SUBROUTINE SUECAESD_06

!**   OPTICAL THICKNESS OF AEROSOLS OF SOIL-DUST ORIGIN
!                                      June

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESD* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSD


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,6:6)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Total Soil Dust Aerosol  month:  6 --- lat:  1  90.0
ZAER (:, 1, 6) = (/&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  2  86.0
ZAER (:, 2, 6) = (/&
&.132E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.133E-02_JPRB,.133E-02_JPRB,.134E-02_JPRB,.134E-02_JPRB,&
&.135E-02_JPRB,.136E-02_JPRB,.137E-02_JPRB,.137E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.137E-02_JPRB,.137E-02_JPRB,.139E-02_JPRB,.141E-02_JPRB,.143E-02_JPRB,.146E-02_JPRB,.149E-02_JPRB,&
&.151E-02_JPRB,.153E-02_JPRB,.156E-02_JPRB,.158E-02_JPRB,.159E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,&
&.158E-02_JPRB,.158E-02_JPRB,.156E-02_JPRB,.153E-02_JPRB,.149E-02_JPRB,.145E-02_JPRB,.141E-02_JPRB,&
&.137E-02_JPRB,.134E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.130E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.132E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,&
&.131E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.129E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.131E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  3  82.0
ZAER (:, 3, 6) = (/&
&.118E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.119E-02_JPRB,.120E-02_JPRB,.122E-02_JPRB,.126E-02_JPRB,&
&.130E-02_JPRB,.135E-02_JPRB,.139E-02_JPRB,.142E-02_JPRB,.146E-02_JPRB,.148E-02_JPRB,.150E-02_JPRB,&
&.153E-02_JPRB,.154E-02_JPRB,.157E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.163E-02_JPRB,.167E-02_JPRB,&
&.173E-02_JPRB,.178E-02_JPRB,.179E-02_JPRB,.177E-02_JPRB,.175E-02_JPRB,.179E-02_JPRB,.189E-02_JPRB,&
&.196E-02_JPRB,.197E-02_JPRB,.202E-02_JPRB,.208E-02_JPRB,.209E-02_JPRB,.202E-02_JPRB,.184E-02_JPRB,&
&.163E-02_JPRB,.147E-02_JPRB,.135E-02_JPRB,.129E-02_JPRB,.127E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,&
&.126E-02_JPRB,.126E-02_JPRB,.126E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.128E-02_JPRB,.129E-02_JPRB,&
&.129E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB,.126E-02_JPRB,.125E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,.124E-02_JPRB,&
&.124E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.123E-02_JPRB,.121E-02_JPRB,&
&.119E-02_JPRB,.119E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  4  78.0
ZAER (:, 4, 6) = (/&
&.111E-02_JPRB,.108E-02_JPRB,.104E-02_JPRB,.101E-02_JPRB,.100E-02_JPRB,.102E-02_JPRB,.106E-02_JPRB,&
&.116E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.144E-02_JPRB,.150E-02_JPRB,.154E-02_JPRB,.160E-02_JPRB,&
&.165E-02_JPRB,.169E-02_JPRB,.174E-02_JPRB,.179E-02_JPRB,.182E-02_JPRB,.188E-02_JPRB,.198E-02_JPRB,&
&.213E-02_JPRB,.227E-02_JPRB,.237E-02_JPRB,.247E-02_JPRB,.249E-02_JPRB,.262E-02_JPRB,.298E-02_JPRB,&
&.326E-02_JPRB,.326E-02_JPRB,.312E-02_JPRB,.289E-02_JPRB,.271E-02_JPRB,.259E-02_JPRB,.243E-02_JPRB,&
&.218E-02_JPRB,.185E-02_JPRB,.148E-02_JPRB,.131E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.130E-02_JPRB,&
&.134E-02_JPRB,.138E-02_JPRB,.140E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.141E-02_JPRB,.139E-02_JPRB,&
&.138E-02_JPRB,.137E-02_JPRB,.136E-02_JPRB,.133E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.127E-02_JPRB,.127E-02_JPRB,.128E-02_JPRB,.127E-02_JPRB,.126E-02_JPRB,.125E-02_JPRB,&
&.125E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.123E-02_JPRB,.122E-02_JPRB,.119E-02_JPRB,.116E-02_JPRB,&
&.114E-02_JPRB,.112E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  5  74.0
ZAER (:, 5, 6) = (/&
&.112E-02_JPRB,.108E-02_JPRB,.101E-02_JPRB,.970E-03_JPRB,.960E-03_JPRB,.962E-03_JPRB,.952E-03_JPRB,&
&.101E-02_JPRB,.113E-02_JPRB,.115E-02_JPRB,.121E-02_JPRB,.132E-02_JPRB,.147E-02_JPRB,.161E-02_JPRB,&
&.167E-02_JPRB,.168E-02_JPRB,.170E-02_JPRB,.177E-02_JPRB,.184E-02_JPRB,.197E-02_JPRB,.220E-02_JPRB,&
&.244E-02_JPRB,.271E-02_JPRB,.305E-02_JPRB,.340E-02_JPRB,.371E-02_JPRB,.417E-02_JPRB,.474E-02_JPRB,&
&.482E-02_JPRB,.458E-02_JPRB,.417E-02_JPRB,.374E-02_JPRB,.332E-02_JPRB,.293E-02_JPRB,.263E-02_JPRB,&
&.247E-02_JPRB,.226E-02_JPRB,.175E-02_JPRB,.135E-02_JPRB,.127E-02_JPRB,.128E-02_JPRB,.131E-02_JPRB,&
&.138E-02_JPRB,.146E-02_JPRB,.154E-02_JPRB,.161E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.160E-02_JPRB,&
&.154E-02_JPRB,.150E-02_JPRB,.152E-02_JPRB,.151E-02_JPRB,.144E-02_JPRB,.137E-02_JPRB,.133E-02_JPRB,&
&.131E-02_JPRB,.132E-02_JPRB,.133E-02_JPRB,.134E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.130E-02_JPRB,&
&.130E-02_JPRB,.130E-02_JPRB,.129E-02_JPRB,.127E-02_JPRB,.125E-02_JPRB,.123E-02_JPRB,.120E-02_JPRB,&
&.117E-02_JPRB,.113E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  6  70.0
ZAER (:, 6, 6) = (/&
&.131E-02_JPRB,.129E-02_JPRB,.123E-02_JPRB,.119E-02_JPRB,.115E-02_JPRB,.110E-02_JPRB,.107E-02_JPRB,&
&.105E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.122E-02_JPRB,.140E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.152E-02_JPRB,.144E-02_JPRB,.147E-02_JPRB,.161E-02_JPRB,.187E-02_JPRB,&
&.220E-02_JPRB,.256E-02_JPRB,.272E-02_JPRB,.285E-02_JPRB,.317E-02_JPRB,.384E-02_JPRB,.490E-02_JPRB,&
&.473E-02_JPRB,.432E-02_JPRB,.411E-02_JPRB,.388E-02_JPRB,.374E-02_JPRB,.344E-02_JPRB,.301E-02_JPRB,&
&.267E-02_JPRB,.235E-02_JPRB,.191E-02_JPRB,.148E-02_JPRB,.128E-02_JPRB,.123E-02_JPRB,.125E-02_JPRB,&
&.132E-02_JPRB,.142E-02_JPRB,.154E-02_JPRB,.165E-02_JPRB,.172E-02_JPRB,.176E-02_JPRB,.172E-02_JPRB,&
&.161E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.158E-02_JPRB,.157E-02_JPRB,.149E-02_JPRB,.141E-02_JPRB,&
&.136E-02_JPRB,.135E-02_JPRB,.137E-02_JPRB,.138E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,&
&.136E-02_JPRB,.134E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.130E-02_JPRB,.130E-02_JPRB,.131E-02_JPRB,&
&.133E-02_JPRB,.132E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  7  66.0
ZAER (:, 7, 6) = (/&
&.161E-02_JPRB,.156E-02_JPRB,.152E-02_JPRB,.144E-02_JPRB,.134E-02_JPRB,.126E-02_JPRB,.124E-02_JPRB,&
&.119E-02_JPRB,.115E-02_JPRB,.119E-02_JPRB,.120E-02_JPRB,.119E-02_JPRB,.118E-02_JPRB,.121E-02_JPRB,&
&.125E-02_JPRB,.127E-02_JPRB,.121E-02_JPRB,.112E-02_JPRB,.114E-02_JPRB,.123E-02_JPRB,.141E-02_JPRB,&
&.162E-02_JPRB,.185E-02_JPRB,.199E-02_JPRB,.221E-02_JPRB,.286E-02_JPRB,.378E-02_JPRB,.534E-02_JPRB,&
&.536E-02_JPRB,.452E-02_JPRB,.418E-02_JPRB,.375E-02_JPRB,.354E-02_JPRB,.353E-02_JPRB,.342E-02_JPRB,&
&.307E-02_JPRB,.257E-02_JPRB,.212E-02_JPRB,.179E-02_JPRB,.151E-02_JPRB,.134E-02_JPRB,.130E-02_JPRB,&
&.132E-02_JPRB,.140E-02_JPRB,.154E-02_JPRB,.166E-02_JPRB,.172E-02_JPRB,.174E-02_JPRB,.174E-02_JPRB,&
&.172E-02_JPRB,.171E-02_JPRB,.165E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,.153E-02_JPRB,.146E-02_JPRB,&
&.140E-02_JPRB,.134E-02_JPRB,.131E-02_JPRB,.129E-02_JPRB,.128E-02_JPRB,.131E-02_JPRB,.135E-02_JPRB,&
&.138E-02_JPRB,.140E-02_JPRB,.139E-02_JPRB,.140E-02_JPRB,.146E-02_JPRB,.155E-02_JPRB,.162E-02_JPRB,&
&.167E-02_JPRB,.165E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  8  62.0
ZAER (:, 8, 6) = (/&
&.368E-02_JPRB,.329E-02_JPRB,.291E-02_JPRB,.254E-02_JPRB,.226E-02_JPRB,.204E-02_JPRB,.192E-02_JPRB,&
&.185E-02_JPRB,.182E-02_JPRB,.184E-02_JPRB,.178E-02_JPRB,.163E-02_JPRB,.145E-02_JPRB,.132E-02_JPRB,&
&.121E-02_JPRB,.115E-02_JPRB,.112E-02_JPRB,.110E-02_JPRB,.109E-02_JPRB,.111E-02_JPRB,.117E-02_JPRB,&
&.125E-02_JPRB,.145E-02_JPRB,.170E-02_JPRB,.226E-02_JPRB,.334E-02_JPRB,.377E-02_JPRB,.546E-02_JPRB,&
&.645E-02_JPRB,.567E-02_JPRB,.505E-02_JPRB,.471E-02_JPRB,.443E-02_JPRB,.404E-02_JPRB,.379E-02_JPRB,&
&.350E-02_JPRB,.295E-02_JPRB,.240E-02_JPRB,.211E-02_JPRB,.195E-02_JPRB,.171E-02_JPRB,.152E-02_JPRB,&
&.141E-02_JPRB,.147E-02_JPRB,.158E-02_JPRB,.167E-02_JPRB,.175E-02_JPRB,.179E-02_JPRB,.183E-02_JPRB,&
&.189E-02_JPRB,.195E-02_JPRB,.191E-02_JPRB,.177E-02_JPRB,.168E-02_JPRB,.159E-02_JPRB,.150E-02_JPRB,&
&.143E-02_JPRB,.136E-02_JPRB,.128E-02_JPRB,.120E-02_JPRB,.117E-02_JPRB,.119E-02_JPRB,.124E-02_JPRB,&
&.141E-02_JPRB,.167E-02_JPRB,.177E-02_JPRB,.190E-02_JPRB,.238E-02_JPRB,.320E-02_JPRB,.388E-02_JPRB,&
&.420E-02_JPRB,.406E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat:  9  58.0
ZAER (:, 9, 6) = (/&
&.648E-02_JPRB,.506E-02_JPRB,.402E-02_JPRB,.368E-02_JPRB,.373E-02_JPRB,.369E-02_JPRB,.351E-02_JPRB,&
&.317E-02_JPRB,.280E-02_JPRB,.252E-02_JPRB,.232E-02_JPRB,.223E-02_JPRB,.212E-02_JPRB,.189E-02_JPRB,&
&.164E-02_JPRB,.146E-02_JPRB,.135E-02_JPRB,.128E-02_JPRB,.122E-02_JPRB,.119E-02_JPRB,.118E-02_JPRB,&
&.118E-02_JPRB,.133E-02_JPRB,.173E-02_JPRB,.306E-02_JPRB,.417E-02_JPRB,.448E-02_JPRB,.655E-02_JPRB,&
&.896E-02_JPRB,.837E-02_JPRB,.687E-02_JPRB,.611E-02_JPRB,.565E-02_JPRB,.502E-02_JPRB,.468E-02_JPRB,&
&.431E-02_JPRB,.376E-02_JPRB,.308E-02_JPRB,.257E-02_JPRB,.229E-02_JPRB,.213E-02_JPRB,.193E-02_JPRB,&
&.180E-02_JPRB,.178E-02_JPRB,.182E-02_JPRB,.184E-02_JPRB,.191E-02_JPRB,.195E-02_JPRB,.200E-02_JPRB,&
&.209E-02_JPRB,.215E-02_JPRB,.216E-02_JPRB,.209E-02_JPRB,.199E-02_JPRB,.188E-02_JPRB,.173E-02_JPRB,&
&.160E-02_JPRB,.149E-02_JPRB,.138E-02_JPRB,.131E-02_JPRB,.132E-02_JPRB,.129E-02_JPRB,.129E-02_JPRB,&
&.151E-02_JPRB,.214E-02_JPRB,.286E-02_JPRB,.462E-02_JPRB,.693E-02_JPRB,.858E-02_JPRB,.917E-02_JPRB,&
&.879E-02_JPRB,.781E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 10  54.0
ZAER (:,10, 6) = (/&
&.784E-02_JPRB,.637E-02_JPRB,.520E-02_JPRB,.484E-02_JPRB,.509E-02_JPRB,.545E-02_JPRB,.511E-02_JPRB,&
&.404E-02_JPRB,.294E-02_JPRB,.223E-02_JPRB,.195E-02_JPRB,.196E-02_JPRB,.218E-02_JPRB,.238E-02_JPRB,&
&.234E-02_JPRB,.207E-02_JPRB,.179E-02_JPRB,.158E-02_JPRB,.144E-02_JPRB,.135E-02_JPRB,.131E-02_JPRB,&
&.132E-02_JPRB,.165E-02_JPRB,.277E-02_JPRB,.559E-02_JPRB,.678E-02_JPRB,.861E-02_JPRB,.121E-01_JPRB,&
&.137E-01_JPRB,.121E-01_JPRB,.894E-02_JPRB,.786E-02_JPRB,.703E-02_JPRB,.625E-02_JPRB,.573E-02_JPRB,&
&.538E-02_JPRB,.481E-02_JPRB,.403E-02_JPRB,.331E-02_JPRB,.287E-02_JPRB,.260E-02_JPRB,.244E-02_JPRB,&
&.234E-02_JPRB,.225E-02_JPRB,.220E-02_JPRB,.231E-02_JPRB,.241E-02_JPRB,.240E-02_JPRB,.237E-02_JPRB,&
&.230E-02_JPRB,.222E-02_JPRB,.220E-02_JPRB,.225E-02_JPRB,.225E-02_JPRB,.214E-02_JPRB,.196E-02_JPRB,&
&.180E-02_JPRB,.165E-02_JPRB,.151E-02_JPRB,.142E-02_JPRB,.154E-02_JPRB,.164E-02_JPRB,.205E-02_JPRB,&
&.255E-02_JPRB,.333E-02_JPRB,.741E-02_JPRB,.102E-01_JPRB,.111E-01_JPRB,.105E-01_JPRB,.941E-02_JPRB,&
&.861E-02_JPRB,.831E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 11  50.0
ZAER (:,11, 6) = (/&
&.911E-02_JPRB,.784E-02_JPRB,.681E-02_JPRB,.673E-02_JPRB,.695E-02_JPRB,.662E-02_JPRB,.562E-02_JPRB,&
&.424E-02_JPRB,.307E-02_JPRB,.254E-02_JPRB,.214E-02_JPRB,.189E-02_JPRB,.193E-02_JPRB,.218E-02_JPRB,&
&.241E-02_JPRB,.245E-02_JPRB,.227E-02_JPRB,.201E-02_JPRB,.182E-02_JPRB,.170E-02_JPRB,.165E-02_JPRB,&
&.169E-02_JPRB,.341E-02_JPRB,.107E-01_JPRB,.196E-01_JPRB,.207E-01_JPRB,.217E-01_JPRB,.207E-01_JPRB,&
&.183E-01_JPRB,.151E-01_JPRB,.125E-01_JPRB,.100E-01_JPRB,.839E-02_JPRB,.740E-02_JPRB,.659E-02_JPRB,&
&.603E-02_JPRB,.552E-02_JPRB,.490E-02_JPRB,.417E-02_JPRB,.355E-02_JPRB,.320E-02_JPRB,.311E-02_JPRB,&
&.298E-02_JPRB,.285E-02_JPRB,.287E-02_JPRB,.300E-02_JPRB,.303E-02_JPRB,.294E-02_JPRB,.281E-02_JPRB,&
&.254E-02_JPRB,.240E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.227E-02_JPRB,.217E-02_JPRB,.207E-02_JPRB,&
&.198E-02_JPRB,.185E-02_JPRB,.170E-02_JPRB,.159E-02_JPRB,.169E-02_JPRB,.235E-02_JPRB,.327E-02_JPRB,&
&.381E-02_JPRB,.760E-02_JPRB,.116E-01_JPRB,.118E-01_JPRB,.993E-02_JPRB,.823E-02_JPRB,.843E-02_JPRB,&
&.915E-02_JPRB,.937E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 12  46.0
ZAER (:,12, 6) = (/&
&.994E-02_JPRB,.847E-02_JPRB,.782E-02_JPRB,.782E-02_JPRB,.705E-02_JPRB,.590E-02_JPRB,.514E-02_JPRB,&
&.406E-02_JPRB,.310E-02_JPRB,.248E-02_JPRB,.217E-02_JPRB,.208E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,&
&.215E-02_JPRB,.237E-02_JPRB,.249E-02_JPRB,.241E-02_JPRB,.225E-02_JPRB,.210E-02_JPRB,.202E-02_JPRB,&
&.205E-02_JPRB,.406E-02_JPRB,.396E-01_JPRB,.657E-01_JPRB,.459E-01_JPRB,.297E-01_JPRB,.204E-01_JPRB,&
&.158E-01_JPRB,.128E-01_JPRB,.117E-01_JPRB,.107E-01_JPRB,.919E-02_JPRB,.773E-02_JPRB,.691E-02_JPRB,&
&.617E-02_JPRB,.541E-02_JPRB,.485E-02_JPRB,.449E-02_JPRB,.423E-02_JPRB,.414E-02_JPRB,.396E-02_JPRB,&
&.374E-02_JPRB,.367E-02_JPRB,.375E-02_JPRB,.380E-02_JPRB,.375E-02_JPRB,.358E-02_JPRB,.329E-02_JPRB,&
&.287E-02_JPRB,.261E-02_JPRB,.251E-02_JPRB,.248E-02_JPRB,.231E-02_JPRB,.222E-02_JPRB,.215E-02_JPRB,&
&.208E-02_JPRB,.197E-02_JPRB,.185E-02_JPRB,.175E-02_JPRB,.188E-02_JPRB,.274E-02_JPRB,.395E-02_JPRB,&
&.813E-02_JPRB,.142E-01_JPRB,.147E-01_JPRB,.122E-01_JPRB,.906E-02_JPRB,.914E-02_JPRB,.110E-01_JPRB,&
&.114E-01_JPRB,.108E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 13  42.0
ZAER (:,13, 6) = (/&
&.100E-01_JPRB,.819E-02_JPRB,.757E-02_JPRB,.755E-02_JPRB,.608E-02_JPRB,.572E-02_JPRB,.480E-02_JPRB,&
&.378E-02_JPRB,.283E-02_JPRB,.236E-02_JPRB,.225E-02_JPRB,.217E-02_JPRB,.206E-02_JPRB,.205E-02_JPRB,&
&.216E-02_JPRB,.224E-02_JPRB,.236E-02_JPRB,.241E-02_JPRB,.237E-02_JPRB,.228E-02_JPRB,.217E-02_JPRB,&
&.212E-02_JPRB,.316E-02_JPRB,.628E-01_JPRB,.902E-01_JPRB,.522E-01_JPRB,.285E-01_JPRB,.166E-01_JPRB,&
&.126E-01_JPRB,.120E-01_JPRB,.111E-01_JPRB,.937E-02_JPRB,.850E-02_JPRB,.752E-02_JPRB,.661E-02_JPRB,&
&.586E-02_JPRB,.507E-02_JPRB,.466E-02_JPRB,.453E-02_JPRB,.465E-02_JPRB,.494E-02_JPRB,.484E-02_JPRB,&
&.483E-02_JPRB,.491E-02_JPRB,.486E-02_JPRB,.466E-02_JPRB,.444E-02_JPRB,.411E-02_JPRB,.368E-02_JPRB,&
&.321E-02_JPRB,.289E-02_JPRB,.279E-02_JPRB,.271E-02_JPRB,.255E-02_JPRB,.247E-02_JPRB,.234E-02_JPRB,&
&.224E-02_JPRB,.211E-02_JPRB,.199E-02_JPRB,.190E-02_JPRB,.224E-02_JPRB,.348E-02_JPRB,.735E-02_JPRB,&
&.172E-01_JPRB,.229E-01_JPRB,.207E-01_JPRB,.149E-01_JPRB,.109E-01_JPRB,.125E-01_JPRB,.135E-01_JPRB,&
&.130E-01_JPRB,.119E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 14  38.0
ZAER (:,14, 6) = (/&
&.849E-02_JPRB,.691E-02_JPRB,.587E-02_JPRB,.567E-02_JPRB,.575E-02_JPRB,.591E-02_JPRB,.504E-02_JPRB,&
&.393E-02_JPRB,.314E-02_JPRB,.278E-02_JPRB,.267E-02_JPRB,.251E-02_JPRB,.235E-02_JPRB,.228E-02_JPRB,&
&.229E-02_JPRB,.229E-02_JPRB,.231E-02_JPRB,.229E-02_JPRB,.226E-02_JPRB,.218E-02_JPRB,.205E-02_JPRB,&
&.198E-02_JPRB,.348E-02_JPRB,.280E-01_JPRB,.410E-01_JPRB,.354E-01_JPRB,.280E-01_JPRB,.205E-01_JPRB,&
&.149E-01_JPRB,.129E-01_JPRB,.112E-01_JPRB,.100E-01_JPRB,.888E-02_JPRB,.720E-02_JPRB,.587E-02_JPRB,&
&.534E-02_JPRB,.487E-02_JPRB,.462E-02_JPRB,.458E-02_JPRB,.497E-02_JPRB,.564E-02_JPRB,.594E-02_JPRB,&
&.644E-02_JPRB,.664E-02_JPRB,.630E-02_JPRB,.576E-02_JPRB,.527E-02_JPRB,.473E-02_JPRB,.421E-02_JPRB,&
&.372E-02_JPRB,.340E-02_JPRB,.321E-02_JPRB,.311E-02_JPRB,.292E-02_JPRB,.282E-02_JPRB,.262E-02_JPRB,&
&.243E-02_JPRB,.229E-02_JPRB,.222E-02_JPRB,.218E-02_JPRB,.307E-02_JPRB,.713E-02_JPRB,.228E-01_JPRB,&
&.359E-01_JPRB,.428E-01_JPRB,.319E-01_JPRB,.202E-01_JPRB,.142E-01_JPRB,.136E-01_JPRB,.136E-01_JPRB,&
&.121E-01_JPRB,.102E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 15  34.0
ZAER (:,15, 6) = (/&
&.736E-02_JPRB,.653E-02_JPRB,.595E-02_JPRB,.560E-02_JPRB,.557E-02_JPRB,.571E-02_JPRB,.527E-02_JPRB,&
&.442E-02_JPRB,.374E-02_JPRB,.340E-02_JPRB,.316E-02_JPRB,.289E-02_JPRB,.269E-02_JPRB,.249E-02_JPRB,&
&.241E-02_JPRB,.243E-02_JPRB,.236E-02_JPRB,.227E-02_JPRB,.219E-02_JPRB,.213E-02_JPRB,.210E-02_JPRB,&
&.268E-02_JPRB,.508E-02_JPRB,.114E-01_JPRB,.140E-01_JPRB,.156E-01_JPRB,.186E-01_JPRB,.193E-01_JPRB,&
&.165E-01_JPRB,.142E-01_JPRB,.127E-01_JPRB,.114E-01_JPRB,.921E-02_JPRB,.694E-02_JPRB,.575E-02_JPRB,&
&.518E-02_JPRB,.482E-02_JPRB,.466E-02_JPRB,.492E-02_JPRB,.631E-02_JPRB,.947E-02_JPRB,.136E-01_JPRB,&
&.129E-01_JPRB,.109E-01_JPRB,.919E-02_JPRB,.784E-02_JPRB,.664E-02_JPRB,.546E-02_JPRB,.499E-02_JPRB,&
&.468E-02_JPRB,.440E-02_JPRB,.431E-02_JPRB,.417E-02_JPRB,.375E-02_JPRB,.341E-02_JPRB,.305E-02_JPRB,&
&.276E-02_JPRB,.269E-02_JPRB,.277E-02_JPRB,.294E-02_JPRB,.653E-02_JPRB,.239E-01_JPRB,.740E-01_JPRB,&
&.829E-01_JPRB,.762E-01_JPRB,.393E-01_JPRB,.226E-01_JPRB,.145E-01_JPRB,.117E-01_JPRB,.111E-01_JPRB,&
&.103E-01_JPRB,.878E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 16  30.0
ZAER (:,16, 6) = (/&
&.877E-02_JPRB,.781E-02_JPRB,.663E-02_JPRB,.583E-02_JPRB,.561E-02_JPRB,.556E-02_JPRB,.539E-02_JPRB,&
&.489E-02_JPRB,.427E-02_JPRB,.391E-02_JPRB,.349E-02_JPRB,.324E-02_JPRB,.308E-02_JPRB,.276E-02_JPRB,&
&.256E-02_JPRB,.259E-02_JPRB,.251E-02_JPRB,.236E-02_JPRB,.234E-02_JPRB,.264E-02_JPRB,.321E-02_JPRB,&
&.435E-02_JPRB,.633E-02_JPRB,.919E-02_JPRB,.821E-02_JPRB,.787E-02_JPRB,.938E-02_JPRB,.115E-01_JPRB,&
&.129E-01_JPRB,.126E-01_JPRB,.115E-01_JPRB,.993E-02_JPRB,.808E-02_JPRB,.657E-02_JPRB,.567E-02_JPRB,&
&.532E-02_JPRB,.527E-02_JPRB,.526E-02_JPRB,.688E-02_JPRB,.137E-01_JPRB,.300E-01_JPRB,.323E-01_JPRB,&
&.244E-01_JPRB,.167E-01_JPRB,.121E-01_JPRB,.961E-02_JPRB,.803E-02_JPRB,.675E-02_JPRB,.622E-02_JPRB,&
&.592E-02_JPRB,.575E-02_JPRB,.569E-02_JPRB,.556E-02_JPRB,.520E-02_JPRB,.460E-02_JPRB,.407E-02_JPRB,&
&.372E-02_JPRB,.413E-02_JPRB,.478E-02_JPRB,.700E-02_JPRB,.142E-01_JPRB,.367E-01_JPRB,.124E+00_JPRB,&
&.120E+00_JPRB,.898E-01_JPRB,.374E-01_JPRB,.191E-01_JPRB,.138E-01_JPRB,.113E-01_JPRB,.105E-01_JPRB,&
&.103E-01_JPRB,.953E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 17  26.0
ZAER (:,17, 6) = (/&
&.906E-02_JPRB,.724E-02_JPRB,.611E-02_JPRB,.568E-02_JPRB,.549E-02_JPRB,.539E-02_JPRB,.537E-02_JPRB,&
&.516E-02_JPRB,.473E-02_JPRB,.432E-02_JPRB,.389E-02_JPRB,.363E-02_JPRB,.330E-02_JPRB,.289E-02_JPRB,&
&.267E-02_JPRB,.261E-02_JPRB,.258E-02_JPRB,.252E-02_JPRB,.262E-02_JPRB,.320E-02_JPRB,.401E-02_JPRB,&
&.404E-02_JPRB,.486E-02_JPRB,.897E-02_JPRB,.874E-02_JPRB,.726E-02_JPRB,.635E-02_JPRB,.678E-02_JPRB,&
&.796E-02_JPRB,.830E-02_JPRB,.802E-02_JPRB,.704E-02_JPRB,.635E-02_JPRB,.596E-02_JPRB,.555E-02_JPRB,&
&.560E-02_JPRB,.628E-02_JPRB,.805E-02_JPRB,.144E-01_JPRB,.281E-01_JPRB,.503E-01_JPRB,.601E-01_JPRB,&
&.344E-01_JPRB,.185E-01_JPRB,.127E-01_JPRB,.112E-01_JPRB,.976E-02_JPRB,.866E-02_JPRB,.823E-02_JPRB,&
&.813E-02_JPRB,.794E-02_JPRB,.743E-02_JPRB,.706E-02_JPRB,.670E-02_JPRB,.615E-02_JPRB,.561E-02_JPRB,&
&.537E-02_JPRB,.676E-02_JPRB,.125E-01_JPRB,.228E-01_JPRB,.281E-01_JPRB,.405E-01_JPRB,.614E-01_JPRB,&
&.560E-01_JPRB,.471E-01_JPRB,.289E-01_JPRB,.179E-01_JPRB,.142E-01_JPRB,.124E-01_JPRB,.120E-01_JPRB,&
&.119E-01_JPRB,.110E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 18  22.0
ZAER (:,18, 6) = (/&
&.658E-02_JPRB,.571E-02_JPRB,.529E-02_JPRB,.498E-02_JPRB,.477E-02_JPRB,.472E-02_JPRB,.466E-02_JPRB,&
&.465E-02_JPRB,.449E-02_JPRB,.417E-02_JPRB,.380E-02_JPRB,.346E-02_JPRB,.300E-02_JPRB,.274E-02_JPRB,&
&.267E-02_JPRB,.266E-02_JPRB,.264E-02_JPRB,.262E-02_JPRB,.275E-02_JPRB,.314E-02_JPRB,.352E-02_JPRB,&
&.340E-02_JPRB,.383E-02_JPRB,.818E-02_JPRB,.134E-01_JPRB,.638E-02_JPRB,.467E-02_JPRB,.487E-02_JPRB,&
&.518E-02_JPRB,.546E-02_JPRB,.513E-02_JPRB,.494E-02_JPRB,.538E-02_JPRB,.583E-02_JPRB,.628E-02_JPRB,&
&.723E-02_JPRB,.947E-02_JPRB,.141E-01_JPRB,.218E-01_JPRB,.331E-01_JPRB,.500E-01_JPRB,.544E-01_JPRB,&
&.305E-01_JPRB,.209E-01_JPRB,.162E-01_JPRB,.159E-01_JPRB,.129E-01_JPRB,.116E-01_JPRB,.110E-01_JPRB,&
&.103E-01_JPRB,.955E-02_JPRB,.893E-02_JPRB,.848E-02_JPRB,.787E-02_JPRB,.746E-02_JPRB,.762E-02_JPRB,&
&.907E-02_JPRB,.131E-01_JPRB,.224E-01_JPRB,.329E-01_JPRB,.341E-01_JPRB,.286E-01_JPRB,.273E-01_JPRB,&
&.271E-01_JPRB,.265E-01_JPRB,.217E-01_JPRB,.164E-01_JPRB,.139E-01_JPRB,.124E-01_JPRB,.115E-01_JPRB,&
&.103E-01_JPRB,.837E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 19  18.0
ZAER (:,19, 6) = (/&
&.513E-02_JPRB,.480E-02_JPRB,.471E-02_JPRB,.433E-02_JPRB,.389E-02_JPRB,.366E-02_JPRB,.351E-02_JPRB,&
&.347E-02_JPRB,.333E-02_JPRB,.312E-02_JPRB,.290E-02_JPRB,.264E-02_JPRB,.248E-02_JPRB,.240E-02_JPRB,&
&.245E-02_JPRB,.256E-02_JPRB,.262E-02_JPRB,.265E-02_JPRB,.277E-02_JPRB,.296E-02_JPRB,.313E-02_JPRB,&
&.349E-02_JPRB,.465E-02_JPRB,.859E-02_JPRB,.114E-01_JPRB,.446E-02_JPRB,.401E-02_JPRB,.417E-02_JPRB,&
&.416E-02_JPRB,.406E-02_JPRB,.443E-02_JPRB,.524E-02_JPRB,.647E-02_JPRB,.764E-02_JPRB,.887E-02_JPRB,&
&.110E-01_JPRB,.144E-01_JPRB,.193E-01_JPRB,.238E-01_JPRB,.258E-01_JPRB,.285E-01_JPRB,.274E-01_JPRB,&
&.241E-01_JPRB,.217E-01_JPRB,.199E-01_JPRB,.193E-01_JPRB,.150E-01_JPRB,.128E-01_JPRB,.114E-01_JPRB,&
&.102E-01_JPRB,.931E-02_JPRB,.889E-02_JPRB,.879E-02_JPRB,.882E-02_JPRB,.918E-02_JPRB,.102E-01_JPRB,&
&.122E-01_JPRB,.143E-01_JPRB,.168E-01_JPRB,.209E-01_JPRB,.218E-01_JPRB,.188E-01_JPRB,.188E-01_JPRB,&
&.184E-01_JPRB,.166E-01_JPRB,.147E-01_JPRB,.130E-01_JPRB,.113E-01_JPRB,.977E-02_JPRB,.845E-02_JPRB,&
&.716E-02_JPRB,.599E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 20  14.0
ZAER (:,20, 6) = (/&
&.357E-02_JPRB,.354E-02_JPRB,.368E-02_JPRB,.337E-02_JPRB,.300E-02_JPRB,.269E-02_JPRB,.247E-02_JPRB,&
&.237E-02_JPRB,.229E-02_JPRB,.227E-02_JPRB,.221E-02_JPRB,.216E-02_JPRB,.219E-02_JPRB,.223E-02_JPRB,&
&.232E-02_JPRB,.243E-02_JPRB,.258E-02_JPRB,.272E-02_JPRB,.288E-02_JPRB,.309E-02_JPRB,.341E-02_JPRB,&
&.410E-02_JPRB,.627E-02_JPRB,.720E-02_JPRB,.538E-02_JPRB,.401E-02_JPRB,.406E-02_JPRB,.404E-02_JPRB,&
&.410E-02_JPRB,.496E-02_JPRB,.643E-02_JPRB,.830E-02_JPRB,.101E-01_JPRB,.117E-01_JPRB,.128E-01_JPRB,&
&.148E-01_JPRB,.190E-01_JPRB,.231E-01_JPRB,.245E-01_JPRB,.227E-01_JPRB,.221E-01_JPRB,.226E-01_JPRB,&
&.237E-01_JPRB,.232E-01_JPRB,.207E-01_JPRB,.164E-01_JPRB,.120E-01_JPRB,.102E-01_JPRB,.889E-02_JPRB,&
&.799E-02_JPRB,.753E-02_JPRB,.753E-02_JPRB,.794E-02_JPRB,.836E-02_JPRB,.868E-02_JPRB,.918E-02_JPRB,&
&.963E-02_JPRB,.976E-02_JPRB,.106E-01_JPRB,.113E-01_JPRB,.115E-01_JPRB,.117E-01_JPRB,.118E-01_JPRB,&
&.113E-01_JPRB,.997E-02_JPRB,.892E-02_JPRB,.818E-02_JPRB,.711E-02_JPRB,.598E-02_JPRB,.519E-02_JPRB,&
&.466E-02_JPRB,.407E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 21  10.0
ZAER (:,21, 6) = (/&
&.202E-02_JPRB,.217E-02_JPRB,.228E-02_JPRB,.223E-02_JPRB,.213E-02_JPRB,.199E-02_JPRB,.191E-02_JPRB,&
&.191E-02_JPRB,.192E-02_JPRB,.197E-02_JPRB,.206E-02_JPRB,.217E-02_JPRB,.231E-02_JPRB,.238E-02_JPRB,&
&.246E-02_JPRB,.262E-02_JPRB,.285E-02_JPRB,.305E-02_JPRB,.326E-02_JPRB,.367E-02_JPRB,.432E-02_JPRB,&
&.533E-02_JPRB,.588E-02_JPRB,.521E-02_JPRB,.436E-02_JPRB,.480E-02_JPRB,.536E-02_JPRB,.579E-02_JPRB,&
&.645E-02_JPRB,.851E-02_JPRB,.110E-01_JPRB,.132E-01_JPRB,.151E-01_JPRB,.166E-01_JPRB,.173E-01_JPRB,&
&.200E-01_JPRB,.256E-01_JPRB,.278E-01_JPRB,.255E-01_JPRB,.222E-01_JPRB,.217E-01_JPRB,.241E-01_JPRB,&
&.264E-01_JPRB,.233E-01_JPRB,.163E-01_JPRB,.963E-02_JPRB,.727E-02_JPRB,.622E-02_JPRB,.549E-02_JPRB,&
&.516E-02_JPRB,.505E-02_JPRB,.531E-02_JPRB,.564E-02_JPRB,.560E-02_JPRB,.548E-02_JPRB,.556E-02_JPRB,&
&.567E-02_JPRB,.608E-02_JPRB,.666E-02_JPRB,.711E-02_JPRB,.716E-02_JPRB,.635E-02_JPRB,.548E-02_JPRB,&
&.532E-02_JPRB,.499E-02_JPRB,.470E-02_JPRB,.423E-02_JPRB,.378E-02_JPRB,.334E-02_JPRB,.305E-02_JPRB,&
&.264E-02_JPRB,.221E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 22   6.0
ZAER (:,22, 6) = (/&
&.151E-02_JPRB,.162E-02_JPRB,.168E-02_JPRB,.172E-02_JPRB,.177E-02_JPRB,.179E-02_JPRB,.182E-02_JPRB,&
&.186E-02_JPRB,.193E-02_JPRB,.206E-02_JPRB,.223E-02_JPRB,.239E-02_JPRB,.254E-02_JPRB,.264E-02_JPRB,&
&.277E-02_JPRB,.294E-02_JPRB,.321E-02_JPRB,.352E-02_JPRB,.393E-02_JPRB,.451E-02_JPRB,.466E-02_JPRB,&
&.466E-02_JPRB,.459E-02_JPRB,.467E-02_JPRB,.549E-02_JPRB,.660E-02_JPRB,.789E-02_JPRB,.943E-02_JPRB,&
&.112E-01_JPRB,.135E-01_JPRB,.159E-01_JPRB,.180E-01_JPRB,.204E-01_JPRB,.224E-01_JPRB,.249E-01_JPRB,&
&.285E-01_JPRB,.329E-01_JPRB,.340E-01_JPRB,.328E-01_JPRB,.301E-01_JPRB,.279E-01_JPRB,.281E-01_JPRB,&
&.294E-01_JPRB,.236E-01_JPRB,.132E-01_JPRB,.527E-02_JPRB,.405E-02_JPRB,.375E-02_JPRB,.354E-02_JPRB,&
&.323E-02_JPRB,.295E-02_JPRB,.283E-02_JPRB,.262E-02_JPRB,.243E-02_JPRB,.238E-02_JPRB,.257E-02_JPRB,&
&.280E-02_JPRB,.294E-02_JPRB,.295E-02_JPRB,.286E-02_JPRB,.268E-02_JPRB,.228E-02_JPRB,.198E-02_JPRB,&
&.195E-02_JPRB,.193E-02_JPRB,.186E-02_JPRB,.178E-02_JPRB,.170E-02_JPRB,.160E-02_JPRB,.159E-02_JPRB,&
&.151E-02_JPRB,.145E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 23   2.0
ZAER (:,23, 6) = (/&
&.135E-02_JPRB,.143E-02_JPRB,.151E-02_JPRB,.162E-02_JPRB,.172E-02_JPRB,.178E-02_JPRB,.186E-02_JPRB,&
&.195E-02_JPRB,.208E-02_JPRB,.221E-02_JPRB,.233E-02_JPRB,.243E-02_JPRB,.254E-02_JPRB,.265E-02_JPRB,&
&.279E-02_JPRB,.299E-02_JPRB,.331E-02_JPRB,.370E-02_JPRB,.408E-02_JPRB,.456E-02_JPRB,.484E-02_JPRB,&
&.496E-02_JPRB,.556E-02_JPRB,.653E-02_JPRB,.796E-02_JPRB,.949E-02_JPRB,.111E-01_JPRB,.128E-01_JPRB,&
&.144E-01_JPRB,.162E-01_JPRB,.181E-01_JPRB,.204E-01_JPRB,.234E-01_JPRB,.264E-01_JPRB,.298E-01_JPRB,&
&.345E-01_JPRB,.396E-01_JPRB,.446E-01_JPRB,.495E-01_JPRB,.516E-01_JPRB,.528E-01_JPRB,.547E-01_JPRB,&
&.554E-01_JPRB,.502E-01_JPRB,.339E-01_JPRB,.119E-01_JPRB,.508E-02_JPRB,.403E-02_JPRB,.342E-02_JPRB,&
&.306E-02_JPRB,.267E-02_JPRB,.225E-02_JPRB,.179E-02_JPRB,.131E-02_JPRB,.111E-02_JPRB,.114E-02_JPRB,&
&.118E-02_JPRB,.112E-02_JPRB,.104E-02_JPRB,.986E-03_JPRB,.919E-03_JPRB,.809E-03_JPRB,.793E-03_JPRB,&
&.833E-03_JPRB,.876E-03_JPRB,.889E-03_JPRB,.908E-03_JPRB,.941E-03_JPRB,.986E-03_JPRB,.107E-02_JPRB,&
&.116E-02_JPRB,.125E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 24  -2.0
ZAER (:,24, 6) = (/&
&.138E-02_JPRB,.145E-02_JPRB,.156E-02_JPRB,.171E-02_JPRB,.186E-02_JPRB,.203E-02_JPRB,.214E-02_JPRB,&
&.222E-02_JPRB,.232E-02_JPRB,.242E-02_JPRB,.250E-02_JPRB,.249E-02_JPRB,.248E-02_JPRB,.255E-02_JPRB,&
&.265E-02_JPRB,.283E-02_JPRB,.313E-02_JPRB,.351E-02_JPRB,.387E-02_JPRB,.450E-02_JPRB,.532E-02_JPRB,&
&.607E-02_JPRB,.688E-02_JPRB,.814E-02_JPRB,.969E-02_JPRB,.117E-01_JPRB,.137E-01_JPRB,.147E-01_JPRB,&
&.151E-01_JPRB,.153E-01_JPRB,.156E-01_JPRB,.165E-01_JPRB,.188E-01_JPRB,.236E-01_JPRB,.289E-01_JPRB,&
&.356E-01_JPRB,.418E-01_JPRB,.506E-01_JPRB,.658E-01_JPRB,.786E-01_JPRB,.899E-01_JPRB,.110E+00_JPRB,&
&.130E+00_JPRB,.146E+00_JPRB,.144E+00_JPRB,.113E+00_JPRB,.501E-01_JPRB,.168E-01_JPRB,.747E-02_JPRB,&
&.499E-02_JPRB,.498E-02_JPRB,.459E-02_JPRB,.349E-02_JPRB,.218E-02_JPRB,.117E-02_JPRB,.812E-03_JPRB,&
&.683E-03_JPRB,.578E-03_JPRB,.516E-03_JPRB,.462E-03_JPRB,.406E-03_JPRB,.376E-03_JPRB,.385E-03_JPRB,&
&.427E-03_JPRB,.471E-03_JPRB,.535E-03_JPRB,.623E-03_JPRB,.723E-03_JPRB,.842E-03_JPRB,.972E-03_JPRB,&
&.111E-02_JPRB,.124E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 25  -6.0
ZAER (:,25, 6) = (/&
&.222E-02_JPRB,.239E-02_JPRB,.261E-02_JPRB,.291E-02_JPRB,.323E-02_JPRB,.367E-02_JPRB,.401E-02_JPRB,&
&.410E-02_JPRB,.409E-02_JPRB,.411E-02_JPRB,.412E-02_JPRB,.387E-02_JPRB,.348E-02_JPRB,.323E-02_JPRB,&
&.322E-02_JPRB,.334E-02_JPRB,.352E-02_JPRB,.393E-02_JPRB,.460E-02_JPRB,.559E-02_JPRB,.725E-02_JPRB,&
&.972E-02_JPRB,.115E-01_JPRB,.132E-01_JPRB,.161E-01_JPRB,.204E-01_JPRB,.238E-01_JPRB,.264E-01_JPRB,&
&.286E-01_JPRB,.284E-01_JPRB,.277E-01_JPRB,.272E-01_JPRB,.266E-01_JPRB,.313E-01_JPRB,.370E-01_JPRB,&
&.448E-01_JPRB,.533E-01_JPRB,.683E-01_JPRB,.923E-01_JPRB,.116E+00_JPRB,.139E+00_JPRB,.178E+00_JPRB,&
&.245E+00_JPRB,.338E+00_JPRB,.469E+00_JPRB,.602E+00_JPRB,.623E+00_JPRB,.172E+00_JPRB,.424E-01_JPRB,&
&.173E-01_JPRB,.149E-01_JPRB,.160E-01_JPRB,.144E-01_JPRB,.957E-02_JPRB,.447E-02_JPRB,.190E-02_JPRB,&
&.147E-02_JPRB,.140E-02_JPRB,.927E-03_JPRB,.752E-03_JPRB,.673E-03_JPRB,.619E-03_JPRB,.510E-03_JPRB,&
&.494E-03_JPRB,.520E-03_JPRB,.632E-03_JPRB,.801E-03_JPRB,.100E-02_JPRB,.123E-02_JPRB,.149E-02_JPRB,&
&.176E-02_JPRB,.201E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 26 -10.0
ZAER (:,26, 6) = (/&
&.435E-02_JPRB,.467E-02_JPRB,.518E-02_JPRB,.580E-02_JPRB,.647E-02_JPRB,.733E-02_JPRB,.814E-02_JPRB,&
&.875E-02_JPRB,.910E-02_JPRB,.906E-02_JPRB,.889E-02_JPRB,.854E-02_JPRB,.744E-02_JPRB,.628E-02_JPRB,&
&.559E-02_JPRB,.554E-02_JPRB,.509E-02_JPRB,.510E-02_JPRB,.593E-02_JPRB,.799E-02_JPRB,.111E-01_JPRB,&
&.157E-01_JPRB,.206E-01_JPRB,.236E-01_JPRB,.279E-01_JPRB,.350E-01_JPRB,.418E-01_JPRB,.468E-01_JPRB,&
&.504E-01_JPRB,.526E-01_JPRB,.563E-01_JPRB,.599E-01_JPRB,.607E-01_JPRB,.672E-01_JPRB,.695E-01_JPRB,&
&.751E-01_JPRB,.854E-01_JPRB,.105E+00_JPRB,.126E+00_JPRB,.145E+00_JPRB,.172E+00_JPRB,.211E+00_JPRB,&
&.278E+00_JPRB,.394E+00_JPRB,.629E+00_JPRB,.104E+01_JPRB,.138E+01_JPRB,.564E+00_JPRB,.122E+00_JPRB,&
&.492E-01_JPRB,.443E-01_JPRB,.556E-01_JPRB,.572E-01_JPRB,.437E-01_JPRB,.195E-01_JPRB,.576E-02_JPRB,&
&.506E-02_JPRB,.717E-02_JPRB,.594E-02_JPRB,.250E-02_JPRB,.196E-02_JPRB,.186E-02_JPRB,.150E-02_JPRB,&
&.128E-02_JPRB,.125E-02_JPRB,.142E-02_JPRB,.174E-02_JPRB,.213E-02_JPRB,.257E-02_JPRB,.312E-02_JPRB,&
&.365E-02_JPRB,.403E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 27 -14.0
ZAER (:,27, 6) = (/&
&.732E-02_JPRB,.787E-02_JPRB,.861E-02_JPRB,.958E-02_JPRB,.106E-01_JPRB,.119E-01_JPRB,.134E-01_JPRB,&
&.150E-01_JPRB,.163E-01_JPRB,.170E-01_JPRB,.181E-01_JPRB,.193E-01_JPRB,.201E-01_JPRB,.197E-01_JPRB,&
&.184E-01_JPRB,.165E-01_JPRB,.137E-01_JPRB,.110E-01_JPRB,.848E-02_JPRB,.908E-02_JPRB,.131E-01_JPRB,&
&.181E-01_JPRB,.231E-01_JPRB,.259E-01_JPRB,.298E-01_JPRB,.363E-01_JPRB,.425E-01_JPRB,.473E-01_JPRB,&
&.536E-01_JPRB,.619E-01_JPRB,.728E-01_JPRB,.880E-01_JPRB,.110E+00_JPRB,.133E+00_JPRB,.134E+00_JPRB,&
&.131E+00_JPRB,.154E+00_JPRB,.170E+00_JPRB,.164E+00_JPRB,.163E+00_JPRB,.195E+00_JPRB,.222E+00_JPRB,&
&.246E+00_JPRB,.331E+00_JPRB,.510E+00_JPRB,.705E+00_JPRB,.875E+00_JPRB,.482E+00_JPRB,.139E+00_JPRB,&
&.875E-01_JPRB,.926E-01_JPRB,.121E+00_JPRB,.132E+00_JPRB,.101E+00_JPRB,.506E-01_JPRB,.194E-01_JPRB,&
&.107E-01_JPRB,.846E-02_JPRB,.685E-02_JPRB,.525E-02_JPRB,.495E-02_JPRB,.459E-02_JPRB,.380E-02_JPRB,&
&.296E-02_JPRB,.242E-02_JPRB,.235E-02_JPRB,.289E-02_JPRB,.372E-02_JPRB,.449E-02_JPRB,.529E-02_JPRB,&
&.611E-02_JPRB,.674E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 28 -18.0
ZAER (:,28, 6) = (/&
&.125E-01_JPRB,.134E-01_JPRB,.144E-01_JPRB,.150E-01_JPRB,.151E-01_JPRB,.155E-01_JPRB,.165E-01_JPRB,&
&.183E-01_JPRB,.206E-01_JPRB,.225E-01_JPRB,.247E-01_JPRB,.285E-01_JPRB,.351E-01_JPRB,.435E-01_JPRB,&
&.486E-01_JPRB,.423E-01_JPRB,.318E-01_JPRB,.250E-01_JPRB,.182E-01_JPRB,.137E-01_JPRB,.139E-01_JPRB,&
&.185E-01_JPRB,.233E-01_JPRB,.275E-01_JPRB,.313E-01_JPRB,.342E-01_JPRB,.354E-01_JPRB,.365E-01_JPRB,&
&.403E-01_JPRB,.460E-01_JPRB,.591E-01_JPRB,.871E-01_JPRB,.137E+00_JPRB,.193E+00_JPRB,.206E+00_JPRB,&
&.196E+00_JPRB,.198E+00_JPRB,.200E+00_JPRB,.191E+00_JPRB,.192E+00_JPRB,.217E+00_JPRB,.231E+00_JPRB,&
&.245E+00_JPRB,.291E+00_JPRB,.356E+00_JPRB,.448E+00_JPRB,.514E+00_JPRB,.395E+00_JPRB,.209E+00_JPRB,&
&.155E+00_JPRB,.147E+00_JPRB,.187E+00_JPRB,.213E+00_JPRB,.168E+00_JPRB,.974E-01_JPRB,.493E-01_JPRB,&
&.279E-01_JPRB,.163E-01_JPRB,.764E-02_JPRB,.742E-02_JPRB,.933E-02_JPRB,.906E-02_JPRB,.947E-02_JPRB,&
&.955E-02_JPRB,.764E-02_JPRB,.544E-02_JPRB,.550E-02_JPRB,.712E-02_JPRB,.832E-02_JPRB,.910E-02_JPRB,&
&.100E-01_JPRB,.113E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 29 -22.0
ZAER (:,29, 6) = (/&
&.203E-01_JPRB,.209E-01_JPRB,.217E-01_JPRB,.216E-01_JPRB,.205E-01_JPRB,.201E-01_JPRB,.201E-01_JPRB,&
&.207E-01_JPRB,.219E-01_JPRB,.234E-01_JPRB,.241E-01_JPRB,.267E-01_JPRB,.344E-01_JPRB,.484E-01_JPRB,&
&.632E-01_JPRB,.660E-01_JPRB,.565E-01_JPRB,.403E-01_JPRB,.338E-01_JPRB,.273E-01_JPRB,.230E-01_JPRB,&
&.213E-01_JPRB,.240E-01_JPRB,.277E-01_JPRB,.309E-01_JPRB,.316E-01_JPRB,.319E-01_JPRB,.311E-01_JPRB,&
&.313E-01_JPRB,.324E-01_JPRB,.378E-01_JPRB,.545E-01_JPRB,.979E-01_JPRB,.187E+00_JPRB,.218E+00_JPRB,&
&.216E+00_JPRB,.203E+00_JPRB,.198E+00_JPRB,.200E+00_JPRB,.221E+00_JPRB,.231E+00_JPRB,.218E+00_JPRB,&
&.212E+00_JPRB,.242E+00_JPRB,.317E+00_JPRB,.391E+00_JPRB,.429E+00_JPRB,.394E+00_JPRB,.295E+00_JPRB,&
&.244E+00_JPRB,.232E+00_JPRB,.251E+00_JPRB,.268E+00_JPRB,.195E+00_JPRB,.135E+00_JPRB,.889E-01_JPRB,&
&.577E-01_JPRB,.331E-01_JPRB,.127E-01_JPRB,.837E-02_JPRB,.989E-02_JPRB,.125E-01_JPRB,.163E-01_JPRB,&
&.201E-01_JPRB,.205E-01_JPRB,.162E-01_JPRB,.150E-01_JPRB,.173E-01_JPRB,.189E-01_JPRB,.191E-01_JPRB,&
&.190E-01_JPRB,.195E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 30 -26.0
ZAER (:,30, 6) = (/&
&.340E-01_JPRB,.345E-01_JPRB,.361E-01_JPRB,.359E-01_JPRB,.337E-01_JPRB,.322E-01_JPRB,.320E-01_JPRB,&
&.321E-01_JPRB,.315E-01_JPRB,.303E-01_JPRB,.296E-01_JPRB,.282E-01_JPRB,.308E-01_JPRB,.445E-01_JPRB,&
&.595E-01_JPRB,.766E-01_JPRB,.829E-01_JPRB,.481E-01_JPRB,.423E-01_JPRB,.394E-01_JPRB,.373E-01_JPRB,&
&.324E-01_JPRB,.308E-01_JPRB,.321E-01_JPRB,.340E-01_JPRB,.351E-01_JPRB,.346E-01_JPRB,.329E-01_JPRB,&
&.312E-01_JPRB,.304E-01_JPRB,.305E-01_JPRB,.340E-01_JPRB,.498E-01_JPRB,.117E+00_JPRB,.199E+00_JPRB,&
&.206E+00_JPRB,.212E+00_JPRB,.225E+00_JPRB,.245E+00_JPRB,.281E+00_JPRB,.251E+00_JPRB,.196E+00_JPRB,&
&.175E+00_JPRB,.208E+00_JPRB,.308E+00_JPRB,.355E+00_JPRB,.361E+00_JPRB,.325E+00_JPRB,.296E+00_JPRB,&
&.290E+00_JPRB,.330E+00_JPRB,.331E+00_JPRB,.274E+00_JPRB,.185E+00_JPRB,.129E+00_JPRB,.104E+00_JPRB,&
&.855E-01_JPRB,.570E-01_JPRB,.216E-01_JPRB,.114E-01_JPRB,.142E-01_JPRB,.194E-01_JPRB,.272E-01_JPRB,&
&.332E-01_JPRB,.345E-01_JPRB,.317E-01_JPRB,.311E-01_JPRB,.331E-01_JPRB,.357E-01_JPRB,.369E-01_JPRB,&
&.365E-01_JPRB,.351E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 31 -30.0
ZAER (:,31, 6) = (/&
&.493E-01_JPRB,.509E-01_JPRB,.521E-01_JPRB,.521E-01_JPRB,.506E-01_JPRB,.483E-01_JPRB,.469E-01_JPRB,&
&.457E-01_JPRB,.450E-01_JPRB,.438E-01_JPRB,.430E-01_JPRB,.411E-01_JPRB,.403E-01_JPRB,.446E-01_JPRB,&
&.475E-01_JPRB,.744E-01_JPRB,.921E-01_JPRB,.545E-01_JPRB,.485E-01_JPRB,.451E-01_JPRB,.425E-01_JPRB,&
&.376E-01_JPRB,.353E-01_JPRB,.338E-01_JPRB,.343E-01_JPRB,.354E-01_JPRB,.339E-01_JPRB,.309E-01_JPRB,&
&.288E-01_JPRB,.275E-01_JPRB,.277E-01_JPRB,.288E-01_JPRB,.322E-01_JPRB,.513E-01_JPRB,.118E+00_JPRB,&
&.173E+00_JPRB,.187E+00_JPRB,.207E+00_JPRB,.244E+00_JPRB,.258E+00_JPRB,.211E+00_JPRB,.162E+00_JPRB,&
&.137E+00_JPRB,.172E+00_JPRB,.288E+00_JPRB,.335E+00_JPRB,.313E+00_JPRB,.271E+00_JPRB,.263E+00_JPRB,&
&.259E+00_JPRB,.257E+00_JPRB,.221E+00_JPRB,.195E+00_JPRB,.163E+00_JPRB,.119E+00_JPRB,.109E+00_JPRB,&
&.938E-01_JPRB,.697E-01_JPRB,.353E-01_JPRB,.209E-01_JPRB,.227E-01_JPRB,.292E-01_JPRB,.396E-01_JPRB,&
&.496E-01_JPRB,.503E-01_JPRB,.477E-01_JPRB,.469E-01_JPRB,.468E-01_JPRB,.488E-01_JPRB,.511E-01_JPRB,&
&.510E-01_JPRB,.499E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 32 -34.0
ZAER (:,32, 6) = (/&
&.621E-01_JPRB,.606E-01_JPRB,.581E-01_JPRB,.566E-01_JPRB,.557E-01_JPRB,.550E-01_JPRB,.525E-01_JPRB,&
&.489E-01_JPRB,.480E-01_JPRB,.493E-01_JPRB,.512E-01_JPRB,.544E-01_JPRB,.601E-01_JPRB,.595E-01_JPRB,&
&.554E-01_JPRB,.788E-01_JPRB,.113E+00_JPRB,.691E-01_JPRB,.554E-01_JPRB,.506E-01_JPRB,.461E-01_JPRB,&
&.404E-01_JPRB,.373E-01_JPRB,.342E-01_JPRB,.314E-01_JPRB,.310E-01_JPRB,.310E-01_JPRB,.279E-01_JPRB,&
&.259E-01_JPRB,.254E-01_JPRB,.259E-01_JPRB,.266E-01_JPRB,.273E-01_JPRB,.323E-01_JPRB,.549E-01_JPRB,&
&.103E+00_JPRB,.135E+00_JPRB,.172E+00_JPRB,.187E+00_JPRB,.130E+00_JPRB,.104E+00_JPRB,.862E-01_JPRB,&
&.904E-01_JPRB,.129E+00_JPRB,.217E+00_JPRB,.279E+00_JPRB,.267E+00_JPRB,.252E+00_JPRB,.248E+00_JPRB,&
&.241E+00_JPRB,.208E+00_JPRB,.174E+00_JPRB,.156E+00_JPRB,.145E+00_JPRB,.141E+00_JPRB,.140E+00_JPRB,&
&.123E+00_JPRB,.885E-01_JPRB,.580E-01_JPRB,.420E-01_JPRB,.418E-01_JPRB,.484E-01_JPRB,.597E-01_JPRB,&
&.707E-01_JPRB,.723E-01_JPRB,.656E-01_JPRB,.601E-01_JPRB,.593E-01_JPRB,.579E-01_JPRB,.580E-01_JPRB,&
&.612E-01_JPRB,.611E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 33 -38.0
ZAER (:,33, 6) = (/&
&.659E-01_JPRB,.582E-01_JPRB,.531E-01_JPRB,.503E-01_JPRB,.502E-01_JPRB,.513E-01_JPRB,.498E-01_JPRB,&
&.470E-01_JPRB,.460E-01_JPRB,.482E-01_JPRB,.519E-01_JPRB,.578E-01_JPRB,.674E-01_JPRB,.709E-01_JPRB,&
&.705E-01_JPRB,.755E-01_JPRB,.888E-01_JPRB,.719E-01_JPRB,.593E-01_JPRB,.523E-01_JPRB,.473E-01_JPRB,&
&.424E-01_JPRB,.387E-01_JPRB,.345E-01_JPRB,.310E-01_JPRB,.289E-01_JPRB,.283E-01_JPRB,.262E-01_JPRB,&
&.249E-01_JPRB,.249E-01_JPRB,.246E-01_JPRB,.246E-01_JPRB,.252E-01_JPRB,.274E-01_JPRB,.407E-01_JPRB,&
&.570E-01_JPRB,.790E-01_JPRB,.110E+00_JPRB,.112E+00_JPRB,.731E-01_JPRB,.554E-01_JPRB,.553E-01_JPRB,&
&.696E-01_JPRB,.105E+00_JPRB,.150E+00_JPRB,.199E+00_JPRB,.243E+00_JPRB,.254E+00_JPRB,.248E+00_JPRB,&
&.225E+00_JPRB,.190E+00_JPRB,.146E+00_JPRB,.156E+00_JPRB,.165E+00_JPRB,.156E+00_JPRB,.171E+00_JPRB,&
&.180E+00_JPRB,.160E+00_JPRB,.133E+00_JPRB,.137E+00_JPRB,.123E+00_JPRB,.112E+00_JPRB,.108E+00_JPRB,&
&.942E-01_JPRB,.876E-01_JPRB,.790E-01_JPRB,.695E-01_JPRB,.681E-01_JPRB,.667E-01_JPRB,.701E-01_JPRB,&
&.734E-01_JPRB,.711E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 34 -42.0
ZAER (:,34, 6) = (/&
&.616E-01_JPRB,.512E-01_JPRB,.454E-01_JPRB,.430E-01_JPRB,.420E-01_JPRB,.424E-01_JPRB,.425E-01_JPRB,&
&.419E-01_JPRB,.423E-01_JPRB,.444E-01_JPRB,.472E-01_JPRB,.509E-01_JPRB,.581E-01_JPRB,.626E-01_JPRB,&
&.641E-01_JPRB,.633E-01_JPRB,.626E-01_JPRB,.579E-01_JPRB,.504E-01_JPRB,.453E-01_JPRB,.422E-01_JPRB,&
&.397E-01_JPRB,.371E-01_JPRB,.334E-01_JPRB,.297E-01_JPRB,.279E-01_JPRB,.265E-01_JPRB,.246E-01_JPRB,&
&.236E-01_JPRB,.232E-01_JPRB,.226E-01_JPRB,.221E-01_JPRB,.224E-01_JPRB,.231E-01_JPRB,.292E-01_JPRB,&
&.366E-01_JPRB,.416E-01_JPRB,.585E-01_JPRB,.736E-01_JPRB,.626E-01_JPRB,.523E-01_JPRB,.499E-01_JPRB,&
&.600E-01_JPRB,.849E-01_JPRB,.104E+00_JPRB,.144E+00_JPRB,.253E+00_JPRB,.343E+00_JPRB,.288E+00_JPRB,&
&.254E+00_JPRB,.213E+00_JPRB,.151E+00_JPRB,.149E+00_JPRB,.172E+00_JPRB,.193E+00_JPRB,.230E+00_JPRB,&
&.289E+00_JPRB,.290E+00_JPRB,.285E+00_JPRB,.298E+00_JPRB,.240E+00_JPRB,.175E+00_JPRB,.140E+00_JPRB,&
&.113E+00_JPRB,.983E-01_JPRB,.923E-01_JPRB,.818E-01_JPRB,.768E-01_JPRB,.773E-01_JPRB,.812E-01_JPRB,&
&.800E-01_JPRB,.726E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 35 -46.0
ZAER (:,35, 6) = (/&
&.627E-01_JPRB,.518E-01_JPRB,.439E-01_JPRB,.395E-01_JPRB,.365E-01_JPRB,.354E-01_JPRB,.361E-01_JPRB,&
&.379E-01_JPRB,.393E-01_JPRB,.395E-01_JPRB,.404E-01_JPRB,.420E-01_JPRB,.461E-01_JPRB,.483E-01_JPRB,&
&.482E-01_JPRB,.472E-01_JPRB,.455E-01_JPRB,.435E-01_JPRB,.398E-01_JPRB,.363E-01_JPRB,.349E-01_JPRB,&
&.332E-01_JPRB,.325E-01_JPRB,.306E-01_JPRB,.273E-01_JPRB,.261E-01_JPRB,.252E-01_JPRB,.233E-01_JPRB,&
&.221E-01_JPRB,.213E-01_JPRB,.206E-01_JPRB,.202E-01_JPRB,.201E-01_JPRB,.201E-01_JPRB,.206E-01_JPRB,&
&.229E-01_JPRB,.264E-01_JPRB,.367E-01_JPRB,.519E-01_JPRB,.548E-01_JPRB,.523E-01_JPRB,.454E-01_JPRB,&
&.510E-01_JPRB,.692E-01_JPRB,.979E-01_JPRB,.149E+00_JPRB,.201E+00_JPRB,.290E+00_JPRB,.255E+00_JPRB,&
&.228E+00_JPRB,.210E+00_JPRB,.199E+00_JPRB,.161E+00_JPRB,.150E+00_JPRB,.196E+00_JPRB,.238E+00_JPRB,&
&.255E+00_JPRB,.263E+00_JPRB,.286E+00_JPRB,.295E+00_JPRB,.234E+00_JPRB,.170E+00_JPRB,.137E+00_JPRB,&
&.117E+00_JPRB,.103E+00_JPRB,.985E-01_JPRB,.943E-01_JPRB,.893E-01_JPRB,.860E-01_JPRB,.841E-01_JPRB,&
&.812E-01_JPRB,.728E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 36 -50.0
ZAER (:,36, 6) = (/&
&.593E-01_JPRB,.481E-01_JPRB,.403E-01_JPRB,.355E-01_JPRB,.325E-01_JPRB,.309E-01_JPRB,.313E-01_JPRB,&
&.336E-01_JPRB,.346E-01_JPRB,.348E-01_JPRB,.353E-01_JPRB,.365E-01_JPRB,.381E-01_JPRB,.374E-01_JPRB,&
&.356E-01_JPRB,.345E-01_JPRB,.339E-01_JPRB,.333E-01_JPRB,.317E-01_JPRB,.299E-01_JPRB,.293E-01_JPRB,&
&.286E-01_JPRB,.284E-01_JPRB,.272E-01_JPRB,.244E-01_JPRB,.234E-01_JPRB,.228E-01_JPRB,.218E-01_JPRB,&
&.210E-01_JPRB,.201E-01_JPRB,.195E-01_JPRB,.190E-01_JPRB,.183E-01_JPRB,.182E-01_JPRB,.190E-01_JPRB,&
&.197E-01_JPRB,.206E-01_JPRB,.241E-01_JPRB,.325E-01_JPRB,.388E-01_JPRB,.408E-01_JPRB,.394E-01_JPRB,&
&.484E-01_JPRB,.679E-01_JPRB,.980E-01_JPRB,.139E+00_JPRB,.141E+00_JPRB,.143E+00_JPRB,.156E+00_JPRB,&
&.163E+00_JPRB,.163E+00_JPRB,.153E+00_JPRB,.141E+00_JPRB,.117E+00_JPRB,.119E+00_JPRB,.134E+00_JPRB,&
&.144E+00_JPRB,.147E+00_JPRB,.142E+00_JPRB,.146E+00_JPRB,.145E+00_JPRB,.125E+00_JPRB,.106E+00_JPRB,&
&.925E-01_JPRB,.857E-01_JPRB,.850E-01_JPRB,.858E-01_JPRB,.841E-01_JPRB,.807E-01_JPRB,.784E-01_JPRB,&
&.754E-01_JPRB,.684E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 37 -54.0
ZAER (:,37, 6) = (/&
&.477E-01_JPRB,.395E-01_JPRB,.344E-01_JPRB,.310E-01_JPRB,.280E-01_JPRB,.269E-01_JPRB,.274E-01_JPRB,&
&.290E-01_JPRB,.300E-01_JPRB,.307E-01_JPRB,.316E-01_JPRB,.320E-01_JPRB,.319E-01_JPRB,.316E-01_JPRB,&
&.302E-01_JPRB,.286E-01_JPRB,.280E-01_JPRB,.272E-01_JPRB,.265E-01_JPRB,.259E-01_JPRB,.258E-01_JPRB,&
&.259E-01_JPRB,.257E-01_JPRB,.252E-01_JPRB,.239E-01_JPRB,.223E-01_JPRB,.211E-01_JPRB,.207E-01_JPRB,&
&.208E-01_JPRB,.198E-01_JPRB,.189E-01_JPRB,.181E-01_JPRB,.173E-01_JPRB,.172E-01_JPRB,.176E-01_JPRB,&
&.180E-01_JPRB,.184E-01_JPRB,.199E-01_JPRB,.240E-01_JPRB,.289E-01_JPRB,.338E-01_JPRB,.382E-01_JPRB,&
&.475E-01_JPRB,.635E-01_JPRB,.742E-01_JPRB,.728E-01_JPRB,.891E-01_JPRB,.920E-01_JPRB,.968E-01_JPRB,&
&.110E+00_JPRB,.115E+00_JPRB,.104E+00_JPRB,.893E-01_JPRB,.810E-01_JPRB,.776E-01_JPRB,.763E-01_JPRB,&
&.766E-01_JPRB,.772E-01_JPRB,.724E-01_JPRB,.699E-01_JPRB,.723E-01_JPRB,.818E-01_JPRB,.828E-01_JPRB,&
&.781E-01_JPRB,.717E-01_JPRB,.685E-01_JPRB,.684E-01_JPRB,.681E-01_JPRB,.657E-01_JPRB,.624E-01_JPRB,&
&.595E-01_JPRB,.550E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 38 -58.0
ZAER (:,38, 6) = (/&
&.359E-01_JPRB,.315E-01_JPRB,.285E-01_JPRB,.278E-01_JPRB,.271E-01_JPRB,.260E-01_JPRB,.252E-01_JPRB,&
&.256E-01_JPRB,.269E-01_JPRB,.287E-01_JPRB,.303E-01_JPRB,.293E-01_JPRB,.275E-01_JPRB,.276E-01_JPRB,&
&.277E-01_JPRB,.269E-01_JPRB,.260E-01_JPRB,.249E-01_JPRB,.241E-01_JPRB,.238E-01_JPRB,.238E-01_JPRB,&
&.238E-01_JPRB,.234E-01_JPRB,.228E-01_JPRB,.223E-01_JPRB,.218E-01_JPRB,.208E-01_JPRB,.200E-01_JPRB,&
&.193E-01_JPRB,.177E-01_JPRB,.168E-01_JPRB,.166E-01_JPRB,.162E-01_JPRB,.159E-01_JPRB,.159E-01_JPRB,&
&.162E-01_JPRB,.170E-01_JPRB,.182E-01_JPRB,.207E-01_JPRB,.239E-01_JPRB,.286E-01_JPRB,.353E-01_JPRB,&
&.450E-01_JPRB,.502E-01_JPRB,.472E-01_JPRB,.406E-01_JPRB,.510E-01_JPRB,.624E-01_JPRB,.658E-01_JPRB,&
&.630E-01_JPRB,.601E-01_JPRB,.564E-01_JPRB,.507E-01_JPRB,.482E-01_JPRB,.490E-01_JPRB,.510E-01_JPRB,&
&.528E-01_JPRB,.534E-01_JPRB,.532E-01_JPRB,.525E-01_JPRB,.522E-01_JPRB,.537E-01_JPRB,.582E-01_JPRB,&
&.632E-01_JPRB,.607E-01_JPRB,.547E-01_JPRB,.512E-01_JPRB,.502E-01_JPRB,.486E-01_JPRB,.463E-01_JPRB,&
&.437E-01_JPRB,.398E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 39 -62.0
ZAER (:,39, 6) = (/&
&.296E-01_JPRB,.280E-01_JPRB,.273E-01_JPRB,.273E-01_JPRB,.271E-01_JPRB,.260E-01_JPRB,.246E-01_JPRB,&
&.254E-01_JPRB,.262E-01_JPRB,.274E-01_JPRB,.290E-01_JPRB,.284E-01_JPRB,.265E-01_JPRB,.261E-01_JPRB,&
&.261E-01_JPRB,.256E-01_JPRB,.245E-01_JPRB,.233E-01_JPRB,.225E-01_JPRB,.222E-01_JPRB,.221E-01_JPRB,&
&.219E-01_JPRB,.211E-01_JPRB,.206E-01_JPRB,.201E-01_JPRB,.200E-01_JPRB,.202E-01_JPRB,.194E-01_JPRB,&
&.175E-01_JPRB,.160E-01_JPRB,.152E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.149E-01_JPRB,.148E-01_JPRB,&
&.147E-01_JPRB,.151E-01_JPRB,.161E-01_JPRB,.181E-01_JPRB,.200E-01_JPRB,.237E-01_JPRB,.273E-01_JPRB,&
&.306E-01_JPRB,.327E-01_JPRB,.344E-01_JPRB,.339E-01_JPRB,.343E-01_JPRB,.380E-01_JPRB,.400E-01_JPRB,&
&.370E-01_JPRB,.332E-01_JPRB,.313E-01_JPRB,.318E-01_JPRB,.330E-01_JPRB,.348E-01_JPRB,.372E-01_JPRB,&
&.389E-01_JPRB,.399E-01_JPRB,.409E-01_JPRB,.413E-01_JPRB,.412E-01_JPRB,.423E-01_JPRB,.456E-01_JPRB,&
&.489E-01_JPRB,.485E-01_JPRB,.449E-01_JPRB,.401E-01_JPRB,.366E-01_JPRB,.347E-01_JPRB,.337E-01_JPRB,&
&.326E-01_JPRB,.308E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 40 -66.0
ZAER (:,40, 6) = (/&
&.262E-01_JPRB,.259E-01_JPRB,.267E-01_JPRB,.278E-01_JPRB,.279E-01_JPRB,.271E-01_JPRB,.272E-01_JPRB,&
&.275E-01_JPRB,.276E-01_JPRB,.278E-01_JPRB,.273E-01_JPRB,.271E-01_JPRB,.269E-01_JPRB,.264E-01_JPRB,&
&.255E-01_JPRB,.245E-01_JPRB,.235E-01_JPRB,.226E-01_JPRB,.219E-01_JPRB,.213E-01_JPRB,.207E-01_JPRB,&
&.201E-01_JPRB,.196E-01_JPRB,.192E-01_JPRB,.189E-01_JPRB,.189E-01_JPRB,.193E-01_JPRB,.191E-01_JPRB,&
&.181E-01_JPRB,.169E-01_JPRB,.159E-01_JPRB,.150E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.143E-01_JPRB,&
&.139E-01_JPRB,.139E-01_JPRB,.145E-01_JPRB,.156E-01_JPRB,.171E-01_JPRB,.191E-01_JPRB,.210E-01_JPRB,&
&.217E-01_JPRB,.221E-01_JPRB,.240E-01_JPRB,.258E-01_JPRB,.262E-01_JPRB,.258E-01_JPRB,.250E-01_JPRB,&
&.236E-01_JPRB,.228E-01_JPRB,.229E-01_JPRB,.249E-01_JPRB,.277E-01_JPRB,.298E-01_JPRB,.313E-01_JPRB,&
&.320E-01_JPRB,.323E-01_JPRB,.324E-01_JPRB,.324E-01_JPRB,.336E-01_JPRB,.352E-01_JPRB,.360E-01_JPRB,&
&.367E-01_JPRB,.375E-01_JPRB,.374E-01_JPRB,.356E-01_JPRB,.327E-01_JPRB,.313E-01_JPRB,.305E-01_JPRB,&
&.297E-01_JPRB,.279E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 41 -70.0
ZAER (:,41, 6) = (/&
&.260E-01_JPRB,.258E-01_JPRB,.265E-01_JPRB,.274E-01_JPRB,.277E-01_JPRB,.275E-01_JPRB,.274E-01_JPRB,&
&.272E-01_JPRB,.270E-01_JPRB,.268E-01_JPRB,.262E-01_JPRB,.257E-01_JPRB,.252E-01_JPRB,.246E-01_JPRB,&
&.239E-01_JPRB,.233E-01_JPRB,.226E-01_JPRB,.218E-01_JPRB,.213E-01_JPRB,.206E-01_JPRB,.199E-01_JPRB,&
&.195E-01_JPRB,.191E-01_JPRB,.187E-01_JPRB,.185E-01_JPRB,.183E-01_JPRB,.185E-01_JPRB,.187E-01_JPRB,&
&.189E-01_JPRB,.188E-01_JPRB,.180E-01_JPRB,.167E-01_JPRB,.154E-01_JPRB,.145E-01_JPRB,.141E-01_JPRB,&
&.137E-01_JPRB,.137E-01_JPRB,.141E-01_JPRB,.146E-01_JPRB,.154E-01_JPRB,.166E-01_JPRB,.177E-01_JPRB,&
&.183E-01_JPRB,.185E-01_JPRB,.189E-01_JPRB,.191E-01_JPRB,.191E-01_JPRB,.190E-01_JPRB,.188E-01_JPRB,&
&.189E-01_JPRB,.190E-01_JPRB,.196E-01_JPRB,.209E-01_JPRB,.226E-01_JPRB,.249E-01_JPRB,.268E-01_JPRB,&
&.281E-01_JPRB,.288E-01_JPRB,.281E-01_JPRB,.274E-01_JPRB,.276E-01_JPRB,.285E-01_JPRB,.291E-01_JPRB,&
&.294E-01_JPRB,.303E-01_JPRB,.313E-01_JPRB,.317E-01_JPRB,.309E-01_JPRB,.307E-01_JPRB,.302E-01_JPRB,&
&.291E-01_JPRB,.274E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 42 -74.0
ZAER (:,42, 6) = (/&
&.259E-01_JPRB,.254E-01_JPRB,.253E-01_JPRB,.255E-01_JPRB,.257E-01_JPRB,.257E-01_JPRB,.255E-01_JPRB,&
&.253E-01_JPRB,.251E-01_JPRB,.248E-01_JPRB,.244E-01_JPRB,.239E-01_JPRB,.233E-01_JPRB,.228E-01_JPRB,&
&.228E-01_JPRB,.227E-01_JPRB,.221E-01_JPRB,.218E-01_JPRB,.211E-01_JPRB,.202E-01_JPRB,.195E-01_JPRB,&
&.191E-01_JPRB,.187E-01_JPRB,.182E-01_JPRB,.182E-01_JPRB,.184E-01_JPRB,.185E-01_JPRB,.187E-01_JPRB,&
&.188E-01_JPRB,.189E-01_JPRB,.187E-01_JPRB,.180E-01_JPRB,.166E-01_JPRB,.150E-01_JPRB,.141E-01_JPRB,&
&.137E-01_JPRB,.136E-01_JPRB,.140E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.154E-01_JPRB,.160E-01_JPRB,&
&.165E-01_JPRB,.169E-01_JPRB,.173E-01_JPRB,.175E-01_JPRB,.177E-01_JPRB,.179E-01_JPRB,.182E-01_JPRB,&
&.185E-01_JPRB,.190E-01_JPRB,.200E-01_JPRB,.205E-01_JPRB,.211E-01_JPRB,.226E-01_JPRB,.238E-01_JPRB,&
&.246E-01_JPRB,.251E-01_JPRB,.252E-01_JPRB,.253E-01_JPRB,.258E-01_JPRB,.265E-01_JPRB,.271E-01_JPRB,&
&.280E-01_JPRB,.290E-01_JPRB,.300E-01_JPRB,.300E-01_JPRB,.295E-01_JPRB,.290E-01_JPRB,.286E-01_JPRB,&
&.278E-01_JPRB,.268E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 43 -78.0
ZAER (:,43, 6) = (/&
&.246E-01_JPRB,.241E-01_JPRB,.238E-01_JPRB,.236E-01_JPRB,.236E-01_JPRB,.235E-01_JPRB,.235E-01_JPRB,&
&.233E-01_JPRB,.230E-01_JPRB,.228E-01_JPRB,.225E-01_JPRB,.221E-01_JPRB,.216E-01_JPRB,.211E-01_JPRB,&
&.209E-01_JPRB,.208E-01_JPRB,.203E-01_JPRB,.201E-01_JPRB,.199E-01_JPRB,.196E-01_JPRB,.191E-01_JPRB,&
&.185E-01_JPRB,.178E-01_JPRB,.176E-01_JPRB,.180E-01_JPRB,.185E-01_JPRB,.189E-01_JPRB,.187E-01_JPRB,&
&.182E-01_JPRB,.183E-01_JPRB,.181E-01_JPRB,.174E-01_JPRB,.164E-01_JPRB,.151E-01_JPRB,.143E-01_JPRB,&
&.142E-01_JPRB,.141E-01_JPRB,.141E-01_JPRB,.144E-01_JPRB,.147E-01_JPRB,.151E-01_JPRB,.155E-01_JPRB,&
&.159E-01_JPRB,.163E-01_JPRB,.167E-01_JPRB,.170E-01_JPRB,.175E-01_JPRB,.178E-01_JPRB,.183E-01_JPRB,&
&.188E-01_JPRB,.194E-01_JPRB,.200E-01_JPRB,.204E-01_JPRB,.208E-01_JPRB,.220E-01_JPRB,.232E-01_JPRB,&
&.235E-01_JPRB,.233E-01_JPRB,.234E-01_JPRB,.240E-01_JPRB,.247E-01_JPRB,.254E-01_JPRB,.260E-01_JPRB,&
&.264E-01_JPRB,.271E-01_JPRB,.273E-01_JPRB,.269E-01_JPRB,.263E-01_JPRB,.260E-01_JPRB,.258E-01_JPRB,&
&.257E-01_JPRB,.252E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 44 -82.0
ZAER (:,44, 6) = (/&
&.220E-01_JPRB,.219E-01_JPRB,.218E-01_JPRB,.216E-01_JPRB,.214E-01_JPRB,.214E-01_JPRB,.213E-01_JPRB,&
&.213E-01_JPRB,.210E-01_JPRB,.206E-01_JPRB,.201E-01_JPRB,.196E-01_JPRB,.192E-01_JPRB,.188E-01_JPRB,&
&.186E-01_JPRB,.184E-01_JPRB,.182E-01_JPRB,.179E-01_JPRB,.177E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,&
&.175E-01_JPRB,.172E-01_JPRB,.170E-01_JPRB,.171E-01_JPRB,.174E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,&
&.173E-01_JPRB,.170E-01_JPRB,.167E-01_JPRB,.163E-01_JPRB,.159E-01_JPRB,.154E-01_JPRB,.149E-01_JPRB,&
&.147E-01_JPRB,.149E-01_JPRB,.151E-01_JPRB,.155E-01_JPRB,.159E-01_JPRB,.163E-01_JPRB,.167E-01_JPRB,&
&.169E-01_JPRB,.171E-01_JPRB,.173E-01_JPRB,.174E-01_JPRB,.177E-01_JPRB,.181E-01_JPRB,.182E-01_JPRB,&
&.183E-01_JPRB,.185E-01_JPRB,.188E-01_JPRB,.190E-01_JPRB,.195E-01_JPRB,.200E-01_JPRB,.203E-01_JPRB,&
&.203E-01_JPRB,.206E-01_JPRB,.211E-01_JPRB,.217E-01_JPRB,.221E-01_JPRB,.221E-01_JPRB,.221E-01_JPRB,&
&.222E-01_JPRB,.225E-01_JPRB,.226E-01_JPRB,.228E-01_JPRB,.229E-01_JPRB,.229E-01_JPRB,.226E-01_JPRB,&
&.224E-01_JPRB,.222E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 45 -86.0
ZAER (:,45, 6) = (/&
&.183E-01_JPRB,.183E-01_JPRB,.182E-01_JPRB,.181E-01_JPRB,.180E-01_JPRB,.179E-01_JPRB,.178E-01_JPRB,&
&.176E-01_JPRB,.175E-01_JPRB,.174E-01_JPRB,.173E-01_JPRB,.172E-01_JPRB,.172E-01_JPRB,.171E-01_JPRB,&
&.170E-01_JPRB,.170E-01_JPRB,.169E-01_JPRB,.168E-01_JPRB,.168E-01_JPRB,.167E-01_JPRB,.166E-01_JPRB,&
&.165E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,&
&.164E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,.165E-01_JPRB,.164E-01_JPRB,.164E-01_JPRB,&
&.165E-01_JPRB,.167E-01_JPRB,.169E-01_JPRB,.172E-01_JPRB,.173E-01_JPRB,.175E-01_JPRB,.175E-01_JPRB,&
&.176E-01_JPRB,.176E-01_JPRB,.177E-01_JPRB,.177E-01_JPRB,.177E-01_JPRB,.176E-01_JPRB,.176E-01_JPRB,&
&.177E-01_JPRB,.178E-01_JPRB,.179E-01_JPRB,.180E-01_JPRB,.181E-01_JPRB,.182E-01_JPRB,.183E-01_JPRB,&
&.183E-01_JPRB,.183E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,.183E-01_JPRB,.182E-01_JPRB,.182E-01_JPRB,&
&.182E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.183E-01_JPRB,.184E-01_JPRB,.184E-01_JPRB,&
&.184E-01_JPRB,.184E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  6 --- lat: 46 -90.0
ZAER (:,46, 6) = (/&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,.173E-01_JPRB,&
&.173E-01_JPRB,.173E-01_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=6   
  DO JI=1,46
    DO JL=1,72
      RAERSD(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SOIL DUST AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESD_06
