SUBROUTINE SUECAESD_02

!**   OPTICAL THICKNESS OF AEROSOLS OF SOIL-DUST ORIGIN
!                                      February

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAESD* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERSD


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,2:2)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Total Soil Dust Aerosol  month:  2 --- lat:  1  90.0
ZAER (:, 1, 2) = (/&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,.886E-03_JPRB,&
&.886E-03_JPRB,.886E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  2  86.0
ZAER (:, 2, 2) = (/&
&.952E-03_JPRB,.949E-03_JPRB,.944E-03_JPRB,.933E-03_JPRB,.921E-03_JPRB,.912E-03_JPRB,.906E-03_JPRB,&
&.903E-03_JPRB,.902E-03_JPRB,.908E-03_JPRB,.922E-03_JPRB,.936E-03_JPRB,.944E-03_JPRB,.948E-03_JPRB,&
&.951E-03_JPRB,.947E-03_JPRB,.935E-03_JPRB,.931E-03_JPRB,.927E-03_JPRB,.927E-03_JPRB,.925E-03_JPRB,&
&.917E-03_JPRB,.911E-03_JPRB,.901E-03_JPRB,.890E-03_JPRB,.879E-03_JPRB,.874E-03_JPRB,.873E-03_JPRB,&
&.872E-03_JPRB,.867E-03_JPRB,.866E-03_JPRB,.861E-03_JPRB,.856E-03_JPRB,.853E-03_JPRB,.847E-03_JPRB,&
&.840E-03_JPRB,.836E-03_JPRB,.835E-03_JPRB,.834E-03_JPRB,.839E-03_JPRB,.842E-03_JPRB,.844E-03_JPRB,&
&.844E-03_JPRB,.839E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,.833E-03_JPRB,.827E-03_JPRB,.822E-03_JPRB,&
&.821E-03_JPRB,.823E-03_JPRB,.827E-03_JPRB,.831E-03_JPRB,.834E-03_JPRB,.840E-03_JPRB,.849E-03_JPRB,&
&.858E-03_JPRB,.869E-03_JPRB,.877E-03_JPRB,.882E-03_JPRB,.884E-03_JPRB,.889E-03_JPRB,.892E-03_JPRB,&
&.895E-03_JPRB,.899E-03_JPRB,.900E-03_JPRB,.903E-03_JPRB,.906E-03_JPRB,.914E-03_JPRB,.927E-03_JPRB,&
&.942E-03_JPRB,.952E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  3  82.0
ZAER (:, 3, 2) = (/&
&.799E-03_JPRB,.796E-03_JPRB,.804E-03_JPRB,.811E-03_JPRB,.822E-03_JPRB,.832E-03_JPRB,.829E-03_JPRB,&
&.833E-03_JPRB,.853E-03_JPRB,.880E-03_JPRB,.890E-03_JPRB,.905E-03_JPRB,.921E-03_JPRB,.927E-03_JPRB,&
&.952E-03_JPRB,.102E-02_JPRB,.107E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,.110E-02_JPRB,&
&.108E-02_JPRB,.106E-02_JPRB,.105E-02_JPRB,.102E-02_JPRB,.988E-03_JPRB,.975E-03_JPRB,.978E-03_JPRB,&
&.982E-03_JPRB,.981E-03_JPRB,.983E-03_JPRB,.988E-03_JPRB,.993E-03_JPRB,.989E-03_JPRB,.960E-03_JPRB,&
&.924E-03_JPRB,.909E-03_JPRB,.886E-03_JPRB,.851E-03_JPRB,.835E-03_JPRB,.839E-03_JPRB,.840E-03_JPRB,&
&.842E-03_JPRB,.839E-03_JPRB,.845E-03_JPRB,.855E-03_JPRB,.861E-03_JPRB,.860E-03_JPRB,.842E-03_JPRB,&
&.815E-03_JPRB,.795E-03_JPRB,.787E-03_JPRB,.779E-03_JPRB,.777E-03_JPRB,.783E-03_JPRB,.793E-03_JPRB,&
&.804E-03_JPRB,.819E-03_JPRB,.833E-03_JPRB,.840E-03_JPRB,.846E-03_JPRB,.851E-03_JPRB,.852E-03_JPRB,&
&.851E-03_JPRB,.856E-03_JPRB,.866E-03_JPRB,.874E-03_JPRB,.875E-03_JPRB,.866E-03_JPRB,.837E-03_JPRB,&
&.821E-03_JPRB,.811E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  4  78.0
ZAER (:, 4, 2) = (/&
&.750E-03_JPRB,.740E-03_JPRB,.749E-03_JPRB,.760E-03_JPRB,.789E-03_JPRB,.832E-03_JPRB,.871E-03_JPRB,&
&.898E-03_JPRB,.917E-03_JPRB,.924E-03_JPRB,.892E-03_JPRB,.856E-03_JPRB,.835E-03_JPRB,.800E-03_JPRB,&
&.810E-03_JPRB,.914E-03_JPRB,.104E-02_JPRB,.108E-02_JPRB,.110E-02_JPRB,.116E-02_JPRB,.121E-02_JPRB,&
&.122E-02_JPRB,.123E-02_JPRB,.125E-02_JPRB,.121E-02_JPRB,.120E-02_JPRB,.122E-02_JPRB,.121E-02_JPRB,&
&.119E-02_JPRB,.116E-02_JPRB,.114E-02_JPRB,.116E-02_JPRB,.119E-02_JPRB,.117E-02_JPRB,.113E-02_JPRB,&
&.109E-02_JPRB,.105E-02_JPRB,.991E-03_JPRB,.933E-03_JPRB,.862E-03_JPRB,.836E-03_JPRB,.836E-03_JPRB,&
&.827E-03_JPRB,.813E-03_JPRB,.821E-03_JPRB,.833E-03_JPRB,.838E-03_JPRB,.841E-03_JPRB,.839E-03_JPRB,&
&.828E-03_JPRB,.811E-03_JPRB,.793E-03_JPRB,.788E-03_JPRB,.788E-03_JPRB,.801E-03_JPRB,.818E-03_JPRB,&
&.837E-03_JPRB,.847E-03_JPRB,.851E-03_JPRB,.853E-03_JPRB,.854E-03_JPRB,.856E-03_JPRB,.851E-03_JPRB,&
&.839E-03_JPRB,.820E-03_JPRB,.823E-03_JPRB,.837E-03_JPRB,.831E-03_JPRB,.806E-03_JPRB,.771E-03_JPRB,&
&.747E-03_JPRB,.759E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  5  74.0
ZAER (:, 5, 2) = (/&
&.907E-03_JPRB,.925E-03_JPRB,.931E-03_JPRB,.930E-03_JPRB,.926E-03_JPRB,.928E-03_JPRB,.939E-03_JPRB,&
&.936E-03_JPRB,.920E-03_JPRB,.906E-03_JPRB,.876E-03_JPRB,.821E-03_JPRB,.771E-03_JPRB,.728E-03_JPRB,&
&.725E-03_JPRB,.788E-03_JPRB,.979E-03_JPRB,.105E-02_JPRB,.110E-02_JPRB,.121E-02_JPRB,.127E-02_JPRB,&
&.127E-02_JPRB,.125E-02_JPRB,.126E-02_JPRB,.132E-02_JPRB,.136E-02_JPRB,.136E-02_JPRB,.131E-02_JPRB,&
&.133E-02_JPRB,.132E-02_JPRB,.127E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.128E-02_JPRB,&
&.130E-02_JPRB,.127E-02_JPRB,.110E-02_JPRB,.926E-03_JPRB,.818E-03_JPRB,.801E-03_JPRB,.801E-03_JPRB,&
&.799E-03_JPRB,.804E-03_JPRB,.807E-03_JPRB,.812E-03_JPRB,.818E-03_JPRB,.815E-03_JPRB,.812E-03_JPRB,&
&.804E-03_JPRB,.818E-03_JPRB,.861E-03_JPRB,.882E-03_JPRB,.891E-03_JPRB,.910E-03_JPRB,.926E-03_JPRB,&
&.917E-03_JPRB,.897E-03_JPRB,.877E-03_JPRB,.871E-03_JPRB,.882E-03_JPRB,.894E-03_JPRB,.912E-03_JPRB,&
&.921E-03_JPRB,.919E-03_JPRB,.920E-03_JPRB,.914E-03_JPRB,.902E-03_JPRB,.882E-03_JPRB,.842E-03_JPRB,&
&.836E-03_JPRB,.871E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  6  70.0
ZAER (:, 6, 2) = (/&
&.106E-02_JPRB,.110E-02_JPRB,.111E-02_JPRB,.110E-02_JPRB,.105E-02_JPRB,.100E-02_JPRB,.978E-03_JPRB,&
&.950E-03_JPRB,.919E-03_JPRB,.882E-03_JPRB,.848E-03_JPRB,.774E-03_JPRB,.710E-03_JPRB,.683E-03_JPRB,&
&.686E-03_JPRB,.725E-03_JPRB,.760E-03_JPRB,.806E-03_JPRB,.951E-03_JPRB,.107E-02_JPRB,.121E-02_JPRB,&
&.130E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.133E-02_JPRB,.143E-02_JPRB,.150E-02_JPRB,.140E-02_JPRB,&
&.134E-02_JPRB,.136E-02_JPRB,.125E-02_JPRB,.108E-02_JPRB,.103E-02_JPRB,.109E-02_JPRB,.116E-02_JPRB,&
&.123E-02_JPRB,.124E-02_JPRB,.106E-02_JPRB,.866E-03_JPRB,.783E-03_JPRB,.766E-03_JPRB,.754E-03_JPRB,&
&.752E-03_JPRB,.776E-03_JPRB,.819E-03_JPRB,.860E-03_JPRB,.892E-03_JPRB,.889E-03_JPRB,.844E-03_JPRB,&
&.832E-03_JPRB,.845E-03_JPRB,.892E-03_JPRB,.954E-03_JPRB,.101E-02_JPRB,.107E-02_JPRB,.106E-02_JPRB,&
&.101E-02_JPRB,.972E-03_JPRB,.965E-03_JPRB,.965E-03_JPRB,.980E-03_JPRB,.998E-03_JPRB,.102E-02_JPRB,&
&.103E-02_JPRB,.103E-02_JPRB,.102E-02_JPRB,.995E-03_JPRB,.984E-03_JPRB,.967E-03_JPRB,.960E-03_JPRB,&
&.980E-03_JPRB,.102E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  7  66.0
ZAER (:, 7, 2) = (/&
&.117E-02_JPRB,.120E-02_JPRB,.124E-02_JPRB,.125E-02_JPRB,.122E-02_JPRB,.117E-02_JPRB,.110E-02_JPRB,&
&.104E-02_JPRB,.988E-03_JPRB,.930E-03_JPRB,.875E-03_JPRB,.833E-03_JPRB,.767E-03_JPRB,.690E-03_JPRB,&
&.669E-03_JPRB,.676E-03_JPRB,.700E-03_JPRB,.746E-03_JPRB,.805E-03_JPRB,.949E-03_JPRB,.114E-02_JPRB,&
&.137E-02_JPRB,.148E-02_JPRB,.137E-02_JPRB,.154E-02_JPRB,.171E-02_JPRB,.173E-02_JPRB,.165E-02_JPRB,&
&.150E-02_JPRB,.145E-02_JPRB,.135E-02_JPRB,.112E-02_JPRB,.102E-02_JPRB,.101E-02_JPRB,.103E-02_JPRB,&
&.107E-02_JPRB,.108E-02_JPRB,.101E-02_JPRB,.940E-03_JPRB,.890E-03_JPRB,.860E-03_JPRB,.827E-03_JPRB,&
&.813E-03_JPRB,.837E-03_JPRB,.890E-03_JPRB,.921E-03_JPRB,.945E-03_JPRB,.962E-03_JPRB,.974E-03_JPRB,&
&.992E-03_JPRB,.101E-02_JPRB,.101E-02_JPRB,.103E-02_JPRB,.107E-02_JPRB,.121E-02_JPRB,.123E-02_JPRB,&
&.121E-02_JPRB,.115E-02_JPRB,.109E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.106E-02_JPRB,.105E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.102E-02_JPRB,.102E-02_JPRB,&
&.106E-02_JPRB,.112E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  8  62.0
ZAER (:, 8, 2) = (/&
&.150E-02_JPRB,.150E-02_JPRB,.153E-02_JPRB,.154E-02_JPRB,.148E-02_JPRB,.139E-02_JPRB,.130E-02_JPRB,&
&.120E-02_JPRB,.113E-02_JPRB,.107E-02_JPRB,.990E-03_JPRB,.913E-03_JPRB,.851E-03_JPRB,.817E-03_JPRB,&
&.803E-03_JPRB,.818E-03_JPRB,.857E-03_JPRB,.922E-03_JPRB,.100E-02_JPRB,.110E-02_JPRB,.121E-02_JPRB,&
&.140E-02_JPRB,.186E-02_JPRB,.240E-02_JPRB,.271E-02_JPRB,.257E-02_JPRB,.227E-02_JPRB,.210E-02_JPRB,&
&.191E-02_JPRB,.171E-02_JPRB,.152E-02_JPRB,.134E-02_JPRB,.119E-02_JPRB,.108E-02_JPRB,.105E-02_JPRB,&
&.107E-02_JPRB,.113E-02_JPRB,.116E-02_JPRB,.114E-02_JPRB,.109E-02_JPRB,.105E-02_JPRB,.103E-02_JPRB,&
&.999E-03_JPRB,.979E-03_JPRB,.993E-03_JPRB,.104E-02_JPRB,.104E-02_JPRB,.108E-02_JPRB,.114E-02_JPRB,&
&.121E-02_JPRB,.121E-02_JPRB,.113E-02_JPRB,.110E-02_JPRB,.113E-02_JPRB,.126E-02_JPRB,.139E-02_JPRB,&
&.140E-02_JPRB,.139E-02_JPRB,.135E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.128E-02_JPRB,.123E-02_JPRB,&
&.124E-02_JPRB,.127E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.129E-02_JPRB,.134E-02_JPRB,.140E-02_JPRB,&
&.146E-02_JPRB,.149E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat:  9  58.0
ZAER (:, 9, 2) = (/&
&.208E-02_JPRB,.207E-02_JPRB,.204E-02_JPRB,.199E-02_JPRB,.189E-02_JPRB,.175E-02_JPRB,.161E-02_JPRB,&
&.147E-02_JPRB,.137E-02_JPRB,.129E-02_JPRB,.120E-02_JPRB,.111E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,&
&.109E-02_JPRB,.114E-02_JPRB,.121E-02_JPRB,.131E-02_JPRB,.141E-02_JPRB,.151E-02_JPRB,.158E-02_JPRB,&
&.193E-02_JPRB,.343E-02_JPRB,.574E-02_JPRB,.507E-02_JPRB,.397E-02_JPRB,.305E-02_JPRB,.252E-02_JPRB,&
&.231E-02_JPRB,.212E-02_JPRB,.193E-02_JPRB,.184E-02_JPRB,.166E-02_JPRB,.144E-02_JPRB,.129E-02_JPRB,&
&.125E-02_JPRB,.129E-02_JPRB,.131E-02_JPRB,.132E-02_JPRB,.136E-02_JPRB,.139E-02_JPRB,.140E-02_JPRB,&
&.142E-02_JPRB,.143E-02_JPRB,.144E-02_JPRB,.146E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,.152E-02_JPRB,&
&.157E-02_JPRB,.152E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,.144E-02_JPRB,.149E-02_JPRB,.157E-02_JPRB,&
&.164E-02_JPRB,.165E-02_JPRB,.164E-02_JPRB,.163E-02_JPRB,.164E-02_JPRB,.162E-02_JPRB,.156E-02_JPRB,&
&.156E-02_JPRB,.161E-02_JPRB,.166E-02_JPRB,.175E-02_JPRB,.185E-02_JPRB,.193E-02_JPRB,.200E-02_JPRB,&
&.210E-02_JPRB,.210E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 10  54.0
ZAER (:,10, 2) = (/&
&.298E-02_JPRB,.295E-02_JPRB,.287E-02_JPRB,.274E-02_JPRB,.257E-02_JPRB,.236E-02_JPRB,.214E-02_JPRB,&
&.192E-02_JPRB,.177E-02_JPRB,.167E-02_JPRB,.157E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.156E-02_JPRB,&
&.162E-02_JPRB,.168E-02_JPRB,.178E-02_JPRB,.188E-02_JPRB,.196E-02_JPRB,.203E-02_JPRB,.219E-02_JPRB,&
&.320E-02_JPRB,.119E-01_JPRB,.155E-01_JPRB,.112E-01_JPRB,.858E-02_JPRB,.629E-02_JPRB,.443E-02_JPRB,&
&.342E-02_JPRB,.302E-02_JPRB,.275E-02_JPRB,.261E-02_JPRB,.242E-02_JPRB,.221E-02_JPRB,.200E-02_JPRB,&
&.188E-02_JPRB,.179E-02_JPRB,.172E-02_JPRB,.177E-02_JPRB,.193E-02_JPRB,.208E-02_JPRB,.218E-02_JPRB,&
&.223E-02_JPRB,.227E-02_JPRB,.229E-02_JPRB,.226E-02_JPRB,.217E-02_JPRB,.204E-02_JPRB,.199E-02_JPRB,&
&.197E-02_JPRB,.193E-02_JPRB,.190E-02_JPRB,.193E-02_JPRB,.197E-02_JPRB,.195E-02_JPRB,.195E-02_JPRB,&
&.199E-02_JPRB,.207E-02_JPRB,.213E-02_JPRB,.212E-02_JPRB,.209E-02_JPRB,.206E-02_JPRB,.205E-02_JPRB,&
&.215E-02_JPRB,.224E-02_JPRB,.235E-02_JPRB,.251E-02_JPRB,.268E-02_JPRB,.285E-02_JPRB,.290E-02_JPRB,&
&.297E-02_JPRB,.297E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 11  50.0
ZAER (:,11, 2) = (/&
&.465E-02_JPRB,.441E-02_JPRB,.413E-02_JPRB,.380E-02_JPRB,.352E-02_JPRB,.326E-02_JPRB,.299E-02_JPRB,&
&.268E-02_JPRB,.241E-02_JPRB,.227E-02_JPRB,.219E-02_JPRB,.214E-02_JPRB,.214E-02_JPRB,.219E-02_JPRB,&
&.225E-02_JPRB,.232E-02_JPRB,.237E-02_JPRB,.241E-02_JPRB,.242E-02_JPRB,.244E-02_JPRB,.329E-02_JPRB,&
&.514E-02_JPRB,.198E-01_JPRB,.393E-01_JPRB,.313E-01_JPRB,.210E-01_JPRB,.143E-01_JPRB,.968E-02_JPRB,&
&.687E-02_JPRB,.540E-02_JPRB,.458E-02_JPRB,.411E-02_JPRB,.371E-02_JPRB,.335E-02_JPRB,.307E-02_JPRB,&
&.288E-02_JPRB,.286E-02_JPRB,.299E-02_JPRB,.320E-02_JPRB,.342E-02_JPRB,.357E-02_JPRB,.364E-02_JPRB,&
&.365E-02_JPRB,.357E-02_JPRB,.346E-02_JPRB,.334E-02_JPRB,.320E-02_JPRB,.299E-02_JPRB,.276E-02_JPRB,&
&.258E-02_JPRB,.248E-02_JPRB,.244E-02_JPRB,.243E-02_JPRB,.240E-02_JPRB,.246E-02_JPRB,.258E-02_JPRB,&
&.275E-02_JPRB,.286E-02_JPRB,.288E-02_JPRB,.284E-02_JPRB,.288E-02_JPRB,.288E-02_JPRB,.299E-02_JPRB,&
&.318E-02_JPRB,.323E-02_JPRB,.365E-02_JPRB,.400E-02_JPRB,.447E-02_JPRB,.480E-02_JPRB,.492E-02_JPRB,&
&.504E-02_JPRB,.489E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 12  46.0
ZAER (:,12, 2) = (/&
&.721E-02_JPRB,.678E-02_JPRB,.608E-02_JPRB,.526E-02_JPRB,.464E-02_JPRB,.421E-02_JPRB,.387E-02_JPRB,&
&.359E-02_JPRB,.329E-02_JPRB,.303E-02_JPRB,.287E-02_JPRB,.277E-02_JPRB,.275E-02_JPRB,.274E-02_JPRB,&
&.277E-02_JPRB,.283E-02_JPRB,.286E-02_JPRB,.285E-02_JPRB,.283E-02_JPRB,.288E-02_JPRB,.486E-02_JPRB,&
&.154E-01_JPRB,.609E-01_JPRB,.110E+00_JPRB,.454E-01_JPRB,.213E-01_JPRB,.159E-01_JPRB,.123E-01_JPRB,&
&.969E-02_JPRB,.823E-02_JPRB,.725E-02_JPRB,.638E-02_JPRB,.565E-02_JPRB,.517E-02_JPRB,.490E-02_JPRB,&
&.477E-02_JPRB,.492E-02_JPRB,.520E-02_JPRB,.540E-02_JPRB,.544E-02_JPRB,.545E-02_JPRB,.543E-02_JPRB,&
&.530E-02_JPRB,.514E-02_JPRB,.496E-02_JPRB,.472E-02_JPRB,.448E-02_JPRB,.420E-02_JPRB,.384E-02_JPRB,&
&.348E-02_JPRB,.324E-02_JPRB,.313E-02_JPRB,.310E-02_JPRB,.322E-02_JPRB,.347E-02_JPRB,.364E-02_JPRB,&
&.392E-02_JPRB,.405E-02_JPRB,.405E-02_JPRB,.426E-02_JPRB,.461E-02_JPRB,.462E-02_JPRB,.501E-02_JPRB,&
&.478E-02_JPRB,.475E-02_JPRB,.565E-02_JPRB,.563E-02_JPRB,.574E-02_JPRB,.597E-02_JPRB,.675E-02_JPRB,&
&.737E-02_JPRB,.745E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 13  42.0
ZAER (:,13, 2) = (/&
&.100E-01_JPRB,.937E-02_JPRB,.817E-02_JPRB,.686E-02_JPRB,.600E-02_JPRB,.537E-02_JPRB,.480E-02_JPRB,&
&.436E-02_JPRB,.406E-02_JPRB,.381E-02_JPRB,.361E-02_JPRB,.350E-02_JPRB,.354E-02_JPRB,.355E-02_JPRB,&
&.359E-02_JPRB,.359E-02_JPRB,.357E-02_JPRB,.357E-02_JPRB,.361E-02_JPRB,.373E-02_JPRB,.112E-01_JPRB,&
&.482E-01_JPRB,.985E-01_JPRB,.120E+00_JPRB,.511E-01_JPRB,.282E-01_JPRB,.201E-01_JPRB,.152E-01_JPRB,&
&.115E-01_JPRB,.934E-02_JPRB,.831E-02_JPRB,.767E-02_JPRB,.708E-02_JPRB,.668E-02_JPRB,.655E-02_JPRB,&
&.653E-02_JPRB,.660E-02_JPRB,.655E-02_JPRB,.649E-02_JPRB,.649E-02_JPRB,.666E-02_JPRB,.665E-02_JPRB,&
&.647E-02_JPRB,.631E-02_JPRB,.622E-02_JPRB,.600E-02_JPRB,.569E-02_JPRB,.534E-02_JPRB,.492E-02_JPRB,&
&.454E-02_JPRB,.426E-02_JPRB,.411E-02_JPRB,.416E-02_JPRB,.453E-02_JPRB,.490E-02_JPRB,.528E-02_JPRB,&
&.612E-02_JPRB,.627E-02_JPRB,.619E-02_JPRB,.743E-02_JPRB,.837E-02_JPRB,.830E-02_JPRB,.804E-02_JPRB,&
&.731E-02_JPRB,.834E-02_JPRB,.817E-02_JPRB,.708E-02_JPRB,.678E-02_JPRB,.794E-02_JPRB,.967E-02_JPRB,&
&.103E-01_JPRB,.102E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 14  38.0
ZAER (:,14, 2) = (/&
&.125E-01_JPRB,.112E-01_JPRB,.961E-02_JPRB,.844E-02_JPRB,.769E-02_JPRB,.716E-02_JPRB,.679E-02_JPRB,&
&.627E-02_JPRB,.576E-02_JPRB,.541E-02_JPRB,.512E-02_JPRB,.492E-02_JPRB,.497E-02_JPRB,.499E-02_JPRB,&
&.495E-02_JPRB,.486E-02_JPRB,.485E-02_JPRB,.494E-02_JPRB,.494E-02_JPRB,.570E-02_JPRB,.174E-01_JPRB,&
&.479E-01_JPRB,.645E-01_JPRB,.560E-01_JPRB,.302E-01_JPRB,.211E-01_JPRB,.159E-01_JPRB,.133E-01_JPRB,&
&.114E-01_JPRB,.100E-01_JPRB,.928E-02_JPRB,.879E-02_JPRB,.825E-02_JPRB,.774E-02_JPRB,.734E-02_JPRB,&
&.708E-02_JPRB,.687E-02_JPRB,.652E-02_JPRB,.633E-02_JPRB,.645E-02_JPRB,.688E-02_JPRB,.750E-02_JPRB,&
&.740E-02_JPRB,.707E-02_JPRB,.672E-02_JPRB,.638E-02_JPRB,.602E-02_JPRB,.580E-02_JPRB,.558E-02_JPRB,&
&.528E-02_JPRB,.502E-02_JPRB,.491E-02_JPRB,.525E-02_JPRB,.608E-02_JPRB,.694E-02_JPRB,.842E-02_JPRB,&
&.916E-02_JPRB,.889E-02_JPRB,.886E-02_JPRB,.127E-01_JPRB,.153E-01_JPRB,.142E-01_JPRB,.127E-01_JPRB,&
&.140E-01_JPRB,.201E-01_JPRB,.139E-01_JPRB,.100E-01_JPRB,.112E-01_JPRB,.145E-01_JPRB,.155E-01_JPRB,&
&.146E-01_JPRB,.135E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 15  34.0
ZAER (:,15, 2) = (/&
&.145E-01_JPRB,.119E-01_JPRB,.984E-02_JPRB,.883E-02_JPRB,.863E-02_JPRB,.870E-02_JPRB,.874E-02_JPRB,&
&.889E-02_JPRB,.895E-02_JPRB,.879E-02_JPRB,.837E-02_JPRB,.789E-02_JPRB,.766E-02_JPRB,.720E-02_JPRB,&
&.668E-02_JPRB,.630E-02_JPRB,.614E-02_JPRB,.607E-02_JPRB,.601E-02_JPRB,.753E-02_JPRB,.166E-01_JPRB,&
&.302E-01_JPRB,.291E-01_JPRB,.263E-01_JPRB,.191E-01_JPRB,.144E-01_JPRB,.115E-01_JPRB,.107E-01_JPRB,&
&.102E-01_JPRB,.992E-02_JPRB,.964E-02_JPRB,.908E-02_JPRB,.854E-02_JPRB,.802E-02_JPRB,.769E-02_JPRB,&
&.740E-02_JPRB,.705E-02_JPRB,.654E-02_JPRB,.621E-02_JPRB,.727E-02_JPRB,.111E-01_JPRB,.137E-01_JPRB,&
&.116E-01_JPRB,.950E-02_JPRB,.781E-02_JPRB,.702E-02_JPRB,.645E-02_JPRB,.602E-02_JPRB,.582E-02_JPRB,&
&.560E-02_JPRB,.552E-02_JPRB,.609E-02_JPRB,.741E-02_JPRB,.940E-02_JPRB,.120E-01_JPRB,.149E-01_JPRB,&
&.157E-01_JPRB,.171E-01_JPRB,.210E-01_JPRB,.350E-01_JPRB,.510E-01_JPRB,.446E-01_JPRB,.362E-01_JPRB,&
&.412E-01_JPRB,.347E-01_JPRB,.220E-01_JPRB,.254E-01_JPRB,.284E-01_JPRB,.281E-01_JPRB,.264E-01_JPRB,&
&.224E-01_JPRB,.180E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 16  30.0
ZAER (:,16, 2) = (/&
&.166E-01_JPRB,.131E-01_JPRB,.109E-01_JPRB,.101E-01_JPRB,.101E-01_JPRB,.105E-01_JPRB,.987E-02_JPRB,&
&.914E-02_JPRB,.864E-02_JPRB,.838E-02_JPRB,.814E-02_JPRB,.803E-02_JPRB,.778E-02_JPRB,.710E-02_JPRB,&
&.662E-02_JPRB,.629E-02_JPRB,.640E-02_JPRB,.675E-02_JPRB,.720E-02_JPRB,.941E-02_JPRB,.165E-01_JPRB,&
&.213E-01_JPRB,.205E-01_JPRB,.208E-01_JPRB,.162E-01_JPRB,.123E-01_JPRB,.981E-02_JPRB,.859E-02_JPRB,&
&.791E-02_JPRB,.738E-02_JPRB,.733E-02_JPRB,.749E-02_JPRB,.759E-02_JPRB,.750E-02_JPRB,.721E-02_JPRB,&
&.688E-02_JPRB,.681E-02_JPRB,.669E-02_JPRB,.774E-02_JPRB,.132E-01_JPRB,.226E-01_JPRB,.238E-01_JPRB,&
&.167E-01_JPRB,.115E-01_JPRB,.847E-02_JPRB,.740E-02_JPRB,.652E-02_JPRB,.594E-02_JPRB,.584E-02_JPRB,&
&.587E-02_JPRB,.613E-02_JPRB,.771E-02_JPRB,.116E-01_JPRB,.161E-01_JPRB,.217E-01_JPRB,.268E-01_JPRB,&
&.299E-01_JPRB,.365E-01_JPRB,.501E-01_JPRB,.701E-01_JPRB,.984E-01_JPRB,.102E+00_JPRB,.832E-01_JPRB,&
&.639E-01_JPRB,.460E-01_JPRB,.495E-01_JPRB,.551E-01_JPRB,.429E-01_JPRB,.378E-01_JPRB,.367E-01_JPRB,&
&.309E-01_JPRB,.233E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 17  26.0
ZAER (:,17, 2) = (/&
&.201E-01_JPRB,.169E-01_JPRB,.149E-01_JPRB,.131E-01_JPRB,.116E-01_JPRB,.102E-01_JPRB,.815E-02_JPRB,&
&.599E-02_JPRB,.465E-02_JPRB,.411E-02_JPRB,.427E-02_JPRB,.478E-02_JPRB,.537E-02_JPRB,.571E-02_JPRB,&
&.556E-02_JPRB,.554E-02_JPRB,.630E-02_JPRB,.737E-02_JPRB,.900E-02_JPRB,.116E-01_JPRB,.157E-01_JPRB,&
&.174E-01_JPRB,.188E-01_JPRB,.180E-01_JPRB,.162E-01_JPRB,.118E-01_JPRB,.901E-02_JPRB,.707E-02_JPRB,&
&.591E-02_JPRB,.591E-02_JPRB,.660E-02_JPRB,.727E-02_JPRB,.751E-02_JPRB,.711E-02_JPRB,.655E-02_JPRB,&
&.642E-02_JPRB,.681E-02_JPRB,.789E-02_JPRB,.119E-01_JPRB,.207E-01_JPRB,.257E-01_JPRB,.226E-01_JPRB,&
&.161E-01_JPRB,.114E-01_JPRB,.834E-02_JPRB,.697E-02_JPRB,.564E-02_JPRB,.549E-02_JPRB,.566E-02_JPRB,&
&.594E-02_JPRB,.686E-02_JPRB,.107E-01_JPRB,.178E-01_JPRB,.240E-01_JPRB,.295E-01_JPRB,.366E-01_JPRB,&
&.444E-01_JPRB,.573E-01_JPRB,.756E-01_JPRB,.104E+00_JPRB,.127E+00_JPRB,.124E+00_JPRB,.107E+00_JPRB,&
&.874E-01_JPRB,.744E-01_JPRB,.914E-01_JPRB,.582E-01_JPRB,.388E-01_JPRB,.326E-01_JPRB,.335E-01_JPRB,&
&.326E-01_JPRB,.271E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 18  22.0
ZAER (:,18, 2) = (/&
&.186E-01_JPRB,.145E-01_JPRB,.109E-01_JPRB,.830E-02_JPRB,.607E-02_JPRB,.407E-02_JPRB,.288E-02_JPRB,&
&.227E-02_JPRB,.205E-02_JPRB,.227E-02_JPRB,.269E-02_JPRB,.304E-02_JPRB,.359E-02_JPRB,.456E-02_JPRB,&
&.533E-02_JPRB,.605E-02_JPRB,.696E-02_JPRB,.825E-02_JPRB,.102E-01_JPRB,.122E-01_JPRB,.148E-01_JPRB,&
&.169E-01_JPRB,.200E-01_JPRB,.173E-01_JPRB,.146E-01_JPRB,.785E-02_JPRB,.568E-02_JPRB,.514E-02_JPRB,&
&.547E-02_JPRB,.632E-02_JPRB,.725E-02_JPRB,.756E-02_JPRB,.753E-02_JPRB,.719E-02_JPRB,.700E-02_JPRB,&
&.735E-02_JPRB,.832E-02_JPRB,.107E-01_JPRB,.163E-01_JPRB,.222E-01_JPRB,.184E-01_JPRB,.126E-01_JPRB,&
&.910E-02_JPRB,.727E-02_JPRB,.497E-02_JPRB,.427E-02_JPRB,.421E-02_JPRB,.482E-02_JPRB,.621E-02_JPRB,&
&.897E-02_JPRB,.141E-01_JPRB,.222E-01_JPRB,.329E-01_JPRB,.398E-01_JPRB,.461E-01_JPRB,.549E-01_JPRB,&
&.632E-01_JPRB,.698E-01_JPRB,.799E-01_JPRB,.935E-01_JPRB,.109E+00_JPRB,.111E+00_JPRB,.108E+00_JPRB,&
&.993E-01_JPRB,.725E-01_JPRB,.479E-01_JPRB,.278E-01_JPRB,.197E-01_JPRB,.166E-01_JPRB,.200E-01_JPRB,&
&.235E-01_JPRB,.226E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 19  18.0
ZAER (:,19, 2) = (/&
&.961E-02_JPRB,.634E-02_JPRB,.397E-02_JPRB,.282E-02_JPRB,.242E-02_JPRB,.191E-02_JPRB,.172E-02_JPRB,&
&.183E-02_JPRB,.216E-02_JPRB,.251E-02_JPRB,.282E-02_JPRB,.315E-02_JPRB,.354E-02_JPRB,.418E-02_JPRB,&
&.514E-02_JPRB,.643E-02_JPRB,.794E-02_JPRB,.100E-01_JPRB,.122E-01_JPRB,.139E-01_JPRB,.159E-01_JPRB,&
&.157E-01_JPRB,.121E-01_JPRB,.979E-02_JPRB,.682E-02_JPRB,.387E-02_JPRB,.395E-02_JPRB,.488E-02_JPRB,&
&.607E-02_JPRB,.683E-02_JPRB,.738E-02_JPRB,.742E-02_JPRB,.746E-02_JPRB,.741E-02_JPRB,.763E-02_JPRB,&
&.810E-02_JPRB,.925E-02_JPRB,.111E-01_JPRB,.131E-01_JPRB,.121E-01_JPRB,.765E-02_JPRB,.542E-02_JPRB,&
&.444E-02_JPRB,.345E-02_JPRB,.264E-02_JPRB,.269E-02_JPRB,.306E-02_JPRB,.359E-02_JPRB,.506E-02_JPRB,&
&.849E-02_JPRB,.161E-01_JPRB,.283E-01_JPRB,.419E-01_JPRB,.531E-01_JPRB,.649E-01_JPRB,.725E-01_JPRB,&
&.727E-01_JPRB,.647E-01_JPRB,.592E-01_JPRB,.573E-01_JPRB,.635E-01_JPRB,.670E-01_JPRB,.645E-01_JPRB,&
&.540E-01_JPRB,.307E-01_JPRB,.144E-01_JPRB,.826E-02_JPRB,.691E-02_JPRB,.810E-02_JPRB,.130E-01_JPRB,&
&.149E-01_JPRB,.130E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 20  14.0
ZAER (:,20, 2) = (/&
&.237E-02_JPRB,.151E-02_JPRB,.108E-02_JPRB,.125E-02_JPRB,.150E-02_JPRB,.152E-02_JPRB,.174E-02_JPRB,&
&.228E-02_JPRB,.285E-02_JPRB,.320E-02_JPRB,.347E-02_JPRB,.395E-02_JPRB,.441E-02_JPRB,.505E-02_JPRB,&
&.609E-02_JPRB,.742E-02_JPRB,.914E-02_JPRB,.111E-01_JPRB,.126E-01_JPRB,.131E-01_JPRB,.129E-01_JPRB,&
&.111E-01_JPRB,.743E-02_JPRB,.419E-02_JPRB,.295E-02_JPRB,.348E-02_JPRB,.505E-02_JPRB,.661E-02_JPRB,&
&.759E-02_JPRB,.740E-02_JPRB,.744E-02_JPRB,.743E-02_JPRB,.762E-02_JPRB,.759E-02_JPRB,.752E-02_JPRB,&
&.756E-02_JPRB,.777E-02_JPRB,.775E-02_JPRB,.752E-02_JPRB,.575E-02_JPRB,.334E-02_JPRB,.250E-02_JPRB,&
&.200E-02_JPRB,.167E-02_JPRB,.157E-02_JPRB,.166E-02_JPRB,.189E-02_JPRB,.222E-02_JPRB,.330E-02_JPRB,&
&.554E-02_JPRB,.104E-01_JPRB,.199E-01_JPRB,.298E-01_JPRB,.362E-01_JPRB,.415E-01_JPRB,.433E-01_JPRB,&
&.418E-01_JPRB,.359E-01_JPRB,.283E-01_JPRB,.263E-01_JPRB,.267E-01_JPRB,.233E-01_JPRB,.168E-01_JPRB,&
&.121E-01_JPRB,.580E-02_JPRB,.225E-02_JPRB,.163E-02_JPRB,.171E-02_JPRB,.215E-02_JPRB,.340E-02_JPRB,&
&.406E-02_JPRB,.317E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 21  10.0
ZAER (:,21, 2) = (/&
&.729E-03_JPRB,.705E-03_JPRB,.795E-03_JPRB,.108E-02_JPRB,.136E-02_JPRB,.158E-02_JPRB,.205E-02_JPRB,&
&.276E-02_JPRB,.339E-02_JPRB,.389E-02_JPRB,.435E-02_JPRB,.490E-02_JPRB,.565E-02_JPRB,.633E-02_JPRB,&
&.677E-02_JPRB,.758E-02_JPRB,.845E-02_JPRB,.927E-02_JPRB,.101E-01_JPRB,.100E-01_JPRB,.844E-02_JPRB,&
&.678E-02_JPRB,.427E-02_JPRB,.272E-02_JPRB,.272E-02_JPRB,.414E-02_JPRB,.668E-02_JPRB,.102E-01_JPRB,&
&.133E-01_JPRB,.111E-01_JPRB,.819E-02_JPRB,.774E-02_JPRB,.773E-02_JPRB,.746E-02_JPRB,.702E-02_JPRB,&
&.666E-02_JPRB,.618E-02_JPRB,.565E-02_JPRB,.519E-02_JPRB,.420E-02_JPRB,.309E-02_JPRB,.258E-02_JPRB,&
&.206E-02_JPRB,.166E-02_JPRB,.143E-02_JPRB,.144E-02_JPRB,.159E-02_JPRB,.196E-02_JPRB,.286E-02_JPRB,&
&.431E-02_JPRB,.715E-02_JPRB,.121E-01_JPRB,.162E-01_JPRB,.170E-01_JPRB,.165E-01_JPRB,.147E-01_JPRB,&
&.122E-01_JPRB,.898E-02_JPRB,.803E-02_JPRB,.805E-02_JPRB,.595E-02_JPRB,.418E-02_JPRB,.330E-02_JPRB,&
&.182E-02_JPRB,.840E-03_JPRB,.499E-03_JPRB,.659E-03_JPRB,.727E-03_JPRB,.776E-03_JPRB,.931E-03_JPRB,&
&.845E-03_JPRB,.754E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 22   6.0
ZAER (:,22, 2) = (/&
&.748E-03_JPRB,.867E-03_JPRB,.106E-02_JPRB,.133E-02_JPRB,.168E-02_JPRB,.220E-02_JPRB,.291E-02_JPRB,&
&.358E-02_JPRB,.413E-02_JPRB,.467E-02_JPRB,.523E-02_JPRB,.592E-02_JPRB,.677E-02_JPRB,.741E-02_JPRB,&
&.762E-02_JPRB,.783E-02_JPRB,.797E-02_JPRB,.832E-02_JPRB,.911E-02_JPRB,.956E-02_JPRB,.793E-02_JPRB,&
&.587E-02_JPRB,.417E-02_JPRB,.342E-02_JPRB,.338E-02_JPRB,.448E-02_JPRB,.677E-02_JPRB,.106E-01_JPRB,&
&.135E-01_JPRB,.116E-01_JPRB,.102E-01_JPRB,.100E-01_JPRB,.101E-01_JPRB,.970E-02_JPRB,.910E-02_JPRB,&
&.824E-02_JPRB,.704E-02_JPRB,.637E-02_JPRB,.635E-02_JPRB,.635E-02_JPRB,.594E-02_JPRB,.546E-02_JPRB,&
&.465E-02_JPRB,.365E-02_JPRB,.281E-02_JPRB,.235E-02_JPRB,.232E-02_JPRB,.251E-02_JPRB,.267E-02_JPRB,&
&.282E-02_JPRB,.320E-02_JPRB,.408E-02_JPRB,.452E-02_JPRB,.409E-02_JPRB,.350E-02_JPRB,.307E-02_JPRB,&
&.262E-02_JPRB,.189E-02_JPRB,.133E-02_JPRB,.117E-02_JPRB,.105E-02_JPRB,.849E-03_JPRB,.605E-03_JPRB,&
&.467E-03_JPRB,.396E-03_JPRB,.427E-03_JPRB,.550E-03_JPRB,.625E-03_JPRB,.685E-03_JPRB,.706E-03_JPRB,&
&.677E-03_JPRB,.667E-03_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 23   2.0
ZAER (:,23, 2) = (/&
&.121E-02_JPRB,.128E-02_JPRB,.142E-02_JPRB,.168E-02_JPRB,.218E-02_JPRB,.297E-02_JPRB,.387E-02_JPRB,&
&.462E-02_JPRB,.531E-02_JPRB,.622E-02_JPRB,.710E-02_JPRB,.767E-02_JPRB,.832E-02_JPRB,.893E-02_JPRB,&
&.949E-02_JPRB,.100E-01_JPRB,.108E-01_JPRB,.116E-01_JPRB,.122E-01_JPRB,.129E-01_JPRB,.120E-01_JPRB,&
&.104E-01_JPRB,.833E-02_JPRB,.747E-02_JPRB,.674E-02_JPRB,.677E-02_JPRB,.805E-02_JPRB,.112E-01_JPRB,&
&.140E-01_JPRB,.152E-01_JPRB,.164E-01_JPRB,.169E-01_JPRB,.172E-01_JPRB,.172E-01_JPRB,.167E-01_JPRB,&
&.155E-01_JPRB,.142E-01_JPRB,.137E-01_JPRB,.143E-01_JPRB,.149E-01_JPRB,.150E-01_JPRB,.157E-01_JPRB,&
&.160E-01_JPRB,.143E-01_JPRB,.107E-01_JPRB,.611E-02_JPRB,.388E-02_JPRB,.364E-02_JPRB,.328E-02_JPRB,&
&.285E-02_JPRB,.243E-02_JPRB,.214E-02_JPRB,.178E-02_JPRB,.150E-02_JPRB,.123E-02_JPRB,.103E-02_JPRB,&
&.817E-03_JPRB,.627E-03_JPRB,.582E-03_JPRB,.606E-03_JPRB,.593E-03_JPRB,.562E-03_JPRB,.624E-03_JPRB,&
&.767E-03_JPRB,.877E-03_JPRB,.103E-02_JPRB,.122E-02_JPRB,.136E-02_JPRB,.141E-02_JPRB,.134E-02_JPRB,&
&.126E-02_JPRB,.118E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 24  -2.0
ZAER (:,24, 2) = (/&
&.310E-02_JPRB,.282E-02_JPRB,.268E-02_JPRB,.278E-02_JPRB,.308E-02_JPRB,.373E-02_JPRB,.477E-02_JPRB,&
&.602E-02_JPRB,.747E-02_JPRB,.917E-02_JPRB,.108E-01_JPRB,.116E-01_JPRB,.123E-01_JPRB,.137E-01_JPRB,&
&.154E-01_JPRB,.162E-01_JPRB,.171E-01_JPRB,.182E-01_JPRB,.192E-01_JPRB,.195E-01_JPRB,.196E-01_JPRB,&
&.199E-01_JPRB,.195E-01_JPRB,.190E-01_JPRB,.177E-01_JPRB,.162E-01_JPRB,.162E-01_JPRB,.197E-01_JPRB,&
&.242E-01_JPRB,.277E-01_JPRB,.300E-01_JPRB,.301E-01_JPRB,.301E-01_JPRB,.303E-01_JPRB,.302E-01_JPRB,&
&.294E-01_JPRB,.294E-01_JPRB,.304E-01_JPRB,.327E-01_JPRB,.357E-01_JPRB,.384E-01_JPRB,.426E-01_JPRB,&
&.461E-01_JPRB,.432E-01_JPRB,.363E-01_JPRB,.266E-01_JPRB,.142E-01_JPRB,.940E-02_JPRB,.827E-02_JPRB,&
&.728E-02_JPRB,.627E-02_JPRB,.521E-02_JPRB,.422E-02_JPRB,.352E-02_JPRB,.303E-02_JPRB,.254E-02_JPRB,&
&.178E-02_JPRB,.113E-02_JPRB,.105E-02_JPRB,.109E-02_JPRB,.117E-02_JPRB,.132E-02_JPRB,.157E-02_JPRB,&
&.194E-02_JPRB,.227E-02_JPRB,.261E-02_JPRB,.300E-02_JPRB,.342E-02_JPRB,.369E-02_JPRB,.369E-02_JPRB,&
&.362E-02_JPRB,.336E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 25  -6.0
ZAER (:,25, 2) = (/&
&.665E-02_JPRB,.582E-02_JPRB,.503E-02_JPRB,.462E-02_JPRB,.473E-02_JPRB,.544E-02_JPRB,.674E-02_JPRB,&
&.839E-02_JPRB,.103E-01_JPRB,.124E-01_JPRB,.147E-01_JPRB,.162E-01_JPRB,.178E-01_JPRB,.205E-01_JPRB,&
&.228E-01_JPRB,.242E-01_JPRB,.261E-01_JPRB,.283E-01_JPRB,.303E-01_JPRB,.317E-01_JPRB,.332E-01_JPRB,&
&.337E-01_JPRB,.341E-01_JPRB,.347E-01_JPRB,.364E-01_JPRB,.372E-01_JPRB,.395E-01_JPRB,.438E-01_JPRB,&
&.505E-01_JPRB,.586E-01_JPRB,.664E-01_JPRB,.699E-01_JPRB,.688E-01_JPRB,.639E-01_JPRB,.607E-01_JPRB,&
&.568E-01_JPRB,.552E-01_JPRB,.555E-01_JPRB,.572E-01_JPRB,.616E-01_JPRB,.664E-01_JPRB,.703E-01_JPRB,&
&.752E-01_JPRB,.773E-01_JPRB,.709E-01_JPRB,.628E-01_JPRB,.417E-01_JPRB,.254E-01_JPRB,.220E-01_JPRB,&
&.198E-01_JPRB,.181E-01_JPRB,.159E-01_JPRB,.134E-01_JPRB,.112E-01_JPRB,.950E-02_JPRB,.844E-02_JPRB,&
&.702E-02_JPRB,.525E-02_JPRB,.367E-02_JPRB,.275E-02_JPRB,.240E-02_JPRB,.252E-02_JPRB,.294E-02_JPRB,&
&.360E-02_JPRB,.426E-02_JPRB,.486E-02_JPRB,.549E-02_JPRB,.622E-02_JPRB,.684E-02_JPRB,.714E-02_JPRB,&
&.742E-02_JPRB,.722E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 26 -10.0
ZAER (:,26, 2) = (/&
&.105E-01_JPRB,.943E-02_JPRB,.807E-02_JPRB,.709E-02_JPRB,.683E-02_JPRB,.771E-02_JPRB,.919E-02_JPRB,&
&.105E-01_JPRB,.120E-01_JPRB,.136E-01_JPRB,.155E-01_JPRB,.182E-01_JPRB,.214E-01_JPRB,.250E-01_JPRB,&
&.281E-01_JPRB,.304E-01_JPRB,.327E-01_JPRB,.348E-01_JPRB,.368E-01_JPRB,.389E-01_JPRB,.413E-01_JPRB,&
&.420E-01_JPRB,.415E-01_JPRB,.432E-01_JPRB,.467E-01_JPRB,.543E-01_JPRB,.666E-01_JPRB,.803E-01_JPRB,&
&.921E-01_JPRB,.107E+00_JPRB,.121E+00_JPRB,.133E+00_JPRB,.141E+00_JPRB,.143E+00_JPRB,.148E+00_JPRB,&
&.147E+00_JPRB,.132E+00_JPRB,.120E+00_JPRB,.113E+00_JPRB,.106E+00_JPRB,.104E+00_JPRB,.110E+00_JPRB,&
&.113E+00_JPRB,.114E+00_JPRB,.112E+00_JPRB,.114E+00_JPRB,.793E-01_JPRB,.523E-01_JPRB,.478E-01_JPRB,&
&.416E-01_JPRB,.368E-01_JPRB,.344E-01_JPRB,.322E-01_JPRB,.300E-01_JPRB,.255E-01_JPRB,.213E-01_JPRB,&
&.183E-01_JPRB,.164E-01_JPRB,.139E-01_JPRB,.918E-02_JPRB,.571E-02_JPRB,.429E-02_JPRB,.473E-02_JPRB,&
&.571E-02_JPRB,.673E-02_JPRB,.767E-02_JPRB,.856E-02_JPRB,.928E-02_JPRB,.982E-02_JPRB,.103E-01_JPRB,&
&.107E-01_JPRB,.109E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 27 -14.0
ZAER (:,27, 2) = (/&
&.130E-01_JPRB,.131E-01_JPRB,.120E-01_JPRB,.107E-01_JPRB,.103E-01_JPRB,.111E-01_JPRB,.124E-01_JPRB,&
&.132E-01_JPRB,.141E-01_JPRB,.153E-01_JPRB,.167E-01_JPRB,.191E-01_JPRB,.215E-01_JPRB,.238E-01_JPRB,&
&.268E-01_JPRB,.299E-01_JPRB,.328E-01_JPRB,.336E-01_JPRB,.337E-01_JPRB,.341E-01_JPRB,.345E-01_JPRB,&
&.346E-01_JPRB,.357E-01_JPRB,.388E-01_JPRB,.448E-01_JPRB,.561E-01_JPRB,.703E-01_JPRB,.855E-01_JPRB,&
&.101E+00_JPRB,.119E+00_JPRB,.135E+00_JPRB,.149E+00_JPRB,.166E+00_JPRB,.185E+00_JPRB,.211E+00_JPRB,&
&.248E+00_JPRB,.259E+00_JPRB,.207E+00_JPRB,.168E+00_JPRB,.172E+00_JPRB,.152E+00_JPRB,.139E+00_JPRB,&
&.144E+00_JPRB,.156E+00_JPRB,.168E+00_JPRB,.187E+00_JPRB,.157E+00_JPRB,.929E-01_JPRB,.775E-01_JPRB,&
&.671E-01_JPRB,.573E-01_JPRB,.533E-01_JPRB,.488E-01_JPRB,.445E-01_JPRB,.409E-01_JPRB,.363E-01_JPRB,&
&.332E-01_JPRB,.294E-01_JPRB,.243E-01_JPRB,.196E-01_JPRB,.144E-01_JPRB,.811E-02_JPRB,.623E-02_JPRB,&
&.686E-02_JPRB,.794E-02_JPRB,.901E-02_JPRB,.100E-01_JPRB,.108E-01_JPRB,.114E-01_JPRB,.116E-01_JPRB,&
&.119E-01_JPRB,.125E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 28 -18.0
ZAER (:,28, 2) = (/&
&.151E-01_JPRB,.162E-01_JPRB,.166E-01_JPRB,.153E-01_JPRB,.139E-01_JPRB,.145E-01_JPRB,.156E-01_JPRB,&
&.157E-01_JPRB,.160E-01_JPRB,.171E-01_JPRB,.188E-01_JPRB,.211E-01_JPRB,.235E-01_JPRB,.247E-01_JPRB,&
&.258E-01_JPRB,.305E-01_JPRB,.369E-01_JPRB,.382E-01_JPRB,.375E-01_JPRB,.356E-01_JPRB,.329E-01_JPRB,&
&.306E-01_JPRB,.298E-01_JPRB,.314E-01_JPRB,.371E-01_JPRB,.474E-01_JPRB,.591E-01_JPRB,.725E-01_JPRB,&
&.878E-01_JPRB,.100E+00_JPRB,.115E+00_JPRB,.130E+00_JPRB,.144E+00_JPRB,.153E+00_JPRB,.163E+00_JPRB,&
&.163E+00_JPRB,.148E+00_JPRB,.146E+00_JPRB,.134E+00_JPRB,.137E+00_JPRB,.131E+00_JPRB,.127E+00_JPRB,&
&.136E+00_JPRB,.152E+00_JPRB,.202E+00_JPRB,.251E+00_JPRB,.208E+00_JPRB,.139E+00_JPRB,.107E+00_JPRB,&
&.954E-01_JPRB,.813E-01_JPRB,.743E-01_JPRB,.675E-01_JPRB,.570E-01_JPRB,.515E-01_JPRB,.494E-01_JPRB,&
&.474E-01_JPRB,.419E-01_JPRB,.351E-01_JPRB,.293E-01_JPRB,.237E-01_JPRB,.161E-01_JPRB,.109E-01_JPRB,&
&.893E-02_JPRB,.908E-02_JPRB,.101E-01_JPRB,.113E-01_JPRB,.126E-01_JPRB,.139E-01_JPRB,.141E-01_JPRB,&
&.136E-01_JPRB,.140E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 29 -22.0
ZAER (:,29, 2) = (/&
&.177E-01_JPRB,.184E-01_JPRB,.189E-01_JPRB,.183E-01_JPRB,.168E-01_JPRB,.169E-01_JPRB,.176E-01_JPRB,&
&.171E-01_JPRB,.171E-01_JPRB,.180E-01_JPRB,.197E-01_JPRB,.217E-01_JPRB,.242E-01_JPRB,.294E-01_JPRB,&
&.323E-01_JPRB,.340E-01_JPRB,.439E-01_JPRB,.447E-01_JPRB,.462E-01_JPRB,.468E-01_JPRB,.371E-01_JPRB,&
&.291E-01_JPRB,.283E-01_JPRB,.274E-01_JPRB,.289E-01_JPRB,.352E-01_JPRB,.457E-01_JPRB,.562E-01_JPRB,&
&.647E-01_JPRB,.722E-01_JPRB,.808E-01_JPRB,.874E-01_JPRB,.922E-01_JPRB,.900E-01_JPRB,.980E-01_JPRB,&
&.123E+00_JPRB,.110E+00_JPRB,.100E+00_JPRB,.104E+00_JPRB,.108E+00_JPRB,.100E+00_JPRB,.987E-01_JPRB,&
&.113E+00_JPRB,.130E+00_JPRB,.182E+00_JPRB,.199E+00_JPRB,.136E+00_JPRB,.124E+00_JPRB,.110E+00_JPRB,&
&.114E+00_JPRB,.101E+00_JPRB,.849E-01_JPRB,.744E-01_JPRB,.665E-01_JPRB,.616E-01_JPRB,.576E-01_JPRB,&
&.547E-01_JPRB,.511E-01_JPRB,.464E-01_JPRB,.403E-01_JPRB,.345E-01_JPRB,.272E-01_JPRB,.209E-01_JPRB,&
&.165E-01_JPRB,.137E-01_JPRB,.125E-01_JPRB,.130E-01_JPRB,.141E-01_JPRB,.154E-01_JPRB,.165E-01_JPRB,&
&.171E-01_JPRB,.176E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 30 -26.0
ZAER (:,30, 2) = (/&
&.220E-01_JPRB,.212E-01_JPRB,.206E-01_JPRB,.196E-01_JPRB,.182E-01_JPRB,.183E-01_JPRB,.184E-01_JPRB,&
&.177E-01_JPRB,.176E-01_JPRB,.178E-01_JPRB,.180E-01_JPRB,.193E-01_JPRB,.236E-01_JPRB,.330E-01_JPRB,&
&.380E-01_JPRB,.491E-01_JPRB,.696E-01_JPRB,.531E-01_JPRB,.411E-01_JPRB,.343E-01_JPRB,.297E-01_JPRB,&
&.260E-01_JPRB,.248E-01_JPRB,.240E-01_JPRB,.241E-01_JPRB,.261E-01_JPRB,.338E-01_JPRB,.435E-01_JPRB,&
&.472E-01_JPRB,.465E-01_JPRB,.427E-01_JPRB,.410E-01_JPRB,.480E-01_JPRB,.643E-01_JPRB,.810E-01_JPRB,&
&.117E+00_JPRB,.154E+00_JPRB,.119E+00_JPRB,.964E-01_JPRB,.974E-01_JPRB,.815E-01_JPRB,.726E-01_JPRB,&
&.810E-01_JPRB,.993E-01_JPRB,.134E+00_JPRB,.130E+00_JPRB,.856E-01_JPRB,.683E-01_JPRB,.737E-01_JPRB,&
&.911E-01_JPRB,.101E+00_JPRB,.891E-01_JPRB,.774E-01_JPRB,.687E-01_JPRB,.618E-01_JPRB,.550E-01_JPRB,&
&.517E-01_JPRB,.514E-01_JPRB,.517E-01_JPRB,.474E-01_JPRB,.429E-01_JPRB,.378E-01_JPRB,.324E-01_JPRB,&
&.279E-01_JPRB,.239E-01_JPRB,.204E-01_JPRB,.188E-01_JPRB,.185E-01_JPRB,.189E-01_JPRB,.201E-01_JPRB,&
&.217E-01_JPRB,.227E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 31 -30.0
ZAER (:,31, 2) = (/&
&.249E-01_JPRB,.224E-01_JPRB,.206E-01_JPRB,.193E-01_JPRB,.181E-01_JPRB,.178E-01_JPRB,.181E-01_JPRB,&
&.174E-01_JPRB,.163E-01_JPRB,.154E-01_JPRB,.149E-01_JPRB,.151E-01_JPRB,.193E-01_JPRB,.332E-01_JPRB,&
&.364E-01_JPRB,.552E-01_JPRB,.867E-01_JPRB,.599E-01_JPRB,.396E-01_JPRB,.299E-01_JPRB,.247E-01_JPRB,&
&.216E-01_JPRB,.199E-01_JPRB,.195E-01_JPRB,.196E-01_JPRB,.200E-01_JPRB,.234E-01_JPRB,.275E-01_JPRB,&
&.315E-01_JPRB,.318E-01_JPRB,.295E-01_JPRB,.247E-01_JPRB,.269E-01_JPRB,.405E-01_JPRB,.432E-01_JPRB,&
&.528E-01_JPRB,.857E-01_JPRB,.962E-01_JPRB,.927E-01_JPRB,.977E-01_JPRB,.720E-01_JPRB,.575E-01_JPRB,&
&.695E-01_JPRB,.773E-01_JPRB,.858E-01_JPRB,.784E-01_JPRB,.505E-01_JPRB,.362E-01_JPRB,.354E-01_JPRB,&
&.447E-01_JPRB,.587E-01_JPRB,.672E-01_JPRB,.615E-01_JPRB,.562E-01_JPRB,.507E-01_JPRB,.452E-01_JPRB,&
&.425E-01_JPRB,.432E-01_JPRB,.497E-01_JPRB,.518E-01_JPRB,.472E-01_JPRB,.422E-01_JPRB,.376E-01_JPRB,&
&.357E-01_JPRB,.335E-01_JPRB,.308E-01_JPRB,.288E-01_JPRB,.276E-01_JPRB,.269E-01_JPRB,.268E-01_JPRB,&
&.270E-01_JPRB,.267E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 32 -34.0
ZAER (:,32, 2) = (/&
&.202E-01_JPRB,.182E-01_JPRB,.166E-01_JPRB,.158E-01_JPRB,.156E-01_JPRB,.154E-01_JPRB,.152E-01_JPRB,&
&.146E-01_JPRB,.134E-01_JPRB,.122E-01_JPRB,.113E-01_JPRB,.111E-01_JPRB,.146E-01_JPRB,.224E-01_JPRB,&
&.247E-01_JPRB,.369E-01_JPRB,.515E-01_JPRB,.462E-01_JPRB,.332E-01_JPRB,.257E-01_JPRB,.214E-01_JPRB,&
&.189E-01_JPRB,.167E-01_JPRB,.154E-01_JPRB,.146E-01_JPRB,.146E-01_JPRB,.163E-01_JPRB,.181E-01_JPRB,&
&.198E-01_JPRB,.209E-01_JPRB,.227E-01_JPRB,.198E-01_JPRB,.157E-01_JPRB,.161E-01_JPRB,.135E-01_JPRB,&
&.137E-01_JPRB,.184E-01_JPRB,.377E-01_JPRB,.570E-01_JPRB,.651E-01_JPRB,.534E-01_JPRB,.343E-01_JPRB,&
&.318E-01_JPRB,.359E-01_JPRB,.472E-01_JPRB,.435E-01_JPRB,.359E-01_JPRB,.330E-01_JPRB,.264E-01_JPRB,&
&.255E-01_JPRB,.341E-01_JPRB,.432E-01_JPRB,.445E-01_JPRB,.435E-01_JPRB,.420E-01_JPRB,.389E-01_JPRB,&
&.366E-01_JPRB,.398E-01_JPRB,.540E-01_JPRB,.616E-01_JPRB,.548E-01_JPRB,.449E-01_JPRB,.360E-01_JPRB,&
&.326E-01_JPRB,.313E-01_JPRB,.301E-01_JPRB,.291E-01_JPRB,.279E-01_JPRB,.266E-01_JPRB,.251E-01_JPRB,&
&.240E-01_JPRB,.223E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 33 -38.0
ZAER (:,33, 2) = (/&
&.123E-01_JPRB,.115E-01_JPRB,.112E-01_JPRB,.111E-01_JPRB,.113E-01_JPRB,.116E-01_JPRB,.116E-01_JPRB,&
&.110E-01_JPRB,.102E-01_JPRB,.913E-02_JPRB,.806E-02_JPRB,.764E-02_JPRB,.908E-02_JPRB,.111E-01_JPRB,&
&.125E-01_JPRB,.153E-01_JPRB,.215E-01_JPRB,.229E-01_JPRB,.193E-01_JPRB,.164E-01_JPRB,.144E-01_JPRB,&
&.124E-01_JPRB,.104E-01_JPRB,.897E-02_JPRB,.861E-02_JPRB,.865E-02_JPRB,.963E-02_JPRB,.109E-01_JPRB,&
&.122E-01_JPRB,.132E-01_JPRB,.150E-01_JPRB,.156E-01_JPRB,.126E-01_JPRB,.103E-01_JPRB,.948E-02_JPRB,&
&.882E-02_JPRB,.866E-02_JPRB,.115E-01_JPRB,.243E-01_JPRB,.374E-01_JPRB,.378E-01_JPRB,.268E-01_JPRB,&
&.186E-01_JPRB,.143E-01_JPRB,.205E-01_JPRB,.260E-01_JPRB,.297E-01_JPRB,.405E-01_JPRB,.282E-01_JPRB,&
&.219E-01_JPRB,.216E-01_JPRB,.268E-01_JPRB,.336E-01_JPRB,.352E-01_JPRB,.334E-01_JPRB,.322E-01_JPRB,&
&.321E-01_JPRB,.440E-01_JPRB,.686E-01_JPRB,.799E-01_JPRB,.649E-01_JPRB,.477E-01_JPRB,.336E-01_JPRB,&
&.260E-01_JPRB,.242E-01_JPRB,.235E-01_JPRB,.224E-01_JPRB,.207E-01_JPRB,.189E-01_JPRB,.170E-01_JPRB,&
&.152E-01_JPRB,.135E-01_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 34 -42.0
ZAER (:,34, 2) = (/&
&.684E-02_JPRB,.701E-02_JPRB,.729E-02_JPRB,.749E-02_JPRB,.785E-02_JPRB,.838E-02_JPRB,.870E-02_JPRB,&
&.843E-02_JPRB,.792E-02_JPRB,.698E-02_JPRB,.595E-02_JPRB,.545E-02_JPRB,.539E-02_JPRB,.550E-02_JPRB,&
&.598E-02_JPRB,.599E-02_JPRB,.784E-02_JPRB,.922E-02_JPRB,.815E-02_JPRB,.652E-02_JPRB,.545E-02_JPRB,&
&.481E-02_JPRB,.454E-02_JPRB,.437E-02_JPRB,.439E-02_JPRB,.457E-02_JPRB,.513E-02_JPRB,.604E-02_JPRB,&
&.720E-02_JPRB,.826E-02_JPRB,.955E-02_JPRB,.111E-01_JPRB,.106E-01_JPRB,.925E-02_JPRB,.825E-02_JPRB,&
&.753E-02_JPRB,.717E-02_JPRB,.677E-02_JPRB,.960E-02_JPRB,.168E-01_JPRB,.238E-01_JPRB,.220E-01_JPRB,&
&.173E-01_JPRB,.132E-01_JPRB,.132E-01_JPRB,.154E-01_JPRB,.383E-01_JPRB,.825E-01_JPRB,.383E-01_JPRB,&
&.267E-01_JPRB,.233E-01_JPRB,.223E-01_JPRB,.273E-01_JPRB,.294E-01_JPRB,.292E-01_JPRB,.350E-01_JPRB,&
&.595E-01_JPRB,.102E+00_JPRB,.105E+00_JPRB,.847E-01_JPRB,.642E-01_JPRB,.502E-01_JPRB,.405E-01_JPRB,&
&.293E-01_JPRB,.220E-01_JPRB,.174E-01_JPRB,.142E-01_JPRB,.119E-01_JPRB,.103E-01_JPRB,.869E-02_JPRB,&
&.742E-02_JPRB,.687E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 35 -46.0
ZAER (:,35, 2) = (/&
&.399E-02_JPRB,.441E-02_JPRB,.496E-02_JPRB,.532E-02_JPRB,.575E-02_JPRB,.648E-02_JPRB,.680E-02_JPRB,&
&.663E-02_JPRB,.633E-02_JPRB,.584E-02_JPRB,.509E-02_JPRB,.444E-02_JPRB,.411E-02_JPRB,.396E-02_JPRB,&
&.389E-02_JPRB,.382E-02_JPRB,.415E-02_JPRB,.389E-02_JPRB,.355E-02_JPRB,.333E-02_JPRB,.312E-02_JPRB,&
&.294E-02_JPRB,.282E-02_JPRB,.274E-02_JPRB,.281E-02_JPRB,.296E-02_JPRB,.312E-02_JPRB,.352E-02_JPRB,&
&.425E-02_JPRB,.497E-02_JPRB,.596E-02_JPRB,.712E-02_JPRB,.783E-02_JPRB,.759E-02_JPRB,.714E-02_JPRB,&
&.673E-02_JPRB,.634E-02_JPRB,.607E-02_JPRB,.572E-02_JPRB,.743E-02_JPRB,.119E-01_JPRB,.151E-01_JPRB,&
&.154E-01_JPRB,.138E-01_JPRB,.123E-01_JPRB,.142E-01_JPRB,.515E-01_JPRB,.109E+00_JPRB,.512E-01_JPRB,&
&.319E-01_JPRB,.302E-01_JPRB,.293E-01_JPRB,.323E-01_JPRB,.288E-01_JPRB,.263E-01_JPRB,.341E-01_JPRB,&
&.543E-01_JPRB,.835E-01_JPRB,.768E-01_JPRB,.487E-01_JPRB,.340E-01_JPRB,.245E-01_JPRB,.201E-01_JPRB,&
&.159E-01_JPRB,.111E-01_JPRB,.802E-02_JPRB,.577E-02_JPRB,.434E-02_JPRB,.385E-02_JPRB,.341E-02_JPRB,&
&.331E-02_JPRB,.349E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 36 -50.0
ZAER (:,36, 2) = (/&
&.295E-02_JPRB,.326E-02_JPRB,.368E-02_JPRB,.401E-02_JPRB,.447E-02_JPRB,.512E-02_JPRB,.544E-02_JPRB,&
&.535E-02_JPRB,.512E-02_JPRB,.485E-02_JPRB,.444E-02_JPRB,.389E-02_JPRB,.348E-02_JPRB,.319E-02_JPRB,&
&.291E-02_JPRB,.265E-02_JPRB,.250E-02_JPRB,.246E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,.247E-02_JPRB,&
&.247E-02_JPRB,.238E-02_JPRB,.233E-02_JPRB,.228E-02_JPRB,.227E-02_JPRB,.243E-02_JPRB,.271E-02_JPRB,&
&.297E-02_JPRB,.327E-02_JPRB,.377E-02_JPRB,.429E-02_JPRB,.479E-02_JPRB,.513E-02_JPRB,.515E-02_JPRB,&
&.494E-02_JPRB,.481E-02_JPRB,.489E-02_JPRB,.456E-02_JPRB,.453E-02_JPRB,.584E-02_JPRB,.783E-02_JPRB,&
&.103E-01_JPRB,.111E-01_JPRB,.110E-01_JPRB,.147E-01_JPRB,.544E-01_JPRB,.100E+00_JPRB,.568E-01_JPRB,&
&.396E-01_JPRB,.370E-01_JPRB,.400E-01_JPRB,.325E-01_JPRB,.233E-01_JPRB,.200E-01_JPRB,.216E-01_JPRB,&
&.289E-01_JPRB,.357E-01_JPRB,.285E-01_JPRB,.187E-01_JPRB,.123E-01_JPRB,.655E-02_JPRB,.448E-02_JPRB,&
&.431E-02_JPRB,.377E-02_JPRB,.344E-02_JPRB,.288E-02_JPRB,.252E-02_JPRB,.241E-02_JPRB,.232E-02_JPRB,&
&.232E-02_JPRB,.258E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 37 -54.0
ZAER (:,37, 2) = (/&
&.270E-02_JPRB,.278E-02_JPRB,.309E-02_JPRB,.336E-02_JPRB,.374E-02_JPRB,.419E-02_JPRB,.446E-02_JPRB,&
&.447E-02_JPRB,.439E-02_JPRB,.420E-02_JPRB,.395E-02_JPRB,.351E-02_JPRB,.308E-02_JPRB,.277E-02_JPRB,&
&.251E-02_JPRB,.230E-02_JPRB,.219E-02_JPRB,.214E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.208E-02_JPRB,&
&.211E-02_JPRB,.212E-02_JPRB,.213E-02_JPRB,.202E-02_JPRB,.194E-02_JPRB,.204E-02_JPRB,.235E-02_JPRB,&
&.242E-02_JPRB,.261E-02_JPRB,.275E-02_JPRB,.273E-02_JPRB,.292E-02_JPRB,.315E-02_JPRB,.328E-02_JPRB,&
&.323E-02_JPRB,.321E-02_JPRB,.344E-02_JPRB,.341E-02_JPRB,.318E-02_JPRB,.364E-02_JPRB,.447E-02_JPRB,&
&.590E-02_JPRB,.799E-02_JPRB,.993E-02_JPRB,.152E-01_JPRB,.430E-01_JPRB,.799E-01_JPRB,.694E-01_JPRB,&
&.571E-01_JPRB,.494E-01_JPRB,.428E-01_JPRB,.295E-01_JPRB,.218E-01_JPRB,.187E-01_JPRB,.167E-01_JPRB,&
&.152E-01_JPRB,.142E-01_JPRB,.136E-01_JPRB,.861E-02_JPRB,.488E-02_JPRB,.313E-02_JPRB,.250E-02_JPRB,&
&.228E-02_JPRB,.221E-02_JPRB,.225E-02_JPRB,.219E-02_JPRB,.213E-02_JPRB,.217E-02_JPRB,.225E-02_JPRB,&
&.243E-02_JPRB,.261E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 38 -58.0
ZAER (:,38, 2) = (/&
&.270E-02_JPRB,.264E-02_JPRB,.265E-02_JPRB,.299E-02_JPRB,.333E-02_JPRB,.356E-02_JPRB,.375E-02_JPRB,&
&.380E-02_JPRB,.385E-02_JPRB,.379E-02_JPRB,.364E-02_JPRB,.335E-02_JPRB,.303E-02_JPRB,.278E-02_JPRB,&
&.256E-02_JPRB,.234E-02_JPRB,.221E-02_JPRB,.204E-02_JPRB,.190E-02_JPRB,.193E-02_JPRB,.200E-02_JPRB,&
&.195E-02_JPRB,.196E-02_JPRB,.200E-02_JPRB,.189E-02_JPRB,.181E-02_JPRB,.188E-02_JPRB,.209E-02_JPRB,&
&.225E-02_JPRB,.256E-02_JPRB,.272E-02_JPRB,.258E-02_JPRB,.251E-02_JPRB,.243E-02_JPRB,.238E-02_JPRB,&
&.235E-02_JPRB,.244E-02_JPRB,.267E-02_JPRB,.272E-02_JPRB,.253E-02_JPRB,.262E-02_JPRB,.322E-02_JPRB,&
&.409E-02_JPRB,.575E-02_JPRB,.937E-02_JPRB,.137E-01_JPRB,.237E-01_JPRB,.450E-01_JPRB,.549E-01_JPRB,&
&.492E-01_JPRB,.369E-01_JPRB,.295E-01_JPRB,.238E-01_JPRB,.212E-01_JPRB,.201E-01_JPRB,.192E-01_JPRB,&
&.167E-01_JPRB,.125E-01_JPRB,.892E-02_JPRB,.517E-02_JPRB,.358E-02_JPRB,.260E-02_JPRB,.218E-02_JPRB,&
&.198E-02_JPRB,.194E-02_JPRB,.197E-02_JPRB,.201E-02_JPRB,.209E-02_JPRB,.220E-02_JPRB,.233E-02_JPRB,&
&.250E-02_JPRB,.265E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 39 -62.0
ZAER (:,39, 2) = (/&
&.276E-02_JPRB,.268E-02_JPRB,.260E-02_JPRB,.276E-02_JPRB,.312E-02_JPRB,.340E-02_JPRB,.350E-02_JPRB,&
&.347E-02_JPRB,.345E-02_JPRB,.338E-02_JPRB,.322E-02_JPRB,.298E-02_JPRB,.272E-02_JPRB,.254E-02_JPRB,&
&.237E-02_JPRB,.220E-02_JPRB,.208E-02_JPRB,.197E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.202E-02_JPRB,&
&.209E-02_JPRB,.207E-02_JPRB,.209E-02_JPRB,.196E-02_JPRB,.180E-02_JPRB,.199E-02_JPRB,.224E-02_JPRB,&
&.247E-02_JPRB,.287E-02_JPRB,.304E-02_JPRB,.278E-02_JPRB,.234E-02_JPRB,.203E-02_JPRB,.196E-02_JPRB,&
&.198E-02_JPRB,.209E-02_JPRB,.218E-02_JPRB,.230E-02_JPRB,.238E-02_JPRB,.267E-02_JPRB,.351E-02_JPRB,&
&.589E-02_JPRB,.733E-02_JPRB,.880E-02_JPRB,.967E-02_JPRB,.127E-01_JPRB,.190E-01_JPRB,.232E-01_JPRB,&
&.233E-01_JPRB,.228E-01_JPRB,.239E-01_JPRB,.214E-01_JPRB,.204E-01_JPRB,.210E-01_JPRB,.209E-01_JPRB,&
&.173E-01_JPRB,.109E-01_JPRB,.518E-02_JPRB,.288E-02_JPRB,.256E-02_JPRB,.242E-02_JPRB,.238E-02_JPRB,&
&.229E-02_JPRB,.228E-02_JPRB,.231E-02_JPRB,.234E-02_JPRB,.241E-02_JPRB,.248E-02_JPRB,.258E-02_JPRB,&
&.272E-02_JPRB,.280E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 40 -66.0
ZAER (:,40, 2) = (/&
&.271E-02_JPRB,.261E-02_JPRB,.259E-02_JPRB,.266E-02_JPRB,.284E-02_JPRB,.299E-02_JPRB,.306E-02_JPRB,&
&.307E-02_JPRB,.302E-02_JPRB,.295E-02_JPRB,.280E-02_JPRB,.263E-02_JPRB,.244E-02_JPRB,.230E-02_JPRB,&
&.216E-02_JPRB,.207E-02_JPRB,.196E-02_JPRB,.190E-02_JPRB,.187E-02_JPRB,.184E-02_JPRB,.195E-02_JPRB,&
&.212E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.210E-02_JPRB,.206E-02_JPRB,.222E-02_JPRB,.247E-02_JPRB,&
&.261E-02_JPRB,.324E-02_JPRB,.359E-02_JPRB,.342E-02_JPRB,.294E-02_JPRB,.239E-02_JPRB,.202E-02_JPRB,&
&.189E-02_JPRB,.198E-02_JPRB,.213E-02_JPRB,.235E-02_JPRB,.267E-02_JPRB,.316E-02_JPRB,.532E-02_JPRB,&
&.776E-02_JPRB,.856E-02_JPRB,.842E-02_JPRB,.784E-02_JPRB,.946E-02_JPRB,.136E-01_JPRB,.175E-01_JPRB,&
&.209E-01_JPRB,.208E-01_JPRB,.207E-01_JPRB,.187E-01_JPRB,.191E-01_JPRB,.209E-01_JPRB,.194E-01_JPRB,&
&.126E-01_JPRB,.702E-02_JPRB,.341E-02_JPRB,.274E-02_JPRB,.274E-02_JPRB,.272E-02_JPRB,.269E-02_JPRB,&
&.268E-02_JPRB,.266E-02_JPRB,.265E-02_JPRB,.263E-02_JPRB,.261E-02_JPRB,.263E-02_JPRB,.268E-02_JPRB,&
&.276E-02_JPRB,.279E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 41 -70.0
ZAER (:,41, 2) = (/&
&.257E-02_JPRB,.244E-02_JPRB,.241E-02_JPRB,.244E-02_JPRB,.248E-02_JPRB,.250E-02_JPRB,.249E-02_JPRB,&
&.247E-02_JPRB,.243E-02_JPRB,.237E-02_JPRB,.230E-02_JPRB,.224E-02_JPRB,.216E-02_JPRB,.206E-02_JPRB,&
&.200E-02_JPRB,.194E-02_JPRB,.184E-02_JPRB,.181E-02_JPRB,.184E-02_JPRB,.187E-02_JPRB,.194E-02_JPRB,&
&.207E-02_JPRB,.215E-02_JPRB,.217E-02_JPRB,.217E-02_JPRB,.223E-02_JPRB,.232E-02_JPRB,.227E-02_JPRB,&
&.235E-02_JPRB,.291E-02_JPRB,.368E-02_JPRB,.403E-02_JPRB,.400E-02_JPRB,.356E-02_JPRB,.315E-02_JPRB,&
&.298E-02_JPRB,.307E-02_JPRB,.346E-02_JPRB,.420E-02_JPRB,.518E-02_JPRB,.610E-02_JPRB,.691E-02_JPRB,&
&.725E-02_JPRB,.725E-02_JPRB,.712E-02_JPRB,.780E-02_JPRB,.922E-02_JPRB,.119E-01_JPRB,.147E-01_JPRB,&
&.152E-01_JPRB,.156E-01_JPRB,.151E-01_JPRB,.136E-01_JPRB,.138E-01_JPRB,.128E-01_JPRB,.962E-02_JPRB,&
&.739E-02_JPRB,.545E-02_JPRB,.370E-02_JPRB,.329E-02_JPRB,.310E-02_JPRB,.301E-02_JPRB,.294E-02_JPRB,&
&.285E-02_JPRB,.279E-02_JPRB,.275E-02_JPRB,.270E-02_JPRB,.268E-02_JPRB,.269E-02_JPRB,.273E-02_JPRB,&
&.273E-02_JPRB,.269E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 42 -74.0
ZAER (:,42, 2) = (/&
&.236E-02_JPRB,.227E-02_JPRB,.218E-02_JPRB,.211E-02_JPRB,.210E-02_JPRB,.210E-02_JPRB,.208E-02_JPRB,&
&.207E-02_JPRB,.204E-02_JPRB,.202E-02_JPRB,.201E-02_JPRB,.197E-02_JPRB,.192E-02_JPRB,.189E-02_JPRB,&
&.184E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,.188E-02_JPRB,.196E-02_JPRB,.203E-02_JPRB,&
&.212E-02_JPRB,.218E-02_JPRB,.225E-02_JPRB,.234E-02_JPRB,.238E-02_JPRB,.234E-02_JPRB,.223E-02_JPRB,&
&.233E-02_JPRB,.280E-02_JPRB,.356E-02_JPRB,.436E-02_JPRB,.491E-02_JPRB,.505E-02_JPRB,.493E-02_JPRB,&
&.486E-02_JPRB,.487E-02_JPRB,.514E-02_JPRB,.564E-02_JPRB,.614E-02_JPRB,.641E-02_JPRB,.632E-02_JPRB,&
&.629E-02_JPRB,.654E-02_JPRB,.736E-02_JPRB,.856E-02_JPRB,.971E-02_JPRB,.108E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.111E-01_JPRB,.105E-01_JPRB,.984E-02_JPRB,.899E-02_JPRB,.765E-02_JPRB,.629E-02_JPRB,&
&.543E-02_JPRB,.464E-02_JPRB,.420E-02_JPRB,.391E-02_JPRB,.352E-02_JPRB,.329E-02_JPRB,.313E-02_JPRB,&
&.297E-02_JPRB,.283E-02_JPRB,.278E-02_JPRB,.273E-02_JPRB,.271E-02_JPRB,.269E-02_JPRB,.265E-02_JPRB,&
&.257E-02_JPRB,.248E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 43 -78.0
ZAER (:,43, 2) = (/&
&.220E-02_JPRB,.212E-02_JPRB,.204E-02_JPRB,.197E-02_JPRB,.193E-02_JPRB,.191E-02_JPRB,.190E-02_JPRB,&
&.189E-02_JPRB,.187E-02_JPRB,.184E-02_JPRB,.182E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.181E-02_JPRB,&
&.183E-02_JPRB,.186E-02_JPRB,.189E-02_JPRB,.192E-02_JPRB,.194E-02_JPRB,.200E-02_JPRB,.209E-02_JPRB,&
&.218E-02_JPRB,.225E-02_JPRB,.229E-02_JPRB,.237E-02_JPRB,.233E-02_JPRB,.224E-02_JPRB,.227E-02_JPRB,&
&.238E-02_JPRB,.266E-02_JPRB,.318E-02_JPRB,.429E-02_JPRB,.515E-02_JPRB,.568E-02_JPRB,.595E-02_JPRB,&
&.623E-02_JPRB,.646E-02_JPRB,.661E-02_JPRB,.668E-02_JPRB,.676E-02_JPRB,.683E-02_JPRB,.692E-02_JPRB,&
&.722E-02_JPRB,.772E-02_JPRB,.817E-02_JPRB,.848E-02_JPRB,.870E-02_JPRB,.886E-02_JPRB,.880E-02_JPRB,&
&.833E-02_JPRB,.764E-02_JPRB,.711E-02_JPRB,.667E-02_JPRB,.635E-02_JPRB,.617E-02_JPRB,.557E-02_JPRB,&
&.469E-02_JPRB,.400E-02_JPRB,.383E-02_JPRB,.387E-02_JPRB,.384E-02_JPRB,.357E-02_JPRB,.351E-02_JPRB,&
&.344E-02_JPRB,.327E-02_JPRB,.315E-02_JPRB,.304E-02_JPRB,.292E-02_JPRB,.276E-02_JPRB,.259E-02_JPRB,&
&.244E-02_JPRB,.231E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 44 -82.0
ZAER (:,44, 2) = (/&
&.232E-02_JPRB,.223E-02_JPRB,.215E-02_JPRB,.208E-02_JPRB,.202E-02_JPRB,.198E-02_JPRB,.196E-02_JPRB,&
&.193E-02_JPRB,.191E-02_JPRB,.189E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.189E-02_JPRB,.190E-02_JPRB,&
&.192E-02_JPRB,.194E-02_JPRB,.197E-02_JPRB,.200E-02_JPRB,.202E-02_JPRB,.207E-02_JPRB,.214E-02_JPRB,&
&.219E-02_JPRB,.221E-02_JPRB,.223E-02_JPRB,.227E-02_JPRB,.227E-02_JPRB,.234E-02_JPRB,.246E-02_JPRB,&
&.264E-02_JPRB,.289E-02_JPRB,.332E-02_JPRB,.406E-02_JPRB,.477E-02_JPRB,.515E-02_JPRB,.528E-02_JPRB,&
&.532E-02_JPRB,.538E-02_JPRB,.549E-02_JPRB,.568E-02_JPRB,.582E-02_JPRB,.584E-02_JPRB,.583E-02_JPRB,&
&.585E-02_JPRB,.589E-02_JPRB,.590E-02_JPRB,.601E-02_JPRB,.612E-02_JPRB,.613E-02_JPRB,.594E-02_JPRB,&
&.566E-02_JPRB,.541E-02_JPRB,.521E-02_JPRB,.505E-02_JPRB,.493E-02_JPRB,.471E-02_JPRB,.443E-02_JPRB,&
&.433E-02_JPRB,.422E-02_JPRB,.412E-02_JPRB,.406E-02_JPRB,.402E-02_JPRB,.393E-02_JPRB,.381E-02_JPRB,&
&.370E-02_JPRB,.357E-02_JPRB,.342E-02_JPRB,.326E-02_JPRB,.307E-02_JPRB,.283E-02_JPRB,.264E-02_JPRB,&
&.251E-02_JPRB,.241E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 45 -86.0
ZAER (:,45, 2) = (/&
&.321E-02_JPRB,.314E-02_JPRB,.305E-02_JPRB,.301E-02_JPRB,.296E-02_JPRB,.292E-02_JPRB,.287E-02_JPRB,&
&.284E-02_JPRB,.282E-02_JPRB,.279E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,.275E-02_JPRB,.276E-02_JPRB,&
&.276E-02_JPRB,.276E-02_JPRB,.277E-02_JPRB,.281E-02_JPRB,.285E-02_JPRB,.289E-02_JPRB,.294E-02_JPRB,&
&.299E-02_JPRB,.307E-02_JPRB,.318E-02_JPRB,.330E-02_JPRB,.342E-02_JPRB,.357E-02_JPRB,.372E-02_JPRB,&
&.392E-02_JPRB,.412E-02_JPRB,.431E-02_JPRB,.446E-02_JPRB,.457E-02_JPRB,.463E-02_JPRB,.466E-02_JPRB,&
&.462E-02_JPRB,.460E-02_JPRB,.456E-02_JPRB,.451E-02_JPRB,.449E-02_JPRB,.447E-02_JPRB,.445E-02_JPRB,&
&.441E-02_JPRB,.435E-02_JPRB,.430E-02_JPRB,.428E-02_JPRB,.428E-02_JPRB,.422E-02_JPRB,.417E-02_JPRB,&
&.419E-02_JPRB,.422E-02_JPRB,.422E-02_JPRB,.428E-02_JPRB,.431E-02_JPRB,.428E-02_JPRB,.426E-02_JPRB,&
&.428E-02_JPRB,.430E-02_JPRB,.430E-02_JPRB,.425E-02_JPRB,.417E-02_JPRB,.407E-02_JPRB,.395E-02_JPRB,&
&.383E-02_JPRB,.370E-02_JPRB,.360E-02_JPRB,.355E-02_JPRB,.349E-02_JPRB,.342E-02_JPRB,.339E-02_JPRB,&
&.333E-02_JPRB,.326E-02_JPRB/)
!-- Total Soil Dust Aerosol  month:  2 --- lat: 46 -90.0
ZAER (:,46, 2) = (/&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,.423E-02_JPRB,&
&.423E-02_JPRB,.423E-02_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=2   
  DO JI=1,46
    DO JL=1,72
      RAERSD(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'SOIL DUST AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAESD_02
