SUBROUTINE SUECAEBC_09

!**   OPTICAL THICKNESS OF BLACK CARBON AEROSOLS (URBAN/FOREST FIRE ORIGIN)
!                                                 September

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAEBC* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERBC


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,9:9)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Black Carbon Aerosol     month:  9 --- lat:  1  90.0
ZAER (:, 1, 9) = (/&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,&
&.177E-03_JPRB,.177E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  2  86.0
ZAER (:, 2, 9) = (/&
&.179E-03_JPRB,.180E-03_JPRB,.182E-03_JPRB,.183E-03_JPRB,.184E-03_JPRB,.185E-03_JPRB,.187E-03_JPRB,&
&.188E-03_JPRB,.189E-03_JPRB,.190E-03_JPRB,.191E-03_JPRB,.192E-03_JPRB,.193E-03_JPRB,.193E-03_JPRB,&
&.193E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.194E-03_JPRB,.193E-03_JPRB,&
&.192E-03_JPRB,.192E-03_JPRB,.192E-03_JPRB,.190E-03_JPRB,.189E-03_JPRB,.188E-03_JPRB,.187E-03_JPRB,&
&.185E-03_JPRB,.184E-03_JPRB,.183E-03_JPRB,.181E-03_JPRB,.180E-03_JPRB,.178E-03_JPRB,.176E-03_JPRB,&
&.175E-03_JPRB,.174E-03_JPRB,.172E-03_JPRB,.171E-03_JPRB,.170E-03_JPRB,.168E-03_JPRB,.167E-03_JPRB,&
&.167E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.164E-03_JPRB,.163E-03_JPRB,.163E-03_JPRB,.163E-03_JPRB,&
&.162E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.162E-03_JPRB,.163E-03_JPRB,&
&.163E-03_JPRB,.164E-03_JPRB,.164E-03_JPRB,.165E-03_JPRB,.165E-03_JPRB,.166E-03_JPRB,.167E-03_JPRB,&
&.168E-03_JPRB,.169E-03_JPRB,.170E-03_JPRB,.172E-03_JPRB,.173E-03_JPRB,.175E-03_JPRB,.176E-03_JPRB,&
&.177E-03_JPRB,.179E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  3  82.0
ZAER (:, 3, 9) = (/&
&.191E-03_JPRB,.191E-03_JPRB,.197E-03_JPRB,.200E-03_JPRB,.203E-03_JPRB,.207E-03_JPRB,.210E-03_JPRB,&
&.213E-03_JPRB,.216E-03_JPRB,.218E-03_JPRB,.220E-03_JPRB,.222E-03_JPRB,.223E-03_JPRB,.223E-03_JPRB,&
&.224E-03_JPRB,.224E-03_JPRB,.223E-03_JPRB,.223E-03_JPRB,.223E-03_JPRB,.222E-03_JPRB,.222E-03_JPRB,&
&.220E-03_JPRB,.220E-03_JPRB,.220E-03_JPRB,.217E-03_JPRB,.216E-03_JPRB,.214E-03_JPRB,.211E-03_JPRB,&
&.209E-03_JPRB,.206E-03_JPRB,.202E-03_JPRB,.198E-03_JPRB,.194E-03_JPRB,.189E-03_JPRB,.184E-03_JPRB,&
&.180E-03_JPRB,.176E-03_JPRB,.171E-03_JPRB,.168E-03_JPRB,.165E-03_JPRB,.161E-03_JPRB,.159E-03_JPRB,&
&.157E-03_JPRB,.154E-03_JPRB,.153E-03_JPRB,.152E-03_JPRB,.151E-03_JPRB,.150E-03_JPRB,.150E-03_JPRB,&
&.149E-03_JPRB,.149E-03_JPRB,.149E-03_JPRB,.149E-03_JPRB,.149E-03_JPRB,.150E-03_JPRB,.150E-03_JPRB,&
&.150E-03_JPRB,.151E-03_JPRB,.152E-03_JPRB,.153E-03_JPRB,.154E-03_JPRB,.155E-03_JPRB,.157E-03_JPRB,&
&.159E-03_JPRB,.162E-03_JPRB,.166E-03_JPRB,.168E-03_JPRB,.172E-03_JPRB,.177E-03_JPRB,.181E-03_JPRB,&
&.184E-03_JPRB,.190E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  4  78.0
ZAER (:, 4, 9) = (/&
&.215E-03_JPRB,.216E-03_JPRB,.225E-03_JPRB,.230E-03_JPRB,.234E-03_JPRB,.240E-03_JPRB,.243E-03_JPRB,&
&.246E-03_JPRB,.250E-03_JPRB,.252E-03_JPRB,.253E-03_JPRB,.254E-03_JPRB,.254E-03_JPRB,.253E-03_JPRB,&
&.252E-03_JPRB,.251E-03_JPRB,.250E-03_JPRB,.249E-03_JPRB,.249E-03_JPRB,.249E-03_JPRB,.250E-03_JPRB,&
&.251E-03_JPRB,.251E-03_JPRB,.252E-03_JPRB,.252E-03_JPRB,.252E-03_JPRB,.251E-03_JPRB,.249E-03_JPRB,&
&.246E-03_JPRB,.243E-03_JPRB,.236E-03_JPRB,.229E-03_JPRB,.223E-03_JPRB,.213E-03_JPRB,.203E-03_JPRB,&
&.196E-03_JPRB,.187E-03_JPRB,.179E-03_JPRB,.174E-03_JPRB,.169E-03_JPRB,.164E-03_JPRB,.161E-03_JPRB,&
&.159E-03_JPRB,.156E-03_JPRB,.156E-03_JPRB,.155E-03_JPRB,.155E-03_JPRB,.154E-03_JPRB,.154E-03_JPRB,&
&.154E-03_JPRB,.154E-03_JPRB,.154E-03_JPRB,.154E-03_JPRB,.154E-03_JPRB,.154E-03_JPRB,.154E-03_JPRB,&
&.154E-03_JPRB,.153E-03_JPRB,.154E-03_JPRB,.154E-03_JPRB,.155E-03_JPRB,.156E-03_JPRB,.159E-03_JPRB,&
&.161E-03_JPRB,.165E-03_JPRB,.172E-03_JPRB,.176E-03_JPRB,.182E-03_JPRB,.192E-03_JPRB,.198E-03_JPRB,&
&.204E-03_JPRB,.215E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  5  74.0
ZAER (:, 5, 9) = (/&
&.257E-03_JPRB,.257E-03_JPRB,.267E-03_JPRB,.271E-03_JPRB,.273E-03_JPRB,.276E-03_JPRB,.277E-03_JPRB,&
&.278E-03_JPRB,.277E-03_JPRB,.276E-03_JPRB,.276E-03_JPRB,.274E-03_JPRB,.272E-03_JPRB,.270E-03_JPRB,&
&.267E-03_JPRB,.264E-03_JPRB,.263E-03_JPRB,.262E-03_JPRB,.263E-03_JPRB,.265E-03_JPRB,.268E-03_JPRB,&
&.273E-03_JPRB,.276E-03_JPRB,.280E-03_JPRB,.286E-03_JPRB,.289E-03_JPRB,.291E-03_JPRB,.292E-03_JPRB,&
&.289E-03_JPRB,.286E-03_JPRB,.276E-03_JPRB,.265E-03_JPRB,.256E-03_JPRB,.241E-03_JPRB,.227E-03_JPRB,&
&.217E-03_JPRB,.203E-03_JPRB,.193E-03_JPRB,.187E-03_JPRB,.180E-03_JPRB,.176E-03_JPRB,.174E-03_JPRB,&
&.172E-03_JPRB,.172E-03_JPRB,.172E-03_JPRB,.173E-03_JPRB,.174E-03_JPRB,.174E-03_JPRB,.175E-03_JPRB,&
&.176E-03_JPRB,.176E-03_JPRB,.177E-03_JPRB,.178E-03_JPRB,.177E-03_JPRB,.177E-03_JPRB,.176E-03_JPRB,&
&.174E-03_JPRB,.173E-03_JPRB,.172E-03_JPRB,.171E-03_JPRB,.171E-03_JPRB,.172E-03_JPRB,.175E-03_JPRB,&
&.178E-03_JPRB,.183E-03_JPRB,.193E-03_JPRB,.200E-03_JPRB,.210E-03_JPRB,.225E-03_JPRB,.234E-03_JPRB,&
&.243E-03_JPRB,.256E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  6  70.0
ZAER (:, 6, 9) = (/&
&.323E-03_JPRB,.323E-03_JPRB,.329E-03_JPRB,.330E-03_JPRB,.329E-03_JPRB,.325E-03_JPRB,.320E-03_JPRB,&
&.316E-03_JPRB,.307E-03_JPRB,.300E-03_JPRB,.296E-03_JPRB,.291E-03_JPRB,.288E-03_JPRB,.286E-03_JPRB,&
&.282E-03_JPRB,.279E-03_JPRB,.277E-03_JPRB,.275E-03_JPRB,.277E-03_JPRB,.281E-03_JPRB,.285E-03_JPRB,&
&.294E-03_JPRB,.301E-03_JPRB,.309E-03_JPRB,.326E-03_JPRB,.333E-03_JPRB,.340E-03_JPRB,.344E-03_JPRB,&
&.339E-03_JPRB,.334E-03_JPRB,.319E-03_JPRB,.304E-03_JPRB,.291E-03_JPRB,.271E-03_JPRB,.255E-03_JPRB,&
&.244E-03_JPRB,.229E-03_JPRB,.217E-03_JPRB,.210E-03_JPRB,.203E-03_JPRB,.199E-03_JPRB,.198E-03_JPRB,&
&.198E-03_JPRB,.199E-03_JPRB,.200E-03_JPRB,.202E-03_JPRB,.206E-03_JPRB,.208E-03_JPRB,.210E-03_JPRB,&
&.214E-03_JPRB,.216E-03_JPRB,.218E-03_JPRB,.220E-03_JPRB,.219E-03_JPRB,.219E-03_JPRB,.217E-03_JPRB,&
&.215E-03_JPRB,.213E-03_JPRB,.211E-03_JPRB,.210E-03_JPRB,.210E-03_JPRB,.210E-03_JPRB,.214E-03_JPRB,&
&.219E-03_JPRB,.227E-03_JPRB,.242E-03_JPRB,.252E-03_JPRB,.266E-03_JPRB,.286E-03_JPRB,.297E-03_JPRB,&
&.308E-03_JPRB,.322E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  7  66.0
ZAER (:, 7, 9) = (/&
&.399E-03_JPRB,.399E-03_JPRB,.402E-03_JPRB,.399E-03_JPRB,.396E-03_JPRB,.385E-03_JPRB,.376E-03_JPRB,&
&.367E-03_JPRB,.349E-03_JPRB,.336E-03_JPRB,.328E-03_JPRB,.319E-03_JPRB,.315E-03_JPRB,.312E-03_JPRB,&
&.307E-03_JPRB,.302E-03_JPRB,.298E-03_JPRB,.293E-03_JPRB,.293E-03_JPRB,.295E-03_JPRB,.299E-03_JPRB,&
&.310E-03_JPRB,.321E-03_JPRB,.332E-03_JPRB,.360E-03_JPRB,.373E-03_JPRB,.385E-03_JPRB,.392E-03_JPRB,&
&.385E-03_JPRB,.377E-03_JPRB,.356E-03_JPRB,.341E-03_JPRB,.328E-03_JPRB,.311E-03_JPRB,.296E-03_JPRB,&
&.284E-03_JPRB,.268E-03_JPRB,.254E-03_JPRB,.246E-03_JPRB,.238E-03_JPRB,.234E-03_JPRB,.233E-03_JPRB,&
&.234E-03_JPRB,.235E-03_JPRB,.237E-03_JPRB,.240E-03_JPRB,.246E-03_JPRB,.251E-03_JPRB,.256E-03_JPRB,&
&.266E-03_JPRB,.269E-03_JPRB,.272E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,.273E-03_JPRB,.271E-03_JPRB,&
&.271E-03_JPRB,.271E-03_JPRB,.272E-03_JPRB,.272E-03_JPRB,.273E-03_JPRB,.275E-03_JPRB,.284E-03_JPRB,&
&.292E-03_JPRB,.304E-03_JPRB,.320E-03_JPRB,.331E-03_JPRB,.345E-03_JPRB,.365E-03_JPRB,.375E-03_JPRB,&
&.386E-03_JPRB,.399E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  8  62.0
ZAER (:, 8, 9) = (/&
&.460E-03_JPRB,.460E-03_JPRB,.466E-03_JPRB,.459E-03_JPRB,.452E-03_JPRB,.435E-03_JPRB,.425E-03_JPRB,&
&.415E-03_JPRB,.395E-03_JPRB,.379E-03_JPRB,.369E-03_JPRB,.358E-03_JPRB,.351E-03_JPRB,.347E-03_JPRB,&
&.341E-03_JPRB,.334E-03_JPRB,.327E-03_JPRB,.318E-03_JPRB,.310E-03_JPRB,.309E-03_JPRB,.309E-03_JPRB,&
&.318E-03_JPRB,.329E-03_JPRB,.341E-03_JPRB,.374E-03_JPRB,.391E-03_JPRB,.406E-03_JPRB,.415E-03_JPRB,&
&.407E-03_JPRB,.399E-03_JPRB,.384E-03_JPRB,.376E-03_JPRB,.369E-03_JPRB,.358E-03_JPRB,.348E-03_JPRB,&
&.339E-03_JPRB,.323E-03_JPRB,.305E-03_JPRB,.294E-03_JPRB,.281E-03_JPRB,.279E-03_JPRB,.282E-03_JPRB,&
&.288E-03_JPRB,.293E-03_JPRB,.295E-03_JPRB,.296E-03_JPRB,.302E-03_JPRB,.308E-03_JPRB,.315E-03_JPRB,&
&.330E-03_JPRB,.334E-03_JPRB,.337E-03_JPRB,.335E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,.334E-03_JPRB,&
&.340E-03_JPRB,.345E-03_JPRB,.354E-03_JPRB,.359E-03_JPRB,.363E-03_JPRB,.369E-03_JPRB,.382E-03_JPRB,&
&.391E-03_JPRB,.403E-03_JPRB,.408E-03_JPRB,.411E-03_JPRB,.415E-03_JPRB,.429E-03_JPRB,.438E-03_JPRB,&
&.448E-03_JPRB,.460E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat:  9  58.0
ZAER (:, 9, 9) = (/&
&.517E-03_JPRB,.517E-03_JPRB,.514E-03_JPRB,.503E-03_JPRB,.492E-03_JPRB,.474E-03_JPRB,.464E-03_JPRB,&
&.455E-03_JPRB,.437E-03_JPRB,.423E-03_JPRB,.413E-03_JPRB,.398E-03_JPRB,.387E-03_JPRB,.380E-03_JPRB,&
&.371E-03_JPRB,.357E-03_JPRB,.348E-03_JPRB,.335E-03_JPRB,.327E-03_JPRB,.328E-03_JPRB,.330E-03_JPRB,&
&.344E-03_JPRB,.358E-03_JPRB,.372E-03_JPRB,.412E-03_JPRB,.435E-03_JPRB,.455E-03_JPRB,.468E-03_JPRB,&
&.458E-03_JPRB,.449E-03_JPRB,.441E-03_JPRB,.435E-03_JPRB,.429E-03_JPRB,.418E-03_JPRB,.407E-03_JPRB,&
&.397E-03_JPRB,.378E-03_JPRB,.352E-03_JPRB,.339E-03_JPRB,.326E-03_JPRB,.341E-03_JPRB,.357E-03_JPRB,&
&.380E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,.389E-03_JPRB,.386E-03_JPRB,.388E-03_JPRB,.390E-03_JPRB,&
&.395E-03_JPRB,.398E-03_JPRB,.400E-03_JPRB,.395E-03_JPRB,.392E-03_JPRB,.392E-03_JPRB,.397E-03_JPRB,&
&.409E-03_JPRB,.419E-03_JPRB,.437E-03_JPRB,.446E-03_JPRB,.454E-03_JPRB,.467E-03_JPRB,.493E-03_JPRB,&
&.502E-03_JPRB,.507E-03_JPRB,.484E-03_JPRB,.480E-03_JPRB,.480E-03_JPRB,.503E-03_JPRB,.510E-03_JPRB,&
&.517E-03_JPRB,.517E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 10  54.0
ZAER (:,10, 9) = (/&
&.558E-03_JPRB,.557E-03_JPRB,.542E-03_JPRB,.532E-03_JPRB,.523E-03_JPRB,.512E-03_JPRB,.506E-03_JPRB,&
&.498E-03_JPRB,.476E-03_JPRB,.463E-03_JPRB,.452E-03_JPRB,.433E-03_JPRB,.418E-03_JPRB,.407E-03_JPRB,&
&.393E-03_JPRB,.373E-03_JPRB,.363E-03_JPRB,.354E-03_JPRB,.355E-03_JPRB,.359E-03_JPRB,.366E-03_JPRB,&
&.385E-03_JPRB,.403E-03_JPRB,.423E-03_JPRB,.474E-03_JPRB,.507E-03_JPRB,.538E-03_JPRB,.565E-03_JPRB,&
&.547E-03_JPRB,.533E-03_JPRB,.523E-03_JPRB,.505E-03_JPRB,.490E-03_JPRB,.466E-03_JPRB,.451E-03_JPRB,&
&.439E-03_JPRB,.422E-03_JPRB,.400E-03_JPRB,.392E-03_JPRB,.390E-03_JPRB,.431E-03_JPRB,.459E-03_JPRB,&
&.494E-03_JPRB,.498E-03_JPRB,.491E-03_JPRB,.480E-03_JPRB,.466E-03_JPRB,.463E-03_JPRB,.461E-03_JPRB,&
&.457E-03_JPRB,.458E-03_JPRB,.458E-03_JPRB,.455E-03_JPRB,.447E-03_JPRB,.442E-03_JPRB,.440E-03_JPRB,&
&.452E-03_JPRB,.464E-03_JPRB,.488E-03_JPRB,.495E-03_JPRB,.505E-03_JPRB,.526E-03_JPRB,.565E-03_JPRB,&
&.579E-03_JPRB,.584E-03_JPRB,.542E-03_JPRB,.532E-03_JPRB,.527E-03_JPRB,.553E-03_JPRB,.561E-03_JPRB,&
&.569E-03_JPRB,.558E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 11  50.0
ZAER (:,11, 9) = (/&
&.592E-03_JPRB,.592E-03_JPRB,.575E-03_JPRB,.562E-03_JPRB,.550E-03_JPRB,.536E-03_JPRB,.535E-03_JPRB,&
&.532E-03_JPRB,.516E-03_JPRB,.502E-03_JPRB,.491E-03_JPRB,.475E-03_JPRB,.461E-03_JPRB,.448E-03_JPRB,&
&.427E-03_JPRB,.406E-03_JPRB,.399E-03_JPRB,.396E-03_JPRB,.411E-03_JPRB,.419E-03_JPRB,.427E-03_JPRB,&
&.447E-03_JPRB,.474E-03_JPRB,.504E-03_JPRB,.563E-03_JPRB,.594E-03_JPRB,.624E-03_JPRB,.657E-03_JPRB,&
&.640E-03_JPRB,.624E-03_JPRB,.602E-03_JPRB,.570E-03_JPRB,.547E-03_JPRB,.522E-03_JPRB,.508E-03_JPRB,&
&.498E-03_JPRB,.488E-03_JPRB,.480E-03_JPRB,.482E-03_JPRB,.493E-03_JPRB,.546E-03_JPRB,.580E-03_JPRB,&
&.620E-03_JPRB,.608E-03_JPRB,.597E-03_JPRB,.584E-03_JPRB,.578E-03_JPRB,.593E-03_JPRB,.609E-03_JPRB,&
&.600E-03_JPRB,.582E-03_JPRB,.566E-03_JPRB,.547E-03_JPRB,.523E-03_JPRB,.505E-03_JPRB,.491E-03_JPRB,&
&.496E-03_JPRB,.504E-03_JPRB,.526E-03_JPRB,.531E-03_JPRB,.541E-03_JPRB,.567E-03_JPRB,.621E-03_JPRB,&
&.643E-03_JPRB,.657E-03_JPRB,.616E-03_JPRB,.600E-03_JPRB,.586E-03_JPRB,.588E-03_JPRB,.594E-03_JPRB,&
&.601E-03_JPRB,.593E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 12  46.0
ZAER (:,12, 9) = (/&
&.642E-03_JPRB,.641E-03_JPRB,.624E-03_JPRB,.603E-03_JPRB,.584E-03_JPRB,.557E-03_JPRB,.558E-03_JPRB,&
&.558E-03_JPRB,.558E-03_JPRB,.552E-03_JPRB,.545E-03_JPRB,.529E-03_JPRB,.514E-03_JPRB,.500E-03_JPRB,&
&.477E-03_JPRB,.459E-03_JPRB,.458E-03_JPRB,.464E-03_JPRB,.495E-03_JPRB,.509E-03_JPRB,.523E-03_JPRB,&
&.560E-03_JPRB,.598E-03_JPRB,.640E-03_JPRB,.728E-03_JPRB,.749E-03_JPRB,.769E-03_JPRB,.772E-03_JPRB,&
&.759E-03_JPRB,.744E-03_JPRB,.700E-03_JPRB,.657E-03_JPRB,.630E-03_JPRB,.616E-03_JPRB,.609E-03_JPRB,&
&.612E-03_JPRB,.631E-03_JPRB,.668E-03_JPRB,.696E-03_JPRB,.734E-03_JPRB,.760E-03_JPRB,.789E-03_JPRB,&
&.831E-03_JPRB,.834E-03_JPRB,.831E-03_JPRB,.826E-03_JPRB,.838E-03_JPRB,.915E-03_JPRB,.998E-03_JPRB,&
&.950E-03_JPRB,.879E-03_JPRB,.813E-03_JPRB,.747E-03_JPRB,.683E-03_JPRB,.638E-03_JPRB,.615E-03_JPRB,&
&.608E-03_JPRB,.607E-03_JPRB,.616E-03_JPRB,.615E-03_JPRB,.625E-03_JPRB,.655E-03_JPRB,.711E-03_JPRB,&
&.727E-03_JPRB,.728E-03_JPRB,.694E-03_JPRB,.682E-03_JPRB,.671E-03_JPRB,.648E-03_JPRB,.646E-03_JPRB,&
&.646E-03_JPRB,.642E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 13  42.0
ZAER (:,13, 9) = (/&
&.770E-03_JPRB,.769E-03_JPRB,.728E-03_JPRB,.695E-03_JPRB,.665E-03_JPRB,.619E-03_JPRB,.613E-03_JPRB,&
&.611E-03_JPRB,.621E-03_JPRB,.621E-03_JPRB,.616E-03_JPRB,.600E-03_JPRB,.583E-03_JPRB,.571E-03_JPRB,&
&.555E-03_JPRB,.551E-03_JPRB,.556E-03_JPRB,.568E-03_JPRB,.600E-03_JPRB,.629E-03_JPRB,.664E-03_JPRB,&
&.765E-03_JPRB,.831E-03_JPRB,.898E-03_JPRB,.103E-02_JPRB,.105E-02_JPRB,.107E-02_JPRB,.103E-02_JPRB,&
&.966E-03_JPRB,.911E-03_JPRB,.833E-03_JPRB,.792E-03_JPRB,.774E-03_JPRB,.796E-03_JPRB,.834E-03_JPRB,&
&.872E-03_JPRB,.945E-03_JPRB,.106E-02_JPRB,.114E-02_JPRB,.125E-02_JPRB,.125E-02_JPRB,.127E-02_JPRB,&
&.131E-02_JPRB,.136E-02_JPRB,.137E-02_JPRB,.138E-02_JPRB,.142E-02_JPRB,.154E-02_JPRB,.166E-02_JPRB,&
&.153E-02_JPRB,.139E-02_JPRB,.126E-02_JPRB,.111E-02_JPRB,.100E-02_JPRB,.925E-03_JPRB,.882E-03_JPRB,&
&.846E-03_JPRB,.825E-03_JPRB,.813E-03_JPRB,.803E-03_JPRB,.814E-03_JPRB,.856E-03_JPRB,.912E-03_JPRB,&
&.928E-03_JPRB,.930E-03_JPRB,.911E-03_JPRB,.911E-03_JPRB,.916E-03_JPRB,.843E-03_JPRB,.814E-03_JPRB,&
&.785E-03_JPRB,.771E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 14  38.0
ZAER (:,14, 9) = (/&
&.103E-02_JPRB,.103E-02_JPRB,.929E-03_JPRB,.880E-03_JPRB,.836E-03_JPRB,.776E-03_JPRB,.748E-03_JPRB,&
&.730E-03_JPRB,.721E-03_JPRB,.716E-03_JPRB,.709E-03_JPRB,.690E-03_JPRB,.676E-03_JPRB,.671E-03_JPRB,&
&.670E-03_JPRB,.682E-03_JPRB,.690E-03_JPRB,.700E-03_JPRB,.728E-03_JPRB,.778E-03_JPRB,.848E-03_JPRB,&
&.109E-02_JPRB,.126E-02_JPRB,.144E-02_JPRB,.178E-02_JPRB,.180E-02_JPRB,.180E-02_JPRB,.159E-02_JPRB,&
&.136E-02_JPRB,.117E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.108E-02_JPRB,.119E-02_JPRB,.124E-02_JPRB,&
&.130E-02_JPRB,.143E-02_JPRB,.170E-02_JPRB,.190E-02_JPRB,.217E-02_JPRB,.212E-02_JPRB,.217E-02_JPRB,&
&.226E-02_JPRB,.228E-02_JPRB,.227E-02_JPRB,.225E-02_JPRB,.234E-02_JPRB,.237E-02_JPRB,.238E-02_JPRB,&
&.209E-02_JPRB,.194E-02_JPRB,.179E-02_JPRB,.158E-02_JPRB,.146E-02_JPRB,.136E-02_JPRB,.124E-02_JPRB,&
&.117E-02_JPRB,.113E-02_JPRB,.113E-02_JPRB,.112E-02_JPRB,.117E-02_JPRB,.129E-02_JPRB,.142E-02_JPRB,&
&.149E-02_JPRB,.154E-02_JPRB,.159E-02_JPRB,.158E-02_JPRB,.157E-02_JPRB,.130E-02_JPRB,.121E-02_JPRB,&
&.112E-02_JPRB,.103E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 15  34.0
ZAER (:,15, 9) = (/&
&.139E-02_JPRB,.139E-02_JPRB,.124E-02_JPRB,.117E-02_JPRB,.111E-02_JPRB,.103E-02_JPRB,.966E-03_JPRB,&
&.923E-03_JPRB,.892E-03_JPRB,.863E-03_JPRB,.841E-03_JPRB,.806E-03_JPRB,.793E-03_JPRB,.792E-03_JPRB,&
&.803E-03_JPRB,.820E-03_JPRB,.829E-03_JPRB,.839E-03_JPRB,.858E-03_JPRB,.935E-03_JPRB,.105E-02_JPRB,&
&.153E-02_JPRB,.194E-02_JPRB,.238E-02_JPRB,.350E-02_JPRB,.352E-02_JPRB,.349E-02_JPRB,.263E-02_JPRB,&
&.207E-02_JPRB,.165E-02_JPRB,.151E-02_JPRB,.155E-02_JPRB,.161E-02_JPRB,.182E-02_JPRB,.177E-02_JPRB,&
&.180E-02_JPRB,.197E-02_JPRB,.250E-02_JPRB,.290E-02_JPRB,.347E-02_JPRB,.343E-02_JPRB,.356E-02_JPRB,&
&.381E-02_JPRB,.355E-02_JPRB,.339E-02_JPRB,.323E-02_JPRB,.318E-02_JPRB,.300E-02_JPRB,.279E-02_JPRB,&
&.240E-02_JPRB,.229E-02_JPRB,.217E-02_JPRB,.201E-02_JPRB,.190E-02_JPRB,.180E-02_JPRB,.162E-02_JPRB,&
&.152E-02_JPRB,.146E-02_JPRB,.144E-02_JPRB,.149E-02_JPRB,.167E-02_JPRB,.214E-02_JPRB,.260E-02_JPRB,&
&.277E-02_JPRB,.286E-02_JPRB,.279E-02_JPRB,.265E-02_JPRB,.243E-02_JPRB,.185E-02_JPRB,.169E-02_JPRB,&
&.156E-02_JPRB,.140E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 16  30.0
ZAER (:,16, 9) = (/&
&.167E-02_JPRB,.167E-02_JPRB,.153E-02_JPRB,.145E-02_JPRB,.137E-02_JPRB,.127E-02_JPRB,.118E-02_JPRB,&
&.111E-02_JPRB,.106E-02_JPRB,.996E-03_JPRB,.951E-03_JPRB,.903E-03_JPRB,.889E-03_JPRB,.893E-03_JPRB,&
&.917E-03_JPRB,.939E-03_JPRB,.945E-03_JPRB,.947E-03_JPRB,.988E-03_JPRB,.112E-02_JPRB,.130E-02_JPRB,&
&.208E-02_JPRB,.279E-02_JPRB,.356E-02_JPRB,.623E-02_JPRB,.643E-02_JPRB,.646E-02_JPRB,.418E-02_JPRB,&
&.316E-02_JPRB,.241E-02_JPRB,.217E-02_JPRB,.219E-02_JPRB,.222E-02_JPRB,.231E-02_JPRB,.226E-02_JPRB,&
&.234E-02_JPRB,.271E-02_JPRB,.353E-02_JPRB,.419E-02_JPRB,.513E-02_JPRB,.539E-02_JPRB,.570E-02_JPRB,&
&.616E-02_JPRB,.534E-02_JPRB,.474E-02_JPRB,.406E-02_JPRB,.359E-02_JPRB,.325E-02_JPRB,.291E-02_JPRB,&
&.254E-02_JPRB,.244E-02_JPRB,.235E-02_JPRB,.224E-02_JPRB,.214E-02_JPRB,.205E-02_JPRB,.187E-02_JPRB,&
&.178E-02_JPRB,.172E-02_JPRB,.170E-02_JPRB,.183E-02_JPRB,.225E-02_JPRB,.331E-02_JPRB,.464E-02_JPRB,&
&.495E-02_JPRB,.484E-02_JPRB,.410E-02_JPRB,.361E-02_JPRB,.301E-02_JPRB,.220E-02_JPRB,.199E-02_JPRB,&
&.184E-02_JPRB,.168E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 17  26.0
ZAER (:,17, 9) = (/&
&.170E-02_JPRB,.170E-02_JPRB,.157E-02_JPRB,.151E-02_JPRB,.145E-02_JPRB,.137E-02_JPRB,.126E-02_JPRB,&
&.119E-02_JPRB,.113E-02_JPRB,.104E-02_JPRB,.983E-03_JPRB,.937E-03_JPRB,.937E-03_JPRB,.959E-03_JPRB,&
&.102E-02_JPRB,.105E-02_JPRB,.106E-02_JPRB,.107E-02_JPRB,.125E-02_JPRB,.152E-02_JPRB,.189E-02_JPRB,&
&.289E-02_JPRB,.392E-02_JPRB,.504E-02_JPRB,.101E-01_JPRB,.106E-01_JPRB,.107E-01_JPRB,.630E-02_JPRB,&
&.474E-02_JPRB,.354E-02_JPRB,.295E-02_JPRB,.275E-02_JPRB,.261E-02_JPRB,.246E-02_JPRB,.261E-02_JPRB,&
&.291E-02_JPRB,.367E-02_JPRB,.485E-02_JPRB,.591E-02_JPRB,.758E-02_JPRB,.838E-02_JPRB,.882E-02_JPRB,&
&.930E-02_JPRB,.747E-02_JPRB,.613E-02_JPRB,.457E-02_JPRB,.363E-02_JPRB,.327E-02_JPRB,.294E-02_JPRB,&
&.260E-02_JPRB,.247E-02_JPRB,.236E-02_JPRB,.225E-02_JPRB,.218E-02_JPRB,.210E-02_JPRB,.194E-02_JPRB,&
&.192E-02_JPRB,.193E-02_JPRB,.200E-02_JPRB,.231E-02_JPRB,.304E-02_JPRB,.485E-02_JPRB,.730E-02_JPRB,&
&.766E-02_JPRB,.701E-02_JPRB,.508E-02_JPRB,.409E-02_JPRB,.305E-02_JPRB,.223E-02_JPRB,.201E-02_JPRB,&
&.185E-02_JPRB,.170E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 18  22.0
ZAER (:,18, 9) = (/&
&.146E-02_JPRB,.146E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.129E-02_JPRB,.126E-02_JPRB,.119E-02_JPRB,&
&.114E-02_JPRB,.109E-02_JPRB,.101E-02_JPRB,.962E-03_JPRB,.927E-03_JPRB,.964E-03_JPRB,.102E-02_JPRB,&
&.113E-02_JPRB,.121E-02_JPRB,.127E-02_JPRB,.135E-02_JPRB,.177E-02_JPRB,.231E-02_JPRB,.304E-02_JPRB,&
&.417E-02_JPRB,.564E-02_JPRB,.726E-02_JPRB,.146E-01_JPRB,.153E-01_JPRB,.155E-01_JPRB,.910E-02_JPRB,&
&.680E-02_JPRB,.497E-02_JPRB,.361E-02_JPRB,.303E-02_JPRB,.267E-02_JPRB,.243E-02_JPRB,.290E-02_JPRB,&
&.347E-02_JPRB,.469E-02_JPRB,.656E-02_JPRB,.831E-02_JPRB,.111E-01_JPRB,.122E-01_JPRB,.123E-01_JPRB,&
&.122E-01_JPRB,.904E-02_JPRB,.707E-02_JPRB,.489E-02_JPRB,.363E-02_JPRB,.326E-02_JPRB,.292E-02_JPRB,&
&.258E-02_JPRB,.243E-02_JPRB,.230E-02_JPRB,.219E-02_JPRB,.214E-02_JPRB,.209E-02_JPRB,.196E-02_JPRB,&
&.207E-02_JPRB,.219E-02_JPRB,.248E-02_JPRB,.313E-02_JPRB,.426E-02_JPRB,.685E-02_JPRB,.966E-02_JPRB,&
&.973E-02_JPRB,.822E-02_JPRB,.518E-02_JPRB,.387E-02_JPRB,.262E-02_JPRB,.197E-02_JPRB,.177E-02_JPRB,&
&.161E-02_JPRB,.147E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 19  18.0
ZAER (:,19, 9) = (/&
&.108E-02_JPRB,.108E-02_JPRB,.974E-03_JPRB,.100E-02_JPRB,.103E-02_JPRB,.108E-02_JPRB,.106E-02_JPRB,&
&.105E-02_JPRB,.104E-02_JPRB,.100E-02_JPRB,.972E-03_JPRB,.940E-03_JPRB,.101E-02_JPRB,.109E-02_JPRB,&
&.126E-02_JPRB,.148E-02_JPRB,.166E-02_JPRB,.191E-02_JPRB,.262E-02_JPRB,.349E-02_JPRB,.464E-02_JPRB,&
&.601E-02_JPRB,.794E-02_JPRB,.101E-01_JPRB,.181E-01_JPRB,.188E-01_JPRB,.190E-01_JPRB,.119E-01_JPRB,&
&.869E-02_JPRB,.612E-02_JPRB,.387E-02_JPRB,.310E-02_JPRB,.265E-02_JPRB,.255E-02_JPRB,.329E-02_JPRB,&
&.412E-02_JPRB,.578E-02_JPRB,.871E-02_JPRB,.110E-01_JPRB,.142E-01_JPRB,.148E-01_JPRB,.143E-01_JPRB,&
&.132E-01_JPRB,.941E-02_JPRB,.736E-02_JPRB,.517E-02_JPRB,.372E-02_JPRB,.328E-02_JPRB,.288E-02_JPRB,&
&.252E-02_JPRB,.240E-02_JPRB,.228E-02_JPRB,.220E-02_JPRB,.215E-02_JPRB,.212E-02_JPRB,.206E-02_JPRB,&
&.230E-02_JPRB,.255E-02_JPRB,.307E-02_JPRB,.418E-02_JPRB,.556E-02_JPRB,.834E-02_JPRB,.100E-01_JPRB,&
&.950E-02_JPRB,.732E-02_JPRB,.414E-02_JPRB,.297E-02_JPRB,.198E-02_JPRB,.153E-02_JPRB,.137E-02_JPRB,&
&.123E-02_JPRB,.109E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 20  14.0
ZAER (:,20, 9) = (/&
&.753E-03_JPRB,.753E-03_JPRB,.728E-03_JPRB,.783E-03_JPRB,.838E-03_JPRB,.956E-03_JPRB,.999E-03_JPRB,&
&.104E-02_JPRB,.109E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.104E-02_JPRB,.112E-02_JPRB,.122E-02_JPRB,&
&.143E-02_JPRB,.188E-02_JPRB,.226E-02_JPRB,.277E-02_JPRB,.385E-02_JPRB,.495E-02_JPRB,.636E-02_JPRB,&
&.803E-02_JPRB,.101E-01_JPRB,.123E-01_JPRB,.194E-01_JPRB,.200E-01_JPRB,.202E-01_JPRB,.130E-01_JPRB,&
&.928E-02_JPRB,.628E-02_JPRB,.378E-02_JPRB,.319E-02_JPRB,.290E-02_JPRB,.302E-02_JPRB,.392E-02_JPRB,&
&.494E-02_JPRB,.706E-02_JPRB,.108E-01_JPRB,.128E-01_JPRB,.149E-01_JPRB,.143E-01_JPRB,.136E-01_JPRB,&
&.126E-01_JPRB,.929E-02_JPRB,.742E-02_JPRB,.539E-02_JPRB,.381E-02_JPRB,.335E-02_JPRB,.295E-02_JPRB,&
&.252E-02_JPRB,.243E-02_JPRB,.234E-02_JPRB,.228E-02_JPRB,.224E-02_JPRB,.222E-02_JPRB,.225E-02_JPRB,&
&.256E-02_JPRB,.290E-02_JPRB,.366E-02_JPRB,.500E-02_JPRB,.613E-02_JPRB,.795E-02_JPRB,.785E-02_JPRB,&
&.692E-02_JPRB,.497E-02_JPRB,.280E-02_JPRB,.206E-02_JPRB,.149E-02_JPRB,.116E-02_JPRB,.102E-02_JPRB,&
&.877E-03_JPRB,.757E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 21  10.0
ZAER (:,21, 9) = (/&
&.594E-03_JPRB,.595E-03_JPRB,.624E-03_JPRB,.693E-03_JPRB,.761E-03_JPRB,.900E-03_JPRB,.974E-03_JPRB,&
&.104E-02_JPRB,.116E-02_JPRB,.119E-02_JPRB,.120E-02_JPRB,.122E-02_JPRB,.135E-02_JPRB,.148E-02_JPRB,&
&.172E-02_JPRB,.237E-02_JPRB,.292E-02_JPRB,.370E-02_JPRB,.514E-02_JPRB,.635E-02_JPRB,.785E-02_JPRB,&
&.937E-02_JPRB,.113E-01_JPRB,.133E-01_JPRB,.190E-01_JPRB,.194E-01_JPRB,.193E-01_JPRB,.120E-01_JPRB,&
&.840E-02_JPRB,.555E-02_JPRB,.355E-02_JPRB,.338E-02_JPRB,.334E-02_JPRB,.363E-02_JPRB,.449E-02_JPRB,&
&.555E-02_JPRB,.782E-02_JPRB,.121E-01_JPRB,.141E-01_JPRB,.156E-01_JPRB,.138E-01_JPRB,.131E-01_JPRB,&
&.125E-01_JPRB,.959E-02_JPRB,.768E-02_JPRB,.555E-02_JPRB,.395E-02_JPRB,.351E-02_JPRB,.311E-02_JPRB,&
&.260E-02_JPRB,.251E-02_JPRB,.243E-02_JPRB,.235E-02_JPRB,.233E-02_JPRB,.233E-02_JPRB,.240E-02_JPRB,&
&.284E-02_JPRB,.331E-02_JPRB,.434E-02_JPRB,.535E-02_JPRB,.596E-02_JPRB,.660E-02_JPRB,.574E-02_JPRB,&
&.484E-02_JPRB,.341E-02_JPRB,.215E-02_JPRB,.167E-02_JPRB,.127E-02_JPRB,.974E-03_JPRB,.833E-03_JPRB,&
&.689E-03_JPRB,.597E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 22   6.0
ZAER (:,22, 9) = (/&
&.556E-03_JPRB,.557E-03_JPRB,.582E-03_JPRB,.642E-03_JPRB,.702E-03_JPRB,.837E-03_JPRB,.924E-03_JPRB,&
&.100E-02_JPRB,.115E-02_JPRB,.123E-02_JPRB,.130E-02_JPRB,.144E-02_JPRB,.162E-02_JPRB,.180E-02_JPRB,&
&.209E-02_JPRB,.282E-02_JPRB,.343E-02_JPRB,.429E-02_JPRB,.587E-02_JPRB,.712E-02_JPRB,.866E-02_JPRB,&
&.104E-01_JPRB,.120E-01_JPRB,.137E-01_JPRB,.167E-01_JPRB,.160E-01_JPRB,.150E-01_JPRB,.968E-02_JPRB,&
&.692E-02_JPRB,.477E-02_JPRB,.340E-02_JPRB,.349E-02_JPRB,.361E-02_JPRB,.391E-02_JPRB,.463E-02_JPRB,&
&.564E-02_JPRB,.792E-02_JPRB,.123E-01_JPRB,.144E-01_JPRB,.163E-01_JPRB,.143E-01_JPRB,.135E-01_JPRB,&
&.127E-01_JPRB,.952E-02_JPRB,.763E-02_JPRB,.555E-02_JPRB,.404E-02_JPRB,.360E-02_JPRB,.321E-02_JPRB,&
&.271E-02_JPRB,.260E-02_JPRB,.250E-02_JPRB,.232E-02_JPRB,.230E-02_JPRB,.232E-02_JPRB,.253E-02_JPRB,&
&.321E-02_JPRB,.381E-02_JPRB,.488E-02_JPRB,.544E-02_JPRB,.560E-02_JPRB,.545E-02_JPRB,.454E-02_JPRB,&
&.383E-02_JPRB,.282E-02_JPRB,.190E-02_JPRB,.153E-02_JPRB,.118E-02_JPRB,.913E-03_JPRB,.779E-03_JPRB,&
&.642E-03_JPRB,.559E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 23   2.0
ZAER (:,23, 9) = (/&
&.565E-03_JPRB,.565E-03_JPRB,.572E-03_JPRB,.602E-03_JPRB,.638E-03_JPRB,.751E-03_JPRB,.841E-03_JPRB,&
&.920E-03_JPRB,.106E-02_JPRB,.120E-02_JPRB,.132E-02_JPRB,.152E-02_JPRB,.176E-02_JPRB,.198E-02_JPRB,&
&.233E-02_JPRB,.310E-02_JPRB,.367E-02_JPRB,.444E-02_JPRB,.589E-02_JPRB,.710E-02_JPRB,.861E-02_JPRB,&
&.108E-01_JPRB,.118E-01_JPRB,.129E-01_JPRB,.130E-01_JPRB,.117E-01_JPRB,.102E-01_JPRB,.736E-02_JPRB,&
&.556E-02_JPRB,.415E-02_JPRB,.323E-02_JPRB,.335E-02_JPRB,.346E-02_JPRB,.369E-02_JPRB,.446E-02_JPRB,&
&.534E-02_JPRB,.717E-02_JPRB,.101E-01_JPRB,.115E-01_JPRB,.129E-01_JPRB,.124E-01_JPRB,.119E-01_JPRB,&
&.113E-01_JPRB,.842E-02_JPRB,.683E-02_JPRB,.513E-02_JPRB,.384E-02_JPRB,.342E-02_JPRB,.304E-02_JPRB,&
&.264E-02_JPRB,.251E-02_JPRB,.239E-02_JPRB,.217E-02_JPRB,.212E-02_JPRB,.214E-02_JPRB,.249E-02_JPRB,&
&.319E-02_JPRB,.376E-02_JPRB,.460E-02_JPRB,.504E-02_JPRB,.511E-02_JPRB,.481E-02_JPRB,.398E-02_JPRB,&
&.338E-02_JPRB,.257E-02_JPRB,.177E-02_JPRB,.145E-02_JPRB,.116E-02_JPRB,.913E-03_JPRB,.789E-03_JPRB,&
&.662E-03_JPRB,.568E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 24  -2.0
ZAER (:,24, 9) = (/&
&.574E-03_JPRB,.574E-03_JPRB,.561E-03_JPRB,.574E-03_JPRB,.592E-03_JPRB,.673E-03_JPRB,.751E-03_JPRB,&
&.823E-03_JPRB,.962E-03_JPRB,.112E-02_JPRB,.126E-02_JPRB,.151E-02_JPRB,.175E-02_JPRB,.195E-02_JPRB,&
&.226E-02_JPRB,.295E-02_JPRB,.342E-02_JPRB,.402E-02_JPRB,.510E-02_JPRB,.604E-02_JPRB,.721E-02_JPRB,&
&.906E-02_JPRB,.940E-02_JPRB,.964E-02_JPRB,.879E-02_JPRB,.781E-02_JPRB,.679E-02_JPRB,.477E-02_JPRB,&
&.386E-02_JPRB,.317E-02_JPRB,.285E-02_JPRB,.287E-02_JPRB,.293E-02_JPRB,.315E-02_JPRB,.381E-02_JPRB,&
&.440E-02_JPRB,.544E-02_JPRB,.656E-02_JPRB,.690E-02_JPRB,.688E-02_JPRB,.746E-02_JPRB,.769E-02_JPRB,&
&.789E-02_JPRB,.609E-02_JPRB,.518E-02_JPRB,.422E-02_JPRB,.346E-02_JPRB,.313E-02_JPRB,.282E-02_JPRB,&
&.240E-02_JPRB,.229E-02_JPRB,.219E-02_JPRB,.209E-02_JPRB,.203E-02_JPRB,.202E-02_JPRB,.223E-02_JPRB,&
&.266E-02_JPRB,.305E-02_JPRB,.377E-02_JPRB,.428E-02_JPRB,.441E-02_JPRB,.421E-02_JPRB,.359E-02_JPRB,&
&.312E-02_JPRB,.246E-02_JPRB,.174E-02_JPRB,.144E-02_JPRB,.115E-02_JPRB,.920E-03_JPRB,.810E-03_JPRB,&
&.698E-03_JPRB,.578E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 25  -6.0
ZAER (:,25, 9) = (/&
&.569E-03_JPRB,.568E-03_JPRB,.543E-03_JPRB,.547E-03_JPRB,.556E-03_JPRB,.611E-03_JPRB,.670E-03_JPRB,&
&.727E-03_JPRB,.838E-03_JPRB,.977E-03_JPRB,.110E-02_JPRB,.134E-02_JPRB,.153E-02_JPRB,.167E-02_JPRB,&
&.187E-02_JPRB,.236E-02_JPRB,.271E-02_JPRB,.316E-02_JPRB,.379E-02_JPRB,.436E-02_JPRB,.507E-02_JPRB,&
&.626E-02_JPRB,.642E-02_JPRB,.651E-02_JPRB,.568E-02_JPRB,.509E-02_JPRB,.447E-02_JPRB,.300E-02_JPRB,&
&.255E-02_JPRB,.223E-02_JPRB,.222E-02_JPRB,.225E-02_JPRB,.232E-02_JPRB,.255E-02_JPRB,.315E-02_JPRB,&
&.363E-02_JPRB,.436E-02_JPRB,.467E-02_JPRB,.455E-02_JPRB,.405E-02_JPRB,.447E-02_JPRB,.471E-02_JPRB,&
&.499E-02_JPRB,.401E-02_JPRB,.368E-02_JPRB,.340E-02_JPRB,.312E-02_JPRB,.295E-02_JPRB,.278E-02_JPRB,&
&.242E-02_JPRB,.240E-02_JPRB,.239E-02_JPRB,.251E-02_JPRB,.247E-02_JPRB,.243E-02_JPRB,.235E-02_JPRB,&
&.252E-02_JPRB,.276E-02_JPRB,.338E-02_JPRB,.390E-02_JPRB,.405E-02_JPRB,.390E-02_JPRB,.333E-02_JPRB,&
&.292E-02_JPRB,.236E-02_JPRB,.183E-02_JPRB,.153E-02_JPRB,.121E-02_JPRB,.930E-03_JPRB,.819E-03_JPRB,&
&.713E-03_JPRB,.574E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 26 -10.0
ZAER (:,26, 9) = (/&
&.562E-03_JPRB,.561E-03_JPRB,.542E-03_JPRB,.542E-03_JPRB,.545E-03_JPRB,.579E-03_JPRB,.625E-03_JPRB,&
&.668E-03_JPRB,.756E-03_JPRB,.850E-03_JPRB,.944E-03_JPRB,.113E-02_JPRB,.122E-02_JPRB,.130E-02_JPRB,&
&.142E-02_JPRB,.177E-02_JPRB,.201E-02_JPRB,.233E-02_JPRB,.265E-02_JPRB,.290E-02_JPRB,.321E-02_JPRB,&
&.394E-02_JPRB,.407E-02_JPRB,.415E-02_JPRB,.360E-02_JPRB,.328E-02_JPRB,.295E-02_JPRB,.210E-02_JPRB,&
&.185E-02_JPRB,.167E-02_JPRB,.169E-02_JPRB,.179E-02_JPRB,.189E-02_JPRB,.215E-02_JPRB,.260E-02_JPRB,&
&.294E-02_JPRB,.342E-02_JPRB,.350E-02_JPRB,.339E-02_JPRB,.305E-02_JPRB,.322E-02_JPRB,.338E-02_JPRB,&
&.361E-02_JPRB,.318E-02_JPRB,.308E-02_JPRB,.301E-02_JPRB,.300E-02_JPRB,.298E-02_JPRB,.296E-02_JPRB,&
&.293E-02_JPRB,.315E-02_JPRB,.337E-02_JPRB,.378E-02_JPRB,.363E-02_JPRB,.351E-02_JPRB,.333E-02_JPRB,&
&.355E-02_JPRB,.382E-02_JPRB,.446E-02_JPRB,.458E-02_JPRB,.446E-02_JPRB,.398E-02_JPRB,.339E-02_JPRB,&
&.296E-02_JPRB,.236E-02_JPRB,.191E-02_JPRB,.162E-02_JPRB,.129E-02_JPRB,.973E-03_JPRB,.842E-03_JPRB,&
&.716E-03_JPRB,.567E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 27 -14.0
ZAER (:,27, 9) = (/&
&.569E-03_JPRB,.569E-03_JPRB,.565E-03_JPRB,.566E-03_JPRB,.569E-03_JPRB,.599E-03_JPRB,.642E-03_JPRB,&
&.680E-03_JPRB,.747E-03_JPRB,.812E-03_JPRB,.873E-03_JPRB,.984E-03_JPRB,.103E-02_JPRB,.107E-02_JPRB,&
&.113E-02_JPRB,.147E-02_JPRB,.166E-02_JPRB,.187E-02_JPRB,.202E-02_JPRB,.212E-02_JPRB,.223E-02_JPRB,&
&.260E-02_JPRB,.270E-02_JPRB,.279E-02_JPRB,.237E-02_JPRB,.219E-02_JPRB,.200E-02_JPRB,.162E-02_JPRB,&
&.151E-02_JPRB,.142E-02_JPRB,.143E-02_JPRB,.150E-02_JPRB,.159E-02_JPRB,.178E-02_JPRB,.209E-02_JPRB,&
&.232E-02_JPRB,.263E-02_JPRB,.271E-02_JPRB,.271E-02_JPRB,.266E-02_JPRB,.277E-02_JPRB,.291E-02_JPRB,&
&.311E-02_JPRB,.310E-02_JPRB,.315E-02_JPRB,.321E-02_JPRB,.335E-02_JPRB,.346E-02_JPRB,.358E-02_JPRB,&
&.394E-02_JPRB,.449E-02_JPRB,.501E-02_JPRB,.572E-02_JPRB,.554E-02_JPRB,.543E-02_JPRB,.550E-02_JPRB,&
&.624E-02_JPRB,.684E-02_JPRB,.777E-02_JPRB,.648E-02_JPRB,.560E-02_JPRB,.445E-02_JPRB,.377E-02_JPRB,&
&.325E-02_JPRB,.253E-02_JPRB,.191E-02_JPRB,.162E-02_JPRB,.133E-02_JPRB,.102E-02_JPRB,.867E-03_JPRB,&
&.710E-03_JPRB,.573E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 28 -18.0
ZAER (:,28, 9) = (/&
&.581E-03_JPRB,.581E-03_JPRB,.593E-03_JPRB,.601E-03_JPRB,.612E-03_JPRB,.647E-03_JPRB,.688E-03_JPRB,&
&.721E-03_JPRB,.770E-03_JPRB,.819E-03_JPRB,.867E-03_JPRB,.962E-03_JPRB,.101E-02_JPRB,.104E-02_JPRB,&
&.108E-02_JPRB,.141E-02_JPRB,.157E-02_JPRB,.173E-02_JPRB,.179E-02_JPRB,.183E-02_JPRB,.188E-02_JPRB,&
&.194E-02_JPRB,.200E-02_JPRB,.207E-02_JPRB,.181E-02_JPRB,.162E-02_JPRB,.143E-02_JPRB,.126E-02_JPRB,&
&.125E-02_JPRB,.124E-02_JPRB,.126E-02_JPRB,.132E-02_JPRB,.139E-02_JPRB,.154E-02_JPRB,.179E-02_JPRB,&
&.197E-02_JPRB,.221E-02_JPRB,.234E-02_JPRB,.243E-02_JPRB,.254E-02_JPRB,.269E-02_JPRB,.282E-02_JPRB,&
&.299E-02_JPRB,.318E-02_JPRB,.338E-02_JPRB,.362E-02_JPRB,.409E-02_JPRB,.432E-02_JPRB,.455E-02_JPRB,&
&.512E-02_JPRB,.575E-02_JPRB,.635E-02_JPRB,.724E-02_JPRB,.712E-02_JPRB,.715E-02_JPRB,.789E-02_JPRB,&
&.987E-02_JPRB,.113E-01_JPRB,.129E-01_JPRB,.961E-02_JPRB,.757E-02_JPRB,.526E-02_JPRB,.413E-02_JPRB,&
&.344E-02_JPRB,.262E-02_JPRB,.185E-02_JPRB,.158E-02_JPRB,.135E-02_JPRB,.107E-02_JPRB,.907E-03_JPRB,&
&.734E-03_JPRB,.586E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 29 -22.0
ZAER (:,29, 9) = (/&
&.614E-03_JPRB,.615E-03_JPRB,.631E-03_JPRB,.640E-03_JPRB,.651E-03_JPRB,.691E-03_JPRB,.737E-03_JPRB,&
&.770E-03_JPRB,.801E-03_JPRB,.836E-03_JPRB,.884E-03_JPRB,.100E-02_JPRB,.111E-02_JPRB,.116E-02_JPRB,&
&.120E-02_JPRB,.143E-02_JPRB,.158E-02_JPRB,.175E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.183E-02_JPRB,&
&.169E-02_JPRB,.166E-02_JPRB,.164E-02_JPRB,.149E-02_JPRB,.130E-02_JPRB,.111E-02_JPRB,.985E-03_JPRB,&
&.102E-02_JPRB,.105E-02_JPRB,.112E-02_JPRB,.122E-02_JPRB,.131E-02_JPRB,.144E-02_JPRB,.167E-02_JPRB,&
&.184E-02_JPRB,.209E-02_JPRB,.227E-02_JPRB,.240E-02_JPRB,.258E-02_JPRB,.285E-02_JPRB,.302E-02_JPRB,&
&.322E-02_JPRB,.334E-02_JPRB,.360E-02_JPRB,.395E-02_JPRB,.475E-02_JPRB,.508E-02_JPRB,.539E-02_JPRB,&
&.594E-02_JPRB,.631E-02_JPRB,.665E-02_JPRB,.714E-02_JPRB,.690E-02_JPRB,.701E-02_JPRB,.875E-02_JPRB,&
&.127E-01_JPRB,.154E-01_JPRB,.185E-01_JPRB,.138E-01_JPRB,.106E-01_JPRB,.650E-02_JPRB,.429E-02_JPRB,&
&.332E-02_JPRB,.251E-02_JPRB,.183E-02_JPRB,.160E-02_JPRB,.142E-02_JPRB,.112E-02_JPRB,.954E-03_JPRB,&
&.781E-03_JPRB,.619E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 30 -26.0
ZAER (:,30, 9) = (/&
&.706E-03_JPRB,.706E-03_JPRB,.704E-03_JPRB,.691E-03_JPRB,.685E-03_JPRB,.728E-03_JPRB,.784E-03_JPRB,&
&.821E-03_JPRB,.840E-03_JPRB,.859E-03_JPRB,.908E-03_JPRB,.106E-02_JPRB,.126E-02_JPRB,.135E-02_JPRB,&
&.139E-02_JPRB,.149E-02_JPRB,.164E-02_JPRB,.188E-02_JPRB,.216E-02_JPRB,.214E-02_JPRB,.204E-02_JPRB,&
&.174E-02_JPRB,.160E-02_JPRB,.147E-02_JPRB,.125E-02_JPRB,.109E-02_JPRB,.936E-03_JPRB,.827E-03_JPRB,&
&.854E-03_JPRB,.886E-03_JPRB,.982E-03_JPRB,.113E-02_JPRB,.125E-02_JPRB,.142E-02_JPRB,.162E-02_JPRB,&
&.179E-02_JPRB,.207E-02_JPRB,.228E-02_JPRB,.247E-02_JPRB,.275E-02_JPRB,.320E-02_JPRB,.347E-02_JPRB,&
&.379E-02_JPRB,.368E-02_JPRB,.385E-02_JPRB,.412E-02_JPRB,.499E-02_JPRB,.540E-02_JPRB,.579E-02_JPRB,&
&.622E-02_JPRB,.612E-02_JPRB,.600E-02_JPRB,.559E-02_JPRB,.527E-02_JPRB,.549E-02_JPRB,.836E-02_JPRB,&
&.142E-01_JPRB,.183E-01_JPRB,.232E-01_JPRB,.185E-01_JPRB,.146E-01_JPRB,.830E-02_JPRB,.460E-02_JPRB,&
&.320E-02_JPRB,.237E-02_JPRB,.187E-02_JPRB,.170E-02_JPRB,.156E-02_JPRB,.120E-02_JPRB,.103E-02_JPRB,&
&.847E-03_JPRB,.711E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 31 -30.0
ZAER (:,31, 9) = (/&
&.923E-03_JPRB,.921E-03_JPRB,.852E-03_JPRB,.783E-03_JPRB,.733E-03_JPRB,.770E-03_JPRB,.835E-03_JPRB,&
&.878E-03_JPRB,.899E-03_JPRB,.898E-03_JPRB,.947E-03_JPRB,.113E-02_JPRB,.140E-02_JPRB,.150E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.171E-02_JPRB,.205E-02_JPRB,.258E-02_JPRB,.259E-02_JPRB,.248E-02_JPRB,&
&.202E-02_JPRB,.178E-02_JPRB,.153E-02_JPRB,.114E-02_JPRB,.993E-03_JPRB,.856E-03_JPRB,.783E-03_JPRB,&
&.789E-03_JPRB,.803E-03_JPRB,.879E-03_JPRB,.102E-02_JPRB,.115E-02_JPRB,.137E-02_JPRB,.158E-02_JPRB,&
&.174E-02_JPRB,.200E-02_JPRB,.225E-02_JPRB,.252E-02_JPRB,.298E-02_JPRB,.387E-02_JPRB,.432E-02_JPRB,&
&.481E-02_JPRB,.446E-02_JPRB,.442E-02_JPRB,.443E-02_JPRB,.511E-02_JPRB,.562E-02_JPRB,.614E-02_JPRB,&
&.642E-02_JPRB,.582E-02_JPRB,.522E-02_JPRB,.395E-02_JPRB,.369E-02_JPRB,.403E-02_JPRB,.737E-02_JPRB,&
&.138E-01_JPRB,.186E-01_JPRB,.249E-01_JPRB,.217E-01_JPRB,.179E-01_JPRB,.103E-01_JPRB,.556E-02_JPRB,&
&.371E-02_JPRB,.252E-02_JPRB,.207E-02_JPRB,.192E-02_JPRB,.182E-02_JPRB,.144E-02_JPRB,.125E-02_JPRB,&
&.105E-02_JPRB,.927E-03_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 32 -34.0
ZAER (:,32, 9) = (/&
&.130E-02_JPRB,.129E-02_JPRB,.108E-02_JPRB,.945E-03_JPRB,.840E-03_JPRB,.843E-03_JPRB,.904E-03_JPRB,&
&.944E-03_JPRB,.966E-03_JPRB,.949E-03_JPRB,.994E-03_JPRB,.119E-02_JPRB,.144E-02_JPRB,.153E-02_JPRB,&
&.153E-02_JPRB,.152E-02_JPRB,.173E-02_JPRB,.214E-02_JPRB,.286E-02_JPRB,.297E-02_JPRB,.297E-02_JPRB,&
&.241E-02_JPRB,.206E-02_JPRB,.169E-02_JPRB,.114E-02_JPRB,.991E-03_JPRB,.856E-03_JPRB,.801E-03_JPRB,&
&.799E-03_JPRB,.802E-03_JPRB,.836E-03_JPRB,.927E-03_JPRB,.103E-02_JPRB,.127E-02_JPRB,.158E-02_JPRB,&
&.179E-02_JPRB,.204E-02_JPRB,.239E-02_JPRB,.279E-02_JPRB,.348E-02_JPRB,.514E-02_JPRB,.594E-02_JPRB,&
&.674E-02_JPRB,.613E-02_JPRB,.582E-02_JPRB,.551E-02_JPRB,.583E-02_JPRB,.641E-02_JPRB,.703E-02_JPRB,&
&.715E-02_JPRB,.618E-02_JPRB,.522E-02_JPRB,.342E-02_JPRB,.320E-02_JPRB,.345E-02_JPRB,.600E-02_JPRB,&
&.113E-01_JPRB,.156E-01_JPRB,.222E-01_JPRB,.212E-01_JPRB,.184E-01_JPRB,.116E-01_JPRB,.691E-02_JPRB,&
&.484E-02_JPRB,.312E-02_JPRB,.250E-02_JPRB,.231E-02_JPRB,.218E-02_JPRB,.188E-02_JPRB,.169E-02_JPRB,&
&.148E-02_JPRB,.130E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 33 -38.0
ZAER (:,33, 9) = (/&
&.173E-02_JPRB,.172E-02_JPRB,.135E-02_JPRB,.117E-02_JPRB,.103E-02_JPRB,.982E-03_JPRB,.101E-02_JPRB,&
&.103E-02_JPRB,.103E-02_JPRB,.101E-02_JPRB,.104E-02_JPRB,.121E-02_JPRB,.138E-02_JPRB,.143E-02_JPRB,&
&.140E-02_JPRB,.145E-02_JPRB,.167E-02_JPRB,.209E-02_JPRB,.285E-02_JPRB,.305E-02_JPRB,.318E-02_JPRB,&
&.269E-02_JPRB,.227E-02_JPRB,.182E-02_JPRB,.119E-02_JPRB,.104E-02_JPRB,.911E-03_JPRB,.832E-03_JPRB,&
&.825E-03_JPRB,.821E-03_JPRB,.831E-03_JPRB,.874E-03_JPRB,.950E-03_JPRB,.120E-02_JPRB,.172E-02_JPRB,&
&.208E-02_JPRB,.251E-02_JPRB,.334E-02_JPRB,.408E-02_JPRB,.523E-02_JPRB,.784E-02_JPRB,.904E-02_JPRB,&
&.102E-01_JPRB,.916E-02_JPRB,.859E-02_JPRB,.797E-02_JPRB,.774E-02_JPRB,.814E-02_JPRB,.860E-02_JPRB,&
&.848E-02_JPRB,.733E-02_JPRB,.621E-02_JPRB,.427E-02_JPRB,.391E-02_JPRB,.382E-02_JPRB,.484E-02_JPRB,&
&.788E-02_JPRB,.107E-01_JPRB,.159E-01_JPRB,.166E-01_JPRB,.154E-01_JPRB,.112E-01_JPRB,.770E-02_JPRB,&
&.586E-02_JPRB,.395E-02_JPRB,.308E-02_JPRB,.277E-02_JPRB,.253E-02_JPRB,.231E-02_JPRB,.215E-02_JPRB,&
&.198E-02_JPRB,.174E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 34 -42.0
ZAER (:,34, 9) = (/&
&.201E-02_JPRB,.200E-02_JPRB,.157E-02_JPRB,.140E-02_JPRB,.126E-02_JPRB,.116E-02_JPRB,.114E-02_JPRB,&
&.112E-02_JPRB,.112E-02_JPRB,.109E-02_JPRB,.110E-02_JPRB,.119E-02_JPRB,.129E-02_JPRB,.131E-02_JPRB,&
&.129E-02_JPRB,.135E-02_JPRB,.154E-02_JPRB,.188E-02_JPRB,.252E-02_JPRB,.271E-02_JPRB,.285E-02_JPRB,&
&.259E-02_JPRB,.224E-02_JPRB,.185E-02_JPRB,.125E-02_JPRB,.111E-02_JPRB,.982E-03_JPRB,.867E-03_JPRB,&
&.847E-03_JPRB,.833E-03_JPRB,.835E-03_JPRB,.882E-03_JPRB,.975E-03_JPRB,.129E-02_JPRB,.217E-02_JPRB,&
&.289E-02_JPRB,.403E-02_JPRB,.655E-02_JPRB,.827E-02_JPRB,.105E-01_JPRB,.133E-01_JPRB,.145E-01_JPRB,&
&.155E-01_JPRB,.141E-01_JPRB,.132E-01_JPRB,.121E-01_JPRB,.110E-01_JPRB,.108E-01_JPRB,.107E-01_JPRB,&
&.101E-01_JPRB,.886E-02_JPRB,.771E-02_JPRB,.592E-02_JPRB,.530E-02_JPRB,.486E-02_JPRB,.465E-02_JPRB,&
&.565E-02_JPRB,.680E-02_JPRB,.945E-02_JPRB,.108E-01_JPRB,.108E-01_JPRB,.934E-02_JPRB,.732E-02_JPRB,&
&.604E-02_JPRB,.448E-02_JPRB,.354E-02_JPRB,.313E-02_JPRB,.275E-02_JPRB,.246E-02_JPRB,.236E-02_JPRB,&
&.226E-02_JPRB,.202E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 35 -46.0
ZAER (:,35, 9) = (/&
&.200E-02_JPRB,.199E-02_JPRB,.165E-02_JPRB,.152E-02_JPRB,.141E-02_JPRB,.127E-02_JPRB,.122E-02_JPRB,&
&.119E-02_JPRB,.118E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,.115E-02_JPRB,.121E-02_JPRB,.123E-02_JPRB,&
&.125E-02_JPRB,.131E-02_JPRB,.143E-02_JPRB,.163E-02_JPRB,.200E-02_JPRB,.211E-02_JPRB,.219E-02_JPRB,&
&.208E-02_JPRB,.188E-02_JPRB,.165E-02_JPRB,.125E-02_JPRB,.113E-02_JPRB,.102E-02_JPRB,.914E-03_JPRB,&
&.886E-03_JPRB,.866E-03_JPRB,.869E-03_JPRB,.966E-03_JPRB,.113E-02_JPRB,.168E-02_JPRB,.326E-02_JPRB,&
&.479E-02_JPRB,.761E-02_JPRB,.139E-01_JPRB,.176E-01_JPRB,.218E-01_JPRB,.222E-01_JPRB,.223E-01_JPRB,&
&.222E-01_JPRB,.210E-01_JPRB,.194E-01_JPRB,.176E-01_JPRB,.150E-01_JPRB,.139E-01_JPRB,.128E-01_JPRB,&
&.115E-01_JPRB,.104E-01_JPRB,.931E-02_JPRB,.764E-02_JPRB,.677E-02_JPRB,.608E-02_JPRB,.530E-02_JPRB,&
&.524E-02_JPRB,.536E-02_JPRB,.596E-02_JPRB,.694E-02_JPRB,.729E-02_JPRB,.722E-02_JPRB,.606E-02_JPRB,&
&.528E-02_JPRB,.429E-02_JPRB,.356E-02_JPRB,.316E-02_JPRB,.273E-02_JPRB,.236E-02_JPRB,.228E-02_JPRB,&
&.221E-02_JPRB,.200E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 36 -50.0
ZAER (:,36, 9) = (/&
&.177E-02_JPRB,.176E-02_JPRB,.156E-02_JPRB,.148E-02_JPRB,.141E-02_JPRB,.129E-02_JPRB,.124E-02_JPRB,&
&.121E-02_JPRB,.118E-02_JPRB,.115E-02_JPRB,.112E-02_JPRB,.108E-02_JPRB,.111E-02_JPRB,.114E-02_JPRB,&
&.121E-02_JPRB,.127E-02_JPRB,.132E-02_JPRB,.141E-02_JPRB,.155E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.147E-02_JPRB,.140E-02_JPRB,.132E-02_JPRB,.115E-02_JPRB,.108E-02_JPRB,.101E-02_JPRB,.933E-03_JPRB,&
&.916E-03_JPRB,.907E-03_JPRB,.934E-03_JPRB,.111E-02_JPRB,.140E-02_JPRB,.234E-02_JPRB,.484E-02_JPRB,&
&.751E-02_JPRB,.128E-01_JPRB,.230E-01_JPRB,.288E-01_JPRB,.350E-01_JPRB,.316E-01_JPRB,.299E-01_JPRB,&
&.281E-01_JPRB,.265E-01_JPRB,.244E-01_JPRB,.216E-01_JPRB,.176E-01_JPRB,.159E-01_JPRB,.142E-01_JPRB,&
&.124E-01_JPRB,.115E-01_JPRB,.107E-01_JPRB,.914E-02_JPRB,.812E-02_JPRB,.728E-02_JPRB,.615E-02_JPRB,&
&.565E-02_JPRB,.529E-02_JPRB,.487E-02_JPRB,.513E-02_JPRB,.525E-02_JPRB,.529E-02_JPRB,.458E-02_JPRB,&
&.411E-02_JPRB,.350E-02_JPRB,.307E-02_JPRB,.279E-02_JPRB,.245E-02_JPRB,.211E-02_JPRB,.202E-02_JPRB,&
&.195E-02_JPRB,.177E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 37 -54.0
ZAER (:,37, 9) = (/&
&.156E-02_JPRB,.155E-02_JPRB,.143E-02_JPRB,.137E-02_JPRB,.132E-02_JPRB,.126E-02_JPRB,.122E-02_JPRB,&
&.119E-02_JPRB,.114E-02_JPRB,.109E-02_JPRB,.105E-02_JPRB,.997E-03_JPRB,.101E-02_JPRB,.104E-02_JPRB,&
&.110E-02_JPRB,.115E-02_JPRB,.118E-02_JPRB,.120E-02_JPRB,.124E-02_JPRB,.123E-02_JPRB,.121E-02_JPRB,&
&.112E-02_JPRB,.110E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.103E-02_JPRB,.993E-03_JPRB,.922E-03_JPRB,&
&.916E-03_JPRB,.922E-03_JPRB,.101E-02_JPRB,.124E-02_JPRB,.162E-02_JPRB,.283E-02_JPRB,.554E-02_JPRB,&
&.833E-02_JPRB,.137E-01_JPRB,.224E-01_JPRB,.274E-01_JPRB,.328E-01_JPRB,.310E-01_JPRB,.297E-01_JPRB,&
&.280E-01_JPRB,.259E-01_JPRB,.235E-01_JPRB,.206E-01_JPRB,.167E-01_JPRB,.153E-01_JPRB,.141E-01_JPRB,&
&.125E-01_JPRB,.118E-01_JPRB,.110E-01_JPRB,.979E-02_JPRB,.874E-02_JPRB,.783E-02_JPRB,.644E-02_JPRB,&
&.565E-02_JPRB,.507E-02_JPRB,.433E-02_JPRB,.408E-02_JPRB,.392E-02_JPRB,.375E-02_JPRB,.330E-02_JPRB,&
&.302E-02_JPRB,.267E-02_JPRB,.236E-02_JPRB,.219E-02_JPRB,.200E-02_JPRB,.182E-02_JPRB,.175E-02_JPRB,&
&.169E-02_JPRB,.156E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 38 -58.0
ZAER (:,38, 9) = (/&
&.139E-02_JPRB,.139E-02_JPRB,.128E-02_JPRB,.124E-02_JPRB,.121E-02_JPRB,.116E-02_JPRB,.114E-02_JPRB,&
&.111E-02_JPRB,.107E-02_JPRB,.102E-02_JPRB,.990E-03_JPRB,.950E-03_JPRB,.955E-03_JPRB,.966E-03_JPRB,&
&.991E-03_JPRB,.100E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.104E-02_JPRB,&
&.102E-02_JPRB,.102E-02_JPRB,.103E-02_JPRB,.101E-02_JPRB,.977E-03_JPRB,.945E-03_JPRB,.886E-03_JPRB,&
&.896E-03_JPRB,.928E-03_JPRB,.112E-02_JPRB,.148E-02_JPRB,.195E-02_JPRB,.319E-02_JPRB,.535E-02_JPRB,&
&.717E-02_JPRB,.102E-01_JPRB,.136E-01_JPRB,.158E-01_JPRB,.184E-01_JPRB,.191E-01_JPRB,.193E-01_JPRB,&
&.194E-01_JPRB,.186E-01_JPRB,.173E-01_JPRB,.157E-01_JPRB,.133E-01_JPRB,.126E-01_JPRB,.119E-01_JPRB,&
&.108E-01_JPRB,.102E-01_JPRB,.955E-02_JPRB,.843E-02_JPRB,.765E-02_JPRB,.696E-02_JPRB,.579E-02_JPRB,&
&.504E-02_JPRB,.449E-02_JPRB,.377E-02_JPRB,.336E-02_JPRB,.310E-02_JPRB,.281E-02_JPRB,.249E-02_JPRB,&
&.229E-02_JPRB,.205E-02_JPRB,.184E-02_JPRB,.174E-02_JPRB,.165E-02_JPRB,.157E-02_JPRB,.154E-02_JPRB,&
&.150E-02_JPRB,.140E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 39 -62.0
ZAER (:,39, 9) = (/&
&.128E-02_JPRB,.128E-02_JPRB,.115E-02_JPRB,.111E-02_JPRB,.108E-02_JPRB,.104E-02_JPRB,.102E-02_JPRB,&
&.996E-03_JPRB,.961E-03_JPRB,.937E-03_JPRB,.921E-03_JPRB,.905E-03_JPRB,.911E-03_JPRB,.915E-03_JPRB,&
&.920E-03_JPRB,.912E-03_JPRB,.910E-03_JPRB,.910E-03_JPRB,.929E-03_JPRB,.949E-03_JPRB,.975E-03_JPRB,&
&.101E-02_JPRB,.101E-02_JPRB,.101E-02_JPRB,.953E-03_JPRB,.906E-03_JPRB,.861E-03_JPRB,.815E-03_JPRB,&
&.853E-03_JPRB,.922E-03_JPRB,.124E-02_JPRB,.175E-02_JPRB,.229E-02_JPRB,.345E-02_JPRB,.473E-02_JPRB,&
&.560E-02_JPRB,.671E-02_JPRB,.755E-02_JPRB,.814E-02_JPRB,.892E-02_JPRB,.956E-02_JPRB,.988E-02_JPRB,&
&.102E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.101E-01_JPRB,.935E-02_JPRB,.889E-02_JPRB,.842E-02_JPRB,&
&.753E-02_JPRB,.709E-02_JPRB,.668E-02_JPRB,.613E-02_JPRB,.580E-02_JPRB,.550E-02_JPRB,.491E-02_JPRB,&
&.444E-02_JPRB,.407E-02_JPRB,.352E-02_JPRB,.314E-02_JPRB,.287E-02_JPRB,.251E-02_JPRB,.215E-02_JPRB,&
&.196E-02_JPRB,.176E-02_JPRB,.162E-02_JPRB,.156E-02_JPRB,.151E-02_JPRB,.147E-02_JPRB,.144E-02_JPRB,&
&.139E-02_JPRB,.129E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 40 -66.0
ZAER (:,40, 9) = (/&
&.122E-02_JPRB,.121E-02_JPRB,.110E-02_JPRB,.105E-02_JPRB,.101E-02_JPRB,.969E-03_JPRB,.948E-03_JPRB,&
&.931E-03_JPRB,.909E-03_JPRB,.899E-03_JPRB,.894E-03_JPRB,.895E-03_JPRB,.901E-03_JPRB,.905E-03_JPRB,&
&.909E-03_JPRB,.911E-03_JPRB,.915E-03_JPRB,.921E-03_JPRB,.942E-03_JPRB,.958E-03_JPRB,.977E-03_JPRB,&
&.100E-02_JPRB,.997E-03_JPRB,.991E-03_JPRB,.923E-03_JPRB,.877E-03_JPRB,.834E-03_JPRB,.795E-03_JPRB,&
&.845E-03_JPRB,.921E-03_JPRB,.123E-02_JPRB,.167E-02_JPRB,.207E-02_JPRB,.286E-02_JPRB,.353E-02_JPRB,&
&.396E-02_JPRB,.445E-02_JPRB,.474E-02_JPRB,.494E-02_JPRB,.520E-02_JPRB,.548E-02_JPRB,.565E-02_JPRB,&
&.585E-02_JPRB,.615E-02_JPRB,.623E-02_JPRB,.630E-02_JPRB,.608E-02_JPRB,.584E-02_JPRB,.557E-02_JPRB,&
&.508E-02_JPRB,.488E-02_JPRB,.469E-02_JPRB,.449E-02_JPRB,.441E-02_JPRB,.432E-02_JPRB,.413E-02_JPRB,&
&.393E-02_JPRB,.376E-02_JPRB,.344E-02_JPRB,.310E-02_JPRB,.286E-02_JPRB,.250E-02_JPRB,.217E-02_JPRB,&
&.200E-02_JPRB,.181E-02_JPRB,.166E-02_JPRB,.160E-02_JPRB,.153E-02_JPRB,.145E-02_JPRB,.140E-02_JPRB,&
&.134E-02_JPRB,.122E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 41 -70.0
ZAER (:,41, 9) = (/&
&.121E-02_JPRB,.121E-02_JPRB,.110E-02_JPRB,.106E-02_JPRB,.102E-02_JPRB,.980E-03_JPRB,.961E-03_JPRB,&
&.947E-03_JPRB,.936E-03_JPRB,.935E-03_JPRB,.937E-03_JPRB,.944E-03_JPRB,.952E-03_JPRB,.957E-03_JPRB,&
&.962E-03_JPRB,.968E-03_JPRB,.973E-03_JPRB,.979E-03_JPRB,.989E-03_JPRB,.996E-03_JPRB,.100E-02_JPRB,&
&.101E-02_JPRB,.997E-03_JPRB,.987E-03_JPRB,.942E-03_JPRB,.913E-03_JPRB,.886E-03_JPRB,.872E-03_JPRB,&
&.925E-03_JPRB,.994E-03_JPRB,.124E-02_JPRB,.154E-02_JPRB,.180E-02_JPRB,.226E-02_JPRB,.259E-02_JPRB,&
&.280E-02_JPRB,.301E-02_JPRB,.315E-02_JPRB,.323E-02_JPRB,.333E-02_JPRB,.347E-02_JPRB,.356E-02_JPRB,&
&.366E-02_JPRB,.381E-02_JPRB,.386E-02_JPRB,.390E-02_JPRB,.379E-02_JPRB,.369E-02_JPRB,.357E-02_JPRB,&
&.340E-02_JPRB,.337E-02_JPRB,.334E-02_JPRB,.336E-02_JPRB,.340E-02_JPRB,.343E-02_JPRB,.346E-02_JPRB,&
&.340E-02_JPRB,.333E-02_JPRB,.315E-02_JPRB,.291E-02_JPRB,.273E-02_JPRB,.248E-02_JPRB,.225E-02_JPRB,&
&.211E-02_JPRB,.196E-02_JPRB,.180E-02_JPRB,.172E-02_JPRB,.163E-02_JPRB,.150E-02_JPRB,.142E-02_JPRB,&
&.135E-02_JPRB,.122E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 42 -74.0
ZAER (:,42, 9) = (/&
&.131E-02_JPRB,.131E-02_JPRB,.121E-02_JPRB,.117E-02_JPRB,.113E-02_JPRB,.109E-02_JPRB,.106E-02_JPRB,&
&.105E-02_JPRB,.104E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.104E-02_JPRB,.105E-02_JPRB,&
&.105E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,.107E-02_JPRB,.107E-02_JPRB,.106E-02_JPRB,.106E-02_JPRB,&
&.106E-02_JPRB,.105E-02_JPRB,.104E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.106E-02_JPRB,&
&.112E-02_JPRB,.119E-02_JPRB,.137E-02_JPRB,.154E-02_JPRB,.169E-02_JPRB,.194E-02_JPRB,.212E-02_JPRB,&
&.224E-02_JPRB,.237E-02_JPRB,.244E-02_JPRB,.249E-02_JPRB,.254E-02_JPRB,.261E-02_JPRB,.266E-02_JPRB,&
&.272E-02_JPRB,.279E-02_JPRB,.282E-02_JPRB,.284E-02_JPRB,.283E-02_JPRB,.282E-02_JPRB,.280E-02_JPRB,&
&.279E-02_JPRB,.282E-02_JPRB,.285E-02_JPRB,.293E-02_JPRB,.299E-02_JPRB,.304E-02_JPRB,.307E-02_JPRB,&
&.304E-02_JPRB,.299E-02_JPRB,.286E-02_JPRB,.269E-02_JPRB,.257E-02_JPRB,.239E-02_JPRB,.223E-02_JPRB,&
&.214E-02_JPRB,.201E-02_JPRB,.188E-02_JPRB,.181E-02_JPRB,.171E-02_JPRB,.158E-02_JPRB,.151E-02_JPRB,&
&.143E-02_JPRB,.131E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 43 -78.0
ZAER (:,43, 9) = (/&
&.146E-02_JPRB,.145E-02_JPRB,.138E-02_JPRB,.135E-02_JPRB,.132E-02_JPRB,.128E-02_JPRB,.125E-02_JPRB,&
&.124E-02_JPRB,.122E-02_JPRB,.120E-02_JPRB,.120E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.119E-02_JPRB,.119E-02_JPRB,.118E-02_JPRB,.118E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,.119E-02_JPRB,&
&.120E-02_JPRB,.120E-02_JPRB,.121E-02_JPRB,.123E-02_JPRB,.125E-02_JPRB,.126E-02_JPRB,.131E-02_JPRB,&
&.137E-02_JPRB,.142E-02_JPRB,.152E-02_JPRB,.162E-02_JPRB,.170E-02_JPRB,.182E-02_JPRB,.192E-02_JPRB,&
&.198E-02_JPRB,.207E-02_JPRB,.214E-02_JPRB,.218E-02_JPRB,.223E-02_JPRB,.229E-02_JPRB,.232E-02_JPRB,&
&.236E-02_JPRB,.241E-02_JPRB,.243E-02_JPRB,.246E-02_JPRB,.249E-02_JPRB,.251E-02_JPRB,.253E-02_JPRB,&
&.256E-02_JPRB,.258E-02_JPRB,.261E-02_JPRB,.265E-02_JPRB,.267E-02_JPRB,.267E-02_JPRB,.266E-02_JPRB,&
&.262E-02_JPRB,.257E-02_JPRB,.248E-02_JPRB,.238E-02_JPRB,.230E-02_JPRB,.219E-02_JPRB,.210E-02_JPRB,&
&.203E-02_JPRB,.195E-02_JPRB,.186E-02_JPRB,.180E-02_JPRB,.173E-02_JPRB,.164E-02_JPRB,.159E-02_JPRB,&
&.154E-02_JPRB,.146E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 44 -82.0
ZAER (:,44, 9) = (/&
&.156E-02_JPRB,.156E-02_JPRB,.153E-02_JPRB,.150E-02_JPRB,.149E-02_JPRB,.146E-02_JPRB,.145E-02_JPRB,&
&.144E-02_JPRB,.142E-02_JPRB,.141E-02_JPRB,.141E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.139E-02_JPRB,&
&.139E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,&
&.141E-02_JPRB,.142E-02_JPRB,.143E-02_JPRB,.146E-02_JPRB,.148E-02_JPRB,.149E-02_JPRB,.153E-02_JPRB,&
&.156E-02_JPRB,.158E-02_JPRB,.163E-02_JPRB,.167E-02_JPRB,.171E-02_JPRB,.176E-02_JPRB,.180E-02_JPRB,&
&.184E-02_JPRB,.188E-02_JPRB,.192E-02_JPRB,.195E-02_JPRB,.199E-02_JPRB,.202E-02_JPRB,.204E-02_JPRB,&
&.206E-02_JPRB,.210E-02_JPRB,.211E-02_JPRB,.213E-02_JPRB,.215E-02_JPRB,.217E-02_JPRB,.218E-02_JPRB,&
&.219E-02_JPRB,.220E-02_JPRB,.221E-02_JPRB,.221E-02_JPRB,.220E-02_JPRB,.219E-02_JPRB,.217E-02_JPRB,&
&.214E-02_JPRB,.212E-02_JPRB,.207E-02_JPRB,.202E-02_JPRB,.199E-02_JPRB,.194E-02_JPRB,.189E-02_JPRB,&
&.186E-02_JPRB,.181E-02_JPRB,.176E-02_JPRB,.174E-02_JPRB,.170E-02_JPRB,.166E-02_JPRB,.163E-02_JPRB,&
&.161E-02_JPRB,.156E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 45 -86.0
ZAER (:,45, 9) = (/&
&.165E-02_JPRB,.165E-02_JPRB,.164E-02_JPRB,.163E-02_JPRB,.163E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,&
&.161E-02_JPRB,.161E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.161E-02_JPRB,&
&.161E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.163E-02_JPRB,.164E-02_JPRB,.165E-02_JPRB,.166E-02_JPRB,&
&.167E-02_JPRB,.168E-02_JPRB,.169E-02_JPRB,.170E-02_JPRB,.171E-02_JPRB,.173E-02_JPRB,.174E-02_JPRB,&
&.175E-02_JPRB,.176E-02_JPRB,.178E-02_JPRB,.179E-02_JPRB,.180E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.184E-02_JPRB,.184E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,&
&.186E-02_JPRB,.186E-02_JPRB,.186E-02_JPRB,.185E-02_JPRB,.185E-02_JPRB,.184E-02_JPRB,.183E-02_JPRB,&
&.183E-02_JPRB,.182E-02_JPRB,.180E-02_JPRB,.179E-02_JPRB,.178E-02_JPRB,.177E-02_JPRB,.175E-02_JPRB,&
&.174E-02_JPRB,.173E-02_JPRB,.171E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.168E-02_JPRB,.167E-02_JPRB,&
&.167E-02_JPRB,.165E-02_JPRB/)
!-- Black Carbon Aerosol     month:  9 --- lat: 46 -90.0
ZAER (:,46, 9) = (/&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,.172E-02_JPRB,&
&.172E-02_JPRB,.172E-02_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=9   
  DO JI=1,46
    DO JL=1,72
      RAERBC(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'BLACK CARBON AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAEBC_09
