SUBROUTINE SUECAEBC_06

!**   OPTICAL THICKNESS OF BLACK CARBON AEROSOLS (URBAN/FOREST FIRE ORIGIN)
!                                                 June

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAEBC* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERBC


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,6:6)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Black Carbon Aerosol     month:  6 --- lat:  1  90.0
ZAER (:, 1, 6) = (/&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,.838E-04_JPRB,&
&.838E-04_JPRB,.838E-04_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  2  86.0
ZAER (:, 2, 6) = (/&
&.853E-04_JPRB,.854E-04_JPRB,.863E-04_JPRB,.869E-04_JPRB,.874E-04_JPRB,.882E-04_JPRB,.887E-04_JPRB,&
&.890E-04_JPRB,.896E-04_JPRB,.900E-04_JPRB,.902E-04_JPRB,.905E-04_JPRB,.908E-04_JPRB,.909E-04_JPRB,&
&.909E-04_JPRB,.910E-04_JPRB,.909E-04_JPRB,.908E-04_JPRB,.906E-04_JPRB,.905E-04_JPRB,.903E-04_JPRB,&
&.899E-04_JPRB,.896E-04_JPRB,.893E-04_JPRB,.888E-04_JPRB,.884E-04_JPRB,.880E-04_JPRB,.874E-04_JPRB,&
&.869E-04_JPRB,.865E-04_JPRB,.858E-04_JPRB,.852E-04_JPRB,.848E-04_JPRB,.840E-04_JPRB,.835E-04_JPRB,&
&.830E-04_JPRB,.824E-04_JPRB,.818E-04_JPRB,.814E-04_JPRB,.808E-04_JPRB,.802E-04_JPRB,.799E-04_JPRB,&
&.794E-04_JPRB,.789E-04_JPRB,.786E-04_JPRB,.783E-04_JPRB,.779E-04_JPRB,.777E-04_JPRB,.774E-04_JPRB,&
&.771E-04_JPRB,.771E-04_JPRB,.770E-04_JPRB,.769E-04_JPRB,.769E-04_JPRB,.769E-04_JPRB,.770E-04_JPRB,&
&.772E-04_JPRB,.773E-04_JPRB,.776E-04_JPRB,.780E-04_JPRB,.783E-04_JPRB,.787E-04_JPRB,.793E-04_JPRB,&
&.797E-04_JPRB,.803E-04_JPRB,.811E-04_JPRB,.816E-04_JPRB,.822E-04_JPRB,.831E-04_JPRB,.837E-04_JPRB,&
&.843E-04_JPRB,.853E-04_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  3  82.0
ZAER (:, 3, 6) = (/&
&.928E-04_JPRB,.929E-04_JPRB,.956E-04_JPRB,.972E-04_JPRB,.986E-04_JPRB,.101E-03_JPRB,.102E-03_JPRB,&
&.103E-03_JPRB,.104E-03_JPRB,.105E-03_JPRB,.106E-03_JPRB,.106E-03_JPRB,.107E-03_JPRB,.107E-03_JPRB,&
&.107E-03_JPRB,.107E-03_JPRB,.106E-03_JPRB,.106E-03_JPRB,.105E-03_JPRB,.105E-03_JPRB,.104E-03_JPRB,&
&.103E-03_JPRB,.102E-03_JPRB,.101E-03_JPRB,.100E-03_JPRB,.992E-04_JPRB,.984E-04_JPRB,.969E-04_JPRB,&
&.957E-04_JPRB,.946E-04_JPRB,.927E-04_JPRB,.912E-04_JPRB,.900E-04_JPRB,.880E-04_JPRB,.865E-04_JPRB,&
&.854E-04_JPRB,.838E-04_JPRB,.823E-04_JPRB,.813E-04_JPRB,.800E-04_JPRB,.786E-04_JPRB,.778E-04_JPRB,&
&.768E-04_JPRB,.757E-04_JPRB,.750E-04_JPRB,.744E-04_JPRB,.733E-04_JPRB,.728E-04_JPRB,.723E-04_JPRB,&
&.714E-04_JPRB,.710E-04_JPRB,.707E-04_JPRB,.702E-04_JPRB,.700E-04_JPRB,.699E-04_JPRB,.699E-04_JPRB,&
&.702E-04_JPRB,.704E-04_JPRB,.710E-04_JPRB,.718E-04_JPRB,.725E-04_JPRB,.736E-04_JPRB,.751E-04_JPRB,&
&.762E-04_JPRB,.777E-04_JPRB,.799E-04_JPRB,.814E-04_JPRB,.832E-04_JPRB,.861E-04_JPRB,.878E-04_JPRB,&
&.896E-04_JPRB,.927E-04_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  4  78.0
ZAER (:, 4, 6) = (/&
&.109E-03_JPRB,.109E-03_JPRB,.115E-03_JPRB,.117E-03_JPRB,.119E-03_JPRB,.123E-03_JPRB,.124E-03_JPRB,&
&.125E-03_JPRB,.126E-03_JPRB,.127E-03_JPRB,.127E-03_JPRB,.127E-03_JPRB,.127E-03_JPRB,.127E-03_JPRB,&
&.127E-03_JPRB,.125E-03_JPRB,.125E-03_JPRB,.124E-03_JPRB,.122E-03_JPRB,.121E-03_JPRB,.120E-03_JPRB,&
&.118E-03_JPRB,.117E-03_JPRB,.116E-03_JPRB,.115E-03_JPRB,.114E-03_JPRB,.114E-03_JPRB,.112E-03_JPRB,&
&.110E-03_JPRB,.109E-03_JPRB,.106E-03_JPRB,.103E-03_JPRB,.101E-03_JPRB,.980E-04_JPRB,.956E-04_JPRB,&
&.938E-04_JPRB,.914E-04_JPRB,.893E-04_JPRB,.880E-04_JPRB,.863E-04_JPRB,.847E-04_JPRB,.838E-04_JPRB,&
&.828E-04_JPRB,.817E-04_JPRB,.810E-04_JPRB,.802E-04_JPRB,.788E-04_JPRB,.779E-04_JPRB,.770E-04_JPRB,&
&.753E-04_JPRB,.744E-04_JPRB,.735E-04_JPRB,.723E-04_JPRB,.718E-04_JPRB,.714E-04_JPRB,.710E-04_JPRB,&
&.711E-04_JPRB,.712E-04_JPRB,.717E-04_JPRB,.727E-04_JPRB,.735E-04_JPRB,.749E-04_JPRB,.770E-04_JPRB,&
&.786E-04_JPRB,.810E-04_JPRB,.847E-04_JPRB,.874E-04_JPRB,.906E-04_JPRB,.961E-04_JPRB,.995E-04_JPRB,&
&.103E-03_JPRB,.109E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  5  74.0
ZAER (:, 5, 6) = (/&
&.131E-03_JPRB,.131E-03_JPRB,.139E-03_JPRB,.142E-03_JPRB,.145E-03_JPRB,.148E-03_JPRB,.149E-03_JPRB,&
&.149E-03_JPRB,.149E-03_JPRB,.148E-03_JPRB,.147E-03_JPRB,.146E-03_JPRB,.144E-03_JPRB,.143E-03_JPRB,&
&.142E-03_JPRB,.139E-03_JPRB,.137E-03_JPRB,.136E-03_JPRB,.133E-03_JPRB,.132E-03_JPRB,.130E-03_JPRB,&
&.128E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,.128E-03_JPRB,.129E-03_JPRB,.129E-03_JPRB,.129E-03_JPRB,&
&.128E-03_JPRB,.127E-03_JPRB,.124E-03_JPRB,.120E-03_JPRB,.118E-03_JPRB,.113E-03_JPRB,.111E-03_JPRB,&
&.109E-03_JPRB,.106E-03_JPRB,.105E-03_JPRB,.104E-03_JPRB,.103E-03_JPRB,.102E-03_JPRB,.101E-03_JPRB,&
&.101E-03_JPRB,.101E-03_JPRB,.100E-03_JPRB,.994E-04_JPRB,.973E-04_JPRB,.959E-04_JPRB,.944E-04_JPRB,&
&.913E-04_JPRB,.898E-04_JPRB,.883E-04_JPRB,.862E-04_JPRB,.852E-04_JPRB,.845E-04_JPRB,.839E-04_JPRB,&
&.838E-04_JPRB,.839E-04_JPRB,.843E-04_JPRB,.851E-04_JPRB,.858E-04_JPRB,.869E-04_JPRB,.886E-04_JPRB,&
&.902E-04_JPRB,.927E-04_JPRB,.967E-04_JPRB,.100E-03_JPRB,.104E-03_JPRB,.112E-03_JPRB,.117E-03_JPRB,&
&.122E-03_JPRB,.131E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  6  70.0
ZAER (:, 6, 6) = (/&
&.156E-03_JPRB,.156E-03_JPRB,.165E-03_JPRB,.169E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,.179E-03_JPRB,&
&.179E-03_JPRB,.177E-03_JPRB,.173E-03_JPRB,.170E-03_JPRB,.166E-03_JPRB,.161E-03_JPRB,.158E-03_JPRB,&
&.153E-03_JPRB,.149E-03_JPRB,.147E-03_JPRB,.145E-03_JPRB,.143E-03_JPRB,.141E-03_JPRB,.139E-03_JPRB,&
&.137E-03_JPRB,.137E-03_JPRB,.137E-03_JPRB,.140E-03_JPRB,.143E-03_JPRB,.145E-03_JPRB,.148E-03_JPRB,&
&.149E-03_JPRB,.149E-03_JPRB,.147E-03_JPRB,.144E-03_JPRB,.141E-03_JPRB,.137E-03_JPRB,.135E-03_JPRB,&
&.134E-03_JPRB,.133E-03_JPRB,.134E-03_JPRB,.135E-03_JPRB,.136E-03_JPRB,.137E-03_JPRB,.137E-03_JPRB,&
&.137E-03_JPRB,.137E-03_JPRB,.137E-03_JPRB,.135E-03_JPRB,.131E-03_JPRB,.129E-03_JPRB,.126E-03_JPRB,&
&.121E-03_JPRB,.118E-03_JPRB,.115E-03_JPRB,.112E-03_JPRB,.110E-03_JPRB,.109E-03_JPRB,.109E-03_JPRB,&
&.110E-03_JPRB,.110E-03_JPRB,.112E-03_JPRB,.113E-03_JPRB,.114E-03_JPRB,.115E-03_JPRB,.115E-03_JPRB,&
&.115E-03_JPRB,.116E-03_JPRB,.119E-03_JPRB,.122E-03_JPRB,.126E-03_JPRB,.134E-03_JPRB,.140E-03_JPRB,&
&.146E-03_JPRB,.156E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  7  66.0
ZAER (:, 7, 6) = (/&
&.191E-03_JPRB,.191E-03_JPRB,.203E-03_JPRB,.210E-03_JPRB,.217E-03_JPRB,.229E-03_JPRB,.232E-03_JPRB,&
&.234E-03_JPRB,.229E-03_JPRB,.220E-03_JPRB,.212E-03_JPRB,.200E-03_JPRB,.188E-03_JPRB,.180E-03_JPRB,&
&.171E-03_JPRB,.165E-03_JPRB,.163E-03_JPRB,.160E-03_JPRB,.158E-03_JPRB,.155E-03_JPRB,.152E-03_JPRB,&
&.149E-03_JPRB,.148E-03_JPRB,.148E-03_JPRB,.152E-03_JPRB,.157E-03_JPRB,.161E-03_JPRB,.167E-03_JPRB,&
&.169E-03_JPRB,.170E-03_JPRB,.170E-03_JPRB,.168E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,.167E-03_JPRB,&
&.169E-03_JPRB,.172E-03_JPRB,.178E-03_JPRB,.182E-03_JPRB,.187E-03_JPRB,.193E-03_JPRB,.195E-03_JPRB,&
&.197E-03_JPRB,.195E-03_JPRB,.192E-03_JPRB,.188E-03_JPRB,.180E-03_JPRB,.176E-03_JPRB,.173E-03_JPRB,&
&.164E-03_JPRB,.158E-03_JPRB,.153E-03_JPRB,.145E-03_JPRB,.143E-03_JPRB,.142E-03_JPRB,.143E-03_JPRB,&
&.147E-03_JPRB,.150E-03_JPRB,.157E-03_JPRB,.161E-03_JPRB,.163E-03_JPRB,.163E-03_JPRB,.160E-03_JPRB,&
&.158E-03_JPRB,.155E-03_JPRB,.156E-03_JPRB,.157E-03_JPRB,.160E-03_JPRB,.168E-03_JPRB,.173E-03_JPRB,&
&.179E-03_JPRB,.191E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  8  62.0
ZAER (:, 8, 6) = (/&
&.262E-03_JPRB,.263E-03_JPRB,.285E-03_JPRB,.298E-03_JPRB,.308E-03_JPRB,.319E-03_JPRB,.319E-03_JPRB,&
&.317E-03_JPRB,.309E-03_JPRB,.290E-03_JPRB,.274E-03_JPRB,.249E-03_JPRB,.225E-03_JPRB,.211E-03_JPRB,&
&.196E-03_JPRB,.189E-03_JPRB,.185E-03_JPRB,.182E-03_JPRB,.178E-03_JPRB,.175E-03_JPRB,.172E-03_JPRB,&
&.166E-03_JPRB,.165E-03_JPRB,.163E-03_JPRB,.165E-03_JPRB,.168E-03_JPRB,.172E-03_JPRB,.178E-03_JPRB,&
&.182E-03_JPRB,.185E-03_JPRB,.190E-03_JPRB,.193E-03_JPRB,.197E-03_JPRB,.202E-03_JPRB,.206E-03_JPRB,&
&.210E-03_JPRB,.218E-03_JPRB,.229E-03_JPRB,.238E-03_JPRB,.251E-03_JPRB,.263E-03_JPRB,.267E-03_JPRB,&
&.269E-03_JPRB,.263E-03_JPRB,.257E-03_JPRB,.249E-03_JPRB,.238E-03_JPRB,.235E-03_JPRB,.232E-03_JPRB,&
&.222E-03_JPRB,.214E-03_JPRB,.206E-03_JPRB,.190E-03_JPRB,.184E-03_JPRB,.181E-03_JPRB,.183E-03_JPRB,&
&.195E-03_JPRB,.206E-03_JPRB,.228E-03_JPRB,.239E-03_JPRB,.242E-03_JPRB,.238E-03_JPRB,.228E-03_JPRB,&
&.222E-03_JPRB,.214E-03_JPRB,.209E-03_JPRB,.209E-03_JPRB,.209E-03_JPRB,.217E-03_JPRB,.227E-03_JPRB,&
&.239E-03_JPRB,.262E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat:  9  58.0
ZAER (:, 9, 6) = (/&
&.408E-03_JPRB,.408E-03_JPRB,.433E-03_JPRB,.431E-03_JPRB,.426E-03_JPRB,.392E-03_JPRB,.371E-03_JPRB,&
&.356E-03_JPRB,.344E-03_JPRB,.330E-03_JPRB,.316E-03_JPRB,.291E-03_JPRB,.267E-03_JPRB,.252E-03_JPRB,&
&.233E-03_JPRB,.219E-03_JPRB,.212E-03_JPRB,.205E-03_JPRB,.199E-03_JPRB,.195E-03_JPRB,.190E-03_JPRB,&
&.187E-03_JPRB,.186E-03_JPRB,.185E-03_JPRB,.187E-03_JPRB,.189E-03_JPRB,.191E-03_JPRB,.196E-03_JPRB,&
&.201E-03_JPRB,.206E-03_JPRB,.219E-03_JPRB,.235E-03_JPRB,.247E-03_JPRB,.264E-03_JPRB,.277E-03_JPRB,&
&.288E-03_JPRB,.304E-03_JPRB,.311E-03_JPRB,.316E-03_JPRB,.325E-03_JPRB,.332E-03_JPRB,.332E-03_JPRB,&
&.329E-03_JPRB,.317E-03_JPRB,.308E-03_JPRB,.297E-03_JPRB,.291E-03_JPRB,.292E-03_JPRB,.292E-03_JPRB,&
&.287E-03_JPRB,.276E-03_JPRB,.266E-03_JPRB,.246E-03_JPRB,.239E-03_JPRB,.236E-03_JPRB,.240E-03_JPRB,&
&.262E-03_JPRB,.280E-03_JPRB,.312E-03_JPRB,.315E-03_JPRB,.313E-03_JPRB,.303E-03_JPRB,.300E-03_JPRB,&
&.297E-03_JPRB,.293E-03_JPRB,.289E-03_JPRB,.291E-03_JPRB,.296E-03_JPRB,.329E-03_JPRB,.354E-03_JPRB,&
&.382E-03_JPRB,.407E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 10  54.0
ZAER (:,10, 6) = (/&
&.553E-03_JPRB,.553E-03_JPRB,.558E-03_JPRB,.531E-03_JPRB,.504E-03_JPRB,.434E-03_JPRB,.405E-03_JPRB,&
&.383E-03_JPRB,.360E-03_JPRB,.350E-03_JPRB,.342E-03_JPRB,.327E-03_JPRB,.313E-03_JPRB,.302E-03_JPRB,&
&.284E-03_JPRB,.259E-03_JPRB,.244E-03_JPRB,.227E-03_JPRB,.216E-03_JPRB,.211E-03_JPRB,.205E-03_JPRB,&
&.202E-03_JPRB,.205E-03_JPRB,.208E-03_JPRB,.218E-03_JPRB,.219E-03_JPRB,.221E-03_JPRB,.225E-03_JPRB,&
&.234E-03_JPRB,.246E-03_JPRB,.283E-03_JPRB,.318E-03_JPRB,.346E-03_JPRB,.387E-03_JPRB,.407E-03_JPRB,&
&.419E-03_JPRB,.430E-03_JPRB,.420E-03_JPRB,.412E-03_JPRB,.398E-03_JPRB,.379E-03_JPRB,.370E-03_JPRB,&
&.362E-03_JPRB,.352E-03_JPRB,.347E-03_JPRB,.340E-03_JPRB,.345E-03_JPRB,.349E-03_JPRB,.354E-03_JPRB,&
&.344E-03_JPRB,.332E-03_JPRB,.321E-03_JPRB,.305E-03_JPRB,.299E-03_JPRB,.296E-03_JPRB,.302E-03_JPRB,&
&.323E-03_JPRB,.337E-03_JPRB,.351E-03_JPRB,.335E-03_JPRB,.325E-03_JPRB,.317E-03_JPRB,.341E-03_JPRB,&
&.368E-03_JPRB,.413E-03_JPRB,.451E-03_JPRB,.468E-03_JPRB,.485E-03_JPRB,.529E-03_JPRB,.548E-03_JPRB,&
&.566E-03_JPRB,.554E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 11  50.0
ZAER (:,11, 6) = (/&
&.653E-03_JPRB,.653E-03_JPRB,.626E-03_JPRB,.588E-03_JPRB,.552E-03_JPRB,.477E-03_JPRB,.438E-03_JPRB,&
&.408E-03_JPRB,.377E-03_JPRB,.366E-03_JPRB,.360E-03_JPRB,.353E-03_JPRB,.346E-03_JPRB,.341E-03_JPRB,&
&.333E-03_JPRB,.302E-03_JPRB,.282E-03_JPRB,.258E-03_JPRB,.240E-03_JPRB,.232E-03_JPRB,.224E-03_JPRB,&
&.223E-03_JPRB,.228E-03_JPRB,.235E-03_JPRB,.250E-03_JPRB,.256E-03_JPRB,.262E-03_JPRB,.275E-03_JPRB,&
&.303E-03_JPRB,.333E-03_JPRB,.419E-03_JPRB,.479E-03_JPRB,.525E-03_JPRB,.589E-03_JPRB,.597E-03_JPRB,&
&.597E-03_JPRB,.587E-03_JPRB,.556E-03_JPRB,.542E-03_JPRB,.532E-03_JPRB,.479E-03_JPRB,.461E-03_JPRB,&
&.449E-03_JPRB,.449E-03_JPRB,.447E-03_JPRB,.445E-03_JPRB,.457E-03_JPRB,.456E-03_JPRB,.454E-03_JPRB,&
&.422E-03_JPRB,.409E-03_JPRB,.396E-03_JPRB,.380E-03_JPRB,.377E-03_JPRB,.374E-03_JPRB,.374E-03_JPRB,&
&.384E-03_JPRB,.387E-03_JPRB,.377E-03_JPRB,.342E-03_JPRB,.328E-03_JPRB,.324E-03_JPRB,.403E-03_JPRB,&
&.481E-03_JPRB,.602E-03_JPRB,.724E-03_JPRB,.753E-03_JPRB,.765E-03_JPRB,.750E-03_JPRB,.735E-03_JPRB,&
&.716E-03_JPRB,.655E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 12  46.0
ZAER (:,12, 6) = (/&
&.740E-03_JPRB,.739E-03_JPRB,.687E-03_JPRB,.649E-03_JPRB,.612E-03_JPRB,.529E-03_JPRB,.473E-03_JPRB,&
&.434E-03_JPRB,.400E-03_JPRB,.397E-03_JPRB,.396E-03_JPRB,.393E-03_JPRB,.390E-03_JPRB,.389E-03_JPRB,&
&.387E-03_JPRB,.359E-03_JPRB,.337E-03_JPRB,.307E-03_JPRB,.278E-03_JPRB,.267E-03_JPRB,.258E-03_JPRB,&
&.263E-03_JPRB,.272E-03_JPRB,.283E-03_JPRB,.304E-03_JPRB,.321E-03_JPRB,.338E-03_JPRB,.378E-03_JPRB,&
&.441E-03_JPRB,.507E-03_JPRB,.674E-03_JPRB,.725E-03_JPRB,.761E-03_JPRB,.799E-03_JPRB,.779E-03_JPRB,&
&.765E-03_JPRB,.748E-03_JPRB,.733E-03_JPRB,.734E-03_JPRB,.749E-03_JPRB,.680E-03_JPRB,.665E-03_JPRB,&
&.664E-03_JPRB,.659E-03_JPRB,.647E-03_JPRB,.631E-03_JPRB,.629E-03_JPRB,.637E-03_JPRB,.644E-03_JPRB,&
&.582E-03_JPRB,.558E-03_JPRB,.534E-03_JPRB,.488E-03_JPRB,.481E-03_JPRB,.476E-03_JPRB,.465E-03_JPRB,&
&.466E-03_JPRB,.461E-03_JPRB,.438E-03_JPRB,.404E-03_JPRB,.396E-03_JPRB,.407E-03_JPRB,.536E-03_JPRB,&
&.646E-03_JPRB,.808E-03_JPRB,.958E-03_JPRB,.963E-03_JPRB,.927E-03_JPRB,.836E-03_JPRB,.807E-03_JPRB,&
&.782E-03_JPRB,.742E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 13  42.0
ZAER (:,13, 6) = (/&
&.887E-03_JPRB,.884E-03_JPRB,.804E-03_JPRB,.753E-03_JPRB,.704E-03_JPRB,.608E-03_JPRB,.545E-03_JPRB,&
&.499E-03_JPRB,.459E-03_JPRB,.458E-03_JPRB,.459E-03_JPRB,.466E-03_JPRB,.458E-03_JPRB,.452E-03_JPRB,&
&.443E-03_JPRB,.422E-03_JPRB,.400E-03_JPRB,.366E-03_JPRB,.333E-03_JPRB,.321E-03_JPRB,.311E-03_JPRB,&
&.328E-03_JPRB,.348E-03_JPRB,.370E-03_JPRB,.431E-03_JPRB,.485E-03_JPRB,.541E-03_JPRB,.650E-03_JPRB,&
&.755E-03_JPRB,.857E-03_JPRB,.107E-02_JPRB,.108E-02_JPRB,.108E-02_JPRB,.107E-02_JPRB,.103E-02_JPRB,&
&.998E-03_JPRB,.950E-03_JPRB,.927E-03_JPRB,.936E-03_JPRB,.973E-03_JPRB,.915E-03_JPRB,.925E-03_JPRB,&
&.964E-03_JPRB,.105E-02_JPRB,.104E-02_JPRB,.100E-02_JPRB,.910E-03_JPRB,.900E-03_JPRB,.895E-03_JPRB,&
&.820E-03_JPRB,.781E-03_JPRB,.740E-03_JPRB,.642E-03_JPRB,.623E-03_JPRB,.606E-03_JPRB,.584E-03_JPRB,&
&.577E-03_JPRB,.569E-03_JPRB,.552E-03_JPRB,.546E-03_JPRB,.549E-03_JPRB,.562E-03_JPRB,.707E-03_JPRB,&
&.840E-03_JPRB,.104E-02_JPRB,.116E-02_JPRB,.112E-02_JPRB,.101E-02_JPRB,.857E-03_JPRB,.848E-03_JPRB,&
&.857E-03_JPRB,.886E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 14  38.0
ZAER (:,14, 6) = (/&
&.115E-02_JPRB,.115E-02_JPRB,.103E-02_JPRB,.933E-03_JPRB,.846E-03_JPRB,.715E-03_JPRB,.652E-03_JPRB,&
&.605E-03_JPRB,.557E-03_JPRB,.545E-03_JPRB,.543E-03_JPRB,.556E-03_JPRB,.537E-03_JPRB,.521E-03_JPRB,&
&.496E-03_JPRB,.487E-03_JPRB,.469E-03_JPRB,.438E-03_JPRB,.412E-03_JPRB,.413E-03_JPRB,.420E-03_JPRB,&
&.451E-03_JPRB,.488E-03_JPRB,.528E-03_JPRB,.723E-03_JPRB,.901E-03_JPRB,.108E-02_JPRB,.139E-02_JPRB,&
&.150E-02_JPRB,.159E-02_JPRB,.173E-02_JPRB,.161E-02_JPRB,.153E-02_JPRB,.142E-02_JPRB,.132E-02_JPRB,&
&.125E-02_JPRB,.116E-02_JPRB,.115E-02_JPRB,.118E-02_JPRB,.128E-02_JPRB,.134E-02_JPRB,.141E-02_JPRB,&
&.151E-02_JPRB,.170E-02_JPRB,.166E-02_JPRB,.158E-02_JPRB,.130E-02_JPRB,.123E-02_JPRB,.118E-02_JPRB,&
&.111E-02_JPRB,.104E-02_JPRB,.978E-03_JPRB,.860E-03_JPRB,.822E-03_JPRB,.790E-03_JPRB,.738E-03_JPRB,&
&.725E-03_JPRB,.719E-03_JPRB,.719E-03_JPRB,.750E-03_JPRB,.782E-03_JPRB,.843E-03_JPRB,.104E-02_JPRB,&
&.119E-02_JPRB,.141E-02_JPRB,.147E-02_JPRB,.140E-02_JPRB,.128E-02_JPRB,.109E-02_JPRB,.111E-02_JPRB,&
&.116E-02_JPRB,.115E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 15  34.0
ZAER (:,15, 6) = (/&
&.146E-02_JPRB,.145E-02_JPRB,.128E-02_JPRB,.114E-02_JPRB,.100E-02_JPRB,.839E-03_JPRB,.773E-03_JPRB,&
&.725E-03_JPRB,.683E-03_JPRB,.660E-03_JPRB,.647E-03_JPRB,.639E-03_JPRB,.608E-03_JPRB,.583E-03_JPRB,&
&.549E-03_JPRB,.544E-03_JPRB,.540E-03_JPRB,.534E-03_JPRB,.553E-03_JPRB,.599E-03_JPRB,.663E-03_JPRB,&
&.737E-03_JPRB,.820E-03_JPRB,.911E-03_JPRB,.158E-02_JPRB,.213E-02_JPRB,.266E-02_JPRB,.319E-02_JPRB,&
&.297E-02_JPRB,.277E-02_JPRB,.240E-02_JPRB,.205E-02_JPRB,.182E-02_JPRB,.160E-02_JPRB,.149E-02_JPRB,&
&.144E-02_JPRB,.140E-02_JPRB,.152E-02_JPRB,.170E-02_JPRB,.205E-02_JPRB,.268E-02_JPRB,.286E-02_JPRB,&
&.294E-02_JPRB,.287E-02_JPRB,.267E-02_JPRB,.242E-02_JPRB,.186E-02_JPRB,.168E-02_JPRB,.153E-02_JPRB,&
&.137E-02_JPRB,.127E-02_JPRB,.119E-02_JPRB,.109E-02_JPRB,.103E-02_JPRB,.976E-03_JPRB,.904E-03_JPRB,&
&.895E-03_JPRB,.897E-03_JPRB,.928E-03_JPRB,.106E-02_JPRB,.121E-02_JPRB,.151E-02_JPRB,.195E-02_JPRB,&
&.218E-02_JPRB,.244E-02_JPRB,.236E-02_JPRB,.224E-02_JPRB,.205E-02_JPRB,.169E-02_JPRB,.166E-02_JPRB,&
&.168E-02_JPRB,.147E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 16  30.0
ZAER (:,16, 6) = (/&
&.155E-02_JPRB,.154E-02_JPRB,.135E-02_JPRB,.121E-02_JPRB,.109E-02_JPRB,.933E-03_JPRB,.891E-03_JPRB,&
&.856E-03_JPRB,.800E-03_JPRB,.767E-03_JPRB,.741E-03_JPRB,.699E-03_JPRB,.659E-03_JPRB,.633E-03_JPRB,&
&.600E-03_JPRB,.589E-03_JPRB,.608E-03_JPRB,.650E-03_JPRB,.813E-03_JPRB,.970E-03_JPRB,.117E-02_JPRB,&
&.143E-02_JPRB,.164E-02_JPRB,.187E-02_JPRB,.402E-02_JPRB,.536E-02_JPRB,.657E-02_JPRB,.630E-02_JPRB,&
&.516E-02_JPRB,.416E-02_JPRB,.280E-02_JPRB,.225E-02_JPRB,.189E-02_JPRB,.162E-02_JPRB,.161E-02_JPRB,&
&.164E-02_JPRB,.176E-02_JPRB,.213E-02_JPRB,.270E-02_JPRB,.379E-02_JPRB,.553E-02_JPRB,.586E-02_JPRB,&
&.579E-02_JPRB,.486E-02_JPRB,.418E-02_JPRB,.339E-02_JPRB,.243E-02_JPRB,.212E-02_JPRB,.185E-02_JPRB,&
&.157E-02_JPRB,.143E-02_JPRB,.131E-02_JPRB,.124E-02_JPRB,.117E-02_JPRB,.112E-02_JPRB,.106E-02_JPRB,&
&.105E-02_JPRB,.108E-02_JPRB,.120E-02_JPRB,.163E-02_JPRB,.214E-02_JPRB,.314E-02_JPRB,.428E-02_JPRB,&
&.476E-02_JPRB,.510E-02_JPRB,.435E-02_JPRB,.380E-02_JPRB,.312E-02_JPRB,.228E-02_JPRB,.208E-02_JPRB,&
&.194E-02_JPRB,.156E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 17  26.0
ZAER (:,17, 6) = (/&
&.138E-02_JPRB,.137E-02_JPRB,.121E-02_JPRB,.113E-02_JPRB,.106E-02_JPRB,.964E-03_JPRB,.961E-03_JPRB,&
&.945E-03_JPRB,.868E-03_JPRB,.826E-03_JPRB,.789E-03_JPRB,.725E-03_JPRB,.681E-03_JPRB,.659E-03_JPRB,&
&.641E-03_JPRB,.633E-03_JPRB,.696E-03_JPRB,.823E-03_JPRB,.131E-02_JPRB,.172E-02_JPRB,.222E-02_JPRB,&
&.294E-02_JPRB,.338E-02_JPRB,.382E-02_JPRB,.911E-02_JPRB,.115E-01_JPRB,.135E-01_JPRB,.101E-01_JPRB,&
&.753E-02_JPRB,.535E-02_JPRB,.294E-02_JPRB,.232E-02_JPRB,.192E-02_JPRB,.166E-02_JPRB,.177E-02_JPRB,&
&.193E-02_JPRB,.228E-02_JPRB,.301E-02_JPRB,.418E-02_JPRB,.644E-02_JPRB,.940E-02_JPRB,.985E-02_JPRB,&
&.954E-02_JPRB,.707E-02_JPRB,.563E-02_JPRB,.406E-02_JPRB,.271E-02_JPRB,.232E-02_JPRB,.198E-02_JPRB,&
&.164E-02_JPRB,.148E-02_JPRB,.134E-02_JPRB,.129E-02_JPRB,.126E-02_JPRB,.122E-02_JPRB,.117E-02_JPRB,&
&.120E-02_JPRB,.131E-02_JPRB,.170E-02_JPRB,.275E-02_JPRB,.392E-02_JPRB,.617E-02_JPRB,.862E-02_JPRB,&
&.921E-02_JPRB,.904E-02_JPRB,.658E-02_JPRB,.514E-02_JPRB,.349E-02_JPRB,.236E-02_JPRB,.203E-02_JPRB,&
&.175E-02_JPRB,.139E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 18  22.0
ZAER (:,18, 6) = (/&
&.115E-02_JPRB,.115E-02_JPRB,.105E-02_JPRB,.100E-02_JPRB,.959E-03_JPRB,.928E-03_JPRB,.936E-03_JPRB,&
&.928E-03_JPRB,.856E-03_JPRB,.818E-03_JPRB,.783E-03_JPRB,.719E-03_JPRB,.671E-03_JPRB,.655E-03_JPRB,&
&.658E-03_JPRB,.693E-03_JPRB,.837E-03_JPRB,.110E-02_JPRB,.210E-02_JPRB,.290E-02_JPRB,.389E-02_JPRB,&
&.553E-02_JPRB,.629E-02_JPRB,.703E-02_JPRB,.163E-01_JPRB,.195E-01_JPRB,.219E-01_JPRB,.138E-01_JPRB,&
&.945E-02_JPRB,.594E-02_JPRB,.295E-02_JPRB,.237E-02_JPRB,.201E-02_JPRB,.182E-02_JPRB,.200E-02_JPRB,&
&.229E-02_JPRB,.299E-02_JPRB,.438E-02_JPRB,.622E-02_JPRB,.961E-02_JPRB,.126E-01_JPRB,.127E-01_JPRB,&
&.118E-01_JPRB,.803E-02_JPRB,.617E-02_JPRB,.424E-02_JPRB,.280E-02_JPRB,.235E-02_JPRB,.194E-02_JPRB,&
&.157E-02_JPRB,.144E-02_JPRB,.133E-02_JPRB,.131E-02_JPRB,.130E-02_JPRB,.129E-02_JPRB,.125E-02_JPRB,&
&.140E-02_JPRB,.169E-02_JPRB,.260E-02_JPRB,.450E-02_JPRB,.647E-02_JPRB,.101E-01_JPRB,.134E-01_JPRB,&
&.135E-01_JPRB,.116E-01_JPRB,.729E-02_JPRB,.514E-02_JPRB,.289E-02_JPRB,.195E-02_JPRB,.165E-02_JPRB,&
&.140E-02_JPRB,.116E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 19  18.0
ZAER (:,19, 6) = (/&
&.992E-03_JPRB,.990E-03_JPRB,.915E-03_JPRB,.883E-03_JPRB,.857E-03_JPRB,.850E-03_JPRB,.843E-03_JPRB,&
&.829E-03_JPRB,.780E-03_JPRB,.763E-03_JPRB,.741E-03_JPRB,.692E-03_JPRB,.654E-03_JPRB,.650E-03_JPRB,&
&.674E-03_JPRB,.798E-03_JPRB,.105E-02_JPRB,.149E-02_JPRB,.296E-02_JPRB,.425E-02_JPRB,.587E-02_JPRB,&
&.882E-02_JPRB,.102E-01_JPRB,.115E-01_JPRB,.234E-01_JPRB,.265E-01_JPRB,.286E-01_JPRB,.159E-01_JPRB,&
&.102E-01_JPRB,.571E-02_JPRB,.281E-02_JPRB,.237E-02_JPRB,.211E-02_JPRB,.203E-02_JPRB,.232E-02_JPRB,&
&.279E-02_JPRB,.394E-02_JPRB,.661E-02_JPRB,.906E-02_JPRB,.130E-01_JPRB,.140E-01_JPRB,.131E-01_JPRB,&
&.111E-01_JPRB,.731E-02_JPRB,.575E-02_JPRB,.424E-02_JPRB,.297E-02_JPRB,.241E-02_JPRB,.188E-02_JPRB,&
&.147E-02_JPRB,.138E-02_JPRB,.130E-02_JPRB,.131E-02_JPRB,.132E-02_JPRB,.133E-02_JPRB,.136E-02_JPRB,&
&.170E-02_JPRB,.221E-02_JPRB,.365E-02_JPRB,.622E-02_JPRB,.864E-02_JPRB,.128E-01_JPRB,.151E-01_JPRB,&
&.141E-01_JPRB,.105E-01_JPRB,.590E-02_JPRB,.397E-02_JPRB,.215E-02_JPRB,.150E-02_JPRB,.130E-02_JPRB,&
&.113E-02_JPRB,.996E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 20  14.0
ZAER (:,20, 6) = (/&
&.862E-03_JPRB,.861E-03_JPRB,.802E-03_JPRB,.795E-03_JPRB,.789E-03_JPRB,.780E-03_JPRB,.759E-03_JPRB,&
&.741E-03_JPRB,.711E-03_JPRB,.707E-03_JPRB,.699E-03_JPRB,.678E-03_JPRB,.670E-03_JPRB,.691E-03_JPRB,&
&.755E-03_JPRB,.100E-02_JPRB,.136E-02_JPRB,.196E-02_JPRB,.369E-02_JPRB,.542E-02_JPRB,.763E-02_JPRB,&
&.118E-01_JPRB,.141E-01_JPRB,.165E-01_JPRB,.282E-01_JPRB,.297E-01_JPRB,.301E-01_JPRB,.146E-01_JPRB,&
&.897E-02_JPRB,.465E-02_JPRB,.252E-02_JPRB,.226E-02_JPRB,.213E-02_JPRB,.219E-02_JPRB,.271E-02_JPRB,&
&.342E-02_JPRB,.504E-02_JPRB,.937E-02_JPRB,.122E-01_JPRB,.159E-01_JPRB,.144E-01_JPRB,.126E-01_JPRB,&
&.994E-02_JPRB,.636E-02_JPRB,.513E-02_JPRB,.405E-02_JPRB,.293E-02_JPRB,.236E-02_JPRB,.179E-02_JPRB,&
&.143E-02_JPRB,.135E-02_JPRB,.128E-02_JPRB,.129E-02_JPRB,.132E-02_JPRB,.137E-02_JPRB,.153E-02_JPRB,&
&.205E-02_JPRB,.268E-02_JPRB,.417E-02_JPRB,.678E-02_JPRB,.885E-02_JPRB,.120E-01_JPRB,.119E-01_JPRB,&
&.103E-01_JPRB,.674E-02_JPRB,.373E-02_JPRB,.260E-02_JPRB,.162E-02_JPRB,.120E-02_JPRB,.108E-02_JPRB,&
&.973E-03_JPRB,.866E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 21  10.0
ZAER (:,21, 6) = (/&
&.769E-03_JPRB,.768E-03_JPRB,.716E-03_JPRB,.715E-03_JPRB,.711E-03_JPRB,.685E-03_JPRB,.671E-03_JPRB,&
&.664E-03_JPRB,.668E-03_JPRB,.676E-03_JPRB,.684E-03_JPRB,.701E-03_JPRB,.732E-03_JPRB,.788E-03_JPRB,&
&.909E-03_JPRB,.129E-02_JPRB,.173E-02_JPRB,.242E-02_JPRB,.433E-02_JPRB,.627E-02_JPRB,.876E-02_JPRB,&
&.131E-01_JPRB,.163E-01_JPRB,.196E-01_JPRB,.287E-01_JPRB,.275E-01_JPRB,.255E-01_JPRB,.107E-01_JPRB,&
&.642E-02_JPRB,.319E-02_JPRB,.210E-02_JPRB,.201E-02_JPRB,.202E-02_JPRB,.229E-02_JPRB,.306E-02_JPRB,&
&.402E-02_JPRB,.608E-02_JPRB,.114E-01_JPRB,.145E-01_JPRB,.178E-01_JPRB,.152E-01_JPRB,.129E-01_JPRB,&
&.976E-02_JPRB,.597E-02_JPRB,.471E-02_JPRB,.362E-02_JPRB,.257E-02_JPRB,.212E-02_JPRB,.170E-02_JPRB,&
&.142E-02_JPRB,.133E-02_JPRB,.126E-02_JPRB,.125E-02_JPRB,.130E-02_JPRB,.138E-02_JPRB,.171E-02_JPRB,&
&.232E-02_JPRB,.289E-02_JPRB,.399E-02_JPRB,.591E-02_JPRB,.701E-02_JPRB,.811E-02_JPRB,.683E-02_JPRB,&
&.554E-02_JPRB,.351E-02_JPRB,.220E-02_JPRB,.170E-02_JPRB,.126E-02_JPRB,.102E-02_JPRB,.936E-03_JPRB,&
&.859E-03_JPRB,.772E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 22   6.0
ZAER (:,22, 6) = (/&
&.712E-03_JPRB,.710E-03_JPRB,.647E-03_JPRB,.638E-03_JPRB,.628E-03_JPRB,.597E-03_JPRB,.596E-03_JPRB,&
&.599E-03_JPRB,.624E-03_JPRB,.655E-03_JPRB,.682E-03_JPRB,.729E-03_JPRB,.789E-03_JPRB,.878E-03_JPRB,&
&.106E-02_JPRB,.149E-02_JPRB,.194E-02_JPRB,.263E-02_JPRB,.470E-02_JPRB,.668E-02_JPRB,.919E-02_JPRB,&
&.126E-01_JPRB,.155E-01_JPRB,.187E-01_JPRB,.235E-01_JPRB,.209E-01_JPRB,.179E-01_JPRB,.737E-02_JPRB,&
&.455E-02_JPRB,.243E-02_JPRB,.173E-02_JPRB,.176E-02_JPRB,.188E-02_JPRB,.234E-02_JPRB,.333E-02_JPRB,&
&.446E-02_JPRB,.681E-02_JPRB,.120E-01_JPRB,.150E-01_JPRB,.184E-01_JPRB,.156E-01_JPRB,.131E-01_JPRB,&
&.971E-02_JPRB,.590E-02_JPRB,.456E-02_JPRB,.337E-02_JPRB,.229E-02_JPRB,.196E-02_JPRB,.165E-02_JPRB,&
&.141E-02_JPRB,.131E-02_JPRB,.122E-02_JPRB,.116E-02_JPRB,.121E-02_JPRB,.133E-02_JPRB,.183E-02_JPRB,&
&.245E-02_JPRB,.295E-02_JPRB,.373E-02_JPRB,.457E-02_JPRB,.482E-02_JPRB,.460E-02_JPRB,.351E-02_JPRB,&
&.281E-02_JPRB,.195E-02_JPRB,.147E-02_JPRB,.127E-02_JPRB,.107E-02_JPRB,.892E-03_JPRB,.829E-03_JPRB,&
&.771E-03_JPRB,.714E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 23   2.0
ZAER (:,23, 6) = (/&
&.681E-03_JPRB,.679E-03_JPRB,.601E-03_JPRB,.586E-03_JPRB,.572E-03_JPRB,.547E-03_JPRB,.554E-03_JPRB,&
&.565E-03_JPRB,.596E-03_JPRB,.638E-03_JPRB,.672E-03_JPRB,.729E-03_JPRB,.808E-03_JPRB,.920E-03_JPRB,&
&.114E-02_JPRB,.153E-02_JPRB,.200E-02_JPRB,.274E-02_JPRB,.495E-02_JPRB,.684E-02_JPRB,.919E-02_JPRB,&
&.110E-01_JPRB,.126E-01_JPRB,.143E-01_JPRB,.162E-01_JPRB,.138E-01_JPRB,.113E-01_JPRB,.499E-02_JPRB,&
&.325E-02_JPRB,.193E-02_JPRB,.143E-02_JPRB,.158E-02_JPRB,.178E-02_JPRB,.240E-02_JPRB,.354E-02_JPRB,&
&.466E-02_JPRB,.678E-02_JPRB,.111E-01_JPRB,.137E-01_JPRB,.165E-01_JPRB,.144E-01_JPRB,.123E-01_JPRB,&
&.922E-02_JPRB,.583E-02_JPRB,.451E-02_JPRB,.327E-02_JPRB,.218E-02_JPRB,.191E-02_JPRB,.167E-02_JPRB,&
&.139E-02_JPRB,.128E-02_JPRB,.118E-02_JPRB,.107E-02_JPRB,.112E-02_JPRB,.124E-02_JPRB,.178E-02_JPRB,&
&.236E-02_JPRB,.279E-02_JPRB,.335E-02_JPRB,.363E-02_JPRB,.357E-02_JPRB,.310E-02_JPRB,.229E-02_JPRB,&
&.188E-02_JPRB,.146E-02_JPRB,.121E-02_JPRB,.110E-02_JPRB,.995E-03_JPRB,.837E-03_JPRB,.784E-03_JPRB,&
&.737E-03_JPRB,.683E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 24  -2.0
ZAER (:,24, 6) = (/&
&.716E-03_JPRB,.713E-03_JPRB,.612E-03_JPRB,.586E-03_JPRB,.563E-03_JPRB,.537E-03_JPRB,.552E-03_JPRB,&
&.567E-03_JPRB,.597E-03_JPRB,.632E-03_JPRB,.667E-03_JPRB,.733E-03_JPRB,.843E-03_JPRB,.950E-03_JPRB,&
&.113E-02_JPRB,.153E-02_JPRB,.201E-02_JPRB,.276E-02_JPRB,.492E-02_JPRB,.649E-02_JPRB,.835E-02_JPRB,&
&.868E-02_JPRB,.898E-02_JPRB,.930E-02_JPRB,.876E-02_JPRB,.712E-02_JPRB,.548E-02_JPRB,.295E-02_JPRB,&
&.215E-02_JPRB,.154E-02_JPRB,.136E-02_JPRB,.155E-02_JPRB,.179E-02_JPRB,.243E-02_JPRB,.343E-02_JPRB,&
&.436E-02_JPRB,.604E-02_JPRB,.865E-02_JPRB,.101E-01_JPRB,.118E-01_JPRB,.106E-01_JPRB,.932E-02_JPRB,&
&.751E-02_JPRB,.515E-02_JPRB,.411E-02_JPRB,.309E-02_JPRB,.220E-02_JPRB,.194E-02_JPRB,.172E-02_JPRB,&
&.138E-02_JPRB,.127E-02_JPRB,.116E-02_JPRB,.107E-02_JPRB,.109E-02_JPRB,.116E-02_JPRB,.151E-02_JPRB,&
&.198E-02_JPRB,.235E-02_JPRB,.286E-02_JPRB,.305E-02_JPRB,.299E-02_JPRB,.260E-02_JPRB,.197E-02_JPRB,&
&.166E-02_JPRB,.135E-02_JPRB,.118E-02_JPRB,.110E-02_JPRB,.101E-02_JPRB,.851E-03_JPRB,.815E-03_JPRB,&
&.790E-03_JPRB,.719E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 25  -6.0
ZAER (:,25, 6) = (/&
&.817E-03_JPRB,.813E-03_JPRB,.673E-03_JPRB,.644E-03_JPRB,.620E-03_JPRB,.612E-03_JPRB,.622E-03_JPRB,&
&.630E-03_JPRB,.642E-03_JPRB,.695E-03_JPRB,.736E-03_JPRB,.797E-03_JPRB,.876E-03_JPRB,.951E-03_JPRB,&
&.108E-02_JPRB,.147E-02_JPRB,.190E-02_JPRB,.256E-02_JPRB,.419E-02_JPRB,.515E-02_JPRB,.622E-02_JPRB,&
&.636E-02_JPRB,.608E-02_JPRB,.574E-02_JPRB,.442E-02_JPRB,.350E-02_JPRB,.262E-02_JPRB,.173E-02_JPRB,&
&.148E-02_JPRB,.131E-02_JPRB,.136E-02_JPRB,.154E-02_JPRB,.175E-02_JPRB,.227E-02_JPRB,.311E-02_JPRB,&
&.385E-02_JPRB,.507E-02_JPRB,.638E-02_JPRB,.682E-02_JPRB,.692E-02_JPRB,.639E-02_JPRB,.593E-02_JPRB,&
&.529E-02_JPRB,.397E-02_JPRB,.336E-02_JPRB,.275E-02_JPRB,.221E-02_JPRB,.202E-02_JPRB,.183E-02_JPRB,&
&.154E-02_JPRB,.147E-02_JPRB,.140E-02_JPRB,.136E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.148E-02_JPRB,&
&.181E-02_JPRB,.210E-02_JPRB,.260E-02_JPRB,.278E-02_JPRB,.273E-02_JPRB,.239E-02_JPRB,.189E-02_JPRB,&
&.167E-02_JPRB,.147E-02_JPRB,.139E-02_JPRB,.130E-02_JPRB,.118E-02_JPRB,.983E-03_JPRB,.940E-03_JPRB,&
&.911E-03_JPRB,.820E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 26 -10.0
ZAER (:,26, 6) = (/&
&.971E-03_JPRB,.966E-03_JPRB,.794E-03_JPRB,.775E-03_JPRB,.765E-03_JPRB,.807E-03_JPRB,.798E-03_JPRB,&
&.790E-03_JPRB,.776E-03_JPRB,.833E-03_JPRB,.872E-03_JPRB,.917E-03_JPRB,.944E-03_JPRB,.993E-03_JPRB,&
&.110E-02_JPRB,.145E-02_JPRB,.176E-02_JPRB,.223E-02_JPRB,.310E-02_JPRB,.359E-02_JPRB,.414E-02_JPRB,&
&.428E-02_JPRB,.387E-02_JPRB,.336E-02_JPRB,.230E-02_JPRB,.189E-02_JPRB,.151E-02_JPRB,.119E-02_JPRB,&
&.117E-02_JPRB,.118E-02_JPRB,.133E-02_JPRB,.147E-02_JPRB,.164E-02_JPRB,.206E-02_JPRB,.266E-02_JPRB,&
&.315E-02_JPRB,.393E-02_JPRB,.469E-02_JPRB,.475E-02_JPRB,.436E-02_JPRB,.394E-02_JPRB,.372E-02_JPRB,&
&.347E-02_JPRB,.302E-02_JPRB,.279E-02_JPRB,.253E-02_JPRB,.237E-02_JPRB,.228E-02_JPRB,.220E-02_JPRB,&
&.212E-02_JPRB,.221E-02_JPRB,.228E-02_JPRB,.236E-02_JPRB,.222E-02_JPRB,.214E-02_JPRB,.218E-02_JPRB,&
&.245E-02_JPRB,.269E-02_JPRB,.308E-02_JPRB,.315E-02_JPRB,.305E-02_JPRB,.268E-02_JPRB,.219E-02_JPRB,&
&.200E-02_JPRB,.186E-02_JPRB,.183E-02_JPRB,.173E-02_JPRB,.158E-02_JPRB,.130E-02_JPRB,.120E-02_JPRB,&
&.112E-02_JPRB,.976E-03_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 27 -14.0
ZAER (:,27, 6) = (/&
&.115E-02_JPRB,.115E-02_JPRB,.964E-03_JPRB,.979E-03_JPRB,.997E-03_JPRB,.106E-02_JPRB,.104E-02_JPRB,&
&.102E-02_JPRB,.975E-03_JPRB,.102E-02_JPRB,.104E-02_JPRB,.105E-02_JPRB,.106E-02_JPRB,.112E-02_JPRB,&
&.125E-02_JPRB,.162E-02_JPRB,.183E-02_JPRB,.207E-02_JPRB,.236E-02_JPRB,.265E-02_JPRB,.302E-02_JPRB,&
&.290E-02_JPRB,.252E-02_JPRB,.207E-02_JPRB,.144E-02_JPRB,.130E-02_JPRB,.117E-02_JPRB,.104E-02_JPRB,&
&.108E-02_JPRB,.113E-02_JPRB,.128E-02_JPRB,.141E-02_JPRB,.154E-02_JPRB,.185E-02_JPRB,.221E-02_JPRB,&
&.250E-02_JPRB,.297E-02_JPRB,.343E-02_JPRB,.353E-02_JPRB,.342E-02_JPRB,.302E-02_JPRB,.280E-02_JPRB,&
&.254E-02_JPRB,.258E-02_JPRB,.264E-02_JPRB,.271E-02_JPRB,.298E-02_JPRB,.302E-02_JPRB,.306E-02_JPRB,&
&.322E-02_JPRB,.358E-02_JPRB,.391E-02_JPRB,.414E-02_JPRB,.394E-02_JPRB,.379E-02_JPRB,.365E-02_JPRB,&
&.403E-02_JPRB,.439E-02_JPRB,.510E-02_JPRB,.465E-02_JPRB,.425E-02_JPRB,.357E-02_JPRB,.297E-02_JPRB,&
&.272E-02_JPRB,.252E-02_JPRB,.237E-02_JPRB,.220E-02_JPRB,.195E-02_JPRB,.170E-02_JPRB,.156E-02_JPRB,&
&.141E-02_JPRB,.116E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 28 -18.0
ZAER (:,28, 6) = (/&
&.135E-02_JPRB,.135E-02_JPRB,.116E-02_JPRB,.122E-02_JPRB,.126E-02_JPRB,.132E-02_JPRB,.128E-02_JPRB,&
&.125E-02_JPRB,.118E-02_JPRB,.120E-02_JPRB,.121E-02_JPRB,.122E-02_JPRB,.124E-02_JPRB,.131E-02_JPRB,&
&.149E-02_JPRB,.186E-02_JPRB,.198E-02_JPRB,.204E-02_JPRB,.202E-02_JPRB,.218E-02_JPRB,.243E-02_JPRB,&
&.211E-02_JPRB,.184E-02_JPRB,.156E-02_JPRB,.122E-02_JPRB,.117E-02_JPRB,.111E-02_JPRB,.105E-02_JPRB,&
&.108E-02_JPRB,.112E-02_JPRB,.125E-02_JPRB,.135E-02_JPRB,.146E-02_JPRB,.169E-02_JPRB,.194E-02_JPRB,&
&.211E-02_JPRB,.233E-02_JPRB,.255E-02_JPRB,.268E-02_JPRB,.284E-02_JPRB,.266E-02_JPRB,.251E-02_JPRB,&
&.231E-02_JPRB,.247E-02_JPRB,.273E-02_JPRB,.307E-02_JPRB,.380E-02_JPRB,.401E-02_JPRB,.420E-02_JPRB,&
&.446E-02_JPRB,.498E-02_JPRB,.546E-02_JPRB,.584E-02_JPRB,.570E-02_JPRB,.557E-02_JPRB,.539E-02_JPRB,&
&.646E-02_JPRB,.738E-02_JPRB,.891E-02_JPRB,.754E-02_JPRB,.649E-02_JPRB,.493E-02_JPRB,.398E-02_JPRB,&
&.358E-02_JPRB,.326E-02_JPRB,.282E-02_JPRB,.253E-02_JPRB,.219E-02_JPRB,.203E-02_JPRB,.188E-02_JPRB,&
&.170E-02_JPRB,.136E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 29 -22.0
ZAER (:,29, 6) = (/&
&.166E-02_JPRB,.166E-02_JPRB,.146E-02_JPRB,.148E-02_JPRB,.150E-02_JPRB,.149E-02_JPRB,.145E-02_JPRB,&
&.142E-02_JPRB,.135E-02_JPRB,.137E-02_JPRB,.139E-02_JPRB,.142E-02_JPRB,.148E-02_JPRB,.157E-02_JPRB,&
&.174E-02_JPRB,.198E-02_JPRB,.203E-02_JPRB,.200E-02_JPRB,.190E-02_JPRB,.198E-02_JPRB,.212E-02_JPRB,&
&.178E-02_JPRB,.159E-02_JPRB,.140E-02_JPRB,.124E-02_JPRB,.118E-02_JPRB,.112E-02_JPRB,.107E-02_JPRB,&
&.110E-02_JPRB,.113E-02_JPRB,.123E-02_JPRB,.133E-02_JPRB,.143E-02_JPRB,.163E-02_JPRB,.185E-02_JPRB,&
&.198E-02_JPRB,.210E-02_JPRB,.207E-02_JPRB,.215E-02_JPRB,.236E-02_JPRB,.257E-02_JPRB,.263E-02_JPRB,&
&.265E-02_JPRB,.269E-02_JPRB,.297E-02_JPRB,.334E-02_JPRB,.446E-02_JPRB,.484E-02_JPRB,.520E-02_JPRB,&
&.546E-02_JPRB,.580E-02_JPRB,.610E-02_JPRB,.623E-02_JPRB,.612E-02_JPRB,.612E-02_JPRB,.659E-02_JPRB,&
&.893E-02_JPRB,.108E-01_JPRB,.136E-01_JPRB,.119E-01_JPRB,.101E-01_JPRB,.703E-02_JPRB,.522E-02_JPRB,&
&.447E-02_JPRB,.390E-02_JPRB,.320E-02_JPRB,.284E-02_JPRB,.244E-02_JPRB,.231E-02_JPRB,.218E-02_JPRB,&
&.203E-02_JPRB,.168E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 30 -26.0
ZAER (:,30, 6) = (/&
&.206E-02_JPRB,.205E-02_JPRB,.181E-02_JPRB,.176E-02_JPRB,.171E-02_JPRB,.162E-02_JPRB,.156E-02_JPRB,&
&.152E-02_JPRB,.150E-02_JPRB,.155E-02_JPRB,.159E-02_JPRB,.163E-02_JPRB,.173E-02_JPRB,.181E-02_JPRB,&
&.194E-02_JPRB,.200E-02_JPRB,.205E-02_JPRB,.213E-02_JPRB,.210E-02_JPRB,.211E-02_JPRB,.212E-02_JPRB,&
&.179E-02_JPRB,.161E-02_JPRB,.143E-02_JPRB,.128E-02_JPRB,.120E-02_JPRB,.112E-02_JPRB,.108E-02_JPRB,&
&.110E-02_JPRB,.113E-02_JPRB,.122E-02_JPRB,.135E-02_JPRB,.147E-02_JPRB,.169E-02_JPRB,.198E-02_JPRB,&
&.214E-02_JPRB,.230E-02_JPRB,.212E-02_JPRB,.213E-02_JPRB,.229E-02_JPRB,.294E-02_JPRB,.322E-02_JPRB,&
&.348E-02_JPRB,.346E-02_JPRB,.362E-02_JPRB,.384E-02_JPRB,.503E-02_JPRB,.547E-02_JPRB,.588E-02_JPRB,&
&.603E-02_JPRB,.595E-02_JPRB,.583E-02_JPRB,.515E-02_JPRB,.497E-02_JPRB,.508E-02_JPRB,.660E-02_JPRB,&
&.105E-01_JPRB,.137E-01_JPRB,.183E-01_JPRB,.168E-01_JPRB,.147E-01_JPRB,.100E-01_JPRB,.676E-02_JPRB,&
&.542E-02_JPRB,.445E-02_JPRB,.362E-02_JPRB,.324E-02_JPRB,.285E-02_JPRB,.269E-02_JPRB,.256E-02_JPRB,&
&.242E-02_JPRB,.207E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 31 -30.0
ZAER (:,31, 6) = (/&
&.237E-02_JPRB,.236E-02_JPRB,.209E-02_JPRB,.201E-02_JPRB,.193E-02_JPRB,.176E-02_JPRB,.169E-02_JPRB,&
&.166E-02_JPRB,.167E-02_JPRB,.172E-02_JPRB,.176E-02_JPRB,.183E-02_JPRB,.191E-02_JPRB,.196E-02_JPRB,&
&.199E-02_JPRB,.196E-02_JPRB,.209E-02_JPRB,.235E-02_JPRB,.260E-02_JPRB,.257E-02_JPRB,.249E-02_JPRB,&
&.208E-02_JPRB,.183E-02_JPRB,.157E-02_JPRB,.130E-02_JPRB,.120E-02_JPRB,.112E-02_JPRB,.109E-02_JPRB,&
&.111E-02_JPRB,.114E-02_JPRB,.122E-02_JPRB,.142E-02_JPRB,.159E-02_JPRB,.192E-02_JPRB,.236E-02_JPRB,&
&.267E-02_JPRB,.309E-02_JPRB,.298E-02_JPRB,.296E-02_JPRB,.299E-02_JPRB,.392E-02_JPRB,.434E-02_JPRB,&
&.476E-02_JPRB,.480E-02_JPRB,.484E-02_JPRB,.490E-02_JPRB,.593E-02_JPRB,.630E-02_JPRB,.663E-02_JPRB,&
&.644E-02_JPRB,.586E-02_JPRB,.525E-02_JPRB,.381E-02_JPRB,.356E-02_JPRB,.371E-02_JPRB,.577E-02_JPRB,&
&.108E-01_JPRB,.149E-01_JPRB,.215E-01_JPRB,.208E-01_JPRB,.186E-01_JPRB,.132E-01_JPRB,.842E-02_JPRB,&
&.642E-02_JPRB,.488E-02_JPRB,.393E-02_JPRB,.357E-02_JPRB,.327E-02_JPRB,.309E-02_JPRB,.295E-02_JPRB,&
&.279E-02_JPRB,.238E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 32 -34.0
ZAER (:,32, 6) = (/&
&.250E-02_JPRB,.249E-02_JPRB,.219E-02_JPRB,.214E-02_JPRB,.208E-02_JPRB,.193E-02_JPRB,.187E-02_JPRB,&
&.183E-02_JPRB,.182E-02_JPRB,.183E-02_JPRB,.186E-02_JPRB,.197E-02_JPRB,.202E-02_JPRB,.200E-02_JPRB,&
&.190E-02_JPRB,.187E-02_JPRB,.205E-02_JPRB,.243E-02_JPRB,.293E-02_JPRB,.298E-02_JPRB,.293E-02_JPRB,&
&.253E-02_JPRB,.220E-02_JPRB,.184E-02_JPRB,.138E-02_JPRB,.127E-02_JPRB,.117E-02_JPRB,.112E-02_JPRB,&
&.115E-02_JPRB,.118E-02_JPRB,.128E-02_JPRB,.154E-02_JPRB,.181E-02_JPRB,.242E-02_JPRB,.314E-02_JPRB,&
&.377E-02_JPRB,.482E-02_JPRB,.527E-02_JPRB,.533E-02_JPRB,.516E-02_JPRB,.609E-02_JPRB,.655E-02_JPRB,&
&.701E-02_JPRB,.687E-02_JPRB,.677E-02_JPRB,.666E-02_JPRB,.752E-02_JPRB,.778E-02_JPRB,.801E-02_JPRB,&
&.716E-02_JPRB,.613E-02_JPRB,.512E-02_JPRB,.333E-02_JPRB,.312E-02_JPRB,.324E-02_JPRB,.497E-02_JPRB,&
&.955E-02_JPRB,.136E-01_JPRB,.208E-01_JPRB,.217E-01_JPRB,.203E-01_JPRB,.151E-01_JPRB,.980E-02_JPRB,&
&.733E-02_JPRB,.513E-02_JPRB,.395E-02_JPRB,.362E-02_JPRB,.342E-02_JPRB,.332E-02_JPRB,.316E-02_JPRB,&
&.296E-02_JPRB,.251E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 33 -38.0
ZAER (:,33, 6) = (/&
&.242E-02_JPRB,.241E-02_JPRB,.215E-02_JPRB,.213E-02_JPRB,.211E-02_JPRB,.205E-02_JPRB,.200E-02_JPRB,&
&.195E-02_JPRB,.186E-02_JPRB,.184E-02_JPRB,.187E-02_JPRB,.200E-02_JPRB,.202E-02_JPRB,.196E-02_JPRB,&
&.178E-02_JPRB,.175E-02_JPRB,.192E-02_JPRB,.226E-02_JPRB,.278E-02_JPRB,.293E-02_JPRB,.302E-02_JPRB,&
&.288E-02_JPRB,.257E-02_JPRB,.222E-02_JPRB,.158E-02_JPRB,.143E-02_JPRB,.129E-02_JPRB,.119E-02_JPRB,&
&.120E-02_JPRB,.123E-02_JPRB,.135E-02_JPRB,.171E-02_JPRB,.212E-02_JPRB,.314E-02_JPRB,.451E-02_JPRB,&
&.583E-02_JPRB,.826E-02_JPRB,.101E-01_JPRB,.105E-01_JPRB,.103E-01_JPRB,.106E-01_JPRB,.109E-01_JPRB,&
&.112E-01_JPRB,.105E-01_JPRB,.999E-02_JPRB,.949E-02_JPRB,.986E-02_JPRB,.991E-02_JPRB,.994E-02_JPRB,&
&.845E-02_JPRB,.718E-02_JPRB,.596E-02_JPRB,.412E-02_JPRB,.388E-02_JPRB,.385E-02_JPRB,.466E-02_JPRB,&
&.745E-02_JPRB,.103E-01_JPRB,.161E-01_JPRB,.189E-01_JPRB,.187E-01_JPRB,.151E-01_JPRB,.103E-01_JPRB,&
&.775E-02_JPRB,.514E-02_JPRB,.371E-02_JPRB,.337E-02_JPRB,.323E-02_JPRB,.320E-02_JPRB,.304E-02_JPRB,&
&.284E-02_JPRB,.243E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 34 -42.0
ZAER (:,34, 6) = (/&
&.216E-02_JPRB,.215E-02_JPRB,.203E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.203E-02_JPRB,.199E-02_JPRB,&
&.195E-02_JPRB,.183E-02_JPRB,.180E-02_JPRB,.181E-02_JPRB,.190E-02_JPRB,.193E-02_JPRB,.187E-02_JPRB,&
&.170E-02_JPRB,.166E-02_JPRB,.177E-02_JPRB,.200E-02_JPRB,.232E-02_JPRB,.247E-02_JPRB,.262E-02_JPRB,&
&.278E-02_JPRB,.263E-02_JPRB,.243E-02_JPRB,.177E-02_JPRB,.159E-02_JPRB,.143E-02_JPRB,.128E-02_JPRB,&
&.126E-02_JPRB,.126E-02_JPRB,.139E-02_JPRB,.180E-02_JPRB,.229E-02_JPRB,.357E-02_JPRB,.602E-02_JPRB,&
&.863E-02_JPRB,.138E-01_JPRB,.190E-01_JPRB,.207E-01_JPRB,.207E-01_JPRB,.188E-01_JPRB,.182E-01_JPRB,&
&.177E-01_JPRB,.163E-01_JPRB,.152E-01_JPRB,.138E-01_JPRB,.127E-01_JPRB,.122E-01_JPRB,.117E-01_JPRB,&
&.998E-02_JPRB,.878E-02_JPRB,.763E-02_JPRB,.596E-02_JPRB,.545E-02_JPRB,.508E-02_JPRB,.482E-02_JPRB,&
&.583E-02_JPRB,.715E-02_JPRB,.105E-01_JPRB,.135E-01_JPRB,.143E-01_JPRB,.130E-01_JPRB,.948E-02_JPRB,&
&.736E-02_JPRB,.489E-02_JPRB,.343E-02_JPRB,.306E-02_JPRB,.288E-02_JPRB,.278E-02_JPRB,.262E-02_JPRB,&
&.243E-02_JPRB,.217E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 35 -46.0
ZAER (:,35, 6) = (/&
&.186E-02_JPRB,.186E-02_JPRB,.188E-02_JPRB,.191E-02_JPRB,.193E-02_JPRB,.194E-02_JPRB,.191E-02_JPRB,&
&.188E-02_JPRB,.181E-02_JPRB,.176E-02_JPRB,.175E-02_JPRB,.177E-02_JPRB,.177E-02_JPRB,.173E-02_JPRB,&
&.162E-02_JPRB,.161E-02_JPRB,.167E-02_JPRB,.179E-02_JPRB,.188E-02_JPRB,.194E-02_JPRB,.201E-02_JPRB,&
&.222E-02_JPRB,.220E-02_JPRB,.216E-02_JPRB,.175E-02_JPRB,.163E-02_JPRB,.151E-02_JPRB,.135E-02_JPRB,&
&.129E-02_JPRB,.126E-02_JPRB,.135E-02_JPRB,.166E-02_JPRB,.207E-02_JPRB,.325E-02_JPRB,.665E-02_JPRB,&
&.108E-01_JPRB,.196E-01_JPRB,.314E-01_JPRB,.355E-01_JPRB,.367E-01_JPRB,.303E-01_JPRB,.276E-01_JPRB,&
&.250E-01_JPRB,.234E-01_JPRB,.215E-01_JPRB,.193E-01_JPRB,.158E-01_JPRB,.143E-01_JPRB,.128E-01_JPRB,&
&.110E-01_JPRB,.101E-01_JPRB,.919E-02_JPRB,.782E-02_JPRB,.694E-02_JPRB,.620E-02_JPRB,.521E-02_JPRB,&
&.529E-02_JPRB,.561E-02_JPRB,.679E-02_JPRB,.851E-02_JPRB,.928E-02_JPRB,.961E-02_JPRB,.780E-02_JPRB,&
&.640E-02_JPRB,.446E-02_JPRB,.325E-02_JPRB,.288E-02_JPRB,.262E-02_JPRB,.232E-02_JPRB,.215E-02_JPRB,&
&.198E-02_JPRB,.186E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 36 -50.0
ZAER (:,36, 6) = (/&
&.170E-02_JPRB,.170E-02_JPRB,.175E-02_JPRB,.178E-02_JPRB,.180E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,&
&.182E-02_JPRB,.178E-02_JPRB,.171E-02_JPRB,.166E-02_JPRB,.160E-02_JPRB,.157E-02_JPRB,.156E-02_JPRB,&
&.154E-02_JPRB,.156E-02_JPRB,.159E-02_JPRB,.162E-02_JPRB,.159E-02_JPRB,.157E-02_JPRB,.153E-02_JPRB,&
&.159E-02_JPRB,.161E-02_JPRB,.162E-02_JPRB,.150E-02_JPRB,.147E-02_JPRB,.143E-02_JPRB,.134E-02_JPRB,&
&.129E-02_JPRB,.126E-02_JPRB,.129E-02_JPRB,.146E-02_JPRB,.174E-02_JPRB,.264E-02_JPRB,.606E-02_JPRB,&
&.107E-01_JPRB,.210E-01_JPRB,.379E-01_JPRB,.447E-01_JPRB,.484E-01_JPRB,.398E-01_JPRB,.353E-01_JPRB,&
&.303E-01_JPRB,.280E-01_JPRB,.259E-01_JPRB,.233E-01_JPRB,.184E-01_JPRB,.160E-01_JPRB,.136E-01_JPRB,&
&.112E-01_JPRB,.104E-01_JPRB,.965E-02_JPRB,.842E-02_JPRB,.736E-02_JPRB,.649E-02_JPRB,.537E-02_JPRB,&
&.526E-02_JPRB,.523E-02_JPRB,.534E-02_JPRB,.585E-02_JPRB,.613E-02_JPRB,.639E-02_JPRB,.560E-02_JPRB,&
&.491E-02_JPRB,.388E-02_JPRB,.303E-02_JPRB,.270E-02_JPRB,.240E-02_JPRB,.201E-02_JPRB,.187E-02_JPRB,&
&.173E-02_JPRB,.170E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 37 -54.0
ZAER (:,37, 6) = (/&
&.168E-02_JPRB,.168E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.170E-02_JPRB,.171E-02_JPRB,.172E-02_JPRB,&
&.171E-02_JPRB,.168E-02_JPRB,.160E-02_JPRB,.154E-02_JPRB,.144E-02_JPRB,.142E-02_JPRB,.142E-02_JPRB,&
&.146E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.145E-02_JPRB,.141E-02_JPRB,.135E-02_JPRB,&
&.130E-02_JPRB,.128E-02_JPRB,.126E-02_JPRB,.127E-02_JPRB,.128E-02_JPRB,.129E-02_JPRB,.125E-02_JPRB,&
&.123E-02_JPRB,.122E-02_JPRB,.130E-02_JPRB,.141E-02_JPRB,.161E-02_JPRB,.224E-02_JPRB,.472E-02_JPRB,&
&.795E-02_JPRB,.151E-01_JPRB,.264E-01_JPRB,.319E-01_JPRB,.367E-01_JPRB,.334E-01_JPRB,.312E-01_JPRB,&
&.284E-01_JPRB,.267E-01_JPRB,.247E-01_JPRB,.222E-01_JPRB,.177E-01_JPRB,.154E-01_JPRB,.131E-01_JPRB,&
&.103E-01_JPRB,.943E-02_JPRB,.855E-02_JPRB,.735E-02_JPRB,.658E-02_JPRB,.596E-02_JPRB,.525E-02_JPRB,&
&.505E-02_JPRB,.491E-02_JPRB,.472E-02_JPRB,.458E-02_JPRB,.441E-02_JPRB,.406E-02_JPRB,.364E-02_JPRB,&
&.339E-02_JPRB,.311E-02_JPRB,.273E-02_JPRB,.250E-02_JPRB,.223E-02_JPRB,.189E-02_JPRB,.178E-02_JPRB,&
&.168E-02_JPRB,.168E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 38 -58.0
ZAER (:,38, 6) = (/&
&.171E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.171E-02_JPRB,.168E-02_JPRB,.164E-02_JPRB,&
&.160E-02_JPRB,.151E-02_JPRB,.145E-02_JPRB,.140E-02_JPRB,.134E-02_JPRB,.135E-02_JPRB,.136E-02_JPRB,&
&.139E-02_JPRB,.142E-02_JPRB,.143E-02_JPRB,.141E-02_JPRB,.138E-02_JPRB,.135E-02_JPRB,.130E-02_JPRB,&
&.123E-02_JPRB,.121E-02_JPRB,.119E-02_JPRB,.118E-02_JPRB,.117E-02_JPRB,.117E-02_JPRB,.113E-02_JPRB,&
&.114E-02_JPRB,.117E-02_JPRB,.131E-02_JPRB,.148E-02_JPRB,.168E-02_JPRB,.213E-02_JPRB,.346E-02_JPRB,&
&.503E-02_JPRB,.834E-02_JPRB,.126E-01_JPRB,.151E-01_JPRB,.179E-01_JPRB,.189E-01_JPRB,.192E-01_JPRB,&
&.193E-01_JPRB,.191E-01_JPRB,.178E-01_JPRB,.160E-01_JPRB,.128E-01_JPRB,.114E-01_JPRB,.101E-01_JPRB,&
&.826E-02_JPRB,.746E-02_JPRB,.670E-02_JPRB,.569E-02_JPRB,.531E-02_JPRB,.501E-02_JPRB,.470E-02_JPRB,&
&.446E-02_JPRB,.427E-02_JPRB,.399E-02_JPRB,.366E-02_JPRB,.337E-02_JPRB,.291E-02_JPRB,.260E-02_JPRB,&
&.248E-02_JPRB,.241E-02_JPRB,.236E-02_JPRB,.227E-02_JPRB,.214E-02_JPRB,.189E-02_JPRB,.180E-02_JPRB,&
&.172E-02_JPRB,.171E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 39 -62.0
ZAER (:,39, 6) = (/&
&.176E-02_JPRB,.176E-02_JPRB,.175E-02_JPRB,.174E-02_JPRB,.172E-02_JPRB,.164E-02_JPRB,.156E-02_JPRB,&
&.149E-02_JPRB,.139E-02_JPRB,.134E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.133E-02_JPRB,.135E-02_JPRB,&
&.138E-02_JPRB,.140E-02_JPRB,.140E-02_JPRB,.139E-02_JPRB,.135E-02_JPRB,.133E-02_JPRB,.130E-02_JPRB,&
&.127E-02_JPRB,.125E-02_JPRB,.124E-02_JPRB,.118E-02_JPRB,.114E-02_JPRB,.110E-02_JPRB,.104E-02_JPRB,&
&.106E-02_JPRB,.109E-02_JPRB,.124E-02_JPRB,.148E-02_JPRB,.171E-02_JPRB,.219E-02_JPRB,.300E-02_JPRB,&
&.383E-02_JPRB,.541E-02_JPRB,.739E-02_JPRB,.867E-02_JPRB,.103E-01_JPRB,.112E-01_JPRB,.113E-01_JPRB,&
&.113E-01_JPRB,.106E-01_JPRB,.991E-02_JPRB,.913E-02_JPRB,.777E-02_JPRB,.711E-02_JPRB,.647E-02_JPRB,&
&.566E-02_JPRB,.529E-02_JPRB,.493E-02_JPRB,.439E-02_JPRB,.417E-02_JPRB,.399E-02_JPRB,.381E-02_JPRB,&
&.366E-02_JPRB,.353E-02_JPRB,.332E-02_JPRB,.311E-02_JPRB,.293E-02_JPRB,.266E-02_JPRB,.241E-02_JPRB,&
&.229E-02_JPRB,.218E-02_JPRB,.217E-02_JPRB,.215E-02_JPRB,.211E-02_JPRB,.197E-02_JPRB,.190E-02_JPRB,&
&.182E-02_JPRB,.176E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 40 -66.0
ZAER (:,40, 6) = (/&
&.180E-02_JPRB,.180E-02_JPRB,.176E-02_JPRB,.173E-02_JPRB,.170E-02_JPRB,.160E-02_JPRB,.152E-02_JPRB,&
&.146E-02_JPRB,.137E-02_JPRB,.134E-02_JPRB,.132E-02_JPRB,.132E-02_JPRB,.134E-02_JPRB,.136E-02_JPRB,&
&.139E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.137E-02_JPRB,.133E-02_JPRB,.131E-02_JPRB,.128E-02_JPRB,&
&.123E-02_JPRB,.121E-02_JPRB,.118E-02_JPRB,.110E-02_JPRB,.106E-02_JPRB,.102E-02_JPRB,.971E-03_JPRB,&
&.981E-03_JPRB,.100E-02_JPRB,.112E-02_JPRB,.132E-02_JPRB,.152E-02_JPRB,.198E-02_JPRB,.261E-02_JPRB,&
&.318E-02_JPRB,.417E-02_JPRB,.543E-02_JPRB,.628E-02_JPRB,.738E-02_JPRB,.792E-02_JPRB,.795E-02_JPRB,&
&.780E-02_JPRB,.711E-02_JPRB,.664E-02_JPRB,.610E-02_JPRB,.517E-02_JPRB,.474E-02_JPRB,.432E-02_JPRB,&
&.393E-02_JPRB,.382E-02_JPRB,.370E-02_JPRB,.350E-02_JPRB,.337E-02_JPRB,.326E-02_JPRB,.314E-02_JPRB,&
&.307E-02_JPRB,.301E-02_JPRB,.294E-02_JPRB,.286E-02_JPRB,.279E-02_JPRB,.267E-02_JPRB,.250E-02_JPRB,&
&.240E-02_JPRB,.227E-02_JPRB,.219E-02_JPRB,.214E-02_JPRB,.209E-02_JPRB,.200E-02_JPRB,.194E-02_JPRB,&
&.187E-02_JPRB,.180E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 41 -70.0
ZAER (:,41, 6) = (/&
&.179E-02_JPRB,.179E-02_JPRB,.175E-02_JPRB,.172E-02_JPRB,.169E-02_JPRB,.162E-02_JPRB,.156E-02_JPRB,&
&.151E-02_JPRB,.144E-02_JPRB,.141E-02_JPRB,.140E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,.139E-02_JPRB,&
&.140E-02_JPRB,.140E-02_JPRB,.139E-02_JPRB,.136E-02_JPRB,.131E-02_JPRB,.128E-02_JPRB,.124E-02_JPRB,&
&.116E-02_JPRB,.112E-02_JPRB,.108E-02_JPRB,.101E-02_JPRB,.977E-03_JPRB,.949E-03_JPRB,.920E-03_JPRB,&
&.929E-03_JPRB,.945E-03_JPRB,.102E-02_JPRB,.116E-02_JPRB,.130E-02_JPRB,.162E-02_JPRB,.205E-02_JPRB,&
&.243E-02_JPRB,.306E-02_JPRB,.377E-02_JPRB,.424E-02_JPRB,.486E-02_JPRB,.527E-02_JPRB,.535E-02_JPRB,&
&.534E-02_JPRB,.498E-02_JPRB,.471E-02_JPRB,.440E-02_JPRB,.391E-02_JPRB,.369E-02_JPRB,.349E-02_JPRB,&
&.325E-02_JPRB,.316E-02_JPRB,.308E-02_JPRB,.293E-02_JPRB,.284E-02_JPRB,.277E-02_JPRB,.269E-02_JPRB,&
&.265E-02_JPRB,.263E-02_JPRB,.262E-02_JPRB,.261E-02_JPRB,.260E-02_JPRB,.256E-02_JPRB,.247E-02_JPRB,&
&.241E-02_JPRB,.231E-02_JPRB,.221E-02_JPRB,.214E-02_JPRB,.207E-02_JPRB,.197E-02_JPRB,.191E-02_JPRB,&
&.186E-02_JPRB,.179E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 42 -74.0
ZAER (:,42, 6) = (/&
&.177E-02_JPRB,.177E-02_JPRB,.172E-02_JPRB,.169E-02_JPRB,.167E-02_JPRB,.162E-02_JPRB,.159E-02_JPRB,&
&.156E-02_JPRB,.152E-02_JPRB,.149E-02_JPRB,.148E-02_JPRB,.146E-02_JPRB,.145E-02_JPRB,.144E-02_JPRB,&
&.143E-02_JPRB,.141E-02_JPRB,.139E-02_JPRB,.136E-02_JPRB,.130E-02_JPRB,.127E-02_JPRB,.122E-02_JPRB,&
&.114E-02_JPRB,.110E-02_JPRB,.106E-02_JPRB,.997E-03_JPRB,.975E-03_JPRB,.954E-03_JPRB,.937E-03_JPRB,&
&.947E-03_JPRB,.962E-03_JPRB,.102E-02_JPRB,.111E-02_JPRB,.119E-02_JPRB,.139E-02_JPRB,.162E-02_JPRB,&
&.182E-02_JPRB,.216E-02_JPRB,.252E-02_JPRB,.275E-02_JPRB,.305E-02_JPRB,.328E-02_JPRB,.337E-02_JPRB,&
&.343E-02_JPRB,.337E-02_JPRB,.332E-02_JPRB,.325E-02_JPRB,.313E-02_JPRB,.307E-02_JPRB,.301E-02_JPRB,&
&.290E-02_JPRB,.284E-02_JPRB,.277E-02_JPRB,.263E-02_JPRB,.255E-02_JPRB,.248E-02_JPRB,.240E-02_JPRB,&
&.237E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.235E-02_JPRB,.234E-02_JPRB,.230E-02_JPRB,&
&.227E-02_JPRB,.222E-02_JPRB,.214E-02_JPRB,.209E-02_JPRB,.202E-02_JPRB,.193E-02_JPRB,.188E-02_JPRB,&
&.183E-02_JPRB,.177E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 43 -78.0
ZAER (:,43, 6) = (/&
&.171E-02_JPRB,.171E-02_JPRB,.167E-02_JPRB,.165E-02_JPRB,.164E-02_JPRB,.161E-02_JPRB,.159E-02_JPRB,&
&.157E-02_JPRB,.154E-02_JPRB,.153E-02_JPRB,.151E-02_JPRB,.149E-02_JPRB,.148E-02_JPRB,.147E-02_JPRB,&
&.145E-02_JPRB,.142E-02_JPRB,.140E-02_JPRB,.138E-02_JPRB,.134E-02_JPRB,.131E-02_JPRB,.127E-02_JPRB,&
&.122E-02_JPRB,.119E-02_JPRB,.116E-02_JPRB,.112E-02_JPRB,.110E-02_JPRB,.109E-02_JPRB,.109E-02_JPRB,&
&.110E-02_JPRB,.111E-02_JPRB,.115E-02_JPRB,.120E-02_JPRB,.125E-02_JPRB,.135E-02_JPRB,.147E-02_JPRB,&
&.156E-02_JPRB,.171E-02_JPRB,.187E-02_JPRB,.197E-02_JPRB,.210E-02_JPRB,.222E-02_JPRB,.228E-02_JPRB,&
&.235E-02_JPRB,.240E-02_JPRB,.243E-02_JPRB,.245E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,.246E-02_JPRB,&
&.243E-02_JPRB,.240E-02_JPRB,.237E-02_JPRB,.229E-02_JPRB,.225E-02_JPRB,.221E-02_JPRB,.215E-02_JPRB,&
&.212E-02_JPRB,.210E-02_JPRB,.208E-02_JPRB,.206E-02_JPRB,.206E-02_JPRB,.205E-02_JPRB,.203E-02_JPRB,&
&.202E-02_JPRB,.199E-02_JPRB,.195E-02_JPRB,.192E-02_JPRB,.188E-02_JPRB,.183E-02_JPRB,.179E-02_JPRB,&
&.176E-02_JPRB,.171E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 44 -82.0
ZAER (:,44, 6) = (/&
&.163E-02_JPRB,.163E-02_JPRB,.161E-02_JPRB,.160E-02_JPRB,.159E-02_JPRB,.158E-02_JPRB,.156E-02_JPRB,&
&.155E-02_JPRB,.154E-02_JPRB,.153E-02_JPRB,.152E-02_JPRB,.151E-02_JPRB,.150E-02_JPRB,.149E-02_JPRB,&
&.147E-02_JPRB,.146E-02_JPRB,.145E-02_JPRB,.143E-02_JPRB,.141E-02_JPRB,.140E-02_JPRB,.138E-02_JPRB,&
&.136E-02_JPRB,.134E-02_JPRB,.133E-02_JPRB,.132E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,.131E-02_JPRB,&
&.132E-02_JPRB,.133E-02_JPRB,.135E-02_JPRB,.138E-02_JPRB,.140E-02_JPRB,.144E-02_JPRB,.148E-02_JPRB,&
&.152E-02_JPRB,.157E-02_JPRB,.163E-02_JPRB,.166E-02_JPRB,.171E-02_JPRB,.176E-02_JPRB,.180E-02_JPRB,&
&.183E-02_JPRB,.187E-02_JPRB,.189E-02_JPRB,.191E-02_JPRB,.193E-02_JPRB,.194E-02_JPRB,.194E-02_JPRB,&
&.195E-02_JPRB,.194E-02_JPRB,.193E-02_JPRB,.192E-02_JPRB,.190E-02_JPRB,.189E-02_JPRB,.187E-02_JPRB,&
&.185E-02_JPRB,.184E-02_JPRB,.182E-02_JPRB,.181E-02_JPRB,.181E-02_JPRB,.180E-02_JPRB,.178E-02_JPRB,&
&.177E-02_JPRB,.176E-02_JPRB,.174E-02_JPRB,.173E-02_JPRB,.172E-02_JPRB,.169E-02_JPRB,.168E-02_JPRB,&
&.166E-02_JPRB,.164E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 45 -86.0
ZAER (:,45, 6) = (/&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.158E-02_JPRB,.158E-02_JPRB,.157E-02_JPRB,.157E-02_JPRB,&
&.156E-02_JPRB,.156E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.155E-02_JPRB,.154E-02_JPRB,.154E-02_JPRB,&
&.153E-02_JPRB,.153E-02_JPRB,.152E-02_JPRB,.152E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.150E-02_JPRB,&
&.150E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.152E-02_JPRB,.153E-02_JPRB,.153E-02_JPRB,.154E-02_JPRB,&
&.155E-02_JPRB,.156E-02_JPRB,.158E-02_JPRB,.159E-02_JPRB,.160E-02_JPRB,.161E-02_JPRB,.162E-02_JPRB,&
&.163E-02_JPRB,.164E-02_JPRB,.164E-02_JPRB,.165E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.167E-02_JPRB,&
&.167E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,.167E-02_JPRB,&
&.166E-02_JPRB,.166E-02_JPRB,.166E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.165E-02_JPRB,.164E-02_JPRB,&
&.164E-02_JPRB,.163E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.162E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,&
&.160E-02_JPRB,.159E-02_JPRB/)
!-- Black Carbon Aerosol     month:  6 --- lat: 46 -90.0
ZAER (:,46, 6) = (/&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,.159E-02_JPRB,&
&.159E-02_JPRB,.159E-02_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=6    
  DO JI=1,46
    DO JL=1,72
      RAERBC(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'BLACK CARBON AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAEBC_06
