SUBROUTINE SUECAEBC_04

!**   OPTICAL THICKNESS OF BLACK CARBON AEROSOLS (URBAN/FOREST FIRE ORIGIN)
!                                                 April

!     PURPOSE.
!     --------

!**   INTERFACE.
!     ----------
!        CALL *SUECAEBC* FROM *SUECRAD*

!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS ===
!     ==== OUTPUTS ===

!        IMPLICIT ARGUMENTS :   NONE
!        --------------------

!     METHOD.
!     -------


!     EXTERNALS.
!     ----------

!          NONE

!     REFERENCE.
!     ----------

!        SEE RADIATION'S PART OF THE MODEL'S DOCUMENTATION AND
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE "I.F.S"

!     AUTHOR.
!     -------
!     J.-J. MORCRETTE  E.C.M.W.F.    98/12/21

!     MODIFICATIONS.
!     --------------
!     H. GALLEE        L.G.G.E.      04/01/15:  split for the NEC SX5

!-----------------------------------------------------------------------

#include "tsmbkind.h"

USE YOEAERC  , ONLY : RAERBC


IMPLICIT NONE


!     -----------------------------------------------------------------

!*       0.1   ARGUMENTS.
!              ----------

!     ----------------------------------------------------------------- 

!*       0.2   LOCAL ARRAYS.
!              -------------

REAL_B :: ZAER(72,46,4:4)

!     LOCAL INTEGER SCALARS
INTEGER_M :: JI, JL, JM

!     LOCAL REAL SCALARS
REAL_B :: ZMAX, ZMIN

!     ------------------------------------------------------------------

!-- Tegen et al., 1997

!-- Black Carbon Aerosol     month:  4 --- lat:  1  90.0
ZAER (:, 1, 4) = (/&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,.860E-04_JPRB,&
&.860E-04_JPRB,.860E-04_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  2  86.0
ZAER (:, 2, 4) = (/&
&.875E-04_JPRB,.875E-04_JPRB,.879E-04_JPRB,.881E-04_JPRB,.883E-04_JPRB,.886E-04_JPRB,.888E-04_JPRB,&
&.889E-04_JPRB,.891E-04_JPRB,.892E-04_JPRB,.893E-04_JPRB,.894E-04_JPRB,.894E-04_JPRB,.894E-04_JPRB,&
&.895E-04_JPRB,.895E-04_JPRB,.894E-04_JPRB,.894E-04_JPRB,.894E-04_JPRB,.894E-04_JPRB,.894E-04_JPRB,&
&.893E-04_JPRB,.892E-04_JPRB,.891E-04_JPRB,.890E-04_JPRB,.888E-04_JPRB,.887E-04_JPRB,.883E-04_JPRB,&
&.881E-04_JPRB,.879E-04_JPRB,.875E-04_JPRB,.872E-04_JPRB,.869E-04_JPRB,.864E-04_JPRB,.860E-04_JPRB,&
&.857E-04_JPRB,.852E-04_JPRB,.848E-04_JPRB,.845E-04_JPRB,.841E-04_JPRB,.837E-04_JPRB,.835E-04_JPRB,&
&.832E-04_JPRB,.828E-04_JPRB,.826E-04_JPRB,.824E-04_JPRB,.822E-04_JPRB,.821E-04_JPRB,.820E-04_JPRB,&
&.819E-04_JPRB,.818E-04_JPRB,.818E-04_JPRB,.819E-04_JPRB,.819E-04_JPRB,.820E-04_JPRB,.821E-04_JPRB,&
&.823E-04_JPRB,.824E-04_JPRB,.827E-04_JPRB,.830E-04_JPRB,.832E-04_JPRB,.835E-04_JPRB,.839E-04_JPRB,&
&.842E-04_JPRB,.846E-04_JPRB,.851E-04_JPRB,.854E-04_JPRB,.858E-04_JPRB,.863E-04_JPRB,.866E-04_JPRB,&
&.870E-04_JPRB,.875E-04_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  3  82.0
ZAER (:, 3, 4) = (/&
&.899E-04_JPRB,.899E-04_JPRB,.910E-04_JPRB,.914E-04_JPRB,.918E-04_JPRB,.922E-04_JPRB,.924E-04_JPRB,&
&.926E-04_JPRB,.925E-04_JPRB,.925E-04_JPRB,.925E-04_JPRB,.924E-04_JPRB,.924E-04_JPRB,.924E-04_JPRB,&
&.924E-04_JPRB,.924E-04_JPRB,.924E-04_JPRB,.925E-04_JPRB,.927E-04_JPRB,.928E-04_JPRB,.931E-04_JPRB,&
&.933E-04_JPRB,.934E-04_JPRB,.935E-04_JPRB,.936E-04_JPRB,.935E-04_JPRB,.934E-04_JPRB,.929E-04_JPRB,&
&.925E-04_JPRB,.921E-04_JPRB,.911E-04_JPRB,.901E-04_JPRB,.892E-04_JPRB,.879E-04_JPRB,.866E-04_JPRB,&
&.857E-04_JPRB,.843E-04_JPRB,.831E-04_JPRB,.822E-04_JPRB,.812E-04_JPRB,.801E-04_JPRB,.795E-04_JPRB,&
&.789E-04_JPRB,.781E-04_JPRB,.778E-04_JPRB,.775E-04_JPRB,.771E-04_JPRB,.769E-04_JPRB,.768E-04_JPRB,&
&.766E-04_JPRB,.765E-04_JPRB,.764E-04_JPRB,.764E-04_JPRB,.763E-04_JPRB,.762E-04_JPRB,.763E-04_JPRB,&
&.765E-04_JPRB,.767E-04_JPRB,.770E-04_JPRB,.775E-04_JPRB,.780E-04_JPRB,.788E-04_JPRB,.798E-04_JPRB,&
&.806E-04_JPRB,.816E-04_JPRB,.831E-04_JPRB,.840E-04_JPRB,.851E-04_JPRB,.867E-04_JPRB,.876E-04_JPRB,&
&.885E-04_JPRB,.898E-04_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  4  78.0
ZAER (:, 4, 4) = (/&
&.925E-04_JPRB,.925E-04_JPRB,.942E-04_JPRB,.947E-04_JPRB,.952E-04_JPRB,.954E-04_JPRB,.952E-04_JPRB,&
&.950E-04_JPRB,.943E-04_JPRB,.937E-04_JPRB,.933E-04_JPRB,.927E-04_JPRB,.923E-04_JPRB,.922E-04_JPRB,&
&.921E-04_JPRB,.922E-04_JPRB,.924E-04_JPRB,.928E-04_JPRB,.934E-04_JPRB,.939E-04_JPRB,.946E-04_JPRB,&
&.959E-04_JPRB,.967E-04_JPRB,.975E-04_JPRB,.988E-04_JPRB,.993E-04_JPRB,.998E-04_JPRB,.100E-03_JPRB,&
&.995E-04_JPRB,.990E-04_JPRB,.975E-04_JPRB,.957E-04_JPRB,.942E-04_JPRB,.917E-04_JPRB,.892E-04_JPRB,&
&.874E-04_JPRB,.849E-04_JPRB,.827E-04_JPRB,.813E-04_JPRB,.796E-04_JPRB,.781E-04_JPRB,.774E-04_JPRB,&
&.767E-04_JPRB,.761E-04_JPRB,.759E-04_JPRB,.757E-04_JPRB,.757E-04_JPRB,.757E-04_JPRB,.758E-04_JPRB,&
&.758E-04_JPRB,.757E-04_JPRB,.755E-04_JPRB,.751E-04_JPRB,.746E-04_JPRB,.742E-04_JPRB,.735E-04_JPRB,&
&.730E-04_JPRB,.728E-04_JPRB,.726E-04_JPRB,.729E-04_JPRB,.733E-04_JPRB,.742E-04_JPRB,.757E-04_JPRB,&
&.769E-04_JPRB,.785E-04_JPRB,.809E-04_JPRB,.825E-04_JPRB,.844E-04_JPRB,.871E-04_JPRB,.886E-04_JPRB,&
&.901E-04_JPRB,.924E-04_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  5  74.0
ZAER (:, 5, 4) = (/&
&.950E-04_JPRB,.950E-04_JPRB,.970E-04_JPRB,.977E-04_JPRB,.982E-04_JPRB,.983E-04_JPRB,.977E-04_JPRB,&
&.971E-04_JPRB,.958E-04_JPRB,.946E-04_JPRB,.938E-04_JPRB,.928E-04_JPRB,.923E-04_JPRB,.921E-04_JPRB,&
&.922E-04_JPRB,.927E-04_JPRB,.932E-04_JPRB,.938E-04_JPRB,.947E-04_JPRB,.955E-04_JPRB,.964E-04_JPRB,&
&.987E-04_JPRB,.100E-03_JPRB,.102E-03_JPRB,.105E-03_JPRB,.107E-03_JPRB,.108E-03_JPRB,.110E-03_JPRB,&
&.110E-03_JPRB,.109E-03_JPRB,.107E-03_JPRB,.105E-03_JPRB,.103E-03_JPRB,.989E-04_JPRB,.954E-04_JPRB,&
&.928E-04_JPRB,.892E-04_JPRB,.862E-04_JPRB,.845E-04_JPRB,.825E-04_JPRB,.813E-04_JPRB,.808E-04_JPRB,&
&.804E-04_JPRB,.805E-04_JPRB,.807E-04_JPRB,.809E-04_JPRB,.816E-04_JPRB,.821E-04_JPRB,.826E-04_JPRB,&
&.832E-04_JPRB,.831E-04_JPRB,.830E-04_JPRB,.822E-04_JPRB,.810E-04_JPRB,.799E-04_JPRB,.779E-04_JPRB,&
&.764E-04_JPRB,.752E-04_JPRB,.739E-04_JPRB,.735E-04_JPRB,.735E-04_JPRB,.740E-04_JPRB,.754E-04_JPRB,&
&.767E-04_JPRB,.784E-04_JPRB,.811E-04_JPRB,.829E-04_JPRB,.852E-04_JPRB,.884E-04_JPRB,.902E-04_JPRB,&
&.921E-04_JPRB,.949E-04_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  6  70.0
ZAER (:, 6, 4) = (/&
&.983E-04_JPRB,.984E-04_JPRB,.100E-03_JPRB,.101E-03_JPRB,.101E-03_JPRB,.101E-03_JPRB,.101E-03_JPRB,&
&.100E-03_JPRB,.989E-04_JPRB,.979E-04_JPRB,.972E-04_JPRB,.963E-04_JPRB,.961E-04_JPRB,.962E-04_JPRB,&
&.969E-04_JPRB,.980E-04_JPRB,.988E-04_JPRB,.996E-04_JPRB,.100E-03_JPRB,.101E-03_JPRB,.102E-03_JPRB,&
&.104E-03_JPRB,.106E-03_JPRB,.108E-03_JPRB,.114E-03_JPRB,.116E-03_JPRB,.118E-03_JPRB,.122E-03_JPRB,&
&.122E-03_JPRB,.122E-03_JPRB,.120E-03_JPRB,.117E-03_JPRB,.115E-03_JPRB,.110E-03_JPRB,.106E-03_JPRB,&
&.103E-03_JPRB,.994E-04_JPRB,.964E-04_JPRB,.948E-04_JPRB,.932E-04_JPRB,.924E-04_JPRB,.922E-04_JPRB,&
&.921E-04_JPRB,.922E-04_JPRB,.922E-04_JPRB,.923E-04_JPRB,.933E-04_JPRB,.942E-04_JPRB,.951E-04_JPRB,&
&.967E-04_JPRB,.970E-04_JPRB,.971E-04_JPRB,.960E-04_JPRB,.943E-04_JPRB,.927E-04_JPRB,.897E-04_JPRB,&
&.872E-04_JPRB,.854E-04_JPRB,.828E-04_JPRB,.815E-04_JPRB,.809E-04_JPRB,.807E-04_JPRB,.817E-04_JPRB,&
&.826E-04_JPRB,.840E-04_JPRB,.861E-04_JPRB,.877E-04_JPRB,.896E-04_JPRB,.925E-04_JPRB,.941E-04_JPRB,&
&.958E-04_JPRB,.982E-04_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  7  66.0
ZAER (:, 7, 4) = (/&
&.104E-03_JPRB,.104E-03_JPRB,.105E-03_JPRB,.105E-03_JPRB,.105E-03_JPRB,.105E-03_JPRB,.105E-03_JPRB,&
&.105E-03_JPRB,.105E-03_JPRB,.105E-03_JPRB,.105E-03_JPRB,.104E-03_JPRB,.104E-03_JPRB,.105E-03_JPRB,&
&.106E-03_JPRB,.108E-03_JPRB,.109E-03_JPRB,.110E-03_JPRB,.110E-03_JPRB,.110E-03_JPRB,.110E-03_JPRB,&
&.111E-03_JPRB,.113E-03_JPRB,.115E-03_JPRB,.123E-03_JPRB,.127E-03_JPRB,.131E-03_JPRB,.134E-03_JPRB,&
&.135E-03_JPRB,.135E-03_JPRB,.133E-03_JPRB,.130E-03_JPRB,.127E-03_JPRB,.123E-03_JPRB,.120E-03_JPRB,&
&.118E-03_JPRB,.115E-03_JPRB,.114E-03_JPRB,.113E-03_JPRB,.113E-03_JPRB,.112E-03_JPRB,.112E-03_JPRB,&
&.111E-03_JPRB,.109E-03_JPRB,.108E-03_JPRB,.107E-03_JPRB,.107E-03_JPRB,.108E-03_JPRB,.110E-03_JPRB,&
&.113E-03_JPRB,.114E-03_JPRB,.115E-03_JPRB,.114E-03_JPRB,.113E-03_JPRB,.112E-03_JPRB,.108E-03_JPRB,&
&.105E-03_JPRB,.103E-03_JPRB,.998E-04_JPRB,.974E-04_JPRB,.961E-04_JPRB,.950E-04_JPRB,.951E-04_JPRB,&
&.953E-04_JPRB,.957E-04_JPRB,.967E-04_JPRB,.975E-04_JPRB,.985E-04_JPRB,.101E-03_JPRB,.102E-03_JPRB,&
&.103E-03_JPRB,.104E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  8  62.0
ZAER (:, 8, 4) = (/&
&.113E-03_JPRB,.113E-03_JPRB,.112E-03_JPRB,.113E-03_JPRB,.113E-03_JPRB,.114E-03_JPRB,.115E-03_JPRB,&
&.116E-03_JPRB,.117E-03_JPRB,.117E-03_JPRB,.117E-03_JPRB,.116E-03_JPRB,.115E-03_JPRB,.116E-03_JPRB,&
&.117E-03_JPRB,.119E-03_JPRB,.120E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,.121E-03_JPRB,.120E-03_JPRB,&
&.121E-03_JPRB,.123E-03_JPRB,.126E-03_JPRB,.135E-03_JPRB,.140E-03_JPRB,.144E-03_JPRB,.146E-03_JPRB,&
&.146E-03_JPRB,.145E-03_JPRB,.143E-03_JPRB,.140E-03_JPRB,.137E-03_JPRB,.133E-03_JPRB,.131E-03_JPRB,&
&.131E-03_JPRB,.132E-03_JPRB,.132E-03_JPRB,.133E-03_JPRB,.134E-03_JPRB,.134E-03_JPRB,.133E-03_JPRB,&
&.132E-03_JPRB,.127E-03_JPRB,.125E-03_JPRB,.122E-03_JPRB,.121E-03_JPRB,.123E-03_JPRB,.125E-03_JPRB,&
&.129E-03_JPRB,.131E-03_JPRB,.133E-03_JPRB,.135E-03_JPRB,.135E-03_JPRB,.135E-03_JPRB,.133E-03_JPRB,&
&.131E-03_JPRB,.128E-03_JPRB,.124E-03_JPRB,.121E-03_JPRB,.119E-03_JPRB,.118E-03_JPRB,.116E-03_JPRB,&
&.115E-03_JPRB,.114E-03_JPRB,.112E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.111E-03_JPRB,.112E-03_JPRB,&
&.113E-03_JPRB,.113E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat:  9  58.0
ZAER (:, 9, 4) = (/&
&.127E-03_JPRB,.127E-03_JPRB,.127E-03_JPRB,.128E-03_JPRB,.129E-03_JPRB,.133E-03_JPRB,.134E-03_JPRB,&
&.135E-03_JPRB,.136E-03_JPRB,.134E-03_JPRB,.133E-03_JPRB,.131E-03_JPRB,.128E-03_JPRB,.127E-03_JPRB,&
&.126E-03_JPRB,.126E-03_JPRB,.127E-03_JPRB,.128E-03_JPRB,.130E-03_JPRB,.132E-03_JPRB,.134E-03_JPRB,&
&.140E-03_JPRB,.144E-03_JPRB,.149E-03_JPRB,.160E-03_JPRB,.164E-03_JPRB,.168E-03_JPRB,.172E-03_JPRB,&
&.171E-03_JPRB,.170E-03_JPRB,.162E-03_JPRB,.153E-03_JPRB,.147E-03_JPRB,.139E-03_JPRB,.138E-03_JPRB,&
&.138E-03_JPRB,.139E-03_JPRB,.141E-03_JPRB,.143E-03_JPRB,.147E-03_JPRB,.149E-03_JPRB,.148E-03_JPRB,&
&.147E-03_JPRB,.142E-03_JPRB,.140E-03_JPRB,.137E-03_JPRB,.138E-03_JPRB,.139E-03_JPRB,.140E-03_JPRB,&
&.144E-03_JPRB,.147E-03_JPRB,.150E-03_JPRB,.155E-03_JPRB,.156E-03_JPRB,.157E-03_JPRB,.158E-03_JPRB,&
&.157E-03_JPRB,.156E-03_JPRB,.152E-03_JPRB,.148E-03_JPRB,.145E-03_JPRB,.142E-03_JPRB,.139E-03_JPRB,&
&.137E-03_JPRB,.134E-03_JPRB,.130E-03_JPRB,.128E-03_JPRB,.126E-03_JPRB,.124E-03_JPRB,.125E-03_JPRB,&
&.125E-03_JPRB,.127E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 10  54.0
ZAER (:,10, 4) = (/&
&.146E-03_JPRB,.146E-03_JPRB,.150E-03_JPRB,.154E-03_JPRB,.157E-03_JPRB,.161E-03_JPRB,.160E-03_JPRB,&
&.158E-03_JPRB,.155E-03_JPRB,.154E-03_JPRB,.151E-03_JPRB,.147E-03_JPRB,.141E-03_JPRB,.137E-03_JPRB,&
&.133E-03_JPRB,.131E-03_JPRB,.130E-03_JPRB,.130E-03_JPRB,.133E-03_JPRB,.136E-03_JPRB,.140E-03_JPRB,&
&.155E-03_JPRB,.166E-03_JPRB,.177E-03_JPRB,.192E-03_JPRB,.199E-03_JPRB,.206E-03_JPRB,.214E-03_JPRB,&
&.214E-03_JPRB,.212E-03_JPRB,.196E-03_JPRB,.179E-03_JPRB,.168E-03_JPRB,.155E-03_JPRB,.150E-03_JPRB,&
&.147E-03_JPRB,.147E-03_JPRB,.151E-03_JPRB,.153E-03_JPRB,.157E-03_JPRB,.158E-03_JPRB,.158E-03_JPRB,&
&.157E-03_JPRB,.154E-03_JPRB,.153E-03_JPRB,.153E-03_JPRB,.155E-03_JPRB,.155E-03_JPRB,.155E-03_JPRB,&
&.155E-03_JPRB,.158E-03_JPRB,.161E-03_JPRB,.168E-03_JPRB,.170E-03_JPRB,.171E-03_JPRB,.171E-03_JPRB,&
&.171E-03_JPRB,.170E-03_JPRB,.167E-03_JPRB,.164E-03_JPRB,.162E-03_JPRB,.157E-03_JPRB,.154E-03_JPRB,&
&.151E-03_JPRB,.148E-03_JPRB,.142E-03_JPRB,.139E-03_JPRB,.137E-03_JPRB,.137E-03_JPRB,.139E-03_JPRB,&
&.141E-03_JPRB,.146E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 11  50.0
ZAER (:,11, 4) = (/&
&.178E-03_JPRB,.178E-03_JPRB,.185E-03_JPRB,.189E-03_JPRB,.192E-03_JPRB,.193E-03_JPRB,.189E-03_JPRB,&
&.185E-03_JPRB,.179E-03_JPRB,.176E-03_JPRB,.173E-03_JPRB,.166E-03_JPRB,.157E-03_JPRB,.152E-03_JPRB,&
&.146E-03_JPRB,.141E-03_JPRB,.139E-03_JPRB,.138E-03_JPRB,.140E-03_JPRB,.143E-03_JPRB,.147E-03_JPRB,&
&.169E-03_JPRB,.187E-03_JPRB,.206E-03_JPRB,.228E-03_JPRB,.235E-03_JPRB,.242E-03_JPRB,.250E-03_JPRB,&
&.250E-03_JPRB,.249E-03_JPRB,.242E-03_JPRB,.222E-03_JPRB,.207E-03_JPRB,.191E-03_JPRB,.182E-03_JPRB,&
&.178E-03_JPRB,.176E-03_JPRB,.179E-03_JPRB,.181E-03_JPRB,.182E-03_JPRB,.179E-03_JPRB,.178E-03_JPRB,&
&.176E-03_JPRB,.176E-03_JPRB,.177E-03_JPRB,.179E-03_JPRB,.176E-03_JPRB,.175E-03_JPRB,.173E-03_JPRB,&
&.170E-03_JPRB,.173E-03_JPRB,.177E-03_JPRB,.183E-03_JPRB,.184E-03_JPRB,.184E-03_JPRB,.183E-03_JPRB,&
&.182E-03_JPRB,.182E-03_JPRB,.179E-03_JPRB,.174E-03_JPRB,.170E-03_JPRB,.164E-03_JPRB,.162E-03_JPRB,&
&.161E-03_JPRB,.160E-03_JPRB,.155E-03_JPRB,.153E-03_JPRB,.151E-03_JPRB,.158E-03_JPRB,.163E-03_JPRB,&
&.169E-03_JPRB,.177E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 12  46.0
ZAER (:,12, 4) = (/&
&.221E-03_JPRB,.221E-03_JPRB,.222E-03_JPRB,.225E-03_JPRB,.227E-03_JPRB,.223E-03_JPRB,.218E-03_JPRB,&
&.213E-03_JPRB,.205E-03_JPRB,.201E-03_JPRB,.197E-03_JPRB,.188E-03_JPRB,.177E-03_JPRB,.170E-03_JPRB,&
&.161E-03_JPRB,.156E-03_JPRB,.154E-03_JPRB,.152E-03_JPRB,.154E-03_JPRB,.158E-03_JPRB,.163E-03_JPRB,&
&.192E-03_JPRB,.215E-03_JPRB,.241E-03_JPRB,.281E-03_JPRB,.291E-03_JPRB,.300E-03_JPRB,.296E-03_JPRB,&
&.292E-03_JPRB,.289E-03_JPRB,.293E-03_JPRB,.277E-03_JPRB,.264E-03_JPRB,.245E-03_JPRB,.235E-03_JPRB,&
&.229E-03_JPRB,.224E-03_JPRB,.227E-03_JPRB,.227E-03_JPRB,.224E-03_JPRB,.222E-03_JPRB,.222E-03_JPRB,&
&.221E-03_JPRB,.223E-03_JPRB,.222E-03_JPRB,.220E-03_JPRB,.208E-03_JPRB,.204E-03_JPRB,.200E-03_JPRB,&
&.196E-03_JPRB,.198E-03_JPRB,.199E-03_JPRB,.201E-03_JPRB,.200E-03_JPRB,.200E-03_JPRB,.199E-03_JPRB,&
&.198E-03_JPRB,.197E-03_JPRB,.194E-03_JPRB,.187E-03_JPRB,.182E-03_JPRB,.176E-03_JPRB,.177E-03_JPRB,&
&.179E-03_JPRB,.183E-03_JPRB,.182E-03_JPRB,.181E-03_JPRB,.179E-03_JPRB,.192E-03_JPRB,.202E-03_JPRB,&
&.213E-03_JPRB,.221E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 13  42.0
ZAER (:,13, 4) = (/&
&.264E-03_JPRB,.264E-03_JPRB,.255E-03_JPRB,.255E-03_JPRB,.254E-03_JPRB,.245E-03_JPRB,.241E-03_JPRB,&
&.237E-03_JPRB,.230E-03_JPRB,.223E-03_JPRB,.217E-03_JPRB,.209E-03_JPRB,.199E-03_JPRB,.191E-03_JPRB,&
&.180E-03_JPRB,.174E-03_JPRB,.172E-03_JPRB,.170E-03_JPRB,.173E-03_JPRB,.179E-03_JPRB,.187E-03_JPRB,&
&.231E-03_JPRB,.271E-03_JPRB,.314E-03_JPRB,.395E-03_JPRB,.419E-03_JPRB,.437E-03_JPRB,.391E-03_JPRB,&
&.379E-03_JPRB,.369E-03_JPRB,.360E-03_JPRB,.334E-03_JPRB,.316E-03_JPRB,.295E-03_JPRB,.289E-03_JPRB,&
&.284E-03_JPRB,.277E-03_JPRB,.281E-03_JPRB,.284E-03_JPRB,.289E-03_JPRB,.302E-03_JPRB,.306E-03_JPRB,&
&.309E-03_JPRB,.305E-03_JPRB,.296E-03_JPRB,.285E-03_JPRB,.263E-03_JPRB,.255E-03_JPRB,.247E-03_JPRB,&
&.241E-03_JPRB,.238E-03_JPRB,.235E-03_JPRB,.231E-03_JPRB,.226E-03_JPRB,.223E-03_JPRB,.221E-03_JPRB,&
&.220E-03_JPRB,.218E-03_JPRB,.214E-03_JPRB,.206E-03_JPRB,.201E-03_JPRB,.196E-03_JPRB,.205E-03_JPRB,&
&.215E-03_JPRB,.230E-03_JPRB,.232E-03_JPRB,.228E-03_JPRB,.220E-03_JPRB,.233E-03_JPRB,.246E-03_JPRB,&
&.261E-03_JPRB,.264E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 14  38.0
ZAER (:,14, 4) = (/&
&.293E-03_JPRB,.293E-03_JPRB,.279E-03_JPRB,.275E-03_JPRB,.270E-03_JPRB,.258E-03_JPRB,.254E-03_JPRB,&
&.252E-03_JPRB,.248E-03_JPRB,.240E-03_JPRB,.234E-03_JPRB,.227E-03_JPRB,.218E-03_JPRB,.211E-03_JPRB,&
&.201E-03_JPRB,.195E-03_JPRB,.192E-03_JPRB,.190E-03_JPRB,.196E-03_JPRB,.207E-03_JPRB,.221E-03_JPRB,&
&.305E-03_JPRB,.376E-03_JPRB,.453E-03_JPRB,.626E-03_JPRB,.702E-03_JPRB,.764E-03_JPRB,.654E-03_JPRB,&
&.584E-03_JPRB,.524E-03_JPRB,.449E-03_JPRB,.413E-03_JPRB,.389E-03_JPRB,.368E-03_JPRB,.361E-03_JPRB,&
&.353E-03_JPRB,.338E-03_JPRB,.353E-03_JPRB,.368E-03_JPRB,.392E-03_JPRB,.442E-03_JPRB,.457E-03_JPRB,&
&.465E-03_JPRB,.433E-03_JPRB,.406E-03_JPRB,.375E-03_JPRB,.344E-03_JPRB,.329E-03_JPRB,.316E-03_JPRB,&
&.302E-03_JPRB,.295E-03_JPRB,.288E-03_JPRB,.277E-03_JPRB,.267E-03_JPRB,.259E-03_JPRB,.256E-03_JPRB,&
&.251E-03_JPRB,.247E-03_JPRB,.241E-03_JPRB,.233E-03_JPRB,.229E-03_JPRB,.226E-03_JPRB,.247E-03_JPRB,&
&.267E-03_JPRB,.299E-03_JPRB,.311E-03_JPRB,.304E-03_JPRB,.289E-03_JPRB,.280E-03_JPRB,.288E-03_JPRB,&
&.299E-03_JPRB,.293E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 15  34.0
ZAER (:,15, 4) = (/&
&.317E-03_JPRB,.317E-03_JPRB,.300E-03_JPRB,.291E-03_JPRB,.283E-03_JPRB,.268E-03_JPRB,.263E-03_JPRB,&
&.260E-03_JPRB,.257E-03_JPRB,.252E-03_JPRB,.249E-03_JPRB,.245E-03_JPRB,.236E-03_JPRB,.230E-03_JPRB,&
&.222E-03_JPRB,.217E-03_JPRB,.216E-03_JPRB,.216E-03_JPRB,.228E-03_JPRB,.248E-03_JPRB,.275E-03_JPRB,&
&.444E-03_JPRB,.551E-03_JPRB,.661E-03_JPRB,.976E-03_JPRB,.120E-02_JPRB,.140E-02_JPRB,.123E-02_JPRB,&
&.993E-03_JPRB,.797E-03_JPRB,.611E-03_JPRB,.550E-03_JPRB,.508E-03_JPRB,.472E-03_JPRB,.455E-03_JPRB,&
&.440E-03_JPRB,.415E-03_JPRB,.437E-03_JPRB,.467E-03_JPRB,.521E-03_JPRB,.647E-03_JPRB,.689E-03_JPRB,&
&.715E-03_JPRB,.617E-03_JPRB,.556E-03_JPRB,.488E-03_JPRB,.429E-03_JPRB,.410E-03_JPRB,.393E-03_JPRB,&
&.377E-03_JPRB,.367E-03_JPRB,.358E-03_JPRB,.340E-03_JPRB,.323E-03_JPRB,.311E-03_JPRB,.303E-03_JPRB,&
&.296E-03_JPRB,.292E-03_JPRB,.286E-03_JPRB,.278E-03_JPRB,.274E-03_JPRB,.271E-03_JPRB,.302E-03_JPRB,&
&.329E-03_JPRB,.370E-03_JPRB,.399E-03_JPRB,.395E-03_JPRB,.379E-03_JPRB,.338E-03_JPRB,.331E-03_JPRB,&
&.328E-03_JPRB,.318E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 16  30.0
ZAER (:,16, 4) = (/&
&.353E-03_JPRB,.353E-03_JPRB,.334E-03_JPRB,.319E-03_JPRB,.305E-03_JPRB,.287E-03_JPRB,.279E-03_JPRB,&
&.273E-03_JPRB,.269E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.268E-03_JPRB,.258E-03_JPRB,.252E-03_JPRB,&
&.246E-03_JPRB,.247E-03_JPRB,.250E-03_JPRB,.256E-03_JPRB,.278E-03_JPRB,.310E-03_JPRB,.355E-03_JPRB,&
&.634E-03_JPRB,.757E-03_JPRB,.876E-03_JPRB,.134E-02_JPRB,.180E-02_JPRB,.220E-02_JPRB,.206E-02_JPRB,&
&.160E-02_JPRB,.123E-02_JPRB,.873E-03_JPRB,.737E-03_JPRB,.646E-03_JPRB,.567E-03_JPRB,.542E-03_JPRB,&
&.525E-03_JPRB,.501E-03_JPRB,.517E-03_JPRB,.554E-03_JPRB,.632E-03_JPRB,.885E-03_JPRB,.975E-03_JPRB,&
&.104E-02_JPRB,.833E-03_JPRB,.716E-03_JPRB,.592E-03_JPRB,.497E-03_JPRB,.482E-03_JPRB,.471E-03_JPRB,&
&.464E-03_JPRB,.450E-03_JPRB,.436E-03_JPRB,.416E-03_JPRB,.397E-03_JPRB,.382E-03_JPRB,.369E-03_JPRB,&
&.364E-03_JPRB,.361E-03_JPRB,.356E-03_JPRB,.346E-03_JPRB,.342E-03_JPRB,.339E-03_JPRB,.371E-03_JPRB,&
&.396E-03_JPRB,.431E-03_JPRB,.473E-03_JPRB,.477E-03_JPRB,.472E-03_JPRB,.406E-03_JPRB,.384E-03_JPRB,&
&.365E-03_JPRB,.354E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 17  26.0
ZAER (:,17, 4) = (/&
&.412E-03_JPRB,.411E-03_JPRB,.389E-03_JPRB,.366E-03_JPRB,.345E-03_JPRB,.319E-03_JPRB,.309E-03_JPRB,&
&.302E-03_JPRB,.295E-03_JPRB,.298E-03_JPRB,.299E-03_JPRB,.301E-03_JPRB,.290E-03_JPRB,.285E-03_JPRB,&
&.284E-03_JPRB,.291E-03_JPRB,.301E-03_JPRB,.318E-03_JPRB,.349E-03_JPRB,.395E-03_JPRB,.457E-03_JPRB,&
&.770E-03_JPRB,.866E-03_JPRB,.951E-03_JPRB,.153E-02_JPRB,.218E-02_JPRB,.277E-02_JPRB,.277E-02_JPRB,&
&.219E-02_JPRB,.170E-02_JPRB,.110E-02_JPRB,.880E-03_JPRB,.732E-03_JPRB,.617E-03_JPRB,.600E-03_JPRB,&
&.589E-03_JPRB,.579E-03_JPRB,.592E-03_JPRB,.628E-03_JPRB,.705E-03_JPRB,.104E-02_JPRB,.117E-02_JPRB,&
&.128E-02_JPRB,.982E-03_JPRB,.828E-03_JPRB,.667E-03_JPRB,.561E-03_JPRB,.559E-03_JPRB,.563E-03_JPRB,&
&.558E-03_JPRB,.534E-03_JPRB,.513E-03_JPRB,.499E-03_JPRB,.487E-03_JPRB,.477E-03_JPRB,.463E-03_JPRB,&
&.461E-03_JPRB,.459E-03_JPRB,.453E-03_JPRB,.441E-03_JPRB,.435E-03_JPRB,.433E-03_JPRB,.457E-03_JPRB,&
&.473E-03_JPRB,.496E-03_JPRB,.536E-03_JPRB,.545E-03_JPRB,.548E-03_JPRB,.481E-03_JPRB,.453E-03_JPRB,&
&.426E-03_JPRB,.412E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 18  22.0
ZAER (:,18, 4) = (/&
&.486E-03_JPRB,.485E-03_JPRB,.453E-03_JPRB,.424E-03_JPRB,.398E-03_JPRB,.370E-03_JPRB,.356E-03_JPRB,&
&.347E-03_JPRB,.337E-03_JPRB,.340E-03_JPRB,.341E-03_JPRB,.340E-03_JPRB,.333E-03_JPRB,.333E-03_JPRB,&
&.339E-03_JPRB,.355E-03_JPRB,.375E-03_JPRB,.407E-03_JPRB,.448E-03_JPRB,.500E-03_JPRB,.568E-03_JPRB,&
&.775E-03_JPRB,.829E-03_JPRB,.873E-03_JPRB,.146E-02_JPRB,.216E-02_JPRB,.280E-02_JPRB,.295E-02_JPRB,&
&.240E-02_JPRB,.191E-02_JPRB,.117E-02_JPRB,.914E-03_JPRB,.748E-03_JPRB,.638E-03_JPRB,.641E-03_JPRB,&
&.650E-03_JPRB,.675E-03_JPRB,.695E-03_JPRB,.719E-03_JPRB,.761E-03_JPRB,.106E-02_JPRB,.118E-02_JPRB,&
&.130E-02_JPRB,.103E-02_JPRB,.887E-03_JPRB,.738E-03_JPRB,.646E-03_JPRB,.651E-03_JPRB,.662E-03_JPRB,&
&.644E-03_JPRB,.610E-03_JPRB,.582E-03_JPRB,.584E-03_JPRB,.586E-03_JPRB,.586E-03_JPRB,.582E-03_JPRB,&
&.580E-03_JPRB,.577E-03_JPRB,.567E-03_JPRB,.554E-03_JPRB,.548E-03_JPRB,.545E-03_JPRB,.554E-03_JPRB,&
&.562E-03_JPRB,.574E-03_JPRB,.596E-03_JPRB,.600E-03_JPRB,.599E-03_JPRB,.546E-03_JPRB,.524E-03_JPRB,&
&.502E-03_JPRB,.487E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 19  18.0
ZAER (:,19, 4) = (/&
&.548E-03_JPRB,.546E-03_JPRB,.505E-03_JPRB,.477E-03_JPRB,.454E-03_JPRB,.433E-03_JPRB,.417E-03_JPRB,&
&.404E-03_JPRB,.390E-03_JPRB,.386E-03_JPRB,.383E-03_JPRB,.380E-03_JPRB,.380E-03_JPRB,.389E-03_JPRB,&
&.411E-03_JPRB,.437E-03_JPRB,.473E-03_JPRB,.531E-03_JPRB,.596E-03_JPRB,.645E-03_JPRB,.703E-03_JPRB,&
&.758E-03_JPRB,.795E-03_JPRB,.833E-03_JPRB,.133E-02_JPRB,.188E-02_JPRB,.239E-02_JPRB,.257E-02_JPRB,&
&.213E-02_JPRB,.174E-02_JPRB,.111E-02_JPRB,.895E-03_JPRB,.759E-03_JPRB,.687E-03_JPRB,.713E-03_JPRB,&
&.749E-03_JPRB,.833E-03_JPRB,.845E-03_JPRB,.845E-03_JPRB,.835E-03_JPRB,.103E-02_JPRB,.113E-02_JPRB,&
&.124E-02_JPRB,.106E-02_JPRB,.952E-03_JPRB,.833E-03_JPRB,.744E-03_JPRB,.739E-03_JPRB,.738E-03_JPRB,&
&.705E-03_JPRB,.673E-03_JPRB,.647E-03_JPRB,.659E-03_JPRB,.672E-03_JPRB,.683E-03_JPRB,.700E-03_JPRB,&
&.707E-03_JPRB,.707E-03_JPRB,.693E-03_JPRB,.678E-03_JPRB,.671E-03_JPRB,.666E-03_JPRB,.657E-03_JPRB,&
&.653E-03_JPRB,.650E-03_JPRB,.643E-03_JPRB,.632E-03_JPRB,.616E-03_JPRB,.578E-03_JPRB,.567E-03_JPRB,&
&.558E-03_JPRB,.548E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 20  14.0
ZAER (:,20, 4) = (/&
&.572E-03_JPRB,.570E-03_JPRB,.530E-03_JPRB,.513E-03_JPRB,.499E-03_JPRB,.489E-03_JPRB,.472E-03_JPRB,&
&.459E-03_JPRB,.444E-03_JPRB,.430E-03_JPRB,.423E-03_JPRB,.421E-03_JPRB,.433E-03_JPRB,.453E-03_JPRB,&
&.495E-03_JPRB,.543E-03_JPRB,.600E-03_JPRB,.690E-03_JPRB,.804E-03_JPRB,.851E-03_JPRB,.897E-03_JPRB,&
&.878E-03_JPRB,.915E-03_JPRB,.959E-03_JPRB,.137E-02_JPRB,.162E-02_JPRB,.186E-02_JPRB,.200E-02_JPRB,&
&.172E-02_JPRB,.147E-02_JPRB,.106E-02_JPRB,.921E-03_JPRB,.843E-03_JPRB,.830E-03_JPRB,.880E-03_JPRB,&
&.934E-03_JPRB,.104E-02_JPRB,.102E-02_JPRB,.990E-03_JPRB,.945E-03_JPRB,.106E-02_JPRB,.115E-02_JPRB,&
&.126E-02_JPRB,.115E-02_JPRB,.104E-02_JPRB,.918E-03_JPRB,.814E-03_JPRB,.796E-03_JPRB,.781E-03_JPRB,&
&.745E-03_JPRB,.727E-03_JPRB,.711E-03_JPRB,.715E-03_JPRB,.728E-03_JPRB,.745E-03_JPRB,.798E-03_JPRB,&
&.870E-03_JPRB,.905E-03_JPRB,.894E-03_JPRB,.845E-03_JPRB,.818E-03_JPRB,.796E-03_JPRB,.752E-03_JPRB,&
&.725E-03_JPRB,.692E-03_JPRB,.649E-03_JPRB,.622E-03_JPRB,.590E-03_JPRB,.572E-03_JPRB,.573E-03_JPRB,&
&.577E-03_JPRB,.572E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 21  10.0
ZAER (:,21, 4) = (/&
&.562E-03_JPRB,.561E-03_JPRB,.528E-03_JPRB,.526E-03_JPRB,.524E-03_JPRB,.517E-03_JPRB,.502E-03_JPRB,&
&.492E-03_JPRB,.488E-03_JPRB,.476E-03_JPRB,.472E-03_JPRB,.474E-03_JPRB,.499E-03_JPRB,.531E-03_JPRB,&
&.590E-03_JPRB,.666E-03_JPRB,.743E-03_JPRB,.859E-03_JPRB,.101E-02_JPRB,.106E-02_JPRB,.109E-02_JPRB,&
&.106E-02_JPRB,.112E-02_JPRB,.119E-02_JPRB,.145E-02_JPRB,.152E-02_JPRB,.158E-02_JPRB,.172E-02_JPRB,&
&.155E-02_JPRB,.139E-02_JPRB,.111E-02_JPRB,.107E-02_JPRB,.106E-02_JPRB,.110E-02_JPRB,.117E-02_JPRB,&
&.122E-02_JPRB,.128E-02_JPRB,.122E-02_JPRB,.118E-02_JPRB,.111E-02_JPRB,.118E-02_JPRB,.127E-02_JPRB,&
&.139E-02_JPRB,.129E-02_JPRB,.115E-02_JPRB,.985E-03_JPRB,.859E-03_JPRB,.836E-03_JPRB,.818E-03_JPRB,&
&.789E-03_JPRB,.780E-03_JPRB,.771E-03_JPRB,.751E-03_JPRB,.760E-03_JPRB,.785E-03_JPRB,.913E-03_JPRB,&
&.116E-02_JPRB,.128E-02_JPRB,.128E-02_JPRB,.112E-02_JPRB,.102E-02_JPRB,.928E-03_JPRB,.817E-03_JPRB,&
&.757E-03_JPRB,.690E-03_JPRB,.616E-03_JPRB,.584E-03_JPRB,.554E-03_JPRB,.565E-03_JPRB,.573E-03_JPRB,&
&.583E-03_JPRB,.563E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 22   6.0
ZAER (:,22, 4) = (/&
&.562E-03_JPRB,.560E-03_JPRB,.520E-03_JPRB,.530E-03_JPRB,.537E-03_JPRB,.524E-03_JPRB,.509E-03_JPRB,&
&.503E-03_JPRB,.517E-03_JPRB,.526E-03_JPRB,.533E-03_JPRB,.544E-03_JPRB,.587E-03_JPRB,.629E-03_JPRB,&
&.702E-03_JPRB,.802E-03_JPRB,.886E-03_JPRB,.101E-02_JPRB,.115E-02_JPRB,.121E-02_JPRB,.128E-02_JPRB,&
&.131E-02_JPRB,.139E-02_JPRB,.149E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.153E-02_JPRB,.168E-02_JPRB,&
&.157E-02_JPRB,.147E-02_JPRB,.136E-02_JPRB,.139E-02_JPRB,.142E-02_JPRB,.148E-02_JPRB,.159E-02_JPRB,&
&.163E-02_JPRB,.163E-02_JPRB,.155E-02_JPRB,.147E-02_JPRB,.135E-02_JPRB,.144E-02_JPRB,.154E-02_JPRB,&
&.169E-02_JPRB,.155E-02_JPRB,.137E-02_JPRB,.115E-02_JPRB,.963E-03_JPRB,.935E-03_JPRB,.914E-03_JPRB,&
&.884E-03_JPRB,.875E-03_JPRB,.864E-03_JPRB,.819E-03_JPRB,.823E-03_JPRB,.864E-03_JPRB,.111E-02_JPRB,&
&.153E-02_JPRB,.174E-02_JPRB,.172E-02_JPRB,.143E-02_JPRB,.125E-02_JPRB,.103E-02_JPRB,.846E-03_JPRB,&
&.749E-03_JPRB,.650E-03_JPRB,.574E-03_JPRB,.561E-03_JPRB,.563E-03_JPRB,.605E-03_JPRB,.612E-03_JPRB,&
&.616E-03_JPRB,.563E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 23   2.0
ZAER (:,23, 4) = (/&
&.610E-03_JPRB,.608E-03_JPRB,.553E-03_JPRB,.565E-03_JPRB,.573E-03_JPRB,.550E-03_JPRB,.536E-03_JPRB,&
&.532E-03_JPRB,.557E-03_JPRB,.576E-03_JPRB,.594E-03_JPRB,.626E-03_JPRB,.693E-03_JPRB,.750E-03_JPRB,&
&.842E-03_JPRB,.947E-03_JPRB,.102E-02_JPRB,.112E-02_JPRB,.128E-02_JPRB,.139E-02_JPRB,.153E-02_JPRB,&
&.173E-02_JPRB,.191E-02_JPRB,.210E-02_JPRB,.173E-02_JPRB,.164E-02_JPRB,.157E-02_JPRB,.172E-02_JPRB,&
&.168E-02_JPRB,.167E-02_JPRB,.183E-02_JPRB,.192E-02_JPRB,.200E-02_JPRB,.215E-02_JPRB,.220E-02_JPRB,&
&.219E-02_JPRB,.210E-02_JPRB,.197E-02_JPRB,.187E-02_JPRB,.175E-02_JPRB,.190E-02_JPRB,.201E-02_JPRB,&
&.216E-02_JPRB,.189E-02_JPRB,.168E-02_JPRB,.144E-02_JPRB,.123E-02_JPRB,.118E-02_JPRB,.114E-02_JPRB,&
&.108E-02_JPRB,.106E-02_JPRB,.105E-02_JPRB,.103E-02_JPRB,.103E-02_JPRB,.107E-02_JPRB,.136E-02_JPRB,&
&.168E-02_JPRB,.182E-02_JPRB,.171E-02_JPRB,.151E-02_JPRB,.136E-02_JPRB,.114E-02_JPRB,.894E-03_JPRB,&
&.766E-03_JPRB,.635E-03_JPRB,.585E-03_JPRB,.602E-03_JPRB,.645E-03_JPRB,.725E-03_JPRB,.728E-03_JPRB,&
&.723E-03_JPRB,.614E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 24  -2.0
ZAER (:,24, 4) = (/&
&.737E-03_JPRB,.735E-03_JPRB,.676E-03_JPRB,.684E-03_JPRB,.687E-03_JPRB,.650E-03_JPRB,.645E-03_JPRB,&
&.644E-03_JPRB,.654E-03_JPRB,.658E-03_JPRB,.677E-03_JPRB,.739E-03_JPRB,.876E-03_JPRB,.963E-03_JPRB,&
&.107E-02_JPRB,.114E-02_JPRB,.122E-02_JPRB,.133E-02_JPRB,.160E-02_JPRB,.178E-02_JPRB,.199E-02_JPRB,&
&.252E-02_JPRB,.280E-02_JPRB,.308E-02_JPRB,.213E-02_JPRB,.193E-02_JPRB,.176E-02_JPRB,.190E-02_JPRB,&
&.197E-02_JPRB,.206E-02_JPRB,.243E-02_JPRB,.270E-02_JPRB,.292E-02_JPRB,.327E-02_JPRB,.323E-02_JPRB,&
&.313E-02_JPRB,.288E-02_JPRB,.267E-02_JPRB,.264E-02_JPRB,.273E-02_JPRB,.296E-02_JPRB,.303E-02_JPRB,&
&.305E-02_JPRB,.226E-02_JPRB,.203E-02_JPRB,.185E-02_JPRB,.168E-02_JPRB,.158E-02_JPRB,.148E-02_JPRB,&
&.141E-02_JPRB,.143E-02_JPRB,.145E-02_JPRB,.158E-02_JPRB,.149E-02_JPRB,.147E-02_JPRB,.166E-02_JPRB,&
&.182E-02_JPRB,.184E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,.154E-02_JPRB,.143E-02_JPRB,.115E-02_JPRB,&
&.102E-02_JPRB,.889E-03_JPRB,.849E-03_JPRB,.866E-03_JPRB,.907E-03_JPRB,.989E-03_JPRB,.966E-03_JPRB,&
&.927E-03_JPRB,.743E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 25  -6.0
ZAER (:,25, 4) = (/&
&.967E-03_JPRB,.965E-03_JPRB,.901E-03_JPRB,.907E-03_JPRB,.911E-03_JPRB,.901E-03_JPRB,.883E-03_JPRB,&
&.865E-03_JPRB,.825E-03_JPRB,.806E-03_JPRB,.825E-03_JPRB,.929E-03_JPRB,.118E-02_JPRB,.132E-02_JPRB,&
&.146E-02_JPRB,.158E-02_JPRB,.174E-02_JPRB,.199E-02_JPRB,.241E-02_JPRB,.265E-02_JPRB,.290E-02_JPRB,&
&.345E-02_JPRB,.353E-02_JPRB,.358E-02_JPRB,.240E-02_JPRB,.221E-02_JPRB,.204E-02_JPRB,.217E-02_JPRB,&
&.227E-02_JPRB,.243E-02_JPRB,.307E-02_JPRB,.370E-02_JPRB,.416E-02_JPRB,.471E-02_JPRB,.441E-02_JPRB,&
&.420E-02_JPRB,.394E-02_JPRB,.374E-02_JPRB,.385E-02_JPRB,.425E-02_JPRB,.487E-02_JPRB,.482E-02_JPRB,&
&.450E-02_JPRB,.290E-02_JPRB,.250E-02_JPRB,.222E-02_JPRB,.209E-02_JPRB,.200E-02_JPRB,.190E-02_JPRB,&
&.192E-02_JPRB,.207E-02_JPRB,.223E-02_JPRB,.254E-02_JPRB,.228E-02_JPRB,.213E-02_JPRB,.220E-02_JPRB,&
&.248E-02_JPRB,.253E-02_JPRB,.212E-02_JPRB,.217E-02_JPRB,.216E-02_JPRB,.208E-02_JPRB,.176E-02_JPRB,&
&.161E-02_JPRB,.150E-02_JPRB,.144E-02_JPRB,.144E-02_JPRB,.146E-02_JPRB,.142E-02_JPRB,.133E-02_JPRB,&
&.121E-02_JPRB,.974E-03_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 26 -10.0
ZAER (:,26, 4) = (/&
&.132E-02_JPRB,.131E-02_JPRB,.125E-02_JPRB,.127E-02_JPRB,.129E-02_JPRB,.130E-02_JPRB,.126E-02_JPRB,&
&.122E-02_JPRB,.110E-02_JPRB,.104E-02_JPRB,.104E-02_JPRB,.116E-02_JPRB,.153E-02_JPRB,.177E-02_JPRB,&
&.209E-02_JPRB,.255E-02_JPRB,.305E-02_JPRB,.382E-02_JPRB,.414E-02_JPRB,.407E-02_JPRB,.390E-02_JPRB,&
&.375E-02_JPRB,.359E-02_JPRB,.342E-02_JPRB,.244E-02_JPRB,.227E-02_JPRB,.214E-02_JPRB,.225E-02_JPRB,&
&.241E-02_JPRB,.262E-02_JPRB,.345E-02_JPRB,.461E-02_JPRB,.546E-02_JPRB,.642E-02_JPRB,.529E-02_JPRB,&
&.471E-02_JPRB,.437E-02_JPRB,.436E-02_JPRB,.460E-02_JPRB,.520E-02_JPRB,.602E-02_JPRB,.597E-02_JPRB,&
&.556E-02_JPRB,.376E-02_JPRB,.308E-02_JPRB,.245E-02_JPRB,.229E-02_JPRB,.230E-02_JPRB,.232E-02_JPRB,&
&.277E-02_JPRB,.326E-02_JPRB,.372E-02_JPRB,.415E-02_JPRB,.359E-02_JPRB,.323E-02_JPRB,.324E-02_JPRB,&
&.385E-02_JPRB,.402E-02_JPRB,.345E-02_JPRB,.326E-02_JPRB,.317E-02_JPRB,.310E-02_JPRB,.276E-02_JPRB,&
&.259E-02_JPRB,.240E-02_JPRB,.221E-02_JPRB,.216E-02_JPRB,.214E-02_JPRB,.195E-02_JPRB,.177E-02_JPRB,&
&.157E-02_JPRB,.132E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 27 -14.0
ZAER (:,27, 4) = (/&
&.168E-02_JPRB,.167E-02_JPRB,.163E-02_JPRB,.164E-02_JPRB,.165E-02_JPRB,.171E-02_JPRB,.167E-02_JPRB,&
&.163E-02_JPRB,.151E-02_JPRB,.139E-02_JPRB,.135E-02_JPRB,.141E-02_JPRB,.182E-02_JPRB,.217E-02_JPRB,&
&.274E-02_JPRB,.389E-02_JPRB,.490E-02_JPRB,.634E-02_JPRB,.629E-02_JPRB,.555E-02_JPRB,.443E-02_JPRB,&
&.344E-02_JPRB,.318E-02_JPRB,.296E-02_JPRB,.229E-02_JPRB,.216E-02_JPRB,.204E-02_JPRB,.207E-02_JPRB,&
&.219E-02_JPRB,.239E-02_JPRB,.325E-02_JPRB,.461E-02_JPRB,.571E-02_JPRB,.733E-02_JPRB,.565E-02_JPRB,&
&.469E-02_JPRB,.386E-02_JPRB,.404E-02_JPRB,.427E-02_JPRB,.469E-02_JPRB,.511E-02_JPRB,.511E-02_JPRB,&
&.495E-02_JPRB,.391E-02_JPRB,.327E-02_JPRB,.256E-02_JPRB,.238E-02_JPRB,.252E-02_JPRB,.269E-02_JPRB,&
&.382E-02_JPRB,.473E-02_JPRB,.554E-02_JPRB,.603E-02_JPRB,.546E-02_JPRB,.503E-02_JPRB,.465E-02_JPRB,&
&.541E-02_JPRB,.569E-02_JPRB,.529E-02_JPRB,.474E-02_JPRB,.446E-02_JPRB,.426E-02_JPRB,.395E-02_JPRB,&
&.373E-02_JPRB,.345E-02_JPRB,.303E-02_JPRB,.290E-02_JPRB,.279E-02_JPRB,.234E-02_JPRB,.209E-02_JPRB,&
&.184E-02_JPRB,.168E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 28 -18.0
ZAER (:,28, 4) = (/&
&.198E-02_JPRB,.198E-02_JPRB,.200E-02_JPRB,.197E-02_JPRB,.196E-02_JPRB,.203E-02_JPRB,.198E-02_JPRB,&
&.194E-02_JPRB,.186E-02_JPRB,.174E-02_JPRB,.168E-02_JPRB,.169E-02_JPRB,.207E-02_JPRB,.246E-02_JPRB,&
&.315E-02_JPRB,.444E-02_JPRB,.554E-02_JPRB,.709E-02_JPRB,.702E-02_JPRB,.598E-02_JPRB,.443E-02_JPRB,&
&.309E-02_JPRB,.282E-02_JPRB,.262E-02_JPRB,.216E-02_JPRB,.205E-02_JPRB,.195E-02_JPRB,.186E-02_JPRB,&
&.195E-02_JPRB,.209E-02_JPRB,.263E-02_JPRB,.358E-02_JPRB,.445E-02_JPRB,.607E-02_JPRB,.488E-02_JPRB,&
&.410E-02_JPRB,.322E-02_JPRB,.339E-02_JPRB,.351E-02_JPRB,.368E-02_JPRB,.384E-02_JPRB,.387E-02_JPRB,&
&.387E-02_JPRB,.349E-02_JPRB,.314E-02_JPRB,.274E-02_JPRB,.264E-02_JPRB,.282E-02_JPRB,.305E-02_JPRB,&
&.468E-02_JPRB,.587E-02_JPRB,.693E-02_JPRB,.766E-02_JPRB,.724E-02_JPRB,.676E-02_JPRB,.548E-02_JPRB,&
&.664E-02_JPRB,.744E-02_JPRB,.827E-02_JPRB,.726E-02_JPRB,.653E-02_JPRB,.553E-02_JPRB,.501E-02_JPRB,&
&.470E-02_JPRB,.433E-02_JPRB,.382E-02_JPRB,.359E-02_JPRB,.336E-02_JPRB,.264E-02_JPRB,.235E-02_JPRB,&
&.207E-02_JPRB,.198E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 29 -22.0
ZAER (:,29, 4) = (/&
&.219E-02_JPRB,.219E-02_JPRB,.224E-02_JPRB,.223E-02_JPRB,.222E-02_JPRB,.230E-02_JPRB,.221E-02_JPRB,&
&.214E-02_JPRB,.200E-02_JPRB,.193E-02_JPRB,.191E-02_JPRB,.197E-02_JPRB,.232E-02_JPRB,.265E-02_JPRB,&
&.319E-02_JPRB,.399E-02_JPRB,.468E-02_JPRB,.566E-02_JPRB,.590E-02_JPRB,.522E-02_JPRB,.412E-02_JPRB,&
&.290E-02_JPRB,.263E-02_JPRB,.242E-02_JPRB,.211E-02_JPRB,.200E-02_JPRB,.190E-02_JPRB,.176E-02_JPRB,&
&.185E-02_JPRB,.194E-02_JPRB,.216E-02_JPRB,.258E-02_JPRB,.300E-02_JPRB,.392E-02_JPRB,.352E-02_JPRB,&
&.322E-02_JPRB,.282E-02_JPRB,.286E-02_JPRB,.294E-02_JPRB,.308E-02_JPRB,.349E-02_JPRB,.367E-02_JPRB,&
&.385E-02_JPRB,.357E-02_JPRB,.341E-02_JPRB,.323E-02_JPRB,.317E-02_JPRB,.331E-02_JPRB,.348E-02_JPRB,&
&.500E-02_JPRB,.616E-02_JPRB,.719E-02_JPRB,.791E-02_JPRB,.734E-02_JPRB,.677E-02_JPRB,.556E-02_JPRB,&
&.784E-02_JPRB,.980E-02_JPRB,.131E-01_JPRB,.117E-01_JPRB,.103E-01_JPRB,.756E-02_JPRB,.635E-02_JPRB,&
&.574E-02_JPRB,.514E-02_JPRB,.448E-02_JPRB,.413E-02_JPRB,.375E-02_JPRB,.304E-02_JPRB,.269E-02_JPRB,&
&.233E-02_JPRB,.220E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 30 -26.0
ZAER (:,30, 4) = (/&
&.235E-02_JPRB,.235E-02_JPRB,.233E-02_JPRB,.237E-02_JPRB,.242E-02_JPRB,.253E-02_JPRB,.239E-02_JPRB,&
&.226E-02_JPRB,.201E-02_JPRB,.195E-02_JPRB,.197E-02_JPRB,.212E-02_JPRB,.251E-02_JPRB,.274E-02_JPRB,&
&.300E-02_JPRB,.334E-02_JPRB,.370E-02_JPRB,.425E-02_JPRB,.468E-02_JPRB,.441E-02_JPRB,.391E-02_JPRB,&
&.292E-02_JPRB,.262E-02_JPRB,.236E-02_JPRB,.211E-02_JPRB,.201E-02_JPRB,.191E-02_JPRB,.180E-02_JPRB,&
&.185E-02_JPRB,.190E-02_JPRB,.197E-02_JPRB,.213E-02_JPRB,.230E-02_JPRB,.266E-02_JPRB,.270E-02_JPRB,&
&.271E-02_JPRB,.265E-02_JPRB,.270E-02_JPRB,.284E-02_JPRB,.314E-02_JPRB,.394E-02_JPRB,.441E-02_JPRB,&
&.495E-02_JPRB,.458E-02_JPRB,.436E-02_JPRB,.413E-02_JPRB,.386E-02_JPRB,.390E-02_JPRB,.397E-02_JPRB,&
&.508E-02_JPRB,.585E-02_JPRB,.650E-02_JPRB,.653E-02_JPRB,.576E-02_JPRB,.525E-02_JPRB,.529E-02_JPRB,&
&.925E-02_JPRB,.128E-01_JPRB,.191E-01_JPRB,.174E-01_JPRB,.153E-01_JPRB,.107E-01_JPRB,.841E-02_JPRB,&
&.723E-02_JPRB,.600E-02_JPRB,.488E-02_JPRB,.439E-02_JPRB,.392E-02_JPRB,.337E-02_JPRB,.303E-02_JPRB,&
&.267E-02_JPRB,.236E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 31 -30.0
ZAER (:,31, 4) = (/&
&.259E-02_JPRB,.259E-02_JPRB,.244E-02_JPRB,.250E-02_JPRB,.256E-02_JPRB,.265E-02_JPRB,.246E-02_JPRB,&
&.229E-02_JPRB,.196E-02_JPRB,.190E-02_JPRB,.194E-02_JPRB,.217E-02_JPRB,.258E-02_JPRB,.273E-02_JPRB,&
&.274E-02_JPRB,.285E-02_JPRB,.314E-02_JPRB,.365E-02_JPRB,.420E-02_JPRB,.417E-02_JPRB,.398E-02_JPRB,&
&.322E-02_JPRB,.285E-02_JPRB,.248E-02_JPRB,.219E-02_JPRB,.209E-02_JPRB,.199E-02_JPRB,.188E-02_JPRB,&
&.187E-02_JPRB,.186E-02_JPRB,.190E-02_JPRB,.206E-02_JPRB,.222E-02_JPRB,.251E-02_JPRB,.276E-02_JPRB,&
&.288E-02_JPRB,.290E-02_JPRB,.310E-02_JPRB,.341E-02_JPRB,.400E-02_JPRB,.515E-02_JPRB,.587E-02_JPRB,&
&.672E-02_JPRB,.628E-02_JPRB,.586E-02_JPRB,.536E-02_JPRB,.474E-02_JPRB,.469E-02_JPRB,.467E-02_JPRB,&
&.539E-02_JPRB,.557E-02_JPRB,.566E-02_JPRB,.487E-02_JPRB,.418E-02_JPRB,.389E-02_JPRB,.500E-02_JPRB,&
&.103E-01_JPRB,.149E-01_JPRB,.230E-01_JPRB,.214E-01_JPRB,.190E-01_JPRB,.137E-01_JPRB,.105E-01_JPRB,&
&.871E-02_JPRB,.668E-02_JPRB,.504E-02_JPRB,.441E-02_JPRB,.386E-02_JPRB,.350E-02_JPRB,.328E-02_JPRB,&
&.306E-02_JPRB,.260E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 32 -34.0
ZAER (:,32, 4) = (/&
&.293E-02_JPRB,.292E-02_JPRB,.265E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,.264E-02_JPRB,.242E-02_JPRB,&
&.223E-02_JPRB,.190E-02_JPRB,.187E-02_JPRB,.194E-02_JPRB,.224E-02_JPRB,.254E-02_JPRB,.258E-02_JPRB,&
&.239E-02_JPRB,.243E-02_JPRB,.271E-02_JPRB,.326E-02_JPRB,.402E-02_JPRB,.414E-02_JPRB,.416E-02_JPRB,&
&.362E-02_JPRB,.321E-02_JPRB,.276E-02_JPRB,.231E-02_JPRB,.218E-02_JPRB,.206E-02_JPRB,.192E-02_JPRB,&
&.186E-02_JPRB,.181E-02_JPRB,.182E-02_JPRB,.203E-02_JPRB,.226E-02_JPRB,.277E-02_JPRB,.325E-02_JPRB,&
&.350E-02_JPRB,.364E-02_JPRB,.411E-02_JPRB,.472E-02_JPRB,.584E-02_JPRB,.745E-02_JPRB,.824E-02_JPRB,&
&.906E-02_JPRB,.845E-02_JPRB,.778E-02_JPRB,.697E-02_JPRB,.618E-02_JPRB,.608E-02_JPRB,.601E-02_JPRB,&
&.626E-02_JPRB,.585E-02_JPRB,.540E-02_JPRB,.420E-02_JPRB,.379E-02_JPRB,.372E-02_JPRB,.504E-02_JPRB,&
&.102E-01_JPRB,.147E-01_JPRB,.222E-01_JPRB,.214E-01_JPRB,.196E-01_JPRB,.153E-01_JPRB,.117E-01_JPRB,&
&.951E-02_JPRB,.693E-02_JPRB,.507E-02_JPRB,.434E-02_JPRB,.367E-02_JPRB,.346E-02_JPRB,.340E-02_JPRB,&
&.334E-02_JPRB,.294E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 33 -38.0
ZAER (:,33, 4) = (/&
&.312E-02_JPRB,.311E-02_JPRB,.281E-02_JPRB,.271E-02_JPRB,.262E-02_JPRB,.255E-02_JPRB,.234E-02_JPRB,&
&.216E-02_JPRB,.186E-02_JPRB,.188E-02_JPRB,.198E-02_JPRB,.230E-02_JPRB,.242E-02_JPRB,.235E-02_JPRB,&
&.206E-02_JPRB,.206E-02_JPRB,.231E-02_JPRB,.279E-02_JPRB,.364E-02_JPRB,.390E-02_JPRB,.408E-02_JPRB,&
&.376E-02_JPRB,.339E-02_JPRB,.297E-02_JPRB,.236E-02_JPRB,.219E-02_JPRB,.203E-02_JPRB,.187E-02_JPRB,&
&.180E-02_JPRB,.175E-02_JPRB,.175E-02_JPRB,.196E-02_JPRB,.224E-02_JPRB,.300E-02_JPRB,.368E-02_JPRB,&
&.410E-02_JPRB,.452E-02_JPRB,.545E-02_JPRB,.661E-02_JPRB,.868E-02_JPRB,.112E-01_JPRB,.120E-01_JPRB,&
&.126E-01_JPRB,.116E-01_JPRB,.107E-01_JPRB,.952E-02_JPRB,.848E-02_JPRB,.825E-02_JPRB,.805E-02_JPRB,&
&.765E-02_JPRB,.685E-02_JPRB,.606E-02_JPRB,.472E-02_JPRB,.448E-02_JPRB,.445E-02_JPRB,.537E-02_JPRB,&
&.898E-02_JPRB,.121E-01_JPRB,.174E-01_JPRB,.178E-01_JPRB,.170E-01_JPRB,.145E-01_JPRB,.114E-01_JPRB,&
&.929E-02_JPRB,.671E-02_JPRB,.493E-02_JPRB,.418E-02_JPRB,.347E-02_JPRB,.334E-02_JPRB,.335E-02_JPRB,&
&.338E-02_JPRB,.313E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 34 -42.0
ZAER (:,34, 4) = (/&
&.301E-02_JPRB,.301E-02_JPRB,.274E-02_JPRB,.262E-02_JPRB,.251E-02_JPRB,.244E-02_JPRB,.228E-02_JPRB,&
&.214E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.196E-02_JPRB,.222E-02_JPRB,.223E-02_JPRB,.215E-02_JPRB,&
&.191E-02_JPRB,.192E-02_JPRB,.209E-02_JPRB,.242E-02_JPRB,.310E-02_JPRB,.335E-02_JPRB,.357E-02_JPRB,&
&.340E-02_JPRB,.315E-02_JPRB,.286E-02_JPRB,.224E-02_JPRB,.207E-02_JPRB,.191E-02_JPRB,.179E-02_JPRB,&
&.174E-02_JPRB,.171E-02_JPRB,.174E-02_JPRB,.195E-02_JPRB,.225E-02_JPRB,.311E-02_JPRB,.400E-02_JPRB,&
&.462E-02_JPRB,.542E-02_JPRB,.743E-02_JPRB,.955E-02_JPRB,.131E-01_JPRB,.167E-01_JPRB,.176E-01_JPRB,&
&.179E-01_JPRB,.164E-01_JPRB,.152E-01_JPRB,.136E-01_JPRB,.116E-01_JPRB,.109E-01_JPRB,.102E-01_JPRB,&
&.919E-02_JPRB,.830E-02_JPRB,.744E-02_JPRB,.603E-02_JPRB,.565E-02_JPRB,.541E-02_JPRB,.553E-02_JPRB,&
&.726E-02_JPRB,.886E-02_JPRB,.118E-01_JPRB,.129E-01_JPRB,.130E-01_JPRB,.120E-01_JPRB,.970E-02_JPRB,&
&.812E-02_JPRB,.604E-02_JPRB,.446E-02_JPRB,.384E-02_JPRB,.328E-02_JPRB,.318E-02_JPRB,.318E-02_JPRB,&
&.320E-02_JPRB,.302E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 35 -46.0
ZAER (:,35, 4) = (/&
&.278E-02_JPRB,.278E-02_JPRB,.253E-02_JPRB,.244E-02_JPRB,.236E-02_JPRB,.229E-02_JPRB,.221E-02_JPRB,&
&.213E-02_JPRB,.194E-02_JPRB,.188E-02_JPRB,.188E-02_JPRB,.200E-02_JPRB,.202E-02_JPRB,.198E-02_JPRB,&
&.189E-02_JPRB,.190E-02_JPRB,.201E-02_JPRB,.221E-02_JPRB,.256E-02_JPRB,.268E-02_JPRB,.277E-02_JPRB,&
&.271E-02_JPRB,.258E-02_JPRB,.243E-02_JPRB,.200E-02_JPRB,.188E-02_JPRB,.178E-02_JPRB,.172E-02_JPRB,&
&.169E-02_JPRB,.168E-02_JPRB,.177E-02_JPRB,.205E-02_JPRB,.240E-02_JPRB,.331E-02_JPRB,.455E-02_JPRB,&
&.554E-02_JPRB,.707E-02_JPRB,.112E-01_JPRB,.147E-01_JPRB,.202E-01_JPRB,.238E-01_JPRB,.244E-01_JPRB,&
&.242E-01_JPRB,.226E-01_JPRB,.209E-01_JPRB,.188E-01_JPRB,.152E-01_JPRB,.136E-01_JPRB,.122E-01_JPRB,&
&.106E-01_JPRB,.973E-02_JPRB,.891E-02_JPRB,.758E-02_JPRB,.689E-02_JPRB,.634E-02_JPRB,.566E-02_JPRB,&
&.607E-02_JPRB,.659E-02_JPRB,.788E-02_JPRB,.864E-02_JPRB,.885E-02_JPRB,.861E-02_JPRB,.730E-02_JPRB,&
&.629E-02_JPRB,.490E-02_JPRB,.382E-02_JPRB,.345E-02_JPRB,.315E-02_JPRB,.306E-02_JPRB,.303E-02_JPRB,&
&.300E-02_JPRB,.279E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 36 -50.0
ZAER (:,36, 4) = (/&
&.259E-02_JPRB,.258E-02_JPRB,.230E-02_JPRB,.223E-02_JPRB,.216E-02_JPRB,.214E-02_JPRB,.209E-02_JPRB,&
&.205E-02_JPRB,.194E-02_JPRB,.186E-02_JPRB,.183E-02_JPRB,.181E-02_JPRB,.183E-02_JPRB,.183E-02_JPRB,&
&.184E-02_JPRB,.190E-02_JPRB,.196E-02_JPRB,.205E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,.212E-02_JPRB,&
&.207E-02_JPRB,.201E-02_JPRB,.194E-02_JPRB,.176E-02_JPRB,.172E-02_JPRB,.168E-02_JPRB,.165E-02_JPRB,&
&.165E-02_JPRB,.166E-02_JPRB,.180E-02_JPRB,.218E-02_JPRB,.261E-02_JPRB,.360E-02_JPRB,.520E-02_JPRB,&
&.667E-02_JPRB,.926E-02_JPRB,.155E-01_JPRB,.202E-01_JPRB,.268E-01_JPRB,.293E-01_JPRB,.297E-01_JPRB,&
&.296E-01_JPRB,.285E-01_JPRB,.264E-01_JPRB,.237E-01_JPRB,.185E-01_JPRB,.163E-01_JPRB,.143E-01_JPRB,&
&.119E-01_JPRB,.109E-01_JPRB,.100E-01_JPRB,.875E-02_JPRB,.794E-02_JPRB,.725E-02_JPRB,.620E-02_JPRB,&
&.590E-02_JPRB,.574E-02_JPRB,.570E-02_JPRB,.569E-02_JPRB,.563E-02_JPRB,.549E-02_JPRB,.477E-02_JPRB,&
&.428E-02_JPRB,.365E-02_JPRB,.326E-02_JPRB,.313E-02_JPRB,.305E-02_JPRB,.298E-02_JPRB,.292E-02_JPRB,&
&.286E-02_JPRB,.260E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 37 -54.0
ZAER (:,37, 4) = (/&
&.250E-02_JPRB,.250E-02_JPRB,.220E-02_JPRB,.210E-02_JPRB,.201E-02_JPRB,.196E-02_JPRB,.191E-02_JPRB,&
&.187E-02_JPRB,.182E-02_JPRB,.178E-02_JPRB,.175E-02_JPRB,.171E-02_JPRB,.172E-02_JPRB,.173E-02_JPRB,&
&.177E-02_JPRB,.181E-02_JPRB,.183E-02_JPRB,.185E-02_JPRB,.184E-02_JPRB,.181E-02_JPRB,.176E-02_JPRB,&
&.170E-02_JPRB,.167E-02_JPRB,.165E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,&
&.160E-02_JPRB,.163E-02_JPRB,.181E-02_JPRB,.224E-02_JPRB,.267E-02_JPRB,.359E-02_JPRB,.499E-02_JPRB,&
&.640E-02_JPRB,.908E-02_JPRB,.148E-01_JPRB,.190E-01_JPRB,.247E-01_JPRB,.277E-01_JPRB,.294E-01_JPRB,&
&.314E-01_JPRB,.313E-01_JPRB,.291E-01_JPRB,.260E-01_JPRB,.201E-01_JPRB,.176E-01_JPRB,.153E-01_JPRB,&
&.126E-01_JPRB,.113E-01_JPRB,.102E-01_JPRB,.876E-02_JPRB,.807E-02_JPRB,.745E-02_JPRB,.643E-02_JPRB,&
&.584E-02_JPRB,.540E-02_JPRB,.482E-02_JPRB,.434E-02_JPRB,.401E-02_JPRB,.356E-02_JPRB,.316E-02_JPRB,&
&.297E-02_JPRB,.280E-02_JPRB,.280E-02_JPRB,.283E-02_JPRB,.287E-02_JPRB,.287E-02_JPRB,.281E-02_JPRB,&
&.273E-02_JPRB,.251E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 38 -58.0
ZAER (:,38, 4) = (/&
&.251E-02_JPRB,.250E-02_JPRB,.227E-02_JPRB,.212E-02_JPRB,.199E-02_JPRB,.182E-02_JPRB,.174E-02_JPRB,&
&.168E-02_JPRB,.162E-02_JPRB,.161E-02_JPRB,.161E-02_JPRB,.160E-02_JPRB,.161E-02_JPRB,.162E-02_JPRB,&
&.163E-02_JPRB,.161E-02_JPRB,.160E-02_JPRB,.160E-02_JPRB,.157E-02_JPRB,.156E-02_JPRB,.155E-02_JPRB,&
&.154E-02_JPRB,.153E-02_JPRB,.152E-02_JPRB,.151E-02_JPRB,.151E-02_JPRB,.150E-02_JPRB,.149E-02_JPRB,&
&.150E-02_JPRB,.154E-02_JPRB,.174E-02_JPRB,.214E-02_JPRB,.252E-02_JPRB,.328E-02_JPRB,.429E-02_JPRB,&
&.528E-02_JPRB,.714E-02_JPRB,.996E-02_JPRB,.121E-01_JPRB,.151E-01_JPRB,.192E-01_JPRB,.219E-01_JPRB,&
&.251E-01_JPRB,.265E-01_JPRB,.252E-01_JPRB,.232E-01_JPRB,.181E-01_JPRB,.159E-01_JPRB,.138E-01_JPRB,&
&.112E-01_JPRB,.996E-02_JPRB,.884E-02_JPRB,.754E-02_JPRB,.705E-02_JPRB,.659E-02_JPRB,.573E-02_JPRB,&
&.512E-02_JPRB,.467E-02_JPRB,.411E-02_JPRB,.366E-02_JPRB,.333E-02_JPRB,.288E-02_JPRB,.256E-02_JPRB,&
&.244E-02_JPRB,.237E-02_JPRB,.246E-02_JPRB,.252E-02_JPRB,.260E-02_JPRB,.263E-02_JPRB,.262E-02_JPRB,&
&.260E-02_JPRB,.251E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 39 -62.0
ZAER (:,39, 4) = (/&
&.253E-02_JPRB,.253E-02_JPRB,.240E-02_JPRB,.226E-02_JPRB,.212E-02_JPRB,.187E-02_JPRB,.173E-02_JPRB,&
&.163E-02_JPRB,.153E-02_JPRB,.150E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,.148E-02_JPRB,&
&.146E-02_JPRB,.143E-02_JPRB,.141E-02_JPRB,.139E-02_JPRB,.140E-02_JPRB,.142E-02_JPRB,.144E-02_JPRB,&
&.148E-02_JPRB,.150E-02_JPRB,.150E-02_JPRB,.146E-02_JPRB,.141E-02_JPRB,.137E-02_JPRB,.131E-02_JPRB,&
&.133E-02_JPRB,.137E-02_JPRB,.156E-02_JPRB,.190E-02_JPRB,.224E-02_JPRB,.296E-02_JPRB,.397E-02_JPRB,&
&.488E-02_JPRB,.647E-02_JPRB,.819E-02_JPRB,.942E-02_JPRB,.111E-01_JPRB,.134E-01_JPRB,.148E-01_JPRB,&
&.166E-01_JPRB,.173E-01_JPRB,.169E-01_JPRB,.163E-01_JPRB,.134E-01_JPRB,.120E-01_JPRB,.107E-01_JPRB,&
&.893E-02_JPRB,.820E-02_JPRB,.751E-02_JPRB,.666E-02_JPRB,.616E-02_JPRB,.571E-02_JPRB,.486E-02_JPRB,&
&.422E-02_JPRB,.378E-02_JPRB,.331E-02_JPRB,.305E-02_JPRB,.286E-02_JPRB,.261E-02_JPRB,.239E-02_JPRB,&
&.229E-02_JPRB,.221E-02_JPRB,.224E-02_JPRB,.228E-02_JPRB,.234E-02_JPRB,.242E-02_JPRB,.246E-02_JPRB,&
&.250E-02_JPRB,.253E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 40 -66.0
ZAER (:,40, 4) = (/&
&.251E-02_JPRB,.250E-02_JPRB,.242E-02_JPRB,.233E-02_JPRB,.223E-02_JPRB,.204E-02_JPRB,.190E-02_JPRB,&
&.180E-02_JPRB,.167E-02_JPRB,.160E-02_JPRB,.156E-02_JPRB,.151E-02_JPRB,.148E-02_JPRB,.146E-02_JPRB,&
&.144E-02_JPRB,.140E-02_JPRB,.139E-02_JPRB,.138E-02_JPRB,.140E-02_JPRB,.143E-02_JPRB,.146E-02_JPRB,&
&.150E-02_JPRB,.150E-02_JPRB,.148E-02_JPRB,.139E-02_JPRB,.133E-02_JPRB,.127E-02_JPRB,.120E-02_JPRB,&
&.122E-02_JPRB,.125E-02_JPRB,.141E-02_JPRB,.167E-02_JPRB,.193E-02_JPRB,.254E-02_JPRB,.342E-02_JPRB,&
&.419E-02_JPRB,.552E-02_JPRB,.695E-02_JPRB,.792E-02_JPRB,.918E-02_JPRB,.105E-01_JPRB,.112E-01_JPRB,&
&.120E-01_JPRB,.122E-01_JPRB,.119E-01_JPRB,.114E-01_JPRB,.983E-02_JPRB,.907E-02_JPRB,.834E-02_JPRB,&
&.737E-02_JPRB,.699E-02_JPRB,.663E-02_JPRB,.608E-02_JPRB,.567E-02_JPRB,.529E-02_JPRB,.459E-02_JPRB,&
&.406E-02_JPRB,.368E-02_JPRB,.322E-02_JPRB,.300E-02_JPRB,.286E-02_JPRB,.272E-02_JPRB,.259E-02_JPRB,&
&.252E-02_JPRB,.244E-02_JPRB,.240E-02_JPRB,.240E-02_JPRB,.241E-02_JPRB,.245E-02_JPRB,.247E-02_JPRB,&
&.249E-02_JPRB,.251E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 41 -70.0
ZAER (:,41, 4) = (/&
&.251E-02_JPRB,.251E-02_JPRB,.241E-02_JPRB,.234E-02_JPRB,.227E-02_JPRB,.214E-02_JPRB,.204E-02_JPRB,&
&.197E-02_JPRB,.186E-02_JPRB,.180E-02_JPRB,.175E-02_JPRB,.167E-02_JPRB,.162E-02_JPRB,.158E-02_JPRB,&
&.154E-02_JPRB,.151E-02_JPRB,.150E-02_JPRB,.149E-02_JPRB,.149E-02_JPRB,.150E-02_JPRB,.151E-02_JPRB,&
&.150E-02_JPRB,.148E-02_JPRB,.145E-02_JPRB,.135E-02_JPRB,.129E-02_JPRB,.124E-02_JPRB,.119E-02_JPRB,&
&.120E-02_JPRB,.123E-02_JPRB,.136E-02_JPRB,.154E-02_JPRB,.173E-02_JPRB,.214E-02_JPRB,.272E-02_JPRB,&
&.324E-02_JPRB,.416E-02_JPRB,.526E-02_JPRB,.604E-02_JPRB,.707E-02_JPRB,.808E-02_JPRB,.852E-02_JPRB,&
&.895E-02_JPRB,.892E-02_JPRB,.862E-02_JPRB,.823E-02_JPRB,.734E-02_JPRB,.693E-02_JPRB,.653E-02_JPRB,&
&.602E-02_JPRB,.584E-02_JPRB,.566E-02_JPRB,.538E-02_JPRB,.515E-02_JPRB,.494E-02_JPRB,.453E-02_JPRB,&
&.419E-02_JPRB,.394E-02_JPRB,.361E-02_JPRB,.340E-02_JPRB,.326E-02_JPRB,.311E-02_JPRB,.297E-02_JPRB,&
&.289E-02_JPRB,.278E-02_JPRB,.270E-02_JPRB,.267E-02_JPRB,.264E-02_JPRB,.262E-02_JPRB,.260E-02_JPRB,&
&.257E-02_JPRB,.251E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 42 -74.0
ZAER (:,42, 4) = (/&
&.252E-02_JPRB,.252E-02_JPRB,.241E-02_JPRB,.234E-02_JPRB,.228E-02_JPRB,.218E-02_JPRB,.212E-02_JPRB,&
&.206E-02_JPRB,.198E-02_JPRB,.193E-02_JPRB,.189E-02_JPRB,.182E-02_JPRB,.176E-02_JPRB,.172E-02_JPRB,&
&.167E-02_JPRB,.163E-02_JPRB,.161E-02_JPRB,.159E-02_JPRB,.156E-02_JPRB,.155E-02_JPRB,.153E-02_JPRB,&
&.150E-02_JPRB,.146E-02_JPRB,.143E-02_JPRB,.136E-02_JPRB,.133E-02_JPRB,.130E-02_JPRB,.127E-02_JPRB,&
&.130E-02_JPRB,.132E-02_JPRB,.142E-02_JPRB,.155E-02_JPRB,.168E-02_JPRB,.195E-02_JPRB,.229E-02_JPRB,&
&.261E-02_JPRB,.315E-02_JPRB,.383E-02_JPRB,.431E-02_JPRB,.497E-02_JPRB,.562E-02_JPRB,.590E-02_JPRB,&
&.617E-02_JPRB,.618E-02_JPRB,.604E-02_JPRB,.585E-02_JPRB,.542E-02_JPRB,.520E-02_JPRB,.499E-02_JPRB,&
&.469E-02_JPRB,.460E-02_JPRB,.451E-02_JPRB,.440E-02_JPRB,.432E-02_JPRB,.425E-02_JPRB,.413E-02_JPRB,&
&.400E-02_JPRB,.390E-02_JPRB,.375E-02_JPRB,.362E-02_JPRB,.352E-02_JPRB,.340E-02_JPRB,.327E-02_JPRB,&
&.318E-02_JPRB,.308E-02_JPRB,.297E-02_JPRB,.291E-02_JPRB,.285E-02_JPRB,.277E-02_JPRB,.271E-02_JPRB,&
&.265E-02_JPRB,.253E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 43 -78.0
ZAER (:,43, 4) = (/&
&.250E-02_JPRB,.249E-02_JPRB,.239E-02_JPRB,.233E-02_JPRB,.227E-02_JPRB,.219E-02_JPRB,.213E-02_JPRB,&
&.209E-02_JPRB,.202E-02_JPRB,.197E-02_JPRB,.193E-02_JPRB,.188E-02_JPRB,.182E-02_JPRB,.178E-02_JPRB,&
&.174E-02_JPRB,.169E-02_JPRB,.167E-02_JPRB,.164E-02_JPRB,.160E-02_JPRB,.158E-02_JPRB,.156E-02_JPRB,&
&.152E-02_JPRB,.150E-02_JPRB,.148E-02_JPRB,.145E-02_JPRB,.145E-02_JPRB,.144E-02_JPRB,.146E-02_JPRB,&
&.149E-02_JPRB,.152E-02_JPRB,.160E-02_JPRB,.169E-02_JPRB,.178E-02_JPRB,.196E-02_JPRB,.216E-02_JPRB,&
&.233E-02_JPRB,.261E-02_JPRB,.295E-02_JPRB,.320E-02_JPRB,.352E-02_JPRB,.385E-02_JPRB,.401E-02_JPRB,&
&.416E-02_JPRB,.423E-02_JPRB,.421E-02_JPRB,.417E-02_JPRB,.403E-02_JPRB,.394E-02_JPRB,.385E-02_JPRB,&
&.371E-02_JPRB,.366E-02_JPRB,.361E-02_JPRB,.356E-02_JPRB,.355E-02_JPRB,.353E-02_JPRB,.350E-02_JPRB,&
&.348E-02_JPRB,.345E-02_JPRB,.341E-02_JPRB,.336E-02_JPRB,.332E-02_JPRB,.326E-02_JPRB,.319E-02_JPRB,&
&.314E-02_JPRB,.306E-02_JPRB,.297E-02_JPRB,.292E-02_JPRB,.285E-02_JPRB,.275E-02_JPRB,.268E-02_JPRB,&
&.262E-02_JPRB,.250E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 44 -82.0
ZAER (:,44, 4) = (/&
&.235E-02_JPRB,.235E-02_JPRB,.228E-02_JPRB,.224E-02_JPRB,.220E-02_JPRB,.214E-02_JPRB,.211E-02_JPRB,&
&.208E-02_JPRB,.203E-02_JPRB,.199E-02_JPRB,.196E-02_JPRB,.192E-02_JPRB,.189E-02_JPRB,.186E-02_JPRB,&
&.183E-02_JPRB,.180E-02_JPRB,.178E-02_JPRB,.176E-02_JPRB,.174E-02_JPRB,.173E-02_JPRB,.172E-02_JPRB,&
&.170E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.169E-02_JPRB,.170E-02_JPRB,.171E-02_JPRB,.173E-02_JPRB,&
&.176E-02_JPRB,.179E-02_JPRB,.185E-02_JPRB,.190E-02_JPRB,.195E-02_JPRB,.205E-02_JPRB,.214E-02_JPRB,&
&.222E-02_JPRB,.234E-02_JPRB,.248E-02_JPRB,.257E-02_JPRB,.269E-02_JPRB,.282E-02_JPRB,.289E-02_JPRB,&
&.296E-02_JPRB,.303E-02_JPRB,.304E-02_JPRB,.306E-02_JPRB,.306E-02_JPRB,.304E-02_JPRB,.303E-02_JPRB,&
&.299E-02_JPRB,.298E-02_JPRB,.296E-02_JPRB,.294E-02_JPRB,.293E-02_JPRB,.293E-02_JPRB,.292E-02_JPRB,&
&.291E-02_JPRB,.290E-02_JPRB,.289E-02_JPRB,.287E-02_JPRB,.285E-02_JPRB,.282E-02_JPRB,.279E-02_JPRB,&
&.276E-02_JPRB,.272E-02_JPRB,.267E-02_JPRB,.263E-02_JPRB,.258E-02_JPRB,.252E-02_JPRB,.248E-02_JPRB,&
&.243E-02_JPRB,.235E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 45 -86.0
ZAER (:,45, 4) = (/&
&.226E-02_JPRB,.226E-02_JPRB,.224E-02_JPRB,.222E-02_JPRB,.220E-02_JPRB,.218E-02_JPRB,.217E-02_JPRB,&
&.215E-02_JPRB,.213E-02_JPRB,.212E-02_JPRB,.211E-02_JPRB,.209E-02_JPRB,.208E-02_JPRB,.207E-02_JPRB,&
&.206E-02_JPRB,.204E-02_JPRB,.204E-02_JPRB,.203E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,&
&.202E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.202E-02_JPRB,.203E-02_JPRB,.204E-02_JPRB,.205E-02_JPRB,&
&.206E-02_JPRB,.207E-02_JPRB,.210E-02_JPRB,.212E-02_JPRB,.214E-02_JPRB,.217E-02_JPRB,.220E-02_JPRB,&
&.222E-02_JPRB,.226E-02_JPRB,.229E-02_JPRB,.231E-02_JPRB,.234E-02_JPRB,.238E-02_JPRB,.240E-02_JPRB,&
&.242E-02_JPRB,.245E-02_JPRB,.246E-02_JPRB,.247E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.250E-02_JPRB,&
&.250E-02_JPRB,.250E-02_JPRB,.250E-02_JPRB,.250E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,.249E-02_JPRB,&
&.248E-02_JPRB,.247E-02_JPRB,.247E-02_JPRB,.246E-02_JPRB,.245E-02_JPRB,.244E-02_JPRB,.243E-02_JPRB,&
&.241E-02_JPRB,.240E-02_JPRB,.238E-02_JPRB,.237E-02_JPRB,.235E-02_JPRB,.232E-02_JPRB,.231E-02_JPRB,&
&.229E-02_JPRB,.226E-02_JPRB/)
!-- Black Carbon Aerosol     month:  4 --- lat: 46 -90.0
ZAER (:,46, 4) = (/&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,.226E-02_JPRB,&
&.226E-02_JPRB,.226E-02_JPRB/)


!     ------------------------------------------------------------------

!ZMAX=-1.E+8_JPRB
!ZMIN= 1.E+8_JPRB
   JM=4
  DO JI=1,46
    DO JL=1,72
      RAERBC(JL,JI,JM)=ZAER(JL,JI,JM)
!      ZMAX=MAX(ZMAX,ZAER(JL,JI,JM))
!      ZMIN=MIN(ZMIN,ZAER(JL,JI,JM))
    ENDDO
  ENDDO

!PRINT 9000,ZMIN,ZMAX
9000 FORMAT(1x,'BLACK CARBON AEROSOLS ',2E12.5)

!     ------------------------------------------------------------------

RETURN
END SUBROUTINE SUECAEBC_04
