!OCL SCALAR
SUBROUTINE RRTM_KGB9_BB

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO9 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, ABSN2OO
USE YOERRTA9 , ONLY : N2OREF  ,H2OREF  ,CH4REF     ,ETAREF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------


!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
&4.0994E-03_JPRB,5.0728E-03_JPRB,6.1420E-03_JPRB,7.2969E-03_JPRB,8.5215E-03_JPRB/)
KBO( :,14, 1) = (/&
&3.5608E-03_JPRB,4.4025E-03_JPRB,5.3259E-03_JPRB,6.3236E-03_JPRB,7.3838E-03_JPRB/)
KBO( :,15, 1) = (/&
&3.1441E-03_JPRB,3.8833E-03_JPRB,4.6911E-03_JPRB,5.5651E-03_JPRB,6.4864E-03_JPRB/)
KBO( :,16, 1) = (/&
&2.7804E-03_JPRB,3.4263E-03_JPRB,4.1318E-03_JPRB,4.8903E-03_JPRB,5.6839E-03_JPRB/)
KBO( :,17, 1) = (/&
&2.5177E-03_JPRB,3.0931E-03_JPRB,3.7229E-03_JPRB,4.3958E-03_JPRB,5.0932E-03_JPRB/)
KBO( :,18, 1) = (/&
&2.3397E-03_JPRB,2.8662E-03_JPRB,3.4383E-03_JPRB,4.0476E-03_JPRB,4.6762E-03_JPRB/)
KBO( :,19, 1) = (/&
&2.2067E-03_JPRB,2.6944E-03_JPRB,3.2196E-03_JPRB,3.7730E-03_JPRB,4.3369E-03_JPRB/)
KBO( :,20, 1) = (/&
&1.9900E-03_JPRB,2.4229E-03_JPRB,2.8861E-03_JPRB,3.3669E-03_JPRB,3.8498E-03_JPRB/)
KBO( :,21, 1) = (/&
&1.7699E-03_JPRB,2.1476E-03_JPRB,2.5489E-03_JPRB,2.9591E-03_JPRB,3.3696E-03_JPRB/)
KBO( :,22, 1) = (/&
&1.5791E-03_JPRB,1.9073E-03_JPRB,2.2490E-03_JPRB,2.5953E-03_JPRB,2.9423E-03_JPRB/)
KBO( :,23, 1) = (/&
&1.4083E-03_JPRB,1.6913E-03_JPRB,1.9813E-03_JPRB,2.2728E-03_JPRB,2.5656E-03_JPRB/)
KBO( :,24, 1) = (/&
&1.2531E-03_JPRB,1.4945E-03_JPRB,1.7386E-03_JPRB,1.9824E-03_JPRB,2.2278E-03_JPRB/)
KBO( :,25, 1) = (/&
&1.1116E-03_JPRB,1.3151E-03_JPRB,1.5192E-03_JPRB,1.7227E-03_JPRB,1.9286E-03_JPRB/)
KBO( :,26, 1) = (/&
&9.8108E-04_JPRB,1.1510E-03_JPRB,1.3208E-03_JPRB,1.4915E-03_JPRB,1.6636E-03_JPRB/)
KBO( :,27, 1) = (/&
&8.5741E-04_JPRB,9.9814E-04_JPRB,1.1394E-03_JPRB,1.2818E-03_JPRB,1.4244E-03_JPRB/)
KBO( :,28, 1) = (/&
&7.4362E-04_JPRB,8.5993E-04_JPRB,9.7672E-04_JPRB,1.0942E-03_JPRB,1.2112E-03_JPRB/)
KBO( :,29, 1) = (/&
&6.4173E-04_JPRB,7.3787E-04_JPRB,8.3430E-04_JPRB,9.3077E-04_JPRB,1.0275E-03_JPRB/)
KBO( :,30, 1) = (/&
&5.5206E-04_JPRB,6.3117E-04_JPRB,7.1043E-04_JPRB,7.8981E-04_JPRB,8.6914E-04_JPRB/)
KBO( :,31, 1) = (/&
&4.7282E-04_JPRB,5.3772E-04_JPRB,6.0295E-04_JPRB,6.6810E-04_JPRB,7.3341E-04_JPRB/)
KBO( :,32, 1) = (/&
&4.0428E-04_JPRB,4.5779E-04_JPRB,5.1149E-04_JPRB,5.6525E-04_JPRB,6.1880E-04_JPRB/)
KBO( :,33, 1) = (/&
&3.4491E-04_JPRB,3.8913E-04_JPRB,4.3344E-04_JPRB,4.7736E-04_JPRB,5.2088E-04_JPRB/)
KBO( :,34, 1) = (/&
&2.9576E-04_JPRB,3.3268E-04_JPRB,3.6928E-04_JPRB,4.0567E-04_JPRB,4.4172E-04_JPRB/)
KBO( :,35, 1) = (/&
&2.5077E-04_JPRB,2.8136E-04_JPRB,3.1174E-04_JPRB,3.4190E-04_JPRB,3.7190E-04_JPRB/)
KBO( :,36, 1) = (/&
&2.0965E-04_JPRB,2.3515E-04_JPRB,2.6041E-04_JPRB,2.8542E-04_JPRB,3.1056E-04_JPRB/)
KBO( :,37, 1) = (/&
&1.6881E-04_JPRB,1.8974E-04_JPRB,2.1051E-04_JPRB,2.3106E-04_JPRB,2.5174E-04_JPRB/)
KBO( :,38, 1) = (/&
&1.3519E-04_JPRB,1.5238E-04_JPRB,1.6942E-04_JPRB,1.8630E-04_JPRB,2.0323E-04_JPRB/)
KBO( :,39, 1) = (/&
&1.0769E-04_JPRB,1.2175E-04_JPRB,1.3571E-04_JPRB,1.4957E-04_JPRB,1.6341E-04_JPRB/)
KBO( :,40, 1) = (/&
&8.3659E-05_JPRB,9.4997E-05_JPRB,1.0624E-04_JPRB,1.1742E-04_JPRB,1.2854E-04_JPRB/)
KBO( :,41, 1) = (/&
&6.4553E-05_JPRB,7.3658E-05_JPRB,8.2687E-05_JPRB,9.1644E-05_JPRB,1.0055E-04_JPRB/)
KBO( :,42, 1) = (/&
&4.9559E-05_JPRB,5.6844E-05_JPRB,6.4074E-05_JPRB,7.1250E-05_JPRB,7.8380E-05_JPRB/)
KBO( :,43, 1) = (/&
&3.7325E-05_JPRB,4.3138E-05_JPRB,4.8889E-05_JPRB,5.4599E-05_JPRB,6.0264E-05_JPRB/)
KBO( :,44, 1) = (/&
&2.7719E-05_JPRB,3.2330E-05_JPRB,3.6894E-05_JPRB,4.1410E-05_JPRB,4.5899E-05_JPRB/)
KBO( :,45, 1) = (/&
&2.0321E-05_JPRB,2.3995E-05_JPRB,2.7586E-05_JPRB,3.1159E-05_JPRB,3.4704E-05_JPRB/)
KBO( :,46, 1) = (/&
&1.4684E-05_JPRB,1.7602E-05_JPRB,2.0438E-05_JPRB,2.3255E-05_JPRB,2.6055E-05_JPRB/)
KBO( :,47, 1) = (/&
&1.0495E-05_JPRB,1.2761E-05_JPRB,1.5036E-05_JPRB,1.7255E-05_JPRB,1.9472E-05_JPRB/)
KBO( :,48, 1) = (/&
&7.3772E-06_JPRB,9.1061E-06_JPRB,1.0897E-05_JPRB,1.2655E-05_JPRB,1.4395E-05_JPRB/)
KBO( :,49, 1) = (/&
&5.0673E-06_JPRB,6.3724E-06_JPRB,7.7347E-06_JPRB,9.1249E-06_JPRB,1.0486E-05_JPRB/)
KBO( :,50, 1) = (/&
&3.5302E-06_JPRB,4.5180E-06_JPRB,5.5663E-06_JPRB,6.6492E-06_JPRB,7.7336E-06_JPRB/)
KBO( :,51, 1) = (/&
&2.4650E-06_JPRB,3.2117E-06_JPRB,4.0196E-06_JPRB,4.8590E-06_JPRB,5.7209E-06_JPRB/)
KBO( :,52, 1) = (/&
&1.6959E-06_JPRB,2.2491E-06_JPRB,2.8606E-06_JPRB,3.5081E-06_JPRB,4.1772E-06_JPRB/)
KBO( :,53, 1) = (/&
&1.1461E-06_JPRB,1.5466E-06_JPRB,1.9999E-06_JPRB,2.4909E-06_JPRB,3.0024E-06_JPRB/)
KBO( :,54, 1) = (/&
&8.1277E-07_JPRB,1.1151E-06_JPRB,1.4623E-06_JPRB,1.8438E-06_JPRB,2.2473E-06_JPRB/)
KBO( :,55, 1) = (/&
&5.9132E-07_JPRB,8.2491E-07_JPRB,1.0964E-06_JPRB,1.3990E-06_JPRB,1.7223E-06_JPRB/)
KBO( :,56, 1) = (/&
&4.2770E-07_JPRB,6.0720E-07_JPRB,8.1863E-07_JPRB,1.0577E-06_JPRB,1.3158E-06_JPRB/)
KBO( :,57, 1) = (/&
&3.0731E-07_JPRB,4.4442E-07_JPRB,6.0841E-07_JPRB,7.9635E-07_JPRB,1.0017E-06_JPRB/)
KBO( :,58, 1) = (/&
&2.2286E-07_JPRB,3.2839E-07_JPRB,4.5650E-07_JPRB,6.0508E-07_JPRB,7.6969E-07_JPRB/)
KBO( :,59, 1) = (/&
&1.8935E-07_JPRB,2.8208E-07_JPRB,3.9434E-07_JPRB,5.2454E-07_JPRB,6.6793E-07_JPRB/)
KBO( :,13, 2) = (/&
&2.0350E-02_JPRB,2.3737E-02_JPRB,2.7056E-02_JPRB,3.0424E-02_JPRB,3.3880E-02_JPRB/)
KBO( :,14, 2) = (/&
&1.7887E-02_JPRB,2.0698E-02_JPRB,2.3474E-02_JPRB,2.6314E-02_JPRB,2.9218E-02_JPRB/)
KBO( :,15, 2) = (/&
&1.5699E-02_JPRB,1.8063E-02_JPRB,2.0419E-02_JPRB,2.2807E-02_JPRB,2.5263E-02_JPRB/)
KBO( :,16, 2) = (/&
&1.3704E-02_JPRB,1.5696E-02_JPRB,1.7682E-02_JPRB,1.9683E-02_JPRB,2.1758E-02_JPRB/)
KBO( :,17, 2) = (/&
&1.2174E-02_JPRB,1.3873E-02_JPRB,1.5565E-02_JPRB,1.7279E-02_JPRB,1.9055E-02_JPRB/)
KBO( :,18, 2) = (/&
&1.1051E-02_JPRB,1.2529E-02_JPRB,1.4014E-02_JPRB,1.5532E-02_JPRB,1.7091E-02_JPRB/)
KBO( :,19, 2) = (/&
&1.0133E-02_JPRB,1.1442E-02_JPRB,1.2772E-02_JPRB,1.4145E-02_JPRB,1.5532E-02_JPRB/)
KBO( :,20, 2) = (/&
&8.9501E-03_JPRB,1.0074E-02_JPRB,1.1232E-02_JPRB,1.2420E-02_JPRB,1.3612E-02_JPRB/)
KBO( :,21, 2) = (/&
&7.8061E-03_JPRB,8.7666E-03_JPRB,9.7638E-03_JPRB,1.0776E-02_JPRB,1.1786E-02_JPRB/)
KBO( :,22, 2) = (/&
&6.7985E-03_JPRB,7.6154E-03_JPRB,8.4665E-03_JPRB,9.3161E-03_JPRB,1.0161E-02_JPRB/)
KBO( :,23, 2) = (/&
&5.9115E-03_JPRB,6.6091E-03_JPRB,7.3264E-03_JPRB,8.0410E-03_JPRB,8.7466E-03_JPRB/)
KBO( :,24, 2) = (/&
&5.1182E-03_JPRB,5.7070E-03_JPRB,6.3037E-03_JPRB,6.8969E-03_JPRB,7.4832E-03_JPRB/)
KBO( :,25, 2) = (/&
&4.4185E-03_JPRB,4.9117E-03_JPRB,5.4043E-03_JPRB,5.8933E-03_JPRB,6.3802E-03_JPRB/)
KBO( :,26, 2) = (/&
&3.8039E-03_JPRB,4.2126E-03_JPRB,4.6157E-03_JPRB,5.0191E-03_JPRB,5.4221E-03_JPRB/)
KBO( :,27, 2) = (/&
&3.2526E-03_JPRB,3.5834E-03_JPRB,3.9131E-03_JPRB,4.2430E-03_JPRB,4.5744E-03_JPRB/)
KBO( :,28, 2) = (/&
&2.7589E-03_JPRB,3.0253E-03_JPRB,3.2916E-03_JPRB,3.5602E-03_JPRB,3.8315E-03_JPRB/)
KBO( :,29, 2) = (/&
&2.3366E-03_JPRB,2.5520E-03_JPRB,2.7694E-03_JPRB,2.9896E-03_JPRB,3.2113E-03_JPRB/)
KBO( :,30, 2) = (/&
&1.9721E-03_JPRB,2.1482E-03_JPRB,2.3261E-03_JPRB,2.5062E-03_JPRB,2.6880E-03_JPRB/)
KBO( :,31, 2) = (/&
&1.6646E-03_JPRB,1.8093E-03_JPRB,1.9562E-03_JPRB,2.1055E-03_JPRB,2.2560E-03_JPRB/)
KBO( :,32, 2) = (/&
&1.4084E-03_JPRB,1.5283E-03_JPRB,1.6508E-03_JPRB,1.7751E-03_JPRB,1.9009E-03_JPRB/)
KBO( :,33, 2) = (/&
&1.1942E-03_JPRB,1.2940E-03_JPRB,1.3964E-03_JPRB,1.5007E-03_JPRB,1.6067E-03_JPRB/)
KBO( :,34, 2) = (/&
&1.0227E-03_JPRB,1.1075E-03_JPRB,1.1945E-03_JPRB,1.2830E-03_JPRB,1.3735E-03_JPRB/)
KBO( :,35, 2) = (/&
&8.7018E-04_JPRB,9.4216E-04_JPRB,1.0160E-03_JPRB,1.0916E-03_JPRB,1.1695E-03_JPRB/)
KBO( :,36, 2) = (/&
&7.3515E-04_JPRB,7.9615E-04_JPRB,8.5904E-04_JPRB,9.2392E-04_JPRB,9.9055E-04_JPRB/)
KBO( :,37, 2) = (/&
&6.0212E-04_JPRB,6.5252E-04_JPRB,7.0452E-04_JPRB,7.5835E-04_JPRB,8.1370E-04_JPRB/)
KBO( :,38, 2) = (/&
&4.9188E-04_JPRB,5.3334E-04_JPRB,5.7632E-04_JPRB,6.2087E-04_JPRB,6.6682E-04_JPRB/)
KBO( :,39, 2) = (/&
&4.0118E-04_JPRB,4.3525E-04_JPRB,4.7078E-04_JPRB,5.0765E-04_JPRB,5.4579E-04_JPRB/)
KBO( :,40, 2) = (/&
&3.1804E-04_JPRB,3.4535E-04_JPRB,3.7372E-04_JPRB,4.0332E-04_JPRB,4.3403E-04_JPRB/)
KBO( :,41, 2) = (/&
&2.5079E-04_JPRB,2.7257E-04_JPRB,2.9509E-04_JPRB,3.1873E-04_JPRB,3.4326E-04_JPRB/)
KBO( :,42, 2) = (/&
&1.9734E-04_JPRB,2.1467E-04_JPRB,2.3255E-04_JPRB,2.5134E-04_JPRB,2.7095E-04_JPRB/)
KBO( :,43, 2) = (/&
&1.5339E-04_JPRB,1.6697E-04_JPRB,1.8107E-04_JPRB,1.9578E-04_JPRB,2.1125E-04_JPRB/)
KBO( :,44, 2) = (/&
&1.1845E-04_JPRB,1.2903E-04_JPRB,1.4006E-04_JPRB,1.5150E-04_JPRB,1.6358E-04_JPRB/)
KBO( :,45, 2) = (/&
&9.1280E-05_JPRB,9.9479E-05_JPRB,1.0807E-04_JPRB,1.1698E-04_JPRB,1.2633E-04_JPRB/)
KBO( :,46, 2) = (/&
&7.0194E-05_JPRB,7.6516E-05_JPRB,8.3188E-05_JPRB,9.0126E-05_JPRB,9.7367E-05_JPRB/)
KBO( :,47, 2) = (/&
&5.3867E-05_JPRB,5.8795E-05_JPRB,6.3952E-05_JPRB,6.9343E-05_JPRB,7.4969E-05_JPRB/)
KBO( :,48, 2) = (/&
&4.1189E-05_JPRB,4.5058E-05_JPRB,4.9041E-05_JPRB,5.3206E-05_JPRB,5.7575E-05_JPRB/)
KBO( :,49, 2) = (/&
&3.1341E-05_JPRB,3.4382E-05_JPRB,3.7483E-05_JPRB,4.0694E-05_JPRB,4.4051E-05_JPRB/)
KBO( :,50, 2) = (/&
&2.4027E-05_JPRB,2.6443E-05_JPRB,2.8884E-05_JPRB,3.1394E-05_JPRB,3.3991E-05_JPRB/)
KBO( :,51, 2) = (/&
&1.8468E-05_JPRB,2.0396E-05_JPRB,2.2328E-05_JPRB,2.4296E-05_JPRB,2.6326E-05_JPRB/)
KBO( :,52, 2) = (/&
&1.4146E-05_JPRB,1.5676E-05_JPRB,1.7214E-05_JPRB,1.8760E-05_JPRB,2.0350E-05_JPRB/)
KBO( :,53, 2) = (/&
&1.0781E-05_JPRB,1.1992E-05_JPRB,1.3217E-05_JPRB,1.4439E-05_JPRB,1.5682E-05_JPRB/)
KBO( :,54, 2) = (/&
&8.3350E-06_JPRB,9.3049E-06_JPRB,1.0280E-05_JPRB,1.1258E-05_JPRB,1.2239E-05_JPRB/)
KBO( :,55, 2) = (/&
&6.4823E-06_JPRB,7.2753E-06_JPRB,8.0542E-06_JPRB,8.8375E-06_JPRB,9.6163E-06_JPRB/)
KBO( :,56, 2) = (/&
&5.0178E-06_JPRB,5.6802E-06_JPRB,6.3041E-06_JPRB,6.9292E-06_JPRB,7.5496E-06_JPRB/)
KBO( :,57, 2) = (/&
&3.8663E-06_JPRB,4.4221E-06_JPRB,4.9273E-06_JPRB,5.4254E-06_JPRB,5.9221E-06_JPRB/)
KBO( :,58, 2) = (/&
&2.9804E-06_JPRB,3.4457E-06_JPRB,3.8617E-06_JPRB,4.2609E-06_JPRB,4.6580E-06_JPRB/)
KBO( :,59, 2) = (/&
&2.4280E-06_JPRB,2.8160E-06_JPRB,3.1595E-06_JPRB,3.4836E-06_JPRB,3.8045E-06_JPRB/)
KBO( :,13, 3) = (/&
&5.2207E-02_JPRB,5.8218E-02_JPRB,6.4867E-02_JPRB,7.1854E-02_JPRB,7.9269E-02_JPRB/)
KBO( :,14, 3) = (/&
&4.5186E-02_JPRB,5.0511E-02_JPRB,5.6225E-02_JPRB,6.2140E-02_JPRB,6.8380E-02_JPRB/)
KBO( :,15, 3) = (/&
&3.9072E-02_JPRB,4.3588E-02_JPRB,4.8378E-02_JPRB,5.3369E-02_JPRB,5.8579E-02_JPRB/)
KBO( :,16, 3) = (/&
&3.3600E-02_JPRB,3.7414E-02_JPRB,4.1420E-02_JPRB,4.5603E-02_JPRB,4.9920E-02_JPRB/)
KBO( :,17, 3) = (/&
&2.9352E-02_JPRB,3.2637E-02_JPRB,3.6077E-02_JPRB,3.9644E-02_JPRB,4.3315E-02_JPRB/)
KBO( :,18, 3) = (/&
&2.6239E-02_JPRB,2.9170E-02_JPRB,3.2236E-02_JPRB,3.5401E-02_JPRB,3.8652E-02_JPRB/)
KBO( :,19, 3) = (/&
&2.3733E-02_JPRB,2.6395E-02_JPRB,2.9161E-02_JPRB,3.2005E-02_JPRB,3.4969E-02_JPRB/)
KBO( :,20, 3) = (/&
&2.0795E-02_JPRB,2.3131E-02_JPRB,2.5535E-02_JPRB,2.8011E-02_JPRB,3.0599E-02_JPRB/)
KBO( :,21, 3) = (/&
&1.8040E-02_JPRB,2.0057E-02_JPRB,2.2116E-02_JPRB,2.4262E-02_JPRB,2.6478E-02_JPRB/)
KBO( :,22, 3) = (/&
&1.5612E-02_JPRB,1.7322E-02_JPRB,1.9070E-02_JPRB,2.0895E-02_JPRB,2.2752E-02_JPRB/)
KBO( :,23, 3) = (/&
&1.3484E-02_JPRB,1.4923E-02_JPRB,1.6411E-02_JPRB,1.7947E-02_JPRB,1.9492E-02_JPRB/)
KBO( :,24, 3) = (/&
&1.1550E-02_JPRB,1.2744E-02_JPRB,1.3987E-02_JPRB,1.5260E-02_JPRB,1.6517E-02_JPRB/)
KBO( :,25, 3) = (/&
&9.8605E-03_JPRB,1.0848E-02_JPRB,1.1882E-02_JPRB,1.2919E-02_JPRB,1.3956E-02_JPRB/)
KBO( :,26, 3) = (/&
&8.3958E-03_JPRB,9.2176E-03_JPRB,1.0068E-02_JPRB,1.0918E-02_JPRB,1.1783E-02_JPRB/)
KBO( :,27, 3) = (/&
&7.0886E-03_JPRB,7.7689E-03_JPRB,8.4604E-03_JPRB,9.1621E-03_JPRB,9.8810E-03_JPRB/)
KBO( :,28, 3) = (/&
&5.9371E-03_JPRB,6.4915E-03_JPRB,7.0594E-03_JPRB,7.6411E-03_JPRB,8.2339E-03_JPRB/)
KBO( :,29, 3) = (/&
&4.9851E-03_JPRB,5.4425E-03_JPRB,5.9143E-03_JPRB,6.3959E-03_JPRB,6.8922E-03_JPRB/)
KBO( :,30, 3) = (/&
&4.1812E-03_JPRB,4.5627E-03_JPRB,4.9527E-03_JPRB,5.3553E-03_JPRB,5.7728E-03_JPRB/)
KBO( :,31, 3) = (/&
&3.5208E-03_JPRB,3.8377E-03_JPRB,4.1624E-03_JPRB,4.5005E-03_JPRB,4.8529E-03_JPRB/)
KBO( :,32, 3) = (/&
&2.9794E-03_JPRB,3.2434E-03_JPRB,3.5171E-03_JPRB,3.8033E-03_JPRB,4.1013E-03_JPRB/)
KBO( :,33, 3) = (/&
&2.5298E-03_JPRB,2.7525E-03_JPRB,2.9853E-03_JPRB,3.2295E-03_JPRB,3.4800E-03_JPRB/)
KBO( :,34, 3) = (/&
&2.1748E-03_JPRB,2.3658E-03_JPRB,2.5669E-03_JPRB,2.7771E-03_JPRB,2.9911E-03_JPRB/)
KBO( :,35, 3) = (/&
&1.8567E-03_JPRB,2.0216E-03_JPRB,2.1956E-03_JPRB,2.3760E-03_JPRB,2.5595E-03_JPRB/)
KBO( :,36, 3) = (/&
&1.5731E-03_JPRB,1.7153E-03_JPRB,1.8654E-03_JPRB,2.0205E-03_JPRB,2.1791E-03_JPRB/)
KBO( :,37, 3) = (/&
&1.2933E-03_JPRB,1.4114E-03_JPRB,1.5364E-03_JPRB,1.6658E-03_JPRB,1.7984E-03_JPRB/)
KBO( :,38, 3) = (/&
&1.0616E-03_JPRB,1.1594E-03_JPRB,1.2634E-03_JPRB,1.3712E-03_JPRB,1.4820E-03_JPRB/)
KBO( :,39, 3) = (/&
&8.7125E-04_JPRB,9.5245E-04_JPRB,1.0387E-03_JPRB,1.1287E-03_JPRB,1.2213E-03_JPRB/)
KBO( :,40, 3) = (/&
&6.9327E-04_JPRB,7.5826E-04_JPRB,8.2752E-04_JPRB,8.9995E-04_JPRB,9.7479E-04_JPRB/)
KBO( :,41, 3) = (/&
&5.4868E-04_JPRB,6.0043E-04_JPRB,6.5570E-04_JPRB,7.1362E-04_JPRB,7.7402E-04_JPRB/)
KBO( :,42, 3) = (/&
&4.3350E-04_JPRB,4.7475E-04_JPRB,5.1866E-04_JPRB,5.6496E-04_JPRB,6.1339E-04_JPRB/)
KBO( :,43, 3) = (/&
&3.3831E-04_JPRB,3.7074E-04_JPRB,4.0518E-04_JPRB,4.4169E-04_JPRB,4.7994E-04_JPRB/)
KBO( :,44, 3) = (/&
&2.6244E-04_JPRB,2.8770E-04_JPRB,3.1459E-04_JPRB,3.4301E-04_JPRB,3.7299E-04_JPRB/)
KBO( :,45, 3) = (/&
&2.0330E-04_JPRB,2.2282E-04_JPRB,2.4376E-04_JPRB,2.6587E-04_JPRB,2.8931E-04_JPRB/)
KBO( :,46, 3) = (/&
&1.5718E-04_JPRB,1.7223E-04_JPRB,1.8847E-04_JPRB,2.0565E-04_JPRB,2.2386E-04_JPRB/)
KBO( :,47, 3) = (/&
&1.2137E-04_JPRB,1.3292E-04_JPRB,1.4544E-04_JPRB,1.5881E-04_JPRB,1.7290E-04_JPRB/)
KBO( :,48, 3) = (/&
&9.3602E-05_JPRB,1.0245E-04_JPRB,1.1206E-04_JPRB,1.2242E-04_JPRB,1.3333E-04_JPRB/)
KBO( :,49, 3) = (/&
&7.2096E-05_JPRB,7.8857E-05_JPRB,8.6198E-05_JPRB,9.4146E-05_JPRB,1.0259E-04_JPRB/)
KBO( :,50, 3) = (/&
&5.5913E-05_JPRB,6.1131E-05_JPRB,6.6766E-05_JPRB,7.2901E-05_JPRB,7.9460E-05_JPRB/)
KBO( :,51, 3) = (/&
&4.3511E-05_JPRB,4.7559E-05_JPRB,5.1896E-05_JPRB,5.6624E-05_JPRB,6.1713E-05_JPRB/)
KBO( :,52, 3) = (/&
&3.3817E-05_JPRB,3.6967E-05_JPRB,4.0308E-05_JPRB,4.3936E-05_JPRB,4.7870E-05_JPRB/)
KBO( :,53, 3) = (/&
&2.6251E-05_JPRB,2.8701E-05_JPRB,3.1278E-05_JPRB,3.4055E-05_JPRB,3.7076E-05_JPRB/)
KBO( :,54, 3) = (/&
&2.0565E-05_JPRB,2.2472E-05_JPRB,2.4493E-05_JPRB,2.6647E-05_JPRB,2.8987E-05_JPRB/)
KBO( :,55, 3) = (/&
&1.6201E-05_JPRB,1.7665E-05_JPRB,1.9265E-05_JPRB,2.0950E-05_JPRB,2.2778E-05_JPRB/)
KBO( :,56, 3) = (/&
&1.2781E-05_JPRB,1.3883E-05_JPRB,1.5142E-05_JPRB,1.6468E-05_JPRB,1.7890E-05_JPRB/)
KBO( :,57, 3) = (/&
&1.0089E-05_JPRB,1.0916E-05_JPRB,1.1894E-05_JPRB,1.2940E-05_JPRB,1.4042E-05_JPRB/)
KBO( :,58, 3) = (/&
&7.9784E-06_JPRB,8.6088E-06_JPRB,9.3610E-06_JPRB,1.0185E-05_JPRB,1.1049E-05_JPRB/)
KBO( :,59, 3) = (/&
&6.4510E-06_JPRB,6.9647E-06_JPRB,7.5759E-06_JPRB,8.2439E-06_JPRB,8.9478E-06_JPRB/)
KBO( :,13, 4) = (/&
&1.1841E-01_JPRB,1.2983E-01_JPRB,1.4154E-01_JPRB,1.5381E-01_JPRB,1.6654E-01_JPRB/)
KBO( :,14, 4) = (/&
&1.0163E-01_JPRB,1.1119E-01_JPRB,1.2120E-01_JPRB,1.3164E-01_JPRB,1.4262E-01_JPRB/)
KBO( :,15, 4) = (/&
&8.7533E-02_JPRB,9.5453E-02_JPRB,1.0360E-01_JPRB,1.1225E-01_JPRB,1.2143E-01_JPRB/)
KBO( :,16, 4) = (/&
&7.4718E-02_JPRB,8.1074E-02_JPRB,8.7917E-02_JPRB,9.5269E-02_JPRB,1.0309E-01_JPRB/)
KBO( :,17, 4) = (/&
&6.4598E-02_JPRB,7.0161E-02_JPRB,7.6195E-02_JPRB,8.2691E-02_JPRB,8.9645E-02_JPRB/)
KBO( :,18, 4) = (/&
&5.7466E-02_JPRB,6.2589E-02_JPRB,6.8109E-02_JPRB,7.4052E-02_JPRB,8.0449E-02_JPRB/)
KBO( :,19, 4) = (/&
&5.1818E-02_JPRB,5.6571E-02_JPRB,6.1696E-02_JPRB,6.7232E-02_JPRB,7.3092E-02_JPRB/)
KBO( :,20, 4) = (/&
&4.5333E-02_JPRB,4.9583E-02_JPRB,5.4175E-02_JPRB,5.9119E-02_JPRB,6.4307E-02_JPRB/)
KBO( :,21, 4) = (/&
&3.9244E-02_JPRB,4.2988E-02_JPRB,4.7056E-02_JPRB,5.1390E-02_JPRB,5.5921E-02_JPRB/)
KBO( :,22, 4) = (/&
&3.3762E-02_JPRB,3.7028E-02_JPRB,4.0590E-02_JPRB,4.4367E-02_JPRB,4.8278E-02_JPRB/)
KBO( :,23, 4) = (/&
&2.8964E-02_JPRB,3.1825E-02_JPRB,3.4924E-02_JPRB,3.8192E-02_JPRB,4.1570E-02_JPRB/)
KBO( :,24, 4) = (/&
&2.4605E-02_JPRB,2.7087E-02_JPRB,2.9744E-02_JPRB,3.2528E-02_JPRB,3.5398E-02_JPRB/)
KBO( :,25, 4) = (/&
&2.0888E-02_JPRB,2.3028E-02_JPRB,2.5293E-02_JPRB,2.7664E-02_JPRB,3.0056E-02_JPRB/)
KBO( :,26, 4) = (/&
&1.7768E-02_JPRB,1.9595E-02_JPRB,2.1528E-02_JPRB,2.3523E-02_JPRB,2.5480E-02_JPRB/)
KBO( :,27, 4) = (/&
&1.5025E-02_JPRB,1.6582E-02_JPRB,1.8208E-02_JPRB,1.9851E-02_JPRB,2.1449E-02_JPRB/)
KBO( :,28, 4) = (/&
&1.2630E-02_JPRB,1.3940E-02_JPRB,1.5283E-02_JPRB,1.6619E-02_JPRB,1.7935E-02_JPRB/)
KBO( :,29, 4) = (/&
&1.0679E-02_JPRB,1.1777E-02_JPRB,1.2882E-02_JPRB,1.3981E-02_JPRB,1.5077E-02_JPRB/)
KBO( :,30, 4) = (/&
&9.0255E-03_JPRB,9.9336E-03_JPRB,1.0847E-02_JPRB,1.1760E-02_JPRB,1.2675E-02_JPRB/)
KBO( :,31, 4) = (/&
&7.6536E-03_JPRB,8.4086E-03_JPRB,9.1742E-03_JPRB,9.9429E-03_JPRB,1.0712E-02_JPRB/)
KBO( :,32, 4) = (/&
&6.5182E-03_JPRB,7.1536E-03_JPRB,7.8014E-03_JPRB,8.4515E-03_JPRB,9.1065E-03_JPRB/)
KBO( :,33, 4) = (/&
&5.5704E-03_JPRB,6.1113E-03_JPRB,6.6630E-03_JPRB,7.2151E-03_JPRB,7.7820E-03_JPRB/)
KBO( :,34, 4) = (/&
&4.8181E-03_JPRB,5.2845E-03_JPRB,5.7551E-03_JPRB,6.2347E-03_JPRB,6.7271E-03_JPRB/)
KBO( :,35, 4) = (/&
&4.1344E-03_JPRB,4.5342E-03_JPRB,4.9410E-03_JPRB,5.3600E-03_JPRB,5.7876E-03_JPRB/)
KBO( :,36, 4) = (/&
&3.5137E-03_JPRB,3.8568E-03_JPRB,4.2105E-03_JPRB,4.5744E-03_JPRB,4.9478E-03_JPRB/)
KBO( :,37, 4) = (/&
&2.9015E-03_JPRB,3.1894E-03_JPRB,3.4867E-03_JPRB,3.7928E-03_JPRB,4.1062E-03_JPRB/)
KBO( :,38, 4) = (/&
&2.3922E-03_JPRB,2.6336E-03_JPRB,2.8833E-03_JPRB,3.1403E-03_JPRB,3.4033E-03_JPRB/)
KBO( :,39, 4) = (/&
&1.9717E-03_JPRB,2.1746E-03_JPRB,2.3846E-03_JPRB,2.6005E-03_JPRB,2.8213E-03_JPRB/)
KBO( :,40, 4) = (/&
&1.5744E-03_JPRB,1.7398E-03_JPRB,1.9111E-03_JPRB,2.0874E-03_JPRB,2.2673E-03_JPRB/)
KBO( :,41, 4) = (/&
&1.2499E-03_JPRB,1.3841E-03_JPRB,1.5231E-03_JPRB,1.6664E-03_JPRB,1.8122E-03_JPRB/)
KBO( :,42, 4) = (/&
&9.9026E-04_JPRB,1.0991E-03_JPRB,1.2117E-03_JPRB,1.3281E-03_JPRB,1.4464E-03_JPRB/)
KBO( :,43, 4) = (/&
&7.7424E-04_JPRB,8.6142E-04_JPRB,9.5183E-04_JPRB,1.0452E-03_JPRB,1.1404E-03_JPRB/)
KBO( :,44, 4) = (/&
&6.0102E-04_JPRB,6.7034E-04_JPRB,7.4252E-04_JPRB,8.1707E-04_JPRB,8.9311E-04_JPRB/)
KBO( :,45, 4) = (/&
&4.6542E-04_JPRB,5.2035E-04_JPRB,5.7783E-04_JPRB,6.3732E-04_JPRB,6.9797E-04_JPRB/)
KBO( :,46, 4) = (/&
&3.5929E-04_JPRB,4.0259E-04_JPRB,4.4817E-04_JPRB,4.9561E-04_JPRB,5.4403E-04_JPRB/)
KBO( :,47, 4) = (/&
&2.7639E-04_JPRB,3.1035E-04_JPRB,3.4642E-04_JPRB,3.8415E-04_JPRB,4.2283E-04_JPRB/)
KBO( :,48, 4) = (/&
&2.1223E-04_JPRB,2.3861E-04_JPRB,2.6709E-04_JPRB,2.9688E-04_JPRB,3.2776E-04_JPRB/)
KBO( :,49, 4) = (/&
&1.6266E-04_JPRB,1.8298E-04_JPRB,2.0524E-04_JPRB,2.2871E-04_JPRB,2.5327E-04_JPRB/)
KBO( :,50, 4) = (/&
&1.2558E-04_JPRB,1.4128E-04_JPRB,1.5863E-04_JPRB,1.7722E-04_JPRB,1.9672E-04_JPRB/)
KBO( :,51, 4) = (/&
&9.7209E-05_JPRB,1.0936E-04_JPRB,1.2288E-04_JPRB,1.3753E-04_JPRB,1.5302E-04_JPRB/)
KBO( :,52, 4) = (/&
&7.5228E-05_JPRB,8.4554E-05_JPRB,9.5027E-05_JPRB,1.0648E-04_JPRB,1.1875E-04_JPRB/)
KBO( :,53, 4) = (/&
&5.8185E-05_JPRB,6.5291E-05_JPRB,7.3346E-05_JPRB,8.2261E-05_JPRB,9.1865E-05_JPRB/)
KBO( :,54, 4) = (/&
&4.5374E-05_JPRB,5.0847E-05_JPRB,5.7097E-05_JPRB,6.4058E-05_JPRB,7.1601E-05_JPRB/)
KBO( :,55, 4) = (/&
&3.5491E-05_JPRB,3.9770E-05_JPRB,4.4634E-05_JPRB,5.0070E-05_JPRB,5.6003E-05_JPRB/)
KBO( :,56, 4) = (/&
&2.7730E-05_JPRB,3.1107E-05_JPRB,3.4873E-05_JPRB,3.9105E-05_JPRB,4.3754E-05_JPRB/)
KBO( :,57, 4) = (/&
&2.1648E-05_JPRB,2.4314E-05_JPRB,2.7229E-05_JPRB,3.0516E-05_JPRB,3.4148E-05_JPRB/)
KBO( :,58, 4) = (/&
&1.6951E-05_JPRB,1.9038E-05_JPRB,2.1314E-05_JPRB,2.3872E-05_JPRB,2.6710E-05_JPRB/)
KBO( :,59, 4) = (/&
&1.3663E-05_JPRB,1.5351E-05_JPRB,1.7200E-05_JPRB,1.9273E-05_JPRB,2.1558E-05_JPRB/)
KBO( :,13, 5) = (/&
&2.7737E-01_JPRB,2.9322E-01_JPRB,3.0941E-01_JPRB,3.2627E-01_JPRB,3.4434E-01_JPRB/)
KBO( :,14, 5) = (/&
&2.3065E-01_JPRB,2.4437E-01_JPRB,2.5863E-01_JPRB,2.7404E-01_JPRB,2.9080E-01_JPRB/)
KBO( :,15, 5) = (/&
&1.9306E-01_JPRB,2.0550E-01_JPRB,2.1890E-01_JPRB,2.3329E-01_JPRB,2.4884E-01_JPRB/)
KBO( :,16, 5) = (/&
&1.6288E-01_JPRB,1.7408E-01_JPRB,1.8590E-01_JPRB,1.9857E-01_JPRB,2.1238E-01_JPRB/)
KBO( :,17, 5) = (/&
&1.4081E-01_JPRB,1.5068E-01_JPRB,1.6123E-01_JPRB,1.7280E-01_JPRB,1.8532E-01_JPRB/)
KBO( :,18, 5) = (/&
&1.2553E-01_JPRB,1.3466E-01_JPRB,1.4467E-01_JPRB,1.5557E-01_JPRB,1.6709E-01_JPRB/)
KBO( :,19, 5) = (/&
&1.1351E-01_JPRB,1.2221E-01_JPRB,1.3178E-01_JPRB,1.4202E-01_JPRB,1.5283E-01_JPRB/)
KBO( :,20, 5) = (/&
&9.9675E-02_JPRB,1.0772E-01_JPRB,1.1652E-01_JPRB,1.2577E-01_JPRB,1.3562E-01_JPRB/)
KBO( :,21, 5) = (/&
&8.6695E-02_JPRB,9.4022E-02_JPRB,1.0192E-01_JPRB,1.1025E-01_JPRB,1.1913E-01_JPRB/)
KBO( :,22, 5) = (/&
&7.4874E-02_JPRB,8.1502E-02_JPRB,8.8514E-02_JPRB,9.5955E-02_JPRB,1.0385E-01_JPRB/)
KBO( :,23, 5) = (/&
&6.4540E-02_JPRB,7.0395E-02_JPRB,7.6612E-02_JPRB,8.3224E-02_JPRB,9.0095E-02_JPRB/)
KBO( :,24, 5) = (/&
&5.4946E-02_JPRB,6.0047E-02_JPRB,6.5517E-02_JPRB,7.1296E-02_JPRB,7.7220E-02_JPRB/)
KBO( :,25, 5) = (/&
&4.6677E-02_JPRB,5.1141E-02_JPRB,5.5940E-02_JPRB,6.0917E-02_JPRB,6.6053E-02_JPRB/)
KBO( :,26, 5) = (/&
&3.9709E-02_JPRB,4.3642E-02_JPRB,4.7787E-02_JPRB,5.2078E-02_JPRB,5.6505E-02_JPRB/)
KBO( :,27, 5) = (/&
&3.3623E-02_JPRB,3.7042E-02_JPRB,4.0591E-02_JPRB,4.4263E-02_JPRB,4.8022E-02_JPRB/)
KBO( :,28, 5) = (/&
&2.8328E-02_JPRB,3.1245E-02_JPRB,3.4254E-02_JPRB,3.7363E-02_JPRB,4.0510E-02_JPRB/)
KBO( :,29, 5) = (/&
&2.4050E-02_JPRB,2.6527E-02_JPRB,2.9098E-02_JPRB,3.1727E-02_JPRB,3.4395E-02_JPRB/)
KBO( :,30, 5) = (/&
&2.0420E-02_JPRB,2.2529E-02_JPRB,2.4722E-02_JPRB,2.6950E-02_JPRB,2.9231E-02_JPRB/)
KBO( :,31, 5) = (/&
&1.7429E-02_JPRB,1.9242E-02_JPRB,2.1110E-02_JPRB,2.3032E-02_JPRB,2.5014E-02_JPRB/)
KBO( :,32, 5) = (/&
&1.4961E-02_JPRB,1.6521E-02_JPRB,1.8130E-02_JPRB,1.9805E-02_JPRB,2.1542E-02_JPRB/)
KBO( :,33, 5) = (/&
&1.2897E-02_JPRB,1.4245E-02_JPRB,1.5653E-02_JPRB,1.7131E-02_JPRB,1.8661E-02_JPRB/)
KBO( :,34, 5) = (/&
&1.1253E-02_JPRB,1.2438E-02_JPRB,1.3692E-02_JPRB,1.5008E-02_JPRB,1.6374E-02_JPRB/)
KBO( :,35, 5) = (/&
&9.7397E-03_JPRB,1.0786E-02_JPRB,1.1902E-02_JPRB,1.3073E-02_JPRB,1.4295E-02_JPRB/)
KBO( :,36, 5) = (/&
&8.3444E-03_JPRB,9.2674E-03_JPRB,1.0255E-02_JPRB,1.1299E-02_JPRB,1.2388E-02_JPRB/)
KBO( :,37, 5) = (/&
&6.9467E-03_JPRB,7.7344E-03_JPRB,8.5805E-03_JPRB,9.4769E-03_JPRB,1.0414E-02_JPRB/)
KBO( :,38, 5) = (/&
&5.7736E-03_JPRB,6.4450E-03_JPRB,7.1687E-03_JPRB,7.9368E-03_JPRB,8.7424E-03_JPRB/)
KBO( :,39, 5) = (/&
&4.7981E-03_JPRB,5.3703E-03_JPRB,5.9884E-03_JPRB,6.6480E-03_JPRB,7.3403E-03_JPRB/)
KBO( :,40, 5) = (/&
&3.8576E-03_JPRB,4.3274E-03_JPRB,4.8368E-03_JPRB,5.3827E-03_JPRB,5.9574E-03_JPRB/)
KBO( :,41, 5) = (/&
&3.0825E-03_JPRB,3.4658E-03_JPRB,3.8827E-03_JPRB,4.3318E-03_JPRB,4.8066E-03_JPRB/)
KBO( :,42, 5) = (/&
&2.4580E-03_JPRB,2.7697E-03_JPRB,3.1105E-03_JPRB,3.4793E-03_JPRB,3.8701E-03_JPRB/)
KBO( :,43, 5) = (/&
&1.9332E-03_JPRB,2.1836E-03_JPRB,2.4577E-03_JPRB,2.7557E-03_JPRB,3.0732E-03_JPRB/)
KBO( :,44, 5) = (/&
&1.5097E-03_JPRB,1.7091E-03_JPRB,1.9276E-03_JPRB,2.1661E-03_JPRB,2.4221E-03_JPRB/)
KBO( :,45, 5) = (/&
&1.1763E-03_JPRB,1.3345E-03_JPRB,1.5083E-03_JPRB,1.6985E-03_JPRB,1.9040E-03_JPRB/)
KBO( :,46, 5) = (/&
&9.1296E-04_JPRB,1.0380E-03_JPRB,1.1758E-03_JPRB,1.3270E-03_JPRB,1.4913E-03_JPRB/)
KBO( :,47, 5) = (/&
&7.0476E-04_JPRB,8.0366E-04_JPRB,9.1252E-04_JPRB,1.0324E-03_JPRB,1.1627E-03_JPRB/)
KBO( :,48, 5) = (/&
&5.4241E-04_JPRB,6.2078E-04_JPRB,7.0617E-04_JPRB,8.0101E-04_JPRB,9.0392E-04_JPRB/)
KBO( :,49, 5) = (/&
&4.1608E-04_JPRB,4.7812E-04_JPRB,5.4515E-04_JPRB,6.1960E-04_JPRB,7.0075E-04_JPRB/)
KBO( :,50, 5) = (/&
&3.2092E-04_JPRB,3.7020E-04_JPRB,4.2343E-04_JPRB,4.8196E-04_JPRB,5.4630E-04_JPRB/)
KBO( :,51, 5) = (/&
&2.4810E-04_JPRB,2.8709E-04_JPRB,3.2948E-04_JPRB,3.7570E-04_JPRB,4.2676E-04_JPRB/)
KBO( :,52, 5) = (/&
&1.9141E-04_JPRB,2.2213E-04_JPRB,2.5579E-04_JPRB,2.9244E-04_JPRB,3.3280E-04_JPRB/)
KBO( :,53, 5) = (/&
&1.4731E-04_JPRB,1.7148E-04_JPRB,1.9808E-04_JPRB,2.2719E-04_JPRB,2.5899E-04_JPRB/)
KBO( :,54, 5) = (/&
&1.1424E-04_JPRB,1.3342E-04_JPRB,1.5446E-04_JPRB,1.7772E-04_JPRB,2.0300E-04_JPRB/)
KBO( :,55, 5) = (/&
&8.8904E-05_JPRB,1.0414E-04_JPRB,1.2079E-04_JPRB,1.3937E-04_JPRB,1.5956E-04_JPRB/)
KBO( :,56, 5) = (/&
&6.9133E-05_JPRB,8.1185E-05_JPRB,9.4325E-05_JPRB,1.0911E-04_JPRB,1.2522E-04_JPRB/)
KBO( :,57, 5) = (/&
&5.3742E-05_JPRB,6.3143E-05_JPRB,7.3567E-05_JPRB,8.5265E-05_JPRB,9.8102E-05_JPRB/)
KBO( :,58, 5) = (/&
&4.1907E-05_JPRB,4.9238E-05_JPRB,5.7492E-05_JPRB,6.6736E-05_JPRB,7.6984E-05_JPRB/)
KBO( :,59, 5) = (/&
&3.3859E-05_JPRB,3.9819E-05_JPRB,4.6565E-05_JPRB,5.4107E-05_JPRB,6.2503E-05_JPRB/)
KBO( :,13, 6) = (/&
&6.4121E-01_JPRB,6.6739E-01_JPRB,6.9468E-01_JPRB,7.2265E-01_JPRB,7.5107E-01_JPRB/)
KBO( :,14, 6) = (/&
&5.3428E-01_JPRB,5.5697E-01_JPRB,5.8044E-01_JPRB,6.0466E-01_JPRB,6.2906E-01_JPRB/)
KBO( :,15, 6) = (/&
&4.4250E-01_JPRB,4.6307E-01_JPRB,4.8477E-01_JPRB,5.0676E-01_JPRB,5.2972E-01_JPRB/)
KBO( :,16, 6) = (/&
&3.7115E-01_JPRB,3.9071E-01_JPRB,4.1071E-01_JPRB,4.3131E-01_JPRB,4.5290E-01_JPRB/)
KBO( :,17, 6) = (/&
&3.2201E-01_JPRB,3.3982E-01_JPRB,3.5775E-01_JPRB,3.7619E-01_JPRB,3.9590E-01_JPRB/)
KBO( :,18, 6) = (/&
&2.8860E-01_JPRB,3.0433E-01_JPRB,3.2058E-01_JPRB,3.3778E-01_JPRB,3.5711E-01_JPRB/)
KBO( :,19, 6) = (/&
&2.6093E-01_JPRB,2.7547E-01_JPRB,2.9092E-01_JPRB,3.0787E-01_JPRB,3.2715E-01_JPRB/)
KBO( :,20, 6) = (/&
&2.2906E-01_JPRB,2.4252E-01_JPRB,2.5706E-01_JPRB,2.7353E-01_JPRB,2.9188E-01_JPRB/)
KBO( :,21, 6) = (/&
&1.9921E-01_JPRB,2.1163E-01_JPRB,2.2547E-01_JPRB,2.4100E-01_JPRB,2.5826E-01_JPRB/)
KBO( :,22, 6) = (/&
&1.7190E-01_JPRB,1.8347E-01_JPRB,1.9652E-01_JPRB,2.1104E-01_JPRB,2.2725E-01_JPRB/)
KBO( :,23, 6) = (/&
&1.4807E-01_JPRB,1.5892E-01_JPRB,1.7107E-01_JPRB,1.8464E-01_JPRB,1.9976E-01_JPRB/)
KBO( :,24, 6) = (/&
&1.2630E-01_JPRB,1.3639E-01_JPRB,1.4760E-01_JPRB,1.6015E-01_JPRB,1.7395E-01_JPRB/)
KBO( :,25, 6) = (/&
&1.0785E-01_JPRB,1.1709E-01_JPRB,1.2743E-01_JPRB,1.3890E-01_JPRB,1.5149E-01_JPRB/)
KBO( :,26, 6) = (/&
&9.2383E-02_JPRB,1.0082E-01_JPRB,1.1033E-01_JPRB,1.2082E-01_JPRB,1.3229E-01_JPRB/)
KBO( :,27, 6) = (/&
&7.8812E-02_JPRB,8.6542E-02_JPRB,9.5218E-02_JPRB,1.0477E-01_JPRB,1.1508E-01_JPRB/)
KBO( :,28, 6) = (/&
&6.6953E-02_JPRB,7.4005E-02_JPRB,8.1900E-02_JPRB,9.0499E-02_JPRB,9.9667E-02_JPRB/)
KBO( :,29, 6) = (/&
&5.7472E-02_JPRB,6.3923E-02_JPRB,7.1088E-02_JPRB,7.8810E-02_JPRB,8.6979E-02_JPRB/)
KBO( :,30, 6) = (/&
&4.9506E-02_JPRB,5.5394E-02_JPRB,6.1825E-02_JPRB,6.8714E-02_JPRB,7.5948E-02_JPRB/)
KBO( :,31, 6) = (/&
&4.3026E-02_JPRB,4.8351E-02_JPRB,5.4145E-02_JPRB,6.0281E-02_JPRB,6.6645E-02_JPRB/)
KBO( :,32, 6) = (/&
&3.7695E-02_JPRB,4.2520E-02_JPRB,4.7714E-02_JPRB,5.3158E-02_JPRB,5.8754E-02_JPRB/)
KBO( :,33, 6) = (/&
&3.3253E-02_JPRB,3.7612E-02_JPRB,4.2238E-02_JPRB,4.7058E-02_JPRB,5.2057E-02_JPRB/)
KBO( :,34, 6) = (/&
&2.9687E-02_JPRB,3.3639E-02_JPRB,3.7802E-02_JPRB,4.2143E-02_JPRB,4.6713E-02_JPRB/)
KBO( :,35, 6) = (/&
&2.6238E-02_JPRB,2.9780E-02_JPRB,3.3512E-02_JPRB,3.7433E-02_JPRB,4.1618E-02_JPRB/)
KBO( :,36, 6) = (/&
&2.2870E-02_JPRB,2.6020E-02_JPRB,2.9343E-02_JPRB,3.2882E-02_JPRB,3.6681E-02_JPRB/)
KBO( :,37, 6) = (/&
&1.9322E-02_JPRB,2.2060E-02_JPRB,2.4965E-02_JPRB,2.8086E-02_JPRB,3.1456E-02_JPRB/)
KBO( :,38, 6) = (/&
&1.6289E-02_JPRB,1.8667E-02_JPRB,2.1206E-02_JPRB,2.3953E-02_JPRB,2.6938E-02_JPRB/)
KBO( :,39, 6) = (/&
&1.3724E-02_JPRB,1.5787E-02_JPRB,1.8005E-02_JPRB,2.0421E-02_JPRB,2.3064E-02_JPRB/)
KBO( :,40, 6) = (/&
&1.1170E-02_JPRB,1.2903E-02_JPRB,1.4777E-02_JPRB,1.6832E-02_JPRB,1.9094E-02_JPRB/)
KBO( :,41, 6) = (/&
&9.0289E-03_JPRB,1.0474E-02_JPRB,1.2048E-02_JPRB,1.3783E-02_JPRB,1.5707E-02_JPRB/)
KBO( :,42, 6) = (/&
&7.2786E-03_JPRB,8.4784E-03_JPRB,9.7962E-03_JPRB,1.1257E-02_JPRB,1.2889E-02_JPRB/)
KBO( :,43, 6) = (/&
&5.7746E-03_JPRB,6.7579E-03_JPRB,7.8468E-03_JPRB,9.0602E-03_JPRB,1.0425E-02_JPRB/)
KBO( :,44, 6) = (/&
&4.5415E-03_JPRB,5.3414E-03_JPRB,6.2337E-03_JPRB,7.2326E-03_JPRB,8.3633E-03_JPRB/)
KBO( :,45, 6) = (/&
&3.5601E-03_JPRB,4.2081E-03_JPRB,4.9346E-03_JPRB,5.7558E-03_JPRB,6.6891E-03_JPRB/)
KBO( :,46, 6) = (/&
&2.7754E-03_JPRB,3.2977E-03_JPRB,3.8855E-03_JPRB,4.5569E-03_JPRB,5.3238E-03_JPRB/)
KBO( :,47, 6) = (/&
&2.1475E-03_JPRB,2.5657E-03_JPRB,3.0384E-03_JPRB,3.5836E-03_JPRB,4.2109E-03_JPRB/)
KBO( :,48, 6) = (/&
&1.6563E-03_JPRB,1.9892E-03_JPRB,2.3684E-03_JPRB,2.8081E-03_JPRB,3.3184E-03_JPRB/)
KBO( :,49, 6) = (/&
&1.2736E-03_JPRB,1.5366E-03_JPRB,1.8396E-03_JPRB,2.1918E-03_JPRB,2.6053E-03_JPRB/)
KBO( :,50, 6) = (/&
&9.8514E-04_JPRB,1.1938E-03_JPRB,1.4366E-03_JPRB,1.7199E-03_JPRB,2.0561E-03_JPRB/)
KBO( :,51, 6) = (/&
&7.6305E-04_JPRB,9.2853E-04_JPRB,1.1230E-03_JPRB,1.3507E-03_JPRB,1.6237E-03_JPRB/)
KBO( :,52, 6) = (/&
&5.8964E-04_JPRB,7.2048E-04_JPRB,8.7539E-04_JPRB,1.0577E-03_JPRB,1.2781E-03_JPRB/)
KBO( :,53, 6) = (/&
&4.5442E-04_JPRB,5.5764E-04_JPRB,6.8041E-04_JPRB,8.2614E-04_JPRB,1.0025E-03_JPRB/)
KBO( :,54, 6) = (/&
&3.5277E-04_JPRB,4.3435E-04_JPRB,5.3231E-04_JPRB,6.4901E-04_JPRB,7.9056E-04_JPRB/)
KBO( :,55, 6) = (/&
&2.7456E-04_JPRB,3.3899E-04_JPRB,4.1714E-04_JPRB,5.1074E-04_JPRB,6.2435E-04_JPRB/)
KBO( :,56, 6) = (/&
&2.1331E-04_JPRB,2.6410E-04_JPRB,3.2619E-04_JPRB,4.0097E-04_JPRB,4.9192E-04_JPRB/)
KBO( :,57, 6) = (/&
&1.6544E-04_JPRB,2.0526E-04_JPRB,2.5453E-04_JPRB,3.1404E-04_JPRB,3.8660E-04_JPRB/)
KBO( :,58, 6) = (/&
&1.2858E-04_JPRB,1.5986E-04_JPRB,1.9897E-04_JPRB,2.4635E-04_JPRB,3.0450E-04_JPRB/)
KBO( :,59, 6) = (/&
&1.0424E-04_JPRB,1.3005E-04_JPRB,1.6246E-04_JPRB,2.0168E-04_JPRB,2.5022E-04_JPRB/)
KBO( :,13, 7) = (/&
&1.5651E+00_JPRB,1.6169E+00_JPRB,1.6708E+00_JPRB,1.7263E+00_JPRB,1.7852E+00_JPRB/)
KBO( :,14, 7) = (/&
&1.3034E+00_JPRB,1.3495E+00_JPRB,1.3970E+00_JPRB,1.4470E+00_JPRB,1.4990E+00_JPRB/)
KBO( :,15, 7) = (/&
&1.0798E+00_JPRB,1.1205E+00_JPRB,1.1627E+00_JPRB,1.2066E+00_JPRB,1.2529E+00_JPRB/)
KBO( :,16, 7) = (/&
&9.0502E-01_JPRB,9.4264E-01_JPRB,9.8168E-01_JPRB,1.0232E+00_JPRB,1.0668E+00_JPRB/)
KBO( :,17, 7) = (/&
&7.8533E-01_JPRB,8.2264E-01_JPRB,8.6170E-01_JPRB,9.0297E-01_JPRB,9.4574E-01_JPRB/)
KBO( :,18, 7) = (/&
&7.0905E-01_JPRB,7.4606E-01_JPRB,7.8445E-01_JPRB,8.2385E-01_JPRB,8.6498E-01_JPRB/)
KBO( :,19, 7) = (/&
&6.5117E-01_JPRB,6.8581E-01_JPRB,7.2084E-01_JPRB,7.5738E-01_JPRB,7.9689E-01_JPRB/)
KBO( :,20, 7) = (/&
&5.8055E-01_JPRB,6.1130E-01_JPRB,6.4302E-01_JPRB,6.7746E-01_JPRB,7.1553E-01_JPRB/)
KBO( :,21, 7) = (/&
&5.1109E-01_JPRB,5.3883E-01_JPRB,5.6867E-01_JPRB,6.0178E-01_JPRB,6.3866E-01_JPRB/)
KBO( :,22, 7) = (/&
&4.4535E-01_JPRB,4.7107E-01_JPRB,4.9963E-01_JPRB,5.3173E-01_JPRB,5.6752E-01_JPRB/)
KBO( :,23, 7) = (/&
&3.8693E-01_JPRB,4.1147E-01_JPRB,4.3911E-01_JPRB,4.7015E-01_JPRB,5.0472E-01_JPRB/)
KBO( :,24, 7) = (/&
&3.3299E-01_JPRB,3.5628E-01_JPRB,3.8277E-01_JPRB,4.1248E-01_JPRB,4.4550E-01_JPRB/)
KBO( :,25, 7) = (/&
&2.8674E-01_JPRB,3.0903E-01_JPRB,3.3447E-01_JPRB,3.6286E-01_JPRB,3.9391E-01_JPRB/)
KBO( :,26, 7) = (/&
&2.4799E-01_JPRB,2.6945E-01_JPRB,2.9359E-01_JPRB,3.2034E-01_JPRB,3.4997E-01_JPRB/)
KBO( :,27, 7) = (/&
&2.1431E-01_JPRB,2.3461E-01_JPRB,2.5723E-01_JPRB,2.8249E-01_JPRB,3.1067E-01_JPRB/)
KBO( :,28, 7) = (/&
&1.8505E-01_JPRB,2.0390E-01_JPRB,2.2502E-01_JPRB,2.4887E-01_JPRB,2.7537E-01_JPRB/)
KBO( :,29, 7) = (/&
&1.6146E-01_JPRB,1.7908E-01_JPRB,1.9912E-01_JPRB,2.2167E-01_JPRB,2.4667E-01_JPRB/)
KBO( :,30, 7) = (/&
&1.4137E-01_JPRB,1.5806E-01_JPRB,1.7706E-01_JPRB,1.9835E-01_JPRB,2.2209E-01_JPRB/)
KBO( :,31, 7) = (/&
&1.2498E-01_JPRB,1.4092E-01_JPRB,1.5896E-01_JPRB,1.7927E-01_JPRB,2.0199E-01_JPRB/)
KBO( :,32, 7) = (/&
&1.1162E-01_JPRB,1.2686E-01_JPRB,1.4411E-01_JPRB,1.6362E-01_JPRB,1.8544E-01_JPRB/)
KBO( :,33, 7) = (/&
&1.0058E-01_JPRB,1.1519E-01_JPRB,1.3185E-01_JPRB,1.5062E-01_JPRB,1.7164E-01_JPRB/)
KBO( :,34, 7) = (/&
&9.1872E-02_JPRB,1.0605E-01_JPRB,1.2221E-01_JPRB,1.4049E-01_JPRB,1.6092E-01_JPRB/)
KBO( :,35, 7) = (/&
&8.3134E-02_JPRB,9.6731E-02_JPRB,1.1227E-01_JPRB,1.2986E-01_JPRB,1.4952E-01_JPRB/)
KBO( :,36, 7) = (/&
&7.4081E-02_JPRB,8.6894E-02_JPRB,1.0163E-01_JPRB,1.1830E-01_JPRB,1.3703E-01_JPRB/)
KBO( :,37, 7) = (/&
&6.4153E-02_JPRB,7.5901E-02_JPRB,8.9515E-02_JPRB,1.0499E-01_JPRB,1.2245E-01_JPRB/)
KBO( :,38, 7) = (/&
&5.5459E-02_JPRB,6.6199E-02_JPRB,7.8762E-02_JPRB,9.3144E-02_JPRB,1.0945E-01_JPRB/)
KBO( :,39, 7) = (/&
&4.7923E-02_JPRB,5.7730E-02_JPRB,6.9328E-02_JPRB,8.2715E-02_JPRB,9.7968E-02_JPRB/)
KBO( :,40, 7) = (/&
&3.9991E-02_JPRB,4.8626E-02_JPRB,5.8962E-02_JPRB,7.1033E-02_JPRB,8.4866E-02_JPRB/)
KBO( :,41, 7) = (/&
&3.3132E-02_JPRB,4.0668E-02_JPRB,4.9786E-02_JPRB,6.0601E-02_JPRB,7.3110E-02_JPRB/)
KBO( :,42, 7) = (/&
&2.7362E-02_JPRB,3.3907E-02_JPRB,4.1915E-02_JPRB,5.1544E-02_JPRB,6.2838E-02_JPRB/)
KBO( :,43, 7) = (/&
&2.2196E-02_JPRB,2.7768E-02_JPRB,3.4671E-02_JPRB,4.3090E-02_JPRB,5.3119E-02_JPRB/)
KBO( :,44, 7) = (/&
&1.7818E-02_JPRB,2.2501E-02_JPRB,2.8380E-02_JPRB,3.5655E-02_JPRB,4.4455E-02_JPRB/)
KBO( :,45, 7) = (/&
&1.4243E-02_JPRB,1.8150E-02_JPRB,2.3128E-02_JPRB,2.9377E-02_JPRB,3.7045E-02_JPRB/)
KBO( :,46, 7) = (/&
&1.1286E-02_JPRB,1.4511E-02_JPRB,1.8685E-02_JPRB,2.4000E-02_JPRB,3.0616E-02_JPRB/)
KBO( :,47, 7) = (/&
&8.8305E-03_JPRB,1.1453E-02_JPRB,1.4902E-02_JPRB,1.9356E-02_JPRB,2.5001E-02_JPRB/)
KBO( :,48, 7) = (/&
&6.8710E-03_JPRB,8.9888E-03_JPRB,1.1814E-02_JPRB,1.5517E-02_JPRB,2.0294E-02_JPRB/)
KBO( :,49, 7) = (/&
&5.3150E-03_JPRB,7.0121E-03_JPRB,9.3059E-03_JPRB,1.2357E-02_JPRB,1.6365E-02_JPRB/)
KBO( :,50, 7) = (/&
&4.1309E-03_JPRB,5.4944E-03_JPRB,7.3653E-03_JPRB,9.8877E-03_JPRB,1.3254E-02_JPRB/)
KBO( :,51, 7) = (/&
&3.2122E-03_JPRB,4.3028E-03_JPRB,5.8246E-03_JPRB,7.9072E-03_JPRB,1.0730E-02_JPRB/)
KBO( :,52, 7) = (/&
&2.4855E-03_JPRB,3.3518E-03_JPRB,4.5791E-03_JPRB,6.2870E-03_JPRB,8.6345E-03_JPRB/)
KBO( :,53, 7) = (/&
&1.9144E-03_JPRB,2.5958E-03_JPRB,3.5772E-03_JPRB,4.9679E-03_JPRB,6.9029E-03_JPRB/)
KBO( :,54, 7) = (/&
&1.4846E-03_JPRB,2.0243E-03_JPRB,2.8131E-03_JPRB,3.9506E-03_JPRB,5.5585E-03_JPRB/)
KBO( :,55, 7) = (/&
&1.1531E-03_JPRB,1.5804E-03_JPRB,2.2143E-03_JPRB,3.1436E-03_JPRB,4.4799E-03_JPRB/)
KBO( :,56, 7) = (/&
&8.9241E-04_JPRB,1.2296E-03_JPRB,1.7344E-03_JPRB,2.4879E-03_JPRB,3.5892E-03_JPRB/)
KBO( :,57, 7) = (/&
&6.8839E-04_JPRB,9.5206E-04_JPRB,1.3509E-03_JPRB,1.9572E-03_JPRB,2.8575E-03_JPRB/)
KBO( :,58, 7) = (/&
&5.3236E-04_JPRB,7.3837E-04_JPRB,1.0535E-03_JPRB,1.5406E-03_JPRB,2.2793E-03_JPRB/)
KBO( :,59, 7) = (/&
&4.3598E-04_JPRB,6.1022E-04_JPRB,8.8068E-04_JPRB,1.3033E-03_JPRB,1.9553E-03_JPRB/)
KBO( :,13, 8) = (/&
&4.7769E+00_JPRB,4.8848E+00_JPRB,4.9874E+00_JPRB,5.0917E+00_JPRB,5.1968E+00_JPRB/)
KBO( :,14, 8) = (/&
&4.0252E+00_JPRB,4.1225E+00_JPRB,4.2203E+00_JPRB,4.3172E+00_JPRB,4.4173E+00_JPRB/)
KBO( :,15, 8) = (/&
&3.3636E+00_JPRB,3.4557E+00_JPRB,3.5447E+00_JPRB,3.6379E+00_JPRB,3.7313E+00_JPRB/)
KBO( :,16, 8) = (/&
&2.8215E+00_JPRB,2.9045E+00_JPRB,2.9912E+00_JPRB,3.0777E+00_JPRB,3.1703E+00_JPRB/)
KBO( :,17, 8) = (/&
&2.4207E+00_JPRB,2.5043E+00_JPRB,2.5895E+00_JPRB,2.6793E+00_JPRB,2.7738E+00_JPRB/)
KBO( :,18, 8) = (/&
&2.1596E+00_JPRB,2.2496E+00_JPRB,2.3425E+00_JPRB,2.4404E+00_JPRB,2.5399E+00_JPRB/)
KBO( :,19, 8) = (/&
&1.9873E+00_JPRB,2.0853E+00_JPRB,2.1866E+00_JPRB,2.2891E+00_JPRB,2.3905E+00_JPRB/)
KBO( :,20, 8) = (/&
&1.8046E+00_JPRB,1.9022E+00_JPRB,2.0007E+00_JPRB,2.0973E+00_JPRB,2.1932E+00_JPRB/)
KBO( :,21, 8) = (/&
&1.6245E+00_JPRB,1.7151E+00_JPRB,1.8038E+00_JPRB,1.8907E+00_JPRB,1.9795E+00_JPRB/)
KBO( :,22, 8) = (/&
&1.4461E+00_JPRB,1.5258E+00_JPRB,1.6036E+00_JPRB,1.6835E+00_JPRB,1.7677E+00_JPRB/)
KBO( :,23, 8) = (/&
&1.2784E+00_JPRB,1.3484E+00_JPRB,1.4202E+00_JPRB,1.4958E+00_JPRB,1.5781E+00_JPRB/)
KBO( :,24, 8) = (/&
&1.1162E+00_JPRB,1.1799E+00_JPRB,1.2469E+00_JPRB,1.3197E+00_JPRB,1.4014E+00_JPRB/)
KBO( :,25, 8) = (/&
&9.7290E-01_JPRB,1.0323E+00_JPRB,1.0964E+00_JPRB,1.1683E+00_JPRB,1.2507E+00_JPRB/)
KBO( :,26, 8) = (/&
&8.5083E-01_JPRB,9.0746E-01_JPRB,9.7028E-01_JPRB,1.0426E+00_JPRB,1.1250E+00_JPRB/)
KBO( :,27, 8) = (/&
&7.4331E-01_JPRB,7.9805E-01_JPRB,8.6066E-01_JPRB,9.3282E-01_JPRB,1.0150E+00_JPRB/)
KBO( :,28, 8) = (/&
&6.4875E-01_JPRB,7.0258E-01_JPRB,7.6476E-01_JPRB,8.3624E-01_JPRB,9.1880E-01_JPRB/)
KBO( :,29, 8) = (/&
&5.7353E-01_JPRB,6.2704E-01_JPRB,6.8898E-01_JPRB,7.6115E-01_JPRB,8.4456E-01_JPRB/)
KBO( :,30, 8) = (/&
&5.1081E-01_JPRB,5.6430E-01_JPRB,6.2672E-01_JPRB,6.9960E-01_JPRB,7.8366E-01_JPRB/)
KBO( :,31, 8) = (/&
&4.6060E-01_JPRB,5.1474E-01_JPRB,5.7850E-01_JPRB,6.5276E-01_JPRB,7.3784E-01_JPRB/)
KBO( :,32, 8) = (/&
&4.2054E-01_JPRB,4.7584E-01_JPRB,5.4138E-01_JPRB,6.1744E-01_JPRB,7.0416E-01_JPRB/)
KBO( :,33, 8) = (/&
&3.8881E-01_JPRB,4.4574E-01_JPRB,5.1326E-01_JPRB,5.9158E-01_JPRB,6.8101E-01_JPRB/)
KBO( :,34, 8) = (/&
&3.6582E-01_JPRB,4.2446E-01_JPRB,4.9413E-01_JPRB,5.7504E-01_JPRB,6.6797E-01_JPRB/)
KBO( :,35, 8) = (/&
&3.4211E-01_JPRB,4.0158E-01_JPRB,4.7243E-01_JPRB,5.5519E-01_JPRB,6.5095E-01_JPRB/)
KBO( :,36, 8) = (/&
&3.1584E-01_JPRB,3.7515E-01_JPRB,4.4596E-01_JPRB,5.2948E-01_JPRB,6.2662E-01_JPRB/)
KBO( :,37, 8) = (/&
&2.8335E-01_JPRB,3.4000E-01_JPRB,4.0808E-01_JPRB,4.8925E-01_JPRB,5.8433E-01_JPRB/)
KBO( :,38, 8) = (/&
&2.5439E-01_JPRB,3.0837E-01_JPRB,3.7382E-01_JPRB,4.5256E-01_JPRB,5.4554E-01_JPRB/)
KBO( :,39, 8) = (/&
&2.2884E-01_JPRB,2.8037E-01_JPRB,3.4336E-01_JPRB,4.1988E-01_JPRB,5.1084E-01_JPRB/)
KBO( :,40, 8) = (/&
&1.9894E-01_JPRB,2.4621E-01_JPRB,3.0460E-01_JPRB,3.7622E-01_JPRB,4.6217E-01_JPRB/)
KBO( :,41, 8) = (/&
&1.7202E-01_JPRB,2.1505E-01_JPRB,2.6889E-01_JPRB,3.3546E-01_JPRB,4.1631E-01_JPRB/)
KBO( :,42, 8) = (/&
&1.4851E-01_JPRB,1.8770E-01_JPRB,2.3715E-01_JPRB,2.9895E-01_JPRB,3.7473E-01_JPRB/)
KBO( :,43, 8) = (/&
&1.2600E-01_JPRB,1.6095E-01_JPRB,2.0554E-01_JPRB,2.6188E-01_JPRB,3.3169E-01_JPRB/)
KBO( :,44, 8) = (/&
&1.0584E-01_JPRB,1.3667E-01_JPRB,1.7652E-01_JPRB,2.2729E-01_JPRB,2.9097E-01_JPRB/)
KBO( :,45, 8) = (/&
&8.8493E-02_JPRB,1.1567E-01_JPRB,1.5110E-01_JPRB,1.9672E-01_JPRB,2.5462E-01_JPRB/)
KBO( :,46, 8) = (/&
&7.3233E-02_JPRB,9.7022E-02_JPRB,1.2827E-01_JPRB,1.6892E-01_JPRB,2.2114E-01_JPRB/)
KBO( :,47, 8) = (/&
&5.9636E-02_JPRB,8.0163E-02_JPRB,1.0738E-01_JPRB,1.4314E-01_JPRB,1.8961E-01_JPRB/)
KBO( :,48, 8) = (/&
&4.8167E-02_JPRB,6.5765E-02_JPRB,8.9346E-02_JPRB,1.2067E-01_JPRB,1.6184E-01_JPRB/)
KBO( :,49, 8) = (/&
&3.8566E-02_JPRB,5.3500E-02_JPRB,7.3805E-02_JPRB,1.0114E-01_JPRB,1.3740E-01_JPRB/)
KBO( :,50, 8) = (/&
&3.0986E-02_JPRB,4.3657E-02_JPRB,6.1235E-02_JPRB,8.5187E-02_JPRB,1.1732E-01_JPRB/)
KBO( :,51, 8) = (/&
&2.4855E-02_JPRB,3.5538E-02_JPRB,5.0728E-02_JPRB,7.1690E-02_JPRB,1.0021E-01_JPRB/)
KBO( :,52, 8) = (/&
&1.9770E-02_JPRB,2.8704E-02_JPRB,4.1703E-02_JPRB,5.9943E-02_JPRB,8.5157E-02_JPRB/)
KBO( :,53, 8) = (/&
&1.5594E-02_JPRB,2.2973E-02_JPRB,3.3967E-02_JPRB,4.9762E-02_JPRB,7.1853E-02_JPRB/)
KBO( :,54, 8) = (/&
&1.2395E-02_JPRB,1.8523E-02_JPRB,2.7877E-02_JPRB,4.1630E-02_JPRB,6.1144E-02_JPRB/)
KBO( :,55, 8) = (/&
&9.8575E-03_JPRB,1.4938E-02_JPRB,2.2890E-02_JPRB,3.4846E-02_JPRB,5.2121E-02_JPRB/)
KBO( :,56, 8) = (/&
&7.7929E-03_JPRB,1.1970E-02_JPRB,1.8661E-02_JPRB,2.8954E-02_JPRB,4.4168E-02_JPRB/)
KBO( :,57, 8) = (/&
&6.1195E-03_JPRB,9.5111E-03_JPRB,1.5088E-02_JPRB,2.3882E-02_JPRB,3.7179E-02_JPRB/)
KBO( :,58, 8) = (/&
&4.8102E-03_JPRB,7.5604E-03_JPRB,1.2200E-02_JPRB,1.9713E-02_JPRB,3.1334E-02_JPRB/)
KBO( :,59, 8) = (/&
&4.0994E-03_JPRB,6.5648E-03_JPRB,1.0813E-02_JPRB,1.7794E-02_JPRB,2.8755E-02_JPRB/)
KBO( :,13, 9) = (/&
&2.2033E+01_JPRB,2.2174E+01_JPRB,2.2343E+01_JPRB,2.2507E+01_JPRB,2.2688E+01_JPRB/)
KBO( :,14, 9) = (/&
&1.9641E+01_JPRB,1.9826E+01_JPRB,1.9998E+01_JPRB,2.0195E+01_JPRB,2.0429E+01_JPRB/)
KBO( :,15, 9) = (/&
&1.7181E+01_JPRB,1.7367E+01_JPRB,1.7589E+01_JPRB,1.7835E+01_JPRB,1.8095E+01_JPRB/)
KBO( :,16, 9) = (/&
&1.4894E+01_JPRB,1.5133E+01_JPRB,1.5386E+01_JPRB,1.5657E+01_JPRB,1.5957E+01_JPRB/)
KBO( :,17, 9) = (/&
&1.3089E+01_JPRB,1.3342E+01_JPRB,1.3618E+01_JPRB,1.3934E+01_JPRB,1.4266E+01_JPRB/)
KBO( :,18, 9) = (/&
&1.1731E+01_JPRB,1.2006E+01_JPRB,1.2330E+01_JPRB,1.2671E+01_JPRB,1.3025E+01_JPRB/)
KBO( :,19, 9) = (/&
&1.0583E+01_JPRB,1.0906E+01_JPRB,1.1254E+01_JPRB,1.1621E+01_JPRB,1.2024E+01_JPRB/)
KBO( :,20, 9) = (/&
&9.4570E+00_JPRB,9.7937E+00_JPRB,1.0152E+01_JPRB,1.0555E+01_JPRB,1.0995E+01_JPRB/)
KBO( :,21, 9) = (/&
&8.4559E+00_JPRB,8.8026E+00_JPRB,9.1952E+00_JPRB,9.6304E+00_JPRB,1.0095E+01_JPRB/)
KBO( :,22, 9) = (/&
&7.5782E+00_JPRB,7.9554E+00_JPRB,8.3755E+00_JPRB,8.8282E+00_JPRB,9.3139E+00_JPRB/)
KBO( :,23, 9) = (/&
&6.8684E+00_JPRB,7.2684E+00_JPRB,7.7047E+00_JPRB,8.1736E+00_JPRB,8.6781E+00_JPRB/)
KBO( :,24, 9) = (/&
&6.2497E+00_JPRB,6.6572E+00_JPRB,7.0979E+00_JPRB,7.5746E+00_JPRB,8.0821E+00_JPRB/)
KBO( :,25, 9) = (/&
&5.7300E+00_JPRB,6.1337E+00_JPRB,6.5736E+00_JPRB,7.0462E+00_JPRB,7.5518E+00_JPRB/)
KBO( :,26, 9) = (/&
&5.2905E+00_JPRB,5.6892E+00_JPRB,6.1183E+00_JPRB,6.5857E+00_JPRB,7.0904E+00_JPRB/)
KBO( :,27, 9) = (/&
&4.8852E+00_JPRB,5.2716E+00_JPRB,5.6895E+00_JPRB,6.1477E+00_JPRB,6.6506E+00_JPRB/)
KBO( :,28, 9) = (/&
&4.4993E+00_JPRB,4.8815E+00_JPRB,5.2912E+00_JPRB,5.7427E+00_JPRB,6.2498E+00_JPRB/)
KBO( :,29, 9) = (/&
&4.1817E+00_JPRB,4.5681E+00_JPRB,4.9858E+00_JPRB,5.4440E+00_JPRB,5.9661E+00_JPRB/)
KBO( :,30, 9) = (/&
&3.9159E+00_JPRB,4.3103E+00_JPRB,4.7415E+00_JPRB,5.2227E+00_JPRB,5.7617E+00_JPRB/)
KBO( :,31, 9) = (/&
&3.7169E+00_JPRB,4.1255E+00_JPRB,4.5793E+00_JPRB,5.0892E+00_JPRB,5.6531E+00_JPRB/)
KBO( :,32, 9) = (/&
&3.5834E+00_JPRB,4.0122E+00_JPRB,4.4950E+00_JPRB,5.0349E+00_JPRB,5.6294E+00_JPRB/)
KBO( :,33, 9) = (/&
&3.5101E+00_JPRB,3.9652E+00_JPRB,4.4790E+00_JPRB,5.0498E+00_JPRB,5.6789E+00_JPRB/)
KBO( :,34, 9) = (/&
&3.5050E+00_JPRB,3.9930E+00_JPRB,4.5402E+00_JPRB,5.1475E+00_JPRB,5.8191E+00_JPRB/)
KBO( :,35, 9) = (/&
&3.4979E+00_JPRB,4.0137E+00_JPRB,4.5890E+00_JPRB,5.2289E+00_JPRB,5.9375E+00_JPRB/)
KBO( :,36, 9) = (/&
&3.4706E+00_JPRB,4.0059E+00_JPRB,4.6026E+00_JPRB,5.2687E+00_JPRB,6.0062E+00_JPRB/)
KBO( :,37, 9) = (/&
&3.3275E+00_JPRB,3.8631E+00_JPRB,4.4602E+00_JPRB,5.1262E+00_JPRB,5.8660E+00_JPRB/)
KBO( :,38, 9) = (/&
&3.1941E+00_JPRB,3.7291E+00_JPRB,4.3242E+00_JPRB,4.9885E+00_JPRB,5.7266E+00_JPRB/)
KBO( :,39, 9) = (/&
&3.0740E+00_JPRB,3.6084E+00_JPRB,4.2006E+00_JPRB,4.8620E+00_JPRB,5.5962E+00_JPRB/)
KBO( :,40, 9) = (/&
&2.8552E+00_JPRB,3.3739E+00_JPRB,3.9447E+00_JPRB,4.5808E+00_JPRB,5.2902E+00_JPRB/)
KBO( :,41, 9) = (/&
&2.6380E+00_JPRB,3.1381E+00_JPRB,3.6872E+00_JPRB,4.2961E+00_JPRB,4.9750E+00_JPRB/)
KBO( :,42, 9) = (/&
&2.4342E+00_JPRB,2.9148E+00_JPRB,3.4437E+00_JPRB,4.0255E+00_JPRB,4.6737E+00_JPRB/)
KBO( :,43, 9) = (/&
&2.2073E+00_JPRB,2.6629E+00_JPRB,3.1662E+00_JPRB,3.7162E+00_JPRB,4.3269E+00_JPRB/)
KBO( :,44, 9) = (/&
&1.9815E+00_JPRB,2.4093E+00_JPRB,2.8849E+00_JPRB,3.4033E+00_JPRB,3.9755E+00_JPRB/)
KBO( :,45, 9) = (/&
&1.7719E+00_JPRB,2.1718E+00_JPRB,2.6189E+00_JPRB,3.1075E+00_JPRB,3.6437E+00_JPRB/)
KBO( :,46, 9) = (/&
&1.5723E+00_JPRB,1.9443E+00_JPRB,2.3619E+00_JPRB,2.8217E+00_JPRB,3.3236E+00_JPRB/)
KBO( :,47, 9) = (/&
&1.3802E+00_JPRB,1.7245E+00_JPRB,2.1129E+00_JPRB,2.5440E+00_JPRB,3.0139E+00_JPRB/)
KBO( :,48, 9) = (/&
&1.2042E+00_JPRB,1.5204E+00_JPRB,1.8800E+00_JPRB,2.2805E+00_JPRB,2.7207E+00_JPRB/)
KBO( :,49, 9) = (/&
&1.0431E+00_JPRB,1.3311E+00_JPRB,1.6618E+00_JPRB,2.0323E+00_JPRB,2.4425E+00_JPRB/)
KBO( :,50, 9) = (/&
&9.1020E-01_JPRB,1.1754E+00_JPRB,1.4811E+00_JPRB,1.8261E+00_JPRB,2.2093E+00_JPRB/)
KBO( :,51, 9) = (/&
&7.9478E-01_JPRB,1.0402E+00_JPRB,1.3230E+00_JPRB,1.6448E+00_JPRB,2.0037E+00_JPRB/)
KBO( :,52, 9) = (/&
&6.8856E-01_JPRB,9.1521E-01_JPRB,1.1763E+00_JPRB,1.4752E+00_JPRB,1.8102E+00_JPRB/)
KBO( :,53, 9) = (/&
&5.9135E-01_JPRB,7.9906E-01_JPRB,1.0400E+00_JPRB,1.3162E+00_JPRB,1.6282E+00_JPRB/)
KBO( :,54, 9) = (/&
&5.1488E-01_JPRB,7.0709E-01_JPRB,9.3257E-01_JPRB,1.1913E+00_JPRB,1.4845E+00_JPRB/)
KBO( :,55, 9) = (/&
&4.5023E-01_JPRB,6.2878E-01_JPRB,8.4073E-01_JPRB,1.0847E+00_JPRB,1.3619E+00_JPRB/)
KBO( :,56, 9) = (/&
&3.9100E-01_JPRB,5.5634E-01_JPRB,7.5480E-01_JPRB,9.8459E-01_JPRB,1.2461E+00_JPRB/)
KBO( :,57, 9) = (/&
&3.3683E-01_JPRB,4.8921E-01_JPRB,6.7380E-01_JPRB,8.9005E-01_JPRB,1.1368E+00_JPRB/)
KBO( :,58, 9) = (/&
&2.9052E-01_JPRB,4.3080E-01_JPRB,6.0283E-01_JPRB,8.0653E-01_JPRB,1.0401E+00_JPRB/)
KBO( :,59, 9) = (/&
&2.7497E-01_JPRB,4.1213E-01_JPRB,5.8166E-01_JPRB,7.8275E-01_JPRB,1.0139E+00_JPRB/)
KBO( :,13,10) = (/&
&6.2443E+01_JPRB,6.2764E+01_JPRB,6.3247E+01_JPRB,6.3715E+01_JPRB,6.4108E+01_JPRB/)
KBO( :,14,10) = (/&
&5.9985E+01_JPRB,6.0474E+01_JPRB,6.1209E+01_JPRB,6.1839E+01_JPRB,6.2132E+01_JPRB/)
KBO( :,15,10) = (/&
&5.6302E+01_JPRB,5.7213E+01_JPRB,5.7905E+01_JPRB,5.8328E+01_JPRB,5.8930E+01_JPRB/)
KBO( :,16,10) = (/&
&5.2360E+01_JPRB,5.3074E+01_JPRB,5.3755E+01_JPRB,5.4642E+01_JPRB,5.5349E+01_JPRB/)
KBO( :,17,10) = (/&
&4.8557E+01_JPRB,4.9472E+01_JPRB,5.0546E+01_JPRB,5.1358E+01_JPRB,5.2195E+01_JPRB/)
KBO( :,18,10) = (/&
&4.5817E+01_JPRB,4.7034E+01_JPRB,4.8009E+01_JPRB,4.9111E+01_JPRB,5.0457E+01_JPRB/)
KBO( :,19,10) = (/&
&4.3325E+01_JPRB,4.4456E+01_JPRB,4.5754E+01_JPRB,4.7330E+01_JPRB,4.8976E+01_JPRB/)
KBO( :,20,10) = (/&
&3.9745E+01_JPRB,4.1127E+01_JPRB,4.2837E+01_JPRB,4.4567E+01_JPRB,4.6284E+01_JPRB/)
KBO( :,21,10) = (/&
&3.6127E+01_JPRB,3.7823E+01_JPRB,3.9580E+01_JPRB,4.1335E+01_JPRB,4.3236E+01_JPRB/)
KBO( :,22,10) = (/&
&3.2661E+01_JPRB,3.4362E+01_JPRB,3.6109E+01_JPRB,3.8022E+01_JPRB,4.0162E+01_JPRB/)
KBO( :,23,10) = (/&
&2.9316E+01_JPRB,3.1011E+01_JPRB,3.2886E+01_JPRB,3.5036E+01_JPRB,3.7336E+01_JPRB/)
KBO( :,24,10) = (/&
&2.6133E+01_JPRB,2.7977E+01_JPRB,3.0126E+01_JPRB,3.2424E+01_JPRB,3.4907E+01_JPRB/)
KBO( :,25,10) = (/&
&2.3786E+01_JPRB,2.5903E+01_JPRB,2.8212E+01_JPRB,3.0718E+01_JPRB,3.3428E+01_JPRB/)
KBO( :,26,10) = (/&
&2.2187E+01_JPRB,2.4436E+01_JPRB,2.6979E+01_JPRB,2.9726E+01_JPRB,3.2775E+01_JPRB/)
KBO( :,27,10) = (/&
&2.0867E+01_JPRB,2.3290E+01_JPRB,2.6025E+01_JPRB,2.9060E+01_JPRB,3.2420E+01_JPRB/)
KBO( :,28,10) = (/&
&1.9963E+01_JPRB,2.2440E+01_JPRB,2.5348E+01_JPRB,2.8653E+01_JPRB,3.2222E+01_JPRB/)
KBO( :,29,10) = (/&
&1.9439E+01_JPRB,2.1951E+01_JPRB,2.4945E+01_JPRB,2.8411E+01_JPRB,3.2065E+01_JPRB/)
KBO( :,30,10) = (/&
&1.9217E+01_JPRB,2.1773E+01_JPRB,2.4822E+01_JPRB,2.8258E+01_JPRB,3.1954E+01_JPRB/)
KBO( :,31,10) = (/&
&1.9236E+01_JPRB,2.1821E+01_JPRB,2.4835E+01_JPRB,2.8172E+01_JPRB,3.1859E+01_JPRB/)
KBO( :,32,10) = (/&
&1.9497E+01_JPRB,2.2156E+01_JPRB,2.5072E+01_JPRB,2.8334E+01_JPRB,3.2036E+01_JPRB/)
KBO( :,33,10) = (/&
&1.9927E+01_JPRB,2.2649E+01_JPRB,2.5483E+01_JPRB,2.8731E+01_JPRB,3.2414E+01_JPRB/)
KBO( :,34,10) = (/&
&2.0616E+01_JPRB,2.3435E+01_JPRB,2.6339E+01_JPRB,2.9629E+01_JPRB,3.3264E+01_JPRB/)
KBO( :,35,10) = (/&
&2.1144E+01_JPRB,2.4078E+01_JPRB,2.7155E+01_JPRB,3.0411E+01_JPRB,3.3926E+01_JPRB/)
KBO( :,36,10) = (/&
&2.1438E+01_JPRB,2.4511E+01_JPRB,2.7776E+01_JPRB,3.1069E+01_JPRB,3.4391E+01_JPRB/)
KBO( :,37,10) = (/&
&2.0912E+01_JPRB,2.3999E+01_JPRB,2.7304E+01_JPRB,3.0662E+01_JPRB,3.3903E+01_JPRB/)
KBO( :,38,10) = (/&
&2.0345E+01_JPRB,2.3428E+01_JPRB,2.6766E+01_JPRB,3.0163E+01_JPRB,3.3445E+01_JPRB/)
KBO( :,39,10) = (/&
&1.9778E+01_JPRB,2.2831E+01_JPRB,2.6185E+01_JPRB,2.9606E+01_JPRB,3.2946E+01_JPRB/)
KBO( :,40,10) = (/&
&1.8680E+01_JPRB,2.1589E+01_JPRB,2.4845E+01_JPRB,2.8243E+01_JPRB,3.1561E+01_JPRB/)
KBO( :,41,10) = (/&
&1.7550E+01_JPRB,2.0318E+01_JPRB,2.3431E+01_JPRB,2.6770E+01_JPRB,3.0077E+01_JPRB/)
KBO( :,42,10) = (/&
&1.6473E+01_JPRB,1.9098E+01_JPRB,2.2042E+01_JPRB,2.5289E+01_JPRB,2.8560E+01_JPRB/)
KBO( :,43,10) = (/&
&1.5257E+01_JPRB,1.7707E+01_JPRB,2.0444E+01_JPRB,2.3540E+01_JPRB,2.6749E+01_JPRB/)
KBO( :,44,10) = (/&
&1.4023E+01_JPRB,1.6313E+01_JPRB,1.8839E+01_JPRB,2.1729E+01_JPRB,2.4856E+01_JPRB/)
KBO( :,45,10) = (/&
&1.2858E+01_JPRB,1.5005E+01_JPRB,1.7331E+01_JPRB,2.0013E+01_JPRB,2.3009E+01_JPRB/)
KBO( :,46,10) = (/&
&1.1732E+01_JPRB,1.3762E+01_JPRB,1.5932E+01_JPRB,1.8398E+01_JPRB,2.1229E+01_JPRB/)
KBO( :,47,10) = (/&
&1.0637E+01_JPRB,1.2563E+01_JPRB,1.4611E+01_JPRB,1.6882E+01_JPRB,1.9522E+01_JPRB/)
KBO( :,48,10) = (/&
&9.5989E+00_JPRB,1.1430E+01_JPRB,1.3382E+01_JPRB,1.5508E+01_JPRB,1.7946E+01_JPRB/)
KBO( :,49,10) = (/&
&8.6105E+00_JPRB,1.0367E+01_JPRB,1.2235E+01_JPRB,1.4247E+01_JPRB,1.6502E+01_JPRB/)
KBO( :,50,10) = (/&
&7.7795E+00_JPRB,9.4717E+00_JPRB,1.1267E+01_JPRB,1.3203E+01_JPRB,1.5335E+01_JPRB/)
KBO( :,51,10) = (/&
&7.0327E+00_JPRB,8.6531E+00_JPRB,1.0392E+01_JPRB,1.2262E+01_JPRB,1.4298E+01_JPRB/)
KBO( :,52,10) = (/&
&6.3294E+00_JPRB,7.8785E+00_JPRB,9.5601E+00_JPRB,1.1364E+01_JPRB,1.3321E+01_JPRB/)
KBO( :,53,10) = (/&
&5.6735E+00_JPRB,7.1473E+00_JPRB,8.7577E+00_JPRB,1.0501E+01_JPRB,1.2384E+01_JPRB/)
KBO( :,54,10) = (/&
&5.1171E+00_JPRB,6.5109E+00_JPRB,8.0578E+00_JPRB,9.7452E+00_JPRB,1.1565E+01_JPRB/)
KBO( :,55,10) = (/&
&4.6203E+00_JPRB,5.9356E+00_JPRB,7.4153E+00_JPRB,9.0377E+00_JPRB,1.0796E+01_JPRB/)
KBO( :,56,10) = (/&
&4.1502E+00_JPRB,5.3934E+00_JPRB,6.7922E+00_JPRB,8.3512E+00_JPRB,1.0055E+01_JPRB/)
KBO( :,57,10) = (/&
&3.7055E+00_JPRB,4.8827E+00_JPRB,6.2007E+00_JPRB,7.6928E+00_JPRB,9.3383E+00_JPRB/)
KBO( :,58,10) = (/&
&3.3017E+00_JPRB,4.4251E+00_JPRB,5.6661E+00_JPRB,7.0836E+00_JPRB,8.6693E+00_JPRB/)
KBO( :,59,10) = (/&
&3.1387E+00_JPRB,4.2362E+00_JPRB,5.4398E+00_JPRB,6.8151E+00_JPRB,8.3756E+00_JPRB/)
KBO( :,13,11) = (/&
&8.6501E+01_JPRB,8.6756E+01_JPRB,8.7009E+01_JPRB,8.7807E+01_JPRB,8.8321E+01_JPRB/)
KBO( :,14,11) = (/&
&8.6001E+01_JPRB,8.6390E+01_JPRB,8.7153E+01_JPRB,8.7884E+01_JPRB,8.8485E+01_JPRB/)
KBO( :,15,11) = (/&
&8.3396E+01_JPRB,8.4271E+01_JPRB,8.5263E+01_JPRB,8.6231E+01_JPRB,8.7169E+01_JPRB/)
KBO( :,16,11) = (/&
&8.0216E+01_JPRB,8.1367E+01_JPRB,8.2641E+01_JPRB,8.3850E+01_JPRB,8.5113E+01_JPRB/)
KBO( :,17,11) = (/&
&7.7559E+01_JPRB,7.9123E+01_JPRB,8.0637E+01_JPRB,8.2229E+01_JPRB,8.3780E+01_JPRB/)
KBO( :,18,11) = (/&
&7.6113E+01_JPRB,7.8038E+01_JPRB,8.0039E+01_JPRB,8.1955E+01_JPRB,8.3906E+01_JPRB/)
KBO( :,19,11) = (/&
&7.4701E+01_JPRB,7.7061E+01_JPRB,7.9341E+01_JPRB,8.1777E+01_JPRB,8.4316E+01_JPRB/)
KBO( :,20,11) = (/&
&7.1644E+01_JPRB,7.4182E+01_JPRB,7.6892E+01_JPRB,7.9840E+01_JPRB,8.2902E+01_JPRB/)
KBO( :,21,11) = (/&
&6.7620E+01_JPRB,7.0516E+01_JPRB,7.3720E+01_JPRB,7.7152E+01_JPRB,8.0637E+01_JPRB/)
KBO( :,22,11) = (/&
&6.3004E+01_JPRB,6.6364E+01_JPRB,7.0039E+01_JPRB,7.3871E+01_JPRB,7.7820E+01_JPRB/)
KBO( :,23,11) = (/&
&5.8500E+01_JPRB,6.2279E+01_JPRB,6.6312E+01_JPRB,7.0504E+01_JPRB,7.4998E+01_JPRB/)
KBO( :,24,11) = (/&
&5.3727E+01_JPRB,5.7825E+01_JPRB,6.2144E+01_JPRB,6.6890E+01_JPRB,7.2071E+01_JPRB/)
KBO( :,25,11) = (/&
&4.9481E+01_JPRB,5.3871E+01_JPRB,5.8717E+01_JPRB,6.4044E+01_JPRB,6.9704E+01_JPRB/)
KBO( :,26,11) = (/&
&4.6254E+01_JPRB,5.1111E+01_JPRB,5.6460E+01_JPRB,6.2228E+01_JPRB,6.8093E+01_JPRB/)
KBO( :,27,11) = (/&
&4.3953E+01_JPRB,4.9258E+01_JPRB,5.5047E+01_JPRB,6.1083E+01_JPRB,6.7149E+01_JPRB/)
KBO( :,28,11) = (/&
&4.2333E+01_JPRB,4.8051E+01_JPRB,5.4161E+01_JPRB,6.0348E+01_JPRB,6.6482E+01_JPRB/)
KBO( :,29,11) = (/&
&4.1519E+01_JPRB,4.7571E+01_JPRB,5.3856E+01_JPRB,6.0162E+01_JPRB,6.6490E+01_JPRB/)
KBO( :,30,11) = (/&
&4.1079E+01_JPRB,4.7326E+01_JPRB,5.3742E+01_JPRB,6.0205E+01_JPRB,6.6744E+01_JPRB/)
KBO( :,31,11) = (/&
&4.0957E+01_JPRB,4.7315E+01_JPRB,5.3845E+01_JPRB,6.0494E+01_JPRB,6.7153E+01_JPRB/)
KBO( :,32,11) = (/&
&4.1227E+01_JPRB,4.7602E+01_JPRB,5.4282E+01_JPRB,6.1081E+01_JPRB,6.7763E+01_JPRB/)
KBO( :,33,11) = (/&
&4.1826E+01_JPRB,4.8137E+01_JPRB,5.4944E+01_JPRB,6.1784E+01_JPRB,6.8374E+01_JPRB/)
KBO( :,34,11) = (/&
&4.3072E+01_JPRB,4.9391E+01_JPRB,5.6254E+01_JPRB,6.3099E+01_JPRB,6.9725E+01_JPRB/)
KBO( :,35,11) = (/&
&4.3986E+01_JPRB,5.0200E+01_JPRB,5.6858E+01_JPRB,6.3640E+01_JPRB,7.0415E+01_JPRB/)
KBO( :,36,11) = (/&
&4.4502E+01_JPRB,5.0408E+01_JPRB,5.6628E+01_JPRB,6.3171E+01_JPRB,7.0200E+01_JPRB/)
KBO( :,37,11) = (/&
&4.3850E+01_JPRB,4.9526E+01_JPRB,5.5508E+01_JPRB,6.1846E+01_JPRB,6.8955E+01_JPRB/)
KBO( :,38,11) = (/&
&4.3288E+01_JPRB,4.8717E+01_JPRB,5.4460E+01_JPRB,6.0601E+01_JPRB,6.7672E+01_JPRB/)
KBO( :,39,11) = (/&
&4.2793E+01_JPRB,4.8055E+01_JPRB,5.3543E+01_JPRB,5.9508E+01_JPRB,6.6570E+01_JPRB/)
KBO( :,40,11) = (/&
&4.0982E+01_JPRB,4.6218E+01_JPRB,5.1475E+01_JPRB,5.7189E+01_JPRB,6.4026E+01_JPRB/)
KBO( :,41,11) = (/&
&3.9015E+01_JPRB,4.4241E+01_JPRB,4.9337E+01_JPRB,5.4818E+01_JPRB,6.1396E+01_JPRB/)
KBO( :,42,11) = (/&
&3.7029E+01_JPRB,4.2233E+01_JPRB,4.7279E+01_JPRB,5.2574E+01_JPRB,5.8917E+01_JPRB/)
KBO( :,43,11) = (/&
&3.4672E+01_JPRB,3.9813E+01_JPRB,4.4910E+01_JPRB,5.0015E+01_JPRB,5.6019E+01_JPRB/)
KBO( :,44,11) = (/&
&3.2216E+01_JPRB,3.7254E+01_JPRB,4.2367E+01_JPRB,4.7396E+01_JPRB,5.3071E+01_JPRB/)
KBO( :,45,11) = (/&
&2.9847E+01_JPRB,3.4776E+01_JPRB,3.9855E+01_JPRB,4.4920E+01_JPRB,5.0317E+01_JPRB/)
KBO( :,46,11) = (/&
&2.7555E+01_JPRB,3.2329E+01_JPRB,3.7304E+01_JPRB,4.2424E+01_JPRB,4.7633E+01_JPRB/)
KBO( :,47,11) = (/&
&2.5262E+01_JPRB,2.9854E+01_JPRB,3.4721E+01_JPRB,3.9795E+01_JPRB,4.4945E+01_JPRB/)
KBO( :,48,11) = (/&
&2.3081E+01_JPRB,2.7503E+01_JPRB,3.2213E+01_JPRB,3.7177E+01_JPRB,4.2342E+01_JPRB/)
KBO( :,49,11) = (/&
&2.1057E+01_JPRB,2.5246E+01_JPRB,2.9758E+01_JPRB,3.4602E+01_JPRB,3.9727E+01_JPRB/)
KBO( :,50,11) = (/&
&1.9318E+01_JPRB,2.3248E+01_JPRB,2.7618E+01_JPRB,3.2289E+01_JPRB,3.7300E+01_JPRB/)
KBO( :,51,11) = (/&
&1.7764E+01_JPRB,2.1445E+01_JPRB,2.5630E+01_JPRB,3.0117E+01_JPRB,3.5003E+01_JPRB/)
KBO( :,52,11) = (/&
&1.6284E+01_JPRB,1.9745E+01_JPRB,2.3706E+01_JPRB,2.8037E+01_JPRB,3.2754E+01_JPRB/)
KBO( :,53,11) = (/&
&1.4870E+01_JPRB,1.8170E+01_JPRB,2.1878E+01_JPRB,2.6032E+01_JPRB,3.0559E+01_JPRB/)
KBO( :,54,11) = (/&
&1.3618E+01_JPRB,1.6796E+01_JPRB,2.0287E+01_JPRB,2.4249E+01_JPRB,2.8597E+01_JPRB/)
KBO( :,55,11) = (/&
&1.2457E+01_JPRB,1.5534E+01_JPRB,1.8860E+01_JPRB,2.2616E+01_JPRB,2.6796E+01_JPRB/)
KBO( :,56,11) = (/&
&1.1356E+01_JPRB,1.4314E+01_JPRB,1.7512E+01_JPRB,2.1058E+01_JPRB,2.5045E+01_JPRB/)
KBO( :,57,11) = (/&
&1.0320E+01_JPRB,1.3127E+01_JPRB,1.6224E+01_JPRB,1.9585E+01_JPRB,2.3359E+01_JPRB/)
KBO( :,58,11) = (/&
&9.3830E+00_JPRB,1.2046E+01_JPRB,1.5046E+01_JPRB,1.8261E+01_JPRB,2.1817E+01_JPRB/)
KBO( :,59,11) = (/&
&8.9391E+00_JPRB,1.1539E+01_JPRB,1.4477E+01_JPRB,1.7622E+01_JPRB,2.1055E+01_JPRB/)
KBO( :,13,12) = (/&
&1.1536E+02_JPRB,1.1632E+02_JPRB,1.1676E+02_JPRB,1.1687E+02_JPRB,1.1771E+02_JPRB/)
KBO( :,14,12) = (/&
&1.1996E+02_JPRB,1.2089E+02_JPRB,1.2132E+02_JPRB,1.2216E+02_JPRB,1.2355E+02_JPRB/)
KBO( :,15,12) = (/&
&1.2190E+02_JPRB,1.2270E+02_JPRB,1.2390E+02_JPRB,1.2571E+02_JPRB,1.2681E+02_JPRB/)
KBO( :,16,12) = (/&
&1.2181E+02_JPRB,1.2365E+02_JPRB,1.2585E+02_JPRB,1.2744E+02_JPRB,1.2865E+02_JPRB/)
KBO( :,17,12) = (/&
&1.2361E+02_JPRB,1.2611E+02_JPRB,1.2809E+02_JPRB,1.2991E+02_JPRB,1.3207E+02_JPRB/)
KBO( :,18,12) = (/&
&1.2791E+02_JPRB,1.3042E+02_JPRB,1.3285E+02_JPRB,1.3575E+02_JPRB,1.3866E+02_JPRB/)
KBO( :,19,12) = (/&
&1.3167E+02_JPRB,1.3492E+02_JPRB,1.3862E+02_JPRB,1.4230E+02_JPRB,1.4589E+02_JPRB/)
KBO( :,20,12) = (/&
&1.3240E+02_JPRB,1.3677E+02_JPRB,1.4130E+02_JPRB,1.4568E+02_JPRB,1.5011E+02_JPRB/)
KBO( :,21,12) = (/&
&1.3167E+02_JPRB,1.3705E+02_JPRB,1.4232E+02_JPRB,1.4765E+02_JPRB,1.5295E+02_JPRB/)
KBO( :,22,12) = (/&
&1.2941E+02_JPRB,1.3568E+02_JPRB,1.4188E+02_JPRB,1.4812E+02_JPRB,1.5420E+02_JPRB/)
KBO( :,23,12) = (/&
&1.2650E+02_JPRB,1.3362E+02_JPRB,1.4090E+02_JPRB,1.4804E+02_JPRB,1.5493E+02_JPRB/)
KBO( :,24,12) = (/&
&1.2203E+02_JPRB,1.3010E+02_JPRB,1.3824E+02_JPRB,1.4621E+02_JPRB,1.5349E+02_JPRB/)
KBO( :,25,12) = (/&
&1.1780E+02_JPRB,1.2675E+02_JPRB,1.3578E+02_JPRB,1.4425E+02_JPRB,1.5220E+02_JPRB/)
KBO( :,26,12) = (/&
&1.1452E+02_JPRB,1.2433E+02_JPRB,1.3394E+02_JPRB,1.4292E+02_JPRB,1.5154E+02_JPRB/)
KBO( :,27,12) = (/&
&1.1158E+02_JPRB,1.2202E+02_JPRB,1.3200E+02_JPRB,1.4156E+02_JPRB,1.5071E+02_JPRB/)
KBO( :,28,12) = (/&
&1.0877E+02_JPRB,1.1953E+02_JPRB,1.2986E+02_JPRB,1.3983E+02_JPRB,1.4949E+02_JPRB/)
KBO( :,29,12) = (/&
&1.0758E+02_JPRB,1.1863E+02_JPRB,1.2937E+02_JPRB,1.3977E+02_JPRB,1.4973E+02_JPRB/)
KBO( :,30,12) = (/&
&1.0679E+02_JPRB,1.1811E+02_JPRB,1.2916E+02_JPRB,1.3989E+02_JPRB,1.4980E+02_JPRB/)
KBO( :,31,12) = (/&
&1.0688E+02_JPRB,1.1849E+02_JPRB,1.2989E+02_JPRB,1.4068E+02_JPRB,1.5077E+02_JPRB/)
KBO( :,32,12) = (/&
&1.0761E+02_JPRB,1.1953E+02_JPRB,1.3110E+02_JPRB,1.4225E+02_JPRB,1.5305E+02_JPRB/)
KBO( :,33,12) = (/&
&1.0869E+02_JPRB,1.2092E+02_JPRB,1.3311E+02_JPRB,1.4513E+02_JPRB,1.5706E+02_JPRB/)
KBO( :,34,12) = (/&
&1.1112E+02_JPRB,1.2403E+02_JPRB,1.3695E+02_JPRB,1.4972E+02_JPRB,1.6276E+02_JPRB/)
KBO( :,35,12) = (/&
&1.1246E+02_JPRB,1.2623E+02_JPRB,1.4002E+02_JPRB,1.5398E+02_JPRB,1.6809E+02_JPRB/)
KBO( :,36,12) = (/&
&1.1250E+02_JPRB,1.2737E+02_JPRB,1.4246E+02_JPRB,1.5783E+02_JPRB,1.7316E+02_JPRB/)
KBO( :,37,12) = (/&
&1.1061E+02_JPRB,1.2593E+02_JPRB,1.4155E+02_JPRB,1.5744E+02_JPRB,1.7321E+02_JPRB/)
KBO( :,38,12) = (/&
&1.0863E+02_JPRB,1.2441E+02_JPRB,1.4054E+02_JPRB,1.5693E+02_JPRB,1.7309E+02_JPRB/)
KBO( :,39,12) = (/&
&1.0682E+02_JPRB,1.2301E+02_JPRB,1.3972E+02_JPRB,1.5664E+02_JPRB,1.7318E+02_JPRB/)
KBO( :,40,12) = (/&
&1.0231E+02_JPRB,1.1830E+02_JPRB,1.3525E+02_JPRB,1.5235E+02_JPRB,1.6904E+02_JPRB/)
KBO( :,41,12) = (/&
&9.7591E+01_JPRB,1.1325E+02_JPRB,1.3028E+02_JPRB,1.4750E+02_JPRB,1.6434E+02_JPRB/)
KBO( :,42,12) = (/&
&9.3027E+01_JPRB,1.0842E+02_JPRB,1.2533E+02_JPRB,1.4267E+02_JPRB,1.5965E+02_JPRB/)
KBO( :,43,12) = (/&
&8.7538E+01_JPRB,1.0245E+02_JPRB,1.1885E+02_JPRB,1.3623E+02_JPRB,1.5326E+02_JPRB/)
KBO( :,44,12) = (/&
&8.1886E+01_JPRB,9.6138E+01_JPRB,1.1198E+02_JPRB,1.2909E+02_JPRB,1.4608E+02_JPRB/)
KBO( :,45,12) = (/&
&7.6645E+01_JPRB,9.0087E+01_JPRB,1.0542E+02_JPRB,1.2199E+02_JPRB,1.3900E+02_JPRB/)
KBO( :,46,12) = (/&
&7.1474E+01_JPRB,8.4055E+01_JPRB,9.8742E+01_JPRB,1.1474E+02_JPRB,1.3156E+02_JPRB/)
KBO( :,47,12) = (/&
&6.6310E+01_JPRB,7.7963E+01_JPRB,9.1690E+01_JPRB,1.0705E+02_JPRB,1.2340E+02_JPRB/)
KBO( :,48,12) = (/&
&6.1600E+01_JPRB,7.2276E+01_JPRB,8.5037E+01_JPRB,9.9673E+01_JPRB,1.1542E+02_JPRB/)
KBO( :,49,12) = (/&
&5.7283E+01_JPRB,6.7050E+01_JPRB,7.8923E+01_JPRB,9.2652E+01_JPRB,1.0778E+02_JPRB/)
KBO( :,50,12) = (/&
&5.3478E+01_JPRB,6.2571E+01_JPRB,7.3516E+01_JPRB,8.6380E+01_JPRB,1.0082E+02_JPRB/)
KBO( :,51,12) = (/&
&4.9875E+01_JPRB,5.8576E+01_JPRB,6.8672E+01_JPRB,8.0731E+01_JPRB,9.4376E+01_JPRB/)
KBO( :,52,12) = (/&
&4.6408E+01_JPRB,5.4871E+01_JPRB,6.4185E+01_JPRB,7.5407E+01_JPRB,8.8241E+01_JPRB/)
KBO( :,53,12) = (/&
&4.3049E+01_JPRB,5.1245E+01_JPRB,6.0053E+01_JPRB,7.0436E+01_JPRB,8.2512E+01_JPRB/)
KBO( :,54,12) = (/&
&4.0074E+01_JPRB,4.8005E+01_JPRB,5.6523E+01_JPRB,6.6130E+01_JPRB,7.7483E+01_JPRB/)
KBO( :,55,12) = (/&
&3.7334E+01_JPRB,4.4988E+01_JPRB,5.3284E+01_JPRB,6.2287E+01_JPRB,7.2912E+01_JPRB/)
KBO( :,56,12) = (/&
&3.4721E+01_JPRB,4.2060E+01_JPRB,5.0133E+01_JPRB,5.8707E+01_JPRB,6.8606E+01_JPRB/)
KBO( :,57,12) = (/&
&3.2171E+01_JPRB,3.9229E+01_JPRB,4.7079E+01_JPRB,5.5373E+01_JPRB,6.4605E+01_JPRB/)
KBO( :,58,12) = (/&
&2.9794E+01_JPRB,3.6617E+01_JPRB,4.4198E+01_JPRB,5.2314E+01_JPRB,6.1016E+01_JPRB/)
KBO( :,59,12) = (/&
&2.8699E+01_JPRB,3.5397E+01_JPRB,4.2806E+01_JPRB,5.0814E+01_JPRB,5.9273E+01_JPRB/)
KBO( :,13,13) = (/&
&1.6492E+02_JPRB,1.6388E+02_JPRB,1.6346E+02_JPRB,1.6281E+02_JPRB,1.6185E+02_JPRB/)
KBO( :,14,13) = (/&
&1.7807E+02_JPRB,1.7770E+02_JPRB,1.7743E+02_JPRB,1.7669E+02_JPRB,1.7598E+02_JPRB/)
KBO( :,15,13) = (/&
&1.8993E+02_JPRB,1.9024E+02_JPRB,1.8997E+02_JPRB,1.8962E+02_JPRB,1.9043E+02_JPRB/)
KBO( :,16,13) = (/&
&2.0050E+02_JPRB,2.0095E+02_JPRB,2.0135E+02_JPRB,2.0291E+02_JPRB,2.0501E+02_JPRB/)
KBO( :,17,13) = (/&
&2.0905E+02_JPRB,2.1062E+02_JPRB,2.1338E+02_JPRB,2.1661E+02_JPRB,2.1875E+02_JPRB/)
KBO( :,18,13) = (/&
&2.1804E+02_JPRB,2.2224E+02_JPRB,2.2674E+02_JPRB,2.3000E+02_JPRB,2.3246E+02_JPRB/)
KBO( :,19,13) = (/&
&2.3115E+02_JPRB,2.3655E+02_JPRB,2.4106E+02_JPRB,2.4477E+02_JPRB,2.4852E+02_JPRB/)
KBO( :,20,13) = (/&
&2.4329E+02_JPRB,2.4898E+02_JPRB,2.5395E+02_JPRB,2.5885E+02_JPRB,2.6364E+02_JPRB/)
KBO( :,21,13) = (/&
&2.5437E+02_JPRB,2.6055E+02_JPRB,2.6661E+02_JPRB,2.7260E+02_JPRB,2.7787E+02_JPRB/)
KBO( :,22,13) = (/&
&2.6250E+02_JPRB,2.7007E+02_JPRB,2.7766E+02_JPRB,2.8448E+02_JPRB,2.9027E+02_JPRB/)
KBO( :,23,13) = (/&
&2.6919E+02_JPRB,2.7869E+02_JPRB,2.8736E+02_JPRB,2.9473E+02_JPRB,3.0099E+02_JPRB/)
KBO( :,24,13) = (/&
&2.7228E+02_JPRB,2.8325E+02_JPRB,2.9264E+02_JPRB,3.0066E+02_JPRB,3.0797E+02_JPRB/)
KBO( :,25,13) = (/&
&2.7478E+02_JPRB,2.8650E+02_JPRB,2.9632E+02_JPRB,3.0547E+02_JPRB,3.1366E+02_JPRB/)
KBO( :,26,13) = (/&
&2.7718E+02_JPRB,2.8924E+02_JPRB,3.0014E+02_JPRB,3.1019E+02_JPRB,3.1917E+02_JPRB/)
KBO( :,27,13) = (/&
&2.7773E+02_JPRB,2.9063E+02_JPRB,3.0281E+02_JPRB,3.1393E+02_JPRB,3.2342E+02_JPRB/)
KBO( :,28,13) = (/&
&2.7669E+02_JPRB,2.9127E+02_JPRB,3.0469E+02_JPRB,3.1685E+02_JPRB,3.2697E+02_JPRB/)
KBO( :,29,13) = (/&
&2.7898E+02_JPRB,2.9479E+02_JPRB,3.0937E+02_JPRB,3.2216E+02_JPRB,3.3294E+02_JPRB/)
KBO( :,30,13) = (/&
&2.8228E+02_JPRB,2.9938E+02_JPRB,3.1508E+02_JPRB,3.2858E+02_JPRB,3.4068E+02_JPRB/)
KBO( :,31,13) = (/&
&2.8807E+02_JPRB,3.0670E+02_JPRB,3.2315E+02_JPRB,3.3792E+02_JPRB,3.5112E+02_JPRB/)
KBO( :,32,13) = (/&
&2.9599E+02_JPRB,3.1568E+02_JPRB,3.3326E+02_JPRB,3.4888E+02_JPRB,3.6266E+02_JPRB/)
KBO( :,33,13) = (/&
&3.0608E+02_JPRB,3.2668E+02_JPRB,3.4478E+02_JPRB,3.6084E+02_JPRB,3.7554E+02_JPRB/)
KBO( :,34,13) = (/&
&3.1667E+02_JPRB,3.3765E+02_JPRB,3.5613E+02_JPRB,3.7316E+02_JPRB,3.8829E+02_JPRB/)
KBO( :,35,13) = (/&
&3.2596E+02_JPRB,3.4758E+02_JPRB,3.6720E+02_JPRB,3.8537E+02_JPRB,4.0075E+02_JPRB/)
KBO( :,36,13) = (/&
&3.3359E+02_JPRB,3.5628E+02_JPRB,3.7747E+02_JPRB,3.9672E+02_JPRB,4.1282E+02_JPRB/)
KBO( :,37,13) = (/&
&3.3360E+02_JPRB,3.5721E+02_JPRB,3.7933E+02_JPRB,3.9940E+02_JPRB,4.1630E+02_JPRB/)
KBO( :,38,13) = (/&
&3.3326E+02_JPRB,3.5780E+02_JPRB,3.8082E+02_JPRB,4.0174E+02_JPRB,4.1947E+02_JPRB/)
KBO( :,39,13) = (/&
&3.3309E+02_JPRB,3.5850E+02_JPRB,3.8253E+02_JPRB,4.0436E+02_JPRB,4.2297E+02_JPRB/)
KBO( :,40,13) = (/&
&3.2648E+02_JPRB,3.5268E+02_JPRB,3.7698E+02_JPRB,3.9960E+02_JPRB,4.1913E+02_JPRB/)
KBO( :,41,13) = (/&
&3.1896E+02_JPRB,3.4578E+02_JPRB,3.7035E+02_JPRB,3.9368E+02_JPRB,4.1397E+02_JPRB/)
KBO( :,42,13) = (/&
&3.1112E+02_JPRB,3.3866E+02_JPRB,3.6362E+02_JPRB,3.8746E+02_JPRB,4.0853E+02_JPRB/)
KBO( :,43,13) = (/&
&3.0052E+02_JPRB,3.2869E+02_JPRB,3.5427E+02_JPRB,3.7807E+02_JPRB,3.9999E+02_JPRB/)
KBO( :,44,13) = (/&
&2.8853E+02_JPRB,3.1745E+02_JPRB,3.4358E+02_JPRB,3.6752E+02_JPRB,3.9013E+02_JPRB/)
KBO( :,45,13) = (/&
&2.7601E+02_JPRB,3.0588E+02_JPRB,3.3279E+02_JPRB,3.5705E+02_JPRB,3.7967E+02_JPRB/)
KBO( :,46,13) = (/&
&2.6267E+02_JPRB,2.9363E+02_JPRB,3.2123E+02_JPRB,3.4597E+02_JPRB,3.6877E+02_JPRB/)
KBO( :,47,13) = (/&
&2.4757E+02_JPRB,2.7937E+02_JPRB,3.0805E+02_JPRB,3.3376E+02_JPRB,3.5676E+02_JPRB/)
KBO( :,48,13) = (/&
&2.3214E+02_JPRB,2.6483E+02_JPRB,2.9482E+02_JPRB,3.2128E+02_JPRB,3.4490E+02_JPRB/)
KBO( :,49,13) = (/&
&2.1667E+02_JPRB,2.4994E+02_JPRB,2.8075E+02_JPRB,3.0839E+02_JPRB,3.3291E+02_JPRB/)
KBO( :,50,13) = (/&
&2.0214E+02_JPRB,2.3567E+02_JPRB,2.6727E+02_JPRB,2.9615E+02_JPRB,3.2136E+02_JPRB/)
KBO( :,51,13) = (/&
&1.8827E+02_JPRB,2.2174E+02_JPRB,2.5386E+02_JPRB,2.8344E+02_JPRB,3.0975E+02_JPRB/)
KBO( :,52,13) = (/&
&1.7469E+02_JPRB,2.0766E+02_JPRB,2.4021E+02_JPRB,2.7051E+02_JPRB,2.9806E+02_JPRB/)
KBO( :,53,13) = (/&
&1.6154E+02_JPRB,1.9380E+02_JPRB,2.2644E+02_JPRB,2.5730E+02_JPRB,2.8551E+02_JPRB/)
KBO( :,54,13) = (/&
&1.4971E+02_JPRB,1.8121E+02_JPRB,2.1351E+02_JPRB,2.4474E+02_JPRB,2.7363E+02_JPRB/)
KBO( :,55,13) = (/&
&1.3871E+02_JPRB,1.6943E+02_JPRB,2.0115E+02_JPRB,2.3248E+02_JPRB,2.6185E+02_JPRB/)
KBO( :,56,13) = (/&
&1.2829E+02_JPRB,1.5787E+02_JPRB,1.8899E+02_JPRB,2.2029E+02_JPRB,2.4989E+02_JPRB/)
KBO( :,57,13) = (/&
&1.1862E+02_JPRB,1.4668E+02_JPRB,1.7707E+02_JPRB,2.0801E+02_JPRB,2.3778E+02_JPRB/)
KBO( :,58,13) = (/&
&1.1001E+02_JPRB,1.3648E+02_JPRB,1.6587E+02_JPRB,1.9633E+02_JPRB,2.2625E+02_JPRB/)
KBO( :,59,13) = (/&
&1.0617E+02_JPRB,1.3192E+02_JPRB,1.6056E+02_JPRB,1.9063E+02_JPRB,2.2036E+02_JPRB/)
KBO( :,13,14) = (/&
&2.3740E+02_JPRB,2.3433E+02_JPRB,2.3150E+02_JPRB,2.2987E+02_JPRB,2.2791E+02_JPRB/)
KBO( :,14,14) = (/&
&2.6697E+02_JPRB,2.6354E+02_JPRB,2.6091E+02_JPRB,2.5890E+02_JPRB,2.5611E+02_JPRB/)
KBO( :,15,14) = (/&
&2.9866E+02_JPRB,2.9528E+02_JPRB,2.9285E+02_JPRB,2.8971E+02_JPRB,2.8602E+02_JPRB/)
KBO( :,16,14) = (/&
&3.3180E+02_JPRB,3.2877E+02_JPRB,3.2564E+02_JPRB,3.2149E+02_JPRB,3.1785E+02_JPRB/)
KBO( :,17,14) = (/&
&3.6593E+02_JPRB,3.6291E+02_JPRB,3.5866E+02_JPRB,3.5483E+02_JPRB,3.5327E+02_JPRB/)
KBO( :,18,14) = (/&
&4.0089E+02_JPRB,3.9701E+02_JPRB,3.9353E+02_JPRB,3.9249E+02_JPRB,3.9242E+02_JPRB/)
KBO( :,19,14) = (/&
&4.3492E+02_JPRB,4.3255E+02_JPRB,4.3249E+02_JPRB,4.3314E+02_JPRB,4.3203E+02_JPRB/)
KBO( :,20,14) = (/&
&4.6851E+02_JPRB,4.6867E+02_JPRB,4.6996E+02_JPRB,4.7008E+02_JPRB,4.6768E+02_JPRB/)
KBO( :,21,14) = (/&
&5.0160E+02_JPRB,5.0368E+02_JPRB,5.0510E+02_JPRB,5.0393E+02_JPRB,5.0142E+02_JPRB/)
KBO( :,22,14) = (/&
&5.3436E+02_JPRB,5.3662E+02_JPRB,5.3668E+02_JPRB,5.3522E+02_JPRB,5.3316E+02_JPRB/)
KBO( :,23,14) = (/&
&5.6475E+02_JPRB,5.6646E+02_JPRB,5.6617E+02_JPRB,5.6492E+02_JPRB,5.6377E+02_JPRB/)
KBO( :,24,14) = (/&
&5.9117E+02_JPRB,5.9235E+02_JPRB,5.9305E+02_JPRB,5.9284E+02_JPRB,5.9155E+02_JPRB/)
KBO( :,25,14) = (/&
&6.1433E+02_JPRB,6.1663E+02_JPRB,6.1844E+02_JPRB,6.1841E+02_JPRB,6.1657E+02_JPRB/)
KBO( :,26,14) = (/&
&6.3532E+02_JPRB,6.3942E+02_JPRB,6.4146E+02_JPRB,6.4105E+02_JPRB,6.3887E+02_JPRB/)
KBO( :,27,14) = (/&
&6.5539E+02_JPRB,6.6044E+02_JPRB,6.6224E+02_JPRB,6.6141E+02_JPRB,6.5941E+02_JPRB/)
KBO( :,28,14) = (/&
&6.7497E+02_JPRB,6.7980E+02_JPRB,6.8130E+02_JPRB,6.7994E+02_JPRB,6.7811E+02_JPRB/)
KBO( :,29,14) = (/&
&6.9431E+02_JPRB,6.9884E+02_JPRB,6.9950E+02_JPRB,6.9835E+02_JPRB,6.9642E+02_JPRB/)
KBO( :,30,14) = (/&
&7.1327E+02_JPRB,7.1751E+02_JPRB,7.1742E+02_JPRB,7.1698E+02_JPRB,7.1542E+02_JPRB/)
KBO( :,31,14) = (/&
&7.3356E+02_JPRB,7.3622E+02_JPRB,7.3751E+02_JPRB,7.3724E+02_JPRB,7.3663E+02_JPRB/)
KBO( :,32,14) = (/&
&7.5311E+02_JPRB,7.5602E+02_JPRB,7.5787E+02_JPRB,7.5927E+02_JPRB,7.5912E+02_JPRB/)
KBO( :,33,14) = (/&
&7.7307E+02_JPRB,7.7793E+02_JPRB,7.8149E+02_JPRB,7.8317E+02_JPRB,7.8351E+02_JPRB/)
KBO( :,34,14) = (/&
&7.9467E+02_JPRB,8.0056E+02_JPRB,8.0525E+02_JPRB,8.0749E+02_JPRB,8.0900E+02_JPRB/)
KBO( :,35,14) = (/&
&8.1769E+02_JPRB,8.2551E+02_JPRB,8.3062E+02_JPRB,8.3402E+02_JPRB,8.3937E+02_JPRB/)
KBO( :,36,14) = (/&
&8.4220E+02_JPRB,8.5215E+02_JPRB,8.5810E+02_JPRB,8.6400E+02_JPRB,8.7476E+02_JPRB/)
KBO( :,37,14) = (/&
&8.5305E+02_JPRB,8.6405E+02_JPRB,8.7082E+02_JPRB,8.7797E+02_JPRB,8.9053E+02_JPRB/)
KBO( :,38,14) = (/&
&8.6322E+02_JPRB,8.7544E+02_JPRB,8.8314E+02_JPRB,8.9164E+02_JPRB,9.0590E+02_JPRB/)
KBO( :,39,14) = (/&
&8.7378E+02_JPRB,8.8745E+02_JPRB,8.9629E+02_JPRB,9.0629E+02_JPRB,9.2255E+02_JPRB/)
KBO( :,40,14) = (/&
&8.7238E+02_JPRB,8.8620E+02_JPRB,8.9614E+02_JPRB,9.0579E+02_JPRB,9.1970E+02_JPRB/)
KBO( :,41,14) = (/&
&8.6852E+02_JPRB,8.8300E+02_JPRB,8.9419E+02_JPRB,9.0301E+02_JPRB,9.1475E+02_JPRB/)
KBO( :,42,14) = (/&
&8.6436E+02_JPRB,8.7945E+02_JPRB,8.9208E+02_JPRB,9.0006E+02_JPRB,9.1044E+02_JPRB/)
KBO( :,43,14) = (/&
&8.5621E+02_JPRB,8.7164E+02_JPRB,8.8447E+02_JPRB,8.9300E+02_JPRB,9.0169E+02_JPRB/)
KBO( :,44,14) = (/&
&8.4579E+02_JPRB,8.6160E+02_JPRB,8.7458E+02_JPRB,8.8449E+02_JPRB,8.9117E+02_JPRB/)
KBO( :,45,14) = (/&
&8.3552E+02_JPRB,8.5159E+02_JPRB,8.6481E+02_JPRB,8.7553E+02_JPRB,8.8180E+02_JPRB/)
KBO( :,46,14) = (/&
&8.2373E+02_JPRB,8.4082E+02_JPRB,8.5433E+02_JPRB,8.6532E+02_JPRB,8.7296E+02_JPRB/)
KBO( :,47,14) = (/&
&8.0885E+02_JPRB,8.2944E+02_JPRB,8.4330E+02_JPRB,8.5448E+02_JPRB,8.6308E+02_JPRB/)
KBO( :,48,14) = (/&
&7.9282E+02_JPRB,8.1701E+02_JPRB,8.3172E+02_JPRB,8.4330E+02_JPRB,8.5233E+02_JPRB/)
KBO( :,49,14) = (/&
&7.7474E+02_JPRB,8.0258E+02_JPRB,8.2078E+02_JPRB,8.3236E+02_JPRB,8.4158E+02_JPRB/)
KBO( :,50,14) = (/&
&7.5683E+02_JPRB,7.8804E+02_JPRB,8.0940E+02_JPRB,8.2148E+02_JPRB,8.3083E+02_JPRB/)
KBO( :,51,14) = (/&
&7.3938E+02_JPRB,7.7206E+02_JPRB,7.9641E+02_JPRB,8.1162E+02_JPRB,8.2058E+02_JPRB/)
KBO( :,52,14) = (/&
&7.2202E+02_JPRB,7.5535E+02_JPRB,7.8294E+02_JPRB,8.0108E+02_JPRB,8.1024E+02_JPRB/)
KBO( :,53,14) = (/&
&7.0324E+02_JPRB,7.3897E+02_JPRB,7.6789E+02_JPRB,7.8856E+02_JPRB,8.0094E+02_JPRB/)
KBO( :,54,14) = (/&
&6.8557E+02_JPRB,7.2372E+02_JPRB,7.5272E+02_JPRB,7.7628E+02_JPRB,7.9095E+02_JPRB/)
KBO( :,55,14) = (/&
&6.6859E+02_JPRB,7.0784E+02_JPRB,7.3838E+02_JPRB,7.6303E+02_JPRB,7.7977E+02_JPRB/)
KBO( :,56,14) = (/&
&6.5053E+02_JPRB,6.9180E+02_JPRB,7.2460E+02_JPRB,7.4881E+02_JPRB,7.6818E+02_JPRB/)
KBO( :,57,14) = (/&
&6.3162E+02_JPRB,6.7617E+02_JPRB,7.0983E+02_JPRB,7.3529E+02_JPRB,7.5540E+02_JPRB/)
KBO( :,58,14) = (/&
&6.1260E+02_JPRB,6.6039E+02_JPRB,6.9564E+02_JPRB,7.2278E+02_JPRB,7.4208E+02_JPRB/)
KBO( :,59,14) = (/&
&6.0339E+02_JPRB,6.5209E+02_JPRB,6.8806E+02_JPRB,7.1492E+02_JPRB,7.3375E+02_JPRB/)
KBO( :,13,15) = (/&
&3.5098E+02_JPRB,3.4253E+02_JPRB,3.3549E+02_JPRB,3.2928E+02_JPRB,3.2668E+02_JPRB/)
KBO( :,14,15) = (/&
&4.0377E+02_JPRB,3.9399E+02_JPRB,3.8548E+02_JPRB,3.7889E+02_JPRB,3.7631E+02_JPRB/)
KBO( :,15,15) = (/&
&4.6249E+02_JPRB,4.5101E+02_JPRB,4.4105E+02_JPRB,4.3505E+02_JPRB,4.3250E+02_JPRB/)
KBO( :,16,15) = (/&
&5.2722E+02_JPRB,5.1397E+02_JPRB,5.0360E+02_JPRB,4.9808E+02_JPRB,4.9380E+02_JPRB/)
KBO( :,17,15) = (/&
&5.9816E+02_JPRB,5.8291E+02_JPRB,5.7380E+02_JPRB,5.6753E+02_JPRB,5.5862E+02_JPRB/)
KBO( :,18,15) = (/&
&6.7401E+02_JPRB,6.5981E+02_JPRB,6.5045E+02_JPRB,6.3876E+02_JPRB,6.2938E+02_JPRB/)
KBO( :,19,15) = (/&
&7.5603E+02_JPRB,7.4243E+02_JPRB,7.2713E+02_JPRB,7.1493E+02_JPRB,7.1147E+02_JPRB/)
KBO( :,20,15) = (/&
&8.4018E+02_JPRB,8.2182E+02_JPRB,8.0329E+02_JPRB,7.9254E+02_JPRB,7.9403E+02_JPRB/)
KBO( :,21,15) = (/&
&9.2407E+02_JPRB,8.9903E+02_JPRB,8.7966E+02_JPRB,8.7268E+02_JPRB,8.7487E+02_JPRB/)
KBO( :,22,15) = (/&
&1.0011E+03_JPRB,9.7360E+02_JPRB,9.5759E+02_JPRB,9.5258E+02_JPRB,9.5318E+02_JPRB/)
KBO( :,23,15) = (/&
&1.0752E+03_JPRB,1.0483E+03_JPRB,1.0346E+03_JPRB,1.0305E+03_JPRB,1.0291E+03_JPRB/)
KBO( :,24,15) = (/&
&1.1456E+03_JPRB,1.1222E+03_JPRB,1.1083E+03_JPRB,1.1031E+03_JPRB,1.1046E+03_JPRB/)
KBO( :,25,15) = (/&
&1.2128E+03_JPRB,1.1904E+03_JPRB,1.1781E+03_JPRB,1.1730E+03_JPRB,1.1805E+03_JPRB/)
KBO( :,26,15) = (/&
&1.2750E+03_JPRB,1.2517E+03_JPRB,1.2401E+03_JPRB,1.2396E+03_JPRB,1.2511E+03_JPRB/)
KBO( :,27,15) = (/&
&1.3306E+03_JPRB,1.3092E+03_JPRB,1.2993E+03_JPRB,1.3047E+03_JPRB,1.3242E+03_JPRB/)
KBO( :,28,15) = (/&
&1.3803E+03_JPRB,1.3622E+03_JPRB,1.3582E+03_JPRB,1.3721E+03_JPRB,1.4060E+03_JPRB/)
KBO( :,29,15) = (/&
&1.4288E+03_JPRB,1.4164E+03_JPRB,1.4235E+03_JPRB,1.4518E+03_JPRB,1.5063E+03_JPRB/)
KBO( :,30,15) = (/&
&1.4796E+03_JPRB,1.4775E+03_JPRB,1.4997E+03_JPRB,1.5506E+03_JPRB,1.6294E+03_JPRB/)
KBO( :,31,15) = (/&
&1.5388E+03_JPRB,1.5544E+03_JPRB,1.6015E+03_JPRB,1.6845E+03_JPRB,1.7959E+03_JPRB/)
KBO( :,32,15) = (/&
&1.6108E+03_JPRB,1.6524E+03_JPRB,1.7357E+03_JPRB,1.8549E+03_JPRB,2.0073E+03_JPRB/)
KBO( :,33,15) = (/&
&1.7049E+03_JPRB,1.7848E+03_JPRB,1.9109E+03_JPRB,2.0795E+03_JPRB,2.2809E+03_JPRB/)
KBO( :,34,15) = (/&
&1.8222E+03_JPRB,1.9474E+03_JPRB,2.1232E+03_JPRB,2.3448E+03_JPRB,2.6010E+03_JPRB/)
KBO( :,35,15) = (/&
&1.9666E+03_JPRB,2.1410E+03_JPRB,2.3742E+03_JPRB,2.6548E+03_JPRB,2.9712E+03_JPRB/)
KBO( :,36,15) = (/&
&2.1340E+03_JPRB,2.3637E+03_JPRB,2.6606E+03_JPRB,3.0085E+03_JPRB,3.3914E+03_JPRB/)
KBO( :,37,15) = (/&
&2.1914E+03_JPRB,2.4375E+03_JPRB,2.7564E+03_JPRB,3.1300E+03_JPRB,3.5406E+03_JPRB/)
KBO( :,38,15) = (/&
&2.2462E+03_JPRB,2.5086E+03_JPRB,2.8496E+03_JPRB,3.2486E+03_JPRB,3.6885E+03_JPRB/)
KBO( :,39,15) = (/&
&2.3075E+03_JPRB,2.5896E+03_JPRB,2.9560E+03_JPRB,3.3853E+03_JPRB,3.8593E+03_JPRB/)
KBO( :,40,15) = (/&
&2.2597E+03_JPRB,2.5238E+03_JPRB,2.8725E+03_JPRB,3.2888E+03_JPRB,3.7565E+03_JPRB/)
KBO( :,41,15) = (/&
&2.2030E+03_JPRB,2.4431E+03_JPRB,2.7663E+03_JPRB,3.1637E+03_JPRB,3.6169E+03_JPRB/)
KBO( :,42,15) = (/&
&2.1527E+03_JPRB,2.3676E+03_JPRB,2.6649E+03_JPRB,3.0437E+03_JPRB,3.4807E+03_JPRB/)
KBO( :,43,15) = (/&
&2.0801E+03_JPRB,2.2578E+03_JPRB,2.5168E+03_JPRB,2.8580E+03_JPRB,3.2606E+03_JPRB/)
KBO( :,44,15) = (/&
&2.0120E+03_JPRB,2.1487E+03_JPRB,2.3643E+03_JPRB,2.6580E+03_JPRB,3.0218E+03_JPRB/)
KBO( :,45,15) = (/&
&1.9613E+03_JPRB,2.0594E+03_JPRB,2.2322E+03_JPRB,2.4807E+03_JPRB,2.8037E+03_JPRB/)
KBO( :,46,15) = (/&
&1.9248E+03_JPRB,1.9849E+03_JPRB,2.1161E+03_JPRB,2.3204E+03_JPRB,2.5965E+03_JPRB/)
KBO( :,47,15) = (/&
&1.9027E+03_JPRB,1.9263E+03_JPRB,2.0143E+03_JPRB,2.1716E+03_JPRB,2.3989E+03_JPRB/)
KBO( :,48,15) = (/&
&1.8901E+03_JPRB,1.8881E+03_JPRB,1.9372E+03_JPRB,2.0507E+03_JPRB,2.2312E+03_JPRB/)
KBO( :,49,15) = (/&
&1.8889E+03_JPRB,1.8669E+03_JPRB,1.8827E+03_JPRB,1.9550E+03_JPRB,2.0905E+03_JPRB/)
KBO( :,50,15) = (/&
&1.8989E+03_JPRB,1.8542E+03_JPRB,1.8471E+03_JPRB,1.8860E+03_JPRB,1.9820E+03_JPRB/)
KBO( :,51,15) = (/&
&1.9169E+03_JPRB,1.8516E+03_JPRB,1.8269E+03_JPRB,1.8368E+03_JPRB,1.8967E+03_JPRB/)
KBO( :,52,15) = (/&
&1.9362E+03_JPRB,1.8607E+03_JPRB,1.8138E+03_JPRB,1.8022E+03_JPRB,1.8318E+03_JPRB/)
KBO( :,53,15) = (/&
&1.9614E+03_JPRB,1.8769E+03_JPRB,1.8109E+03_JPRB,1.7819E+03_JPRB,1.7849E+03_JPRB/)
KBO( :,54,15) = (/&
&1.9844E+03_JPRB,1.8925E+03_JPRB,1.8175E+03_JPRB,1.7685E+03_JPRB,1.7516E+03_JPRB/)
KBO( :,55,15) = (/&
&2.0020E+03_JPRB,1.9117E+03_JPRB,1.8292E+03_JPRB,1.7630E+03_JPRB,1.7309E+03_JPRB/)
KBO( :,56,15) = (/&
&2.0278E+03_JPRB,1.9328E+03_JPRB,1.8420E+03_JPRB,1.7676E+03_JPRB,1.7165E+03_JPRB/)
KBO( :,57,15) = (/&
&2.0604E+03_JPRB,1.9486E+03_JPRB,1.8586E+03_JPRB,1.7772E+03_JPRB,1.7105E+03_JPRB/)
KBO( :,58,15) = (/&
&2.0975E+03_JPRB,1.9708E+03_JPRB,1.8754E+03_JPRB,1.7869E+03_JPRB,1.7130E+03_JPRB/)
KBO( :,59,15) = (/&
&2.1134E+03_JPRB,1.9790E+03_JPRB,1.8747E+03_JPRB,1.7853E+03_JPRB,1.7084E+03_JPRB/)
KBO( :,13,16) = (/&
&5.7032E+02_JPRB,5.5610E+02_JPRB,5.4108E+02_JPRB,5.2545E+02_JPRB,5.0988E+02_JPRB/)
KBO( :,14,16) = (/&
&6.6729E+02_JPRB,6.4906E+02_JPRB,6.2994E+02_JPRB,6.1106E+02_JPRB,5.9252E+02_JPRB/)
KBO( :,15,16) = (/&
&7.7710E+02_JPRB,7.5381E+02_JPRB,7.3065E+02_JPRB,7.0752E+02_JPRB,6.8404E+02_JPRB/)
KBO( :,16,16) = (/&
&8.9983E+02_JPRB,8.7150E+02_JPRB,8.4258E+02_JPRB,8.1329E+02_JPRB,7.9266E+02_JPRB/)
KBO( :,17,16) = (/&
&1.0356E+03_JPRB,9.9960E+02_JPRB,9.6297E+02_JPRB,9.3112E+02_JPRB,9.3376E+02_JPRB/)
KBO( :,18,16) = (/&
&1.1805E+03_JPRB,1.1349E+03_JPRB,1.0927E+03_JPRB,1.0913E+03_JPRB,1.1178E+03_JPRB/)
KBO( :,19,16) = (/&
&1.3301E+03_JPRB,1.2743E+03_JPRB,1.2636E+03_JPRB,1.2905E+03_JPRB,1.3412E+03_JPRB/)
KBO( :,20,16) = (/&
&1.4790E+03_JPRB,1.4325E+03_JPRB,1.4416E+03_JPRB,1.4834E+03_JPRB,1.5509E+03_JPRB/)
KBO( :,21,16) = (/&
&1.6248E+03_JPRB,1.6005E+03_JPRB,1.6227E+03_JPRB,1.6765E+03_JPRB,1.7801E+03_JPRB/)
KBO( :,22,16) = (/&
&1.7789E+03_JPRB,1.7751E+03_JPRB,1.8121E+03_JPRB,1.8963E+03_JPRB,2.0533E+03_JPRB/)
KBO( :,23,16) = (/&
&1.9420E+03_JPRB,1.9550E+03_JPRB,2.0171E+03_JPRB,2.1515E+03_JPRB,2.3736E+03_JPRB/)
KBO( :,24,16) = (/&
&2.1057E+03_JPRB,2.1395E+03_JPRB,2.2516E+03_JPRB,2.4478E+03_JPRB,2.7312E+03_JPRB/)
KBO( :,25,16) = (/&
&2.2727E+03_JPRB,2.3487E+03_JPRB,2.5135E+03_JPRB,2.7876E+03_JPRB,3.1353E+03_JPRB/)
KBO( :,26,16) = (/&
&2.4430E+03_JPRB,2.5769E+03_JPRB,2.8118E+03_JPRB,3.1571E+03_JPRB,3.5871E+03_JPRB/)
KBO( :,27,16) = (/&
&2.6427E+03_JPRB,2.8396E+03_JPRB,3.1669E+03_JPRB,3.5883E+03_JPRB,4.0930E+03_JPRB/)
KBO( :,28,16) = (/&
&2.8823E+03_JPRB,3.1635E+03_JPRB,3.5805E+03_JPRB,4.0928E+03_JPRB,4.6511E+03_JPRB/)
KBO( :,29,16) = (/&
&3.1912E+03_JPRB,3.5861E+03_JPRB,4.1049E+03_JPRB,4.7016E+03_JPRB,5.3176E+03_JPRB/)
KBO( :,30,16) = (/&
&3.5968E+03_JPRB,4.1208E+03_JPRB,4.7628E+03_JPRB,5.4277E+03_JPRB,6.1129E+03_JPRB/)
KBO( :,31,16) = (/&
&4.1669E+03_JPRB,4.8568E+03_JPRB,5.5986E+03_JPRB,6.3508E+03_JPRB,7.1245E+03_JPRB/)
KBO( :,32,16) = (/&
&4.9181E+03_JPRB,5.7548E+03_JPRB,6.5943E+03_JPRB,7.4480E+03_JPRB,8.3250E+03_JPRB/)
KBO( :,33,16) = (/&
&5.8885E+03_JPRB,6.8470E+03_JPRB,7.8053E+03_JPRB,8.7780E+03_JPRB,9.7768E+03_JPRB/)
KBO( :,34,16) = (/&
&6.9635E+03_JPRB,8.0514E+03_JPRB,9.1398E+03_JPRB,1.0245E+04_JPRB,1.1380E+04_JPRB/)
KBO( :,35,16) = (/&
&8.1473E+03_JPRB,9.3881E+03_JPRB,1.0630E+04_JPRB,1.1894E+04_JPRB,1.3185E+04_JPRB/)
KBO( :,36,16) = (/&
&9.4364E+03_JPRB,1.0865E+04_JPRB,1.2293E+04_JPRB,1.3743E+04_JPRB,1.5227E+04_JPRB/)
KBO( :,37,16) = (/&
&9.8676E+03_JPRB,1.1389E+04_JPRB,1.2910E+04_JPRB,1.4442E+04_JPRB,1.6011E+04_JPRB/)
KBO( :,38,16) = (/&
&1.0288E+04_JPRB,1.1907E+04_JPRB,1.3518E+04_JPRB,1.5146E+04_JPRB,1.6802E+04_JPRB/)
KBO( :,39,16) = (/&
&1.0771E+04_JPRB,1.2499E+04_JPRB,1.4216E+04_JPRB,1.5954E+04_JPRB,1.7707E+04_JPRB/)
KBO( :,40,16) = (/&
&1.0414E+04_JPRB,1.2148E+04_JPRB,1.3875E+04_JPRB,1.5613E+04_JPRB,1.7368E+04_JPRB/)
KBO( :,41,16) = (/&
&9.9384E+03_JPRB,1.1661E+04_JPRB,1.3383E+04_JPRB,1.5104E+04_JPRB,1.6844E+04_JPRB/)
KBO( :,42,16) = (/&
&9.4612E+03_JPRB,1.1170E+04_JPRB,1.2888E+04_JPRB,1.4596E+04_JPRB,1.6317E+04_JPRB/)
KBO( :,43,16) = (/&
&8.7147E+03_JPRB,1.0370E+04_JPRB,1.2042E+04_JPRB,1.3705E+04_JPRB,1.5380E+04_JPRB/)
KBO( :,44,16) = (/&
&7.8820E+03_JPRB,9.4600E+03_JPRB,1.1070E+04_JPRB,1.2678E+04_JPRB,1.4284E+04_JPRB/)
KBO( :,45,16) = (/&
&7.0926E+03_JPRB,8.5904E+03_JPRB,1.0135E+04_JPRB,1.1689E+04_JPRB,1.3230E+04_JPRB/)
KBO( :,46,16) = (/&
&6.3333E+03_JPRB,7.7267E+03_JPRB,9.1993E+03_JPRB,1.0689E+04_JPRB,1.2169E+04_JPRB/)
KBO( :,47,16) = (/&
&5.6159E+03_JPRB,6.8398E+03_JPRB,8.2286E+03_JPRB,9.6499E+03_JPRB,1.1071E+04_JPRB/)
KBO( :,48,16) = (/&
&5.0469E+03_JPRB,6.0380E+03_JPRB,7.3127E+03_JPRB,8.6620E+03_JPRB,1.0021E+04_JPRB/)
KBO( :,49,16) = (/&
&4.6114E+03_JPRB,5.3556E+03_JPRB,6.4573E+03_JPRB,7.7273E+03_JPRB,9.0204E+03_JPRB/)
KBO( :,50,16) = (/&
&4.2827E+03_JPRB,4.8418E+03_JPRB,5.7290E+03_JPRB,6.8837E+03_JPRB,8.1065E+03_JPRB/)
KBO( :,51,16) = (/&
&4.0377E+03_JPRB,4.4505E+03_JPRB,5.1216E+03_JPRB,6.1118E+03_JPRB,7.2612E+03_JPRB/)
KBO( :,52,16) = (/&
&3.9027E+03_JPRB,4.1388E+03_JPRB,4.6373E+03_JPRB,5.4292E+03_JPRB,6.4624E+03_JPRB/)
KBO( :,53,16) = (/&
&3.8594E+03_JPRB,3.9014E+03_JPRB,4.2603E+03_JPRB,4.8496E+03_JPRB,5.7176E+03_JPRB/)
KBO( :,54,16) = (/&
&3.9053E+03_JPRB,3.7705E+03_JPRB,3.9739E+03_JPRB,4.4065E+03_JPRB,5.0959E+03_JPRB/)
KBO( :,55,16) = (/&
&4.0460E+03_JPRB,3.7217E+03_JPRB,3.7544E+03_JPRB,4.0660E+03_JPRB,4.5765E+03_JPRB/)
KBO( :,56,16) = (/&
&4.2054E+03_JPRB,3.7493E+03_JPRB,3.6207E+03_JPRB,3.7906E+03_JPRB,4.1568E+03_JPRB/)
KBO( :,57,16) = (/&
&4.3770E+03_JPRB,3.8799E+03_JPRB,3.5717E+03_JPRB,3.5790E+03_JPRB,3.8293E+03_JPRB/)
KBO( :,58,16) = (/&
&4.5510E+03_JPRB,4.0210E+03_JPRB,3.5972E+03_JPRB,3.4529E+03_JPRB,3.5736E+03_JPRB/)
KBO( :,59,16) = (/&
&4.6237E+03_JPRB,4.0799E+03_JPRB,3.6344E+03_JPRB,3.3958E+03_JPRB,3.4194E+03_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB9_BB
