!OCL SCALAR
SUBROUTINE RRTM_KGB9_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO9 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, ABSN2OO
USE YOERRTA9 , ONLY : N2OREF  ,H2OREF  ,CH4REF     ,ETAREF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 11, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&9.5159E-01_JPRB,8.6193E-01_JPRB,7.8445E-01_JPRB,7.0786E-01_JPRB,6.2475E-01_JPRB,5.4735E-01_JPRB,&
&4.7357E-01_JPRB,4.3191E-01_JPRB,4.5105E-01_JPRB,4.6500E-01_JPRB,4.7768E-01_JPRB/)
KAO( :, 2, 1, 9) = (/&
&9.4610E-01_JPRB,8.6636E-01_JPRB,7.9453E-01_JPRB,7.2334E-01_JPRB,6.4819E-01_JPRB,5.8098E-01_JPRB,&
&5.1867E-01_JPRB,5.0225E-01_JPRB,5.3434E-01_JPRB,5.5100E-01_JPRB,5.6593E-01_JPRB/)
KAO( :, 3, 1, 9) = (/&
&9.4063E-01_JPRB,8.6755E-01_JPRB,8.0500E-01_JPRB,7.3756E-01_JPRB,6.7496E-01_JPRB,6.1686E-01_JPRB,&
&5.7144E-01_JPRB,5.7997E-01_JPRB,6.2451E-01_JPRB,6.4411E-01_JPRB,6.6119E-01_JPRB/)
KAO( :, 4, 1, 9) = (/&
&9.3410E-01_JPRB,8.6712E-01_JPRB,8.1423E-01_JPRB,7.5391E-01_JPRB,7.0437E-01_JPRB,6.5593E-01_JPRB,&
&6.3263E-01_JPRB,6.6511E-01_JPRB,7.2065E-01_JPRB,7.4338E-01_JPRB,7.6295E-01_JPRB/)
KAO( :, 5, 1, 9) = (/&
&9.2639E-01_JPRB,8.6753E-01_JPRB,8.2122E-01_JPRB,7.7366E-01_JPRB,7.3498E-01_JPRB,7.0006E-01_JPRB,&
&7.0131E-01_JPRB,7.5726E-01_JPRB,8.2266E-01_JPRB,8.4882E-01_JPRB,8.7078E-01_JPRB/)
KAO( :, 1, 2, 9) = (/&
&9.9571E-01_JPRB,8.9920E-01_JPRB,8.1614E-01_JPRB,7.3263E-01_JPRB,6.4026E-01_JPRB,5.4806E-01_JPRB,&
&4.6027E-01_JPRB,3.9041E-01_JPRB,3.9261E-01_JPRB,4.0467E-01_JPRB,4.1298E-01_JPRB/)
KAO( :, 2, 2, 9) = (/&
&9.8996E-01_JPRB,9.0283E-01_JPRB,8.2671E-01_JPRB,7.4790E-01_JPRB,6.6191E-01_JPRB,5.7890E-01_JPRB,&
&4.9929E-01_JPRB,4.5184E-01_JPRB,4.6916E-01_JPRB,4.8383E-01_JPRB,4.9391E-01_JPRB/)
KAO( :, 3, 2, 9) = (/&
&9.8376E-01_JPRB,9.0392E-01_JPRB,8.3729E-01_JPRB,7.6239E-01_JPRB,6.8599E-01_JPRB,6.1186E-01_JPRB,&
&5.4354E-01_JPRB,5.2118E-01_JPRB,5.5194E-01_JPRB,5.6942E-01_JPRB,5.8138E-01_JPRB/)
KAO( :, 4, 2, 9) = (/&
&9.7691E-01_JPRB,9.0424E-01_JPRB,8.4680E-01_JPRB,7.7835E-01_JPRB,7.1309E-01_JPRB,6.4690E-01_JPRB,&
&5.9506E-01_JPRB,5.9772E-01_JPRB,6.4088E-01_JPRB,6.6141E-01_JPRB,6.7534E-01_JPRB/)
KAO( :, 5, 2, 9) = (/&
&9.6899E-01_JPRB,9.0591E-01_JPRB,8.5458E-01_JPRB,7.9701E-01_JPRB,7.4146E-01_JPRB,6.8466E-01_JPRB,&
&6.5376E-01_JPRB,6.8054E-01_JPRB,7.3475E-01_JPRB,7.5849E-01_JPRB,7.7486E-01_JPRB/)
KAO( :, 1, 3, 9) = (/&
&1.0405E+00_JPRB,9.3488E-01_JPRB,8.4463E-01_JPRB,7.5330E-01_JPRB,6.5244E-01_JPRB,5.4916E-01_JPRB,&
&4.4520E-01_JPRB,3.4870E-01_JPRB,3.2584E-01_JPRB,3.3543E-01_JPRB,3.3962E-01_JPRB/)
KAO( :, 2, 3, 9) = (/&
&1.0349E+00_JPRB,9.3892E-01_JPRB,8.5534E-01_JPRB,7.6913E-01_JPRB,6.7395E-01_JPRB,5.7625E-01_JPRB,&
&4.7914E-01_JPRB,3.9837E-01_JPRB,3.9325E-01_JPRB,4.0529E-01_JPRB,4.1035E-01_JPRB/)
KAO( :, 3, 3, 9) = (/&
&1.0286E+00_JPRB,9.4087E-01_JPRB,8.6735E-01_JPRB,7.8384E-01_JPRB,6.9647E-01_JPRB,6.0649E-01_JPRB,&
&5.1617E-01_JPRB,4.5626E-01_JPRB,4.6701E-01_JPRB,4.8157E-01_JPRB,4.8769E-01_JPRB/)
KAO( :, 4, 3, 9) = (/&
&1.0216E+00_JPRB,9.4194E-01_JPRB,8.7769E-01_JPRB,8.0047E-01_JPRB,7.2103E-01_JPRB,6.3769E-01_JPRB,&
&5.5844E-01_JPRB,5.2182E-01_JPRB,5.4652E-01_JPRB,5.6383E-01_JPRB,5.7106E-01_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.0137E+00_JPRB,9.4403E-01_JPRB,8.8589E-01_JPRB,8.1893E-01_JPRB,7.4713E-01_JPRB,6.7001E-01_JPRB,&
&6.0589E-01_JPRB,5.9289E-01_JPRB,6.3020E-01_JPRB,6.5037E-01_JPRB,6.5878E-01_JPRB/)
KAO( :, 1, 4, 9) = (/&
&1.0880E+00_JPRB,9.7313E-01_JPRB,8.7384E-01_JPRB,7.7222E-01_JPRB,6.6520E-01_JPRB,5.5149E-01_JPRB,&
&4.3468E-01_JPRB,3.1551E-01_JPRB,2.6473E-01_JPRB,2.7010E-01_JPRB,2.7211E-01_JPRB/)
KAO( :, 2, 4, 9) = (/&
&1.0823E+00_JPRB,9.7690E-01_JPRB,8.8415E-01_JPRB,7.9011E-01_JPRB,6.8589E-01_JPRB,5.7725E-01_JPRB,&
&4.6480E-01_JPRB,3.5528E-01_JPRB,3.2290E-01_JPRB,3.3154E-01_JPRB,3.3402E-01_JPRB/)
KAO( :, 3, 4, 9) = (/&
&1.0759E+00_JPRB,9.7896E-01_JPRB,8.9677E-01_JPRB,8.0590E-01_JPRB,7.0747E-01_JPRB,6.0512E-01_JPRB,&
&4.9649E-01_JPRB,4.0248E-01_JPRB,3.8741E-01_JPRB,3.9884E-01_JPRB,4.0190E-01_JPRB/)
KAO( :, 4, 4, 9) = (/&
&1.0687E+00_JPRB,9.8058E-01_JPRB,9.0886E-01_JPRB,8.2235E-01_JPRB,7.3113E-01_JPRB,6.3357E-01_JPRB,&
&5.3180E-01_JPRB,4.5630E-01_JPRB,4.5720E-01_JPRB,4.7127E-01_JPRB,4.7487E-01_JPRB/)
KAO( :, 5, 4, 9) = (/&
&1.0611E+00_JPRB,9.8340E-01_JPRB,9.1796E-01_JPRB,8.4063E-01_JPRB,7.5604E-01_JPRB,6.6259E-01_JPRB,&
&5.7101E-01_JPRB,5.1566E-01_JPRB,5.3169E-01_JPRB,5.4837E-01_JPRB,5.5265E-01_JPRB/)
KAO( :, 1, 5, 9) = (/&
&1.1353E+00_JPRB,1.0122E+00_JPRB,9.0436E-01_JPRB,7.9314E-01_JPRB,6.7788E-01_JPRB,5.5661E-01_JPRB,&
&4.2870E-01_JPRB,2.9193E-01_JPRB,2.1579E-01_JPRB,2.1412E-01_JPRB,2.1527E-01_JPRB/)
KAO( :, 2, 5, 9) = (/&
&1.1302E+00_JPRB,1.0164E+00_JPRB,9.1463E-01_JPRB,8.1125E-01_JPRB,6.9965E-01_JPRB,5.8117E-01_JPRB,&
&4.5601E-01_JPRB,3.2431E-01_JPRB,2.6337E-01_JPRB,2.6679E-01_JPRB,2.6824E-01_JPRB/)
KAO( :, 3, 5, 9) = (/&
&1.1241E+00_JPRB,1.0191E+00_JPRB,9.2734E-01_JPRB,8.2845E-01_JPRB,7.2101E-01_JPRB,6.0737E-01_JPRB,&
&4.8451E-01_JPRB,3.6228E-01_JPRB,3.1806E-01_JPRB,3.2529E-01_JPRB,3.2713E-01_JPRB/)
KAO( :, 4, 5, 9) = (/&
&1.1173E+00_JPRB,1.0209E+00_JPRB,9.4019E-01_JPRB,8.4617E-01_JPRB,7.4384E-01_JPRB,6.3435E-01_JPRB,&
&5.1515E-01_JPRB,4.0564E-01_JPRB,3.7849E-01_JPRB,3.8902E-01_JPRB,3.9122E-01_JPRB/)
KAO( :, 5, 5, 9) = (/&
&1.1101E+00_JPRB,1.0243E+00_JPRB,9.5096E-01_JPRB,8.6410E-01_JPRB,7.6849E-01_JPRB,6.6158E-01_JPRB,&
&5.4858E-01_JPRB,4.5511E-01_JPRB,4.4484E-01_JPRB,4.5817E-01_JPRB,4.6081E-01_JPRB/)
KAO( :, 1, 6, 9) = (/&
&1.1806E+00_JPRB,1.0498E+00_JPRB,9.3337E-01_JPRB,8.1273E-01_JPRB,6.8998E-01_JPRB,5.6047E-01_JPRB,&
&4.2456E-01_JPRB,2.7532E-01_JPRB,1.7725E-01_JPRB,1.6538E-01_JPRB,1.6672E-01_JPRB/)
KAO( :, 2, 6, 9) = (/&
&1.1761E+00_JPRB,1.0541E+00_JPRB,9.4371E-01_JPRB,8.3128E-01_JPRB,7.1158E-01_JPRB,5.8532E-01_JPRB,&
&4.4996E-01_JPRB,3.0144E-01_JPRB,2.1482E-01_JPRB,2.0943E-01_JPRB,2.1089E-01_JPRB/)
KAO( :, 3, 6, 9) = (/&
&1.1706E+00_JPRB,1.0579E+00_JPRB,9.5635E-01_JPRB,8.4936E-01_JPRB,7.3343E-01_JPRB,6.1037E-01_JPRB,&
&4.7682E-01_JPRB,3.3219E-01_JPRB,2.5890E-01_JPRB,2.5930E-01_JPRB,2.6088E-01_JPRB/)
KAO( :, 4, 6, 9) = (/&
&1.1647E+00_JPRB,1.0607E+00_JPRB,9.7013E-01_JPRB,8.6759E-01_JPRB,7.5661E-01_JPRB,6.3681E-01_JPRB,&
&5.0490E-01_JPRB,3.6744E-01_JPRB,3.0939E-01_JPRB,3.1452E-01_JPRB,3.1634E-01_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.1580E+00_JPRB,1.0646E+00_JPRB,9.8251E-01_JPRB,8.8607E-01_JPRB,7.8101E-01_JPRB,6.6342E-01_JPRB,&
&5.3428E-01_JPRB,4.0750E-01_JPRB,3.6653E-01_JPRB,3.7539E-01_JPRB,3.7760E-01_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.2136E+00_JPRB,1.0774E+00_JPRB,9.5377E-01_JPRB,8.2536E-01_JPRB,6.9593E-01_JPRB,5.6078E-01_JPRB,&
&4.1863E-01_JPRB,2.6313E-01_JPRB,1.4935E-01_JPRB,1.2578E-01_JPRB,1.4257E-01_JPRB/)
KAO( :, 2, 7, 9) = (/&
&1.2100E+00_JPRB,1.0820E+00_JPRB,9.6432E-01_JPRB,8.4363E-01_JPRB,7.1756E-01_JPRB,5.8508E-01_JPRB,&
&4.4339E-01_JPRB,2.8645E-01_JPRB,1.7844E-01_JPRB,1.6196E-01_JPRB,1.7527E-01_JPRB/)
KAO( :, 3, 7, 9) = (/&
&1.2053E+00_JPRB,1.0866E+00_JPRB,9.7664E-01_JPRB,8.6237E-01_JPRB,7.3986E-01_JPRB,6.1018E-01_JPRB,&
&4.6912E-01_JPRB,3.1223E-01_JPRB,2.1332E-01_JPRB,2.0363E-01_JPRB,2.1371E-01_JPRB/)
KAO( :, 4, 7, 9) = (/&
&1.1998E+00_JPRB,1.0903E+00_JPRB,9.9072E-01_JPRB,8.8131E-01_JPRB,7.6315E-01_JPRB,6.3674E-01_JPRB,&
&4.9590E-01_JPRB,3.4090E-01_JPRB,2.5438E-01_JPRB,2.5086E-01_JPRB,2.5825E-01_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.1932E+00_JPRB,1.0942E+00_JPRB,1.0040E+00_JPRB,9.0033E-01_JPRB,7.8781E-01_JPRB,6.6359E-01_JPRB,&
&5.2347E-01_JPRB,3.7392E-01_JPRB,3.0186E-01_JPRB,3.0359E-01_JPRB,3.0908E-01_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.2316E+00_JPRB,1.0924E+00_JPRB,9.6349E-01_JPRB,8.3019E-01_JPRB,6.9548E-01_JPRB,5.5575E-01_JPRB,&
&4.1003E-01_JPRB,2.5191E-01_JPRB,1.3039E-01_JPRB,9.5856E-02_JPRB,1.7533E-01_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.2282E+00_JPRB,1.0969E+00_JPRB,9.7419E-01_JPRB,8.4770E-01_JPRB,7.1665E-01_JPRB,5.7977E-01_JPRB,&
&4.3430E-01_JPRB,2.7347E-01_JPRB,1.5278E-01_JPRB,1.2456E-01_JPRB,2.0121E-01_JPRB/)
KAO( :, 3, 8, 9) = (/&
&1.2234E+00_JPRB,1.1017E+00_JPRB,9.8619E-01_JPRB,8.6635E-01_JPRB,7.3926E-01_JPRB,6.0504E-01_JPRB,&
&4.5959E-01_JPRB,2.9702E-01_JPRB,1.8008E-01_JPRB,1.5872E-01_JPRB,2.2963E-01_JPRB/)
KAO( :, 4, 8, 9) = (/&
&1.2179E+00_JPRB,1.1058E+00_JPRB,1.0001E+00_JPRB,8.8559E-01_JPRB,7.6296E-01_JPRB,6.3135E-01_JPRB,&
&4.8567E-01_JPRB,3.2261E-01_JPRB,2.1292E-01_JPRB,1.9834E-01_JPRB,2.6180E-01_JPRB/)
KAO( :, 5, 8, 9) = (/&
&1.2113E+00_JPRB,1.1100E+00_JPRB,1.0138E+00_JPRB,9.0571E-01_JPRB,7.8768E-01_JPRB,6.5815E-01_JPRB,&
&5.1266E-01_JPRB,3.5055E-01_JPRB,2.5143E-01_JPRB,2.4311E-01_JPRB,2.9921E-01_JPRB/)
KAO( :, 1, 9, 9) = (/&
&1.2312E+00_JPRB,1.0915E+00_JPRB,9.6019E-01_JPRB,8.2497E-01_JPRB,6.8804E-01_JPRB,5.4659E-01_JPRB,&
&3.9889E-01_JPRB,2.4010E-01_JPRB,1.1745E-01_JPRB,7.4115E-02_JPRB,3.8570E-01_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.2271E+00_JPRB,1.0952E+00_JPRB,9.7062E-01_JPRB,8.4182E-01_JPRB,7.0896E-01_JPRB,5.7001E-01_JPRB,&
&4.2261E-01_JPRB,2.6038E-01_JPRB,1.3539E-01_JPRB,9.6435E-02_JPRB,4.2073E-01_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.2221E+00_JPRB,1.0999E+00_JPRB,9.8223E-01_JPRB,8.6047E-01_JPRB,7.3167E-01_JPRB,5.9531E-01_JPRB,&
&4.4692E-01_JPRB,2.8236E-01_JPRB,1.5682E-01_JPRB,1.2365E-01_JPRB,4.5798E-01_JPRB/)
KAO( :, 4, 9, 9) = (/&
&1.2168E+00_JPRB,1.1048E+00_JPRB,9.9655E-01_JPRB,8.8042E-01_JPRB,7.5597E-01_JPRB,6.2078E-01_JPRB,&
&4.7224E-01_JPRB,3.0619E-01_JPRB,1.8270E-01_JPRB,1.5583E-01_JPRB,4.9794E-01_JPRB/)
KAO( :, 5, 9, 9) = (/&
&1.2103E+00_JPRB,1.1097E+00_JPRB,1.0110E+00_JPRB,9.0113E-01_JPRB,7.8074E-01_JPRB,6.4684E-01_JPRB,&
&4.9870E-01_JPRB,3.3189E-01_JPRB,2.1333E-01_JPRB,1.9294E-01_JPRB,5.3980E-01_JPRB/)
KAO( :, 1,10, 9) = (/&
&1.2065E+00_JPRB,1.0698E+00_JPRB,9.3983E-01_JPRB,8.0628E-01_JPRB,6.7075E-01_JPRB,5.3108E-01_JPRB,&
&3.8524E-01_JPRB,2.2846E-01_JPRB,1.0759E-01_JPRB,6.0114E-02_JPRB,1.2134E+00_JPRB/)
KAO( :, 2,10, 9) = (/&
&1.2021E+00_JPRB,1.0732E+00_JPRB,9.5006E-01_JPRB,8.2241E-01_JPRB,6.9118E-01_JPRB,5.5381E-01_JPRB,&
&4.0835E-01_JPRB,2.4753E-01_JPRB,1.2339E-01_JPRB,7.7390E-02_JPRB,1.2525E+00_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.1979E+00_JPRB,1.0788E+00_JPRB,9.6194E-01_JPRB,8.4108E-01_JPRB,7.1368E-01_JPRB,5.7871E-01_JPRB,&
&4.3197E-01_JPRB,2.6832E-01_JPRB,1.4165E-01_JPRB,9.8913E-02_JPRB,1.2959E+00_JPRB/)
KAO( :, 4,10, 9) = (/&
&1.1924E+00_JPRB,1.0841E+00_JPRB,9.7645E-01_JPRB,8.6142E-01_JPRB,7.3813E-01_JPRB,6.0416E-01_JPRB,&
&4.5629E-01_JPRB,2.9111E-01_JPRB,1.6279E-01_JPRB,1.2496E-01_JPRB,1.3457E+00_JPRB/)
KAO( :, 5,10, 9) = (/&
&1.1868E+00_JPRB,1.0895E+00_JPRB,9.9148E-01_JPRB,8.8237E-01_JPRB,7.6307E-01_JPRB,6.3026E-01_JPRB,&
&4.8193E-01_JPRB,3.1564E-01_JPRB,1.8743E-01_JPRB,1.5518E-01_JPRB,1.4010E+00_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.1602E+00_JPRB,1.0321E+00_JPRB,9.0888E-01_JPRB,7.8134E-01_JPRB,6.5183E-01_JPRB,5.1709E-01_JPRB,&
&3.7632E-01_JPRB,2.2357E-01_JPRB,1.0454E-01_JPRB,5.6265E-02_JPRB,1.7556E+00_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.1566E+00_JPRB,1.0373E+00_JPRB,9.1992E-01_JPRB,7.9870E-01_JPRB,6.7250E-01_JPRB,5.3982E-01_JPRB,&
&3.9883E-01_JPRB,2.4238E-01_JPRB,1.1972E-01_JPRB,7.0995E-02_JPRB,1.7896E+00_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.1521E+00_JPRB,1.0433E+00_JPRB,9.3315E-01_JPRB,8.1800E-01_JPRB,6.9552E-01_JPRB,5.6467E-01_JPRB,&
&4.2241E-01_JPRB,2.6285E-01_JPRB,1.3701E-01_JPRB,8.9495E-02_JPRB,1.8345E+00_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.1472E+00_JPRB,1.0489E+00_JPRB,9.4806E-01_JPRB,8.3843E-01_JPRB,7.1973E-01_JPRB,5.9025E-01_JPRB,&
&4.4701E-01_JPRB,2.8499E-01_JPRB,1.5648E-01_JPRB,1.1176E-01_JPRB,1.8895E+00_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.1436E+00_JPRB,1.0565E+00_JPRB,9.6473E-01_JPRB,8.6013E-01_JPRB,7.4475E-01_JPRB,6.1626E-01_JPRB,&
&4.7243E-01_JPRB,3.0896E-01_JPRB,1.7805E-01_JPRB,1.3759E-01_JPRB,1.9545E+00_JPRB/)
KAO( :, 1,12, 9) = (/&
&1.0927E+00_JPRB,9.7589E-01_JPRB,8.6130E-01_JPRB,7.4238E-01_JPRB,6.2051E-01_JPRB,4.9305E-01_JPRB,&
&3.5975E-01_JPRB,2.1463E-01_JPRB,1.0064E-01_JPRB,5.3171E-02_JPRB,1.9140E+00_JPRB/)
KAO( :, 2,12, 9) = (/&
&1.0892E+00_JPRB,9.8224E-01_JPRB,8.7322E-01_JPRB,7.6047E-01_JPRB,6.4152E-01_JPRB,5.1615E-01_JPRB,&
&3.8192E-01_JPRB,2.3322E-01_JPRB,1.1514E-01_JPRB,6.5840E-02_JPRB,1.9498E+00_JPRB/)
KAO( :, 3,12, 9) = (/&
&1.0852E+00_JPRB,9.8827E-01_JPRB,8.8733E-01_JPRB,7.7978E-01_JPRB,6.6433E-01_JPRB,5.4034E-01_JPRB,&
&4.0501E-01_JPRB,2.5357E-01_JPRB,1.3154E-01_JPRB,8.1554E-02_JPRB,2.0010E+00_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.0828E+00_JPRB,9.9622E-01_JPRB,9.0368E-01_JPRB,8.0090E-01_JPRB,6.8832E-01_JPRB,5.6535E-01_JPRB,&
&4.2922E-01_JPRB,2.7541E-01_JPRB,1.4957E-01_JPRB,1.0036E-01_JPRB,2.0646E+00_JPRB/)
KAO( :, 5,12, 9) = (/&
&1.0799E+00_JPRB,1.0059E+00_JPRB,9.2157E-01_JPRB,8.2344E-01_JPRB,7.1363E-01_JPRB,5.9111E-01_JPRB,&
&4.5461E-01_JPRB,2.9875E-01_JPRB,1.6950E-01_JPRB,1.2252E-01_JPRB,2.1387E+00_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.0003E+00_JPRB,8.9827E-01_JPRB,7.9453E-01_JPRB,6.8742E-01_JPRB,5.7557E-01_JPRB,4.5851E-01_JPRB,&
&3.3514E-01_JPRB,2.0061E-01_JPRB,9.5403E-02_JPRB,5.0265E-02_JPRB,1.6361E+00_JPRB/)
KAO( :, 2,13, 9) = (/&
&9.9751E-01_JPRB,9.0481E-01_JPRB,8.0727E-01_JPRB,7.0499E-01_JPRB,5.9591E-01_JPRB,4.8058E-01_JPRB,&
&3.5629E-01_JPRB,2.1887E-01_JPRB,1.0898E-01_JPRB,6.1395E-02_JPRB,1.6789E+00_JPRB/)
KAO( :, 3,13, 9) = (/&
&9.9614E-01_JPRB,9.1298E-01_JPRB,8.2308E-01_JPRB,7.2470E-01_JPRB,6.1846E-01_JPRB,5.0385E-01_JPRB,&
&3.7856E-01_JPRB,2.3882E-01_JPRB,1.2434E-01_JPRB,7.4760E-02_JPRB,1.7343E+00_JPRB/)
KAO( :, 4,13, 9) = (/&
&9.9388E-01_JPRB,9.2211E-01_JPRB,8.4003E-01_JPRB,7.4638E-01_JPRB,6.4247E-01_JPRB,5.2829E-01_JPRB,&
&4.0218E-01_JPRB,2.6010E-01_JPRB,1.4124E-01_JPRB,9.0738E-02_JPRB,1.8018E+00_JPRB/)
KAO( :, 5,13, 9) = (/&
&9.9133E-01_JPRB,9.3236E-01_JPRB,8.5728E-01_JPRB,7.6831E-01_JPRB,6.6718E-01_JPRB,5.5353E-01_JPRB,&
&4.2726E-01_JPRB,2.8267E-01_JPRB,1.5974E-01_JPRB,1.0946E-01_JPRB,1.8787E+00_JPRB/)
KAO( :, 1, 1,10) = (/&
&1.4571E+00_JPRB,1.2985E+00_JPRB,1.1908E+00_JPRB,1.0846E+00_JPRB,1.0480E+00_JPRB,9.7569E-01_JPRB,&
&9.5294E-01_JPRB,1.0946E+00_JPRB,1.1970E+00_JPRB,1.2341E+00_JPRB,1.2515E+00_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.4234E+00_JPRB,1.2781E+00_JPRB,1.1865E+00_JPRB,1.1317E+00_JPRB,1.1150E+00_JPRB,1.0495E+00_JPRB,&
&1.1148E+00_JPRB,1.2924E+00_JPRB,1.4136E+00_JPRB,1.4576E+00_JPRB,1.4767E+00_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.3920E+00_JPRB,1.2691E+00_JPRB,1.1852E+00_JPRB,1.1966E+00_JPRB,1.1609E+00_JPRB,1.1524E+00_JPRB,&
&1.2953E+00_JPRB,1.5017E+00_JPRB,1.6423E+00_JPRB,1.6923E+00_JPRB,1.7109E+00_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.3678E+00_JPRB,1.2658E+00_JPRB,1.2088E+00_JPRB,1.2463E+00_JPRB,1.2126E+00_JPRB,1.2713E+00_JPRB,&
&1.4845E+00_JPRB,1.7225E+00_JPRB,1.8842E+00_JPRB,1.9406E+00_JPRB,1.9546E+00_JPRB/)
KAO( :, 5, 1,10) = (/&
&1.3506E+00_JPRB,1.2582E+00_JPRB,1.2509E+00_JPRB,1.2864E+00_JPRB,1.2835E+00_JPRB,1.4126E+00_JPRB,&
&1.6783E+00_JPRB,1.9484E+00_JPRB,2.1328E+00_JPRB,2.1974E+00_JPRB,2.2094E+00_JPRB/)
KAO( :, 1, 2,10) = (/&
&1.5647E+00_JPRB,1.3899E+00_JPRB,1.2609E+00_JPRB,1.1489E+00_JPRB,1.0577E+00_JPRB,9.7853E-01_JPRB,&
&8.8718E-01_JPRB,9.8958E-01_JPRB,1.0824E+00_JPRB,1.1177E+00_JPRB,1.1363E+00_JPRB/)
KAO( :, 2, 2,10) = (/&
&1.5359E+00_JPRB,1.3755E+00_JPRB,1.2594E+00_JPRB,1.1862E+00_JPRB,1.1175E+00_JPRB,1.0395E+00_JPRB,&
&1.0286E+00_JPRB,1.1844E+00_JPRB,1.2956E+00_JPRB,1.3363E+00_JPRB,1.3552E+00_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.5095E+00_JPRB,1.3719E+00_JPRB,1.2702E+00_JPRB,1.2294E+00_JPRB,1.1716E+00_JPRB,1.1207E+00_JPRB,&
&1.2069E+00_JPRB,1.4002E+00_JPRB,1.5313E+00_JPRB,1.5789E+00_JPRB,1.5968E+00_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.4881E+00_JPRB,1.3707E+00_JPRB,1.2904E+00_JPRB,1.2704E+00_JPRB,1.2297E+00_JPRB,1.2284E+00_JPRB,&
&1.3999E+00_JPRB,1.6237E+00_JPRB,1.7765E+00_JPRB,1.8314E+00_JPRB,1.8527E+00_JPRB/)
KAO( :, 5, 2,10) = (/&
&1.4712E+00_JPRB,1.3632E+00_JPRB,1.3184E+00_JPRB,1.3082E+00_JPRB,1.2921E+00_JPRB,1.3673E+00_JPRB,&
&1.6066E+00_JPRB,1.8637E+00_JPRB,2.0388E+00_JPRB,2.1005E+00_JPRB,2.1202E+00_JPRB/)
KAO( :, 1, 3,10) = (/&
&1.6996E+00_JPRB,1.5099E+00_JPRB,1.3576E+00_JPRB,1.2090E+00_JPRB,1.0921E+00_JPRB,9.6189E-01_JPRB,&
&8.2495E-01_JPRB,8.5120E-01_JPRB,9.3114E-01_JPRB,9.6079E-01_JPRB,9.7144E-01_JPRB/)
KAO( :, 2, 3,10) = (/&
&1.6714E+00_JPRB,1.4913E+00_JPRB,1.3572E+00_JPRB,1.2562E+00_JPRB,1.1313E+00_JPRB,1.0225E+00_JPRB,&
&9.3378E-01_JPRB,1.0377E+00_JPRB,1.1351E+00_JPRB,1.1715E+00_JPRB,1.1847E+00_JPRB/)
KAO( :, 3, 3,10) = (/&
&1.6464E+00_JPRB,1.4878E+00_JPRB,1.3648E+00_JPRB,1.2864E+00_JPRB,1.1805E+00_JPRB,1.0851E+00_JPRB,&
&1.0848E+00_JPRB,1.2467E+00_JPRB,1.3633E+00_JPRB,1.4058E+00_JPRB,1.4211E+00_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.6254E+00_JPRB,1.4868E+00_JPRB,1.3919E+00_JPRB,1.3095E+00_JPRB,1.2349E+00_JPRB,1.1776E+00_JPRB,&
&1.2699E+00_JPRB,1.4722E+00_JPRB,1.6102E+00_JPRB,1.6602E+00_JPRB,1.6774E+00_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.6074E+00_JPRB,1.4842E+00_JPRB,1.4163E+00_JPRB,1.3403E+00_JPRB,1.2931E+00_JPRB,1.3071E+00_JPRB,&
&1.4856E+00_JPRB,1.7228E+00_JPRB,1.8845E+00_JPRB,1.9421E+00_JPRB,1.9615E+00_JPRB/)
KAO( :, 1, 4,10) = (/&
&1.8323E+00_JPRB,1.6281E+00_JPRB,1.4618E+00_JPRB,1.2952E+00_JPRB,1.1419E+00_JPRB,9.7127E-01_JPRB,&
&7.8485E-01_JPRB,7.2735E-01_JPRB,7.9434E-01_JPRB,8.1908E-01_JPRB,8.2678E-01_JPRB/)
KAO( :, 2, 4,10) = (/&
&1.8090E+00_JPRB,1.6115E+00_JPRB,1.4679E+00_JPRB,1.3303E+00_JPRB,1.1865E+00_JPRB,1.0111E+00_JPRB,&
&8.6551E-01_JPRB,8.9427E-01_JPRB,9.7752E-01_JPRB,1.0078E+00_JPRB,1.0171E+00_JPRB/)
KAO( :, 3, 4,10) = (/&
&1.7889E+00_JPRB,1.6155E+00_JPRB,1.4723E+00_JPRB,1.3642E+00_JPRB,1.2203E+00_JPRB,1.0626E+00_JPRB,&
&9.8912E-01_JPRB,1.0844E+00_JPRB,1.1852E+00_JPRB,1.2230E+00_JPRB,1.2342E+00_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.7702E+00_JPRB,1.6167E+00_JPRB,1.4947E+00_JPRB,1.3909E+00_JPRB,1.2565E+00_JPRB,1.1410E+00_JPRB,&
&1.1388E+00_JPRB,1.2955E+00_JPRB,1.4168E+00_JPRB,1.4624E+00_JPRB,1.4761E+00_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.7501E+00_JPRB,1.6097E+00_JPRB,1.5232E+00_JPRB,1.4123E+00_JPRB,1.3009E+00_JPRB,1.2498E+00_JPRB,&
&1.3238E+00_JPRB,1.5313E+00_JPRB,1.6751E+00_JPRB,1.7296E+00_JPRB,1.7455E+00_JPRB/)
KAO( :, 1, 5,10) = (/&
&1.9828E+00_JPRB,1.7589E+00_JPRB,1.5692E+00_JPRB,1.3787E+00_JPRB,1.1995E+00_JPRB,9.9912E-01_JPRB,&
&7.7673E-01_JPRB,6.3208E-01_JPRB,6.6656E-01_JPRB,6.8788E-01_JPRB,6.9344E-01_JPRB/)
KAO( :, 2, 5,10) = (/&
&1.9634E+00_JPRB,1.7445E+00_JPRB,1.5796E+00_JPRB,1.4090E+00_JPRB,1.2375E+00_JPRB,1.0422E+00_JPRB,&
&8.3265E-01_JPRB,7.6892E-01_JPRB,8.3508E-01_JPRB,8.6158E-01_JPRB,8.6855E-01_JPRB/)
KAO( :, 3, 5,10) = (/&
&1.9451E+00_JPRB,1.7488E+00_JPRB,1.5830E+00_JPRB,1.4394E+00_JPRB,1.2778E+00_JPRB,1.0801E+00_JPRB,&
&9.2394E-01_JPRB,9.3676E-01_JPRB,1.0236E+00_JPRB,1.0564E+00_JPRB,1.0650E+00_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.9265E+00_JPRB,1.7517E+00_JPRB,1.6023E+00_JPRB,1.4639E+00_JPRB,1.3153E+00_JPRB,1.1360E+00_JPRB,&
&1.0450E+00_JPRB,1.1261E+00_JPRB,1.2312E+00_JPRB,1.2708E+00_JPRB,1.2815E+00_JPRB/)
KAO( :, 5, 5,10) = (/&
&1.9040E+00_JPRB,1.7416E+00_JPRB,1.6301E+00_JPRB,1.4960E+00_JPRB,1.3496E+00_JPRB,1.2128E+00_JPRB,&
&1.1890E+00_JPRB,1.3318E+00_JPRB,1.4563E+00_JPRB,1.5043E+00_JPRB,1.5161E+00_JPRB/)
KAO( :, 1, 6,10) = (/&
&2.1467E+00_JPRB,1.9004E+00_JPRB,1.6825E+00_JPRB,1.4649E+00_JPRB,1.2465E+00_JPRB,1.0269E+00_JPRB,&
&7.8605E-01_JPRB,5.5785E-01_JPRB,5.4603E-01_JPRB,5.6364E-01_JPRB,5.6772E-01_JPRB/)
KAO( :, 2, 6,10) = (/&
&2.1281E+00_JPRB,1.8881E+00_JPRB,1.6957E+00_JPRB,1.4846E+00_JPRB,1.2828E+00_JPRB,1.0659E+00_JPRB,&
&8.3980E-01_JPRB,6.6949E-01_JPRB,6.9629E-01_JPRB,7.1873E-01_JPRB,7.2407E-01_JPRB/)
KAO( :, 3, 6,10) = (/&
&2.1101E+00_JPRB,1.8868E+00_JPRB,1.6967E+00_JPRB,1.5129E+00_JPRB,1.3220E+00_JPRB,1.1137E+00_JPRB,&
&9.0037E-01_JPRB,8.0396E-01_JPRB,8.6638E-01_JPRB,8.9449E-01_JPRB,9.0065E-01_JPRB/)
KAO( :, 4, 6,10) = (/&
&2.0853E+00_JPRB,1.8860E+00_JPRB,1.7059E+00_JPRB,1.5431E+00_JPRB,1.3571E+00_JPRB,1.1686E+00_JPRB,&
&9.8228E-01_JPRB,9.6588E-01_JPRB,1.0545E+00_JPRB,1.0886E+00_JPRB,1.0960E+00_JPRB/)
KAO( :, 5, 6,10) = (/&
&2.0580E+00_JPRB,1.8736E+00_JPRB,1.7305E+00_JPRB,1.5756E+00_JPRB,1.3997E+00_JPRB,1.2303E+00_JPRB,&
&1.0965E+00_JPRB,1.1472E+00_JPRB,1.2529E+00_JPRB,1.2937E+00_JPRB,1.3014E+00_JPRB/)
KAO( :, 1, 7,10) = (/&
&2.2844E+00_JPRB,2.0203E+00_JPRB,1.7798E+00_JPRB,1.5404E+00_JPRB,1.2929E+00_JPRB,1.0469E+00_JPRB,&
&7.9236E-01_JPRB,5.2961E-01_JPRB,4.3906E-01_JPRB,4.5269E-01_JPRB,4.5518E-01_JPRB/)
KAO( :, 2, 7,10) = (/&
&2.2660E+00_JPRB,2.0078E+00_JPRB,1.7931E+00_JPRB,1.5555E+00_JPRB,1.3285E+00_JPRB,1.0902E+00_JPRB,&
&8.4669E-01_JPRB,5.9963E-01_JPRB,5.6851E-01_JPRB,5.8633E-01_JPRB,5.8943E-01_JPRB/)
KAO( :, 3, 7,10) = (/&
&2.2458E+00_JPRB,2.0016E+00_JPRB,1.7952E+00_JPRB,1.5839E+00_JPRB,1.3724E+00_JPRB,1.1382E+00_JPRB,&
&9.0788E-01_JPRB,7.0219E-01_JPRB,7.1570E-01_JPRB,7.3889E-01_JPRB,7.4245E-01_JPRB/)
KAO( :, 4, 7,10) = (/&
&2.2171E+00_JPRB,2.0004E+00_JPRB,1.8020E+00_JPRB,1.6192E+00_JPRB,1.4137E+00_JPRB,1.1896E+00_JPRB,&
&9.7833E-01_JPRB,8.3274E-01_JPRB,8.7925E-01_JPRB,9.0812E-01_JPRB,9.1193E-01_JPRB/)
KAO( :, 5, 7,10) = (/&
&2.1959E+00_JPRB,1.9929E+00_JPRB,1.8261E+00_JPRB,1.6565E+00_JPRB,1.4548E+00_JPRB,1.2529E+00_JPRB,&
&1.0566E+00_JPRB,9.7505E-01_JPRB,1.0516E+00_JPRB,1.0862E+00_JPRB,1.0907E+00_JPRB/)
KAO( :, 1, 8,10) = (/&
&2.3885E+00_JPRB,2.1081E+00_JPRB,1.8478E+00_JPRB,1.5947E+00_JPRB,1.3299E+00_JPRB,1.0742E+00_JPRB,&
&7.9832E-01_JPRB,5.1485E-01_JPRB,3.4910E-01_JPRB,3.5166E-01_JPRB,4.0882E-01_JPRB/)
KAO( :, 2, 8,10) = (/&
&2.3816E+00_JPRB,2.1064E+00_JPRB,1.8710E+00_JPRB,1.6145E+00_JPRB,1.3755E+00_JPRB,1.1190E+00_JPRB,&
&8.5217E-01_JPRB,5.7569E-01_JPRB,4.5136E-01_JPRB,4.6418E-01_JPRB,4.8409E-01_JPRB/)
KAO( :, 3, 8,10) = (/&
&2.3652E+00_JPRB,2.1007E+00_JPRB,1.8806E+00_JPRB,1.6533E+00_JPRB,1.4207E+00_JPRB,1.1711E+00_JPRB,&
&9.0846E-01_JPRB,6.4219E-01_JPRB,5.7508E-01_JPRB,5.9368E-01_JPRB,5.9892E-01_JPRB/)
KAO( :, 4, 8,10) = (/&
&2.3476E+00_JPRB,2.1091E+00_JPRB,1.8906E+00_JPRB,1.6908E+00_JPRB,1.4662E+00_JPRB,1.2230E+00_JPRB,&
&9.7637E-01_JPRB,7.3139E-01_JPRB,7.1362E-01_JPRB,7.3716E-01_JPRB,7.4183E-01_JPRB/)
KAO( :, 5, 8,10) = (/&
&2.3384E+00_JPRB,2.1117E+00_JPRB,1.9201E+00_JPRB,1.7277E+00_JPRB,1.5122E+00_JPRB,1.2845E+00_JPRB,&
&1.0504E+00_JPRB,8.4237E-01_JPRB,8.6471E-01_JPRB,8.9254E-01_JPRB,8.9924E-01_JPRB/)
KAO( :, 1, 9,10) = (/&
&2.5386E+00_JPRB,2.2349E+00_JPRB,1.9481E+00_JPRB,1.6673E+00_JPRB,1.3731E+00_JPRB,1.0924E+00_JPRB,&
&8.0108E-01_JPRB,5.0383E-01_JPRB,2.8431E-01_JPRB,2.6546E-01_JPRB,1.0078E+00_JPRB/)
KAO( :, 2, 9,10) = (/&
&2.5451E+00_JPRB,2.2468E+00_JPRB,1.9792E+00_JPRB,1.6927E+00_JPRB,1.4190E+00_JPRB,1.1389E+00_JPRB,&
&8.5564E-01_JPRB,5.6069E-01_JPRB,3.5715E-01_JPRB,3.5572E-01_JPRB,1.1000E+00_JPRB/)
KAO( :, 3, 9,10) = (/&
&2.5371E+00_JPRB,2.2464E+00_JPRB,1.9929E+00_JPRB,1.7275E+00_JPRB,1.4622E+00_JPRB,1.1905E+00_JPRB,&
&9.1694E-01_JPRB,6.2032E-01_JPRB,4.5328E-01_JPRB,4.6281E-01_JPRB,1.1964E+00_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.5272E+00_JPRB,2.2578E+00_JPRB,2.0033E+00_JPRB,1.7607E+00_JPRB,1.5050E+00_JPRB,1.2522E+00_JPRB,&
&9.8282E-01_JPRB,6.8556E-01_JPRB,5.6762E-01_JPRB,5.8509E-01_JPRB,1.3014E+00_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.5219E+00_JPRB,2.2665E+00_JPRB,2.0326E+00_JPRB,1.7988E+00_JPRB,1.5562E+00_JPRB,1.3171E+00_JPRB,&
&1.0492E+00_JPRB,7.6013E-01_JPRB,7.0072E-01_JPRB,7.2284E-01_JPRB,1.4121E+00_JPRB/)
KAO( :, 1,10,10) = (/&
&2.7032E+00_JPRB,2.3752E+00_JPRB,2.0666E+00_JPRB,1.7582E+00_JPRB,1.4376E+00_JPRB,1.1282E+00_JPRB,&
&8.0844E-01_JPRB,4.9374E-01_JPRB,2.5722E-01_JPRB,2.0186E-01_JPRB,3.6688E+00_JPRB/)
KAO( :, 2,10,10) = (/&
&2.7107E+00_JPRB,2.3914E+00_JPRB,2.0994E+00_JPRB,1.7884E+00_JPRB,1.4847E+00_JPRB,1.1756E+00_JPRB,&
&8.5930E-01_JPRB,5.5140E-01_JPRB,3.0504E-01_JPRB,2.7555E-01_JPRB,3.7597E+00_JPRB/)
KAO( :, 3,10,10) = (/&
&2.7016E+00_JPRB,2.3907E+00_JPRB,2.1143E+00_JPRB,1.8225E+00_JPRB,1.5274E+00_JPRB,1.2237E+00_JPRB,&
&9.2233E-01_JPRB,6.0585E-01_JPRB,3.7278E-01_JPRB,3.6425E-01_JPRB,3.8938E+00_JPRB/)
KAO( :, 4,10,10) = (/&
&2.6956E+00_JPRB,2.4067E+00_JPRB,2.1300E+00_JPRB,1.8578E+00_JPRB,1.5689E+00_JPRB,1.2815E+00_JPRB,&
&9.8969E-01_JPRB,6.6341E-01_JPRB,4.6317E-01_JPRB,4.6656E-01_JPRB,4.0246E+00_JPRB/)
KAO( :, 5,10,10) = (/&
&2.6869E+00_JPRB,2.4172E+00_JPRB,2.1621E+00_JPRB,1.8987E+00_JPRB,1.6181E+00_JPRB,1.3422E+00_JPRB,&
&1.0558E+00_JPRB,7.2592E-01_JPRB,5.7500E-01_JPRB,5.8744E-01_JPRB,4.1547E+00_JPRB/)
KAO( :, 1,11,10) = (/&
&2.8365E+00_JPRB,2.4939E+00_JPRB,2.1806E+00_JPRB,1.8562E+00_JPRB,1.5246E+00_JPRB,1.1987E+00_JPRB,&
&8.5286E-01_JPRB,5.0756E-01_JPRB,2.5720E-01_JPRB,1.7786E-01_JPRB,5.8233E+00_JPRB/)
KAO( :, 2,11,10) = (/&
&2.8311E+00_JPRB,2.5017E+00_JPRB,2.2072E+00_JPRB,1.8857E+00_JPRB,1.5735E+00_JPRB,1.2464E+00_JPRB,&
&9.0789E-01_JPRB,5.6161E-01_JPRB,3.0021E-01_JPRB,2.4395E-01_JPRB,5.8712E+00_JPRB/)
KAO( :, 3,11,10) = (/&
&2.8249E+00_JPRB,2.5109E+00_JPRB,2.2225E+00_JPRB,1.9282E+00_JPRB,1.6185E+00_JPRB,1.2983E+00_JPRB,&
&9.6627E-01_JPRB,6.1528E-01_JPRB,3.5612E-01_JPRB,3.2409E-01_JPRB,5.9730E+00_JPRB/)
KAO( :, 4,11,10) = (/&
&2.8199E+00_JPRB,2.5320E+00_JPRB,2.2523E+00_JPRB,1.9711E+00_JPRB,1.6696E+00_JPRB,1.3539E+00_JPRB,&
&1.0246E+00_JPRB,6.7092E-01_JPRB,4.3024E-01_JPRB,4.1910E-01_JPRB,6.1100E+00_JPRB/)
KAO( :, 5,11,10) = (/&
&2.8024E+00_JPRB,2.5388E+00_JPRB,2.2830E+00_JPRB,2.0130E+00_JPRB,1.7222E+00_JPRB,1.4150E+00_JPRB,&
&1.0853E+00_JPRB,7.3326E-01_JPRB,5.2958E-01_JPRB,5.3082E-01_JPRB,6.2451E+00_JPRB/)
KAO( :, 1,12,10) = (/&
&2.9007E+00_JPRB,2.5522E+00_JPRB,2.2455E+00_JPRB,1.9136E+00_JPRB,1.5844E+00_JPRB,1.2502E+00_JPRB,&
&8.9520E-01_JPRB,5.2570E-01_JPRB,2.5575E-01_JPRB,1.5969E-01_JPRB,6.7808E+00_JPRB/)
KAO( :, 2,12,10) = (/&
&2.8957E+00_JPRB,2.5649E+00_JPRB,2.2681E+00_JPRB,1.9492E+00_JPRB,1.6332E+00_JPRB,1.2959E+00_JPRB,&
&9.5066E-01_JPRB,5.7358E-01_JPRB,2.9740E-01_JPRB,2.1707E-01_JPRB,6.8136E+00_JPRB/)
KAO( :, 3,12,10) = (/&
&2.8959E+00_JPRB,2.5923E+00_JPRB,2.2942E+00_JPRB,1.9975E+00_JPRB,1.6818E+00_JPRB,1.3548E+00_JPRB,&
&1.0083E+00_JPRB,6.2153E-01_JPRB,3.4695E-01_JPRB,2.8857E-01_JPRB,6.9134E+00_JPRB/)
KAO( :, 4,12,10) = (/&
&2.8817E+00_JPRB,2.6059E+00_JPRB,2.3289E+00_JPRB,2.0414E+00_JPRB,1.7379E+00_JPRB,1.4164E+00_JPRB,&
&1.0650E+00_JPRB,6.7585E-01_JPRB,4.1101E-01_JPRB,3.7695E-01_JPRB,7.0381E+00_JPRB/)
KAO( :, 5,12,10) = (/&
&2.8680E+00_JPRB,2.6070E+00_JPRB,2.3572E+00_JPRB,2.0817E+00_JPRB,1.7934E+00_JPRB,1.4807E+00_JPRB,&
&1.1194E+00_JPRB,7.3817E-01_JPRB,4.8817E-01_JPRB,4.7434E-01_JPRB,7.1520E+00_JPRB/)
KAO( :, 1,13,10) = (/&
&2.8740E+00_JPRB,2.5320E+00_JPRB,2.2375E+00_JPRB,1.9099E+00_JPRB,1.5916E+00_JPRB,1.2554E+00_JPRB,&
&9.0824E-01_JPRB,5.3705E-01_JPRB,2.5121E-01_JPRB,1.4664E-01_JPRB,6.0411E+00_JPRB/)
KAO( :, 2,13,10) = (/&
&2.8792E+00_JPRB,2.5659E+00_JPRB,2.2680E+00_JPRB,1.9609E+00_JPRB,1.6438E+00_JPRB,1.3095E+00_JPRB,&
&9.6448E-01_JPRB,5.8102E-01_JPRB,2.9305E-01_JPRB,1.9412E-01_JPRB,6.1051E+00_JPRB/)
KAO( :, 3,13,10) = (/&
&2.8707E+00_JPRB,2.5893E+00_JPRB,2.2982E+00_JPRB,2.0064E+00_JPRB,1.6967E+00_JPRB,1.3719E+00_JPRB,&
&1.0233E+00_JPRB,6.2659E-01_JPRB,3.3990E-01_JPRB,2.5773E-01_JPRB,6.2169E+00_JPRB/)
KAO( :, 4,13,10) = (/&
&2.8643E+00_JPRB,2.5995E+00_JPRB,2.3326E+00_JPRB,2.0484E+00_JPRB,1.7508E+00_JPRB,1.4355E+00_JPRB,&
&1.0824E+00_JPRB,6.7916E-01_JPRB,3.9630E-01_JPRB,3.3349E-01_JPRB,6.3137E+00_JPRB/)
KAO( :, 5,13,10) = (/&
&2.8671E+00_JPRB,2.6159E+00_JPRB,2.3730E+00_JPRB,2.0970E+00_JPRB,1.8103E+00_JPRB,1.4979E+00_JPRB,&
&1.1399E+00_JPRB,7.4021E-01_JPRB,4.5873E-01_JPRB,4.1936E-01_JPRB,6.4289E+00_JPRB/)
KAO( :, 1, 1,11) = (/&
&1.6613E+00_JPRB,1.4866E+00_JPRB,1.3853E+00_JPRB,1.3300E+00_JPRB,1.2682E+00_JPRB,1.2323E+00_JPRB,&
&1.3863E+00_JPRB,1.6088E+00_JPRB,1.7596E+00_JPRB,1.8112E+00_JPRB,1.8168E+00_JPRB/)
KAO( :, 2, 1,11) = (/&
&1.6169E+00_JPRB,1.4555E+00_JPRB,1.4059E+00_JPRB,1.3808E+00_JPRB,1.3576E+00_JPRB,1.4059E+00_JPRB,&
&1.6502E+00_JPRB,1.9162E+00_JPRB,2.0970E+00_JPRB,2.1595E+00_JPRB,2.1711E+00_JPRB/)
KAO( :, 3, 1,11) = (/&
&1.5778E+00_JPRB,1.4552E+00_JPRB,1.4351E+00_JPRB,1.4445E+00_JPRB,1.4667E+00_JPRB,1.6093E+00_JPRB,&
&1.9164E+00_JPRB,2.2262E+00_JPRB,2.4366E+00_JPRB,2.5118E+00_JPRB,2.5357E+00_JPRB/)
KAO( :, 4, 1,11) = (/&
&1.5458E+00_JPRB,1.4600E+00_JPRB,1.4693E+00_JPRB,1.5080E+00_JPRB,1.5810E+00_JPRB,1.8320E+00_JPRB,&
&2.1847E+00_JPRB,2.5375E+00_JPRB,2.7777E+00_JPRB,2.8639E+00_JPRB,2.8977E+00_JPRB/)
KAO( :, 5, 1,11) = (/&
&1.5169E+00_JPRB,1.4756E+00_JPRB,1.5189E+00_JPRB,1.5745E+00_JPRB,1.7149E+00_JPRB,2.0625E+00_JPRB,&
&2.4598E+00_JPRB,2.8572E+00_JPRB,3.1271E+00_JPRB,3.2233E+00_JPRB,3.2607E+00_JPRB/)
KAO( :, 1, 2,11) = (/&
&1.7931E+00_JPRB,1.6027E+00_JPRB,1.4692E+00_JPRB,1.3591E+00_JPRB,1.3119E+00_JPRB,1.2053E+00_JPRB,&
&1.2920E+00_JPRB,1.4995E+00_JPRB,1.6403E+00_JPRB,1.6893E+00_JPRB,1.7029E+00_JPRB/)
KAO( :, 2, 2,11) = (/&
&1.7517E+00_JPRB,1.5695E+00_JPRB,1.4741E+00_JPRB,1.4214E+00_JPRB,1.3827E+00_JPRB,1.3473E+00_JPRB,&
&1.5430E+00_JPRB,1.7916E+00_JPRB,1.9609E+00_JPRB,2.0211E+00_JPRB,2.0410E+00_JPRB/)
KAO( :, 3, 2,11) = (/&
&1.7144E+00_JPRB,1.5578E+00_JPRB,1.4838E+00_JPRB,1.5024E+00_JPRB,1.4587E+00_JPRB,1.5235E+00_JPRB,&
&1.7953E+00_JPRB,2.0852E+00_JPRB,2.2826E+00_JPRB,2.3530E+00_JPRB,2.3802E+00_JPRB/)
KAO( :, 4, 2,11) = (/&
&1.6782E+00_JPRB,1.5545E+00_JPRB,1.5253E+00_JPRB,1.5641E+00_JPRB,1.5463E+00_JPRB,1.7285E+00_JPRB,&
&2.0611E+00_JPRB,2.3939E+00_JPRB,2.6193E+00_JPRB,2.6996E+00_JPRB,2.7281E+00_JPRB/)
KAO( :, 5, 2,11) = (/&
&1.6444E+00_JPRB,1.5616E+00_JPRB,1.5898E+00_JPRB,1.6106E+00_JPRB,1.6616E+00_JPRB,1.9596E+00_JPRB,&
&2.3378E+00_JPRB,2.7154E+00_JPRB,2.9704E+00_JPRB,3.0605E+00_JPRB,3.0919E+00_JPRB/)
KAO( :, 1, 3,11) = (/&
&1.9627E+00_JPRB,1.7504E+00_JPRB,1.5854E+00_JPRB,1.4217E+00_JPRB,1.3102E+00_JPRB,1.1839E+00_JPRB,&
&1.1622E+00_JPRB,1.3310E+00_JPRB,1.4543E+00_JPRB,1.4985E+00_JPRB,1.5140E+00_JPRB/)
KAO( :, 2, 3,11) = (/&
&1.9279E+00_JPRB,1.7219E+00_JPRB,1.5816E+00_JPRB,1.4501E+00_JPRB,1.3900E+00_JPRB,1.2949E+00_JPRB,&
&1.3876E+00_JPRB,1.6085E+00_JPRB,1.7572E+00_JPRB,1.8110E+00_JPRB,1.8300E+00_JPRB/)
KAO( :, 3, 3,11) = (/&
&1.8924E+00_JPRB,1.7068E+00_JPRB,1.5754E+00_JPRB,1.5312E+00_JPRB,1.4545E+00_JPRB,1.4364E+00_JPRB,&
&1.6346E+00_JPRB,1.8944E+00_JPRB,2.0697E+00_JPRB,2.1336E+00_JPRB,2.1557E+00_JPRB/)
KAO( :, 4, 3,11) = (/&
&1.8571E+00_JPRB,1.6996E+00_JPRB,1.5918E+00_JPRB,1.6013E+00_JPRB,1.5297E+00_JPRB,1.6118E+00_JPRB,&
&1.8962E+00_JPRB,2.1972E+00_JPRB,2.4008E+00_JPRB,2.4733E+00_JPRB,2.4988E+00_JPRB/)
KAO( :, 5, 3,11) = (/&
&1.8235E+00_JPRB,1.6901E+00_JPRB,1.6505E+00_JPRB,1.6453E+00_JPRB,1.6300E+00_JPRB,1.8256E+00_JPRB,&
&2.1737E+00_JPRB,2.5187E+00_JPRB,2.7529E+00_JPRB,2.8347E+00_JPRB,2.8622E+00_JPRB/)
KAO( :, 1, 4,11) = (/&
&2.1765E+00_JPRB,1.9348E+00_JPRB,1.7298E+00_JPRB,1.5261E+00_JPRB,1.3305E+00_JPRB,1.1605E+00_JPRB,&
&1.0551E+00_JPRB,1.1346E+00_JPRB,1.2370E+00_JPRB,1.2757E+00_JPRB,1.2869E+00_JPRB/)
KAO( :, 2, 4,11) = (/&
&2.1414E+00_JPRB,1.9083E+00_JPRB,1.7248E+00_JPRB,1.5356E+00_JPRB,1.3817E+00_JPRB,1.2586E+00_JPRB,&
&1.2309E+00_JPRB,1.3912E+00_JPRB,1.5177E+00_JPRB,1.5661E+00_JPRB,1.5799E+00_JPRB/)
KAO( :, 3, 4,11) = (/&
&2.1021E+00_JPRB,1.8834E+00_JPRB,1.7158E+00_JPRB,1.5815E+00_JPRB,1.4532E+00_JPRB,1.3786E+00_JPRB,&
&1.4439E+00_JPRB,1.6656E+00_JPRB,1.8177E+00_JPRB,1.8749E+00_JPRB,1.8912E+00_JPRB/)
KAO( :, 4, 4,11) = (/&
&2.0644E+00_JPRB,1.8749E+00_JPRB,1.7166E+00_JPRB,1.6274E+00_JPRB,1.5294E+00_JPRB,1.5218E+00_JPRB,&
&1.7000E+00_JPRB,1.9644E+00_JPRB,2.1444E+00_JPRB,2.2100E+00_JPRB,2.2304E+00_JPRB/)
KAO( :, 5, 4,11) = (/&
&2.0315E+00_JPRB,1.8634E+00_JPRB,1.7507E+00_JPRB,1.6723E+00_JPRB,1.6226E+00_JPRB,1.7027E+00_JPRB,&
&1.9800E+00_JPRB,2.2880E+00_JPRB,2.4977E+00_JPRB,2.5739E+00_JPRB,2.5981E+00_JPRB/)
KAO( :, 1, 5,11) = (/&
&2.3978E+00_JPRB,2.1273E+00_JPRB,1.8817E+00_JPRB,1.6476E+00_JPRB,1.4011E+00_JPRB,1.1672E+00_JPRB,&
&9.7083E-01_JPRB,9.5214E-01_JPRB,1.0369E+00_JPRB,1.0689E+00_JPRB,1.0768E+00_JPRB/)
KAO( :, 2, 5,11) = (/&
&2.3540E+00_JPRB,2.0936E+00_JPRB,1.8768E+00_JPRB,1.6491E+00_JPRB,1.4389E+00_JPRB,1.2340E+00_JPRB,&
&1.1149E+00_JPRB,1.1831E+00_JPRB,1.2889E+00_JPRB,1.3291E+00_JPRB,1.3391E+00_JPRB/)
KAO( :, 3, 5,11) = (/&
&2.3123E+00_JPRB,2.0603E+00_JPRB,1.8683E+00_JPRB,1.6861E+00_JPRB,1.4856E+00_JPRB,1.3243E+00_JPRB,&
&1.2879E+00_JPRB,1.4387E+00_JPRB,1.5683E+00_JPRB,1.6173E+00_JPRB,1.6292E+00_JPRB/)
KAO( :, 4, 5,11) = (/&
&2.2731E+00_JPRB,2.0535E+00_JPRB,1.8606E+00_JPRB,1.7201E+00_JPRB,1.5405E+00_JPRB,1.4489E+00_JPRB,&
&1.5047E+00_JPRB,1.7253E+00_JPRB,1.8810E+00_JPRB,1.9395E+00_JPRB,1.9546E+00_JPRB/)
KAO( :, 5, 5,11) = (/&
&2.2409E+00_JPRB,2.0441E+00_JPRB,1.8877E+00_JPRB,1.7429E+00_JPRB,1.6151E+00_JPRB,1.6124E+00_JPRB,&
&1.7700E+00_JPRB,2.0422E+00_JPRB,2.2271E+00_JPRB,2.2953E+00_JPRB,2.3139E+00_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.5958E+00_JPRB,2.2974E+00_JPRB,2.0142E+00_JPRB,1.7617E+00_JPRB,1.4801E+00_JPRB,1.2138E+00_JPRB,&
&9.4381E-01_JPRB,8.0769E-01_JPRB,8.5699E-01_JPRB,8.8288E-01_JPRB,8.8884E-01_JPRB/)
KAO( :, 2, 6,11) = (/&
&2.5524E+00_JPRB,2.2633E+00_JPRB,2.0140E+00_JPRB,1.7595E+00_JPRB,1.5235E+00_JPRB,1.2699E+00_JPRB,&
&1.0358E+00_JPRB,9.9995E-01_JPRB,1.0855E+00_JPRB,1.1188E+00_JPRB,1.1263E+00_JPRB/)
KAO( :, 3, 6,11) = (/&
&2.5133E+00_JPRB,2.2324E+00_JPRB,2.0130E+00_JPRB,1.7928E+00_JPRB,1.5724E+00_JPRB,1.3298E+00_JPRB,&
&1.1740E+00_JPRB,1.2292E+00_JPRB,1.3373E+00_JPRB,1.3782E+00_JPRB,1.3885E+00_JPRB/)
KAO( :, 4, 6,11) = (/&
&2.4807E+00_JPRB,2.2302E+00_JPRB,2.0078E+00_JPRB,1.8271E+00_JPRB,1.6226E+00_JPRB,1.4050E+00_JPRB,&
&1.3553E+00_JPRB,1.4899E+00_JPRB,1.6221E+00_JPRB,1.6724E+00_JPRB,1.6846E+00_JPRB/)
KAO( :, 5, 6,11) = (/&
&2.4531E+00_JPRB,2.2259E+00_JPRB,2.0295E+00_JPRB,1.8622E+00_JPRB,1.6727E+00_JPRB,1.5327E+00_JPRB,&
&1.5693E+00_JPRB,1.7819E+00_JPRB,1.9432E+00_JPRB,2.0038E+00_JPRB,2.0198E+00_JPRB/)
KAO( :, 1, 7,11) = (/&
&2.7829E+00_JPRB,2.4576E+00_JPRB,2.1410E+00_JPRB,1.8711E+00_JPRB,1.5626E+00_JPRB,1.2726E+00_JPRB,&
&9.6771E-01_JPRB,6.9895E-01_JPRB,6.9406E-01_JPRB,7.1533E-01_JPRB,7.2033E-01_JPRB/)
KAO( :, 2, 7,11) = (/&
&2.7493E+00_JPRB,2.4354E+00_JPRB,2.1596E+00_JPRB,1.8755E+00_JPRB,1.6074E+00_JPRB,1.3276E+00_JPRB,&
&1.0391E+00_JPRB,8.5593E-01_JPRB,8.9783E-01_JPRB,9.2606E-01_JPRB,9.3225E-01_JPRB/)
KAO( :, 3, 7,11) = (/&
&2.7215E+00_JPRB,2.4153E+00_JPRB,2.1690E+00_JPRB,1.9070E+00_JPRB,1.6545E+00_JPRB,1.3898E+00_JPRB,&
&1.1226E+00_JPRB,1.0453E+00_JPRB,1.1294E+00_JPRB,1.1648E+00_JPRB,1.1728E+00_JPRB/)
KAO( :, 4, 7,11) = (/&
&2.6975E+00_JPRB,2.4170E+00_JPRB,2.1702E+00_JPRB,1.9430E+00_JPRB,1.7107E+00_JPRB,1.4568E+00_JPRB,&
&1.2495E+00_JPRB,1.2760E+00_JPRB,1.3906E+00_JPRB,1.4345E+00_JPRB,1.4450E+00_JPRB/)
KAO( :, 5, 7,11) = (/&
&2.6700E+00_JPRB,2.4191E+00_JPRB,2.1904E+00_JPRB,1.9836E+00_JPRB,1.7642E+00_JPRB,1.5351E+00_JPRB,&
&1.4268E+00_JPRB,1.5390E+00_JPRB,1.6803E+00_JPRB,1.7334E+00_JPRB,1.7463E+00_JPRB/)
KAO( :, 1, 8,11) = (/&
&2.9847E+00_JPRB,2.6313E+00_JPRB,2.2865E+00_JPRB,1.9879E+00_JPRB,1.6488E+00_JPRB,1.3255E+00_JPRB,&
&9.9877E-01_JPRB,6.5722E-01_JPRB,5.5701E-01_JPRB,5.7433E-01_JPRB,5.7952E-01_JPRB/)
KAO( :, 2, 8,11) = (/&
&2.9589E+00_JPRB,2.6183E+00_JPRB,2.3133E+00_JPRB,2.0003E+00_JPRB,1.6901E+00_JPRB,1.3820E+00_JPRB,&
&1.0665E+00_JPRB,7.5791E-01_JPRB,7.3569E-01_JPRB,7.5906E-01_JPRB,7.6418E-01_JPRB/)
KAO( :, 3, 8,11) = (/&
&2.9382E+00_JPRB,2.6052E+00_JPRB,2.3281E+00_JPRB,2.0270E+00_JPRB,1.7422E+00_JPRB,1.4465E+00_JPRB,&
&1.1457E+00_JPRB,9.0969E-01_JPRB,9.4197E-01_JPRB,9.7232E-01_JPRB,9.7875E-01_JPRB/)
KAO( :, 4, 8,11) = (/&
&2.9170E+00_JPRB,2.6060E+00_JPRB,2.3361E+00_JPRB,2.0694E+00_JPRB,1.8026E+00_JPRB,1.5183E+00_JPRB,&
&1.2312E+00_JPRB,1.0984E+00_JPRB,1.1773E+00_JPRB,1.2154E+00_JPRB,1.2236E+00_JPRB/)
KAO( :, 5, 8,11) = (/&
&2.8898E+00_JPRB,2.6134E+00_JPRB,2.3563E+00_JPRB,2.1177E+00_JPRB,1.8614E+00_JPRB,1.5931E+00_JPRB,&
&1.3477E+00_JPRB,1.3211E+00_JPRB,1.4373E+00_JPRB,1.4847E+00_JPRB,1.4939E+00_JPRB/)
KAO( :, 1, 9,11) = (/&
&3.1562E+00_JPRB,2.7768E+00_JPRB,2.4133E+00_JPRB,2.0911E+00_JPRB,1.7326E+00_JPRB,1.3839E+00_JPRB,&
&1.0276E+00_JPRB,6.4719E-01_JPRB,4.4660E-01_JPRB,4.5187E-01_JPRB,1.3511E+00_JPRB/)
KAO( :, 2, 9,11) = (/&
&3.1384E+00_JPRB,2.7738E+00_JPRB,2.4447E+00_JPRB,2.1155E+00_JPRB,1.7788E+00_JPRB,1.4436E+00_JPRB,&
&1.0888E+00_JPRB,7.2585E-01_JPRB,5.9330E-01_JPRB,6.1102E-01_JPRB,1.4527E+00_JPRB/)
KAO( :, 3, 9,11) = (/&
&3.1307E+00_JPRB,2.7744E+00_JPRB,2.4761E+00_JPRB,2.1489E+00_JPRB,1.8392E+00_JPRB,1.5081E+00_JPRB,&
&1.1726E+00_JPRB,8.2343E-01_JPRB,7.7078E-01_JPRB,7.9585E-01_JPRB,1.5858E+00_JPRB/)
KAO( :, 4, 9,11) = (/&
&3.1198E+00_JPRB,2.7814E+00_JPRB,2.4948E+00_JPRB,2.2031E+00_JPRB,1.9038E+00_JPRB,1.5809E+00_JPRB,&
&1.2536E+00_JPRB,9.6368E-01_JPRB,9.7557E-01_JPRB,1.0082E+00_JPRB,1.7168E+00_JPRB/)
KAO( :, 5, 9,11) = (/&
&3.0996E+00_JPRB,2.7968E+00_JPRB,2.5179E+00_JPRB,2.2589E+00_JPRB,1.9623E+00_JPRB,1.6560E+00_JPRB,&
&1.3493E+00_JPRB,1.1417E+00_JPRB,1.2025E+00_JPRB,1.2431E+00_JPRB,1.8589E+00_JPRB/)
KAO( :, 1,10,11) = (/&
&3.3334E+00_JPRB,2.9275E+00_JPRB,2.5435E+00_JPRB,2.1899E+00_JPRB,1.8099E+00_JPRB,1.4340E+00_JPRB,&
&1.0600E+00_JPRB,6.4816E-01_JPRB,3.7397E-01_JPRB,3.5551E-01_JPRB,5.2534E+00_JPRB/)
KAO( :, 2,10,11) = (/&
&3.3403E+00_JPRB,2.9437E+00_JPRB,2.5854E+00_JPRB,2.2265E+00_JPRB,1.8583E+00_JPRB,1.5038E+00_JPRB,&
&1.1221E+00_JPRB,7.2216E-01_JPRB,4.8652E-01_JPRB,4.8944E-01_JPRB,5.3617E+00_JPRB/)
KAO( :, 3,10,11) = (/&
&3.3507E+00_JPRB,2.9656E+00_JPRB,2.6315E+00_JPRB,2.2679E+00_JPRB,1.9297E+00_JPRB,1.5737E+00_JPRB,&
&1.2011E+00_JPRB,8.0616E-01_JPRB,6.2998E-01_JPRB,6.4742E-01_JPRB,5.5025E+00_JPRB/)
KAO( :, 4,10,11) = (/&
&3.3473E+00_JPRB,2.9767E+00_JPRB,2.6569E+00_JPRB,2.3310E+00_JPRB,1.9983E+00_JPRB,1.6498E+00_JPRB,&
&1.2844E+00_JPRB,9.0267E-01_JPRB,8.0194E-01_JPRB,8.2874E-01_JPRB,5.7004E+00_JPRB/)
KAO( :, 5,10,11) = (/&
&3.3392E+00_JPRB,3.0005E+00_JPRB,2.6833E+00_JPRB,2.3869E+00_JPRB,2.0631E+00_JPRB,1.7311E+00_JPRB,&
&1.3746E+00_JPRB,1.0270E+00_JPRB,9.9701E-01_JPRB,1.0314E+00_JPRB,5.9087E+00_JPRB/)
KAO( :, 1,11,11) = (/&
&3.5791E+00_JPRB,3.1435E+00_JPRB,2.7380E+00_JPRB,2.3402E+00_JPRB,1.9223E+00_JPRB,1.5197E+00_JPRB,&
&1.1123E+00_JPRB,6.8009E-01_JPRB,3.6796E-01_JPRB,3.2253E-01_JPRB,8.7180E+00_JPRB/)
KAO( :, 2,11,11) = (/&
&3.6087E+00_JPRB,3.1771E+00_JPRB,2.7948E+00_JPRB,2.3883E+00_JPRB,1.9888E+00_JPRB,1.5919E+00_JPRB,&
&1.1796E+00_JPRB,7.5512E-01_JPRB,4.5552E-01_JPRB,4.4047E-01_JPRB,8.8675E+00_JPRB/)
KAO( :, 3,11,11) = (/&
&3.6204E+00_JPRB,3.2046E+00_JPRB,2.8376E+00_JPRB,2.4402E+00_JPRB,2.0562E+00_JPRB,1.6610E+00_JPRB,&
&1.2640E+00_JPRB,8.3788E-01_JPRB,5.7436E-01_JPRB,5.8089E-01_JPRB,8.9648E+00_JPRB/)
KAO( :, 4,11,11) = (/&
&3.6182E+00_JPRB,3.2254E+00_JPRB,2.8581E+00_JPRB,2.4960E+00_JPRB,2.1196E+00_JPRB,1.7427E+00_JPRB,&
&1.3559E+00_JPRB,9.2621E-01_JPRB,7.2423E-01_JPRB,7.4487E-01_JPRB,9.1149E+00_JPRB/)
KAO( :, 5,11,11) = (/&
&3.6174E+00_JPRB,3.2471E+00_JPRB,2.8980E+00_JPRB,2.5529E+00_JPRB,2.1857E+00_JPRB,1.8304E+00_JPRB,&
&1.4477E+00_JPRB,1.0248E+00_JPRB,8.9846E-01_JPRB,9.2879E-01_JPRB,9.3291E+00_JPRB/)
KAO( :, 1,12,11) = (/&
&3.8356E+00_JPRB,3.3697E+00_JPRB,2.9444E+00_JPRB,2.5088E+00_JPRB,2.0569E+00_JPRB,1.6203E+00_JPRB,&
&1.1634E+00_JPRB,7.0598E-01_JPRB,3.6756E-01_JPRB,2.8729E-01_JPRB,1.0641E+01_JPRB/)
KAO( :, 2,12,11) = (/&
&3.8609E+00_JPRB,3.3997E+00_JPRB,3.0019E+00_JPRB,2.5600E+00_JPRB,2.1300E+00_JPRB,1.6898E+00_JPRB,&
&1.2364E+00_JPRB,7.8348E-01_JPRB,4.3743E-01_JPRB,3.9283E-01_JPRB,1.0771E+01_JPRB/)
KAO( :, 3,12,11) = (/&
&3.8613E+00_JPRB,3.4230E+00_JPRB,3.0314E+00_JPRB,2.6152E+00_JPRB,2.1935E+00_JPRB,1.7589E+00_JPRB,&
&1.3202E+00_JPRB,8.6394E-01_JPRB,5.3376E-01_JPRB,5.1970E-01_JPRB,1.0841E+01_JPRB/)
KAO( :, 4,12,11) = (/&
&3.8625E+00_JPRB,3.4569E+00_JPRB,3.0618E+00_JPRB,2.6703E+00_JPRB,2.2548E+00_JPRB,1.8353E+00_JPRB,&
&1.4152E+00_JPRB,9.4767E-01_JPRB,6.5928E-01_JPRB,6.6542E-01_JPRB,1.0973E+01_JPRB/)
KAO( :, 5,12,11) = (/&
&3.8581E+00_JPRB,3.4796E+00_JPRB,3.1105E+00_JPRB,2.7293E+00_JPRB,2.3221E+00_JPRB,1.9216E+00_JPRB,&
&1.5109E+00_JPRB,1.0379E+00_JPRB,8.1824E-01_JPRB,8.3851E-01_JPRB,1.1187E+01_JPRB/)
KAO( :, 1,13,11) = (/&
&3.9871E+00_JPRB,3.5054E+00_JPRB,3.0792E+00_JPRB,2.6225E+00_JPRB,2.1590E+00_JPRB,1.6999E+00_JPRB,&
&1.2116E+00_JPRB,7.2436E-01_JPRB,3.6726E-01_JPRB,2.5477E-01_JPRB,9.9516E+00_JPRB/)
KAO( :, 2,13,11) = (/&
&3.9908E+00_JPRB,3.5178E+00_JPRB,3.1201E+00_JPRB,2.6682E+00_JPRB,2.2282E+00_JPRB,1.7642E+00_JPRB,&
&1.2901E+00_JPRB,8.0058E-01_JPRB,4.3056E-01_JPRB,3.4969E-01_JPRB,1.0028E+01_JPRB/)
KAO( :, 3,13,11) = (/&
&3.9925E+00_JPRB,3.5529E+00_JPRB,3.1500E+00_JPRB,2.7322E+00_JPRB,2.2922E+00_JPRB,1.8395E+00_JPRB,&
&1.3733E+00_JPRB,8.8117E-01_JPRB,5.1140E-01_JPRB,4.6457E-01_JPRB,1.0124E+01_JPRB/)
KAO( :, 4,13,11) = (/&
&3.9936E+00_JPRB,3.5963E+00_JPRB,3.1980E+00_JPRB,2.7942E+00_JPRB,2.3651E+00_JPRB,1.9195E+00_JPRB,&
&1.4609E+00_JPRB,9.6392E-01_JPRB,6.1546E-01_JPRB,5.9986E-01_JPRB,1.0319E+01_JPRB/)
KAO( :, 5,13,11) = (/&
&3.9766E+00_JPRB,3.6110E+00_JPRB,3.2440E+00_JPRB,2.8558E+00_JPRB,2.4407E+00_JPRB,2.0092E+00_JPRB,&
&1.5546E+00_JPRB,1.0530E+00_JPRB,7.5480E-01_JPRB,7.6043E-01_JPRB,1.0517E+01_JPRB/)
KAO( :, 1, 1,12) = (/&
&2.0024E+00_JPRB,1.8234E+00_JPRB,1.7233E+00_JPRB,1.6000E+00_JPRB,1.5390E+00_JPRB,1.6921E+00_JPRB,&
&2.0059E+00_JPRB,2.3183E+00_JPRB,2.5294E+00_JPRB,2.5972E+00_JPRB,2.5881E+00_JPRB/)
KAO( :, 2, 1,12) = (/&
&1.9590E+00_JPRB,1.7950E+00_JPRB,1.7523E+00_JPRB,1.6313E+00_JPRB,1.6912E+00_JPRB,2.0086E+00_JPRB,&
&2.3854E+00_JPRB,2.7609E+00_JPRB,3.0136E+00_JPRB,3.0926E+00_JPRB,3.0692E+00_JPRB/)
KAO( :, 3, 1,12) = (/&
&1.9218E+00_JPRB,1.7695E+00_JPRB,1.7573E+00_JPRB,1.7104E+00_JPRB,1.9221E+00_JPRB,2.3617E+00_JPRB,&
&2.8084E+00_JPRB,3.2536E+00_JPRB,3.5528E+00_JPRB,3.6452E+00_JPRB,3.6033E+00_JPRB/)
KAO( :, 4, 1,12) = (/&
&1.8869E+00_JPRB,1.7776E+00_JPRB,1.7584E+00_JPRB,1.8482E+00_JPRB,2.2062E+00_JPRB,2.7254E+00_JPRB,&
&3.2420E+00_JPRB,3.7568E+00_JPRB,4.1037E+00_JPRB,4.2125E+00_JPRB,4.1721E+00_JPRB/)
KAO( :, 5, 1,12) = (/&
&1.8556E+00_JPRB,1.7835E+00_JPRB,1.7826E+00_JPRB,2.0106E+00_JPRB,2.5078E+00_JPRB,3.0956E+00_JPRB,&
&3.6815E+00_JPRB,4.2658E+00_JPRB,4.6607E+00_JPRB,4.7891E+00_JPRB,4.7658E+00_JPRB/)
KAO( :, 1, 2,12) = (/&
&2.1298E+00_JPRB,1.9238E+00_JPRB,1.7993E+00_JPRB,1.6635E+00_JPRB,1.5382E+00_JPRB,1.6444E+00_JPRB,&
&1.9357E+00_JPRB,2.2355E+00_JPRB,2.4380E+00_JPRB,2.5040E+00_JPRB,2.5099E+00_JPRB/)
KAO( :, 2, 2,12) = (/&
&2.0858E+00_JPRB,1.8949E+00_JPRB,1.8227E+00_JPRB,1.6898E+00_JPRB,1.7064E+00_JPRB,1.9739E+00_JPRB,&
&2.3396E+00_JPRB,2.7042E+00_JPRB,2.9505E+00_JPRB,3.0304E+00_JPRB,3.0347E+00_JPRB/)
KAO( :, 3, 2,12) = (/&
&2.0506E+00_JPRB,1.8767E+00_JPRB,1.8261E+00_JPRB,1.7610E+00_JPRB,1.9334E+00_JPRB,2.3331E+00_JPRB,&
&2.7675E+00_JPRB,3.2005E+00_JPRB,3.4937E+00_JPRB,3.5905E+00_JPRB,3.6006E+00_JPRB/)
KAO( :, 4, 2,12) = (/&
&2.0203E+00_JPRB,1.8859E+00_JPRB,1.8248E+00_JPRB,1.8919E+00_JPRB,2.2034E+00_JPRB,2.7037E+00_JPRB,&
&3.2087E+00_JPRB,3.7127E+00_JPRB,4.0556E+00_JPRB,4.1705E+00_JPRB,4.1872E+00_JPRB/)
KAO( :, 5, 2,12) = (/&
&1.9908E+00_JPRB,1.8904E+00_JPRB,1.8512E+00_JPRB,2.0461E+00_JPRB,2.4857E+00_JPRB,3.0612E+00_JPRB,&
&3.6347E+00_JPRB,4.2084E+00_JPRB,4.6000E+00_JPRB,4.7320E+00_JPRB,4.7545E+00_JPRB/)
KAO( :, 1, 3,12) = (/&
&2.3152E+00_JPRB,2.0670E+00_JPRB,1.8762E+00_JPRB,1.7274E+00_JPRB,1.5513E+00_JPRB,1.5459E+00_JPRB,&
&1.7613E+00_JPRB,2.0324E+00_JPRB,2.2184E+00_JPRB,2.2809E+00_JPRB,2.3001E+00_JPRB/)
KAO( :, 2, 3,12) = (/&
&2.2611E+00_JPRB,2.0302E+00_JPRB,1.8953E+00_JPRB,1.7501E+00_JPRB,1.6877E+00_JPRB,1.8252E+00_JPRB,&
&2.1469E+00_JPRB,2.4814E+00_JPRB,2.7105E+00_JPRB,2.7886E+00_JPRB,2.8127E+00_JPRB/)
KAO( :, 3, 3,12) = (/&
&2.2196E+00_JPRB,2.0024E+00_JPRB,1.9041E+00_JPRB,1.8045E+00_JPRB,1.8785E+00_JPRB,2.1610E+00_JPRB,&
&2.5580E+00_JPRB,2.9591E+00_JPRB,3.2348E+00_JPRB,3.3294E+00_JPRB,3.3602E+00_JPRB/)
KAO( :, 4, 3,12) = (/&
&2.1813E+00_JPRB,2.0049E+00_JPRB,1.9086E+00_JPRB,1.9162E+00_JPRB,2.1012E+00_JPRB,2.5182E+00_JPRB,&
&2.9831E+00_JPRB,3.4549E+00_JPRB,3.7770E+00_JPRB,3.8911E+00_JPRB,3.9291E+00_JPRB/)
KAO( :, 5, 3,12) = (/&
&2.1479E+00_JPRB,2.0113E+00_JPRB,1.9331E+00_JPRB,2.0520E+00_JPRB,2.3502E+00_JPRB,2.8679E+00_JPRB,&
&3.4008E+00_JPRB,3.9406E+00_JPRB,4.3094E+00_JPRB,4.4428E+00_JPRB,4.4869E+00_JPRB/)
KAO( :, 1, 4,12) = (/&
&2.5457E+00_JPRB,2.2591E+00_JPRB,2.0008E+00_JPRB,1.7948E+00_JPRB,1.5715E+00_JPRB,1.4721E+00_JPRB,&
&1.5451E+00_JPRB,1.7860E+00_JPRB,1.9513E+00_JPRB,2.0089E+00_JPRB,2.0285E+00_JPRB/)
KAO( :, 2, 4,12) = (/&
&2.4902E+00_JPRB,2.2151E+00_JPRB,2.0050E+00_JPRB,1.8035E+00_JPRB,1.6846E+00_JPRB,1.6830E+00_JPRB,&
&1.9079E+00_JPRB,2.2087E+00_JPRB,2.4143E+00_JPRB,2.4852E+00_JPRB,2.5099E+00_JPRB/)
KAO( :, 3, 4,12) = (/&
&2.4431E+00_JPRB,2.1812E+00_JPRB,2.0033E+00_JPRB,1.8558E+00_JPRB,1.8346E+00_JPRB,1.9529E+00_JPRB,&
&2.2983E+00_JPRB,2.6628E+00_JPRB,2.9108E+00_JPRB,2.9983E+00_JPRB,3.0280E+00_JPRB/)
KAO( :, 4, 4,12) = (/&
&2.3979E+00_JPRB,2.1681E+00_JPRB,1.9996E+00_JPRB,1.9562E+00_JPRB,2.0099E+00_JPRB,2.2734E+00_JPRB,&
&2.7005E+00_JPRB,3.1310E+00_JPRB,3.4248E+00_JPRB,3.5296E+00_JPRB,3.5651E+00_JPRB/)
KAO( :, 5, 4,12) = (/&
&2.3549E+00_JPRB,2.1677E+00_JPRB,2.0250E+00_JPRB,2.0706E+00_JPRB,2.2012E+00_JPRB,2.6084E+00_JPRB,&
&3.1023E+00_JPRB,3.5987E+00_JPRB,3.9377E+00_JPRB,4.0590E+00_JPRB,4.0984E+00_JPRB/)
KAO( :, 1, 5,12) = (/&
&2.7985E+00_JPRB,2.4747E+00_JPRB,2.1629E+00_JPRB,1.9120E+00_JPRB,1.6257E+00_JPRB,1.4332E+00_JPRB,&
&1.3851E+00_JPRB,1.5480E+00_JPRB,1.6917E+00_JPRB,1.7423E+00_JPRB,1.7595E+00_JPRB/)
KAO( :, 2, 5,12) = (/&
&2.7492E+00_JPRB,2.4385E+00_JPRB,2.1709E+00_JPRB,1.9088E+00_JPRB,1.7063E+00_JPRB,1.6093E+00_JPRB,&
&1.6827E+00_JPRB,1.9416E+00_JPRB,2.1228E+00_JPRB,2.1868E+00_JPRB,2.2077E+00_JPRB/)
KAO( :, 3, 5,12) = (/&
&2.7030E+00_JPRB,2.4052E+00_JPRB,2.1654E+00_JPRB,1.9357E+00_JPRB,1.8221E+00_JPRB,1.8325E+00_JPRB,&
&2.0441E+00_JPRB,2.3696E+00_JPRB,2.5914E+00_JPRB,2.6707E+00_JPRB,2.6969E+00_JPRB/)
KAO( :, 4, 5,12) = (/&
&2.6567E+00_JPRB,2.3812E+00_JPRB,2.1576E+00_JPRB,2.0192E+00_JPRB,1.9790E+00_JPRB,2.0835E+00_JPRB,&
&2.4268E+00_JPRB,2.8144E+00_JPRB,3.0796E+00_JPRB,3.1741E+00_JPRB,3.2046E+00_JPRB/)
KAO( :, 5, 5,12) = (/&
&2.6110E+00_JPRB,2.3730E+00_JPRB,2.1635E+00_JPRB,2.1182E+00_JPRB,2.1485E+00_JPRB,2.3741E+00_JPRB,&
&2.8181E+00_JPRB,3.2699E+00_JPRB,3.5786E+00_JPRB,3.6897E+00_JPRB,3.7249E+00_JPRB/)
KAO( :, 1, 6,12) = (/&
&3.0669E+00_JPRB,2.7085E+00_JPRB,2.3540E+00_JPRB,2.0714E+00_JPRB,1.7429E+00_JPRB,1.4581E+00_JPRB,&
&1.2708E+00_JPRB,1.2992E+00_JPRB,1.4199E+00_JPRB,1.4638E+00_JPRB,1.4769E+00_JPRB/)
KAO( :, 2, 6,12) = (/&
&3.0273E+00_JPRB,2.6834E+00_JPRB,2.3740E+00_JPRB,2.0802E+00_JPRB,1.7965E+00_JPRB,1.5717E+00_JPRB,&
&1.5052E+00_JPRB,1.6583E+00_JPRB,1.8132E+00_JPRB,1.8699E+00_JPRB,1.8859E+00_JPRB/)
KAO( :, 3, 6,12) = (/&
&2.9774E+00_JPRB,2.6481E+00_JPRB,2.3757E+00_JPRB,2.0942E+00_JPRB,1.8671E+00_JPRB,1.7544E+00_JPRB,&
&1.8026E+00_JPRB,2.0622E+00_JPRB,2.2566E+00_JPRB,2.3275E+00_JPRB,2.3474E+00_JPRB/)
KAO( :, 4, 6,12) = (/&
&2.9289E+00_JPRB,2.6161E+00_JPRB,2.3748E+00_JPRB,2.1584E+00_JPRB,1.9838E+00_JPRB,1.9738E+00_JPRB,&
&2.1469E+00_JPRB,2.4888E+00_JPRB,2.7236E+00_JPRB,2.8101E+00_JPRB,2.8355E+00_JPRB/)
KAO( :, 5, 6,12) = (/&
&2.8845E+00_JPRB,2.6155E+00_JPRB,2.3754E+00_JPRB,2.2196E+00_JPRB,2.1301E+00_JPRB,2.2099E+00_JPRB,&
&2.5314E+00_JPRB,2.9385E+00_JPRB,3.2168E+00_JPRB,3.3176E+00_JPRB,3.3483E+00_JPRB/)
KAO( :, 1, 7,12) = (/&
&3.3664E+00_JPRB,2.9675E+00_JPRB,2.5762E+00_JPRB,2.2561E+00_JPRB,1.8881E+00_JPRB,1.5413E+00_JPRB,&
&1.2170E+00_JPRB,1.0953E+00_JPRB,1.1799E+00_JPRB,1.2170E+00_JPRB,1.2273E+00_JPRB/)
KAO( :, 2, 7,12) = (/&
&3.3233E+00_JPRB,2.9434E+00_JPRB,2.5928E+00_JPRB,2.2752E+00_JPRB,1.9335E+00_JPRB,1.6227E+00_JPRB,&
&1.3832E+00_JPRB,1.3998E+00_JPRB,1.5310E+00_JPRB,1.5791E+00_JPRB,1.5922E+00_JPRB/)
KAO( :, 3, 7,12) = (/&
&3.2746E+00_JPRB,2.9093E+00_JPRB,2.6019E+00_JPRB,2.2869E+00_JPRB,2.0053E+00_JPRB,1.7360E+00_JPRB,&
&1.6231E+00_JPRB,1.7636E+00_JPRB,1.9299E+00_JPRB,1.9918E+00_JPRB,2.0082E+00_JPRB/)
KAO( :, 4, 7,12) = (/&
&3.2312E+00_JPRB,2.8766E+00_JPRB,2.6067E+00_JPRB,2.3470E+00_JPRB,2.0847E+00_JPRB,1.8980E+00_JPRB,&
&1.9031E+00_JPRB,2.1576E+00_JPRB,2.3620E+00_JPRB,2.4387E+00_JPRB,2.4578E+00_JPRB/)
KAO( :, 5, 7,12) = (/&
&3.1925E+00_JPRB,2.8793E+00_JPRB,2.6061E+00_JPRB,2.4035E+00_JPRB,2.1834E+00_JPRB,2.1023E+00_JPRB,&
&2.2418E+00_JPRB,2.5923E+00_JPRB,2.8385E+00_JPRB,2.9297E+00_JPRB,2.9542E+00_JPRB/)
KAO( :, 1, 8,12) = (/&
&3.6796E+00_JPRB,3.2357E+00_JPRB,2.8155E+00_JPRB,2.4508E+00_JPRB,2.0518E+00_JPRB,1.6449E+00_JPRB,&
&1.2564E+00_JPRB,9.4794E-01_JPRB,9.6423E-01_JPRB,9.9527E-01_JPRB,1.0031E+00_JPRB/)
KAO( :, 2, 8,12) = (/&
&3.6371E+00_JPRB,3.2182E+00_JPRB,2.8214E+00_JPRB,2.4857E+00_JPRB,2.0950E+00_JPRB,1.7292E+00_JPRB,&
&1.3545E+00_JPRB,1.1961E+00_JPRB,1.2815E+00_JPRB,1.3224E+00_JPRB,1.3335E+00_JPRB/)
KAO( :, 3, 8,12) = (/&
&3.5989E+00_JPRB,3.1965E+00_JPRB,2.8529E+00_JPRB,2.5009E+00_JPRB,2.1656E+00_JPRB,1.8143E+00_JPRB,&
&1.5162E+00_JPRB,1.5048E+00_JPRB,1.6425E+00_JPRB,1.6953E+00_JPRB,1.7094E+00_JPRB/)
KAO( :, 4, 8,12) = (/&
&3.5657E+00_JPRB,3.1726E+00_JPRB,2.8689E+00_JPRB,2.5490E+00_JPRB,2.2397E+00_JPRB,1.9179E+00_JPRB,&
&1.7462E+00_JPRB,1.8651E+00_JPRB,2.0421E+00_JPRB,2.1078E+00_JPRB,2.1252E+00_JPRB/)
KAO( :, 5, 8,12) = (/&
&3.5352E+00_JPRB,3.1791E+00_JPRB,2.8690E+00_JPRB,2.6021E+00_JPRB,2.3244E+00_JPRB,2.0668E+00_JPRB,&
&2.0251E+00_JPRB,2.2682E+00_JPRB,2.4843E+00_JPRB,2.5643E+00_JPRB,2.5857E+00_JPRB/)
KAO( :, 1, 9,12) = (/&
&4.0318E+00_JPRB,3.5333E+00_JPRB,3.0785E+00_JPRB,2.6542E+00_JPRB,2.2190E+00_JPRB,1.7557E+00_JPRB,&
&1.3174E+00_JPRB,8.6677E-01_JPRB,7.7038E-01_JPRB,7.9546E-01_JPRB,1.7542E+00_JPRB/)
KAO( :, 2, 9,12) = (/&
&4.0030E+00_JPRB,3.5307E+00_JPRB,3.0824E+00_JPRB,2.7001E+00_JPRB,2.2575E+00_JPRB,1.8461E+00_JPRB,&
&1.4064E+00_JPRB,1.0445E+00_JPRB,1.0532E+00_JPRB,1.0871E+00_JPRB,1.8981E+00_JPRB/)
KAO( :, 3, 9,12) = (/&
&3.9727E+00_JPRB,3.5227E+00_JPRB,3.1268E+00_JPRB,2.7209E+00_JPRB,2.3294E+00_JPRB,1.9265E+00_JPRB,&
&1.5119E+00_JPRB,1.3023E+00_JPRB,1.3838E+00_JPRB,1.4291E+00_JPRB,2.0473E+00_JPRB/)
KAO( :, 4, 9,12) = (/&
&3.9416E+00_JPRB,3.5045E+00_JPRB,3.1488E+00_JPRB,2.7628E+00_JPRB,2.4024E+00_JPRB,2.0175E+00_JPRB,&
&1.6727E+00_JPRB,1.6129E+00_JPRB,1.7549E+00_JPRB,1.8115E+00_JPRB,2.2264E+00_JPRB/)
KAO( :, 5, 9,12) = (/&
&3.9107E+00_JPRB,3.5025E+00_JPRB,3.1553E+00_JPRB,2.8210E+00_JPRB,2.4858E+00_JPRB,2.1278E+00_JPRB,&
&1.8886E+00_JPRB,1.9733E+00_JPRB,2.1611E+00_JPRB,2.2311E+00_JPRB,2.4535E+00_JPRB/)
KAO( :, 1,10,12) = (/&
&4.3955E+00_JPRB,3.8477E+00_JPRB,3.3521E+00_JPRB,2.8767E+00_JPRB,2.3926E+00_JPRB,1.8785E+00_JPRB,&
&1.3866E+00_JPRB,8.6336E-01_JPRB,6.3346E-01_JPRB,6.4780E-01_JPRB,7.3111E+00_JPRB/)
KAO( :, 2,10,12) = (/&
&4.3744E+00_JPRB,3.8521E+00_JPRB,3.3628E+00_JPRB,2.9299E+00_JPRB,2.4350E+00_JPRB,1.9605E+00_JPRB,&
&1.4761E+00_JPRB,9.8354E-01_JPRB,8.7753E-01_JPRB,9.0596E-01_JPRB,7.5369E+00_JPRB/)
KAO( :, 3,10,12) = (/&
&4.3454E+00_JPRB,3.8426E+00_JPRB,3.4089E+00_JPRB,2.9580E+00_JPRB,2.5003E+00_JPRB,2.0431E+00_JPRB,&
&1.5702E+00_JPRB,1.1751E+00_JPRB,1.1717E+00_JPRB,1.2103E+00_JPRB,7.6962E+00_JPRB/)
KAO( :, 4,10,12) = (/&
&4.3187E+00_JPRB,3.8382E+00_JPRB,3.4396E+00_JPRB,2.9970E+00_JPRB,2.5770E+00_JPRB,2.1340E+00_JPRB,&
&1.7005E+00_JPRB,1.4326E+00_JPRB,1.5105E+00_JPRB,1.5607E+00_JPRB,7.8986E+00_JPRB/)
KAO( :, 5,10,12) = (/&
&4.2903E+00_JPRB,3.8382E+00_JPRB,3.4516E+00_JPRB,3.0612E+00_JPRB,2.6632E+00_JPRB,2.2380E+00_JPRB,&
&1.8630E+00_JPRB,1.7458E+00_JPRB,1.8899E+00_JPRB,1.9522E+00_JPRB,8.1725E+00_JPRB/)
KAO( :, 1,11,12) = (/&
&4.7308E+00_JPRB,4.1459E+00_JPRB,3.6107E+00_JPRB,3.1115E+00_JPRB,2.5799E+00_JPRB,2.0280E+00_JPRB,&
&1.4948E+00_JPRB,9.2025E-01_JPRB,6.1405E-01_JPRB,6.1696E-01_JPRB,1.2757E+01_JPRB/)
KAO( :, 2,11,12) = (/&
&4.7091E+00_JPRB,4.1481E+00_JPRB,3.6443E+00_JPRB,3.1635E+00_JPRB,2.6293E+00_JPRB,2.1180E+00_JPRB,&
&1.5850E+00_JPRB,1.0412E+00_JPRB,8.3722E-01_JPRB,8.6133E-01_JPRB,1.3027E+01_JPRB/)
KAO( :, 3,11,12) = (/&
&4.6897E+00_JPRB,4.1435E+00_JPRB,3.6990E+00_JPRB,3.1970E+00_JPRB,2.7141E+00_JPRB,2.2094E+00_JPRB,&
&1.6909E+00_JPRB,1.1958E+00_JPRB,1.1123E+00_JPRB,1.1498E+00_JPRB,1.3314E+01_JPRB/)
KAO( :, 4,11,12) = (/&
&4.6692E+00_JPRB,4.1531E+00_JPRB,3.7297E+00_JPRB,3.2622E+00_JPRB,2.7974E+00_JPRB,2.3063E+00_JPRB,&
&1.8183E+00_JPRB,1.4163E+00_JPRB,1.4330E+00_JPRB,1.4813E+00_JPRB,1.3489E+01_JPRB/)
KAO( :, 5,11,12) = (/&
&4.6420E+00_JPRB,4.1769E+00_JPRB,3.7456E+00_JPRB,3.3296E+00_JPRB,2.8874E+00_JPRB,2.4151E+00_JPRB,&
&1.9751E+00_JPRB,1.6959E+00_JPRB,1.7942E+00_JPRB,1.8551E+00_JPRB,1.3680E+01_JPRB/)
KAO( :, 1,12,12) = (/&
&5.0416E+00_JPRB,4.4234E+00_JPRB,3.8522E+00_JPRB,3.3241E+00_JPRB,2.7470E+00_JPRB,2.1693E+00_JPRB,&
&1.6007E+00_JPRB,9.8107E-01_JPRB,5.9628E-01_JPRB,5.7876E-01_JPRB,1.6383E+01_JPRB/)
KAO( :, 2,12,12) = (/&
&5.0347E+00_JPRB,4.4335E+00_JPRB,3.9118E+00_JPRB,3.3765E+00_JPRB,2.8152E+00_JPRB,2.2721E+00_JPRB,&
&1.6921E+00_JPRB,1.0981E+00_JPRB,7.9216E-01_JPRB,8.0484E-01_JPRB,1.6695E+01_JPRB/)
KAO( :, 3,12,12) = (/&
&5.0354E+00_JPRB,4.4439E+00_JPRB,3.9725E+00_JPRB,3.4283E+00_JPRB,2.9170E+00_JPRB,2.3708E+00_JPRB,&
&1.8115E+00_JPRB,1.2441E+00_JPRB,1.0402E+00_JPRB,1.0726E+00_JPRB,1.7028E+01_JPRB/)
KAO( :, 4,12,12) = (/&
&5.0236E+00_JPRB,4.4684E+00_JPRB,4.0052E+00_JPRB,3.5139E+00_JPRB,3.0129E+00_JPRB,2.4842E+00_JPRB,&
&1.9405E+00_JPRB,1.4225E+00_JPRB,1.3339E+00_JPRB,1.3805E+00_JPRB,1.7215E+01_JPRB/)
KAO( :, 5,12,12) = (/&
&5.0049E+00_JPRB,4.5094E+00_JPRB,4.0368E+00_JPRB,3.5937E+00_JPRB,3.1097E+00_JPRB,2.6019E+00_JPRB,&
&2.0929E+00_JPRB,1.6533E+00_JPRB,1.6680E+00_JPRB,1.7268E+00_JPRB,1.7382E+01_JPRB/)
KAO( :, 1,13,12) = (/&
&5.3304E+00_JPRB,4.6811E+00_JPRB,4.0819E+00_JPRB,3.5134E+00_JPRB,2.8970E+00_JPRB,2.2995E+00_JPRB,&
&1.6906E+00_JPRB,1.0389E+00_JPRB,5.8422E-01_JPRB,5.3149E-01_JPRB,1.6186E+01_JPRB/)
KAO( :, 2,13,12) = (/&
&5.3554E+00_JPRB,4.7152E+00_JPRB,4.1740E+00_JPRB,3.5813E+00_JPRB,2.9917E+00_JPRB,2.4106E+00_JPRB,&
&1.7931E+00_JPRB,1.1573E+00_JPRB,7.4488E-01_JPRB,7.3540E-01_JPRB,1.6553E+01_JPRB/)
KAO( :, 3,13,12) = (/&
&5.3653E+00_JPRB,4.7361E+00_JPRB,4.2367E+00_JPRB,3.6559E+00_JPRB,3.0996E+00_JPRB,2.5206E+00_JPRB,&
&1.9222E+00_JPRB,1.2910E+00_JPRB,9.5651E-01_JPRB,9.7652E-01_JPRB,1.6790E+01_JPRB/)
KAO( :, 4,13,12) = (/&
&5.3597E+00_JPRB,4.7768E+00_JPRB,4.2708E+00_JPRB,3.7474E+00_JPRB,3.2027E+00_JPRB,2.6474E+00_JPRB,&
&2.0605E+00_JPRB,1.4452E+00_JPRB,1.2190E+00_JPRB,1.2583E+00_JPRB,1.6940E+01_JPRB/)
KAO( :, 5,13,12) = (/&
&5.3540E+00_JPRB,4.8243E+00_JPRB,4.3295E+00_JPRB,3.8360E+00_JPRB,3.3105E+00_JPRB,2.7756E+00_JPRB,&
&2.2095E+00_JPRB,1.6297E+00_JPRB,1.5189E+00_JPRB,1.5724E+00_JPRB,1.7194E+01_JPRB/)
KAO( :, 1, 1,13) = (/&
&2.4839E+00_JPRB,2.2228E+00_JPRB,1.9877E+00_JPRB,1.9817E+00_JPRB,2.1295E+00_JPRB,2.6064E+00_JPRB,&
&3.1026E+00_JPRB,3.6009E+00_JPRB,3.9384E+00_JPRB,4.0531E+00_JPRB,4.0630E+00_JPRB/)
KAO( :, 2, 1,13) = (/&
&2.4167E+00_JPRB,2.1788E+00_JPRB,2.0545E+00_JPRB,2.1075E+00_JPRB,2.4600E+00_JPRB,3.0319E+00_JPRB,&
&3.6075E+00_JPRB,4.1850E+00_JPRB,4.5773E+00_JPRB,4.7124E+00_JPRB,4.7383E+00_JPRB/)
KAO( :, 3, 1,13) = (/&
&2.3519E+00_JPRB,2.1341E+00_JPRB,2.1343E+00_JPRB,2.2717E+00_JPRB,2.8227E+00_JPRB,3.4785E+00_JPRB,&
&4.1394E+00_JPRB,4.8027E+00_JPRB,5.2528E+00_JPRB,5.4080E+00_JPRB,5.4468E+00_JPRB/)
KAO( :, 4, 1,13) = (/&
&2.2895E+00_JPRB,2.0936E+00_JPRB,2.2122E+00_JPRB,2.4949E+00_JPRB,3.2196E+00_JPRB,3.9764E+00_JPRB,&
&4.7367E+00_JPRB,5.4979E+00_JPRB,6.0151E+00_JPRB,6.1897E+00_JPRB,6.2191E+00_JPRB/)
KAO( :, 5, 1,13) = (/&
&2.2294E+00_JPRB,2.0855E+00_JPRB,2.2831E+00_JPRB,2.7897E+00_JPRB,3.6518E+00_JPRB,4.5202E+00_JPRB,&
&5.3909E+00_JPRB,6.2623E+00_JPRB,6.8525E+00_JPRB,7.0478E+00_JPRB,7.0466E+00_JPRB/)
KAO( :, 1, 2,13) = (/&
&2.6401E+00_JPRB,2.3655E+00_JPRB,2.1111E+00_JPRB,2.0137E+00_JPRB,2.0825E+00_JPRB,2.5044E+00_JPRB,&
&2.9828E+00_JPRB,3.4624E+00_JPRB,3.7882E+00_JPRB,3.8997E+00_JPRB,3.9250E+00_JPRB/)
KAO( :, 2, 2,13) = (/&
&2.5670E+00_JPRB,2.3197E+00_JPRB,2.1659E+00_JPRB,2.1086E+00_JPRB,2.3636E+00_JPRB,2.9098E+00_JPRB,&
&3.4676E+00_JPRB,4.0262E+00_JPRB,4.4056E+00_JPRB,4.5331E+00_JPRB,4.5625E+00_JPRB/)
KAO( :, 3, 2,13) = (/&
&2.4971E+00_JPRB,2.2719E+00_JPRB,2.2158E+00_JPRB,2.2307E+00_JPRB,2.7197E+00_JPRB,3.3654E+00_JPRB,&
&4.0138E+00_JPRB,4.6621E+00_JPRB,5.1023E+00_JPRB,5.2462E+00_JPRB,5.2684E+00_JPRB/)
KAO( :, 4, 2,13) = (/&
&2.4323E+00_JPRB,2.2338E+00_JPRB,2.2635E+00_JPRB,2.4358E+00_JPRB,3.1246E+00_JPRB,3.8712E+00_JPRB,&
&4.6205E+00_JPRB,5.3694E+00_JPRB,5.8768E+00_JPRB,6.0401E+00_JPRB,6.0554E+00_JPRB/)
KAO( :, 5, 2,13) = (/&
&2.3760E+00_JPRB,2.2281E+00_JPRB,2.3133E+00_JPRB,2.7376E+00_JPRB,3.5897E+00_JPRB,4.4519E+00_JPRB,&
&5.3157E+00_JPRB,6.1803E+00_JPRB,6.7635E+00_JPRB,6.9497E+00_JPRB,6.9610E+00_JPRB/)
KAO( :, 1, 3,13) = (/&
&2.8086E+00_JPRB,2.5114E+00_JPRB,2.2208E+00_JPRB,2.0677E+00_JPRB,2.0427E+00_JPRB,2.3373E+00_JPRB,&
&2.7874E+00_JPRB,3.2384E+00_JPRB,3.5440E+00_JPRB,3.6445E+00_JPRB,3.6749E+00_JPRB/)
KAO( :, 2, 3,13) = (/&
&2.7404E+00_JPRB,2.4643E+00_JPRB,2.2716E+00_JPRB,2.1464E+00_JPRB,2.2628E+00_JPRB,2.7529E+00_JPRB,&
&3.2849E+00_JPRB,3.8172E+00_JPRB,4.1782E+00_JPRB,4.2940E+00_JPRB,4.3270E+00_JPRB/)
KAO( :, 3, 3,13) = (/&
&2.6764E+00_JPRB,2.4178E+00_JPRB,2.3087E+00_JPRB,2.2456E+00_JPRB,2.5986E+00_JPRB,3.2215E+00_JPRB,&
&3.8463E+00_JPRB,4.4711E+00_JPRB,4.8938E+00_JPRB,5.0274E+00_JPRB,5.0645E+00_JPRB/)
KAO( :, 4, 3,13) = (/&
&2.6211E+00_JPRB,2.3803E+00_JPRB,2.3402E+00_JPRB,2.4064E+00_JPRB,3.0169E+00_JPRB,3.7447E+00_JPRB,&
&4.4738E+00_JPRB,5.2031E+00_JPRB,5.6949E+00_JPRB,5.8469E+00_JPRB,5.8866E+00_JPRB/)
KAO( :, 5, 3,13) = (/&
&2.5706E+00_JPRB,2.3763E+00_JPRB,2.3730E+00_JPRB,2.6809E+00_JPRB,3.4926E+00_JPRB,4.3391E+00_JPRB,&
&5.1873E+00_JPRB,6.0352E+00_JPRB,6.6054E+00_JPRB,6.7799E+00_JPRB,6.8242E+00_JPRB/)
KAO( :, 1, 4,13) = (/&
&2.9705E+00_JPRB,2.6437E+00_JPRB,2.3228E+00_JPRB,2.1502E+00_JPRB,2.0620E+00_JPRB,2.1581E+00_JPRB,&
&2.5548E+00_JPRB,2.9693E+00_JPRB,3.2504E+00_JPRB,3.3452E+00_JPRB,3.3799E+00_JPRB/)
KAO( :, 2, 4,13) = (/&
&2.9060E+00_JPRB,2.6045E+00_JPRB,2.3805E+00_JPRB,2.2339E+00_JPRB,2.2319E+00_JPRB,2.5887E+00_JPRB,&
&3.0909E+00_JPRB,3.5931E+00_JPRB,3.9330E+00_JPRB,4.0437E+00_JPRB,4.0869E+00_JPRB/)
KAO( :, 3, 4,13) = (/&
&2.8503E+00_JPRB,2.5669E+00_JPRB,2.4183E+00_JPRB,2.3219E+00_JPRB,2.5237E+00_JPRB,3.0875E+00_JPRB,&
&3.6882E+00_JPRB,4.2895E+00_JPRB,4.6950E+00_JPRB,4.8250E+00_JPRB,4.8772E+00_JPRB/)
KAO( :, 4, 4,13) = (/&
&2.8040E+00_JPRB,2.5355E+00_JPRB,2.4511E+00_JPRB,2.4730E+00_JPRB,2.9343E+00_JPRB,3.6460E+00_JPRB,&
&4.3587E+00_JPRB,5.0710E+00_JPRB,5.5512E+00_JPRB,5.6975E+00_JPRB,5.7609E+00_JPRB/)
KAO( :, 5, 4,13) = (/&
&2.7640E+00_JPRB,2.5346E+00_JPRB,2.4816E+00_JPRB,2.7138E+00_JPRB,3.4317E+00_JPRB,4.2678E+00_JPRB,&
&5.1048E+00_JPRB,5.9414E+00_JPRB,6.5038E+00_JPRB,6.6733E+00_JPRB,6.7499E+00_JPRB/)
KAO( :, 1, 5,13) = (/&
&3.2157E+00_JPRB,2.8490E+00_JPRB,2.4890E+00_JPRB,2.2607E+00_JPRB,2.1003E+00_JPRB,2.0316E+00_JPRB,&
&2.2821E+00_JPRB,2.6531E+00_JPRB,2.9050E+00_JPRB,2.9914E+00_JPRB,3.0227E+00_JPRB/)
KAO( :, 2, 5,13) = (/&
&3.1462E+00_JPRB,2.8052E+00_JPRB,2.5301E+00_JPRB,2.3469E+00_JPRB,2.2490E+00_JPRB,2.3958E+00_JPRB,&
&2.8314E+00_JPRB,3.2925E+00_JPRB,3.6050E+00_JPRB,3.7092E+00_JPRB,3.7515E+00_JPRB/)
KAO( :, 3, 5,13) = (/&
&3.0906E+00_JPRB,2.7658E+00_JPRB,2.5622E+00_JPRB,2.4318E+00_JPRB,2.4969E+00_JPRB,2.8886E+00_JPRB,&
&3.4523E+00_JPRB,4.0155E+00_JPRB,4.3974E+00_JPRB,4.5211E+00_JPRB,4.5746E+00_JPRB/)
KAO( :, 4, 5,13) = (/&
&3.0486E+00_JPRB,2.7373E+00_JPRB,2.5958E+00_JPRB,2.5683E+00_JPRB,2.8557E+00_JPRB,3.4815E+00_JPRB,&
&4.1633E+00_JPRB,4.8446E+00_JPRB,5.3051E+00_JPRB,5.4504E+00_JPRB,5.5199E+00_JPRB/)
KAO( :, 5, 5,13) = (/&
&3.0130E+00_JPRB,2.7440E+00_JPRB,2.6274E+00_JPRB,2.8078E+00_JPRB,3.3228E+00_JPRB,4.1277E+00_JPRB,&
&4.9382E+00_JPRB,5.7481E+00_JPRB,6.2955E+00_JPRB,6.4701E+00_JPRB,6.5508E+00_JPRB/)
KAO( :, 1, 6,13) = (/&
&3.5873E+00_JPRB,3.1674E+00_JPRB,2.7646E+00_JPRB,2.4502E+00_JPRB,2.1689E+00_JPRB,1.9718E+00_JPRB,&
&2.0147E+00_JPRB,2.3234E+00_JPRB,2.5447E+00_JPRB,2.6195E+00_JPRB,2.6494E+00_JPRB/)
KAO( :, 2, 6,13) = (/&
&3.5157E+00_JPRB,3.1229E+00_JPRB,2.7666E+00_JPRB,2.5046E+00_JPRB,2.2807E+00_JPRB,2.2712E+00_JPRB,&
&2.5407E+00_JPRB,2.9561E+00_JPRB,3.2371E+00_JPRB,3.3302E+00_JPRB,3.3702E+00_JPRB/)
KAO( :, 3, 6,13) = (/&
&3.4666E+00_JPRB,3.0873E+00_JPRB,2.7933E+00_JPRB,2.5658E+00_JPRB,2.5099E+00_JPRB,2.6904E+00_JPRB,&
&3.1624E+00_JPRB,3.6822E+00_JPRB,4.0323E+00_JPRB,4.1466E+00_JPRB,4.1994E+00_JPRB/)
KAO( :, 4, 6,13) = (/&
&3.4223E+00_JPRB,3.0572E+00_JPRB,2.8088E+00_JPRB,2.6700E+00_JPRB,2.8225E+00_JPRB,3.2304E+00_JPRB,&
&3.8614E+00_JPRB,4.4961E+00_JPRB,4.9248E+00_JPRB,5.0662E+00_JPRB,5.1277E+00_JPRB/)
KAO( :, 5, 6,13) = (/&
&3.3760E+00_JPRB,3.0424E+00_JPRB,2.8322E+00_JPRB,2.8911E+00_JPRB,3.2026E+00_JPRB,3.8541E+00_JPRB,&
&4.6128E+00_JPRB,5.3710E+00_JPRB,5.8848E+00_JPRB,6.0557E+00_JPRB,6.1288E+00_JPRB/)
KAO( :, 1, 7,13) = (/&
&4.0318E+00_JPRB,3.5414E+00_JPRB,3.1020E+00_JPRB,2.7107E+00_JPRB,2.3308E+00_JPRB,1.9686E+00_JPRB,&
&1.8437E+00_JPRB,2.0053E+00_JPRB,2.1966E+00_JPRB,2.2625E+00_JPRB,2.2876E+00_JPRB/)
KAO( :, 2, 7,13) = (/&
&3.9753E+00_JPRB,3.5219E+00_JPRB,3.0843E+00_JPRB,2.7586E+00_JPRB,2.3913E+00_JPRB,2.2135E+00_JPRB,&
&2.2792E+00_JPRB,2.6148E+00_JPRB,2.8647E+00_JPRB,2.9486E+00_JPRB,2.9838E+00_JPRB/)
KAO( :, 3, 7,13) = (/&
&3.9273E+00_JPRB,3.4958E+00_JPRB,3.1284E+00_JPRB,2.7893E+00_JPRB,2.5460E+00_JPRB,2.5637E+00_JPRB,&
&2.8433E+00_JPRB,3.3088E+00_JPRB,3.6254E+00_JPRB,3.7327E+00_JPRB,3.7756E+00_JPRB/)
KAO( :, 4, 7,13) = (/&
&3.8768E+00_JPRB,3.4612E+00_JPRB,3.1354E+00_JPRB,2.8419E+00_JPRB,2.8178E+00_JPRB,3.0023E+00_JPRB,&
&3.5065E+00_JPRB,4.0831E+00_JPRB,4.4749E+00_JPRB,4.6081E+00_JPRB,4.6607E+00_JPRB/)
KAO( :, 5, 7,13) = (/&
&3.8207E+00_JPRB,3.4295E+00_JPRB,3.1455E+00_JPRB,3.0110E+00_JPRB,3.1435E+00_JPRB,3.5518E+00_JPRB,&
&4.2303E+00_JPRB,4.9268E+00_JPRB,5.4004E+00_JPRB,5.5634E+00_JPRB,5.6245E+00_JPRB/)
KAO( :, 1, 8,13) = (/&
&4.5607E+00_JPRB,3.9914E+00_JPRB,3.4954E+00_JPRB,3.0029E+00_JPRB,2.5709E+00_JPRB,2.0712E+00_JPRB,&
&1.7381E+00_JPRB,1.7156E+00_JPRB,1.8751E+00_JPRB,1.9316E+00_JPRB,1.9534E+00_JPRB/)
KAO( :, 2, 8,13) = (/&
&4.5049E+00_JPRB,3.9749E+00_JPRB,3.4687E+00_JPRB,3.0674E+00_JPRB,2.6040E+00_JPRB,2.2247E+00_JPRB,&
&2.0925E+00_JPRB,2.2663E+00_JPRB,2.4833E+00_JPRB,2.5592E+00_JPRB,2.5867E+00_JPRB/)
KAO( :, 3, 8,13) = (/&
&4.4464E+00_JPRB,3.9470E+00_JPRB,3.5041E+00_JPRB,3.0976E+00_JPRB,2.6943E+00_JPRB,2.4990E+00_JPRB,&
&2.5535E+00_JPRB,2.9086E+00_JPRB,3.1877E+00_JPRB,3.2861E+00_JPRB,3.3201E+00_JPRB/)
KAO( :, 4, 8,13) = (/&
&4.3818E+00_JPRB,3.9082E+00_JPRB,3.5223E+00_JPRB,3.1240E+00_JPRB,2.8867E+00_JPRB,2.8624E+00_JPRB,&
&3.1305E+00_JPRB,3.6344E+00_JPRB,3.9841E+00_JPRB,4.1071E+00_JPRB,4.1503E+00_JPRB/)
KAO( :, 5, 8,13) = (/&
&4.3157E+00_JPRB,3.8635E+00_JPRB,3.5342E+00_JPRB,3.2389E+00_JPRB,3.1422E+00_JPRB,3.3087E+00_JPRB,&
&3.8133E+00_JPRB,4.4423E+00_JPRB,4.8694E+00_JPRB,5.0203E+00_JPRB,5.0730E+00_JPRB/)
KAO( :, 1, 9,13) = (/&
&5.1388E+00_JPRB,4.4967E+00_JPRB,3.9252E+00_JPRB,3.3415E+00_JPRB,2.8260E+00_JPRB,2.2549E+00_JPRB,&
&1.7301E+00_JPRB,1.4899E+00_JPRB,1.5781E+00_JPRB,1.6272E+00_JPRB,2.1902E+00_JPRB/)
KAO( :, 2, 9,13) = (/&
&5.0816E+00_JPRB,4.4676E+00_JPRB,3.8997E+00_JPRB,3.4081E+00_JPRB,2.8754E+00_JPRB,2.3488E+00_JPRB,&
&1.9883E+00_JPRB,1.9458E+00_JPRB,2.1210E+00_JPRB,2.1876E+00_JPRB,2.4675E+00_JPRB/)
KAO( :, 3, 9,13) = (/&
&5.0129E+00_JPRB,4.4339E+00_JPRB,3.9077E+00_JPRB,3.4536E+00_JPRB,2.9357E+00_JPRB,2.5363E+00_JPRB,&
&2.3438E+00_JPRB,2.5133E+00_JPRB,2.7551E+00_JPRB,2.8417E+00_JPRB,2.9456E+00_JPRB/)
KAO( :, 4, 9,13) = (/&
&4.9367E+00_JPRB,4.3927E+00_JPRB,3.9413E+00_JPRB,3.4799E+00_JPRB,3.0724E+00_JPRB,2.8062E+00_JPRB,&
&2.8193E+00_JPRB,3.1848E+00_JPRB,3.4916E+00_JPRB,3.6009E+00_JPRB,3.6428E+00_JPRB/)
KAO( :, 5, 9,13) = (/&
&4.8646E+00_JPRB,4.3466E+00_JPRB,3.9578E+00_JPRB,3.5604E+00_JPRB,3.2602E+00_JPRB,3.1715E+00_JPRB,&
&3.4132E+00_JPRB,3.9460E+00_JPRB,4.3263E+00_JPRB,4.4628E+00_JPRB,4.5130E+00_JPRB/)
KAO( :, 1,10,13) = (/&
&5.7351E+00_JPRB,5.0184E+00_JPRB,4.3590E+00_JPRB,3.7061E+00_JPRB,3.1107E+00_JPRB,2.4665E+00_JPRB,&
&1.8265E+00_JPRB,1.3589E+00_JPRB,1.3281E+00_JPRB,1.3706E+00_JPRB,9.6850E+00_JPRB/)
KAO( :, 2,10,13) = (/&
&5.6702E+00_JPRB,4.9713E+00_JPRB,4.3505E+00_JPRB,3.7771E+00_JPRB,3.1762E+00_JPRB,2.5499E+00_JPRB,&
&2.0068E+00_JPRB,1.7165E+00_JPRB,1.8132E+00_JPRB,1.8713E+00_JPRB,1.0044E+01_JPRB/)
KAO( :, 3,10,13) = (/&
&5.6012E+00_JPRB,4.9439E+00_JPRB,4.3471E+00_JPRB,3.8363E+00_JPRB,3.2324E+00_JPRB,2.7093E+00_JPRB,&
&2.2713E+00_JPRB,2.1992E+00_JPRB,2.3944E+00_JPRB,2.4708E+00_JPRB,1.0371E+01_JPRB/)
KAO( :, 4,10,13) = (/&
&5.5289E+00_JPRB,4.9007E+00_JPRB,4.3908E+00_JPRB,3.8627E+00_JPRB,3.3600E+00_JPRB,2.8996E+00_JPRB,&
&2.6404E+00_JPRB,2.8075E+00_JPRB,3.0779E+00_JPRB,3.1762E+00_JPRB,1.0595E+01_JPRB/)
KAO( :, 5,10,13) = (/&
&5.4567E+00_JPRB,4.8683E+00_JPRB,4.4123E+00_JPRB,3.9290E+00_JPRB,3.4997E+00_JPRB,3.1758E+00_JPRB,&
&3.1346E+00_JPRB,3.5190E+00_JPRB,3.8593E+00_JPRB,3.9826E+00_JPRB,1.0862E+01_JPRB/)
KAO( :, 1,11,13) = (/&
&6.3333E+00_JPRB,5.5418E+00_JPRB,4.8105E+00_JPRB,4.1265E+00_JPRB,3.4538E+00_JPRB,2.7288E+00_JPRB,&
&2.0255E+00_JPRB,1.4130E+00_JPRB,1.2863E+00_JPRB,1.3280E+00_JPRB,1.7958E+01_JPRB/)
KAO( :, 2,11,13) = (/&
&6.2689E+00_JPRB,5.5023E+00_JPRB,4.8148E+00_JPRB,4.2028E+00_JPRB,3.5226E+00_JPRB,2.8349E+00_JPRB,&
&2.1999E+00_JPRB,1.7269E+00_JPRB,1.7697E+00_JPRB,1.8270E+00_JPRB,1.8277E+01_JPRB/)
KAO( :, 3,11,13) = (/&
&6.2039E+00_JPRB,5.4744E+00_JPRB,4.8374E+00_JPRB,4.2598E+00_JPRB,3.5999E+00_JPRB,3.0009E+00_JPRB,&
&2.4146E+00_JPRB,2.1815E+00_JPRB,2.3423E+00_JPRB,2.4181E+00_JPRB,1.8696E+01_JPRB/)
KAO( :, 4,11,13) = (/&
&6.1388E+00_JPRB,5.4345E+00_JPRB,4.8963E+00_JPRB,4.2927E+00_JPRB,3.7367E+00_JPRB,3.1778E+00_JPRB,&
&2.7380E+00_JPRB,2.7546E+00_JPRB,3.0088E+00_JPRB,3.1059E+00_JPRB,1.9174E+01_JPRB/)
KAO( :, 5,11,13) = (/&
&6.0780E+00_JPRB,5.4134E+00_JPRB,4.9226E+00_JPRB,4.3897E+00_JPRB,3.8870E+00_JPRB,3.4157E+00_JPRB,&
&3.1673E+00_JPRB,3.4320E+00_JPRB,3.7647E+00_JPRB,3.8872E+00_JPRB,1.9497E+01_JPRB/)
KAO( :, 1,12,13) = (/&
&6.9733E+00_JPRB,6.1019E+00_JPRB,5.2948E+00_JPRB,4.5762E+00_JPRB,3.8194E+00_JPRB,3.0108E+00_JPRB,&
&2.2358E+00_JPRB,1.4812E+00_JPRB,1.2391E+00_JPRB,1.2773E+00_JPRB,2.4501E+01_JPRB/)
KAO( :, 2,12,13) = (/&
&6.9181E+00_JPRB,6.0812E+00_JPRB,5.3188E+00_JPRB,4.6589E+00_JPRB,3.8924E+00_JPRB,3.1398E+00_JPRB,&
&2.4112E+00_JPRB,1.7577E+00_JPRB,1.7083E+00_JPRB,1.7645E+00_JPRB,2.4773E+01_JPRB/)
KAO( :, 3,12,13) = (/&
&6.8566E+00_JPRB,6.0530E+00_JPRB,5.3874E+00_JPRB,4.7146E+00_JPRB,3.9882E+00_JPRB,3.3020E+00_JPRB,&
&2.6071E+00_JPRB,2.1662E+00_JPRB,2.2758E+00_JPRB,2.3503E+00_JPRB,2.5275E+01_JPRB/)
KAO( :, 4,12,13) = (/&
&6.7979E+00_JPRB,6.0149E+00_JPRB,5.4468E+00_JPRB,4.7610E+00_JPRB,4.1335E+00_JPRB,3.4795E+00_JPRB,&
&2.8840E+00_JPRB,2.7114E+00_JPRB,2.9349E+00_JPRB,3.0298E+00_JPRB,2.5870E+01_JPRB/)
KAO( :, 5,12,13) = (/&
&6.7411E+00_JPRB,6.0058E+00_JPRB,5.4709E+00_JPRB,4.8727E+00_JPRB,4.2890E+00_JPRB,3.6876E+00_JPRB,&
&3.2559E+00_JPRB,3.3514E+00_JPRB,3.6668E+00_JPRB,3.7859E+00_JPRB,2.6254E+01_JPRB/)
KAO( :, 1,13,13) = (/&
&7.6256E+00_JPRB,6.6753E+00_JPRB,5.7900E+00_JPRB,5.0347E+00_JPRB,4.1913E+00_JPRB,3.3018E+00_JPRB,&
&2.4527E+00_JPRB,1.5669E+00_JPRB,1.1934E+00_JPRB,1.2215E+00_JPRB,2.5519E+01_JPRB/)
KAO( :, 2,13,13) = (/&
&7.5682E+00_JPRB,6.6598E+00_JPRB,5.8333E+00_JPRB,5.1240E+00_JPRB,4.2715E+00_JPRB,3.4570E+00_JPRB,&
&2.6249E+00_JPRB,1.8136E+00_JPRB,1.6447E+00_JPRB,1.6979E+00_JPRB,2.5832E+01_JPRB/)
KAO( :, 3,13,13) = (/&
&7.5147E+00_JPRB,6.6337E+00_JPRB,5.9406E+00_JPRB,5.1772E+00_JPRB,4.3985E+00_JPRB,3.6181E+00_JPRB,&
&2.8202E+00_JPRB,2.1840E+00_JPRB,2.2018E+00_JPRB,2.2745E+00_JPRB,2.6512E+01_JPRB/)
KAO( :, 4,13,13) = (/&
&7.4664E+00_JPRB,6.6067E+00_JPRB,6.0077E+00_JPRB,5.2519E+00_JPRB,4.5469E+00_JPRB,3.7922E+00_JPRB,&
&3.0751E+00_JPRB,2.6716E+00_JPRB,2.8374E+00_JPRB,2.9314E+00_JPRB,2.7153E+01_JPRB/)
KAO( :, 5,13,13) = (/&
&7.4088E+00_JPRB,6.6207E+00_JPRB,6.0282E+00_JPRB,5.3739E+00_JPRB,4.7039E+00_JPRB,4.0017E+00_JPRB,&
&3.3998E+00_JPRB,3.2768E+00_JPRB,3.5575E+00_JPRB,3.6746E+00_JPRB,2.7529E+01_JPRB/)
KAO( :, 1, 1,14) = (/&
&2.8887E+00_JPRB,2.5952E+00_JPRB,2.4344E+00_JPRB,2.7140E+00_JPRB,3.5782E+00_JPRB,4.4490E+00_JPRB,&
&5.3193E+00_JPRB,6.1891E+00_JPRB,6.7728E+00_JPRB,6.9450E+00_JPRB,6.8281E+00_JPRB/)
KAO( :, 2, 1,14) = (/&
&2.8442E+00_JPRB,2.6117E+00_JPRB,2.5016E+00_JPRB,3.2440E+00_JPRB,4.2873E+00_JPRB,5.3316E+00_JPRB,&
&6.3758E+00_JPRB,7.4184E+00_JPRB,8.1189E+00_JPRB,8.3231E+00_JPRB,8.1685E+00_JPRB/)
KAO( :, 3, 1,14) = (/&
&2.8000E+00_JPRB,2.6157E+00_JPRB,2.7106E+00_JPRB,3.8144E+00_JPRB,5.0435E+00_JPRB,6.2737E+00_JPRB,&
&7.5035E+00_JPRB,8.7311E+00_JPRB,9.5570E+00_JPRB,9.7945E+00_JPRB,9.6021E+00_JPRB/)
KAO( :, 4, 1,14) = (/&
&2.7537E+00_JPRB,2.6124E+00_JPRB,3.0214E+00_JPRB,4.4121E+00_JPRB,5.8371E+00_JPRB,7.2628E+00_JPRB,&
&8.6899E+00_JPRB,1.0113E+01_JPRB,1.1069E+01_JPRB,1.1344E+01_JPRB,1.1112E+01_JPRB/)
KAO( :, 5, 1,14) = (/&
&2.7061E+00_JPRB,2.6132E+00_JPRB,3.3957E+00_JPRB,5.0168E+00_JPRB,6.6412E+00_JPRB,8.2665E+00_JPRB,&
&9.8911E+00_JPRB,1.1513E+01_JPRB,1.2604E+01_JPRB,1.2922E+01_JPRB,1.2679E+01_JPRB/)
KAO( :, 1, 2,14) = (/&
&3.0576E+00_JPRB,2.7352E+00_JPRB,2.5260E+00_JPRB,2.7828E+00_JPRB,3.6218E+00_JPRB,4.5046E+00_JPRB,&
&5.3876E+00_JPRB,6.2699E+00_JPRB,6.8610E+00_JPRB,7.0352E+00_JPRB,6.9906E+00_JPRB/)
KAO( :, 2, 2,14) = (/&
&3.0061E+00_JPRB,2.7324E+00_JPRB,2.6141E+00_JPRB,3.3196E+00_JPRB,4.3910E+00_JPRB,5.4630E+00_JPRB,&
&6.5356E+00_JPRB,7.6067E+00_JPRB,8.3258E+00_JPRB,8.5350E+00_JPRB,8.4749E+00_JPRB/)
KAO( :, 3, 2,14) = (/&
&2.9525E+00_JPRB,2.7255E+00_JPRB,2.8471E+00_JPRB,3.9327E+00_JPRB,5.2058E+00_JPRB,6.4796E+00_JPRB,&
&7.7532E+00_JPRB,9.0260E+00_JPRB,9.8805E+00_JPRB,1.0131E+01_JPRB,1.0067E+01_JPRB/)
KAO( :, 4, 2,14) = (/&
&2.8984E+00_JPRB,2.7145E+00_JPRB,3.1607E+00_JPRB,4.5565E+00_JPRB,6.0350E+00_JPRB,7.5142E+00_JPRB,&
&8.9933E+00_JPRB,1.0470E+01_JPRB,1.1465E+01_JPRB,1.1763E+01_JPRB,1.1703E+01_JPRB/)
KAO( :, 5, 2,14) = (/&
&2.8438E+00_JPRB,2.7189E+00_JPRB,3.5222E+00_JPRB,5.1840E+00_JPRB,6.8691E+00_JPRB,8.5548E+00_JPRB,&
&1.0241E+01_JPRB,1.1924E+01_JPRB,1.3058E+01_JPRB,1.3402E+01_JPRB,1.3350E+01_JPRB/)
KAO( :, 1, 3,14) = (/&
&3.2627E+00_JPRB,2.9257E+00_JPRB,2.6844E+00_JPRB,2.7974E+00_JPRB,3.4992E+00_JPRB,4.3540E+00_JPRB,&
&5.2086E+00_JPRB,6.0626E+00_JPRB,6.6362E+00_JPRB,6.8051E+00_JPRB,6.8438E+00_JPRB/)
KAO( :, 2, 3,14) = (/&
&3.2141E+00_JPRB,2.9285E+00_JPRB,2.7611E+00_JPRB,3.2879E+00_JPRB,4.2959E+00_JPRB,5.3479E+00_JPRB,&
&6.3996E+00_JPRB,7.4507E+00_JPRB,8.1567E+00_JPRB,8.3690E+00_JPRB,8.4216E+00_JPRB/)
KAO( :, 3, 3,14) = (/&
&3.1592E+00_JPRB,2.9193E+00_JPRB,2.9657E+00_JPRB,3.8707E+00_JPRB,5.1268E+00_JPRB,6.3848E+00_JPRB,&
&7.6422E+00_JPRB,8.8991E+00_JPRB,9.7445E+00_JPRB,1.0003E+01_JPRB,1.0068E+01_JPRB/)
KAO( :, 4, 3,14) = (/&
&3.1015E+00_JPRB,2.9015E+00_JPRB,3.2432E+00_JPRB,4.5116E+00_JPRB,5.9798E+00_JPRB,7.4486E+00_JPRB,&
&8.9182E+00_JPRB,1.0386E+01_JPRB,1.1375E+01_JPRB,1.1682E+01_JPRB,1.1760E+01_JPRB/)
KAO( :, 5, 3,14) = (/&
&3.0445E+00_JPRB,2.9022E+00_JPRB,3.5824E+00_JPRB,5.1608E+00_JPRB,6.8436E+00_JPRB,8.5264E+00_JPRB,&
&1.0210E+01_JPRB,1.1891E+01_JPRB,1.3025E+01_JPRB,1.3379E+01_JPRB,1.3473E+01_JPRB/)
KAO( :, 1, 4,14) = (/&
&3.5400E+00_JPRB,3.1664E+00_JPRB,2.9101E+00_JPRB,2.8758E+00_JPRB,3.3348E+00_JPRB,4.1525E+00_JPRB,&
&4.9718E+00_JPRB,5.7899E+00_JPRB,6.3397E+00_JPRB,6.5008E+00_JPRB,6.5768E+00_JPRB/)
KAO( :, 2, 4,14) = (/&
&3.4855E+00_JPRB,3.1790E+00_JPRB,2.9576E+00_JPRB,3.2747E+00_JPRB,4.1109E+00_JPRB,5.1228E+00_JPRB,&
&6.1348E+00_JPRB,7.1442E+00_JPRB,7.8249E+00_JPRB,8.0301E+00_JPRB,8.1227E+00_JPRB/)
KAO( :, 3, 4,14) = (/&
&3.4320E+00_JPRB,3.1719E+00_JPRB,3.1607E+00_JPRB,3.7785E+00_JPRB,4.9272E+00_JPRB,6.1416E+00_JPRB,&
&7.3563E+00_JPRB,8.5691E+00_JPRB,9.3880E+00_JPRB,9.6426E+00_JPRB,9.7500E+00_JPRB/)
KAO( :, 4, 4,14) = (/&
&3.3791E+00_JPRB,3.1599E+00_JPRB,3.3859E+00_JPRB,4.3631E+00_JPRB,5.7749E+00_JPRB,7.1988E+00_JPRB,&
&8.6228E+00_JPRB,1.0046E+01_JPRB,1.1007E+01_JPRB,1.1312E+01_JPRB,1.1439E+01_JPRB/)
KAO( :, 5, 4,14) = (/&
&3.3258E+00_JPRB,3.1591E+00_JPRB,3.6665E+00_JPRB,5.0052E+00_JPRB,6.6441E+00_JPRB,8.2840E+00_JPRB,&
&9.9242E+00_JPRB,1.1564E+01_JPRB,1.2671E+01_JPRB,1.3030E+01_JPRB,1.3170E+01_JPRB/)
KAO( :, 1, 5,14) = (/&
&3.8712E+00_JPRB,3.4337E+00_JPRB,3.1666E+00_JPRB,3.0128E+00_JPRB,3.2471E+00_JPRB,3.9337E+00_JPRB,&
&4.7121E+00_JPRB,5.4892E+00_JPRB,6.0120E+00_JPRB,6.1700E+00_JPRB,6.2549E+00_JPRB/)
KAO( :, 2, 5,14) = (/&
&3.8269E+00_JPRB,3.4694E+00_JPRB,3.1866E+00_JPRB,3.3432E+00_JPRB,3.9282E+00_JPRB,4.8845E+00_JPRB,&
&5.8524E+00_JPRB,6.8187E+00_JPRB,7.4706E+00_JPRB,7.6730E+00_JPRB,7.7736E+00_JPRB/)
KAO( :, 3, 5,14) = (/&
&3.7755E+00_JPRB,3.4748E+00_JPRB,3.3901E+00_JPRB,3.7632E+00_JPRB,4.7202E+00_JPRB,5.8870E+00_JPRB,&
&7.0546E+00_JPRB,8.2214E+00_JPRB,9.0082E+00_JPRB,9.2591E+00_JPRB,9.3759E+00_JPRB/)
KAO( :, 4, 5,14) = (/&
&3.7208E+00_JPRB,3.4667E+00_JPRB,3.6066E+00_JPRB,4.2692E+00_JPRB,5.5501E+00_JPRB,6.9232E+00_JPRB,&
&8.2967E+00_JPRB,9.6704E+00_JPRB,1.0598E+01_JPRB,1.0900E+01_JPRB,1.1032E+01_JPRB/)
KAO( :, 5, 5,14) = (/&
&3.6685E+00_JPRB,3.4626E+00_JPRB,3.8317E+00_JPRB,4.8383E+00_JPRB,6.4165E+00_JPRB,8.0063E+00_JPRB,&
&9.5964E+00_JPRB,1.1185E+01_JPRB,1.2259E+01_JPRB,1.2606E+01_JPRB,1.2759E+01_JPRB/)
KAO( :, 1, 6,14) = (/&
&4.2985E+00_JPRB,3.7747E+00_JPRB,3.4577E+00_JPRB,3.1550E+00_JPRB,3.2497E+00_JPRB,3.6558E+00_JPRB,&
&4.3601E+00_JPRB,5.0812E+00_JPRB,5.5670E+00_JPRB,5.7208E+00_JPRB,5.7987E+00_JPRB/)
KAO( :, 2, 6,14) = (/&
&4.2427E+00_JPRB,3.8123E+00_JPRB,3.4653E+00_JPRB,3.4897E+00_JPRB,3.8064E+00_JPRB,4.5507E+00_JPRB,&
&5.4535E+00_JPRB,6.3569E+00_JPRB,6.9669E+00_JPRB,7.1637E+00_JPRB,7.2558E+00_JPRB/)
KAO( :, 3, 6,14) = (/&
&4.1875E+00_JPRB,3.8273E+00_JPRB,3.6255E+00_JPRB,3.8306E+00_JPRB,4.4762E+00_JPRB,5.5205E+00_JPRB,&
&6.6168E+00_JPRB,7.7121E+00_JPRB,8.4537E+00_JPRB,8.6967E+00_JPRB,8.8046E+00_JPRB/)
KAO( :, 4, 6,14) = (/&
&4.1387E+00_JPRB,3.8237E+00_JPRB,3.8813E+00_JPRB,4.2503E+00_JPRB,5.2544E+00_JPRB,6.5579E+00_JPRB,&
&7.8608E+00_JPRB,9.1631E+00_JPRB,1.0044E+01_JPRB,1.0331E+01_JPRB,1.0461E+01_JPRB/)
KAO( :, 5, 6,14) = (/&
&4.0993E+00_JPRB,3.8210E+00_JPRB,4.0697E+00_JPRB,4.7381E+00_JPRB,6.1433E+00_JPRB,7.6683E+00_JPRB,&
&9.1923E+00_JPRB,1.0715E+01_JPRB,1.1746E+01_JPRB,1.2082E+01_JPRB,1.2233E+01_JPRB/)
KAO( :, 1, 7,14) = (/&
&4.8729E+00_JPRB,4.2640E+00_JPRB,3.8474E+00_JPRB,3.3679E+00_JPRB,3.3344E+00_JPRB,3.4772E+00_JPRB,&
&3.9641E+00_JPRB,4.6207E+00_JPRB,5.0642E+00_JPRB,5.2074E+00_JPRB,5.2771E+00_JPRB/)
KAO( :, 2, 7,14) = (/&
&4.7919E+00_JPRB,4.2473E+00_JPRB,3.8324E+00_JPRB,3.6623E+00_JPRB,3.7914E+00_JPRB,4.2248E+00_JPRB,&
&5.0116E+00_JPRB,5.8421E+00_JPRB,6.4042E+00_JPRB,6.5890E+00_JPRB,6.6727E+00_JPRB/)
KAO( :, 3, 7,14) = (/&
&4.7214E+00_JPRB,4.2557E+00_JPRB,3.9089E+00_JPRB,4.0054E+00_JPRB,4.3393E+00_JPRB,5.1382E+00_JPRB,&
&6.1595E+00_JPRB,7.1803E+00_JPRB,7.8713E+00_JPRB,8.0973E+00_JPRB,8.2014E+00_JPRB/)
KAO( :, 4, 7,14) = (/&
&4.6651E+00_JPRB,4.2593E+00_JPRB,4.1634E+00_JPRB,4.3388E+00_JPRB,5.0089E+00_JPRB,6.1843E+00_JPRB,&
&7.4141E+00_JPRB,8.6442E+00_JPRB,9.4748E+00_JPRB,9.7461E+00_JPRB,9.8717E+00_JPRB/)
KAO( :, 5, 7,14) = (/&
&4.6229E+00_JPRB,4.2611E+00_JPRB,4.3711E+00_JPRB,4.7337E+00_JPRB,5.8551E+00_JPRB,7.3079E+00_JPRB,&
&8.7620E+00_JPRB,1.0215E+01_JPRB,1.1197E+01_JPRB,1.1518E+01_JPRB,1.1668E+01_JPRB/)
KAO( :, 1, 8,14) = (/&
&5.5925E+00_JPRB,4.8936E+00_JPRB,4.3354E+00_JPRB,3.7383E+00_JPRB,3.4607E+00_JPRB,3.3817E+00_JPRB,&
&3.5604E+00_JPRB,4.1011E+00_JPRB,4.4961E+00_JPRB,4.6277E+00_JPRB,4.6848E+00_JPRB/)
KAO( :, 2, 8,14) = (/&
&5.4938E+00_JPRB,4.8247E+00_JPRB,4.3191E+00_JPRB,3.9163E+00_JPRB,3.8835E+00_JPRB,4.0306E+00_JPRB,&
&4.5806E+00_JPRB,5.3399E+00_JPRB,5.8538E+00_JPRB,6.0240E+00_JPRB,6.1006E+00_JPRB/)
KAO( :, 3, 8,14) = (/&
&5.4085E+00_JPRB,4.8212E+00_JPRB,4.3278E+00_JPRB,4.2425E+00_JPRB,4.3274E+00_JPRB,4.8175E+00_JPRB,&
&5.7136E+00_JPRB,6.6616E+00_JPRB,7.3038E+00_JPRB,7.5143E+00_JPRB,7.6111E+00_JPRB/)
KAO( :, 4, 8,14) = (/&
&5.3368E+00_JPRB,4.8168E+00_JPRB,4.5230E+00_JPRB,4.5538E+00_JPRB,4.8873E+00_JPRB,5.8090E+00_JPRB,&
&6.9627E+00_JPRB,8.1174E+00_JPRB,8.9008E+00_JPRB,9.1580E+00_JPRB,9.2752E+00_JPRB/)
KAO( :, 5, 8,14) = (/&
&5.2815E+00_JPRB,4.8169E+00_JPRB,4.7320E+00_JPRB,4.8661E+00_JPRB,5.6370E+00_JPRB,6.9370E+00_JPRB,&
&8.3184E+00_JPRB,9.6982E+00_JPRB,1.0633E+01_JPRB,1.0941E+01_JPRB,1.1084E+01_JPRB/)
KAO( :, 1, 9,14) = (/&
&6.4577E+00_JPRB,5.6507E+00_JPRB,4.9407E+00_JPRB,4.2286E+00_JPRB,3.7253E+00_JPRB,3.3779E+00_JPRB,&
&3.2319E+00_JPRB,3.5421E+00_JPRB,3.8831E+00_JPRB,3.9990E+00_JPRB,4.0498E+00_JPRB/)
KAO( :, 2, 9,14) = (/&
&6.3422E+00_JPRB,5.5498E+00_JPRB,4.9222E+00_JPRB,4.3098E+00_JPRB,4.0685E+00_JPRB,3.8931E+00_JPRB,&
&4.1244E+00_JPRB,4.7547E+00_JPRB,5.2133E+00_JPRB,5.3678E+00_JPRB,5.4322E+00_JPRB/)
KAO( :, 3, 9,14) = (/&
&6.2329E+00_JPRB,5.5111E+00_JPRB,4.9049E+00_JPRB,4.5899E+00_JPRB,4.4547E+00_JPRB,4.5979E+00_JPRB,&
&5.2352E+00_JPRB,6.1039E+00_JPRB,6.6924E+00_JPRB,6.8898E+00_JPRB,6.9747E+00_JPRB/)
KAO( :, 4, 9,14) = (/&
&6.1515E+00_JPRB,5.4910E+00_JPRB,5.0222E+00_JPRB,4.8653E+00_JPRB,4.9067E+00_JPRB,5.4882E+00_JPRB,&
&6.4831E+00_JPRB,7.5599E+00_JPRB,8.2895E+00_JPRB,8.5312E+00_JPRB,8.6396E+00_JPRB/)
KAO( :, 5, 9,14) = (/&
&6.0869E+00_JPRB,5.4865E+00_JPRB,5.2250E+00_JPRB,5.1325E+00_JPRB,5.5425E+00_JPRB,6.5444E+00_JPRB,&
&7.8337E+00_JPRB,9.1350E+00_JPRB,1.0015E+01_JPRB,1.0307E+01_JPRB,1.0438E+01_JPRB/)
KAO( :, 1,10,14) = (/&
&7.4443E+00_JPRB,6.5140E+00_JPRB,5.6562E+00_JPRB,4.8450E+00_JPRB,4.1266E+00_JPRB,3.5478E+00_JPRB,&
&3.0700E+00_JPRB,3.0881E+00_JPRB,3.3779E+00_JPRB,3.4799E+00_JPRB,1.2058E+01_JPRB/)
KAO( :, 2,10,14) = (/&
&7.3221E+00_JPRB,6.4071E+00_JPRB,5.6365E+00_JPRB,4.8644E+00_JPRB,4.3967E+00_JPRB,3.9545E+00_JPRB,&
&3.8217E+00_JPRB,4.2441E+00_JPRB,4.6539E+00_JPRB,4.7937E+00_JPRB,1.2410E+01_JPRB/)
KAO( :, 3,10,14) = (/&
&7.2124E+00_JPRB,6.3403E+00_JPRB,5.6271E+00_JPRB,5.0725E+00_JPRB,4.7313E+00_JPRB,4.4923E+00_JPRB,&
&4.8301E+00_JPRB,5.5719E+00_JPRB,6.1108E+00_JPRB,6.2952E+00_JPRB,1.2954E+01_JPRB/)
KAO( :, 4,10,14) = (/&
&7.1175E+00_JPRB,6.3123E+00_JPRB,5.6779E+00_JPRB,5.3374E+00_JPRB,5.0908E+00_JPRB,5.2975E+00_JPRB,&
&6.0440E+00_JPRB,7.0430E+00_JPRB,7.7247E+00_JPRB,7.9559E+00_JPRB,1.3387E+01_JPRB/)
KAO( :, 5,10,14) = (/&
&7.0366E+00_JPRB,6.2756E+00_JPRB,5.8648E+00_JPRB,5.5670E+00_JPRB,5.6360E+00_JPRB,6.2965E+00_JPRB,&
&7.4267E+00_JPRB,8.6602E+00_JPRB,9.4961E+00_JPRB,9.7792E+00_JPRB,1.3845E+01_JPRB/)
KAO( :, 1,11,14) = (/&
&8.4957E+00_JPRB,7.4339E+00_JPRB,6.4512E+00_JPRB,5.5185E+00_JPRB,4.7207E+00_JPRB,3.9718E+00_JPRB,&
&3.2916E+00_JPRB,3.1500E+00_JPRB,3.4253E+00_JPRB,3.5296E+00_JPRB,2.3513E+01_JPRB/)
KAO( :, 2,11,14) = (/&
&8.3816E+00_JPRB,7.3341E+00_JPRB,6.4276E+00_JPRB,5.6044E+00_JPRB,4.9602E+00_JPRB,4.3313E+00_JPRB,&
&3.9798E+00_JPRB,4.2912E+00_JPRB,4.7066E+00_JPRB,4.8505E+00_JPRB,2.3943E+01_JPRB/)
KAO( :, 3,11,14) = (/&
&8.2705E+00_JPRB,7.2767E+00_JPRB,6.4537E+00_JPRB,5.8081E+00_JPRB,5.2448E+00_JPRB,4.8172E+00_JPRB,&
&4.9716E+00_JPRB,5.6457E+00_JPRB,6.1916E+00_JPRB,6.3804E+00_JPRB,2.4436E+01_JPRB/)
KAO( :, 4,11,14) = (/&
&8.1691E+00_JPRB,7.2418E+00_JPRB,6.5336E+00_JPRB,6.0302E+00_JPRB,5.5871E+00_JPRB,5.5776E+00_JPRB,&
&6.1920E+00_JPRB,7.1803E+00_JPRB,7.8743E+00_JPRB,8.1125E+00_JPRB,2.5073E+01_JPRB/)
KAO( :, 5,11,14) = (/&
&8.0687E+00_JPRB,7.1847E+00_JPRB,6.6868E+00_JPRB,6.2347E+00_JPRB,6.0989E+00_JPRB,6.5755E+00_JPRB,&
&7.6314E+00_JPRB,8.8985E+00_JPRB,9.7576E+00_JPRB,1.0049E+01_JPRB,2.5623E+01_JPRB/)
KAO( :, 1,12,14) = (/&
&9.6896E+00_JPRB,8.4786E+00_JPRB,7.3560E+00_JPRB,6.2642E+00_JPRB,5.3896E+00_JPRB,4.4442E+00_JPRB,&
&3.5654E+00_JPRB,3.2232E+00_JPRB,3.4640E+00_JPRB,3.5704E+00_JPRB,3.3781E+01_JPRB/)
KAO( :, 2,12,14) = (/&
&9.5610E+00_JPRB,8.3661E+00_JPRB,7.3175E+00_JPRB,6.4413E+00_JPRB,5.6023E+00_JPRB,4.7562E+00_JPRB,&
&4.1907E+00_JPRB,4.3435E+00_JPRB,4.7515E+00_JPRB,4.8976E+00_JPRB,3.4305E+01_JPRB/)
KAO( :, 3,12,14) = (/&
&9.4357E+00_JPRB,8.3098E+00_JPRB,7.3390E+00_JPRB,6.6507E+00_JPRB,5.8481E+00_JPRB,5.2296E+00_JPRB,&
&5.1297E+00_JPRB,5.7060E+00_JPRB,6.2577E+00_JPRB,6.4493E+00_JPRB,3.4708E+01_JPRB/)
KAO( :, 4,12,14) = (/&
&9.3148E+00_JPRB,8.2568E+00_JPRB,7.4893E+00_JPRB,6.8212E+00_JPRB,6.1645E+00_JPRB,5.9310E+00_JPRB,&
&6.3510E+00_JPRB,7.2870E+00_JPRB,7.9920E+00_JPRB,8.2360E+00_JPRB,3.5460E+01_JPRB/)
KAO( :, 5,12,14) = (/&
&9.1990E+00_JPRB,8.1836E+00_JPRB,7.6152E+00_JPRB,6.9928E+00_JPRB,6.6719E+00_JPRB,6.9180E+00_JPRB,&
&7.8262E+00_JPRB,9.0973E+00_JPRB,9.9751E+00_JPRB,1.0276E+01_JPRB,3.6457E+01_JPRB/)
KAO( :, 1,13,14) = (/&
&1.0978E+01_JPRB,9.6060E+00_JPRB,8.3365E+00_JPRB,7.0935E+00_JPRB,6.1273E+00_JPRB,4.9756E+00_JPRB,&
&3.8881E+00_JPRB,3.3072E+00_JPRB,3.4820E+00_JPRB,3.5899E+00_JPRB,3.7314E+01_JPRB/)
KAO( :, 2,13,14) = (/&
&1.0837E+01_JPRB,9.4874E+00_JPRB,8.2842E+00_JPRB,7.3253E+00_JPRB,6.3404E+00_JPRB,5.2568E+00_JPRB,&
&4.4758E+00_JPRB,4.4007E+00_JPRB,4.7797E+00_JPRB,4.9274E+00_JPRB,3.7831E+01_JPRB/)
KAO( :, 3,13,14) = (/&
&1.0694E+01_JPRB,9.4274E+00_JPRB,8.2977E+00_JPRB,7.5668E+00_JPRB,6.5337E+00_JPRB,5.7124E+00_JPRB,&
&5.3511E+00_JPRB,5.7626E+00_JPRB,6.3147E+00_JPRB,6.5078E+00_JPRB,3.8270E+01_JPRB/)
KAO( :, 4,13,14) = (/&
&1.0553E+01_JPRB,9.3501E+00_JPRB,8.4789E+00_JPRB,7.6951E+00_JPRB,6.8488E+00_JPRB,6.3996E+00_JPRB,&
&6.5438E+00_JPRB,7.3994E+00_JPRB,8.1156E+00_JPRB,8.3624E+00_JPRB,3.9180E+01_JPRB/)
KAO( :, 5,13,14) = (/&
&1.0418E+01_JPRB,9.2624E+00_JPRB,8.6238E+00_JPRB,7.8509E+00_JPRB,7.3367E+00_JPRB,7.3271E+00_JPRB,&
&8.0317E+00_JPRB,9.2713E+00_JPRB,1.0168E+01_JPRB,1.0477E+01_JPRB,4.0242E+01_JPRB/)
KAO( :, 1, 1,15) = (/&
&3.4517E+00_JPRB,3.0397E+00_JPRB,4.3495E+00_JPRB,6.5195E+00_JPRB,8.6891E+00_JPRB,1.0859E+01_JPRB,&
&1.3028E+01_JPRB,1.5192E+01_JPRB,1.6642E+01_JPRB,1.7045E+01_JPRB,1.6592E+01_JPRB/)
KAO( :, 2, 1,15) = (/&
&3.3993E+00_JPRB,3.1455E+00_JPRB,5.0715E+00_JPRB,7.6013E+00_JPRB,1.0131E+01_JPRB,1.2660E+01_JPRB,&
&1.5190E+01_JPRB,1.7713E+01_JPRB,1.9405E+01_JPRB,1.9876E+01_JPRB,1.9373E+01_JPRB/)
KAO( :, 3, 1,15) = (/&
&3.3459E+00_JPRB,3.3075E+00_JPRB,5.7978E+00_JPRB,8.6893E+00_JPRB,1.1582E+01_JPRB,1.4472E+01_JPRB,&
&1.7361E+01_JPRB,2.0250E+01_JPRB,2.2182E+01_JPRB,2.2727E+01_JPRB,2.2178E+01_JPRB/)
KAO( :, 4, 1,15) = (/&
&3.2986E+00_JPRB,3.5290E+00_JPRB,6.5252E+00_JPRB,9.7768E+00_JPRB,1.3028E+01_JPRB,1.6279E+01_JPRB,&
&1.9527E+01_JPRB,2.2769E+01_JPRB,2.4943E+01_JPRB,2.5561E+01_JPRB,2.4969E+01_JPRB/)
KAO( :, 5, 1,15) = (/&
&3.2551E+00_JPRB,3.7853E+00_JPRB,7.2659E+00_JPRB,1.0883E+01_JPRB,1.4501E+01_JPRB,1.8116E+01_JPRB,&
&2.1727E+01_JPRB,2.5337E+01_JPRB,2.7748E+01_JPRB,2.8418E+01_JPRB,2.7723E+01_JPRB/)
KAO( :, 1, 2,15) = (/&
&3.6522E+00_JPRB,3.2711E+00_JPRB,4.5099E+00_JPRB,6.6968E+00_JPRB,8.9267E+00_JPRB,1.1156E+01_JPRB,&
&1.3385E+01_JPRB,1.5605E+01_JPRB,1.7100E+01_JPRB,1.7534E+01_JPRB,1.7404E+01_JPRB/)
KAO( :, 2, 2,15) = (/&
&3.6012E+00_JPRB,3.4064E+00_JPRB,5.2386E+00_JPRB,7.8494E+00_JPRB,1.0463E+01_JPRB,1.3076E+01_JPRB,&
&1.5688E+01_JPRB,1.8292E+01_JPRB,2.0045E+01_JPRB,2.0557E+01_JPRB,2.0412E+01_JPRB/)
KAO( :, 3, 2,15) = (/&
&3.5578E+00_JPRB,3.5847E+00_JPRB,6.0307E+00_JPRB,9.0357E+00_JPRB,1.2041E+01_JPRB,1.5045E+01_JPRB,&
&1.8047E+01_JPRB,2.1044E+01_JPRB,2.3057E+01_JPRB,2.3640E+01_JPRB,2.3465E+01_JPRB/)
KAO( :, 4, 2,15) = (/&
&3.5171E+00_JPRB,3.8136E+00_JPRB,6.8582E+00_JPRB,1.0272E+01_JPRB,1.3685E+01_JPRB,1.7098E+01_JPRB,&
&2.0508E+01_JPRB,2.3916E+01_JPRB,2.6198E+01_JPRB,2.6851E+01_JPRB,2.6618E+01_JPRB/)
KAO( :, 5, 2,15) = (/&
&3.4777E+00_JPRB,4.0744E+00_JPRB,7.7115E+00_JPRB,1.1547E+01_JPRB,1.5382E+01_JPRB,1.9216E+01_JPRB,&
&2.3048E+01_JPRB,2.6876E+01_JPRB,2.9437E+01_JPRB,3.0161E+01_JPRB,2.9874E+01_JPRB/)
KAO( :, 1, 3,15) = (/&
&4.0012E+00_JPRB,3.5438E+00_JPRB,4.5445E+00_JPRB,6.5121E+00_JPRB,8.6806E+00_JPRB,1.0848E+01_JPRB,&
&1.3016E+01_JPRB,1.5179E+01_JPRB,1.6635E+01_JPRB,1.7074E+01_JPRB,1.7180E+01_JPRB/)
KAO( :, 2, 3,15) = (/&
&3.9193E+00_JPRB,3.6637E+00_JPRB,5.2345E+00_JPRB,7.7505E+00_JPRB,1.0328E+01_JPRB,1.2905E+01_JPRB,&
&1.5480E+01_JPRB,1.8051E+01_JPRB,1.9781E+01_JPRB,2.0289E+01_JPRB,2.0415E+01_JPRB/)
KAO( :, 3, 3,15) = (/&
&3.8577E+00_JPRB,3.8234E+00_JPRB,6.0517E+00_JPRB,9.0644E+00_JPRB,1.2077E+01_JPRB,1.5089E+01_JPRB,&
&1.8099E+01_JPRB,2.1106E+01_JPRB,2.3127E+01_JPRB,2.3709E+01_JPRB,2.3850E+01_JPRB/)
KAO( :, 4, 3,15) = (/&
&3.8049E+00_JPRB,4.0468E+00_JPRB,6.9689E+00_JPRB,1.0436E+01_JPRB,1.3903E+01_JPRB,1.7370E+01_JPRB,&
&2.0836E+01_JPRB,2.4295E+01_JPRB,2.6620E+01_JPRB,2.7290E+01_JPRB,2.7443E+01_JPRB/)
KAO( :, 5, 3,15) = (/&
&3.7571E+00_JPRB,4.3042E+00_JPRB,7.9142E+00_JPRB,1.1851E+01_JPRB,1.5788E+01_JPRB,1.9723E+01_JPRB,&
&2.3657E+01_JPRB,2.7583E+01_JPRB,3.0223E+01_JPRB,3.0982E+01_JPRB,3.1151E+01_JPRB/)
KAO( :, 1, 4,15) = (/&
&4.5413E+00_JPRB,3.9760E+00_JPRB,4.5956E+00_JPRB,6.1749E+00_JPRB,8.2304E+00_JPRB,1.0286E+01_JPRB,&
&1.2342E+01_JPRB,1.4394E+01_JPRB,1.5775E+01_JPRB,1.6197E+01_JPRB,1.6378E+01_JPRB/)
KAO( :, 2, 4,15) = (/&
&4.4358E+00_JPRB,4.0500E+00_JPRB,5.2197E+00_JPRB,7.4879E+00_JPRB,9.9757E+00_JPRB,1.2463E+01_JPRB,&
&1.4950E+01_JPRB,1.7428E+01_JPRB,1.9103E+01_JPRB,1.9604E+01_JPRB,1.9831E+01_JPRB/)
KAO( :, 3, 4,15) = (/&
&4.3496E+00_JPRB,4.1500E+00_JPRB,5.9601E+00_JPRB,8.9065E+00_JPRB,1.1863E+01_JPRB,1.4820E+01_JPRB,&
&1.7774E+01_JPRB,2.0728E+01_JPRB,2.2708E+01_JPRB,2.3295E+01_JPRB,2.3568E+01_JPRB/)
KAO( :, 4, 4,15) = (/&
&4.2783E+00_JPRB,4.3259E+00_JPRB,6.9520E+00_JPRB,1.0406E+01_JPRB,1.3860E+01_JPRB,1.7313E+01_JPRB,&
&2.0763E+01_JPRB,2.4211E+01_JPRB,2.6527E+01_JPRB,2.7194E+01_JPRB,2.7525E+01_JPRB/)
KAO( :, 5, 4,15) = (/&
&4.2147E+00_JPRB,4.5565E+00_JPRB,7.9967E+00_JPRB,1.1967E+01_JPRB,1.5938E+01_JPRB,1.9911E+01_JPRB,&
&2.3877E+01_JPRB,2.7842E+01_JPRB,3.0498E+01_JPRB,3.1272E+01_JPRB,3.1647E+01_JPRB/)
KAO( :, 1, 5,15) = (/&
&5.1884E+00_JPRB,4.5403E+00_JPRB,4.7931E+00_JPRB,5.8956E+00_JPRB,7.7629E+00_JPRB,9.7012E+00_JPRB,&
&1.1639E+01_JPRB,1.3574E+01_JPRB,1.4878E+01_JPRB,1.5273E+01_JPRB,1.5485E+01_JPRB/)
KAO( :, 2, 5,15) = (/&
&5.0662E+00_JPRB,4.5450E+00_JPRB,5.3264E+00_JPRB,7.1969E+00_JPRB,9.5885E+00_JPRB,1.1980E+01_JPRB,&
&1.4371E+01_JPRB,1.6762E+01_JPRB,1.8366E+01_JPRB,1.8844E+01_JPRB,1.9112E+01_JPRB/)
KAO( :, 3, 5,15) = (/&
&4.9667E+00_JPRB,4.6362E+00_JPRB,5.9568E+00_JPRB,8.7016E+00_JPRB,1.1592E+01_JPRB,1.4482E+01_JPRB,&
&1.7370E+01_JPRB,2.0252E+01_JPRB,2.2194E+01_JPRB,2.2764E+01_JPRB,2.3092E+01_JPRB/)
KAO( :, 4, 5,15) = (/&
&4.8811E+00_JPRB,4.7581E+00_JPRB,6.8907E+00_JPRB,1.0315E+01_JPRB,1.3738E+01_JPRB,1.7164E+01_JPRB,&
&2.0588E+01_JPRB,2.4000E+01_JPRB,2.6296E+01_JPRB,2.6966E+01_JPRB,2.7352E+01_JPRB/)
KAO( :, 5, 5,15) = (/&
&4.8022E+00_JPRB,4.9436E+00_JPRB,8.0245E+00_JPRB,1.2011E+01_JPRB,1.5998E+01_JPRB,1.9984E+01_JPRB,&
&2.3970E+01_JPRB,2.7945E+01_JPRB,3.0615E+01_JPRB,3.1395E+01_JPRB,3.1854E+01_JPRB/)
KAO( :, 1, 6,15) = (/&
&5.9540E+00_JPRB,5.2101E+00_JPRB,5.1559E+00_JPRB,5.7766E+00_JPRB,7.2000E+00_JPRB,8.9966E+00_JPRB,&
&1.0790E+01_JPRB,1.2585E+01_JPRB,1.3788E+01_JPRB,1.4160E+01_JPRB,1.4369E+01_JPRB/)
KAO( :, 2, 6,15) = (/&
&5.8116E+00_JPRB,5.1177E+00_JPRB,5.5815E+00_JPRB,6.8585E+00_JPRB,9.1046E+00_JPRB,1.1376E+01_JPRB,&
&1.3646E+01_JPRB,1.5913E+01_JPRB,1.7437E+01_JPRB,1.7895E+01_JPRB,1.8166E+01_JPRB/)
KAO( :, 3, 6,15) = (/&
&5.6919E+00_JPRB,5.2252E+00_JPRB,6.1200E+00_JPRB,8.4234E+00_JPRB,1.1222E+01_JPRB,1.4022E+01_JPRB,&
&1.6819E+01_JPRB,1.9613E+01_JPRB,2.1489E+01_JPRB,2.2041E+01_JPRB,2.2387E+01_JPRB/)
KAO( :, 4, 6,15) = (/&
&5.5882E+00_JPRB,5.3197E+00_JPRB,6.8459E+00_JPRB,1.0145E+01_JPRB,1.3515E+01_JPRB,1.6884E+01_JPRB,&
&2.0253E+01_JPRB,2.3617E+01_JPRB,2.5877E+01_JPRB,2.6539E+01_JPRB,2.6957E+01_JPRB/)
KAO( :, 5, 6,15) = (/&
&5.4924E+00_JPRB,5.4609E+00_JPRB,7.9964E+00_JPRB,1.1974E+01_JPRB,1.5951E+01_JPRB,1.9927E+01_JPRB,&
&2.3903E+01_JPRB,2.7873E+01_JPRB,3.0539E+01_JPRB,3.1317E+01_JPRB,3.1808E+01_JPRB/)
KAO( :, 1, 7,15) = (/&
&6.8609E+00_JPRB,6.0036E+00_JPRB,5.6856E+00_JPRB,5.8569E+00_JPRB,6.6558E+00_JPRB,8.2325E+00_JPRB,&
&9.8779E+00_JPRB,1.1519E+01_JPRB,1.2625E+01_JPRB,1.2957E+01_JPRB,1.3161E+01_JPRB/)
KAO( :, 2, 7,15) = (/&
&6.6929E+00_JPRB,5.8566E+00_JPRB,5.9907E+00_JPRB,6.7106E+00_JPRB,8.5545E+00_JPRB,1.0689E+01_JPRB,&
&1.2823E+01_JPRB,1.4953E+01_JPRB,1.6388E+01_JPRB,1.6819E+01_JPRB,1.7084E+01_JPRB/)
KAO( :, 3, 7,15) = (/&
&6.5525E+00_JPRB,5.8774E+00_JPRB,6.4316E+00_JPRB,8.0973E+00_JPRB,1.0774E+01_JPRB,1.3461E+01_JPRB,&
&1.6147E+01_JPRB,1.8828E+01_JPRB,2.0635E+01_JPRB,2.1172E+01_JPRB,2.1511E+01_JPRB/)
KAO( :, 4, 7,15) = (/&
&6.4308E+00_JPRB,6.0200E+00_JPRB,7.0014E+00_JPRB,9.9118E+00_JPRB,1.3206E+01_JPRB,1.6500E+01_JPRB,&
&1.9791E+01_JPRB,2.3078E+01_JPRB,2.5291E+01_JPRB,2.5943E+01_JPRB,2.6365E+01_JPRB/)
KAO( :, 5, 7,15) = (/&
&6.3315E+00_JPRB,6.1156E+00_JPRB,7.9980E+00_JPRB,1.1868E+01_JPRB,1.5812E+01_JPRB,1.9756E+01_JPRB,&
&2.3696E+01_JPRB,2.7636E+01_JPRB,3.0283E+01_JPRB,3.1063E+01_JPRB,3.1573E+01_JPRB/)
KAO( :, 1, 8,15) = (/&
&7.8865E+00_JPRB,6.9009E+00_JPRB,6.2843E+00_JPRB,6.1316E+00_JPRB,6.3613E+00_JPRB,7.5584E+00_JPRB,&
&9.0686E+00_JPRB,1.0577E+01_JPRB,1.1592E+01_JPRB,1.1900E+01_JPRB,1.2089E+01_JPRB/)
KAO( :, 2, 8,15) = (/&
&7.6965E+00_JPRB,6.7347E+00_JPRB,6.5927E+00_JPRB,6.8053E+00_JPRB,7.9909E+00_JPRB,9.9438E+00_JPRB,&
&1.1929E+01_JPRB,1.3913E+01_JPRB,1.5248E+01_JPRB,1.5655E+01_JPRB,1.5901E+01_JPRB/)
KAO( :, 3, 8,15) = (/&
&7.5504E+00_JPRB,6.6675E+00_JPRB,6.9179E+00_JPRB,7.9162E+00_JPRB,1.0245E+01_JPRB,1.2802E+01_JPRB,&
&1.5357E+01_JPRB,1.7910E+01_JPRB,1.9627E+01_JPRB,2.0148E+01_JPRB,2.0469E+01_JPRB/)
KAO( :, 4, 8,15) = (/&
&7.4360E+00_JPRB,6.7883E+00_JPRB,7.3531E+00_JPRB,9.6152E+00_JPRB,1.2792E+01_JPRB,1.5983E+01_JPRB,&
&1.9172E+01_JPRB,2.2359E+01_JPRB,2.4505E+01_JPRB,2.5152E+01_JPRB,2.5554E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&7.3370E+00_JPRB,6.9240E+00_JPRB,8.1752E+00_JPRB,1.1669E+01_JPRB,1.5550E+01_JPRB,1.9429E+01_JPRB,&
&2.3306E+01_JPRB,2.7182E+01_JPRB,2.9790E+01_JPRB,3.0576E+01_JPRB,3.1067E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&9.0967E+00_JPRB,7.9598E+00_JPRB,6.9734E+00_JPRB,6.6246E+00_JPRB,6.3273E+00_JPRB,6.9836E+00_JPRB,&
&8.3234E+00_JPRB,9.7073E+00_JPRB,1.0640E+01_JPRB,1.0924E+01_JPRB,1.1099E+01_JPRB/)
KAO( :, 2, 9,15) = (/&
&8.8543E+00_JPRB,7.7477E+00_JPRB,7.2824E+00_JPRB,7.1264E+00_JPRB,7.6457E+00_JPRB,9.2650E+00_JPRB,&
&1.1116E+01_JPRB,1.2965E+01_JPRB,1.4208E+01_JPRB,1.4588E+01_JPRB,1.4820E+01_JPRB/)
KAO( :, 3, 9,15) = (/&
&8.7111E+00_JPRB,7.6297E+00_JPRB,7.5745E+00_JPRB,7.9608E+00_JPRB,9.6557E+00_JPRB,1.2050E+01_JPRB,&
&1.4456E+01_JPRB,1.6860E+01_JPRB,1.8477E+01_JPRB,1.8971E+01_JPRB,1.9271E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&8.5917E+00_JPRB,7.6924E+00_JPRB,7.9085E+00_JPRB,9.4305E+00_JPRB,1.2224E+01_JPRB,1.5276E+01_JPRB,&
&1.8326E+01_JPRB,2.1371E+01_JPRB,2.3421E+01_JPRB,2.4055E+01_JPRB,2.4428E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&8.4819E+00_JPRB,7.8606E+00_JPRB,8.5251E+00_JPRB,1.1371E+01_JPRB,1.5099E+01_JPRB,1.8867E+01_JPRB,&
&2.2635E+01_JPRB,2.6398E+01_JPRB,2.8934E+01_JPRB,2.9714E+01_JPRB,3.0176E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&1.0579E+01_JPRB,9.2563E+00_JPRB,7.9515E+00_JPRB,7.2414E+00_JPRB,6.6262E+00_JPRB,6.7533E+00_JPRB,&
&7.7880E+00_JPRB,9.0842E+00_JPRB,9.9553E+00_JPRB,1.0226E+01_JPRB,1.4443E+01_JPRB/)
KAO( :, 2,10,15) = (/&
&1.0272E+01_JPRB,8.9883E+00_JPRB,8.0814E+00_JPRB,7.6749E+00_JPRB,7.6815E+00_JPRB,8.8308E+00_JPRB,&
&1.0573E+01_JPRB,1.2332E+01_JPRB,1.3516E+01_JPRB,1.3883E+01_JPRB,1.6088E+01_JPRB/)
KAO( :, 3,10,15) = (/&
&1.0064E+01_JPRB,8.8059E+00_JPRB,8.3682E+00_JPRB,8.3372E+00_JPRB,9.4460E+00_JPRB,1.1603E+01_JPRB,&
&1.3923E+01_JPRB,1.6236E+01_JPRB,1.7795E+01_JPRB,1.8275E+01_JPRB,1.8972E+01_JPRB/)
KAO( :, 4,10,15) = (/&
&9.9156E+00_JPRB,8.7771E+00_JPRB,8.6891E+00_JPRB,9.5568E+00_JPRB,1.1876E+01_JPRB,1.4833E+01_JPRB,&
&1.7796E+01_JPRB,2.0756E+01_JPRB,2.2749E+01_JPRB,2.3365E+01_JPRB,2.3730E+01_JPRB/)
KAO( :, 5,10,15) = (/&
&9.7815E+00_JPRB,8.9122E+00_JPRB,9.1420E+00_JPRB,1.1360E+01_JPRB,1.4761E+01_JPRB,1.8450E+01_JPRB,&
&2.2139E+01_JPRB,2.5815E+01_JPRB,2.8297E+01_JPRB,2.9069E+01_JPRB,2.9515E+01_JPRB/)
KAO( :, 1,11,15) = (/&
&1.2192E+01_JPRB,1.0668E+01_JPRB,9.1719E+00_JPRB,8.2095E+00_JPRB,7.4257E+00_JPRB,7.4696E+00_JPRB,&
&8.4517E+00_JPRB,9.8563E+00_JPRB,1.0806E+01_JPRB,1.1102E+01_JPRB,2.7700E+01_JPRB/)
KAO( :, 2,11,15) = (/&
&1.1855E+01_JPRB,1.0373E+01_JPRB,9.2641E+00_JPRB,8.5808E+00_JPRB,8.5516E+00_JPRB,9.6496E+00_JPRB,&
&1.1490E+01_JPRB,1.3402E+01_JPRB,1.4690E+01_JPRB,1.5091E+01_JPRB,2.8329E+01_JPRB/)
KAO( :, 3,11,15) = (/&
&1.1617E+01_JPRB,1.0165E+01_JPRB,9.4549E+00_JPRB,9.2771E+00_JPRB,1.0404E+01_JPRB,1.2597E+01_JPRB,&
&1.5113E+01_JPRB,1.7627E+01_JPRB,1.9321E+01_JPRB,1.9850E+01_JPRB,2.9277E+01_JPRB/)
KAO( :, 4,11,15) = (/&
&1.1419E+01_JPRB,1.0101E+01_JPRB,9.7647E+00_JPRB,1.0584E+01_JPRB,1.2914E+01_JPRB,1.6054E+01_JPRB,&
&1.9262E+01_JPRB,2.2467E+01_JPRB,2.4628E+01_JPRB,2.5304E+01_JPRB,3.1159E+01_JPRB/)
KAO( :, 5,11,15) = (/&
&1.1246E+01_JPRB,1.0208E+01_JPRB,1.0298E+01_JPRB,1.2412E+01_JPRB,1.5920E+01_JPRB,1.9895E+01_JPRB,&
&2.3870E+01_JPRB,2.7842E+01_JPRB,3.0521E+01_JPRB,3.1359E+01_JPRB,3.4867E+01_JPRB/)
KAO( :, 1,12,15) = (/&
&1.4055E+01_JPRB,1.2298E+01_JPRB,1.0584E+01_JPRB,9.3863E+00_JPRB,8.3528E+00_JPRB,8.2912E+00_JPRB,&
&9.1651E+00_JPRB,1.0659E+01_JPRB,1.1686E+01_JPRB,1.2009E+01_JPRB,4.0755E+01_JPRB/)
KAO( :, 2,12,15) = (/&
&1.3708E+01_JPRB,1.1994E+01_JPRB,1.0673E+01_JPRB,9.6215E+00_JPRB,9.5535E+00_JPRB,1.0572E+01_JPRB,&
&1.2442E+01_JPRB,1.4512E+01_JPRB,1.5909E+01_JPRB,1.6350E+01_JPRB,4.1783E+01_JPRB/)
KAO( :, 3,12,15) = (/&
&1.3432E+01_JPRB,1.1753E+01_JPRB,1.0809E+01_JPRB,1.0365E+01_JPRB,1.1475E+01_JPRB,1.3634E+01_JPRB,&
&1.6334E+01_JPRB,1.9052E+01_JPRB,2.0884E+01_JPRB,2.1465E+01_JPRB,4.2453E+01_JPRB/)
KAO( :, 4,12,15) = (/&
&1.3187E+01_JPRB,1.1665E+01_JPRB,1.0969E+01_JPRB,1.1758E+01_JPRB,1.4080E+01_JPRB,1.7299E+01_JPRB,&
&2.0755E+01_JPRB,2.4210E+01_JPRB,2.6541E+01_JPRB,2.7279E+01_JPRB,4.2992E+01_JPRB/)
KAO( :, 5,12,15) = (/&
&1.2971E+01_JPRB,1.1732E+01_JPRB,1.1607E+01_JPRB,1.3640E+01_JPRB,1.7148E+01_JPRB,2.1366E+01_JPRB,&
&2.5637E+01_JPRB,2.9905E+01_JPRB,3.2783E+01_JPRB,3.3705E+01_JPRB,4.4626E+01_JPRB/)
KAO( :, 1,13,15) = (/&
&1.6228E+01_JPRB,1.4199E+01_JPRB,1.2230E+01_JPRB,1.0748E+01_JPRB,9.4009E+00_JPRB,9.2214E+00_JPRB,&
&9.9389E+00_JPRB,1.1470E+01_JPRB,1.2574E+01_JPRB,1.2929E+01_JPRB,4.6698E+01_JPRB/)
KAO( :, 2,13,15) = (/&
&1.5839E+01_JPRB,1.3859E+01_JPRB,1.2304E+01_JPRB,1.0893E+01_JPRB,1.0661E+01_JPRB,1.1572E+01_JPRB,&
&1.3374E+01_JPRB,1.5600E+01_JPRB,1.7103E+01_JPRB,1.7585E+01_JPRB,4.7783E+01_JPRB/)
KAO( :, 3,13,15) = (/&
&1.5511E+01_JPRB,1.3574E+01_JPRB,1.2374E+01_JPRB,1.1617E+01_JPRB,1.2687E+01_JPRB,1.4735E+01_JPRB,&
&1.7515E+01_JPRB,2.0432E+01_JPRB,2.2399E+01_JPRB,2.3033E+01_JPRB,4.8488E+01_JPRB/)
KAO( :, 4,13,15) = (/&
&1.5222E+01_JPRB,1.3473E+01_JPRB,1.2471E+01_JPRB,1.3097E+01_JPRB,1.5327E+01_JPRB,1.8511E+01_JPRB,&
&2.2200E+01_JPRB,2.5897E+01_JPRB,2.8394E+01_JPRB,2.9197E+01_JPRB,4.9013E+01_JPRB/)
KAO( :, 5,13,15) = (/&
&1.4970E+01_JPRB,1.3493E+01_JPRB,1.3069E+01_JPRB,1.5022E+01_JPRB,1.8478E+01_JPRB,2.2815E+01_JPRB,&
&2.7375E+01_JPRB,3.1933E+01_JPRB,3.5007E+01_JPRB,3.5995E+01_JPRB,5.0755E+01_JPRB/)
KAO( :, 1, 1,16) = (/&
&3.6978E+00_JPRB,3.2359E+00_JPRB,5.8520E+00_JPRB,8.7722E+00_JPRB,1.1692E+01_JPRB,1.4611E+01_JPRB,&
&1.7529E+01_JPRB,2.0434E+01_JPRB,2.2353E+01_JPRB,2.2771E+01_JPRB,2.1591E+01_JPRB/)
KAO( :, 2, 1,16) = (/&
&3.6499E+00_JPRB,3.4722E+00_JPRB,6.9301E+00_JPRB,1.0388E+01_JPRB,1.3844E+01_JPRB,1.7300E+01_JPRB,&
&2.0752E+01_JPRB,2.4192E+01_JPRB,2.6475E+01_JPRB,2.6965E+01_JPRB,2.5577E+01_JPRB/)
KAO( :, 3, 1,16) = (/&
&3.5975E+00_JPRB,4.0332E+00_JPRB,8.0476E+00_JPRB,1.2062E+01_JPRB,1.6074E+01_JPRB,2.0086E+01_JPRB,&
&2.4094E+01_JPRB,2.8087E+01_JPRB,3.0726E+01_JPRB,3.1309E+01_JPRB,2.9700E+01_JPRB/)
KAO( :, 4, 1,16) = (/&
&3.5405E+00_JPRB,4.6049E+00_JPRB,9.1863E+00_JPRB,1.3767E+01_JPRB,1.8347E+01_JPRB,2.2925E+01_JPRB,&
&2.7499E+01_JPRB,3.2055E+01_JPRB,3.5076E+01_JPRB,3.5737E+01_JPRB,3.3906E+01_JPRB/)
KAO( :, 5, 1,16) = (/&
&3.4814E+00_JPRB,5.1822E+00_JPRB,1.0334E+01_JPRB,1.5485E+01_JPRB,2.0637E+01_JPRB,2.5785E+01_JPRB,&
&3.0929E+01_JPRB,3.6054E+01_JPRB,3.9459E+01_JPRB,4.0196E+01_JPRB,3.8155E+01_JPRB/)
KAO( :, 1, 2,16) = (/&
&4.0520E+00_JPRB,3.5458E+00_JPRB,6.5231E+00_JPRB,9.7790E+00_JPRB,1.3034E+01_JPRB,1.6288E+01_JPRB,&
&1.9539E+01_JPRB,2.2778E+01_JPRB,2.4923E+01_JPRB,2.5395E+01_JPRB,2.4752E+01_JPRB/)
KAO( :, 2, 2,16) = (/&
&3.9931E+00_JPRB,3.9027E+00_JPRB,7.7909E+00_JPRB,1.1679E+01_JPRB,1.5566E+01_JPRB,1.9451E+01_JPRB,&
&2.3333E+01_JPRB,2.7200E+01_JPRB,2.9762E+01_JPRB,3.0330E+01_JPRB,2.9565E+01_JPRB/)
KAO( :, 3, 2,16) = (/&
&3.9308E+00_JPRB,4.5630E+00_JPRB,9.1069E+00_JPRB,1.3651E+01_JPRB,1.8193E+01_JPRB,2.2734E+01_JPRB,&
&2.7271E+01_JPRB,3.1793E+01_JPRB,3.4788E+01_JPRB,3.5457E+01_JPRB,3.4565E+01_JPRB/)
KAO( :, 4, 2,16) = (/&
&3.8638E+00_JPRB,5.2409E+00_JPRB,1.0457E+01_JPRB,1.5672E+01_JPRB,2.0886E+01_JPRB,2.6099E+01_JPRB,&
&3.1306E+01_JPRB,3.6497E+01_JPRB,3.9942E+01_JPRB,4.0702E+01_JPRB,3.9688E+01_JPRB/)
KAO( :, 5, 2,16) = (/&
&3.7925E+00_JPRB,5.9258E+00_JPRB,1.1820E+01_JPRB,1.7713E+01_JPRB,2.3607E+01_JPRB,2.9498E+01_JPRB,&
&3.5387E+01_JPRB,4.1252E+01_JPRB,4.5136E+01_JPRB,4.6007E+01_JPRB,4.4885E+01_JPRB/)
KAO( :, 1, 3,16) = (/&
&4.4902E+00_JPRB,3.9291E+00_JPRB,6.9369E+00_JPRB,1.0400E+01_JPRB,1.3863E+01_JPRB,1.7324E+01_JPRB,&
&2.0784E+01_JPRB,2.4230E+01_JPRB,2.6510E+01_JPRB,2.7027E+01_JPRB,2.7042E+01_JPRB/)
KAO( :, 2, 3,16) = (/&
&4.4190E+00_JPRB,4.2063E+00_JPRB,8.3989E+00_JPRB,1.2591E+01_JPRB,1.6783E+01_JPRB,2.0972E+01_JPRB,&
&2.5161E+01_JPRB,2.9338E+01_JPRB,3.2094E+01_JPRB,3.2723E+01_JPRB,3.2745E+01_JPRB/)
KAO( :, 3, 3,16) = (/&
&4.3422E+00_JPRB,4.9746E+00_JPRB,9.9306E+00_JPRB,1.4886E+01_JPRB,1.9841E+01_JPRB,2.4793E+01_JPRB,&
&2.9742E+01_JPRB,3.4667E+01_JPRB,3.7936E+01_JPRB,3.8674E+01_JPRB,3.8715E+01_JPRB/)
KAO( :, 4, 3,16) = (/&
&4.2611E+00_JPRB,5.7667E+00_JPRB,1.1509E+01_JPRB,1.7250E+01_JPRB,2.2991E+01_JPRB,2.8729E+01_JPRB,&
&3.4468E+01_JPRB,4.0180E+01_JPRB,4.3962E+01_JPRB,4.4836E+01_JPRB,4.4863E+01_JPRB/)
KAO( :, 5, 3,16) = (/&
&4.1760E+00_JPRB,6.5736E+00_JPRB,1.3115E+01_JPRB,1.9656E+01_JPRB,2.6196E+01_JPRB,3.2733E+01_JPRB,&
&3.9264E+01_JPRB,4.5777E+01_JPRB,5.0083E+01_JPRB,5.1074E+01_JPRB,5.1136E+01_JPRB/)
KAO( :, 1, 4,16) = (/&
&5.0258E+00_JPRB,4.3977E+00_JPRB,7.1969E+00_JPRB,1.0791E+01_JPRB,1.4383E+01_JPRB,1.7975E+01_JPRB,&
&2.1569E+01_JPRB,2.5144E+01_JPRB,2.7520E+01_JPRB,2.8065E+01_JPRB,2.8444E+01_JPRB/)
KAO( :, 2, 4,16) = (/&
&4.9390E+00_JPRB,4.4372E+00_JPRB,8.8585E+00_JPRB,1.3281E+01_JPRB,1.7703E+01_JPRB,2.2123E+01_JPRB,&
&2.6539E+01_JPRB,3.0949E+01_JPRB,3.3856E+01_JPRB,3.4541E+01_JPRB,3.4994E+01_JPRB/)
KAO( :, 3, 4,16) = (/&
&4.8457E+00_JPRB,5.3158E+00_JPRB,1.0614E+01_JPRB,1.5912E+01_JPRB,2.1209E+01_JPRB,2.6503E+01_JPRB,&
&3.1793E+01_JPRB,3.7075E+01_JPRB,4.0567E+01_JPRB,4.1384E+01_JPRB,4.1940E+01_JPRB/)
KAO( :, 4, 4,16) = (/&
&4.7474E+00_JPRB,6.2334E+00_JPRB,1.2443E+01_JPRB,1.8652E+01_JPRB,2.4860E+01_JPRB,3.1065E+01_JPRB,&
&3.7265E+01_JPRB,4.3443E+01_JPRB,4.7539E+01_JPRB,4.8495E+01_JPRB,4.9142E+01_JPRB/)
KAO( :, 5, 4,16) = (/&
&4.6434E+00_JPRB,7.1705E+00_JPRB,1.4309E+01_JPRB,2.1448E+01_JPRB,2.8585E+01_JPRB,3.5719E+01_JPRB,&
&4.2858E+01_JPRB,4.9961E+01_JPRB,5.4666E+01_JPRB,5.5776E+01_JPRB,5.6532E+01_JPRB/)
KAO( :, 1, 5,16) = (/&
&5.9530E+00_JPRB,5.2090E+00_JPRB,7.3637E+00_JPRB,1.1041E+01_JPRB,1.4718E+01_JPRB,1.8396E+01_JPRB,&
&2.2069E+01_JPRB,2.5729E+01_JPRB,2.8163E+01_JPRB,2.8740E+01_JPRB,2.9269E+01_JPRB/)
KAO( :, 2, 5,16) = (/&
&5.7866E+00_JPRB,5.0634E+00_JPRB,9.2276E+00_JPRB,1.3835E+01_JPRB,1.8442E+01_JPRB,2.3049E+01_JPRB,&
&2.7650E+01_JPRB,3.2234E+01_JPRB,3.5276E+01_JPRB,3.5999E+01_JPRB,3.6669E+01_JPRB/)
KAO( :, 3, 5,16) = (/&
&5.6302E+00_JPRB,5.6178E+00_JPRB,1.1219E+01_JPRB,1.6821E+01_JPRB,2.2421E+01_JPRB,2.8019E+01_JPRB,&
&3.3616E+01_JPRB,3.9189E+01_JPRB,4.2893E+01_JPRB,4.3778E+01_JPRB,4.4575E+01_JPRB/)
KAO( :, 4, 5,16) = (/&
&5.4798E+00_JPRB,6.6656E+00_JPRB,1.3308E+01_JPRB,1.9950E+01_JPRB,2.6591E+01_JPRB,3.3229E+01_JPRB,&
&3.9862E+01_JPRB,4.6471E+01_JPRB,5.0866E+01_JPRB,5.1930E+01_JPRB,5.2869E+01_JPRB/)
KAO( :, 5, 5,16) = (/&
&5.3354E+00_JPRB,7.7467E+00_JPRB,1.5462E+01_JPRB,2.3177E+01_JPRB,3.0891E+01_JPRB,3.8601E+01_JPRB,&
&4.6304E+01_JPRB,5.3986E+01_JPRB,5.9081E+01_JPRB,6.0310E+01_JPRB,6.1426E+01_JPRB/)
KAO( :, 1, 6,16) = (/&
&7.2738E+00_JPRB,6.3646E+00_JPRB,7.3570E+00_JPRB,1.1032E+01_JPRB,1.4706E+01_JPRB,1.8378E+01_JPRB,&
&2.2046E+01_JPRB,2.5711E+01_JPRB,2.8141E+01_JPRB,2.8729E+01_JPRB,2.9318E+01_JPRB/)
KAO( :, 2, 6,16) = (/&
&7.0648E+00_JPRB,6.1818E+00_JPRB,9.4107E+00_JPRB,1.4112E+01_JPRB,1.8811E+01_JPRB,2.3508E+01_JPRB,&
&2.8203E+01_JPRB,3.2879E+01_JPRB,3.5997E+01_JPRB,3.6754E+01_JPRB,3.7506E+01_JPRB/)
KAO( :, 3, 6,16) = (/&
&6.8590E+00_JPRB,6.0610E+00_JPRB,1.1637E+01_JPRB,1.7447E+01_JPRB,2.3256E+01_JPRB,2.9066E+01_JPRB,&
&3.4869E+01_JPRB,4.0663E+01_JPRB,4.4507E+01_JPRB,4.5454E+01_JPRB,4.6382E+01_JPRB/)
KAO( :, 4, 6,16) = (/&
&6.6613E+00_JPRB,7.0109E+00_JPRB,1.4000E+01_JPRB,2.0989E+01_JPRB,2.7977E+01_JPRB,3.4961E+01_JPRB,&
&4.1942E+01_JPRB,4.8903E+01_JPRB,5.3535E+01_JPRB,5.4670E+01_JPRB,5.5779E+01_JPRB/)
KAO( :, 5, 6,16) = (/&
&6.4832E+00_JPRB,8.2415E+00_JPRB,1.6453E+01_JPRB,2.4664E+01_JPRB,3.2878E+01_JPRB,4.1086E+01_JPRB,&
&4.9286E+01_JPRB,5.7462E+01_JPRB,6.2904E+01_JPRB,6.4241E+01_JPRB,6.5559E+01_JPRB/)
KAO( :, 1, 7,16) = (/&
&8.8732E+00_JPRB,7.7641E+00_JPRB,7.2311E+00_JPRB,1.0833E+01_JPRB,1.4441E+01_JPRB,1.8048E+01_JPRB,&
&2.1653E+01_JPRB,2.5247E+01_JPRB,2.7641E+01_JPRB,2.8229E+01_JPRB,2.8832E+01_JPRB/)
KAO( :, 2, 7,16) = (/&
&8.6143E+00_JPRB,7.5376E+00_JPRB,9.4585E+00_JPRB,1.4183E+01_JPRB,1.8907E+01_JPRB,2.3629E+01_JPRB,&
&2.8346E+01_JPRB,3.3048E+01_JPRB,3.6188E+01_JPRB,3.6968E+01_JPRB,3.7763E+01_JPRB/)
KAO( :, 3, 7,16) = (/&
&8.3664E+00_JPRB,7.3209E+00_JPRB,1.1919E+01_JPRB,1.7872E+01_JPRB,2.3823E+01_JPRB,2.9773E+01_JPRB,&
&3.5718E+01_JPRB,4.1638E+01_JPRB,4.5593E+01_JPRB,4.6590E+01_JPRB,4.7567E+01_JPRB/)
KAO( :, 4, 7,16) = (/&
&8.1390E+00_JPRB,7.4468E+00_JPRB,1.4558E+01_JPRB,2.1826E+01_JPRB,2.9093E+01_JPRB,3.6357E+01_JPRB,&
&4.3619E+01_JPRB,5.0854E+01_JPRB,5.5680E+01_JPRB,5.6904E+01_JPRB,5.8098E+01_JPRB/)
KAO( :, 5, 7,16) = (/&
&7.9265E+00_JPRB,8.6774E+00_JPRB,1.7326E+01_JPRB,2.5975E+01_JPRB,3.4621E+01_JPRB,4.3265E+01_JPRB,&
&5.1911E+01_JPRB,6.0538E+01_JPRB,6.6258E+01_JPRB,6.7733E+01_JPRB,6.9141E+01_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.0788E+01_JPRB,9.4395E+00_JPRB,8.0910E+00_JPRB,1.0487E+01_JPRB,1.3981E+01_JPRB,1.7474E+01_JPRB,&
&2.0958E+01_JPRB,2.4442E+01_JPRB,2.6758E+01_JPRB,2.7356E+01_JPRB,2.7940E+01_JPRB/)
KAO( :, 2, 8,16) = (/&
&1.0475E+01_JPRB,9.1659E+00_JPRB,9.3873E+00_JPRB,1.4077E+01_JPRB,1.8765E+01_JPRB,2.3452E+01_JPRB,&
&2.8149E+01_JPRB,3.2822E+01_JPRB,3.5937E+01_JPRB,3.6740E+01_JPRB,3.7513E+01_JPRB/)
KAO( :, 3, 8,16) = (/&
&1.0193E+01_JPRB,8.9191E+00_JPRB,1.2075E+01_JPRB,1.8106E+01_JPRB,2.4136E+01_JPRB,3.0164E+01_JPRB,&
&3.6189E+01_JPRB,4.2205E+01_JPRB,4.6208E+01_JPRB,4.7253E+01_JPRB,4.8244E+01_JPRB/)
KAO( :, 4, 8,16) = (/&
&9.9289E+00_JPRB,8.6882E+00_JPRB,1.4994E+01_JPRB,2.2482E+01_JPRB,2.9968E+01_JPRB,3.7453E+01_JPRB,&
&4.4932E+01_JPRB,5.2391E+01_JPRB,5.7371E+01_JPRB,5.8661E+01_JPRB,5.9909E+01_JPRB/)
KAO( :, 5, 8,16) = (/&
&9.6775E+00_JPRB,9.2158E+00_JPRB,1.8085E+01_JPRB,2.7113E+01_JPRB,3.6140E+01_JPRB,4.5163E+01_JPRB,&
&5.4184E+01_JPRB,6.3203E+01_JPRB,6.9206E+01_JPRB,7.0757E+01_JPRB,7.2247E+01_JPRB/)
KAO( :, 1, 9,16) = (/&
&1.3069E+01_JPRB,1.1436E+01_JPRB,9.8022E+00_JPRB,9.9694E+00_JPRB,1.3291E+01_JPRB,1.6611E+01_JPRB,&
&1.9930E+01_JPRB,2.3243E+01_JPRB,2.5447E+01_JPRB,2.6029E+01_JPRB,2.6580E+01_JPRB/)
KAO( :, 2, 9,16) = (/&
&1.2725E+01_JPRB,1.1134E+01_JPRB,9.8753E+00_JPRB,1.3769E+01_JPRB,1.8356E+01_JPRB,2.2942E+01_JPRB,&
&2.7527E+01_JPRB,3.2095E+01_JPRB,3.5151E+01_JPRB,3.5948E+01_JPRB,3.6707E+01_JPRB/)
KAO( :, 3, 9,16) = (/&
&1.2400E+01_JPRB,1.0851E+01_JPRB,1.2076E+01_JPRB,1.8109E+01_JPRB,2.4141E+01_JPRB,3.0170E+01_JPRB,&
&3.6196E+01_JPRB,4.2203E+01_JPRB,4.6216E+01_JPRB,4.7284E+01_JPRB,4.8252E+01_JPRB/)
KAO( :, 4, 9,16) = (/&
&1.2089E+01_JPRB,1.0578E+01_JPRB,1.5258E+01_JPRB,2.2878E+01_JPRB,3.0500E+01_JPRB,3.8117E+01_JPRB,&
&4.5731E+01_JPRB,5.3326E+01_JPRB,5.8402E+01_JPRB,5.9748E+01_JPRB,6.0995E+01_JPRB/)
KAO( :, 5, 9,16) = (/&
&1.1789E+01_JPRB,1.0434E+01_JPRB,1.8677E+01_JPRB,2.8005E+01_JPRB,3.7330E+01_JPRB,4.6652E+01_JPRB,&
&5.5969E+01_JPRB,6.5258E+01_JPRB,7.1468E+01_JPRB,7.3124E+01_JPRB,7.4629E+01_JPRB/)
KAO( :, 1,10,16) = (/&
&1.5771E+01_JPRB,1.3799E+01_JPRB,1.1828E+01_JPRB,1.0379E+01_JPRB,1.2776E+01_JPRB,1.5968E+01_JPRB,&
&1.9158E+01_JPRB,2.2340E+01_JPRB,2.4469E+01_JPRB,2.5039E+01_JPRB,2.5553E+01_JPRB/)
KAO( :, 2,10,16) = (/&
&1.5386E+01_JPRB,1.3463E+01_JPRB,1.1540E+01_JPRB,1.3590E+01_JPRB,1.8117E+01_JPRB,2.2643E+01_JPRB,&
&2.7166E+01_JPRB,3.1679E+01_JPRB,3.4682E+01_JPRB,3.5507E+01_JPRB,3.6231E+01_JPRB/)
KAO( :, 3,10,16) = (/&
&1.5014E+01_JPRB,1.3138E+01_JPRB,1.2638E+01_JPRB,1.8229E+01_JPRB,2.4305E+01_JPRB,3.0376E+01_JPRB,&
&3.6447E+01_JPRB,4.2507E+01_JPRB,4.6554E+01_JPRB,4.7660E+01_JPRB,4.8617E+01_JPRB/)
KAO( :, 4,10,16) = (/&
&1.4647E+01_JPRB,1.2816E+01_JPRB,1.5618E+01_JPRB,2.3419E+01_JPRB,3.1218E+01_JPRB,3.9016E+01_JPRB,&
&4.6807E+01_JPRB,5.4591E+01_JPRB,5.9795E+01_JPRB,6.1215E+01_JPRB,6.2420E+01_JPRB/)
KAO( :, 5,10,16) = (/&
&1.4280E+01_JPRB,1.2495E+01_JPRB,1.9355E+01_JPRB,2.9020E+01_JPRB,3.8692E+01_JPRB,4.8365E+01_JPRB,&
&5.8042E+01_JPRB,6.7684E+01_JPRB,7.4123E+01_JPRB,7.5902E+01_JPRB,7.7369E+01_JPRB/)
KAO( :, 1,11,16) = (/&
&1.8786E+01_JPRB,1.6438E+01_JPRB,1.4090E+01_JPRB,1.2331E+01_JPRB,1.4530E+01_JPRB,1.8160E+01_JPRB,&
&2.1788E+01_JPRB,2.5406E+01_JPRB,2.7840E+01_JPRB,2.8505E+01_JPRB,3.1090E+01_JPRB/)
KAO( :, 2,11,16) = (/&
&1.8352E+01_JPRB,1.6058E+01_JPRB,1.3764E+01_JPRB,1.5493E+01_JPRB,2.0554E+01_JPRB,2.5688E+01_JPRB,&
&3.0819E+01_JPRB,3.5940E+01_JPRB,3.9370E+01_JPRB,4.0314E+01_JPRB,4.1103E+01_JPRB/)
KAO( :, 3,11,16) = (/&
&1.7913E+01_JPRB,1.5674E+01_JPRB,1.4890E+01_JPRB,2.0637E+01_JPRB,2.7511E+01_JPRB,3.4389E+01_JPRB,&
&4.1261E+01_JPRB,4.8114E+01_JPRB,5.2700E+01_JPRB,5.3986E+01_JPRB,5.5030E+01_JPRB/)
KAO( :, 4,11,16) = (/&
&1.7463E+01_JPRB,1.5280E+01_JPRB,1.7784E+01_JPRB,2.6445E+01_JPRB,3.5253E+01_JPRB,4.4066E+01_JPRB,&
&5.2867E+01_JPRB,6.1654E+01_JPRB,6.7542E+01_JPRB,6.9213E+01_JPRB,7.0519E+01_JPRB/)
KAO( :, 5,11,16) = (/&
&1.7011E+01_JPRB,1.4885E+01_JPRB,2.1813E+01_JPRB,3.2706E+01_JPRB,4.3599E+01_JPRB,5.4495E+01_JPRB,&
&6.5377E+01_JPRB,7.6235E+01_JPRB,8.3536E+01_JPRB,8.5586E+01_JPRB,8.7197E+01_JPRB/)
KAO( :, 1,12,16) = (/&
&2.2316E+01_JPRB,1.9527E+01_JPRB,1.6737E+01_JPRB,1.4596E+01_JPRB,1.6461E+01_JPRB,2.0474E+01_JPRB,&
&2.4566E+01_JPRB,2.8661E+01_JPRB,3.1410E+01_JPRB,3.2180E+01_JPRB,4.4855E+01_JPRB/)
KAO( :, 2,12,16) = (/&
&2.1794E+01_JPRB,1.9070E+01_JPRB,1.6346E+01_JPRB,1.7861E+01_JPRB,2.3106E+01_JPRB,2.8879E+01_JPRB,&
&3.4647E+01_JPRB,4.0407E+01_JPRB,4.4277E+01_JPRB,4.5382E+01_JPRB,4.9760E+01_JPRB/)
KAO( :, 3,12,16) = (/&
&2.1250E+01_JPRB,1.8594E+01_JPRB,1.7508E+01_JPRB,2.3135E+01_JPRB,3.0842E+01_JPRB,3.8557E+01_JPRB,&
&4.6258E+01_JPRB,5.3944E+01_JPRB,5.9113E+01_JPRB,6.0595E+01_JPRB,6.2174E+01_JPRB/)
KAO( :, 4,12,16) = (/&
&2.0691E+01_JPRB,1.8105E+01_JPRB,2.0448E+01_JPRB,2.9564E+01_JPRB,3.9416E+01_JPRB,4.9267E+01_JPRB,&
&5.9115E+01_JPRB,6.8938E+01_JPRB,7.5537E+01_JPRB,7.7449E+01_JPRB,7.8830E+01_JPRB/)
KAO( :, 5,12,16) = (/&
&2.0116E+01_JPRB,1.7618E+01_JPRB,2.4414E+01_JPRB,3.6468E+01_JPRB,4.8613E+01_JPRB,6.0754E+01_JPRB,&
&7.2909E+01_JPRB,8.5015E+01_JPRB,9.3174E+01_JPRB,9.5539E+01_JPRB,9.7222E+01_JPRB/)
KAO( :, 1,13,16) = (/&
&2.6369E+01_JPRB,2.3073E+01_JPRB,1.9777E+01_JPRB,1.7264E+01_JPRB,1.8821E+01_JPRB,2.2830E+01_JPRB,&
&2.7390E+01_JPRB,3.1940E+01_JPRB,3.5002E+01_JPRB,3.5903E+01_JPRB,5.1967E+01_JPRB/)
KAO( :, 2,13,16) = (/&
&2.5711E+01_JPRB,2.2497E+01_JPRB,1.9315E+01_JPRB,2.0637E+01_JPRB,2.5666E+01_JPRB,3.2078E+01_JPRB,&
&3.8490E+01_JPRB,4.4893E+01_JPRB,4.9192E+01_JPRB,5.0468E+01_JPRB,5.7721E+01_JPRB/)
KAO( :, 3,13,16) = (/&
&2.5020E+01_JPRB,2.1893E+01_JPRB,2.0597E+01_JPRB,2.5898E+01_JPRB,3.4157E+01_JPRB,4.2689E+01_JPRB,&
&5.1216E+01_JPRB,5.9737E+01_JPRB,6.5448E+01_JPRB,6.7176E+01_JPRB,7.0449E+01_JPRB/)
KAO( :, 4,13,16) = (/&
&2.4297E+01_JPRB,2.1260E+01_JPRB,2.3512E+01_JPRB,3.2642E+01_JPRB,4.3514E+01_JPRB,5.4385E+01_JPRB,&
&6.5247E+01_JPRB,7.6086E+01_JPRB,8.3406E+01_JPRB,8.5607E+01_JPRB,8.7331E+01_JPRB/)
KAO( :, 5,13,16) = (/&
&2.3576E+01_JPRB,2.0739E+01_JPRB,2.7492E+01_JPRB,4.0149E+01_JPRB,5.3519E+01_JPRB,6.6886E+01_JPRB,&
&8.0252E+01_JPRB,9.3599E+01_JPRB,1.0259E+02_JPRB,1.0529E+02_JPRB,1.0701E+02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB9_A2
