!OCL SCALAR
SUBROUTINE RRTM_KGB9_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO9 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, ABSN2OO
USE YOERRTA9 , ONLY : N2OREF  ,H2OREF  ,CH4REF     ,ETAREF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 11, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.8511E-03_JPRB,2.1684E-03_JPRB,1.9806E-03_JPRB,1.7402E-03_JPRB,1.4775E-03_JPRB,1.1966E-03_JPRB,&
&8.9433E-04_JPRB,5.6221E-04_JPRB,3.0428E-04_JPRB,1.8439E-04_JPRB,1.3102E-04_JPRB/)
KAO( :, 2, 1, 1) = (/&
&2.0894E-03_JPRB,2.4523E-03_JPRB,2.2500E-03_JPRB,1.9818E-03_JPRB,1.6875E-03_JPRB,1.3729E-03_JPRB,&
&1.0298E-03_JPRB,6.5344E-04_JPRB,3.5857E-04_JPRB,2.2082E-04_JPRB,1.5794E-04_JPRB/)
KAO( :, 3, 1, 1) = (/&
&2.3330E-03_JPRB,2.7449E-03_JPRB,2.5294E-03_JPRB,2.2345E-03_JPRB,1.9095E-03_JPRB,1.5602E-03_JPRB,&
&1.1757E-03_JPRB,7.5512E-04_JPRB,4.2015E-04_JPRB,2.6222E-04_JPRB,1.8993E-04_JPRB/)
KAO( :, 4, 1, 1) = (/&
&2.5835E-03_JPRB,3.0490E-03_JPRB,2.8221E-03_JPRB,2.5018E-03_JPRB,2.1465E-03_JPRB,1.7595E-03_JPRB,&
&1.3344E-03_JPRB,8.6724E-04_JPRB,4.8897E-04_JPRB,3.0971E-04_JPRB,2.2746E-04_JPRB/)
KAO( :, 5, 1, 1) = (/&
&2.8404E-03_JPRB,3.3655E-03_JPRB,3.1292E-03_JPRB,2.7851E-03_JPRB,2.3984E-03_JPRB,1.9730E-03_JPRB,&
&1.5065E-03_JPRB,9.9023E-04_JPRB,5.6589E-04_JPRB,3.6410E-04_JPRB,2.7116E-04_JPRB/)
KAO( :, 1, 2, 1) = (/&
&1.5469E-03_JPRB,1.8260E-03_JPRB,1.6779E-03_JPRB,1.4743E-03_JPRB,1.2523E-03_JPRB,1.0146E-03_JPRB,&
&7.5802E-04_JPRB,4.7362E-04_JPRB,2.5248E-04_JPRB,1.4960E-04_JPRB,1.0313E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.7573E-03_JPRB,2.0750E-03_JPRB,1.9149E-03_JPRB,1.6867E-03_JPRB,1.4365E-03_JPRB,1.1680E-03_JPRB,&
&8.7632E-04_JPRB,5.5250E-04_JPRB,2.9879E-04_JPRB,1.7951E-04_JPRB,1.2466E-04_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.9736E-03_JPRB,2.3350E-03_JPRB,2.1627E-03_JPRB,1.9104E-03_JPRB,1.6322E-03_JPRB,1.3324E-03_JPRB,&
&1.0035E-03_JPRB,6.4000E-04_JPRB,3.5119E-04_JPRB,2.1343E-04_JPRB,1.4991E-04_JPRB/)
KAO( :, 4, 2, 1) = (/&
&2.1961E-03_JPRB,2.6057E-03_JPRB,2.4227E-03_JPRB,2.1470E-03_JPRB,1.8412E-03_JPRB,1.5084E-03_JPRB,&
&1.1417E-03_JPRB,7.3666E-04_JPRB,4.0980E-04_JPRB,2.5228E-04_JPRB,1.7955E-04_JPRB/)
KAO( :, 5, 2, 1) = (/&
&2.4226E-03_JPRB,2.8887E-03_JPRB,2.6975E-03_JPRB,2.3995E-03_JPRB,2.0641E-03_JPRB,1.6967E-03_JPRB,&
&1.2922E-03_JPRB,8.4309E-04_JPRB,4.7525E-04_JPRB,2.9676E-04_JPRB,2.1402E-04_JPRB/)
KAO( :, 1, 3, 1) = (/&
&1.2487E-03_JPRB,1.4859E-03_JPRB,1.3703E-03_JPRB,1.2034E-03_JPRB,1.0233E-03_JPRB,8.2934E-04_JPRB,&
&6.1870E-04_JPRB,3.8491E-04_JPRB,2.0061E-04_JPRB,1.1644E-04_JPRB,8.3034E-05_JPRB/)
KAO( :, 2, 3, 1) = (/&
&1.4306E-03_JPRB,1.7008E-03_JPRB,1.5762E-03_JPRB,1.3877E-03_JPRB,1.1829E-03_JPRB,9.6138E-04_JPRB,&
&7.2009E-04_JPRB,4.5115E-04_JPRB,2.3871E-04_JPRB,1.4060E-04_JPRB,1.0024E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&1.6189E-03_JPRB,1.9278E-03_JPRB,1.7928E-03_JPRB,1.5827E-03_JPRB,1.3525E-03_JPRB,1.1028E-03_JPRB,&
&8.2939E-04_JPRB,5.2453E-04_JPRB,2.8190E-04_JPRB,1.6789E-04_JPRB,1.2022E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.8135E-03_JPRB,2.1671E-03_JPRB,2.0211E-03_JPRB,1.7891E-03_JPRB,1.5341E-03_JPRB,1.2544E-03_JPRB,&
&9.4745E-04_JPRB,6.0589E-04_JPRB,3.3035E-04_JPRB,1.9886E-04_JPRB,1.4335E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&2.0119E-03_JPRB,2.4174E-03_JPRB,2.2628E-03_JPRB,2.0104E-03_JPRB,1.7281E-03_JPRB,1.4171E-03_JPRB,&
&1.0763E-03_JPRB,6.9556E-04_JPRB,3.8485E-04_JPRB,2.3413E-04_JPRB,1.7025E-04_JPRB/)
KAO( :, 1, 4, 1) = (/&
&9.9332E-04_JPRB,1.1937E-03_JPRB,1.1041E-03_JPRB,9.6868E-04_JPRB,8.2360E-04_JPRB,6.6725E-04_JPRB,&
&4.9729E-04_JPRB,3.0812E-04_JPRB,1.5709E-04_JPRB,8.9177E-05_JPRB,7.0382E-05_JPRB/)
KAO( :, 2, 4, 1) = (/&
&1.1489E-03_JPRB,1.3782E-03_JPRB,1.2812E-03_JPRB,1.1272E-03_JPRB,9.6052E-04_JPRB,7.8016E-04_JPRB,&
&5.8305E-04_JPRB,3.6333E-04_JPRB,1.8801E-04_JPRB,1.0835E-04_JPRB,8.4949E-05_JPRB/)
KAO( :, 3, 4, 1) = (/&
&1.3111E-03_JPRB,1.5738E-03_JPRB,1.4685E-03_JPRB,1.2957E-03_JPRB,1.1067E-03_JPRB,9.0126E-04_JPRB,&
&6.7612E-04_JPRB,4.2453E-04_JPRB,2.2322E-04_JPRB,1.3010E-04_JPRB,1.0182E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&1.4784E-03_JPRB,1.7816E-03_JPRB,1.6672E-03_JPRB,1.4760E-03_JPRB,1.2640E-03_JPRB,1.0311E-03_JPRB,&
&7.7663E-04_JPRB,4.9254E-04_JPRB,2.6274E-04_JPRB,1.5479E-04_JPRB,1.2151E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&1.6498E-03_JPRB,2.0005E-03_JPRB,1.8776E-03_JPRB,1.6682E-03_JPRB,1.4321E-03_JPRB,1.1713E-03_JPRB,&
&8.8632E-04_JPRB,5.6750E-04_JPRB,3.0711E-04_JPRB,1.8305E-04_JPRB,1.4406E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&7.8562E-04_JPRB,9.5485E-04_JPRB,8.8731E-04_JPRB,7.7760E-04_JPRB,6.6042E-04_JPRB,5.3465E-04_JPRB,&
&3.9818E-04_JPRB,2.4507E-04_JPRB,1.2280E-04_JPRB,6.8024E-05_JPRB,6.2892E-05_JPRB/)
KAO( :, 2, 5, 1) = (/&
&9.1788E-04_JPRB,1.1130E-03_JPRB,1.0387E-03_JPRB,9.1348E-04_JPRB,7.7739E-04_JPRB,6.3079E-04_JPRB,&
&4.7083E-04_JPRB,2.9144E-04_JPRB,1.4786E-04_JPRB,8.3150E-05_JPRB,7.5836E-05_JPRB/)
KAO( :, 3, 5, 1) = (/&
&1.0564E-03_JPRB,1.2815E-03_JPRB,1.1993E-03_JPRB,1.0584E-03_JPRB,9.0286E-04_JPRB,7.3472E-04_JPRB,&
&5.4988E-04_JPRB,3.4257E-04_JPRB,1.7646E-04_JPRB,1.0042E-04_JPRB,9.0784E-05_JPRB/)
KAO( :, 4, 5, 1) = (/&
&1.2000E-03_JPRB,1.4607E-03_JPRB,1.3706E-03_JPRB,1.2143E-03_JPRB,1.0385E-03_JPRB,8.4626E-04_JPRB,&
&6.3535E-04_JPRB,3.9924E-04_JPRB,2.0859E-04_JPRB,1.2014E-04_JPRB,1.0789E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.3470E-03_JPRB,1.6493E-03_JPRB,1.5534E-03_JPRB,1.3815E-03_JPRB,1.1841E-03_JPRB,9.6670E-04_JPRB,&
&7.2902E-04_JPRB,4.6176E-04_JPRB,2.4472E-04_JPRB,1.4262E-04_JPRB,1.2760E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&6.1309E-04_JPRB,7.5529E-04_JPRB,7.0573E-04_JPRB,6.1814E-04_JPRB,5.2423E-04_JPRB,4.2388E-04_JPRB,&
&3.1493E-04_JPRB,1.9253E-04_JPRB,9.5104E-05_JPRB,5.1400E-05_JPRB,5.8511E-05_JPRB/)
KAO( :, 2, 6, 1) = (/&
&7.2529E-04_JPRB,8.9038E-04_JPRB,8.3470E-04_JPRB,7.3394E-04_JPRB,6.2382E-04_JPRB,5.0540E-04_JPRB,&
&3.7640E-04_JPRB,2.3131E-04_JPRB,1.1537E-04_JPRB,6.3305E-05_JPRB,7.0591E-05_JPRB/)
KAO( :, 3, 6, 1) = (/&
&8.4334E-04_JPRB,1.0336E-03_JPRB,9.7184E-04_JPRB,8.5812E-04_JPRB,7.3092E-04_JPRB,5.9381E-04_JPRB,&
&4.4329E-04_JPRB,2.7409E-04_JPRB,1.3848E-04_JPRB,7.6884E-05_JPRB,8.4368E-05_JPRB/)
KAO( :, 4, 6, 1) = (/&
&9.6591E-04_JPRB,1.1861E-03_JPRB,1.1181E-03_JPRB,9.9183E-04_JPRB,8.4677E-04_JPRB,6.8969E-04_JPRB,&
&5.1579E-04_JPRB,3.2112E-04_JPRB,1.6446E-04_JPRB,9.2420E-05_JPRB,9.9996E-05_JPRB/)
KAO( :, 5, 6, 1) = (/&
&1.0919E-03_JPRB,1.3468E-03_JPRB,1.2743E-03_JPRB,1.1355E-03_JPRB,9.7181E-04_JPRB,7.9286E-04_JPRB,&
&5.9519E-04_JPRB,3.7314E-04_JPRB,1.9367E-04_JPRB,1.1025E-04_JPRB,1.1781E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&4.7156E-04_JPRB,5.8937E-04_JPRB,5.5332E-04_JPRB,4.8469E-04_JPRB,4.1048E-04_JPRB,3.3155E-04_JPRB,&
&2.4554E-04_JPRB,1.4938E-04_JPRB,7.2895E-05_JPRB,3.8595E-05_JPRB,5.7264E-05_JPRB/)
KAO( :, 2, 7, 1) = (/&
&5.6495E-04_JPRB,7.0294E-04_JPRB,6.6167E-04_JPRB,5.8245E-04_JPRB,4.9439E-04_JPRB,4.0002E-04_JPRB,&
&2.9682E-04_JPRB,1.8140E-04_JPRB,8.9227E-05_JPRB,4.7916E-05_JPRB,6.9677E-05_JPRB/)
KAO( :, 3, 7, 1) = (/&
&6.6439E-04_JPRB,8.2373E-04_JPRB,7.7721E-04_JPRB,6.8744E-04_JPRB,5.8490E-04_JPRB,4.7448E-04_JPRB,&
&3.5318E-04_JPRB,2.1689E-04_JPRB,1.0783E-04_JPRB,5.8667E-05_JPRB,8.3618E-05_JPRB/)
KAO( :, 4, 7, 1) = (/&
&7.6901E-04_JPRB,9.5239E-04_JPRB,9.0133E-04_JPRB,8.0079E-04_JPRB,6.8276E-04_JPRB,5.5536E-04_JPRB,&
&4.1449E-04_JPRB,2.5602E-04_JPRB,1.2881E-04_JPRB,7.0934E-05_JPRB,9.9245E-05_JPRB/)
KAO( :, 5, 7, 1) = (/&
&8.7687E-04_JPRB,1.0882E-03_JPRB,1.0337E-03_JPRB,9.2277E-04_JPRB,7.8860E-04_JPRB,6.4298E-04_JPRB,&
&4.8152E-04_JPRB,2.9917E-04_JPRB,1.5235E-04_JPRB,8.4990E-05_JPRB,1.1668E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&3.6149E-04_JPRB,4.5739E-04_JPRB,4.3172E-04_JPRB,3.7856E-04_JPRB,3.2005E-04_JPRB,2.5782E-04_JPRB,&
&1.9045E-04_JPRB,1.1541E-04_JPRB,5.5760E-05_JPRB,2.8968E-05_JPRB,6.3348E-05_JPRB/)
KAO( :, 2, 8, 1) = (/&
&4.3856E-04_JPRB,5.5284E-04_JPRB,5.2317E-04_JPRB,4.6128E-04_JPRB,3.9080E-04_JPRB,3.1525E-04_JPRB,&
&2.3332E-04_JPRB,1.4196E-04_JPRB,6.8893E-05_JPRB,3.6257E-05_JPRB,7.8227E-05_JPRB/)
KAO( :, 3, 8, 1) = (/&
&5.2180E-04_JPRB,6.5495E-04_JPRB,6.2122E-04_JPRB,5.5050E-04_JPRB,4.6739E-04_JPRB,3.7783E-04_JPRB,&
&2.8052E-04_JPRB,1.7141E-04_JPRB,8.3884E-05_JPRB,4.4746E-05_JPRB,9.4849E-05_JPRB/)
KAO( :, 4, 8, 1) = (/&
&6.1041E-04_JPRB,7.6428E-04_JPRB,7.2626E-04_JPRB,6.4667E-04_JPRB,5.5039E-04_JPRB,4.4616E-04_JPRB,&
&3.3220E-04_JPRB,2.0388E-04_JPRB,1.0087E-04_JPRB,5.4479E-05_JPRB,1.1299E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&7.0263E-04_JPRB,8.7961E-04_JPRB,8.3866E-04_JPRB,7.5024E-04_JPRB,6.4012E-04_JPRB,5.2015E-04_JPRB,&
&3.8858E-04_JPRB,2.3987E-04_JPRB,1.1991E-04_JPRB,6.5600E-05_JPRB,1.3300E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&2.7588E-04_JPRB,3.5363E-04_JPRB,3.3564E-04_JPRB,2.9442E-04_JPRB,2.4845E-04_JPRB,1.9944E-04_JPRB,&
&1.4687E-04_JPRB,8.8846E-05_JPRB,4.2564E-05_JPRB,2.1694E-05_JPRB,1.1635E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&3.3926E-04_JPRB,4.3331E-04_JPRB,4.1256E-04_JPRB,3.6456E-04_JPRB,3.0818E-04_JPRB,2.4781E-04_JPRB,&
&1.8292E-04_JPRB,1.1098E-04_JPRB,5.3248E-05_JPRB,2.7395E-05_JPRB,1.4478E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&4.0867E-04_JPRB,5.1901E-04_JPRB,4.9554E-04_JPRB,4.4073E-04_JPRB,3.7338E-04_JPRB,3.0096E-04_JPRB,&
&2.2284E-04_JPRB,1.3558E-04_JPRB,6.5394E-05_JPRB,3.4106E-05_JPRB,1.7665E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&4.8311E-04_JPRB,6.1155E-04_JPRB,5.8496E-04_JPRB,5.2319E-04_JPRB,4.4421E-04_JPRB,3.5901E-04_JPRB,&
&2.6668E-04_JPRB,1.6266E-04_JPRB,7.9185E-05_JPRB,4.1808E-05_JPRB,2.1187E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&5.6145E-04_JPRB,7.0981E-04_JPRB,6.8093E-04_JPRB,6.1164E-04_JPRB,5.2090E-04_JPRB,4.2218E-04_JPRB,&
&3.1451E-04_JPRB,1.9257E-04_JPRB,9.4690E-05_JPRB,5.0644E-05_JPRB,2.5097E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&2.1325E-04_JPRB,2.7761E-04_JPRB,2.6556E-04_JPRB,2.3335E-04_JPRB,1.9651E-04_JPRB,1.5718E-04_JPRB,&
&1.1525E-04_JPRB,6.9475E-05_JPRB,3.3064E-05_JPRB,1.6594E-05_JPRB,2.6093E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&2.6523E-04_JPRB,3.4415E-04_JPRB,3.3059E-04_JPRB,2.9327E-04_JPRB,2.4721E-04_JPRB,1.9814E-04_JPRB,&
&1.4562E-04_JPRB,8.8015E-05_JPRB,4.1956E-05_JPRB,2.1115E-05_JPRB,3.2387E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&3.2298E-04_JPRB,4.1660E-04_JPRB,4.0088E-04_JPRB,3.5836E-04_JPRB,3.0264E-04_JPRB,2.4324E-04_JPRB,&
&1.7951E-04_JPRB,1.0893E-04_JPRB,5.2077E-05_JPRB,2.6475E-05_JPRB,3.9665E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&3.8555E-04_JPRB,4.9515E-04_JPRB,4.7688E-04_JPRB,4.2876E-04_JPRB,3.6342E-04_JPRB,2.9294E-04_JPRB,&
&2.1704E-04_JPRB,1.3203E-04_JPRB,6.3508E-05_JPRB,3.2669E-05_JPRB,4.7888E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&4.5214E-04_JPRB,5.7861E-04_JPRB,5.5869E-04_JPRB,5.0469E-04_JPRB,4.2960E-04_JPRB,3.4738E-04_JPRB,&
&2.5818E-04_JPRB,1.5755E-04_JPRB,7.6353E-05_JPRB,3.9767E-05_JPRB,5.6953E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&1.8263E-04_JPRB,2.4132E-04_JPRB,2.3375E-04_JPRB,2.0689E-04_JPRB,1.7392E-04_JPRB,1.3885E-04_JPRB,&
&1.0153E-04_JPRB,6.1012E-05_JPRB,2.8844E-05_JPRB,1.4318E-05_JPRB,3.1500E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&2.2729E-04_JPRB,2.9882E-04_JPRB,2.9035E-04_JPRB,2.5993E-04_JPRB,2.1873E-04_JPRB,1.7499E-04_JPRB,&
&1.2837E-04_JPRB,7.7411E-05_JPRB,3.6724E-05_JPRB,1.8248E-05_JPRB,3.9075E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&2.7702E-04_JPRB,3.6186E-04_JPRB,3.5142E-04_JPRB,3.1724E-04_JPRB,2.6804E-04_JPRB,2.1505E-04_JPRB,&
&1.5840E-04_JPRB,9.5897E-05_JPRB,4.5698E-05_JPRB,2.2869E-05_JPRB,4.7807E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&3.3090E-04_JPRB,4.2990E-04_JPRB,4.1786E-04_JPRB,3.7887E-04_JPRB,3.2210E-04_JPRB,2.5914E-04_JPRB,&
&1.9166E-04_JPRB,1.1648E-04_JPRB,5.5756E-05_JPRB,2.8227E-05_JPRB,5.7397E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&3.8797E-04_JPRB,5.0222E-04_JPRB,4.8941E-04_JPRB,4.4563E-04_JPRB,3.8069E-04_JPRB,3.0738E-04_JPRB,&
&2.2816E-04_JPRB,1.3917E-04_JPRB,6.7021E-05_JPRB,3.4339E-05_JPRB,6.7669E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&1.5441E-04_JPRB,2.0564E-04_JPRB,2.0096E-04_JPRB,1.7923E-04_JPRB,1.5061E-04_JPRB,1.2020E-04_JPRB,&
&8.7841E-05_JPRB,5.2718E-05_JPRB,2.4841E-05_JPRB,1.2247E-05_JPRB,3.0779E-04_JPRB/)
KAO( :, 2,12, 1) = (/&
&1.9212E-04_JPRB,2.5449E-04_JPRB,2.4895E-04_JPRB,2.2471E-04_JPRB,1.8931E-04_JPRB,1.5143E-04_JPRB,&
&1.1103E-04_JPRB,6.6933E-05_JPRB,3.1660E-05_JPRB,1.5617E-05_JPRB,3.8209E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&2.3412E-04_JPRB,3.0815E-04_JPRB,3.0111E-04_JPRB,2.7354E-04_JPRB,2.3196E-04_JPRB,1.8605E-04_JPRB,&
&1.3699E-04_JPRB,8.2969E-05_JPRB,3.9466E-05_JPRB,1.9595E-05_JPRB,4.6727E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&2.7956E-04_JPRB,3.6583E-04_JPRB,3.5793E-04_JPRB,3.2668E-04_JPRB,2.7866E-04_JPRB,2.2413E-04_JPRB,&
&1.6571E-04_JPRB,1.0083E-04_JPRB,4.8187E-05_JPRB,2.4182E-05_JPRB,5.5911E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&3.2770E-04_JPRB,4.2716E-04_JPRB,4.1907E-04_JPRB,3.8390E-04_JPRB,3.2941E-04_JPRB,2.6578E-04_JPRB,&
&1.9722E-04_JPRB,1.2047E-04_JPRB,5.7910E-05_JPRB,2.9402E-05_JPRB,6.5729E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&1.2926E-04_JPRB,1.7285E-04_JPRB,1.6977E-04_JPRB,1.5243E-04_JPRB,1.2815E-04_JPRB,1.0230E-04_JPRB,&
&7.4794E-05_JPRB,4.4876E-05_JPRB,2.1143E-05_JPRB,1.0395E-05_JPRB,2.5481E-04_JPRB/)
KAO( :, 2,13, 1) = (/&
&1.6076E-04_JPRB,2.1391E-04_JPRB,2.1001E-04_JPRB,1.9062E-04_JPRB,1.6104E-04_JPRB,1.2883E-04_JPRB,&
&9.4499E-05_JPRB,5.6968E-05_JPRB,2.6983E-05_JPRB,1.3259E-05_JPRB,3.1628E-04_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.9591E-04_JPRB,2.5905E-04_JPRB,2.5408E-04_JPRB,2.3203E-04_JPRB,1.9732E-04_JPRB,1.5826E-04_JPRB,&
&1.1655E-04_JPRB,7.0656E-05_JPRB,3.3658E-05_JPRB,1.6638E-05_JPRB,3.8652E-04_JPRB/)
KAO( :, 4,13, 1) = (/&
&2.3390E-04_JPRB,3.0751E-04_JPRB,3.0205E-04_JPRB,2.7698E-04_JPRB,2.3712E-04_JPRB,1.9078E-04_JPRB,&
&1.4104E-04_JPRB,8.5929E-05_JPRB,4.1109E-05_JPRB,2.0532E-05_JPRB,4.6199E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&2.7408E-04_JPRB,3.5916E-04_JPRB,3.5371E-04_JPRB,3.2549E-04_JPRB,2.8046E-04_JPRB,2.2630E-04_JPRB,&
&1.6790E-04_JPRB,1.0268E-04_JPRB,4.9402E-05_JPRB,2.4960E-05_JPRB,5.4289E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&6.0407E-03_JPRB,7.8065E-03_JPRB,8.1846E-03_JPRB,7.8906E-03_JPRB,7.1910E-03_JPRB,6.1108E-03_JPRB,&
&4.6908E-03_JPRB,3.0070E-03_JPRB,1.6029E-03_JPRB,8.9663E-04_JPRB,5.4161E-04_JPRB/)
KAO( :, 2, 1, 2) = (/&
&6.8195E-03_JPRB,8.6717E-03_JPRB,9.0298E-03_JPRB,8.7022E-03_JPRB,7.9330E-03_JPRB,6.7597E-03_JPRB,&
&5.2275E-03_JPRB,3.3989E-03_JPRB,1.8520E-03_JPRB,1.0477E-03_JPRB,6.3833E-04_JPRB/)
KAO( :, 3, 1, 2) = (/&
&7.5788E-03_JPRB,9.5388E-03_JPRB,9.9036E-03_JPRB,9.5604E-03_JPRB,8.7254E-03_JPRB,7.4504E-03_JPRB,&
&5.8064E-03_JPRB,3.8251E-03_JPRB,2.1238E-03_JPRB,1.2161E-03_JPRB,7.5231E-04_JPRB/)
KAO( :, 4, 1, 2) = (/&
&8.3303E-03_JPRB,1.0419E-02_JPRB,1.0813E-02_JPRB,1.0461E-02_JPRB,9.5556E-03_JPRB,8.1956E-03_JPRB,&
&6.4324E-03_JPRB,4.2921E-03_JPRB,2.4115E-03_JPRB,1.4052E-03_JPRB,8.8294E-04_JPRB/)
KAO( :, 5, 1, 2) = (/&
&9.0559E-03_JPRB,1.1320E-02_JPRB,1.1753E-02_JPRB,1.1384E-02_JPRB,1.0421E-02_JPRB,8.9932E-03_JPRB,&
&7.1094E-03_JPRB,4.8020E-03_JPRB,2.7233E-03_JPRB,1.6150E-03_JPRB,1.0321E-03_JPRB/)
KAO( :, 1, 2, 2) = (/&
&5.2124E-03_JPRB,6.6819E-03_JPRB,6.9789E-03_JPRB,6.7465E-03_JPRB,6.1674E-03_JPRB,5.2549E-03_JPRB,&
&4.0193E-03_JPRB,2.5539E-03_JPRB,1.3468E-03_JPRB,7.4621E-04_JPRB,4.4731E-04_JPRB/)
KAO( :, 2, 2, 2) = (/&
&5.8769E-03_JPRB,7.4300E-03_JPRB,7.7105E-03_JPRB,7.4546E-03_JPRB,6.8169E-03_JPRB,5.8241E-03_JPRB,&
&4.4832E-03_JPRB,2.8884E-03_JPRB,1.5578E-03_JPRB,8.7448E-04_JPRB,5.2849E-04_JPRB/)
KAO( :, 3, 2, 2) = (/&
&6.5337E-03_JPRB,8.1860E-03_JPRB,8.4759E-03_JPRB,8.2057E-03_JPRB,7.5067E-03_JPRB,6.4273E-03_JPRB,&
&4.9857E-03_JPRB,3.2553E-03_JPRB,1.7880E-03_JPRB,1.0185E-03_JPRB,6.2321E-04_JPRB/)
KAO( :, 4, 2, 2) = (/&
&7.1816E-03_JPRB,8.9552E-03_JPRB,9.2749E-03_JPRB,8.9993E-03_JPRB,8.2303E-03_JPRB,7.0662E-03_JPRB,&
&5.5323E-03_JPRB,3.6583E-03_JPRB,2.0367E-03_JPRB,1.1804E-03_JPRB,7.3231E-04_JPRB/)
KAO( :, 5, 2, 2) = (/&
&7.8051E-03_JPRB,9.7506E-03_JPRB,1.0101E-02_JPRB,9.8071E-03_JPRB,8.9873E-03_JPRB,7.7508E-03_JPRB,&
&6.1243E-03_JPRB,4.1022E-03_JPRB,2.3063E-03_JPRB,1.3585E-03_JPRB,8.5647E-04_JPRB/)
KAO( :, 1, 3, 2) = (/&
&4.3523E-03_JPRB,5.5520E-03_JPRB,5.7775E-03_JPRB,5.5913E-03_JPRB,5.1223E-03_JPRB,4.3826E-03_JPRB,&
&3.3610E-03_JPRB,2.1161E-03_JPRB,1.0951E-03_JPRB,5.9556E-04_JPRB,3.7857E-04_JPRB/)
KAO( :, 2, 3, 2) = (/&
&4.9209E-03_JPRB,6.2002E-03_JPRB,6.4082E-03_JPRB,6.1965E-03_JPRB,5.6752E-03_JPRB,4.8744E-03_JPRB,&
&3.7636E-03_JPRB,2.3985E-03_JPRB,1.2700E-03_JPRB,7.0291E-04_JPRB,4.5096E-04_JPRB/)
KAO( :, 3, 3, 2) = (/&
&5.4868E-03_JPRB,6.8502E-03_JPRB,7.0667E-03_JPRB,6.8427E-03_JPRB,6.2712E-03_JPRB,5.3957E-03_JPRB,&
&4.1940E-03_JPRB,2.7077E-03_JPRB,1.4615E-03_JPRB,8.2150E-04_JPRB,5.3286E-04_JPRB/)
KAO( :, 4, 3, 2) = (/&
&6.0417E-03_JPRB,7.5160E-03_JPRB,7.7553E-03_JPRB,7.5242E-03_JPRB,6.9056E-03_JPRB,5.9509E-03_JPRB,&
&4.6578E-03_JPRB,3.0477E-03_JPRB,1.6703E-03_JPRB,9.5611E-04_JPRB,6.2579E-04_JPRB/)
KAO( :, 5, 3, 2) = (/&
&6.5818E-03_JPRB,8.2045E-03_JPRB,8.4687E-03_JPRB,8.2290E-03_JPRB,7.5712E-03_JPRB,6.5448E-03_JPRB,&
&5.1618E-03_JPRB,3.4239E-03_JPRB,1.8984E-03_JPRB,1.1049E-03_JPRB,7.3100E-04_JPRB/)
KAO( :, 1, 4, 2) = (/&
&3.6037E-03_JPRB,4.5619E-03_JPRB,4.7284E-03_JPRB,4.5758E-03_JPRB,4.1942E-03_JPRB,3.5992E-03_JPRB,&
&2.7695E-03_JPRB,1.7380E-03_JPRB,8.8220E-04_JPRB,4.6885E-04_JPRB,3.3625E-04_JPRB/)
KAO( :, 2, 4, 2) = (/&
&4.0887E-03_JPRB,5.1148E-03_JPRB,5.2710E-03_JPRB,5.0898E-03_JPRB,4.6632E-03_JPRB,4.0157E-03_JPRB,&
&3.1155E-03_JPRB,1.9801E-03_JPRB,1.0256E-03_JPRB,5.5681E-04_JPRB,4.0363E-04_JPRB/)
KAO( :, 3, 4, 2) = (/&
&4.5729E-03_JPRB,5.6722E-03_JPRB,5.8309E-03_JPRB,5.6384E-03_JPRB,5.1725E-03_JPRB,4.4617E-03_JPRB,&
&3.4837E-03_JPRB,2.2420E-03_JPRB,1.1837E-03_JPRB,6.5451E-04_JPRB,4.7814E-04_JPRB/)
KAO( :, 4, 4, 2) = (/&
&5.0500E-03_JPRB,6.2435E-03_JPRB,6.4200E-03_JPRB,6.2178E-03_JPRB,5.7168E-03_JPRB,4.9415E-03_JPRB,&
&3.8793E-03_JPRB,2.5280E-03_JPRB,1.3568E-03_JPRB,7.6386E-04_JPRB,5.6139E-04_JPRB/)
KAO( :, 5, 4, 2) = (/&
&5.5166E-03_JPRB,6.8327E-03_JPRB,7.0292E-03_JPRB,6.8237E-03_JPRB,6.2950E-03_JPRB,5.4568E-03_JPRB,&
&4.3128E-03_JPRB,2.8421E-03_JPRB,1.5485E-03_JPRB,8.8605E-04_JPRB,6.5402E-04_JPRB/)
KAO( :, 1, 5, 2) = (/&
&2.9853E-03_JPRB,3.7407E-03_JPRB,3.8556E-03_JPRB,3.7312E-03_JPRB,3.4190E-03_JPRB,2.9428E-03_JPRB,&
&2.2723E-03_JPRB,1.4198E-03_JPRB,7.1091E-04_JPRB,3.6855E-04_JPRB,3.1611E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&3.4022E-03_JPRB,4.2141E-03_JPRB,4.3188E-03_JPRB,4.1657E-03_JPRB,3.8152E-03_JPRB,3.2922E-03_JPRB,&
&2.5629E-03_JPRB,1.6244E-03_JPRB,8.2914E-04_JPRB,4.3956E-04_JPRB,3.7920E-04_JPRB/)
KAO( :, 3, 5, 2) = (/&
&3.8163E-03_JPRB,4.6908E-03_JPRB,4.7976E-03_JPRB,4.6281E-03_JPRB,4.2450E-03_JPRB,3.6719E-03_JPRB,&
&2.8734E-03_JPRB,1.8464E-03_JPRB,9.6023E-04_JPRB,5.1918E-04_JPRB,4.5044E-04_JPRB/)
KAO( :, 4, 5, 2) = (/&
&4.2238E-03_JPRB,5.1812E-03_JPRB,5.2987E-03_JPRB,5.1187E-03_JPRB,4.7071E-03_JPRB,4.0810E-03_JPRB,&
&3.2111E-03_JPRB,2.0883E-03_JPRB,1.1042E-03_JPRB,6.0901E-04_JPRB,5.3057E-04_JPRB/)
KAO( :, 5, 5, 2) = (/&
&4.6242E-03_JPRB,5.6849E-03_JPRB,5.8163E-03_JPRB,5.6316E-03_JPRB,5.2005E-03_JPRB,4.5233E-03_JPRB,&
&3.5780E-03_JPRB,2.3536E-03_JPRB,1.2639E-03_JPRB,7.0822E-04_JPRB,6.1748E-04_JPRB/)
KAO( :, 1, 6, 2) = (/&
&2.4498E-03_JPRB,3.0475E-03_JPRB,3.1220E-03_JPRB,3.0196E-03_JPRB,2.7652E-03_JPRB,2.3889E-03_JPRB,&
&1.8491E-03_JPRB,1.1489E-03_JPRB,5.6714E-04_JPRB,2.8783E-04_JPRB,3.1080E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&2.8080E-03_JPRB,3.4520E-03_JPRB,3.5157E-03_JPRB,3.3870E-03_JPRB,3.0980E-03_JPRB,2.6793E-03_JPRB,&
&2.0903E-03_JPRB,1.3197E-03_JPRB,6.6501E-04_JPRB,3.4472E-04_JPRB,3.7051E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&3.1640E-03_JPRB,3.8601E-03_JPRB,3.9229E-03_JPRB,3.7774E-03_JPRB,3.4589E-03_JPRB,2.9977E-03_JPRB,&
&2.3510E-03_JPRB,1.5040E-03_JPRB,7.7398E-04_JPRB,4.0896E-04_JPRB,4.3796E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&3.5132E-03_JPRB,4.2794E-03_JPRB,4.3478E-03_JPRB,4.1882E-03_JPRB,3.8474E-03_JPRB,3.3403E-03_JPRB,&
&2.6340E-03_JPRB,1.7060E-03_JPRB,8.9431E-04_JPRB,4.8188E-04_JPRB,5.1446E-04_JPRB/)
KAO( :, 5, 6, 2) = (/&
&3.8604E-03_JPRB,4.7099E-03_JPRB,4.7886E-03_JPRB,4.6205E-03_JPRB,4.2616E-03_JPRB,3.7139E-03_JPRB,&
&2.9438E-03_JPRB,1.9283E-03_JPRB,1.0272E-03_JPRB,5.6324E-04_JPRB,5.9978E-04_JPRB/)
KAO( :, 1, 7, 2) = (/&
&1.9828E-03_JPRB,2.4555E-03_JPRB,2.5089E-03_JPRB,2.4265E-03_JPRB,2.2222E-03_JPRB,1.9219E-03_JPRB,&
&1.4917E-03_JPRB,9.2169E-04_JPRB,4.4935E-04_JPRB,2.2355E-04_JPRB,3.2905E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&2.2898E-03_JPRB,2.8015E-03_JPRB,2.8404E-03_JPRB,2.7343E-03_JPRB,2.4995E-03_JPRB,2.1638E-03_JPRB,&
&1.6905E-03_JPRB,1.0629E-03_JPRB,5.2977E-04_JPRB,2.6953E-04_JPRB,3.8642E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&2.5950E-03_JPRB,3.1495E-03_JPRB,3.1847E-03_JPRB,3.0608E-03_JPRB,2.7988E-03_JPRB,2.4271E-03_JPRB,&
&1.9063E-03_JPRB,1.2157E-03_JPRB,6.1889E-04_JPRB,3.2121E-04_JPRB,4.5238E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&2.8946E-03_JPRB,3.5066E-03_JPRB,3.5426E-03_JPRB,3.4040E-03_JPRB,3.1227E-03_JPRB,2.7135E-03_JPRB,&
&2.1417E-03_JPRB,1.3825E-03_JPRB,7.1739E-04_JPRB,3.7957E-04_JPRB,5.2784E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&3.1931E-03_JPRB,3.8740E-03_JPRB,3.9151E-03_JPRB,3.7654E-03_JPRB,3.4684E-03_JPRB,3.0255E-03_JPRB,&
&2.3992E-03_JPRB,1.5660E-03_JPRB,8.2652E-04_JPRB,4.4537E-04_JPRB,6.1466E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&1.5989E-03_JPRB,1.9702E-03_JPRB,2.0115E-03_JPRB,1.9470E-03_JPRB,1.7844E-03_JPRB,1.5432E-03_JPRB,&
&1.1995E-03_JPRB,7.3709E-04_JPRB,3.5460E-04_JPRB,1.7239E-04_JPRB,4.0077E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&1.8612E-03_JPRB,2.2667E-03_JPRB,2.2904E-03_JPRB,2.2044E-03_JPRB,2.0147E-03_JPRB,1.7439E-03_JPRB,&
&1.3635E-03_JPRB,8.5344E-04_JPRB,4.2074E-04_JPRB,2.0967E-04_JPRB,4.6582E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&2.1244E-03_JPRB,2.5624E-03_JPRB,2.5789E-03_JPRB,2.4755E-03_JPRB,2.2630E-03_JPRB,1.9622E-03_JPRB,&
&1.5425E-03_JPRB,9.7987E-04_JPRB,4.9319E-04_JPRB,2.5142E-04_JPRB,5.4055E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&2.3819E-03_JPRB,2.8649E-03_JPRB,2.8813E-03_JPRB,2.7618E-03_JPRB,2.5306E-03_JPRB,2.2005E-03_JPRB,&
&1.7382E-03_JPRB,1.1179E-03_JPRB,5.7326E-04_JPRB,2.9833E-04_JPRB,6.2468E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&2.6384E-03_JPRB,3.1771E-03_JPRB,3.1953E-03_JPRB,3.0634E-03_JPRB,2.8174E-03_JPRB,2.4583E-03_JPRB,&
&1.9520E-03_JPRB,1.2696E-03_JPRB,6.6233E-04_JPRB,3.5121E-04_JPRB,7.1932E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&1.2874E-03_JPRB,1.5807E-03_JPRB,1.6105E-03_JPRB,1.5596E-03_JPRB,1.4331E-03_JPRB,1.2409E-03_JPRB,&
&9.6467E-04_JPRB,5.8855E-04_JPRB,2.7878E-04_JPRB,1.3223E-04_JPRB,7.1624E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&1.5123E-03_JPRB,1.8336E-03_JPRB,1.8477E-03_JPRB,1.7758E-03_JPRB,1.6249E-03_JPRB,1.4066E-03_JPRB,&
&1.0996E-03_JPRB,6.8448E-04_JPRB,3.3322E-04_JPRB,1.6247E-04_JPRB,8.2651E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&1.7405E-03_JPRB,2.0860E-03_JPRB,2.0902E-03_JPRB,2.0023E-03_JPRB,1.8310E-03_JPRB,1.5864E-03_JPRB,&
&1.2475E-03_JPRB,7.8935E-04_JPRB,3.9239E-04_JPRB,1.9609E-04_JPRB,9.5177E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&1.9645E-03_JPRB,2.3442E-03_JPRB,2.3456E-03_JPRB,2.2427E-03_JPRB,2.0525E-03_JPRB,1.7831E-03_JPRB,&
&1.4096E-03_JPRB,9.0343E-04_JPRB,4.5751E-04_JPRB,2.3374E-04_JPRB,1.0933E-03_JPRB/)
KAO( :, 5, 9, 2) = (/&
&2.1858E-03_JPRB,2.6097E-03_JPRB,2.6113E-03_JPRB,2.4953E-03_JPRB,2.2897E-03_JPRB,1.9950E-03_JPRB,&
&1.5860E-03_JPRB,1.0288E-03_JPRB,5.2969E-04_JPRB,2.7603E-04_JPRB,1.2508E-03_JPRB/)
KAO( :, 1,10, 2) = (/&
&1.0529E-03_JPRB,1.2869E-03_JPRB,1.3057E-03_JPRB,1.2641E-03_JPRB,1.1629E-03_JPRB,1.0080E-03_JPRB,&
&7.8495E-04_JPRB,4.7620E-04_JPRB,2.2170E-04_JPRB,1.0270E-04_JPRB,1.3580E-03_JPRB/)
KAO( :, 2,10, 2) = (/&
&1.2490E-03_JPRB,1.5074E-03_JPRB,1.5131E-03_JPRB,1.4495E-03_JPRB,1.3257E-03_JPRB,1.1471E-03_JPRB,&
&8.9825E-04_JPRB,5.5593E-04_JPRB,2.6681E-04_JPRB,1.2750E-04_JPRB,1.5971E-03_JPRB/)
KAO( :, 3,10, 2) = (/&
&1.4492E-03_JPRB,1.7260E-03_JPRB,1.7215E-03_JPRB,1.6426E-03_JPRB,1.5005E-03_JPRB,1.2985E-03_JPRB,&
&1.0216E-03_JPRB,6.4239E-04_JPRB,3.1568E-04_JPRB,1.5479E-04_JPRB,1.8667E-03_JPRB/)
KAO( :, 4,10, 2) = (/&
&1.6458E-03_JPRB,1.9481E-03_JPRB,1.9385E-03_JPRB,1.8468E-03_JPRB,1.6872E-03_JPRB,1.4625E-03_JPRB,&
&1.1568E-03_JPRB,7.3723E-04_JPRB,3.6917E-04_JPRB,1.8512E-04_JPRB,2.1592E-03_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.8388E-03_JPRB,2.1768E-03_JPRB,2.1658E-03_JPRB,2.0613E-03_JPRB,1.8866E-03_JPRB,1.6398E-03_JPRB,&
&1.3041E-03_JPRB,8.4131E-04_JPRB,4.2827E-04_JPRB,2.1913E-04_JPRB,2.4697E-03_JPRB/)
KAO( :, 1,11, 2) = (/&
&9.3652E-04_JPRB,1.1385E-03_JPRB,1.1471E-03_JPRB,1.1044E-03_JPRB,1.0133E-03_JPRB,8.7645E-04_JPRB,&
&6.8412E-04_JPRB,4.1724E-04_JPRB,1.9356E-04_JPRB,8.8827E-05_JPRB,1.5807E-03_JPRB/)
KAO( :, 2,11, 2) = (/&
&1.1100E-03_JPRB,1.3322E-03_JPRB,1.3282E-03_JPRB,1.2667E-03_JPRB,1.1577E-03_JPRB,1.0002E-03_JPRB,&
&7.8407E-04_JPRB,4.8629E-04_JPRB,2.3224E-04_JPRB,1.1007E-04_JPRB,1.8547E-03_JPRB/)
KAO( :, 3,11, 2) = (/&
&1.2856E-03_JPRB,1.5232E-03_JPRB,1.5121E-03_JPRB,1.4368E-03_JPRB,1.3117E-03_JPRB,1.1334E-03_JPRB,&
&8.9329E-04_JPRB,5.6169E-04_JPRB,2.7435E-04_JPRB,1.3331E-04_JPRB,2.1559E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&1.4549E-03_JPRB,1.7175E-03_JPRB,1.7035E-03_JPRB,1.6171E-03_JPRB,1.4759E-03_JPRB,1.2781E-03_JPRB,&
&1.0119E-03_JPRB,6.4442E-04_JPRB,3.2046E-04_JPRB,1.5895E-04_JPRB,2.4834E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.6224E-03_JPRB,1.9187E-03_JPRB,1.9023E-03_JPRB,1.8058E-03_JPRB,1.6504E-03_JPRB,1.4334E-03_JPRB,&
&1.1403E-03_JPRB,7.3509E-04_JPRB,3.7157E-04_JPRB,1.8783E-04_JPRB,2.8350E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&8.1827E-04_JPRB,9.9361E-04_JPRB,9.9598E-04_JPRB,9.5548E-04_JPRB,8.7645E-04_JPRB,7.5891E-04_JPRB,&
&5.9398E-04_JPRB,3.6310E-04_JPRB,1.6830E-04_JPRB,7.6627E-05_JPRB,1.5346E-03_JPRB/)
KAO( :, 2,12, 2) = (/&
&9.6798E-04_JPRB,1.1604E-03_JPRB,1.1525E-03_JPRB,1.0960E-03_JPRB,1.0027E-03_JPRB,8.6748E-04_JPRB,&
&6.8181E-04_JPRB,4.2341E-04_JPRB,2.0151E-04_JPRB,9.4708E-05_JPRB,1.7971E-03_JPRB/)
KAO( :, 3,12, 2) = (/&
&1.1161E-03_JPRB,1.3239E-03_JPRB,1.3118E-03_JPRB,1.2444E-03_JPRB,1.1369E-03_JPRB,9.8346E-04_JPRB,&
&7.7783E-04_JPRB,4.8954E-04_JPRB,2.3774E-04_JPRB,1.1437E-04_JPRB,2.0823E-03_JPRB/)
KAO( :, 4,12, 2) = (/&
&1.2595E-03_JPRB,1.4901E-03_JPRB,1.4761E-03_JPRB,1.3996E-03_JPRB,1.2792E-03_JPRB,1.1092E-03_JPRB,&
&8.8159E-04_JPRB,5.6210E-04_JPRB,2.7747E-04_JPRB,1.3609E-04_JPRB,2.3913E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&1.4015E-03_JPRB,1.6631E-03_JPRB,1.6469E-03_JPRB,1.5633E-03_JPRB,1.4309E-03_JPRB,1.2447E-03_JPRB,&
&9.9327E-04_JPRB,6.4127E-04_JPRB,3.2131E-04_JPRB,1.6049E-04_JPRB,2.7230E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&7.0404E-04_JPRB,8.5653E-04_JPRB,8.5583E-04_JPRB,8.1887E-04_JPRB,7.5123E-04_JPRB,6.5123E-04_JPRB,&
&5.1170E-04_JPRB,3.1408E-04_JPRB,1.4547E-04_JPRB,6.5608E-05_JPRB,1.2897E-03_JPRB/)
KAO( :, 2,13, 2) = (/&
&8.3008E-04_JPRB,9.9639E-04_JPRB,9.8845E-04_JPRB,9.3911E-04_JPRB,8.5990E-04_JPRB,7.4464E-04_JPRB,&
&5.8802E-04_JPRB,3.6685E-04_JPRB,1.7398E-04_JPRB,8.0807E-05_JPRB,1.5096E-03_JPRB/)
KAO( :, 3,13, 2) = (/&
&9.5290E-04_JPRB,1.1338E-03_JPRB,1.1232E-03_JPRB,1.0653E-03_JPRB,9.7462E-04_JPRB,8.4434E-04_JPRB,&
&6.7107E-04_JPRB,4.2462E-04_JPRB,2.0511E-04_JPRB,9.7336E-05_JPRB,1.7467E-03_JPRB/)
KAO( :, 4,13, 2) = (/&
&1.0727E-03_JPRB,1.2739E-03_JPRB,1.2624E-03_JPRB,1.1971E-03_JPRB,1.0958E-03_JPRB,9.5214E-04_JPRB,&
&7.5999E-04_JPRB,4.8760E-04_JPRB,2.3902E-04_JPRB,1.1564E-04_JPRB,2.0029E-03_JPRB/)
KAO( :, 5,13, 2) = (/&
&1.1912E-03_JPRB,1.4186E-03_JPRB,1.4067E-03_JPRB,1.3365E-03_JPRB,1.2243E-03_JPRB,1.0674E-03_JPRB,&
&8.5545E-04_JPRB,5.5580E-04_JPRB,2.7627E-04_JPRB,1.3629E-04_JPRB,2.2773E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&1.5976E-02_JPRB,1.8568E-02_JPRB,1.8677E-02_JPRB,1.8308E-02_JPRB,1.7430E-02_JPRB,1.5980E-02_JPRB,&
&1.3794E-02_JPRB,1.0032E-02_JPRB,5.6593E-03_JPRB,3.1315E-03_JPRB,1.4725E-03_JPRB/)
KAO( :, 2, 1, 3) = (/&
&1.7009E-02_JPRB,1.9983E-02_JPRB,2.0158E-02_JPRB,1.9765E-02_JPRB,1.8846E-02_JPRB,1.7308E-02_JPRB,&
&1.4965E-02_JPRB,1.0920E-02_JPRB,6.2447E-03_JPRB,3.5291E-03_JPRB,1.7476E-03_JPRB/)
KAO( :, 3, 1, 3) = (/&
&1.8075E-02_JPRB,2.1456E-02_JPRB,2.1662E-02_JPRB,2.1259E-02_JPRB,2.0298E-02_JPRB,1.8677E-02_JPRB,&
&1.6168E-02_JPRB,1.1845E-02_JPRB,6.8970E-03_JPRB,3.9734E-03_JPRB,2.0647E-03_JPRB/)
KAO( :, 4, 1, 3) = (/&
&1.9173E-02_JPRB,2.2980E-02_JPRB,2.3194E-02_JPRB,2.2786E-02_JPRB,2.1822E-02_JPRB,2.0115E-02_JPRB,&
&1.7401E-02_JPRB,1.2827E-02_JPRB,7.6128E-03_JPRB,4.4580E-03_JPRB,2.4335E-03_JPRB/)
KAO( :, 5, 1, 3) = (/&
&2.0338E-02_JPRB,2.4533E-02_JPRB,2.4778E-02_JPRB,2.4397E-02_JPRB,2.3401E-02_JPRB,2.1590E-02_JPRB,&
&1.8677E-02_JPRB,1.3858E-02_JPRB,8.3792E-03_JPRB,4.9858E-03_JPRB,2.8649E-03_JPRB/)
KAO( :, 1, 2, 3) = (/&
&1.3803E-02_JPRB,1.6030E-02_JPRB,1.6037E-02_JPRB,1.5594E-02_JPRB,1.4756E-02_JPRB,1.3459E-02_JPRB,&
&1.1617E-02_JPRB,8.5122E-03_JPRB,4.8022E-03_JPRB,2.6569E-03_JPRB,1.3182E-03_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.4747E-02_JPRB,1.7312E-02_JPRB,1.7346E-02_JPRB,1.6863E-02_JPRB,1.5968E-02_JPRB,1.4592E-02_JPRB,&
&1.2613E-02_JPRB,9.2706E-03_JPRB,5.3102E-03_JPRB,3.0023E-03_JPRB,1.5460E-03_JPRB/)
KAO( :, 3, 2, 3) = (/&
&1.5720E-02_JPRB,1.8638E-02_JPRB,1.8676E-02_JPRB,1.8166E-02_JPRB,1.7228E-02_JPRB,1.5775E-02_JPRB,&
&1.3646E-02_JPRB,1.0060E-02_JPRB,5.8750E-03_JPRB,3.3882E-03_JPRB,1.8045E-03_JPRB/)
KAO( :, 4, 2, 3) = (/&
&1.6750E-02_JPRB,1.9993E-02_JPRB,2.0028E-02_JPRB,1.9499E-02_JPRB,1.8542E-02_JPRB,1.7020E-02_JPRB,&
&1.4712E-02_JPRB,1.0896E-02_JPRB,6.4908E-03_JPRB,3.8125E-03_JPRB,2.0990E-03_JPRB/)
KAO( :, 5, 2, 3) = (/&
&1.7833E-02_JPRB,2.1360E-02_JPRB,2.1424E-02_JPRB,2.0911E-02_JPRB,1.9906E-02_JPRB,1.8307E-02_JPRB,&
&1.5816E-02_JPRB,1.1769E-02_JPRB,7.1573E-03_JPRB,4.2773E-03_JPRB,2.4433E-03_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.1661E-02_JPRB,1.3546E-02_JPRB,1.3524E-02_JPRB,1.3093E-02_JPRB,1.2307E-02_JPRB,1.1159E-02_JPRB,&
&9.5780E-03_JPRB,7.0484E-03_JPRB,3.9675E-03_JPRB,2.1846E-03_JPRB,1.2406E-03_JPRB/)
KAO( :, 2, 3, 3) = (/&
&1.2503E-02_JPRB,1.4707E-02_JPRB,1.4691E-02_JPRB,1.4206E-02_JPRB,1.3360E-02_JPRB,1.2110E-02_JPRB,&
&1.0409E-02_JPRB,7.6788E-03_JPRB,4.3933E-03_JPRB,2.4719E-03_JPRB,1.4298E-03_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.3391E-02_JPRB,1.5887E-02_JPRB,1.5874E-02_JPRB,1.5334E-02_JPRB,1.4440E-02_JPRB,1.3111E-02_JPRB,&
&1.1280E-02_JPRB,8.3388E-03_JPRB,4.8688E-03_JPRB,2.7958E-03_JPRB,1.6523E-03_JPRB/)
KAO( :, 4, 3, 3) = (/&
&1.4336E-02_JPRB,1.7085E-02_JPRB,1.7069E-02_JPRB,1.6495E-02_JPRB,1.5553E-02_JPRB,1.4166E-02_JPRB,&
&1.2195E-02_JPRB,9.0457E-03_JPRB,5.3867E-03_JPRB,3.1533E-03_JPRB,1.9090E-03_JPRB/)
KAO( :, 5, 3, 3) = (/&
&1.5320E-02_JPRB,1.8321E-02_JPRB,1.8292E-02_JPRB,1.7706E-02_JPRB,1.6704E-02_JPRB,1.5265E-02_JPRB,&
&1.3148E-02_JPRB,9.7836E-03_JPRB,5.9483E-03_JPRB,3.5492E-03_JPRB,2.2059E-03_JPRB/)
KAO( :, 1, 4, 3) = (/&
&9.7449E-03_JPRB,1.1294E-02_JPRB,1.1258E-02_JPRB,1.0884E-02_JPRB,1.0199E-02_JPRB,9.2227E-03_JPRB,&
&7.8658E-03_JPRB,5.7767E-03_JPRB,3.2406E-03_JPRB,1.7708E-03_JPRB,1.2728E-03_JPRB/)
KAO( :, 2, 4, 3) = (/&
&1.0487E-02_JPRB,1.2330E-02_JPRB,1.2286E-02_JPRB,1.1862E-02_JPRB,1.1122E-02_JPRB,1.0046E-02_JPRB,&
&8.5629E-03_JPRB,6.2952E-03_JPRB,3.5929E-03_JPRB,2.0093E-03_JPRB,1.4326E-03_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.1282E-02_JPRB,1.3369E-02_JPRB,1.3332E-02_JPRB,1.2857E-02_JPRB,1.2064E-02_JPRB,1.0901E-02_JPRB,&
&9.2930E-03_JPRB,6.8463E-03_JPRB,3.9872E-03_JPRB,2.2770E-03_JPRB,1.6227E-03_JPRB/)
KAO( :, 4, 4, 3) = (/&
&1.2130E-02_JPRB,1.4435E-02_JPRB,1.4396E-02_JPRB,1.3883E-02_JPRB,1.3026E-02_JPRB,1.1786E-02_JPRB,&
&1.0067E-02_JPRB,7.4371E-03_JPRB,4.4153E-03_JPRB,2.5725E-03_JPRB,1.8437E-03_JPRB/)
KAO( :, 5, 4, 3) = (/&
&1.3022E-02_JPRB,1.5544E-02_JPRB,1.5501E-02_JPRB,1.4941E-02_JPRB,1.4007E-02_JPRB,1.2708E-02_JPRB,&
&1.0876E-02_JPRB,8.0666E-03_JPRB,4.8767E-03_JPRB,2.9035E-03_JPRB,2.1000E-03_JPRB/)
KAO( :, 1, 5, 3) = (/&
&8.1183E-03_JPRB,9.3706E-03_JPRB,9.3339E-03_JPRB,9.0036E-03_JPRB,8.4209E-03_JPRB,7.5832E-03_JPRB,&
&6.4445E-03_JPRB,4.7331E-03_JPRB,2.6371E-03_JPRB,1.4269E-03_JPRB,1.3512E-03_JPRB/)
KAO( :, 2, 5, 3) = (/&
&8.7619E-03_JPRB,1.0271E-02_JPRB,1.0226E-02_JPRB,9.8533E-03_JPRB,9.2177E-03_JPRB,8.3034E-03_JPRB,&
&7.0466E-03_JPRB,5.1625E-03_JPRB,2.9261E-03_JPRB,1.6222E-03_JPRB,1.4975E-03_JPRB/)
KAO( :, 3, 5, 3) = (/&
&9.4590E-03_JPRB,1.1191E-02_JPRB,1.1132E-02_JPRB,1.0717E-02_JPRB,1.0035E-02_JPRB,9.0438E-03_JPRB,&
&7.6825E-03_JPRB,5.6186E-03_JPRB,3.2487E-03_JPRB,1.8419E-03_JPRB,1.6628E-03_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.0214E-02_JPRB,1.2129E-02_JPRB,1.2065E-02_JPRB,1.1613E-02_JPRB,1.0874E-02_JPRB,9.8104E-03_JPRB,&
&8.3376E-03_JPRB,6.1127E-03_JPRB,3.6040E-03_JPRB,2.0844E-03_JPRB,1.8526E-03_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.1012E-02_JPRB,1.3112E-02_JPRB,1.3045E-02_JPRB,1.2543E-02_JPRB,1.1733E-02_JPRB,1.0605E-02_JPRB,&
&9.0222E-03_JPRB,6.6408E-03_JPRB,3.9796E-03_JPRB,2.3572E-03_JPRB,2.0770E-03_JPRB/)
KAO( :, 1, 6, 3) = (/&
&6.7387E-03_JPRB,7.7194E-03_JPRB,7.6902E-03_JPRB,7.3986E-03_JPRB,6.9016E-03_JPRB,6.1800E-03_JPRB,&
&5.2304E-03_JPRB,3.8605E-03_JPRB,2.1393E-03_JPRB,1.1384E-03_JPRB,1.3809E-03_JPRB/)
KAO( :, 2, 6, 3) = (/&
&7.2904E-03_JPRB,8.4901E-03_JPRB,8.4559E-03_JPRB,8.1341E-03_JPRB,7.5897E-03_JPRB,6.8043E-03_JPRB,&
&5.7497E-03_JPRB,4.2219E-03_JPRB,2.3703E-03_JPRB,1.2951E-03_JPRB,1.5336E-03_JPRB/)
KAO( :, 3, 6, 3) = (/&
&7.8883E-03_JPRB,9.2955E-03_JPRB,9.2345E-03_JPRB,8.8797E-03_JPRB,8.2936E-03_JPRB,7.4421E-03_JPRB,&
&6.2952E-03_JPRB,4.6028E-03_JPRB,2.6285E-03_JPRB,1.4716E-03_JPRB,1.6931E-03_JPRB/)
KAO( :, 4, 6, 3) = (/&
&8.5494E-03_JPRB,1.0121E-02_JPRB,1.0046E-02_JPRB,9.6522E-03_JPRB,9.0176E-03_JPRB,8.1042E-03_JPRB,&
&6.8613E-03_JPRB,5.0179E-03_JPRB,2.9165E-03_JPRB,1.6693E-03_JPRB,1.8690E-03_JPRB/)
KAO( :, 5, 6, 3) = (/&
&9.2455E-03_JPRB,1.0989E-02_JPRB,1.0902E-02_JPRB,1.0465E-02_JPRB,9.7689E-03_JPRB,8.7913E-03_JPRB,&
&7.4494E-03_JPRB,5.4572E-03_JPRB,3.2276E-03_JPRB,1.8909E-03_JPRB,2.0643E-03_JPRB/)
KAO( :, 1, 7, 3) = (/&
&5.5708E-03_JPRB,6.3303E-03_JPRB,6.2934E-03_JPRB,6.0276E-03_JPRB,5.6127E-03_JPRB,5.0058E-03_JPRB,&
&4.2172E-03_JPRB,3.1142E-03_JPRB,1.7288E-03_JPRB,9.0214E-04_JPRB,1.3580E-03_JPRB/)
KAO( :, 2, 7, 3) = (/&
&6.0396E-03_JPRB,6.9771E-03_JPRB,6.9412E-03_JPRB,6.6559E-03_JPRB,6.1993E-03_JPRB,5.5301E-03_JPRB,&
&4.6524E-03_JPRB,3.4207E-03_JPRB,1.9119E-03_JPRB,1.0257E-03_JPRB,1.5329E-03_JPRB/)
KAO( :, 3, 7, 3) = (/&
&6.5450E-03_JPRB,7.6646E-03_JPRB,7.6059E-03_JPRB,7.3014E-03_JPRB,6.8031E-03_JPRB,6.0741E-03_JPRB,&
&5.1130E-03_JPRB,3.7412E-03_JPRB,2.1172E-03_JPRB,1.1666E-03_JPRB,1.7255E-03_JPRB/)
KAO( :, 4, 7, 3) = (/&
&7.1105E-03_JPRB,8.3764E-03_JPRB,8.3038E-03_JPRB,7.9705E-03_JPRB,7.4282E-03_JPRB,6.6393E-03_JPRB,&
&5.5928E-03_JPRB,4.0886E-03_JPRB,2.3470E-03_JPRB,1.3258E-03_JPRB,1.9241E-03_JPRB/)
KAO( :, 5, 7, 3) = (/&
&7.7089E-03_JPRB,9.1270E-03_JPRB,9.0467E-03_JPRB,8.6734E-03_JPRB,8.0760E-03_JPRB,7.2286E-03_JPRB,&
&6.0941E-03_JPRB,4.4574E-03_JPRB,2.6042E-03_JPRB,1.5049E-03_JPRB,2.1289E-03_JPRB/)
KAO( :, 1, 8, 3) = (/&
&4.5931E-03_JPRB,5.1838E-03_JPRB,5.1398E-03_JPRB,4.8986E-03_JPRB,4.5439E-03_JPRB,4.0450E-03_JPRB,&
&3.3970E-03_JPRB,2.5021E-03_JPRB,1.3915E-03_JPRB,7.1461E-04_JPRB,1.4342E-03_JPRB/)
KAO( :, 2, 8, 3) = (/&
&4.9923E-03_JPRB,5.7205E-03_JPRB,5.6835E-03_JPRB,5.4255E-03_JPRB,5.0420E-03_JPRB,4.4815E-03_JPRB,&
&3.7569E-03_JPRB,2.7595E-03_JPRB,1.5378E-03_JPRB,8.1223E-04_JPRB,1.6265E-03_JPRB/)
KAO( :, 3, 8, 3) = (/&
&5.4187E-03_JPRB,6.3059E-03_JPRB,6.2512E-03_JPRB,5.9779E-03_JPRB,5.5552E-03_JPRB,4.9397E-03_JPRB,&
&4.1407E-03_JPRB,3.0283E-03_JPRB,1.7020E-03_JPRB,9.2374E-04_JPRB,1.8395E-03_JPRB/)
KAO( :, 4, 8, 3) = (/&
&5.8951E-03_JPRB,6.9159E-03_JPRB,6.8456E-03_JPRB,6.5555E-03_JPRB,6.0927E-03_JPRB,5.4203E-03_JPRB,&
&4.5434E-03_JPRB,3.3140E-03_JPRB,1.8874E-03_JPRB,1.0500E-03_JPRB,2.0723E-03_JPRB/)
KAO( :, 5, 8, 3) = (/&
&6.4067E-03_JPRB,7.5583E-03_JPRB,7.4822E-03_JPRB,7.1624E-03_JPRB,6.6529E-03_JPRB,5.9218E-03_JPRB,&
&4.9680E-03_JPRB,3.6203E-03_JPRB,2.0980E-03_JPRB,1.1933E-03_JPRB,2.3247E-03_JPRB/)
KAO( :, 1, 9, 3) = (/&
&3.7723E-03_JPRB,4.2334E-03_JPRB,4.1819E-03_JPRB,3.9649E-03_JPRB,3.6588E-03_JPRB,3.2575E-03_JPRB,&
&2.7305E-03_JPRB,2.0072E-03_JPRB,1.1193E-03_JPRB,5.6741E-04_JPRB,1.9860E-03_JPRB/)
KAO( :, 2, 9, 3) = (/&
&4.1112E-03_JPRB,4.6764E-03_JPRB,4.6357E-03_JPRB,4.4068E-03_JPRB,4.0793E-03_JPRB,3.6198E-03_JPRB,&
&3.0290E-03_JPRB,2.2191E-03_JPRB,1.2358E-03_JPRB,6.4340E-04_JPRB,2.2587E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&4.4681E-03_JPRB,5.1657E-03_JPRB,5.1169E-03_JPRB,4.8742E-03_JPRB,4.5148E-03_JPRB,4.0038E-03_JPRB,&
&3.3466E-03_JPRB,2.4441E-03_JPRB,1.3675E-03_JPRB,7.3070E-04_JPRB,2.5668E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&4.8668E-03_JPRB,5.6866E-03_JPRB,5.6264E-03_JPRB,5.3677E-03_JPRB,4.9748E-03_JPRB,4.4113E-03_JPRB,&
&3.6848E-03_JPRB,2.6780E-03_JPRB,1.5165E-03_JPRB,8.3094E-04_JPRB,2.9044E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&5.3024E-03_JPRB,6.2338E-03_JPRB,6.1683E-03_JPRB,5.8906E-03_JPRB,5.4560E-03_JPRB,4.8416E-03_JPRB,&
&4.0418E-03_JPRB,2.9316E-03_JPRB,1.6868E-03_JPRB,9.4494E-04_JPRB,3.2758E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&3.1048E-03_JPRB,3.4713E-03_JPRB,3.4149E-03_JPRB,3.2215E-03_JPRB,2.9606E-03_JPRB,2.6323E-03_JPRB,&
&2.2040E-03_JPRB,1.6183E-03_JPRB,9.0511E-04_JPRB,4.5442E-04_JPRB,3.4066E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&3.3920E-03_JPRB,3.8387E-03_JPRB,3.7924E-03_JPRB,3.5898E-03_JPRB,3.3084E-03_JPRB,2.9358E-03_JPRB,&
&2.4507E-03_JPRB,1.7915E-03_JPRB,9.9919E-04_JPRB,5.1342E-04_JPRB,3.8889E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&3.6957E-03_JPRB,4.2459E-03_JPRB,4.1994E-03_JPRB,3.9831E-03_JPRB,3.6769E-03_JPRB,3.2571E-03_JPRB,&
&2.7157E-03_JPRB,1.9778E-03_JPRB,1.1048E-03_JPRB,5.8256E-04_JPRB,4.4355E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&4.0318E-03_JPRB,4.6867E-03_JPRB,4.6340E-03_JPRB,4.4000E-03_JPRB,4.0676E-03_JPRB,3.6005E-03_JPRB,&
&2.9971E-03_JPRB,2.1730E-03_JPRB,1.2259E-03_JPRB,6.6297E-04_JPRB,5.0564E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&4.4033E-03_JPRB,5.1538E-03_JPRB,5.0961E-03_JPRB,4.8470E-03_JPRB,4.4796E-03_JPRB,3.9660E-03_JPRB,&
&3.2977E-03_JPRB,2.3839E-03_JPRB,1.3631E-03_JPRB,7.5476E-04_JPRB,5.7516E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&2.6765E-03_JPRB,2.9827E-03_JPRB,2.9227E-03_JPRB,2.7508E-03_JPRB,2.5220E-03_JPRB,2.2363E-03_JPRB,&
&1.8676E-03_JPRB,1.3675E-03_JPRB,7.6612E-04_JPRB,3.8447E-04_JPRB,4.0480E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&2.9286E-03_JPRB,3.3040E-03_JPRB,3.2538E-03_JPRB,3.0703E-03_JPRB,2.8192E-03_JPRB,2.4962E-03_JPRB,&
&2.0772E-03_JPRB,1.5146E-03_JPRB,8.4625E-04_JPRB,4.3409E-04_JPRB,4.6666E-03_JPRB/)
KAO( :, 3,11, 3) = (/&
&3.2003E-03_JPRB,3.6648E-03_JPRB,3.6125E-03_JPRB,3.4113E-03_JPRB,3.1362E-03_JPRB,2.7724E-03_JPRB,&
&2.3029E-03_JPRB,1.6722E-03_JPRB,9.3679E-04_JPRB,4.9229E-04_JPRB,5.3654E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&3.5051E-03_JPRB,4.0531E-03_JPRB,3.9947E-03_JPRB,3.7750E-03_JPRB,3.4761E-03_JPRB,3.0693E-03_JPRB,&
&2.5452E-03_JPRB,1.8406E-03_JPRB,1.0404E-03_JPRB,5.6079E-04_JPRB,6.1512E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&3.8321E-03_JPRB,4.4649E-03_JPRB,4.4022E-03_JPRB,4.1654E-03_JPRB,3.8377E-03_JPRB,3.3874E-03_JPRB,&
&2.8053E-03_JPRB,2.0226E-03_JPRB,1.1574E-03_JPRB,6.3974E-04_JPRB,7.0160E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&2.3036E-03_JPRB,2.5583E-03_JPRB,2.4978E-03_JPRB,2.3445E-03_JPRB,2.1430E-03_JPRB,1.8944E-03_JPRB,&
&1.5761E-03_JPRB,1.1517E-03_JPRB,6.4556E-04_JPRB,3.2349E-04_JPRB,4.0392E-03_JPRB/)
KAO( :, 2,12, 3) = (/&
&2.5244E-03_JPRB,2.8452E-03_JPRB,2.7899E-03_JPRB,2.6237E-03_JPRB,2.3996E-03_JPRB,2.1171E-03_JPRB,&
&1.7537E-03_JPRB,1.2751E-03_JPRB,7.1384E-04_JPRB,3.6513E-04_JPRB,4.6690E-03_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.7664E-03_JPRB,3.1661E-03_JPRB,3.1080E-03_JPRB,2.9230E-03_JPRB,2.6751E-03_JPRB,2.3552E-03_JPRB,&
&1.9462E-03_JPRB,1.4075E-03_JPRB,7.9075E-04_JPRB,4.1435E-04_JPRB,5.3798E-03_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.0371E-03_JPRB,3.5090E-03_JPRB,3.4460E-03_JPRB,3.2437E-03_JPRB,2.9706E-03_JPRB,2.6114E-03_JPRB,&
&2.1543E-03_JPRB,1.5507E-03_JPRB,8.7926E-04_JPRB,4.7250E-04_JPRB,6.1711E-03_JPRB/)
KAO( :, 5,12, 3) = (/&
&3.3239E-03_JPRB,3.8709E-03_JPRB,3.8063E-03_JPRB,3.5842E-03_JPRB,3.2855E-03_JPRB,2.8872E-03_JPRB,&
&2.3774E-03_JPRB,1.7073E-03_JPRB,9.7951E-04_JPRB,5.3974E-04_JPRB,7.0329E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.9693E-03_JPRB,2.1819E-03_JPRB,2.1260E-03_JPRB,1.9917E-03_JPRB,1.8142E-03_JPRB,1.5977E-03_JPRB,&
&1.3230E-03_JPRB,9.6163E-04_JPRB,5.3722E-04_JPRB,2.6914E-04_JPRB,3.4457E-03_JPRB/)
KAO( :, 2,13, 3) = (/&
&2.1605E-03_JPRB,2.4363E-03_JPRB,2.3825E-03_JPRB,2.2341E-03_JPRB,2.0358E-03_JPRB,1.7890E-03_JPRB,&
&1.4743E-03_JPRB,1.0637E-03_JPRB,5.9461E-04_JPRB,3.0420E-04_JPRB,3.9859E-03_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.3729E-03_JPRB,2.7175E-03_JPRB,2.6607E-03_JPRB,2.4950E-03_JPRB,2.2744E-03_JPRB,1.9956E-03_JPRB,&
&1.6383E-03_JPRB,1.1739E-03_JPRB,6.5958E-04_JPRB,3.4564E-04_JPRB,4.5954E-03_JPRB/)
KAO( :, 4,13, 3) = (/&
&2.6042E-03_JPRB,3.0147E-03_JPRB,2.9558E-03_JPRB,2.7741E-03_JPRB,2.5310E-03_JPRB,2.2169E-03_JPRB,&
&1.8165E-03_JPRB,1.2954E-03_JPRB,7.3516E-04_JPRB,3.9462E-04_JPRB,5.2719E-03_JPRB/)
KAO( :, 5,13, 3) = (/&
&2.8484E-03_JPRB,3.3273E-03_JPRB,3.2687E-03_JPRB,3.0678E-03_JPRB,2.8024E-03_JPRB,2.4543E-03_JPRB,&
&2.0064E-03_JPRB,1.4291E-03_JPRB,8.2095E-04_JPRB,4.5105E-04_JPRB,5.9980E-03_JPRB/)
KAO( :, 1, 1, 4) = (/&
&3.2206E-02_JPRB,3.7616E-02_JPRB,3.7442E-02_JPRB,3.5602E-02_JPRB,3.2848E-02_JPRB,2.9212E-02_JPRB,&
&2.4411E-02_JPRB,1.8093E-02_JPRB,1.1087E-02_JPRB,6.4396E-03_JPRB,4.1579E-03_JPRB/)
KAO( :, 2, 1, 4) = (/&
&3.3985E-02_JPRB,4.0141E-02_JPRB,4.0066E-02_JPRB,3.8220E-02_JPRB,3.5310E-02_JPRB,3.1363E-02_JPRB,&
&2.6274E-02_JPRB,1.9563E-02_JPRB,1.2137E-02_JPRB,7.2344E-03_JPRB,4.9421E-03_JPRB/)
KAO( :, 3, 1, 4) = (/&
&3.5840E-02_JPRB,4.2657E-02_JPRB,4.2657E-02_JPRB,4.0828E-02_JPRB,3.7715E-02_JPRB,3.3592E-02_JPRB,&
&2.8238E-02_JPRB,2.1146E-02_JPRB,1.3263E-02_JPRB,8.1243E-03_JPRB,5.8370E-03_JPRB/)
KAO( :, 4, 1, 4) = (/&
&3.7710E-02_JPRB,4.5086E-02_JPRB,4.5284E-02_JPRB,4.3358E-02_JPRB,4.0123E-02_JPRB,3.5805E-02_JPRB,&
&3.0308E-02_JPRB,2.2810E-02_JPRB,1.4502E-02_JPRB,9.1329E-03_JPRB,6.8906E-03_JPRB/)
KAO( :, 5, 1, 4) = (/&
&3.9546E-02_JPRB,4.7465E-02_JPRB,4.7884E-02_JPRB,4.5873E-02_JPRB,4.2558E-02_JPRB,3.8078E-02_JPRB,&
&3.2453E-02_JPRB,2.4580E-02_JPRB,1.5839E-02_JPRB,1.0280E-02_JPRB,8.0935E-03_JPRB/)
KAO( :, 1, 2, 4) = (/&
&2.8104E-02_JPRB,3.2464E-02_JPRB,3.2358E-02_JPRB,3.0703E-02_JPRB,2.8262E-02_JPRB,2.5049E-02_JPRB,&
&2.0887E-02_JPRB,1.5371E-02_JPRB,9.5321E-03_JPRB,5.5766E-03_JPRB,3.4128E-03_JPRB/)
KAO( :, 2, 2, 4) = (/&
&2.9709E-02_JPRB,3.4733E-02_JPRB,3.4706E-02_JPRB,3.3029E-02_JPRB,3.0407E-02_JPRB,2.6975E-02_JPRB,&
&2.2525E-02_JPRB,1.6668E-02_JPRB,1.0444E-02_JPRB,6.2493E-03_JPRB,4.0210E-03_JPRB/)
KAO( :, 3, 2, 4) = (/&
&3.1368E-02_JPRB,3.6997E-02_JPRB,3.7038E-02_JPRB,3.5309E-02_JPRB,3.2541E-02_JPRB,2.8948E-02_JPRB,&
&2.4248E-02_JPRB,1.8078E-02_JPRB,1.1429E-02_JPRB,7.0025E-03_JPRB,4.7234E-03_JPRB/)
KAO( :, 4, 2, 4) = (/&
&3.3025E-02_JPRB,3.9194E-02_JPRB,3.9406E-02_JPRB,3.7566E-02_JPRB,3.4724E-02_JPRB,3.0907E-02_JPRB,&
&2.6047E-02_JPRB,1.9552E-02_JPRB,1.2511E-02_JPRB,7.8460E-03_JPRB,5.5531E-03_JPRB/)
KAO( :, 5, 2, 4) = (/&
&3.4658E-02_JPRB,4.1417E-02_JPRB,4.1750E-02_JPRB,3.9870E-02_JPRB,3.6925E-02_JPRB,3.2920E-02_JPRB,&
&2.7922E-02_JPRB,2.1122E-02_JPRB,1.3687E-02_JPRB,8.7925E-03_JPRB,6.5017E-03_JPRB/)
KAO( :, 1, 3, 4) = (/&
&2.4251E-02_JPRB,2.7585E-02_JPRB,2.7414E-02_JPRB,2.5896E-02_JPRB,2.3769E-02_JPRB,2.1015E-02_JPRB,&
&1.7490E-02_JPRB,1.2799E-02_JPRB,7.9859E-03_JPRB,4.6822E-03_JPRB,3.0167E-03_JPRB/)
KAO( :, 2, 3, 4) = (/&
&2.5692E-02_JPRB,2.9548E-02_JPRB,2.9492E-02_JPRB,2.7935E-02_JPRB,2.5630E-02_JPRB,2.2680E-02_JPRB,&
&1.8918E-02_JPRB,1.3904E-02_JPRB,8.7584E-03_JPRB,5.2529E-03_JPRB,3.4804E-03_JPRB/)
KAO( :, 3, 3, 4) = (/&
&2.7159E-02_JPRB,3.1559E-02_JPRB,3.1551E-02_JPRB,2.9932E-02_JPRB,2.7503E-02_JPRB,2.4395E-02_JPRB,&
&2.0399E-02_JPRB,1.5119E-02_JPRB,9.5888E-03_JPRB,5.8905E-03_JPRB,4.0103E-03_JPRB/)
KAO( :, 4, 3, 4) = (/&
&2.8607E-02_JPRB,3.3560E-02_JPRB,3.3603E-02_JPRB,3.1948E-02_JPRB,2.9447E-02_JPRB,2.6126E-02_JPRB,&
&2.1928E-02_JPRB,1.6399E-02_JPRB,1.0499E-02_JPRB,6.6008E-03_JPRB,4.6200E-03_JPRB/)
KAO( :, 5, 3, 4) = (/&
&3.0051E-02_JPRB,3.5562E-02_JPRB,3.5683E-02_JPRB,3.4039E-02_JPRB,3.1430E-02_JPRB,2.7908E-02_JPRB,&
&2.3518E-02_JPRB,1.7750E-02_JPRB,1.1493E-02_JPRB,7.3863E-03_JPRB,5.3130E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&2.0821E-02_JPRB,2.3399E-02_JPRB,2.3111E-02_JPRB,2.1751E-02_JPRB,1.9864E-02_JPRB,1.7485E-02_JPRB,&
&1.4530E-02_JPRB,1.0587E-02_JPRB,6.6174E-03_JPRB,3.8560E-03_JPRB,2.7540E-03_JPRB/)
KAO( :, 2, 4, 4) = (/&
&2.2145E-02_JPRB,2.5108E-02_JPRB,2.4937E-02_JPRB,2.3519E-02_JPRB,2.1458E-02_JPRB,1.8898E-02_JPRB,&
&1.5727E-02_JPRB,1.1528E-02_JPRB,7.2647E-03_JPRB,4.3306E-03_JPRB,3.1427E-03_JPRB/)
KAO( :, 3, 4, 4) = (/&
&2.3458E-02_JPRB,2.6892E-02_JPRB,2.6767E-02_JPRB,2.5244E-02_JPRB,2.3063E-02_JPRB,2.0374E-02_JPRB,&
&1.6989E-02_JPRB,1.2556E-02_JPRB,7.9663E-03_JPRB,4.8678E-03_JPRB,3.5922E-03_JPRB/)
KAO( :, 4, 4, 4) = (/&
&2.4742E-02_JPRB,2.8684E-02_JPRB,2.8567E-02_JPRB,2.7002E-02_JPRB,2.4744E-02_JPRB,2.1891E-02_JPRB,&
&1.8302E-02_JPRB,1.3637E-02_JPRB,8.7323E-03_JPRB,5.4756E-03_JPRB,4.1087E-03_JPRB/)
KAO( :, 5, 4, 4) = (/&
&2.6031E-02_JPRB,3.0478E-02_JPRB,3.0373E-02_JPRB,2.8831E-02_JPRB,2.6502E-02_JPRB,2.3472E-02_JPRB,&
&1.9656E-02_JPRB,1.4775E-02_JPRB,9.5721E-03_JPRB,6.1469E-03_JPRB,4.6820E-03_JPRB/)
KAO( :, 1, 5, 4) = (/&
&1.7749E-02_JPRB,1.9809E-02_JPRB,1.9474E-02_JPRB,1.8308E-02_JPRB,1.6656E-02_JPRB,1.4612E-02_JPRB,&
&1.2090E-02_JPRB,8.7523E-03_JPRB,5.4506E-03_JPRB,3.1594E-03_JPRB,2.6009E-03_JPRB/)
KAO( :, 2, 5, 4) = (/&
&1.8962E-02_JPRB,2.1368E-02_JPRB,2.1111E-02_JPRB,1.9856E-02_JPRB,1.8026E-02_JPRB,1.5797E-02_JPRB,&
&1.3087E-02_JPRB,9.5480E-03_JPRB,5.9920E-03_JPRB,3.5465E-03_JPRB,2.9383E-03_JPRB/)
KAO( :, 3, 5, 4) = (/&
&2.0156E-02_JPRB,2.2955E-02_JPRB,2.2766E-02_JPRB,2.1370E-02_JPRB,1.9402E-02_JPRB,1.7036E-02_JPRB,&
&1.4132E-02_JPRB,1.0409E-02_JPRB,6.5849E-03_JPRB,3.9909E-03_JPRB,3.3267E-03_JPRB/)
KAO( :, 4, 5, 4) = (/&
&2.1323E-02_JPRB,2.4554E-02_JPRB,2.4380E-02_JPRB,2.2909E-02_JPRB,2.0850E-02_JPRB,1.8325E-02_JPRB,&
&1.5252E-02_JPRB,1.1317E-02_JPRB,7.2332E-03_JPRB,4.4966E-03_JPRB,3.7667E-03_JPRB/)
KAO( :, 5, 5, 4) = (/&
&2.2499E-02_JPRB,2.6158E-02_JPRB,2.5975E-02_JPRB,2.4497E-02_JPRB,2.2360E-02_JPRB,1.9686E-02_JPRB,&
&1.6421E-02_JPRB,1.2278E-02_JPRB,7.9387E-03_JPRB,5.0610E-03_JPRB,4.2588E-03_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.5007E-02_JPRB,1.6598E-02_JPRB,1.6252E-02_JPRB,1.5296E-02_JPRB,1.3918E-02_JPRB,1.2197E-02_JPRB,&
&1.0070E-02_JPRB,7.1973E-03_JPRB,4.4418E-03_JPRB,2.5632E-03_JPRB,2.6270E-03_JPRB/)
KAO( :, 2, 6, 4) = (/&
&1.6096E-02_JPRB,1.8008E-02_JPRB,1.7715E-02_JPRB,1.6668E-02_JPRB,1.5117E-02_JPRB,1.3217E-02_JPRB,&
&1.0902E-02_JPRB,7.8574E-03_JPRB,4.8940E-03_JPRB,2.8829E-03_JPRB,2.9097E-03_JPRB/)
KAO( :, 3, 6, 4) = (/&
&1.7175E-02_JPRB,1.9434E-02_JPRB,1.9209E-02_JPRB,1.8020E-02_JPRB,1.6319E-02_JPRB,1.4272E-02_JPRB,&
&1.1772E-02_JPRB,8.5712E-03_JPRB,5.3927E-03_JPRB,3.2482E-03_JPRB,3.2462E-03_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.8239E-02_JPRB,2.0847E-02_JPRB,2.0666E-02_JPRB,1.9382E-02_JPRB,1.7575E-02_JPRB,1.5371E-02_JPRB,&
&1.2710E-02_JPRB,9.3314E-03_JPRB,5.9328E-03_JPRB,3.6614E-03_JPRB,3.6324E-03_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.9314E-02_JPRB,2.2274E-02_JPRB,2.2099E-02_JPRB,2.0773E-02_JPRB,1.8871E-02_JPRB,1.6523E-02_JPRB,&
&1.3707E-02_JPRB,1.0147E-02_JPRB,6.5230E-03_JPRB,4.1212E-03_JPRB,4.0664E-03_JPRB/)
KAO( :, 1, 7, 4) = (/&
&1.2562E-02_JPRB,1.3749E-02_JPRB,1.3412E-02_JPRB,1.2652E-02_JPRB,1.1501E-02_JPRB,1.0078E-02_JPRB,&
&8.3008E-03_JPRB,5.8951E-03_JPRB,3.5839E-03_JPRB,2.0640E-03_JPRB,2.8990E-03_JPRB/)
KAO( :, 2, 7, 4) = (/&
&1.3513E-02_JPRB,1.4992E-02_JPRB,1.4706E-02_JPRB,1.3842E-02_JPRB,1.2549E-02_JPRB,1.0956E-02_JPRB,&
&9.0265E-03_JPRB,6.4348E-03_JPRB,3.9618E-03_JPRB,2.3233E-03_JPRB,3.1544E-03_JPRB/)
KAO( :, 3, 7, 4) = (/&
&1.4463E-02_JPRB,1.6248E-02_JPRB,1.6003E-02_JPRB,1.5021E-02_JPRB,1.3588E-02_JPRB,1.1865E-02_JPRB,&
&9.7704E-03_JPRB,7.0232E-03_JPRB,4.3758E-03_JPRB,2.6208E-03_JPRB,3.4308E-03_JPRB/)
KAO( :, 4, 7, 4) = (/&
&1.5412E-02_JPRB,1.7497E-02_JPRB,1.7276E-02_JPRB,1.6194E-02_JPRB,1.4663E-02_JPRB,1.2815E-02_JPRB,&
&1.0574E-02_JPRB,7.6491E-03_JPRB,4.8284E-03_JPRB,2.9535E-03_JPRB,3.7526E-03_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.6381E-02_JPRB,1.8748E-02_JPRB,1.8546E-02_JPRB,1.7402E-02_JPRB,1.5774E-02_JPRB,1.3800E-02_JPRB,&
&1.1415E-02_JPRB,8.3305E-03_JPRB,5.3183E-03_JPRB,3.3227E-03_JPRB,4.1190E-03_JPRB/)
KAO( :, 1, 8, 4) = (/&
&1.0489E-02_JPRB,1.1350E-02_JPRB,1.1041E-02_JPRB,1.0421E-02_JPRB,9.4682E-03_JPRB,8.2685E-03_JPRB,&
&6.7870E-03_JPRB,4.8019E-03_JPRB,2.8904E-03_JPRB,1.6552E-03_JPRB,3.2034E-03_JPRB/)
KAO( :, 2, 8, 4) = (/&
&1.1308E-02_JPRB,1.2427E-02_JPRB,1.2159E-02_JPRB,1.1459E-02_JPRB,1.0373E-02_JPRB,9.0374E-03_JPRB,&
&7.4076E-03_JPRB,5.2450E-03_JPRB,3.1947E-03_JPRB,1.8626E-03_JPRB,3.5949E-03_JPRB/)
KAO( :, 3, 8, 4) = (/&
&1.2133E-02_JPRB,1.3516E-02_JPRB,1.3273E-02_JPRB,1.2475E-02_JPRB,1.1268E-02_JPRB,9.8130E-03_JPRB,&
&8.0528E-03_JPRB,5.7311E-03_JPRB,3.5370E-03_JPRB,2.1011E-03_JPRB,3.9889E-03_JPRB/)
KAO( :, 4, 8, 4) = (/&
&1.2965E-02_JPRB,1.4611E-02_JPRB,1.4368E-02_JPRB,1.3473E-02_JPRB,1.2174E-02_JPRB,1.0625E-02_JPRB,&
&8.7372E-03_JPRB,6.2577E-03_JPRB,3.9075E-03_JPRB,2.3709E-03_JPRB,4.3703E-03_JPRB/)
KAO( :, 5, 8, 4) = (/&
&1.3816E-02_JPRB,1.5699E-02_JPRB,1.5470E-02_JPRB,1.4502E-02_JPRB,1.3123E-02_JPRB,1.1467E-02_JPRB,&
&9.4537E-03_JPRB,6.8298E-03_JPRB,4.3093E-03_JPRB,2.6663E-03_JPRB,4.7512E-03_JPRB/)
KAO( :, 1, 9, 4) = (/&
&8.7568E-03_JPRB,9.3693E-03_JPRB,9.0975E-03_JPRB,8.5800E-03_JPRB,7.7896E-03_JPRB,6.7645E-03_JPRB,&
&5.5285E-03_JPRB,3.9033E-03_JPRB,2.3310E-03_JPRB,1.3217E-03_JPRB,4.5731E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&9.4553E-03_JPRB,1.0293E-02_JPRB,1.0054E-02_JPRB,9.4845E-03_JPRB,8.5715E-03_JPRB,7.4310E-03_JPRB,&
&6.0526E-03_JPRB,4.2651E-03_JPRB,2.5747E-03_JPRB,1.4878E-03_JPRB,5.2597E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.0173E-02_JPRB,1.1238E-02_JPRB,1.1012E-02_JPRB,1.0364E-02_JPRB,9.3410E-03_JPRB,8.0964E-03_JPRB,&
&6.6049E-03_JPRB,4.6620E-03_JPRB,2.8506E-03_JPRB,1.6770E-03_JPRB,5.9814E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&1.0901E-02_JPRB,1.2188E-02_JPRB,1.1952E-02_JPRB,1.1222E-02_JPRB,1.0108E-02_JPRB,8.7846E-03_JPRB,&
&7.1864E-03_JPRB,5.1051E-03_JPRB,3.1528E-03_JPRB,1.8913E-03_JPRB,6.7372E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&1.1643E-02_JPRB,1.3136E-02_JPRB,1.2896E-02_JPRB,1.2091E-02_JPRB,1.0918E-02_JPRB,9.5045E-03_JPRB,&
&7.7923E-03_JPRB,5.5824E-03_JPRB,3.4794E-03_JPRB,2.1303E-03_JPRB,7.5084E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&7.3210E-03_JPRB,7.7682E-03_JPRB,7.5348E-03_JPRB,7.0910E-03_JPRB,6.4276E-03_JPRB,5.5555E-03_JPRB,&
&4.5190E-03_JPRB,3.1874E-03_JPRB,1.8869E-03_JPRB,1.0615E-03_JPRB,8.5089E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&7.9160E-03_JPRB,8.5578E-03_JPRB,8.3513E-03_JPRB,7.8702E-03_JPRB,7.1056E-03_JPRB,6.1307E-03_JPRB,&
&4.9642E-03_JPRB,3.4828E-03_JPRB,2.0800E-03_JPRB,1.1948E-03_JPRB,9.8844E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&8.5286E-03_JPRB,9.3757E-03_JPRB,9.1726E-03_JPRB,8.6301E-03_JPRB,7.7707E-03_JPRB,6.7003E-03_JPRB,&
&5.4292E-03_JPRB,3.8086E-03_JPRB,2.3039E-03_JPRB,1.3482E-03_JPRB,1.1359E-02_JPRB/)
KAO( :, 4,10, 4) = (/&
&9.1631E-03_JPRB,1.0191E-02_JPRB,9.9769E-03_JPRB,9.3788E-03_JPRB,8.4243E-03_JPRB,7.2793E-03_JPRB,&
&5.9222E-03_JPRB,4.1756E-03_JPRB,2.5509E-03_JPRB,1.5190E-03_JPRB,1.2931E-02_JPRB/)
KAO( :, 5,10, 4) = (/&
&9.8113E-03_JPRB,1.1015E-02_JPRB,1.0788E-02_JPRB,1.0124E-02_JPRB,9.1153E-03_JPRB,7.8926E-03_JPRB,&
&6.4363E-03_JPRB,4.5749E-03_JPRB,2.8219E-03_JPRB,1.7121E-03_JPRB,1.4601E-02_JPRB/)
KAO( :, 1,11, 4) = (/&
&6.3238E-03_JPRB,6.7320E-03_JPRB,6.5341E-03_JPRB,6.1432E-03_JPRB,5.5500E-03_JPRB,4.7770E-03_JPRB,&
&3.8625E-03_JPRB,2.7098E-03_JPRB,1.5930E-03_JPRB,8.9971E-04_JPRB,1.0691E-02_JPRB/)
KAO( :, 2,11, 4) = (/&
&6.8377E-03_JPRB,7.4132E-03_JPRB,7.2351E-03_JPRB,6.8044E-03_JPRB,6.1328E-03_JPRB,5.2698E-03_JPRB,&
&4.2482E-03_JPRB,2.9626E-03_JPRB,1.7579E-03_JPRB,1.0147E-03_JPRB,1.2446E-02_JPRB/)
KAO( :, 3,11, 4) = (/&
&7.3680E-03_JPRB,8.1117E-03_JPRB,7.9281E-03_JPRB,7.4556E-03_JPRB,6.7022E-03_JPRB,5.7552E-03_JPRB,&
&4.6507E-03_JPRB,3.2459E-03_JPRB,1.9476E-03_JPRB,1.1453E-03_JPRB,1.4323E-02_JPRB/)
KAO( :, 4,11, 4) = (/&
&7.9250E-03_JPRB,8.8100E-03_JPRB,8.6199E-03_JPRB,8.1042E-03_JPRB,7.2716E-03_JPRB,6.2615E-03_JPRB,&
&5.0763E-03_JPRB,3.5597E-03_JPRB,2.1591E-03_JPRB,1.2891E-03_JPRB,1.6318E-02_JPRB/)
KAO( :, 5,11, 4) = (/&
&8.4995E-03_JPRB,9.5310E-03_JPRB,9.3303E-03_JPRB,8.7684E-03_JPRB,7.8755E-03_JPRB,6.7950E-03_JPRB,&
&5.5255E-03_JPRB,3.9023E-03_JPRB,2.3918E-03_JPRB,1.4517E-03_JPRB,1.8430E-02_JPRB/)
KAO( :, 1,12, 4) = (/&
&5.4239E-03_JPRB,5.7942E-03_JPRB,5.6254E-03_JPRB,5.2775E-03_JPRB,4.7538E-03_JPRB,4.0783E-03_JPRB,&
&3.2815E-03_JPRB,2.2911E-03_JPRB,1.3390E-03_JPRB,7.5901E-04_JPRB,1.1069E-02_JPRB/)
KAO( :, 2,12, 4) = (/&
&5.8650E-03_JPRB,6.3756E-03_JPRB,6.2146E-03_JPRB,5.8301E-03_JPRB,5.2465E-03_JPRB,4.4949E-03_JPRB,&
&3.6123E-03_JPRB,2.5101E-03_JPRB,1.4788E-03_JPRB,8.5773E-04_JPRB,1.2922E-02_JPRB/)
KAO( :, 3,12, 4) = (/&
&6.3326E-03_JPRB,6.9605E-03_JPRB,6.7926E-03_JPRB,6.3822E-03_JPRB,5.7295E-03_JPRB,4.9116E-03_JPRB,&
&3.9590E-03_JPRB,2.7527E-03_JPRB,1.6402E-03_JPRB,9.6785E-04_JPRB,1.4890E-02_JPRB/)
KAO( :, 4,12, 4) = (/&
&6.8197E-03_JPRB,7.5612E-03_JPRB,7.3901E-03_JPRB,6.9407E-03_JPRB,6.2248E-03_JPRB,5.3513E-03_JPRB,&
&4.3255E-03_JPRB,3.0215E-03_JPRB,1.8202E-03_JPRB,1.0893E-03_JPRB,1.6968E-02_JPRB/)
KAO( :, 5,12, 4) = (/&
&7.3239E-03_JPRB,8.1869E-03_JPRB,8.0102E-03_JPRB,7.5305E-03_JPRB,6.7534E-03_JPRB,5.8184E-03_JPRB,&
&4.7200E-03_JPRB,3.3172E-03_JPRB,2.0173E-03_JPRB,1.2265E-03_JPRB,1.9174E-02_JPRB/)
KAO( :, 1,13, 4) = (/&
&4.6050E-03_JPRB,4.9342E-03_JPRB,4.7817E-03_JPRB,4.4662E-03_JPRB,4.0147E-03_JPRB,3.4350E-03_JPRB,&
&2.7500E-03_JPRB,1.9135E-03_JPRB,1.1150E-03_JPRB,6.3435E-04_JPRB,9.6482E-03_JPRB/)
KAO( :, 2,13, 4) = (/&
&4.9867E-03_JPRB,5.4199E-03_JPRB,5.2643E-03_JPRB,4.9240E-03_JPRB,4.4219E-03_JPRB,3.7782E-03_JPRB,&
&3.0269E-03_JPRB,2.1006E-03_JPRB,1.2335E-03_JPRB,7.1745E-04_JPRB,1.1271E-02_JPRB/)
KAO( :, 3,13, 4) = (/&
&5.3971E-03_JPRB,5.9114E-03_JPRB,5.7510E-03_JPRB,5.3855E-03_JPRB,4.8287E-03_JPRB,4.1310E-03_JPRB,&
&3.3205E-03_JPRB,2.3075E-03_JPRB,1.3695E-03_JPRB,8.0946E-04_JPRB,1.2985E-02_JPRB/)
KAO( :, 4,13, 4) = (/&
&5.8203E-03_JPRB,6.4262E-03_JPRB,6.2609E-03_JPRB,5.8661E-03_JPRB,5.2552E-03_JPRB,4.5068E-03_JPRB,&
&3.6338E-03_JPRB,2.5380E-03_JPRB,1.5209E-03_JPRB,9.1160E-04_JPRB,1.4785E-02_JPRB/)
KAO( :, 5,13, 4) = (/&
&6.2608E-03_JPRB,6.9642E-03_JPRB,6.7991E-03_JPRB,6.3791E-03_JPRB,5.7139E-03_JPRB,4.9101E-03_JPRB,&
&3.9752E-03_JPRB,2.7918E-03_JPRB,1.6870E-03_JPRB,1.0277E-03_JPRB,1.6692E-02_JPRB/)
KAO( :, 1, 1, 5) = (/&
&6.9423E-02_JPRB,7.4960E-02_JPRB,7.2881E-02_JPRB,6.7852E-02_JPRB,6.0804E-02_JPRB,5.2531E-02_JPRB,&
&4.2824E-02_JPRB,3.0610E-02_JPRB,1.9045E-02_JPRB,1.1972E-02_JPRB,9.0656E-03_JPRB/)
KAO( :, 2, 1, 5) = (/&
&7.1301E-02_JPRB,7.7925E-02_JPRB,7.6064E-02_JPRB,7.1198E-02_JPRB,6.4170E-02_JPRB,5.6008E-02_JPRB,&
&4.6002E-02_JPRB,3.3219E-02_JPRB,2.0898E-02_JPRB,1.3541E-02_JPRB,1.0844E-02_JPRB/)
KAO( :, 3, 1, 5) = (/&
&7.2960E-02_JPRB,8.0744E-02_JPRB,7.9397E-02_JPRB,7.4686E-02_JPRB,6.7915E-02_JPRB,5.9615E-02_JPRB,&
&4.9205E-02_JPRB,3.5928E-02_JPRB,2.2906E-02_JPRB,1.5284E-02_JPRB,1.2853E-02_JPRB/)
KAO( :, 4, 1, 5) = (/&
&7.4482E-02_JPRB,8.3568E-02_JPRB,8.2751E-02_JPRB,7.8370E-02_JPRB,7.1840E-02_JPRB,6.3241E-02_JPRB,&
&5.2611E-02_JPRB,3.8800E-02_JPRB,2.5071E-02_JPRB,1.7190E-02_JPRB,1.5078E-02_JPRB/)
KAO( :, 5, 1, 5) = (/&
&7.5977E-02_JPRB,8.6416E-02_JPRB,8.6132E-02_JPRB,8.2229E-02_JPRB,7.5721E-02_JPRB,6.7015E-02_JPRB,&
&5.6188E-02_JPRB,4.1791E-02_JPRB,2.7379E-02_JPRB,1.9319E-02_JPRB,1.7544E-02_JPRB/)
KAO( :, 1, 2, 5) = (/&
&6.1428E-02_JPRB,6.6243E-02_JPRB,6.4016E-02_JPRB,5.9686E-02_JPRB,5.3408E-02_JPRB,4.5905E-02_JPRB,&
&3.7325E-02_JPRB,2.6638E-02_JPRB,1.6539E-02_JPRB,1.0261E-02_JPRB,7.2943E-03_JPRB/)
KAO( :, 2, 2, 5) = (/&
&6.3157E-02_JPRB,6.8963E-02_JPRB,6.7035E-02_JPRB,6.2877E-02_JPRB,5.6628E-02_JPRB,4.9107E-02_JPRB,&
&4.0147E-02_JPRB,2.8970E-02_JPRB,1.8198E-02_JPRB,1.1562E-02_JPRB,8.6747E-03_JPRB/)
KAO( :, 3, 2, 5) = (/&
&6.4729E-02_JPRB,7.1653E-02_JPRB,7.0183E-02_JPRB,6.6237E-02_JPRB,6.0087E-02_JPRB,5.2347E-02_JPRB,&
&4.3083E-02_JPRB,3.1429E-02_JPRB,1.9978E-02_JPRB,1.2998E-02_JPRB,1.0260E-02_JPRB/)
KAO( :, 4, 2, 5) = (/&
&6.6252E-02_JPRB,7.4355E-02_JPRB,7.3321E-02_JPRB,6.9741E-02_JPRB,6.3553E-02_JPRB,5.5697E-02_JPRB,&
&4.6228E-02_JPRB,3.4024E-02_JPRB,2.1871E-02_JPRB,1.4556E-02_JPRB,1.2034E-02_JPRB/)
KAO( :, 5, 2, 5) = (/&
&6.7782E-02_JPRB,7.7009E-02_JPRB,7.6503E-02_JPRB,7.3173E-02_JPRB,6.7016E-02_JPRB,5.9180E-02_JPRB,&
&4.9505E-02_JPRB,3.6707E-02_JPRB,2.3887E-02_JPRB,1.6290E-02_JPRB,1.4004E-02_JPRB/)
KAO( :, 1, 3, 5) = (/&
&5.3533E-02_JPRB,5.7434E-02_JPRB,5.5277E-02_JPRB,5.1527E-02_JPRB,4.6035E-02_JPRB,3.9352E-02_JPRB,&
&3.1746E-02_JPRB,2.2523E-02_JPRB,1.3908E-02_JPRB,8.6490E-03_JPRB,5.9287E-03_JPRB/)
KAO( :, 2, 3, 5) = (/&
&5.5137E-02_JPRB,5.9969E-02_JPRB,5.8097E-02_JPRB,5.4502E-02_JPRB,4.8980E-02_JPRB,4.2173E-02_JPRB,&
&3.4244E-02_JPRB,2.4566E-02_JPRB,1.5350E-02_JPRB,9.6962E-03_JPRB,6.9493E-03_JPRB/)
KAO( :, 3, 3, 5) = (/&
&5.6675E-02_JPRB,6.2431E-02_JPRB,6.0975E-02_JPRB,5.7589E-02_JPRB,5.2056E-02_JPRB,4.5047E-02_JPRB,&
&3.6855E-02_JPRB,2.6729E-02_JPRB,1.6909E-02_JPRB,1.0855E-02_JPRB,8.1206E-03_JPRB/)
KAO( :, 4, 3, 5) = (/&
&5.8200E-02_JPRB,6.4923E-02_JPRB,6.3882E-02_JPRB,6.0753E-02_JPRB,5.5077E-02_JPRB,4.8037E-02_JPRB,&
&3.9643E-02_JPRB,2.9018E-02_JPRB,1.8575E-02_JPRB,1.2121E-02_JPRB,9.4750E-03_JPRB/)
KAO( :, 5, 3, 5) = (/&
&5.9733E-02_JPRB,6.7416E-02_JPRB,6.6842E-02_JPRB,6.3776E-02_JPRB,5.8159E-02_JPRB,5.1164E-02_JPRB,&
&4.2585E-02_JPRB,3.1380E-02_JPRB,2.0348E-02_JPRB,1.3514E-02_JPRB,1.0998E-02_JPRB/)
KAO( :, 1, 4, 5) = (/&
&4.6353E-02_JPRB,4.9264E-02_JPRB,4.7316E-02_JPRB,4.4016E-02_JPRB,3.9303E-02_JPRB,3.3446E-02_JPRB,&
&2.6720E-02_JPRB,1.8817E-02_JPRB,1.1541E-02_JPRB,7.2722E-03_JPRB,5.4712E-03_JPRB/)
KAO( :, 2, 4, 5) = (/&
&4.7832E-02_JPRB,5.1575E-02_JPRB,4.9905E-02_JPRB,4.6721E-02_JPRB,4.1940E-02_JPRB,3.5924E-02_JPRB,&
&2.8909E-02_JPRB,2.0563E-02_JPRB,1.2756E-02_JPRB,8.1360E-03_JPRB,6.2894E-03_JPRB/)
KAO( :, 3, 4, 5) = (/&
&4.9292E-02_JPRB,5.3845E-02_JPRB,5.2477E-02_JPRB,4.9511E-02_JPRB,4.4682E-02_JPRB,3.8438E-02_JPRB,&
&3.1206E-02_JPRB,2.2430E-02_JPRB,1.4083E-02_JPRB,9.0822E-03_JPRB,7.2079E-03_JPRB/)
KAO( :, 4, 4, 5) = (/&
&5.0753E-02_JPRB,5.6167E-02_JPRB,5.5096E-02_JPRB,5.2291E-02_JPRB,4.7354E-02_JPRB,4.1051E-02_JPRB,&
&3.3627E-02_JPRB,2.4418E-02_JPRB,1.5508E-02_JPRB,1.0111E-02_JPRB,8.2258E-03_JPRB/)
KAO( :, 5, 4, 5) = (/&
&5.2237E-02_JPRB,5.8453E-02_JPRB,5.7807E-02_JPRB,5.4969E-02_JPRB,5.0043E-02_JPRB,4.3750E-02_JPRB,&
&3.6221E-02_JPRB,2.6492E-02_JPRB,1.7044E-02_JPRB,1.1243E-02_JPRB,9.3585E-03_JPRB/)
KAO( :, 1, 5, 5) = (/&
&4.0215E-02_JPRB,4.2178E-02_JPRB,4.0345E-02_JPRB,3.7366E-02_JPRB,3.3354E-02_JPRB,2.8283E-02_JPRB,&
&2.2446E-02_JPRB,1.5692E-02_JPRB,9.5378E-03_JPRB,6.0574E-03_JPRB,5.0927E-03_JPRB/)
KAO( :, 2, 5, 5) = (/&
&4.1564E-02_JPRB,4.4223E-02_JPRB,4.2656E-02_JPRB,3.9744E-02_JPRB,3.5712E-02_JPRB,3.0486E-02_JPRB,&
&2.4325E-02_JPRB,1.7173E-02_JPRB,1.0563E-02_JPRB,6.7992E-03_JPRB,5.7848E-03_JPRB/)
KAO( :, 3, 5, 5) = (/&
&4.2880E-02_JPRB,4.6295E-02_JPRB,4.4929E-02_JPRB,4.2198E-02_JPRB,3.8104E-02_JPRB,3.2711E-02_JPRB,&
&2.6325E-02_JPRB,1.8758E-02_JPRB,1.1674E-02_JPRB,7.6073E-03_JPRB,6.5722E-03_JPRB/)
KAO( :, 4, 5, 5) = (/&
&4.4250E-02_JPRB,4.8374E-02_JPRB,4.7253E-02_JPRB,4.4669E-02_JPRB,4.0477E-02_JPRB,3.4961E-02_JPRB,&
&2.8432E-02_JPRB,2.0449E-02_JPRB,1.2880E-02_JPRB,8.4762E-03_JPRB,7.4570E-03_JPRB/)
KAO( :, 5, 5, 5) = (/&
&4.5632E-02_JPRB,5.0457E-02_JPRB,4.9661E-02_JPRB,4.7073E-02_JPRB,4.2857E-02_JPRB,3.7281E-02_JPRB,&
&3.0645E-02_JPRB,2.2241E-02_JPRB,1.4179E-02_JPRB,9.4224E-03_JPRB,8.4289E-03_JPRB/)
KAO( :, 1, 6, 5) = (/&
&3.4853E-02_JPRB,3.6094E-02_JPRB,3.4340E-02_JPRB,3.1567E-02_JPRB,2.8074E-02_JPRB,2.3747E-02_JPRB,&
&1.8747E-02_JPRB,1.3033E-02_JPRB,7.8344E-03_JPRB,4.9564E-03_JPRB,4.7664E-03_JPRB/)
KAO( :, 2, 6, 5) = (/&
&3.6095E-02_JPRB,3.7902E-02_JPRB,3.6360E-02_JPRB,3.3627E-02_JPRB,3.0131E-02_JPRB,2.5638E-02_JPRB,&
&2.0371E-02_JPRB,1.4275E-02_JPRB,8.6972E-03_JPRB,5.5735E-03_JPRB,5.3896E-03_JPRB/)
KAO( :, 3, 6, 5) = (/&
&3.7297E-02_JPRB,3.9745E-02_JPRB,3.8353E-02_JPRB,3.5764E-02_JPRB,3.2219E-02_JPRB,2.7550E-02_JPRB,&
&2.2085E-02_JPRB,1.5615E-02_JPRB,9.6284E-03_JPRB,6.2556E-03_JPRB,6.0790E-03_JPRB/)
KAO( :, 4, 6, 5) = (/&
&3.8557E-02_JPRB,4.1597E-02_JPRB,4.0389E-02_JPRB,3.7908E-02_JPRB,3.4281E-02_JPRB,2.9507E-02_JPRB,&
&2.3870E-02_JPRB,1.7046E-02_JPRB,1.0643E-02_JPRB,7.0034E-03_JPRB,6.8484E-03_JPRB/)
KAO( :, 5, 6, 5) = (/&
&3.9824E-02_JPRB,4.3464E-02_JPRB,4.2478E-02_JPRB,4.0047E-02_JPRB,3.6382E-02_JPRB,3.1522E-02_JPRB,&
&2.5736E-02_JPRB,1.8573E-02_JPRB,1.1739E-02_JPRB,7.8250E-03_JPRB,7.7029E-03_JPRB/)
KAO( :, 1, 7, 5) = (/&
&2.9815E-02_JPRB,3.0608E-02_JPRB,2.8988E-02_JPRB,2.6483E-02_JPRB,2.3444E-02_JPRB,1.9806E-02_JPRB,&
&1.5587E-02_JPRB,1.0729E-02_JPRB,6.3834E-03_JPRB,3.9988E-03_JPRB,4.7710E-03_JPRB/)
KAO( :, 2, 7, 5) = (/&
&3.0946E-02_JPRB,3.2211E-02_JPRB,3.0727E-02_JPRB,2.8262E-02_JPRB,2.5215E-02_JPRB,2.1406E-02_JPRB,&
&1.6940E-02_JPRB,1.1789E-02_JPRB,7.0925E-03_JPRB,4.5059E-03_JPRB,5.3365E-03_JPRB/)
KAO( :, 3, 7, 5) = (/&
&3.2060E-02_JPRB,3.3823E-02_JPRB,3.2464E-02_JPRB,3.0099E-02_JPRB,2.7004E-02_JPRB,2.3026E-02_JPRB,&
&1.8369E-02_JPRB,1.2921E-02_JPRB,7.8758E-03_JPRB,5.0685E-03_JPRB,5.9857E-03_JPRB/)
KAO( :, 4, 7, 5) = (/&
&3.3198E-02_JPRB,3.5483E-02_JPRB,3.4283E-02_JPRB,3.1964E-02_JPRB,2.8781E-02_JPRB,2.4689E-02_JPRB,&
&1.9856E-02_JPRB,1.4137E-02_JPRB,8.7260E-03_JPRB,5.6932E-03_JPRB,6.6962E-03_JPRB/)
KAO( :, 5, 7, 5) = (/&
&3.4342E-02_JPRB,3.7144E-02_JPRB,3.6117E-02_JPRB,3.3825E-02_JPRB,3.0620E-02_JPRB,2.6411E-02_JPRB,&
&2.1416E-02_JPRB,1.5421E-02_JPRB,9.6443E-03_JPRB,6.3905E-03_JPRB,7.4882E-03_JPRB/)
KAO( :, 1, 8, 5) = (/&
&2.5283E-02_JPRB,2.5751E-02_JPRB,2.4270E-02_JPRB,2.2079E-02_JPRB,1.9496E-02_JPRB,1.6496E-02_JPRB,&
&1.2947E-02_JPRB,8.8078E-03_JPRB,5.1661E-03_JPRB,3.1956E-03_JPRB,5.6775E-03_JPRB/)
KAO( :, 2, 8, 5) = (/&
&2.6302E-02_JPRB,2.7180E-02_JPRB,2.5781E-02_JPRB,2.3615E-02_JPRB,2.1015E-02_JPRB,1.7843E-02_JPRB,&
&1.4097E-02_JPRB,9.7060E-03_JPRB,5.7494E-03_JPRB,3.6083E-03_JPRB,6.1622E-03_JPRB/)
KAO( :, 3, 8, 5) = (/&
&2.7320E-02_JPRB,2.8593E-02_JPRB,2.7305E-02_JPRB,2.5195E-02_JPRB,2.2546E-02_JPRB,1.9223E-02_JPRB,&
&1.5282E-02_JPRB,1.0665E-02_JPRB,6.3913E-03_JPRB,4.0728E-03_JPRB,6.7057E-03_JPRB/)
KAO( :, 4, 8, 5) = (/&
&2.8333E-02_JPRB,3.0041E-02_JPRB,2.8915E-02_JPRB,2.6829E-02_JPRB,2.4088E-02_JPRB,2.0635E-02_JPRB,&
&1.6522E-02_JPRB,1.1685E-02_JPRB,7.1066E-03_JPRB,4.5896E-03_JPRB,7.3455E-03_JPRB/)
KAO( :, 5, 8, 5) = (/&
&2.9349E-02_JPRB,3.1526E-02_JPRB,3.0540E-02_JPRB,2.8464E-02_JPRB,2.5707E-02_JPRB,2.2109E-02_JPRB,&
&1.7816E-02_JPRB,1.2753E-02_JPRB,7.8746E-03_JPRB,5.1734E-03_JPRB,8.0746E-03_JPRB/)
KAO( :, 1, 9, 5) = (/&
&2.1393E-02_JPRB,2.1598E-02_JPRB,2.0242E-02_JPRB,1.8370E-02_JPRB,1.6186E-02_JPRB,1.3706E-02_JPRB,&
&1.0722E-02_JPRB,7.2195E-03_JPRB,4.1746E-03_JPRB,2.5439E-03_JPRB,1.0113E-02_JPRB/)
KAO( :, 2, 9, 5) = (/&
&2.2301E-02_JPRB,2.2863E-02_JPRB,2.1562E-02_JPRB,1.9670E-02_JPRB,1.7466E-02_JPRB,1.4848E-02_JPRB,&
&1.1705E-02_JPRB,7.9781E-03_JPRB,4.6436E-03_JPRB,2.8718E-03_JPRB,1.1342E-02_JPRB/)
KAO( :, 3, 9, 5) = (/&
&2.3221E-02_JPRB,2.4089E-02_JPRB,2.2883E-02_JPRB,2.1022E-02_JPRB,1.8774E-02_JPRB,1.6030E-02_JPRB,&
&1.2717E-02_JPRB,8.7854E-03_JPRB,5.1730E-03_JPRB,3.2515E-03_JPRB,1.2507E-02_JPRB/)
KAO( :, 4, 9, 5) = (/&
&2.4120E-02_JPRB,2.5343E-02_JPRB,2.4280E-02_JPRB,2.2425E-02_JPRB,2.0119E-02_JPRB,1.7244E-02_JPRB,&
&1.3767E-02_JPRB,9.6361E-03_JPRB,5.7611E-03_JPRB,3.6765E-03_JPRB,1.3554E-02_JPRB/)
KAO( :, 5, 9, 5) = (/&
&2.5016E-02_JPRB,2.6638E-02_JPRB,2.5702E-02_JPRB,2.3865E-02_JPRB,2.1516E-02_JPRB,1.8508E-02_JPRB,&
&1.4864E-02_JPRB,1.0529E-02_JPRB,6.4045E-03_JPRB,4.1546E-03_JPRB,1.4572E-02_JPRB/)
KAO( :, 1,10, 5) = (/&
&1.8113E-02_JPRB,1.8138E-02_JPRB,1.6915E-02_JPRB,1.5326E-02_JPRB,1.3493E-02_JPRB,1.1404E-02_JPRB,&
&8.8894E-03_JPRB,5.9161E-03_JPRB,3.3974E-03_JPRB,2.0400E-03_JPRB,2.3155E-02_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.8911E-02_JPRB,1.9233E-02_JPRB,1.8049E-02_JPRB,1.6433E-02_JPRB,1.4556E-02_JPRB,1.2371E-02_JPRB,&
&9.7152E-03_JPRB,6.5645E-03_JPRB,3.7859E-03_JPRB,2.2984E-03_JPRB,2.6502E-02_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.9728E-02_JPRB,2.0295E-02_JPRB,1.9188E-02_JPRB,1.7578E-02_JPRB,1.5660E-02_JPRB,1.3378E-02_JPRB,&
&1.0586E-02_JPRB,7.2492E-03_JPRB,4.2176E-03_JPRB,2.6036E-03_JPRB,2.9732E-02_JPRB/)
KAO( :, 4,10, 5) = (/&
&2.0511E-02_JPRB,2.1373E-02_JPRB,2.0386E-02_JPRB,1.8762E-02_JPRB,1.6821E-02_JPRB,1.4424E-02_JPRB,&
&1.1488E-02_JPRB,7.9631E-03_JPRB,4.7001E-03_JPRB,2.9535E-03_JPRB,3.2827E-02_JPRB/)
KAO( :, 5,10, 5) = (/&
&2.1304E-02_JPRB,2.2491E-02_JPRB,2.1602E-02_JPRB,2.0004E-02_JPRB,1.8011E-02_JPRB,1.5518E-02_JPRB,&
&1.2440E-02_JPRB,8.7186E-03_JPRB,5.2306E-03_JPRB,3.3445E-03_JPRB,3.5819E-02_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.5695E-02_JPRB,1.5702E-02_JPRB,1.4638E-02_JPRB,1.3267E-02_JPRB,1.1679E-02_JPRB,9.8503E-03_JPRB,&
&7.6677E-03_JPRB,5.0761E-03_JPRB,2.9053E-03_JPRB,1.7228E-03_JPRB,2.9993E-02_JPRB/)
KAO( :, 2,11, 5) = (/&
&1.6401E-02_JPRB,1.6637E-02_JPRB,1.5599E-02_JPRB,1.4214E-02_JPRB,1.2583E-02_JPRB,1.0686E-02_JPRB,&
&8.3766E-03_JPRB,5.6416E-03_JPRB,3.2428E-03_JPRB,1.9419E-03_JPRB,3.4197E-02_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.7106E-02_JPRB,1.7559E-02_JPRB,1.6602E-02_JPRB,1.5204E-02_JPRB,1.3537E-02_JPRB,1.1563E-02_JPRB,&
&9.1295E-03_JPRB,6.2308E-03_JPRB,3.6142E-03_JPRB,2.2018E-03_JPRB,3.8237E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.7783E-02_JPRB,1.8504E-02_JPRB,1.7628E-02_JPRB,1.6229E-02_JPRB,1.4542E-02_JPRB,1.2483E-02_JPRB,&
&9.9207E-03_JPRB,6.8466E-03_JPRB,4.0263E-03_JPRB,2.5043E-03_JPRB,4.2149E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&1.8493E-02_JPRB,1.9485E-02_JPRB,1.8676E-02_JPRB,1.7295E-02_JPRB,1.5575E-02_JPRB,1.3438E-02_JPRB,&
&1.0754E-02_JPRB,7.5058E-03_JPRB,4.4801E-03_JPRB,2.8413E-03_JPRB,4.5923E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&1.3506E-02_JPRB,1.3529E-02_JPRB,1.2628E-02_JPRB,1.1452E-02_JPRB,1.0063E-02_JPRB,8.4685E-03_JPRB,&
&6.5828E-03_JPRB,4.3370E-03_JPRB,2.4676E-03_JPRB,1.4501E-03_JPRB,3.1379E-02_JPRB/)
KAO( :, 2,12, 5) = (/&
&1.4125E-02_JPRB,1.4325E-02_JPRB,1.3451E-02_JPRB,1.2271E-02_JPRB,1.0846E-02_JPRB,9.1944E-03_JPRB,&
&7.1930E-03_JPRB,4.8218E-03_JPRB,2.7588E-03_JPRB,1.6351E-03_JPRB,3.5598E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.4721E-02_JPRB,1.5127E-02_JPRB,1.4318E-02_JPRB,1.3125E-02_JPRB,1.1678E-02_JPRB,9.9571E-03_JPRB,&
&7.8415E-03_JPRB,5.3248E-03_JPRB,3.0763E-03_JPRB,1.8570E-03_JPRB,3.9752E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.5317E-02_JPRB,1.5950E-02_JPRB,1.5202E-02_JPRB,1.4009E-02_JPRB,1.2540E-02_JPRB,1.0752E-02_JPRB,&
&8.5246E-03_JPRB,5.8565E-03_JPRB,3.4251E-03_JPRB,2.1158E-03_JPRB,4.3744E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.5969E-02_JPRB,1.6812E-02_JPRB,1.6124E-02_JPRB,1.4932E-02_JPRB,1.3442E-02_JPRB,1.1579E-02_JPRB,&
&9.2378E-03_JPRB,6.4203E-03_JPRB,3.8147E-03_JPRB,2.4036E-03_JPRB,4.7604E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&1.1399E-02_JPRB,1.1449E-02_JPRB,1.0710E-02_JPRB,9.7174E-03_JPRB,8.5323E-03_JPRB,7.1730E-03_JPRB,&
&5.5827E-03_JPRB,3.6682E-03_JPRB,2.0730E-03_JPRB,1.2124E-03_JPRB,2.7163E-02_JPRB/)
KAO( :, 2,13, 5) = (/&
&1.1916E-02_JPRB,1.2118E-02_JPRB,1.1410E-02_JPRB,1.0424E-02_JPRB,9.2099E-03_JPRB,7.8054E-03_JPRB,&
&6.1073E-03_JPRB,4.0757E-03_JPRB,2.3191E-03_JPRB,1.3693E-03_JPRB,3.0692E-02_JPRB/)
KAO( :, 3,13, 5) = (/&
&1.2413E-02_JPRB,1.2810E-02_JPRB,1.2156E-02_JPRB,1.1166E-02_JPRB,9.9300E-03_JPRB,8.4666E-03_JPRB,&
&6.6637E-03_JPRB,4.5036E-03_JPRB,2.5869E-03_JPRB,1.5580E-03_JPRB,3.4158E-02_JPRB/)
KAO( :, 4,13, 5) = (/&
&1.2945E-02_JPRB,1.3524E-02_JPRB,1.2930E-02_JPRB,1.1934E-02_JPRB,1.0680E-02_JPRB,9.1538E-03_JPRB,&
&7.2492E-03_JPRB,4.9532E-03_JPRB,2.8844E-03_JPRB,1.7769E-03_JPRB,3.7486E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&1.3534E-02_JPRB,1.4296E-02_JPRB,1.3748E-02_JPRB,1.2750E-02_JPRB,1.1472E-02_JPRB,9.8678E-03_JPRB,&
&7.8555E-03_JPRB,5.4258E-03_JPRB,3.2161E-03_JPRB,2.0203E-03_JPRB,4.0660E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&1.3812E-01_JPRB,1.3826E-01_JPRB,1.3412E-01_JPRB,1.2512E-01_JPRB,1.1224E-01_JPRB,9.5217E-02_JPRB,&
&7.4976E-02_JPRB,5.1336E-02_JPRB,3.0614E-02_JPRB,2.1696E-02_JPRB,2.0374E-02_JPRB/)
KAO( :, 2, 1, 6) = (/&
&1.3941E-01_JPRB,1.4212E-01_JPRB,1.3899E-01_JPRB,1.3015E-01_JPRB,1.1723E-01_JPRB,9.9705E-02_JPRB,&
&7.9423E-02_JPRB,5.5251E-02_JPRB,3.3932E-02_JPRB,2.4851E-02_JPRB,2.3928E-02_JPRB/)
KAO( :, 3, 1, 6) = (/&
&1.4069E-01_JPRB,1.4606E-01_JPRB,1.4349E-01_JPRB,1.3492E-01_JPRB,1.2182E-01_JPRB,1.0431E-01_JPRB,&
&8.4373E-02_JPRB,5.9330E-02_JPRB,3.7520E-02_JPRB,2.8503E-02_JPRB,2.7981E-02_JPRB/)
KAO( :, 4, 1, 6) = (/&
&1.4204E-01_JPRB,1.4980E-01_JPRB,1.4773E-01_JPRB,1.3955E-01_JPRB,1.2635E-01_JPRB,1.0953E-01_JPRB,&
&8.9320E-02_JPRB,6.3663E-02_JPRB,4.1464E-02_JPRB,3.2709E-02_JPRB,3.2519E-02_JPRB/)
KAO( :, 5, 1, 6) = (/&
&1.4335E-01_JPRB,1.5332E-01_JPRB,1.5190E-01_JPRB,1.4393E-01_JPRB,1.3131E-01_JPRB,1.1498E-01_JPRB,&
&9.4231E-02_JPRB,6.8373E-02_JPRB,4.5718E-02_JPRB,3.7379E-02_JPRB,3.7561E-02_JPRB/)
KAO( :, 1, 2, 6) = (/&
&1.2540E-01_JPRB,1.2569E-01_JPRB,1.2163E-01_JPRB,1.1284E-01_JPRB,1.0119E-01_JPRB,8.6267E-02_JPRB,&
&6.7814E-02_JPRB,4.6281E-02_JPRB,2.7026E-02_JPRB,1.8209E-02_JPRB,1.6155E-02_JPRB/)
KAO( :, 2, 2, 6) = (/&
&1.2690E-01_JPRB,1.2947E-01_JPRB,1.2609E-01_JPRB,1.1758E-01_JPRB,1.0596E-01_JPRB,9.0648E-02_JPRB,&
&7.2085E-02_JPRB,4.9891E-02_JPRB,2.9876E-02_JPRB,2.0766E-02_JPRB,1.9045E-02_JPRB/)
KAO( :, 3, 2, 6) = (/&
&1.2845E-01_JPRB,1.3318E-01_JPRB,1.3033E-01_JPRB,1.2211E-01_JPRB,1.1052E-01_JPRB,9.5256E-02_JPRB,&
&7.6664E-02_JPRB,5.3627E-02_JPRB,3.2984E-02_JPRB,2.3750E-02_JPRB,2.2338E-02_JPRB/)
KAO( :, 4, 2, 6) = (/&
&1.2994E-01_JPRB,1.3679E-01_JPRB,1.3454E-01_JPRB,1.2649E-01_JPRB,1.1513E-01_JPRB,1.0018E-01_JPRB,&
&8.1132E-02_JPRB,5.7623E-02_JPRB,3.6417E-02_JPRB,2.7177E-02_JPRB,2.6047E-02_JPRB/)
KAO( :, 5, 2, 6) = (/&
&1.3135E-01_JPRB,1.4032E-01_JPRB,1.3874E-01_JPRB,1.3096E-01_JPRB,1.2020E-01_JPRB,1.0521E-01_JPRB,&
&8.5803E-02_JPRB,6.1991E-02_JPRB,4.0111E-02_JPRB,3.0993E-02_JPRB,3.0183E-02_JPRB/)
KAO( :, 1, 3, 6) = (/&
&1.1249E-01_JPRB,1.1241E-01_JPRB,1.0797E-01_JPRB,9.9582E-02_JPRB,8.8991E-02_JPRB,7.6122E-02_JPRB,&
&5.9776E-02_JPRB,4.0423E-02_JPRB,2.3381E-02_JPRB,1.4989E-02_JPRB,1.2392E-02_JPRB/)
KAO( :, 2, 3, 6) = (/&
&1.1410E-01_JPRB,1.1606E-01_JPRB,1.1205E-01_JPRB,1.0392E-01_JPRB,9.3538E-02_JPRB,8.0374E-02_JPRB,&
&6.3755E-02_JPRB,4.3750E-02_JPRB,2.5848E-02_JPRB,1.7065E-02_JPRB,1.4647E-02_JPRB/)
KAO( :, 3, 3, 6) = (/&
&1.1569E-01_JPRB,1.1965E-01_JPRB,1.1613E-01_JPRB,1.0831E-01_JPRB,9.7905E-02_JPRB,8.4765E-02_JPRB,&
&6.7839E-02_JPRB,4.7191E-02_JPRB,2.8514E-02_JPRB,1.9425E-02_JPRB,1.7233E-02_JPRB/)
KAO( :, 4, 3, 6) = (/&
&1.1726E-01_JPRB,1.2309E-01_JPRB,1.2032E-01_JPRB,1.1259E-01_JPRB,1.0247E-01_JPRB,8.9387E-02_JPRB,&
&7.1928E-02_JPRB,5.0787E-02_JPRB,3.1455E-02_JPRB,2.2128E-02_JPRB,2.0137E-02_JPRB/)
KAO( :, 5, 3, 6) = (/&
&1.1874E-01_JPRB,1.2658E-01_JPRB,1.2440E-01_JPRB,1.1705E-01_JPRB,1.0739E-01_JPRB,9.3857E-02_JPRB,&
&7.6244E-02_JPRB,5.4771E-02_JPRB,3.4624E-02_JPRB,2.5158E-02_JPRB,2.3398E-02_JPRB/)
KAO( :, 1, 4, 6) = (/&
&1.0010E-01_JPRB,9.9685E-02_JPRB,9.4787E-02_JPRB,8.6882E-02_JPRB,7.7198E-02_JPRB,6.5934E-02_JPRB,&
&5.1807E-02_JPRB,3.4736E-02_JPRB,1.9980E-02_JPRB,1.2335E-02_JPRB,1.0141E-02_JPRB/)
KAO( :, 2, 4, 6) = (/&
&1.0170E-01_JPRB,1.0312E-01_JPRB,9.8622E-02_JPRB,9.0905E-02_JPRB,8.1426E-02_JPRB,6.9900E-02_JPRB,&
&5.5494E-02_JPRB,3.7661E-02_JPRB,2.2134E-02_JPRB,1.4013E-02_JPRB,1.1758E-02_JPRB/)
KAO( :, 3, 4, 6) = (/&
&1.0335E-01_JPRB,1.0651E-01_JPRB,1.0245E-01_JPRB,9.5068E-02_JPRB,8.5570E-02_JPRB,7.4056E-02_JPRB,&
&5.9162E-02_JPRB,4.0698E-02_JPRB,2.4492E-02_JPRB,1.5920E-02_JPRB,1.3637E-02_JPRB/)
KAO( :, 4, 4, 6) = (/&
&1.0499E-01_JPRB,1.0979E-01_JPRB,1.0642E-01_JPRB,9.9223E-02_JPRB,8.9977E-02_JPRB,7.8273E-02_JPRB,&
&6.2815E-02_JPRB,4.3991E-02_JPRB,2.7037E-02_JPRB,1.8072E-02_JPRB,1.5828E-02_JPRB/)
KAO( :, 5, 4, 6) = (/&
&1.0648E-01_JPRB,1.1320E-01_JPRB,1.1032E-01_JPRB,1.0355E-01_JPRB,9.4621E-02_JPRB,8.2442E-02_JPRB,&
&6.6678E-02_JPRB,4.7586E-02_JPRB,2.9766E-02_JPRB,2.0476E-02_JPRB,1.8322E-02_JPRB/)
KAO( :, 1, 5, 6) = (/&
&8.8646E-02_JPRB,8.7933E-02_JPRB,8.2832E-02_JPRB,7.5476E-02_JPRB,6.6640E-02_JPRB,5.6566E-02_JPRB,&
&4.4409E-02_JPRB,2.9574E-02_JPRB,1.6904E-02_JPRB,1.0272E-02_JPRB,9.1351E-03_JPRB/)
KAO( :, 2, 5, 6) = (/&
&9.0277E-02_JPRB,9.1081E-02_JPRB,8.6318E-02_JPRB,7.9229E-02_JPRB,7.0495E-02_JPRB,6.0192E-02_JPRB,&
&4.7724E-02_JPRB,3.2103E-02_JPRB,1.8750E-02_JPRB,1.1641E-02_JPRB,1.0542E-02_JPRB/)
KAO( :, 3, 5, 6) = (/&
&9.1984E-02_JPRB,9.4263E-02_JPRB,8.9928E-02_JPRB,8.3093E-02_JPRB,7.4368E-02_JPRB,6.3999E-02_JPRB,&
&5.1030E-02_JPRB,3.4755E-02_JPRB,2.0780E-02_JPRB,1.3171E-02_JPRB,1.2136E-02_JPRB/)
KAO( :, 4, 5, 6) = (/&
&9.3576E-02_JPRB,9.7447E-02_JPRB,9.3654E-02_JPRB,8.7006E-02_JPRB,7.8424E-02_JPRB,6.7877E-02_JPRB,&
&5.4374E-02_JPRB,3.7638E-02_JPRB,2.3002E-02_JPRB,1.4893E-02_JPRB,1.3923E-02_JPRB/)
KAO( :, 5, 5, 6) = (/&
&9.5080E-02_JPRB,1.0065E-01_JPRB,9.7383E-02_JPRB,9.1136E-02_JPRB,8.2601E-02_JPRB,7.1701E-02_JPRB,&
&5.7863E-02_JPRB,4.0796E-02_JPRB,2.5412E-02_JPRB,1.6809E-02_JPRB,1.5908E-02_JPRB/)
KAO( :, 1, 6, 6) = (/&
&7.7960E-02_JPRB,7.6934E-02_JPRB,7.1843E-02_JPRB,6.5156E-02_JPRB,5.7207E-02_JPRB,4.8156E-02_JPRB,&
&3.7659E-02_JPRB,2.4879E-02_JPRB,1.4127E-02_JPRB,8.5541E-03_JPRB,8.3666E-03_JPRB/)
KAO( :, 2, 6, 6) = (/&
&7.9609E-02_JPRB,7.9866E-02_JPRB,7.5063E-02_JPRB,6.8592E-02_JPRB,6.0623E-02_JPRB,5.1416E-02_JPRB,&
&4.0604E-02_JPRB,2.7099E-02_JPRB,1.5685E-02_JPRB,9.6918E-03_JPRB,9.5572E-03_JPRB/)
KAO( :, 3, 6, 6) = (/&
&8.1302E-02_JPRB,8.2836E-02_JPRB,7.8445E-02_JPRB,7.2127E-02_JPRB,6.4136E-02_JPRB,5.4857E-02_JPRB,&
&4.3565E-02_JPRB,2.9366E-02_JPRB,1.7400E-02_JPRB,1.0963E-02_JPRB,1.0922E-02_JPRB/)
KAO( :, 4, 6, 6) = (/&
&8.2802E-02_JPRB,8.5864E-02_JPRB,8.1904E-02_JPRB,7.5770E-02_JPRB,6.7852E-02_JPRB,5.8330E-02_JPRB,&
&4.6522E-02_JPRB,3.1837E-02_JPRB,1.9277E-02_JPRB,1.2364E-02_JPRB,1.2452E-02_JPRB/)
KAO( :, 5, 6, 6) = (/&
&8.4221E-02_JPRB,8.8823E-02_JPRB,8.5384E-02_JPRB,7.9630E-02_JPRB,7.1590E-02_JPRB,6.1823E-02_JPRB,&
&4.9653E-02_JPRB,3.4554E-02_JPRB,2.1337E-02_JPRB,1.3901E-02_JPRB,1.4136E-02_JPRB/)
KAO( :, 1, 7, 6) = (/&
&6.7828E-02_JPRB,6.6421E-02_JPRB,6.1520E-02_JPRB,5.5497E-02_JPRB,4.8477E-02_JPRB,4.0523E-02_JPRB,&
&3.1519E-02_JPRB,2.0723E-02_JPRB,1.1684E-02_JPRB,7.0442E-03_JPRB,8.2153E-03_JPRB/)
KAO( :, 2, 7, 6) = (/&
&6.9386E-02_JPRB,6.9084E-02_JPRB,6.4466E-02_JPRB,5.8621E-02_JPRB,5.1513E-02_JPRB,4.3404E-02_JPRB,&
&3.4117E-02_JPRB,2.2620E-02_JPRB,1.3002E-02_JPRB,8.0096E-03_JPRB,9.3023E-03_JPRB/)
KAO( :, 3, 7, 6) = (/&
&7.0902E-02_JPRB,7.1781E-02_JPRB,6.7571E-02_JPRB,6.1798E-02_JPRB,5.4668E-02_JPRB,4.6485E-02_JPRB,&
&3.6722E-02_JPRB,2.4596E-02_JPRB,1.4441E-02_JPRB,9.0791E-03_JPRB,1.0528E-02_JPRB/)
KAO( :, 4, 7, 6) = (/&
&7.2282E-02_JPRB,7.4474E-02_JPRB,7.0674E-02_JPRB,6.5102E-02_JPRB,5.8020E-02_JPRB,4.9583E-02_JPRB,&
&3.9334E-02_JPRB,2.6694E-02_JPRB,1.6007E-02_JPRB,1.0271E-02_JPRB,1.1922E-02_JPRB/)
KAO( :, 5, 7, 6) = (/&
&7.3586E-02_JPRB,7.7141E-02_JPRB,7.3787E-02_JPRB,6.8567E-02_JPRB,6.1369E-02_JPRB,5.2671E-02_JPRB,&
&4.2103E-02_JPRB,2.8979E-02_JPRB,1.7736E-02_JPRB,1.1572E-02_JPRB,1.3447E-02_JPRB/)
KAO( :, 1, 8, 6) = (/&
&5.8712E-02_JPRB,5.7043E-02_JPRB,5.2438E-02_JPRB,4.7021E-02_JPRB,4.0853E-02_JPRB,3.3895E-02_JPRB,&
&2.6198E-02_JPRB,1.7219E-02_JPRB,9.5944E-03_JPRB,5.7565E-03_JPRB,9.7903E-03_JPRB/)
KAO( :, 2, 8, 6) = (/&
&6.0111E-02_JPRB,5.9403E-02_JPRB,5.5109E-02_JPRB,4.9792E-02_JPRB,4.3500E-02_JPRB,3.6406E-02_JPRB,&
&2.8441E-02_JPRB,1.8832E-02_JPRB,1.0715E-02_JPRB,6.5565E-03_JPRB,1.0886E-02_JPRB/)
KAO( :, 3, 8, 6) = (/&
&6.1464E-02_JPRB,6.1765E-02_JPRB,5.7839E-02_JPRB,5.2591E-02_JPRB,4.6276E-02_JPRB,3.9078E-02_JPRB,&
&3.0733E-02_JPRB,2.0508E-02_JPRB,1.1934E-02_JPRB,7.4566E-03_JPRB,1.2121E-02_JPRB/)
KAO( :, 4, 8, 6) = (/&
&6.2712E-02_JPRB,6.4146E-02_JPRB,6.0527E-02_JPRB,5.5457E-02_JPRB,4.9226E-02_JPRB,4.1797E-02_JPRB,&
&3.3031E-02_JPRB,2.2300E-02_JPRB,1.3252E-02_JPRB,8.4625E-03_JPRB,1.3482E-02_JPRB/)
KAO( :, 5, 8, 6) = (/&
&6.3914E-02_JPRB,6.6490E-02_JPRB,6.3234E-02_JPRB,5.8457E-02_JPRB,5.2124E-02_JPRB,4.4504E-02_JPRB,&
&3.5484E-02_JPRB,2.4239E-02_JPRB,1.4708E-02_JPRB,9.5766E-03_JPRB,1.4975E-02_JPRB/)
KAO( :, 1, 9, 6) = (/&
&5.0689E-02_JPRB,4.8919E-02_JPRB,4.4694E-02_JPRB,3.9834E-02_JPRB,3.4426E-02_JPRB,2.8389E-02_JPRB,&
&2.1819E-02_JPRB,1.4302E-02_JPRB,7.8127E-03_JPRB,4.6620E-03_JPRB,2.0696E-02_JPRB/)
KAO( :, 2, 9, 6) = (/&
&5.1946E-02_JPRB,5.0973E-02_JPRB,4.7056E-02_JPRB,4.2253E-02_JPRB,3.6737E-02_JPRB,3.0544E-02_JPRB,&
&2.3724E-02_JPRB,1.5668E-02_JPRB,8.7780E-03_JPRB,5.3214E-03_JPRB,2.1910E-02_JPRB/)
KAO( :, 3, 9, 6) = (/&
&5.3143E-02_JPRB,5.3077E-02_JPRB,4.9431E-02_JPRB,4.4665E-02_JPRB,3.9122E-02_JPRB,3.2816E-02_JPRB,&
&2.5692E-02_JPRB,1.7096E-02_JPRB,9.8039E-03_JPRB,6.0656E-03_JPRB,2.3234E-02_JPRB/)
KAO( :, 4, 9, 6) = (/&
&5.4267E-02_JPRB,5.5157E-02_JPRB,5.1739E-02_JPRB,4.7167E-02_JPRB,4.1644E-02_JPRB,3.5136E-02_JPRB,&
&2.7685E-02_JPRB,1.8626E-02_JPRB,1.0916E-02_JPRB,6.9060E-03_JPRB,2.4826E-02_JPRB/)
KAO( :, 5, 9, 6) = (/&
&5.5411E-02_JPRB,5.7220E-02_JPRB,5.4074E-02_JPRB,4.9699E-02_JPRB,4.4127E-02_JPRB,3.7477E-02_JPRB,&
&2.9785E-02_JPRB,2.0273E-02_JPRB,1.2148E-02_JPRB,7.8411E-03_JPRB,2.6607E-02_JPRB/)
KAO( :, 1,10, 6) = (/&
&4.3441E-02_JPRB,4.1752E-02_JPRB,3.7992E-02_JPRB,3.3732E-02_JPRB,2.9033E-02_JPRB,2.3892E-02_JPRB,&
&1.8315E-02_JPRB,1.1925E-02_JPRB,6.3650E-03_JPRB,3.7730E-03_JPRB,5.8980E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&4.4578E-02_JPRB,4.3534E-02_JPRB,4.0036E-02_JPRB,3.5800E-02_JPRB,3.1038E-02_JPRB,2.5745E-02_JPRB,&
&1.9928E-02_JPRB,1.3095E-02_JPRB,7.1901E-03_JPRB,4.3268E-03_JPRB,6.2127E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&4.5637E-02_JPRB,4.5360E-02_JPRB,4.2074E-02_JPRB,3.7890E-02_JPRB,3.3109E-02_JPRB,2.7662E-02_JPRB,&
&2.1605E-02_JPRB,1.4318E-02_JPRB,8.0717E-03_JPRB,4.9441E-03_JPRB,6.4930E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&4.6665E-02_JPRB,4.7201E-02_JPRB,4.4073E-02_JPRB,4.0041E-02_JPRB,3.5227E-02_JPRB,2.9634E-02_JPRB,&
&2.3310E-02_JPRB,1.5630E-02_JPRB,9.0074E-03_JPRB,5.6431E-03_JPRB,6.7490E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&4.7723E-02_JPRB,4.9037E-02_JPRB,4.6142E-02_JPRB,4.2228E-02_JPRB,3.7348E-02_JPRB,3.1608E-02_JPRB,&
&2.5075E-02_JPRB,1.7036E-02_JPRB,1.0045E-02_JPRB,6.4268E-03_JPRB,6.9977E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&3.7516E-02_JPRB,3.6158E-02_JPRB,3.2933E-02_JPRB,2.9252E-02_JPRB,2.5204E-02_JPRB,2.0803E-02_JPRB,&
&1.5990E-02_JPRB,1.0375E-02_JPRB,5.4827E-03_JPRB,3.2361E-03_JPRB,8.1016E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&3.8506E-02_JPRB,3.7721E-02_JPRB,3.4706E-02_JPRB,3.1031E-02_JPRB,2.6946E-02_JPRB,2.2411E-02_JPRB,&
&1.7386E-02_JPRB,1.1409E-02_JPRB,6.2003E-03_JPRB,3.7210E-03_JPRB,8.4685E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&3.9439E-02_JPRB,3.9310E-02_JPRB,3.6436E-02_JPRB,3.2830E-02_JPRB,2.8736E-02_JPRB,2.4071E-02_JPRB,&
&1.8831E-02_JPRB,1.2487E-02_JPRB,6.9722E-03_JPRB,4.2623E-03_JPRB,8.7980E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&4.0392E-02_JPRB,4.0944E-02_JPRB,3.8217E-02_JPRB,3.4707E-02_JPRB,3.0543E-02_JPRB,2.5731E-02_JPRB,&
&2.0303E-02_JPRB,1.3646E-02_JPRB,7.7970E-03_JPRB,4.8703E-03_JPRB,9.0981E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&4.1332E-02_JPRB,4.2552E-02_JPRB,4.0059E-02_JPRB,3.6603E-02_JPRB,3.2383E-02_JPRB,2.7450E-02_JPRB,&
&2.1833E-02_JPRB,1.4887E-02_JPRB,8.7084E-03_JPRB,5.5527E-03_JPRB,9.3973E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&3.2190E-02_JPRB,3.1071E-02_JPRB,2.8321E-02_JPRB,2.5152E-02_JPRB,2.1728E-02_JPRB,1.7981E-02_JPRB,&
&1.3822E-02_JPRB,8.9602E-03_JPRB,4.7106E-03_JPRB,2.7564E-03_JPRB,8.5402E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&3.3033E-02_JPRB,3.2405E-02_JPRB,2.9806E-02_JPRB,2.6661E-02_JPRB,2.3211E-02_JPRB,1.9361E-02_JPRB,&
&1.5025E-02_JPRB,9.8641E-03_JPRB,5.3297E-03_JPRB,3.1770E-03_JPRB,8.8737E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&3.3864E-02_JPRB,3.3793E-02_JPRB,3.1297E-02_JPRB,2.8211E-02_JPRB,2.4733E-02_JPRB,2.0771E-02_JPRB,&
&1.6265E-02_JPRB,1.0821E-02_JPRB,6.0022E-03_JPRB,3.6467E-03_JPRB,9.1670E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&3.4696E-02_JPRB,3.5203E-02_JPRB,3.2853E-02_JPRB,2.9817E-02_JPRB,2.6296E-02_JPRB,2.2203E-02_JPRB,&
&1.7545E-02_JPRB,1.1834E-02_JPRB,6.7302E-03_JPRB,4.1679E-03_JPRB,9.4574E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&3.5522E-02_JPRB,3.6626E-02_JPRB,3.4423E-02_JPRB,3.1438E-02_JPRB,2.7875E-02_JPRB,2.3697E-02_JPRB,&
&1.8905E-02_JPRB,1.2927E-02_JPRB,7.5191E-03_JPRB,4.7590E-03_JPRB,9.7614E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&2.7210E-02_JPRB,2.6304E-02_JPRB,2.3996E-02_JPRB,2.1359E-02_JPRB,1.8491E-02_JPRB,1.5314E-02_JPRB,&
&1.1755E-02_JPRB,7.6170E-03_JPRB,4.0095E-03_JPRB,2.3275E-03_JPRB,7.1211E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&2.7941E-02_JPRB,2.7441E-02_JPRB,2.5246E-02_JPRB,2.2622E-02_JPRB,1.9729E-02_JPRB,1.6472E-02_JPRB,&
&1.2765E-02_JPRB,8.4034E-03_JPRB,4.5447E-03_JPRB,2.6861E-03_JPRB,7.3769E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&2.8664E-02_JPRB,2.8630E-02_JPRB,2.6520E-02_JPRB,2.3935E-02_JPRB,2.1025E-02_JPRB,1.7662E-02_JPRB,&
&1.3821E-02_JPRB,9.2359E-03_JPRB,5.1273E-03_JPRB,3.0871E-03_JPRB,7.6136E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&2.9387E-02_JPRB,2.9844E-02_JPRB,2.7832E-02_JPRB,2.5287E-02_JPRB,2.2341E-02_JPRB,1.8888E-02_JPRB,&
&1.4940E-02_JPRB,1.0117E-02_JPRB,5.7529E-03_JPRB,3.5334E-03_JPRB,7.8673E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&3.0121E-02_JPRB,3.1064E-02_JPRB,2.9140E-02_JPRB,2.6651E-02_JPRB,2.3680E-02_JPRB,2.0177E-02_JPRB,&
&1.6134E-02_JPRB,1.1077E-02_JPRB,6.4283E-03_JPRB,4.0402E-03_JPRB,8.1505E-02_JPRB/)
KAO( :, 1, 1, 7) = (/&
&2.6926E-01_JPRB,2.5612E-01_JPRB,2.3950E-01_JPRB,2.1903E-01_JPRB,1.9378E-01_JPRB,1.6501E-01_JPRB,&
&1.2973E-01_JPRB,8.7439E-02_JPRB,5.3950E-02_JPRB,4.2811E-02_JPRB,4.3233E-02_JPRB/)
KAO( :, 2, 1, 7) = (/&
&2.6861E-01_JPRB,2.5930E-01_JPRB,2.4513E-01_JPRB,2.2568E-01_JPRB,2.0133E-01_JPRB,1.7294E-01_JPRB,&
&1.3711E-01_JPRB,9.4464E-02_JPRB,6.0595E-02_JPRB,5.0710E-02_JPRB,5.1677E-02_JPRB/)
KAO( :, 3, 1, 7) = (/&
&2.6820E-01_JPRB,2.6238E-01_JPRB,2.5102E-01_JPRB,2.3240E-01_JPRB,2.0913E-01_JPRB,1.8091E-01_JPRB,&
&1.4446E-01_JPRB,1.0226E-01_JPRB,6.8084E-02_JPRB,5.9495E-02_JPRB,6.1037E-02_JPRB/)
KAO( :, 4, 1, 7) = (/&
&2.6771E-01_JPRB,2.6572E-01_JPRB,2.5658E-01_JPRB,2.3935E-01_JPRB,2.1685E-01_JPRB,1.8839E-01_JPRB,&
&1.5222E-01_JPRB,1.1069E-01_JPRB,7.6279E-02_JPRB,6.9108E-02_JPRB,7.1213E-02_JPRB/)
KAO( :, 5, 1, 7) = (/&
&2.6714E-01_JPRB,2.6936E-01_JPRB,2.6194E-01_JPRB,2.4642E-01_JPRB,2.2450E-01_JPRB,1.9571E-01_JPRB,&
&1.6083E-01_JPRB,1.1918E-01_JPRB,8.5421E-02_JPRB,7.9682E-02_JPRB,8.2280E-02_JPRB/)
KAO( :, 1, 2, 7) = (/&
&2.5685E-01_JPRB,2.4492E-01_JPRB,2.2865E-01_JPRB,2.0884E-01_JPRB,1.8444E-01_JPRB,1.5601E-01_JPRB,&
&1.2319E-01_JPRB,8.1747E-02_JPRB,4.8230E-02_JPRB,3.5409E-02_JPRB,3.4615E-02_JPRB/)
KAO( :, 2, 2, 7) = (/&
&2.5657E-01_JPRB,2.4834E-01_JPRB,2.3445E-01_JPRB,2.1551E-01_JPRB,1.9182E-01_JPRB,1.6377E-01_JPRB,&
&1.3042E-01_JPRB,8.8197E-02_JPRB,5.3891E-02_JPRB,4.1822E-02_JPRB,4.1515E-02_JPRB/)
KAO( :, 3, 2, 7) = (/&
&2.5627E-01_JPRB,2.5163E-01_JPRB,2.4011E-01_JPRB,2.2230E-01_JPRB,1.9937E-01_JPRB,1.7150E-01_JPRB,&
&1.3758E-01_JPRB,9.5254E-02_JPRB,6.0018E-02_JPRB,4.9025E-02_JPRB,4.9189E-02_JPRB/)
KAO( :, 4, 2, 7) = (/&
&2.5591E-01_JPRB,2.5517E-01_JPRB,2.4558E-01_JPRB,2.2928E-01_JPRB,2.0702E-01_JPRB,1.7899E-01_JPRB,&
&1.4524E-01_JPRB,1.0258E-01_JPRB,6.6782E-02_JPRB,5.7123E-02_JPRB,5.7631E-02_JPRB/)
KAO( :, 5, 2, 7) = (/&
&2.5562E-01_JPRB,2.5902E-01_JPRB,2.5095E-01_JPRB,2.3638E-01_JPRB,2.1422E-01_JPRB,1.8662E-01_JPRB,&
&1.5329E-01_JPRB,1.0996E-01_JPRB,7.4405E-02_JPRB,6.6142E-02_JPRB,6.6949E-02_JPRB/)
KAO( :, 1, 3, 7) = (/&
&2.4108E-01_JPRB,2.2965E-01_JPRB,2.1361E-01_JPRB,1.9446E-01_JPRB,1.7133E-01_JPRB,1.4401E-01_JPRB,&
&1.1345E-01_JPRB,7.5185E-02_JPRB,4.2160E-02_JPRB,2.8583E-02_JPRB,2.6584E-02_JPRB/)
KAO( :, 2, 3, 7) = (/&
&2.4113E-01_JPRB,2.3314E-01_JPRB,2.1942E-01_JPRB,2.0119E-01_JPRB,1.7846E-01_JPRB,1.5146E-01_JPRB,&
&1.2063E-01_JPRB,8.1173E-02_JPRB,4.7044E-02_JPRB,3.3533E-02_JPRB,3.2019E-02_JPRB/)
KAO( :, 3, 3, 7) = (/&
&2.4094E-01_JPRB,2.3663E-01_JPRB,2.2501E-01_JPRB,2.0773E-01_JPRB,1.8580E-01_JPRB,1.5907E-01_JPRB,&
&1.2798E-01_JPRB,8.7501E-02_JPRB,5.2313E-02_JPRB,3.9244E-02_JPRB,3.8141E-02_JPRB/)
KAO( :, 4, 3, 7) = (/&
&2.4074E-01_JPRB,2.4043E-01_JPRB,2.3041E-01_JPRB,2.1449E-01_JPRB,1.9317E-01_JPRB,1.6647E-01_JPRB,&
&1.3556E-01_JPRB,9.3949E-02_JPRB,5.7980E-02_JPRB,4.5777E-02_JPRB,4.5020E-02_JPRB/)
KAO( :, 5, 3, 7) = (/&
&2.4071E-01_JPRB,2.4430E-01_JPRB,2.3591E-01_JPRB,2.2137E-01_JPRB,2.0017E-01_JPRB,1.7425E-01_JPRB,&
&1.4332E-01_JPRB,1.0047E-01_JPRB,6.4245E-02_JPRB,5.3237E-02_JPRB,5.2730E-02_JPRB/)
KAO( :, 1, 4, 7) = (/&
&2.2311E-01_JPRB,2.1202E-01_JPRB,1.9660E-01_JPRB,1.7804E-01_JPRB,1.5619E-01_JPRB,1.3066E-01_JPRB,&
&1.0239E-01_JPRB,6.7996E-02_JPRB,3.6908E-02_JPRB,2.3235E-02_JPRB,2.0397E-02_JPRB/)
KAO( :, 2, 4, 7) = (/&
&2.2321E-01_JPRB,2.1552E-01_JPRB,2.0209E-01_JPRB,1.8449E-01_JPRB,1.6284E-01_JPRB,1.3774E-01_JPRB,&
&1.0930E-01_JPRB,7.3775E-02_JPRB,4.1078E-02_JPRB,2.7004E-02_JPRB,2.4614E-02_JPRB/)
KAO( :, 3, 4, 7) = (/&
&2.2314E-01_JPRB,2.1901E-01_JPRB,2.0753E-01_JPRB,1.9073E-01_JPRB,1.6981E-01_JPRB,1.4494E-01_JPRB,&
&1.1634E-01_JPRB,7.9807E-02_JPRB,4.5483E-02_JPRB,3.1405E-02_JPRB,2.9481E-02_JPRB/)
KAO( :, 4, 4, 7) = (/&
&2.2327E-01_JPRB,2.2287E-01_JPRB,2.1284E-01_JPRB,1.9716E-01_JPRB,1.7693E-01_JPRB,1.5226E-01_JPRB,&
&1.2381E-01_JPRB,8.5751E-02_JPRB,5.0279E-02_JPRB,3.6528E-02_JPRB,3.5030E-02_JPRB/)
KAO( :, 5, 4, 7) = (/&
&2.2365E-01_JPRB,2.2673E-01_JPRB,2.1820E-01_JPRB,2.0372E-01_JPRB,1.8385E-01_JPRB,1.5984E-01_JPRB,&
&1.3133E-01_JPRB,9.1593E-02_JPRB,5.5615E-02_JPRB,4.2459E-02_JPRB,4.1306E-02_JPRB/)
KAO( :, 1, 5, 7) = (/&
&2.0367E-01_JPRB,1.9330E-01_JPRB,1.7867E-01_JPRB,1.6084E-01_JPRB,1.4027E-01_JPRB,1.1693E-01_JPRB,&
&9.0945E-02_JPRB,6.0466E-02_JPRB,3.2455E-02_JPRB,1.9165E-02_JPRB,1.7920E-02_JPRB/)
KAO( :, 2, 5, 7) = (/&
&2.0387E-01_JPRB,1.9668E-01_JPRB,1.8380E-01_JPRB,1.6682E-01_JPRB,1.4653E-01_JPRB,1.2346E-01_JPRB,&
&9.7443E-02_JPRB,6.5962E-02_JPRB,3.6138E-02_JPRB,2.2169E-02_JPRB,2.0934E-02_JPRB/)
KAO( :, 3, 5, 7) = (/&
&2.0408E-01_JPRB,2.0015E-01_JPRB,1.8885E-01_JPRB,1.7264E-01_JPRB,1.5303E-01_JPRB,1.3023E-01_JPRB,&
&1.0413E-01_JPRB,7.1676E-02_JPRB,3.9916E-02_JPRB,2.5581E-02_JPRB,2.4393E-02_JPRB/)
KAO( :, 4, 5, 7) = (/&
&2.0467E-01_JPRB,2.0395E-01_JPRB,1.9389E-01_JPRB,1.7862E-01_JPRB,1.5966E-01_JPRB,1.3725E-01_JPRB,&
&1.1106E-01_JPRB,7.7287E-02_JPRB,4.3976E-02_JPRB,2.9567E-02_JPRB,2.8440E-02_JPRB/)
KAO( :, 5, 5, 7) = (/&
&2.0538E-01_JPRB,2.0784E-01_JPRB,1.9895E-01_JPRB,1.8474E-01_JPRB,1.6635E-01_JPRB,1.4459E-01_JPRB,&
&1.1807E-01_JPRB,8.2795E-02_JPRB,4.8485E-02_JPRB,3.4195E-02_JPRB,3.3174E-02_JPRB/)
KAO( :, 1, 6, 7) = (/&
&1.8377E-01_JPRB,1.7398E-01_JPRB,1.6006E-01_JPRB,1.4318E-01_JPRB,1.2397E-01_JPRB,1.0298E-01_JPRB,&
&7.9521E-02_JPRB,5.2397E-02_JPRB,2.8050E-02_JPRB,1.5934E-02_JPRB,1.6791E-02_JPRB/)
KAO( :, 2, 6, 7) = (/&
&1.8406E-01_JPRB,1.7717E-01_JPRB,1.6474E-01_JPRB,1.4853E-01_JPRB,1.2984E-01_JPRB,1.0898E-01_JPRB,&
&8.5328E-02_JPRB,5.7490E-02_JPRB,3.1447E-02_JPRB,1.8349E-02_JPRB,1.9516E-02_JPRB/)
KAO( :, 3, 6, 7) = (/&
&1.8458E-01_JPRB,1.8054E-01_JPRB,1.6936E-01_JPRB,1.5392E-01_JPRB,1.3584E-01_JPRB,1.1517E-01_JPRB,&
&9.1409E-02_JPRB,6.2836E-02_JPRB,3.4889E-02_JPRB,2.1106E-02_JPRB,2.2611E-02_JPRB/)
KAO( :, 4, 6, 7) = (/&
&1.8542E-01_JPRB,1.8421E-01_JPRB,1.7403E-01_JPRB,1.5942E-01_JPRB,1.4196E-01_JPRB,1.2162E-01_JPRB,&
&9.7928E-02_JPRB,6.8139E-02_JPRB,3.8483E-02_JPRB,2.4244E-02_JPRB,2.6124E-02_JPRB/)
KAO( :, 5, 6, 7) = (/&
&1.8648E-01_JPRB,1.8801E-01_JPRB,1.7890E-01_JPRB,1.6506E-01_JPRB,1.4823E-01_JPRB,1.2840E-01_JPRB,&
&1.0438E-01_JPRB,7.3304E-02_JPRB,4.2378E-02_JPRB,2.7839E-02_JPRB,3.0053E-02_JPRB/)
KAO( :, 1, 7, 7) = (/&
&1.6272E-01_JPRB,1.5372E-01_JPRB,1.4080E-01_JPRB,1.2519E-01_JPRB,1.0771E-01_JPRB,8.8984E-02_JPRB,&
&6.8276E-02_JPRB,4.4541E-02_JPRB,2.3807E-02_JPRB,1.3453E-02_JPRB,1.6655E-02_JPRB/)
KAO( :, 2, 7, 7) = (/&
&1.6325E-01_JPRB,1.5679E-01_JPRB,1.4498E-01_JPRB,1.2986E-01_JPRB,1.1297E-01_JPRB,9.4402E-02_JPRB,&
&7.3383E-02_JPRB,4.9046E-02_JPRB,2.6845E-02_JPRB,1.5405E-02_JPRB,1.9132E-02_JPRB/)
KAO( :, 3, 7, 7) = (/&
&1.6400E-01_JPRB,1.6007E-01_JPRB,1.4916E-01_JPRB,1.3473E-01_JPRB,1.1836E-01_JPRB,9.9949E-02_JPRB,&
&7.8806E-02_JPRB,5.3833E-02_JPRB,2.9954E-02_JPRB,1.7645E-02_JPRB,2.1895E-02_JPRB/)
KAO( :, 4, 7, 7) = (/&
&1.6505E-01_JPRB,1.6353E-01_JPRB,1.5347E-01_JPRB,1.3982E-01_JPRB,1.2392E-01_JPRB,1.0565E-01_JPRB,&
&8.4634E-02_JPRB,5.8597E-02_JPRB,3.3207E-02_JPRB,2.0171E-02_JPRB,2.4986E-02_JPRB/)
KAO( :, 5, 7, 7) = (/&
&1.6641E-01_JPRB,1.6726E-01_JPRB,1.5808E-01_JPRB,1.4506E-01_JPRB,1.2973E-01_JPRB,1.1182E-01_JPRB,&
&9.0461E-02_JPRB,6.3334E-02_JPRB,3.6689E-02_JPRB,2.3031E-02_JPRB,2.8476E-02_JPRB/)
KAO( :, 1, 8, 7) = (/&
&1.4230E-01_JPRB,1.3413E-01_JPRB,1.2233E-01_JPRB,1.0813E-01_JPRB,9.2496E-02_JPRB,7.5904E-02_JPRB,&
&5.7906E-02_JPRB,3.7394E-02_JPRB,2.0019E-02_JPRB,1.1310E-02_JPRB,1.9019E-02_JPRB/)
KAO( :, 2, 8, 7) = (/&
&1.4305E-01_JPRB,1.3708E-01_JPRB,1.2596E-01_JPRB,1.1218E-01_JPRB,9.7109E-02_JPRB,8.0704E-02_JPRB,&
&6.2330E-02_JPRB,4.1218E-02_JPRB,2.2623E-02_JPRB,1.3029E-02_JPRB,2.1546E-02_JPRB/)
KAO( :, 3, 8, 7) = (/&
&1.4394E-01_JPRB,1.4013E-01_JPRB,1.2970E-01_JPRB,1.1658E-01_JPRB,1.0194E-01_JPRB,8.5591E-02_JPRB,&
&6.7043E-02_JPRB,4.5347E-02_JPRB,2.5359E-02_JPRB,1.4903E-02_JPRB,2.4327E-02_JPRB/)
KAO( :, 4, 8, 7) = (/&
&1.4525E-01_JPRB,1.4339E-01_JPRB,1.3373E-01_JPRB,1.2126E-01_JPRB,1.0690E-01_JPRB,9.0683E-02_JPRB,&
&7.2129E-02_JPRB,4.9569E-02_JPRB,2.8222E-02_JPRB,1.6964E-02_JPRB,2.7427E-02_JPRB/)
KAO( :, 5, 8, 7) = (/&
&1.4678E-01_JPRB,1.4702E-01_JPRB,1.3814E-01_JPRB,1.2616E-01_JPRB,1.1217E-01_JPRB,9.6136E-02_JPRB,&
&7.7253E-02_JPRB,5.3800E-02_JPRB,3.1285E-02_JPRB,1.9274E-02_JPRB,3.0890E-02_JPRB/)
KAO( :, 1, 9, 7) = (/&
&1.2368E-01_JPRB,1.1615E-01_JPRB,1.0547E-01_JPRB,9.2730E-02_JPRB,7.8890E-02_JPRB,6.4288E-02_JPRB,&
&4.8706E-02_JPRB,3.1194E-02_JPRB,1.6735E-02_JPRB,9.3621E-03_JPRB,3.9474E-02_JPRB/)
KAO( :, 2, 9, 7) = (/&
&1.2453E-01_JPRB,1.1886E-01_JPRB,1.0862E-01_JPRB,9.6299E-02_JPRB,8.2892E-02_JPRB,6.8444E-02_JPRB,&
&5.2534E-02_JPRB,3.4360E-02_JPRB,1.8949E-02_JPRB,1.0875E-02_JPRB,4.3185E-02_JPRB/)
KAO( :, 3, 9, 7) = (/&
&1.2562E-01_JPRB,1.2177E-01_JPRB,1.1199E-01_JPRB,1.0025E-01_JPRB,8.7157E-02_JPRB,7.2734E-02_JPRB,&
&5.6567E-02_JPRB,3.7837E-02_JPRB,2.1307E-02_JPRB,1.2524E-02_JPRB,4.7262E-02_JPRB/)
KAO( :, 4, 9, 7) = (/&
&1.2711E-01_JPRB,1.2497E-01_JPRB,1.1585E-01_JPRB,1.0453E-01_JPRB,9.1592E-02_JPRB,7.7237E-02_JPRB,&
&6.0927E-02_JPRB,4.1474E-02_JPRB,2.3783E-02_JPRB,1.4321E-02_JPRB,5.1601E-02_JPRB/)
KAO( :, 5, 9, 7) = (/&
&1.2877E-01_JPRB,1.2842E-01_JPRB,1.2005E-01_JPRB,1.0911E-01_JPRB,9.6384E-02_JPRB,8.2052E-02_JPRB,&
&6.5390E-02_JPRB,4.5200E-02_JPRB,2.6423E-02_JPRB,1.6264E-02_JPRB,5.6231E-02_JPRB/)
KAO( :, 1,10, 7) = (/&
&1.0692E-01_JPRB,1.0005E-01_JPRB,9.0502E-02_JPRB,7.9216E-02_JPRB,6.7057E-02_JPRB,5.4323E-02_JPRB,&
&4.0890E-02_JPRB,2.6119E-02_JPRB,1.4019E-02_JPRB,7.7525E-03_JPRB,1.2082E-01_JPRB/)
KAO( :, 2,10, 7) = (/&
&1.0785E-01_JPRB,1.0257E-01_JPRB,9.3251E-02_JPRB,8.2316E-02_JPRB,7.0515E-02_JPRB,5.7848E-02_JPRB,&
&4.4197E-02_JPRB,2.8769E-02_JPRB,1.5892E-02_JPRB,9.0528E-03_JPRB,1.2557E-01_JPRB/)
KAO( :, 3,10, 7) = (/&
&1.0912E-01_JPRB,1.0534E-01_JPRB,9.6345E-02_JPRB,8.5888E-02_JPRB,7.4218E-02_JPRB,6.1590E-02_JPRB,&
&4.7639E-02_JPRB,3.1645E-02_JPRB,1.7926E-02_JPRB,1.0497E-02_JPRB,1.3124E-01_JPRB/)
KAO( :, 4,10, 7) = (/&
&1.1068E-01_JPRB,1.0836E-01_JPRB,9.9964E-02_JPRB,8.9810E-02_JPRB,7.8244E-02_JPRB,6.5593E-02_JPRB,&
&5.1337E-02_JPRB,3.4711E-02_JPRB,2.0071E-02_JPRB,1.2083E-02_JPRB,1.3784E-01_JPRB/)
KAO( :, 5,10, 7) = (/&
&1.1237E-01_JPRB,1.1161E-01_JPRB,1.0388E-01_JPRB,9.3947E-02_JPRB,8.2580E-02_JPRB,6.9883E-02_JPRB,&
&5.5203E-02_JPRB,3.7928E-02_JPRB,2.2348E-02_JPRB,1.3792E-02_JPRB,1.4518E-01_JPRB/)
KAO( :, 1,11, 7) = (/&
&9.2754E-02_JPRB,8.7072E-02_JPRB,7.8639E-02_JPRB,6.8755E-02_JPRB,5.8275E-02_JPRB,4.7245E-02_JPRB,&
&3.5602E-02_JPRB,2.2866E-02_JPRB,1.2334E-02_JPRB,6.8505E-03_JPRB,1.6609E-01_JPRB/)
KAO( :, 2,11, 7) = (/&
&9.3939E-02_JPRB,8.9571E-02_JPRB,8.1238E-02_JPRB,7.1711E-02_JPRB,6.1381E-02_JPRB,5.0306E-02_JPRB,&
&3.8442E-02_JPRB,2.5156E-02_JPRB,1.3991E-02_JPRB,8.0122E-03_JPRB,1.7138E-01_JPRB/)
KAO( :, 3,11, 7) = (/&
&9.5412E-02_JPRB,9.2282E-02_JPRB,8.4324E-02_JPRB,7.5102E-02_JPRB,6.4785E-02_JPRB,5.3640E-02_JPRB,&
&4.1470E-02_JPRB,2.7635E-02_JPRB,1.5787E-02_JPRB,9.3174E-03_JPRB,1.7778E-01_JPRB/)
KAO( :, 4,11, 7) = (/&
&9.6996E-02_JPRB,9.5142E-02_JPRB,8.7745E-02_JPRB,7.8708E-02_JPRB,6.8483E-02_JPRB,5.7282E-02_JPRB,&
&4.4714E-02_JPRB,3.0277E-02_JPRB,1.7707E-02_JPRB,1.0749E-02_JPRB,1.8499E-01_JPRB/)
KAO( :, 5,11, 7) = (/&
&9.8658E-02_JPRB,9.8284E-02_JPRB,9.1388E-02_JPRB,8.2534E-02_JPRB,7.2404E-02_JPRB,6.1041E-02_JPRB,&
&4.8110E-02_JPRB,3.3083E-02_JPRB,1.9725E-02_JPRB,1.2309E-02_JPRB,1.9294E-01_JPRB/)
KAO( :, 1,12, 7) = (/&
&8.0002E-02_JPRB,7.5395E-02_JPRB,6.7953E-02_JPRB,5.9467E-02_JPRB,5.0458E-02_JPRB,4.0919E-02_JPRB,&
&3.0920E-02_JPRB,1.9925E-02_JPRB,1.0727E-02_JPRB,5.9901E-03_JPRB,1.7505E-01_JPRB/)
KAO( :, 2,12, 7) = (/&
&8.1332E-02_JPRB,7.7813E-02_JPRB,7.0567E-02_JPRB,6.2307E-02_JPRB,5.3303E-02_JPRB,4.3618E-02_JPRB,&
&3.3391E-02_JPRB,2.1911E-02_JPRB,1.2184E-02_JPRB,7.0189E-03_JPRB,1.8048E-01_JPRB/)
KAO( :, 3,12, 7) = (/&
&8.2791E-02_JPRB,8.0324E-02_JPRB,7.3485E-02_JPRB,6.5420E-02_JPRB,5.6352E-02_JPRB,4.6610E-02_JPRB,&
&3.6047E-02_JPRB,2.4056E-02_JPRB,1.3765E-02_JPRB,8.1809E-03_JPRB,1.8704E-01_JPRB/)
KAO( :, 4,12, 7) = (/&
&8.4300E-02_JPRB,8.3063E-02_JPRB,7.6637E-02_JPRB,6.8671E-02_JPRB,5.9646E-02_JPRB,4.9774E-02_JPRB,&
&3.8886E-02_JPRB,2.6351E-02_JPRB,1.5463E-02_JPRB,9.4646E-03_JPRB,1.9416E-01_JPRB/)
KAO( :, 5,12, 7) = (/&
&8.5799E-02_JPRB,8.5928E-02_JPRB,7.9923E-02_JPRB,7.2138E-02_JPRB,6.3097E-02_JPRB,5.3071E-02_JPRB,&
&4.1851E-02_JPRB,2.8800E-02_JPRB,1.7260E-02_JPRB,1.0869E-02_JPRB,2.0180E-01_JPRB/)
KAO( :, 1,13, 7) = (/&
&6.7746E-02_JPRB,6.4117E-02_JPRB,5.7794E-02_JPRB,5.0687E-02_JPRB,4.3091E-02_JPRB,3.5063E-02_JPRB,&
&2.6600E-02_JPRB,1.7143E-02_JPRB,9.2085E-03_JPRB,5.1738E-03_JPRB,1.4684E-01_JPRB/)
KAO( :, 2,13, 7) = (/&
&6.9040E-02_JPRB,6.6326E-02_JPRB,6.0272E-02_JPRB,5.3267E-02_JPRB,4.5640E-02_JPRB,3.7446E-02_JPRB,&
&2.8771E-02_JPRB,1.8875E-02_JPRB,1.0472E-02_JPRB,6.0786E-03_JPRB,1.5190E-01_JPRB/)
KAO( :, 3,13, 7) = (/&
&7.0402E-02_JPRB,6.8674E-02_JPRB,6.2930E-02_JPRB,5.6044E-02_JPRB,4.8322E-02_JPRB,4.0046E-02_JPRB,&
&3.1093E-02_JPRB,2.0746E-02_JPRB,1.1854E-02_JPRB,7.0992E-03_JPRB,1.5783E-01_JPRB/)
KAO( :, 4,13, 7) = (/&
&7.1727E-02_JPRB,7.1116E-02_JPRB,6.5698E-02_JPRB,5.8955E-02_JPRB,5.1188E-02_JPRB,4.2780E-02_JPRB,&
&3.3535E-02_JPRB,2.2751E-02_JPRB,1.3343E-02_JPRB,8.2333E-03_JPRB,1.6414E-01_JPRB/)
KAO( :, 5,13, 7) = (/&
&7.3153E-02_JPRB,7.3694E-02_JPRB,6.8621E-02_JPRB,6.1933E-02_JPRB,5.4168E-02_JPRB,4.5648E-02_JPRB,&
&3.6089E-02_JPRB,2.4874E-02_JPRB,1.4932E-02_JPRB,9.4816E-03_JPRB,1.7071E-01_JPRB/)
KAO( :, 1, 1, 8) = (/&
&4.9299E-01_JPRB,4.5097E-01_JPRB,4.1423E-01_JPRB,3.7425E-01_JPRB,3.3288E-01_JPRB,2.8439E-01_JPRB,&
&2.3129E-01_JPRB,1.6724E-01_JPRB,1.2209E-01_JPRB,1.1839E-01_JPRB,1.2231E-01_JPRB/)
KAO( :, 2, 1, 8) = (/&
&4.9158E-01_JPRB,4.5413E-01_JPRB,4.2130E-01_JPRB,3.8574E-01_JPRB,3.4556E-01_JPRB,2.9862E-01_JPRB,&
&2.4672E-01_JPRB,1.8285E-01_JPRB,1.4316E-01_JPRB,1.4173E-01_JPRB,1.4653E-01_JPRB/)
KAO( :, 3, 1, 8) = (/&
&4.8921E-01_JPRB,4.5835E-01_JPRB,4.2895E-01_JPRB,3.9755E-01_JPRB,3.5824E-01_JPRB,3.1313E-01_JPRB,&
&2.6208E-01_JPRB,1.9974E-01_JPRB,1.6634E-01_JPRB,1.6696E-01_JPRB,1.7273E-01_JPRB/)
KAO( :, 4, 1, 8) = (/&
&4.8664E-01_JPRB,4.6279E-01_JPRB,4.3774E-01_JPRB,4.0881E-01_JPRB,3.7103E-01_JPRB,3.2868E-01_JPRB,&
&2.7711E-01_JPRB,2.1740E-01_JPRB,1.9172E-01_JPRB,1.9403E-01_JPRB,2.0091E-01_JPRB/)
KAO( :, 5, 1, 8) = (/&
&4.8428E-01_JPRB,4.6664E-01_JPRB,4.4704E-01_JPRB,4.1926E-01_JPRB,3.8405E-01_JPRB,3.4407E-01_JPRB,&
&2.9186E-01_JPRB,2.3664E-01_JPRB,2.1906E-01_JPRB,2.2276E-01_JPRB,2.3078E-01_JPRB/)
KAO( :, 1, 2, 8) = (/&
&5.0098E-01_JPRB,4.5838E-01_JPRB,4.1902E-01_JPRB,3.7538E-01_JPRB,3.3034E-01_JPRB,2.7973E-01_JPRB,&
&2.2195E-01_JPRB,1.5668E-01_JPRB,1.0587E-01_JPRB,9.8490E-02_JPRB,1.0033E-01_JPRB/)
KAO( :, 2, 2, 8) = (/&
&4.9983E-01_JPRB,4.6235E-01_JPRB,4.2661E-01_JPRB,3.8655E-01_JPRB,3.4282E-01_JPRB,2.9301E-01_JPRB,&
&2.3610E-01_JPRB,1.7056E-01_JPRB,1.2318E-01_JPRB,1.1876E-01_JPRB,1.2114E-01_JPRB/)
KAO( :, 3, 2, 8) = (/&
&4.9812E-01_JPRB,4.6732E-01_JPRB,4.3492E-01_JPRB,3.9791E-01_JPRB,3.5518E-01_JPRB,3.0663E-01_JPRB,&
&2.5073E-01_JPRB,1.8486E-01_JPRB,1.4281E-01_JPRB,1.4075E-01_JPRB,1.4376E-01_JPRB/)
KAO( :, 4, 2, 8) = (/&
&4.9623E-01_JPRB,4.7200E-01_JPRB,4.4361E-01_JPRB,4.0869E-01_JPRB,3.6716E-01_JPRB,3.2094E-01_JPRB,&
&2.6503E-01_JPRB,2.0038E-01_JPRB,1.6450E-01_JPRB,1.6447E-01_JPRB,1.6812E-01_JPRB/)
KAO( :, 5, 2, 8) = (/&
&4.9443E-01_JPRB,4.7565E-01_JPRB,4.5245E-01_JPRB,4.1884E-01_JPRB,3.7991E-01_JPRB,3.3502E-01_JPRB,&
&2.7893E-01_JPRB,2.1726E-01_JPRB,1.8823E-01_JPRB,1.8992E-01_JPRB,1.9426E-01_JPRB/)
KAO( :, 1, 3, 8) = (/&
&5.0316E-01_JPRB,4.6054E-01_JPRB,4.1948E-01_JPRB,3.7358E-01_JPRB,3.2537E-01_JPRB,2.7199E-01_JPRB,&
&2.1201E-01_JPRB,1.4405E-01_JPRB,9.1061E-02_JPRB,7.8216E-02_JPRB,7.8431E-02_JPRB/)
KAO( :, 2, 3, 8) = (/&
&5.0250E-01_JPRB,4.6508E-01_JPRB,4.2753E-01_JPRB,3.8448E-01_JPRB,3.3743E-01_JPRB,2.8477E-01_JPRB,&
&2.2471E-01_JPRB,1.5690E-01_JPRB,1.0463E-01_JPRB,9.5297E-02_JPRB,9.5775E-02_JPRB/)
KAO( :, 3, 3, 8) = (/&
&5.0156E-01_JPRB,4.7034E-01_JPRB,4.3587E-01_JPRB,3.9592E-01_JPRB,3.4938E-01_JPRB,2.9738E-01_JPRB,&
&2.3781E-01_JPRB,1.6990E-01_JPRB,1.2021E-01_JPRB,1.1406E-01_JPRB,1.1481E-01_JPRB/)
KAO( :, 4, 3, 8) = (/&
&5.0040E-01_JPRB,4.7526E-01_JPRB,4.4463E-01_JPRB,4.0641E-01_JPRB,3.6112E-01_JPRB,3.1063E-01_JPRB,&
&2.5089E-01_JPRB,1.8361E-01_JPRB,1.3795E-01_JPRB,1.3453E-01_JPRB,1.3558E-01_JPRB/)
KAO( :, 5, 3, 8) = (/&
&4.9904E-01_JPRB,4.7934E-01_JPRB,4.5345E-01_JPRB,4.1619E-01_JPRB,3.7327E-01_JPRB,3.2376E-01_JPRB,&
&2.6376E-01_JPRB,1.9847E-01_JPRB,1.5778E-01_JPRB,1.5659E-01_JPRB,1.5798E-01_JPRB/)
KAO( :, 1, 4, 8) = (/&
&4.9806E-01_JPRB,4.5577E-01_JPRB,4.1390E-01_JPRB,3.6716E-01_JPRB,3.1756E-01_JPRB,2.6347E-01_JPRB,&
&2.0234E-01_JPRB,1.3271E-01_JPRB,7.8950E-02_JPRB,6.0980E-02_JPRB,6.0379E-02_JPRB/)
KAO( :, 2, 4, 8) = (/&
&4.9826E-01_JPRB,4.6101E-01_JPRB,4.2242E-01_JPRB,3.7800E-01_JPRB,3.3007E-01_JPRB,2.7585E-01_JPRB,&
&2.1397E-01_JPRB,1.4413E-01_JPRB,8.9794E-02_JPRB,7.4947E-02_JPRB,7.4639E-02_JPRB/)
KAO( :, 3, 4, 8) = (/&
&4.9811E-01_JPRB,4.6681E-01_JPRB,4.3096E-01_JPRB,3.8962E-01_JPRB,3.4219E-01_JPRB,2.8784E-01_JPRB,&
&2.2620E-01_JPRB,1.5584E-01_JPRB,1.0227E-01_JPRB,9.0609E-02_JPRB,9.0488E-02_JPRB/)
KAO( :, 4, 4, 8) = (/&
&4.9746E-01_JPRB,4.7213E-01_JPRB,4.3992E-01_JPRB,4.0060E-01_JPRB,3.5359E-01_JPRB,3.0001E-01_JPRB,&
&2.3826E-01_JPRB,1.6835E-01_JPRB,1.1655E-01_JPRB,1.0791E-01_JPRB,1.0795E-01_JPRB/)
KAO( :, 5, 4, 8) = (/&
&4.9635E-01_JPRB,4.7672E-01_JPRB,4.4914E-01_JPRB,4.1061E-01_JPRB,3.6511E-01_JPRB,3.1218E-01_JPRB,&
&2.5028E-01_JPRB,1.8187E-01_JPRB,1.3226E-01_JPRB,1.2654E-01_JPRB,1.2673E-01_JPRB/)
KAO( :, 1, 5, 8) = (/&
&4.8638E-01_JPRB,4.4445E-01_JPRB,4.0240E-01_JPRB,3.5595E-01_JPRB,3.0624E-01_JPRB,2.5236E-01_JPRB,&
&1.9246E-01_JPRB,1.2312E-01_JPRB,6.9001E-02_JPRB,4.7715E-02_JPRB,4.6683E-02_JPRB/)
KAO( :, 2, 5, 8) = (/&
&4.8710E-01_JPRB,4.5014E-01_JPRB,4.1145E-01_JPRB,3.6700E-01_JPRB,3.1862E-01_JPRB,2.6463E-01_JPRB,&
&2.0376E-01_JPRB,1.3331E-01_JPRB,7.8352E-02_JPRB,5.8722E-02_JPRB,5.8068E-02_JPRB/)
KAO( :, 3, 5, 8) = (/&
&4.8733E-01_JPRB,4.5646E-01_JPRB,4.2038E-01_JPRB,3.7871E-01_JPRB,3.3086E-01_JPRB,2.7657E-01_JPRB,&
&2.1509E-01_JPRB,1.4382E-01_JPRB,8.8703E-02_JPRB,7.1451E-02_JPRB,7.1075E-02_JPRB/)
KAO( :, 4, 5, 8) = (/&
&4.8688E-01_JPRB,4.6221E-01_JPRB,4.2956E-01_JPRB,3.8977E-01_JPRB,3.4249E-01_JPRB,2.8843E-01_JPRB,&
&2.2638E-01_JPRB,1.5517E-01_JPRB,1.0010E-01_JPRB,8.5586E-02_JPRB,8.5398E-02_JPRB/)
KAO( :, 5, 5, 8) = (/&
&4.8605E-01_JPRB,4.6725E-01_JPRB,4.3887E-01_JPRB,4.0002E-01_JPRB,3.5369E-01_JPRB,3.0008E-01_JPRB,&
&2.3780E-01_JPRB,1.6738E-01_JPRB,1.1249E-01_JPRB,1.0093E-01_JPRB,1.0091E-01_JPRB/)
KAO( :, 1, 6, 8) = (/&
&4.6671E-01_JPRB,4.2600E-01_JPRB,3.8466E-01_JPRB,3.3926E-01_JPRB,2.9061E-01_JPRB,2.3768E-01_JPRB,&
&1.7963E-01_JPRB,1.1420E-01_JPRB,6.0552E-02_JPRB,3.7850E-02_JPRB,4.1921E-02_JPRB/)
KAO( :, 2, 6, 8) = (/&
&4.6803E-01_JPRB,4.3203E-01_JPRB,3.9392E-01_JPRB,3.5053E-01_JPRB,3.0269E-01_JPRB,2.4962E-01_JPRB,&
&1.9077E-01_JPRB,1.2351E-01_JPRB,6.8512E-02_JPRB,4.6284E-02_JPRB,5.0049E-02_JPRB/)
KAO( :, 3, 6, 8) = (/&
&4.6842E-01_JPRB,4.3840E-01_JPRB,4.0304E-01_JPRB,3.6198E-01_JPRB,3.1472E-01_JPRB,2.6142E-01_JPRB,&
&2.0201E-01_JPRB,1.3304E-01_JPRB,7.7462E-02_JPRB,5.6089E-02_JPRB,5.9440E-02_JPRB/)
KAO( :, 4, 6, 8) = (/&
&4.6834E-01_JPRB,4.4438E-01_JPRB,4.1233E-01_JPRB,3.7291E-01_JPRB,3.2609E-01_JPRB,2.7299E-01_JPRB,&
&2.1298E-01_JPRB,1.4322E-01_JPRB,8.7054E-02_JPRB,6.7233E-02_JPRB,7.0024E-02_JPRB/)
KAO( :, 5, 6, 8) = (/&
&4.6792E-01_JPRB,4.4990E-01_JPRB,4.2136E-01_JPRB,3.8305E-01_JPRB,3.3708E-01_JPRB,2.8431E-01_JPRB,&
&2.2411E-01_JPRB,1.5430E-01_JPRB,9.7088E-02_JPRB,7.9618E-02_JPRB,8.1792E-02_JPRB/)
KAO( :, 1, 7, 8) = (/&
&4.3699E-01_JPRB,3.9837E-01_JPRB,3.5896E-01_JPRB,3.1590E-01_JPRB,2.6958E-01_JPRB,2.1919E-01_JPRB,&
&1.6418E-01_JPRB,1.0344E-01_JPRB,5.3382E-02_JPRB,3.0831E-02_JPRB,4.2953E-02_JPRB/)
KAO( :, 2, 7, 8) = (/&
&4.3843E-01_JPRB,4.0448E-01_JPRB,3.6812E-01_JPRB,3.2701E-01_JPRB,2.8124E-01_JPRB,2.3050E-01_JPRB,&
&1.7482E-01_JPRB,1.1234E-01_JPRB,6.0200E-02_JPRB,3.7229E-02_JPRB,5.0680E-02_JPRB/)
KAO( :, 3, 7, 8) = (/&
&4.3919E-01_JPRB,4.1086E-01_JPRB,3.7731E-01_JPRB,3.3799E-01_JPRB,2.9265E-01_JPRB,2.4169E-01_JPRB,&
&1.8565E-01_JPRB,1.2131E-01_JPRB,6.7916E-02_JPRB,4.4736E-02_JPRB,5.9303E-02_JPRB/)
KAO( :, 4, 7, 8) = (/&
&4.3964E-01_JPRB,4.1709E-01_JPRB,3.8642E-01_JPRB,3.4844E-01_JPRB,3.0343E-01_JPRB,2.5289E-01_JPRB,&
&1.9633E-01_JPRB,1.3094E-01_JPRB,7.6222E-02_JPRB,5.3326E-02_JPRB,6.8509E-02_JPRB/)
KAO( :, 5, 7, 8) = (/&
&4.3947E-01_JPRB,4.2288E-01_JPRB,3.9537E-01_JPRB,3.5832E-01_JPRB,3.1399E-01_JPRB,2.6369E-01_JPRB,&
&2.0720E-01_JPRB,1.4134E-01_JPRB,8.4840E-02_JPRB,6.3000E-02_JPRB,7.8182E-02_JPRB/)
KAO( :, 1, 8, 8) = (/&
&4.0095E-01_JPRB,3.6508E-01_JPRB,3.2839E-01_JPRB,2.8828E-01_JPRB,2.4526E-01_JPRB,1.9846E-01_JPRB,&
&1.4746E-01_JPRB,9.1777E-02_JPRB,4.6862E-02_JPRB,2.5767E-02_JPRB,4.9298E-02_JPRB/)
KAO( :, 2, 8, 8) = (/&
&4.0247E-01_JPRB,3.7108E-01_JPRB,3.3718E-01_JPRB,2.9895E-01_JPRB,2.5608E-01_JPRB,2.0883E-01_JPRB,&
&1.5736E-01_JPRB,1.0019E-01_JPRB,5.2944E-02_JPRB,3.0729E-02_JPRB,5.6721E-02_JPRB/)
KAO( :, 3, 8, 8) = (/&
&4.0379E-01_JPRB,3.7769E-01_JPRB,3.4624E-01_JPRB,3.0913E-01_JPRB,2.6652E-01_JPRB,2.1917E-01_JPRB,&
&1.6744E-01_JPRB,1.0879E-01_JPRB,5.9618E-02_JPRB,3.6479E-02_JPRB,6.5019E-02_JPRB/)
KAO( :, 4, 8, 8) = (/&
&4.0440E-01_JPRB,3.8393E-01_JPRB,3.5518E-01_JPRB,3.1911E-01_JPRB,2.7671E-01_JPRB,2.2954E-01_JPRB,&
&1.7755E-01_JPRB,1.1776E-01_JPRB,6.6811E-02_JPRB,4.3078E-02_JPRB,7.4113E-02_JPRB/)
KAO( :, 5, 8, 8) = (/&
&4.0446E-01_JPRB,3.8965E-01_JPRB,3.6366E-01_JPRB,3.2844E-01_JPRB,2.8667E-01_JPRB,2.3995E-01_JPRB,&
&1.8784E-01_JPRB,1.2743E-01_JPRB,7.4347E-02_JPRB,5.0583E-02_JPRB,8.3692E-02_JPRB/)
KAO( :, 1, 9, 8) = (/&
&3.6220E-01_JPRB,3.2943E-01_JPRB,2.9565E-01_JPRB,2.5888E-01_JPRB,2.1956E-01_JPRB,1.7688E-01_JPRB,&
&1.3053E-01_JPRB,8.0073E-02_JPRB,4.0469E-02_JPRB,2.1839E-02_JPRB,9.4199E-02_JPRB/)
KAO( :, 2, 9, 8) = (/&
&3.6411E-01_JPRB,3.3547E-01_JPRB,3.0414E-01_JPRB,2.6872E-01_JPRB,2.2935E-01_JPRB,1.8612E-01_JPRB,&
&1.3939E-01_JPRB,8.7821E-02_JPRB,4.5931E-02_JPRB,2.5820E-02_JPRB,1.0332E-01_JPRB/)
KAO( :, 3, 9, 8) = (/&
&3.6566E-01_JPRB,3.4191E-01_JPRB,3.1284E-01_JPRB,2.7831E-01_JPRB,2.3893E-01_JPRB,1.9553E-01_JPRB,&
&1.4849E-01_JPRB,9.5850E-02_JPRB,5.1870E-02_JPRB,3.0419E-02_JPRB,1.1365E-01_JPRB/)
KAO( :, 4, 9, 8) = (/&
&3.6634E-01_JPRB,3.4783E-01_JPRB,3.2112E-01_JPRB,2.8747E-01_JPRB,2.4838E-01_JPRB,2.0518E-01_JPRB,&
&1.5786E-01_JPRB,1.0419E-01_JPRB,5.8269E-02_JPRB,3.5620E-02_JPRB,1.2479E-01_JPRB/)
KAO( :, 5, 9, 8) = (/&
&3.6687E-01_JPRB,3.5352E-01_JPRB,3.2900E-01_JPRB,2.9611E-01_JPRB,2.5769E-01_JPRB,2.1498E-01_JPRB,&
&1.6749E-01_JPRB,1.1307E-01_JPRB,6.4929E-02_JPRB,4.1475E-02_JPRB,1.3690E-01_JPRB/)
KAO( :, 1,10, 8) = (/&
&3.2199E-01_JPRB,2.9278E-01_JPRB,2.6222E-01_JPRB,2.2905E-01_JPRB,1.9373E-01_JPRB,1.5558E-01_JPRB,&
&1.1424E-01_JPRB,6.9413E-02_JPRB,3.4798E-02_JPRB,1.8896E-02_JPRB,2.8335E-01_JPRB/)
KAO( :, 2,10, 8) = (/&
&3.2419E-01_JPRB,2.9882E-01_JPRB,2.7031E-01_JPRB,2.3822E-01_JPRB,2.0265E-01_JPRB,1.6381E-01_JPRB,&
&1.2203E-01_JPRB,7.6200E-02_JPRB,3.9653E-02_JPRB,2.2203E-02_JPRB,3.0010E-01_JPRB/)
KAO( :, 3,10, 8) = (/&
&3.2557E-01_JPRB,3.0468E-01_JPRB,2.7841E-01_JPRB,2.4694E-01_JPRB,2.1134E-01_JPRB,1.7240E-01_JPRB,&
&1.3024E-01_JPRB,8.3423E-02_JPRB,4.4862E-02_JPRB,2.6006E-02_JPRB,3.2041E-01_JPRB/)
KAO( :, 4,10, 8) = (/&
&3.2676E-01_JPRB,3.1040E-01_JPRB,2.8596E-01_JPRB,2.5507E-01_JPRB,2.1988E-01_JPRB,1.8121E-01_JPRB,&
&1.3879E-01_JPRB,9.0984E-02_JPRB,5.0519E-02_JPRB,3.0296E-02_JPRB,3.4283E-01_JPRB/)
KAO( :, 5,10, 8) = (/&
&3.2756E-01_JPRB,3.1604E-01_JPRB,2.9325E-01_JPRB,2.6321E-01_JPRB,2.2857E-01_JPRB,1.9016E-01_JPRB,&
&1.4762E-01_JPRB,9.9000E-02_JPRB,5.6488E-02_JPRB,3.5105E-02_JPRB,3.6677E-01_JPRB/)
KAO( :, 1,11, 8) = (/&
&2.8411E-01_JPRB,2.5988E-01_JPRB,2.3321E-01_JPRB,2.0412E-01_JPRB,1.7249E-01_JPRB,1.3838E-01_JPRB,&
&1.0172E-01_JPRB,6.2178E-02_JPRB,3.1646E-02_JPRB,1.7506E-02_JPRB,3.9917E-01_JPRB/)
KAO( :, 2,11, 8) = (/&
&2.8582E-01_JPRB,2.6534E-01_JPRB,2.4057E-01_JPRB,2.1213E-01_JPRB,1.8034E-01_JPRB,1.4593E-01_JPRB,&
&1.0888E-01_JPRB,6.8210E-02_JPRB,3.6011E-02_JPRB,2.0567E-02_JPRB,4.2270E-01_JPRB/)
KAO( :, 3,11, 8) = (/&
&2.8739E-01_JPRB,2.7084E-01_JPRB,2.4780E-01_JPRB,2.1959E-01_JPRB,1.8803E-01_JPRB,1.5372E-01_JPRB,&
&1.1636E-01_JPRB,7.4695E-02_JPRB,4.0724E-02_JPRB,2.3986E-02_JPRB,4.4934E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&2.8878E-01_JPRB,2.7644E-01_JPRB,2.5472E-01_JPRB,2.2709E-01_JPRB,1.9597E-01_JPRB,1.6177E-01_JPRB,&
&1.2408E-01_JPRB,8.1642E-02_JPRB,4.5765E-02_JPRB,2.7772E-02_JPRB,4.7717E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&2.8955E-01_JPRB,2.8144E-01_JPRB,2.6102E-01_JPRB,2.3454E-01_JPRB,2.0411E-01_JPRB,1.7002E-01_JPRB,&
&1.3228E-01_JPRB,8.8823E-02_JPRB,5.1141E-02_JPRB,3.2010E-02_JPRB,5.0557E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&2.4710E-01_JPRB,2.2747E-01_JPRB,2.0446E-01_JPRB,1.7910E-01_JPRB,1.5126E-01_JPRB,1.2141E-01_JPRB,&
&8.9466E-02_JPRB,5.4973E-02_JPRB,2.8499E-02_JPRB,1.5999E-02_JPRB,4.2800E-01_JPRB/)
KAO( :, 2,12, 8) = (/&
&2.4901E-01_JPRB,2.3258E-01_JPRB,2.1111E-01_JPRB,1.8597E-01_JPRB,1.5805E-01_JPRB,1.2818E-01_JPRB,&
&9.5808E-02_JPRB,6.0321E-02_JPRB,3.2343E-02_JPRB,1.8809E-02_JPRB,4.5340E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&2.5080E-01_JPRB,2.3792E-01_JPRB,2.1766E-01_JPRB,1.9271E-01_JPRB,1.6525E-01_JPRB,1.3521E-01_JPRB,&
&1.0253E-01_JPRB,6.6046E-02_JPRB,3.6536E-02_JPRB,2.1931E-02_JPRB,4.7921E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&2.5204E-01_JPRB,2.4277E-01_JPRB,2.2355E-01_JPRB,1.9948E-01_JPRB,1.7252E-01_JPRB,1.4258E-01_JPRB,&
&1.0952E-01_JPRB,7.2180E-02_JPRB,4.1025E-02_JPRB,2.5368E-02_JPRB,5.0641E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&2.5346E-01_JPRB,2.4761E-01_JPRB,2.2936E-01_JPRB,2.0632E-01_JPRB,1.7985E-01_JPRB,1.5006E-01_JPRB,&
&1.1690E-01_JPRB,7.8517E-02_JPRB,4.5825E-02_JPRB,2.9158E-02_JPRB,5.3542E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&2.1104E-01_JPRB,1.9539E-01_JPRB,1.7591E-01_JPRB,1.5396E-01_JPRB,1.2999E-01_JPRB,1.0448E-01_JPRB,&
&7.7298E-02_JPRB,4.7962E-02_JPRB,2.5275E-02_JPRB,1.4360E-02_JPRB,3.6245E-01_JPRB/)
KAO( :, 2,13, 8) = (/&
&2.1306E-01_JPRB,2.0027E-01_JPRB,1.8186E-01_JPRB,1.6010E-01_JPRB,1.3622E-01_JPRB,1.1063E-01_JPRB,&
&8.2888E-02_JPRB,5.2545E-02_JPRB,2.8685E-02_JPRB,1.6930E-02_JPRB,3.8275E-01_JPRB/)
KAO( :, 3,13, 8) = (/&
&2.1469E-01_JPRB,2.0496E-01_JPRB,1.8742E-01_JPRB,1.6612E-01_JPRB,1.4267E-01_JPRB,1.1693E-01_JPRB,&
&8.8832E-02_JPRB,5.7525E-02_JPRB,3.2378E-02_JPRB,1.9762E-02_JPRB,4.0424E-01_JPRB/)
KAO( :, 4,13, 8) = (/&
&2.1644E-01_JPRB,2.0961E-01_JPRB,1.9285E-01_JPRB,1.7222E-01_JPRB,1.4919E-01_JPRB,1.2339E-01_JPRB,&
&9.4996E-02_JPRB,6.2832E-02_JPRB,3.6346E-02_JPRB,2.2885E-02_JPRB,4.2761E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&2.1812E-01_JPRB,2.1428E-01_JPRB,1.9853E-01_JPRB,1.7877E-01_JPRB,1.5586E-01_JPRB,1.3014E-01_JPRB,&
&1.0138E-01_JPRB,6.8371E-02_JPRB,4.0590E-02_JPRB,2.6305E-02_JPRB,4.5224E-01_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB9_A1
