!OCL SCALAR
SUBROUTINE RRTM_KGB7_BB

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 7:  980-1080 cm-1 (low - H2O,O3; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO7 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,ABSCO2O
USE YOERRTA7 , ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
&5.1259E-02_JPRB,7.3611E-02_JPRB,1.0293E-01_JPRB,1.3958E-01_JPRB,1.8370E-01_JPRB/)
KBO( :,14, 1) = (/&
&4.5713E-02_JPRB,6.5277E-02_JPRB,9.0553E-02_JPRB,1.2145E-01_JPRB,1.5795E-01_JPRB/)
KBO( :,15, 1) = (/&
&4.0795E-02_JPRB,5.7938E-02_JPRB,7.9664E-02_JPRB,1.0581E-01_JPRB,1.3605E-01_JPRB/)
KBO( :,16, 1) = (/&
&3.6460E-02_JPRB,5.1532E-02_JPRB,7.0278E-02_JPRB,9.2517E-02_JPRB,1.1775E-01_JPRB/)
KBO( :,17, 1) = (/&
&3.2358E-02_JPRB,4.5390E-02_JPRB,6.1388E-02_JPRB,8.0070E-02_JPRB,1.0088E-01_JPRB/)
KBO( :,18, 1) = (/&
&2.8485E-02_JPRB,3.9634E-02_JPRB,5.3109E-02_JPRB,6.8586E-02_JPRB,8.5607E-02_JPRB/)
KBO( :,19, 1) = (/&
&2.4839E-02_JPRB,3.4251E-02_JPRB,4.5451E-02_JPRB,5.8119E-02_JPRB,7.1935E-02_JPRB/)
KBO( :,20, 1) = (/&
&2.1646E-02_JPRB,2.9549E-02_JPRB,3.8829E-02_JPRB,4.9218E-02_JPRB,6.0534E-02_JPRB/)
KBO( :,21, 1) = (/&
&1.8726E-02_JPRB,2.5319E-02_JPRB,3.2990E-02_JPRB,4.1539E-02_JPRB,5.0831E-02_JPRB/)
KBO( :,22, 1) = (/&
&1.6430E-02_JPRB,2.1972E-02_JPRB,2.8373E-02_JPRB,3.5469E-02_JPRB,4.3144E-02_JPRB/)
KBO( :,23, 1) = (/&
&1.4344E-02_JPRB,1.9007E-02_JPRB,2.4347E-02_JPRB,3.0236E-02_JPRB,3.6575E-02_JPRB/)
KBO( :,24, 1) = (/&
&1.2498E-02_JPRB,1.6422E-02_JPRB,2.0874E-02_JPRB,2.5759E-02_JPRB,3.0990E-02_JPRB/)
KBO( :,25, 1) = (/&
&1.0890E-02_JPRB,1.4194E-02_JPRB,1.7906E-02_JPRB,2.1962E-02_JPRB,2.6282E-02_JPRB/)
KBO( :,26, 1) = (/&
&9.5169E-03_JPRB,1.2303E-02_JPRB,1.5406E-02_JPRB,1.8780E-02_JPRB,2.2347E-02_JPRB/)
KBO( :,27, 1) = (/&
&8.3127E-03_JPRB,1.0661E-02_JPRB,1.3260E-02_JPRB,1.6073E-02_JPRB,1.9015E-02_JPRB/)
KBO( :,28, 1) = (/&
&7.2555E-03_JPRB,9.2333E-03_JPRB,1.1414E-02_JPRB,1.3752E-02_JPRB,1.6182E-02_JPRB/)
KBO( :,29, 1) = (/&
&6.3460E-03_JPRB,8.0168E-03_JPRB,9.8497E-03_JPRB,1.1797E-02_JPRB,1.3808E-02_JPRB/)
KBO( :,30, 1) = (/&
&5.5479E-03_JPRB,6.9613E-03_JPRB,8.4972E-03_JPRB,1.0118E-02_JPRB,1.1783E-02_JPRB/)
KBO( :,31, 1) = (/&
&4.8584E-03_JPRB,6.0543E-03_JPRB,7.3446E-03_JPRB,8.6964E-03_JPRB,1.0081E-02_JPRB/)
KBO( :,32, 1) = (/&
&4.2533E-03_JPRB,5.2649E-03_JPRB,6.3493E-03_JPRB,7.4778E-03_JPRB,8.6341E-03_JPRB/)
KBO( :,33, 1) = (/&
&3.7229E-03_JPRB,4.5793E-03_JPRB,5.4910E-03_JPRB,6.4373E-03_JPRB,7.4041E-03_JPRB/)
KBO( :,34, 1) = (/&
&3.2276E-03_JPRB,3.9492E-03_JPRB,4.7134E-03_JPRB,5.5048E-03_JPRB,6.3115E-03_JPRB/)
KBO( :,35, 1) = (/&
&2.7399E-03_JPRB,3.3442E-03_JPRB,3.9827E-03_JPRB,4.6441E-03_JPRB,5.3183E-03_JPRB/)
KBO( :,36, 1) = (/&
&2.2726E-03_JPRB,2.7751E-03_JPRB,3.3064E-03_JPRB,3.8585E-03_JPRB,4.4216E-03_JPRB/)
KBO( :,37, 1) = (/&
&1.8221E-03_JPRB,2.2350E-03_JPRB,2.6736E-03_JPRB,3.1310E-03_JPRB,3.5993E-03_JPRB/)
KBO( :,38, 1) = (/&
&1.4592E-03_JPRB,1.7985E-03_JPRB,2.1611E-03_JPRB,2.5404E-03_JPRB,2.9304E-03_JPRB/)
KBO( :,39, 1) = (/&
&1.1699E-03_JPRB,1.4493E-03_JPRB,1.7501E-03_JPRB,2.0658E-03_JPRB,2.3919E-03_JPRB/)
KBO( :,40, 1) = (/&
&9.1194E-04_JPRB,1.1380E-03_JPRB,1.3840E-03_JPRB,1.6433E-03_JPRB,1.9130E-03_JPRB/)
KBO( :,41, 1) = (/&
&7.0723E-04_JPRB,8.8961E-04_JPRB,1.0899E-03_JPRB,1.3025E-03_JPRB,1.5252E-03_JPRB/)
KBO( :,42, 1) = (/&
&5.4756E-04_JPRB,6.9456E-04_JPRB,8.5764E-04_JPRB,1.0321E-03_JPRB,1.2157E-03_JPRB/)
KBO( :,43, 1) = (/&
&4.1699E-04_JPRB,5.3448E-04_JPRB,6.6629E-04_JPRB,8.0890E-04_JPRB,9.6007E-04_JPRB/)
KBO( :,44, 1) = (/&
&3.1440E-04_JPRB,4.0792E-04_JPRB,5.1407E-04_JPRB,6.3038E-04_JPRB,7.5481E-04_JPRB/)
KBO( :,45, 1) = (/&
&2.3640E-04_JPRB,3.1074E-04_JPRB,3.9606E-04_JPRB,4.9085E-04_JPRB,5.9335E-04_JPRB/)
KBO( :,46, 1) = (/&
&1.7594E-04_JPRB,2.3455E-04_JPRB,3.0267E-04_JPRB,3.7967E-04_JPRB,4.6391E-04_JPRB/)
KBO( :,47, 1) = (/&
&1.2843E-04_JPRB,1.7389E-04_JPRB,2.2775E-04_JPRB,2.8951E-04_JPRB,3.5820E-04_JPRB/)
KBO( :,48, 1) = (/&
&9.3343E-05_JPRB,1.2837E-04_JPRB,1.7092E-04_JPRB,2.2045E-04_JPRB,2.7649E-04_JPRB/)
KBO( :,49, 1) = (/&
&6.7599E-05_JPRB,9.4536E-05_JPRB,1.2808E-04_JPRB,1.6786E-04_JPRB,2.1369E-04_JPRB/)
KBO( :,50, 1) = (/&
&4.8948E-05_JPRB,6.9502E-05_JPRB,9.5623E-05_JPRB,1.2729E-04_JPRB,1.6435E-04_JPRB/)
KBO( :,51, 1) = (/&
&3.5346E-05_JPRB,5.0921E-05_JPRB,7.1079E-05_JPRB,9.6095E-05_JPRB,1.2578E-04_JPRB/)
KBO( :,52, 1) = (/&
&2.5450E-05_JPRB,3.7196E-05_JPRB,5.2726E-05_JPRB,7.2442E-05_JPRB,9.6232E-05_JPRB/)
KBO( :,53, 1) = (/&
&1.8296E-05_JPRB,2.7103E-05_JPRB,3.9075E-05_JPRB,5.4599E-05_JPRB,7.3735E-05_JPRB/)
KBO( :,54, 1) = (/&
&1.3152E-05_JPRB,1.9639E-05_JPRB,2.8663E-05_JPRB,4.0549E-05_JPRB,5.5484E-05_JPRB/)
KBO( :,55, 1) = (/&
&9.4445E-06_JPRB,1.4166E-05_JPRB,2.0853E-05_JPRB,2.9772E-05_JPRB,4.1184E-05_JPRB/)
KBO( :,56, 1) = (/&
&6.7805E-06_JPRB,1.0206E-05_JPRB,1.5127E-05_JPRB,2.1803E-05_JPRB,3.0469E-05_JPRB/)
KBO( :,57, 1) = (/&
&4.8676E-06_JPRB,7.3427E-06_JPRB,1.0945E-05_JPRB,1.5922E-05_JPRB,2.2468E-05_JPRB/)
KBO( :,58, 1) = (/&
&3.5190E-06_JPRB,5.3050E-06_JPRB,7.9365E-06_JPRB,1.1632E-05_JPRB,1.6547E-05_JPRB/)
KBO( :,59, 1) = (/&
&2.7224E-06_JPRB,4.0826E-06_JPRB,6.0785E-06_JPRB,8.8720E-06_JPRB,1.2572E-05_JPRB/)
KBO( :,13, 2) = (/&
&2.7119E-01_JPRB,3.6310E-01_JPRB,4.7414E-01_JPRB,6.0307E-01_JPRB,7.4957E-01_JPRB/)
KBO( :,14, 2) = (/&
&2.5353E-01_JPRB,3.3756E-01_JPRB,4.3733E-01_JPRB,5.5227E-01_JPRB,6.8177E-01_JPRB/)
KBO( :,15, 2) = (/&
&2.3613E-01_JPRB,3.1296E-01_JPRB,4.0272E-01_JPRB,5.0521E-01_JPRB,6.1950E-01_JPRB/)
KBO( :,16, 2) = (/&
&2.1883E-01_JPRB,2.8892E-01_JPRB,3.7007E-01_JPRB,4.6171E-01_JPRB,5.6222E-01_JPRB/)
KBO( :,17, 2) = (/&
&2.0046E-01_JPRB,2.6387E-01_JPRB,3.3671E-01_JPRB,4.1802E-01_JPRB,5.0615E-01_JPRB/)
KBO( :,18, 2) = (/&
&1.8162E-01_JPRB,2.3837E-01_JPRB,3.0306E-01_JPRB,3.7451E-01_JPRB,4.5033E-01_JPRB/)
KBO( :,19, 2) = (/&
&1.6273E-01_JPRB,2.1280E-01_JPRB,2.6942E-01_JPRB,3.3081E-01_JPRB,3.9474E-01_JPRB/)
KBO( :,20, 2) = (/&
&1.4529E-01_JPRB,1.8899E-01_JPRB,2.3756E-01_JPRB,2.8972E-01_JPRB,3.4258E-01_JPRB/)
KBO( :,21, 2) = (/&
&1.2870E-01_JPRB,1.6616E-01_JPRB,2.0730E-01_JPRB,2.5076E-01_JPRB,2.9377E-01_JPRB/)
KBO( :,22, 2) = (/&
&1.1499E-01_JPRB,1.4695E-01_JPRB,1.8158E-01_JPRB,2.1711E-01_JPRB,2.5164E-01_JPRB/)
KBO( :,23, 2) = (/&
&1.0194E-01_JPRB,1.2892E-01_JPRB,1.5758E-01_JPRB,1.8624E-01_JPRB,2.1370E-01_JPRB/)
KBO( :,24, 2) = (/&
&8.9789E-02_JPRB,1.1229E-01_JPRB,1.3567E-01_JPRB,1.5862E-01_JPRB,1.8060E-01_JPRB/)
KBO( :,25, 2) = (/&
&7.8662E-02_JPRB,9.7205E-02_JPRB,1.1609E-01_JPRB,1.3460E-01_JPRB,1.5226E-01_JPRB/)
KBO( :,26, 2) = (/&
&6.8677E-02_JPRB,8.3839E-02_JPRB,9.9146E-02_JPRB,1.1408E-01_JPRB,1.2832E-01_JPRB/)
KBO( :,27, 2) = (/&
&5.9597E-02_JPRB,7.2017E-02_JPRB,8.4456E-02_JPRB,9.6525E-02_JPRB,1.0804E-01_JPRB/)
KBO( :,28, 2) = (/&
&5.1479E-02_JPRB,6.1677E-02_JPRB,7.1788E-02_JPRB,8.1553E-02_JPRB,9.0870E-02_JPRB/)
KBO( :,29, 2) = (/&
&4.4418E-02_JPRB,5.2773E-02_JPRB,6.1008E-02_JPRB,6.8941E-02_JPRB,7.6507E-02_JPRB/)
KBO( :,30, 2) = (/&
&3.8240E-02_JPRB,4.5084E-02_JPRB,5.1802E-02_JPRB,5.8270E-02_JPRB,6.4403E-02_JPRB/)
KBO( :,31, 2) = (/&
&3.2906E-02_JPRB,3.8522E-02_JPRB,4.4011E-02_JPRB,4.9308E-02_JPRB,5.4268E-02_JPRB/)
KBO( :,32, 2) = (/&
&2.8286E-02_JPRB,3.2899E-02_JPRB,3.7402E-02_JPRB,4.1721E-02_JPRB,4.5728E-02_JPRB/)
KBO( :,33, 2) = (/&
&2.4296E-02_JPRB,2.8097E-02_JPRB,3.1779E-02_JPRB,3.5285E-02_JPRB,3.8510E-02_JPRB/)
KBO( :,34, 2) = (/&
&2.0730E-02_JPRB,2.3844E-02_JPRB,2.6852E-02_JPRB,2.9683E-02_JPRB,3.2295E-02_JPRB/)
KBO( :,35, 2) = (/&
&1.7417E-02_JPRB,1.9970E-02_JPRB,2.2433E-02_JPRB,2.4741E-02_JPRB,2.6876E-02_JPRB/)
KBO( :,36, 2) = (/&
&1.4391E-02_JPRB,1.6493E-02_JPRB,1.8520E-02_JPRB,2.0421E-02_JPRB,2.2183E-02_JPRB/)
KBO( :,37, 2) = (/&
&1.1614E-02_JPRB,1.3354E-02_JPRB,1.5031E-02_JPRB,1.6611E-02_JPRB,1.8085E-02_JPRB/)
KBO( :,38, 2) = (/&
&9.3636E-03_JPRB,1.0802E-02_JPRB,1.2193E-02_JPRB,1.3510E-02_JPRB,1.4737E-02_JPRB/)
KBO( :,39, 2) = (/&
&7.5541E-03_JPRB,8.7439E-03_JPRB,9.8975E-03_JPRB,1.0998E-02_JPRB,1.2026E-02_JPRB/)
KBO( :,40, 2) = (/&
&5.9794E-03_JPRB,6.9606E-03_JPRB,7.9183E-03_JPRB,8.8404E-03_JPRB,9.7022E-03_JPRB/)
KBO( :,41, 2) = (/&
&4.7162E-03_JPRB,5.5242E-03_JPRB,6.3175E-03_JPRB,7.0884E-03_JPRB,7.8122E-03_JPRB/)
KBO( :,42, 2) = (/&
&3.7141E-03_JPRB,4.3793E-03_JPRB,5.0373E-03_JPRB,5.6797E-03_JPRB,6.2875E-03_JPRB/)
KBO( :,43, 2) = (/&
&2.8894E-03_JPRB,3.4367E-03_JPRB,3.9819E-03_JPRB,4.5167E-03_JPRB,5.0302E-03_JPRB/)
KBO( :,44, 2) = (/&
&2.2311E-03_JPRB,2.6800E-03_JPRB,3.1318E-03_JPRB,3.5777E-03_JPRB,4.0109E-03_JPRB/)
KBO( :,45, 2) = (/&
&1.7190E-03_JPRB,2.0864E-03_JPRB,2.4595E-03_JPRB,2.8305E-03_JPRB,3.1948E-03_JPRB/)
KBO( :,46, 2) = (/&
&1.3144E-03_JPRB,1.6127E-03_JPRB,1.9198E-03_JPRB,2.2288E-03_JPRB,2.5338E-03_JPRB/)
KBO( :,47, 2) = (/&
&9.9072E-04_JPRB,1.2307E-03_JPRB,1.4827E-03_JPRB,1.7388E-03_JPRB,1.9939E-03_JPRB/)
KBO( :,48, 2) = (/&
&7.4328E-04_JPRB,9.3584E-04_JPRB,1.1422E-03_JPRB,1.3542E-03_JPRB,1.5673E-03_JPRB/)
KBO( :,49, 2) = (/&
&5.5568E-04_JPRB,7.0962E-04_JPRB,8.7747E-04_JPRB,1.0533E-03_JPRB,1.2311E-03_JPRB/)
KBO( :,50, 2) = (/&
&4.1543E-04_JPRB,5.3759E-04_JPRB,6.7298E-04_JPRB,8.1754E-04_JPRB,9.6501E-04_JPRB/)
KBO( :,51, 2) = (/&
&3.0972E-04_JPRB,4.0612E-04_JPRB,5.1480E-04_JPRB,6.3279E-04_JPRB,7.5447E-04_JPRB/)
KBO( :,52, 2) = (/&
&2.2960E-04_JPRB,3.0589E-04_JPRB,3.9277E-04_JPRB,4.8863E-04_JPRB,5.8929E-04_JPRB/)
KBO( :,53, 2) = (/&
&1.6933E-04_JPRB,2.2968E-04_JPRB,2.9891E-04_JPRB,3.7665E-04_JPRB,4.6003E-04_JPRB/)
KBO( :,54, 2) = (/&
&1.2476E-04_JPRB,1.7207E-04_JPRB,2.2658E-04_JPRB,2.8866E-04_JPRB,3.5637E-04_JPRB/)
KBO( :,55, 2) = (/&
&9.1638E-05_JPRB,1.2832E-04_JPRB,1.7102E-04_JPRB,2.1999E-04_JPRB,2.7423E-04_JPRB/)
KBO( :,56, 2) = (/&
&6.6998E-05_JPRB,9.5270E-05_JPRB,1.2875E-04_JPRB,1.6725E-04_JPRB,2.1034E-04_JPRB/)
KBO( :,57, 2) = (/&
&4.8715E-05_JPRB,7.0398E-05_JPRB,9.6609E-05_JPRB,1.2676E-04_JPRB,1.6093E-04_JPRB/)
KBO( :,58, 2) = (/&
&3.5429E-05_JPRB,5.2045E-05_JPRB,7.2448E-05_JPRB,9.6079E-05_JPRB,1.2306E-04_JPRB/)
KBO( :,59, 2) = (/&
&2.7567E-05_JPRB,4.0660E-05_JPRB,5.6784E-05_JPRB,7.5471E-05_JPRB,9.6741E-05_JPRB/)
KBO( :,13, 3) = (/&
&1.0985E+00_JPRB,1.3471E+00_JPRB,1.6024E+00_JPRB,1.8569E+00_JPRB,2.1065E+00_JPRB/)
KBO( :,14, 3) = (/&
&1.0057E+00_JPRB,1.2261E+00_JPRB,1.4487E+00_JPRB,1.6701E+00_JPRB,1.8867E+00_JPRB/)
KBO( :,15, 3) = (/&
&9.2327E-01_JPRB,1.1163E+00_JPRB,1.3096E+00_JPRB,1.5013E+00_JPRB,1.6927E+00_JPRB/)
KBO( :,16, 3) = (/&
&8.4655E-01_JPRB,1.0142E+00_JPRB,1.1813E+00_JPRB,1.3501E+00_JPRB,1.5181E+00_JPRB/)
KBO( :,17, 3) = (/&
&7.7095E-01_JPRB,9.1488E-01_JPRB,1.0609E+00_JPRB,1.2083E+00_JPRB,1.3539E+00_JPRB/)
KBO( :,18, 3) = (/&
&6.9584E-01_JPRB,8.2061E-01_JPRB,9.4796E-01_JPRB,1.0751E+00_JPRB,1.2000E+00_JPRB/)
KBO( :,19, 3) = (/&
&6.2275E-01_JPRB,7.3128E-01_JPRB,8.4109E-01_JPRB,9.5006E-01_JPRB,1.0557E+00_JPRB/)
KBO( :,20, 3) = (/&
&5.5466E-01_JPRB,6.4877E-01_JPRB,7.4343E-01_JPRB,8.3591E-01_JPRB,9.2515E-01_JPRB/)
KBO( :,21, 3) = (/&
&4.8960E-01_JPRB,5.7076E-01_JPRB,6.5178E-01_JPRB,7.3033E-01_JPRB,8.0430E-01_JPRB/)
KBO( :,22, 3) = (/&
&4.3303E-01_JPRB,5.0259E-01_JPRB,5.7096E-01_JPRB,6.3565E-01_JPRB,6.9649E-01_JPRB/)
KBO( :,23, 3) = (/&
&3.8028E-01_JPRB,4.3904E-01_JPRB,4.9534E-01_JPRB,5.4802E-01_JPRB,5.9732E-01_JPRB/)
KBO( :,24, 3) = (/&
&3.3218E-01_JPRB,3.8059E-01_JPRB,4.2634E-01_JPRB,4.6878E-01_JPRB,5.0765E-01_JPRB/)
KBO( :,25, 3) = (/&
&2.8849E-01_JPRB,3.2793E-01_JPRB,3.6460E-01_JPRB,3.9816E-01_JPRB,4.2820E-01_JPRB/)
KBO( :,26, 3) = (/&
&2.4952E-01_JPRB,2.8128E-01_JPRB,3.1016E-01_JPRB,3.3620E-01_JPRB,3.5944E-01_JPRB/)
KBO( :,27, 3) = (/&
&2.1458E-01_JPRB,2.3971E-01_JPRB,2.6222E-01_JPRB,2.8249E-01_JPRB,3.0071E-01_JPRB/)
KBO( :,28, 3) = (/&
&1.8348E-01_JPRB,2.0307E-01_JPRB,2.2063E-01_JPRB,2.3668E-01_JPRB,2.5103E-01_JPRB/)
KBO( :,29, 3) = (/&
&1.5612E-01_JPRB,1.7138E-01_JPRB,1.8529E-01_JPRB,1.9807E-01_JPRB,2.0946E-01_JPRB/)
KBO( :,30, 3) = (/&
&1.3217E-01_JPRB,1.4426E-01_JPRB,1.5536E-01_JPRB,1.6555E-01_JPRB,1.7467E-01_JPRB/)
KBO( :,31, 3) = (/&
&1.1164E-01_JPRB,1.2131E-01_JPRB,1.3020E-01_JPRB,1.3837E-01_JPRB,1.4579E-01_JPRB/)
KBO( :,32, 3) = (/&
&9.4160E-02_JPRB,1.0190E-01_JPRB,1.0909E-01_JPRB,1.1569E-01_JPRB,1.2174E-01_JPRB/)
KBO( :,33, 3) = (/&
&7.9328E-02_JPRB,8.5579E-02_JPRB,9.1418E-02_JPRB,9.6812E-02_JPRB,1.0174E-01_JPRB/)
KBO( :,34, 3) = (/&
&6.6575E-02_JPRB,7.1681E-02_JPRB,7.6449E-02_JPRB,8.0861E-02_JPRB,8.4837E-02_JPRB/)
KBO( :,35, 3) = (/&
&5.5452E-02_JPRB,5.9669E-02_JPRB,6.3583E-02_JPRB,6.7195E-02_JPRB,7.0402E-02_JPRB/)
KBO( :,36, 3) = (/&
&4.5817E-02_JPRB,4.9311E-02_JPRB,5.2541E-02_JPRB,5.5500E-02_JPRB,5.8136E-02_JPRB/)
KBO( :,37, 3) = (/&
&3.7392E-02_JPRB,4.0307E-02_JPRB,4.2995E-02_JPRB,4.5443E-02_JPRB,4.7667E-02_JPRB/)
KBO( :,38, 3) = (/&
&3.0507E-02_JPRB,3.2931E-02_JPRB,3.5170E-02_JPRB,3.7213E-02_JPRB,3.9076E-02_JPRB/)
KBO( :,39, 3) = (/&
&2.4900E-02_JPRB,2.6916E-02_JPRB,2.8785E-02_JPRB,3.0496E-02_JPRB,3.2065E-02_JPRB/)
KBO( :,40, 3) = (/&
&2.0117E-02_JPRB,2.1794E-02_JPRB,2.3370E-02_JPRB,2.4808E-02_JPRB,2.6137E-02_JPRB/)
KBO( :,41, 3) = (/&
&1.6225E-02_JPRB,1.7626E-02_JPRB,1.8947E-02_JPRB,2.0157E-02_JPRB,2.1285E-02_JPRB/)
KBO( :,42, 3) = (/&
&1.3079E-02_JPRB,1.4250E-02_JPRB,1.5359E-02_JPRB,1.6379E-02_JPRB,1.7329E-02_JPRB/)
KBO( :,43, 3) = (/&
&1.0482E-02_JPRB,1.1462E-02_JPRB,1.2394E-02_JPRB,1.3257E-02_JPRB,1.4064E-02_JPRB/)
KBO( :,44, 3) = (/&
&8.3710E-03_JPRB,9.1942E-03_JPRB,9.9787E-03_JPRB,1.0713E-02_JPRB,1.1396E-02_JPRB/)
KBO( :,45, 3) = (/&
&6.6788E-03_JPRB,7.3702E-03_JPRB,8.0298E-03_JPRB,8.6522E-03_JPRB,9.2329E-03_JPRB/)
KBO( :,46, 3) = (/&
&5.3081E-03_JPRB,5.8891E-03_JPRB,6.4422E-03_JPRB,6.9706E-03_JPRB,7.4651E-03_JPRB/)
KBO( :,47, 3) = (/&
&4.1866E-03_JPRB,4.6766E-03_JPRB,5.1419E-03_JPRB,5.5881E-03_JPRB,6.0116E-03_JPRB/)
KBO( :,48, 3) = (/&
&3.2935E-03_JPRB,3.7074E-03_JPRB,4.1001E-03_JPRB,4.4778E-03_JPRB,4.8397E-03_JPRB/)
KBO( :,49, 3) = (/&
&2.5846E-03_JPRB,2.9354E-03_JPRB,3.2677E-03_JPRB,3.5868E-03_JPRB,3.8959E-03_JPRB/)
KBO( :,50, 3) = (/&
&2.0269E-03_JPRB,2.3221E-03_JPRB,2.6022E-03_JPRB,2.8709E-03_JPRB,3.1320E-03_JPRB/)
KBO( :,51, 3) = (/&
&1.5861E-03_JPRB,1.8335E-03_JPRB,2.0693E-03_JPRB,2.2950E-03_JPRB,2.5144E-03_JPRB/)
KBO( :,52, 3) = (/&
&1.2373E-03_JPRB,1.4448E-03_JPRB,1.6433E-03_JPRB,1.8335E-03_JPRB,2.0181E-03_JPRB/)
KBO( :,53, 3) = (/&
&9.6238E-04_JPRB,1.1359E-03_JPRB,1.3032E-03_JPRB,1.4639E-03_JPRB,1.6200E-03_JPRB/)
KBO( :,54, 3) = (/&
&7.4760E-04_JPRB,8.9109E-04_JPRB,1.0310E-03_JPRB,1.1653E-03_JPRB,1.2951E-03_JPRB/)
KBO( :,55, 3) = (/&
&5.7948E-04_JPRB,6.9751E-04_JPRB,8.1351E-04_JPRB,9.2482E-04_JPRB,1.0323E-03_JPRB/)
KBO( :,56, 3) = (/&
&4.4747E-04_JPRB,5.4475E-04_JPRB,6.4072E-04_JPRB,7.3311E-04_JPRB,8.2203E-04_JPRB/)
KBO( :,57, 3) = (/&
&3.4377E-04_JPRB,4.2418E-04_JPRB,5.0351E-04_JPRB,5.8007E-04_JPRB,6.5383E-04_JPRB/)
KBO( :,58, 3) = (/&
&2.6362E-04_JPRB,3.3015E-04_JPRB,3.9544E-04_JPRB,4.5883E-04_JPRB,5.1985E-04_JPRB/)
KBO( :,59, 3) = (/&
&2.1059E-04_JPRB,2.6499E-04_JPRB,3.1808E-04_JPRB,3.6954E-04_JPRB,4.1891E-04_JPRB/)
KBO( :,13, 4) = (/&
&3.3302E+00_JPRB,3.5900E+00_JPRB,3.8490E+00_JPRB,4.0993E+00_JPRB,4.3544E+00_JPRB/)
KBO( :,14, 4) = (/&
&2.9375E+00_JPRB,3.1623E+00_JPRB,3.3912E+00_JPRB,3.6192E+00_JPRB,3.8536E+00_JPRB/)
KBO( :,15, 4) = (/&
&2.5847E+00_JPRB,2.7829E+00_JPRB,2.9920E+00_JPRB,3.2042E+00_JPRB,3.4159E+00_JPRB/)
KBO( :,16, 4) = (/&
&2.2723E+00_JPRB,2.4555E+00_JPRB,2.6487E+00_JPRB,2.8409E+00_JPRB,3.0352E+00_JPRB/)
KBO( :,17, 4) = (/&
&1.9985E+00_JPRB,2.1683E+00_JPRB,2.3422E+00_JPRB,2.5153E+00_JPRB,2.6950E+00_JPRB/)
KBO( :,18, 4) = (/&
&1.7574E+00_JPRB,1.9111E+00_JPRB,2.0646E+00_JPRB,2.2235E+00_JPRB,2.3882E+00_JPRB/)
KBO( :,19, 4) = (/&
&1.5417E+00_JPRB,1.6771E+00_JPRB,1.8159E+00_JPRB,1.9608E+00_JPRB,2.1091E+00_JPRB/)
KBO( :,20, 4) = (/&
&1.3501E+00_JPRB,1.4708E+00_JPRB,1.5966E+00_JPRB,1.7265E+00_JPRB,1.8579E+00_JPRB/)
KBO( :,21, 4) = (/&
&1.1792E+00_JPRB,1.2872E+00_JPRB,1.3996E+00_JPRB,1.5140E+00_JPRB,1.6291E+00_JPRB/)
KBO( :,22, 4) = (/&
&1.0331E+00_JPRB,1.1299E+00_JPRB,1.2292E+00_JPRB,1.3301E+00_JPRB,1.4294E+00_JPRB/)
KBO( :,23, 4) = (/&
&9.0257E-01_JPRB,9.8785E-01_JPRB,1.0758E+00_JPRB,1.1637E+00_JPRB,1.2469E+00_JPRB/)
KBO( :,24, 4) = (/&
&7.8462E-01_JPRB,8.6035E-01_JPRB,9.3739E-01_JPRB,1.0117E+00_JPRB,1.0795E+00_JPRB/)
KBO( :,25, 4) = (/&
&6.8021E-01_JPRB,7.4644E-01_JPRB,8.1147E-01_JPRB,8.7243E-01_JPRB,9.2768E-01_JPRB/)
KBO( :,26, 4) = (/&
&5.8877E-01_JPRB,6.4489E-01_JPRB,6.9856E-01_JPRB,7.4767E-01_JPRB,7.9152E-01_JPRB/)
KBO( :,27, 4) = (/&
&5.0790E-01_JPRB,5.5427E-01_JPRB,5.9771E-01_JPRB,6.3660E-01_JPRB,6.7040E-01_JPRB/)
KBO( :,28, 4) = (/&
&4.3619E-01_JPRB,4.7420E-01_JPRB,5.0861E-01_JPRB,5.3858E-01_JPRB,5.6428E-01_JPRB/)
KBO( :,29, 4) = (/&
&3.7351E-01_JPRB,4.0404E-01_JPRB,4.3062E-01_JPRB,4.5356E-01_JPRB,4.7355E-01_JPRB/)
KBO( :,30, 4) = (/&
&3.1877E-01_JPRB,3.4252E-01_JPRB,3.6291E-01_JPRB,3.8087E-01_JPRB,3.9669E-01_JPRB/)
KBO( :,31, 4) = (/&
&2.7097E-01_JPRB,2.8918E-01_JPRB,3.0519E-01_JPRB,3.1945E-01_JPRB,3.3218E-01_JPRB/)
KBO( :,32, 4) = (/&
&2.2933E-01_JPRB,2.4355E-01_JPRB,2.5629E-01_JPRB,2.6778E-01_JPRB,2.7819E-01_JPRB/)
KBO( :,33, 4) = (/&
&1.9352E-01_JPRB,2.0488E-01_JPRB,2.1514E-01_JPRB,2.2453E-01_JPRB,2.3322E-01_JPRB/)
KBO( :,34, 4) = (/&
&1.6266E-01_JPRB,1.7186E-01_JPRB,1.8021E-01_JPRB,1.8806E-01_JPRB,1.9533E-01_JPRB/)
KBO( :,35, 4) = (/&
&1.3588E-01_JPRB,1.4344E-01_JPRB,1.5044E-01_JPRB,1.5708E-01_JPRB,1.6319E-01_JPRB/)
KBO( :,36, 4) = (/&
&1.1281E-01_JPRB,1.1914E-01_JPRB,1.2508E-01_JPRB,1.3072E-01_JPRB,1.3587E-01_JPRB/)
KBO( :,37, 4) = (/&
&9.2816E-02_JPRB,9.8205E-02_JPRB,1.0328E-01_JPRB,1.0804E-01_JPRB,1.1242E-01_JPRB/)
KBO( :,38, 4) = (/&
&7.6370E-02_JPRB,8.0963E-02_JPRB,8.5283E-02_JPRB,8.9321E-02_JPRB,9.2973E-02_JPRB/)
KBO( :,39, 4) = (/&
&6.2888E-02_JPRB,6.6805E-02_JPRB,7.0475E-02_JPRB,7.3875E-02_JPRB,7.6971E-02_JPRB/)
KBO( :,40, 4) = (/&
&5.1396E-02_JPRB,5.4708E-02_JPRB,5.7829E-02_JPRB,6.0714E-02_JPRB,6.3350E-02_JPRB/)
KBO( :,41, 4) = (/&
&4.1955E-02_JPRB,4.4762E-02_JPRB,4.7396E-02_JPRB,4.9843E-02_JPRB,5.2102E-02_JPRB/)
KBO( :,42, 4) = (/&
&3.4234E-02_JPRB,3.6611E-02_JPRB,3.8848E-02_JPRB,4.0922E-02_JPRB,4.2851E-02_JPRB/)
KBO( :,43, 4) = (/&
&2.7815E-02_JPRB,2.9825E-02_JPRB,3.1727E-02_JPRB,3.3492E-02_JPRB,3.5154E-02_JPRB/)
KBO( :,44, 4) = (/&
&2.2537E-02_JPRB,2.4240E-02_JPRB,2.5867E-02_JPRB,2.7378E-02_JPRB,2.8807E-02_JPRB/)
KBO( :,45, 4) = (/&
&1.8246E-02_JPRB,1.9697E-02_JPRB,2.1085E-02_JPRB,2.2374E-02_JPRB,2.3604E-02_JPRB/)
KBO( :,46, 4) = (/&
&1.4728E-02_JPRB,1.5964E-02_JPRB,1.7142E-02_JPRB,1.8251E-02_JPRB,1.9308E-02_JPRB/)
KBO( :,47, 4) = (/&
&1.1818E-02_JPRB,1.2873E-02_JPRB,1.3878E-02_JPRB,1.4831E-02_JPRB,1.5740E-02_JPRB/)
KBO( :,48, 4) = (/&
&9.4657E-03_JPRB,1.0367E-02_JPRB,1.1228E-02_JPRB,1.2052E-02_JPRB,1.2833E-02_JPRB/)
KBO( :,49, 4) = (/&
&7.5680E-03_JPRB,8.3421E-03_JPRB,9.0805E-03_JPRB,9.7902E-03_JPRB,1.0464E-02_JPRB/)
KBO( :,50, 4) = (/&
&6.0502E-03_JPRB,6.7078E-03_JPRB,7.3374E-03_JPRB,7.9442E-03_JPRB,8.5226E-03_JPRB/)
KBO( :,51, 4) = (/&
&4.8299E-03_JPRB,5.3854E-03_JPRB,5.9216E-03_JPRB,6.4376E-03_JPRB,6.9334E-03_JPRB/)
KBO( :,52, 4) = (/&
&3.8467E-03_JPRB,4.3164E-03_JPRB,4.7737E-03_JPRB,5.2128E-03_JPRB,5.6384E-03_JPRB/)
KBO( :,53, 4) = (/&
&3.0576E-03_JPRB,3.4544E-03_JPRB,3.8447E-03_JPRB,4.2192E-03_JPRB,4.5847E-03_JPRB/)
KBO( :,54, 4) = (/&
&2.4302E-03_JPRB,2.7614E-03_JPRB,3.0899E-03_JPRB,3.4056E-03_JPRB,3.7134E-03_JPRB/)
KBO( :,55, 4) = (/&
&1.9293E-03_JPRB,2.2038E-03_JPRB,2.4777E-03_JPRB,2.7424E-03_JPRB,2.9994E-03_JPRB/)
KBO( :,56, 4) = (/&
&1.5286E-03_JPRB,1.7562E-03_JPRB,1.9841E-03_JPRB,2.2060E-03_JPRB,2.4199E-03_JPRB/)
KBO( :,57, 4) = (/&
&1.2085E-03_JPRB,1.3971E-03_JPRB,1.5864E-03_JPRB,1.7724E-03_JPRB,1.9514E-03_JPRB/)
KBO( :,58, 4) = (/&
&9.5537E-04_JPRB,1.1118E-03_JPRB,1.2685E-03_JPRB,1.4237E-03_JPRB,1.5733E-03_JPRB/)
KBO( :,59, 4) = (/&
&7.7590E-04_JPRB,9.0437E-04_JPRB,1.0323E-03_JPRB,1.1597E-03_JPRB,1.2822E-03_JPRB/)
KBO( :,13, 5) = (/&
&6.9141E+00_JPRB,7.1545E+00_JPRB,7.4046E+00_JPRB,7.6833E+00_JPRB,7.9432E+00_JPRB/)
KBO( :,14, 5) = (/&
&6.0755E+00_JPRB,6.2987E+00_JPRB,6.5306E+00_JPRB,6.7873E+00_JPRB,7.0278E+00_JPRB/)
KBO( :,15, 5) = (/&
&5.3116E+00_JPRB,5.5269E+00_JPRB,5.7512E+00_JPRB,5.9835E+00_JPRB,6.2117E+00_JPRB/)
KBO( :,16, 5) = (/&
&4.6343E+00_JPRB,4.8449E+00_JPRB,5.0585E+00_JPRB,5.2837E+00_JPRB,5.5069E+00_JPRB/)
KBO( :,17, 5) = (/&
&4.0419E+00_JPRB,4.2430E+00_JPRB,4.4508E+00_JPRB,4.6718E+00_JPRB,4.8821E+00_JPRB/)
KBO( :,18, 5) = (/&
&3.5281E+00_JPRB,3.7196E+00_JPRB,3.9254E+00_JPRB,4.1289E+00_JPRB,4.3250E+00_JPRB/)
KBO( :,19, 5) = (/&
&3.0859E+00_JPRB,3.2697E+00_JPRB,3.4594E+00_JPRB,3.6428E+00_JPRB,3.8279E+00_JPRB/)
KBO( :,20, 5) = (/&
&2.7073E+00_JPRB,2.8768E+00_JPRB,3.0450E+00_JPRB,3.2129E+00_JPRB,3.3880E+00_JPRB/)
KBO( :,21, 5) = (/&
&2.3737E+00_JPRB,2.5247E+00_JPRB,2.6757E+00_JPRB,2.8327E+00_JPRB,2.9960E+00_JPRB/)
KBO( :,22, 5) = (/&
&2.0857E+00_JPRB,2.2199E+00_JPRB,2.3591E+00_JPRB,2.5039E+00_JPRB,2.6519E+00_JPRB/)
KBO( :,23, 5) = (/&
&1.8289E+00_JPRB,1.9512E+00_JPRB,2.0778E+00_JPRB,2.2081E+00_JPRB,2.3436E+00_JPRB/)
KBO( :,24, 5) = (/&
&1.6014E+00_JPRB,1.7122E+00_JPRB,1.8266E+00_JPRB,1.9454E+00_JPRB,2.0684E+00_JPRB/)
KBO( :,25, 5) = (/&
&1.3998E+00_JPRB,1.4999E+00_JPRB,1.6048E+00_JPRB,1.7138E+00_JPRB,1.8217E+00_JPRB/)
KBO( :,26, 5) = (/&
&1.2210E+00_JPRB,1.3132E+00_JPRB,1.4097E+00_JPRB,1.5070E+00_JPRB,1.6011E+00_JPRB/)
KBO( :,27, 5) = (/&
&1.0633E+00_JPRB,1.1477E+00_JPRB,1.2343E+00_JPRB,1.3197E+00_JPRB,1.4013E+00_JPRB/)
KBO( :,28, 5) = (/&
&9.2471E-01_JPRB,1.0003E+00_JPRB,1.0762E+00_JPRB,1.1506E+00_JPRB,1.2207E+00_JPRB/)
KBO( :,29, 5) = (/&
&8.0378E-01_JPRB,8.6991E-01_JPRB,9.3571E-01_JPRB,9.9918E-01_JPRB,1.0579E+00_JPRB/)
KBO( :,30, 5) = (/&
&6.9745E-01_JPRB,7.5481E-01_JPRB,8.1124E-01_JPRB,8.6394E-01_JPRB,9.1132E-01_JPRB/)
KBO( :,31, 5) = (/&
&6.0465E-01_JPRB,6.5420E-01_JPRB,7.0129E-01_JPRB,7.4415E-01_JPRB,7.8220E-01_JPRB/)
KBO( :,32, 5) = (/&
&5.2389E-01_JPRB,5.6576E-01_JPRB,6.0408E-01_JPRB,6.3888E-01_JPRB,6.7018E-01_JPRB/)
KBO( :,33, 5) = (/&
&4.5339E-01_JPRB,4.8777E-01_JPRB,5.1895E-01_JPRB,5.4778E-01_JPRB,5.7413E-01_JPRB/)
KBO( :,34, 5) = (/&
&3.9043E-01_JPRB,4.1838E-01_JPRB,4.4436E-01_JPRB,4.6859E-01_JPRB,4.9150E-01_JPRB/)
KBO( :,35, 5) = (/&
&3.3304E-01_JPRB,3.5641E-01_JPRB,3.7837E-01_JPRB,3.9937E-01_JPRB,4.1969E-01_JPRB/)
KBO( :,36, 5) = (/&
&2.8159E-01_JPRB,3.0146E-01_JPRB,3.2042E-01_JPRB,3.3894E-01_JPRB,3.5721E-01_JPRB/)
KBO( :,37, 5) = (/&
&2.3528E-01_JPRB,2.5243E-01_JPRB,2.6898E-01_JPRB,2.8542E-01_JPRB,3.0190E-01_JPRB/)
KBO( :,38, 5) = (/&
&1.9653E-01_JPRB,2.1135E-01_JPRB,2.2593E-01_JPRB,2.4055E-01_JPRB,2.5537E-01_JPRB/)
KBO( :,39, 5) = (/&
&1.6424E-01_JPRB,1.7712E-01_JPRB,1.9008E-01_JPRB,2.0314E-01_JPRB,2.1645E-01_JPRB/)
KBO( :,40, 5) = (/&
&1.3599E-01_JPRB,1.4712E-01_JPRB,1.5856E-01_JPRB,1.7013E-01_JPRB,1.8191E-01_JPRB/)
KBO( :,41, 5) = (/&
&1.1240E-01_JPRB,1.2208E-01_JPRB,1.3208E-01_JPRB,1.4229E-01_JPRB,1.5269E-01_JPRB/)
KBO( :,42, 5) = (/&
&9.2848E-02_JPRB,1.0126E-01_JPRB,1.1003E-01_JPRB,1.1902E-01_JPRB,1.2816E-01_JPRB/)
KBO( :,43, 5) = (/&
&7.6272E-02_JPRB,8.3551E-02_JPRB,9.1173E-02_JPRB,9.9059E-02_JPRB,1.0710E-01_JPRB/)
KBO( :,44, 5) = (/&
&6.2420E-02_JPRB,6.8705E-02_JPRB,7.5347E-02_JPRB,8.2255E-02_JPRB,8.9304E-02_JPRB/)
KBO( :,45, 5) = (/&
&5.1037E-02_JPRB,5.6461E-02_JPRB,6.2222E-02_JPRB,6.8245E-02_JPRB,7.4410E-02_JPRB/)
KBO( :,46, 5) = (/&
&4.1575E-02_JPRB,4.6220E-02_JPRB,5.1187E-02_JPRB,5.6431E-02_JPRB,6.1814E-02_JPRB/)
KBO( :,47, 5) = (/&
&3.3624E-02_JPRB,3.7569E-02_JPRB,4.1825E-02_JPRB,4.6358E-02_JPRB,5.1051E-02_JPRB/)
KBO( :,48, 5) = (/&
&2.7133E-02_JPRB,3.0477E-02_JPRB,3.4127E-02_JPRB,3.8049E-02_JPRB,4.2137E-02_JPRB/)
KBO( :,49, 5) = (/&
&2.1850E-02_JPRB,2.4695E-02_JPRB,2.7812E-02_JPRB,3.1199E-02_JPRB,3.4749E-02_JPRB/)
KBO( :,50, 5) = (/&
&1.7588E-02_JPRB,1.9999E-02_JPRB,2.2640E-02_JPRB,2.5547E-02_JPRB,2.8612E-02_JPRB/)
KBO( :,51, 5) = (/&
&1.4133E-02_JPRB,1.6172E-02_JPRB,1.8401E-02_JPRB,2.0880E-02_JPRB,2.3515E-02_JPRB/)
KBO( :,52, 5) = (/&
&1.1330E-02_JPRB,1.3052E-02_JPRB,1.4932E-02_JPRB,1.7041E-02_JPRB,1.9304E-02_JPRB/)
KBO( :,53, 5) = (/&
&9.0563E-03_JPRB,1.0511E-02_JPRB,1.2096E-02_JPRB,1.3890E-02_JPRB,1.5837E-02_JPRB/)
KBO( :,54, 5) = (/&
&7.2337E-03_JPRB,8.4542E-03_JPRB,9.7774E-03_JPRB,1.1280E-02_JPRB,1.2936E-02_JPRB/)
KBO( :,55, 5) = (/&
&5.7674E-03_JPRB,6.7888E-03_JPRB,7.8837E-03_JPRB,9.1276E-03_JPRB,1.0528E-02_JPRB/)
KBO( :,56, 5) = (/&
&4.5854E-03_JPRB,5.4402E-03_JPRB,6.3461E-03_JPRB,7.3755E-03_JPRB,8.5458E-03_JPRB/)
KBO( :,57, 5) = (/&
&3.6334E-03_JPRB,4.3489E-03_JPRB,5.0994E-03_JPRB,5.9486E-03_JPRB,6.9270E-03_JPRB/)
KBO( :,58, 5) = (/&
&2.8784E-03_JPRB,3.4761E-03_JPRB,4.0992E-03_JPRB,4.7976E-03_JPRB,5.6122E-03_JPRB/)
KBO( :,59, 5) = (/&
&2.3567E-03_JPRB,2.8551E-03_JPRB,3.3744E-03_JPRB,3.9529E-03_JPRB,4.6311E-03_JPRB/)
KBO( :,13, 6) = (/&
&1.3830E+01_JPRB,1.4015E+01_JPRB,1.4160E+01_JPRB,1.4307E+01_JPRB,1.4522E+01_JPRB/)
KBO( :,14, 6) = (/&
&1.2340E+01_JPRB,1.2516E+01_JPRB,1.2660E+01_JPRB,1.2793E+01_JPRB,1.2966E+01_JPRB/)
KBO( :,15, 6) = (/&
&1.0924E+01_JPRB,1.1092E+01_JPRB,1.1224E+01_JPRB,1.1351E+01_JPRB,1.1516E+01_JPRB/)
KBO( :,16, 6) = (/&
&9.6024E+00_JPRB,9.7501E+00_JPRB,9.8836E+00_JPRB,1.0029E+01_JPRB,1.0212E+01_JPRB/)
KBO( :,17, 6) = (/&
&8.3708E+00_JPRB,8.5153E+00_JPRB,8.6644E+00_JPRB,8.8329E+00_JPRB,9.0401E+00_JPRB/)
KBO( :,18, 6) = (/&
&7.2569E+00_JPRB,7.4102E+00_JPRB,7.5767E+00_JPRB,7.7740E+00_JPRB,8.0051E+00_JPRB/)
KBO( :,19, 6) = (/&
&6.2750E+00_JPRB,6.4411E+00_JPRB,6.6283E+00_JPRB,6.8499E+00_JPRB,7.0924E+00_JPRB/)
KBO( :,20, 6) = (/&
&5.4324E+00_JPRB,5.6127E+00_JPRB,5.8201E+00_JPRB,6.0515E+00_JPRB,6.2952E+00_JPRB/)
KBO( :,21, 6) = (/&
&4.7199E+00_JPRB,4.9098E+00_JPRB,5.1220E+00_JPRB,5.3512E+00_JPRB,5.5929E+00_JPRB/)
KBO( :,22, 6) = (/&
&4.1275E+00_JPRB,4.3173E+00_JPRB,4.5250E+00_JPRB,4.7472E+00_JPRB,4.9873E+00_JPRB/)
KBO( :,23, 6) = (/&
&3.6186E+00_JPRB,3.8008E+00_JPRB,4.0007E+00_JPRB,4.2194E+00_JPRB,4.4546E+00_JPRB/)
KBO( :,24, 6) = (/&
&3.1789E+00_JPRB,3.3535E+00_JPRB,3.5481E+00_JPRB,3.7602E+00_JPRB,3.9826E+00_JPRB/)
KBO( :,25, 6) = (/&
&2.8009E+00_JPRB,2.9702E+00_JPRB,3.1571E+00_JPRB,3.3553E+00_JPRB,3.5661E+00_JPRB/)
KBO( :,26, 6) = (/&
&2.4787E+00_JPRB,2.6417E+00_JPRB,2.8161E+00_JPRB,3.0035E+00_JPRB,3.2026E+00_JPRB/)
KBO( :,27, 6) = (/&
&2.1990E+00_JPRB,2.3537E+00_JPRB,2.5197E+00_JPRB,2.6976E+00_JPRB,2.8845E+00_JPRB/)
KBO( :,28, 6) = (/&
&1.9523E+00_JPRB,2.1013E+00_JPRB,2.2618E+00_JPRB,2.4297E+00_JPRB,2.6035E+00_JPRB/)
KBO( :,29, 6) = (/&
&1.7370E+00_JPRB,1.8823E+00_JPRB,2.0367E+00_JPRB,2.1958E+00_JPRB,2.3561E+00_JPRB/)
KBO( :,30, 6) = (/&
&1.5497E+00_JPRB,1.6904E+00_JPRB,1.8375E+00_JPRB,1.9876E+00_JPRB,2.1376E+00_JPRB/)
KBO( :,31, 6) = (/&
&1.3874E+00_JPRB,1.5222E+00_JPRB,1.6617E+00_JPRB,1.8040E+00_JPRB,1.9446E+00_JPRB/)
KBO( :,32, 6) = (/&
&1.2460E+00_JPRB,1.3738E+00_JPRB,1.5067E+00_JPRB,1.6408E+00_JPRB,1.7720E+00_JPRB/)
KBO( :,33, 6) = (/&
&1.1223E+00_JPRB,1.2436E+00_JPRB,1.3697E+00_JPRB,1.4955E+00_JPRB,1.6172E+00_JPRB/)
KBO( :,34, 6) = (/&
&1.0099E+00_JPRB,1.1249E+00_JPRB,1.2434E+00_JPRB,1.3608E+00_JPRB,1.4735E+00_JPRB/)
KBO( :,35, 6) = (/&
&9.0209E-01_JPRB,1.0096E+00_JPRB,1.1199E+00_JPRB,1.2299E+00_JPRB,1.3354E+00_JPRB/)
KBO( :,36, 6) = (/&
&7.9733E-01_JPRB,8.9688E-01_JPRB,9.9932E-01_JPRB,1.1023E+00_JPRB,1.2028E+00_JPRB/)
KBO( :,37, 6) = (/&
&6.9211E-01_JPRB,7.8344E-01_JPRB,8.7821E-01_JPRB,9.7443E-01_JPRB,1.0708E+00_JPRB/)
KBO( :,38, 6) = (/&
&6.0006E-01_JPRB,6.8377E-01_JPRB,7.7149E-01_JPRB,8.6171E-01_JPRB,9.5413E-01_JPRB/)
KBO( :,39, 6) = (/&
&5.2043E-01_JPRB,5.9726E-01_JPRB,6.7852E-01_JPRB,7.6343E-01_JPRB,8.5244E-01_JPRB/)
KBO( :,40, 6) = (/&
&4.4416E-01_JPRB,5.1399E-01_JPRB,5.8862E-01_JPRB,6.6792E-01_JPRB,7.5268E-01_JPRB/)
KBO( :,41, 6) = (/&
&3.7776E-01_JPRB,4.4092E-01_JPRB,5.0931E-01_JPRB,5.8308E-01_JPRB,6.6368E-01_JPRB/)
KBO( :,42, 6) = (/&
&3.2073E-01_JPRB,3.7777E-01_JPRB,4.4039E-01_JPRB,5.0902E-01_JPRB,5.8559E-01_JPRB/)
KBO( :,43, 6) = (/&
&2.6920E-01_JPRB,3.2022E-01_JPRB,3.7707E-01_JPRB,4.4047E-01_JPRB,5.1263E-01_JPRB/)
KBO( :,44, 6) = (/&
&2.2419E-01_JPRB,2.6949E-01_JPRB,3.2089E-01_JPRB,3.7919E-01_JPRB,4.4668E-01_JPRB/)
KBO( :,45, 6) = (/&
&1.8610E-01_JPRB,2.2623E-01_JPRB,2.7250E-01_JPRB,3.2589E-01_JPRB,3.8881E-01_JPRB/)
KBO( :,46, 6) = (/&
&1.5321E-01_JPRB,1.8844E-01_JPRB,2.2973E-01_JPRB,2.7826E-01_JPRB,3.3646E-01_JPRB/)
KBO( :,47, 6) = (/&
&1.2434E-01_JPRB,1.5480E-01_JPRB,1.9116E-01_JPRB,2.3462E-01_JPRB,2.8768E-01_JPRB/)
KBO( :,48, 6) = (/&
&1.0036E-01_JPRB,1.2653E-01_JPRB,1.5835E-01_JPRB,1.9711E-01_JPRB,2.4528E-01_JPRB/)
KBO( :,49, 6) = (/&
&8.0612E-02_JPRB,1.0295E-01_JPRB,1.3061E-01_JPRB,1.6496E-01_JPRB,2.0845E-01_JPRB/)
KBO( :,50, 6) = (/&
&6.4743E-02_JPRB,8.3670E-02_JPRB,1.0758E-01_JPRB,1.3777E-01_JPRB,1.7673E-01_JPRB/)
KBO( :,51, 6) = (/&
&5.1836E-02_JPRB,6.7752E-02_JPRB,8.8282E-02_JPRB,1.1466E-01_JPRB,1.4926E-01_JPRB/)
KBO( :,52, 6) = (/&
&4.1270E-02_JPRB,5.4579E-02_JPRB,7.2088E-02_JPRB,9.5008E-02_JPRB,1.2557E-01_JPRB/)
KBO( :,53, 6) = (/&
&3.2703E-02_JPRB,4.3723E-02_JPRB,5.8551E-02_JPRB,7.8358E-02_JPRB,1.0523E-01_JPRB/)
KBO( :,54, 6) = (/&
&2.5932E-02_JPRB,3.5025E-02_JPRB,4.7496E-02_JPRB,6.4433E-02_JPRB,8.7763E-02_JPRB/)
KBO( :,55, 6) = (/&
&2.0516E-02_JPRB,2.7980E-02_JPRB,3.8384E-02_JPRB,5.2720E-02_JPRB,7.2773E-02_JPRB/)
KBO( :,56, 6) = (/&
&1.6157E-02_JPRB,2.2243E-02_JPRB,3.0860E-02_JPRB,4.2933E-02_JPRB,6.0054E-02_JPRB/)
KBO( :,57, 6) = (/&
&1.2662E-02_JPRB,1.7594E-02_JPRB,2.4676E-02_JPRB,3.4773E-02_JPRB,4.9299E-02_JPRB/)
KBO( :,58, 6) = (/&
&9.9314E-03_JPRB,1.3912E-02_JPRB,1.9723E-02_JPRB,2.8150E-02_JPRB,4.0439E-02_JPRB/)
KBO( :,59, 6) = (/&
&8.2224E-03_JPRB,1.1623E-02_JPRB,1.6659E-02_JPRB,2.4055E-02_JPRB,3.5006E-02_JPRB/)
KBO( :,13, 7) = (/&
&2.6335E+01_JPRB,2.6343E+01_JPRB,2.6317E+01_JPRB,2.6278E+01_JPRB,2.6240E+01_JPRB/)
KBO( :,14, 7) = (/&
&2.4335E+01_JPRB,2.4368E+01_JPRB,2.4378E+01_JPRB,2.4360E+01_JPRB,2.4346E+01_JPRB/)
KBO( :,15, 7) = (/&
&2.2209E+01_JPRB,2.2271E+01_JPRB,2.2317E+01_JPRB,2.2351E+01_JPRB,2.2363E+01_JPRB/)
KBO( :,16, 7) = (/&
&2.0041E+01_JPRB,2.0151E+01_JPRB,2.0235E+01_JPRB,2.0297E+01_JPRB,2.0322E+01_JPRB/)
KBO( :,17, 7) = (/&
&1.7927E+01_JPRB,1.8060E+01_JPRB,1.8168E+01_JPRB,1.8242E+01_JPRB,1.8304E+01_JPRB/)
KBO( :,18, 7) = (/&
&1.5898E+01_JPRB,1.6045E+01_JPRB,1.6164E+01_JPRB,1.6266E+01_JPRB,1.6378E+01_JPRB/)
KBO( :,19, 7) = (/&
&1.3992E+01_JPRB,1.4142E+01_JPRB,1.4282E+01_JPRB,1.4427E+01_JPRB,1.4606E+01_JPRB/)
KBO( :,20, 7) = (/&
&1.2229E+01_JPRB,1.2396E+01_JPRB,1.2574E+01_JPRB,1.2781E+01_JPRB,1.3031E+01_JPRB/)
KBO( :,21, 7) = (/&
&1.0639E+01_JPRB,1.0839E+01_JPRB,1.1068E+01_JPRB,1.1335E+01_JPRB,1.1649E+01_JPRB/)
KBO( :,22, 7) = (/&
&9.2636E+00_JPRB,9.5053E+00_JPRB,9.7840E+00_JPRB,1.0108E+01_JPRB,1.0461E+01_JPRB/)
KBO( :,23, 7) = (/&
&8.0952E+00_JPRB,8.3738E+00_JPRB,8.6908E+00_JPRB,9.0366E+00_JPRB,9.4060E+00_JPRB/)
KBO( :,24, 7) = (/&
&7.1130E+00_JPRB,7.4146E+00_JPRB,7.7429E+00_JPRB,8.0993E+00_JPRB,8.4864E+00_JPRB/)
KBO( :,25, 7) = (/&
&6.2837E+00_JPRB,6.5877E+00_JPRB,6.9205E+00_JPRB,7.2883E+00_JPRB,7.6912E+00_JPRB/)
KBO( :,26, 7) = (/&
&5.5745E+00_JPRB,5.8760E+00_JPRB,6.2151E+00_JPRB,6.5923E+00_JPRB,7.0080E+00_JPRB/)
KBO( :,27, 7) = (/&
&4.9643E+00_JPRB,5.2682E+00_JPRB,5.6134E+00_JPRB,5.9978E+00_JPRB,6.4129E+00_JPRB/)
KBO( :,28, 7) = (/&
&4.4473E+00_JPRB,4.7539E+00_JPRB,5.1020E+00_JPRB,5.4857E+00_JPRB,5.8980E+00_JPRB/)
KBO( :,29, 7) = (/&
&4.0139E+00_JPRB,4.3228E+00_JPRB,4.6679E+00_JPRB,5.0477E+00_JPRB,5.4611E+00_JPRB/)
KBO( :,30, 7) = (/&
&3.6503E+00_JPRB,3.9570E+00_JPRB,4.2982E+00_JPRB,4.6765E+00_JPRB,5.0904E+00_JPRB/)
KBO( :,31, 7) = (/&
&3.3458E+00_JPRB,3.6492E+00_JPRB,3.9896E+00_JPRB,4.3657E+00_JPRB,4.7803E+00_JPRB/)
KBO( :,32, 7) = (/&
&3.0885E+00_JPRB,3.3924E+00_JPRB,3.7326E+00_JPRB,4.1089E+00_JPRB,4.5242E+00_JPRB/)
KBO( :,33, 7) = (/&
&2.8733E+00_JPRB,3.1791E+00_JPRB,3.5210E+00_JPRB,3.8996E+00_JPRB,4.3193E+00_JPRB/)
KBO( :,34, 7) = (/&
&2.6844E+00_JPRB,2.9924E+00_JPRB,3.3348E+00_JPRB,3.7181E+00_JPRB,4.1445E+00_JPRB/)
KBO( :,35, 7) = (/&
&2.4984E+00_JPRB,2.8075E+00_JPRB,3.1505E+00_JPRB,3.5359E+00_JPRB,3.9675E+00_JPRB/)
KBO( :,36, 7) = (/&
&2.3072E+00_JPRB,2.6159E+00_JPRB,2.9582E+00_JPRB,3.3431E+00_JPRB,3.7763E+00_JPRB/)
KBO( :,37, 7) = (/&
&2.0954E+00_JPRB,2.4005E+00_JPRB,2.7380E+00_JPRB,3.1168E+00_JPRB,3.5461E+00_JPRB/)
KBO( :,38, 7) = (/&
&1.9034E+00_JPRB,2.2055E+00_JPRB,2.5402E+00_JPRB,2.9151E+00_JPRB,3.3403E+00_JPRB/)
KBO( :,39, 7) = (/&
&1.7317E+00_JPRB,2.0312E+00_JPRB,2.3647E+00_JPRB,2.7379E+00_JPRB,3.1615E+00_JPRB/)
KBO( :,40, 7) = (/&
&1.5481E+00_JPRB,1.8407E+00_JPRB,2.1704E+00_JPRB,2.5377E+00_JPRB,2.9544E+00_JPRB/)
KBO( :,41, 7) = (/&
&1.3778E+00_JPRB,1.6628E+00_JPRB,1.9879E+00_JPRB,2.3508E+00_JPRB,2.7602E+00_JPRB/)
KBO( :,42, 7) = (/&
&1.2232E+00_JPRB,1.4999E+00_JPRB,1.8203E+00_JPRB,2.1797E+00_JPRB,2.5828E+00_JPRB/)
KBO( :,43, 7) = (/&
&1.0698E+00_JPRB,1.3347E+00_JPRB,1.6469E+00_JPRB,2.0008E+00_JPRB,2.3963E+00_JPRB/)
KBO( :,44, 7) = (/&
&9.2588E-01_JPRB,1.1760E+00_JPRB,1.4777E+00_JPRB,1.8247E+00_JPRB,2.2132E+00_JPRB/)
KBO( :,45, 7) = (/&
&7.9702E-01_JPRB,1.0315E+00_JPRB,1.3210E+00_JPRB,1.6600E+00_JPRB,2.0420E+00_JPRB/)
KBO( :,46, 7) = (/&
&6.7818E-01_JPRB,8.9459E-01_JPRB,1.1684E+00_JPRB,1.4973E+00_JPRB,1.8716E+00_JPRB/)
KBO( :,47, 7) = (/&
&5.6580E-01_JPRB,7.6097E-01_JPRB,1.0151E+00_JPRB,1.3286E+00_JPRB,1.6923E+00_JPRB/)
KBO( :,48, 7) = (/&
&4.6791E-01_JPRB,6.4213E-01_JPRB,8.7532E-01_JPRB,1.1714E+00_JPRB,1.5227E+00_JPRB/)
KBO( :,49, 7) = (/&
&3.8353E-01_JPRB,5.3743E-01_JPRB,7.4923E-01_JPRB,1.0257E+00_JPRB,1.3624E+00_JPRB/)
KBO( :,50, 7) = (/&
&3.1398E-01_JPRB,4.4906E-01_JPRB,6.4014E-01_JPRB,8.9685E-01_JPRB,1.2172E+00_JPRB/)
KBO( :,51, 7) = (/&
&2.5573E-01_JPRB,3.7326E-01_JPRB,5.4427E-01_JPRB,7.8065E-01_JPRB,1.0832E+00_JPRB/)
KBO( :,52, 7) = (/&
&2.0647E-01_JPRB,3.0764E-01_JPRB,4.5931E-01_JPRB,6.7487E-01_JPRB,9.5820E-01_JPRB/)
KBO( :,53, 7) = (/&
&1.6527E-01_JPRB,2.5130E-01_JPRB,3.8436E-01_JPRB,5.7911E-01_JPRB,8.4227E-01_JPRB/)
KBO( :,54, 7) = (/&
&1.3250E-01_JPRB,2.0520E-01_JPRB,3.2144E-01_JPRB,4.9663E-01_JPRB,7.3948E-01_JPRB/)
KBO( :,55, 7) = (/&
&1.0586E-01_JPRB,1.6687E-01_JPRB,2.6744E-01_JPRB,4.2379E-01_JPRB,6.4623E-01_JPRB/)
KBO( :,56, 7) = (/&
&8.3917E-02_JPRB,1.3459E-01_JPRB,2.2056E-01_JPRB,3.5886E-01_JPRB,5.6114E-01_JPRB/)
KBO( :,57, 7) = (/&
&6.5997E-02_JPRB,1.0758E-01_JPRB,1.8019E-01_JPRB,3.0131E-01_JPRB,4.8364E-01_JPRB/)
KBO( :,58, 7) = (/&
&5.1899E-02_JPRB,8.5940E-02_JPRB,1.4705E-01_JPRB,2.5263E-01_JPRB,4.1642E-01_JPRB/)
KBO( :,59, 7) = (/&
&4.4275E-02_JPRB,7.4915E-02_JPRB,1.3121E-01_JPRB,2.3019E-01_JPRB,3.8591E-01_JPRB/)
KBO( :,13, 8) = (/&
&5.0965E+01_JPRB,5.0361E+01_JPRB,4.9768E+01_JPRB,4.9177E+01_JPRB,4.8632E+01_JPRB/)
KBO( :,14, 8) = (/&
&4.9580E+01_JPRB,4.9133E+01_JPRB,4.8669E+01_JPRB,4.8207E+01_JPRB,4.7744E+01_JPRB/)
KBO( :,15, 8) = (/&
&4.7755E+01_JPRB,4.7423E+01_JPRB,4.7054E+01_JPRB,4.6684E+01_JPRB,4.6310E+01_JPRB/)
KBO( :,16, 8) = (/&
&4.5437E+01_JPRB,4.5197E+01_JPRB,4.4948E+01_JPRB,4.4674E+01_JPRB,4.4398E+01_JPRB/)
KBO( :,17, 8) = (/&
&4.2668E+01_JPRB,4.2548E+01_JPRB,4.2401E+01_JPRB,4.2228E+01_JPRB,4.2024E+01_JPRB/)
KBO( :,18, 8) = (/&
&3.9590E+01_JPRB,3.9566E+01_JPRB,3.9492E+01_JPRB,3.9393E+01_JPRB,3.9273E+01_JPRB/)
KBO( :,19, 8) = (/&
&3.6298E+01_JPRB,3.6335E+01_JPRB,3.6351E+01_JPRB,3.6334E+01_JPRB,3.6282E+01_JPRB/)
KBO( :,20, 8) = (/&
&3.2906E+01_JPRB,3.3017E+01_JPRB,3.3099E+01_JPRB,3.3142E+01_JPRB,3.3168E+01_JPRB/)
KBO( :,21, 8) = (/&
&2.9547E+01_JPRB,2.9709E+01_JPRB,2.9845E+01_JPRB,2.9969E+01_JPRB,3.0103E+01_JPRB/)
KBO( :,22, 8) = (/&
&2.6311E+01_JPRB,2.6524E+01_JPRB,2.6733E+01_JPRB,2.6954E+01_JPRB,2.7222E+01_JPRB/)
KBO( :,23, 8) = (/&
&2.3277E+01_JPRB,2.3556E+01_JPRB,2.3854E+01_JPRB,2.4204E+01_JPRB,2.4638E+01_JPRB/)
KBO( :,24, 8) = (/&
&2.0517E+01_JPRB,2.0874E+01_JPRB,2.1304E+01_JPRB,2.1801E+01_JPRB,2.2391E+01_JPRB/)
KBO( :,25, 8) = (/&
&1.8081E+01_JPRB,1.8550E+01_JPRB,1.9103E+01_JPRB,1.9746E+01_JPRB,2.0474E+01_JPRB/)
KBO( :,26, 8) = (/&
&1.6011E+01_JPRB,1.6594E+01_JPRB,1.7264E+01_JPRB,1.8029E+01_JPRB,1.8873E+01_JPRB/)
KBO( :,27, 8) = (/&
&1.4287E+01_JPRB,1.4961E+01_JPRB,1.5728E+01_JPRB,1.6587E+01_JPRB,1.7528E+01_JPRB/)
KBO( :,28, 8) = (/&
&1.2856E+01_JPRB,1.3605E+01_JPRB,1.4442E+01_JPRB,1.5375E+01_JPRB,1.6398E+01_JPRB/)
KBO( :,29, 8) = (/&
&1.1675E+01_JPRB,1.2478E+01_JPRB,1.3380E+01_JPRB,1.4384E+01_JPRB,1.5477E+01_JPRB/)
KBO( :,30, 8) = (/&
&1.0695E+01_JPRB,1.1550E+01_JPRB,1.2511E+01_JPRB,1.3578E+01_JPRB,1.4743E+01_JPRB/)
KBO( :,31, 8) = (/&
&9.8981E+00_JPRB,1.0807E+01_JPRB,1.1824E+01_JPRB,1.2957E+01_JPRB,1.4200E+01_JPRB/)
KBO( :,32, 8) = (/&
&9.2617E+00_JPRB,1.0217E+01_JPRB,1.1294E+01_JPRB,1.2501E+01_JPRB,1.3819E+01_JPRB/)
KBO( :,33, 8) = (/&
&8.7596E+00_JPRB,9.7694E+00_JPRB,1.0911E+01_JPRB,1.2196E+01_JPRB,1.3598E+01_JPRB/)
KBO( :,34, 8) = (/&
&8.3433E+00_JPRB,9.4056E+00_JPRB,1.0617E+01_JPRB,1.1977E+01_JPRB,1.3459E+01_JPRB/)
KBO( :,35, 8) = (/&
&7.9357E+00_JPRB,9.0427E+00_JPRB,1.0314E+01_JPRB,1.1736E+01_JPRB,1.3286E+01_JPRB/)
KBO( :,36, 8) = (/&
&7.5046E+00_JPRB,8.6413E+00_JPRB,9.9524E+00_JPRB,1.1425E+01_JPRB,1.3024E+01_JPRB/)
KBO( :,37, 8) = (/&
&6.9879E+00_JPRB,8.1265E+00_JPRB,9.4503E+00_JPRB,1.0942E+01_JPRB,1.2567E+01_JPRB/)
KBO( :,38, 8) = (/&
&6.5288E+00_JPRB,7.6643E+00_JPRB,8.9952E+00_JPRB,1.0502E+01_JPRB,1.2144E+01_JPRB/)
KBO( :,39, 8) = (/&
&6.1286E+00_JPRB,7.2600E+00_JPRB,8.5928E+00_JPRB,1.0109E+01_JPRB,1.1767E+01_JPRB/)
KBO( :,40, 8) = (/&
&5.6684E+00_JPRB,6.7740E+00_JPRB,8.0799E+00_JPRB,9.5804E+00_JPRB,1.1233E+01_JPRB/)
KBO( :,41, 8) = (/&
&5.2402E+00_JPRB,6.3138E+00_JPRB,7.5882E+00_JPRB,9.0624E+00_JPRB,1.0701E+01_JPRB/)
KBO( :,42, 8) = (/&
&4.8506E+00_JPRB,5.8918E+00_JPRB,7.1323E+00_JPRB,8.5740E+00_JPRB,1.0194E+01_JPRB/)
KBO( :,43, 8) = (/&
&4.4438E+00_JPRB,5.4412E+00_JPRB,6.6345E+00_JPRB,8.0293E+00_JPRB,9.6145E+00_JPRB/)
KBO( :,44, 8) = (/&
&4.0493E+00_JPRB,4.9983E+00_JPRB,6.1400E+00_JPRB,7.4797E+00_JPRB,9.0187E+00_JPRB/)
KBO( :,45, 8) = (/&
&3.6876E+00_JPRB,4.5888E+00_JPRB,5.6785E+00_JPRB,6.9623E+00_JPRB,8.4500E+00_JPRB/)
KBO( :,46, 8) = (/&
&3.3383E+00_JPRB,4.1880E+00_JPRB,5.2207E+00_JPRB,6.4454E+00_JPRB,7.8745E+00_JPRB/)
KBO( :,47, 8) = (/&
&2.9856E+00_JPRB,3.7780E+00_JPRB,4.7472E+00_JPRB,5.9041E+00_JPRB,7.2615E+00_JPRB/)
KBO( :,48, 8) = (/&
&2.6572E+00_JPRB,3.4003E+00_JPRB,4.3078E+00_JPRB,5.3986E+00_JPRB,6.6852E+00_JPRB/)
KBO( :,49, 8) = (/&
&2.3488E+00_JPRB,3.0535E+00_JPRB,3.9013E+00_JPRB,4.9276E+00_JPRB,6.1472E+00_JPRB/)
KBO( :,50, 8) = (/&
&2.0729E+00_JPRB,2.7473E+00_JPRB,3.5436E+00_JPRB,4.5091E+00_JPRB,5.6655E+00_JPRB/)
KBO( :,51, 8) = (/&
&1.8206E+00_JPRB,2.4651E+00_JPRB,3.2190E+00_JPRB,4.1264E+00_JPRB,5.2204E+00_JPRB/)
KBO( :,52, 8) = (/&
&1.5859E+00_JPRB,2.1977E+00_JPRB,2.9176E+00_JPRB,3.7698E+00_JPRB,4.8036E+00_JPRB/)
KBO( :,53, 8) = (/&
&1.3682E+00_JPRB,1.9445E+00_JPRB,2.6333E+00_JPRB,3.4378E+00_JPRB,4.4138E+00_JPRB/)
KBO( :,54, 8) = (/&
&1.1812E+00_JPRB,1.7215E+00_JPRB,2.3803E+00_JPRB,3.1453E+00_JPRB,4.0633E+00_JPRB/)
KBO( :,55, 8) = (/&
&1.0150E+00_JPRB,1.5193E+00_JPRB,2.1463E+00_JPRB,2.8770E+00_JPRB,3.7398E+00_JPRB/)
KBO( :,56, 8) = (/&
&8.6368E-01_JPRB,1.3309E+00_JPRB,1.9241E+00_JPRB,2.6237E+00_JPRB,3.4375E+00_JPRB/)
KBO( :,57, 8) = (/&
&7.2682E-01_JPRB,1.1556E+00_JPRB,1.7137E+00_JPRB,2.3824E+00_JPRB,3.1551E+00_JPRB/)
KBO( :,58, 8) = (/&
&6.0967E-01_JPRB,1.0012E+00_JPRB,1.5247E+00_JPRB,2.1627E+00_JPRB,2.9020E+00_JPRB/)
KBO( :,59, 8) = (/&
&5.5853E-01_JPRB,9.3598E-01_JPRB,1.4448E+00_JPRB,2.0692E+00_JPRB,2.7925E+00_JPRB/)
KBO( :,13, 9) = (/&
&9.9288E+01_JPRB,9.7856E+01_JPRB,9.6419E+01_JPRB,9.4961E+01_JPRB,9.3473E+01_JPRB/)
KBO( :,14, 9) = (/&
&1.0412E+02_JPRB,1.0269E+02_JPRB,1.0123E+02_JPRB,9.9736E+01_JPRB,9.8238E+01_JPRB/)
KBO( :,15, 9) = (/&
&1.0817E+02_JPRB,1.0679E+02_JPRB,1.0540E+02_JPRB,1.0396E+02_JPRB,1.0249E+02_JPRB/)
KBO( :,16, 9) = (/&
&1.1129E+02_JPRB,1.1004E+02_JPRB,1.0873E+02_JPRB,1.0740E+02_JPRB,1.0603E+02_JPRB/)
KBO( :,17, 9) = (/&
&1.1340E+02_JPRB,1.1230E+02_JPRB,1.1113E+02_JPRB,1.0995E+02_JPRB,1.0873E+02_JPRB/)
KBO( :,18, 9) = (/&
&1.1434E+02_JPRB,1.1342E+02_JPRB,1.1248E+02_JPRB,1.1144E+02_JPRB,1.1034E+02_JPRB/)
KBO( :,19, 9) = (/&
&1.1401E+02_JPRB,1.1333E+02_JPRB,1.1256E+02_JPRB,1.1172E+02_JPRB,1.1083E+02_JPRB/)
KBO( :,20, 9) = (/&
&1.1234E+02_JPRB,1.1193E+02_JPRB,1.1143E+02_JPRB,1.1085E+02_JPRB,1.1019E+02_JPRB/)
KBO( :,21, 9) = (/&
&1.0946E+02_JPRB,1.0935E+02_JPRB,1.0914E+02_JPRB,1.0884E+02_JPRB,1.0846E+02_JPRB/)
KBO( :,22, 9) = (/&
&1.0557E+02_JPRB,1.0577E+02_JPRB,1.0588E+02_JPRB,1.0590E+02_JPRB,1.0584E+02_JPRB/)
KBO( :,23, 9) = (/&
&1.0094E+02_JPRB,1.0149E+02_JPRB,1.0194E+02_JPRB,1.0233E+02_JPRB,1.0260E+02_JPRB/)
KBO( :,24, 9) = (/&
&9.5817E+01_JPRB,9.6736E+01_JPRB,9.7569E+01_JPRB,9.8330E+01_JPRB,9.9010E+01_JPRB/)
KBO( :,25, 9) = (/&
&9.0469E+01_JPRB,9.1797E+01_JPRB,9.3074E+01_JPRB,9.4238E+01_JPRB,9.5339E+01_JPRB/)
KBO( :,26, 9) = (/&
&8.5212E+01_JPRB,8.6963E+01_JPRB,8.8676E+01_JPRB,9.0313E+01_JPRB,9.1842E+01_JPRB/)
KBO( :,27, 9) = (/&
&8.0235E+01_JPRB,8.2437E+01_JPRB,8.4599E+01_JPRB,8.6731E+01_JPRB,8.8747E+01_JPRB/)
KBO( :,28, 9) = (/&
&7.5722E+01_JPRB,7.8382E+01_JPRB,8.1040E+01_JPRB,8.3660E+01_JPRB,8.6177E+01_JPRB/)
KBO( :,29, 9) = (/&
&7.1851E+01_JPRB,7.4992E+01_JPRB,7.8130E+01_JPRB,8.1223E+01_JPRB,8.4209E+01_JPRB/)
KBO( :,30, 9) = (/&
&6.8679E+01_JPRB,7.2286E+01_JPRB,7.5891E+01_JPRB,7.9421E+01_JPRB,8.2811E+01_JPRB/)
KBO( :,31, 9) = (/&
&6.6225E+01_JPRB,7.0279E+01_JPRB,7.4326E+01_JPRB,7.8245E+01_JPRB,8.1966E+01_JPRB/)
KBO( :,32, 9) = (/&
&6.4479E+01_JPRB,6.8946E+01_JPRB,7.3367E+01_JPRB,7.7627E+01_JPRB,8.1643E+01_JPRB/)
KBO( :,33, 9) = (/&
&6.3393E+01_JPRB,6.8225E+01_JPRB,7.2967E+01_JPRB,7.7506E+01_JPRB,8.1771E+01_JPRB/)
KBO( :,34, 9) = (/&
&6.2705E+01_JPRB,6.7842E+01_JPRB,7.2848E+01_JPRB,7.7622E+01_JPRB,8.2086E+01_JPRB/)
KBO( :,35, 9) = (/&
&6.1970E+01_JPRB,6.7369E+01_JPRB,7.2611E+01_JPRB,7.7614E+01_JPRB,8.2278E+01_JPRB/)
KBO( :,36, 9) = (/&
&6.0967E+01_JPRB,6.6598E+01_JPRB,7.2072E+01_JPRB,7.7300E+01_JPRB,8.2185E+01_JPRB/)
KBO( :,37, 9) = (/&
&5.9279E+01_JPRB,6.5142E+01_JPRB,7.0846E+01_JPRB,7.6292E+01_JPRB,8.1436E+01_JPRB/)
KBO( :,38, 9) = (/&
&5.7701E+01_JPRB,6.3776E+01_JPRB,6.9699E+01_JPRB,7.5382E+01_JPRB,8.0760E+01_JPRB/)
KBO( :,39, 9) = (/&
&5.6270E+01_JPRB,6.2546E+01_JPRB,6.8688E+01_JPRB,7.4617E+01_JPRB,8.0162E+01_JPRB/)
KBO( :,40, 9) = (/&
&5.4230E+01_JPRB,6.0690E+01_JPRB,6.6996E+01_JPRB,7.3138E+01_JPRB,7.8857E+01_JPRB/)
KBO( :,41, 9) = (/&
&5.2156E+01_JPRB,5.8758E+01_JPRB,6.5235E+01_JPRB,7.1572E+01_JPRB,7.7464E+01_JPRB/)
KBO( :,42, 9) = (/&
&5.0129E+01_JPRB,5.6855E+01_JPRB,6.3499E+01_JPRB,7.0016E+01_JPRB,7.6080E+01_JPRB/)
KBO( :,43, 9) = (/&
&4.7760E+01_JPRB,5.4598E+01_JPRB,6.1399E+01_JPRB,6.8099E+01_JPRB,7.4350E+01_JPRB/)
KBO( :,44, 9) = (/&
&4.5249E+01_JPRB,5.2184E+01_JPRB,5.9131E+01_JPRB,6.6010E+01_JPRB,7.2452E+01_JPRB/)
KBO( :,45, 9) = (/&
&4.2770E+01_JPRB,4.9790E+01_JPRB,5.6875E+01_JPRB,6.3919E+01_JPRB,7.0547E+01_JPRB/)
KBO( :,46, 9) = (/&
&4.0163E+01_JPRB,4.7243E+01_JPRB,5.4479E+01_JPRB,6.1655E+01_JPRB,6.8464E+01_JPRB/)
KBO( :,47, 9) = (/&
&3.7279E+01_JPRB,4.4372E+01_JPRB,5.1688E+01_JPRB,5.9007E+01_JPRB,6.6000E+01_JPRB/)
KBO( :,48, 9) = (/&
&3.4455E+01_JPRB,4.1531E+01_JPRB,4.8914E+01_JPRB,5.6355E+01_JPRB,6.3516E+01_JPRB/)
KBO( :,49, 9) = (/&
&3.1707E+01_JPRB,3.8733E+01_JPRB,4.6179E+01_JPRB,5.3719E+01_JPRB,6.1038E+01_JPRB/)
KBO( :,50, 9) = (/&
&2.9168E+01_JPRB,3.6084E+01_JPRB,4.3531E+01_JPRB,5.1127E+01_JPRB,5.8574E+01_JPRB/)
KBO( :,51, 9) = (/&
&2.6765E+01_JPRB,3.3523E+01_JPRB,4.0920E+01_JPRB,4.8550E+01_JPRB,5.6098E+01_JPRB/)
KBO( :,52, 9) = (/&
&2.4432E+01_JPRB,3.1037E+01_JPRB,3.8359E+01_JPRB,4.5995E+01_JPRB,5.3635E+01_JPRB/)
KBO( :,53, 9) = (/&
&2.2208E+01_JPRB,2.8629E+01_JPRB,3.5855E+01_JPRB,4.3474E+01_JPRB,5.1186E+01_JPRB/)
KBO( :,54, 9) = (/&
&2.0205E+01_JPRB,2.6401E+01_JPRB,3.3414E+01_JPRB,4.0973E+01_JPRB,4.8699E+01_JPRB/)
KBO( :,55, 9) = (/&
&1.8353E+01_JPRB,2.4282E+01_JPRB,3.1024E+01_JPRB,3.8470E+01_JPRB,4.6173E+01_JPRB/)
KBO( :,56, 9) = (/&
&1.6601E+01_JPRB,2.2262E+01_JPRB,2.8733E+01_JPRB,3.6003E+01_JPRB,4.3640E+01_JPRB/)
KBO( :,57, 9) = (/&
&1.4942E+01_JPRB,2.0332E+01_JPRB,2.6541E+01_JPRB,3.3571E+01_JPRB,4.1137E+01_JPRB/)
KBO( :,58, 9) = (/&
&1.3455E+01_JPRB,1.8580E+01_JPRB,2.4530E+01_JPRB,3.1284E+01_JPRB,3.8733E+01_JPRB/)
KBO( :,59, 9) = (/&
&1.2865E+01_JPRB,1.7859E+01_JPRB,2.3642E+01_JPRB,3.0152E+01_JPRB,3.7359E+01_JPRB/)
KBO( :,13,10) = (/&
&1.4836E+02_JPRB,1.4604E+02_JPRB,1.4370E+02_JPRB,1.4155E+02_JPRB,1.3951E+02_JPRB/)
KBO( :,14,10) = (/&
&1.6431E+02_JPRB,1.6174E+02_JPRB,1.5931E+02_JPRB,1.5707E+02_JPRB,1.5447E+02_JPRB/)
KBO( :,15,10) = (/&
&1.8088E+02_JPRB,1.7844E+02_JPRB,1.7598E+02_JPRB,1.7321E+02_JPRB,1.7049E+02_JPRB/)
KBO( :,16,10) = (/&
&1.9837E+02_JPRB,1.9582E+02_JPRB,1.9294E+02_JPRB,1.9007E+02_JPRB,1.8732E+02_JPRB/)
KBO( :,17,10) = (/&
&2.1550E+02_JPRB,2.1268E+02_JPRB,2.0959E+02_JPRB,2.0637E+02_JPRB,2.0299E+02_JPRB/)
KBO( :,18,10) = (/&
&2.3147E+02_JPRB,2.2811E+02_JPRB,2.2491E+02_JPRB,2.2179E+02_JPRB,2.1873E+02_JPRB/)
KBO( :,19,10) = (/&
&2.4561E+02_JPRB,2.4282E+02_JPRB,2.3998E+02_JPRB,2.3673E+02_JPRB,2.3333E+02_JPRB/)
KBO( :,20,10) = (/&
&2.5875E+02_JPRB,2.5597E+02_JPRB,2.5299E+02_JPRB,2.4975E+02_JPRB,2.4650E+02_JPRB/)
KBO( :,21,10) = (/&
&2.6956E+02_JPRB,2.6694E+02_JPRB,2.6416E+02_JPRB,2.6126E+02_JPRB,2.5829E+02_JPRB/)
KBO( :,22,10) = (/&
&2.7742E+02_JPRB,2.7556E+02_JPRB,2.7346E+02_JPRB,2.7109E+02_JPRB,2.6822E+02_JPRB/)
KBO( :,23,10) = (/&
&2.8259E+02_JPRB,2.8167E+02_JPRB,2.8054E+02_JPRB,2.7877E+02_JPRB,2.7640E+02_JPRB/)
KBO( :,24,10) = (/&
&2.8579E+02_JPRB,2.8593E+02_JPRB,2.8555E+02_JPRB,2.8452E+02_JPRB,2.8281E+02_JPRB/)
KBO( :,25,10) = (/&
&2.8759E+02_JPRB,2.8855E+02_JPRB,2.8897E+02_JPRB,2.8899E+02_JPRB,2.8805E+02_JPRB/)
KBO( :,26,10) = (/&
&2.8827E+02_JPRB,2.9039E+02_JPRB,2.9171E+02_JPRB,2.9254E+02_JPRB,2.9232E+02_JPRB/)
KBO( :,27,10) = (/&
&2.8831E+02_JPRB,2.9160E+02_JPRB,2.9410E+02_JPRB,2.9547E+02_JPRB,2.9582E+02_JPRB/)
KBO( :,28,10) = (/&
&2.8830E+02_JPRB,2.9281E+02_JPRB,2.9591E+02_JPRB,2.9817E+02_JPRB,2.9880E+02_JPRB/)
KBO( :,29,10) = (/&
&2.8819E+02_JPRB,2.9390E+02_JPRB,2.9762E+02_JPRB,3.0035E+02_JPRB,3.0140E+02_JPRB/)
KBO( :,30,10) = (/&
&2.8853E+02_JPRB,2.9509E+02_JPRB,2.9931E+02_JPRB,3.0230E+02_JPRB,3.0384E+02_JPRB/)
KBO( :,31,10) = (/&
&2.8941E+02_JPRB,2.9638E+02_JPRB,3.0093E+02_JPRB,3.0407E+02_JPRB,3.0610E+02_JPRB/)
KBO( :,32,10) = (/&
&2.9067E+02_JPRB,2.9787E+02_JPRB,3.0275E+02_JPRB,3.0577E+02_JPRB,3.0795E+02_JPRB/)
KBO( :,33,10) = (/&
&2.9222E+02_JPRB,2.9942E+02_JPRB,3.0456E+02_JPRB,3.0752E+02_JPRB,3.0966E+02_JPRB/)
KBO( :,34,10) = (/&
&2.9363E+02_JPRB,3.0091E+02_JPRB,3.0608E+02_JPRB,3.0904E+02_JPRB,3.1115E+02_JPRB/)
KBO( :,35,10) = (/&
&2.9423E+02_JPRB,3.0182E+02_JPRB,3.0717E+02_JPRB,3.1018E+02_JPRB,3.1229E+02_JPRB/)
KBO( :,36,10) = (/&
&2.9400E+02_JPRB,3.0205E+02_JPRB,3.0771E+02_JPRB,3.1091E+02_JPRB,3.1314E+02_JPRB/)
KBO( :,37,10) = (/&
&2.9277E+02_JPRB,3.0116E+02_JPRB,3.0745E+02_JPRB,3.1132E+02_JPRB,3.1369E+02_JPRB/)
KBO( :,38,10) = (/&
&2.9103E+02_JPRB,3.0008E+02_JPRB,3.0698E+02_JPRB,3.1126E+02_JPRB,3.1405E+02_JPRB/)
KBO( :,39,10) = (/&
&2.8923E+02_JPRB,2.9890E+02_JPRB,3.0637E+02_JPRB,3.1107E+02_JPRB,3.1517E+02_JPRB/)
KBO( :,40,10) = (/&
&2.8609E+02_JPRB,2.9711E+02_JPRB,3.0497E+02_JPRB,3.1036E+02_JPRB,3.1550E+02_JPRB/)
KBO( :,41,10) = (/&
&2.8252E+02_JPRB,2.9448E+02_JPRB,3.0316E+02_JPRB,3.0942E+02_JPRB,3.1556E+02_JPRB/)
KBO( :,42,10) = (/&
&2.7862E+02_JPRB,2.9160E+02_JPRB,3.0113E+02_JPRB,3.0834E+02_JPRB,3.1556E+02_JPRB/)
KBO( :,43,10) = (/&
&2.7361E+02_JPRB,2.8779E+02_JPRB,2.9836E+02_JPRB,3.0666E+02_JPRB,3.1512E+02_JPRB/)
KBO( :,44,10) = (/&
&2.6782E+02_JPRB,2.8324E+02_JPRB,2.9499E+02_JPRB,3.0453E+02_JPRB,3.1441E+02_JPRB/)
KBO( :,45,10) = (/&
&2.6165E+02_JPRB,2.7823E+02_JPRB,2.9120E+02_JPRB,3.0219E+02_JPRB,3.1362E+02_JPRB/)
KBO( :,46,10) = (/&
&2.5462E+02_JPRB,2.7249E+02_JPRB,2.8693E+02_JPRB,2.9929E+02_JPRB,3.1228E+02_JPRB/)
KBO( :,47,10) = (/&
&2.4622E+02_JPRB,2.6556E+02_JPRB,2.8145E+02_JPRB,2.9525E+02_JPRB,3.0983E+02_JPRB/)
KBO( :,48,10) = (/&
&2.3713E+02_JPRB,2.5803E+02_JPRB,2.7541E+02_JPRB,2.9095E+02_JPRB,3.0719E+02_JPRB/)
KBO( :,49,10) = (/&
&2.2739E+02_JPRB,2.4986E+02_JPRB,2.6881E+02_JPRB,2.8662E+02_JPRB,3.0453E+02_JPRB/)
KBO( :,50,10) = (/&
&2.1772E+02_JPRB,2.4169E+02_JPRB,2.6202E+02_JPRB,2.8158E+02_JPRB,3.0094E+02_JPRB/)
KBO( :,51,10) = (/&
&2.0784E+02_JPRB,2.3330E+02_JPRB,2.5496E+02_JPRB,2.7591E+02_JPRB,2.9666E+02_JPRB/)
KBO( :,52,10) = (/&
&1.9746E+02_JPRB,2.2442E+02_JPRB,2.4742E+02_JPRB,2.7004E+02_JPRB,2.9216E+02_JPRB/)
KBO( :,53,10) = (/&
&1.8667E+02_JPRB,2.1498E+02_JPRB,2.3949E+02_JPRB,2.6404E+02_JPRB,2.8766E+02_JPRB/)
KBO( :,54,10) = (/&
&1.7641E+02_JPRB,2.0557E+02_JPRB,2.3152E+02_JPRB,2.5629E+02_JPRB,2.8134E+02_JPRB/)
KBO( :,55,10) = (/&
&1.6630E+02_JPRB,1.9645E+02_JPRB,2.2352E+02_JPRB,2.4801E+02_JPRB,2.7356E+02_JPRB/)
KBO( :,56,10) = (/&
&1.5594E+02_JPRB,1.8700E+02_JPRB,2.1520E+02_JPRB,2.3992E+02_JPRB,2.6576E+02_JPRB/)
KBO( :,57,10) = (/&
&1.4539E+02_JPRB,1.7728E+02_JPRB,2.0648E+02_JPRB,2.3204E+02_JPRB,2.5725E+02_JPRB/)
KBO( :,58,10) = (/&
&1.3524E+02_JPRB,1.6780E+02_JPRB,1.9789E+02_JPRB,2.2459E+02_JPRB,2.4918E+02_JPRB/)
KBO( :,59,10) = (/&
&1.3112E+02_JPRB,1.6391E+02_JPRB,1.9433E+02_JPRB,2.2152E+02_JPRB,2.4535E+02_JPRB/)
KBO( :,13,11) = (/&
&1.6552E+02_JPRB,1.6259E+02_JPRB,1.5976E+02_JPRB,1.5701E+02_JPRB,1.5440E+02_JPRB/)
KBO( :,14,11) = (/&
&1.8516E+02_JPRB,1.8233E+02_JPRB,1.7933E+02_JPRB,1.7635E+02_JPRB,1.7362E+02_JPRB/)
KBO( :,15,11) = (/&
&2.0794E+02_JPRB,2.0481E+02_JPRB,2.0174E+02_JPRB,1.9859E+02_JPRB,1.9534E+02_JPRB/)
KBO( :,16,11) = (/&
&2.3251E+02_JPRB,2.2934E+02_JPRB,2.2596E+02_JPRB,2.2193E+02_JPRB,2.1747E+02_JPRB/)
KBO( :,17,11) = (/&
&2.5822E+02_JPRB,2.5449E+02_JPRB,2.5028E+02_JPRB,2.4575E+02_JPRB,2.4111E+02_JPRB/)
KBO( :,18,11) = (/&
&2.8377E+02_JPRB,2.7983E+02_JPRB,2.7512E+02_JPRB,2.7022E+02_JPRB,2.6507E+02_JPRB/)
KBO( :,19,11) = (/&
&3.0872E+02_JPRB,3.0403E+02_JPRB,2.9887E+02_JPRB,2.9373E+02_JPRB,2.8833E+02_JPRB/)
KBO( :,20,11) = (/&
&3.3154E+02_JPRB,3.2667E+02_JPRB,3.2149E+02_JPRB,3.1658E+02_JPRB,3.1110E+02_JPRB/)
KBO( :,21,11) = (/&
&3.5303E+02_JPRB,3.4859E+02_JPRB,3.4368E+02_JPRB,3.3863E+02_JPRB,3.3281E+02_JPRB/)
KBO( :,22,11) = (/&
&3.7308E+02_JPRB,3.6866E+02_JPRB,3.6382E+02_JPRB,3.5853E+02_JPRB,3.5259E+02_JPRB/)
KBO( :,23,11) = (/&
&3.9085E+02_JPRB,3.8660E+02_JPRB,3.8185E+02_JPRB,3.7650E+02_JPRB,3.7123E+02_JPRB/)
KBO( :,24,11) = (/&
&4.0631E+02_JPRB,4.0255E+02_JPRB,3.9828E+02_JPRB,3.9348E+02_JPRB,3.8793E+02_JPRB/)
KBO( :,25,11) = (/&
&4.1938E+02_JPRB,4.1686E+02_JPRB,4.1282E+02_JPRB,4.0821E+02_JPRB,4.0269E+02_JPRB/)
KBO( :,26,11) = (/&
&4.3004E+02_JPRB,4.2864E+02_JPRB,4.2545E+02_JPRB,4.2097E+02_JPRB,4.1544E+02_JPRB/)
KBO( :,27,11) = (/&
&4.3932E+02_JPRB,4.3875E+02_JPRB,4.3604E+02_JPRB,4.3201E+02_JPRB,4.2641E+02_JPRB/)
KBO( :,28,11) = (/&
&4.4708E+02_JPRB,4.4715E+02_JPRB,4.4516E+02_JPRB,4.4121E+02_JPRB,4.3584E+02_JPRB/)
KBO( :,29,11) = (/&
&4.5390E+02_JPRB,4.5431E+02_JPRB,4.5282E+02_JPRB,4.4905E+02_JPRB,4.4353E+02_JPRB/)
KBO( :,30,11) = (/&
&4.5978E+02_JPRB,4.6051E+02_JPRB,4.5914E+02_JPRB,4.5563E+02_JPRB,4.4966E+02_JPRB/)
KBO( :,31,11) = (/&
&4.6502E+02_JPRB,4.6582E+02_JPRB,4.6429E+02_JPRB,4.6092E+02_JPRB,4.5451E+02_JPRB/)
KBO( :,32,11) = (/&
&4.6952E+02_JPRB,4.7023E+02_JPRB,4.6854E+02_JPRB,4.6499E+02_JPRB,4.5830E+02_JPRB/)
KBO( :,33,11) = (/&
&4.7348E+02_JPRB,4.7409E+02_JPRB,4.7192E+02_JPRB,4.6794E+02_JPRB,4.6103E+02_JPRB/)
KBO( :,34,11) = (/&
&4.7685E+02_JPRB,4.7731E+02_JPRB,4.7475E+02_JPRB,4.7028E+02_JPRB,4.6319E+02_JPRB/)
KBO( :,35,11) = (/&
&4.7958E+02_JPRB,4.8002E+02_JPRB,4.7736E+02_JPRB,4.7259E+02_JPRB,4.6551E+02_JPRB/)
KBO( :,36,11) = (/&
&4.8169E+02_JPRB,4.8240E+02_JPRB,4.7987E+02_JPRB,4.7499E+02_JPRB,4.6813E+02_JPRB/)
KBO( :,37,11) = (/&
&4.8298E+02_JPRB,4.8446E+02_JPRB,4.8243E+02_JPRB,4.7809E+02_JPRB,4.7147E+02_JPRB/)
KBO( :,38,11) = (/&
&4.8394E+02_JPRB,4.8606E+02_JPRB,4.8459E+02_JPRB,4.8068E+02_JPRB,4.7405E+02_JPRB/)
KBO( :,39,11) = (/&
&4.8451E+02_JPRB,4.8733E+02_JPRB,4.8637E+02_JPRB,4.8291E+02_JPRB,4.7658E+02_JPRB/)
KBO( :,40,11) = (/&
&4.8421E+02_JPRB,4.8736E+02_JPRB,4.8800E+02_JPRB,4.8523E+02_JPRB,4.7946E+02_JPRB/)
KBO( :,41,11) = (/&
&4.8335E+02_JPRB,4.8764E+02_JPRB,4.8927E+02_JPRB,4.8717E+02_JPRB,4.8206E+02_JPRB/)
KBO( :,42,11) = (/&
&4.8204E+02_JPRB,4.8748E+02_JPRB,4.9006E+02_JPRB,4.8875E+02_JPRB,4.8434E+02_JPRB/)
KBO( :,43,11) = (/&
&4.7975E+02_JPRB,4.8654E+02_JPRB,4.9041E+02_JPRB,4.9008E+02_JPRB,4.8652E+02_JPRB/)
KBO( :,44,11) = (/&
&4.7655E+02_JPRB,4.8494E+02_JPRB,4.9019E+02_JPRB,4.9098E+02_JPRB,4.8839E+02_JPRB/)
KBO( :,45,11) = (/&
&4.7253E+02_JPRB,4.8276E+02_JPRB,4.8943E+02_JPRB,4.9145E+02_JPRB,4.9003E+02_JPRB/)
KBO( :,46,11) = (/&
&4.6734E+02_JPRB,4.7968E+02_JPRB,4.8743E+02_JPRB,4.9144E+02_JPRB,4.9142E+02_JPRB/)
KBO( :,47,11) = (/&
&4.6037E+02_JPRB,4.7532E+02_JPRB,4.8503E+02_JPRB,4.9075E+02_JPRB,4.9230E+02_JPRB/)
KBO( :,48,11) = (/&
&4.5226E+02_JPRB,4.6987E+02_JPRB,4.8198E+02_JPRB,4.8932E+02_JPRB,4.9295E+02_JPRB/)
KBO( :,49,11) = (/&
&4.4290E+02_JPRB,4.6342E+02_JPRB,4.7813E+02_JPRB,4.8707E+02_JPRB,4.9364E+02_JPRB/)
KBO( :,50,11) = (/&
&4.3303E+02_JPRB,4.5634E+02_JPRB,4.7362E+02_JPRB,4.8430E+02_JPRB,4.9319E+02_JPRB/)
KBO( :,51,11) = (/&
&4.2231E+02_JPRB,4.4854E+02_JPRB,4.6823E+02_JPRB,4.8097E+02_JPRB,4.9173E+02_JPRB/)
KBO( :,52,11) = (/&
&4.1028E+02_JPRB,4.3983E+02_JPRB,4.6194E+02_JPRB,4.7695E+02_JPRB,4.9018E+02_JPRB/)
KBO( :,53,11) = (/&
&3.9747E+02_JPRB,4.3006E+02_JPRB,4.5475E+02_JPRB,4.7218E+02_JPRB,4.8896E+02_JPRB/)
KBO( :,54,11) = (/&
&3.8468E+02_JPRB,4.1991E+02_JPRB,4.4737E+02_JPRB,4.6699E+02_JPRB,4.8405E+02_JPRB/)
KBO( :,55,11) = (/&
&3.7148E+02_JPRB,4.0953E+02_JPRB,4.3953E+02_JPRB,4.6157E+02_JPRB,4.7789E+02_JPRB/)
KBO( :,56,11) = (/&
&3.5741E+02_JPRB,3.9825E+02_JPRB,4.3092E+02_JPRB,4.5516E+02_JPRB,4.7290E+02_JPRB/)
KBO( :,57,11) = (/&
&3.4261E+02_JPRB,3.8598E+02_JPRB,4.2152E+02_JPRB,4.4813E+02_JPRB,4.6777E+02_JPRB/)
KBO( :,58,11) = (/&
&3.2780E+02_JPRB,3.7359E+02_JPRB,4.1192E+02_JPRB,4.4072E+02_JPRB,4.6249E+02_JPRB/)
KBO( :,59,11) = (/&
&3.2152E+02_JPRB,3.6839E+02_JPRB,4.0780E+02_JPRB,4.3751E+02_JPRB,4.6016E+02_JPRB/)
KBO( :,13,12) = (/&
&1.8421E+02_JPRB,1.8166E+02_JPRB,1.7879E+02_JPRB,1.7574E+02_JPRB,1.7251E+02_JPRB/)
KBO( :,14,12) = (/&
&2.0903E+02_JPRB,2.0619E+02_JPRB,2.0324E+02_JPRB,1.9988E+02_JPRB,1.9636E+02_JPRB/)
KBO( :,15,12) = (/&
&2.3780E+02_JPRB,2.3442E+02_JPRB,2.3068E+02_JPRB,2.2666E+02_JPRB,2.2225E+02_JPRB/)
KBO( :,16,12) = (/&
&2.7012E+02_JPRB,2.6570E+02_JPRB,2.6084E+02_JPRB,2.5612E+02_JPRB,2.5162E+02_JPRB/)
KBO( :,17,12) = (/&
&3.0507E+02_JPRB,2.9990E+02_JPRB,2.9472E+02_JPRB,2.8913E+02_JPRB,2.8362E+02_JPRB/)
KBO( :,18,12) = (/&
&3.4264E+02_JPRB,3.3653E+02_JPRB,3.3027E+02_JPRB,3.2388E+02_JPRB,3.1713E+02_JPRB/)
KBO( :,19,12) = (/&
&3.8113E+02_JPRB,3.7455E+02_JPRB,3.6765E+02_JPRB,3.6040E+02_JPRB,3.5292E+02_JPRB/)
KBO( :,20,12) = (/&
&4.2119E+02_JPRB,4.1426E+02_JPRB,4.0655E+02_JPRB,3.9813E+02_JPRB,3.8981E+02_JPRB/)
KBO( :,21,12) = (/&
&4.6191E+02_JPRB,4.5363E+02_JPRB,4.4508E+02_JPRB,4.3611E+02_JPRB,4.2662E+02_JPRB/)
KBO( :,22,12) = (/&
&5.0045E+02_JPRB,4.9187E+02_JPRB,4.8228E+02_JPRB,4.7267E+02_JPRB,4.6269E+02_JPRB/)
KBO( :,23,12) = (/&
&5.3771E+02_JPRB,5.2859E+02_JPRB,5.1832E+02_JPRB,5.0803E+02_JPRB,4.9670E+02_JPRB/)
KBO( :,24,12) = (/&
&5.7227E+02_JPRB,5.6260E+02_JPRB,5.5214E+02_JPRB,5.4076E+02_JPRB,5.2846E+02_JPRB/)
KBO( :,25,12) = (/&
&6.0401E+02_JPRB,5.9384E+02_JPRB,5.8279E+02_JPRB,5.7065E+02_JPRB,5.5724E+02_JPRB/)
KBO( :,26,12) = (/&
&6.3275E+02_JPRB,6.2182E+02_JPRB,6.0975E+02_JPRB,5.9668E+02_JPRB,5.8248E+02_JPRB/)
KBO( :,27,12) = (/&
&6.5788E+02_JPRB,6.4612E+02_JPRB,6.3329E+02_JPRB,6.1912E+02_JPRB,6.0393E+02_JPRB/)
KBO( :,28,12) = (/&
&6.7977E+02_JPRB,6.6741E+02_JPRB,6.5368E+02_JPRB,6.3839E+02_JPRB,6.2186E+02_JPRB/)
KBO( :,29,12) = (/&
&6.9860E+02_JPRB,6.8540E+02_JPRB,6.7056E+02_JPRB,6.5407E+02_JPRB,6.3669E+02_JPRB/)
KBO( :,30,12) = (/&
&7.1428E+02_JPRB,7.0014E+02_JPRB,6.8436E+02_JPRB,6.6687E+02_JPRB,6.4843E+02_JPRB/)
KBO( :,31,12) = (/&
&7.2707E+02_JPRB,7.1224E+02_JPRB,6.9535E+02_JPRB,6.7679E+02_JPRB,6.5732E+02_JPRB/)
KBO( :,32,12) = (/&
&7.3739E+02_JPRB,7.2161E+02_JPRB,7.0352E+02_JPRB,6.8424E+02_JPRB,6.6374E+02_JPRB/)
KBO( :,33,12) = (/&
&7.4529E+02_JPRB,7.2852E+02_JPRB,7.0939E+02_JPRB,6.8945E+02_JPRB,6.6810E+02_JPRB/)
KBO( :,34,12) = (/&
&7.5166E+02_JPRB,7.3380E+02_JPRB,7.1390E+02_JPRB,6.9344E+02_JPRB,6.7141E+02_JPRB/)
KBO( :,35,12) = (/&
&7.5785E+02_JPRB,7.3918E+02_JPRB,7.1874E+02_JPRB,6.9799E+02_JPRB,6.7527E+02_JPRB/)
KBO( :,36,12) = (/&
&7.6435E+02_JPRB,7.4538E+02_JPRB,7.2454E+02_JPRB,7.0358E+02_JPRB,6.8040E+02_JPRB/)
KBO( :,37,12) = (/&
&7.7161E+02_JPRB,7.5340E+02_JPRB,7.3251E+02_JPRB,7.1089E+02_JPRB,6.8800E+02_JPRB/)
KBO( :,38,12) = (/&
&7.7853E+02_JPRB,7.6067E+02_JPRB,7.3983E+02_JPRB,7.1816E+02_JPRB,6.9536E+02_JPRB/)
KBO( :,39,12) = (/&
&7.8464E+02_JPRB,7.6713E+02_JPRB,7.4647E+02_JPRB,7.2475E+02_JPRB,7.0178E+02_JPRB/)
KBO( :,40,12) = (/&
&7.9160E+02_JPRB,7.7414E+02_JPRB,7.5465E+02_JPRB,7.3306E+02_JPRB,7.1009E+02_JPRB/)
KBO( :,41,12) = (/&
&7.9795E+02_JPRB,7.8137E+02_JPRB,7.6252E+02_JPRB,7.4117E+02_JPRB,7.1825E+02_JPRB/)
KBO( :,42,12) = (/&
&8.0363E+02_JPRB,7.8805E+02_JPRB,7.6985E+02_JPRB,7.4880E+02_JPRB,7.2604E+02_JPRB/)
KBO( :,43,12) = (/&
&8.0918E+02_JPRB,7.9503E+02_JPRB,7.7774E+02_JPRB,7.5724E+02_JPRB,7.3478E+02_JPRB/)
KBO( :,44,12) = (/&
&8.1405E+02_JPRB,8.0171E+02_JPRB,7.8561E+02_JPRB,7.6584E+02_JPRB,7.4379E+02_JPRB/)
KBO( :,45,12) = (/&
&8.1783E+02_JPRB,8.0759E+02_JPRB,7.9294E+02_JPRB,7.7397E+02_JPRB,7.5240E+02_JPRB/)
KBO( :,46,12) = (/&
&8.2078E+02_JPRB,8.1309E+02_JPRB,8.0010E+02_JPRB,7.8201E+02_JPRB,7.6131E+02_JPRB/)
KBO( :,47,12) = (/&
&8.2288E+02_JPRB,8.1791E+02_JPRB,8.0688E+02_JPRB,7.9031E+02_JPRB,7.7082E+02_JPRB/)
KBO( :,48,12) = (/&
&8.2365E+02_JPRB,8.2167E+02_JPRB,8.1273E+02_JPRB,7.9796E+02_JPRB,7.7963E+02_JPRB/)
KBO( :,49,12) = (/&
&8.2287E+02_JPRB,8.2431E+02_JPRB,8.1763E+02_JPRB,8.0487E+02_JPRB,7.8791E+02_JPRB/)
KBO( :,50,12) = (/&
&8.2045E+02_JPRB,8.2549E+02_JPRB,8.2124E+02_JPRB,8.1073E+02_JPRB,7.9521E+02_JPRB/)
KBO( :,51,12) = (/&
&8.1647E+02_JPRB,8.2526E+02_JPRB,8.2370E+02_JPRB,8.1563E+02_JPRB,8.0180E+02_JPRB/)
KBO( :,52,12) = (/&
&8.1121E+02_JPRB,8.2367E+02_JPRB,8.2531E+02_JPRB,8.1967E+02_JPRB,8.0788E+02_JPRB/)
KBO( :,53,12) = (/&
&8.0411E+02_JPRB,8.2055E+02_JPRB,8.2579E+02_JPRB,8.2272E+02_JPRB,8.1321E+02_JPRB/)
KBO( :,54,12) = (/&
&7.9588E+02_JPRB,8.1607E+02_JPRB,8.2504E+02_JPRB,8.2471E+02_JPRB,8.1743E+02_JPRB/)
KBO( :,55,12) = (/&
&7.8606E+02_JPRB,8.1098E+02_JPRB,8.2328E+02_JPRB,8.2571E+02_JPRB,8.2076E+02_JPRB/)
KBO( :,56,12) = (/&
&7.7445E+02_JPRB,8.0478E+02_JPRB,8.2051E+02_JPRB,8.2610E+02_JPRB,8.2295E+02_JPRB/)
KBO( :,57,12) = (/&
&7.6082E+02_JPRB,7.9711E+02_JPRB,8.1649E+02_JPRB,8.2552E+02_JPRB,8.2493E+02_JPRB/)
KBO( :,58,12) = (/&
&7.4626E+02_JPRB,7.8808E+02_JPRB,8.1174E+02_JPRB,8.2409E+02_JPRB,8.2621E+02_JPRB/)
KBO( :,59,12) = (/&
&7.3987E+02_JPRB,7.8401E+02_JPRB,8.0954E+02_JPRB,8.2334E+02_JPRB,8.2653E+02_JPRB/)
KBO( :,13,13) = (/&
&2.0706E+02_JPRB,2.0275E+02_JPRB,1.9960E+02_JPRB,1.9642E+02_JPRB,1.9325E+02_JPRB/)
KBO( :,14,13) = (/&
&2.3740E+02_JPRB,2.3314E+02_JPRB,2.2927E+02_JPRB,2.2508E+02_JPRB,2.2071E+02_JPRB/)
KBO( :,15,13) = (/&
&2.7338E+02_JPRB,2.6831E+02_JPRB,2.6304E+02_JPRB,2.5795E+02_JPRB,2.5294E+02_JPRB/)
KBO( :,16,13) = (/&
&3.1308E+02_JPRB,3.0705E+02_JPRB,3.0154E+02_JPRB,2.9582E+02_JPRB,2.8990E+02_JPRB/)
KBO( :,17,13) = (/&
&3.5766E+02_JPRB,3.5096E+02_JPRB,3.4421E+02_JPRB,3.3769E+02_JPRB,3.3070E+02_JPRB/)
KBO( :,18,13) = (/&
&4.0731E+02_JPRB,3.9992E+02_JPRB,3.9262E+02_JPRB,3.8506E+02_JPRB,3.7703E+02_JPRB/)
KBO( :,19,13) = (/&
&4.6388E+02_JPRB,4.5553E+02_JPRB,4.4668E+02_JPRB,4.3762E+02_JPRB,4.2783E+02_JPRB/)
KBO( :,20,13) = (/&
&5.2583E+02_JPRB,5.1576E+02_JPRB,5.0510E+02_JPRB,4.9383E+02_JPRB,4.8218E+02_JPRB/)
KBO( :,21,13) = (/&
&5.9116E+02_JPRB,5.7950E+02_JPRB,5.6656E+02_JPRB,5.5310E+02_JPRB,5.3897E+02_JPRB/)
KBO( :,22,13) = (/&
&6.5823E+02_JPRB,6.4391E+02_JPRB,6.2839E+02_JPRB,6.1210E+02_JPRB,5.9534E+02_JPRB/)
KBO( :,23,13) = (/&
&7.2542E+02_JPRB,7.0808E+02_JPRB,6.8952E+02_JPRB,6.6991E+02_JPRB,6.4969E+02_JPRB/)
KBO( :,24,13) = (/&
&7.9029E+02_JPRB,7.7002E+02_JPRB,7.4790E+02_JPRB,7.2486E+02_JPRB,7.0140E+02_JPRB/)
KBO( :,25,13) = (/&
&8.5203E+02_JPRB,8.2748E+02_JPRB,8.0207E+02_JPRB,7.7556E+02_JPRB,7.4909E+02_JPRB/)
KBO( :,26,13) = (/&
&9.0879E+02_JPRB,8.8008E+02_JPRB,8.5133E+02_JPRB,8.2123E+02_JPRB,7.9187E+02_JPRB/)
KBO( :,27,13) = (/&
&9.5929E+02_JPRB,9.2767E+02_JPRB,8.9539E+02_JPRB,8.6200E+02_JPRB,8.2944E+02_JPRB/)
KBO( :,28,13) = (/&
&1.0038E+03_JPRB,9.6874E+02_JPRB,9.3346E+02_JPRB,8.9698E+02_JPRB,8.6129E+02_JPRB/)
KBO( :,29,13) = (/&
&1.0414E+03_JPRB,1.0031E+03_JPRB,9.6490E+02_JPRB,9.2572E+02_JPRB,8.8715E+02_JPRB/)
KBO( :,30,13) = (/&
&1.0721E+03_JPRB,1.0311E+03_JPRB,9.9002E+02_JPRB,9.4833E+02_JPRB,9.0740E+02_JPRB/)
KBO( :,31,13) = (/&
&1.0964E+03_JPRB,1.0523E+03_JPRB,1.0091E+03_JPRB,9.6516E+02_JPRB,9.2258E+02_JPRB/)
KBO( :,32,13) = (/&
&1.1144E+03_JPRB,1.0680E+03_JPRB,1.0228E+03_JPRB,9.7704E+02_JPRB,9.3296E+02_JPRB/)
KBO( :,33,13) = (/&
&1.1268E+03_JPRB,1.0785E+03_JPRB,1.0318E+03_JPRB,9.8453E+02_JPRB,9.3914E+02_JPRB/)
KBO( :,34,13) = (/&
&1.1363E+03_JPRB,1.0866E+03_JPRB,1.0383E+03_JPRB,9.8991E+02_JPRB,9.4342E+02_JPRB/)
KBO( :,35,13) = (/&
&1.1468E+03_JPRB,1.0959E+03_JPRB,1.0463E+03_JPRB,9.9687E+02_JPRB,9.4938E+02_JPRB/)
KBO( :,36,13) = (/&
&1.1600E+03_JPRB,1.1078E+03_JPRB,1.0572E+03_JPRB,1.0067E+03_JPRB,9.5830E+02_JPRB/)
KBO( :,37,13) = (/&
&1.1790E+03_JPRB,1.1257E+03_JPRB,1.0738E+03_JPRB,1.0220E+03_JPRB,9.7295E+02_JPRB/)
KBO( :,38,13) = (/&
&1.1965E+03_JPRB,1.1423E+03_JPRB,1.0895E+03_JPRB,1.0368E+03_JPRB,9.8736E+02_JPRB/)
KBO( :,39,13) = (/&
&1.2126E+03_JPRB,1.1577E+03_JPRB,1.1039E+03_JPRB,1.0505E+03_JPRB,1.0002E+03_JPRB/)
KBO( :,40,13) = (/&
&1.2331E+03_JPRB,1.1780E+03_JPRB,1.1227E+03_JPRB,1.0686E+03_JPRB,1.0174E+03_JPRB/)
KBO( :,41,13) = (/&
&1.2534E+03_JPRB,1.1977E+03_JPRB,1.1416E+03_JPRB,1.0868E+03_JPRB,1.0348E+03_JPRB/)
KBO( :,42,13) = (/&
&1.2728E+03_JPRB,1.2168E+03_JPRB,1.1600E+03_JPRB,1.1045E+03_JPRB,1.0518E+03_JPRB/)
KBO( :,43,13) = (/&
&1.2945E+03_JPRB,1.2387E+03_JPRB,1.1810E+03_JPRB,1.1249E+03_JPRB,1.0714E+03_JPRB/)
KBO( :,44,13) = (/&
&1.3174E+03_JPRB,1.2614E+03_JPRB,1.2031E+03_JPRB,1.1464E+03_JPRB,1.0923E+03_JPRB/)
KBO( :,45,13) = (/&
&1.3398E+03_JPRB,1.2836E+03_JPRB,1.2250E+03_JPRB,1.1678E+03_JPRB,1.1130E+03_JPRB/)
KBO( :,46,13) = (/&
&1.3628E+03_JPRB,1.3065E+03_JPRB,1.2489E+03_JPRB,1.1905E+03_JPRB,1.1348E+03_JPRB/)
KBO( :,47,13) = (/&
&1.3873E+03_JPRB,1.3317E+03_JPRB,1.2742E+03_JPRB,1.2156E+03_JPRB,1.1587E+03_JPRB/)
KBO( :,48,13) = (/&
&1.4108E+03_JPRB,1.3565E+03_JPRB,1.2991E+03_JPRB,1.2406E+03_JPRB,1.1829E+03_JPRB/)
KBO( :,49,13) = (/&
&1.4335E+03_JPRB,1.3803E+03_JPRB,1.3234E+03_JPRB,1.2654E+03_JPRB,1.2072E+03_JPRB/)
KBO( :,50,13) = (/&
&1.4541E+03_JPRB,1.4021E+03_JPRB,1.3460E+03_JPRB,1.2885E+03_JPRB,1.2302E+03_JPRB/)
KBO( :,51,13) = (/&
&1.4730E+03_JPRB,1.4228E+03_JPRB,1.3681E+03_JPRB,1.3104E+03_JPRB,1.2525E+03_JPRB/)
KBO( :,52,13) = (/&
&1.4907E+03_JPRB,1.4427E+03_JPRB,1.3898E+03_JPRB,1.3321E+03_JPRB,1.2744E+03_JPRB/)
KBO( :,53,13) = (/&
&1.5061E+03_JPRB,1.4619E+03_JPRB,1.4106E+03_JPRB,1.3539E+03_JPRB,1.2962E+03_JPRB/)
KBO( :,54,13) = (/&
&1.5192E+03_JPRB,1.4794E+03_JPRB,1.4292E+03_JPRB,1.3736E+03_JPRB,1.3161E+03_JPRB/)
KBO( :,55,13) = (/&
&1.5309E+03_JPRB,1.4941E+03_JPRB,1.4465E+03_JPRB,1.3926E+03_JPRB,1.3351E+03_JPRB/)
KBO( :,56,13) = (/&
&1.5407E+03_JPRB,1.5075E+03_JPRB,1.4630E+03_JPRB,1.4106E+03_JPRB,1.3542E+03_JPRB/)
KBO( :,57,13) = (/&
&1.5484E+03_JPRB,1.5197E+03_JPRB,1.4789E+03_JPRB,1.4283E+03_JPRB,1.3728E+03_JPRB/)
KBO( :,58,13) = (/&
&1.5535E+03_JPRB,1.5303E+03_JPRB,1.4929E+03_JPRB,1.4443E+03_JPRB,1.3902E+03_JPRB/)
KBO( :,59,13) = (/&
&1.5550E+03_JPRB,1.5344E+03_JPRB,1.4983E+03_JPRB,1.4507E+03_JPRB,1.3972E+03_JPRB/)
KBO( :,13,14) = (/&
&2.5200E+02_JPRB,2.4567E+02_JPRB,2.3912E+02_JPRB,2.3261E+02_JPRB,2.2671E+02_JPRB/)
KBO( :,14,14) = (/&
&2.8356E+02_JPRB,2.7567E+02_JPRB,2.6762E+02_JPRB,2.6041E+02_JPRB,2.5414E+02_JPRB/)
KBO( :,15,14) = (/&
&3.2000E+02_JPRB,3.1086E+02_JPRB,3.0278E+02_JPRB,2.9520E+02_JPRB,2.8835E+02_JPRB/)
KBO( :,16,14) = (/&
&3.6501E+02_JPRB,3.5545E+02_JPRB,3.4663E+02_JPRB,3.3835E+02_JPRB,3.3040E+02_JPRB/)
KBO( :,17,14) = (/&
&4.2043E+02_JPRB,4.1003E+02_JPRB,4.0038E+02_JPRB,3.9117E+02_JPRB,3.8254E+02_JPRB/)
KBO( :,18,14) = (/&
&4.8684E+02_JPRB,4.7541E+02_JPRB,4.6423E+02_JPRB,4.5366E+02_JPRB,4.4317E+02_JPRB/)
KBO( :,19,14) = (/&
&5.6352E+02_JPRB,5.4977E+02_JPRB,5.3699E+02_JPRB,5.2451E+02_JPRB,5.1166E+02_JPRB/)
KBO( :,20,14) = (/&
&6.4946E+02_JPRB,6.3281E+02_JPRB,6.1710E+02_JPRB,6.0187E+02_JPRB,5.8639E+02_JPRB/)
KBO( :,21,14) = (/&
&7.4362E+02_JPRB,7.2356E+02_JPRB,7.0410E+02_JPRB,6.8448E+02_JPRB,6.6564E+02_JPRB/)
KBO( :,22,14) = (/&
&8.4333E+02_JPRB,8.1844E+02_JPRB,7.9450E+02_JPRB,7.7017E+02_JPRB,7.4626E+02_JPRB/)
KBO( :,23,14) = (/&
&9.4680E+02_JPRB,9.1686E+02_JPRB,8.8724E+02_JPRB,8.5711E+02_JPRB,8.2794E+02_JPRB/)
KBO( :,24,14) = (/&
&1.0528E+03_JPRB,1.0161E+03_JPRB,9.7917E+02_JPRB,9.4320E+02_JPRB,9.0772E+02_JPRB/)
KBO( :,25,14) = (/&
&1.1567E+03_JPRB,1.1128E+03_JPRB,1.0684E+03_JPRB,1.0249E+03_JPRB,9.8260E+02_JPRB/)
KBO( :,26,14) = (/&
&1.2530E+03_JPRB,1.2021E+03_JPRB,1.1497E+03_JPRB,1.0989E+03_JPRB,1.0499E+03_JPRB/)
KBO( :,27,14) = (/&
&1.3414E+03_JPRB,1.2817E+03_JPRB,1.2215E+03_JPRB,1.1632E+03_JPRB,1.1083E+03_JPRB/)
KBO( :,28,14) = (/&
&1.4184E+03_JPRB,1.3503E+03_JPRB,1.2822E+03_JPRB,1.2175E+03_JPRB,1.1569E+03_JPRB/)
KBO( :,29,14) = (/&
&1.4829E+03_JPRB,1.4069E+03_JPRB,1.3322E+03_JPRB,1.2616E+03_JPRB,1.1958E+03_JPRB/)
KBO( :,30,14) = (/&
&1.5347E+03_JPRB,1.4521E+03_JPRB,1.3719E+03_JPRB,1.2961E+03_JPRB,1.2258E+03_JPRB/)
KBO( :,31,14) = (/&
&1.5740E+03_JPRB,1.4863E+03_JPRB,1.4011E+03_JPRB,1.3213E+03_JPRB,1.2473E+03_JPRB/)
KBO( :,32,14) = (/&
&1.6019E+03_JPRB,1.5104E+03_JPRB,1.4212E+03_JPRB,1.3381E+03_JPRB,1.2613E+03_JPRB/)
KBO( :,33,14) = (/&
&1.6206E+03_JPRB,1.5254E+03_JPRB,1.4335E+03_JPRB,1.3478E+03_JPRB,1.2690E+03_JPRB/)
KBO( :,34,14) = (/&
&1.6343E+03_JPRB,1.5362E+03_JPRB,1.4422E+03_JPRB,1.3545E+03_JPRB,1.2743E+03_JPRB/)
KBO( :,35,14) = (/&
&1.6513E+03_JPRB,1.5505E+03_JPRB,1.4543E+03_JPRB,1.3647E+03_JPRB,1.2829E+03_JPRB/)
KBO( :,36,14) = (/&
&1.6747E+03_JPRB,1.5711E+03_JPRB,1.4723E+03_JPRB,1.3806E+03_JPRB,1.2969E+03_JPRB/)
KBO( :,37,14) = (/&
&1.7119E+03_JPRB,1.6037E+03_JPRB,1.5018E+03_JPRB,1.4086E+03_JPRB,1.3210E+03_JPRB/)
KBO( :,38,14) = (/&
&1.7464E+03_JPRB,1.6348E+03_JPRB,1.5298E+03_JPRB,1.4339E+03_JPRB,1.3446E+03_JPRB/)
KBO( :,39,14) = (/&
&1.7785E+03_JPRB,1.6638E+03_JPRB,1.5560E+03_JPRB,1.4575E+03_JPRB,1.3661E+03_JPRB/)
KBO( :,40,14) = (/&
&1.8213E+03_JPRB,1.7031E+03_JPRB,1.5916E+03_JPRB,1.4897E+03_JPRB,1.3957E+03_JPRB/)
KBO( :,41,14) = (/&
&1.8650E+03_JPRB,1.7429E+03_JPRB,1.6279E+03_JPRB,1.5226E+03_JPRB,1.4260E+03_JPRB/)
KBO( :,42,14) = (/&
&1.9083E+03_JPRB,1.7822E+03_JPRB,1.6638E+03_JPRB,1.5553E+03_JPRB,1.4560E+03_JPRB/)
KBO( :,43,14) = (/&
&1.9590E+03_JPRB,1.8282E+03_JPRB,1.7062E+03_JPRB,1.5939E+03_JPRB,1.4914E+03_JPRB/)
KBO( :,44,14) = (/&
&2.0135E+03_JPRB,1.8780E+03_JPRB,1.7518E+03_JPRB,1.6354E+03_JPRB,1.5294E+03_JPRB/)
KBO( :,45,14) = (/&
&2.0686E+03_JPRB,1.9283E+03_JPRB,1.7978E+03_JPRB,1.6776E+03_JPRB,1.5679E+03_JPRB/)
KBO( :,46,14) = (/&
&2.1281E+03_JPRB,1.9824E+03_JPRB,1.8468E+03_JPRB,1.7228E+03_JPRB,1.6096E+03_JPRB/)
KBO( :,47,14) = (/&
&2.1954E+03_JPRB,2.0435E+03_JPRB,1.9031E+03_JPRB,1.7740E+03_JPRB,1.6572E+03_JPRB/)
KBO( :,48,14) = (/&
&2.2648E+03_JPRB,2.1064E+03_JPRB,1.9610E+03_JPRB,1.8268E+03_JPRB,1.7061E+03_JPRB/)
KBO( :,49,14) = (/&
&2.3361E+03_JPRB,2.1712E+03_JPRB,2.0209E+03_JPRB,1.8815E+03_JPRB,1.7562E+03_JPRB/)
KBO( :,50,14) = (/&
&2.4045E+03_JPRB,2.2339E+03_JPRB,2.0788E+03_JPRB,1.9343E+03_JPRB,1.8042E+03_JPRB/)
KBO( :,51,14) = (/&
&2.4726E+03_JPRB,2.2963E+03_JPRB,2.1361E+03_JPRB,1.9873E+03_JPRB,1.8522E+03_JPRB/)
KBO( :,52,14) = (/&
&2.5428E+03_JPRB,2.3607E+03_JPRB,2.1949E+03_JPRB,2.0419E+03_JPRB,1.9016E+03_JPRB/)
KBO( :,53,14) = (/&
&2.6141E+03_JPRB,2.4269E+03_JPRB,2.2555E+03_JPRB,2.0978E+03_JPRB,1.9528E+03_JPRB/)
KBO( :,54,14) = (/&
&2.6807E+03_JPRB,2.4886E+03_JPRB,2.3128E+03_JPRB,2.1502E+03_JPRB,2.0011E+03_JPRB/)
KBO( :,55,14) = (/&
&2.7459E+03_JPRB,2.5495E+03_JPRB,2.3693E+03_JPRB,2.2020E+03_JPRB,2.0486E+03_JPRB/)
KBO( :,56,14) = (/&
&2.8130E+03_JPRB,2.6116E+03_JPRB,2.4267E+03_JPRB,2.2548E+03_JPRB,2.0964E+03_JPRB/)
KBO( :,57,14) = (/&
&2.8820E+03_JPRB,2.6749E+03_JPRB,2.4855E+03_JPRB,2.3093E+03_JPRB,2.1460E+03_JPRB/)
KBO( :,58,14) = (/&
&2.9481E+03_JPRB,2.7364E+03_JPRB,2.5424E+03_JPRB,2.3624E+03_JPRB,2.1944E+03_JPRB/)
KBO( :,59,14) = (/&
&2.9753E+03_JPRB,2.7616E+03_JPRB,2.5658E+03_JPRB,2.3843E+03_JPRB,2.2142E+03_JPRB/)
KBO( :,13,15) = (/&
&3.0496E+02_JPRB,3.0081E+02_JPRB,2.9676E+02_JPRB,2.9051E+02_JPRB,2.8450E+02_JPRB/)
KBO( :,14,15) = (/&
&3.4462E+02_JPRB,3.4099E+02_JPRB,3.3527E+02_JPRB,3.3016E+02_JPRB,3.2406E+02_JPRB/)
KBO( :,15,15) = (/&
&3.8936E+02_JPRB,3.8628E+02_JPRB,3.8183E+02_JPRB,3.7492E+02_JPRB,3.6807E+02_JPRB/)
KBO( :,16,15) = (/&
&4.4332E+02_JPRB,4.3856E+02_JPRB,4.3430E+02_JPRB,4.2589E+02_JPRB,4.1877E+02_JPRB/)
KBO( :,17,15) = (/&
&5.0835E+02_JPRB,5.0183E+02_JPRB,4.9489E+02_JPRB,4.8561E+02_JPRB,4.7621E+02_JPRB/)
KBO( :,18,15) = (/&
&5.8677E+02_JPRB,5.7885E+02_JPRB,5.6791E+02_JPRB,5.5537E+02_JPRB,5.4279E+02_JPRB/)
KBO( :,19,15) = (/&
&6.8130E+02_JPRB,6.6815E+02_JPRB,6.5194E+02_JPRB,6.3561E+02_JPRB,6.1955E+02_JPRB/)
KBO( :,20,15) = (/&
&7.8879E+02_JPRB,7.7015E+02_JPRB,7.4875E+02_JPRB,7.2676E+02_JPRB,7.0600E+02_JPRB/)
KBO( :,21,15) = (/&
&9.1167E+02_JPRB,8.8542E+02_JPRB,8.5728E+02_JPRB,8.2924E+02_JPRB,8.0222E+02_JPRB/)
KBO( :,22,15) = (/&
&1.0456E+03_JPRB,1.0104E+03_JPRB,9.7413E+02_JPRB,9.3830E+02_JPRB,9.0416E+02_JPRB/)
KBO( :,23,15) = (/&
&1.1890E+03_JPRB,1.1427E+03_JPRB,1.0964E+03_JPRB,1.0517E+03_JPRB,1.0073E+03_JPRB/)
KBO( :,24,15) = (/&
&1.3341E+03_JPRB,1.2769E+03_JPRB,1.2199E+03_JPRB,1.1637E+03_JPRB,1.1097E+03_JPRB/)
KBO( :,25,15) = (/&
&1.4777E+03_JPRB,1.4064E+03_JPRB,1.3371E+03_JPRB,1.2692E+03_JPRB,1.2051E+03_JPRB/)
KBO( :,26,15) = (/&
&1.6127E+03_JPRB,1.5257E+03_JPRB,1.4439E+03_JPRB,1.3652E+03_JPRB,1.2908E+03_JPRB/)
KBO( :,27,15) = (/&
&1.7363E+03_JPRB,1.6345E+03_JPRB,1.5403E+03_JPRB,1.4516E+03_JPRB,1.3681E+03_JPRB/)
KBO( :,28,15) = (/&
&1.8456E+03_JPRB,1.7310E+03_JPRB,1.6252E+03_JPRB,1.5262E+03_JPRB,1.4343E+03_JPRB/)
KBO( :,29,15) = (/&
&1.9374E+03_JPRB,1.8114E+03_JPRB,1.6953E+03_JPRB,1.5870E+03_JPRB,1.4880E+03_JPRB/)
KBO( :,30,15) = (/&
&2.0123E+03_JPRB,1.8759E+03_JPRB,1.7509E+03_JPRB,1.6347E+03_JPRB,1.5297E+03_JPRB/)
KBO( :,31,15) = (/&
&2.0695E+03_JPRB,1.9241E+03_JPRB,1.7919E+03_JPRB,1.6696E+03_JPRB,1.5595E+03_JPRB/)
KBO( :,32,15) = (/&
&2.1098E+03_JPRB,1.9573E+03_JPRB,1.8199E+03_JPRB,1.6927E+03_JPRB,1.5791E+03_JPRB/)
KBO( :,33,15) = (/&
&2.1350E+03_JPRB,1.9776E+03_JPRB,1.8360E+03_JPRB,1.7058E+03_JPRB,1.5896E+03_JPRB/)
KBO( :,34,15) = (/&
&2.1531E+03_JPRB,1.9921E+03_JPRB,1.8473E+03_JPRB,1.7146E+03_JPRB,1.5966E+03_JPRB/)
KBO( :,35,15) = (/&
&2.1773E+03_JPRB,2.0121E+03_JPRB,1.8641E+03_JPRB,1.7288E+03_JPRB,1.6085E+03_JPRB/)
KBO( :,36,15) = (/&
&2.2124E+03_JPRB,2.0424E+03_JPRB,1.8903E+03_JPRB,1.7515E+03_JPRB,1.6285E+03_JPRB/)
KBO( :,37,15) = (/&
&2.2692E+03_JPRB,2.0922E+03_JPRB,1.9342E+03_JPRB,1.7916E+03_JPRB,1.6630E+03_JPRB/)
KBO( :,38,15) = (/&
&2.3243E+03_JPRB,2.1400E+03_JPRB,1.9765E+03_JPRB,1.8290E+03_JPRB,1.6948E+03_JPRB/)
KBO( :,39,15) = (/&
&2.3761E+03_JPRB,2.1849E+03_JPRB,2.0163E+03_JPRB,1.8643E+03_JPRB,1.7262E+03_JPRB/)
KBO( :,40,15) = (/&
&2.4467E+03_JPRB,2.2470E+03_JPRB,2.0711E+03_JPRB,1.9128E+03_JPRB,1.7697E+03_JPRB/)
KBO( :,41,15) = (/&
&2.5197E+03_JPRB,2.3108E+03_JPRB,2.1276E+03_JPRB,1.9630E+03_JPRB,1.8147E+03_JPRB/)
KBO( :,42,15) = (/&
&2.5927E+03_JPRB,2.3746E+03_JPRB,2.1839E+03_JPRB,2.0131E+03_JPRB,1.8595E+03_JPRB/)
KBO( :,43,15) = (/&
&2.6795E+03_JPRB,2.4509E+03_JPRB,2.2509E+03_JPRB,2.0729E+03_JPRB,1.9127E+03_JPRB/)
KBO( :,44,15) = (/&
&2.7746E+03_JPRB,2.5346E+03_JPRB,2.3244E+03_JPRB,2.1382E+03_JPRB,1.9711E+03_JPRB/)
KBO( :,45,15) = (/&
&2.8725E+03_JPRB,2.6210E+03_JPRB,2.4001E+03_JPRB,2.2052E+03_JPRB,2.0310E+03_JPRB/)
KBO( :,46,15) = (/&
&2.9808E+03_JPRB,2.7160E+03_JPRB,2.4820E+03_JPRB,2.2786E+03_JPRB,2.0965E+03_JPRB/)
KBO( :,47,15) = (/&
&3.1065E+03_JPRB,2.8260E+03_JPRB,2.5776E+03_JPRB,2.3630E+03_JPRB,2.1714E+03_JPRB/)
KBO( :,48,15) = (/&
&3.2382E+03_JPRB,2.9414E+03_JPRB,2.6779E+03_JPRB,2.4515E+03_JPRB,2.2491E+03_JPRB/)
KBO( :,49,15) = (/&
&3.3769E+03_JPRB,3.0628E+03_JPRB,2.7828E+03_JPRB,2.5435E+03_JPRB,2.3301E+03_JPRB/)
KBO( :,50,15) = (/&
&3.5153E+03_JPRB,3.1825E+03_JPRB,2.8860E+03_JPRB,2.6340E+03_JPRB,2.4097E+03_JPRB/)
KBO( :,51,15) = (/&
&3.6567E+03_JPRB,3.3043E+03_JPRB,2.9915E+03_JPRB,2.7258E+03_JPRB,2.4905E+03_JPRB/)
KBO( :,52,15) = (/&
&3.8059E+03_JPRB,3.4316E+03_JPRB,3.1018E+03_JPRB,2.8218E+03_JPRB,2.5746E+03_JPRB/)
KBO( :,53,15) = (/&
&3.9647E+03_JPRB,3.5659E+03_JPRB,3.2181E+03_JPRB,2.9226E+03_JPRB,2.6623E+03_JPRB/)
KBO( :,54,15) = (/&
&4.1182E+03_JPRB,3.6932E+03_JPRB,3.3305E+03_JPRB,3.0197E+03_JPRB,2.7461E+03_JPRB/)
KBO( :,55,15) = (/&
&4.2719E+03_JPRB,3.8244E+03_JPRB,3.4429E+03_JPRB,3.1156E+03_JPRB,2.8302E+03_JPRB/)
KBO( :,56,15) = (/&
&4.4321E+03_JPRB,3.9623E+03_JPRB,3.5606E+03_JPRB,3.2171E+03_JPRB,2.9172E+03_JPRB/)
KBO( :,57,15) = (/&
&4.6005E+03_JPRB,4.1071E+03_JPRB,3.6841E+03_JPRB,3.3227E+03_JPRB,3.0093E+03_JPRB/)
KBO( :,58,15) = (/&
&4.7711E+03_JPRB,4.2512E+03_JPRB,3.8068E+03_JPRB,3.4270E+03_JPRB,3.1000E+03_JPRB/)
KBO( :,59,15) = (/&
&4.8435E+03_JPRB,4.3113E+03_JPRB,3.8580E+03_JPRB,3.4704E+03_JPRB,3.1379E+03_JPRB/)
KBO( :,13,16) = (/&
&3.6480E+02_JPRB,3.5145E+02_JPRB,3.4350E+02_JPRB,3.3674E+02_JPRB,3.3295E+02_JPRB/)
KBO( :,14,16) = (/&
&4.3305E+02_JPRB,4.2002E+02_JPRB,4.0834E+02_JPRB,4.0114E+02_JPRB,3.9514E+02_JPRB/)
KBO( :,15,16) = (/&
&5.1021E+02_JPRB,4.9566E+02_JPRB,4.8445E+02_JPRB,4.7500E+02_JPRB,4.6664E+02_JPRB/)
KBO( :,16,16) = (/&
&6.0095E+02_JPRB,5.8332E+02_JPRB,5.7034E+02_JPRB,5.5793E+02_JPRB,5.4743E+02_JPRB/)
KBO( :,17,16) = (/&
&6.9984E+02_JPRB,6.8135E+02_JPRB,6.6501E+02_JPRB,6.5003E+02_JPRB,6.3773E+02_JPRB/)
KBO( :,18,16) = (/&
&8.1052E+02_JPRB,7.8978E+02_JPRB,7.6911E+02_JPRB,7.5277E+02_JPRB,7.3709E+02_JPRB/)
KBO( :,19,16) = (/&
&9.3185E+02_JPRB,9.0651E+02_JPRB,8.8287E+02_JPRB,8.6357E+02_JPRB,8.4262E+02_JPRB/)
KBO( :,20,16) = (/&
&1.0617E+03_JPRB,1.0323E+03_JPRB,1.0033E+03_JPRB,9.7715E+02_JPRB,9.5295E+02_JPRB/)
KBO( :,21,16) = (/&
&1.1955E+03_JPRB,1.1605E+03_JPRB,1.1266E+03_JPRB,1.0931E+03_JPRB,1.0626E+03_JPRB/)
KBO( :,22,16) = (/&
&1.3313E+03_JPRB,1.2888E+03_JPRB,1.2452E+03_JPRB,1.2039E+03_JPRB,1.1668E+03_JPRB/)
KBO( :,23,16) = (/&
&1.4677E+03_JPRB,1.4171E+03_JPRB,1.3647E+03_JPRB,1.3122E+03_JPRB,1.2693E+03_JPRB/)
KBO( :,24,16) = (/&
&1.6031E+03_JPRB,1.5431E+03_JPRB,1.4805E+03_JPRB,1.4214E+03_JPRB,1.3711E+03_JPRB/)
KBO( :,25,16) = (/&
&1.7446E+03_JPRB,1.6761E+03_JPRB,1.6075E+03_JPRB,1.5354E+03_JPRB,1.4755E+03_JPRB/)
KBO( :,26,16) = (/&
&1.8991E+03_JPRB,1.8163E+03_JPRB,1.7331E+03_JPRB,1.6466E+03_JPRB,1.5750E+03_JPRB/)
KBO( :,27,16) = (/&
&2.0473E+03_JPRB,1.9486E+03_JPRB,1.8508E+03_JPRB,1.7507E+03_JPRB,1.6645E+03_JPRB/)
KBO( :,28,16) = (/&
&2.1841E+03_JPRB,2.0672E+03_JPRB,1.9532E+03_JPRB,1.8416E+03_JPRB,1.7427E+03_JPRB/)
KBO( :,29,16) = (/&
&2.3013E+03_JPRB,2.1668E+03_JPRB,2.0380E+03_JPRB,1.9159E+03_JPRB,1.8061E+03_JPRB/)
KBO( :,30,16) = (/&
&2.3968E+03_JPRB,2.2468E+03_JPRB,2.1057E+03_JPRB,1.9742E+03_JPRB,1.8547E+03_JPRB/)
KBO( :,31,16) = (/&
&2.4698E+03_JPRB,2.3066E+03_JPRB,2.1555E+03_JPRB,2.0162E+03_JPRB,1.8899E+03_JPRB/)
KBO( :,32,16) = (/&
&2.5212E+03_JPRB,2.3480E+03_JPRB,2.1899E+03_JPRB,2.0439E+03_JPRB,1.9131E+03_JPRB/)
KBO( :,33,16) = (/&
&2.5535E+03_JPRB,2.3733E+03_JPRB,2.2102E+03_JPRB,2.0593E+03_JPRB,1.9261E+03_JPRB/)
KBO( :,34,16) = (/&
&2.5772E+03_JPRB,2.3915E+03_JPRB,2.2247E+03_JPRB,2.0705E+03_JPRB,1.9349E+03_JPRB/)
KBO( :,35,16) = (/&
&2.6073E+03_JPRB,2.4161E+03_JPRB,2.2452E+03_JPRB,2.0872E+03_JPRB,1.9493E+03_JPRB/)
KBO( :,36,16) = (/&
&2.6509E+03_JPRB,2.4529E+03_JPRB,2.2766E+03_JPRB,2.1138E+03_JPRB,1.9720E+03_JPRB/)
KBO( :,37,16) = (/&
&2.7188E+03_JPRB,2.5136E+03_JPRB,2.3285E+03_JPRB,2.1597E+03_JPRB,2.0114E+03_JPRB/)
KBO( :,38,16) = (/&
&2.7845E+03_JPRB,2.5721E+03_JPRB,2.3785E+03_JPRB,2.2030E+03_JPRB,2.0515E+03_JPRB/)
KBO( :,39,16) = (/&
&2.8472E+03_JPRB,2.6270E+03_JPRB,2.4254E+03_JPRB,2.2449E+03_JPRB,2.0875E+03_JPRB/)
KBO( :,40,16) = (/&
&2.9330E+03_JPRB,2.6993E+03_JPRB,2.4900E+03_JPRB,2.3030E+03_JPRB,2.1374E+03_JPRB/)
KBO( :,41,16) = (/&
&3.0218E+03_JPRB,2.7769E+03_JPRB,2.5568E+03_JPRB,2.3631E+03_JPRB,2.1888E+03_JPRB/)
KBO( :,42,16) = (/&
&3.1113E+03_JPRB,2.8546E+03_JPRB,2.6243E+03_JPRB,2.4236E+03_JPRB,2.2399E+03_JPRB/)
KBO( :,43,16) = (/&
&3.2191E+03_JPRB,2.9464E+03_JPRB,2.7051E+03_JPRB,2.4953E+03_JPRB,2.3016E+03_JPRB/)
KBO( :,44,16) = (/&
&3.3385E+03_JPRB,3.0469E+03_JPRB,2.7942E+03_JPRB,2.5737E+03_JPRB,2.3700E+03_JPRB/)
KBO( :,45,16) = (/&
&3.4626E+03_JPRB,3.1506E+03_JPRB,2.8863E+03_JPRB,2.6539E+03_JPRB,2.4394E+03_JPRB/)
KBO( :,46,16) = (/&
&3.6001E+03_JPRB,3.2642E+03_JPRB,2.9874E+03_JPRB,2.7413E+03_JPRB,2.5151E+03_JPRB/)
KBO( :,47,16) = (/&
&3.7610E+03_JPRB,3.3965E+03_JPRB,3.1046E+03_JPRB,2.8425E+03_JPRB,2.6031E+03_JPRB/)
KBO( :,48,16) = (/&
&3.9321E+03_JPRB,3.5361E+03_JPRB,3.2276E+03_JPRB,2.9476E+03_JPRB,2.6982E+03_JPRB/)
KBO( :,49,16) = (/&
&4.1176E+03_JPRB,3.6899E+03_JPRB,3.3583E+03_JPRB,3.0595E+03_JPRB,2.7974E+03_JPRB/)
KBO( :,50,16) = (/&
&4.3032E+03_JPRB,3.8456E+03_JPRB,3.4873E+03_JPRB,3.1701E+03_JPRB,2.8952E+03_JPRB/)
KBO( :,51,16) = (/&
&4.4935E+03_JPRB,4.0060E+03_JPRB,3.6203E+03_JPRB,3.2826E+03_JPRB,2.9949E+03_JPRB/)
KBO( :,52,16) = (/&
&4.6944E+03_JPRB,4.1760E+03_JPRB,3.7596E+03_JPRB,3.4020E+03_JPRB,3.0994E+03_JPRB/)
KBO( :,53,16) = (/&
&4.9137E+03_JPRB,4.3562E+03_JPRB,3.9079E+03_JPRB,3.5294E+03_JPRB,3.2093E+03_JPRB/)
KBO( :,54,16) = (/&
&5.1332E+03_JPRB,4.5465E+03_JPRB,4.0538E+03_JPRB,3.6533E+03_JPRB,3.3147E+03_JPRB/)
KBO( :,55,16) = (/&
&5.3615E+03_JPRB,4.7268E+03_JPRB,4.2040E+03_JPRB,3.7715E+03_JPRB,3.4204E+03_JPRB/)
KBO( :,56,16) = (/&
&5.6101E+03_JPRB,4.9206E+03_JPRB,4.3611E+03_JPRB,3.9031E+03_JPRB,3.5302E+03_JPRB/)
KBO( :,57,16) = (/&
&5.8786E+03_JPRB,5.1280E+03_JPRB,4.5273E+03_JPRB,4.0416E+03_JPRB,3.6469E+03_JPRB/)
KBO( :,58,16) = (/&
&6.1495E+03_JPRB,5.3426E+03_JPRB,4.6971E+03_JPRB,4.1821E+03_JPRB,3.7629E+03_JPRB/)
KBO( :,59,16) = (/&
&6.2646E+03_JPRB,5.4342E+03_JPRB,4.7694E+03_JPRB,4.2411E+03_JPRB,3.8114E+03_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB7_BB
