!OCL SCALAR
SUBROUTINE RRTM_KGB7_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 7:  980-1080 cm-1 (low - H2O,O3; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO7 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,ABSCO2O
USE YOERRTA7 , ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&7.6730E-04_JPRB,6.9533E-04_JPRB,6.3435E-04_JPRB,5.7755E-04_JPRB,5.2747E-04_JPRB,4.8127E-04_JPRB,&
&4.6360E-04_JPRB,4.7153E-04_JPRB,5.0503E-04_JPRB/)
KAO( :, 2, 1, 9) = (/&
&8.9446E-04_JPRB,8.3145E-04_JPRB,7.7791E-04_JPRB,7.3079E-04_JPRB,6.8158E-04_JPRB,6.4054E-04_JPRB,&
&6.4060E-04_JPRB,6.7751E-04_JPRB,7.4127E-04_JPRB/)
KAO( :, 3, 1, 9) = (/&
&1.0839E-03_JPRB,1.0326E-03_JPRB,9.8910E-04_JPRB,9.4874E-04_JPRB,8.8995E-04_JPRB,8.5059E-04_JPRB,&
&8.6660E-04_JPRB,9.3858E-04_JPRB,1.0404E-03_JPRB/)
KAO( :, 4, 1, 9) = (/&
&1.3392E-03_JPRB,1.2976E-03_JPRB,1.2617E-03_JPRB,1.2187E-03_JPRB,1.1503E-03_JPRB,1.1142E-03_JPRB,&
&1.1537E-03_JPRB,1.2600E-03_JPRB,1.4074E-03_JPRB/)
KAO( :, 5, 1, 9) = (/&
&1.6572E-03_JPRB,1.6190E-03_JPRB,1.5928E-03_JPRB,1.5446E-03_JPRB,1.4696E-03_JPRB,1.4385E-03_JPRB,&
&1.5029E-03_JPRB,1.6559E-03_JPRB,1.8563E-03_JPRB/)
KAO( :, 1, 2, 9) = (/&
&7.2791E-04_JPRB,6.5760E-04_JPRB,5.9478E-04_JPRB,5.3539E-04_JPRB,4.8045E-04_JPRB,4.2766E-04_JPRB,&
&4.0009E-04_JPRB,3.9735E-04_JPRB,4.3728E-04_JPRB/)
KAO( :, 2, 2, 9) = (/&
&8.1810E-04_JPRB,7.5677E-04_JPRB,7.0172E-04_JPRB,6.5562E-04_JPRB,6.0484E-04_JPRB,5.6238E-04_JPRB,&
&5.5650E-04_JPRB,5.8260E-04_JPRB,6.4861E-04_JPRB/)
KAO( :, 3, 2, 9) = (/&
&9.5216E-04_JPRB,9.0507E-04_JPRB,8.6910E-04_JPRB,8.3462E-04_JPRB,7.8786E-04_JPRB,7.5096E-04_JPRB,&
&7.5914E-04_JPRB,8.1646E-04_JPRB,9.1827E-04_JPRB/)
KAO( :, 4, 2, 9) = (/&
&1.1442E-03_JPRB,1.1148E-03_JPRB,1.1009E-03_JPRB,1.0715E-03_JPRB,1.0248E-03_JPRB,9.9267E-04_JPRB,&
&1.0179E-03_JPRB,1.1078E-03_JPRB,1.2541E-03_JPRB/)
KAO( :, 5, 2, 9) = (/&
&1.3996E-03_JPRB,1.3905E-03_JPRB,1.3914E-03_JPRB,1.3624E-03_JPRB,1.3173E-03_JPRB,1.2906E-03_JPRB,&
&1.3365E-03_JPRB,1.4703E-03_JPRB,1.6733E-03_JPRB/)
KAO( :, 1, 3, 9) = (/&
&6.9198E-04_JPRB,6.2093E-04_JPRB,5.5500E-04_JPRB,4.9112E-04_JPRB,4.2858E-04_JPRB,3.6796E-04_JPRB,&
&3.2243E-04_JPRB,2.7068E-04_JPRB,3.8445E-04_JPRB/)
KAO( :, 2, 3, 9) = (/&
&7.4808E-04_JPRB,6.8197E-04_JPRB,6.2244E-04_JPRB,5.6656E-04_JPRB,5.0936E-04_JPRB,4.6235E-04_JPRB,&
&4.4533E-04_JPRB,4.5718E-04_JPRB,5.8212E-04_JPRB/)
KAO( :, 3, 3, 9) = (/&
&8.2613E-04_JPRB,7.7358E-04_JPRB,7.3159E-04_JPRB,6.8941E-04_JPRB,6.4390E-04_JPRB,6.1118E-04_JPRB,&
&6.1390E-04_JPRB,6.5687E-04_JPRB,8.4097E-04_JPRB/)
KAO( :, 4, 3, 9) = (/&
&9.3955E-04_JPRB,9.0936E-04_JPRB,8.9358E-04_JPRB,8.6993E-04_JPRB,8.3759E-04_JPRB,8.1431E-04_JPRB,&
&8.3330E-04_JPRB,9.0689E-04_JPRB,1.1736E-03_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.1024E-03_JPRB,1.1029E-03_JPRB,1.1144E-03_JPRB,1.1087E-03_JPRB,1.0858E-03_JPRB,1.0701E-03_JPRB,&
&1.1102E-03_JPRB,1.2203E-03_JPRB,1.5855E-03_JPRB/)
KAO( :, 1, 4, 9) = (/&
&6.9141E-04_JPRB,6.1573E-04_JPRB,5.4365E-04_JPRB,4.7268E-04_JPRB,4.0185E-04_JPRB,3.3169E-04_JPRB,&
&2.6484E-04_JPRB,1.1941E-04_JPRB,4.2525E-04_JPRB/)
KAO( :, 2, 4, 9) = (/&
&7.1303E-04_JPRB,6.4311E-04_JPRB,5.7730E-04_JPRB,5.1428E-04_JPRB,4.4890E-04_JPRB,3.8935E-04_JPRB,&
&3.5277E-04_JPRB,3.2803E-04_JPRB,6.6098E-04_JPRB/)
KAO( :, 3, 4, 9) = (/&
&7.6419E-04_JPRB,7.0113E-04_JPRB,6.4756E-04_JPRB,5.8990E-04_JPRB,5.3391E-04_JPRB,4.9265E-04_JPRB,&
&4.8275E-04_JPRB,5.0730E-04_JPRB,9.8045E-04_JPRB/)
KAO( :, 4, 4, 9) = (/&
&8.2609E-04_JPRB,7.8182E-04_JPRB,7.4991E-04_JPRB,7.1089E-04_JPRB,6.7442E-04_JPRB,6.5009E-04_JPRB,&
&6.6146E-04_JPRB,7.1854E-04_JPRB,1.3938E-03_JPRB/)
KAO( :, 5, 4, 9) = (/&
&9.1327E-04_JPRB,9.0245E-04_JPRB,8.9877E-04_JPRB,8.8705E-04_JPRB,8.7034E-04_JPRB,8.6010E-04_JPRB,&
&8.9180E-04_JPRB,9.8101E-04_JPRB,1.9118E-03_JPRB/)
KAO( :, 1, 5, 9) = (/&
&7.1194E-04_JPRB,6.3073E-04_JPRB,5.5152E-04_JPRB,4.7348E-04_JPRB,3.9513E-04_JPRB,3.1519E-04_JPRB,&
&2.2983E-04_JPRB,2.7452E-05_JPRB,4.8453E-04_JPRB/)
KAO( :, 2, 5, 9) = (/&
&7.1296E-04_JPRB,6.3797E-04_JPRB,5.6646E-04_JPRB,4.9574E-04_JPRB,4.2273E-04_JPRB,3.5196E-04_JPRB,&
&2.8944E-04_JPRB,1.7242E-04_JPRB,7.7671E-04_JPRB/)
KAO( :, 3, 5, 9) = (/&
&7.3444E-04_JPRB,6.6574E-04_JPRB,6.0369E-04_JPRB,5.3780E-04_JPRB,4.7146E-04_JPRB,4.1473E-04_JPRB,&
&3.8369E-04_JPRB,3.7633E-04_JPRB,1.1824E-03_JPRB/)
KAO( :, 4, 5, 9) = (/&
&7.7697E-04_JPRB,7.1991E-04_JPRB,6.7045E-04_JPRB,6.1217E-04_JPRB,5.6053E-04_JPRB,5.2336E-04_JPRB,&
&5.2023E-04_JPRB,5.5862E-04_JPRB,1.7181E-03_JPRB/)
KAO( :, 5, 5, 9) = (/&
&8.2601E-04_JPRB,7.9119E-04_JPRB,7.6213E-04_JPRB,7.3107E-04_JPRB,6.9880E-04_JPRB,6.8266E-04_JPRB,&
&7.0503E-04_JPRB,7.7701E-04_JPRB,2.3991E-03_JPRB/)
KAO( :, 1, 6, 9) = (/&
&7.4702E-04_JPRB,6.5911E-04_JPRB,5.7262E-04_JPRB,4.8679E-04_JPRB,4.0134E-04_JPRB,3.1318E-04_JPRB,&
&1.5461E-04_JPRB,1.6758E-05_JPRB,5.2688E-04_JPRB/)
KAO( :, 2, 6, 9) = (/&
&7.4128E-04_JPRB,6.5855E-04_JPRB,5.7826E-04_JPRB,4.9892E-04_JPRB,4.1789E-04_JPRB,3.3501E-04_JPRB,&
&2.5184E-04_JPRB,5.3936E-05_JPRB,8.7850E-04_JPRB/)
KAO( :, 3, 6, 9) = (/&
&7.3954E-04_JPRB,6.6416E-04_JPRB,5.9359E-04_JPRB,5.2126E-04_JPRB,4.4507E-04_JPRB,3.7370E-04_JPRB,&
&3.1408E-04_JPRB,2.2236E-04_JPRB,1.3809E-03_JPRB/)
KAO( :, 4, 6, 9) = (/&
&7.5717E-04_JPRB,6.9002E-04_JPRB,6.2962E-04_JPRB,5.6099E-04_JPRB,4.9557E-04_JPRB,4.3902E-04_JPRB,&
&4.1006E-04_JPRB,4.1489E-04_JPRB,2.0655E-03_JPRB/)
KAO( :, 5, 6, 9) = (/&
&7.8954E-04_JPRB,7.3758E-04_JPRB,6.8841E-04_JPRB,6.3360E-04_JPRB,5.8155E-04_JPRB,5.4713E-04_JPRB,&
&5.4922E-04_JPRB,5.9986E-04_JPRB,2.9589E-03_JPRB/)
KAO( :, 1, 7, 9) = (/&
&7.9467E-04_JPRB,6.9929E-04_JPRB,6.0424E-04_JPRB,5.1073E-04_JPRB,4.1693E-04_JPRB,3.2089E-04_JPRB,&
&5.1325E-05_JPRB,1.2122E-05_JPRB,6.0259E-04_JPRB/)
KAO( :, 2, 7, 9) = (/&
&7.8343E-04_JPRB,6.9250E-04_JPRB,6.0357E-04_JPRB,5.1592E-04_JPRB,4.2687E-04_JPRB,3.3542E-04_JPRB,&
&2.2592E-04_JPRB,1.5976E-05_JPRB,1.0502E-03_JPRB/)
KAO( :, 3, 7, 9) = (/&
&7.7573E-04_JPRB,6.9130E-04_JPRB,6.0997E-04_JPRB,5.2908E-04_JPRB,4.4409E-04_JPRB,3.5904E-04_JPRB,&
&2.7616E-04_JPRB,9.2965E-05_JPRB,1.7102E-03_JPRB/)
KAO( :, 4, 7, 9) = (/&
&7.7294E-04_JPRB,6.9692E-04_JPRB,6.2657E-04_JPRB,5.4965E-04_JPRB,4.7312E-04_JPRB,3.9920E-04_JPRB,&
&3.3903E-04_JPRB,2.7602E-04_JPRB,2.6319E-03_JPRB/)
KAO( :, 5, 7, 9) = (/&
&7.8731E-04_JPRB,7.2173E-04_JPRB,6.5887E-04_JPRB,5.9065E-04_JPRB,5.2295E-04_JPRB,4.6490E-04_JPRB,&
&4.3618E-04_JPRB,4.5346E-04_JPRB,3.8668E-03_JPRB/)
KAO( :, 1, 8, 9) = (/&
&8.5501E-04_JPRB,7.5078E-04_JPRB,6.4657E-04_JPRB,5.4366E-04_JPRB,4.4039E-04_JPRB,3.3294E-04_JPRB,&
&2.6688E-05_JPRB,1.2258E-05_JPRB,8.1286E-04_JPRB/)
KAO( :, 2, 8, 9) = (/&
&8.4099E-04_JPRB,7.4093E-04_JPRB,6.4228E-04_JPRB,5.4430E-04_JPRB,4.4636E-04_JPRB,3.4551E-04_JPRB,&
&1.0468E-04_JPRB,1.2830E-05_JPRB,1.4923E-03_JPRB/)
KAO( :, 3, 8, 9) = (/&
&8.2855E-04_JPRB,7.3472E-04_JPRB,6.4208E-04_JPRB,5.5147E-04_JPRB,4.5797E-04_JPRB,3.6152E-04_JPRB,&
&2.5538E-04_JPRB,1.6241E-05_JPRB,2.5369E-03_JPRB/)
KAO( :, 4, 8, 9) = (/&
&8.1840E-04_JPRB,7.3203E-04_JPRB,6.4929E-04_JPRB,5.6425E-04_JPRB,4.7544E-04_JPRB,3.8760E-04_JPRB,&
&3.0236E-04_JPRB,1.3733E-04_JPRB,4.0371E-03_JPRB/)
KAO( :, 5, 8, 9) = (/&
&8.1270E-04_JPRB,7.3589E-04_JPRB,6.6348E-04_JPRB,5.8412E-04_JPRB,5.0562E-04_JPRB,4.2829E-04_JPRB,&
&3.6616E-04_JPRB,3.2564E-04_JPRB,6.0900E-03_JPRB/)
KAO( :, 1, 9, 9) = (/&
&9.2560E-04_JPRB,8.1125E-04_JPRB,6.9819E-04_JPRB,5.8413E-04_JPRB,4.7055E-04_JPRB,3.5015E-04_JPRB,&
&5.5500E-06_JPRB,4.9629E-06_JPRB,2.0290E-03_JPRB/)
KAO( :, 2, 9, 9) = (/&
&9.1093E-04_JPRB,8.0097E-04_JPRB,6.9137E-04_JPRB,5.8249E-04_JPRB,4.7378E-04_JPRB,3.6194E-04_JPRB,&
&3.0062E-05_JPRB,1.0842E-05_JPRB,3.9531E-03_JPRB/)
KAO( :, 3, 9, 9) = (/&
&8.9709E-04_JPRB,7.9180E-04_JPRB,6.8775E-04_JPRB,5.8518E-04_JPRB,4.8156E-04_JPRB,3.7367E-04_JPRB,&
&1.7999E-04_JPRB,1.5619E-05_JPRB,7.0405E-03_JPRB/)
KAO( :, 4, 9, 9) = (/&
&8.8317E-04_JPRB,7.8542E-04_JPRB,6.8899E-04_JPRB,5.9345E-04_JPRB,4.9320E-04_JPRB,3.9217E-04_JPRB,&
&2.8412E-04_JPRB,3.4988E-05_JPRB,1.1630E-02_JPRB/)
KAO( :, 5, 9, 9) = (/&
&8.7042E-04_JPRB,7.8172E-04_JPRB,6.9655E-04_JPRB,6.0534E-04_JPRB,5.1346E-04_JPRB,4.2035E-04_JPRB,&
&3.3049E-04_JPRB,1.7732E-04_JPRB,1.8084E-02_JPRB/)
KAO( :, 1,10, 9) = (/&
&1.0020E-03_JPRB,8.7768E-04_JPRB,7.5453E-04_JPRB,6.2994E-04_JPRB,5.0369E-04_JPRB,2.0029E-04_JPRB,&
&4.8338E-06_JPRB,1.1150E-06_JPRB,6.1828E-03_JPRB/)
KAO( :, 2,10, 9) = (/&
&9.8614E-04_JPRB,8.6564E-04_JPRB,7.4527E-04_JPRB,6.2596E-04_JPRB,5.0608E-04_JPRB,3.8053E-04_JPRB,&
&2.2407E-05_JPRB,6.0753E-06_JPRB,1.2701E-02_JPRB/)
KAO( :, 3,10, 9) = (/&
&9.7041E-04_JPRB,8.5442E-04_JPRB,7.4008E-04_JPRB,6.2563E-04_JPRB,5.1190E-04_JPRB,3.9299E-04_JPRB,&
&5.6685E-05_JPRB,1.0644E-05_JPRB,2.3596E-02_JPRB/)
KAO( :, 4,10, 9) = (/&
&9.5474E-04_JPRB,8.4629E-04_JPRB,7.3757E-04_JPRB,6.3110E-04_JPRB,5.2156E-04_JPRB,4.0815E-04_JPRB,&
&2.6069E-04_JPRB,1.4418E-05_JPRB,4.0339E-02_JPRB/)
KAO( :, 5,10, 9) = (/&
&9.3936E-04_JPRB,8.3916E-04_JPRB,7.4145E-04_JPRB,6.4037E-04_JPRB,5.3630E-04_JPRB,4.3024E-04_JPRB,&
&3.1815E-04_JPRB,7.5689E-05_JPRB,6.4528E-02_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.0733E-03_JPRB,9.4010E-04_JPRB,8.0821E-04_JPRB,6.7481E-04_JPRB,5.3993E-04_JPRB,1.7304E-04_JPRB,&
&4.5690E-06_JPRB,1.0947E-06_JPRB,9.5058E-03_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.0562E-03_JPRB,9.2720E-04_JPRB,7.9859E-04_JPRB,6.7071E-04_JPRB,5.4165E-04_JPRB,4.0387E-04_JPRB,&
&2.1514E-05_JPRB,7.8378E-06_JPRB,1.9538E-02_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.0391E-03_JPRB,9.1541E-04_JPRB,7.9272E-04_JPRB,6.7016E-04_JPRB,5.4829E-04_JPRB,4.2037E-04_JPRB,&
&4.6128E-05_JPRB,1.0839E-05_JPRB,3.6276E-02_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.0222E-03_JPRB,9.0627E-04_JPRB,7.9028E-04_JPRB,6.7590E-04_JPRB,5.5839E-04_JPRB,4.3725E-04_JPRB,&
&2.4358E-04_JPRB,1.5967E-05_JPRB,6.2057E-02_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.0062E-03_JPRB,8.9870E-04_JPRB,7.9417E-04_JPRB,6.8540E-04_JPRB,5.7395E-04_JPRB,4.5941E-04_JPRB,&
&3.3487E-04_JPRB,5.8510E-05_JPRB,9.9558E-02_JPRB/)
KAO( :, 1,12, 9) = (/&
&1.1429E-03_JPRB,1.0011E-03_JPRB,8.6066E-04_JPRB,7.1891E-04_JPRB,5.7572E-04_JPRB,2.3708E-04_JPRB,&
&4.4567E-06_JPRB,5.1497E-06_JPRB,1.0798E-02_JPRB/)
KAO( :, 2,12, 9) = (/&
&1.1252E-03_JPRB,9.8802E-04_JPRB,8.5145E-04_JPRB,7.1518E-04_JPRB,5.7793E-04_JPRB,4.3517E-04_JPRB,&
&2.8931E-05_JPRB,1.3305E-05_JPRB,2.2185E-02_JPRB/)
KAO( :, 3,12, 9) = (/&
&1.1078E-03_JPRB,9.7648E-04_JPRB,8.4588E-04_JPRB,7.1557E-04_JPRB,5.8568E-04_JPRB,4.5025E-04_JPRB,&
&8.7797E-05_JPRB,1.2058E-05_JPRB,4.1218E-02_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.0907E-03_JPRB,9.6728E-04_JPRB,8.4415E-04_JPRB,7.2188E-04_JPRB,5.9608E-04_JPRB,4.6749E-04_JPRB,&
&2.9839E-04_JPRB,1.3906E-05_JPRB,7.0748E-02_JPRB/)
KAO( :, 5,12, 9) = (/&
&1.0737E-03_JPRB,9.5961E-04_JPRB,8.4835E-04_JPRB,7.3154E-04_JPRB,6.1267E-04_JPRB,4.9042E-04_JPRB,&
&3.5775E-04_JPRB,5.9229E-05_JPRB,1.1398E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.2093E-03_JPRB,1.0592E-03_JPRB,9.1069E-04_JPRB,7.6104E-04_JPRB,6.0998E-04_JPRB,3.0141E-04_JPRB,&
&8.4692E-06_JPRB,3.6390E-06_JPRB,9.7505E-03_JPRB/)
KAO( :, 2,13, 9) = (/&
&1.1916E-03_JPRB,1.0465E-03_JPRB,9.0223E-04_JPRB,7.5810E-04_JPRB,6.1322E-04_JPRB,4.6338E-04_JPRB,&
&3.8957E-05_JPRB,7.1625E-06_JPRB,2.0045E-02_JPRB/)
KAO( :, 3,13, 9) = (/&
&1.1742E-03_JPRB,1.0355E-03_JPRB,8.9704E-04_JPRB,7.5964E-04_JPRB,6.2169E-04_JPRB,4.7851E-04_JPRB,&
&1.3589E-04_JPRB,1.1895E-05_JPRB,3.7380E-02_JPRB/)
KAO( :, 4,13, 9) = (/&
&1.1565E-03_JPRB,1.0260E-03_JPRB,8.9628E-04_JPRB,7.6660E-04_JPRB,6.3308E-04_JPRB,4.9715E-04_JPRB,&
&3.4150E-04_JPRB,1.1060E-05_JPRB,6.4458E-02_JPRB/)
KAO( :, 5,13, 9) = (/&
&1.1382E-03_JPRB,1.0180E-03_JPRB,9.0061E-04_JPRB,7.7706E-04_JPRB,6.5089E-04_JPRB,5.2149E-04_JPRB,&
&3.8129E-04_JPRB,5.9752E-05_JPRB,1.0436E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&9.4926E-04_JPRB,8.5786E-04_JPRB,8.1138E-04_JPRB,7.6433E-04_JPRB,7.2663E-04_JPRB,7.8967E-04_JPRB,&
&8.8787E-04_JPRB,9.8903E-04_JPRB,1.1026E-03_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.2390E-03_JPRB,1.1300E-03_JPRB,1.0621E-03_JPRB,9.8809E-04_JPRB,9.8084E-04_JPRB,1.1153E-03_JPRB,&
&1.2754E-03_JPRB,1.4463E-03_JPRB,1.6199E-03_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.6285E-03_JPRB,1.4941E-03_JPRB,1.4019E-03_JPRB,1.3143E-03_JPRB,1.3388E-03_JPRB,1.5587E-03_JPRB,&
&1.7963E-03_JPRB,2.0319E-03_JPRB,2.2893E-03_JPRB/)
KAO( :, 4, 1,10) = (/&
&2.1075E-03_JPRB,1.9429E-03_JPRB,1.8233E-03_JPRB,1.7260E-03_JPRB,1.7987E-03_JPRB,2.1195E-03_JPRB,&
&2.4630E-03_JPRB,2.8065E-03_JPRB,3.1716E-03_JPRB/)
KAO( :, 5, 1,10) = (/&
&2.6676E-03_JPRB,2.4810E-03_JPRB,2.3359E-03_JPRB,2.2329E-03_JPRB,2.3416E-03_JPRB,2.7812E-03_JPRB,&
&3.2550E-03_JPRB,3.7334E-03_JPRB,4.2210E-03_JPRB/)
KAO( :, 1, 2,10) = (/&
&8.9025E-04_JPRB,8.0274E-04_JPRB,7.4274E-04_JPRB,6.8609E-04_JPRB,6.7102E-04_JPRB,7.1742E-04_JPRB,&
&7.9680E-04_JPRB,8.7045E-04_JPRB,9.7644E-04_JPRB/)
KAO( :, 2, 2,10) = (/&
&1.1017E-03_JPRB,1.0100E-03_JPRB,9.5453E-04_JPRB,8.9274E-04_JPRB,8.8682E-04_JPRB,1.0003E-03_JPRB,&
&1.1309E-03_JPRB,1.2737E-03_JPRB,1.4319E-03_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.4395E-03_JPRB,1.3424E-03_JPRB,1.2619E-03_JPRB,1.1931E-03_JPRB,1.1956E-03_JPRB,1.3885E-03_JPRB,&
&1.5988E-03_JPRB,1.8061E-03_JPRB,2.0428E-03_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.8618E-03_JPRB,1.7544E-03_JPRB,1.6479E-03_JPRB,1.5853E-03_JPRB,1.5993E-03_JPRB,1.8833E-03_JPRB,&
&2.1846E-03_JPRB,2.4927E-03_JPRB,2.8370E-03_JPRB/)
KAO( :, 5, 2,10) = (/&
&2.3686E-03_JPRB,2.2486E-03_JPRB,2.1364E-03_JPRB,2.0670E-03_JPRB,2.0882E-03_JPRB,2.4685E-03_JPRB,&
&2.8904E-03_JPRB,3.3295E-03_JPRB,3.7864E-03_JPRB/)
KAO( :, 1, 3,10) = (/&
&8.4979E-04_JPRB,7.6433E-04_JPRB,6.9594E-04_JPRB,6.3370E-04_JPRB,5.8853E-04_JPRB,5.9559E-04_JPRB,&
&6.5667E-04_JPRB,7.1533E-04_JPRB,8.1217E-04_JPRB/)
KAO( :, 2, 3,10) = (/&
&9.3603E-04_JPRB,8.5921E-04_JPRB,7.9338E-04_JPRB,7.5508E-04_JPRB,7.6062E-04_JPRB,8.4114E-04_JPRB,&
&9.4920E-04_JPRB,1.0487E-03_JPRB,1.2014E-03_JPRB/)
KAO( :, 3, 3,10) = (/&
&1.1433E-03_JPRB,1.0846E-03_JPRB,1.0263E-03_JPRB,9.9233E-04_JPRB,1.0119E-03_JPRB,1.1695E-03_JPRB,&
&1.3351E-03_JPRB,1.4995E-03_JPRB,1.7286E-03_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.4720E-03_JPRB,1.4093E-03_JPRB,1.3576E-03_JPRB,1.3122E-03_JPRB,1.3394E-03_JPRB,1.5776E-03_JPRB,&
&1.8258E-03_JPRB,2.0744E-03_JPRB,2.3896E-03_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.8783E-03_JPRB,1.8107E-03_JPRB,1.7793E-03_JPRB,1.7293E-03_JPRB,1.7612E-03_JPRB,2.0848E-03_JPRB,&
&2.4329E-03_JPRB,2.7873E-03_JPRB,3.2122E-03_JPRB/)
KAO( :, 1, 4,10) = (/&
&8.5598E-04_JPRB,7.6200E-04_JPRB,6.7698E-04_JPRB,6.0274E-04_JPRB,5.4143E-04_JPRB,4.8510E-04_JPRB,&
&5.0808E-04_JPRB,5.4195E-04_JPRB,7.2030E-04_JPRB/)
KAO( :, 2, 4,10) = (/&
&8.7829E-04_JPRB,7.9754E-04_JPRB,7.2820E-04_JPRB,6.8132E-04_JPRB,6.4105E-04_JPRB,6.7652E-04_JPRB,&
&7.5328E-04_JPRB,8.3000E-04_JPRB,1.1216E-03_JPRB/)
KAO( :, 3, 4,10) = (/&
&9.6941E-04_JPRB,9.0019E-04_JPRB,8.3950E-04_JPRB,8.2706E-04_JPRB,8.3972E-04_JPRB,9.4956E-04_JPRB,&
&1.0831E-03_JPRB,1.2181E-03_JPRB,1.6652E-03_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.1497E-03_JPRB,1.1076E-03_JPRB,1.0973E-03_JPRB,1.0748E-03_JPRB,1.1139E-03_JPRB,1.3070E-03_JPRB,&
&1.5051E-03_JPRB,1.7091E-03_JPRB,2.3798E-03_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.4423E-03_JPRB,1.4228E-03_JPRB,1.4377E-03_JPRB,1.4117E-03_JPRB,1.4741E-03_JPRB,1.7577E-03_JPRB,&
&2.0499E-03_JPRB,2.3324E-03_JPRB,3.2737E-03_JPRB/)
KAO( :, 1, 5,10) = (/&
&8.8900E-04_JPRB,7.8652E-04_JPRB,6.9034E-04_JPRB,5.9667E-04_JPRB,5.1545E-04_JPRB,4.4672E-04_JPRB,&
&3.9522E-04_JPRB,3.0801E-04_JPRB,9.0832E-04_JPRB/)
KAO( :, 2, 5,10) = (/&
&8.9256E-04_JPRB,7.9933E-04_JPRB,7.1388E-04_JPRB,6.4679E-04_JPRB,5.8953E-04_JPRB,5.4566E-04_JPRB,&
&5.8778E-04_JPRB,6.2517E-04_JPRB,1.4726E-03_JPRB/)
KAO( :, 3, 5,10) = (/&
&9.1630E-04_JPRB,8.3731E-04_JPRB,7.6863E-04_JPRB,7.3348E-04_JPRB,7.0053E-04_JPRB,7.6737E-04_JPRB,&
&8.6212E-04_JPRB,9.5439E-04_JPRB,2.2518E-03_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.0039E-03_JPRB,9.3325E-04_JPRB,8.9498E-04_JPRB,8.8178E-04_JPRB,9.2025E-04_JPRB,1.0734E-03_JPRB,&
&1.2371E-03_JPRB,1.3976E-03_JPRB,3.3076E-03_JPRB/)
KAO( :, 5, 5,10) = (/&
&1.1384E-03_JPRB,1.1125E-03_JPRB,1.1459E-03_JPRB,1.1447E-03_JPRB,1.2384E-03_JPRB,1.4768E-03_JPRB,&
&1.7232E-03_JPRB,1.9621E-03_JPRB,4.6582E-03_JPRB/)
KAO( :, 1, 6,10) = (/&
&9.4887E-04_JPRB,8.3839E-04_JPRB,7.3102E-04_JPRB,6.2493E-04_JPRB,5.2042E-04_JPRB,4.2275E-04_JPRB,&
&3.3556E-04_JPRB,3.4740E-06_JPRB,1.1251E-03_JPRB/)
KAO( :, 2, 6,10) = (/&
&9.3677E-04_JPRB,8.3218E-04_JPRB,7.3454E-04_JPRB,6.4594E-04_JPRB,5.6378E-04_JPRB,4.9151E-04_JPRB,&
&4.4994E-04_JPRB,4.2597E-04_JPRB,1.8832E-03_JPRB/)
KAO( :, 3, 6,10) = (/&
&9.3921E-04_JPRB,8.4673E-04_JPRB,7.5957E-04_JPRB,6.9636E-04_JPRB,6.3706E-04_JPRB,6.1057E-04_JPRB,&
&6.7476E-04_JPRB,7.3912E-04_JPRB,2.9583E-03_JPRB/)
KAO( :, 4, 6,10) = (/&
&9.5719E-04_JPRB,8.7688E-04_JPRB,8.1813E-04_JPRB,7.7967E-04_JPRB,7.5775E-04_JPRB,8.5851E-04_JPRB,&
&9.8609E-04_JPRB,1.1121E-03_JPRB,4.4273E-03_JPRB/)
KAO( :, 5, 6,10) = (/&
&1.0294E-03_JPRB,9.6457E-04_JPRB,9.3753E-04_JPRB,9.2588E-04_JPRB,1.0133E-03_JPRB,1.2038E-03_JPRB,&
&1.4020E-03_JPRB,1.6034E-03_JPRB,6.3437E-03_JPRB/)
KAO( :, 1, 7,10) = (/&
&1.0279E-03_JPRB,9.0433E-04_JPRB,7.8375E-04_JPRB,6.6508E-04_JPRB,5.4484E-04_JPRB,4.2431E-04_JPRB,&
&2.6888E-04_JPRB,7.8015E-06_JPRB,1.4588E-03_JPRB/)
KAO( :, 2, 7,10) = (/&
&1.0083E-03_JPRB,8.9241E-04_JPRB,7.8172E-04_JPRB,6.7204E-04_JPRB,5.7124E-04_JPRB,4.6914E-04_JPRB,&
&3.6802E-04_JPRB,8.6137E-05_JPRB,2.5625E-03_JPRB/)
KAO( :, 3, 7,10) = (/&
&9.9596E-04_JPRB,8.9237E-04_JPRB,7.9108E-04_JPRB,7.0321E-04_JPRB,6.1556E-04_JPRB,5.3871E-04_JPRB,&
&5.1518E-04_JPRB,5.4052E-04_JPRB,4.1805E-03_JPRB/)
KAO( :, 4, 7,10) = (/&
&9.8826E-04_JPRB,8.9639E-04_JPRB,8.1334E-04_JPRB,7.5573E-04_JPRB,6.8824E-04_JPRB,6.8183E-04_JPRB,&
&7.7451E-04_JPRB,8.6801E-04_JPRB,6.4027E-03_JPRB/)
KAO( :, 5, 7,10) = (/&
&1.0011E-03_JPRB,9.2233E-04_JPRB,8.6964E-04_JPRB,8.2719E-04_JPRB,8.3320E-04_JPRB,9.6571E-04_JPRB,&
&1.1203E-03_JPRB,1.2853E-03_JPRB,9.3461E-03_JPRB/)
KAO( :, 1, 8,10) = (/&
&1.1125E-03_JPRB,9.7475E-04_JPRB,8.4628E-04_JPRB,7.1245E-04_JPRB,5.8223E-04_JPRB,4.4955E-04_JPRB,&
&1.2055E-05_JPRB,1.4979E-05_JPRB,2.2126E-03_JPRB/)
KAO( :, 2, 8,10) = (/&
&1.0938E-03_JPRB,9.6654E-04_JPRB,8.3997E-04_JPRB,7.1323E-04_JPRB,5.9255E-04_JPRB,4.7230E-04_JPRB,&
&3.2313E-04_JPRB,3.4269E-06_JPRB,4.0836E-03_JPRB/)
KAO( :, 3, 8,10) = (/&
&1.0758E-03_JPRB,9.5487E-04_JPRB,8.3741E-04_JPRB,7.2643E-04_JPRB,6.2166E-04_JPRB,5.1323E-04_JPRB,&
&4.2493E-04_JPRB,3.0113E-04_JPRB,6.9437E-03_JPRB/)
KAO( :, 4, 8,10) = (/&
&1.0550E-03_JPRB,9.4862E-04_JPRB,8.4799E-04_JPRB,7.6117E-04_JPRB,6.7028E-04_JPRB,5.9614E-04_JPRB,&
&6.0166E-04_JPRB,6.5642E-04_JPRB,1.1024E-02_JPRB/)
KAO( :, 5, 8,10) = (/&
&1.0393E-03_JPRB,9.5089E-04_JPRB,8.7866E-04_JPRB,8.1224E-04_JPRB,7.5400E-04_JPRB,7.6815E-04_JPRB,&
&8.8282E-04_JPRB,1.0221E-03_JPRB,1.6724E-02_JPRB/)
KAO( :, 1, 9,10) = (/&
&1.2180E-03_JPRB,1.0664E-03_JPRB,9.2270E-04_JPRB,7.7328E-04_JPRB,6.2475E-04_JPRB,4.6815E-04_JPRB,&
&9.5178E-06_JPRB,3.3772E-06_JPRB,6.2846E-03_JPRB/)
KAO( :, 2, 9,10) = (/&
&1.1921E-03_JPRB,1.0498E-03_JPRB,9.0635E-04_JPRB,7.6682E-04_JPRB,6.2317E-04_JPRB,4.8406E-04_JPRB,&
&8.3341E-05_JPRB,3.8343E-06_JPRB,1.2227E-02_JPRB/)
KAO( :, 3, 9,10) = (/&
&1.1669E-03_JPRB,1.0310E-03_JPRB,8.9852E-04_JPRB,7.6558E-04_JPRB,6.4277E-04_JPRB,5.2121E-04_JPRB,&
&3.7666E-04_JPRB,1.2040E-05_JPRB,2.1734E-02_JPRB/)
KAO( :, 4, 9,10) = (/&
&1.1470E-03_JPRB,1.0235E-03_JPRB,9.0044E-04_JPRB,7.8767E-04_JPRB,6.8183E-04_JPRB,5.6489E-04_JPRB,&
&4.9156E-04_JPRB,4.5088E-04_JPRB,3.6006E-02_JPRB/)
KAO( :, 5, 9,10) = (/&
&1.1295E-03_JPRB,1.0174E-03_JPRB,9.1849E-04_JPRB,8.2709E-04_JPRB,7.3027E-04_JPRB,6.6994E-04_JPRB,&
&6.9088E-04_JPRB,7.9186E-04_JPRB,5.6162E-02_JPRB/)
KAO( :, 1,10,10) = (/&
&1.3419E-03_JPRB,1.1745E-03_JPRB,1.0112E-03_JPRB,8.4729E-04_JPRB,6.7925E-04_JPRB,4.9697E-04_JPRB,&
&1.5254E-06_JPRB,1.5343E-06_JPRB,2.0999E-02_JPRB/)
KAO( :, 2,10,10) = (/&
&1.3141E-03_JPRB,1.1539E-03_JPRB,9.9630E-04_JPRB,8.3744E-04_JPRB,6.7916E-04_JPRB,5.1101E-04_JPRB,&
&6.8452E-06_JPRB,3.0451E-06_JPRB,4.3024E-02_JPRB/)
KAO( :, 3,10,10) = (/&
&1.2898E-03_JPRB,1.1375E-03_JPRB,9.8703E-04_JPRB,8.3404E-04_JPRB,6.8649E-04_JPRB,5.3929E-04_JPRB,&
&3.2626E-04_JPRB,6.0173E-06_JPRB,7.9885E-02_JPRB/)
KAO( :, 4,10,10) = (/&
&1.2672E-03_JPRB,1.1264E-03_JPRB,9.8249E-04_JPRB,8.4764E-04_JPRB,7.1223E-04_JPRB,5.7730E-04_JPRB,&
&4.4171E-04_JPRB,9.9896E-05_JPRB,1.3680E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&1.2477E-03_JPRB,1.1172E-03_JPRB,9.9135E-04_JPRB,8.7077E-04_JPRB,7.4770E-04_JPRB,6.3934E-04_JPRB,&
&5.7696E-04_JPRB,6.1656E-04_JPRB,2.1952E-01_JPRB/)
KAO( :, 1,11,10) = (/&
&1.4755E-03_JPRB,1.2917E-03_JPRB,1.1119E-03_JPRB,9.3058E-04_JPRB,7.4744E-04_JPRB,5.5051E-04_JPRB,&
&1.6522E-06_JPRB,1.5412E-06_JPRB,3.4475E-02_JPRB/)
KAO( :, 2,11,10) = (/&
&1.4485E-03_JPRB,1.2719E-03_JPRB,1.0971E-03_JPRB,9.2191E-04_JPRB,7.4745E-04_JPRB,5.7109E-04_JPRB,&
&1.1696E-05_JPRB,3.1243E-06_JPRB,7.0850E-02_JPRB/)
KAO( :, 3,11,10) = (/&
&1.4264E-03_JPRB,1.2579E-03_JPRB,1.0914E-03_JPRB,9.2154E-04_JPRB,7.5855E-04_JPRB,5.9482E-04_JPRB,&
&3.1605E-04_JPRB,9.6309E-06_JPRB,1.3183E-01_JPRB/)
KAO( :, 4,11,10) = (/&
&1.4023E-03_JPRB,1.2457E-03_JPRB,1.0849E-03_JPRB,9.3462E-04_JPRB,7.7881E-04_JPRB,6.1925E-04_JPRB,&
&4.6174E-04_JPRB,2.1053E-05_JPRB,2.2597E-01_JPRB/)
KAO( :, 5,11,10) = (/&
&1.3792E-03_JPRB,1.2345E-03_JPRB,1.0916E-03_JPRB,9.5041E-04_JPRB,8.0615E-04_JPRB,6.7157E-04_JPRB,&
&5.8929E-04_JPRB,6.0215E-04_JPRB,3.6233E-01_JPRB/)
KAO( :, 1,12,10) = (/&
&1.6315E-03_JPRB,1.4286E-03_JPRB,1.2296E-03_JPRB,1.0282E-03_JPRB,8.2450E-04_JPRB,6.1652E-04_JPRB,&
&3.3057E-06_JPRB,1.5465E-06_JPRB,4.1474E-02_JPRB/)
KAO( :, 2,12,10) = (/&
&1.6041E-03_JPRB,1.4085E-03_JPRB,1.2135E-03_JPRB,1.0193E-03_JPRB,8.2407E-04_JPRB,6.2890E-04_JPRB,&
&2.0154E-05_JPRB,3.2488E-06_JPRB,8.5418E-02_JPRB/)
KAO( :, 3,12,10) = (/&
&1.5781E-03_JPRB,1.3908E-03_JPRB,1.2052E-03_JPRB,1.0160E-03_JPRB,8.3518E-04_JPRB,6.5087E-04_JPRB,&
&4.2444E-04_JPRB,1.1529E-05_JPRB,1.5881E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&1.5539E-03_JPRB,1.3775E-03_JPRB,1.1979E-03_JPRB,1.0287E-03_JPRB,8.5555E-04_JPRB,6.7702E-04_JPRB,&
&4.9760E-04_JPRB,3.6698E-05_JPRB,2.7219E-01_JPRB/)
KAO( :, 5,12,10) = (/&
&1.5294E-03_JPRB,1.3662E-03_JPRB,1.2069E-03_JPRB,1.0470E-03_JPRB,8.8424E-04_JPRB,7.2459E-04_JPRB,&
&6.0457E-04_JPRB,5.8830E-04_JPRB,4.3580E-01_JPRB/)
KAO( :, 1,13,10) = (/&
&1.8076E-03_JPRB,1.5828E-03_JPRB,1.3613E-03_JPRB,1.1383E-03_JPRB,9.1463E-04_JPRB,6.8299E-04_JPRB,&
&3.0458E-06_JPRB,2.1473E-06_JPRB,3.9495E-02_JPRB/)
KAO( :, 2,13,10) = (/&
&1.7788E-03_JPRB,1.5607E-03_JPRB,1.3444E-03_JPRB,1.1293E-03_JPRB,9.1288E-04_JPRB,6.9366E-04_JPRB,&
&2.1339E-05_JPRB,1.1723E-05_JPRB,8.1294E-02_JPRB/)
KAO( :, 3,13,10) = (/&
&1.7495E-03_JPRB,1.5404E-03_JPRB,1.3343E-03_JPRB,1.1244E-03_JPRB,9.2221E-04_JPRB,7.1955E-04_JPRB,&
&4.9268E-04_JPRB,4.3370E-06_JPRB,1.5101E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&1.7235E-03_JPRB,1.5270E-03_JPRB,1.3269E-03_JPRB,1.1365E-03_JPRB,9.4473E-04_JPRB,7.4612E-04_JPRB,&
&5.5227E-04_JPRB,4.6866E-05_JPRB,2.5856E-01_JPRB/)
KAO( :, 5,13,10) = (/&
&1.6990E-03_JPRB,1.5170E-03_JPRB,1.3368E-03_JPRB,1.1584E-03_JPRB,9.7488E-04_JPRB,7.9318E-04_JPRB,&
&6.2728E-04_JPRB,5.6960E-04_JPRB,4.1354E-01_JPRB/)
KAO( :, 1, 1,11) = (/&
&1.0196E-03_JPRB,9.3758E-04_JPRB,9.0316E-04_JPRB,8.5667E-04_JPRB,8.7577E-04_JPRB,1.0236E-03_JPRB,&
&1.1763E-03_JPRB,1.3143E-03_JPRB,1.4719E-03_JPRB/)
KAO( :, 2, 1,11) = (/&
&1.3459E-03_JPRB,1.2311E-03_JPRB,1.1576E-03_JPRB,1.1100E-03_JPRB,1.2232E-03_JPRB,1.4576E-03_JPRB,&
&1.6924E-03_JPRB,1.9154E-03_JPRB,2.1488E-03_JPRB/)
KAO( :, 3, 1,11) = (/&
&1.7777E-03_JPRB,1.6234E-03_JPRB,1.5128E-03_JPRB,1.4437E-03_JPRB,1.6918E-03_JPRB,2.0373E-03_JPRB,&
&2.3872E-03_JPRB,2.7172E-03_JPRB,3.0763E-03_JPRB/)
KAO( :, 4, 1,11) = (/&
&2.2969E-03_JPRB,2.1117E-03_JPRB,1.9790E-03_JPRB,1.9131E-03_JPRB,2.3134E-03_JPRB,2.7903E-03_JPRB,&
&3.2537E-03_JPRB,3.7099E-03_JPRB,4.2069E-03_JPRB/)
KAO( :, 5, 1,11) = (/&
&2.9364E-03_JPRB,2.7064E-03_JPRB,2.5487E-03_JPRB,2.4995E-03_JPRB,3.0802E-03_JPRB,3.7340E-03_JPRB,&
&4.3606E-03_JPRB,4.9323E-03_JPRB,5.6150E-03_JPRB/)
KAO( :, 1, 2,11) = (/&
&9.5564E-04_JPRB,8.6594E-04_JPRB,8.2247E-04_JPRB,7.8184E-04_JPRB,7.7258E-04_JPRB,8.9065E-04_JPRB,&
&1.0177E-03_JPRB,1.1498E-03_JPRB,1.2899E-03_JPRB/)
KAO( :, 2, 2,11) = (/&
&1.2029E-03_JPRB,1.1043E-03_JPRB,1.0479E-03_JPRB,9.9924E-04_JPRB,1.0917E-03_JPRB,1.3015E-03_JPRB,&
&1.5067E-03_JPRB,1.7035E-03_JPRB,1.9385E-03_JPRB/)
KAO( :, 3, 2,11) = (/&
&1.5957E-03_JPRB,1.4702E-03_JPRB,1.3834E-03_JPRB,1.3292E-03_JPRB,1.5404E-03_JPRB,1.8482E-03_JPRB,&
&2.1587E-03_JPRB,2.4595E-03_JPRB,2.8087E-03_JPRB/)
KAO( :, 4, 2,11) = (/&
&2.0836E-03_JPRB,1.9269E-03_JPRB,1.8210E-03_JPRB,1.7577E-03_JPRB,2.1115E-03_JPRB,2.5490E-03_JPRB,&
&2.9802E-03_JPRB,3.4053E-03_JPRB,3.8766E-03_JPRB/)
KAO( :, 5, 2,11) = (/&
&2.6761E-03_JPRB,2.4830E-03_JPRB,2.3690E-03_JPRB,2.3218E-03_JPRB,2.8435E-03_JPRB,3.4292E-03_JPRB,&
&4.0478E-03_JPRB,4.5913E-03_JPRB,5.2765E-03_JPRB/)
KAO( :, 1, 3,11) = (/&
&9.1098E-04_JPRB,8.1971E-04_JPRB,7.5453E-04_JPRB,6.8955E-04_JPRB,6.6573E-04_JPRB,7.4366E-04_JPRB,&
&8.3291E-04_JPRB,9.1681E-04_JPRB,1.0507E-03_JPRB/)
KAO( :, 2, 3,11) = (/&
&1.0095E-03_JPRB,9.2632E-04_JPRB,8.7912E-04_JPRB,8.5222E-04_JPRB,9.1711E-04_JPRB,1.0796E-03_JPRB,&
&1.2384E-03_JPRB,1.3937E-03_JPRB,1.6031E-03_JPRB/)
KAO( :, 3, 3,11) = (/&
&1.2860E-03_JPRB,1.2005E-03_JPRB,1.1448E-03_JPRB,1.1224E-03_JPRB,1.2896E-03_JPRB,1.5406E-03_JPRB,&
&1.7947E-03_JPRB,2.0396E-03_JPRB,2.3408E-03_JPRB/)
KAO( :, 4, 3,11) = (/&
&1.6840E-03_JPRB,1.5843E-03_JPRB,1.5072E-03_JPRB,1.4946E-03_JPRB,1.7912E-03_JPRB,2.1550E-03_JPRB,&
&2.5174E-03_JPRB,2.8934E-03_JPRB,3.3321E-03_JPRB/)
KAO( :, 5, 3,11) = (/&
&2.1821E-03_JPRB,2.0586E-03_JPRB,1.9862E-03_JPRB,1.9857E-03_JPRB,2.4329E-03_JPRB,2.9479E-03_JPRB,&
&3.4818E-03_JPRB,3.9625E-03_JPRB,4.5981E-03_JPRB/)
KAO( :, 1, 4,11) = (/&
&9.1007E-04_JPRB,8.1515E-04_JPRB,7.4019E-04_JPRB,6.6666E-04_JPRB,6.0223E-04_JPRB,6.1717E-04_JPRB,&
&6.7688E-04_JPRB,7.1358E-04_JPRB,8.7370E-04_JPRB/)
KAO( :, 2, 4,11) = (/&
&9.4061E-04_JPRB,8.5858E-04_JPRB,8.0024E-04_JPRB,7.4707E-04_JPRB,7.7220E-04_JPRB,8.8981E-04_JPRB,&
&1.0064E-03_JPRB,1.1094E-03_JPRB,1.3491E-03_JPRB/)
KAO( :, 3, 4,11) = (/&
&1.0580E-03_JPRB,9.8116E-04_JPRB,9.2713E-04_JPRB,9.3975E-04_JPRB,1.0753E-03_JPRB,1.2664E-03_JPRB,&
&1.4600E-03_JPRB,1.6482E-03_JPRB,1.9983E-03_JPRB/)
KAO( :, 4, 4,11) = (/&
&1.3185E-03_JPRB,1.2651E-03_JPRB,1.2235E-03_JPRB,1.2449E-03_JPRB,1.4893E-03_JPRB,1.7828E-03_JPRB,&
&2.0723E-03_JPRB,2.3550E-03_JPRB,2.8663E-03_JPRB/)
KAO( :, 5, 4,11) = (/&
&1.7012E-03_JPRB,1.6381E-03_JPRB,1.6202E-03_JPRB,1.6478E-03_JPRB,2.0248E-03_JPRB,2.4554E-03_JPRB,&
&2.8747E-03_JPRB,3.2963E-03_JPRB,4.0058E-03_JPRB/)
KAO( :, 1, 5,11) = (/&
&9.4336E-04_JPRB,8.3814E-04_JPRB,7.4599E-04_JPRB,6.5815E-04_JPRB,5.8713E-04_JPRB,5.1959E-04_JPRB,&
&5.3264E-04_JPRB,5.5247E-04_JPRB,1.0574E-03_JPRB/)
KAO( :, 2, 5,11) = (/&
&9.5312E-04_JPRB,8.5894E-04_JPRB,7.8295E-04_JPRB,7.1666E-04_JPRB,6.6657E-04_JPRB,7.2698E-04_JPRB,&
&8.1350E-04_JPRB,8.9727E-04_JPRB,1.7265E-03_JPRB/)
KAO( :, 3, 5,11) = (/&
&9.8083E-04_JPRB,9.0340E-04_JPRB,8.4536E-04_JPRB,8.1479E-04_JPRB,8.9835E-04_JPRB,1.0481E-03_JPRB,&
&1.2030E-03_JPRB,1.3495E-03_JPRB,2.6645E-03_JPRB/)
KAO( :, 4, 5,11) = (/&
&1.0919E-03_JPRB,1.0271E-03_JPRB,9.9432E-04_JPRB,1.0447E-03_JPRB,1.2444E-03_JPRB,1.4845E-03_JPRB,&
&1.7171E-03_JPRB,1.9373E-03_JPRB,3.9343E-03_JPRB/)
KAO( :, 5, 5,11) = (/&
&1.3125E-03_JPRB,1.2964E-03_JPRB,1.3064E-03_JPRB,1.3776E-03_JPRB,1.6940E-03_JPRB,2.0397E-03_JPRB,&
&2.3911E-03_JPRB,2.7218E-03_JPRB,5.5487E-03_JPRB/)
KAO( :, 1, 6,11) = (/&
&1.0191E-03_JPRB,8.9896E-04_JPRB,7.8508E-04_JPRB,6.7831E-04_JPRB,5.7633E-04_JPRB,4.9216E-04_JPRB,&
&4.0826E-04_JPRB,9.2980E-05_JPRB,1.3931E-03_JPRB/)
KAO( :, 2, 6,11) = (/&
&1.0047E-03_JPRB,8.9662E-04_JPRB,8.0205E-04_JPRB,7.1402E-04_JPRB,6.3991E-04_JPRB,5.8384E-04_JPRB,&
&6.2794E-04_JPRB,6.7696E-04_JPRB,2.3552E-03_JPRB/)
KAO( :, 3, 6,11) = (/&
&1.0047E-03_JPRB,9.1475E-04_JPRB,8.3262E-04_JPRB,7.7264E-04_JPRB,7.4682E-04_JPRB,8.3595E-04_JPRB,&
&9.5189E-04_JPRB,1.0656E-03_JPRB,3.7189E-03_JPRB/)
KAO( :, 4, 6,11) = (/&
&1.0246E-03_JPRB,9.4864E-04_JPRB,8.9322E-04_JPRB,8.8690E-04_JPRB,1.0204E-03_JPRB,1.2021E-03_JPRB,&
&1.3925E-03_JPRB,1.5656E-03_JPRB,5.5692E-03_JPRB/)
KAO( :, 5, 6,11) = (/&
&1.1192E-03_JPRB,1.0605E-03_JPRB,1.0485E-03_JPRB,1.1451E-03_JPRB,1.4045E-03_JPRB,1.6858E-03_JPRB,&
&1.9713E-03_JPRB,2.2360E-03_JPRB,7.9629E-03_JPRB/)
KAO( :, 1, 7,11) = (/&
&1.1105E-03_JPRB,9.7554E-04_JPRB,8.4845E-04_JPRB,7.2311E-04_JPRB,5.9822E-04_JPRB,4.8054E-04_JPRB,&
&3.5912E-04_JPRB,1.6334E-05_JPRB,1.8685E-03_JPRB/)
KAO( :, 2, 7,11) = (/&
&1.0953E-03_JPRB,9.7181E-04_JPRB,8.5659E-04_JPRB,7.3634E-04_JPRB,6.3339E-04_JPRB,5.4068E-04_JPRB,&
&4.8190E-04_JPRB,4.0504E-04_JPRB,3.3171E-03_JPRB/)
KAO( :, 3, 7,11) = (/&
&1.0776E-03_JPRB,9.6988E-04_JPRB,8.6596E-04_JPRB,7.7221E-04_JPRB,7.0034E-04_JPRB,6.6772E-04_JPRB,&
&7.4067E-04_JPRB,8.0814E-04_JPRB,5.4649E-03_JPRB/)
KAO( :, 4, 7,11) = (/&
&1.0633E-03_JPRB,9.7163E-04_JPRB,8.9525E-04_JPRB,8.4042E-04_JPRB,8.3803E-04_JPRB,9.5863E-04_JPRB,&
&1.0998E-03_JPRB,1.2373E-03_JPRB,8.4838E-03_JPRB/)
KAO( :, 5, 7,11) = (/&
&1.0727E-03_JPRB,1.0017E-03_JPRB,9.6422E-04_JPRB,9.7682E-04_JPRB,1.1474E-03_JPRB,1.3738E-03_JPRB,&
&1.6070E-03_JPRB,1.8227E-03_JPRB,1.2477E-02_JPRB/)
KAO( :, 1, 8,11) = (/&
&1.2212E-03_JPRB,1.0686E-03_JPRB,9.2776E-04_JPRB,7.8030E-04_JPRB,6.3679E-04_JPRB,4.9028E-04_JPRB,&
&2.5705E-05_JPRB,3.5598E-06_JPRB,3.0236E-03_JPRB/)
KAO( :, 2, 8,11) = (/&
&1.1904E-03_JPRB,1.0515E-03_JPRB,9.1846E-04_JPRB,7.8584E-04_JPRB,6.5098E-04_JPRB,5.2805E-04_JPRB,&
&4.1417E-04_JPRB,7.4299E-06_JPRB,5.6339E-03_JPRB/)
KAO( :, 3, 8,11) = (/&
&1.1656E-03_JPRB,1.0373E-03_JPRB,9.2017E-04_JPRB,7.9903E-04_JPRB,6.9375E-04_JPRB,6.0910E-04_JPRB,&
&5.7009E-04_JPRB,5.4932E-04_JPRB,9.6178E-03_JPRB/)
KAO( :, 4, 8,11) = (/&
&1.1498E-03_JPRB,1.0424E-03_JPRB,9.3266E-04_JPRB,8.4261E-04_JPRB,7.7492E-04_JPRB,7.6691E-04_JPRB,&
&8.6816E-04_JPRB,9.6408E-04_JPRB,1.5378E-02_JPRB/)
KAO( :, 5, 8,11) = (/&
&1.1310E-03_JPRB,1.0416E-03_JPRB,9.7038E-04_JPRB,9.2287E-04_JPRB,9.4475E-04_JPRB,1.1097E-03_JPRB,&
&1.2928E-03_JPRB,1.4673E-03_JPRB,2.3131E-02_JPRB/)
KAO( :, 1, 9,11) = (/&
&1.3346E-03_JPRB,1.1677E-03_JPRB,1.0079E-03_JPRB,8.4634E-04_JPRB,6.8278E-04_JPRB,5.1557E-04_JPRB,&
&6.2170E-06_JPRB,3.5575E-07_JPRB,9.0278E-03_JPRB/)
KAO( :, 2, 9,11) = (/&
&1.3004E-03_JPRB,1.1437E-03_JPRB,9.9288E-04_JPRB,8.4407E-04_JPRB,6.9152E-04_JPRB,5.4161E-04_JPRB,&
&3.0407E-04_JPRB,7.5811E-06_JPRB,1.7755E-02_JPRB/)
KAO( :, 3, 9,11) = (/&
&1.2716E-03_JPRB,1.1282E-03_JPRB,9.9193E-04_JPRB,8.4979E-04_JPRB,7.1877E-04_JPRB,5.8562E-04_JPRB,&
&4.7440E-04_JPRB,1.3642E-04_JPRB,3.1669E-02_JPRB/)
KAO( :, 4, 9,11) = (/&
&1.2493E-03_JPRB,1.1232E-03_JPRB,9.9486E-04_JPRB,8.7574E-04_JPRB,7.6208E-04_JPRB,6.8407E-04_JPRB,&
&6.7008E-04_JPRB,7.2430E-04_JPRB,5.2322E-02_JPRB/)
KAO( :, 5, 9,11) = (/&
&1.2292E-03_JPRB,1.1190E-03_JPRB,1.0123E-03_JPRB,9.2200E-04_JPRB,8.6839E-04_JPRB,8.8671E-04_JPRB,&
&1.0239E-03_JPRB,1.1645E-03_JPRB,8.1332E-02_JPRB/)
KAO( :, 1,10,11) = (/&
&1.4702E-03_JPRB,1.2866E-03_JPRB,1.1046E-03_JPRB,9.2775E-04_JPRB,7.4227E-04_JPRB,5.4877E-04_JPRB,&
&1.5669E-06_JPRB,2.1750E-07_JPRB,3.1809E-02_JPRB/)
KAO( :, 2,10,11) = (/&
&1.4381E-03_JPRB,1.2591E-03_JPRB,1.0910E-03_JPRB,9.1751E-04_JPRB,7.4581E-04_JPRB,5.6956E-04_JPRB,&
&1.4408E-05_JPRB,2.9977E-06_JPRB,6.5658E-02_JPRB/)
KAO( :, 3,10,11) = (/&
&1.4088E-03_JPRB,1.2443E-03_JPRB,1.0832E-03_JPRB,9.2001E-04_JPRB,7.6006E-04_JPRB,6.0163E-04_JPRB,&
&4.0981E-04_JPRB,3.3752E-06_JPRB,1.2158E-01_JPRB/)
KAO( :, 4,10,11) = (/&
&1.3837E-03_JPRB,1.2299E-03_JPRB,1.0785E-03_JPRB,9.3172E-04_JPRB,7.8792E-04_JPRB,6.5978E-04_JPRB,&
&5.6509E-04_JPRB,4.3870E-04_JPRB,2.0789E-01_JPRB/)
KAO( :, 5,10,11) = (/&
&1.3583E-03_JPRB,1.2214E-03_JPRB,1.0847E-03_JPRB,9.6075E-04_JPRB,8.5481E-04_JPRB,7.9082E-04_JPRB,&
&8.2900E-04_JPRB,9.3239E-04_JPRB,3.3217E-01_JPRB/)
KAO( :, 1,11,11) = (/&
&1.6253E-03_JPRB,1.4219E-03_JPRB,1.2219E-03_JPRB,1.0236E-03_JPRB,8.2003E-04_JPRB,6.0541E-04_JPRB,&
&1.4231E-06_JPRB,1.8071E-07_JPRB,5.4692E-02_JPRB/)
KAO( :, 2,11,11) = (/&
&1.5951E-03_JPRB,1.3985E-03_JPRB,1.2081E-03_JPRB,1.0150E-03_JPRB,8.2284E-04_JPRB,6.1646E-04_JPRB,&
&9.6207E-06_JPRB,2.7452E-06_JPRB,1.1216E-01_JPRB/)
KAO( :, 3,11,11) = (/&
&1.5642E-03_JPRB,1.3790E-03_JPRB,1.1965E-03_JPRB,1.0113E-03_JPRB,8.2943E-04_JPRB,6.4775E-04_JPRB,&
&4.3571E-04_JPRB,8.6785E-06_JPRB,2.0795E-01_JPRB/)
KAO( :, 4,11,11) = (/&
&1.5361E-03_JPRB,1.3630E-03_JPRB,1.1895E-03_JPRB,1.0207E-03_JPRB,8.5744E-04_JPRB,7.0323E-04_JPRB,&
&5.8809E-04_JPRB,4.1682E-04_JPRB,3.5571E-01_JPRB/)
KAO( :, 5,11,11) = (/&
&1.5066E-03_JPRB,1.3488E-03_JPRB,1.1930E-03_JPRB,1.0481E-03_JPRB,9.1295E-04_JPRB,8.2679E-04_JPRB,&
&8.2109E-04_JPRB,9.1792E-04_JPRB,5.7120E-01_JPRB/)
KAO( :, 1,12,11) = (/&
&1.8041E-03_JPRB,1.5789E-03_JPRB,1.3570E-03_JPRB,1.1389E-03_JPRB,9.1257E-04_JPRB,6.7888E-04_JPRB,&
&5.1658E-06_JPRB,1.5829E-07_JPRB,6.8561E-02_JPRB/)
KAO( :, 2,12,11) = (/&
&1.7738E-03_JPRB,1.5558E-03_JPRB,1.3438E-03_JPRB,1.1292E-03_JPRB,9.1436E-04_JPRB,6.9573E-04_JPRB,&
&2.0820E-05_JPRB,3.7433E-06_JPRB,1.4057E-01_JPRB/)
KAO( :, 3,12,11) = (/&
&1.7418E-03_JPRB,1.5353E-03_JPRB,1.3329E-03_JPRB,1.1261E-03_JPRB,9.2270E-04_JPRB,7.2358E-04_JPRB,&
&4.7954E-04_JPRB,1.5535E-05_JPRB,2.6118E-01_JPRB/)
KAO( :, 4,12,11) = (/&
&1.7090E-03_JPRB,1.5180E-03_JPRB,1.3238E-03_JPRB,1.1375E-03_JPRB,9.5111E-04_JPRB,7.6548E-04_JPRB,&
&6.0636E-04_JPRB,4.1209E-04_JPRB,4.4778E-01_JPRB/)
KAO( :, 5,12,11) = (/&
&1.6778E-03_JPRB,1.5017E-03_JPRB,1.3263E-03_JPRB,1.1626E-03_JPRB,9.9449E-04_JPRB,8.6348E-04_JPRB,&
&8.1707E-04_JPRB,9.1552E-04_JPRB,7.1823E-01_JPRB/)
KAO( :, 1,13,11) = (/&
&2.0162E-03_JPRB,1.7643E-03_JPRB,1.5166E-03_JPRB,1.2707E-03_JPRB,1.0200E-03_JPRB,7.6409E-04_JPRB,&
&1.3933E-06_JPRB,1.3814E-07_JPRB,6.7541E-02_JPRB/)
KAO( :, 2,13,11) = (/&
&1.9804E-03_JPRB,1.7378E-03_JPRB,1.5003E-03_JPRB,1.2598E-03_JPRB,1.0208E-03_JPRB,7.7583E-04_JPRB,&
&1.0519E-04_JPRB,2.9677E-05_JPRB,1.3898E-01_JPRB/)
KAO( :, 3,13,11) = (/&
&1.9463E-03_JPRB,1.7141E-03_JPRB,1.4887E-03_JPRB,1.2580E-03_JPRB,1.0319E-03_JPRB,8.0958E-04_JPRB,&
&5.4607E-04_JPRB,8.2236E-06_JPRB,2.5839E-01_JPRB/)
KAO( :, 4,13,11) = (/&
&1.9119E-03_JPRB,1.6986E-03_JPRB,1.4811E-03_JPRB,1.2741E-03_JPRB,1.0665E-03_JPRB,8.4965E-04_JPRB,&
&6.3669E-04_JPRB,4.3144E-04_JPRB,4.4372E-01_JPRB/)
KAO( :, 5,13,11) = (/&
&1.8807E-03_JPRB,1.6835E-03_JPRB,1.4885E-03_JPRB,1.3024E-03_JPRB,1.1081E-03_JPRB,9.2308E-04_JPRB,&
&8.2856E-04_JPRB,9.1296E-04_JPRB,7.1076E-01_JPRB/)
KAO( :, 1, 1,12) = (/&
&1.1348E-03_JPRB,1.0512E-03_JPRB,1.0112E-03_JPRB,1.0380E-03_JPRB,1.2591E-03_JPRB,1.5034E-03_JPRB,&
&1.7458E-03_JPRB,1.9916E-03_JPRB,2.2515E-03_JPRB/)
KAO( :, 2, 1,12) = (/&
&1.4497E-03_JPRB,1.3258E-03_JPRB,1.2902E-03_JPRB,1.3933E-03_JPRB,1.7402E-03_JPRB,2.0749E-03_JPRB,&
&2.4232E-03_JPRB,2.7843E-03_JPRB,3.1336E-03_JPRB/)
KAO( :, 3, 1,12) = (/&
&1.9087E-03_JPRB,1.7431E-03_JPRB,1.6616E-03_JPRB,1.8437E-03_JPRB,2.3259E-03_JPRB,2.8106E-03_JPRB,&
&3.3232E-03_JPRB,3.7674E-03_JPRB,4.2777E-03_JPRB/)
KAO( :, 4, 1,12) = (/&
&2.5088E-03_JPRB,2.2929E-03_JPRB,2.1415E-03_JPRB,2.4320E-03_JPRB,3.0901E-03_JPRB,3.7563E-03_JPRB,&
&4.4295E-03_JPRB,5.0514E-03_JPRB,5.7435E-03_JPRB/)
KAO( :, 5, 1,12) = (/&
&3.2224E-03_JPRB,2.9512E-03_JPRB,2.7375E-03_JPRB,3.2055E-03_JPRB,4.1147E-03_JPRB,5.0116E-03_JPRB,&
&5.9163E-03_JPRB,6.7642E-03_JPRB,7.7486E-03_JPRB/)
KAO( :, 1, 2,12) = (/&
&1.0492E-03_JPRB,9.6475E-04_JPRB,9.4375E-04_JPRB,9.3817E-04_JPRB,1.1146E-03_JPRB,1.3292E-03_JPRB,&
&1.5275E-03_JPRB,1.7383E-03_JPRB,1.9763E-03_JPRB/)
KAO( :, 2, 2,12) = (/&
&1.3114E-03_JPRB,1.2057E-03_JPRB,1.1899E-03_JPRB,1.2587E-03_JPRB,1.5556E-03_JPRB,1.8745E-03_JPRB,&
&2.1716E-03_JPRB,2.4737E-03_JPRB,2.8199E-03_JPRB/)
KAO( :, 3, 2,12) = (/&
&1.7413E-03_JPRB,1.5927E-03_JPRB,1.5301E-03_JPRB,1.6869E-03_JPRB,2.1324E-03_JPRB,2.5756E-03_JPRB,&
&3.0059E-03_JPRB,3.4270E-03_JPRB,3.9244E-03_JPRB/)
KAO( :, 4, 2,12) = (/&
&2.2840E-03_JPRB,2.1084E-03_JPRB,1.9850E-03_JPRB,2.2595E-03_JPRB,2.8933E-03_JPRB,3.5203E-03_JPRB,&
&4.1407E-03_JPRB,4.7114E-03_JPRB,5.4047E-03_JPRB/)
KAO( :, 5, 2,12) = (/&
&2.9533E-03_JPRB,2.7476E-03_JPRB,2.5658E-03_JPRB,3.0087E-03_JPRB,3.8774E-03_JPRB,4.7340E-03_JPRB,&
&5.5746E-03_JPRB,6.3471E-03_JPRB,7.3465E-03_JPRB/)
KAO( :, 1, 3,12) = (/&
&9.8854E-04_JPRB,8.9343E-04_JPRB,8.4035E-04_JPRB,7.9923E-04_JPRB,8.9609E-04_JPRB,1.0622E-03_JPRB,&
&1.2115E-03_JPRB,1.3909E-03_JPRB,1.5813E-03_JPRB/)
KAO( :, 2, 3,12) = (/&
&1.0879E-03_JPRB,1.0117E-03_JPRB,1.0134E-03_JPRB,1.0514E-03_JPRB,1.2838E-03_JPRB,1.5374E-03_JPRB,&
&1.7938E-03_JPRB,2.0363E-03_JPRB,2.3508E-03_JPRB/)
KAO( :, 3, 3,12) = (/&
&1.4163E-03_JPRB,1.3226E-03_JPRB,1.2897E-03_JPRB,1.4327E-03_JPRB,1.8163E-03_JPRB,2.1941E-03_JPRB,&
&2.5686E-03_JPRB,2.9319E-03_JPRB,3.4012E-03_JPRB/)
KAO( :, 4, 3,12) = (/&
&1.8714E-03_JPRB,1.7493E-03_JPRB,1.6791E-03_JPRB,1.9710E-03_JPRB,2.5266E-03_JPRB,3.0817E-03_JPRB,&
&3.6203E-03_JPRB,4.1272E-03_JPRB,4.8320E-03_JPRB/)
KAO( :, 5, 3,12) = (/&
&2.4278E-03_JPRB,2.3027E-03_JPRB,2.1923E-03_JPRB,2.6689E-03_JPRB,3.4381E-03_JPRB,4.1969E-03_JPRB,&
&4.9576E-03_JPRB,5.6521E-03_JPRB,6.6247E-03_JPRB/)
KAO( :, 1, 4,12) = (/&
&9.8669E-04_JPRB,8.8509E-04_JPRB,8.1352E-04_JPRB,7.2996E-04_JPRB,7.1817E-04_JPRB,8.1881E-04_JPRB,&
&9.2748E-04_JPRB,1.0403E-03_JPRB,1.2116E-03_JPRB/)
KAO( :, 2, 4,12) = (/&
&1.0290E-03_JPRB,9.4426E-04_JPRB,8.9000E-04_JPRB,8.7285E-04_JPRB,1.0287E-03_JPRB,1.2254E-03_JPRB,&
&1.4193E-03_JPRB,1.6044E-03_JPRB,1.8734E-03_JPRB/)
KAO( :, 3, 4,12) = (/&
&1.1436E-03_JPRB,1.0840E-03_JPRB,1.0833E-03_JPRB,1.1914E-03_JPRB,1.4983E-03_JPRB,1.8005E-03_JPRB,&
&2.1029E-03_JPRB,2.3872E-03_JPRB,2.8182E-03_JPRB/)
KAO( :, 4, 4,12) = (/&
&1.4872E-03_JPRB,1.4093E-03_JPRB,1.3825E-03_JPRB,1.6613E-03_JPRB,2.1282E-03_JPRB,2.5939E-03_JPRB,&
&3.0338E-03_JPRB,3.4691E-03_JPRB,4.1139E-03_JPRB/)
KAO( :, 5, 4,12) = (/&
&1.9382E-03_JPRB,1.8528E-03_JPRB,1.8277E-03_JPRB,2.2907E-03_JPRB,2.9502E-03_JPRB,3.6113E-03_JPRB,&
&4.2678E-03_JPRB,4.8667E-03_JPRB,5.7453E-03_JPRB/)
KAO( :, 1, 5,12) = (/&
&1.0261E-03_JPRB,9.1725E-04_JPRB,8.2759E-04_JPRB,7.3874E-04_JPRB,6.4512E-04_JPRB,6.5305E-04_JPRB,&
&7.2025E-04_JPRB,7.5251E-04_JPRB,1.2236E-03_JPRB/)
KAO( :, 2, 5,12) = (/&
&1.0342E-03_JPRB,9.3335E-04_JPRB,8.6180E-04_JPRB,7.8962E-04_JPRB,8.4539E-04_JPRB,9.8224E-04_JPRB,&
&1.1196E-03_JPRB,1.2424E-03_JPRB,1.9823E-03_JPRB/)
KAO( :, 3, 5,12) = (/&
&1.0684E-03_JPRB,1.0038E-03_JPRB,9.4286E-04_JPRB,9.9237E-04_JPRB,1.2238E-03_JPRB,1.4671E-03_JPRB,&
&1.7012E-03_JPRB,1.9194E-03_JPRB,3.0657E-03_JPRB/)
KAO( :, 4, 5,12) = (/&
&1.1964E-03_JPRB,1.1404E-03_JPRB,1.1495E-03_JPRB,1.3909E-03_JPRB,1.7635E-03_JPRB,2.1391E-03_JPRB,&
&2.5166E-03_JPRB,2.8551E-03_JPRB,4.5233E-03_JPRB/)
KAO( :, 5, 5,12) = (/&
&1.5188E-03_JPRB,1.4742E-03_JPRB,1.5113E-03_JPRB,1.9296E-03_JPRB,2.4758E-03_JPRB,3.0285E-03_JPRB,&
&3.5691E-03_JPRB,4.1028E-03_JPRB,6.4627E-03_JPRB/)
KAO( :, 1, 6,12) = (/&
&1.1049E-03_JPRB,9.7887E-04_JPRB,8.6230E-04_JPRB,7.6209E-04_JPRB,6.5337E-04_JPRB,5.5666E-04_JPRB,&
&5.5642E-04_JPRB,4.3457E-04_JPRB,1.6601E-03_JPRB/)
KAO( :, 2, 6,12) = (/&
&1.0940E-03_JPRB,9.8241E-04_JPRB,8.8704E-04_JPRB,7.8683E-04_JPRB,7.2565E-04_JPRB,7.9447E-04_JPRB,&
&8.9119E-04_JPRB,9.6573E-04_JPRB,2.8308E-03_JPRB/)
KAO( :, 3, 6,12) = (/&
&1.0875E-03_JPRB,9.9703E-04_JPRB,9.2009E-04_JPRB,8.7195E-04_JPRB,1.0022E-03_JPRB,1.1888E-03_JPRB,&
&1.3628E-03_JPRB,1.5154E-03_JPRB,4.5116E-03_JPRB/)
KAO( :, 4, 6,12) = (/&
&1.1159E-03_JPRB,1.0443E-03_JPRB,1.0086E-03_JPRB,1.1512E-03_JPRB,1.4495E-03_JPRB,1.7437E-03_JPRB,&
&2.0380E-03_JPRB,2.2956E-03_JPRB,6.7993E-03_JPRB/)
KAO( :, 5, 6,12) = (/&
&1.2286E-03_JPRB,1.1769E-03_JPRB,1.2461E-03_JPRB,1.5980E-03_JPRB,2.0421E-03_JPRB,2.4961E-03_JPRB,&
&2.9289E-03_JPRB,3.3559E-03_JPRB,9.7752E-03_JPRB/)
KAO( :, 1, 7,12) = (/&
&1.2137E-03_JPRB,1.0668E-03_JPRB,9.3381E-04_JPRB,8.0126E-04_JPRB,6.7255E-04_JPRB,5.4820E-04_JPRB,&
&4.1640E-04_JPRB,3.0869E-05_JPRB,2.3413E-03_JPRB/)
KAO( :, 2, 7,12) = (/&
&1.1848E-03_JPRB,1.0517E-03_JPRB,9.3479E-04_JPRB,8.1727E-04_JPRB,7.1224E-04_JPRB,6.5078E-04_JPRB,&
&7.0341E-04_JPRB,7.0961E-04_JPRB,4.1815E-03_JPRB/)
KAO( :, 3, 7,12) = (/&
&1.1720E-03_JPRB,1.0531E-03_JPRB,9.4856E-04_JPRB,8.6129E-04_JPRB,8.4208E-04_JPRB,9.5854E-04_JPRB,&
&1.0943E-03_JPRB,1.2041E-03_JPRB,6.9208E-03_JPRB/)
KAO( :, 4, 7,12) = (/&
&1.1592E-03_JPRB,1.0754E-03_JPRB,9.9552E-04_JPRB,9.9504E-04_JPRB,1.1919E-03_JPRB,1.4256E-03_JPRB,&
&1.6531E-03_JPRB,1.8455E-03_JPRB,1.0828E-02_JPRB/)
KAO( :, 5, 7,12) = (/&
&1.1731E-03_JPRB,1.1101E-03_JPRB,1.1084E-03_JPRB,1.3320E-03_JPRB,1.6974E-03_JPRB,2.0528E-03_JPRB,&
&2.4023E-03_JPRB,2.7339E-03_JPRB,1.6080E-02_JPRB/)
KAO( :, 1, 8,12) = (/&
&1.3302E-03_JPRB,1.1658E-03_JPRB,1.0139E-03_JPRB,8.5656E-04_JPRB,7.0725E-04_JPRB,5.4905E-04_JPRB,&
&1.6082E-04_JPRB,2.8484E-07_JPRB,3.9959E-03_JPRB/)
KAO( :, 2, 8,12) = (/&
&1.3004E-03_JPRB,1.1467E-03_JPRB,1.0012E-03_JPRB,8.6385E-04_JPRB,7.2504E-04_JPRB,6.1282E-04_JPRB,&
&5.3057E-04_JPRB,1.6656E-04_JPRB,7.5095E-03_JPRB/)
KAO( :, 3, 8,12) = (/&
&1.2723E-03_JPRB,1.1332E-03_JPRB,1.0084E-03_JPRB,8.8648E-04_JPRB,8.0497E-04_JPRB,7.6904E-04_JPRB,&
&8.5886E-04_JPRB,9.3436E-04_JPRB,1.2956E-02_JPRB/)
KAO( :, 4, 8,12) = (/&
&1.2504E-03_JPRB,1.1361E-03_JPRB,1.0320E-03_JPRB,9.6671E-04_JPRB,9.9043E-04_JPRB,1.1533E-03_JPRB,&
&1.3325E-03_JPRB,1.4846E-03_JPRB,2.0833E-02_JPRB/)
KAO( :, 5, 8,12) = (/&
&1.2393E-03_JPRB,1.1508E-03_JPRB,1.0962E-03_JPRB,1.1509E-03_JPRB,1.4064E-03_JPRB,1.6900E-03_JPRB,&
&1.9737E-03_JPRB,2.2347E-03_JPRB,3.1620E-02_JPRB/)
KAO( :, 1, 9,12) = (/&
&1.4663E-03_JPRB,1.2845E-03_JPRB,1.1076E-03_JPRB,9.3469E-04_JPRB,7.5727E-04_JPRB,5.8307E-04_JPRB,&
&1.6145E-06_JPRB,2.0592E-07_JPRB,1.2575E-02_JPRB/)
KAO( :, 2, 9,12) = (/&
&1.4356E-03_JPRB,1.2615E-03_JPRB,1.0955E-03_JPRB,9.3110E-04_JPRB,7.6732E-04_JPRB,6.0757E-04_JPRB,&
&4.4742E-04_JPRB,4.9464E-06_JPRB,2.4960E-02_JPRB/)
KAO( :, 3, 9,12) = (/&
&1.4052E-03_JPRB,1.2435E-03_JPRB,1.0940E-03_JPRB,9.3756E-04_JPRB,8.0269E-04_JPRB,7.0533E-04_JPRB,&
&6.6208E-04_JPRB,5.9691E-04_JPRB,4.4947E-02_JPRB/)
KAO( :, 4, 9,12) = (/&
&1.3734E-03_JPRB,1.2333E-03_JPRB,1.0941E-03_JPRB,9.8345E-04_JPRB,9.2035E-04_JPRB,9.1976E-04_JPRB,&
&1.0530E-03_JPRB,1.1532E-03_JPRB,7.5044E-02_JPRB/)
KAO( :, 5, 9,12) = (/&
&1.3495E-03_JPRB,1.2289E-03_JPRB,1.1320E-03_JPRB,1.1073E-03_JPRB,1.1561E-03_JPRB,1.3692E-03_JPRB,&
&1.6014E-03_JPRB,1.8055E-03_JPRB,1.1730E-01_JPRB/)
KAO( :, 1,10,12) = (/&
&1.6187E-03_JPRB,1.4174E-03_JPRB,1.2153E-03_JPRB,1.0239E-03_JPRB,8.2814E-04_JPRB,6.1453E-04_JPRB,&
&6.9444E-06_JPRB,1.3528E-07_JPRB,4.6442E-02_JPRB/)
KAO( :, 2,10,12) = (/&
&1.5845E-03_JPRB,1.3876E-03_JPRB,1.2040E-03_JPRB,1.0153E-03_JPRB,8.2732E-04_JPRB,6.3066E-04_JPRB,&
&6.0414E-06_JPRB,2.4038E-07_JPRB,9.7061E-02_JPRB/)
KAO( :, 3,10,12) = (/&
&1.5496E-03_JPRB,1.3649E-03_JPRB,1.1919E-03_JPRB,1.0167E-03_JPRB,8.3828E-04_JPRB,6.9321E-04_JPRB,&
&5.6244E-04_JPRB,1.6180E-05_JPRB,1.8182E-01_JPRB/)
KAO( :, 4,10,12) = (/&
&1.5143E-03_JPRB,1.3460E-03_JPRB,1.1894E-03_JPRB,1.0321E-03_JPRB,9.2147E-04_JPRB,8.3365E-04_JPRB,&
&8.4635E-04_JPRB,8.9521E-04_JPRB,3.1352E-01_JPRB/)
KAO( :, 5,10,12) = (/&
&1.4834E-03_JPRB,1.3403E-03_JPRB,1.2022E-03_JPRB,1.1224E-03_JPRB,1.0739E-03_JPRB,1.1316E-03_JPRB,&
&1.3218E-03_JPRB,1.4837E-03_JPRB,5.0232E-01_JPRB/)
KAO( :, 1,11,12) = (/&
&1.7757E-03_JPRB,1.5541E-03_JPRB,1.3331E-03_JPRB,1.1222E-03_JPRB,9.0093E-04_JPRB,6.6092E-04_JPRB,&
&2.1249E-07_JPRB,1.1902E-07_JPRB,8.4989E-02_JPRB/)
KAO( :, 2,11,12) = (/&
&1.7401E-03_JPRB,1.5236E-03_JPRB,1.3209E-03_JPRB,1.1131E-03_JPRB,9.0551E-04_JPRB,6.8456E-04_JPRB,&
&5.0849E-06_JPRB,2.2480E-07_JPRB,1.7663E-01_JPRB/)
KAO( :, 3,11,12) = (/&
&1.7062E-03_JPRB,1.5022E-03_JPRB,1.3117E-03_JPRB,1.1165E-03_JPRB,9.1999E-04_JPRB,7.4783E-04_JPRB,&
&5.9186E-04_JPRB,1.9217E-05_JPRB,3.2957E-01_JPRB/)
KAO( :, 4,11,12) = (/&
&1.6714E-03_JPRB,1.4855E-03_JPRB,1.3084E-03_JPRB,1.1327E-03_JPRB,9.9341E-04_JPRB,8.8882E-04_JPRB,&
&8.4081E-04_JPRB,8.6421E-04_JPRB,5.6545E-01_JPRB/)
KAO( :, 5,11,12) = (/&
&1.6419E-03_JPRB,1.4793E-03_JPRB,1.3196E-03_JPRB,1.2145E-03_JPRB,1.1433E-03_JPRB,1.1424E-03_JPRB,&
&1.3148E-03_JPRB,1.4973E-03_JPRB,9.0555E-01_JPRB/)
KAO( :, 1,12,12) = (/&
&1.9873E-03_JPRB,1.7393E-03_JPRB,1.4928E-03_JPRB,1.2520E-03_JPRB,1.0061E-03_JPRB,7.4569E-04_JPRB,&
&3.5180E-06_JPRB,1.0587E-07_JPRB,1.1338E-01_JPRB/)
KAO( :, 2,12,12) = (/&
&1.9520E-03_JPRB,1.7112E-03_JPRB,1.4785E-03_JPRB,1.2437E-03_JPRB,1.0101E-03_JPRB,7.5903E-04_JPRB,&
&1.0775E-04_JPRB,2.1135E-07_JPRB,2.3445E-01_JPRB/)
KAO( :, 3,12,12) = (/&
&1.9174E-03_JPRB,1.6867E-03_JPRB,1.4681E-03_JPRB,1.2458E-03_JPRB,1.0238E-03_JPRB,8.1622E-04_JPRB,&
&6.4203E-04_JPRB,3.7377E-05_JPRB,4.3560E-01_JPRB/)
KAO( :, 4,12,12) = (/&
&1.8834E-03_JPRB,1.6709E-03_JPRB,1.4657E-03_JPRB,1.2628E-03_JPRB,1.0856E-03_JPRB,9.4862E-04_JPRB,&
&8.6085E-04_JPRB,8.9434E-04_JPRB,7.4512E-01_JPRB/)
KAO( :, 5,12,12) = (/&
&1.8486E-03_JPRB,1.6625E-03_JPRB,1.4769E-03_JPRB,1.3298E-03_JPRB,1.2184E-03_JPRB,1.1740E-03_JPRB,&
&1.3120E-03_JPRB,1.5054E-03_JPRB,1.1919E+00_JPRB/)
KAO( :, 1,13,12) = (/&
&2.2427E-03_JPRB,1.9626E-03_JPRB,1.6858E-03_JPRB,1.4123E-03_JPRB,1.1345E-03_JPRB,8.4814E-04_JPRB,&
&1.1187E-05_JPRB,1.0167E-07_JPRB,1.1866E-01_JPRB/)
KAO( :, 2,13,12) = (/&
&2.2124E-03_JPRB,1.9395E-03_JPRB,1.6734E-03_JPRB,1.4094E-03_JPRB,1.1421E-03_JPRB,8.6480E-04_JPRB,&
&5.2696E-04_JPRB,2.8959E-06_JPRB,2.4434E-01_JPRB/)
KAO( :, 3,13,12) = (/&
&2.1775E-03_JPRB,1.9152E-03_JPRB,1.6674E-03_JPRB,1.4121E-03_JPRB,1.1577E-03_JPRB,9.1193E-04_JPRB,&
&6.8708E-04_JPRB,6.0943E-05_JPRB,4.5287E-01_JPRB/)
KAO( :, 4,13,12) = (/&
&2.1409E-03_JPRB,1.8984E-03_JPRB,1.6628E-03_JPRB,1.4290E-03_JPRB,1.2050E-03_JPRB,1.0161E-03_JPRB,&
&8.8642E-04_JPRB,9.0231E-04_JPRB,7.7451E-01_JPRB/)
KAO( :, 5,13,12) = (/&
&2.1006E-03_JPRB,1.8859E-03_JPRB,1.6731E-03_JPRB,1.4783E-03_JPRB,1.3081E-03_JPRB,1.2199E-03_JPRB,&
&1.3045E-03_JPRB,1.5082E-03_JPRB,1.2405E+00_JPRB/)
KAO( :, 1, 1,13) = (/&
&1.2739E-03_JPRB,1.1824E-03_JPRB,1.1666E-03_JPRB,1.5366E-03_JPRB,1.9783E-03_JPRB,2.4169E-03_JPRB,&
&2.8580E-03_JPRB,3.2493E-03_JPRB,3.6912E-03_JPRB/)
KAO( :, 2, 1,13) = (/&
&1.5764E-03_JPRB,1.4796E-03_JPRB,1.5934E-03_JPRB,2.2153E-03_JPRB,2.8682E-03_JPRB,3.5161E-03_JPRB,&
&4.1531E-03_JPRB,4.7522E-03_JPRB,5.3893E-03_JPRB/)
KAO( :, 3, 1,13) = (/&
&2.0474E-03_JPRB,1.8907E-03_JPRB,2.1514E-03_JPRB,3.0567E-03_JPRB,3.9747E-03_JPRB,4.8887E-03_JPRB,&
&5.7686E-03_JPRB,6.5999E-03_JPRB,7.5144E-03_JPRB/)
KAO( :, 4, 1,13) = (/&
&2.6856E-03_JPRB,2.4413E-03_JPRB,2.8242E-03_JPRB,4.0342E-03_JPRB,5.3078E-03_JPRB,6.5325E-03_JPRB,&
&7.7349E-03_JPRB,8.8443E-03_JPRB,1.0074E-02_JPRB/)
KAO( :, 5, 1,13) = (/&
&3.4590E-03_JPRB,3.1378E-03_JPRB,3.6496E-03_JPRB,5.2809E-03_JPRB,6.8982E-03_JPRB,8.3727E-03_JPRB,&
&9.9335E-03_JPRB,1.1522E-02_JPRB,1.3097E-02_JPRB/)
KAO( :, 1, 2,13) = (/&
&1.1866E-03_JPRB,1.1005E-03_JPRB,1.0888E-03_JPRB,1.4004E-03_JPRB,1.7886E-03_JPRB,2.1767E-03_JPRB,&
&2.5570E-03_JPRB,2.9296E-03_JPRB,3.3601E-03_JPRB/)
KAO( :, 2, 2,13) = (/&
&1.4562E-03_JPRB,1.3635E-03_JPRB,1.4719E-03_JPRB,2.0169E-03_JPRB,2.6032E-03_JPRB,3.1819E-03_JPRB,&
&3.7488E-03_JPRB,4.3087E-03_JPRB,4.9192E-03_JPRB/)
KAO( :, 3, 2,13) = (/&
&1.8764E-03_JPRB,1.7361E-03_JPRB,1.9709E-03_JPRB,2.7595E-03_JPRB,3.5900E-03_JPRB,4.4194E-03_JPRB,&
&5.2979E-03_JPRB,6.0766E-03_JPRB,6.9371E-03_JPRB/)
KAO( :, 4, 2,13) = (/&
&2.4859E-03_JPRB,2.2733E-03_JPRB,2.5962E-03_JPRB,3.6933E-03_JPRB,4.8528E-03_JPRB,5.9853E-03_JPRB,&
&7.0801E-03_JPRB,8.2323E-03_JPRB,9.3999E-03_JPRB/)
KAO( :, 5, 2,13) = (/&
&3.2381E-03_JPRB,2.9580E-03_JPRB,3.3897E-03_JPRB,4.8434E-03_JPRB,6.3274E-03_JPRB,7.7660E-03_JPRB,&
&9.2016E-03_JPRB,1.0766E-02_JPRB,1.2382E-02_JPRB/)
KAO( :, 1, 3,13) = (/&
&1.0869E-03_JPRB,9.8978E-04_JPRB,9.6295E-04_JPRB,1.1603E-03_JPRB,1.4657E-03_JPRB,1.7785E-03_JPRB,&
&2.0850E-03_JPRB,2.3589E-03_JPRB,2.7295E-03_JPRB/)
KAO( :, 2, 3,13) = (/&
&1.2497E-03_JPRB,1.1652E-03_JPRB,1.2498E-03_JPRB,1.6617E-03_JPRB,2.1329E-03_JPRB,2.6212E-03_JPRB,&
&3.0709E-03_JPRB,3.5231E-03_JPRB,4.1120E-03_JPRB/)
KAO( :, 3, 3,13) = (/&
&1.5536E-03_JPRB,1.4627E-03_JPRB,1.6643E-03_JPRB,2.3266E-03_JPRB,3.0120E-03_JPRB,3.7022E-03_JPRB,&
&4.3567E-03_JPRB,5.0579E-03_JPRB,5.8139E-03_JPRB/)
KAO( :, 4, 3,13) = (/&
&2.0446E-03_JPRB,1.9153E-03_JPRB,2.2001E-03_JPRB,3.1214E-03_JPRB,4.0764E-03_JPRB,5.0190E-03_JPRB,&
&6.0061E-03_JPRB,6.9576E-03_JPRB,7.9493E-03_JPRB/)
KAO( :, 5, 3,13) = (/&
&2.6968E-03_JPRB,2.5178E-03_JPRB,2.9045E-03_JPRB,4.1585E-03_JPRB,5.4384E-03_JPRB,6.6732E-03_JPRB,&
&7.9956E-03_JPRB,9.1997E-03_JPRB,1.0739E-02_JPRB/)
KAO( :, 1, 4,13) = (/&
&1.0799E-03_JPRB,9.7556E-04_JPRB,8.9641E-04_JPRB,9.5375E-04_JPRB,1.1834E-03_JPRB,1.4206E-03_JPRB,&
&1.6456E-03_JPRB,1.8574E-03_JPRB,2.1783E-03_JPRB/)
KAO( :, 2, 4,13) = (/&
&1.1355E-03_JPRB,1.0374E-03_JPRB,1.0646E-03_JPRB,1.3628E-03_JPRB,1.7241E-03_JPRB,2.0900E-03_JPRB,&
&2.4594E-03_JPRB,2.8248E-03_JPRB,3.3135E-03_JPRB/)
KAO( :, 3, 4,13) = (/&
&1.2900E-03_JPRB,1.2405E-03_JPRB,1.3881E-03_JPRB,1.9129E-03_JPRB,2.4612E-03_JPRB,3.0202E-03_JPRB,&
&3.5514E-03_JPRB,4.1507E-03_JPRB,4.7512E-03_JPRB/)
KAO( :, 4, 4,13) = (/&
&1.6429E-03_JPRB,1.5804E-03_JPRB,1.8599E-03_JPRB,2.6280E-03_JPRB,3.3944E-03_JPRB,4.1721E-03_JPRB,&
&4.9786E-03_JPRB,5.7576E-03_JPRB,6.6384E-03_JPRB/)
KAO( :, 5, 4,13) = (/&
&2.1595E-03_JPRB,2.0705E-03_JPRB,2.4561E-03_JPRB,3.5243E-03_JPRB,4.6000E-03_JPRB,5.6864E-03_JPRB,&
&6.7238E-03_JPRB,7.7228E-03_JPRB,9.0563E-03_JPRB/)
KAO( :, 1, 5,13) = (/&
&1.1289E-03_JPRB,1.0122E-03_JPRB,9.1285E-04_JPRB,8.4241E-04_JPRB,9.2546E-04_JPRB,1.1068E-03_JPRB,&
&1.2785E-03_JPRB,1.4321E-03_JPRB,1.7133E-03_JPRB/)
KAO( :, 2, 5,13) = (/&
&1.1322E-03_JPRB,1.0283E-03_JPRB,9.7216E-04_JPRB,1.1030E-03_JPRB,1.3905E-03_JPRB,1.6648E-03_JPRB,&
&1.9659E-03_JPRB,2.2474E-03_JPRB,2.6825E-03_JPRB/)
KAO( :, 3, 5,13) = (/&
&1.1835E-03_JPRB,1.1059E-03_JPRB,1.1769E-03_JPRB,1.5659E-03_JPRB,1.9991E-03_JPRB,2.4574E-03_JPRB,&
&2.8892E-03_JPRB,3.3463E-03_JPRB,3.9939E-03_JPRB/)
KAO( :, 4, 5,13) = (/&
&1.3233E-03_JPRB,1.3123E-03_JPRB,1.5693E-03_JPRB,2.1884E-03_JPRB,2.8269E-03_JPRB,3.4574E-03_JPRB,&
&4.1167E-03_JPRB,4.7382E-03_JPRB,5.7495E-03_JPRB/)
KAO( :, 5, 5,13) = (/&
&1.7059E-03_JPRB,1.6691E-03_JPRB,2.0917E-03_JPRB,2.9965E-03_JPRB,3.8855E-03_JPRB,4.8207E-03_JPRB,&
&5.6559E-03_JPRB,6.5131E-03_JPRB,7.9790E-03_JPRB/)
KAO( :, 1, 6,13) = (/&
&1.2255E-03_JPRB,1.0879E-03_JPRB,9.6530E-04_JPRB,8.5617E-04_JPRB,7.6660E-04_JPRB,8.1723E-04_JPRB,&
&9.3534E-04_JPRB,1.0402E-03_JPRB,1.9062E-03_JPRB/)
KAO( :, 2, 6,13) = (/&
&1.1965E-03_JPRB,1.0719E-03_JPRB,9.9849E-04_JPRB,9.4121E-04_JPRB,1.0795E-03_JPRB,1.2813E-03_JPRB,&
&1.4997E-03_JPRB,1.7132E-03_JPRB,3.2547E-03_JPRB/)
KAO( :, 3, 6,13) = (/&
&1.1926E-03_JPRB,1.1043E-03_JPRB,1.0603E-03_JPRB,1.2688E-03_JPRB,1.5962E-03_JPRB,1.9526E-03_JPRB,&
&2.2912E-03_JPRB,2.6142E-03_JPRB,5.2095E-03_JPRB/)
KAO( :, 4, 6,13) = (/&
&1.2240E-03_JPRB,1.1777E-03_JPRB,1.3174E-03_JPRB,1.8087E-03_JPRB,2.3347E-03_JPRB,2.8437E-03_JPRB,&
&3.3597E-03_JPRB,3.8303E-03_JPRB,7.9481E-03_JPRB/)
KAO( :, 5, 6,13) = (/&
&1.3458E-03_JPRB,1.3554E-03_JPRB,1.7833E-03_JPRB,2.5412E-03_JPRB,3.2833E-03_JPRB,4.0389E-03_JPRB,&
&4.7385E-03_JPRB,5.4113E-03_JPRB,1.1516E-02_JPRB/)
KAO( :, 1, 7,13) = (/&
&1.3402E-03_JPRB,1.1742E-03_JPRB,1.0361E-03_JPRB,8.9910E-04_JPRB,7.6679E-04_JPRB,6.5368E-04_JPRB,&
&6.8075E-04_JPRB,4.6956E-04_JPRB,2.7722E-03_JPRB/)
KAO( :, 2, 7,13) = (/&
&1.3037E-03_JPRB,1.1622E-03_JPRB,1.0519E-03_JPRB,9.4323E-04_JPRB,8.7488E-04_JPRB,9.7401E-04_JPRB,&
&1.1211E-03_JPRB,1.2635E-03_JPRB,5.0027E-03_JPRB/)
KAO( :, 3, 7,13) = (/&
&1.2784E-03_JPRB,1.1532E-03_JPRB,1.0893E-03_JPRB,1.0694E-03_JPRB,1.2699E-03_JPRB,1.5175E-03_JPRB,&
&1.7746E-03_JPRB,2.0272E-03_JPRB,8.3555E-03_JPRB/)
KAO( :, 4, 7,13) = (/&
&1.2774E-03_JPRB,1.1979E-03_JPRB,1.1860E-03_JPRB,1.4785E-03_JPRB,1.8884E-03_JPRB,2.2924E-03_JPRB,&
&2.6858E-03_JPRB,3.0881E-03_JPRB,1.3125E-02_JPRB/)
KAO( :, 5, 7,13) = (/&
&1.2892E-03_JPRB,1.2565E-03_JPRB,1.5103E-03_JPRB,2.1215E-03_JPRB,2.7429E-03_JPRB,3.3579E-03_JPRB,&
&3.9536E-03_JPRB,4.4822E-03_JPRB,1.9541E-02_JPRB/)
KAO( :, 1, 8,13) = (/&
&1.4772E-03_JPRB,1.2923E-03_JPRB,1.1263E-03_JPRB,9.6270E-04_JPRB,8.0241E-04_JPRB,6.4872E-04_JPRB,&
&4.5811E-04_JPRB,2.1716E-07_JPRB,4.9636E-03_JPRB/)
KAO( :, 2, 8,13) = (/&
&1.4370E-03_JPRB,1.2729E-03_JPRB,1.1241E-03_JPRB,9.9655E-04_JPRB,8.5931E-04_JPRB,7.7387E-04_JPRB,&
&8.4353E-04_JPRB,8.7711E-04_JPRB,9.4321E-03_JPRB/)
KAO( :, 3, 8,13) = (/&
&1.4034E-03_JPRB,1.2585E-03_JPRB,1.1607E-03_JPRB,1.0510E-03_JPRB,1.0272E-03_JPRB,1.1868E-03_JPRB,&
&1.3711E-03_JPRB,1.5476E-03_JPRB,1.6446E-02_JPRB/)
KAO( :, 4, 8,13) = (/&
&1.3792E-03_JPRB,1.2775E-03_JPRB,1.2067E-03_JPRB,1.2391E-03_JPRB,1.5156E-03_JPRB,1.8221E-03_JPRB,&
&2.1295E-03_JPRB,2.4428E-03_JPRB,2.6678E-02_JPRB/)
KAO( :, 5, 8,13) = (/&
&1.3692E-03_JPRB,1.3040E-03_JPRB,1.3510E-03_JPRB,1.7655E-03_JPRB,2.2564E-03_JPRB,2.7486E-03_JPRB,&
&3.2245E-03_JPRB,3.6702E-03_JPRB,4.0890E-02_JPRB/)
KAO( :, 1, 9,13) = (/&
&1.6318E-03_JPRB,1.4281E-03_JPRB,1.2324E-03_JPRB,1.0452E-03_JPRB,8.5200E-04_JPRB,6.6304E-04_JPRB,&
&1.2309E-05_JPRB,1.5379E-07_JPRB,1.6381E-02_JPRB/)
KAO( :, 2, 9,13) = (/&
&1.5875E-03_JPRB,1.3936E-03_JPRB,1.2247E-03_JPRB,1.0563E-03_JPRB,9.0066E-04_JPRB,7.3338E-04_JPRB,&
&6.0228E-04_JPRB,1.0871E-04_JPRB,3.2932E-02_JPRB/)
KAO( :, 3, 9,13) = (/&
&1.5482E-03_JPRB,1.3786E-03_JPRB,1.2438E-03_JPRB,1.1136E-03_JPRB,9.6991E-04_JPRB,9.4000E-04_JPRB,&
&1.0591E-03_JPRB,1.1303E-03_JPRB,6.0073E-02_JPRB/)
KAO( :, 4, 9,13) = (/&
&1.5167E-03_JPRB,1.3746E-03_JPRB,1.2857E-03_JPRB,1.1928E-03_JPRB,1.2413E-03_JPRB,1.4696E-03_JPRB,&
&1.6946E-03_JPRB,1.9089E-03_JPRB,1.0132E-01_JPRB/)
KAO( :, 5, 9,13) = (/&
&1.4899E-03_JPRB,1.4080E-03_JPRB,1.3636E-03_JPRB,1.4825E-03_JPRB,1.8628E-03_JPRB,2.2533E-03_JPRB,&
&2.6127E-03_JPRB,2.9482E-03_JPRB,1.5979E-01_JPRB/)
KAO( :, 1,10,13) = (/&
&1.8020E-03_JPRB,1.5774E-03_JPRB,1.3520E-03_JPRB,1.1382E-03_JPRB,9.2570E-04_JPRB,6.9265E-04_JPRB,&
&1.3740E-07_JPRB,1.3289E-07_JPRB,6.3524E-02_JPRB/)
KAO( :, 2,10,13) = (/&
&1.7549E-03_JPRB,1.5358E-03_JPRB,1.3388E-03_JPRB,1.1389E-03_JPRB,9.5013E-04_JPRB,7.6352E-04_JPRB,&
&2.9725E-04_JPRB,1.5747E-07_JPRB,1.3432E-01_JPRB/)
KAO( :, 3,10,13) = (/&
&1.7152E-03_JPRB,1.5184E-03_JPRB,1.3412E-03_JPRB,1.1838E-03_JPRB,1.0217E-03_JPRB,8.6702E-04_JPRB,&
&8.3836E-04_JPRB,6.8845E-04_JPRB,2.5555E-01_JPRB/)
KAO( :, 4,10,13) = (/&
&1.6812E-03_JPRB,1.5047E-03_JPRB,1.3857E-03_JPRB,1.2506E-03_JPRB,1.1577E-03_JPRB,1.2249E-03_JPRB,&
&1.4008E-03_JPRB,1.5238E-03_JPRB,4.4499E-01_JPRB/)
KAO( :, 5,10,13) = (/&
&1.6497E-03_JPRB,1.5369E-03_JPRB,1.4416E-03_JPRB,1.4073E-03_JPRB,1.5858E-03_JPRB,1.9083E-03_JPRB,&
&2.1930E-03_JPRB,2.4338E-03_JPRB,7.2126E-01_JPRB/)
KAO( :, 1,11,13) = (/&
&1.9883E-03_JPRB,1.7404E-03_JPRB,1.4929E-03_JPRB,1.2571E-03_JPRB,1.0189E-03_JPRB,7.6574E-04_JPRB,&
&1.2245E-07_JPRB,1.1939E-07_JPRB,1.2338E-01_JPRB/)
KAO( :, 2,11,13) = (/&
&1.9390E-03_JPRB,1.6974E-03_JPRB,1.4774E-03_JPRB,1.2577E-03_JPRB,1.0438E-03_JPRB,8.3574E-04_JPRB,&
&2.2761E-04_JPRB,1.3870E-07_JPRB,2.6041E-01_JPRB/)
KAO( :, 3,11,13) = (/&
&1.9012E-03_JPRB,1.6811E-03_JPRB,1.4837E-03_JPRB,1.3022E-03_JPRB,1.1118E-03_JPRB,9.5270E-04_JPRB,&
&8.5092E-04_JPRB,5.4921E-04_JPRB,4.9292E-01_JPRB/)
KAO( :, 4,11,13) = (/&
&1.8676E-03_JPRB,1.6686E-03_JPRB,1.5247E-03_JPRB,1.3663E-03_JPRB,1.2686E-03_JPRB,1.2743E-03_JPRB,&
&1.4286E-03_JPRB,1.5277E-03_JPRB,8.5618E-01_JPRB/)
KAO( :, 5,11,13) = (/&
&1.8327E-03_JPRB,1.6976E-03_JPRB,1.5788E-03_JPRB,1.5380E-03_JPRB,1.6440E-03_JPRB,1.9550E-03_JPRB,&
&2.2595E-03_JPRB,2.4555E-03_JPRB,1.3826E+00_JPRB/)
KAO( :, 1,12,13) = (/&
&2.2187E-03_JPRB,1.9406E-03_JPRB,1.6640E-03_JPRB,1.4003E-03_JPRB,1.1350E-03_JPRB,8.4971E-04_JPRB,&
&1.4328E-05_JPRB,1.0909E-07_JPRB,1.7650E-01_JPRB/)
KAO( :, 2,12,13) = (/&
&2.1703E-03_JPRB,1.8998E-03_JPRB,1.6482E-03_JPRB,1.4040E-03_JPRB,1.1602E-03_JPRB,9.1881E-04_JPRB,&
&5.8608E-04_JPRB,1.2488E-07_JPRB,3.7061E-01_JPRB/)
KAO( :, 3,12,13) = (/&
&2.1329E-03_JPRB,1.8834E-03_JPRB,1.6576E-03_JPRB,1.4426E-03_JPRB,1.2188E-03_JPRB,1.0435E-03_JPRB,&
&9.0113E-04_JPRB,6.0140E-04_JPRB,6.9805E-01_JPRB/)
KAO( :, 4,12,13) = (/&
&2.0986E-03_JPRB,1.8697E-03_JPRB,1.6880E-03_JPRB,1.4960E-03_JPRB,1.3858E-03_JPRB,1.3370E-03_JPRB,&
&1.4776E-03_JPRB,1.5577E-03_JPRB,1.2104E+00_JPRB/)
KAO( :, 5,12,13) = (/&
&2.0637E-03_JPRB,1.8889E-03_JPRB,1.7335E-03_JPRB,1.6736E-03_JPRB,1.7272E-03_JPRB,2.0047E-03_JPRB,&
&2.3234E-03_JPRB,2.5266E-03_JPRB,1.9488E+00_JPRB/)
KAO( :, 1,13,13) = (/&
&2.5214E-03_JPRB,2.2065E-03_JPRB,1.8921E-03_JPRB,1.5892E-03_JPRB,1.2848E-03_JPRB,9.6635E-04_JPRB,&
&1.4011E-05_JPRB,9.2652E-08_JPRB,1.9891E-01_JPRB/)
KAO( :, 2,13,13) = (/&
&2.4696E-03_JPRB,2.1633E-03_JPRB,1.8707E-03_JPRB,1.5871E-03_JPRB,1.3039E-03_JPRB,1.0191E-03_JPRB,&
&7.2224E-04_JPRB,1.1771E-07_JPRB,4.1557E-01_JPRB/)
KAO( :, 3,13,13) = (/&
&2.4301E-03_JPRB,2.1428E-03_JPRB,1.8727E-03_JPRB,1.6140E-03_JPRB,1.3467E-03_JPRB,1.1319E-03_JPRB,&
&9.6477E-04_JPRB,7.6672E-04_JPRB,7.8045E-01_JPRB/)
KAO( :, 4,13,13) = (/&
&2.3936E-03_JPRB,2.1221E-03_JPRB,1.8926E-03_JPRB,1.6520E-03_JPRB,1.5047E-03_JPRB,1.4110E-03_JPRB,&
&1.5144E-03_JPRB,1.6138E-03_JPRB,1.3452E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&2.3541E-03_JPRB,2.1248E-03_JPRB,1.9211E-03_JPRB,1.8214E-03_JPRB,1.8209E-03_JPRB,2.0454E-03_JPRB,&
&2.3767E-03_JPRB,2.6027E-03_JPRB,2.1609E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&1.4077E-03_JPRB,1.3543E-03_JPRB,2.0015E-03_JPRB,2.9052E-03_JPRB,3.8062E-03_JPRB,4.7033E-03_JPRB,&
&5.5027E-03_JPRB,6.3534E-03_JPRB,7.2447E-03_JPRB/)
KAO( :, 2, 1,14) = (/&
&1.7458E-03_JPRB,1.7470E-03_JPRB,2.6822E-03_JPRB,3.8935E-03_JPRB,5.1049E-03_JPRB,6.3777E-03_JPRB,&
&7.5886E-03_JPRB,8.9435E-03_JPRB,1.0377E-02_JPRB/)
KAO( :, 3, 1,14) = (/&
&2.2077E-03_JPRB,2.2614E-03_JPRB,3.6964E-03_JPRB,5.3773E-03_JPRB,7.0539E-03_JPRB,8.7220E-03_JPRB,&
&1.0257E-02_JPRB,1.2410E-02_JPRB,1.4154E-02_JPRB/)
KAO( :, 4, 1,14) = (/&
&2.8109E-03_JPRB,2.9075E-03_JPRB,4.9134E-03_JPRB,7.1686E-03_JPRB,9.5162E-03_JPRB,1.1788E-02_JPRB,&
&1.3767E-02_JPRB,1.5840E-02_JPRB,1.8057E-02_JPRB/)
KAO( :, 5, 1,14) = (/&
&3.6086E-03_JPRB,3.7240E-03_JPRB,6.4216E-03_JPRB,9.3840E-03_JPRB,1.2343E-02_JPRB,1.5071E-02_JPRB,&
&1.7936E-02_JPRB,2.0469E-02_JPRB,2.3091E-02_JPRB/)
KAO( :, 1, 2,14) = (/&
&1.3294E-03_JPRB,1.2597E-03_JPRB,1.6974E-03_JPRB,2.4370E-03_JPRB,3.1928E-03_JPRB,3.9456E-03_JPRB,&
&4.9620E-03_JPRB,5.6067E-03_JPRB,6.6116E-03_JPRB/)
KAO( :, 2, 2,14) = (/&
&1.6318E-03_JPRB,1.6184E-03_JPRB,2.4692E-03_JPRB,3.6012E-03_JPRB,4.7302E-03_JPRB,5.7659E-03_JPRB,&
&6.8491E-03_JPRB,8.1205E-03_JPRB,8.9947E-03_JPRB/)
KAO( :, 3, 2,14) = (/&
&2.0588E-03_JPRB,2.1063E-03_JPRB,3.4156E-03_JPRB,4.9986E-03_JPRB,6.5782E-03_JPRB,8.1429E-03_JPRB,&
&9.7017E-03_JPRB,1.0879E-02_JPRB,1.2701E-02_JPRB/)
KAO( :, 4, 2,14) = (/&
&2.6403E-03_JPRB,2.6941E-03_JPRB,4.6292E-03_JPRB,6.7785E-03_JPRB,8.9613E-03_JPRB,1.1099E-02_JPRB,&
&1.3055E-02_JPRB,1.4808E-02_JPRB,1.7360E-02_JPRB/)
KAO( :, 5, 2,14) = (/&
&3.4097E-03_JPRB,3.4754E-03_JPRB,6.1509E-03_JPRB,9.0470E-03_JPRB,1.1928E-02_JPRB,1.4499E-02_JPRB,&
&1.7101E-02_JPRB,1.9409E-02_JPRB,2.2968E-02_JPRB/)
KAO( :, 1, 3,14) = (/&
&1.2102E-03_JPRB,1.1138E-03_JPRB,1.3857E-03_JPRB,2.0244E-03_JPRB,2.6529E-03_JPRB,3.2119E-03_JPRB,&
&4.0399E-03_JPRB,4.4246E-03_JPRB,5.1581E-03_JPRB/)
KAO( :, 2, 3,14) = (/&
&1.4090E-03_JPRB,1.3841E-03_JPRB,2.0941E-03_JPRB,3.0584E-03_JPRB,4.0208E-03_JPRB,4.9852E-03_JPRB,&
&5.9175E-03_JPRB,6.7182E-03_JPRB,7.9412E-03_JPRB/)
KAO( :, 3, 3,14) = (/&
&1.7427E-03_JPRB,1.7765E-03_JPRB,2.9090E-03_JPRB,4.4193E-03_JPRB,5.8208E-03_JPRB,7.2086E-03_JPRB,&
&8.4753E-03_JPRB,9.3954E-03_JPRB,1.1366E-02_JPRB/)
KAO( :, 4, 3,14) = (/&
&2.2157E-03_JPRB,2.2613E-03_JPRB,3.9916E-03_JPRB,5.8630E-03_JPRB,8.0161E-03_JPRB,9.9398E-03_JPRB,&
&1.1828E-02_JPRB,1.3094E-02_JPRB,1.5315E-02_JPRB/)
KAO( :, 5, 3,14) = (/&
&2.8879E-03_JPRB,2.9466E-03_JPRB,5.4167E-03_JPRB,7.9578E-03_JPRB,1.0502E-02_JPRB,1.2821E-02_JPRB,&
&1.5472E-02_JPRB,1.7483E-02_JPRB,2.0768E-02_JPRB/)
KAO( :, 1, 4,14) = (/&
&1.1727E-03_JPRB,1.0568E-03_JPRB,1.1437E-03_JPRB,1.6336E-03_JPRB,2.1314E-03_JPRB,2.5848E-03_JPRB,&
&3.0242E-03_JPRB,3.4499E-03_JPRB,4.1004E-03_JPRB/)
KAO( :, 2, 4,14) = (/&
&1.2525E-03_JPRB,1.1704E-03_JPRB,1.6924E-03_JPRB,2.4669E-03_JPRB,3.2745E-03_JPRB,3.9503E-03_JPRB,&
&4.8080E-03_JPRB,5.4438E-03_JPRB,6.5186E-03_JPRB/)
KAO( :, 3, 4,14) = (/&
&1.4517E-03_JPRB,1.4687E-03_JPRB,2.4478E-03_JPRB,3.6499E-03_JPRB,4.8038E-03_JPRB,6.0561E-03_JPRB,&
&7.1091E-03_JPRB,8.0698E-03_JPRB,9.5998E-03_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.8147E-03_JPRB,1.9649E-03_JPRB,3.5509E-03_JPRB,5.2270E-03_JPRB,6.8077E-03_JPRB,8.4354E-03_JPRB,&
&1.0206E-02_JPRB,1.1463E-02_JPRB,1.3354E-02_JPRB/)
KAO( :, 5, 4,14) = (/&
&2.3595E-03_JPRB,2.5550E-03_JPRB,4.7325E-03_JPRB,6.9980E-03_JPRB,9.2811E-03_JPRB,1.1690E-02_JPRB,&
&1.3662E-02_JPRB,1.5386E-02_JPRB,1.8463E-02_JPRB/)
KAO( :, 1, 5,14) = (/&
&1.2458E-03_JPRB,1.1157E-03_JPRB,1.0306E-03_JPRB,1.3033E-03_JPRB,1.6734E-03_JPRB,2.0057E-03_JPRB,&
&2.3259E-03_JPRB,2.6388E-03_JPRB,3.1846E-03_JPRB/)
KAO( :, 2, 5,14) = (/&
&1.2388E-03_JPRB,1.1282E-03_JPRB,1.3991E-03_JPRB,2.0036E-03_JPRB,2.6425E-03_JPRB,3.1687E-03_JPRB,&
&3.8762E-03_JPRB,4.3488E-03_JPRB,5.2301E-03_JPRB/)
KAO( :, 3, 5,14) = (/&
&1.2913E-03_JPRB,1.2589E-03_JPRB,2.0814E-03_JPRB,3.0197E-03_JPRB,3.9667E-03_JPRB,4.9958E-03_JPRB,&
&5.9133E-03_JPRB,6.6574E-03_JPRB,8.0153E-03_JPRB/)
KAO( :, 4, 5,14) = (/&
&1.4963E-03_JPRB,1.6907E-03_JPRB,3.0309E-03_JPRB,4.4615E-03_JPRB,5.8606E-03_JPRB,7.1898E-03_JPRB,&
&8.6483E-03_JPRB,9.7418E-03_JPRB,1.1669E-02_JPRB/)
KAO( :, 5, 5,14) = (/&
&1.8886E-03_JPRB,2.2503E-03_JPRB,4.1688E-03_JPRB,6.1333E-03_JPRB,8.1604E-03_JPRB,1.0200E-02_JPRB,&
&1.2063E-02_JPRB,1.3620E-02_JPRB,1.6367E-02_JPRB/)
KAO( :, 1, 6,14) = (/&
&1.3667E-03_JPRB,1.2087E-03_JPRB,1.0726E-03_JPRB,1.0607E-03_JPRB,1.2821E-03_JPRB,1.5260E-03_JPRB,&
&1.8008E-03_JPRB,1.9547E-03_JPRB,2.5327E-03_JPRB/)
KAO( :, 2, 6,14) = (/&
&1.3345E-03_JPRB,1.2078E-03_JPRB,1.2022E-03_JPRB,1.6068E-03_JPRB,2.0999E-03_JPRB,2.5469E-03_JPRB,&
&3.0216E-03_JPRB,3.3465E-03_JPRB,4.2698E-03_JPRB/)
KAO( :, 3, 6,14) = (/&
&1.3246E-03_JPRB,1.2185E-03_JPRB,1.7375E-03_JPRB,2.5142E-03_JPRB,3.2318E-03_JPRB,4.0369E-03_JPRB,&
&4.7556E-03_JPRB,5.3249E-03_JPRB,6.8388E-03_JPRB/)
KAO( :, 4, 6,14) = (/&
&1.3486E-03_JPRB,1.4645E-03_JPRB,2.5454E-03_JPRB,3.7331E-03_JPRB,4.8424E-03_JPRB,6.0309E-03_JPRB,&
&7.1539E-03_JPRB,8.1418E-03_JPRB,1.0356E-02_JPRB/)
KAO( :, 5, 6,14) = (/&
&1.5159E-03_JPRB,1.9586E-03_JPRB,3.6257E-03_JPRB,5.3066E-03_JPRB,6.9540E-03_JPRB,8.6820E-03_JPRB,&
&1.0231E-02_JPRB,1.1546E-02_JPRB,1.5077E-02_JPRB/)
KAO( :, 1, 7,14) = (/&
&1.5156E-03_JPRB,1.3262E-03_JPRB,1.1714E-03_JPRB,1.0190E-03_JPRB,1.0169E-03_JPRB,1.1666E-03_JPRB,&
&1.3423E-03_JPRB,1.3981E-03_JPRB,3.1910E-03_JPRB/)
KAO( :, 2, 7,14) = (/&
&1.4765E-03_JPRB,1.3249E-03_JPRB,1.1925E-03_JPRB,1.3147E-03_JPRB,1.6557E-03_JPRB,1.9990E-03_JPRB,&
&2.2925E-03_JPRB,2.5530E-03_JPRB,5.7452E-03_JPRB/)
KAO( :, 3, 7,14) = (/&
&1.4370E-03_JPRB,1.3162E-03_JPRB,1.4936E-03_JPRB,2.0652E-03_JPRB,2.6453E-03_JPRB,3.2054E-03_JPRB,&
&3.7731E-03_JPRB,4.2042E-03_JPRB,9.6110E-03_JPRB/)
KAO( :, 4, 7,14) = (/&
&1.4149E-03_JPRB,1.3977E-03_JPRB,2.1475E-03_JPRB,3.1203E-03_JPRB,4.0198E-03_JPRB,4.9787E-03_JPRB,&
&5.7945E-03_JPRB,6.6068E-03_JPRB,1.5108E-02_JPRB/)
KAO( :, 5, 7,14) = (/&
&1.4374E-03_JPRB,1.7222E-03_JPRB,3.0905E-03_JPRB,4.5057E-03_JPRB,5.8428E-03_JPRB,7.2095E-03_JPRB,&
&8.5374E-03_JPRB,9.6315E-03_JPRB,2.2589E-02_JPRB/)
KAO( :, 1, 8,14) = (/&
&1.6998E-03_JPRB,1.4847E-03_JPRB,1.3004E-03_JPRB,1.1133E-03_JPRB,9.4349E-04_JPRB,9.0420E-04_JPRB,&
&1.0045E-03_JPRB,4.3482E-04_JPRB,5.8016E-03_JPRB/)
KAO( :, 2, 8,14) = (/&
&1.6532E-03_JPRB,1.4674E-03_JPRB,1.3041E-03_JPRB,1.2025E-03_JPRB,1.3140E-03_JPRB,1.5672E-03_JPRB,&
&1.7686E-03_JPRB,1.9237E-03_JPRB,1.1052E-02_JPRB/)
KAO( :, 3, 8,14) = (/&
&1.6074E-03_JPRB,1.4616E-03_JPRB,1.4143E-03_JPRB,1.6802E-03_JPRB,2.1261E-03_JPRB,2.5596E-03_JPRB,&
&3.0033E-03_JPRB,3.3007E-03_JPRB,1.9324E-02_JPRB/)
KAO( :, 4, 8,14) = (/&
&1.5686E-03_JPRB,1.4776E-03_JPRB,1.8215E-03_JPRB,2.5548E-03_JPRB,3.2874E-03_JPRB,4.0303E-03_JPRB,&
&4.7235E-03_JPRB,5.2596E-03_JPRB,3.1553E-02_JPRB/)
KAO( :, 5, 8,14) = (/&
&1.5375E-03_JPRB,1.6349E-03_JPRB,2.6125E-03_JPRB,3.7580E-03_JPRB,4.8839E-03_JPRB,6.0119E-03_JPRB,&
&7.1085E-03_JPRB,8.0648E-03_JPRB,4.8625E-02_JPRB/)
KAO( :, 1, 9,14) = (/&
&1.9224E-03_JPRB,1.6818E-03_JPRB,1.4431E-03_JPRB,1.2356E-03_JPRB,1.0226E-03_JPRB,8.1041E-04_JPRB,&
&6.6192E-04_JPRB,1.6289E-07_JPRB,1.9855E-02_JPRB/)
KAO( :, 2, 9,14) = (/&
&1.8714E-03_JPRB,1.6372E-03_JPRB,1.4546E-03_JPRB,1.2624E-03_JPRB,1.1376E-03_JPRB,1.2029E-03_JPRB,&
&1.3478E-03_JPRB,1.4009E-03_JPRB,4.0030E-02_JPRB/)
KAO( :, 3, 9,14) = (/&
&1.8227E-03_JPRB,1.6409E-03_JPRB,1.4856E-03_JPRB,1.4717E-03_JPRB,1.6810E-03_JPRB,2.0286E-03_JPRB,&
&2.3381E-03_JPRB,2.5517E-03_JPRB,7.3381E-02_JPRB/)
KAO( :, 4, 9,14) = (/&
&1.7776E-03_JPRB,1.6302E-03_JPRB,1.6842E-03_JPRB,2.0805E-03_JPRB,2.6540E-03_JPRB,3.2313E-03_JPRB,&
&3.7806E-03_JPRB,4.1994E-03_JPRB,1.2455E-01_JPRB/)
KAO( :, 5, 9,14) = (/&
&1.7367E-03_JPRB,1.7061E-03_JPRB,2.1848E-03_JPRB,3.1013E-03_JPRB,4.0216E-03_JPRB,4.9873E-03_JPRB,&
&5.8671E-03_JPRB,6.6087E-03_JPRB,1.9836E-01_JPRB/)
KAO( :, 1,10,14) = (/&
&2.1700E-03_JPRB,1.8991E-03_JPRB,1.6269E-03_JPRB,1.3797E-03_JPRB,1.1299E-03_JPRB,8.7387E-04_JPRB,&
&1.3980E-07_JPRB,1.2659E-07_JPRB,7.9784E-02_JPRB/)
KAO( :, 2,10,14) = (/&
&2.1212E-03_JPRB,1.8542E-03_JPRB,1.6327E-03_JPRB,1.4005E-03_JPRB,1.1807E-03_JPRB,1.0294E-03_JPRB,&
&1.0221E-03_JPRB,1.9929E-04_JPRB,1.6978E-01_JPRB/)
KAO( :, 3,10,14) = (/&
&2.0702E-03_JPRB,1.8475E-03_JPRB,1.6421E-03_JPRB,1.4813E-03_JPRB,1.4506E-03_JPRB,1.6271E-03_JPRB,&
&1.8528E-03_JPRB,1.9874E-03_JPRB,3.2534E-01_JPRB/)
KAO( :, 4,10,14) = (/&
&2.0197E-03_JPRB,1.8363E-03_JPRB,1.7391E-03_JPRB,1.8390E-03_JPRB,2.2028E-03_JPRB,2.6538E-03_JPRB,&
&3.1240E-03_JPRB,3.3958E-03_JPRB,5.7201E-01_JPRB/)
KAO( :, 5,10,14) = (/&
&1.9722E-03_JPRB,1.8724E-03_JPRB,2.0258E-03_JPRB,2.6203E-03_JPRB,3.3709E-03_JPRB,4.1714E-03_JPRB,&
&4.8976E-03_JPRB,5.4947E-03_JPRB,9.3618E-01_JPRB/)
KAO( :, 1,11,14) = (/&
&2.4346E-03_JPRB,2.1262E-03_JPRB,1.8242E-03_JPRB,1.5461E-03_JPRB,1.2663E-03_JPRB,9.7971E-04_JPRB,&
&1.2672E-07_JPRB,1.1257E-07_JPRB,1.6191E-01_JPRB/)
KAO( :, 2,11,14) = (/&
&2.3800E-03_JPRB,2.0803E-03_JPRB,1.8321E-03_JPRB,1.5714E-03_JPRB,1.3247E-03_JPRB,1.1173E-03_JPRB,&
&1.0133E-03_JPRB,1.0538E-04_JPRB,3.4424E-01_JPRB/)
KAO( :, 3,11,14) = (/&
&2.3211E-03_JPRB,2.0734E-03_JPRB,1.8393E-03_JPRB,1.6589E-03_JPRB,1.5627E-03_JPRB,1.6631E-03_JPRB,&
&1.8852E-03_JPRB,2.0216E-03_JPRB,6.6076E-01_JPRB/)
KAO( :, 4,11,14) = (/&
&2.2623E-03_JPRB,2.0579E-03_JPRB,1.9437E-03_JPRB,1.9604E-03_JPRB,2.2434E-03_JPRB,2.7165E-03_JPRB,&
&3.1823E-03_JPRB,3.4732E-03_JPRB,1.1622E+00_JPRB/)
KAO( :, 5,11,14) = (/&
&2.2095E-03_JPRB,2.1020E-03_JPRB,2.1745E-03_JPRB,2.6686E-03_JPRB,3.4370E-03_JPRB,4.2001E-03_JPRB,&
&4.9598E-03_JPRB,5.6011E-03_JPRB,1.8980E+00_JPRB/)
KAO( :, 1,12,14) = (/&
&2.7322E-03_JPRB,2.3881E-03_JPRB,2.0484E-03_JPRB,1.7387E-03_JPRB,1.4199E-03_JPRB,1.1012E-03_JPRB,&
&1.1269E-07_JPRB,1.0126E-07_JPRB,2.4431E-01_JPRB/)
KAO( :, 2,12,14) = (/&
&2.6690E-03_JPRB,2.3367E-03_JPRB,2.0556E-03_JPRB,1.7563E-03_JPRB,1.4836E-03_JPRB,1.2255E-03_JPRB,&
&1.0602E-03_JPRB,2.2342E-04_JPRB,5.2005E-01_JPRB/)
KAO( :, 3,12,14) = (/&
&2.6024E-03_JPRB,2.3216E-03_JPRB,2.0574E-03_JPRB,1.8575E-03_JPRB,1.6967E-03_JPRB,1.7241E-03_JPRB,&
&1.9458E-03_JPRB,2.1132E-03_JPRB,9.9525E-01_JPRB/)
KAO( :, 4,12,14) = (/&
&2.5362E-03_JPRB,2.2963E-03_JPRB,2.1666E-03_JPRB,2.1029E-03_JPRB,2.2976E-03_JPRB,2.7702E-03_JPRB,&
&3.2192E-03_JPRB,3.5953E-03_JPRB,1.7434E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&2.4736E-03_JPRB,2.3442E-03_JPRB,2.3511E-03_JPRB,2.7323E-03_JPRB,3.5045E-03_JPRB,4.2744E-03_JPRB,&
&5.0574E-03_JPRB,5.7337E-03_JPRB,2.8511E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&3.0694E-03_JPRB,2.6858E-03_JPRB,2.3020E-03_JPRB,1.9523E-03_JPRB,1.5893E-03_JPRB,1.2280E-03_JPRB,&
&9.6824E-05_JPRB,9.3571E-08_JPRB,2.9420E-01_JPRB/)
KAO( :, 2,13,14) = (/&
&2.9959E-03_JPRB,2.6225E-03_JPRB,2.2984E-03_JPRB,1.9588E-03_JPRB,1.6492E-03_JPRB,1.3537E-03_JPRB,&
&1.1186E-03_JPRB,4.7180E-04_JPRB,6.2570E-01_JPRB/)
KAO( :, 3,13,14) = (/&
&2.9125E-03_JPRB,2.5931E-03_JPRB,2.2966E-03_JPRB,2.0585E-03_JPRB,1.8442E-03_JPRB,1.7986E-03_JPRB,&
&1.9858E-03_JPRB,2.1644E-03_JPRB,1.1929E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&2.8338E-03_JPRB,2.5576E-03_JPRB,2.3960E-03_JPRB,2.2668E-03_JPRB,2.3808E-03_JPRB,2.8162E-03_JPRB,&
&3.2861E-03_JPRB,3.6781E-03_JPRB,2.0900E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&2.7615E-03_JPRB,2.6036E-03_JPRB,2.5577E-03_JPRB,2.8390E-03_JPRB,3.5800E-03_JPRB,4.3621E-03_JPRB,&
&5.1422E-03_JPRB,5.8469E-03_JPRB,3.4082E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&1.5335E-03_JPRB,1.9324E-03_JPRB,3.7679E-03_JPRB,5.5453E-03_JPRB,7.3003E-03_JPRB,9.0183E-03_JPRB,&
&1.0616E-02_JPRB,1.1802E-02_JPRB,1.3402E-02_JPRB/)
KAO( :, 2, 1,15) = (/&
&1.8833E-03_JPRB,2.7655E-03_JPRB,5.2889E-03_JPRB,7.8002E-03_JPRB,1.0284E-02_JPRB,1.2663E-02_JPRB,&
&1.4949E-02_JPRB,1.7186E-02_JPRB,1.9451E-02_JPRB/)
KAO( :, 3, 1,15) = (/&
&2.3483E-03_JPRB,3.8414E-03_JPRB,7.3773E-03_JPRB,1.0888E-02_JPRB,1.4361E-02_JPRB,1.7765E-02_JPRB,&
&2.0815E-02_JPRB,2.3917E-02_JPRB,2.7184E-02_JPRB/)
KAO( :, 4, 1,15) = (/&
&2.9416E-03_JPRB,5.1566E-03_JPRB,9.9228E-03_JPRB,1.4661E-02_JPRB,1.9210E-02_JPRB,2.3760E-02_JPRB,&
&2.8113E-02_JPRB,3.1154E-02_JPRB,3.5404E-02_JPRB/)
KAO( :, 5, 1,15) = (/&
&3.6966E-03_JPRB,6.6653E-03_JPRB,1.2941E-02_JPRB,1.9171E-02_JPRB,2.5316E-02_JPRB,3.1127E-02_JPRB,&
&3.6787E-02_JPRB,4.1016E-02_JPRB,4.6262E-02_JPRB/)
KAO( :, 1, 2,15) = (/&
&1.4383E-03_JPRB,1.8910E-03_JPRB,3.6349E-03_JPRB,5.3031E-03_JPRB,6.9932E-03_JPRB,8.6450E-03_JPRB,&
&1.0512E-02_JPRB,1.1619E-02_JPRB,1.3810E-02_JPRB/)
KAO( :, 2, 2,15) = (/&
&1.7711E-03_JPRB,2.7662E-03_JPRB,5.3277E-03_JPRB,7.8716E-03_JPRB,1.0388E-02_JPRB,1.2798E-02_JPRB,&
&1.4898E-02_JPRB,1.7232E-02_JPRB,1.9744E-02_JPRB/)
KAO( :, 3, 2,15) = (/&
&2.2091E-03_JPRB,3.9249E-03_JPRB,7.5049E-03_JPRB,1.1104E-02_JPRB,1.4661E-02_JPRB,1.8139E-02_JPRB,&
&2.1328E-02_JPRB,2.3602E-02_JPRB,2.7985E-02_JPRB/)
KAO( :, 4, 2,15) = (/&
&2.7705E-03_JPRB,5.2948E-03_JPRB,1.0279E-02_JPRB,1.5231E-02_JPRB,2.0000E-02_JPRB,2.4763E-02_JPRB,&
&2.9040E-02_JPRB,3.2255E-02_JPRB,3.8158E-02_JPRB/)
KAO( :, 5, 2,15) = (/&
&3.5089E-03_JPRB,6.9573E-03_JPRB,1.3524E-02_JPRB,2.0020E-02_JPRB,2.6474E-02_JPRB,3.2706E-02_JPRB,&
&3.8152E-02_JPRB,4.2439E-02_JPRB,5.0508E-02_JPRB/)
KAO( :, 1, 3,15) = (/&
&1.2705E-03_JPRB,1.6880E-03_JPRB,3.2165E-03_JPRB,4.7906E-03_JPRB,6.3186E-03_JPRB,7.6460E-03_JPRB,&
&9.3643E-03_JPRB,1.0229E-02_JPRB,1.2458E-02_JPRB/)
KAO( :, 2, 3,15) = (/&
&1.5436E-03_JPRB,2.5438E-03_JPRB,4.9323E-03_JPRB,7.3010E-03_JPRB,9.6387E-03_JPRB,1.1841E-02_JPRB,&
&1.4163E-02_JPRB,1.5548E-02_JPRB,1.9155E-02_JPRB/)
KAO( :, 3, 3,15) = (/&
&1.9176E-03_JPRB,3.6434E-03_JPRB,6.9853E-03_JPRB,1.0590E-02_JPRB,1.3995E-02_JPRB,1.7311E-02_JPRB,&
&2.0232E-02_JPRB,2.1858E-02_JPRB,2.7487E-02_JPRB/)
KAO( :, 4, 3,15) = (/&
&2.3869E-03_JPRB,4.9269E-03_JPRB,9.6201E-03_JPRB,1.4277E-02_JPRB,1.9500E-02_JPRB,2.4127E-02_JPRB,&
&2.8236E-02_JPRB,3.0501E-02_JPRB,3.7416E-02_JPRB/)
KAO( :, 5, 3,15) = (/&
&2.9972E-03_JPRB,6.6065E-03_JPRB,1.2887E-02_JPRB,1.9158E-02_JPRB,2.5345E-02_JPRB,3.1167E-02_JPRB,&
&3.7358E-02_JPRB,4.1161E-02_JPRB,5.0258E-02_JPRB/)
KAO( :, 1, 4,15) = (/&
&1.2393E-03_JPRB,1.4291E-03_JPRB,2.7934E-03_JPRB,4.1582E-03_JPRB,5.4860E-03_JPRB,6.6271E-03_JPRB,&
&7.7456E-03_JPRB,8.5638E-03_JPRB,1.0713E-02_JPRB/)
KAO( :, 2, 4,15) = (/&
&1.3400E-03_JPRB,2.1964E-03_JPRB,4.2752E-03_JPRB,6.3365E-03_JPRB,8.4061E-03_JPRB,1.0279E-02_JPRB,&
&1.2357E-02_JPRB,1.3474E-02_JPRB,1.7008E-02_JPRB/)
KAO( :, 3, 4,15) = (/&
&1.6349E-03_JPRB,3.2436E-03_JPRB,6.2304E-03_JPRB,9.4103E-03_JPRB,1.2432E-02_JPRB,1.5539E-02_JPRB,&
&1.8108E-02_JPRB,2.0011E-02_JPRB,2.5265E-02_JPRB/)
KAO( :, 4, 4,15) = (/&
&2.0292E-03_JPRB,4.6522E-03_JPRB,9.1141E-03_JPRB,1.3542E-02_JPRB,1.7761E-02_JPRB,2.1969E-02_JPRB,&
&2.5895E-02_JPRB,2.8549E-02_JPRB,3.4694E-02_JPRB/)
KAO( :, 5, 4,15) = (/&
&2.5299E-03_JPRB,6.1198E-03_JPRB,1.2014E-02_JPRB,1.7823E-02_JPRB,2.3626E-02_JPRB,3.0145E-02_JPRB,&
&3.4844E-02_JPRB,3.8179E-02_JPRB,4.7443E-02_JPRB/)
KAO( :, 1, 5,15) = (/&
&1.3376E-03_JPRB,1.3061E-03_JPRB,2.2933E-03_JPRB,3.4105E-03_JPRB,4.5058E-03_JPRB,5.4169E-03_JPRB,&
&6.3127E-03_JPRB,7.0090E-03_JPRB,8.8382E-03_JPRB/)
KAO( :, 2, 5,15) = (/&
&1.3263E-03_JPRB,1.8712E-03_JPRB,3.6486E-03_JPRB,5.3688E-03_JPRB,7.2653E-03_JPRB,8.6947E-03_JPRB,&
&1.0335E-02_JPRB,1.1527E-02_JPRB,1.4282E-02_JPRB/)
KAO( :, 3, 5,15) = (/&
&1.4243E-03_JPRB,2.8262E-03_JPRB,5.4158E-03_JPRB,8.2878E-03_JPRB,1.0953E-02_JPRB,1.3340E-02_JPRB,&
&1.6078E-02_JPRB,1.7370E-02_JPRB,2.2313E-02_JPRB/)
KAO( :, 4, 5,15) = (/&
&1.6989E-03_JPRB,4.0314E-03_JPRB,7.9177E-03_JPRB,1.2164E-02_JPRB,1.6022E-02_JPRB,1.9693E-02_JPRB,&
&2.2743E-02_JPRB,2.5430E-02_JPRB,3.1147E-02_JPRB/)
KAO( :, 5, 5,15) = (/&
&2.0980E-03_JPRB,5.4208E-03_JPRB,1.0645E-02_JPRB,1.5846E-02_JPRB,2.1457E-02_JPRB,2.6719E-02_JPRB,&
&3.1700E-02_JPRB,3.4634E-02_JPRB,4.2396E-02_JPRB/)
KAO( :, 1, 6,15) = (/&
&1.4699E-03_JPRB,1.3039E-03_JPRB,1.7682E-03_JPRB,2.6642E-03_JPRB,3.3901E-03_JPRB,4.1361E-03_JPRB,&
&4.9645E-03_JPRB,5.4015E-03_JPRB,7.0142E-03_JPRB/)
KAO( :, 2, 6,15) = (/&
&1.4420E-03_JPRB,1.6011E-03_JPRB,2.9603E-03_JPRB,4.2663E-03_JPRB,5.9096E-03_JPRB,7.1197E-03_JPRB,&
&8.3224E-03_JPRB,9.2909E-03_JPRB,1.1572E-02_JPRB/)
KAO( :, 3, 6,15) = (/&
&1.4209E-03_JPRB,2.3651E-03_JPRB,4.5056E-03_JPRB,6.8456E-03_JPRB,9.2009E-03_JPRB,1.1119E-02_JPRB,&
&1.3497E-02_JPRB,1.4341E-02_JPRB,1.8485E-02_JPRB/)
KAO( :, 4, 6,15) = (/&
&1.4876E-03_JPRB,3.4335E-03_JPRB,6.7368E-03_JPRB,1.0314E-02_JPRB,1.3111E-02_JPRB,1.6614E-02_JPRB,&
&1.9482E-02_JPRB,2.1613E-02_JPRB,2.6785E-02_JPRB/)
KAO( :, 5, 6,15) = (/&
&1.7311E-03_JPRB,4.9309E-03_JPRB,9.6716E-03_JPRB,1.4408E-02_JPRB,1.8785E-02_JPRB,2.3407E-02_JPRB,&
&2.7826E-02_JPRB,3.0253E-02_JPRB,3.8797E-02_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.6452E-03_JPRB,1.4412E-03_JPRB,1.4879E-03_JPRB,1.9571E-03_JPRB,2.5256E-03_JPRB,3.0766E-03_JPRB,&
&3.7011E-03_JPRB,4.0149E-03_JPRB,5.3627E-03_JPRB/)
KAO( :, 2, 7,15) = (/&
&1.6160E-03_JPRB,1.5227E-03_JPRB,2.2973E-03_JPRB,3.3257E-03_JPRB,4.5738E-03_JPRB,5.5584E-03_JPRB,&
&6.3881E-03_JPRB,7.2538E-03_JPRB,9.6722E-03_JPRB/)
KAO( :, 3, 7,15) = (/&
&1.5860E-03_JPRB,2.0263E-03_JPRB,3.8492E-03_JPRB,5.5523E-03_JPRB,7.3824E-03_JPRB,9.0664E-03_JPRB,&
&1.0834E-02_JPRB,1.1569E-02_JPRB,1.5617E-02_JPRB/)
KAO( :, 4, 7,15) = (/&
&1.5638E-03_JPRB,2.9557E-03_JPRB,5.6559E-03_JPRB,8.6531E-03_JPRB,1.0991E-02_JPRB,1.3929E-02_JPRB,&
&1.6365E-02_JPRB,1.8010E-02_JPRB,2.4730E-02_JPRB/)
KAO( :, 5, 7,15) = (/&
&1.5935E-03_JPRB,4.3661E-03_JPRB,8.5392E-03_JPRB,1.2446E-02_JPRB,1.6667E-02_JPRB,2.0343E-02_JPRB,&
&2.3794E-02_JPRB,2.5830E-02_JPRB,3.6014E-02_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.8723E-03_JPRB,1.6388E-03_JPRB,1.4610E-03_JPRB,1.5561E-03_JPRB,1.8720E-03_JPRB,2.3376E-03_JPRB,&
&2.6613E-03_JPRB,2.9039E-03_JPRB,6.4956E-03_JPRB/)
KAO( :, 2, 8,15) = (/&
&1.8456E-03_JPRB,1.6296E-03_JPRB,1.9116E-03_JPRB,2.6011E-03_JPRB,3.5199E-03_JPRB,4.2393E-03_JPRB,&
&4.8531E-03_JPRB,5.3550E-03_JPRB,1.2422E-02_JPRB/)
KAO( :, 3, 8,15) = (/&
&1.8093E-03_JPRB,1.9050E-03_JPRB,3.1124E-03_JPRB,4.4584E-03_JPRB,5.9417E-03_JPRB,7.2783E-03_JPRB,&
&8.6194E-03_JPRB,9.3908E-03_JPRB,2.1656E-02_JPRB/)
KAO( :, 4, 8,15) = (/&
&1.7796E-03_JPRB,2.5264E-03_JPRB,4.7746E-03_JPRB,7.1139E-03_JPRB,9.2445E-03_JPRB,1.1405E-02_JPRB,&
&1.3524E-02_JPRB,1.4718E-02_JPRB,3.5472E-02_JPRB/)
KAO( :, 5, 8,15) = (/&
&1.7474E-03_JPRB,3.6460E-03_JPRB,7.3775E-03_JPRB,1.0554E-02_JPRB,1.4351E-02_JPRB,1.7437E-02_JPRB,&
&2.0234E-02_JPRB,2.2659E-02_JPRB,5.4466E-02_JPRB/)
KAO( :, 1, 9,15) = (/&
&2.1531E-03_JPRB,1.8852E-03_JPRB,1.6173E-03_JPRB,1.4438E-03_JPRB,1.4392E-03_JPRB,1.6909E-03_JPRB,&
&1.8360E-03_JPRB,1.2556E-03_JPRB,2.2429E-02_JPRB/)
KAO( :, 2, 9,15) = (/&
&2.1197E-03_JPRB,1.8522E-03_JPRB,1.7919E-03_JPRB,2.0362E-03_JPRB,2.5897E-03_JPRB,3.1619E-03_JPRB,&
&3.6769E-03_JPRB,3.8809E-03_JPRB,4.5293E-02_JPRB/)
KAO( :, 3, 9,15) = (/&
&2.0806E-03_JPRB,1.9202E-03_JPRB,2.4651E-03_JPRB,3.5166E-03_JPRB,4.6833E-03_JPRB,5.6685E-03_JPRB,&
&6.7191E-03_JPRB,7.2005E-03_JPRB,8.3053E-02_JPRB/)
KAO( :, 4, 9,15) = (/&
&2.0479E-03_JPRB,2.3234E-03_JPRB,3.9257E-03_JPRB,5.8282E-03_JPRB,7.5382E-03_JPRB,9.2852E-03_JPRB,&
&1.0968E-02_JPRB,1.1755E-02_JPRB,1.4085E-01_JPRB/)
KAO( :, 5, 9,15) = (/&
&2.0135E-03_JPRB,3.1161E-03_JPRB,6.2953E-03_JPRB,8.9489E-03_JPRB,1.1910E-02_JPRB,1.4603E-02_JPRB,&
&1.7103E-02_JPRB,1.8687E-02_JPRB,2.2489E-01_JPRB/)
KAO( :, 1,10,15) = (/&
&2.4996E-03_JPRB,2.1860E-03_JPRB,1.8719E-03_JPRB,1.5736E-03_JPRB,1.3474E-03_JPRB,1.3138E-03_JPRB,&
&1.2455E-03_JPRB,1.1328E-07_JPRB,9.2144E-02_JPRB/)
KAO( :, 2,10,15) = (/&
&2.4545E-03_JPRB,2.1478E-03_JPRB,1.8895E-03_JPRB,1.8842E-03_JPRB,2.0494E-03_JPRB,2.4515E-03_JPRB,&
&2.7912E-03_JPRB,2.8411E-03_JPRB,1.9577E-01_JPRB/)
KAO( :, 3,10,15) = (/&
&2.4123E-03_JPRB,2.1379E-03_JPRB,2.2699E-03_JPRB,2.9106E-03_JPRB,3.7957E-03_JPRB,4.5303E-03_JPRB,&
&5.1569E-03_JPRB,5.5947E-03_JPRB,3.7579E-01_JPRB/)
KAO( :, 4,10,15) = (/&
&2.3670E-03_JPRB,2.3455E-03_JPRB,3.3904E-03_JPRB,4.7982E-03_JPRB,6.5586E-03_JPRB,7.6814E-03_JPRB,&
&8.9698E-03_JPRB,9.4919E-03_JPRB,6.5920E-01_JPRB/)
KAO( :, 5,10,15) = (/&
&2.3225E-03_JPRB,2.8728E-03_JPRB,5.4745E-03_JPRB,7.9446E-03_JPRB,1.0257E-02_JPRB,1.2466E-02_JPRB,&
&1.4486E-02_JPRB,1.5553E-02_JPRB,1.0800E+00_JPRB/)
KAO( :, 1,11,15) = (/&
&2.8637E-03_JPRB,2.5035E-03_JPRB,2.1436E-03_JPRB,1.8035E-03_JPRB,1.5339E-03_JPRB,1.4234E-03_JPRB,&
&1.1994E-03_JPRB,9.8829E-08_JPRB,1.9145E-01_JPRB/)
KAO( :, 2,11,15) = (/&
&2.8241E-03_JPRB,2.4682E-03_JPRB,2.1655E-03_JPRB,2.0940E-03_JPRB,2.2293E-03_JPRB,2.5943E-03_JPRB,&
&2.8972E-03_JPRB,2.9304E-03_JPRB,4.0810E-01_JPRB/)
KAO( :, 3,11,15) = (/&
&2.7755E-03_JPRB,2.4611E-03_JPRB,2.5498E-03_JPRB,3.0773E-03_JPRB,3.9941E-03_JPRB,4.8157E-03_JPRB,&
&5.3205E-03_JPRB,5.7118E-03_JPRB,7.8317E-01_JPRB/)
KAO( :, 4,11,15) = (/&
&2.7180E-03_JPRB,2.6251E-03_JPRB,3.6039E-03_JPRB,5.0535E-03_JPRB,6.8961E-03_JPRB,8.2198E-03_JPRB,&
&9.2474E-03_JPRB,9.6840E-03_JPRB,1.3768E+00_JPRB/)
KAO( :, 5,11,15) = (/&
&2.6558E-03_JPRB,3.1273E-03_JPRB,5.6600E-03_JPRB,8.3772E-03_JPRB,1.0624E-02_JPRB,1.3218E-02_JPRB,&
&1.5003E-02_JPRB,1.5876E-02_JPRB,2.2520E+00_JPRB/)
KAO( :, 1,12,15) = (/&
&3.2714E-03_JPRB,2.8584E-03_JPRB,2.4535E-03_JPRB,2.0680E-03_JPRB,1.7413E-03_JPRB,1.5693E-03_JPRB,&
&1.4195E-03_JPRB,8.7492E-08_JPRB,2.9715E-01_JPRB/)
KAO( :, 2,12,15) = (/&
&3.2238E-03_JPRB,2.8219E-03_JPRB,2.4898E-03_JPRB,2.3173E-03_JPRB,2.4029E-03_JPRB,2.7493E-03_JPRB,&
&3.0184E-03_JPRB,3.0151E-03_JPRB,6.3430E-01_JPRB/)
KAO( :, 3,12,15) = (/&
&3.1690E-03_JPRB,2.8261E-03_JPRB,2.8398E-03_JPRB,3.2763E-03_JPRB,4.1787E-03_JPRB,5.0712E-03_JPRB,&
&5.7128E-03_JPRB,5.7933E-03_JPRB,1.2146E+00_JPRB/)
KAO( :, 4,12,15) = (/&
&3.1066E-03_JPRB,2.9671E-03_JPRB,3.8178E-03_JPRB,5.5845E-03_JPRB,7.1025E-03_JPRB,8.6518E-03_JPRB,&
&9.8099E-03_JPRB,1.0106E-02_JPRB,2.1338E+00_JPRB/)
KAO( :, 5,12,15) = (/&
&3.0417E-03_JPRB,3.4447E-03_JPRB,5.9771E-03_JPRB,8.7849E-03_JPRB,1.1154E-02_JPRB,1.3933E-02_JPRB,&
&1.5683E-02_JPRB,1.6226E-02_JPRB,3.5026E+00_JPRB/)
KAO( :, 1,13,15) = (/&
&3.7174E-03_JPRB,3.2529E-03_JPRB,2.7876E-03_JPRB,2.3613E-03_JPRB,1.9840E-03_JPRB,1.7059E-03_JPRB,&
&1.5699E-03_JPRB,2.2638E-04_JPRB,3.7080E-01_JPRB/)
KAO( :, 2,13,15) = (/&
&3.6607E-03_JPRB,3.2024E-03_JPRB,2.8505E-03_JPRB,2.5957E-03_JPRB,2.5988E-03_JPRB,2.8843E-03_JPRB,&
&3.1480E-03_JPRB,3.2252E-03_JPRB,7.9012E-01_JPRB/)
KAO( :, 3,13,15) = (/&
&3.6056E-03_JPRB,3.2358E-03_JPRB,3.0977E-03_JPRB,3.5132E-03_JPRB,4.3893E-03_JPRB,5.3238E-03_JPRB,&
&5.9823E-03_JPRB,6.0551E-03_JPRB,1.5116E+00_JPRB/)
KAO( :, 4,13,15) = (/&
&3.5392E-03_JPRB,3.3725E-03_JPRB,4.1216E-03_JPRB,5.8741E-03_JPRB,7.4524E-03_JPRB,8.9744E-03_JPRB,&
&1.0256E-02_JPRB,1.0534E-02_JPRB,2.6566E+00_JPRB/)
KAO( :, 5,13,15) = (/&
&3.4654E-03_JPRB,3.8025E-03_JPRB,6.3205E-03_JPRB,9.1996E-03_JPRB,1.1773E-02_JPRB,1.4433E-02_JPRB,&
&1.6393E-02_JPRB,1.6955E-02_JPRB,4.3588E+00_JPRB/)
KAO( :, 1, 1,16) = (/&
&1.5672E-03_JPRB,2.1553E-03_JPRB,4.1215E-03_JPRB,6.0711E-03_JPRB,7.9933E-03_JPRB,9.8639E-03_JPRB,&
&1.1623E-02_JPRB,1.2894E-02_JPRB,1.4627E-02_JPRB/)
KAO( :, 2, 1,16) = (/&
&1.9455E-03_JPRB,3.1176E-03_JPRB,5.9834E-03_JPRB,8.8258E-03_JPRB,1.1628E-02_JPRB,1.4352E-02_JPRB,&
&1.6890E-02_JPRB,1.8782E-02_JPRB,2.1292E-02_JPRB/)
KAO( :, 3, 1,16) = (/&
&2.4286E-03_JPRB,4.3028E-03_JPRB,8.2818E-03_JPRB,1.2234E-02_JPRB,1.6127E-02_JPRB,1.9913E-02_JPRB,&
&2.3612E-02_JPRB,2.6215E-02_JPRB,2.9752E-02_JPRB/)
KAO( :, 4, 1,16) = (/&
&3.0199E-03_JPRB,5.7955E-03_JPRB,1.1212E-02_JPRB,1.6585E-02_JPRB,2.1939E-02_JPRB,2.7103E-02_JPRB,&
&3.1641E-02_JPRB,3.5382E-02_JPRB,4.0152E-02_JPRB/)
KAO( :, 5, 1,16) = (/&
&3.7301E-03_JPRB,7.5925E-03_JPRB,1.4663E-02_JPRB,2.1614E-02_JPRB,2.8523E-02_JPRB,3.5412E-02_JPRB,&
&4.1705E-02_JPRB,4.6016E-02_JPRB,5.2602E-02_JPRB/)
KAO( :, 1, 2,16) = (/&
&1.4714E-03_JPRB,2.1897E-03_JPRB,4.1859E-03_JPRB,6.1816E-03_JPRB,8.1457E-03_JPRB,1.0051E-02_JPRB,&
&1.1874E-02_JPRB,1.3114E-02_JPRB,1.5524E-02_JPRB/)
KAO( :, 2, 2,16) = (/&
&1.8243E-03_JPRB,3.2190E-03_JPRB,6.2284E-03_JPRB,9.2101E-03_JPRB,1.2144E-02_JPRB,1.5021E-02_JPRB,&
&1.7606E-02_JPRB,1.9473E-02_JPRB,2.2997E-02_JPRB/)
KAO( :, 3, 2,16) = (/&
&2.2843E-03_JPRB,4.5394E-03_JPRB,8.8033E-03_JPRB,1.3032E-02_JPRB,1.7194E-02_JPRB,2.1230E-02_JPRB,&
&2.5009E-02_JPRB,2.7460E-02_JPRB,3.2496E-02_JPRB/)
KAO( :, 4, 2,16) = (/&
&2.8708E-03_JPRB,6.2086E-03_JPRB,1.2093E-02_JPRB,1.7923E-02_JPRB,2.3632E-02_JPRB,2.9181E-02_JPRB,&
&3.4133E-02_JPRB,3.7858E-02_JPRB,4.4523E-02_JPRB/)
KAO( :, 5, 2,16) = (/&
&3.5701E-03_JPRB,8.1350E-03_JPRB,1.5874E-02_JPRB,2.3527E-02_JPRB,3.1085E-02_JPRB,3.8729E-02_JPRB,&
&4.5307E-02_JPRB,4.9567E-02_JPRB,5.9359E-02_JPRB/)
KAO( :, 1, 3,16) = (/&
&1.2836E-03_JPRB,2.0294E-03_JPRB,3.8863E-03_JPRB,5.8124E-03_JPRB,7.6573E-03_JPRB,9.3378E-03_JPRB,&
&1.1017E-02_JPRB,1.1974E-02_JPRB,1.4949E-02_JPRB/)
KAO( :, 2, 3,16) = (/&
&1.5660E-03_JPRB,3.0824E-03_JPRB,6.0009E-03_JPRB,8.8868E-03_JPRB,1.1717E-02_JPRB,1.4438E-02_JPRB,&
&1.6887E-02_JPRB,1.8445E-02_JPRB,2.2945E-02_JPRB/)
KAO( :, 3, 3,16) = (/&
&1.9600E-03_JPRB,4.4422E-03_JPRB,8.7147E-03_JPRB,1.2909E-02_JPRB,1.7029E-02_JPRB,2.0993E-02_JPRB,&
&2.4634E-02_JPRB,2.6606E-02_JPRB,3.3559E-02_JPRB/)
KAO( :, 4, 3,16) = (/&
&2.4642E-03_JPRB,6.2222E-03_JPRB,1.2184E-02_JPRB,1.8079E-02_JPRB,2.3727E-02_JPRB,2.9253E-02_JPRB,&
&3.4378E-02_JPRB,3.7595E-02_JPRB,4.7010E-02_JPRB/)
KAO( :, 5, 3,16) = (/&
&3.0951E-03_JPRB,8.3838E-03_JPRB,1.6309E-02_JPRB,2.4359E-02_JPRB,3.2164E-02_JPRB,3.9734E-02_JPRB,&
&4.6556E-02_JPRB,5.0749E-02_JPRB,6.3475E-02_JPRB/)
KAO( :, 1, 4,16) = (/&
&1.2574E-03_JPRB,1.8114E-03_JPRB,3.5154E-03_JPRB,5.2030E-03_JPRB,6.8473E-03_JPRB,8.4135E-03_JPRB,&
&9.7945E-03_JPRB,1.0467E-02_JPRB,1.3735E-02_JPRB/)
KAO( :, 2, 4,16) = (/&
&1.4045E-03_JPRB,2.8445E-03_JPRB,5.5546E-03_JPRB,8.2273E-03_JPRB,1.0867E-02_JPRB,1.3255E-02_JPRB,&
&1.5543E-02_JPRB,1.6757E-02_JPRB,2.1717E-02_JPRB/)
KAO( :, 3, 4,16) = (/&
&1.7089E-03_JPRB,4.2655E-03_JPRB,8.3342E-03_JPRB,1.2385E-02_JPRB,1.6320E-02_JPRB,2.0006E-02_JPRB,&
&2.3383E-02_JPRB,2.5166E-02_JPRB,3.2791E-02_JPRB/)
KAO( :, 4, 4,16) = (/&
&2.1090E-03_JPRB,6.0675E-03_JPRB,1.1915E-02_JPRB,1.7681E-02_JPRB,2.3322E-02_JPRB,2.8694E-02_JPRB,&
&3.3458E-02_JPRB,3.6118E-02_JPRB,4.7164E-02_JPRB/)
KAO( :, 5, 4,16) = (/&
&2.6086E-03_JPRB,8.3756E-03_JPRB,1.6515E-02_JPRB,2.4278E-02_JPRB,3.2230E-02_JPRB,3.9587E-02_JPRB,&
&4.6358E-02_JPRB,4.9833E-02_JPRB,6.4660E-02_JPRB/)
KAO( :, 1, 5,16) = (/&
&1.3825E-03_JPRB,1.5837E-03_JPRB,3.0919E-03_JPRB,4.5531E-03_JPRB,6.0074E-03_JPRB,7.3563E-03_JPRB,&
&8.5040E-03_JPRB,9.0047E-03_JPRB,1.2222E-02_JPRB/)
KAO( :, 2, 5,16) = (/&
&1.3514E-03_JPRB,2.5997E-03_JPRB,5.0814E-03_JPRB,7.5197E-03_JPRB,9.9239E-03_JPRB,1.2026E-02_JPRB,&
&1.3939E-02_JPRB,1.4883E-02_JPRB,2.0096E-02_JPRB/)
KAO( :, 3, 5,16) = (/&
&1.5206E-03_JPRB,4.0333E-03_JPRB,7.8158E-03_JPRB,1.1713E-02_JPRB,1.5405E-02_JPRB,1.8636E-02_JPRB,&
&2.1846E-02_JPRB,2.3099E-02_JPRB,3.1394E-02_JPRB/)
KAO( :, 4, 5,16) = (/&
&1.8386E-03_JPRB,5.8482E-03_JPRB,1.1495E-02_JPRB,1.7163E-02_JPRB,2.2705E-02_JPRB,2.7707E-02_JPRB,&
&3.1828E-02_JPRB,3.4087E-02_JPRB,4.5825E-02_JPRB/)
KAO( :, 5, 5,16) = (/&
&2.2527E-03_JPRB,8.2599E-03_JPRB,1.6275E-02_JPRB,2.4092E-02_JPRB,3.1836E-02_JPRB,3.8856E-02_JPRB,&
&4.5237E-02_JPRB,4.7798E-02_JPRB,6.5032E-02_JPRB/)
KAO( :, 1, 6,16) = (/&
&1.5452E-03_JPRB,1.3558E-03_JPRB,2.6064E-03_JPRB,3.8420E-03_JPRB,5.0190E-03_JPRB,6.1218E-03_JPRB,&
&7.0124E-03_JPRB,7.3072E-03_JPRB,1.0404E-02_JPRB/)
KAO( :, 2, 6,16) = (/&
&1.5160E-03_JPRB,2.2762E-03_JPRB,4.4992E-03_JPRB,6.5908E-03_JPRB,8.7549E-03_JPRB,1.0577E-02_JPRB,&
&1.2081E-02_JPRB,1.2650E-02_JPRB,1.7914E-02_JPRB/)
KAO( :, 3, 6,16) = (/&
&1.4831E-03_JPRB,3.6667E-03_JPRB,7.1626E-03_JPRB,1.0648E-02_JPRB,1.4117E-02_JPRB,1.6912E-02_JPRB,&
&1.9731E-02_JPRB,2.0210E-02_JPRB,2.8978E-02_JPRB/)
KAO( :, 4, 6,16) = (/&
&1.6115E-03_JPRB,5.5846E-03_JPRB,1.0973E-02_JPRB,1.6135E-02_JPRB,2.1251E-02_JPRB,2.6015E-02_JPRB,&
&2.9549E-02_JPRB,3.0765E-02_JPRB,4.3671E-02_JPRB/)
KAO( :, 5, 6,16) = (/&
&1.9392E-03_JPRB,8.0663E-03_JPRB,1.5907E-02_JPRB,2.3470E-02_JPRB,3.0817E-02_JPRB,3.7382E-02_JPRB,&
&4.3204E-02_JPRB,4.4622E-02_JPRB,6.3997E-02_JPRB/)
KAO( :, 1, 7,16) = (/&
&1.7424E-03_JPRB,1.5255E-03_JPRB,2.1507E-03_JPRB,3.1520E-03_JPRB,4.1047E-03_JPRB,4.9755E-03_JPRB,&
&5.6339E-03_JPRB,5.7296E-03_JPRB,8.6456E-03_JPRB/)
KAO( :, 2, 7,16) = (/&
&1.7170E-03_JPRB,1.9718E-03_JPRB,3.9047E-03_JPRB,5.6866E-03_JPRB,7.5061E-03_JPRB,9.0459E-03_JPRB,&
&1.0285E-02_JPRB,1.0440E-02_JPRB,1.5762E-02_JPRB/)
KAO( :, 3, 7,16) = (/&
&1.6789E-03_JPRB,3.3135E-03_JPRB,6.5455E-03_JPRB,9.5842E-03_JPRB,1.2571E-02_JPRB,1.5280E-02_JPRB,&
&1.7323E-02_JPRB,1.7346E-02_JPRB,2.6392E-02_JPRB/)
KAO( :, 4, 7,16) = (/&
&1.6475E-03_JPRB,5.2207E-03_JPRB,1.0255E-02_JPRB,1.5008E-02_JPRB,1.9715E-02_JPRB,2.4009E-02_JPRB,&
&2.7310E-02_JPRB,2.7325E-02_JPRB,4.1677E-02_JPRB/)
KAO( :, 5, 7,16) = (/&
&1.7171E-03_JPRB,7.7744E-03_JPRB,1.5301E-02_JPRB,2.2477E-02_JPRB,2.9556E-02_JPRB,3.5932E-02_JPRB,&
&4.0780E-02_JPRB,4.0784E-02_JPRB,6.2312E-02_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.9724E-03_JPRB,1.7312E-03_JPRB,1.7354E-03_JPRB,2.5314E-03_JPRB,3.2671E-03_JPRB,3.9608E-03_JPRB,&
&4.3782E-03_JPRB,4.2763E-03_JPRB,7.0340E-03_JPRB/)
KAO( :, 2, 8,16) = (/&
&1.9569E-03_JPRB,1.7215E-03_JPRB,3.3340E-03_JPRB,4.8320E-03_JPRB,6.3356E-03_JPRB,7.5448E-03_JPRB,&
&8.4497E-03_JPRB,8.2045E-03_JPRB,1.3623E-02_JPRB/)
KAO( :, 3, 8,16) = (/&
&1.9222E-03_JPRB,3.0063E-03_JPRB,5.8393E-03_JPRB,8.4557E-03_JPRB,1.1082E-02_JPRB,1.3356E-02_JPRB,&
&1.4892E-02_JPRB,1.4508E-02_JPRB,2.3611E-02_JPRB/)
KAO( :, 4, 8,16) = (/&
&1.8856E-03_JPRB,4.8368E-03_JPRB,9.4413E-03_JPRB,1.3907E-02_JPRB,1.7960E-02_JPRB,2.1659E-02_JPRB,&
&2.4357E-02_JPRB,2.3676E-02_JPRB,3.8984E-02_JPRB/)
KAO( :, 5, 8,16) = (/&
&1.8442E-03_JPRB,7.3401E-03_JPRB,1.4568E-02_JPRB,2.1338E-02_JPRB,2.7859E-02_JPRB,3.3579E-02_JPRB,&
&3.7493E-02_JPRB,3.6571E-02_JPRB,5.9238E-02_JPRB/)
KAO( :, 1, 9,16) = (/&
&2.2527E-03_JPRB,1.9717E-03_JPRB,1.6910E-03_JPRB,1.9762E-03_JPRB,2.5161E-03_JPRB,3.0221E-03_JPRB,&
&3.2672E-03_JPRB,3.0670E-03_JPRB,2.3998E-02_JPRB/)
KAO( :, 2, 9,16) = (/&
&2.2414E-03_JPRB,1.9482E-03_JPRB,2.7675E-03_JPRB,3.9857E-03_JPRB,5.1603E-03_JPRB,6.1015E-03_JPRB,&
&6.6813E-03_JPRB,6.2533E-03_JPRB,4.8508E-02_JPRB/)
KAO( :, 3, 9,16) = (/&
&2.2044E-03_JPRB,2.6160E-03_JPRB,5.0727E-03_JPRB,7.3140E-03_JPRB,9.5554E-03_JPRB,1.1250E-02_JPRB,&
&1.2412E-02_JPRB,1.1623E-02_JPRB,8.8725E-02_JPRB/)
KAO( :, 4, 9,16) = (/&
&2.1701E-03_JPRB,4.4267E-03_JPRB,8.5607E-03_JPRB,1.2545E-02_JPRB,1.6038E-02_JPRB,1.9134E-02_JPRB,&
&2.1125E-02_JPRB,1.9740E-02_JPRB,1.5078E-01_JPRB/)
KAO( :, 5, 9,16) = (/&
&2.1291E-03_JPRB,6.8813E-03_JPRB,1.3705E-02_JPRB,1.9867E-02_JPRB,2.5629E-02_JPRB,3.0522E-02_JPRB,&
&3.3472E-02_JPRB,3.1537E-02_JPRB,2.4056E-01_JPRB/)
KAO( :, 1,10,16) = (/&
&2.6049E-03_JPRB,2.2811E-03_JPRB,1.9524E-03_JPRB,1.6297E-03_JPRB,1.9817E-03_JPRB,2.3323E-03_JPRB,&
&2.4538E-03_JPRB,1.0919E-07_JPRB,9.9434E-02_JPRB/)
KAO( :, 2,10,16) = (/&
&2.5564E-03_JPRB,2.2387E-03_JPRB,2.3682E-03_JPRB,3.4024E-03_JPRB,4.3056E-03_JPRB,4.9923E-03_JPRB,&
&5.3151E-03_JPRB,4.7395E-03_JPRB,2.1164E-01_JPRB/)
KAO( :, 3,10,16) = (/&
&2.5312E-03_JPRB,2.3572E-03_JPRB,4.5332E-03_JPRB,6.5179E-03_JPRB,8.3516E-03_JPRB,9.6321E-03_JPRB,&
&1.0262E-02_JPRB,9.2275E-03_JPRB,4.0466E-01_JPRB/)
KAO( :, 4,10,16) = (/&
&2.4933E-03_JPRB,4.1318E-03_JPRB,7.9555E-03_JPRB,1.1428E-02_JPRB,1.4719E-02_JPRB,1.6992E-02_JPRB,&
&1.8127E-02_JPRB,1.6262E-02_JPRB,7.1180E-01_JPRB/)
KAO( :, 5,10,16) = (/&
&2.4587E-03_JPRB,6.7099E-03_JPRB,1.3086E-02_JPRB,1.8862E-02_JPRB,2.3880E-02_JPRB,2.7946E-02_JPRB,&
&2.9807E-02_JPRB,2.6793E-02_JPRB,1.1699E+00_JPRB/)
KAO( :, 1,11,16) = (/&
&3.0995E-03_JPRB,2.7200E-03_JPRB,2.3118E-03_JPRB,1.9403E-03_JPRB,2.2912E-03_JPRB,2.6188E-03_JPRB,&
&2.6729E-03_JPRB,9.6247E-08_JPRB,2.0911E-01_JPRB/)
KAO( :, 2,11,16) = (/&
&2.9890E-03_JPRB,2.6201E-03_JPRB,2.7716E-03_JPRB,3.9533E-03_JPRB,4.9561E-03_JPRB,5.6265E-03_JPRB,&
&5.7942E-03_JPRB,4.9820E-03_JPRB,4.4548E-01_JPRB/)
KAO( :, 3,11,16) = (/&
&2.9190E-03_JPRB,2.7609E-03_JPRB,5.3580E-03_JPRB,7.5536E-03_JPRB,9.5654E-03_JPRB,1.0853E-02_JPRB,&
&1.1187E-02_JPRB,9.7006E-03_JPRB,8.5245E-01_JPRB/)
KAO( :, 4,11,16) = (/&
&2.8864E-03_JPRB,4.8539E-03_JPRB,9.3197E-03_JPRB,1.3213E-02_JPRB,1.6850E-02_JPRB,1.9193E-02_JPRB,&
&1.9763E-02_JPRB,1.7093E-02_JPRB,1.5055E+00_JPRB/)
KAO( :, 5,11,16) = (/&
&2.8813E-03_JPRB,7.9127E-03_JPRB,1.5164E-02_JPRB,2.1854E-02_JPRB,2.7083E-02_JPRB,3.1374E-02_JPRB,&
&3.2509E-02_JPRB,2.8179E-02_JPRB,2.4634E+00_JPRB/)
KAO( :, 1,12,16) = (/&
&3.7114E-03_JPRB,3.2586E-03_JPRB,2.7915E-03_JPRB,2.3232E-03_JPRB,2.6631E-03_JPRB,3.0175E-03_JPRB,&
&3.0634E-03_JPRB,8.7203E-08_JPRB,3.2918E-01_JPRB/)
KAO( :, 2,12,16) = (/&
&3.5714E-03_JPRB,3.1255E-03_JPRB,3.2432E-03_JPRB,4.6151E-03_JPRB,5.7633E-03_JPRB,6.4683E-03_JPRB,&
&6.5276E-03_JPRB,5.5718E-03_JPRB,7.0176E-01_JPRB/)
KAO( :, 3,12,16) = (/&
&3.4916E-03_JPRB,3.2858E-03_JPRB,6.3152E-03_JPRB,8.8262E-03_JPRB,1.0981E-02_JPRB,1.2464E-02_JPRB,&
&1.2740E-02_JPRB,1.0731E-02_JPRB,1.3410E+00_JPRB/)
KAO( :, 4,12,16) = (/&
&3.4311E-03_JPRB,5.7096E-03_JPRB,1.0941E-02_JPRB,1.5646E-02_JPRB,1.9404E-02_JPRB,2.2034E-02_JPRB,&
&2.2454E-02_JPRB,1.9063E-02_JPRB,2.3582E+00_JPRB/)
KAO( :, 5,12,16) = (/&
&3.4152E-03_JPRB,9.2951E-03_JPRB,1.7728E-02_JPRB,2.5434E-02_JPRB,3.1194E-02_JPRB,3.5945E-02_JPRB,&
&3.6575E-02_JPRB,3.1362E-02_JPRB,3.8718E+00_JPRB/)
KAO( :, 1,13,16) = (/&
&4.4410E-03_JPRB,3.8860E-03_JPRB,3.3353E-03_JPRB,2.7740E-03_JPRB,3.0544E-03_JPRB,3.4238E-03_JPRB,&
&3.4509E-03_JPRB,2.8859E-03_JPRB,4.1592E-01_JPRB/)
KAO( :, 2,13,16) = (/&
&4.2685E-03_JPRB,3.7372E-03_JPRB,3.7732E-03_JPRB,5.3427E-03_JPRB,6.6266E-03_JPRB,7.3589E-03_JPRB,&
&7.3233E-03_JPRB,6.2265E-03_JPRB,8.8643E-01_JPRB/)
KAO( :, 3,13,16) = (/&
&4.1797E-03_JPRB,3.9191E-03_JPRB,7.1821E-03_JPRB,1.0185E-02_JPRB,1.2582E-02_JPRB,1.4162E-02_JPRB,&
&1.4321E-02_JPRB,1.1935E-02_JPRB,1.6929E+00_JPRB/)
KAO( :, 4,13,16) = (/&
&4.0934E-03_JPRB,6.6879E-03_JPRB,1.2699E-02_JPRB,1.8078E-02_JPRB,2.2220E-02_JPRB,2.4912E-02_JPRB,&
&2.5205E-02_JPRB,2.1207E-02_JPRB,2.9775E+00_JPRB/)
KAO( :, 5,13,16) = (/&
&4.0583E-03_JPRB,1.0796E-02_JPRB,2.0731E-02_JPRB,2.9284E-02_JPRB,3.5883E-02_JPRB,4.0713E-02_JPRB,&
&4.0964E-02_JPRB,3.4894E-02_JPRB,4.8770E+00_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB7_A2
