!OCL SCALAR
SUBROUTINE RRTM_KGB7_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 7:  980-1080 cm-1 (low - H2O,O3; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO7 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,ABSCO2O
USE YOERRTA7 , ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&2.2177E-05_JPRB,2.0513E-05_JPRB,1.8414E-05_JPRB,1.6282E-05_JPRB,1.4597E-05_JPRB,1.7000E-05_JPRB,&
&3.1783E-05_JPRB,2.9548E-05_JPRB,2.0326E-05_JPRB/)
KAO( :, 2, 1, 1) = (/&
&2.9476E-05_JPRB,2.7495E-05_JPRB,2.4720E-05_JPRB,2.1727E-05_JPRB,1.8690E-05_JPRB,1.6642E-05_JPRB,&
&2.2418E-05_JPRB,3.4177E-05_JPRB,1.9700E-05_JPRB/)
KAO( :, 3, 1, 1) = (/&
&3.7965E-05_JPRB,3.5737E-05_JPRB,3.2254E-05_JPRB,2.8364E-05_JPRB,2.4321E-05_JPRB,2.0140E-05_JPRB,&
&1.9338E-05_JPRB,3.5856E-05_JPRB,1.9799E-05_JPRB/)
KAO( :, 4, 1, 1) = (/&
&4.7589E-05_JPRB,4.5238E-05_JPRB,4.1024E-05_JPRB,3.6253E-05_JPRB,3.0918E-05_JPRB,2.5365E-05_JPRB,&
&2.0061E-05_JPRB,3.1406E-05_JPRB,1.8985E-05_JPRB/)
KAO( :, 5, 1, 1) = (/&
&5.8133E-05_JPRB,5.5835E-05_JPRB,5.0877E-05_JPRB,4.5058E-05_JPRB,3.8486E-05_JPRB,3.1429E-05_JPRB,&
&2.4355E-05_JPRB,2.3465E-05_JPRB,1.9414E-05_JPRB/)
KAO( :, 1, 2, 1) = (/&
&1.7361E-05_JPRB,1.6018E-05_JPRB,1.4350E-05_JPRB,1.2700E-05_JPRB,1.2303E-05_JPRB,1.7164E-05_JPRB,&
&3.1474E-05_JPRB,2.4947E-05_JPRB,1.4706E-05_JPRB/)
KAO( :, 2, 2, 1) = (/&
&2.3361E-05_JPRB,2.1726E-05_JPRB,1.9465E-05_JPRB,1.7053E-05_JPRB,1.4815E-05_JPRB,1.4858E-05_JPRB,&
&2.3603E-05_JPRB,2.7767E-05_JPRB,1.5833E-05_JPRB/)
KAO( :, 3, 2, 1) = (/&
&3.0408E-05_JPRB,2.8494E-05_JPRB,2.5606E-05_JPRB,2.2430E-05_JPRB,1.9084E-05_JPRB,1.6104E-05_JPRB,&
&1.8012E-05_JPRB,3.1460E-05_JPRB,1.6197E-05_JPRB/)
KAO( :, 4, 2, 1) = (/&
&3.8408E-05_JPRB,3.6296E-05_JPRB,3.2790E-05_JPRB,2.8865E-05_JPRB,2.4498E-05_JPRB,1.9967E-05_JPRB,&
&1.6925E-05_JPRB,3.2098E-05_JPRB,1.4117E-05_JPRB/)
KAO( :, 5, 2, 1) = (/&
&4.7278E-05_JPRB,4.5107E-05_JPRB,4.0996E-05_JPRB,3.6211E-05_JPRB,3.0776E-05_JPRB,2.4989E-05_JPRB,&
&1.9312E-05_JPRB,2.3551E-05_JPRB,1.4164E-05_JPRB/)
KAO( :, 1, 3, 1) = (/&
&1.2199E-05_JPRB,1.1359E-05_JPRB,1.0200E-05_JPRB,9.6275E-06_JPRB,1.2031E-05_JPRB,1.8466E-05_JPRB,&
&2.2967E-05_JPRB,2.1740E-05_JPRB,1.1424E-05_JPRB/)
KAO( :, 2, 3, 1) = (/&
&1.6733E-05_JPRB,1.5628E-05_JPRB,1.3980E-05_JPRB,1.2308E-05_JPRB,1.1642E-05_JPRB,1.5244E-05_JPRB,&
&2.7219E-05_JPRB,2.2185E-05_JPRB,1.1890E-05_JPRB/)
KAO( :, 3, 3, 1) = (/&
&2.2207E-05_JPRB,2.0825E-05_JPRB,1.8647E-05_JPRB,1.6328E-05_JPRB,1.4051E-05_JPRB,1.3615E-05_JPRB,&
&2.0537E-05_JPRB,2.5366E-05_JPRB,1.0328E-05_JPRB/)
KAO( :, 4, 3, 1) = (/&
&2.8575E-05_JPRB,2.6953E-05_JPRB,2.4203E-05_JPRB,2.1170E-05_JPRB,1.7963E-05_JPRB,1.5129E-05_JPRB,&
&1.6245E-05_JPRB,2.7906E-05_JPRB,8.9114E-06_JPRB/)
KAO( :, 5, 3, 1) = (/&
&3.5718E-05_JPRB,3.3927E-05_JPRB,3.0634E-05_JPRB,2.6847E-05_JPRB,2.2736E-05_JPRB,1.8593E-05_JPRB,&
&1.5444E-05_JPRB,2.7715E-05_JPRB,7.5424E-06_JPRB/)
KAO( :, 1, 4, 1) = (/&
&8.2740E-06_JPRB,7.8120E-06_JPRB,7.3229E-06_JPRB,7.9409E-06_JPRB,1.1817E-05_JPRB,2.0000E-05_JPRB,&
&1.7036E-05_JPRB,1.6859E-05_JPRB,8.3202E-06_JPRB/)
KAO( :, 2, 4, 1) = (/&
&1.1549E-05_JPRB,1.0930E-05_JPRB,9.8917E-06_JPRB,9.2790E-06_JPRB,1.0972E-05_JPRB,1.6368E-05_JPRB,&
&2.0889E-05_JPRB,1.9211E-05_JPRB,7.1922E-06_JPRB/)
KAO( :, 3, 4, 1) = (/&
&1.5581E-05_JPRB,1.4791E-05_JPRB,1.3288E-05_JPRB,1.1769E-05_JPRB,1.1067E-05_JPRB,1.3703E-05_JPRB,&
&2.3763E-05_JPRB,1.9912E-05_JPRB,5.4002E-06_JPRB/)
KAO( :, 4, 4, 1) = (/&
&2.0367E-05_JPRB,1.9416E-05_JPRB,1.7464E-05_JPRB,1.5301E-05_JPRB,1.3238E-05_JPRB,1.2747E-05_JPRB,&
&1.8197E-05_JPRB,2.2927E-05_JPRB,4.7781E-06_JPRB/)
KAO( :, 5, 4, 1) = (/&
&2.5890E-05_JPRB,2.4787E-05_JPRB,2.2347E-05_JPRB,1.9553E-05_JPRB,1.6603E-05_JPRB,1.3957E-05_JPRB,&
&1.4873E-05_JPRB,2.4745E-05_JPRB,6.3734E-06_JPRB/)
KAO( :, 1, 5, 1) = (/&
&5.5869E-06_JPRB,5.3398E-06_JPRB,5.3975E-06_JPRB,7.5444E-06_JPRB,1.2793E-05_JPRB,1.5045E-05_JPRB,&
&1.3730E-05_JPRB,1.2376E-05_JPRB,4.7266E-06_JPRB/)
KAO( :, 2, 5, 1) = (/&
&7.8874E-06_JPRB,7.5569E-06_JPRB,7.0693E-06_JPRB,7.4130E-06_JPRB,1.0864E-05_JPRB,1.7853E-05_JPRB,&
&1.5643E-05_JPRB,1.6221E-05_JPRB,3.5143E-06_JPRB/)
KAO( :, 3, 5, 1) = (/&
&1.0780E-05_JPRB,1.0380E-05_JPRB,9.4898E-06_JPRB,8.8724E-06_JPRB,9.9994E-06_JPRB,1.4704E-05_JPRB,&
&1.8972E-05_JPRB,1.7347E-05_JPRB,2.8694E-06_JPRB/)
KAO( :, 4, 5, 1) = (/&
&1.4284E-05_JPRB,1.3812E-05_JPRB,1.2569E-05_JPRB,1.1246E-05_JPRB,1.0513E-05_JPRB,1.2455E-05_JPRB,&
&2.1138E-05_JPRB,1.8036E-05_JPRB,3.9174E-06_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.8381E-05_JPRB,1.7863E-05_JPRB,1.6238E-05_JPRB,1.4332E-05_JPRB,1.2479E-05_JPRB,1.1807E-05_JPRB,&
&1.6766E-05_JPRB,2.0636E-05_JPRB,5.6357E-06_JPRB/)
KAO( :, 1, 6, 1) = (/&
&3.7614E-06_JPRB,3.6612E-06_JPRB,4.2770E-06_JPRB,7.9260E-06_JPRB,1.2929E-05_JPRB,1.1264E-05_JPRB,&
&1.2098E-05_JPRB,9.0224E-06_JPRB,2.4844E-06_JPRB/)
KAO( :, 2, 6, 1) = (/&
&5.3574E-06_JPRB,5.1717E-06_JPRB,5.1909E-06_JPRB,6.9736E-06_JPRB,1.1707E-05_JPRB,1.3896E-05_JPRB,&
&1.2589E-05_JPRB,1.2103E-05_JPRB,1.8407E-06_JPRB/)
KAO( :, 3, 6, 1) = (/&
&7.3957E-06_JPRB,7.1617E-06_JPRB,6.7263E-06_JPRB,7.0062E-06_JPRB,1.0148E-05_JPRB,1.6269E-05_JPRB,&
&1.4268E-05_JPRB,1.5386E-05_JPRB,2.1237E-06_JPRB/)
KAO( :, 4, 6, 1) = (/&
&9.9154E-06_JPRB,9.6620E-06_JPRB,8.9048E-06_JPRB,8.3244E-06_JPRB,9.2342E-06_JPRB,1.3655E-05_JPRB,&
&1.7166E-05_JPRB,1.5743E-05_JPRB,3.1741E-06_JPRB/)
KAO( :, 5, 6, 1) = (/&
&1.2917E-05_JPRB,1.2663E-05_JPRB,1.1620E-05_JPRB,1.0475E-05_JPRB,9.8347E-06_JPRB,1.1480E-05_JPRB,&
&1.8999E-05_JPRB,1.6296E-05_JPRB,4.8288E-06_JPRB/)
KAO( :, 1, 7, 1) = (/&
&2.5698E-06_JPRB,2.6225E-06_JPRB,4.3229E-06_JPRB,9.1260E-06_JPRB,9.6331E-06_JPRB,9.4890E-06_JPRB,&
&8.7898E-06_JPRB,6.9652E-06_JPRB,1.3336E-06_JPRB/)
KAO( :, 2, 7, 1) = (/&
&3.6949E-06_JPRB,3.6079E-06_JPRB,4.1418E-06_JPRB,7.5616E-06_JPRB,1.2142E-05_JPRB,1.0521E-05_JPRB,&
&1.1728E-05_JPRB,8.9866E-06_JPRB,1.2052E-06_JPRB/)
KAO( :, 3, 7, 1) = (/&
&5.1506E-06_JPRB,5.0082E-06_JPRB,4.9832E-06_JPRB,6.5372E-06_JPRB,1.0639E-05_JPRB,1.2818E-05_JPRB,&
&1.1491E-05_JPRB,1.1845E-05_JPRB,1.7476E-06_JPRB/)
KAO( :, 4, 7, 1) = (/&
&6.9721E-06_JPRB,6.8111E-06_JPRB,6.4221E-06_JPRB,6.6314E-06_JPRB,9.5364E-06_JPRB,1.4735E-05_JPRB,&
&1.3056E-05_JPRB,1.4613E-05_JPRB,2.7527E-06_JPRB/)
KAO( :, 5, 7, 1) = (/&
&9.1741E-06_JPRB,9.0313E-06_JPRB,8.3715E-06_JPRB,7.8432E-06_JPRB,8.4495E-06_JPRB,1.2715E-05_JPRB,&
&1.5629E-05_JPRB,1.4305E-05_JPRB,4.3096E-06_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.7756E-06_JPRB,2.0634E-06_JPRB,5.0880E-06_JPRB,8.2373E-06_JPRB,7.8177E-06_JPRB,7.9286E-06_JPRB,&
&6.3775E-06_JPRB,5.4113E-06_JPRB,9.3762E-07_JPRB/)
KAO( :, 2, 8, 1) = (/&
&2.5589E-06_JPRB,2.6026E-06_JPRB,4.1994E-06_JPRB,8.7611E-06_JPRB,9.1501E-06_JPRB,8.9485E-06_JPRB,&
&8.8743E-06_JPRB,7.1784E-06_JPRB,1.1824E-06_JPRB/)
KAO( :, 3, 8, 1) = (/&
&3.5966E-06_JPRB,3.5351E-06_JPRB,4.0408E-06_JPRB,7.3057E-06_JPRB,1.1311E-05_JPRB,9.8836E-06_JPRB,&
&1.0943E-05_JPRB,9.1050E-06_JPRB,1.7854E-06_JPRB/)
KAO( :, 4, 8, 1) = (/&
&4.9051E-06_JPRB,4.8155E-06_JPRB,4.7641E-06_JPRB,6.2802E-06_JPRB,1.0233E-05_JPRB,1.1811E-05_JPRB,&
&1.0660E-05_JPRB,1.1545E-05_JPRB,2.8335E-06_JPRB/)
KAO( :, 5, 8, 1) = (/&
&6.5079E-06_JPRB,6.4275E-06_JPRB,6.0806E-06_JPRB,6.2850E-06_JPRB,8.9855E-06_JPRB,1.3690E-05_JPRB,&
&1.2091E-05_JPRB,1.3991E-05_JPRB,4.4905E-06_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.2486E-06_JPRB,2.0772E-06_JPRB,6.3261E-06_JPRB,6.5239E-06_JPRB,6.7379E-06_JPRB,5.7685E-06_JPRB,&
&4.7923E-06_JPRB,4.4775E-06_JPRB,2.0431E-06_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.8028E-06_JPRB,2.0516E-06_JPRB,4.9892E-06_JPRB,7.9160E-06_JPRB,7.4534E-06_JPRB,8.0589E-06_JPRB,&
&6.6119E-06_JPRB,5.7051E-06_JPRB,2.4856E-06_JPRB/)
KAO( :, 3, 9, 1) = (/&
&2.5445E-06_JPRB,2.5819E-06_JPRB,4.1305E-06_JPRB,8.3727E-06_JPRB,8.7276E-06_JPRB,8.5620E-06_JPRB,&
&8.8118E-06_JPRB,7.4196E-06_JPRB,3.4314E-06_JPRB/)
KAO( :, 4, 9, 1) = (/&
&3.4959E-06_JPRB,3.4634E-06_JPRB,3.9749E-06_JPRB,7.0571E-06_JPRB,1.0574E-05_JPRB,9.2822E-06_JPRB,&
&1.0319E-05_JPRB,9.2300E-06_JPRB,5.1599E-06_JPRB/)
KAO( :, 5, 9, 1) = (/&
&4.6733E-06_JPRB,4.6321E-06_JPRB,4.5821E-06_JPRB,6.0749E-06_JPRB,9.9333E-06_JPRB,1.0979E-05_JPRB,&
&1.0111E-05_JPRB,1.1271E-05_JPRB,8.0274E-06_JPRB/)
KAO( :, 1,10, 1) = (/&
&9.1025E-07_JPRB,2.4528E-06_JPRB,5.5726E-06_JPRB,5.5107E-06_JPRB,5.1975E-06_JPRB,4.4519E-06_JPRB,&
&3.8745E-06_JPRB,3.7574E-06_JPRB,7.2814E-06_JPRB/)
KAO( :, 2,10, 1) = (/&
&1.3156E-06_JPRB,2.0527E-06_JPRB,6.2782E-06_JPRB,6.4430E-06_JPRB,6.8843E-06_JPRB,6.1546E-06_JPRB,&
&5.1800E-06_JPRB,4.8780E-06_JPRB,8.0238E-06_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.8603E-06_JPRB,2.0830E-06_JPRB,5.0693E-06_JPRB,7.7258E-06_JPRB,7.2719E-06_JPRB,8.2740E-06_JPRB,&
&6.9520E-06_JPRB,6.2927E-06_JPRB,9.9400E-06_JPRB/)
KAO( :, 4,10, 1) = (/&
&2.5643E-06_JPRB,2.6119E-06_JPRB,4.1284E-06_JPRB,8.2194E-06_JPRB,8.3768E-06_JPRB,8.2923E-06_JPRB,&
&8.9244E-06_JPRB,7.7919E-06_JPRB,1.3755E-05_JPRB/)
KAO( :, 5,10, 1) = (/&
&3.4396E-06_JPRB,3.4402E-06_JPRB,3.9520E-06_JPRB,6.9781E-06_JPRB,9.9688E-06_JPRB,8.9208E-06_JPRB,&
&1.0073E-05_JPRB,9.4585E-06_JPRB,2.0482E-05_JPRB/)
KAO( :, 1,11, 1) = (/&
&7.9990E-07_JPRB,2.6784E-06_JPRB,5.0182E-06_JPRB,5.2703E-06_JPRB,4.7427E-06_JPRB,4.1219E-06_JPRB,&
&3.7030E-06_JPRB,3.7980E-06_JPRB,1.0212E-05_JPRB/)
KAO( :, 2,11, 1) = (/&
&1.1506E-06_JPRB,2.1675E-06_JPRB,6.1676E-06_JPRB,5.9511E-06_JPRB,6.4671E-06_JPRB,5.5707E-06_JPRB,&
&4.8102E-06_JPRB,4.7946E-06_JPRB,1.1170E-05_JPRB/)
KAO( :, 3,11, 1) = (/&
&1.6161E-06_JPRB,1.9795E-06_JPRB,5.4689E-06_JPRB,6.8567E-06_JPRB,6.9277E-06_JPRB,7.3643E-06_JPRB,&
&6.3255E-06_JPRB,6.0154E-06_JPRB,1.3679E-05_JPRB/)
KAO( :, 4,11, 1) = (/&
&2.2097E-06_JPRB,2.3135E-06_JPRB,4.4934E-06_JPRB,8.2433E-06_JPRB,7.5005E-06_JPRB,8.0757E-06_JPRB,&
&8.0043E-06_JPRB,7.4062E-06_JPRB,1.8725E-05_JPRB/)
KAO( :, 5,11, 1) = (/&
&2.9383E-06_JPRB,2.9710E-06_JPRB,3.8010E-06_JPRB,7.4323E-06_JPRB,8.7355E-06_JPRB,8.0970E-06_JPRB,&
&9.6640E-06_JPRB,8.8290E-06_JPRB,2.7664E-05_JPRB/)
KAO( :, 1,12, 1) = (/&
&7.0941E-07_JPRB,2.6297E-06_JPRB,4.5700E-06_JPRB,4.9667E-06_JPRB,4.3747E-06_JPRB,3.8263E-06_JPRB,&
&3.4506E-06_JPRB,3.6352E-06_JPRB,1.0764E-05_JPRB/)
KAO( :, 2,12, 1) = (/&
&1.0191E-06_JPRB,2.0344E-06_JPRB,5.5461E-06_JPRB,5.4627E-06_JPRB,5.8842E-06_JPRB,5.0801E-06_JPRB,&
&4.4391E-06_JPRB,4.4109E-06_JPRB,1.1741E-05_JPRB/)
KAO( :, 3,12, 1) = (/&
&1.4279E-06_JPRB,1.8013E-06_JPRB,5.3154E-06_JPRB,6.1728E-06_JPRB,6.3556E-06_JPRB,6.6152E-06_JPRB,&
&5.7465E-06_JPRB,5.5323E-06_JPRB,1.4320E-05_JPRB/)
KAO( :, 4,12, 1) = (/&
&1.9430E-06_JPRB,2.0642E-06_JPRB,4.3928E-06_JPRB,7.3526E-06_JPRB,6.7817E-06_JPRB,7.5948E-06_JPRB,&
&7.1609E-06_JPRB,6.7682E-06_JPRB,1.9523E-05_JPRB/)
KAO( :, 5,12, 1) = (/&
&2.5711E-06_JPRB,2.6172E-06_JPRB,3.5411E-06_JPRB,7.1217E-06_JPRB,7.7996E-06_JPRB,7.3436E-06_JPRB,&
&8.5622E-06_JPRB,7.9225E-06_JPRB,2.8755E-05_JPRB/)
KAO( :, 1,13, 1) = (/&
&6.2420E-07_JPRB,2.5595E-06_JPRB,4.1789E-06_JPRB,4.5948E-06_JPRB,4.0362E-06_JPRB,3.5472E-06_JPRB,&
&3.2436E-06_JPRB,3.4107E-06_JPRB,9.1608E-06_JPRB/)
KAO( :, 2,13, 1) = (/&
&8.9615E-07_JPRB,1.9079E-06_JPRB,4.9940E-06_JPRB,5.0423E-06_JPRB,5.3353E-06_JPRB,4.6287E-06_JPRB,&
&4.1017E-06_JPRB,4.1244E-06_JPRB,9.9901E-06_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.2529E-06_JPRB,1.6490E-06_JPRB,5.1498E-06_JPRB,5.5689E-06_JPRB,5.8865E-06_JPRB,5.9318E-06_JPRB,&
&5.1860E-06_JPRB,5.1003E-06_JPRB,1.2178E-05_JPRB/)
KAO( :, 4,13, 1) = (/&
&1.6987E-06_JPRB,1.8380E-06_JPRB,4.2684E-06_JPRB,6.5744E-06_JPRB,6.1601E-06_JPRB,7.0815E-06_JPRB,&
&6.4247E-06_JPRB,6.1421E-06_JPRB,1.6600E-05_JPRB/)
KAO( :, 5,13, 1) = (/&
&2.2352E-06_JPRB,2.2950E-06_JPRB,3.3070E-06_JPRB,6.8297E-06_JPRB,6.9887E-06_JPRB,6.7633E-06_JPRB,&
&7.6284E-06_JPRB,7.1420E-06_JPRB,2.4442E-05_JPRB/)
KAO( :, 1, 1, 2) = (/&
&5.4151E-05_JPRB,5.1620E-05_JPRB,4.7151E-05_JPRB,4.1642E-05_JPRB,3.5398E-05_JPRB,2.6235E-05_JPRB,&
&2.1071E-05_JPRB,5.8698E-05_JPRB,2.4321E-05_JPRB/)
KAO( :, 2, 1, 2) = (/&
&6.7514E-05_JPRB,6.4760E-05_JPRB,5.9233E-05_JPRB,5.2524E-05_JPRB,4.5074E-05_JPRB,3.6408E-05_JPRB,&
&2.4335E-05_JPRB,5.6829E-05_JPRB,2.7514E-05_JPRB/)
KAO( :, 3, 1, 2) = (/&
&8.2149E-05_JPRB,7.9291E-05_JPRB,7.2593E-05_JPRB,6.4606E-05_JPRB,5.5728E-05_JPRB,4.6152E-05_JPRB,&
&3.4241E-05_JPRB,4.5420E-05_JPRB,2.4336E-05_JPRB/)
KAO( :, 4, 1, 2) = (/&
&9.7723E-05_JPRB,9.4880E-05_JPRB,8.7232E-05_JPRB,7.7947E-05_JPRB,6.7833E-05_JPRB,5.6842E-05_JPRB,&
&4.4766E-05_JPRB,2.6532E-05_JPRB,2.9870E-05_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.1394E-04_JPRB,1.1139E-04_JPRB,1.0299E-04_JPRB,9.2684E-05_JPRB,8.1155E-05_JPRB,6.8389E-05_JPRB,&
&5.3823E-05_JPRB,3.3217E-05_JPRB,2.3434E-05_JPRB/)
KAO( :, 1, 2, 2) = (/&
&4.2753E-05_JPRB,4.0882E-05_JPRB,3.7362E-05_JPRB,3.3159E-05_JPRB,2.7615E-05_JPRB,1.8637E-05_JPRB,&
&2.2134E-05_JPRB,5.3399E-05_JPRB,1.8302E-05_JPRB/)
KAO( :, 2, 2, 2) = (/&
&5.3879E-05_JPRB,5.1846E-05_JPRB,4.7574E-05_JPRB,4.2472E-05_JPRB,3.6451E-05_JPRB,2.8399E-05_JPRB,&
&1.9335E-05_JPRB,5.2953E-05_JPRB,1.7179E-05_JPRB/)
KAO( :, 3, 2, 2) = (/&
&6.6088E-05_JPRB,6.4132E-05_JPRB,5.9087E-05_JPRB,5.2832E-05_JPRB,4.5668E-05_JPRB,3.7676E-05_JPRB,&
&2.6673E-05_JPRB,4.9047E-05_JPRB,2.0200E-05_JPRB/)
KAO( :, 4, 2, 2) = (/&
&7.9313E-05_JPRB,7.7493E-05_JPRB,7.1541E-05_JPRB,6.4098E-05_JPRB,5.5769E-05_JPRB,4.6664E-05_JPRB,&
&3.6034E-05_JPRB,2.7239E-05_JPRB,1.9971E-05_JPRB/)
KAO( :, 5, 2, 2) = (/&
&9.3172E-05_JPRB,9.1802E-05_JPRB,8.4933E-05_JPRB,7.6462E-05_JPRB,6.6920E-05_JPRB,5.6293E-05_JPRB,&
&4.4283E-05_JPRB,2.5633E-05_JPRB,1.6128E-05_JPRB/)
KAO( :, 1, 3, 2) = (/&
&3.1637E-05_JPRB,3.0177E-05_JPRB,2.7541E-05_JPRB,2.3988E-05_JPRB,1.7787E-05_JPRB,1.3073E-05_JPRB,&
&4.0575E-05_JPRB,4.8194E-05_JPRB,1.2505E-05_JPRB/)
KAO( :, 2, 3, 2) = (/&
&4.0410E-05_JPRB,3.8878E-05_JPRB,3.5667E-05_JPRB,3.1901E-05_JPRB,2.6742E-05_JPRB,1.8595E-05_JPRB,&
&1.9446E-05_JPRB,5.0395E-05_JPRB,1.3203E-05_JPRB/)
KAO( :, 3, 3, 2) = (/&
&5.0197E-05_JPRB,4.8688E-05_JPRB,4.4913E-05_JPRB,4.0333E-05_JPRB,3.4912E-05_JPRB,2.7673E-05_JPRB,&
&1.8085E-05_JPRB,4.8586E-05_JPRB,1.3602E-05_JPRB/)
KAO( :, 4, 3, 2) = (/&
&6.0782E-05_JPRB,5.9537E-05_JPRB,5.5167E-05_JPRB,4.9672E-05_JPRB,4.3304E-05_JPRB,3.6088E-05_JPRB,&
&2.5607E-05_JPRB,4.2696E-05_JPRB,1.2094E-05_JPRB/)
KAO( :, 5, 3, 2) = (/&
&7.2122E-05_JPRB,7.1291E-05_JPRB,6.6301E-05_JPRB,5.9947E-05_JPRB,5.2623E-05_JPRB,4.4244E-05_JPRB,&
&3.4126E-05_JPRB,2.2584E-05_JPRB,1.6766E-05_JPRB/)
KAO( :, 1, 4, 2) = (/&
&2.3214E-05_JPRB,2.2012E-05_JPRB,1.9759E-05_JPRB,1.6356E-05_JPRB,1.1177E-05_JPRB,1.3102E-05_JPRB,&
&5.4531E-05_JPRB,4.5521E-05_JPRB,8.5704E-06_JPRB/)
KAO( :, 2, 4, 2) = (/&
&2.9987E-05_JPRB,2.8729E-05_JPRB,2.6188E-05_JPRB,2.2885E-05_JPRB,1.7414E-05_JPRB,1.2331E-05_JPRB,&
&3.4914E-05_JPRB,4.5109E-05_JPRB,8.5816E-06_JPRB/)
KAO( :, 3, 4, 2) = (/&
&3.7737E-05_JPRB,3.6418E-05_JPRB,3.3481E-05_JPRB,2.9943E-05_JPRB,2.5212E-05_JPRB,1.8076E-05_JPRB,&
&1.7776E-05_JPRB,4.6705E-05_JPRB,7.7341E-06_JPRB/)
KAO( :, 4, 4, 2) = (/&
&4.6237E-05_JPRB,4.5035E-05_JPRB,4.1706E-05_JPRB,3.7594E-05_JPRB,3.2675E-05_JPRB,2.6052E-05_JPRB,&
&1.7191E-05_JPRB,4.4501E-05_JPRB,1.1430E-05_JPRB/)
KAO( :, 5, 4, 2) = (/&
&5.5394E-05_JPRB,5.4566E-05_JPRB,5.0800E-05_JPRB,4.6060E-05_JPRB,4.0396E-05_JPRB,3.3727E-05_JPRB,&
&2.3835E-05_JPRB,3.7336E-05_JPRB,1.6242E-05_JPRB/)
KAO( :, 1, 5, 2) = (/&
&1.7110E-05_JPRB,1.6145E-05_JPRB,1.4165E-05_JPRB,1.0426E-05_JPRB,7.9870E-06_JPRB,2.4744E-05_JPRB,&
&5.4612E-05_JPRB,4.2211E-05_JPRB,5.8558E-06_JPRB/)
KAO( :, 2, 5, 2) = (/&
&2.2350E-05_JPRB,2.1312E-05_JPRB,1.9197E-05_JPRB,1.6194E-05_JPRB,1.1081E-05_JPRB,1.1593E-05_JPRB,&
&4.7643E-05_JPRB,4.2913E-05_JPRB,4.4739E-06_JPRB/)
KAO( :, 3, 5, 2) = (/&
&2.8416E-05_JPRB,2.7289E-05_JPRB,2.4884E-05_JPRB,2.1811E-05_JPRB,1.7120E-05_JPRB,1.1847E-05_JPRB,&
&3.1141E-05_JPRB,4.2424E-05_JPRB,6.9636E-06_JPRB/)
KAO( :, 4, 5, 2) = (/&
&3.5202E-05_JPRB,3.4084E-05_JPRB,3.1336E-05_JPRB,2.8012E-05_JPRB,2.3757E-05_JPRB,1.7453E-05_JPRB,&
&1.5962E-05_JPRB,4.2655E-05_JPRB,1.0597E-05_JPRB/)
KAO( :, 5, 5, 2) = (/&
&4.2592E-05_JPRB,4.1680E-05_JPRB,3.8616E-05_JPRB,3.4875E-05_JPRB,3.0427E-05_JPRB,2.4423E-05_JPRB,&
&1.5902E-05_JPRB,4.0629E-05_JPRB,1.5906E-05_JPRB/)
KAO( :, 1, 6, 2) = (/&
&1.2522E-05_JPRB,1.1758E-05_JPRB,9.8897E-06_JPRB,6.3513E-06_JPRB,1.0585E-05_JPRB,4.0712E-05_JPRB,&
&5.0160E-05_JPRB,4.0760E-05_JPRB,3.1679E-06_JPRB/)
KAO( :, 2, 6, 2) = (/&
&1.6573E-05_JPRB,1.5756E-05_JPRB,1.3865E-05_JPRB,1.0569E-05_JPRB,7.4971E-06_JPRB,2.3617E-05_JPRB,&
&5.0226E-05_JPRB,4.0741E-05_JPRB,3.5969E-06_JPRB/)
KAO( :, 3, 6, 2) = (/&
&2.1308E-05_JPRB,2.0432E-05_JPRB,1.8454E-05_JPRB,1.5643E-05_JPRB,1.0753E-05_JPRB,1.1262E-05_JPRB,&
&4.2958E-05_JPRB,3.9589E-05_JPRB,5.9975E-06_JPRB/)
KAO( :, 4, 6, 2) = (/&
&2.6653E-05_JPRB,2.5731E-05_JPRB,2.3505E-05_JPRB,2.0714E-05_JPRB,1.6401E-05_JPRB,1.1347E-05_JPRB,&
&2.9347E-05_JPRB,3.9364E-05_JPRB,9.7407E-06_JPRB/)
KAO( :, 5, 6, 2) = (/&
&3.2562E-05_JPRB,3.1730E-05_JPRB,2.9223E-05_JPRB,2.6148E-05_JPRB,2.2224E-05_JPRB,1.6477E-05_JPRB,&
&1.5448E-05_JPRB,3.9356E-05_JPRB,1.5151E-05_JPRB/)
KAO( :, 1, 7, 2) = (/&
&9.2632E-06_JPRB,8.5835E-06_JPRB,6.2688E-06_JPRB,5.7491E-06_JPRB,2.0750E-05_JPRB,4.7549E-05_JPRB,&
&4.9746E-05_JPRB,4.3221E-05_JPRB,1.9173E-06_JPRB/)
KAO( :, 2, 7, 2) = (/&
&1.2411E-05_JPRB,1.1741E-05_JPRB,9.9384E-06_JPRB,6.3308E-06_JPRB,9.8932E-06_JPRB,3.7604E-05_JPRB,&
&4.5915E-05_JPRB,3.8224E-05_JPRB,3.1404E-06_JPRB/)
KAO( :, 3, 7, 2) = (/&
&1.6131E-05_JPRB,1.5426E-05_JPRB,1.3668E-05_JPRB,1.0538E-05_JPRB,7.5655E-06_JPRB,2.2395E-05_JPRB,&
&4.5385E-05_JPRB,3.8777E-05_JPRB,5.5259E-06_JPRB/)
KAO( :, 4, 7, 2) = (/&
&2.0394E-05_JPRB,1.9668E-05_JPRB,1.7772E-05_JPRB,1.5135E-05_JPRB,1.0480E-05_JPRB,1.1695E-05_JPRB,&
&3.8455E-05_JPRB,3.6049E-05_JPRB,9.3488E-06_JPRB/)
KAO( :, 5, 7, 2) = (/&
&2.5104E-05_JPRB,2.4438E-05_JPRB,2.2345E-05_JPRB,1.9724E-05_JPRB,1.5920E-05_JPRB,1.0909E-05_JPRB,&
&2.7780E-05_JPRB,3.6976E-05_JPRB,1.5076E-05_JPRB/)
KAO( :, 1, 8, 2) = (/&
&6.9226E-06_JPRB,6.1974E-06_JPRB,3.6925E-06_JPRB,9.7107E-06_JPRB,3.1400E-05_JPRB,5.1217E-05_JPRB,&
&5.1133E-05_JPRB,4.7405E-05_JPRB,1.8023E-06_JPRB/)
KAO( :, 2, 8, 2) = (/&
&9.3730E-06_JPRB,8.7696E-06_JPRB,6.5222E-06_JPRB,5.5338E-06_JPRB,2.0725E-05_JPRB,4.5311E-05_JPRB,&
&4.6330E-05_JPRB,3.9950E-05_JPRB,3.2574E-06_JPRB/)
KAO( :, 3, 8, 2) = (/&
&1.2271E-05_JPRB,1.1705E-05_JPRB,9.9611E-06_JPRB,6.4477E-06_JPRB,1.0502E-05_JPRB,3.6242E-05_JPRB,&
&4.2814E-05_JPRB,3.6156E-05_JPRB,5.9101E-06_JPRB/)
KAO( :, 4, 8, 2) = (/&
&1.5653E-05_JPRB,1.5070E-05_JPRB,1.3408E-05_JPRB,1.0377E-05_JPRB,7.4564E-06_JPRB,2.3003E-05_JPRB,&
&4.1378E-05_JPRB,3.6628E-05_JPRB,1.0378E-05_JPRB/)
KAO( :, 5, 8, 2) = (/&
&1.9451E-05_JPRB,1.8892E-05_JPRB,1.7102E-05_JPRB,1.4623E-05_JPRB,1.0332E-05_JPRB,1.2287E-05_JPRB,&
&3.5601E-05_JPRB,3.3798E-05_JPRB,1.7377E-05_JPRB/)
KAO( :, 1, 9, 2) = (/&
&5.2610E-06_JPRB,4.1633E-06_JPRB,4.0647E-06_JPRB,1.6473E-05_JPRB,4.2753E-05_JPRB,5.1385E-05_JPRB,&
&4.7611E-05_JPRB,4.8409E-05_JPRB,3.6172E-06_JPRB/)
KAO( :, 2, 9, 2) = (/&
&7.1572E-06_JPRB,6.5056E-06_JPRB,3.9269E-06_JPRB,9.8251E-06_JPRB,3.2469E-05_JPRB,4.6277E-05_JPRB,&
&4.7279E-05_JPRB,4.4658E-05_JPRB,6.1285E-06_JPRB/)
KAO( :, 3, 9, 2) = (/&
&9.4513E-06_JPRB,8.9266E-06_JPRB,6.7478E-06_JPRB,5.5531E-06_JPRB,2.0823E-05_JPRB,4.1922E-05_JPRB,&
&4.3117E-05_JPRB,3.6857E-05_JPRB,1.1095E-05_JPRB/)
KAO( :, 4, 9, 2) = (/&
&1.2144E-05_JPRB,1.1656E-05_JPRB,9.9211E-06_JPRB,6.5681E-06_JPRB,1.1366E-05_JPRB,3.4298E-05_JPRB,&
&3.9570E-05_JPRB,3.4386E-05_JPRB,2.0048E-05_JPRB/)
KAO( :, 5, 9, 2) = (/&
&1.5214E-05_JPRB,1.4744E-05_JPRB,1.3136E-05_JPRB,1.0200E-05_JPRB,7.5939E-06_JPRB,2.3119E-05_JPRB,&
&3.7419E-05_JPRB,3.3965E-05_JPRB,3.4968E-05_JPRB/)
KAO( :, 1,10, 2) = (/&
&4.1564E-06_JPRB,2.6079E-06_JPRB,6.9218E-06_JPRB,2.7859E-05_JPRB,4.8834E-05_JPRB,5.2686E-05_JPRB,&
&4.6389E-05_JPRB,4.9087E-05_JPRB,1.0652E-05_JPRB/)
KAO( :, 2,10, 2) = (/&
&5.6598E-06_JPRB,4.6524E-06_JPRB,4.2303E-06_JPRB,1.7606E-05_JPRB,4.1116E-05_JPRB,4.7567E-05_JPRB,&
&4.5264E-05_JPRB,4.6736E-05_JPRB,1.6225E-05_JPRB/)
KAO( :, 3,10, 2) = (/&
&7.4935E-06_JPRB,6.8980E-06_JPRB,4.2539E-06_JPRB,1.0638E-05_JPRB,3.2709E-05_JPRB,4.2416E-05_JPRB,&
&4.4544E-05_JPRB,4.1212E-05_JPRB,2.8258E-05_JPRB/)
KAO( :, 4,10, 2) = (/&
&9.6635E-06_JPRB,9.2067E-06_JPRB,7.0228E-06_JPRB,5.8835E-06_JPRB,2.2271E-05_JPRB,3.9179E-05_JPRB,&
&4.0535E-05_JPRB,3.4910E-05_JPRB,5.1242E-05_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.2158E-05_JPRB,1.1756E-05_JPRB,1.0040E-05_JPRB,6.8113E-06_JPRB,1.2737E-05_JPRB,3.2445E-05_JPRB,&
&3.6666E-05_JPRB,3.2986E-05_JPRB,9.1455E-05_JPRB/)
KAO( :, 1,11, 2) = (/&
&3.8505E-06_JPRB,2.2272E-06_JPRB,9.0452E-06_JPRB,3.3373E-05_JPRB,4.6563E-05_JPRB,5.1119E-05_JPRB,&
&4.6293E-05_JPRB,4.7828E-05_JPRB,1.4850E-05_JPRB/)
KAO( :, 2,11, 2) = (/&
&5.1974E-06_JPRB,4.0087E-06_JPRB,5.3940E-06_JPRB,2.3158E-05_JPRB,4.1599E-05_JPRB,4.6146E-05_JPRB,&
&4.2299E-05_JPRB,4.6208E-05_JPRB,2.2452E-05_JPRB/)
KAO( :, 3,11, 2) = (/&
&6.8266E-06_JPRB,6.1648E-06_JPRB,4.0224E-06_JPRB,1.4825E-05_JPRB,3.4779E-05_JPRB,4.0817E-05_JPRB,&
&4.2127E-05_JPRB,4.1473E-05_JPRB,3.8968E-05_JPRB/)
KAO( :, 4,11, 2) = (/&
&8.7559E-06_JPRB,8.2911E-06_JPRB,5.8154E-06_JPRB,8.1179E-06_JPRB,2.7292E-05_JPRB,3.7470E-05_JPRB,&
&3.8829E-05_JPRB,3.4450E-05_JPRB,7.0589E-05_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.0954E-05_JPRB,1.0574E-05_JPRB,8.7742E-06_JPRB,6.0446E-06_JPRB,1.8157E-05_JPRB,3.3048E-05_JPRB,&
&3.5168E-05_JPRB,3.1159E-05_JPRB,1.2578E-04_JPRB/)
KAO( :, 1,12, 2) = (/&
&3.5781E-06_JPRB,2.0859E-06_JPRB,9.5195E-06_JPRB,3.1787E-05_JPRB,4.2342E-05_JPRB,4.6653E-05_JPRB,&
&4.2689E-05_JPRB,4.4370E-05_JPRB,1.5650E-05_JPRB/)
KAO( :, 2,12, 2) = (/&
&4.8068E-06_JPRB,3.6887E-06_JPRB,5.7939E-06_JPRB,2.3796E-05_JPRB,3.7779E-05_JPRB,4.1997E-05_JPRB,&
&3.8426E-05_JPRB,4.2634E-05_JPRB,2.3652E-05_JPRB/)
KAO( :, 3,12, 2) = (/&
&6.2948E-06_JPRB,5.6556E-06_JPRB,3.7630E-06_JPRB,1.5847E-05_JPRB,3.2542E-05_JPRB,3.7297E-05_JPRB,&
&3.8083E-05_JPRB,3.7879E-05_JPRB,4.1024E-05_JPRB/)
KAO( :, 4,12, 2) = (/&
&8.0397E-06_JPRB,7.5827E-06_JPRB,5.0870E-06_JPRB,9.0305E-06_JPRB,2.6555E-05_JPRB,3.3515E-05_JPRB,&
&3.5502E-05_JPRB,3.1529E-05_JPRB,7.4223E-05_JPRB/)
KAO( :, 5,12, 2) = (/&
&1.0028E-05_JPRB,9.6397E-06_JPRB,7.9012E-06_JPRB,5.7864E-06_JPRB,1.8461E-05_JPRB,3.0406E-05_JPRB,&
&3.2113E-05_JPRB,2.8581E-05_JPRB,1.3214E-04_JPRB/)
KAO( :, 1,13, 2) = (/&
&3.3027E-06_JPRB,1.9849E-06_JPRB,1.0579E-05_JPRB,3.0102E-05_JPRB,3.8661E-05_JPRB,4.2078E-05_JPRB,&
&3.9451E-05_JPRB,4.0882E-05_JPRB,1.3351E-05_JPRB/)
KAO( :, 2,13, 2) = (/&
&4.4219E-06_JPRB,3.3751E-06_JPRB,6.3222E-06_JPRB,2.3724E-05_JPRB,3.3992E-05_JPRB,3.8161E-05_JPRB,&
&3.4651E-05_JPRB,3.8910E-05_JPRB,2.0209E-05_JPRB/)
KAO( :, 3,13, 2) = (/&
&5.7740E-06_JPRB,5.1371E-06_JPRB,3.6294E-06_JPRB,1.6612E-05_JPRB,3.0054E-05_JPRB,3.4084E-05_JPRB,&
&3.4363E-05_JPRB,3.4522E-05_JPRB,3.5082E-05_JPRB/)
KAO( :, 4,13, 2) = (/&
&7.3436E-06_JPRB,6.8959E-06_JPRB,4.5387E-06_JPRB,1.0066E-05_JPRB,2.5028E-05_JPRB,3.0345E-05_JPRB,&
&3.2120E-05_JPRB,2.8785E-05_JPRB,6.3433E-05_JPRB/)
KAO( :, 5,13, 2) = (/&
&9.1271E-06_JPRB,8.7491E-06_JPRB,7.0983E-06_JPRB,6.0072E-06_JPRB,1.8622E-05_JPRB,2.7834E-05_JPRB,&
&2.8936E-05_JPRB,2.5906E-05_JPRB,1.1287E-04_JPRB/)
KAO( :, 1, 1, 3) = (/&
&1.0561E-04_JPRB,9.9580E-05_JPRB,9.1881E-05_JPRB,8.2381E-05_JPRB,7.1375E-05_JPRB,5.7989E-05_JPRB,&
&3.5664E-05_JPRB,6.4412E-05_JPRB,3.1092E-05_JPRB/)
KAO( :, 2, 1, 3) = (/&
&1.2338E-04_JPRB,1.1773E-04_JPRB,1.0902E-04_JPRB,9.8327E-05_JPRB,8.5823E-05_JPRB,7.1198E-05_JPRB,&
&5.2267E-05_JPRB,4.7983E-05_JPRB,3.3217E-05_JPRB/)
KAO( :, 3, 1, 3) = (/&
&1.4195E-04_JPRB,1.3687E-04_JPRB,1.2720E-04_JPRB,1.1513E-04_JPRB,1.0071E-04_JPRB,8.3744E-05_JPRB,&
&6.2834E-05_JPRB,3.3890E-05_JPRB,3.3867E-05_JPRB/)
KAO( :, 4, 1, 3) = (/&
&1.6072E-04_JPRB,1.5621E-04_JPRB,1.4581E-04_JPRB,1.3254E-04_JPRB,1.1572E-04_JPRB,9.6056E-05_JPRB,&
&7.3269E-05_JPRB,4.4619E-05_JPRB,2.4444E-05_JPRB/)
KAO( :, 5, 1, 3) = (/&
&1.7870E-04_JPRB,1.7588E-04_JPRB,1.6519E-04_JPRB,1.5017E-04_JPRB,1.3146E-04_JPRB,1.0980E-04_JPRB,&
&8.4775E-05_JPRB,5.5831E-05_JPRB,2.9607E-05_JPRB/)
KAO( :, 1, 2, 3) = (/&
&9.0935E-05_JPRB,8.5722E-05_JPRB,7.8558E-05_JPRB,6.9752E-05_JPRB,5.9712E-05_JPRB,4.7385E-05_JPRB,&
&2.8063E-05_JPRB,6.1629E-05_JPRB,2.1541E-05_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.0613E-04_JPRB,1.0109E-04_JPRB,9.2923E-05_JPRB,8.2896E-05_JPRB,7.1836E-05_JPRB,5.9001E-05_JPRB,&
&4.0531E-05_JPRB,5.4238E-05_JPRB,2.6282E-05_JPRB/)
KAO( :, 3, 2, 3) = (/&
&1.2220E-04_JPRB,1.1726E-04_JPRB,1.0800E-04_JPRB,9.6883E-05_JPRB,8.4549E-05_JPRB,7.0132E-05_JPRB,&
&5.2211E-05_JPRB,3.5371E-05_JPRB,2.0831E-05_JPRB/)
KAO( :, 4, 2, 3) = (/&
&1.3840E-04_JPRB,1.3383E-04_JPRB,1.2384E-04_JPRB,1.1185E-04_JPRB,9.7762E-05_JPRB,8.1196E-05_JPRB,&
&6.1844E-05_JPRB,3.5901E-05_JPRB,1.8797E-05_JPRB/)
KAO( :, 5, 2, 3) = (/&
&1.5419E-04_JPRB,1.5072E-04_JPRB,1.4069E-04_JPRB,1.2749E-04_JPRB,1.1156E-04_JPRB,9.3151E-05_JPRB,&
&7.1896E-05_JPRB,4.6407E-05_JPRB,2.8564E-05_JPRB/)
KAO( :, 1, 3, 3) = (/&
&7.5234E-05_JPRB,7.0905E-05_JPRB,6.4619E-05_JPRB,5.6937E-05_JPRB,4.7925E-05_JPRB,3.4057E-05_JPRB,&
&2.9471E-05_JPRB,6.0714E-05_JPRB,1.5353E-05_JPRB/)
KAO( :, 2, 3, 3) = (/&
&8.8054E-05_JPRB,8.3720E-05_JPRB,7.6548E-05_JPRB,6.7694E-05_JPRB,5.7920E-05_JPRB,4.6422E-05_JPRB,&
&2.6506E-05_JPRB,5.8794E-05_JPRB,1.3222E-05_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.0142E-04_JPRB,9.7129E-05_JPRB,8.9011E-05_JPRB,7.9094E-05_JPRB,6.8344E-05_JPRB,5.6044E-05_JPRB,&
&3.9469E-05_JPRB,4.5819E-05_JPRB,1.2529E-05_JPRB/)
KAO( :, 4, 3, 3) = (/&
&1.1514E-04_JPRB,1.1089E-04_JPRB,1.0189E-04_JPRB,9.1196E-05_JPRB,7.9328E-05_JPRB,6.5564E-05_JPRB,&
&4.9536E-05_JPRB,2.9992E-05_JPRB,2.0006E-05_JPRB/)
KAO( :, 5, 3, 3) = (/&
&1.2867E-04_JPRB,1.2511E-04_JPRB,1.1573E-04_JPRB,1.0413E-04_JPRB,9.0747E-05_JPRB,7.5488E-05_JPRB,&
&5.8137E-05_JPRB,3.3705E-05_JPRB,2.9649E-05_JPRB/)
KAO( :, 1, 4, 3) = (/&
&6.1778E-05_JPRB,5.8294E-05_JPRB,5.2798E-05_JPRB,4.6202E-05_JPRB,3.7473E-05_JPRB,2.1169E-05_JPRB,&
&3.9527E-05_JPRB,6.1900E-05_JPRB,9.6628E-06_JPRB/)
KAO( :, 2, 4, 3) = (/&
&7.2880E-05_JPRB,6.9141E-05_JPRB,6.2841E-05_JPRB,5.5219E-05_JPRB,4.6442E-05_JPRB,3.4307E-05_JPRB,&
&2.4540E-05_JPRB,5.8099E-05_JPRB,8.2774E-06_JPRB/)
KAO( :, 3, 4, 3) = (/&
&8.4189E-05_JPRB,8.0422E-05_JPRB,7.3326E-05_JPRB,6.4671E-05_JPRB,5.5214E-05_JPRB,4.4201E-05_JPRB,&
&2.5763E-05_JPRB,5.4305E-05_JPRB,1.4320E-05_JPRB/)
KAO( :, 4, 4, 3) = (/&
&9.5731E-05_JPRB,9.1993E-05_JPRB,8.4010E-05_JPRB,7.4439E-05_JPRB,6.4080E-05_JPRB,5.2536E-05_JPRB,&
&3.7772E-05_JPRB,4.0812E-05_JPRB,2.1667E-05_JPRB/)
KAO( :, 5, 4, 3) = (/&
&1.0722E-04_JPRB,1.0376E-04_JPRB,9.5138E-05_JPRB,8.4789E-05_JPRB,7.3585E-05_JPRB,6.0982E-05_JPRB,&
&4.6442E-05_JPRB,2.6775E-05_JPRB,3.0897E-05_JPRB/)
KAO( :, 1, 5, 3) = (/&
&5.0693E-05_JPRB,4.7899E-05_JPRB,4.3078E-05_JPRB,3.7149E-05_JPRB,2.7343E-05_JPRB,1.8823E-05_JPRB,&
&5.3113E-05_JPRB,6.4247E-05_JPRB,5.8413E-06_JPRB/)
KAO( :, 2, 5, 3) = (/&
&6.0292E-05_JPRB,5.7244E-05_JPRB,5.1699E-05_JPRB,4.5062E-05_JPRB,3.6934E-05_JPRB,2.2807E-05_JPRB,&
&3.5085E-05_JPRB,5.8430E-05_JPRB,9.0461E-06_JPRB/)
KAO( :, 3, 5, 3) = (/&
&7.0130E-05_JPRB,6.6900E-05_JPRB,6.0628E-05_JPRB,5.3145E-05_JPRB,4.4673E-05_JPRB,3.3772E-05_JPRB,&
&2.2961E-05_JPRB,5.4725E-05_JPRB,1.4542E-05_JPRB/)
KAO( :, 4, 5, 3) = (/&
&7.9880E-05_JPRB,7.6664E-05_JPRB,6.9684E-05_JPRB,6.1301E-05_JPRB,5.2150E-05_JPRB,4.1916E-05_JPRB,&
&2.5438E-05_JPRB,4.9130E-05_JPRB,2.2207E-05_JPRB/)
KAO( :, 5, 5, 3) = (/&
&8.9549E-05_JPRB,8.6422E-05_JPRB,7.8834E-05_JPRB,6.9694E-05_JPRB,5.9898E-05_JPRB,4.9265E-05_JPRB,&
&3.5529E-05_JPRB,3.7520E-05_JPRB,3.2469E-05_JPRB/)
KAO( :, 1, 6, 3) = (/&
&4.1241E-05_JPRB,3.8825E-05_JPRB,3.4760E-05_JPRB,2.8889E-05_JPRB,1.6124E-05_JPRB,2.3998E-05_JPRB,&
&6.9344E-05_JPRB,6.4810E-05_JPRB,4.4340E-06_JPRB/)
KAO( :, 2, 6, 3) = (/&
&4.9399E-05_JPRB,4.6917E-05_JPRB,4.2198E-05_JPRB,3.6346E-05_JPRB,2.7704E-05_JPRB,1.8853E-05_JPRB,&
&4.8135E-05_JPRB,6.0892E-05_JPRB,8.2681E-06_JPRB/)
KAO( :, 3, 6, 3) = (/&
&5.7861E-05_JPRB,5.5206E-05_JPRB,4.9718E-05_JPRB,4.3299E-05_JPRB,3.5690E-05_JPRB,2.2202E-05_JPRB,&
&3.1528E-05_JPRB,5.5484E-05_JPRB,1.3906E-05_JPRB/)
KAO( :, 4, 6, 3) = (/&
&6.6294E-05_JPRB,6.3463E-05_JPRB,5.7396E-05_JPRB,5.0239E-05_JPRB,4.2302E-05_JPRB,3.1945E-05_JPRB,&
&2.0634E-05_JPRB,5.2274E-05_JPRB,2.1920E-05_JPRB/)
KAO( :, 5, 6, 3) = (/&
&7.4664E-05_JPRB,7.1784E-05_JPRB,6.5151E-05_JPRB,5.7238E-05_JPRB,4.8740E-05_JPRB,3.9314E-05_JPRB,&
&2.3437E-05_JPRB,4.4846E-05_JPRB,3.3007E-05_JPRB/)
KAO( :, 1, 7, 3) = (/&
&3.3565E-05_JPRB,3.1356E-05_JPRB,2.7729E-05_JPRB,1.9350E-05_JPRB,1.4415E-05_JPRB,3.7753E-05_JPRB,&
&7.9102E-05_JPRB,6.2223E-05_JPRB,4.1072E-06_JPRB/)
KAO( :, 2, 7, 3) = (/&
&4.0432E-05_JPRB,3.8210E-05_JPRB,3.4263E-05_JPRB,2.8707E-05_JPRB,1.6576E-05_JPRB,2.4516E-05_JPRB,&
&6.1614E-05_JPRB,6.3419E-05_JPRB,8.0365E-06_JPRB/)
KAO( :, 3, 7, 3) = (/&
&4.7650E-05_JPRB,4.5423E-05_JPRB,4.0777E-05_JPRB,3.5184E-05_JPRB,2.7131E-05_JPRB,1.8290E-05_JPRB,&
&4.3600E-05_JPRB,5.7557E-05_JPRB,1.3883E-05_JPRB/)
KAO( :, 4, 7, 3) = (/&
&5.4916E-05_JPRB,5.2553E-05_JPRB,4.7306E-05_JPRB,4.1198E-05_JPRB,3.3969E-05_JPRB,2.0841E-05_JPRB,&
&2.8970E-05_JPRB,5.2203E-05_JPRB,2.2718E-05_JPRB/)
KAO( :, 5, 7, 3) = (/&
&6.2191E-05_JPRB,5.9624E-05_JPRB,5.3859E-05_JPRB,4.7059E-05_JPRB,3.9626E-05_JPRB,3.0110E-05_JPRB,&
&1.8574E-05_JPRB,4.8026E-05_JPRB,3.5441E-05_JPRB/)
KAO( :, 1, 8, 3) = (/&
&2.7226E-05_JPRB,2.5212E-05_JPRB,2.1382E-05_JPRB,1.0543E-05_JPRB,2.2029E-05_JPRB,5.3627E-05_JPRB,&
&8.2097E-05_JPRB,5.8785E-05_JPRB,4.6971E-06_JPRB/)
KAO( :, 2, 8, 3) = (/&
&3.3008E-05_JPRB,3.0976E-05_JPRB,2.7464E-05_JPRB,1.9851E-05_JPRB,1.5586E-05_JPRB,3.6260E-05_JPRB,&
&7.0608E-05_JPRB,6.2688E-05_JPRB,9.0473E-06_JPRB/)
KAO( :, 3, 8, 3) = (/&
&3.9152E-05_JPRB,3.7119E-05_JPRB,3.3223E-05_JPRB,2.7933E-05_JPRB,1.6165E-05_JPRB,2.3754E-05_JPRB,&
&5.6757E-05_JPRB,6.1667E-05_JPRB,1.6403E-05_JPRB/)
KAO( :, 4, 8, 3) = (/&
&4.5401E-05_JPRB,4.3320E-05_JPRB,3.8890E-05_JPRB,3.3512E-05_JPRB,2.5986E-05_JPRB,1.7686E-05_JPRB,&
&4.1699E-05_JPRB,5.5000E-05_JPRB,2.8038E-05_JPRB/)
KAO( :, 5, 8, 3) = (/&
&5.1574E-05_JPRB,4.9405E-05_JPRB,4.4463E-05_JPRB,3.8672E-05_JPRB,3.1838E-05_JPRB,1.9274E-05_JPRB,&
&2.7957E-05_JPRB,4.8608E-05_JPRB,4.5414E-05_JPRB/)
KAO( :, 1, 9, 3) = (/&
&2.1974E-05_JPRB,2.0130E-05_JPRB,1.3358E-05_JPRB,1.2253E-05_JPRB,3.2656E-05_JPRB,7.0337E-05_JPRB,&
&8.9242E-05_JPRB,5.7837E-05_JPRB,9.3121E-06_JPRB/)
KAO( :, 2, 9, 3) = (/&
&2.6942E-05_JPRB,2.5061E-05_JPRB,2.1391E-05_JPRB,1.1226E-05_JPRB,2.1710E-05_JPRB,5.1789E-05_JPRB,&
&7.4746E-05_JPRB,5.8409E-05_JPRB,1.8445E-05_JPRB/)
KAO( :, 3, 9, 3) = (/&
&3.2174E-05_JPRB,3.0300E-05_JPRB,2.6794E-05_JPRB,1.9848E-05_JPRB,1.5650E-05_JPRB,3.5796E-05_JPRB,&
&6.3518E-05_JPRB,6.2556E-05_JPRB,3.5097E-05_JPRB/)
KAO( :, 4, 9, 3) = (/&
&3.7549E-05_JPRB,3.5640E-05_JPRB,3.1882E-05_JPRB,2.6804E-05_JPRB,1.5301E-05_JPRB,2.3066E-05_JPRB,&
&5.1951E-05_JPRB,5.9042E-05_JPRB,6.2870E-05_JPRB/)
KAO( :, 5, 9, 3) = (/&
&4.2852E-05_JPRB,4.0889E-05_JPRB,3.6715E-05_JPRB,3.1666E-05_JPRB,2.4183E-05_JPRB,1.7177E-05_JPRB,&
&4.0166E-05_JPRB,5.1290E-05_JPRB,1.0621E-04_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.7885E-05_JPRB,1.6093E-05_JPRB,7.4609E-06_JPRB,1.9809E-05_JPRB,4.8743E-05_JPRB,8.4191E-05_JPRB,&
&9.7811E-05_JPRB,5.7087E-05_JPRB,2.4684E-05_JPRB/)
KAO( :, 2,10, 3) = (/&
&2.2205E-05_JPRB,2.0473E-05_JPRB,1.4192E-05_JPRB,1.3653E-05_JPRB,3.3673E-05_JPRB,6.6332E-05_JPRB,&
&8.1889E-05_JPRB,5.8933E-05_JPRB,4.8726E-05_JPRB/)
KAO( :, 3,10, 3) = (/&
&2.6710E-05_JPRB,2.4979E-05_JPRB,2.1384E-05_JPRB,1.1205E-05_JPRB,2.2836E-05_JPRB,5.0904E-05_JPRB,&
&6.7817E-05_JPRB,6.0017E-05_JPRB,9.5318E-05_JPRB/)
KAO( :, 4,10, 3) = (/&
&3.1308E-05_JPRB,2.9540E-05_JPRB,2.6146E-05_JPRB,1.9462E-05_JPRB,1.5742E-05_JPRB,3.6775E-05_JPRB,&
&5.7447E-05_JPRB,6.0670E-05_JPRB,1.7750E-04_JPRB/)
KAO( :, 5,10, 3) = (/&
&3.5884E-05_JPRB,3.4076E-05_JPRB,3.0469E-05_JPRB,2.5574E-05_JPRB,1.4532E-05_JPRB,2.3848E-05_JPRB,&
&4.8505E-05_JPRB,5.5852E-05_JPRB,3.1067E-04_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.6247E-05_JPRB,1.4357E-05_JPRB,6.7662E-06_JPRB,2.3639E-05_JPRB,5.5683E-05_JPRB,8.1956E-05_JPRB,&
&9.4483E-05_JPRB,5.8077E-05_JPRB,3.4483E-05_JPRB/)
KAO( :, 2,11, 3) = (/&
&2.0083E-05_JPRB,1.8438E-05_JPRB,1.1223E-05_JPRB,1.6583E-05_JPRB,3.8809E-05_JPRB,6.7379E-05_JPRB,&
&8.0717E-05_JPRB,5.8833E-05_JPRB,6.8180E-05_JPRB/)
KAO( :, 3,11, 3) = (/&
&2.4035E-05_JPRB,2.2414E-05_JPRB,1.8252E-05_JPRB,1.1545E-05_JPRB,2.7168E-05_JPRB,5.4230E-05_JPRB,&
&6.6296E-05_JPRB,5.8218E-05_JPRB,1.3381E-04_JPRB/)
KAO( :, 4,11, 3) = (/&
&2.8028E-05_JPRB,2.6371E-05_JPRB,2.3077E-05_JPRB,1.4565E-05_JPRB,1.8361E-05_JPRB,4.2537E-05_JPRB,&
&5.6345E-05_JPRB,5.9076E-05_JPRB,2.5000E-04_JPRB/)
KAO( :, 5,11, 3) = (/&
&3.1996E-05_JPRB,3.0330E-05_JPRB,2.7020E-05_JPRB,2.1917E-05_JPRB,1.3395E-05_JPRB,2.9523E-05_JPRB,&
&4.8541E-05_JPRB,5.5094E-05_JPRB,4.3853E-04_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.4787E-05_JPRB,1.2868E-05_JPRB,7.7779E-06_JPRB,2.3775E-05_JPRB,5.3535E-05_JPRB,7.5004E-05_JPRB,&
&8.6201E-05_JPRB,6.0383E-05_JPRB,3.6484E-05_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.8188E-05_JPRB,1.6624E-05_JPRB,9.6989E-06_JPRB,1.6809E-05_JPRB,3.8801E-05_JPRB,6.1756E-05_JPRB,&
&7.3880E-05_JPRB,5.7828E-05_JPRB,7.2267E-05_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.1698E-05_JPRB,2.0162E-05_JPRB,1.6039E-05_JPRB,1.1681E-05_JPRB,2.6941E-05_JPRB,5.0140E-05_JPRB,&
&6.0455E-05_JPRB,5.6955E-05_JPRB,1.4213E-04_JPRB/)
KAO( :, 4,12, 3) = (/&
&2.5223E-05_JPRB,2.3667E-05_JPRB,2.0595E-05_JPRB,1.1968E-05_JPRB,1.8179E-05_JPRB,4.0062E-05_JPRB,&
&5.0860E-05_JPRB,5.5338E-05_JPRB,2.6585E-04_JPRB/)
KAO( :, 5,12, 3) = (/&
&2.8679E-05_JPRB,2.7160E-05_JPRB,2.4085E-05_JPRB,1.8993E-05_JPRB,1.3232E-05_JPRB,3.0080E-05_JPRB,&
&4.4162E-05_JPRB,5.0190E-05_JPRB,4.6593E-04_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.3378E-05_JPRB,1.1412E-05_JPRB,8.0344E-06_JPRB,2.3863E-05_JPRB,5.0631E-05_JPRB,6.7851E-05_JPRB,&
&7.7279E-05_JPRB,5.9944E-05_JPRB,3.1248E-05_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.6405E-05_JPRB,1.4918E-05_JPRB,8.1452E-06_JPRB,1.7072E-05_JPRB,3.8399E-05_JPRB,5.6349E-05_JPRB,&
&6.7351E-05_JPRB,5.6397E-05_JPRB,6.1993E-05_JPRB/)
KAO( :, 3,13, 3) = (/&
&1.9514E-05_JPRB,1.8083E-05_JPRB,1.3959E-05_JPRB,1.1780E-05_JPRB,2.7506E-05_JPRB,4.6033E-05_JPRB,&
&5.5011E-05_JPRB,5.3246E-05_JPRB,1.2205E-04_JPRB/)
KAO( :, 4,13, 3) = (/&
&2.2612E-05_JPRB,2.1175E-05_JPRB,1.8198E-05_JPRB,9.8216E-06_JPRB,1.8940E-05_JPRB,3.7116E-05_JPRB,&
&4.6044E-05_JPRB,5.0287E-05_JPRB,2.2822E-04_JPRB/)
KAO( :, 5,13, 3) = (/&
&2.5652E-05_JPRB,2.4254E-05_JPRB,2.1392E-05_JPRB,1.5930E-05_JPRB,1.2761E-05_JPRB,2.9362E-05_JPRB,&
&4.0037E-05_JPRB,4.5639E-05_JPRB,3.9941E-04_JPRB/)
KAO( :, 1, 1, 4) = (/&
&1.9325E-04_JPRB,1.8065E-04_JPRB,1.6180E-04_JPRB,1.4199E-04_JPRB,1.2006E-04_JPRB,9.6342E-05_JPRB,&
&6.5622E-05_JPRB,4.8423E-05_JPRB,3.6972E-05_JPRB/)
KAO( :, 2, 1, 4) = (/&
&2.0819E-04_JPRB,1.9606E-04_JPRB,1.7737E-04_JPRB,1.5604E-04_JPRB,1.3291E-04_JPRB,1.0794E-04_JPRB,&
&7.9216E-05_JPRB,4.1605E-05_JPRB,3.5731E-05_JPRB/)
KAO( :, 3, 1, 4) = (/&
&2.2206E-04_JPRB,2.1170E-04_JPRB,1.9336E-04_JPRB,1.7130E-04_JPRB,1.4701E-04_JPRB,1.2089E-04_JPRB,&
&9.0968E-05_JPRB,4.3271E-05_JPRB,3.0303E-05_JPRB/)
KAO( :, 4, 1, 4) = (/&
&2.3676E-04_JPRB,2.2953E-04_JPRB,2.1085E-04_JPRB,1.8785E-04_JPRB,1.6294E-04_JPRB,1.3496E-04_JPRB,&
&1.0281E-04_JPRB,6.1284E-05_JPRB,3.2172E-05_JPRB/)
KAO( :, 5, 1, 4) = (/&
&2.5437E-04_JPRB,2.4947E-04_JPRB,2.3011E-04_JPRB,2.0700E-04_JPRB,1.8097E-04_JPRB,1.5051E-04_JPRB,&
&1.1633E-04_JPRB,7.7203E-05_JPRB,5.3094E-05_JPRB/)
KAO( :, 1, 2, 4) = (/&
&1.7573E-04_JPRB,1.6392E-04_JPRB,1.4659E-04_JPRB,1.2809E-04_JPRB,1.0782E-04_JPRB,8.5648E-05_JPRB,&
&5.2006E-05_JPRB,5.2667E-05_JPRB,2.6840E-05_JPRB/)
KAO( :, 2, 2, 4) = (/&
&1.8913E-04_JPRB,1.7769E-04_JPRB,1.6041E-04_JPRB,1.4067E-04_JPRB,1.1911E-04_JPRB,9.5721E-05_JPRB,&
&6.8639E-05_JPRB,4.4992E-05_JPRB,2.4069E-05_JPRB/)
KAO( :, 3, 2, 4) = (/&
&2.0133E-04_JPRB,1.9150E-04_JPRB,1.7426E-04_JPRB,1.5374E-04_JPRB,1.3095E-04_JPRB,1.0674E-04_JPRB,&
&7.9754E-05_JPRB,3.2688E-05_JPRB,1.8110E-05_JPRB/)
KAO( :, 4, 2, 4) = (/&
&2.1403E-04_JPRB,2.0644E-04_JPRB,1.8885E-04_JPRB,1.6750E-04_JPRB,1.4394E-04_JPRB,1.1875E-04_JPRB,&
&8.9867E-05_JPRB,4.7809E-05_JPRB,3.1086E-05_JPRB/)
KAO( :, 5, 2, 4) = (/&
&2.2856E-04_JPRB,2.2298E-04_JPRB,2.0481E-04_JPRB,1.8286E-04_JPRB,1.5862E-04_JPRB,1.3164E-04_JPRB,&
&1.0114E-04_JPRB,6.3503E-05_JPRB,4.8865E-05_JPRB/)
KAO( :, 1, 3, 4) = (/&
&1.5562E-04_JPRB,1.4484E-04_JPRB,1.2927E-04_JPRB,1.1236E-04_JPRB,9.3995E-05_JPRB,7.3269E-05_JPRB,&
&3.7797E-05_JPRB,5.7431E-05_JPRB,1.5095E-05_JPRB/)
KAO( :, 2, 3, 4) = (/&
&1.6743E-04_JPRB,1.5710E-04_JPRB,1.4113E-04_JPRB,1.2321E-04_JPRB,1.0375E-04_JPRB,8.2299E-05_JPRB,&
&5.2915E-05_JPRB,4.4705E-05_JPRB,1.4179E-05_JPRB/)
KAO( :, 3, 3, 4) = (/&
&1.7855E-04_JPRB,1.6918E-04_JPRB,1.5296E-04_JPRB,1.3430E-04_JPRB,1.1381E-04_JPRB,9.1766E-05_JPRB,&
&6.6891E-05_JPRB,3.9451E-05_JPRB,2.0319E-05_JPRB/)
KAO( :, 4, 3, 4) = (/&
&1.8934E-04_JPRB,1.8180E-04_JPRB,1.6533E-04_JPRB,1.4585E-04_JPRB,1.2452E-04_JPRB,1.0168E-04_JPRB,&
&7.6248E-05_JPRB,3.2208E-05_JPRB,3.3927E-05_JPRB/)
KAO( :, 5, 3, 4) = (/&
&2.0107E-04_JPRB,1.9484E-04_JPRB,1.7806E-04_JPRB,1.5818E-04_JPRB,1.3631E-04_JPRB,1.1252E-04_JPRB,&
&8.5478E-05_JPRB,4.8964E-05_JPRB,4.8647E-05_JPRB/)
KAO( :, 1, 4, 4) = (/&
&1.3687E-04_JPRB,1.2644E-04_JPRB,1.1299E-04_JPRB,9.7757E-05_JPRB,8.1171E-05_JPRB,6.0079E-05_JPRB,&
&3.3581E-05_JPRB,5.5796E-05_JPRB,9.0880E-06_JPRB/)
KAO( :, 2, 4, 4) = (/&
&1.4693E-04_JPRB,1.3749E-04_JPRB,1.2327E-04_JPRB,1.0708E-04_JPRB,8.9715E-05_JPRB,7.0113E-05_JPRB,&
&3.5389E-05_JPRB,5.3371E-05_JPRB,1.3014E-05_JPRB/)
KAO( :, 3, 4, 4) = (/&
&1.5672E-04_JPRB,1.4837E-04_JPRB,1.3344E-04_JPRB,1.1660E-04_JPRB,9.8197E-05_JPRB,7.8371E-05_JPRB,&
&5.1608E-05_JPRB,4.1358E-05_JPRB,2.3902E-05_JPRB/)
KAO( :, 4, 4, 4) = (/&
&1.6639E-04_JPRB,1.5936E-04_JPRB,1.4405E-04_JPRB,1.2651E-04_JPRB,1.0733E-04_JPRB,8.6606E-05_JPRB,&
&6.3258E-05_JPRB,3.2371E-05_JPRB,3.6595E-05_JPRB/)
KAO( :, 5, 4, 4) = (/&
&1.7628E-04_JPRB,1.7040E-04_JPRB,1.5502E-04_JPRB,1.3697E-04_JPRB,1.1689E-04_JPRB,9.5499E-05_JPRB,&
&7.1870E-05_JPRB,3.2326E-05_JPRB,5.1692E-05_JPRB/)
KAO( :, 1, 5, 4) = (/&
&1.2014E-04_JPRB,1.0999E-04_JPRB,9.8155E-05_JPRB,8.4680E-05_JPRB,6.9013E-05_JPRB,3.7866E-05_JPRB,&
&4.6216E-05_JPRB,5.4078E-05_JPRB,7.0562E-06_JPRB/)
KAO( :, 2, 5, 4) = (/&
&1.2869E-04_JPRB,1.1940E-04_JPRB,1.0711E-04_JPRB,9.2677E-05_JPRB,7.7027E-05_JPRB,5.7820E-05_JPRB,&
&3.1601E-05_JPRB,5.4237E-05_JPRB,1.5420E-05_JPRB/)
KAO( :, 3, 5, 4) = (/&
&1.3705E-04_JPRB,1.2928E-04_JPRB,1.1605E-04_JPRB,1.0090E-04_JPRB,8.4608E-05_JPRB,6.6395E-05_JPRB,&
&3.0335E-05_JPRB,4.8756E-05_JPRB,2.5527E-05_JPRB/)
KAO( :, 4, 5, 4) = (/&
&1.4539E-04_JPRB,1.3907E-04_JPRB,1.2508E-04_JPRB,1.0941E-04_JPRB,9.2394E-05_JPRB,7.3775E-05_JPRB,&
&4.9339E-05_JPRB,4.0777E-05_JPRB,3.8427E-05_JPRB/)
KAO( :, 5, 5, 4) = (/&
&1.5402E-04_JPRB,1.4864E-04_JPRB,1.3443E-04_JPRB,1.1832E-04_JPRB,1.0042E-04_JPRB,8.1145E-05_JPRB,&
&5.9883E-05_JPRB,2.8598E-05_JPRB,5.5173E-05_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.0508E-04_JPRB,9.5482E-05_JPRB,8.4601E-05_JPRB,7.2633E-05_JPRB,5.7469E-05_JPRB,2.8022E-05_JPRB,&
&6.0470E-05_JPRB,5.5709E-05_JPRB,8.4537E-06_JPRB/)
KAO( :, 2, 6, 4) = (/&
&1.1254E-04_JPRB,1.0355E-04_JPRB,9.2576E-05_JPRB,7.9894E-05_JPRB,6.5248E-05_JPRB,3.5620E-05_JPRB,&
&4.1186E-05_JPRB,5.3203E-05_JPRB,1.5781E-05_JPRB/)
KAO( :, 3, 6, 4) = (/&
&1.1968E-04_JPRB,1.1191E-04_JPRB,1.0054E-04_JPRB,8.6961E-05_JPRB,7.2380E-05_JPRB,5.4688E-05_JPRB,&
&2.8839E-05_JPRB,5.2690E-05_JPRB,2.5759E-05_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.2668E-04_JPRB,1.2066E-04_JPRB,1.0839E-04_JPRB,9.4280E-05_JPRB,7.9174E-05_JPRB,6.2217E-05_JPRB,&
&2.9595E-05_JPRB,4.6245E-05_JPRB,3.9594E-05_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.3386E-04_JPRB,1.2916E-04_JPRB,1.1625E-04_JPRB,1.0183E-04_JPRB,8.5941E-05_JPRB,6.8663E-05_JPRB,&
&4.7108E-05_JPRB,3.8925E-05_JPRB,5.8371E-05_JPRB/)
KAO( :, 1, 7, 4) = (/&
&9.1290E-05_JPRB,8.2455E-05_JPRB,7.2640E-05_JPRB,6.1602E-05_JPRB,3.5951E-05_JPRB,3.2065E-05_JPRB,&
&6.9438E-05_JPRB,5.4588E-05_JPRB,8.8732E-06_JPRB/)
KAO( :, 2, 7, 4) = (/&
&9.8266E-05_JPRB,8.9923E-05_JPRB,7.9846E-05_JPRB,6.8611E-05_JPRB,5.4855E-05_JPRB,2.5347E-05_JPRB,&
&5.3484E-05_JPRB,5.4646E-05_JPRB,1.6319E-05_JPRB/)
KAO( :, 3, 7, 4) = (/&
&1.0452E-04_JPRB,9.6912E-05_JPRB,8.6790E-05_JPRB,7.4880E-05_JPRB,6.1588E-05_JPRB,3.4215E-05_JPRB,&
&3.8465E-05_JPRB,5.3097E-05_JPRB,2.7544E-05_JPRB/)
KAO( :, 4, 7, 4) = (/&
&1.1064E-04_JPRB,1.0436E-04_JPRB,9.3727E-05_JPRB,8.1191E-05_JPRB,6.7704E-05_JPRB,5.1369E-05_JPRB,&
&2.6755E-05_JPRB,5.1792E-05_JPRB,4.3707E-05_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.1674E-04_JPRB,1.1189E-04_JPRB,1.0064E-04_JPRB,8.7738E-05_JPRB,7.3682E-05_JPRB,5.8032E-05_JPRB,&
&2.8026E-05_JPRB,4.3741E-05_JPRB,6.6125E-05_JPRB/)
KAO( :, 1, 8, 4) = (/&
&7.8671E-05_JPRB,7.0723E-05_JPRB,6.1903E-05_JPRB,5.0899E-05_JPRB,2.5388E-05_JPRB,4.7045E-05_JPRB,&
&8.3139E-05_JPRB,5.2475E-05_JPRB,1.0506E-05_JPRB/)
KAO( :, 2, 8, 4) = (/&
&8.5114E-05_JPRB,7.7503E-05_JPRB,6.8369E-05_JPRB,5.8071E-05_JPRB,3.2941E-05_JPRB,3.1252E-05_JPRB,&
&6.5972E-05_JPRB,5.4053E-05_JPRB,1.9913E-05_JPRB/)
KAO( :, 3, 8, 4) = (/&
&9.0774E-05_JPRB,8.3700E-05_JPRB,7.4489E-05_JPRB,6.3931E-05_JPRB,5.1217E-05_JPRB,2.3975E-05_JPRB,&
&4.9768E-05_JPRB,5.3114E-05_JPRB,3.5011E-05_JPRB/)
KAO( :, 4, 8, 4) = (/&
&9.6188E-05_JPRB,9.0023E-05_JPRB,8.0588E-05_JPRB,6.9637E-05_JPRB,5.7276E-05_JPRB,3.0654E-05_JPRB,&
&3.6814E-05_JPRB,5.0886E-05_JPRB,5.7647E-05_JPRB/)
KAO( :, 5, 8, 4) = (/&
&1.0147E-04_JPRB,9.6459E-05_JPRB,8.6744E-05_JPRB,7.5335E-05_JPRB,6.2848E-05_JPRB,4.7544E-05_JPRB,&
&2.4830E-05_JPRB,4.9742E-05_JPRB,8.9972E-05_JPRB/)
KAO( :, 1, 9, 4) = (/&
&6.7736E-05_JPRB,6.0618E-05_JPRB,5.2744E-05_JPRB,3.0920E-05_JPRB,2.9239E-05_JPRB,6.2840E-05_JPRB,&
&9.2889E-05_JPRB,5.0470E-05_JPRB,2.2355E-05_JPRB/)
KAO( :, 2, 9, 4) = (/&
&7.3171E-05_JPRB,6.6259E-05_JPRB,5.8117E-05_JPRB,4.7578E-05_JPRB,2.3188E-05_JPRB,4.4116E-05_JPRB,&
&7.7151E-05_JPRB,5.4835E-05_JPRB,4.4341E-05_JPRB/)
KAO( :, 3, 9, 4) = (/&
&7.8488E-05_JPRB,7.2012E-05_JPRB,6.3679E-05_JPRB,5.4052E-05_JPRB,2.9892E-05_JPRB,3.0664E-05_JPRB,&
&6.0561E-05_JPRB,5.3817E-05_JPRB,8.1564E-05_JPRB/)
KAO( :, 4, 9, 4) = (/&
&8.3263E-05_JPRB,7.7446E-05_JPRB,6.8972E-05_JPRB,5.9229E-05_JPRB,4.7000E-05_JPRB,2.3105E-05_JPRB,&
&4.7608E-05_JPRB,5.0373E-05_JPRB,1.4008E-04_JPRB/)
KAO( :, 5, 9, 4) = (/&
&8.7956E-05_JPRB,8.2925E-05_JPRB,7.4329E-05_JPRB,6.4343E-05_JPRB,5.3101E-05_JPRB,2.7223E-05_JPRB,&
&3.3997E-05_JPRB,5.1225E-05_JPRB,2.2664E-04_JPRB/)
KAO( :, 1,10, 4) = (/&
&5.8447E-05_JPRB,5.2123E-05_JPRB,4.4386E-05_JPRB,2.1253E-05_JPRB,4.1633E-05_JPRB,7.5363E-05_JPRB,&
&9.7685E-05_JPRB,4.9222E-05_JPRB,5.9155E-05_JPRB/)
KAO( :, 2,10, 4) = (/&
&6.2971E-05_JPRB,5.6773E-05_JPRB,4.9349E-05_JPRB,2.7108E-05_JPRB,2.8492E-05_JPRB,5.8974E-05_JPRB,&
&8.8305E-05_JPRB,5.1607E-05_JPRB,1.2250E-04_JPRB/)
KAO( :, 3,10, 4) = (/&
&6.7713E-05_JPRB,6.1803E-05_JPRB,5.4313E-05_JPRB,4.4294E-05_JPRB,2.2166E-05_JPRB,4.3639E-05_JPRB,&
&7.2310E-05_JPRB,5.3792E-05_JPRB,2.3595E-04_JPRB/)
KAO( :, 4,10, 4) = (/&
&7.2017E-05_JPRB,6.6651E-05_JPRB,5.9032E-05_JPRB,5.0145E-05_JPRB,2.5984E-05_JPRB,3.1163E-05_JPRB,&
&5.5814E-05_JPRB,5.4096E-05_JPRB,4.2155E-04_JPRB/)
KAO( :, 5,10, 4) = (/&
&7.6122E-05_JPRB,7.1340E-05_JPRB,6.3672E-05_JPRB,5.4807E-05_JPRB,4.2703E-05_JPRB,2.2571E-05_JPRB,&
&4.5447E-05_JPRB,5.0941E-05_JPRB,7.0536E-04_JPRB/)
KAO( :, 1,11, 4) = (/&
&5.1997E-05_JPRB,4.6399E-05_JPRB,3.7006E-05_JPRB,2.2118E-05_JPRB,4.9070E-05_JPRB,8.0297E-05_JPRB,&
&9.7665E-05_JPRB,4.9036E-05_JPRB,8.3819E-05_JPRB/)
KAO( :, 2,11, 4) = (/&
&5.5995E-05_JPRB,5.0499E-05_JPRB,4.3536E-05_JPRB,1.8160E-05_JPRB,3.3942E-05_JPRB,6.1798E-05_JPRB,&
&8.7929E-05_JPRB,5.1899E-05_JPRB,1.7378E-04_JPRB/)
KAO( :, 3,11, 4) = (/&
&6.0050E-05_JPRB,5.4855E-05_JPRB,4.8042E-05_JPRB,3.2999E-05_JPRB,2.4599E-05_JPRB,4.8087E-05_JPRB,&
&7.2580E-05_JPRB,5.4376E-05_JPRB,3.3527E-04_JPRB/)
KAO( :, 4,11, 4) = (/&
&6.3834E-05_JPRB,5.9102E-05_JPRB,5.2252E-05_JPRB,4.3696E-05_JPRB,1.9003E-05_JPRB,3.4301E-05_JPRB,&
&5.7788E-05_JPRB,5.3890E-05_JPRB,5.9988E-04_JPRB/)
KAO( :, 5,11, 4) = (/&
&6.7488E-05_JPRB,6.3205E-05_JPRB,5.6377E-05_JPRB,4.8245E-05_JPRB,3.1229E-05_JPRB,2.6140E-05_JPRB,&
&4.5484E-05_JPRB,5.1296E-05_JPRB,1.0059E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&4.6056E-05_JPRB,4.1083E-05_JPRB,2.9802E-05_JPRB,2.2251E-05_JPRB,4.6624E-05_JPRB,7.2962E-05_JPRB,&
&9.3907E-05_JPRB,4.7563E-05_JPRB,8.9454E-05_JPRB/)
KAO( :, 2,12, 4) = (/&
&4.9615E-05_JPRB,4.4762E-05_JPRB,3.8254E-05_JPRB,1.6590E-05_JPRB,3.3432E-05_JPRB,5.6542E-05_JPRB,&
&8.1508E-05_JPRB,5.1901E-05_JPRB,1.8559E-04_JPRB/)
KAO( :, 3,12, 4) = (/&
&5.3180E-05_JPRB,4.8610E-05_JPRB,4.2465E-05_JPRB,2.5666E-05_JPRB,2.4567E-05_JPRB,4.4887E-05_JPRB,&
&6.5994E-05_JPRB,5.4335E-05_JPRB,3.5825E-04_JPRB/)
KAO( :, 4,12, 4) = (/&
&5.6562E-05_JPRB,5.2350E-05_JPRB,4.6232E-05_JPRB,3.8181E-05_JPRB,1.8227E-05_JPRB,3.2932E-05_JPRB,&
&5.2904E-05_JPRB,5.3475E-05_JPRB,6.4181E-04_JPRB/)
KAO( :, 5,12, 4) = (/&
&5.9903E-05_JPRB,5.6017E-05_JPRB,4.9962E-05_JPRB,4.2621E-05_JPRB,2.4691E-05_JPRB,2.4714E-05_JPRB,&
&4.1916E-05_JPRB,5.0025E-05_JPRB,1.0767E-03_JPRB/)
KAO( :, 1,13, 4) = (/&
&4.0560E-05_JPRB,3.6160E-05_JPRB,2.3255E-05_JPRB,2.2093E-05_JPRB,4.4020E-05_JPRB,6.7810E-05_JPRB,&
&8.9069E-05_JPRB,4.8857E-05_JPRB,7.6979E-05_JPRB/)
KAO( :, 2,13, 4) = (/&
&4.3721E-05_JPRB,3.9447E-05_JPRB,3.3315E-05_JPRB,1.5735E-05_JPRB,3.2401E-05_JPRB,5.2990E-05_JPRB,&
&7.4939E-05_JPRB,5.2762E-05_JPRB,1.5983E-04_JPRB/)
KAO( :, 3,13, 4) = (/&
&4.6874E-05_JPRB,4.2856E-05_JPRB,3.7307E-05_JPRB,1.9448E-05_JPRB,2.3246E-05_JPRB,4.1872E-05_JPRB,&
&6.0127E-05_JPRB,5.4225E-05_JPRB,3.0871E-04_JPRB/)
KAO( :, 4,13, 4) = (/&
&4.9922E-05_JPRB,4.6146E-05_JPRB,4.0717E-05_JPRB,3.2736E-05_JPRB,1.7797E-05_JPRB,3.1779E-05_JPRB,&
&4.8971E-05_JPRB,5.3750E-05_JPRB,5.5309E-04_JPRB/)
KAO( :, 5,13, 4) = (/&
&5.3030E-05_JPRB,4.9529E-05_JPRB,4.4121E-05_JPRB,3.7423E-05_JPRB,1.9634E-05_JPRB,2.2842E-05_JPRB,&
&3.9348E-05_JPRB,4.8274E-05_JPRB,9.2736E-04_JPRB/)
KAO( :, 1, 1, 5) = (/&
&2.7778E-04_JPRB,2.5521E-04_JPRB,2.2685E-04_JPRB,1.9591E-04_JPRB,1.6332E-04_JPRB,1.2879E-04_JPRB,&
&9.0596E-05_JPRB,4.4043E-05_JPRB,3.2346E-05_JPRB/)
KAO( :, 2, 1, 5) = (/&
&2.9066E-04_JPRB,2.6987E-04_JPRB,2.4077E-04_JPRB,2.0932E-04_JPRB,1.7577E-04_JPRB,1.4048E-04_JPRB,&
&1.0294E-04_JPRB,3.8809E-05_JPRB,2.9426E-05_JPRB/)
KAO( :, 3, 1, 5) = (/&
&3.0544E-04_JPRB,2.8616E-04_JPRB,2.5754E-04_JPRB,2.2525E-04_JPRB,1.9101E-04_JPRB,1.5455E-04_JPRB,&
&1.1678E-04_JPRB,5.7173E-05_JPRB,3.3954E-05_JPRB/)
KAO( :, 4, 1, 5) = (/&
&3.2184E-04_JPRB,3.0525E-04_JPRB,2.7707E-04_JPRB,2.4441E-04_JPRB,2.0932E-04_JPRB,1.7239E-04_JPRB,&
&1.3430E-04_JPRB,8.9432E-05_JPRB,5.9307E-05_JPRB/)
KAO( :, 5, 1, 5) = (/&
&3.3997E-04_JPRB,3.2768E-04_JPRB,2.9971E-04_JPRB,2.6685E-04_JPRB,2.3158E-04_JPRB,1.9537E-04_JPRB,&
&1.5650E-04_JPRB,1.1300E-04_JPRB,9.1458E-05_JPRB/)
KAO( :, 1, 2, 5) = (/&
&2.6036E-04_JPRB,2.3849E-04_JPRB,2.1215E-04_JPRB,1.8325E-04_JPRB,1.5238E-04_JPRB,1.1978E-04_JPRB,&
&8.1666E-05_JPRB,4.4295E-05_JPRB,2.4496E-05_JPRB/)
KAO( :, 2, 2, 5) = (/&
&2.7147E-04_JPRB,2.5141E-04_JPRB,2.2439E-04_JPRB,1.9462E-04_JPRB,1.6271E-04_JPRB,1.2925E-04_JPRB,&
&9.2973E-05_JPRB,3.2500E-05_JPRB,1.9528E-05_JPRB/)
KAO( :, 3, 2, 5) = (/&
&2.8407E-04_JPRB,2.6548E-04_JPRB,2.3846E-04_JPRB,2.0759E-04_JPRB,1.7524E-04_JPRB,1.4054E-04_JPRB,&
&1.0396E-04_JPRB,4.5395E-05_JPRB,3.3431E-05_JPRB/)
KAO( :, 4, 2, 5) = (/&
&2.9719E-04_JPRB,2.8128E-04_JPRB,2.5423E-04_JPRB,2.2320E-04_JPRB,1.8996E-04_JPRB,1.5400E-04_JPRB,&
&1.1668E-04_JPRB,6.9584E-05_JPRB,5.7490E-05_JPRB/)
KAO( :, 5, 2, 5) = (/&
&3.1122E-04_JPRB,2.9870E-04_JPRB,2.7220E-04_JPRB,2.4100E-04_JPRB,2.0649E-04_JPRB,1.7035E-04_JPRB,&
&1.3266E-04_JPRB,9.1999E-05_JPRB,8.3000E-05_JPRB/)
KAO( :, 1, 3, 5) = (/&
&2.4050E-04_JPRB,2.1900E-04_JPRB,1.9501E-04_JPRB,1.6859E-04_JPRB,1.4005E-04_JPRB,1.0947E-04_JPRB,&
&5.4416E-05_JPRB,3.5695E-05_JPRB,1.3250E-05_JPRB/)
KAO( :, 2, 3, 5) = (/&
&2.4980E-04_JPRB,2.3024E-04_JPRB,2.0600E-04_JPRB,1.7839E-04_JPRB,1.4857E-04_JPRB,1.1723E-04_JPRB,&
&8.2222E-05_JPRB,4.3756E-05_JPRB,1.9778E-05_JPRB/)
KAO( :, 3, 3, 5) = (/&
&2.5986E-04_JPRB,2.4240E-04_JPRB,2.1776E-04_JPRB,1.8907E-04_JPRB,1.5831E-04_JPRB,1.2594E-04_JPRB,&
&9.1156E-05_JPRB,3.2284E-05_JPRB,3.8343E-05_JPRB/)
KAO( :, 4, 3, 5) = (/&
&2.7050E-04_JPRB,2.5528E-04_JPRB,2.3027E-04_JPRB,2.0105E-04_JPRB,1.6973E-04_JPRB,1.3628E-04_JPRB,&
&1.0110E-04_JPRB,4.6885E-05_JPRB,5.9630E-05_JPRB/)
KAO( :, 5, 3, 5) = (/&
&2.8151E-04_JPRB,2.6949E-04_JPRB,2.4440E-04_JPRB,2.1478E-04_JPRB,1.8246E-04_JPRB,1.4822E-04_JPRB,&
&1.1296E-04_JPRB,7.0463E-05_JPRB,8.2542E-05_JPRB/)
KAO( :, 1, 4, 5) = (/&
&2.2167E-04_JPRB,2.0054E-04_JPRB,1.7755E-04_JPRB,1.5346E-04_JPRB,1.2760E-04_JPRB,9.8873E-05_JPRB,&
&4.0720E-05_JPRB,3.6076E-05_JPRB,1.0820E-05_JPRB/)
KAO( :, 2, 4, 5) = (/&
&2.2949E-04_JPRB,2.0991E-04_JPRB,1.8792E-04_JPRB,1.6318E-04_JPRB,1.3546E-04_JPRB,1.0612E-04_JPRB,&
&6.1178E-05_JPRB,4.0667E-05_JPRB,2.5683E-05_JPRB/)
KAO( :, 3, 4, 5) = (/&
&2.3807E-04_JPRB,2.2061E-04_JPRB,1.9870E-04_JPRB,1.7224E-04_JPRB,1.4361E-04_JPRB,1.1345E-04_JPRB,&
&8.0170E-05_JPRB,3.9940E-05_JPRB,4.2610E-05_JPRB/)
KAO( :, 4, 4, 5) = (/&
&2.4662E-04_JPRB,2.3181E-04_JPRB,2.0905E-04_JPRB,1.8202E-04_JPRB,1.5268E-04_JPRB,1.2186E-04_JPRB,&
&8.8749E-05_JPRB,3.2893E-05_JPRB,6.1830E-05_JPRB/)
KAO( :, 5, 4, 5) = (/&
&2.5546E-04_JPRB,2.4342E-04_JPRB,2.2022E-04_JPRB,1.9281E-04_JPRB,1.6313E-04_JPRB,1.3125E-04_JPRB,&
&9.8124E-05_JPRB,4.6973E-05_JPRB,8.6084E-05_JPRB/)
KAO( :, 1, 5, 5) = (/&
&2.0312E-04_JPRB,1.8300E-04_JPRB,1.6095E-04_JPRB,1.3872E-04_JPRB,1.1510E-04_JPRB,8.6738E-05_JPRB,&
&4.3892E-05_JPRB,4.1155E-05_JPRB,1.4610E-05_JPRB/)
KAO( :, 2, 5, 5) = (/&
&2.1032E-04_JPRB,1.9153E-04_JPRB,1.7045E-04_JPRB,1.4818E-04_JPRB,1.2310E-04_JPRB,9.5120E-05_JPRB,&
&3.7530E-05_JPRB,4.0109E-05_JPRB,2.7956E-05_JPRB/)
KAO( :, 3, 5, 5) = (/&
&2.1754E-04_JPRB,2.0013E-04_JPRB,1.8048E-04_JPRB,1.5683E-04_JPRB,1.3036E-04_JPRB,1.0212E-04_JPRB,&
&6.5559E-05_JPRB,4.4646E-05_JPRB,4.3990E-05_JPRB/)
KAO( :, 4, 5, 5) = (/&
&2.2506E-04_JPRB,2.1008E-04_JPRB,1.8992E-04_JPRB,1.6512E-04_JPRB,1.3787E-04_JPRB,1.0933E-04_JPRB,&
&7.7878E-05_JPRB,3.3941E-05_JPRB,6.4638E-05_JPRB/)
KAO( :, 5, 5, 5) = (/&
&2.3238E-04_JPRB,2.2040E-04_JPRB,1.9936E-04_JPRB,1.7403E-04_JPRB,1.4649E-04_JPRB,1.1721E-04_JPRB,&
&8.5745E-05_JPRB,3.1943E-05_JPRB,9.1486E-05_JPRB/)
KAO( :, 1, 6, 5) = (/&
&1.8420E-04_JPRB,1.6521E-04_JPRB,1.4487E-04_JPRB,1.2401E-04_JPRB,1.0200E-04_JPRB,5.1119E-05_JPRB,&
&5.2764E-05_JPRB,4.0912E-05_JPRB,1.5202E-05_JPRB/)
KAO( :, 2, 6, 5) = (/&
&1.9125E-04_JPRB,1.7344E-04_JPRB,1.5331E-04_JPRB,1.3274E-04_JPRB,1.1039E-04_JPRB,8.3040E-05_JPRB,&
&4.0684E-05_JPRB,4.1198E-05_JPRB,2.7867E-05_JPRB/)
KAO( :, 3, 6, 5) = (/&
&1.9735E-04_JPRB,1.8080E-04_JPRB,1.6199E-04_JPRB,1.4097E-04_JPRB,1.1727E-04_JPRB,9.0932E-05_JPRB,&
&3.7180E-05_JPRB,4.3495E-05_JPRB,4.4553E-05_JPRB/)
KAO( :, 4, 6, 5) = (/&
&2.0383E-04_JPRB,1.8894E-04_JPRB,1.7073E-04_JPRB,1.4876E-04_JPRB,1.2398E-04_JPRB,9.7753E-05_JPRB,&
&6.3121E-05_JPRB,4.1277E-05_JPRB,6.7315E-05_JPRB/)
KAO( :, 5, 6, 5) = (/&
&2.1033E-04_JPRB,1.9804E-04_JPRB,1.7951E-04_JPRB,1.5655E-04_JPRB,1.3146E-04_JPRB,1.0454E-04_JPRB,&
&7.4462E-05_JPRB,2.9067E-05_JPRB,9.7382E-05_JPRB/)
KAO( :, 1, 7, 5) = (/&
&1.6701E-04_JPRB,1.4912E-04_JPRB,1.3042E-04_JPRB,1.1101E-04_JPRB,8.9476E-05_JPRB,4.0710E-05_JPRB,&
&6.0855E-05_JPRB,4.0116E-05_JPRB,1.6644E-05_JPRB/)
KAO( :, 2, 7, 5) = (/&
&1.7267E-04_JPRB,1.5557E-04_JPRB,1.3718E-04_JPRB,1.1786E-04_JPRB,9.7049E-05_JPRB,4.9928E-05_JPRB,&
&4.8787E-05_JPRB,4.5062E-05_JPRB,2.9556E-05_JPRB/)
KAO( :, 3, 7, 5) = (/&
&1.7837E-04_JPRB,1.6263E-04_JPRB,1.4469E-04_JPRB,1.2545E-04_JPRB,1.0416E-04_JPRB,7.8620E-05_JPRB,&
&3.6425E-05_JPRB,4.0796E-05_JPRB,4.8760E-05_JPRB/)
KAO( :, 4, 7, 5) = (/&
&1.8378E-04_JPRB,1.6956E-04_JPRB,1.5235E-04_JPRB,1.3267E-04_JPRB,1.1063E-04_JPRB,8.6254E-05_JPRB,&
&3.2851E-05_JPRB,4.0620E-05_JPRB,7.6055E-05_JPRB/)
KAO( :, 5, 7, 5) = (/&
&1.8944E-04_JPRB,1.7724E-04_JPRB,1.6021E-04_JPRB,1.4001E-04_JPRB,1.1733E-04_JPRB,9.2830E-05_JPRB,&
&6.1065E-05_JPRB,3.8081E-05_JPRB,1.1312E-04_JPRB/)
KAO( :, 1, 8, 5) = (/&
&1.5130E-04_JPRB,1.3448E-04_JPRB,1.1721E-04_JPRB,9.9034E-05_JPRB,5.7155E-05_JPRB,4.5775E-05_JPRB,&
&6.5418E-05_JPRB,3.6348E-05_JPRB,2.0483E-05_JPRB/)
KAO( :, 2, 8, 5) = (/&
&1.5492E-04_JPRB,1.3874E-04_JPRB,1.2199E-04_JPRB,1.0406E-04_JPRB,8.3301E-05_JPRB,3.7776E-05_JPRB,&
&5.8525E-05_JPRB,4.3657E-05_JPRB,3.7683E-05_JPRB/)
KAO( :, 3, 8, 5) = (/&
&1.6015E-04_JPRB,1.4504E-04_JPRB,1.2855E-04_JPRB,1.1077E-04_JPRB,9.0857E-05_JPRB,4.6752E-05_JPRB,&
&4.3822E-05_JPRB,4.5900E-05_JPRB,6.4480E-05_JPRB/)
KAO( :, 4, 8, 5) = (/&
&1.6485E-04_JPRB,1.5131E-04_JPRB,1.3522E-04_JPRB,1.1731E-04_JPRB,9.7584E-05_JPRB,7.3940E-05_JPRB,&
&3.2766E-05_JPRB,4.4537E-05_JPRB,1.0397E-04_JPRB/)
KAO( :, 5, 8, 5) = (/&
&1.6974E-04_JPRB,1.5791E-04_JPRB,1.4195E-04_JPRB,1.2381E-04_JPRB,1.0390E-04_JPRB,8.1150E-05_JPRB,&
&3.2012E-05_JPRB,4.1555E-05_JPRB,1.5936E-04_JPRB/)
KAO( :, 1, 9, 5) = (/&
&1.3564E-04_JPRB,1.2012E-04_JPRB,1.0422E-04_JPRB,8.6571E-05_JPRB,3.4561E-05_JPRB,5.5358E-05_JPRB,&
&6.8138E-05_JPRB,3.3996E-05_JPRB,4.5162E-05_JPRB/)
KAO( :, 2, 9, 5) = (/&
&1.3891E-04_JPRB,1.2385E-04_JPRB,1.0843E-04_JPRB,9.1664E-05_JPRB,5.0992E-05_JPRB,4.2386E-05_JPRB,&
&6.5806E-05_JPRB,4.0485E-05_JPRB,8.7517E-05_JPRB/)
KAO( :, 3, 9, 5) = (/&
&1.4289E-04_JPRB,1.2859E-04_JPRB,1.1355E-04_JPRB,9.7157E-05_JPRB,7.7469E-05_JPRB,3.4604E-05_JPRB,&
&5.5697E-05_JPRB,4.6781E-05_JPRB,1.5660E-04_JPRB/)
KAO( :, 4, 9, 5) = (/&
&1.4749E-04_JPRB,1.3449E-04_JPRB,1.1965E-04_JPRB,1.0332E-04_JPRB,8.5038E-05_JPRB,4.3487E-05_JPRB,&
&3.9087E-05_JPRB,4.7631E-05_JPRB,2.6232E-04_JPRB/)
KAO( :, 5, 9, 5) = (/&
&1.5175E-04_JPRB,1.4048E-04_JPRB,1.2566E-04_JPRB,1.0925E-04_JPRB,9.1216E-05_JPRB,6.9027E-05_JPRB,&
&3.0570E-05_JPRB,4.2818E-05_JPRB,4.1578E-04_JPRB/)
KAO( :, 1,10, 5) = (/&
&1.2050E-04_JPRB,1.0644E-04_JPRB,9.1895E-05_JPRB,5.4223E-05_JPRB,4.2282E-05_JPRB,7.1662E-05_JPRB,&
&7.3849E-05_JPRB,3.1216E-05_JPRB,1.2336E-04_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.2385E-04_JPRB,1.1007E-04_JPRB,9.5885E-05_JPRB,7.9074E-05_JPRB,3.2785E-05_JPRB,5.1790E-05_JPRB,&
&7.0330E-05_JPRB,3.8106E-05_JPRB,2.4914E-04_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.2701E-04_JPRB,1.1389E-04_JPRB,1.0009E-04_JPRB,8.4859E-05_JPRB,4.3697E-05_JPRB,3.8515E-05_JPRB,&
&6.4563E-05_JPRB,4.6857E-05_JPRB,4.6353E-04_JPRB/)
KAO( :, 4,10, 5) = (/&
&1.3108E-04_JPRB,1.1889E-04_JPRB,1.0547E-04_JPRB,9.0382E-05_JPRB,7.1811E-05_JPRB,3.1846E-05_JPRB,&
&5.3076E-05_JPRB,4.9334E-05_JPRB,8.0273E-04_JPRB/)
KAO( :, 5,10, 5) = (/&
&1.3517E-04_JPRB,1.2455E-04_JPRB,1.1096E-04_JPRB,9.6119E-05_JPRB,7.9300E-05_JPRB,3.9467E-05_JPRB,&
&3.6989E-05_JPRB,4.6816E-05_JPRB,1.3114E-03_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.0765E-04_JPRB,9.5133E-05_JPRB,8.1740E-05_JPRB,2.9684E-05_JPRB,4.4771E-05_JPRB,7.3844E-05_JPRB,&
&7.4458E-05_JPRB,3.2353E-05_JPRB,1.7556E-04_JPRB/)
KAO( :, 2,11, 5) = (/&
&1.1086E-04_JPRB,9.8643E-05_JPRB,8.5755E-05_JPRB,6.3950E-05_JPRB,3.5072E-05_JPRB,5.6362E-05_JPRB,&
&7.3811E-05_JPRB,3.7974E-05_JPRB,3.5513E-04_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.1390E-04_JPRB,1.0226E-04_JPRB,8.9873E-05_JPRB,7.5337E-05_JPRB,2.7488E-05_JPRB,4.0668E-05_JPRB,&
&6.6695E-05_JPRB,4.8469E-05_JPRB,6.6195E-04_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.1768E-04_JPRB,1.0695E-04_JPRB,9.4758E-05_JPRB,8.0812E-05_JPRB,5.6203E-05_JPRB,3.0959E-05_JPRB,&
&5.4960E-05_JPRB,5.2325E-05_JPRB,1.1500E-03_JPRB/)
KAO( :, 5,11, 5) = (/&
&1.2143E-04_JPRB,1.1200E-04_JPRB,9.9665E-05_JPRB,8.6317E-05_JPRB,7.0507E-05_JPRB,2.8241E-05_JPRB,&
&4.0108E-05_JPRB,4.7823E-05_JPRB,1.8824E-03_JPRB/)
KAO( :, 1,12, 5) = (/&
&9.5550E-05_JPRB,8.4510E-05_JPRB,7.2433E-05_JPRB,2.4695E-05_JPRB,4.1319E-05_JPRB,6.8965E-05_JPRB,&
&7.5836E-05_JPRB,3.3972E-05_JPRB,1.8803E-04_JPRB/)
KAO( :, 2,12, 5) = (/&
&9.8585E-05_JPRB,8.7816E-05_JPRB,7.6262E-05_JPRB,5.0625E-05_JPRB,3.2099E-05_JPRB,5.2909E-05_JPRB,&
&7.1285E-05_JPRB,4.2092E-05_JPRB,3.8071E-04_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.0170E-04_JPRB,9.1397E-05_JPRB,8.0291E-05_JPRB,6.6609E-05_JPRB,2.6053E-05_JPRB,3.8656E-05_JPRB,&
&6.2061E-05_JPRB,5.0288E-05_JPRB,7.1091E-04_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.0532E-04_JPRB,9.5859E-05_JPRB,8.4741E-05_JPRB,7.2190E-05_JPRB,4.4571E-05_JPRB,2.9606E-05_JPRB,&
&5.1144E-05_JPRB,5.0950E-05_JPRB,1.2367E-03_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.0873E-04_JPRB,1.0026E-04_JPRB,8.9123E-05_JPRB,7.7100E-05_JPRB,6.2475E-05_JPRB,2.4044E-05_JPRB,&
&3.7811E-05_JPRB,4.5929E-05_JPRB,2.0278E-03_JPRB/)
KAO( :, 1,13, 5) = (/&
&8.4205E-05_JPRB,7.4539E-05_JPRB,6.3467E-05_JPRB,2.3538E-05_JPRB,3.8325E-05_JPRB,6.4275E-05_JPRB,&
&7.5533E-05_JPRB,3.5671E-05_JPRB,1.6223E-04_JPRB/)
KAO( :, 2,13, 5) = (/&
&8.7134E-05_JPRB,7.7658E-05_JPRB,6.7263E-05_JPRB,3.8163E-05_JPRB,2.9276E-05_JPRB,4.8144E-05_JPRB,&
&6.6883E-05_JPRB,4.5962E-05_JPRB,3.2881E-04_JPRB/)
KAO( :, 3,13, 5) = (/&
&9.0177E-05_JPRB,8.1122E-05_JPRB,7.1136E-05_JPRB,5.8053E-05_JPRB,2.4699E-05_JPRB,3.6684E-05_JPRB,&
&5.7406E-05_JPRB,5.0678E-05_JPRB,6.1498E-04_JPRB/)
KAO( :, 4,13, 5) = (/&
&9.3566E-05_JPRB,8.5217E-05_JPRB,7.5208E-05_JPRB,6.3816E-05_JPRB,3.3862E-05_JPRB,2.8346E-05_JPRB,&
&4.7321E-05_JPRB,4.6618E-05_JPRB,1.0717E-03_JPRB/)
KAO( :, 5,13, 5) = (/&
&9.6738E-05_JPRB,8.9098E-05_JPRB,7.9178E-05_JPRB,6.8356E-05_JPRB,5.4471E-05_JPRB,2.2350E-05_JPRB,&
&3.5198E-05_JPRB,4.4559E-05_JPRB,1.7596E-03_JPRB/)
KAO( :, 1, 1, 6) = (/&
&3.5218E-04_JPRB,3.2067E-04_JPRB,2.8542E-04_JPRB,2.4691E-04_JPRB,2.0715E-04_JPRB,1.6430E-04_JPRB,&
&1.1630E-04_JPRB,3.0602E-05_JPRB,2.2334E-05_JPRB/)
KAO( :, 2, 1, 6) = (/&
&3.6703E-04_JPRB,3.3779E-04_JPRB,3.0330E-04_JPRB,2.6523E-04_JPRB,2.2344E-04_JPRB,1.7999E-04_JPRB,&
&1.3446E-04_JPRB,5.1639E-05_JPRB,3.3226E-05_JPRB/)
KAO( :, 3, 1, 6) = (/&
&3.8585E-04_JPRB,3.5978E-04_JPRB,3.2593E-04_JPRB,2.8711E-04_JPRB,2.4473E-04_JPRB,2.0196E-04_JPRB,&
&1.5783E-04_JPRB,1.0327E-04_JPRB,6.5420E-05_JPRB/)
KAO( :, 4, 1, 6) = (/&
&4.0907E-04_JPRB,3.8577E-04_JPRB,3.5450E-04_JPRB,3.1632E-04_JPRB,2.7470E-04_JPRB,2.3182E-04_JPRB,&
&1.8685E-04_JPRB,1.3638E-04_JPRB,1.1847E-04_JPRB/)
KAO( :, 5, 1, 6) = (/&
&4.3737E-04_JPRB,4.1878E-04_JPRB,3.9158E-04_JPRB,3.5534E-04_JPRB,3.1369E-04_JPRB,2.6894E-04_JPRB,&
&2.2111E-04_JPRB,1.7023E-04_JPRB,1.6126E-04_JPRB/)
KAO( :, 1, 2, 6) = (/&
&3.3988E-04_JPRB,3.0828E-04_JPRB,2.7319E-04_JPRB,2.3566E-04_JPRB,1.9671E-04_JPRB,1.5488E-04_JPRB,&
&1.0656E-04_JPRB,2.4639E-05_JPRB,2.0135E-05_JPRB/)
KAO( :, 2, 2, 6) = (/&
&3.5074E-04_JPRB,3.2145E-04_JPRB,2.8720E-04_JPRB,2.5072E-04_JPRB,2.1014E-04_JPRB,1.6733E-04_JPRB,&
&1.2121E-04_JPRB,3.9180E-05_JPRB,2.9901E-05_JPRB/)
KAO( :, 3, 2, 6) = (/&
&3.6475E-04_JPRB,3.3829E-04_JPRB,3.0546E-04_JPRB,2.6776E-04_JPRB,2.2592E-04_JPRB,1.8277E-04_JPRB,&
&1.3792E-04_JPRB,7.3527E-05_JPRB,6.9892E-05_JPRB/)
KAO( :, 4, 2, 6) = (/&
&3.8225E-04_JPRB,3.5820E-04_JPRB,3.2688E-04_JPRB,2.8858E-04_JPRB,2.4665E-04_JPRB,2.0403E-04_JPRB,&
&1.5963E-04_JPRB,1.1035E-04_JPRB,1.0774E-04_JPRB/)
KAO( :, 5, 2, 6) = (/&
&4.0273E-04_JPRB,3.8268E-04_JPRB,3.5304E-04_JPRB,3.1570E-04_JPRB,2.7513E-04_JPRB,2.3154E-04_JPRB,&
&1.8624E-04_JPRB,1.3783E-04_JPRB,1.4438E-04_JPRB/)
KAO( :, 1, 3, 6) = (/&
&3.2586E-04_JPRB,2.9354E-04_JPRB,2.5840E-04_JPRB,2.2211E-04_JPRB,1.8493E-04_JPRB,1.4459E-04_JPRB,&
&9.3968E-05_JPRB,2.6836E-05_JPRB,1.7667E-05_JPRB/)
KAO( :, 2, 3, 6) = (/&
&3.3335E-04_JPRB,3.0322E-04_JPRB,2.6938E-04_JPRB,2.3450E-04_JPRB,1.9584E-04_JPRB,1.5458E-04_JPRB,&
&1.0872E-04_JPRB,2.7860E-05_JPRB,4.2305E-05_JPRB/)
KAO( :, 3, 3, 6) = (/&
&3.4307E-04_JPRB,3.1560E-04_JPRB,2.8356E-04_JPRB,2.4811E-04_JPRB,2.0859E-04_JPRB,1.6657E-04_JPRB,&
&1.2164E-04_JPRB,4.3049E-05_JPRB,7.4173E-05_JPRB/)
KAO( :, 4, 3, 6) = (/&
&3.5510E-04_JPRB,3.3067E-04_JPRB,3.0030E-04_JPRB,2.6396E-04_JPRB,2.2347E-04_JPRB,1.8094E-04_JPRB,&
&1.3617E-04_JPRB,8.0549E-05_JPRB,1.0462E-04_JPRB/)
KAO( :, 5, 3, 6) = (/&
&3.6934E-04_JPRB,3.4886E-04_JPRB,3.1925E-04_JPRB,2.8285E-04_JPRB,2.4246E-04_JPRB,1.9904E-04_JPRB,&
&1.5402E-04_JPRB,1.0740E-04_JPRB,1.4134E-04_JPRB/)
KAO( :, 1, 4, 6) = (/&
&3.1202E-04_JPRB,2.8003E-04_JPRB,2.4507E-04_JPRB,2.0972E-04_JPRB,1.7365E-04_JPRB,1.3503E-04_JPRB,&
&5.8768E-05_JPRB,2.9314E-05_JPRB,2.4023E-05_JPRB/)
KAO( :, 2, 4, 6) = (/&
&3.1813E-04_JPRB,2.8791E-04_JPRB,2.5394E-04_JPRB,2.1965E-04_JPRB,1.8377E-04_JPRB,1.4389E-04_JPRB,&
&9.7093E-05_JPRB,2.3337E-05_JPRB,5.0021E-05_JPRB/)
KAO( :, 3, 4, 6) = (/&
&3.2483E-04_JPRB,2.9675E-04_JPRB,2.6510E-04_JPRB,2.3175E-04_JPRB,1.9444E-04_JPRB,1.5360E-04_JPRB,&
&1.0928E-04_JPRB,3.0718E-05_JPRB,7.6252E-05_JPRB/)
KAO( :, 4, 4, 6) = (/&
&3.3350E-04_JPRB,3.0829E-04_JPRB,2.7872E-04_JPRB,2.4437E-04_JPRB,2.0593E-04_JPRB,1.6469E-04_JPRB,&
&1.2057E-04_JPRB,4.4984E-05_JPRB,1.0921E-04_JPRB/)
KAO( :, 5, 4, 6) = (/&
&3.4440E-04_JPRB,3.2288E-04_JPRB,2.9368E-04_JPRB,2.5882E-04_JPRB,2.1958E-04_JPRB,1.7772E-04_JPRB,&
&1.3279E-04_JPRB,8.3344E-05_JPRB,1.5068E-04_JPRB/)
KAO( :, 1, 5, 6) = (/&
&2.9770E-04_JPRB,2.6568E-04_JPRB,2.3231E-04_JPRB,1.9760E-04_JPRB,1.6264E-04_JPRB,1.2501E-04_JPRB,&
&5.2212E-05_JPRB,2.7851E-05_JPRB,2.9425E-05_JPRB/)
KAO( :, 2, 5, 6) = (/&
&3.0341E-04_JPRB,2.7316E-04_JPRB,2.3988E-04_JPRB,2.0612E-04_JPRB,1.7178E-04_JPRB,1.3444E-04_JPRB,&
&6.8808E-05_JPRB,2.4233E-05_JPRB,5.0902E-05_JPRB/)
KAO( :, 3, 5, 6) = (/&
&3.0855E-04_JPRB,2.8044E-04_JPRB,2.4851E-04_JPRB,2.1615E-04_JPRB,1.8164E-04_JPRB,1.4300E-04_JPRB,&
&9.8456E-05_JPRB,2.2567E-05_JPRB,7.8789E-05_JPRB/)
KAO( :, 4, 5, 6) = (/&
&3.1479E-04_JPRB,2.8896E-04_JPRB,2.6020E-04_JPRB,2.2793E-04_JPRB,1.9183E-04_JPRB,1.5203E-04_JPRB,&
&1.0899E-04_JPRB,3.3886E-05_JPRB,1.1586E-04_JPRB/)
KAO( :, 5, 5, 6) = (/&
&3.2275E-04_JPRB,3.0062E-04_JPRB,2.7287E-04_JPRB,2.4005E-04_JPRB,2.0243E-04_JPRB,1.6230E-04_JPRB,&
&1.1916E-04_JPRB,4.8642E-05_JPRB,1.6375E-04_JPRB/)
KAO( :, 1, 6, 6) = (/&
&2.8451E-04_JPRB,2.5278E-04_JPRB,2.2028E-04_JPRB,1.8707E-04_JPRB,1.5294E-04_JPRB,1.1368E-04_JPRB,&
&5.1499E-05_JPRB,2.2491E-05_JPRB,2.9300E-05_JPRB/)
KAO( :, 2, 6, 6) = (/&
&2.8818E-04_JPRB,2.5756E-04_JPRB,2.2592E-04_JPRB,1.9305E-04_JPRB,1.5960E-04_JPRB,1.2358E-04_JPRB,&
&4.9278E-05_JPRB,2.8018E-05_JPRB,5.0020E-05_JPRB/)
KAO( :, 3, 6, 6) = (/&
&2.9308E-04_JPRB,2.6479E-04_JPRB,2.3342E-04_JPRB,2.0176E-04_JPRB,1.6837E-04_JPRB,1.3278E-04_JPRB,&
&7.5022E-05_JPRB,2.4679E-05_JPRB,7.9554E-05_JPRB/)
KAO( :, 4, 6, 6) = (/&
&2.9797E-04_JPRB,2.7171E-04_JPRB,2.4252E-04_JPRB,2.1130E-04_JPRB,1.7798E-04_JPRB,1.4080E-04_JPRB,&
&9.8593E-05_JPRB,2.6413E-05_JPRB,1.2029E-04_JPRB/)
KAO( :, 5, 6, 6) = (/&
&3.0385E-04_JPRB,2.8038E-04_JPRB,2.5320E-04_JPRB,2.2231E-04_JPRB,1.8746E-04_JPRB,1.4953E-04_JPRB,&
&1.0805E-04_JPRB,3.4957E-05_JPRB,1.7428E-04_JPRB/)
KAO( :, 1, 7, 6) = (/&
&2.7154E-04_JPRB,2.4047E-04_JPRB,2.0869E-04_JPRB,1.7653E-04_JPRB,1.4316E-04_JPRB,6.3076E-05_JPRB,&
&5.3076E-05_JPRB,1.8799E-05_JPRB,2.9459E-05_JPRB/)
KAO( :, 2, 7, 6) = (/&
&2.7322E-04_JPRB,2.4322E-04_JPRB,2.1245E-04_JPRB,1.8113E-04_JPRB,1.4876E-04_JPRB,1.1194E-04_JPRB,&
&4.9416E-05_JPRB,2.1766E-05_JPRB,5.1977E-05_JPRB/)
KAO( :, 3, 7, 6) = (/&
&2.7795E-04_JPRB,2.4940E-04_JPRB,2.1931E-04_JPRB,1.8853E-04_JPRB,1.5632E-04_JPRB,1.2173E-04_JPRB,&
&4.3459E-05_JPRB,2.7910E-05_JPRB,8.5515E-05_JPRB/)
KAO( :, 4, 7, 6) = (/&
&2.8245E-04_JPRB,2.5609E-04_JPRB,2.2726E-04_JPRB,1.9695E-04_JPRB,1.6467E-04_JPRB,1.3028E-04_JPRB,&
&8.3030E-05_JPRB,3.1238E-05_JPRB,1.3325E-04_JPRB/)
KAO( :, 5, 7, 6) = (/&
&2.8703E-04_JPRB,2.6318E-04_JPRB,2.3595E-04_JPRB,2.0579E-04_JPRB,1.7351E-04_JPRB,1.3813E-04_JPRB,&
&9.7826E-05_JPRB,2.9395E-05_JPRB,1.9863E-04_JPRB/)
KAO( :, 1, 8, 6) = (/&
&2.5666E-04_JPRB,2.2665E-04_JPRB,1.9623E-04_JPRB,1.6528E-04_JPRB,1.3188E-04_JPRB,5.2672E-05_JPRB,&
&5.4590E-05_JPRB,1.5212E-05_JPRB,3.5336E-05_JPRB/)
KAO( :, 2, 8, 6) = (/&
&2.5871E-04_JPRB,2.2976E-04_JPRB,1.9987E-04_JPRB,1.6976E-04_JPRB,1.3838E-04_JPRB,6.2293E-05_JPRB,&
&5.1049E-05_JPRB,2.0990E-05_JPRB,6.5164E-05_JPRB/)
KAO( :, 3, 8, 6) = (/&
&2.6131E-04_JPRB,2.3354E-04_JPRB,2.0472E-04_JPRB,1.7542E-04_JPRB,1.4479E-04_JPRB,1.0936E-04_JPRB,&
&4.3593E-05_JPRB,2.7838E-05_JPRB,1.1164E-04_JPRB/)
KAO( :, 4, 8, 6) = (/&
&2.6597E-04_JPRB,2.3972E-04_JPRB,2.1214E-04_JPRB,1.8293E-04_JPRB,1.5207E-04_JPRB,1.1872E-04_JPRB,&
&4.2928E-05_JPRB,2.9399E-05_JPRB,1.8005E-04_JPRB/)
KAO( :, 5, 8, 6) = (/&
&2.6965E-04_JPRB,2.4602E-04_JPRB,2.1946E-04_JPRB,1.9059E-04_JPRB,1.5945E-04_JPRB,1.2678E-04_JPRB,&
&8.1506E-05_JPRB,3.0396E-05_JPRB,2.7574E-04_JPRB/)
KAO( :, 1, 9, 6) = (/&
&2.4051E-04_JPRB,2.1191E-04_JPRB,1.8318E-04_JPRB,1.5348E-04_JPRB,8.9740E-05_JPRB,5.6443E-05_JPRB,&
&5.8323E-05_JPRB,1.3977E-05_JPRB,7.8714E-05_JPRB/)
KAO( :, 2, 9, 6) = (/&
&2.4280E-04_JPRB,2.1514E-04_JPRB,1.8659E-04_JPRB,1.5766E-04_JPRB,1.2621E-04_JPRB,4.8115E-05_JPRB,&
&5.1962E-05_JPRB,1.8297E-05_JPRB,1.5286E-04_JPRB/)
KAO( :, 3, 9, 6) = (/&
&2.4480E-04_JPRB,2.1809E-04_JPRB,1.9044E-04_JPRB,1.6238E-04_JPRB,1.3286E-04_JPRB,5.9719E-05_JPRB,&
&4.7955E-05_JPRB,2.2245E-05_JPRB,2.7373E-04_JPRB/)
KAO( :, 4, 9, 6) = (/&
&2.4800E-04_JPRB,2.2255E-04_JPRB,1.9613E-04_JPRB,1.6836E-04_JPRB,1.3908E-04_JPRB,1.0477E-04_JPRB,&
&3.9262E-05_JPRB,3.1477E-05_JPRB,4.5768E-04_JPRB/)
KAO( :, 5, 9, 6) = (/&
&2.5161E-04_JPRB,2.2818E-04_JPRB,2.0281E-04_JPRB,1.7515E-04_JPRB,1.4598E-04_JPRB,1.1469E-04_JPRB,&
&3.6846E-05_JPRB,3.4477E-05_JPRB,7.2229E-04_JPRB/)
KAO( :, 1,10, 6) = (/&
&2.2330E-04_JPRB,1.9647E-04_JPRB,1.6947E-04_JPRB,1.4070E-04_JPRB,5.0397E-05_JPRB,6.4372E-05_JPRB,&
&5.4119E-05_JPRB,1.3671E-05_JPRB,2.1819E-04_JPRB/)
KAO( :, 2,10, 6) = (/&
&2.2579E-04_JPRB,1.9970E-04_JPRB,1.7289E-04_JPRB,1.4528E-04_JPRB,8.0532E-05_JPRB,5.4367E-05_JPRB,&
&6.0104E-05_JPRB,1.5483E-05_JPRB,4.4393E-04_JPRB/)
KAO( :, 3,10, 6) = (/&
&2.2759E-04_JPRB,2.0234E-04_JPRB,1.7625E-04_JPRB,1.4950E-04_JPRB,1.1945E-04_JPRB,4.4354E-05_JPRB,&
&5.3052E-05_JPRB,2.1110E-05_JPRB,8.2682E-04_JPRB/)
KAO( :, 4,10, 6) = (/&
&2.2922E-04_JPRB,2.0521E-04_JPRB,1.8016E-04_JPRB,1.5410E-04_JPRB,1.2582E-04_JPRB,5.3486E-05_JPRB,&
&4.4581E-05_JPRB,2.9122E-05_JPRB,1.4295E-03_JPRB/)
KAO( :, 5,10, 6) = (/&
&2.3198E-04_JPRB,2.0949E-04_JPRB,1.8557E-04_JPRB,1.5950E-04_JPRB,1.3216E-04_JPRB,9.8775E-05_JPRB,&
&3.6643E-05_JPRB,3.6794E-05_JPRB,2.3221E-03_JPRB/)
KAO( :, 1,11, 6) = (/&
&2.0583E-04_JPRB,1.8127E-04_JPRB,1.5633E-04_JPRB,1.2776E-04_JPRB,4.7811E-05_JPRB,6.9737E-05_JPRB,&
&5.8557E-05_JPRB,1.2546E-05_JPRB,3.1512E-04_JPRB/)
KAO( :, 2,11, 6) = (/&
&2.0808E-04_JPRB,1.8417E-04_JPRB,1.5959E-04_JPRB,1.3341E-04_JPRB,4.2960E-05_JPRB,5.2587E-05_JPRB,&
&6.0943E-05_JPRB,1.7249E-05_JPRB,6.4309E-04_JPRB/)
KAO( :, 3,11, 6) = (/&
&2.0985E-04_JPRB,1.8679E-04_JPRB,1.6278E-04_JPRB,1.3786E-04_JPRB,1.0094E-04_JPRB,4.2926E-05_JPRB,&
&5.4000E-05_JPRB,2.1438E-05_JPRB,1.2009E-03_JPRB/)
KAO( :, 4,11, 6) = (/&
&2.1113E-04_JPRB,1.8931E-04_JPRB,1.6638E-04_JPRB,1.4208E-04_JPRB,1.1471E-04_JPRB,3.5997E-05_JPRB,&
&4.5064E-05_JPRB,2.9593E-05_JPRB,2.0809E-03_JPRB/)
KAO( :, 5,11, 6) = (/&
&2.1332E-04_JPRB,1.9322E-04_JPRB,1.7102E-04_JPRB,1.4678E-04_JPRB,1.2136E-04_JPRB,7.6714E-05_JPRB,&
&3.8255E-05_JPRB,4.0077E-05_JPRB,3.3932E-03_JPRB/)
KAO( :, 1,12, 6) = (/&
&1.8719E-04_JPRB,1.6501E-04_JPRB,1.4226E-04_JPRB,1.0840E-04_JPRB,4.3551E-05_JPRB,6.5135E-05_JPRB,&
&6.0449E-05_JPRB,1.2368E-05_JPRB,3.4134E-04_JPRB/)
KAO( :, 2,12, 6) = (/&
&1.8952E-04_JPRB,1.6785E-04_JPRB,1.4553E-04_JPRB,1.2117E-04_JPRB,3.5062E-05_JPRB,4.8573E-05_JPRB,&
&6.2841E-05_JPRB,1.5474E-05_JPRB,6.9803E-04_JPRB/)
KAO( :, 3,12, 6) = (/&
&1.9118E-04_JPRB,1.7048E-04_JPRB,1.4865E-04_JPRB,1.2583E-04_JPRB,8.1862E-05_JPRB,3.7617E-05_JPRB,&
&5.3564E-05_JPRB,2.1248E-05_JPRB,1.3057E-03_JPRB/)
KAO( :, 4,12, 6) = (/&
&1.9270E-04_JPRB,1.7320E-04_JPRB,1.5231E-04_JPRB,1.2983E-04_JPRB,1.0441E-04_JPRB,3.3342E-05_JPRB,&
&4.1959E-05_JPRB,3.5845E-05_JPRB,2.2690E-03_JPRB/)
KAO( :, 5,12, 6) = (/&
&1.9518E-04_JPRB,1.7738E-04_JPRB,1.5684E-04_JPRB,1.3457E-04_JPRB,1.1104E-04_JPRB,6.4947E-05_JPRB,&
&3.5407E-05_JPRB,4.3496E-05_JPRB,3.7128E-03_JPRB/)
KAO( :, 1,13, 6) = (/&
&1.6844E-04_JPRB,1.4859E-04_JPRB,1.2806E-04_JPRB,8.6165E-05_JPRB,4.0107E-05_JPRB,6.0133E-05_JPRB,&
&6.1357E-05_JPRB,1.2763E-05_JPRB,2.9734E-04_JPRB/)
KAO( :, 2,13, 6) = (/&
&1.7069E-04_JPRB,1.5140E-04_JPRB,1.3134E-04_JPRB,1.0891E-04_JPRB,3.2613E-05_JPRB,4.6872E-05_JPRB,&
&6.0094E-05_JPRB,1.5072E-05_JPRB,6.0887E-04_JPRB/)
KAO( :, 3,13, 6) = (/&
&1.7244E-04_JPRB,1.5407E-04_JPRB,1.3444E-04_JPRB,1.1361E-04_JPRB,6.4637E-05_JPRB,3.4627E-05_JPRB,&
&4.8765E-05_JPRB,2.7303E-05_JPRB,1.1416E-03_JPRB/)
KAO( :, 4,13, 6) = (/&
&1.7422E-04_JPRB,1.5702E-04_JPRB,1.3806E-04_JPRB,1.1756E-04_JPRB,9.3337E-05_JPRB,3.0148E-05_JPRB,&
&3.8538E-05_JPRB,4.2636E-05_JPRB,1.9903E-03_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.7685E-04_JPRB,1.6120E-04_JPRB,1.4238E-04_JPRB,1.2222E-04_JPRB,1.0041E-04_JPRB,5.2947E-05_JPRB,&
&3.1886E-05_JPRB,4.0330E-05_JPRB,3.2638E-03_JPRB/)
KAO( :, 1, 1, 7) = (/&
&4.3889E-04_JPRB,3.9958E-04_JPRB,3.5783E-04_JPRB,3.1336E-04_JPRB,2.6698E-04_JPRB,2.1857E-04_JPRB,&
&1.6424E-04_JPRB,4.0399E-05_JPRB,2.8247E-05_JPRB/)
KAO( :, 2, 1, 7) = (/&
&4.5976E-04_JPRB,4.2497E-04_JPRB,3.8736E-04_JPRB,3.4581E-04_JPRB,3.0220E-04_JPRB,2.5189E-04_JPRB,&
&1.9631E-04_JPRB,1.0954E-04_JPRB,6.7630E-05_JPRB/)
KAO( :, 3, 1, 7) = (/&
&4.8944E-04_JPRB,4.6159E-04_JPRB,4.2784E-04_JPRB,3.8962E-04_JPRB,3.4476E-04_JPRB,2.9292E-04_JPRB,&
&2.3514E-04_JPRB,1.7014E-04_JPRB,1.5365E-04_JPRB/)
KAO( :, 4, 1, 7) = (/&
&5.2941E-04_JPRB,5.1023E-04_JPRB,4.7948E-04_JPRB,4.4219E-04_JPRB,3.9618E-04_JPRB,3.4392E-04_JPRB,&
&2.8630E-04_JPRB,2.2387E-04_JPRB,2.1803E-04_JPRB/)
KAO( :, 5, 1, 7) = (/&
&5.7974E-04_JPRB,5.6859E-04_JPRB,5.4269E-04_JPRB,5.0514E-04_JPRB,4.6062E-04_JPRB,4.1002E-04_JPRB,&
&3.5338E-04_JPRB,2.8599E-04_JPRB,2.8983E-04_JPRB/)
KAO( :, 1, 2, 7) = (/&
&4.2778E-04_JPRB,3.8751E-04_JPRB,3.4424E-04_JPRB,2.9838E-04_JPRB,2.5188E-04_JPRB,2.0290E-04_JPRB,&
&1.4875E-04_JPRB,2.6658E-05_JPRB,3.1573E-05_JPRB/)
KAO( :, 2, 2, 7) = (/&
&4.4270E-04_JPRB,4.0621E-04_JPRB,3.6561E-04_JPRB,3.2154E-04_JPRB,2.7708E-04_JPRB,2.2750E-04_JPRB,&
&1.7305E-04_JPRB,6.5324E-05_JPRB,8.8564E-05_JPRB/)
KAO( :, 3, 2, 7) = (/&
&4.6316E-04_JPRB,4.3154E-04_JPRB,3.9306E-04_JPRB,3.5392E-04_JPRB,3.0888E-04_JPRB,2.5881E-04_JPRB,&
&2.0328E-04_JPRB,1.3652E-04_JPRB,1.4781E-04_JPRB/)
KAO( :, 4, 2, 7) = (/&
&4.8891E-04_JPRB,4.6467E-04_JPRB,4.3116E-04_JPRB,3.9316E-04_JPRB,3.4835E-04_JPRB,2.9748E-04_JPRB,&
&2.4237E-04_JPRB,1.8240E-04_JPRB,2.0533E-04_JPRB/)
KAO( :, 5, 2, 7) = (/&
&5.2249E-04_JPRB,5.0735E-04_JPRB,4.7839E-04_JPRB,4.4173E-04_JPRB,3.9700E-04_JPRB,3.4683E-04_JPRB,&
&2.9289E-04_JPRB,2.3410E-04_JPRB,2.7363E-04_JPRB/)
KAO( :, 1, 3, 7) = (/&
&4.1666E-04_JPRB,3.7587E-04_JPRB,3.3124E-04_JPRB,2.8500E-04_JPRB,2.3719E-04_JPRB,1.8911E-04_JPRB,&
&1.3261E-04_JPRB,2.3452E-05_JPRB,4.9343E-05_JPRB/)
KAO( :, 2, 3, 7) = (/&
&4.2699E-04_JPRB,3.8906E-04_JPRB,3.4648E-04_JPRB,3.0084E-04_JPRB,2.5570E-04_JPRB,2.0628E-04_JPRB,&
&1.5092E-04_JPRB,2.8713E-05_JPRB,9.9198E-05_JPRB/)
KAO( :, 3, 3, 7) = (/&
&4.4021E-04_JPRB,4.0629E-04_JPRB,3.6539E-04_JPRB,3.2263E-04_JPRB,2.7685E-04_JPRB,2.2699E-04_JPRB,&
&1.7257E-04_JPRB,8.2898E-05_JPRB,1.4682E-04_JPRB/)
KAO( :, 4, 3, 7) = (/&
&4.5674E-04_JPRB,4.2778E-04_JPRB,3.8962E-04_JPRB,3.4911E-04_JPRB,3.0352E-04_JPRB,2.5381E-04_JPRB,&
&1.9998E-04_JPRB,1.3835E-04_JPRB,2.0520E-04_JPRB/)
KAO( :, 5, 3, 7) = (/&
&4.7776E-04_JPRB,4.5415E-04_JPRB,4.2101E-04_JPRB,3.8173E-04_JPRB,3.3698E-04_JPRB,2.8849E-04_JPRB,&
&2.3510E-04_JPRB,1.7936E-04_JPRB,2.7654E-04_JPRB/)
KAO( :, 1, 4, 7) = (/&
&4.0967E-04_JPRB,3.6653E-04_JPRB,3.2176E-04_JPRB,2.7479E-04_JPRB,2.2703E-04_JPRB,1.7902E-04_JPRB,&
&1.1570E-04_JPRB,2.0026E-05_JPRB,6.2716E-05_JPRB/)
KAO( :, 2, 4, 7) = (/&
&4.1728E-04_JPRB,3.7737E-04_JPRB,3.3344E-04_JPRB,2.8769E-04_JPRB,2.4076E-04_JPRB,1.9242E-04_JPRB,&
&1.3658E-04_JPRB,2.3923E-05_JPRB,1.0107E-04_JPRB/)
KAO( :, 3, 4, 7) = (/&
&4.2535E-04_JPRB,3.8928E-04_JPRB,3.4656E-04_JPRB,3.0255E-04_JPRB,2.5648E-04_JPRB,2.0706E-04_JPRB,&
&1.5237E-04_JPRB,3.0608E-05_JPRB,1.5048E-04_JPRB/)
KAO( :, 4, 4, 7) = (/&
&4.3671E-04_JPRB,4.0394E-04_JPRB,3.6448E-04_JPRB,3.2102E-04_JPRB,2.7530E-04_JPRB,2.2501E-04_JPRB,&
&1.7081E-04_JPRB,9.6060E-05_JPRB,2.1454E-04_JPRB/)
KAO( :, 5, 4, 7) = (/&
&4.4976E-04_JPRB,4.2181E-04_JPRB,3.8534E-04_JPRB,3.4353E-04_JPRB,2.9780E-04_JPRB,2.4759E-04_JPRB,&
&1.9471E-04_JPRB,1.3517E-04_JPRB,2.9601E-04_JPRB/)
KAO( :, 1, 5, 7) = (/&
&4.0808E-04_JPRB,3.6358E-04_JPRB,3.1756E-04_JPRB,2.7050E-04_JPRB,2.2238E-04_JPRB,1.7234E-04_JPRB,&
&5.9731E-05_JPRB,1.5183E-05_JPRB,6.3144E-05_JPRB/)
KAO( :, 2, 5, 7) = (/&
&4.1172E-04_JPRB,3.6950E-04_JPRB,3.2496E-04_JPRB,2.7819E-04_JPRB,2.3077E-04_JPRB,1.8213E-04_JPRB,&
&1.2446E-04_JPRB,2.0194E-05_JPRB,1.0232E-04_JPRB/)
KAO( :, 3, 5, 7) = (/&
&4.1699E-04_JPRB,3.7855E-04_JPRB,3.3456E-04_JPRB,2.8999E-04_JPRB,2.4284E-04_JPRB,1.9427E-04_JPRB,&
&1.3989E-04_JPRB,2.2013E-05_JPRB,1.5619E-04_JPRB/)
KAO( :, 4, 5, 7) = (/&
&4.2318E-04_JPRB,3.8831E-04_JPRB,3.4637E-04_JPRB,3.0279E-04_JPRB,2.5707E-04_JPRB,2.0772E-04_JPRB,&
&1.5350E-04_JPRB,3.7923E-05_JPRB,2.2888E-04_JPRB/)
KAO( :, 5, 5, 7) = (/&
&4.3181E-04_JPRB,3.9999E-04_JPRB,3.6216E-04_JPRB,3.1916E-04_JPRB,2.7412E-04_JPRB,2.2354E-04_JPRB,&
&1.6943E-04_JPRB,1.0257E-04_JPRB,3.2402E-04_JPRB/)
KAO( :, 1, 6, 7) = (/&
&4.0917E-04_JPRB,3.6282E-04_JPRB,3.1586E-04_JPRB,2.6754E-04_JPRB,2.1851E-04_JPRB,1.6735E-04_JPRB,&
&5.0306E-05_JPRB,1.4647E-05_JPRB,5.9838E-05_JPRB/)
KAO( :, 2, 6, 7) = (/&
&4.0728E-04_JPRB,3.6393E-04_JPRB,3.1828E-04_JPRB,2.7141E-04_JPRB,2.2388E-04_JPRB,1.7484E-04_JPRB,&
&6.6257E-05_JPRB,1.8734E-05_JPRB,1.0066E-04_JPRB/)
KAO( :, 3, 6, 7) = (/&
&4.1093E-04_JPRB,3.6989E-04_JPRB,3.2582E-04_JPRB,2.7999E-04_JPRB,2.3310E-04_JPRB,1.8335E-04_JPRB,&
&1.2803E-04_JPRB,1.9091E-05_JPRB,1.6014E-04_JPRB/)
KAO( :, 4, 6, 7) = (/&
&4.1435E-04_JPRB,3.7775E-04_JPRB,3.3462E-04_JPRB,2.9056E-04_JPRB,2.4377E-04_JPRB,1.9519E-04_JPRB,&
&1.4167E-04_JPRB,2.4651E-05_JPRB,2.4320E-04_JPRB/)
KAO( :, 5, 6, 7) = (/&
&4.1880E-04_JPRB,3.8572E-04_JPRB,3.4541E-04_JPRB,3.0219E-04_JPRB,2.5684E-04_JPRB,2.0763E-04_JPRB,&
&1.5383E-04_JPRB,5.0012E-05_JPRB,3.5512E-04_JPRB/)
KAO( :, 1, 7, 7) = (/&
&4.0843E-04_JPRB,3.6062E-04_JPRB,3.1311E-04_JPRB,2.6422E-04_JPRB,2.1469E-04_JPRB,1.5788E-04_JPRB,&
&4.4260E-05_JPRB,1.0477E-05_JPRB,5.9419E-05_JPRB/)
KAO( :, 2, 7, 7) = (/&
&4.0468E-04_JPRB,3.5984E-04_JPRB,3.1329E-04_JPRB,2.6596E-04_JPRB,2.1769E-04_JPRB,1.6781E-04_JPRB,&
&5.1786E-05_JPRB,1.4646E-05_JPRB,1.0524E-04_JPRB/)
KAO( :, 3, 7, 7) = (/&
&4.0363E-04_JPRB,3.6136E-04_JPRB,3.1683E-04_JPRB,2.7075E-04_JPRB,2.2418E-04_JPRB,1.7495E-04_JPRB,&
&8.7540E-05_JPRB,1.8041E-05_JPRB,1.7514E-04_JPRB/)
KAO( :, 4, 7, 7) = (/&
&4.0645E-04_JPRB,3.6771E-04_JPRB,3.2468E-04_JPRB,2.8007E-04_JPRB,2.3381E-04_JPRB,1.8431E-04_JPRB,&
&1.2997E-04_JPRB,1.8283E-05_JPRB,2.7663E-04_JPRB/)
KAO( :, 5, 7, 7) = (/&
&4.0882E-04_JPRB,3.7446E-04_JPRB,3.3339E-04_JPRB,2.9009E-04_JPRB,2.4386E-04_JPRB,1.9554E-04_JPRB,&
&1.4307E-04_JPRB,2.6104E-05_JPRB,4.1561E-04_JPRB/)
KAO( :, 1, 8, 7) = (/&
&4.0424E-04_JPRB,3.5590E-04_JPRB,3.0795E-04_JPRB,2.5922E-04_JPRB,2.0908E-04_JPRB,7.0272E-05_JPRB,&
&3.7437E-05_JPRB,1.0693E-05_JPRB,7.0148E-05_JPRB/)
KAO( :, 2, 8, 7) = (/&
&3.9936E-04_JPRB,3.5369E-04_JPRB,3.0725E-04_JPRB,2.5982E-04_JPRB,2.1133E-04_JPRB,1.5687E-04_JPRB,&
&4.6834E-05_JPRB,1.4067E-05_JPRB,1.3163E-04_JPRB/)
KAO( :, 3, 8, 7) = (/&
&3.9575E-04_JPRB,3.5313E-04_JPRB,3.0818E-04_JPRB,2.6229E-04_JPRB,2.1562E-04_JPRB,1.6577E-04_JPRB,&
&5.0426E-05_JPRB,1.5328E-05_JPRB,2.2983E-04_JPRB/)
KAO( :, 4, 8, 7) = (/&
&3.9577E-04_JPRB,3.5593E-04_JPRB,3.1259E-04_JPRB,2.6838E-04_JPRB,2.2238E-04_JPRB,1.7380E-04_JPRB,&
&9.5405E-05_JPRB,1.7738E-05_JPRB,3.7526E-04_JPRB/)
KAO( :, 5, 8, 7) = (/&
&3.9853E-04_JPRB,3.6216E-04_JPRB,3.2118E-04_JPRB,2.7729E-04_JPRB,2.3198E-04_JPRB,1.8391E-04_JPRB,&
&1.3140E-04_JPRB,2.3100E-05_JPRB,5.7971E-04_JPRB/)
KAO( :, 1, 9, 7) = (/&
&3.9550E-04_JPRB,3.4756E-04_JPRB,2.9976E-04_JPRB,2.5157E-04_JPRB,2.0053E-04_JPRB,6.3971E-05_JPRB,&
&3.0992E-05_JPRB,8.5618E-06_JPRB,1.5177E-04_JPRB/)
KAO( :, 2, 9, 7) = (/&
&3.9108E-04_JPRB,3.4522E-04_JPRB,2.9936E-04_JPRB,2.5239E-04_JPRB,2.0355E-04_JPRB,7.9459E-05_JPRB,&
&4.6168E-05_JPRB,1.0069E-05_JPRB,3.0222E-04_JPRB/)
KAO( :, 3, 9, 7) = (/&
&3.8711E-04_JPRB,3.4432E-04_JPRB,2.9976E-04_JPRB,2.5434E-04_JPRB,2.0775E-04_JPRB,1.5531E-04_JPRB,&
&4.6577E-05_JPRB,1.4628E-05_JPRB,5.5112E-04_JPRB/)
KAO( :, 4, 9, 7) = (/&
&3.8454E-04_JPRB,3.4471E-04_JPRB,3.0182E-04_JPRB,2.5833E-04_JPRB,2.1289E-04_JPRB,1.6399E-04_JPRB,&
&4.7735E-05_JPRB,1.8317E-05_JPRB,9.3434E-04_JPRB/)
KAO( :, 5, 9, 7) = (/&
&3.8590E-04_JPRB,3.4906E-04_JPRB,3.0820E-04_JPRB,2.6500E-04_JPRB,2.1985E-04_JPRB,1.7262E-04_JPRB,&
&1.0739E-04_JPRB,2.0046E-05_JPRB,1.4932E-03_JPRB/)
KAO( :, 1,10, 7) = (/&
&3.8145E-04_JPRB,3.3484E-04_JPRB,2.8824E-04_JPRB,2.4073E-04_JPRB,1.3749E-04_JPRB,6.8864E-05_JPRB,&
&1.3426E-05_JPRB,5.4253E-06_JPRB,4.2208E-04_JPRB/)
KAO( :, 2,10, 7) = (/&
&3.7808E-04_JPRB,3.3310E-04_JPRB,2.8836E-04_JPRB,2.4244E-04_JPRB,1.9222E-04_JPRB,5.4332E-05_JPRB,&
&3.8318E-05_JPRB,1.3544E-05_JPRB,8.8420E-04_JPRB/)
KAO( :, 3,10, 7) = (/&
&3.7522E-04_JPRB,3.3290E-04_JPRB,2.8933E-04_JPRB,2.4468E-04_JPRB,1.9821E-04_JPRB,8.2625E-05_JPRB,&
&4.6026E-05_JPRB,1.3859E-05_JPRB,1.6822E-03_JPRB/)
KAO( :, 4,10, 7) = (/&
&3.7308E-04_JPRB,3.3362E-04_JPRB,2.9154E-04_JPRB,2.4864E-04_JPRB,2.0415E-04_JPRB,1.5269E-04_JPRB,&
&4.6983E-05_JPRB,1.4205E-05_JPRB,2.9547E-03_JPRB/)
KAO( :, 5,10, 7) = (/&
&3.7174E-04_JPRB,3.3554E-04_JPRB,2.9552E-04_JPRB,2.5392E-04_JPRB,2.0969E-04_JPRB,1.6270E-04_JPRB,&
&4.1673E-05_JPRB,1.7828E-05_JPRB,4.8607E-03_JPRB/)
KAO( :, 1,11, 7) = (/&
&3.6294E-04_JPRB,3.1871E-04_JPRB,2.7451E-04_JPRB,2.2858E-04_JPRB,8.3578E-05_JPRB,6.1372E-05_JPRB,&
&1.3364E-05_JPRB,7.7912E-06_JPRB,6.2992E-04_JPRB/)
KAO( :, 2,11, 7) = (/&
&3.6112E-04_JPRB,3.1852E-04_JPRB,2.7580E-04_JPRB,2.3178E-04_JPRB,1.8037E-04_JPRB,5.7295E-05_JPRB,&
&4.0682E-05_JPRB,1.2520E-05_JPRB,1.3182E-03_JPRB/)
KAO( :, 3,11, 7) = (/&
&3.5947E-04_JPRB,3.1941E-04_JPRB,2.7779E-04_JPRB,2.3507E-04_JPRB,1.9020E-04_JPRB,4.7650E-05_JPRB,&
&4.7645E-05_JPRB,1.4087E-05_JPRB,2.5064E-03_JPRB/)
KAO( :, 4,11, 7) = (/&
&3.5796E-04_JPRB,3.2062E-04_JPRB,2.8056E-04_JPRB,2.3967E-04_JPRB,1.9644E-04_JPRB,1.3235E-04_JPRB,&
&4.6296E-05_JPRB,1.5164E-05_JPRB,4.4025E-03_JPRB/)
KAO( :, 5,11, 7) = (/&
&3.5673E-04_JPRB,3.2259E-04_JPRB,2.8479E-04_JPRB,2.4474E-04_JPRB,2.0200E-04_JPRB,1.5578E-04_JPRB,&
&4.2752E-05_JPRB,1.8894E-05_JPRB,7.2340E-03_JPRB/)
KAO( :, 1,12, 7) = (/&
&3.4280E-04_JPRB,3.0118E-04_JPRB,2.5967E-04_JPRB,2.1631E-04_JPRB,7.2200E-05_JPRB,5.9727E-05_JPRB,&
&3.2869E-05_JPRB,5.5658E-06_JPRB,7.0164E-04_JPRB/)
KAO( :, 2,12, 7) = (/&
&3.4212E-04_JPRB,3.0217E-04_JPRB,2.6182E-04_JPRB,2.2007E-04_JPRB,1.6435E-04_JPRB,5.4340E-05_JPRB,&
&4.2800E-05_JPRB,1.1130E-05_JPRB,1.4668E-03_JPRB/)
KAO( :, 3,12, 7) = (/&
&3.4134E-04_JPRB,3.0369E-04_JPRB,2.6435E-04_JPRB,2.2391E-04_JPRB,1.8076E-04_JPRB,4.4282E-05_JPRB,&
&4.6617E-05_JPRB,1.2881E-05_JPRB,2.7876E-03_JPRB/)
KAO( :, 4,12, 7) = (/&
&3.4044E-04_JPRB,3.0540E-04_JPRB,2.6773E-04_JPRB,2.2890E-04_JPRB,1.8713E-04_JPRB,1.1838E-04_JPRB,&
&4.1381E-05_JPRB,1.3556E-05_JPRB,4.8923E-03_JPRB/)
KAO( :, 5,12, 7) = (/&
&3.3969E-04_JPRB,3.0785E-04_JPRB,2.7216E-04_JPRB,2.3387E-04_JPRB,1.9308E-04_JPRB,1.4819E-04_JPRB,&
&3.8774E-05_JPRB,2.3365E-05_JPRB,8.0367E-03_JPRB/)
KAO( :, 1,13, 7) = (/&
&3.2074E-04_JPRB,2.8200E-04_JPRB,2.4335E-04_JPRB,2.0260E-04_JPRB,5.9755E-05_JPRB,5.5012E-05_JPRB,&
&4.0916E-05_JPRB,6.5979E-06_JPRB,6.2734E-04_JPRB/)
KAO( :, 2,13, 7) = (/&
&3.2081E-04_JPRB,2.8371E-04_JPRB,2.4601E-04_JPRB,2.0672E-04_JPRB,1.4264E-04_JPRB,4.7131E-05_JPRB,&
&4.6167E-05_JPRB,1.0279E-05_JPRB,1.3098E-03_JPRB/)
KAO( :, 3,13, 7) = (/&
&3.2050E-04_JPRB,2.8547E-04_JPRB,2.4888E-04_JPRB,2.1104E-04_JPRB,1.6957E-04_JPRB,3.8720E-05_JPRB,&
&4.6164E-05_JPRB,1.0646E-05_JPRB,2.4868E-03_JPRB/)
KAO( :, 4,13, 7) = (/&
&3.2004E-04_JPRB,2.8761E-04_JPRB,2.5261E-04_JPRB,2.1602E-04_JPRB,1.7644E-04_JPRB,1.0425E-04_JPRB,&
&3.7809E-05_JPRB,1.7867E-05_JPRB,4.3609E-03_JPRB/)
KAO( :, 5,13, 7) = (/&
&3.1955E-04_JPRB,2.9043E-04_JPRB,2.5703E-04_JPRB,2.2081E-04_JPRB,1.8253E-04_JPRB,1.3988E-04_JPRB,&
&3.6793E-05_JPRB,3.0837E-05_JPRB,7.1735E-03_JPRB/)
KAO( :, 1, 1, 8) = (/&
&5.6685E-04_JPRB,5.1953E-04_JPRB,4.6936E-04_JPRB,4.1592E-04_JPRB,3.5781E-04_JPRB,2.9881E-04_JPRB,&
&2.3721E-04_JPRB,1.2965E-04_JPRB,9.7553E-05_JPRB/)
KAO( :, 2, 1, 8) = (/&
&6.1498E-04_JPRB,5.7331E-04_JPRB,5.2736E-04_JPRB,4.7456E-04_JPRB,4.1825E-04_JPRB,3.6336E-04_JPRB,&
&3.0181E-04_JPRB,2.4017E-04_JPRB,2.2948E-04_JPRB/)
KAO( :, 3, 1, 8) = (/&
&6.7611E-04_JPRB,6.4061E-04_JPRB,6.0111E-04_JPRB,5.5388E-04_JPRB,5.0779E-04_JPRB,4.5514E-04_JPRB,&
&3.9223E-04_JPRB,3.3256E-04_JPRB,3.4276E-04_JPRB/)
KAO( :, 4, 1, 8) = (/&
&7.5480E-04_JPRB,7.2914E-04_JPRB,7.0254E-04_JPRB,6.6835E-04_JPRB,6.2923E-04_JPRB,5.7675E-04_JPRB,&
&5.0673E-04_JPRB,4.4275E-04_JPRB,4.7133E-04_JPRB/)
KAO( :, 5, 1, 8) = (/&
&8.5668E-04_JPRB,8.5031E-04_JPRB,8.3845E-04_JPRB,8.1883E-04_JPRB,7.8346E-04_JPRB,7.2655E-04_JPRB,&
&6.4693E-04_JPRB,5.7765E-04_JPRB,6.2516E-04_JPRB/)
KAO( :, 1, 2, 8) = (/&
&5.4710E-04_JPRB,4.9662E-04_JPRB,4.4514E-04_JPRB,3.9135E-04_JPRB,3.3202E-04_JPRB,2.7342E-04_JPRB,&
&2.1062E-04_JPRB,7.4193E-05_JPRB,1.1449E-04_JPRB/)
KAO( :, 2, 2, 8) = (/&
&5.7920E-04_JPRB,5.3530E-04_JPRB,4.8866E-04_JPRB,4.3544E-04_JPRB,3.7966E-04_JPRB,3.2266E-04_JPRB,&
&2.6099E-04_JPRB,1.8962E-04_JPRB,2.1819E-04_JPRB/)
KAO( :, 3, 2, 8) = (/&
&6.1998E-04_JPRB,5.8558E-04_JPRB,5.4532E-04_JPRB,4.9598E-04_JPRB,4.4601E-04_JPRB,3.9266E-04_JPRB,&
&3.3270E-04_JPRB,2.7330E-04_JPRB,3.1544E-04_JPRB/)
KAO( :, 4, 2, 8) = (/&
&6.7522E-04_JPRB,6.5257E-04_JPRB,6.1970E-04_JPRB,5.8199E-04_JPRB,5.3956E-04_JPRB,4.8955E-04_JPRB,&
&4.2848E-04_JPRB,3.6701E-04_JPRB,4.3346E-04_JPRB/)
KAO( :, 5, 2, 8) = (/&
&7.4593E-04_JPRB,7.3758E-04_JPRB,7.2139E-04_JPRB,6.9843E-04_JPRB,6.6276E-04_JPRB,6.1561E-04_JPRB,&
&5.4954E-04_JPRB,4.8184E-04_JPRB,5.7913E-04_JPRB/)
KAO( :, 1, 3, 8) = (/&
&5.3214E-04_JPRB,4.7681E-04_JPRB,4.2344E-04_JPRB,3.6680E-04_JPRB,3.0810E-04_JPRB,2.4726E-04_JPRB,&
&1.8453E-04_JPRB,2.5084E-05_JPRB,1.5128E-04_JPRB/)
KAO( :, 2, 3, 8) = (/&
&5.5191E-04_JPRB,5.0347E-04_JPRB,4.5239E-04_JPRB,3.9784E-04_JPRB,3.4016E-04_JPRB,2.8162E-04_JPRB,&
&2.1920E-04_JPRB,1.0464E-04_JPRB,2.3348E-04_JPRB/)
KAO( :, 3, 3, 8) = (/&
&5.7477E-04_JPRB,5.3435E-04_JPRB,4.8907E-04_JPRB,4.3911E-04_JPRB,3.8574E-04_JPRB,3.2874E-04_JPRB,&
&2.6890E-04_JPRB,2.0489E-04_JPRB,3.3684E-04_JPRB/)
KAO( :, 4, 3, 8) = (/&
&6.0596E-04_JPRB,5.7781E-04_JPRB,5.4062E-04_JPRB,4.9604E-04_JPRB,4.4703E-04_JPRB,3.9517E-04_JPRB,&
&3.3938E-04_JPRB,2.8379E-04_JPRB,4.6834E-04_JPRB/)
KAO( :, 5, 3, 8) = (/&
&6.4785E-04_JPRB,6.3446E-04_JPRB,6.0817E-04_JPRB,5.7312E-04_JPRB,5.3235E-04_JPRB,4.8682E-04_JPRB,&
&4.3334E-04_JPRB,3.7597E-04_JPRB,6.3257E-04_JPRB/)
KAO( :, 1, 4, 8) = (/&
&5.3110E-04_JPRB,4.7262E-04_JPRB,4.1623E-04_JPRB,3.5723E-04_JPRB,2.9627E-04_JPRB,2.3321E-04_JPRB,&
&1.6340E-04_JPRB,1.9895E-05_JPRB,1.6136E-04_JPRB/)
KAO( :, 2, 4, 8) = (/&
&5.4153E-04_JPRB,4.8798E-04_JPRB,4.3377E-04_JPRB,3.7487E-04_JPRB,3.1581E-04_JPRB,2.5480E-04_JPRB,&
&1.9036E-04_JPRB,3.4588E-05_JPRB,2.5102E-04_JPRB/)
KAO( :, 3, 4, 8) = (/&
&5.5497E-04_JPRB,5.0890E-04_JPRB,4.5760E-04_JPRB,4.0292E-04_JPRB,3.4647E-04_JPRB,2.8693E-04_JPRB,&
&2.2354E-04_JPRB,1.2964E-04_JPRB,3.6989E-04_JPRB/)
KAO( :, 4, 4, 8) = (/&
&5.7139E-04_JPRB,5.3494E-04_JPRB,4.8805E-04_JPRB,4.4096E-04_JPRB,3.8626E-04_JPRB,3.3033E-04_JPRB,&
&2.7143E-04_JPRB,2.1212E-04_JPRB,5.2455E-04_JPRB/)
KAO( :, 5, 4, 8) = (/&
&5.9415E-04_JPRB,5.6860E-04_JPRB,5.3306E-04_JPRB,4.9025E-04_JPRB,4.4085E-04_JPRB,3.9152E-04_JPRB,&
&3.3850E-04_JPRB,2.8746E-04_JPRB,7.1892E-04_JPRB/)
KAO( :, 1, 5, 8) = (/&
&5.4290E-04_JPRB,4.8021E-04_JPRB,4.2005E-04_JPRB,3.5773E-04_JPRB,2.9361E-04_JPRB,2.2840E-04_JPRB,&
&1.2412E-04_JPRB,1.6779E-05_JPRB,1.6478E-04_JPRB/)
KAO( :, 2, 5, 8) = (/&
&5.4234E-04_JPRB,4.8521E-04_JPRB,4.2730E-04_JPRB,3.6655E-04_JPRB,3.0462E-04_JPRB,2.4081E-04_JPRB,&
&1.7158E-04_JPRB,2.4577E-05_JPRB,2.6430E-04_JPRB/)
KAO( :, 3, 5, 8) = (/&
&5.5176E-04_JPRB,4.9971E-04_JPRB,4.4439E-04_JPRB,3.8473E-04_JPRB,3.2493E-04_JPRB,2.6199E-04_JPRB,&
&1.9530E-04_JPRB,5.1968E-05_JPRB,4.0107E-04_JPRB/)
KAO( :, 4, 5, 8) = (/&
&5.6082E-04_JPRB,5.1698E-04_JPRB,4.6451E-04_JPRB,4.1055E-04_JPRB,3.5125E-04_JPRB,2.9127E-04_JPRB,&
&2.2746E-04_JPRB,1.4698E-04_JPRB,5.8315E-04_JPRB/)
KAO( :, 5, 5, 8) = (/&
&5.7193E-04_JPRB,5.3856E-04_JPRB,4.9143E-04_JPRB,4.4154E-04_JPRB,3.8661E-04_JPRB,3.3087E-04_JPRB,&
&2.7242E-04_JPRB,2.1704E-04_JPRB,8.1664E-04_JPRB/)
KAO( :, 1, 6, 8) = (/&
&5.5933E-04_JPRB,4.9291E-04_JPRB,4.2842E-04_JPRB,3.6305E-04_JPRB,2.9613E-04_JPRB,2.2724E-04_JPRB,&
&5.3023E-05_JPRB,1.5921E-05_JPRB,1.6080E-04_JPRB/)
KAO( :, 2, 6, 8) = (/&
&5.5265E-04_JPRB,4.9132E-04_JPRB,4.3026E-04_JPRB,3.6705E-04_JPRB,3.0202E-04_JPRB,2.3616E-04_JPRB,&
&1.5492E-04_JPRB,1.7381E-05_JPRB,2.6878E-04_JPRB/)
KAO( :, 3, 6, 8) = (/&
&5.5383E-04_JPRB,4.9775E-04_JPRB,4.3880E-04_JPRB,3.7661E-04_JPRB,3.1407E-04_JPRB,2.4921E-04_JPRB,&
&1.7746E-04_JPRB,2.2302E-05_JPRB,4.2225E-04_JPRB/)
KAO( :, 4, 6, 8) = (/&
&5.6178E-04_JPRB,5.1138E-04_JPRB,4.5491E-04_JPRB,3.9556E-04_JPRB,3.3327E-04_JPRB,2.6812E-04_JPRB,&
&2.0001E-04_JPRB,6.4403E-05_JPRB,6.3155E-04_JPRB/)
KAO( :, 5, 6, 8) = (/&
&5.6806E-04_JPRB,5.2664E-04_JPRB,4.7387E-04_JPRB,4.1708E-04_JPRB,3.5623E-04_JPRB,2.9443E-04_JPRB,&
&2.3016E-04_JPRB,1.5609E-04_JPRB,9.0635E-04_JPRB/)
KAO( :, 1, 7, 8) = (/&
&5.7912E-04_JPRB,5.0929E-04_JPRB,4.4052E-04_JPRB,3.7179E-04_JPRB,3.0169E-04_JPRB,2.2904E-04_JPRB,&
&3.6739E-05_JPRB,9.8065E-06_JPRB,1.6369E-04_JPRB/)
KAO( :, 2, 7, 8) = (/&
&5.7054E-04_JPRB,5.0526E-04_JPRB,4.4059E-04_JPRB,3.7406E-04_JPRB,3.0610E-04_JPRB,2.3585E-04_JPRB,&
&6.5393E-05_JPRB,1.3372E-05_JPRB,2.8615E-04_JPRB/)
KAO( :, 3, 7, 8) = (/&
&5.6399E-04_JPRB,5.0435E-04_JPRB,4.4269E-04_JPRB,3.7826E-04_JPRB,3.1294E-04_JPRB,2.4573E-04_JPRB,&
&1.6693E-04_JPRB,2.0015E-05_JPRB,4.6772E-04_JPRB/)
KAO( :, 4, 7, 8) = (/&
&5.6580E-04_JPRB,5.1086E-04_JPRB,4.5119E-04_JPRB,3.8935E-04_JPRB,3.2489E-04_JPRB,2.5799E-04_JPRB,&
&1.8517E-04_JPRB,2.1193E-05_JPRB,7.2326E-04_JPRB/)
KAO( :, 5, 7, 8) = (/&
&5.7198E-04_JPRB,5.2353E-04_JPRB,4.6732E-04_JPRB,4.0650E-04_JPRB,3.4261E-04_JPRB,2.7564E-04_JPRB,&
&2.0638E-04_JPRB,8.3698E-05_JPRB,1.0705E-03_JPRB/)
KAO( :, 1, 8, 8) = (/&
&5.9871E-04_JPRB,5.2574E-04_JPRB,4.5363E-04_JPRB,3.8151E-04_JPRB,3.0818E-04_JPRB,2.2816E-04_JPRB,&
&3.1690E-05_JPRB,9.1563E-06_JPRB,1.9592E-04_JPRB/)
KAO( :, 2, 8, 8) = (/&
&5.8942E-04_JPRB,5.2019E-04_JPRB,4.5182E-04_JPRB,3.8232E-04_JPRB,3.1150E-04_JPRB,2.3688E-04_JPRB,&
&4.4878E-05_JPRB,1.3062E-05_JPRB,3.5981E-04_JPRB/)
KAO( :, 3, 8, 8) = (/&
&5.8144E-04_JPRB,5.1705E-04_JPRB,4.5231E-04_JPRB,3.8496E-04_JPRB,3.1600E-04_JPRB,2.4571E-04_JPRB,&
&1.0309E-04_JPRB,1.4129E-05_JPRB,6.1385E-04_JPRB/)
KAO( :, 4, 8, 8) = (/&
&5.7448E-04_JPRB,5.1610E-04_JPRB,4.5471E-04_JPRB,3.9018E-04_JPRB,3.2457E-04_JPRB,2.5556E-04_JPRB,&
&1.7544E-04_JPRB,1.7304E-05_JPRB,9.8945E-04_JPRB/)
KAO( :, 5, 8, 8) = (/&
&5.7483E-04_JPRB,5.2262E-04_JPRB,4.6340E-04_JPRB,4.0220E-04_JPRB,3.3597E-04_JPRB,2.6696E-04_JPRB,&
&1.9367E-04_JPRB,2.4514E-05_JPRB,1.5199E-03_JPRB/)
KAO( :, 1, 9, 8) = (/&
&6.1652E-04_JPRB,5.4081E-04_JPRB,4.6545E-04_JPRB,3.9056E-04_JPRB,3.1379E-04_JPRB,9.9114E-05_JPRB,&
&1.3949E-05_JPRB,3.9239E-06_JPRB,4.2520E-04_JPRB/)
KAO( :, 2, 9, 8) = (/&
&6.0629E-04_JPRB,5.3376E-04_JPRB,4.6202E-04_JPRB,3.8990E-04_JPRB,3.1655E-04_JPRB,2.3544E-04_JPRB,&
&3.7382E-05_JPRB,8.6951E-06_JPRB,8.3044E-04_JPRB/)
KAO( :, 3, 9, 8) = (/&
&5.9694E-04_JPRB,5.2858E-04_JPRB,4.6094E-04_JPRB,3.9128E-04_JPRB,3.1984E-04_JPRB,2.4585E-04_JPRB,&
&4.7453E-05_JPRB,1.1219E-05_JPRB,1.4978E-03_JPRB/)
KAO( :, 4, 9, 8) = (/&
&5.8812E-04_JPRB,5.2540E-04_JPRB,4.6162E-04_JPRB,3.9424E-04_JPRB,3.2635E-04_JPRB,2.5585E-04_JPRB,&
&1.3793E-04_JPRB,1.5823E-05_JPRB,2.5315E-03_JPRB/)
KAO( :, 5, 9, 8) = (/&
&5.8094E-04_JPRB,5.2489E-04_JPRB,4.6409E-04_JPRB,4.0156E-04_JPRB,3.3516E-04_JPRB,2.6461E-04_JPRB,&
&1.8608E-04_JPRB,1.9887E-05_JPRB,4.0512E-03_JPRB/)
KAO( :, 1,10, 8) = (/&
&6.2969E-04_JPRB,5.5181E-04_JPRB,4.7454E-04_JPRB,3.9703E-04_JPRB,3.1724E-04_JPRB,6.5127E-05_JPRB,&
&3.7452E-06_JPRB,3.2741E-06_JPRB,1.1769E-03_JPRB/)
KAO( :, 2,10, 8) = (/&
&6.1957E-04_JPRB,5.4459E-04_JPRB,4.7029E-04_JPRB,3.9585E-04_JPRB,3.1968E-04_JPRB,1.3041E-04_JPRB,&
&2.4515E-05_JPRB,7.2975E-06_JPRB,2.4417E-03_JPRB/)
KAO( :, 3,10, 8) = (/&
&6.0939E-04_JPRB,5.3813E-04_JPRB,4.6769E-04_JPRB,3.9651E-04_JPRB,3.2305E-04_JPRB,2.4182E-04_JPRB,&
&4.3807E-05_JPRB,1.1783E-05_JPRB,4.6287E-03_JPRB/)
KAO( :, 4,10, 8) = (/&
&5.9955E-04_JPRB,5.3329E-04_JPRB,4.6744E-04_JPRB,3.9835E-04_JPRB,3.2790E-04_JPRB,2.5437E-04_JPRB,&
&4.6423E-05_JPRB,1.1970E-05_JPRB,8.1527E-03_JPRB/)
KAO( :, 5,10, 8) = (/&
&5.9051E-04_JPRB,5.3069E-04_JPRB,4.6841E-04_JPRB,4.0335E-04_JPRB,3.3599E-04_JPRB,2.6411E-04_JPRB,&
&1.6905E-04_JPRB,1.8347E-05_JPRB,1.3511E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&6.3270E-04_JPRB,5.5469E-04_JPRB,4.7693E-04_JPRB,3.9917E-04_JPRB,3.1669E-04_JPRB,6.3388E-05_JPRB,&
&3.6721E-06_JPRB,3.2147E-07_JPRB,1.7207E-03_JPRB/)
KAO( :, 2,11, 8) = (/&
&6.2323E-04_JPRB,5.4792E-04_JPRB,4.7320E-04_JPRB,3.9836E-04_JPRB,3.2132E-04_JPRB,8.3669E-05_JPRB,&
&2.5421E-05_JPRB,6.2024E-06_JPRB,3.6065E-03_JPRB/)
KAO( :, 3,11, 8) = (/&
&6.1343E-04_JPRB,5.4174E-04_JPRB,4.7120E-04_JPRB,3.9965E-04_JPRB,3.2524E-04_JPRB,2.3807E-04_JPRB,&
&4.5288E-05_JPRB,1.1010E-05_JPRB,6.9077E-03_JPRB/)
KAO( :, 4,11, 8) = (/&
&6.0422E-04_JPRB,5.3760E-04_JPRB,4.7151E-04_JPRB,4.0215E-04_JPRB,3.3145E-04_JPRB,2.5596E-04_JPRB,&
&4.6438E-05_JPRB,1.1046E-05_JPRB,1.2276E-02_JPRB/)
KAO( :, 5,11, 8) = (/&
&5.9513E-04_JPRB,5.3553E-04_JPRB,4.7292E-04_JPRB,4.0786E-04_JPRB,3.3977E-04_JPRB,2.6645E-04_JPRB,&
&1.3530E-04_JPRB,1.8396E-05_JPRB,2.0378E-02_JPRB/)
KAO( :, 1,12, 8) = (/&
&6.3015E-04_JPRB,5.5264E-04_JPRB,4.7514E-04_JPRB,3.9757E-04_JPRB,3.1556E-04_JPRB,6.0378E-05_JPRB,&
&5.1686E-06_JPRB,4.1217E-06_JPRB,1.9089E-03_JPRB/)
KAO( :, 2,12, 8) = (/&
&6.2156E-04_JPRB,5.4661E-04_JPRB,4.7228E-04_JPRB,3.9794E-04_JPRB,3.2115E-04_JPRB,9.3459E-05_JPRB,&
&3.5910E-05_JPRB,6.9491E-06_JPRB,4.0407E-03_JPRB/)
KAO( :, 3,12, 8) = (/&
&6.1284E-04_JPRB,5.4153E-04_JPRB,4.7137E-04_JPRB,3.9993E-04_JPRB,3.2562E-04_JPRB,2.3942E-04_JPRB,&
&4.5459E-05_JPRB,1.2207E-05_JPRB,7.7972E-03_JPRB/)
KAO( :, 4,12, 8) = (/&
&6.0431E-04_JPRB,5.3827E-04_JPRB,4.7217E-04_JPRB,4.0315E-04_JPRB,3.3297E-04_JPRB,2.5722E-04_JPRB,&
&4.4991E-05_JPRB,1.1842E-05_JPRB,1.3838E-02_JPRB/)
KAO( :, 5,12, 8) = (/&
&5.9614E-04_JPRB,5.3719E-04_JPRB,4.7459E-04_JPRB,4.0965E-04_JPRB,3.4109E-04_JPRB,2.6763E-04_JPRB,&
&1.4327E-04_JPRB,1.6122E-05_JPRB,2.2897E-02_JPRB/)
KAO( :, 1,13, 8) = (/&
&6.2067E-04_JPRB,5.4442E-04_JPRB,4.6829E-04_JPRB,3.9206E-04_JPRB,3.1059E-04_JPRB,5.4570E-05_JPRB,&
&2.5324E-05_JPRB,1.9027E-06_JPRB,1.7246E-03_JPRB/)
KAO( :, 2,13, 8) = (/&
&6.1333E-04_JPRB,5.3966E-04_JPRB,4.6657E-04_JPRB,3.9353E-04_JPRB,3.1741E-04_JPRB,1.0184E-04_JPRB,&
&4.1822E-05_JPRB,6.3468E-06_JPRB,3.6765E-03_JPRB/)
KAO( :, 3,13, 8) = (/&
&6.0610E-04_JPRB,5.3617E-04_JPRB,4.6704E-04_JPRB,3.9622E-04_JPRB,3.2317E-04_JPRB,2.3665E-04_JPRB,&
&4.5927E-05_JPRB,1.1176E-05_JPRB,7.0786E-03_JPRB/)
KAO( :, 4,13, 8) = (/&
&5.9902E-04_JPRB,5.3443E-04_JPRB,4.6878E-04_JPRB,4.0069E-04_JPRB,3.3118E-04_JPRB,2.5588E-04_JPRB,&
&4.4674E-05_JPRB,1.1239E-05_JPRB,1.2524E-02_JPRB/)
KAO( :, 5,13, 8) = (/&
&5.9234E-04_JPRB,5.3454E-04_JPRB,4.7242E-04_JPRB,4.0791E-04_JPRB,3.3951E-04_JPRB,2.6646E-04_JPRB,&
&1.4670E-04_JPRB,2.0921E-05_JPRB,2.0681E-02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB7_A1
