!OCL SCALAR
SUBROUTINE RRTM_KGB7_00

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 7:  980-1080 cm-1 (low - H2O,O3; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO7 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,ABSCO2O
USE YOERRTA7 , ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
FRACREFBO( :) = (/&
    &0.15355594_JPRB,0.15310939_JPRB,0.14274909_JPRB,0.13129812_JPRB,&
    &0.11736792_JPRB,0.10118213_JPRB,0.08215259_JPRB,0.06165591_JPRB,&
    &0.04164486_JPRB,0.00451141_JPRB,0.00372837_JPRB,0.00294095_JPRB,&
    &0.00215259_JPRB,0.00136792_JPRB,0.00051233_JPRB,0.00007075_JPRB/)

ABSCO2O( :) = (/&
     &9.30038E-05_JPRB, 1.74061E-04_JPRB, 2.09293E-04_JPRB, 2.52360E-04_JPRB,&
     &3.13404E-04_JPRB, 4.16619E-04_JPRB, 6.27394E-04_JPRB, 1.29386E-03_JPRB,&
     &4.05192E-03_JPRB, 3.97050E-03_JPRB, 7.00634E-04_JPRB, 6.06617E-04_JPRB,&
     &7.66978E-04_JPRB, 6.70661E-04_JPRB, 7.89971E-04_JPRB, 7.55709E-04_JPRB/)

STRRAT = 8.21104E+04_JPRB

!     ------------------------------------------------------------------

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&5.19175E-02_JPRB, 4.28815E-02_JPRB, 3.54182E-02_JPRB, 2.92539E-02_JPRB, 2.41624E-02_JPRB,&
&1.99571E-02_JPRB, 1.64836E-02_JPRB, 1.36148E-02_JPRB, 1.12452E-02_JPRB, 9.28801E-03_JPRB/)
SELFREFO( :, 2) = (/&
&4.36985E-02_JPRB, 3.78503E-02_JPRB, 3.27848E-02_JPRB, 2.83973E-02_JPRB, 2.45969E-02_JPRB,&
&2.13051E-02_JPRB, 1.84538E-02_JPRB, 1.59842E-02_JPRB, 1.38450E-02_JPRB, 1.19921E-02_JPRB/)
SELFREFO( :, 3) = (/&
&4.25575E-02_JPRB, 3.71214E-02_JPRB, 3.23797E-02_JPRB, 2.82437E-02_JPRB, 2.46360E-02_JPRB,&
&2.14891E-02_JPRB, 1.87442E-02_JPRB, 1.63499E-02_JPRB, 1.42615E-02_JPRB, 1.24398E-02_JPRB/)
SELFREFO( :, 4) = (/&
&4.03854E-02_JPRB, 3.54677E-02_JPRB, 3.11488E-02_JPRB, 2.73558E-02_JPRB, 2.40247E-02_JPRB,&
&2.10992E-02_JPRB, 1.85300E-02_JPRB, 1.62736E-02_JPRB, 1.42920E-02_JPRB, 1.25517E-02_JPRB/)
SELFREFO( :, 5) = (/&
&3.95070E-02_JPRB, 3.46726E-02_JPRB, 3.04297E-02_JPRB, 2.67060E-02_JPRB, 2.34380E-02_JPRB,&
&2.05699E-02_JPRB, 1.80528E-02_JPRB, 1.58437E-02_JPRB, 1.39049E-02_JPRB, 1.22034E-02_JPRB/)
SELFREFO( :, 6) = (/&
&3.89748E-02_JPRB, 3.40186E-02_JPRB, 2.96926E-02_JPRB, 2.59168E-02_JPRB, 2.26211E-02_JPRB,&
&1.97445E-02_JPRB, 1.72337E-02_JPRB, 1.50422E-02_JPRB, 1.31293E-02_JPRB, 1.14597E-02_JPRB/)
SELFREFO( :, 7) = (/&
&3.85527E-02_JPRB, 3.36561E-02_JPRB, 2.93815E-02_JPRB, 2.56497E-02_JPRB, 2.23920E-02_JPRB,&
&1.95480E-02_JPRB, 1.70652E-02_JPRB, 1.48977E-02_JPRB, 1.30056E-02_JPRB, 1.13537E-02_JPRB/)
SELFREFO( :, 8) = (/&
&3.78212E-02_JPRB, 3.30614E-02_JPRB, 2.89005E-02_JPRB, 2.52633E-02_JPRB, 2.20839E-02_JPRB,&
&1.93046E-02_JPRB, 1.68751E-02_JPRB, 1.47513E-02_JPRB, 1.28948E-02_JPRB, 1.12720E-02_JPRB/)
SELFREFO( :, 9) = (/&
&3.68624E-02_JPRB, 3.22676E-02_JPRB, 2.82456E-02_JPRB, 2.47248E-02_JPRB, 2.16429E-02_JPRB,&
&1.89452E-02_JPRB, 1.65838E-02_JPRB, 1.45166E-02_JPRB, 1.27072E-02_JPRB, 1.11233E-02_JPRB/)
SELFREFO( :,10) = (/&
&3.63135E-02_JPRB, 3.19332E-02_JPRB, 2.80813E-02_JPRB, 2.46940E-02_JPRB, 2.17154E-02_JPRB,&
&1.90960E-02_JPRB, 1.67926E-02_JPRB, 1.47670E-02_JPRB, 1.29857E-02_JPRB, 1.14193E-02_JPRB/)
SELFREFO( :,11) = (/&
&3.60018E-02_JPRB, 3.17294E-02_JPRB, 2.79640E-02_JPRB, 2.46454E-02_JPRB, 2.17207E-02_JPRB,&
&1.91430E-02_JPRB, 1.68713E-02_JPRB, 1.48691E-02_JPRB, 1.31045E-02_JPRB, 1.15494E-02_JPRB/)
SELFREFO( :,12) = (/&
&3.65147E-02_JPRB, 3.19158E-02_JPRB, 2.78962E-02_JPRB, 2.43827E-02_JPRB, 2.13118E-02_JPRB,&
&1.86277E-02_JPRB, 1.62816E-02_JPRB, 1.42310E-02_JPRB, 1.24386E-02_JPRB, 1.08720E-02_JPRB/)
SELFREFO( :,13) = (/&
&3.72684E-02_JPRB, 3.23732E-02_JPRB, 2.81210E-02_JPRB, 2.44274E-02_JPRB, 2.12189E-02_JPRB,&
&1.84318E-02_JPRB, 1.60108E-02_JPRB, 1.39078E-02_JPRB, 1.20810E-02_JPRB, 1.04942E-02_JPRB/)
SELFREFO( :,14) = (/&
&3.87604E-02_JPRB, 3.34099E-02_JPRB, 2.87979E-02_JPRB, 2.48226E-02_JPRB, 2.13960E-02_JPRB,&
&1.84425E-02_JPRB, 1.58967E-02_JPRB, 1.37023E-02_JPRB, 1.18108E-02_JPRB, 1.01804E-02_JPRB/)
SELFREFO( :,15) = (/&
&3.51227E-02_JPRB, 3.05052E-02_JPRB, 2.64947E-02_JPRB, 2.30115E-02_JPRB, 1.99862E-02_JPRB,&
&1.73586E-02_JPRB, 1.50765E-02_JPRB, 1.30944E-02_JPRB, 1.13729E-02_JPRB, 9.87775E-03_JPRB/)
SELFREFO( :,16) = (/&
&3.51227E-02_JPRB, 3.05052E-02_JPRB, 2.64947E-02_JPRB, 2.30115E-02_JPRB, 1.99862E-02_JPRB,&
&1.73586E-02_JPRB, 1.50765E-02_JPRB, 1.30944E-02_JPRB, 1.13729E-02_JPRB, 9.87775E-03_JPRB/)

FRACREFAO( :, 1) = (/&
  &0.16461779_JPRB, 0.14889984_JPRB, 0.14233345_JPRB, 0.13156526_JPRB,&
  &0.11679733_JPRB, 0.09988949_JPRB, 0.08078653_JPRB, 0.06006384_JPRB,&
  &0.04028391_JPRB, 0.00435899_JPRB, 0.00359173_JPRB, 0.00281707_JPRB,&
  &0.00206767_JPRB, 0.00135012_JPRB, 0.00050720_JPRB, 0.00007146_JPRB/)
FRACREFAO( :, 2) = (/&
  &0.16442357_JPRB, 0.14944240_JPRB, 0.14245804_JPRB, 0.13111183_JPRB,&
  &0.11688625_JPRB, 0.09983791_JPRB, 0.08085148_JPRB, 0.05993948_JPRB,&
  &0.04028057_JPRB, 0.00435939_JPRB, 0.00358708_JPRB, 0.00284036_JPRB,&
  &0.00208869_JPRB, 0.00133256_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 3) = (/&
  &0.16368519_JPRB, 0.15018989_JPRB, 0.14262174_JPRB, 0.13084342_JPRB,&
  &0.11682195_JPRB, 0.09996257_JPRB, 0.08074036_JPRB, 0.05985692_JPRB,&
  &0.04045362_JPRB, 0.00436208_JPRB, 0.00358257_JPRB, 0.00287122_JPRB,&
  &0.00211004_JPRB, 0.00133804_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 4) = (/&
  &0.16274056_JPRB, 0.15133780_JPRB, 0.14228874_JPRB, 0.13081114_JPRB,&
  &0.11688486_JPRB, 0.09979610_JPRB, 0.08073687_JPRB, 0.05996741_JPRB,&
  &0.04040616_JPRB, 0.00439869_JPRB, 0.00368910_JPRB, 0.00293041_JPRB,&
  &0.00211604_JPRB, 0.00133536_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 5) = (/&
  &0.16176532_JPRB, 0.15207882_JPRB, 0.14226955_JPRB, 0.13079646_JPRB,&
  &0.11688191_JPRB, 0.09966998_JPRB, 0.08066384_JPRB, 0.06020275_JPRB,&
  &0.04047901_JPRB, 0.00446696_JPRB, 0.00377456_JPRB, 0.00294410_JPRB,&
  &0.00211082_JPRB, 0.00133536_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 6) = (/&
  &0.15993737_JPRB, 0.15305527_JPRB, 0.14259829_JPRB, 0.13078023_JPRB,&
  &0.11686983_JPRB, 0.09980131_JPRB, 0.08058286_JPRB, 0.06031430_JPRB,&
  &0.04082833_JPRB, 0.00450509_JPRB, 0.00377574_JPRB, 0.00294823_JPRB,&
  &0.00210977_JPRB, 0.00133302_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 7) = (/&
  &0.15371189_JPRB, 0.15592396_JPRB, 0.14430280_JPRB, 0.13076764_JPRB,&
  &0.11720382_JPRB, 0.10023471_JPRB, 0.08066396_JPRB, 0.06073554_JPRB,&
  &0.04121581_JPRB, 0.00451202_JPRB, 0.00377832_JPRB, 0.00294609_JPRB,&
  &0.00210943_JPRB, 0.00133336_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 8) = (/&
  &0.14262275_JPRB, 0.14572631_JPRB, 0.14560597_JPRB, 0.13736825_JPRB,&
  &0.12271351_JPRB, 0.10419556_JPRB, 0.08294533_JPRB, 0.06199794_JPRB,&
  &0.04157615_JPRB, 0.00452842_JPRB, 0.00377704_JPRB, 0.00293852_JPRB,&
  &0.00211034_JPRB, 0.00133278_JPRB, 0.00049259_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 9) = (/&
  &0.14500433_JPRB, 0.14590444_JPRB, 0.14430299_JPRB, 0.13770708_JPRB,&
  &0.12288283_JPRB, 0.10350952_JPRB, 0.08269450_JPRB, 0.06130579_JPRB,&
  &0.04144571_JPRB, 0.00452096_JPRB, 0.00377382_JPRB, 0.00294532_JPRB,&
  &0.00210943_JPRB, 0.00133228_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB7_00
