!OCL SCALAR
SUBROUTINE RRTM_KGB5_B4

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, CCL4O
USE YOERRTA5 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KB contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of co2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13,13) = (/&
&2.6529E+00_JPRB,2.2831E+00_JPRB,3.2422E+00_JPRB,4.4425E+00_JPRB,5.7532E+00_JPRB/)
KBO( :, 2,13,13) = (/&
&3.7901E+00_JPRB,3.0012E+00_JPRB,3.3868E+00_JPRB,4.4780E+00_JPRB,5.6304E+00_JPRB/)
KBO( :, 3,13,13) = (/&
&5.1407E+00_JPRB,3.9898E+00_JPRB,3.7034E+00_JPRB,4.5284E+00_JPRB,5.5094E+00_JPRB/)
KBO( :, 4,13,13) = (/&
&6.6849E+00_JPRB,5.1505E+00_JPRB,4.1152E+00_JPRB,4.5525E+00_JPRB,5.3863E+00_JPRB/)
KBO( :, 5,13,13) = (/&
&8.4107E+00_JPRB,6.4413E+00_JPRB,4.6939E+00_JPRB,4.5962E+00_JPRB,5.2598E+00_JPRB/)
KBO( :, 1,14,13) = (/&
&2.7859E+00_JPRB,2.4754E+00_JPRB,3.5707E+00_JPRB,4.9274E+00_JPRB,6.3617E+00_JPRB/)
KBO( :, 2,14,13) = (/&
&3.9819E+00_JPRB,3.1616E+00_JPRB,3.7430E+00_JPRB,4.9467E+00_JPRB,6.2248E+00_JPRB/)
KBO( :, 3,14,13) = (/&
&5.4169E+00_JPRB,4.1984E+00_JPRB,4.1076E+00_JPRB,4.9547E+00_JPRB,6.0805E+00_JPRB/)
KBO( :, 4,14,13) = (/&
&7.0660E+00_JPRB,5.4307E+00_JPRB,4.5231E+00_JPRB,4.9634E+00_JPRB,5.9266E+00_JPRB/)
KBO( :, 5,14,13) = (/&
&8.9144E+00_JPRB,6.8140E+00_JPRB,5.0663E+00_JPRB,5.0044E+00_JPRB,5.7690E+00_JPRB/)
KBO( :, 1,15,13) = (/&
&2.9857E+00_JPRB,2.7217E+00_JPRB,3.9316E+00_JPRB,5.4603E+00_JPRB,7.0398E+00_JPRB/)
KBO( :, 2,15,13) = (/&
&4.2764E+00_JPRB,3.4089E+00_JPRB,4.1424E+00_JPRB,5.4476E+00_JPRB,6.8612E+00_JPRB/)
KBO( :, 3,15,13) = (/&
&5.8211E+00_JPRB,4.5002E+00_JPRB,4.5148E+00_JPRB,5.4204E+00_JPRB,6.6790E+00_JPRB/)
KBO( :, 4,15,13) = (/&
&7.6022E+00_JPRB,5.8275E+00_JPRB,4.9790E+00_JPRB,5.4051E+00_JPRB,6.4972E+00_JPRB/)
KBO( :, 5,15,13) = (/&
&9.6077E+00_JPRB,7.3247E+00_JPRB,5.5648E+00_JPRB,5.4790E+00_JPRB,6.3175E+00_JPRB/)
KBO( :, 1,16,13) = (/&
&3.2520E+00_JPRB,3.0398E+00_JPRB,4.3234E+00_JPRB,6.0080E+00_JPRB,7.7322E+00_JPRB/)
KBO( :, 2,16,13) = (/&
&4.6456E+00_JPRB,3.7621E+00_JPRB,4.5833E+00_JPRB,5.9695E+00_JPRB,7.5298E+00_JPRB/)
KBO( :, 3,16,13) = (/&
&6.3086E+00_JPRB,4.8685E+00_JPRB,4.9506E+00_JPRB,5.9143E+00_JPRB,7.3233E+00_JPRB/)
KBO( :, 4,16,13) = (/&
&8.2262E+00_JPRB,6.2820E+00_JPRB,5.4881E+00_JPRB,5.8959E+00_JPRB,7.1229E+00_JPRB/)
KBO( :, 5,16,13) = (/&
&1.0371E+01_JPRB,7.8838E+00_JPRB,6.1617E+00_JPRB,6.0261E+00_JPRB,6.9371E+00_JPRB/)
KBO( :, 1,17,13) = (/&
&3.5103E+00_JPRB,3.4027E+00_JPRB,4.7571E+00_JPRB,6.5946E+00_JPRB,8.5011E+00_JPRB/)
KBO( :, 2,17,13) = (/&
&4.9855E+00_JPRB,4.1396E+00_JPRB,5.0300E+00_JPRB,6.5219E+00_JPRB,8.2752E+00_JPRB/)
KBO( :, 3,17,13) = (/&
&6.7391E+00_JPRB,5.2214E+00_JPRB,5.4410E+00_JPRB,6.4503E+00_JPRB,8.0549E+00_JPRB/)
KBO( :, 4,17,13) = (/&
&8.7527E+00_JPRB,6.6750E+00_JPRB,6.0440E+00_JPRB,6.4589E+00_JPRB,7.8521E+00_JPRB/)
KBO( :, 5,17,13) = (/&
&1.0977E+01_JPRB,8.3330E+00_JPRB,6.7610E+00_JPRB,6.6072E+00_JPRB,7.6623E+00_JPRB/)
KBO( :, 1,18,13) = (/&
&3.7201E+00_JPRB,3.7715E+00_JPRB,5.2410E+00_JPRB,7.2877E+00_JPRB,9.4447E+00_JPRB/)
KBO( :, 2,18,13) = (/&
&5.2473E+00_JPRB,4.5163E+00_JPRB,5.5131E+00_JPRB,7.1747E+00_JPRB,9.1964E+00_JPRB/)
KBO( :, 3,18,13) = (/&
&7.0567E+00_JPRB,5.5681E+00_JPRB,5.9890E+00_JPRB,7.0880E+00_JPRB,8.9663E+00_JPRB/)
KBO( :, 4,18,13) = (/&
&9.1072E+00_JPRB,6.9581E+00_JPRB,6.6273E+00_JPRB,7.1370E+00_JPRB,8.7546E+00_JPRB/)
KBO( :, 5,18,13) = (/&
&1.1367E+01_JPRB,8.6174E+00_JPRB,7.3488E+00_JPRB,7.2704E+00_JPRB,8.5556E+00_JPRB/)
KBO( :, 1,19,13) = (/&
&3.8561E+00_JPRB,4.1299E+00_JPRB,5.8089E+00_JPRB,8.1195E+00_JPRB,1.0564E+01_JPRB/)
KBO( :, 2,19,13) = (/&
&5.4052E+00_JPRB,4.8948E+00_JPRB,6.0739E+00_JPRB,7.9918E+00_JPRB,1.0309E+01_JPRB/)
KBO( :, 3,19,13) = (/&
&7.2158E+00_JPRB,5.8804E+00_JPRB,6.5899E+00_JPRB,7.9071E+00_JPRB,1.0068E+01_JPRB/)
KBO( :, 4,19,13) = (/&
&9.2611E+00_JPRB,7.1822E+00_JPRB,7.2047E+00_JPRB,7.9510E+00_JPRB,9.8352E+00_JPRB/)
KBO( :, 5,19,13) = (/&
&1.1520E+01_JPRB,8.7584E+00_JPRB,7.9092E+00_JPRB,8.0447E+00_JPRB,9.6021E+00_JPRB/)
KBO( :, 1,20,13) = (/&
&3.9352E+00_JPRB,4.4974E+00_JPRB,6.4850E+00_JPRB,9.0968E+00_JPRB,1.1862E+01_JPRB/)
KBO( :, 2,20,13) = (/&
&5.4656E+00_JPRB,5.2567E+00_JPRB,6.7702E+00_JPRB,8.9553E+00_JPRB,1.1592E+01_JPRB/)
KBO( :, 3,20,13) = (/&
&7.2432E+00_JPRB,6.1806E+00_JPRB,7.2339E+00_JPRB,8.8912E+00_JPRB,1.1329E+01_JPRB/)
KBO( :, 4,20,13) = (/&
&9.2559E+00_JPRB,7.3730E+00_JPRB,7.8059E+00_JPRB,8.9109E+00_JPRB,1.1059E+01_JPRB/)
KBO( :, 5,20,13) = (/&
&1.1478E+01_JPRB,8.8414E+00_JPRB,8.4557E+00_JPRB,8.9640E+00_JPRB,1.0785E+01_JPRB/)
KBO( :, 1,21,13) = (/&
&3.9152E+00_JPRB,4.8660E+00_JPRB,7.2675E+00_JPRB,1.0177E+01_JPRB,1.3275E+01_JPRB/)
KBO( :, 2,21,13) = (/&
&5.3925E+00_JPRB,5.5769E+00_JPRB,7.5673E+00_JPRB,1.0032E+01_JPRB,1.2988E+01_JPRB/)
KBO( :, 3,21,13) = (/&
&7.1172E+00_JPRB,6.4580E+00_JPRB,7.9491E+00_JPRB,9.9865E+00_JPRB,1.2690E+01_JPRB/)
KBO( :, 4,21,13) = (/&
&9.0683E+00_JPRB,7.5180E+00_JPRB,8.4370E+00_JPRB,9.9647E+00_JPRB,1.2379E+01_JPRB/)
KBO( :, 5,21,13) = (/&
&1.1238E+01_JPRB,8.8639E+00_JPRB,9.0125E+00_JPRB,9.9895E+00_JPRB,1.2064E+01_JPRB/)
KBO( :, 1,22,13) = (/&
&3.8909E+00_JPRB,5.2900E+00_JPRB,8.1566E+00_JPRB,1.1308E+01_JPRB,1.4732E+01_JPRB/)
KBO( :, 2,22,13) = (/&
&5.3181E+00_JPRB,5.9209E+00_JPRB,8.4402E+00_JPRB,1.1175E+01_JPRB,1.4410E+01_JPRB/)
KBO( :, 3,22,13) = (/&
&6.9795E+00_JPRB,6.7348E+00_JPRB,8.7599E+00_JPRB,1.1122E+01_JPRB,1.4067E+01_JPRB/)
KBO( :, 4,22,13) = (/&
&8.8688E+00_JPRB,7.7237E+00_JPRB,9.1513E+00_JPRB,1.1075E+01_JPRB,1.3709E+01_JPRB/)
KBO( :, 5,22,13) = (/&
&1.0970E+01_JPRB,8.9302E+00_JPRB,9.6408E+00_JPRB,1.1105E+01_JPRB,1.3343E+01_JPRB/)
KBO( :, 1,23,13) = (/&
&3.7997E+00_JPRB,5.7292E+00_JPRB,9.0913E+00_JPRB,1.2436E+01_JPRB,1.6180E+01_JPRB/)
KBO( :, 2,23,13) = (/&
&5.1595E+00_JPRB,6.2753E+00_JPRB,9.3535E+00_JPRB,1.2331E+01_JPRB,1.5809E+01_JPRB/)
KBO( :, 3,23,13) = (/&
&6.7493E+00_JPRB,6.9925E+00_JPRB,9.6137E+00_JPRB,1.2263E+01_JPRB,1.5425E+01_JPRB/)
KBO( :, 4,23,13) = (/&
&8.5542E+00_JPRB,7.9012E+00_JPRB,9.9104E+00_JPRB,1.2220E+01_JPRB,1.5025E+01_JPRB/)
KBO( :, 5,23,13) = (/&
&1.0561E+01_JPRB,8.9781E+00_JPRB,1.0309E+01_JPRB,1.2253E+01_JPRB,1.4614E+01_JPRB/)
KBO( :, 1,24,13) = (/&
&3.6631E+00_JPRB,6.1905E+00_JPRB,1.0011E+01_JPRB,1.3544E+01_JPRB,1.7573E+01_JPRB/)
KBO( :, 2,24,13) = (/&
&4.9530E+00_JPRB,6.6528E+00_JPRB,1.0267E+01_JPRB,1.3455E+01_JPRB,1.7161E+01_JPRB/)
KBO( :, 3,24,13) = (/&
&6.4554E+00_JPRB,7.2715E+00_JPRB,1.0481E+01_JPRB,1.3377E+01_JPRB,1.6726E+01_JPRB/)
KBO( :, 4,24,13) = (/&
&8.1608E+00_JPRB,8.0605E+00_JPRB,1.0709E+01_JPRB,1.3365E+01_JPRB,1.6282E+01_JPRB/)
KBO( :, 5,24,13) = (/&
&1.0048E+01_JPRB,9.0171E+00_JPRB,1.1006E+01_JPRB,1.3382E+01_JPRB,1.5827E+01_JPRB/)
KBO( :, 1,25,13) = (/&
&3.5057E+00_JPRB,6.6591E+00_JPRB,1.0912E+01_JPRB,1.4625E+01_JPRB,1.8883E+01_JPRB/)
KBO( :, 2,25,13) = (/&
&4.7154E+00_JPRB,7.0448E+00_JPRB,1.1156E+01_JPRB,1.4541E+01_JPRB,1.8427E+01_JPRB/)
KBO( :, 3,25,13) = (/&
&6.1224E+00_JPRB,7.5602E+00_JPRB,1.1335E+01_JPRB,1.4472E+01_JPRB,1.7954E+01_JPRB/)
KBO( :, 4,25,13) = (/&
&7.7153E+00_JPRB,8.2240E+00_JPRB,1.1508E+01_JPRB,1.4486E+01_JPRB,1.7464E+01_JPRB/)
KBO( :, 5,25,13) = (/&
&9.4941E+00_JPRB,9.0534E+00_JPRB,1.1717E+01_JPRB,1.4473E+01_JPRB,1.6960E+01_JPRB/)
KBO( :, 1,26,13) = (/&
&3.3374E+00_JPRB,7.1235E+00_JPRB,1.1789E+01_JPRB,1.5669E+01_JPRB,2.0088E+01_JPRB/)
KBO( :, 2,26,13) = (/&
&4.4661E+00_JPRB,7.4439E+00_JPRB,1.2007E+01_JPRB,1.5575E+01_JPRB,1.9597E+01_JPRB/)
KBO( :, 3,26,13) = (/&
&5.7769E+00_JPRB,7.8591E+00_JPRB,1.2149E+01_JPRB,1.5545E+01_JPRB,1.9088E+01_JPRB/)
KBO( :, 4,26,13) = (/&
&7.2756E+00_JPRB,8.4078E+00_JPRB,1.2269E+01_JPRB,1.5555E+01_JPRB,1.8555E+01_JPRB/)
KBO( :, 5,26,13) = (/&
&8.9639E+00_JPRB,9.1104E+00_JPRB,1.2401E+01_JPRB,1.5501E+01_JPRB,1.8008E+01_JPRB/)
KBO( :, 1,27,13) = (/&
&3.1533E+00_JPRB,7.5608E+00_JPRB,1.2611E+01_JPRB,1.6642E+01_JPRB,2.1191E+01_JPRB/)
KBO( :, 2,27,13) = (/&
&4.1993E+00_JPRB,7.8220E+00_JPRB,1.2795E+01_JPRB,1.6570E+01_JPRB,2.0672E+01_JPRB/)
KBO( :, 3,27,13) = (/&
&5.4265E+00_JPRB,8.1469E+00_JPRB,1.2900E+01_JPRB,1.6567E+01_JPRB,2.0125E+01_JPRB/)
KBO( :, 4,27,13) = (/&
&6.8378E+00_JPRB,8.5911E+00_JPRB,1.2961E+01_JPRB,1.6544E+01_JPRB,1.9552E+01_JPRB/)
KBO( :, 5,27,13) = (/&
&8.4460E+00_JPRB,9.1761E+00_JPRB,1.3028E+01_JPRB,1.6437E+01_JPRB,1.8965E+01_JPRB/)
KBO( :, 1,28,13) = (/&
&2.9616E+00_JPRB,7.9550E+00_JPRB,1.3362E+01_JPRB,1.7538E+01_JPRB,2.2180E+01_JPRB/)
KBO( :, 2,28,13) = (/&
&3.9383E+00_JPRB,8.1625E+00_JPRB,1.3501E+01_JPRB,1.7502E+01_JPRB,2.1637E+01_JPRB/)
KBO( :, 3,28,13) = (/&
&5.0899E+00_JPRB,8.4137E+00_JPRB,1.3570E+01_JPRB,1.7504E+01_JPRB,2.1054E+01_JPRB/)
KBO( :, 4,28,13) = (/&
&6.4309E+00_JPRB,8.7658E+00_JPRB,1.3582E+01_JPRB,1.7435E+01_JPRB,2.0443E+01_JPRB/)
KBO( :, 5,28,13) = (/&
&7.9687E+00_JPRB,9.2612E+00_JPRB,1.3583E+01_JPRB,1.7274E+01_JPRB,1.9806E+01_JPRB/)
KBO( :, 1,29,13) = (/&
&2.7798E+00_JPRB,8.2996E+00_JPRB,1.4029E+01_JPRB,1.8369E+01_JPRB,2.3056E+01_JPRB/)
KBO( :, 2,29,13) = (/&
&3.6961E+00_JPRB,8.4616E+00_JPRB,1.4123E+01_JPRB,1.8351E+01_JPRB,2.2490E+01_JPRB/)
KBO( :, 3,29,13) = (/&
&4.7900E+00_JPRB,8.6571E+00_JPRB,1.4153E+01_JPRB,1.8339E+01_JPRB,2.1869E+01_JPRB/)
KBO( :, 4,29,13) = (/&
&6.0802E+00_JPRB,8.9313E+00_JPRB,1.4117E+01_JPRB,1.8214E+01_JPRB,2.1214E+01_JPRB/)
KBO( :, 5,29,13) = (/&
&7.5801E+00_JPRB,9.3590E+00_JPRB,1.4065E+01_JPRB,1.8003E+01_JPRB,2.0531E+01_JPRB/)
KBO( :, 1,30,13) = (/&
&2.6097E+00_JPRB,8.5908E+00_JPRB,1.4603E+01_JPRB,1.9121E+01_JPRB,2.3810E+01_JPRB/)
KBO( :, 2,30,13) = (/&
&3.4798E+00_JPRB,8.7177E+00_JPRB,1.4662E+01_JPRB,1.9123E+01_JPRB,2.3210E+01_JPRB/)
KBO( :, 3,30,13) = (/&
&4.5355E+00_JPRB,8.8683E+00_JPRB,1.4648E+01_JPRB,1.9056E+01_JPRB,2.2548E+01_JPRB/)
KBO( :, 4,30,13) = (/&
&5.7939E+00_JPRB,9.0839E+00_JPRB,1.4573E+01_JPRB,1.8881E+01_JPRB,2.1848E+01_JPRB/)
KBO( :, 5,30,13) = (/&
&7.2765E+00_JPRB,9.4615E+00_JPRB,1.4472E+01_JPRB,1.8622E+01_JPRB,2.1123E+01_JPRB/)
KBO( :, 1,31,13) = (/&
&2.4675E+00_JPRB,8.8387E+00_JPRB,1.5097E+01_JPRB,1.9786E+01_JPRB,2.4442E+01_JPRB/)
KBO( :, 2,31,13) = (/&
&3.3065E+00_JPRB,8.9332E+00_JPRB,1.5120E+01_JPRB,1.9782E+01_JPRB,2.3801E+01_JPRB/)
KBO( :, 3,31,13) = (/&
&4.3370E+00_JPRB,9.0438E+00_JPRB,1.5067E+01_JPRB,1.9662E+01_JPRB,2.3103E+01_JPRB/)
KBO( :, 4,31,13) = (/&
&5.5801E+00_JPRB,9.2263E+00_JPRB,1.4955E+01_JPRB,1.9437E+01_JPRB,2.2362E+01_JPRB/)
KBO( :, 5,31,13) = (/&
&7.0509E+00_JPRB,9.5653E+00_JPRB,1.4810E+01_JPRB,1.9130E+01_JPRB,2.1597E+01_JPRB/)
KBO( :, 1,32,13) = (/&
&2.3570E+00_JPRB,9.0474E+00_JPRB,1.5512E+01_JPRB,2.0376E+01_JPRB,2.4941E+01_JPRB/)
KBO( :, 2,32,13) = (/&
&3.1778E+00_JPRB,9.1115E+00_JPRB,1.5508E+01_JPRB,2.0335E+01_JPRB,2.4268E+01_JPRB/)
KBO( :, 3,32,13) = (/&
&4.1934E+00_JPRB,9.1907E+00_JPRB,1.5415E+01_JPRB,2.0161E+01_JPRB,2.3538E+01_JPRB/)
KBO( :, 4,32,13) = (/&
&5.4301E+00_JPRB,9.3557E+00_JPRB,1.5262E+01_JPRB,1.9889E+01_JPRB,2.2767E+01_JPRB/)
KBO( :, 5,32,13) = (/&
&6.9074E+00_JPRB,9.6740E+00_JPRB,1.5082E+01_JPRB,1.9542E+01_JPRB,2.1974E+01_JPRB/)
KBO( :, 1,33,13) = (/&
&2.2789E+00_JPRB,9.2179E+00_JPRB,1.5861E+01_JPRB,2.0884E+01_JPRB,2.5338E+01_JPRB/)
KBO( :, 2,33,13) = (/&
&3.0898E+00_JPRB,9.2539E+00_JPRB,1.5825E+01_JPRB,2.0788E+01_JPRB,2.4635E+01_JPRB/)
KBO( :, 3,33,13) = (/&
&4.1032E+00_JPRB,9.3163E+00_JPRB,1.5692E+01_JPRB,2.0569E+01_JPRB,2.3873E+01_JPRB/)
KBO( :, 4,33,13) = (/&
&5.3488E+00_JPRB,9.4706E+00_JPRB,1.5505E+01_JPRB,2.0254E+01_JPRB,2.3076E+01_JPRB/)
KBO( :, 5,33,13) = (/&
&6.8488E+00_JPRB,9.7721E+00_JPRB,1.5299E+01_JPRB,1.9864E+01_JPRB,2.2268E+01_JPRB/)
KBO( :, 1,34,13) = (/&
&2.2036E+00_JPRB,9.3532E+00_JPRB,1.6153E+01_JPRB,2.1306E+01_JPRB,2.5672E+01_JPRB/)
KBO( :, 2,34,13) = (/&
&3.0096E+00_JPRB,9.3699E+00_JPRB,1.6083E+01_JPRB,2.1168E+01_JPRB,2.4937E+01_JPRB/)
KBO( :, 3,34,13) = (/&
&4.0278E+00_JPRB,9.4208E+00_JPRB,1.5917E+01_JPRB,2.0905E+01_JPRB,2.4148E+01_JPRB/)
KBO( :, 4,34,13) = (/&
&5.2881E+00_JPRB,9.5680E+00_JPRB,1.5706E+01_JPRB,2.0553E+01_JPRB,2.3339E+01_JPRB/)
KBO( :, 5,34,13) = (/&
&6.8127E+00_JPRB,9.8518E+00_JPRB,1.5477E+01_JPRB,2.0124E+01_JPRB,2.2490E+01_JPRB/)
KBO( :, 1,35,13) = (/&
&2.0911E+00_JPRB,9.4628E+00_JPRB,1.6401E+01_JPRB,2.1656E+01_JPRB,2.5992E+01_JPRB/)
KBO( :, 2,35,13) = (/&
&2.8838E+00_JPRB,9.4629E+00_JPRB,1.6303E+01_JPRB,2.1492E+01_JPRB,2.5233E+01_JPRB/)
KBO( :, 3,35,13) = (/&
&3.8959E+00_JPRB,9.5011E+00_JPRB,1.6117E+01_JPRB,2.1198E+01_JPRB,2.4439E+01_JPRB/)
KBO( :, 4,35,13) = (/&
&5.1566E+00_JPRB,9.6352E+00_JPRB,1.5885E+01_JPRB,2.0818E+01_JPRB,2.3603E+01_JPRB/)
KBO( :, 5,35,13) = (/&
&6.6907E+00_JPRB,9.8962E+00_JPRB,1.5633E+01_JPRB,2.0364E+01_JPRB,2.2731E+01_JPRB/)
KBO( :, 1,36,13) = (/&
&1.9336E+00_JPRB,9.5525E+00_JPRB,1.6611E+01_JPRB,2.1959E+01_JPRB,2.6325E+01_JPRB/)
KBO( :, 2,36,13) = (/&
&2.7002E+00_JPRB,9.5428E+00_JPRB,1.6501E+01_JPRB,2.1782E+01_JPRB,2.5563E+01_JPRB/)
KBO( :, 3,36,13) = (/&
&3.6889E+00_JPRB,9.5627E+00_JPRB,1.6302E+01_JPRB,2.1472E+01_JPRB,2.4764E+01_JPRB/)
KBO( :, 4,36,13) = (/&
&4.9268E+00_JPRB,9.6763E+00_JPRB,1.6053E+01_JPRB,2.1074E+01_JPRB,2.3903E+01_JPRB/)
KBO( :, 5,36,13) = (/&
&6.4449E+00_JPRB,9.9025E+00_JPRB,1.5784E+01_JPRB,2.0602E+01_JPRB,2.3039E+01_JPRB/)
KBO( :, 1,37,13) = (/&
&1.7104E+00_JPRB,9.6249E+00_JPRB,1.6795E+01_JPRB,2.2228E+01_JPRB,2.6709E+01_JPRB/)
KBO( :, 2,37,13) = (/&
&2.4252E+00_JPRB,9.6135E+00_JPRB,1.6690E+01_JPRB,2.2061E+01_JPRB,2.5960E+01_JPRB/)
KBO( :, 3,37,13) = (/&
&3.3606E+00_JPRB,9.6107E+00_JPRB,1.6491E+01_JPRB,2.1757E+01_JPRB,2.5160E+01_JPRB/)
KBO( :, 4,37,13) = (/&
&4.5420E+00_JPRB,9.6944E+00_JPRB,1.6238E+01_JPRB,2.1356E+01_JPRB,2.4291E+01_JPRB/)
KBO( :, 5,37,13) = (/&
&6.0039E+00_JPRB,9.8734E+00_JPRB,1.5956E+01_JPRB,2.0878E+01_JPRB,2.3432E+01_JPRB/)
KBO( :, 1,38,13) = (/&
&1.5178E+00_JPRB,9.6872E+00_JPRB,1.6953E+01_JPRB,2.2459E+01_JPRB,2.7050E+01_JPRB/)
KBO( :, 2,38,13) = (/&
&2.1837E+00_JPRB,9.6773E+00_JPRB,1.6856E+01_JPRB,2.2300E+01_JPRB,2.6324E+01_JPRB/)
KBO( :, 3,38,13) = (/&
&3.0661E+00_JPRB,9.6576E+00_JPRB,1.6660E+01_JPRB,2.2007E+01_JPRB,2.5527E+01_JPRB/)
KBO( :, 4,38,13) = (/&
&4.1937E+00_JPRB,9.7120E+00_JPRB,1.6406E+01_JPRB,2.1607E+01_JPRB,2.4654E+01_JPRB/)
KBO( :, 5,38,13) = (/&
&5.6039E+00_JPRB,9.8559E+00_JPRB,1.6114E+01_JPRB,2.1125E+01_JPRB,2.3814E+01_JPRB/)
KBO( :, 1,39,13) = (/&
&1.3554E+00_JPRB,9.7390E+00_JPRB,1.7088E+01_JPRB,2.2653E+01_JPRB,2.7361E+01_JPRB/)
KBO( :, 2,39,13) = (/&
&1.9775E+00_JPRB,9.7313E+00_JPRB,1.6998E+01_JPRB,2.2506E+01_JPRB,2.6660E+01_JPRB/)
KBO( :, 3,39,13) = (/&
&2.8107E+00_JPRB,9.7018E+00_JPRB,1.6808E+01_JPRB,2.2224E+01_JPRB,2.5863E+01_JPRB/)
KBO( :, 4,39,13) = (/&
&3.8900E+00_JPRB,9.7305E+00_JPRB,1.6552E+01_JPRB,2.1827E+01_JPRB,2.4995E+01_JPRB/)
KBO( :, 5,39,13) = (/&
&5.2496E+00_JPRB,9.8477E+00_JPRB,1.6251E+01_JPRB,2.1343E+01_JPRB,2.4180E+01_JPRB/)
KBO( :, 1,40,13) = (/&
&1.1681E+00_JPRB,9.7791E+00_JPRB,1.7201E+01_JPRB,2.2818E+01_JPRB,2.7695E+01_JPRB/)
KBO( :, 2,40,13) = (/&
&1.7299E+00_JPRB,9.7827E+00_JPRB,1.7132E+01_JPRB,2.2703E+01_JPRB,2.7023E+01_JPRB/)
KBO( :, 3,40,13) = (/&
&2.4946E+00_JPRB,9.7467E+00_JPRB,1.6955E+01_JPRB,2.2448E+01_JPRB,2.6240E+01_JPRB/)
KBO( :, 4,40,13) = (/&
&3.5017E+00_JPRB,9.7482E+00_JPRB,1.6709E+01_JPRB,2.2060E+01_JPRB,2.5376E+01_JPRB/)
KBO( :, 5,40,13) = (/&
&4.7836E+00_JPRB,9.8329E+00_JPRB,1.6405E+01_JPRB,2.1591E+01_JPRB,2.4561E+01_JPRB/)
KBO( :, 1,41,13) = (/&
&1.0033E+00_JPRB,9.8102E+00_JPRB,1.7286E+01_JPRB,2.2943E+01_JPRB,2.8002E+01_JPRB/)
KBO( :, 2,41,13) = (/&
&1.5079E+00_JPRB,9.8257E+00_JPRB,1.7243E+01_JPRB,2.2872E+01_JPRB,2.7362E+01_JPRB/)
KBO( :, 3,41,13) = (/&
&2.2063E+00_JPRB,9.7913E+00_JPRB,1.7089E+01_JPRB,2.2643E+01_JPRB,2.6601E+01_JPRB/)
KBO( :, 4,41,13) = (/&
&3.1401E+00_JPRB,9.7698E+00_JPRB,1.6851E+01_JPRB,2.2278E+01_JPRB,2.5742E+01_JPRB/)
KBO( :, 5,41,13) = (/&
&4.3440E+00_JPRB,9.8243E+00_JPRB,1.6560E+01_JPRB,2.1826E+01_JPRB,2.4926E+01_JPRB/)
KBO( :, 1,42,13) = (/&
&8.6335E-01_JPRB,9.8273E+00_JPRB,1.7356E+01_JPRB,2.3044E+01_JPRB,2.8283E+01_JPRB/)
KBO( :, 2,42,13) = (/&
&1.3157E+00_JPRB,9.8564E+00_JPRB,1.7335E+01_JPRB,2.3007E+01_JPRB,2.7677E+01_JPRB/)
KBO( :, 3,42,13) = (/&
&1.9522E+00_JPRB,9.8313E+00_JPRB,1.7204E+01_JPRB,2.2814E+01_JPRB,2.6940E+01_JPRB/)
KBO( :, 4,42,13) = (/&
&2.8149E+00_JPRB,9.7926E+00_JPRB,1.6984E+01_JPRB,2.2480E+01_JPRB,2.6086E+01_JPRB/)
KBO( :, 5,42,13) = (/&
&3.9427E+00_JPRB,9.8251E+00_JPRB,1.6704E+01_JPRB,2.2040E+01_JPRB,2.5280E+01_JPRB/)
KBO( :, 1,43,13) = (/&
&7.2508E-01_JPRB,9.8337E+00_JPRB,1.7398E+01_JPRB,2.3109E+01_JPRB,2.8558E+01_JPRB/)
KBO( :, 2,43,13) = (/&
&1.1220E+00_JPRB,9.8829E+00_JPRB,1.7414E+01_JPRB,2.3123E+01_JPRB,2.7999E+01_JPRB/)
KBO( :, 3,43,13) = (/&
&1.6895E+00_JPRB,9.8684E+00_JPRB,1.7314E+01_JPRB,2.2973E+01_JPRB,2.7299E+01_JPRB/)
KBO( :, 4,43,13) = (/&
&2.4716E+00_JPRB,9.8264E+00_JPRB,1.7115E+01_JPRB,2.2681E+01_JPRB,2.6464E+01_JPRB/)
KBO( :, 5,43,13) = (/&
&3.5092E+00_JPRB,9.8254E+00_JPRB,1.6846E+01_JPRB,2.2258E+01_JPRB,2.5655E+01_JPRB/)
KBO( :, 1,44,13) = (/&
&6.0013E-01_JPRB,9.8242E+00_JPRB,1.7407E+01_JPRB,2.3147E+01_JPRB,2.8810E+01_JPRB/)
KBO( :, 2,44,13) = (/&
&9.4539E-01_JPRB,9.8972E+00_JPRB,1.7468E+01_JPRB,2.3207E+01_JPRB,2.8309E+01_JPRB/)
KBO( :, 3,44,13) = (/&
&1.4447E+00_JPRB,9.9041E+00_JPRB,1.7409E+01_JPRB,2.3114E+01_JPRB,2.7658E+01_JPRB/)
KBO( :, 4,44,13) = (/&
&2.1455E+00_JPRB,9.8623E+00_JPRB,1.7235E+01_JPRB,2.2860E+01_JPRB,2.6847E+01_JPRB/)
KBO( :, 5,44,13) = (/&
&3.0884E+00_JPRB,9.8324E+00_JPRB,1.6982E+01_JPRB,2.2470E+01_JPRB,2.6041E+01_JPRB/)
KBO( :, 1,45,13) = (/&
&4.9465E-01_JPRB,9.7992E+00_JPRB,1.7389E+01_JPRB,2.3167E+01_JPRB,2.9031E+01_JPRB/)
KBO( :, 2,45,13) = (/&
&7.9499E-01_JPRB,9.8981E+00_JPRB,1.7509E+01_JPRB,2.3257E+01_JPRB,2.8598E+01_JPRB/)
KBO( :, 3,45,13) = (/&
&1.2327E+00_JPRB,9.9225E+00_JPRB,1.7478E+01_JPRB,2.3219E+01_JPRB,2.7995E+01_JPRB/)
KBO( :, 4,45,13) = (/&
&1.8567E+00_JPRB,9.8915E+00_JPRB,1.7341E+01_JPRB,2.3018E+01_JPRB,2.7214E+01_JPRB/)
KBO( :, 5,45,13) = (/&
&2.7102E+00_JPRB,9.8493E+00_JPRB,1.7115E+01_JPRB,2.2672E+01_JPRB,2.6426E+01_JPRB/)
KBO( :, 1,46,13) = (/&
&4.0155E-01_JPRB,9.7565E+00_JPRB,1.7327E+01_JPRB,2.3150E+01_JPRB,2.9223E+01_JPRB/)
KBO( :, 2,46,13) = (/&
&6.5885E-01_JPRB,9.8895E+00_JPRB,1.7519E+01_JPRB,2.3282E+01_JPRB,2.8865E+01_JPRB/)
KBO( :, 3,46,13) = (/&
&1.0393E+00_JPRB,9.9389E+00_JPRB,1.7538E+01_JPRB,2.3304E+01_JPRB,2.8321E+01_JPRB/)
KBO( :, 4,46,13) = (/&
&1.5881E+00_JPRB,9.9248E+00_JPRB,1.7436E+01_JPRB,2.3155E+01_JPRB,2.7586E+01_JPRB/)
KBO( :, 5,46,13) = (/&
&2.3518E+00_JPRB,9.8787E+00_JPRB,1.7232E+01_JPRB,2.2856E+01_JPRB,2.6820E+01_JPRB/)
KBO( :, 1,47,13) = (/&
&3.1717E-01_JPRB,9.6922E+00_JPRB,1.7208E+01_JPRB,2.3094E+01_JPRB,2.9376E+01_JPRB/)
KBO( :, 2,47,13) = (/&
&5.3176E-01_JPRB,9.8626E+00_JPRB,1.7496E+01_JPRB,2.3281E+01_JPRB,2.9106E+01_JPRB/)
KBO( :, 3,47,13) = (/&
&8.5644E-01_JPRB,9.9410E+00_JPRB,1.7572E+01_JPRB,2.3352E+01_JPRB,2.8639E+01_JPRB/)
KBO( :, 4,47,13) = (/&
&1.3291E+00_JPRB,9.9482E+00_JPRB,1.7517E+01_JPRB,2.3272E+01_JPRB,2.7966E+01_JPRB/)
KBO( :, 5,47,13) = (/&
&1.9994E+00_JPRB,9.9068E+00_JPRB,1.7348E+01_JPRB,2.3029E+01_JPRB,2.7224E+01_JPRB/)
KBO( :, 1,48,13) = (/&
&2.4862E-01_JPRB,9.6017E+00_JPRB,1.7047E+01_JPRB,2.3003E+01_JPRB,2.9483E+01_JPRB/)
KBO( :, 2,48,13) = (/&
&4.2613E-01_JPRB,9.8140E+00_JPRB,1.7433E+01_JPRB,2.3259E+01_JPRB,2.9313E+01_JPRB/)
KBO( :, 3,48,13) = (/&
&7.0129E-01_JPRB,9.9267E+00_JPRB,1.7586E+01_JPRB,2.3367E+01_JPRB,2.8930E+01_JPRB/)
KBO( :, 4,48,13) = (/&
&1.1072E+00_JPRB,9.9609E+00_JPRB,1.7574E+01_JPRB,2.3356E+01_JPRB,2.8330E+01_JPRB/)
KBO( :, 5,48,13) = (/&
&1.6909E+00_JPRB,9.9361E+00_JPRB,1.7449E+01_JPRB,2.3177E+01_JPRB,2.7634E+01_JPRB/)
KBO( :, 1,49,13) = (/&
&1.9264E-01_JPRB,9.4936E+00_JPRB,1.6831E+01_JPRB,2.2884E+01_JPRB,2.9536E+01_JPRB/)
KBO( :, 2,49,13) = (/&
&3.3927E-01_JPRB,9.7516E+00_JPRB,1.7325E+01_JPRB,2.3198E+01_JPRB,2.9479E+01_JPRB/)
KBO( :, 3,49,13) = (/&
&5.6996E-01_JPRB,9.9055E+00_JPRB,1.7565E+01_JPRB,2.3359E+01_JPRB,2.9191E+01_JPRB/)
KBO( :, 4,49,13) = (/&
&9.1758E-01_JPRB,9.9664E+00_JPRB,1.7609E+01_JPRB,2.3411E+01_JPRB,2.8684E+01_JPRB/)
KBO( :, 5,49,13) = (/&
&1.4225E+00_JPRB,9.9636E+00_JPRB,1.7532E+01_JPRB,2.3297E+01_JPRB,2.8060E+01_JPRB/)
KBO( :, 1,50,13) = (/&
&1.4991E-01_JPRB,9.3720E+00_JPRB,1.6585E+01_JPRB,2.2746E+01_JPRB,2.9526E+01_JPRB/)
KBO( :, 2,50,13) = (/&
&2.7206E-01_JPRB,9.6777E+00_JPRB,1.7184E+01_JPRB,2.3116E+01_JPRB,2.9581E+01_JPRB/)
KBO( :, 3,50,13) = (/&
&4.6587E-01_JPRB,9.8653E+00_JPRB,1.7520E+01_JPRB,2.3339E+01_JPRB,2.9394E+01_JPRB/)
KBO( :, 4,50,13) = (/&
&7.6520E-01_JPRB,9.9556E+00_JPRB,1.7628E+01_JPRB,2.3427E+01_JPRB,2.8975E+01_JPRB/)
KBO( :, 5,50,13) = (/&
&1.2040E+00_JPRB,9.9732E+00_JPRB,1.7585E+01_JPRB,2.3377E+01_JPRB,2.8410E+01_JPRB/)
KBO( :, 1,51,13) = (/&
&1.1613E-01_JPRB,9.2274E+00_JPRB,1.6313E+01_JPRB,2.2591E+01_JPRB,2.9458E+01_JPRB/)
KBO( :, 2,51,13) = (/&
&2.1747E-01_JPRB,9.5837E+00_JPRB,1.7015E+01_JPRB,2.3015E+01_JPRB,2.9634E+01_JPRB/)
KBO( :, 3,51,13) = (/&
&3.8080E-01_JPRB,9.8127E+00_JPRB,1.7438E+01_JPRB,2.3293E+01_JPRB,2.9540E+01_JPRB/)
KBO( :, 4,51,13) = (/&
&6.3740E-01_JPRB,9.9403E+00_JPRB,1.7621E+01_JPRB,2.3422E+01_JPRB,2.9215E+01_JPRB/)
KBO( :, 5,51,13) = (/&
&1.0193E+00_JPRB,9.9828E+00_JPRB,1.7629E+01_JPRB,2.3438E+01_JPRB,2.8716E+01_JPRB/)
KBO( :, 1,52,13) = (/&
&8.8830E-02_JPRB,9.0603E+00_JPRB,1.6002E+01_JPRB,2.2409E+01_JPRB,2.9330E+01_JPRB/)
KBO( :, 2,52,13) = (/&
&1.7228E-01_JPRB,9.4776E+00_JPRB,1.6796E+01_JPRB,2.2887E+01_JPRB,2.9643E+01_JPRB/)
KBO( :, 3,52,13) = (/&
&3.0974E-01_JPRB,9.7502E+00_JPRB,1.7322E+01_JPRB,2.3223E+01_JPRB,2.9659E+01_JPRB/)
KBO( :, 4,52,13) = (/&
&5.2763E-01_JPRB,9.9116E+00_JPRB,1.7589E+01_JPRB,2.3402E+01_JPRB,2.9438E+01_JPRB/)
KBO( :, 5,52,13) = (/&
&8.5949E-01_JPRB,9.9800E+00_JPRB,1.7648E+01_JPRB,2.3465E+01_JPRB,2.9019E+01_JPRB/)
KBO( :, 1,53,13) = (/&
&6.6880E-02_JPRB,8.8647E+00_JPRB,1.5677E+01_JPRB,2.2193E+01_JPRB,2.9155E+01_JPRB/)
KBO( :, 2,53,13) = (/&
&1.3508E-01_JPRB,9.3494E+00_JPRB,1.6545E+01_JPRB,2.2742E+01_JPRB,2.9618E+01_JPRB/)
KBO( :, 3,53,13) = (/&
&2.5013E-01_JPRB,9.6673E+00_JPRB,1.7171E+01_JPRB,2.3128E+01_JPRB,2.9750E+01_JPRB/)
KBO( :, 4,53,13) = (/&
&4.3419E-01_JPRB,9.8656E+00_JPRB,1.7531E+01_JPRB,2.3368E+01_JPRB,2.9650E+01_JPRB/)
KBO( :, 5,53,13) = (/&
&7.2052E-01_JPRB,9.9643E+00_JPRB,1.7656E+01_JPRB,2.3466E+01_JPRB,2.9335E+01_JPRB/)
KBO( :, 1,54,13) = (/&
&5.0839E-02_JPRB,8.6560E+00_JPRB,1.5373E+01_JPRB,2.1974E+01_JPRB,2.8918E+01_JPRB/)
KBO( :, 2,54,13) = (/&
&1.0673E-01_JPRB,9.2095E+00_JPRB,1.6282E+01_JPRB,2.2589E+01_JPRB,2.9523E+01_JPRB/)
KBO( :, 3,54,13) = (/&
&2.0374E-01_JPRB,9.5773E+00_JPRB,1.7000E+01_JPRB,2.3024E+01_JPRB,2.9743E+01_JPRB/)
KBO( :, 4,54,13) = (/&
&3.6116E-01_JPRB,9.8132E+00_JPRB,1.7444E+01_JPRB,2.3313E+01_JPRB,2.9733E+01_JPRB/)
KBO( :, 5,54,13) = (/&
&6.0938E-01_JPRB,9.9478E+00_JPRB,1.7641E+01_JPRB,2.3452E+01_JPRB,2.9479E+01_JPRB/)
KBO( :, 1,55,13) = (/&
&3.8590E-02_JPRB,8.4380E+00_JPRB,1.5071E+01_JPRB,2.1738E+01_JPRB,2.8629E+01_JPRB/)
KBO( :, 2,55,13) = (/&
&8.4187E-02_JPRB,9.0594E+00_JPRB,1.6002E+01_JPRB,2.2420E+01_JPRB,2.9369E+01_JPRB/)
KBO( :, 3,55,13) = (/&
&1.6606E-01_JPRB,9.4812E+00_JPRB,1.6803E+01_JPRB,2.2906E+01_JPRB,2.9692E+01_JPRB/)
KBO( :, 4,55,13) = (/&
&3.0143E-01_JPRB,9.7562E+00_JPRB,1.7333E+01_JPRB,2.3245E+01_JPRB,2.9737E+01_JPRB/)
KBO( :, 5,55,13) = (/&
&5.1631E-01_JPRB,9.9193E+00_JPRB,1.7608E+01_JPRB,2.3429E+01_JPRB,2.9535E+01_JPRB/)
KBO( :, 1,56,13) = (/&
&2.8925E-02_JPRB,8.1981E+00_JPRB,1.4756E+01_JPRB,2.1468E+01_JPRB,2.8292E+01_JPRB/)
KBO( :, 2,56,13) = (/&
&6.5661E-02_JPRB,8.8869E+00_JPRB,1.5713E+01_JPRB,2.2226E+01_JPRB,2.9164E+01_JPRB/)
KBO( :, 3,56,13) = (/&
&1.3426E-01_JPRB,9.3664E+00_JPRB,1.6578E+01_JPRB,2.2772E+01_JPRB,2.9626E+01_JPRB/)
KBO( :, 4,56,13) = (/&
&2.5023E-01_JPRB,9.6820E+00_JPRB,1.7199E+01_JPRB,2.3159E+01_JPRB,2.9723E+01_JPRB/)
KBO( :, 5,56,13) = (/&
&4.3568E-01_JPRB,9.8776E+00_JPRB,1.7553E+01_JPRB,2.3395E+01_JPRB,2.9592E+01_JPRB/)
KBO( :, 1,57,13) = (/&
&2.1373E-02_JPRB,7.9379E+00_JPRB,1.4433E+01_JPRB,2.1148E+01_JPRB,2.7903E+01_JPRB/)
KBO( :, 2,57,13) = (/&
&5.0645E-02_JPRB,8.6879E+00_JPRB,1.5420E+01_JPRB,2.2015E+01_JPRB,2.8928E+01_JPRB/)
KBO( :, 3,57,13) = (/&
&1.0745E-01_JPRB,9.2330E+00_JPRB,1.6328E+01_JPRB,2.2623E+01_JPRB,2.9512E+01_JPRB/)
KBO( :, 4,57,13) = (/&
&2.0610E-01_JPRB,9.5955E+00_JPRB,1.7038E+01_JPRB,2.3057E+01_JPRB,2.9704E+01_JPRB/)
KBO( :, 5,57,13) = (/&
&3.6599E-01_JPRB,9.8279E+00_JPRB,1.7470E+01_JPRB,2.3341E+01_JPRB,2.9632E+01_JPRB/)
KBO( :, 1,58,13) = (/&
&1.5800E-02_JPRB,7.6756E+00_JPRB,1.4130E+01_JPRB,2.0811E+01_JPRB,2.7488E+01_JPRB/)
KBO( :, 2,58,13) = (/&
&3.9154E-02_JPRB,8.4827E+00_JPRB,1.5134E+01_JPRB,2.1791E+01_JPRB,2.8663E+01_JPRB/)
KBO( :, 3,58,13) = (/&
&8.6058E-02_JPRB,9.0936E+00_JPRB,1.6064E+01_JPRB,2.2465E+01_JPRB,2.9358E+01_JPRB/)
KBO( :, 4,58,13) = (/&
&1.7024E-01_JPRB,9.5047E+00_JPRB,1.6851E+01_JPRB,2.2942E+01_JPRB,2.9664E+01_JPRB/)
KBO( :, 5,58,13) = (/&
&3.0899E-01_JPRB,9.7734E+00_JPRB,1.7367E+01_JPRB,2.3275E+01_JPRB,2.9640E+01_JPRB/)
KBO( :, 1,59,13) = (/&
&1.3838E-02_JPRB,7.5677E+00_JPRB,1.4007E+01_JPRB,2.0664E+01_JPRB,2.7307E+01_JPRB/)
KBO( :, 2,59,13) = (/&
&3.5056E-02_JPRB,8.3966E+00_JPRB,1.5017E+01_JPRB,2.1696E+01_JPRB,2.8542E+01_JPRB/)
KBO( :, 3,59,13) = (/&
&7.8363E-02_JPRB,9.0327E+00_JPRB,1.5954E+01_JPRB,2.2395E+01_JPRB,2.9259E+01_JPRB/)
KBO( :, 4,59,13) = (/&
&1.5720E-01_JPRB,9.4649E+00_JPRB,1.6772E+01_JPRB,2.2896E+01_JPRB,2.9587E+01_JPRB/)
KBO( :, 5,59,13) = (/&
&2.8816E-01_JPRB,9.7494E+00_JPRB,1.7321E+01_JPRB,2.3246E+01_JPRB,2.9569E+01_JPRB/)
KBO( :, 1,13,14) = (/&
&4.6782E+00_JPRB,3.6509E+00_JPRB,4.2069E+00_JPRB,5.5965E+00_JPRB,7.3161E+00_JPRB/)
KBO( :, 2,13,14) = (/&
&6.6812E+00_JPRB,5.1302E+00_JPRB,4.5042E+00_JPRB,5.7107E+00_JPRB,7.2956E+00_JPRB/)
KBO( :, 3,13,14) = (/&
&9.0802E+00_JPRB,6.9191E+00_JPRB,5.0854E+00_JPRB,5.8389E+00_JPRB,7.2254E+00_JPRB/)
KBO( :, 4,13,14) = (/&
&1.1847E+01_JPRB,8.9860E+00_JPRB,6.1879E+00_JPRB,5.9827E+00_JPRB,7.1308E+00_JPRB/)
KBO( :, 5,13,14) = (/&
&1.4944E+01_JPRB,1.1307E+01_JPRB,7.6807E+00_JPRB,6.1087E+00_JPRB,7.0090E+00_JPRB/)
KBO( :, 1,14,14) = (/&
&4.9923E+00_JPRB,3.8888E+00_JPRB,4.7381E+00_JPRB,6.4037E+00_JPRB,8.3224E+00_JPRB/)
KBO( :, 2,14,14) = (/&
&7.1439E+00_JPRB,5.4635E+00_JPRB,4.9958E+00_JPRB,6.5120E+00_JPRB,8.2505E+00_JPRB/)
KBO( :, 3,14,14) = (/&
&9.7357E+00_JPRB,7.4026E+00_JPRB,5.5402E+00_JPRB,6.6306E+00_JPRB,8.1450E+00_JPRB/)
KBO( :, 4,14,14) = (/&
&1.2709E+01_JPRB,9.6301E+00_JPRB,6.6722E+00_JPRB,6.7341E+00_JPRB,8.0104E+00_JPRB/)
KBO( :, 5,14,14) = (/&
&1.6035E+01_JPRB,1.2120E+01_JPRB,8.2226E+00_JPRB,6.8436E+00_JPRB,7.8600E+00_JPRB/)
KBO( :, 1,15,14) = (/&
&5.4062E+00_JPRB,4.2107E+00_JPRB,5.3329E+00_JPRB,7.2809E+00_JPRB,9.4098E+00_JPRB/)
KBO( :, 2,15,14) = (/&
&7.7383E+00_JPRB,5.9068E+00_JPRB,5.5826E+00_JPRB,7.3825E+00_JPRB,9.2906E+00_JPRB/)
KBO( :, 3,15,14) = (/&
&1.0510E+01_JPRB,7.9793E+00_JPRB,6.1638E+00_JPRB,7.4874E+00_JPRB,9.1316E+00_JPRB/)
KBO( :, 4,15,14) = (/&
&1.3725E+01_JPRB,1.0385E+01_JPRB,7.2775E+00_JPRB,7.5682E+00_JPRB,8.9529E+00_JPRB/)
KBO( :, 5,15,14) = (/&
&1.7334E+01_JPRB,1.3091E+01_JPRB,8.9110E+00_JPRB,7.6564E+00_JPRB,8.7607E+00_JPRB/)
KBO( :, 1,16,14) = (/&
&5.9070E+00_JPRB,4.6227E+00_JPRB,6.0140E+00_JPRB,8.2333E+00_JPRB,1.0600E+01_JPRB/)
KBO( :, 2,16,14) = (/&
&8.4297E+00_JPRB,6.4209E+00_JPRB,6.2881E+00_JPRB,8.3090E+00_JPRB,1.0416E+01_JPRB/)
KBO( :, 3,16,14) = (/&
&1.1476E+01_JPRB,8.7000E+00_JPRB,6.9539E+00_JPRB,8.3944E+00_JPRB,1.0210E+01_JPRB/)
KBO( :, 4,16,14) = (/&
&1.4985E+01_JPRB,1.1333E+01_JPRB,8.0898E+00_JPRB,8.4541E+00_JPRB,9.9887E+00_JPRB/)
KBO( :, 5,16,14) = (/&
&1.8893E+01_JPRB,1.4263E+01_JPRB,9.7433E+00_JPRB,8.5272E+00_JPRB,9.7516E+00_JPRB/)
KBO( :, 1,17,14) = (/&
&6.5286E+00_JPRB,5.1327E+00_JPRB,6.7700E+00_JPRB,9.2670E+00_JPRB,1.1882E+01_JPRB/)
KBO( :, 2,17,14) = (/&
&9.3114E+00_JPRB,7.0853E+00_JPRB,7.1236E+00_JPRB,9.3227E+00_JPRB,1.1650E+01_JPRB/)
KBO( :, 3,17,14) = (/&
&1.2634E+01_JPRB,9.5700E+00_JPRB,7.8705E+00_JPRB,9.3681E+00_JPRB,1.1400E+01_JPRB/)
KBO( :, 4,17,14) = (/&
&1.6437E+01_JPRB,1.2419E+01_JPRB,9.0210E+00_JPRB,9.4013E+00_JPRB,1.1124E+01_JPRB/)
KBO( :, 5,17,14) = (/&
&2.0695E+01_JPRB,1.5610E+01_JPRB,1.0717E+01_JPRB,9.5036E+00_JPRB,1.0836E+01_JPRB/)
KBO( :, 1,18,14) = (/&
&7.2317E+00_JPRB,5.7331E+00_JPRB,7.5895E+00_JPRB,1.0388E+01_JPRB,1.3283E+01_JPRB/)
KBO( :, 2,18,14) = (/&
&1.0272E+01_JPRB,7.8128E+00_JPRB,8.0485E+00_JPRB,1.0408E+01_JPRB,1.2989E+01_JPRB/)
KBO( :, 3,18,14) = (/&
&1.3865E+01_JPRB,1.0490E+01_JPRB,8.8399E+00_JPRB,1.0411E+01_JPRB,1.2668E+01_JPRB/)
KBO( :, 4,18,14) = (/&
&1.8001E+01_JPRB,1.3591E+01_JPRB,1.0044E+01_JPRB,1.0415E+01_JPRB,1.2336E+01_JPRB/)
KBO( :, 5,18,14) = (/&
&2.2607E+01_JPRB,1.7043E+01_JPRB,1.1818E+01_JPRB,1.0584E+01_JPRB,1.2000E+01_JPRB/)
KBO( :, 1,19,14) = (/&
&7.9818E+00_JPRB,6.4241E+00_JPRB,8.4744E+00_JPRB,1.1590E+01_JPRB,1.4808E+01_JPRB/)
KBO( :, 2,19,14) = (/&
&1.1265E+01_JPRB,8.5751E+00_JPRB,9.0608E+00_JPRB,1.1546E+01_JPRB,1.4436E+01_JPRB/)
KBO( :, 3,19,14) = (/&
&1.5159E+01_JPRB,1.1457E+01_JPRB,9.8998E+00_JPRB,1.1494E+01_JPRB,1.4048E+01_JPRB/)
KBO( :, 4,19,14) = (/&
&1.9623E+01_JPRB,1.4803E+01_JPRB,1.1193E+01_JPRB,1.1515E+01_JPRB,1.3659E+01_JPRB/)
KBO( :, 5,19,14) = (/&
&2.4552E+01_JPRB,1.8498E+01_JPRB,1.3028E+01_JPRB,1.1768E+01_JPRB,1.3289E+01_JPRB/)
KBO( :, 1,20,14) = (/&
&8.8016E+00_JPRB,7.2179E+00_JPRB,9.4445E+00_JPRB,1.2859E+01_JPRB,1.6432E+01_JPRB/)
KBO( :, 2,20,14) = (/&
&1.2354E+01_JPRB,9.4599E+00_JPRB,1.0108E+01_JPRB,1.2760E+01_JPRB,1.5989E+01_JPRB/)
KBO( :, 3,20,14) = (/&
&1.6553E+01_JPRB,1.2501E+01_JPRB,1.1094E+01_JPRB,1.2659E+01_JPRB,1.5545E+01_JPRB/)
KBO( :, 4,20,14) = (/&
&2.1320E+01_JPRB,1.6075E+01_JPRB,1.2479E+01_JPRB,1.2712E+01_JPRB,1.5125E+01_JPRB/)
KBO( :, 5,20,14) = (/&
&2.6584E+01_JPRB,2.0023E+01_JPRB,1.4364E+01_JPRB,1.3028E+01_JPRB,1.4722E+01_JPRB/)
KBO( :, 1,21,14) = (/&
&9.6531E+00_JPRB,8.0964E+00_JPRB,1.0501E+01_JPRB,1.4235E+01_JPRB,1.8234E+01_JPRB/)
KBO( :, 2,21,14) = (/&
&1.3477E+01_JPRB,1.0427E+01_JPRB,1.1223E+01_JPRB,1.4069E+01_JPRB,1.7720E+01_JPRB/)
KBO( :, 3,21,14) = (/&
&1.7944E+01_JPRB,1.3555E+01_JPRB,1.2376E+01_JPRB,1.3942E+01_JPRB,1.7224E+01_JPRB/)
KBO( :, 4,21,14) = (/&
&2.3006E+01_JPRB,1.7340E+01_JPRB,1.3886E+01_JPRB,1.4053E+01_JPRB,1.6755E+01_JPRB/)
KBO( :, 5,21,14) = (/&
&2.8574E+01_JPRB,2.1516E+01_JPRB,1.5811E+01_JPRB,1.4416E+01_JPRB,1.6302E+01_JPRB/)
KBO( :, 1,22,14) = (/&
&1.0760E+01_JPRB,9.1888E+00_JPRB,1.1695E+01_JPRB,1.5745E+01_JPRB,2.0205E+01_JPRB/)
KBO( :, 2,22,14) = (/&
&1.4853E+01_JPRB,1.1640E+01_JPRB,1.2517E+01_JPRB,1.5515E+01_JPRB,1.9617E+01_JPRB/)
KBO( :, 3,22,14) = (/&
&1.9615E+01_JPRB,1.4884E+01_JPRB,1.3822E+01_JPRB,1.5397E+01_JPRB,1.9064E+01_JPRB/)
KBO( :, 4,22,14) = (/&
&2.4968E+01_JPRB,1.8810E+01_JPRB,1.5484E+01_JPRB,1.5561E+01_JPRB,1.8540E+01_JPRB/)
KBO( :, 5,22,14) = (/&
&3.0827E+01_JPRB,2.3206E+01_JPRB,1.7456E+01_JPRB,1.5921E+01_JPRB,1.8033E+01_JPRB/)
KBO( :, 1,23,14) = (/&
&1.1802E+01_JPRB,1.0322E+01_JPRB,1.2998E+01_JPRB,1.7421E+01_JPRB,2.2401E+01_JPRB/)
KBO( :, 2,23,14) = (/&
&1.6133E+01_JPRB,1.2850E+01_JPRB,1.3921E+01_JPRB,1.7123E+01_JPRB,2.1737E+01_JPRB/)
KBO( :, 3,23,14) = (/&
&2.1125E+01_JPRB,1.6165E+01_JPRB,1.5339E+01_JPRB,1.7031E+01_JPRB,2.1100E+01_JPRB/)
KBO( :, 4,23,14) = (/&
&2.6726E+01_JPRB,2.0157E+01_JPRB,1.7101E+01_JPRB,1.7209E+01_JPRB,2.0484E+01_JPRB/)
KBO( :, 5,23,14) = (/&
&3.2827E+01_JPRB,2.4712E+01_JPRB,1.9081E+01_JPRB,1.7519E+01_JPRB,1.9884E+01_JPRB/)
KBO( :, 1,24,14) = (/&
&1.2745E+01_JPRB,1.1442E+01_JPRB,1.4445E+01_JPRB,1.9244E+01_JPRB,2.4809E+01_JPRB/)
KBO( :, 2,24,14) = (/&
&1.7253E+01_JPRB,1.4016E+01_JPRB,1.5441E+01_JPRB,1.8901E+01_JPRB,2.4045E+01_JPRB/)
KBO( :, 3,24,14) = (/&
&2.2449E+01_JPRB,1.7365E+01_JPRB,1.6912E+01_JPRB,1.8816E+01_JPRB,2.3295E+01_JPRB/)
KBO( :, 4,24,14) = (/&
&2.8233E+01_JPRB,2.1395E+01_JPRB,1.8672E+01_JPRB,1.8934E+01_JPRB,2.2558E+01_JPRB/)
KBO( :, 5,24,14) = (/&
&3.4560E+01_JPRB,2.6021E+01_JPRB,2.0658E+01_JPRB,1.9202E+01_JPRB,2.1836E+01_JPRB/)
KBO( :, 1,25,14) = (/&
&1.3566E+01_JPRB,1.2543E+01_JPRB,1.5996E+01_JPRB,2.1177E+01_JPRB,2.7336E+01_JPRB/)
KBO( :, 2,25,14) = (/&
&1.8227E+01_JPRB,1.5135E+01_JPRB,1.7035E+01_JPRB,2.0783E+01_JPRB,2.6441E+01_JPRB/)
KBO( :, 3,25,14) = (/&
&2.3565E+01_JPRB,1.8483E+01_JPRB,1.8488E+01_JPRB,2.0675E+01_JPRB,2.5549E+01_JPRB/)
KBO( :, 4,25,14) = (/&
&2.9531E+01_JPRB,2.2535E+01_JPRB,2.0204E+01_JPRB,2.0688E+01_JPRB,2.4667E+01_JPRB/)
KBO( :, 5,25,14) = (/&
&3.6063E+01_JPRB,2.7206E+01_JPRB,2.2162E+01_JPRB,2.0908E+01_JPRB,2.3805E+01_JPRB/)
KBO( :, 1,26,14) = (/&
&1.4327E+01_JPRB,1.3631E+01_JPRB,1.7595E+01_JPRB,2.3118E+01_JPRB,2.9859E+01_JPRB/)
KBO( :, 2,26,14) = (/&
&1.9108E+01_JPRB,1.6210E+01_JPRB,1.8663E+01_JPRB,2.2706E+01_JPRB,2.8803E+01_JPRB/)
KBO( :, 3,26,14) = (/&
&2.4589E+01_JPRB,1.9567E+01_JPRB,2.0048E+01_JPRB,2.2494E+01_JPRB,2.7746E+01_JPRB/)
KBO( :, 4,26,14) = (/&
&3.0710E+01_JPRB,2.3631E+01_JPRB,2.1693E+01_JPRB,2.2407E+01_JPRB,2.6705E+01_JPRB/)
KBO( :, 5,26,14) = (/&
&3.7411E+01_JPRB,2.8326E+01_JPRB,2.3613E+01_JPRB,2.2582E+01_JPRB,2.5687E+01_JPRB/)
KBO( :, 1,27,14) = (/&
&1.4974E+01_JPRB,1.4661E+01_JPRB,1.9208E+01_JPRB,2.5017E+01_JPRB,3.2282E+01_JPRB/)
KBO( :, 2,27,14) = (/&
&1.9864E+01_JPRB,1.7209E+01_JPRB,2.0231E+01_JPRB,2.4566E+01_JPRB,3.1037E+01_JPRB/)
KBO( :, 3,27,14) = (/&
&2.5463E+01_JPRB,2.0563E+01_JPRB,2.1528E+01_JPRB,2.4213E+01_JPRB,2.9805E+01_JPRB/)
KBO( :, 4,27,14) = (/&
&3.1732E+01_JPRB,2.4635E+01_JPRB,2.3113E+01_JPRB,2.4054E+01_JPRB,2.8597E+01_JPRB/)
KBO( :, 5,27,14) = (/&
&3.8595E+01_JPRB,2.9368E+01_JPRB,2.4984E+01_JPRB,2.4188E+01_JPRB,2.7415E+01_JPRB/)
KBO( :, 1,28,14) = (/&
&1.5529E+01_JPRB,1.5623E+01_JPRB,2.0763E+01_JPRB,2.6821E+01_JPRB,3.4499E+01_JPRB/)
KBO( :, 2,28,14) = (/&
&2.0516E+01_JPRB,1.8143E+01_JPRB,2.1720E+01_JPRB,2.6283E+01_JPRB,3.3057E+01_JPRB/)
KBO( :, 3,28,14) = (/&
&2.6237E+01_JPRB,2.1495E+01_JPRB,2.2921E+01_JPRB,2.5811E+01_JPRB,3.1645E+01_JPRB/)
KBO( :, 4,28,14) = (/&
&3.2647E+01_JPRB,2.5586E+01_JPRB,2.4438E+01_JPRB,2.5592E+01_JPRB,3.0274E+01_JPRB/)
KBO( :, 5,28,14) = (/&
&3.9662E+01_JPRB,3.0339E+01_JPRB,2.6263E+01_JPRB,2.5678E+01_JPRB,2.8942E+01_JPRB/)
KBO( :, 1,29,14) = (/&
&1.6065E+01_JPRB,1.6544E+01_JPRB,2.2216E+01_JPRB,2.8472E+01_JPRB,3.6458E+01_JPRB/)
KBO( :, 2,29,14) = (/&
&2.1153E+01_JPRB,1.9041E+01_JPRB,2.3104E+01_JPRB,2.7817E+01_JPRB,3.4827E+01_JPRB/)
KBO( :, 3,29,14) = (/&
&2.7000E+01_JPRB,2.2394E+01_JPRB,2.4221E+01_JPRB,2.7267E+01_JPRB,3.3240E+01_JPRB/)
KBO( :, 4,29,14) = (/&
&3.3548E+01_JPRB,2.6519E+01_JPRB,2.5679E+01_JPRB,2.7001E+01_JPRB,3.1702E+01_JPRB/)
KBO( :, 5,29,14) = (/&
&4.0738E+01_JPRB,3.1323E+01_JPRB,2.7457E+01_JPRB,2.7031E+01_JPRB,3.0226E+01_JPRB/)
KBO( :, 1,30,14) = (/&
&1.6583E+01_JPRB,1.7406E+01_JPRB,2.3544E+01_JPRB,2.9947E+01_JPRB,3.8146E+01_JPRB/)
KBO( :, 2,30,14) = (/&
&2.1792E+01_JPRB,1.9899E+01_JPRB,2.4353E+01_JPRB,2.9156E+01_JPRB,3.6330E+01_JPRB/)
KBO( :, 3,30,14) = (/&
&2.7775E+01_JPRB,2.3269E+01_JPRB,2.5405E+01_JPRB,2.8560E+01_JPRB,3.4577E+01_JPRB/)
KBO( :, 4,30,14) = (/&
&3.4468E+01_JPRB,2.7442E+01_JPRB,2.6816E+01_JPRB,2.8255E+01_JPRB,3.2901E+01_JPRB/)
KBO( :, 5,30,14) = (/&
&4.1847E+01_JPRB,3.2326E+01_JPRB,2.8565E+01_JPRB,2.8235E+01_JPRB,3.1294E+01_JPRB/)
KBO( :, 1,31,14) = (/&
&1.7141E+01_JPRB,1.8216E+01_JPRB,2.4732E+01_JPRB,3.1198E+01_JPRB,3.9531E+01_JPRB/)
KBO( :, 2,31,14) = (/&
&2.2491E+01_JPRB,2.0743E+01_JPRB,2.5474E+01_JPRB,3.0318E+01_JPRB,3.7553E+01_JPRB/)
KBO( :, 3,31,14) = (/&
&2.8624E+01_JPRB,2.4158E+01_JPRB,2.6485E+01_JPRB,2.9690E+01_JPRB,3.5656E+01_JPRB/)
KBO( :, 4,31,14) = (/&
&3.5512E+01_JPRB,2.8414E+01_JPRB,2.7854E+01_JPRB,2.9357E+01_JPRB,3.3855E+01_JPRB/)
KBO( :, 5,31,14) = (/&
&4.3115E+01_JPRB,3.3401E+01_JPRB,2.9611E+01_JPRB,2.9290E+01_JPRB,3.2132E+01_JPRB/)
KBO( :, 1,32,14) = (/&
&1.7775E+01_JPRB,1.8991E+01_JPRB,2.5780E+01_JPRB,3.2231E+01_JPRB,4.0629E+01_JPRB/)
KBO( :, 2,32,14) = (/&
&2.3279E+01_JPRB,2.1576E+01_JPRB,2.6467E+01_JPRB,3.1293E+01_JPRB,3.8513E+01_JPRB/)
KBO( :, 3,32,14) = (/&
&2.9596E+01_JPRB,2.5078E+01_JPRB,2.7453E+01_JPRB,3.0651E+01_JPRB,3.6492E+01_JPRB/)
KBO( :, 4,32,14) = (/&
&3.6705E+01_JPRB,2.9433E+01_JPRB,2.8819E+01_JPRB,3.0298E+01_JPRB,3.4575E+01_JPRB/)
KBO( :, 5,32,14) = (/&
&4.4536E+01_JPRB,3.4534E+01_JPRB,3.0584E+01_JPRB,3.0174E+01_JPRB,3.2756E+01_JPRB/)
KBO( :, 1,33,14) = (/&
&1.8489E+01_JPRB,1.9733E+01_JPRB,2.6684E+01_JPRB,3.3047E+01_JPRB,4.1445E+01_JPRB/)
KBO( :, 2,33,14) = (/&
&2.4189E+01_JPRB,2.2424E+01_JPRB,2.7346E+01_JPRB,3.2099E+01_JPRB,3.9209E+01_JPRB/)
KBO( :, 3,33,14) = (/&
&3.0723E+01_JPRB,2.6034E+01_JPRB,2.8320E+01_JPRB,3.1451E+01_JPRB,3.7092E+01_JPRB/)
KBO( :, 4,33,14) = (/&
&3.8063E+01_JPRB,3.0513E+01_JPRB,2.9704E+01_JPRB,3.1070E+01_JPRB,3.5085E+01_JPRB/)
KBO( :, 5,33,14) = (/&
&4.6119E+01_JPRB,3.5751E+01_JPRB,3.1499E+01_JPRB,3.0917E+01_JPRB,3.3191E+01_JPRB/)
KBO( :, 1,34,14) = (/&
&1.9120E+01_JPRB,2.0380E+01_JPRB,2.7451E+01_JPRB,3.3738E+01_JPRB,4.2092E+01_JPRB/)
KBO( :, 2,34,14) = (/&
&2.5003E+01_JPRB,2.3162E+01_JPRB,2.8086E+01_JPRB,3.2774E+01_JPRB,3.9759E+01_JPRB/)
KBO( :, 3,34,14) = (/&
&3.1744E+01_JPRB,2.6883E+01_JPRB,2.9061E+01_JPRB,3.2120E+01_JPRB,3.7559E+01_JPRB/)
KBO( :, 4,34,14) = (/&
&3.9301E+01_JPRB,3.1483E+01_JPRB,3.0464E+01_JPRB,3.1710E+01_JPRB,3.5480E+01_JPRB/)
KBO( :, 5,34,14) = (/&
&4.7562E+01_JPRB,3.6856E+01_JPRB,3.2292E+01_JPRB,3.1536E+01_JPRB,3.3568E+01_JPRB/)
KBO( :, 1,35,14) = (/&
&1.9330E+01_JPRB,2.0794E+01_JPRB,2.8053E+01_JPRB,3.4390E+01_JPRB,4.2763E+01_JPRB/)
KBO( :, 2,35,14) = (/&
&2.5319E+01_JPRB,2.3595E+01_JPRB,2.8656E+01_JPRB,3.3397E+01_JPRB,4.0342E+01_JPRB/)
KBO( :, 3,35,14) = (/&
&3.2191E+01_JPRB,2.7358E+01_JPRB,2.9608E+01_JPRB,3.2717E+01_JPRB,3.8062E+01_JPRB/)
KBO( :, 4,35,14) = (/&
&3.9886E+01_JPRB,3.2011E+01_JPRB,3.1003E+01_JPRB,3.2263E+01_JPRB,3.5938E+01_JPRB/)
KBO( :, 5,35,14) = (/&
&4.8294E+01_JPRB,3.7467E+01_JPRB,3.2840E+01_JPRB,3.2051E+01_JPRB,3.4008E+01_JPRB/)
KBO( :, 1,36,14) = (/&
&1.9010E+01_JPRB,2.0941E+01_JPRB,2.8519E+01_JPRB,3.5044E+01_JPRB,4.3548E+01_JPRB/)
KBO( :, 2,36,14) = (/&
&2.5019E+01_JPRB,2.3674E+01_JPRB,2.9070E+01_JPRB,3.3996E+01_JPRB,4.1038E+01_JPRB/)
KBO( :, 3,36,14) = (/&
&3.1927E+01_JPRB,2.7395E+01_JPRB,2.9968E+01_JPRB,3.3265E+01_JPRB,3.8679E+01_JPRB/)
KBO( :, 4,36,14) = (/&
&3.9672E+01_JPRB,3.2015E+01_JPRB,3.1322E+01_JPRB,3.2758E+01_JPRB,3.6525E+01_JPRB/)
KBO( :, 5,36,14) = (/&
&4.8151E+01_JPRB,3.7481E+01_JPRB,3.3115E+01_JPRB,3.2494E+01_JPRB,3.4530E+01_JPRB/)
KBO( :, 1,37,14) = (/&
&1.7926E+01_JPRB,2.0769E+01_JPRB,2.8871E+01_JPRB,3.5793E+01_JPRB,4.4612E+01_JPRB/)
KBO( :, 2,37,14) = (/&
&2.3809E+01_JPRB,2.3285E+01_JPRB,2.9325E+01_JPRB,3.4640E+01_JPRB,4.1997E+01_JPRB/)
KBO( :, 3,37,14) = (/&
&3.0620E+01_JPRB,2.6825E+01_JPRB,3.0118E+01_JPRB,3.3823E+01_JPRB,3.9558E+01_JPRB/)
KBO( :, 4,37,14) = (/&
&3.8296E+01_JPRB,3.1288E+01_JPRB,3.1366E+01_JPRB,3.3235E+01_JPRB,3.7337E+01_JPRB/)
KBO( :, 5,37,14) = (/&
&4.6724E+01_JPRB,3.6634E+01_JPRB,3.3044E+01_JPRB,3.2894E+01_JPRB,3.5259E+01_JPRB/)
KBO( :, 1,38,14) = (/&
&1.6878E+01_JPRB,2.0610E+01_JPRB,2.9172E+01_JPRB,3.6472E+01_JPRB,4.5609E+01_JPRB/)
KBO( :, 2,38,14) = (/&
&2.2623E+01_JPRB,2.2907E+01_JPRB,2.9536E+01_JPRB,3.5227E+01_JPRB,4.2904E+01_JPRB/)
KBO( :, 3,38,14) = (/&
&2.9321E+01_JPRB,2.6260E+01_JPRB,3.0234E+01_JPRB,3.4327E+01_JPRB,4.0395E+01_JPRB/)
KBO( :, 4,38,14) = (/&
&3.6903E+01_JPRB,3.0559E+01_JPRB,3.1375E+01_JPRB,3.3664E+01_JPRB,3.8108E+01_JPRB/)
KBO( :, 5,38,14) = (/&
&4.5262E+01_JPRB,3.5766E+01_JPRB,3.2950E+01_JPRB,3.3255E+01_JPRB,3.5951E+01_JPRB/)
KBO( :, 1,39,14) = (/&
&1.5902E+01_JPRB,2.0474E+01_JPRB,2.9440E+01_JPRB,3.7085E+01_JPRB,4.6521E+01_JPRB/)
KBO( :, 2,39,14) = (/&
&2.1511E+01_JPRB,2.2570E+01_JPRB,2.9719E+01_JPRB,3.5757E+01_JPRB,4.3739E+01_JPRB/)
KBO( :, 3,39,14) = (/&
&2.8094E+01_JPRB,2.5734E+01_JPRB,3.0328E+01_JPRB,3.4778E+01_JPRB,4.1182E+01_JPRB/)
KBO( :, 4,39,14) = (/&
&3.5578E+01_JPRB,2.9877E+01_JPRB,3.1374E+01_JPRB,3.4050E+01_JPRB,3.8820E+01_JPRB/)
KBO( :, 5,39,14) = (/&
&4.3862E+01_JPRB,3.4943E+01_JPRB,3.2862E+01_JPRB,3.3572E+01_JPRB,3.6607E+01_JPRB/)
KBO( :, 1,40,14) = (/&
&1.4487E+01_JPRB,2.0210E+01_JPRB,2.9678E+01_JPRB,3.7814E+01_JPRB,4.7667E+01_JPRB/)
KBO( :, 2,40,14) = (/&
&1.9857E+01_JPRB,2.2013E+01_JPRB,2.9846E+01_JPRB,3.6374E+01_JPRB,4.4798E+01_JPRB/)
KBO( :, 3,40,14) = (/&
&2.6217E+01_JPRB,2.4887E+01_JPRB,3.0342E+01_JPRB,3.5275E+01_JPRB,4.2152E+01_JPRB/)
KBO( :, 4,40,14) = (/&
&3.3508E+01_JPRB,2.8778E+01_JPRB,3.1239E+01_JPRB,3.4477E+01_JPRB,3.9718E+01_JPRB/)
KBO( :, 5,40,14) = (/&
&4.1627E+01_JPRB,3.3601E+01_JPRB,3.2609E+01_JPRB,3.3904E+01_JPRB,3.7435E+01_JPRB/)
KBO( :, 1,41,14) = (/&
&1.3110E+01_JPRB,1.9958E+01_JPRB,2.9912E+01_JPRB,3.8549E+01_JPRB,4.8809E+01_JPRB/)
KBO( :, 2,41,14) = (/&
&1.8221E+01_JPRB,2.1507E+01_JPRB,2.9962E+01_JPRB,3.6988E+01_JPRB,4.5856E+01_JPRB/)
KBO( :, 3,41,14) = (/&
&2.4334E+01_JPRB,2.4070E+01_JPRB,3.0356E+01_JPRB,3.5769E+01_JPRB,4.3126E+01_JPRB/)
KBO( :, 4,41,14) = (/&
&3.1415E+01_JPRB,2.7692E+01_JPRB,3.1100E+01_JPRB,3.4894E+01_JPRB,4.0627E+01_JPRB/)
KBO( :, 5,41,14) = (/&
&3.9350E+01_JPRB,3.2265E+01_JPRB,3.2344E+01_JPRB,3.4220E+01_JPRB,3.8269E+01_JPRB/)
KBO( :, 1,42,14) = (/&
&1.1835E+01_JPRB,1.9752E+01_JPRB,3.0145E+01_JPRB,3.9251E+01_JPRB,4.9910E+01_JPRB/)
KBO( :, 2,42,14) = (/&
&1.6674E+01_JPRB,2.1083E+01_JPRB,3.0080E+01_JPRB,3.7587E+01_JPRB,4.6885E+01_JPRB/)
KBO( :, 3,42,14) = (/&
&2.2540E+01_JPRB,2.3336E+01_JPRB,3.0367E+01_JPRB,3.6256E+01_JPRB,4.4084E+01_JPRB/)
KBO( :, 4,42,14) = (/&
&2.9380E+01_JPRB,2.6668E+01_JPRB,3.0980E+01_JPRB,3.5287E+01_JPRB,4.1523E+01_JPRB/)
KBO( :, 5,42,14) = (/&
&3.7130E+01_JPRB,3.0990E+01_JPRB,3.2078E+01_JPRB,3.4533E+01_JPRB,3.9096E+01_JPRB/)
KBO( :, 1,43,14) = (/&
&1.0424E+01_JPRB,1.9517E+01_JPRB,3.0390E+01_JPRB,4.0028E+01_JPRB,5.1165E+01_JPRB/)
KBO( :, 2,43,14) = (/&
&1.4940E+01_JPRB,2.0651E+01_JPRB,3.0207E+01_JPRB,3.8268E+01_JPRB,4.8059E+01_JPRB/)
KBO( :, 3,43,14) = (/&
&2.0485E+01_JPRB,2.2541E+01_JPRB,3.0363E+01_JPRB,3.6818E+01_JPRB,4.5176E+01_JPRB/)
KBO( :, 4,43,14) = (/&
&2.7034E+01_JPRB,2.5521E+01_JPRB,3.0853E+01_JPRB,3.5715E+01_JPRB,4.2549E+01_JPRB/)
KBO( :, 5,43,14) = (/&
&3.4521E+01_JPRB,2.9529E+01_JPRB,3.1770E+01_JPRB,3.4894E+01_JPRB,4.0051E+01_JPRB/)
KBO( :, 1,44,14) = (/&
&9.0454E+00_JPRB,1.9303E+01_JPRB,3.0654E+01_JPRB,4.0829E+01_JPRB,5.2486E+01_JPRB/)
KBO( :, 2,44,14) = (/&
&1.3210E+01_JPRB,2.0258E+01_JPRB,3.0364E+01_JPRB,3.9018E+01_JPRB,4.9303E+01_JPRB/)
KBO( :, 3,44,14) = (/&
&1.8410E+01_JPRB,2.1811E+01_JPRB,3.0377E+01_JPRB,3.7427E+01_JPRB,4.6338E+01_JPRB/)
KBO( :, 4,44,14) = (/&
&2.4625E+01_JPRB,2.4403E+01_JPRB,3.0751E+01_JPRB,3.6187E+01_JPRB,4.3644E+01_JPRB/)
KBO( :, 5,44,14) = (/&
&3.1810E+01_JPRB,2.8069E+01_JPRB,3.1486E+01_JPRB,3.5287E+01_JPRB,4.1079E+01_JPRB/)
KBO( :, 1,45,14) = (/&
&7.7991E+00_JPRB,1.9124E+01_JPRB,3.0912E+01_JPRB,4.1626E+01_JPRB,5.3793E+01_JPRB/)
KBO( :, 2,45,14) = (/&
&1.1620E+01_JPRB,1.9930E+01_JPRB,3.0535E+01_JPRB,3.9772E+01_JPRB,5.0542E+01_JPRB/)
KBO( :, 3,45,14) = (/&
&1.6462E+01_JPRB,2.1220E+01_JPRB,3.0424E+01_JPRB,3.8053E+01_JPRB,4.7507E+01_JPRB/)
KBO( :, 4,45,14) = (/&
&2.2340E+01_JPRB,2.3424E+01_JPRB,3.0669E+01_JPRB,3.6679E+01_JPRB,4.4753E+01_JPRB/)
KBO( :, 5,45,14) = (/&
&2.9206E+01_JPRB,2.6717E+01_JPRB,3.1243E+01_JPRB,3.5671E+01_JPRB,4.2118E+01_JPRB/)
KBO( :, 1,46,14) = (/&
&6.6114E+00_JPRB,1.8975E+01_JPRB,3.1192E+01_JPRB,4.2505E+01_JPRB,5.5177E+01_JPRB/)
KBO( :, 2,46,14) = (/&
&1.0078E+01_JPRB,1.9636E+01_JPRB,3.0742E+01_JPRB,4.0557E+01_JPRB,5.1854E+01_JPRB/)
KBO( :, 3,46,14) = (/&
&1.4541E+01_JPRB,2.0717E+01_JPRB,3.0510E+01_JPRB,3.8745E+01_JPRB,4.8748E+01_JPRB/)
KBO( :, 4,46,14) = (/&
&2.0050E+01_JPRB,2.2518E+01_JPRB,3.0610E+01_JPRB,3.7236E+01_JPRB,4.5932E+01_JPRB/)
KBO( :, 5,46,14) = (/&
&2.6570E+01_JPRB,2.5413E+01_JPRB,3.1056E+01_JPRB,3.6085E+01_JPRB,4.3222E+01_JPRB/)
KBO( :, 1,47,14) = (/&
&5.4426E+00_JPRB,1.8843E+01_JPRB,3.1468E+01_JPRB,4.3504E+01_JPRB,5.6708E+01_JPRB/)
KBO( :, 2,47,14) = (/&
&8.5243E+00_JPRB,1.9360E+01_JPRB,3.0989E+01_JPRB,4.1408E+01_JPRB,5.3314E+01_JPRB/)
KBO( :, 3,47,14) = (/&
&1.2575E+01_JPRB,2.0245E+01_JPRB,3.0638E+01_JPRB,3.9555E+01_JPRB,5.0119E+01_JPRB/)
KBO( :, 4,47,14) = (/&
&1.7661E+01_JPRB,2.1683E+01_JPRB,3.0580E+01_JPRB,3.7894E+01_JPRB,4.7238E+01_JPRB/)
KBO( :, 5,47,14) = (/&
&2.3779E+01_JPRB,2.4127E+01_JPRB,3.0897E+01_JPRB,3.6585E+01_JPRB,4.4450E+01_JPRB/)
KBO( :, 1,48,14) = (/&
&4.4277E+00_JPRB,1.8761E+01_JPRB,3.1768E+01_JPRB,4.4555E+01_JPRB,5.8239E+01_JPRB/)
KBO( :, 2,48,14) = (/&
&7.1412E+00_JPRB,1.9151E+01_JPRB,3.1244E+01_JPRB,4.2299E+01_JPRB,5.4783E+01_JPRB/)
KBO( :, 3,48,14) = (/&
&1.0789E+01_JPRB,1.9869E+01_JPRB,3.0807E+01_JPRB,4.0379E+01_JPRB,5.1522E+01_JPRB/)
KBO( :, 4,48,14) = (/&
&1.5451E+01_JPRB,2.1038E+01_JPRB,3.0616E+01_JPRB,3.8583E+01_JPRB,4.8572E+01_JPRB/)
KBO( :, 5,48,14) = (/&
&2.1160E+01_JPRB,2.3022E+01_JPRB,3.0768E+01_JPRB,3.7126E+01_JPRB,4.5703E+01_JPRB/)
KBO( :, 1,49,14) = (/&
&3.5582E+00_JPRB,1.8724E+01_JPRB,3.2110E+01_JPRB,4.5630E+01_JPRB,5.9777E+01_JPRB/)
KBO( :, 2,49,14) = (/&
&5.9176E+00_JPRB,1.8981E+01_JPRB,3.1512E+01_JPRB,4.3246E+01_JPRB,5.6279E+01_JPRB/)
KBO( :, 3,49,14) = (/&
&9.1765E+00_JPRB,1.9555E+01_JPRB,3.1023E+01_JPRB,4.1205E+01_JPRB,5.2968E+01_JPRB/)
KBO( :, 4,49,14) = (/&
&1.3419E+01_JPRB,2.0517E+01_JPRB,3.0706E+01_JPRB,3.9341E+01_JPRB,4.9951E+01_JPRB/)
KBO( :, 5,49,14) = (/&
&1.8709E+01_JPRB,2.2099E+01_JPRB,3.0706E+01_JPRB,3.7732E+01_JPRB,4.7001E+01_JPRB/)
KBO( :, 1,50,14) = (/&
&2.8621E+00_JPRB,1.8722E+01_JPRB,3.2476E+01_JPRB,4.6653E+01_JPRB,6.1210E+01_JPRB/)
KBO( :, 2,50,14) = (/&
&4.9088E+00_JPRB,1.8875E+01_JPRB,3.1754E+01_JPRB,4.4175E+01_JPRB,5.7683E+01_JPRB/)
KBO( :, 3,50,14) = (/&
&7.8135E+00_JPRB,1.9320E+01_JPRB,3.1237E+01_JPRB,4.1987E+01_JPRB,5.4314E+01_JPRB/)
KBO( :, 4,50,14) = (/&
&1.1676E+01_JPRB,2.0117E+01_JPRB,3.0830E+01_JPRB,4.0088E+01_JPRB,5.1232E+01_JPRB/)
KBO( :, 5,50,14) = (/&
&1.6567E+01_JPRB,2.1410E+01_JPRB,3.0696E+01_JPRB,3.8343E+01_JPRB,4.8212E+01_JPRB/)
KBO( :, 1,51,14) = (/&
&2.2871E+00_JPRB,1.8709E+01_JPRB,3.2860E+01_JPRB,4.7625E+01_JPRB,6.2589E+01_JPRB/)
KBO( :, 2,51,14) = (/&
&4.0542E+00_JPRB,1.8811E+01_JPRB,3.2015E+01_JPRB,4.5121E+01_JPRB,5.9058E+01_JPRB/)
KBO( :, 3,51,14) = (/&
&6.6290E+00_JPRB,1.9146E+01_JPRB,3.1467E+01_JPRB,4.2798E+01_JPRB,5.5634E+01_JPRB/)
KBO( :, 4,51,14) = (/&
&1.0131E+01_JPRB,1.9796E+01_JPRB,3.0988E+01_JPRB,4.0823E+01_JPRB,5.2469E+01_JPRB/)
KBO( :, 5,51,14) = (/&
&1.4636E+01_JPRB,2.0878E+01_JPRB,3.0739E+01_JPRB,3.8979E+01_JPRB,4.9405E+01_JPRB/)
KBO( :, 1,52,14) = (/&
&1.8042E+00_JPRB,1.8682E+01_JPRB,3.3246E+01_JPRB,4.8560E+01_JPRB,6.3938E+01_JPRB/)
KBO( :, 2,52,14) = (/&
&3.3141E+00_JPRB,1.8789E+01_JPRB,3.2326E+01_JPRB,4.6081E+01_JPRB,6.0432E+01_JPRB/)
KBO( :, 3,52,14) = (/&
&5.5749E+00_JPRB,1.9001E+01_JPRB,3.1682E+01_JPRB,4.3646E+01_JPRB,5.6974E+01_JPRB/)
KBO( :, 4,52,14) = (/&
&8.7257E+00_JPRB,1.9525E+01_JPRB,3.1181E+01_JPRB,4.1550E+01_JPRB,5.3732E+01_JPRB/)
KBO( :, 5,52,14) = (/&
&1.2856E+01_JPRB,2.0429E+01_JPRB,3.0821E+01_JPRB,3.9666E+01_JPRB,5.0627E+01_JPRB/)
KBO( :, 1,53,14) = (/&
&1.4016E+00_JPRB,1.8621E+01_JPRB,3.3678E+01_JPRB,4.9490E+01_JPRB,6.5279E+01_JPRB/)
KBO( :, 2,53,14) = (/&
&2.6762E+00_JPRB,1.8776E+01_JPRB,3.2671E+01_JPRB,4.7047E+01_JPRB,6.1804E+01_JPRB/)
KBO( :, 3,53,14) = (/&
&4.6412E+00_JPRB,1.8903E+01_JPRB,3.1912E+01_JPRB,4.4545E+01_JPRB,5.8349E+01_JPRB/)
KBO( :, 4,53,14) = (/&
&7.4512E+00_JPRB,1.9311E+01_JPRB,3.1378E+01_JPRB,4.2307E+01_JPRB,5.5036E+01_JPRB/)
KBO( :, 5,53,14) = (/&
&1.1217E+01_JPRB,2.0061E+01_JPRB,3.0940E+01_JPRB,4.0380E+01_JPRB,5.1884E+01_JPRB/)
KBO( :, 1,54,14) = (/&
&1.0961E+00_JPRB,1.8547E+01_JPRB,3.4112E+01_JPRB,5.0332E+01_JPRB,6.6490E+01_JPRB/)
KBO( :, 2,54,14) = (/&
&2.1755E+00_JPRB,1.8757E+01_JPRB,3.3015E+01_JPRB,4.7918E+01_JPRB,6.3018E+01_JPRB/)
KBO( :, 3,54,14) = (/&
&3.8890E+00_JPRB,1.8845E+01_JPRB,3.2149E+01_JPRB,4.5398E+01_JPRB,5.9550E+01_JPRB/)
KBO( :, 4,54,14) = (/&
&6.4008E+00_JPRB,1.9153E+01_JPRB,3.1582E+01_JPRB,4.3046E+01_JPRB,5.6158E+01_JPRB/)
KBO( :, 5,54,14) = (/&
&9.8389E+00_JPRB,1.9773E+01_JPRB,3.1086E+01_JPRB,4.1043E+01_JPRB,5.2991E+01_JPRB/)
KBO( :, 1,55,14) = (/&
&8.5398E-01_JPRB,1.8492E+01_JPRB,3.4545E+01_JPRB,5.1111E+01_JPRB,6.7620E+01_JPRB/)
KBO( :, 2,55,14) = (/&
&1.7643E+00_JPRB,1.8724E+01_JPRB,3.3346E+01_JPRB,4.8723E+01_JPRB,6.4160E+01_JPRB/)
KBO( :, 3,55,14) = (/&
&3.2551E+00_JPRB,1.8827E+01_JPRB,3.2415E+01_JPRB,4.6233E+01_JPRB,6.0665E+01_JPRB/)
KBO( :, 4,55,14) = (/&
&5.4933E+00_JPRB,1.9028E+01_JPRB,3.1761E+01_JPRB,4.3784E+01_JPRB,5.7216E+01_JPRB/)
KBO( :, 5,55,14) = (/&
&8.6198E+00_JPRB,1.9538E+01_JPRB,3.1251E+01_JPRB,4.1673E+01_JPRB,5.3976E+01_JPRB/)
KBO( :, 1,56,14) = (/&
&6.5583E-01_JPRB,1.8466E+01_JPRB,3.5009E+01_JPRB,5.1852E+01_JPRB,6.8713E+01_JPRB/)
KBO( :, 2,56,14) = (/&
&1.4149E+00_JPRB,1.8664E+01_JPRB,3.3714E+01_JPRB,4.9524E+01_JPRB,6.5316E+01_JPRB/)
KBO( :, 3,56,14) = (/&
&2.7001E+00_JPRB,1.8813E+01_JPRB,3.2708E+01_JPRB,4.7069E+01_JPRB,6.1791E+01_JPRB/)
KBO( :, 4,56,14) = (/&
&4.6799E+00_JPRB,1.8938E+01_JPRB,3.1954E+01_JPRB,4.4562E+01_JPRB,5.8292E+01_JPRB/)
KBO( :, 5,56,14) = (/&
&7.5092E+00_JPRB,1.9349E+01_JPRB,3.1417E+01_JPRB,4.2326E+01_JPRB,5.4949E+01_JPRB/)
KBO( :, 1,57,14) = (/&
&4.9569E-01_JPRB,1.8461E+01_JPRB,3.5476E+01_JPRB,5.2586E+01_JPRB,6.9771E+01_JPRB/)
KBO( :, 2,57,14) = (/&
&1.1207E+00_JPRB,1.8588E+01_JPRB,3.4120E+01_JPRB,5.0320E+01_JPRB,6.6462E+01_JPRB/)
KBO( :, 3,57,14) = (/&
&2.2185E+00_JPRB,1.8789E+01_JPRB,3.3026E+01_JPRB,4.7890E+01_JPRB,6.2944E+01_JPRB/)
KBO( :, 4,57,14) = (/&
&3.9561E+00_JPRB,1.8878E+01_JPRB,3.2169E+01_JPRB,4.5368E+01_JPRB,5.9404E+01_JPRB/)
KBO( :, 5,57,14) = (/&
&6.5001E+00_JPRB,1.9194E+01_JPRB,3.1605E+01_JPRB,4.3020E+01_JPRB,5.5955E+01_JPRB/)
KBO( :, 1,58,14) = (/&
&3.7410E-01_JPRB,1.8476E+01_JPRB,3.5878E+01_JPRB,5.3233E+01_JPRB,7.0727E+01_JPRB/)
KBO( :, 2,58,14) = (/&
&8.8722E-01_JPRB,1.8527E+01_JPRB,3.4515E+01_JPRB,5.1048E+01_JPRB,6.7516E+01_JPRB/)
KBO( :, 3,58,14) = (/&
&1.8232E+00_JPRB,1.8757E+01_JPRB,3.3332E+01_JPRB,4.8650E+01_JPRB,6.4043E+01_JPRB/)
KBO( :, 4,58,14) = (/&
&3.3485E+00_JPRB,1.8853E+01_JPRB,3.2410E+01_JPRB,4.6145E+01_JPRB,6.0474E+01_JPRB/)
KBO( :, 5,58,14) = (/&
&5.6308E+00_JPRB,1.9066E+01_JPRB,3.1770E+01_JPRB,4.3707E+01_JPRB,5.6952E+01_JPRB/)
KBO( :, 1,59,14) = (/&
&3.3226E-01_JPRB,1.8499E+01_JPRB,3.6042E+01_JPRB,5.3487E+01_JPRB,7.1108E+01_JPRB/)
KBO( :, 2,59,14) = (/&
&8.0465E-01_JPRB,1.8512E+01_JPRB,3.4692E+01_JPRB,5.1340E+01_JPRB,6.7946E+01_JPRB/)
KBO( :, 3,59,14) = (/&
&1.6796E+00_JPRB,1.8742E+01_JPRB,3.3465E+01_JPRB,4.8954E+01_JPRB,6.4485E+01_JPRB/)
KBO( :, 4,59,14) = (/&
&3.1244E+00_JPRB,1.8851E+01_JPRB,3.2518E+01_JPRB,4.6468E+01_JPRB,6.0924E+01_JPRB/)
KBO( :, 5,59,14) = (/&
&5.3047E+00_JPRB,1.9029E+01_JPRB,3.1839E+01_JPRB,4.3997E+01_JPRB,5.7335E+01_JPRB/)
KBO( :, 1,13,15) = (/&
&1.4736E+01_JPRB,1.1137E+01_JPRB,7.6940E+00_JPRB,7.1072E+00_JPRB,9.0794E+00_JPRB/)
KBO( :, 2,13,15) = (/&
&2.0753E+01_JPRB,1.5659E+01_JPRB,1.0572E+01_JPRB,7.4219E+00_JPRB,8.9416E+00_JPRB/)
KBO( :, 3,13,15) = (/&
&2.7810E+01_JPRB,2.0956E+01_JPRB,1.4105E+01_JPRB,8.2365E+00_JPRB,8.8640E+00_JPRB/)
KBO( :, 4,13,15) = (/&
&3.5751E+01_JPRB,2.6911E+01_JPRB,1.8075E+01_JPRB,9.6167E+00_JPRB,8.7852E+00_JPRB/)
KBO( :, 5,13,15) = (/&
&4.4392E+01_JPRB,3.3391E+01_JPRB,2.2391E+01_JPRB,1.1515E+01_JPRB,8.6750E+00_JPRB/)
KBO( :, 1,14,15) = (/&
&1.6396E+01_JPRB,1.2398E+01_JPRB,8.6531E+00_JPRB,8.0901E+00_JPRB,1.0338E+01_JPRB/)
KBO( :, 2,14,15) = (/&
&2.3021E+01_JPRB,1.7368E+01_JPRB,1.1723E+01_JPRB,8.4557E+00_JPRB,1.0225E+01_JPRB/)
KBO( :, 3,14,15) = (/&
&3.0725E+01_JPRB,2.3145E+01_JPRB,1.5568E+01_JPRB,9.3794E+00_JPRB,1.0164E+01_JPRB/)
KBO( :, 4,14,15) = (/&
&3.9405E+01_JPRB,2.9646E+01_JPRB,1.9890E+01_JPRB,1.0857E+01_JPRB,1.0076E+01_JPRB/)
KBO( :, 5,14,15) = (/&
&4.8887E+01_JPRB,3.6753E+01_JPRB,2.4621E+01_JPRB,1.2810E+01_JPRB,9.9619E+00_JPRB/)
KBO( :, 1,15,15) = (/&
&1.8108E+01_JPRB,1.3685E+01_JPRB,9.7296E+00_JPRB,9.2864E+00_JPRB,1.1891E+01_JPRB/)
KBO( :, 2,15,15) = (/&
&2.5292E+01_JPRB,1.9065E+01_JPRB,1.2925E+01_JPRB,9.7320E+00_JPRB,1.1822E+01_JPRB/)
KBO( :, 3,15,15) = (/&
&3.3657E+01_JPRB,2.5333E+01_JPRB,1.7012E+01_JPRB,1.0681E+01_JPRB,1.1765E+01_JPRB/)
KBO( :, 4,15,15) = (/&
&4.3009E+01_JPRB,3.2342E+01_JPRB,2.1677E+01_JPRB,1.2195E+01_JPRB,1.1648E+01_JPRB/)
KBO( :, 5,15,15) = (/&
&5.3119E+01_JPRB,3.9920E+01_JPRB,2.6722E+01_JPRB,1.4174E+01_JPRB,1.1512E+01_JPRB/)
KBO( :, 1,16,15) = (/&
&1.9766E+01_JPRB,1.4918E+01_JPRB,1.0847E+01_JPRB,1.0763E+01_JPRB,1.3814E+01_JPRB/)
KBO( :, 2,16,15) = (/&
&2.7468E+01_JPRB,2.0688E+01_JPRB,1.4114E+01_JPRB,1.1259E+01_JPRB,1.3757E+01_JPRB/)
KBO( :, 3,16,15) = (/&
&3.6341E+01_JPRB,2.7338E+01_JPRB,1.8370E+01_JPRB,1.2200E+01_JPRB,1.3647E+01_JPRB/)
KBO( :, 4,16,15) = (/&
&4.6268E+01_JPRB,3.4775E+01_JPRB,2.3285E+01_JPRB,1.3712E+01_JPRB,1.3493E+01_JPRB/)
KBO( :, 5,16,15) = (/&
&5.7098E+01_JPRB,4.2893E+01_JPRB,2.8688E+01_JPRB,1.5674E+01_JPRB,1.3336E+01_JPRB/)
KBO( :, 1,17,15) = (/&
&2.1283E+01_JPRB,1.6042E+01_JPRB,1.2037E+01_JPRB,1.2521E+01_JPRB,1.6103E+01_JPRB/)
KBO( :, 2,17,15) = (/&
&2.9464E+01_JPRB,2.2172E+01_JPRB,1.5299E+01_JPRB,1.3029E+01_JPRB,1.5994E+01_JPRB/)
KBO( :, 3,17,15) = (/&
&3.8948E+01_JPRB,2.9275E+01_JPRB,1.9669E+01_JPRB,1.3963E+01_JPRB,1.5820E+01_JPRB/)
KBO( :, 4,17,15) = (/&
&4.9621E+01_JPRB,3.7275E+01_JPRB,2.4936E+01_JPRB,1.5438E+01_JPRB,1.5638E+01_JPRB/)
KBO( :, 5,17,15) = (/&
&6.1258E+01_JPRB,4.5999E+01_JPRB,3.0742E+01_JPRB,1.7360E+01_JPRB,1.5449E+01_JPRB/)
KBO( :, 1,18,15) = (/&
&2.2877E+01_JPRB,1.7231E+01_JPRB,1.3375E+01_JPRB,1.4554E+01_JPRB,1.8639E+01_JPRB/)
KBO( :, 2,18,15) = (/&
&3.1639E+01_JPRB,2.3798E+01_JPRB,1.6609E+01_JPRB,1.5067E+01_JPRB,1.8464E+01_JPRB/)
KBO( :, 3,18,15) = (/&
&4.1858E+01_JPRB,3.1457E+01_JPRB,2.1141E+01_JPRB,1.5981E+01_JPRB,1.8293E+01_JPRB/)
KBO( :, 4,18,15) = (/&
&5.3342E+01_JPRB,4.0067E+01_JPRB,2.6795E+01_JPRB,1.7399E+01_JPRB,1.8084E+01_JPRB/)
KBO( :, 5,18,15) = (/&
&6.5884E+01_JPRB,4.9471E+01_JPRB,3.3060E+01_JPRB,1.9258E+01_JPRB,1.7848E+01_JPRB/)
KBO( :, 1,19,15) = (/&
&2.4623E+01_JPRB,1.8531E+01_JPRB,1.4907E+01_JPRB,1.6838E+01_JPRB,2.1462E+01_JPRB/)
KBO( :, 2,19,15) = (/&
&3.4070E+01_JPRB,2.5614E+01_JPRB,1.8084E+01_JPRB,1.7369E+01_JPRB,2.1261E+01_JPRB/)
KBO( :, 3,19,15) = (/&
&4.5079E+01_JPRB,3.3868E+01_JPRB,2.2784E+01_JPRB,1.8262E+01_JPRB,2.1046E+01_JPRB/)
KBO( :, 4,19,15) = (/&
&5.7371E+01_JPRB,4.3086E+01_JPRB,2.8804E+01_JPRB,1.9597E+01_JPRB,2.0788E+01_JPRB/)
KBO( :, 5,19,15) = (/&
&7.0794E+01_JPRB,5.3152E+01_JPRB,3.5511E+01_JPRB,2.1320E+01_JPRB,2.0472E+01_JPRB/)
KBO( :, 1,20,15) = (/&
&2.6740E+01_JPRB,2.0113E+01_JPRB,1.6687E+01_JPRB,1.9463E+01_JPRB,2.4692E+01_JPRB/)
KBO( :, 2,20,15) = (/&
&3.6896E+01_JPRB,2.7729E+01_JPRB,1.9869E+01_JPRB,1.9965E+01_JPRB,2.4417E+01_JPRB/)
KBO( :, 3,20,15) = (/&
&4.8627E+01_JPRB,3.6527E+01_JPRB,2.4686E+01_JPRB,2.0749E+01_JPRB,2.4109E+01_JPRB/)
KBO( :, 4,20,15) = (/&
&6.1800E+01_JPRB,4.6406E+01_JPRB,3.1013E+01_JPRB,2.1980E+01_JPRB,2.3749E+01_JPRB/)
KBO( :, 5,20,15) = (/&
&7.6193E+01_JPRB,5.7200E+01_JPRB,3.8207E+01_JPRB,2.3582E+01_JPRB,2.3335E+01_JPRB/)
KBO( :, 1,21,15) = (/&
&2.8977E+01_JPRB,2.1786E+01_JPRB,1.8588E+01_JPRB,2.2423E+01_JPRB,2.8316E+01_JPRB/)
KBO( :, 2,21,15) = (/&
&3.9801E+01_JPRB,2.9904E+01_JPRB,2.1842E+01_JPRB,2.2829E+01_JPRB,2.7905E+01_JPRB/)
KBO( :, 3,21,15) = (/&
&5.2367E+01_JPRB,3.9328E+01_JPRB,2.6804E+01_JPRB,2.3451E+01_JPRB,2.7467E+01_JPRB/)
KBO( :, 4,21,15) = (/&
&6.6469E+01_JPRB,4.9905E+01_JPRB,3.3345E+01_JPRB,2.4522E+01_JPRB,2.6969E+01_JPRB/)
KBO( :, 5,21,15) = (/&
&8.1848E+01_JPRB,6.1440E+01_JPRB,4.1033E+01_JPRB,2.6023E+01_JPRB,2.6435E+01_JPRB/)
KBO( :, 1,22,15) = (/&
&3.1988E+01_JPRB,2.4041E+01_JPRB,2.0812E+01_JPRB,2.5651E+01_JPRB,3.2255E+01_JPRB/)
KBO( :, 2,22,15) = (/&
&4.3721E+01_JPRB,3.2841E+01_JPRB,2.4334E+01_JPRB,2.5950E+01_JPRB,3.1687E+01_JPRB/)
KBO( :, 3,22,15) = (/&
&5.7294E+01_JPRB,4.3022E+01_JPRB,2.9561E+01_JPRB,2.6432E+01_JPRB,3.1040E+01_JPRB/)
KBO( :, 4,22,15) = (/&
&7.2474E+01_JPRB,5.4409E+01_JPRB,3.6410E+01_JPRB,2.7333E+01_JPRB,3.0338E+01_JPRB/)
KBO( :, 5,22,15) = (/&
&8.8942E+01_JPRB,6.6761E+01_JPRB,4.4583E+01_JPRB,2.8834E+01_JPRB,2.9615E+01_JPRB/)
KBO( :, 1,23,15) = (/&
&3.5516E+01_JPRB,2.6690E+01_JPRB,2.3334E+01_JPRB,2.9036E+01_JPRB,3.6353E+01_JPRB/)
KBO( :, 2,23,15) = (/&
&4.8281E+01_JPRB,3.6264E+01_JPRB,2.7127E+01_JPRB,2.9241E+01_JPRB,3.5539E+01_JPRB/)
KBO( :, 3,23,15) = (/&
&6.2902E+01_JPRB,4.7230E+01_JPRB,3.2633E+01_JPRB,2.9564E+01_JPRB,3.4668E+01_JPRB/)
KBO( :, 4,23,15) = (/&
&7.9108E+01_JPRB,5.9385E+01_JPRB,3.9793E+01_JPRB,3.0280E+01_JPRB,3.3772E+01_JPRB/)
KBO( :, 5,23,15) = (/&
&9.6701E+01_JPRB,7.2580E+01_JPRB,4.8461E+01_JPRB,3.1825E+01_JPRB,3.2859E+01_JPRB/)
KBO( :, 1,24,15) = (/&
&3.9680E+01_JPRB,2.9829E+01_JPRB,2.6160E+01_JPRB,3.2548E+01_JPRB,4.0469E+01_JPRB/)
KBO( :, 2,24,15) = (/&
&5.3468E+01_JPRB,4.0169E+01_JPRB,3.0146E+01_JPRB,3.2629E+01_JPRB,3.9411E+01_JPRB/)
KBO( :, 3,24,15) = (/&
&6.9159E+01_JPRB,5.1932E+01_JPRB,3.5957E+01_JPRB,3.2753E+01_JPRB,3.8325E+01_JPRB/)
KBO( :, 4,24,15) = (/&
&8.6552E+01_JPRB,6.4969E+01_JPRB,4.3591E+01_JPRB,3.3410E+01_JPRB,3.7213E+01_JPRB/)
KBO( :, 5,24,15) = (/&
&1.0532E+02_JPRB,7.9041E+01_JPRB,5.2783E+01_JPRB,3.4989E+01_JPRB,3.6087E+01_JPRB/)
KBO( :, 1,25,15) = (/&
&4.4432E+01_JPRB,3.3401E+01_JPRB,2.9194E+01_JPRB,3.6051E+01_JPRB,4.4622E+01_JPRB/)
KBO( :, 2,25,15) = (/&
&5.9330E+01_JPRB,4.4578E+01_JPRB,3.3433E+01_JPRB,3.6017E+01_JPRB,4.3268E+01_JPRB/)
KBO( :, 3,25,15) = (/&
&7.6262E+01_JPRB,5.7273E+01_JPRB,3.9678E+01_JPRB,3.5986E+01_JPRB,4.1914E+01_JPRB/)
KBO( :, 4,25,15) = (/&
&9.4907E+01_JPRB,7.1254E+01_JPRB,4.7861E+01_JPRB,3.6668E+01_JPRB,4.0563E+01_JPRB/)
KBO( :, 5,25,15) = (/&
&1.1490E+02_JPRB,8.6240E+01_JPRB,5.7602E+01_JPRB,3.8320E+01_JPRB,3.9224E+01_JPRB/)
KBO( :, 1,26,15) = (/&
&4.9945E+01_JPRB,3.7542E+01_JPRB,3.2485E+01_JPRB,3.9526E+01_JPRB,4.8685E+01_JPRB/)
KBO( :, 2,26,15) = (/&
&6.6132E+01_JPRB,4.9685E+01_JPRB,3.7067E+01_JPRB,3.9294E+01_JPRB,4.7029E+01_JPRB/)
KBO( :, 3,26,15) = (/&
&8.4358E+01_JPRB,6.3353E+01_JPRB,4.3878E+01_JPRB,3.9293E+01_JPRB,4.5384E+01_JPRB/)
KBO( :, 4,26,15) = (/&
&1.0419E+02_JPRB,7.8224E+01_JPRB,5.2598E+01_JPRB,4.0034E+01_JPRB,4.3769E+01_JPRB/)
KBO( :, 5,26,15) = (/&
&1.2529E+02_JPRB,9.4044E+01_JPRB,6.2813E+01_JPRB,4.1703E+01_JPRB,4.2207E+01_JPRB/)
KBO( :, 1,27,15) = (/&
&5.6070E+01_JPRB,4.2141E+01_JPRB,3.5908E+01_JPRB,4.2930E+01_JPRB,5.2613E+01_JPRB/)
KBO( :, 2,27,15) = (/&
&7.3488E+01_JPRB,5.5206E+01_JPRB,4.0960E+01_JPRB,4.2467E+01_JPRB,5.0627E+01_JPRB/)
KBO( :, 3,27,15) = (/&
&9.2902E+01_JPRB,6.9766E+01_JPRB,4.8295E+01_JPRB,4.2561E+01_JPRB,4.8685E+01_JPRB/)
KBO( :, 4,27,15) = (/&
&1.1389E+02_JPRB,8.5509E+01_JPRB,5.7519E+01_JPRB,4.3345E+01_JPRB,4.6803E+01_JPRB/)
KBO( :, 5,27,15) = (/&
&1.3609E+02_JPRB,1.0215E+02_JPRB,6.8230E+01_JPRB,4.5005E+01_JPRB,4.4998E+01_JPRB/)
KBO( :, 1,28,15) = (/&
&6.2602E+01_JPRB,4.7047E+01_JPRB,3.9407E+01_JPRB,4.6160E+01_JPRB,5.6361E+01_JPRB/)
KBO( :, 2,28,15) = (/&
&8.1239E+01_JPRB,6.1026E+01_JPRB,4.4978E+01_JPRB,4.5556E+01_JPRB,5.4022E+01_JPRB/)
KBO( :, 3,28,15) = (/&
&1.0182E+02_JPRB,7.6460E+01_JPRB,5.2849E+01_JPRB,4.5684E+01_JPRB,5.1781E+01_JPRB/)
KBO( :, 4,28,15) = (/&
&1.2390E+02_JPRB,9.3015E+01_JPRB,6.2567E+01_JPRB,4.6514E+01_JPRB,4.9625E+01_JPRB/)
KBO( :, 5,28,15) = (/&
&1.4712E+02_JPRB,1.1043E+02_JPRB,7.3749E+01_JPRB,4.8179E+01_JPRB,4.7555E+01_JPRB/)
KBO( :, 1,29,15) = (/&
&6.9623E+01_JPRB,5.2320E+01_JPRB,4.3015E+01_JPRB,4.9123E+01_JPRB,5.9729E+01_JPRB/)
KBO( :, 2,29,15) = (/&
&8.9447E+01_JPRB,6.7187E+01_JPRB,4.9134E+01_JPRB,4.8482E+01_JPRB,5.7058E+01_JPRB/)
KBO( :, 3,29,15) = (/&
&1.1112E+02_JPRB,8.3443E+01_JPRB,5.7534E+01_JPRB,4.8630E+01_JPRB,5.4527E+01_JPRB/)
KBO( :, 4,29,15) = (/&
&1.3428E+02_JPRB,1.0081E+02_JPRB,6.7748E+01_JPRB,4.9484E+01_JPRB,5.2105E+01_JPRB/)
KBO( :, 5,29,15) = (/&
&1.5845E+02_JPRB,1.1893E+02_JPRB,7.9425E+01_JPRB,5.1210E+01_JPRB,4.9788E+01_JPRB/)
KBO( :, 1,30,15) = (/&
&7.6956E+01_JPRB,5.7823E+01_JPRB,4.6660E+01_JPRB,5.1758E+01_JPRB,6.2685E+01_JPRB/)
KBO( :, 2,30,15) = (/&
&9.7902E+01_JPRB,7.3533E+01_JPRB,5.3332E+01_JPRB,5.1164E+01_JPRB,5.9706E+01_JPRB/)
KBO( :, 3,30,15) = (/&
&1.2067E+02_JPRB,9.0610E+01_JPRB,6.2274E+01_JPRB,5.1339E+01_JPRB,5.6887E+01_JPRB/)
KBO( :, 4,30,15) = (/&
&1.4481E+02_JPRB,1.0871E+02_JPRB,7.2976E+01_JPRB,5.2237E+01_JPRB,5.4217E+01_JPRB/)
KBO( :, 5,30,15) = (/&
&1.6975E+02_JPRB,1.2741E+02_JPRB,8.5081E+01_JPRB,5.4027E+01_JPRB,5.1685E+01_JPRB/)
KBO( :, 1,31,15) = (/&
&8.4668E+01_JPRB,6.3613E+01_JPRB,5.0308E+01_JPRB,5.4125E+01_JPRB,6.5163E+01_JPRB/)
KBO( :, 2,31,15) = (/&
&1.0670E+02_JPRB,8.0139E+01_JPRB,5.7571E+01_JPRB,5.3567E+01_JPRB,6.1881E+01_JPRB/)
KBO( :, 3,31,15) = (/&
&1.3043E+02_JPRB,9.7932E+01_JPRB,6.7030E+01_JPRB,5.3784E+01_JPRB,5.8816E+01_JPRB/)
KBO( :, 4,31,15) = (/&
&1.5531E+02_JPRB,1.1659E+02_JPRB,7.8195E+01_JPRB,5.4732E+01_JPRB,5.5925E+01_JPRB/)
KBO( :, 5,31,15) = (/&
&1.8083E+02_JPRB,1.3573E+02_JPRB,9.0627E+01_JPRB,5.6617E+01_JPRB,5.3201E+01_JPRB/)
KBO( :, 1,32,15) = (/&
&9.2652E+01_JPRB,6.9602E+01_JPRB,5.3950E+01_JPRB,5.6194E+01_JPRB,6.7147E+01_JPRB/)
KBO( :, 2,32,15) = (/&
&1.1562E+02_JPRB,8.6827E+01_JPRB,6.1761E+01_JPRB,5.5696E+01_JPRB,6.3605E+01_JPRB/)
KBO( :, 3,32,15) = (/&
&1.4016E+02_JPRB,1.0523E+02_JPRB,7.1723E+01_JPRB,5.5956E+01_JPRB,6.0313E+01_JPRB/)
KBO( :, 4,32,15) = (/&
&1.6571E+02_JPRB,1.2439E+02_JPRB,8.3322E+01_JPRB,5.6967E+01_JPRB,5.7235E+01_JPRB/)
KBO( :, 5,32,15) = (/&
&1.9180E+02_JPRB,1.4395E+02_JPRB,9.6112E+01_JPRB,5.9039E+01_JPRB,5.4359E+01_JPRB/)
KBO( :, 1,33,15) = (/&
&1.0072E+02_JPRB,7.5656E+01_JPRB,5.7525E+01_JPRB,5.7981E+01_JPRB,6.8650E+01_JPRB/)
KBO( :, 2,33,15) = (/&
&1.2455E+02_JPRB,9.3526E+01_JPRB,6.5887E+01_JPRB,5.7530E+01_JPRB,6.4898E+01_JPRB/)
KBO( :, 3,33,15) = (/&
&1.4981E+02_JPRB,1.1247E+02_JPRB,7.6362E+01_JPRB,5.7872E+01_JPRB,6.1421E+01_JPRB/)
KBO( :, 4,33,15) = (/&
&1.7592E+02_JPRB,1.3205E+02_JPRB,8.8345E+01_JPRB,5.9018E+01_JPRB,5.8197E+01_JPRB/)
KBO( :, 5,33,15) = (/&
&2.0244E+02_JPRB,1.5193E+02_JPRB,1.0144E+02_JPRB,6.1255E+01_JPRB,5.5191E+01_JPRB/)
KBO( :, 1,34,15) = (/&
&1.0805E+02_JPRB,8.1154E+01_JPRB,6.0752E+01_JPRB,5.9538E+01_JPRB,6.9858E+01_JPRB/)
KBO( :, 2,34,15) = (/&
&1.3258E+02_JPRB,9.9553E+01_JPRB,6.9613E+01_JPRB,5.9127E+01_JPRB,6.5932E+01_JPRB/)
KBO( :, 3,34,15) = (/&
&1.5841E+02_JPRB,1.1893E+02_JPRB,8.0500E+01_JPRB,5.9515E+01_JPRB,6.2316E+01_JPRB/)
KBO( :, 4,34,15) = (/&
&1.8496E+02_JPRB,1.3883E+02_JPRB,9.2804E+01_JPRB,6.0816E+01_JPRB,5.8960E+01_JPRB/)
KBO( :, 5,34,15) = (/&
&2.1175E+02_JPRB,1.5892E+02_JPRB,1.0610E+02_JPRB,6.3176E+01_JPRB,5.5844E+01_JPRB/)
KBO( :, 1,35,15) = (/&
&1.1294E+02_JPRB,8.4826E+01_JPRB,6.3098E+01_JPRB,6.0919E+01_JPRB,7.1099E+01_JPRB/)
KBO( :, 2,35,15) = (/&
&1.3798E+02_JPRB,1.0360E+02_JPRB,7.2230E+01_JPRB,6.0487E+01_JPRB,6.7012E+01_JPRB/)
KBO( :, 3,35,15) = (/&
&1.6418E+02_JPRB,1.2325E+02_JPRB,8.3338E+01_JPRB,6.0862E+01_JPRB,6.3251E+01_JPRB/)
KBO( :, 4,35,15) = (/&
&1.9102E+02_JPRB,1.4338E+02_JPRB,9.5820E+01_JPRB,6.2223E+01_JPRB,5.9778E+01_JPRB/)
KBO( :, 5,35,15) = (/&
&2.1806E+02_JPRB,1.6365E+02_JPRB,1.0925E+02_JPRB,6.4647E+01_JPRB,5.6557E+01_JPRB/)
KBO( :, 1,36,15) = (/&
&1.1497E+02_JPRB,8.6347E+01_JPRB,6.4397E+01_JPRB,6.2153E+01_JPRB,7.2517E+01_JPRB/)
KBO( :, 2,36,15) = (/&
&1.4029E+02_JPRB,1.0534E+02_JPRB,7.3555E+01_JPRB,6.1644E+01_JPRB,6.8256E+01_JPRB/)
KBO( :, 3,36,15) = (/&
&1.6674E+02_JPRB,1.2517E+02_JPRB,8.4714E+01_JPRB,6.1952E+01_JPRB,6.4357E+01_JPRB/)
KBO( :, 4,36,15) = (/&
&1.9381E+02_JPRB,1.4548E+02_JPRB,9.7239E+01_JPRB,6.3251E+01_JPRB,6.0757E+01_JPRB/)
KBO( :, 5,36,15) = (/&
&2.2104E+02_JPRB,1.6589E+02_JPRB,1.1075E+02_JPRB,6.5650E+01_JPRB,5.7519E+01_JPRB/)
KBO( :, 1,37,15) = (/&
&1.1301E+02_JPRB,8.4880E+01_JPRB,6.4331E+01_JPRB,6.3346E+01_JPRB,7.4417E+01_JPRB/)
KBO( :, 2,37,15) = (/&
&1.3839E+02_JPRB,1.0391E+02_JPRB,7.3187E+01_JPRB,6.2656E+01_JPRB,6.9936E+01_JPRB/)
KBO( :, 3,37,15) = (/&
&1.6490E+02_JPRB,1.2380E+02_JPRB,8.4124E+01_JPRB,6.2789E+01_JPRB,6.5851E+01_JPRB/)
KBO( :, 4,37,15) = (/&
&1.9210E+02_JPRB,1.4420E+02_JPRB,9.6503E+01_JPRB,6.3870E+01_JPRB,6.2117E+01_JPRB/)
KBO( :, 5,37,15) = (/&
&2.1953E+02_JPRB,1.6476E+02_JPRB,1.1000E+02_JPRB,6.6083E+01_JPRB,5.8820E+01_JPRB/)
KBO( :, 1,38,15) = (/&
&1.1060E+02_JPRB,8.3078E+01_JPRB,6.4103E+01_JPRB,6.4426E+01_JPRB,7.6201E+01_JPRB/)
KBO( :, 2,38,15) = (/&
&1.3599E+02_JPRB,1.0211E+02_JPRB,7.2632E+01_JPRB,6.3555E+01_JPRB,7.1515E+01_JPRB/)
KBO( :, 3,38,15) = (/&
&1.6253E+02_JPRB,1.2202E+02_JPRB,8.3307E+01_JPRB,6.3503E+01_JPRB,6.7259E+01_JPRB/)
KBO( :, 4,38,15) = (/&
&1.8982E+02_JPRB,1.4248E+02_JPRB,9.5509E+01_JPRB,6.4372E+01_JPRB,6.3412E+01_JPRB/)
KBO( :, 5,38,15) = (/&
&2.1740E+02_JPRB,1.6316E+02_JPRB,1.0894E+02_JPRB,6.6382E+01_JPRB,6.0081E+01_JPRB/)
KBO( :, 1,39,15) = (/&
&1.0803E+02_JPRB,8.1144E+01_JPRB,6.3771E+01_JPRB,6.5414E+01_JPRB,7.7868E+01_JPRB/)
KBO( :, 2,39,15) = (/&
&1.3337E+02_JPRB,1.0015E+02_JPRB,7.1982E+01_JPRB,6.4350E+01_JPRB,7.2975E+01_JPRB/)
KBO( :, 3,39,15) = (/&
&1.5993E+02_JPRB,1.2007E+02_JPRB,8.2398E+01_JPRB,6.4114E+01_JPRB,6.8560E+01_JPRB/)
KBO( :, 4,39,15) = (/&
&1.8726E+02_JPRB,1.4057E+02_JPRB,9.4413E+01_JPRB,6.4795E+01_JPRB,6.4662E+01_JPRB/)
KBO( :, 5,39,15) = (/&
&2.1494E+02_JPRB,1.6132E+02_JPRB,1.0771E+02_JPRB,6.6595E+01_JPRB,6.1311E+01_JPRB/)
KBO( :, 1,40,15) = (/&
&1.0282E+02_JPRB,7.7288E+01_JPRB,6.2719E+01_JPRB,6.6497E+01_JPRB,7.9980E+01_JPRB/)
KBO( :, 2,40,15) = (/&
&1.2788E+02_JPRB,9.6038E+01_JPRB,7.0327E+01_JPRB,6.5135E+01_JPRB,7.4834E+01_JPRB/)
KBO( :, 3,40,15) = (/&
&1.5434E+02_JPRB,1.1588E+02_JPRB,8.0252E+01_JPRB,6.4644E+01_JPRB,7.0224E+01_JPRB/)
KBO( :, 4,40,15) = (/&
&1.8163E+02_JPRB,1.3634E+02_JPRB,9.1957E+01_JPRB,6.5051E+01_JPRB,6.6166E+01_JPRB/)
KBO( :, 5,40,15) = (/&
&2.0939E+02_JPRB,1.5716E+02_JPRB,1.0497E+02_JPRB,6.6532E+01_JPRB,6.2695E+01_JPRB/)
KBO( :, 1,41,15) = (/&
&9.7246E+01_JPRB,7.3264E+01_JPRB,6.1654E+01_JPRB,6.7606E+01_JPRB,8.2110E+01_JPRB/)
KBO( :, 2,41,15) = (/&
&1.2196E+02_JPRB,9.1598E+01_JPRB,6.8639E+01_JPRB,6.5918E+01_JPRB,7.6715E+01_JPRB/)
KBO( :, 3,41,15) = (/&
&1.4825E+02_JPRB,1.1131E+02_JPRB,7.7976E+01_JPRB,6.5166E+01_JPRB,7.1898E+01_JPRB/)
KBO( :, 4,41,15) = (/&
&1.7546E+02_JPRB,1.3172E+02_JPRB,8.9341E+01_JPRB,6.5294E+01_JPRB,6.7663E+01_JPRB/)
KBO( :, 5,41,15) = (/&
&2.0319E+02_JPRB,1.5251E+02_JPRB,1.0200E+02_JPRB,6.6466E+01_JPRB,6.4089E+01_JPRB/)
KBO( :, 1,42,15) = (/&
&9.1646E+01_JPRB,6.9319E+01_JPRB,6.0662E+01_JPRB,6.8736E+01_JPRB,8.4225E+01_JPRB/)
KBO( :, 2,42,15) = (/&
&1.1599E+02_JPRB,8.7117E+01_JPRB,6.7035E+01_JPRB,6.6694E+01_JPRB,7.8581E+01_JPRB/)
KBO( :, 3,42,15) = (/&
&1.4201E+02_JPRB,1.0663E+02_JPRB,7.5772E+01_JPRB,6.5694E+01_JPRB,7.3551E+01_JPRB/)
KBO( :, 4,42,15) = (/&
&1.6913E+02_JPRB,1.2698E+02_JPRB,8.6698E+01_JPRB,6.5537E+01_JPRB,6.9143E+01_JPRB/)
KBO( :, 5,42,15) = (/&
&1.9682E+02_JPRB,1.4774E+02_JPRB,9.9046E+01_JPRB,6.6404E+01_JPRB,6.5463E+01_JPRB/)
KBO( :, 1,43,15) = (/&
&8.4789E+01_JPRB,6.4636E+01_JPRB,5.9566E+01_JPRB,7.0099E+01_JPRB,8.6671E+01_JPRB/)
KBO( :, 2,43,15) = (/&
&1.0857E+02_JPRB,8.1571E+01_JPRB,6.5097E+01_JPRB,6.7581E+01_JPRB,8.0749E+01_JPRB/)
KBO( :, 3,43,15) = (/&
&1.3420E+02_JPRB,1.0078E+02_JPRB,7.3112E+01_JPRB,6.6245E+01_JPRB,7.5464E+01_JPRB/)
KBO( :, 4,43,15) = (/&
&1.6112E+02_JPRB,1.2096E+02_JPRB,8.3408E+01_JPRB,6.5806E+01_JPRB,7.0849E+01_JPRB/)
KBO( :, 5,43,15) = (/&
&1.8873E+02_JPRB,1.4167E+02_JPRB,9.5382E+01_JPRB,6.6299E+01_JPRB,6.7006E+01_JPRB/)
KBO( :, 1,44,15) = (/&
&7.7526E+01_JPRB,5.9880E+01_JPRB,5.8674E+01_JPRB,7.1657E+01_JPRB,8.9332E+01_JPRB/)
KBO( :, 2,44,15) = (/&
&1.0062E+02_JPRB,7.5764E+01_JPRB,6.3217E+01_JPRB,6.8595E+01_JPRB,8.3089E+01_JPRB/)
KBO( :, 3,44,15) = (/&
&1.2573E+02_JPRB,9.4425E+01_JPRB,7.0405E+01_JPRB,6.6884E+01_JPRB,7.7528E+01_JPRB/)
KBO( :, 4,44,15) = (/&
&1.5235E+02_JPRB,1.1439E+02_JPRB,7.9935E+01_JPRB,6.6125E+01_JPRB,7.2672E+01_JPRB/)
KBO( :, 5,44,15) = (/&
&1.7985E+02_JPRB,1.3501E+02_JPRB,9.1481E+01_JPRB,6.6264E+01_JPRB,6.8668E+01_JPRB/)
KBO( :, 1,45,15) = (/&
&7.0491E+01_JPRB,5.5510E+01_JPRB,5.8020E+01_JPRB,7.3319E+01_JPRB,9.2047E+01_JPRB/)
KBO( :, 2,45,15) = (/&
&9.2796E+01_JPRB,7.0229E+01_JPRB,6.1583E+01_JPRB,6.9737E+01_JPRB,8.5464E+01_JPRB/)
KBO( :, 3,45,15) = (/&
&1.1733E+02_JPRB,8.8127E+01_JPRB,6.7937E+01_JPRB,6.7594E+01_JPRB,7.9635E+01_JPRB/)
KBO( :, 4,45,15) = (/&
&1.4359E+02_JPRB,1.0781E+02_JPRB,7.6707E+01_JPRB,6.6524E+01_JPRB,7.4535E+01_JPRB/)
KBO( :, 5,45,15) = (/&
&1.7088E+02_JPRB,1.2829E+02_JPRB,8.7650E+01_JPRB,6.6303E+01_JPRB,7.0370E+01_JPRB/)
KBO( :, 1,46,15) = (/&
&6.3285E+01_JPRB,5.1283E+01_JPRB,5.7489E+01_JPRB,7.5126E+01_JPRB,9.5002E+01_JPRB/)
KBO( :, 2,46,15) = (/&
&8.4647E+01_JPRB,6.4675E+01_JPRB,6.0155E+01_JPRB,7.1107E+01_JPRB,8.8042E+01_JPRB/)
KBO( :, 3,46,15) = (/&
&1.0850E+02_JPRB,8.1543E+01_JPRB,6.5540E+01_JPRB,6.8434E+01_JPRB,8.1933E+01_JPRB/)
KBO( :, 4,46,15) = (/&
&1.3425E+02_JPRB,1.0081E+02_JPRB,7.3459E+01_JPRB,6.6985E+01_JPRB,7.6545E+01_JPRB/)
KBO( :, 5,46,15) = (/&
&1.6128E+02_JPRB,1.2109E+02_JPRB,8.3670E+01_JPRB,6.6464E+01_JPRB,7.2233E+01_JPRB/)
KBO( :, 1,47,15) = (/&
&5.5631E+01_JPRB,4.7112E+01_JPRB,5.7366E+01_JPRB,7.7250E+01_JPRB,9.8390E+01_JPRB/)
KBO( :, 2,47,15) = (/&
&7.5847E+01_JPRB,5.8961E+01_JPRB,5.9001E+01_JPRB,7.2829E+01_JPRB,9.1005E+01_JPRB/)
KBO( :, 3,47,15) = (/&
&9.8817E+01_JPRB,7.4522E+01_JPRB,6.3205E+01_JPRB,6.9511E+01_JPRB,8.4535E+01_JPRB/)
KBO( :, 4,47,15) = (/&
&1.2390E+02_JPRB,9.3053E+01_JPRB,7.0147E+01_JPRB,6.7616E+01_JPRB,7.8824E+01_JPRB/)
KBO( :, 5,47,15) = (/&
&1.5053E+02_JPRB,1.1302E+02_JPRB,7.9443E+01_JPRB,6.6722E+01_JPRB,7.4271E+01_JPRB/)
KBO( :, 1,48,15) = (/&
&4.8436E+01_JPRB,4.3553E+01_JPRB,5.7561E+01_JPRB,7.9397E+01_JPRB,1.0193E+02_JPRB/)
KBO( :, 2,48,15) = (/&
&6.7454E+01_JPRB,5.3825E+01_JPRB,5.8172E+01_JPRB,7.4675E+01_JPRB,9.4102E+01_JPRB/)
KBO( :, 3,48,15) = (/&
&8.9409E+01_JPRB,6.7955E+01_JPRB,6.1273E+01_JPRB,7.0816E+01_JPRB,8.7238E+01_JPRB/)
KBO( :, 4,48,15) = (/&
&1.1374E+02_JPRB,8.5433E+01_JPRB,6.7178E+01_JPRB,6.8391E+01_JPRB,8.1214E+01_JPRB/)
KBO( :, 5,48,15) = (/&
&1.3983E+02_JPRB,1.0500E+02_JPRB,7.5561E+01_JPRB,6.7098E+01_JPRB,7.6443E+01_JPRB/)
KBO( :, 1,49,15) = (/&
&4.1740E+01_JPRB,4.0612E+01_JPRB,5.8201E+01_JPRB,8.1772E+01_JPRB,1.0563E+02_JPRB/)
KBO( :, 2,49,15) = (/&
&5.9508E+01_JPRB,4.9323E+01_JPRB,5.7719E+01_JPRB,7.6675E+01_JPRB,9.7333E+01_JPRB/)
KBO( :, 3,49,15) = (/&
&8.0351E+01_JPRB,6.1919E+01_JPRB,5.9828E+01_JPRB,7.2362E+01_JPRB,9.0062E+01_JPRB/)
KBO( :, 4,49,15) = (/&
&1.0383E+02_JPRB,7.8144E+01_JPRB,6.4592E+01_JPRB,6.9309E+01_JPRB,8.3761E+01_JPRB/)
KBO( :, 5,49,15) = (/&
&1.2931E+02_JPRB,9.7110E+01_JPRB,7.1998E+01_JPRB,6.7617E+01_JPRB,7.8823E+01_JPRB/)
KBO( :, 1,50,15) = (/&
&3.5934E+01_JPRB,3.8439E+01_JPRB,5.9112E+01_JPRB,8.4116E+01_JPRB,1.0931E+02_JPRB/)
KBO( :, 2,50,15) = (/&
&5.2489E+01_JPRB,4.5633E+01_JPRB,5.7703E+01_JPRB,7.8607E+01_JPRB,1.0052E+02_JPRB/)
KBO( :, 3,50,15) = (/&
&7.2228E+01_JPRB,5.6786E+01_JPRB,5.8886E+01_JPRB,7.4022E+01_JPRB,9.2854E+01_JPRB/)
KBO( :, 4,50,15) = (/&
&9.4805E+01_JPRB,7.1728E+01_JPRB,6.2540E+01_JPRB,7.0379E+01_JPRB,8.6215E+01_JPRB/)
KBO( :, 5,50,15) = (/&
&1.1961E+02_JPRB,8.9835E+01_JPRB,6.9015E+01_JPRB,6.8227E+01_JPRB,8.1035E+01_JPRB/)
KBO( :, 1,51,15) = (/&
&3.0771E+01_JPRB,3.7000E+01_JPRB,6.0264E+01_JPRB,8.6506E+01_JPRB,1.1308E+02_JPRB/)
KBO( :, 2,51,15) = (/&
&4.6091E+01_JPRB,4.2604E+01_JPRB,5.8016E+01_JPRB,8.0604E+01_JPRB,1.0374E+02_JPRB/)
KBO( :, 3,51,15) = (/&
&6.4712E+01_JPRB,5.2306E+01_JPRB,5.8175E+01_JPRB,7.5702E+01_JPRB,9.5668E+01_JPRB/)
KBO( :, 4,51,15) = (/&
&8.6318E+01_JPRB,6.5907E+01_JPRB,6.0924E+01_JPRB,7.1626E+01_JPRB,8.8689E+01_JPRB/)
KBO( :, 5,51,15) = (/&
&1.1042E+02_JPRB,8.2968E+01_JPRB,6.6417E+01_JPRB,6.8953E+01_JPRB,8.3187E+01_JPRB/)
KBO( :, 1,52,15) = (/&
&2.6073E+01_JPRB,3.6045E+01_JPRB,6.1822E+01_JPRB,8.9117E+01_JPRB,1.1704E+02_JPRB/)
KBO( :, 2,52,15) = (/&
&4.0129E+01_JPRB,4.0074E+01_JPRB,5.8683E+01_JPRB,8.2788E+01_JPRB,1.0713E+02_JPRB/)
KBO( :, 3,52,15) = (/&
&5.7599E+01_JPRB,4.8365E+01_JPRB,5.7911E+01_JPRB,7.7538E+01_JPRB,9.8609E+01_JPRB/)
KBO( :, 4,52,15) = (/&
&7.8172E+01_JPRB,6.0565E+01_JPRB,5.9728E+01_JPRB,7.3072E+01_JPRB,9.1293E+01_JPRB/)
KBO( :, 5,52,15) = (/&
&1.0144E+02_JPRB,7.6446E+01_JPRB,6.4164E+01_JPRB,6.9820E+01_JPRB,8.5483E+01_JPRB/)
KBO( :, 1,53,15) = (/&
&2.1825E+01_JPRB,3.5431E+01_JPRB,6.3525E+01_JPRB,9.1916E+01_JPRB,1.2120E+02_JPRB/)
KBO( :, 2,53,15) = (/&
&3.4602E+01_JPRB,3.8125E+01_JPRB,5.9600E+01_JPRB,8.5050E+01_JPRB,1.1069E+02_JPRB/)
KBO( :, 3,53,15) = (/&
&5.0871E+01_JPRB,4.4917E+01_JPRB,5.7933E+01_JPRB,7.9373E+01_JPRB,1.0169E+02_JPRB/)
KBO( :, 4,53,15) = (/&
&7.0355E+01_JPRB,5.5689E+01_JPRB,5.8850E+01_JPRB,7.4670E+01_JPRB,9.4071E+01_JPRB/)
KBO( :, 5,53,15) = (/&
&9.2711E+01_JPRB,7.0293E+01_JPRB,6.2235E+01_JPRB,7.0877E+01_JPRB,8.7997E+01_JPRB/)
KBO( :, 1,54,15) = (/&
&1.8337E+01_JPRB,3.5294E+01_JPRB,6.5103E+01_JPRB,9.4568E+01_JPRB,1.2522E+02_JPRB/)
KBO( :, 2,54,15) = (/&
&2.9950E+01_JPRB,3.6915E+01_JPRB,6.0716E+01_JPRB,8.7228E+01_JPRB,1.1414E+02_JPRB/)
KBO( :, 3,54,15) = (/&
&4.5070E+01_JPRB,4.2223E+01_JPRB,5.8276E+01_JPRB,8.1216E+01_JPRB,1.0463E+02_JPRB/)
KBO( :, 4,54,15) = (/&
&6.3520E+01_JPRB,5.1682E+01_JPRB,5.8241E+01_JPRB,7.6218E+01_JPRB,9.6556E+01_JPRB/)
KBO( :, 5,54,15) = (/&
&8.4973E+01_JPRB,6.5035E+01_JPRB,6.0814E+01_JPRB,7.2031E+01_JPRB,8.9905E+01_JPRB/)
KBO( :, 1,55,15) = (/&
&1.5337E+01_JPRB,3.5484E+01_JPRB,6.6783E+01_JPRB,9.7340E+01_JPRB,1.2928E+02_JPRB/)
KBO( :, 2,55,15) = (/&
&2.5852E+01_JPRB,3.6097E+01_JPRB,6.2097E+01_JPRB,8.9537E+01_JPRB,1.1762E+02_JPRB/)
KBO( :, 3,55,15) = (/&
&3.9852E+01_JPRB,4.0035E+01_JPRB,5.8876E+01_JPRB,8.3127E+01_JPRB,1.0760E+02_JPRB/)
KBO( :, 4,55,15) = (/&
&5.7277E+01_JPRB,4.8243E+01_JPRB,5.8037E+01_JPRB,7.7828E+01_JPRB,9.9021E+01_JPRB/)
KBO( :, 5,55,15) = (/&
&7.7821E+01_JPRB,6.0372E+01_JPRB,5.9798E+01_JPRB,7.3320E+01_JPRB,9.1766E+01_JPRB/)
KBO( :, 1,56,15) = (/&
&1.2678E+01_JPRB,3.5873E+01_JPRB,6.8551E+01_JPRB,1.0034E+02_JPRB,1.3352E+02_JPRB/)
KBO( :, 2,56,15) = (/&
&2.2123E+01_JPRB,3.5552E+01_JPRB,6.3571E+01_JPRB,9.1965E+01_JPRB,1.2124E+02_JPRB/)
KBO( :, 3,56,15) = (/&
&3.5001E+01_JPRB,3.8317E+01_JPRB,5.9669E+01_JPRB,8.5094E+01_JPRB,1.1071E+02_JPRB/)
KBO( :, 4,56,15) = (/&
&5.1365E+01_JPRB,4.5210E+01_JPRB,5.8041E+01_JPRB,7.9413E+01_JPRB,1.0170E+02_JPRB/)
KBO( :, 5,56,15) = (/&
&7.0946E+01_JPRB,5.6077E+01_JPRB,5.9007E+01_JPRB,7.4694E+01_JPRB,9.3909E+01_JPRB/)
KBO( :, 1,57,15) = (/&
&1.0339E+01_JPRB,3.6549E+01_JPRB,7.0411E+01_JPRB,1.0357E+02_JPRB,1.3800E+02_JPRB/)
KBO( :, 2,57,15) = (/&
&1.8742E+01_JPRB,3.5363E+01_JPRB,6.5053E+01_JPRB,9.4457E+01_JPRB,1.2502E+02_JPRB/)
KBO( :, 3,57,15) = (/&
&3.0504E+01_JPRB,3.7104E+01_JPRB,6.0681E+01_JPRB,8.7139E+01_JPRB,1.1395E+02_JPRB/)
KBO( :, 4,57,15) = (/&
&4.5773E+01_JPRB,4.2584E+01_JPRB,5.8331E+01_JPRB,8.1143E+01_JPRB,1.0448E+02_JPRB/)
KBO( :, 5,57,15) = (/&
&6.4363E+01_JPRB,5.2190E+01_JPRB,5.8389E+01_JPRB,7.6157E+01_JPRB,9.6302E+01_JPRB/)
KBO( :, 1,58,15) = (/&
&8.4072E+00_JPRB,3.7388E+01_JPRB,7.2338E+01_JPRB,1.0684E+02_JPRB,1.4246E+02_JPRB/)
KBO( :, 2,58,15) = (/&
&1.5855E+01_JPRB,3.5502E+01_JPRB,6.6608E+01_JPRB,9.7023E+01_JPRB,1.2881E+02_JPRB/)
KBO( :, 3,58,15) = (/&
&2.6572E+01_JPRB,3.6289E+01_JPRB,6.1949E+01_JPRB,8.9266E+01_JPRB,1.1719E+02_JPRB/)
KBO( :, 4,58,15) = (/&
&4.0779E+01_JPRB,4.0444E+01_JPRB,5.8844E+01_JPRB,8.2917E+01_JPRB,1.0723E+02_JPRB/)
KBO( :, 5,58,15) = (/&
&5.8404E+01_JPRB,4.8880E+01_JPRB,5.8134E+01_JPRB,7.7647E+01_JPRB,9.8698E+01_JPRB/)
KBO( :, 1,59,15) = (/&
&7.7095E+00_JPRB,3.7763E+01_JPRB,7.3160E+01_JPRB,1.0825E+02_JPRB,1.4434E+02_JPRB/)
KBO( :, 2,59,15) = (/&
&1.4785E+01_JPRB,3.5623E+01_JPRB,6.7273E+01_JPRB,9.8137E+01_JPRB,1.3040E+02_JPRB/)
KBO( :, 3,59,15) = (/&
&2.5092E+01_JPRB,3.6030E+01_JPRB,6.2505E+01_JPRB,9.0193E+01_JPRB,1.1856E+02_JPRB/)
KBO( :, 4,59,15) = (/&
&3.8875E+01_JPRB,3.9709E+01_JPRB,5.9122E+01_JPRB,8.3653E+01_JPRB,1.0840E+02_JPRB/)
KBO( :, 5,59,15) = (/&
&5.6102E+01_JPRB,4.7649E+01_JPRB,5.8109E+01_JPRB,7.8262E+01_JPRB,9.9705E+01_JPRB/)
KBO( :, 1,13,16) = (/&
&3.2263E+01_JPRB,2.4210E+01_JPRB,1.6158E+01_JPRB,8.6472E+00_JPRB,1.1361E+01_JPRB/)
KBO( :, 2,13,16) = (/&
&4.5174E+01_JPRB,3.3894E+01_JPRB,2.2614E+01_JPRB,1.1334E+01_JPRB,1.0965E+01_JPRB/)
KBO( :, 3,13,16) = (/&
&6.0029E+01_JPRB,4.5035E+01_JPRB,3.0042E+01_JPRB,1.5048E+01_JPRB,1.0696E+01_JPRB/)
KBO( :, 4,13,16) = (/&
&7.6465E+01_JPRB,5.7362E+01_JPRB,3.8260E+01_JPRB,1.9157E+01_JPRB,1.0564E+01_JPRB/)
KBO( :, 5,13,16) = (/&
&9.4073E+01_JPRB,7.0568E+01_JPRB,4.7064E+01_JPRB,2.3559E+01_JPRB,1.0648E+01_JPRB/)
KBO( :, 1,14,16) = (/&
&3.9418E+01_JPRB,2.9575E+01_JPRB,1.9732E+01_JPRB,1.0271E+01_JPRB,1.2990E+01_JPRB/)
KBO( :, 2,14,16) = (/&
&5.4735E+01_JPRB,4.1063E+01_JPRB,2.7391E+01_JPRB,1.3719E+01_JPRB,1.2722E+01_JPRB/)
KBO( :, 3,14,16) = (/&
&7.2196E+01_JPRB,5.4159E+01_JPRB,3.6122E+01_JPRB,1.8084E+01_JPRB,1.2482E+01_JPRB/)
KBO( :, 4,14,16) = (/&
&9.1581E+01_JPRB,6.8699E+01_JPRB,4.5817E+01_JPRB,2.2935E+01_JPRB,1.2482E+01_JPRB/)
KBO( :, 5,14,16) = (/&
&1.1260E+02_JPRB,8.4466E+01_JPRB,5.6330E+01_JPRB,2.8194E+01_JPRB,1.2541E+01_JPRB/)
KBO( :, 1,15,16) = (/&
&4.7744E+01_JPRB,3.5818E+01_JPRB,2.3892E+01_JPRB,1.2552E+01_JPRB,1.5030E+01_JPRB/)
KBO( :, 2,15,16) = (/&
&6.5839E+01_JPRB,4.9390E+01_JPRB,3.2941E+01_JPRB,1.6492E+01_JPRB,1.4777E+01_JPRB/)
KBO( :, 3,15,16) = (/&
&8.6769E+01_JPRB,6.5089E+01_JPRB,4.3408E+01_JPRB,2.1728E+01_JPRB,1.4586E+01_JPRB/)
KBO( :, 4,15,16) = (/&
&1.1002E+02_JPRB,8.2528E+01_JPRB,5.5036E+01_JPRB,2.7544E+01_JPRB,1.4666E+01_JPRB/)
KBO( :, 5,15,16) = (/&
&1.3516E+02_JPRB,1.0139E+02_JPRB,6.7610E+01_JPRB,3.3833E+01_JPRB,1.4702E+01_JPRB/)
KBO( :, 1,16,16) = (/&
&5.7645E+01_JPRB,4.3243E+01_JPRB,2.8842E+01_JPRB,1.5267E+01_JPRB,1.7359E+01_JPRB/)
KBO( :, 2,16,16) = (/&
&7.9413E+01_JPRB,5.9570E+01_JPRB,3.9727E+01_JPRB,1.9884E+01_JPRB,1.7054E+01_JPRB/)
KBO( :, 3,16,16) = (/&
&1.0440E+02_JPRB,7.8314E+01_JPRB,5.2225E+01_JPRB,2.6135E+01_JPRB,1.7041E+01_JPRB/)
KBO( :, 4,16,16) = (/&
&1.3208E+02_JPRB,9.9071E+01_JPRB,6.6063E+01_JPRB,3.3056E+01_JPRB,1.7119E+01_JPRB/)
KBO( :, 5,16,16) = (/&
&1.6175E+02_JPRB,1.2132E+02_JPRB,8.0899E+01_JPRB,4.0476E+01_JPRB,1.7152E+01_JPRB/)
KBO( :, 1,17,16) = (/&
&6.9575E+01_JPRB,5.2190E+01_JPRB,3.4804E+01_JPRB,1.8369E+01_JPRB,1.9921E+01_JPRB/)
KBO( :, 2,17,16) = (/&
&9.5428E+01_JPRB,7.1580E+01_JPRB,4.7733E+01_JPRB,2.3885E+01_JPRB,1.9756E+01_JPRB/)
KBO( :, 3,17,16) = (/&
&1.2491E+02_JPRB,9.3694E+01_JPRB,6.2476E+01_JPRB,3.1259E+01_JPRB,1.9810E+01_JPRB/)
KBO( :, 4,17,16) = (/&
&1.5735E+02_JPRB,1.1802E+02_JPRB,7.8696E+01_JPRB,3.9370E+01_JPRB,1.9895E+01_JPRB/)
KBO( :, 5,17,16) = (/&
&1.9186E+02_JPRB,1.4391E+02_JPRB,9.5955E+01_JPRB,4.8001E+01_JPRB,1.9910E+01_JPRB/)
KBO( :, 1,18,16) = (/&
&8.3432E+01_JPRB,6.2581E+01_JPRB,4.1731E+01_JPRB,2.1854E+01_JPRB,2.3228E+01_JPRB/)
KBO( :, 2,18,16) = (/&
&1.1378E+02_JPRB,8.5346E+01_JPRB,5.6908E+01_JPRB,2.8471E+01_JPRB,2.3168E+01_JPRB/)
KBO( :, 3,18,16) = (/&
&1.4807E+02_JPRB,1.1106E+02_JPRB,7.4051E+01_JPRB,3.7043E+01_JPRB,2.3063E+01_JPRB/)
KBO( :, 4,18,16) = (/&
&1.8546E+02_JPRB,1.3910E+02_JPRB,9.2747E+01_JPRB,4.6393E+01_JPRB,2.3051E+01_JPRB/)
KBO( :, 5,18,16) = (/&
&2.2501E+02_JPRB,1.6877E+02_JPRB,1.1253E+02_JPRB,5.6286E+01_JPRB,2.2993E+01_JPRB/)
KBO( :, 1,19,16) = (/&
&9.9057E+01_JPRB,7.4299E+01_JPRB,4.9542E+01_JPRB,2.5942E+01_JPRB,2.7272E+01_JPRB/)
KBO( :, 2,19,16) = (/&
&1.3405E+02_JPRB,1.0055E+02_JPRB,6.7042E+01_JPRB,3.3543E+01_JPRB,2.7144E+01_JPRB/)
KBO( :, 3,19,16) = (/&
&1.7334E+02_JPRB,1.3002E+02_JPRB,8.6689E+01_JPRB,4.3364E+01_JPRB,2.6916E+01_JPRB/)
KBO( :, 4,19,16) = (/&
&2.1641E+02_JPRB,1.6232E+02_JPRB,1.0823E+02_JPRB,5.4140E+01_JPRB,2.6725E+01_JPRB/)
KBO( :, 5,19,16) = (/&
&2.6236E+02_JPRB,1.9678E+02_JPRB,1.3121E+02_JPRB,6.5630E+01_JPRB,2.6538E+01_JPRB/)
KBO( :, 1,20,16) = (/&
&1.1670E+02_JPRB,8.7534E+01_JPRB,5.8366E+01_JPRB,3.0680E+01_JPRB,3.1959E+01_JPRB/)
KBO( :, 2,20,16) = (/&
&1.5709E+02_JPRB,1.1783E+02_JPRB,7.8566E+01_JPRB,3.9305E+01_JPRB,3.1724E+01_JPRB/)
KBO( :, 3,20,16) = (/&
&2.0269E+02_JPRB,1.5203E+02_JPRB,1.0137E+02_JPRB,5.0708E+01_JPRB,3.1376E+01_JPRB/)
KBO( :, 4,20,16) = (/&
&2.5230E+02_JPRB,1.8924E+02_JPRB,1.2618E+02_JPRB,6.3114E+01_JPRB,3.0984E+01_JPRB/)
KBO( :, 5,20,16) = (/&
&3.0479E+02_JPRB,2.2861E+02_JPRB,1.5242E+02_JPRB,7.6237E+01_JPRB,3.0606E+01_JPRB/)
KBO( :, 1,21,16) = (/&
&1.3677E+02_JPRB,1.0259E+02_JPRB,6.8408E+01_JPRB,3.5947E+01_JPRB,3.7295E+01_JPRB/)
KBO( :, 2,21,16) = (/&
&1.8327E+02_JPRB,1.3746E+02_JPRB,9.1655E+01_JPRB,4.5850E+01_JPRB,3.6923E+01_JPRB/)
KBO( :, 3,21,16) = (/&
&2.3530E+02_JPRB,1.7648E+02_JPRB,1.1767E+02_JPRB,5.8860E+01_JPRB,3.6405E+01_JPRB/)
KBO( :, 4,21,16) = (/&
&2.9155E+02_JPRB,2.1867E+02_JPRB,1.4580E+02_JPRB,7.2922E+01_JPRB,3.5874E+01_JPRB/)
KBO( :, 5,21,16) = (/&
&3.5033E+02_JPRB,2.6276E+02_JPRB,1.7519E+02_JPRB,8.7619E+01_JPRB,3.5270E+01_JPRB/)
KBO( :, 1,22,16) = (/&
&1.6233E+02_JPRB,1.2176E+02_JPRB,8.1187E+01_JPRB,4.2657E+01_JPRB,4.3248E+01_JPRB/)
KBO( :, 2,22,16) = (/&
&2.1544E+02_JPRB,1.6159E+02_JPRB,1.0774E+02_JPRB,5.3945E+01_JPRB,4.2701E+01_JPRB/)
KBO( :, 3,22,16) = (/&
&2.7410E+02_JPRB,2.0559E+02_JPRB,1.3707E+02_JPRB,6.8557E+01_JPRB,4.2119E+01_JPRB/)
KBO( :, 4,22,16) = (/&
&3.3685E+02_JPRB,2.5265E+02_JPRB,1.6845E+02_JPRB,8.4248E+01_JPRB,4.1509E+01_JPRB/)
KBO( :, 5,22,16) = (/&
&4.0263E+02_JPRB,3.0199E+02_JPRB,2.0134E+02_JPRB,1.0070E+02_JPRB,4.0811E+01_JPRB/)
KBO( :, 1,23,16) = (/&
&1.9053E+02_JPRB,1.4291E+02_JPRB,9.5285E+01_JPRB,5.0617E+01_JPRB,5.0337E+01_JPRB/)
KBO( :, 2,23,16) = (/&
&2.5017E+02_JPRB,1.8764E+02_JPRB,1.2511E+02_JPRB,6.2998E+01_JPRB,4.9660E+01_JPRB/)
KBO( :, 3,23,16) = (/&
&3.1595E+02_JPRB,2.3698E+02_JPRB,1.5800E+02_JPRB,7.9029E+01_JPRB,4.8927E+01_JPRB/)
KBO( :, 4,23,16) = (/&
&3.8628E+02_JPRB,2.8972E+02_JPRB,1.9317E+02_JPRB,9.6612E+01_JPRB,4.8034E+01_JPRB/)
KBO( :, 5,23,16) = (/&
&4.5926E+02_JPRB,3.4446E+02_JPRB,2.2966E+02_JPRB,1.1486E+02_JPRB,4.7018E+01_JPRB/)
KBO( :, 1,24,16) = (/&
&2.2153E+02_JPRB,1.6616E+02_JPRB,1.1079E+02_JPRB,5.9590E+01_JPRB,5.8418E+01_JPRB/)
KBO( :, 2,24,16) = (/&
&2.8858E+02_JPRB,2.1645E+02_JPRB,1.4432E+02_JPRB,7.2964E+01_JPRB,5.7353E+01_JPRB/)
KBO( :, 3,24,16) = (/&
&3.6176E+02_JPRB,2.7134E+02_JPRB,1.8091E+02_JPRB,9.0484E+01_JPRB,5.6191E+01_JPRB/)
KBO( :, 4,24,16) = (/&
&4.3913E+02_JPRB,3.2936E+02_JPRB,2.1959E+02_JPRB,1.0983E+02_JPRB,5.4899E+01_JPRB/)
KBO( :, 5,24,16) = (/&
&5.1871E+02_JPRB,3.8905E+02_JPRB,2.5939E+02_JPRB,1.2972E+02_JPRB,5.3493E+01_JPRB/)
KBO( :, 1,25,16) = (/&
&2.5592E+02_JPRB,1.9195E+02_JPRB,1.2799E+02_JPRB,6.9505E+01_JPRB,6.6958E+01_JPRB/)
KBO( :, 2,25,16) = (/&
&3.3021E+02_JPRB,2.4767E+02_JPRB,1.6513E+02_JPRB,8.3805E+01_JPRB,6.5388E+01_JPRB/)
KBO( :, 3,25,16) = (/&
&4.1034E+02_JPRB,3.0777E+02_JPRB,2.0520E+02_JPRB,1.0263E+02_JPRB,6.3684E+01_JPRB/)
KBO( :, 4,25,16) = (/&
&4.9407E+02_JPRB,3.7057E+02_JPRB,2.4706E+02_JPRB,1.2356E+02_JPRB,6.1889E+01_JPRB/)
KBO( :, 5,25,16) = (/&
&5.7945E+02_JPRB,4.3460E+02_JPRB,2.8975E+02_JPRB,1.4490E+02_JPRB,6.0007E+01_JPRB/)
KBO( :, 1,26,16) = (/&
&2.9375E+02_JPRB,2.2033E+02_JPRB,1.4690E+02_JPRB,8.0244E+01_JPRB,7.5657E+01_JPRB/)
KBO( :, 2,26,16) = (/&
&3.7482E+02_JPRB,2.8113E+02_JPRB,1.8744E+02_JPRB,9.5627E+01_JPRB,7.3427E+01_JPRB/)
KBO( :, 3,26,16) = (/&
&4.6126E+02_JPRB,3.4596E+02_JPRB,2.3065E+02_JPRB,1.1546E+02_JPRB,7.1104E+01_JPRB/)
KBO( :, 4,26,16) = (/&
&5.5138E+02_JPRB,4.1354E+02_JPRB,2.7571E+02_JPRB,1.3788E+02_JPRB,6.8732E+01_JPRB/)
KBO( :, 5,26,16) = (/&
&6.4282E+02_JPRB,4.8213E+02_JPRB,3.2143E+02_JPRB,1.6074E+02_JPRB,6.6296E+01_JPRB/)
KBO( :, 1,27,16) = (/&
&3.3321E+02_JPRB,2.4992E+02_JPRB,1.6663E+02_JPRB,9.1366E+01_JPRB,8.4138E+01_JPRB/)
KBO( :, 2,27,16) = (/&
&4.2092E+02_JPRB,3.1570E+02_JPRB,2.1048E+02_JPRB,1.0786E+02_JPRB,8.1216E+01_JPRB/)
KBO( :, 3,27,16) = (/&
&5.1399E+02_JPRB,3.8550E+02_JPRB,2.5701E+02_JPRB,1.2862E+02_JPRB,7.8186E+01_JPRB/)
KBO( :, 4,27,16) = (/&
&6.0988E+02_JPRB,4.5742E+02_JPRB,3.0496E+02_JPRB,1.5250E+02_JPRB,7.5179E+01_JPRB/)
KBO( :, 5,27,16) = (/&
&7.0613E+02_JPRB,5.2960E+02_JPRB,3.5308E+02_JPRB,1.7656E+02_JPRB,7.2191E+01_JPRB/)
KBO( :, 1,28,16) = (/&
&3.7433E+02_JPRB,2.8075E+02_JPRB,1.8718E+02_JPRB,1.0259E+02_JPRB,9.2146E+01_JPRB/)
KBO( :, 2,28,16) = (/&
&4.6847E+02_JPRB,3.5136E+02_JPRB,2.3425E+02_JPRB,1.2023E+02_JPRB,8.8477E+01_JPRB/)
KBO( :, 3,28,16) = (/&
&5.6719E+02_JPRB,4.2540E+02_JPRB,2.8361E+02_JPRB,1.4204E+02_JPRB,8.4711E+01_JPRB/)
KBO( :, 4,28,16) = (/&
&6.6805E+02_JPRB,5.0105E+02_JPRB,3.3404E+02_JPRB,1.6704E+02_JPRB,8.1058E+01_JPRB/)
KBO( :, 5,28,16) = (/&
&7.6861E+02_JPRB,5.7647E+02_JPRB,3.8432E+02_JPRB,1.9217E+02_JPRB,7.7535E+01_JPRB/)
KBO( :, 1,29,16) = (/&
&4.1725E+02_JPRB,3.1294E+02_JPRB,2.0864E+02_JPRB,1.1391E+02_JPRB,9.9444E+01_JPRB/)
KBO( :, 2,29,16) = (/&
&5.1701E+02_JPRB,3.8777E+02_JPRB,2.5852E+02_JPRB,1.3257E+02_JPRB,9.4950E+01_JPRB/)
KBO( :, 3,29,16) = (/&
&6.2080E+02_JPRB,4.6561E+02_JPRB,3.1041E+02_JPRB,1.5542E+02_JPRB,9.0532E+01_JPRB/)
KBO( :, 4,29,16) = (/&
&7.2558E+02_JPRB,5.4419E+02_JPRB,3.6280E+02_JPRB,1.8141E+02_JPRB,8.6254E+01_JPRB/)
KBO( :, 5,29,16) = (/&
&8.2901E+02_JPRB,6.2176E+02_JPRB,4.1451E+02_JPRB,2.0727E+02_JPRB,8.2152E+01_JPRB/)
KBO( :, 1,30,16) = (/&
&4.6074E+02_JPRB,3.4556E+02_JPRB,2.3038E+02_JPRB,1.2510E+02_JPRB,1.0583E+02_JPRB/)
KBO( :, 2,30,16) = (/&
&5.6540E+02_JPRB,4.2406E+02_JPRB,2.8271E+02_JPRB,1.4464E+02_JPRB,1.0057E+02_JPRB/)
KBO( :, 3,30,16) = (/&
&6.7286E+02_JPRB,5.0465E+02_JPRB,3.3644E+02_JPRB,1.6852E+02_JPRB,9.5505E+01_JPRB/)
KBO( :, 4,30,16) = (/&
&7.8088E+02_JPRB,5.8566E+02_JPRB,3.9045E+02_JPRB,1.9523E+02_JPRB,9.0661E+01_JPRB/)
KBO( :, 5,30,16) = (/&
&8.8686E+02_JPRB,6.6515E+02_JPRB,4.4344E+02_JPRB,2.2173E+02_JPRB,8.6036E+01_JPRB/)
KBO( :, 1,31,16) = (/&
&5.0472E+02_JPRB,3.7854E+02_JPRB,2.5237E+02_JPRB,1.3614E+02_JPRB,1.1117E+02_JPRB/)
KBO( :, 2,31,16) = (/&
&6.1339E+02_JPRB,4.6004E+02_JPRB,3.0670E+02_JPRB,1.5661E+02_JPRB,1.0529E+02_JPRB/)
KBO( :, 3,31,16) = (/&
&7.2433E+02_JPRB,5.4325E+02_JPRB,3.6217E+02_JPRB,1.8144E+02_JPRB,9.9591E+01_JPRB/)
KBO( :, 4,31,16) = (/&
&8.3504E+02_JPRB,6.2629E+02_JPRB,4.1753E+02_JPRB,2.0877E+02_JPRB,9.4229E+01_JPRB/)
KBO( :, 5,31,16) = (/&
&9.4280E+02_JPRB,7.0711E+02_JPRB,4.7141E+02_JPRB,2.3571E+02_JPRB,8.9176E+01_JPRB/)
KBO( :, 1,32,16) = (/&
&5.4855E+02_JPRB,4.1142E+02_JPRB,2.7428E+02_JPRB,1.4676E+02_JPRB,1.1548E+02_JPRB/)
KBO( :, 2,32,16) = (/&
&6.6091E+02_JPRB,4.9568E+02_JPRB,3.3046E+02_JPRB,1.6826E+02_JPRB,1.0901E+02_JPRB/)
KBO( :, 3,32,16) = (/&
&7.7477E+02_JPRB,5.8108E+02_JPRB,3.8739E+02_JPRB,1.9388E+02_JPRB,1.0281E+02_JPRB/)
KBO( :, 4,32,16) = (/&
&8.8730E+02_JPRB,6.6548E+02_JPRB,4.4366E+02_JPRB,2.2183E+02_JPRB,9.7004E+01_JPRB/)
KBO( :, 5,32,16) = (/&
&9.9594E+02_JPRB,7.4695E+02_JPRB,4.9797E+02_JPRB,2.4899E+02_JPRB,9.1601E+01_JPRB/)
KBO( :, 1,33,16) = (/&
&5.9242E+02_JPRB,4.4432E+02_JPRB,2.9622E+02_JPRB,1.5694E+02_JPRB,1.1883E+02_JPRB/)
KBO( :, 2,33,16) = (/&
&7.0777E+02_JPRB,5.3083E+02_JPRB,3.5389E+02_JPRB,1.7956E+02_JPRB,1.1183E+02_JPRB/)
KBO( :, 3,33,16) = (/&
&8.2358E+02_JPRB,6.1768E+02_JPRB,4.1179E+02_JPRB,2.0591E+02_JPRB,1.0524E+02_JPRB/)
KBO( :, 4,33,16) = (/&
&9.3713E+02_JPRB,7.0285E+02_JPRB,4.6857E+02_JPRB,2.3429E+02_JPRB,9.9066E+01_JPRB/)
KBO( :, 5,33,16) = (/&
&1.0459E+03_JPRB,7.8446E+02_JPRB,5.2297E+02_JPRB,2.6149E+02_JPRB,9.3354E+01_JPRB/)
KBO( :, 1,34,16) = (/&
&6.3153E+02_JPRB,4.7365E+02_JPRB,3.1577E+02_JPRB,1.6595E+02_JPRB,1.2152E+02_JPRB/)
KBO( :, 2,34,16) = (/&
&7.4904E+02_JPRB,5.6178E+02_JPRB,3.7452E+02_JPRB,1.8952E+02_JPRB,1.1409E+02_JPRB/)
KBO( :, 3,34,16) = (/&
&8.6625E+02_JPRB,6.4969E+02_JPRB,4.3313E+02_JPRB,2.1657E+02_JPRB,1.0714E+02_JPRB/)
KBO( :, 4,34,16) = (/&
&9.8045E+02_JPRB,7.3534E+02_JPRB,4.9023E+02_JPRB,2.4512E+02_JPRB,1.0070E+02_JPRB/)
KBO( :, 5,34,16) = (/&
&1.0897E+03_JPRB,8.1726E+02_JPRB,5.4484E+02_JPRB,2.7243E+02_JPRB,9.4730E+01_JPRB/)
KBO( :, 1,35,16) = (/&
&6.5821E+02_JPRB,4.9366E+02_JPRB,3.2911E+02_JPRB,1.7240E+02_JPRB,1.2419E+02_JPRB/)
KBO( :, 2,35,16) = (/&
&7.7728E+02_JPRB,5.8296E+02_JPRB,3.8864E+02_JPRB,1.9649E+02_JPRB,1.1638E+02_JPRB/)
KBO( :, 3,35,16) = (/&
&8.9594E+02_JPRB,6.7196E+02_JPRB,4.4797E+02_JPRB,2.2399E+02_JPRB,1.0909E+02_JPRB/)
KBO( :, 4,35,16) = (/&
&1.0109E+03_JPRB,7.5821E+02_JPRB,5.0548E+02_JPRB,2.5274E+02_JPRB,1.0239E+02_JPRB/)
KBO( :, 5,35,16) = (/&
&1.1199E+03_JPRB,8.3992E+02_JPRB,5.5995E+02_JPRB,2.7998E+02_JPRB,9.6183E+01_JPRB/)
KBO( :, 1,36,16) = (/&
&6.7059E+02_JPRB,5.0294E+02_JPRB,3.3530E+02_JPRB,1.7604E+02_JPRB,1.2715E+02_JPRB/)
KBO( :, 2,36,16) = (/&
&7.9094E+02_JPRB,5.9320E+02_JPRB,3.9547E+02_JPRB,2.0012E+02_JPRB,1.1897E+02_JPRB/)
KBO( :, 3,36,16) = (/&
&9.1055E+02_JPRB,6.8291E+02_JPRB,4.5528E+02_JPRB,2.2764E+02_JPRB,1.1135E+02_JPRB/)
KBO( :, 4,36,16) = (/&
&1.0266E+03_JPRB,7.6996E+02_JPRB,5.1331E+02_JPRB,2.5666E+02_JPRB,1.0436E+02_JPRB/)
KBO( :, 5,36,16) = (/&
&1.1363E+03_JPRB,8.5221E+02_JPRB,5.6814E+02_JPRB,2.8407E+02_JPRB,9.7934E+01_JPRB/)
KBO( :, 1,37,16) = (/&
&6.6319E+02_JPRB,4.9740E+02_JPRB,3.3160E+02_JPRB,1.7601E+02_JPRB,1.3096E+02_JPRB/)
KBO( :, 2,37,16) = (/&
&7.8424E+02_JPRB,5.8818E+02_JPRB,3.9212E+02_JPRB,1.9937E+02_JPRB,1.2236E+02_JPRB/)
KBO( :, 3,37,16) = (/&
&9.0524E+02_JPRB,6.7893E+02_JPRB,4.5262E+02_JPRB,2.2635E+02_JPRB,1.1439E+02_JPRB/)
KBO( :, 4,37,16) = (/&
&1.0226E+03_JPRB,7.6693E+02_JPRB,5.1129E+02_JPRB,2.5565E+02_JPRB,1.0707E+02_JPRB/)
KBO( :, 5,37,16) = (/&
&1.1340E+03_JPRB,8.5053E+02_JPRB,5.6702E+02_JPRB,2.8351E+02_JPRB,1.0033E+02_JPRB/)
KBO( :, 1,38,16) = (/&
&6.5328E+02_JPRB,4.8996E+02_JPRB,3.2664E+02_JPRB,1.7551E+02_JPRB,1.3460E+02_JPRB/)
KBO( :, 2,38,16) = (/&
&7.7497E+02_JPRB,5.8123E+02_JPRB,3.8749E+02_JPRB,1.9811E+02_JPRB,1.2556E+02_JPRB/)
KBO( :, 3,38,16) = (/&
&8.9678E+02_JPRB,6.7259E+02_JPRB,4.4839E+02_JPRB,2.2452E+02_JPRB,1.1726E+02_JPRB/)
KBO( :, 4,38,16) = (/&
&1.0156E+03_JPRB,7.6168E+02_JPRB,5.0779E+02_JPRB,2.5390E+02_JPRB,1.0960E+02_JPRB/)
KBO( :, 5,38,16) = (/&
&1.1289E+03_JPRB,8.4669E+02_JPRB,5.6446E+02_JPRB,2.8223E+02_JPRB,1.0262E+02_JPRB/)
KBO( :, 1,39,16) = (/&
&6.4257E+02_JPRB,4.8193E+02_JPRB,3.2129E+02_JPRB,1.7479E+02_JPRB,1.3792E+02_JPRB/)
KBO( :, 2,39,16) = (/&
&7.6414E+02_JPRB,5.7310E+02_JPRB,3.8207E+02_JPRB,1.9654E+02_JPRB,1.2851E+02_JPRB/)
KBO( :, 3,39,16) = (/&
&8.8664E+02_JPRB,6.6498E+02_JPRB,4.4332E+02_JPRB,2.2243E+02_JPRB,1.1989E+02_JPRB/)
KBO( :, 4,39,16) = (/&
&1.0066E+03_JPRB,7.5495E+02_JPRB,5.0330E+02_JPRB,2.5165E+02_JPRB,1.1192E+02_JPRB/)
KBO( :, 5,39,16) = (/&
&1.1211E+03_JPRB,8.4084E+02_JPRB,5.6056E+02_JPRB,2.8028E+02_JPRB,1.0470E+02_JPRB/)
KBO( :, 1,40,16) = (/&
&6.1808E+02_JPRB,4.6356E+02_JPRB,3.0904E+02_JPRB,1.7192E+02_JPRB,1.4210E+02_JPRB/)
KBO( :, 2,40,16) = (/&
&7.3974E+02_JPRB,5.5481E+02_JPRB,3.6987E+02_JPRB,1.9237E+02_JPRB,1.3221E+02_JPRB/)
KBO( :, 3,40,16) = (/&
&8.6274E+02_JPRB,6.4706E+02_JPRB,4.3137E+02_JPRB,2.1745E+02_JPRB,1.2321E+02_JPRB/)
KBO( :, 4,40,16) = (/&
&9.8377E+02_JPRB,7.3783E+02_JPRB,4.9189E+02_JPRB,2.4594E+02_JPRB,1.1493E+02_JPRB/)
KBO( :, 5,40,16) = (/&
&1.1003E+03_JPRB,8.2526E+02_JPRB,5.5018E+02_JPRB,2.7509E+02_JPRB,1.0740E+02_JPRB/)
KBO( :, 1,41,16) = (/&
&5.9120E+02_JPRB,4.4340E+02_JPRB,2.9560E+02_JPRB,1.6877E+02_JPRB,1.4632E+02_JPRB/)
KBO( :, 2,41,16) = (/&
&7.1268E+02_JPRB,5.3451E+02_JPRB,3.5634E+02_JPRB,1.8787E+02_JPRB,1.3592E+02_JPRB/)
KBO( :, 3,41,16) = (/&
&8.3597E+02_JPRB,6.2698E+02_JPRB,4.1798E+02_JPRB,2.1205E+02_JPRB,1.2655E+02_JPRB/)
KBO( :, 4,41,16) = (/&
&9.5842E+02_JPRB,7.1882E+02_JPRB,4.7921E+02_JPRB,2.3967E+02_JPRB,1.1795E+02_JPRB/)
KBO( :, 5,41,16) = (/&
&1.0766E+03_JPRB,8.0748E+02_JPRB,5.3832E+02_JPRB,2.6916E+02_JPRB,1.1013E+02_JPRB/)
KBO( :, 1,42,16) = (/&
&5.6381E+02_JPRB,4.2287E+02_JPRB,2.8192E+02_JPRB,1.6586E+02_JPRB,1.5054E+02_JPRB/)
KBO( :, 2,42,16) = (/&
&6.8496E+02_JPRB,5.1372E+02_JPRB,3.4248E+02_JPRB,1.8375E+02_JPRB,1.3960E+02_JPRB/)
KBO( :, 3,42,16) = (/&
&8.0821E+02_JPRB,6.0616E+02_JPRB,4.0411E+02_JPRB,2.0657E+02_JPRB,1.2981E+02_JPRB/)
KBO( :, 4,42,16) = (/&
&9.3135E+02_JPRB,6.9851E+02_JPRB,4.6567E+02_JPRB,2.3323E+02_JPRB,1.2093E+02_JPRB/)
KBO( :, 5,42,16) = (/&
&1.0512E+03_JPRB,7.8842E+02_JPRB,5.2562E+02_JPRB,2.6281E+02_JPRB,1.1278E+02_JPRB/)
KBO( :, 1,43,16) = (/&
&5.2955E+02_JPRB,3.9717E+02_JPRB,2.6480E+02_JPRB,1.6239E+02_JPRB,1.5543E+02_JPRB/)
KBO( :, 2,43,16) = (/&
&6.4929E+02_JPRB,4.8697E+02_JPRB,3.2465E+02_JPRB,1.7863E+02_JPRB,1.4384E+02_JPRB/)
KBO( :, 3,43,16) = (/&
&7.7272E+02_JPRB,5.7954E+02_JPRB,3.8636E+02_JPRB,1.9990E+02_JPRB,1.3363E+02_JPRB/)
KBO( :, 4,43,16) = (/&
&8.9638E+02_JPRB,6.7229E+02_JPRB,4.4819E+02_JPRB,2.2542E+02_JPRB,1.2436E+02_JPRB/)
KBO( :, 5,43,16) = (/&
&1.0176E+03_JPRB,7.6322E+02_JPRB,5.0881E+02_JPRB,2.5441E+02_JPRB,1.1585E+02_JPRB/)
KBO( :, 1,44,16) = (/&
&4.9226E+02_JPRB,3.6921E+02_JPRB,2.4618E+02_JPRB,1.5919E+02_JPRB,1.6071E+02_JPRB/)
KBO( :, 2,44,16) = (/&
&6.1049E+02_JPRB,4.5787E+02_JPRB,3.0525E+02_JPRB,1.7333E+02_JPRB,1.4841E+02_JPRB/)
KBO( :, 3,44,16) = (/&
&7.3319E+02_JPRB,5.4989E+02_JPRB,3.6660E+02_JPRB,1.9274E+02_JPRB,1.3765E+02_JPRB/)
KBO( :, 4,44,16) = (/&
&8.5738E+02_JPRB,6.4303E+02_JPRB,4.2869E+02_JPRB,2.1719E+02_JPRB,1.2801E+02_JPRB/)
KBO( :, 5,44,16) = (/&
&9.7980E+02_JPRB,7.3485E+02_JPRB,4.8990E+02_JPRB,2.4500E+02_JPRB,1.1918E+02_JPRB/)
KBO( :, 1,45,16) = (/&
&4.5538E+02_JPRB,3.4155E+02_JPRB,2.2854E+02_JPRB,1.5641E+02_JPRB,1.6609E+02_JPRB/)
KBO( :, 2,45,16) = (/&
&5.7191E+02_JPRB,4.2894E+02_JPRB,2.8597E+02_JPRB,1.6860E+02_JPRB,1.5314E+02_JPRB/)
KBO( :, 3,45,16) = (/&
&6.9342E+02_JPRB,5.2007E+02_JPRB,3.4671E+02_JPRB,1.8629E+02_JPRB,1.4178E+02_JPRB/)
KBO( :, 4,45,16) = (/&
&8.1734E+02_JPRB,6.1301E+02_JPRB,4.0867E+02_JPRB,2.0907E+02_JPRB,1.3172E+02_JPRB/)
KBO( :, 5,45,16) = (/&
&9.4113E+02_JPRB,7.0584E+02_JPRB,4.7056E+02_JPRB,2.3576E+02_JPRB,1.2254E+02_JPRB/)
KBO( :, 1,46,16) = (/&
&4.1669E+02_JPRB,3.1253E+02_JPRB,2.1183E+02_JPRB,1.5432E+02_JPRB,1.7199E+02_JPRB/)
KBO( :, 2,46,16) = (/&
&5.3032E+02_JPRB,3.9775E+02_JPRB,2.6519E+02_JPRB,1.6403E+02_JPRB,1.5825E+02_JPRB/)
KBO( :, 3,46,16) = (/&
&6.5084E+02_JPRB,4.8813E+02_JPRB,3.2542E+02_JPRB,1.7998E+02_JPRB,1.4624E+02_JPRB/)
KBO( :, 4,46,16) = (/&
&7.7453E+02_JPRB,5.8090E+02_JPRB,3.8727E+02_JPRB,2.0089E+02_JPRB,1.3568E+02_JPRB/)
KBO( :, 5,46,16) = (/&
&8.9886E+02_JPRB,6.7414E+02_JPRB,4.4943E+02_JPRB,2.2628E+02_JPRB,1.2618E+02_JPRB/)
KBO( :, 1,47,16) = (/&
&3.7428E+02_JPRB,2.8073E+02_JPRB,1.9464E+02_JPRB,1.5283E+02_JPRB,1.7876E+02_JPRB/)
KBO( :, 2,47,16) = (/&
&4.8479E+02_JPRB,3.6362E+02_JPRB,2.4253E+02_JPRB,1.5990E+02_JPRB,1.6413E+02_JPRB/)
KBO( :, 3,47,16) = (/&
&6.0294E+02_JPRB,4.5221E+02_JPRB,3.0147E+02_JPRB,1.7328E+02_JPRB,1.5134E+02_JPRB/)
KBO( :, 4,47,16) = (/&
&7.2591E+02_JPRB,5.4443E+02_JPRB,3.6295E+02_JPRB,1.9215E+02_JPRB,1.4020E+02_JPRB/)
KBO( :, 5,47,16) = (/&
&8.5037E+02_JPRB,6.3778E+02_JPRB,4.2518E+02_JPRB,2.1607E+02_JPRB,1.3023E+02_JPRB/)
KBO( :, 1,48,16) = (/&
&3.3349E+02_JPRB,2.5014E+02_JPRB,1.7970E+02_JPRB,1.5302E+02_JPRB,1.8591E+02_JPRB/)
KBO( :, 2,48,16) = (/&
&4.4002E+02_JPRB,3.3004E+02_JPRB,2.2195E+02_JPRB,1.5666E+02_JPRB,1.7030E+02_JPRB/)
KBO( :, 3,48,16) = (/&
&5.5563E+02_JPRB,4.1673E+02_JPRB,2.7783E+02_JPRB,1.6752E+02_JPRB,1.5672E+02_JPRB/)
KBO( :, 4,48,16) = (/&
&6.7724E+02_JPRB,5.0793E+02_JPRB,3.3862E+02_JPRB,1.8443E+02_JPRB,1.4489E+02_JPRB/)
KBO( :, 5,48,16) = (/&
&8.0113E+02_JPRB,6.0085E+02_JPRB,4.0056E+02_JPRB,2.0627E+02_JPRB,1.3444E+02_JPRB/)
KBO( :, 1,49,16) = (/&
&2.9450E+02_JPRB,2.2091E+02_JPRB,1.6633E+02_JPRB,1.5392E+02_JPRB,1.9354E+02_JPRB/)
KBO( :, 2,49,16) = (/&
&3.9655E+02_JPRB,2.9743E+02_JPRB,2.0370E+02_JPRB,1.5444E+02_JPRB,1.7673E+02_JPRB/)
KBO( :, 3,49,16) = (/&
&5.0897E+02_JPRB,3.8174E+02_JPRB,2.5452E+02_JPRB,1.6274E+02_JPRB,1.6236E+02_JPRB/)
KBO( :, 4,49,16) = (/&
&6.2857E+02_JPRB,4.7143E+02_JPRB,3.1428E+02_JPRB,1.7731E+02_JPRB,1.4974E+02_JPRB/)
KBO( :, 5,49,16) = (/&
&7.5222E+02_JPRB,5.6417E+02_JPRB,3.7611E+02_JPRB,1.9706E+02_JPRB,1.3876E+02_JPRB/)
KBO( :, 1,50,16) = (/&
&2.5985E+02_JPRB,1.9491E+02_JPRB,1.5586E+02_JPRB,1.5616E+02_JPRB,2.0113E+02_JPRB/)
KBO( :, 2,50,16) = (/&
&3.5704E+02_JPRB,2.6780E+02_JPRB,1.8851E+02_JPRB,1.5379E+02_JPRB,1.8310E+02_JPRB/)
KBO( :, 3,50,16) = (/&
&4.6618E+02_JPRB,3.4965E+02_JPRB,2.3374E+02_JPRB,1.5907E+02_JPRB,1.6786E+02_JPRB/)
KBO( :, 4,50,16) = (/&
&5.8341E+02_JPRB,4.3757E+02_JPRB,2.9172E+02_JPRB,1.7138E+02_JPRB,1.5459E+02_JPRB/)
KBO( :, 5,50,16) = (/&
&7.0619E+02_JPRB,5.2964E+02_JPRB,3.5310E+02_JPRB,1.8927E+02_JPRB,1.4300E+02_JPRB/)
KBO( :, 1,51,16) = (/&
&2.2810E+02_JPRB,1.7111E+02_JPRB,1.4781E+02_JPRB,1.5986E+02_JPRB,2.0899E+02_JPRB/)
KBO( :, 2,51,16) = (/&
&3.2034E+02_JPRB,2.4028E+02_JPRB,1.7546E+02_JPRB,1.5410E+02_JPRB,1.8970E+02_JPRB/)
KBO( :, 3,51,16) = (/&
&4.2561E+02_JPRB,3.1923E+02_JPRB,2.1599E+02_JPRB,1.5649E+02_JPRB,1.7346E+02_JPRB/)
KBO( :, 4,51,16) = (/&
&5.4039E+02_JPRB,4.0531E+02_JPRB,2.7023E+02_JPRB,1.6638E+02_JPRB,1.5946E+02_JPRB/)
KBO( :, 5,51,16) = (/&
&6.6162E+02_JPRB,4.9621E+02_JPRB,3.3081E+02_JPRB,1.8245E+02_JPRB,1.4725E+02_JPRB/)
KBO( :, 1,52,16) = (/&
&1.9828E+02_JPRB,1.4993E+02_JPRB,1.4119E+02_JPRB,1.6436E+02_JPRB,2.1740E+02_JPRB/)
KBO( :, 2,52,16) = (/&
&2.8540E+02_JPRB,2.1407E+02_JPRB,1.6382E+02_JPRB,1.5520E+02_JPRB,1.9665E+02_JPRB/)
KBO( :, 3,52,16) = (/&
&3.8626E+02_JPRB,2.8971E+02_JPRB,1.9981E+02_JPRB,1.5468E+02_JPRB,1.7935E+02_JPRB/)
KBO( :, 4,52,16) = (/&
&4.9804E+02_JPRB,3.7355E+02_JPRB,2.4908E+02_JPRB,1.6225E+02_JPRB,1.6458E+02_JPRB/)
KBO( :, 5,52,16) = (/&
&6.1718E+02_JPRB,4.6289E+02_JPRB,3.0859E+02_JPRB,1.7607E+02_JPRB,1.5168E+02_JPRB/)
KBO( :, 1,53,16) = (/&
&1.7053E+02_JPRB,1.3271E+02_JPRB,1.3636E+02_JPRB,1.6986E+02_JPRB,2.2630E+02_JPRB/)
KBO( :, 2,53,16) = (/&
&2.5204E+02_JPRB,1.8906E+02_JPRB,1.5417E+02_JPRB,1.5767E+02_JPRB,2.0404E+02_JPRB/)
KBO( :, 3,53,16) = (/&
&3.4819E+02_JPRB,2.6116E+02_JPRB,1.8555E+02_JPRB,1.5442E+02_JPRB,1.8552E+02_JPRB/)
KBO( :, 4,53,16) = (/&
&4.5652E+02_JPRB,3.4241E+02_JPRB,2.2942E+02_JPRB,1.5882E+02_JPRB,1.6992E+02_JPRB/)
KBO( :, 5,53,16) = (/&
&5.7327E+02_JPRB,4.2996E+02_JPRB,2.8665E+02_JPRB,1.7045E+02_JPRB,1.5636E+02_JPRB/)
KBO( :, 1,54,16) = (/&
&1.4705E+02_JPRB,1.1956E+02_JPRB,1.3416E+02_JPRB,1.7624E+02_JPRB,2.3498E+02_JPRB/)
KBO( :, 2,54,16) = (/&
&2.2318E+02_JPRB,1.6747E+02_JPRB,1.4694E+02_JPRB,1.6122E+02_JPRB,2.1126E+02_JPRB/)
KBO( :, 3,54,16) = (/&
&3.1471E+02_JPRB,2.3606E+02_JPRB,1.7373E+02_JPRB,1.5475E+02_JPRB,1.9160E+02_JPRB/)
KBO( :, 4,54,16) = (/&
&4.1929E+02_JPRB,3.1449E+02_JPRB,2.1344E+02_JPRB,1.5657E+02_JPRB,1.7506E+02_JPRB/)
KBO( :, 5,54,16) = (/&
&5.3373E+02_JPRB,4.0031E+02_JPRB,2.6690E+02_JPRB,1.6597E+02_JPRB,1.6083E+02_JPRB/)
KBO( :, 1,55,16) = (/&
&1.2631E+02_JPRB,1.0869E+02_JPRB,1.3316E+02_JPRB,1.8286E+02_JPRB,2.4381E+02_JPRB/)
KBO( :, 2,55,16) = (/&
&1.9709E+02_JPRB,1.4921E+02_JPRB,1.4131E+02_JPRB,1.6522E+02_JPRB,2.1865E+02_JPRB/)
KBO( :, 3,55,16) = (/&
&2.8395E+02_JPRB,2.1299E+02_JPRB,1.6360E+02_JPRB,1.5579E+02_JPRB,1.9769E+02_JPRB/)
KBO( :, 4,55,16) = (/&
&3.8466E+02_JPRB,2.8852E+02_JPRB,1.9931E+02_JPRB,1.5501E+02_JPRB,1.8019E+02_JPRB/)
KBO( :, 5,55,16) = (/&
&4.9642E+02_JPRB,3.7233E+02_JPRB,2.4828E+02_JPRB,1.6238E+02_JPRB,1.6531E+02_JPRB/)
KBO( :, 1,56,16) = (/&
&1.0745E+02_JPRB,1.0001E+02_JPRB,1.3351E+02_JPRB,1.8985E+02_JPRB,2.5313E+02_JPRB/)
KBO( :, 2,56,16) = (/&
&1.7263E+02_JPRB,1.3401E+02_JPRB,1.3702E+02_JPRB,1.6999E+02_JPRB,2.2638E+02_JPRB/)
KBO( :, 3,56,16) = (/&
&2.5461E+02_JPRB,1.9098E+02_JPRB,1.5506E+02_JPRB,1.5788E+02_JPRB,2.0410E+02_JPRB/)
KBO( :, 4,56,16) = (/&
&3.5127E+02_JPRB,2.6347E+02_JPRB,1.8679E+02_JPRB,1.5477E+02_JPRB,1.8556E+02_JPRB/)
KBO( :, 5,56,16) = (/&
&4.5985E+02_JPRB,3.4491E+02_JPRB,2.3096E+02_JPRB,1.5935E+02_JPRB,1.6993E+02_JPRB/)
KBO( :, 1,57,16) = (/&
&9.0369E+01_JPRB,9.3013E+01_JPRB,1.3545E+02_JPRB,1.9732E+02_JPRB,2.6309E+02_JPRB/)
KBO( :, 2,57,16) = (/&
&1.4993E+02_JPRB,1.2125E+02_JPRB,1.3471E+02_JPRB,1.7593E+02_JPRB,2.3457E+02_JPRB/)
KBO( :, 3,57,16) = (/&
&2.2676E+02_JPRB,1.7012E+02_JPRB,1.4804E+02_JPRB,1.6118E+02_JPRB,2.1092E+02_JPRB/)
KBO( :, 4,57,16) = (/&
&3.1896E+02_JPRB,2.3925E+02_JPRB,1.7532E+02_JPRB,1.5501E+02_JPRB,1.9130E+02_JPRB/)
KBO( :, 5,57,16) = (/&
&4.2411E+02_JPRB,3.1810E+02_JPRB,2.1552E+02_JPRB,1.5708E+02_JPRB,1.7479E+02_JPRB/)
KBO( :, 1,58,16) = (/&
&7.5798E+01_JPRB,8.7968E+01_JPRB,1.3839E+02_JPRB,2.0486E+02_JPRB,2.7315E+02_JPRB/)
KBO( :, 2,58,16) = (/&
&1.3002E+02_JPRB,1.1067E+02_JPRB,1.3357E+02_JPRB,1.8211E+02_JPRB,2.4282E+02_JPRB/)
KBO( :, 3,58,16) = (/&
&2.0177E+02_JPRB,1.5234E+02_JPRB,1.4243E+02_JPRB,1.6481E+02_JPRB,2.1780E+02_JPRB/)
KBO( :, 4,58,16) = (/&
&2.8967E+02_JPRB,2.1728E+02_JPRB,1.6554E+02_JPRB,1.5580E+02_JPRB,1.9696E+02_JPRB/)
KBO( :, 5,58,16) = (/&
&3.9118E+02_JPRB,2.9340E+02_JPRB,2.0194E+02_JPRB,1.5548E+02_JPRB,1.7957E+02_JPRB/)
KBO( :, 1,59,16) = (/&
&7.0427E+01_JPRB,8.6420E+01_JPRB,1.3992E+02_JPRB,2.0810E+02_JPRB,2.7747E+02_JPRB/)
KBO( :, 2,59,16) = (/&
&1.2257E+02_JPRB,1.0699E+02_JPRB,1.3342E+02_JPRB,1.8471E+02_JPRB,2.4629E+02_JPRB/)
KBO( :, 3,59,16) = (/&
&1.9225E+02_JPRB,1.4609E+02_JPRB,1.4061E+02_JPRB,1.6649E+02_JPRB,2.2067E+02_JPRB/)
KBO( :, 4,59,16) = (/&
&2.7820E+02_JPRB,2.0868E+02_JPRB,1.6196E+02_JPRB,1.5644E+02_JPRB,1.9936E+02_JPRB/)
KBO( :, 5,59,16) = (/&
&3.7829E+02_JPRB,2.8373E+02_JPRB,1.9693E+02_JPRB,1.5516E+02_JPRB,1.8158E+02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB5_B4
