!OCL SCALAR
SUBROUTINE RRTM_KGB5_B3

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, CCL4O
USE YOERRTA5 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KB contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of co2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 9) = (/&
&1.6103E-01_JPRB,6.6158E-01_JPRB,1.1273E+00_JPRB,1.5637E+00_JPRB,2.0193E+00_JPRB/)
KBO( :, 2,13, 9) = (/&
&2.3702E-01_JPRB,7.0502E-01_JPRB,1.1597E+00_JPRB,1.5650E+00_JPRB,1.9887E+00_JPRB/)
KBO( :, 3,13, 9) = (/&
&3.3165E-01_JPRB,7.5350E-01_JPRB,1.1971E+00_JPRB,1.5759E+00_JPRB,1.9602E+00_JPRB/)
KBO( :, 4,13, 9) = (/&
&4.4557E-01_JPRB,8.0998E-01_JPRB,1.2356E+00_JPRB,1.5909E+00_JPRB,1.9329E+00_JPRB/)
KBO( :, 5,13, 9) = (/&
&5.7859E-01_JPRB,8.7605E-01_JPRB,1.2746E+00_JPRB,1.6061E+00_JPRB,1.9056E+00_JPRB/)
KBO( :, 1,14, 9) = (/&
&1.4761E-01_JPRB,6.9347E-01_JPRB,1.1794E+00_JPRB,1.6262E+00_JPRB,2.0952E+00_JPRB/)
KBO( :, 2,14, 9) = (/&
&2.1664E-01_JPRB,7.3539E-01_JPRB,1.2185E+00_JPRB,1.6328E+00_JPRB,2.0656E+00_JPRB/)
KBO( :, 3,14, 9) = (/&
&3.0271E-01_JPRB,7.8091E-01_JPRB,1.2580E+00_JPRB,1.6489E+00_JPRB,2.0363E+00_JPRB/)
KBO( :, 4,14, 9) = (/&
&4.0599E-01_JPRB,8.3259E-01_JPRB,1.2961E+00_JPRB,1.6672E+00_JPRB,2.0067E+00_JPRB/)
KBO( :, 5,14, 9) = (/&
&5.2635E-01_JPRB,8.9136E-01_JPRB,1.3335E+00_JPRB,1.6865E+00_JPRB,1.9784E+00_JPRB/)
KBO( :, 1,15, 9) = (/&
&1.3457E-01_JPRB,7.2100E-01_JPRB,1.2219E+00_JPRB,1.6745E+00_JPRB,2.1504E+00_JPRB/)
KBO( :, 2,15, 9) = (/&
&1.9694E-01_JPRB,7.6310E-01_JPRB,1.2659E+00_JPRB,1.6872E+00_JPRB,2.1231E+00_JPRB/)
KBO( :, 3,15, 9) = (/&
&2.7439E-01_JPRB,8.0691E-01_JPRB,1.3081E+00_JPRB,1.7082E+00_JPRB,2.0944E+00_JPRB/)
KBO( :, 4,15, 9) = (/&
&3.6719E-01_JPRB,8.5456E-01_JPRB,1.3474E+00_JPRB,1.7304E+00_JPRB,2.0661E+00_JPRB/)
KBO( :, 5,15, 9) = (/&
&4.7561E-01_JPRB,9.0769E-01_JPRB,1.3846E+00_JPRB,1.7533E+00_JPRB,2.0378E+00_JPRB/)
KBO( :, 1,16, 9) = (/&
&1.2205E-01_JPRB,7.4077E-01_JPRB,1.2541E+00_JPRB,1.7073E+00_JPRB,2.1827E+00_JPRB/)
KBO( :, 2,16, 9) = (/&
&1.7791E-01_JPRB,7.8396E-01_JPRB,1.3002E+00_JPRB,1.7270E+00_JPRB,2.1581E+00_JPRB/)
KBO( :, 3,16, 9) = (/&
&2.4715E-01_JPRB,8.2834E-01_JPRB,1.3436E+00_JPRB,1.7521E+00_JPRB,2.1327E+00_JPRB/)
KBO( :, 4,16, 9) = (/&
&3.3034E-01_JPRB,8.7418E-01_JPRB,1.3847E+00_JPRB,1.7782E+00_JPRB,2.1067E+00_JPRB/)
KBO( :, 5,16, 9) = (/&
&4.2786E-01_JPRB,9.2279E-01_JPRB,1.4244E+00_JPRB,1.8037E+00_JPRB,2.0808E+00_JPRB/)
KBO( :, 1,17, 9) = (/&
&1.0982E-01_JPRB,7.5143E-01_JPRB,1.2725E+00_JPRB,1.7242E+00_JPRB,2.1909E+00_JPRB/)
KBO( :, 2,17, 9) = (/&
&1.5953E-01_JPRB,7.9549E-01_JPRB,1.3193E+00_JPRB,1.7501E+00_JPRB,2.1703E+00_JPRB/)
KBO( :, 3,17, 9) = (/&
&2.2127E-01_JPRB,8.4054E-01_JPRB,1.3636E+00_JPRB,1.7793E+00_JPRB,2.1486E+00_JPRB/)
KBO( :, 4,17, 9) = (/&
&2.9584E-01_JPRB,8.8682E-01_JPRB,1.4059E+00_JPRB,1.8091E+00_JPRB,2.1266E+00_JPRB/)
KBO( :, 5,17, 9) = (/&
&3.8385E-01_JPRB,9.3422E-01_JPRB,1.4466E+00_JPRB,1.8364E+00_JPRB,2.1039E+00_JPRB/)
KBO( :, 1,18, 9) = (/&
&9.8329E-02_JPRB,7.5240E-01_JPRB,1.2756E+00_JPRB,1.7244E+00_JPRB,2.1757E+00_JPRB/)
KBO( :, 2,18, 9) = (/&
&1.4251E-01_JPRB,7.9706E-01_JPRB,1.3228E+00_JPRB,1.7556E+00_JPRB,2.1597E+00_JPRB/)
KBO( :, 3,18, 9) = (/&
&1.9773E-01_JPRB,8.4264E-01_JPRB,1.3673E+00_JPRB,1.7888E+00_JPRB,2.1427E+00_JPRB/)
KBO( :, 4,18, 9) = (/&
&2.6482E-01_JPRB,8.8901E-01_JPRB,1.4101E+00_JPRB,1.8204E+00_JPRB,2.1245E+00_JPRB/)
KBO( :, 5,18, 9) = (/&
&3.4448E-01_JPRB,9.3666E-01_JPRB,1.4514E+00_JPRB,1.8483E+00_JPRB,2.1059E+00_JPRB/)
KBO( :, 1,19, 9) = (/&
&8.7815E-02_JPRB,7.4384E-01_JPRB,1.2637E+00_JPRB,1.7067E+00_JPRB,2.1362E+00_JPRB/)
KBO( :, 2,19, 9) = (/&
&1.2725E-01_JPRB,7.8828E-01_JPRB,1.3102E+00_JPRB,1.7428E+00_JPRB,2.1257E+00_JPRB/)
KBO( :, 3,19, 9) = (/&
&1.7679E-01_JPRB,8.3379E-01_JPRB,1.3547E+00_JPRB,1.7786E+00_JPRB,2.1135E+00_JPRB/)
KBO( :, 4,19, 9) = (/&
&2.3728E-01_JPRB,8.8010E-01_JPRB,1.3977E+00_JPRB,1.8108E+00_JPRB,2.0991E+00_JPRB/)
KBO( :, 5,19, 9) = (/&
&3.0895E-01_JPRB,9.2824E-01_JPRB,1.4393E+00_JPRB,1.8391E+00_JPRB,2.0837E+00_JPRB/)
KBO( :, 1,20, 9) = (/&
&7.9041E-02_JPRB,7.2700E-01_JPRB,1.2374E+00_JPRB,1.6719E+00_JPRB,2.0747E+00_JPRB/)
KBO( :, 2,20, 9) = (/&
&1.1454E-01_JPRB,7.7070E-01_JPRB,1.2831E+00_JPRB,1.7109E+00_JPRB,2.0685E+00_JPRB/)
KBO( :, 3,20, 9) = (/&
&1.5930E-01_JPRB,8.1568E-01_JPRB,1.3273E+00_JPRB,1.7472E+00_JPRB,2.0604E+00_JPRB/)
KBO( :, 4,20, 9) = (/&
&2.1376E-01_JPRB,8.6194E-01_JPRB,1.3702E+00_JPRB,1.7799E+00_JPRB,2.0509E+00_JPRB/)
KBO( :, 5,20, 9) = (/&
&2.7842E-01_JPRB,9.1045E-01_JPRB,1.4124E+00_JPRB,1.8091E+00_JPRB,2.0408E+00_JPRB/)
KBO( :, 1,21, 9) = (/&
&7.1445E-02_JPRB,7.0244E-01_JPRB,1.1970E+00_JPRB,1.6199E+00_JPRB,1.9923E+00_JPRB/)
KBO( :, 2,21, 9) = (/&
&1.0353E-01_JPRB,7.4522E-01_JPRB,1.2418E+00_JPRB,1.6596E+00_JPRB,1.9909E+00_JPRB/)
KBO( :, 3,21, 9) = (/&
&1.4384E-01_JPRB,7.8934E-01_JPRB,1.2854E+00_JPRB,1.6962E+00_JPRB,1.9875E+00_JPRB/)
KBO( :, 4,21, 9) = (/&
&1.9307E-01_JPRB,8.3547E-01_JPRB,1.3286E+00_JPRB,1.7297E+00_JPRB,1.9830E+00_JPRB/)
KBO( :, 5,21, 9) = (/&
&2.5151E-01_JPRB,8.8443E-01_JPRB,1.3716E+00_JPRB,1.7608E+00_JPRB,1.9785E+00_JPRB/)
KBO( :, 1,22, 9) = (/&
&6.6536E-02_JPRB,6.7362E-01_JPRB,1.1476E+00_JPRB,1.5553E+00_JPRB,1.8930E+00_JPRB/)
KBO( :, 2,22, 9) = (/&
&9.5961E-02_JPRB,7.1546E-01_JPRB,1.1915E+00_JPRB,1.5946E+00_JPRB,1.8960E+00_JPRB/)
KBO( :, 3,22, 9) = (/&
&1.3293E-01_JPRB,7.5906E-01_JPRB,1.2350E+00_JPRB,1.6314E+00_JPRB,1.8977E+00_JPRB/)
KBO( :, 4,22, 9) = (/&
&1.7791E-01_JPRB,8.0536E-01_JPRB,1.2788E+00_JPRB,1.6663E+00_JPRB,1.8991E+00_JPRB/)
KBO( :, 5,22, 9) = (/&
&2.3124E-01_JPRB,8.5502E-01_JPRB,1.3230E+00_JPRB,1.6998E+00_JPRB,1.9008E+00_JPRB/)
KBO( :, 1,23, 9) = (/&
&6.2130E-02_JPRB,6.3989E-01_JPRB,1.0889E+00_JPRB,1.4764E+00_JPRB,1.7800E+00_JPRB/)
KBO( :, 2,23, 9) = (/&
&8.9203E-02_JPRB,6.8080E-01_JPRB,1.1324E+00_JPRB,1.5163E+00_JPRB,1.7885E+00_JPRB/)
KBO( :, 3,23, 9) = (/&
&1.2310E-01_JPRB,7.2420E-01_JPRB,1.1763E+00_JPRB,1.5547E+00_JPRB,1.7963E+00_JPRB/)
KBO( :, 4,23, 9) = (/&
&1.6423E-01_JPRB,7.7098E-01_JPRB,1.2210E+00_JPRB,1.5918E+00_JPRB,1.8040E+00_JPRB/)
KBO( :, 5,23, 9) = (/&
&2.1277E-01_JPRB,8.2154E-01_JPRB,1.2673E+00_JPRB,1.6285E+00_JPRB,1.8132E+00_JPRB/)
KBO( :, 1,24, 9) = (/&
&5.8273E-02_JPRB,6.0306E-01_JPRB,1.0238E+00_JPRB,1.3884E+00_JPRB,1.6590E+00_JPRB/)
KBO( :, 2,24, 9) = (/&
&8.3232E-02_JPRB,6.4338E-01_JPRB,1.0676E+00_JPRB,1.4297E+00_JPRB,1.6731E+00_JPRB/)
KBO( :, 3,24, 9) = (/&
&1.1427E-01_JPRB,6.8692E-01_JPRB,1.1126E+00_JPRB,1.4703E+00_JPRB,1.6874E+00_JPRB/)
KBO( :, 4,24, 9) = (/&
&1.5163E-01_JPRB,7.3448E-01_JPRB,1.1591E+00_JPRB,1.5108E+00_JPRB,1.7035E+00_JPRB/)
KBO( :, 5,24, 9) = (/&
&1.9552E-01_JPRB,7.8610E-01_JPRB,1.2077E+00_JPRB,1.5519E+00_JPRB,1.7219E+00_JPRB/)
KBO( :, 1,25, 9) = (/&
&5.4812E-02_JPRB,5.6477E-01_JPRB,9.5569E-01_JPRB,1.2954E+00_JPRB,1.5347E+00_JPRB/)
KBO( :, 2,25, 9) = (/&
&7.7748E-02_JPRB,6.0521E-01_JPRB,1.0005E+00_JPRB,1.3386E+00_JPRB,1.5551E+00_JPRB/)
KBO( :, 3,25, 9) = (/&
&1.0600E-01_JPRB,6.4947E-01_JPRB,1.0471E+00_JPRB,1.3828E+00_JPRB,1.5779E+00_JPRB/)
KBO( :, 4,25, 9) = (/&
&1.3990E-01_JPRB,6.9799E-01_JPRB,1.0963E+00_JPRB,1.4282E+00_JPRB,1.6034E+00_JPRB/)
KBO( :, 5,25, 9) = (/&
&1.7983E-01_JPRB,7.5057E-01_JPRB,1.1486E+00_JPRB,1.4751E+00_JPRB,1.6307E+00_JPRB/)
KBO( :, 1,26, 9) = (/&
&5.1716E-02_JPRB,5.2713E-01_JPRB,8.8788E-01_JPRB,1.2018E+00_JPRB,1.4126E+00_JPRB/)
KBO( :, 2,26, 9) = (/&
&7.2684E-02_JPRB,5.6826E-01_JPRB,9.3427E-01_JPRB,1.2488E+00_JPRB,1.4411E+00_JPRB/)
KBO( :, 3,26, 9) = (/&
&9.8449E-02_JPRB,6.1372E-01_JPRB,9.8375E-01_JPRB,1.2977E+00_JPRB,1.4727E+00_JPRB/)
KBO( :, 4,26, 9) = (/&
&1.2939E-01_JPRB,6.6352E-01_JPRB,1.0365E+00_JPRB,1.3486E+00_JPRB,1.5064E+00_JPRB/)
KBO( :, 5,26, 9) = (/&
&1.6591E-01_JPRB,7.1727E-01_JPRB,1.0930E+00_JPRB,1.4010E+00_JPRB,1.5406E+00_JPRB/)
KBO( :, 1,27, 9) = (/&
&4.8584E-02_JPRB,4.9097E-01_JPRB,8.2256E-01_JPRB,1.1121E+00_JPRB,1.2977E+00_JPRB/)
KBO( :, 2,27, 9) = (/&
&6.7759E-02_JPRB,5.3335E-01_JPRB,8.7159E-01_JPRB,1.1633E+00_JPRB,1.3342E+00_JPRB/)
KBO( :, 3,27, 9) = (/&
&9.1281E-02_JPRB,5.8032E-01_JPRB,9.2435E-01_JPRB,1.2172E+00_JPRB,1.3733E+00_JPRB/)
KBO( :, 4,27, 9) = (/&
&1.1958E-01_JPRB,6.3161E-01_JPRB,9.8117E-01_JPRB,1.2730E+00_JPRB,1.4135E+00_JPRB/)
KBO( :, 5,27, 9) = (/&
&1.5306E-01_JPRB,6.8640E-01_JPRB,1.0413E+00_JPRB,1.3298E+00_JPRB,1.4532E+00_JPRB/)
KBO( :, 1,28, 9) = (/&
&4.5513E-02_JPRB,4.5771E-01_JPRB,7.6221E-01_JPRB,1.0285E+00_JPRB,1.1920E+00_JPRB/)
KBO( :, 2,28, 9) = (/&
&6.3043E-02_JPRB,5.0158E-01_JPRB,8.1400E-01_JPRB,1.0840E+00_JPRB,1.2355E+00_JPRB/)
KBO( :, 3,28, 9) = (/&
&8.4577E-02_JPRB,5.5008E-01_JPRB,8.7020E-01_JPRB,1.1421E+00_JPRB,1.2807E+00_JPRB/)
KBO( :, 4,28, 9) = (/&
&1.1056E-01_JPRB,6.0266E-01_JPRB,9.3037E-01_JPRB,1.2019E+00_JPRB,1.3261E+00_JPRB/)
KBO( :, 5,28, 9) = (/&
&1.4146E-01_JPRB,6.5861E-01_JPRB,9.9361E-01_JPRB,1.2630E+00_JPRB,1.3707E+00_JPRB/)
KBO( :, 1,29, 9) = (/&
&4.2634E-02_JPRB,4.2840E-01_JPRB,7.0804E-01_JPRB,9.5295E-01_JPRB,1.0976E+00_JPRB/)
KBO( :, 2,29, 9) = (/&
&5.8749E-02_JPRB,4.7373E-01_JPRB,7.6274E-01_JPRB,1.0122E+00_JPRB,1.1466E+00_JPRB/)
KBO( :, 3,29, 9) = (/&
&7.8594E-02_JPRB,5.2372E-01_JPRB,8.2196E-01_JPRB,1.0740E+00_JPRB,1.1968E+00_JPRB/)
KBO( :, 4,29, 9) = (/&
&1.0258E-01_JPRB,5.7741E-01_JPRB,8.8498E-01_JPRB,1.1377E+00_JPRB,1.2469E+00_JPRB/)
KBO( :, 5,29, 9) = (/&
&1.3125E-01_JPRB,6.3414E-01_JPRB,9.5133E-01_JPRB,1.2027E+00_JPRB,1.2962E+00_JPRB/)
KBO( :, 1,30, 9) = (/&
&3.9899E-02_JPRB,4.0291E-01_JPRB,6.6036E-01_JPRB,8.8584E-01_JPRB,1.0137E+00_JPRB/)
KBO( :, 2,30, 9) = (/&
&5.4774E-02_JPRB,4.4971E-01_JPRB,7.1779E-01_JPRB,9.4836E-01_JPRB,1.0674E+00_JPRB/)
KBO( :, 3,30, 9) = (/&
&7.3108E-02_JPRB,5.0075E-01_JPRB,7.7974E-01_JPRB,1.0137E+00_JPRB,1.1221E+00_JPRB/)
KBO( :, 4,30, 9) = (/&
&9.5439E-02_JPRB,5.5545E-01_JPRB,8.4558E-01_JPRB,1.0809E+00_JPRB,1.1769E+00_JPRB/)
KBO( :, 5,30, 9) = (/&
&1.2214E-01_JPRB,6.1274E-01_JPRB,9.1443E-01_JPRB,1.1496E+00_JPRB,1.2307E+00_JPRB/)
KBO( :, 1,31, 9) = (/&
&3.7399E-02_JPRB,3.8153E-01_JPRB,6.1964E-01_JPRB,8.2749E-01_JPRB,9.4112E-01_JPRB/)
KBO( :, 2,31, 9) = (/&
&5.1170E-02_JPRB,4.2947E-01_JPRB,6.7967E-01_JPRB,8.9330E-01_JPRB,9.9936E-01_JPRB/)
KBO( :, 3,31, 9) = (/&
&6.8267E-02_JPRB,4.8157E-01_JPRB,7.4418E-01_JPRB,9.6186E-01_JPRB,1.0590E+00_JPRB/)
KBO( :, 4,31, 9) = (/&
&8.9119E-02_JPRB,5.3688E-01_JPRB,8.1247E-01_JPRB,1.0326E+00_JPRB,1.1185E+00_JPRB/)
KBO( :, 5,31, 9) = (/&
&1.1420E-01_JPRB,5.9468E-01_JPRB,8.8352E-01_JPRB,1.1045E+00_JPRB,1.1767E+00_JPRB/)
KBO( :, 1,32, 9) = (/&
&3.5118E-02_JPRB,3.6406E-01_JPRB,5.8571E-01_JPRB,7.7819E-01_JPRB,8.7995E-01_JPRB/)
KBO( :, 2,32, 9) = (/&
&4.7970E-02_JPRB,4.1299E-01_JPRB,6.4823E-01_JPRB,8.4697E-01_JPRB,9.4296E-01_JPRB/)
KBO( :, 3,32, 9) = (/&
&6.4004E-02_JPRB,4.6590E-01_JPRB,7.1516E-01_JPRB,9.1892E-01_JPRB,1.0071E+00_JPRB/)
KBO( :, 4,32, 9) = (/&
&8.3615E-02_JPRB,5.2189E-01_JPRB,7.8583E-01_JPRB,9.9290E-01_JPRB,1.0709E+00_JPRB/)
KBO( :, 5,32, 9) = (/&
&1.0720E-01_JPRB,5.8002E-01_JPRB,8.5872E-01_JPRB,1.0680E+00_JPRB,1.1336E+00_JPRB/)
KBO( :, 1,33, 9) = (/&
&3.3077E-02_JPRB,3.5017E-01_JPRB,5.5838E-01_JPRB,7.3762E-01_JPRB,8.3032E-01_JPRB/)
KBO( :, 2,33, 9) = (/&
&4.5163E-02_JPRB,4.0001E-01_JPRB,6.2312E-01_JPRB,8.0956E-01_JPRB,8.9776E-01_JPRB/)
KBO( :, 3,33, 9) = (/&
&6.0263E-02_JPRB,4.5365E-01_JPRB,6.9243E-01_JPRB,8.8459E-01_JPRB,9.6617E-01_JPRB/)
KBO( :, 4,33, 9) = (/&
&7.8793E-02_JPRB,5.1005E-01_JPRB,7.6498E-01_JPRB,9.6177E-01_JPRB,1.0343E+00_JPRB/)
KBO( :, 5,33, 9) = (/&
&1.0108E-01_JPRB,5.6875E-01_JPRB,8.3998E-01_JPRB,1.0396E+00_JPRB,1.1011E+00_JPRB/)
KBO( :, 1,34, 9) = (/&
&3.0915E-02_JPRB,3.3781E-01_JPRB,5.3486E-01_JPRB,7.0304E-01_JPRB,7.8832E-01_JPRB/)
KBO( :, 2,34, 9) = (/&
&4.2252E-02_JPRB,3.8839E-01_JPRB,6.0166E-01_JPRB,7.7789E-01_JPRB,8.5967E-01_JPRB/)
KBO( :, 3,34, 9) = (/&
&5.6470E-02_JPRB,4.4255E-01_JPRB,6.7299E-01_JPRB,8.5584E-01_JPRB,9.3187E-01_JPRB/)
KBO( :, 4,34, 9) = (/&
&7.3896E-02_JPRB,4.9923E-01_JPRB,7.4727E-01_JPRB,9.3566E-01_JPRB,1.0039E+00_JPRB/)
KBO( :, 5,34, 9) = (/&
&9.5018E-02_JPRB,5.5848E-01_JPRB,8.2408E-01_JPRB,1.0160E+00_JPRB,1.0743E+00_JPRB/)
KBO( :, 1,35, 9) = (/&
&2.8132E-02_JPRB,3.2365E-01_JPRB,5.1055E-01_JPRB,6.6895E-01_JPRB,7.4864E-01_JPRB/)
KBO( :, 2,35, 9) = (/&
&3.8581E-02_JPRB,3.7456E-01_JPRB,5.7889E-01_JPRB,7.4628E-01_JPRB,8.2332E-01_JPRB/)
KBO( :, 3,35, 9) = (/&
&5.1721E-02_JPRB,4.2888E-01_JPRB,6.5160E-01_JPRB,8.2665E-01_JPRB,8.9938E-01_JPRB/)
KBO( :, 4,35, 9) = (/&
&6.7950E-02_JPRB,4.8574E-01_JPRB,7.2738E-01_JPRB,9.0865E-01_JPRB,9.7493E-01_JPRB/)
KBO( :, 5,35, 9) = (/&
&8.7661E-02_JPRB,5.4539E-01_JPRB,8.0566E-01_JPRB,9.9133E-01_JPRB,1.0487E+00_JPRB/)
KBO( :, 1,36, 9) = (/&
&2.4794E-02_JPRB,3.0684E-01_JPRB,4.8374E-01_JPRB,6.3315E-01_JPRB,7.0816E-01_JPRB/)
KBO( :, 2,36, 9) = (/&
&3.4216E-02_JPRB,3.5764E-01_JPRB,5.5293E-01_JPRB,7.1235E-01_JPRB,7.8609E-01_JPRB/)
KBO( :, 3,36, 9) = (/&
&4.6142E-02_JPRB,4.1180E-01_JPRB,6.2660E-01_JPRB,7.9449E-01_JPRB,8.6552E-01_JPRB/)
KBO( :, 4,36, 9) = (/&
&6.0983E-02_JPRB,4.6863E-01_JPRB,7.0343E-01_JPRB,8.7846E-01_JPRB,9.4446E-01_JPRB/)
KBO( :, 5,36, 9) = (/&
&7.9101E-02_JPRB,5.2833E-01_JPRB,7.8277E-01_JPRB,9.6328E-01_JPRB,1.0212E+00_JPRB/)
KBO( :, 1,37, 9) = (/&
&2.0815E-02_JPRB,2.8513E-01_JPRB,4.5081E-01_JPRB,5.9101E-01_JPRB,6.6164E-01_JPRB/)
KBO( :, 2,37, 9) = (/&
&2.9022E-02_JPRB,3.3521E-01_JPRB,5.2012E-01_JPRB,6.7125E-01_JPRB,7.4211E-01_JPRB/)
KBO( :, 3,37, 9) = (/&
&3.9516E-02_JPRB,3.8880E-01_JPRB,5.9400E-01_JPRB,7.5469E-01_JPRB,8.2434E-01_JPRB/)
KBO( :, 4,37, 9) = (/&
&5.2685E-02_JPRB,4.4520E-01_JPRB,6.7131E-01_JPRB,8.4030E-01_JPRB,9.0639E-01_JPRB/)
KBO( :, 5,37, 9) = (/&
&6.8908E-02_JPRB,5.0450E-01_JPRB,7.5128E-01_JPRB,9.2687E-01_JPRB,9.8613E-01_JPRB/)
KBO( :, 1,38, 9) = (/&
&1.7440E-02_JPRB,2.6532E-01_JPRB,4.2090E-01_JPRB,5.5282E-01_JPRB,6.1999E-01_JPRB/)
KBO( :, 2,38, 9) = (/&
&2.4585E-02_JPRB,3.1463E-01_JPRB,4.9010E-01_JPRB,6.3385E-01_JPRB,7.0267E-01_JPRB/)
KBO( :, 3,38, 9) = (/&
&3.3827E-02_JPRB,3.6763E-01_JPRB,5.6406E-01_JPRB,7.1841E-01_JPRB,7.8751E-01_JPRB/)
KBO( :, 4,38, 9) = (/&
&4.5497E-02_JPRB,4.2358E-01_JPRB,6.4172E-01_JPRB,8.0528E-01_JPRB,8.7233E-01_JPRB/)
KBO( :, 5,38, 9) = (/&
&6.0061E-02_JPRB,4.8245E-01_JPRB,7.2216E-01_JPRB,8.9334E-01_JPRB,9.5488E-01_JPRB/)
KBO( :, 1,39, 9) = (/&
&1.4635E-02_JPRB,2.4758E-01_JPRB,3.9422E-01_JPRB,5.1882E-01_JPRB,5.8346E-01_JPRB/)
KBO( :, 2,39, 9) = (/&
&2.0862E-02_JPRB,2.9613E-01_JPRB,4.6317E-01_JPRB,6.0043E-01_JPRB,6.6823E-01_JPRB/)
KBO( :, 3,39, 9) = (/&
&2.9010E-02_JPRB,3.4853E-01_JPRB,5.3715E-01_JPRB,6.8585E-01_JPRB,7.5543E-01_JPRB/)
KBO( :, 4,39, 9) = (/&
&3.9392E-02_JPRB,4.0402E-01_JPRB,6.1498E-01_JPRB,7.7375E-01_JPRB,8.4272E-01_JPRB/)
KBO( :, 5,39, 9) = (/&
&5.2487E-02_JPRB,4.6246E-01_JPRB,6.9574E-01_JPRB,8.6309E-01_JPRB,9.2808E-01_JPRB/)
KBO( :, 1,40, 9) = (/&
&1.1817E-02_JPRB,2.2703E-01_JPRB,3.6362E-01_JPRB,4.8024E-01_JPRB,5.4110E-01_JPRB/)
KBO( :, 2,40, 9) = (/&
&1.7093E-02_JPRB,2.7438E-01_JPRB,4.3164E-01_JPRB,5.6172E-01_JPRB,6.2692E-01_JPRB/)
KBO( :, 3,40, 9) = (/&
&2.4086E-02_JPRB,3.2578E-01_JPRB,5.0508E-01_JPRB,6.4747E-01_JPRB,7.1559E-01_JPRB/)
KBO( :, 4,40, 9) = (/&
&3.3120E-02_JPRB,3.8047E-01_JPRB,5.8258E-01_JPRB,7.3604E-01_JPRB,8.0488E-01_JPRB/)
KBO( :, 5,40, 9) = (/&
&4.4642E-02_JPRB,4.3816E-01_JPRB,6.6329E-01_JPRB,8.2630E-01_JPRB,8.9263E-01_JPRB/)
KBO( :, 1,41, 9) = (/&
&9.4732E-03_JPRB,2.0772E-01_JPRB,3.3472E-01_JPRB,4.4372E-01_JPRB,5.0098E-01_JPRB/)
KBO( :, 2,41, 9) = (/&
&1.3924E-02_JPRB,2.5378E-01_JPRB,4.0168E-01_JPRB,5.2481E-01_JPRB,5.8738E-01_JPRB/)
KBO( :, 3,41, 9) = (/&
&1.9893E-02_JPRB,3.0412E-01_JPRB,4.7431E-01_JPRB,6.1058E-01_JPRB,6.7711E-01_JPRB/)
KBO( :, 4,41, 9) = (/&
&2.7726E-02_JPRB,3.5790E-01_JPRB,5.5133E-01_JPRB,6.9954E-01_JPRB,7.6804E-01_JPRB/)
KBO( :, 5,41, 9) = (/&
&3.7835E-02_JPRB,4.1479E-01_JPRB,6.3183E-01_JPRB,7.9045E-01_JPRB,8.5793E-01_JPRB/)
KBO( :, 1,42, 9) = (/&
&7.5682E-03_JPRB,1.9007E-01_JPRB,3.0814E-01_JPRB,4.0997E-01_JPRB,4.6395E-01_JPRB/)
KBO( :, 2,42, 9) = (/&
&1.1315E-02_JPRB,2.3478E-01_JPRB,3.7386E-01_JPRB,4.9039E-01_JPRB,5.5062E-01_JPRB/)
KBO( :, 3,42, 9) = (/&
&1.6414E-02_JPRB,2.8401E-01_JPRB,4.4556E-01_JPRB,5.7596E-01_JPRB,6.4116E-01_JPRB/)
KBO( :, 4,42, 9) = (/&
&2.3189E-02_JPRB,3.3687E-01_JPRB,5.2199E-01_JPRB,6.6509E-01_JPRB,7.3350E-01_JPRB/)
KBO( :, 5,42, 9) = (/&
&3.2053E-02_JPRB,3.9299E-01_JPRB,6.0205E-01_JPRB,7.5646E-01_JPRB,8.2526E-01_JPRB/)
KBO( :, 1,43, 9) = (/&
&5.8792E-03_JPRB,1.7158E-01_JPRB,2.8021E-01_JPRB,3.7439E-01_JPRB,4.2476E-01_JPRB/)
KBO( :, 2,43, 9) = (/&
&8.9664E-03_JPRB,2.1465E-01_JPRB,3.4423E-01_JPRB,4.5359E-01_JPRB,5.1109E-01_JPRB/)
KBO( :, 3,43, 9) = (/&
&1.3239E-02_JPRB,2.6247E-01_JPRB,4.1451E-01_JPRB,5.3841E-01_JPRB,6.0195E-01_JPRB/)
KBO( :, 4,43, 9) = (/&
&1.8999E-02_JPRB,3.1420E-01_JPRB,4.8991E-01_JPRB,6.2734E-01_JPRB,6.9535E-01_JPRB/)
KBO( :, 5,43, 9) = (/&
&2.6643E-02_JPRB,3.6926E-01_JPRB,5.6925E-01_JPRB,7.1886E-01_JPRB,7.8877E-01_JPRB/)
KBO( :, 1,44, 9) = (/&
&4.4882E-03_JPRB,1.5364E-01_JPRB,2.5283E-01_JPRB,3.3925E-01_JPRB,3.8604E-01_JPRB/)
KBO( :, 2,44, 9) = (/&
&6.9936E-03_JPRB,1.9487E-01_JPRB,3.1482E-01_JPRB,4.1683E-01_JPRB,4.7142E-01_JPRB/)
KBO( :, 3,44, 9) = (/&
&1.0532E-02_JPRB,2.4110E-01_JPRB,3.8337E-01_JPRB,5.0055E-01_JPRB,5.6226E-01_JPRB/)
KBO( :, 4,44, 9) = (/&
&1.5385E-02_JPRB,2.9150E-01_JPRB,4.5750E-01_JPRB,5.8891E-01_JPRB,6.5637E-01_JPRB/)
KBO( :, 5,44, 9) = (/&
&2.1907E-02_JPRB,3.4545E-01_JPRB,5.3592E-01_JPRB,6.8023E-01_JPRB,7.5115E-01_JPRB/)
KBO( :, 1,45, 9) = (/&
&3.4023E-03_JPRB,1.3718E-01_JPRB,2.2742E-01_JPRB,3.0640E-01_JPRB,3.4986E-01_JPRB/)
KBO( :, 2,45, 9) = (/&
&5.4211E-03_JPRB,1.7648E-01_JPRB,2.8724E-01_JPRB,3.8210E-01_JPRB,4.3396E-01_JPRB/)
KBO( :, 3,45, 9) = (/&
&8.3344E-03_JPRB,2.2102E-01_JPRB,3.5390E-01_JPRB,4.6443E-01_JPRB,5.2448E-01_JPRB/)
KBO( :, 4,45, 9) = (/&
&1.2410E-02_JPRB,2.7007E-01_JPRB,4.2657E-01_JPRB,5.5186E-01_JPRB,6.1889E-01_JPRB/)
KBO( :, 5,45, 9) = (/&
&1.7962E-02_JPRB,3.2284E-01_JPRB,5.0389E-01_JPRB,6.4288E-01_JPRB,7.1489E-01_JPRB/)
KBO( :, 1,46, 9) = (/&
&2.5298E-03_JPRB,1.2128E-01_JPRB,2.0265E-01_JPRB,2.7417E-01_JPRB,3.1426E-01_JPRB/)
KBO( :, 2,46, 9) = (/&
&4.1311E-03_JPRB,1.5849E-01_JPRB,2.6002E-01_JPRB,3.4751E-01_JPRB,3.9644E-01_JPRB/)
KBO( :, 3,46, 9) = (/&
&6.4978E-03_JPRB,2.0122E-01_JPRB,3.2453E-01_JPRB,4.2805E-01_JPRB,4.8611E-01_JPRB/)
KBO( :, 4,46, 9) = (/&
&9.8756E-03_JPRB,2.4871E-01_JPRB,3.9537E-01_JPRB,5.1423E-01_JPRB,5.8048E-01_JPRB/)
KBO( :, 5,46, 9) = (/&
&1.4561E-02_JPRB,3.0016E-01_JPRB,4.7134E-01_JPRB,6.0463E-01_JPRB,6.7732E-01_JPRB/)
KBO( :, 1,47, 9) = (/&
&1.8212E-03_JPRB,1.0532E-01_JPRB,1.7755E-01_JPRB,2.4129E-01_JPRB,2.7755E-01_JPRB/)
KBO( :, 2,47, 9) = (/&
&3.0568E-03_JPRB,1.4024E-01_JPRB,2.3198E-01_JPRB,3.1155E-01_JPRB,3.5689E-01_JPRB/)
KBO( :, 3,47, 9) = (/&
&4.9310E-03_JPRB,1.8078E-01_JPRB,2.9385E-01_JPRB,3.8973E-01_JPRB,4.4482E-01_JPRB/)
KBO( :, 4,47, 9) = (/&
&7.6712E-03_JPRB,2.2639E-01_JPRB,3.6245E-01_JPRB,4.7424E-01_JPRB,5.3854E-01_JPRB/)
KBO( :, 5,47, 9) = (/&
&1.1548E-02_JPRB,2.7630E-01_JPRB,4.3672E-01_JPRB,5.6347E-01_JPRB,6.3559E-01_JPRB/)
KBO( :, 1,48, 9) = (/&
&1.2952E-03_JPRB,9.0848E-02_JPRB,1.5447E-01_JPRB,2.1078E-01_JPRB,2.4345E-01_JPRB/)
KBO( :, 2,48, 9) = (/&
&2.2372E-03_JPRB,1.2337E-01_JPRB,2.0574E-01_JPRB,2.7761E-01_JPRB,3.1960E-01_JPRB/)
KBO( :, 3,48, 9) = (/&
&3.7056E-03_JPRB,1.6164E-01_JPRB,2.6488E-01_JPRB,3.5315E-01_JPRB,4.0534E-01_JPRB/)
KBO( :, 4,48, 9) = (/&
&5.9066E-03_JPRB,2.0530E-01_JPRB,3.3102E-01_JPRB,4.3559E-01_JPRB,4.9804E-01_JPRB/)
KBO( :, 5,48, 9) = (/&
&9.0925E-03_JPRB,2.5355E-01_JPRB,4.0335E-01_JPRB,5.2339E-01_JPRB,5.9498E-01_JPRB/)
KBO( :, 1,49, 9) = (/&
&9.0858E-04_JPRB,7.7773E-02_JPRB,1.3333E-01_JPRB,1.8263E-01_JPRB,2.1203E-01_JPRB/)
KBO( :, 2,49, 9) = (/&
&1.6178E-03_JPRB,1.0781E-01_JPRB,1.8129E-01_JPRB,2.4570E-01_JPRB,2.8465E-01_JPRB/)
KBO( :, 3,49, 9) = (/&
&2.7562E-03_JPRB,1.4379E-01_JPRB,2.3752E-01_JPRB,3.1823E-01_JPRB,3.6781E-01_JPRB/)
KBO( :, 4,49, 9) = (/&
&4.5071E-03_JPRB,1.8535E-01_JPRB,3.0106E-01_JPRB,3.9831E-01_JPRB,4.5913E-01_JPRB/)
KBO( :, 5,49, 9) = (/&
&7.1028E-03_JPRB,2.3184E-01_JPRB,3.7117E-01_JPRB,4.8442E-01_JPRB,5.5577E-01_JPRB/)
KBO( :, 1,50, 9) = (/&
&6.3845E-04_JPRB,6.6632E-02_JPRB,1.1508E-01_JPRB,1.5813E-01_JPRB,1.8420E-01_JPRB/)
KBO( :, 2,50, 9) = (/&
&1.1723E-03_JPRB,9.4330E-02_JPRB,1.5988E-01_JPRB,2.1752E-01_JPRB,2.5295E-01_JPRB/)
KBO( :, 3,50, 9) = (/&
&2.0555E-03_JPRB,1.2813E-01_JPRB,2.1319E-01_JPRB,2.8686E-01_JPRB,3.3317E-01_JPRB/)
KBO( :, 4,50, 9) = (/&
&3.4507E-03_JPRB,1.6762E-01_JPRB,2.7419E-01_JPRB,3.6453E-01_JPRB,4.2252E-01_JPRB/)
KBO( :, 5,50, 9) = (/&
&5.5676E-03_JPRB,2.1233E-01_JPRB,3.4204E-01_JPRB,4.4881E-01_JPRB,5.1834E-01_JPRB/)
KBO( :, 1,51, 9) = (/&
&4.4606E-04_JPRB,5.6891E-02_JPRB,9.8867E-02_JPRB,1.3627E-01_JPRB,1.5911E-01_JPRB/)
KBO( :, 2,51, 9) = (/&
&8.4540E-04_JPRB,8.2329E-02_JPRB,1.4056E-01_JPRB,1.9187E-01_JPRB,2.2375E-01_JPRB/)
KBO( :, 3,51, 9) = (/&
&1.5266E-03_JPRB,1.1393E-01_JPRB,1.9092E-01_JPRB,2.5792E-01_JPRB,3.0065E-01_JPRB/)
KBO( :, 4,51, 9) = (/&
&2.6330E-03_JPRB,1.5136E-01_JPRB,2.4932E-01_JPRB,3.3298E-01_JPRB,3.8756E-01_JPRB/)
KBO( :, 5,51, 9) = (/&
&4.3537E-03_JPRB,1.9426E-01_JPRB,3.1486E-01_JPRB,4.1517E-01_JPRB,4.8205E-01_JPRB/)
KBO( :, 1,52, 9) = (/&
&3.0758E-04_JPRB,4.8172E-02_JPRB,8.4225E-02_JPRB,1.1640E-01_JPRB,1.3632E-01_JPRB/)
KBO( :, 2,52, 9) = (/&
&6.0273E-04_JPRB,7.1379E-02_JPRB,1.2274E-01_JPRB,1.6806E-01_JPRB,1.9667E-01_JPRB/)
KBO( :, 3,52, 9) = (/&
&1.1225E-03_JPRB,1.0074E-01_JPRB,1.7004E-01_JPRB,2.3059E-01_JPRB,2.6996E-01_JPRB/)
KBO( :, 4,52, 9) = (/&
&1.9908E-03_JPRB,1.3610E-01_JPRB,2.2571E-01_JPRB,3.0271E-01_JPRB,3.5416E-01_JPRB/)
KBO( :, 5,52, 9) = (/&
&3.3781E-03_JPRB,1.7706E-01_JPRB,2.8879E-01_JPRB,3.8263E-01_JPRB,4.4697E-01_JPRB/)
KBO( :, 1,53, 9) = (/&
&2.0907E-04_JPRB,4.0394E-02_JPRB,7.1019E-02_JPRB,9.8396E-02_JPRB,1.1571E-01_JPRB/)
KBO( :, 2,53, 9) = (/&
&4.2389E-04_JPRB,6.1427E-02_JPRB,1.0630E-01_JPRB,1.4598E-01_JPRB,1.7164E-01_JPRB/)
KBO( :, 3,53, 9) = (/&
&8.1536E-04_JPRB,8.8519E-02_JPRB,1.5049E-01_JPRB,2.0480E-01_JPRB,2.4110E-01_JPRB/)
KBO( :, 4,53, 9) = (/&
&1.4900E-03_JPRB,1.2174E-01_JPRB,2.0325E-01_JPRB,2.7370E-01_JPRB,3.2235E-01_JPRB/)
KBO( :, 5,53, 9) = (/&
&2.5972E-03_JPRB,1.6068E-01_JPRB,2.6380E-01_JPRB,3.5112E-01_JPRB,4.1323E-01_JPRB/)
KBO( :, 1,54, 9) = (/&
&1.4322E-04_JPRB,3.4010E-02_JPRB,6.0069E-02_JPRB,8.3407E-02_JPRB,9.8018E-02_JPRB/)
KBO( :, 2,54, 9) = (/&
&3.0073E-04_JPRB,5.3101E-02_JPRB,9.2377E-02_JPRB,1.2719E-01_JPRB,1.4939E-01_JPRB/)
KBO( :, 3,54, 9) = (/&
&5.9718E-04_JPRB,7.8129E-02_JPRB,1.3368E-01_JPRB,1.8244E-01_JPRB,2.1463E-01_JPRB/)
KBO( :, 4,54, 9) = (/&
&1.1241E-03_JPRB,1.0934E-01_JPRB,1.8368E-01_JPRB,2.4822E-01_JPRB,2.9238E-01_JPRB/)
KBO( :, 5,54, 9) = (/&
&2.0131E-03_JPRB,1.4639E-01_JPRB,2.4179E-01_JPRB,3.2314E-01_JPRB,3.8050E-01_JPRB/)
KBO( :, 1,55, 9) = (/&
&9.7902E-05_JPRB,2.8554E-02_JPRB,5.0642E-02_JPRB,7.0457E-02_JPRB,8.2500E-02_JPRB/)
KBO( :, 2,55, 9) = (/&
&2.1303E-04_JPRB,4.5829E-02_JPRB,8.0130E-02_JPRB,1.1056E-01_JPRB,1.2929E-01_JPRB/)
KBO( :, 3,55, 9) = (/&
&4.3705E-04_JPRB,6.8906E-02_JPRB,1.1861E-01_JPRB,1.6229E-01_JPRB,1.9004E-01_JPRB/)
KBO( :, 4,55, 9) = (/&
&8.4778E-04_JPRB,9.8145E-02_JPRB,1.6589E-01_JPRB,2.2492E-01_JPRB,2.6385E-01_JPRB/)
KBO( :, 5,55, 9) = (/&
&1.5604E-03_JPRB,1.3338E-01_JPRB,2.2157E-01_JPRB,2.9717E-01_JPRB,3.4860E-01_JPRB/)
KBO( :, 1,56, 9) = (/&
&6.5982E-05_JPRB,2.3749E-02_JPRB,4.2283E-02_JPRB,5.8930E-02_JPRB,6.8770E-02_JPRB/)
KBO( :, 2,56, 9) = (/&
&1.4918E-04_JPRB,3.9269E-02_JPRB,6.8966E-02_JPRB,9.5347E-02_JPRB,1.1107E-01_JPRB/)
KBO( :, 3,56, 9) = (/&
&3.1651E-04_JPRB,6.0448E-02_JPRB,1.0460E-01_JPRB,1.4348E-01_JPRB,1.6725E-01_JPRB/)
KBO( :, 4,56, 9) = (/&
&6.3389E-04_JPRB,8.7699E-02_JPRB,1.4915E-01_JPRB,2.0282E-01_JPRB,2.3679E-01_JPRB/)
KBO( :, 5,56, 9) = (/&
&1.2004E-03_JPRB,1.2107E-01_JPRB,2.0225E-01_JPRB,2.7220E-01_JPRB,3.1806E-01_JPRB/)
KBO( :, 1,57, 9) = (/&
&4.3767E-05_JPRB,1.9535E-02_JPRB,3.4912E-02_JPRB,4.8732E-02_JPRB,5.6673E-02_JPRB/)
KBO( :, 2,57, 9) = (/&
&1.0316E-04_JPRB,3.3365E-02_JPRB,5.8830E-02_JPRB,8.1501E-02_JPRB,9.4580E-02_JPRB/)
KBO( :, 3,57, 9) = (/&
&2.2677E-04_JPRB,5.2688E-02_JPRB,9.1608E-02_JPRB,1.2597E-01_JPRB,1.4616E-01_JPRB/)
KBO( :, 4,57, 9) = (/&
&4.6916E-04_JPRB,7.7962E-02_JPRB,1.3338E-01_JPRB,1.8187E-01_JPRB,2.1133E-01_JPRB/)
KBO( :, 5,57, 9) = (/&
&9.1588E-04_JPRB,1.0942E-01_JPRB,1.8382E-01_JPRB,2.4826E-01_JPRB,2.8886E-01_JPRB/)
KBO( :, 1,58, 9) = (/&
&2.9014E-05_JPRB,1.6044E-02_JPRB,2.8753E-02_JPRB,4.0190E-02_JPRB,4.6551E-02_JPRB/)
KBO( :, 2,58, 9) = (/&
&7.1292E-05_JPRB,2.8332E-02_JPRB,5.0135E-02_JPRB,6.9583E-02_JPRB,8.0381E-02_JPRB/)
KBO( :, 3,58, 9) = (/&
&1.6267E-04_JPRB,4.5930E-02_JPRB,8.0232E-02_JPRB,1.1053E-01_JPRB,1.2757E-01_JPRB/)
KBO( :, 4,58, 9) = (/&
&3.4791E-04_JPRB,6.9359E-02_JPRB,1.1932E-01_JPRB,1.6310E-01_JPRB,1.8840E-01_JPRB/)
KBO( :, 5,58, 9) = (/&
&7.0018E-04_JPRB,9.8967E-02_JPRB,1.6720E-01_JPRB,2.2650E-01_JPRB,2.6195E-01_JPRB/)
KBO( :, 1,59, 9) = (/&
&2.2635E-05_JPRB,1.4643E-02_JPRB,2.6255E-02_JPRB,3.6697E-02_JPRB,4.2048E-02_JPRB/)
KBO( :, 2,59, 9) = (/&
&5.7212E-05_JPRB,2.6338E-02_JPRB,4.6664E-02_JPRB,6.4796E-02_JPRB,7.3964E-02_JPRB/)
KBO( :, 3,59, 9) = (/&
&1.3405E-04_JPRB,4.3265E-02_JPRB,7.5702E-02_JPRB,1.0436E-01_JPRB,1.1887E-01_JPRB/)
KBO( :, 4,59, 9) = (/&
&2.9326E-04_JPRB,6.5970E-02_JPRB,1.1372E-01_JPRB,1.5558E-01_JPRB,1.7711E-01_JPRB/)
KBO( :, 5,59, 9) = (/&
&6.0242E-04_JPRB,9.4820E-02_JPRB,1.6057E-01_JPRB,2.1777E-01_JPRB,2.4787E-01_JPRB/)
KBO( :, 1,13,10) = (/&
&6.7750E-01_JPRB,1.1612E+00_JPRB,1.7683E+00_JPRB,2.4833E+00_JPRB,3.2280E+00_JPRB/)
KBO( :, 2,13,10) = (/&
&9.8868E-01_JPRB,1.3195E+00_JPRB,1.8430E+00_JPRB,2.4544E+00_JPRB,3.1587E+00_JPRB/)
KBO( :, 3,13,10) = (/&
&1.3619E+00_JPRB,1.5274E+00_JPRB,1.9406E+00_JPRB,2.4411E+00_JPRB,3.1000E+00_JPRB/)
KBO( :, 4,13,10) = (/&
&1.7899E+00_JPRB,1.7565E+00_JPRB,2.0793E+00_JPRB,2.4696E+00_JPRB,3.0494E+00_JPRB/)
KBO( :, 5,13,10) = (/&
&2.2734E+00_JPRB,2.0120E+00_JPRB,2.2415E+00_JPRB,2.5072E+00_JPRB,3.0022E+00_JPRB/)
KBO( :, 1,14,10) = (/&
&6.6134E-01_JPRB,1.2265E+00_JPRB,1.9371E+00_JPRB,2.7275E+00_JPRB,3.5435E+00_JPRB/)
KBO( :, 2,14,10) = (/&
&9.5434E-01_JPRB,1.3839E+00_JPRB,2.0016E+00_JPRB,2.7009E+00_JPRB,3.4774E+00_JPRB/)
KBO( :, 3,14,10) = (/&
&1.3032E+00_JPRB,1.5702E+00_JPRB,2.0959E+00_JPRB,2.6930E+00_JPRB,3.4197E+00_JPRB/)
KBO( :, 4,14,10) = (/&
&1.7103E+00_JPRB,1.7846E+00_JPRB,2.2135E+00_JPRB,2.7227E+00_JPRB,3.3624E+00_JPRB/)
KBO( :, 5,14,10) = (/&
&2.1701E+00_JPRB,2.0313E+00_JPRB,2.3489E+00_JPRB,2.7404E+00_JPRB,3.3020E+00_JPRB/)
KBO( :, 1,15,10) = (/&
&6.3051E-01_JPRB,1.3065E+00_JPRB,2.1302E+00_JPRB,2.9787E+00_JPRB,3.8647E+00_JPRB/)
KBO( :, 2,15,10) = (/&
&9.0166E-01_JPRB,1.4415E+00_JPRB,2.2062E+00_JPRB,2.9568E+00_JPRB,3.8040E+00_JPRB/)
KBO( :, 3,15,10) = (/&
&1.2283E+00_JPRB,1.6099E+00_JPRB,2.2945E+00_JPRB,2.9614E+00_JPRB,3.7464E+00_JPRB/)
KBO( :, 4,15,10) = (/&
&1.6076E+00_JPRB,1.8076E+00_JPRB,2.3898E+00_JPRB,2.9892E+00_JPRB,3.6813E+00_JPRB/)
KBO( :, 5,15,10) = (/&
&2.0350E+00_JPRB,2.0302E+00_JPRB,2.4952E+00_JPRB,3.0078E+00_JPRB,3.6149E+00_JPRB/)
KBO( :, 1,16,10) = (/&
&5.8908E-01_JPRB,1.4179E+00_JPRB,2.3250E+00_JPRB,3.2386E+00_JPRB,4.2028E+00_JPRB/)
KBO( :, 2,16,10) = (/&
&8.3922E-01_JPRB,1.5233E+00_JPRB,2.4132E+00_JPRB,3.2198E+00_JPRB,4.1391E+00_JPRB/)
KBO( :, 3,16,10) = (/&
&1.1390E+00_JPRB,1.6562E+00_JPRB,2.5083E+00_JPRB,3.2400E+00_JPRB,4.0764E+00_JPRB/)
KBO( :, 4,16,10) = (/&
&1.4867E+00_JPRB,1.8239E+00_JPRB,2.5939E+00_JPRB,3.2704E+00_JPRB,4.0090E+00_JPRB/)
KBO( :, 5,16,10) = (/&
&1.8763E+00_JPRB,2.0203E+00_JPRB,2.6728E+00_JPRB,3.3036E+00_JPRB,3.9360E+00_JPRB/)
KBO( :, 1,17,10) = (/&
&5.4248E-01_JPRB,1.5341E+00_JPRB,2.5200E+00_JPRB,3.4785E+00_JPRB,4.5198E+00_JPRB/)
KBO( :, 2,17,10) = (/&
&7.6928E-01_JPRB,1.6341E+00_JPRB,2.6202E+00_JPRB,3.4798E+00_JPRB,4.4583E+00_JPRB/)
KBO( :, 3,17,10) = (/&
&1.0404E+00_JPRB,1.7374E+00_JPRB,2.7194E+00_JPRB,3.5099E+00_JPRB,4.3924E+00_JPRB/)
KBO( :, 4,17,10) = (/&
&1.3522E+00_JPRB,1.8611E+00_JPRB,2.8021E+00_JPRB,3.5422E+00_JPRB,4.3166E+00_JPRB/)
KBO( :, 5,17,10) = (/&
&1.7001E+00_JPRB,2.0150E+00_JPRB,2.8795E+00_JPRB,3.5848E+00_JPRB,4.2409E+00_JPRB/)
KBO( :, 1,18,10) = (/&
&4.9348E-01_JPRB,1.6382E+00_JPRB,2.7119E+00_JPRB,3.6984E+00_JPRB,4.7971E+00_JPRB/)
KBO( :, 2,18,10) = (/&
&6.9669E-01_JPRB,1.7374E+00_JPRB,2.8139E+00_JPRB,3.7221E+00_JPRB,4.7361E+00_JPRB/)
KBO( :, 3,18,10) = (/&
&9.3760E-01_JPRB,1.8373E+00_JPRB,2.9117E+00_JPRB,3.7521E+00_JPRB,4.6633E+00_JPRB/)
KBO( :, 4,18,10) = (/&
&1.2130E+00_JPRB,1.9403E+00_JPRB,3.0001E+00_JPRB,3.7974E+00_JPRB,4.5895E+00_JPRB/)
KBO( :, 5,18,10) = (/&
&1.5215E+00_JPRB,2.0549E+00_JPRB,3.0821E+00_JPRB,3.8475E+00_JPRB,4.5159E+00_JPRB/)
KBO( :, 1,19,10) = (/&
&4.4294E-01_JPRB,1.7294E+00_JPRB,2.8772E+00_JPRB,3.8900E+00_JPRB,5.0246E+00_JPRB/)
KBO( :, 2,19,10) = (/&
&6.2191E-01_JPRB,1.8298E+00_JPRB,2.9845E+00_JPRB,3.9195E+00_JPRB,4.9572E+00_JPRB/)
KBO( :, 3,19,10) = (/&
&8.3280E-01_JPRB,1.9296E+00_JPRB,3.0814E+00_JPRB,3.9651E+00_JPRB,4.8890E+00_JPRB/)
KBO( :, 4,19,10) = (/&
&1.0758E+00_JPRB,2.0307E+00_JPRB,3.1709E+00_JPRB,4.0288E+00_JPRB,4.8272E+00_JPRB/)
KBO( :, 5,19,10) = (/&
&1.3553E+00_JPRB,2.1313E+00_JPRB,3.2530E+00_JPRB,4.0885E+00_JPRB,4.7625E+00_JPRB/)
KBO( :, 1,20,10) = (/&
&3.9571E-01_JPRB,1.8051E+00_JPRB,3.0095E+00_JPRB,4.0443E+00_JPRB,5.1864E+00_JPRB/)
KBO( :, 2,20,10) = (/&
&5.5188E-01_JPRB,1.9076E+00_JPRB,3.1223E+00_JPRB,4.0868E+00_JPRB,5.1320E+00_JPRB/)
KBO( :, 3,20,10) = (/&
&7.3749E-01_JPRB,2.0075E+00_JPRB,3.2244E+00_JPRB,4.1593E+00_JPRB,5.0769E+00_JPRB/)
KBO( :, 4,20,10) = (/&
&9.5721E-01_JPRB,2.1096E+00_JPRB,3.3164E+00_JPRB,4.2324E+00_JPRB,5.0165E+00_JPRB/)
KBO( :, 5,20,10) = (/&
&1.2100E+00_JPRB,2.2109E+00_JPRB,3.3994E+00_JPRB,4.2966E+00_JPRB,4.9507E+00_JPRB/)
KBO( :, 1,21,10) = (/&
&3.5072E-01_JPRB,1.8556E+00_JPRB,3.1080E+00_JPRB,4.1542E+00_JPRB,5.2872E+00_JPRB/)
KBO( :, 2,21,10) = (/&
&4.8766E-01_JPRB,1.9607E+00_JPRB,3.2231E+00_JPRB,4.2283E+00_JPRB,5.2442E+00_JPRB/)
KBO( :, 3,21,10) = (/&
&6.5440E-01_JPRB,2.0647E+00_JPRB,3.3316E+00_JPRB,4.3160E+00_JPRB,5.1977E+00_JPRB/)
KBO( :, 4,21,10) = (/&
&8.5123E-01_JPRB,2.1675E+00_JPRB,3.4268E+00_JPRB,4.3944E+00_JPRB,5.1446E+00_JPRB/)
KBO( :, 5,21,10) = (/&
&1.0760E+00_JPRB,2.2689E+00_JPRB,3.5139E+00_JPRB,4.4592E+00_JPRB,5.0861E+00_JPRB/)
KBO( :, 1,22,10) = (/&
&3.1704E-01_JPRB,1.8909E+00_JPRB,3.1718E+00_JPRB,4.2211E+00_JPRB,5.3188E+00_JPRB/)
KBO( :, 2,22,10) = (/&
&4.4113E-01_JPRB,1.9967E+00_JPRB,3.2921E+00_JPRB,4.3258E+00_JPRB,5.2898E+00_JPRB/)
KBO( :, 3,22,10) = (/&
&5.9182E-01_JPRB,2.1052E+00_JPRB,3.4006E+00_JPRB,4.4235E+00_JPRB,5.2566E+00_JPRB/)
KBO( :, 4,22,10) = (/&
&7.6857E-01_JPRB,2.2097E+00_JPRB,3.4994E+00_JPRB,4.5051E+00_JPRB,5.2176E+00_JPRB/)
KBO( :, 5,22,10) = (/&
&9.7285E-01_JPRB,2.3126E+00_JPRB,3.5927E+00_JPRB,4.5701E+00_JPRB,5.1722E+00_JPRB/)
KBO( :, 1,23,10) = (/&
&2.8927E-01_JPRB,1.9014E+00_JPRB,3.1969E+00_JPRB,4.2666E+00_JPRB,5.3040E+00_JPRB/)
KBO( :, 2,23,10) = (/&
&4.0191E-01_JPRB,2.0125E+00_JPRB,3.3191E+00_JPRB,4.3795E+00_JPRB,5.2890E+00_JPRB/)
KBO( :, 3,23,10) = (/&
&5.3783E-01_JPRB,2.1222E+00_JPRB,3.4289E+00_JPRB,4.4796E+00_JPRB,5.2663E+00_JPRB/)
KBO( :, 4,23,10) = (/&
&6.9875E-01_JPRB,2.2290E+00_JPRB,3.5339E+00_JPRB,4.5665E+00_JPRB,5.2397E+00_JPRB/)
KBO( :, 5,23,10) = (/&
&8.8602E-01_JPRB,2.3359E+00_JPRB,3.6321E+00_JPRB,4.6372E+00_JPRB,5.2101E+00_JPRB/)
KBO( :, 1,24,10) = (/&
&2.6648E-01_JPRB,1.8914E+00_JPRB,3.1927E+00_JPRB,4.2785E+00_JPRB,5.2470E+00_JPRB/)
KBO( :, 2,24,10) = (/&
&3.6872E-01_JPRB,2.0063E+00_JPRB,3.3129E+00_JPRB,4.3925E+00_JPRB,5.2443E+00_JPRB/)
KBO( :, 3,24,10) = (/&
&4.9335E-01_JPRB,2.1181E+00_JPRB,3.4275E+00_JPRB,4.4944E+00_JPRB,5.2358E+00_JPRB/)
KBO( :, 4,24,10) = (/&
&6.4237E-01_JPRB,2.2281E+00_JPRB,3.5391E+00_JPRB,4.5872E+00_JPRB,5.2224E+00_JPRB/)
KBO( :, 5,24,10) = (/&
&8.1853E-01_JPRB,2.3388E+00_JPRB,3.6424E+00_JPRB,4.6721E+00_JPRB,5.2057E+00_JPRB/)
KBO( :, 1,25,10) = (/&
&2.4735E-01_JPRB,1.8676E+00_JPRB,3.1644E+00_JPRB,4.2512E+00_JPRB,5.1457E+00_JPRB/)
KBO( :, 2,25,10) = (/&
&3.4172E-01_JPRB,1.9814E+00_JPRB,3.2839E+00_JPRB,4.3716E+00_JPRB,5.1625E+00_JPRB/)
KBO( :, 3,25,10) = (/&
&4.5795E-01_JPRB,2.0952E+00_JPRB,3.4036E+00_JPRB,4.4805E+00_JPRB,5.1730E+00_JPRB/)
KBO( :, 4,25,10) = (/&
&5.9795E-01_JPRB,2.2113E+00_JPRB,3.5208E+00_JPRB,4.5808E+00_JPRB,5.1736E+00_JPRB/)
KBO( :, 5,25,10) = (/&
&7.5984E-01_JPRB,2.3264E+00_JPRB,3.6336E+00_JPRB,4.6738E+00_JPRB,5.1743E+00_JPRB/)
KBO( :, 1,26,10) = (/&
&2.3360E-01_JPRB,1.8352E+00_JPRB,3.1131E+00_JPRB,4.1942E+00_JPRB,5.0148E+00_JPRB/)
KBO( :, 2,26,10) = (/&
&3.2286E-01_JPRB,1.9478E+00_JPRB,3.2410E+00_JPRB,4.3228E+00_JPRB,5.0531E+00_JPRB/)
KBO( :, 3,26,10) = (/&
&4.3204E-01_JPRB,2.0643E+00_JPRB,3.3666E+00_JPRB,4.4432E+00_JPRB,5.0819E+00_JPRB/)
KBO( :, 4,26,10) = (/&
&5.6016E-01_JPRB,2.1838E+00_JPRB,3.4889E+00_JPRB,4.5535E+00_JPRB,5.1063E+00_JPRB/)
KBO( :, 5,26,10) = (/&
&7.0753E-01_JPRB,2.3058E+00_JPRB,3.6092E+00_JPRB,4.6573E+00_JPRB,5.1261E+00_JPRB/)
KBO( :, 1,27,10) = (/&
&2.2294E-01_JPRB,1.7950E+00_JPRB,3.0495E+00_JPRB,4.1133E+00_JPRB,4.8609E+00_JPRB/)
KBO( :, 2,27,10) = (/&
&3.0707E-01_JPRB,1.9093E+00_JPRB,3.1862E+00_JPRB,4.2562E+00_JPRB,4.9227E+00_JPRB/)
KBO( :, 3,27,10) = (/&
&4.0769E-01_JPRB,2.0286E+00_JPRB,3.3192E+00_JPRB,4.3886E+00_JPRB,4.9781E+00_JPRB/)
KBO( :, 4,27,10) = (/&
&5.2517E-01_JPRB,2.1513E+00_JPRB,3.4485E+00_JPRB,4.5128E+00_JPRB,5.0272E+00_JPRB/)
KBO( :, 5,27,10) = (/&
&6.6106E-01_JPRB,2.2811E+00_JPRB,3.5767E+00_JPRB,4.6309E+00_JPRB,5.0714E+00_JPRB/)
KBO( :, 1,28,10) = (/&
&2.1278E-01_JPRB,1.7516E+00_JPRB,2.9793E+00_JPRB,4.0203E+00_JPRB,4.7023E+00_JPRB/)
KBO( :, 2,28,10) = (/&
&2.9077E-01_JPRB,1.8695E+00_JPRB,3.1275E+00_JPRB,4.1790E+00_JPRB,4.7891E+00_JPRB/)
KBO( :, 3,28,10) = (/&
&3.8371E-01_JPRB,1.9907E+00_JPRB,3.2690E+00_JPRB,4.3298E+00_JPRB,4.8703E+00_JPRB/)
KBO( :, 4,28,10) = (/&
&4.9305E-01_JPRB,2.1190E+00_JPRB,3.4062E+00_JPRB,4.4719E+00_JPRB,4.9485E+00_JPRB/)
KBO( :, 5,28,10) = (/&
&6.1872E-01_JPRB,2.2538E+00_JPRB,3.5418E+00_JPRB,4.5998E+00_JPRB,5.0210E+00_JPRB/)
KBO( :, 1,29,10) = (/&
&2.0270E-01_JPRB,1.7094E+00_JPRB,2.9099E+00_JPRB,3.9283E+00_JPRB,4.5455E+00_JPRB/)
KBO( :, 2,29,10) = (/&
&2.7494E-01_JPRB,1.8321E+00_JPRB,3.0685E+00_JPRB,4.1039E+00_JPRB,4.6641E+00_JPRB/)
KBO( :, 3,29,10) = (/&
&3.6154E-01_JPRB,1.9564E+00_JPRB,3.2214E+00_JPRB,4.2736E+00_JPRB,4.7773E+00_JPRB/)
KBO( :, 4,29,10) = (/&
&4.6300E-01_JPRB,2.0903E+00_JPRB,3.3694E+00_JPRB,4.4317E+00_JPRB,4.8838E+00_JPRB/)
KBO( :, 5,29,10) = (/&
&5.8057E-01_JPRB,2.2289E+00_JPRB,3.5079E+00_JPRB,4.5763E+00_JPRB,4.9830E+00_JPRB/)
KBO( :, 1,30,10) = (/&
&1.9279E-01_JPRB,1.6706E+00_JPRB,2.8469E+00_JPRB,3.8440E+00_JPRB,4.4080E+00_JPRB/)
KBO( :, 2,30,10) = (/&
&2.6009E-01_JPRB,1.7962E+00_JPRB,3.0153E+00_JPRB,4.0402E+00_JPRB,4.5583E+00_JPRB/)
KBO( :, 3,30,10) = (/&
&3.4074E-01_JPRB,1.9283E+00_JPRB,3.1794E+00_JPRB,4.2253E+00_JPRB,4.7038E+00_JPRB/)
KBO( :, 4,30,10) = (/&
&4.3604E-01_JPRB,2.0655E+00_JPRB,3.3337E+00_JPRB,4.4011E+00_JPRB,4.8377E+00_JPRB/)
KBO( :, 5,30,10) = (/&
&5.4764E-01_JPRB,2.2092E+00_JPRB,3.4808E+00_JPRB,4.5595E+00_JPRB,4.9628E+00_JPRB/)
KBO( :, 1,31,10) = (/&
&1.8369E-01_JPRB,1.6365E+00_JPRB,2.7938E+00_JPRB,3.7778E+00_JPRB,4.2984E+00_JPRB/)
KBO( :, 2,31,10) = (/&
&2.4679E-01_JPRB,1.7684E+00_JPRB,2.9729E+00_JPRB,3.9905E+00_JPRB,4.4818E+00_JPRB/)
KBO( :, 3,31,10) = (/&
&3.2266E-01_JPRB,1.9061E+00_JPRB,3.1442E+00_JPRB,4.1950E+00_JPRB,4.6519E+00_JPRB/)
KBO( :, 4,31,10) = (/&
&4.1304E-01_JPRB,2.0477E+00_JPRB,3.3074E+00_JPRB,4.3826E+00_JPRB,4.8118E+00_JPRB/)
KBO( :, 5,31,10) = (/&
&5.2000E-01_JPRB,2.1969E+00_JPRB,3.4636E+00_JPRB,4.5527E+00_JPRB,4.9659E+00_JPRB/)
KBO( :, 1,32,10) = (/&
&1.7551E-01_JPRB,1.6097E+00_JPRB,2.7544E+00_JPRB,3.7286E+00_JPRB,4.2211E+00_JPRB/)
KBO( :, 2,32,10) = (/&
&2.3510E-01_JPRB,1.7486E+00_JPRB,2.9407E+00_JPRB,3.9624E+00_JPRB,4.4263E+00_JPRB/)
KBO( :, 3,32,10) = (/&
&3.0724E-01_JPRB,1.8916E+00_JPRB,3.1218E+00_JPRB,4.1778E+00_JPRB,4.6235E+00_JPRB/)
KBO( :, 4,32,10) = (/&
&3.9398E-01_JPRB,2.0379E+00_JPRB,3.2915E+00_JPRB,4.3768E+00_JPRB,4.8156E+00_JPRB/)
KBO( :, 5,32,10) = (/&
&4.9781E-01_JPRB,2.1923E+00_JPRB,3.4588E+00_JPRB,4.5574E+00_JPRB,4.9861E+00_JPRB/)
KBO( :, 1,33,10) = (/&
&1.6799E-01_JPRB,1.5914E+00_JPRB,2.7274E+00_JPRB,3.7024E+00_JPRB,4.1697E+00_JPRB/)
KBO( :, 2,33,10) = (/&
&2.2491E-01_JPRB,1.7368E+00_JPRB,2.9243E+00_JPRB,3.9492E+00_JPRB,4.4031E+00_JPRB/)
KBO( :, 3,33,10) = (/&
&2.9437E-01_JPRB,1.8837E+00_JPRB,3.1109E+00_JPRB,4.1768E+00_JPRB,4.6308E+00_JPRB/)
KBO( :, 4,33,10) = (/&
&3.7842E-01_JPRB,2.0362E+00_JPRB,3.2892E+00_JPRB,4.3833E+00_JPRB,4.8420E+00_JPRB/)
KBO( :, 5,33,10) = (/&
&4.8057E-01_JPRB,2.1931E+00_JPRB,3.4634E+00_JPRB,4.5721E+00_JPRB,5.0256E+00_JPRB/)
KBO( :, 1,34,10) = (/&
&1.5948E-01_JPRB,1.5775E+00_JPRB,2.7077E+00_JPRB,3.6846E+00_JPRB,4.1408E+00_JPRB/)
KBO( :, 2,34,10) = (/&
&2.1390E-01_JPRB,1.7270E+00_JPRB,2.9131E+00_JPRB,3.9429E+00_JPRB,4.4016E+00_JPRB/)
KBO( :, 3,34,10) = (/&
&2.8085E-01_JPRB,1.8791E+00_JPRB,3.1047E+00_JPRB,4.1792E+00_JPRB,4.6526E+00_JPRB/)
KBO( :, 4,34,10) = (/&
&3.6334E-01_JPRB,2.0371E+00_JPRB,3.2904E+00_JPRB,4.3938E+00_JPRB,4.8733E+00_JPRB/)
KBO( :, 5,34,10) = (/&
&4.6344E-01_JPRB,2.1941E+00_JPRB,3.4718E+00_JPRB,4.5911E+00_JPRB,5.0724E+00_JPRB/)
KBO( :, 1,35,10) = (/&
&1.4741E-01_JPRB,1.5567E+00_JPRB,2.6803E+00_JPRB,3.6561E+00_JPRB,4.1139E+00_JPRB/)
KBO( :, 2,35,10) = (/&
&1.9866E-01_JPRB,1.7096E+00_JPRB,2.8922E+00_JPRB,3.9256E+00_JPRB,4.4015E+00_JPRB/)
KBO( :, 3,35,10) = (/&
&2.6293E-01_JPRB,1.8664E+00_JPRB,3.0898E+00_JPRB,4.1709E+00_JPRB,4.6633E+00_JPRB/)
KBO( :, 4,35,10) = (/&
&3.4264E-01_JPRB,2.0276E+00_JPRB,3.2824E+00_JPRB,4.3940E+00_JPRB,4.8993E+00_JPRB/)
KBO( :, 5,35,10) = (/&
&4.3976E-01_JPRB,2.1842E+00_JPRB,3.4695E+00_JPRB,4.5966E+00_JPRB,5.1130E+00_JPRB/)
KBO( :, 1,36,10) = (/&
&1.3214E-01_JPRB,1.5254E+00_JPRB,2.6382E+00_JPRB,3.6093E+00_JPRB,4.0744E+00_JPRB/)
KBO( :, 2,36,10) = (/&
&1.7956E-01_JPRB,1.6813E+00_JPRB,2.8567E+00_JPRB,3.8896E+00_JPRB,4.3806E+00_JPRB/)
KBO( :, 3,36,10) = (/&
&2.4004E-01_JPRB,1.8415E+00_JPRB,3.0610E+00_JPRB,4.1453E+00_JPRB,4.6577E+00_JPRB/)
KBO( :, 4,36,10) = (/&
&3.1565E-01_JPRB,2.0040E+00_JPRB,3.2597E+00_JPRB,4.3756E+00_JPRB,4.9082E+00_JPRB/)
KBO( :, 5,36,10) = (/&
&4.0871E-01_JPRB,2.1610E+00_JPRB,3.4521E+00_JPRB,4.5836E+00_JPRB,5.1373E+00_JPRB/)
KBO( :, 1,37,10) = (/&
&1.1316E-01_JPRB,1.4752E+00_JPRB,2.5688E+00_JPRB,3.5261E+00_JPRB,3.9938E+00_JPRB/)
KBO( :, 2,37,10) = (/&
&1.5558E-01_JPRB,1.6337E+00_JPRB,2.7946E+00_JPRB,3.8188E+00_JPRB,4.3194E+00_JPRB/)
KBO( :, 3,37,10) = (/&
&2.1051E-01_JPRB,1.7957E+00_JPRB,3.0066E+00_JPRB,4.0860E+00_JPRB,4.6128E+00_JPRB/)
KBO( :, 4,37,10) = (/&
&2.8028E-01_JPRB,1.9593E+00_JPRB,3.2111E+00_JPRB,4.3259E+00_JPRB,4.8781E+00_JPRB/)
KBO( :, 5,37,10) = (/&
&3.6684E-01_JPRB,2.1183E+00_JPRB,3.4096E+00_JPRB,4.5437E+00_JPRB,5.1231E+00_JPRB/)
KBO( :, 1,38,10) = (/&
&9.6748E-02_JPRB,1.4275E+00_JPRB,2.5025E+00_JPRB,3.4448E+00_JPRB,3.9178E+00_JPRB/)
KBO( :, 2,38,10) = (/&
&1.3470E-01_JPRB,1.5886E+00_JPRB,2.7351E+00_JPRB,3.7489E+00_JPRB,4.2599E+00_JPRB/)
KBO( :, 3,38,10) = (/&
&1.8442E-01_JPRB,1.7514E+00_JPRB,2.9540E+00_JPRB,4.0269E+00_JPRB,4.5684E+00_JPRB/)
KBO( :, 4,38,10) = (/&
&2.4862E-01_JPRB,1.9169E+00_JPRB,3.1637E+00_JPRB,4.2769E+00_JPRB,4.8492E+00_JPRB/)
KBO( :, 5,38,10) = (/&
&3.2905E-01_JPRB,2.0776E+00_JPRB,3.3672E+00_JPRB,4.5027E+00_JPRB,5.1082E+00_JPRB/)
KBO( :, 1,39,10) = (/&
&8.2846E-02_JPRB,1.3834E+00_JPRB,2.4412E+00_JPRB,3.3680E+00_JPRB,3.8485E+00_JPRB/)
KBO( :, 2,39,10) = (/&
&1.1685E-01_JPRB,1.5463E+00_JPRB,2.6796E+00_JPRB,3.6824E+00_JPRB,4.2039E+00_JPRB/)
KBO( :, 3,39,10) = (/&
&1.6194E-01_JPRB,1.7108E+00_JPRB,2.9043E+00_JPRB,3.9699E+00_JPRB,4.5285E+00_JPRB/)
KBO( :, 4,39,10) = (/&
&2.2088E-01_JPRB,1.8779E+00_JPRB,3.1188E+00_JPRB,4.2292E+00_JPRB,4.8250E+00_JPRB/)
KBO( :, 5,39,10) = (/&
&2.9576E-01_JPRB,2.0398E+00_JPRB,3.3275E+00_JPRB,4.4625E+00_JPRB,5.0971E+00_JPRB/)
KBO( :, 1,40,10) = (/&
&6.8460E-02_JPRB,1.3257E+00_JPRB,2.3577E+00_JPRB,3.2603E+00_JPRB,3.7339E+00_JPRB/)
KBO( :, 2,40,10) = (/&
&9.7988E-02_JPRB,1.4903E+00_JPRB,2.6023E+00_JPRB,3.5872E+00_JPRB,4.1045E+00_JPRB/)
KBO( :, 3,40,10) = (/&
&1.3775E-01_JPRB,1.6559E+00_JPRB,2.8336E+00_JPRB,3.8858E+00_JPRB,4.4458E+00_JPRB/)
KBO( :, 4,40,10) = (/&
&1.9045E-01_JPRB,1.8245E+00_JPRB,3.0542E+00_JPRB,4.1559E+00_JPRB,4.7581E+00_JPRB/)
KBO( :, 5,40,10) = (/&
&2.5849E-01_JPRB,1.9886E+00_JPRB,3.2674E+00_JPRB,4.3994E+00_JPRB,5.0432E+00_JPRB/)
KBO( :, 1,41,10) = (/&
&5.6234E-02_JPRB,1.2690E+00_JPRB,2.2720E+00_JPRB,3.1495E+00_JPRB,3.6139E+00_JPRB/)
KBO( :, 2,41,10) = (/&
&8.1724E-02_JPRB,1.4342E+00_JPRB,2.5230E+00_JPRB,3.4875E+00_JPRB,3.9992E+00_JPRB/)
KBO( :, 3,41,10) = (/&
&1.1661E-01_JPRB,1.6007E+00_JPRB,2.7616E+00_JPRB,3.7972E+00_JPRB,4.3567E+00_JPRB/)
KBO( :, 4,41,10) = (/&
&1.6350E-01_JPRB,1.7709E+00_JPRB,2.9870E+00_JPRB,4.0779E+00_JPRB,4.6840E+00_JPRB/)
KBO( :, 5,41,10) = (/&
&2.2482E-01_JPRB,1.9373E+00_JPRB,3.2036E+00_JPRB,4.3314E+00_JPRB,4.9822E+00_JPRB/)
KBO( :, 1,42,10) = (/&
&4.6099E-02_JPRB,1.2146E+00_JPRB,2.1872E+00_JPRB,3.0381E+00_JPRB,3.4945E+00_JPRB/)
KBO( :, 2,42,10) = (/&
&6.8068E-02_JPRB,1.3798E+00_JPRB,2.4452E+00_JPRB,3.3871E+00_JPRB,3.8938E+00_JPRB/)
KBO( :, 3,42,10) = (/&
&9.8587E-02_JPRB,1.5478E+00_JPRB,2.6891E+00_JPRB,3.7072E+00_JPRB,4.2665E+00_JPRB/)
KBO( :, 4,42,10) = (/&
&1.4020E-01_JPRB,1.7187E+00_JPRB,2.9198E+00_JPRB,3.9988E+00_JPRB,4.6092E+00_JPRB/)
KBO( :, 5,42,10) = (/&
&1.9544E-01_JPRB,1.8864E+00_JPRB,3.1414E+00_JPRB,4.2616E+00_JPRB,4.9213E+00_JPRB/)
KBO( :, 1,43,10) = (/&
&3.6837E-02_JPRB,1.1530E+00_JPRB,2.0885E+00_JPRB,2.9067E+00_JPRB,3.3518E+00_JPRB/)
KBO( :, 2,43,10) = (/&
&5.5339E-02_JPRB,1.3181E+00_JPRB,2.3532E+00_JPRB,3.2663E+00_JPRB,3.7650E+00_JPRB/)
KBO( :, 3,43,10) = (/&
&8.1513E-02_JPRB,1.4866E+00_JPRB,2.6028E+00_JPRB,3.5988E+00_JPRB,4.1527E+00_JPRB/)
KBO( :, 4,43,10) = (/&
&1.1773E-01_JPRB,1.6570E+00_JPRB,2.8399E+00_JPRB,3.9012E+00_JPRB,4.5115E+00_JPRB/)
KBO( :, 5,43,10) = (/&
&1.6664E-01_JPRB,1.8278E+00_JPRB,3.0668E+00_JPRB,4.1754E+00_JPRB,4.8396E+00_JPRB/)
KBO( :, 1,44,10) = (/&
&2.8988E-02_JPRB,1.0887E+00_JPRB,1.9830E+00_JPRB,2.7653E+00_JPRB,3.1966E+00_JPRB/)
KBO( :, 2,44,10) = (/&
&4.4338E-02_JPRB,1.2532E+00_JPRB,2.2540E+00_JPRB,3.1344E+00_JPRB,3.6243E+00_JPRB/)
KBO( :, 3,44,10) = (/&
&6.6501E-02_JPRB,1.4222E+00_JPRB,2.5105E+00_JPRB,3.4789E+00_JPRB,4.0260E+00_JPRB/)
KBO( :, 4,44,10) = (/&
&9.7639E-02_JPRB,1.5932E+00_JPRB,2.7543E+00_JPRB,3.7931E+00_JPRB,4.4021E+00_JPRB/)
KBO( :, 5,44,10) = (/&
&1.4052E-01_JPRB,1.7655E+00_JPRB,2.9842E+00_JPRB,4.0798E+00_JPRB,4.7466E+00_JPRB/)
KBO( :, 1,45,10) = (/&
&2.2674E-02_JPRB,1.0257E+00_JPRB,1.8783E+00_JPRB,2.6228E+00_JPRB,3.0412E+00_JPRB/)
KBO( :, 2,45,10) = (/&
&3.5361E-02_JPRB,1.1906E+00_JPRB,2.1544E+00_JPRB,3.0007E+00_JPRB,3.4821E+00_JPRB/)
KBO( :, 3,45,10) = (/&
&5.3984E-02_JPRB,1.3593E+00_JPRB,2.4179E+00_JPRB,3.3558E+00_JPRB,3.8978E+00_JPRB/)
KBO( :, 4,45,10) = (/&
&8.0687E-02_JPRB,1.5302E+00_JPRB,2.6662E+00_JPRB,3.6830E+00_JPRB,4.2916E+00_JPRB/)
KBO( :, 5,45,10) = (/&
&1.1807E-01_JPRB,1.7032E+00_JPRB,2.9026E+00_JPRB,3.9804E+00_JPRB,4.6530E+00_JPRB/)
KBO( :, 1,46,10) = (/&
&1.7410E-02_JPRB,9.6094E-01_JPRB,1.7674E+00_JPRB,2.4706E+00_JPRB,2.8739E+00_JPRB/)
KBO( :, 2,46,10) = (/&
&2.7786E-02_JPRB,1.1256E+00_JPRB,2.0477E+00_JPRB,2.8564E+00_JPRB,3.3272E+00_JPRB/)
KBO( :, 3,46,10) = (/&
&4.3233E-02_JPRB,1.2931E+00_JPRB,2.3174E+00_JPRB,3.2226E+00_JPRB,3.7574E+00_JPRB/)
KBO( :, 4,46,10) = (/&
&6.5795E-02_JPRB,1.4641E+00_JPRB,2.5723E+00_JPRB,3.5627E+00_JPRB,4.1675E+00_JPRB/)
KBO( :, 5,46,10) = (/&
&9.8017E-02_JPRB,1.6372E+00_JPRB,2.8147E+00_JPRB,3.8708E+00_JPRB,4.5474E+00_JPRB/)
KBO( :, 1,47,10) = (/&
&1.2932E-02_JPRB,8.9077E-01_JPRB,1.6439E+00_JPRB,2.2995E+00_JPRB,2.6825E+00_JPRB/)
KBO( :, 2,47,10) = (/&
&2.1223E-02_JPRB,1.0540E+00_JPRB,1.9287E+00_JPRB,2.6946E+00_JPRB,3.1473E+00_JPRB/)
KBO( :, 3,47,10) = (/&
&3.3771E-02_JPRB,1.2207E+00_JPRB,2.2047E+00_JPRB,3.0711E+00_JPRB,3.5926E+00_JPRB/)
KBO( :, 4,47,10) = (/&
&5.2401E-02_JPRB,1.3916E+00_JPRB,2.4667E+00_JPRB,3.4226E+00_JPRB,4.0177E+00_JPRB/)
KBO( :, 5,47,10) = (/&
&7.9614E-02_JPRB,1.5646E+00_JPRB,2.7148E+00_JPRB,3.7454E+00_JPRB,4.4170E+00_JPRB/)
KBO( :, 1,48,10) = (/&
&9.4853E-03_JPRB,8.2116E-01_JPRB,1.5192E+00_JPRB,2.1278E+00_JPRB,2.4903E+00_JPRB/)
KBO( :, 2,48,10) = (/&
&1.6017E-02_JPRB,9.8364E-01_JPRB,1.8094E+00_JPRB,2.5302E+00_JPRB,2.9654E+00_JPRB/)
KBO( :, 3,48,10) = (/&
&2.6151E-02_JPRB,1.1500E+00_JPRB,2.0897E+00_JPRB,2.9152E+00_JPRB,3.4258E+00_JPRB/)
KBO( :, 4,48,10) = (/&
&4.1450E-02_JPRB,1.3196E+00_JPRB,2.3589E+00_JPRB,3.2790E+00_JPRB,3.8661E+00_JPRB/)
KBO( :, 5,48,10) = (/&
&6.4206E-02_JPRB,1.4922E+00_JPRB,2.6125E+00_JPRB,3.6159E+00_JPRB,4.2851E+00_JPRB/)
KBO( :, 1,49,10) = (/&
&6.8584E-03_JPRB,7.5265E-01_JPRB,1.3951E+00_JPRB,1.9557E+00_JPRB,2.2987E+00_JPRB/)
KBO( :, 2,49,10) = (/&
&1.1934E-02_JPRB,9.1467E-01_JPRB,1.6885E+00_JPRB,2.3631E+00_JPRB,2.7820E+00_JPRB/)
KBO( :, 3,49,10) = (/&
&2.0019E-02_JPRB,1.0797E+00_JPRB,1.9731E+00_JPRB,2.7567E+00_JPRB,3.2569E+00_JPRB/)
KBO( :, 4,49,10) = (/&
&3.2532E-02_JPRB,1.2481E+00_JPRB,2.2484E+00_JPRB,3.1312E+00_JPRB,3.7144E+00_JPRB/)
KBO( :, 5,49,10) = (/&
&5.1423E-02_JPRB,1.4202E+00_JPRB,2.5087E+00_JPRB,3.4802E+00_JPRB,4.1524E+00_JPRB/)
KBO( :, 1,50,10) = (/&
&4.9588E-03_JPRB,6.8907E-01_JPRB,1.2794E+00_JPRB,1.7942E+00_JPRB,2.1153E+00_JPRB/)
KBO( :, 2,50,10) = (/&
&8.8947E-03_JPRB,8.5045E-01_JPRB,1.5739E+00_JPRB,2.2042E+00_JPRB,2.6031E+00_JPRB/)
KBO( :, 3,50,10) = (/&
&1.5348E-02_JPRB,1.0143E+00_JPRB,1.8632E+00_JPRB,2.6056E+00_JPRB,3.0870E+00_JPRB/)
KBO( :, 4,50,10) = (/&
&2.5608E-02_JPRB,1.1821E+00_JPRB,2.1430E+00_JPRB,2.9888E+00_JPRB,3.5596E+00_JPRB/)
KBO( :, 5,50,10) = (/&
&4.1387E-02_JPRB,1.3536E+00_JPRB,2.4101E+00_JPRB,3.3481E+00_JPRB,4.0115E+00_JPRB/)
KBO( :, 1,51,10) = (/&
&3.5571E-03_JPRB,6.2785E-01_JPRB,1.1678E+00_JPRB,1.6386E+00_JPRB,1.9369E+00_JPRB/)
KBO( :, 2,51,10) = (/&
&6.5893E-03_JPRB,7.8876E-01_JPRB,1.4624E+00_JPRB,2.0498E+00_JPRB,2.4257E+00_JPRB/)
KBO( :, 3,51,10) = (/&
&1.1707E-02_JPRB,9.5177E-01_JPRB,1.7551E+00_JPRB,2.4566E+00_JPRB,2.9162E+00_JPRB/)
KBO( :, 4,51,10) = (/&
&2.0074E-02_JPRB,1.1187E+00_JPRB,2.0387E+00_JPRB,2.8466E+00_JPRB,3.3998E+00_JPRB/)
KBO( :, 5,51,10) = (/&
&3.3273E-02_JPRB,1.2890E+00_JPRB,2.3117E+00_JPRB,3.2168E+00_JPRB,3.8651E+00_JPRB/)
KBO( :, 1,52,10) = (/&
&2.5127E-03_JPRB,5.6820E-01_JPRB,1.0583E+00_JPRB,1.4864E+00_JPRB,1.7624E+00_JPRB/)
KBO( :, 2,52,10) = (/&
&4.8248E-03_JPRB,7.2792E-01_JPRB,1.3512E+00_JPRB,1.8952E+00_JPRB,2.2490E+00_JPRB/)
KBO( :, 3,52,10) = (/&
&8.8346E-03_JPRB,8.9029E-01_JPRB,1.6463E+00_JPRB,2.3052E+00_JPRB,2.7452E+00_JPRB/)
KBO( :, 4,52,10) = (/&
&1.5583E-02_JPRB,1.0558E+00_JPRB,1.9336E+00_JPRB,2.7033E+00_JPRB,3.2391E+00_JPRB/)
KBO( :, 5,52,10) = (/&
&2.6529E-02_JPRB,1.2246E+00_JPRB,2.2115E+00_JPRB,3.0824E+00_JPRB,3.7180E+00_JPRB/)
KBO( :, 1,53,10) = (/&
&1.7459E-03_JPRB,5.1010E-01_JPRB,9.5136E-01_JPRB,1.3367E+00_JPRB,1.5916E+00_JPRB/)
KBO( :, 2,53,10) = (/&
&3.4808E-03_JPRB,6.6729E-01_JPRB,1.2403E+00_JPRB,1.7405E+00_JPRB,2.0746E+00_JPRB/)
KBO( :, 3,53,10) = (/&
&6.5872E-03_JPRB,8.2899E-01_JPRB,1.5363E+00_JPRB,2.1529E+00_JPRB,2.5747E+00_JPRB/)
KBO( :, 4,53,10) = (/&
&1.1962E-02_JPRB,9.9325E-01_JPRB,1.8279E+00_JPRB,2.5576E+00_JPRB,3.0783E+00_JPRB/)
KBO( :, 5,53,10) = (/&
&2.0951E-02_JPRB,1.1616E+00_JPRB,2.1096E+00_JPRB,2.9440E+00_JPRB,3.5715E+00_JPRB/)
KBO( :, 1,54,10) = (/&
&1.2204E-03_JPRB,4.5823E-01_JPRB,8.5579E-01_JPRB,1.2025E+00_JPRB,1.4326E+00_JPRB/)
KBO( :, 2,54,10) = (/&
&2.5281E-03_JPRB,6.1212E-01_JPRB,1.1396E+00_JPRB,1.5999E+00_JPRB,1.9069E+00_JPRB/)
KBO( :, 3,54,10) = (/&
&4.9409E-03_JPRB,7.7338E-01_JPRB,1.4350E+00_JPRB,2.0125E+00_JPRB,2.4041E+00_JPRB/)
KBO( :, 4,54,10) = (/&
&9.2436E-03_JPRB,9.3695E-01_JPRB,1.7295E+00_JPRB,2.4215E+00_JPRB,2.9094E+00_JPRB/)
KBO( :, 5,54,10) = (/&
&1.6670E-02_JPRB,1.1040E+00_JPRB,2.0145E+00_JPRB,2.8142E+00_JPRB,3.4095E+00_JPRB/)
KBO( :, 1,55,10) = (/&
&8.4904E-04_JPRB,4.1031E-01_JPRB,7.6714E-01_JPRB,1.0777E+00_JPRB,1.2810E+00_JPRB/)
KBO( :, 2,55,10) = (/&
&1.8289E-03_JPRB,5.6051E-01_JPRB,1.0445E+00_JPRB,1.4675E+00_JPRB,1.7437E+00_JPRB/)
KBO( :, 3,55,10) = (/&
&3.6957E-03_JPRB,7.2049E-01_JPRB,1.3381E+00_JPRB,1.8775E+00_JPRB,2.2346E+00_JPRB/)
KBO( :, 4,55,10) = (/&
&7.1338E-03_JPRB,8.8320E-01_JPRB,1.6342E+00_JPRB,2.2888E+00_JPRB,2.7356E+00_JPRB/)
KBO( :, 5,55,10) = (/&
&1.3248E-02_JPRB,1.0490E+00_JPRB,1.9226E+00_JPRB,2.6886E+00_JPRB,3.2366E+00_JPRB/)
KBO( :, 1,56,10) = (/&
&5.8188E-04_JPRB,3.6451E-01_JPRB,6.8188E-01_JPRB,9.5775E-01_JPRB,1.1364E+00_JPRB/)
KBO( :, 2,56,10) = (/&
&1.3061E-03_JPRB,5.1010E-01_JPRB,9.5157E-01_JPRB,1.3373E+00_JPRB,1.5849E+00_JPRB/)
KBO( :, 3,56,10) = (/&
&2.7348E-03_JPRB,6.6775E-01_JPRB,1.2416E+00_JPRB,1.7426E+00_JPRB,2.0675E+00_JPRB/)
KBO( :, 4,56,10) = (/&
&5.4506E-03_JPRB,8.2982E-01_JPRB,1.5384E+00_JPRB,2.1560E+00_JPRB,2.5656E+00_JPRB/)
KBO( :, 5,56,10) = (/&
&1.0438E-02_JPRB,9.9464E-01_JPRB,1.8304E+00_JPRB,2.5617E+00_JPRB,3.0643E+00_JPRB/)
KBO( :, 1,57,10) = (/&
&3.9249E-04_JPRB,3.2068E-01_JPRB,6.0044E-01_JPRB,8.4280E-01_JPRB,9.9873E-01_JPRB/)
KBO( :, 2,57,10) = (/&
&9.2030E-04_JPRB,4.6083E-01_JPRB,8.6077E-01_JPRB,1.2098E+00_JPRB,1.4302E+00_JPRB/)
KBO( :, 3,57,10) = (/&
&2.0002E-03_JPRB,6.1542E-01_JPRB,1.1460E+00_JPRB,1.6091E+00_JPRB,1.9029E+00_JPRB/)
KBO( :, 4,57,10) = (/&
&4.1235E-03_JPRB,7.7708E-01_JPRB,1.4422E+00_JPRB,2.0227E+00_JPRB,2.3967E+00_JPRB/)
KBO( :, 5,57,10) = (/&
&8.1478E-03_JPRB,9.4098E-01_JPRB,1.7369E+00_JPRB,2.4323E+00_JPRB,2.8933E+00_JPRB/)
KBO( :, 1,58,10) = (/&
&2.6430E-04_JPRB,2.8122E-01_JPRB,5.2695E-01_JPRB,7.3930E-01_JPRB,8.7420E-01_JPRB/)
KBO( :, 2,58,10) = (/&
&6.4821E-04_JPRB,4.1579E-01_JPRB,7.7745E-01_JPRB,1.0922E+00_JPRB,1.2875E+00_JPRB/)
KBO( :, 3,58,10) = (/&
&1.4624E-03_JPRB,5.6685E-01_JPRB,1.0564E+00_JPRB,1.4844E+00_JPRB,1.7489E+00_JPRB/)
KBO( :, 4,58,10) = (/&
&3.1206E-03_JPRB,7.2740E-01_JPRB,1.3510E+00_JPRB,1.8958E+00_JPRB,2.2357E+00_JPRB/)
KBO( :, 5,58,10) = (/&
&6.3628E-03_JPRB,8.9041E-01_JPRB,1.6474E+00_JPRB,2.3075E+00_JPRB,2.7302E+00_JPRB/)
KBO( :, 1,59,10) = (/&
&2.0990E-04_JPRB,2.6575E-01_JPRB,4.9806E-01_JPRB,6.9856E-01_JPRB,8.1922E-01_JPRB/)
KBO( :, 2,59,10) = (/&
&5.2942E-04_JPRB,3.9787E-01_JPRB,7.4416E-01_JPRB,1.0453E+00_JPRB,1.2213E+00_JPRB/)
KBO( :, 3,59,10) = (/&
&1.2254E-03_JPRB,5.4737E-01_JPRB,1.0206E+00_JPRB,1.4342E+00_JPRB,1.6735E+00_JPRB/)
KBO( :, 4,59,10) = (/&
&2.6840E-03_JPRB,7.0712E-01_JPRB,1.3141E+00_JPRB,1.8442E+00_JPRB,2.1507E+00_JPRB/)
KBO( :, 5,59,10) = (/&
&5.6182E-03_JPRB,8.7007E-01_JPRB,1.6111E+00_JPRB,2.2569E+00_JPRB,2.6371E+00_JPRB/)
KBO( :, 1,13,11) = (/&
&1.0801E+00_JPRB,1.4348E+00_JPRB,2.0789E+00_JPRB,2.8766E+00_JPRB,3.7088E+00_JPRB/)
KBO( :, 2,13,11) = (/&
&1.5786E+00_JPRB,1.6909E+00_JPRB,2.2344E+00_JPRB,2.8378E+00_JPRB,3.6154E+00_JPRB/)
KBO( :, 3,13,11) = (/&
&2.1806E+00_JPRB,1.9878E+00_JPRB,2.3945E+00_JPRB,2.8212E+00_JPRB,3.5326E+00_JPRB/)
KBO( :, 4,13,11) = (/&
&2.8720E+00_JPRB,2.3800E+00_JPRB,2.5914E+00_JPRB,2.8385E+00_JPRB,3.4655E+00_JPRB/)
KBO( :, 5,13,11) = (/&
&3.6411E+00_JPRB,2.8911E+00_JPRB,2.8480E+00_JPRB,2.9116E+00_JPRB,3.4228E+00_JPRB/)
KBO( :, 1,14,11) = (/&
&1.1044E+00_JPRB,1.5475E+00_JPRB,2.2497E+00_JPRB,3.1463E+00_JPRB,4.0884E+00_JPRB/)
KBO( :, 2,14,11) = (/&
&1.5971E+00_JPRB,1.7939E+00_JPRB,2.3794E+00_JPRB,3.1054E+00_JPRB,3.9980E+00_JPRB/)
KBO( :, 3,14,11) = (/&
&2.1821E+00_JPRB,2.0987E+00_JPRB,2.5507E+00_JPRB,3.0870E+00_JPRB,3.9208E+00_JPRB/)
KBO( :, 4,14,11) = (/&
&2.8502E+00_JPRB,2.4509E+00_JPRB,2.7671E+00_JPRB,3.1108E+00_JPRB,3.8503E+00_JPRB/)
KBO( :, 5,14,11) = (/&
&3.5884E+00_JPRB,2.8921E+00_JPRB,3.0089E+00_JPRB,3.1705E+00_JPRB,3.7851E+00_JPRB/)
KBO( :, 1,15,11) = (/&
&1.1021E+00_JPRB,1.6587E+00_JPRB,2.4815E+00_JPRB,3.5024E+00_JPRB,4.5632E+00_JPRB/)
KBO( :, 2,15,11) = (/&
&1.5743E+00_JPRB,1.8988E+00_JPRB,2.5745E+00_JPRB,3.4612E+00_JPRB,4.4691E+00_JPRB/)
KBO( :, 3,15,11) = (/&
&2.1315E+00_JPRB,2.1848E+00_JPRB,2.7319E+00_JPRB,3.4370E+00_JPRB,4.3819E+00_JPRB/)
KBO( :, 4,15,11) = (/&
&2.7650E+00_JPRB,2.5138E+00_JPRB,2.9331E+00_JPRB,3.4633E+00_JPRB,4.3032E+00_JPRB/)
KBO( :, 5,15,11) = (/&
&3.4727E+00_JPRB,2.9032E+00_JPRB,3.1579E+00_JPRB,3.5044E+00_JPRB,4.2227E+00_JPRB/)
KBO( :, 1,16,11) = (/&
&1.0714E+00_JPRB,1.7588E+00_JPRB,2.7564E+00_JPRB,3.8747E+00_JPRB,5.0508E+00_JPRB/)
KBO( :, 2,16,11) = (/&
&1.5150E+00_JPRB,1.9873E+00_JPRB,2.8550E+00_JPRB,3.8426E+00_JPRB,4.9605E+00_JPRB/)
KBO( :, 3,16,11) = (/&
&2.0368E+00_JPRB,2.2470E+00_JPRB,2.9773E+00_JPRB,3.8351E+00_JPRB,4.8716E+00_JPRB/)
KBO( :, 4,16,11) = (/&
&2.6368E+00_JPRB,2.5533E+00_JPRB,3.1361E+00_JPRB,3.8536E+00_JPRB,4.7863E+00_JPRB/)
KBO( :, 5,16,11) = (/&
&3.3066E+00_JPRB,2.9151E+00_JPRB,3.3174E+00_JPRB,3.8762E+00_JPRB,4.6948E+00_JPRB/)
KBO( :, 1,17,11) = (/&
&1.0151E+00_JPRB,1.8852E+00_JPRB,3.0518E+00_JPRB,4.2628E+00_JPRB,5.5542E+00_JPRB/)
KBO( :, 2,17,11) = (/&
&1.4250E+00_JPRB,2.0700E+00_JPRB,3.1614E+00_JPRB,4.2288E+00_JPRB,5.4601E+00_JPRB/)
KBO( :, 3,17,11) = (/&
&1.9121E+00_JPRB,2.3001E+00_JPRB,3.2776E+00_JPRB,4.2348E+00_JPRB,5.3679E+00_JPRB/)
KBO( :, 4,17,11) = (/&
&2.4694E+00_JPRB,2.5770E+00_JPRB,3.4037E+00_JPRB,4.2558E+00_JPRB,5.2730E+00_JPRB/)
KBO( :, 5,17,11) = (/&
&3.0899E+00_JPRB,2.9049E+00_JPRB,3.5383E+00_JPRB,4.2898E+00_JPRB,5.1747E+00_JPRB/)
KBO( :, 1,18,11) = (/&
&9.4290E-01_JPRB,2.0484E+00_JPRB,3.3469E+00_JPRB,4.6479E+00_JPRB,6.0575E+00_JPRB/)
KBO( :, 2,18,11) = (/&
&1.3205E+00_JPRB,2.1931E+00_JPRB,3.4728E+00_JPRB,4.6183E+00_JPRB,5.9563E+00_JPRB/)
KBO( :, 3,18,11) = (/&
&1.7655E+00_JPRB,2.3717E+00_JPRB,3.5959E+00_JPRB,4.6412E+00_JPRB,5.8591E+00_JPRB/)
KBO( :, 4,18,11) = (/&
&2.2742E+00_JPRB,2.6014E+00_JPRB,3.7076E+00_JPRB,4.6704E+00_JPRB,5.7576E+00_JPRB/)
KBO( :, 5,18,11) = (/&
&2.8368E+00_JPRB,2.8834E+00_JPRB,3.8149E+00_JPRB,4.7239E+00_JPRB,5.6493E+00_JPRB/)
KBO( :, 1,19,11) = (/&
&8.6437E-01_JPRB,2.2167E+00_JPRB,3.6423E+00_JPRB,5.0107E+00_JPRB,6.5258E+00_JPRB/)
KBO( :, 2,19,11) = (/&
&1.2052E+00_JPRB,2.3536E+00_JPRB,3.7778E+00_JPRB,5.0137E+00_JPRB,6.4336E+00_JPRB/)
KBO( :, 3,19,11) = (/&
&1.6063E+00_JPRB,2.4963E+00_JPRB,3.9078E+00_JPRB,5.0409E+00_JPRB,6.3317E+00_JPRB/)
KBO( :, 4,19,11) = (/&
&2.0613E+00_JPRB,2.6673E+00_JPRB,4.0216E+00_JPRB,5.0848E+00_JPRB,6.2172E+00_JPRB/)
KBO( :, 5,19,11) = (/&
&2.5635E+00_JPRB,2.8852E+00_JPRB,4.1233E+00_JPRB,5.1457E+00_JPRB,6.0969E+00_JPRB/)
KBO( :, 1,20,11) = (/&
&7.8779E-01_JPRB,2.3765E+00_JPRB,3.9264E+00_JPRB,5.3499E+00_JPRB,6.9480E+00_JPRB/)
KBO( :, 2,20,11) = (/&
&1.0926E+00_JPRB,2.5148E+00_JPRB,4.0670E+00_JPRB,5.3834E+00_JPRB,6.8553E+00_JPRB/)
KBO( :, 3,20,11) = (/&
&1.4487E+00_JPRB,2.6525E+00_JPRB,4.1962E+00_JPRB,5.4179E+00_JPRB,6.7496E+00_JPRB/)
KBO( :, 4,20,11) = (/&
&1.8513E+00_JPRB,2.7916E+00_JPRB,4.3148E+00_JPRB,5.4862E+00_JPRB,6.6370E+00_JPRB/)
KBO( :, 5,20,11) = (/&
&2.2991E+00_JPRB,2.9510E+00_JPRB,4.4216E+00_JPRB,5.5498E+00_JPRB,6.5228E+00_JPRB/)
KBO( :, 1,21,11) = (/&
&7.0932E-01_JPRB,2.5175E+00_JPRB,4.1824E+00_JPRB,5.6525E+00_JPRB,7.2957E+00_JPRB/)
KBO( :, 2,21,11) = (/&
&9.7801E-01_JPRB,2.6602E+00_JPRB,4.3300E+00_JPRB,5.6984E+00_JPRB,7.2060E+00_JPRB/)
KBO( :, 3,21,11) = (/&
&1.2908E+00_JPRB,2.7977E+00_JPRB,4.4565E+00_JPRB,5.7675E+00_JPRB,7.1115E+00_JPRB/)
KBO( :, 4,21,11) = (/&
&1.6486E+00_JPRB,2.9337E+00_JPRB,4.5784E+00_JPRB,5.8514E+00_JPRB,7.0112E+00_JPRB/)
KBO( :, 5,21,11) = (/&
&2.0548E+00_JPRB,3.0662E+00_JPRB,4.6884E+00_JPRB,5.9211E+00_JPRB,6.9051E+00_JPRB/)
KBO( :, 1,22,11) = (/&
&6.4634E-01_JPRB,2.6427E+00_JPRB,4.4108E+00_JPRB,5.9111E+00_JPRB,7.5603E+00_JPRB/)
KBO( :, 2,22,11) = (/&
&8.8382E-01_JPRB,2.7886E+00_JPRB,4.5605E+00_JPRB,5.9821E+00_JPRB,7.4874E+00_JPRB/)
KBO( :, 3,22,11) = (/&
&1.1630E+00_JPRB,2.9292E+00_JPRB,4.6954E+00_JPRB,6.0879E+00_JPRB,7.4042E+00_JPRB/)
KBO( :, 4,22,11) = (/&
&1.4885E+00_JPRB,3.0664E+00_JPRB,4.8184E+00_JPRB,6.1855E+00_JPRB,7.3136E+00_JPRB/)
KBO( :, 5,22,11) = (/&
&1.8588E+00_JPRB,3.1975E+00_JPRB,4.9293E+00_JPRB,6.2618E+00_JPRB,7.2153E+00_JPRB/)
KBO( :, 1,23,11) = (/&
&5.8489E-01_JPRB,2.7446E+00_JPRB,4.5940E+00_JPRB,6.1135E+00_JPRB,7.7491E+00_JPRB/)
KBO( :, 2,23,11) = (/&
&7.9682E-01_JPRB,2.8912E+00_JPRB,4.7488E+00_JPRB,6.2356E+00_JPRB,7.6928E+00_JPRB/)
KBO( :, 3,23,11) = (/&
&1.0504E+00_JPRB,3.0346E+00_JPRB,4.8968E+00_JPRB,6.3608E+00_JPRB,7.6287E+00_JPRB/)
KBO( :, 4,23,11) = (/&
&1.3447E+00_JPRB,3.1725E+00_JPRB,5.0242E+00_JPRB,6.4689E+00_JPRB,7.5521E+00_JPRB/)
KBO( :, 5,23,11) = (/&
&1.6807E+00_JPRB,3.3048E+00_JPRB,5.1382E+00_JPRB,6.5524E+00_JPRB,7.4632E+00_JPRB/)
KBO( :, 1,24,11) = (/&
&5.2989E-01_JPRB,2.8195E+00_JPRB,4.7301E+00_JPRB,6.2761E+00_JPRB,7.8550E+00_JPRB/)
KBO( :, 2,24,11) = (/&
&7.2198E-01_JPRB,2.9702E+00_JPRB,4.8974E+00_JPRB,6.4380E+00_JPRB,7.8243E+00_JPRB/)
KBO( :, 3,24,11) = (/&
&9.5134E-01_JPRB,3.1164E+00_JPRB,5.0504E+00_JPRB,6.5817E+00_JPRB,7.7816E+00_JPRB/)
KBO( :, 4,24,11) = (/&
&1.2196E+00_JPRB,3.2537E+00_JPRB,5.1885E+00_JPRB,6.6940E+00_JPRB,7.7249E+00_JPRB/)
KBO( :, 5,24,11) = (/&
&1.5265E+00_JPRB,3.3851E+00_JPRB,5.3089E+00_JPRB,6.7822E+00_JPRB,7.6563E+00_JPRB/)
KBO( :, 1,25,11) = (/&
&4.8476E-01_JPRB,2.8697E+00_JPRB,4.8218E+00_JPRB,6.4097E+00_JPRB,7.9026E+00_JPRB/)
KBO( :, 2,25,11) = (/&
&6.5969E-01_JPRB,3.0274E+00_JPRB,5.0029E+00_JPRB,6.5890E+00_JPRB,7.8973E+00_JPRB/)
KBO( :, 3,25,11) = (/&
&8.6906E-01_JPRB,3.1754E+00_JPRB,5.1656E+00_JPRB,6.7410E+00_JPRB,7.8772E+00_JPRB/)
KBO( :, 4,25,11) = (/&
&1.1152E+00_JPRB,3.3120E+00_JPRB,5.3111E+00_JPRB,6.8679E+00_JPRB,7.8462E+00_JPRB/)
KBO( :, 5,25,11) = (/&
&1.4024E+00_JPRB,3.4449E+00_JPRB,5.4363E+00_JPRB,6.9674E+00_JPRB,7.7978E+00_JPRB/)
KBO( :, 1,26,11) = (/&
&4.4920E-01_JPRB,2.9004E+00_JPRB,4.8834E+00_JPRB,6.5041E+00_JPRB,7.9089E+00_JPRB/)
KBO( :, 2,26,11) = (/&
&6.0999E-01_JPRB,3.0628E+00_JPRB,5.0713E+00_JPRB,6.6966E+00_JPRB,7.9304E+00_JPRB/)
KBO( :, 3,26,11) = (/&
&8.0376E-01_JPRB,3.2124E+00_JPRB,5.2452E+00_JPRB,6.8629E+00_JPRB,7.9361E+00_JPRB/)
KBO( :, 4,26,11) = (/&
&1.0358E+00_JPRB,3.3523E+00_JPRB,5.4003E+00_JPRB,7.0027E+00_JPRB,7.9285E+00_JPRB/)
KBO( :, 5,26,11) = (/&
&1.3073E+00_JPRB,3.4838E+00_JPRB,5.5299E+00_JPRB,7.1136E+00_JPRB,7.9075E+00_JPRB/)
KBO( :, 1,27,11) = (/&
&4.1952E-01_JPRB,2.9133E+00_JPRB,4.9160E+00_JPRB,6.5693E+00_JPRB,7.8901E+00_JPRB/)
KBO( :, 2,27,11) = (/&
&5.6911E-01_JPRB,3.0774E+00_JPRB,5.1132E+00_JPRB,6.7755E+00_JPRB,7.9378E+00_JPRB/)
KBO( :, 3,27,11) = (/&
&7.5273E-01_JPRB,3.2297E+00_JPRB,5.2948E+00_JPRB,6.9532E+00_JPRB,7.9707E+00_JPRB/)
KBO( :, 4,27,11) = (/&
&9.7351E-01_JPRB,3.3745E+00_JPRB,5.4563E+00_JPRB,7.1054E+00_JPRB,7.9865E+00_JPRB/)
KBO( :, 5,27,11) = (/&
&1.2293E+00_JPRB,3.5064E+00_JPRB,5.5938E+00_JPRB,7.2297E+00_JPRB,7.9857E+00_JPRB/)
KBO( :, 1,28,11) = (/&
&3.9524E-01_JPRB,2.9112E+00_JPRB,4.9316E+00_JPRB,6.6151E+00_JPRB,7.8478E+00_JPRB/)
KBO( :, 2,28,11) = (/&
&5.3765E-01_JPRB,3.0764E+00_JPRB,5.1350E+00_JPRB,6.8313E+00_JPRB,7.9309E+00_JPRB/)
KBO( :, 3,28,11) = (/&
&7.1264E-01_JPRB,3.2343E+00_JPRB,5.3248E+00_JPRB,7.0207E+00_JPRB,7.9898E+00_JPRB/)
KBO( :, 4,28,11) = (/&
&9.1903E-01_JPRB,3.3816E+00_JPRB,5.4915E+00_JPRB,7.1844E+00_JPRB,8.0261E+00_JPRB/)
KBO( :, 5,28,11) = (/&
&1.1585E+00_JPRB,3.5178E+00_JPRB,5.6384E+00_JPRB,7.3251E+00_JPRB,8.0453E+00_JPRB/)
KBO( :, 1,29,11) = (/&
&3.7850E-01_JPRB,2.9006E+00_JPRB,4.9391E+00_JPRB,6.6424E+00_JPRB,7.8025E+00_JPRB/)
KBO( :, 2,29,11) = (/&
&5.1450E-01_JPRB,3.0673E+00_JPRB,5.1512E+00_JPRB,6.8720E+00_JPRB,7.9130E+00_JPRB/)
KBO( :, 3,29,11) = (/&
&6.7825E-01_JPRB,3.2303E+00_JPRB,5.3447E+00_JPRB,7.0744E+00_JPRB,7.9988E+00_JPRB/)
KBO( :, 4,29,11) = (/&
&8.7094E-01_JPRB,3.3797E+00_JPRB,5.5169E+00_JPRB,7.2525E+00_JPRB,8.0603E+00_JPRB/)
KBO( :, 5,29,11) = (/&
&1.0951E+00_JPRB,3.5266E+00_JPRB,5.6745E+00_JPRB,7.3989E+00_JPRB,8.0964E+00_JPRB/)
KBO( :, 1,30,11) = (/&
&3.6524E-01_JPRB,2.8876E+00_JPRB,4.9408E+00_JPRB,6.6613E+00_JPRB,7.7569E+00_JPRB/)
KBO( :, 2,30,11) = (/&
&4.9379E-01_JPRB,3.0581E+00_JPRB,5.1612E+00_JPRB,6.9058E+00_JPRB,7.8990E+00_JPRB/)
KBO( :, 3,30,11) = (/&
&6.4720E-01_JPRB,3.2216E+00_JPRB,5.3594E+00_JPRB,7.1246E+00_JPRB,8.0078E+00_JPRB/)
KBO( :, 4,30,11) = (/&
&8.2776E-01_JPRB,3.3773E+00_JPRB,5.5423E+00_JPRB,7.3074E+00_JPRB,8.0873E+00_JPRB/)
KBO( :, 5,30,11) = (/&
&1.0381E+00_JPRB,3.5327E+00_JPRB,5.7037E+00_JPRB,7.4625E+00_JPRB,8.1388E+00_JPRB/)
KBO( :, 1,31,11) = (/&
&3.5308E-01_JPRB,2.8782E+00_JPRB,4.9477E+00_JPRB,6.6803E+00_JPRB,7.7265E+00_JPRB/)
KBO( :, 2,31,11) = (/&
&4.7488E-01_JPRB,3.0504E+00_JPRB,5.1727E+00_JPRB,6.9441E+00_JPRB,7.8903E+00_JPRB/)
KBO( :, 3,31,11) = (/&
&6.2002E-01_JPRB,3.2131E+00_JPRB,5.3800E+00_JPRB,7.1680E+00_JPRB,8.0238E+00_JPRB/)
KBO( :, 4,31,11) = (/&
&7.9132E-01_JPRB,3.3767E+00_JPRB,5.5675E+00_JPRB,7.3599E+00_JPRB,8.1232E+00_JPRB/)
KBO( :, 5,31,11) = (/&
&9.9103E-01_JPRB,3.5400E+00_JPRB,5.7311E+00_JPRB,7.5249E+00_JPRB,8.1871E+00_JPRB/)
KBO( :, 1,32,11) = (/&
&3.4150E-01_JPRB,2.8720E+00_JPRB,4.9582E+00_JPRB,6.7133E+00_JPRB,7.7054E+00_JPRB/)
KBO( :, 2,32,11) = (/&
&4.5747E-01_JPRB,3.0437E+00_JPRB,5.1930E+00_JPRB,6.9826E+00_JPRB,7.9024E+00_JPRB/)
KBO( :, 3,32,11) = (/&
&5.9670E-01_JPRB,3.2099E+00_JPRB,5.4027E+00_JPRB,7.2169E+00_JPRB,8.0545E+00_JPRB/)
KBO( :, 4,32,11) = (/&
&7.6078E-01_JPRB,3.3797E+00_JPRB,5.5915E+00_JPRB,7.4162E+00_JPRB,8.1621E+00_JPRB/)
KBO( :, 5,32,11) = (/&
&9.5335E-01_JPRB,3.5468E+00_JPRB,5.7567E+00_JPRB,7.5820E+00_JPRB,8.2482E+00_JPRB/)
KBO( :, 1,33,11) = (/&
&3.3112E-01_JPRB,2.8707E+00_JPRB,4.9789E+00_JPRB,6.7544E+00_JPRB,7.7163E+00_JPRB/)
KBO( :, 2,33,11) = (/&
&4.4241E-01_JPRB,3.0429E+00_JPRB,5.2166E+00_JPRB,7.0302E+00_JPRB,7.9310E+00_JPRB/)
KBO( :, 3,33,11) = (/&
&5.7622E-01_JPRB,3.2140E+00_JPRB,5.4288E+00_JPRB,7.2705E+00_JPRB,8.0890E+00_JPRB/)
KBO( :, 4,33,11) = (/&
&7.3587E-01_JPRB,3.3885E+00_JPRB,5.6201E+00_JPRB,7.4720E+00_JPRB,8.2154E+00_JPRB/)
KBO( :, 5,33,11) = (/&
&9.2410E-01_JPRB,3.5572E+00_JPRB,5.7855E+00_JPRB,7.6373E+00_JPRB,8.3240E+00_JPRB/)
KBO( :, 1,34,11) = (/&
&3.1870E-01_JPRB,2.8673E+00_JPRB,5.0003E+00_JPRB,6.7932E+00_JPRB,7.7350E+00_JPRB/)
KBO( :, 2,34,11) = (/&
&4.2545E-01_JPRB,3.0410E+00_JPRB,5.2383E+00_JPRB,7.0757E+00_JPRB,7.9562E+00_JPRB/)
KBO( :, 3,34,11) = (/&
&5.5478E-01_JPRB,3.2165E+00_JPRB,5.4526E+00_JPRB,7.3185E+00_JPRB,8.1289E+00_JPRB/)
KBO( :, 4,34,11) = (/&
&7.0990E-01_JPRB,3.3947E+00_JPRB,5.6453E+00_JPRB,7.5211E+00_JPRB,8.2807E+00_JPRB/)
KBO( :, 5,34,11) = (/&
&8.9548E-01_JPRB,3.5658E+00_JPRB,5.8091E+00_JPRB,7.6845E+00_JPRB,8.3957E+00_JPRB/)
KBO( :, 1,35,11) = (/&
&2.9899E-01_JPRB,2.8528E+00_JPRB,5.0022E+00_JPRB,6.8098E+00_JPRB,7.7352E+00_JPRB/)
KBO( :, 2,35,11) = (/&
&4.0035E-01_JPRB,3.0296E+00_JPRB,5.2435E+00_JPRB,7.1001E+00_JPRB,7.9730E+00_JPRB/)
KBO( :, 3,35,11) = (/&
&5.2425E-01_JPRB,3.2088E+00_JPRB,5.4619E+00_JPRB,7.3466E+00_JPRB,8.1718E+00_JPRB/)
KBO( :, 4,35,11) = (/&
&6.7403E-01_JPRB,3.3885E+00_JPRB,5.6558E+00_JPRB,7.5526E+00_JPRB,8.3426E+00_JPRB/)
KBO( :, 5,35,11) = (/&
&8.5588E-01_JPRB,3.5636E+00_JPRB,5.8215E+00_JPRB,7.7184E+00_JPRB,8.4695E+00_JPRB/)
KBO( :, 1,36,11) = (/&
&2.7267E-01_JPRB,2.8247E+00_JPRB,4.9811E+00_JPRB,6.7967E+00_JPRB,7.7171E+00_JPRB/)
KBO( :, 2,36,11) = (/&
&3.6730E-01_JPRB,3.0036E+00_JPRB,5.2282E+00_JPRB,7.0962E+00_JPRB,7.9794E+00_JPRB/)
KBO( :, 3,36,11) = (/&
&4.8410E-01_JPRB,3.1863E+00_JPRB,5.4514E+00_JPRB,7.3517E+00_JPRB,8.2066E+00_JPRB/)
KBO( :, 4,36,11) = (/&
&6.2745E-01_JPRB,3.3693E+00_JPRB,5.6486E+00_JPRB,7.5634E+00_JPRB,8.3923E+00_JPRB/)
KBO( :, 5,36,11) = (/&
&8.0265E-01_JPRB,3.5462E+00_JPRB,5.8174E+00_JPRB,7.7338E+00_JPRB,8.5363E+00_JPRB/)
KBO( :, 1,37,11) = (/&
&2.3789E-01_JPRB,2.7731E+00_JPRB,4.9241E+00_JPRB,6.7346E+00_JPRB,7.6594E+00_JPRB/)
KBO( :, 2,37,11) = (/&
&3.2371E-01_JPRB,2.9546E+00_JPRB,5.1797E+00_JPRB,7.0518E+00_JPRB,7.9502E+00_JPRB/)
KBO( :, 3,37,11) = (/&
&4.3093E-01_JPRB,3.1396E+00_JPRB,5.4103E+00_JPRB,7.3206E+00_JPRB,8.2067E+00_JPRB/)
KBO( :, 4,37,11) = (/&
&5.6432E-01_JPRB,3.3261E+00_JPRB,5.6154E+00_JPRB,7.5430E+00_JPRB,8.4107E+00_JPRB/)
KBO( :, 5,37,11) = (/&
&7.2921E-01_JPRB,3.5055E+00_JPRB,5.7906E+00_JPRB,7.7231E+00_JPRB,8.5767E+00_JPRB/)
KBO( :, 1,38,11) = (/&
&2.0735E-01_JPRB,2.7246E+00_JPRB,4.8643E+00_JPRB,6.6686E+00_JPRB,7.6002E+00_JPRB/)
KBO( :, 2,38,11) = (/&
&2.8530E-01_JPRB,2.9075E+00_JPRB,5.1303E+00_JPRB,7.0023E+00_JPRB,7.9233E+00_JPRB/)
KBO( :, 3,38,11) = (/&
&3.8349E-01_JPRB,3.0952E+00_JPRB,5.3688E+00_JPRB,7.2838E+00_JPRB,8.2079E+00_JPRB/)
KBO( :, 4,38,11) = (/&
&5.0781E-01_JPRB,3.2834E+00_JPRB,5.5805E+00_JPRB,7.5172E+00_JPRB,8.4321E+00_JPRB/)
KBO( :, 5,38,11) = (/&
&6.6307E-01_JPRB,3.4663E+00_JPRB,5.7630E+00_JPRB,7.7072E+00_JPRB,8.6191E+00_JPRB/)
KBO( :, 1,39,11) = (/&
&1.8082E-01_JPRB,2.6797E+00_JPRB,4.8064E+00_JPRB,6.6001E+00_JPRB,7.5476E+00_JPRB/)
KBO( :, 2,39,11) = (/&
&2.5186E-01_JPRB,2.8651E+00_JPRB,5.0819E+00_JPRB,6.9495E+00_JPRB,7.9070E+00_JPRB/)
KBO( :, 3,39,11) = (/&
&3.4240E-01_JPRB,3.0532E+00_JPRB,5.3282E+00_JPRB,7.2446E+00_JPRB,8.2139E+00_JPRB/)
KBO( :, 4,39,11) = (/&
&4.5842E-01_JPRB,3.2439E+00_JPRB,5.5467E+00_JPRB,7.4896E+00_JPRB,8.4602E+00_JPRB/)
KBO( :, 5,39,11) = (/&
&6.0509E-01_JPRB,3.4298E+00_JPRB,5.7341E+00_JPRB,7.6881E+00_JPRB,8.6682E+00_JPRB/)
KBO( :, 1,40,11) = (/&
&1.5207E-01_JPRB,2.6179E+00_JPRB,4.7176E+00_JPRB,6.4886E+00_JPRB,7.4449E+00_JPRB/)
KBO( :, 2,40,11) = (/&
&2.1512E-01_JPRB,2.8059E+00_JPRB,5.0086E+00_JPRB,6.8609E+00_JPRB,7.8328E+00_JPRB/)
KBO( :, 3,40,11) = (/&
&2.9689E-01_JPRB,2.9943E+00_JPRB,5.2638E+00_JPRB,7.1743E+00_JPRB,8.1664E+00_JPRB/)
KBO( :, 4,40,11) = (/&
&4.0254E-01_JPRB,3.1876E+00_JPRB,5.4913E+00_JPRB,7.4357E+00_JPRB,8.4349E+00_JPRB/)
KBO( :, 5,40,11) = (/&
&5.3785E-01_JPRB,3.3763E+00_JPRB,5.6880E+00_JPRB,7.6474E+00_JPRB,8.6627E+00_JPRB/)
KBO( :, 1,41,11) = (/&
&1.2695E-01_JPRB,2.5542E+00_JPRB,4.6228E+00_JPRB,6.3672E+00_JPRB,7.3294E+00_JPRB/)
KBO( :, 2,41,11) = (/&
&1.8252E-01_JPRB,2.7470E+00_JPRB,4.9288E+00_JPRB,6.7628E+00_JPRB,7.7447E+00_JPRB/)
KBO( :, 3,41,11) = (/&
&2.5614E-01_JPRB,2.9363E+00_JPRB,5.1938E+00_JPRB,7.0965E+00_JPRB,8.1064E+00_JPRB/)
KBO( :, 4,41,11) = (/&
&3.5214E-01_JPRB,3.1287E+00_JPRB,5.4316E+00_JPRB,7.3741E+00_JPRB,8.3985E+00_JPRB/)
KBO( :, 5,41,11) = (/&
&4.7642E-01_JPRB,3.3197E+00_JPRB,5.6390E+00_JPRB,7.5995E+00_JPRB,8.6452E+00_JPRB/)
KBO( :, 1,42,11) = (/&
&1.0572E-01_JPRB,2.4914E+00_JPRB,4.5264E+00_JPRB,6.2425E+00_JPRB,7.2103E+00_JPRB/)
KBO( :, 2,42,11) = (/&
&1.5450E-01_JPRB,2.6890E+00_JPRB,4.8460E+00_JPRB,6.6593E+00_JPRB,7.6506E+00_JPRB/)
KBO( :, 3,42,11) = (/&
&2.2046E-01_JPRB,2.8775E+00_JPRB,5.1228E+00_JPRB,7.0129E+00_JPRB,8.0405E+00_JPRB/)
KBO( :, 4,42,11) = (/&
&3.0794E-01_JPRB,3.0704E+00_JPRB,5.3705E+00_JPRB,7.3070E+00_JPRB,8.3576E+00_JPRB/)
KBO( :, 5,42,11) = (/&
&4.2243E-01_JPRB,3.2655E+00_JPRB,5.5859E+00_JPRB,7.5484E+00_JPRB,8.6234E+00_JPRB/)
KBO( :, 1,43,11) = (/&
&8.5799E-02_JPRB,2.4158E+00_JPRB,4.4064E+00_JPRB,6.0854E+00_JPRB,7.0535E+00_JPRB/)
KBO( :, 2,43,11) = (/&
&1.2776E-01_JPRB,2.6198E+00_JPRB,4.7439E+00_JPRB,6.5289E+00_JPRB,7.5260E+00_JPRB/)
KBO( :, 3,43,11) = (/&
&1.8555E-01_JPRB,2.8110E+00_JPRB,5.0358E+00_JPRB,6.9052E+00_JPRB,7.9459E+00_JPRB/)
KBO( :, 4,43,11) = (/&
&2.6399E-01_JPRB,3.0044E+00_JPRB,5.2930E+00_JPRB,7.2200E+00_JPRB,8.2902E+00_JPRB/)
KBO( :, 5,43,11) = (/&
&3.6761E-01_JPRB,3.2003E+00_JPRB,5.5191E+00_JPRB,7.4799E+00_JPRB,8.5786E+00_JPRB/)
KBO( :, 1,44,11) = (/&
&6.8535E-02_JPRB,2.3354E+00_JPRB,4.2721E+00_JPRB,5.9087E+00_JPRB,6.8762E+00_JPRB/)
KBO( :, 2,44,11) = (/&
&1.0421E-01_JPRB,2.5468E+00_JPRB,4.6283E+00_JPRB,6.3792E+00_JPRB,7.3815E+00_JPRB/)
KBO( :, 3,44,11) = (/&
&1.5420E-01_JPRB,2.7418E+00_JPRB,4.9358E+00_JPRB,6.7810E+00_JPRB,7.8336E+00_JPRB/)
KBO( :, 4,44,11) = (/&
&2.2347E-01_JPRB,2.9335E+00_JPRB,5.2044E+00_JPRB,7.1195E+00_JPRB,8.2083E+00_JPRB/)
KBO( :, 5,44,11) = (/&
&3.1682E-01_JPRB,3.1294E+00_JPRB,5.4461E+00_JPRB,7.3981E+00_JPRB,8.5217E+00_JPRB/)
KBO( :, 1,45,11) = (/&
&5.4457E-02_JPRB,2.2535E+00_JPRB,4.1320E+00_JPRB,5.7238E+00_JPRB,6.6894E+00_JPRB/)
KBO( :, 2,45,11) = (/&
&8.4549E-02_JPRB,2.4711E+00_JPRB,4.5065E+00_JPRB,6.2198E+00_JPRB,7.2293E+00_JPRB/)
KBO( :, 3,45,11) = (/&
&1.2761E-01_JPRB,2.6717E+00_JPRB,4.8324E+00_JPRB,6.6492E+00_JPRB,7.7146E+00_JPRB/)
KBO( :, 4,45,11) = (/&
&1.8837E-01_JPRB,2.8633E+00_JPRB,5.1155E+00_JPRB,7.0100E+00_JPRB,8.1205E+00_JPRB/)
KBO( :, 5,45,11) = (/&
&2.7227E-01_JPRB,3.0592E+00_JPRB,5.3653E+00_JPRB,7.3089E+00_JPRB,8.4600E+00_JPRB/)
KBO( :, 1,46,11) = (/&
&4.2589E-02_JPRB,2.1649E+00_JPRB,3.9784E+00_JPRB,5.5163E+00_JPRB,6.4796E+00_JPRB/)
KBO( :, 2,46,11) = (/&
&6.7560E-02_JPRB,2.3893E+00_JPRB,4.3722E+00_JPRB,6.0430E+00_JPRB,7.0551E+00_JPRB/)
KBO( :, 3,46,11) = (/&
&1.0417E-01_JPRB,2.5968E+00_JPRB,4.7173E+00_JPRB,6.4988E+00_JPRB,7.5749E+00_JPRB/)
KBO( :, 4,46,11) = (/&
&1.5686E-01_JPRB,2.7912E+00_JPRB,5.0150E+00_JPRB,6.8844E+00_JPRB,8.0167E+00_JPRB/)
KBO( :, 5,46,11) = (/&
&2.3102E-01_JPRB,2.9860E+00_JPRB,5.2763E+00_JPRB,7.2084E+00_JPRB,8.3844E+00_JPRB/)
KBO( :, 1,47,11) = (/&
&3.2329E-02_JPRB,2.0635E+00_JPRB,3.7990E+00_JPRB,5.2746E+00_JPRB,6.2270E+00_JPRB/)
KBO( :, 2,47,11) = (/&
&5.2621E-02_JPRB,2.2974E+00_JPRB,4.2140E+00_JPRB,5.8338E+00_JPRB,6.8413E+00_JPRB/)
KBO( :, 3,47,11) = (/&
&8.2966E-02_JPRB,2.5124E+00_JPRB,4.5790E+00_JPRB,6.3183E+00_JPRB,7.3957E+00_JPRB/)
KBO( :, 4,47,11) = (/&
&1.2765E-01_JPRB,2.7111E+00_JPRB,4.8962E+00_JPRB,6.7355E+00_JPRB,7.8773E+00_JPRB/)
KBO( :, 5,47,11) = (/&
&1.9183E-01_JPRB,2.9039E+00_JPRB,5.1733E+00_JPRB,7.0849E+00_JPRB,8.2769E+00_JPRB/)
KBO( :, 1,48,11) = (/&
&2.4260E-02_JPRB,1.9590E+00_JPRB,3.6114E+00_JPRB,5.0219E+00_JPRB,5.9614E+00_JPRB/)
KBO( :, 2,48,11) = (/&
&4.0661E-02_JPRB,2.2016E+00_JPRB,4.0471E+00_JPRB,5.6109E+00_JPRB,6.6162E+00_JPRB/)
KBO( :, 3,48,11) = (/&
&6.5567E-02_JPRB,2.4242E+00_JPRB,4.4350E+00_JPRB,6.1272E+00_JPRB,7.2066E+00_JPRB/)
KBO( :, 4,48,11) = (/&
&1.0316E-01_JPRB,2.6297E+00_JPRB,4.7726E+00_JPRB,6.5740E+00_JPRB,7.7277E+00_JPRB/)
KBO( :, 5,48,11) = (/&
&1.5827E-01_JPRB,2.8235E+00_JPRB,5.0650E+00_JPRB,6.9498E+00_JPRB,8.1636E+00_JPRB/)
KBO( :, 1,49,11) = (/&
&1.7994E-02_JPRB,1.8499E+00_JPRB,3.4182E+00_JPRB,4.7557E+00_JPRB,5.6860E+00_JPRB/)
KBO( :, 2,49,11) = (/&
&3.1088E-02_JPRB,2.1039E+00_JPRB,3.8735E+00_JPRB,5.3754E+00_JPRB,6.3833E+00_JPRB/)
KBO( :, 3,49,11) = (/&
&5.1455E-02_JPRB,2.3348E+00_JPRB,4.2824E+00_JPRB,5.9252E+00_JPRB,7.0121E+00_JPRB/)
KBO( :, 4,49,11) = (/&
&8.2689E-02_JPRB,2.5471E+00_JPRB,4.6395E+00_JPRB,6.4001E+00_JPRB,7.5720E+00_JPRB/)
KBO( :, 5,49,11) = (/&
&1.2977E-01_JPRB,2.7449E+00_JPRB,4.9494E+00_JPRB,6.8054E+00_JPRB,8.0481E+00_JPRB/)
KBO( :, 1,50,11) = (/&
&1.3371E-02_JPRB,1.7459E+00_JPRB,3.2314E+00_JPRB,4.4954E+00_JPRB,5.4078E+00_JPRB/)
KBO( :, 2,50,11) = (/&
&2.3833E-02_JPRB,2.0084E+00_JPRB,3.7026E+00_JPRB,5.1456E+00_JPRB,6.1414E+00_JPRB/)
KBO( :, 3,50,11) = (/&
&4.0559E-02_JPRB,2.2474E+00_JPRB,4.1296E+00_JPRB,5.7236E+00_JPRB,6.8056E+00_JPRB/)
KBO( :, 4,50,11) = (/&
&6.6648E-02_JPRB,2.4671E+00_JPRB,4.5076E+00_JPRB,6.2258E+00_JPRB,7.4018E+00_JPRB/)
KBO( :, 5,50,11) = (/&
&1.0683E-01_JPRB,2.6694E+00_JPRB,4.8363E+00_JPRB,6.6602E+00_JPRB,7.9136E+00_JPRB/)
KBO( :, 1,51,11) = (/&
&9.8653E-03_JPRB,1.6429E+00_JPRB,3.0451E+00_JPRB,4.2358E+00_JPRB,5.1231E+00_JPRB/)
KBO( :, 2,51,11) = (/&
&1.8201E-02_JPRB,1.9124E+00_JPRB,3.5299E+00_JPRB,4.9113E+00_JPRB,5.8903E+00_JPRB/)
KBO( :, 3,51,11) = (/&
&3.1898E-02_JPRB,2.1605E+00_JPRB,3.9764E+00_JPRB,5.5162E+00_JPRB,6.5869E+00_JPRB/)
KBO( :, 4,51,11) = (/&
&5.3712E-02_JPRB,2.3869E+00_JPRB,4.3743E+00_JPRB,6.0489E+00_JPRB,7.2173E+00_JPRB/)
KBO( :, 5,51,11) = (/&
&8.7772E-02_JPRB,2.5955E+00_JPRB,4.7209E+00_JPRB,6.5087E+00_JPRB,7.7625E+00_JPRB/)
KBO( :, 1,52,11) = (/&
&7.1653E-03_JPRB,1.5381E+00_JPRB,2.8544E+00_JPRB,3.9674E+00_JPRB,4.8308E+00_JPRB/)
KBO( :, 2,52,11) = (/&
&1.3765E-02_JPRB,1.8137E+00_JPRB,3.3544E+00_JPRB,4.6675E+00_JPRB,5.6327E+00_JPRB/)
KBO( :, 3,52,11) = (/&
&2.4855E-02_JPRB,2.0712E+00_JPRB,3.8173E+00_JPRB,5.3003E+00_JPRB,6.3625E+00_JPRB/)
KBO( :, 4,52,11) = (/&
&4.3007E-02_JPRB,2.3053E+00_JPRB,4.2329E+00_JPRB,5.8617E+00_JPRB,7.0261E+00_JPRB/)
KBO( :, 5,52,11) = (/&
&7.1746E-02_JPRB,2.5209E+00_JPRB,4.5976E+00_JPRB,6.3464E+00_JPRB,7.6074E+00_JPRB/)
KBO( :, 1,53,11) = (/&
&5.1115E-03_JPRB,1.4319E+00_JPRB,2.6598E+00_JPRB,3.6923E+00_JPRB,4.5327E+00_JPRB/)
KBO( :, 2,53,11) = (/&
&1.0264E-02_JPRB,1.7132E+00_JPRB,3.1732E+00_JPRB,4.4138E+00_JPRB,5.3644E+00_JPRB/)
KBO( :, 3,53,11) = (/&
&1.9168E-02_JPRB,1.9787E+00_JPRB,3.6497E+00_JPRB,5.0750E+00_JPRB,6.1311E+00_JPRB/)
KBO( :, 4,53,11) = (/&
&3.4142E-02_JPRB,2.2206E+00_JPRB,4.0841E+00_JPRB,5.6629E+00_JPRB,6.8305E+00_JPRB/)
KBO( :, 5,53,11) = (/&
&5.8320E-02_JPRB,2.4429E+00_JPRB,4.4694E+00_JPRB,6.1755E+00_JPRB,7.4521E+00_JPRB/)
KBO( :, 1,54,11) = (/&
&3.6599E-03_JPRB,1.3331E+00_JPRB,2.4769E+00_JPRB,3.4372E+00_JPRB,4.2368E+00_JPRB/)
KBO( :, 2,54,11) = (/&
&7.6954E-03_JPRB,1.6189E+00_JPRB,3.0020E+00_JPRB,4.1755E+00_JPRB,5.0910E+00_JPRB/)
KBO( :, 3,54,11) = (/&
&1.4927E-02_JPRB,1.8903E+00_JPRB,3.4914E+00_JPRB,4.8585E+00_JPRB,5.8811E+00_JPRB/)
KBO( :, 4,54,11) = (/&
&2.7354E-02_JPRB,2.1411E+00_JPRB,3.9432E+00_JPRB,5.4718E+00_JPRB,6.6071E+00_JPRB/)
KBO( :, 5,54,11) = (/&
&4.7880E-02_JPRB,2.3694E+00_JPRB,4.3455E+00_JPRB,6.0119E+00_JPRB,7.2530E+00_JPRB/)
KBO( :, 1,55,11) = (/&
&2.6041E-03_JPRB,1.2377E+00_JPRB,2.2999E+00_JPRB,3.1900E+00_JPRB,3.9377E+00_JPRB/)
KBO( :, 2,55,11) = (/&
&5.7429E-03_JPRB,1.5271E+00_JPRB,2.8349E+00_JPRB,3.9397E+00_JPRB,4.8084E+00_JPRB/)
KBO( :, 3,55,11) = (/&
&1.1607E-02_JPRB,1.8036E+00_JPRB,3.3372E+00_JPRB,4.6433E+00_JPRB,5.6183E+00_JPRB/)
KBO( :, 4,55,11) = (/&
&2.1919E-02_JPRB,2.0624E+00_JPRB,3.8024E+00_JPRB,5.2808E+00_JPRB,6.3606E+00_JPRB/)
KBO( :, 5,55,11) = (/&
&3.9357E-02_JPRB,2.2976E+00_JPRB,4.2205E+00_JPRB,5.8462E+00_JPRB,7.0320E+00_JPRB/)
KBO( :, 1,56,11) = (/&
&1.8212E-03_JPRB,1.1423E+00_JPRB,2.1234E+00_JPRB,2.9415E+00_JPRB,3.6402E+00_JPRB/)
KBO( :, 2,56,11) = (/&
&4.2220E-03_JPRB,1.4344E+00_JPRB,2.6648E+00_JPRB,3.6993E+00_JPRB,4.5216E+00_JPRB/)
KBO( :, 3,56,11) = (/&
&8.9199E-03_JPRB,1.7161E+00_JPRB,3.1791E+00_JPRB,4.4224E+00_JPRB,5.3514E+00_JPRB/)
KBO( :, 4,56,11) = (/&
&1.7443E-02_JPRB,1.9818E+00_JPRB,3.6561E+00_JPRB,5.0841E+00_JPRB,6.1109E+00_JPRB/)
KBO( :, 5,56,11) = (/&
&3.2146E-02_JPRB,2.2236E+00_JPRB,4.0904E+00_JPRB,5.6718E+00_JPRB,6.8038E+00_JPRB/)
KBO( :, 1,57,11) = (/&
&1.2487E-03_JPRB,1.0475E+00_JPRB,1.9452E+00_JPRB,2.6920E+00_JPRB,3.3454E+00_JPRB/)
KBO( :, 2,57,11) = (/&
&3.0556E-03_JPRB,1.3407E+00_JPRB,2.4912E+00_JPRB,3.4567E+00_JPRB,4.2318E+00_JPRB/)
KBO( :, 3,57,11) = (/&
&6.7633E-03_JPRB,1.6266E+00_JPRB,3.0165E+00_JPRB,4.1956E+00_JPRB,5.0790E+00_JPRB/)
KBO( :, 4,57,11) = (/&
&1.3762E-02_JPRB,1.8981E+00_JPRB,3.5056E+00_JPRB,4.8781E+00_JPRB,5.8578E+00_JPRB/)
KBO( :, 5,57,11) = (/&
&2.6062E-02_JPRB,2.1481E+00_JPRB,3.9566E+00_JPRB,5.4903E+00_JPRB,6.5663E+00_JPRB/)
KBO( :, 1,58,11) = (/&
&8.5190E-04_JPRB,9.5769E-01_JPRB,1.7770E+00_JPRB,2.4580E+00_JPRB,3.0673E+00_JPRB/)
KBO( :, 2,58,11) = (/&
&2.2048E-03_JPRB,1.2510E+00_JPRB,2.3247E+00_JPRB,3.2249E+00_JPRB,3.9528E+00_JPRB/)
KBO( :, 3,58,11) = (/&
&5.1227E-03_JPRB,1.5404E+00_JPRB,2.8593E+00_JPRB,3.9742E+00_JPRB,4.8120E+00_JPRB/)
KBO( :, 4,58,11) = (/&
&1.0857E-02_JPRB,1.8165E+00_JPRB,3.3607E+00_JPRB,4.6761E+00_JPRB,5.6102E+00_JPRB/)
KBO( :, 5,58,11) = (/&
&2.1207E-02_JPRB,2.0743E+00_JPRB,3.8247E+00_JPRB,5.3111E+00_JPRB,6.3315E+00_JPRB/)
KBO( :, 1,59,11) = (/&
&6.9156E-04_JPRB,9.2148E-01_JPRB,1.7091E+00_JPRB,2.3639E+00_JPRB,2.9470E+00_JPRB/)
KBO( :, 2,59,11) = (/&
&1.8554E-03_JPRB,1.2146E+00_JPRB,2.2573E+00_JPRB,3.1301E+00_JPRB,3.8229E+00_JPRB/)
KBO( :, 3,59,11) = (/&
&4.4546E-03_JPRB,1.5052E+00_JPRB,2.7951E+00_JPRB,3.8834E+00_JPRB,4.6728E+00_JPRB/)
KBO( :, 4,59,11) = (/&
&9.7022E-03_JPRB,1.7833E+00_JPRB,3.3009E+00_JPRB,4.5928E+00_JPRB,5.4696E+00_JPRB/)
KBO( :, 5,59,11) = (/&
&1.9310E-02_JPRB,2.0440E+00_JPRB,3.7699E+00_JPRB,5.2372E+00_JPRB,6.1828E+00_JPRB/)
KBO( :, 1,13,12) = (/&
&1.6565E+00_JPRB,1.7848E+00_JPRB,2.5700E+00_JPRB,3.5717E+00_JPRB,4.5988E+00_JPRB/)
KBO( :, 2,13,12) = (/&
&2.4215E+00_JPRB,2.1271E+00_JPRB,2.6999E+00_JPRB,3.5485E+00_JPRB,4.4641E+00_JPRB/)
KBO( :, 3,13,12) = (/&
&3.3369E+00_JPRB,2.6815E+00_JPRB,2.9576E+00_JPRB,3.5009E+00_JPRB,4.3216E+00_JPRB/)
KBO( :, 4,13,12) = (/&
&4.4039E+00_JPRB,3.4401E+00_JPRB,3.2679E+00_JPRB,3.4869E+00_JPRB,4.1798E+00_JPRB/)
KBO( :, 5,13,12) = (/&
&5.5941E+00_JPRB,4.3251E+00_JPRB,3.6079E+00_JPRB,3.5523E+00_JPRB,4.0718E+00_JPRB/)
KBO( :, 1,14,12) = (/&
&1.7762E+00_JPRB,1.9421E+00_JPRB,2.7864E+00_JPRB,3.8795E+00_JPRB,4.9959E+00_JPRB/)
KBO( :, 2,14,12) = (/&
&2.5729E+00_JPRB,2.3289E+00_JPRB,2.9407E+00_JPRB,3.8344E+00_JPRB,4.8460E+00_JPRB/)
KBO( :, 3,14,12) = (/&
&3.5256E+00_JPRB,2.8532E+00_JPRB,3.1735E+00_JPRB,3.7815E+00_JPRB,4.6937E+00_JPRB/)
KBO( :, 4,14,12) = (/&
&4.6225E+00_JPRB,3.6062E+00_JPRB,3.4878E+00_JPRB,3.7727E+00_JPRB,4.5592E+00_JPRB/)
KBO( :, 5,14,12) = (/&
&5.8383E+00_JPRB,4.5040E+00_JPRB,3.8887E+00_JPRB,3.8650E+00_JPRB,4.4445E+00_JPRB/)
KBO( :, 1,15,12) = (/&
&1.8721E+00_JPRB,2.1191E+00_JPRB,3.0241E+00_JPRB,4.2075E+00_JPRB,5.4430E+00_JPRB/)
KBO( :, 2,15,12) = (/&
&2.6862E+00_JPRB,2.5250E+00_JPRB,3.1995E+00_JPRB,4.1499E+00_JPRB,5.2993E+00_JPRB/)
KBO( :, 3,15,12) = (/&
&3.6549E+00_JPRB,3.0295E+00_JPRB,3.4400E+00_JPRB,4.1044E+00_JPRB,5.1665E+00_JPRB/)
KBO( :, 4,15,12) = (/&
&4.7570E+00_JPRB,3.7259E+00_JPRB,3.7691E+00_JPRB,4.1180E+00_JPRB,5.0472E+00_JPRB/)
KBO( :, 5,15,12) = (/&
&5.9648E+00_JPRB,4.5949E+00_JPRB,4.1611E+00_JPRB,4.2079E+00_JPRB,4.9426E+00_JPRB/)
KBO( :, 1,16,12) = (/&
&1.9290E+00_JPRB,2.3038E+00_JPRB,3.3146E+00_JPRB,4.6435E+00_JPRB,6.0407E+00_JPRB/)
KBO( :, 2,16,12) = (/&
&2.7431E+00_JPRB,2.7084E+00_JPRB,3.4673E+00_JPRB,4.5698E+00_JPRB,5.8966E+00_JPRB/)
KBO( :, 3,16,12) = (/&
&3.6970E+00_JPRB,3.2040E+00_JPRB,3.7345E+00_JPRB,4.5214E+00_JPRB,5.7687E+00_JPRB/)
KBO( :, 4,16,12) = (/&
&4.7715E+00_JPRB,3.8272E+00_JPRB,4.0666E+00_JPRB,4.5545E+00_JPRB,5.6476E+00_JPRB/)
KBO( :, 5,16,12) = (/&
&5.9496E+00_JPRB,4.6127E+00_JPRB,4.4402E+00_JPRB,4.6207E+00_JPRB,5.5338E+00_JPRB/)
KBO( :, 1,17,12) = (/&
&1.9373E+00_JPRB,2.4828E+00_JPRB,3.6697E+00_JPRB,5.1796E+00_JPRB,6.7612E+00_JPRB/)
KBO( :, 2,17,12) = (/&
&2.7255E+00_JPRB,2.8755E+00_JPRB,3.8159E+00_JPRB,5.1042E+00_JPRB,6.6167E+00_JPRB/)
KBO( :, 3,17,12) = (/&
&3.6395E+00_JPRB,3.3552E+00_JPRB,4.0591E+00_JPRB,5.0640E+00_JPRB,6.4791E+00_JPRB/)
KBO( :, 4,17,12) = (/&
&4.6714E+00_JPRB,3.9092E+00_JPRB,4.3629E+00_JPRB,5.0919E+00_JPRB,6.3471E+00_JPRB/)
KBO( :, 5,17,12) = (/&
&5.8138E+00_JPRB,4.6040E+00_JPRB,4.7123E+00_JPRB,5.1320E+00_JPRB,6.2136E+00_JPRB/)
KBO( :, 1,18,12) = (/&
&1.8923E+00_JPRB,2.6601E+00_JPRB,4.0950E+00_JPRB,5.7689E+00_JPRB,7.5292E+00_JPRB/)
KBO( :, 2,18,12) = (/&
&2.6358E+00_JPRB,3.0291E+00_JPRB,4.2495E+00_JPRB,5.7045E+00_JPRB,7.3896E+00_JPRB/)
KBO( :, 3,18,12) = (/&
&3.5005E+00_JPRB,3.4699E+00_JPRB,4.4508E+00_JPRB,5.6824E+00_JPRB,7.2449E+00_JPRB/)
KBO( :, 4,18,12) = (/&
&4.4831E+00_JPRB,3.9859E+00_JPRB,4.6968E+00_JPRB,5.6976E+00_JPRB,7.0972E+00_JPRB/)
KBO( :, 5,18,12) = (/&
&5.5803E+00_JPRB,4.6005E+00_JPRB,4.9912E+00_JPRB,5.7191E+00_JPRB,6.9473E+00_JPRB/)
KBO( :, 1,19,12) = (/&
&1.8026E+00_JPRB,2.8675E+00_JPRB,4.5643E+00_JPRB,6.3966E+00_JPRB,8.3446E+00_JPRB/)
KBO( :, 2,19,12) = (/&
&2.4955E+00_JPRB,3.1750E+00_JPRB,4.7346E+00_JPRB,6.3280E+00_JPRB,8.1858E+00_JPRB/)
KBO( :, 3,19,12) = (/&
&3.3065E+00_JPRB,3.5656E+00_JPRB,4.9096E+00_JPRB,6.3278E+00_JPRB,8.0274E+00_JPRB/)
KBO( :, 4,19,12) = (/&
&4.2336E+00_JPRB,4.0373E+00_JPRB,5.1018E+00_JPRB,6.3400E+00_JPRB,7.8734E+00_JPRB/)
KBO( :, 5,19,12) = (/&
&5.2638E+00_JPRB,4.5965E+00_JPRB,5.3281E+00_JPRB,6.3749E+00_JPRB,7.7186E+00_JPRB/)
KBO( :, 1,20,12) = (/&
&1.6924E+00_JPRB,3.1159E+00_JPRB,5.0615E+00_JPRB,7.0193E+00_JPRB,9.1509E+00_JPRB/)
KBO( :, 2,20,12) = (/&
&2.3342E+00_JPRB,3.3609E+00_JPRB,5.2475E+00_JPRB,6.9651E+00_JPRB,8.9802E+00_JPRB/)
KBO( :, 3,20,12) = (/&
&3.0883E+00_JPRB,3.6808E+00_JPRB,5.4216E+00_JPRB,6.9801E+00_JPRB,8.8129E+00_JPRB/)
KBO( :, 4,20,12) = (/&
&3.9463E+00_JPRB,4.0848E+00_JPRB,5.5777E+00_JPRB,7.0012E+00_JPRB,8.6463E+00_JPRB/)
KBO( :, 5,20,12) = (/&
&4.8961E+00_JPRB,4.5736E+00_JPRB,5.7512E+00_JPRB,7.0663E+00_JPRB,8.4743E+00_JPRB/)
KBO( :, 1,21,12) = (/&
&1.5690E+00_JPRB,3.3918E+00_JPRB,5.5679E+00_JPRB,7.6325E+00_JPRB,9.9359E+00_JPRB/)
KBO( :, 2,21,12) = (/&
&2.1586E+00_JPRB,3.5959E+00_JPRB,5.7632E+00_JPRB,7.6131E+00_JPRB,9.7631E+00_JPRB/)
KBO( :, 3,21,12) = (/&
&2.8476E+00_JPRB,3.8439E+00_JPRB,5.9415E+00_JPRB,7.6317E+00_JPRB,9.5829E+00_JPRB/)
KBO( :, 4,21,12) = (/&
&3.6276E+00_JPRB,4.1634E+00_JPRB,6.0894E+00_JPRB,7.6838E+00_JPRB,9.4023E+00_JPRB/)
KBO( :, 5,21,12) = (/&
&4.4917E+00_JPRB,4.5642E+00_JPRB,6.2271E+00_JPRB,7.7630E+00_JPRB,9.2137E+00_JPRB/)
KBO( :, 1,22,12) = (/&
&1.4699E+00_JPRB,3.6838E+00_JPRB,6.0744E+00_JPRB,8.2202E+00_JPRB,1.0664E+01_JPRB/)
KBO( :, 2,22,12) = (/&
&2.0081E+00_JPRB,3.8770E+00_JPRB,6.2779E+00_JPRB,8.2401E+00_JPRB,1.0485E+01_JPRB/)
KBO( :, 3,22,12) = (/&
&2.6322E+00_JPRB,4.0768E+00_JPRB,6.4526E+00_JPRB,8.2804E+00_JPRB,1.0306E+01_JPRB/)
KBO( :, 4,22,12) = (/&
&3.3385E+00_JPRB,4.3174E+00_JPRB,6.6003E+00_JPRB,8.3666E+00_JPRB,1.0115E+01_JPRB/)
KBO( :, 5,22,12) = (/&
&4.1224E+00_JPRB,4.6294E+00_JPRB,6.7220E+00_JPRB,8.4420E+00_JPRB,9.9167E+00_JPRB/)
KBO( :, 1,23,12) = (/&
&1.3635E+00_JPRB,3.9535E+00_JPRB,6.5578E+00_JPRB,8.7891E+00_JPRB,1.1317E+01_JPRB/)
KBO( :, 2,23,12) = (/&
&1.8479E+00_JPRB,4.1472E+00_JPRB,6.7653E+00_JPRB,8.8306E+00_JPRB,1.1151E+01_JPRB/)
KBO( :, 3,23,12) = (/&
&2.4090E+00_JPRB,4.3291E+00_JPRB,6.9299E+00_JPRB,8.9124E+00_JPRB,1.0971E+01_JPRB/)
KBO( :, 4,23,12) = (/&
&3.0476E+00_JPRB,4.5186E+00_JPRB,7.0757E+00_JPRB,9.0158E+00_JPRB,1.0781E+01_JPRB/)
KBO( :, 5,23,12) = (/&
&3.7677E+00_JPRB,4.7466E+00_JPRB,7.1916E+00_JPRB,9.0858E+00_JPRB,1.0580E+01_JPRB/)
KBO( :, 1,24,12) = (/&
&1.2524E+00_JPRB,4.1964E+00_JPRB,7.0027E+00_JPRB,9.3088E+00_JPRB,1.1891E+01_JPRB/)
KBO( :, 2,24,12) = (/&
&1.6860E+00_JPRB,4.3866E+00_JPRB,7.2061E+00_JPRB,9.3894E+00_JPRB,1.1740E+01_JPRB/)
KBO( :, 3,24,12) = (/&
&2.1916E+00_JPRB,4.5632E+00_JPRB,7.3707E+00_JPRB,9.5161E+00_JPRB,1.1574E+01_JPRB/)
KBO( :, 4,24,12) = (/&
&2.7755E+00_JPRB,4.7310E+00_JPRB,7.5040E+00_JPRB,9.6239E+00_JPRB,1.1390E+01_JPRB/)
KBO( :, 5,24,12) = (/&
&3.4421E+00_JPRB,4.9112E+00_JPRB,7.6141E+00_JPRB,9.6873E+00_JPRB,1.1189E+01_JPRB/)
KBO( :, 1,25,12) = (/&
&1.1444E+00_JPRB,4.4093E+00_JPRB,7.3963E+00_JPRB,9.7702E+00_JPRB,1.2380E+01_JPRB/)
KBO( :, 2,25,12) = (/&
&1.5338E+00_JPRB,4.5946E+00_JPRB,7.5950E+00_JPRB,9.9140E+00_JPRB,1.2253E+01_JPRB/)
KBO( :, 3,25,12) = (/&
&1.9951E+00_JPRB,4.7679E+00_JPRB,7.7559E+00_JPRB,1.0074E+01_JPRB,1.2101E+01_JPRB/)
KBO( :, 4,25,12) = (/&
&2.5340E+00_JPRB,4.9285E+00_JPRB,7.8837E+00_JPRB,1.0178E+01_JPRB,1.1928E+01_JPRB/)
KBO( :, 5,25,12) = (/&
&3.1490E+00_JPRB,5.0856E+00_JPRB,7.9862E+00_JPRB,1.0230E+01_JPRB,1.1731E+01_JPRB/)
KBO( :, 1,26,12) = (/&
&1.0478E+00_JPRB,4.5874E+00_JPRB,7.7327E+00_JPRB,1.0197E+01_JPRB,1.2777E+01_JPRB/)
KBO( :, 2,26,12) = (/&
&1.4034E+00_JPRB,4.7724E+00_JPRB,7.9352E+00_JPRB,1.0399E+01_JPRB,1.2676E+01_JPRB/)
KBO( :, 3,26,12) = (/&
&1.8290E+00_JPRB,4.9445E+00_JPRB,8.0940E+00_JPRB,1.0560E+01_JPRB,1.2548E+01_JPRB/)
KBO( :, 4,26,12) = (/&
&2.3262E+00_JPRB,5.0995E+00_JPRB,8.2175E+00_JPRB,1.0662E+01_JPRB,1.2385E+01_JPRB/)
KBO( :, 5,26,12) = (/&
&2.8994E+00_JPRB,5.2504E+00_JPRB,8.3168E+00_JPRB,1.0708E+01_JPRB,1.2185E+01_JPRB/)
KBO( :, 1,27,12) = (/&
&9.6295E-01_JPRB,4.7357E+00_JPRB,8.0186E+00_JPRB,1.0582E+01_JPRB,1.3091E+01_JPRB/)
KBO( :, 2,27,12) = (/&
&1.2910E+00_JPRB,4.9215E+00_JPRB,8.2248E+00_JPRB,1.0814E+01_JPRB,1.3028E+01_JPRB/)
KBO( :, 3,27,12) = (/&
&1.6838E+00_JPRB,5.0898E+00_JPRB,8.3871E+00_JPRB,1.0984E+01_JPRB,1.2918E+01_JPRB/)
KBO( :, 4,27,12) = (/&
&2.1466E+00_JPRB,5.2404E+00_JPRB,8.5110E+00_JPRB,1.1084E+01_JPRB,1.2766E+01_JPRB/)
KBO( :, 5,27,12) = (/&
&2.6872E+00_JPRB,5.3861E+00_JPRB,8.6027E+00_JPRB,1.1128E+01_JPRB,1.2572E+01_JPRB/)
KBO( :, 1,28,12) = (/&
&8.9212E-01_JPRB,4.8606E+00_JPRB,8.2568E+00_JPRB,1.0928E+01_JPRB,1.3355E+01_JPRB/)
KBO( :, 2,28,12) = (/&
&1.1960E+00_JPRB,5.0446E+00_JPRB,8.4744E+00_JPRB,1.1178E+01_JPRB,1.3316E+01_JPRB/)
KBO( :, 3,28,12) = (/&
&1.5631E+00_JPRB,5.2061E+00_JPRB,8.6403E+00_JPRB,1.1353E+01_JPRB,1.3227E+01_JPRB/)
KBO( :, 4,28,12) = (/&
&2.0020E+00_JPRB,5.3547E+00_JPRB,8.7642E+00_JPRB,1.1451E+01_JPRB,1.3084E+01_JPRB/)
KBO( :, 5,28,12) = (/&
&2.5209E+00_JPRB,5.4919E+00_JPRB,8.8461E+00_JPRB,1.1491E+01_JPRB,1.2898E+01_JPRB/)
KBO( :, 1,29,12) = (/&
&8.3439E-01_JPRB,4.9630E+00_JPRB,8.4638E+00_JPRB,1.1240E+01_JPRB,1.3569E+01_JPRB/)
KBO( :, 2,29,12) = (/&
&1.1207E+00_JPRB,5.1454E+00_JPRB,8.6875E+00_JPRB,1.1503E+01_JPRB,1.3552E+01_JPRB/)
KBO( :, 3,29,12) = (/&
&1.4717E+00_JPRB,5.3013E+00_JPRB,8.8580E+00_JPRB,1.1673E+01_JPRB,1.3478E+01_JPRB/)
KBO( :, 4,29,12) = (/&
&1.8931E+00_JPRB,5.4461E+00_JPRB,8.9793E+00_JPRB,1.1770E+01_JPRB,1.3347E+01_JPRB/)
KBO( :, 5,29,12) = (/&
&2.3917E+00_JPRB,5.5710E+00_JPRB,9.0514E+00_JPRB,1.1806E+01_JPRB,1.3171E+01_JPRB/)
KBO( :, 1,30,12) = (/&
&7.8953E-01_JPRB,5.0479E+00_JPRB,8.6488E+00_JPRB,1.1520E+01_JPRB,1.3753E+01_JPRB/)
KBO( :, 2,30,12) = (/&
&1.0632E+00_JPRB,5.2264E+00_JPRB,8.8753E+00_JPRB,1.1783E+01_JPRB,1.3755E+01_JPRB/)
KBO( :, 3,30,12) = (/&
&1.4002E+00_JPRB,5.3769E+00_JPRB,9.0463E+00_JPRB,1.1951E+01_JPRB,1.3696E+01_JPRB/)
KBO( :, 4,30,12) = (/&
&1.8078E+00_JPRB,5.5153E+00_JPRB,9.1561E+00_JPRB,1.2049E+01_JPRB,1.3577E+01_JPRB/)
KBO( :, 5,30,12) = (/&
&2.2911E+00_JPRB,5.6294E+00_JPRB,9.2248E+00_JPRB,1.2077E+01_JPRB,1.3407E+01_JPRB/)
KBO( :, 1,31,12) = (/&
&7.5763E-01_JPRB,5.1182E+00_JPRB,8.8135E+00_JPRB,1.1775E+01_JPRB,1.3909E+01_JPRB/)
KBO( :, 2,31,12) = (/&
&1.0216E+00_JPRB,5.2915E+00_JPRB,9.0421E+00_JPRB,1.2027E+01_JPRB,1.3937E+01_JPRB/)
KBO( :, 3,31,12) = (/&
&1.3478E+00_JPRB,5.4413E+00_JPRB,9.2028E+00_JPRB,1.2197E+01_JPRB,1.3886E+01_JPRB/)
KBO( :, 4,31,12) = (/&
&1.7441E+00_JPRB,5.5694E+00_JPRB,9.3055E+00_JPRB,1.2288E+01_JPRB,1.3772E+01_JPRB/)
KBO( :, 5,31,12) = (/&
&2.2144E+00_JPRB,5.6760E+00_JPRB,9.3680E+00_JPRB,1.2303E+01_JPRB,1.3606E+01_JPRB/)
KBO( :, 1,32,12) = (/&
&7.3463E-01_JPRB,5.1776E+00_JPRB,8.9653E+00_JPRB,1.1995E+01_JPRB,1.4066E+01_JPRB/)
KBO( :, 2,32,12) = (/&
&9.9287E-01_JPRB,5.3488E+00_JPRB,9.1823E+00_JPRB,1.2248E+01_JPRB,1.4093E+01_JPRB/)
KBO( :, 3,32,12) = (/&
&1.3124E+00_JPRB,5.4937E+00_JPRB,9.3364E+00_JPRB,1.2412E+01_JPRB,1.4048E+01_JPRB/)
KBO( :, 4,32,12) = (/&
&1.6979E+00_JPRB,5.6116E+00_JPRB,9.4348E+00_JPRB,1.2490E+01_JPRB,1.3938E+01_JPRB/)
KBO( :, 5,32,12) = (/&
&2.1569E+00_JPRB,5.7180E+00_JPRB,9.4915E+00_JPRB,1.2493E+01_JPRB,1.3768E+01_JPRB/)
KBO( :, 1,33,12) = (/&
&7.1977E-01_JPRB,5.2298E+00_JPRB,9.0982E+00_JPRB,1.2196E+01_JPRB,1.4201E+01_JPRB/)
KBO( :, 2,33,12) = (/&
&9.7359E-01_JPRB,5.3967E+00_JPRB,9.3054E+00_JPRB,1.2444E+01_JPRB,1.4231E+01_JPRB/)
KBO( :, 3,33,12) = (/&
&1.2863E+00_JPRB,5.5361E+00_JPRB,9.4542E+00_JPRB,1.2592E+01_JPRB,1.4192E+01_JPRB/)
KBO( :, 4,33,12) = (/&
&1.6635E+00_JPRB,5.6471E+00_JPRB,9.5434E+00_JPRB,1.2656E+01_JPRB,1.4080E+01_JPRB/)
KBO( :, 5,33,12) = (/&
&2.1169E+00_JPRB,5.7606E+00_JPRB,9.5939E+00_JPRB,1.2650E+01_JPRB,1.3912E+01_JPRB/)
KBO( :, 1,34,12) = (/&
&7.0357E-01_JPRB,5.2718E+00_JPRB,9.2058E+00_JPRB,1.2367E+01_JPRB,1.4318E+01_JPRB/)
KBO( :, 2,34,12) = (/&
&9.5100E-01_JPRB,5.4364E+00_JPRB,9.4086E+00_JPRB,1.2603E+01_JPRB,1.4360E+01_JPRB/)
KBO( :, 3,34,12) = (/&
&1.2571E+00_JPRB,5.5683E+00_JPRB,9.5524E+00_JPRB,1.2741E+01_JPRB,1.4321E+01_JPRB/)
KBO( :, 4,34,12) = (/&
&1.6282E+00_JPRB,5.6772E+00_JPRB,9.6331E+00_JPRB,1.2794E+01_JPRB,1.4205E+01_JPRB/)
KBO( :, 5,34,12) = (/&
&2.0759E+00_JPRB,5.7973E+00_JPRB,9.6806E+00_JPRB,1.2780E+01_JPRB,1.4057E+01_JPRB/)
KBO( :, 1,35,12) = (/&
&6.7127E-01_JPRB,5.2954E+00_JPRB,9.2834E+00_JPRB,1.2496E+01_JPRB,1.4429E+01_JPRB/)
KBO( :, 2,35,12) = (/&
&9.0855E-01_JPRB,5.4587E+00_JPRB,9.4864E+00_JPRB,1.2723E+01_JPRB,1.4480E+01_JPRB/)
KBO( :, 3,35,12) = (/&
&1.2033E+00_JPRB,5.5864E+00_JPRB,9.6267E+00_JPRB,1.2858E+01_JPRB,1.4440E+01_JPRB/)
KBO( :, 4,35,12) = (/&
&1.5648E+00_JPRB,5.6975E+00_JPRB,9.7046E+00_JPRB,1.2909E+01_JPRB,1.4336E+01_JPRB/)
KBO( :, 5,35,12) = (/&
&2.0039E+00_JPRB,5.8207E+00_JPRB,9.7512E+00_JPRB,1.2890E+01_JPRB,1.4208E+01_JPRB/)
KBO( :, 1,36,12) = (/&
&6.2192E-01_JPRB,5.2979E+00_JPRB,9.3271E+00_JPRB,1.2576E+01_JPRB,1.4520E+01_JPRB/)
KBO( :, 2,36,12) = (/&
&8.4546E-01_JPRB,5.4637E+00_JPRB,9.5367E+00_JPRB,1.2809E+01_JPRB,1.4583E+01_JPRB/)
KBO( :, 3,36,12) = (/&
&1.1251E+00_JPRB,5.5908E+00_JPRB,9.6790E+00_JPRB,1.2948E+01_JPRB,1.4550E+01_JPRB/)
KBO( :, 4,36,12) = (/&
&1.4725E+00_JPRB,5.7038E+00_JPRB,9.7597E+00_JPRB,1.3004E+01_JPRB,1.4471E+01_JPRB/)
KBO( :, 5,36,12) = (/&
&1.8981E+00_JPRB,5.8306E+00_JPRB,9.8077E+00_JPRB,1.2987E+01_JPRB,1.4353E+01_JPRB/)
KBO( :, 1,37,12) = (/&
&5.5089E-01_JPRB,5.2730E+00_JPRB,9.3242E+00_JPRB,1.2595E+01_JPRB,1.4578E+01_JPRB/)
KBO( :, 2,37,12) = (/&
&7.5546E-01_JPRB,5.4446E+00_JPRB,9.5503E+00_JPRB,1.2851E+01_JPRB,1.4663E+01_JPRB/)
KBO( :, 3,37,12) = (/&
&1.0138E+00_JPRB,5.5779E+00_JPRB,9.7054E+00_JPRB,1.3008E+01_JPRB,1.4649E+01_JPRB/)
KBO( :, 4,37,12) = (/&
&1.3388E+00_JPRB,5.6937E+00_JPRB,9.7968E+00_JPRB,1.3080E+01_JPRB,1.4599E+01_JPRB/)
KBO( :, 5,37,12) = (/&
&1.7405E+00_JPRB,5.8196E+00_JPRB,9.8483E+00_JPRB,1.3074E+01_JPRB,1.4497E+01_JPRB/)
KBO( :, 1,38,12) = (/&
&4.8774E-01_JPRB,5.2446E+00_JPRB,9.3121E+00_JPRB,1.2598E+01_JPRB,1.4624E+01_JPRB/)
KBO( :, 2,38,12) = (/&
&6.7596E-01_JPRB,5.4236E+00_JPRB,9.5535E+00_JPRB,1.2878E+01_JPRB,1.4727E+01_JPRB/)
KBO( :, 3,38,12) = (/&
&9.1580E-01_JPRB,5.5635E+00_JPRB,9.7210E+00_JPRB,1.3053E+01_JPRB,1.4738E+01_JPRB/)
KBO( :, 4,38,12) = (/&
&1.2196E+00_JPRB,5.6813E+00_JPRB,9.8236E+00_JPRB,1.3139E+01_JPRB,1.4721E+01_JPRB/)
KBO( :, 5,38,12) = (/&
&1.5995E+00_JPRB,5.8073E+00_JPRB,9.8794E+00_JPRB,1.3147E+01_JPRB,1.4637E+01_JPRB/)
KBO( :, 1,39,12) = (/&
&4.3319E-01_JPRB,5.2171E+00_JPRB,9.2923E+00_JPRB,1.2591E+01_JPRB,1.4655E+01_JPRB/)
KBO( :, 2,39,12) = (/&
&6.0674E-01_JPRB,5.4013E+00_JPRB,9.5491E+00_JPRB,1.2892E+01_JPRB,1.4779E+01_JPRB/)
KBO( :, 3,39,12) = (/&
&8.3076E-01_JPRB,5.5491E+00_JPRB,9.7285E+00_JPRB,1.3083E+01_JPRB,1.4825E+01_JPRB/)
KBO( :, 4,39,12) = (/&
&1.1162E+00_JPRB,5.6693E+00_JPRB,9.8420E+00_JPRB,1.3183E+01_JPRB,1.4848E+01_JPRB/)
KBO( :, 5,39,12) = (/&
&1.4760E+00_JPRB,5.7939E+00_JPRB,9.9065E+00_JPRB,1.3208E+01_JPRB,1.4788E+01_JPRB/)
KBO( :, 1,40,12) = (/&
&3.7146E-01_JPRB,5.1676E+00_JPRB,9.2350E+00_JPRB,1.2533E+01_JPRB,1.4645E+01_JPRB/)
KBO( :, 2,40,12) = (/&
&5.2844E-01_JPRB,5.3608E+00_JPRB,9.5128E+00_JPRB,1.2866E+01_JPRB,1.4804E+01_JPRB/)
KBO( :, 3,40,12) = (/&
&7.3313E-01_JPRB,5.5191E+00_JPRB,9.7148E+00_JPRB,1.3086E+01_JPRB,1.4881E+01_JPRB/)
KBO( :, 4,40,12) = (/&
&9.9528E-01_JPRB,5.6415E+00_JPRB,9.8443E+00_JPRB,1.3210E+01_JPRB,1.4931E+01_JPRB/)
KBO( :, 5,40,12) = (/&
&1.3291E+00_JPRB,5.7657E+00_JPRB,9.9220E+00_JPRB,1.3255E+01_JPRB,1.4902E+01_JPRB/)
KBO( :, 1,41,12) = (/&
&3.1691E-01_JPRB,5.1123E+00_JPRB,9.1654E+00_JPRB,1.2453E+01_JPRB,1.4615E+01_JPRB/)
KBO( :, 2,41,12) = (/&
&4.5854E-01_JPRB,5.3141E+00_JPRB,9.4645E+00_JPRB,1.2820E+01_JPRB,1.4813E+01_JPRB/)
KBO( :, 3,41,12) = (/&
&6.4497E-01_JPRB,5.4832E+00_JPRB,9.6893E+00_JPRB,1.3072E+01_JPRB,1.4921E+01_JPRB/)
KBO( :, 4,41,12) = (/&
&8.8600E-01_JPRB,5.6149E+00_JPRB,9.8376E+00_JPRB,1.3222E+01_JPRB,1.5000E+01_JPRB/)
KBO( :, 5,41,12) = (/&
&1.1949E+00_JPRB,5.7388E+00_JPRB,9.9263E+00_JPRB,1.3289E+01_JPRB,1.5001E+01_JPRB/)
KBO( :, 1,42,12) = (/&
&2.6990E-01_JPRB,5.0545E+00_JPRB,9.0851E+00_JPRB,1.2357E+01_JPRB,1.4568E+01_JPRB/)
KBO( :, 2,42,12) = (/&
&3.9791E-01_JPRB,5.2666E+00_JPRB,9.4059E+00_JPRB,1.2762E+01_JPRB,1.4811E+01_JPRB/)
KBO( :, 3,42,12) = (/&
&5.6786E-01_JPRB,5.4473E+00_JPRB,9.6535E+00_JPRB,1.3042E+01_JPRB,1.4951E+01_JPRB/)
KBO( :, 4,42,12) = (/&
&7.8985E-01_JPRB,5.5889E+00_JPRB,9.8202E+00_JPRB,1.3220E+01_JPRB,1.5062E+01_JPRB/)
KBO( :, 5,42,12) = (/&
&1.0759E+00_JPRB,5.7103E+00_JPRB,9.9256E+00_JPRB,1.3308E+01_JPRB,1.5095E+01_JPRB/)
KBO( :, 1,43,12) = (/&
&2.2408E-01_JPRB,4.9801E+00_JPRB,8.9750E+00_JPRB,1.2220E+01_JPRB,1.4488E+01_JPRB/)
KBO( :, 2,43,12) = (/&
&3.3742E-01_JPRB,5.2050E+00_JPRB,9.3221E+00_JPRB,1.2666E+01_JPRB,1.4779E+01_JPRB/)
KBO( :, 3,43,12) = (/&
&4.9010E-01_JPRB,5.3960E+00_JPRB,9.5945E+00_JPRB,1.2984E+01_JPRB,1.4959E+01_JPRB/)
KBO( :, 4,43,12) = (/&
&6.9169E-01_JPRB,5.5493E+00_JPRB,9.7889E+00_JPRB,1.3197E+01_JPRB,1.5104E+01_JPRB/)
KBO( :, 5,43,12) = (/&
&9.5305E-01_JPRB,5.6745E+00_JPRB,9.9131E+00_JPRB,1.3310E+01_JPRB,1.5176E+01_JPRB/)
KBO( :, 1,44,12) = (/&
&1.8323E-01_JPRB,4.8933E+00_JPRB,8.8410E+00_JPRB,1.2051E+01_JPRB,1.4377E+01_JPRB/)
KBO( :, 2,44,12) = (/&
&2.8217E-01_JPRB,5.1330E+00_JPRB,9.2212E+00_JPRB,1.2543E+01_JPRB,1.4725E+01_JPRB/)
KBO( :, 3,44,12) = (/&
&4.1838E-01_JPRB,5.3347E+00_JPRB,9.5219E+00_JPRB,1.2906E+01_JPRB,1.4949E+01_JPRB/)
KBO( :, 4,44,12) = (/&
&5.9984E-01_JPRB,5.5043E+00_JPRB,9.7457E+00_JPRB,1.3153E+01_JPRB,1.5131E+01_JPRB/)
KBO( :, 5,44,12) = (/&
&8.3730E-01_JPRB,5.6361E+00_JPRB,9.8881E+00_JPRB,1.3302E+01_JPRB,1.5248E+01_JPRB/)
KBO( :, 1,45,12) = (/&
&1.4904E-01_JPRB,4.8014E+00_JPRB,8.6942E+00_JPRB,1.1857E+01_JPRB,1.4243E+01_JPRB/)
KBO( :, 2,45,12) = (/&
&2.3486E-01_JPRB,5.0590E+00_JPRB,9.1087E+00_JPRB,1.2404E+01_JPRB,1.4652E+01_JPRB/)
KBO( :, 3,45,12) = (/&
&3.5578E-01_JPRB,5.2728E+00_JPRB,9.4361E+00_JPRB,1.2811E+01_JPRB,1.4928E+01_JPRB/)
KBO( :, 4,45,12) = (/&
&5.1907E-01_JPRB,5.4551E+00_JPRB,9.6849E+00_JPRB,1.3095E+01_JPRB,1.5155E+01_JPRB/)
KBO( :, 5,45,12) = (/&
&7.3447E-01_JPRB,5.5970E+00_JPRB,9.8551E+00_JPRB,1.3278E+01_JPRB,1.5316E+01_JPRB/)
KBO( :, 1,46,12) = (/&
&1.1910E-01_JPRB,4.6973E+00_JPRB,8.5264E+00_JPRB,1.1635E+01_JPRB,1.4074E+01_JPRB/)
KBO( :, 2,46,12) = (/&
&1.9264E-01_JPRB,4.9713E+00_JPRB,8.9752E+00_JPRB,1.2231E+01_JPRB,1.4552E+01_JPRB/)
KBO( :, 3,46,12) = (/&
&2.9840E-01_JPRB,5.1994E+00_JPRB,9.3302E+00_JPRB,1.2687E+01_JPRB,1.4886E+01_JPRB/)
KBO( :, 4,46,12) = (/&
&4.4420E-01_JPRB,5.3934E+00_JPRB,9.6109E+00_JPRB,1.3017E+01_JPRB,1.5158E+01_JPRB/)
KBO( :, 5,46,12) = (/&
&6.3821E-01_JPRB,5.5501E+00_JPRB,9.8128E+00_JPRB,1.3236E+01_JPRB,1.5371E+01_JPRB/)
KBO( :, 1,47,12) = (/&
&9.2205E-02_JPRB,4.5728E+00_JPRB,8.3222E+00_JPRB,1.1357E+01_JPRB,1.3848E+01_JPRB/)
KBO( :, 2,47,12) = (/&
&1.5376E-01_JPRB,4.8658E+00_JPRB,8.8065E+00_JPRB,1.2014E+01_JPRB,1.4405E+01_JPRB/)
KBO( :, 3,47,12) = (/&
&2.4420E-01_JPRB,5.1135E+00_JPRB,9.2023E+00_JPRB,1.2528E+01_JPRB,1.4805E+01_JPRB/)
KBO( :, 4,47,12) = (/&
&3.7202E-01_JPRB,5.3206E+00_JPRB,9.5150E+00_JPRB,1.2907E+01_JPRB,1.5121E+01_JPRB/)
KBO( :, 5,47,12) = (/&
&5.4440E-01_JPRB,5.4945E+00_JPRB,9.7455E+00_JPRB,1.3168E+01_JPRB,1.5387E+01_JPRB/)
KBO( :, 1,48,12) = (/&
&7.0454E-02_JPRB,4.4412E+00_JPRB,8.1011E+00_JPRB,1.1048E+01_JPRB,1.3590E+01_JPRB/)
KBO( :, 2,48,12) = (/&
&1.2149E-01_JPRB,4.7546E+00_JPRB,8.6257E+00_JPRB,1.1771E+01_JPRB,1.4231E+01_JPRB/)
KBO( :, 3,48,12) = (/&
&1.9826E-01_JPRB,5.0205E+00_JPRB,9.0577E+00_JPRB,1.2345E+01_JPRB,1.4705E+01_JPRB/)
KBO( :, 4,48,12) = (/&
&3.0915E-01_JPRB,5.2415E+00_JPRB,9.3998E+00_JPRB,1.2778E+01_JPRB,1.5077E+01_JPRB/)
KBO( :, 5,48,12) = (/&
&4.6199E-01_JPRB,5.4308E+00_JPRB,9.6652E+00_JPRB,1.3083E+01_JPRB,1.5397E+01_JPRB/)
KBO( :, 1,49,12) = (/&
&5.3088E-02_JPRB,4.3008E+00_JPRB,7.8587E+00_JPRB,1.0710E+01_JPRB,1.3300E+01_JPRB/)
KBO( :, 2,49,12) = (/&
&9.4886E-02_JPRB,4.6325E+00_JPRB,8.4260E+00_JPRB,1.1503E+01_JPRB,1.4035E+01_JPRB/)
KBO( :, 3,49,12) = (/&
&1.5966E-01_JPRB,4.9173E+00_JPRB,8.8952E+00_JPRB,1.2135E+01_JPRB,1.4593E+01_JPRB/)
KBO( :, 4,49,12) = (/&
&2.5505E-01_JPRB,5.1573E+00_JPRB,9.2755E+00_JPRB,1.2624E+01_JPRB,1.5028E+01_JPRB/)
KBO( :, 5,49,12) = (/&
&3.8941E-01_JPRB,5.3580E+00_JPRB,9.5745E+00_JPRB,1.2980E+01_JPRB,1.5409E+01_JPRB/)
KBO( :, 1,50,12) = (/&
&4.0067E-02_JPRB,4.1596E+00_JPRB,7.6089E+00_JPRB,1.0372E+01_JPRB,1.2988E+01_JPRB/)
KBO( :, 2,50,12) = (/&
&7.4256E-02_JPRB,4.5125E+00_JPRB,8.2260E+00_JPRB,1.1225E+01_JPRB,1.3810E+01_JPRB/)
KBO( :, 3,50,12) = (/&
&1.2901E-01_JPRB,4.8174E+00_JPRB,8.7310E+00_JPRB,1.1915E+01_JPRB,1.4444E+01_JPRB/)
KBO( :, 4,50,12) = (/&
&2.1116E-01_JPRB,5.0740E+00_JPRB,9.1458E+00_JPRB,1.2461E+01_JPRB,1.4934E+01_JPRB/)
KBO( :, 5,50,12) = (/&
&3.2945E-01_JPRB,5.2879E+00_JPRB,9.4738E+00_JPRB,1.2866E+01_JPRB,1.5371E+01_JPRB/)
KBO( :, 1,51,12) = (/&
&3.0082E-02_JPRB,4.0166E+00_JPRB,7.3470E+00_JPRB,1.0024E+01_JPRB,1.2649E+01_JPRB/)
KBO( :, 2,51,12) = (/&
&5.7864E-02_JPRB,4.3904E+00_JPRB,8.0166E+00_JPRB,1.0930E+01_JPRB,1.3555E+01_JPRB/)
KBO( :, 3,51,12) = (/&
&1.0385E-01_JPRB,4.7103E+00_JPRB,8.5593E+00_JPRB,1.1684E+01_JPRB,1.4265E+01_JPRB/)
KBO( :, 4,51,12) = (/&
&1.7451E-01_JPRB,4.9838E+00_JPRB,9.0063E+00_JPRB,1.2280E+01_JPRB,1.4812E+01_JPRB/)
KBO( :, 5,51,12) = (/&
&2.7822E-01_JPRB,5.2130E+00_JPRB,9.3629E+00_JPRB,1.2735E+01_JPRB,1.5297E+01_JPRB/)
KBO( :, 1,52,12) = (/&
&2.2321E-02_JPRB,3.8633E+00_JPRB,7.0669E+00_JPRB,9.6645E+00_JPRB,1.2286E+01_JPRB/)
KBO( :, 2,52,12) = (/&
&4.4568E-02_JPRB,4.2586E+00_JPRB,7.7887E+00_JPRB,1.0615E+01_JPRB,1.3275E+01_JPRB/)
KBO( :, 3,52,12) = (/&
&8.2764E-02_JPRB,4.5976E+00_JPRB,8.3722E+00_JPRB,1.1430E+01_JPRB,1.4067E+01_JPRB/)
KBO( :, 4,52,12) = (/&
&1.4332E-01_JPRB,4.8897E+00_JPRB,8.8533E+00_JPRB,1.2081E+01_JPRB,1.4681E+01_JPRB/)
KBO( :, 5,52,12) = (/&
&2.3359E-01_JPRB,5.1350E+00_JPRB,9.2453E+00_JPRB,1.2589E+01_JPRB,1.5214E+01_JPRB/)
KBO( :, 1,53,12) = (/&
&1.6320E-02_JPRB,3.7017E+00_JPRB,6.7670E+00_JPRB,9.2859E+00_JPRB,1.1890E+01_JPRB/)
KBO( :, 2,53,12) = (/&
&3.3883E-02_JPRB,4.1210E+00_JPRB,7.5408E+00_JPRB,1.0281E+01_JPRB,1.2972E+01_JPRB/)
KBO( :, 3,53,12) = (/&
&6.5211E-02_JPRB,4.4803E+00_JPRB,8.1737E+00_JPRB,1.1152E+01_JPRB,1.3849E+01_JPRB/)
KBO( :, 4,53,12) = (/&
&1.1656E-01_JPRB,4.7901E+00_JPRB,8.6895E+00_JPRB,1.1861E+01_JPRB,1.4540E+01_JPRB/)
KBO( :, 5,53,12) = (/&
&1.9454E-01_JPRB,5.0513E+00_JPRB,9.1138E+00_JPRB,1.2423E+01_JPRB,1.5132E+01_JPRB/)
KBO( :, 1,54,12) = (/&
&1.2044E-02_JPRB,3.5460E+00_JPRB,6.4769E+00_JPRB,8.9175E+00_JPRB,1.1478E+01_JPRB/)
KBO( :, 2,54,12) = (/&
&2.6009E-02_JPRB,3.9878E+00_JPRB,7.2955E+00_JPRB,9.9571E+00_JPRB,1.2628E+01_JPRB/)
KBO( :, 3,54,12) = (/&
&5.1821E-02_JPRB,4.3666E+00_JPRB,7.9779E+00_JPRB,1.0876E+01_JPRB,1.3583E+01_JPRB/)
KBO( :, 4,54,12) = (/&
&9.5474E-02_JPRB,4.6901E+00_JPRB,8.5279E+00_JPRB,1.1644E+01_JPRB,1.4331E+01_JPRB/)
KBO( :, 5,54,12) = (/&
&1.6346E-01_JPRB,4.9679E+00_JPRB,8.9829E+00_JPRB,1.2251E+01_JPRB,1.4953E+01_JPRB/)
KBO( :, 1,55,12) = (/&
&8.8474E-03_JPRB,3.3874E+00_JPRB,6.1849E+00_JPRB,8.5463E+00_JPRB,1.1054E+01_JPRB/)
KBO( :, 2,55,12) = (/&
&1.9964E-02_JPRB,3.8514E+00_JPRB,7.0467E+00_JPRB,9.6387E+00_JPRB,1.2268E+01_JPRB/)
KBO( :, 3,55,12) = (/&
&4.1152E-02_JPRB,4.2498E+00_JPRB,7.7746E+00_JPRB,1.0596E+01_JPRB,1.3279E+01_JPRB/)
KBO( :, 4,55,12) = (/&
&7.8159E-02_JPRB,4.5905E+00_JPRB,8.3623E+00_JPRB,1.1417E+01_JPRB,1.4084E+01_JPRB/)
KBO( :, 5,55,12) = (/&
&1.3750E-01_JPRB,4.8845E+00_JPRB,8.8463E+00_JPRB,1.2073E+01_JPRB,1.4722E+01_JPRB/)
KBO( :, 1,56,12) = (/&
&6.4082E-03_JPRB,3.2244E+00_JPRB,5.8774E+00_JPRB,8.1652E+00_JPRB,1.0610E+01_JPRB/)
KBO( :, 2,56,12) = (/&
&1.5162E-02_JPRB,3.7100E+00_JPRB,6.7838E+00_JPRB,9.3060E+00_JPRB,1.1893E+01_JPRB/)
KBO( :, 3,56,12) = (/&
&3.2388E-02_JPRB,4.1289E+00_JPRB,7.5561E+00_JPRB,1.0301E+01_JPRB,1.2952E+01_JPRB/)
KBO( :, 4,56,12) = (/&
&6.3471E-02_JPRB,4.4879E+00_JPRB,8.1882E+00_JPRB,1.1172E+01_JPRB,1.3823E+01_JPRB/)
KBO( :, 5,56,12) = (/&
&1.1487E-01_JPRB,4.7971E+00_JPRB,8.7028E+00_JPRB,1.1880E+01_JPRB,1.4496E+01_JPRB/)
KBO( :, 1,57,12) = (/&
&4.5631E-03_JPRB,3.0511E+00_JPRB,5.5587E+00_JPRB,7.7750E+00_JPRB,1.0138E+01_JPRB/)
KBO( :, 2,57,12) = (/&
&1.1368E-02_JPRB,3.5622E+00_JPRB,6.5073E+00_JPRB,8.9555E+00_JPRB,1.1499E+01_JPRB/)
KBO( :, 3,57,12) = (/&
&2.5250E-02_JPRB,4.0025E+00_JPRB,7.3232E+00_JPRB,9.9930E+00_JPRB,1.2617E+01_JPRB/)
KBO( :, 4,57,12) = (/&
&5.1105E-02_JPRB,4.3794E+00_JPRB,8.0015E+00_JPRB,1.0910E+01_JPRB,1.3544E+01_JPRB/)
KBO( :, 5,57,12) = (/&
&9.5178E-02_JPRB,4.7023E+00_JPRB,8.5498E+00_JPRB,1.1673E+01_JPRB,1.4270E+01_JPRB/)
KBO( :, 1,58,12) = (/&
&3.2442E-03_JPRB,2.8817E+00_JPRB,5.2469E+00_JPRB,7.3938E+00_JPRB,9.6647E+00_JPRB/)
KBO( :, 2,58,12) = (/&
&8.5196E-03_JPRB,3.4130E+00_JPRB,6.2333E+00_JPRB,8.6058E+00_JPRB,1.1102E+01_JPRB/)
KBO( :, 3,58,12) = (/&
&1.9737E-02_JPRB,3.8740E+00_JPRB,7.0888E+00_JPRB,9.6922E+00_JPRB,1.2287E+01_JPRB/)
KBO( :, 4,58,12) = (/&
&4.1256E-02_JPRB,4.2697E+00_JPRB,7.8107E+00_JPRB,1.0646E+01_JPRB,1.3253E+01_JPRB/)
KBO( :, 5,58,12) = (/&
&7.9005E-02_JPRB,4.6081E+00_JPRB,8.3923E+00_JPRB,1.1459E+01_JPRB,1.4032E+01_JPRB/)
KBO( :, 1,59,12) = (/&
&2.7554E-03_JPRB,2.8115E+00_JPRB,5.1204E+00_JPRB,7.2380E+00_JPRB,9.4574E+00_JPRB/)
KBO( :, 2,59,12) = (/&
&7.4695E-03_JPRB,3.3520E+00_JPRB,6.1191E+00_JPRB,8.4629E+00_JPRB,1.0919E+01_JPRB/)
KBO( :, 3,59,12) = (/&
&1.7700E-02_JPRB,3.8208E+00_JPRB,6.9919E+00_JPRB,9.5688E+00_JPRB,1.2133E+01_JPRB/)
KBO( :, 4,59,12) = (/&
&3.7590E-02_JPRB,4.2246E+00_JPRB,7.7306E+00_JPRB,1.0537E+01_JPRB,1.3092E+01_JPRB/)
KBO( :, 5,59,12) = (/&
&7.2976E-02_JPRB,4.5698E+00_JPRB,8.3286E+00_JPRB,1.1370E+01_JPRB,1.3863E+01_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB5_B3
