!OCL SCALAR
SUBROUTINE RRTM_KGB5_B2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, CCL4O
USE YOERRTA5 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KB contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of co2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 5) = (/&
&9.5206E-04_JPRB,3.5867E-02_JPRB,6.3329E-02_JPRB,8.8273E-02_JPRB,1.0919E-01_JPRB/)
KBO( :, 2,13, 5) = (/&
&1.4606E-03_JPRB,3.9499E-02_JPRB,6.8038E-02_JPRB,9.3530E-02_JPRB,1.1392E-01_JPRB/)
KBO( :, 3,13, 5) = (/&
&2.1122E-03_JPRB,4.3255E-02_JPRB,7.2755E-02_JPRB,9.8485E-02_JPRB,1.1804E-01_JPRB/)
KBO( :, 4,13, 5) = (/&
&2.9342E-03_JPRB,4.7055E-02_JPRB,7.7481E-02_JPRB,1.0325E-01_JPRB,1.2194E-01_JPRB/)
KBO( :, 5,13, 5) = (/&
&3.9691E-03_JPRB,5.0998E-02_JPRB,8.2111E-02_JPRB,1.0793E-01_JPRB,1.2556E-01_JPRB/)
KBO( :, 1,14, 5) = (/&
&8.3529E-04_JPRB,3.1756E-02_JPRB,5.5904E-02_JPRB,7.7763E-02_JPRB,9.5354E-02_JPRB/)
KBO( :, 2,14, 5) = (/&
&1.2709E-03_JPRB,3.5009E-02_JPRB,6.0040E-02_JPRB,8.2374E-02_JPRB,9.9262E-02_JPRB/)
KBO( :, 3,14, 5) = (/&
&1.8315E-03_JPRB,3.8336E-02_JPRB,6.4269E-02_JPRB,8.6806E-02_JPRB,1.0290E-01_JPRB/)
KBO( :, 4,14, 5) = (/&
&2.5450E-03_JPRB,4.1786E-02_JPRB,6.8525E-02_JPRB,9.1155E-02_JPRB,1.0629E-01_JPRB/)
KBO( :, 5,14, 5) = (/&
&3.4515E-03_JPRB,4.5381E-02_JPRB,7.2773E-02_JPRB,9.5396E-02_JPRB,1.0928E-01_JPRB/)
KBO( :, 1,15, 5) = (/&
&7.3165E-04_JPRB,2.7921E-02_JPRB,4.8914E-02_JPRB,6.7922E-02_JPRB,8.2662E-02_JPRB/)
KBO( :, 2,15, 5) = (/&
&1.1052E-03_JPRB,3.0784E-02_JPRB,5.2602E-02_JPRB,7.1990E-02_JPRB,8.6043E-02_JPRB/)
KBO( :, 3,15, 5) = (/&
&1.5893E-03_JPRB,3.3752E-02_JPRB,5.6376E-02_JPRB,7.5928E-02_JPRB,8.9235E-02_JPRB/)
KBO( :, 4,15, 5) = (/&
&2.2106E-03_JPRB,3.6890E-02_JPRB,6.0189E-02_JPRB,7.9806E-02_JPRB,9.1982E-02_JPRB/)
KBO( :, 5,15, 5) = (/&
&3.0053E-03_JPRB,4.0122E-02_JPRB,6.4009E-02_JPRB,8.3450E-02_JPRB,9.3979E-02_JPRB/)
KBO( :, 1,16, 5) = (/&
&6.3939E-04_JPRB,2.4371E-02_JPRB,4.2503E-02_JPRB,5.8900E-02_JPRB,7.1290E-02_JPRB/)
KBO( :, 2,16, 5) = (/&
&9.6055E-04_JPRB,2.6877E-02_JPRB,4.5773E-02_JPRB,6.2455E-02_JPRB,7.4252E-02_JPRB/)
KBO( :, 3,16, 5) = (/&
&1.3794E-03_JPRB,2.9539E-02_JPRB,4.9114E-02_JPRB,6.5898E-02_JPRB,7.6813E-02_JPRB/)
KBO( :, 4,16, 5) = (/&
&1.9216E-03_JPRB,3.2321E-02_JPRB,5.2426E-02_JPRB,6.9093E-02_JPRB,7.8632E-02_JPRB/)
KBO( :, 5,16, 5) = (/&
&2.6144E-03_JPRB,3.5146E-02_JPRB,5.5567E-02_JPRB,7.1811E-02_JPRB,7.9616E-02_JPRB/)
KBO( :, 1,17, 5) = (/&
&5.5621E-04_JPRB,2.1119E-02_JPRB,3.6702E-02_JPRB,5.0729E-02_JPRB,6.1106E-02_JPRB/)
KBO( :, 2,17, 5) = (/&
&8.3232E-04_JPRB,2.3324E-02_JPRB,3.9564E-02_JPRB,5.3768E-02_JPRB,6.3482E-02_JPRB/)
KBO( :, 3,17, 5) = (/&
&1.1952E-03_JPRB,2.5644E-02_JPRB,4.2368E-02_JPRB,5.6531E-02_JPRB,6.5194E-02_JPRB/)
KBO( :, 4,17, 5) = (/&
&1.6664E-03_JPRB,2.8012E-02_JPRB,4.5051E-02_JPRB,5.8907E-02_JPRB,6.6158E-02_JPRB/)
KBO( :, 5,17, 5) = (/&
&2.2697E-03_JPRB,3.0355E-02_JPRB,4.7479E-02_JPRB,6.0879E-02_JPRB,6.6574E-02_JPRB/)
KBO( :, 1,18, 5) = (/&
&4.8259E-04_JPRB,1.8188E-02_JPRB,3.1503E-02_JPRB,4.3373E-02_JPRB,5.1944E-02_JPRB/)
KBO( :, 2,18, 5) = (/&
&7.2053E-04_JPRB,2.0086E-02_JPRB,3.3870E-02_JPRB,4.5795E-02_JPRB,5.3602E-02_JPRB/)
KBO( :, 3,18, 5) = (/&
&1.0344E-03_JPRB,2.2024E-02_JPRB,3.6106E-02_JPRB,4.7862E-02_JPRB,5.4601E-02_JPRB/)
KBO( :, 4,18, 5) = (/&
&1.4426E-03_JPRB,2.3955E-02_JPRB,3.8187E-02_JPRB,4.9634E-02_JPRB,5.5105E-02_JPRB/)
KBO( :, 5,18, 5) = (/&
&1.9652E-03_JPRB,2.5872E-02_JPRB,4.0129E-02_JPRB,5.1165E-02_JPRB,5.5250E-02_JPRB/)
KBO( :, 1,19, 5) = (/&
&4.1792E-04_JPRB,1.5551E-02_JPRB,2.6815E-02_JPRB,3.6748E-02_JPRB,4.3685E-02_JPRB/)
KBO( :, 2,19, 5) = (/&
&6.2288E-04_JPRB,1.7122E-02_JPRB,2.8681E-02_JPRB,3.8570E-02_JPRB,4.4726E-02_JPRB/)
KBO( :, 3,19, 5) = (/&
&8.9314E-04_JPRB,1.8695E-02_JPRB,3.0435E-02_JPRB,4.0145E-02_JPRB,4.5326E-02_JPRB/)
KBO( :, 4,19, 5) = (/&
&1.2454E-03_JPRB,2.0272E-02_JPRB,3.2103E-02_JPRB,4.1538E-02_JPRB,4.5592E-02_JPRB/)
KBO( :, 5,19, 5) = (/&
&1.6963E-03_JPRB,2.1865E-02_JPRB,3.3692E-02_JPRB,4.2753E-02_JPRB,4.5589E-02_JPRB/)
KBO( :, 1,20, 5) = (/&
&3.6420E-04_JPRB,1.3204E-02_JPRB,2.2627E-02_JPRB,3.0869E-02_JPRB,3.6406E-02_JPRB/)
KBO( :, 2,20, 5) = (/&
&5.4128E-04_JPRB,1.4478E-02_JPRB,2.4102E-02_JPRB,3.2269E-02_JPRB,3.7086E-02_JPRB/)
KBO( :, 3,20, 5) = (/&
&7.7497E-04_JPRB,1.5768E-02_JPRB,2.5513E-02_JPRB,3.3512E-02_JPRB,3.7454E-02_JPRB/)
KBO( :, 4,20, 5) = (/&
&1.0788E-03_JPRB,1.7071E-02_JPRB,2.6877E-02_JPRB,3.4628E-02_JPRB,3.7589E-02_JPRB/)
KBO( :, 5,20, 5) = (/&
&1.4684E-03_JPRB,1.8409E-02_JPRB,2.8186E-02_JPRB,3.5595E-02_JPRB,3.7513E-02_JPRB/)
KBO( :, 1,21, 5) = (/&
&3.1749E-04_JPRB,1.1126E-02_JPRB,1.8957E-02_JPRB,2.5768E-02_JPRB,3.0157E-02_JPRB/)
KBO( :, 2,21, 5) = (/&
&4.7023E-04_JPRB,1.2173E-02_JPRB,2.0148E-02_JPRB,2.6878E-02_JPRB,3.0618E-02_JPRB/)
KBO( :, 3,21, 5) = (/&
&6.7172E-04_JPRB,1.3233E-02_JPRB,2.1304E-02_JPRB,2.7875E-02_JPRB,3.0852E-02_JPRB/)
KBO( :, 4,21, 5) = (/&
&9.3331E-04_JPRB,1.4327E-02_JPRB,2.2423E-02_JPRB,2.8768E-02_JPRB,3.0908E-02_JPRB/)
KBO( :, 5,21, 5) = (/&
&1.2694E-03_JPRB,1.5438E-02_JPRB,2.3509E-02_JPRB,2.9558E-02_JPRB,3.0797E-02_JPRB/)
KBO( :, 1,22, 5) = (/&
&2.8408E-04_JPRB,9.3883E-03_JPRB,1.5880E-02_JPRB,2.1492E-02_JPRB,2.4916E-02_JPRB/)
KBO( :, 2,22, 5) = (/&
&4.1797E-04_JPRB,1.0249E-02_JPRB,1.6855E-02_JPRB,2.2374E-02_JPRB,2.5222E-02_JPRB/)
KBO( :, 3,22, 5) = (/&
&5.9453E-04_JPRB,1.1132E-02_JPRB,1.7800E-02_JPRB,2.3170E-02_JPRB,2.5366E-02_JPRB/)
KBO( :, 4,22, 5) = (/&
&8.2301E-04_JPRB,1.2047E-02_JPRB,1.8719E-02_JPRB,2.3894E-02_JPRB,2.5365E-02_JPRB/)
KBO( :, 5,22, 5) = (/&
&1.1184E-03_JPRB,1.2973E-02_JPRB,1.9629E-02_JPRB,2.4534E-02_JPRB,2.5237E-02_JPRB/)
KBO( :, 1,23, 5) = (/&
&2.5418E-04_JPRB,7.8977E-03_JPRB,1.3269E-02_JPRB,1.7874E-02_JPRB,2.0529E-02_JPRB/)
KBO( :, 2,23, 5) = (/&
&3.7141E-04_JPRB,8.6092E-03_JPRB,1.4071E-02_JPRB,1.8581E-02_JPRB,2.0735E-02_JPRB/)
KBO( :, 3,23, 5) = (/&
&5.2592E-04_JPRB,9.3501E-03_JPRB,1.4842E-02_JPRB,1.9229E-02_JPRB,2.0817E-02_JPRB/)
KBO( :, 4,23, 5) = (/&
&7.2596E-04_JPRB,1.0112E-02_JPRB,1.5610E-02_JPRB,1.9813E-02_JPRB,2.0787E-02_JPRB/)
KBO( :, 5,23, 5) = (/&
&9.8686E-04_JPRB,1.0888E-02_JPRB,1.6368E-02_JPRB,2.0340E-02_JPRB,2.0658E-02_JPRB/)
KBO( :, 1,24, 5) = (/&
&2.2750E-04_JPRB,6.6317E-03_JPRB,1.1075E-02_JPRB,1.4842E-02_JPRB,1.6884E-02_JPRB/)
KBO( :, 2,24, 5) = (/&
&3.3026E-04_JPRB,7.2252E-03_JPRB,1.1728E-02_JPRB,1.5415E-02_JPRB,1.7024E-02_JPRB/)
KBO( :, 3,24, 5) = (/&
&4.6578E-04_JPRB,7.8440E-03_JPRB,1.2367E-02_JPRB,1.5941E-02_JPRB,1.7063E-02_JPRB/)
KBO( :, 4,24, 5) = (/&
&6.4270E-04_JPRB,8.4805E-03_JPRB,1.3008E-02_JPRB,1.6415E-02_JPRB,1.7016E-02_JPRB/)
KBO( :, 5,24, 5) = (/&
&8.7339E-04_JPRB,9.1332E-03_JPRB,1.3636E-02_JPRB,1.6855E-02_JPRB,1.6890E-02_JPRB/)
KBO( :, 1,25, 5) = (/&
&2.0394E-04_JPRB,5.5639E-03_JPRB,9.2339E-03_JPRB,1.2315E-02_JPRB,1.3870E-02_JPRB/)
KBO( :, 2,25, 5) = (/&
&2.9439E-04_JPRB,6.0615E-03_JPRB,9.7694E-03_JPRB,1.2780E-02_JPRB,1.3961E-02_JPRB/)
KBO( :, 3,25, 5) = (/&
&4.1407E-04_JPRB,6.5784E-03_JPRB,1.0303E-02_JPRB,1.3206E-02_JPRB,1.3975E-02_JPRB/)
KBO( :, 4,25, 5) = (/&
&5.7180E-04_JPRB,7.1121E-03_JPRB,1.0835E-02_JPRB,1.3598E-02_JPRB,1.3919E-02_JPRB/)
KBO( :, 5,25, 5) = (/&
&7.7557E-04_JPRB,7.6591E-03_JPRB,1.1360E-02_JPRB,1.3963E-02_JPRB,1.3799E-02_JPRB/)
KBO( :, 1,26, 5) = (/&
&1.8382E-04_JPRB,4.6737E-03_JPRB,7.6992E-03_JPRB,1.0216E-02_JPRB,1.1388E-02_JPRB/)
KBO( :, 2,26, 5) = (/&
&2.6412E-04_JPRB,5.0893E-03_JPRB,8.1430E-03_JPRB,1.0593E-02_JPRB,1.1444E-02_JPRB/)
KBO( :, 3,26, 5) = (/&
&3.7112E-04_JPRB,5.5248E-03_JPRB,8.5884E-03_JPRB,1.0942E-02_JPRB,1.1439E-02_JPRB/)
KBO( :, 4,26, 5) = (/&
&5.1206E-04_JPRB,5.9696E-03_JPRB,9.0299E-03_JPRB,1.1267E-02_JPRB,1.1378E-02_JPRB/)
KBO( :, 5,26, 5) = (/&
&6.9168E-04_JPRB,6.4260E-03_JPRB,9.4675E-03_JPRB,1.1565E-02_JPRB,1.1265E-02_JPRB/)
KBO( :, 1,27, 5) = (/&
&1.6571E-04_JPRB,3.9248E-03_JPRB,6.4172E-03_JPRB,8.4701E-03_JPRB,9.3451E-03_JPRB/)
KBO( :, 2,27, 5) = (/&
&2.3754E-04_JPRB,4.2747E-03_JPRB,6.7865E-03_JPRB,8.7783E-03_JPRB,9.3771E-03_JPRB/)
KBO( :, 3,27, 5) = (/&
&3.3337E-04_JPRB,4.6378E-03_JPRB,7.1567E-03_JPRB,9.0646E-03_JPRB,9.3601E-03_JPRB/)
KBO( :, 4,27, 5) = (/&
&4.5858E-04_JPRB,5.0089E-03_JPRB,7.5246E-03_JPRB,9.3326E-03_JPRB,9.2999E-03_JPRB/)
KBO( :, 5,27, 5) = (/&
&6.1684E-04_JPRB,5.3899E-03_JPRB,7.8886E-03_JPRB,9.5804E-03_JPRB,9.1956E-03_JPRB/)
KBO( :, 1,28, 5) = (/&
&1.4962E-04_JPRB,3.2968E-03_JPRB,5.3486E-03_JPRB,7.0211E-03_JPRB,7.6657E-03_JPRB/)
KBO( :, 2,28, 5) = (/&
&2.1414E-04_JPRB,3.5906E-03_JPRB,5.6546E-03_JPRB,7.2727E-03_JPRB,7.6801E-03_JPRB/)
KBO( :, 3,28, 5) = (/&
&2.9958E-04_JPRB,3.8927E-03_JPRB,5.9643E-03_JPRB,7.5099E-03_JPRB,7.6582E-03_JPRB/)
KBO( :, 4,28, 5) = (/&
&4.1038E-04_JPRB,4.2012E-03_JPRB,6.2693E-03_JPRB,7.7298E-03_JPRB,7.5988E-03_JPRB/)
KBO( :, 5,28, 5) = (/&
&5.4914E-04_JPRB,4.5240E-03_JPRB,6.5722E-03_JPRB,7.9359E-03_JPRB,7.5057E-03_JPRB/)
KBO( :, 1,29, 5) = (/&
&1.3561E-04_JPRB,2.7716E-03_JPRB,4.4584E-03_JPRB,5.8201E-03_JPRB,6.2872E-03_JPRB/)
KBO( :, 2,29, 5) = (/&
&1.9362E-04_JPRB,3.0169E-03_JPRB,4.7155E-03_JPRB,6.0283E-03_JPRB,6.2926E-03_JPRB/)
KBO( :, 3,29, 5) = (/&
&2.6977E-04_JPRB,3.2683E-03_JPRB,4.9713E-03_JPRB,6.2221E-03_JPRB,6.2669E-03_JPRB/)
KBO( :, 4,29, 5) = (/&
&3.6734E-04_JPRB,3.5269E-03_JPRB,5.2257E-03_JPRB,6.4042E-03_JPRB,6.2118E-03_JPRB/)
KBO( :, 5,29, 5) = (/&
&4.8841E-04_JPRB,3.8031E-03_JPRB,5.4769E-03_JPRB,6.5743E-03_JPRB,6.1306E-03_JPRB/)
KBO( :, 1,30, 5) = (/&
&1.2311E-04_JPRB,2.3299E-03_JPRB,3.7176E-03_JPRB,4.8241E-03_JPRB,5.1561E-03_JPRB/)
KBO( :, 2,30, 5) = (/&
&1.7495E-04_JPRB,2.5344E-03_JPRB,3.9319E-03_JPRB,4.9954E-03_JPRB,5.1555E-03_JPRB/)
KBO( :, 3,30, 5) = (/&
&2.4248E-04_JPRB,2.7440E-03_JPRB,4.1448E-03_JPRB,5.1563E-03_JPRB,5.1297E-03_JPRB/)
KBO( :, 4,30, 5) = (/&
&3.2798E-04_JPRB,2.9629E-03_JPRB,4.3553E-03_JPRB,5.3054E-03_JPRB,5.0790E-03_JPRB/)
KBO( :, 5,30, 5) = (/&
&4.3295E-04_JPRB,3.2017E-03_JPRB,4.5670E-03_JPRB,5.4466E-03_JPRB,5.0095E-03_JPRB/)
KBO( :, 1,31, 5) = (/&
&1.1192E-04_JPRB,1.9595E-03_JPRB,3.1024E-03_JPRB,4.0004E-03_JPRB,4.2313E-03_JPRB/)
KBO( :, 2,31, 5) = (/&
&1.5800E-04_JPRB,2.1296E-03_JPRB,3.2801E-03_JPRB,4.1421E-03_JPRB,4.2268E-03_JPRB/)
KBO( :, 3,31, 5) = (/&
&2.1757E-04_JPRB,2.3054E-03_JPRB,3.4565E-03_JPRB,4.2735E-03_JPRB,4.2017E-03_JPRB/)
KBO( :, 4,31, 5) = (/&
&2.9222E-04_JPRB,2.4942E-03_JPRB,3.6328E-03_JPRB,4.3970E-03_JPRB,4.1575E-03_JPRB/)
KBO( :, 5,31, 5) = (/&
&3.8261E-04_JPRB,2.7007E-03_JPRB,3.8145E-03_JPRB,4.5146E-03_JPRB,4.0989E-03_JPRB/)
KBO( :, 1,32, 5) = (/&
&1.0163E-04_JPRB,1.6481E-03_JPRB,2.5899E-03_JPRB,3.3182E-03_JPRB,3.4733E-03_JPRB/)
KBO( :, 2,32, 5) = (/&
&1.4246E-04_JPRB,1.7902E-03_JPRB,2.7371E-03_JPRB,3.4345E-03_JPRB,3.4660E-03_JPRB/)
KBO( :, 3,32, 5) = (/&
&1.9480E-04_JPRB,1.9398E-03_JPRB,2.8839E-03_JPRB,3.5427E-03_JPRB,3.4424E-03_JPRB/)
KBO( :, 4,32, 5) = (/&
&2.5957E-04_JPRB,2.1035E-03_JPRB,3.0336E-03_JPRB,3.6462E-03_JPRB,3.4050E-03_JPRB/)
KBO( :, 5,32, 5) = (/&
&3.3711E-04_JPRB,2.2803E-03_JPRB,3.1908E-03_JPRB,3.7450E-03_JPRB,3.3564E-03_JPRB/)
KBO( :, 1,33, 5) = (/&
&9.2126E-05_JPRB,1.3862E-03_JPRB,2.1619E-03_JPRB,2.7533E-03_JPRB,2.8512E-03_JPRB/)
KBO( :, 2,33, 5) = (/&
&1.2819E-04_JPRB,1.5059E-03_JPRB,2.2846E-03_JPRB,2.8490E-03_JPRB,2.8435E-03_JPRB/)
KBO( :, 3,33, 5) = (/&
&1.7396E-04_JPRB,1.6352E-03_JPRB,2.4079E-03_JPRB,2.9394E-03_JPRB,2.8229E-03_JPRB/)
KBO( :, 4,33, 5) = (/&
&2.2988E-04_JPRB,1.7763E-03_JPRB,2.5366E-03_JPRB,3.0253E-03_JPRB,2.7916E-03_JPRB/)
KBO( :, 5,33, 5) = (/&
&2.9642E-04_JPRB,1.9270E-03_JPRB,2.6736E-03_JPRB,3.1112E-03_JPRB,2.7515E-03_JPRB/)
KBO( :, 1,34, 5) = (/&
&8.2273E-05_JPRB,1.1628E-03_JPRB,1.8018E-03_JPRB,2.2821E-03_JPRB,2.3408E-03_JPRB/)
KBO( :, 2,34, 5) = (/&
&1.1377E-04_JPRB,1.2650E-03_JPRB,1.9038E-03_JPRB,2.3616E-03_JPRB,2.3330E-03_JPRB/)
KBO( :, 3,34, 5) = (/&
&1.5328E-04_JPRB,1.3767E-03_JPRB,2.0090E-03_JPRB,2.4362E-03_JPRB,2.3154E-03_JPRB/)
KBO( :, 4,34, 5) = (/&
&2.0116E-04_JPRB,1.4967E-03_JPRB,2.1205E-03_JPRB,2.5102E-03_JPRB,2.2896E-03_JPRB/)
KBO( :, 5,34, 5) = (/&
&2.5794E-04_JPRB,1.6239E-03_JPRB,2.2376E-03_JPRB,2.5850E-03_JPRB,2.2567E-03_JPRB/)
KBO( :, 1,35, 5) = (/&
&7.0985E-05_JPRB,9.6792E-04_JPRB,1.4935E-03_JPRB,1.8860E-03_JPRB,1.9224E-03_JPRB/)
KBO( :, 2,35, 5) = (/&
&9.7802E-05_JPRB,1.0553E-03_JPRB,1.5791E-03_JPRB,1.9515E-03_JPRB,1.9160E-03_JPRB/)
KBO( :, 3,35, 5) = (/&
&1.3114E-04_JPRB,1.1504E-03_JPRB,1.6692E-03_JPRB,2.0149E-03_JPRB,1.9021E-03_JPRB/)
KBO( :, 4,35, 5) = (/&
&1.7143E-04_JPRB,1.2515E-03_JPRB,1.7654E-03_JPRB,2.0786E-03_JPRB,1.8814E-03_JPRB/)
KBO( :, 5,35, 5) = (/&
&2.1910E-04_JPRB,1.3576E-03_JPRB,1.8646E-03_JPRB,2.1453E-03_JPRB,1.8551E-03_JPRB/)
KBO( :, 1,36, 5) = (/&
&5.9035E-05_JPRB,7.9892E-04_JPRB,1.2308E-03_JPRB,1.5523E-03_JPRB,1.5795E-03_JPRB/)
KBO( :, 2,36, 5) = (/&
&8.1217E-05_JPRB,8.7305E-04_JPRB,1.3026E-03_JPRB,1.6078E-03_JPRB,1.5749E-03_JPRB/)
KBO( :, 3,36, 5) = (/&
&1.0874E-04_JPRB,9.5286E-04_JPRB,1.3800E-03_JPRB,1.6617E-03_JPRB,1.5644E-03_JPRB/)
KBO( :, 4,36, 5) = (/&
&1.4198E-04_JPRB,1.0374E-03_JPRB,1.4616E-03_JPRB,1.7169E-03_JPRB,1.5482E-03_JPRB/)
KBO( :, 5,36, 5) = (/&
&1.8132E-04_JPRB,1.1249E-03_JPRB,1.5450E-03_JPRB,1.7750E-03_JPRB,1.5279E-03_JPRB/)
KBO( :, 1,37, 5) = (/&
&4.6641E-05_JPRB,6.5099E-04_JPRB,1.0056E-03_JPRB,1.2714E-03_JPRB,1.2972E-03_JPRB/)
KBO( :, 2,37, 5) = (/&
&6.4348E-05_JPRB,7.1292E-04_JPRB,1.0660E-03_JPRB,1.3181E-03_JPRB,1.2951E-03_JPRB/)
KBO( :, 3,37, 5) = (/&
&8.6362E-05_JPRB,7.7917E-04_JPRB,1.1314E-03_JPRB,1.3641E-03_JPRB,1.2877E-03_JPRB/)
KBO( :, 4,37, 5) = (/&
&1.1309E-04_JPRB,8.4913E-04_JPRB,1.1999E-03_JPRB,1.4118E-03_JPRB,1.2757E-03_JPRB/)
KBO( :, 5,37, 5) = (/&
&1.4475E-04_JPRB,9.2097E-04_JPRB,1.2698E-03_JPRB,1.4619E-03_JPRB,1.2601E-03_JPRB/)
KBO( :, 1,38, 5) = (/&
&3.6723E-05_JPRB,5.3005E-04_JPRB,8.2089E-04_JPRB,1.0406E-03_JPRB,1.0656E-03_JPRB/)
KBO( :, 2,38, 5) = (/&
&5.0809E-05_JPRB,5.8160E-04_JPRB,8.7173E-04_JPRB,1.0802E-03_JPRB,1.0654E-03_JPRB/)
KBO( :, 3,38, 5) = (/&
&6.8411E-05_JPRB,6.3671E-04_JPRB,9.2702E-04_JPRB,1.1191E-03_JPRB,1.0602E-03_JPRB/)
KBO( :, 4,38, 5) = (/&
&8.9837E-05_JPRB,6.9447E-04_JPRB,9.8469E-04_JPRB,1.1603E-03_JPRB,1.0517E-03_JPRB/)
KBO( :, 5,38, 5) = (/&
&1.1531E-04_JPRB,7.5325E-04_JPRB,1.0431E-03_JPRB,1.2032E-03_JPRB,1.0398E-03_JPRB/)
KBO( :, 1,39, 5) = (/&
&2.8898E-05_JPRB,4.3158E-04_JPRB,6.7024E-04_JPRB,8.5167E-04_JPRB,8.7586E-04_JPRB/)
KBO( :, 2,39, 5) = (/&
&4.0107E-05_JPRB,4.7450E-04_JPRB,7.1291E-04_JPRB,8.8507E-04_JPRB,8.7670E-04_JPRB/)
KBO( :, 3,39, 5) = (/&
&5.4168E-05_JPRB,5.2021E-04_JPRB,7.5961E-04_JPRB,9.1815E-04_JPRB,8.7354E-04_JPRB/)
KBO( :, 4,39, 5) = (/&
&7.1354E-05_JPRB,5.6789E-04_JPRB,8.0816E-04_JPRB,9.5425E-04_JPRB,8.6787E-04_JPRB/)
KBO( :, 5,39, 5) = (/&
&9.1825E-05_JPRB,6.1595E-04_JPRB,8.5693E-04_JPRB,9.9080E-04_JPRB,8.5879E-04_JPRB/)
KBO( :, 1,40, 5) = (/&
&2.1926E-05_JPRB,3.4792E-04_JPRB,5.4363E-04_JPRB,6.9406E-04_JPRB,7.1842E-04_JPRB/)
KBO( :, 2,40, 5) = (/&
&3.0613E-05_JPRB,3.8334E-04_JPRB,5.7923E-04_JPRB,7.2214E-04_JPRB,7.2011E-04_JPRB/)
KBO( :, 3,40, 5) = (/&
&4.1595E-05_JPRB,4.2107E-04_JPRB,6.1835E-04_JPRB,7.5061E-04_JPRB,7.1871E-04_JPRB/)
KBO( :, 4,40, 5) = (/&
&5.5108E-05_JPRB,4.6016E-04_JPRB,6.5893E-04_JPRB,7.8109E-04_JPRB,7.1463E-04_JPRB/)
KBO( :, 5,40, 5) = (/&
&7.1275E-05_JPRB,4.9940E-04_JPRB,6.9980E-04_JPRB,8.1264E-04_JPRB,7.0800E-04_JPRB/)
KBO( :, 1,41, 5) = (/&
&1.6527E-05_JPRB,2.7994E-04_JPRB,4.4041E-04_JPRB,5.6504E-04_JPRB,5.8892E-04_JPRB/)
KBO( :, 2,41, 5) = (/&
&2.3240E-05_JPRB,3.0917E-04_JPRB,4.7005E-04_JPRB,5.8887E-04_JPRB,5.9140E-04_JPRB/)
KBO( :, 3,41, 5) = (/&
&3.1779E-05_JPRB,3.4025E-04_JPRB,5.0274E-04_JPRB,6.1295E-04_JPRB,5.9095E-04_JPRB/)
KBO( :, 4,41, 5) = (/&
&4.2345E-05_JPRB,3.7229E-04_JPRB,5.3669E-04_JPRB,6.3912E-04_JPRB,5.8845E-04_JPRB/)
KBO( :, 5,41, 5) = (/&
&5.5088E-05_JPRB,4.0429E-04_JPRB,5.7085E-04_JPRB,6.6587E-04_JPRB,5.8356E-04_JPRB/)
KBO( :, 1,42, 5) = (/&
&1.2429E-05_JPRB,2.2514E-04_JPRB,3.5666E-04_JPRB,4.5978E-04_JPRB,4.8268E-04_JPRB/)
KBO( :, 2,42, 5) = (/&
&1.7617E-05_JPRB,2.4922E-04_JPRB,3.8130E-04_JPRB,4.8000E-04_JPRB,4.8554E-04_JPRB/)
KBO( :, 3,42, 5) = (/&
&2.4234E-05_JPRB,2.7477E-04_JPRB,4.0862E-04_JPRB,5.0042E-04_JPRB,4.8593E-04_JPRB/)
KBO( :, 4,42, 5) = (/&
&3.2488E-05_JPRB,3.0100E-04_JPRB,4.3706E-04_JPRB,5.2275E-04_JPRB,4.8456E-04_JPRB/)
KBO( :, 5,42, 5) = (/&
&4.2516E-05_JPRB,3.2713E-04_JPRB,4.6549E-04_JPRB,5.4559E-04_JPRB,4.8115E-04_JPRB/)
KBO( :, 1,43, 5) = (/&
&9.1288E-06_JPRB,1.7990E-04_JPRB,2.8763E-04_JPRB,3.7307E-04_JPRB,3.9529E-04_JPRB/)
KBO( :, 2,43, 5) = (/&
&1.3070E-05_JPRB,1.9955E-04_JPRB,3.0790E-04_JPRB,3.8997E-04_JPRB,3.9826E-04_JPRB/)
KBO( :, 3,43, 5) = (/&
&1.8123E-05_JPRB,2.2051E-04_JPRB,3.3057E-04_JPRB,4.0731E-04_JPRB,3.9935E-04_JPRB/)
KBO( :, 4,43, 5) = (/&
&2.4489E-05_JPRB,2.4201E-04_JPRB,3.5433E-04_JPRB,4.2614E-04_JPRB,3.9876E-04_JPRB/)
KBO( :, 5,43, 5) = (/&
&3.2280E-05_JPRB,2.6336E-04_JPRB,3.7813E-04_JPRB,4.4577E-04_JPRB,3.9669E-04_JPRB/)
KBO( :, 1,44, 5) = (/&
&6.6151E-06_JPRB,1.4326E-04_JPRB,2.3138E-04_JPRB,3.0204E-04_JPRB,3.2336E-04_JPRB/)
KBO( :, 2,44, 5) = (/&
&9.5822E-06_JPRB,1.5927E-04_JPRB,2.4809E-04_JPRB,3.1644E-04_JPRB,3.2651E-04_JPRB/)
KBO( :, 3,44, 5) = (/&
&1.3410E-05_JPRB,1.7639E-04_JPRB,2.6682E-04_JPRB,3.3096E-04_JPRB,3.2809E-04_JPRB/)
KBO( :, 4,44, 5) = (/&
&1.8276E-05_JPRB,1.9397E-04_JPRB,2.8664E-04_JPRB,3.4697E-04_JPRB,3.2823E-04_JPRB/)
KBO( :, 5,44, 5) = (/&
&2.4286E-05_JPRB,2.1151E-04_JPRB,3.0643E-04_JPRB,3.6349E-04_JPRB,3.2698E-04_JPRB/)
KBO( :, 1,45, 5) = (/&
&4.7734E-06_JPRB,1.1403E-04_JPRB,1.8604E-04_JPRB,2.4442E-04_JPRB,2.6449E-04_JPRB/)
KBO( :, 2,45, 5) = (/&
&6.9996E-06_JPRB,1.2693E-04_JPRB,1.9973E-04_JPRB,2.5644E-04_JPRB,2.6762E-04_JPRB/)
KBO( :, 3,45, 5) = (/&
&9.8982E-06_JPRB,1.4091E-04_JPRB,2.1513E-04_JPRB,2.6865E-04_JPRB,2.6944E-04_JPRB/)
KBO( :, 4,45, 5) = (/&
&1.3603E-05_JPRB,1.5533E-04_JPRB,2.3165E-04_JPRB,2.8211E-04_JPRB,2.7010E-04_JPRB/)
KBO( :, 5,45, 5) = (/&
&1.8224E-05_JPRB,1.6976E-04_JPRB,2.4816E-04_JPRB,2.9621E-04_JPRB,2.6963E-04_JPRB/)
KBO( :, 1,46, 5) = (/&
&3.3983E-06_JPRB,9.0473E-05_JPRB,1.4921E-04_JPRB,1.9732E-04_JPRB,2.1604E-04_JPRB/)
KBO( :, 2,46, 5) = (/&
&5.0514E-06_JPRB,1.0084E-04_JPRB,1.6045E-04_JPRB,2.0752E-04_JPRB,2.1916E-04_JPRB/)
KBO( :, 3,46, 5) = (/&
&7.2271E-06_JPRB,1.1223E-04_JPRB,1.7305E-04_JPRB,2.1775E-04_JPRB,2.2117E-04_JPRB/)
KBO( :, 4,46, 5) = (/&
&1.0026E-05_JPRB,1.2405E-04_JPRB,1.8678E-04_JPRB,2.2906E-04_JPRB,2.2224E-04_JPRB/)
KBO( :, 5,46, 5) = (/&
&1.3554E-05_JPRB,1.3592E-04_JPRB,2.0050E-04_JPRB,2.4099E-04_JPRB,2.2226E-04_JPRB/)
KBO( :, 1,47, 5) = (/&
&2.3650E-06_JPRB,7.1417E-05_JPRB,1.1919E-04_JPRB,1.5882E-04_JPRB,1.7611E-04_JPRB/)
KBO( :, 2,47, 5) = (/&
&3.5679E-06_JPRB,7.9650E-05_JPRB,1.2838E-04_JPRB,1.6748E-04_JPRB,1.7919E-04_JPRB/)
KBO( :, 3,47, 5) = (/&
&5.1778E-06_JPRB,8.8892E-05_JPRB,1.3863E-04_JPRB,1.7599E-04_JPRB,1.8128E-04_JPRB/)
KBO( :, 4,47, 5) = (/&
&7.2636E-06_JPRB,9.8532E-05_JPRB,1.4995E-04_JPRB,1.8532E-04_JPRB,1.8257E-04_JPRB/)
KBO( :, 5,47, 5) = (/&
&9.9200E-06_JPRB,1.0829E-04_JPRB,1.6134E-04_JPRB,1.9543E-04_JPRB,1.8296E-04_JPRB/)
KBO( :, 1,48, 5) = (/&
&1.6346E-06_JPRB,5.6335E-05_JPRB,9.5109E-05_JPRB,1.2769E-04_JPRB,1.4342E-04_JPRB/)
KBO( :, 2,48, 5) = (/&
&2.5038E-06_JPRB,6.2854E-05_JPRB,1.0261E-04_JPRB,1.3493E-04_JPRB,1.4636E-04_JPRB/)
KBO( :, 3,48, 5) = (/&
&3.6896E-06_JPRB,7.0296E-05_JPRB,1.1094E-04_JPRB,1.4209E-04_JPRB,1.4851E-04_JPRB/)
KBO( :, 4,48, 5) = (/&
&5.2406E-06_JPRB,7.8146E-05_JPRB,1.2020E-04_JPRB,1.4978E-04_JPRB,1.4992E-04_JPRB/)
KBO( :, 5,48, 5) = (/&
&7.2291E-06_JPRB,8.6170E-05_JPRB,1.2966E-04_JPRB,1.5832E-04_JPRB,1.5064E-04_JPRB/)
KBO( :, 1,49, 5) = (/&
&1.1213E-06_JPRB,4.4399E-05_JPRB,7.5829E-05_JPRB,1.0254E-04_JPRB,1.1671E-04_JPRB/)
KBO( :, 2,49, 5) = (/&
&1.7465E-06_JPRB,4.9565E-05_JPRB,8.1954E-05_JPRB,1.0863E-04_JPRB,1.1954E-04_JPRB/)
KBO( :, 3,49, 5) = (/&
&2.6146E-06_JPRB,5.5485E-05_JPRB,8.8647E-05_JPRB,1.1460E-04_JPRB,1.2164E-04_JPRB/)
KBO( :, 4,49, 5) = (/&
&3.7631E-06_JPRB,6.1900E-05_JPRB,9.6246E-05_JPRB,1.2097E-04_JPRB,1.2315E-04_JPRB/)
KBO( :, 5,49, 5) = (/&
&5.2478E-06_JPRB,6.8486E-05_JPRB,1.0411E-04_JPRB,1.2810E-04_JPRB,1.2412E-04_JPRB/)
KBO( :, 1,50, 5) = (/&
&7.7219E-07_JPRB,3.5060E-05_JPRB,6.0501E-05_JPRB,8.2333E-05_JPRB,9.4799E-05_JPRB/)
KBO( :, 2,50, 5) = (/&
&1.2243E-06_JPRB,3.9171E-05_JPRB,6.5508E-05_JPRB,8.7444E-05_JPRB,9.7433E-05_JPRB/)
KBO( :, 3,50, 5) = (/&
&1.8601E-06_JPRB,4.3898E-05_JPRB,7.0971E-05_JPRB,9.2481E-05_JPRB,9.9443E-05_JPRB/)
KBO( :, 4,50, 5) = (/&
&2.7138E-06_JPRB,4.9113E-05_JPRB,7.7142E-05_JPRB,9.7774E-05_JPRB,1.0093E-04_JPRB/)
KBO( :, 5,50, 5) = (/&
&3.8270E-06_JPRB,5.4504E-05_JPRB,8.3666E-05_JPRB,1.0372E-04_JPRB,1.0197E-04_JPRB/)
KBO( :, 1,51, 5) = (/&
&5.3024E-07_JPRB,2.7696E-05_JPRB,4.8261E-05_JPRB,6.6083E-05_JPRB,7.6892E-05_JPRB/)
KBO( :, 2,51, 5) = (/&
&8.5735E-07_JPRB,3.0983E-05_JPRB,5.2368E-05_JPRB,7.0412E-05_JPRB,7.9289E-05_JPRB/)
KBO( :, 3,51, 5) = (/&
&1.3218E-06_JPRB,3.4738E-05_JPRB,5.6824E-05_JPRB,7.4609E-05_JPRB,8.1180E-05_JPRB/)
KBO( :, 4,51, 5) = (/&
&1.9559E-06_JPRB,3.8961E-05_JPRB,6.1833E-05_JPRB,7.8998E-05_JPRB,8.2596E-05_JPRB/)
KBO( :, 5,51, 5) = (/&
&2.7897E-06_JPRB,4.3372E-05_JPRB,6.7221E-05_JPRB,8.3927E-05_JPRB,8.3636E-05_JPRB/)
KBO( :, 1,52, 5) = (/&
&3.6108E-07_JPRB,2.1866E-05_JPRB,3.8454E-05_JPRB,5.2969E-05_JPRB,6.2335E-05_JPRB/)
KBO( :, 2,52, 5) = (/&
&5.9667E-07_JPRB,2.4493E-05_JPRB,4.1837E-05_JPRB,5.6625E-05_JPRB,6.4483E-05_JPRB/)
KBO( :, 3,52, 5) = (/&
&9.3484E-07_JPRB,2.7465E-05_JPRB,4.5448E-05_JPRB,6.0126E-05_JPRB,6.6246E-05_JPRB/)
KBO( :, 4,52, 5) = (/&
&1.4036E-06_JPRB,3.0877E-05_JPRB,4.9517E-05_JPRB,6.3789E-05_JPRB,6.7578E-05_JPRB/)
KBO( :, 5,52, 5) = (/&
&2.0268E-06_JPRB,3.4479E-05_JPRB,5.3935E-05_JPRB,6.7855E-05_JPRB,6.8602E-05_JPRB/)
KBO( :, 1,53, 5) = (/&
&2.4332E-07_JPRB,1.7244E-05_JPRB,3.0597E-05_JPRB,4.2405E-05_JPRB,5.0498E-05_JPRB/)
KBO( :, 2,53, 5) = (/&
&4.1214E-07_JPRB,1.9345E-05_JPRB,3.3390E-05_JPRB,4.5480E-05_JPRB,5.2422E-05_JPRB/)
KBO( :, 3,53, 5) = (/&
&6.5730E-07_JPRB,2.1709E-05_JPRB,3.6329E-05_JPRB,4.8415E-05_JPRB,5.4043E-05_JPRB/)
KBO( :, 4,53, 5) = (/&
&1.0016E-06_JPRB,2.4434E-05_JPRB,3.9600E-05_JPRB,5.1439E-05_JPRB,5.5301E-05_JPRB/)
KBO( :, 5,53, 5) = (/&
&1.4656E-06_JPRB,2.7368E-05_JPRB,4.3227E-05_JPRB,5.4790E-05_JPRB,5.6292E-05_JPRB/)
KBO( :, 1,54, 5) = (/&
&1.6511E-07_JPRB,1.3630E-05_JPRB,2.4378E-05_JPRB,3.3979E-05_JPRB,4.0794E-05_JPRB/)
KBO( :, 2,54, 5) = (/&
&2.8688E-07_JPRB,1.5326E-05_JPRB,2.6694E-05_JPRB,3.6556E-05_JPRB,4.2472E-05_JPRB/)
KBO( :, 3,54, 5) = (/&
&4.6588E-07_JPRB,1.7208E-05_JPRB,2.9089E-05_JPRB,3.9026E-05_JPRB,4.3891E-05_JPRB/)
KBO( :, 4,54, 5) = (/&
&7.2012E-07_JPRB,1.9389E-05_JPRB,3.1742E-05_JPRB,4.1533E-05_JPRB,4.5023E-05_JPRB/)
KBO( :, 5,54, 5) = (/&
&1.0672E-06_JPRB,2.1776E-05_JPRB,3.4708E-05_JPRB,4.4305E-05_JPRB,4.5917E-05_JPRB/)
KBO( :, 1,55, 5) = (/&
&1.1192E-07_JPRB,1.0784E-05_JPRB,1.9433E-05_JPRB,2.7227E-05_JPRB,3.2881E-05_JPRB/)
KBO( :, 2,55, 5) = (/&
&1.9966E-07_JPRB,1.2152E-05_JPRB,2.1341E-05_JPRB,2.9385E-05_JPRB,3.4331E-05_JPRB/)
KBO( :, 3,55, 5) = (/&
&3.3052E-07_JPRB,1.3654E-05_JPRB,2.3300E-05_JPRB,3.1458E-05_JPRB,3.5546E-05_JPRB/)
KBO( :, 4,55, 5) = (/&
&5.1840E-07_JPRB,1.5395E-05_JPRB,2.5450E-05_JPRB,3.3531E-05_JPRB,3.6538E-05_JPRB/)
KBO( :, 5,55, 5) = (/&
&7.7808E-07_JPRB,1.7333E-05_JPRB,2.7868E-05_JPRB,3.5813E-05_JPRB,3.7304E-05_JPRB/)
KBO( :, 1,56, 5) = (/&
&7.5122E-08_JPRB,8.5244E-06_JPRB,1.5477E-05_JPRB,2.1786E-05_JPRB,2.6473E-05_JPRB/)
KBO( :, 2,56, 5) = (/&
&1.3800E-07_JPRB,9.6271E-06_JPRB,1.7041E-05_JPRB,2.3587E-05_JPRB,2.7734E-05_JPRB/)
KBO( :, 3,56, 5) = (/&
&2.3328E-07_JPRB,1.0832E-05_JPRB,1.8654E-05_JPRB,2.5333E-05_JPRB,2.8773E-05_JPRB/)
KBO( :, 4,56, 5) = (/&
&3.7175E-07_JPRB,1.2217E-05_JPRB,2.0395E-05_JPRB,2.7050E-05_JPRB,2.9637E-05_JPRB/)
KBO( :, 5,56, 5) = (/&
&5.6529E-07_JPRB,1.3785E-05_JPRB,2.2358E-05_JPRB,2.8934E-05_JPRB,3.0300E-05_JPRB/)
KBO( :, 1,57, 5) = (/&
&4.9911E-08_JPRB,6.7334E-06_JPRB,1.2315E-05_JPRB,1.7411E-05_JPRB,2.1292E-05_JPRB/)
KBO( :, 2,57, 5) = (/&
&9.4564E-08_JPRB,7.6208E-06_JPRB,1.3595E-05_JPRB,1.8912E-05_JPRB,2.2387E-05_JPRB/)
KBO( :, 3,57, 5) = (/&
&1.6361E-07_JPRB,8.5900E-06_JPRB,1.4922E-05_JPRB,2.0379E-05_JPRB,2.3279E-05_JPRB/)
KBO( :, 4,57, 5) = (/&
&2.6533E-07_JPRB,9.6896E-06_JPRB,1.6333E-05_JPRB,2.1806E-05_JPRB,2.4024E-05_JPRB/)
KBO( :, 5,57, 5) = (/&
&4.0896E-07_JPRB,1.0955E-05_JPRB,1.7923E-05_JPRB,2.3357E-05_JPRB,2.4605E-05_JPRB/)
KBO( :, 1,58, 5) = (/&
&3.3413E-08_JPRB,5.3223E-06_JPRB,9.7997E-06_JPRB,1.3911E-05_JPRB,1.7115E-05_JPRB/)
KBO( :, 2,58, 5) = (/&
&6.4876E-08_JPRB,6.0389E-06_JPRB,1.0850E-05_JPRB,1.5164E-05_JPRB,1.8057E-05_JPRB/)
KBO( :, 3,58, 5) = (/&
&1.1501E-07_JPRB,6.8202E-06_JPRB,1.1942E-05_JPRB,1.6396E-05_JPRB,1.8824E-05_JPRB/)
KBO( :, 4,58, 5) = (/&
&1.8988E-07_JPRB,7.6962E-06_JPRB,1.3093E-05_JPRB,1.7589E-05_JPRB,1.9461E-05_JPRB/)
KBO( :, 5,58, 5) = (/&
&2.9670E-07_JPRB,8.7155E-06_JPRB,1.4378E-05_JPRB,1.8862E-05_JPRB,1.9967E-05_JPRB/)
KBO( :, 1,59, 5) = (/&
&2.5326E-08_JPRB,4.3059E-06_JPRB,7.9479E-06_JPRB,1.1296E-05_JPRB,1.3872E-05_JPRB/)
KBO( :, 2,59, 5) = (/&
&4.9570E-08_JPRB,4.8933E-06_JPRB,8.8138E-06_JPRB,1.2338E-05_JPRB,1.4642E-05_JPRB/)
KBO( :, 3,59, 5) = (/&
&8.8759E-08_JPRB,5.5323E-06_JPRB,9.7147E-06_JPRB,1.3360E-05_JPRB,1.5267E-05_JPRB/)
KBO( :, 4,59, 5) = (/&
&1.4767E-07_JPRB,6.2484E-06_JPRB,1.0666E-05_JPRB,1.4358E-05_JPRB,1.5775E-05_JPRB/)
KBO( :, 5,59, 5) = (/&
&2.3207E-07_JPRB,7.0847E-06_JPRB,1.1728E-05_JPRB,1.5422E-05_JPRB,1.6178E-05_JPRB/)
KBO( :, 1,13, 6) = (/&
&2.6469E-03_JPRB,7.2603E-02_JPRB,1.2898E-01_JPRB,1.8080E-01_JPRB,2.2253E-01_JPRB/)
KBO( :, 2,13, 6) = (/&
&4.0410E-03_JPRB,7.8062E-02_JPRB,1.3546E-01_JPRB,1.8736E-01_JPRB,2.2767E-01_JPRB/)
KBO( :, 3,13, 6) = (/&
&5.9076E-03_JPRB,8.4142E-02_JPRB,1.4233E-01_JPRB,1.9380E-01_JPRB,2.3269E-01_JPRB/)
KBO( :, 4,13, 6) = (/&
&8.3159E-03_JPRB,9.0550E-02_JPRB,1.4952E-01_JPRB,2.0027E-01_JPRB,2.3737E-01_JPRB/)
KBO( :, 5,13, 6) = (/&
&1.1338E-02_JPRB,9.6973E-02_JPRB,1.5692E-01_JPRB,2.0664E-01_JPRB,2.4174E-01_JPRB/)
KBO( :, 1,14, 6) = (/&
&2.3459E-03_JPRB,6.5146E-02_JPRB,1.1561E-01_JPRB,1.6205E-01_JPRB,1.9813E-01_JPRB/)
KBO( :, 2,14, 6) = (/&
&3.5742E-03_JPRB,7.0309E-02_JPRB,1.2183E-01_JPRB,1.6837E-01_JPRB,2.0310E-01_JPRB/)
KBO( :, 3,14, 6) = (/&
&5.2156E-03_JPRB,7.5953E-02_JPRB,1.2830E-01_JPRB,1.7462E-01_JPRB,2.0779E-01_JPRB/)
KBO( :, 4,14, 6) = (/&
&7.3297E-03_JPRB,8.1768E-02_JPRB,1.3506E-01_JPRB,1.8090E-01_JPRB,2.1206E-01_JPRB/)
KBO( :, 5,14, 6) = (/&
&9.9793E-03_JPRB,8.7785E-02_JPRB,1.4192E-01_JPRB,1.8688E-01_JPRB,2.1597E-01_JPRB/)
KBO( :, 1,15, 6) = (/&
&2.0815E-03_JPRB,5.8070E-02_JPRB,1.0290E-01_JPRB,1.4403E-01_JPRB,1.7518E-01_JPRB/)
KBO( :, 2,15, 6) = (/&
&3.1616E-03_JPRB,6.2877E-02_JPRB,1.0871E-01_JPRB,1.5003E-01_JPRB,1.7983E-01_JPRB/)
KBO( :, 3,15, 6) = (/&
&4.5990E-03_JPRB,6.8034E-02_JPRB,1.1474E-01_JPRB,1.5600E-01_JPRB,1.8413E-01_JPRB/)
KBO( :, 4,15, 6) = (/&
&6.4457E-03_JPRB,7.3357E-02_JPRB,1.2094E-01_JPRB,1.6184E-01_JPRB,1.8811E-01_JPRB/)
KBO( :, 5,15, 6) = (/&
&8.7688E-03_JPRB,7.8954E-02_JPRB,1.2718E-01_JPRB,1.6743E-01_JPRB,1.9184E-01_JPRB/)
KBO( :, 1,16, 6) = (/&
&1.8434E-03_JPRB,5.1431E-02_JPRB,9.0904E-02_JPRB,1.2695E-01_JPRB,1.5373E-01_JPRB/)
KBO( :, 2,16, 6) = (/&
&2.7883E-03_JPRB,5.5853E-02_JPRB,9.6202E-02_JPRB,1.3255E-01_JPRB,1.5805E-01_JPRB/)
KBO( :, 3,16, 6) = (/&
&4.0405E-03_JPRB,6.0484E-02_JPRB,1.0174E-01_JPRB,1.3809E-01_JPRB,1.6209E-01_JPRB/)
KBO( :, 4,16, 6) = (/&
&5.6545E-03_JPRB,6.5388E-02_JPRB,1.0742E-01_JPRB,1.4346E-01_JPRB,1.6594E-01_JPRB/)
KBO( :, 5,16, 6) = (/&
&7.6948E-03_JPRB,7.0557E-02_JPRB,1.1317E-01_JPRB,1.4876E-01_JPRB,1.6944E-01_JPRB/)
KBO( :, 1,17, 6) = (/&
&1.6228E-03_JPRB,4.5214E-02_JPRB,7.9628E-02_JPRB,1.1095E-01_JPRB,1.3382E-01_JPRB/)
KBO( :, 2,17, 6) = (/&
&2.4444E-03_JPRB,4.9201E-02_JPRB,8.4449E-02_JPRB,1.1610E-01_JPRB,1.3782E-01_JPRB/)
KBO( :, 3,17, 6) = (/&
&3.5341E-03_JPRB,5.3403E-02_JPRB,8.9520E-02_JPRB,1.2115E-01_JPRB,1.4166E-01_JPRB/)
KBO( :, 4,17, 6) = (/&
&4.9442E-03_JPRB,5.7899E-02_JPRB,9.4657E-02_JPRB,1.2610E-01_JPRB,1.4516E-01_JPRB/)
KBO( :, 5,17, 6) = (/&
&6.7314E-03_JPRB,6.2605E-02_JPRB,9.9934E-02_JPRB,1.3078E-01_JPRB,1.4759E-01_JPRB/)
KBO( :, 1,18, 6) = (/&
&1.4215E-03_JPRB,3.9490E-02_JPRB,6.9231E-02_JPRB,9.6243E-02_JPRB,1.1568E-01_JPRB/)
KBO( :, 2,18, 6) = (/&
&2.1346E-03_JPRB,4.3045E-02_JPRB,7.3605E-02_JPRB,1.0089E-01_JPRB,1.1941E-01_JPRB/)
KBO( :, 3,18, 6) = (/&
&3.0824E-03_JPRB,4.6855E-02_JPRB,7.8190E-02_JPRB,1.0547E-01_JPRB,1.2277E-01_JPRB/)
KBO( :, 4,18, 6) = (/&
&4.3155E-03_JPRB,5.0887E-02_JPRB,8.2789E-02_JPRB,1.0966E-01_JPRB,1.2516E-01_JPRB/)
KBO( :, 5,18, 6) = (/&
&5.8773E-03_JPRB,5.5100E-02_JPRB,8.7246E-02_JPRB,1.1319E-01_JPRB,1.2607E-01_JPRB/)
KBO( :, 1,19, 6) = (/&
&1.2396E-03_JPRB,3.4273E-02_JPRB,5.9817E-02_JPRB,8.2935E-02_JPRB,9.9419E-02_JPRB/)
KBO( :, 2,19, 6) = (/&
&1.8580E-03_JPRB,3.7439E-02_JPRB,6.3787E-02_JPRB,8.7073E-02_JPRB,1.0261E-01_JPRB/)
KBO( :, 3,19, 6) = (/&
&2.6842E-03_JPRB,4.0827E-02_JPRB,6.7738E-02_JPRB,9.0822E-02_JPRB,1.0491E-01_JPRB/)
KBO( :, 4,19, 6) = (/&
&3.7596E-03_JPRB,4.4308E-02_JPRB,7.1517E-02_JPRB,9.3932E-02_JPRB,1.0593E-01_JPRB/)
KBO( :, 5,19, 6) = (/&
&5.1106E-03_JPRB,4.7901E-02_JPRB,7.4978E-02_JPRB,9.6351E-02_JPRB,1.0588E-01_JPRB/)
KBO( :, 1,20, 6) = (/&
&1.0863E-03_JPRB,2.9636E-02_JPRB,5.1506E-02_JPRB,7.1094E-02_JPRB,8.4913E-02_JPRB/)
KBO( :, 2,20, 6) = (/&
&1.6251E-03_JPRB,3.2413E-02_JPRB,5.4873E-02_JPRB,7.4436E-02_JPRB,8.7129E-02_JPRB/)
KBO( :, 3,20, 6) = (/&
&2.3482E-03_JPRB,3.5255E-02_JPRB,5.8051E-02_JPRB,7.7198E-02_JPRB,8.8290E-02_JPRB/)
KBO( :, 4,20, 6) = (/&
&3.2830E-03_JPRB,3.8154E-02_JPRB,6.0963E-02_JPRB,7.9391E-02_JPRB,8.8534E-02_JPRB/)
KBO( :, 5,20, 6) = (/&
&4.4496E-03_JPRB,4.1105E-02_JPRB,6.3670E-02_JPRB,8.1212E-02_JPRB,8.8096E-02_JPRB/)
KBO( :, 1,21, 6) = (/&
&9.5155E-04_JPRB,2.5477E-02_JPRB,4.4023E-02_JPRB,6.0405E-02_JPRB,7.1745E-02_JPRB/)
KBO( :, 2,21, 6) = (/&
&1.4227E-03_JPRB,2.7779E-02_JPRB,4.6702E-02_JPRB,6.2887E-02_JPRB,7.3006E-02_JPRB/)
KBO( :, 3,21, 6) = (/&
&2.0513E-03_JPRB,3.0099E-02_JPRB,4.9167E-02_JPRB,6.4894E-02_JPRB,7.3521E-02_JPRB/)
KBO( :, 4,21, 6) = (/&
&2.8588E-03_JPRB,3.2465E-02_JPRB,5.1448E-02_JPRB,6.6586E-02_JPRB,7.3416E-02_JPRB/)
KBO( :, 5,21, 6) = (/&
&3.8612E-03_JPRB,3.4927E-02_JPRB,5.3670E-02_JPRB,6.8026E-02_JPRB,7.2850E-02_JPRB/)
KBO( :, 1,22, 6) = (/&
&8.5713E-04_JPRB,2.1832E-02_JPRB,3.7420E-02_JPRB,5.0944E-02_JPRB,6.0002E-02_JPRB/)
KBO( :, 2,22, 6) = (/&
&1.2758E-03_JPRB,2.3688E-02_JPRB,3.9495E-02_JPRB,5.2772E-02_JPRB,6.0672E-02_JPRB/)
KBO( :, 3,22, 6) = (/&
&1.8291E-03_JPRB,2.5590E-02_JPRB,4.1428E-02_JPRB,5.4322E-02_JPRB,6.0829E-02_JPRB/)
KBO( :, 4,22, 6) = (/&
&2.5337E-03_JPRB,2.7556E-02_JPRB,4.3286E-02_JPRB,5.5664E-02_JPRB,6.0555E-02_JPRB/)
KBO( :, 5,22, 6) = (/&
&3.4060E-03_JPRB,2.9653E-02_JPRB,4.5131E-02_JPRB,5.6799E-02_JPRB,5.9942E-02_JPRB/)
KBO( :, 1,23, 6) = (/&
&7.7308E-04_JPRB,1.8541E-02_JPRB,3.1541E-02_JPRB,4.2653E-02_JPRB,4.9784E-02_JPRB/)
KBO( :, 2,23, 6) = (/&
&1.1436E-03_JPRB,2.0060E-02_JPRB,3.3177E-02_JPRB,4.4071E-02_JPRB,5.0135E-02_JPRB/)
KBO( :, 3,23, 6) = (/&
&1.6287E-03_JPRB,2.1636E-02_JPRB,3.4743E-02_JPRB,4.5309E-02_JPRB,5.0108E-02_JPRB/)
KBO( :, 4,23, 6) = (/&
&2.2433E-03_JPRB,2.3301E-02_JPRB,3.6276E-02_JPRB,4.6369E-02_JPRB,4.9769E-02_JPRB/)
KBO( :, 5,23, 6) = (/&
&3.0015E-03_JPRB,2.5093E-02_JPRB,3.7820E-02_JPRB,4.7284E-02_JPRB,4.9161E-02_JPRB/)
KBO( :, 1,24, 6) = (/&
&6.9820E-04_JPRB,1.5662E-02_JPRB,2.6451E-02_JPRB,3.5569E-02_JPRB,4.1103E-02_JPRB/)
KBO( :, 2,24, 6) = (/&
&1.0252E-03_JPRB,1.6916E-02_JPRB,2.7766E-02_JPRB,3.6705E-02_JPRB,4.1269E-02_JPRB/)
KBO( :, 3,24, 6) = (/&
&1.4503E-03_JPRB,1.8243E-02_JPRB,2.9050E-02_JPRB,3.7680E-02_JPRB,4.1148E-02_JPRB/)
KBO( :, 4,24, 6) = (/&
&1.9860E-03_JPRB,1.9665E-02_JPRB,3.0328E-02_JPRB,3.8530E-02_JPRB,4.0787E-02_JPRB/)
KBO( :, 5,24, 6) = (/&
&2.6469E-03_JPRB,2.1188E-02_JPRB,3.1637E-02_JPRB,3.9277E-02_JPRB,4.0220E-02_JPRB/)
KBO( :, 1,25, 6) = (/&
&6.3170E-04_JPRB,1.3191E-02_JPRB,2.2113E-02_JPRB,2.9594E-02_JPRB,3.3832E-02_JPRB/)
KBO( :, 2,25, 6) = (/&
&9.2001E-04_JPRB,1.4240E-02_JPRB,2.3188E-02_JPRB,3.0496E-02_JPRB,3.3883E-02_JPRB/)
KBO( :, 3,25, 6) = (/&
&1.2928E-03_JPRB,1.5370E-02_JPRB,2.4249E-02_JPRB,3.1273E-02_JPRB,3.3716E-02_JPRB/)
KBO( :, 4,25, 6) = (/&
&1.7603E-03_JPRB,1.6573E-02_JPRB,2.5329E-02_JPRB,3.1960E-02_JPRB,3.3363E-02_JPRB/)
KBO( :, 5,25, 6) = (/&
&2.3402E-03_JPRB,1.7869E-02_JPRB,2.6443E-02_JPRB,3.2590E-02_JPRB,3.2859E-02_JPRB/)
KBO( :, 1,26, 6) = (/&
&5.7419E-04_JPRB,1.1097E-02_JPRB,1.8461E-02_JPRB,2.4587E-02_JPRB,2.7791E-02_JPRB/)
KBO( :, 2,26, 6) = (/&
&8.2924E-04_JPRB,1.1987E-02_JPRB,1.9343E-02_JPRB,2.5297E-02_JPRB,2.7770E-02_JPRB/)
KBO( :, 3,26, 6) = (/&
&1.1565E-03_JPRB,1.2945E-02_JPRB,2.0233E-02_JPRB,2.5928E-02_JPRB,2.7584E-02_JPRB/)
KBO( :, 4,26, 6) = (/&
&1.5683E-03_JPRB,1.3972E-02_JPRB,2.1156E-02_JPRB,2.6492E-02_JPRB,2.7256E-02_JPRB/)
KBO( :, 5,26, 6) = (/&
&2.0814E-03_JPRB,1.5076E-02_JPRB,2.2099E-02_JPRB,2.7036E-02_JPRB,2.6815E-02_JPRB/)
KBO( :, 1,27, 6) = (/&
&5.2085E-04_JPRB,9.3262E-03_JPRB,1.5390E-02_JPRB,2.0394E-02_JPRB,2.2795E-02_JPRB/)
KBO( :, 2,27, 6) = (/&
&7.4611E-04_JPRB,1.0083E-02_JPRB,1.6124E-02_JPRB,2.0964E-02_JPRB,2.2740E-02_JPRB/)
KBO( :, 3,27, 6) = (/&
&1.0345E-03_JPRB,1.0897E-02_JPRB,1.6882E-02_JPRB,2.1477E-02_JPRB,2.2550E-02_JPRB/)
KBO( :, 4,27, 6) = (/&
&1.3997E-03_JPRB,1.1774E-02_JPRB,1.7663E-02_JPRB,2.1954E-02_JPRB,2.2255E-02_JPRB/)
KBO( :, 5,27, 6) = (/&
&1.8540E-03_JPRB,1.2711E-02_JPRB,1.8466E-02_JPRB,2.2421E-02_JPRB,2.1874E-02_JPRB/)
KBO( :, 1,28, 6) = (/&
&4.7154E-04_JPRB,7.8350E-03_JPRB,1.2820E-02_JPRB,1.6898E-02_JPRB,1.8683E-02_JPRB/)
KBO( :, 2,28, 6) = (/&
&6.7041E-04_JPRB,8.4791E-03_JPRB,1.3441E-02_JPRB,1.7362E-02_JPRB,1.8606E-02_JPRB/)
KBO( :, 3,28, 6) = (/&
&9.2613E-04_JPRB,9.1729E-03_JPRB,1.4084E-02_JPRB,1.7787E-02_JPRB,1.8427E-02_JPRB/)
KBO( :, 4,28, 6) = (/&
&1.2511E-03_JPRB,9.9188E-03_JPRB,1.4746E-02_JPRB,1.8199E-02_JPRB,1.8168E-02_JPRB/)
KBO( :, 5,28, 6) = (/&
&1.6528E-03_JPRB,1.0715E-02_JPRB,1.5432E-02_JPRB,1.8597E-02_JPRB,1.7841E-02_JPRB/)
KBO( :, 1,29, 6) = (/&
&4.2728E-04_JPRB,6.5872E-03_JPRB,1.0682E-02_JPRB,1.3997E-02_JPRB,1.5306E-02_JPRB/)
KBO( :, 2,29, 6) = (/&
&6.0398E-04_JPRB,7.1366E-03_JPRB,1.1209E-02_JPRB,1.4377E-02_JPRB,1.5221E-02_JPRB/)
KBO( :, 3,29, 6) = (/&
&8.3275E-04_JPRB,7.7277E-03_JPRB,1.1754E-02_JPRB,1.4740E-02_JPRB,1.5060E-02_JPRB/)
KBO( :, 4,29, 6) = (/&
&1.1219E-03_JPRB,8.3625E-03_JPRB,1.2318E-02_JPRB,1.5088E-02_JPRB,1.4833E-02_JPRB/)
KBO( :, 5,29, 6) = (/&
&1.4752E-03_JPRB,9.0420E-03_JPRB,1.2902E-02_JPRB,1.5434E-02_JPRB,1.4555E-02_JPRB/)
KBO( :, 1,30, 6) = (/&
&3.8695E-04_JPRB,5.5390E-03_JPRB,8.9023E-03_JPRB,1.1592E-02_JPRB,1.2537E-02_JPRB/)
KBO( :, 2,30, 6) = (/&
&5.4519E-04_JPRB,6.0089E-03_JPRB,9.3487E-03_JPRB,1.1911E-02_JPRB,1.2451E-02_JPRB/)
KBO( :, 3,30, 6) = (/&
&7.4997E-04_JPRB,6.5118E-03_JPRB,9.8133E-03_JPRB,1.2219E-02_JPRB,1.2307E-02_JPRB/)
KBO( :, 4,30, 6) = (/&
&1.0057E-03_JPRB,7.0541E-03_JPRB,1.0293E-02_JPRB,1.2517E-02_JPRB,1.2111E-02_JPRB/)
KBO( :, 5,30, 6) = (/&
&1.3159E-03_JPRB,7.6360E-03_JPRB,1.0791E-02_JPRB,1.2813E-02_JPRB,1.1876E-02_JPRB/)
KBO( :, 1,31, 6) = (/&
&3.5135E-04_JPRB,4.6635E-03_JPRB,7.4241E-03_JPRB,9.6038E-03_JPRB,1.0269E-02_JPRB/)
KBO( :, 2,31, 6) = (/&
&4.9394E-04_JPRB,5.0642E-03_JPRB,7.8045E-03_JPRB,9.8736E-03_JPRB,1.0187E-02_JPRB/)
KBO( :, 3,31, 6) = (/&
&6.7641E-04_JPRB,5.4940E-03_JPRB,8.1988E-03_JPRB,1.0135E-02_JPRB,1.0061E-02_JPRB/)
KBO( :, 4,31, 6) = (/&
&9.0234E-04_JPRB,5.9565E-03_JPRB,8.6081E-03_JPRB,1.0392E-02_JPRB,9.8960E-03_JPRB/)
KBO( :, 5,31, 6) = (/&
&1.1742E-03_JPRB,6.4605E-03_JPRB,9.0359E-03_JPRB,1.0646E-02_JPRB,9.7006E-03_JPRB/)
KBO( :, 1,32, 6) = (/&
&3.2001E-04_JPRB,3.9308E-03_JPRB,6.1947E-03_JPRB,7.9626E-03_JPRB,8.4097E-03_JPRB/)
KBO( :, 2,32, 6) = (/&
&4.4829E-04_JPRB,4.2720E-03_JPRB,6.5203E-03_JPRB,8.1905E-03_JPRB,8.3364E-03_JPRB/)
KBO( :, 3,32, 6) = (/&
&6.1024E-04_JPRB,4.6387E-03_JPRB,6.8547E-03_JPRB,8.4122E-03_JPRB,8.2274E-03_JPRB/)
KBO( :, 4,32, 6) = (/&
&8.0906E-04_JPRB,5.0375E-03_JPRB,7.2071E-03_JPRB,8.6330E-03_JPRB,8.0902E-03_JPRB/)
KBO( :, 5,32, 6) = (/&
&1.0464E-03_JPRB,5.4823E-03_JPRB,7.5792E-03_JPRB,8.8523E-03_JPRB,7.9289E-03_JPRB/)
KBO( :, 1,33, 6) = (/&
&2.9187E-04_JPRB,3.3162E-03_JPRB,5.1759E-03_JPRB,6.6059E-03_JPRB,6.8900E-03_JPRB/)
KBO( :, 2,33, 6) = (/&
&4.0643E-04_JPRB,3.6075E-03_JPRB,5.4523E-03_JPRB,6.7980E-03_JPRB,6.8251E-03_JPRB/)
KBO( :, 3,33, 6) = (/&
&5.4996E-04_JPRB,3.9216E-03_JPRB,5.7391E-03_JPRB,6.9881E-03_JPRB,6.7331E-03_JPRB/)
KBO( :, 4,33, 6) = (/&
&7.2438E-04_JPRB,4.2703E-03_JPRB,6.0424E-03_JPRB,7.1762E-03_JPRB,6.6187E-03_JPRB/)
KBO( :, 5,33, 6) = (/&
&9.3060E-04_JPRB,4.6643E-03_JPRB,6.3702E-03_JPRB,7.3681E-03_JPRB,6.4878E-03_JPRB/)
KBO( :, 1,34, 6) = (/&
&2.6296E-04_JPRB,2.7910E-03_JPRB,4.3184E-03_JPRB,5.4761E-03_JPRB,5.6450E-03_JPRB/)
KBO( :, 2,34, 6) = (/&
&3.6417E-04_JPRB,3.0392E-03_JPRB,4.5551E-03_JPRB,5.6403E-03_JPRB,5.5898E-03_JPRB/)
KBO( :, 3,34, 6) = (/&
&4.8977E-04_JPRB,3.3104E-03_JPRB,4.8001E-03_JPRB,5.8026E-03_JPRB,5.5129E-03_JPRB/)
KBO( :, 4,34, 6) = (/&
&6.4109E-04_JPRB,3.6176E-03_JPRB,5.0649E-03_JPRB,5.9649E-03_JPRB,5.4188E-03_JPRB/)
KBO( :, 5,34, 6) = (/&
&8.1804E-04_JPRB,3.9621E-03_JPRB,5.3546E-03_JPRB,6.1354E-03_JPRB,5.3128E-03_JPRB/)
KBO( :, 1,35, 6) = (/&
&2.2910E-04_JPRB,2.3313E-03_JPRB,3.5886E-03_JPRB,4.5289E-03_JPRB,4.6300E-03_JPRB/)
KBO( :, 2,35, 6) = (/&
&3.1618E-04_JPRB,2.5413E-03_JPRB,3.7885E-03_JPRB,4.6696E-03_JPRB,4.5851E-03_JPRB/)
KBO( :, 3,35, 6) = (/&
&4.2365E-04_JPRB,2.7760E-03_JPRB,3.9992E-03_JPRB,4.8085E-03_JPRB,4.5223E-03_JPRB/)
KBO( :, 4,35, 6) = (/&
&5.5209E-04_JPRB,3.0435E-03_JPRB,4.2290E-03_JPRB,4.9499E-03_JPRB,4.4473E-03_JPRB/)
KBO( :, 5,35, 6) = (/&
&7.0126E-04_JPRB,3.3413E-03_JPRB,4.4858E-03_JPRB,5.1019E-03_JPRB,4.3622E-03_JPRB/)
KBO( :, 1,36, 6) = (/&
&1.9220E-04_JPRB,1.9293E-03_JPRB,2.9645E-03_JPRB,3.7347E-03_JPRB,3.8021E-03_JPRB/)
KBO( :, 2,36, 6) = (/&
&2.6515E-04_JPRB,2.1069E-03_JPRB,3.1345E-03_JPRB,3.8546E-03_JPRB,3.7663E-03_JPRB/)
KBO( :, 3,36, 6) = (/&
&3.5491E-04_JPRB,2.3084E-03_JPRB,3.3147E-03_JPRB,3.9746E-03_JPRB,3.7181E-03_JPRB/)
KBO( :, 4,36, 6) = (/&
&4.6148E-04_JPRB,2.5376E-03_JPRB,3.5142E-03_JPRB,4.0989E-03_JPRB,3.6590E-03_JPRB/)
KBO( :, 5,36, 6) = (/&
&5.8535E-04_JPRB,2.7911E-03_JPRB,3.7375E-03_JPRB,4.2333E-03_JPRB,3.5914E-03_JPRB/)
KBO( :, 1,37, 6) = (/&
&1.5305E-04_JPRB,1.5760E-03_JPRB,2.4302E-03_JPRB,3.0653E-03_JPRB,3.1247E-03_JPRB/)
KBO( :, 2,37, 6) = (/&
&2.1204E-04_JPRB,1.7239E-03_JPRB,2.5719E-03_JPRB,3.1677E-03_JPRB,3.0989E-03_JPRB/)
KBO( :, 3,37, 6) = (/&
&2.8465E-04_JPRB,1.8937E-03_JPRB,2.7243E-03_JPRB,3.2712E-03_JPRB,3.0625E-03_JPRB/)
KBO( :, 4,37, 6) = (/&
&3.7093E-04_JPRB,2.0863E-03_JPRB,2.8955E-03_JPRB,3.3791E-03_JPRB,3.0167E-03_JPRB/)
KBO( :, 5,37, 6) = (/&
&4.7146E-04_JPRB,2.2992E-03_JPRB,3.0865E-03_JPRB,3.4968E-03_JPRB,2.9640E-03_JPRB/)
KBO( :, 1,38, 6) = (/&
&1.2136E-04_JPRB,1.2859E-03_JPRB,1.9906E-03_JPRB,2.5150E-03_JPRB,2.5688E-03_JPRB/)
KBO( :, 2,38, 6) = (/&
&1.6887E-04_JPRB,1.4096E-03_JPRB,2.1097E-03_JPRB,2.6028E-03_JPRB,2.5509E-03_JPRB/)
KBO( :, 3,38, 6) = (/&
&2.2753E-04_JPRB,1.5523E-03_JPRB,2.2385E-03_JPRB,2.6923E-03_JPRB,2.5240E-03_JPRB/)
KBO( :, 4,38, 6) = (/&
&2.9721E-04_JPRB,1.7139E-03_JPRB,2.3837E-03_JPRB,2.7852E-03_JPRB,2.4889E-03_JPRB/)
KBO( :, 5,38, 6) = (/&
&3.7858E-04_JPRB,1.8923E-03_JPRB,2.5471E-03_JPRB,2.8888E-03_JPRB,2.4479E-03_JPRB/)
KBO( :, 1,39, 6) = (/&
&9.6167E-05_JPRB,1.0495E-03_JPRB,1.6303E-03_JPRB,2.0636E-03_JPRB,2.1132E-03_JPRB/)
KBO( :, 2,39, 6) = (/&
&1.3440E-04_JPRB,1.1528E-03_JPRB,1.7304E-03_JPRB,2.1389E-03_JPRB,2.1009E-03_JPRB/)
KBO( :, 3,39, 6) = (/&
&1.8170E-04_JPRB,1.2730E-03_JPRB,1.8388E-03_JPRB,2.2153E-03_JPRB,2.0813E-03_JPRB/)
KBO( :, 4,39, 6) = (/&
&2.3793E-04_JPRB,1.4086E-03_JPRB,1.9640E-03_JPRB,2.2962E-03_JPRB,2.0549E-03_JPRB/)
KBO( :, 5,39, 6) = (/&
&3.0389E-04_JPRB,1.5581E-03_JPRB,2.1030E-03_JPRB,2.3870E-03_JPRB,2.0237E-03_JPRB/)
KBO( :, 1,40, 6) = (/&
&7.3361E-05_JPRB,8.4824E-04_JPRB,1.3271E-03_JPRB,1.6866E-03_JPRB,1.7362E-03_JPRB/)
KBO( :, 2,40, 6) = (/&
&1.0336E-04_JPRB,9.3344E-04_JPRB,1.4100E-03_JPRB,1.7510E-03_JPRB,1.7287E-03_JPRB/)
KBO( :, 3,40, 6) = (/&
&1.4073E-04_JPRB,1.0330E-03_JPRB,1.5012E-03_JPRB,1.8164E-03_JPRB,1.7149E-03_JPRB/)
KBO( :, 4,40, 6) = (/&
&1.8535E-04_JPRB,1.1457E-03_JPRB,1.6065E-03_JPRB,1.8858E-03_JPRB,1.6953E-03_JPRB/)
KBO( :, 5,40, 6) = (/&
&2.3794E-04_JPRB,1.2701E-03_JPRB,1.7242E-03_JPRB,1.9642E-03_JPRB,1.6715E-03_JPRB/)
KBO( :, 1,41, 6) = (/&
&5.5536E-05_JPRB,6.8458E-04_JPRB,1.0790E-03_JPRB,1.3774E-03_JPRB,1.4257E-03_JPRB/)
KBO( :, 2,41, 6) = (/&
&7.8965E-05_JPRB,7.5448E-04_JPRB,1.1479E-03_JPRB,1.4323E-03_JPRB,1.4220E-03_JPRB/)
KBO( :, 3,41, 6) = (/&
&1.0837E-04_JPRB,8.3692E-04_JPRB,1.2239E-03_JPRB,1.4879E-03_JPRB,1.4126E-03_JPRB/)
KBO( :, 4,41, 6) = (/&
&1.4371E-04_JPRB,9.3022E-04_JPRB,1.3127E-03_JPRB,1.5474E-03_JPRB,1.3983E-03_JPRB/)
KBO( :, 5,41, 6) = (/&
&1.8543E-04_JPRB,1.0335E-03_JPRB,1.4117E-03_JPRB,1.6149E-03_JPRB,1.3804E-03_JPRB/)
KBO( :, 1,42, 6) = (/&
&4.1927E-05_JPRB,5.5223E-04_JPRB,8.7661E-04_JPRB,1.1242E-03_JPRB,1.1705E-03_JPRB/)
KBO( :, 2,42, 6) = (/&
&6.0156E-05_JPRB,6.0961E-04_JPRB,9.3423E-04_JPRB,1.1710E-03_JPRB,1.1695E-03_JPRB/)
KBO( :, 3,42, 6) = (/&
&8.3258E-05_JPRB,6.7778E-04_JPRB,9.9759E-04_JPRB,1.2187E-03_JPRB,1.1637E-03_JPRB/)
KBO( :, 4,42, 6) = (/&
&1.1119E-04_JPRB,7.5501E-04_JPRB,1.0720E-03_JPRB,1.2691E-03_JPRB,1.1534E-03_JPRB/)
KBO( :, 5,42, 6) = (/&
&1.4431E-04_JPRB,8.4052E-04_JPRB,1.1554E-03_JPRB,1.3271E-03_JPRB,1.1399E-03_JPRB/)
KBO( :, 1,43, 6) = (/&
&3.0871E-05_JPRB,4.4295E-04_JPRB,7.0961E-04_JPRB,9.1501E-04_JPRB,9.6059E-04_JPRB/)
KBO( :, 2,43, 6) = (/&
&4.4814E-05_JPRB,4.8939E-04_JPRB,7.5700E-04_JPRB,9.5494E-04_JPRB,9.6152E-04_JPRB/)
KBO( :, 3,43, 6) = (/&
&6.2693E-05_JPRB,5.4521E-04_JPRB,8.0961E-04_JPRB,9.9510E-04_JPRB,9.5849E-04_JPRB/)
KBO( :, 4,43, 6) = (/&
&8.4515E-05_JPRB,6.0874E-04_JPRB,8.7133E-04_JPRB,1.0381E-03_JPRB,9.5168E-04_JPRB/)
KBO( :, 5,43, 6) = (/&
&1.1049E-04_JPRB,6.7929E-04_JPRB,9.4142E-04_JPRB,1.0873E-03_JPRB,9.4176E-04_JPRB/)
KBO( :, 1,44, 6) = (/&
&2.2405E-05_JPRB,3.5419E-04_JPRB,5.7300E-04_JPRB,7.4330E-04_JPRB,7.8767E-04_JPRB/)
KBO( :, 2,44, 6) = (/&
&3.2966E-05_JPRB,3.9175E-04_JPRB,6.1232E-04_JPRB,7.7738E-04_JPRB,7.9040E-04_JPRB/)
KBO( :, 3,44, 6) = (/&
&4.6673E-05_JPRB,4.3706E-04_JPRB,6.5546E-04_JPRB,8.1138E-04_JPRB,7.8937E-04_JPRB/)
KBO( :, 4,44, 6) = (/&
&6.3585E-05_JPRB,4.8914E-04_JPRB,7.0656E-04_JPRB,8.4741E-04_JPRB,7.8495E-04_JPRB/)
KBO( :, 5,44, 6) = (/&
&8.3871E-05_JPRB,5.4682E-04_JPRB,7.6475E-04_JPRB,8.8894E-04_JPRB,7.7792E-04_JPRB/)
KBO( :, 1,45, 6) = (/&
&1.6187E-05_JPRB,2.8311E-04_JPRB,4.6245E-04_JPRB,6.0348E-04_JPRB,6.4574E-04_JPRB/)
KBO( :, 2,45, 6) = (/&
&2.4128E-05_JPRB,3.1327E-04_JPRB,4.9462E-04_JPRB,6.3227E-04_JPRB,6.4929E-04_JPRB/)
KBO( :, 3,45, 6) = (/&
&3.4598E-05_JPRB,3.4993E-04_JPRB,5.3013E-04_JPRB,6.6097E-04_JPRB,6.4978E-04_JPRB/)
KBO( :, 4,45, 6) = (/&
&4.7680E-05_JPRB,3.9262E-04_JPRB,5.7224E-04_JPRB,6.9137E-04_JPRB,6.4736E-04_JPRB/)
KBO( :, 5,45, 6) = (/&
&6.3477E-05_JPRB,4.3989E-04_JPRB,6.2080E-04_JPRB,7.2641E-04_JPRB,6.4265E-04_JPRB/)
KBO( :, 1,46, 6) = (/&
&1.1520E-05_JPRB,2.2564E-04_JPRB,3.7222E-04_JPRB,4.8884E-04_JPRB,5.2865E-04_JPRB/)
KBO( :, 2,46, 6) = (/&
&1.7434E-05_JPRB,2.4986E-04_JPRB,3.9882E-04_JPRB,5.1333E-04_JPRB,5.3299E-04_JPRB/)
KBO( :, 3,46, 6) = (/&
&2.5336E-05_JPRB,2.7928E-04_JPRB,4.2790E-04_JPRB,5.3774E-04_JPRB,5.3473E-04_JPRB/)
KBO( :, 4,46, 6) = (/&
&3.5391E-05_JPRB,3.1408E-04_JPRB,4.6247E-04_JPRB,5.6316E-04_JPRB,5.3383E-04_JPRB/)
KBO( :, 5,46, 6) = (/&
&4.7626E-05_JPRB,3.5268E-04_JPRB,5.0275E-04_JPRB,5.9251E-04_JPRB,5.3089E-04_JPRB/)
KBO( :, 1,47, 6) = (/&
&7.9924E-06_JPRB,1.7901E-04_JPRB,2.9855E-04_JPRB,3.9477E-04_JPRB,4.3220E-04_JPRB/)
KBO( :, 2,47, 6) = (/&
&1.2309E-05_JPRB,1.9833E-04_JPRB,3.2055E-04_JPRB,4.1563E-04_JPRB,4.3695E-04_JPRB/)
KBO( :, 3,47, 6) = (/&
&1.8181E-05_JPRB,2.2162E-04_JPRB,3.4407E-04_JPRB,4.3618E-04_JPRB,4.3945E-04_JPRB/)
KBO( :, 4,47, 6) = (/&
&2.5793E-05_JPRB,2.4965E-04_JPRB,3.7202E-04_JPRB,4.5733E-04_JPRB,4.3966E-04_JPRB/)
KBO( :, 5,47, 6) = (/&
&3.5147E-05_JPRB,2.8107E-04_JPRB,4.0519E-04_JPRB,4.8165E-04_JPRB,4.3810E-04_JPRB/)
KBO( :, 1,48, 6) = (/&
&5.4989E-06_JPRB,1.4192E-04_JPRB,2.3922E-04_JPRB,3.1843E-04_JPRB,3.5311E-04_JPRB/)
KBO( :, 2,48, 6) = (/&
&8.6315E-06_JPRB,1.5730E-04_JPRB,2.5726E-04_JPRB,3.3610E-04_JPRB,3.5792E-04_JPRB/)
KBO( :, 3,48, 6) = (/&
&1.2966E-05_JPRB,1.7572E-04_JPRB,2.7645E-04_JPRB,3.5343E-04_JPRB,3.6095E-04_JPRB/)
KBO( :, 4,48, 6) = (/&
&1.8681E-05_JPRB,1.9817E-04_JPRB,2.9900E-04_JPRB,3.7105E-04_JPRB,3.6197E-04_JPRB/)
KBO( :, 5,48, 6) = (/&
&2.5826E-05_JPRB,2.2362E-04_JPRB,3.2610E-04_JPRB,3.9105E-04_JPRB,3.6145E-04_JPRB/)
KBO( :, 1,49, 6) = (/&
&3.7496E-06_JPRB,1.1244E-04_JPRB,1.9146E-04_JPRB,2.5656E-04_JPRB,2.8829E-04_JPRB/)
KBO( :, 2,49, 6) = (/&
&6.0096E-06_JPRB,1.2470E-04_JPRB,2.0632E-04_JPRB,2.7145E-04_JPRB,2.9308E-04_JPRB/)
KBO( :, 3,49, 6) = (/&
&9.1827E-06_JPRB,1.3921E-04_JPRB,2.2197E-04_JPRB,2.8604E-04_JPRB,2.9630E-04_JPRB/)
KBO( :, 4,49, 6) = (/&
&1.3445E-05_JPRB,1.5710E-04_JPRB,2.4010E-04_JPRB,3.0080E-04_JPRB,2.9804E-04_JPRB/)
KBO( :, 5,49, 6) = (/&
&1.8873E-05_JPRB,1.7770E-04_JPRB,2.6214E-04_JPRB,3.1726E-04_JPRB,2.9838E-04_JPRB/)
KBO( :, 1,50, 6) = (/&
&2.5671E-06_JPRB,8.9202E-05_JPRB,1.5332E-04_JPRB,2.0675E-04_JPRB,2.3501E-04_JPRB/)
KBO( :, 2,50, 6) = (/&
&4.1982E-06_JPRB,9.9030E-05_JPRB,1.6552E-04_JPRB,2.1923E-04_JPRB,2.3945E-04_JPRB/)
KBO( :, 3,50, 6) = (/&
&6.5267E-06_JPRB,1.1055E-04_JPRB,1.7841E-04_JPRB,2.3163E-04_JPRB,2.4283E-04_JPRB/)
KBO( :, 4,50, 6) = (/&
&9.7111E-06_JPRB,1.2482E-04_JPRB,1.9315E-04_JPRB,2.4401E-04_JPRB,2.4486E-04_JPRB/)
KBO( :, 5,50, 6) = (/&
&1.3834E-05_JPRB,1.4148E-04_JPRB,2.1114E-04_JPRB,2.5764E-04_JPRB,2.4575E-04_JPRB/)
KBO( :, 1,51, 6) = (/&
&1.7531E-06_JPRB,7.0824E-05_JPRB,1.2282E-04_JPRB,1.6665E-04_JPRB,1.9149E-04_JPRB/)
KBO( :, 2,51, 6) = (/&
&2.9260E-06_JPRB,7.8726E-05_JPRB,1.3289E-04_JPRB,1.7703E-04_JPRB,1.9549E-04_JPRB/)
KBO( :, 3,51, 6) = (/&
&4.6328E-06_JPRB,8.7882E-05_JPRB,1.4342E-04_JPRB,1.8752E-04_JPRB,1.9871E-04_JPRB/)
KBO( :, 4,51, 6) = (/&
&7.0046E-06_JPRB,9.9229E-05_JPRB,1.5538E-04_JPRB,1.9791E-04_JPRB,2.0087E-04_JPRB/)
KBO( :, 5,51, 6) = (/&
&1.0130E-05_JPRB,1.1266E-04_JPRB,1.6996E-04_JPRB,2.0914E-04_JPRB,2.0202E-04_JPRB/)
KBO( :, 1,52, 6) = (/&
&1.1881E-06_JPRB,5.6174E-05_JPRB,9.8252E-05_JPRB,1.3417E-04_JPRB,1.5588E-04_JPRB/)
KBO( :, 2,52, 6) = (/&
&2.0257E-06_JPRB,6.2550E-05_JPRB,1.0656E-04_JPRB,1.4280E-04_JPRB,1.5952E-04_JPRB/)
KBO( :, 3,52, 6) = (/&
&3.2686E-06_JPRB,6.9845E-05_JPRB,1.1522E-04_JPRB,1.5163E-04_JPRB,1.6251E-04_JPRB/)
KBO( :, 4,52, 6) = (/&
&5.0263E-06_JPRB,7.8807E-05_JPRB,1.2491E-04_JPRB,1.6037E-04_JPRB,1.6475E-04_JPRB/)
KBO( :, 5,52, 6) = (/&
&7.3808E-06_JPRB,8.9616E-05_JPRB,1.3676E-04_JPRB,1.6966E-04_JPRB,1.6606E-04_JPRB/)
KBO( :, 1,53, 6) = (/&
&7.9832E-07_JPRB,4.4542E-05_JPRB,7.8584E-05_JPRB,1.0800E-04_JPRB,1.2691E-04_JPRB/)
KBO( :, 2,53, 6) = (/&
&1.3907E-06_JPRB,4.9657E-05_JPRB,8.5371E-05_JPRB,1.1509E-04_JPRB,1.3015E-04_JPRB/)
KBO( :, 3,53, 6) = (/&
&2.2894E-06_JPRB,5.5484E-05_JPRB,9.2507E-05_JPRB,1.2251E-04_JPRB,1.3293E-04_JPRB/)
KBO( :, 4,53, 6) = (/&
&3.5816E-06_JPRB,6.2524E-05_JPRB,1.0033E-04_JPRB,1.2981E-04_JPRB,1.3510E-04_JPRB/)
KBO( :, 5,53, 6) = (/&
&5.3461E-06_JPRB,7.1179E-05_JPRB,1.0986E-04_JPRB,1.3751E-04_JPRB,1.3653E-04_JPRB/)
KBO( :, 1,54, 6) = (/&
&5.4266E-07_JPRB,3.5380E-05_JPRB,6.2932E-05_JPRB,8.7009E-05_JPRB,1.0307E-04_JPRB/)
KBO( :, 2,54, 6) = (/&
&9.6274E-07_JPRB,3.9519E-05_JPRB,6.8507E-05_JPRB,9.2859E-05_JPRB,1.0590E-04_JPRB/)
KBO( :, 3,54, 6) = (/&
&1.6160E-06_JPRB,4.4199E-05_JPRB,7.4364E-05_JPRB,9.9034E-05_JPRB,1.0834E-04_JPRB/)
KBO( :, 4,54, 6) = (/&
&2.5711E-06_JPRB,4.9786E-05_JPRB,8.0771E-05_JPRB,1.0520E-04_JPRB,1.1032E-04_JPRB/)
KBO( :, 5,54, 6) = (/&
&3.8980E-06_JPRB,5.6706E-05_JPRB,8.8453E-05_JPRB,1.1157E-04_JPRB,1.1168E-04_JPRB/)
KBO( :, 1,55, 6) = (/&
&3.6993E-07_JPRB,2.8151E-05_JPRB,5.0447E-05_JPRB,7.0154E-05_JPRB,8.3628E-05_JPRB/)
KBO( :, 2,55, 6) = (/&
&6.6712E-07_JPRB,3.1488E-05_JPRB,5.5000E-05_JPRB,7.4925E-05_JPRB,8.6021E-05_JPRB/)
KBO( :, 3,55, 6) = (/&
&1.1415E-06_JPRB,3.5243E-05_JPRB,5.9803E-05_JPRB,8.0054E-05_JPRB,8.8077E-05_JPRB/)
KBO( :, 4,55, 6) = (/&
&1.8471E-06_JPRB,3.9685E-05_JPRB,6.5040E-05_JPRB,8.5219E-05_JPRB,8.9795E-05_JPRB/)
KBO( :, 5,55, 6) = (/&
&2.8436E-06_JPRB,4.5216E-05_JPRB,7.1236E-05_JPRB,9.0537E-05_JPRB,9.1036E-05_JPRB/)
KBO( :, 1,56, 6) = (/&
&2.5120E-07_JPRB,2.2384E-05_JPRB,4.0408E-05_JPRB,5.6527E-05_JPRB,6.7818E-05_JPRB/)
KBO( :, 2,56, 6) = (/&
&4.5929E-07_JPRB,2.5052E-05_JPRB,4.4089E-05_JPRB,6.0389E-05_JPRB,6.9831E-05_JPRB/)
KBO( :, 3,56, 6) = (/&
&8.0167E-07_JPRB,2.8088E-05_JPRB,4.8066E-05_JPRB,6.4674E-05_JPRB,7.1604E-05_JPRB/)
KBO( :, 4,56, 6) = (/&
&1.3201E-06_JPRB,3.1626E-05_JPRB,5.2345E-05_JPRB,6.8997E-05_JPRB,7.3067E-05_JPRB/)
KBO( :, 5,56, 6) = (/&
&2.0659E-06_JPRB,3.6024E-05_JPRB,5.7338E-05_JPRB,7.3417E-05_JPRB,7.4207E-05_JPRB/)
KBO( :, 1,57, 6) = (/&
&1.7004E-07_JPRB,1.7782E-05_JPRB,3.2345E-05_JPRB,4.5525E-05_JPRB,5.4975E-05_JPRB/)
KBO( :, 2,57, 6) = (/&
&3.1410E-07_JPRB,1.9933E-05_JPRB,3.5335E-05_JPRB,4.8660E-05_JPRB,5.6678E-05_JPRB/)
KBO( :, 3,57, 6) = (/&
&5.5924E-07_JPRB,2.2368E-05_JPRB,3.8595E-05_JPRB,5.2193E-05_JPRB,5.8180E-05_JPRB/)
KBO( :, 4,57, 6) = (/&
&9.3826E-07_JPRB,2.5192E-05_JPRB,4.2090E-05_JPRB,5.5809E-05_JPRB,5.9446E-05_JPRB/)
KBO( :, 5,57, 6) = (/&
&1.4926E-06_JPRB,2.8677E-05_JPRB,4.6125E-05_JPRB,5.9484E-05_JPRB,6.0455E-05_JPRB/)
KBO( :, 1,58, 6) = (/&
&1.1577E-07_JPRB,1.4158E-05_JPRB,2.5932E-05_JPRB,3.6700E-05_JPRB,4.4570E-05_JPRB/)
KBO( :, 2,58, 6) = (/&
&2.1587E-07_JPRB,1.5875E-05_JPRB,2.8345E-05_JPRB,3.9233E-05_JPRB,4.6003E-05_JPRB/)
KBO( :, 3,58, 6) = (/&
&3.9135E-07_JPRB,1.7835E-05_JPRB,3.1005E-05_JPRB,4.2122E-05_JPRB,4.7262E-05_JPRB/)
KBO( :, 4,58, 6) = (/&
&6.6857E-07_JPRB,2.0101E-05_JPRB,3.3873E-05_JPRB,4.5147E-05_JPRB,4.8336E-05_JPRB/)
KBO( :, 5,58, 6) = (/&
&1.0806E-06_JPRB,2.2861E-05_JPRB,3.7148E-05_JPRB,4.8221E-05_JPRB,4.9215E-05_JPRB/)
KBO( :, 1,59, 6) = (/&
&8.8304E-08_JPRB,1.1506E-05_JPRB,2.1115E-05_JPRB,2.9926E-05_JPRB,3.6293E-05_JPRB/)
KBO( :, 2,59, 6) = (/&
&1.6550E-07_JPRB,1.2912E-05_JPRB,2.3105E-05_JPRB,3.2031E-05_JPRB,3.7443E-05_JPRB/)
KBO( :, 3,59, 6) = (/&
&3.0240E-07_JPRB,1.4529E-05_JPRB,2.5310E-05_JPRB,3.4431E-05_JPRB,3.8446E-05_JPRB/)
KBO( :, 4,59, 6) = (/&
&5.2081E-07_JPRB,1.6394E-05_JPRB,2.7692E-05_JPRB,3.6949E-05_JPRB,3.9290E-05_JPRB/)
KBO( :, 5,59, 6) = (/&
&8.4770E-07_JPRB,1.8680E-05_JPRB,3.0444E-05_JPRB,3.9546E-05_JPRB,3.9972E-05_JPRB/)
KBO( :, 1,13, 7) = (/&
&7.6417E-03_JPRB,1.4685E-01_JPRB,2.6416E-01_JPRB,3.6864E-01_JPRB,4.6109E-01_JPRB/)
KBO( :, 2,13, 7) = (/&
&1.1521E-02_JPRB,1.5454E-01_JPRB,2.7251E-01_JPRB,3.7688E-01_JPRB,4.6334E-01_JPRB/)
KBO( :, 3,13, 7) = (/&
&1.6613E-02_JPRB,1.6273E-01_JPRB,2.8042E-01_JPRB,3.8453E-01_JPRB,4.6553E-01_JPRB/)
KBO( :, 4,13, 7) = (/&
&2.3028E-02_JPRB,1.7232E-01_JPRB,2.8850E-01_JPRB,3.9133E-01_JPRB,4.6726E-01_JPRB/)
KBO( :, 5,13, 7) = (/&
&3.0788E-02_JPRB,1.8356E-01_JPRB,2.9741E-01_JPRB,3.9745E-01_JPRB,4.6774E-01_JPRB/)
KBO( :, 1,14, 7) = (/&
&6.7826E-03_JPRB,1.3584E-01_JPRB,2.4414E-01_JPRB,3.4060E-01_JPRB,4.2274E-01_JPRB/)
KBO( :, 2,14, 7) = (/&
&1.0248E-02_JPRB,1.4315E-01_JPRB,2.5224E-01_JPRB,3.4887E-01_JPRB,4.2540E-01_JPRB/)
KBO( :, 3,14, 7) = (/&
&1.4775E-02_JPRB,1.5124E-01_JPRB,2.6040E-01_JPRB,3.5649E-01_JPRB,4.2762E-01_JPRB/)
KBO( :, 4,14, 7) = (/&
&2.0429E-02_JPRB,1.6084E-01_JPRB,2.6907E-01_JPRB,3.6333E-01_JPRB,4.2937E-01_JPRB/)
KBO( :, 5,14, 7) = (/&
&2.7297E-02_JPRB,1.7167E-01_JPRB,2.7817E-01_JPRB,3.7020E-01_JPRB,4.3049E-01_JPRB/)
KBO( :, 1,15, 7) = (/&
&6.0553E-03_JPRB,1.2441E-01_JPRB,2.2318E-01_JPRB,3.1131E-01_JPRB,3.8387E-01_JPRB/)
KBO( :, 2,15, 7) = (/&
&9.1374E-03_JPRB,1.3148E-01_JPRB,2.3116E-01_JPRB,3.1936E-01_JPRB,3.8692E-01_JPRB/)
KBO( :, 3,15, 7) = (/&
&1.3123E-02_JPRB,1.3959E-01_JPRB,2.3951E-01_JPRB,3.2683E-01_JPRB,3.8938E-01_JPRB/)
KBO( :, 4,15, 7) = (/&
&1.8101E-02_JPRB,1.4896E-01_JPRB,2.4836E-01_JPRB,3.3404E-01_JPRB,3.9141E-01_JPRB/)
KBO( :, 5,15, 7) = (/&
&2.4175E-02_JPRB,1.5911E-01_JPRB,2.5777E-01_JPRB,3.4141E-01_JPRB,3.9315E-01_JPRB/)
KBO( :, 1,16, 7) = (/&
&5.4131E-03_JPRB,1.1283E-01_JPRB,2.0186E-01_JPRB,2.8155E-01_JPRB,3.4527E-01_JPRB/)
KBO( :, 2,16, 7) = (/&
&8.1288E-03_JPRB,1.1972E-01_JPRB,2.0981E-01_JPRB,2.8928E-01_JPRB,3.4862E-01_JPRB/)
KBO( :, 3,16, 7) = (/&
&1.1627E-02_JPRB,1.2773E-01_JPRB,2.1812E-01_JPRB,2.9668E-01_JPRB,3.5162E-01_JPRB/)
KBO( :, 4,16, 7) = (/&
&1.6009E-02_JPRB,1.3671E-01_JPRB,2.2693E-01_JPRB,3.0423E-01_JPRB,3.5439E-01_JPRB/)
KBO( :, 5,16, 7) = (/&
&2.1373E-02_JPRB,1.4625E-01_JPRB,2.3648E-01_JPRB,3.1202E-01_JPRB,3.5679E-01_JPRB/)
KBO( :, 1,17, 7) = (/&
&4.8149E-03_JPRB,1.0146E-01_JPRB,1.8080E-01_JPRB,2.5190E-01_JPRB,3.0738E-01_JPRB/)
KBO( :, 2,17, 7) = (/&
&7.1924E-03_JPRB,1.0816E-01_JPRB,1.8856E-01_JPRB,2.5937E-01_JPRB,3.1115E-01_JPRB/)
KBO( :, 3,17, 7) = (/&
&1.0254E-02_JPRB,1.1589E-01_JPRB,1.9675E-01_JPRB,2.6692E-01_JPRB,3.1465E-01_JPRB/)
KBO( :, 4,17, 7) = (/&
&1.4092E-02_JPRB,1.2436E-01_JPRB,2.0561E-01_JPRB,2.7457E-01_JPRB,3.1792E-01_JPRB/)
KBO( :, 5,17, 7) = (/&
&1.8801E-02_JPRB,1.3345E-01_JPRB,2.1493E-01_JPRB,2.8234E-01_JPRB,3.2110E-01_JPRB/)
KBO( :, 1,18, 7) = (/&
&4.2633E-03_JPRB,9.0462E-02_JPRB,1.6049E-01_JPRB,2.2327E-01_JPRB,2.7128E-01_JPRB/)
KBO( :, 2,18, 7) = (/&
&6.3371E-03_JPRB,9.6983E-02_JPRB,1.6798E-01_JPRB,2.3054E-01_JPRB,2.7526E-01_JPRB/)
KBO( :, 3,18, 7) = (/&
&9.0048E-03_JPRB,1.0434E-01_JPRB,1.7596E-01_JPRB,2.3795E-01_JPRB,2.7919E-01_JPRB/)
KBO( :, 4,18, 7) = (/&
&1.2349E-02_JPRB,1.1235E-01_JPRB,1.8455E-01_JPRB,2.4558E-01_JPRB,2.8307E-01_JPRB/)
KBO( :, 5,18, 7) = (/&
&1.6477E-02_JPRB,1.2095E-01_JPRB,1.9366E-01_JPRB,2.5349E-01_JPRB,2.8698E-01_JPRB/)
KBO( :, 1,19, 7) = (/&
&3.7554E-03_JPRB,8.0086E-02_JPRB,1.4130E-01_JPRB,1.9618E-01_JPRB,2.3729E-01_JPRB/)
KBO( :, 2,19, 7) = (/&
&5.5565E-03_JPRB,8.6345E-02_JPRB,1.4840E-01_JPRB,2.0316E-01_JPRB,2.4150E-01_JPRB/)
KBO( :, 3,19, 7) = (/&
&7.8702E-03_JPRB,9.3236E-02_JPRB,1.5616E-01_JPRB,2.1043E-01_JPRB,2.4581E-01_JPRB/)
KBO( :, 4,19, 7) = (/&
&1.0787E-02_JPRB,1.0080E-01_JPRB,1.6449E-01_JPRB,2.1798E-01_JPRB,2.5008E-01_JPRB/)
KBO( :, 5,19, 7) = (/&
&1.4413E-02_JPRB,1.0887E-01_JPRB,1.7330E-01_JPRB,2.2565E-01_JPRB,2.5355E-01_JPRB/)
KBO( :, 1,20, 7) = (/&
&3.3111E-03_JPRB,7.0557E-02_JPRB,1.2355E-01_JPRB,1.7117E-01_JPRB,2.0615E-01_JPRB/)
KBO( :, 2,20, 7) = (/&
&4.8768E-03_JPRB,7.6467E-02_JPRB,1.3039E-01_JPRB,1.7787E-01_JPRB,2.1057E-01_JPRB/)
KBO( :, 3,20, 7) = (/&
&6.8937E-03_JPRB,8.2939E-02_JPRB,1.3783E-01_JPRB,1.8491E-01_JPRB,2.1500E-01_JPRB/)
KBO( :, 4,20, 7) = (/&
&9.4568E-03_JPRB,8.9997E-02_JPRB,1.4573E-01_JPRB,1.9190E-01_JPRB,2.1847E-01_JPRB/)
KBO( :, 5,20, 7) = (/&
&1.2649E-02_JPRB,9.7398E-02_JPRB,1.5380E-01_JPRB,1.9837E-01_JPRB,2.2024E-01_JPRB/)
KBO( :, 1,21, 7) = (/&
&2.9095E-03_JPRB,6.1851E-02_JPRB,1.0745E-01_JPRB,1.4844E-01_JPRB,1.7810E-01_JPRB/)
KBO( :, 2,21, 7) = (/&
&4.2692E-03_JPRB,6.7344E-02_JPRB,1.1397E-01_JPRB,1.5479E-01_JPRB,1.8248E-01_JPRB/)
KBO( :, 3,21, 7) = (/&
&6.0338E-03_JPRB,7.3350E-02_JPRB,1.2086E-01_JPRB,1.6105E-01_JPRB,1.8592E-01_JPRB/)
KBO( :, 4,21, 7) = (/&
&8.2818E-03_JPRB,7.9701E-02_JPRB,1.2784E-01_JPRB,1.6671E-01_JPRB,1.8765E-01_JPRB/)
KBO( :, 5,21, 7) = (/&
&1.1081E-02_JPRB,8.6263E-02_JPRB,1.3464E-01_JPRB,1.7152E-01_JPRB,1.8756E-01_JPRB/)
KBO( :, 1,22, 7) = (/&
&2.6181E-03_JPRB,5.4287E-02_JPRB,9.3450E-02_JPRB,1.2844E-01_JPRB,1.5335E-01_JPRB/)
KBO( :, 2,22, 7) = (/&
&3.8243E-03_JPRB,5.9349E-02_JPRB,9.9393E-02_JPRB,1.3393E-01_JPRB,1.5664E-01_JPRB/)
KBO( :, 3,22, 7) = (/&
&5.3935E-03_JPRB,6.4666E-02_JPRB,1.0530E-01_JPRB,1.3879E-01_JPRB,1.5834E-01_JPRB/)
KBO( :, 4,22, 7) = (/&
&7.3925E-03_JPRB,7.0137E-02_JPRB,1.1102E-01_JPRB,1.4284E-01_JPRB,1.5840E-01_JPRB/)
KBO( :, 5,22, 7) = (/&
&9.8581E-03_JPRB,7.5739E-02_JPRB,1.1637E-01_JPRB,1.4626E-01_JPRB,1.5728E-01_JPRB/)
KBO( :, 1,23, 7) = (/&
&2.3567E-03_JPRB,4.7466E-02_JPRB,8.0891E-02_JPRB,1.1029E-01_JPRB,1.3073E-01_JPRB/)
KBO( :, 2,23, 7) = (/&
&3.4308E-03_JPRB,5.1876E-02_JPRB,8.5843E-02_JPRB,1.1448E-01_JPRB,1.3247E-01_JPRB/)
KBO( :, 3,23, 7) = (/&
&4.8257E-03_JPRB,5.6351E-02_JPRB,9.0620E-02_JPRB,1.1795E-01_JPRB,1.3277E-01_JPRB/)
KBO( :, 4,23, 7) = (/&
&6.5958E-03_JPRB,6.0900E-02_JPRB,9.5105E-02_JPRB,1.2092E-01_JPRB,1.3207E-01_JPRB/)
KBO( :, 5,23, 7) = (/&
&8.7592E-03_JPRB,6.5586E-02_JPRB,9.9383E-02_JPRB,1.2354E-01_JPRB,1.3064E-01_JPRB/)
KBO( :, 1,24, 7) = (/&
&2.1271E-03_JPRB,4.1190E-02_JPRB,6.9395E-02_JPRB,9.3707E-02_JPRB,1.1002E-01_JPRB/)
KBO( :, 2,24, 7) = (/&
&3.0856E-03_JPRB,4.4852E-02_JPRB,7.3354E-02_JPRB,9.6714E-02_JPRB,1.1057E-01_JPRB/)
KBO( :, 3,24, 7) = (/&
&4.3257E-03_JPRB,4.8524E-02_JPRB,7.7130E-02_JPRB,9.9321E-02_JPRB,1.1024E-01_JPRB/)
KBO( :, 4,24, 7) = (/&
&5.8826E-03_JPRB,5.2297E-02_JPRB,8.0734E-02_JPRB,1.0166E-01_JPRB,1.0927E-01_JPRB/)
KBO( :, 5,24, 7) = (/&
&7.7717E-03_JPRB,5.6295E-02_JPRB,8.4275E-02_JPRB,1.0378E-01_JPRB,1.0782E-01_JPRB/)
KBO( :, 1,25, 7) = (/&
&1.9281E-03_JPRB,3.5411E-02_JPRB,5.8998E-02_JPRB,7.8852E-02_JPRB,9.1568E-02_JPRB/)
KBO( :, 2,25, 7) = (/&
&2.7824E-03_JPRB,3.8393E-02_JPRB,6.2155E-02_JPRB,8.1138E-02_JPRB,9.1561E-02_JPRB/)
KBO( :, 3,25, 7) = (/&
&3.8806E-03_JPRB,4.1433E-02_JPRB,6.5194E-02_JPRB,8.3215E-02_JPRB,9.0981E-02_JPRB/)
KBO( :, 4,25, 7) = (/&
&5.2453E-03_JPRB,4.4637E-02_JPRB,6.8168E-02_JPRB,8.5119E-02_JPRB,8.9958E-02_JPRB/)
KBO( :, 5,25, 7) = (/&
&6.8977E-03_JPRB,4.8120E-02_JPRB,7.1175E-02_JPRB,8.6855E-02_JPRB,8.8595E-02_JPRB/)
KBO( :, 1,26, 7) = (/&
&1.7587E-03_JPRB,3.0214E-02_JPRB,4.9851E-02_JPRB,6.5996E-02_JPRB,7.5710E-02_JPRB/)
KBO( :, 2,26, 7) = (/&
&2.5210E-03_JPRB,3.2677E-02_JPRB,5.2397E-02_JPRB,6.7829E-02_JPRB,7.5438E-02_JPRB/)
KBO( :, 3,26, 7) = (/&
&3.4928E-03_JPRB,3.5239E-02_JPRB,5.4896E-02_JPRB,6.9528E-02_JPRB,7.4777E-02_JPRB/)
KBO( :, 4,26, 7) = (/&
&4.6908E-03_JPRB,3.8029E-02_JPRB,5.7397E-02_JPRB,7.1083E-02_JPRB,7.3800E-02_JPRB/)
KBO( :, 5,26, 7) = (/&
&6.1395E-03_JPRB,4.1060E-02_JPRB,5.9986E-02_JPRB,7.2531E-02_JPRB,7.2558E-02_JPRB/)
KBO( :, 1,27, 7) = (/&
&1.6029E-03_JPRB,2.5642E-02_JPRB,4.1927E-02_JPRB,5.5065E-02_JPRB,6.2332E-02_JPRB/)
KBO( :, 2,27, 7) = (/&
&2.2812E-03_JPRB,2.7700E-02_JPRB,4.4008E-02_JPRB,5.6573E-02_JPRB,6.1961E-02_JPRB/)
KBO( :, 3,27, 7) = (/&
&3.1372E-03_JPRB,2.9918E-02_JPRB,4.6094E-02_JPRB,5.7948E-02_JPRB,6.1302E-02_JPRB/)
KBO( :, 4,27, 7) = (/&
&4.1899E-03_JPRB,3.2354E-02_JPRB,4.8227E-02_JPRB,5.9239E-02_JPRB,6.0407E-02_JPRB/)
KBO( :, 5,27, 7) = (/&
&5.4669E-03_JPRB,3.4991E-02_JPRB,5.0494E-02_JPRB,6.0487E-02_JPRB,5.9313E-02_JPRB/)
KBO( :, 1,28, 7) = (/&
&1.4587E-03_JPRB,2.1692E-02_JPRB,3.5152E-02_JPRB,4.5868E-02_JPRB,5.1191E-02_JPRB/)
KBO( :, 2,28, 7) = (/&
&2.0600E-03_JPRB,2.3452E-02_JPRB,3.6880E-02_JPRB,4.7085E-02_JPRB,5.0788E-02_JPRB/)
KBO( :, 3,28, 7) = (/&
&2.8147E-03_JPRB,2.5390E-02_JPRB,3.8642E-02_JPRB,4.8221E-02_JPRB,5.0174E-02_JPRB/)
KBO( :, 4,28, 7) = (/&
&3.7416E-03_JPRB,2.7500E-02_JPRB,4.0500E-02_JPRB,4.9318E-02_JPRB,4.9374E-02_JPRB/)
KBO( :, 5,28, 7) = (/&
&4.8758E-03_JPRB,2.9796E-02_JPRB,4.2469E-02_JPRB,5.0418E-02_JPRB,4.8430E-02_JPRB/)
KBO( :, 1,29, 7) = (/&
&1.3284E-03_JPRB,1.8334E-02_JPRB,2.9430E-02_JPRB,3.8154E-02_JPRB,4.1977E-02_JPRB/)
KBO( :, 2,29, 7) = (/&
&1.8615E-03_JPRB,1.9864E-02_JPRB,3.0877E-02_JPRB,3.9147E-02_JPRB,4.1585E-02_JPRB/)
KBO( :, 3,29, 7) = (/&
&2.5273E-03_JPRB,2.1548E-02_JPRB,3.2404E-02_JPRB,4.0101E-02_JPRB,4.1024E-02_JPRB/)
KBO( :, 4,29, 7) = (/&
&3.3502E-03_JPRB,2.3383E-02_JPRB,3.4027E-02_JPRB,4.1054E-02_JPRB,4.0329E-02_JPRB/)
KBO( :, 5,29, 7) = (/&
&4.3678E-03_JPRB,2.5374E-02_JPRB,3.5730E-02_JPRB,4.2021E-02_JPRB,3.9526E-02_JPRB/)
KBO( :, 1,30, 7) = (/&
&1.2077E-03_JPRB,1.5498E-02_JPRB,2.4613E-02_JPRB,3.1700E-02_JPRB,3.4385E-02_JPRB/)
KBO( :, 2,30, 7) = (/&
&1.6794E-03_JPRB,1.6830E-02_JPRB,2.5859E-02_JPRB,3.2527E-02_JPRB,3.4019E-02_JPRB/)
KBO( :, 3,30, 7) = (/&
&2.2700E-03_JPRB,1.8290E-02_JPRB,2.7194E-02_JPRB,3.3342E-02_JPRB,3.3526E-02_JPRB/)
KBO( :, 4,30, 7) = (/&
&3.0076E-03_JPRB,1.9884E-02_JPRB,2.8602E-02_JPRB,3.4179E-02_JPRB,3.2934E-02_JPRB/)
KBO( :, 5,30, 7) = (/&
&3.9239E-03_JPRB,2.1618E-02_JPRB,3.0083E-02_JPRB,3.5038E-02_JPRB,3.2267E-02_JPRB/)
KBO( :, 1,31, 7) = (/&
&1.0979E-03_JPRB,1.3116E-02_JPRB,2.0595E-02_JPRB,2.6327E-02_JPRB,2.8152E-02_JPRB/)
KBO( :, 2,31, 7) = (/&
&1.5169E-03_JPRB,1.4272E-02_JPRB,2.1683E-02_JPRB,2.7024E-02_JPRB,2.7826E-02_JPRB/)
KBO( :, 3,31, 7) = (/&
&2.0453E-03_JPRB,1.5538E-02_JPRB,2.2843E-02_JPRB,2.7738E-02_JPRB,2.7405E-02_JPRB/)
KBO( :, 4,31, 7) = (/&
&2.7116E-03_JPRB,1.6927E-02_JPRB,2.4066E-02_JPRB,2.8483E-02_JPRB,2.6914E-02_JPRB/)
KBO( :, 5,31, 7) = (/&
&3.5394E-03_JPRB,1.8442E-02_JPRB,2.5352E-02_JPRB,2.9238E-02_JPRB,2.6357E-02_JPRB/)
KBO( :, 1,32, 7) = (/&
&9.9745E-04_JPRB,1.1111E-02_JPRB,1.7254E-02_JPRB,2.1864E-02_JPRB,2.3045E-02_JPRB/)
KBO( :, 2,32, 7) = (/&
&1.3720E-03_JPRB,1.2113E-02_JPRB,1.8202E-02_JPRB,2.2466E-02_JPRB,2.2758E-02_JPRB/)
KBO( :, 3,32, 7) = (/&
&1.8496E-03_JPRB,1.3215E-02_JPRB,1.9210E-02_JPRB,2.3105E-02_JPRB,2.2405E-02_JPRB/)
KBO( :, 4,32, 7) = (/&
&2.4534E-03_JPRB,1.4429E-02_JPRB,2.0269E-02_JPRB,2.3758E-02_JPRB,2.1994E-02_JPRB/)
KBO( :, 5,32, 7) = (/&
&3.1994E-03_JPRB,1.5763E-02_JPRB,2.1391E-02_JPRB,2.4424E-02_JPRB,2.1537E-02_JPRB/)
KBO( :, 1,33, 7) = (/&
&9.0609E-04_JPRB,9.4233E-03_JPRB,1.4475E-02_JPRB,1.8167E-02_JPRB,1.8863E-02_JPRB/)
KBO( :, 2,33, 7) = (/&
&1.2447E-03_JPRB,1.0296E-02_JPRB,1.5300E-02_JPRB,1.8704E-02_JPRB,1.8620E-02_JPRB/)
KBO( :, 3,33, 7) = (/&
&1.6790E-03_JPRB,1.1258E-02_JPRB,1.6171E-02_JPRB,1.9267E-02_JPRB,1.8323E-02_JPRB/)
KBO( :, 4,33, 7) = (/&
&2.2252E-03_JPRB,1.2324E-02_JPRB,1.7095E-02_JPRB,1.9844E-02_JPRB,1.7985E-02_JPRB/)
KBO( :, 5,33, 7) = (/&
&2.8950E-03_JPRB,1.3521E-02_JPRB,1.8082E-02_JPRB,2.0433E-02_JPRB,1.7614E-02_JPRB/)
KBO( :, 1,34, 7) = (/&
&8.1514E-04_JPRB,7.9756E-03_JPRB,1.2137E-02_JPRB,1.5099E-02_JPRB,1.5443E-02_JPRB/)
KBO( :, 2,34, 7) = (/&
&1.1204E-03_JPRB,8.7356E-03_JPRB,1.2847E-02_JPRB,1.5577E-02_JPRB,1.5237E-02_JPRB/)
KBO( :, 3,34, 7) = (/&
&1.5119E-03_JPRB,9.5758E-03_JPRB,1.3604E-02_JPRB,1.6072E-02_JPRB,1.4994E-02_JPRB/)
KBO( :, 4,34, 7) = (/&
&2.0012E-03_JPRB,1.0522E-02_JPRB,1.4410E-02_JPRB,1.6579E-02_JPRB,1.4722E-02_JPRB/)
KBO( :, 5,34, 7) = (/&
&2.5995E-03_JPRB,1.1602E-02_JPRB,1.5283E-02_JPRB,1.7098E-02_JPRB,1.4425E-02_JPRB/)
KBO( :, 1,35, 7) = (/&
&7.1227E-04_JPRB,6.7018E-03_JPRB,1.0127E-02_JPRB,1.2528E-02_JPRB,1.2660E-02_JPRB/)
KBO( :, 2,35, 7) = (/&
&9.8163E-04_JPRB,7.3560E-03_JPRB,1.0739E-02_JPRB,1.2948E-02_JPRB,1.2494E-02_JPRB/)
KBO( :, 3,35, 7) = (/&
&1.3263E-03_JPRB,8.0909E-03_JPRB,1.1393E-02_JPRB,1.3382E-02_JPRB,1.2302E-02_JPRB/)
KBO( :, 4,35, 7) = (/&
&1.7561E-03_JPRB,8.9242E-03_JPRB,1.2096E-02_JPRB,1.3825E-02_JPRB,1.2085E-02_JPRB/)
KBO( :, 5,35, 7) = (/&
&2.2810E-03_JPRB,9.8947E-03_JPRB,1.2873E-02_JPRB,1.4284E-02_JPRB,1.1851E-02_JPRB/)
KBO( :, 1,36, 7) = (/&
&6.0202E-04_JPRB,5.5779E-03_JPRB,8.4015E-03_JPRB,1.0366E-02_JPRB,1.0396E-02_JPRB/)
KBO( :, 2,36, 7) = (/&
&8.3319E-04_JPRB,6.1400E-03_JPRB,8.9260E-03_JPRB,1.0732E-02_JPRB,1.0268E-02_JPRB/)
KBO( :, 3,36, 7) = (/&
&1.1287E-03_JPRB,6.7734E-03_JPRB,9.4880E-03_JPRB,1.1109E-02_JPRB,1.0116E-02_JPRB/)
KBO( :, 4,36, 7) = (/&
&1.4983E-03_JPRB,7.5040E-03_JPRB,1.0100E-02_JPRB,1.1497E-02_JPRB,9.9466E-03_JPRB/)
KBO( :, 5,36, 7) = (/&
&1.9490E-03_JPRB,8.3637E-03_JPRB,1.0791E-02_JPRB,1.1906E-02_JPRB,9.7636E-03_JPRB/)
KBO( :, 1,37, 7) = (/&
&4.8416E-04_JPRB,4.5804E-03_JPRB,6.9086E-03_JPRB,8.5355E-03_JPRB,8.5508E-03_JPRB/)
KBO( :, 2,37, 7) = (/&
&6.7495E-04_JPRB,5.0520E-03_JPRB,7.3527E-03_JPRB,8.8519E-03_JPRB,8.4527E-03_JPRB/)
KBO( :, 3,37, 7) = (/&
&9.1952E-04_JPRB,5.5894E-03_JPRB,7.8325E-03_JPRB,9.1782E-03_JPRB,8.3356E-03_JPRB/)
KBO( :, 4,37, 7) = (/&
&1.2272E-03_JPRB,6.2161E-03_JPRB,8.3611E-03_JPRB,9.5172E-03_JPRB,8.2045E-03_JPRB/)
KBO( :, 5,37, 7) = (/&
&1.6032E-03_JPRB,6.9603E-03_JPRB,8.9629E-03_JPRB,9.8764E-03_JPRB,8.0631E-03_JPRB/)
KBO( :, 1,38, 7) = (/&
&3.8815E-04_JPRB,3.7581E-03_JPRB,5.6778E-03_JPRB,7.0261E-03_JPRB,7.0356E-03_JPRB/)
KBO( :, 2,38, 7) = (/&
&5.4489E-04_JPRB,4.1553E-03_JPRB,6.0551E-03_JPRB,7.3001E-03_JPRB,6.9620E-03_JPRB/)
KBO( :, 3,38, 7) = (/&
&7.4720E-04_JPRB,4.6096E-03_JPRB,6.4646E-03_JPRB,7.5820E-03_JPRB,6.8735E-03_JPRB/)
KBO( :, 4,38, 7) = (/&
&1.0025E-03_JPRB,5.1457E-03_JPRB,6.9210E-03_JPRB,7.8773E-03_JPRB,6.7744E-03_JPRB/)
KBO( :, 5,38, 7) = (/&
&1.3158E-03_JPRB,5.7907E-03_JPRB,7.4467E-03_JPRB,8.1937E-03_JPRB,6.6650E-03_JPRB/)
KBO( :, 1,39, 7) = (/&
&3.1112E-04_JPRB,3.0839E-03_JPRB,4.6680E-03_JPRB,5.7846E-03_JPRB,5.7911E-03_JPRB/)
KBO( :, 2,39, 7) = (/&
&4.3990E-04_JPRB,3.4180E-03_JPRB,4.9880E-03_JPRB,6.0205E-03_JPRB,5.7382E-03_JPRB/)
KBO( :, 3,39, 7) = (/&
&6.0701E-04_JPRB,3.8014E-03_JPRB,5.3384E-03_JPRB,6.2649E-03_JPRB,5.6729E-03_JPRB/)
KBO( :, 4,39, 7) = (/&
&8.1924E-04_JPRB,4.2647E-03_JPRB,5.7318E-03_JPRB,6.5208E-03_JPRB,5.5990E-03_JPRB/)
KBO( :, 5,39, 7) = (/&
&1.0794E-03_JPRB,4.8235E-03_JPRB,6.1904E-03_JPRB,6.7997E-03_JPRB,5.5155E-03_JPRB/)
KBO( :, 1,40, 7) = (/&
&2.3999E-04_JPRB,2.5045E-03_JPRB,3.8112E-03_JPRB,4.7419E-03_JPRB,4.7659E-03_JPRB/)
KBO( :, 2,40, 7) = (/&
&3.4272E-04_JPRB,2.7807E-03_JPRB,4.0807E-03_JPRB,4.9438E-03_JPRB,4.7281E-03_JPRB/)
KBO( :, 3,40, 7) = (/&
&4.7709E-04_JPRB,3.1013E-03_JPRB,4.3772E-03_JPRB,5.1542E-03_JPRB,4.6798E-03_JPRB/)
KBO( :, 4,40, 7) = (/&
&6.4876E-04_JPRB,3.4905E-03_JPRB,4.7113E-03_JPRB,5.3759E-03_JPRB,4.6247E-03_JPRB/)
KBO( :, 5,40, 7) = (/&
&8.6088E-04_JPRB,3.9661E-03_JPRB,5.1051E-03_JPRB,5.6199E-03_JPRB,4.5616E-03_JPRB/)
KBO( :, 1,41, 7) = (/&
&1.8373E-04_JPRB,2.0302E-03_JPRB,3.1081E-03_JPRB,3.8838E-03_JPRB,3.9218E-03_JPRB/)
KBO( :, 2,41, 7) = (/&
&2.6521E-04_JPRB,2.2593E-03_JPRB,3.3353E-03_JPRB,4.0566E-03_JPRB,3.8950E-03_JPRB/)
KBO( :, 3,41, 7) = (/&
&3.7260E-04_JPRB,2.5252E-03_JPRB,3.5847E-03_JPRB,4.2368E-03_JPRB,3.8605E-03_JPRB/)
KBO( :, 4,41, 7) = (/&
&5.1095E-04_JPRB,2.8525E-03_JPRB,3.8680E-03_JPRB,4.4284E-03_JPRB,3.8199E-03_JPRB/)
KBO( :, 5,41, 7) = (/&
&6.8302E-04_JPRB,3.2540E-03_JPRB,4.2038E-03_JPRB,4.6408E-03_JPRB,3.7718E-03_JPRB/)
KBO( :, 1,42, 7) = (/&
&1.4021E-04_JPRB,1.6447E-03_JPRB,2.5340E-03_JPRB,3.1794E-03_JPRB,3.2271E-03_JPRB/)
KBO( :, 2,42, 7) = (/&
&2.0457E-04_JPRB,1.8341E-03_JPRB,2.7244E-03_JPRB,3.3270E-03_JPRB,3.2092E-03_JPRB/)
KBO( :, 3,42, 7) = (/&
&2.9014E-04_JPRB,2.0556E-03_JPRB,2.9350E-03_JPRB,3.4824E-03_JPRB,3.1854E-03_JPRB/)
KBO( :, 4,42, 7) = (/&
&4.0126E-04_JPRB,2.3289E-03_JPRB,3.1740E-03_JPRB,3.6472E-03_JPRB,3.1554E-03_JPRB/)
KBO( :, 5,42, 7) = (/&
&5.4072E-04_JPRB,2.6686E-03_JPRB,3.4603E-03_JPRB,3.8315E-03_JPRB,3.1192E-03_JPRB/)
KBO( :, 1,43, 7) = (/&
&1.0418E-04_JPRB,1.3241E-03_JPRB,2.0566E-03_JPRB,2.5949E-03_JPRB,2.6555E-03_JPRB/)
KBO( :, 2,43, 7) = (/&
&1.5394E-04_JPRB,1.4792E-03_JPRB,2.2158E-03_JPRB,2.7206E-03_JPRB,2.6446E-03_JPRB/)
KBO( :, 3,43, 7) = (/&
&2.2089E-04_JPRB,1.6609E-03_JPRB,2.3912E-03_JPRB,2.8530E-03_JPRB,2.6280E-03_JPRB/)
KBO( :, 4,43, 7) = (/&
&3.0843E-04_JPRB,1.8861E-03_JPRB,2.5915E-03_JPRB,2.9949E-03_JPRB,2.6073E-03_JPRB/)
KBO( :, 5,43, 7) = (/&
&4.1975E-04_JPRB,2.1696E-03_JPRB,2.8326E-03_JPRB,3.1535E-03_JPRB,2.5807E-03_JPRB/)
KBO( :, 1,44, 7) = (/&
&7.6179E-05_JPRB,1.0623E-03_JPRB,1.6648E-03_JPRB,2.1141E-03_JPRB,2.1847E-03_JPRB/)
KBO( :, 2,44, 7) = (/&
&1.1420E-04_JPRB,1.1887E-03_JPRB,1.7975E-03_JPRB,2.2205E-03_JPRB,2.1791E-03_JPRB/)
KBO( :, 3,44, 7) = (/&
&1.6589E-04_JPRB,1.3367E-03_JPRB,1.9435E-03_JPRB,2.3337E-03_JPRB,2.1689E-03_JPRB/)
KBO( :, 4,44, 7) = (/&
&2.3431E-04_JPRB,1.5216E-03_JPRB,2.1097E-03_JPRB,2.4546E-03_JPRB,2.1546E-03_JPRB/)
KBO( :, 5,44, 7) = (/&
&3.2209E-04_JPRB,1.7553E-03_JPRB,2.3110E-03_JPRB,2.5901E-03_JPRB,2.1354E-03_JPRB/)
KBO( :, 1,45, 7) = (/&
&5.5380E-05_JPRB,8.5190E-04_JPRB,1.3470E-03_JPRB,1.7214E-03_JPRB,1.7974E-03_JPRB/)
KBO( :, 2,45, 7) = (/&
&8.4230E-05_JPRB,9.5419E-04_JPRB,1.4571E-03_JPRB,1.8110E-03_JPRB,1.7954E-03_JPRB/)
KBO( :, 3,45, 7) = (/&
&1.2398E-04_JPRB,1.0747E-03_JPRB,1.5782E-03_JPRB,1.9072E-03_JPRB,1.7895E-03_JPRB/)
KBO( :, 4,45, 7) = (/&
&1.7714E-04_JPRB,1.2254E-03_JPRB,1.7161E-03_JPRB,2.0103E-03_JPRB,1.7807E-03_JPRB/)
KBO( :, 5,45, 7) = (/&
&2.4615E-04_JPRB,1.4185E-03_JPRB,1.8836E-03_JPRB,2.1255E-03_JPRB,1.7676E-03_JPRB/)
KBO( :, 1,46, 7) = (/&
&3.9608E-05_JPRB,6.8065E-04_JPRB,1.0869E-03_JPRB,1.3989E-03_JPRB,1.4780E-03_JPRB/)
KBO( :, 2,46, 7) = (/&
&6.1254E-05_JPRB,7.6359E-04_JPRB,1.1780E-03_JPRB,1.4742E-03_JPRB,1.4788E-03_JPRB/)
KBO( :, 3,46, 7) = (/&
&9.1434E-05_JPRB,8.6131E-04_JPRB,1.2786E-03_JPRB,1.5561E-03_JPRB,1.4768E-03_JPRB/)
KBO( :, 4,46, 7) = (/&
&1.3231E-04_JPRB,9.8314E-04_JPRB,1.3925E-03_JPRB,1.6437E-03_JPRB,1.4719E-03_JPRB/)
KBO( :, 5,46, 7) = (/&
&1.8599E-04_JPRB,1.1411E-03_JPRB,1.5309E-03_JPRB,1.7412E-03_JPRB,1.4636E-03_JPRB/)
KBO( :, 1,47, 7) = (/&
&2.7565E-05_JPRB,5.4081E-04_JPRB,8.7346E-04_JPRB,1.1337E-03_JPRB,1.2145E-03_JPRB/)
KBO( :, 2,47, 7) = (/&
&4.3444E-05_JPRB,6.0782E-04_JPRB,9.4864E-04_JPRB,1.1966E-03_JPRB,1.2173E-03_JPRB/)
KBO( :, 3,47, 7) = (/&
&6.5911E-05_JPRB,6.8599E-04_JPRB,1.0313E-03_JPRB,1.2655E-03_JPRB,1.2177E-03_JPRB/)
KBO( :, 4,47, 7) = (/&
&9.6767E-05_JPRB,7.8305E-04_JPRB,1.1246E-03_JPRB,1.3397E-03_JPRB,1.2159E-03_JPRB/)
KBO( :, 5,47, 7) = (/&
&1.3786E-04_JPRB,9.1017E-04_JPRB,1.2371E-03_JPRB,1.4212E-03_JPRB,1.2107E-03_JPRB/)
KBO( :, 1,48, 7) = (/&
&1.9010E-05_JPRB,4.2934E-04_JPRB,7.0139E-04_JPRB,9.1842E-04_JPRB,9.9781E-04_JPRB/)
KBO( :, 2,48, 7) = (/&
&3.0547E-05_JPRB,4.8321E-04_JPRB,7.6298E-04_JPRB,9.7015E-04_JPRB,1.0019E-03_JPRB/)
KBO( :, 3,48, 7) = (/&
&4.7172E-05_JPRB,5.4566E-04_JPRB,8.3089E-04_JPRB,1.0280E-03_JPRB,1.0041E-03_JPRB/)
KBO( :, 4,48, 7) = (/&
&7.0312E-05_JPRB,6.2270E-04_JPRB,9.0704E-04_JPRB,1.0904E-03_JPRB,1.0043E-03_JPRB/)
KBO( :, 5,48, 7) = (/&
&1.0158E-04_JPRB,7.2457E-04_JPRB,9.9839E-04_JPRB,1.1584E-03_JPRB,1.0014E-03_JPRB/)
KBO( :, 1,49, 7) = (/&
&1.2989E-05_JPRB,3.4041E-04_JPRB,5.6254E-04_JPRB,7.4336E-04_JPRB,8.1967E-04_JPRB/)
KBO( :, 2,49, 7) = (/&
&2.1288E-05_JPRB,3.8375E-04_JPRB,6.1286E-04_JPRB,7.8566E-04_JPRB,8.2462E-04_JPRB/)
KBO( :, 3,49, 7) = (/&
&3.3501E-05_JPRB,4.3371E-04_JPRB,6.6869E-04_JPRB,8.3391E-04_JPRB,8.2791E-04_JPRB/)
KBO( :, 4,49, 7) = (/&
&5.0757E-05_JPRB,4.9477E-04_JPRB,7.3099E-04_JPRB,8.8650E-04_JPRB,8.2973E-04_JPRB/)
KBO( :, 5,49, 7) = (/&
&7.4391E-05_JPRB,5.7603E-04_JPRB,8.0512E-04_JPRB,9.4378E-04_JPRB,8.2902E-04_JPRB/)
KBO( :, 1,50, 7) = (/&
&8.9107E-06_JPRB,2.7028E-04_JPRB,4.5165E-04_JPRB,6.0203E-04_JPRB,6.7224E-04_JPRB/)
KBO( :, 2,50, 7) = (/&
&1.4889E-05_JPRB,3.0526E-04_JPRB,4.9281E-04_JPRB,6.3656E-04_JPRB,6.7754E-04_JPRB/)
KBO( :, 3,50, 7) = (/&
&2.3877E-05_JPRB,3.4554E-04_JPRB,5.3891E-04_JPRB,6.7691E-04_JPRB,6.8139E-04_JPRB/)
KBO( :, 4,50, 7) = (/&
&3.6771E-05_JPRB,3.9444E-04_JPRB,5.9020E-04_JPRB,7.2140E-04_JPRB,6.8414E-04_JPRB/)
KBO( :, 5,50, 7) = (/&
&5.4655E-05_JPRB,4.5942E-04_JPRB,6.5054E-04_JPRB,7.6968E-04_JPRB,6.8480E-04_JPRB/)
KBO( :, 1,51, 7) = (/&
&6.0961E-06_JPRB,2.1476E-04_JPRB,3.6280E-04_JPRB,4.8765E-04_JPRB,5.5078E-04_JPRB/)
KBO( :, 2,51, 7) = (/&
&1.0381E-05_JPRB,2.4307E-04_JPRB,3.9642E-04_JPRB,5.1588E-04_JPRB,5.5623E-04_JPRB/)
KBO( :, 3,51, 7) = (/&
&1.6982E-05_JPRB,2.7555E-04_JPRB,4.3451E-04_JPRB,5.4955E-04_JPRB,5.6027E-04_JPRB/)
KBO( :, 4,51, 7) = (/&
&2.6587E-05_JPRB,3.1466E-04_JPRB,4.7661E-04_JPRB,5.8697E-04_JPRB,5.6337E-04_JPRB/)
KBO( :, 5,51, 7) = (/&
&4.0101E-05_JPRB,3.6650E-04_JPRB,5.2570E-04_JPRB,6.2745E-04_JPRB,5.6478E-04_JPRB/)
KBO( :, 1,52, 7) = (/&
&4.1353E-06_JPRB,1.7061E-04_JPRB,2.9145E-04_JPRB,3.9501E-04_JPRB,4.5130E-04_JPRB/)
KBO( :, 2,52, 7) = (/&
&7.1818E-06_JPRB,1.9335E-04_JPRB,3.1863E-04_JPRB,4.1793E-04_JPRB,4.5663E-04_JPRB/)
KBO( :, 3,52, 7) = (/&
&1.1989E-05_JPRB,2.1956E-04_JPRB,3.4994E-04_JPRB,4.4575E-04_JPRB,4.6074E-04_JPRB/)
KBO( :, 4,52, 7) = (/&
&1.9102E-05_JPRB,2.5087E-04_JPRB,3.8455E-04_JPRB,4.7710E-04_JPRB,4.6395E-04_JPRB/)
KBO( :, 5,52, 7) = (/&
&2.9266E-05_JPRB,2.9208E-04_JPRB,4.2456E-04_JPRB,5.1110E-04_JPRB,4.6590E-04_JPRB/)
KBO( :, 1,53, 7) = (/&
&2.7771E-06_JPRB,1.3543E-04_JPRB,2.3402E-04_JPRB,3.1978E-04_JPRB,3.6971E-04_JPRB/)
KBO( :, 2,53, 7) = (/&
&4.9256E-06_JPRB,1.5363E-04_JPRB,2.5583E-04_JPRB,3.3830E-04_JPRB,3.7486E-04_JPRB/)
KBO( :, 3,53, 7) = (/&
&8.3927E-06_JPRB,1.7477E-04_JPRB,2.8146E-04_JPRB,3.6113E-04_JPRB,3.7892E-04_JPRB/)
KBO( :, 4,53, 7) = (/&
&1.3629E-05_JPRB,1.9978E-04_JPRB,3.0996E-04_JPRB,3.8736E-04_JPRB,3.8222E-04_JPRB/)
KBO( :, 5,53, 7) = (/&
&2.1224E-05_JPRB,2.3248E-04_JPRB,3.4254E-04_JPRB,4.1583E-04_JPRB,3.8453E-04_JPRB/)
KBO( :, 1,54, 7) = (/&
&1.8811E-06_JPRB,1.0783E-04_JPRB,1.8829E-04_JPRB,2.5915E-04_JPRB,3.0210E-04_JPRB/)
KBO( :, 2,54, 7) = (/&
&3.4084E-06_JPRB,1.2242E-04_JPRB,2.0578E-04_JPRB,2.7417E-04_JPRB,3.0673E-04_JPRB/)
KBO( :, 3,54, 7) = (/&
&5.9212E-06_JPRB,1.3950E-04_JPRB,2.2680E-04_JPRB,2.9292E-04_JPRB,3.1041E-04_JPRB/)
KBO( :, 4,54, 7) = (/&
&9.7966E-06_JPRB,1.5966E-04_JPRB,2.5030E-04_JPRB,3.1483E-04_JPRB,3.1342E-04_JPRB/)
KBO( :, 5,54, 7) = (/&
&1.5501E-05_JPRB,1.8577E-04_JPRB,2.7693E-04_JPRB,3.3870E-04_JPRB,3.1563E-04_JPRB/)
KBO( :, 1,55, 7) = (/&
&1.2736E-06_JPRB,8.5960E-05_JPRB,1.5164E-04_JPRB,2.1009E-04_JPRB,2.4656E-04_JPRB/)
KBO( :, 2,55, 7) = (/&
&2.3598E-06_JPRB,9.7655E-05_JPRB,1.6564E-04_JPRB,2.2229E-04_JPRB,2.5059E-04_JPRB/)
KBO( :, 3,55, 7) = (/&
&4.1776E-06_JPRB,1.1145E-04_JPRB,1.8284E-04_JPRB,2.3762E-04_JPRB,2.5377E-04_JPRB/)
KBO( :, 4,55, 7) = (/&
&7.0441E-06_JPRB,1.2773E-04_JPRB,2.0219E-04_JPRB,2.5588E-04_JPRB,2.5634E-04_JPRB/)
KBO( :, 5,55, 7) = (/&
&1.1323E-05_JPRB,1.4864E-04_JPRB,2.2410E-04_JPRB,2.7593E-04_JPRB,2.5827E-04_JPRB/)
KBO( :, 1,56, 7) = (/&
&8.5479E-07_JPRB,6.8495E-05_JPRB,1.2209E-04_JPRB,1.7021E-04_JPRB,2.0114E-04_JPRB/)
KBO( :, 2,56, 7) = (/&
&1.6225E-06_JPRB,7.7817E-05_JPRB,1.3325E-04_JPRB,1.8015E-04_JPRB,2.0463E-04_JPRB/)
KBO( :, 3,56, 7) = (/&
&2.9270E-06_JPRB,8.8970E-05_JPRB,1.4725E-04_JPRB,1.9262E-04_JPRB,2.0743E-04_JPRB/)
KBO( :, 4,56, 7) = (/&
&5.0340E-06_JPRB,1.0210E-04_JPRB,1.6318E-04_JPRB,2.0779E-04_JPRB,2.0965E-04_JPRB/)
KBO( :, 5,56, 7) = (/&
&8.2279E-06_JPRB,1.1881E-04_JPRB,1.8117E-04_JPRB,2.2455E-04_JPRB,2.1130E-04_JPRB/)
KBO( :, 1,57, 7) = (/&
&5.6832E-07_JPRB,5.4568E-05_JPRB,9.8248E-05_JPRB,1.3779E-04_JPRB,1.6394E-04_JPRB/)
KBO( :, 2,57, 7) = (/&
&1.1069E-06_JPRB,6.1982E-05_JPRB,1.0712E-04_JPRB,1.4596E-04_JPRB,1.6709E-04_JPRB/)
KBO( :, 3,57, 7) = (/&
&2.0353E-06_JPRB,7.0945E-05_JPRB,1.1847E-04_JPRB,1.5604E-04_JPRB,1.6951E-04_JPRB/)
KBO( :, 4,57, 7) = (/&
&3.5732E-06_JPRB,8.1530E-05_JPRB,1.3155E-04_JPRB,1.6855E-04_JPRB,1.7142E-04_JPRB/)
KBO( :, 5,57, 7) = (/&
&5.9454E-06_JPRB,9.4896E-05_JPRB,1.4631E-04_JPRB,1.8257E-04_JPRB,1.7286E-04_JPRB/)
KBO( :, 1,58, 7) = (/&
&3.7890E-07_JPRB,4.3568E-05_JPRB,7.9163E-05_JPRB,1.1161E-04_JPRB,1.3361E-04_JPRB/)
KBO( :, 2,58, 7) = (/&
&7.5700E-07_JPRB,4.9431E-05_JPRB,8.6199E-05_JPRB,1.1831E-04_JPRB,1.3638E-04_JPRB/)
KBO( :, 3,58, 7) = (/&
&1.4190E-06_JPRB,5.6651E-05_JPRB,9.5379E-05_JPRB,1.2647E-04_JPRB,1.3843E-04_JPRB/)
KBO( :, 4,58, 7) = (/&
&2.5422E-06_JPRB,6.5215E-05_JPRB,1.0612E-04_JPRB,1.3677E-04_JPRB,1.4007E-04_JPRB/)
KBO( :, 5,58, 7) = (/&
&4.3056E-06_JPRB,7.5939E-05_JPRB,1.1825E-04_JPRB,1.4847E-04_JPRB,1.4132E-04_JPRB/)
KBO( :, 1,59, 7) = (/&
&2.8711E-07_JPRB,3.5512E-05_JPRB,6.4676E-05_JPRB,9.1313E-05_JPRB,1.0905E-04_JPRB/)
KBO( :, 2,59, 7) = (/&
&5.8051E-07_JPRB,4.0372E-05_JPRB,7.0558E-05_JPRB,9.6940E-05_JPRB,1.1137E-04_JPRB/)
KBO( :, 3,59, 7) = (/&
&1.1009E-06_JPRB,4.6368E-05_JPRB,7.8242E-05_JPRB,1.0385E-04_JPRB,1.1298E-04_JPRB/)
KBO( :, 4,59, 7) = (/&
&1.9927E-06_JPRB,5.3528E-05_JPRB,8.7247E-05_JPRB,1.1259E-04_JPRB,1.1418E-04_JPRB/)
KBO( :, 5,59, 7) = (/&
&3.4060E-06_JPRB,6.2579E-05_JPRB,9.7497E-05_JPRB,1.2251E-04_JPRB,1.1509E-04_JPRB/)
KBO( :, 1,13, 8) = (/&
&2.3970E-02_JPRB,3.0710E-01_JPRB,5.4364E-01_JPRB,7.5219E-01_JPRB,9.5462E-01_JPRB/)
KBO( :, 2,13, 8) = (/&
&3.5910E-02_JPRB,3.2191E-01_JPRB,5.5986E-01_JPRB,7.6221E-01_JPRB,9.4753E-01_JPRB/)
KBO( :, 3,13, 8) = (/&
&5.1314E-02_JPRB,3.3704E-01_JPRB,5.7518E-01_JPRB,7.7250E-01_JPRB,9.3944E-01_JPRB/)
KBO( :, 4,13, 8) = (/&
&7.0544E-02_JPRB,3.5215E-01_JPRB,5.8965E-01_JPRB,7.8209E-01_JPRB,9.3187E-01_JPRB/)
KBO( :, 5,13, 8) = (/&
&9.4072E-02_JPRB,3.6813E-01_JPRB,6.0322E-01_JPRB,7.9095E-01_JPRB,9.2652E-01_JPRB/)
KBO( :, 1,14, 8) = (/&
&2.1394E-02_JPRB,2.9767E-01_JPRB,5.2636E-01_JPRB,7.2588E-01_JPRB,9.1476E-01_JPRB/)
KBO( :, 2,14, 8) = (/&
&3.2006E-02_JPRB,3.1221E-01_JPRB,5.4240E-01_JPRB,7.3771E-01_JPRB,9.0915E-01_JPRB/)
KBO( :, 3,14, 8) = (/&
&4.5714E-02_JPRB,3.2744E-01_JPRB,5.5760E-01_JPRB,7.4911E-01_JPRB,9.0264E-01_JPRB/)
KBO( :, 4,14, 8) = (/&
&6.3005E-02_JPRB,3.4291E-01_JPRB,5.7202E-01_JPRB,7.5985E-01_JPRB,8.9702E-01_JPRB/)
KBO( :, 5,14, 8) = (/&
&8.4224E-02_JPRB,3.5938E-01_JPRB,5.8648E-01_JPRB,7.6955E-01_JPRB,8.9207E-01_JPRB/)
KBO( :, 1,15, 8) = (/&
&1.9200E-02_JPRB,2.8555E-01_JPRB,5.0447E-01_JPRB,6.9471E-01_JPRB,8.6829E-01_JPRB/)
KBO( :, 2,15, 8) = (/&
&2.8674E-02_JPRB,2.9984E-01_JPRB,5.2000E-01_JPRB,7.0783E-01_JPRB,8.6420E-01_JPRB/)
KBO( :, 3,15, 8) = (/&
&4.1036E-02_JPRB,3.1465E-01_JPRB,5.3501E-01_JPRB,7.2026E-01_JPRB,8.6024E-01_JPRB/)
KBO( :, 4,15, 8) = (/&
&5.6691E-02_JPRB,3.3028E-01_JPRB,5.4991E-01_JPRB,7.3143E-01_JPRB,8.5592E-01_JPRB/)
KBO( :, 5,15, 8) = (/&
&7.5884E-02_JPRB,3.4766E-01_JPRB,5.6508E-01_JPRB,7.4152E-01_JPRB,8.5184E-01_JPRB/)
KBO( :, 1,16, 8) = (/&
&1.7280E-02_JPRB,2.7106E-01_JPRB,4.7797E-01_JPRB,6.5828E-01_JPRB,8.1566E-01_JPRB/)
KBO( :, 2,16, 8) = (/&
&2.5826E-02_JPRB,2.8505E-01_JPRB,4.9327E-01_JPRB,6.7219E-01_JPRB,8.1411E-01_JPRB/)
KBO( :, 3,16, 8) = (/&
&3.7038E-02_JPRB,2.9951E-01_JPRB,5.0847E-01_JPRB,6.8487E-01_JPRB,8.1174E-01_JPRB/)
KBO( :, 4,16, 8) = (/&
&5.1196E-02_JPRB,3.1526E-01_JPRB,5.2352E-01_JPRB,6.9628E-01_JPRB,8.0904E-01_JPRB/)
KBO( :, 5,16, 8) = (/&
&6.8473E-02_JPRB,3.3321E-01_JPRB,5.3879E-01_JPRB,7.0679E-01_JPRB,8.0649E-01_JPRB/)
KBO( :, 1,17, 8) = (/&
&1.5538E-02_JPRB,2.5421E-01_JPRB,4.4772E-01_JPRB,6.1710E-01_JPRB,7.5839E-01_JPRB/)
KBO( :, 2,17, 8) = (/&
&2.3272E-02_JPRB,2.6785E-01_JPRB,4.6279E-01_JPRB,6.3082E-01_JPRB,7.5816E-01_JPRB/)
KBO( :, 3,17, 8) = (/&
&3.3383E-02_JPRB,2.8231E-01_JPRB,4.7772E-01_JPRB,6.4345E-01_JPRB,7.5757E-01_JPRB/)
KBO( :, 4,17, 8) = (/&
&4.6070E-02_JPRB,2.9815E-01_JPRB,4.9276E-01_JPRB,6.5511E-01_JPRB,7.5658E-01_JPRB/)
KBO( :, 5,17, 8) = (/&
&6.1414E-02_JPRB,3.1621E-01_JPRB,5.0851E-01_JPRB,6.6619E-01_JPRB,7.5588E-01_JPRB/)
KBO( :, 1,18, 8) = (/&
&1.3967E-02_JPRB,2.3577E-01_JPRB,4.1440E-01_JPRB,5.7110E-01_JPRB,6.9644E-01_JPRB/)
KBO( :, 2,18, 8) = (/&
&2.0919E-02_JPRB,2.4897E-01_JPRB,4.2906E-01_JPRB,5.8444E-01_JPRB,6.9784E-01_JPRB/)
KBO( :, 3,18, 8) = (/&
&2.9927E-02_JPRB,2.6320E-01_JPRB,4.4386E-01_JPRB,5.9706E-01_JPRB,6.9881E-01_JPRB/)
KBO( :, 4,18, 8) = (/&
&4.1175E-02_JPRB,2.7935E-01_JPRB,4.5908E-01_JPRB,6.0918E-01_JPRB,6.9970E-01_JPRB/)
KBO( :, 5,18, 8) = (/&
&5.4768E-02_JPRB,2.9730E-01_JPRB,4.7517E-01_JPRB,6.2117E-01_JPRB,7.0068E-01_JPRB/)
KBO( :, 1,19, 8) = (/&
&1.2535E-02_JPRB,2.1612E-01_JPRB,3.7880E-01_JPRB,5.2193E-01_JPRB,6.3226E-01_JPRB/)
KBO( :, 2,19, 8) = (/&
&1.8709E-02_JPRB,2.2885E-01_JPRB,3.9316E-01_JPRB,5.3486E-01_JPRB,6.3494E-01_JPRB/)
KBO( :, 3,19, 8) = (/&
&2.6683E-02_JPRB,2.4307E-01_JPRB,4.0782E-01_JPRB,5.4746E-01_JPRB,6.3735E-01_JPRB/)
KBO( :, 4,19, 8) = (/&
&3.6602E-02_JPRB,2.5923E-01_JPRB,4.2323E-01_JPRB,5.6013E-01_JPRB,6.4003E-01_JPRB/)
KBO( :, 5,19, 8) = (/&
&4.8595E-02_JPRB,2.7710E-01_JPRB,4.3996E-01_JPRB,5.7286E-01_JPRB,6.4337E-01_JPRB/)
KBO( :, 1,20, 8) = (/&
&1.1287E-02_JPRB,1.9616E-01_JPRB,3.4278E-01_JPRB,4.7146E-01_JPRB,5.6767E-01_JPRB/)
KBO( :, 2,20, 8) = (/&
&1.6764E-02_JPRB,2.0859E-01_JPRB,3.5655E-01_JPRB,4.8417E-01_JPRB,5.7171E-01_JPRB/)
KBO( :, 3,20, 8) = (/&
&2.3811E-02_JPRB,2.2281E-01_JPRB,3.7110E-01_JPRB,4.9713E-01_JPRB,5.7584E-01_JPRB/)
KBO( :, 4,20, 8) = (/&
&3.2552E-02_JPRB,2.3876E-01_JPRB,3.8677E-01_JPRB,5.1039E-01_JPRB,5.8077E-01_JPRB/)
KBO( :, 5,20, 8) = (/&
&4.3159E-02_JPRB,2.5646E-01_JPRB,4.0398E-01_JPRB,5.2418E-01_JPRB,5.8653E-01_JPRB/)
KBO( :, 1,21, 8) = (/&
&1.0123E-02_JPRB,1.7642E-01_JPRB,3.0702E-01_JPRB,4.2164E-01_JPRB,5.0497E-01_JPRB/)
KBO( :, 2,21, 8) = (/&
&1.4960E-02_JPRB,1.8865E-01_JPRB,3.2047E-01_JPRB,4.3442E-01_JPRB,5.1019E-01_JPRB/)
KBO( :, 3,21, 8) = (/&
&2.1152E-02_JPRB,2.0268E-01_JPRB,3.3499E-01_JPRB,4.4767E-01_JPRB,5.1630E-01_JPRB/)
KBO( :, 4,21, 8) = (/&
&2.8843E-02_JPRB,2.1843E-01_JPRB,3.5106E-01_JPRB,4.6165E-01_JPRB,5.2357E-01_JPRB/)
KBO( :, 5,21, 8) = (/&
&3.8204E-02_JPRB,2.3577E-01_JPRB,3.6853E-01_JPRB,4.7644E-01_JPRB,5.3124E-01_JPRB/)
KBO( :, 1,22, 8) = (/&
&9.2874E-03_JPRB,1.5831E-01_JPRB,2.7358E-01_JPRB,3.7468E-01_JPRB,4.4590E-01_JPRB/)
KBO( :, 2,22, 8) = (/&
&1.3605E-02_JPRB,1.7047E-01_JPRB,2.8679E-01_JPRB,3.8765E-01_JPRB,4.5286E-01_JPRB/)
KBO( :, 3,22, 8) = (/&
&1.9114E-02_JPRB,1.8434E-01_JPRB,3.0159E-01_JPRB,4.0144E-01_JPRB,4.6097E-01_JPRB/)
KBO( :, 4,22, 8) = (/&
&2.5961E-02_JPRB,1.9982E-01_JPRB,3.1798E-01_JPRB,4.1606E-01_JPRB,4.6951E-01_JPRB/)
KBO( :, 5,22, 8) = (/&
&3.4349E-02_JPRB,2.1668E-01_JPRB,3.3570E-01_JPRB,4.3114E-01_JPRB,4.7729E-01_JPRB/)
KBO( :, 1,23, 8) = (/&
&8.4921E-03_JPRB,1.4152E-01_JPRB,2.4231E-01_JPRB,3.3110E-01_JPRB,3.9186E-01_JPRB/)
KBO( :, 2,23, 8) = (/&
&1.2342E-02_JPRB,1.5348E-01_JPRB,2.5569E-01_JPRB,3.4426E-01_JPRB,4.0022E-01_JPRB/)
KBO( :, 3,23, 8) = (/&
&1.7244E-02_JPRB,1.6712E-01_JPRB,2.7061E-01_JPRB,3.5816E-01_JPRB,4.0905E-01_JPRB/)
KBO( :, 4,23, 8) = (/&
&2.3366E-02_JPRB,1.8219E-01_JPRB,2.8684E-01_JPRB,3.7242E-01_JPRB,4.1729E-01_JPRB/)
KBO( :, 5,23, 8) = (/&
&3.0906E-02_JPRB,1.9826E-01_JPRB,3.0394E-01_JPRB,3.8658E-01_JPRB,4.2349E-01_JPRB/)
KBO( :, 1,24, 8) = (/&
&7.7535E-03_JPRB,1.2629E-01_JPRB,2.1405E-01_JPRB,2.9135E-01_JPRB,3.4301E-01_JPRB/)
KBO( :, 2,24, 8) = (/&
&1.1183E-02_JPRB,1.3800E-01_JPRB,2.2733E-01_JPRB,3.0427E-01_JPRB,3.5176E-01_JPRB/)
KBO( :, 3,24, 8) = (/&
&1.5576E-02_JPRB,1.5118E-01_JPRB,2.4185E-01_JPRB,3.1749E-01_JPRB,3.6002E-01_JPRB/)
KBO( :, 4,24, 8) = (/&
&2.1087E-02_JPRB,1.6543E-01_JPRB,2.5728E-01_JPRB,3.3050E-01_JPRB,3.6605E-01_JPRB/)
KBO( :, 5,24, 8) = (/&
&2.7862E-02_JPRB,1.8042E-01_JPRB,2.7311E-01_JPRB,3.4269E-01_JPRB,3.6924E-01_JPRB/)
KBO( :, 1,25, 8) = (/&
&7.0742E-03_JPRB,1.1262E-01_JPRB,1.8871E-01_JPRB,2.5540E-01_JPRB,2.9903E-01_JPRB/)
KBO( :, 2,25, 8) = (/&
&1.0155E-02_JPRB,1.2387E-01_JPRB,2.0149E-01_JPRB,2.6744E-01_JPRB,3.0694E-01_JPRB/)
KBO( :, 3,25, 8) = (/&
&1.4119E-02_JPRB,1.3621E-01_JPRB,2.1507E-01_JPRB,2.7908E-01_JPRB,3.1279E-01_JPRB/)
KBO( :, 4,25, 8) = (/&
&1.9079E-02_JPRB,1.4928E-01_JPRB,2.2897E-01_JPRB,2.8986E-01_JPRB,3.1583E-01_JPRB/)
KBO( :, 5,25, 8) = (/&
&2.5164E-02_JPRB,1.6305E-01_JPRB,2.4282E-01_JPRB,2.9961E-01_JPRB,3.1616E-01_JPRB/)
KBO( :, 1,26, 8) = (/&
&6.4819E-03_JPRB,1.0046E-01_JPRB,1.6616E-01_JPRB,2.2296E-01_JPRB,2.5906E-01_JPRB/)
KBO( :, 2,26, 8) = (/&
&9.2746E-03_JPRB,1.1094E-01_JPRB,1.7789E-01_JPRB,2.3321E-01_JPRB,2.6463E-01_JPRB/)
KBO( :, 3,26, 8) = (/&
&1.2860E-02_JPRB,1.2211E-01_JPRB,1.8982E-01_JPRB,2.4261E-01_JPRB,2.6762E-01_JPRB/)
KBO( :, 4,26, 8) = (/&
&1.7340E-02_JPRB,1.3390E-01_JPRB,2.0176E-01_JPRB,2.5109E-01_JPRB,2.6820E-01_JPRB/)
KBO( :, 5,26, 8) = (/&
&2.2797E-02_JPRB,1.4641E-01_JPRB,2.1346E-01_JPRB,2.5871E-01_JPRB,2.6701E-01_JPRB/)
KBO( :, 1,27, 8) = (/&
&5.9496E-03_JPRB,8.9354E-02_JPRB,1.4559E-01_JPRB,1.9301E-01_JPRB,2.2196E-01_JPRB/)
KBO( :, 2,27, 8) = (/&
&8.4823E-03_JPRB,9.8713E-02_JPRB,1.5575E-01_JPRB,2.0121E-01_JPRB,2.2502E-01_JPRB/)
KBO( :, 3,27, 8) = (/&
&1.1723E-02_JPRB,1.0860E-01_JPRB,1.6592E-01_JPRB,2.0857E-01_JPRB,2.2594E-01_JPRB/)
KBO( :, 4,27, 8) = (/&
&1.5760E-02_JPRB,1.1910E-01_JPRB,1.7588E-01_JPRB,2.1528E-01_JPRB,2.2532E-01_JPRB/)
KBO( :, 5,27, 8) = (/&
&2.0640E-02_JPRB,1.3042E-01_JPRB,1.8584E-01_JPRB,2.2158E-01_JPRB,2.2357E-01_JPRB/)
KBO( :, 1,28, 8) = (/&
&5.4648E-03_JPRB,7.8954E-02_JPRB,1.2664E-01_JPRB,1.6556E-01_JPRB,1.8790E-01_JPRB/)
KBO( :, 2,28, 8) = (/&
&7.7612E-03_JPRB,8.7134E-02_JPRB,1.3525E-01_JPRB,1.7197E-01_JPRB,1.8917E-01_JPRB/)
KBO( :, 3,28, 8) = (/&
&1.0688E-02_JPRB,9.5816E-02_JPRB,1.4371E-01_JPRB,1.7791E-01_JPRB,1.8910E-01_JPRB/)
KBO( :, 4,28, 8) = (/&
&1.4301E-02_JPRB,1.0515E-01_JPRB,1.5218E-01_JPRB,1.8352E-01_JPRB,1.8804E-01_JPRB/)
KBO( :, 5,28, 8) = (/&
&1.8668E-02_JPRB,1.1540E-01_JPRB,1.6098E-01_JPRB,1.8889E-01_JPRB,1.8616E-01_JPRB/)
KBO( :, 1,29, 8) = (/&
&5.0360E-03_JPRB,6.9325E-02_JPRB,1.0943E-01_JPRB,1.4091E-01_JPRB,1.5759E-01_JPRB/)
KBO( :, 2,29, 8) = (/&
&7.1202E-03_JPRB,7.6426E-02_JPRB,1.1663E-01_JPRB,1.4615E-01_JPRB,1.5798E-01_JPRB/)
KBO( :, 3,29, 8) = (/&
&9.7533E-03_JPRB,8.4055E-02_JPRB,1.2381E-01_JPRB,1.5115E-01_JPRB,1.5749E-01_JPRB/)
KBO( :, 4,29, 8) = (/&
&1.2997E-02_JPRB,9.2463E-02_JPRB,1.3122E-01_JPRB,1.5595E-01_JPRB,1.5628E-01_JPRB/)
KBO( :, 5,29, 8) = (/&
&1.6906E-02_JPRB,1.0185E-01_JPRB,1.3918E-01_JPRB,1.6061E-01_JPRB,1.5451E-01_JPRB/)
KBO( :, 1,30, 8) = (/&
&4.6402E-03_JPRB,6.0489E-02_JPRB,9.4043E-02_JPRB,1.1942E-01_JPRB,1.3140E-01_JPRB/)
KBO( :, 2,30, 8) = (/&
&6.5263E-03_JPRB,6.6689E-02_JPRB,1.0012E-01_JPRB,1.2384E-01_JPRB,1.3139E-01_JPRB/)
KBO( :, 3,30, 8) = (/&
&8.8957E-03_JPRB,7.3511E-02_JPRB,1.0635E-01_JPRB,1.2814E-01_JPRB,1.3072E-01_JPRB/)
KBO( :, 4,30, 8) = (/&
&1.1806E-02_JPRB,8.1191E-02_JPRB,1.1302E-01_JPRB,1.3230E-01_JPRB,1.2954E-01_JPRB/)
KBO( :, 5,30, 8) = (/&
&1.5321E-02_JPRB,8.9861E-02_JPRB,1.2036E-01_JPRB,1.3654E-01_JPRB,1.2795E-01_JPRB/)
KBO( :, 1,31, 8) = (/&
&4.2816E-03_JPRB,5.2594E-02_JPRB,8.0556E-02_JPRB,1.0100E-01_JPRB,1.0923E-01_JPRB/)
KBO( :, 2,31, 8) = (/&
&5.9928E-03_JPRB,5.8093E-02_JPRB,8.5788E-02_JPRB,1.0484E-01_JPRB,1.0901E-01_JPRB/)
KBO( :, 3,31, 8) = (/&
&8.1254E-03_JPRB,6.4313E-02_JPRB,9.1351E-02_JPRB,1.0855E-01_JPRB,1.0832E-01_JPRB/)
KBO( :, 4,31, 8) = (/&
&1.0750E-02_JPRB,7.1406E-02_JPRB,9.7440E-02_JPRB,1.1230E-01_JPRB,1.0725E-01_JPRB/)
KBO( :, 5,31, 8) = (/&
&1.3934E-02_JPRB,7.9435E-02_JPRB,1.0429E-01_JPRB,1.1627E-01_JPRB,1.0582E-01_JPRB/)
KBO( :, 1,32, 8) = (/&
&3.9575E-03_JPRB,4.5682E-02_JPRB,6.8898E-02_JPRB,8.5411E-02_JPRB,9.0602E-02_JPRB/)
KBO( :, 2,32, 8) = (/&
&5.5021E-03_JPRB,5.0658E-02_JPRB,7.3522E-02_JPRB,8.8727E-02_JPRB,9.0292E-02_JPRB/)
KBO( :, 3,32, 8) = (/&
&7.4345E-03_JPRB,5.6386E-02_JPRB,7.8565E-02_JPRB,9.2013E-02_JPRB,8.9633E-02_JPRB/)
KBO( :, 4,32, 8) = (/&
&9.8223E-03_JPRB,6.2960E-02_JPRB,8.4228E-02_JPRB,9.5465E-02_JPRB,8.8660E-02_JPRB/)
KBO( :, 5,32, 8) = (/&
&1.2730E-02_JPRB,7.0429E-02_JPRB,9.0625E-02_JPRB,9.9233E-02_JPRB,8.7449E-02_JPRB/)
KBO( :, 1,33, 8) = (/&
&3.6591E-03_JPRB,3.9715E-02_JPRB,5.8948E-02_JPRB,7.2241E-02_JPRB,7.5055E-02_JPRB/)
KBO( :, 2,33, 8) = (/&
&5.0639E-03_JPRB,4.4286E-02_JPRB,6.3097E-02_JPRB,7.5129E-02_JPRB,7.4722E-02_JPRB/)
KBO( :, 3,33, 8) = (/&
&6.8217E-03_JPRB,4.9606E-02_JPRB,6.7743E-02_JPRB,7.8113E-02_JPRB,7.4121E-02_JPRB/)
KBO( :, 4,33, 8) = (/&
&9.0010E-03_JPRB,5.5729E-02_JPRB,7.3038E-02_JPRB,8.1349E-02_JPRB,7.3284E-02_JPRB/)
KBO( :, 5,33, 8) = (/&
&1.1693E-02_JPRB,6.2702E-02_JPRB,7.9022E-02_JPRB,8.4992E-02_JPRB,7.2286E-02_JPRB/)
KBO( :, 1,34, 8) = (/&
&3.3424E-03_JPRB,3.4485E-02_JPRB,5.0364E-02_JPRB,6.1041E-02_JPRB,6.2108E-02_JPRB/)
KBO( :, 2,34, 8) = (/&
&4.6136E-03_JPRB,3.8708E-02_JPRB,5.4132E-02_JPRB,6.3612E-02_JPRB,6.1791E-02_JPRB/)
KBO( :, 3,34, 8) = (/&
&6.2081E-03_JPRB,4.3641E-02_JPRB,5.8453E-02_JPRB,6.6369E-02_JPRB,6.1269E-02_JPRB/)
KBO( :, 4,34, 8) = (/&
&8.2079E-03_JPRB,4.9328E-02_JPRB,6.3400E-02_JPRB,6.9443E-02_JPRB,6.0579E-02_JPRB/)
KBO( :, 5,34, 8) = (/&
&1.0690E-02_JPRB,5.5879E-02_JPRB,6.9026E-02_JPRB,7.2976E-02_JPRB,5.9770E-02_JPRB/)
KBO( :, 1,35, 8) = (/&
&2.9610E-03_JPRB,2.9708E-02_JPRB,4.2806E-02_JPRB,5.1414E-02_JPRB,5.1399E-02_JPRB/)
KBO( :, 2,35, 8) = (/&
&4.0852E-03_JPRB,3.3563E-02_JPRB,4.6239E-02_JPRB,5.3734E-02_JPRB,5.1129E-02_JPRB/)
KBO( :, 3,35, 8) = (/&
&5.5146E-03_JPRB,3.8090E-02_JPRB,5.0226E-02_JPRB,5.6294E-02_JPRB,5.0708E-02_JPRB/)
KBO( :, 4,35, 8) = (/&
&7.3191E-03_JPRB,4.3348E-02_JPRB,5.4809E-02_JPRB,5.9220E-02_JPRB,5.0169E-02_JPRB/)
KBO( :, 5,35, 8) = (/&
&9.5862E-03_JPRB,4.9447E-02_JPRB,6.0051E-02_JPRB,6.2576E-02_JPRB,4.9549E-02_JPRB/)
KBO( :, 1,36, 8) = (/&
&2.5291E-03_JPRB,2.5317E-02_JPRB,3.6139E-02_JPRB,4.3139E-02_JPRB,4.2550E-02_JPRB/)
KBO( :, 2,36, 8) = (/&
&3.5081E-03_JPRB,2.8787E-02_JPRB,3.9246E-02_JPRB,4.5245E-02_JPRB,4.2349E-02_JPRB/)
KBO( :, 3,36, 8) = (/&
&4.7623E-03_JPRB,3.2880E-02_JPRB,4.2875E-02_JPRB,4.7610E-02_JPRB,4.2034E-02_JPRB/)
KBO( :, 4,36, 8) = (/&
&6.3600E-03_JPRB,3.7684E-02_JPRB,4.7082E-02_JPRB,5.0344E-02_JPRB,4.1631E-02_JPRB/)
KBO( :, 5,36, 8) = (/&
&8.3828E-03_JPRB,4.3328E-02_JPRB,5.1915E-02_JPRB,5.3486E-02_JPRB,4.1174E-02_JPRB/)
KBO( :, 1,37, 8) = (/&
&2.0572E-03_JPRB,2.1190E-02_JPRB,3.0172E-02_JPRB,3.5966E-02_JPRB,3.5231E-02_JPRB/)
KBO( :, 2,37, 8) = (/&
&2.8742E-03_JPRB,2.4234E-02_JPRB,3.2921E-02_JPRB,3.7847E-02_JPRB,3.5097E-02_JPRB/)
KBO( :, 3,37, 8) = (/&
&3.9377E-03_JPRB,2.7856E-02_JPRB,3.6156E-02_JPRB,3.9991E-02_JPRB,3.4880E-02_JPRB/)
KBO( :, 4,37, 8) = (/&
&5.3075E-03_JPRB,3.2157E-02_JPRB,3.9929E-02_JPRB,4.2485E-02_JPRB,3.4595E-02_JPRB/)
KBO( :, 5,37, 8) = (/&
&7.0531E-03_JPRB,3.7266E-02_JPRB,4.4310E-02_JPRB,4.5361E-02_JPRB,3.4266E-02_JPRB/)
KBO( :, 1,38, 8) = (/&
&1.6668E-03_JPRB,1.7718E-02_JPRB,2.5179E-02_JPRB,2.9976E-02_JPRB,2.9178E-02_JPRB/)
KBO( :, 2,38, 8) = (/&
&2.3512E-03_JPRB,2.0388E-02_JPRB,2.7616E-02_JPRB,3.1654E-02_JPRB,2.9106E-02_JPRB/)
KBO( :, 3,38, 8) = (/&
&3.2489E-03_JPRB,2.3599E-02_JPRB,3.0491E-02_JPRB,3.3589E-02_JPRB,2.8965E-02_JPRB/)
KBO( :, 4,38, 8) = (/&
&4.4197E-03_JPRB,2.7448E-02_JPRB,3.3876E-02_JPRB,3.5861E-02_JPRB,2.8777E-02_JPRB/)
KBO( :, 5,38, 8) = (/&
&5.9291E-03_JPRB,3.2085E-02_JPRB,3.7857E-02_JPRB,3.8499E-02_JPRB,2.8558E-02_JPRB/)
KBO( :, 1,39, 8) = (/&
&1.3505E-03_JPRB,1.4824E-02_JPRB,2.1025E-02_JPRB,2.4988E-02_JPRB,2.4183E-02_JPRB/)
KBO( :, 2,39, 8) = (/&
&1.9237E-03_JPRB,1.7169E-02_JPRB,2.3181E-02_JPRB,2.6485E-02_JPRB,2.4157E-02_JPRB/)
KBO( :, 3,39, 8) = (/&
&2.6812E-03_JPRB,2.0015E-02_JPRB,2.5740E-02_JPRB,2.8232E-02_JPRB,2.4081E-02_JPRB/)
KBO( :, 4,39, 8) = (/&
&3.6890E-03_JPRB,2.3470E-02_JPRB,2.8781E-02_JPRB,3.0301E-02_JPRB,2.3974E-02_JPRB/)
KBO( :, 5,39, 8) = (/&
&4.9956E-03_JPRB,2.7688E-02_JPRB,3.2410E-02_JPRB,3.2726E-02_JPRB,2.3849E-02_JPRB/)
KBO( :, 1,40, 8) = (/&
&1.0535E-03_JPRB,1.2217E-02_JPRB,1.7388E-02_JPRB,2.0709E-02_JPRB,2.0019E-02_JPRB/)
KBO( :, 2,40, 8) = (/&
&1.5173E-03_JPRB,1.4233E-02_JPRB,1.9255E-02_JPRB,2.2025E-02_JPRB,2.0029E-02_JPRB/)
KBO( :, 3,40, 8) = (/&
&2.1424E-03_JPRB,1.6709E-02_JPRB,2.1499E-02_JPRB,2.3574E-02_JPRB,2.0001E-02_JPRB/)
KBO( :, 4,40, 8) = (/&
&2.9806E-03_JPRB,1.9754E-02_JPRB,2.4186E-02_JPRB,2.5425E-02_JPRB,1.9953E-02_JPRB/)
KBO( :, 5,40, 8) = (/&
&4.0841E-03_JPRB,2.3521E-02_JPRB,2.7438E-02_JPRB,2.7615E-02_JPRB,1.9891E-02_JPRB/)
KBO( :, 1,41, 8) = (/&
&8.1549E-04_JPRB,1.0039E-02_JPRB,1.4352E-02_JPRB,1.7141E-02_JPRB,1.6569E-02_JPRB/)
KBO( :, 2,41, 8) = (/&
&1.1896E-03_JPRB,1.1765E-02_JPRB,1.5963E-02_JPRB,1.8295E-02_JPRB,1.6609E-02_JPRB/)
KBO( :, 3,41, 8) = (/&
&1.7007E-03_JPRB,1.3910E-02_JPRB,1.7922E-02_JPRB,1.9664E-02_JPRB,1.6616E-02_JPRB/)
KBO( :, 4,41, 8) = (/&
&2.3967E-03_JPRB,1.6587E-02_JPRB,2.0295E-02_JPRB,2.1313E-02_JPRB,1.6608E-02_JPRB/)
KBO( :, 5,41, 8) = (/&
&3.3209E-03_JPRB,1.9941E-02_JPRB,2.3193E-02_JPRB,2.3279E-02_JPRB,1.6596E-02_JPRB/)
KBO( :, 1,42, 8) = (/&
&6.2885E-04_JPRB,8.2389E-03_JPRB,1.1838E-02_JPRB,1.4182E-02_JPRB,1.3717E-02_JPRB/)
KBO( :, 2,42, 8) = (/&
&9.3075E-04_JPRB,9.7147E-03_JPRB,1.3226E-02_JPRB,1.5189E-02_JPRB,1.3775E-02_JPRB/)
KBO( :, 3,42, 8) = (/&
&1.3476E-03_JPRB,1.1572E-02_JPRB,1.4934E-02_JPRB,1.6397E-02_JPRB,1.3812E-02_JPRB/)
KBO( :, 4,42, 8) = (/&
&1.9221E-03_JPRB,1.3921E-02_JPRB,1.7022E-02_JPRB,1.7862E-02_JPRB,1.3835E-02_JPRB/)
KBO( :, 5,42, 8) = (/&
&2.6974E-03_JPRB,1.6905E-02_JPRB,1.9608E-02_JPRB,1.9625E-02_JPRB,1.3858E-02_JPRB/)
KBO( :, 1,43, 8) = (/&
&4.7225E-04_JPRB,6.6911E-03_JPRB,9.6971E-03_JPRB,1.1682E-02_JPRB,1.1351E-02_JPRB/)
KBO( :, 2,43, 8) = (/&
&7.0933E-04_JPRB,7.9348E-03_JPRB,1.0877E-02_JPRB,1.2551E-02_JPRB,1.1424E-02_JPRB/)
KBO( :, 3,43, 8) = (/&
&1.0435E-03_JPRB,9.5155E-03_JPRB,1.2344E-02_JPRB,1.3602E-02_JPRB,1.1480E-02_JPRB/)
KBO( :, 4,43, 8) = (/&
&1.5082E-03_JPRB,1.1547E-02_JPRB,1.4158E-02_JPRB,1.4886E-02_JPRB,1.1523E-02_JPRB/)
KBO( :, 5,43, 8) = (/&
&2.1454E-03_JPRB,1.4163E-02_JPRB,1.6434E-02_JPRB,1.6450E-02_JPRB,1.1573E-02_JPRB/)
KBO( :, 1,44, 8) = (/&
&3.4902E-04_JPRB,5.4014E-03_JPRB,7.9122E-03_JPRB,9.5973E-03_JPRB,9.3906E-03_JPRB/)
KBO( :, 2,44, 8) = (/&
&5.3336E-04_JPRB,6.4385E-03_JPRB,8.9048E-03_JPRB,1.0341E-02_JPRB,9.4727E-03_JPRB/)
KBO( :, 3,44, 8) = (/&
&7.9641E-04_JPRB,7.7741E-03_JPRB,1.0155E-02_JPRB,1.1247E-02_JPRB,9.5408E-03_JPRB/)
KBO( :, 4,44, 8) = (/&
&1.1697E-03_JPRB,9.5107E-03_JPRB,1.1718E-02_JPRB,1.2366E-02_JPRB,9.5994E-03_JPRB/)
KBO( :, 5,44, 8) = (/&
&1.6866E-03_JPRB,1.1782E-02_JPRB,1.3700E-02_JPRB,1.3737E-02_JPRB,9.6629E-03_JPRB/)
KBO( :, 1,45, 8) = (/&
&2.5641E-04_JPRB,4.3524E-03_JPRB,6.4489E-03_JPRB,7.8776E-03_JPRB,7.7700E-03_JPRB/)
KBO( :, 2,45, 8) = (/&
&3.9819E-04_JPRB,5.2131E-03_JPRB,7.2796E-03_JPRB,8.5115E-03_JPRB,7.8565E-03_JPRB/)
KBO( :, 3,45, 8) = (/&
&6.0452E-04_JPRB,6.3356E-03_JPRB,8.3400E-03_JPRB,9.2883E-03_JPRB,7.9298E-03_JPRB/)
KBO( :, 4,45, 8) = (/&
&9.0225E-04_JPRB,7.8148E-03_JPRB,9.6818E-03_JPRB,1.0257E-02_JPRB,7.9978E-03_JPRB/)
KBO( :, 5,45, 8) = (/&
&1.3212E-03_JPRB,9.7779E-03_JPRB,1.1402E-02_JPRB,1.1457E-02_JPRB,8.0738E-03_JPRB/)
KBO( :, 1,46, 8) = (/&
&1.8524E-04_JPRB,3.4864E-03_JPRB,5.2341E-03_JPRB,6.4466E-03_JPRB,6.4230E-03_JPRB/)
KBO( :, 2,46, 8) = (/&
&2.9313E-04_JPRB,4.1931E-03_JPRB,5.9228E-03_JPRB,6.9831E-03_JPRB,6.5117E-03_JPRB/)
KBO( :, 3,46, 8) = (/&
&4.5241E-04_JPRB,5.1271E-03_JPRB,6.8142E-03_JPRB,7.6439E-03_JPRB,6.5889E-03_JPRB/)
KBO( :, 4,46, 8) = (/&
&6.8674E-04_JPRB,6.3729E-03_JPRB,7.9564E-03_JPRB,8.4768E-03_JPRB,6.6644E-03_JPRB/)
KBO( :, 5,46, 8) = (/&
&1.0220E-03_JPRB,8.0538E-03_JPRB,9.4380E-03_JPRB,9.5193E-03_JPRB,6.7476E-03_JPRB/)
KBO( :, 1,47, 8) = (/&
&1.3000E-04_JPRB,2.7663E-03_JPRB,4.2208E-03_JPRB,5.2521E-03_JPRB,5.3026E-03_JPRB/)
KBO( :, 2,47, 8) = (/&
&2.1025E-04_JPRB,3.3363E-03_JPRB,4.7828E-03_JPRB,5.7020E-03_JPRB,5.3902E-03_JPRB/)
KBO( :, 3,47, 8) = (/&
&3.3047E-04_JPRB,4.0995E-03_JPRB,5.5201E-03_JPRB,6.2559E-03_JPRB,5.4679E-03_JPRB/)
KBO( :, 4,47, 8) = (/&
&5.1029E-04_JPRB,5.1296E-03_JPRB,6.4755E-03_JPRB,6.9601E-03_JPRB,5.5444E-03_JPRB/)
KBO( :, 5,47, 8) = (/&
&7.7317E-04_JPRB,6.5403E-03_JPRB,7.7293E-03_JPRB,7.8503E-03_JPRB,5.6289E-03_JPRB/)
KBO( :, 1,48, 8) = (/&
&9.0250E-05_JPRB,2.1914E-03_JPRB,3.3994E-03_JPRB,4.2738E-03_JPRB,4.3771E-03_JPRB/)
KBO( :, 2,48, 8) = (/&
&1.4933E-04_JPRB,2.6470E-03_JPRB,3.8547E-03_JPRB,4.6490E-03_JPRB,4.4611E-03_JPRB/)
KBO( :, 3,48, 8) = (/&
&2.3950E-04_JPRB,3.2661E-03_JPRB,4.4586E-03_JPRB,5.1091E-03_JPRB,4.5366E-03_JPRB/)
KBO( :, 4,48, 8) = (/&
&3.7635E-04_JPRB,4.1116E-03_JPRB,5.2534E-03_JPRB,5.7004E-03_JPRB,4.6124E-03_JPRB/)
KBO( :, 5,48, 8) = (/&
&5.8082E-04_JPRB,5.2884E-03_JPRB,6.3086E-03_JPRB,6.4573E-03_JPRB,4.6977E-03_JPRB/)
KBO( :, 1,49, 8) = (/&
&6.1993E-05_JPRB,1.7331E-03_JPRB,2.7330E-03_JPRB,3.4719E-03_JPRB,3.6111E-03_JPRB/)
KBO( :, 2,49, 8) = (/&
&1.0511E-04_JPRB,2.0938E-03_JPRB,3.1004E-03_JPRB,3.7836E-03_JPRB,3.6915E-03_JPRB/)
KBO( :, 3,49, 8) = (/&
&1.7216E-04_JPRB,2.5932E-03_JPRB,3.5917E-03_JPRB,4.1650E-03_JPRB,3.7653E-03_JPRB/)
KBO( :, 4,49, 8) = (/&
&2.7551E-04_JPRB,3.2829E-03_JPRB,4.2486E-03_JPRB,4.6580E-03_JPRB,3.8405E-03_JPRB/)
KBO( :, 5,49, 8) = (/&
&4.3301E-04_JPRB,4.2570E-03_JPRB,5.1317E-03_JPRB,5.2985E-03_JPRB,3.9263E-03_JPRB/)
KBO( :, 1,50, 8) = (/&
&4.2678E-05_JPRB,1.3745E-03_JPRB,2.2002E-03_JPRB,2.8212E-03_JPRB,2.9737E-03_JPRB/)
KBO( :, 2,50, 8) = (/&
&7.4146E-05_JPRB,1.6605E-03_JPRB,2.4974E-03_JPRB,3.0815E-03_JPRB,3.0479E-03_JPRB/)
KBO( :, 3,50, 8) = (/&
&1.2406E-04_JPRB,2.0639E-03_JPRB,2.8982E-03_JPRB,3.3988E-03_JPRB,3.1188E-03_JPRB/)
KBO( :, 4,50, 8) = (/&
&2.0253E-04_JPRB,2.6282E-03_JPRB,3.4425E-03_JPRB,3.8116E-03_JPRB,3.1913E-03_JPRB/)
KBO( :, 5,50, 8) = (/&
&3.2424E-04_JPRB,3.4369E-03_JPRB,4.1830E-03_JPRB,4.3547E-03_JPRB,3.2730E-03_JPRB/)
KBO( :, 1,51, 8) = (/&
&2.9237E-05_JPRB,1.0909E-03_JPRB,1.7714E-03_JPRB,2.2917E-03_JPRB,2.4464E-03_JPRB/)
KBO( :, 2,51, 8) = (/&
&5.2166E-05_JPRB,1.3176E-03_JPRB,2.0125E-03_JPRB,2.5102E-03_JPRB,2.5148E-03_JPRB/)
KBO( :, 3,51, 8) = (/&
&8.9091E-05_JPRB,1.6426E-03_JPRB,2.3388E-03_JPRB,2.7738E-03_JPRB,2.5806E-03_JPRB/)
KBO( :, 4,51, 8) = (/&
&1.4840E-04_JPRB,2.1028E-03_JPRB,2.7878E-03_JPRB,3.1176E-03_JPRB,2.6477E-03_JPRB/)
KBO( :, 5,51, 8) = (/&
&2.4207E-04_JPRB,2.7714E-03_JPRB,3.4063E-03_JPRB,3.5762E-03_JPRB,2.7227E-03_JPRB/)
KBO( :, 1,52, 8) = (/&
&1.9807E-05_JPRB,8.6538E-04_JPRB,1.4249E-03_JPRB,1.8595E-03_JPRB,2.0124E-03_JPRB/)
KBO( :, 2,52, 8) = (/&
&3.6322E-05_JPRB,1.0438E-03_JPRB,1.6200E-03_JPRB,2.0422E-03_JPRB,2.0750E-03_JPRB/)
KBO( :, 3,52, 8) = (/&
&6.3515E-05_JPRB,1.3037E-03_JPRB,1.8836E-03_JPRB,2.2603E-03_JPRB,2.1352E-03_JPRB/)
KBO( :, 4,52, 8) = (/&
&1.0788E-04_JPRB,1.6767E-03_JPRB,2.2517E-03_JPRB,2.5448E-03_JPRB,2.1970E-03_JPRB/)
KBO( :, 5,52, 8) = (/&
&1.7958E-04_JPRB,2.2260E-03_JPRB,2.7651E-03_JPRB,2.9295E-03_JPRB,2.2657E-03_JPRB/)
KBO( :, 1,53, 8) = (/&
&1.3242E-05_JPRB,6.8573E-04_JPRB,1.1446E-03_JPRB,1.5067E-03_JPRB,1.6550E-03_JPRB/)
KBO( :, 2,53, 8) = (/&
&2.5022E-05_JPRB,8.2535E-04_JPRB,1.3018E-03_JPRB,1.6587E-03_JPRB,1.7117E-03_JPRB/)
KBO( :, 3,53, 8) = (/&
&4.4849E-05_JPRB,1.0313E-03_JPRB,1.5135E-03_JPRB,1.8385E-03_JPRB,1.7670E-03_JPRB/)
KBO( :, 4,53, 8) = (/&
&7.7724E-05_JPRB,1.3321E-03_JPRB,1.8130E-03_JPRB,2.0729E-03_JPRB,1.8239E-03_JPRB/)
KBO( :, 5,53, 8) = (/&
&1.3199E-04_JPRB,1.7794E-03_JPRB,2.2365E-03_JPRB,2.3931E-03_JPRB,1.8874E-03_JPRB/)
KBO( :, 1,54, 8) = (/&
&8.9248E-06_JPRB,5.4556E-04_JPRB,9.2163E-04_JPRB,1.2225E-03_JPRB,1.3566E-03_JPRB/)
KBO( :, 2,54, 8) = (/&
&1.7372E-05_JPRB,6.5581E-04_JPRB,1.0492E-03_JPRB,1.3494E-03_JPRB,1.4063E-03_JPRB/)
KBO( :, 3,54, 8) = (/&
&3.1907E-05_JPRB,8.1979E-04_JPRB,1.2202E-03_JPRB,1.4983E-03_JPRB,1.4551E-03_JPRB/)
KBO( :, 4,54, 8) = (/&
&5.6506E-05_JPRB,1.0634E-03_JPRB,1.4647E-03_JPRB,1.6922E-03_JPRB,1.5046E-03_JPRB/)
KBO( :, 5,54, 8) = (/&
&9.7836E-05_JPRB,1.4301E-03_JPRB,1.8159E-03_JPRB,1.9597E-03_JPRB,1.5596E-03_JPRB/)
KBO( :, 1,55, 8) = (/&
&6.0009E-06_JPRB,4.3459E-04_JPRB,7.4215E-04_JPRB,9.9172E-04_JPRB,1.1093E-03_JPRB/)
KBO( :, 2,55, 8) = (/&
&1.2050E-05_JPRB,5.2184E-04_JPRB,8.4618E-04_JPRB,1.0977E-03_JPRB,1.1520E-03_JPRB/)
KBO( :, 3,55, 8) = (/&
&2.2697E-05_JPRB,6.5227E-04_JPRB,9.8427E-04_JPRB,1.2212E-03_JPRB,1.1941E-03_JPRB/)
KBO( :, 4,55, 8) = (/&
&4.1051E-05_JPRB,8.4944E-04_JPRB,1.1837E-03_JPRB,1.3815E-03_JPRB,1.2361E-03_JPRB/)
KBO( :, 5,55, 8) = (/&
&7.2472E-05_JPRB,1.1494E-03_JPRB,1.4743E-03_JPRB,1.6046E-03_JPRB,1.2823E-03_JPRB/)
KBO( :, 1,56, 8) = (/&
&3.9898E-06_JPRB,3.4589E-04_JPRB,5.9689E-04_JPRB,8.0352E-04_JPRB,9.0649E-04_JPRB/)
KBO( :, 2,56, 8) = (/&
&8.2750E-06_JPRB,4.1470E-04_JPRB,6.8153E-04_JPRB,8.9166E-04_JPRB,9.4301E-04_JPRB/)
KBO( :, 3,56, 8) = (/&
&1.6003E-05_JPRB,5.1786E-04_JPRB,7.9279E-04_JPRB,9.9410E-04_JPRB,9.7913E-04_JPRB/)
KBO( :, 4,56, 8) = (/&
&2.9587E-05_JPRB,6.7655E-04_JPRB,9.5450E-04_JPRB,1.1258E-03_JPRB,1.0149E-03_JPRB/)
KBO( :, 5,56, 8) = (/&
&5.3280E-05_JPRB,9.2055E-04_JPRB,1.1938E-03_JPRB,1.3111E-03_JPRB,1.0536E-03_JPRB/)
KBO( :, 1,57, 8) = (/&
&2.6173E-06_JPRB,2.7500E-04_JPRB,4.7940E-04_JPRB,6.5022E-04_JPRB,7.4014E-04_JPRB/)
KBO( :, 2,57, 8) = (/&
&5.6185E-06_JPRB,3.2928E-04_JPRB,5.4834E-04_JPRB,7.2338E-04_JPRB,7.7148E-04_JPRB/)
KBO( :, 3,57, 8) = (/&
&1.1178E-05_JPRB,4.1034E-04_JPRB,6.3758E-04_JPRB,8.0791E-04_JPRB,8.0223E-04_JPRB/)
KBO( :, 4,57, 8) = (/&
&2.1131E-05_JPRB,5.3714E-04_JPRB,7.6779E-04_JPRB,9.1604E-04_JPRB,8.3279E-04_JPRB/)
KBO( :, 5,57, 8) = (/&
&3.8855E-05_JPRB,7.3446E-04_JPRB,9.6373E-04_JPRB,1.0689E-03_JPRB,8.6527E-04_JPRB/)
KBO( :, 1,58, 8) = (/&
&1.7187E-06_JPRB,2.1897E-04_JPRB,3.8537E-04_JPRB,5.2636E-04_JPRB,6.0391E-04_JPRB/)
KBO( :, 2,58, 8) = (/&
&3.8204E-06_JPRB,2.6201E-04_JPRB,4.4157E-04_JPRB,5.8689E-04_JPRB,6.3061E-04_JPRB/)
KBO( :, 3,58, 8) = (/&
&7.8175E-06_JPRB,3.2596E-04_JPRB,5.1345E-04_JPRB,6.5702E-04_JPRB,6.5669E-04_JPRB/)
KBO( :, 4,58, 8) = (/&
&1.5128E-05_JPRB,4.2731E-04_JPRB,6.1848E-04_JPRB,7.4589E-04_JPRB,6.8257E-04_JPRB/)
KBO( :, 5,58, 8) = (/&
&2.8383E-05_JPRB,5.8709E-04_JPRB,7.7891E-04_JPRB,8.7185E-04_JPRB,7.0967E-04_JPRB/)
KBO( :, 1,59, 8) = (/&
&1.3071E-06_JPRB,1.7971E-04_JPRB,3.1713E-04_JPRB,4.3408E-04_JPRB,4.9479E-04_JPRB/)
KBO( :, 2,59, 8) = (/&
&2.9593E-06_JPRB,2.1590E-04_JPRB,3.6455E-04_JPRB,4.8545E-04_JPRB,5.1653E-04_JPRB/)
KBO( :, 3,59, 8) = (/&
&6.1606E-06_JPRB,2.7044E-04_JPRB,4.2589E-04_JPRB,5.4538E-04_JPRB,5.3752E-04_JPRB/)
KBO( :, 4,59, 8) = (/&
&1.2116E-05_JPRB,3.5815E-04_JPRB,5.1701E-04_JPRB,6.2252E-04_JPRB,5.5854E-04_JPRB/)
KBO( :, 5,59, 8) = (/&
&2.3132E-05_JPRB,4.9905E-04_JPRB,6.5830E-04_JPRB,7.3365E-04_JPRB,5.8023E-04_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB5_B2
