!OCL SCALAR
SUBROUTINE RRTM_KGB5_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, CCL4O
USE YOERRTA5 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 9 and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 9 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature TREF-15, 
!     JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.2281E-06_JPRB,7.3444E-06_JPRB,1.3802E-05_JPRB,2.1363E-05_JPRB,3.4026E-05_JPRB,5.1149E-05_JPRB,&
&7.6454E-05_JPRB,1.1492E-04_JPRB,5.1051E-05_JPRB/)
KAO( :, 2, 1, 1) = (/&
&1.6369E-06_JPRB,8.9617E-06_JPRB,1.6072E-05_JPRB,2.4135E-05_JPRB,3.4106E-05_JPRB,4.9214E-05_JPRB,&
&7.9048E-05_JPRB,1.3905E-04_JPRB,5.4063E-05_JPRB/)
KAO( :, 3, 1, 1) = (/&
&2.1611E-06_JPRB,1.1094E-05_JPRB,1.8726E-05_JPRB,2.7825E-05_JPRB,3.8281E-05_JPRB,5.1592E-05_JPRB,&
&7.6813E-05_JPRB,1.3616E-04_JPRB,6.0994E-05_JPRB/)
KAO( :, 4, 1, 1) = (/&
&2.8032E-06_JPRB,1.3911E-05_JPRB,2.1873E-05_JPRB,3.1872E-05_JPRB,4.3669E-05_JPRB,5.8650E-05_JPRB,&
&8.1107E-05_JPRB,1.3247E-04_JPRB,6.8413E-05_JPRB/)
KAO( :, 5, 1, 1) = (/&
&3.5749E-06_JPRB,1.7399E-05_JPRB,2.6270E-05_JPRB,3.5363E-05_JPRB,4.8470E-05_JPRB,6.5479E-05_JPRB,&
&9.0735E-05_JPRB,1.4099E-04_JPRB,5.7731E-05_JPRB/)
KAO( :, 1, 2, 1) = (/&
&9.2208E-07_JPRB,5.6661E-06_JPRB,1.0853E-05_JPRB,1.7695E-05_JPRB,2.8111E-05_JPRB,4.1811E-05_JPRB,&
&5.7766E-05_JPRB,8.8171E-05_JPRB,3.6499E-05_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.2339E-06_JPRB,6.8718E-06_JPRB,1.2450E-05_JPRB,1.9038E-05_JPRB,2.7428E-05_JPRB,4.2214E-05_JPRB,&
&6.5891E-05_JPRB,1.0808E-04_JPRB,3.9328E-05_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.6382E-06_JPRB,8.4733E-06_JPRB,1.4470E-05_JPRB,2.1567E-05_JPRB,3.0172E-05_JPRB,4.1842E-05_JPRB,&
&6.2761E-05_JPRB,1.1359E-04_JPRB,4.4926E-05_JPRB/)
KAO( :, 4, 2, 1) = (/&
&2.1437E-06_JPRB,1.0582E-05_JPRB,1.7090E-05_JPRB,2.4961E-05_JPRB,3.4319E-05_JPRB,4.6334E-05_JPRB,&
&6.4942E-05_JPRB,1.0880E-04_JPRB,4.8706E-05_JPRB/)
KAO( :, 5, 2, 1) = (/&
&2.7550E-06_JPRB,1.3307E-05_JPRB,2.0303E-05_JPRB,2.7768E-05_JPRB,3.8649E-05_JPRB,5.3069E-05_JPRB,&
&7.1656E-05_JPRB,1.1174E-04_JPRB,4.2264E-05_JPRB/)
KAO( :, 1, 3, 1) = (/&
&6.5681E-07_JPRB,4.2928E-06_JPRB,8.6206E-06_JPRB,1.4813E-05_JPRB,2.2795E-05_JPRB,3.0956E-05_JPRB,&
&4.2159E-05_JPRB,6.7143E-05_JPRB,2.4558E-05_JPRB/)
KAO( :, 2, 3, 1) = (/&
&8.8032E-07_JPRB,5.0858E-06_JPRB,9.4979E-06_JPRB,1.4908E-05_JPRB,2.3302E-05_JPRB,3.4761E-05_JPRB,&
&5.2810E-05_JPRB,7.8083E-05_JPRB,2.7352E-05_JPRB/)
KAO( :, 3, 3, 1) = (/&
&1.1757E-06_JPRB,6.2479E-06_JPRB,1.1007E-05_JPRB,1.6613E-05_JPRB,2.3543E-05_JPRB,3.3879E-05_JPRB,&
&5.3064E-05_JPRB,9.3905E-05_JPRB,3.1433E-05_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.5541E-06_JPRB,7.7549E-06_JPRB,1.2987E-05_JPRB,1.9178E-05_JPRB,2.6197E-05_JPRB,3.5750E-05_JPRB,&
&5.1915E-05_JPRB,9.2229E-05_JPRB,2.9423E-05_JPRB/)
KAO( :, 5, 3, 1) = (/&
&2.0193E-06_JPRB,9.7639E-06_JPRB,1.5167E-05_JPRB,2.2031E-05_JPRB,3.0010E-05_JPRB,4.0258E-05_JPRB,&
&5.5267E-05_JPRB,9.0112E-05_JPRB,2.9943E-05_JPRB/)
KAO( :, 1, 4, 1) = (/&
&4.6419E-07_JPRB,3.2238E-06_JPRB,7.0968E-06_JPRB,1.2172E-05_JPRB,1.6732E-05_JPRB,2.2369E-05_JPRB,&
&3.1463E-05_JPRB,5.3229E-05_JPRB,1.7381E-05_JPRB/)
KAO( :, 2, 4, 1) = (/&
&6.2245E-07_JPRB,3.7726E-06_JPRB,7.2766E-06_JPRB,1.2504E-05_JPRB,1.9255E-05_JPRB,2.8079E-05_JPRB,&
&3.7485E-05_JPRB,5.7403E-05_JPRB,1.9667E-05_JPRB/)
KAO( :, 3, 4, 1) = (/&
&8.3351E-07_JPRB,4.5653E-06_JPRB,8.3036E-06_JPRB,1.2777E-05_JPRB,1.8816E-05_JPRB,2.9030E-05_JPRB,&
&4.4417E-05_JPRB,7.0863E-05_JPRB,2.1895E-05_JPRB/)
KAO( :, 4, 4, 1) = (/&
&1.1087E-06_JPRB,5.6384E-06_JPRB,9.6405E-06_JPRB,1.4565E-05_JPRB,2.0321E-05_JPRB,2.8264E-05_JPRB,&
&4.3444E-05_JPRB,7.7444E-05_JPRB,2.1414E-05_JPRB/)
KAO( :, 5, 4, 1) = (/&
&1.4581E-06_JPRB,7.0726E-06_JPRB,1.1402E-05_JPRB,1.6579E-05_JPRB,2.3011E-05_JPRB,3.1009E-05_JPRB,&
&4.3245E-05_JPRB,7.3708E-05_JPRB,2.2863E-05_JPRB/)
KAO( :, 1, 5, 1) = (/&
&3.3427E-07_JPRB,2.5337E-06_JPRB,5.7680E-06_JPRB,8.9425E-06_JPRB,1.2242E-05_JPRB,1.6995E-05_JPRB,&
&2.4164E-05_JPRB,4.4230E-05_JPRB,1.3422E-05_JPRB/)
KAO( :, 2, 5, 1) = (/&
&4.4601E-07_JPRB,2.8401E-06_JPRB,5.8531E-06_JPRB,1.0220E-05_JPRB,1.5419E-05_JPRB,2.0153E-05_JPRB,&
&2.7336E-05_JPRB,4.3727E-05_JPRB,1.5115E-05_JPRB/)
KAO( :, 3, 5, 1) = (/&
&5.9812E-07_JPRB,3.3532E-06_JPRB,6.3191E-06_JPRB,1.0031E-05_JPRB,1.5953E-05_JPRB,2.3950E-05_JPRB,&
&3.4195E-05_JPRB,5.0601E-05_JPRB,1.6591E-05_JPRB/)
KAO( :, 4, 5, 1) = (/&
&7.9837E-07_JPRB,4.1280E-06_JPRB,7.3147E-06_JPRB,1.1079E-05_JPRB,1.5854E-05_JPRB,2.3810E-05_JPRB,&
&3.6514E-05_JPRB,6.2591E-05_JPRB,1.7658E-05_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.0575E-06_JPRB,5.1440E-06_JPRB,8.5910E-06_JPRB,1.2709E-05_JPRB,1.7592E-05_JPRB,2.4262E-05_JPRB,&
&3.5276E-05_JPRB,6.2368E-05_JPRB,1.9388E-05_JPRB/)
KAO( :, 1, 6, 1) = (/&
&2.4467E-07_JPRB,2.0115E-06_JPRB,4.4506E-06_JPRB,6.5328E-06_JPRB,9.2134E-06_JPRB,1.2867E-05_JPRB,&
&1.9266E-05_JPRB,3.4226E-05_JPRB,1.1020E-05_JPRB/)
KAO( :, 2, 6, 1) = (/&
&3.2244E-07_JPRB,2.1802E-06_JPRB,4.7859E-06_JPRB,8.3031E-06_JPRB,1.1024E-05_JPRB,1.4816E-05_JPRB,&
&2.0767E-05_JPRB,3.3867E-05_JPRB,1.2361E-05_JPRB/)
KAO( :, 3, 6, 1) = (/&
&4.3252E-07_JPRB,2.5034E-06_JPRB,4.8788E-06_JPRB,8.5188E-06_JPRB,1.3353E-05_JPRB,1.8353E-05_JPRB,&
&2.4440E-05_JPRB,3.7220E-05_JPRB,1.3756E-05_JPRB/)
KAO( :, 4, 6, 1) = (/&
&5.7866E-07_JPRB,3.0227E-06_JPRB,5.4901E-06_JPRB,8.5441E-06_JPRB,1.3294E-05_JPRB,1.9970E-05_JPRB,&
&3.0079E-05_JPRB,4.5487E-05_JPRB,1.5370E-05_JPRB/)
KAO( :, 5, 6, 1) = (/&
&7.6960E-07_JPRB,3.7504E-06_JPRB,6.3767E-06_JPRB,9.6311E-06_JPRB,1.3563E-05_JPRB,1.9464E-05_JPRB,&
&3.0023E-05_JPRB,5.3031E-05_JPRB,1.7349E-05_JPRB/)
KAO( :, 1, 7, 1) = (/&
&1.8363E-07_JPRB,1.6339E-06_JPRB,3.2365E-06_JPRB,4.8736E-06_JPRB,7.0565E-06_JPRB,1.0168E-05_JPRB,&
&1.5448E-05_JPRB,2.6119E-05_JPRB,9.9973E-06_JPRB/)
KAO( :, 2, 7, 1) = (/&
&2.3828E-07_JPRB,1.7045E-06_JPRB,3.9446E-06_JPRB,5.9885E-06_JPRB,8.1187E-06_JPRB,1.1164E-05_JPRB,&
&1.5910E-05_JPRB,2.7804E-05_JPRB,1.1252E-05_JPRB/)
KAO( :, 3, 7, 1) = (/&
&3.1712E-07_JPRB,1.8915E-06_JPRB,4.0133E-06_JPRB,6.9371E-06_JPRB,1.0184E-05_JPRB,1.3247E-05_JPRB,&
&1.8144E-05_JPRB,2.8687E-05_JPRB,1.2767E-05_JPRB/)
KAO( :, 4, 7, 1) = (/&
&4.2549E-07_JPRB,2.2415E-06_JPRB,4.2001E-06_JPRB,7.0066E-06_JPRB,1.0950E-05_JPRB,1.6323E-05_JPRB,&
&2.2218E-05_JPRB,3.2987E-05_JPRB,1.4591E-05_JPRB/)
KAO( :, 5, 7, 1) = (/&
&5.6782E-07_JPRB,2.7608E-06_JPRB,4.8541E-06_JPRB,7.3705E-06_JPRB,1.0748E-05_JPRB,1.6390E-05_JPRB,&
&2.5035E-05_JPRB,4.1583E-05_JPRB,1.6759E-05_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.4297E-07_JPRB,1.2986E-06_JPRB,2.4296E-06_JPRB,3.7740E-06_JPRB,5.5717E-06_JPRB,8.1007E-06_JPRB,&
&1.2269E-05_JPRB,2.0668E-05_JPRB,1.1224E-05_JPRB/)
KAO( :, 2, 8, 1) = (/&
&1.8237E-07_JPRB,1.3796E-06_JPRB,2.9841E-06_JPRB,4.4232E-06_JPRB,6.1625E-06_JPRB,8.6070E-06_JPRB,&
&1.2749E-05_JPRB,2.2374E-05_JPRB,1.3050E-05_JPRB/)
KAO( :, 3, 8, 1) = (/&
&2.3995E-07_JPRB,1.4828E-06_JPRB,3.2302E-06_JPRB,5.5721E-06_JPRB,7.4009E-06_JPRB,9.9584E-06_JPRB,&
&1.3793E-05_JPRB,2.2720E-05_JPRB,1.5037E-05_JPRB/)
KAO( :, 4, 8, 1) = (/&
&3.2109E-07_JPRB,1.7086E-06_JPRB,3.3052E-06_JPRB,5.7552E-06_JPRB,9.1163E-06_JPRB,1.2137E-05_JPRB,&
&1.6200E-05_JPRB,2.4932E-05_JPRB,1.7316E-05_JPRB/)
KAO( :, 5, 8, 1) = (/&
&4.2933E-07_JPRB,2.0665E-06_JPRB,3.6851E-06_JPRB,5.7093E-06_JPRB,9.1231E-06_JPRB,1.3616E-05_JPRB,&
&2.0240E-05_JPRB,2.9795E-05_JPRB,1.9811E-05_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.1391E-07_JPRB,9.6607E-07_JPRB,1.8596E-06_JPRB,2.9960E-06_JPRB,4.4278E-06_JPRB,6.4496E-06_JPRB,&
&9.3668E-06_JPRB,1.6296E-05_JPRB,2.3175E-05_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.4318E-07_JPRB,1.1432E-06_JPRB,2.1917E-06_JPRB,3.3465E-06_JPRB,4.7894E-06_JPRB,6.8583E-06_JPRB,&
&1.0124E-05_JPRB,1.7732E-05_JPRB,2.8424E-05_JPRB/)
KAO( :, 3, 9, 1) = (/&
&1.8594E-07_JPRB,1.1885E-06_JPRB,2.6962E-06_JPRB,4.0343E-06_JPRB,5.5351E-06_JPRB,7.5514E-06_JPRB,&
&1.0675E-05_JPRB,1.8150E-05_JPRB,3.4053E-05_JPRB/)
KAO( :, 4, 9, 1) = (/&
&2.4670E-07_JPRB,1.3380E-06_JPRB,2.7503E-06_JPRB,4.7549E-06_JPRB,6.8876E-06_JPRB,8.9087E-06_JPRB,&
&1.2295E-05_JPRB,1.9210E-05_JPRB,3.9839E-05_JPRB/)
KAO( :, 5, 9, 1) = (/&
&3.3010E-07_JPRB,1.5784E-06_JPRB,2.8513E-06_JPRB,4.8049E-06_JPRB,7.4827E-06_JPRB,1.1096E-05_JPRB,&
&1.4749E-05_JPRB,2.1955E-05_JPRB,4.5594E-05_JPRB/)
KAO( :, 1,10, 1) = (/&
&9.5530E-08_JPRB,7.6103E-07_JPRB,1.4822E-06_JPRB,2.4013E-06_JPRB,3.5241E-06_JPRB,5.0863E-06_JPRB,&
&7.7041E-06_JPRB,1.2423E-05_JPRB,8.9067E-05_JPRB/)
KAO( :, 2,10, 1) = (/&
&1.1882E-07_JPRB,9.2450E-07_JPRB,1.6979E-06_JPRB,2.6207E-06_JPRB,3.8503E-06_JPRB,5.4657E-06_JPRB,&
&7.9684E-06_JPRB,1.3651E-05_JPRB,1.1125E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.5289E-07_JPRB,9.7942E-07_JPRB,2.0846E-06_JPRB,3.0524E-06_JPRB,4.2640E-06_JPRB,5.9216E-06_JPRB,&
&8.6666E-06_JPRB,1.4411E-05_JPRB,1.3376E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&2.0094E-07_JPRB,1.0816E-06_JPRB,2.2331E-06_JPRB,3.8855E-06_JPRB,5.1239E-06_JPRB,6.8144E-06_JPRB,&
&9.5102E-06_JPRB,1.5396E-05_JPRB,1.5621E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&2.6711E-07_JPRB,1.2572E-06_JPRB,2.3283E-06_JPRB,3.9502E-06_JPRB,6.1703E-06_JPRB,8.4471E-06_JPRB,&
&1.1047E-05_JPRB,1.7057E-05_JPRB,1.7815E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&8.8479E-08_JPRB,6.5723E-07_JPRB,1.2585E-06_JPRB,2.0039E-06_JPRB,2.9121E-06_JPRB,4.1955E-06_JPRB,&
&6.2637E-06_JPRB,1.0419E-05_JPRB,1.7219E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&1.1103E-07_JPRB,7.9724E-07_JPRB,1.4388E-06_JPRB,2.1938E-06_JPRB,3.2099E-06_JPRB,4.5380E-06_JPRB,&
&6.5334E-06_JPRB,1.1529E-05_JPRB,2.1393E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&1.4325E-07_JPRB,8.5009E-07_JPRB,1.7790E-06_JPRB,2.5762E-06_JPRB,3.5853E-06_JPRB,4.9027E-06_JPRB,&
&7.2087E-06_JPRB,1.1783E-05_JPRB,2.5548E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&1.8796E-07_JPRB,9.4910E-07_JPRB,1.8794E-06_JPRB,3.2448E-06_JPRB,4.3096E-06_JPRB,5.7004E-06_JPRB,&
&7.8146E-06_JPRB,1.2759E-05_JPRB,2.9570E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&2.4830E-07_JPRB,1.0997E-06_JPRB,1.9987E-06_JPRB,3.2788E-06_JPRB,5.0983E-06_JPRB,7.0948E-06_JPRB,&
&9.2185E-06_JPRB,1.4157E-05_JPRB,3.3417E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&7.8411E-08_JPRB,5.6432E-07_JPRB,1.0564E-06_JPRB,1.6792E-06_JPRB,2.4262E-06_JPRB,3.3875E-06_JPRB,&
&5.1824E-06_JPRB,8.5930E-06_JPRB,2.1970E-04_JPRB/)
KAO( :, 2,12, 1) = (/&
&9.8958E-08_JPRB,6.8328E-07_JPRB,1.2215E-06_JPRB,1.8350E-06_JPRB,2.6716E-06_JPRB,3.7787E-06_JPRB,&
&5.3849E-06_JPRB,9.1860E-06_JPRB,2.7209E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&1.2797E-07_JPRB,7.2421E-07_JPRB,1.5209E-06_JPRB,2.1711E-06_JPRB,3.0040E-06_JPRB,4.0829E-06_JPRB,&
&6.0229E-06_JPRB,9.7068E-06_JPRB,3.2380E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&1.6772E-07_JPRB,8.1500E-07_JPRB,1.5843E-06_JPRB,2.7212E-06_JPRB,3.6141E-06_JPRB,4.7595E-06_JPRB,&
&6.4840E-06_JPRB,1.0629E-05_JPRB,3.7332E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&2.2081E-07_JPRB,9.4887E-07_JPRB,1.7061E-06_JPRB,2.7338E-06_JPRB,4.2409E-06_JPRB,5.9628E-06_JPRB,&
&7.7123E-06_JPRB,1.1668E-05_JPRB,4.2006E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&6.9984E-08_JPRB,4.8746E-07_JPRB,8.9934E-07_JPRB,1.4101E-06_JPRB,2.0188E-06_JPRB,2.7991E-06_JPRB,&
&4.1521E-06_JPRB,7.2727E-06_JPRB,2.2865E-04_JPRB/)
KAO( :, 2,13, 1) = (/&
&8.8821E-08_JPRB,5.8672E-07_JPRB,1.0421E-06_JPRB,1.5517E-06_JPRB,2.2340E-06_JPRB,3.1346E-06_JPRB,&
&4.4727E-06_JPRB,7.4604E-06_JPRB,2.8267E-04_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.1504E-07_JPRB,6.2137E-07_JPRB,1.3015E-06_JPRB,1.8350E-06_JPRB,2.5305E-06_JPRB,3.4076E-06_JPRB,&
&4.9426E-06_JPRB,8.0265E-06_JPRB,3.3576E-04_JPRB/)
KAO( :, 4,13, 1) = (/&
&1.5036E-07_JPRB,7.0084E-07_JPRB,1.3483E-06_JPRB,2.2875E-06_JPRB,3.0337E-06_JPRB,3.9839E-06_JPRB,&
&5.4210E-06_JPRB,8.7755E-06_JPRB,3.8637E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&1.9712E-07_JPRB,8.1525E-07_JPRB,1.4451E-06_JPRB,2.3051E-06_JPRB,3.5032E-06_JPRB,5.0029E-06_JPRB,&
&6.4407E-06_JPRB,9.6564E-06_JPRB,4.3385E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&3.7010E-06_JPRB,1.8091E-05_JPRB,2.8711E-05_JPRB,4.8863E-05_JPRB,7.2307E-05_JPRB,1.1413E-04_JPRB,&
&1.8771E-04_JPRB,3.6122E-04_JPRB,1.1281E-04_JPRB/)
KAO( :, 2, 1, 2) = (/&
&5.3266E-06_JPRB,2.4423E-05_JPRB,3.4269E-05_JPRB,4.7704E-05_JPRB,7.6078E-05_JPRB,1.1442E-04_JPRB,&
&1.6436E-04_JPRB,3.2838E-04_JPRB,8.7847E-05_JPRB/)
KAO( :, 3, 1, 2) = (/&
&7.5177E-06_JPRB,3.2854E-05_JPRB,4.4289E-05_JPRB,5.4913E-05_JPRB,7.2779E-05_JPRB,1.0814E-04_JPRB,&
&1.7906E-04_JPRB,2.8467E-04_JPRB,8.6883E-05_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.0391E-05_JPRB,4.3522E-05_JPRB,5.8544E-05_JPRB,6.9693E-05_JPRB,8.1288E-05_JPRB,1.0220E-04_JPRB,&
&1.5047E-04_JPRB,3.0285E-04_JPRB,9.1049E-05_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.4024E-05_JPRB,5.6758E-05_JPRB,7.6016E-05_JPRB,9.1662E-05_JPRB,1.0372E-04_JPRB,1.1700E-04_JPRB,&
&1.4991E-04_JPRB,2.3704E-04_JPRB,1.3000E-04_JPRB/)
KAO( :, 1, 2, 2) = (/&
&2.7903E-06_JPRB,1.3902E-05_JPRB,2.3771E-05_JPRB,3.9190E-05_JPRB,6.1137E-05_JPRB,9.7231E-05_JPRB,&
&1.5250E-04_JPRB,2.8746E-04_JPRB,7.5943E-05_JPRB/)
KAO( :, 2, 2, 2) = (/&
&4.0561E-06_JPRB,1.8720E-05_JPRB,2.7225E-05_JPRB,3.9741E-05_JPRB,6.4537E-05_JPRB,9.0899E-05_JPRB,&
&1.4609E-04_JPRB,2.7008E-04_JPRB,6.2612E-05_JPRB/)
KAO( :, 3, 2, 2) = (/&
&5.7887E-06_JPRB,2.5353E-05_JPRB,3.4446E-05_JPRB,4.3750E-05_JPRB,5.8352E-05_JPRB,9.7668E-05_JPRB,&
&1.4210E-04_JPRB,2.4211E-04_JPRB,6.1269E-05_JPRB/)
KAO( :, 4, 2, 2) = (/&
&8.0784E-06_JPRB,3.3950E-05_JPRB,4.5325E-05_JPRB,5.3921E-05_JPRB,6.4280E-05_JPRB,8.5665E-05_JPRB,&
&1.3688E-04_JPRB,2.4556E-04_JPRB,6.9568E-05_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.1019E-05_JPRB,4.4672E-05_JPRB,5.9575E-05_JPRB,7.1166E-05_JPRB,7.9595E-05_JPRB,9.1088E-05_JPRB,&
&1.2520E-04_JPRB,2.1802E-04_JPRB,9.5557E-05_JPRB/)
KAO( :, 1, 3, 2) = (/&
&1.9479E-06_JPRB,1.0095E-05_JPRB,1.9141E-05_JPRB,3.0705E-05_JPRB,5.2363E-05_JPRB,7.9991E-05_JPRB,&
&1.2823E-04_JPRB,2.3806E-04_JPRB,4.6992E-05_JPRB/)
KAO( :, 2, 3, 2) = (/&
&2.8509E-06_JPRB,1.3413E-05_JPRB,2.1137E-05_JPRB,3.4101E-05_JPRB,4.9706E-05_JPRB,7.8708E-05_JPRB,&
&1.2808E-04_JPRB,2.2769E-04_JPRB,4.2012E-05_JPRB/)
KAO( :, 3, 3, 2) = (/&
&4.1189E-06_JPRB,1.8265E-05_JPRB,2.5419E-05_JPRB,3.4683E-05_JPRB,5.2513E-05_JPRB,8.0240E-05_JPRB,&
&1.1481E-04_JPRB,2.1816E-04_JPRB,4.3174E-05_JPRB/)
KAO( :, 4, 3, 2) = (/&
&5.8233E-06_JPRB,2.4801E-05_JPRB,3.3200E-05_JPRB,4.0180E-05_JPRB,5.1786E-05_JPRB,7.2468E-05_JPRB,&
&1.2549E-04_JPRB,1.9856E-04_JPRB,5.6282E-05_JPRB/)
KAO( :, 5, 3, 2) = (/&
&8.0612E-06_JPRB,3.3094E-05_JPRB,4.4191E-05_JPRB,5.1801E-05_JPRB,5.9300E-05_JPRB,7.2075E-05_JPRB,&
&1.0386E-04_JPRB,2.0859E-04_JPRB,6.8039E-05_JPRB/)
KAO( :, 1, 4, 2) = (/&
&1.3432E-06_JPRB,7.4538E-06_JPRB,1.4964E-05_JPRB,2.5625E-05_JPRB,4.3243E-05_JPRB,6.6019E-05_JPRB,&
&1.0530E-04_JPRB,1.9952E-04_JPRB,3.1575E-05_JPRB/)
KAO( :, 2, 4, 2) = (/&
&1.9591E-06_JPRB,9.5155E-06_JPRB,1.6737E-05_JPRB,2.6791E-05_JPRB,4.2345E-05_JPRB,6.7439E-05_JPRB,&
&1.0271E-04_JPRB,1.8871E-04_JPRB,3.0704E-05_JPRB/)
KAO( :, 3, 4, 2) = (/&
&2.8537E-06_JPRB,1.2845E-05_JPRB,1.8934E-05_JPRB,2.8752E-05_JPRB,4.4199E-05_JPRB,6.2430E-05_JPRB,&
&1.0202E-04_JPRB,1.8062E-04_JPRB,3.4088E-05_JPRB/)
KAO( :, 4, 4, 2) = (/&
&4.0888E-06_JPRB,1.7612E-05_JPRB,2.3922E-05_JPRB,3.0749E-05_JPRB,4.2010E-05_JPRB,6.5728E-05_JPRB,&
&9.6566E-05_JPRB,1.7460E-04_JPRB,4.3387E-05_JPRB/)
KAO( :, 5, 4, 2) = (/&
&5.7388E-06_JPRB,2.3829E-05_JPRB,3.1758E-05_JPRB,3.7789E-05_JPRB,4.5312E-05_JPRB,5.9095E-05_JPRB,&
&1.0064E-04_JPRB,1.6850E-04_JPRB,5.1079E-05_JPRB/)
KAO( :, 1, 5, 2) = (/&
&9.4882E-07_JPRB,5.7155E-06_JPRB,1.1980E-05_JPRB,2.2295E-05_JPRB,3.5116E-05_JPRB,5.3339E-05_JPRB,&
&8.8729E-05_JPRB,1.5937E-04_JPRB,2.5456E-05_JPRB/)
KAO( :, 2, 5, 2) = (/&
&1.3669E-06_JPRB,6.8739E-06_JPRB,1.3459E-05_JPRB,2.1396E-05_JPRB,3.6297E-05_JPRB,5.4282E-05_JPRB,&
&8.6042E-05_JPRB,1.6025E-04_JPRB,2.6654E-05_JPRB/)
KAO( :, 3, 5, 2) = (/&
&1.9884E-06_JPRB,9.0859E-06_JPRB,1.4605E-05_JPRB,2.3671E-05_JPRB,3.4093E-05_JPRB,5.5324E-05_JPRB,&
&8.6463E-05_JPRB,1.5363E-04_JPRB,3.0684E-05_JPRB/)
KAO( :, 4, 5, 2) = (/&
&2.8701E-06_JPRB,1.2430E-05_JPRB,1.7294E-05_JPRB,2.4580E-05_JPRB,3.7203E-05_JPRB,5.3154E-05_JPRB,&
&8.1963E-05_JPRB,1.5281E-04_JPRB,3.6321E-05_JPRB/)
KAO( :, 5, 5, 2) = (/&
&4.0709E-06_JPRB,1.7029E-05_JPRB,2.2743E-05_JPRB,2.7902E-05_JPRB,3.6353E-05_JPRB,5.3115E-05_JPRB,&
&8.4864E-05_JPRB,1.3732E-04_JPRB,4.2547E-05_JPRB/)
KAO( :, 1, 6, 2) = (/&
&6.8988E-07_JPRB,4.4652E-06_JPRB,9.7580E-06_JPRB,1.7678E-05_JPRB,2.8332E-05_JPRB,4.4145E-05_JPRB,&
&7.0109E-05_JPRB,1.2493E-04_JPRB,2.3716E-05_JPRB/)
KAO( :, 2, 6, 2) = (/&
&9.7314E-07_JPRB,5.0974E-06_JPRB,1.0412E-05_JPRB,1.7485E-05_JPRB,2.9376E-05_JPRB,4.4804E-05_JPRB,&
&7.0122E-05_JPRB,1.3276E-04_JPRB,2.6375E-05_JPRB/)
KAO( :, 3, 6, 2) = (/&
&1.3972E-06_JPRB,6.4724E-06_JPRB,1.1564E-05_JPRB,1.8858E-05_JPRB,2.8568E-05_JPRB,4.7043E-05_JPRB,&
&7.0202E-05_JPRB,1.2748E-04_JPRB,3.0169E-05_JPRB/)
KAO( :, 4, 6, 2) = (/&
&2.0156E-06_JPRB,8.7063E-06_JPRB,1.3025E-05_JPRB,2.0355E-05_JPRB,3.0069E-05_JPRB,4.4240E-05_JPRB,&
&7.1336E-05_JPRB,1.2324E-04_JPRB,3.4994E-05_JPRB/)
KAO( :, 5, 6, 2) = (/&
&2.8756E-06_JPRB,1.1976E-05_JPRB,1.6242E-05_JPRB,2.1147E-05_JPRB,3.0629E-05_JPRB,4.5526E-05_JPRB,&
&6.5474E-05_JPRB,1.2130E-04_JPRB,4.0495E-05_JPRB/)
KAO( :, 1, 7, 2) = (/&
&5.2255E-07_JPRB,3.4411E-06_JPRB,7.7789E-06_JPRB,1.4395E-05_JPRB,2.2965E-05_JPRB,3.5662E-05_JPRB,&
&5.5652E-05_JPRB,9.9078E-05_JPRB,2.5677E-05_JPRB/)
KAO( :, 2, 7, 2) = (/&
&7.2172E-07_JPRB,4.0179E-06_JPRB,8.3376E-06_JPRB,1.4853E-05_JPRB,2.4331E-05_JPRB,3.6364E-05_JPRB,&
&5.7791E-05_JPRB,1.0563E-04_JPRB,2.9556E-05_JPRB/)
KAO( :, 3, 7, 2) = (/&
&1.0201E-06_JPRB,4.7217E-06_JPRB,9.3095E-06_JPRB,1.5083E-05_JPRB,2.5365E-05_JPRB,3.7347E-05_JPRB,&
&5.8190E-05_JPRB,1.0603E-04_JPRB,3.3998E-05_JPRB/)
KAO( :, 4, 7, 2) = (/&
&1.4537E-06_JPRB,6.1748E-06_JPRB,1.0020E-05_JPRB,1.6138E-05_JPRB,2.3962E-05_JPRB,3.7967E-05_JPRB,&
&5.8451E-05_JPRB,1.0372E-04_JPRB,3.9119E-05_JPRB/)
KAO( :, 5, 7, 2) = (/&
&2.0693E-06_JPRB,8.4363E-06_JPRB,1.1705E-05_JPRB,1.7001E-05_JPRB,2.5826E-05_JPRB,3.5527E-05_JPRB,&
&5.8296E-05_JPRB,1.0385E-04_JPRB,4.4936E-05_JPRB/)
KAO( :, 1, 8, 2) = (/&
&4.1700E-07_JPRB,2.7639E-06_JPRB,6.4938E-06_JPRB,1.1630E-05_JPRB,1.8371E-05_JPRB,2.7706E-05_JPRB,&
&4.4850E-05_JPRB,8.0696E-05_JPRB,3.5956E-05_JPRB/)
KAO( :, 2, 8, 2) = (/&
&5.6411E-07_JPRB,3.1556E-06_JPRB,6.9457E-06_JPRB,1.2120E-05_JPRB,1.9397E-05_JPRB,2.9581E-05_JPRB,&
&4.6513E-05_JPRB,8.4727E-05_JPRB,4.2511E-05_JPRB/)
KAO( :, 3, 8, 2) = (/&
&7.8647E-07_JPRB,3.6535E-06_JPRB,7.3255E-06_JPRB,1.2353E-05_JPRB,2.0079E-05_JPRB,3.0844E-05_JPRB,&
&4.7401E-05_JPRB,8.6525E-05_JPRB,4.9724E-05_JPRB/)
KAO( :, 4, 8, 2) = (/&
&1.1061E-06_JPRB,4.5424E-06_JPRB,7.9917E-06_JPRB,1.3185E-05_JPRB,1.9791E-05_JPRB,3.2038E-05_JPRB,&
&4.8054E-05_JPRB,8.5457E-05_JPRB,5.7233E-05_JPRB/)
KAO( :, 5, 8, 2) = (/&
&1.5569E-06_JPRB,6.0599E-06_JPRB,9.0209E-06_JPRB,1.3990E-05_JPRB,2.0815E-05_JPRB,3.0475E-05_JPRB,&
&4.9899E-05_JPRB,8.4659E-05_JPRB,6.5356E-05_JPRB/)
KAO( :, 1, 9, 2) = (/&
&3.4646E-07_JPRB,2.3339E-06_JPRB,5.2376E-06_JPRB,9.2182E-06_JPRB,1.4337E-05_JPRB,2.2490E-05_JPRB,&
&3.6396E-05_JPRB,6.1412E-05_JPRB,1.0490E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&4.5919E-07_JPRB,2.4585E-06_JPRB,5.5676E-06_JPRB,9.8533E-06_JPRB,1.5559E-05_JPRB,2.3683E-05_JPRB,&
&3.6999E-05_JPRB,7.0677E-05_JPRB,1.2405E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&6.2898E-07_JPRB,2.9262E-06_JPRB,5.8022E-06_JPRB,1.0344E-05_JPRB,1.6840E-05_JPRB,2.4691E-05_JPRB,&
&3.8818E-05_JPRB,7.0031E-05_JPRB,1.4290E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&8.7625E-07_JPRB,3.4474E-06_JPRB,6.4904E-06_JPRB,1.0589E-05_JPRB,1.7378E-05_JPRB,2.5849E-05_JPRB,&
&3.9400E-05_JPRB,7.0716E-05_JPRB,1.6112E-04_JPRB/)
KAO( :, 5, 9, 2) = (/&
&1.2209E-06_JPRB,4.4922E-06_JPRB,7.0958E-06_JPRB,1.1298E-05_JPRB,1.6936E-05_JPRB,2.6020E-05_JPRB,&
&4.0325E-05_JPRB,7.2083E-05_JPRB,1.7893E-04_JPRB/)
KAO( :, 1,10, 2) = (/&
&3.1214E-07_JPRB,1.9536E-06_JPRB,4.2576E-06_JPRB,7.3396E-06_JPRB,1.1621E-05_JPRB,1.8021E-05_JPRB,&
&2.8013E-05_JPRB,4.7749E-05_JPRB,4.9962E-04_JPRB/)
KAO( :, 2,10, 2) = (/&
&4.0887E-07_JPRB,2.0598E-06_JPRB,4.7149E-06_JPRB,8.0606E-06_JPRB,1.2573E-05_JPRB,1.8809E-05_JPRB,&
&3.0275E-05_JPRB,5.6188E-05_JPRB,5.8548E-04_JPRB/)
KAO( :, 3,10, 2) = (/&
&5.5155E-07_JPRB,2.4175E-06_JPRB,4.9545E-06_JPRB,8.5941E-06_JPRB,1.3457E-05_JPRB,2.0204E-05_JPRB,&
&3.1138E-05_JPRB,5.6286E-05_JPRB,6.6291E-04_JPRB/)
KAO( :, 4,10, 2) = (/&
&7.5650E-07_JPRB,2.8298E-06_JPRB,5.3256E-06_JPRB,8.7402E-06_JPRB,1.3978E-05_JPRB,2.1601E-05_JPRB,&
&3.2082E-05_JPRB,5.7693E-05_JPRB,7.2972E-04_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.0427E-06_JPRB,3.5400E-06_JPRB,5.8501E-06_JPRB,9.4137E-06_JPRB,1.4055E-05_JPRB,2.2092E-05_JPRB,&
&3.3371E-05_JPRB,5.7680E-05_JPRB,7.8611E-04_JPRB/)
KAO( :, 1,11, 2) = (/&
&3.2074E-07_JPRB,1.7276E-06_JPRB,3.6239E-06_JPRB,6.1854E-06_JPRB,9.6607E-06_JPRB,1.4993E-05_JPRB,&
&2.3443E-05_JPRB,4.1061E-05_JPRB,1.0142E-03_JPRB/)
KAO( :, 2,11, 2) = (/&
&4.2113E-07_JPRB,1.8116E-06_JPRB,4.1199E-06_JPRB,6.7716E-06_JPRB,1.0543E-05_JPRB,1.5526E-05_JPRB,&
&2.4849E-05_JPRB,4.5454E-05_JPRB,1.1742E-03_JPRB/)
KAO( :, 3,11, 2) = (/&
&5.6514E-07_JPRB,2.1552E-06_JPRB,4.2148E-06_JPRB,7.3585E-06_JPRB,1.1239E-05_JPRB,1.6846E-05_JPRB,&
&2.5655E-05_JPRB,4.5531E-05_JPRB,1.3139E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&7.6814E-07_JPRB,2.5322E-06_JPRB,4.6852E-06_JPRB,7.3538E-06_JPRB,1.1830E-05_JPRB,1.8155E-05_JPRB,&
&2.6824E-05_JPRB,4.7139E-05_JPRB,1.4305E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.0464E-06_JPRB,3.2313E-06_JPRB,5.0889E-06_JPRB,8.1260E-06_JPRB,1.1741E-05_JPRB,1.8567E-05_JPRB,&
&2.7673E-05_JPRB,4.7684E-05_JPRB,1.5261E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&3.0483E-07_JPRB,1.4986E-06_JPRB,3.1036E-06_JPRB,5.2551E-06_JPRB,7.9883E-06_JPRB,1.2411E-05_JPRB,&
&1.9208E-05_JPRB,3.3894E-05_JPRB,1.3243E-03_JPRB/)
KAO( :, 2,12, 2) = (/&
&4.0026E-07_JPRB,1.5746E-06_JPRB,3.5034E-06_JPRB,5.7409E-06_JPRB,8.9248E-06_JPRB,1.2928E-05_JPRB,&
&2.0014E-05_JPRB,3.7406E-05_JPRB,1.5202E-03_JPRB/)
KAO( :, 3,12, 2) = (/&
&5.3553E-07_JPRB,1.8879E-06_JPRB,3.5598E-06_JPRB,6.2204E-06_JPRB,9.4506E-06_JPRB,1.4131E-05_JPRB,&
&2.1193E-05_JPRB,3.7290E-05_JPRB,1.6892E-03_JPRB/)
KAO( :, 4,12, 2) = (/&
&7.2441E-07_JPRB,2.2261E-06_JPRB,4.0611E-06_JPRB,6.2008E-06_JPRB,9.9865E-06_JPRB,1.4941E-05_JPRB,&
&2.2423E-05_JPRB,3.8766E-05_JPRB,1.8301E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&9.8233E-07_JPRB,2.8782E-06_JPRB,4.3585E-06_JPRB,6.9707E-06_JPRB,9.7990E-06_JPRB,1.5463E-05_JPRB,&
&2.2949E-05_JPRB,3.9658E-05_JPRB,1.9441E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&2.9003E-07_JPRB,1.3003E-06_JPRB,2.6851E-06_JPRB,4.4901E-06_JPRB,6.6847E-06_JPRB,1.0336E-05_JPRB,&
&1.6084E-05_JPRB,2.8206E-05_JPRB,1.3971E-03_JPRB/)
KAO( :, 2,13, 2) = (/&
&3.7990E-07_JPRB,1.3887E-06_JPRB,2.9888E-06_JPRB,4.8895E-06_JPRB,7.4887E-06_JPRB,1.0848E-05_JPRB,&
&1.6497E-05_JPRB,3.0927E-05_JPRB,1.5951E-03_JPRB/)
KAO( :, 3,13, 2) = (/&
&5.0572E-07_JPRB,1.6533E-06_JPRB,3.0166E-06_JPRB,5.2825E-06_JPRB,8.0084E-06_JPRB,1.1877E-05_JPRB,&
&1.7766E-05_JPRB,3.0474E-05_JPRB,1.7653E-03_JPRB/)
KAO( :, 4,13, 2) = (/&
&6.7947E-07_JPRB,1.9700E-06_JPRB,3.4410E-06_JPRB,5.2325E-06_JPRB,8.4395E-06_JPRB,1.2460E-05_JPRB,&
&1.8625E-05_JPRB,3.2158E-05_JPRB,1.9067E-03_JPRB/)
KAO( :, 5,13, 2) = (/&
&9.1576E-07_JPRB,2.5777E-06_JPRB,3.7459E-06_JPRB,5.9026E-06_JPRB,8.2962E-06_JPRB,1.2772E-05_JPRB,&
&1.8972E-05_JPRB,3.2948E-05_JPRB,2.0202E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&1.2955E-05_JPRB,5.0522E-05_JPRB,7.1945E-05_JPRB,8.6154E-05_JPRB,1.0208E-04_JPRB,1.2598E-04_JPRB,&
&1.9123E-04_JPRB,3.6418E-04_JPRB,1.3186E-04_JPRB/)
KAO( :, 2, 1, 3) = (/&
&1.9287E-05_JPRB,7.0010E-05_JPRB,9.9593E-05_JPRB,1.2286E-04_JPRB,1.3525E-04_JPRB,1.5548E-04_JPRB,&
&2.0918E-04_JPRB,3.4739E-04_JPRB,1.7322E-04_JPRB/)
KAO( :, 3, 1, 3) = (/&
&2.7759E-05_JPRB,9.4510E-05_JPRB,1.3259E-04_JPRB,1.6366E-04_JPRB,1.8879E-04_JPRB,2.0943E-04_JPRB,&
&2.3157E-04_JPRB,3.4811E-04_JPRB,1.6150E-04_JPRB/)
KAO( :, 4, 1, 3) = (/&
&3.8738E-05_JPRB,1.2422E-04_JPRB,1.7221E-04_JPRB,2.0992E-04_JPRB,2.4272E-04_JPRB,2.7453E-04_JPRB,&
&3.1488E-04_JPRB,3.8180E-04_JPRB,1.6247E-04_JPRB/)
KAO( :, 5, 1, 3) = (/&
&5.2551E-05_JPRB,1.5948E-04_JPRB,2.1800E-04_JPRB,2.6091E-04_JPRB,2.8985E-04_JPRB,3.1670E-04_JPRB,&
&3.5730E-04_JPRB,5.0275E-04_JPRB,1.6769E-04_JPRB/)
KAO( :, 1, 2, 3) = (/&
&1.0215E-05_JPRB,3.8380E-05_JPRB,5.3048E-05_JPRB,6.6381E-05_JPRB,7.9446E-05_JPRB,1.0242E-04_JPRB,&
&1.6771E-04_JPRB,3.2794E-04_JPRB,9.6316E-05_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.5451E-05_JPRB,5.4104E-05_JPRB,7.5600E-05_JPRB,9.3324E-05_JPRB,1.0289E-04_JPRB,1.2339E-04_JPRB,&
&1.5508E-04_JPRB,2.9561E-04_JPRB,1.1950E-04_JPRB/)
KAO( :, 3, 2, 3) = (/&
&2.2597E-05_JPRB,7.3963E-05_JPRB,1.0253E-04_JPRB,1.2549E-04_JPRB,1.4695E-04_JPRB,1.5501E-04_JPRB,&
&1.8766E-04_JPRB,2.7580E-04_JPRB,1.1963E-04_JPRB/)
KAO( :, 4, 2, 3) = (/&
&3.1981E-05_JPRB,9.8266E-05_JPRB,1.3455E-04_JPRB,1.6363E-04_JPRB,1.9057E-04_JPRB,2.1405E-04_JPRB,&
&2.4009E-04_JPRB,3.0871E-04_JPRB,1.1944E-04_JPRB/)
KAO( :, 5, 2, 3) = (/&
&4.3949E-05_JPRB,1.2724E-04_JPRB,1.7210E-04_JPRB,2.0576E-04_JPRB,2.2967E-04_JPRB,2.5641E-04_JPRB,&
&2.9387E-04_JPRB,3.8545E-04_JPRB,1.2834E-04_JPRB/)
KAO( :, 1, 3, 3) = (/&
&7.2365E-06_JPRB,2.6998E-05_JPRB,3.6477E-05_JPRB,4.7217E-05_JPRB,5.6642E-05_JPRB,8.7936E-05_JPRB,&
&1.4529E-04_JPRB,2.7769E-04_JPRB,6.9628E-05_JPRB/)
KAO( :, 2, 3, 3) = (/&
&1.1199E-05_JPRB,3.9041E-05_JPRB,5.3564E-05_JPRB,6.4272E-05_JPRB,7.6774E-05_JPRB,9.0855E-05_JPRB,&
&1.2382E-04_JPRB,2.6260E-04_JPRB,7.7539E-05_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.6746E-05_JPRB,5.4459E-05_JPRB,7.4537E-05_JPRB,8.9917E-05_JPRB,1.0355E-04_JPRB,1.1572E-04_JPRB,&
&1.4649E-04_JPRB,2.2179E-04_JPRB,7.9988E-05_JPRB/)
KAO( :, 4, 3, 3) = (/&
&2.4191E-05_JPRB,7.3480E-05_JPRB,9.9615E-05_JPRB,1.2140E-04_JPRB,1.3959E-04_JPRB,1.5714E-04_JPRB,&
&1.6549E-04_JPRB,2.4024E-04_JPRB,8.5666E-05_JPRB/)
KAO( :, 5, 3, 3) = (/&
&3.3870E-05_JPRB,9.6615E-05_JPRB,1.2939E-04_JPRB,1.5483E-04_JPRB,1.7605E-04_JPRB,2.0033E-04_JPRB,&
&2.2747E-04_JPRB,2.7100E-04_JPRB,9.7295E-05_JPRB/)
KAO( :, 1, 4, 3) = (/&
&4.9164E-06_JPRB,1.8370E-05_JPRB,2.4721E-05_JPRB,3.3121E-05_JPRB,4.7620E-05_JPRB,7.5266E-05_JPRB,&
&1.2052E-04_JPRB,2.1534E-04_JPRB,5.2534E-05_JPRB/)
KAO( :, 2, 4, 3) = (/&
&7.7659E-06_JPRB,2.7326E-05_JPRB,3.6365E-05_JPRB,4.5331E-05_JPRB,5.4377E-05_JPRB,7.0048E-05_JPRB,&
&1.1606E-04_JPRB,2.2356E-04_JPRB,5.6606E-05_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.1872E-05_JPRB,3.9091E-05_JPRB,5.2753E-05_JPRB,6.2810E-05_JPRB,7.2334E-05_JPRB,8.5510E-05_JPRB,&
&1.0655E-04_JPRB,2.0132E-04_JPRB,6.1013E-05_JPRB/)
KAO( :, 4, 4, 3) = (/&
&1.7537E-05_JPRB,5.3794E-05_JPRB,7.2225E-05_JPRB,8.6566E-05_JPRB,1.0009E-04_JPRB,1.0905E-04_JPRB,&
&1.2927E-04_JPRB,1.7979E-04_JPRB,6.7247E-05_JPRB/)
KAO( :, 5, 4, 3) = (/&
&2.5077E-05_JPRB,7.1949E-05_JPRB,9.5586E-05_JPRB,1.1422E-04_JPRB,1.3046E-04_JPRB,1.4874E-04_JPRB,&
&1.6151E-04_JPRB,2.1004E-04_JPRB,7.8070E-05_JPRB/)
KAO( :, 1, 5, 3) = (/&
&3.3274E-06_JPRB,1.2413E-05_JPRB,1.6893E-05_JPRB,2.5297E-05_JPRB,3.9702E-05_JPRB,6.2471E-05_JPRB,&
&9.4799E-05_JPRB,1.7379E-04_JPRB,4.3352E-05_JPRB/)
KAO( :, 2, 5, 3) = (/&
&5.3144E-06_JPRB,1.8924E-05_JPRB,2.4595E-05_JPRB,3.1378E-05_JPRB,3.9382E-05_JPRB,6.2226E-05_JPRB,&
&9.6051E-05_JPRB,1.8141E-04_JPRB,4.9071E-05_JPRB/)
KAO( :, 3, 5, 3) = (/&
&8.2729E-06_JPRB,2.7735E-05_JPRB,3.6853E-05_JPRB,4.3473E-05_JPRB,5.3077E-05_JPRB,6.0111E-05_JPRB,&
&8.8205E-05_JPRB,1.7170E-04_JPRB,5.3581E-05_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.2483E-05_JPRB,3.8936E-05_JPRB,5.1944E-05_JPRB,6.0771E-05_JPRB,7.0416E-05_JPRB,8.1406E-05_JPRB,&
&9.7912E-05_JPRB,1.4624E-04_JPRB,6.0502E-05_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.8234E-05_JPRB,5.2997E-05_JPRB,7.0214E-05_JPRB,8.3889E-05_JPRB,9.4583E-05_JPRB,1.0646E-04_JPRB,&
&1.1645E-04_JPRB,1.6664E-04_JPRB,6.9524E-05_JPRB/)
KAO( :, 1, 6, 3) = (/&
&2.2627E-06_JPRB,8.2256E-06_JPRB,1.2662E-05_JPRB,2.0881E-05_JPRB,3.2287E-05_JPRB,4.9842E-05_JPRB,&
&7.8514E-05_JPRB,1.5143E-04_JPRB,4.2185E-05_JPRB/)
KAO( :, 2, 6, 3) = (/&
&3.5902E-06_JPRB,1.2715E-05_JPRB,1.6777E-05_JPRB,2.2883E-05_JPRB,3.3890E-05_JPRB,5.0807E-05_JPRB,&
&8.0753E-05_JPRB,1.4463E-04_JPRB,4.8590E-05_JPRB/)
KAO( :, 3, 6, 3) = (/&
&5.6436E-06_JPRB,1.9109E-05_JPRB,2.4998E-05_JPRB,3.0305E-05_JPRB,3.7831E-05_JPRB,4.7255E-05_JPRB,&
&7.8945E-05_JPRB,1.4406E-04_JPRB,5.5296E-05_JPRB/)
KAO( :, 4, 6, 3) = (/&
&8.6680E-06_JPRB,2.7468E-05_JPRB,3.6416E-05_JPRB,4.2070E-05_JPRB,4.9055E-05_JPRB,5.8245E-05_JPRB,&
&7.2889E-05_JPRB,1.3759E-04_JPRB,6.2699E-05_JPRB/)
KAO( :, 5, 6, 3) = (/&
&1.2910E-05_JPRB,3.8070E-05_JPRB,5.0552E-05_JPRB,5.9531E-05_JPRB,6.5990E-05_JPRB,7.5485E-05_JPRB,&
&9.0151E-05_JPRB,1.2519E-04_JPRB,7.1158E-05_JPRB/)
KAO( :, 1, 7, 3) = (/&
&1.6260E-06_JPRB,5.6512E-06_JPRB,1.0534E-05_JPRB,1.6548E-05_JPRB,2.5722E-05_JPRB,3.9212E-05_JPRB,&
&6.5255E-05_JPRB,1.1642E-04_JPRB,4.8396E-05_JPRB/)
KAO( :, 2, 7, 3) = (/&
&2.4977E-06_JPRB,8.5111E-06_JPRB,1.1552E-05_JPRB,1.8620E-05_JPRB,2.6964E-05_JPRB,4.1086E-05_JPRB,&
&6.5326E-05_JPRB,1.2038E-04_JPRB,5.6755E-05_JPRB/)
KAO( :, 3, 7, 3) = (/&
&3.8937E-06_JPRB,1.3083E-05_JPRB,1.6837E-05_JPRB,2.1037E-05_JPRB,2.8103E-05_JPRB,4.1971E-05_JPRB,&
&6.4916E-05_JPRB,1.2035E-04_JPRB,6.5643E-05_JPRB/)
KAO( :, 4, 7, 3) = (/&
&6.0131E-06_JPRB,1.9182E-05_JPRB,2.5262E-05_JPRB,2.9578E-05_JPRB,3.5380E-05_JPRB,4.1824E-05_JPRB,&
&6.4389E-05_JPRB,1.1625E-04_JPRB,7.5112E-05_JPRB/)
KAO( :, 5, 7, 3) = (/&
&9.0775E-06_JPRB,2.7049E-05_JPRB,3.5910E-05_JPRB,4.1673E-05_JPRB,4.7430E-05_JPRB,5.6675E-05_JPRB,&
&6.4662E-05_JPRB,1.0376E-04_JPRB,8.5479E-05_JPRB/)
KAO( :, 1, 8, 3) = (/&
&1.2762E-06_JPRB,4.2855E-06_JPRB,8.2820E-06_JPRB,1.3051E-05_JPRB,1.9907E-05_JPRB,3.3971E-05_JPRB,&
&5.0446E-05_JPRB,8.6971E-05_JPRB,7.7745E-05_JPRB/)
KAO( :, 2, 8, 3) = (/&
&1.8844E-06_JPRB,5.9050E-06_JPRB,8.9489E-06_JPRB,1.4806E-05_JPRB,2.1839E-05_JPRB,3.2608E-05_JPRB,&
&5.2540E-05_JPRB,9.7610E-05_JPRB,8.9498E-05_JPRB/)
KAO( :, 3, 8, 3) = (/&
&2.8385E-06_JPRB,8.9737E-06_JPRB,1.1895E-05_JPRB,1.5870E-05_JPRB,2.4156E-05_JPRB,3.3906E-05_JPRB,&
&5.3605E-05_JPRB,9.6849E-05_JPRB,1.0287E-04_JPRB/)
KAO( :, 4, 8, 3) = (/&
&4.3106E-06_JPRB,1.3404E-05_JPRB,1.7498E-05_JPRB,2.1009E-05_JPRB,2.6036E-05_JPRB,3.4758E-05_JPRB,&
&5.4115E-05_JPRB,9.7671E-05_JPRB,1.1774E-04_JPRB/)
KAO( :, 5, 8, 3) = (/&
&6.4933E-06_JPRB,1.9198E-05_JPRB,2.5108E-05_JPRB,2.9532E-05_JPRB,3.3547E-05_JPRB,4.0870E-05_JPRB,&
&5.0672E-05_JPRB,9.4048E-05_JPRB,1.3326E-04_JPRB/)
KAO( :, 1, 9, 3) = (/&
&1.0706E-06_JPRB,3.3489E-06_JPRB,6.5283E-06_JPRB,1.0192E-05_JPRB,1.7278E-05_JPRB,2.6238E-05_JPRB,&
&3.9041E-05_JPRB,7.0346E-05_JPRB,2.7103E-04_JPRB/)
KAO( :, 2, 9, 3) = (/&
&1.5238E-06_JPRB,4.4647E-06_JPRB,7.4896E-06_JPRB,1.1805E-05_JPRB,1.7404E-05_JPRB,2.6241E-05_JPRB,&
&4.5076E-05_JPRB,7.3357E-05_JPRB,3.0478E-04_JPRB/)
KAO( :, 3, 9, 3) = (/&
&2.2245E-06_JPRB,6.3482E-06_JPRB,8.7814E-06_JPRB,1.3182E-05_JPRB,1.8649E-05_JPRB,2.8139E-05_JPRB,&
&4.2432E-05_JPRB,8.1918E-05_JPRB,3.3943E-04_JPRB/)
KAO( :, 4, 9, 3) = (/&
&3.2853E-06_JPRB,9.5377E-06_JPRB,1.2081E-05_JPRB,1.5048E-05_JPRB,2.0438E-05_JPRB,2.9250E-05_JPRB,&
&4.4492E-05_JPRB,8.0054E-05_JPRB,3.7569E-04_JPRB/)
KAO( :, 5, 9, 3) = (/&
&4.8340E-06_JPRB,1.3704E-05_JPRB,1.7727E-05_JPRB,2.0846E-05_JPRB,2.4389E-05_JPRB,3.0169E-05_JPRB,&
&4.5558E-05_JPRB,7.6780E-05_JPRB,4.1363E-04_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.0087E-06_JPRB,2.8522E-06_JPRB,5.3847E-06_JPRB,8.7589E-06_JPRB,1.3656E-05_JPRB,2.0793E-05_JPRB,&
&3.0265E-05_JPRB,5.6466E-05_JPRB,1.4467E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&1.3893E-06_JPRB,3.6572E-06_JPRB,6.0381E-06_JPRB,9.5656E-06_JPRB,1.3744E-05_JPRB,2.2378E-05_JPRB,&
&3.6073E-05_JPRB,5.8999E-05_JPRB,1.6134E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&1.9601E-06_JPRB,4.9746E-06_JPRB,7.1675E-06_JPRB,1.0782E-05_JPRB,1.5548E-05_JPRB,2.2425E-05_JPRB,&
&3.4813E-05_JPRB,6.8188E-05_JPRB,1.7742E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&2.8046E-06_JPRB,7.3061E-06_JPRB,9.2760E-06_JPRB,1.2016E-05_JPRB,1.7674E-05_JPRB,2.3526E-05_JPRB,&
&3.6626E-05_JPRB,6.3451E-05_JPRB,1.9257E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&4.0204E-06_JPRB,1.0448E-05_JPRB,1.3168E-05_JPRB,1.5711E-05_JPRB,1.8780E-05_JPRB,2.5290E-05_JPRB,&
&3.7179E-05_JPRB,6.5468E-05_JPRB,2.0654E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.1167E-06_JPRB,2.7196E-06_JPRB,4.8414E-06_JPRB,7.5750E-06_JPRB,1.1619E-05_JPRB,1.6844E-05_JPRB,&
&2.5920E-05_JPRB,4.2497E-05_JPRB,3.0648E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&1.5177E-06_JPRB,3.5342E-06_JPRB,5.4336E-06_JPRB,8.4346E-06_JPRB,1.1729E-05_JPRB,1.8362E-05_JPRB,&
&2.9194E-05_JPRB,5.0129E-05_JPRB,3.3976E-03_JPRB/)
KAO( :, 3,11, 3) = (/&
&2.0984E-06_JPRB,4.8006E-06_JPRB,6.5451E-06_JPRB,9.5029E-06_JPRB,1.3465E-05_JPRB,1.9020E-05_JPRB,&
&2.8692E-05_JPRB,5.7928E-05_JPRB,3.7050E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&2.9335E-06_JPRB,6.8708E-06_JPRB,8.4101E-06_JPRB,1.0863E-05_JPRB,1.4762E-05_JPRB,2.0091E-05_JPRB,&
&3.0371E-05_JPRB,5.2028E-05_JPRB,3.9809E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&4.1000E-06_JPRB,9.6543E-06_JPRB,1.1857E-05_JPRB,1.3714E-05_JPRB,1.6526E-05_JPRB,2.1427E-05_JPRB,&
&3.1464E-05_JPRB,5.4245E-05_JPRB,4.2143E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.1265E-06_JPRB,2.5186E-06_JPRB,4.3674E-06_JPRB,6.5192E-06_JPRB,9.8193E-06_JPRB,1.4195E-05_JPRB,&
&2.1669E-05_JPRB,3.5591E-05_JPRB,4.1354E-03_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.5273E-06_JPRB,3.2471E-06_JPRB,4.8453E-06_JPRB,7.4929E-06_JPRB,9.9333E-06_JPRB,1.5224E-05_JPRB,&
&2.4490E-05_JPRB,4.2520E-05_JPRB,4.5631E-03_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.0931E-06_JPRB,4.4632E-06_JPRB,5.8990E-06_JPRB,8.1723E-06_JPRB,1.1637E-05_JPRB,1.5989E-05_JPRB,&
&2.3803E-05_JPRB,4.4958E-05_JPRB,4.9406E-03_JPRB/)
KAO( :, 4,12, 3) = (/&
&2.8927E-06_JPRB,6.3250E-06_JPRB,7.6186E-06_JPRB,9.4669E-06_JPRB,1.2563E-05_JPRB,1.7445E-05_JPRB,&
&2.5222E-05_JPRB,4.2668E-05_JPRB,5.2603E-03_JPRB/)
KAO( :, 5,12, 3) = (/&
&3.9848E-06_JPRB,8.7921E-06_JPRB,1.0605E-05_JPRB,1.2004E-05_JPRB,1.4341E-05_JPRB,1.8049E-05_JPRB,&
&2.6521E-05_JPRB,4.4754E-05_JPRB,5.5165E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.1328E-06_JPRB,2.3238E-06_JPRB,3.9430E-06_JPRB,5.6932E-06_JPRB,8.4038E-06_JPRB,1.1800E-05_JPRB,&
&1.7829E-05_JPRB,3.0820E-05_JPRB,4.4819E-03_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.5311E-06_JPRB,3.0098E-06_JPRB,4.3521E-06_JPRB,6.6679E-06_JPRB,8.7081E-06_JPRB,1.2897E-05_JPRB,&
&1.9883E-05_JPRB,3.4493E-05_JPRB,4.9164E-03_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.0853E-06_JPRB,4.1223E-06_JPRB,5.4114E-06_JPRB,7.2554E-06_JPRB,1.0229E-05_JPRB,1.3641E-05_JPRB,&
&1.9729E-05_JPRB,3.6438E-05_JPRB,5.2852E-03_JPRB/)
KAO( :, 4,13, 3) = (/&
&2.8506E-06_JPRB,5.8568E-06_JPRB,6.9938E-06_JPRB,8.4840E-06_JPRB,1.0942E-05_JPRB,1.5066E-05_JPRB,&
&2.1270E-05_JPRB,3.5313E-05_JPRB,5.5871E-03_JPRB/)
KAO( :, 5,13, 3) = (/&
&3.8711E-06_JPRB,8.0712E-06_JPRB,9.6159E-06_JPRB,1.0719E-05_JPRB,1.2561E-05_JPRB,1.5293E-05_JPRB,&
&2.2681E-05_JPRB,3.7058E-05_JPRB,5.8266E-03_JPRB/)
KAO( :, 1, 1, 4) = (/&
&7.4893E-05_JPRB,1.7660E-04_JPRB,2.0743E-04_JPRB,2.2345E-04_JPRB,2.5541E-04_JPRB,3.0113E-04_JPRB,&
&4.0065E-04_JPRB,5.1140E-04_JPRB,1.9420E-04_JPRB/)
KAO( :, 2, 1, 4) = (/&
&1.0396E-04_JPRB,2.3012E-04_JPRB,2.6622E-04_JPRB,2.8243E-04_JPRB,2.9424E-04_JPRB,3.3000E-04_JPRB,&
&4.1387E-04_JPRB,6.5618E-04_JPRB,1.7248E-04_JPRB/)
KAO( :, 3, 1, 4) = (/&
&1.3874E-04_JPRB,2.9171E-04_JPRB,3.3413E-04_JPRB,3.5198E-04_JPRB,3.5734E-04_JPRB,3.6401E-04_JPRB,&
&4.2489E-04_JPRB,6.4403E-04_JPRB,1.9641E-04_JPRB/)
KAO( :, 4, 1, 4) = (/&
&1.7941E-04_JPRB,3.6434E-04_JPRB,4.1317E-04_JPRB,4.3271E-04_JPRB,4.3728E-04_JPRB,4.3279E-04_JPRB,&
&4.4184E-04_JPRB,6.1293E-04_JPRB,2.4660E-04_JPRB/)
KAO( :, 5, 1, 4) = (/&
&2.2524E-04_JPRB,4.4700E-04_JPRB,5.0389E-04_JPRB,5.2899E-04_JPRB,5.4228E-04_JPRB,5.4473E-04_JPRB,&
&5.3368E-04_JPRB,5.6423E-04_JPRB,3.1492E-04_JPRB/)
KAO( :, 1, 2, 4) = (/&
&5.8910E-05_JPRB,1.3730E-04_JPRB,1.6111E-04_JPRB,1.7338E-04_JPRB,1.9974E-04_JPRB,2.3614E-04_JPRB,&
&3.1448E-04_JPRB,3.8866E-04_JPRB,1.4405E-04_JPRB/)
KAO( :, 2, 2, 4) = (/&
&8.3036E-05_JPRB,1.8135E-04_JPRB,2.0964E-04_JPRB,2.2070E-04_JPRB,2.3158E-04_JPRB,2.7057E-04_JPRB,&
&3.3372E-04_JPRB,5.4726E-04_JPRB,1.2817E-04_JPRB/)
KAO( :, 3, 2, 4) = (/&
&1.1213E-04_JPRB,2.3284E-04_JPRB,2.6662E-04_JPRB,2.8050E-04_JPRB,2.8374E-04_JPRB,2.9072E-04_JPRB,&
&3.5956E-04_JPRB,5.3062E-04_JPRB,1.4567E-04_JPRB/)
KAO( :, 4, 2, 4) = (/&
&1.4639E-04_JPRB,2.9331E-04_JPRB,3.3229E-04_JPRB,3.4773E-04_JPRB,3.4771E-04_JPRB,3.4598E-04_JPRB,&
&3.5609E-04_JPRB,5.3796E-04_JPRB,1.8917E-04_JPRB/)
KAO( :, 5, 2, 4) = (/&
&1.8573E-04_JPRB,3.6333E-04_JPRB,4.0899E-04_JPRB,4.2805E-04_JPRB,4.3596E-04_JPRB,4.3023E-04_JPRB,&
&4.2036E-04_JPRB,4.7310E-04_JPRB,2.4106E-04_JPRB/)
KAO( :, 1, 3, 4) = (/&
&4.2697E-05_JPRB,9.9737E-05_JPRB,1.1762E-04_JPRB,1.3175E-04_JPRB,1.5206E-04_JPRB,1.7738E-04_JPRB,&
&2.2461E-04_JPRB,3.0012E-04_JPRB,9.0760E-05_JPRB/)
KAO( :, 2, 3, 4) = (/&
&6.1628E-05_JPRB,1.3453E-04_JPRB,1.5553E-04_JPRB,1.6395E-04_JPRB,1.7863E-04_JPRB,2.1026E-04_JPRB,&
&2.6559E-04_JPRB,4.0665E-04_JPRB,9.5213E-05_JPRB/)
KAO( :, 3, 3, 4) = (/&
&8.5155E-05_JPRB,1.7580E-04_JPRB,2.0156E-04_JPRB,2.1203E-04_JPRB,2.1267E-04_JPRB,2.2935E-04_JPRB,&
&2.8279E-04_JPRB,4.3028E-04_JPRB,1.1265E-04_JPRB/)
KAO( :, 4, 3, 4) = (/&
&1.1317E-04_JPRB,2.2386E-04_JPRB,2.5438E-04_JPRB,2.6544E-04_JPRB,2.6602E-04_JPRB,2.6653E-04_JPRB,&
&2.9745E-04_JPRB,4.2745E-04_JPRB,1.4173E-04_JPRB/)
KAO( :, 5, 3, 4) = (/&
&1.4597E-04_JPRB,2.8045E-04_JPRB,3.1649E-04_JPRB,3.3077E-04_JPRB,3.3240E-04_JPRB,3.2175E-04_JPRB,&
&3.2192E-04_JPRB,4.1153E-04_JPRB,1.7765E-04_JPRB/)
KAO( :, 1, 4, 4) = (/&
&2.9896E-05_JPRB,7.0709E-05_JPRB,8.4360E-05_JPRB,9.7466E-05_JPRB,1.0874E-04_JPRB,1.3074E-04_JPRB,&
&1.6227E-04_JPRB,2.5464E-04_JPRB,6.8134E-05_JPRB/)
KAO( :, 2, 4, 4) = (/&
&4.4341E-05_JPRB,9.6962E-05_JPRB,1.1247E-04_JPRB,1.1929E-04_JPRB,1.3785E-04_JPRB,1.5834E-04_JPRB,&
&2.0071E-04_JPRB,2.9189E-04_JPRB,7.8206E-05_JPRB/)
KAO( :, 3, 4, 4) = (/&
&6.2914E-05_JPRB,1.2902E-04_JPRB,1.4817E-04_JPRB,1.5527E-04_JPRB,1.5849E-04_JPRB,1.8569E-04_JPRB,&
&2.2497E-04_JPRB,3.4124E-04_JPRB,9.0845E-05_JPRB/)
KAO( :, 4, 4, 4) = (/&
&8.5677E-05_JPRB,1.6689E-04_JPRB,1.9068E-04_JPRB,1.9916E-04_JPRB,1.9978E-04_JPRB,2.0155E-04_JPRB,&
&2.4936E-04_JPRB,3.5340E-04_JPRB,1.0988E-04_JPRB/)
KAO( :, 5, 4, 4) = (/&
&1.1242E-04_JPRB,2.1149E-04_JPRB,2.3915E-04_JPRB,2.5028E-04_JPRB,2.4989E-04_JPRB,2.4272E-04_JPRB,&
&2.4831E-04_JPRB,3.6709E-04_JPRB,1.3381E-04_JPRB/)
KAO( :, 1, 5, 4) = (/&
&2.0688E-05_JPRB,4.9203E-05_JPRB,5.9785E-05_JPRB,6.6990E-05_JPRB,7.8124E-05_JPRB,9.2624E-05_JPRB,&
&1.2472E-04_JPRB,2.0745E-04_JPRB,6.1812E-05_JPRB/)
KAO( :, 2, 5, 4) = (/&
&3.1637E-05_JPRB,6.9271E-05_JPRB,8.0604E-05_JPRB,9.0077E-05_JPRB,1.0181E-04_JPRB,1.1707E-04_JPRB,&
&1.4853E-04_JPRB,2.1722E-04_JPRB,7.1005E-05_JPRB/)
KAO( :, 3, 5, 4) = (/&
&4.6076E-05_JPRB,9.3625E-05_JPRB,1.0769E-04_JPRB,1.1334E-04_JPRB,1.2174E-04_JPRB,1.4414E-04_JPRB,&
&1.7668E-04_JPRB,2.5800E-04_JPRB,8.3094E-05_JPRB/)
KAO( :, 4, 5, 4) = (/&
&6.4341E-05_JPRB,1.2346E-04_JPRB,1.4103E-04_JPRB,1.4850E-04_JPRB,1.4693E-04_JPRB,1.5815E-04_JPRB,&
&1.9286E-04_JPRB,2.8817E-04_JPRB,9.6701E-05_JPRB/)
KAO( :, 5, 5, 4) = (/&
&8.6238E-05_JPRB,1.5868E-04_JPRB,1.7942E-04_JPRB,1.8707E-04_JPRB,1.8806E-04_JPRB,1.8319E-04_JPRB,&
&2.0554E-04_JPRB,2.8611E-04_JPRB,1.1287E-04_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.4006E-05_JPRB,3.3343E-05_JPRB,4.0079E-05_JPRB,4.5588E-05_JPRB,5.4107E-05_JPRB,6.6418E-05_JPRB,&
&1.0066E-04_JPRB,1.4196E-04_JPRB,6.6243E-05_JPRB/)
KAO( :, 2, 6, 4) = (/&
&2.2071E-05_JPRB,4.8614E-05_JPRB,5.7228E-05_JPRB,6.5093E-05_JPRB,7.1721E-05_JPRB,8.5635E-05_JPRB,&
&1.0856E-04_JPRB,1.8021E-04_JPRB,7.5554E-05_JPRB/)
KAO( :, 3, 6, 4) = (/&
&3.3040E-05_JPRB,6.6682E-05_JPRB,7.6698E-05_JPRB,8.2380E-05_JPRB,9.3552E-05_JPRB,1.0700E-04_JPRB,&
&1.3596E-04_JPRB,1.9405E-04_JPRB,8.6063E-05_JPRB/)
KAO( :, 4, 6, 4) = (/&
&4.7386E-05_JPRB,8.9793E-05_JPRB,1.0237E-04_JPRB,1.0759E-04_JPRB,1.0965E-04_JPRB,1.2726E-04_JPRB,&
&1.5398E-04_JPRB,2.2704E-04_JPRB,9.8696E-05_JPRB/)
KAO( :, 5, 6, 4) = (/&
&6.5121E-05_JPRB,1.1757E-04_JPRB,1.3268E-04_JPRB,1.3869E-04_JPRB,1.4006E-04_JPRB,1.3836E-04_JPRB,&
&1.7051E-04_JPRB,2.3669E-04_JPRB,1.1305E-04_JPRB/)
KAO( :, 1, 7, 4) = (/&
&9.5061E-06_JPRB,2.2311E-05_JPRB,2.6088E-05_JPRB,3.0162E-05_JPRB,3.7877E-05_JPRB,5.4505E-05_JPRB,&
&7.5227E-05_JPRB,1.1255E-04_JPRB,8.3483E-05_JPRB/)
KAO( :, 2, 7, 4) = (/&
&1.5323E-05_JPRB,3.3598E-05_JPRB,4.0386E-05_JPRB,4.3881E-05_JPRB,5.0583E-05_JPRB,6.2493E-05_JPRB,&
&8.2842E-05_JPRB,1.4322E-04_JPRB,9.4311E-05_JPRB/)
KAO( :, 3, 7, 4) = (/&
&2.3596E-05_JPRB,4.7494E-05_JPRB,5.4556E-05_JPRB,6.1372E-05_JPRB,6.7015E-05_JPRB,7.9350E-05_JPRB,&
&9.7496E-05_JPRB,1.4436E-04_JPRB,1.0703E-04_JPRB/)
KAO( :, 4, 7, 4) = (/&
&3.4570E-05_JPRB,6.4860E-05_JPRB,7.3694E-05_JPRB,7.7754E-05_JPRB,8.4695E-05_JPRB,9.7029E-05_JPRB,&
&1.1678E-04_JPRB,1.6858E-04_JPRB,1.2127E-04_JPRB/)
KAO( :, 5, 7, 4) = (/&
&4.8551E-05_JPRB,8.6609E-05_JPRB,9.7619E-05_JPRB,1.0164E-04_JPRB,1.0226E-04_JPRB,1.0885E-04_JPRB,&
&1.3405E-04_JPRB,1.9133E-04_JPRB,1.3656E-04_JPRB/)
KAO( :, 1, 8, 4) = (/&
&6.7311E-06_JPRB,1.4755E-05_JPRB,1.6935E-05_JPRB,2.1463E-05_JPRB,3.1231E-05_JPRB,4.0742E-05_JPRB,&
&5.6656E-05_JPRB,8.5927E-05_JPRB,1.5049E-04_JPRB/)
KAO( :, 2, 8, 4) = (/&
&1.0838E-05_JPRB,2.3183E-05_JPRB,2.7453E-05_JPRB,3.0553E-05_JPRB,3.5694E-05_JPRB,4.6374E-05_JPRB,&
&6.9419E-05_JPRB,1.0643E-04_JPRB,1.6866E-04_JPRB/)
KAO( :, 3, 8, 4) = (/&
&1.6914E-05_JPRB,3.3766E-05_JPRB,3.8989E-05_JPRB,4.4447E-05_JPRB,4.8070E-05_JPRB,5.7198E-05_JPRB,&
&7.1116E-05_JPRB,1.2478E-04_JPRB,1.8779E-04_JPRB/)
KAO( :, 4, 8, 4) = (/&
&2.5195E-05_JPRB,4.6972E-05_JPRB,5.3026E-05_JPRB,5.6927E-05_JPRB,6.4565E-05_JPRB,7.1923E-05_JPRB,&
&9.0751E-05_JPRB,1.2249E-04_JPRB,2.0805E-04_JPRB/)
KAO( :, 5, 8, 4) = (/&
&3.5942E-05_JPRB,6.3786E-05_JPRB,7.1729E-05_JPRB,7.3949E-05_JPRB,7.6446E-05_JPRB,8.8163E-05_JPRB,&
&1.0367E-04_JPRB,1.5461E-04_JPRB,2.3067E-04_JPRB/)
KAO( :, 1, 9, 4) = (/&
&5.1599E-06_JPRB,1.0081E-05_JPRB,1.1772E-05_JPRB,1.6698E-05_JPRB,2.2821E-05_JPRB,2.9936E-05_JPRB,&
&4.2105E-05_JPRB,6.2990E-05_JPRB,5.8733E-04_JPRB/)
KAO( :, 2, 9, 4) = (/&
&8.0231E-06_JPRB,1.6031E-05_JPRB,1.8581E-05_JPRB,2.0889E-05_JPRB,2.6202E-05_JPRB,3.8502E-05_JPRB,&
&5.1188E-05_JPRB,8.2231E-05_JPRB,6.4455E-04_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.2365E-05_JPRB,2.3962E-05_JPRB,2.7785E-05_JPRB,3.0574E-05_JPRB,3.4959E-05_JPRB,4.1433E-05_JPRB,&
&5.7939E-05_JPRB,9.7311E-05_JPRB,7.0196E-04_JPRB/)
KAO( :, 4, 9, 4) = (/&
&1.8494E-05_JPRB,3.4148E-05_JPRB,3.8522E-05_JPRB,4.2610E-05_JPRB,4.6125E-05_JPRB,5.4566E-05_JPRB,&
&6.5066E-05_JPRB,9.3543E-05_JPRB,7.5838E-04_JPRB/)
KAO( :, 5, 9, 4) = (/&
&2.6560E-05_JPRB,4.6839E-05_JPRB,5.2429E-05_JPRB,5.4183E-05_JPRB,5.9609E-05_JPRB,6.7149E-05_JPRB,&
&7.9436E-05_JPRB,1.1417E-04_JPRB,8.1247E-04_JPRB/)
KAO( :, 1,10, 4) = (/&
&4.5845E-06_JPRB,7.8051E-06_JPRB,9.3693E-06_JPRB,1.2991E-05_JPRB,1.7572E-05_JPRB,2.3437E-05_JPRB,&
&3.3813E-05_JPRB,4.9188E-05_JPRB,3.3674E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&6.8084E-06_JPRB,1.2034E-05_JPRB,1.3688E-05_JPRB,1.5733E-05_JPRB,2.1211E-05_JPRB,2.9098E-05_JPRB,&
&3.8545E-05_JPRB,6.3500E-05_JPRB,3.6391E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&1.0062E-05_JPRB,1.7982E-05_JPRB,2.0409E-05_JPRB,2.2663E-05_JPRB,2.5613E-05_JPRB,3.1784E-05_JPRB,&
&4.7385E-05_JPRB,7.3006E-05_JPRB,3.8993E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&1.4658E-05_JPRB,2.5727E-05_JPRB,2.8782E-05_JPRB,3.2310E-05_JPRB,3.4485E-05_JPRB,4.0752E-05_JPRB,&
&4.8720E-05_JPRB,8.2499E-05_JPRB,4.1490E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&2.0786E-05_JPRB,3.5657E-05_JPRB,3.9659E-05_JPRB,4.1123E-05_JPRB,4.6983E-05_JPRB,5.0556E-05_JPRB,&
&6.3521E-05_JPRB,8.4499E-05_JPRB,4.3775E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&5.0356E-06_JPRB,7.7353E-06_JPRB,8.8833E-06_JPRB,1.1452E-05_JPRB,1.5243E-05_JPRB,2.1044E-05_JPRB,&
&2.8338E-05_JPRB,4.9949E-05_JPRB,7.2577E-03_JPRB/)
KAO( :, 2,11, 4) = (/&
&7.2423E-06_JPRB,1.1514E-05_JPRB,1.2798E-05_JPRB,1.4086E-05_JPRB,1.8007E-05_JPRB,2.4558E-05_JPRB,&
&3.3851E-05_JPRB,5.2802E-05_JPRB,7.8158E-03_JPRB/)
KAO( :, 3,11, 4) = (/&
&1.0309E-05_JPRB,1.6653E-05_JPRB,1.8407E-05_JPRB,2.0089E-05_JPRB,2.2296E-05_JPRB,2.7018E-05_JPRB,&
&3.8586E-05_JPRB,6.0068E-05_JPRB,8.3354E-03_JPRB/)
KAO( :, 4,11, 4) = (/&
&1.4421E-05_JPRB,2.3379E-05_JPRB,2.5740E-05_JPRB,2.7750E-05_JPRB,3.0309E-05_JPRB,3.4851E-05_JPRB,&
&4.1245E-05_JPRB,6.8211E-05_JPRB,8.8296E-03_JPRB/)
KAO( :, 5,11, 4) = (/&
&1.9663E-05_JPRB,3.1842E-05_JPRB,3.4991E-05_JPRB,3.6140E-05_JPRB,3.9688E-05_JPRB,4.2983E-05_JPRB,&
&5.3776E-05_JPRB,6.9907E-05_JPRB,9.2688E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&5.1165E-06_JPRB,7.4029E-06_JPRB,8.1941E-06_JPRB,1.0138E-05_JPRB,1.3490E-05_JPRB,1.7256E-05_JPRB,&
&2.4419E-05_JPRB,4.0146E-05_JPRB,9.9448E-03_JPRB/)
KAO( :, 2,12, 4) = (/&
&7.2283E-06_JPRB,1.0802E-05_JPRB,1.1887E-05_JPRB,1.2642E-05_JPRB,1.5734E-05_JPRB,2.0542E-05_JPRB,&
&2.7886E-05_JPRB,4.3910E-05_JPRB,1.0705E-02_JPRB/)
KAO( :, 3,12, 4) = (/&
&1.0065E-05_JPRB,1.5284E-05_JPRB,1.6642E-05_JPRB,1.8157E-05_JPRB,1.9448E-05_JPRB,2.3207E-05_JPRB,&
&3.2168E-05_JPRB,5.3905E-05_JPRB,1.1409E-02_JPRB/)
KAO( :, 4,12, 4) = (/&
&1.3731E-05_JPRB,2.1142E-05_JPRB,2.2780E-05_JPRB,2.4378E-05_JPRB,2.6665E-05_JPRB,2.9738E-05_JPRB,&
&3.5163E-05_JPRB,5.5828E-05_JPRB,1.2051E-02_JPRB/)
KAO( :, 5,12, 4) = (/&
&1.8328E-05_JPRB,2.8382E-05_JPRB,3.0850E-05_JPRB,3.1430E-05_JPRB,3.3929E-05_JPRB,3.7016E-05_JPRB,&
&4.5266E-05_JPRB,5.8847E-05_JPRB,1.2603E-02_JPRB/)
KAO( :, 1,13, 4) = (/&
&5.1628E-06_JPRB,7.0476E-06_JPRB,7.6783E-06_JPRB,9.1901E-06_JPRB,1.1659E-05_JPRB,1.4990E-05_JPRB,&
&2.0746E-05_JPRB,3.1591E-05_JPRB,1.0979E-02_JPRB/)
KAO( :, 2,13, 4) = (/&
&7.1656E-06_JPRB,1.0090E-05_JPRB,1.0951E-05_JPRB,1.1562E-05_JPRB,1.3750E-05_JPRB,1.7398E-05_JPRB,&
&2.3701E-05_JPRB,3.7488E-05_JPRB,1.1813E-02_JPRB/)
KAO( :, 3,13, 4) = (/&
&9.7810E-06_JPRB,1.4159E-05_JPRB,1.5003E-05_JPRB,1.6207E-05_JPRB,1.7175E-05_JPRB,1.9965E-05_JPRB,&
&2.7079E-05_JPRB,4.3382E-05_JPRB,1.2578E-02_JPRB/)
KAO( :, 4,13, 4) = (/&
&1.3104E-05_JPRB,1.9253E-05_JPRB,2.0395E-05_JPRB,2.1436E-05_JPRB,2.3261E-05_JPRB,2.5640E-05_JPRB,&
&2.9895E-05_JPRB,4.6045E-05_JPRB,1.3231E-02_JPRB/)
KAO( :, 5,13, 4) = (/&
&1.7208E-05_JPRB,2.5546E-05_JPRB,2.7424E-05_JPRB,2.7535E-05_JPRB,2.9380E-05_JPRB,3.2546E-05_JPRB,&
&3.8040E-05_JPRB,4.9840E-05_JPRB,1.3742E-02_JPRB/)
KAO( :, 1, 1, 5) = (/&
&3.1090E-04_JPRB,4.1312E-04_JPRB,4.5176E-04_JPRB,4.6856E-04_JPRB,4.5586E-04_JPRB,4.3213E-04_JPRB,&
&4.5397E-04_JPRB,7.8015E-04_JPRB,2.0103E-04_JPRB/)
KAO( :, 2, 1, 5) = (/&
&3.8398E-04_JPRB,5.2122E-04_JPRB,5.7336E-04_JPRB,6.0217E-04_JPRB,6.0591E-04_JPRB,5.7511E-04_JPRB,&
&5.3422E-04_JPRB,6.1896E-04_JPRB,2.8351E-04_JPRB/)
KAO( :, 3, 1, 5) = (/&
&4.6534E-04_JPRB,6.4382E-04_JPRB,7.1301E-04_JPRB,7.5438E-04_JPRB,7.7134E-04_JPRB,7.6006E-04_JPRB,&
&7.0811E-04_JPRB,7.4234E-04_JPRB,3.7763E-04_JPRB/)
KAO( :, 4, 1, 5) = (/&
&5.5987E-04_JPRB,7.8442E-04_JPRB,8.7478E-04_JPRB,9.3078E-04_JPRB,9.6145E-04_JPRB,9.6632E-04_JPRB,&
&9.4057E-04_JPRB,8.7094E-04_JPRB,4.7321E-04_JPRB/)
KAO( :, 5, 1, 5) = (/&
&6.6579E-04_JPRB,9.4348E-04_JPRB,1.0594E-03_JPRB,1.1323E-03_JPRB,1.1769E-03_JPRB,1.1973E-03_JPRB,&
&1.1941E-03_JPRB,1.1720E-03_JPRB,5.8670E-04_JPRB/)
KAO( :, 1, 2, 5) = (/&
&2.4736E-04_JPRB,3.2724E-04_JPRB,3.5306E-04_JPRB,3.6178E-04_JPRB,3.4912E-04_JPRB,3.3979E-04_JPRB,&
&3.6882E-04_JPRB,6.4661E-04_JPRB,1.4637E-04_JPRB/)
KAO( :, 2, 2, 5) = (/&
&3.1002E-04_JPRB,4.1717E-04_JPRB,4.5359E-04_JPRB,4.7283E-04_JPRB,4.7168E-04_JPRB,4.4103E-04_JPRB,&
&4.4124E-04_JPRB,5.1519E-04_JPRB,2.1389E-04_JPRB/)
KAO( :, 3, 2, 5) = (/&
&3.8079E-04_JPRB,5.2107E-04_JPRB,5.7062E-04_JPRB,5.9973E-04_JPRB,6.0662E-04_JPRB,5.9325E-04_JPRB,&
&5.3745E-04_JPRB,5.8652E-04_JPRB,2.8633E-04_JPRB/)
KAO( :, 4, 2, 5) = (/&
&4.6210E-04_JPRB,6.4094E-04_JPRB,7.0763E-04_JPRB,7.4776E-04_JPRB,7.6652E-04_JPRB,7.5984E-04_JPRB,&
&7.3202E-04_JPRB,6.4140E-04_JPRB,3.5290E-04_JPRB/)
KAO( :, 5, 2, 5) = (/&
&5.5546E-04_JPRB,7.7925E-04_JPRB,8.6616E-04_JPRB,9.1863E-04_JPRB,9.4674E-04_JPRB,9.5490E-04_JPRB,&
&9.4094E-04_JPRB,9.1867E-04_JPRB,4.4201E-04_JPRB/)
KAO( :, 1, 3, 5) = (/&
&1.8639E-04_JPRB,2.4387E-04_JPRB,2.5915E-04_JPRB,2.5906E-04_JPRB,2.4918E-04_JPRB,2.5967E-04_JPRB,&
&3.1653E-04_JPRB,4.7580E-04_JPRB,1.1679E-04_JPRB/)
KAO( :, 2, 3, 5) = (/&
&2.3798E-04_JPRB,3.1564E-04_JPRB,3.3906E-04_JPRB,3.5000E-04_JPRB,3.4157E-04_JPRB,3.1943E-04_JPRB,&
&3.2743E-04_JPRB,4.5496E-04_JPRB,1.5856E-04_JPRB/)
KAO( :, 3, 3, 5) = (/&
&2.9733E-04_JPRB,4.0070E-04_JPRB,4.3349E-04_JPRB,4.5188E-04_JPRB,4.5270E-04_JPRB,4.3123E-04_JPRB,&
&3.9880E-04_JPRB,4.4081E-04_JPRB,2.0446E-04_JPRB/)
KAO( :, 4, 3, 5) = (/&
&3.6501E-04_JPRB,4.9946E-04_JPRB,5.4499E-04_JPRB,5.7170E-04_JPRB,5.7932E-04_JPRB,5.6633E-04_JPRB,&
&5.2704E-04_JPRB,5.1414E-04_JPRB,2.5539E-04_JPRB/)
KAO( :, 5, 3, 5) = (/&
&4.4410E-04_JPRB,6.1578E-04_JPRB,6.7619E-04_JPRB,7.1133E-04_JPRB,7.2738E-04_JPRB,7.2351E-04_JPRB,&
&7.0138E-04_JPRB,6.6673E-04_JPRB,3.2169E-04_JPRB/)
KAO( :, 1, 4, 5) = (/&
&1.3808E-04_JPRB,1.7775E-04_JPRB,1.8565E-04_JPRB,1.8174E-04_JPRB,1.8202E-04_JPRB,1.9738E-04_JPRB,&
&2.6854E-04_JPRB,3.3980E-04_JPRB,9.6622E-05_JPRB/)
KAO( :, 2, 4, 5) = (/&
&1.7835E-04_JPRB,2.3331E-04_JPRB,2.4753E-04_JPRB,2.5139E-04_JPRB,2.3877E-04_JPRB,2.3221E-04_JPRB,&
&2.5394E-04_JPRB,4.0618E-04_JPRB,1.2075E-04_JPRB/)
KAO( :, 3, 4, 5) = (/&
&2.2702E-04_JPRB,3.0170E-04_JPRB,3.2275E-04_JPRB,3.3261E-04_JPRB,3.2998E-04_JPRB,3.0635E-04_JPRB,&
&3.0422E-04_JPRB,3.7513E-04_JPRB,1.4994E-04_JPRB/)
KAO( :, 4, 4, 5) = (/&
&2.8327E-04_JPRB,3.8288E-04_JPRB,4.1191E-04_JPRB,4.2826E-04_JPRB,4.2837E-04_JPRB,4.1511E-04_JPRB,&
&3.7299E-04_JPRB,4.1488E-04_JPRB,1.8740E-04_JPRB/)
KAO( :, 5, 4, 5) = (/&
&3.4778E-04_JPRB,4.7798E-04_JPRB,5.1863E-04_JPRB,5.4065E-04_JPRB,5.4665E-04_JPRB,5.3624E-04_JPRB,&
&5.0550E-04_JPRB,4.5874E-04_JPRB,2.3509E-04_JPRB/)
KAO( :, 1, 5, 5) = (/&
&1.0090E-04_JPRB,1.2840E-04_JPRB,1.3222E-04_JPRB,1.3092E-04_JPRB,1.3649E-04_JPRB,1.6019E-04_JPRB,&
&2.1671E-04_JPRB,2.5303E-04_JPRB,9.1217E-05_JPRB/)
KAO( :, 2, 5, 5) = (/&
&1.3290E-04_JPRB,1.7161E-04_JPRB,1.7952E-04_JPRB,1.7693E-04_JPRB,1.6957E-04_JPRB,1.7378E-04_JPRB,&
&2.2031E-04_JPRB,3.2593E-04_JPRB,1.0460E-04_JPRB/)
KAO( :, 3, 5, 5) = (/&
&1.7169E-04_JPRB,2.2556E-04_JPRB,2.3842E-04_JPRB,2.4266E-04_JPRB,2.3387E-04_JPRB,2.1722E-04_JPRB,&
&2.2376E-04_JPRB,3.3249E-04_JPRB,1.2312E-04_JPRB/)
KAO( :, 4, 5, 5) = (/&
&2.1761E-04_JPRB,2.9095E-04_JPRB,3.1013E-04_JPRB,3.1776E-04_JPRB,3.1556E-04_JPRB,2.9734E-04_JPRB,&
&2.7621E-04_JPRB,3.0674E-04_JPRB,1.4846E-04_JPRB/)
KAO( :, 5, 5, 5) = (/&
&2.6974E-04_JPRB,3.6873E-04_JPRB,3.9640E-04_JPRB,4.0873E-04_JPRB,4.0796E-04_JPRB,3.9425E-04_JPRB,&
&3.6157E-04_JPRB,3.6174E-04_JPRB,1.8146E-04_JPRB/)
KAO( :, 1, 6, 5) = (/&
&7.2092E-05_JPRB,9.1048E-05_JPRB,9.3429E-05_JPRB,9.5226E-05_JPRB,1.0150E-04_JPRB,1.3173E-04_JPRB,&
&1.4984E-04_JPRB,1.9196E-04_JPRB,9.8397E-05_JPRB/)
KAO( :, 2, 6, 5) = (/&
&9.7448E-05_JPRB,1.2423E-04_JPRB,1.2792E-04_JPRB,1.2413E-04_JPRB,1.2424E-04_JPRB,1.3383E-04_JPRB,&
&1.7960E-04_JPRB,2.4434E-04_JPRB,1.1133E-04_JPRB/)
KAO( :, 3, 6, 5) = (/&
&1.2736E-04_JPRB,1.6584E-04_JPRB,1.7360E-04_JPRB,1.7200E-04_JPRB,1.6167E-04_JPRB,1.5892E-04_JPRB,&
&1.7153E-04_JPRB,2.8218E-04_JPRB,1.2781E-04_JPRB/)
KAO( :, 4, 6, 5) = (/&
&1.6376E-04_JPRB,2.1742E-04_JPRB,2.3003E-04_JPRB,2.3266E-04_JPRB,2.2686E-04_JPRB,2.0723E-04_JPRB,&
&2.0538E-04_JPRB,2.5489E-04_JPRB,1.4690E-04_JPRB/)
KAO( :, 5, 6, 5) = (/&
&2.0555E-04_JPRB,2.7960E-04_JPRB,2.9861E-04_JPRB,3.0501E-04_JPRB,3.0003E-04_JPRB,2.8746E-04_JPRB,&
&2.5983E-04_JPRB,2.8313E-04_JPRB,1.7007E-04_JPRB/)
KAO( :, 1, 7, 5) = (/&
&5.0915E-05_JPRB,6.4096E-05_JPRB,6.5839E-05_JPRB,7.0435E-05_JPRB,8.2474E-05_JPRB,1.0016E-04_JPRB,&
&1.1360E-04_JPRB,1.4590E-04_JPRB,1.4032E-04_JPRB/)
KAO( :, 2, 7, 5) = (/&
&7.0625E-05_JPRB,8.9097E-05_JPRB,9.0314E-05_JPRB,8.9429E-05_JPRB,9.3251E-05_JPRB,1.0724E-04_JPRB,&
&1.4912E-04_JPRB,1.8863E-04_JPRB,1.5518E-04_JPRB/)
KAO( :, 3, 7, 5) = (/&
&9.4098E-05_JPRB,1.2125E-04_JPRB,1.2537E-04_JPRB,1.2091E-04_JPRB,1.1603E-04_JPRB,1.1857E-04_JPRB,&
&1.4624E-04_JPRB,2.2506E-04_JPRB,1.7262E-04_JPRB/)
KAO( :, 4, 7, 5) = (/&
&1.2191E-04_JPRB,1.6102E-04_JPRB,1.6901E-04_JPRB,1.6848E-04_JPRB,1.5829E-04_JPRB,1.4830E-04_JPRB,&
&1.5156E-04_JPRB,2.2031E-04_JPRB,1.9339E-04_JPRB/)
KAO( :, 5, 7, 5) = (/&
&1.5529E-04_JPRB,2.0973E-04_JPRB,2.2297E-04_JPRB,2.2562E-04_JPRB,2.1894E-04_JPRB,2.0410E-04_JPRB,&
&1.8782E-04_JPRB,2.1024E-04_JPRB,2.1671E-04_JPRB/)
KAO( :, 1, 8, 5) = (/&
&3.6049E-05_JPRB,4.5291E-05_JPRB,4.7754E-05_JPRB,5.1919E-05_JPRB,6.1186E-05_JPRB,6.9190E-05_JPRB,&
&8.4378E-05_JPRB,1.1648E-04_JPRB,2.7572E-04_JPRB/)
KAO( :, 2, 8, 5) = (/&
&5.1045E-05_JPRB,6.3896E-05_JPRB,6.4272E-05_JPRB,6.5150E-05_JPRB,6.9954E-05_JPRB,8.8868E-05_JPRB,&
&1.0162E-04_JPRB,1.4598E-04_JPRB,3.0000E-04_JPRB/)
KAO( :, 3, 8, 5) = (/&
&6.9216E-05_JPRB,8.8252E-05_JPRB,9.0050E-05_JPRB,8.5873E-05_JPRB,8.5359E-05_JPRB,9.1693E-05_JPRB,&
&1.2432E-04_JPRB,1.5741E-04_JPRB,3.2619E-04_JPRB/)
KAO( :, 4, 8, 5) = (/&
&9.0719E-05_JPRB,1.1854E-04_JPRB,1.2391E-04_JPRB,1.2089E-04_JPRB,1.1160E-04_JPRB,1.0845E-04_JPRB,&
&1.1912E-04_JPRB,1.9063E-04_JPRB,3.5459E-04_JPRB/)
KAO( :, 5, 8, 5) = (/&
&1.1702E-04_JPRB,1.5606E-04_JPRB,1.6531E-04_JPRB,1.6622E-04_JPRB,1.5932E-04_JPRB,1.4248E-04_JPRB,&
&1.4183E-04_JPRB,1.7131E-04_JPRB,3.8497E-04_JPRB/)
KAO( :, 1, 9, 5) = (/&
&2.5866E-05_JPRB,3.2320E-05_JPRB,3.4576E-05_JPRB,3.8709E-05_JPRB,4.6229E-05_JPRB,5.2438E-05_JPRB,&
&6.5503E-05_JPRB,9.3730E-05_JPRB,1.1703E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&3.7130E-05_JPRB,4.6042E-05_JPRB,4.6409E-05_JPRB,4.8783E-05_JPRB,5.6170E-05_JPRB,6.7762E-05_JPRB,&
&7.7225E-05_JPRB,1.1273E-04_JPRB,1.2364E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&5.1057E-05_JPRB,6.4238E-05_JPRB,6.4747E-05_JPRB,6.3009E-05_JPRB,6.3858E-05_JPRB,7.4779E-05_JPRB,&
&9.9385E-05_JPRB,1.2137E-04_JPRB,1.3035E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&6.7872E-05_JPRB,8.7074E-05_JPRB,9.0171E-05_JPRB,8.6365E-05_JPRB,8.1775E-05_JPRB,8.1150E-05_JPRB,&
&1.0091E-04_JPRB,1.5846E-04_JPRB,1.3706E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&8.8212E-05_JPRB,1.1565E-04_JPRB,1.2170E-04_JPRB,1.2148E-04_JPRB,1.1255E-04_JPRB,1.0392E-04_JPRB,&
&1.0391E-04_JPRB,1.5035E-04_JPRB,1.4393E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&2.0052E-05_JPRB,2.4599E-05_JPRB,2.6224E-05_JPRB,2.9775E-05_JPRB,3.4377E-05_JPRB,3.9753E-05_JPRB,&
&5.1870E-05_JPRB,7.0614E-05_JPRB,6.9310E-03_JPRB/)
KAO( :, 2,10, 5) = (/&
&2.8642E-05_JPRB,3.5006E-05_JPRB,3.5601E-05_JPRB,3.7670E-05_JPRB,4.4192E-05_JPRB,5.0297E-05_JPRB,&
&6.0753E-05_JPRB,8.8409E-05_JPRB,7.2473E-03_JPRB/)
KAO( :, 3,10, 5) = (/&
&3.9509E-05_JPRB,4.8803E-05_JPRB,4.8668E-05_JPRB,4.7951E-05_JPRB,5.0708E-05_JPRB,6.1469E-05_JPRB,&
&7.4297E-05_JPRB,9.6176E-05_JPRB,7.5424E-03_JPRB/)
KAO( :, 4,10, 5) = (/&
&5.2822E-05_JPRB,6.6323E-05_JPRB,6.7918E-05_JPRB,6.3993E-05_JPRB,6.2062E-05_JPRB,6.4519E-05_JPRB,&
&8.5147E-05_JPRB,1.1230E-04_JPRB,7.8121E-03_JPRB/)
KAO( :, 5,10, 5) = (/&
&6.8969E-05_JPRB,8.8314E-05_JPRB,9.1957E-05_JPRB,9.0701E-05_JPRB,8.2062E-05_JPRB,7.8779E-05_JPRB,&
&8.1888E-05_JPRB,1.3051E-04_JPRB,8.0714E-03_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.9311E-05_JPRB,2.2943E-05_JPRB,2.3712E-05_JPRB,2.6076E-05_JPRB,2.9763E-05_JPRB,3.4761E-05_JPRB,&
&4.2561E-05_JPRB,5.7624E-05_JPRB,1.5187E-02_JPRB/)
KAO( :, 2,11, 5) = (/&
&2.6757E-05_JPRB,3.2178E-05_JPRB,3.2098E-05_JPRB,3.3425E-05_JPRB,3.7561E-05_JPRB,4.3432E-05_JPRB,&
&5.1256E-05_JPRB,7.3332E-05_JPRB,1.5840E-02_JPRB/)
KAO( :, 3,11, 5) = (/&
&3.6196E-05_JPRB,4.4102E-05_JPRB,4.3948E-05_JPRB,4.2431E-05_JPRB,4.4099E-05_JPRB,5.1811E-05_JPRB,&
&6.2145E-05_JPRB,8.0656E-05_JPRB,1.6449E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&4.7882E-05_JPRB,5.9111E-05_JPRB,6.0086E-05_JPRB,5.7204E-05_JPRB,5.4371E-05_JPRB,5.5076E-05_JPRB,&
&7.0526E-05_JPRB,9.2945E-05_JPRB,1.6989E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&6.2068E-05_JPRB,7.8174E-05_JPRB,8.0859E-05_JPRB,7.9258E-05_JPRB,7.2738E-05_JPRB,6.8607E-05_JPRB,&
&6.8925E-05_JPRB,1.0616E-04_JPRB,1.7481E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&1.8157E-05_JPRB,2.1121E-05_JPRB,2.1509E-05_JPRB,2.2736E-05_JPRB,2.6145E-05_JPRB,3.0200E-05_JPRB,&
&3.7064E-05_JPRB,5.0458E-05_JPRB,2.1164E-02_JPRB/)
KAO( :, 2,12, 5) = (/&
&2.4750E-05_JPRB,2.9265E-05_JPRB,2.8640E-05_JPRB,2.9365E-05_JPRB,3.1815E-05_JPRB,3.7644E-05_JPRB,&
&4.4258E-05_JPRB,6.0893E-05_JPRB,2.2083E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&3.3051E-05_JPRB,3.9669E-05_JPRB,3.9323E-05_JPRB,3.7322E-05_JPRB,3.8330E-05_JPRB,4.3268E-05_JPRB,&
&5.2953E-05_JPRB,6.6459E-05_JPRB,2.2904E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&4.3268E-05_JPRB,5.2755E-05_JPRB,5.3305E-05_JPRB,5.0755E-05_JPRB,4.7183E-05_JPRB,4.7321E-05_JPRB,&
&5.8905E-05_JPRB,7.8211E-05_JPRB,2.3625E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&5.5712E-05_JPRB,6.9313E-05_JPRB,7.1134E-05_JPRB,6.9400E-05_JPRB,6.4153E-05_JPRB,5.9244E-05_JPRB,&
&5.8683E-05_JPRB,8.6772E-05_JPRB,2.4304E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&1.7179E-05_JPRB,1.9773E-05_JPRB,1.9599E-05_JPRB,2.0374E-05_JPRB,2.3480E-05_JPRB,2.5935E-05_JPRB,&
&3.2097E-05_JPRB,4.3807E-05_JPRB,2.3722E-02_JPRB/)
KAO( :, 2,13, 5) = (/&
&2.3195E-05_JPRB,2.7018E-05_JPRB,2.6155E-05_JPRB,2.6118E-05_JPRB,2.7654E-05_JPRB,3.2413E-05_JPRB,&
&3.6439E-05_JPRB,5.1480E-05_JPRB,2.4748E-02_JPRB/)
KAO( :, 3,13, 5) = (/&
&3.0612E-05_JPRB,3.6208E-05_JPRB,3.5603E-05_JPRB,3.3306E-05_JPRB,3.3238E-05_JPRB,3.6754E-05_JPRB,&
&4.5231E-05_JPRB,5.7370E-05_JPRB,2.5646E-02_JPRB/)
KAO( :, 4,13, 5) = (/&
&3.9626E-05_JPRB,4.7737E-05_JPRB,4.7941E-05_JPRB,4.5252E-05_JPRB,4.1653E-05_JPRB,4.0753E-05_JPRB,&
&4.9320E-05_JPRB,6.5660E-05_JPRB,2.6492E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&5.0622E-05_JPRB,6.2138E-05_JPRB,6.3203E-05_JPRB,6.1426E-05_JPRB,5.6252E-05_JPRB,5.1272E-05_JPRB,&
&5.0385E-05_JPRB,7.0865E-05_JPRB,2.7279E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&7.6668E-04_JPRB,9.5698E-04_JPRB,1.0451E-03_JPRB,1.0706E-03_JPRB,1.0458E-03_JPRB,9.8544E-04_JPRB,&
&8.4925E-04_JPRB,7.0084E-04_JPRB,3.6790E-04_JPRB/)
KAO( :, 2, 1, 6) = (/&
&9.3715E-04_JPRB,1.2033E-03_JPRB,1.3264E-03_JPRB,1.3678E-03_JPRB,1.3579E-03_JPRB,1.2955E-03_JPRB,&
&1.2019E-03_JPRB,1.0530E-03_JPRB,4.9374E-04_JPRB/)
KAO( :, 3, 1, 6) = (/&
&1.1259E-03_JPRB,1.4892E-03_JPRB,1.6507E-03_JPRB,1.7086E-03_JPRB,1.7099E-03_JPRB,1.6660E-03_JPRB,&
&1.5468E-03_JPRB,1.3572E-03_JPRB,6.9469E-04_JPRB/)
KAO( :, 4, 1, 6) = (/&
&1.3346E-03_JPRB,1.8150E-03_JPRB,2.0125E-03_JPRB,2.0930E-03_JPRB,2.1054E-03_JPRB,2.0604E-03_JPRB,&
&1.9461E-03_JPRB,1.7694E-03_JPRB,9.3629E-04_JPRB/)
KAO( :, 5, 1, 6) = (/&
&1.5631E-03_JPRB,2.1751E-03_JPRB,2.4107E-03_JPRB,2.5177E-03_JPRB,2.5412E-03_JPRB,2.4997E-03_JPRB,&
&2.4003E-03_JPRB,2.2329E-03_JPRB,1.1943E-03_JPRB/)
KAO( :, 1, 2, 6) = (/&
&6.1736E-04_JPRB,7.7957E-04_JPRB,8.4495E-04_JPRB,8.5822E-04_JPRB,8.3168E-04_JPRB,7.6710E-04_JPRB,&
&6.8197E-04_JPRB,6.1117E-04_JPRB,2.7552E-04_JPRB/)
KAO( :, 2, 2, 6) = (/&
&7.6431E-04_JPRB,9.9047E-04_JPRB,1.0825E-03_JPRB,1.1059E-03_JPRB,1.0905E-03_JPRB,1.0282E-03_JPRB,&
&9.1763E-04_JPRB,8.3788E-04_JPRB,3.8116E-04_JPRB/)
KAO( :, 3, 2, 6) = (/&
&9.2906E-04_JPRB,1.2346E-03_JPRB,1.3561E-03_JPRB,1.3925E-03_JPRB,1.3898E-03_JPRB,1.3440E-03_JPRB,&
&1.2411E-03_JPRB,1.1007E-03_JPRB,5.2777E-04_JPRB/)
KAO( :, 4, 2, 6) = (/&
&1.1126E-03_JPRB,1.5138E-03_JPRB,1.6623E-03_JPRB,1.7166E-03_JPRB,1.7237E-03_JPRB,1.6799E-03_JPRB,&
&1.5813E-03_JPRB,1.4262E-03_JPRB,7.0852E-04_JPRB/)
KAO( :, 5, 2, 6) = (/&
&1.3161E-03_JPRB,1.8216E-03_JPRB,2.0023E-03_JPRB,2.0780E-03_JPRB,2.0918E-03_JPRB,2.0576E-03_JPRB,&
&1.9689E-03_JPRB,1.8083E-03_JPRB,9.0055E-04_JPRB/)
KAO( :, 1, 3, 6) = (/&
&4.6874E-04_JPRB,5.9508E-04_JPRB,6.3781E-04_JPRB,6.4117E-04_JPRB,6.1436E-04_JPRB,5.4822E-04_JPRB,&
&5.0421E-04_JPRB,5.3533E-04_JPRB,2.0334E-04_JPRB/)
KAO( :, 2, 3, 6) = (/&
&5.9055E-04_JPRB,7.6700E-04_JPRB,8.2890E-04_JPRB,8.3946E-04_JPRB,8.1795E-04_JPRB,7.6034E-04_JPRB,&
&6.7368E-04_JPRB,6.0816E-04_JPRB,2.8145E-04_JPRB/)
KAO( :, 3, 3, 6) = (/&
&7.2955E-04_JPRB,9.6821E-04_JPRB,1.0493E-03_JPRB,1.0696E-03_JPRB,1.0616E-03_JPRB,1.0150E-03_JPRB,&
&9.2112E-04_JPRB,8.3960E-04_JPRB,3.8605E-04_JPRB/)
KAO( :, 4, 3, 6) = (/&
&8.8621E-04_JPRB,1.1995E-03_JPRB,1.3001E-03_JPRB,1.3322E-03_JPRB,1.3333E-03_JPRB,1.2938E-03_JPRB,&
&1.2044E-03_JPRB,1.0885E-03_JPRB,5.0764E-04_JPRB/)
KAO( :, 5, 3, 6) = (/&
&1.0620E-03_JPRB,1.4561E-03_JPRB,1.5813E-03_JPRB,1.6291E-03_JPRB,1.6339E-03_JPRB,1.6065E-03_JPRB,&
&1.5265E-03_JPRB,1.3705E-03_JPRB,6.4701E-04_JPRB/)
KAO( :, 1, 4, 6) = (/&
&3.4631E-04_JPRB,4.3892E-04_JPRB,4.6539E-04_JPRB,4.6252E-04_JPRB,4.3395E-04_JPRB,3.8559E-04_JPRB,&
&3.5487E-04_JPRB,4.4831E-04_JPRB,1.5114E-04_JPRB/)
KAO( :, 2, 4, 6) = (/&
&4.4425E-04_JPRB,5.7553E-04_JPRB,6.1538E-04_JPRB,6.1883E-04_JPRB,5.9314E-04_JPRB,5.4165E-04_JPRB,&
&4.8640E-04_JPRB,4.4227E-04_JPRB,2.0515E-04_JPRB/)
KAO( :, 3, 4, 6) = (/&
&5.5883E-04_JPRB,7.3740E-04_JPRB,7.9031E-04_JPRB,7.9974E-04_JPRB,7.8639E-04_JPRB,7.3691E-04_JPRB,&
&6.4680E-04_JPRB,6.1866E-04_JPRB,2.7731E-04_JPRB/)
KAO( :, 4, 4, 6) = (/&
&6.8974E-04_JPRB,9.2537E-04_JPRB,9.9228E-04_JPRB,1.0098E-03_JPRB,1.0044E-03_JPRB,9.6650E-04_JPRB,&
&8.8358E-04_JPRB,7.6484E-04_JPRB,3.6266E-04_JPRB/)
KAO( :, 5, 4, 6) = (/&
&8.3990E-04_JPRB,1.1361E-03_JPRB,1.2201E-03_JPRB,1.2496E-03_JPRB,1.2472E-03_JPRB,1.2194E-03_JPRB,&
&1.1540E-03_JPRB,1.0325E-03_JPRB,4.6430E-04_JPRB/)
KAO( :, 1, 5, 6) = (/&
&2.5250E-04_JPRB,3.1808E-04_JPRB,3.3386E-04_JPRB,3.2714E-04_JPRB,3.0037E-04_JPRB,2.7399E-04_JPRB,&
&2.6791E-04_JPRB,3.5704E-04_JPRB,1.2908E-04_JPRB/)
KAO( :, 2, 5, 6) = (/&
&3.3043E-04_JPRB,4.2488E-04_JPRB,4.5012E-04_JPRB,4.4889E-04_JPRB,4.2554E-04_JPRB,3.8200E-04_JPRB,&
&3.3745E-04_JPRB,3.7310E-04_JPRB,1.6348E-04_JPRB/)
KAO( :, 3, 5, 6) = (/&
&4.2316E-04_JPRB,5.5338E-04_JPRB,5.8740E-04_JPRB,5.9160E-04_JPRB,5.7542E-04_JPRB,5.3101E-04_JPRB,&
&4.6257E-04_JPRB,4.4755E-04_JPRB,2.1057E-04_JPRB/)
KAO( :, 4, 5, 6) = (/&
&5.3209E-04_JPRB,7.0370E-04_JPRB,7.4784E-04_JPRB,7.5773E-04_JPRB,7.4773E-04_JPRB,7.1163E-04_JPRB,&
&6.4170E-04_JPRB,5.6009E-04_JPRB,2.6995E-04_JPRB/)
KAO( :, 5, 5, 6) = (/&
&6.5954E-04_JPRB,8.7577E-04_JPRB,9.3136E-04_JPRB,9.4956E-04_JPRB,9.4321E-04_JPRB,9.1424E-04_JPRB,&
&8.5021E-04_JPRB,7.6505E-04_JPRB,3.4403E-04_JPRB/)
KAO( :, 1, 6, 6) = (/&
&1.8041E-04_JPRB,2.2490E-04_JPRB,2.3336E-04_JPRB,2.2464E-04_JPRB,2.0963E-04_JPRB,1.9425E-04_JPRB,&
&2.2107E-04_JPRB,2.7984E-04_JPRB,1.4894E-04_JPRB/)
KAO( :, 2, 6, 6) = (/&
&2.4129E-04_JPRB,3.0664E-04_JPRB,3.2201E-04_JPRB,3.1753E-04_JPRB,2.9432E-04_JPRB,2.6424E-04_JPRB,&
&2.4608E-04_JPRB,3.2717E-04_JPRB,1.7150E-04_JPRB/)
KAO( :, 3, 6, 6) = (/&
&3.1506E-04_JPRB,4.0665E-04_JPRB,4.2823E-04_JPRB,4.2924E-04_JPRB,4.1092E-04_JPRB,3.7075E-04_JPRB,&
&3.2608E-04_JPRB,3.0715E-04_JPRB,1.9997E-04_JPRB/)
KAO( :, 4, 6, 6) = (/&
&4.0467E-04_JPRB,5.2530E-04_JPRB,5.5383E-04_JPRB,5.5842E-04_JPRB,5.4724E-04_JPRB,5.1243E-04_JPRB,&
&4.4254E-04_JPRB,3.9888E-04_JPRB,2.3767E-04_JPRB/)
KAO( :, 5, 6, 6) = (/&
&5.1106E-04_JPRB,6.6417E-04_JPRB,6.9974E-04_JPRB,7.0967E-04_JPRB,7.0212E-04_JPRB,6.7161E-04_JPRB,&
&6.0464E-04_JPRB,5.2589E-04_JPRB,2.8598E-04_JPRB/)
KAO( :, 1, 7, 6) = (/&
&1.2786E-04_JPRB,1.5741E-04_JPRB,1.6149E-04_JPRB,1.5385E-04_JPRB,1.4113E-04_JPRB,1.3717E-04_JPRB,&
&1.7921E-04_JPRB,2.1884E-04_JPRB,2.2335E-04_JPRB/)
KAO( :, 2, 7, 6) = (/&
&1.7476E-04_JPRB,2.1914E-04_JPRB,2.2777E-04_JPRB,2.2084E-04_JPRB,2.0229E-04_JPRB,1.8812E-04_JPRB,&
&1.8018E-04_JPRB,2.7538E-04_JPRB,2.4653E-04_JPRB/)
KAO( :, 3, 7, 6) = (/&
&2.3335E-04_JPRB,2.9589E-04_JPRB,3.0942E-04_JPRB,3.0765E-04_JPRB,2.8977E-04_JPRB,2.5625E-04_JPRB,&
&2.3275E-04_JPRB,2.5170E-04_JPRB,2.7339E-04_JPRB/)
KAO( :, 4, 7, 6) = (/&
&3.0583E-04_JPRB,3.8902E-04_JPRB,4.0709E-04_JPRB,4.0819E-04_JPRB,3.9588E-04_JPRB,3.6356E-04_JPRB,&
&3.1361E-04_JPRB,2.9658E-04_JPRB,3.0348E-04_JPRB/)
KAO( :, 5, 7, 6) = (/&
&3.9359E-04_JPRB,5.0084E-04_JPRB,5.2271E-04_JPRB,5.2613E-04_JPRB,5.1742E-04_JPRB,4.8862E-04_JPRB,&
&4.3693E-04_JPRB,3.8092E-04_JPRB,3.3962E-04_JPRB/)
KAO( :, 1, 8, 6) = (/&
&9.0775E-05_JPRB,1.1005E-04_JPRB,1.1099E-04_JPRB,1.0509E-04_JPRB,9.9650E-05_JPRB,1.1055E-04_JPRB,&
&1.4832E-04_JPRB,1.7530E-04_JPRB,4.7525E-04_JPRB/)
KAO( :, 2, 8, 6) = (/&
&1.2669E-04_JPRB,1.5629E-04_JPRB,1.6068E-04_JPRB,1.5361E-04_JPRB,1.4250E-04_JPRB,1.3452E-04_JPRB,&
&1.4933E-04_JPRB,2.0310E-04_JPRB,5.0480E-04_JPRB/)
KAO( :, 3, 8, 6) = (/&
&1.7285E-04_JPRB,2.1483E-04_JPRB,2.2274E-04_JPRB,2.1837E-04_JPRB,2.0107E-04_JPRB,1.8034E-04_JPRB,&
&1.6967E-04_JPRB,2.2418E-04_JPRB,5.3971E-04_JPRB/)
KAO( :, 4, 8, 6) = (/&
&2.3078E-04_JPRB,2.8784E-04_JPRB,2.9834E-04_JPRB,2.9682E-04_JPRB,2.8348E-04_JPRB,2.5378E-04_JPRB,&
&2.1967E-04_JPRB,2.1775E-04_JPRB,5.7949E-04_JPRB/)
KAO( :, 5, 8, 6) = (/&
&3.0207E-04_JPRB,3.7730E-04_JPRB,3.9003E-04_JPRB,3.8941E-04_JPRB,3.7851E-04_JPRB,3.5314E-04_JPRB,&
&3.0320E-04_JPRB,2.7345E-04_JPRB,6.2347E-04_JPRB/)
KAO( :, 1, 9, 6) = (/&
&6.4923E-05_JPRB,7.7301E-05_JPRB,7.6873E-05_JPRB,7.2507E-05_JPRB,7.2968E-05_JPRB,8.8916E-05_JPRB,&
&1.0626E-04_JPRB,1.3047E-04_JPRB,2.1479E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&9.2060E-05_JPRB,1.1144E-04_JPRB,1.1301E-04_JPRB,1.0673E-04_JPRB,9.8741E-05_JPRB,9.7585E-05_JPRB,&
&1.2203E-04_JPRB,1.5315E-04_JPRB,2.2213E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&1.2784E-04_JPRB,1.5591E-04_JPRB,1.5957E-04_JPRB,1.5395E-04_JPRB,1.4101E-04_JPRB,1.2937E-04_JPRB,&
&1.2902E-04_JPRB,1.8269E-04_JPRB,2.3004E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&1.7362E-04_JPRB,2.1265E-04_JPRB,2.1819E-04_JPRB,2.1460E-04_JPRB,2.0088E-04_JPRB,1.7687E-04_JPRB,&
&1.6114E-04_JPRB,1.7045E-04_JPRB,2.3836E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&2.3060E-04_JPRB,2.8346E-04_JPRB,2.9069E-04_JPRB,2.8691E-04_JPRB,2.7538E-04_JPRB,2.5192E-04_JPRB,&
&2.1567E-04_JPRB,2.0242E-04_JPRB,2.4645E-03_JPRB/)
KAO( :, 1,10, 6) = (/&
&4.9625E-05_JPRB,5.7572E-05_JPRB,5.6443E-05_JPRB,5.4999E-05_JPRB,5.9435E-05_JPRB,7.0786E-05_JPRB,&
&7.6295E-05_JPRB,1.0573E-04_JPRB,1.3224E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&7.0134E-05_JPRB,8.3014E-05_JPRB,8.2620E-05_JPRB,7.7969E-05_JPRB,7.3377E-05_JPRB,8.0016E-05_JPRB,&
&9.8395E-05_JPRB,1.2266E-04_JPRB,1.3476E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&9.7838E-05_JPRB,1.1716E-04_JPRB,1.1840E-04_JPRB,1.1257E-04_JPRB,1.0247E-04_JPRB,9.5389E-05_JPRB,&
&1.0384E-04_JPRB,1.4488E-04_JPRB,1.3733E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&1.3411E-04_JPRB,1.6175E-04_JPRB,1.6407E-04_JPRB,1.5918E-04_JPRB,1.4592E-04_JPRB,1.2914E-04_JPRB,&
&1.2234E-04_JPRB,1.5601E-04_JPRB,1.4015E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&1.7947E-04_JPRB,2.1813E-04_JPRB,2.2167E-04_JPRB,2.1661E-04_JPRB,2.0497E-04_JPRB,1.8308E-04_JPRB,&
&1.5705E-04_JPRB,1.5556E-04_JPRB,1.4285E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&4.6838E-05_JPRB,5.3188E-05_JPRB,5.1940E-05_JPRB,4.9560E-05_JPRB,5.2867E-05_JPRB,6.0471E-05_JPRB,&
&6.7131E-05_JPRB,8.9235E-05_JPRB,2.9682E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&6.4771E-05_JPRB,7.4879E-05_JPRB,7.3789E-05_JPRB,6.9085E-05_JPRB,6.5402E-05_JPRB,6.9078E-05_JPRB,&
&8.2402E-05_JPRB,9.7823E-05_JPRB,3.0214E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&8.8977E-05_JPRB,1.0443E-04_JPRB,1.0449E-04_JPRB,9.8837E-05_JPRB,8.9325E-05_JPRB,8.2564E-05_JPRB,&
&9.0256E-05_JPRB,1.2264E-04_JPRB,3.0751E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&1.2031E-04_JPRB,1.4341E-04_JPRB,1.4439E-04_JPRB,1.3909E-04_JPRB,1.2684E-04_JPRB,1.1148E-04_JPRB,&
&1.0343E-04_JPRB,1.2710E-04_JPRB,3.1294E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&1.5966E-04_JPRB,1.9217E-04_JPRB,1.9445E-04_JPRB,1.8922E-04_JPRB,1.7785E-04_JPRB,1.5826E-04_JPRB,&
&1.3426E-04_JPRB,1.3572E-04_JPRB,3.1828E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&4.4013E-05_JPRB,4.9051E-05_JPRB,4.7310E-05_JPRB,4.5083E-05_JPRB,4.5655E-05_JPRB,5.3046E-05_JPRB,&
&5.5846E-05_JPRB,7.3868E-05_JPRB,4.2262E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&5.9811E-05_JPRB,6.7905E-05_JPRB,6.6450E-05_JPRB,6.1482E-05_JPRB,5.7471E-05_JPRB,5.8427E-05_JPRB,&
&7.0235E-05_JPRB,8.1755E-05_JPRB,4.3100E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&8.0771E-05_JPRB,9.3483E-05_JPRB,9.2712E-05_JPRB,8.7290E-05_JPRB,7.8335E-05_JPRB,7.2055E-05_JPRB,&
&7.5619E-05_JPRB,1.0330E-04_JPRB,4.3963E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&1.0778E-04_JPRB,1.2684E-04_JPRB,1.2706E-04_JPRB,1.2188E-04_JPRB,1.1092E-04_JPRB,9.6993E-05_JPRB,&
&8.8534E-05_JPRB,1.0545E-04_JPRB,4.4781E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&1.4170E-04_JPRB,1.6874E-04_JPRB,1.7020E-04_JPRB,1.6546E-04_JPRB,1.5470E-04_JPRB,1.3786E-04_JPRB,&
&1.1554E-04_JPRB,1.1534E-04_JPRB,4.5542E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&4.2090E-05_JPRB,4.6101E-05_JPRB,4.3965E-05_JPRB,4.1016E-05_JPRB,4.0300E-05_JPRB,4.5499E-05_JPRB,&
&4.8852E-05_JPRB,6.1759E-05_JPRB,4.8346E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&5.6243E-05_JPRB,6.2753E-05_JPRB,6.0819E-05_JPRB,5.5713E-05_JPRB,5.1322E-05_JPRB,5.0494E-05_JPRB,&
&6.0604E-05_JPRB,6.8003E-05_JPRB,4.9462E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&7.4458E-05_JPRB,8.4643E-05_JPRB,8.3343E-05_JPRB,7.8251E-05_JPRB,6.9869E-05_JPRB,6.3030E-05_JPRB,&
&6.3206E-05_JPRB,8.7133E-05_JPRB,5.0553E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&9.7702E-05_JPRB,1.1298E-04_JPRB,1.1246E-04_JPRB,1.0753E-04_JPRB,9.7507E-05_JPRB,8.4857E-05_JPRB,&
&7.6788E-05_JPRB,8.6167E-05_JPRB,5.1568E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.2694E-04_JPRB,1.4871E-04_JPRB,1.4954E-04_JPRB,1.4480E-04_JPRB,1.3473E-04_JPRB,1.1941E-04_JPRB,&
&9.9413E-05_JPRB,9.9688E-05_JPRB,5.2519E-02_JPRB/)
KAO( :, 1, 1, 7) = (/&
&2.0564E-03_JPRB,2.2357E-03_JPRB,2.2921E-03_JPRB,2.2746E-03_JPRB,2.1808E-03_JPRB,2.0118E-03_JPRB,&
&1.7401E-03_JPRB,1.3032E-03_JPRB,9.5552E-04_JPRB/)
KAO( :, 2, 1, 7) = (/&
&2.5245E-03_JPRB,2.7780E-03_JPRB,2.8722E-03_JPRB,2.8575E-03_JPRB,2.7633E-03_JPRB,2.6046E-03_JPRB,&
&2.3222E-03_JPRB,1.8131E-03_JPRB,1.3540E-03_JPRB/)
KAO( :, 3, 1, 7) = (/&
&3.0325E-03_JPRB,3.3773E-03_JPRB,3.5284E-03_JPRB,3.5242E-03_JPRB,3.4302E-03_JPRB,3.2547E-03_JPRB,&
&2.9982E-03_JPRB,2.6610E-03_JPRB,1.7942E-03_JPRB/)
KAO( :, 4, 1, 7) = (/&
&3.5774E-03_JPRB,4.0328E-03_JPRB,4.2570E-03_JPRB,4.2786E-03_JPRB,4.1734E-03_JPRB,3.9880E-03_JPRB,&
&3.7418E-03_JPRB,3.6443E-03_JPRB,2.2977E-03_JPRB/)
KAO( :, 5, 1, 7) = (/&
&4.1551E-03_JPRB,4.7493E-03_JPRB,5.0612E-03_JPRB,5.1084E-03_JPRB,4.9896E-03_JPRB,4.7828E-03_JPRB,&
&4.5388E-03_JPRB,4.6729E-03_JPRB,2.8901E-03_JPRB/)
KAO( :, 1, 2, 7) = (/&
&1.7021E-03_JPRB,1.8729E-03_JPRB,1.9247E-03_JPRB,1.9078E-03_JPRB,1.8213E-03_JPRB,1.6737E-03_JPRB,&
&1.4152E-03_JPRB,1.0410E-03_JPRB,7.2465E-04_JPRB/)
KAO( :, 2, 2, 7) = (/&
&2.1085E-03_JPRB,2.3473E-03_JPRB,2.4306E-03_JPRB,2.4189E-03_JPRB,2.3372E-03_JPRB,2.1946E-03_JPRB,&
&1.9650E-03_JPRB,1.4507E-03_JPRB,1.0070E-03_JPRB/)
KAO( :, 3, 2, 7) = (/&
&2.5539E-03_JPRB,2.8790E-03_JPRB,3.0056E-03_JPRB,3.0096E-03_JPRB,2.9218E-03_JPRB,2.7596E-03_JPRB,&
&2.5256E-03_JPRB,2.1562E-03_JPRB,1.3358E-03_JPRB/)
KAO( :, 4, 2, 7) = (/&
&3.0381E-03_JPRB,3.4689E-03_JPRB,3.6518E-03_JPRB,3.6778E-03_JPRB,3.5757E-03_JPRB,3.4032E-03_JPRB,&
&3.1678E-03_JPRB,2.9648E-03_JPRB,1.7229E-03_JPRB/)
KAO( :, 5, 2, 7) = (/&
&3.5521E-03_JPRB,4.1214E-03_JPRB,4.3704E-03_JPRB,4.4118E-03_JPRB,4.3015E-03_JPRB,4.1082E-03_JPRB,&
&3.8609E-03_JPRB,3.8044E-03_JPRB,2.1852E-03_JPRB/)
KAO( :, 1, 3, 7) = (/&
&1.3207E-03_JPRB,1.4650E-03_JPRB,1.5081E-03_JPRB,1.4879E-03_JPRB,1.4138E-03_JPRB,1.2859E-03_JPRB,&
&1.0511E-03_JPRB,7.8811E-04_JPRB,5.1479E-04_JPRB/)
KAO( :, 2, 3, 7) = (/&
&1.6600E-03_JPRB,1.8649E-03_JPRB,1.9312E-03_JPRB,1.9179E-03_JPRB,1.8422E-03_JPRB,1.7178E-03_JPRB,&
&1.5069E-03_JPRB,1.1268E-03_JPRB,7.0924E-04_JPRB/)
KAO( :, 3, 3, 7) = (/&
&2.0389E-03_JPRB,2.3205E-03_JPRB,2.4185E-03_JPRB,2.4171E-03_JPRB,2.3339E-03_JPRB,2.1929E-03_JPRB,&
&1.9846E-03_JPRB,1.6361E-03_JPRB,9.4601E-04_JPRB/)
KAO( :, 4, 3, 7) = (/&
&2.4547E-03_JPRB,2.8320E-03_JPRB,2.9726E-03_JPRB,2.9883E-03_JPRB,2.8925E-03_JPRB,2.7393E-03_JPRB,&
&2.5305E-03_JPRB,2.2455E-03_JPRB,1.2306E-03_JPRB/)
KAO( :, 5, 3, 7) = (/&
&2.8997E-03_JPRB,3.4059E-03_JPRB,3.5906E-03_JPRB,3.6183E-03_JPRB,3.5177E-03_JPRB,3.3454E-03_JPRB,&
&3.1285E-03_JPRB,2.9519E-03_JPRB,1.5729E-03_JPRB/)
KAO( :, 1, 4, 7) = (/&
&9.9106E-04_JPRB,1.1077E-03_JPRB,1.1376E-03_JPRB,1.1157E-03_JPRB,1.0521E-03_JPRB,9.4148E-04_JPRB,&
&7.8510E-04_JPRB,5.6824E-04_JPRB,3.5975E-04_JPRB/)
KAO( :, 2, 4, 7) = (/&
&1.2690E-03_JPRB,1.4351E-03_JPRB,1.4835E-03_JPRB,1.4646E-03_JPRB,1.3997E-03_JPRB,1.2889E-03_JPRB,&
&1.0960E-03_JPRB,8.9289E-04_JPRB,4.9353E-04_JPRB/)
KAO( :, 3, 4, 7) = (/&
&1.5842E-03_JPRB,1.8142E-03_JPRB,1.8866E-03_JPRB,1.8780E-03_JPRB,1.8013E-03_JPRB,1.6820E-03_JPRB,&
&1.5023E-03_JPRB,1.1830E-03_JPRB,6.6203E-04_JPRB/)
KAO( :, 4, 4, 7) = (/&
&1.9340E-03_JPRB,2.2471E-03_JPRB,2.3499E-03_JPRB,2.3511E-03_JPRB,2.2648E-03_JPRB,2.1322E-03_JPRB,&
&1.9509E-03_JPRB,1.6764E-03_JPRB,8.7194E-04_JPRB/)
KAO( :, 5, 4, 7) = (/&
&2.3113E-03_JPRB,2.7351E-03_JPRB,2.8762E-03_JPRB,2.8805E-03_JPRB,2.7879E-03_JPRB,2.6395E-03_JPRB,&
&2.4567E-03_JPRB,2.2403E-03_JPRB,1.1262E-03_JPRB/)
KAO( :, 1, 5, 7) = (/&
&7.3127E-04_JPRB,8.2296E-04_JPRB,8.4087E-04_JPRB,8.1934E-04_JPRB,7.6237E-04_JPRB,6.6355E-04_JPRB,&
&5.7712E-04_JPRB,4.2586E-04_JPRB,2.6106E-04_JPRB/)
KAO( :, 2, 5, 7) = (/&
&9.5564E-04_JPRB,1.0866E-03_JPRB,1.1175E-03_JPRB,1.0975E-03_JPRB,1.0423E-03_JPRB,9.4115E-04_JPRB,&
&7.8089E-04_JPRB,7.0271E-04_JPRB,3.5186E-04_JPRB/)
KAO( :, 3, 5, 7) = (/&
&1.2139E-03_JPRB,1.3968E-03_JPRB,1.4447E-03_JPRB,1.4289E-03_JPRB,1.3656E-03_JPRB,1.2642E-03_JPRB,&
&1.1044E-03_JPRB,8.5519E-04_JPRB,4.7090E-04_JPRB/)
KAO( :, 4, 5, 7) = (/&
&1.5030E-03_JPRB,1.7556E-03_JPRB,1.8265E-03_JPRB,1.8139E-03_JPRB,1.7423E-03_JPRB,1.6256E-03_JPRB,&
&1.4668E-03_JPRB,1.2302E-03_JPRB,6.2262E-04_JPRB/)
KAO( :, 5, 5, 7) = (/&
&1.8204E-03_JPRB,2.1651E-03_JPRB,2.2625E-03_JPRB,2.2502E-03_JPRB,2.1716E-03_JPRB,2.0469E-03_JPRB,&
&1.8925E-03_JPRB,1.6626E-03_JPRB,8.1240E-04_JPRB/)
KAO( :, 1, 6, 7) = (/&
&5.2529E-04_JPRB,5.9432E-04_JPRB,6.0352E-04_JPRB,5.8305E-04_JPRB,5.3304E-04_JPRB,4.5328E-04_JPRB,&
&4.1878E-04_JPRB,3.5780E-04_JPRB,2.4217E-04_JPRB/)
KAO( :, 2, 6, 7) = (/&
&7.0212E-04_JPRB,8.0206E-04_JPRB,8.1885E-04_JPRB,8.0064E-04_JPRB,7.5267E-04_JPRB,6.6720E-04_JPRB,&
&5.4925E-04_JPRB,4.7137E-04_JPRB,2.9304E-04_JPRB/)
KAO( :, 3, 6, 7) = (/&
&9.0974E-04_JPRB,1.0505E-03_JPRB,1.0784E-03_JPRB,1.0608E-03_JPRB,1.0082E-03_JPRB,9.2191E-04_JPRB,&
&7.8184E-04_JPRB,6.5554E-04_JPRB,3.6650E-04_JPRB/)
KAO( :, 4, 6, 7) = (/&
&1.1453E-03_JPRB,1.3423E-03_JPRB,1.3852E-03_JPRB,1.3677E-03_JPRB,1.3077E-03_JPRB,1.2097E-03_JPRB,&
&1.0767E-03_JPRB,8.5645E-04_JPRB,4.6653E-04_JPRB/)
KAO( :, 5, 6, 7) = (/&
&1.4081E-03_JPRB,1.6785E-03_JPRB,1.7408E-03_JPRB,1.7212E-03_JPRB,1.6525E-03_JPRB,1.5502E-03_JPRB,&
&1.4183E-03_JPRB,1.2157E-03_JPRB,5.9973E-04_JPRB/)
KAO( :, 1, 7, 7) = (/&
&3.7120E-04_JPRB,4.2080E-04_JPRB,4.2477E-04_JPRB,4.0604E-04_JPRB,3.6355E-04_JPRB,3.1468E-04_JPRB,&
&2.7452E-04_JPRB,3.0003E-04_JPRB,3.4329E-04_JPRB/)
KAO( :, 2, 7, 7) = (/&
&5.0811E-04_JPRB,5.8113E-04_JPRB,5.8975E-04_JPRB,5.7433E-04_JPRB,5.3282E-04_JPRB,4.5716E-04_JPRB,&
&3.8591E-04_JPRB,3.1558E-04_JPRB,3.8021E-04_JPRB/)
KAO( :, 3, 7, 7) = (/&
&6.7189E-04_JPRB,7.7708E-04_JPRB,7.9243E-04_JPRB,7.7528E-04_JPRB,7.3224E-04_JPRB,6.5998E-04_JPRB,&
&5.4384E-04_JPRB,5.0808E-04_JPRB,4.2510E-04_JPRB/)
KAO( :, 4, 7, 7) = (/&
&8.6172E-04_JPRB,1.0111E-03_JPRB,1.0357E-03_JPRB,1.0171E-03_JPRB,9.6771E-04_JPRB,8.8863E-04_JPRB,&
&7.7053E-04_JPRB,5.9901E-04_JPRB,4.8327E-04_JPRB/)
KAO( :, 5, 7, 7) = (/&
&1.0762E-03_JPRB,1.2838E-03_JPRB,1.3208E-03_JPRB,1.3007E-03_JPRB,1.2428E-03_JPRB,1.1566E-03_JPRB,&
&1.0378E-03_JPRB,8.6101E-04_JPRB,5.6256E-04_JPRB/)
KAO( :, 1, 8, 7) = (/&
&2.6005E-04_JPRB,2.9445E-04_JPRB,2.9544E-04_JPRB,2.7954E-04_JPRB,2.4583E-04_JPRB,2.1647E-04_JPRB,&
&1.8002E-04_JPRB,2.3598E-04_JPRB,7.9092E-04_JPRB/)
KAO( :, 2, 8, 7) = (/&
&3.6459E-04_JPRB,4.1637E-04_JPRB,4.2010E-04_JPRB,4.0556E-04_JPRB,3.7047E-04_JPRB,3.0940E-04_JPRB,&
&2.7524E-04_JPRB,2.5435E-04_JPRB,8.3476E-04_JPRB/)
KAO( :, 3, 8, 7) = (/&
&4.9221E-04_JPRB,5.6877E-04_JPRB,5.7633E-04_JPRB,5.6089E-04_JPRB,5.2598E-04_JPRB,4.6466E-04_JPRB,&
&3.7776E-04_JPRB,3.4121E-04_JPRB,8.7965E-04_JPRB/)
KAO( :, 4, 8, 7) = (/&
&6.4351E-04_JPRB,7.5336E-04_JPRB,7.6684E-04_JPRB,7.4955E-04_JPRB,7.0992E-04_JPRB,6.4867E-04_JPRB,&
&5.4671E-04_JPRB,4.4943E-04_JPRB,9.3048E-04_JPRB/)
KAO( :, 5, 8, 7) = (/&
&8.1696E-04_JPRB,9.7167E-04_JPRB,9.9275E-04_JPRB,9.7485E-04_JPRB,9.2841E-04_JPRB,8.5440E-04_JPRB,&
&7.5642E-04_JPRB,5.9342E-04_JPRB,9.8996E-04_JPRB/)
KAO( :, 1, 9, 7) = (/&
&1.8087E-04_JPRB,2.0393E-04_JPRB,2.0319E-04_JPRB,1.8996E-04_JPRB,1.6599E-04_JPRB,1.4845E-04_JPRB,&
&1.4517E-04_JPRB,1.8943E-04_JPRB,3.7840E-03_JPRB/)
KAO( :, 2, 9, 7) = (/&
&2.5947E-04_JPRB,2.9518E-04_JPRB,2.9598E-04_JPRB,2.8323E-04_JPRB,2.5237E-04_JPRB,2.1334E-04_JPRB,&
&1.9297E-04_JPRB,2.0265E-04_JPRB,3.8746E-03_JPRB/)
KAO( :, 3, 9, 7) = (/&
&3.5788E-04_JPRB,4.1170E-04_JPRB,4.1507E-04_JPRB,4.0085E-04_JPRB,3.7117E-04_JPRB,3.1718E-04_JPRB,&
&2.6164E-04_JPRB,2.2715E-04_JPRB,3.9645E-03_JPRB/)
KAO( :, 4, 9, 7) = (/&
&4.7699E-04_JPRB,5.5569E-04_JPRB,5.6204E-04_JPRB,5.4699E-04_JPRB,5.1526E-04_JPRB,4.6408E-04_JPRB,&
&3.7784E-04_JPRB,3.4199E-04_JPRB,4.0560E-03_JPRB/)
KAO( :, 5, 9, 7) = (/&
&6.1621E-04_JPRB,7.2836E-04_JPRB,7.3953E-04_JPRB,7.2389E-04_JPRB,6.8675E-04_JPRB,6.2690E-04_JPRB,&
&5.4244E-04_JPRB,4.1506E-04_JPRB,4.1481E-03_JPRB/)
KAO( :, 1,10, 7) = (/&
&1.3094E-04_JPRB,1.4617E-04_JPRB,1.4409E-04_JPRB,1.3166E-04_JPRB,1.1671E-04_JPRB,1.0840E-04_JPRB,&
&1.1994E-04_JPRB,1.5334E-04_JPRB,2.4678E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&1.9036E-04_JPRB,2.1493E-04_JPRB,2.1399E-04_JPRB,2.0239E-04_JPRB,1.7779E-04_JPRB,1.5202E-04_JPRB,&
&1.3461E-04_JPRB,1.6391E-04_JPRB,2.4818E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&2.6670E-04_JPRB,3.0451E-04_JPRB,3.0518E-04_JPRB,2.9252E-04_JPRB,2.6713E-04_JPRB,2.2545E-04_JPRB,&
&1.9430E-04_JPRB,1.7654E-04_JPRB,2.4944E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&3.6077E-04_JPRB,4.1729E-04_JPRB,4.1982E-04_JPRB,4.0619E-04_JPRB,3.7979E-04_JPRB,3.3605E-04_JPRB,&
&2.6665E-04_JPRB,2.5064E-04_JPRB,2.5043E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&4.7368E-04_JPRB,5.5457E-04_JPRB,5.6006E-04_JPRB,5.4560E-04_JPRB,5.1520E-04_JPRB,4.6682E-04_JPRB,&
&3.9587E-04_JPRB,3.0490E-04_JPRB,2.5182E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&1.1672E-04_JPRB,1.2865E-04_JPRB,1.2575E-04_JPRB,1.1552E-04_JPRB,1.0159E-04_JPRB,9.2164E-05_JPRB,&
&9.9270E-05_JPRB,1.2653E-04_JPRB,5.7559E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&1.6732E-04_JPRB,1.8741E-04_JPRB,1.8550E-04_JPRB,1.7442E-04_JPRB,1.5354E-04_JPRB,1.3133E-04_JPRB,&
&1.1767E-04_JPRB,1.4329E-04_JPRB,5.7684E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&2.3276E-04_JPRB,2.6444E-04_JPRB,2.6342E-04_JPRB,2.5118E-04_JPRB,2.2884E-04_JPRB,1.9264E-04_JPRB,&
&1.6524E-04_JPRB,1.4558E-04_JPRB,5.7855E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&3.1443E-04_JPRB,3.6154E-04_JPRB,3.6203E-04_JPRB,3.4857E-04_JPRB,3.2499E-04_JPRB,2.8713E-04_JPRB,&
&2.2934E-04_JPRB,2.1182E-04_JPRB,5.7981E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&4.1392E-04_JPRB,4.8111E-04_JPRB,4.8318E-04_JPRB,4.6852E-04_JPRB,4.4073E-04_JPRB,3.9804E-04_JPRB,&
&3.3719E-04_JPRB,2.5664E-04_JPRB,5.8015E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&1.0495E-04_JPRB,1.1425E-04_JPRB,1.1065E-04_JPRB,1.0139E-04_JPRB,8.8702E-05_JPRB,8.0270E-05_JPRB,&
&8.3227E-05_JPRB,1.1035E-04_JPRB,8.4777E-02_JPRB/)
KAO( :, 2,12, 7) = (/&
&1.4811E-04_JPRB,1.6444E-04_JPRB,1.6133E-04_JPRB,1.5088E-04_JPRB,1.3304E-04_JPRB,1.1329E-04_JPRB,&
&1.0211E-04_JPRB,1.1814E-04_JPRB,8.5052E-02_JPRB/)
KAO( :, 3,12, 7) = (/&
&2.0461E-04_JPRB,2.3053E-04_JPRB,2.2799E-04_JPRB,2.1647E-04_JPRB,1.9655E-04_JPRB,1.6510E-04_JPRB,&
&1.3813E-04_JPRB,1.2052E-04_JPRB,8.5320E-02_JPRB/)
KAO( :, 4,12, 7) = (/&
&2.7614E-04_JPRB,3.1483E-04_JPRB,3.1311E-04_JPRB,3.0005E-04_JPRB,2.7866E-04_JPRB,2.4569E-04_JPRB,&
&1.9595E-04_JPRB,1.7650E-04_JPRB,8.5551E-02_JPRB/)
KAO( :, 5,12, 7) = (/&
&3.6369E-04_JPRB,4.1945E-04_JPRB,4.1876E-04_JPRB,4.0374E-04_JPRB,3.7792E-04_JPRB,3.3990E-04_JPRB,&
&2.8821E-04_JPRB,2.1660E-04_JPRB,8.5586E-02_JPRB/)
KAO( :, 1,13, 7) = (/&
&9.6451E-05_JPRB,1.0341E-04_JPRB,9.9264E-05_JPRB,9.0436E-05_JPRB,7.8283E-05_JPRB,7.1353E-05_JPRB,&
&7.0038E-05_JPRB,8.7127E-05_JPRB,1.0017E-01_JPRB/)
KAO( :, 2,13, 7) = (/&
&1.3353E-04_JPRB,1.4634E-04_JPRB,1.4212E-04_JPRB,1.3211E-04_JPRB,1.1628E-04_JPRB,9.7846E-05_JPRB,&
&8.8593E-05_JPRB,9.9520E-05_JPRB,1.0066E-01_JPRB/)
KAO( :, 3,13, 7) = (/&
&1.8247E-04_JPRB,2.0319E-04_JPRB,1.9922E-04_JPRB,1.8770E-04_JPRB,1.6984E-04_JPRB,1.4285E-04_JPRB,&
&1.1822E-04_JPRB,1.0096E-04_JPRB,1.0114E-01_JPRB/)
KAO( :, 4,13, 7) = (/&
&2.4463E-04_JPRB,2.7635E-04_JPRB,2.7262E-04_JPRB,2.5991E-04_JPRB,2.4023E-04_JPRB,2.1109E-04_JPRB,&
&1.6739E-04_JPRB,1.4711E-04_JPRB,1.0151E-01_JPRB/)
KAO( :, 5,13, 7) = (/&
&3.2023E-04_JPRB,3.6781E-04_JPRB,3.6463E-04_JPRB,3.4949E-04_JPRB,3.2644E-04_JPRB,2.9244E-04_JPRB,&
&2.4737E-04_JPRB,1.8188E-04_JPRB,1.0162E-01_JPRB/)
KAO( :, 1, 1, 8) = (/&
&4.4239E-03_JPRB,4.5519E-03_JPRB,4.5724E-03_JPRB,4.4178E-03_JPRB,4.2198E-03_JPRB,4.0058E-03_JPRB,&
&3.6615E-03_JPRB,3.0019E-03_JPRB,2.7752E-03_JPRB/)
KAO( :, 2, 1, 8) = (/&
&5.3797E-03_JPRB,5.6034E-03_JPRB,5.6810E-03_JPRB,5.5458E-03_JPRB,5.3768E-03_JPRB,5.2131E-03_JPRB,&
&5.0349E-03_JPRB,4.6587E-03_JPRB,3.8056E-03_JPRB/)
KAO( :, 3, 1, 8) = (/&
&6.4347E-03_JPRB,6.7859E-03_JPRB,6.9273E-03_JPRB,6.8482E-03_JPRB,6.7118E-03_JPRB,6.6177E-03_JPRB,&
&6.6013E-03_JPRB,6.5225E-03_JPRB,5.0401E-03_JPRB/)
KAO( :, 4, 1, 8) = (/&
&7.5645E-03_JPRB,8.0892E-03_JPRB,8.3352E-03_JPRB,8.3083E-03_JPRB,8.2560E-03_JPRB,8.2611E-03_JPRB,&
&8.3847E-03_JPRB,8.5252E-03_JPRB,6.4996E-03_JPRB/)
KAO( :, 5, 1, 8) = (/&
&8.7680E-03_JPRB,9.5130E-03_JPRB,9.8898E-03_JPRB,9.9473E-03_JPRB,1.0011E-02_JPRB,1.0143E-02_JPRB,&
&1.0425E-02_JPRB,1.0769E-02_JPRB,8.2076E-03_JPRB/)
KAO( :, 1, 2, 8) = (/&
&3.8956E-03_JPRB,4.0502E-03_JPRB,4.0603E-03_JPRB,3.9353E-03_JPRB,3.7465E-03_JPRB,3.4739E-03_JPRB,&
&3.0905E-03_JPRB,2.3943E-03_JPRB,2.1184E-03_JPRB/)
KAO( :, 2, 2, 8) = (/&
&4.7918E-03_JPRB,5.0484E-03_JPRB,5.0971E-03_JPRB,4.9960E-03_JPRB,4.7901E-03_JPRB,4.5311E-03_JPRB,&
&4.2459E-03_JPRB,3.8455E-03_JPRB,2.9268E-03_JPRB/)
KAO( :, 3, 2, 8) = (/&
&5.7854E-03_JPRB,6.1757E-03_JPRB,6.2838E-03_JPRB,6.2127E-03_JPRB,6.0071E-03_JPRB,5.7828E-03_JPRB,&
&5.6083E-03_JPRB,5.4427E-03_JPRB,3.9021E-03_JPRB/)
KAO( :, 4, 2, 8) = (/&
&6.8580E-03_JPRB,7.4217E-03_JPRB,7.6327E-03_JPRB,7.5901E-03_JPRB,7.4062E-03_JPRB,7.2358E-03_JPRB,&
&7.1625E-03_JPRB,7.2397E-03_JPRB,5.0676E-03_JPRB/)
KAO( :, 5, 2, 8) = (/&
&8.0102E-03_JPRB,8.7860E-03_JPRB,9.1257E-03_JPRB,9.1299E-03_JPRB,8.9977E-03_JPRB,8.9056E-03_JPRB,&
&8.9466E-03_JPRB,9.2132E-03_JPRB,6.4234E-03_JPRB/)
KAO( :, 1, 3, 8) = (/&
&3.2185E-03_JPRB,3.3667E-03_JPRB,3.3683E-03_JPRB,3.2709E-03_JPRB,3.1158E-03_JPRB,2.8506E-03_JPRB,&
&2.4272E-03_JPRB,1.7393E-03_JPRB,1.4905E-03_JPRB/)
KAO( :, 2, 3, 8) = (/&
&4.0272E-03_JPRB,4.2617E-03_JPRB,4.2966E-03_JPRB,4.2148E-03_JPRB,4.0495E-03_JPRB,3.7679E-03_JPRB,&
&3.4096E-03_JPRB,2.8817E-03_JPRB,2.0706E-03_JPRB/)
KAO( :, 3, 3, 8) = (/&
&4.9255E-03_JPRB,5.2838E-03_JPRB,5.3750E-03_JPRB,5.3109E-03_JPRB,5.1338E-03_JPRB,4.8398E-03_JPRB,&
&4.5501E-03_JPRB,4.1909E-03_JPRB,2.7937E-03_JPRB/)
KAO( :, 4, 3, 8) = (/&
&5.9079E-03_JPRB,6.4325E-03_JPRB,6.6107E-03_JPRB,6.5630E-03_JPRB,6.3820E-03_JPRB,6.0909E-03_JPRB,&
&5.8611E-03_JPRB,5.7562E-03_JPRB,3.6692E-03_JPRB/)
KAO( :, 5, 3, 8) = (/&
&6.9696E-03_JPRB,7.6975E-03_JPRB,7.9877E-03_JPRB,7.9811E-03_JPRB,7.8040E-03_JPRB,7.5290E-03_JPRB,&
&7.3615E-03_JPRB,7.4650E-03_JPRB,4.7053E-03_JPRB/)
KAO( :, 1, 4, 8) = (/&
&2.5545E-03_JPRB,2.6859E-03_JPRB,2.6880E-03_JPRB,2.6203E-03_JPRB,2.4823E-03_JPRB,2.2588E-03_JPRB,&
&1.8322E-03_JPRB,1.2713E-03_JPRB,1.0214E-03_JPRB/)
KAO( :, 2, 4, 8) = (/&
&3.2572E-03_JPRB,3.4677E-03_JPRB,3.4957E-03_JPRB,3.4378E-03_JPRB,3.2931E-03_JPRB,3.0601E-03_JPRB,&
&2.6717E-03_JPRB,2.0170E-03_JPRB,1.4352E-03_JPRB/)
KAO( :, 3, 4, 8) = (/&
&4.0447E-03_JPRB,4.3684E-03_JPRB,4.4456E-03_JPRB,4.3951E-03_JPRB,4.2405E-03_JPRB,3.9923E-03_JPRB,&
&3.6333E-03_JPRB,3.0944E-03_JPRB,1.9579E-03_JPRB/)
KAO( :, 4, 4, 8) = (/&
&4.9198E-03_JPRB,5.3921E-03_JPRB,5.5389E-03_JPRB,5.5062E-03_JPRB,5.3434E-03_JPRB,5.0807E-03_JPRB,&
&4.7402E-03_JPRB,4.4587E-03_JPRB,2.6028E-03_JPRB/)
KAO( :, 5, 4, 8) = (/&
&5.8819E-03_JPRB,6.5317E-03_JPRB,6.7822E-03_JPRB,6.7765E-03_JPRB,6.6162E-03_JPRB,6.3253E-03_JPRB,&
&5.9954E-03_JPRB,5.8840E-03_JPRB,3.3755E-03_JPRB/)
KAO( :, 1, 5, 8) = (/&
&1.9756E-03_JPRB,2.0856E-03_JPRB,2.0921E-03_JPRB,2.0392E-03_JPRB,1.9309E-03_JPRB,1.7377E-03_JPRB,&
&1.3394E-03_JPRB,9.1353E-04_JPRB,7.0438E-04_JPRB/)
KAO( :, 2, 5, 8) = (/&
&2.5687E-03_JPRB,2.7468E-03_JPRB,2.7774E-03_JPRB,2.7346E-03_JPRB,2.6141E-03_JPRB,2.4178E-03_JPRB,&
&2.0843E-03_JPRB,1.3471E-03_JPRB,9.9854E-04_JPRB/)
KAO( :, 3, 5, 8) = (/&
&3.2454E-03_JPRB,3.5226E-03_JPRB,3.5942E-03_JPRB,3.5589E-03_JPRB,3.4246E-03_JPRB,3.2139E-03_JPRB,&
&2.8968E-03_JPRB,2.2808E-03_JPRB,1.3756E-03_JPRB/)
KAO( :, 4, 5, 8) = (/&
&4.0078E-03_JPRB,4.4135E-03_JPRB,4.5464E-03_JPRB,4.5227E-03_JPRB,4.3801E-03_JPRB,4.1565E-03_JPRB,&
&3.8227E-03_JPRB,3.4129E-03_JPRB,1.8460E-03_JPRB/)
KAO( :, 5, 5, 8) = (/&
&4.8571E-03_JPRB,5.4208E-03_JPRB,5.6379E-03_JPRB,5.6316E-03_JPRB,5.4908E-03_JPRB,5.2408E-03_JPRB,&
&4.8842E-03_JPRB,4.5932E-03_JPRB,2.4240E-03_JPRB/)
KAO( :, 1, 6, 8) = (/&
&1.4751E-03_JPRB,1.5649E-03_JPRB,1.5698E-03_JPRB,1.5250E-03_JPRB,1.4367E-03_JPRB,1.2692E-03_JPRB,&
&9.2432E-04_JPRB,6.8601E-04_JPRB,5.0937E-04_JPRB/)
KAO( :, 2, 6, 8) = (/&
&1.9613E-03_JPRB,2.1071E-03_JPRB,2.1348E-03_JPRB,2.0943E-03_JPRB,1.9976E-03_JPRB,1.8330E-03_JPRB,&
&1.5334E-03_JPRB,9.4512E-04_JPRB,7.0634E-04_JPRB/)
KAO( :, 3, 6, 8) = (/&
&2.5283E-03_JPRB,2.7572E-03_JPRB,2.8184E-03_JPRB,2.7830E-03_JPRB,2.6756E-03_JPRB,2.5003E-03_JPRB,&
&2.2237E-03_JPRB,1.6320E-03_JPRB,9.7275E-04_JPRB/)
KAO( :, 4, 6, 8) = (/&
&3.1771E-03_JPRB,3.5120E-03_JPRB,3.6225E-03_JPRB,3.5959E-03_JPRB,3.4819E-03_JPRB,3.2887E-03_JPRB,&
&3.0155E-03_JPRB,2.5468E-03_JPRB,1.3152E-03_JPRB/)
KAO( :, 5, 6, 8) = (/&
&3.9082E-03_JPRB,4.3796E-03_JPRB,4.5491E-03_JPRB,4.5475E-03_JPRB,4.4280E-03_JPRB,4.2073E-03_JPRB,&
&3.9106E-03_JPRB,3.5240E-03_JPRB,1.7410E-03_JPRB/)
KAO( :, 1, 7, 8) = (/&
&1.0756E-03_JPRB,1.1457E-03_JPRB,1.1474E-03_JPRB,1.1092E-03_JPRB,1.0328E-03_JPRB,8.8328E-04_JPRB,&
&6.4847E-04_JPRB,4.9589E-04_JPRB,5.7093E-04_JPRB/)
KAO( :, 2, 7, 8) = (/&
&1.4649E-03_JPRB,1.5820E-03_JPRB,1.5990E-03_JPRB,1.5629E-03_JPRB,1.4809E-03_JPRB,1.3423E-03_JPRB,&
&1.0733E-03_JPRB,6.5945E-04_JPRB,6.7059E-04_JPRB/)
KAO( :, 3, 7, 8) = (/&
&1.9283E-03_JPRB,2.1130E-03_JPRB,2.1564E-03_JPRB,2.1214E-03_JPRB,2.0320E-03_JPRB,1.8875E-03_JPRB,&
&1.6475E-03_JPRB,1.0998E-03_JPRB,8.2028E-04_JPRB/)
KAO( :, 4, 7, 8) = (/&
&2.4693E-03_JPRB,2.7409E-03_JPRB,2.8220E-03_JPRB,2.7928E-03_JPRB,2.6936E-03_JPRB,2.5390E-03_JPRB,&
&2.3115E-03_JPRB,1.8751E-03_JPRB,1.0332E-03_JPRB/)
KAO( :, 5, 7, 8) = (/&
&3.0886E-03_JPRB,3.4749E-03_JPRB,3.5989E-03_JPRB,3.5853E-03_JPRB,3.4794E-03_JPRB,3.3014E-03_JPRB,&
&3.0555E-03_JPRB,2.6855E-03_JPRB,1.3202E-03_JPRB/)
KAO( :, 1, 8, 8) = (/&
&7.7013E-04_JPRB,8.2269E-04_JPRB,8.2096E-04_JPRB,7.8766E-04_JPRB,7.2051E-04_JPRB,5.9734E-04_JPRB,&
&4.5221E-04_JPRB,3.6815E-04_JPRB,1.2465E-03_JPRB/)
KAO( :, 2, 8, 8) = (/&
&1.0761E-03_JPRB,1.1666E-03_JPRB,1.1753E-03_JPRB,1.1418E-03_JPRB,1.0747E-03_JPRB,9.5486E-04_JPRB,&
&7.2722E-04_JPRB,4.9024E-04_JPRB,1.3265E-03_JPRB/)
KAO( :, 3, 8, 8) = (/&
&1.4486E-03_JPRB,1.5933E-03_JPRB,1.6206E-03_JPRB,1.5872E-03_JPRB,1.5112E-03_JPRB,1.3931E-03_JPRB,&
&1.1791E-03_JPRB,7.7032E-04_JPRB,1.4183E-03_JPRB/)
KAO( :, 4, 8, 8) = (/&
&1.8914E-03_JPRB,2.1096E-03_JPRB,2.1595E-03_JPRB,2.1285E-03_JPRB,2.0449E-03_JPRB,1.9150E-03_JPRB,&
&1.7248E-03_JPRB,1.3234E-03_JPRB,1.5297E-03_JPRB/)
KAO( :, 5, 8, 8) = (/&
&2.4078E-03_JPRB,2.7196E-03_JPRB,2.8008E-03_JPRB,2.7757E-03_JPRB,2.6827E-03_JPRB,2.5404E-03_JPRB,&
&2.3451E-03_JPRB,2.0264E-03_JPRB,1.6770E-03_JPRB/)
KAO( :, 1, 9, 8) = (/&
&5.4062E-04_JPRB,5.7894E-04_JPRB,5.7406E-04_JPRB,5.4447E-04_JPRB,4.8698E-04_JPRB,3.9028E-04_JPRB,&
&3.0735E-04_JPRB,2.8186E-04_JPRB,6.3377E-03_JPRB/)
KAO( :, 2, 9, 8) = (/&
&7.7655E-04_JPRB,8.4391E-04_JPRB,8.4599E-04_JPRB,8.1629E-04_JPRB,7.6016E-04_JPRB,6.5450E-04_JPRB,&
&4.7980E-04_JPRB,3.6416E-04_JPRB,6.4305E-03_JPRB/)
KAO( :, 3, 9, 8) = (/&
&1.0705E-03_JPRB,1.1799E-03_JPRB,1.1936E-03_JPRB,1.1638E-03_JPRB,1.1017E-03_JPRB,1.0023E-03_JPRB,&
&8.1517E-04_JPRB,5.4679E-04_JPRB,6.5495E-03_JPRB/)
KAO( :, 4, 9, 8) = (/&
&1.4270E-03_JPRB,1.5951E-03_JPRB,1.6232E-03_JPRB,1.5910E-03_JPRB,1.5219E-03_JPRB,1.4168E-03_JPRB,&
&1.2519E-03_JPRB,8.7875E-04_JPRB,6.6729E-03_JPRB/)
KAO( :, 5, 9, 8) = (/&
&1.8505E-03_JPRB,2.0950E-03_JPRB,2.1415E-03_JPRB,2.1108E-03_JPRB,2.0308E-03_JPRB,1.9153E-03_JPRB,&
&1.7561E-03_JPRB,1.4678E-03_JPRB,6.8190E-03_JPRB/)
KAO( :, 1,10, 8) = (/&
&3.8585E-04_JPRB,4.1375E-04_JPRB,4.0806E-04_JPRB,3.8295E-04_JPRB,3.3374E-04_JPRB,2.6302E-04_JPRB,&
&2.1519E-04_JPRB,2.1943E-04_JPRB,4.4307E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&5.6783E-04_JPRB,6.1776E-04_JPRB,6.1659E-04_JPRB,5.9118E-04_JPRB,5.4276E-04_JPRB,4.5386E-04_JPRB,&
&3.3714E-04_JPRB,2.8172E-04_JPRB,4.4039E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&7.9994E-04_JPRB,8.8269E-04_JPRB,8.8820E-04_JPRB,8.6201E-04_JPRB,8.1182E-04_JPRB,7.2562E-04_JPRB,&
&5.6386E-04_JPRB,3.8153E-04_JPRB,4.3887E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&1.0873E-03_JPRB,1.2167E-03_JPRB,1.2305E-03_JPRB,1.2016E-03_JPRB,1.1439E-03_JPRB,1.0569E-03_JPRB,&
&9.1489E-04_JPRB,6.0012E-04_JPRB,4.3695E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&1.4329E-03_JPRB,1.6260E-03_JPRB,1.6511E-03_JPRB,1.6186E-03_JPRB,1.5509E-03_JPRB,1.4549E-03_JPRB,&
&1.3198E-03_JPRB,1.0619E-03_JPRB,4.3454E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&3.3331E-04_JPRB,3.5859E-04_JPRB,3.5347E-04_JPRB,3.3213E-04_JPRB,2.8916E-04_JPRB,2.2877E-04_JPRB,&
&1.7900E-04_JPRB,1.9967E-04_JPRB,1.0878E-01_JPRB/)
KAO( :, 2,11, 8) = (/&
&4.9047E-04_JPRB,5.3552E-04_JPRB,5.3381E-04_JPRB,5.1299E-04_JPRB,4.7115E-04_JPRB,3.9388E-04_JPRB,&
&2.9080E-04_JPRB,2.3623E-04_JPRB,1.0793E-01_JPRB/)
KAO( :, 3,11, 8) = (/&
&6.9278E-04_JPRB,7.6757E-04_JPRB,7.7025E-04_JPRB,7.4755E-04_JPRB,7.0442E-04_JPRB,6.3244E-04_JPRB,&
&4.9501E-04_JPRB,3.3029E-04_JPRB,1.0687E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&9.4454E-04_JPRB,1.0621E-03_JPRB,1.0699E-03_JPRB,1.0431E-03_JPRB,9.9167E-04_JPRB,9.1658E-04_JPRB,&
&7.9795E-04_JPRB,5.4407E-04_JPRB,1.0586E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&1.2469E-03_JPRB,1.4253E-03_JPRB,1.4411E-03_JPRB,1.4083E-03_JPRB,1.3458E-03_JPRB,1.2607E-03_JPRB,&
&1.1470E-03_JPRB,9.3092E-04_JPRB,1.0499E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&2.8868E-04_JPRB,3.1016E-04_JPRB,3.0546E-04_JPRB,2.8704E-04_JPRB,2.5147E-04_JPRB,1.9676E-04_JPRB,&
&1.5529E-04_JPRB,1.6943E-04_JPRB,1.6800E-01_JPRB/)
KAO( :, 2,12, 8) = (/&
&4.2419E-04_JPRB,4.6341E-04_JPRB,4.6115E-04_JPRB,4.4308E-04_JPRB,4.0808E-04_JPRB,3.4351E-04_JPRB,&
&2.4857E-04_JPRB,1.9580E-04_JPRB,1.6656E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&6.0023E-04_JPRB,6.6617E-04_JPRB,6.6650E-04_JPRB,6.4587E-04_JPRB,6.0783E-04_JPRB,5.4736E-04_JPRB,&
&4.3585E-04_JPRB,2.8774E-04_JPRB,1.6485E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&8.1906E-04_JPRB,9.2524E-04_JPRB,9.2921E-04_JPRB,9.0286E-04_JPRB,8.5627E-04_JPRB,7.9080E-04_JPRB,&
&6.9052E-04_JPRB,4.8039E-04_JPRB,1.6324E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&1.0839E-03_JPRB,1.2432E-03_JPRB,1.2546E-03_JPRB,1.2224E-03_JPRB,1.1638E-03_JPRB,1.0874E-03_JPRB,&
&9.8876E-04_JPRB,8.1388E-04_JPRB,1.6195E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&2.5312E-04_JPRB,2.6982E-04_JPRB,2.6458E-04_JPRB,2.4857E-04_JPRB,2.1806E-04_JPRB,1.7081E-04_JPRB,&
&1.3117E-04_JPRB,1.3895E-04_JPRB,2.0739E-01_JPRB/)
KAO( :, 2,13, 8) = (/&
&3.6904E-04_JPRB,4.0143E-04_JPRB,3.9817E-04_JPRB,3.8186E-04_JPRB,3.5137E-04_JPRB,2.9757E-04_JPRB,&
&2.1658E-04_JPRB,1.6379E-04_JPRB,2.0586E-01_JPRB/)
KAO( :, 3,13, 8) = (/&
&5.2080E-04_JPRB,5.7811E-04_JPRB,5.7661E-04_JPRB,5.5693E-04_JPRB,5.2224E-04_JPRB,4.6985E-04_JPRB,&
&3.7580E-04_JPRB,2.4807E-04_JPRB,2.0409E-01_JPRB/)
KAO( :, 4,13, 8) = (/&
&7.1123E-04_JPRB,8.0344E-04_JPRB,8.0567E-04_JPRB,7.8029E-04_JPRB,7.3718E-04_JPRB,6.7848E-04_JPRB,&
&5.9304E-04_JPRB,4.2232E-04_JPRB,2.0245E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&9.4485E-04_JPRB,1.0811E-03_JPRB,1.0875E-03_JPRB,1.0578E-03_JPRB,1.0044E-03_JPRB,9.3443E-04_JPRB,&
&8.4723E-04_JPRB,7.0315E-04_JPRB,2.0129E-01_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB5_A1
