!OCL SCALAR
SUBROUTINE RRTM_KGB4_B3

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO4 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO
USE YOERRTA4 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 6, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*H2O), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 9) = (/&
&2.1640E+00_JPRB,2.1630E+00_JPRB,1.9037E+00_JPRB,1.9914E+00_JPRB,2.1507E+00_JPRB,2.1924E+00_JPRB/)
KBO( :, 2,13, 9) = (/&
&2.1780E+00_JPRB,2.1770E+00_JPRB,1.9043E+00_JPRB,1.9692E+00_JPRB,2.1183E+00_JPRB,2.1702E+00_JPRB/)
KBO( :, 3,13, 9) = (/&
&2.1863E+00_JPRB,2.1853E+00_JPRB,1.9004E+00_JPRB,1.9443E+00_JPRB,2.0822E+00_JPRB,2.1533E+00_JPRB/)
KBO( :, 4,13, 9) = (/&
&2.1908E+00_JPRB,2.1898E+00_JPRB,1.8939E+00_JPRB,1.9183E+00_JPRB,2.0440E+00_JPRB,2.1390E+00_JPRB/)
KBO( :, 5,13, 9) = (/&
&2.1905E+00_JPRB,2.1895E+00_JPRB,1.8836E+00_JPRB,1.8902E+00_JPRB,2.0042E+00_JPRB,2.1255E+00_JPRB/)
KBO( :, 1,14, 9) = (/&
&1.9847E+00_JPRB,1.9838E+00_JPRB,1.8303E+00_JPRB,2.0353E+00_JPRB,2.2590E+00_JPRB,2.3088E+00_JPRB/)
KBO( :, 2,14, 9) = (/&
&1.9934E+00_JPRB,1.9925E+00_JPRB,1.8250E+00_JPRB,2.0091E+00_JPRB,2.2231E+00_JPRB,2.2801E+00_JPRB/)
KBO( :, 3,14, 9) = (/&
&1.9976E+00_JPRB,1.9967E+00_JPRB,1.8170E+00_JPRB,1.9802E+00_JPRB,2.1840E+00_JPRB,2.2566E+00_JPRB/)
KBO( :, 4,14, 9) = (/&
&1.9974E+00_JPRB,1.9965E+00_JPRB,1.8053E+00_JPRB,1.9495E+00_JPRB,2.1431E+00_JPRB,2.2372E+00_JPRB/)
KBO( :, 5,14, 9) = (/&
&1.9939E+00_JPRB,1.9930E+00_JPRB,1.7904E+00_JPRB,1.9177E+00_JPRB,2.1004E+00_JPRB,2.2192E+00_JPRB/)
KBO( :, 1,15, 9) = (/&
&1.7889E+00_JPRB,1.7882E+00_JPRB,1.7547E+00_JPRB,2.0779E+00_JPRB,2.3573E+00_JPRB,2.4290E+00_JPRB/)
KBO( :, 2,15, 9) = (/&
&1.7928E+00_JPRB,1.7920E+00_JPRB,1.7452E+00_JPRB,2.0486E+00_JPRB,2.3189E+00_JPRB,2.4037E+00_JPRB/)
KBO( :, 3,15, 9) = (/&
&1.7928E+00_JPRB,1.7920E+00_JPRB,1.7330E+00_JPRB,2.0171E+00_JPRB,2.2790E+00_JPRB,2.3775E+00_JPRB/)
KBO( :, 4,15, 9) = (/&
&1.7917E+00_JPRB,1.7909E+00_JPRB,1.7182E+00_JPRB,1.9838E+00_JPRB,2.2366E+00_JPRB,2.3528E+00_JPRB/)
KBO( :, 5,15, 9) = (/&
&1.7907E+00_JPRB,1.7899E+00_JPRB,1.7010E+00_JPRB,1.9495E+00_JPRB,2.1934E+00_JPRB,2.3317E+00_JPRB/)
KBO( :, 1,16, 9) = (/&
&1.5869E+00_JPRB,1.5863E+00_JPRB,1.6883E+00_JPRB,2.1193E+00_JPRB,2.4455E+00_JPRB,2.5492E+00_JPRB/)
KBO( :, 2,16, 9) = (/&
&1.5874E+00_JPRB,1.5868E+00_JPRB,1.6750E+00_JPRB,2.0881E+00_JPRB,2.4087E+00_JPRB,2.5259E+00_JPRB/)
KBO( :, 3,16, 9) = (/&
&1.5879E+00_JPRB,1.5873E+00_JPRB,1.6596E+00_JPRB,2.0559E+00_JPRB,2.3694E+00_JPRB,2.5006E+00_JPRB/)
KBO( :, 4,16, 9) = (/&
&1.5893E+00_JPRB,1.5886E+00_JPRB,1.6420E+00_JPRB,2.0221E+00_JPRB,2.3275E+00_JPRB,2.4758E+00_JPRB/)
KBO( :, 5,16, 9) = (/&
&1.5915E+00_JPRB,1.5908E+00_JPRB,1.6225E+00_JPRB,1.9860E+00_JPRB,2.2837E+00_JPRB,2.4531E+00_JPRB/)
KBO( :, 1,17, 9) = (/&
&1.3911E+00_JPRB,1.3906E+00_JPRB,1.6357E+00_JPRB,2.1551E+00_JPRB,2.5270E+00_JPRB,2.6550E+00_JPRB/)
KBO( :, 2,17, 9) = (/&
&1.3924E+00_JPRB,1.3919E+00_JPRB,1.6197E+00_JPRB,2.1251E+00_JPRB,2.4914E+00_JPRB,2.6342E+00_JPRB/)
KBO( :, 3,17, 9) = (/&
&1.3948E+00_JPRB,1.3943E+00_JPRB,1.6016E+00_JPRB,2.0927E+00_JPRB,2.4529E+00_JPRB,2.6104E+00_JPRB/)
KBO( :, 4,17, 9) = (/&
&1.4001E+00_JPRB,1.3995E+00_JPRB,1.5824E+00_JPRB,2.0573E+00_JPRB,2.4118E+00_JPRB,2.5862E+00_JPRB/)
KBO( :, 5,17, 9) = (/&
&1.4089E+00_JPRB,1.4083E+00_JPRB,1.5632E+00_JPRB,2.0202E+00_JPRB,2.3685E+00_JPRB,2.5625E+00_JPRB/)
KBO( :, 1,18, 9) = (/&
&1.2109E+00_JPRB,1.2104E+00_JPRB,1.5964E+00_JPRB,2.1814E+00_JPRB,2.5952E+00_JPRB,2.7389E+00_JPRB/)
KBO( :, 2,18, 9) = (/&
&1.2140E+00_JPRB,1.2136E+00_JPRB,1.5784E+00_JPRB,2.1525E+00_JPRB,2.5616E+00_JPRB,2.7209E+00_JPRB/)
KBO( :, 3,18, 9) = (/&
&1.2208E+00_JPRB,1.2204E+00_JPRB,1.5595E+00_JPRB,2.1201E+00_JPRB,2.5247E+00_JPRB,2.7005E+00_JPRB/)
KBO( :, 4,18, 9) = (/&
&1.2322E+00_JPRB,1.2318E+00_JPRB,1.5407E+00_JPRB,2.0849E+00_JPRB,2.4850E+00_JPRB,2.6784E+00_JPRB/)
KBO( :, 5,18, 9) = (/&
&1.2477E+00_JPRB,1.2472E+00_JPRB,1.5230E+00_JPRB,2.0478E+00_JPRB,2.4440E+00_JPRB,2.6553E+00_JPRB/)
KBO( :, 1,19, 9) = (/&
&1.0487E+00_JPRB,1.0484E+00_JPRB,1.5649E+00_JPRB,2.1968E+00_JPRB,2.6409E+00_JPRB,2.7963E+00_JPRB/)
KBO( :, 2,19, 9) = (/&
&1.0560E+00_JPRB,1.0557E+00_JPRB,1.5474E+00_JPRB,2.1687E+00_JPRB,2.6108E+00_JPRB,2.7829E+00_JPRB/)
KBO( :, 3,19, 9) = (/&
&1.0685E+00_JPRB,1.0682E+00_JPRB,1.5292E+00_JPRB,2.1368E+00_JPRB,2.5782E+00_JPRB,2.7649E+00_JPRB/)
KBO( :, 4,19, 9) = (/&
&1.0859E+00_JPRB,1.0855E+00_JPRB,1.5121E+00_JPRB,2.1019E+00_JPRB,2.5438E+00_JPRB,2.7445E+00_JPRB/)
KBO( :, 5,19, 9) = (/&
&1.1065E+00_JPRB,1.1062E+00_JPRB,1.4975E+00_JPRB,2.0661E+00_JPRB,2.5062E+00_JPRB,2.7222E+00_JPRB/)
KBO( :, 1,20, 9) = (/&
&9.0827E-01_JPRB,9.0805E-01_JPRB,1.5341E+00_JPRB,2.1956E+00_JPRB,2.6632E+00_JPRB,2.8242E+00_JPRB/)
KBO( :, 2,20, 9) = (/&
&9.2064E-01_JPRB,9.2040E-01_JPRB,1.5172E+00_JPRB,2.1687E+00_JPRB,2.6400E+00_JPRB,2.8145E+00_JPRB/)
KBO( :, 3,20, 9) = (/&
&9.3844E-01_JPRB,9.3819E-01_JPRB,1.5016E+00_JPRB,2.1388E+00_JPRB,2.6129E+00_JPRB,2.8000E+00_JPRB/)
KBO( :, 4,20, 9) = (/&
&9.6013E-01_JPRB,9.5986E-01_JPRB,1.4885E+00_JPRB,2.1071E+00_JPRB,2.5814E+00_JPRB,2.7828E+00_JPRB/)
KBO( :, 5,20, 9) = (/&
&9.8430E-01_JPRB,9.8400E-01_JPRB,1.4771E+00_JPRB,2.0741E+00_JPRB,2.5454E+00_JPRB,2.7636E+00_JPRB/)
KBO( :, 1,21, 9) = (/&
&7.8993E-01_JPRB,7.8978E-01_JPRB,1.4986E+00_JPRB,2.1733E+00_JPRB,2.6623E+00_JPRB,2.8179E+00_JPRB/)
KBO( :, 2,21, 9) = (/&
&8.0667E-01_JPRB,8.0650E-01_JPRB,1.4848E+00_JPRB,2.1496E+00_JPRB,2.6446E+00_JPRB,2.8129E+00_JPRB/)
KBO( :, 3,21, 9) = (/&
&8.2802E-01_JPRB,8.2784E-01_JPRB,1.4733E+00_JPRB,2.1235E+00_JPRB,2.6208E+00_JPRB,2.8029E+00_JPRB/)
KBO( :, 4,21, 9) = (/&
&8.5232E-01_JPRB,8.5211E-01_JPRB,1.4639E+00_JPRB,2.0960E+00_JPRB,2.5913E+00_JPRB,2.7898E+00_JPRB/)
KBO( :, 5,21, 9) = (/&
&8.7899E-01_JPRB,8.7876E-01_JPRB,1.4566E+00_JPRB,2.0681E+00_JPRB,2.5576E+00_JPRB,2.7727E+00_JPRB/)
KBO( :, 1,22, 9) = (/&
&6.9217E-01_JPRB,6.9207E-01_JPRB,1.4567E+00_JPRB,2.1294E+00_JPRB,2.6320E+00_JPRB,2.7789E+00_JPRB/)
KBO( :, 2,22, 9) = (/&
&7.1220E-01_JPRB,7.1209E-01_JPRB,1.4478E+00_JPRB,2.1106E+00_JPRB,2.6173E+00_JPRB,2.7783E+00_JPRB/)
KBO( :, 3,22, 9) = (/&
&7.3566E-01_JPRB,7.3553E-01_JPRB,1.4413E+00_JPRB,2.0897E+00_JPRB,2.5963E+00_JPRB,2.7722E+00_JPRB/)
KBO( :, 4,22, 9) = (/&
&7.6128E-01_JPRB,7.6113E-01_JPRB,1.4363E+00_JPRB,2.0682E+00_JPRB,2.5703E+00_JPRB,2.7624E+00_JPRB/)
KBO( :, 5,22, 9) = (/&
&7.8574E-01_JPRB,7.8555E-01_JPRB,1.4327E+00_JPRB,2.0477E+00_JPRB,2.5401E+00_JPRB,2.7492E+00_JPRB/)
KBO( :, 1,23, 9) = (/&
&6.1008E-01_JPRB,6.1003E-01_JPRB,1.4083E+00_JPRB,2.0681E+00_JPRB,2.5705E+00_JPRB,2.7083E+00_JPRB/)
KBO( :, 2,23, 9) = (/&
&6.3198E-01_JPRB,6.3192E-01_JPRB,1.4051E+00_JPRB,2.0548E+00_JPRB,2.5593E+00_JPRB,2.7117E+00_JPRB/)
KBO( :, 3,23, 9) = (/&
&6.5543E-01_JPRB,6.5535E-01_JPRB,1.4040E+00_JPRB,2.0403E+00_JPRB,2.5427E+00_JPRB,2.7102E+00_JPRB/)
KBO( :, 4,23, 9) = (/&
&6.7837E-01_JPRB,6.7826E-01_JPRB,1.4041E+00_JPRB,2.0263E+00_JPRB,2.5213E+00_JPRB,2.7060E+00_JPRB/)
KBO( :, 5,23, 9) = (/&
&7.0030E-01_JPRB,7.0016E-01_JPRB,1.4050E+00_JPRB,2.0127E+00_JPRB,2.4961E+00_JPRB,2.6994E+00_JPRB/)
KBO( :, 1,24, 9) = (/&
&5.4033E-01_JPRB,5.4033E-01_JPRB,1.3546E+00_JPRB,1.9899E+00_JPRB,2.4822E+00_JPRB,2.6084E+00_JPRB/)
KBO( :, 2,24, 9) = (/&
&5.6139E-01_JPRB,5.6138E-01_JPRB,1.3577E+00_JPRB,1.9836E+00_JPRB,2.4759E+00_JPRB,2.6174E+00_JPRB/)
KBO( :, 3,24, 9) = (/&
&5.8245E-01_JPRB,5.8242E-01_JPRB,1.3618E+00_JPRB,1.9770E+00_JPRB,2.4649E+00_JPRB,2.6232E+00_JPRB/)
KBO( :, 4,24, 9) = (/&
&6.0241E-01_JPRB,6.0233E-01_JPRB,1.3664E+00_JPRB,1.9707E+00_JPRB,2.4498E+00_JPRB,2.6268E+00_JPRB/)
KBO( :, 5,24, 9) = (/&
&6.2165E-01_JPRB,6.2155E-01_JPRB,1.3699E+00_JPRB,1.9646E+00_JPRB,2.4321E+00_JPRB,2.6277E+00_JPRB/)
KBO( :, 1,25, 9) = (/&
&4.7832E-01_JPRB,4.7836E-01_JPRB,1.2974E+00_JPRB,1.9000E+00_JPRB,2.3730E+00_JPRB,2.4875E+00_JPRB/)
KBO( :, 2,25, 9) = (/&
&4.9733E-01_JPRB,4.9735E-01_JPRB,1.3057E+00_JPRB,1.9014E+00_JPRB,2.3734E+00_JPRB,2.5038E+00_JPRB/)
KBO( :, 3,25, 9) = (/&
&5.1523E-01_JPRB,5.1522E-01_JPRB,1.3146E+00_JPRB,1.9031E+00_JPRB,2.3699E+00_JPRB,2.5183E+00_JPRB/)
KBO( :, 4,25, 9) = (/&
&5.3256E-01_JPRB,5.3251E-01_JPRB,1.3228E+00_JPRB,1.9051E+00_JPRB,2.3637E+00_JPRB,2.5320E+00_JPRB/)
KBO( :, 5,25, 9) = (/&
&5.4968E-01_JPRB,5.4961E-01_JPRB,1.3292E+00_JPRB,1.9068E+00_JPRB,2.3561E+00_JPRB,2.5438E+00_JPRB/)
KBO( :, 1,26, 9) = (/&
&4.2201E-01_JPRB,4.2207E-01_JPRB,1.2364E+00_JPRB,1.8029E+00_JPRB,2.2507E+00_JPRB,2.3533E+00_JPRB/)
KBO( :, 2,26, 9) = (/&
&4.3804E-01_JPRB,4.3809E-01_JPRB,1.2498E+00_JPRB,1.8126E+00_JPRB,2.2597E+00_JPRB,2.3788E+00_JPRB/)
KBO( :, 3,26, 9) = (/&
&4.5354E-01_JPRB,4.5356E-01_JPRB,1.2632E+00_JPRB,1.8229E+00_JPRB,2.2657E+00_JPRB,2.4047E+00_JPRB/)
KBO( :, 4,26, 9) = (/&
&4.6906E-01_JPRB,4.6904E-01_JPRB,1.2746E+00_JPRB,1.8333E+00_JPRB,2.2706E+00_JPRB,2.4304E+00_JPRB/)
KBO( :, 5,26, 9) = (/&
&4.8497E-01_JPRB,4.8494E-01_JPRB,1.2839E+00_JPRB,1.8429E+00_JPRB,2.2744E+00_JPRB,2.4544E+00_JPRB/)
KBO( :, 1,27, 9) = (/&
&3.7036E-01_JPRB,3.7045E-01_JPRB,1.1734E+00_JPRB,1.7029E+00_JPRB,2.1233E+00_JPRB,2.2152E+00_JPRB/)
KBO( :, 2,27, 9) = (/&
&3.8398E-01_JPRB,3.8406E-01_JPRB,1.1918E+00_JPRB,1.7218E+00_JPRB,2.1420E+00_JPRB,2.2527E+00_JPRB/)
KBO( :, 3,27, 9) = (/&
&3.9787E-01_JPRB,3.9791E-01_JPRB,1.2085E+00_JPRB,1.7412E+00_JPRB,2.1596E+00_JPRB,2.2917E+00_JPRB/)
KBO( :, 4,27, 9) = (/&
&4.1227E-01_JPRB,4.1229E-01_JPRB,1.2235E+00_JPRB,1.7604E+00_JPRB,2.1764E+00_JPRB,2.3307E+00_JPRB/)
KBO( :, 5,27, 9) = (/&
&4.2780E-01_JPRB,4.2779E-01_JPRB,1.2358E+00_JPRB,1.7785E+00_JPRB,2.1924E+00_JPRB,2.3678E+00_JPRB/)
KBO( :, 1,28, 9) = (/&
&3.2384E-01_JPRB,3.2396E-01_JPRB,1.1111E+00_JPRB,1.6050E+00_JPRB,1.9966E+00_JPRB,2.0814E+00_JPRB/)
KBO( :, 2,28, 9) = (/&
&3.3603E-01_JPRB,3.3613E-01_JPRB,1.1332E+00_JPRB,1.6332E+00_JPRB,2.0271E+00_JPRB,2.1324E+00_JPRB/)
KBO( :, 3,28, 9) = (/&
&3.4881E-01_JPRB,3.4887E-01_JPRB,1.1536E+00_JPRB,1.6622E+00_JPRB,2.0573E+00_JPRB,2.1850E+00_JPRB/)
KBO( :, 4,28, 9) = (/&
&3.6268E-01_JPRB,3.6273E-01_JPRB,1.1720E+00_JPRB,1.6900E+00_JPRB,2.0870E+00_JPRB,2.2373E+00_JPRB/)
KBO( :, 5,28, 9) = (/&
&3.7804E-01_JPRB,3.7806E-01_JPRB,1.1877E+00_JPRB,1.7173E+00_JPRB,2.1162E+00_JPRB,2.2869E+00_JPRB/)
KBO( :, 1,29, 9) = (/&
&2.8312E-01_JPRB,2.8326E-01_JPRB,1.0508E+00_JPRB,1.5130E+00_JPRB,1.8780E+00_JPRB,1.9589E+00_JPRB/)
KBO( :, 2,29, 9) = (/&
&2.9434E-01_JPRB,2.9445E-01_JPRB,1.0766E+00_JPRB,1.5511E+00_JPRB,1.9210E+00_JPRB,2.0243E+00_JPRB/)
KBO( :, 3,29, 9) = (/&
&3.0652E-01_JPRB,3.0661E-01_JPRB,1.1009E+00_JPRB,1.5889E+00_JPRB,1.9642E+00_JPRB,2.0907E+00_JPRB/)
KBO( :, 4,29, 9) = (/&
&3.2016E-01_JPRB,3.2023E-01_JPRB,1.1226E+00_JPRB,1.6261E+00_JPRB,2.0071E+00_JPRB,2.1548E+00_JPRB/)
KBO( :, 5,29, 9) = (/&
&3.3571E-01_JPRB,3.3577E-01_JPRB,1.1421E+00_JPRB,1.6615E+00_JPRB,2.0485E+00_JPRB,2.2151E+00_JPRB/)
KBO( :, 1,30, 9) = (/&
&2.4766E-01_JPRB,2.4782E-01_JPRB,9.9433E-01_JPRB,1.4304E+00_JPRB,1.7715E+00_JPRB,1.8514E+00_JPRB/)
KBO( :, 2,30, 9) = (/&
&2.5837E-01_JPRB,2.5850E-01_JPRB,1.0241E+00_JPRB,1.4775E+00_JPRB,1.8271E+00_JPRB,1.9302E+00_JPRB/)
KBO( :, 3,30, 9) = (/&
&2.7045E-01_JPRB,2.7056E-01_JPRB,1.0517E+00_JPRB,1.5244E+00_JPRB,1.8833E+00_JPRB,2.0084E+00_JPRB/)
KBO( :, 4,30, 9) = (/&
&2.8427E-01_JPRB,2.8436E-01_JPRB,1.0773E+00_JPRB,1.5701E+00_JPRB,1.9380E+00_JPRB,2.0829E+00_JPRB/)
KBO( :, 5,30, 9) = (/&
&3.0013E-01_JPRB,3.0021E-01_JPRB,1.1005E+00_JPRB,1.6130E+00_JPRB,1.9897E+00_JPRB,2.1530E+00_JPRB/)
KBO( :, 1,31, 9) = (/&
&2.1718E-01_JPRB,2.1735E-01_JPRB,9.4336E-01_JPRB,1.3592E+00_JPRB,1.6802E+00_JPRB,1.7623E+00_JPRB/)
KBO( :, 2,31, 9) = (/&
&2.2773E-01_JPRB,2.2787E-01_JPRB,9.7667E-01_JPRB,1.4147E+00_JPRB,1.7480E+00_JPRB,1.8530E+00_JPRB/)
KBO( :, 3,31, 9) = (/&
&2.3995E-01_JPRB,2.4007E-01_JPRB,1.0080E+00_JPRB,1.4699E+00_JPRB,1.8151E+00_JPRB,1.9409E+00_JPRB/)
KBO( :, 4,31, 9) = (/&
&2.5414E-01_JPRB,2.5424E-01_JPRB,1.0371E+00_JPRB,1.5227E+00_JPRB,1.8795E+00_JPRB,2.0251E+00_JPRB/)
KBO( :, 5,31, 9) = (/&
&2.7018E-01_JPRB,2.7028E-01_JPRB,1.0644E+00_JPRB,1.5717E+00_JPRB,1.9397E+00_JPRB,2.1038E+00_JPRB/)
KBO( :, 1,32, 9) = (/&
&1.9126E-01_JPRB,1.9146E-01_JPRB,8.9853E-01_JPRB,1.2997E+00_JPRB,1.6046E+00_JPRB,1.6901E+00_JPRB/)
KBO( :, 2,32, 9) = (/&
&2.0193E-01_JPRB,2.0209E-01_JPRB,9.3540E-01_JPRB,1.3632E+00_JPRB,1.6829E+00_JPRB,1.7901E+00_JPRB/)
KBO( :, 3,32, 9) = (/&
&2.1445E-01_JPRB,2.1459E-01_JPRB,9.7036E-01_JPRB,1.4251E+00_JPRB,1.7593E+00_JPRB,1.8876E+00_JPRB/)
KBO( :, 4,32, 9) = (/&
&2.2890E-01_JPRB,2.2902E-01_JPRB,1.0032E+00_JPRB,1.4834E+00_JPRB,1.8319E+00_JPRB,1.9801E+00_JPRB/)
KBO( :, 5,32, 9) = (/&
&2.4476E-01_JPRB,2.4488E-01_JPRB,1.0341E+00_JPRB,1.5373E+00_JPRB,1.8995E+00_JPRB,2.0662E+00_JPRB/)
KBO( :, 1,33, 9) = (/&
&1.6940E-01_JPRB,1.6962E-01_JPRB,8.6040E-01_JPRB,1.2516E+00_JPRB,1.5440E+00_JPRB,1.6336E+00_JPRB/)
KBO( :, 2,33, 9) = (/&
&1.8040E-01_JPRB,1.8058E-01_JPRB,9.0069E-01_JPRB,1.3217E+00_JPRB,1.6313E+00_JPRB,1.7427E+00_JPRB/)
KBO( :, 3,33, 9) = (/&
&1.9322E-01_JPRB,1.9338E-01_JPRB,9.3905E-01_JPRB,1.3887E+00_JPRB,1.7155E+00_JPRB,1.8483E+00_JPRB/)
KBO( :, 4,33, 9) = (/&
&2.0759E-01_JPRB,2.0774E-01_JPRB,9.7525E-01_JPRB,1.4518E+00_JPRB,1.7950E+00_JPRB,1.9477E+00_JPRB/)
KBO( :, 5,33, 9) = (/&
&2.2287E-01_JPRB,2.2300E-01_JPRB,1.0095E+00_JPRB,1.5103E+00_JPRB,1.8688E+00_JPRB,2.0398E+00_JPRB/)
KBO( :, 1,34, 9) = (/&
&1.5076E-01_JPRB,1.5101E-01_JPRB,8.2749E-01_JPRB,1.2115E+00_JPRB,1.4944E+00_JPRB,1.5862E+00_JPRB/)
KBO( :, 2,34, 9) = (/&
&1.6203E-01_JPRB,1.6224E-01_JPRB,8.7097E-01_JPRB,1.2867E+00_JPRB,1.5891E+00_JPRB,1.7034E+00_JPRB/)
KBO( :, 3,34, 9) = (/&
&1.7492E-01_JPRB,1.7510E-01_JPRB,9.1244E-01_JPRB,1.3584E+00_JPRB,1.6800E+00_JPRB,1.8152E+00_JPRB/)
KBO( :, 4,34, 9) = (/&
&1.8884E-01_JPRB,1.8900E-01_JPRB,9.5164E-01_JPRB,1.4257E+00_JPRB,1.7654E+00_JPRB,1.9207E+00_JPRB/)
KBO( :, 5,34, 9) = (/&
&2.0347E-01_JPRB,2.0361E-01_JPRB,9.8858E-01_JPRB,1.4882E+00_JPRB,1.8441E+00_JPRB,2.0182E+00_JPRB/)
KBO( :, 1,35, 9) = (/&
&1.3410E-01_JPRB,1.3442E-01_JPRB,7.9621E-01_JPRB,1.1726E+00_JPRB,1.4470E+00_JPRB,1.5402E+00_JPRB/)
KBO( :, 2,35, 9) = (/&
&1.4542E-01_JPRB,1.4567E-01_JPRB,8.4262E-01_JPRB,1.2523E+00_JPRB,1.5484E+00_JPRB,1.6636E+00_JPRB/)
KBO( :, 3,35, 9) = (/&
&1.5802E-01_JPRB,1.5823E-01_JPRB,8.8698E-01_JPRB,1.3283E+00_JPRB,1.6454E+00_JPRB,1.7818E+00_JPRB/)
KBO( :, 4,35, 9) = (/&
&1.7135E-01_JPRB,1.7153E-01_JPRB,9.2894E-01_JPRB,1.3999E+00_JPRB,1.7361E+00_JPRB,1.8932E+00_JPRB/)
KBO( :, 5,35, 9) = (/&
&1.8540E-01_JPRB,1.8556E-01_JPRB,9.6841E-01_JPRB,1.4664E+00_JPRB,1.8195E+00_JPRB,1.9967E+00_JPRB/)
KBO( :, 1,36, 9) = (/&
&1.1885E-01_JPRB,1.1927E-01_JPRB,7.6459E-01_JPRB,1.1318E+00_JPRB,1.3978E+00_JPRB,1.4899E+00_JPRB/)
KBO( :, 2,36, 9) = (/&
&1.2990E-01_JPRB,1.3022E-01_JPRB,8.1382E-01_JPRB,1.2158E+00_JPRB,1.5052E+00_JPRB,1.6195E+00_JPRB/)
KBO( :, 3,36, 9) = (/&
&1.4201E-01_JPRB,1.4226E-01_JPRB,8.6094E-01_JPRB,1.2962E+00_JPRB,1.6079E+00_JPRB,1.7441E+00_JPRB/)
KBO( :, 4,36, 9) = (/&
&1.5478E-01_JPRB,1.5499E-01_JPRB,9.0551E-01_JPRB,1.3720E+00_JPRB,1.7039E+00_JPRB,1.8614E+00_JPRB/)
KBO( :, 5,36, 9) = (/&
&1.6836E-01_JPRB,1.6854E-01_JPRB,9.4765E-01_JPRB,1.4424E+00_JPRB,1.7920E+00_JPRB,1.9701E+00_JPRB/)
KBO( :, 1,37, 9) = (/&
&1.0428E-01_JPRB,1.0485E-01_JPRB,7.2899E-01_JPRB,1.0835E+00_JPRB,1.3388E+00_JPRB,1.4259E+00_JPRB/)
KBO( :, 2,37, 9) = (/&
&1.1481E-01_JPRB,1.1525E-01_JPRB,7.8118E-01_JPRB,1.1719E+00_JPRB,1.4522E+00_JPRB,1.5616E+00_JPRB/)
KBO( :, 3,37, 9) = (/&
&1.2629E-01_JPRB,1.2662E-01_JPRB,8.3108E-01_JPRB,1.2566E+00_JPRB,1.5607E+00_JPRB,1.6925E+00_JPRB/)
KBO( :, 4,37, 9) = (/&
&1.3851E-01_JPRB,1.3876E-01_JPRB,8.7848E-01_JPRB,1.3370E+00_JPRB,1.6624E+00_JPRB,1.8161E+00_JPRB/)
KBO( :, 5,37, 9) = (/&
&1.5156E-01_JPRB,1.5177E-01_JPRB,9.2339E-01_JPRB,1.4116E+00_JPRB,1.7558E+00_JPRB,1.9309E+00_JPRB/)
KBO( :, 1,38, 9) = (/&
&9.1605E-02_JPRB,9.2343E-02_JPRB,6.9610E-01_JPRB,1.0388E+00_JPRB,1.2845E+00_JPRB,1.3674E+00_JPRB/)
KBO( :, 2,38, 9) = (/&
&1.0158E-01_JPRB,1.0215E-01_JPRB,7.5088E-01_JPRB,1.1311E+00_JPRB,1.4032E+00_JPRB,1.5087E+00_JPRB/)
KBO( :, 3,38, 9) = (/&
&1.1247E-01_JPRB,1.1289E-01_JPRB,8.0339E-01_JPRB,1.2200E+00_JPRB,1.5169E+00_JPRB,1.6453E+00_JPRB/)
KBO( :, 4,38, 9) = (/&
&1.2417E-01_JPRB,1.2448E-01_JPRB,8.5338E-01_JPRB,1.3042E+00_JPRB,1.6236E+00_JPRB,1.7750E+00_JPRB/)
KBO( :, 5,38, 9) = (/&
&1.3676E-01_JPRB,1.3700E-01_JPRB,9.0083E-01_JPRB,1.3828E+00_JPRB,1.7217E+00_JPRB,1.8952E+00_JPRB/)
KBO( :, 1,39, 9) = (/&
&8.0656E-02_JPRB,8.1594E-02_JPRB,6.6607E-01_JPRB,9.9815E-01_JPRB,1.2351E+00_JPRB,1.3152E+00_JPRB/)
KBO( :, 2,39, 9) = (/&
&9.0069E-02_JPRB,9.0786E-02_JPRB,7.2321E-01_JPRB,1.0941E+00_JPRB,1.3584E+00_JPRB,1.4617E+00_JPRB/)
KBO( :, 3,39, 9) = (/&
&1.0038E-01_JPRB,1.0092E-01_JPRB,7.7814E-01_JPRB,1.1864E+00_JPRB,1.4767E+00_JPRB,1.6037E+00_JPRB/)
KBO( :, 4,39, 9) = (/&
&1.1160E-01_JPRB,1.1200E-01_JPRB,8.3050E-01_JPRB,1.2742E+00_JPRB,1.5879E+00_JPRB,1.7392E+00_JPRB/)
KBO( :, 5,39, 9) = (/&
&1.2381E-01_JPRB,1.2410E-01_JPRB,8.8026E-01_JPRB,1.3564E+00_JPRB,1.6903E+00_JPRB,1.8642E+00_JPRB/)
KBO( :, 1,40, 9) = (/&
&7.0343E-02_JPRB,7.1517E-02_JPRB,6.3258E-01_JPRB,9.5074E-01_JPRB,1.1768E+00_JPRB,1.2495E+00_JPRB/)
KBO( :, 2,40, 9) = (/&
&7.9103E-02_JPRB,8.0020E-02_JPRB,6.9189E-01_JPRB,1.0501E+00_JPRB,1.3045E+00_JPRB,1.4003E+00_JPRB/)
KBO( :, 3,40, 9) = (/&
&8.8790E-02_JPRB,8.9492E-02_JPRB,7.4925E-01_JPRB,1.1461E+00_JPRB,1.4274E+00_JPRB,1.5476E+00_JPRB/)
KBO( :, 4,40, 9) = (/&
&9.9461E-02_JPRB,9.9977E-02_JPRB,8.0414E-01_JPRB,1.2375E+00_JPRB,1.5434E+00_JPRB,1.6884E+00_JPRB/)
KBO( :, 5,40, 9) = (/&
&1.1114E-01_JPRB,1.1151E-01_JPRB,8.5633E-01_JPRB,1.3236E+00_JPRB,1.6507E+00_JPRB,1.8191E+00_JPRB/)
KBO( :, 1,41, 9) = (/&
&6.1266E-02_JPRB,6.2696E-02_JPRB,6.0022E-01_JPRB,9.0450E-01_JPRB,1.1198E+00_JPRB,1.1852E+00_JPRB/)
KBO( :, 2,41, 9) = (/&
&6.9449E-02_JPRB,7.0593E-02_JPRB,6.6161E-01_JPRB,1.0070E+00_JPRB,1.2513E+00_JPRB,1.3399E+00_JPRB/)
KBO( :, 3,41, 9) = (/&
&7.8517E-02_JPRB,7.9409E-02_JPRB,7.2121E-01_JPRB,1.1063E+00_JPRB,1.3785E+00_JPRB,1.4916E+00_JPRB/)
KBO( :, 4,41, 9) = (/&
&8.8610E-02_JPRB,8.9276E-02_JPRB,7.7839E-01_JPRB,1.2012E+00_JPRB,1.4990E+00_JPRB,1.6374E+00_JPRB/)
KBO( :, 5,41, 9) = (/&
&9.9774E-02_JPRB,1.0026E-01_JPRB,8.3284E-01_JPRB,1.2906E+00_JPRB,1.6108E+00_JPRB,1.7737E+00_JPRB/)
KBO( :, 1,42, 9) = (/&
&5.3360E-02_JPRB,5.5059E-02_JPRB,5.6966E-01_JPRB,8.6038E-01_JPRB,1.0655E+00_JPRB,1.1243E+00_JPRB/)
KBO( :, 2,42, 9) = (/&
&6.0993E-02_JPRB,6.2382E-02_JPRB,6.3280E-01_JPRB,9.6562E-01_JPRB,1.2001E+00_JPRB,1.2823E+00_JPRB/)
KBO( :, 3,42, 9) = (/&
&6.9507E-02_JPRB,7.0610E-02_JPRB,6.9445E-01_JPRB,1.0679E+00_JPRB,1.3311E+00_JPRB,1.4380E+00_JPRB/)
KBO( :, 4,42, 9) = (/&
&7.9032E-02_JPRB,7.9871E-02_JPRB,7.5376E-01_JPRB,1.1658E+00_JPRB,1.4555E+00_JPRB,1.5883E+00_JPRB/)
KBO( :, 5,42, 9) = (/&
&8.9684E-02_JPRB,9.0303E-02_JPRB,8.1031E-01_JPRB,1.2585E+00_JPRB,1.5717E+00_JPRB,1.7298E+00_JPRB/)
KBO( :, 1,43, 9) = (/&
&4.6136E-02_JPRB,4.8125E-02_JPRB,5.3704E-01_JPRB,8.1220E-01_JPRB,1.0058E+00_JPRB,1.0569E+00_JPRB/)
KBO( :, 2,43, 9) = (/&
&5.3161E-02_JPRB,5.4823E-02_JPRB,6.0168E-01_JPRB,9.1982E-01_JPRB,1.1431E+00_JPRB,1.2177E+00_JPRB/)
KBO( :, 3,43, 9) = (/&
&6.1123E-02_JPRB,6.2470E-02_JPRB,6.6532E-01_JPRB,1.0249E+00_JPRB,1.2775E+00_JPRB,1.3770E+00_JPRB/)
KBO( :, 4,43, 9) = (/&
&7.0049E-02_JPRB,7.1098E-02_JPRB,7.2673E-01_JPRB,1.1259E+00_JPRB,1.4060E+00_JPRB,1.5318E+00_JPRB/)
KBO( :, 5,43, 9) = (/&
&8.0119E-02_JPRB,8.0908E-02_JPRB,7.8534E-01_JPRB,1.2218E+00_JPRB,1.5266E+00_JPRB,1.6786E+00_JPRB/)
KBO( :, 1,44, 9) = (/&
&3.9685E-02_JPRB,4.1972E-02_JPRB,5.0412E-01_JPRB,7.6296E-01_JPRB,9.4428E-01_JPRB,9.8787E-01_JPRB/)
KBO( :, 2,44, 9) = (/&
&4.6152E-02_JPRB,4.8103E-02_JPRB,5.7004E-01_JPRB,8.7240E-01_JPRB,1.0838E+00_JPRB,1.1508E+00_JPRB/)
KBO( :, 3,44, 9) = (/&
&5.3529E-02_JPRB,5.5143E-02_JPRB,6.3536E-01_JPRB,9.8002E-01_JPRB,1.2213E+00_JPRB,1.3132E+00_JPRB/)
KBO( :, 4,44, 9) = (/&
&6.1901E-02_JPRB,6.3183E-02_JPRB,6.9879E-01_JPRB,1.0840E+00_JPRB,1.3536E+00_JPRB,1.4723E+00_JPRB/)
KBO( :, 5,44, 9) = (/&
&7.1354E-02_JPRB,7.2347E-02_JPRB,7.5939E-01_JPRB,1.1829E+00_JPRB,1.4784E+00_JPRB,1.6242E+00_JPRB/)
KBO( :, 1,45, 9) = (/&
&3.4076E-02_JPRB,3.6651E-02_JPRB,4.7238E-01_JPRB,7.1511E-01_JPRB,8.8440E-01_JPRB,9.2130E-01_JPRB/)
KBO( :, 2,45, 9) = (/&
&4.0025E-02_JPRB,4.2260E-02_JPRB,5.3939E-01_JPRB,8.2584E-01_JPRB,1.0257E+00_JPRB,1.0858E+00_JPRB/)
KBO( :, 3,45, 9) = (/&
&4.6843E-02_JPRB,4.8732E-02_JPRB,6.0607E-01_JPRB,9.3570E-01_JPRB,1.1656E+00_JPRB,1.2509E+00_JPRB/)
KBO( :, 4,45, 9) = (/&
&5.4663E-02_JPRB,5.6198E-02_JPRB,6.7125E-01_JPRB,1.0423E+00_JPRB,1.3013E+00_JPRB,1.4137E+00_JPRB/)
KBO( :, 5,45, 9) = (/&
&6.3560E-02_JPRB,6.4776E-02_JPRB,7.3381E-01_JPRB,1.1441E+00_JPRB,1.4299E+00_JPRB,1.5705E+00_JPRB/)
KBO( :, 1,46, 9) = (/&
&2.9074E-02_JPRB,3.1936E-02_JPRB,4.4021E-01_JPRB,6.6617E-01_JPRB,8.2306E-01_JPRB,8.5311E-01_JPRB/)
KBO( :, 2,46, 9) = (/&
&3.4514E-02_JPRB,3.7034E-02_JPRB,5.0803E-01_JPRB,7.7771E-01_JPRB,9.6537E-01_JPRB,1.0184E+00_JPRB/)
KBO( :, 3,46, 9) = (/&
&4.0817E-02_JPRB,4.2987E-02_JPRB,5.7579E-01_JPRB,8.8933E-01_JPRB,1.1073E+00_JPRB,1.1856E+00_JPRB/)
KBO( :, 4,46, 9) = (/&
&4.8065E-02_JPRB,4.9872E-02_JPRB,6.4255E-01_JPRB,9.9829E-01_JPRB,1.2460E+00_JPRB,1.3517E+00_JPRB/)
KBO( :, 5,46, 9) = (/&
&5.6423E-02_JPRB,5.7882E-02_JPRB,7.0700E-01_JPRB,1.1029E+00_JPRB,1.3784E+00_JPRB,1.5131E+00_JPRB/)
KBO( :, 1,47, 9) = (/&
&2.4535E-02_JPRB,2.7684E-02_JPRB,4.0628E-01_JPRB,6.1382E-01_JPRB,7.5741E-01_JPRB,7.7949E-01_JPRB/)
KBO( :, 2,47, 9) = (/&
&2.9449E-02_JPRB,3.2260E-02_JPRB,4.7443E-01_JPRB,7.2561E-01_JPRB,8.9979E-01_JPRB,9.4468E-01_JPRB/)
KBO( :, 3,47, 9) = (/&
&3.5234E-02_JPRB,3.7694E-02_JPRB,5.4316E-01_JPRB,8.3846E-01_JPRB,1.0433E+00_JPRB,1.1130E+00_JPRB/)
KBO( :, 4,47, 9) = (/&
&4.1912E-02_JPRB,4.4006E-02_JPRB,6.1119E-01_JPRB,9.4961E-01_JPRB,1.1846E+00_JPRB,1.2819E+00_JPRB/)
KBO( :, 5,47, 9) = (/&
&4.9674E-02_JPRB,5.1405E-02_JPRB,6.7740E-01_JPRB,1.0570E+00_JPRB,1.3207E+00_JPRB,1.4474E+00_JPRB/)
KBO( :, 1,48, 9) = (/&
&2.0618E-02_JPRB,2.4026E-02_JPRB,3.7343E-01_JPRB,5.6290E-01_JPRB,6.9352E-01_JPRB,7.0849E-01_JPRB/)
KBO( :, 2,48, 9) = (/&
&2.5013E-02_JPRB,2.8103E-02_JPRB,4.4151E-01_JPRB,6.7436E-01_JPRB,8.3513E-01_JPRB,8.7266E-01_JPRB/)
KBO( :, 3,48, 9) = (/&
&3.0305E-02_JPRB,3.3049E-02_JPRB,5.1090E-01_JPRB,7.8783E-01_JPRB,9.7958E-01_JPRB,1.0415E+00_JPRB/)
KBO( :, 4,48, 9) = (/&
&3.6461E-02_JPRB,3.8842E-02_JPRB,5.7999E-01_JPRB,9.0076E-01_JPRB,1.1229E+00_JPRB,1.2126E+00_JPRB/)
KBO( :, 5,48, 9) = (/&
&4.3637E-02_JPRB,4.5645E-02_JPRB,6.4766E-01_JPRB,1.0105E+00_JPRB,1.2621E+00_JPRB,1.3817E+00_JPRB/)
KBO( :, 1,49, 9) = (/&
&1.7262E-02_JPRB,2.0889E-02_JPRB,3.4154E-01_JPRB,5.1353E-01_JPRB,6.3147E-01_JPRB,6.4035E-01_JPRB/)
KBO( :, 2,49, 9) = (/&
&2.1137E-02_JPRB,2.4489E-02_JPRB,4.0924E-01_JPRB,6.2397E-01_JPRB,7.7164E-01_JPRB,8.0268E-01_JPRB/)
KBO( :, 3,49, 9) = (/&
&2.5945E-02_JPRB,2.8963E-02_JPRB,4.7895E-01_JPRB,7.3764E-01_JPRB,9.1622E-01_JPRB,9.7159E-01_JPRB/)
KBO( :, 4,49, 9) = (/&
&3.1605E-02_JPRB,3.4269E-02_JPRB,5.4885E-01_JPRB,8.5174E-01_JPRB,1.0610E+00_JPRB,1.1442E+00_JPRB/)
KBO( :, 5,49, 9) = (/&
&3.8248E-02_JPRB,4.0534E-02_JPRB,6.1776E-01_JPRB,9.6350E-01_JPRB,1.2028E+00_JPRB,1.3168E+00_JPRB/)
KBO( :, 1,50, 9) = (/&
&1.4461E-02_JPRB,1.8256E-02_JPRB,3.1238E-01_JPRB,4.6845E-01_JPRB,5.7488E-01_JPRB,5.7744E-01_JPRB/)
KBO( :, 2,50, 9) = (/&
&1.7870E-02_JPRB,2.1439E-02_JPRB,3.7949E-01_JPRB,5.7732E-01_JPRB,7.1302E-01_JPRB,7.3703E-01_JPRB/)
KBO( :, 3,50, 9) = (/&
&2.2222E-02_JPRB,2.5490E-02_JPRB,4.4914E-01_JPRB,6.9079E-01_JPRB,8.5702E-01_JPRB,9.0516E-01_JPRB/)
KBO( :, 4,50, 9) = (/&
&2.7435E-02_JPRB,3.0361E-02_JPRB,5.1966E-01_JPRB,8.0553E-01_JPRB,1.0027E+00_JPRB,1.0781E+00_JPRB/)
KBO( :, 5,50, 9) = (/&
&3.3599E-02_JPRB,3.6150E-02_JPRB,5.8955E-01_JPRB,9.1897E-01_JPRB,1.1465E+00_JPRB,1.2529E+00_JPRB/)
KBO( :, 1,51, 9) = (/&
&1.2097E-02_JPRB,1.6003E-02_JPRB,2.8492E-01_JPRB,4.2603E-01_JPRB,5.2182E-01_JPRB,5.1816E-01_JPRB/)
KBO( :, 2,51, 9) = (/&
&1.5083E-02_JPRB,1.8829E-02_JPRB,3.5127E-01_JPRB,5.3304E-01_JPRB,6.5735E-01_JPRB,6.7429E-01_JPRB/)
KBO( :, 3,51, 9) = (/&
&1.8997E-02_JPRB,2.2488E-02_JPRB,4.2058E-01_JPRB,6.4583E-01_JPRB,8.0019E-01_JPRB,8.4077E-01_JPRB/)
KBO( :, 4,51, 9) = (/&
&2.3775E-02_JPRB,2.6948E-02_JPRB,4.9143E-01_JPRB,7.6084E-01_JPRB,9.4628E-01_JPRB,1.0134E+00_JPRB/)
KBO( :, 5,51, 9) = (/&
&2.9499E-02_JPRB,3.2304E-02_JPRB,5.6205E-01_JPRB,8.7547E-01_JPRB,1.0915E+00_JPRB,1.1895E+00_JPRB/)
KBO( :, 1,52, 9) = (/&
&1.0095E-02_JPRB,1.4050E-02_JPRB,2.5854E-01_JPRB,3.8529E-01_JPRB,4.7109E-01_JPRB,4.6197E-01_JPRB/)
KBO( :, 2,52, 9) = (/&
&1.2680E-02_JPRB,1.6562E-02_JPRB,3.2378E-01_JPRB,4.9000E-01_JPRB,6.0315E-01_JPRB,6.1385E-01_JPRB/)
KBO( :, 3,52, 9) = (/&
&1.6167E-02_JPRB,1.9851E-02_JPRB,3.9257E-01_JPRB,6.0150E-01_JPRB,7.4434E-01_JPRB,7.7805E-01_JPRB/)
KBO( :, 4,52, 9) = (/&
&2.0524E-02_JPRB,2.3923E-02_JPRB,4.6343E-01_JPRB,7.1644E-01_JPRB,8.9011E-01_JPRB,9.4994E-01_JPRB/)
KBO( :, 5,52, 9) = (/&
&2.5821E-02_JPRB,2.8872E-02_JPRB,5.3465E-01_JPRB,8.3183E-01_JPRB,1.0363E+00_JPRB,1.1268E+00_JPRB/)
KBO( :, 1,53, 9) = (/&
&8.3963E-03_JPRB,1.2343E-02_JPRB,2.3325E-01_JPRB,3.4626E-01_JPRB,4.2244E-01_JPRB,4.0883E-01_JPRB/)
KBO( :, 2,53, 9) = (/&
&1.0621E-02_JPRB,1.4581E-02_JPRB,2.9700E-01_JPRB,4.4811E-01_JPRB,5.5051E-01_JPRB,5.5572E-01_JPRB/)
KBO( :, 3,53, 9) = (/&
&1.3693E-02_JPRB,1.7537E-02_JPRB,3.6501E-01_JPRB,5.5778E-01_JPRB,6.8933E-01_JPRB,7.1705E-01_JPRB/)
KBO( :, 4,53, 9) = (/&
&1.7633E-02_JPRB,2.1242E-02_JPRB,4.3562E-01_JPRB,6.7222E-01_JPRB,8.3412E-01_JPRB,8.8780E-01_JPRB/)
KBO( :, 5,53, 9) = (/&
&2.2506E-02_JPRB,2.5791E-02_JPRB,5.0721E-01_JPRB,7.8803E-01_JPRB,9.8102E-01_JPRB,1.0650E+00_JPRB/)
KBO( :, 1,54, 9) = (/&
&7.0177E-03_JPRB,1.0894E-02_JPRB,2.1095E-01_JPRB,3.1199E-01_JPRB,3.7969E-01_JPRB,3.6085E-01_JPRB/)
KBO( :, 2,54, 9) = (/&
&8.9302E-03_JPRB,1.2918E-02_JPRB,2.7298E-01_JPRB,4.1066E-01_JPRB,5.0363E-01_JPRB,5.0181E-01_JPRB/)
KBO( :, 3,54, 9) = (/&
&1.1634E-02_JPRB,1.5589E-02_JPRB,3.4013E-01_JPRB,5.1838E-01_JPRB,6.3970E-01_JPRB,6.5930E-01_JPRB/)
KBO( :, 4,54, 9) = (/&
&1.5199E-02_JPRB,1.8979E-02_JPRB,4.1032E-01_JPRB,6.3200E-01_JPRB,7.8327E-01_JPRB,8.2770E-01_JPRB/)
KBO( :, 5,54, 9) = (/&
&1.9687E-02_JPRB,2.3177E-02_JPRB,4.8201E-01_JPRB,7.4784E-01_JPRB,9.3015E-01_JPRB,1.0034E+00_JPRB/)
KBO( :, 1,55, 9) = (/&
&5.8731E-03_JPRB,9.6286E-03_JPRB,1.9052E-01_JPRB,2.8063E-01_JPRB,3.4069E-01_JPRB,3.1655E-01_JPRB/)
KBO( :, 2,55, 9) = (/&
&7.5168E-03_JPRB,1.1480E-02_JPRB,2.5064E-01_JPRB,3.7586E-01_JPRB,4.6019E-01_JPRB,4.5069E-01_JPRB/)
KBO( :, 3,55, 9) = (/&
&9.8853E-03_JPRB,1.3900E-02_JPRB,3.1669E-01_JPRB,4.8140E-01_JPRB,5.9307E-01_JPRB,6.0350E-01_JPRB/)
KBO( :, 4,55, 9) = (/&
&1.3096E-02_JPRB,1.7018E-02_JPRB,3.8628E-01_JPRB,5.9371E-01_JPRB,7.3500E-01_JPRB,7.6887E-01_JPRB/)
KBO( :, 5,55, 9) = (/&
&1.7222E-02_JPRB,2.0899E-02_JPRB,4.5791E-01_JPRB,7.0935E-01_JPRB,8.8144E-01_JPRB,9.4215E-01_JPRB/)
KBO( :, 1,56, 9) = (/&
&4.9060E-03_JPRB,8.5039E-03_JPRB,1.7111E-01_JPRB,2.5106E-01_JPRB,3.0385E-01_JPRB,2.7511E-01_JPRB/)
KBO( :, 2,56, 9) = (/&
&6.3120E-03_JPRB,1.0201E-02_JPRB,2.2915E-01_JPRB,3.4243E-01_JPRB,4.1847E-01_JPRB,4.0215E-01_JPRB/)
KBO( :, 3,56, 9) = (/&
&8.3672E-03_JPRB,1.2401E-02_JPRB,2.9378E-01_JPRB,4.4537E-01_JPRB,5.4774E-01_JPRB,5.4959E-01_JPRB/)
KBO( :, 4,56, 9) = (/&
&1.1240E-02_JPRB,1.5268E-02_JPRB,3.6263E-01_JPRB,5.5595E-01_JPRB,6.8746E-01_JPRB,7.1138E-01_JPRB/)
KBO( :, 5,56, 9) = (/&
&1.5010E-02_JPRB,1.8851E-02_JPRB,4.3398E-01_JPRB,6.7113E-01_JPRB,8.3300E-01_JPRB,8.8217E-01_JPRB/)
KBO( :, 1,57, 9) = (/&
&4.0878E-03_JPRB,7.4982E-03_JPRB,1.5269E-01_JPRB,2.2324E-01_JPRB,2.6911E-01_JPRB,2.3696E-01_JPRB/)
KBO( :, 2,57, 9) = (/&
&5.2898E-03_JPRB,9.0610E-03_JPRB,2.0850E-01_JPRB,3.1039E-01_JPRB,3.7842E-01_JPRB,3.5615E-01_JPRB/)
KBO( :, 3,57, 9) = (/&
&7.0606E-03_JPRB,1.1069E-02_JPRB,2.7146E-01_JPRB,4.1021E-01_JPRB,5.0366E-01_JPRB,4.9745E-01_JPRB/)
KBO( :, 4,57, 9) = (/&
&9.6071E-03_JPRB,1.3700E-02_JPRB,3.3939E-01_JPRB,5.1887E-01_JPRB,6.4072E-01_JPRB,6.5511E-01_JPRB/)
KBO( :, 5,57, 9) = (/&
&1.3031E-02_JPRB,1.7013E-02_JPRB,4.1025E-01_JPRB,6.3316E-01_JPRB,7.8498E-01_JPRB,8.2331E-01_JPRB/)
KBO( :, 1,58, 9) = (/&
&3.4110E-03_JPRB,6.6187E-03_JPRB,1.3608E-01_JPRB,1.9844E-01_JPRB,2.3812E-01_JPRB,2.0347E-01_JPRB/)
KBO( :, 2,58, 9) = (/&
&4.4437E-03_JPRB,8.0723E-03_JPRB,1.8969E-01_JPRB,2.8123E-01_JPRB,3.4208E-01_JPRB,3.1439E-01_JPRB/)
KBO( :, 3,58, 9) = (/&
&5.9725E-03_JPRB,9.9123E-03_JPRB,2.5079E-01_JPRB,3.7777E-01_JPRB,4.6311E-01_JPRB,4.4931E-01_JPRB/)
KBO( :, 4,58, 9) = (/&
&8.2191E-03_JPRB,1.2333E-02_JPRB,3.1765E-01_JPRB,4.8433E-01_JPRB,5.9715E-01_JPRB,6.0236E-01_JPRB/)
KBO( :, 5,58, 9) = (/&
&1.1325E-02_JPRB,1.5419E-02_JPRB,3.8789E-01_JPRB,5.9740E-01_JPRB,7.3982E-01_JPRB,7.6757E-01_JPRB/)
KBO( :, 1,59, 9) = (/&
&2.9777E-03_JPRB,6.0559E-03_JPRB,1.2911E-01_JPRB,1.8831E-01_JPRB,2.2557E-01_JPRB,1.8804E-01_JPRB/)
KBO( :, 2,59, 9) = (/&
&3.9243E-03_JPRB,7.4586E-03_JPRB,1.8188E-01_JPRB,2.6942E-01_JPRB,3.2742E-01_JPRB,2.9431E-01_JPRB/)
KBO( :, 3,59, 9) = (/&
&5.3410E-03_JPRB,9.2341E-03_JPRB,2.4229E-01_JPRB,3.6461E-01_JPRB,4.4670E-01_JPRB,4.2516E-01_JPRB/)
KBO( :, 4,59, 9) = (/&
&7.4484E-03_JPRB,1.1574E-02_JPRB,3.0869E-01_JPRB,4.7031E-01_JPRB,5.7948E-01_JPRB,5.7493E-01_JPRB/)
KBO( :, 5,59, 9) = (/&
&1.0416E-02_JPRB,1.4573E-02_JPRB,3.7872E-01_JPRB,5.8281E-01_JPRB,7.2146E-01_JPRB,7.3756E-01_JPRB/)
KBO( :, 1,13,10) = (/&
&7.5289E+00_JPRB,7.5248E+00_JPRB,5.8020E+00_JPRB,4.2235E+00_JPRB,3.4788E+00_JPRB,3.3830E+00_JPRB/)
KBO( :, 2,13,10) = (/&
&7.5373E+00_JPRB,7.5331E+00_JPRB,5.7965E+00_JPRB,4.1949E+00_JPRB,3.4100E+00_JPRB,3.3091E+00_JPRB/)
KBO( :, 3,13,10) = (/&
&7.5342E+00_JPRB,7.5300E+00_JPRB,5.7907E+00_JPRB,4.1656E+00_JPRB,3.3402E+00_JPRB,3.2690E+00_JPRB/)
KBO( :, 4,13,10) = (/&
&7.4927E+00_JPRB,7.4886E+00_JPRB,5.7565E+00_JPRB,4.1206E+00_JPRB,3.2641E+00_JPRB,3.2567E+00_JPRB/)
KBO( :, 5,13,10) = (/&
&7.4212E+00_JPRB,7.4171E+00_JPRB,5.6978E+00_JPRB,4.0611E+00_JPRB,3.1856E+00_JPRB,3.2490E+00_JPRB/)
KBO( :, 1,14,10) = (/&
&7.4571E+00_JPRB,7.4529E+00_JPRB,5.7300E+00_JPRB,4.2516E+00_JPRB,3.6973E+00_JPRB,3.6249E+00_JPRB/)
KBO( :, 2,14,10) = (/&
&7.4407E+00_JPRB,7.4365E+00_JPRB,5.7211E+00_JPRB,4.2113E+00_JPRB,3.6244E+00_JPRB,3.5667E+00_JPRB/)
KBO( :, 3,14,10) = (/&
&7.3963E+00_JPRB,7.3922E+00_JPRB,5.6812E+00_JPRB,4.1556E+00_JPRB,3.5526E+00_JPRB,3.5115E+00_JPRB/)
KBO( :, 4,14,10) = (/&
&7.3296E+00_JPRB,7.3255E+00_JPRB,5.6249E+00_JPRB,4.0935E+00_JPRB,3.4766E+00_JPRB,3.4707E+00_JPRB/)
KBO( :, 5,14,10) = (/&
&7.2465E+00_JPRB,7.2425E+00_JPRB,5.5619E+00_JPRB,4.0245E+00_JPRB,3.4020E+00_JPRB,3.4493E+00_JPRB/)
KBO( :, 1,15,10) = (/&
&7.1911E+00_JPRB,7.1871E+00_JPRB,5.5280E+00_JPRB,4.2968E+00_JPRB,3.9627E+00_JPRB,3.9090E+00_JPRB/)
KBO( :, 2,15,10) = (/&
&7.1513E+00_JPRB,7.1474E+00_JPRB,5.4956E+00_JPRB,4.2289E+00_JPRB,3.8871E+00_JPRB,3.8400E+00_JPRB/)
KBO( :, 3,15,10) = (/&
&7.0923E+00_JPRB,7.0884E+00_JPRB,5.4464E+00_JPRB,4.1468E+00_JPRB,3.8062E+00_JPRB,3.7828E+00_JPRB/)
KBO( :, 4,15,10) = (/&
&6.9934E+00_JPRB,6.9895E+00_JPRB,5.3713E+00_JPRB,4.0638E+00_JPRB,3.7328E+00_JPRB,3.7290E+00_JPRB/)
KBO( :, 5,15,10) = (/&
&6.8864E+00_JPRB,6.8825E+00_JPRB,5.2899E+00_JPRB,3.9761E+00_JPRB,3.6483E+00_JPRB,3.6704E+00_JPRB/)
KBO( :, 1,16,10) = (/&
&6.7911E+00_JPRB,6.7873E+00_JPRB,5.2205E+00_JPRB,4.3199E+00_JPRB,4.2502E+00_JPRB,4.2466E+00_JPRB/)
KBO( :, 2,16,10) = (/&
&6.7263E+00_JPRB,6.7226E+00_JPRB,5.1711E+00_JPRB,4.2329E+00_JPRB,4.1599E+00_JPRB,4.1741E+00_JPRB/)
KBO( :, 3,16,10) = (/&
&6.6333E+00_JPRB,6.6296E+00_JPRB,5.0988E+00_JPRB,4.1448E+00_JPRB,4.0703E+00_JPRB,4.1094E+00_JPRB/)
KBO( :, 4,16,10) = (/&
&6.5280E+00_JPRB,6.5244E+00_JPRB,5.0198E+00_JPRB,4.0496E+00_JPRB,3.9801E+00_JPRB,4.0403E+00_JPRB/)
KBO( :, 5,16,10) = (/&
&6.4167E+00_JPRB,6.4131E+00_JPRB,4.9361E+00_JPRB,3.9499E+00_JPRB,3.8927E+00_JPRB,3.9614E+00_JPRB/)
KBO( :, 1,17,10) = (/&
&6.2531E+00_JPRB,6.2497E+00_JPRB,4.8286E+00_JPRB,4.3686E+00_JPRB,4.5172E+00_JPRB,4.6364E+00_JPRB/)
KBO( :, 2,17,10) = (/&
&6.1677E+00_JPRB,6.1643E+00_JPRB,4.7626E+00_JPRB,4.2792E+00_JPRB,4.4298E+00_JPRB,4.5601E+00_JPRB/)
KBO( :, 3,17,10) = (/&
&6.0747E+00_JPRB,6.0713E+00_JPRB,4.6908E+00_JPRB,4.1860E+00_JPRB,4.3428E+00_JPRB,4.4812E+00_JPRB/)
KBO( :, 4,17,10) = (/&
&5.9604E+00_JPRB,5.9571E+00_JPRB,4.6053E+00_JPRB,4.0899E+00_JPRB,4.2570E+00_JPRB,4.3935E+00_JPRB/)
KBO( :, 5,17,10) = (/&
&5.8291E+00_JPRB,5.8259E+00_JPRB,4.5089E+00_JPRB,3.9935E+00_JPRB,4.1733E+00_JPRB,4.3011E+00_JPRB/)
KBO( :, 1,18,10) = (/&
&5.6266E+00_JPRB,5.6236E+00_JPRB,4.4207E+00_JPRB,4.4989E+00_JPRB,4.8053E+00_JPRB,5.0247E+00_JPRB/)
KBO( :, 2,18,10) = (/&
&5.5427E+00_JPRB,5.5397E+00_JPRB,4.3512E+00_JPRB,4.4021E+00_JPRB,4.7226E+00_JPRB,4.9470E+00_JPRB/)
KBO( :, 3,18,10) = (/&
&5.4374E+00_JPRB,5.4345E+00_JPRB,4.2669E+00_JPRB,4.3054E+00_JPRB,4.6429E+00_JPRB,4.8548E+00_JPRB/)
KBO( :, 4,18,10) = (/&
&5.3118E+00_JPRB,5.3090E+00_JPRB,4.1727E+00_JPRB,4.2046E+00_JPRB,4.5567E+00_JPRB,4.7652E+00_JPRB/)
KBO( :, 5,18,10) = (/&
&5.1788E+00_JPRB,5.1760E+00_JPRB,4.0826E+00_JPRB,4.1045E+00_JPRB,4.4583E+00_JPRB,4.6766E+00_JPRB/)
KBO( :, 1,19,10) = (/&
&4.9892E+00_JPRB,4.9865E+00_JPRB,4.1022E+00_JPRB,4.6290E+00_JPRB,5.1554E+00_JPRB,5.3946E+00_JPRB/)
KBO( :, 2,19,10) = (/&
&4.8951E+00_JPRB,4.8924E+00_JPRB,4.0165E+00_JPRB,4.5273E+00_JPRB,5.0702E+00_JPRB,5.3073E+00_JPRB/)
KBO( :, 3,19,10) = (/&
&4.7798E+00_JPRB,4.7773E+00_JPRB,3.9238E+00_JPRB,4.4269E+00_JPRB,4.9753E+00_JPRB,5.2208E+00_JPRB/)
KBO( :, 4,19,10) = (/&
&4.6598E+00_JPRB,4.6573E+00_JPRB,3.8352E+00_JPRB,4.3303E+00_JPRB,4.8704E+00_JPRB,5.1400E+00_JPRB/)
KBO( :, 5,19,10) = (/&
&4.5508E+00_JPRB,4.5484E+00_JPRB,3.7462E+00_JPRB,4.2290E+00_JPRB,4.7590E+00_JPRB,5.0603E+00_JPRB/)
KBO( :, 1,20,10) = (/&
&4.3446E+00_JPRB,4.3423E+00_JPRB,3.8795E+00_JPRB,4.7522E+00_JPRB,5.5065E+00_JPRB,5.7535E+00_JPRB/)
KBO( :, 2,20,10) = (/&
&4.2431E+00_JPRB,4.2409E+00_JPRB,3.7927E+00_JPRB,4.6561E+00_JPRB,5.4004E+00_JPRB,5.6800E+00_JPRB/)
KBO( :, 3,20,10) = (/&
&4.1397E+00_JPRB,4.1376E+00_JPRB,3.7047E+00_JPRB,4.5585E+00_JPRB,5.2878E+00_JPRB,5.6033E+00_JPRB/)
KBO( :, 4,20,10) = (/&
&4.0481E+00_JPRB,4.0460E+00_JPRB,3.6150E+00_JPRB,4.4575E+00_JPRB,5.1721E+00_JPRB,5.5261E+00_JPRB/)
KBO( :, 5,20,10) = (/&
&3.9765E+00_JPRB,3.9744E+00_JPRB,3.5343E+00_JPRB,4.3595E+00_JPRB,5.0554E+00_JPRB,5.4406E+00_JPRB/)
KBO( :, 1,21,10) = (/&
&3.7211E+00_JPRB,3.7192E+00_JPRB,3.7613E+00_JPRB,4.9074E+00_JPRB,5.7827E+00_JPRB,6.1154E+00_JPRB/)
KBO( :, 2,21,10) = (/&
&3.6330E+00_JPRB,3.6312E+00_JPRB,3.6717E+00_JPRB,4.8116E+00_JPRB,5.6714E+00_JPRB,6.0506E+00_JPRB/)
KBO( :, 3,21,10) = (/&
&3.5589E+00_JPRB,3.5571E+00_JPRB,3.5807E+00_JPRB,4.7108E+00_JPRB,5.5635E+00_JPRB,5.9724E+00_JPRB/)
KBO( :, 4,21,10) = (/&
&3.5073E+00_JPRB,3.5055E+00_JPRB,3.5016E+00_JPRB,4.6097E+00_JPRB,5.4603E+00_JPRB,5.8886E+00_JPRB/)
KBO( :, 5,21,10) = (/&
&3.4691E+00_JPRB,3.4674E+00_JPRB,3.4364E+00_JPRB,4.5052E+00_JPRB,5.3541E+00_JPRB,5.8090E+00_JPRB/)
KBO( :, 1,22,10) = (/&
&3.1543E+00_JPRB,3.1527E+00_JPRB,3.6782E+00_JPRB,5.0447E+00_JPRB,6.0160E+00_JPRB,6.4253E+00_JPRB/)
KBO( :, 2,22,10) = (/&
&3.0969E+00_JPRB,3.0954E+00_JPRB,3.5898E+00_JPRB,4.9499E+00_JPRB,5.9206E+00_JPRB,6.3659E+00_JPRB/)
KBO( :, 3,22,10) = (/&
&3.0620E+00_JPRB,3.0605E+00_JPRB,3.5058E+00_JPRB,4.8486E+00_JPRB,5.8265E+00_JPRB,6.2989E+00_JPRB/)
KBO( :, 4,22,10) = (/&
&3.0425E+00_JPRB,3.0410E+00_JPRB,3.4395E+00_JPRB,4.7446E+00_JPRB,5.7289E+00_JPRB,6.2283E+00_JPRB/)
KBO( :, 5,22,10) = (/&
&3.0546E+00_JPRB,3.0532E+00_JPRB,3.3854E+00_JPRB,4.6358E+00_JPRB,5.6252E+00_JPRB,6.1603E+00_JPRB/)
KBO( :, 1,23,10) = (/&
&2.6854E+00_JPRB,2.6841E+00_JPRB,3.6308E+00_JPRB,5.1459E+00_JPRB,6.2399E+00_JPRB,6.6740E+00_JPRB/)
KBO( :, 2,23,10) = (/&
&2.6617E+00_JPRB,2.6604E+00_JPRB,3.5468E+00_JPRB,5.0540E+00_JPRB,6.1652E+00_JPRB,6.6315E+00_JPRB/)
KBO( :, 3,23,10) = (/&
&2.6584E+00_JPRB,2.6571E+00_JPRB,3.4703E+00_JPRB,4.9599E+00_JPRB,6.0780E+00_JPRB,6.5824E+00_JPRB/)
KBO( :, 4,23,10) = (/&
&2.6872E+00_JPRB,2.6859E+00_JPRB,3.4111E+00_JPRB,4.8587E+00_JPRB,5.9856E+00_JPRB,6.5287E+00_JPRB/)
KBO( :, 5,23,10) = (/&
&2.7417E+00_JPRB,2.7405E+00_JPRB,3.3560E+00_JPRB,4.7548E+00_JPRB,5.8884E+00_JPRB,6.4686E+00_JPRB/)
KBO( :, 1,24,10) = (/&
&2.3151E+00_JPRB,2.3140E+00_JPRB,3.5886E+00_JPRB,5.2274E+00_JPRB,6.4311E+00_JPRB,6.8789E+00_JPRB/)
KBO( :, 2,24,10) = (/&
&2.3230E+00_JPRB,2.3219E+00_JPRB,3.5113E+00_JPRB,5.1442E+00_JPRB,6.3705E+00_JPRB,6.8549E+00_JPRB/)
KBO( :, 3,24,10) = (/&
&2.3609E+00_JPRB,2.3598E+00_JPRB,3.4524E+00_JPRB,5.0514E+00_JPRB,6.2984E+00_JPRB,6.8163E+00_JPRB/)
KBO( :, 4,24,10) = (/&
&2.4175E+00_JPRB,2.4164E+00_JPRB,3.3989E+00_JPRB,4.9521E+00_JPRB,6.2181E+00_JPRB,6.7710E+00_JPRB/)
KBO( :, 5,24,10) = (/&
&2.4762E+00_JPRB,2.4752E+00_JPRB,3.3577E+00_JPRB,4.8533E+00_JPRB,6.1278E+00_JPRB,6.7244E+00_JPRB/)
KBO( :, 1,25,10) = (/&
&2.0244E+00_JPRB,2.0235E+00_JPRB,3.5269E+00_JPRB,5.2724E+00_JPRB,6.5740E+00_JPRB,7.0315E+00_JPRB/)
KBO( :, 2,25,10) = (/&
&2.0651E+00_JPRB,2.0643E+00_JPRB,3.4750E+00_JPRB,5.1965E+00_JPRB,6.5327E+00_JPRB,7.0283E+00_JPRB/)
KBO( :, 3,25,10) = (/&
&2.1229E+00_JPRB,2.1220E+00_JPRB,3.4316E+00_JPRB,5.1098E+00_JPRB,6.4777E+00_JPRB,7.0013E+00_JPRB/)
KBO( :, 4,25,10) = (/&
&2.1858E+00_JPRB,2.1849E+00_JPRB,3.3932E+00_JPRB,5.0189E+00_JPRB,6.4050E+00_JPRB,6.9699E+00_JPRB/)
KBO( :, 5,25,10) = (/&
&2.2519E+00_JPRB,2.2510E+00_JPRB,3.3680E+00_JPRB,4.9354E+00_JPRB,6.3143E+00_JPRB,6.9411E+00_JPRB/)
KBO( :, 1,26,10) = (/&
&1.8038E+00_JPRB,1.8031E+00_JPRB,3.4751E+00_JPRB,5.2741E+00_JPRB,6.6754E+00_JPRB,7.1367E+00_JPRB/)
KBO( :, 2,26,10) = (/&
&1.8584E+00_JPRB,1.8577E+00_JPRB,3.4421E+00_JPRB,5.2128E+00_JPRB,6.6468E+00_JPRB,7.1525E+00_JPRB/)
KBO( :, 3,26,10) = (/&
&1.9217E+00_JPRB,1.9209E+00_JPRB,3.4089E+00_JPRB,5.1445E+00_JPRB,6.6040E+00_JPRB,7.1457E+00_JPRB/)
KBO( :, 4,26,10) = (/&
&1.9824E+00_JPRB,1.9816E+00_JPRB,3.3919E+00_JPRB,5.0736E+00_JPRB,6.5398E+00_JPRB,7.1301E+00_JPRB/)
KBO( :, 5,26,10) = (/&
&2.0431E+00_JPRB,2.0423E+00_JPRB,3.3693E+00_JPRB,5.0098E+00_JPRB,6.4614E+00_JPRB,7.1116E+00_JPRB/)
KBO( :, 1,27,10) = (/&
&1.6205E+00_JPRB,1.6200E+00_JPRB,3.4312E+00_JPRB,5.2512E+00_JPRB,6.7302E+00_JPRB,7.1916E+00_JPRB/)
KBO( :, 2,27,10) = (/&
&1.6821E+00_JPRB,1.6815E+00_JPRB,3.4096E+00_JPRB,5.2107E+00_JPRB,6.7204E+00_JPRB,7.2341E+00_JPRB/)
KBO( :, 3,27,10) = (/&
&1.7393E+00_JPRB,1.7387E+00_JPRB,3.3986E+00_JPRB,5.1611E+00_JPRB,6.6901E+00_JPRB,7.2461E+00_JPRB/)
KBO( :, 4,27,10) = (/&
&1.7952E+00_JPRB,1.7945E+00_JPRB,3.3849E+00_JPRB,5.1118E+00_JPRB,6.6400E+00_JPRB,7.2521E+00_JPRB/)
KBO( :, 5,27,10) = (/&
&1.8467E+00_JPRB,1.8460E+00_JPRB,3.3678E+00_JPRB,5.0688E+00_JPRB,6.5750E+00_JPRB,7.2529E+00_JPRB/)
KBO( :, 1,28,10) = (/&
&1.4581E+00_JPRB,1.4577E+00_JPRB,3.3793E+00_JPRB,5.2151E+00_JPRB,6.7528E+00_JPRB,7.2099E+00_JPRB/)
KBO( :, 2,28,10) = (/&
&1.5130E+00_JPRB,1.5126E+00_JPRB,3.3785E+00_JPRB,5.1947E+00_JPRB,6.7653E+00_JPRB,7.2740E+00_JPRB/)
KBO( :, 3,28,10) = (/&
&1.5669E+00_JPRB,1.5664E+00_JPRB,3.3810E+00_JPRB,5.1664E+00_JPRB,6.7512E+00_JPRB,7.3192E+00_JPRB/)
KBO( :, 4,28,10) = (/&
&1.6172E+00_JPRB,1.6166E+00_JPRB,3.3732E+00_JPRB,5.1425E+00_JPRB,6.7177E+00_JPRB,7.3590E+00_JPRB/)
KBO( :, 5,28,10) = (/&
&1.6631E+00_JPRB,1.6625E+00_JPRB,3.3694E+00_JPRB,5.1109E+00_JPRB,6.6624E+00_JPRB,7.3782E+00_JPRB/)
KBO( :, 1,29,10) = (/&
&1.3022E+00_JPRB,1.3019E+00_JPRB,3.3270E+00_JPRB,5.1728E+00_JPRB,6.7559E+00_JPRB,7.2096E+00_JPRB/)
KBO( :, 2,29,10) = (/&
&1.3533E+00_JPRB,1.3529E+00_JPRB,3.3473E+00_JPRB,5.1723E+00_JPRB,6.7905E+00_JPRB,7.3069E+00_JPRB/)
KBO( :, 3,29,10) = (/&
&1.4031E+00_JPRB,1.4027E+00_JPRB,3.3571E+00_JPRB,5.1703E+00_JPRB,6.7965E+00_JPRB,7.3925E+00_JPRB/)
KBO( :, 4,29,10) = (/&
&1.4491E+00_JPRB,1.4487E+00_JPRB,3.3643E+00_JPRB,5.1652E+00_JPRB,6.7741E+00_JPRB,7.4637E+00_JPRB/)
KBO( :, 5,29,10) = (/&
&1.4926E+00_JPRB,1.4921E+00_JPRB,3.3697E+00_JPRB,5.1473E+00_JPRB,6.7261E+00_JPRB,7.4940E+00_JPRB/)
KBO( :, 1,30,10) = (/&
&1.1600E+00_JPRB,1.1597E+00_JPRB,3.2811E+00_JPRB,5.1242E+00_JPRB,6.7455E+00_JPRB,7.2055E+00_JPRB/)
KBO( :, 2,30,10) = (/&
&1.2064E+00_JPRB,1.2061E+00_JPRB,3.3125E+00_JPRB,5.1497E+00_JPRB,6.8027E+00_JPRB,7.3456E+00_JPRB/)
KBO( :, 3,30,10) = (/&
&1.2511E+00_JPRB,1.2508E+00_JPRB,3.3366E+00_JPRB,5.1707E+00_JPRB,6.8233E+00_JPRB,7.4712E+00_JPRB/)
KBO( :, 4,30,10) = (/&
&1.2939E+00_JPRB,1.2935E+00_JPRB,3.3556E+00_JPRB,5.1801E+00_JPRB,6.8143E+00_JPRB,7.5611E+00_JPRB/)
KBO( :, 5,30,10) = (/&
&1.3350E+00_JPRB,1.3346E+00_JPRB,3.3660E+00_JPRB,5.1735E+00_JPRB,6.7754E+00_JPRB,7.6031E+00_JPRB/)
KBO( :, 1,31,10) = (/&
&1.0335E+00_JPRB,1.0333E+00_JPRB,3.2413E+00_JPRB,5.0768E+00_JPRB,6.7328E+00_JPRB,7.2247E+00_JPRB/)
KBO( :, 2,31,10) = (/&
&1.0751E+00_JPRB,1.0749E+00_JPRB,3.2817E+00_JPRB,5.1294E+00_JPRB,6.8096E+00_JPRB,7.4118E+00_JPRB/)
KBO( :, 3,31,10) = (/&
&1.1154E+00_JPRB,1.1152E+00_JPRB,3.3173E+00_JPRB,5.1678E+00_JPRB,6.8467E+00_JPRB,7.5648E+00_JPRB/)
KBO( :, 4,31,10) = (/&
&1.1549E+00_JPRB,1.1546E+00_JPRB,3.3453E+00_JPRB,5.1899E+00_JPRB,6.8485E+00_JPRB,7.6626E+00_JPRB/)
KBO( :, 5,31,10) = (/&
&1.1976E+00_JPRB,1.1973E+00_JPRB,3.3597E+00_JPRB,5.1968E+00_JPRB,6.8174E+00_JPRB,7.7173E+00_JPRB/)
KBO( :, 1,32,10) = (/&
&9.2196E-01_JPRB,9.2184E-01_JPRB,3.2061E+00_JPRB,5.0420E+00_JPRB,6.7251E+00_JPRB,7.2717E+00_JPRB/)
KBO( :, 2,32,10) = (/&
&9.5916E-01_JPRB,9.5901E-01_JPRB,3.2581E+00_JPRB,5.1143E+00_JPRB,6.8187E+00_JPRB,7.4921E+00_JPRB/)
KBO( :, 3,32,10) = (/&
&9.9613E-01_JPRB,9.9593E-01_JPRB,3.3030E+00_JPRB,5.1678E+00_JPRB,6.8677E+00_JPRB,7.6515E+00_JPRB/)
KBO( :, 4,32,10) = (/&
&1.0359E+00_JPRB,1.0357E+00_JPRB,3.3356E+00_JPRB,5.2002E+00_JPRB,6.8779E+00_JPRB,7.7596E+00_JPRB/)
KBO( :, 5,32,10) = (/&
&1.0855E+00_JPRB,1.0851E+00_JPRB,3.3519E+00_JPRB,5.2172E+00_JPRB,6.8517E+00_JPRB,7.8246E+00_JPRB/)
KBO( :, 1,33,10) = (/&
&8.2444E-01_JPRB,8.2438E-01_JPRB,3.1786E+00_JPRB,5.0173E+00_JPRB,6.7243E+00_JPRB,7.3448E+00_JPRB/)
KBO( :, 2,33,10) = (/&
&8.5838E-01_JPRB,8.5826E-01_JPRB,3.2411E+00_JPRB,5.1061E+00_JPRB,6.8299E+00_JPRB,7.5783E+00_JPRB/)
KBO( :, 3,33,10) = (/&
&8.9425E-01_JPRB,8.9407E-01_JPRB,3.2909E+00_JPRB,5.1715E+00_JPRB,6.8889E+00_JPRB,7.7451E+00_JPRB/)
KBO( :, 4,33,10) = (/&
&9.3902E-01_JPRB,9.3875E-01_JPRB,3.3252E+00_JPRB,5.2146E+00_JPRB,6.9056E+00_JPRB,7.8681E+00_JPRB/)
KBO( :, 5,33,10) = (/&
&9.9963E-01_JPRB,9.9926E-01_JPRB,3.3429E+00_JPRB,5.2364E+00_JPRB,6.8820E+00_JPRB,7.9383E+00_JPRB/)
KBO( :, 1,34,10) = (/&
&7.3808E-01_JPRB,7.3807E-01_JPRB,3.1554E+00_JPRB,5.0005E+00_JPRB,6.7270E+00_JPRB,7.4193E+00_JPRB/)
KBO( :, 2,34,10) = (/&
&7.7041E-01_JPRB,7.7031E-01_JPRB,3.2245E+00_JPRB,5.1037E+00_JPRB,6.8428E+00_JPRB,7.6564E+00_JPRB/)
KBO( :, 3,34,10) = (/&
&8.0927E-01_JPRB,8.0908E-01_JPRB,3.2785E+00_JPRB,5.1786E+00_JPRB,6.9090E+00_JPRB,7.8421E+00_JPRB/)
KBO( :, 4,34,10) = (/&
&8.6226E-01_JPRB,8.6198E-01_JPRB,3.3161E+00_JPRB,5.2290E+00_JPRB,6.9264E+00_JPRB,7.9654E+00_JPRB/)
KBO( :, 5,34,10) = (/&
&9.3161E-01_JPRB,9.3129E-01_JPRB,3.3332E+00_JPRB,5.2535E+00_JPRB,6.9068E+00_JPRB,8.0359E+00_JPRB/)
KBO( :, 1,35,10) = (/&
&6.6091E-01_JPRB,6.6090E-01_JPRB,3.1297E+00_JPRB,4.9826E+00_JPRB,6.7231E+00_JPRB,7.4730E+00_JPRB/)
KBO( :, 2,35,10) = (/&
&6.9343E-01_JPRB,6.9337E-01_JPRB,3.2054E+00_JPRB,5.0985E+00_JPRB,6.8504E+00_JPRB,7.7289E+00_JPRB/)
KBO( :, 3,35,10) = (/&
&7.3707E-01_JPRB,7.3689E-01_JPRB,3.2647E+00_JPRB,5.1833E+00_JPRB,6.9233E+00_JPRB,7.9244E+00_JPRB/)
KBO( :, 4,35,10) = (/&
&7.9689E-01_JPRB,7.9665E-01_JPRB,3.3047E+00_JPRB,5.2421E+00_JPRB,6.9456E+00_JPRB,8.0506E+00_JPRB/)
KBO( :, 5,35,10) = (/&
&8.7135E-01_JPRB,8.7107E-01_JPRB,3.3248E+00_JPRB,5.2688E+00_JPRB,6.9299E+00_JPRB,8.1175E+00_JPRB/)
KBO( :, 1,36,10) = (/&
&5.9261E-01_JPRB,5.9263E-01_JPRB,3.0998E+00_JPRB,4.9572E+00_JPRB,6.7063E+00_JPRB,7.5006E+00_JPRB/)
KBO( :, 2,36,10) = (/&
&6.2616E-01_JPRB,6.2611E-01_JPRB,3.1830E+00_JPRB,5.0867E+00_JPRB,6.8489E+00_JPRB,7.7811E+00_JPRB/)
KBO( :, 3,36,10) = (/&
&6.7343E-01_JPRB,6.7330E-01_JPRB,3.2478E+00_JPRB,5.1832E+00_JPRB,6.9309E+00_JPRB,7.9826E+00_JPRB/)
KBO( :, 4,36,10) = (/&
&7.3660E-01_JPRB,7.3640E-01_JPRB,3.2928E+00_JPRB,5.2484E+00_JPRB,6.9611E+00_JPRB,8.1184E+00_JPRB/)
KBO( :, 5,36,10) = (/&
&8.1395E-01_JPRB,8.1372E-01_JPRB,3.3165E+00_JPRB,5.2807E+00_JPRB,6.9512E+00_JPRB,8.1925E+00_JPRB/)
KBO( :, 1,37,10) = (/&
&5.2989E-01_JPRB,5.2996E-01_JPRB,3.0580E+00_JPRB,4.9104E+00_JPRB,6.6637E+00_JPRB,7.4740E+00_JPRB/)
KBO( :, 2,37,10) = (/&
&5.6419E-01_JPRB,5.6414E-01_JPRB,3.1506E+00_JPRB,5.0576E+00_JPRB,6.8262E+00_JPRB,7.7836E+00_JPRB/)
KBO( :, 3,37,10) = (/&
&6.1196E-01_JPRB,6.1186E-01_JPRB,3.2232E+00_JPRB,5.1694E+00_JPRB,6.9254E+00_JPRB,8.0021E+00_JPRB/)
KBO( :, 4,37,10) = (/&
&6.7516E-01_JPRB,6.7503E-01_JPRB,3.2773E+00_JPRB,5.2468E+00_JPRB,6.9696E+00_JPRB,8.1546E+00_JPRB/)
KBO( :, 5,37,10) = (/&
&7.5242E-01_JPRB,7.5225E-01_JPRB,3.3077E+00_JPRB,5.2880E+00_JPRB,6.9712E+00_JPRB,8.2436E+00_JPRB/)
KBO( :, 1,38,10) = (/&
&4.7505E-01_JPRB,4.7513E-01_JPRB,3.0176E+00_JPRB,4.8628E+00_JPRB,6.6172E+00_JPRB,7.4494E+00_JPRB/)
KBO( :, 2,38,10) = (/&
&5.1071E-01_JPRB,5.1070E-01_JPRB,3.1197E+00_JPRB,5.0269E+00_JPRB,6.7975E+00_JPRB,7.7810E+00_JPRB/)
KBO( :, 3,38,10) = (/&
&5.5877E-01_JPRB,5.5872E-01_JPRB,3.2002E+00_JPRB,5.1526E+00_JPRB,6.9148E+00_JPRB,8.0180E+00_JPRB/)
KBO( :, 4,38,10) = (/&
&6.2123E-01_JPRB,6.2116E-01_JPRB,3.2619E+00_JPRB,5.2424E+00_JPRB,6.9725E+00_JPRB,8.1853E+00_JPRB/)
KBO( :, 5,38,10) = (/&
&6.9700E-01_JPRB,6.9689E-01_JPRB,3.2986E+00_JPRB,5.2927E+00_JPRB,6.9850E+00_JPRB,8.2945E+00_JPRB/)
KBO( :, 1,39,10) = (/&
&4.2667E-01_JPRB,4.2675E-01_JPRB,2.9792E+00_JPRB,4.8162E+00_JPRB,6.5678E+00_JPRB,7.4301E+00_JPRB/)
KBO( :, 2,39,10) = (/&
&4.6368E-01_JPRB,4.6371E-01_JPRB,3.0898E+00_JPRB,4.9949E+00_JPRB,6.7657E+00_JPRB,7.7791E+00_JPRB/)
KBO( :, 3,39,10) = (/&
&5.1271E-01_JPRB,5.1271E-01_JPRB,3.1789E+00_JPRB,5.1345E+00_JPRB,6.8995E+00_JPRB,8.0327E+00_JPRB/)
KBO( :, 4,39,10) = (/&
&5.7418E-01_JPRB,5.7416E-01_JPRB,3.2474E+00_JPRB,5.2350E+00_JPRB,6.9705E+00_JPRB,8.2154E+00_JPRB/)
KBO( :, 5,39,10) = (/&
&6.4813E-01_JPRB,6.4808E-01_JPRB,3.2906E+00_JPRB,5.2946E+00_JPRB,6.9954E+00_JPRB,8.3481E+00_JPRB/)
KBO( :, 1,40,10) = (/&
&3.8059E-01_JPRB,3.8066E-01_JPRB,2.9294E+00_JPRB,4.7482E+00_JPRB,6.4900E+00_JPRB,7.3413E+00_JPRB/)
KBO( :, 2,40,10) = (/&
&4.1764E-01_JPRB,4.1768E-01_JPRB,3.0517E+00_JPRB,4.9455E+00_JPRB,6.7137E+00_JPRB,7.7220E+00_JPRB/)
KBO( :, 3,40,10) = (/&
&4.6631E-01_JPRB,4.6635E-01_JPRB,3.1498E+00_JPRB,5.1004E+00_JPRB,6.8682E+00_JPRB,8.0003E+00_JPRB/)
KBO( :, 4,40,10) = (/&
&5.2644E-01_JPRB,5.2648E-01_JPRB,3.2265E+00_JPRB,5.2162E+00_JPRB,6.9603E+00_JPRB,8.2072E+00_JPRB/)
KBO( :, 5,40,10) = (/&
&5.9702E-01_JPRB,5.9703E-01_JPRB,3.2787E+00_JPRB,5.2882E+00_JPRB,7.0004E+00_JPRB,8.3571E+00_JPRB/)
KBO( :, 1,41,10) = (/&
&3.3906E-01_JPRB,3.3914E-01_JPRB,2.8764E+00_JPRB,4.6750E+00_JPRB,6.4031E+00_JPRB,7.2374E+00_JPRB/)
KBO( :, 2,41,10) = (/&
&3.7555E-01_JPRB,3.7562E-01_JPRB,3.0116E+00_JPRB,4.8899E+00_JPRB,6.6527E+00_JPRB,7.6510E+00_JPRB/)
KBO( :, 3,41,10) = (/&
&4.2374E-01_JPRB,4.2382E-01_JPRB,3.1192E+00_JPRB,5.0596E+00_JPRB,6.8298E+00_JPRB,7.9584E+00_JPRB/)
KBO( :, 4,41,10) = (/&
&4.8252E-01_JPRB,4.8261E-01_JPRB,3.2032E+00_JPRB,5.1909E+00_JPRB,6.9423E+00_JPRB,8.1883E+00_JPRB/)
KBO( :, 5,41,10) = (/&
&5.5055E-01_JPRB,5.5059E-01_JPRB,3.2647E+00_JPRB,5.2767E+00_JPRB,6.9993E+00_JPRB,8.3564E+00_JPRB/)
KBO( :, 1,42,10) = (/&
&3.0216E-01_JPRB,3.0227E-01_JPRB,2.8228E+00_JPRB,4.6001E+00_JPRB,6.3100E+00_JPRB,7.1283E+00_JPRB/)
KBO( :, 2,42,10) = (/&
&3.3749E-01_JPRB,3.3759E-01_JPRB,2.9700E+00_JPRB,4.8303E+00_JPRB,6.5864E+00_JPRB,7.5749E+00_JPRB/)
KBO( :, 3,42,10) = (/&
&3.8480E-01_JPRB,3.8492E-01_JPRB,3.0865E+00_JPRB,5.0162E+00_JPRB,6.7847E+00_JPRB,7.9100E+00_JPRB/)
KBO( :, 4,42,10) = (/&
&4.4288E-01_JPRB,4.4301E-01_JPRB,3.1790E+00_JPRB,5.1608E+00_JPRB,6.9184E+00_JPRB,8.1647E+00_JPRB/)
KBO( :, 5,42,10) = (/&
&5.0928E-01_JPRB,5.0935E-01_JPRB,3.2490E+00_JPRB,5.2607E+00_JPRB,6.9918E+00_JPRB,8.3533E+00_JPRB/)
KBO( :, 1,43,10) = (/&
&2.6768E-01_JPRB,2.6781E-01_JPRB,2.7595E+00_JPRB,4.5068E+00_JPRB,6.1924E+00_JPRB,6.9816E+00_JPRB/)
KBO( :, 2,43,10) = (/&
&3.0121E-01_JPRB,3.0134E-01_JPRB,2.9195E+00_JPRB,4.7538E+00_JPRB,6.4985E+00_JPRB,7.4658E+00_JPRB/)
KBO( :, 3,43,10) = (/&
&3.4636E-01_JPRB,3.4652E-01_JPRB,3.0475E+00_JPRB,4.9586E+00_JPRB,6.7250E+00_JPRB,7.8363E+00_JPRB/)
KBO( :, 4,43,10) = (/&
&4.0279E-01_JPRB,4.0294E-01_JPRB,3.1487E+00_JPRB,5.1186E+00_JPRB,6.8816E+00_JPRB,8.1193E+00_JPRB/)
KBO( :, 5,43,10) = (/&
&4.6775E-01_JPRB,4.6784E-01_JPRB,3.2281E+00_JPRB,5.2365E+00_JPRB,6.9765E+00_JPRB,8.3335E+00_JPRB/)
KBO( :, 1,44,10) = (/&
&2.3663E-01_JPRB,2.3679E-01_JPRB,2.6889E+00_JPRB,4.3996E+00_JPRB,6.0559E+00_JPRB,6.8135E+00_JPRB/)
KBO( :, 2,44,10) = (/&
&2.6748E-01_JPRB,2.6764E-01_JPRB,2.8618E+00_JPRB,4.6667E+00_JPRB,6.3943E+00_JPRB,7.3355E+00_JPRB/)
KBO( :, 3,44,10) = (/&
&3.1007E-01_JPRB,3.1028E-01_JPRB,3.0033E+00_JPRB,4.8904E+00_JPRB,6.6510E+00_JPRB,7.7469E+00_JPRB/)
KBO( :, 4,44,10) = (/&
&3.6426E-01_JPRB,3.6444E-01_JPRB,3.1143E+00_JPRB,5.0666E+00_JPRB,6.8341E+00_JPRB,8.0609E+00_JPRB/)
KBO( :, 5,44,10) = (/&
&4.2790E-01_JPRB,4.2800E-01_JPRB,3.2017E+00_JPRB,5.2027E+00_JPRB,6.9510E+00_JPRB,8.3005E+00_JPRB/)
KBO( :, 1,45,10) = (/&
&2.0943E-01_JPRB,2.0961E-01_JPRB,2.6149E+00_JPRB,4.2870E+00_JPRB,5.9088E+00_JPRB,6.6376E+00_JPRB/)
KBO( :, 2,45,10) = (/&
&2.3748E-01_JPRB,2.3768E-01_JPRB,2.7996E+00_JPRB,4.5739E+00_JPRB,6.2800E+00_JPRB,7.1981E+00_JPRB/)
KBO( :, 3,45,10) = (/&
&2.7717E-01_JPRB,2.7741E-01_JPRB,2.9545E+00_JPRB,4.8149E+00_JPRB,6.5679E+00_JPRB,7.6498E+00_JPRB/)
KBO( :, 4,45,10) = (/&
&3.2881E-01_JPRB,3.2900E-01_JPRB,3.0769E+00_JPRB,5.0100E+00_JPRB,6.7767E+00_JPRB,7.9956E+00_JPRB/)
KBO( :, 5,45,10) = (/&
&3.9089E-01_JPRB,3.9099E-01_JPRB,3.1729E+00_JPRB,5.1617E+00_JPRB,6.9184E+00_JPRB,8.2647E+00_JPRB/)
KBO( :, 1,46,10) = (/&
&1.8488E-01_JPRB,1.8509E-01_JPRB,2.5337E+00_JPRB,4.1619E+00_JPRB,5.7408E+00_JPRB,6.4343E+00_JPRB/)
KBO( :, 2,46,10) = (/&
&2.1029E-01_JPRB,2.1052E-01_JPRB,2.7308E+00_JPRB,4.4685E+00_JPRB,6.1476E+00_JPRB,7.0351E+00_JPRB/)
KBO( :, 3,46,10) = (/&
&2.4641E-01_JPRB,2.4669E-01_JPRB,2.8991E+00_JPRB,4.7282E+00_JPRB,6.4680E+00_JPRB,7.5299E+00_JPRB/)
KBO( :, 4,46,10) = (/&
&2.9502E-01_JPRB,2.9523E-01_JPRB,3.0336E+00_JPRB,4.9428E+00_JPRB,6.7064E+00_JPRB,7.9122E+00_JPRB/)
KBO( :, 5,46,10) = (/&
&3.5492E-01_JPRB,3.5504E-01_JPRB,3.1395E+00_JPRB,5.1108E+00_JPRB,6.8742E+00_JPRB,8.2122E+00_JPRB/)
KBO( :, 1,47,10) = (/&
&1.6240E-01_JPRB,1.6263E-01_JPRB,2.4388E+00_JPRB,4.0166E+00_JPRB,5.5397E+00_JPRB,6.1804E+00_JPRB/)
KBO( :, 2,47,10) = (/&
&1.8504E-01_JPRB,1.8532E-01_JPRB,2.6496E+00_JPRB,4.3442E+00_JPRB,5.9864E+00_JPRB,6.8265E+00_JPRB/)
KBO( :, 3,47,10) = (/&
&2.1735E-01_JPRB,2.1764E-01_JPRB,2.8316E+00_JPRB,4.6250E+00_JPRB,6.3441E+00_JPRB,7.3704E+00_JPRB/)
KBO( :, 4,47,10) = (/&
&2.6219E-01_JPRB,2.6243E-01_JPRB,2.9807E+00_JPRB,4.8597E+00_JPRB,6.6165E+00_JPRB,7.7948E+00_JPRB/)
KBO( :, 5,47,10) = (/&
&3.1904E-01_JPRB,3.1916E-01_JPRB,3.0987E+00_JPRB,5.0473E+00_JPRB,6.8132E+00_JPRB,8.1318E+00_JPRB/)
KBO( :, 1,48,10) = (/&
&1.4274E-01_JPRB,1.4309E-01_JPRB,2.3378E+00_JPRB,3.8621E+00_JPRB,5.3223E+00_JPRB,5.9129E+00_JPRB/)
KBO( :, 2,48,10) = (/&
&1.6289E-01_JPRB,1.6319E-01_JPRB,2.5631E+00_JPRB,4.2108E+00_JPRB,5.8103E+00_JPRB,6.6062E+00_JPRB/)
KBO( :, 3,48,10) = (/&
&1.9167E-01_JPRB,1.9198E-01_JPRB,2.7584E+00_JPRB,4.5133E+00_JPRB,6.2051E+00_JPRB,7.1967E+00_JPRB/)
KBO( :, 4,48,10) = (/&
&2.3239E-01_JPRB,2.3264E-01_JPRB,2.9226E+00_JPRB,4.7680E+00_JPRB,6.5135E+00_JPRB,7.6665E+00_JPRB/)
KBO( :, 5,48,10) = (/&
&2.8577E-01_JPRB,2.8592E-01_JPRB,3.0525E+00_JPRB,4.9759E+00_JPRB,6.7401E+00_JPRB,8.0423E+00_JPRB/)
KBO( :, 1,49,10) = (/&
&1.2506E-01_JPRB,1.2569E-01_JPRB,2.2315E+00_JPRB,3.6984E+00_JPRB,5.0916E+00_JPRB,5.6363E+00_JPRB/)
KBO( :, 2,49,10) = (/&
&1.4348E-01_JPRB,1.4383E-01_JPRB,2.4717E+00_JPRB,4.0691E+00_JPRB,5.6178E+00_JPRB,6.3745E+00_JPRB/)
KBO( :, 3,49,10) = (/&
&1.6900E-01_JPRB,1.6934E-01_JPRB,2.6802E+00_JPRB,4.3928E+00_JPRB,6.0515E+00_JPRB,7.0127E+00_JPRB/)
KBO( :, 4,49,10) = (/&
&2.0581E-01_JPRB,2.0606E-01_JPRB,2.8586E+00_JPRB,4.6682E+00_JPRB,6.3962E+00_JPRB,7.5292E+00_JPRB/)
KBO( :, 5,49,10) = (/&
&2.5518E-01_JPRB,2.5533E-01_JPRB,3.0025E+00_JPRB,4.8968E+00_JPRB,6.6558E+00_JPRB,7.9457E+00_JPRB/)
KBO( :, 1,50,10) = (/&
&1.0959E-01_JPRB,1.1070E-01_JPRB,2.1267E+00_JPRB,3.5368E+00_JPRB,4.8615E+00_JPRB,5.3538E+00_JPRB/)
KBO( :, 2,50,10) = (/&
&1.2689E-01_JPRB,1.2744E-01_JPRB,2.3809E+00_JPRB,3.9302E+00_JPRB,5.4235E+00_JPRB,6.1306E+00_JPRB/)
KBO( :, 3,50,10) = (/&
&1.4973E-01_JPRB,1.5009E-01_JPRB,2.6019E+00_JPRB,4.2725E+00_JPRB,5.8946E+00_JPRB,6.8112E+00_JPRB/)
KBO( :, 4,50,10) = (/&
&1.8304E-01_JPRB,1.8331E-01_JPRB,2.7927E+00_JPRB,4.5675E+00_JPRB,6.2731E+00_JPRB,7.3745E+00_JPRB/)
KBO( :, 5,50,10) = (/&
&2.2866E-01_JPRB,2.2882E-01_JPRB,2.9508E+00_JPRB,4.8146E+00_JPRB,6.5657E+00_JPRB,7.8282E+00_JPRB/)
KBO( :, 1,51,10) = (/&
&9.5768E-02_JPRB,9.7661E-02_JPRB,2.0216E+00_JPRB,3.3751E+00_JPRB,4.6268E+00_JPRB,5.0597E+00_JPRB/)
KBO( :, 2,51,10) = (/&
&1.1216E-01_JPRB,1.1307E-01_JPRB,2.2881E+00_JPRB,3.7875E+00_JPRB,5.2217E+00_JPRB,5.8744E+00_JPRB/)
KBO( :, 3,51,10) = (/&
&1.3299E-01_JPRB,1.3343E-01_JPRB,2.5219E+00_JPRB,4.1480E+00_JPRB,5.7284E+00_JPRB,6.5943E+00_JPRB/)
KBO( :, 4,51,10) = (/&
&1.6308E-01_JPRB,1.6337E-01_JPRB,2.7248E+00_JPRB,4.4626E+00_JPRB,6.1415E+00_JPRB,7.2033E+00_JPRB/)
KBO( :, 5,51,10) = (/&
&2.0524E-01_JPRB,2.0541E-01_JPRB,2.8961E+00_JPRB,4.7281E+00_JPRB,6.4666E+00_JPRB,7.6945E+00_JPRB/)
KBO( :, 1,52,10) = (/&
&8.3171E-02_JPRB,8.6221E-02_JPRB,1.9144E+00_JPRB,3.2076E+00_JPRB,4.3819E+00_JPRB,4.7580E+00_JPRB/)
KBO( :, 2,52,10) = (/&
&9.8912E-02_JPRB,1.0039E-01_JPRB,2.1906E+00_JPRB,3.6370E+00_JPRB,5.0088E+00_JPRB,5.6089E+00_JPRB/)
KBO( :, 3,52,10) = (/&
&1.1809E-01_JPRB,1.1874E-01_JPRB,2.4381E+00_JPRB,4.0185E+00_JPRB,5.5505E+00_JPRB,6.3684E+00_JPRB/)
KBO( :, 4,52,10) = (/&
&1.4539E-01_JPRB,1.4572E-01_JPRB,2.6526E+00_JPRB,4.3511E+00_JPRB,5.9980E+00_JPRB,7.0214E+00_JPRB/)
KBO( :, 5,52,10) = (/&
&1.8406E-01_JPRB,1.8425E-01_JPRB,2.8362E+00_JPRB,4.6354E+00_JPRB,6.3565E+00_JPRB,7.5532E+00_JPRB/)
KBO( :, 1,53,10) = (/&
&7.1760E-02_JPRB,7.6225E-02_JPRB,1.8049E+00_JPRB,3.0338E+00_JPRB,4.1285E+00_JPRB,4.4543E+00_JPRB/)
KBO( :, 2,53,10) = (/&
&8.6733E-02_JPRB,8.9133E-02_JPRB,2.0890E+00_JPRB,3.4808E+00_JPRB,4.7838E+00_JPRB,5.3384E+00_JPRB/)
KBO( :, 3,53,10) = (/&
&1.0470E-01_JPRB,1.0571E-01_JPRB,2.3496E+00_JPRB,3.8826E+00_JPRB,5.3593E+00_JPRB,6.1340E+00_JPRB/)
KBO( :, 4,53,10) = (/&
&1.2964E-01_JPRB,1.3004E-01_JPRB,2.5758E+00_JPRB,4.2328E+00_JPRB,5.8432E+00_JPRB,6.8310E+00_JPRB/)
KBO( :, 5,53,10) = (/&
&1.6486E-01_JPRB,1.6505E-01_JPRB,2.7718E+00_JPRB,4.5358E+00_JPRB,6.2341E+00_JPRB,7.4042E+00_JPRB/)
KBO( :, 1,54,10) = (/&
&6.1882E-02_JPRB,6.7940E-02_JPRB,1.7027E+00_JPRB,2.8705E+00_JPRB,3.8894E+00_JPRB,4.1460E+00_JPRB/)
KBO( :, 2,54,10) = (/&
&7.6155E-02_JPRB,7.9684E-02_JPRB,1.9930E+00_JPRB,3.3325E+00_JPRB,4.5678E+00_JPRB,5.0509E+00_JPRB/)
KBO( :, 3,54,10) = (/&
&9.3240E-02_JPRB,9.4826E-02_JPRB,2.2641E+00_JPRB,3.7513E+00_JPRB,5.1730E+00_JPRB,5.8771E+00_JPRB/)
KBO( :, 4,54,10) = (/&
&1.1632E-01_JPRB,1.1690E-01_JPRB,2.5020E+00_JPRB,4.1182E+00_JPRB,5.6892E+00_JPRB,6.6127E+00_JPRB/)
KBO( :, 5,54,10) = (/&
&1.4865E-01_JPRB,1.4887E-01_JPRB,2.7085E+00_JPRB,4.4384E+00_JPRB,6.1110E+00_JPRB,7.2268E+00_JPRB/)
KBO( :, 1,55,10) = (/&
&5.3143E-02_JPRB,6.0929E-02_JPRB,1.6034E+00_JPRB,2.7108E+00_JPRB,3.6519E+00_JPRB,3.8346E+00_JPRB/)
KBO( :, 2,55,10) = (/&
&6.6664E-02_JPRB,7.1549E-02_JPRB,1.8993E+00_JPRB,3.1854E+00_JPRB,4.3528E+00_JPRB,4.7449E+00_JPRB/)
KBO( :, 3,55,10) = (/&
&8.2988E-02_JPRB,8.5434E-02_JPRB,2.1781E+00_JPRB,3.6188E+00_JPRB,4.9850E+00_JPRB,5.6016E+00_JPRB/)
KBO( :, 4,55,10) = (/&
&1.0455E-01_JPRB,1.0541E-01_JPRB,2.4283E+00_JPRB,4.0035E+00_JPRB,5.5314E+00_JPRB,6.3670E+00_JPRB/)
KBO( :, 5,55,10) = (/&
&1.3450E-01_JPRB,1.3475E-01_JPRB,2.6447E+00_JPRB,4.3400E+00_JPRB,5.9837E+00_JPRB,7.0246E+00_JPRB/)
KBO( :, 1,56,10) = (/&
&4.5363E-02_JPRB,5.4761E-02_JPRB,1.5057E+00_JPRB,2.5465E+00_JPRB,3.4107E+00_JPRB,3.5270E+00_JPRB/)
KBO( :, 2,56,10) = (/&
&5.8005E-02_JPRB,6.4431E-02_JPRB,1.8040E+00_JPRB,3.0340E+00_JPRB,4.1322E+00_JPRB,4.4343E+00_JPRB/)
KBO( :, 3,56,10) = (/&
&7.3593E-02_JPRB,7.7144E-02_JPRB,2.0898E+00_JPRB,3.4823E+00_JPRB,4.7884E+00_JPRB,5.3173E+00_JPRB/)
KBO( :, 4,56,10) = (/&
&9.3887E-02_JPRB,9.5237E-02_JPRB,2.3510E+00_JPRB,3.8850E+00_JPRB,5.3647E+00_JPRB,6.1108E+00_JPRB/)
KBO( :, 5,56,10) = (/&
&1.2181E-01_JPRB,1.2219E-01_JPRB,2.5776E+00_JPRB,4.2361E+00_JPRB,5.8482E+00_JPRB,6.8081E+00_JPRB/)
KBO( :, 1,57,10) = (/&
&3.8484E-02_JPRB,4.9332E-02_JPRB,1.4087E+00_JPRB,2.3775E+00_JPRB,3.1673E+00_JPRB,3.2197E+00_JPRB/)
KBO( :, 2,57,10) = (/&
&5.0147E-02_JPRB,5.8221E-02_JPRB,1.7073E+00_JPRB,2.8793E+00_JPRB,3.9049E+00_JPRB,4.1273E+00_JPRB/)
KBO( :, 3,57,10) = (/&
&6.4931E-02_JPRB,6.9815E-02_JPRB,1.9987E+00_JPRB,3.3420E+00_JPRB,4.5839E+00_JPRB,5.0218E+00_JPRB/)
KBO( :, 4,57,10) = (/&
&8.4109E-02_JPRB,8.6186E-02_JPRB,2.2698E+00_JPRB,3.7606E+00_JPRB,5.1878E+00_JPRB,5.8449E+00_JPRB/)
KBO( :, 5,57,10) = (/&
&1.1023E-01_JPRB,1.1081E-01_JPRB,2.5075E+00_JPRB,4.1274E+00_JPRB,5.7022E+00_JPRB,6.5747E+00_JPRB/)
KBO( :, 1,58,10) = (/&
&3.2626E-02_JPRB,4.4633E-02_JPRB,1.3174E+00_JPRB,2.2156E+00_JPRB,2.9363E+00_JPRB,2.9278E+00_JPRB/)
KBO( :, 2,58,10) = (/&
&4.3298E-02_JPRB,5.2922E-02_JPRB,1.6144E+00_JPRB,2.7304E+00_JPRB,3.6831E+00_JPRB,3.8325E+00_JPRB/)
KBO( :, 3,58,10) = (/&
&5.7247E-02_JPRB,6.3597E-02_JPRB,1.9107E+00_JPRB,3.2043E+00_JPRB,4.3821E+00_JPRB,4.7236E+00_JPRB/)
KBO( :, 4,58,10) = (/&
&7.5473E-02_JPRB,7.8525E-02_JPRB,2.1894E+00_JPRB,3.6369E+00_JPRB,5.0121E+00_JPRB,5.5748E+00_JPRB/)
KBO( :, 5,58,10) = (/&
&1.0003E-01_JPRB,1.0093E-01_JPRB,2.4389E+00_JPRB,4.0197E+00_JPRB,5.5549E+00_JPRB,6.3325E+00_JPRB/)
KBO( :, 1,59,10) = (/&
&2.9072E-02_JPRB,4.1705E-02_JPRB,1.2802E+00_JPRB,2.1494E+00_JPRB,2.8421E+00_JPRB,2.7798E+00_JPRB/)
KBO( :, 2,59,10) = (/&
&3.9252E-02_JPRB,4.9835E-02_JPRB,1.5765E+00_JPRB,2.6680E+00_JPRB,3.5911E+00_JPRB,3.6659E+00_JPRB/)
KBO( :, 3,59,10) = (/&
&5.3000E-02_JPRB,6.0270E-02_JPRB,1.8744E+00_JPRB,3.1473E+00_JPRB,4.2993E+00_JPRB,4.5411E+00_JPRB/)
KBO( :, 4,59,10) = (/&
&7.1218E-02_JPRB,7.4859E-02_JPRB,2.1561E+00_JPRB,3.5852E+00_JPRB,4.9384E+00_JPRB,5.3790E+00_JPRB/)
KBO( :, 5,59,10) = (/&
&9.5581E-02_JPRB,9.6679E-02_JPRB,2.4098E+00_JPRB,3.9752E+00_JPRB,5.4931E+00_JPRB,6.1513E+00_JPRB/)
KBO( :, 1,13,11) = (/&
&1.0830E+01_JPRB,1.0824E+01_JPRB,8.2966E+00_JPRB,5.7775E+00_JPRB,4.2067E+00_JPRB,3.8416E+00_JPRB/)
KBO( :, 2,13,11) = (/&
&1.0842E+01_JPRB,1.0836E+01_JPRB,8.3048E+00_JPRB,5.7756E+00_JPRB,4.1117E+00_JPRB,3.7626E+00_JPRB/)
KBO( :, 3,13,11) = (/&
&1.0806E+01_JPRB,1.0800E+01_JPRB,8.2770E+00_JPRB,5.7524E+00_JPRB,4.0103E+00_JPRB,3.7005E+00_JPRB/)
KBO( :, 4,13,11) = (/&
&1.0724E+01_JPRB,1.0718E+01_JPRB,8.2112E+00_JPRB,5.7002E+00_JPRB,3.9058E+00_JPRB,3.6875E+00_JPRB/)
KBO( :, 5,13,11) = (/&
&1.0621E+01_JPRB,1.0615E+01_JPRB,8.1337E+00_JPRB,5.6465E+00_JPRB,3.8013E+00_JPRB,3.7028E+00_JPRB/)
KBO( :, 1,14,11) = (/&
&1.1181E+01_JPRB,1.1175E+01_JPRB,8.5568E+00_JPRB,5.9649E+00_JPRB,4.4522E+00_JPRB,4.2077E+00_JPRB/)
KBO( :, 2,14,11) = (/&
&1.1133E+01_JPRB,1.1127E+01_JPRB,8.5167E+00_JPRB,5.9323E+00_JPRB,4.3476E+00_JPRB,4.1247E+00_JPRB/)
KBO( :, 3,14,11) = (/&
&1.1053E+01_JPRB,1.1047E+01_JPRB,8.4570E+00_JPRB,5.8889E+00_JPRB,4.2415E+00_JPRB,4.0417E+00_JPRB/)
KBO( :, 4,14,11) = (/&
&1.0933E+01_JPRB,1.0927E+01_JPRB,8.3682E+00_JPRB,5.8252E+00_JPRB,4.1413E+00_JPRB,3.9695E+00_JPRB/)
KBO( :, 5,14,11) = (/&
&1.0780E+01_JPRB,1.0774E+01_JPRB,8.2481E+00_JPRB,5.7382E+00_JPRB,4.0362E+00_JPRB,3.9481E+00_JPRB/)
KBO( :, 1,15,11) = (/&
&1.1265E+01_JPRB,1.1259E+01_JPRB,8.6144E+00_JPRB,6.0504E+00_JPRB,4.7323E+00_JPRB,4.5971E+00_JPRB/)
KBO( :, 2,15,11) = (/&
&1.1162E+01_JPRB,1.1156E+01_JPRB,8.5378E+00_JPRB,5.9895E+00_JPRB,4.6323E+00_JPRB,4.4988E+00_JPRB/)
KBO( :, 3,15,11) = (/&
&1.1022E+01_JPRB,1.1015E+01_JPRB,8.4337E+00_JPRB,5.9199E+00_JPRB,4.5312E+00_JPRB,4.4142E+00_JPRB/)
KBO( :, 4,15,11) = (/&
&1.0880E+01_JPRB,1.0874E+01_JPRB,8.3234E+00_JPRB,5.8348E+00_JPRB,4.4237E+00_JPRB,4.3326E+00_JPRB/)
KBO( :, 5,15,11) = (/&
&1.0698E+01_JPRB,1.0692E+01_JPRB,8.1811E+00_JPRB,5.7294E+00_JPRB,4.3189E+00_JPRB,4.2569E+00_JPRB/)
KBO( :, 1,16,11) = (/&
&1.1047E+01_JPRB,1.1041E+01_JPRB,8.4566E+00_JPRB,6.0733E+00_JPRB,5.0987E+00_JPRB,4.9814E+00_JPRB/)
KBO( :, 2,16,11) = (/&
&1.0912E+01_JPRB,1.0905E+01_JPRB,8.3558E+00_JPRB,5.9956E+00_JPRB,4.9979E+00_JPRB,4.8884E+00_JPRB/)
KBO( :, 3,16,11) = (/&
&1.0758E+01_JPRB,1.0752E+01_JPRB,8.2381E+00_JPRB,5.8935E+00_JPRB,4.8881E+00_JPRB,4.7986E+00_JPRB/)
KBO( :, 4,16,11) = (/&
&1.0569E+01_JPRB,1.0563E+01_JPRB,8.0898E+00_JPRB,5.7760E+00_JPRB,4.7808E+00_JPRB,4.7200E+00_JPRB/)
KBO( :, 5,16,11) = (/&
&1.0363E+01_JPRB,1.0357E+01_JPRB,7.9324E+00_JPRB,5.6614E+00_JPRB,4.6746E+00_JPRB,4.6272E+00_JPRB/)
KBO( :, 1,17,11) = (/&
&1.0577E+01_JPRB,1.0572E+01_JPRB,8.1098E+00_JPRB,6.0991E+00_JPRB,5.5106E+00_JPRB,5.4165E+00_JPRB/)
KBO( :, 2,17,11) = (/&
&1.0411E+01_JPRB,1.0405E+01_JPRB,7.9835E+00_JPRB,5.9805E+00_JPRB,5.3996E+00_JPRB,5.3206E+00_JPRB/)
KBO( :, 3,17,11) = (/&
&1.0224E+01_JPRB,1.0219E+01_JPRB,7.8406E+00_JPRB,5.8520E+00_JPRB,5.2910E+00_JPRB,5.2289E+00_JPRB/)
KBO( :, 4,17,11) = (/&
&1.0028E+01_JPRB,1.0022E+01_JPRB,7.6890E+00_JPRB,5.7215E+00_JPRB,5.1803E+00_JPRB,5.1373E+00_JPRB/)
KBO( :, 5,17,11) = (/&
&9.8160E+00_JPRB,9.8105E+00_JPRB,7.5244E+00_JPRB,5.5839E+00_JPRB,5.0653E+00_JPRB,5.0432E+00_JPRB/)
KBO( :, 1,18,11) = (/&
&9.8986E+00_JPRB,9.8931E+00_JPRB,7.6044E+00_JPRB,6.1164E+00_JPRB,5.9534E+00_JPRB,5.9474E+00_JPRB/)
KBO( :, 2,18,11) = (/&
&9.7140E+00_JPRB,9.7086E+00_JPRB,7.4654E+00_JPRB,5.9795E+00_JPRB,5.8383E+00_JPRB,5.8411E+00_JPRB/)
KBO( :, 3,18,11) = (/&
&9.5273E+00_JPRB,9.5220E+00_JPRB,7.3210E+00_JPRB,5.8383E+00_JPRB,5.7189E+00_JPRB,5.7395E+00_JPRB/)
KBO( :, 4,18,11) = (/&
&9.3182E+00_JPRB,9.3130E+00_JPRB,7.1594E+00_JPRB,5.7006E+00_JPRB,5.6002E+00_JPRB,5.6385E+00_JPRB/)
KBO( :, 5,18,11) = (/&
&9.0984E+00_JPRB,9.0934E+00_JPRB,6.9901E+00_JPRB,5.5596E+00_JPRB,5.4784E+00_JPRB,5.5361E+00_JPRB/)
KBO( :, 1,19,11) = (/&
&9.0617E+00_JPRB,9.0567E+00_JPRB,6.9882E+00_JPRB,6.1944E+00_JPRB,6.4032E+00_JPRB,6.5506E+00_JPRB/)
KBO( :, 2,19,11) = (/&
&8.8807E+00_JPRB,8.8758E+00_JPRB,6.8508E+00_JPRB,6.0541E+00_JPRB,6.2790E+00_JPRB,6.4421E+00_JPRB/)
KBO( :, 3,19,11) = (/&
&8.6840E+00_JPRB,8.6793E+00_JPRB,6.6993E+00_JPRB,5.9155E+00_JPRB,6.1530E+00_JPRB,6.3302E+00_JPRB/)
KBO( :, 4,19,11) = (/&
&8.4690E+00_JPRB,8.4643E+00_JPRB,6.5346E+00_JPRB,5.7782E+00_JPRB,6.0205E+00_JPRB,6.1969E+00_JPRB/)
KBO( :, 5,19,11) = (/&
&8.2461E+00_JPRB,8.2415E+00_JPRB,6.3683E+00_JPRB,5.6418E+00_JPRB,5.8884E+00_JPRB,6.0738E+00_JPRB/)
KBO( :, 1,20,11) = (/&
&8.1338E+00_JPRB,8.1294E+00_JPRB,6.3787E+00_JPRB,6.3724E+00_JPRB,6.8676E+00_JPRB,7.1512E+00_JPRB/)
KBO( :, 2,20,11) = (/&
&7.9489E+00_JPRB,7.9446E+00_JPRB,6.2323E+00_JPRB,6.2367E+00_JPRB,6.7380E+00_JPRB,7.0235E+00_JPRB/)
KBO( :, 3,20,11) = (/&
&7.7484E+00_JPRB,7.7442E+00_JPRB,6.0747E+00_JPRB,6.0984E+00_JPRB,6.6037E+00_JPRB,6.8886E+00_JPRB/)
KBO( :, 4,20,11) = (/&
&7.5336E+00_JPRB,7.5295E+00_JPRB,5.9158E+00_JPRB,5.9585E+00_JPRB,6.4615E+00_JPRB,6.7483E+00_JPRB/)
KBO( :, 5,20,11) = (/&
&7.3192E+00_JPRB,7.3153E+00_JPRB,5.7540E+00_JPRB,5.8154E+00_JPRB,6.3114E+00_JPRB,6.6285E+00_JPRB/)
KBO( :, 1,21,11) = (/&
&7.1783E+00_JPRB,7.1745E+00_JPRB,5.8792E+00_JPRB,6.5789E+00_JPRB,7.3613E+00_JPRB,7.7022E+00_JPRB/)
KBO( :, 2,21,11) = (/&
&6.9919E+00_JPRB,6.9882E+00_JPRB,5.7299E+00_JPRB,6.4389E+00_JPRB,7.2225E+00_JPRB,7.5647E+00_JPRB/)
KBO( :, 3,21,11) = (/&
&6.7909E+00_JPRB,6.7873E+00_JPRB,5.5766E+00_JPRB,6.2973E+00_JPRB,7.0712E+00_JPRB,7.4405E+00_JPRB/)
KBO( :, 4,21,11) = (/&
&6.5939E+00_JPRB,6.5903E+00_JPRB,5.4217E+00_JPRB,6.1490E+00_JPRB,6.9129E+00_JPRB,7.3122E+00_JPRB/)
KBO( :, 5,21,11) = (/&
&6.4093E+00_JPRB,6.4059E+00_JPRB,5.2663E+00_JPRB,5.9963E+00_JPRB,6.7516E+00_JPRB,7.1970E+00_JPRB/)
KBO( :, 1,22,11) = (/&
&6.2177E+00_JPRB,6.2144E+00_JPRB,5.5479E+00_JPRB,6.7900E+00_JPRB,7.8374E+00_JPRB,8.2375E+00_JPRB/)
KBO( :, 2,22,11) = (/&
&6.0356E+00_JPRB,6.0324E+00_JPRB,5.3995E+00_JPRB,6.6451E+00_JPRB,7.6895E+00_JPRB,8.1166E+00_JPRB/)
KBO( :, 3,22,11) = (/&
&5.8596E+00_JPRB,5.8565E+00_JPRB,5.2499E+00_JPRB,6.4943E+00_JPRB,7.5342E+00_JPRB,8.0016E+00_JPRB/)
KBO( :, 4,22,11) = (/&
&5.7069E+00_JPRB,5.7039E+00_JPRB,5.1029E+00_JPRB,6.3342E+00_JPRB,7.3721E+00_JPRB,7.8779E+00_JPRB/)
KBO( :, 5,22,11) = (/&
&5.5907E+00_JPRB,5.5878E+00_JPRB,4.9677E+00_JPRB,6.1731E+00_JPRB,7.2068E+00_JPRB,7.7598E+00_JPRB/)
KBO( :, 1,23,11) = (/&
&5.3001E+00_JPRB,5.2974E+00_JPRB,5.3392E+00_JPRB,7.0212E+00_JPRB,8.2731E+00_JPRB,8.7769E+00_JPRB/)
KBO( :, 2,23,11) = (/&
&5.1465E+00_JPRB,5.1439E+00_JPRB,5.1959E+00_JPRB,6.8658E+00_JPRB,8.1318E+00_JPRB,8.6756E+00_JPRB/)
KBO( :, 3,23,11) = (/&
&5.0259E+00_JPRB,5.0234E+00_JPRB,5.0568E+00_JPRB,6.6964E+00_JPRB,7.9822E+00_JPRB,8.5635E+00_JPRB/)
KBO( :, 4,23,11) = (/&
&4.9408E+00_JPRB,4.9383E+00_JPRB,4.9256E+00_JPRB,6.5229E+00_JPRB,7.8283E+00_JPRB,8.4337E+00_JPRB/)
KBO( :, 5,23,11) = (/&
&4.8982E+00_JPRB,4.8957E+00_JPRB,4.8170E+00_JPRB,6.3467E+00_JPRB,7.6656E+00_JPRB,8.3117E+00_JPRB/)
KBO( :, 1,24,11) = (/&
&4.4810E+00_JPRB,4.4788E+00_JPRB,5.2117E+00_JPRB,7.2187E+00_JPRB,8.6894E+00_JPRB,9.2830E+00_JPRB/)
KBO( :, 2,24,11) = (/&
&4.3875E+00_JPRB,4.3854E+00_JPRB,5.0729E+00_JPRB,7.0552E+00_JPRB,8.5552E+00_JPRB,9.1952E+00_JPRB/)
KBO( :, 3,24,11) = (/&
&4.3298E+00_JPRB,4.3277E+00_JPRB,4.9395E+00_JPRB,6.8841E+00_JPRB,8.4129E+00_JPRB,9.0854E+00_JPRB/)
KBO( :, 4,24,11) = (/&
&4.3240E+00_JPRB,4.3219E+00_JPRB,4.8305E+00_JPRB,6.7106E+00_JPRB,8.2583E+00_JPRB,8.9534E+00_JPRB/)
KBO( :, 5,24,11) = (/&
&4.3568E+00_JPRB,4.3547E+00_JPRB,4.7450E+00_JPRB,6.5341E+00_JPRB,8.0917E+00_JPRB,8.8298E+00_JPRB/)
KBO( :, 1,25,11) = (/&
&3.8157E+00_JPRB,3.8139E+00_JPRB,5.1260E+00_JPRB,7.3753E+00_JPRB,9.0809E+00_JPRB,9.7303E+00_JPRB/)
KBO( :, 2,25,11) = (/&
&3.7828E+00_JPRB,3.7809E+00_JPRB,4.9881E+00_JPRB,7.2252E+00_JPRB,8.9546E+00_JPRB,9.6529E+00_JPRB/)
KBO( :, 3,25,11) = (/&
&3.7966E+00_JPRB,3.7948E+00_JPRB,4.8698E+00_JPRB,7.0694E+00_JPRB,8.8114E+00_JPRB,9.5492E+00_JPRB/)
KBO( :, 4,25,11) = (/&
&3.8447E+00_JPRB,3.8429E+00_JPRB,4.7808E+00_JPRB,6.9055E+00_JPRB,8.6548E+00_JPRB,9.4220E+00_JPRB/)
KBO( :, 5,25,11) = (/&
&3.9327E+00_JPRB,3.9309E+00_JPRB,4.7021E+00_JPRB,6.7298E+00_JPRB,8.4889E+00_JPRB,9.2936E+00_JPRB/)
KBO( :, 1,26,11) = (/&
&3.3036E+00_JPRB,3.3021E+00_JPRB,5.0575E+00_JPRB,7.5192E+00_JPRB,9.4189E+00_JPRB,1.0102E+01_JPRB/)
KBO( :, 2,26,11) = (/&
&3.3285E+00_JPRB,3.3270E+00_JPRB,4.9281E+00_JPRB,7.3849E+00_JPRB,9.3027E+00_JPRB,1.0041E+01_JPRB/)
KBO( :, 3,26,11) = (/&
&3.3889E+00_JPRB,3.3874E+00_JPRB,4.8326E+00_JPRB,7.2371E+00_JPRB,9.1673E+00_JPRB,9.9526E+00_JPRB/)
KBO( :, 4,26,11) = (/&
&3.4837E+00_JPRB,3.4822E+00_JPRB,4.7525E+00_JPRB,7.0754E+00_JPRB,9.0130E+00_JPRB,9.8334E+00_JPRB/)
KBO( :, 5,26,11) = (/&
&3.5869E+00_JPRB,3.5853E+00_JPRB,4.6879E+00_JPRB,6.9081E+00_JPRB,8.8429E+00_JPRB,9.7104E+00_JPRB/)
KBO( :, 1,27,11) = (/&
&2.9165E+00_JPRB,2.9152E+00_JPRB,4.9857E+00_JPRB,7.6560E+00_JPRB,9.7110E+00_JPRB,1.0421E+01_JPRB/)
KBO( :, 2,27,11) = (/&
&2.9834E+00_JPRB,2.9822E+00_JPRB,4.8877E+00_JPRB,7.5297E+00_JPRB,9.6106E+00_JPRB,1.0382E+01_JPRB/)
KBO( :, 3,27,11) = (/&
&3.0758E+00_JPRB,3.0745E+00_JPRB,4.8130E+00_JPRB,7.3870E+00_JPRB,9.4838E+00_JPRB,1.0306E+01_JPRB/)
KBO( :, 4,27,11) = (/&
&3.1796E+00_JPRB,3.1781E+00_JPRB,4.7485E+00_JPRB,7.2327E+00_JPRB,9.3303E+00_JPRB,1.0198E+01_JPRB/)
KBO( :, 5,27,11) = (/&
&3.2957E+00_JPRB,3.2941E+00_JPRB,4.7038E+00_JPRB,7.0683E+00_JPRB,9.1564E+00_JPRB,1.0089E+01_JPRB/)
KBO( :, 1,28,11) = (/&
&2.6155E+00_JPRB,2.6145E+00_JPRB,4.9275E+00_JPRB,7.7638E+00_JPRB,9.9551E+00_JPRB,1.0696E+01_JPRB/)
KBO( :, 2,28,11) = (/&
&2.7046E+00_JPRB,2.7035E+00_JPRB,4.8641E+00_JPRB,7.6476E+00_JPRB,9.8682E+00_JPRB,1.0682E+01_JPRB/)
KBO( :, 3,28,11) = (/&
&2.8078E+00_JPRB,2.8066E+00_JPRB,4.8086E+00_JPRB,7.5132E+00_JPRB,9.7479E+00_JPRB,1.0615E+01_JPRB/)
KBO( :, 4,28,11) = (/&
&2.9220E+00_JPRB,2.9207E+00_JPRB,4.7661E+00_JPRB,7.3606E+00_JPRB,9.5999E+00_JPRB,1.0521E+01_JPRB/)
KBO( :, 5,28,11) = (/&
&3.0419E+00_JPRB,3.0404E+00_JPRB,4.7235E+00_JPRB,7.2046E+00_JPRB,9.4195E+00_JPRB,1.0424E+01_JPRB/)
KBO( :, 1,29,11) = (/&
&2.3732E+00_JPRB,2.3723E+00_JPRB,4.8900E+00_JPRB,7.8375E+00_JPRB,1.0150E+01_JPRB,1.0951E+01_JPRB/)
KBO( :, 2,29,11) = (/&
&2.4712E+00_JPRB,2.4702E+00_JPRB,4.8481E+00_JPRB,7.7319E+00_JPRB,1.0078E+01_JPRB,1.0946E+01_JPRB/)
KBO( :, 3,29,11) = (/&
&2.5783E+00_JPRB,2.5771E+00_JPRB,4.8118E+00_JPRB,7.6037E+00_JPRB,9.9721E+00_JPRB,1.0893E+01_JPRB/)
KBO( :, 4,29,11) = (/&
&2.6902E+00_JPRB,2.6889E+00_JPRB,4.7850E+00_JPRB,7.4580E+00_JPRB,9.8268E+00_JPRB,1.0822E+01_JPRB/)
KBO( :, 5,29,11) = (/&
&2.8045E+00_JPRB,2.8032E+00_JPRB,4.7400E+00_JPRB,7.3154E+00_JPRB,9.6483E+00_JPRB,1.0741E+01_JPRB/)
KBO( :, 1,30,11) = (/&
&2.1658E+00_JPRB,2.1650E+00_JPRB,4.8677E+00_JPRB,7.8862E+00_JPRB,1.0317E+01_JPRB,1.1167E+01_JPRB/)
KBO( :, 2,30,11) = (/&
&2.2662E+00_JPRB,2.2652E+00_JPRB,4.8423E+00_JPRB,7.7911E+00_JPRB,1.0262E+01_JPRB,1.1177E+01_JPRB/)
KBO( :, 3,30,11) = (/&
&2.3698E+00_JPRB,2.3687E+00_JPRB,4.8249E+00_JPRB,7.6717E+00_JPRB,1.0162E+01_JPRB,1.1145E+01_JPRB/)
KBO( :, 4,30,11) = (/&
&2.4773E+00_JPRB,2.4761E+00_JPRB,4.7959E+00_JPRB,7.5389E+00_JPRB,1.0012E+01_JPRB,1.1105E+01_JPRB/)
KBO( :, 5,30,11) = (/&
&2.5877E+00_JPRB,2.5865E+00_JPRB,4.7569E+00_JPRB,7.4115E+00_JPRB,9.8340E+00_JPRB,1.1029E+01_JPRB/)
KBO( :, 1,31,11) = (/&
&1.9790E+00_JPRB,1.9782E+00_JPRB,4.8500E+00_JPRB,7.9143E+00_JPRB,1.0464E+01_JPRB,1.1366E+01_JPRB/)
KBO( :, 2,31,11) = (/&
&2.0776E+00_JPRB,2.0767E+00_JPRB,4.8427E+00_JPRB,7.8316E+00_JPRB,1.0417E+01_JPRB,1.1398E+01_JPRB/)
KBO( :, 3,31,11) = (/&
&2.1797E+00_JPRB,2.1787E+00_JPRB,4.8321E+00_JPRB,7.7240E+00_JPRB,1.0316E+01_JPRB,1.1410E+01_JPRB/)
KBO( :, 4,31,11) = (/&
&2.2842E+00_JPRB,2.2832E+00_JPRB,4.8021E+00_JPRB,7.6072E+00_JPRB,1.0171E+01_JPRB,1.1390E+01_JPRB/)
KBO( :, 5,31,11) = (/&
&2.3904E+00_JPRB,2.3893E+00_JPRB,4.7702E+00_JPRB,7.4874E+00_JPRB,9.9885E+00_JPRB,1.1305E+01_JPRB/)
KBO( :, 1,32,11) = (/&
&1.8065E+00_JPRB,1.8057E+00_JPRB,4.8337E+00_JPRB,7.9321E+00_JPRB,1.0594E+01_JPRB,1.1553E+01_JPRB/)
KBO( :, 2,32,11) = (/&
&1.9056E+00_JPRB,1.9048E+00_JPRB,4.8404E+00_JPRB,7.8602E+00_JPRB,1.0550E+01_JPRB,1.1632E+01_JPRB/)
KBO( :, 3,32,11) = (/&
&2.0071E+00_JPRB,2.0062E+00_JPRB,4.8291E+00_JPRB,7.7660E+00_JPRB,1.0447E+01_JPRB,1.1676E+01_JPRB/)
KBO( :, 4,32,11) = (/&
&2.1091E+00_JPRB,2.1082E+00_JPRB,4.8052E+00_JPRB,7.6656E+00_JPRB,1.0296E+01_JPRB,1.1648E+01_JPRB/)
KBO( :, 5,32,11) = (/&
&2.2144E+00_JPRB,2.2134E+00_JPRB,4.7806E+00_JPRB,7.5529E+00_JPRB,1.0105E+01_JPRB,1.1557E+01_JPRB/)
KBO( :, 1,33,11) = (/&
&1.6510E+00_JPRB,1.6503E+00_JPRB,4.8210E+00_JPRB,7.9482E+00_JPRB,1.0706E+01_JPRB,1.1767E+01_JPRB/)
KBO( :, 2,33,11) = (/&
&1.7494E+00_JPRB,1.7487E+00_JPRB,4.8343E+00_JPRB,7.8861E+00_JPRB,1.0658E+01_JPRB,1.1881E+01_JPRB/)
KBO( :, 3,33,11) = (/&
&1.8501E+00_JPRB,1.8493E+00_JPRB,4.8252E+00_JPRB,7.8076E+00_JPRB,1.0548E+01_JPRB,1.1918E+01_JPRB/)
KBO( :, 4,33,11) = (/&
&1.9524E+00_JPRB,1.9516E+00_JPRB,4.8101E+00_JPRB,7.7163E+00_JPRB,1.0391E+01_JPRB,1.1878E+01_JPRB/)
KBO( :, 5,33,11) = (/&
&2.0594E+00_JPRB,2.0586E+00_JPRB,4.7896E+00_JPRB,7.6047E+00_JPRB,1.0193E+01_JPRB,1.1783E+01_JPRB/)
KBO( :, 1,34,11) = (/&
&1.5098E+00_JPRB,1.5093E+00_JPRB,4.8119E+00_JPRB,7.9653E+00_JPRB,1.0798E+01_JPRB,1.1972E+01_JPRB/)
KBO( :, 2,34,11) = (/&
&1.6067E+00_JPRB,1.6061E+00_JPRB,4.8282E+00_JPRB,7.9164E+00_JPRB,1.0745E+01_JPRB,1.2091E+01_JPRB/)
KBO( :, 3,34,11) = (/&
&1.7068E+00_JPRB,1.7062E+00_JPRB,4.8254E+00_JPRB,7.8470E+00_JPRB,1.0632E+01_JPRB,1.2113E+01_JPRB/)
KBO( :, 4,34,11) = (/&
&1.8116E+00_JPRB,1.8109E+00_JPRB,4.8147E+00_JPRB,7.7622E+00_JPRB,1.0470E+01_JPRB,1.2073E+01_JPRB/)
KBO( :, 5,34,11) = (/&
&1.9232E+00_JPRB,1.9225E+00_JPRB,4.7977E+00_JPRB,7.6521E+00_JPRB,1.0264E+01_JPRB,1.1969E+01_JPRB/)
KBO( :, 1,35,11) = (/&
&1.3777E+00_JPRB,1.3773E+00_JPRB,4.8007E+00_JPRB,7.9865E+00_JPRB,1.0878E+01_JPRB,1.2152E+01_JPRB/)
KBO( :, 2,35,11) = (/&
&1.4720E+00_JPRB,1.4715E+00_JPRB,4.8220E+00_JPRB,7.9505E+00_JPRB,1.0824E+01_JPRB,1.2272E+01_JPRB/)
KBO( :, 3,35,11) = (/&
&1.5713E+00_JPRB,1.5708E+00_JPRB,4.8275E+00_JPRB,7.8907E+00_JPRB,1.0710E+01_JPRB,1.2296E+01_JPRB/)
KBO( :, 4,35,11) = (/&
&1.6790E+00_JPRB,1.6784E+00_JPRB,4.8220E+00_JPRB,7.8081E+00_JPRB,1.0547E+01_JPRB,1.2260E+01_JPRB/)
KBO( :, 5,35,11) = (/&
&1.7986E+00_JPRB,1.7980E+00_JPRB,4.8075E+00_JPRB,7.7002E+00_JPRB,1.0336E+01_JPRB,1.2159E+01_JPRB/)
KBO( :, 1,36,11) = (/&
&1.2514E+00_JPRB,1.2511E+00_JPRB,4.7868E+00_JPRB,8.0109E+00_JPRB,1.0946E+01_JPRB,1.2304E+01_JPRB/)
KBO( :, 2,36,11) = (/&
&1.3435E+00_JPRB,1.3431E+00_JPRB,4.8179E+00_JPRB,7.9877E+00_JPRB,1.0897E+01_JPRB,1.2427E+01_JPRB/)
KBO( :, 3,36,11) = (/&
&1.4435E+00_JPRB,1.4430E+00_JPRB,4.8314E+00_JPRB,7.9353E+00_JPRB,1.0788E+01_JPRB,1.2470E+01_JPRB/)
KBO( :, 4,36,11) = (/&
&1.5538E+00_JPRB,1.5533E+00_JPRB,4.8318E+00_JPRB,7.8582E+00_JPRB,1.0627E+01_JPRB,1.2438E+01_JPRB/)
KBO( :, 5,36,11) = (/&
&1.6810E+00_JPRB,1.6804E+00_JPRB,4.8203E+00_JPRB,7.7528E+00_JPRB,1.0416E+01_JPRB,1.2339E+01_JPRB/)
KBO( :, 1,37,11) = (/&
&1.1282E+00_JPRB,1.1280E+00_JPRB,4.7699E+00_JPRB,8.0315E+00_JPRB,1.1000E+01_JPRB,1.2396E+01_JPRB/)
KBO( :, 2,37,11) = (/&
&1.2167E+00_JPRB,1.2164E+00_JPRB,4.8125E+00_JPRB,8.0243E+00_JPRB,1.0970E+01_JPRB,1.2544E+01_JPRB/)
KBO( :, 3,37,11) = (/&
&1.3158E+00_JPRB,1.3155E+00_JPRB,4.8359E+00_JPRB,7.9814E+00_JPRB,1.0872E+01_JPRB,1.2615E+01_JPRB/)
KBO( :, 4,37,11) = (/&
&1.4284E+00_JPRB,1.4280E+00_JPRB,4.8417E+00_JPRB,7.9120E+00_JPRB,1.0722E+01_JPRB,1.2596E+01_JPRB/)
KBO( :, 5,37,11) = (/&
&1.5612E+00_JPRB,1.5606E+00_JPRB,4.8348E+00_JPRB,7.8131E+00_JPRB,1.0516E+01_JPRB,1.2504E+01_JPRB/)
KBO( :, 1,38,11) = (/&
&1.0204E+00_JPRB,1.0202E+00_JPRB,4.7523E+00_JPRB,8.0470E+00_JPRB,1.1041E+01_JPRB,1.2476E+01_JPRB/)
KBO( :, 2,38,11) = (/&
&1.1044E+00_JPRB,1.1042E+00_JPRB,4.8063E+00_JPRB,8.0526E+00_JPRB,1.1031E+01_JPRB,1.2656E+01_JPRB/)
KBO( :, 3,38,11) = (/&
&1.2026E+00_JPRB,1.2023E+00_JPRB,4.8389E+00_JPRB,8.0207E+00_JPRB,1.0945E+01_JPRB,1.2754E+01_JPRB/)
KBO( :, 4,38,11) = (/&
&1.3171E+00_JPRB,1.3167E+00_JPRB,4.8508E+00_JPRB,7.9583E+00_JPRB,1.0805E+01_JPRB,1.2746E+01_JPRB/)
KBO( :, 5,38,11) = (/&
&1.4551E+00_JPRB,1.4546E+00_JPRB,4.8486E+00_JPRB,7.8661E+00_JPRB,1.0608E+01_JPRB,1.2659E+01_JPRB/)
KBO( :, 1,39,11) = (/&
&9.2697E-01_JPRB,9.2690E-01_JPRB,4.7345E+00_JPRB,8.0529E+00_JPRB,1.1070E+01_JPRB,1.2554E+01_JPRB/)
KBO( :, 2,39,11) = (/&
&1.0083E+00_JPRB,1.0081E+00_JPRB,4.8007E+00_JPRB,8.0735E+00_JPRB,1.1079E+01_JPRB,1.2773E+01_JPRB/)
KBO( :, 3,39,11) = (/&
&1.1037E+00_JPRB,1.1035E+00_JPRB,4.8402E+00_JPRB,8.0520E+00_JPRB,1.1008E+01_JPRB,1.2893E+01_JPRB/)
KBO( :, 4,39,11) = (/&
&1.2204E+00_JPRB,1.2201E+00_JPRB,4.8590E+00_JPRB,7.9971E+00_JPRB,1.0876E+01_JPRB,1.2892E+01_JPRB/)
KBO( :, 5,39,11) = (/&
&1.3628E+00_JPRB,1.3623E+00_JPRB,4.8606E+00_JPRB,7.9113E+00_JPRB,1.0688E+01_JPRB,1.2810E+01_JPRB/)
KBO( :, 1,40,11) = (/&
&8.3758E-01_JPRB,8.3760E-01_JPRB,4.7063E+00_JPRB,8.0487E+00_JPRB,1.1082E+01_JPRB,1.2556E+01_JPRB/)
KBO( :, 2,40,11) = (/&
&9.1581E-01_JPRB,9.1577E-01_JPRB,4.7869E+00_JPRB,8.0879E+00_JPRB,1.1120E+01_JPRB,1.2816E+01_JPRB/)
KBO( :, 3,40,11) = (/&
&1.0079E+00_JPRB,1.0078E+00_JPRB,4.8371E+00_JPRB,8.0805E+00_JPRB,1.1070E+01_JPRB,1.2970E+01_JPRB/)
KBO( :, 4,40,11) = (/&
&1.1225E+00_JPRB,1.1222E+00_JPRB,4.8639E+00_JPRB,8.0357E+00_JPRB,1.0954E+01_JPRB,1.2989E+01_JPRB/)
KBO( :, 5,40,11) = (/&
&1.2665E+00_JPRB,1.2660E+00_JPRB,4.8714E+00_JPRB,7.9591E+00_JPRB,1.0779E+01_JPRB,1.2926E+01_JPRB/)
KBO( :, 1,41,11) = (/&
&7.5804E-01_JPRB,7.5812E-01_JPRB,4.6746E+00_JPRB,8.0347E+00_JPRB,1.1077E+01_JPRB,1.2530E+01_JPRB/)
KBO( :, 2,41,11) = (/&
&8.3424E-01_JPRB,8.3425E-01_JPRB,4.7690E+00_JPRB,8.0936E+00_JPRB,1.1147E+01_JPRB,1.2837E+01_JPRB/)
KBO( :, 3,41,11) = (/&
&9.2284E-01_JPRB,9.2272E-01_JPRB,4.8295E+00_JPRB,8.1031E+00_JPRB,1.1121E+01_JPRB,1.3026E+01_JPRB/)
KBO( :, 4,41,11) = (/&
&1.0345E+00_JPRB,1.0342E+00_JPRB,4.8660E+00_JPRB,8.0690E+00_JPRB,1.1022E+01_JPRB,1.3069E+01_JPRB/)
KBO( :, 5,41,11) = (/&
&1.1779E+00_JPRB,1.1775E+00_JPRB,4.8792E+00_JPRB,8.0025E+00_JPRB,1.0862E+01_JPRB,1.3028E+01_JPRB/)
KBO( :, 1,42,11) = (/&
&6.8836E-01_JPRB,6.8850E-01_JPRB,4.6395E+00_JPRB,8.0108E+00_JPRB,1.1057E+01_JPRB,1.2493E+01_JPRB/)
KBO( :, 2,42,11) = (/&
&7.6202E-01_JPRB,7.6208E-01_JPRB,4.7478E+00_JPRB,8.0915E+00_JPRB,1.1161E+01_JPRB,1.2847E+01_JPRB/)
KBO( :, 3,42,11) = (/&
&8.4897E-01_JPRB,8.4889E-01_JPRB,4.8194E+00_JPRB,8.1177E+00_JPRB,1.1160E+01_JPRB,1.3071E+01_JPRB/)
KBO( :, 4,42,11) = (/&
&9.5721E-01_JPRB,9.5697E-01_JPRB,4.8642E+00_JPRB,8.0964E+00_JPRB,1.1081E+01_JPRB,1.3142E+01_JPRB/)
KBO( :, 5,42,11) = (/&
&1.0979E+00_JPRB,1.0975E+00_JPRB,4.8838E+00_JPRB,8.0399E+00_JPRB,1.0937E+01_JPRB,1.3122E+01_JPRB/)
KBO( :, 1,43,11) = (/&
&6.2327E-01_JPRB,6.2346E-01_JPRB,4.5920E+00_JPRB,7.9682E+00_JPRB,1.1010E+01_JPRB,1.2410E+01_JPRB/)
KBO( :, 2,43,11) = (/&
&6.9363E-01_JPRB,6.9372E-01_JPRB,4.7172E+00_JPRB,8.0779E+00_JPRB,1.1157E+01_JPRB,1.2823E+01_JPRB/)
KBO( :, 3,43,11) = (/&
&7.7812E-01_JPRB,7.7808E-01_JPRB,4.8024E+00_JPRB,8.1237E+00_JPRB,1.1190E+01_JPRB,1.3092E+01_JPRB/)
KBO( :, 4,43,11) = (/&
&8.8257E-01_JPRB,8.8240E-01_JPRB,4.8564E+00_JPRB,8.1185E+00_JPRB,1.1134E+01_JPRB,1.3199E+01_JPRB/)
KBO( :, 5,43,11) = (/&
&1.0175E+00_JPRB,1.0172E+00_JPRB,4.8852E+00_JPRB,8.0748E+00_JPRB,1.1010E+01_JPRB,1.3208E+01_JPRB/)
KBO( :, 1,44,11) = (/&
&5.6319E-01_JPRB,5.6344E-01_JPRB,4.5362E+00_JPRB,7.9098E+00_JPRB,1.0942E+01_JPRB,1.2291E+01_JPRB/)
KBO( :, 2,44,11) = (/&
&6.3128E-01_JPRB,6.3143E-01_JPRB,4.6773E+00_JPRB,8.0513E+00_JPRB,1.1133E+01_JPRB,1.2773E+01_JPRB/)
KBO( :, 3,44,11) = (/&
&7.1290E-01_JPRB,7.1288E-01_JPRB,4.7788E+00_JPRB,8.1200E+00_JPRB,1.1206E+01_JPRB,1.3092E+01_JPRB/)
KBO( :, 4,44,11) = (/&
&8.1370E-01_JPRB,8.1356E-01_JPRB,4.8431E+00_JPRB,8.1349E+00_JPRB,1.1178E+01_JPRB,1.3245E+01_JPRB/)
KBO( :, 5,44,11) = (/&
&9.4155E-01_JPRB,9.4126E-01_JPRB,4.8828E+00_JPRB,8.1039E+00_JPRB,1.1076E+01_JPRB,1.3283E+01_JPRB/)
KBO( :, 1,45,11) = (/&
&5.0848E-01_JPRB,5.0877E-01_JPRB,4.4759E+00_JPRB,7.8396E+00_JPRB,1.0853E+01_JPRB,1.2157E+01_JPRB/)
KBO( :, 2,45,11) = (/&
&5.7558E-01_JPRB,5.7574E-01_JPRB,4.6321E+00_JPRB,8.0148E+00_JPRB,1.1090E+01_JPRB,1.2710E+01_JPRB/)
KBO( :, 3,45,11) = (/&
&6.5428E-01_JPRB,6.5431E-01_JPRB,4.7490E+00_JPRB,8.1075E+00_JPRB,1.1206E+01_JPRB,1.3081E+01_JPRB/)
KBO( :, 4,45,11) = (/&
&7.5171E-01_JPRB,7.5160E-01_JPRB,4.8272E+00_JPRB,8.1428E+00_JPRB,1.1211E+01_JPRB,1.3283E+01_JPRB/)
KBO( :, 5,45,11) = (/&
&8.7320E-01_JPRB,8.7295E-01_JPRB,4.8756E+00_JPRB,8.1271E+00_JPRB,1.1133E+01_JPRB,1.3354E+01_JPRB/)
KBO( :, 1,46,11) = (/&
&4.5749E-01_JPRB,4.5781E-01_JPRB,4.4050E+00_JPRB,7.7477E+00_JPRB,1.0733E+01_JPRB,1.1988E+01_JPRB/)
KBO( :, 2,46,11) = (/&
&5.2335E-01_JPRB,5.2354E-01_JPRB,4.5777E+00_JPRB,7.9624E+00_JPRB,1.1027E+01_JPRB,1.2622E+01_JPRB/)
KBO( :, 3,46,11) = (/&
&5.9972E-01_JPRB,5.9977E-01_JPRB,4.7113E+00_JPRB,8.0849E+00_JPRB,1.1188E+01_JPRB,1.3051E+01_JPRB/)
KBO( :, 4,46,11) = (/&
&6.9340E-01_JPRB,6.9332E-01_JPRB,4.8042E+00_JPRB,8.1402E+00_JPRB,1.1232E+01_JPRB,1.3309E+01_JPRB/)
KBO( :, 5,46,11) = (/&
&8.0900E-01_JPRB,8.0880E-01_JPRB,4.8629E+00_JPRB,8.1438E+00_JPRB,1.1182E+01_JPRB,1.3415E+01_JPRB/)
KBO( :, 1,47,11) = (/&
&4.0799E-01_JPRB,4.0834E-01_JPRB,4.3192E+00_JPRB,7.6262E+00_JPRB,1.0570E+01_JPRB,1.1748E+01_JPRB/)
KBO( :, 2,47,11) = (/&
&4.7291E-01_JPRB,4.7311E-01_JPRB,4.5111E+00_JPRB,7.8858E+00_JPRB,1.0930E+01_JPRB,1.2474E+01_JPRB/)
KBO( :, 3,47,11) = (/&
&5.4737E-01_JPRB,5.4746E-01_JPRB,4.6622E+00_JPRB,8.0462E+00_JPRB,1.1144E+01_JPRB,1.2972E+01_JPRB/)
KBO( :, 4,47,11) = (/&
&6.3579E-01_JPRB,6.3575E-01_JPRB,4.7722E+00_JPRB,8.1275E+00_JPRB,1.1235E+01_JPRB,1.3300E+01_JPRB/)
KBO( :, 5,47,11) = (/&
&7.4500E-01_JPRB,7.4486E-01_JPRB,4.8444E+00_JPRB,8.1534E+00_JPRB,1.1220E+01_JPRB,1.3455E+01_JPRB/)
KBO( :, 1,48,11) = (/&
&3.6234E-01_JPRB,3.6271E-01_JPRB,4.2229E+00_JPRB,7.4847E+00_JPRB,1.0381E+01_JPRB,1.1491E+01_JPRB/)
KBO( :, 2,48,11) = (/&
&4.2649E-01_JPRB,4.2672E-01_JPRB,4.4362E+00_JPRB,7.7928E+00_JPRB,1.0805E+01_JPRB,1.2307E+01_JPRB/)
KBO( :, 3,48,11) = (/&
&4.9899E-01_JPRB,4.9911E-01_JPRB,4.6047E+00_JPRB,7.9930E+00_JPRB,1.1077E+01_JPRB,1.2882E+01_JPRB/)
KBO( :, 4,48,11) = (/&
&5.8344E-01_JPRB,5.8343E-01_JPRB,4.7326E+00_JPRB,8.1042E+00_JPRB,1.1219E+01_JPRB,1.3280E+01_JPRB/)
KBO( :, 5,48,11) = (/&
&6.8655E-01_JPRB,6.8645E-01_JPRB,4.8209E+00_JPRB,8.1532E+00_JPRB,1.1244E+01_JPRB,1.3490E+01_JPRB/)
KBO( :, 1,49,11) = (/&
&3.2105E-01_JPRB,3.2141E-01_JPRB,4.1218E+00_JPRB,7.3215E+00_JPRB,1.0162E+01_JPRB,1.1223E+01_JPRB/)
KBO( :, 2,49,11) = (/&
&3.8263E-01_JPRB,3.8290E-01_JPRB,4.3538E+00_JPRB,7.6804E+00_JPRB,1.0654E+01_JPRB,1.2130E+01_JPRB/)
KBO( :, 3,49,11) = (/&
&4.5423E-01_JPRB,4.5438E-01_JPRB,4.5413E+00_JPRB,7.9230E+00_JPRB,1.0989E+01_JPRB,1.2791E+01_JPRB/)
KBO( :, 4,49,11) = (/&
&5.3583E-01_JPRB,5.3587E-01_JPRB,4.6861E+00_JPRB,8.0697E+00_JPRB,1.1180E+01_JPRB,1.3260E+01_JPRB/)
KBO( :, 5,49,11) = (/&
&6.3293E-01_JPRB,6.3285E-01_JPRB,4.7905E+00_JPRB,8.1418E+00_JPRB,1.1253E+01_JPRB,1.3527E+01_JPRB/)
KBO( :, 1,50,11) = (/&
&2.8508E-01_JPRB,2.8546E-01_JPRB,4.0216E+00_JPRB,7.1533E+00_JPRB,9.9242E+00_JPRB,1.0908E+01_JPRB/)
KBO( :, 2,50,11) = (/&
&3.4378E-01_JPRB,3.4406E-01_JPRB,4.2684E+00_JPRB,7.5560E+00_JPRB,1.0485E+01_JPRB,1.1896E+01_JPRB/)
KBO( :, 3,50,11) = (/&
&4.1407E-01_JPRB,4.1424E-01_JPRB,4.4746E+00_JPRB,7.8430E+00_JPRB,1.0882E+01_JPRB,1.2647E+01_JPRB/)
KBO( :, 4,50,11) = (/&
&4.9363E-01_JPRB,4.9370E-01_JPRB,4.6366E+00_JPRB,8.0253E+00_JPRB,1.1126E+01_JPRB,1.3186E+01_JPRB/)
KBO( :, 5,50,11) = (/&
&5.8619E-01_JPRB,5.8614E-01_JPRB,4.7566E+00_JPRB,8.1231E+00_JPRB,1.1244E+01_JPRB,1.3516E+01_JPRB/)
KBO( :, 1,51,11) = (/&
&2.5326E-01_JPRB,2.5365E-01_JPRB,3.9197E+00_JPRB,6.9713E+00_JPRB,9.6644E+00_JPRB,1.0563E+01_JPRB/)
KBO( :, 2,51,11) = (/&
&3.0874E-01_JPRB,3.0902E-01_JPRB,4.1778E+00_JPRB,7.4188E+00_JPRB,1.0300E+01_JPRB,1.1619E+01_JPRB/)
KBO( :, 3,51,11) = (/&
&3.7711E-01_JPRB,3.7728E-01_JPRB,4.4030E+00_JPRB,7.7505E+00_JPRB,1.0757E+01_JPRB,1.2466E+01_JPRB/)
KBO( :, 4,51,11) = (/&
&4.5549E-01_JPRB,4.5558E-01_JPRB,4.5816E+00_JPRB,7.9699E+00_JPRB,1.1056E+01_JPRB,1.3074E+01_JPRB/)
KBO( :, 5,51,11) = (/&
&5.4422E-01_JPRB,5.4419E-01_JPRB,4.7173E+00_JPRB,8.0963E+00_JPRB,1.1218E+01_JPRB,1.3472E+01_JPRB/)
KBO( :, 1,52,11) = (/&
&2.2461E-01_JPRB,2.2501E-01_JPRB,3.8110E+00_JPRB,6.7727E+00_JPRB,9.3780E+00_JPRB,1.0204E+01_JPRB/)
KBO( :, 2,52,11) = (/&
&2.7696E-01_JPRB,2.7724E-01_JPRB,4.0846E+00_JPRB,7.2661E+00_JPRB,1.0090E+01_JPRB,1.1325E+01_JPRB/)
KBO( :, 3,52,11) = (/&
&3.4251E-01_JPRB,3.4273E-01_JPRB,4.3258E+00_JPRB,7.6413E+00_JPRB,1.0608E+01_JPRB,1.2266E+01_JPRB/)
KBO( :, 4,52,11) = (/&
&4.1924E-01_JPRB,4.1934E-01_JPRB,4.5215E+00_JPRB,7.9004E+00_JPRB,1.0966E+01_JPRB,1.2948E+01_JPRB/)
KBO( :, 5,52,11) = (/&
&5.0516E-01_JPRB,5.0516E-01_JPRB,4.6729E+00_JPRB,8.0607E+00_JPRB,1.1176E+01_JPRB,1.3418E+01_JPRB/)
KBO( :, 1,53,11) = (/&
&1.9876E-01_JPRB,1.9925E-01_JPRB,3.6957E+00_JPRB,6.5526E+00_JPRB,9.0627E+00_JPRB,9.8215E+00_JPRB/)
KBO( :, 2,53,11) = (/&
&2.4812E-01_JPRB,2.4842E-01_JPRB,3.9863E+00_JPRB,7.0970E+00_JPRB,9.8501E+00_JPRB,1.1018E+01_JPRB/)
KBO( :, 3,53,11) = (/&
&3.1019E-01_JPRB,3.1042E-01_JPRB,4.2400E+00_JPRB,7.5167E+00_JPRB,1.0436E+01_JPRB,1.2052E+01_JPRB/)
KBO( :, 4,53,11) = (/&
&3.8453E-01_JPRB,3.8465E-01_JPRB,4.4543E+00_JPRB,7.8181E+00_JPRB,1.0855E+01_JPRB,1.2811E+01_JPRB/)
KBO( :, 5,53,11) = (/&
&4.6824E-01_JPRB,4.6827E-01_JPRB,4.6221E+00_JPRB,8.0127E+00_JPRB,1.1114E+01_JPRB,1.3357E+01_JPRB/)
KBO( :, 1,54,11) = (/&
&1.7658E-01_JPRB,1.7738E-01_JPRB,3.5830E+00_JPRB,6.3331E+00_JPRB,8.7501E+00_JPRB,9.3830E+00_JPRB/)
KBO( :, 2,54,11) = (/&
&2.2311E-01_JPRB,2.2343E-01_JPRB,3.8924E+00_JPRB,6.9272E+00_JPRB,9.6066E+00_JPRB,1.0637E+01_JPRB/)
KBO( :, 3,54,11) = (/&
&2.8225E-01_JPRB,2.8249E-01_JPRB,4.1567E+00_JPRB,7.3875E+00_JPRB,1.0262E+01_JPRB,1.1745E+01_JPRB/)
KBO( :, 4,54,11) = (/&
&3.5407E-01_JPRB,3.5420E-01_JPRB,4.3869E+00_JPRB,7.7293E+00_JPRB,1.0733E+01_JPRB,1.2587E+01_JPRB/)
KBO( :, 5,54,11) = (/&
&4.3599E-01_JPRB,4.3605E-01_JPRB,4.5705E+00_JPRB,7.9578E+00_JPRB,1.1045E+01_JPRB,1.3213E+01_JPRB/)
KBO( :, 1,55,11) = (/&
&1.5693E-01_JPRB,1.5821E-01_JPRB,3.4683E+00_JPRB,6.1089E+00_JPRB,8.4282E+00_JPRB,8.9090E+00_JPRB/)
KBO( :, 2,55,11) = (/&
&2.0085E-01_JPRB,2.0128E-01_JPRB,3.7963E+00_JPRB,6.7515E+00_JPRB,9.3517E+00_JPRB,1.0215E+01_JPRB/)
KBO( :, 3,55,11) = (/&
&2.5734E-01_JPRB,2.5756E-01_JPRB,4.0737E+00_JPRB,7.2511E+00_JPRB,1.0072E+01_JPRB,1.1362E+01_JPRB/)
KBO( :, 4,55,11) = (/&
&3.2630E-01_JPRB,3.2643E-01_JPRB,4.3183E+00_JPRB,7.6321E+00_JPRB,1.0598E+01_JPRB,1.2305E+01_JPRB/)
KBO( :, 5,55,11) = (/&
&4.0605E-01_JPRB,4.0612E-01_JPRB,4.5166E+00_JPRB,7.8950E+00_JPRB,1.0962E+01_JPRB,1.2994E+01_JPRB/)
KBO( :, 1,56,11) = (/&
&1.3887E-01_JPRB,1.4103E-01_JPRB,3.3452E+00_JPRB,5.8712E+00_JPRB,8.0833E+00_JPRB,8.4282E+00_JPRB/)
KBO( :, 2,56,11) = (/&
&1.8055E-01_JPRB,1.8122E-01_JPRB,3.6957E+00_JPRB,6.5591E+00_JPRB,9.0757E+00_JPRB,9.7805E+00_JPRB/)
KBO( :, 3,56,11) = (/&
&2.3436E-01_JPRB,2.3458E-01_JPRB,3.9878E+00_JPRB,7.1027E+00_JPRB,9.8624E+00_JPRB,1.0961E+01_JPRB/)
KBO( :, 4,56,11) = (/&
&2.9996E-01_JPRB,3.0009E-01_JPRB,4.2431E+00_JPRB,7.5221E+00_JPRB,1.0447E+01_JPRB,1.1989E+01_JPRB/)
KBO( :, 5,56,11) = (/&
&3.7712E-01_JPRB,3.7719E-01_JPRB,4.4577E+00_JPRB,7.8227E+00_JPRB,1.0864E+01_JPRB,1.2750E+01_JPRB/)
KBO( :, 1,57,11) = (/&
&1.2231E-01_JPRB,1.2572E-01_JPRB,3.2149E+00_JPRB,5.6195E+00_JPRB,7.7189E+00_JPRB,7.9409E+00_JPRB/)
KBO( :, 2,57,11) = (/&
&1.6188E-01_JPRB,1.6303E-01_JPRB,3.5895E+00_JPRB,6.3509E+00_JPRB,8.7789E+00_JPRB,9.3239E+00_JPRB/)
KBO( :, 3,57,11) = (/&
&2.1281E-01_JPRB,2.1309E-01_JPRB,3.8984E+00_JPRB,6.9426E+00_JPRB,9.6313E+00_JPRB,1.0551E+01_JPRB/)
KBO( :, 4,57,11) = (/&
&2.7533E-01_JPRB,2.7549E-01_JPRB,4.1635E+00_JPRB,7.3997E+00_JPRB,1.0280E+01_JPRB,1.1629E+01_JPRB/)
KBO( :, 5,57,11) = (/&
&3.4953E-01_JPRB,3.4962E-01_JPRB,4.3933E+00_JPRB,7.7390E+00_JPRB,1.0749E+01_JPRB,1.2483E+01_JPRB/)
KBO( :, 1,58,11) = (/&
&1.0753E-01_JPRB,1.1255E-01_JPRB,3.0845E+00_JPRB,5.3675E+00_JPRB,7.3519E+00_JPRB,7.4714E+00_JPRB/)
KBO( :, 2,58,11) = (/&
&1.4527E-01_JPRB,1.4713E-01_JPRB,3.4823E+00_JPRB,6.1407E+00_JPRB,8.4780E+00_JPRB,8.8781E+00_JPRB/)
KBO( :, 3,58,11) = (/&
&1.9346E-01_JPRB,1.9393E-01_JPRB,3.8086E+00_JPRB,6.7779E+00_JPRB,9.3926E+00_JPRB,1.0139E+01_JPRB/)
KBO( :, 4,58,11) = (/&
&2.5331E-01_JPRB,2.5345E-01_JPRB,4.0858E+00_JPRB,7.2725E+00_JPRB,1.0104E+01_JPRB,1.1238E+01_JPRB/)
KBO( :, 5,58,11) = (/&
&3.2441E-01_JPRB,3.2451E-01_JPRB,4.3290E+00_JPRB,7.6484E+00_JPRB,1.0623E+01_JPRB,1.2180E+01_JPRB/)
KBO( :, 1,59,11) = (/&
&9.9614E-02_JPRB,1.0577E-01_JPRB,3.0288E+00_JPRB,5.2610E+00_JPRB,7.1978E+00_JPRB,7.2394E+00_JPRB/)
KBO( :, 2,59,11) = (/&
&1.3736E-01_JPRB,1.3969E-01_JPRB,3.4366E+00_JPRB,6.0532E+00_JPRB,8.3509E+00_JPRB,8.6179E+00_JPRB/)
KBO( :, 3,59,11) = (/&
&1.8506E-01_JPRB,1.8566E-01_JPRB,3.7708E+00_JPRB,6.7076E+00_JPRB,9.2912E+00_JPRB,9.8422E+00_JPRB/)
KBO( :, 4,59,11) = (/&
&2.4408E-01_JPRB,2.4421E-01_JPRB,4.0531E+00_JPRB,7.2180E+00_JPRB,1.0029E+01_JPRB,1.0900E+01_JPRB/)
KBO( :, 5,59,11) = (/&
&3.1395E-01_JPRB,3.1406E-01_JPRB,4.3016E+00_JPRB,7.6085E+00_JPRB,1.0568E+01_JPRB,1.1809E+01_JPRB/)
KBO( :, 1,13,12) = (/&
&1.5071E+01_JPRB,1.5062E+01_JPRB,1.1553E+01_JPRB,8.0422E+00_JPRB,5.1775E+00_JPRB,4.4276E+00_JPRB/)
KBO( :, 2,13,12) = (/&
&1.5045E+01_JPRB,1.5037E+01_JPRB,1.1523E+01_JPRB,8.0068E+00_JPRB,5.0603E+00_JPRB,4.3468E+00_JPRB/)
KBO( :, 3,13,12) = (/&
&1.4932E+01_JPRB,1.4924E+01_JPRB,1.1428E+01_JPRB,7.9305E+00_JPRB,4.9434E+00_JPRB,4.2743E+00_JPRB/)
KBO( :, 4,13,12) = (/&
&1.4793E+01_JPRB,1.4785E+01_JPRB,1.1318E+01_JPRB,7.8509E+00_JPRB,4.8345E+00_JPRB,4.2338E+00_JPRB/)
KBO( :, 5,13,12) = (/&
&1.4616E+01_JPRB,1.4607E+01_JPRB,1.1172E+01_JPRB,7.7373E+00_JPRB,4.7181E+00_JPRB,4.2382E+00_JPRB/)
KBO( :, 1,14,12) = (/&
&1.6109E+01_JPRB,1.6100E+01_JPRB,1.2313E+01_JPRB,8.5158E+00_JPRB,5.5307E+00_JPRB,4.8392E+00_JPRB/)
KBO( :, 2,14,12) = (/&
&1.6026E+01_JPRB,1.6017E+01_JPRB,1.2244E+01_JPRB,8.4632E+00_JPRB,5.4108E+00_JPRB,4.7399E+00_JPRB/)
KBO( :, 3,14,12) = (/&
&1.5874E+01_JPRB,1.5865E+01_JPRB,1.2127E+01_JPRB,8.3786E+00_JPRB,5.2843E+00_JPRB,4.6480E+00_JPRB/)
KBO( :, 4,14,12) = (/&
&1.5690E+01_JPRB,1.5681E+01_JPRB,1.1982E+01_JPRB,8.2687E+00_JPRB,5.1442E+00_JPRB,4.5663E+00_JPRB/)
KBO( :, 5,14,12) = (/&
&1.5467E+01_JPRB,1.5458E+01_JPRB,1.1810E+01_JPRB,8.1473E+00_JPRB,5.0031E+00_JPRB,4.5067E+00_JPRB/)
KBO( :, 1,15,12) = (/&
&1.6950E+01_JPRB,1.6940E+01_JPRB,1.2936E+01_JPRB,8.9243E+00_JPRB,5.9139E+00_JPRB,5.3392E+00_JPRB/)
KBO( :, 2,15,12) = (/&
&1.6795E+01_JPRB,1.6786E+01_JPRB,1.2817E+01_JPRB,8.8403E+00_JPRB,5.7728E+00_JPRB,5.2173E+00_JPRB/)
KBO( :, 3,15,12) = (/&
&1.6618E+01_JPRB,1.6608E+01_JPRB,1.2675E+01_JPRB,8.7335E+00_JPRB,5.6294E+00_JPRB,5.1076E+00_JPRB/)
KBO( :, 4,15,12) = (/&
&1.6363E+01_JPRB,1.6354E+01_JPRB,1.2477E+01_JPRB,8.5926E+00_JPRB,5.4844E+00_JPRB,5.0174E+00_JPRB/)
KBO( :, 5,15,12) = (/&
&1.6071E+01_JPRB,1.6061E+01_JPRB,1.2263E+01_JPRB,8.4516E+00_JPRB,5.3505E+00_JPRB,4.9217E+00_JPRB/)
KBO( :, 1,16,12) = (/&
&1.7483E+01_JPRB,1.7473E+01_JPRB,1.3331E+01_JPRB,9.1930E+00_JPRB,6.3135E+00_JPRB,5.9094E+00_JPRB/)
KBO( :, 2,16,12) = (/&
&1.7265E+01_JPRB,1.7255E+01_JPRB,1.3158E+01_JPRB,9.0640E+00_JPRB,6.1752E+00_JPRB,5.7636E+00_JPRB/)
KBO( :, 3,16,12) = (/&
&1.7001E+01_JPRB,1.6992E+01_JPRB,1.2961E+01_JPRB,8.9272E+00_JPRB,6.0421E+00_JPRB,5.6420E+00_JPRB/)
KBO( :, 4,16,12) = (/&
&1.6715E+01_JPRB,1.6706E+01_JPRB,1.2750E+01_JPRB,8.7873E+00_JPRB,5.9067E+00_JPRB,5.5250E+00_JPRB/)
KBO( :, 5,16,12) = (/&
&1.6400E+01_JPRB,1.6391E+01_JPRB,1.2509E+01_JPRB,8.6238E+00_JPRB,5.7670E+00_JPRB,5.4408E+00_JPRB/)
KBO( :, 1,17,12) = (/&
&1.7611E+01_JPRB,1.7601E+01_JPRB,1.3423E+01_JPRB,9.2865E+00_JPRB,6.8286E+00_JPRB,6.5192E+00_JPRB/)
KBO( :, 2,17,12) = (/&
&1.7351E+01_JPRB,1.7341E+01_JPRB,1.3231E+01_JPRB,9.1506E+00_JPRB,6.6893E+00_JPRB,6.3748E+00_JPRB/)
KBO( :, 3,17,12) = (/&
&1.7056E+01_JPRB,1.7047E+01_JPRB,1.3013E+01_JPRB,9.0104E+00_JPRB,6.5437E+00_JPRB,6.2526E+00_JPRB/)
KBO( :, 4,17,12) = (/&
&1.6747E+01_JPRB,1.6738E+01_JPRB,1.2778E+01_JPRB,8.8490E+00_JPRB,6.3936E+00_JPRB,6.1321E+00_JPRB/)
KBO( :, 5,17,12) = (/&
&1.6425E+01_JPRB,1.6416E+01_JPRB,1.2531E+01_JPRB,8.6800E+00_JPRB,6.2394E+00_JPRB,6.0341E+00_JPRB/)
KBO( :, 1,18,12) = (/&
&1.7373E+01_JPRB,1.7363E+01_JPRB,1.3259E+01_JPRB,9.2987E+00_JPRB,7.4434E+00_JPRB,7.1986E+00_JPRB/)
KBO( :, 2,18,12) = (/&
&1.7075E+01_JPRB,1.7065E+01_JPRB,1.3035E+01_JPRB,9.1492E+00_JPRB,7.2871E+00_JPRB,7.0606E+00_JPRB/)
KBO( :, 3,18,12) = (/&
&1.6756E+01_JPRB,1.6747E+01_JPRB,1.2796E+01_JPRB,8.9869E+00_JPRB,7.1229E+00_JPRB,6.9365E+00_JPRB/)
KBO( :, 4,18,12) = (/&
&1.6448E+01_JPRB,1.6438E+01_JPRB,1.2559E+01_JPRB,8.8102E+00_JPRB,6.9614E+00_JPRB,6.7953E+00_JPRB/)
KBO( :, 5,18,12) = (/&
&1.6127E+01_JPRB,1.6118E+01_JPRB,1.2311E+01_JPRB,8.6284E+00_JPRB,6.8009E+00_JPRB,6.6712E+00_JPRB/)
KBO( :, 1,19,12) = (/&
&1.6746E+01_JPRB,1.6736E+01_JPRB,1.2803E+01_JPRB,9.3167E+00_JPRB,8.0934E+00_JPRB,7.9604E+00_JPRB/)
KBO( :, 2,19,12) = (/&
&1.6435E+01_JPRB,1.6426E+01_JPRB,1.2567E+01_JPRB,9.1426E+00_JPRB,7.9243E+00_JPRB,7.8083E+00_JPRB/)
KBO( :, 3,19,12) = (/&
&1.6123E+01_JPRB,1.6114E+01_JPRB,1.2329E+01_JPRB,8.9518E+00_JPRB,7.7527E+00_JPRB,7.6627E+00_JPRB/)
KBO( :, 4,19,12) = (/&
&1.5818E+01_JPRB,1.5809E+01_JPRB,1.2094E+01_JPRB,8.7559E+00_JPRB,7.5782E+00_JPRB,7.5080E+00_JPRB/)
KBO( :, 5,19,12) = (/&
&1.5498E+01_JPRB,1.5490E+01_JPRB,1.1845E+01_JPRB,8.5563E+00_JPRB,7.3997E+00_JPRB,7.3552E+00_JPRB/)
KBO( :, 1,20,12) = (/&
&1.5808E+01_JPRB,1.5799E+01_JPRB,1.2109E+01_JPRB,9.3560E+00_JPRB,8.7540E+00_JPRB,8.7978E+00_JPRB/)
KBO( :, 2,20,12) = (/&
&1.5503E+01_JPRB,1.5494E+01_JPRB,1.1873E+01_JPRB,9.1479E+00_JPRB,8.5752E+00_JPRB,8.6307E+00_JPRB/)
KBO( :, 3,20,12) = (/&
&1.5194E+01_JPRB,1.5185E+01_JPRB,1.1636E+01_JPRB,8.9392E+00_JPRB,8.3955E+00_JPRB,8.4731E+00_JPRB/)
KBO( :, 4,20,12) = (/&
&1.4894E+01_JPRB,1.4886E+01_JPRB,1.1403E+01_JPRB,8.7296E+00_JPRB,8.2170E+00_JPRB,8.2989E+00_JPRB/)
KBO( :, 5,20,12) = (/&
&1.4572E+01_JPRB,1.4563E+01_JPRB,1.1152E+01_JPRB,8.5115E+00_JPRB,8.0382E+00_JPRB,8.1214E+00_JPRB/)
KBO( :, 1,21,12) = (/&
&1.4618E+01_JPRB,1.4609E+01_JPRB,1.1224E+01_JPRB,9.4749E+00_JPRB,9.4674E+00_JPRB,9.7176E+00_JPRB/)
KBO( :, 2,21,12) = (/&
&1.4320E+01_JPRB,1.4312E+01_JPRB,1.0993E+01_JPRB,9.2613E+00_JPRB,9.2871E+00_JPRB,9.5392E+00_JPRB/)
KBO( :, 3,21,12) = (/&
&1.4030E+01_JPRB,1.4022E+01_JPRB,1.0770E+01_JPRB,9.0451E+00_JPRB,9.1076E+00_JPRB,9.3604E+00_JPRB/)
KBO( :, 4,21,12) = (/&
&1.3731E+01_JPRB,1.3724E+01_JPRB,1.0538E+01_JPRB,8.8193E+00_JPRB,8.9189E+00_JPRB,9.1661E+00_JPRB/)
KBO( :, 5,21,12) = (/&
&1.3412E+01_JPRB,1.3405E+01_JPRB,1.0288E+01_JPRB,8.5978E+00_JPRB,8.7269E+00_JPRB,8.9634E+00_JPRB/)
KBO( :, 1,22,12) = (/&
&1.3252E+01_JPRB,1.3245E+01_JPRB,1.0263E+01_JPRB,9.6884E+00_JPRB,1.0237E+01_JPRB,1.0659E+01_JPRB/)
KBO( :, 2,22,12) = (/&
&1.2974E+01_JPRB,1.2967E+01_JPRB,1.0045E+01_JPRB,9.4635E+00_JPRB,1.0051E+01_JPRB,1.0470E+01_JPRB/)
KBO( :, 3,22,12) = (/&
&1.2686E+01_JPRB,1.2679E+01_JPRB,9.8204E+00_JPRB,9.2336E+00_JPRB,9.8532E+00_JPRB,1.0276E+01_JPRB/)
KBO( :, 4,22,12) = (/&
&1.2392E+01_JPRB,1.2385E+01_JPRB,9.5853E+00_JPRB,9.0077E+00_JPRB,9.6460E+00_JPRB,1.0057E+01_JPRB/)
KBO( :, 5,22,12) = (/&
&1.2080E+01_JPRB,1.2073E+01_JPRB,9.3373E+00_JPRB,8.7763E+00_JPRB,9.4290E+00_JPRB,9.8257E+00_JPRB/)
KBO( :, 1,23,12) = (/&
&1.1802E+01_JPRB,1.1796E+01_JPRB,9.3955E+00_JPRB,9.9793E+00_JPRB,1.1071E+01_JPRB,1.1590E+01_JPRB/)
KBO( :, 2,23,12) = (/&
&1.1532E+01_JPRB,1.1526E+01_JPRB,9.1740E+00_JPRB,9.7510E+00_JPRB,1.0853E+01_JPRB,1.1387E+01_JPRB/)
KBO( :, 3,23,12) = (/&
&1.1254E+01_JPRB,1.1248E+01_JPRB,8.9457E+00_JPRB,9.5279E+00_JPRB,1.0621E+01_JPRB,1.1176E+01_JPRB/)
KBO( :, 4,23,12) = (/&
&1.0971E+01_JPRB,1.0965E+01_JPRB,8.7049E+00_JPRB,9.2947E+00_JPRB,1.0373E+01_JPRB,1.0939E+01_JPRB/)
KBO( :, 5,23,12) = (/&
&1.0694E+01_JPRB,1.0688E+01_JPRB,8.4691E+00_JPRB,9.0520E+00_JPRB,1.0118E+01_JPRB,1.0692E+01_JPRB/)
KBO( :, 1,24,12) = (/&
&1.0339E+01_JPRB,1.0334E+01_JPRB,8.7416E+00_JPRB,1.0311E+01_JPRB,1.1869E+01_JPRB,1.2496E+01_JPRB/)
KBO( :, 2,24,12) = (/&
&1.0079E+01_JPRB,1.0074E+01_JPRB,8.5118E+00_JPRB,1.0085E+01_JPRB,1.1623E+01_JPRB,1.2266E+01_JPRB/)
KBO( :, 3,24,12) = (/&
&9.8237E+00_JPRB,9.8183E+00_JPRB,8.2739E+00_JPRB,9.8502E+00_JPRB,1.1362E+01_JPRB,1.2041E+01_JPRB/)
KBO( :, 4,24,12) = (/&
&9.5837E+00_JPRB,9.5785E+00_JPRB,8.0352E+00_JPRB,9.6060E+00_JPRB,1.1087E+01_JPRB,1.1795E+01_JPRB/)
KBO( :, 5,24,12) = (/&
&9.4022E+00_JPRB,9.3971E+00_JPRB,7.8130E+00_JPRB,9.3488E+00_JPRB,1.0802E+01_JPRB,1.1530E+01_JPRB/)
KBO( :, 1,25,12) = (/&
&8.9159E+00_JPRB,8.9112E+00_JPRB,8.3253E+00_JPRB,1.0680E+01_JPRB,1.2624E+01_JPRB,1.3349E+01_JPRB/)
KBO( :, 2,25,12) = (/&
&8.6856E+00_JPRB,8.6810E+00_JPRB,8.0901E+00_JPRB,1.0434E+01_JPRB,1.2357E+01_JPRB,1.3117E+01_JPRB/)
KBO( :, 3,25,12) = (/&
&8.4955E+00_JPRB,8.4909E+00_JPRB,7.8520E+00_JPRB,1.0179E+01_JPRB,1.2070E+01_JPRB,1.2889E+01_JPRB/)
KBO( :, 4,25,12) = (/&
&8.3669E+00_JPRB,8.3624E+00_JPRB,7.6206E+00_JPRB,9.9074E+00_JPRB,1.1769E+01_JPRB,1.2627E+01_JPRB/)
KBO( :, 5,25,12) = (/&
&8.2951E+00_JPRB,8.2906E+00_JPRB,7.4263E+00_JPRB,9.6322E+00_JPRB,1.1459E+01_JPRB,1.2339E+01_JPRB/)
KBO( :, 1,26,12) = (/&
&7.5918E+00_JPRB,7.5878E+00_JPRB,8.0448E+00_JPRB,1.1047E+01_JPRB,1.3308E+01_JPRB,1.4181E+01_JPRB/)
KBO( :, 2,26,12) = (/&
&7.4417E+00_JPRB,7.4378E+00_JPRB,7.8118E+00_JPRB,1.0782E+01_JPRB,1.3032E+01_JPRB,1.3946E+01_JPRB/)
KBO( :, 3,26,12) = (/&
&7.3590E+00_JPRB,7.3551E+00_JPRB,7.5780E+00_JPRB,1.0497E+01_JPRB,1.2721E+01_JPRB,1.3696E+01_JPRB/)
KBO( :, 4,26,12) = (/&
&7.3502E+00_JPRB,7.3462E+00_JPRB,7.3714E+00_JPRB,1.0203E+01_JPRB,1.2399E+01_JPRB,1.3409E+01_JPRB/)
KBO( :, 5,26,12) = (/&
&7.4276E+00_JPRB,7.4236E+00_JPRB,7.2173E+00_JPRB,9.8998E+00_JPRB,1.2064E+01_JPRB,1.3105E+01_JPRB/)
KBO( :, 1,27,12) = (/&
&6.4683E+00_JPRB,6.4649E+00_JPRB,7.8812E+00_JPRB,1.1375E+01_JPRB,1.3927E+01_JPRB,1.4966E+01_JPRB/)
KBO( :, 2,27,12) = (/&
&6.4189E+00_JPRB,6.4156E+00_JPRB,7.6472E+00_JPRB,1.1088E+01_JPRB,1.3638E+01_JPRB,1.4716E+01_JPRB/)
KBO( :, 3,27,12) = (/&
&6.4591E+00_JPRB,6.4557E+00_JPRB,7.4245E+00_JPRB,1.0785E+01_JPRB,1.3326E+01_JPRB,1.4451E+01_JPRB/)
KBO( :, 4,27,12) = (/&
&6.5895E+00_JPRB,6.5861E+00_JPRB,7.2540E+00_JPRB,1.0466E+01_JPRB,1.2988E+01_JPRB,1.4141E+01_JPRB/)
KBO( :, 5,27,12) = (/&
&6.7673E+00_JPRB,6.7638E+00_JPRB,7.1253E+00_JPRB,1.0145E+01_JPRB,1.2630E+01_JPRB,1.3805E+01_JPRB/)
KBO( :, 1,28,12) = (/&
&5.5812E+00_JPRB,5.5783E+00_JPRB,7.7689E+00_JPRB,1.1658E+01_JPRB,1.4504E+01_JPRB,1.5676E+01_JPRB/)
KBO( :, 2,28,12) = (/&
&5.6494E+00_JPRB,5.6465E+00_JPRB,7.5324E+00_JPRB,1.1356E+01_JPRB,1.4208E+01_JPRB,1.5420E+01_JPRB/)
KBO( :, 3,28,12) = (/&
&5.8063E+00_JPRB,5.8033E+00_JPRB,7.3350E+00_JPRB,1.1035E+01_JPRB,1.3883E+01_JPRB,1.5136E+01_JPRB/)
KBO( :, 4,28,12) = (/&
&5.9982E+00_JPRB,5.9952E+00_JPRB,7.1895E+00_JPRB,1.0705E+01_JPRB,1.3523E+01_JPRB,1.4796E+01_JPRB/)
KBO( :, 5,28,12) = (/&
&6.2275E+00_JPRB,6.2243E+00_JPRB,7.0847E+00_JPRB,1.0363E+01_JPRB,1.3144E+01_JPRB,1.4440E+01_JPRB/)
KBO( :, 1,29,12) = (/&
&4.9263E+00_JPRB,4.9239E+00_JPRB,7.6738E+00_JPRB,1.1886E+01_JPRB,1.5034E+01_JPRB,1.6303E+01_JPRB/)
KBO( :, 2,29,12) = (/&
&5.0905E+00_JPRB,5.0880E+00_JPRB,7.4511E+00_JPRB,1.1577E+01_JPRB,1.4725E+01_JPRB,1.6056E+01_JPRB/)
KBO( :, 3,29,12) = (/&
&5.2910E+00_JPRB,5.2884E+00_JPRB,7.2824E+00_JPRB,1.1245E+01_JPRB,1.4371E+01_JPRB,1.5737E+01_JPRB/)
KBO( :, 4,29,12) = (/&
&5.5388E+00_JPRB,5.5361E+00_JPRB,7.1566E+00_JPRB,1.0903E+01_JPRB,1.3995E+01_JPRB,1.5373E+01_JPRB/)
KBO( :, 5,29,12) = (/&
&5.8140E+00_JPRB,5.8111E+00_JPRB,7.0642E+00_JPRB,1.0551E+01_JPRB,1.3590E+01_JPRB,1.5023E+01_JPRB/)
KBO( :, 1,30,12) = (/&
&4.4481E+00_JPRB,4.4460E+00_JPRB,7.5927E+00_JPRB,1.2072E+01_JPRB,1.5506E+01_JPRB,1.6872E+01_JPRB/)
KBO( :, 2,30,12) = (/&
&4.6495E+00_JPRB,4.6473E+00_JPRB,7.3991E+00_JPRB,1.1764E+01_JPRB,1.5173E+01_JPRB,1.6609E+01_JPRB/)
KBO( :, 3,30,12) = (/&
&4.9026E+00_JPRB,4.9003E+00_JPRB,7.2499E+00_JPRB,1.1426E+01_JPRB,1.4795E+01_JPRB,1.6261E+01_JPRB/)
KBO( :, 4,30,12) = (/&
&5.1748E+00_JPRB,5.1723E+00_JPRB,7.1402E+00_JPRB,1.1073E+01_JPRB,1.4399E+01_JPRB,1.5886E+01_JPRB/)
KBO( :, 5,30,12) = (/&
&5.4669E+00_JPRB,5.4641E+00_JPRB,7.0513E+00_JPRB,1.0712E+01_JPRB,1.3969E+01_JPRB,1.5546E+01_JPRB/)
KBO( :, 1,31,12) = (/&
&4.0826E+00_JPRB,4.0808E+00_JPRB,7.5248E+00_JPRB,1.2230E+01_JPRB,1.5909E+01_JPRB,1.7372E+01_JPRB/)
KBO( :, 2,31,12) = (/&
&4.3203E+00_JPRB,4.3184E+00_JPRB,7.3583E+00_JPRB,1.1921E+01_JPRB,1.5546E+01_JPRB,1.7073E+01_JPRB/)
KBO( :, 3,31,12) = (/&
&4.5820E+00_JPRB,4.5799E+00_JPRB,7.2311E+00_JPRB,1.1577E+01_JPRB,1.5153E+01_JPRB,1.6713E+01_JPRB/)
KBO( :, 4,31,12) = (/&
&4.8695E+00_JPRB,4.8672E+00_JPRB,7.1286E+00_JPRB,1.1212E+01_JPRB,1.4724E+01_JPRB,1.6381E+01_JPRB/)
KBO( :, 5,31,12) = (/&
&5.1816E+00_JPRB,5.1790E+00_JPRB,7.0469E+00_JPRB,1.0847E+01_JPRB,1.4274E+01_JPRB,1.6048E+01_JPRB/)
KBO( :, 1,32,12) = (/&
&3.7968E+00_JPRB,3.7952E+00_JPRB,7.4739E+00_JPRB,1.2361E+01_JPRB,1.6239E+01_JPRB,1.7800E+01_JPRB/)
KBO( :, 2,32,12) = (/&
&4.0447E+00_JPRB,4.0430E+00_JPRB,7.3338E+00_JPRB,1.2050E+01_JPRB,1.5855E+01_JPRB,1.7484E+01_JPRB/)
KBO( :, 3,32,12) = (/&
&4.3179E+00_JPRB,4.3159E+00_JPRB,7.2183E+00_JPRB,1.1702E+01_JPRB,1.5442E+01_JPRB,1.7161E+01_JPRB/)
KBO( :, 4,32,12) = (/&
&4.6213E+00_JPRB,4.6191E+00_JPRB,7.1240E+00_JPRB,1.1329E+01_JPRB,1.4991E+01_JPRB,1.6858E+01_JPRB/)
KBO( :, 5,32,12) = (/&
&4.9485E+00_JPRB,4.9460E+00_JPRB,7.0483E+00_JPRB,1.0954E+01_JPRB,1.4516E+01_JPRB,1.6491E+01_JPRB/)
KBO( :, 1,33,12) = (/&
&3.5568E+00_JPRB,3.5554E+00_JPRB,7.4337E+00_JPRB,1.2471E+01_JPRB,1.6507E+01_JPRB,1.8167E+01_JPRB/)
KBO( :, 2,33,12) = (/&
&3.8191E+00_JPRB,3.8174E+00_JPRB,7.3162E+00_JPRB,1.2150E+01_JPRB,1.6107E+01_JPRB,1.7878E+01_JPRB/)
KBO( :, 3,33,12) = (/&
&4.1081E+00_JPRB,4.1061E+00_JPRB,7.2154E+00_JPRB,1.1795E+01_JPRB,1.5670E+01_JPRB,1.7617E+01_JPRB/)
KBO( :, 4,33,12) = (/&
&4.4244E+00_JPRB,4.4223E+00_JPRB,7.1305E+00_JPRB,1.1413E+01_JPRB,1.5196E+01_JPRB,1.7282E+01_JPRB/)
KBO( :, 5,33,12) = (/&
&4.7677E+00_JPRB,4.7653E+00_JPRB,7.0542E+00_JPRB,1.1036E+01_JPRB,1.4698E+01_JPRB,1.6888E+01_JPRB/)
KBO( :, 1,34,12) = (/&
&3.3521E+00_JPRB,3.3507E+00_JPRB,7.4128E+00_JPRB,1.2559E+01_JPRB,1.6734E+01_JPRB,1.8506E+01_JPRB/)
KBO( :, 2,34,12) = (/&
&3.6291E+00_JPRB,3.6275E+00_JPRB,7.3128E+00_JPRB,1.2232E+01_JPRB,1.6317E+01_JPRB,1.8280E+01_JPRB/)
KBO( :, 3,34,12) = (/&
&3.9317E+00_JPRB,3.9298E+00_JPRB,7.2212E+00_JPRB,1.1872E+01_JPRB,1.5854E+01_JPRB,1.8005E+01_JPRB/)
KBO( :, 4,34,12) = (/&
&4.2593E+00_JPRB,4.2572E+00_JPRB,7.1423E+00_JPRB,1.1481E+01_JPRB,1.5360E+01_JPRB,1.7643E+01_JPRB/)
KBO( :, 5,34,12) = (/&
&4.6153E+00_JPRB,4.6130E+00_JPRB,7.0650E+00_JPRB,1.1105E+01_JPRB,1.4842E+01_JPRB,1.7226E+01_JPRB/)
KBO( :, 1,35,12) = (/&
&3.1598E+00_JPRB,3.1585E+00_JPRB,7.4142E+00_JPRB,1.2657E+01_JPRB,1.6945E+01_JPRB,1.8872E+01_JPRB/)
KBO( :, 2,35,12) = (/&
&3.4442E+00_JPRB,3.4427E+00_JPRB,7.3257E+00_JPRB,1.2327E+01_JPRB,1.6516E+01_JPRB,1.8673E+01_JPRB/)
KBO( :, 3,35,12) = (/&
&3.7587E+00_JPRB,3.7569E+00_JPRB,7.2409E+00_JPRB,1.1960E+01_JPRB,1.6036E+01_JPRB,1.8373E+01_JPRB/)
KBO( :, 4,35,12) = (/&
&4.0964E+00_JPRB,4.0944E+00_JPRB,7.1633E+00_JPRB,1.1567E+01_JPRB,1.5526E+01_JPRB,1.7979E+01_JPRB/)
KBO( :, 5,35,12) = (/&
&4.4686E+00_JPRB,4.4663E+00_JPRB,7.0860E+00_JPRB,1.1190E+01_JPRB,1.4992E+01_JPRB,1.7544E+01_JPRB/)
KBO( :, 1,36,12) = (/&
&2.9654E+00_JPRB,2.9641E+00_JPRB,7.4313E+00_JPRB,1.2766E+01_JPRB,1.7160E+01_JPRB,1.9227E+01_JPRB/)
KBO( :, 2,36,12) = (/&
&3.2570E+00_JPRB,3.2555E+00_JPRB,7.3495E+00_JPRB,1.2436E+01_JPRB,1.6723E+01_JPRB,1.9033E+01_JPRB/)
KBO( :, 3,36,12) = (/&
&3.5797E+00_JPRB,3.5780E+00_JPRB,7.2711E+00_JPRB,1.2069E+01_JPRB,1.6233E+01_JPRB,1.8715E+01_JPRB/)
KBO( :, 4,36,12) = (/&
&3.9316E+00_JPRB,3.9297E+00_JPRB,7.1919E+00_JPRB,1.1675E+01_JPRB,1.5711E+01_JPRB,1.8314E+01_JPRB/)
KBO( :, 5,36,12) = (/&
&4.3127E+00_JPRB,4.3105E+00_JPRB,7.1101E+00_JPRB,1.1293E+01_JPRB,1.5166E+01_JPRB,1.7865E+01_JPRB/)
KBO( :, 1,37,12) = (/&
&2.7533E+00_JPRB,2.7522E+00_JPRB,7.4577E+00_JPRB,1.2906E+01_JPRB,1.7405E+01_JPRB,1.9546E+01_JPRB/)
KBO( :, 2,37,12) = (/&
&3.0486E+00_JPRB,3.0472E+00_JPRB,7.3839E+00_JPRB,1.2582E+01_JPRB,1.6967E+01_JPRB,1.9367E+01_JPRB/)
KBO( :, 3,37,12) = (/&
&3.3772E+00_JPRB,3.3756E+00_JPRB,7.3093E+00_JPRB,1.2218E+01_JPRB,1.6476E+01_JPRB,1.9050E+01_JPRB/)
KBO( :, 4,37,12) = (/&
&3.7381E+00_JPRB,3.7362E+00_JPRB,7.2303E+00_JPRB,1.1826E+01_JPRB,1.5946E+01_JPRB,1.8659E+01_JPRB/)
KBO( :, 5,37,12) = (/&
&4.1246E+00_JPRB,4.1225E+00_JPRB,7.1455E+00_JPRB,1.1440E+01_JPRB,1.5395E+01_JPRB,1.8212E+01_JPRB/)
KBO( :, 1,38,12) = (/&
&2.5620E+00_JPRB,2.5610E+00_JPRB,7.4808E+00_JPRB,1.3030E+01_JPRB,1.7619E+01_JPRB,1.9841E+01_JPRB/)
KBO( :, 2,38,12) = (/&
&2.8608E+00_JPRB,2.8595E+00_JPRB,7.4174E+00_JPRB,1.2714E+01_JPRB,1.7188E+01_JPRB,1.9683E+01_JPRB/)
KBO( :, 3,38,12) = (/&
&3.1956E+00_JPRB,3.1942E+00_JPRB,7.3440E+00_JPRB,1.2353E+01_JPRB,1.6696E+01_JPRB,1.9369E+01_JPRB/)
KBO( :, 4,38,12) = (/&
&3.5649E+00_JPRB,3.5631E+00_JPRB,7.2670E+00_JPRB,1.1965E+01_JPRB,1.6163E+01_JPRB,1.8994E+01_JPRB/)
KBO( :, 5,38,12) = (/&
&3.9585E+00_JPRB,3.9565E+00_JPRB,7.1817E+00_JPRB,1.1573E+01_JPRB,1.5604E+01_JPRB,1.8550E+01_JPRB/)
KBO( :, 1,39,12) = (/&
&2.3896E+00_JPRB,2.3887E+00_JPRB,7.5031E+00_JPRB,1.3145E+01_JPRB,1.7806E+01_JPRB,2.0123E+01_JPRB/)
KBO( :, 2,39,12) = (/&
&2.6949E+00_JPRB,2.6937E+00_JPRB,7.4455E+00_JPRB,1.2830E+01_JPRB,1.7380E+01_JPRB,1.9979E+01_JPRB/)
KBO( :, 3,39,12) = (/&
&3.0362E+00_JPRB,3.0348E+00_JPRB,7.3756E+00_JPRB,1.2474E+01_JPRB,1.6890E+01_JPRB,1.9683E+01_JPRB/)
KBO( :, 4,39,12) = (/&
&3.4116E+00_JPRB,3.4099E+00_JPRB,7.3010E+00_JPRB,1.2089E+01_JPRB,1.6357E+01_JPRB,1.9331E+01_JPRB/)
KBO( :, 5,39,12) = (/&
&3.8125E+00_JPRB,3.8105E+00_JPRB,7.2161E+00_JPRB,1.1695E+01_JPRB,1.5793E+01_JPRB,1.8893E+01_JPRB/)
KBO( :, 1,40,12) = (/&
&2.2084E+00_JPRB,2.2076E+00_JPRB,7.5257E+00_JPRB,1.3272E+01_JPRB,1.8011E+01_JPRB,2.0327E+01_JPRB/)
KBO( :, 2,40,12) = (/&
&2.5142E+00_JPRB,2.5132E+00_JPRB,7.4776E+00_JPRB,1.2969E+01_JPRB,1.7599E+01_JPRB,2.0223E+01_JPRB/)
KBO( :, 3,40,12) = (/&
&2.8571E+00_JPRB,2.8558E+00_JPRB,7.4104E+00_JPRB,1.2622E+01_JPRB,1.7115E+01_JPRB,1.9951E+01_JPRB/)
KBO( :, 4,40,12) = (/&
&3.2355E+00_JPRB,3.2339E+00_JPRB,7.3412E+00_JPRB,1.2241E+01_JPRB,1.6586E+01_JPRB,1.9625E+01_JPRB/)
KBO( :, 5,40,12) = (/&
&3.6402E+00_JPRB,3.6383E+00_JPRB,7.2559E+00_JPRB,1.1846E+01_JPRB,1.6023E+01_JPRB,1.9193E+01_JPRB/)
KBO( :, 1,41,12) = (/&
&2.0392E+00_JPRB,2.0384E+00_JPRB,7.5497E+00_JPRB,1.3388E+01_JPRB,1.8196E+01_JPRB,2.0499E+01_JPRB/)
KBO( :, 2,41,12) = (/&
&2.3453E+00_JPRB,2.3444E+00_JPRB,7.5055E+00_JPRB,1.3103E+01_JPRB,1.7800E+01_JPRB,2.0441E+01_JPRB/)
KBO( :, 3,41,12) = (/&
&2.6889E+00_JPRB,2.6876E+00_JPRB,7.4442E+00_JPRB,1.2764E+01_JPRB,1.7330E+01_JPRB,2.0201E+01_JPRB/)
KBO( :, 4,41,12) = (/&
&3.0674E+00_JPRB,3.0659E+00_JPRB,7.3773E+00_JPRB,1.2388E+01_JPRB,1.6806E+01_JPRB,1.9901E+01_JPRB/)
KBO( :, 5,41,12) = (/&
&3.4739E+00_JPRB,3.4722E+00_JPRB,7.2932E+00_JPRB,1.1996E+01_JPRB,1.6248E+01_JPRB,1.9478E+01_JPRB/)
KBO( :, 1,42,12) = (/&
&1.8842E+00_JPRB,1.8835E+00_JPRB,7.5738E+00_JPRB,1.3492E+01_JPRB,1.8356E+01_JPRB,2.0651E+01_JPRB/)
KBO( :, 2,42,12) = (/&
&2.1916E+00_JPRB,2.1907E+00_JPRB,7.5284E+00_JPRB,1.3224E+01_JPRB,1.7982E+01_JPRB,2.0639E+01_JPRB/)
KBO( :, 3,42,12) = (/&
&2.5344E+00_JPRB,2.5332E+00_JPRB,7.4756E+00_JPRB,1.2895E+01_JPRB,1.7528E+01_JPRB,2.0438E+01_JPRB/)
KBO( :, 4,42,12) = (/&
&2.9115E+00_JPRB,2.9101E+00_JPRB,7.4107E+00_JPRB,1.2526E+01_JPRB,1.7014E+01_JPRB,2.0170E+01_JPRB/)
KBO( :, 5,42,12) = (/&
&3.3176E+00_JPRB,3.3160E+00_JPRB,7.3300E+00_JPRB,1.2138E+01_JPRB,1.6460E+01_JPRB,1.9759E+01_JPRB/)
KBO( :, 1,43,12) = (/&
&1.7267E+00_JPRB,1.7260E+00_JPRB,7.5950E+00_JPRB,1.3597E+01_JPRB,1.8513E+01_JPRB,2.0770E+01_JPRB/)
KBO( :, 2,43,12) = (/&
&2.0318E+00_JPRB,2.0310E+00_JPRB,7.5508E+00_JPRB,1.3350E+01_JPRB,1.8172E+01_JPRB,2.0815E+01_JPRB/)
KBO( :, 3,43,12) = (/&
&2.3711E+00_JPRB,2.3700E+00_JPRB,7.5067E+00_JPRB,1.3037E+01_JPRB,1.7739E+01_JPRB,2.0667E+01_JPRB/)
KBO( :, 4,43,12) = (/&
&2.7430E+00_JPRB,2.7417E+00_JPRB,7.4433E+00_JPRB,1.2679E+01_JPRB,1.7236E+01_JPRB,2.0434E+01_JPRB/)
KBO( :, 5,43,12) = (/&
&3.1470E+00_JPRB,3.1454E+00_JPRB,7.3686E+00_JPRB,1.2292E+01_JPRB,1.6691E+01_JPRB,2.0048E+01_JPRB/)
KBO( :, 1,44,12) = (/&
&1.5761E+00_JPRB,1.5756E+00_JPRB,7.6126E+00_JPRB,1.3691E+01_JPRB,1.8648E+01_JPRB,2.0862E+01_JPRB/)
KBO( :, 2,44,12) = (/&
&1.8753E+00_JPRB,1.8746E+00_JPRB,7.5725E+00_JPRB,1.3468E+01_JPRB,1.8351E+01_JPRB,2.0968E+01_JPRB/)
KBO( :, 3,44,12) = (/&
&2.2096E+00_JPRB,2.2086E+00_JPRB,7.5342E+00_JPRB,1.3177E+01_JPRB,1.7945E+01_JPRB,2.0887E+01_JPRB/)
KBO( :, 4,44,12) = (/&
&2.5754E+00_JPRB,2.5742E+00_JPRB,7.4767E+00_JPRB,1.2832E+01_JPRB,1.7460E+01_JPRB,2.0692E+01_JPRB/)
KBO( :, 5,44,12) = (/&
&2.9738E+00_JPRB,2.9723E+00_JPRB,7.4066E+00_JPRB,1.2450E+01_JPRB,1.6925E+01_JPRB,2.0342E+01_JPRB/)
KBO( :, 1,45,12) = (/&
&1.4392E+00_JPRB,1.4387E+00_JPRB,7.6289E+00_JPRB,1.3769E+01_JPRB,1.8760E+01_JPRB,2.0935E+01_JPRB/)
KBO( :, 2,45,12) = (/&
&1.7286E+00_JPRB,1.7279E+00_JPRB,7.5921E+00_JPRB,1.3574E+01_JPRB,1.8509E+01_JPRB,2.1105E+01_JPRB/)
KBO( :, 3,45,12) = (/&
&2.0581E+00_JPRB,2.0572E+00_JPRB,7.5558E+00_JPRB,1.3307E+01_JPRB,1.8131E+01_JPRB,2.1101E+01_JPRB/)
KBO( :, 4,45,12) = (/&
&2.4180E+00_JPRB,2.4169E+00_JPRB,7.5062E+00_JPRB,1.2976E+01_JPRB,1.7672E+01_JPRB,2.0953E+01_JPRB/)
KBO( :, 5,45,12) = (/&
&2.8084E+00_JPRB,2.8070E+00_JPRB,7.4420E+00_JPRB,1.2604E+01_JPRB,1.7149E+01_JPRB,2.0640E+01_JPRB/)
KBO( :, 1,46,12) = (/&
&1.3097E+00_JPRB,1.3093E+00_JPRB,7.6423E+00_JPRB,1.3829E+01_JPRB,1.8849E+01_JPRB,2.0974E+01_JPRB/)
KBO( :, 2,46,12) = (/&
&1.5854E+00_JPRB,1.5848E+00_JPRB,7.6098E+00_JPRB,1.3672E+01_JPRB,1.8651E+01_JPRB,2.1212E+01_JPRB/)
KBO( :, 3,46,12) = (/&
&1.9071E+00_JPRB,1.9063E+00_JPRB,7.5745E+00_JPRB,1.3430E+01_JPRB,1.8314E+01_JPRB,2.1300E+01_JPRB/)
KBO( :, 4,46,12) = (/&
&2.2598E+00_JPRB,2.2588E+00_JPRB,7.5350E+00_JPRB,1.3119E+01_JPRB,1.7880E+01_JPRB,2.1201E+01_JPRB/)
KBO( :, 5,46,12) = (/&
&2.6412E+00_JPRB,2.6399E+00_JPRB,7.4731E+00_JPRB,1.2761E+01_JPRB,1.7374E+01_JPRB,2.0932E+01_JPRB/)
KBO( :, 1,47,12) = (/&
&1.1830E+00_JPRB,1.1826E+00_JPRB,7.6481E+00_JPRB,1.3869E+01_JPRB,1.8908E+01_JPRB,2.0951E+01_JPRB/)
KBO( :, 2,47,12) = (/&
&1.4407E+00_JPRB,1.4402E+00_JPRB,7.6261E+00_JPRB,1.3765E+01_JPRB,1.8775E+01_JPRB,2.1251E+01_JPRB/)
KBO( :, 3,47,12) = (/&
&1.7493E+00_JPRB,1.7485E+00_JPRB,7.5928E+00_JPRB,1.3553E+01_JPRB,1.8492E+01_JPRB,2.1457E+01_JPRB/)
KBO( :, 4,47,12) = (/&
&2.0941E+00_JPRB,2.0931E+00_JPRB,7.5591E+00_JPRB,1.3267E+01_JPRB,1.8091E+01_JPRB,2.1416E+01_JPRB/)
KBO( :, 5,47,12) = (/&
&2.4666E+00_JPRB,2.4654E+00_JPRB,7.5056E+00_JPRB,1.2925E+01_JPRB,1.7610E+01_JPRB,2.1209E+01_JPRB/)
KBO( :, 1,48,12) = (/&
&1.0695E+00_JPRB,1.0692E+00_JPRB,7.6498E+00_JPRB,1.3881E+01_JPRB,1.8927E+01_JPRB,2.0896E+01_JPRB/)
KBO( :, 2,48,12) = (/&
&1.3081E+00_JPRB,1.3076E+00_JPRB,7.6404E+00_JPRB,1.3836E+01_JPRB,1.8873E+01_JPRB,2.1276E+01_JPRB/)
KBO( :, 3,48,12) = (/&
&1.6006E+00_JPRB,1.5999E+00_JPRB,7.6097E+00_JPRB,1.3659E+01_JPRB,1.8647E+01_JPRB,2.1600E+01_JPRB/)
KBO( :, 4,48,12) = (/&
&1.9354E+00_JPRB,1.9345E+00_JPRB,7.5773E+00_JPRB,1.3403E+01_JPRB,1.8286E+01_JPRB,2.1634E+01_JPRB/)
KBO( :, 5,48,12) = (/&
&2.2984E+00_JPRB,2.2973E+00_JPRB,7.5353E+00_JPRB,1.3082E+01_JPRB,1.7836E+01_JPRB,2.1486E+01_JPRB/)
KBO( :, 1,49,12) = (/&
&9.6483E-01_JPRB,9.6464E-01_JPRB,7.6392E+00_JPRB,1.3864E+01_JPRB,1.8901E+01_JPRB,2.0809E+01_JPRB/)
KBO( :, 2,49,12) = (/&
&1.1880E+00_JPRB,1.1876E+00_JPRB,7.6494E+00_JPRB,1.3882E+01_JPRB,1.8939E+01_JPRB,2.1303E+01_JPRB/)
KBO( :, 3,49,12) = (/&
&1.4610E+00_JPRB,1.4604E+00_JPRB,7.6246E+00_JPRB,1.3753E+01_JPRB,1.8773E+01_JPRB,2.1746E+01_JPRB/)
KBO( :, 4,49,12) = (/&
&1.7825E+00_JPRB,1.7817E+00_JPRB,7.5952E+00_JPRB,1.3527E+01_JPRB,1.8464E+01_JPRB,2.1864E+01_JPRB/)
KBO( :, 5,49,12) = (/&
&2.1366E+00_JPRB,2.1357E+00_JPRB,7.5591E+00_JPRB,1.3229E+01_JPRB,1.8046E+01_JPRB,2.1779E+01_JPRB/)
KBO( :, 1,50,12) = (/&
&8.7334E-01_JPRB,8.7321E-01_JPRB,7.6167E+00_JPRB,1.3816E+01_JPRB,1.8840E+01_JPRB,2.0653E+01_JPRB/)
KBO( :, 2,50,12) = (/&
&1.0849E+00_JPRB,1.0846E+00_JPRB,7.6499E+00_JPRB,1.3902E+01_JPRB,1.8966E+01_JPRB,2.1256E+01_JPRB/)
KBO( :, 3,50,12) = (/&
&1.3397E+00_JPRB,1.3393E+00_JPRB,7.6369E+00_JPRB,1.3826E+01_JPRB,1.8870E+01_JPRB,2.1793E+01_JPRB/)
KBO( :, 4,50,12) = (/&
&1.6451E+00_JPRB,1.6444E+00_JPRB,7.6078E+00_JPRB,1.3629E+01_JPRB,1.8612E+01_JPRB,2.2015E+01_JPRB/)
KBO( :, 5,50,12) = (/&
&1.9901E+00_JPRB,1.9893E+00_JPRB,7.5766E+00_JPRB,1.3357E+01_JPRB,1.8227E+01_JPRB,2.2000E+01_JPRB/)
KBO( :, 1,51,12) = (/&
&7.9109E-01_JPRB,7.9101E-01_JPRB,7.5808E+00_JPRB,1.3738E+01_JPRB,1.8738E+01_JPRB,2.0437E+01_JPRB/)
KBO( :, 2,51,12) = (/&
&9.9151E-01_JPRB,9.9125E-01_JPRB,7.6471E+00_JPRB,1.3897E+01_JPRB,1.8959E+01_JPRB,2.1160E+01_JPRB/)
KBO( :, 3,51,12) = (/&
&1.2299E+00_JPRB,1.2295E+00_JPRB,7.6471E+00_JPRB,1.3876E+01_JPRB,1.8940E+01_JPRB,2.1766E+01_JPRB/)
KBO( :, 4,51,12) = (/&
&1.5182E+00_JPRB,1.5176E+00_JPRB,7.6211E+00_JPRB,1.3717E+01_JPRB,1.8736E+01_JPRB,2.2115E+01_JPRB/)
KBO( :, 5,51,12) = (/&
&1.8518E+00_JPRB,1.8510E+00_JPRB,7.5920E+00_JPRB,1.3472E+01_JPRB,1.8393E+01_JPRB,2.2169E+01_JPRB/)
KBO( :, 1,52,12) = (/&
&7.1584E-01_JPRB,7.1581E-01_JPRB,7.5315E+00_JPRB,1.3629E+01_JPRB,1.8592E+01_JPRB,2.0184E+01_JPRB/)
KBO( :, 2,52,12) = (/&
&9.0437E-01_JPRB,9.0419E-01_JPRB,7.6323E+00_JPRB,1.3867E+01_JPRB,1.8918E+01_JPRB,2.1052E+01_JPRB/)
KBO( :, 3,52,12) = (/&
&1.1294E+00_JPRB,1.1290E+00_JPRB,7.6500E+00_JPRB,1.3907E+01_JPRB,1.8982E+01_JPRB,2.1738E+01_JPRB/)
KBO( :, 4,52,12) = (/&
&1.3999E+00_JPRB,1.3994E+00_JPRB,7.6316E+00_JPRB,1.3795E+01_JPRB,1.8838E+01_JPRB,2.2212E+01_JPRB/)
KBO( :, 5,52,12) = (/&
&1.7187E+00_JPRB,1.7179E+00_JPRB,7.6040E+00_JPRB,1.3576E+01_JPRB,1.8542E+01_JPRB,2.2347E+01_JPRB/)
KBO( :, 1,53,12) = (/&
&6.4519E-01_JPRB,6.4525E-01_JPRB,7.4665E+00_JPRB,1.3494E+01_JPRB,1.8401E+01_JPRB,1.9906E+01_JPRB/)
KBO( :, 2,53,12) = (/&
&8.2291E-01_JPRB,8.2276E-01_JPRB,7.6064E+00_JPRB,1.3809E+01_JPRB,1.8841E+01_JPRB,2.0928E+01_JPRB/)
KBO( :, 3,53,12) = (/&
&1.0366E+00_JPRB,1.0363E+00_JPRB,7.6500E+00_JPRB,1.3915E+01_JPRB,1.8993E+01_JPRB,2.1723E+01_JPRB/)
KBO( :, 4,53,12) = (/&
&1.2893E+00_JPRB,1.2888E+00_JPRB,7.6422E+00_JPRB,1.3856E+01_JPRB,1.8918E+01_JPRB,2.2328E+01_JPRB/)
KBO( :, 5,53,12) = (/&
&1.5912E+00_JPRB,1.5905E+00_JPRB,7.6165E+00_JPRB,1.3669E+01_JPRB,1.8674E+01_JPRB,2.2548E+01_JPRB/)
KBO( :, 1,54,12) = (/&
&5.8435E-01_JPRB,5.8444E-01_JPRB,7.3907E+00_JPRB,1.3327E+01_JPRB,1.8178E+01_JPRB,1.9515E+01_JPRB/)
KBO( :, 2,54,12) = (/&
&7.5368E-01_JPRB,7.5356E-01_JPRB,7.5705E+00_JPRB,1.3729E+01_JPRB,1.8734E+01_JPRB,2.0634E+01_JPRB/)
KBO( :, 3,54,12) = (/&
&9.5607E-01_JPRB,9.5580E-01_JPRB,7.6449E+00_JPRB,1.3905E+01_JPRB,1.8977E+01_JPRB,2.1497E+01_JPRB/)
KBO( :, 4,54,12) = (/&
&1.1937E+00_JPRB,1.1933E+00_JPRB,7.6499E+00_JPRB,1.3896E+01_JPRB,1.8973E+01_JPRB,2.2212E+01_JPRB/)
KBO( :, 5,54,12) = (/&
&1.4797E+00_JPRB,1.4791E+00_JPRB,7.6261E+00_JPRB,1.3745E+01_JPRB,1.8779E+01_JPRB,2.2527E+01_JPRB/)
KBO( :, 1,55,12) = (/&
&5.2854E-01_JPRB,5.2867E-01_JPRB,7.3044E+00_JPRB,1.3131E+01_JPRB,1.7924E+01_JPRB,1.9047E+01_JPRB/)
KBO( :, 2,55,12) = (/&
&6.9118E-01_JPRB,6.9109E-01_JPRB,7.5254E+00_JPRB,1.3628E+01_JPRB,1.8597E+01_JPRB,2.0249E+01_JPRB/)
KBO( :, 3,55,12) = (/&
&8.8293E-01_JPRB,8.8272E-01_JPRB,7.6307E+00_JPRB,1.3873E+01_JPRB,1.8933E+01_JPRB,2.1158E+01_JPRB/)
KBO( :, 4,55,12) = (/&
&1.1091E+00_JPRB,1.1087E+00_JPRB,7.6507E+00_JPRB,1.3919E+01_JPRB,1.9002E+01_JPRB,2.1900E+01_JPRB/)
KBO( :, 5,55,12) = (/&
&1.3791E+00_JPRB,1.3786E+00_JPRB,7.6348E+00_JPRB,1.3810E+01_JPRB,1.8863E+01_JPRB,2.2367E+01_JPRB/)
KBO( :, 1,56,12) = (/&
&4.7560E-01_JPRB,4.7583E-01_JPRB,7.2007E+00_JPRB,1.2908E+01_JPRB,1.7624E+01_JPRB,1.8559E+01_JPRB/)
KBO( :, 2,56,12) = (/&
&6.3205E-01_JPRB,6.3206E-01_JPRB,7.4679E+00_JPRB,1.3507E+01_JPRB,1.8426E+01_JPRB,1.9860E+01_JPRB/)
KBO( :, 3,56,12) = (/&
&8.1360E-01_JPRB,8.1344E-01_JPRB,7.6074E+00_JPRB,1.3821E+01_JPRB,1.8863E+01_JPRB,2.0825E+01_JPRB/)
KBO( :, 4,56,12) = (/&
&1.0301E+00_JPRB,1.0298E+00_JPRB,7.6506E+00_JPRB,1.3924E+01_JPRB,1.9011E+01_JPRB,2.1557E+01_JPRB/)
KBO( :, 5,56,12) = (/&
&1.2841E+00_JPRB,1.2836E+00_JPRB,7.6437E+00_JPRB,1.3864E+01_JPRB,1.8933E+01_JPRB,2.2162E+01_JPRB/)
KBO( :, 1,57,12) = (/&
&4.2603E-01_JPRB,4.2637E-01_JPRB,7.0800E+00_JPRB,1.2651E+01_JPRB,1.7279E+01_JPRB,1.8044E+01_JPRB/)
KBO( :, 2,57,12) = (/&
&5.7620E-01_JPRB,5.7623E-01_JPRB,7.3960E+00_JPRB,1.3349E+01_JPRB,1.8215E+01_JPRB,1.9448E+01_JPRB/)
KBO( :, 3,57,12) = (/&
&7.4950E-01_JPRB,7.4937E-01_JPRB,7.5736E+00_JPRB,1.3745E+01_JPRB,1.8761E+01_JPRB,2.0480E+01_JPRB/)
KBO( :, 4,57,12) = (/&
&9.5476E-01_JPRB,9.5448E-01_JPRB,7.6455E+00_JPRB,1.3913E+01_JPRB,1.8993E+01_JPRB,2.1239E+01_JPRB/)
KBO( :, 5,57,12) = (/&
&1.1947E+00_JPRB,1.1943E+00_JPRB,7.6507E+00_JPRB,1.3900E+01_JPRB,1.8982E+01_JPRB,2.1879E+01_JPRB/)
KBO( :, 1,58,12) = (/&
&3.8222E-01_JPRB,3.8258E-01_JPRB,6.9487E+00_JPRB,1.2376E+01_JPRB,1.6911E+01_JPRB,1.7525E+01_JPRB/)
KBO( :, 2,58,12) = (/&
&5.2528E-01_JPRB,5.2538E-01_JPRB,7.3177E+00_JPRB,1.3169E+01_JPRB,1.7977E+01_JPRB,1.9013E+01_JPRB/)
KBO( :, 3,58,12) = (/&
&6.9186E-01_JPRB,6.9176E-01_JPRB,7.5326E+00_JPRB,1.3651E+01_JPRB,1.8633E+01_JPRB,2.0139E+01_JPRB/)
KBO( :, 4,58,12) = (/&
&8.8662E-01_JPRB,8.8639E-01_JPRB,7.6334E+00_JPRB,1.3885E+01_JPRB,1.8953E+01_JPRB,2.0942E+01_JPRB/)
KBO( :, 5,58,12) = (/&
&1.1152E+00_JPRB,1.1149E+00_JPRB,7.6513E+00_JPRB,1.3923E+01_JPRB,1.9012E+01_JPRB,2.1525E+01_JPRB/)
KBO( :, 1,59,12) = (/&
&3.6401E-01_JPRB,3.6437E-01_JPRB,6.8886E+00_JPRB,1.2256E+01_JPRB,1.6751E+01_JPRB,1.7277E+01_JPRB/)
KBO( :, 2,59,12) = (/&
&5.0412E-01_JPRB,5.0423E-01_JPRB,7.2807E+00_JPRB,1.3088E+01_JPRB,1.7871E+01_JPRB,1.8767E+01_JPRB/)
KBO( :, 3,59,12) = (/&
&6.6841E-01_JPRB,6.6833E-01_JPRB,7.5138E+00_JPRB,1.3610E+01_JPRB,1.8575E+01_JPRB,1.9865E+01_JPRB/)
KBO( :, 4,59,12) = (/&
&8.5925E-01_JPRB,8.5905E-01_JPRB,7.6263E+00_JPRB,1.3870E+01_JPRB,1.8932E+01_JPRB,2.0637E+01_JPRB/)
KBO( :, 5,59,12) = (/&
&1.0843E+00_JPRB,1.0840E+00_JPRB,7.6509E+00_JPRB,1.3928E+01_JPRB,1.9019E+01_JPRB,2.1126E+01_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB4_B3
