!OCL SCALAR
SUBROUTINE RRTM_KGB4_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO4 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO
USE YOERRTA4 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 9 and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 9 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15,
!     JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&6.6520E-04_JPRB,9.3651E-04_JPRB,1.4195E-03_JPRB,1.7255E-03_JPRB,1.7636E-03_JPRB,1.9179E-03_JPRB,&
&2.2204E-03_JPRB,6.6521E-04_JPRB,2.9560E-04_JPRB/)
KAO( :, 2, 1, 1) = (/&
&7.2624E-04_JPRB,1.0466E-03_JPRB,1.3888E-03_JPRB,1.7096E-03_JPRB,1.7897E-03_JPRB,1.8561E-03_JPRB,&
&2.1300E-03_JPRB,7.2624E-04_JPRB,3.1103E-04_JPRB/)
KAO( :, 3, 1, 1) = (/&
&7.8383E-04_JPRB,1.1584E-03_JPRB,1.4071E-03_JPRB,1.6420E-03_JPRB,1.7160E-03_JPRB,1.8518E-03_JPRB,&
&1.8802E-03_JPRB,7.8382E-04_JPRB,3.3914E-04_JPRB/)
KAO( :, 4, 1, 1) = (/&
&8.3828E-04_JPRB,1.2570E-03_JPRB,1.4277E-03_JPRB,1.5406E-03_JPRB,1.6601E-03_JPRB,1.7661E-03_JPRB,&
&1.9135E-03_JPRB,8.3828E-04_JPRB,3.4976E-04_JPRB/)
KAO( :, 5, 1, 1) = (/&
&8.9042E-04_JPRB,1.3363E-03_JPRB,1.4623E-03_JPRB,1.4949E-03_JPRB,1.5948E-03_JPRB,1.7209E-03_JPRB,&
&1.8800E-03_JPRB,8.9042E-04_JPRB,3.6339E-04_JPRB/)
KAO( :, 1, 2, 1) = (/&
&5.6062E-04_JPRB,7.7127E-04_JPRB,1.2084E-03_JPRB,1.4307E-03_JPRB,1.4610E-03_JPRB,1.6052E-03_JPRB,&
&1.8465E-03_JPRB,5.6064E-04_JPRB,2.2622E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&6.1375E-04_JPRB,8.6380E-04_JPRB,1.1701E-03_JPRB,1.4336E-03_JPRB,1.4895E-03_JPRB,1.5756E-03_JPRB,&
&1.7789E-03_JPRB,6.1375E-04_JPRB,2.4137E-04_JPRB/)
KAO( :, 3, 2, 1) = (/&
&6.6443E-04_JPRB,9.5953E-04_JPRB,1.1781E-03_JPRB,1.4158E-03_JPRB,1.4693E-03_JPRB,1.5606E-03_JPRB,&
&1.5694E-03_JPRB,6.6443E-04_JPRB,2.6320E-04_JPRB/)
KAO( :, 4, 2, 1) = (/&
&7.1315E-04_JPRB,1.0478E-03_JPRB,1.1975E-03_JPRB,1.3128E-03_JPRB,1.4207E-03_JPRB,1.5299E-03_JPRB,&
&1.6204E-03_JPRB,7.1315E-04_JPRB,2.6697E-04_JPRB/)
KAO( :, 5, 2, 1) = (/&
&7.6110E-04_JPRB,1.1196E-03_JPRB,1.2294E-03_JPRB,1.2636E-03_JPRB,1.3416E-03_JPRB,1.4292E-03_JPRB,&
&1.6103E-03_JPRB,7.6110E-04_JPRB,2.8176E-04_JPRB/)
KAO( :, 1, 3, 1) = (/&
&4.5610E-04_JPRB,6.1532E-04_JPRB,1.0634E-03_JPRB,1.1828E-03_JPRB,1.2321E-03_JPRB,1.3407E-03_JPRB,&
&1.5585E-03_JPRB,4.5610E-04_JPRB,1.7188E-04_JPRB/)
KAO( :, 2, 3, 1) = (/&
&5.0238E-04_JPRB,6.9021E-04_JPRB,9.8179E-04_JPRB,1.2124E-03_JPRB,1.2375E-03_JPRB,1.3359E-03_JPRB,&
&1.5396E-03_JPRB,5.0238E-04_JPRB,1.8492E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&5.4735E-04_JPRB,7.7249E-04_JPRB,9.8402E-04_JPRB,1.2068E-03_JPRB,1.2546E-03_JPRB,1.2975E-03_JPRB,&
&1.4283E-03_JPRB,5.4735E-04_JPRB,1.9939E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&5.9112E-04_JPRB,8.5275E-04_JPRB,9.9833E-04_JPRB,1.1432E-03_JPRB,1.2143E-03_JPRB,1.3053E-03_JPRB,&
&1.3316E-03_JPRB,5.9111E-04_JPRB,2.0334E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&6.3422E-04_JPRB,9.1933E-04_JPRB,1.0199E-03_JPRB,1.0852E-03_JPRB,1.1540E-03_JPRB,1.2145E-03_JPRB,&
&1.3760E-03_JPRB,6.3422E-04_JPRB,2.1583E-04_JPRB/)
KAO( :, 1, 4, 1) = (/&
&3.6423E-04_JPRB,4.8714E-04_JPRB,9.4139E-04_JPRB,9.6507E-04_JPRB,9.9104E-04_JPRB,1.0740E-03_JPRB,&
&1.2797E-03_JPRB,3.6423E-04_JPRB,1.3905E-04_JPRB/)
KAO( :, 2, 4, 1) = (/&
&4.0448E-04_JPRB,5.4353E-04_JPRB,8.4041E-04_JPRB,9.9900E-04_JPRB,1.0270E-03_JPRB,1.1129E-03_JPRB,&
&1.2594E-03_JPRB,4.0448E-04_JPRB,1.4875E-04_JPRB/)
KAO( :, 3, 4, 1) = (/&
&4.4401E-04_JPRB,6.1201E-04_JPRB,8.1748E-04_JPRB,1.0205E-03_JPRB,1.0406E-03_JPRB,1.0943E-03_JPRB,&
&1.2249E-03_JPRB,4.4401E-04_JPRB,1.5559E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&4.8291E-04_JPRB,6.8107E-04_JPRB,8.2218E-04_JPRB,9.9576E-04_JPRB,1.0515E-03_JPRB,1.1006E-03_JPRB,&
&1.1252E-03_JPRB,4.8291E-04_JPRB,1.6190E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&5.2123E-04_JPRB,7.4343E-04_JPRB,8.4151E-04_JPRB,9.3019E-04_JPRB,1.0130E-03_JPRB,1.0785E-03_JPRB,&
&1.1439E-03_JPRB,5.2123E-04_JPRB,1.7165E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&2.8763E-04_JPRB,3.8654E-04_JPRB,7.7838E-04_JPRB,7.8467E-04_JPRB,8.0817E-04_JPRB,8.9938E-04_JPRB,&
&1.0676E-03_JPRB,2.8763E-04_JPRB,1.2485E-04_JPRB/)
KAO( :, 2, 5, 1) = (/&
&3.2269E-04_JPRB,4.2830E-04_JPRB,7.4590E-04_JPRB,8.1887E-04_JPRB,8.5674E-04_JPRB,9.1744E-04_JPRB,&
&1.0598E-03_JPRB,3.2269E-04_JPRB,1.2888E-04_JPRB/)
KAO( :, 3, 5, 1) = (/&
&3.5710E-04_JPRB,4.8150E-04_JPRB,6.8301E-04_JPRB,8.4014E-04_JPRB,8.5447E-04_JPRB,9.4082E-04_JPRB,&
&1.0595E-03_JPRB,3.5710E-04_JPRB,1.3287E-04_JPRB/)
KAO( :, 4, 5, 1) = (/&
&3.9114E-04_JPRB,5.4044E-04_JPRB,6.7913E-04_JPRB,8.5598E-04_JPRB,8.6451E-04_JPRB,8.9768E-04_JPRB,&
&1.0160E-03_JPRB,3.9114E-04_JPRB,1.3801E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&4.2493E-04_JPRB,5.9616E-04_JPRB,6.9081E-04_JPRB,8.1432E-04_JPRB,8.7086E-04_JPRB,9.0230E-04_JPRB,&
&9.2751E-04_JPRB,4.2493E-04_JPRB,1.4524E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&2.2397E-04_JPRB,3.0352E-04_JPRB,6.2893E-04_JPRB,6.2633E-04_JPRB,6.5793E-04_JPRB,7.3403E-04_JPRB,&
&8.4350E-04_JPRB,2.2397E-04_JPRB,1.2107E-04_JPRB/)
KAO( :, 2, 6, 1) = (/&
&2.5420E-04_JPRB,3.3557E-04_JPRB,6.5797E-04_JPRB,6.6891E-04_JPRB,6.8491E-04_JPRB,7.4023E-04_JPRB,&
&8.5687E-04_JPRB,2.5420E-04_JPRB,1.2280E-04_JPRB/)
KAO( :, 3, 6, 1) = (/&
&2.8396E-04_JPRB,3.7655E-04_JPRB,5.9102E-04_JPRB,6.9033E-04_JPRB,7.1783E-04_JPRB,7.6667E-04_JPRB,&
&8.6376E-04_JPRB,2.8396E-04_JPRB,1.2577E-04_JPRB/)
KAO( :, 4, 6, 1) = (/&
&3.1350E-04_JPRB,4.2404E-04_JPRB,5.6109E-04_JPRB,7.1632E-04_JPRB,7.2169E-04_JPRB,7.5902E-04_JPRB,&
&8.5063E-04_JPRB,3.1350E-04_JPRB,1.3038E-04_JPRB/)
KAO( :, 5, 6, 1) = (/&
&3.4283E-04_JPRB,4.7259E-04_JPRB,5.6315E-04_JPRB,6.9669E-04_JPRB,7.3767E-04_JPRB,7.6266E-04_JPRB,&
&8.1179E-04_JPRB,3.4283E-04_JPRB,1.3594E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&1.7269E-04_JPRB,2.3971E-04_JPRB,5.0297E-04_JPRB,4.9860E-04_JPRB,5.2471E-04_JPRB,5.7932E-04_JPRB,&
&6.8439E-04_JPRB,1.7269E-04_JPRB,1.2386E-04_JPRB/)
KAO( :, 2, 7, 1) = (/&
&1.9843E-04_JPRB,2.6259E-04_JPRB,5.3532E-04_JPRB,5.3729E-04_JPRB,5.5606E-04_JPRB,6.0939E-04_JPRB,&
&7.1230E-04_JPRB,1.9843E-04_JPRB,1.2615E-04_JPRB/)
KAO( :, 3, 7, 1) = (/&
&2.2393E-04_JPRB,2.9362E-04_JPRB,5.3350E-04_JPRB,5.6384E-04_JPRB,5.8750E-04_JPRB,6.2580E-04_JPRB,&
&7.2255E-04_JPRB,2.2393E-04_JPRB,1.3021E-04_JPRB/)
KAO( :, 4, 7, 1) = (/&
&2.4925E-04_JPRB,3.3156E-04_JPRB,4.6934E-04_JPRB,5.8250E-04_JPRB,5.9359E-04_JPRB,6.5453E-04_JPRB,&
&7.2305E-04_JPRB,2.4925E-04_JPRB,1.3523E-04_JPRB/)
KAO( :, 5, 7, 1) = (/&
&2.7472E-04_JPRB,3.7184E-04_JPRB,4.6283E-04_JPRB,5.9977E-04_JPRB,6.0303E-04_JPRB,6.2094E-04_JPRB,&
&7.0629E-04_JPRB,2.7472E-04_JPRB,1.4126E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.3221E-04_JPRB,1.9199E-04_JPRB,3.9770E-04_JPRB,3.9939E-04_JPRB,4.1807E-04_JPRB,4.5731E-04_JPRB,&
&5.2988E-04_JPRB,1.3221E-04_JPRB,1.4509E-04_JPRB/)
KAO( :, 2, 8, 1) = (/&
&1.5393E-04_JPRB,2.0559E-04_JPRB,4.3250E-04_JPRB,4.2908E-04_JPRB,4.4968E-04_JPRB,4.9581E-04_JPRB,&
&5.6885E-04_JPRB,1.5393E-04_JPRB,1.5038E-04_JPRB/)
KAO( :, 3, 8, 1) = (/&
&1.7558E-04_JPRB,2.2912E-04_JPRB,4.5525E-04_JPRB,4.5996E-04_JPRB,4.7140E-04_JPRB,5.1385E-04_JPRB,&
&5.9033E-04_JPRB,1.7558E-04_JPRB,1.5764E-04_JPRB/)
KAO( :, 4, 8, 1) = (/&
&1.9711E-04_JPRB,2.5824E-04_JPRB,4.0990E-04_JPRB,4.7600E-04_JPRB,4.9383E-04_JPRB,5.2727E-04_JPRB,&
&5.9173E-04_JPRB,1.9711E-04_JPRB,1.6674E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&2.1892E-04_JPRB,2.9157E-04_JPRB,3.8268E-04_JPRB,4.9451E-04_JPRB,4.9883E-04_JPRB,5.2700E-04_JPRB,&
&5.9438E-04_JPRB,2.1892E-04_JPRB,1.7746E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.0035E-04_JPRB,1.5952E-04_JPRB,3.1293E-04_JPRB,3.1348E-04_JPRB,3.2666E-04_JPRB,3.7028E-04_JPRB,&
&4.1425E-04_JPRB,1.0035E-04_JPRB,2.6669E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.1858E-04_JPRB,1.6346E-04_JPRB,3.4529E-04_JPRB,3.4165E-04_JPRB,3.5657E-04_JPRB,3.9289E-04_JPRB,&
&4.5949E-04_JPRB,1.1858E-04_JPRB,2.9076E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&1.3693E-04_JPRB,1.7866E-04_JPRB,3.6700E-04_JPRB,3.7083E-04_JPRB,3.8336E-04_JPRB,4.1668E-04_JPRB,&
&4.8180E-04_JPRB,1.3693E-04_JPRB,3.1567E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&1.5518E-04_JPRB,2.0111E-04_JPRB,3.6635E-04_JPRB,3.8855E-04_JPRB,4.0471E-04_JPRB,4.3043E-04_JPRB,&
&4.9285E-04_JPRB,1.5518E-04_JPRB,3.4209E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&1.7362E-04_JPRB,2.2754E-04_JPRB,3.2201E-04_JPRB,4.0291E-04_JPRB,4.1258E-04_JPRB,4.4913E-04_JPRB,&
&4.9613E-04_JPRB,1.7362E-04_JPRB,3.6921E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&7.6756E-05_JPRB,1.3962E-04_JPRB,2.4767E-04_JPRB,2.4912E-04_JPRB,2.5968E-04_JPRB,2.8653E-04_JPRB,&
&3.2992E-04_JPRB,7.6756E-05_JPRB,9.2332E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&9.1972E-05_JPRB,1.3177E-04_JPRB,2.7498E-04_JPRB,2.7460E-04_JPRB,2.8768E-04_JPRB,3.1486E-04_JPRB,&
&3.6117E-04_JPRB,9.1972E-05_JPRB,1.0290E-03_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.0747E-04_JPRB,1.4129E-04_JPRB,2.9762E-04_JPRB,2.9728E-04_JPRB,3.1080E-04_JPRB,3.3927E-04_JPRB,&
&3.8542E-04_JPRB,1.0747E-04_JPRB,1.1258E-03_JPRB/)
KAO( :, 4,10, 1) = (/&
&1.2295E-04_JPRB,1.5843E-04_JPRB,3.0850E-04_JPRB,3.1535E-04_JPRB,3.2529E-04_JPRB,3.5387E-04_JPRB,&
&4.0422E-04_JPRB,1.2295E-04_JPRB,1.2119E-03_JPRB/)
KAO( :, 5,10, 1) = (/&
&1.3850E-04_JPRB,1.7919E-04_JPRB,2.7969E-04_JPRB,3.2918E-04_JPRB,3.4141E-04_JPRB,3.6383E-04_JPRB,&
&4.0592E-04_JPRB,1.3850E-04_JPRB,1.2885E-03_JPRB/)
KAO( :, 1,11, 1) = (/&
&6.4262E-05_JPRB,1.1488E-04_JPRB,2.0652E-04_JPRB,2.0693E-04_JPRB,2.1515E-04_JPRB,2.3759E-04_JPRB,&
&2.7074E-04_JPRB,6.4262E-05_JPRB,1.7436E-03_JPRB/)
KAO( :, 2,11, 1) = (/&
&7.7063E-05_JPRB,1.0910E-04_JPRB,2.2893E-04_JPRB,2.2837E-04_JPRB,2.3880E-04_JPRB,2.5987E-04_JPRB,&
&3.0065E-04_JPRB,7.7062E-05_JPRB,1.9352E-03_JPRB/)
KAO( :, 3,11, 1) = (/&
&9.0126E-05_JPRB,1.1759E-04_JPRB,2.4677E-04_JPRB,2.4752E-04_JPRB,2.5932E-04_JPRB,2.8168E-04_JPRB,&
&3.2064E-04_JPRB,9.0126E-05_JPRB,2.1015E-03_JPRB/)
KAO( :, 4,11, 1) = (/&
&1.0318E-04_JPRB,1.3204E-04_JPRB,2.5349E-04_JPRB,2.6117E-04_JPRB,2.7047E-04_JPRB,2.9445E-04_JPRB,&
&3.3354E-04_JPRB,1.0318E-04_JPRB,2.2375E-03_JPRB/)
KAO( :, 5,11, 1) = (/&
&1.1625E-04_JPRB,1.4979E-04_JPRB,2.3047E-04_JPRB,2.7288E-04_JPRB,2.8316E-04_JPRB,3.0222E-04_JPRB,&
&3.3717E-04_JPRB,1.1625E-04_JPRB,2.3499E-03_JPRB/)
KAO( :, 1,12, 1) = (/&
&5.3838E-05_JPRB,9.4472E-05_JPRB,1.7221E-04_JPRB,1.7229E-04_JPRB,1.7912E-04_JPRB,1.9811E-04_JPRB,&
&2.2298E-04_JPRB,5.3838E-05_JPRB,2.2190E-03_JPRB/)
KAO( :, 2,12, 1) = (/&
&6.4583E-05_JPRB,9.0416E-05_JPRB,1.9070E-04_JPRB,1.8997E-04_JPRB,1.9851E-04_JPRB,2.1621E-04_JPRB,&
&2.4883E-04_JPRB,6.4583E-05_JPRB,2.4508E-03_JPRB/)
KAO( :, 3,12, 1) = (/&
&7.5579E-05_JPRB,9.8146E-05_JPRB,2.0479E-04_JPRB,2.0556E-04_JPRB,2.1508E-04_JPRB,2.3475E-04_JPRB,&
&2.6564E-04_JPRB,7.5579E-05_JPRB,2.6460E-03_JPRB/)
KAO( :, 4,12, 1) = (/&
&8.6531E-05_JPRB,1.1008E-04_JPRB,2.0887E-04_JPRB,2.1630E-04_JPRB,2.2430E-04_JPRB,2.4416E-04_JPRB,&
&2.7688E-04_JPRB,8.6531E-05_JPRB,2.8013E-03_JPRB/)
KAO( :, 5,12, 1) = (/&
&9.7427E-05_JPRB,1.2490E-04_JPRB,1.8859E-04_JPRB,2.2596E-04_JPRB,2.3336E-04_JPRB,2.5057E-04_JPRB,&
&2.7888E-04_JPRB,9.7427E-05_JPRB,2.9236E-03_JPRB/)
KAO( :, 1,13, 1) = (/&
&4.5099E-05_JPRB,7.7513E-05_JPRB,1.4325E-04_JPRB,1.4387E-04_JPRB,1.4900E-04_JPRB,1.6404E-04_JPRB,&
&1.8470E-04_JPRB,4.5100E-05_JPRB,2.3136E-03_JPRB/)
KAO( :, 2,13, 1) = (/&
&5.4137E-05_JPRB,7.5163E-05_JPRB,1.5870E-04_JPRB,1.5797E-04_JPRB,1.6505E-04_JPRB,1.7934E-04_JPRB,&
&2.0687E-04_JPRB,5.4137E-05_JPRB,2.5403E-03_JPRB/)
KAO( :, 3,13, 1) = (/&
&6.3329E-05_JPRB,8.1727E-05_JPRB,1.6965E-04_JPRB,1.7063E-04_JPRB,1.7871E-04_JPRB,1.9512E-04_JPRB,&
&2.2035E-04_JPRB,6.3329E-05_JPRB,2.7282E-03_JPRB/)
KAO( :, 4,13, 1) = (/&
&7.2450E-05_JPRB,9.1778E-05_JPRB,1.7219E-04_JPRB,1.7914E-04_JPRB,1.8635E-04_JPRB,2.0203E-04_JPRB,&
&2.2943E-04_JPRB,7.2450E-05_JPRB,2.8788E-03_JPRB/)
KAO( :, 5,13, 1) = (/&
&8.1530E-05_JPRB,1.0397E-04_JPRB,1.5476E-04_JPRB,1.8739E-04_JPRB,1.9322E-04_JPRB,2.0819E-04_JPRB,&
&2.3071E-04_JPRB,8.1530E-05_JPRB,2.9950E-03_JPRB/)
KAO( :, 1, 1, 2) = (/&
&1.5260E-03_JPRB,1.7595E-03_JPRB,1.6480E-03_JPRB,2.2258E-03_JPRB,2.8344E-03_JPRB,3.1469E-03_JPRB,&
&3.6918E-03_JPRB,1.5260E-03_JPRB,4.9914E-04_JPRB/)
KAO( :, 2, 1, 2) = (/&
&1.5826E-03_JPRB,1.8212E-03_JPRB,1.7561E-03_JPRB,1.9980E-03_JPRB,2.4681E-03_JPRB,2.9684E-03_JPRB,&
&3.2872E-03_JPRB,1.5826E-03_JPRB,4.6415E-04_JPRB/)
KAO( :, 3, 1, 2) = (/&
&1.6227E-03_JPRB,1.8571E-03_JPRB,1.8350E-03_JPRB,1.9032E-03_JPRB,2.3046E-03_JPRB,2.7220E-03_JPRB,&
&3.3030E-03_JPRB,1.6227E-03_JPRB,4.6231E-04_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.6627E-03_JPRB,1.9016E-03_JPRB,1.9450E-03_JPRB,1.9945E-03_JPRB,2.2414E-03_JPRB,2.5327E-03_JPRB,&
&2.8363E-03_JPRB,1.6627E-03_JPRB,4.9516E-04_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.6942E-03_JPRB,1.9567E-03_JPRB,2.0282E-03_JPRB,2.1178E-03_JPRB,2.1837E-03_JPRB,2.3289E-03_JPRB,&
&2.6951E-03_JPRB,1.6942E-03_JPRB,5.5604E-04_JPRB/)
KAO( :, 1, 2, 2) = (/&
&1.2957E-03_JPRB,1.4736E-03_JPRB,1.3696E-03_JPRB,1.9219E-03_JPRB,2.4448E-03_JPRB,2.7185E-03_JPRB,&
&3.0973E-03_JPRB,1.2957E-03_JPRB,3.5777E-04_JPRB/)
KAO( :, 2, 2, 2) = (/&
&1.3520E-03_JPRB,1.5352E-03_JPRB,1.4594E-03_JPRB,1.7363E-03_JPRB,2.1608E-03_JPRB,2.5931E-03_JPRB,&
&2.9477E-03_JPRB,1.3520E-03_JPRB,3.5334E-04_JPRB/)
KAO( :, 3, 2, 2) = (/&
&1.3955E-03_JPRB,1.5728E-03_JPRB,1.5388E-03_JPRB,1.5910E-03_JPRB,1.9652E-03_JPRB,2.3965E-03_JPRB,&
&2.8214E-03_JPRB,1.3955E-03_JPRB,3.5208E-04_JPRB/)
KAO( :, 4, 2, 2) = (/&
&1.4306E-03_JPRB,1.6119E-03_JPRB,1.6289E-03_JPRB,1.6668E-03_JPRB,1.8749E-03_JPRB,2.1515E-03_JPRB,&
&2.5798E-03_JPRB,1.4306E-03_JPRB,3.8903E-04_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.4618E-03_JPRB,1.6648E-03_JPRB,1.7112E-03_JPRB,1.7696E-03_JPRB,1.8658E-03_JPRB,2.0390E-03_JPRB,&
&2.2630E-03_JPRB,1.4618E-03_JPRB,4.3501E-04_JPRB/)
KAO( :, 1, 3, 2) = (/&
&1.0941E-03_JPRB,1.2249E-03_JPRB,1.1110E-03_JPRB,1.6978E-03_JPRB,2.0757E-03_JPRB,2.3977E-03_JPRB,&
&2.5385E-03_JPRB,1.0941E-03_JPRB,2.5435E-04_JPRB/)
KAO( :, 2, 3, 2) = (/&
&1.1496E-03_JPRB,1.2893E-03_JPRB,1.2094E-03_JPRB,1.5400E-03_JPRB,1.9037E-03_JPRB,2.2282E-03_JPRB,&
&2.6108E-03_JPRB,1.1496E-03_JPRB,2.5844E-04_JPRB/)
KAO( :, 3, 3, 2) = (/&
&1.1926E-03_JPRB,1.3278E-03_JPRB,1.2717E-03_JPRB,1.3590E-03_JPRB,1.7088E-03_JPRB,2.1812E-03_JPRB,&
&2.3392E-03_JPRB,1.1926E-03_JPRB,2.6804E-04_JPRB/)
KAO( :, 4, 3, 2) = (/&
&1.2267E-03_JPRB,1.3589E-03_JPRB,1.3473E-03_JPRB,1.3690E-03_JPRB,1.6042E-03_JPRB,1.9290E-03_JPRB,&
&2.3507E-03_JPRB,1.2267E-03_JPRB,3.0065E-04_JPRB/)
KAO( :, 5, 3, 2) = (/&
&1.2554E-03_JPRB,1.4034E-03_JPRB,1.4269E-03_JPRB,1.4462E-03_JPRB,1.5803E-03_JPRB,1.7891E-03_JPRB,&
&1.9934E-03_JPRB,1.2554E-03_JPRB,3.3529E-04_JPRB/)
KAO( :, 1, 4, 2) = (/&
&9.2228E-04_JPRB,1.0144E-03_JPRB,8.9155E-04_JPRB,1.5523E-03_JPRB,1.8182E-03_JPRB,2.0790E-03_JPRB,&
&2.1019E-03_JPRB,9.2229E-04_JPRB,1.9739E-04_JPRB/)
KAO( :, 2, 4, 2) = (/&
&9.7173E-04_JPRB,1.0764E-03_JPRB,9.9094E-04_JPRB,1.3563E-03_JPRB,1.7130E-03_JPRB,1.9182E-03_JPRB,&
&2.1666E-03_JPRB,9.7173E-04_JPRB,1.9900E-04_JPRB/)
KAO( :, 3, 4, 2) = (/&
&1.0138E-03_JPRB,1.1151E-03_JPRB,1.0445E-03_JPRB,1.2251E-03_JPRB,1.5369E-03_JPRB,1.8521E-03_JPRB,&
&2.1013E-03_JPRB,1.0138E-03_JPRB,2.1276E-04_JPRB/)
KAO( :, 4, 4, 2) = (/&
&1.0473E-03_JPRB,1.1460E-03_JPRB,1.1161E-03_JPRB,1.1284E-03_JPRB,1.3578E-03_JPRB,1.6754E-03_JPRB,&
&2.0077E-03_JPRB,1.0473E-03_JPRB,2.3595E-04_JPRB/)
KAO( :, 5, 4, 2) = (/&
&1.0726E-03_JPRB,1.1805E-03_JPRB,1.1814E-03_JPRB,1.1848E-03_JPRB,1.3479E-03_JPRB,1.5615E-03_JPRB,&
&1.8994E-03_JPRB,1.0726E-03_JPRB,2.6165E-04_JPRB/)
KAO( :, 1, 5, 2) = (/&
&7.6690E-04_JPRB,8.2765E-04_JPRB,7.8062E-04_JPRB,1.3867E-03_JPRB,1.5867E-03_JPRB,1.6936E-03_JPRB,&
&1.7521E-03_JPRB,7.6690E-04_JPRB,1.6280E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&8.1285E-04_JPRB,8.8774E-04_JPRB,7.8341E-04_JPRB,1.1988E-03_JPRB,1.4770E-03_JPRB,1.6719E-03_JPRB,&
&1.7693E-03_JPRB,8.1285E-04_JPRB,1.6768E-04_JPRB/)
KAO( :, 3, 5, 2) = (/&
&8.5183E-04_JPRB,9.2930E-04_JPRB,8.6098E-04_JPRB,1.1035E-03_JPRB,1.3517E-03_JPRB,1.5871E-03_JPRB,&
&1.8468E-03_JPRB,8.5182E-04_JPRB,1.7918E-04_JPRB/)
KAO( :, 4, 5, 2) = (/&
&8.8381E-04_JPRB,9.6005E-04_JPRB,9.1547E-04_JPRB,9.4610E-04_JPRB,1.2396E-03_JPRB,1.5757E-03_JPRB,&
&1.6719E-03_JPRB,8.8381E-04_JPRB,1.9528E-04_JPRB/)
KAO( :, 5, 5, 2) = (/&
&9.0780E-04_JPRB,9.9038E-04_JPRB,9.7867E-04_JPRB,9.6385E-04_JPRB,1.1363E-03_JPRB,1.3750E-03_JPRB,&
&1.6759E-03_JPRB,9.0780E-04_JPRB,2.1430E-04_JPRB/)
KAO( :, 1, 6, 2) = (/&
&6.2795E-04_JPRB,6.6838E-04_JPRB,7.3561E-04_JPRB,1.2263E-03_JPRB,1.3683E-03_JPRB,1.4046E-03_JPRB,&
&1.5094E-03_JPRB,6.2795E-04_JPRB,1.5216E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&6.7183E-04_JPRB,7.2288E-04_JPRB,6.1801E-04_JPRB,1.0919E-03_JPRB,1.2712E-03_JPRB,1.4757E-03_JPRB,&
&1.4814E-03_JPRB,6.7183E-04_JPRB,1.5894E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&7.0773E-04_JPRB,7.6513E-04_JPRB,6.8912E-04_JPRB,9.6974E-04_JPRB,1.1945E-03_JPRB,1.3671E-03_JPRB,&
&1.5170E-03_JPRB,7.0773E-04_JPRB,1.6897E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&7.3816E-04_JPRB,7.9782E-04_JPRB,7.4473E-04_JPRB,8.7065E-04_JPRB,1.1028E-03_JPRB,1.3310E-03_JPRB,&
&1.4982E-03_JPRB,7.3816E-04_JPRB,1.8083E-04_JPRB/)
KAO( :, 5, 6, 2) = (/&
&7.6173E-04_JPRB,8.2557E-04_JPRB,8.0696E-04_JPRB,7.9653E-04_JPRB,9.7171E-04_JPRB,1.2001E-03_JPRB,&
&1.4350E-03_JPRB,7.6173E-04_JPRB,1.9544E-04_JPRB/)
KAO( :, 1, 7, 2) = (/&
&5.0891E-04_JPRB,5.3280E-04_JPRB,7.2820E-04_JPRB,1.0600E-03_JPRB,1.1897E-03_JPRB,1.2028E-03_JPRB,&
&1.2645E-03_JPRB,5.0891E-04_JPRB,1.6819E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&5.5019E-04_JPRB,5.8559E-04_JPRB,5.5050E-04_JPRB,9.8189E-04_JPRB,1.1133E-03_JPRB,1.1994E-03_JPRB,&
&1.2177E-03_JPRB,5.5019E-04_JPRB,1.7740E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&5.8438E-04_JPRB,6.2588E-04_JPRB,5.2192E-04_JPRB,8.6875E-04_JPRB,1.0399E-03_JPRB,1.1761E-03_JPRB,&
&1.2214E-03_JPRB,5.8438E-04_JPRB,1.8897E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&6.1239E-04_JPRB,6.5682E-04_JPRB,6.0713E-04_JPRB,7.7808E-04_JPRB,9.7331E-04_JPRB,1.1140E-03_JPRB,&
&1.3014E-03_JPRB,6.1239E-04_JPRB,2.0290E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&6.3467E-04_JPRB,6.8419E-04_JPRB,6.5295E-04_JPRB,6.7554E-04_JPRB,8.8119E-04_JPRB,1.1133E-03_JPRB,&
&1.2053E-03_JPRB,6.3467E-04_JPRB,2.1872E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&4.0935E-04_JPRB,4.1885E-04_JPRB,6.7101E-04_JPRB,9.1256E-04_JPRB,1.0194E-03_JPRB,1.0135E-03_JPRB,&
&1.0819E-03_JPRB,4.0935E-04_JPRB,2.1824E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&4.4692E-04_JPRB,4.7118E-04_JPRB,5.1659E-04_JPRB,8.5913E-04_JPRB,9.6357E-04_JPRB,9.8846E-04_JPRB,&
&1.0429E-03_JPRB,4.4692E-04_JPRB,2.3690E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&4.7903E-04_JPRB,5.0921E-04_JPRB,4.2513E-04_JPRB,7.7866E-04_JPRB,8.9423E-04_JPRB,1.0205E-03_JPRB,&
&1.0213E-03_JPRB,4.7903E-04_JPRB,2.5819E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&5.0519E-04_JPRB,5.3873E-04_JPRB,4.7470E-04_JPRB,6.8242E-04_JPRB,8.4925E-04_JPRB,9.6082E-04_JPRB,&
&1.0565E-03_JPRB,5.0519E-04_JPRB,2.8169E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&5.2646E-04_JPRB,5.6355E-04_JPRB,5.3173E-04_JPRB,6.2134E-04_JPRB,7.8503E-04_JPRB,9.3706E-04_JPRB,&
&1.0322E-03_JPRB,5.2647E-04_JPRB,3.0574E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&3.2639E-04_JPRB,3.2062E-04_JPRB,6.1707E-04_JPRB,7.9540E-04_JPRB,8.4564E-04_JPRB,8.5817E-04_JPRB,&
&9.0723E-04_JPRB,3.2639E-04_JPRB,5.5545E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&3.6012E-04_JPRB,3.7319E-04_JPRB,5.0226E-04_JPRB,7.4254E-04_JPRB,8.4023E-04_JPRB,8.3301E-04_JPRB,&
&8.5728E-04_JPRB,3.6012E-04_JPRB,6.1165E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&3.8987E-04_JPRB,4.1225E-04_JPRB,3.7907E-04_JPRB,6.8530E-04_JPRB,7.7881E-04_JPRB,8.3778E-04_JPRB,&
&8.4817E-04_JPRB,3.8987E-04_JPRB,6.6653E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&4.1424E-04_JPRB,4.3910E-04_JPRB,3.6051E-04_JPRB,6.1000E-04_JPRB,7.2902E-04_JPRB,8.1999E-04_JPRB,&
&8.4396E-04_JPRB,4.1424E-04_JPRB,7.1819E-04_JPRB/)
KAO( :, 5, 9, 2) = (/&
&4.3431E-04_JPRB,4.6239E-04_JPRB,4.2288E-04_JPRB,5.4880E-04_JPRB,6.8867E-04_JPRB,7.7866E-04_JPRB,&
&8.9097E-04_JPRB,4.3431E-04_JPRB,7.7202E-04_JPRB/)
KAO( :, 1,10, 2) = (/&
&2.6062E-04_JPRB,2.4097E-04_JPRB,5.6760E-04_JPRB,6.7838E-04_JPRB,7.0839E-04_JPRB,7.4582E-04_JPRB,&
&7.5583E-04_JPRB,2.6062E-04_JPRB,2.5277E-03_JPRB/)
KAO( :, 2,10, 2) = (/&
&2.9023E-04_JPRB,2.9545E-04_JPRB,4.5173E-04_JPRB,6.2994E-04_JPRB,7.1727E-04_JPRB,7.0001E-04_JPRB,&
&7.3420E-04_JPRB,2.9022E-04_JPRB,2.7784E-03_JPRB/)
KAO( :, 3,10, 2) = (/&
&3.1702E-04_JPRB,3.3294E-04_JPRB,3.4527E-04_JPRB,5.9793E-04_JPRB,6.6774E-04_JPRB,6.9352E-04_JPRB,&
&7.1312E-04_JPRB,3.1702E-04_JPRB,3.0145E-03_JPRB/)
KAO( :, 4,10, 2) = (/&
&3.3919E-04_JPRB,3.5815E-04_JPRB,2.9459E-04_JPRB,5.3609E-04_JPRB,6.2952E-04_JPRB,7.0029E-04_JPRB,&
&6.9972E-04_JPRB,3.3919E-04_JPRB,3.2222E-03_JPRB/)
KAO( :, 5,10, 2) = (/&
&3.5768E-04_JPRB,3.7923E-04_JPRB,3.2874E-04_JPRB,4.7549E-04_JPRB,5.9483E-04_JPRB,6.7311E-04_JPRB,&
&7.3613E-04_JPRB,3.5768E-04_JPRB,3.4035E-03_JPRB/)
KAO( :, 1,11, 2) = (/&
&2.1907E-04_JPRB,2.0328E-04_JPRB,4.6419E-04_JPRB,5.6297E-04_JPRB,5.8907E-04_JPRB,6.1155E-04_JPRB,&
&6.1013E-04_JPRB,2.1907E-04_JPRB,5.1242E-03_JPRB/)
KAO( :, 2,11, 2) = (/&
&2.4410E-04_JPRB,2.4843E-04_JPRB,3.7130E-04_JPRB,5.2284E-04_JPRB,5.9762E-04_JPRB,5.8585E-04_JPRB,&
&6.0135E-04_JPRB,2.4411E-04_JPRB,5.5864E-03_JPRB/)
KAO( :, 3,11, 2) = (/&
&2.6625E-04_JPRB,2.7930E-04_JPRB,2.8189E-04_JPRB,4.9405E-04_JPRB,5.5402E-04_JPRB,5.7720E-04_JPRB,&
&5.8571E-04_JPRB,2.6625E-04_JPRB,6.0066E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&2.8487E-04_JPRB,3.0018E-04_JPRB,2.4472E-04_JPRB,4.4200E-04_JPRB,5.2652E-04_JPRB,5.8248E-04_JPRB,&
&5.7961E-04_JPRB,2.8487E-04_JPRB,6.3763E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&3.0010E-04_JPRB,3.1719E-04_JPRB,2.7311E-04_JPRB,3.9201E-04_JPRB,4.9427E-04_JPRB,5.6306E-04_JPRB,&
&6.1631E-04_JPRB,3.0010E-04_JPRB,6.6804E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&1.8394E-04_JPRB,1.7118E-04_JPRB,3.7730E-04_JPRB,4.6792E-04_JPRB,4.8975E-04_JPRB,4.9917E-04_JPRB,&
&5.0397E-04_JPRB,1.8394E-04_JPRB,6.7953E-03_JPRB/)
KAO( :, 2,12, 2) = (/&
&2.0488E-04_JPRB,2.0891E-04_JPRB,3.0355E-04_JPRB,4.3536E-04_JPRB,4.9195E-04_JPRB,4.8369E-04_JPRB,&
&4.9615E-04_JPRB,2.0488E-04_JPRB,7.3722E-03_JPRB/)
KAO( :, 3,12, 2) = (/&
&2.2338E-04_JPRB,2.3370E-04_JPRB,2.2853E-04_JPRB,4.0848E-04_JPRB,4.6057E-04_JPRB,4.8139E-04_JPRB,&
&4.8293E-04_JPRB,2.2338E-04_JPRB,7.8888E-03_JPRB/)
KAO( :, 4,12, 2) = (/&
&2.3905E-04_JPRB,2.5126E-04_JPRB,2.0156E-04_JPRB,3.6557E-04_JPRB,4.3992E-04_JPRB,4.8195E-04_JPRB,&
&4.8526E-04_JPRB,2.3905E-04_JPRB,8.3181E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&2.5129E-04_JPRB,2.6467E-04_JPRB,2.2905E-04_JPRB,3.2273E-04_JPRB,4.1230E-04_JPRB,4.6630E-04_JPRB,&
&5.1248E-04_JPRB,2.5129E-04_JPRB,8.6386E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&1.5430E-04_JPRB,1.4442E-04_JPRB,3.0805E-04_JPRB,3.8950E-04_JPRB,4.0767E-04_JPRB,4.1179E-04_JPRB,&
&4.1330E-04_JPRB,1.5430E-04_JPRB,7.3053E-03_JPRB/)
KAO( :, 2,13, 2) = (/&
&1.7179E-04_JPRB,1.7510E-04_JPRB,2.4818E-04_JPRB,3.6198E-04_JPRB,4.0625E-04_JPRB,3.9974E-04_JPRB,&
&4.1166E-04_JPRB,1.7179E-04_JPRB,7.9022E-03_JPRB/)
KAO( :, 3,13, 2) = (/&
&1.8741E-04_JPRB,1.9575E-04_JPRB,1.8604E-04_JPRB,3.3670E-04_JPRB,3.8272E-04_JPRB,4.0145E-04_JPRB,&
&4.0060E-04_JPRB,1.8741E-04_JPRB,8.4145E-03_JPRB/)
KAO( :, 4,13, 2) = (/&
&2.0031E-04_JPRB,2.0975E-04_JPRB,1.6656E-04_JPRB,3.0379E-04_JPRB,3.6769E-04_JPRB,4.0078E-04_JPRB,&
&4.0187E-04_JPRB,2.0032E-04_JPRB,8.8018E-03_JPRB/)
KAO( :, 5,13, 2) = (/&
&2.1018E-04_JPRB,2.2076E-04_JPRB,1.9159E-04_JPRB,2.6448E-04_JPRB,3.4432E-04_JPRB,3.8512E-04_JPRB,&
&4.2420E-04_JPRB,2.1018E-04_JPRB,9.0680E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&2.3465E-03_JPRB,2.4031E-03_JPRB,2.2597E-03_JPRB,2.1524E-03_JPRB,2.8276E-03_JPRB,3.5761E-03_JPRB,&
&4.3079E-03_JPRB,2.3465E-03_JPRB,5.1471E-04_JPRB/)
KAO( :, 2, 1, 3) = (/&
&2.3042E-03_JPRB,2.4485E-03_JPRB,2.4199E-03_JPRB,2.2938E-03_JPRB,2.9847E-03_JPRB,3.1952E-03_JPRB,&
&4.1667E-03_JPRB,2.3042E-03_JPRB,6.2319E-04_JPRB/)
KAO( :, 3, 1, 3) = (/&
&2.2700E-03_JPRB,2.4966E-03_JPRB,2.5862E-03_JPRB,2.6511E-03_JPRB,2.8738E-03_JPRB,2.9164E-03_JPRB,&
&3.6118E-03_JPRB,2.2700E-03_JPRB,7.4229E-04_JPRB/)
KAO( :, 4, 1, 3) = (/&
&2.2509E-03_JPRB,2.5573E-03_JPRB,2.7581E-03_JPRB,2.9718E-03_JPRB,3.0657E-03_JPRB,3.3376E-03_JPRB,&
&3.1600E-03_JPRB,2.2509E-03_JPRB,8.5977E-04_JPRB/)
KAO( :, 5, 1, 3) = (/&
&2.2422E-03_JPRB,2.6355E-03_JPRB,2.9552E-03_JPRB,3.2531E-03_JPRB,3.4296E-03_JPRB,3.4558E-03_JPRB,&
&3.2808E-03_JPRB,2.2422E-03_JPRB,9.9766E-04_JPRB/)
KAO( :, 1, 2, 3) = (/&
&2.0157E-03_JPRB,2.0510E-03_JPRB,1.8851E-03_JPRB,1.8206E-03_JPRB,2.4343E-03_JPRB,2.9704E-03_JPRB,&
&3.8311E-03_JPRB,2.0157E-03_JPRB,4.1396E-04_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.9815E-03_JPRB,2.0886E-03_JPRB,2.0439E-03_JPRB,1.8938E-03_JPRB,2.5204E-03_JPRB,2.7128E-03_JPRB,&
&3.3350E-03_JPRB,1.9815E-03_JPRB,4.8039E-04_JPRB/)
KAO( :, 3, 2, 3) = (/&
&1.9576E-03_JPRB,2.1326E-03_JPRB,2.1790E-03_JPRB,2.1795E-03_JPRB,2.4882E-03_JPRB,2.4941E-03_JPRB,&
&3.2109E-03_JPRB,1.9575E-03_JPRB,5.7955E-04_JPRB/)
KAO( :, 4, 2, 3) = (/&
&1.9481E-03_JPRB,2.1829E-03_JPRB,2.3235E-03_JPRB,2.4676E-03_JPRB,2.6097E-03_JPRB,2.8349E-03_JPRB,&
&2.5868E-03_JPRB,1.9481E-03_JPRB,6.6714E-04_JPRB/)
KAO( :, 5, 2, 3) = (/&
&1.9507E-03_JPRB,2.2521E-03_JPRB,2.4912E-03_JPRB,2.7356E-03_JPRB,2.8987E-03_JPRB,2.9418E-03_JPRB,&
&2.7830E-03_JPRB,1.9507E-03_JPRB,7.7523E-04_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.7285E-03_JPRB,1.7377E-03_JPRB,1.5305E-03_JPRB,1.6757E-03_JPRB,2.1680E-03_JPRB,2.5609E-03_JPRB,&
&3.3887E-03_JPRB,1.7285E-03_JPRB,3.2280E-04_JPRB/)
KAO( :, 2, 3, 3) = (/&
&1.7015E-03_JPRB,1.7653E-03_JPRB,1.6878E-03_JPRB,1.5112E-03_JPRB,2.1719E-03_JPRB,2.4083E-03_JPRB,&
&2.8061E-03_JPRB,1.7015E-03_JPRB,3.7412E-04_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.6851E-03_JPRB,1.8101E-03_JPRB,1.8073E-03_JPRB,1.7539E-03_JPRB,2.2398E-03_JPRB,2.1112E-03_JPRB,&
&2.7333E-03_JPRB,1.6851E-03_JPRB,4.3157E-04_JPRB/)
KAO( :, 4, 3, 3) = (/&
&1.6786E-03_JPRB,1.8567E-03_JPRB,1.9291E-03_JPRB,1.9927E-03_JPRB,2.1347E-03_JPRB,2.2693E-03_JPRB,&
&2.2801E-03_JPRB,1.6786E-03_JPRB,5.0448E-04_JPRB/)
KAO( :, 5, 3, 3) = (/&
&1.6877E-03_JPRB,1.9156E-03_JPRB,2.0710E-03_JPRB,2.2420E-03_JPRB,2.3625E-03_JPRB,2.5310E-03_JPRB,&
&2.3182E-03_JPRB,1.6877E-03_JPRB,5.8583E-04_JPRB/)
KAO( :, 1, 4, 3) = (/&
&1.4834E-03_JPRB,1.4711E-03_JPRB,1.2522E-03_JPRB,1.4479E-03_JPRB,1.9854E-03_JPRB,2.2569E-03_JPRB,&
&2.9775E-03_JPRB,1.4834E-03_JPRB,2.5081E-04_JPRB/)
KAO( :, 2, 4, 3) = (/&
&1.4601E-03_JPRB,1.4870E-03_JPRB,1.3690E-03_JPRB,1.2662E-03_JPRB,1.8060E-03_JPRB,2.0826E-03_JPRB,&
&2.4977E-03_JPRB,1.4601E-03_JPRB,2.9277E-04_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.4467E-03_JPRB,1.5271E-03_JPRB,1.4979E-03_JPRB,1.3500E-03_JPRB,1.8497E-03_JPRB,1.9610E-03_JPRB,&
&2.2907E-03_JPRB,1.4467E-03_JPRB,3.3271E-04_JPRB/)
KAO( :, 4, 4, 3) = (/&
&1.4432E-03_JPRB,1.5714E-03_JPRB,1.5969E-03_JPRB,1.5937E-03_JPRB,1.7902E-03_JPRB,1.9320E-03_JPRB,&
&2.2420E-03_JPRB,1.4432E-03_JPRB,3.8467E-04_JPRB/)
KAO( :, 5, 4, 3) = (/&
&1.4550E-03_JPRB,1.6236E-03_JPRB,1.7127E-03_JPRB,1.8068E-03_JPRB,1.8486E-03_JPRB,2.1176E-03_JPRB,&
&1.8018E-03_JPRB,1.4551E-03_JPRB,4.4551E-04_JPRB/)
KAO( :, 1, 5, 3) = (/&
&1.2773E-03_JPRB,1.2497E-03_JPRB,1.0064E-03_JPRB,1.2506E-03_JPRB,1.7352E-03_JPRB,2.1064E-03_JPRB,&
&2.5188E-03_JPRB,1.2773E-03_JPRB,2.1025E-04_JPRB/)
KAO( :, 2, 5, 3) = (/&
&1.2595E-03_JPRB,1.2634E-03_JPRB,1.1147E-03_JPRB,1.1296E-03_JPRB,1.5824E-03_JPRB,1.8075E-03_JPRB,&
&2.2978E-03_JPRB,1.2595E-03_JPRB,2.3601E-04_JPRB/)
KAO( :, 3, 5, 3) = (/&
&1.2471E-03_JPRB,1.2907E-03_JPRB,1.2226E-03_JPRB,1.0559E-03_JPRB,1.5556E-03_JPRB,1.7264E-03_JPRB,&
&1.8319E-03_JPRB,1.2471E-03_JPRB,2.6674E-04_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.2460E-03_JPRB,1.3277E-03_JPRB,1.3232E-03_JPRB,1.2839E-03_JPRB,1.5266E-03_JPRB,1.5639E-03_JPRB,&
&1.9030E-03_JPRB,1.2460E-03_JPRB,3.0491E-04_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.2575E-03_JPRB,1.3721E-03_JPRB,1.4143E-03_JPRB,1.4453E-03_JPRB,1.5006E-03_JPRB,1.7674E-03_JPRB,&
&1.7436E-03_JPRB,1.2575E-03_JPRB,3.5060E-04_JPRB/)
KAO( :, 1, 6, 3) = (/&
&1.0958E-03_JPRB,1.0595E-03_JPRB,7.7664E-04_JPRB,1.1085E-03_JPRB,1.5393E-03_JPRB,1.9338E-03_JPRB,&
&2.1934E-03_JPRB,1.0958E-03_JPRB,1.9645E-04_JPRB/)
KAO( :, 2, 6, 3) = (/&
&1.0816E-03_JPRB,1.0727E-03_JPRB,9.0695E-04_JPRB,1.0023E-03_JPRB,1.4434E-03_JPRB,1.5856E-03_JPRB,&
&2.0291E-03_JPRB,1.0816E-03_JPRB,2.1208E-04_JPRB/)
KAO( :, 3, 6, 3) = (/&
&1.0710E-03_JPRB,1.0888E-03_JPRB,9.9129E-04_JPRB,8.7443E-04_JPRB,1.3179E-03_JPRB,1.5033E-03_JPRB,&
&1.7077E-03_JPRB,1.0710E-03_JPRB,2.3481E-04_JPRB/)
KAO( :, 4, 6, 3) = (/&
&1.0708E-03_JPRB,1.1186E-03_JPRB,1.0874E-03_JPRB,9.5969E-04_JPRB,1.2671E-03_JPRB,1.4010E-03_JPRB,&
&1.5917E-03_JPRB,1.0708E-03_JPRB,2.6339E-04_JPRB/)
KAO( :, 5, 6, 3) = (/&
&1.0806E-03_JPRB,1.1572E-03_JPRB,1.1631E-03_JPRB,1.1545E-03_JPRB,1.2485E-03_JPRB,1.4294E-03_JPRB,&
&1.6004E-03_JPRB,1.0806E-03_JPRB,2.9803E-04_JPRB/)
KAO( :, 1, 7, 3) = (/&
&9.3348E-04_JPRB,8.9092E-04_JPRB,5.7161E-04_JPRB,1.0208E-03_JPRB,1.3784E-03_JPRB,1.7037E-03_JPRB,&
&1.8935E-03_JPRB,9.3348E-04_JPRB,2.1146E-04_JPRB/)
KAO( :, 2, 7, 3) = (/&
&9.2171E-04_JPRB,9.0329E-04_JPRB,7.1477E-04_JPRB,8.4903E-04_JPRB,1.2778E-03_JPRB,1.4945E-03_JPRB,&
&1.7270E-03_JPRB,9.2171E-04_JPRB,2.3005E-04_JPRB/)
KAO( :, 3, 7, 3) = (/&
&9.1419E-04_JPRB,9.1920E-04_JPRB,8.1160E-04_JPRB,7.6435E-04_JPRB,1.1213E-03_JPRB,1.3301E-03_JPRB,&
&1.6214E-03_JPRB,9.1419E-04_JPRB,2.5234E-04_JPRB/)
KAO( :, 4, 7, 3) = (/&
&9.1402E-04_JPRB,9.3968E-04_JPRB,8.8126E-04_JPRB,7.5287E-04_JPRB,1.0570E-03_JPRB,1.2475E-03_JPRB,&
&1.2998E-03_JPRB,9.1402E-04_JPRB,2.7815E-04_JPRB/)
KAO( :, 5, 7, 3) = (/&
&9.2290E-04_JPRB,9.7254E-04_JPRB,9.5644E-04_JPRB,8.9479E-04_JPRB,1.0508E-03_JPRB,1.1268E-03_JPRB,&
&1.3501E-03_JPRB,9.2290E-04_JPRB,3.0806E-04_JPRB/)
KAO( :, 1, 8, 3) = (/&
&7.8900E-04_JPRB,7.4488E-04_JPRB,4.6218E-04_JPRB,9.6318E-04_JPRB,1.2372E-03_JPRB,1.5237E-03_JPRB,&
&1.6722E-03_JPRB,7.8900E-04_JPRB,3.0765E-04_JPRB/)
KAO( :, 2, 8, 3) = (/&
&7.8043E-04_JPRB,7.5428E-04_JPRB,5.4366E-04_JPRB,7.5909E-04_JPRB,1.0879E-03_JPRB,1.3550E-03_JPRB,&
&1.4794E-03_JPRB,7.8043E-04_JPRB,3.3864E-04_JPRB/)
KAO( :, 3, 8, 3) = (/&
&7.7466E-04_JPRB,7.6980E-04_JPRB,6.4963E-04_JPRB,7.0009E-04_JPRB,9.7649E-04_JPRB,1.1689E-03_JPRB,&
&1.4326E-03_JPRB,7.7466E-04_JPRB,3.7286E-04_JPRB/)
KAO( :, 4, 8, 3) = (/&
&7.7506E-04_JPRB,7.8870E-04_JPRB,7.1575E-04_JPRB,6.1864E-04_JPRB,8.9565E-04_JPRB,1.0708E-03_JPRB,&
&1.2387E-03_JPRB,7.7506E-04_JPRB,4.1070E-04_JPRB/)
KAO( :, 5, 8, 3) = (/&
&7.8287E-04_JPRB,8.1561E-04_JPRB,7.7836E-04_JPRB,6.6838E-04_JPRB,8.8453E-04_JPRB,9.5158E-04_JPRB,&
&1.1620E-03_JPRB,7.8287E-04_JPRB,4.5222E-04_JPRB/)
KAO( :, 1, 9, 3) = (/&
&6.6353E-04_JPRB,6.2207E-04_JPRB,4.1497E-04_JPRB,8.5325E-04_JPRB,1.1545E-03_JPRB,1.3202E-03_JPRB,&
&1.4543E-03_JPRB,6.6353E-04_JPRB,9.2255E-04_JPRB/)
KAO( :, 2, 9, 3) = (/&
&6.5824E-04_JPRB,6.2786E-04_JPRB,3.9339E-04_JPRB,7.1164E-04_JPRB,9.5910E-04_JPRB,1.2248E-03_JPRB,&
&1.2834E-03_JPRB,6.5824E-04_JPRB,1.0047E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&6.5331E-04_JPRB,6.3921E-04_JPRB,5.1016E-04_JPRB,5.9654E-04_JPRB,8.7596E-04_JPRB,1.0857E-03_JPRB,&
&1.2145E-03_JPRB,6.5331E-04_JPRB,1.0900E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&6.5413E-04_JPRB,6.5950E-04_JPRB,5.8244E-04_JPRB,5.3974E-04_JPRB,7.9259E-04_JPRB,9.3024E-04_JPRB,&
&1.1600E-03_JPRB,6.5413E-04_JPRB,1.1801E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&6.6022E-04_JPRB,6.8110E-04_JPRB,6.3639E-04_JPRB,5.2716E-04_JPRB,7.2311E-04_JPRB,8.5016E-04_JPRB,&
&9.6256E-04_JPRB,6.6022E-04_JPRB,1.2684E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&5.5537E-04_JPRB,5.1658E-04_JPRB,3.5969E-04_JPRB,7.5778E-04_JPRB,1.0268E-03_JPRB,1.1188E-03_JPRB,&
&1.2385E-03_JPRB,5.5537E-04_JPRB,4.6647E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&5.5299E-04_JPRB,5.2259E-04_JPRB,3.1728E-04_JPRB,6.5526E-04_JPRB,8.4363E-04_JPRB,1.0738E-03_JPRB,&
&1.0790E-03_JPRB,5.5299E-04_JPRB,4.9960E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&5.4881E-04_JPRB,5.3065E-04_JPRB,3.9373E-04_JPRB,5.2361E-04_JPRB,7.6014E-04_JPRB,9.4697E-04_JPRB,&
&1.0409E-03_JPRB,5.4881E-04_JPRB,5.3035E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&5.5010E-04_JPRB,5.4878E-04_JPRB,4.7038E-04_JPRB,4.9342E-04_JPRB,6.7583E-04_JPRB,8.0683E-04_JPRB,&
&1.0299E-03_JPRB,5.5010E-04_JPRB,5.6055E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&5.5598E-04_JPRB,5.6871E-04_JPRB,5.2247E-04_JPRB,4.3615E-04_JPRB,6.1815E-04_JPRB,7.4431E-04_JPRB,&
&8.6008E-04_JPRB,5.5598E-04_JPRB,5.8866E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&4.6383E-04_JPRB,4.3181E-04_JPRB,2.9311E-04_JPRB,6.2613E-04_JPRB,8.4464E-04_JPRB,9.4332E-04_JPRB,&
&1.0276E-03_JPRB,4.6383E-04_JPRB,9.7820E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&4.6171E-04_JPRB,4.3648E-04_JPRB,2.6562E-04_JPRB,5.3382E-04_JPRB,6.9685E-04_JPRB,9.0179E-04_JPRB,&
&9.0128E-04_JPRB,4.6171E-04_JPRB,1.0398E-02_JPRB/)
KAO( :, 3,11, 3) = (/&
&4.5971E-04_JPRB,4.4491E-04_JPRB,3.3508E-04_JPRB,4.3267E-04_JPRB,6.3864E-04_JPRB,7.7944E-04_JPRB,&
&8.8922E-04_JPRB,4.5971E-04_JPRB,1.0944E-02_JPRB/)
KAO( :, 4,11, 3) = (/&
&4.6259E-04_JPRB,4.6298E-04_JPRB,4.0175E-04_JPRB,4.0894E-04_JPRB,5.5874E-04_JPRB,6.6574E-04_JPRB,&
&8.6378E-04_JPRB,4.6259E-04_JPRB,1.1452E-02_JPRB/)
KAO( :, 5,11, 3) = (/&
&4.6974E-04_JPRB,4.8223E-04_JPRB,4.4819E-04_JPRB,3.7104E-04_JPRB,5.1007E-04_JPRB,6.1091E-04_JPRB,&
&6.9095E-04_JPRB,4.6974E-04_JPRB,1.1916E-02_JPRB/)
KAO( :, 1,12, 3) = (/&
&3.8677E-04_JPRB,3.6035E-04_JPRB,2.4184E-04_JPRB,5.1647E-04_JPRB,6.9945E-04_JPRB,8.0460E-04_JPRB,&
&8.3717E-04_JPRB,3.8677E-04_JPRB,1.3274E-02_JPRB/)
KAO( :, 2,12, 3) = (/&
&3.8521E-04_JPRB,3.6402E-04_JPRB,2.2242E-04_JPRB,4.3447E-04_JPRB,5.8110E-04_JPRB,7.4047E-04_JPRB,&
&7.6321E-04_JPRB,3.8521E-04_JPRB,1.4068E-02_JPRB/)
KAO( :, 3,12, 3) = (/&
&3.8458E-04_JPRB,3.7296E-04_JPRB,2.8696E-04_JPRB,3.5751E-04_JPRB,5.2960E-04_JPRB,6.4366E-04_JPRB,&
&7.5179E-04_JPRB,3.8458E-04_JPRB,1.4758E-02_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.8810E-04_JPRB,3.8944E-04_JPRB,3.4377E-04_JPRB,3.3355E-04_JPRB,4.6692E-04_JPRB,5.5746E-04_JPRB,&
&7.0895E-04_JPRB,3.8810E-04_JPRB,1.5376E-02_JPRB/)
KAO( :, 5,12, 3) = (/&
&3.9595E-04_JPRB,4.0863E-04_JPRB,3.8125E-04_JPRB,3.1202E-04_JPRB,4.2678E-04_JPRB,5.1131E-04_JPRB,&
&5.7489E-04_JPRB,3.9595E-04_JPRB,1.5941E-02_JPRB/)
KAO( :, 1,13, 3) = (/&
&3.2194E-04_JPRB,2.9976E-04_JPRB,1.9852E-04_JPRB,4.2567E-04_JPRB,5.7525E-04_JPRB,6.7061E-04_JPRB,&
&6.9907E-04_JPRB,3.2194E-04_JPRB,1.4565E-02_JPRB/)
KAO( :, 2,13, 3) = (/&
&3.2103E-04_JPRB,3.0342E-04_JPRB,1.8519E-04_JPRB,3.5157E-04_JPRB,4.8791E-04_JPRB,6.1939E-04_JPRB,&
&6.5160E-04_JPRB,3.2103E-04_JPRB,1.5395E-02_JPRB/)
KAO( :, 3,13, 3) = (/&
&3.2113E-04_JPRB,3.1205E-04_JPRB,2.4410E-04_JPRB,2.9571E-04_JPRB,4.4082E-04_JPRB,5.2957E-04_JPRB,&
&6.2741E-04_JPRB,3.2112E-04_JPRB,1.6107E-02_JPRB/)
KAO( :, 4,13, 3) = (/&
&3.2542E-04_JPRB,3.2754E-04_JPRB,2.9103E-04_JPRB,2.6678E-04_JPRB,3.8858E-04_JPRB,4.6663E-04_JPRB,&
&5.7700E-04_JPRB,3.2542E-04_JPRB,1.6764E-02_JPRB/)
KAO( :, 5,13, 3) = (/&
&3.3271E-04_JPRB,3.4522E-04_JPRB,3.2313E-04_JPRB,2.6306E-04_JPRB,3.5325E-04_JPRB,4.2786E-04_JPRB,&
&4.7758E-04_JPRB,3.3271E-04_JPRB,1.7329E-02_JPRB/)
KAO( :, 1, 1, 4) = (/&
&3.2539E-03_JPRB,3.4940E-03_JPRB,3.4388E-03_JPRB,3.0659E-03_JPRB,3.4522E-03_JPRB,4.1188E-03_JPRB,&
&4.1472E-03_JPRB,3.2539E-03_JPRB,9.9646E-04_JPRB/)
KAO( :, 2, 1, 4) = (/&
&3.2363E-03_JPRB,3.6045E-03_JPRB,3.7021E-03_JPRB,3.5901E-03_JPRB,3.1463E-03_JPRB,4.3360E-03_JPRB,&
&4.0838E-03_JPRB,3.2363E-03_JPRB,1.0956E-03_JPRB/)
KAO( :, 3, 1, 4) = (/&
&3.2334E-03_JPRB,3.7700E-03_JPRB,3.9602E-03_JPRB,3.9629E-03_JPRB,3.8081E-03_JPRB,4.2925E-03_JPRB,&
&5.1219E-03_JPRB,3.2334E-03_JPRB,1.3007E-03_JPRB/)
KAO( :, 4, 1, 4) = (/&
&3.2490E-03_JPRB,3.9748E-03_JPRB,4.2071E-03_JPRB,4.2935E-03_JPRB,4.3164E-03_JPRB,4.2604E-03_JPRB,&
&5.6033E-03_JPRB,3.2490E-03_JPRB,1.5944E-03_JPRB/)
KAO( :, 5, 1, 4) = (/&
&3.2698E-03_JPRB,4.1740E-03_JPRB,4.4497E-03_JPRB,4.6155E-03_JPRB,4.8047E-03_JPRB,5.1537E-03_JPRB,&
&5.5559E-03_JPRB,3.2698E-03_JPRB,1.9119E-03_JPRB/)
KAO( :, 1, 2, 4) = (/&
&2.8229E-03_JPRB,2.9984E-03_JPRB,2.9248E-03_JPRB,2.5710E-03_JPRB,2.9591E-03_JPRB,3.5685E-03_JPRB,&
&3.3471E-03_JPRB,2.8229E-03_JPRB,7.1037E-04_JPRB/)
KAO( :, 2, 2, 4) = (/&
&2.8182E-03_JPRB,3.1079E-03_JPRB,3.1510E-03_JPRB,3.0220E-03_JPRB,2.6456E-03_JPRB,3.5065E-03_JPRB,&
&3.5091E-03_JPRB,2.8182E-03_JPRB,8.2941E-04_JPRB/)
KAO( :, 3, 2, 4) = (/&
&2.8273E-03_JPRB,3.2641E-03_JPRB,3.3991E-03_JPRB,3.3882E-03_JPRB,3.1076E-03_JPRB,3.6339E-03_JPRB,&
&4.1453E-03_JPRB,2.8273E-03_JPRB,9.9329E-04_JPRB/)
KAO( :, 4, 2, 4) = (/&
&2.8479E-03_JPRB,3.4537E-03_JPRB,3.6378E-03_JPRB,3.6922E-03_JPRB,3.5902E-03_JPRB,3.4985E-03_JPRB,&
&4.8079E-03_JPRB,2.8479E-03_JPRB,1.2207E-03_JPRB/)
KAO( :, 5, 2, 4) = (/&
&2.8762E-03_JPRB,3.6435E-03_JPRB,3.8640E-03_JPRB,3.9829E-03_JPRB,4.0196E-03_JPRB,4.2137E-03_JPRB,&
&4.6057E-03_JPRB,2.8762E-03_JPRB,1.4645E-03_JPRB/)
KAO( :, 1, 3, 4) = (/&
&2.4480E-03_JPRB,2.5503E-03_JPRB,2.4276E-03_JPRB,1.9299E-03_JPRB,2.4394E-03_JPRB,2.9600E-03_JPRB,&
&3.0819E-03_JPRB,2.4480E-03_JPRB,5.1310E-04_JPRB/)
KAO( :, 2, 3, 4) = (/&
&2.4484E-03_JPRB,2.6489E-03_JPRB,2.6249E-03_JPRB,2.4613E-03_JPRB,2.1891E-03_JPRB,2.8113E-03_JPRB,&
&2.9085E-03_JPRB,2.4484E-03_JPRB,6.0695E-04_JPRB/)
KAO( :, 3, 3, 4) = (/&
&2.4631E-03_JPRB,2.7817E-03_JPRB,2.8578E-03_JPRB,2.8021E-03_JPRB,2.3361E-03_JPRB,3.1956E-03_JPRB,&
&3.2912E-03_JPRB,2.4631E-03_JPRB,7.4313E-04_JPRB/)
KAO( :, 4, 3, 4) = (/&
&2.4843E-03_JPRB,2.9440E-03_JPRB,3.0734E-03_JPRB,3.0947E-03_JPRB,2.9596E-03_JPRB,2.9621E-03_JPRB,&
&3.8254E-03_JPRB,2.4843E-03_JPRB,8.9831E-04_JPRB/)
KAO( :, 5, 3, 4) = (/&
&2.5152E-03_JPRB,3.1190E-03_JPRB,3.2801E-03_JPRB,3.3527E-03_JPRB,3.3374E-03_JPRB,3.2653E-03_JPRB,&
&3.7266E-03_JPRB,2.5152E-03_JPRB,1.0797E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&2.1250E-03_JPRB,2.1670E-03_JPRB,1.9990E-03_JPRB,1.5199E-03_JPRB,1.9962E-03_JPRB,2.4995E-03_JPRB,&
&2.9024E-03_JPRB,2.1250E-03_JPRB,3.7531E-04_JPRB/)
KAO( :, 2, 4, 4) = (/&
&2.1204E-03_JPRB,2.2489E-03_JPRB,2.1700E-03_JPRB,1.9399E-03_JPRB,1.9963E-03_JPRB,2.4266E-03_JPRB,&
&2.6000E-03_JPRB,2.1204E-03_JPRB,4.4756E-04_JPRB/)
KAO( :, 3, 4, 4) = (/&
&2.1413E-03_JPRB,2.3587E-03_JPRB,2.3627E-03_JPRB,2.2544E-03_JPRB,1.9195E-03_JPRB,2.4658E-03_JPRB,&
&2.5172E-03_JPRB,2.1413E-03_JPRB,5.4705E-04_JPRB/)
KAO( :, 4, 4, 4) = (/&
&2.1654E-03_JPRB,2.4980E-03_JPRB,2.5663E-03_JPRB,2.5373E-03_JPRB,2.3728E-03_JPRB,2.4769E-03_JPRB,&
&2.8318E-03_JPRB,2.1654E-03_JPRB,6.6125E-04_JPRB/)
KAO( :, 5, 4, 4) = (/&
&2.1913E-03_JPRB,2.6456E-03_JPRB,2.7536E-03_JPRB,2.7816E-03_JPRB,2.7405E-03_JPRB,2.5702E-03_JPRB,&
&3.2605E-03_JPRB,2.1913E-03_JPRB,7.9714E-04_JPRB/)
KAO( :, 1, 5, 4) = (/&
&1.8265E-03_JPRB,1.8381E-03_JPRB,1.6457E-03_JPRB,1.2486E-03_JPRB,1.7229E-03_JPRB,2.0547E-03_JPRB,&
&2.6848E-03_JPRB,1.8265E-03_JPRB,2.8596E-04_JPRB/)
KAO( :, 2, 5, 4) = (/&
&1.8274E-03_JPRB,1.9048E-03_JPRB,1.7983E-03_JPRB,1.4752E-03_JPRB,1.7469E-03_JPRB,2.1116E-03_JPRB,&
&2.1134E-03_JPRB,1.8274E-03_JPRB,3.4190E-04_JPRB/)
KAO( :, 3, 5, 4) = (/&
&1.8508E-03_JPRB,2.0003E-03_JPRB,1.9620E-03_JPRB,1.8188E-03_JPRB,1.6077E-03_JPRB,1.9516E-03_JPRB,&
&2.1073E-03_JPRB,1.8508E-03_JPRB,4.1292E-04_JPRB/)
KAO( :, 4, 5, 4) = (/&
&1.8793E-03_JPRB,2.1182E-03_JPRB,2.1350E-03_JPRB,2.0517E-03_JPRB,1.8087E-03_JPRB,2.2071E-03_JPRB,&
&2.2714E-03_JPRB,1.8793E-03_JPRB,4.9789E-04_JPRB/)
KAO( :, 5, 5, 4) = (/&
&1.9065E-03_JPRB,2.2435E-03_JPRB,2.3053E-03_JPRB,2.2926E-03_JPRB,2.2224E-03_JPRB,2.0829E-03_JPRB,&
&2.5565E-03_JPRB,1.9065E-03_JPRB,5.9975E-04_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.5738E-03_JPRB,1.5536E-03_JPRB,1.3462E-03_JPRB,1.0905E-03_JPRB,1.5345E-03_JPRB,1.8378E-03_JPRB,&
&2.3696E-03_JPRB,1.5738E-03_JPRB,2.4570E-04_JPRB/)
KAO( :, 2, 6, 4) = (/&
&1.5785E-03_JPRB,1.6102E-03_JPRB,1.4864E-03_JPRB,1.0878E-03_JPRB,1.4533E-03_JPRB,1.8096E-03_JPRB,&
&1.9208E-03_JPRB,1.5785E-03_JPRB,2.8650E-04_JPRB/)
KAO( :, 3, 6, 4) = (/&
&1.5938E-03_JPRB,1.6886E-03_JPRB,1.6242E-03_JPRB,1.4329E-03_JPRB,1.3971E-03_JPRB,1.6588E-03_JPRB,&
&1.7977E-03_JPRB,1.5938E-03_JPRB,3.3646E-04_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.6207E-03_JPRB,1.7903E-03_JPRB,1.7740E-03_JPRB,1.6609E-03_JPRB,1.4090E-03_JPRB,1.7880E-03_JPRB,&
&1.8264E-03_JPRB,1.6207E-03_JPRB,3.9927E-04_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.6514E-03_JPRB,1.8945E-03_JPRB,1.9189E-03_JPRB,1.8707E-03_JPRB,1.7309E-03_JPRB,1.7651E-03_JPRB,&
&1.8956E-03_JPRB,1.6514E-03_JPRB,4.7341E-04_JPRB/)
KAO( :, 1, 7, 4) = (/&
&1.3566E-03_JPRB,1.3176E-03_JPRB,1.0800E-03_JPRB,9.9879E-04_JPRB,1.3645E-03_JPRB,1.6716E-03_JPRB,&
&2.0138E-03_JPRB,1.3566E-03_JPRB,2.7117E-04_JPRB/)
KAO( :, 2, 7, 4) = (/&
&1.3616E-03_JPRB,1.3614E-03_JPRB,1.2294E-03_JPRB,8.6943E-04_JPRB,1.2441E-03_JPRB,1.4557E-03_JPRB,&
&1.7627E-03_JPRB,1.3616E-03_JPRB,3.0497E-04_JPRB/)
KAO( :, 3, 7, 4) = (/&
&1.3738E-03_JPRB,1.4251E-03_JPRB,1.3424E-03_JPRB,1.0748E-03_JPRB,1.3239E-03_JPRB,1.4948E-03_JPRB,&
&1.4893E-03_JPRB,1.3738E-03_JPRB,3.4547E-04_JPRB/)
KAO( :, 4, 7, 4) = (/&
&1.3909E-03_JPRB,1.5062E-03_JPRB,1.4675E-03_JPRB,1.3314E-03_JPRB,1.1299E-03_JPRB,1.4256E-03_JPRB,&
&1.5101E-03_JPRB,1.3909E-03_JPRB,3.9363E-04_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.4214E-03_JPRB,1.5939E-03_JPRB,1.5929E-03_JPRB,1.5159E-03_JPRB,1.3044E-03_JPRB,1.5546E-03_JPRB,&
&1.5847E-03_JPRB,1.4214E-03_JPRB,4.4999E-04_JPRB/)
KAO( :, 1, 8, 4) = (/&
&1.1638E-03_JPRB,1.1139E-03_JPRB,8.4796E-04_JPRB,8.4668E-04_JPRB,1.2396E-03_JPRB,1.5094E-03_JPRB,&
&1.6975E-03_JPRB,1.1638E-03_JPRB,4.3052E-04_JPRB/)
KAO( :, 2, 8, 4) = (/&
&1.1671E-03_JPRB,1.1491E-03_JPRB,9.9702E-04_JPRB,7.1894E-04_JPRB,1.1157E-03_JPRB,1.2835E-03_JPRB,&
&1.5171E-03_JPRB,1.1671E-03_JPRB,4.7244E-04_JPRB/)
KAO( :, 3, 8, 4) = (/&
&1.1763E-03_JPRB,1.1971E-03_JPRB,1.1061E-03_JPRB,7.5625E-04_JPRB,1.0948E-03_JPRB,1.3227E-03_JPRB,&
&1.3243E-03_JPRB,1.1763E-03_JPRB,5.1908E-04_JPRB/)
KAO( :, 4, 8, 4) = (/&
&1.1882E-03_JPRB,1.2582E-03_JPRB,1.2081E-03_JPRB,1.0410E-03_JPRB,9.4931E-04_JPRB,1.2112E-03_JPRB,&
&1.2350E-03_JPRB,1.1882E-03_JPRB,5.7242E-04_JPRB/)
KAO( :, 5, 8, 4) = (/&
&1.2141E-03_JPRB,1.3322E-03_JPRB,1.3142E-03_JPRB,1.2208E-03_JPRB,9.8671E-04_JPRB,1.3128E-03_JPRB,&
&1.3456E-03_JPRB,1.2141E-03_JPRB,6.3120E-04_JPRB/)
KAO( :, 1, 9, 4) = (/&
&9.9337E-04_JPRB,9.3743E-04_JPRB,6.1970E-04_JPRB,7.5456E-04_JPRB,1.1089E-03_JPRB,1.3407E-03_JPRB,&
&1.5068E-03_JPRB,9.9337E-04_JPRB,1.4422E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&9.9471E-04_JPRB,9.6601E-04_JPRB,8.0263E-04_JPRB,6.4260E-04_JPRB,9.9035E-04_JPRB,1.1710E-03_JPRB,&
&1.3289E-03_JPRB,9.9471E-04_JPRB,1.5498E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.0028E-03_JPRB,1.0037E-03_JPRB,9.0388E-04_JPRB,5.9394E-04_JPRB,8.7485E-04_JPRB,1.0779E-03_JPRB,&
&1.1968E-03_JPRB,1.0028E-03_JPRB,1.6632E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&1.0138E-03_JPRB,1.0500E-03_JPRB,9.8794E-04_JPRB,7.6322E-04_JPRB,8.5312E-04_JPRB,1.1047E-03_JPRB,&
&1.0664E-03_JPRB,1.0138E-03_JPRB,1.7764E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&1.0324E-03_JPRB,1.1072E-03_JPRB,1.0751E-03_JPRB,9.6755E-04_JPRB,7.9829E-04_JPRB,1.0354E-03_JPRB,&
&1.1339E-03_JPRB,1.0324E-03_JPRB,1.8836E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&8.4390E-04_JPRB,7.8883E-04_JPRB,4.5496E-04_JPRB,6.3978E-04_JPRB,9.7062E-04_JPRB,1.1888E-03_JPRB,&
&1.3025E-03_JPRB,8.4390E-04_JPRB,7.7978E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&8.4417E-04_JPRB,8.1047E-04_JPRB,6.4039E-04_JPRB,5.5867E-04_JPRB,8.6775E-04_JPRB,1.0100E-03_JPRB,&
&1.1972E-03_JPRB,8.4417E-04_JPRB,8.1651E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&8.5209E-04_JPRB,8.4218E-04_JPRB,7.3701E-04_JPRB,4.8053E-04_JPRB,7.5503E-04_JPRB,9.4507E-04_JPRB,&
&1.0394E-03_JPRB,8.5209E-04_JPRB,8.5320E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&8.6243E-04_JPRB,8.7871E-04_JPRB,8.1378E-04_JPRB,5.4794E-04_JPRB,7.5693E-04_JPRB,9.4093E-04_JPRB,&
&9.0694E-04_JPRB,8.6243E-04_JPRB,8.8886E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&8.7838E-04_JPRB,9.2500E-04_JPRB,8.8544E-04_JPRB,7.6044E-04_JPRB,6.4236E-04_JPRB,8.2354E-04_JPRB,&
&9.4540E-04_JPRB,8.7839E-04_JPRB,9.2325E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&7.1140E-04_JPRB,6.6686E-04_JPRB,3.9659E-04_JPRB,5.3128E-04_JPRB,8.2390E-04_JPRB,9.6334E-04_JPRB,&
&1.0535E-03_JPRB,7.1140E-04_JPRB,1.6752E-02_JPRB/)
KAO( :, 2,11, 4) = (/&
&7.1470E-04_JPRB,6.8928E-04_JPRB,5.4857E-04_JPRB,4.7790E-04_JPRB,7.0017E-04_JPRB,8.4578E-04_JPRB,&
&9.6239E-04_JPRB,7.1470E-04_JPRB,1.7467E-02_JPRB/)
KAO( :, 3,11, 4) = (/&
&7.2406E-04_JPRB,7.1829E-04_JPRB,6.3252E-04_JPRB,4.0136E-04_JPRB,6.0473E-04_JPRB,8.1229E-04_JPRB,&
&8.6413E-04_JPRB,7.2406E-04_JPRB,1.8154E-02_JPRB/)
KAO( :, 4,11, 4) = (/&
&7.3750E-04_JPRB,7.5088E-04_JPRB,6.9603E-04_JPRB,4.8007E-04_JPRB,6.2834E-04_JPRB,7.5345E-04_JPRB,&
&7.8530E-04_JPRB,7.3750E-04_JPRB,1.8779E-02_JPRB/)
KAO( :, 5,11, 4) = (/&
&7.5575E-04_JPRB,7.9367E-04_JPRB,7.5606E-04_JPRB,6.5213E-04_JPRB,5.4718E-04_JPRB,7.0193E-04_JPRB,&
&8.3404E-04_JPRB,7.5575E-04_JPRB,1.9352E-02_JPRB/)
KAO( :, 1,12, 4) = (/&
&5.9829E-04_JPRB,5.6157E-04_JPRB,3.4347E-04_JPRB,4.4145E-04_JPRB,6.8008E-04_JPRB,7.8397E-04_JPRB,&
&8.5127E-04_JPRB,5.9830E-04_JPRB,2.3223E-02_JPRB/)
KAO( :, 2,12, 4) = (/&
&6.0344E-04_JPRB,5.8387E-04_JPRB,4.6957E-04_JPRB,3.9737E-04_JPRB,5.7696E-04_JPRB,7.2078E-04_JPRB,&
&7.8930E-04_JPRB,6.0344E-04_JPRB,2.4171E-02_JPRB/)
KAO( :, 3,12, 4) = (/&
&6.1383E-04_JPRB,6.1057E-04_JPRB,5.4014E-04_JPRB,3.4306E-04_JPRB,5.0450E-04_JPRB,6.7941E-04_JPRB,&
&7.3306E-04_JPRB,6.1383E-04_JPRB,2.5042E-02_JPRB/)
KAO( :, 4,12, 4) = (/&
&6.2909E-04_JPRB,6.4187E-04_JPRB,5.9443E-04_JPRB,4.2049E-04_JPRB,5.1244E-04_JPRB,6.1921E-04_JPRB,&
&6.8115E-04_JPRB,6.2909E-04_JPRB,2.5830E-02_JPRB/)
KAO( :, 5,12, 4) = (/&
&6.5010E-04_JPRB,6.8123E-04_JPRB,6.4805E-04_JPRB,5.6243E-04_JPRB,4.5555E-04_JPRB,5.8069E-04_JPRB,&
&6.9766E-04_JPRB,6.5010E-04_JPRB,2.6537E-02_JPRB/)
KAO( :, 1,13, 4) = (/&
&5.0269E-04_JPRB,4.7309E-04_JPRB,2.9722E-04_JPRB,3.6029E-04_JPRB,5.5327E-04_JPRB,6.7267E-04_JPRB,&
&6.9641E-04_JPRB,5.0269E-04_JPRB,2.5949E-02_JPRB/)
KAO( :, 2,13, 4) = (/&
&5.0863E-04_JPRB,4.9324E-04_JPRB,4.0227E-04_JPRB,3.2512E-04_JPRB,4.7435E-04_JPRB,5.7218E-04_JPRB,&
&6.4965E-04_JPRB,5.0863E-04_JPRB,2.6966E-02_JPRB/)
KAO( :, 3,13, 4) = (/&
&5.1998E-04_JPRB,5.1754E-04_JPRB,4.6042E-04_JPRB,2.9200E-04_JPRB,4.1919E-04_JPRB,5.5920E-04_JPRB,&
&6.2355E-04_JPRB,5.1997E-04_JPRB,2.7905E-02_JPRB/)
KAO( :, 4,13, 4) = (/&
&5.3565E-04_JPRB,5.4724E-04_JPRB,5.0865E-04_JPRB,3.7273E-04_JPRB,4.1799E-04_JPRB,5.1125E-04_JPRB,&
&5.5790E-04_JPRB,5.3565E-04_JPRB,2.8735E-02_JPRB/)
KAO( :, 5,13, 4) = (/&
&5.5698E-04_JPRB,5.8373E-04_JPRB,5.5557E-04_JPRB,4.8519E-04_JPRB,3.8080E-04_JPRB,4.8575E-04_JPRB,&
&5.9866E-04_JPRB,5.5698E-04_JPRB,2.9481E-02_JPRB/)
KAO( :, 1, 1, 5) = (/&
&5.1773E-03_JPRB,5.5179E-03_JPRB,5.4794E-03_JPRB,5.0590E-03_JPRB,3.8870E-03_JPRB,4.6296E-03_JPRB,&
&5.9241E-03_JPRB,5.1773E-03_JPRB,1.5277E-03_JPRB/)
KAO( :, 2, 1, 5) = (/&
&5.2034E-03_JPRB,5.6993E-03_JPRB,5.7195E-03_JPRB,5.6065E-03_JPRB,5.1571E-03_JPRB,4.6383E-03_JPRB,&
&6.9998E-03_JPRB,5.2034E-03_JPRB,2.0327E-03_JPRB/)
KAO( :, 3, 1, 5) = (/&
&5.2523E-03_JPRB,5.8787E-03_JPRB,6.0084E-03_JPRB,6.0684E-03_JPRB,6.0397E-03_JPRB,6.1073E-03_JPRB,&
&5.9208E-03_JPRB,5.2523E-03_JPRB,2.5125E-03_JPRB/)
KAO( :, 4, 1, 5) = (/&
&5.3054E-03_JPRB,6.0746E-03_JPRB,6.3010E-03_JPRB,6.5205E-03_JPRB,6.8111E-03_JPRB,7.3269E-03_JPRB,&
&7.5915E-03_JPRB,5.3054E-03_JPRB,3.0259E-03_JPRB/)
KAO( :, 5, 1, 5) = (/&
&5.3679E-03_JPRB,6.2880E-03_JPRB,6.5896E-03_JPRB,6.9769E-03_JPRB,7.5426E-03_JPRB,8.2616E-03_JPRB,&
&9.5734E-03_JPRB,5.3679E-03_JPRB,3.5988E-03_JPRB/)
KAO( :, 1, 2, 5) = (/&
&4.6050E-03_JPRB,4.8904E-03_JPRB,4.7826E-03_JPRB,4.2812E-03_JPRB,3.0961E-03_JPRB,4.0066E-03_JPRB,&
&5.0115E-03_JPRB,4.6050E-03_JPRB,1.1833E-03_JPRB/)
KAO( :, 2, 2, 5) = (/&
&4.6546E-03_JPRB,5.0669E-03_JPRB,5.0153E-03_JPRB,4.8028E-03_JPRB,4.2371E-03_JPRB,3.8571E-03_JPRB,&
&5.7082E-03_JPRB,4.6545E-03_JPRB,1.5250E-03_JPRB/)
KAO( :, 3, 2, 5) = (/&
&4.7163E-03_JPRB,5.2445E-03_JPRB,5.2818E-03_JPRB,5.2193E-03_JPRB,5.0401E-03_JPRB,4.8158E-03_JPRB,&
&4.8111E-03_JPRB,4.7163E-03_JPRB,1.8851E-03_JPRB/)
KAO( :, 4, 2, 5) = (/&
&4.7840E-03_JPRB,5.4375E-03_JPRB,5.5428E-03_JPRB,5.6145E-03_JPRB,5.7557E-03_JPRB,6.0979E-03_JPRB,&
&6.0650E-03_JPRB,4.7840E-03_JPRB,2.2872E-03_JPRB/)
KAO( :, 5, 2, 5) = (/&
&4.8541E-03_JPRB,5.6350E-03_JPRB,5.8029E-03_JPRB,5.9983E-03_JPRB,6.3916E-03_JPRB,6.9220E-03_JPRB,&
&7.8417E-03_JPRB,4.8542E-03_JPRB,2.7410E-03_JPRB/)
KAO( :, 1, 3, 5) = (/&
&4.0566E-03_JPRB,4.2666E-03_JPRB,4.1136E-03_JPRB,3.4902E-03_JPRB,2.4320E-03_JPRB,3.7448E-03_JPRB,&
&4.0596E-03_JPRB,4.0566E-03_JPRB,8.5537E-04_JPRB/)
KAO( :, 2, 3, 5) = (/&
&4.1192E-03_JPRB,4.4343E-03_JPRB,4.3374E-03_JPRB,4.0126E-03_JPRB,3.2863E-03_JPRB,3.1710E-03_JPRB,&
&4.6913E-03_JPRB,4.1192E-03_JPRB,1.0912E-03_JPRB/)
KAO( :, 3, 3, 5) = (/&
&4.1883E-03_JPRB,4.6068E-03_JPRB,4.5710E-03_JPRB,4.4080E-03_JPRB,4.0587E-03_JPRB,3.3970E-03_JPRB,&
&4.0950E-03_JPRB,4.1883E-03_JPRB,1.3564E-03_JPRB/)
KAO( :, 4, 3, 5) = (/&
&4.2607E-03_JPRB,4.7874E-03_JPRB,4.8302E-03_JPRB,4.7600E-03_JPRB,4.6789E-03_JPRB,4.6803E-03_JPRB,&
&4.6046E-03_JPRB,4.2607E-03_JPRB,1.6587E-03_JPRB/)
KAO( :, 5, 3, 5) = (/&
&4.3291E-03_JPRB,4.9729E-03_JPRB,5.0821E-03_JPRB,5.1132E-03_JPRB,5.2389E-03_JPRB,5.5501E-03_JPRB,&
&6.1453E-03_JPRB,4.3291E-03_JPRB,2.0123E-03_JPRB/)
KAO( :, 1, 4, 5) = (/&
&3.5459E-03_JPRB,3.6825E-03_JPRB,3.4932E-03_JPRB,2.7637E-03_JPRB,1.9201E-03_JPRB,3.0460E-03_JPRB,&
&3.2749E-03_JPRB,3.5459E-03_JPRB,6.1561E-04_JPRB/)
KAO( :, 2, 4, 5) = (/&
&3.6061E-03_JPRB,3.8362E-03_JPRB,3.7182E-03_JPRB,3.3223E-03_JPRB,2.3497E-03_JPRB,2.6627E-03_JPRB,&
&3.6845E-03_JPRB,3.6061E-03_JPRB,7.8011E-04_JPRB/)
KAO( :, 3, 4, 5) = (/&
&3.6751E-03_JPRB,4.0009E-03_JPRB,3.9352E-03_JPRB,3.7212E-03_JPRB,3.1586E-03_JPRB,2.6599E-03_JPRB,&
&3.9284E-03_JPRB,3.6751E-03_JPRB,9.7541E-04_JPRB/)
KAO( :, 4, 4, 5) = (/&
&3.7472E-03_JPRB,4.1657E-03_JPRB,4.1547E-03_JPRB,4.0471E-03_JPRB,3.7579E-03_JPRB,3.4987E-03_JPRB,&
&3.4684E-03_JPRB,3.7472E-03_JPRB,1.2060E-03_JPRB/)
KAO( :, 5, 4, 5) = (/&
&3.8173E-03_JPRB,4.3392E-03_JPRB,4.3926E-03_JPRB,4.3575E-03_JPRB,4.2919E-03_JPRB,4.2730E-03_JPRB,&
&4.3662E-03_JPRB,3.8173E-03_JPRB,1.4743E-03_JPRB/)
KAO( :, 1, 5, 5) = (/&
&3.0911E-03_JPRB,3.1547E-03_JPRB,2.9517E-03_JPRB,2.1585E-03_JPRB,1.7089E-03_JPRB,2.5065E-03_JPRB,&
&2.6736E-03_JPRB,3.0911E-03_JPRB,4.5259E-04_JPRB/)
KAO( :, 2, 5, 5) = (/&
&3.1432E-03_JPRB,3.2952E-03_JPRB,3.1535E-03_JPRB,2.7144E-03_JPRB,1.7305E-03_JPRB,2.3740E-03_JPRB,&
&2.9171E-03_JPRB,3.1432E-03_JPRB,5.6940E-04_JPRB/)
KAO( :, 3, 5, 5) = (/&
&3.2011E-03_JPRB,3.4418E-03_JPRB,3.3526E-03_JPRB,3.0998E-03_JPRB,2.4424E-03_JPRB,2.1728E-03_JPRB,&
&3.3563E-03_JPRB,3.2011E-03_JPRB,7.1313E-04_JPRB/)
KAO( :, 4, 5, 5) = (/&
&3.2691E-03_JPRB,3.5925E-03_JPRB,3.5476E-03_JPRB,3.4130E-03_JPRB,3.0304E-03_JPRB,2.4542E-03_JPRB,&
&2.7853E-03_JPRB,3.2691E-03_JPRB,8.8641E-04_JPRB/)
KAO( :, 5, 5, 5) = (/&
&3.3413E-03_JPRB,3.7507E-03_JPRB,3.7512E-03_JPRB,3.6954E-03_JPRB,3.5144E-03_JPRB,3.3039E-03_JPRB,&
&3.1174E-03_JPRB,3.3413E-03_JPRB,1.0913E-03_JPRB/)
KAO( :, 1, 6, 5) = (/&
&2.6814E-03_JPRB,2.6940E-03_JPRB,2.4706E-03_JPRB,1.6241E-03_JPRB,1.5796E-03_JPRB,1.9986E-03_JPRB,&
&2.3111E-03_JPRB,2.6814E-03_JPRB,3.5673E-04_JPRB/)
KAO( :, 2, 6, 5) = (/&
&2.7286E-03_JPRB,2.8170E-03_JPRB,2.6566E-03_JPRB,2.1953E-03_JPRB,1.3951E-03_JPRB,2.0187E-03_JPRB,&
&2.3167E-03_JPRB,2.7286E-03_JPRB,4.3928E-04_JPRB/)
KAO( :, 3, 6, 5) = (/&
&2.7784E-03_JPRB,2.9396E-03_JPRB,2.8323E-03_JPRB,2.5431E-03_JPRB,1.8045E-03_JPRB,1.8580E-03_JPRB,&
&2.5230E-03_JPRB,2.7784E-03_JPRB,5.4225E-04_JPRB/)
KAO( :, 4, 6, 5) = (/&
&2.8457E-03_JPRB,3.0707E-03_JPRB,3.0040E-03_JPRB,2.8313E-03_JPRB,2.4304E-03_JPRB,1.8757E-03_JPRB,&
&2.4280E-03_JPRB,2.8457E-03_JPRB,6.6880E-04_JPRB/)
KAO( :, 5, 6, 5) = (/&
&2.9149E-03_JPRB,3.2145E-03_JPRB,3.1791E-03_JPRB,3.0927E-03_JPRB,2.8718E-03_JPRB,2.5020E-03_JPRB,&
&2.4114E-03_JPRB,2.9149E-03_JPRB,8.2090E-04_JPRB/)
KAO( :, 1, 7, 5) = (/&
&2.3167E-03_JPRB,2.2952E-03_JPRB,2.0696E-03_JPRB,1.1773E-03_JPRB,1.4001E-03_JPRB,1.6742E-03_JPRB,&
&2.1113E-03_JPRB,2.3167E-03_JPRB,3.6556E-04_JPRB/)
KAO( :, 2, 7, 5) = (/&
&2.3617E-03_JPRB,2.3995E-03_JPRB,2.2278E-03_JPRB,1.7561E-03_JPRB,1.2221E-03_JPRB,1.7039E-03_JPRB,&
&1.9252E-03_JPRB,2.3617E-03_JPRB,4.2264E-04_JPRB/)
KAO( :, 3, 7, 5) = (/&
&2.4125E-03_JPRB,2.5066E-03_JPRB,2.3818E-03_JPRB,2.0804E-03_JPRB,1.2642E-03_JPRB,1.6328E-03_JPRB,&
&2.0160E-03_JPRB,2.4124E-03_JPRB,4.9466E-04_JPRB/)
KAO( :, 4, 7, 5) = (/&
&2.4726E-03_JPRB,2.6189E-03_JPRB,2.5346E-03_JPRB,2.3337E-03_JPRB,1.9285E-03_JPRB,1.5396E-03_JPRB,&
&2.2851E-03_JPRB,2.4726E-03_JPRB,5.8211E-04_JPRB/)
KAO( :, 5, 7, 5) = (/&
&2.5348E-03_JPRB,2.7473E-03_JPRB,2.6870E-03_JPRB,2.5696E-03_JPRB,2.3235E-03_JPRB,1.8153E-03_JPRB,&
&1.9526E-03_JPRB,2.5348E-03_JPRB,6.8811E-04_JPRB/)
KAO( :, 1, 8, 5) = (/&
&1.9955E-03_JPRB,1.9488E-03_JPRB,1.7343E-03_JPRB,8.5576E-04_JPRB,1.2169E-03_JPRB,1.3982E-03_JPRB,&
&1.8806E-03_JPRB,1.9955E-03_JPRB,5.8425E-04_JPRB/)
KAO( :, 2, 8, 5) = (/&
&2.0363E-03_JPRB,2.0385E-03_JPRB,1.8715E-03_JPRB,1.3678E-03_JPRB,1.1488E-03_JPRB,1.3583E-03_JPRB,&
&1.6630E-03_JPRB,2.0363E-03_JPRB,6.4943E-04_JPRB/)
KAO( :, 3, 8, 5) = (/&
&2.0848E-03_JPRB,2.1355E-03_JPRB,2.0016E-03_JPRB,1.7099E-03_JPRB,1.0490E-03_JPRB,1.3612E-03_JPRB,&
&1.5304E-03_JPRB,2.0848E-03_JPRB,7.2039E-04_JPRB/)
KAO( :, 4, 8, 5) = (/&
&2.1402E-03_JPRB,2.2347E-03_JPRB,2.1377E-03_JPRB,1.9281E-03_JPRB,1.4576E-03_JPRB,1.3615E-03_JPRB,&
&1.7494E-03_JPRB,2.1402E-03_JPRB,7.9144E-04_JPRB/)
KAO( :, 5, 8, 5) = (/&
&2.1918E-03_JPRB,2.3439E-03_JPRB,2.2739E-03_JPRB,2.1323E-03_JPRB,1.8701E-03_JPRB,1.4117E-03_JPRB,&
&1.6694E-03_JPRB,2.1918E-03_JPRB,8.7428E-04_JPRB/)
KAO( :, 1, 9, 5) = (/&
&1.7089E-03_JPRB,1.6461E-03_JPRB,1.4363E-03_JPRB,6.6011E-04_JPRB,1.0235E-03_JPRB,1.2576E-03_JPRB,&
&1.6021E-03_JPRB,1.7089E-03_JPRB,2.1905E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&1.7449E-03_JPRB,1.7240E-03_JPRB,1.5611E-03_JPRB,9.5939E-04_JPRB,1.0171E-03_JPRB,1.0930E-03_JPRB,&
&1.4980E-03_JPRB,1.7449E-03_JPRB,2.3032E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&1.7892E-03_JPRB,1.8095E-03_JPRB,1.6779E-03_JPRB,1.3700E-03_JPRB,8.8733E-04_JPRB,1.1976E-03_JPRB,&
&1.2362E-03_JPRB,1.7892E-03_JPRB,2.4285E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&1.8369E-03_JPRB,1.8975E-03_JPRB,1.7975E-03_JPRB,1.5888E-03_JPRB,1.0202E-03_JPRB,1.1883E-03_JPRB,&
&1.3430E-03_JPRB,1.8369E-03_JPRB,2.5680E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&1.8812E-03_JPRB,1.9874E-03_JPRB,1.9123E-03_JPRB,1.7614E-03_JPRB,1.4649E-03_JPRB,1.1491E-03_JPRB,&
&1.5713E-03_JPRB,1.8812E-03_JPRB,2.7221E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&1.4572E-03_JPRB,1.3868E-03_JPRB,1.1826E-03_JPRB,6.2346E-04_JPRB,8.6762E-04_JPRB,1.0836E-03_JPRB,&
&1.3348E-03_JPRB,1.4572E-03_JPRB,1.2658E-02_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.4886E-03_JPRB,1.4531E-03_JPRB,1.3004E-03_JPRB,6.9239E-04_JPRB,8.6868E-04_JPRB,9.6168E-04_JPRB,&
&1.2569E-03_JPRB,1.4886E-03_JPRB,1.3059E-02_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.5264E-03_JPRB,1.5274E-03_JPRB,1.4051E-03_JPRB,1.0747E-03_JPRB,7.7218E-04_JPRB,9.7410E-04_JPRB,&
&1.0859E-03_JPRB,1.5264E-03_JPRB,1.3449E-02_JPRB/)
KAO( :, 4,10, 5) = (/&
&1.5664E-03_JPRB,1.6018E-03_JPRB,1.5021E-03_JPRB,1.3016E-03_JPRB,7.5442E-04_JPRB,1.0421E-03_JPRB,&
&1.0986E-03_JPRB,1.5664E-03_JPRB,1.3823E-02_JPRB/)
KAO( :, 5,10, 5) = (/&
&1.6039E-03_JPRB,1.6782E-03_JPRB,1.6029E-03_JPRB,1.4558E-03_JPRB,1.1428E-03_JPRB,9.8459E-04_JPRB,&
&1.2311E-03_JPRB,1.6039E-03_JPRB,1.4197E-02_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.2517E-03_JPRB,1.1909E-03_JPRB,1.0253E-03_JPRB,4.8905E-04_JPRB,7.3597E-04_JPRB,9.0427E-04_JPRB,&
&1.2588E-03_JPRB,1.2517E-03_JPRB,2.8270E-02_JPRB/)
KAO( :, 2,11, 5) = (/&
&1.2817E-03_JPRB,1.2489E-03_JPRB,1.1208E-03_JPRB,6.0287E-04_JPRB,7.2254E-04_JPRB,8.2946E-04_JPRB,&
&1.0205E-03_JPRB,1.2817E-03_JPRB,2.9032E-02_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.3127E-03_JPRB,1.3112E-03_JPRB,1.2059E-03_JPRB,9.4181E-04_JPRB,6.2131E-04_JPRB,8.6171E-04_JPRB,&
&8.9101E-04_JPRB,1.3127E-03_JPRB,2.9698E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.3452E-03_JPRB,1.3741E-03_JPRB,1.2883E-03_JPRB,1.1215E-03_JPRB,6.5766E-04_JPRB,8.7354E-04_JPRB,&
&9.3021E-04_JPRB,1.3452E-03_JPRB,3.0336E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&1.3753E-03_JPRB,1.4371E-03_JPRB,1.3746E-03_JPRB,1.2547E-03_JPRB,9.9517E-04_JPRB,7.9857E-04_JPRB,&
&1.0959E-03_JPRB,1.3753E-03_JPRB,3.0956E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&1.0733E-03_JPRB,1.0215E-03_JPRB,8.8454E-04_JPRB,3.9006E-04_JPRB,6.2359E-04_JPRB,7.4085E-04_JPRB,&
&1.0395E-03_JPRB,1.0733E-03_JPRB,4.0158E-02_JPRB/)
KAO( :, 2,12, 5) = (/&
&1.0987E-03_JPRB,1.0703E-03_JPRB,9.6221E-04_JPRB,5.3528E-04_JPRB,5.8115E-04_JPRB,7.1438E-04_JPRB,&
&8.3203E-04_JPRB,1.0987E-03_JPRB,4.1196E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.1257E-03_JPRB,1.1222E-03_JPRB,1.0309E-03_JPRB,8.1291E-04_JPRB,4.9033E-04_JPRB,7.2341E-04_JPRB,&
&7.5536E-04_JPRB,1.1257E-03_JPRB,4.2149E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.1520E-03_JPRB,1.1737E-03_JPRB,1.0999E-03_JPRB,9.6654E-04_JPRB,5.7890E-04_JPRB,6.9991E-04_JPRB,&
&7.9257E-04_JPRB,1.1520E-03_JPRB,4.3060E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.1770E-03_JPRB,1.2266E-03_JPRB,1.1727E-03_JPRB,1.0746E-03_JPRB,8.6506E-04_JPRB,6.5737E-04_JPRB,&
&9.1851E-04_JPRB,1.1770E-03_JPRB,4.3899E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&9.1723E-04_JPRB,8.7340E-04_JPRB,7.5855E-04_JPRB,3.3160E-04_JPRB,5.1898E-04_JPRB,6.0675E-04_JPRB,&
&8.3666E-04_JPRB,9.1723E-04_JPRB,4.5805E-02_JPRB/)
KAO( :, 2,13, 5) = (/&
&9.3894E-04_JPRB,9.1416E-04_JPRB,8.2179E-04_JPRB,4.8369E-04_JPRB,4.6977E-04_JPRB,6.3046E-04_JPRB,&
&6.9917E-04_JPRB,9.3894E-04_JPRB,4.7104E-02_JPRB/)
KAO( :, 3,13, 5) = (/&
&9.6174E-04_JPRB,9.5729E-04_JPRB,8.7932E-04_JPRB,7.0453E-04_JPRB,4.0162E-04_JPRB,5.9248E-04_JPRB,&
&6.3372E-04_JPRB,9.6174E-04_JPRB,4.8249E-02_JPRB/)
KAO( :, 4,13, 5) = (/&
&9.8438E-04_JPRB,1.0004E-03_JPRB,9.3575E-04_JPRB,8.2536E-04_JPRB,5.0557E-04_JPRB,5.5685E-04_JPRB,&
&6.8082E-04_JPRB,9.8438E-04_JPRB,4.9296E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&1.0080E-03_JPRB,1.0464E-03_JPRB,9.9862E-04_JPRB,9.1769E-04_JPRB,7.4911E-04_JPRB,5.5133E-04_JPRB,&
&7.2141E-04_JPRB,1.0080E-03_JPRB,5.0236E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&8.5333E-03_JPRB,9.0798E-03_JPRB,9.1539E-03_JPRB,8.9379E-03_JPRB,8.0082E-03_JPRB,5.5783E-03_JPRB,&
&6.6117E-03_JPRB,8.5333E-03_JPRB,2.8261E-03_JPRB/)
KAO( :, 2, 1, 6) = (/&
&8.4109E-03_JPRB,9.3459E-03_JPRB,9.6624E-03_JPRB,9.7547E-03_JPRB,9.5796E-03_JPRB,8.4027E-03_JPRB,&
&6.4961E-03_JPRB,8.4109E-03_JPRB,3.5780E-03_JPRB/)
KAO( :, 3, 1, 6) = (/&
&8.3030E-03_JPRB,9.6326E-03_JPRB,1.0206E-02_JPRB,1.0614E-02_JPRB,1.0858E-02_JPRB,1.0462E-02_JPRB,&
&9.8456E-03_JPRB,8.3030E-03_JPRB,4.4090E-03_JPRB/)
KAO( :, 4, 1, 6) = (/&
&8.2237E-03_JPRB,9.8958E-03_JPRB,1.0796E-02_JPRB,1.1545E-02_JPRB,1.2099E-02_JPRB,1.2369E-02_JPRB,&
&1.2077E-02_JPRB,8.2237E-03_JPRB,5.3050E-03_JPRB/)
KAO( :, 5, 1, 6) = (/&
&8.1599E-03_JPRB,1.0181E-02_JPRB,1.1469E-02_JPRB,1.2490E-02_JPRB,1.3377E-02_JPRB,1.4165E-02_JPRB,&
&1.4318E-02_JPRB,8.1599E-03_JPRB,6.2987E-03_JPRB/)
KAO( :, 1, 2, 6) = (/&
&7.7094E-03_JPRB,8.1495E-03_JPRB,8.1817E-03_JPRB,7.9690E-03_JPRB,7.0574E-03_JPRB,4.6583E-03_JPRB,&
&5.9458E-03_JPRB,7.7094E-03_JPRB,2.1253E-03_JPRB/)
KAO( :, 2, 2, 6) = (/&
&7.6098E-03_JPRB,8.3857E-03_JPRB,8.6188E-03_JPRB,8.6202E-03_JPRB,8.3668E-03_JPRB,7.2354E-03_JPRB,&
&5.4614E-03_JPRB,7.6098E-03_JPRB,2.6911E-03_JPRB/)
KAO( :, 3, 2, 6) = (/&
&7.5380E-03_JPRB,8.6324E-03_JPRB,9.0696E-03_JPRB,9.3578E-03_JPRB,9.5323E-03_JPRB,9.1344E-03_JPRB,&
&8.4099E-03_JPRB,7.5380E-03_JPRB,3.3283E-03_JPRB/)
KAO( :, 4, 2, 6) = (/&
&7.4926E-03_JPRB,8.8750E-03_JPRB,9.5781E-03_JPRB,1.0164E-02_JPRB,1.0603E-02_JPRB,1.0755E-02_JPRB,&
&1.0378E-02_JPRB,7.4926E-03_JPRB,4.0288E-03_JPRB/)
KAO( :, 5, 2, 6) = (/&
&7.4775E-03_JPRB,9.1627E-03_JPRB,1.0156E-02_JPRB,1.0982E-02_JPRB,1.1695E-02_JPRB,1.2352E-02_JPRB,&
&1.2667E-02_JPRB,7.4775E-03_JPRB,4.8116E-03_JPRB/)
KAO( :, 1, 3, 6) = (/&
&6.9121E-03_JPRB,7.2188E-03_JPRB,7.1796E-03_JPRB,6.8889E-03_JPRB,5.8502E-03_JPRB,3.2278E-03_JPRB,&
&4.9879E-03_JPRB,6.9121E-03_JPRB,1.5160E-03_JPRB/)
KAO( :, 2, 3, 6) = (/&
&6.8480E-03_JPRB,7.4276E-03_JPRB,7.5203E-03_JPRB,7.4048E-03_JPRB,7.0014E-03_JPRB,5.7055E-03_JPRB,&
&4.3384E-03_JPRB,6.8480E-03_JPRB,1.9279E-03_JPRB/)
KAO( :, 3, 3, 6) = (/&
&6.8135E-03_JPRB,7.6493E-03_JPRB,7.8976E-03_JPRB,8.0141E-03_JPRB,8.0170E-03_JPRB,7.5441E-03_JPRB,&
&6.5174E-03_JPRB,6.8135E-03_JPRB,2.4028E-03_JPRB/)
KAO( :, 4, 3, 6) = (/&
&6.8122E-03_JPRB,7.8956E-03_JPRB,8.3131E-03_JPRB,8.6965E-03_JPRB,8.9952E-03_JPRB,8.9752E-03_JPRB,&
&8.4882E-03_JPRB,6.8122E-03_JPRB,2.9375E-03_JPRB/)
KAO( :, 5, 3, 6) = (/&
&6.8492E-03_JPRB,8.1657E-03_JPRB,8.7936E-03_JPRB,9.3904E-03_JPRB,9.9168E-03_JPRB,1.0345E-02_JPRB,&
&1.0484E-02_JPRB,6.8492E-03_JPRB,3.5390E-03_JPRB/)
KAO( :, 1, 4, 6) = (/&
&6.1397E-03_JPRB,6.3324E-03_JPRB,6.2269E-03_JPRB,5.8666E-03_JPRB,4.6601E-03_JPRB,2.6335E-03_JPRB,&
&4.3502E-03_JPRB,6.1397E-03_JPRB,1.0676E-03_JPRB/)
KAO( :, 2, 4, 6) = (/&
&6.1071E-03_JPRB,6.5281E-03_JPRB,6.5061E-03_JPRB,6.2987E-03_JPRB,5.7315E-03_JPRB,4.2122E-03_JPRB,&
&3.5243E-03_JPRB,6.1071E-03_JPRB,1.3674E-03_JPRB/)
KAO( :, 3, 4, 6) = (/&
&6.1173E-03_JPRB,6.7424E-03_JPRB,6.8351E-03_JPRB,6.7928E-03_JPRB,6.6355E-03_JPRB,6.0084E-03_JPRB,&
&4.4111E-03_JPRB,6.1173E-03_JPRB,1.7216E-03_JPRB/)
KAO( :, 4, 4, 6) = (/&
&6.1616E-03_JPRB,6.9850E-03_JPRB,7.2018E-03_JPRB,7.3533E-03_JPRB,7.4639E-03_JPRB,7.3054E-03_JPRB,&
&6.7355E-03_JPRB,6.1616E-03_JPRB,2.1295E-03_JPRB/)
KAO( :, 5, 4, 6) = (/&
&6.2327E-03_JPRB,7.2498E-03_JPRB,7.6166E-03_JPRB,7.9404E-03_JPRB,8.2799E-03_JPRB,8.5196E-03_JPRB,&
&8.4780E-03_JPRB,6.2327E-03_JPRB,2.5893E-03_JPRB/)
KAO( :, 1, 5, 6) = (/&
&5.4116E-03_JPRB,5.5054E-03_JPRB,5.3551E-03_JPRB,4.9387E-03_JPRB,3.4030E-03_JPRB,2.3925E-03_JPRB,&
&3.5026E-03_JPRB,5.4116E-03_JPRB,7.5991E-04_JPRB/)
KAO( :, 2, 5, 6) = (/&
&5.4112E-03_JPRB,5.7013E-03_JPRB,5.6024E-03_JPRB,5.3215E-03_JPRB,4.5735E-03_JPRB,2.7843E-03_JPRB,&
&3.3021E-03_JPRB,5.4112E-03_JPRB,9.7889E-04_JPRB/)
KAO( :, 3, 5, 6) = (/&
&5.4571E-03_JPRB,5.9124E-03_JPRB,5.8939E-03_JPRB,5.7468E-03_JPRB,5.4242E-03_JPRB,4.5784E-03_JPRB,&
&3.1711E-03_JPRB,5.4571E-03_JPRB,1.2420E-03_JPRB/)
KAO( :, 4, 5, 6) = (/&
&5.5303E-03_JPRB,6.1539E-03_JPRB,6.2322E-03_JPRB,6.2166E-03_JPRB,6.1395E-03_JPRB,5.8002E-03_JPRB,&
&5.0694E-03_JPRB,5.5303E-03_JPRB,1.5508E-03_JPRB/)
KAO( :, 5, 5, 6) = (/&
&5.6126E-03_JPRB,6.4231E-03_JPRB,6.6120E-03_JPRB,6.7193E-03_JPRB,6.8307E-03_JPRB,6.8747E-03_JPRB,&
&6.7129E-03_JPRB,5.6126E-03_JPRB,1.9069E-03_JPRB/)
KAO( :, 1, 6, 6) = (/&
&4.7396E-03_JPRB,4.7463E-03_JPRB,4.5518E-03_JPRB,4.0433E-03_JPRB,2.2638E-03_JPRB,2.3141E-03_JPRB,&
&2.8805E-03_JPRB,4.7396E-03_JPRB,5.6698E-04_JPRB/)
KAO( :, 2, 6, 6) = (/&
&4.7673E-03_JPRB,4.9357E-03_JPRB,4.7801E-03_JPRB,4.4457E-03_JPRB,3.5304E-03_JPRB,1.8920E-03_JPRB,&
&2.9747E-03_JPRB,4.7673E-03_JPRB,7.2146E-04_JPRB/)
KAO( :, 3, 6, 6) = (/&
&4.8326E-03_JPRB,5.1460E-03_JPRB,5.0538E-03_JPRB,4.8362E-03_JPRB,4.3455E-03_JPRB,3.2638E-03_JPRB,&
&2.4492E-03_JPRB,4.8326E-03_JPRB,9.1393E-04_JPRB/)
KAO( :, 4, 6, 6) = (/&
&4.9138E-03_JPRB,5.3898E-03_JPRB,5.3670E-03_JPRB,5.2448E-03_JPRB,5.0135E-03_JPRB,4.4890E-03_JPRB,&
&3.4781E-03_JPRB,4.9137E-03_JPRB,1.1441E-03_JPRB/)
KAO( :, 5, 6, 6) = (/&
&5.0007E-03_JPRB,5.6605E-03_JPRB,5.7246E-03_JPRB,5.6834E-03_JPRB,5.6159E-03_JPRB,5.4449E-03_JPRB,&
&5.0343E-03_JPRB,5.0007E-03_JPRB,1.4139E-03_JPRB/)
KAO( :, 1, 7, 6) = (/&
&4.1378E-03_JPRB,4.0754E-03_JPRB,3.8389E-03_JPRB,3.2475E-03_JPRB,1.4857E-03_JPRB,2.1025E-03_JPRB,&
&2.2984E-03_JPRB,4.1378E-03_JPRB,5.2481E-04_JPRB/)
KAO( :, 2, 7, 6) = (/&
&4.1822E-03_JPRB,4.2521E-03_JPRB,4.0570E-03_JPRB,3.6688E-03_JPRB,2.5306E-03_JPRB,1.4831E-03_JPRB,&
&2.6067E-03_JPRB,4.1822E-03_JPRB,6.3111E-04_JPRB/)
KAO( :, 3, 7, 6) = (/&
&4.2509E-03_JPRB,4.4583E-03_JPRB,4.3081E-03_JPRB,4.0486E-03_JPRB,3.4473E-03_JPRB,2.1091E-03_JPRB,&
&1.9768E-03_JPRB,4.2509E-03_JPRB,7.6397E-04_JPRB/)
KAO( :, 4, 7, 6) = (/&
&4.3334E-03_JPRB,4.6876E-03_JPRB,4.6037E-03_JPRB,4.4308E-03_JPRB,4.0651E-03_JPRB,3.3647E-03_JPRB,&
&2.1587E-03_JPRB,4.3334E-03_JPRB,9.2876E-04_JPRB/)
KAO( :, 5, 7, 6) = (/&
&4.4225E-03_JPRB,4.9342E-03_JPRB,4.9410E-03_JPRB,4.8191E-03_JPRB,4.6280E-03_JPRB,4.2870E-03_JPRB,&
&3.6120E-03_JPRB,4.4226E-03_JPRB,1.1252E-03_JPRB/)
KAO( :, 1, 8, 6) = (/&
&3.6094E-03_JPRB,3.5033E-03_JPRB,3.2400E-03_JPRB,2.6287E-03_JPRB,9.9863E-04_JPRB,1.7500E-03_JPRB,&
&1.8960E-03_JPRB,3.6094E-03_JPRB,8.2600E-04_JPRB/)
KAO( :, 2, 8, 6) = (/&
&3.6637E-03_JPRB,3.6642E-03_JPRB,3.4430E-03_JPRB,3.0211E-03_JPRB,1.7119E-03_JPRB,1.3558E-03_JPRB,&
&2.1462E-03_JPRB,3.6637E-03_JPRB,9.0812E-04_JPRB/)
KAO( :, 3, 8, 6) = (/&
&3.7354E-03_JPRB,3.8451E-03_JPRB,3.6742E-03_JPRB,3.3691E-03_JPRB,2.6819E-03_JPRB,1.3910E-03_JPRB,&
&1.9474E-03_JPRB,3.7354E-03_JPRB,1.0101E-03_JPRB/)
KAO( :, 4, 8, 6) = (/&
&3.8119E-03_JPRB,4.0509E-03_JPRB,3.9304E-03_JPRB,3.7228E-03_JPRB,3.3248E-03_JPRB,2.3768E-03_JPRB,&
&1.6650E-03_JPRB,3.8120E-03_JPRB,1.1353E-03_JPRB/)
KAO( :, 5, 8, 6) = (/&
&3.8974E-03_JPRB,4.2692E-03_JPRB,4.2189E-03_JPRB,4.0809E-03_JPRB,3.8147E-03_JPRB,3.3186E-03_JPRB,&
&2.4419E-03_JPRB,3.8974E-03_JPRB,1.2742E-03_JPRB/)
KAO( :, 1, 9, 6) = (/&
&3.1509E-03_JPRB,3.0135E-03_JPRB,2.7414E-03_JPRB,2.0848E-03_JPRB,8.0225E-04_JPRB,1.3860E-03_JPRB,&
&1.6095E-03_JPRB,3.1509E-03_JPRB,3.2874E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&3.2069E-03_JPRB,3.1552E-03_JPRB,2.9300E-03_JPRB,2.5120E-03_JPRB,1.1882E-03_JPRB,1.2244E-03_JPRB,&
&1.8134E-03_JPRB,3.2069E-03_JPRB,3.4426E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&3.2779E-03_JPRB,3.3142E-03_JPRB,3.1292E-03_JPRB,2.8177E-03_JPRB,2.0556E-03_JPRB,1.0032E-03_JPRB,&
&1.7964E-03_JPRB,3.2779E-03_JPRB,3.6002E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&3.3512E-03_JPRB,3.4918E-03_JPRB,3.3477E-03_JPRB,3.1214E-03_JPRB,2.7090E-03_JPRB,1.5625E-03_JPRB,&
&1.3565E-03_JPRB,3.3512E-03_JPRB,3.7586E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&3.4301E-03_JPRB,3.6852E-03_JPRB,3.5951E-03_JPRB,3.4314E-03_JPRB,3.1547E-03_JPRB,2.5504E-03_JPRB,&
&1.5207E-03_JPRB,3.4301E-03_JPRB,3.9312E-03_JPRB/)
KAO( :, 1,10, 6) = (/&
&2.7434E-03_JPRB,2.5990E-03_JPRB,2.3418E-03_JPRB,1.5988E-03_JPRB,7.7035E-04_JPRB,1.2159E-03_JPRB,&
&1.3978E-03_JPRB,2.7434E-03_JPRB,2.0046E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&2.7987E-03_JPRB,2.7245E-03_JPRB,2.5022E-03_JPRB,2.1126E-03_JPRB,8.9708E-04_JPRB,1.0763E-03_JPRB,&
&1.5093E-03_JPRB,2.7987E-03_JPRB,2.0516E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&2.8639E-03_JPRB,2.8623E-03_JPRB,2.6825E-03_JPRB,2.3837E-03_JPRB,1.5791E-03_JPRB,8.7614E-04_JPRB,&
&1.4149E-03_JPRB,2.8639E-03_JPRB,2.0938E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&2.9341E-03_JPRB,3.0198E-03_JPRB,2.8777E-03_JPRB,2.6425E-03_JPRB,2.2095E-03_JPRB,1.1197E-03_JPRB,&
&1.2062E-03_JPRB,2.9342E-03_JPRB,2.1345E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&3.0129E-03_JPRB,3.1899E-03_JPRB,3.0825E-03_JPRB,2.9045E-03_JPRB,2.6201E-03_JPRB,1.9654E-03_JPRB,&
&1.1926E-03_JPRB,3.0129E-03_JPRB,2.1744E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&2.3930E-03_JPRB,2.2760E-03_JPRB,2.0475E-03_JPRB,1.4917E-03_JPRB,6.1519E-04_JPRB,9.5739E-04_JPRB,&
&1.2117E-03_JPRB,2.3930E-03_JPRB,4.6010E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&2.4495E-03_JPRB,2.3897E-03_JPRB,2.1964E-03_JPRB,1.8774E-03_JPRB,8.8795E-04_JPRB,8.5785E-04_JPRB,&
&1.2212E-03_JPRB,2.4495E-03_JPRB,4.7118E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&2.5108E-03_JPRB,2.5149E-03_JPRB,2.3607E-03_JPRB,2.1179E-03_JPRB,1.5063E-03_JPRB,7.2487E-04_JPRB,&
&1.1617E-03_JPRB,2.5108E-03_JPRB,4.8044E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&2.5797E-03_JPRB,2.6613E-03_JPRB,2.5391E-03_JPRB,2.3353E-03_JPRB,1.9791E-03_JPRB,1.1049E-03_JPRB,&
&9.4883E-04_JPRB,2.5797E-03_JPRB,4.8805E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&2.6499E-03_JPRB,2.8182E-03_JPRB,2.7229E-03_JPRB,2.5580E-03_JPRB,2.3142E-03_JPRB,1.8079E-03_JPRB,&
&1.0035E-03_JPRB,2.6499E-03_JPRB,4.9391E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&2.0746E-03_JPRB,1.9783E-03_JPRB,1.7801E-03_JPRB,1.3556E-03_JPRB,4.8267E-04_JPRB,8.1463E-04_JPRB,&
&1.0185E-03_JPRB,2.0746E-03_JPRB,6.7547E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&2.1273E-03_JPRB,2.0770E-03_JPRB,1.9105E-03_JPRB,1.6481E-03_JPRB,8.3724E-04_JPRB,7.1683E-04_JPRB,&
&1.0103E-03_JPRB,2.1273E-03_JPRB,6.9266E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&2.1844E-03_JPRB,2.1915E-03_JPRB,2.0594E-03_JPRB,1.8587E-03_JPRB,1.3892E-03_JPRB,6.4751E-04_JPRB,&
&9.5728E-04_JPRB,2.1844E-03_JPRB,7.0619E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&2.2441E-03_JPRB,2.3226E-03_JPRB,2.2206E-03_JPRB,2.0453E-03_JPRB,1.7491E-03_JPRB,1.0405E-03_JPRB,&
&7.8138E-04_JPRB,2.2441E-03_JPRB,7.1602E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&2.3050E-03_JPRB,2.4598E-03_JPRB,2.3822E-03_JPRB,2.2381E-03_JPRB,2.0304E-03_JPRB,1.6325E-03_JPRB,&
&9.2438E-04_JPRB,2.3050E-03_JPRB,7.2303E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&1.7883E-03_JPRB,1.7065E-03_JPRB,1.5374E-03_JPRB,1.2007E-03_JPRB,4.3025E-04_JPRB,6.7590E-04_JPRB,&
&8.1885E-04_JPRB,1.7883E-03_JPRB,7.9860E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&1.8363E-03_JPRB,1.7948E-03_JPRB,1.6528E-03_JPRB,1.4324E-03_JPRB,7.6774E-04_JPRB,6.2246E-04_JPRB,&
&8.1329E-04_JPRB,1.8363E-03_JPRB,8.1807E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&1.8869E-03_JPRB,1.8960E-03_JPRB,1.7818E-03_JPRB,1.6095E-03_JPRB,1.2397E-03_JPRB,5.6950E-04_JPRB,&
&8.2318E-04_JPRB,1.8869E-03_JPRB,8.3291E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&1.9378E-03_JPRB,2.0074E-03_JPRB,1.9206E-03_JPRB,1.7755E-03_JPRB,1.5322E-03_JPRB,9.5845E-04_JPRB,&
&6.9708E-04_JPRB,1.9378E-03_JPRB,8.4416E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.9900E-03_JPRB,2.1258E-03_JPRB,2.0644E-03_JPRB,1.9405E-03_JPRB,1.7651E-03_JPRB,1.4419E-03_JPRB,&
&8.3688E-04_JPRB,1.9900E-03_JPRB,8.5292E-02_JPRB/)
KAO( :, 1, 1, 7) = (/&
&1.6473E-02_JPRB,1.6639E-02_JPRB,1.6620E-02_JPRB,1.6044E-02_JPRB,1.5024E-02_JPRB,1.3187E-02_JPRB,&
&7.6213E-03_JPRB,1.6473E-02_JPRB,5.9369E-03_JPRB/)
KAO( :, 2, 1, 7) = (/&
&1.6283E-02_JPRB,1.7319E-02_JPRB,1.7601E-02_JPRB,1.7371E-02_JPRB,1.6714E-02_JPRB,1.5606E-02_JPRB,&
&1.2675E-02_JPRB,1.6283E-02_JPRB,7.5309E-03_JPRB/)
KAO( :, 3, 1, 7) = (/&
&1.6044E-02_JPRB,1.7939E-02_JPRB,1.8616E-02_JPRB,1.8736E-02_JPRB,1.8509E-02_JPRB,1.7932E-02_JPRB,&
&1.6316E-02_JPRB,1.6044E-02_JPRB,9.3034E-03_JPRB/)
KAO( :, 4, 1, 7) = (/&
&1.5780E-02_JPRB,1.8566E-02_JPRB,1.9707E-02_JPRB,2.0218E-02_JPRB,2.0468E-02_JPRB,2.0392E-02_JPRB,&
&2.0221E-02_JPRB,1.5780E-02_JPRB,1.1241E-02_JPRB/)
KAO( :, 5, 1, 7) = (/&
&1.5514E-02_JPRB,1.9239E-02_JPRB,2.0866E-02_JPRB,2.1848E-02_JPRB,2.2518E-02_JPRB,2.2938E-02_JPRB,&
&2.4338E-02_JPRB,1.5514E-02_JPRB,1.3369E-02_JPRB/)
KAO( :, 1, 2, 7) = (/&
&1.5534E-02_JPRB,1.5698E-02_JPRB,1.5655E-02_JPRB,1.5068E-02_JPRB,1.4135E-02_JPRB,1.2270E-02_JPRB,&
&7.4181E-03_JPRB,1.5534E-02_JPRB,4.4640E-03_JPRB/)
KAO( :, 2, 2, 7) = (/&
&1.5342E-02_JPRB,1.6324E-02_JPRB,1.6590E-02_JPRB,1.6353E-02_JPRB,1.5831E-02_JPRB,1.4815E-02_JPRB,&
&1.2543E-02_JPRB,1.5342E-02_JPRB,5.6970E-03_JPRB/)
KAO( :, 3, 2, 7) = (/&
&1.5098E-02_JPRB,1.6904E-02_JPRB,1.7545E-02_JPRB,1.7691E-02_JPRB,1.7497E-02_JPRB,1.7085E-02_JPRB,&
&1.5776E-02_JPRB,1.5098E-02_JPRB,7.0876E-03_JPRB/)
KAO( :, 4, 2, 7) = (/&
&1.4834E-02_JPRB,1.7491E-02_JPRB,1.8583E-02_JPRB,1.9136E-02_JPRB,1.9381E-02_JPRB,1.9396E-02_JPRB,&
&1.8919E-02_JPRB,1.4834E-02_JPRB,8.6392E-03_JPRB/)
KAO( :, 5, 2, 7) = (/&
&1.4582E-02_JPRB,1.8087E-02_JPRB,1.9710E-02_JPRB,2.0699E-02_JPRB,2.1415E-02_JPRB,2.1844E-02_JPRB,&
&2.2101E-02_JPRB,1.4582E-02_JPRB,1.0344E-02_JPRB/)
KAO( :, 1, 3, 7) = (/&
&1.4379E-02_JPRB,1.4400E-02_JPRB,1.4273E-02_JPRB,1.3714E-02_JPRB,1.2774E-02_JPRB,1.0758E-02_JPRB,&
&5.9221E-03_JPRB,1.4379E-02_JPRB,3.1627E-03_JPRB/)
KAO( :, 2, 3, 7) = (/&
&1.4181E-02_JPRB,1.4962E-02_JPRB,1.5204E-02_JPRB,1.4906E-02_JPRB,1.4357E-02_JPRB,1.3275E-02_JPRB,&
&1.0750E-02_JPRB,1.4181E-02_JPRB,4.0720E-03_JPRB/)
KAO( :, 3, 3, 7) = (/&
&1.3955E-02_JPRB,1.5485E-02_JPRB,1.6078E-02_JPRB,1.6124E-02_JPRB,1.5928E-02_JPRB,1.5419E-02_JPRB,&
&1.4145E-02_JPRB,1.3955E-02_JPRB,5.1227E-03_JPRB/)
KAO( :, 4, 3, 7) = (/&
&1.3715E-02_JPRB,1.6019E-02_JPRB,1.7011E-02_JPRB,1.7443E-02_JPRB,1.7601E-02_JPRB,1.7599E-02_JPRB,&
&1.7151E-02_JPRB,1.3715E-02_JPRB,6.3251E-03_JPRB/)
KAO( :, 5, 3, 7) = (/&
&1.3488E-02_JPRB,1.6566E-02_JPRB,1.8015E-02_JPRB,1.8885E-02_JPRB,1.9466E-02_JPRB,1.9880E-02_JPRB,&
&1.9891E-02_JPRB,1.3488E-02_JPRB,7.6362E-03_JPRB/)
KAO( :, 1, 4, 7) = (/&
&1.3100E-02_JPRB,1.2948E-02_JPRB,1.2709E-02_JPRB,1.2152E-02_JPRB,1.1211E-02_JPRB,8.9540E-03_JPRB,&
&3.9235E-03_JPRB,1.3100E-02_JPRB,2.2077E-03_JPRB/)
KAO( :, 2, 4, 7) = (/&
&1.2922E-02_JPRB,1.3421E-02_JPRB,1.3563E-02_JPRB,1.3273E-02_JPRB,1.2687E-02_JPRB,1.1465E-02_JPRB,&
&8.5932E-03_JPRB,1.2922E-02_JPRB,2.8908E-03_JPRB/)
KAO( :, 3, 4, 7) = (/&
&1.2710E-02_JPRB,1.3886E-02_JPRB,1.4373E-02_JPRB,1.4371E-02_JPRB,1.4080E-02_JPRB,1.3407E-02_JPRB,&
&1.1985E-02_JPRB,1.2710E-02_JPRB,3.6760E-03_JPRB/)
KAO( :, 4, 4, 7) = (/&
&1.2510E-02_JPRB,1.4373E-02_JPRB,1.5200E-02_JPRB,1.5503E-02_JPRB,1.5542E-02_JPRB,1.5364E-02_JPRB,&
&1.4835E-02_JPRB,1.2510E-02_JPRB,4.5891E-03_JPRB/)
KAO( :, 5, 4, 7) = (/&
&1.2325E-02_JPRB,1.4885E-02_JPRB,1.6099E-02_JPRB,1.6758E-02_JPRB,1.7169E-02_JPRB,1.7435E-02_JPRB,&
&1.7471E-02_JPRB,1.2325E-02_JPRB,5.6179E-03_JPRB/)
KAO( :, 1, 5, 7) = (/&
&1.1785E-02_JPRB,1.1507E-02_JPRB,1.1168E-02_JPRB,1.0600E-02_JPRB,9.6507E-03_JPRB,6.9414E-03_JPRB,&
&2.9345E-03_JPRB,1.1785E-02_JPRB,1.5496E-03_JPRB/)
KAO( :, 2, 5, 7) = (/&
&1.1618E-02_JPRB,1.1886E-02_JPRB,1.1906E-02_JPRB,1.1601E-02_JPRB,1.1008E-02_JPRB,9.7482E-03_JPRB,&
&6.3716E-03_JPRB,1.1618E-02_JPRB,2.0513E-03_JPRB/)
KAO( :, 3, 5, 7) = (/&
&1.1447E-02_JPRB,1.2288E-02_JPRB,1.2620E-02_JPRB,1.2540E-02_JPRB,1.2196E-02_JPRB,1.1475E-02_JPRB,&
&9.8448E-03_JPRB,1.1447E-02_JPRB,2.6474E-03_JPRB/)
KAO( :, 4, 5, 7) = (/&
&1.1293E-02_JPRB,1.2719E-02_JPRB,1.3350E-02_JPRB,1.3509E-02_JPRB,1.3472E-02_JPRB,1.3207E-02_JPRB,&
&1.2517E-02_JPRB,1.1293E-02_JPRB,3.3414E-03_JPRB/)
KAO( :, 5, 5, 7) = (/&
&1.1183E-02_JPRB,1.3178E-02_JPRB,1.4123E-02_JPRB,1.4583E-02_JPRB,1.4883E-02_JPRB,1.5015E-02_JPRB,&
&1.4926E-02_JPRB,1.1183E-02_JPRB,4.1312E-03_JPRB/)
KAO( :, 1, 6, 7) = (/&
&1.0487E-02_JPRB,1.0124E-02_JPRB,9.7249E-03_JPRB,9.1457E-03_JPRB,8.1285E-03_JPRB,4.8996E-03_JPRB,&
&1.9678E-03_JPRB,1.0487E-02_JPRB,1.0937E-03_JPRB/)
KAO( :, 2, 6, 7) = (/&
&1.0349E-02_JPRB,1.0437E-02_JPRB,1.0332E-02_JPRB,9.9754E-03_JPRB,9.2866E-03_JPRB,7.9160E-03_JPRB,&
&4.3878E-03_JPRB,1.0349E-02_JPRB,1.4598E-03_JPRB/)
KAO( :, 3, 6, 7) = (/&
&1.0220E-02_JPRB,1.0784E-02_JPRB,1.0929E-02_JPRB,1.0753E-02_JPRB,1.0353E-02_JPRB,9.5432E-03_JPRB,&
&7.8232E-03_JPRB,1.0220E-02_JPRB,1.9008E-03_JPRB/)
KAO( :, 4, 6, 7) = (/&
&1.0135E-02_JPRB,1.1143E-02_JPRB,1.1530E-02_JPRB,1.1576E-02_JPRB,1.1439E-02_JPRB,1.1088E-02_JPRB,&
&1.0277E-02_JPRB,1.0135E-02_JPRB,2.4221E-03_JPRB/)
KAO( :, 5, 6, 7) = (/&
&1.0102E-02_JPRB,1.1554E-02_JPRB,1.2194E-02_JPRB,1.2480E-02_JPRB,1.2652E-02_JPRB,1.2678E-02_JPRB,&
&1.2494E-02_JPRB,1.0102E-02_JPRB,3.0257E-03_JPRB/)
KAO( :, 1, 7, 7) = (/&
&9.2309E-03_JPRB,8.8319E-03_JPRB,8.3968E-03_JPRB,7.7952E-03_JPRB,6.7475E-03_JPRB,3.2870E-03_JPRB,&
&1.9179E-03_JPRB,9.2309E-03_JPRB,8.9645E-04_JPRB/)
KAO( :, 2, 7, 7) = (/&
&9.1242E-03_JPRB,9.0932E-03_JPRB,8.9046E-03_JPRB,8.4994E-03_JPRB,7.7737E-03_JPRB,6.2095E-03_JPRB,&
&2.8211E-03_JPRB,9.1242E-03_JPRB,1.1346E-03_JPRB/)
KAO( :, 3, 7, 7) = (/&
&9.0499E-03_JPRB,9.3880E-03_JPRB,9.3912E-03_JPRB,9.1437E-03_JPRB,8.6640E-03_JPRB,7.8059E-03_JPRB,&
&5.8358E-03_JPRB,9.0499E-03_JPRB,1.4379E-03_JPRB/)
KAO( :, 4, 7, 7) = (/&
&9.0319E-03_JPRB,9.7281E-03_JPRB,9.8888E-03_JPRB,9.8240E-03_JPRB,9.6043E-03_JPRB,9.1535E-03_JPRB,&
&8.2625E-03_JPRB,9.0319E-03_JPRB,1.8162E-03_JPRB/)
KAO( :, 5, 7, 7) = (/&
&9.0677E-03_JPRB,1.0114E-02_JPRB,1.0453E-02_JPRB,1.0590E-02_JPRB,1.0614E-02_JPRB,1.0515E-02_JPRB,&
&1.0212E-02_JPRB,9.0678E-03_JPRB,2.2700E-03_JPRB/)
KAO( :, 1, 8, 7) = (/&
&8.0750E-03_JPRB,7.6623E-03_JPRB,7.2138E-03_JPRB,6.5975E-03_JPRB,5.4257E-03_JPRB,2.2723E-03_JPRB,&
&1.6249E-03_JPRB,8.0750E-03_JPRB,1.2831E-03_JPRB/)
KAO( :, 2, 8, 7) = (/&
&7.9997E-03_JPRB,7.8793E-03_JPRB,7.6227E-03_JPRB,7.1817E-03_JPRB,6.4216E-03_JPRB,4.5366E-03_JPRB,&
&1.9736E-03_JPRB,7.9997E-03_JPRB,1.4497E-03_JPRB/)
KAO( :, 3, 8, 7) = (/&
&7.9739E-03_JPRB,8.1496E-03_JPRB,8.0220E-03_JPRB,7.7220E-03_JPRB,7.1874E-03_JPRB,6.2455E-03_JPRB,&
&3.8530E-03_JPRB,7.9739E-03_JPRB,1.6552E-03_JPRB/)
KAO( :, 4, 8, 7) = (/&
&8.0128E-03_JPRB,8.4694E-03_JPRB,8.4614E-03_JPRB,8.2951E-03_JPRB,7.9668E-03_JPRB,7.4368E-03_JPRB,&
&6.3444E-03_JPRB,8.0128E-03_JPRB,1.8965E-03_JPRB/)
KAO( :, 5, 8, 7) = (/&
&8.1136E-03_JPRB,8.8341E-03_JPRB,8.9710E-03_JPRB,8.9459E-03_JPRB,8.8203E-03_JPRB,8.6006E-03_JPRB,&
&8.1402E-03_JPRB,8.1136E-03_JPRB,2.1909E-03_JPRB/)
KAO( :, 1, 9, 7) = (/&
&7.0296E-03_JPRB,6.6308E-03_JPRB,6.1804E-03_JPRB,5.5360E-03_JPRB,4.1437E-03_JPRB,1.5632E-03_JPRB,&
&1.4348E-03_JPRB,7.0296E-03_JPRB,5.0746E-03_JPRB/)
KAO( :, 2, 9, 7) = (/&
&6.9891E-03_JPRB,6.8154E-03_JPRB,6.5047E-03_JPRB,6.0126E-03_JPRB,5.1664E-03_JPRB,3.1309E-03_JPRB,&
&1.3440E-03_JPRB,6.9891E-03_JPRB,5.2575E-03_JPRB/)
KAO( :, 3, 9, 7) = (/&
&7.0047E-03_JPRB,7.0682E-03_JPRB,6.8401E-03_JPRB,6.4671E-03_JPRB,5.8881E-03_JPRB,4.8032E-03_JPRB,&
&2.4408E-03_JPRB,7.0047E-03_JPRB,5.4725E-03_JPRB/)
KAO( :, 4, 9, 7) = (/&
&7.0937E-03_JPRB,7.3642E-03_JPRB,7.2266E-03_JPRB,6.9602E-03_JPRB,6.5505E-03_JPRB,5.9472E-03_JPRB,&
&4.6225E-03_JPRB,7.0937E-03_JPRB,5.7075E-03_JPRB/)
KAO( :, 5, 9, 7) = (/&
&7.2359E-03_JPRB,7.7189E-03_JPRB,7.6898E-03_JPRB,7.5393E-03_JPRB,7.2796E-03_JPRB,6.9540E-03_JPRB,&
&6.3115E-03_JPRB,7.2359E-03_JPRB,5.9395E-03_JPRB/)
KAO( :, 1,10, 7) = (/&
&6.0824E-03_JPRB,5.7201E-03_JPRB,5.2950E-03_JPRB,4.6533E-03_JPRB,3.1243E-03_JPRB,1.0849E-03_JPRB,&
&1.3514E-03_JPRB,6.0824E-03_JPRB,3.2036E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&6.0816E-03_JPRB,5.8999E-03_JPRB,5.5711E-03_JPRB,5.0543E-03_JPRB,4.1674E-03_JPRB,2.1951E-03_JPRB,&
&1.1513E-03_JPRB,6.0816E-03_JPRB,3.2646E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&6.1454E-03_JPRB,6.1496E-03_JPRB,5.8546E-03_JPRB,5.4437E-03_JPRB,4.8180E-03_JPRB,3.6424E-03_JPRB,&
&1.7330E-03_JPRB,6.1454E-03_JPRB,3.3079E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&6.2758E-03_JPRB,6.4382E-03_JPRB,6.1991E-03_JPRB,5.8783E-03_JPRB,5.4350E-03_JPRB,4.7237E-03_JPRB,&
&3.2810E-03_JPRB,6.2757E-03_JPRB,3.3401E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&6.4344E-03_JPRB,6.7774E-03_JPRB,6.6295E-03_JPRB,6.3941E-03_JPRB,6.0678E-03_JPRB,5.6397E-03_JPRB,&
&4.8978E-03_JPRB,6.4344E-03_JPRB,3.3652E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&5.2811E-03_JPRB,5.0055E-03_JPRB,4.6335E-03_JPRB,4.0757E-03_JPRB,2.8727E-03_JPRB,1.0865E-03_JPRB,&
&1.0171E-03_JPRB,5.2811E-03_JPRB,7.6840E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&5.3409E-03_JPRB,5.2140E-03_JPRB,4.8806E-03_JPRB,4.4140E-03_JPRB,3.6622E-03_JPRB,2.0302E-03_JPRB,&
&9.1811E-04_JPRB,5.3409E-03_JPRB,7.7870E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&5.4674E-03_JPRB,5.4758E-03_JPRB,5.1638E-03_JPRB,4.7679E-03_JPRB,4.2203E-03_JPRB,3.2247E-03_JPRB,&
&1.5980E-03_JPRB,5.4674E-03_JPRB,7.8594E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&5.6175E-03_JPRB,5.7677E-03_JPRB,5.5092E-03_JPRB,5.1897E-03_JPRB,4.7728E-03_JPRB,4.1267E-03_JPRB,&
&2.9888E-03_JPRB,5.6175E-03_JPRB,7.8959E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&5.7848E-03_JPRB,6.0885E-03_JPRB,5.9189E-03_JPRB,5.6782E-03_JPRB,5.3431E-03_JPRB,4.9223E-03_JPRB,&
&4.2500E-03_JPRB,5.7848E-03_JPRB,7.9148E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&4.6406E-03_JPRB,4.4264E-03_JPRB,4.0750E-03_JPRB,3.5822E-03_JPRB,2.6510E-03_JPRB,1.0132E-03_JPRB,&
&9.2156E-04_JPRB,4.6406E-03_JPRB,1.1768E-01_JPRB/)
KAO( :, 2,12, 7) = (/&
&4.7513E-03_JPRB,4.6501E-03_JPRB,4.3133E-03_JPRB,3.8811E-03_JPRB,3.2507E-03_JPRB,1.8501E-03_JPRB,&
&7.3924E-04_JPRB,4.7513E-03_JPRB,1.1892E-01_JPRB/)
KAO( :, 3,12, 7) = (/&
&4.8892E-03_JPRB,4.8966E-03_JPRB,4.5920E-03_JPRB,4.2162E-03_JPRB,3.7357E-03_JPRB,2.9015E-03_JPRB,&
&1.4402E-03_JPRB,4.8892E-03_JPRB,1.1988E-01_JPRB/)
KAO( :, 4,12, 7) = (/&
&5.0434E-03_JPRB,5.1649E-03_JPRB,4.9117E-03_JPRB,4.6087E-03_JPRB,4.2340E-03_JPRB,3.6743E-03_JPRB,&
&2.6652E-03_JPRB,5.0434E-03_JPRB,1.2040E-01_JPRB/)
KAO( :, 5,12, 7) = (/&
&5.1943E-03_JPRB,5.4604E-03_JPRB,5.2859E-03_JPRB,5.0532E-03_JPRB,4.7466E-03_JPRB,4.3367E-03_JPRB,&
&3.6758E-03_JPRB,5.1943E-03_JPRB,1.2066E-01_JPRB/)
KAO( :, 1,13, 7) = (/&
&4.1040E-03_JPRB,3.9320E-03_JPRB,3.6016E-03_JPRB,3.1660E-03_JPRB,2.4198E-03_JPRB,9.6006E-04_JPRB,&
&7.4336E-04_JPRB,4.1040E-03_JPRB,1.4478E-01_JPRB/)
KAO( :, 2,13, 7) = (/&
&4.2232E-03_JPRB,4.1425E-03_JPRB,3.8331E-03_JPRB,3.4407E-03_JPRB,2.9046E-03_JPRB,1.6979E-03_JPRB,&
&6.7921E-04_JPRB,4.2232E-03_JPRB,1.4623E-01_JPRB/)
KAO( :, 3,13, 7) = (/&
&4.3611E-03_JPRB,4.3698E-03_JPRB,4.0899E-03_JPRB,3.7461E-03_JPRB,3.3273E-03_JPRB,2.6603E-03_JPRB,&
&1.2963E-03_JPRB,4.3611E-03_JPRB,1.4748E-01_JPRB/)
KAO( :, 4,13, 7) = (/&
&4.4992E-03_JPRB,4.6148E-03_JPRB,4.3841E-03_JPRB,4.0963E-03_JPRB,3.7570E-03_JPRB,3.2859E-03_JPRB,&
&2.3687E-03_JPRB,4.4992E-03_JPRB,1.4817E-01_JPRB/)
KAO( :, 5,13, 7) = (/&
&4.6327E-03_JPRB,4.8729E-03_JPRB,4.7086E-03_JPRB,4.4884E-03_JPRB,4.2102E-03_JPRB,3.8391E-03_JPRB,&
&3.2592E-03_JPRB,4.6327E-03_JPRB,1.4848E-01_JPRB/)
KAO( :, 1, 1, 8) = (/&
&3.2446E-02_JPRB,3.0961E-02_JPRB,2.9943E-02_JPRB,2.8814E-02_JPRB,2.6701E-02_JPRB,2.3826E-02_JPRB,&
&2.0786E-02_JPRB,3.2446E-02_JPRB,1.5676E-02_JPRB/)
KAO( :, 2, 1, 8) = (/&
&3.2527E-02_JPRB,3.1848E-02_JPRB,3.1994E-02_JPRB,3.1175E-02_JPRB,2.9719E-02_JPRB,2.8532E-02_JPRB,&
&2.8157E-02_JPRB,3.2527E-02_JPRB,2.0060E-02_JPRB/)
KAO( :, 3, 1, 8) = (/&
&3.2555E-02_JPRB,3.3035E-02_JPRB,3.4009E-02_JPRB,3.3632E-02_JPRB,3.3098E-02_JPRB,3.4035E-02_JPRB,&
&3.6093E-02_JPRB,3.2555E-02_JPRB,2.5319E-02_JPRB/)
KAO( :, 4, 1, 8) = (/&
&3.2520E-02_JPRB,3.4424E-02_JPRB,3.5893E-02_JPRB,3.6221E-02_JPRB,3.7173E-02_JPRB,4.0037E-02_JPRB,&
&4.3790E-02_JPRB,3.2520E-02_JPRB,3.1444E-02_JPRB/)
KAO( :, 5, 1, 8) = (/&
&3.2436E-02_JPRB,3.5761E-02_JPRB,3.7828E-02_JPRB,3.9167E-02_JPRB,4.2081E-02_JPRB,4.6777E-02_JPRB,&
&5.1699E-02_JPRB,3.2436E-02_JPRB,3.8339E-02_JPRB/)
KAO( :, 1, 2, 8) = (/&
&3.3259E-02_JPRB,3.1637E-02_JPRB,3.0502E-02_JPRB,2.9322E-02_JPRB,2.7192E-02_JPRB,2.4045E-02_JPRB,&
&1.9418E-02_JPRB,3.3259E-02_JPRB,1.2401E-02_JPRB/)
KAO( :, 2, 2, 8) = (/&
&3.3309E-02_JPRB,3.2542E-02_JPRB,3.2579E-02_JPRB,3.1869E-02_JPRB,3.0109E-02_JPRB,2.7900E-02_JPRB,&
&2.5530E-02_JPRB,3.3309E-02_JPRB,1.5971E-02_JPRB/)
KAO( :, 3, 2, 8) = (/&
&3.3352E-02_JPRB,3.3755E-02_JPRB,3.4718E-02_JPRB,3.4392E-02_JPRB,3.3246E-02_JPRB,3.2250E-02_JPRB,&
&3.2349E-02_JPRB,3.3352E-02_JPRB,2.0278E-02_JPRB/)
KAO( :, 4, 2, 8) = (/&
&3.3330E-02_JPRB,3.5174E-02_JPRB,3.6737E-02_JPRB,3.6916E-02_JPRB,3.6641E-02_JPRB,3.7274E-02_JPRB,&
&3.9441E-02_JPRB,3.3330E-02_JPRB,2.5234E-02_JPRB/)
KAO( :, 5, 2, 8) = (/&
&3.3226E-02_JPRB,3.6569E-02_JPRB,3.8777E-02_JPRB,3.9713E-02_JPRB,4.0596E-02_JPRB,4.2979E-02_JPRB,&
&4.7032E-02_JPRB,3.3226E-02_JPRB,3.0759E-02_JPRB/)
KAO( :, 1, 3, 8) = (/&
&3.3391E-02_JPRB,3.1594E-02_JPRB,3.0176E-02_JPRB,2.8739E-02_JPRB,2.6633E-02_JPRB,2.3336E-02_JPRB,&
&1.8177E-02_JPRB,3.3391E-02_JPRB,9.1438E-03_JPRB/)
KAO( :, 2, 3, 8) = (/&
&3.3463E-02_JPRB,3.2445E-02_JPRB,3.2154E-02_JPRB,3.1362E-02_JPRB,2.9626E-02_JPRB,2.6963E-02_JPRB,&
&2.3198E-02_JPRB,3.3463E-02_JPRB,1.1964E-02_JPRB/)
KAO( :, 3, 3, 8) = (/&
&3.3507E-02_JPRB,3.3666E-02_JPRB,3.4348E-02_JPRB,3.4020E-02_JPRB,3.2664E-02_JPRB,3.0729E-02_JPRB,&
&2.8675E-02_JPRB,3.3507E-02_JPRB,1.5312E-02_JPRB/)
KAO( :, 4, 3, 8) = (/&
&3.3484E-02_JPRB,3.5076E-02_JPRB,3.6460E-02_JPRB,3.6685E-02_JPRB,3.5851E-02_JPRB,3.4760E-02_JPRB,&
&3.4446E-02_JPRB,3.3484E-02_JPRB,1.9144E-02_JPRB/)
KAO( :, 5, 3, 8) = (/&
&3.3365E-02_JPRB,3.6491E-02_JPRB,3.8546E-02_JPRB,3.9400E-02_JPRB,3.9309E-02_JPRB,3.9340E-02_JPRB,&
&4.1039E-02_JPRB,3.3365E-02_JPRB,2.3426E-02_JPRB/)
KAO( :, 1, 4, 8) = (/&
&3.2823E-02_JPRB,3.0856E-02_JPRB,2.9216E-02_JPRB,2.7536E-02_JPRB,2.5263E-02_JPRB,2.2005E-02_JPRB,&
&1.7126E-02_JPRB,3.2823E-02_JPRB,6.4847E-03_JPRB/)
KAO( :, 2, 4, 8) = (/&
&3.2916E-02_JPRB,3.1703E-02_JPRB,3.1081E-02_JPRB,3.0059E-02_JPRB,2.8252E-02_JPRB,2.5566E-02_JPRB,&
&2.1643E-02_JPRB,3.2916E-02_JPRB,8.6411E-03_JPRB/)
KAO( :, 3, 4, 8) = (/&
&3.2942E-02_JPRB,3.2855E-02_JPRB,3.3172E-02_JPRB,3.2679E-02_JPRB,3.1442E-02_JPRB,2.9283E-02_JPRB,&
&2.6180E-02_JPRB,3.2942E-02_JPRB,1.1256E-02_JPRB/)
KAO( :, 4, 4, 8) = (/&
&3.2895E-02_JPRB,3.4207E-02_JPRB,3.5261E-02_JPRB,3.5386E-02_JPRB,3.4683E-02_JPRB,3.2992E-02_JPRB,&
&3.0830E-02_JPRB,3.2895E-02_JPRB,1.4266E-02_JPRB/)
KAO( :, 5, 4, 8) = (/&
&3.2791E-02_JPRB,3.5598E-02_JPRB,3.7342E-02_JPRB,3.8144E-02_JPRB,3.7958E-02_JPRB,3.6915E-02_JPRB,&
&3.6060E-02_JPRB,3.2791E-02_JPRB,1.7623E-02_JPRB/)
KAO( :, 1, 5, 8) = (/&
&3.1527E-02_JPRB,2.9441E-02_JPRB,2.7666E-02_JPRB,2.5800E-02_JPRB,2.3517E-02_JPRB,2.0290E-02_JPRB,&
&1.5284E-02_JPRB,3.1527E-02_JPRB,4.5483E-03_JPRB/)
KAO( :, 2, 5, 8) = (/&
&3.1627E-02_JPRB,3.0253E-02_JPRB,2.9410E-02_JPRB,2.8191E-02_JPRB,2.6385E-02_JPRB,2.3754E-02_JPRB,&
&1.9782E-02_JPRB,3.1627E-02_JPRB,6.1662E-03_JPRB/)
KAO( :, 3, 5, 8) = (/&
&3.1653E-02_JPRB,3.1374E-02_JPRB,3.1394E-02_JPRB,3.0704E-02_JPRB,2.9499E-02_JPRB,2.7410E-02_JPRB,&
&2.4207E-02_JPRB,3.1653E-02_JPRB,8.1447E-03_JPRB/)
KAO( :, 4, 5, 8) = (/&
&3.1587E-02_JPRB,3.2681E-02_JPRB,3.3373E-02_JPRB,3.3364E-02_JPRB,3.2711E-02_JPRB,3.1061E-02_JPRB,&
&2.8366E-02_JPRB,3.1587E-02_JPRB,1.0460E-02_JPRB/)
KAO( :, 5, 5, 8) = (/&
&3.1459E-02_JPRB,3.4035E-02_JPRB,3.5391E-02_JPRB,3.6063E-02_JPRB,3.5941E-02_JPRB,3.4747E-02_JPRB,&
&3.2643E-02_JPRB,3.1459E-02_JPRB,1.3095E-02_JPRB/)
KAO( :, 1, 6, 8) = (/&
&2.9690E-02_JPRB,2.7513E-02_JPRB,2.5633E-02_JPRB,2.3605E-02_JPRB,2.1298E-02_JPRB,1.8147E-02_JPRB,&
&1.3146E-02_JPRB,2.9690E-02_JPRB,3.1369E-03_JPRB/)
KAO( :, 2, 6, 8) = (/&
&2.9770E-02_JPRB,2.8288E-02_JPRB,2.7183E-02_JPRB,2.5789E-02_JPRB,2.4036E-02_JPRB,2.1561E-02_JPRB,&
&1.7543E-02_JPRB,2.9770E-02_JPRB,4.3187E-03_JPRB/)
KAO( :, 3, 6, 8) = (/&
&2.9783E-02_JPRB,2.9294E-02_JPRB,2.9045E-02_JPRB,2.8192E-02_JPRB,2.6960E-02_JPRB,2.5034E-02_JPRB,&
&2.1858E-02_JPRB,2.9783E-02_JPRB,5.7867E-03_JPRB/)
KAO( :, 4, 6, 8) = (/&
&2.9692E-02_JPRB,3.0523E-02_JPRB,3.0946E-02_JPRB,3.0715E-02_JPRB,3.0007E-02_JPRB,2.8497E-02_JPRB,&
&2.5800E-02_JPRB,2.9692E-02_JPRB,7.5502E-03_JPRB/)
KAO( :, 5, 6, 8) = (/&
&2.9534E-02_JPRB,3.1783E-02_JPRB,3.2869E-02_JPRB,3.3262E-02_JPRB,3.3064E-02_JPRB,3.1999E-02_JPRB,&
&2.9755E-02_JPRB,2.9534E-02_JPRB,9.5800E-03_JPRB/)
KAO( :, 1, 7, 8) = (/&
&2.7399E-02_JPRB,2.5219E-02_JPRB,2.3318E-02_JPRB,2.1250E-02_JPRB,1.8905E-02_JPRB,1.5866E-02_JPRB,&
&1.0211E-02_JPRB,2.7399E-02_JPRB,2.2133E-03_JPRB/)
KAO( :, 2, 7, 8) = (/&
&2.7465E-02_JPRB,2.5918E-02_JPRB,2.4664E-02_JPRB,2.3195E-02_JPRB,2.1415E-02_JPRB,1.9044E-02_JPRB,&
&1.5287E-02_JPRB,2.7465E-02_JPRB,3.0581E-03_JPRB/)
KAO( :, 3, 7, 8) = (/&
&2.7467E-02_JPRB,2.6847E-02_JPRB,2.6363E-02_JPRB,2.5381E-02_JPRB,2.4103E-02_JPRB,2.2261E-02_JPRB,&
&1.9298E-02_JPRB,2.7467E-02_JPRB,4.1379E-03_JPRB/)
KAO( :, 4, 7, 8) = (/&
&2.7377E-02_JPRB,2.7967E-02_JPRB,2.8113E-02_JPRB,2.7721E-02_JPRB,2.6897E-02_JPRB,2.5513E-02_JPRB,&
&2.3011E-02_JPRB,2.7377E-02_JPRB,5.4434E-03_JPRB/)
KAO( :, 5, 7, 8) = (/&
&2.7205E-02_JPRB,2.9095E-02_JPRB,2.9889E-02_JPRB,3.0064E-02_JPRB,2.9735E-02_JPRB,2.8823E-02_JPRB,&
&2.6785E-02_JPRB,2.7205E-02_JPRB,6.9886E-03_JPRB/)
KAO( :, 1, 8, 8) = (/&
&2.4838E-02_JPRB,2.2730E-02_JPRB,2.0879E-02_JPRB,1.8847E-02_JPRB,1.6562E-02_JPRB,1.3598E-02_JPRB,&
&7.9263E-03_JPRB,2.4838E-02_JPRB,2.3197E-03_JPRB/)
KAO( :, 2, 8, 8) = (/&
&2.4890E-02_JPRB,2.3360E-02_JPRB,2.2033E-02_JPRB,2.0523E-02_JPRB,1.8797E-02_JPRB,1.6567E-02_JPRB,&
&1.2790E-02_JPRB,2.4890E-02_JPRB,2.7806E-03_JPRB/)
KAO( :, 3, 8, 8) = (/&
&2.4862E-02_JPRB,2.4160E-02_JPRB,2.3528E-02_JPRB,2.2491E-02_JPRB,2.1199E-02_JPRB,1.9477E-02_JPRB,&
&1.6802E-02_JPRB,2.4862E-02_JPRB,3.4079E-03_JPRB/)
KAO( :, 4, 8, 8) = (/&
&2.4775E-02_JPRB,2.5154E-02_JPRB,2.5100E-02_JPRB,2.4578E-02_JPRB,2.3711E-02_JPRB,2.2381E-02_JPRB,&
&2.0219E-02_JPRB,2.4775E-02_JPRB,4.2580E-03_JPRB/)
KAO( :, 5, 8, 8) = (/&
&2.4622E-02_JPRB,2.6148E-02_JPRB,2.6699E-02_JPRB,2.6671E-02_JPRB,2.6294E-02_JPRB,2.5372E-02_JPRB,&
&2.3589E-02_JPRB,2.4622E-02_JPRB,5.3361E-03_JPRB/)
KAO( :, 1, 9, 8) = (/&
&2.2221E-02_JPRB,2.0209E-02_JPRB,1.8418E-02_JPRB,1.6497E-02_JPRB,1.4362E-02_JPRB,1.1452E-02_JPRB,&
&5.8464E-03_JPRB,2.2221E-02_JPRB,8.1045E-03_JPRB/)
KAO( :, 2, 9, 8) = (/&
&2.2228E-02_JPRB,2.0738E-02_JPRB,1.9399E-02_JPRB,1.7929E-02_JPRB,1.6274E-02_JPRB,1.4180E-02_JPRB,&
&1.0256E-02_JPRB,2.2228E-02_JPRB,8.4976E-03_JPRB/)
KAO( :, 3, 9, 8) = (/&
&2.2181E-02_JPRB,2.1419E-02_JPRB,2.0685E-02_JPRB,1.9636E-02_JPRB,1.8370E-02_JPRB,1.6740E-02_JPRB,&
&1.4221E-02_JPRB,2.2181E-02_JPRB,8.9064E-03_JPRB/)
KAO( :, 4, 9, 8) = (/&
&2.2077E-02_JPRB,2.2259E-02_JPRB,2.2053E-02_JPRB,2.1452E-02_JPRB,2.0561E-02_JPRB,1.9271E-02_JPRB,&
&1.7337E-02_JPRB,2.2077E-02_JPRB,9.3666E-03_JPRB/)
KAO( :, 5, 9, 8) = (/&
&2.1959E-02_JPRB,2.3140E-02_JPRB,2.3450E-02_JPRB,2.3281E-02_JPRB,2.2789E-02_JPRB,2.1856E-02_JPRB,&
&2.0328E-02_JPRB,2.1959E-02_JPRB,9.8960E-03_JPRB/)
KAO( :, 1,10, 8) = (/&
&1.9665E-02_JPRB,1.7813E-02_JPRB,1.6135E-02_JPRB,1.4379E-02_JPRB,1.2423E-02_JPRB,9.6194E-03_JPRB,&
&4.3665E-03_JPRB,1.9665E-02_JPRB,5.0859E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&1.9655E-02_JPRB,1.8254E-02_JPRB,1.6961E-02_JPRB,1.5587E-02_JPRB,1.4053E-02_JPRB,1.2088E-02_JPRB,&
&8.1382E-03_JPRB,1.9655E-02_JPRB,5.1465E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&1.9577E-02_JPRB,1.8805E-02_JPRB,1.8054E-02_JPRB,1.7058E-02_JPRB,1.5850E-02_JPRB,1.4336E-02_JPRB,&
&1.1950E-02_JPRB,1.9577E-02_JPRB,5.1955E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&1.9473E-02_JPRB,1.9523E-02_JPRB,1.9227E-02_JPRB,1.8591E-02_JPRB,1.7700E-02_JPRB,1.6478E-02_JPRB,&
&1.4693E-02_JPRB,1.9473E-02_JPRB,5.2354E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&1.9405E-02_JPRB,2.0288E-02_JPRB,2.0423E-02_JPRB,2.0132E-02_JPRB,1.9564E-02_JPRB,1.8691E-02_JPRB,&
&1.7347E-02_JPRB,1.9405E-02_JPRB,5.2682E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&1.7199E-02_JPRB,1.5692E-02_JPRB,1.4307E-02_JPRB,1.2861E-02_JPRB,1.1262E-02_JPRB,9.0316E-03_JPRB,&
&4.4212E-03_JPRB,1.7199E-02_JPRB,1.2641E-01_JPRB/)
KAO( :, 2,11, 8) = (/&
&1.7139E-02_JPRB,1.6089E-02_JPRB,1.5094E-02_JPRB,1.3995E-02_JPRB,1.2699E-02_JPRB,1.1063E-02_JPRB,&
&8.1294E-03_JPRB,1.7139E-02_JPRB,1.2630E-01_JPRB/)
KAO( :, 3,11, 8) = (/&
&1.7062E-02_JPRB,1.6616E-02_JPRB,1.6068E-02_JPRB,1.5250E-02_JPRB,1.4213E-02_JPRB,1.2927E-02_JPRB,&
&1.0968E-02_JPRB,1.7062E-02_JPRB,1.2657E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&1.7027E-02_JPRB,1.7284E-02_JPRB,1.7074E-02_JPRB,1.6503E-02_JPRB,1.5727E-02_JPRB,1.4747E-02_JPRB,&
&1.3302E-02_JPRB,1.7027E-02_JPRB,1.2680E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&1.7051E-02_JPRB,1.8003E-02_JPRB,1.8097E-02_JPRB,1.7795E-02_JPRB,1.7338E-02_JPRB,1.6670E-02_JPRB,&
&1.5656E-02_JPRB,1.7051E-02_JPRB,1.2668E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&1.4892E-02_JPRB,1.3707E-02_JPRB,1.2589E-02_JPRB,1.1424E-02_JPRB,1.0096E-02_JPRB,8.2815E-03_JPRB,&
&4.4233E-03_JPRB,1.4892E-02_JPRB,2.0178E-01_JPRB/)
KAO( :, 2,12, 8) = (/&
&1.4830E-02_JPRB,1.4076E-02_JPRB,1.3327E-02_JPRB,1.2415E-02_JPRB,1.1306E-02_JPRB,9.9128E-03_JPRB,&
&7.6510E-03_JPRB,1.4830E-02_JPRB,2.0127E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&1.4815E-02_JPRB,1.4616E-02_JPRB,1.4166E-02_JPRB,1.3436E-02_JPRB,1.2531E-02_JPRB,1.1419E-02_JPRB,&
&9.8144E-03_JPRB,1.4815E-02_JPRB,2.0109E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&1.4874E-02_JPRB,1.5249E-02_JPRB,1.5019E-02_JPRB,1.4484E-02_JPRB,1.3802E-02_JPRB,1.2969E-02_JPRB,&
&1.1802E-02_JPRB,1.4874E-02_JPRB,2.0108E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&1.5028E-02_JPRB,1.5947E-02_JPRB,1.5923E-02_JPRB,1.5630E-02_JPRB,1.5205E-02_JPRB,1.4665E-02_JPRB,&
&1.3888E-02_JPRB,1.5028E-02_JPRB,2.0061E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&1.2856E-02_JPRB,1.1926E-02_JPRB,1.1034E-02_JPRB,1.0051E-02_JPRB,8.9048E-03_JPRB,7.3808E-03_JPRB,&
&4.3560E-03_JPRB,1.2856E-02_JPRB,2.5947E-01_JPRB/)
KAO( :, 2,13, 8) = (/&
&1.2849E-02_JPRB,1.2317E-02_JPRB,1.1692E-02_JPRB,1.0882E-02_JPRB,9.8884E-03_JPRB,8.6786E-03_JPRB,&
&6.8479E-03_JPRB,1.2849E-02_JPRB,2.5953E-01_JPRB/)
KAO( :, 3,13, 8) = (/&
&1.2913E-02_JPRB,1.2850E-02_JPRB,1.2417E-02_JPRB,1.1721E-02_JPRB,1.0882E-02_JPRB,9.9190E-03_JPRB,&
&8.6023E-03_JPRB,1.2913E-02_JPRB,2.5942E-01_JPRB/)
KAO( :, 4,13, 8) = (/&
&1.3088E-02_JPRB,1.3471E-02_JPRB,1.3169E-02_JPRB,1.2637E-02_JPRB,1.1989E-02_JPRB,1.1248E-02_JPRB,&
&1.0301E-02_JPRB,1.3088E-02_JPRB,2.5909E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&1.3373E-02_JPRB,1.4159E-02_JPRB,1.4029E-02_JPRB,1.3679E-02_JPRB,1.3241E-02_JPRB,1.2749E-02_JPRB,&
&1.2125E-02_JPRB,1.3373E-02_JPRB,2.5815E-01_JPRB/)



!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB4_A2
