!OCL SCALAR
SUBROUTINE RRTM_KGB3_B4

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different H2O to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = H2O/(H2O+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of H2O.  For instance, JS=1 refers to no H2O, 
!     JS = 2 corresponds to eta = 0.25, etc.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13,13) = (/&
&1.2852E+00_JPRB,1.0643E+00_JPRB,9.2423E-01_JPRB,7.7210E-01_JPRB,4.8560E+00_JPRB/)
KBO( :, 2,13,13) = (/&
&1.8300E+00_JPRB,1.5153E+00_JPRB,1.3056E+00_JPRB,1.0896E+00_JPRB,5.1762E+00_JPRB/)
KBO( :, 3,13,13) = (/&
&2.4898E+00_JPRB,2.0619E+00_JPRB,1.7781E+00_JPRB,1.4720E+00_JPRB,5.5995E+00_JPRB/)
KBO( :, 4,13,13) = (/&
&3.2580E+00_JPRB,2.7136E+00_JPRB,2.3379E+00_JPRB,1.9103E+00_JPRB,6.0006E+00_JPRB/)
KBO( :, 5,13,13) = (/&
&4.1344E+00_JPRB,3.4741E+00_JPRB,2.9826E+00_JPRB,2.3986E+00_JPRB,6.3254E+00_JPRB/)
KBO( :, 1,14,13) = (/&
&1.4353E+00_JPRB,1.1813E+00_JPRB,1.0097E+00_JPRB,8.1766E-01_JPRB,4.4364E+00_JPRB/)
KBO( :, 2,14,13) = (/&
&2.0320E+00_JPRB,1.6766E+00_JPRB,1.4217E+00_JPRB,1.1476E+00_JPRB,4.7777E+00_JPRB/)
KBO( :, 3,14,13) = (/&
&2.7397E+00_JPRB,2.2766E+00_JPRB,1.9164E+00_JPRB,1.5404E+00_JPRB,5.1956E+00_JPRB/)
KBO( :, 4,14,13) = (/&
&3.5525E+00_JPRB,2.9774E+00_JPRB,2.5038E+00_JPRB,1.9898E+00_JPRB,5.5579E+00_JPRB/)
KBO( :, 5,14,13) = (/&
&4.4583E+00_JPRB,3.7784E+00_JPRB,3.1767E+00_JPRB,2.5098E+00_JPRB,5.8954E+00_JPRB/)
KBO( :, 1,15,13) = (/&
&1.5785E+00_JPRB,1.3067E+00_JPRB,1.1097E+00_JPRB,8.6674E-01_JPRB,3.8492E+00_JPRB/)
KBO( :, 2,15,13) = (/&
&2.2125E+00_JPRB,1.8434E+00_JPRB,1.5563E+00_JPRB,1.2050E+00_JPRB,4.1968E+00_JPRB/)
KBO( :, 3,15,13) = (/&
&2.9595E+00_JPRB,2.4844E+00_JPRB,2.0889E+00_JPRB,1.6068E+00_JPRB,4.5453E+00_JPRB/)
KBO( :, 4,15,13) = (/&
&3.8045E+00_JPRB,3.2259E+00_JPRB,2.7088E+00_JPRB,2.0757E+00_JPRB,4.8945E+00_JPRB/)
KBO( :, 5,15,13) = (/&
&4.7324E+00_JPRB,4.0530E+00_JPRB,3.4024E+00_JPRB,2.6201E+00_JPRB,5.1308E+00_JPRB/)
KBO( :, 1,16,13) = (/&
&1.6990E+00_JPRB,1.4270E+00_JPRB,1.2197E+00_JPRB,9.1540E-01_JPRB,3.2967E+00_JPRB/)
KBO( :, 2,16,13) = (/&
&2.3632E+00_JPRB,1.9965E+00_JPRB,1.6991E+00_JPRB,1.2635E+00_JPRB,3.5992E+00_JPRB/)
KBO( :, 3,16,13) = (/&
&3.1332E+00_JPRB,2.6737E+00_JPRB,2.2662E+00_JPRB,1.6797E+00_JPRB,3.8825E+00_JPRB/)
KBO( :, 4,16,13) = (/&
&3.9954E+00_JPRB,3.4413E+00_JPRB,2.9150E+00_JPRB,2.1732E+00_JPRB,4.0955E+00_JPRB/)
KBO( :, 5,16,13) = (/&
&4.9441E+00_JPRB,4.2813E+00_JPRB,3.6296E+00_JPRB,2.7347E+00_JPRB,4.3356E+00_JPRB/)
KBO( :, 1,17,13) = (/&
&1.7867E+00_JPRB,1.5291E+00_JPRB,1.3172E+00_JPRB,9.6442E-01_JPRB,2.8946E+00_JPRB/)
KBO( :, 2,17,13) = (/&
&2.4630E+00_JPRB,2.1240E+00_JPRB,1.8197E+00_JPRB,1.3271E+00_JPRB,3.1209E+00_JPRB/)
KBO( :, 3,17,13) = (/&
&3.2412E+00_JPRB,2.8205E+00_JPRB,2.4120E+00_JPRB,1.7621E+00_JPRB,3.3231E+00_JPRB/)
KBO( :, 4,17,13) = (/&
&4.1129E+00_JPRB,3.6026E+00_JPRB,3.0785E+00_JPRB,2.2752E+00_JPRB,3.5467E+00_JPRB/)
KBO( :, 5,17,13) = (/&
&5.0518E+00_JPRB,4.4575E+00_JPRB,3.8174E+00_JPRB,2.8444E+00_JPRB,3.7869E+00_JPRB/)
KBO( :, 1,18,13) = (/&
&1.8395E+00_JPRB,1.6132E+00_JPRB,1.3961E+00_JPRB,1.0121E+00_JPRB,2.6255E+00_JPRB/)
KBO( :, 2,18,13) = (/&
&2.5106E+00_JPRB,2.2211E+00_JPRB,1.9179E+00_JPRB,1.3918E+00_JPRB,2.8074E+00_JPRB/)
KBO( :, 3,18,13) = (/&
&3.2840E+00_JPRB,2.9230E+00_JPRB,2.5216E+00_JPRB,1.8455E+00_JPRB,2.9886E+00_JPRB/)
KBO( :, 4,18,13) = (/&
&4.1398E+00_JPRB,3.7076E+00_JPRB,3.1995E+00_JPRB,2.3655E+00_JPRB,3.2033E+00_JPRB/)
KBO( :, 5,18,13) = (/&
&5.0652E+00_JPRB,4.5681E+00_JPRB,3.9586E+00_JPRB,2.9470E+00_JPRB,3.4431E+00_JPRB/)
KBO( :, 1,19,13) = (/&
&1.8429E+00_JPRB,1.6700E+00_JPRB,1.4536E+00_JPRB,1.0564E+00_JPRB,2.4577E+00_JPRB/)
KBO( :, 2,19,13) = (/&
&2.5022E+00_JPRB,2.2784E+00_JPRB,1.9833E+00_JPRB,1.4492E+00_JPRB,2.6093E+00_JPRB/)
KBO( :, 3,19,13) = (/&
&3.2520E+00_JPRB,2.9805E+00_JPRB,2.5894E+00_JPRB,1.9140E+00_JPRB,2.7860E+00_JPRB/)
KBO( :, 4,19,13) = (/&
&4.0807E+00_JPRB,3.7648E+00_JPRB,3.2792E+00_JPRB,2.4354E+00_JPRB,2.9804E+00_JPRB/)
KBO( :, 5,19,13) = (/&
&4.9680E+00_JPRB,4.6224E+00_JPRB,4.0395E+00_JPRB,3.0224E+00_JPRB,3.2175E+00_JPRB/)
KBO( :, 1,20,13) = (/&
&1.8228E+00_JPRB,1.7025E+00_JPRB,1.4928E+00_JPRB,1.0898E+00_JPRB,2.3654E+00_JPRB/)
KBO( :, 2,20,13) = (/&
&2.4538E+00_JPRB,2.3051E+00_JPRB,2.0204E+00_JPRB,1.4897E+00_JPRB,2.5217E+00_JPRB/)
KBO( :, 3,20,13) = (/&
&3.1699E+00_JPRB,2.9971E+00_JPRB,2.6320E+00_JPRB,1.9524E+00_JPRB,2.6999E+00_JPRB/)
KBO( :, 4,20,13) = (/&
&3.9554E+00_JPRB,3.7710E+00_JPRB,3.3175E+00_JPRB,2.4725E+00_JPRB,2.8911E+00_JPRB/)
KBO( :, 5,20,13) = (/&
&4.8063E+00_JPRB,4.6094E+00_JPRB,4.0741E+00_JPRB,3.0590E+00_JPRB,3.1232E+00_JPRB/)
KBO( :, 1,21,13) = (/&
&1.7623E+00_JPRB,1.7061E+00_JPRB,1.5006E+00_JPRB,1.1051E+00_JPRB,2.2987E+00_JPRB/)
KBO( :, 2,21,13) = (/&
&2.3568E+00_JPRB,2.2938E+00_JPRB,2.0241E+00_JPRB,1.5005E+00_JPRB,2.4810E+00_JPRB/)
KBO( :, 3,21,13) = (/&
&3.0264E+00_JPRB,2.9663E+00_JPRB,2.6252E+00_JPRB,1.9540E+00_JPRB,2.6709E+00_JPRB/)
KBO( :, 4,21,13) = (/&
&3.7661E+00_JPRB,3.7114E+00_JPRB,3.3017E+00_JPRB,2.4660E+00_JPRB,2.8739E+00_JPRB/)
KBO( :, 5,21,13) = (/&
&4.5709E+00_JPRB,4.5292E+00_JPRB,4.0353E+00_JPRB,3.0458E+00_JPRB,3.1122E+00_JPRB/)
KBO( :, 1,22,13) = (/&
&1.7051E+00_JPRB,1.7105E+00_JPRB,1.5137E+00_JPRB,1.1220E+00_JPRB,2.2215E+00_JPRB/)
KBO( :, 2,22,13) = (/&
&2.2594E+00_JPRB,2.2812E+00_JPRB,2.0265E+00_JPRB,1.5078E+00_JPRB,2.4273E+00_JPRB/)
KBO( :, 3,22,13) = (/&
&2.8843E+00_JPRB,2.9298E+00_JPRB,2.6159E+00_JPRB,1.9497E+00_JPRB,2.6344E+00_JPRB/)
KBO( :, 4,22,13) = (/&
&3.5784E+00_JPRB,3.6530E+00_JPRB,3.2699E+00_JPRB,2.4532E+00_JPRB,2.8571E+00_JPRB/)
KBO( :, 5,22,13) = (/&
&4.3282E+00_JPRB,4.4413E+00_JPRB,3.9817E+00_JPRB,3.0263E+00_JPRB,3.1138E+00_JPRB/)
KBO( :, 1,23,13) = (/&
&1.6227E+00_JPRB,1.6865E+00_JPRB,1.4987E+00_JPRB,1.1164E+00_JPRB,2.1516E+00_JPRB/)
KBO( :, 2,23,13) = (/&
&2.1334E+00_JPRB,2.2311E+00_JPRB,1.9947E+00_JPRB,1.4865E+00_JPRB,2.3714E+00_JPRB/)
KBO( :, 3,23,13) = (/&
&2.7130E+00_JPRB,2.8505E+00_JPRB,2.5601E+00_JPRB,1.9131E+00_JPRB,2.5957E+00_JPRB/)
KBO( :, 4,23,13) = (/&
&3.3545E+00_JPRB,3.5417E+00_JPRB,3.1845E+00_JPRB,2.4070E+00_JPRB,2.8423E+00_JPRB/)
KBO( :, 5,23,13) = (/&
&4.0511E+00_JPRB,4.2980E+00_JPRB,3.8824E+00_JPRB,2.9663E+00_JPRB,3.1097E+00_JPRB/)
KBO( :, 1,24,13) = (/&
&1.5221E+00_JPRB,1.6399E+00_JPRB,1.4631E+00_JPRB,1.0922E+00_JPRB,2.0557E+00_JPRB/)
KBO( :, 2,24,13) = (/&
&1.9909E+00_JPRB,2.1551E+00_JPRB,1.9333E+00_JPRB,1.4438E+00_JPRB,2.2893E+00_JPRB/)
KBO( :, 3,24,13) = (/&
&2.5227E+00_JPRB,2.7424E+00_JPRB,2.4670E+00_JPRB,1.8560E+00_JPRB,2.5308E+00_JPRB/)
KBO( :, 4,24,13) = (/&
&3.1132E+00_JPRB,3.3998E+00_JPRB,3.0690E+00_JPRB,2.3315E+00_JPRB,2.7959E+00_JPRB/)
KBO( :, 5,24,13) = (/&
&3.7625E+00_JPRB,4.1275E+00_JPRB,3.7502E+00_JPRB,2.8726E+00_JPRB,3.0711E+00_JPRB/)
KBO( :, 1,25,13) = (/&
&1.4164E+00_JPRB,1.5764E+00_JPRB,1.4120E+00_JPRB,1.0539E+00_JPRB,1.9710E+00_JPRB/)
KBO( :, 2,25,13) = (/&
&1.8451E+00_JPRB,2.0623E+00_JPRB,1.8523E+00_JPRB,1.3889E+00_JPRB,2.2117E+00_JPRB/)
KBO( :, 3,25,13) = (/&
&2.3323E+00_JPRB,2.6170E+00_JPRB,2.3560E+00_JPRB,1.7813E+00_JPRB,2.4702E+00_JPRB/)
KBO( :, 4,25,13) = (/&
&2.8785E+00_JPRB,3.2423E+00_JPRB,2.9353E+00_JPRB,2.2379E+00_JPRB,2.7415E+00_JPRB/)
KBO( :, 5,25,13) = (/&
&3.4748E+00_JPRB,3.9386E+00_JPRB,3.5958E+00_JPRB,2.7566E+00_JPRB,3.0246E+00_JPRB/)
KBO( :, 1,26,13) = (/&
&1.3174E+00_JPRB,1.5065E+00_JPRB,1.3505E+00_JPRB,1.0108E+00_JPRB,1.9092E+00_JPRB/)
KBO( :, 2,26,13) = (/&
&1.7100E+00_JPRB,1.9656E+00_JPRB,1.7614E+00_JPRB,1.3273E+00_JPRB,2.1568E+00_JPRB/)
KBO( :, 3,26,13) = (/&
&2.1599E+00_JPRB,2.4918E+00_JPRB,2.2424E+00_JPRB,1.7022E+00_JPRB,2.4251E+00_JPRB/)
KBO( :, 4,26,13) = (/&
&2.6619E+00_JPRB,3.0863E+00_JPRB,2.8007E+00_JPRB,2.1368E+00_JPRB,2.6974E+00_JPRB/)
KBO( :, 5,26,13) = (/&
&3.2164E+00_JPRB,3.7562E+00_JPRB,3.4382E+00_JPRB,2.6323E+00_JPRB,2.9897E+00_JPRB/)
KBO( :, 1,27,13) = (/&
&1.2227E+00_JPRB,1.4318E+00_JPRB,1.2776E+00_JPRB,9.6234E-01_JPRB,1.8084E+00_JPRB/)
KBO( :, 2,27,13) = (/&
&1.5845E+00_JPRB,1.8650E+00_JPRB,1.6669E+00_JPRB,1.2616E+00_JPRB,2.0606E+00_JPRB/)
KBO( :, 3,27,13) = (/&
&1.9986E+00_JPRB,2.3637E+00_JPRB,2.1255E+00_JPRB,1.6180E+00_JPRB,2.3235E+00_JPRB/)
KBO( :, 4,27,13) = (/&
&2.4670E+00_JPRB,2.9335E+00_JPRB,2.6606E+00_JPRB,2.0306E+00_JPRB,2.5979E+00_JPRB/)
KBO( :, 5,27,13) = (/&
&2.9836E+00_JPRB,3.5812E+00_JPRB,3.2799E+00_JPRB,2.5047E+00_JPRB,2.8940E+00_JPRB/)
KBO( :, 1,28,13) = (/&
&1.1382E+00_JPRB,1.3569E+00_JPRB,1.2047E+00_JPRB,9.1050E-01_JPRB,1.6756E+00_JPRB/)
KBO( :, 2,28,13) = (/&
&1.4731E+00_JPRB,1.7658E+00_JPRB,1.5747E+00_JPRB,1.1959E+00_JPRB,1.9259E+00_JPRB/)
KBO( :, 3,28,13) = (/&
&1.8595E+00_JPRB,2.2417E+00_JPRB,2.0136E+00_JPRB,1.5323E+00_JPRB,2.1797E+00_JPRB/)
KBO( :, 4,28,13) = (/&
&2.2933E+00_JPRB,2.7930E+00_JPRB,2.5304E+00_JPRB,1.9266E+00_JPRB,2.4581E+00_JPRB/)
KBO( :, 5,28,13) = (/&
&2.7792E+00_JPRB,3.4303E+00_JPRB,3.1288E+00_JPRB,2.3846E+00_JPRB,2.7569E+00_JPRB/)
KBO( :, 1,29,13) = (/&
&1.0690E+00_JPRB,1.2881E+00_JPRB,1.1394E+00_JPRB,8.6196E-01_JPRB,1.5316E+00_JPRB/)
KBO( :, 2,29,13) = (/&
&1.3833E+00_JPRB,1.6767E+00_JPRB,1.4909E+00_JPRB,1.1330E+00_JPRB,1.7636E+00_JPRB/)
KBO( :, 3,29,13) = (/&
&1.7418E+00_JPRB,2.1373E+00_JPRB,1.9152E+00_JPRB,1.4529E+00_JPRB,2.0079E+00_JPRB/)
KBO( :, 4,29,13) = (/&
&2.1520E+00_JPRB,2.6796E+00_JPRB,2.4158E+00_JPRB,1.8327E+00_JPRB,2.2752E+00_JPRB/)
KBO( :, 5,29,13) = (/&
&2.6198E+00_JPRB,3.3045E+00_JPRB,3.0000E+00_JPRB,2.2771E+00_JPRB,2.5616E+00_JPRB/)
KBO( :, 1,30,13) = (/&
&1.0127E+00_JPRB,1.2266E+00_JPRB,1.0797E+00_JPRB,8.1863E-01_JPRB,1.3724E+00_JPRB/)
KBO( :, 2,30,13) = (/&
&1.3069E+00_JPRB,1.6015E+00_JPRB,1.4185E+00_JPRB,1.0745E+00_JPRB,1.5829E+00_JPRB/)
KBO( :, 3,30,13) = (/&
&1.6487E+00_JPRB,2.0522E+00_JPRB,1.8302E+00_JPRB,1.3820E+00_JPRB,1.8153E+00_JPRB/)
KBO( :, 4,30,13) = (/&
&2.0473E+00_JPRB,2.5843E+00_JPRB,2.3209E+00_JPRB,1.7515E+00_JPRB,2.0659E+00_JPRB/)
KBO( :, 5,30,13) = (/&
&2.5092E+00_JPRB,3.2023E+00_JPRB,2.8969E+00_JPRB,2.1888E+00_JPRB,2.3374E+00_JPRB/)
KBO( :, 1,31,13) = (/&
&9.6510E-01_JPRB,1.1794E+00_JPRB,1.0308E+00_JPRB,7.7856E-01_JPRB,1.1918E+00_JPRB/)
KBO( :, 2,31,13) = (/&
&1.2477E+00_JPRB,1.5457E+00_JPRB,1.3619E+00_JPRB,1.0252E+00_JPRB,1.3817E+00_JPRB/)
KBO( :, 3,31,13) = (/&
&1.5837E+00_JPRB,1.9885E+00_JPRB,1.7652E+00_JPRB,1.3248E+00_JPRB,1.5914E+00_JPRB/)
KBO( :, 4,31,13) = (/&
&1.9797E+00_JPRB,2.5159E+00_JPRB,2.2496E+00_JPRB,1.6880E+00_JPRB,1.8169E+00_JPRB/)
KBO( :, 5,31,13) = (/&
&2.4397E+00_JPRB,3.1333E+00_JPRB,2.8243E+00_JPRB,2.1253E+00_JPRB,2.0691E+00_JPRB/)
KBO( :, 1,32,13) = (/&
&9.2809E-01_JPRB,1.1462E+00_JPRB,9.9628E-01_JPRB,7.4536E-01_JPRB,1.0320E+00_JPRB/)
KBO( :, 2,32,13) = (/&
&1.2071E+00_JPRB,1.5069E+00_JPRB,1.3205E+00_JPRB,9.8597E-01_JPRB,1.2033E+00_JPRB/)
KBO( :, 3,32,13) = (/&
&1.5432E+00_JPRB,1.9476E+00_JPRB,1.7191E+00_JPRB,1.2835E+00_JPRB,1.3897E+00_JPRB/)
KBO( :, 4,32,13) = (/&
&1.9406E+00_JPRB,2.4766E+00_JPRB,2.2038E+00_JPRB,1.6458E+00_JPRB,1.5971E+00_JPRB/)
KBO( :, 5,32,13) = (/&
&2.3994E+00_JPRB,3.0984E+00_JPRB,2.7844E+00_JPRB,2.0892E+00_JPRB,1.8364E+00_JPRB/)
KBO( :, 1,33,13) = (/&
&9.0452E-01_JPRB,1.1258E+00_JPRB,9.7321E-01_JPRB,7.2002E-01_JPRB,8.8562E-01_JPRB/)
KBO( :, 2,33,13) = (/&
&1.1846E+00_JPRB,1.4864E+00_JPRB,1.2941E+00_JPRB,9.5876E-01_JPRB,1.0371E+00_JPRB/)
KBO( :, 3,33,13) = (/&
&1.5214E+00_JPRB,1.9311E+00_JPRB,1.6937E+00_JPRB,1.2572E+00_JPRB,1.2046E+00_JPRB/)
KBO( :, 4,33,13) = (/&
&1.9196E+00_JPRB,2.4657E+00_JPRB,2.1858E+00_JPRB,1.6239E+00_JPRB,1.3977E+00_JPRB/)
KBO( :, 5,33,13) = (/&
&2.3836E+00_JPRB,3.1007E+00_JPRB,2.7768E+00_JPRB,2.0781E+00_JPRB,1.6273E+00_JPRB/)
KBO( :, 1,34,13) = (/&
&8.8467E-01_JPRB,1.1068E+00_JPRB,9.5054E-01_JPRB,6.9629E-01_JPRB,7.8494E-01_JPRB/)
KBO( :, 2,34,13) = (/&
&1.1642E+00_JPRB,1.4706E+00_JPRB,1.2717E+00_JPRB,9.3470E-01_JPRB,9.2138E-01_JPRB/)
KBO( :, 3,34,13) = (/&
&1.5015E+00_JPRB,1.9181E+00_JPRB,1.6758E+00_JPRB,1.2345E+00_JPRB,1.0773E+00_JPRB/)
KBO( :, 4,34,13) = (/&
&1.9018E+00_JPRB,2.4632E+00_JPRB,2.1759E+00_JPRB,1.6080E+00_JPRB,1.2614E+00_JPRB/)
KBO( :, 5,34,13) = (/&
&2.3740E+00_JPRB,3.1145E+00_JPRB,2.7821E+00_JPRB,2.0712E+00_JPRB,1.4792E+00_JPRB/)
KBO( :, 1,35,13) = (/&
&8.4955E-01_JPRB,1.0688E+00_JPRB,9.1231E-01_JPRB,6.6202E-01_JPRB,6.7824E-01_JPRB/)
KBO( :, 2,35,13) = (/&
&1.1250E+00_JPRB,1.4313E+00_JPRB,1.2303E+00_JPRB,8.9698E-01_JPRB,8.0193E-01_JPRB/)
KBO( :, 3,35,13) = (/&
&1.4599E+00_JPRB,1.8791E+00_JPRB,1.6347E+00_JPRB,1.1945E+00_JPRB,9.4771E-01_JPRB/)
KBO( :, 4,35,13) = (/&
&1.8617E+00_JPRB,2.4289E+00_JPRB,2.1382E+00_JPRB,1.5703E+00_JPRB,1.1239E+00_JPRB/)
KBO( :, 5,35,13) = (/&
&2.3371E+00_JPRB,3.0886E+00_JPRB,2.7503E+00_JPRB,2.0370E+00_JPRB,1.3258E+00_JPRB/)
KBO( :, 1,36,13) = (/&
&7.9554E-01_JPRB,1.0086E+00_JPRB,8.5573E-01_JPRB,6.1485E-01_JPRB,5.7027E-01_JPRB/)
KBO( :, 2,36,13) = (/&
&1.0642E+00_JPRB,1.3634E+00_JPRB,1.1652E+00_JPRB,8.4197E-01_JPRB,6.8378E-01_JPRB/)
KBO( :, 3,36,13) = (/&
&1.3924E+00_JPRB,1.8049E+00_JPRB,1.5634E+00_JPRB,1.1326E+00_JPRB,8.2218E-01_JPRB/)
KBO( :, 4,36,13) = (/&
&1.7900E+00_JPRB,2.3512E+00_JPRB,2.0607E+00_JPRB,1.5026E+00_JPRB,9.8859E-01_JPRB/)
KBO( :, 5,36,13) = (/&
&2.2630E+00_JPRB,3.0065E+00_JPRB,2.6687E+00_JPRB,1.9640E+00_JPRB,1.1762E+00_JPRB/)
KBO( :, 1,37,13) = (/&
&7.1417E-01_JPRB,9.1309E-01_JPRB,7.7089E-01_JPRB,5.4803E-01_JPRB,4.9622E-01_JPRB/)
KBO( :, 2,37,13) = (/&
&9.6913E-01_JPRB,1.2512E+00_JPRB,1.0630E+00_JPRB,7.6043E-01_JPRB,5.9797E-01_JPRB/)
KBO( :, 3,37,13) = (/&
&1.2840E+00_JPRB,1.6746E+00_JPRB,1.4416E+00_JPRB,1.0353E+00_JPRB,7.2233E-01_JPRB/)
KBO( :, 4,37,13) = (/&
&1.6678E+00_JPRB,2.2008E+00_JPRB,1.9187E+00_JPRB,1.3875E+00_JPRB,8.7304E-01_JPRB/)
KBO( :, 5,37,13) = (/&
&2.1271E+00_JPRB,2.8380E+00_JPRB,2.5062E+00_JPRB,1.8314E+00_JPRB,1.0444E+00_JPRB/)
KBO( :, 1,38,13) = (/&
&6.4094E-01_JPRB,8.2768E-01_JPRB,6.9645E-01_JPRB,4.8972E-01_JPRB,4.2782E-01_JPRB/)
KBO( :, 2,38,13) = (/&
&8.8268E-01_JPRB,1.1499E+00_JPRB,9.7252E-01_JPRB,6.8901E-01_JPRB,5.1817E-01_JPRB/)
KBO( :, 3,38,13) = (/&
&1.1854E+00_JPRB,1.5567E+00_JPRB,1.3326E+00_JPRB,9.4875E-01_JPRB,6.2911E-01_JPRB/)
KBO( :, 4,38,13) = (/&
&1.5548E+00_JPRB,2.0633E+00_JPRB,1.7903E+00_JPRB,1.2846E+00_JPRB,7.6404E-01_JPRB/)
KBO( :, 5,38,13) = (/&
&2.0005E+00_JPRB,2.6819E+00_JPRB,2.3577E+00_JPRB,1.7108E+00_JPRB,9.1910E-01_JPRB/)
KBO( :, 1,39,13) = (/&
&5.7700E-01_JPRB,7.5348E-01_JPRB,6.3234E-01_JPRB,4.4039E-01_JPRB,3.6316E-01_JPRB/)
KBO( :, 2,39,13) = (/&
&8.0617E-01_JPRB,1.0607E+00_JPRB,8.9464E-01_JPRB,6.2787E-01_JPRB,4.4256E-01_JPRB/)
KBO( :, 3,39,13) = (/&
&1.0971E+00_JPRB,1.4528E+00_JPRB,1.2371E+00_JPRB,8.7381E-01_JPRB,5.4063E-01_JPRB/)
KBO( :, 4,39,13) = (/&
&1.4539E+00_JPRB,1.9409E+00_JPRB,1.6768E+00_JPRB,1.1946E+00_JPRB,6.6034E-01_JPRB/)
KBO( :, 5,39,13) = (/&
&1.8880E+00_JPRB,2.5419E+00_JPRB,2.2244E+00_JPRB,1.6039E+00_JPRB,7.9890E-01_JPRB/)
KBO( :, 1,40,13) = (/&
&5.0186E-01_JPRB,6.6294E-01_JPRB,5.5500E-01_JPRB,3.8289E-01_JPRB,3.1769E-01_JPRB/)
KBO( :, 2,40,13) = (/&
&7.1323E-01_JPRB,9.4798E-01_JPRB,7.9752E-01_JPRB,5.5384E-01_JPRB,3.8877E-01_JPRB/)
KBO( :, 3,40,13) = (/&
&9.8586E-01_JPRB,1.3164E+00_JPRB,1.1157E+00_JPRB,7.8136E-01_JPRB,4.7618E-01_JPRB/)
KBO( :, 4,40,13) = (/&
&1.3258E+00_JPRB,1.7781E+00_JPRB,1.5269E+00_JPRB,1.0795E+00_JPRB,5.8462E-01_JPRB/)
KBO( :, 5,40,13) = (/&
&1.7397E+00_JPRB,2.3496E+00_JPRB,2.0447E+00_JPRB,1.4640E+00_JPRB,7.1183E-01_JPRB/)
KBO( :, 1,41,13) = (/&
&4.3380E-01_JPRB,5.8097E-01_JPRB,4.8476E-01_JPRB,3.3186E-01_JPRB,2.7762E-01_JPRB/)
KBO( :, 2,41,13) = (/&
&6.2819E-01_JPRB,8.4375E-01_JPRB,7.0798E-01_JPRB,4.8718E-01_JPRB,3.4151E-01_JPRB/)
KBO( :, 3,41,13) = (/&
&8.8231E-01_JPRB,1.1885E+00_JPRB,1.0030E+00_JPRB,6.9676E-01_JPRB,4.1944E-01_JPRB/)
KBO( :, 4,41,13) = (/&
&1.2044E+00_JPRB,1.6239E+00_JPRB,1.3862E+00_JPRB,9.7292E-01_JPRB,5.1737E-01_JPRB/)
KBO( :, 5,41,13) = (/&
&1.5976E+00_JPRB,2.1644E+00_JPRB,1.8733E+00_JPRB,1.3324E+00_JPRB,6.3382E-01_JPRB/)
KBO( :, 1,42,13) = (/&
&3.7449E-01_JPRB,5.0898E-01_JPRB,4.2337E-01_JPRB,2.8788E-01_JPRB,2.4070E-01_JPRB/)
KBO( :, 2,42,13) = (/&
&5.5270E-01_JPRB,7.5038E-01_JPRB,6.2836E-01_JPRB,4.2892E-01_JPRB,2.9753E-01_JPRB/)
KBO( :, 3,42,13) = (/&
&7.8906E-01_JPRB,1.0722E+00_JPRB,9.0203E-01_JPRB,6.2172E-01_JPRB,3.6699E-01_JPRB/)
KBO( :, 4,42,13) = (/&
&1.0928E+00_JPRB,1.4824E+00_JPRB,1.2591E+00_JPRB,8.7750E-01_JPRB,4.5486E-01_JPRB/)
KBO( :, 5,42,13) = (/&
&1.4670E+00_JPRB,1.9931E+00_JPRB,1.7165E+00_JPRB,1.2130E+00_JPRB,5.6051E-01_JPRB/)
KBO( :, 1,43,13) = (/&
&3.1535E-01_JPRB,4.3481E-01_JPRB,3.6057E-01_JPRB,2.4367E-01_JPRB,2.0825E-01_JPRB/)
KBO( :, 2,43,13) = (/&
&4.7503E-01_JPRB,6.5262E-01_JPRB,5.4494E-01_JPRB,3.6943E-01_JPRB,2.5841E-01_JPRB/)
KBO( :, 3,43,13) = (/&
&6.9119E-01_JPRB,9.4733E-01_JPRB,7.9475E-01_JPRB,5.4324E-01_JPRB,3.1952E-01_JPRB/)
KBO( :, 4,43,13) = (/&
&9.7283E-01_JPRB,1.3279E+00_JPRB,1.1223E+00_JPRB,7.7674E-01_JPRB,3.9652E-01_JPRB/)
KBO( :, 5,43,13) = (/&
&1.3243E+00_JPRB,1.8050E+00_JPRB,1.5450E+00_JPRB,1.0849E+00_JPRB,4.9087E-01_JPRB/)
KBO( :, 1,44,13) = (/&
&2.6174E-01_JPRB,3.6590E-01_JPRB,3.0263E-01_JPRB,2.0344E-01_JPRB,1.7938E-01_JPRB/)
KBO( :, 2,44,13) = (/&
&4.0277E-01_JPRB,5.6056E-01_JPRB,4.6662E-01_JPRB,3.1442E-01_JPRB,2.2338E-01_JPRB/)
KBO( :, 3,44,13) = (/&
&5.9777E-01_JPRB,8.2704E-01_JPRB,6.9190E-01_JPRB,4.6961E-01_JPRB,2.7697E-01_JPRB/)
KBO( :, 4,44,13) = (/&
&8.5584E-01_JPRB,1.1770E+00_JPRB,9.9059E-01_JPRB,6.8041E-01_JPRB,3.4323E-01_JPRB/)
KBO( :, 5,44,13) = (/&
&1.1839E+00_JPRB,1.6189E+00_JPRB,1.3779E+00_JPRB,9.6037E-01_JPRB,4.2597E-01_JPRB/)
KBO( :, 1,45,13) = (/&
&2.1651E-01_JPRB,3.0623E-01_JPRB,2.5303E-01_JPRB,1.6909E-01_JPRB,1.5286E-01_JPRB/)
KBO( :, 2,45,13) = (/&
&3.3998E-01_JPRB,4.7944E-01_JPRB,3.9799E-01_JPRB,2.6665E-01_JPRB,1.9138E-01_JPRB/)
KBO( :, 3,45,13) = (/&
&5.1505E-01_JPRB,7.1915E-01_JPRB,6.0047E-01_JPRB,4.0501E-01_JPRB,2.3804E-01_JPRB/)
KBO( :, 4,45,13) = (/&
&7.5069E-01_JPRB,1.0392E+00_JPRB,8.7233E-01_JPRB,5.9477E-01_JPRB,2.9472E-01_JPRB/)
KBO( :, 5,45,13) = (/&
&1.0546E+00_JPRB,1.4482E+00_JPRB,1.2265E+00_JPRB,8.4853E-01_JPRB,3.6589E-01_JPRB/)
KBO( :, 1,46,13) = (/&
&1.7663E-01_JPRB,2.5198E-01_JPRB,2.0821E-01_JPRB,1.3852E-01_JPRB,1.2920E-01_JPRB/)
KBO( :, 2,46,13) = (/&
&2.8312E-01_JPRB,4.0392E-01_JPRB,3.3454E-01_JPRB,2.2297E-01_JPRB,1.6315E-01_JPRB/)
KBO( :, 3,46,13) = (/&
&4.3787E-01_JPRB,6.1746E-01_JPRB,5.1421E-01_JPRB,3.4506E-01_JPRB,2.0329E-01_JPRB/)
KBO( :, 4,46,13) = (/&
&6.5040E-01_JPRB,9.0658E-01_JPRB,7.5889E-01_JPRB,5.1408E-01_JPRB,2.5188E-01_JPRB/)
KBO( :, 5,46,13) = (/&
&9.2878E-01_JPRB,1.2821E+00_JPRB,1.0808E+00_JPRB,7.4274E-01_JPRB,3.1240E-01_JPRB/)
KBO( :, 1,47,13) = (/&
&1.4044E-01_JPRB,2.0128E-01_JPRB,1.6621E-01_JPRB,1.1051E-01_JPRB,1.0897E-01_JPRB/)
KBO( :, 2,47,13) = (/&
&2.3004E-01_JPRB,3.3154E-01_JPRB,2.7419E-01_JPRB,1.8180E-01_JPRB,1.3962E-01_JPRB/)
KBO( :, 3,47,13) = (/&
&3.6325E-01_JPRB,5.1821E-01_JPRB,4.3034E-01_JPRB,2.8728E-01_JPRB,1.7431E-01_JPRB/)
KBO( :, 4,47,13) = (/&
&5.5117E-01_JPRB,7.7483E-01_JPRB,6.4673E-01_JPRB,4.3554E-01_JPRB,2.1654E-01_JPRB/)
KBO( :, 5,47,13) = (/&
&8.0200E-01_JPRB,1.1139E+00_JPRB,9.3561E-01_JPRB,6.3799E-01_JPRB,2.6782E-01_JPRB/)
KBO( :, 1,48,13) = (/&
&1.1101E-01_JPRB,1.5927E-01_JPRB,1.3139E-01_JPRB,8.7527E-02_JPRB,9.0201E-02_JPRB/)
KBO( :, 2,48,13) = (/&
&1.8567E-01_JPRB,2.6968E-01_JPRB,2.2270E-01_JPRB,1.4710E-01_JPRB,1.1764E-01_JPRB/)
KBO( :, 3,48,13) = (/&
&2.9933E-01_JPRB,4.3159E-01_JPRB,3.5753E-01_JPRB,2.3730E-01_JPRB,1.4811E-01_JPRB/)
KBO( :, 4,48,13) = (/&
&4.6369E-01_JPRB,6.5797E-01_JPRB,5.4789E-01_JPRB,3.6706E-01_JPRB,1.8402E-01_JPRB/)
KBO( :, 5,48,13) = (/&
&6.8807E-01_JPRB,9.6214E-01_JPRB,8.0577E-01_JPRB,5.4570E-01_JPRB,2.2761E-01_JPRB/)
KBO( :, 1,49,13) = (/&
&8.6952E-02_JPRB,1.2481E-01_JPRB,1.0270E-01_JPRB,6.8735E-02_JPRB,7.2916E-02_JPRB/)
KBO( :, 2,49,13) = (/&
&1.4886E-01_JPRB,2.1718E-01_JPRB,1.7934E-01_JPRB,1.1829E-01_JPRB,9.6830E-02_JPRB/)
KBO( :, 3,49,13) = (/&
&2.4507E-01_JPRB,3.5657E-01_JPRB,2.9496E-01_JPRB,1.9481E-01_JPRB,1.2384E-01_JPRB/)
KBO( :, 4,49,13) = (/&
&3.8722E-01_JPRB,5.5518E-01_JPRB,4.6109E-01_JPRB,3.0744E-01_JPRB,1.5413E-01_JPRB/)
KBO( :, 5,49,13) = (/&
&5.8631E-01_JPRB,8.2602E-01_JPRB,6.8968E-01_JPRB,4.6440E-01_JPRB,1.9058E-01_JPRB/)
KBO( :, 1,50,13) = (/&
&6.8423E-02_JPRB,9.8362E-02_JPRB,8.0813E-02_JPRB,5.4318E-02_JPRB,6.0640E-02_JPRB/)
KBO( :, 2,50,13) = (/&
&1.2024E-01_JPRB,1.7560E-01_JPRB,1.4487E-01_JPRB,9.5713E-02_JPRB,8.2094E-02_JPRB/)
KBO( :, 3,50,13) = (/&
&2.0188E-01_JPRB,2.9561E-01_JPRB,2.4418E-01_JPRB,1.6072E-01_JPRB,1.0662E-01_JPRB/)
KBO( :, 4,50,13) = (/&
&3.2485E-01_JPRB,4.7020E-01_JPRB,3.8945E-01_JPRB,2.5843E-01_JPRB,1.3377E-01_JPRB/)
KBO( :, 5,50,13) = (/&
&5.0116E-01_JPRB,7.1185E-01_JPRB,5.9284E-01_JPRB,3.9734E-01_JPRB,1.6547E-01_JPRB/)
KBO( :, 1,51,13) = (/&
&5.3728E-02_JPRB,7.7475E-02_JPRB,6.3575E-02_JPRB,4.2812E-02_JPRB,5.0933E-02_JPRB/)
KBO( :, 2,51,13) = (/&
&9.7035E-02_JPRB,1.4176E-01_JPRB,1.1670E-01_JPRB,7.7313E-02_JPRB,7.0361E-02_JPRB/)
KBO( :, 3,51,13) = (/&
&1.6618E-01_JPRB,2.4447E-01_JPRB,2.0180E-01_JPRB,1.3255E-01_JPRB,9.2830E-02_JPRB/)
KBO( :, 4,51,13) = (/&
&2.7241E-01_JPRB,3.9733E-01_JPRB,3.2861E-01_JPRB,2.1702E-01_JPRB,1.1799E-01_JPRB/)
KBO( :, 5,51,13) = (/&
&4.2784E-01_JPRB,6.1277E-01_JPRB,5.0908E-01_JPRB,3.3984E-01_JPRB,1.4641E-01_JPRB/)
KBO( :, 1,52,13) = (/&
&4.1802E-02_JPRB,6.0502E-02_JPRB,4.9697E-02_JPRB,3.3504E-02_JPRB,4.2023E-02_JPRB/)
KBO( :, 2,52,13) = (/&
&7.7722E-02_JPRB,1.1354E-01_JPRB,9.3251E-02_JPRB,6.2061E-02_JPRB,5.9351E-02_JPRB/)
KBO( :, 3,52,13) = (/&
&1.3608E-01_JPRB,2.0057E-01_JPRB,1.6557E-01_JPRB,1.0873E-01_JPRB,7.9645E-02_JPRB/)
KBO( :, 4,52,13) = (/&
&2.2730E-01_JPRB,3.3353E-01_JPRB,2.7571E-01_JPRB,1.8131E-01_JPRB,1.0280E-01_JPRB/)
KBO( :, 5,52,13) = (/&
&3.6299E-01_JPRB,5.2462E-01_JPRB,4.3487E-01_JPRB,2.8905E-01_JPRB,1.2859E-01_JPRB/)
KBO( :, 1,53,13) = (/&
&3.2183E-02_JPRB,4.6680E-02_JPRB,3.8481E-02_JPRB,2.6042E-02_JPRB,3.3756E-02_JPRB/)
KBO( :, 2,53,13) = (/&
&6.1728E-02_JPRB,9.0133E-02_JPRB,7.3973E-02_JPRB,4.9381E-02_JPRB,4.8993E-02_JPRB/)
KBO( :, 3,53,13) = (/&
&1.1077E-01_JPRB,1.6319E-01_JPRB,1.3454E-01_JPRB,8.8555E-02_JPRB,6.7056E-02_JPRB/)
KBO( :, 4,53,13) = (/&
&1.8844E-01_JPRB,2.7785E-01_JPRB,2.2936E-01_JPRB,1.5042E-01_JPRB,8.7934E-02_JPRB/)
KBO( :, 5,53,13) = (/&
&3.0619E-01_JPRB,4.4605E-01_JPRB,3.6897E-01_JPRB,2.4410E-01_JPRB,1.1120E-01_JPRB/)
KBO( :, 1,54,13) = (/&
&2.5047E-02_JPRB,3.6400E-02_JPRB,3.0153E-02_JPRB,2.0502E-02_JPRB,2.9038E-02_JPRB/)
KBO( :, 2,54,13) = (/&
&4.9509E-02_JPRB,7.2463E-02_JPRB,5.9428E-02_JPRB,3.9713E-02_JPRB,4.3296E-02_JPRB/)
KBO( :, 3,54,13) = (/&
&9.1047E-02_JPRB,1.3408E-01_JPRB,1.1032E-01_JPRB,7.2811E-02_JPRB,6.0352E-02_JPRB/)
KBO( :, 4,54,13) = (/&
&1.5773E-01_JPRB,2.3322E-01_JPRB,1.9256E-01_JPRB,1.2610E-01_JPRB,8.0247E-02_JPRB/)
KBO( :, 5,54,13) = (/&
&2.6064E-01_JPRB,3.8195E-01_JPRB,3.1567E-01_JPRB,2.0798E-01_JPRB,1.0268E-01_JPRB/)
KBO( :, 1,55,13) = (/&
&1.9531E-02_JPRB,2.8409E-02_JPRB,2.3654E-02_JPRB,1.6169E-02_JPRB,2.6016E-02_JPRB/)
KBO( :, 2,55,13) = (/&
&3.9731E-02_JPRB,5.8300E-02_JPRB,4.7864E-02_JPRB,3.2046E-02_JPRB,3.9891E-02_JPRB/)
KBO( :, 3,55,13) = (/&
&7.5011E-02_JPRB,1.1035E-01_JPRB,9.0609E-02_JPRB,6.0025E-02_JPRB,5.6691E-02_JPRB/)
KBO( :, 4,55,13) = (/&
&1.3239E-01_JPRB,1.9599E-01_JPRB,1.6178E-01_JPRB,1.0597E-01_JPRB,7.6430E-02_JPRB/)
KBO( :, 5,55,13) = (/&
&2.2232E-01_JPRB,3.2737E-01_JPRB,2.7053E-01_JPRB,1.7756E-01_JPRB,9.9052E-02_JPRB/)
KBO( :, 1,56,13) = (/&
&1.5085E-02_JPRB,2.1991E-02_JPRB,1.8385E-02_JPRB,1.2629E-02_JPRB,2.3210E-02_JPRB/)
KBO( :, 2,56,13) = (/&
&3.1640E-02_JPRB,4.6519E-02_JPRB,3.8293E-02_JPRB,2.5741E-02_JPRB,3.6554E-02_JPRB/)
KBO( :, 3,56,13) = (/&
&6.1401E-02_JPRB,9.0252E-02_JPRB,7.4044E-02_JPRB,4.9175E-02_JPRB,5.3168E-02_JPRB/)
KBO( :, 4,56,13) = (/&
&1.1069E-01_JPRB,1.6371E-01_JPRB,1.3502E-01_JPRB,8.8647E-02_JPRB,7.2863E-02_JPRB/)
KBO( :, 5,56,13) = (/&
&1.8882E-01_JPRB,2.7905E-01_JPRB,2.3042E-01_JPRB,1.5088E-01_JPRB,9.5532E-02_JPRB/)
KBO( :, 1,57,13) = (/&
&1.1497E-02_JPRB,1.6861E-02_JPRB,1.4167E-02_JPRB,9.7433E-03_JPRB,2.0535E-02_JPRB/)
KBO( :, 2,57,13) = (/&
&2.4982E-02_JPRB,3.6767E-02_JPRB,3.0405E-02_JPRB,2.0539E-02_JPRB,3.3381E-02_JPRB/)
KBO( :, 3,57,13) = (/&
&4.9863E-02_JPRB,7.3408E-02_JPRB,6.0172E-02_JPRB,4.0018E-02_JPRB,4.9853E-02_JPRB/)
KBO( :, 4,57,13) = (/&
&9.1973E-02_JPRB,1.3592E-01_JPRB,1.1188E-01_JPRB,7.3644E-02_JPRB,6.9368E-02_JPRB/)
KBO( :, 5,57,13) = (/&
&1.5956E-01_JPRB,2.3633E-01_JPRB,1.9520E-01_JPRB,1.2765E-01_JPRB,9.2143E-02_JPRB/)
KBO( :, 1,58,13) = (/&
&8.7557E-03_JPRB,1.2987E-02_JPRB,1.0957E-02_JPRB,7.5300E-03_JPRB,1.8437E-02_JPRB/)
KBO( :, 2,58,13) = (/&
&1.9822E-02_JPRB,2.9153E-02_JPRB,2.4235E-02_JPRB,1.6460E-02_JPRB,3.1052E-02_JPRB/)
KBO( :, 3,58,13) = (/&
&4.0615E-02_JPRB,5.9904E-02_JPRB,4.9134E-02_JPRB,3.2752E-02_JPRB,4.7553E-02_JPRB/)
KBO( :, 4,58,13) = (/&
&7.6749E-02_JPRB,1.1326E-01_JPRB,9.3033E-02_JPRB,6.1446E-02_JPRB,6.7327E-02_JPRB/)
KBO( :, 5,58,13) = (/&
&1.3538E-01_JPRB,2.0081E-01_JPRB,1.6583E-01_JPRB,1.0846E-01_JPRB,9.0540E-02_JPRB/)
KBO( :, 1,59,13) = (/&
&7.7834E-03_JPRB,1.1635E-02_JPRB,9.8237E-03_JPRB,6.7346E-03_JPRB,2.0567E-02_JPRB/)
KBO( :, 2,59,13) = (/&
&1.7968E-02_JPRB,2.6456E-02_JPRB,2.2028E-02_JPRB,1.4988E-02_JPRB,3.5300E-02_JPRB/)
KBO( :, 3,59,13) = (/&
&3.7275E-02_JPRB,5.5026E-02_JPRB,4.5163E-02_JPRB,3.0132E-02_JPRB,5.4587E-02_JPRB/)
KBO( :, 4,59,13) = (/&
&7.1187E-02_JPRB,1.0502E-01_JPRB,8.6201E-02_JPRB,5.6998E-02_JPRB,7.7965E-02_JPRB/)
KBO( :, 5,59,13) = (/&
&1.2652E-01_JPRB,1.8769E-01_JPRB,1.5496E-01_JPRB,1.0142E-01_JPRB,1.0516E-01_JPRB/)
KBO( :, 1,13,14) = (/&
&2.2524E+00_JPRB,1.8642E+00_JPRB,1.4613E+00_JPRB,1.4569E+00_JPRB,8.7601E+00_JPRB/)
KBO( :, 2,13,14) = (/&
&3.1331E+00_JPRB,2.6017E+00_JPRB,2.0765E+00_JPRB,2.1108E+00_JPRB,8.6837E+00_JPRB/)
KBO( :, 3,13,14) = (/&
&4.2161E+00_JPRB,3.4975E+00_JPRB,2.8332E+00_JPRB,2.9400E+00_JPRB,8.5967E+00_JPRB/)
KBO( :, 4,13,14) = (/&
&5.4742E+00_JPRB,4.5326E+00_JPRB,3.7176E+00_JPRB,3.9461E+00_JPRB,8.5509E+00_JPRB/)
KBO( :, 5,13,14) = (/&
&6.8794E+00_JPRB,5.6742E+00_JPRB,4.7180E+00_JPRB,5.1201E+00_JPRB,8.7332E+00_JPRB/)
KBO( :, 1,14,14) = (/&
&2.4300E+00_JPRB,2.0099E+00_JPRB,1.6039E+00_JPRB,1.5951E+00_JPRB,7.9998E+00_JPRB/)
KBO( :, 2,14,14) = (/&
&3.3671E+00_JPRB,2.7809E+00_JPRB,2.2722E+00_JPRB,2.2861E+00_JPRB,7.9399E+00_JPRB/)
KBO( :, 3,14,14) = (/&
&4.5098E+00_JPRB,3.7249E+00_JPRB,3.1058E+00_JPRB,3.1479E+00_JPRB,7.9396E+00_JPRB/)
KBO( :, 4,14,14) = (/&
&5.8479E+00_JPRB,4.8327E+00_JPRB,4.0848E+00_JPRB,4.1748E+00_JPRB,8.0204E+00_JPRB/)
KBO( :, 5,14,14) = (/&
&7.3485E+00_JPRB,6.0867E+00_JPRB,5.1845E+00_JPRB,5.3505E+00_JPRB,8.4765E+00_JPRB/)
KBO( :, 1,15,14) = (/&
&2.6568E+00_JPRB,2.1796E+00_JPRB,1.7854E+00_JPRB,1.7352E+00_JPRB,6.7060E+00_JPRB/)
KBO( :, 2,15,14) = (/&
&3.6822E+00_JPRB,3.0192E+00_JPRB,2.5118E+00_JPRB,2.4660E+00_JPRB,6.7632E+00_JPRB/)
KBO( :, 3,15,14) = (/&
&4.9145E+00_JPRB,4.0419E+00_JPRB,3.4197E+00_JPRB,3.3625E+00_JPRB,6.9344E+00_JPRB/)
KBO( :, 4,15,14) = (/&
&6.3536E+00_JPRB,5.2540E+00_JPRB,4.4910E+00_JPRB,4.4107E+00_JPRB,7.2734E+00_JPRB/)
KBO( :, 5,15,14) = (/&
&7.9751E+00_JPRB,6.6376E+00_JPRB,5.7127E+00_JPRB,5.6036E+00_JPRB,8.1653E+00_JPRB/)
KBO( :, 1,16,14) = (/&
&2.9427E+00_JPRB,2.4019E+00_JPRB,1.9918E+00_JPRB,1.8807E+00_JPRB,5.4890E+00_JPRB/)
KBO( :, 2,16,14) = (/&
&4.0755E+00_JPRB,3.3334E+00_JPRB,2.7941E+00_JPRB,2.6497E+00_JPRB,5.7267E+00_JPRB/)
KBO( :, 3,16,14) = (/&
&5.4183E+00_JPRB,4.4587E+00_JPRB,3.7848E+00_JPRB,3.5786E+00_JPRB,6.0751E+00_JPRB/)
KBO( :, 4,16,14) = (/&
&6.9849E+00_JPRB,5.7895E+00_JPRB,4.9533E+00_JPRB,4.6688E+00_JPRB,6.8712E+00_JPRB/)
KBO( :, 5,16,14) = (/&
&8.7453E+00_JPRB,7.3192E+00_JPRB,6.3031E+00_JPRB,5.9185E+00_JPRB,8.0451E+00_JPRB/)
KBO( :, 1,17,14) = (/&
&3.2750E+00_JPRB,2.6726E+00_JPRB,2.2378E+00_JPRB,2.0301E+00_JPRB,4.7640E+00_JPRB/)
KBO( :, 2,17,14) = (/&
&4.5330E+00_JPRB,3.7089E+00_JPRB,3.1283E+00_JPRB,2.8374E+00_JPRB,5.1281E+00_JPRB/)
KBO( :, 3,17,14) = (/&
&6.0126E+00_JPRB,4.9507E+00_JPRB,4.2109E+00_JPRB,3.8046E+00_JPRB,5.7513E+00_JPRB/)
KBO( :, 4,17,14) = (/&
&7.7135E+00_JPRB,6.4169E+00_JPRB,5.4921E+00_JPRB,4.9337E+00_JPRB,6.7135E+00_JPRB/)
KBO( :, 5,17,14) = (/&
&9.6338E+00_JPRB,8.1047E+00_JPRB,6.9599E+00_JPRB,6.2366E+00_JPRB,8.0058E+00_JPRB/)
KBO( :, 1,18,14) = (/&
&3.6472E+00_JPRB,2.9807E+00_JPRB,2.5189E+00_JPRB,2.1796E+00_JPRB,4.4334E+00_JPRB/)
KBO( :, 2,18,14) = (/&
&5.0323E+00_JPRB,4.1367E+00_JPRB,3.4979E+00_JPRB,3.0247E+00_JPRB,4.9096E+00_JPRB/)
KBO( :, 3,18,14) = (/&
&6.6454E+00_JPRB,5.5144E+00_JPRB,4.6858E+00_JPRB,4.0381E+00_JPRB,5.6608E+00_JPRB/)
KBO( :, 4,18,14) = (/&
&8.4890E+00_JPRB,7.1264E+00_JPRB,6.0803E+00_JPRB,5.2199E+00_JPRB,6.6925E+00_JPRB/)
KBO( :, 5,18,14) = (/&
&1.0542E+01_JPRB,8.9586E+00_JPRB,7.6601E+00_JPRB,6.5575E+00_JPRB,7.9988E+00_JPRB/)
KBO( :, 1,19,14) = (/&
&4.0274E+00_JPRB,3.3233E+00_JPRB,2.8227E+00_JPRB,2.3261E+00_JPRB,4.2975E+00_JPRB/)
KBO( :, 2,19,14) = (/&
&5.5204E+00_JPRB,4.5992E+00_JPRB,3.8961E+00_JPRB,3.2089E+00_JPRB,4.8408E+00_JPRB/)
KBO( :, 3,19,14) = (/&
&7.2641E+00_JPRB,6.1090E+00_JPRB,5.1847E+00_JPRB,4.2710E+00_JPRB,5.6348E+00_JPRB/)
KBO( :, 4,19,14) = (/&
&9.2241E+00_JPRB,7.8543E+00_JPRB,6.6837E+00_JPRB,5.5155E+00_JPRB,6.6912E+00_JPRB/)
KBO( :, 5,19,14) = (/&
&1.1403E+01_JPRB,9.8034E+00_JPRB,8.3820E+00_JPRB,6.9048E+00_JPRB,7.9670E+00_JPRB/)
KBO( :, 1,20,14) = (/&
&4.4042E+00_JPRB,3.6923E+00_JPRB,3.1564E+00_JPRB,2.5009E+00_JPRB,4.3386E+00_JPRB/)
KBO( :, 2,20,14) = (/&
&6.0056E+00_JPRB,5.0815E+00_JPRB,4.3305E+00_JPRB,3.4328E+00_JPRB,4.8920E+00_JPRB/)
KBO( :, 3,20,14) = (/&
&7.8551E+00_JPRB,6.7164E+00_JPRB,5.7136E+00_JPRB,4.5512E+00_JPRB,5.6658E+00_JPRB/)
KBO( :, 4,20,14) = (/&
&9.9239E+00_JPRB,8.5703E+00_JPRB,7.3215E+00_JPRB,5.8504E+00_JPRB,6.6818E+00_JPRB/)
KBO( :, 5,20,14) = (/&
&1.2197E+01_JPRB,1.0639E+01_JPRB,9.1299E+00_JPRB,7.3134E+00_JPRB,7.9255E+00_JPRB/)
KBO( :, 1,21,14) = (/&
&4.7479E+00_JPRB,4.0508E+00_JPRB,3.4983E+00_JPRB,2.6955E+00_JPRB,4.4010E+00_JPRB/)
KBO( :, 2,21,14) = (/&
&6.4355E+00_JPRB,5.5399E+00_JPRB,4.7678E+00_JPRB,3.6820E+00_JPRB,4.9446E+00_JPRB/)
KBO( :, 3,21,14) = (/&
&8.3663E+00_JPRB,7.2751E+00_JPRB,6.2518E+00_JPRB,4.8572E+00_JPRB,5.6757E+00_JPRB/)
KBO( :, 4,21,14) = (/&
&1.0512E+01_JPRB,9.2314E+00_JPRB,7.9526E+00_JPRB,6.2141E+00_JPRB,6.6288E+00_JPRB/)
KBO( :, 5,21,14) = (/&
&1.2856E+01_JPRB,1.1396E+01_JPRB,9.8659E+00_JPRB,7.7561E+00_JPRB,7.8277E+00_JPRB/)
KBO( :, 1,22,14) = (/&
&5.1420E+00_JPRB,4.4823E+00_JPRB,3.9096E+00_JPRB,2.9527E+00_JPRB,4.4013E+00_JPRB/)
KBO( :, 2,22,14) = (/&
&6.9006E+00_JPRB,6.0705E+00_JPRB,5.2806E+00_JPRB,4.0025E+00_JPRB,4.9528E+00_JPRB/)
KBO( :, 3,22,14) = (/&
&8.8983E+00_JPRB,7.9013E+00_JPRB,6.8678E+00_JPRB,5.2402E+00_JPRB,5.6748E+00_JPRB/)
KBO( :, 4,22,14) = (/&
&1.1116E+01_JPRB,9.9470E+00_JPRB,8.6698E+00_JPRB,6.6674E+00_JPRB,6.5994E+00_JPRB/)
KBO( :, 5,22,14) = (/&
&1.3502E+01_JPRB,1.2202E+01_JPRB,1.0686E+01_JPRB,8.2853E+00_JPRB,7.7517E+00_JPRB/)
KBO( :, 1,23,14) = (/&
&5.4713E+00_JPRB,4.8911E+00_JPRB,4.3072E+00_JPRB,3.2139E+00_JPRB,4.3813E+00_JPRB/)
KBO( :, 2,23,14) = (/&
&7.2751E+00_JPRB,6.5638E+00_JPRB,5.7664E+00_JPRB,4.3250E+00_JPRB,4.9555E+00_JPRB/)
KBO( :, 3,23,14) = (/&
&9.3230E+00_JPRB,8.4735E+00_JPRB,7.4455E+00_JPRB,5.6212E+00_JPRB,5.6783E+00_JPRB/)
KBO( :, 4,23,14) = (/&
&1.1564E+01_JPRB,1.0599E+01_JPRB,9.3428E+00_JPRB,7.1049E+00_JPRB,6.5825E+00_JPRB/)
KBO( :, 5,23,14) = (/&
&1.3974E+01_JPRB,1.2910E+01_JPRB,1.1439E+01_JPRB,8.7857E+00_JPRB,7.6865E+00_JPRB/)
KBO( :, 1,24,14) = (/&
&5.7350E+00_JPRB,5.2712E+00_JPRB,4.6801E+00_JPRB,3.4774E+00_JPRB,4.3078E+00_JPRB/)
KBO( :, 2,24,14) = (/&
&7.5695E+00_JPRB,7.0067E+00_JPRB,6.2189E+00_JPRB,4.6444E+00_JPRB,4.9097E+00_JPRB/)
KBO( :, 3,24,14) = (/&
&9.6279E+00_JPRB,8.9845E+00_JPRB,7.9822E+00_JPRB,5.9954E+00_JPRB,5.6514E+00_JPRB/)
KBO( :, 4,24,14) = (/&
&1.1878E+01_JPRB,1.1160E+01_JPRB,9.9533E+00_JPRB,7.5366E+00_JPRB,6.5532E+00_JPRB/)
KBO( :, 5,24,14) = (/&
&1.4285E+01_JPRB,1.3514E+01_JPRB,1.2126E+01_JPRB,9.2665E+00_JPRB,7.6715E+00_JPRB/)
KBO( :, 1,25,14) = (/&
&5.9267E+00_JPRB,5.6187E+00_JPRB,5.0280E+00_JPRB,3.7387E+00_JPRB,4.2972E+00_JPRB/)
KBO( :, 2,25,14) = (/&
&7.7642E+00_JPRB,7.4077E+00_JPRB,6.6347E+00_JPRB,4.9555E+00_JPRB,4.9309E+00_JPRB/)
KBO( :, 3,25,14) = (/&
&9.8187E+00_JPRB,9.4277E+00_JPRB,8.4720E+00_JPRB,6.3648E+00_JPRB,5.6934E+00_JPRB/)
KBO( :, 4,25,14) = (/&
&1.2059E+01_JPRB,1.1644E+01_JPRB,1.0515E+01_JPRB,7.9525E+00_JPRB,6.6186E+00_JPRB/)
KBO( :, 5,25,14) = (/&
&1.4463E+01_JPRB,1.4040E+01_JPRB,1.2752E+01_JPRB,9.7432E+00_JPRB,7.7714E+00_JPRB/)
KBO( :, 1,26,14) = (/&
&6.0673E+00_JPRB,5.9449E+00_JPRB,5.3655E+00_JPRB,4.0058E+00_JPRB,4.3684E+00_JPRB/)
KBO( :, 2,26,14) = (/&
&7.8884E+00_JPRB,7.7776E+00_JPRB,7.0359E+00_JPRB,5.2751E+00_JPRB,5.0446E+00_JPRB/)
KBO( :, 3,26,14) = (/&
&9.9238E+00_JPRB,9.8293E+00_JPRB,8.9381E+00_JPRB,6.7352E+00_JPRB,5.8349E+00_JPRB/)
KBO( :, 4,26,14) = (/&
&1.2150E+01_JPRB,1.2086E+01_JPRB,1.1047E+01_JPRB,8.3792E+00_JPRB,6.8011E+00_JPRB/)
KBO( :, 5,26,14) = (/&
&1.4535E+01_JPRB,1.4527E+01_JPRB,1.3353E+01_JPRB,1.0236E+01_JPRB,7.9789E+00_JPRB/)
KBO( :, 1,27,14) = (/&
&6.1343E+00_JPRB,6.2302E+00_JPRB,5.6763E+00_JPRB,4.2525E+00_JPRB,4.3799E+00_JPRB/)
KBO( :, 2,27,14) = (/&
&7.9331E+00_JPRB,8.0869E+00_JPRB,7.4032E+00_JPRB,5.5689E+00_JPRB,5.1012E+00_JPRB/)
KBO( :, 3,27,14) = (/&
&9.9492E+00_JPRB,1.0172E+01_JPRB,9.3622E+00_JPRB,7.0779E+00_JPRB,5.9411E+00_JPRB/)
KBO( :, 4,27,14) = (/&
&1.2151E+01_JPRB,1.2467E+01_JPRB,1.1529E+01_JPRB,8.7861E+00_JPRB,6.9495E+00_JPRB/)
KBO( :, 5,27,14) = (/&
&1.4529E+01_JPRB,1.4944E+01_JPRB,1.3914E+01_JPRB,1.0727E+01_JPRB,8.1417E+00_JPRB/)
KBO( :, 1,28,14) = (/&
&6.1453E+00_JPRB,6.4763E+00_JPRB,5.9637E+00_JPRB,4.4841E+00_JPRB,4.3357E+00_JPRB/)
KBO( :, 2,28,14) = (/&
&7.9217E+00_JPRB,8.3599E+00_JPRB,7.7430E+00_JPRB,5.8381E+00_JPRB,5.0957E+00_JPRB/)
KBO( :, 3,28,14) = (/&
&9.9089E+00_JPRB,1.0474E+01_JPRB,9.7521E+00_JPRB,7.4031E+00_JPRB,5.9939E+00_JPRB/)
KBO( :, 4,28,14) = (/&
&1.2103E+01_JPRB,1.2802E+01_JPRB,1.1983E+01_JPRB,9.1765E+00_JPRB,7.0380E+00_JPRB/)
KBO( :, 5,28,14) = (/&
&1.4484E+01_JPRB,1.5315E+01_JPRB,1.4450E+01_JPRB,1.1205E+01_JPRB,8.2560E+00_JPRB/)
KBO( :, 1,29,14) = (/&
&6.1344E+00_JPRB,6.7103E+00_JPRB,6.2468E+00_JPRB,4.7094E+00_JPRB,4.2060E+00_JPRB/)
KBO( :, 2,29,14) = (/&
&7.8873E+00_JPRB,8.6217E+00_JPRB,8.0781E+00_JPRB,6.1108E+00_JPRB,4.9771E+00_JPRB/)
KBO( :, 3,29,14) = (/&
&9.8658E+00_JPRB,1.0771E+01_JPRB,1.0146E+01_JPRB,7.7338E+00_JPRB,5.8851E+00_JPRB/)
KBO( :, 4,29,14) = (/&
&1.2059E+01_JPRB,1.3133E+01_JPRB,1.2445E+01_JPRB,9.5787E+00_JPRB,6.9308E+00_JPRB/)
KBO( :, 5,29,14) = (/&
&1.4440E+01_JPRB,1.5700E+01_JPRB,1.5002E+01_JPRB,1.1702E+01_JPRB,8.1658E+00_JPRB/)
KBO( :, 1,30,14) = (/&
&6.1074E+00_JPRB,6.9340E+00_JPRB,6.5266E+00_JPRB,4.9327E+00_JPRB,4.0096E+00_JPRB/)
KBO( :, 2,30,14) = (/&
&7.8501E+00_JPRB,8.8831E+00_JPRB,8.4088E+00_JPRB,6.3894E+00_JPRB,4.7868E+00_JPRB/)
KBO( :, 3,30,14) = (/&
&9.8321E+00_JPRB,1.1068E+01_JPRB,1.0541E+01_JPRB,8.0663E+00_JPRB,5.6845E+00_JPRB/)
KBO( :, 4,30,14) = (/&
&1.2029E+01_JPRB,1.3476E+01_JPRB,1.2917E+01_JPRB,9.9903E+00_JPRB,6.7312E+00_JPRB/)
KBO( :, 5,30,14) = (/&
&1.4419E+01_JPRB,1.6109E+01_JPRB,1.5573E+01_JPRB,1.2209E+01_JPRB,7.9754E+00_JPRB/)
KBO( :, 1,31,14) = (/&
&6.0986E+00_JPRB,7.1722E+00_JPRB,6.8200E+00_JPRB,5.1755E+00_JPRB,3.7163E+00_JPRB/)
KBO( :, 2,31,14) = (/&
&7.8450E+00_JPRB,9.1619E+00_JPRB,8.7620E+00_JPRB,6.6858E+00_JPRB,4.4619E+00_JPRB/)
KBO( :, 3,31,14) = (/&
&9.8340E+00_JPRB,1.1393E+01_JPRB,1.0969E+01_JPRB,8.4279E+00_JPRB,5.3316E+00_JPRB/)
KBO( :, 4,31,14) = (/&
&1.2043E+01_JPRB,1.3864E+01_JPRB,1.3429E+01_JPRB,1.0440E+01_JPRB,6.3686E+00_JPRB/)
KBO( :, 5,31,14) = (/&
&1.4461E+01_JPRB,1.6571E+01_JPRB,1.6185E+01_JPRB,1.2751E+01_JPRB,7.6315E+00_JPRB/)
KBO( :, 1,32,14) = (/&
&6.1266E+00_JPRB,7.4384E+00_JPRB,7.1350E+00_JPRB,5.4384E+00_JPRB,3.4364E+00_JPRB/)
KBO( :, 2,32,14) = (/&
&7.8843E+00_JPRB,9.4733E+00_JPRB,9.1481E+00_JPRB,7.0065E+00_JPRB,4.1508E+00_JPRB/)
KBO( :, 3,32,14) = (/&
&9.8908E+00_JPRB,1.1765E+01_JPRB,1.1436E+01_JPRB,8.8189E+00_JPRB,5.0057E+00_JPRB/)
KBO( :, 4,32,14) = (/&
&1.2132E+01_JPRB,1.4306E+01_JPRB,1.3989E+01_JPRB,1.0926E+01_JPRB,6.0480E+00_JPRB/)
KBO( :, 5,32,14) = (/&
&1.4591E+01_JPRB,1.7095E+01_JPRB,1.6845E+01_JPRB,1.3332E+01_JPRB,7.3373E+00_JPRB/)
KBO( :, 1,33,14) = (/&
&6.1928E+00_JPRB,7.7310E+00_JPRB,7.4804E+00_JPRB,5.7251E+00_JPRB,3.1571E+00_JPRB/)
KBO( :, 2,33,14) = (/&
&7.9747E+00_JPRB,9.8269E+00_JPRB,9.5731E+00_JPRB,7.3563E+00_JPRB,3.8547E+00_JPRB/)
KBO( :, 3,33,14) = (/&
&1.0016E+01_JPRB,1.2187E+01_JPRB,1.1940E+01_JPRB,9.2481E+00_JPRB,4.7049E+00_JPRB/)
KBO( :, 4,33,14) = (/&
&1.2296E+01_JPRB,1.4804E+01_JPRB,1.4590E+01_JPRB,1.1453E+01_JPRB,5.7736E+00_JPRB/)
KBO( :, 5,33,14) = (/&
&1.4813E+01_JPRB,1.7670E+01_JPRB,1.7552E+01_JPRB,1.3951E+01_JPRB,7.0995E+00_JPRB/)
KBO( :, 1,34,14) = (/&
&6.2424E+00_JPRB,7.9897E+00_JPRB,7.7910E+00_JPRB,5.9836E+00_JPRB,2.9611E+00_JPRB/)
KBO( :, 2,34,14) = (/&
&8.0550E+00_JPRB,1.0143E+01_JPRB,9.9528E+00_JPRB,7.6724E+00_JPRB,3.6568E+00_JPRB/)
KBO( :, 3,34,14) = (/&
&1.0129E+01_JPRB,1.2569E+01_JPRB,1.2399E+01_JPRB,9.6375E+00_JPRB,4.5137E+00_JPRB/)
KBO( :, 4,34,14) = (/&
&1.2455E+01_JPRB,1.5251E+01_JPRB,1.5135E+01_JPRB,1.1928E+01_JPRB,5.6067E+00_JPRB/)
KBO( :, 5,34,14) = (/&
&1.5024E+01_JPRB,1.8190E+01_JPRB,1.8193E+01_JPRB,1.4509E+01_JPRB,6.9726E+00_JPRB/)
KBO( :, 1,35,14) = (/&
&6.1783E+00_JPRB,8.0868E+00_JPRB,7.9354E+00_JPRB,6.1097E+00_JPRB,2.7386E+00_JPRB/)
KBO( :, 2,35,14) = (/&
&8.0021E+00_JPRB,1.0274E+01_JPRB,1.0143E+01_JPRB,7.8342E+00_JPRB,3.4231E+00_JPRB/)
KBO( :, 3,35,14) = (/&
&1.0093E+01_JPRB,1.2741E+01_JPRB,1.2638E+01_JPRB,9.8464E+00_JPRB,4.2817E+00_JPRB/)
KBO( :, 4,35,14) = (/&
&1.2448E+01_JPRB,1.5466E+01_JPRB,1.5430E+01_JPRB,1.2190E+01_JPRB,5.3838E+00_JPRB/)
KBO( :, 5,35,14) = (/&
&1.5050E+01_JPRB,1.8453E+01_JPRB,1.8553E+01_JPRB,1.4830E+01_JPRB,6.7795E+00_JPRB/)
KBO( :, 1,36,14) = (/&
&5.9739E+00_JPRB,7.9879E+00_JPRB,7.8762E+00_JPRB,6.0736E+00_JPRB,2.4966E+00_JPRB/)
KBO( :, 2,36,14) = (/&
&7.7837E+00_JPRB,1.0180E+01_JPRB,1.0097E+01_JPRB,7.8072E+00_JPRB,3.1606E+00_JPRB/)
KBO( :, 3,36,14) = (/&
&9.8723E+00_JPRB,1.2658E+01_JPRB,1.2607E+01_JPRB,9.8330E+00_JPRB,4.0029E+00_JPRB/)
KBO( :, 4,36,14) = (/&
&1.2229E+01_JPRB,1.5396E+01_JPRB,1.5418E+01_JPRB,1.2194E+01_JPRB,5.0917E+00_JPRB/)
KBO( :, 5,36,14) = (/&
&1.4834E+01_JPRB,1.8403E+01_JPRB,1.8570E+01_JPRB,1.4857E+01_JPRB,6.4863E+00_JPRB/)
KBO( :, 1,37,14) = (/&
&5.5612E+00_JPRB,7.6037E+00_JPRB,7.5217E+00_JPRB,5.8049E+00_JPRB,2.2433E+00_JPRB/)
KBO( :, 2,37,14) = (/&
&7.3179E+00_JPRB,9.7571E+00_JPRB,9.7063E+00_JPRB,7.5074E+00_JPRB,2.8646E+00_JPRB/)
KBO( :, 3,37,14) = (/&
&9.3602E+00_JPRB,1.2203E+01_JPRB,1.2188E+01_JPRB,9.5001E+00_JPRB,3.6608E+00_JPRB/)
KBO( :, 4,37,14) = (/&
&1.1681E+01_JPRB,1.4916E+01_JPRB,1.4967E+01_JPRB,1.1825E+01_JPRB,4.7005E+00_JPRB/)
KBO( :, 5,37,14) = (/&
&1.4259E+01_JPRB,1.7897E+01_JPRB,1.8089E+01_JPRB,1.4461E+01_JPRB,6.0475E+00_JPRB/)
KBO( :, 1,38,14) = (/&
&5.1796E+00_JPRB,7.2275E+00_JPRB,7.1681E+00_JPRB,5.5362E+00_JPRB,1.9985E+00_JPRB/)
KBO( :, 2,38,14) = (/&
&6.8825E+00_JPRB,9.3401E+00_JPRB,9.3116E+00_JPRB,7.2050E+00_JPRB,2.5786E+00_JPRB/)
KBO( :, 3,38,14) = (/&
&8.8770E+00_JPRB,1.1748E+01_JPRB,1.1759E+01_JPRB,9.1583E+00_JPRB,3.3304E+00_JPRB/)
KBO( :, 4,38,14) = (/&
&1.1161E+01_JPRB,1.4430E+01_JPRB,1.4508E+01_JPRB,1.1443E+01_JPRB,4.3225E+00_JPRB/)
KBO( :, 5,38,14) = (/&
&1.3706E+01_JPRB,1.7382E+01_JPRB,1.7591E+01_JPRB,1.4049E+01_JPRB,5.6183E+00_JPRB/)
KBO( :, 1,39,14) = (/&
&4.8363E+00_JPRB,6.8762E+00_JPRB,6.8344E+00_JPRB,5.2801E+00_JPRB,1.7623E+00_JPRB/)
KBO( :, 2,39,14) = (/&
&6.4874E+00_JPRB,8.9479E+00_JPRB,8.9339E+00_JPRB,6.9176E+00_JPRB,2.3035E+00_JPRB/)
KBO( :, 3,39,14) = (/&
&8.4367E+00_JPRB,1.1315E+01_JPRB,1.1346E+01_JPRB,8.8331E+00_JPRB,3.0157E+00_JPRB/)
KBO( :, 4,39,14) = (/&
&1.0680E+01_JPRB,1.3965E+01_JPRB,1.4062E+01_JPRB,1.1077E+01_JPRB,3.9619E+00_JPRB/)
KBO( :, 5,39,14) = (/&
&1.3190E+01_JPRB,1.6887E+01_JPRB,1.7105E+01_JPRB,1.3646E+01_JPRB,5.2103E+00_JPRB/)
KBO( :, 1,40,14) = (/&
&4.3793E+00_JPRB,6.3557E+00_JPRB,6.3258E+00_JPRB,4.8864E+00_JPRB,1.5658E+00_JPRB/)
KBO( :, 2,40,14) = (/&
&5.9498E+00_JPRB,8.3535E+00_JPRB,8.3464E+00_JPRB,6.4658E+00_JPRB,2.0604E+00_JPRB/)
KBO( :, 3,40,14) = (/&
&7.8232E+00_JPRB,1.0648E+01_JPRB,1.0689E+01_JPRB,8.3111E+00_JPRB,2.7192E+00_JPRB/)
KBO( :, 4,40,14) = (/&
&9.9941E+00_JPRB,1.3236E+01_JPRB,1.3338E+01_JPRB,1.0477E+01_JPRB,3.5936E+00_JPRB/)
KBO( :, 5,40,14) = (/&
&1.2441E+01_JPRB,1.6098E+01_JPRB,1.6304E+01_JPRB,1.2976E+01_JPRB,4.7608E+00_JPRB/)
KBO( :, 1,41,14) = (/&
&3.9456E+00_JPRB,5.8420E+00_JPRB,5.8231E+00_JPRB,4.4960E+00_JPRB,1.3889E+00_JPRB/)
KBO( :, 2,41,14) = (/&
&5.4322E+00_JPRB,7.7601E+00_JPRB,7.7597E+00_JPRB,6.0124E+00_JPRB,1.8377E+00_JPRB/)
KBO( :, 3,41,14) = (/&
&7.2229E+00_JPRB,9.9804E+00_JPRB,1.0024E+01_JPRB,7.7851E+00_JPRB,2.4432E+00_JPRB/)
KBO( :, 4,41,14) = (/&
&9.3151E+00_JPRB,1.2496E+01_JPRB,1.2598E+01_JPRB,9.8694E+00_JPRB,3.2503E+00_JPRB/)
KBO( :, 5,41,14) = (/&
&1.1696E+01_JPRB,1.5294E+01_JPRB,1.5489E+01_JPRB,1.2290E+01_JPRB,4.3315E+00_JPRB/)
KBO( :, 1,42,14) = (/&
&3.5496E+00_JPRB,5.3598E+00_JPRB,5.3497E+00_JPRB,4.1263E+00_JPRB,1.2230E+00_JPRB/)
KBO( :, 2,42,14) = (/&
&4.9552E+00_JPRB,7.1957E+00_JPRB,7.1981E+00_JPRB,5.5771E+00_JPRB,1.6308E+00_JPRB/)
KBO( :, 3,42,14) = (/&
&6.6624E+00_JPRB,9.3374E+00_JPRB,9.3819E+00_JPRB,7.2830E+00_JPRB,2.1850E+00_JPRB/)
KBO( :, 4,42,14) = (/&
&8.6755E+00_JPRB,1.1781E+01_JPRB,1.1882E+01_JPRB,9.2833E+00_JPRB,2.9295E+00_JPRB/)
KBO( :, 5,42,14) = (/&
&1.0984E+01_JPRB,1.4512E+01_JPRB,1.4694E+01_JPRB,1.1624E+01_JPRB,3.9287E+00_JPRB/)
KBO( :, 1,43,14) = (/&
&3.1237E+00_JPRB,4.8164E+00_JPRB,4.8129E+00_JPRB,3.7055E+00_JPRB,1.0597E+00_JPRB/)
KBO( :, 2,43,14) = (/&
&4.4310E+00_JPRB,6.5524E+00_JPRB,6.5555E+00_JPRB,5.0769E+00_JPRB,1.4220E+00_JPRB/)
KBO( :, 3,43,14) = (/&
&6.0363E+00_JPRB,8.5993E+00_JPRB,8.6369E+00_JPRB,6.7040E+00_JPRB,1.9190E+00_JPRB/)
KBO( :, 4,43,14) = (/&
&7.9515E+00_JPRB,1.0949E+01_JPRB,1.1041E+01_JPRB,8.6082E+00_JPRB,2.5937E+00_JPRB/)
KBO( :, 5,43,14) = (/&
&1.0170E+01_JPRB,1.3594E+01_JPRB,1.3761E+01_JPRB,1.0846E+01_JPRB,3.5024E+00_JPRB/)
KBO( :, 1,44,14) = (/&
&2.7094E+00_JPRB,4.2738E+00_JPRB,4.2715E+00_JPRB,3.2851E+00_JPRB,9.0642E-01_JPRB/)
KBO( :, 2,44,14) = (/&
&3.9148E+00_JPRB,5.9019E+00_JPRB,5.9083E+00_JPRB,4.5708E+00_JPRB,1.2238E+00_JPRB/)
KBO( :, 3,44,14) = (/&
&5.4146E+00_JPRB,7.8441E+00_JPRB,7.8762E+00_JPRB,6.1124E+00_JPRB,1.6632E+00_JPRB/)
KBO( :, 4,44,14) = (/&
&7.2212E+00_JPRB,1.0093E+01_JPRB,1.0172E+01_JPRB,7.9162E+00_JPRB,2.2685E+00_JPRB/)
KBO( :, 5,44,14) = (/&
&9.3383E+00_JPRB,1.2640E+01_JPRB,1.2790E+01_JPRB,1.0039E+01_JPRB,3.0877E+00_JPRB/)
KBO( :, 1,45,14) = (/&
&2.3381E+00_JPRB,3.7708E+00_JPRB,3.7687E+00_JPRB,2.8968E+00_JPRB,7.6661E-01_JPRB/)
KBO( :, 2,45,14) = (/&
&3.4439E+00_JPRB,5.2956E+00_JPRB,5.3039E+00_JPRB,4.0958E+00_JPRB,1.0405E+00_JPRB/)
KBO( :, 3,45,14) = (/&
&4.8375E+00_JPRB,7.1296E+00_JPRB,7.1547E+00_JPRB,5.5510E+00_JPRB,1.4289E+00_JPRB/)
KBO( :, 4,45,14) = (/&
&6.5366E+00_JPRB,9.2742E+00_JPRB,9.3409E+00_JPRB,7.2620E+00_JPRB,1.9684E+00_JPRB/)
KBO( :, 5,45,14) = (/&
&8.5492E+00_JPRB,1.1723E+01_JPRB,1.1855E+01_JPRB,9.2715E+00_JPRB,2.7076E+00_JPRB/)
KBO( :, 1,46,14) = (/&
&1.9868E+00_JPRB,3.2812E+00_JPRB,3.2800E+00_JPRB,2.5190E+00_JPRB,6.4180E-01_JPRB/)
KBO( :, 2,46,14) = (/&
&2.9896E+00_JPRB,4.6959E+00_JPRB,4.7028E+00_JPRB,3.6244E+00_JPRB,8.7338E-01_JPRB/)
KBO( :, 3,46,14) = (/&
&4.2743E+00_JPRB,6.4145E+00_JPRB,6.4351E+00_JPRB,4.9866E+00_JPRB,1.2115E+00_JPRB/)
KBO( :, 4,46,14) = (/&
&5.8592E+00_JPRB,8.4475E+00_JPRB,8.5037E+00_JPRB,6.6059E+00_JPRB,1.6869E+00_JPRB/)
KBO( :, 5,46,14) = (/&
&7.7565E+00_JPRB,1.0789E+01_JPRB,1.0900E+01_JPRB,8.5039E+00_JPRB,2.3466E+00_JPRB/)
KBO( :, 1,47,14) = (/&
&1.6439E+00_JPRB,2.7872E+00_JPRB,2.7853E+00_JPRB,2.1361E+00_JPRB,5.3608E-01_JPRB/)
KBO( :, 2,47,14) = (/&
&2.5332E+00_JPRB,4.0761E+00_JPRB,4.0808E+00_JPRB,3.1417E+00_JPRB,7.2689E-01_JPRB/)
KBO( :, 3,47,14) = (/&
&3.7004E+00_JPRB,5.6682E+00_JPRB,5.6872E+00_JPRB,4.4002E+00_JPRB,1.0142E+00_JPRB/)
KBO( :, 4,47,14) = (/&
&5.1603E+00_JPRB,7.5763E+00_JPRB,7.6194E+00_JPRB,5.9172E+00_JPRB,1.4236E+00_JPRB/)
KBO( :, 5,47,14) = (/&
&6.9294E+00_JPRB,9.7951E+00_JPRB,9.8846E+00_JPRB,7.6954E+00_JPRB,2.0006E+00_JPRB/)
KBO( :, 1,48,14) = (/&
&1.3454E+00_JPRB,2.3441E+00_JPRB,2.3435E+00_JPRB,1.7934E+00_JPRB,4.4332E-01_JPRB/)
KBO( :, 2,48,14) = (/&
&2.1289E+00_JPRB,3.5090E+00_JPRB,3.5130E+00_JPRB,2.7017E+00_JPRB,5.9906E-01_JPRB/)
KBO( :, 3,48,14) = (/&
&3.1810E+00_JPRB,4.9808E+00_JPRB,4.9955E+00_JPRB,3.8562E+00_JPRB,8.3681E-01_JPRB/)
KBO( :, 4,48,14) = (/&
&4.5168E+00_JPRB,6.7583E+00_JPRB,6.7897E+00_JPRB,5.2679E+00_JPRB,1.1898E+00_JPRB/)
KBO( :, 5,48,14) = (/&
&6.1589E+00_JPRB,8.8519E+00_JPRB,8.9240E+00_JPRB,6.9392E+00_JPRB,1.6894E+00_JPRB/)
KBO( :, 1,49,14) = (/&
&1.0880E+00_JPRB,1.9520E+00_JPRB,1.9492E+00_JPRB,1.4892E+00_JPRB,3.6205E-01_JPRB/)
KBO( :, 2,49,14) = (/&
&1.7730E+00_JPRB,2.9965E+00_JPRB,2.9993E+00_JPRB,2.3026E+00_JPRB,4.8696E-01_JPRB/)
KBO( :, 3,49,14) = (/&
&2.7108E+00_JPRB,4.3431E+00_JPRB,4.3550E+00_JPRB,3.3555E+00_JPRB,6.7993E-01_JPRB/)
KBO( :, 4,49,14) = (/&
&3.9297E+00_JPRB,5.9939E+00_JPRB,6.0205E+00_JPRB,4.6638E+00_JPRB,9.7892E-01_JPRB/)
KBO( :, 5,49,14) = (/&
&5.4456E+00_JPRB,7.9623E+00_JPRB,8.0197E+00_JPRB,6.2316E+00_JPRB,1.4097E+00_JPRB/)
KBO( :, 1,50,14) = (/&
&8.8117E-01_JPRB,1.6250E+00_JPRB,1.6221E+00_JPRB,1.2383E+00_JPRB,3.0851E-01_JPRB/)
KBO( :, 2,50,14) = (/&
&1.4792E+00_JPRB,2.5614E+00_JPRB,2.5640E+00_JPRB,1.9649E+00_JPRB,4.1033E-01_JPRB/)
KBO( :, 3,50,14) = (/&
&2.3153E+00_JPRB,3.7911E+00_JPRB,3.7998E+00_JPRB,2.9253E+00_JPRB,5.6911E-01_JPRB/)
KBO( :, 4,50,14) = (/&
&3.4255E+00_JPRB,5.3270E+00_JPRB,5.3498E+00_JPRB,4.1369E+00_JPRB,8.2028E-01_JPRB/)
KBO( :, 5,50,14) = (/&
&4.8249E+00_JPRB,7.1748E+00_JPRB,7.2189E+00_JPRB,5.6068E+00_JPRB,1.1946E+00_JPRB/)
KBO( :, 1,51,14) = (/&
&7.1056E-01_JPRB,1.3442E+00_JPRB,1.3433E+00_JPRB,1.0241E+00_JPRB,2.6969E-01_JPRB/)
KBO( :, 2,51,14) = (/&
&1.2285E+00_JPRB,2.1825E+00_JPRB,2.1836E+00_JPRB,1.6701E+00_JPRB,3.5352E-01_JPRB/)
KBO( :, 3,51,14) = (/&
&1.9719E+00_JPRB,3.3009E+00_JPRB,3.3075E+00_JPRB,2.5431E+00_JPRB,4.8463E-01_JPRB/)
KBO( :, 4,51,14) = (/&
&2.9787E+00_JPRB,4.7254E+00_JPRB,4.7429E+00_JPRB,3.6598E+00_JPRB,6.9430E-01_JPRB/)
KBO( :, 5,51,14) = (/&
&4.2688E+00_JPRB,6.4560E+00_JPRB,6.4905E+00_JPRB,5.0345E+00_JPRB,1.0186E+00_JPRB/)
KBO( :, 1,52,14) = (/&
&5.6673E-01_JPRB,1.0993E+00_JPRB,1.1002E+00_JPRB,8.3639E-01_JPRB,2.3587E-01_JPRB/)
KBO( :, 2,52,14) = (/&
&1.0109E+00_JPRB,1.8431E+00_JPRB,1.8420E+00_JPRB,1.4073E+00_JPRB,3.0435E-01_JPRB/)
KBO( :, 3,52,14) = (/&
&1.6672E+00_JPRB,2.8532E+00_JPRB,2.8589E+00_JPRB,2.1945E+00_JPRB,4.1172E-01_JPRB/)
KBO( :, 4,52,14) = (/&
&2.5718E+00_JPRB,4.1653E+00_JPRB,4.1785E+00_JPRB,3.2201E+00_JPRB,5.8484E-01_JPRB/)
KBO( :, 5,52,14) = (/&
&3.7560E+00_JPRB,5.7814E+00_JPRB,5.8111E+00_JPRB,4.5005E+00_JPRB,8.6103E-01_JPRB/)
KBO( :, 1,53,14) = (/&
&4.4695E-01_JPRB,8.8846E-01_JPRB,8.9001E-01_JPRB,6.7290E-01_JPRB,2.0456E-01_JPRB/)
KBO( :, 2,53,14) = (/&
&8.2293E-01_JPRB,1.5387E+00_JPRB,1.5377E+00_JPRB,1.1737E+00_JPRB,2.6214E-01_JPRB/)
KBO( :, 3,53,14) = (/&
&1.3961E+00_JPRB,2.4467E+00_JPRB,2.4512E+00_JPRB,1.8778E+00_JPRB,3.4832E-01_JPRB/)
KBO( :, 4,53,14) = (/&
&2.2042E+00_JPRB,3.6459E+00_JPRB,3.6556E+00_JPRB,2.8141E+00_JPRB,4.9014E-01_JPRB/)
KBO( :, 5,53,14) = (/&
&3.2850E+00_JPRB,5.1511E+00_JPRB,5.1749E+00_JPRB,4.0006E+00_JPRB,7.2139E-01_JPRB/)
KBO( :, 1,54,14) = (/&
&3.5542E-01_JPRB,7.2243E-01_JPRB,7.2402E-01_JPRB,5.4442E-01_JPRB,1.8822E-01_JPRB/)
KBO( :, 2,54,14) = (/&
&6.7476E-01_JPRB,1.2906E+00_JPRB,1.2914E+00_JPRB,9.8429E-01_JPRB,2.4211E-01_JPRB/)
KBO( :, 3,54,14) = (/&
&1.1767E+00_JPRB,2.1105E+00_JPRB,2.1120E+00_JPRB,1.6159E+00_JPRB,3.1436E-01_JPRB/)
KBO( :, 4,54,14) = (/&
&1.9014E+00_JPRB,3.2074E+00_JPRB,3.2160E+00_JPRB,2.4725E+00_JPRB,4.3384E-01_JPRB/)
KBO( :, 5,54,14) = (/&
&2.8871E+00_JPRB,4.6109E+00_JPRB,4.6302E+00_JPRB,3.5724E+00_JPRB,6.2978E-01_JPRB/)
KBO( :, 1,55,14) = (/&
&2.8206E-01_JPRB,5.8561E-01_JPRB,5.8631E-01_JPRB,4.3881E-01_JPRB,1.7956E-01_JPRB/)
KBO( :, 2,55,14) = (/&
&5.5285E-01_JPRB,1.0805E+00_JPRB,1.0824E+00_JPRB,8.2279E-01_JPRB,2.3170E-01_JPRB/)
KBO( :, 3,55,14) = (/&
&9.9080E-01_JPRB,1.8171E+00_JPRB,1.8174E+00_JPRB,1.3888E+00_JPRB,2.9651E-01_JPRB/)
KBO( :, 4,55,14) = (/&
&1.6397E+00_JPRB,2.8207E+00_JPRB,2.8269E+00_JPRB,2.1700E+00_JPRB,3.9927E-01_JPRB/)
KBO( :, 5,55,14) = (/&
&2.5364E+00_JPRB,4.1246E+00_JPRB,4.1390E+00_JPRB,3.1901E+00_JPRB,5.6676E-01_JPRB/)
KBO( :, 1,56,14) = (/&
&2.2149E-01_JPRB,4.6888E-01_JPRB,4.6793E-01_JPRB,3.4931E-01_JPRB,1.7153E-01_JPRB/)
KBO( :, 2,56,14) = (/&
&4.4941E-01_JPRB,8.9702E-01_JPRB,8.9917E-01_JPRB,6.8030E-01_JPRB,2.2216E-01_JPRB/)
KBO( :, 3,56,14) = (/&
&8.2764E-01_JPRB,1.5520E+00_JPRB,1.5517E+00_JPRB,1.1848E+00_JPRB,2.8403E-01_JPRB/)
KBO( :, 4,56,14) = (/&
&1.4044E+00_JPRB,2.4656E+00_JPRB,2.4713E+00_JPRB,1.8937E+00_JPRB,3.7249E-01_JPRB/)
KBO( :, 5,56,14) = (/&
&2.2168E+00_JPRB,3.6708E+00_JPRB,3.6827E+00_JPRB,2.8356E+00_JPRB,5.1654E-01_JPRB/)
KBO( :, 1,57,14) = (/&
&1.7214E-01_JPRB,3.7079E-01_JPRB,3.6824E-01_JPRB,2.7420E-01_JPRB,1.6338E-01_JPRB/)
KBO( :, 2,57,14) = (/&
&3.6172E-01_JPRB,7.3713E-01_JPRB,7.3924E-01_JPRB,5.5639E-01_JPRB,2.1373E-01_JPRB/)
KBO( :, 3,57,14) = (/&
&6.8570E-01_JPRB,1.3134E+00_JPRB,1.3148E+00_JPRB,1.0025E+00_JPRB,2.7456E-01_JPRB/)
KBO( :, 4,57,14) = (/&
&1.1942E+00_JPRB,2.1424E+00_JPRB,2.1454E+00_JPRB,1.6418E+00_JPRB,3.5310E-01_JPRB/)
KBO( :, 5,57,14) = (/&
&1.9264E+00_JPRB,3.2505E+00_JPRB,3.2602E+00_JPRB,2.5070E+00_JPRB,4.7752E-01_JPRB/)
KBO( :, 1,58,14) = (/&
&1.3445E-01_JPRB,2.9284E-01_JPRB,2.8903E-01_JPRB,2.1482E-01_JPRB,1.5774E-01_JPRB/)
KBO( :, 2,58,14) = (/&
&2.9137E-01_JPRB,6.0563E-01_JPRB,6.0668E-01_JPRB,4.5447E-01_JPRB,2.0929E-01_JPRB/)
KBO( :, 3,58,14) = (/&
&5.6904E-01_JPRB,1.1121E+00_JPRB,1.1143E+00_JPRB,8.4762E-01_JPRB,2.7004E-01_JPRB/)
KBO( :, 4,58,14) = (/&
&1.0164E+00_JPRB,1.8625E+00_JPRB,1.8634E+00_JPRB,1.4242E+00_JPRB,3.4514E-01_JPRB/)
KBO( :, 5,58,14) = (/&
&1.6772E+00_JPRB,2.8815E+00_JPRB,2.8885E+00_JPRB,2.2182E+00_JPRB,4.5564E-01_JPRB/)
KBO( :, 1,59,14) = (/&
&1.2131E-01_JPRB,2.6518E-01_JPRB,2.6089E-01_JPRB,1.9393E-01_JPRB,1.7441E-01_JPRB/)
KBO( :, 2,59,14) = (/&
&2.6626E-01_JPRB,5.5782E-01_JPRB,5.5852E-01_JPRB,4.1787E-01_JPRB,2.3461E-01_JPRB/)
KBO( :, 3,59,14) = (/&
&5.2659E-01_JPRB,1.0377E+00_JPRB,1.0403E+00_JPRB,7.9028E-01_JPRB,3.0633E-01_JPRB/)
KBO( :, 4,59,14) = (/&
&9.5064E-01_JPRB,1.7566E+00_JPRB,1.7573E+00_JPRB,1.3429E+00_JPRB,3.9674E-01_JPRB/)
KBO( :, 5,59,14) = (/&
&1.5830E+00_JPRB,2.7404E+00_JPRB,2.7474E+00_JPRB,2.1087E+00_JPRB,5.2021E-01_JPRB/)
KBO( :, 1,13,15) = (/&
&3.2244E+00_JPRB,2.5409E+00_JPRB,3.1328E+00_JPRB,4.6712E+00_JPRB,1.1048E+01_JPRB/)
KBO( :, 2,13,15) = (/&
&4.5398E+00_JPRB,3.6057E+00_JPRB,4.5237E+00_JPRB,6.7554E+00_JPRB,1.1523E+01_JPRB/)
KBO( :, 3,13,15) = (/&
&6.0837E+00_JPRB,4.8732E+00_JPRB,6.1887E+00_JPRB,9.2622E+00_JPRB,1.3154E+01_JPRB/)
KBO( :, 4,13,15) = (/&
&7.8628E+00_JPRB,6.3217E+00_JPRB,8.1422E+00_JPRB,1.2196E+01_JPRB,1.6296E+01_JPRB/)
KBO( :, 5,13,15) = (/&
&9.8525E+00_JPRB,7.9653E+00_JPRB,1.0472E+01_JPRB,1.5686E+01_JPRB,2.0959E+01_JPRB/)
KBO( :, 1,14,15) = (/&
&3.5755E+00_JPRB,2.8779E+00_JPRB,3.4519E+00_JPRB,5.1028E+00_JPRB,1.0373E+01_JPRB/)
KBO( :, 2,14,15) = (/&
&5.0524E+00_JPRB,4.1250E+00_JPRB,4.9883E+00_JPRB,7.3878E+00_JPRB,1.1513E+01_JPRB/)
KBO( :, 3,14,15) = (/&
&6.8346E+00_JPRB,5.5984E+00_JPRB,6.8212E+00_JPRB,1.0151E+01_JPRB,1.3855E+01_JPRB/)
KBO( :, 4,14,15) = (/&
&8.9000E+00_JPRB,7.2723E+00_JPRB,8.9537E+00_JPRB,1.3379E+01_JPRB,1.7871E+01_JPRB/)
KBO( :, 5,14,15) = (/&
&1.1265E+01_JPRB,9.1701E+00_JPRB,1.1497E+01_JPRB,1.7206E+01_JPRB,2.2981E+01_JPRB/)
KBO( :, 1,15,15) = (/&
&4.0824E+00_JPRB,3.3435E+00_JPRB,3.8164E+00_JPRB,5.5870E+00_JPRB,9.5637E+00_JPRB/)
KBO( :, 2,15,15) = (/&
&5.7577E+00_JPRB,4.7850E+00_JPRB,5.5076E+00_JPRB,8.0842E+00_JPRB,1.1461E+01_JPRB/)
KBO( :, 3,15,15) = (/&
&7.8213E+00_JPRB,6.5007E+00_JPRB,7.5362E+00_JPRB,1.1097E+01_JPRB,1.4826E+01_JPRB/)
KBO( :, 4,15,15) = (/&
&1.0256E+01_JPRB,8.4593E+00_JPRB,9.9114E+00_JPRB,1.4655E+01_JPRB,1.9572E+01_JPRB/)
KBO( :, 5,15,15) = (/&
&1.3032E+01_JPRB,1.0687E+01_JPRB,1.2684E+01_JPRB,1.8793E+01_JPRB,2.5099E+01_JPRB/)
KBO( :, 1,16,15) = (/&
&4.7372E+00_JPRB,3.9270E+00_JPRB,4.2463E+00_JPRB,6.1221E+00_JPRB,9.0976E+00_JPRB/)
KBO( :, 2,16,15) = (/&
&6.6436E+00_JPRB,5.5787E+00_JPRB,6.1045E+00_JPRB,8.8126E+00_JPRB,1.1843E+01_JPRB/)
KBO( :, 3,16,15) = (/&
&9.0517E+00_JPRB,7.5797E+00_JPRB,8.3542E+00_JPRB,1.2092E+01_JPRB,1.6147E+01_JPRB/)
KBO( :, 4,16,15) = (/&
&1.1879E+01_JPRB,9.9008E+00_JPRB,1.1023E+01_JPRB,1.5960E+01_JPRB,2.1309E+01_JPRB/)
KBO( :, 5,16,15) = (/&
&1.5093E+01_JPRB,1.2519E+01_JPRB,1.4078E+01_JPRB,2.0387E+01_JPRB,2.7221E+01_JPRB/)
KBO( :, 1,17,15) = (/&
&5.5197E+00_JPRB,4.6160E+00_JPRB,4.7418E+00_JPRB,6.6773E+00_JPRB,9.2205E+00_JPRB/)
KBO( :, 2,17,15) = (/&
&7.7119E+00_JPRB,6.5019E+00_JPRB,6.7774E+00_JPRB,9.5358E+00_JPRB,1.2727E+01_JPRB/)
KBO( :, 3,17,15) = (/&
&1.0467E+01_JPRB,8.8388E+00_JPRB,9.2742E+00_JPRB,1.3058E+01_JPRB,1.7430E+01_JPRB/)
KBO( :, 4,17,15) = (/&
&1.3720E+01_JPRB,1.1553E+01_JPRB,1.2244E+01_JPRB,1.7227E+01_JPRB,2.2998E+01_JPRB/)
KBO( :, 5,17,15) = (/&
&1.7413E+01_JPRB,1.4594E+01_JPRB,1.5673E+01_JPRB,2.2047E+01_JPRB,2.9433E+01_JPRB/)
KBO( :, 1,18,15) = (/&
&6.4274E+00_JPRB,5.4111E+00_JPRB,5.3034E+00_JPRB,7.2350E+00_JPRB,9.7622E+00_JPRB/)
KBO( :, 2,18,15) = (/&
&8.9573E+00_JPRB,7.5807E+00_JPRB,7.5479E+00_JPRB,1.0273E+01_JPRB,1.3710E+01_JPRB/)
KBO( :, 3,18,15) = (/&
&1.2111E+01_JPRB,1.0258E+01_JPRB,1.0321E+01_JPRB,1.4006E+01_JPRB,1.8696E+01_JPRB/)
KBO( :, 4,18,15) = (/&
&1.5845E+01_JPRB,1.3386E+01_JPRB,1.3622E+01_JPRB,1.8470E+01_JPRB,2.4650E+01_JPRB/)
KBO( :, 5,18,15) = (/&
&2.0084E+01_JPRB,1.6890E+01_JPRB,1.7434E+01_JPRB,2.3673E+01_JPRB,3.1599E+01_JPRB/)
KBO( :, 1,19,15) = (/&
&7.5164E+00_JPRB,6.3134E+00_JPRB,5.9395E+00_JPRB,7.8093E+00_JPRB,1.0475E+01_JPRB/)
KBO( :, 2,19,15) = (/&
&1.0441E+01_JPRB,8.8014E+00_JPRB,8.4278E+00_JPRB,1.1035E+01_JPRB,1.4729E+01_JPRB/)
KBO( :, 3,19,15) = (/&
&1.4043E+01_JPRB,1.1861E+01_JPRB,1.1513E+01_JPRB,1.4988E+01_JPRB,2.0004E+01_JPRB/)
KBO( :, 4,19,15) = (/&
&1.8322E+01_JPRB,1.5433E+01_JPRB,1.5177E+01_JPRB,1.9715E+01_JPRB,2.6318E+01_JPRB/)
KBO( :, 5,19,15) = (/&
&2.3146E+01_JPRB,1.9466E+01_JPRB,1.9384E+01_JPRB,2.5255E+01_JPRB,3.3709E+01_JPRB/)
KBO( :, 1,20,15) = (/&
&8.8455E+00_JPRB,7.4066E+00_JPRB,6.7186E+00_JPRB,8.4558E+00_JPRB,1.1343E+01_JPRB/)
KBO( :, 2,20,15) = (/&
&1.2219E+01_JPRB,1.0275E+01_JPRB,9.4871E+00_JPRB,1.1882E+01_JPRB,1.5858E+01_JPRB/)
KBO( :, 3,20,15) = (/&
&1.6346E+01_JPRB,1.3763E+01_JPRB,1.2931E+01_JPRB,1.6095E+01_JPRB,2.1479E+01_JPRB/)
KBO( :, 4,20,15) = (/&
&2.1206E+01_JPRB,1.7855E+01_JPRB,1.6990E+01_JPRB,2.1127E+01_JPRB,2.8198E+01_JPRB/)
KBO( :, 5,20,15) = (/&
&2.6661E+01_JPRB,2.2435E+01_JPRB,2.1640E+01_JPRB,2.6969E+01_JPRB,3.5995E+01_JPRB/)
KBO( :, 1,21,15) = (/&
&1.0378E+01_JPRB,8.6731E+00_JPRB,7.6340E+00_JPRB,9.1349E+00_JPRB,1.2281E+01_JPRB/)
KBO( :, 2,21,15) = (/&
&1.4246E+01_JPRB,1.1959E+01_JPRB,1.0712E+01_JPRB,1.2780E+01_JPRB,1.7040E+01_JPRB/)
KBO( :, 3,21,15) = (/&
&1.8940E+01_JPRB,1.5929E+01_JPRB,1.4528E+01_JPRB,1.7265E+01_JPRB,2.3018E+01_JPRB/)
KBO( :, 4,21,15) = (/&
&2.4416E+01_JPRB,2.0563E+01_JPRB,1.9019E+01_JPRB,2.2602E+01_JPRB,3.0124E+01_JPRB/)
KBO( :, 5,21,15) = (/&
&3.0523E+01_JPRB,2.5747E+01_JPRB,2.4135E+01_JPRB,2.8712E+01_JPRB,3.8248E+01_JPRB/)
KBO( :, 1,22,15) = (/&
&1.2355E+01_JPRB,1.0324E+01_JPRB,8.9103E+00_JPRB,1.0132E+01_JPRB,1.3532E+01_JPRB/)
KBO( :, 2,22,15) = (/&
&1.6827E+01_JPRB,1.4110E+01_JPRB,1.2397E+01_JPRB,1.4085E+01_JPRB,1.8635E+01_JPRB/)
KBO( :, 3,22,15) = (/&
&2.2180E+01_JPRB,1.8653E+01_JPRB,1.6659E+01_JPRB,1.8921E+01_JPRB,2.5003E+01_JPRB/)
KBO( :, 4,22,15) = (/&
&2.8311E+01_JPRB,2.3905E+01_JPRB,2.1641E+01_JPRB,2.4584E+01_JPRB,3.2472E+01_JPRB/)
KBO( :, 5,22,15) = (/&
&3.5149E+01_JPRB,2.9738E+01_JPRB,2.7250E+01_JPRB,3.1004E+01_JPRB,4.0987E+01_JPRB/)
KBO( :, 1,23,15) = (/&
&1.4605E+01_JPRB,1.2205E+01_JPRB,1.0445E+01_JPRB,1.1291E+01_JPRB,1.4871E+01_JPRB/)
KBO( :, 2,23,15) = (/&
&1.9716E+01_JPRB,1.6539E+01_JPRB,1.4376E+01_JPRB,1.5566E+01_JPRB,2.0310E+01_JPRB/)
KBO( :, 3,23,15) = (/&
&2.5726E+01_JPRB,2.1683E+01_JPRB,1.9115E+01_JPRB,2.0736E+01_JPRB,2.6995E+01_JPRB/)
KBO( :, 4,23,15) = (/&
&3.2572E+01_JPRB,2.7566E+01_JPRB,2.4581E+01_JPRB,2.6716E+01_JPRB,3.4786E+01_JPRB/)
KBO( :, 5,23,15) = (/&
&4.0123E+01_JPRB,3.4080E+01_JPRB,3.0686E+01_JPRB,3.3457E+01_JPRB,4.3686E+01_JPRB/)
KBO( :, 1,24,15) = (/&
&1.7134E+01_JPRB,1.4330E+01_JPRB,1.2237E+01_JPRB,1.2592E+01_JPRB,1.6241E+01_JPRB/)
KBO( :, 2,24,15) = (/&
&2.2882E+01_JPRB,1.9252E+01_JPRB,1.6642E+01_JPRB,1.7193E+01_JPRB,2.2035E+01_JPRB/)
KBO( :, 3,24,15) = (/&
&2.9584E+01_JPRB,2.5005E+01_JPRB,2.1866E+01_JPRB,2.2682E+01_JPRB,2.9023E+01_JPRB/)
KBO( :, 4,24,15) = (/&
&3.7130E+01_JPRB,3.1556E+01_JPRB,2.7836E+01_JPRB,2.8990E+01_JPRB,3.7154E+01_JPRB/)
KBO( :, 5,24,15) = (/&
&4.5388E+01_JPRB,3.8713E+01_JPRB,3.4446E+01_JPRB,3.6104E+01_JPRB,4.6377E+01_JPRB/)
KBO( :, 1,25,15) = (/&
&1.9927E+01_JPRB,1.6707E+01_JPRB,1.4288E+01_JPRB,1.4051E+01_JPRB,1.7699E+01_JPRB/)
KBO( :, 2,25,15) = (/&
&2.6343E+01_JPRB,2.2217E+01_JPRB,1.9188E+01_JPRB,1.8973E+01_JPRB,2.3814E+01_JPRB/)
KBO( :, 3,25,15) = (/&
&3.3724E+01_JPRB,2.8620E+01_JPRB,2.4897E+01_JPRB,2.4764E+01_JPRB,3.1106E+01_JPRB/)
KBO( :, 4,25,15) = (/&
&4.1952E+01_JPRB,3.5794E+01_JPRB,3.1378E+01_JPRB,3.1440E+01_JPRB,3.9572E+01_JPRB/)
KBO( :, 5,25,15) = (/&
&5.0891E+01_JPRB,4.3587E+01_JPRB,3.8479E+01_JPRB,3.8878E+01_JPRB,4.9030E+01_JPRB/)
KBO( :, 1,26,15) = (/&
&2.3026E+01_JPRB,1.9365E+01_JPRB,1.6616E+01_JPRB,1.5692E+01_JPRB,1.9320E+01_JPRB/)
KBO( :, 2,26,15) = (/&
&3.0129E+01_JPRB,2.5491E+01_JPRB,2.2032E+01_JPRB,2.0944E+01_JPRB,2.5726E+01_JPRB/)
KBO( :, 3,26,15) = (/&
&3.8188E+01_JPRB,3.2536E+01_JPRB,2.8266E+01_JPRB,2.7089E+01_JPRB,3.3354E+01_JPRB/)
KBO( :, 4,26,15) = (/&
&4.7076E+01_JPRB,4.0316E+01_JPRB,3.5238E+01_JPRB,3.4113E+01_JPRB,4.2106E+01_JPRB/)
KBO( :, 5,26,15) = (/&
&5.6691E+01_JPRB,4.8702E+01_JPRB,4.2828E+01_JPRB,4.1890E+01_JPRB,5.1865E+01_JPRB/)
KBO( :, 1,27,15) = (/&
&2.6319E+01_JPRB,2.2209E+01_JPRB,1.9103E+01_JPRB,1.7475E+01_JPRB,2.1047E+01_JPRB/)
KBO( :, 2,27,15) = (/&
&3.4077E+01_JPRB,2.8961E+01_JPRB,2.5047E+01_JPRB,2.3066E+01_JPRB,2.7740E+01_JPRB/)
KBO( :, 3,27,15) = (/&
&4.2766E+01_JPRB,3.6599E+01_JPRB,3.1799E+01_JPRB,2.9545E+01_JPRB,3.5624E+01_JPRB/)
KBO( :, 4,27,15) = (/&
&5.2311E+01_JPRB,4.4949E+01_JPRB,3.9254E+01_JPRB,3.6881E+01_JPRB,4.4625E+01_JPRB/)
KBO( :, 5,27,15) = (/&
&6.2535E+01_JPRB,5.3903E+01_JPRB,4.7276E+01_JPRB,4.4959E+01_JPRB,5.4744E+01_JPRB/)
KBO( :, 1,28,15) = (/&
&2.9739E+01_JPRB,2.5212E+01_JPRB,2.1725E+01_JPRB,1.9370E+01_JPRB,2.2823E+01_JPRB/)
KBO( :, 2,28,15) = (/&
&3.8111E+01_JPRB,3.2556E+01_JPRB,2.8178E+01_JPRB,2.5312E+01_JPRB,2.9805E+01_JPRB/)
KBO( :, 3,28,15) = (/&
&4.7442E+01_JPRB,4.0758E+01_JPRB,3.5447E+01_JPRB,3.2130E+01_JPRB,3.7952E+01_JPRB/)
KBO( :, 4,28,15) = (/&
&5.7581E+01_JPRB,4.9637E+01_JPRB,4.3359E+01_JPRB,3.9780E+01_JPRB,4.7241E+01_JPRB/)
KBO( :, 5,28,15) = (/&
&6.8350E+01_JPRB,5.9110E+01_JPRB,5.1790E+01_JPRB,4.8135E+01_JPRB,5.7711E+01_JPRB/)
KBO( :, 1,29,15) = (/&
&3.3289E+01_JPRB,2.8377E+01_JPRB,2.4485E+01_JPRB,2.1425E+01_JPRB,2.4625E+01_JPRB/)
KBO( :, 2,29,15) = (/&
&4.2270E+01_JPRB,3.6277E+01_JPRB,3.1445E+01_JPRB,2.7695E+01_JPRB,3.1898E+01_JPRB/)
KBO( :, 3,29,15) = (/&
&5.2200E+01_JPRB,4.5001E+01_JPRB,3.9165E+01_JPRB,3.4833E+01_JPRB,4.0336E+01_JPRB/)
KBO( :, 4,29,15) = (/&
&6.2884E+01_JPRB,5.4377E+01_JPRB,4.7526E+01_JPRB,4.2792E+01_JPRB,4.9976E+01_JPRB/)
KBO( :, 5,29,15) = (/&
&7.4157E+01_JPRB,6.4312E+01_JPRB,5.6343E+01_JPRB,5.1436E+01_JPRB,6.0842E+01_JPRB/)
KBO( :, 1,30,15) = (/&
&3.6922E+01_JPRB,3.1637E+01_JPRB,2.7336E+01_JPRB,2.3566E+01_JPRB,2.6436E+01_JPRB/)
KBO( :, 2,30,15) = (/&
&4.6484E+01_JPRB,4.0046E+01_JPRB,3.4764E+01_JPRB,3.0148E+01_JPRB,3.4000E+01_JPRB/)
KBO( :, 3,30,15) = (/&
&5.6941E+01_JPRB,4.9235E+01_JPRB,4.2907E+01_JPRB,3.7604E+01_JPRB,4.2767E+01_JPRB/)
KBO( :, 4,30,15) = (/&
&6.8119E+01_JPRB,5.9074E+01_JPRB,5.1660E+01_JPRB,4.5840E+01_JPRB,5.2778E+01_JPRB/)
KBO( :, 5,30,15) = (/&
&7.9816E+01_JPRB,6.9391E+01_JPRB,6.0797E+01_JPRB,5.4746E+01_JPRB,6.4070E+01_JPRB/)
KBO( :, 1,31,15) = (/&
&4.0648E+01_JPRB,3.4989E+01_JPRB,3.0276E+01_JPRB,2.5790E+01_JPRB,2.8253E+01_JPRB/)
KBO( :, 2,31,15) = (/&
&5.0739E+01_JPRB,4.3869E+01_JPRB,3.8136E+01_JPRB,3.2693E+01_JPRB,3.6176E+01_JPRB/)
KBO( :, 3,31,15) = (/&
&6.1698E+01_JPRB,5.3493E+01_JPRB,4.6669E+01_JPRB,4.0453E+01_JPRB,4.5327E+01_JPRB/)
KBO( :, 4,31,15) = (/&
&7.3307E+01_JPRB,6.3725E+01_JPRB,5.5765E+01_JPRB,4.8944E+01_JPRB,5.5745E+01_JPRB/)
KBO( :, 5,31,15) = (/&
&8.5379E+01_JPRB,7.4384E+01_JPRB,6.5189E+01_JPRB,5.8116E+01_JPRB,6.7439E+01_JPRB/)
KBO( :, 1,32,15) = (/&
&4.4430E+01_JPRB,3.8384E+01_JPRB,3.3279E+01_JPRB,2.8093E+01_JPRB,3.0198E+01_JPRB/)
KBO( :, 2,32,15) = (/&
&5.5010E+01_JPRB,4.7713E+01_JPRB,4.1521E+01_JPRB,3.5304E+01_JPRB,3.8486E+01_JPRB/)
KBO( :, 3,32,15) = (/&
&6.6406E+01_JPRB,5.7714E+01_JPRB,5.0403E+01_JPRB,4.3340E+01_JPRB,4.8019E+01_JPRB/)
KBO( :, 4,32,15) = (/&
&7.8394E+01_JPRB,6.8294E+01_JPRB,5.9802E+01_JPRB,5.2093E+01_JPRB,5.8861E+01_JPRB/)
KBO( :, 5,32,15) = (/&
&9.0789E+01_JPRB,7.9248E+01_JPRB,6.9496E+01_JPRB,6.1520E+01_JPRB,7.0971E+01_JPRB/)
KBO( :, 1,33,15) = (/&
&4.8242E+01_JPRB,4.1814E+01_JPRB,3.6311E+01_JPRB,3.0445E+01_JPRB,3.2261E+01_JPRB/)
KBO( :, 2,33,15) = (/&
&5.9259E+01_JPRB,5.1534E+01_JPRB,4.4898E+01_JPRB,3.7953E+01_JPRB,4.0933E+01_JPRB/)
KBO( :, 3,33,15) = (/&
&7.1044E+01_JPRB,6.1877E+01_JPRB,5.4099E+01_JPRB,4.6243E+01_JPRB,5.0861E+01_JPRB/)
KBO( :, 4,33,15) = (/&
&8.3385E+01_JPRB,7.2754E+01_JPRB,6.3738E+01_JPRB,5.5225E+01_JPRB,6.2072E+01_JPRB/)
KBO( :, 5,33,15) = (/&
&9.6014E+01_JPRB,8.3965E+01_JPRB,7.3665E+01_JPRB,6.4932E+01_JPRB,7.4660E+01_JPRB/)
KBO( :, 1,34,15) = (/&
&5.1672E+01_JPRB,4.4907E+01_JPRB,3.9052E+01_JPRB,3.2559E+01_JPRB,3.4150E+01_JPRB/)
KBO( :, 2,34,15) = (/&
&6.3066E+01_JPRB,5.4942E+01_JPRB,4.7932E+01_JPRB,4.0320E+01_JPRB,4.3137E+01_JPRB/)
KBO( :, 3,34,15) = (/&
&7.5181E+01_JPRB,6.5586E+01_JPRB,5.7376E+01_JPRB,4.8848E+01_JPRB,5.3416E+01_JPRB/)
KBO( :, 4,34,15) = (/&
&8.7786E+01_JPRB,7.6718E+01_JPRB,6.7237E+01_JPRB,5.8022E+01_JPRB,6.4986E+01_JPRB/)
KBO( :, 5,34,15) = (/&
&1.0062E+02_JPRB,8.8122E+01_JPRB,7.7322E+01_JPRB,6.7972E+01_JPRB,7.7968E+01_JPRB/)
KBO( :, 1,35,15) = (/&
&5.3974E+01_JPRB,4.7010E+01_JPRB,4.0914E+01_JPRB,3.3953E+01_JPRB,3.5284E+01_JPRB/)
KBO( :, 2,35,15) = (/&
&6.5632E+01_JPRB,5.7261E+01_JPRB,4.9986E+01_JPRB,4.1880E+01_JPRB,4.4477E+01_JPRB/)
KBO( :, 3,35,15) = (/&
&7.7983E+01_JPRB,6.8108E+01_JPRB,5.9607E+01_JPRB,5.0554E+01_JPRB,5.4966E+01_JPRB/)
KBO( :, 4,35,15) = (/&
&9.0774E+01_JPRB,7.9423E+01_JPRB,6.9615E+01_JPRB,5.9856E+01_JPRB,6.6747E+01_JPRB/)
KBO( :, 5,35,15) = (/&
&1.0376E+02_JPRB,9.0958E+01_JPRB,7.9827E+01_JPRB,6.9953E+01_JPRB,7.9975E+01_JPRB/)
KBO( :, 1,36,15) = (/&
&5.4952E+01_JPRB,4.7928E+01_JPRB,4.1728E+01_JPRB,3.4482E+01_JPRB,3.5497E+01_JPRB/)
KBO( :, 2,36,15) = (/&
&6.6748E+01_JPRB,5.8304E+01_JPRB,5.0900E+01_JPRB,4.2469E+01_JPRB,4.4743E+01_JPRB/)
KBO( :, 3,36,15) = (/&
&7.9237E+01_JPRB,6.9268E+01_JPRB,6.0630E+01_JPRB,5.1203E+01_JPRB,5.5299E+01_JPRB/)
KBO( :, 4,36,15) = (/&
&9.2160E+01_JPRB,8.0690E+01_JPRB,7.0740E+01_JPRB,6.0560E+01_JPRB,6.7150E+01_JPRB/)
KBO( :, 5,36,15) = (/&
&1.0527E+02_JPRB,9.2347E+01_JPRB,8.1033E+01_JPRB,7.0691E+01_JPRB,8.0445E+01_JPRB/)
KBO( :, 1,37,15) = (/&
&5.4077E+01_JPRB,4.7203E+01_JPRB,4.1090E+01_JPRB,3.3816E+01_JPRB,3.4402E+01_JPRB/)
KBO( :, 2,37,15) = (/&
&6.5871E+01_JPRB,5.7581E+01_JPRB,5.0256E+01_JPRB,4.1730E+01_JPRB,4.3504E+01_JPRB/)
KBO( :, 3,37,15) = (/&
&7.8394E+01_JPRB,6.8564E+01_JPRB,6.0003E+01_JPRB,5.0406E+01_JPRB,5.3919E+01_JPRB/)
KBO( :, 4,37,15) = (/&
&9.1373E+01_JPRB,8.0024E+01_JPRB,7.0155E+01_JPRB,5.9711E+01_JPRB,6.5630E+01_JPRB/)
KBO( :, 5,37,15) = (/&
&1.0457E+02_JPRB,9.1743E+01_JPRB,8.0502E+01_JPRB,6.9769E+01_JPRB,7.8764E+01_JPRB/)
KBO( :, 1,38,15) = (/&
&5.2998E+01_JPRB,4.6292E+01_JPRB,4.0284E+01_JPRB,3.3047E+01_JPRB,3.3256E+01_JPRB/)
KBO( :, 2,38,15) = (/&
&6.4758E+01_JPRB,5.6646E+01_JPRB,4.9430E+01_JPRB,4.0867E+01_JPRB,4.2193E+01_JPRB/)
KBO( :, 3,38,15) = (/&
&7.7286E+01_JPRB,6.7628E+01_JPRB,5.9170E+01_JPRB,4.9481E+01_JPRB,5.2447E+01_JPRB/)
KBO( :, 4,38,15) = (/&
&9.0295E+01_JPRB,7.9101E+01_JPRB,6.9339E+01_JPRB,5.8727E+01_JPRB,6.4002E+01_JPRB/)
KBO( :, 5,38,15) = (/&
&1.0355E+02_JPRB,9.0878E+01_JPRB,7.9733E+01_JPRB,6.8695E+01_JPRB,7.6964E+01_JPRB/)
KBO( :, 1,39,15) = (/&
&5.1838E+01_JPRB,4.5309E+01_JPRB,3.9414E+01_JPRB,3.2253E+01_JPRB,3.2133E+01_JPRB/)
KBO( :, 2,39,15) = (/&
&6.3550E+01_JPRB,5.5622E+01_JPRB,4.8527E+01_JPRB,3.9972E+01_JPRB,4.0905E+01_JPRB/)
KBO( :, 3,39,15) = (/&
&7.6056E+01_JPRB,6.6591E+01_JPRB,5.8243E+01_JPRB,4.8504E+01_JPRB,5.0987E+01_JPRB/)
KBO( :, 4,39,15) = (/&
&8.9075E+01_JPRB,7.8055E+01_JPRB,6.8422E+01_JPRB,5.7684E+01_JPRB,6.2386E+01_JPRB/)
KBO( :, 5,39,15) = (/&
&1.0239E+02_JPRB,8.9867E+01_JPRB,7.8837E+01_JPRB,6.7576E+01_JPRB,7.5172E+01_JPRB/)
KBO( :, 1,40,15) = (/&
&4.9471E+01_JPRB,4.3246E+01_JPRB,3.7591E+01_JPRB,3.0698E+01_JPRB,3.0218E+01_JPRB/)
KBO( :, 2,40,15) = (/&
&6.1032E+01_JPRB,5.3431E+01_JPRB,4.6594E+01_JPRB,3.8229E+01_JPRB,3.8702E+01_JPRB/)
KBO( :, 3,40,15) = (/&
&7.3417E+01_JPRB,6.4309E+01_JPRB,5.6223E+01_JPRB,4.6591E+01_JPRB,4.8455E+01_JPRB/)
KBO( :, 4,40,15) = (/&
&8.6398E+01_JPRB,7.5721E+01_JPRB,6.6340E+01_JPRB,5.5655E+01_JPRB,5.9567E+01_JPRB/)
KBO( :, 5,40,15) = (/&
&9.9725E+01_JPRB,8.7493E+01_JPRB,7.6754E+01_JPRB,6.5366E+01_JPRB,7.2010E+01_JPRB/)
KBO( :, 1,41,15) = (/&
&4.6940E+01_JPRB,4.1029E+01_JPRB,3.5646E+01_JPRB,2.9054E+01_JPRB,2.8252E+01_JPRB/)
KBO( :, 2,41,15) = (/&
&5.8303E+01_JPRB,5.1061E+01_JPRB,4.4488E+01_JPRB,3.6382E+01_JPRB,3.6429E+01_JPRB/)
KBO( :, 3,41,15) = (/&
&7.0545E+01_JPRB,6.1809E+01_JPRB,5.4014E+01_JPRB,4.4569E+01_JPRB,4.5866E+01_JPRB/)
KBO( :, 4,41,15) = (/&
&8.3446E+01_JPRB,7.3140E+01_JPRB,6.4053E+01_JPRB,5.3489E+01_JPRB,5.6653E+01_JPRB/)
KBO( :, 5,41,15) = (/&
&9.6762E+01_JPRB,8.4890E+01_JPRB,7.4453E+01_JPRB,6.3028E+01_JPRB,6.8762E+01_JPRB/)
KBO( :, 1,42,15) = (/&
&4.4400E+01_JPRB,3.8808E+01_JPRB,3.3695E+01_JPRB,2.7433E+01_JPRB,2.6367E+01_JPRB/)
KBO( :, 2,42,15) = (/&
&5.5548E+01_JPRB,4.8653E+01_JPRB,4.2370E+01_JPRB,3.4558E+01_JPRB,3.4231E+01_JPRB/)
KBO( :, 3,42,15) = (/&
&6.7639E+01_JPRB,5.9264E+01_JPRB,5.1765E+01_JPRB,4.2548E+01_JPRB,4.3345E+01_JPRB/)
KBO( :, 4,42,15) = (/&
&8.0422E+01_JPRB,7.0505E+01_JPRB,6.1708E+01_JPRB,5.1309E+01_JPRB,5.3802E+01_JPRB/)
KBO( :, 5,42,15) = (/&
&9.3690E+01_JPRB,8.2187E+01_JPRB,7.2071E+01_JPRB,6.0692E+01_JPRB,6.5582E+01_JPRB/)
KBO( :, 1,43,15) = (/&
&4.1299E+01_JPRB,3.6086E+01_JPRB,3.1303E+01_JPRB,2.5481E+01_JPRB,2.4168E+01_JPRB/)
KBO( :, 2,43,15) = (/&
&5.2146E+01_JPRB,4.5668E+01_JPRB,3.9733E+01_JPRB,3.2349E+01_JPRB,3.1657E+01_JPRB/)
KBO( :, 3,43,15) = (/&
&6.3997E+01_JPRB,5.6104E+01_JPRB,4.8948E+01_JPRB,4.0078E+01_JPRB,4.0382E+01_JPRB/)
KBO( :, 4,43,15) = (/&
&7.6621E+01_JPRB,6.7188E+01_JPRB,5.8773E+01_JPRB,4.8617E+01_JPRB,5.0407E+01_JPRB/)
KBO( :, 5,43,15) = (/&
&8.9810E+01_JPRB,7.8771E+01_JPRB,6.9043E+01_JPRB,5.7825E+01_JPRB,6.1798E+01_JPRB/)
KBO( :, 1,44,15) = (/&
&3.8013E+01_JPRB,3.3205E+01_JPRB,2.8794E+01_JPRB,2.3425E+01_JPRB,2.1911E+01_JPRB/)
KBO( :, 2,44,15) = (/&
&4.8506E+01_JPRB,4.2466E+01_JPRB,3.6916E+01_JPRB,3.0017E+01_JPRB,2.8999E+01_JPRB/)
KBO( :, 3,44,15) = (/&
&6.0070E+01_JPRB,5.2664E+01_JPRB,4.5908E+01_JPRB,3.7464E+01_JPRB,3.7309E+01_JPRB/)
KBO( :, 4,44,15) = (/&
&7.2479E+01_JPRB,6.3560E+01_JPRB,5.5564E+01_JPRB,4.5749E+01_JPRB,4.6877E+01_JPRB/)
KBO( :, 5,44,15) = (/&
&8.5539E+01_JPRB,7.5028E+01_JPRB,6.5726E+01_JPRB,5.4770E+01_JPRB,5.7838E+01_JPRB/)
KBO( :, 1,45,15) = (/&
&3.4808E+01_JPRB,3.0429E+01_JPRB,2.6372E+01_JPRB,2.1438E+01_JPRB,1.9764E+01_JPRB/)
KBO( :, 2,45,15) = (/&
&4.4949E+01_JPRB,3.9329E+01_JPRB,3.4164E+01_JPRB,2.7759E+01_JPRB,2.6477E+01_JPRB/)
KBO( :, 3,45,15) = (/&
&5.6198E+01_JPRB,4.9271E+01_JPRB,4.2916E+01_JPRB,3.4929E+01_JPRB,3.4365E+01_JPRB/)
KBO( :, 4,45,15) = (/&
&6.8372E+01_JPRB,5.9966E+01_JPRB,5.2371E+01_JPRB,4.2948E+01_JPRB,4.3515E+01_JPRB/)
KBO( :, 5,45,15) = (/&
&8.1258E+01_JPRB,7.1280E+01_JPRB,6.2402E+01_JPRB,5.1752E+01_JPRB,5.3999E+01_JPRB/)
KBO( :, 1,46,15) = (/&
&3.1505E+01_JPRB,2.7578E+01_JPRB,2.3887E+01_JPRB,1.9401E+01_JPRB,1.7612E+01_JPRB/)
KBO( :, 2,46,15) = (/&
&4.1254E+01_JPRB,3.6080E+01_JPRB,3.1312E+01_JPRB,2.5449E+01_JPRB,2.3941E+01_JPRB/)
KBO( :, 3,46,15) = (/&
&5.2137E+01_JPRB,4.5691E+01_JPRB,3.9762E+01_JPRB,3.2315E+01_JPRB,3.1392E+01_JPRB/)
KBO( :, 4,46,15) = (/&
&6.4023E+01_JPRB,5.6167E+01_JPRB,4.8996E+01_JPRB,4.0034E+01_JPRB,4.0089E+01_JPRB/)
KBO( :, 5,46,15) = (/&
&7.6702E+01_JPRB,6.7284E+01_JPRB,5.8863E+01_JPRB,4.8569E+01_JPRB,5.0083E+01_JPRB/)
KBO( :, 1,47,15) = (/&
&2.7961E+01_JPRB,2.4503E+01_JPRB,2.1248E+01_JPRB,1.7233E+01_JPRB,1.5367E+01_JPRB/)
KBO( :, 2,47,15) = (/&
&3.7265E+01_JPRB,3.2586E+01_JPRB,2.8263E+01_JPRB,2.2963E+01_JPRB,2.1269E+01_JPRB/)
KBO( :, 3,47,15) = (/&
&4.7706E+01_JPRB,4.1783E+01_JPRB,3.6327E+01_JPRB,2.9490E+01_JPRB,2.8246E+01_JPRB/)
KBO( :, 4,47,15) = (/&
&5.9232E+01_JPRB,5.1960E+01_JPRB,4.5284E+01_JPRB,3.6873E+01_JPRB,3.6445E+01_JPRB/)
KBO( :, 5,47,15) = (/&
&7.1624E+01_JPRB,6.2836E+01_JPRB,5.4930E+01_JPRB,4.5104E+01_JPRB,4.5902E+01_JPRB/)
KBO( :, 1,48,15) = (/&
&2.4583E+01_JPRB,2.1589E+01_JPRB,1.8762E+01_JPRB,1.5191E+01_JPRB,1.3292E+01_JPRB/)
KBO( :, 2,48,15) = (/&
&3.3426E+01_JPRB,2.9268E+01_JPRB,2.5357E+01_JPRB,2.0590E+01_JPRB,1.8769E+01_JPRB/)
KBO( :, 3,48,15) = (/&
&4.3425E+01_JPRB,3.8016E+01_JPRB,3.3009E+01_JPRB,2.6800E+01_JPRB,2.5307E+01_JPRB/)
KBO( :, 4,48,15) = (/&
&5.4549E+01_JPRB,4.7838E+01_JPRB,4.1652E+01_JPRB,3.3842E+01_JPRB,3.3001E+01_JPRB/)
KBO( :, 5,48,15) = (/&
&6.6636E+01_JPRB,5.8472E+01_JPRB,5.1042E+01_JPRB,4.1740E+01_JPRB,4.1948E+01_JPRB/)
KBO( :, 1,49,15) = (/&
&2.1421E+01_JPRB,1.8843E+01_JPRB,1.6440E+01_JPRB,1.3266E+01_JPRB,1.1366E+01_JPRB/)
KBO( :, 2,49,15) = (/&
&2.9765E+01_JPRB,2.6085E+01_JPRB,2.2608E+01_JPRB,1.8340E+01_JPRB,1.6436E+01_JPRB/)
KBO( :, 3,49,15) = (/&
&3.9312E+01_JPRB,3.4398E+01_JPRB,2.9848E+01_JPRB,2.4239E+01_JPRB,2.2553E+01_JPRB/)
KBO( :, 4,49,15) = (/&
&5.0006E+01_JPRB,4.3828E+01_JPRB,3.8123E+01_JPRB,3.0941E+01_JPRB,2.9764E+01_JPRB/)
KBO( :, 5,49,15) = (/&
&6.1741E+01_JPRB,5.4182E+01_JPRB,4.7244E+01_JPRB,3.8502E+01_JPRB,3.8207E+01_JPRB/)
KBO( :, 1,50,15) = (/&
&1.8647E+01_JPRB,1.6457E+01_JPRB,1.4418E+01_JPRB,1.1591E+01_JPRB,9.7268E+00_JPRB/)
KBO( :, 2,50,15) = (/&
&2.6492E+01_JPRB,2.3254E+01_JPRB,2.0184E+01_JPRB,1.6354E+01_JPRB,1.4411E+01_JPRB/)
KBO( :, 3,50,15) = (/&
&3.5615E+01_JPRB,3.1176E+01_JPRB,2.7033E+01_JPRB,2.1940E+01_JPRB,2.0122E+01_JPRB/)
KBO( :, 4,50,15) = (/&
&4.5887E+01_JPRB,4.0194E+01_JPRB,3.4925E+01_JPRB,2.8335E+01_JPRB,2.6904E+01_JPRB/)
KBO( :, 5,50,15) = (/&
&5.7262E+01_JPRB,5.0235E+01_JPRB,4.3773E+01_JPRB,3.5576E+01_JPRB,3.4879E+01_JPRB/)
KBO( :, 1,51,15) = (/&
&1.6143E+01_JPRB,1.4306E+01_JPRB,1.2586E+01_JPRB,1.0093E+01_JPRB,8.2870E+00_JPRB/)
KBO( :, 2,51,15) = (/&
&2.3475E+01_JPRB,2.0646E+01_JPRB,1.7965E+01_JPRB,1.4527E+01_JPRB,1.2580E+01_JPRB/)
KBO( :, 3,51,15) = (/&
&3.2173E+01_JPRB,2.8191E+01_JPRB,2.4427E+01_JPRB,1.9818E+01_JPRB,1.7912E+01_JPRB/)
KBO( :, 4,51,15) = (/&
&4.2029E+01_JPRB,3.6799E+01_JPRB,3.1946E+01_JPRB,2.5931E+01_JPRB,2.4302E+01_JPRB/)
KBO( :, 5,51,15) = (/&
&5.3021E+01_JPRB,4.6505E+01_JPRB,4.0477E+01_JPRB,3.2858E+01_JPRB,3.1825E+01_JPRB/)
KBO( :, 1,52,15) = (/&
&1.3849E+01_JPRB,1.2323E+01_JPRB,1.0901E+01_JPRB,8.7257E+00_JPRB,7.0030E+00_JPRB/)
KBO( :, 2,52,15) = (/&
&2.0656E+01_JPRB,1.8194E+01_JPRB,1.5897E+01_JPRB,1.2810E+01_JPRB,1.0879E+01_JPRB/)
KBO( :, 3,52,15) = (/&
&2.8881E+01_JPRB,2.5328E+01_JPRB,2.1965E+01_JPRB,1.7806E+01_JPRB,1.5846E+01_JPRB/)
KBO( :, 4,52,15) = (/&
&3.8328E+01_JPRB,3.3546E+01_JPRB,2.9106E+01_JPRB,2.3622E+01_JPRB,2.1850E+01_JPRB/)
KBO( :, 5,52,15) = (/&
&4.8918E+01_JPRB,4.2880E+01_JPRB,3.7289E+01_JPRB,3.0246E+01_JPRB,2.8936E+01_JPRB/)
KBO( :, 1,53,15) = (/&
&1.1740E+01_JPRB,1.0506E+01_JPRB,9.3420E+00_JPRB,7.4730E+00_JPRB,5.8524E+00_JPRB/)
KBO( :, 2,53,15) = (/&
&1.8002E+01_JPRB,1.5914E+01_JPRB,1.3956E+01_JPRB,1.1210E+01_JPRB,9.3278E+00_JPRB/)
KBO( :, 3,53,15) = (/&
&2.5731E+01_JPRB,2.2607E+01_JPRB,1.9634E+01_JPRB,1.5897E+01_JPRB,1.3918E+01_JPRB/)
KBO( :, 4,53,15) = (/&
&3.4758E+01_JPRB,3.0444E+01_JPRB,2.6393E+01_JPRB,2.1412E+01_JPRB,1.9532E+01_JPRB/)
KBO( :, 5,53,15) = (/&
&4.4940E+01_JPRB,3.9367E+01_JPRB,3.4201E+01_JPRB,2.7742E+01_JPRB,2.6213E+01_JPRB/)
KBO( :, 1,54,15) = (/&
&9.9823E+00_JPRB,8.9835E+00_JPRB,8.0433E+00_JPRB,6.4217E+00_JPRB,4.9233E+00_JPRB/)
KBO( :, 2,54,15) = (/&
&1.5743E+01_JPRB,1.3968E+01_JPRB,1.2300E+01_JPRB,9.8589E+00_JPRB,8.0425E+00_JPRB/)
KBO( :, 3,54,15) = (/&
&2.2999E+01_JPRB,2.0231E+01_JPRB,1.7622E+01_JPRB,1.4237E+01_JPRB,1.2265E+01_JPRB/)
KBO( :, 4,54,15) = (/&
&3.1619E+01_JPRB,2.7721E+01_JPRB,2.4021E+01_JPRB,1.9481E+01_JPRB,1.7533E+01_JPRB/)
KBO( :, 5,54,15) = (/&
&4.1422E+01_JPRB,3.6269E+01_JPRB,3.1486E+01_JPRB,2.5548E+01_JPRB,2.3860E+01_JPRB/)
KBO( :, 1,55,15) = (/&
&8.4600E+00_JPRB,7.6587E+00_JPRB,6.9105E+00_JPRB,5.5064E+00_JPRB,4.1393E+00_JPRB/)
KBO( :, 2,55,15) = (/&
&1.3741E+01_JPRB,1.2235E+01_JPRB,1.0828E+01_JPRB,8.6641E+00_JPRB,6.9310E+00_JPRB/)
KBO( :, 3,55,15) = (/&
&2.0525E+01_JPRB,1.8089E+01_JPRB,1.5809E+01_JPRB,1.2733E+01_JPRB,1.0785E+01_JPRB/)
KBO( :, 4,55,15) = (/&
&2.8733E+01_JPRB,2.5211E+01_JPRB,2.1862E+01_JPRB,1.7718E+01_JPRB,1.5733E+01_JPRB/)
KBO( :, 5,55,15) = (/&
&3.8167E+01_JPRB,3.3414E+01_JPRB,2.8994E+01_JPRB,2.3523E+01_JPRB,2.1717E+01_JPRB/)
KBO( :, 1,56,15) = (/&
&7.0942E+00_JPRB,6.4705E+00_JPRB,5.8843E+00_JPRB,4.6820E+00_JPRB,3.4600E+00_JPRB/)
KBO( :, 2,56,15) = (/&
&1.1888E+01_JPRB,1.0638E+01_JPRB,9.4563E+00_JPRB,7.5636E+00_JPRB,5.9306E+00_JPRB/)
KBO( :, 3,56,15) = (/&
&1.8195E+01_JPRB,1.6084E+01_JPRB,1.4104E+01_JPRB,1.1328E+01_JPRB,9.4258E+00_JPRB/)
KBO( :, 4,56,15) = (/&
&2.5965E+01_JPRB,2.2816E+01_JPRB,1.9813E+01_JPRB,1.6042E+01_JPRB,1.4044E+01_JPRB/)
KBO( :, 5,56,15) = (/&
&3.5031E+01_JPRB,3.0686E+01_JPRB,2.6607E+01_JPRB,2.1582E+01_JPRB,1.9682E+01_JPRB/)
KBO( :, 1,57,15) = (/&
&5.8809E+00_JPRB,5.4073E+00_JPRB,4.9520E+00_JPRB,3.9358E+00_JPRB,2.8765E+00_JPRB/)
KBO( :, 2,57,15) = (/&
&1.0188E+01_JPRB,9.1644E+00_JPRB,8.1997E+00_JPRB,6.5476E+00_JPRB,5.0356E+00_JPRB/)
KBO( :, 3,57,15) = (/&
&1.6011E+01_JPRB,1.4204E+01_JPRB,1.2504E+01_JPRB,1.0022E+01_JPRB,8.1887E+00_JPRB/)
KBO( :, 4,57,15) = (/&
&2.3331E+01_JPRB,2.0526E+01_JPRB,1.7871E+01_JPRB,1.4443E+01_JPRB,1.2452E+01_JPRB/)
KBO( :, 5,57,15) = (/&
&3.2013E+01_JPRB,2.8066E+01_JPRB,2.4321E+01_JPRB,1.9722E+01_JPRB,1.7763E+01_JPRB/)
KBO( :, 1,58,15) = (/&
&4.8592E+00_JPRB,4.5120E+00_JPRB,4.1533E+00_JPRB,3.3050E+00_JPRB,2.4069E+00_JPRB/)
KBO( :, 2,58,15) = (/&
&8.7235E+00_JPRB,7.8898E+00_JPRB,7.1098E+00_JPRB,5.6659E+00_JPRB,4.2880E+00_JPRB/)
KBO( :, 3,58,15) = (/&
&1.4093E+01_JPRB,1.2543E+01_JPRB,1.1091E+01_JPRB,8.8788E+00_JPRB,7.1312E+00_JPRB/)
KBO( :, 4,58,15) = (/&
&2.0969E+01_JPRB,1.8473E+01_JPRB,1.6137E+01_JPRB,1.3004E+01_JPRB,1.1037E+01_JPRB/)
KBO( :, 5,58,15) = (/&
&2.9256E+01_JPRB,2.5669E+01_JPRB,2.2254E+01_JPRB,1.8039E+01_JPRB,1.6041E+01_JPRB/)
KBO( :, 1,59,15) = (/&
&4.4860E+00_JPRB,4.1832E+00_JPRB,3.8589E+00_JPRB,3.0732E+00_JPRB,2.2588E+00_JPRB/)
KBO( :, 2,59,15) = (/&
&8.1764E+00_JPRB,7.4157E+00_JPRB,6.7019E+00_JPRB,5.3375E+00_JPRB,4.0381E+00_JPRB/)
KBO( :, 3,59,15) = (/&
&1.3363E+01_JPRB,1.1913E+01_JPRB,1.0553E+01_JPRB,8.4437E+00_JPRB,6.7583E+00_JPRB/)
KBO( :, 4,59,15) = (/&
&2.0059E+01_JPRB,1.7690E+01_JPRB,1.5474E+01_JPRB,1.2453E+01_JPRB,1.0517E+01_JPRB/)
KBO( :, 5,59,15) = (/&
&2.8188E+01_JPRB,2.4740E+01_JPRB,2.1460E+01_JPRB,1.7388E+01_JPRB,1.5382E+01_JPRB/)
KBO( :, 1,13,16) = (/&
&3.5240E+00_JPRB,3.4508E+00_JPRB,6.8957E+00_JPRB,1.0310E+01_JPRB,1.3810E+01_JPRB/)
KBO( :, 2,13,16) = (/&
&5.0188E+00_JPRB,4.8884E+00_JPRB,9.7668E+00_JPRB,1.4606E+01_JPRB,1.9563E+01_JPRB/)
KBO( :, 3,13,16) = (/&
&6.8636E+00_JPRB,6.9963E+00_JPRB,1.3983E+01_JPRB,2.0917E+01_JPRB,2.7996E+01_JPRB/)
KBO( :, 4,13,16) = (/&
&8.9983E+00_JPRB,9.9231E+00_JPRB,1.9821E+01_JPRB,2.9657E+01_JPRB,3.9702E+01_JPRB/)
KBO( :, 5,13,16) = (/&
&1.1391E+01_JPRB,1.3448E+01_JPRB,2.6873E+01_JPRB,4.0197E+01_JPRB,5.3821E+01_JPRB/)
KBO( :, 1,14,16) = (/&
&4.0865E+00_JPRB,4.2627E+00_JPRB,8.5157E+00_JPRB,1.2737E+01_JPRB,1.7061E+01_JPRB/)
KBO( :, 2,14,16) = (/&
&5.9152E+00_JPRB,5.9770E+00_JPRB,1.1941E+01_JPRB,1.7861E+01_JPRB,2.3919E+01_JPRB/)
KBO( :, 3,14,16) = (/&
&8.1116E+00_JPRB,8.4946E+00_JPRB,1.6974E+01_JPRB,2.5393E+01_JPRB,3.3994E+01_JPRB/)
KBO( :, 4,14,16) = (/&
&1.0667E+01_JPRB,1.1982E+01_JPRB,2.3941E+01_JPRB,3.5820E+01_JPRB,4.7947E+01_JPRB/)
KBO( :, 5,14,16) = (/&
&1.3570E+01_JPRB,1.6166E+01_JPRB,3.2293E+01_JPRB,4.8328E+01_JPRB,6.4679E+01_JPRB/)
KBO( :, 1,15,16) = (/&
&4.9205E+00_JPRB,5.2381E+00_JPRB,1.0467E+01_JPRB,1.5657E+01_JPRB,2.0962E+01_JPRB/)
KBO( :, 2,15,16) = (/&
&7.1107E+00_JPRB,7.3251E+00_JPRB,1.4636E+01_JPRB,2.1892E+01_JPRB,2.9314E+01_JPRB/)
KBO( :, 3,15,16) = (/&
&9.7657E+00_JPRB,1.0319E+01_JPRB,2.0625E+01_JPRB,3.0857E+01_JPRB,4.1307E+01_JPRB/)
KBO( :, 4,15,16) = (/&
&1.2863E+01_JPRB,1.4348E+01_JPRB,2.8667E+01_JPRB,4.2902E+01_JPRB,5.7415E+01_JPRB/)
KBO( :, 5,15,16) = (/&
&1.6377E+01_JPRB,1.9245E+01_JPRB,3.8440E+01_JPRB,5.7530E+01_JPRB,7.7014E+01_JPRB/)
KBO( :, 1,16,16) = (/&
&6.0019E+00_JPRB,6.3755E+00_JPRB,1.2742E+01_JPRB,1.9060E+01_JPRB,2.5511E+01_JPRB/)
KBO( :, 2,16,16) = (/&
&8.6719E+00_JPRB,8.9601E+00_JPRB,1.7905E+01_JPRB,2.6782E+01_JPRB,3.5858E+01_JPRB/)
KBO( :, 3,16,16) = (/&
&1.1897E+01_JPRB,1.2494E+01_JPRB,2.4965E+01_JPRB,3.7351E+01_JPRB,5.0005E+01_JPRB/)
KBO( :, 4,16,16) = (/&
&1.5664E+01_JPRB,1.7033E+01_JPRB,3.4039E+01_JPRB,5.0943E+01_JPRB,6.8160E+01_JPRB/)
KBO( :, 5,16,16) = (/&
&1.9931E+01_JPRB,2.2609E+01_JPRB,4.5144E+01_JPRB,6.7604E+01_JPRB,9.0384E+01_JPRB/)
KBO( :, 1,17,16) = (/&
&7.3859E+00_JPRB,7.7004E+00_JPRB,1.5389E+01_JPRB,2.3023E+01_JPRB,3.0816E+01_JPRB/)
KBO( :, 2,17,16) = (/&
&1.0640E+01_JPRB,1.0863E+01_JPRB,2.1706E+01_JPRB,3.2470E+01_JPRB,4.3467E+01_JPRB/)
KBO( :, 3,17,16) = (/&
&1.4563E+01_JPRB,1.4992E+01_JPRB,2.9958E+01_JPRB,4.4824E+01_JPRB,5.9991E+01_JPRB/)
KBO( :, 4,17,16) = (/&
&1.9138E+01_JPRB,2.0152E+01_JPRB,4.0219E+01_JPRB,6.0189E+01_JPRB,8.0517E+01_JPRB/)
KBO( :, 5,17,16) = (/&
&2.4286E+01_JPRB,2.6459E+01_JPRB,5.2448E+01_JPRB,7.8504E+01_JPRB,1.0501E+02_JPRB/)
KBO( :, 1,18,16) = (/&
&9.1226E+00_JPRB,9.2597E+00_JPRB,1.8491E+01_JPRB,2.7668E+01_JPRB,3.7034E+01_JPRB/)
KBO( :, 2,18,16) = (/&
&1.3090E+01_JPRB,1.3038E+01_JPRB,2.6008E+01_JPRB,3.8923E+01_JPRB,5.2083E+01_JPRB/)
KBO( :, 3,18,16) = (/&
&1.7870E+01_JPRB,1.7862E+01_JPRB,3.5545E+01_JPRB,5.3199E+01_JPRB,7.1167E+01_JPRB/)
KBO( :, 4,18,16) = (/&
&2.3384E+01_JPRB,2.3802E+01_JPRB,4.7105E+01_JPRB,7.0494E+01_JPRB,9.4316E+01_JPRB/)
KBO( :, 5,18,16) = (/&
&2.9603E+01_JPRB,3.0959E+01_JPRB,6.0617E+01_JPRB,9.0761E+01_JPRB,1.2137E+02_JPRB/)
KBO( :, 1,19,16) = (/&
&1.1267E+01_JPRB,1.1103E+01_JPRB,2.1975E+01_JPRB,3.2891E+01_JPRB,4.4000E+01_JPRB/)
KBO( :, 2,19,16) = (/&
&1.6108E+01_JPRB,1.5588E+01_JPRB,3.0737E+01_JPRB,4.5998E+01_JPRB,6.1538E+01_JPRB/)
KBO( :, 3,19,16) = (/&
&2.1880E+01_JPRB,2.1226E+01_JPRB,4.1603E+01_JPRB,6.2286E+01_JPRB,8.3284E+01_JPRB/)
KBO( :, 4,19,16) = (/&
&2.8546E+01_JPRB,2.8063E+01_JPRB,5.4555E+01_JPRB,8.1653E+01_JPRB,1.0920E+02_JPRB/)
KBO( :, 5,19,16) = (/&
&3.6015E+01_JPRB,3.6209E+01_JPRB,6.9418E+01_JPRB,1.0398E+02_JPRB,1.3897E+02_JPRB/)
KBO( :, 1,20,16) = (/&
&1.3993E+01_JPRB,1.3379E+01_JPRB,2.5920E+01_JPRB,3.8804E+01_JPRB,5.1896E+01_JPRB/)
KBO( :, 2,20,16) = (/&
&1.9857E+01_JPRB,1.8711E+01_JPRB,3.5970E+01_JPRB,5.3858E+01_JPRB,7.2020E+01_JPRB/)
KBO( :, 3,20,16) = (/&
&2.6849E+01_JPRB,2.5309E+01_JPRB,4.8236E+01_JPRB,7.2221E+01_JPRB,9.6564E+01_JPRB/)
KBO( :, 4,20,16) = (/&
&3.4854E+01_JPRB,3.3204E+01_JPRB,6.2605E+01_JPRB,9.3754E+01_JPRB,1.2532E+02_JPRB/)
KBO( :, 5,20,16) = (/&
&4.3828E+01_JPRB,4.2464E+01_JPRB,7.8932E+01_JPRB,1.1822E+02_JPRB,1.5801E+02_JPRB/)
KBO( :, 1,21,16) = (/&
&1.7315E+01_JPRB,1.6114E+01_JPRB,3.0129E+01_JPRB,4.5115E+01_JPRB,6.0314E+01_JPRB/)
KBO( :, 2,21,16) = (/&
&2.4393E+01_JPRB,2.2395E+01_JPRB,4.1483E+01_JPRB,6.2116E+01_JPRB,8.3040E+01_JPRB/)
KBO( :, 3,21,16) = (/&
&3.2776E+01_JPRB,3.0091E+01_JPRB,5.5119E+01_JPRB,8.2559E+01_JPRB,1.1033E+02_JPRB/)
KBO( :, 4,21,16) = (/&
&4.2294E+01_JPRB,3.9176E+01_JPRB,7.0924E+01_JPRB,1.0622E+02_JPRB,1.4195E+02_JPRB/)
KBO( :, 5,21,16) = (/&
&5.3038E+01_JPRB,4.9692E+01_JPRB,8.8908E+01_JPRB,1.3317E+02_JPRB,1.7794E+02_JPRB/)
KBO( :, 1,22,16) = (/&
&2.1825E+01_JPRB,1.9779E+01_JPRB,3.5248E+01_JPRB,5.2796E+01_JPRB,7.0550E+01_JPRB/)
KBO( :, 2,22,16) = (/&
&3.0396E+01_JPRB,2.7253E+01_JPRB,4.8033E+01_JPRB,7.1948E+01_JPRB,9.6125E+01_JPRB/)
KBO( :, 3,22,16) = (/&
&4.0380E+01_JPRB,3.6230E+01_JPRB,6.3173E+01_JPRB,9.4660E+01_JPRB,1.2648E+02_JPRB/)
KBO( :, 4,22,16) = (/&
&5.1797E+01_JPRB,4.6707E+01_JPRB,8.0766E+01_JPRB,1.2099E+02_JPRB,1.6165E+02_JPRB/)
KBO( :, 5,22,16) = (/&
&6.4540E+01_JPRB,5.8724E+01_JPRB,1.0071E+02_JPRB,1.5084E+02_JPRB,2.0156E+02_JPRB/)
KBO( :, 1,23,16) = (/&
&2.7320E+01_JPRB,2.4188E+01_JPRB,4.0693E+01_JPRB,6.0960E+01_JPRB,8.1453E+01_JPRB/)
KBO( :, 2,23,16) = (/&
&3.7558E+01_JPRB,3.2976E+01_JPRB,5.4970E+01_JPRB,8.2336E+01_JPRB,1.1003E+02_JPRB/)
KBO( :, 3,23,16) = (/&
&4.9408E+01_JPRB,4.3375E+01_JPRB,7.1816E+01_JPRB,1.0759E+02_JPRB,1.4373E+02_JPRB/)
KBO( :, 4,23,16) = (/&
&6.2874E+01_JPRB,5.5353E+01_JPRB,9.1309E+01_JPRB,1.3680E+02_JPRB,1.8276E+02_JPRB/)
KBO( :, 5,23,16) = (/&
&7.7698E+01_JPRB,6.8961E+01_JPRB,1.1333E+02_JPRB,1.6978E+02_JPRB,2.2679E+02_JPRB/)
KBO( :, 1,24,16) = (/&
&3.3869E+01_JPRB,2.9387E+01_JPRB,4.6648E+01_JPRB,6.9904E+01_JPRB,9.3367E+01_JPRB/)
KBO( :, 2,24,16) = (/&
&4.6006E+01_JPRB,3.9622E+01_JPRB,6.2515E+01_JPRB,9.3679E+01_JPRB,1.2511E+02_JPRB/)
KBO( :, 3,24,16) = (/&
&5.9946E+01_JPRB,5.1571E+01_JPRB,8.1209E+01_JPRB,1.2167E+02_JPRB,1.6250E+02_JPRB/)
KBO( :, 4,24,16) = (/&
&7.5539E+01_JPRB,6.5110E+01_JPRB,1.0265E+02_JPRB,1.5380E+02_JPRB,2.0542E+02_JPRB/)
KBO( :, 5,24,16) = (/&
&9.2477E+01_JPRB,8.0448E+01_JPRB,1.2660E+02_JPRB,1.8969E+02_JPRB,2.5333E+02_JPRB/)
KBO( :, 1,25,16) = (/&
&4.1599E+01_JPRB,3.5454E+01_JPRB,5.3146E+01_JPRB,7.9642E+01_JPRB,1.0635E+02_JPRB/)
KBO( :, 2,25,16) = (/&
&5.5782E+01_JPRB,4.7228E+01_JPRB,7.0740E+01_JPRB,1.0597E+02_JPRB,1.4155E+02_JPRB/)
KBO( :, 3,25,16) = (/&
&7.1943E+01_JPRB,6.0744E+01_JPRB,9.1338E+01_JPRB,1.3688E+02_JPRB,1.8276E+02_JPRB/)
KBO( :, 4,25,16) = (/&
&8.9735E+01_JPRB,7.6043E+01_JPRB,1.1460E+02_JPRB,1.7175E+02_JPRB,2.2932E+02_JPRB/)
KBO( :, 5,25,16) = (/&
&1.0881E+02_JPRB,9.3022E+01_JPRB,1.4062E+02_JPRB,2.1079E+02_JPRB,2.8133E+02_JPRB/)
KBO( :, 1,26,16) = (/&
&5.0633E+01_JPRB,4.2540E+01_JPRB,6.0521E+01_JPRB,9.0533E+01_JPRB,1.2089E+02_JPRB/)
KBO( :, 2,26,16) = (/&
&6.7031E+01_JPRB,5.5881E+01_JPRB,7.9837E+01_JPRB,1.1964E+02_JPRB,1.5974E+02_JPRB/)
KBO( :, 3,26,16) = (/&
&8.5449E+01_JPRB,7.1046E+01_JPRB,1.0219E+02_JPRB,1.5314E+02_JPRB,2.0448E+02_JPRB/)
KBO( :, 4,26,16) = (/&
&1.0550E+02_JPRB,8.8104E+01_JPRB,1.2741E+02_JPRB,1.9092E+02_JPRB,2.5490E+02_JPRB/)
KBO( :, 5,26,16) = (/&
&1.2662E+02_JPRB,1.0665E+02_JPRB,1.5535E+02_JPRB,2.3284E+02_JPRB,3.1085E+02_JPRB/)
KBO( :, 1,27,16) = (/&
&6.0760E+01_JPRB,5.0362E+01_JPRB,6.8627E+01_JPRB,1.0214E+02_JPRB,1.3635E+02_JPRB/)
KBO( :, 2,27,16) = (/&
&7.9372E+01_JPRB,6.5351E+01_JPRB,8.9496E+01_JPRB,1.3381E+02_JPRB,1.7862E+02_JPRB/)
KBO( :, 3,27,16) = (/&
&1.0007E+02_JPRB,8.2171E+01_JPRB,1.1350E+02_JPRB,1.7014E+02_JPRB,2.2709E+02_JPRB/)
KBO( :, 4,27,16) = (/&
&1.2219E+02_JPRB,1.0086E+02_JPRB,1.4060E+02_JPRB,2.1077E+02_JPRB,2.8135E+02_JPRB/)
KBO( :, 5,27,16) = (/&
&1.4517E+02_JPRB,1.2078E+02_JPRB,1.7031E+02_JPRB,2.5527E+02_JPRB,3.4078E+02_JPRB/)
KBO( :, 1,28,16) = (/&
&7.1850E+01_JPRB,5.8865E+01_JPRB,7.7249E+01_JPRB,1.1435E+02_JPRB,1.5263E+02_JPRB/)
KBO( :, 2,28,16) = (/&
&9.2653E+01_JPRB,7.5393E+01_JPRB,9.9671E+01_JPRB,1.4851E+02_JPRB,1.9822E+02_JPRB/)
KBO( :, 3,28,16) = (/&
&1.1541E+02_JPRB,9.3821E+01_JPRB,1.2515E+02_JPRB,1.8738E+02_JPRB,2.5009E+02_JPRB/)
KBO( :, 4,28,16) = (/&
&1.3940E+02_JPRB,1.1403E+02_JPRB,1.5381E+02_JPRB,2.3053E+02_JPRB,3.0770E+02_JPRB/)
KBO( :, 5,28,16) = (/&
&1.6406E+02_JPRB,1.3517E+02_JPRB,1.8510E+02_JPRB,2.7748E+02_JPRB,3.7030E+02_JPRB/)
KBO( :, 1,29,16) = (/&
&8.3876E+01_JPRB,6.7955E+01_JPRB,8.6536E+01_JPRB,1.2716E+02_JPRB,1.6971E+02_JPRB/)
KBO( :, 2,29,16) = (/&
&1.0671E+02_JPRB,8.6050E+01_JPRB,1.1035E+02_JPRB,1.6386E+02_JPRB,2.1869E+02_JPRB/)
KBO( :, 3,29,16) = (/&
&1.3128E+02_JPRB,1.0596E+02_JPRB,1.3736E+02_JPRB,2.0522E+02_JPRB,2.7387E+02_JPRB/)
KBO( :, 4,29,16) = (/&
&1.5691E+02_JPRB,1.2750E+02_JPRB,1.6737E+02_JPRB,2.5071E+02_JPRB,3.3454E+02_JPRB/)
KBO( :, 5,29,16) = (/&
&1.8307E+02_JPRB,1.4968E+02_JPRB,1.9986E+02_JPRB,2.9963E+02_JPRB,3.9981E+02_JPRB/)
KBO( :, 1,30,16) = (/&
&9.6402E+01_JPRB,7.7403E+01_JPRB,9.6100E+01_JPRB,1.4042E+02_JPRB,1.8733E+02_JPRB/)
KBO( :, 2,30,16) = (/&
&1.2111E+02_JPRB,9.6917E+01_JPRB,1.2129E+02_JPRB,1.7953E+02_JPRB,2.3957E+02_JPRB/)
KBO( :, 3,30,16) = (/&
&1.4725E+02_JPRB,1.1830E+02_JPRB,1.4967E+02_JPRB,2.2319E+02_JPRB,2.9778E+02_JPRB/)
KBO( :, 4,30,16) = (/&
&1.7435E+02_JPRB,1.4089E+02_JPRB,1.8090E+02_JPRB,2.7076E+02_JPRB,3.6126E+02_JPRB/)
KBO( :, 5,30,16) = (/&
&2.0174E+02_JPRB,1.6391E+02_JPRB,2.1447E+02_JPRB,3.2140E+02_JPRB,4.2881E+02_JPRB/)
KBO( :, 1,31,16) = (/&
&1.0938E+02_JPRB,8.7129E+01_JPRB,1.0605E+02_JPRB,1.5425E+02_JPRB,2.0576E+02_JPRB/)
KBO( :, 2,31,16) = (/&
&1.3571E+02_JPRB,1.0800E+02_JPRB,1.3247E+02_JPRB,1.9550E+02_JPRB,2.6086E+02_JPRB/)
KBO( :, 3,31,16) = (/&
&1.6324E+02_JPRB,1.3063E+02_JPRB,1.6212E+02_JPRB,2.4122E+02_JPRB,3.2182E+02_JPRB/)
KBO( :, 4,31,16) = (/&
&1.9162E+02_JPRB,1.5412E+02_JPRB,1.9447E+02_JPRB,2.9069E+02_JPRB,3.8783E+02_JPRB/)
KBO( :, 5,31,16) = (/&
&2.1989E+02_JPRB,1.7781E+02_JPRB,2.2900E+02_JPRB,3.4301E+02_JPRB,4.5761E+02_JPRB/)
KBO( :, 1,32,16) = (/&
&1.2256E+02_JPRB,9.7067E+01_JPRB,1.1617E+02_JPRB,1.6836E+02_JPRB,2.2461E+02_JPRB/)
KBO( :, 2,32,16) = (/&
&1.5030E+02_JPRB,1.1913E+02_JPRB,1.4393E+02_JPRB,2.1170E+02_JPRB,2.8241E+02_JPRB/)
KBO( :, 3,32,16) = (/&
&1.7905E+02_JPRB,1.4279E+02_JPRB,1.7463E+02_JPRB,2.5936E+02_JPRB,3.4601E+02_JPRB/)
KBO( :, 4,32,16) = (/&
&2.0835E+02_JPRB,1.6700E+02_JPRB,2.0791E+02_JPRB,3.1047E+02_JPRB,4.1404E+02_JPRB/)
KBO( :, 5,32,16) = (/&
&2.3734E+02_JPRB,1.9118E+02_JPRB,2.4327E+02_JPRB,3.6420E+02_JPRB,4.8584E+02_JPRB/)
KBO( :, 1,33,16) = (/&
&1.3570E+02_JPRB,1.0705E+02_JPRB,1.2638E+02_JPRB,1.8277E+02_JPRB,2.4379E+02_JPRB/)
KBO( :, 2,33,16) = (/&
&1.6469E+02_JPRB,1.3015E+02_JPRB,1.5530E+02_JPRB,2.2797E+02_JPRB,3.0408E+02_JPRB/)
KBO( :, 3,33,16) = (/&
&1.9448E+02_JPRB,1.5467E+02_JPRB,1.8707E+02_JPRB,2.7733E+02_JPRB,3.6994E+02_JPRB/)
KBO( :, 4,33,16) = (/&
&2.2436E+02_JPRB,1.7936E+02_JPRB,2.2122E+02_JPRB,3.2976E+02_JPRB,4.3991E+02_JPRB/)
KBO( :, 5,33,16) = (/&
&2.5393E+02_JPRB,2.0390E+02_JPRB,2.5728E+02_JPRB,3.8487E+02_JPRB,5.1330E+02_JPRB/)
KBO( :, 1,34,16) = (/&
&1.4769E+02_JPRB,1.1615E+02_JPRB,1.3561E+02_JPRB,1.9580E+02_JPRB,2.6115E+02_JPRB/)
KBO( :, 2,34,16) = (/&
&1.7765E+02_JPRB,1.4013E+02_JPRB,1.6546E+02_JPRB,2.4255E+02_JPRB,3.2352E+02_JPRB/)
KBO( :, 3,34,16) = (/&
&2.0819E+02_JPRB,1.6522E+02_JPRB,1.9808E+02_JPRB,2.9327E+02_JPRB,3.9114E+02_JPRB/)
KBO( :, 4,34,16) = (/&
&2.3855E+02_JPRB,1.9025E+02_JPRB,2.3293E+02_JPRB,3.4692E+02_JPRB,4.6270E+02_JPRB/)
KBO( :, 5,34,16) = (/&
&2.6850E+02_JPRB,2.1503E+02_JPRB,2.6955E+02_JPRB,4.0292E+02_JPRB,5.3742E+02_JPRB/)
KBO( :, 1,35,16) = (/&
&1.5643E+02_JPRB,1.2270E+02_JPRB,1.4190E+02_JPRB,2.0436E+02_JPRB,2.7254E+02_JPRB/)
KBO( :, 2,35,16) = (/&
&1.8713E+02_JPRB,1.4730E+02_JPRB,1.7243E+02_JPRB,2.5214E+02_JPRB,3.3629E+02_JPRB/)
KBO( :, 3,35,16) = (/&
&2.1819E+02_JPRB,1.7282E+02_JPRB,2.0562E+02_JPRB,3.0372E+02_JPRB,4.0506E+02_JPRB/)
KBO( :, 4,35,16) = (/&
&2.4895E+02_JPRB,1.9814E+02_JPRB,2.4081E+02_JPRB,3.5825E+02_JPRB,4.7775E+02_JPRB/)
KBO( :, 5,35,16) = (/&
&2.7917E+02_JPRB,2.2313E+02_JPRB,2.7780E+02_JPRB,4.1495E+02_JPRB,5.5336E+02_JPRB/)
KBO( :, 1,36,16) = (/&
&1.6128E+02_JPRB,1.2623E+02_JPRB,1.4470E+02_JPRB,2.0760E+02_JPRB,2.7682E+02_JPRB/)
KBO( :, 2,36,16) = (/&
&1.9250E+02_JPRB,1.5118E+02_JPRB,1.7553E+02_JPRB,2.5587E+02_JPRB,3.4124E+02_JPRB/)
KBO( :, 3,36,16) = (/&
&2.2400E+02_JPRB,1.7706E+02_JPRB,2.0894E+02_JPRB,3.0787E+02_JPRB,4.1050E+02_JPRB/)
KBO( :, 4,36,16) = (/&
&2.5511E+02_JPRB,2.0265E+02_JPRB,2.4435E+02_JPRB,3.6281E+02_JPRB,4.8383E+02_JPRB/)
KBO( :, 5,36,16) = (/&
&2.8566E+02_JPRB,2.2781E+02_JPRB,2.8144E+02_JPRB,4.1994E+02_JPRB,5.6005E+02_JPRB/)
KBO( :, 1,37,16) = (/&
&1.6074E+02_JPRB,1.2562E+02_JPRB,1.4270E+02_JPRB,2.0342E+02_JPRB,2.7131E+02_JPRB/)
KBO( :, 2,37,16) = (/&
&1.9235E+02_JPRB,1.5069E+02_JPRB,1.7337E+02_JPRB,2.5150E+02_JPRB,3.3544E+02_JPRB/)
KBO( :, 3,37,16) = (/&
&2.2422E+02_JPRB,1.7676E+02_JPRB,2.0661E+02_JPRB,3.0337E+02_JPRB,4.0456E+02_JPRB/)
KBO( :, 4,37,16) = (/&
&2.5568E+02_JPRB,2.0266E+02_JPRB,2.4193E+02_JPRB,3.5830E+02_JPRB,4.7782E+02_JPRB/)
KBO( :, 5,37,16) = (/&
&2.8661E+02_JPRB,2.2807E+02_JPRB,2.7894E+02_JPRB,4.1548E+02_JPRB,5.5411E+02_JPRB/)
KBO( :, 1,38,16) = (/&
&1.5931E+02_JPRB,1.2434E+02_JPRB,1.4021E+02_JPRB,1.9855E+02_JPRB,2.6480E+02_JPRB/)
KBO( :, 2,38,16) = (/&
&1.9120E+02_JPRB,1.4947E+02_JPRB,1.7064E+02_JPRB,2.4634E+02_JPRB,3.2849E+02_JPRB/)
KBO( :, 3,38,16) = (/&
&2.2336E+02_JPRB,1.7568E+02_JPRB,2.0368E+02_JPRB,2.9797E+02_JPRB,3.9734E+02_JPRB/)
KBO( :, 4,38,16) = (/&
&2.5520E+02_JPRB,2.0184E+02_JPRB,2.3879E+02_JPRB,3.5282E+02_JPRB,4.7045E+02_JPRB/)
KBO( :, 5,38,16) = (/&
&2.8646E+02_JPRB,2.2749E+02_JPRB,2.7570E+02_JPRB,4.0988E+02_JPRB,5.4664E+02_JPRB/)
KBO( :, 1,39,16) = (/&
&1.5737E+02_JPRB,1.2272E+02_JPRB,1.3752E+02_JPRB,1.9347E+02_JPRB,2.5800E+02_JPRB/)
KBO( :, 2,39,16) = (/&
&1.8947E+02_JPRB,1.4785E+02_JPRB,1.6766E+02_JPRB,2.4086E+02_JPRB,3.2118E+02_JPRB/)
KBO( :, 3,39,16) = (/&
&2.2190E+02_JPRB,1.7414E+02_JPRB,2.0048E+02_JPRB,2.9227E+02_JPRB,3.8976E+02_JPRB/)
KBO( :, 4,39,16) = (/&
&2.5401E+02_JPRB,2.0054E+02_JPRB,2.3540E+02_JPRB,3.4685E+02_JPRB,4.6257E+02_JPRB/)
KBO( :, 5,39,16) = (/&
&2.8557E+02_JPRB,2.2640E+02_JPRB,2.7220E+02_JPRB,4.0387E+02_JPRB,5.3853E+02_JPRB/)
KBO( :, 1,40,16) = (/&
&1.5173E+02_JPRB,1.1834E+02_JPRB,1.3170E+02_JPRB,1.8369E+02_JPRB,2.4496E+02_JPRB/)
KBO( :, 2,40,16) = (/&
&1.8387E+02_JPRB,1.4326E+02_JPRB,1.6126E+02_JPRB,2.3014E+02_JPRB,3.0690E+02_JPRB/)
KBO( :, 3,40,16) = (/&
&2.1654E+02_JPRB,1.6951E+02_JPRB,1.9355E+02_JPRB,2.8092E+02_JPRB,3.7460E+02_JPRB/)
KBO( :, 4,40,16) = (/&
&2.4896E+02_JPRB,1.9611E+02_JPRB,2.2806E+02_JPRB,3.3490E+02_JPRB,4.4658E+02_JPRB/)
KBO( :, 5,40,16) = (/&
&2.8081E+02_JPRB,2.2225E+02_JPRB,2.6459E+02_JPRB,3.9162E+02_JPRB,5.2225E+02_JPRB/)
KBO( :, 1,41,16) = (/&
&1.4531E+02_JPRB,1.1344E+02_JPRB,1.2539E+02_JPRB,1.7342E+02_JPRB,2.3126E+02_JPRB/)
KBO( :, 2,41,16) = (/&
&1.7739E+02_JPRB,1.3804E+02_JPRB,1.5439E+02_JPRB,2.1880E+02_JPRB,2.9176E+02_JPRB/)
KBO( :, 3,41,16) = (/&
&2.1022E+02_JPRB,1.6418E+02_JPRB,1.8612E+02_JPRB,2.6873E+02_JPRB,3.5832E+02_JPRB/)
KBO( :, 4,41,16) = (/&
&2.4292E+02_JPRB,1.9086E+02_JPRB,2.2015E+02_JPRB,3.2196E+02_JPRB,4.2934E+02_JPRB/)
KBO( :, 5,41,16) = (/&
&2.7507E+02_JPRB,2.1730E+02_JPRB,2.5630E+02_JPRB,3.7839E+02_JPRB,5.0449E+02_JPRB/)
KBO( :, 1,42,16) = (/&
&1.3859E+02_JPRB,1.0832E+02_JPRB,1.1902E+02_JPRB,1.6325E+02_JPRB,2.1769E+02_JPRB/)
KBO( :, 2,42,16) = (/&
&1.7052E+02_JPRB,1.3266E+02_JPRB,1.4745E+02_JPRB,2.0749E+02_JPRB,2.7665E+02_JPRB/)
KBO( :, 3,42,16) = (/&
&2.0342E+02_JPRB,1.5859E+02_JPRB,1.7863E+02_JPRB,2.5644E+02_JPRB,3.4199E+02_JPRB/)
KBO( :, 4,42,16) = (/&
&2.3635E+02_JPRB,1.8528E+02_JPRB,2.1215E+02_JPRB,3.0913E+02_JPRB,4.1213E+02_JPRB/)
KBO( :, 5,42,16) = (/&
&2.6880E+02_JPRB,2.1197E+02_JPRB,2.4778E+02_JPRB,3.6481E+02_JPRB,4.8644E+02_JPRB/)
KBO( :, 1,43,16) = (/&
&1.3001E+02_JPRB,1.0178E+02_JPRB,1.1123E+02_JPRB,1.5100E+02_JPRB,2.0132E+02_JPRB/)
KBO( :, 2,43,16) = (/&
&1.6156E+02_JPRB,1.2573E+02_JPRB,1.3894E+02_JPRB,1.9371E+02_JPRB,2.5828E+02_JPRB/)
KBO( :, 3,43,16) = (/&
&1.9443E+02_JPRB,1.5128E+02_JPRB,1.6930E+02_JPRB,2.4134E+02_JPRB,3.2182E+02_JPRB/)
KBO( :, 4,43,16) = (/&
&2.2750E+02_JPRB,1.7792E+02_JPRB,2.0213E+02_JPRB,2.9308E+02_JPRB,3.9078E+02_JPRB/)
KBO( :, 5,43,16) = (/&
&2.6025E+02_JPRB,2.0480E+02_JPRB,2.3724E+02_JPRB,3.4798E+02_JPRB,4.6403E+02_JPRB/)
KBO( :, 1,44,16) = (/&
&1.2064E+02_JPRB,9.4696E+01_JPRB,1.0291E+02_JPRB,1.3822E+02_JPRB,1.8432E+02_JPRB/)
KBO( :, 2,44,16) = (/&
&1.5164E+02_JPRB,1.1817E+02_JPRB,1.2980E+02_JPRB,1.7913E+02_JPRB,2.3893E+02_JPRB/)
KBO( :, 3,44,16) = (/&
&1.8428E+02_JPRB,1.4322E+02_JPRB,1.5930E+02_JPRB,2.2526E+02_JPRB,3.0036E+02_JPRB/)
KBO( :, 4,44,16) = (/&
&2.1753E+02_JPRB,1.6972E+02_JPRB,1.9139E+02_JPRB,2.7583E+02_JPRB,3.6782E+02_JPRB/)
KBO( :, 5,44,16) = (/&
&2.5049E+02_JPRB,1.9666E+02_JPRB,2.2579E+02_JPRB,3.2975E+02_JPRB,4.3968E+02_JPRB/)
KBO( :, 1,45,16) = (/&
&1.1151E+02_JPRB,8.7613E+01_JPRB,9.4790E+01_JPRB,1.2608E+02_JPRB,1.6812E+02_JPRB/)
KBO( :, 2,45,16) = (/&
&1.4164E+02_JPRB,1.1057E+02_JPRB,1.2077E+02_JPRB,1.6507E+02_JPRB,2.2006E+02_JPRB/)
KBO( :, 3,45,16) = (/&
&1.7396E+02_JPRB,1.3520E+02_JPRB,1.4945E+02_JPRB,2.0958E+02_JPRB,2.7946E+02_JPRB/)
KBO( :, 4,45,16) = (/&
&2.0722E+02_JPRB,1.6134E+02_JPRB,1.8077E+02_JPRB,2.5885E+02_JPRB,3.4509E+02_JPRB/)
KBO( :, 5,45,16) = (/&
&2.4041E+02_JPRB,1.8823E+02_JPRB,2.1441E+02_JPRB,3.1179E+02_JPRB,4.1569E+02_JPRB/)
KBO( :, 1,46,16) = (/&
&1.0202E+02_JPRB,8.0263E+01_JPRB,8.6456E+01_JPRB,1.1385E+02_JPRB,1.5183E+02_JPRB/)
KBO( :, 2,46,16) = (/&
&1.3102E+02_JPRB,1.0251E+02_JPRB,1.1143E+02_JPRB,1.5058E+02_JPRB,2.0077E+02_JPRB/)
KBO( :, 3,46,16) = (/&
&1.6284E+02_JPRB,1.2664E+02_JPRB,1.3922E+02_JPRB,1.9326E+02_JPRB,2.5769E+02_JPRB/)
KBO( :, 4,46,16) = (/&
&1.9593E+02_JPRB,1.5228E+02_JPRB,1.6961E+02_JPRB,2.4101E+02_JPRB,3.2127E+02_JPRB/)
KBO( :, 5,46,16) = (/&
&2.2932E+02_JPRB,1.7911E+02_JPRB,2.0249E+02_JPRB,2.9283E+02_JPRB,3.9038E+02_JPRB/)
KBO( :, 1,47,16) = (/&
&9.1833E+01_JPRB,7.2521E+01_JPRB,7.7492E+01_JPRB,1.0107E+02_JPRB,1.3478E+02_JPRB/)
KBO( :, 2,47,16) = (/&
&1.1935E+02_JPRB,9.3639E+01_JPRB,1.0124E+02_JPRB,1.3522E+02_JPRB,1.8034E+02_JPRB/)
KBO( :, 3,47,16) = (/&
&1.5031E+02_JPRB,1.1714E+02_JPRB,1.2800E+02_JPRB,1.7568E+02_JPRB,2.3430E+02_JPRB/)
KBO( :, 4,47,16) = (/&
&1.8310E+02_JPRB,1.4216E+02_JPRB,1.5736E+02_JPRB,2.2148E+02_JPRB,2.9535E+02_JPRB/)
KBO( :, 5,47,16) = (/&
&2.1655E+02_JPRB,1.6875E+02_JPRB,1.8931E+02_JPRB,2.7187E+02_JPRB,3.6261E+02_JPRB/)
KBO( :, 1,48,16) = (/&
&8.2434E+01_JPRB,6.5271E+01_JPRB,6.9082E+01_JPRB,8.9310E+01_JPRB,1.1908E+02_JPRB/)
KBO( :, 2,48,16) = (/&
&1.0815E+02_JPRB,8.4940E+01_JPRB,9.1497E+01_JPRB,1.2085E+02_JPRB,1.6117E+02_JPRB/)
KBO( :, 3,48,16) = (/&
&1.3796E+02_JPRB,1.0775E+02_JPRB,1.1715E+02_JPRB,1.5893E+02_JPRB,2.1191E+02_JPRB/)
KBO( :, 4,48,16) = (/&
&1.7024E+02_JPRB,1.3227E+02_JPRB,1.4550E+02_JPRB,2.0275E+02_JPRB,2.7033E+02_JPRB/)
KBO( :, 5,48,16) = (/&
&2.0361E+02_JPRB,1.5829E+02_JPRB,1.7646E+02_JPRB,2.5142E+02_JPRB,3.3526E+02_JPRB/)
KBO( :, 1,49,16) = (/&
&7.3591E+01_JPRB,5.8555E+01_JPRB,6.1217E+01_JPRB,7.8585E+01_JPRB,1.0478E+02_JPRB/)
KBO( :, 2,49,16) = (/&
&9.7468E+01_JPRB,7.6787E+01_JPRB,8.2199E+01_JPRB,1.0753E+02_JPRB,1.4337E+02_JPRB/)
KBO( :, 3,49,16) = (/&
&1.2589E+02_JPRB,9.8595E+01_JPRB,1.0664E+02_JPRB,1.4299E+02_JPRB,1.9063E+02_JPRB/)
KBO( :, 4,49,16) = (/&
&1.5743E+02_JPRB,1.2250E+02_JPRB,1.3397E+02_JPRB,1.8464E+02_JPRB,2.4618E+02_JPRB/)
KBO( :, 5,49,16) = (/&
&1.9052E+02_JPRB,1.4794E+02_JPRB,1.6391E+02_JPRB,2.3149E+02_JPRB,3.0868E+02_JPRB/)
KBO( :, 1,50,16) = (/&
&6.5961E+01_JPRB,5.2638E+01_JPRB,5.4393E+01_JPRB,6.9399E+01_JPRB,9.2534E+01_JPRB/)
KBO( :, 2,50,16) = (/&
&8.8116E+01_JPRB,6.9616E+01_JPRB,7.3948E+01_JPRB,9.5883E+01_JPRB,1.2784E+02_JPRB/)
KBO( :, 3,50,16) = (/&
&1.1495E+02_JPRB,9.0222E+01_JPRB,9.7185E+01_JPRB,1.2898E+02_JPRB,1.7197E+02_JPRB/)
KBO( :, 4,50,16) = (/&
&1.4556E+02_JPRB,1.1350E+02_JPRB,1.2350E+02_JPRB,1.6846E+02_JPRB,2.2453E+02_JPRB/)
KBO( :, 5,50,16) = (/&
&1.7823E+02_JPRB,1.3839E+02_JPRB,1.5245E+02_JPRB,2.1343E+02_JPRB,2.8458E+02_JPRB/)
KBO( :, 1,51,16) = (/&
&5.9119E+01_JPRB,4.7354E+01_JPRB,4.8344E+01_JPRB,6.1204E+01_JPRB,8.1604E+01_JPRB/)
KBO( :, 2,51,16) = (/&
&7.9680E+01_JPRB,6.3168E+01_JPRB,6.6452E+01_JPRB,8.5530E+01_JPRB,1.1410E+02_JPRB/)
KBO( :, 3,51,16) = (/&
&1.0482E+02_JPRB,8.2356E+01_JPRB,8.8430E+01_JPRB,1.1623E+02_JPRB,1.5497E+02_JPRB/)
KBO( :, 4,51,16) = (/&
&1.3427E+02_JPRB,1.0494E+02_JPRB,1.1368E+02_JPRB,1.5339E+02_JPRB,2.0454E+02_JPRB/)
KBO( :, 5,51,16) = (/&
&1.6639E+02_JPRB,1.2932E+02_JPRB,1.4173E+02_JPRB,1.9652E+02_JPRB,2.6202E+02_JPRB/)
KBO( :, 1,52,16) = (/&
&5.2745E+01_JPRB,4.2467E+01_JPRB,4.2754E+01_JPRB,5.3680E+01_JPRB,7.1576E+01_JPRB/)
KBO( :, 2,52,16) = (/&
&7.1747E+01_JPRB,5.7129E+01_JPRB,5.9424E+01_JPRB,7.6073E+01_JPRB,1.0142E+02_JPRB/)
KBO( :, 3,52,16) = (/&
&9.5200E+01_JPRB,7.5047E+01_JPRB,8.0071E+01_JPRB,1.0434E+02_JPRB,1.3911E+02_JPRB/)
KBO( :, 4,52,16) = (/&
&1.2328E+02_JPRB,9.6608E+01_JPRB,1.0420E+02_JPRB,1.3918E+02_JPRB,1.8556E+02_JPRB/)
KBO( :, 5,52,16) = (/&
&1.5465E+02_JPRB,1.2039E+02_JPRB,1.3128E+02_JPRB,1.8026E+02_JPRB,2.4037E+02_JPRB/)
KBO( :, 1,53,16) = (/&
&4.6931E+01_JPRB,3.7942E+01_JPRB,3.7717E+01_JPRB,4.6873E+01_JPRB,6.2479E+01_JPRB/)
KBO( :, 2,53,16) = (/&
&6.4426E+01_JPRB,5.1434E+01_JPRB,5.2934E+01_JPRB,6.7323E+01_JPRB,8.9766E+01_JPRB/)
KBO( :, 3,53,16) = (/&
&8.6242E+01_JPRB,6.8154E+01_JPRB,7.2147E+01_JPRB,9.3266E+01_JPRB,1.2436E+02_JPRB/)
KBO( :, 4,53,16) = (/&
&1.1270E+02_JPRB,8.8425E+01_JPRB,9.5072E+01_JPRB,1.2575E+02_JPRB,1.6767E+02_JPRB/)
KBO( :, 5,53,16) = (/&
&1.4306E+02_JPRB,1.1161E+02_JPRB,1.2116E+02_JPRB,1.6465E+02_JPRB,2.1957E+02_JPRB/)
KBO( :, 1,54,16) = (/&
&4.2077E+01_JPRB,3.4169E+01_JPRB,3.3488E+01_JPRB,4.1262E+01_JPRB,5.4902E+01_JPRB/)
KBO( :, 2,54,16) = (/&
&5.8190E+01_JPRB,4.6634E+01_JPRB,4.7441E+01_JPRB,5.9915E+01_JPRB,7.9878E+01_JPRB/)
KBO( :, 3,54,16) = (/&
&7.8514E+01_JPRB,6.2282E+01_JPRB,6.5328E+01_JPRB,8.3924E+01_JPRB,1.1190E+02_JPRB/)
KBO( :, 4,54,16) = (/&
&1.0342E+02_JPRB,8.1276E+01_JPRB,8.7086E+01_JPRB,1.1420E+02_JPRB,1.5227E+02_JPRB/)
KBO( :, 5,54,16) = (/&
&1.3269E+02_JPRB,1.0372E+02_JPRB,1.1219E+02_JPRB,1.5097E+02_JPRB,2.0130E+02_JPRB/)
KBO( :, 1,55,16) = (/&
&3.7797E+01_JPRB,3.0836E+01_JPRB,2.9805E+01_JPRB,3.6383E+01_JPRB,4.8271E+01_JPRB/)
KBO( :, 2,55,16) = (/&
&5.2583E+01_JPRB,4.2337E+01_JPRB,4.2558E+01_JPRB,5.3364E+01_JPRB,7.1129E+01_JPRB/)
KBO( :, 3,55,16) = (/&
&7.1538E+01_JPRB,5.6971E+01_JPRB,5.9162E+01_JPRB,7.5653E+01_JPRB,1.0088E+02_JPRB/)
KBO( :, 4,55,16) = (/&
&9.4943E+01_JPRB,7.4845E+01_JPRB,7.9765E+01_JPRB,1.0380E+02_JPRB,1.3840E+02_JPRB/)
KBO( :, 5,55,16) = (/&
&1.2300E+02_JPRB,9.6367E+01_JPRB,1.0384E+02_JPRB,1.3854E+02_JPRB,1.8472E+02_JPRB/)
KBO( :, 1,56,16) = (/&
&3.3873E+01_JPRB,2.7740E+01_JPRB,2.6480E+01_JPRB,3.1942E+01_JPRB,4.2208E+01_JPRB/)
KBO( :, 2,56,16) = (/&
&4.7453E+01_JPRB,3.8343E+01_JPRB,3.8125E+01_JPRB,4.7379E+01_JPRB,6.3148E+01_JPRB/)
KBO( :, 3,56,16) = (/&
&6.5091E+01_JPRB,5.1940E+01_JPRB,5.3452E+01_JPRB,6.7966E+01_JPRB,9.0627E+01_JPRB/)
KBO( :, 4,56,16) = (/&
&8.7046E+01_JPRB,6.8764E+01_JPRB,7.2784E+01_JPRB,9.4072E+01_JPRB,1.2543E+02_JPRB/)
KBO( :, 5,56,16) = (/&
&1.1365E+02_JPRB,8.9173E+01_JPRB,9.5823E+01_JPRB,1.2676E+02_JPRB,1.6901E+02_JPRB/)
KBO( :, 1,57,16) = (/&
&3.0269E+01_JPRB,2.4887E+01_JPRB,2.3522E+01_JPRB,2.7966E+01_JPRB,3.6672E+01_JPRB/)
KBO( :, 2,57,16) = (/&
&4.2742E+01_JPRB,3.4680E+01_JPRB,3.4029E+01_JPRB,4.1940E+01_JPRB,5.5826E+01_JPRB/)
KBO( :, 3,57,16) = (/&
&5.9049E+01_JPRB,4.7291E+01_JPRB,4.8146E+01_JPRB,6.0813E+01_JPRB,8.1079E+01_JPRB/)
KBO( :, 4,57,16) = (/&
&7.9588E+01_JPRB,6.3092E+01_JPRB,6.6213E+01_JPRB,8.5068E+01_JPRB,1.1341E+02_JPRB/)
KBO( :, 5,57,16) = (/&
&1.0467E+02_JPRB,8.2241E+01_JPRB,8.8127E+01_JPRB,1.1561E+02_JPRB,1.5417E+02_JPRB/)
KBO( :, 1,58,16) = (/&
&2.7181E+01_JPRB,2.2407E+01_JPRB,2.1043E+01_JPRB,2.4570E+01_JPRB,3.1903E+01_JPRB/)
KBO( :, 2,58,16) = (/&
&3.8607E+01_JPRB,3.1473E+01_JPRB,3.0470E+01_JPRB,3.7255E+01_JPRB,4.9462E+01_JPRB/)
KBO( :, 3,58,16) = (/&
&5.3661E+01_JPRB,4.3166E+01_JPRB,4.3454E+01_JPRB,5.4507E+01_JPRB,7.2688E+01_JPRB/)
KBO( :, 4,58,16) = (/&
&7.2881E+01_JPRB,5.7996E+01_JPRB,6.0310E+01_JPRB,7.7125E+01_JPRB,1.0284E+02_JPRB/)
KBO( :, 5,58,16) = (/&
&9.6586E+01_JPRB,7.6089E+01_JPRB,8.1135E+01_JPRB,1.0566E+02_JPRB,1.4091E+02_JPRB/)
KBO( :, 1,59,16) = (/&
&2.6031E+01_JPRB,2.1482E+01_JPRB,2.0126E+01_JPRB,2.3303E+01_JPRB,3.0129E+01_JPRB/)
KBO( :, 2,59,16) = (/&
&3.7063E+01_JPRB,3.0259E+01_JPRB,2.9150E+01_JPRB,3.5486E+01_JPRB,4.7064E+01_JPRB/)
KBO( :, 3,59,16) = (/&
&5.1630E+01_JPRB,4.1596E+01_JPRB,4.1690E+01_JPRB,5.2144E+01_JPRB,6.9539E+01_JPRB/)
KBO( :, 4,59,16) = (/&
&7.0350E+01_JPRB,5.6032E+01_JPRB,5.8043E+01_JPRB,7.4115E+01_JPRB,9.8842E+01_JPRB/)
KBO( :, 5,59,16) = (/&
&9.3474E+01_JPRB,7.3716E+01_JPRB,7.8416E+01_JPRB,1.0186E+02_JPRB,1.3581E+02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3_B4
