!OCL SCALAR
SUBROUTINE RRTM_KGB3_B3

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different H2O to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = H2O/(H2O+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of H2O.  For instance, JS=1 refers to no H2O, 
!     JS = 2 corresponds to eta = 0.25, etc.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 9) = (/&
&6.2749E-02_JPRB,7.2855E-02_JPRB,6.7478E-02_JPRB,5.3345E-02_JPRB,4.4699E-01_JPRB/)
KBO( :, 2,13, 9) = (/&
&8.6319E-02_JPRB,1.0135E-01_JPRB,9.4230E-02_JPRB,7.4640E-02_JPRB,4.8102E-01_JPRB/)
KBO( :, 3,13, 9) = (/&
&1.1531E-01_JPRB,1.3583E-01_JPRB,1.2671E-01_JPRB,1.0042E-01_JPRB,5.1621E-01_JPRB/)
KBO( :, 4,13, 9) = (/&
&1.4981E-01_JPRB,1.7650E-01_JPRB,1.6480E-01_JPRB,1.3078E-01_JPRB,5.5243E-01_JPRB/)
KBO( :, 5,13, 9) = (/&
&1.8970E-01_JPRB,2.2347E-01_JPRB,2.0865E-01_JPRB,1.6587E-01_JPRB,5.8937E-01_JPRB/)
KBO( :, 1,14, 9) = (/&
&5.7187E-02_JPRB,6.7301E-02_JPRB,6.2129E-02_JPRB,4.9110E-02_JPRB,3.7769E-01_JPRB/)
KBO( :, 2,14, 9) = (/&
&7.8466E-02_JPRB,9.3270E-02_JPRB,8.6445E-02_JPRB,6.8459E-02_JPRB,4.0753E-01_JPRB/)
KBO( :, 3,14, 9) = (/&
&1.0467E-01_JPRB,1.2476E-01_JPRB,1.1574E-01_JPRB,9.1819E-02_JPRB,4.3868E-01_JPRB/)
KBO( :, 4,14, 9) = (/&
&1.3581E-01_JPRB,1.6192E-01_JPRB,1.5034E-01_JPRB,1.1930E-01_JPRB,4.7064E-01_JPRB/)
KBO( :, 5,14, 9) = (/&
&1.7224E-01_JPRB,2.0464E-01_JPRB,1.9021E-01_JPRB,1.5110E-01_JPRB,5.0408E-01_JPRB/)
KBO( :, 1,15, 9) = (/&
&5.1721E-02_JPRB,6.1566E-02_JPRB,5.6680E-02_JPRB,4.4751E-02_JPRB,2.9568E-01_JPRB/)
KBO( :, 2,15, 9) = (/&
&7.0936E-02_JPRB,8.5115E-02_JPRB,7.8492E-02_JPRB,6.2182E-02_JPRB,3.2213E-01_JPRB/)
KBO( :, 3,15, 9) = (/&
&9.4515E-02_JPRB,1.1370E-01_JPRB,1.0486E-01_JPRB,8.3182E-02_JPRB,3.4986E-01_JPRB/)
KBO( :, 4,15, 9) = (/&
&1.2289E-01_JPRB,1.4728E-01_JPRB,1.3607E-01_JPRB,1.0790E-01_JPRB,3.7853E-01_JPRB/)
KBO( :, 5,15, 9) = (/&
&1.5637E-01_JPRB,1.8627E-01_JPRB,1.7195E-01_JPRB,1.3626E-01_JPRB,4.0894E-01_JPRB/)
KBO( :, 1,16, 9) = (/&
&4.6578E-02_JPRB,5.5911E-02_JPRB,5.1274E-02_JPRB,4.0416E-02_JPRB,2.2673E-01_JPRB/)
KBO( :, 2,16, 9) = (/&
&6.3866E-02_JPRB,7.7158E-02_JPRB,7.0810E-02_JPRB,5.5944E-02_JPRB,2.5071E-01_JPRB/)
KBO( :, 3,16, 9) = (/&
&8.5294E-02_JPRB,1.0285E-01_JPRB,9.4463E-02_JPRB,7.4731E-02_JPRB,2.7559E-01_JPRB/)
KBO( :, 4,16, 9) = (/&
&1.1126E-01_JPRB,1.3331E-01_JPRB,1.2237E-01_JPRB,9.6725E-02_JPRB,3.0207E-01_JPRB/)
KBO( :, 5,16, 9) = (/&
&1.4207E-01_JPRB,1.6889E-01_JPRB,1.5467E-01_JPRB,1.2182E-01_JPRB,3.3015E-01_JPRB/)
KBO( :, 1,17, 9) = (/&
&4.1900E-02_JPRB,5.0464E-02_JPRB,4.6053E-02_JPRB,3.6179E-02_JPRB,1.8226E-01_JPRB/)
KBO( :, 2,17, 9) = (/&
&5.7522E-02_JPRB,6.9444E-02_JPRB,6.3472E-02_JPRB,4.9973E-02_JPRB,2.0447E-01_JPRB/)
KBO( :, 3,17, 9) = (/&
&7.7026E-02_JPRB,9.2538E-02_JPRB,8.4551E-02_JPRB,6.6605E-02_JPRB,2.2810E-01_JPRB/)
KBO( :, 4,17, 9) = (/&
&1.0079E-01_JPRB,1.2017E-01_JPRB,1.0955E-01_JPRB,8.5985E-02_JPRB,2.5342E-01_JPRB/)
KBO( :, 5,17, 9) = (/&
&1.2927E-01_JPRB,1.5258E-01_JPRB,1.3846E-01_JPRB,1.0816E-01_JPRB,2.7946E-01_JPRB/)
KBO( :, 1,18, 9) = (/&
&3.7891E-02_JPRB,4.5454E-02_JPRB,4.1197E-02_JPRB,3.2260E-02_JPRB,1.5403E-01_JPRB/)
KBO( :, 2,18, 9) = (/&
&5.2057E-02_JPRB,6.2358E-02_JPRB,5.6644E-02_JPRB,4.4449E-02_JPRB,1.7502E-01_JPRB/)
KBO( :, 3,18, 9) = (/&
&6.9815E-02_JPRB,8.3160E-02_JPRB,7.5488E-02_JPRB,5.9051E-02_JPRB,1.9748E-01_JPRB/)
KBO( :, 4,18, 9) = (/&
&9.1668E-02_JPRB,1.0819E-01_JPRB,9.7824E-02_JPRB,7.6130E-02_JPRB,2.2105E-01_JPRB/)
KBO( :, 5,18, 9) = (/&
&1.1799E-01_JPRB,1.3770E-01_JPRB,1.2371E-01_JPRB,9.5780E-02_JPRB,2.4525E-01_JPRB/)
KBO( :, 1,19, 9) = (/&
&3.4441E-02_JPRB,4.0854E-02_JPRB,3.6785E-02_JPRB,2.8648E-02_JPRB,1.3592E-01_JPRB/)
KBO( :, 2,19, 9) = (/&
&4.7310E-02_JPRB,5.6014E-02_JPRB,5.0505E-02_JPRB,3.9333E-02_JPRB,1.5599E-01_JPRB/)
KBO( :, 3,19, 9) = (/&
&6.3559E-02_JPRB,7.4763E-02_JPRB,6.7291E-02_JPRB,5.2149E-02_JPRB,1.7738E-01_JPRB/)
KBO( :, 4,19, 9) = (/&
&8.3699E-02_JPRB,9.7466E-02_JPRB,8.7225E-02_JPRB,6.7250E-02_JPRB,1.9960E-01_JPRB/)
KBO( :, 5,19, 9) = (/&
&1.0809E-01_JPRB,1.2436E-01_JPRB,1.1051E-01_JPRB,8.4704E-02_JPRB,2.2240E-01_JPRB/)
KBO( :, 1,20, 9) = (/&
&3.1662E-02_JPRB,3.7011E-02_JPRB,3.3064E-02_JPRB,2.5535E-02_JPRB,1.2166E-01_JPRB/)
KBO( :, 2,20, 9) = (/&
&4.3462E-02_JPRB,5.0683E-02_JPRB,4.5312E-02_JPRB,3.4918E-02_JPRB,1.4050E-01_JPRB/)
KBO( :, 3,20, 9) = (/&
&5.8468E-02_JPRB,6.7693E-02_JPRB,6.0291E-02_JPRB,4.6251E-02_JPRB,1.6041E-01_JPRB/)
KBO( :, 4,20, 9) = (/&
&7.7082E-02_JPRB,8.8368E-02_JPRB,7.8218E-02_JPRB,5.9632E-02_JPRB,1.8092E-01_JPRB/)
KBO( :, 5,20, 9) = (/&
&9.9590E-02_JPRB,1.1296E-01_JPRB,9.9282E-02_JPRB,7.5236E-02_JPRB,2.0180E-01_JPRB/)
KBO( :, 1,21, 9) = (/&
&2.9197E-02_JPRB,3.3644E-02_JPRB,2.9800E-02_JPRB,2.2751E-02_JPRB,1.0840E-01_JPRB/)
KBO( :, 2,21, 9) = (/&
&4.0061E-02_JPRB,4.6022E-02_JPRB,4.0720E-02_JPRB,3.1025E-02_JPRB,1.2575E-01_JPRB/)
KBO( :, 3,21, 9) = (/&
&5.3879E-02_JPRB,6.1513E-02_JPRB,5.4145E-02_JPRB,4.1071E-02_JPRB,1.4377E-01_JPRB/)
KBO( :, 4,21, 9) = (/&
&7.1035E-02_JPRB,8.0368E-02_JPRB,7.0344E-02_JPRB,5.2993E-02_JPRB,1.6228E-01_JPRB/)
KBO( :, 5,21, 9) = (/&
&9.1717E-02_JPRB,1.0275E-01_JPRB,8.9495E-02_JPRB,6.6978E-02_JPRB,1.8109E-01_JPRB/)
KBO( :, 1,22, 9) = (/&
&2.7499E-02_JPRB,3.1251E-02_JPRB,2.7449E-02_JPRB,2.0717E-02_JPRB,9.5123E-02_JPRB/)
KBO( :, 2,22, 9) = (/&
&3.7657E-02_JPRB,4.2715E-02_JPRB,3.7381E-02_JPRB,2.8145E-02_JPRB,1.1043E-01_JPRB/)
KBO( :, 3,22, 9) = (/&
&5.0562E-02_JPRB,5.6977E-02_JPRB,4.9664E-02_JPRB,3.7184E-02_JPRB,1.2615E-01_JPRB/)
KBO( :, 4,22, 9) = (/&
&6.6397E-02_JPRB,7.4321E-02_JPRB,6.4486E-02_JPRB,4.7986E-02_JPRB,1.4210E-01_JPRB/)
KBO( :, 5,22, 9) = (/&
&8.5266E-02_JPRB,9.4958E-02_JPRB,8.2045E-02_JPRB,6.0712E-02_JPRB,1.5827E-01_JPRB/)
KBO( :, 1,23, 9) = (/&
&2.5951E-02_JPRB,2.9125E-02_JPRB,2.5330E-02_JPRB,1.8934E-02_JPRB,8.2353E-02_JPRB/)
KBO( :, 2,23, 9) = (/&
&3.5455E-02_JPRB,3.9694E-02_JPRB,3.4441E-02_JPRB,2.5641E-02_JPRB,9.5317E-02_JPRB/)
KBO( :, 3,23, 9) = (/&
&4.7331E-02_JPRB,5.2838E-02_JPRB,4.5688E-02_JPRB,3.3836E-02_JPRB,1.0857E-01_JPRB/)
KBO( :, 4,23, 9) = (/&
&6.1763E-02_JPRB,6.8758E-02_JPRB,5.9284E-02_JPRB,4.3652E-02_JPRB,1.2209E-01_JPRB/)
KBO( :, 5,23, 9) = (/&
&7.8933E-02_JPRB,8.7537E-02_JPRB,7.5364E-02_JPRB,5.5173E-02_JPRB,1.3590E-01_JPRB/)
KBO( :, 1,24, 9) = (/&
&2.4473E-02_JPRB,2.7169E-02_JPRB,2.3444E-02_JPRB,1.7363E-02_JPRB,6.9430E-02_JPRB/)
KBO( :, 2,24, 9) = (/&
&3.3250E-02_JPRB,3.6936E-02_JPRB,3.1810E-02_JPRB,2.3462E-02_JPRB,8.0157E-02_JPRB/)
KBO( :, 3,24, 9) = (/&
&4.4117E-02_JPRB,4.8975E-02_JPRB,4.2123E-02_JPRB,3.0921E-02_JPRB,9.1223E-02_JPRB/)
KBO( :, 4,24, 9) = (/&
&5.7285E-02_JPRB,6.3439E-02_JPRB,5.4524E-02_JPRB,3.9854E-02_JPRB,1.0266E-01_JPRB/)
KBO( :, 5,24, 9) = (/&
&7.2998E-02_JPRB,8.0524E-02_JPRB,6.9109E-02_JPRB,5.0332E-02_JPRB,1.1441E-01_JPRB/)
KBO( :, 1,25, 9) = (/&
&2.3088E-02_JPRB,2.5438E-02_JPRB,2.1801E-02_JPRB,1.6002E-02_JPRB,5.7837E-02_JPRB/)
KBO( :, 2,25, 9) = (/&
&3.1174E-02_JPRB,3.4396E-02_JPRB,2.9493E-02_JPRB,2.1569E-02_JPRB,6.6784E-02_JPRB/)
KBO( :, 3,25, 9) = (/&
&4.1147E-02_JPRB,4.5360E-02_JPRB,3.8891E-02_JPRB,2.8375E-02_JPRB,7.6101E-02_JPRB/)
KBO( :, 4,25, 9) = (/&
&5.3244E-02_JPRB,5.8521E-02_JPRB,5.0118E-02_JPRB,3.6473E-02_JPRB,8.5758E-02_JPRB/)
KBO( :, 5,25, 9) = (/&
&6.7659E-02_JPRB,7.4121E-02_JPRB,6.3317E-02_JPRB,4.5953E-02_JPRB,9.5693E-02_JPRB/)
KBO( :, 1,26, 9) = (/&
&2.1853E-02_JPRB,2.3928E-02_JPRB,2.0426E-02_JPRB,1.4853E-02_JPRB,4.8392E-02_JPRB/)
KBO( :, 2,26, 9) = (/&
&2.9360E-02_JPRB,3.2138E-02_JPRB,2.7449E-02_JPRB,1.9958E-02_JPRB,5.5916E-02_JPRB/)
KBO( :, 3,26, 9) = (/&
&3.8590E-02_JPRB,4.2170E-02_JPRB,3.5993E-02_JPRB,2.6138E-02_JPRB,6.3792E-02_JPRB/)
KBO( :, 4,26, 9) = (/&
&4.9775E-02_JPRB,5.4242E-02_JPRB,4.6206E-02_JPRB,3.3463E-02_JPRB,7.1975E-02_JPRB/)
KBO( :, 5,26, 9) = (/&
&6.3079E-02_JPRB,6.8549E-02_JPRB,5.8245E-02_JPRB,4.2044E-02_JPRB,8.0448E-02_JPRB/)
KBO( :, 1,27, 9) = (/&
&2.0589E-02_JPRB,2.2432E-02_JPRB,1.9091E-02_JPRB,1.3798E-02_JPRB,3.9711E-02_JPRB/)
KBO( :, 2,27, 9) = (/&
&2.7577E-02_JPRB,2.9992E-02_JPRB,2.5499E-02_JPRB,1.8441E-02_JPRB,4.5946E-02_JPRB/)
KBO( :, 3,27, 9) = (/&
&3.6163E-02_JPRB,3.9222E-02_JPRB,3.3292E-02_JPRB,2.4027E-02_JPRB,5.2514E-02_JPRB/)
KBO( :, 4,27, 9) = (/&
&4.6525E-02_JPRB,5.0331E-02_JPRB,4.2630E-02_JPRB,3.0669E-02_JPRB,5.9354E-02_JPRB/)
KBO( :, 5,27, 9) = (/&
&5.8822E-02_JPRB,6.3502E-02_JPRB,5.3650E-02_JPRB,3.8505E-02_JPRB,6.6468E-02_JPRB/)
KBO( :, 1,28, 9) = (/&
&1.9320E-02_JPRB,2.0975E-02_JPRB,1.7795E-02_JPRB,1.2791E-02_JPRB,3.1912E-02_JPRB/)
KBO( :, 2,28, 9) = (/&
&2.5855E-02_JPRB,2.7959E-02_JPRB,2.3678E-02_JPRB,1.7000E-02_JPRB,3.7011E-02_JPRB/)
KBO( :, 3,28, 9) = (/&
&3.3864E-02_JPRB,3.6500E-02_JPRB,3.0839E-02_JPRB,2.2082E-02_JPRB,4.2382E-02_JPRB/)
KBO( :, 4,28, 9) = (/&
&4.3478E-02_JPRB,4.6764E-02_JPRB,3.9410E-02_JPRB,2.8143E-02_JPRB,4.8009E-02_JPRB/)
KBO( :, 5,28, 9) = (/&
&5.4874E-02_JPRB,5.8907E-02_JPRB,4.9537E-02_JPRB,3.5320E-02_JPRB,5.3947E-02_JPRB/)
KBO( :, 1,29, 9) = (/&
&1.8123E-02_JPRB,1.9628E-02_JPRB,1.6597E-02_JPRB,1.1861E-02_JPRB,2.5423E-02_JPRB/)
KBO( :, 2,29, 9) = (/&
&2.4225E-02_JPRB,2.6121E-02_JPRB,2.2032E-02_JPRB,1.5699E-02_JPRB,2.9542E-02_JPRB/)
KBO( :, 3,29, 9) = (/&
&3.1700E-02_JPRB,3.4031E-02_JPRB,2.8639E-02_JPRB,2.0345E-02_JPRB,3.3911E-02_JPRB/)
KBO( :, 4,29, 9) = (/&
&4.0663E-02_JPRB,4.3529E-02_JPRB,3.6544E-02_JPRB,2.5917E-02_JPRB,3.8545E-02_JPRB/)
KBO( :, 5,29, 9) = (/&
&5.1268E-02_JPRB,5.4769E-02_JPRB,4.5895E-02_JPRB,3.2522E-02_JPRB,4.3488E-02_JPRB/)
KBO( :, 1,30, 9) = (/&
&1.6958E-02_JPRB,1.8364E-02_JPRB,1.5479E-02_JPRB,1.0998E-02_JPRB,1.9951E-02_JPRB/)
KBO( :, 2,30, 9) = (/&
&2.2671E-02_JPRB,2.4409E-02_JPRB,2.0518E-02_JPRB,1.4521E-02_JPRB,2.3241E-02_JPRB/)
KBO( :, 3,30, 9) = (/&
&2.9641E-02_JPRB,3.1772E-02_JPRB,2.6628E-02_JPRB,1.8795E-02_JPRB,2.6766E-02_JPRB/)
KBO( :, 4,30, 9) = (/&
&3.8012E-02_JPRB,4.0581E-02_JPRB,3.3943E-02_JPRB,2.3935E-02_JPRB,3.0561E-02_JPRB/)
KBO( :, 5,30, 9) = (/&
&4.7908E-02_JPRB,5.1031E-02_JPRB,4.2627E-02_JPRB,3.0033E-02_JPRB,3.4653E-02_JPRB/)
KBO( :, 1,31, 9) = (/&
&1.5875E-02_JPRB,1.7181E-02_JPRB,1.4459E-02_JPRB,1.0211E-02_JPRB,1.5400E-02_JPRB/)
KBO( :, 2,31, 9) = (/&
&2.1201E-02_JPRB,2.2826E-02_JPRB,1.9139E-02_JPRB,1.3463E-02_JPRB,1.8009E-02_JPRB/)
KBO( :, 3,31, 9) = (/&
&2.7703E-02_JPRB,2.9694E-02_JPRB,2.4816E-02_JPRB,1.7421E-02_JPRB,2.0837E-02_JPRB/)
KBO( :, 4,31, 9) = (/&
&3.5538E-02_JPRB,3.7926E-02_JPRB,3.1623E-02_JPRB,2.2179E-02_JPRB,2.3914E-02_JPRB/)
KBO( :, 5,31, 9) = (/&
&4.4824E-02_JPRB,4.7692E-02_JPRB,3.9738E-02_JPRB,2.7844E-02_JPRB,2.7277E-02_JPRB/)
KBO( :, 1,32, 9) = (/&
&1.4881E-02_JPRB,1.6116E-02_JPRB,1.3532E-02_JPRB,9.5127E-03_JPRB,1.1925E-02_JPRB/)
KBO( :, 2,32, 9) = (/&
&1.9865E-02_JPRB,2.1395E-02_JPRB,1.7905E-02_JPRB,1.2529E-02_JPRB,1.4004E-02_JPRB/)
KBO( :, 3,32, 9) = (/&
&2.5959E-02_JPRB,2.7823E-02_JPRB,2.3208E-02_JPRB,1.6206E-02_JPRB,1.6285E-02_JPRB/)
KBO( :, 4,32, 9) = (/&
&3.3313E-02_JPRB,3.5564E-02_JPRB,2.9600E-02_JPRB,2.0639E-02_JPRB,1.8807E-02_JPRB/)
KBO( :, 5,32, 9) = (/&
&4.2060E-02_JPRB,4.4782E-02_JPRB,3.7223E-02_JPRB,2.5926E-02_JPRB,2.1578E-02_JPRB/)
KBO( :, 1,33, 9) = (/&
&1.3967E-02_JPRB,1.5144E-02_JPRB,1.2690E-02_JPRB,8.8844E-03_JPRB,9.2074E-03_JPRB/)
KBO( :, 2,33, 9) = (/&
&1.8640E-02_JPRB,2.0097E-02_JPRB,1.6785E-02_JPRB,1.1705E-02_JPRB,1.0873E-02_JPRB/)
KBO( :, 3,33, 9) = (/&
&2.4387E-02_JPRB,2.6153E-02_JPRB,2.1778E-02_JPRB,1.5136E-02_JPRB,1.2726E-02_JPRB/)
KBO( :, 4,33, 9) = (/&
&3.1327E-02_JPRB,3.3471E-02_JPRB,2.7814E-02_JPRB,1.9292E-02_JPRB,1.4787E-02_JPRB/)
KBO( :, 5,33, 9) = (/&
&3.9572E-02_JPRB,4.2221E-02_JPRB,3.5044E-02_JPRB,2.4264E-02_JPRB,1.7080E-02_JPRB/)
KBO( :, 1,34, 9) = (/&
&1.3038E-02_JPRB,1.4154E-02_JPRB,1.1832E-02_JPRB,8.2492E-03_JPRB,7.3647E-03_JPRB/)
KBO( :, 2,34, 9) = (/&
&1.7420E-02_JPRB,1.8798E-02_JPRB,1.5659E-02_JPRB,1.0876E-02_JPRB,8.7412E-03_JPRB/)
KBO( :, 3,34, 9) = (/&
&2.2825E-02_JPRB,2.4500E-02_JPRB,2.0360E-02_JPRB,1.4089E-02_JPRB,1.0289E-02_JPRB/)
KBO( :, 4,34, 9) = (/&
&2.9360E-02_JPRB,3.1418E-02_JPRB,2.6065E-02_JPRB,1.7978E-02_JPRB,1.2027E-02_JPRB/)
KBO( :, 5,34, 9) = (/&
&3.7137E-02_JPRB,3.9713E-02_JPRB,3.2919E-02_JPRB,2.2661E-02_JPRB,1.3976E-02_JPRB/)
KBO( :, 1,35, 9) = (/&
&1.1851E-02_JPRB,1.2890E-02_JPRB,1.0761E-02_JPRB,7.4718E-03_JPRB,5.7550E-03_JPRB/)
KBO( :, 2,35, 9) = (/&
&1.5900E-02_JPRB,1.7182E-02_JPRB,1.4286E-02_JPRB,9.8834E-03_JPRB,6.8791E-03_JPRB/)
KBO( :, 3,35, 9) = (/&
&2.0897E-02_JPRB,2.2486E-02_JPRB,1.8648E-02_JPRB,1.2848E-02_JPRB,8.1522E-03_JPRB/)
KBO( :, 4,35, 9) = (/&
&2.6965E-02_JPRB,2.8940E-02_JPRB,2.3971E-02_JPRB,1.6457E-02_JPRB,9.5922E-03_JPRB/)
KBO( :, 5,35, 9) = (/&
&3.4238E-02_JPRB,3.6722E-02_JPRB,3.0385E-02_JPRB,2.0819E-02_JPRB,1.1216E-02_JPRB/)
KBO( :, 1,36, 9) = (/&
&1.0455E-02_JPRB,1.1397E-02_JPRB,9.5033E-03_JPRB,6.5755E-03_JPRB,4.3571E-03_JPRB/)
KBO( :, 2,36, 9) = (/&
&1.4117E-02_JPRB,1.5290E-02_JPRB,1.2699E-02_JPRB,8.7484E-03_JPRB,5.2508E-03_JPRB/)
KBO( :, 3,36, 9) = (/&
&1.8658E-02_JPRB,2.0138E-02_JPRB,1.6673E-02_JPRB,1.1439E-02_JPRB,6.2734E-03_JPRB/)
KBO( :, 4,36, 9) = (/&
&2.4204E-02_JPRB,2.6071E-02_JPRB,2.1551E-02_JPRB,1.4738E-02_JPRB,7.4336E-03_JPRB/)
KBO( :, 5,36, 9) = (/&
&3.0898E-02_JPRB,3.3263E-02_JPRB,2.7471E-02_JPRB,1.8745E-02_JPRB,8.7508E-03_JPRB/)
KBO( :, 1,37, 9) = (/&
&8.8498E-03_JPRB,9.6657E-03_JPRB,8.0482E-03_JPRB,5.5507E-03_JPRB,3.4394E-03_JPRB/)
KBO( :, 2,37, 9) = (/&
&1.2053E-02_JPRB,1.3088E-02_JPRB,1.0850E-02_JPRB,7.4463E-03_JPRB,4.1756E-03_JPRB/)
KBO( :, 3,37, 9) = (/&
&1.6053E-02_JPRB,1.7380E-02_JPRB,1.4373E-02_JPRB,9.8197E-03_JPRB,5.0255E-03_JPRB/)
KBO( :, 4,37, 9) = (/&
&2.0992E-02_JPRB,2.2697E-02_JPRB,1.8723E-02_JPRB,1.2754E-02_JPRB,5.9977E-03_JPRB/)
KBO( :, 5,37, 9) = (/&
&2.6999E-02_JPRB,2.9182E-02_JPRB,2.4048E-02_JPRB,1.6341E-02_JPRB,7.1081E-03_JPRB/)
KBO( :, 1,38, 9) = (/&
&7.4680E-03_JPRB,8.1793E-03_JPRB,6.8001E-03_JPRB,4.6741E-03_JPRB,2.7036E-03_JPRB/)
KBO( :, 2,38, 9) = (/&
&1.0268E-02_JPRB,1.1184E-02_JPRB,9.2546E-03_JPRB,6.3288E-03_JPRB,3.3094E-03_JPRB/)
KBO( :, 3,38, 9) = (/&
&1.3799E-02_JPRB,1.4987E-02_JPRB,1.2370E-02_JPRB,8.4204E-03_JPRB,4.0136E-03_JPRB/)
KBO( :, 4,38, 9) = (/&
&1.8189E-02_JPRB,1.9741E-02_JPRB,1.6260E-02_JPRB,1.1031E-02_JPRB,4.8267E-03_JPRB/)
KBO( :, 5,38, 9) = (/&
&2.3579E-02_JPRB,2.5605E-02_JPRB,2.1052E-02_JPRB,1.4244E-02_JPRB,5.7626E-03_JPRB/)
KBO( :, 1,39, 9) = (/&
&6.2942E-03_JPRB,6.9249E-03_JPRB,5.7460E-03_JPRB,3.9360E-03_JPRB,2.1044E-03_JPRB/)
KBO( :, 2,39, 9) = (/&
&8.7432E-03_JPRB,9.5663E-03_JPRB,7.9000E-03_JPRB,5.3823E-03_JPRB,2.5994E-03_JPRB/)
KBO( :, 3,39, 9) = (/&
&1.1864E-02_JPRB,1.2937E-02_JPRB,1.0660E-02_JPRB,7.2304E-03_JPRB,3.1792E-03_JPRB/)
KBO( :, 4,39, 9) = (/&
&1.5781E-02_JPRB,1.7197E-02_JPRB,1.4145E-02_JPRB,9.5554E-03_JPRB,3.8556E-03_JPRB/)
KBO( :, 5,39, 9) = (/&
&2.0624E-02_JPRB,2.2512E-02_JPRB,1.8470E-02_JPRB,1.2443E-02_JPRB,4.6381E-03_JPRB/)
KBO( :, 1,40, 9) = (/&
&5.1375E-03_JPRB,5.6803E-03_JPRB,4.7069E-03_JPRB,3.2115E-03_JPRB,1.6578E-03_JPRB/)
KBO( :, 2,40, 9) = (/&
&7.2291E-03_JPRB,7.9459E-03_JPRB,6.5495E-03_JPRB,4.4441E-03_JPRB,2.0666E-03_JPRB/)
KBO( :, 3,40, 9) = (/&
&9.9296E-03_JPRB,1.0871E-02_JPRB,8.9384E-03_JPRB,6.0392E-03_JPRB,2.5498E-03_JPRB/)
KBO( :, 4,40, 9) = (/&
&1.3354E-02_JPRB,1.4603E-02_JPRB,1.1989E-02_JPRB,8.0664E-03_JPRB,3.1172E-03_JPRB/)
KBO( :, 5,40, 9) = (/&
&1.7630E-02_JPRB,1.9320E-02_JPRB,1.5819E-02_JPRB,1.0610E-02_JPRB,3.7783E-03_JPRB/)
KBO( :, 1,41, 9) = (/&
&4.1669E-03_JPRB,4.6307E-03_JPRB,3.8311E-03_JPRB,2.6055E-03_JPRB,1.3022E-03_JPRB/)
KBO( :, 2,41, 9) = (/&
&5.9450E-03_JPRB,6.5654E-03_JPRB,5.4031E-03_JPRB,3.6497E-03_JPRB,1.6387E-03_JPRB/)
KBO( :, 3,41, 9) = (/&
&8.2702E-03_JPRB,9.0939E-03_JPRB,7.4627E-03_JPRB,5.0204E-03_JPRB,2.0406E-03_JPRB/)
KBO( :, 4,41, 9) = (/&
&1.1254E-02_JPRB,1.2358E-02_JPRB,1.0124E-02_JPRB,6.7836E-03_JPRB,2.5160E-03_JPRB/)
KBO( :, 5,41, 9) = (/&
&1.5021E-02_JPRB,1.6526E-02_JPRB,1.3505E-02_JPRB,9.0170E-03_JPRB,3.0745E-03_JPRB/)
KBO( :, 1,42, 9) = (/&
&3.3673E-03_JPRB,3.7618E-03_JPRB,3.1084E-03_JPRB,2.1093E-03_JPRB,1.0159E-03_JPRB/)
KBO( :, 2,42, 9) = (/&
&4.8758E-03_JPRB,5.4116E-03_JPRB,4.4469E-03_JPRB,2.9930E-03_JPRB,1.2910E-03_JPRB/)
KBO( :, 3,42, 9) = (/&
&6.8765E-03_JPRB,7.5957E-03_JPRB,6.2240E-03_JPRB,4.1675E-03_JPRB,1.6231E-03_JPRB/)
KBO( :, 4,42, 9) = (/&
&9.4703E-03_JPRB,1.0449E-02_JPRB,8.5426E-03_JPRB,5.6988E-03_JPRB,2.0195E-03_JPRB/)
KBO( :, 5,42, 9) = (/&
&1.2789E-02_JPRB,1.4133E-02_JPRB,1.1527E-02_JPRB,7.6610E-03_JPRB,2.4891E-03_JPRB/)
KBO( :, 1,43, 9) = (/&
&2.6545E-03_JPRB,2.9817E-03_JPRB,2.4611E-03_JPRB,1.6672E-03_JPRB,7.8914E-04_JPRB/)
KBO( :, 2,43, 9) = (/&
&3.9072E-03_JPRB,4.3601E-03_JPRB,3.5785E-03_JPRB,2.4026E-03_JPRB,1.0130E-03_JPRB/)
KBO( :, 3,43, 9) = (/&
&5.5970E-03_JPRB,6.2146E-03_JPRB,5.0833E-03_JPRB,3.3914E-03_JPRB,1.2871E-03_JPRB/)
KBO( :, 4,43, 9) = (/&
&7.8170E-03_JPRB,8.6680E-03_JPRB,7.0728E-03_JPRB,4.6984E-03_JPRB,1.6175E-03_JPRB/)
KBO( :, 5,43, 9) = (/&
&1.0695E-02_JPRB,1.1876E-02_JPRB,9.6670E-03_JPRB,6.3964E-03_JPRB,2.0136E-03_JPRB/)
KBO( :, 1,44, 9) = (/&
&2.0599E-03_JPRB,2.3264E-03_JPRB,1.9189E-03_JPRB,1.2982E-03_JPRB,6.1043E-04_JPRB/)
KBO( :, 2,44, 9) = (/&
&3.0865E-03_JPRB,3.4632E-03_JPRB,2.8398E-03_JPRB,1.9029E-03_JPRB,7.9160E-04_JPRB/)
KBO( :, 3,44, 9) = (/&
&4.4945E-03_JPRB,5.0200E-03_JPRB,4.1009E-03_JPRB,2.7282E-03_JPRB,1.0166E-03_JPRB/)
KBO( :, 4,44, 9) = (/&
&6.3771E-03_JPRB,7.1092E-03_JPRB,5.7918E-03_JPRB,3.8324E-03_JPRB,1.2916E-03_JPRB/)
KBO( :, 5,44, 9) = (/&
&8.8507E-03_JPRB,9.8816E-03_JPRB,8.0271E-03_JPRB,5.2885E-03_JPRB,1.6254E-03_JPRB/)
KBO( :, 1,45, 9) = (/&
&1.5883E-03_JPRB,1.8029E-03_JPRB,1.4862E-03_JPRB,1.0041E-03_JPRB,4.6915E-04_JPRB/)
KBO( :, 2,45, 9) = (/&
&2.4237E-03_JPRB,2.7348E-03_JPRB,2.2402E-03_JPRB,1.4983E-03_JPRB,6.1463E-04_JPRB/)
KBO( :, 3,45, 9) = (/&
&3.5915E-03_JPRB,4.0353E-03_JPRB,3.2920E-03_JPRB,2.1847E-03_JPRB,7.9813E-04_JPRB/)
KBO( :, 4,45, 9) = (/&
&5.1787E-03_JPRB,5.8074E-03_JPRB,4.7242E-03_JPRB,3.1158E-03_JPRB,1.0255E-03_JPRB/)
KBO( :, 5,45, 9) = (/&
&7.2977E-03_JPRB,8.1949E-03_JPRB,6.6455E-03_JPRB,4.3597E-03_JPRB,1.3052E-03_JPRB/)
KBO( :, 1,46, 9) = (/&
&1.2050E-03_JPRB,1.3752E-03_JPRB,1.1327E-03_JPRB,7.6415E-04_JPRB,3.5825E-04_JPRB/)
KBO( :, 2,46, 9) = (/&
&1.8745E-03_JPRB,2.1271E-03_JPRB,1.7406E-03_JPRB,1.1623E-03_JPRB,4.7455E-04_JPRB/)
KBO( :, 3,46, 9) = (/&
&2.8292E-03_JPRB,3.1990E-03_JPRB,2.6058E-03_JPRB,1.7261E-03_JPRB,6.2280E-04_JPRB/)
KBO( :, 4,46, 9) = (/&
&4.1523E-03_JPRB,4.6867E-03_JPRB,3.8068E-03_JPRB,2.5043E-03_JPRB,8.0997E-04_JPRB/)
KBO( :, 5,46, 9) = (/&
&5.9484E-03_JPRB,6.7211E-03_JPRB,5.4412E-03_JPRB,3.5566E-03_JPRB,1.0425E-03_JPRB/)
KBO( :, 1,47, 9) = (/&
&8.9059E-04_JPRB,1.0221E-03_JPRB,8.4076E-04_JPRB,5.6652E-04_JPRB,2.7270E-04_JPRB/)
KBO( :, 2,47, 9) = (/&
&1.4154E-03_JPRB,1.6142E-03_JPRB,1.3191E-03_JPRB,8.8003E-04_JPRB,3.6578E-04_JPRB/)
KBO( :, 3,47, 9) = (/&
&2.1790E-03_JPRB,2.4785E-03_JPRB,2.0162E-03_JPRB,1.3331E-03_JPRB,4.8487E-04_JPRB/)
KBO( :, 4,47, 9) = (/&
&3.2603E-03_JPRB,3.7035E-03_JPRB,3.0033E-03_JPRB,1.9711E-03_JPRB,6.3790E-04_JPRB/)
KBO( :, 5,47, 9) = (/&
&4.7543E-03_JPRB,5.4065E-03_JPRB,4.3698E-03_JPRB,2.8478E-03_JPRB,8.3079E-04_JPRB/)
KBO( :, 1,48, 9) = (/&
&6.5137E-04_JPRB,7.5160E-04_JPRB,6.1768E-04_JPRB,4.1559E-04_JPRB,2.0605E-04_JPRB/)
KBO( :, 2,48, 9) = (/&
&1.0584E-03_JPRB,1.2128E-03_JPRB,9.8996E-04_JPRB,6.6009E-04_JPRB,2.8014E-04_JPRB/)
KBO( :, 3,48, 9) = (/&
&1.6631E-03_JPRB,1.9026E-03_JPRB,1.5461E-03_JPRB,1.0205E-03_JPRB,3.7581E-04_JPRB/)
KBO( :, 4,48, 9) = (/&
&2.5384E-03_JPRB,2.9025E-03_JPRB,2.3504E-03_JPRB,1.5394E-03_JPRB,4.9967E-04_JPRB/)
KBO( :, 5,48, 9) = (/&
&3.7716E-03_JPRB,4.3191E-03_JPRB,3.4853E-03_JPRB,2.2659E-03_JPRB,6.5826E-04_JPRB/)
KBO( :, 1,49, 9) = (/&
&4.7074E-04_JPRB,5.4614E-04_JPRB,4.4842E-04_JPRB,3.0149E-04_JPRB,1.5387E-04_JPRB/)
KBO( :, 2,49, 9) = (/&
&7.8312E-04_JPRB,9.0147E-04_JPRB,7.3522E-04_JPRB,4.8971E-04_JPRB,2.1293E-04_JPRB/)
KBO( :, 3,49, 9) = (/&
&1.2566E-03_JPRB,1.4457E-03_JPRB,1.1738E-03_JPRB,7.7341E-04_JPRB,2.8949E-04_JPRB/)
KBO( :, 4,49, 9) = (/&
&1.9577E-03_JPRB,2.2532E-03_JPRB,1.8228E-03_JPRB,1.1917E-03_JPRB,3.8929E-04_JPRB/)
KBO( :, 5,49, 9) = (/&
&2.9665E-03_JPRB,3.4229E-03_JPRB,2.7586E-03_JPRB,1.7902E-03_JPRB,5.1846E-04_JPRB/)
KBO( :, 1,50, 9) = (/&
&3.4213E-04_JPRB,3.9935E-04_JPRB,3.2746E-04_JPRB,2.1988E-04_JPRB,1.1674E-04_JPRB/)
KBO( :, 2,50, 9) = (/&
&5.8343E-04_JPRB,6.7437E-04_JPRB,5.4936E-04_JPRB,3.6511E-04_JPRB,1.6480E-04_JPRB/)
KBO( :, 3,50, 9) = (/&
&9.5650E-04_JPRB,1.1046E-03_JPRB,8.9539E-04_JPRB,5.8873E-04_JPRB,2.2733E-04_JPRB/)
KBO( :, 4,50, 9) = (/&
&1.5196E-03_JPRB,1.7582E-03_JPRB,1.4207E-03_JPRB,9.2622E-04_JPRB,3.0916E-04_JPRB/)
KBO( :, 5,50, 9) = (/&
&2.3472E-03_JPRB,2.7261E-03_JPRB,2.1933E-03_JPRB,1.4203E-03_JPRB,4.1592E-04_JPRB/)
KBO( :, 1,51, 9) = (/&
&2.4775E-04_JPRB,2.9121E-04_JPRB,2.3870E-04_JPRB,1.5996E-04_JPRB,8.8877E-05_JPRB/)
KBO( :, 2,51, 9) = (/&
&4.3433E-04_JPRB,5.0395E-04_JPRB,4.0996E-04_JPRB,2.7183E-04_JPRB,1.2827E-04_JPRB/)
KBO( :, 3,51, 9) = (/&
&7.2809E-04_JPRB,8.4314E-04_JPRB,6.8222E-04_JPRB,4.4757E-04_JPRB,1.8017E-04_JPRB/)
KBO( :, 4,51, 9) = (/&
&1.1797E-03_JPRB,1.3708E-03_JPRB,1.1057E-03_JPRB,7.1871E-04_JPRB,2.4785E-04_JPRB/)
KBO( :, 5,51, 9) = (/&
&1.8569E-03_JPRB,2.1693E-03_JPRB,1.7420E-03_JPRB,1.1250E-03_JPRB,3.3679E-04_JPRB/)
KBO( :, 1,52, 9) = (/&
&1.7722E-04_JPRB,2.0977E-04_JPRB,1.7188E-04_JPRB,1.1517E-04_JPRB,6.6934E-05_JPRB/)
KBO( :, 2,52, 9) = (/&
&3.1988E-04_JPRB,3.7329E-04_JPRB,3.0314E-04_JPRB,2.0061E-04_JPRB,9.9021E-05_JPRB/)
KBO( :, 3,52, 9) = (/&
&5.4977E-04_JPRB,6.3853E-04_JPRB,5.1539E-04_JPRB,3.3762E-04_JPRB,1.4208E-04_JPRB/)
KBO( :, 4,52, 9) = (/&
&9.0908E-04_JPRB,1.0602E-03_JPRB,8.5370E-04_JPRB,5.5342E-04_JPRB,1.9834E-04_JPRB/)
KBO( :, 5,52, 9) = (/&
&1.4584E-03_JPRB,1.7130E-03_JPRB,1.3740E-03_JPRB,8.8469E-04_JPRB,2.7257E-04_JPRB/)
KBO( :, 1,53, 9) = (/&
&1.2486E-04_JPRB,1.4876E-04_JPRB,1.2192E-04_JPRB,8.1756E-05_JPRB,4.9810E-05_JPRB/)
KBO( :, 2,53, 9) = (/&
&2.3236E-04_JPRB,2.7326E-04_JPRB,2.2175E-04_JPRB,1.4647E-04_JPRB,7.5549E-05_JPRB/)
KBO( :, 3,53, 9) = (/&
&4.1092E-04_JPRB,4.7878E-04_JPRB,3.8566E-04_JPRB,2.5219E-04_JPRB,1.1108E-04_JPRB/)
KBO( :, 4,53, 9) = (/&
&6.9449E-04_JPRB,8.1233E-04_JPRB,6.5288E-04_JPRB,4.2235E-04_JPRB,1.5818E-04_JPRB/)
KBO( :, 5,53, 9) = (/&
&1.1362E-03_JPRB,1.3415E-03_JPRB,1.0746E-03_JPRB,6.9016E-04_JPRB,2.1993E-04_JPRB/)
KBO( :, 1,54, 9) = (/&
&8.9225E-05_JPRB,1.0698E-04_JPRB,8.7651E-05_JPRB,5.8813E-05_JPRB,3.8030E-05_JPRB/)
KBO( :, 2,54, 9) = (/&
&1.7137E-04_JPRB,2.0293E-04_JPRB,1.6456E-04_JPRB,1.0850E-04_JPRB,5.9001E-05_JPRB/)
KBO( :, 3,54, 9) = (/&
&3.1189E-04_JPRB,3.6460E-04_JPRB,2.9303E-04_JPRB,1.9101E-04_JPRB,8.8833E-05_JPRB/)
KBO( :, 4,54, 9) = (/&
&5.3932E-04_JPRB,6.3180E-04_JPRB,5.0597E-04_JPRB,3.2631E-04_JPRB,1.2913E-04_JPRB/)
KBO( :, 5,54, 9) = (/&
&8.9911E-04_JPRB,1.0637E-03_JPRB,8.5017E-04_JPRB,5.4403E-04_JPRB,1.8204E-04_JPRB/)
KBO( :, 1,55, 9) = (/&
&6.3909E-05_JPRB,7.7058E-05_JPRB,6.3103E-05_JPRB,4.2365E-05_JPRB,2.9408E-05_JPRB/)
KBO( :, 2,55, 9) = (/&
&1.2694E-04_JPRB,1.5118E-04_JPRB,1.2247E-04_JPRB,8.0640E-05_JPRB,4.6546E-05_JPRB/)
KBO( :, 3,55, 9) = (/&
&2.3779E-04_JPRB,2.7922E-04_JPRB,2.2392E-04_JPRB,1.4533E-04_JPRB,7.1755E-05_JPRB/)
KBO( :, 4,55, 9) = (/&
&4.2152E-04_JPRB,4.9417E-04_JPRB,3.9420E-04_JPRB,2.5317E-04_JPRB,1.0664E-04_JPRB/)
KBO( :, 5,55, 9) = (/&
&7.1633E-04_JPRB,8.4754E-04_JPRB,6.7522E-04_JPRB,4.3025E-04_JPRB,1.5287E-04_JPRB/)
KBO( :, 1,56, 9) = (/&
&4.5238E-05_JPRB,5.4873E-05_JPRB,4.4919E-05_JPRB,3.0179E-05_JPRB,2.2620E-05_JPRB/)
KBO( :, 2,56, 9) = (/&
&9.3046E-05_JPRB,1.1152E-04_JPRB,9.0251E-05_JPRB,5.9375E-05_JPRB,3.6523E-05_JPRB/)
KBO( :, 3,56, 9) = (/&
&1.7973E-04_JPRB,2.1224E-04_JPRB,1.6993E-04_JPRB,1.0998E-04_JPRB,5.7678E-05_JPRB/)
KBO( :, 4,56, 9) = (/&
&3.2753E-04_JPRB,3.8449E-04_JPRB,3.0571E-04_JPRB,1.9550E-04_JPRB,8.7776E-05_JPRB/)
KBO( :, 5,56, 9) = (/&
&5.6860E-04_JPRB,6.7252E-04_JPRB,5.3373E-04_JPRB,3.3864E-04_JPRB,1.2833E-04_JPRB/)
KBO( :, 1,57, 9) = (/&
&3.1565E-05_JPRB,3.8561E-05_JPRB,3.1572E-05_JPRB,2.1236E-05_JPRB,1.7319E-05_JPRB/)
KBO( :, 2,57, 9) = (/&
&6.7437E-05_JPRB,8.1368E-05_JPRB,6.5785E-05_JPRB,4.3278E-05_JPRB,2.8513E-05_JPRB/)
KBO( :, 3,57, 9) = (/&
&1.3453E-04_JPRB,1.5983E-04_JPRB,1.2788E-04_JPRB,8.2634E-05_JPRB,4.6105E-05_JPRB/)
KBO( :, 4,57, 9) = (/&
&2.5265E-04_JPRB,2.9731E-04_JPRB,2.3573E-04_JPRB,1.5020E-04_JPRB,7.1946E-05_JPRB/)
KBO( :, 5,57, 9) = (/&
&4.4894E-04_JPRB,5.3119E-04_JPRB,4.1979E-04_JPRB,2.6517E-04_JPRB,1.0766E-04_JPRB/)
KBO( :, 1,58, 9) = (/&
&2.2075E-05_JPRB,2.7134E-05_JPRB,2.2226E-05_JPRB,1.4971E-05_JPRB,1.3364E-05_JPRB/)
KBO( :, 2,58, 9) = (/&
&4.8978E-05_JPRB,5.9454E-05_JPRB,4.8051E-05_JPRB,3.1593E-05_JPRB,2.2406E-05_JPRB/)
KBO( :, 3,58, 9) = (/&
&1.0101E-04_JPRB,1.2083E-04_JPRB,9.6543E-05_JPRB,6.2301E-05_JPRB,3.7078E-05_JPRB/)
KBO( :, 4,58, 9) = (/&
&1.9559E-04_JPRB,2.3110E-04_JPRB,1.8274E-04_JPRB,1.1601E-04_JPRB,5.9357E-05_JPRB/)
KBO( :, 5,58, 9) = (/&
&3.5639E-04_JPRB,4.2210E-04_JPRB,3.3215E-04_JPRB,2.0879E-04_JPRB,9.0999E-05_JPRB/)
KBO( :, 1,59, 9) = (/&
&1.8162E-05_JPRB,2.2362E-05_JPRB,1.8260E-05_JPRB,1.2253E-05_JPRB,1.1708E-05_JPRB/)
KBO( :, 2,59, 9) = (/&
&4.1323E-05_JPRB,5.0285E-05_JPRB,4.0483E-05_JPRB,2.6494E-05_JPRB,1.9897E-05_JPRB/)
KBO( :, 3,59, 9) = (/&
&8.7123E-05_JPRB,1.0455E-04_JPRB,8.3213E-05_JPRB,5.3390E-05_JPRB,3.3400E-05_JPRB/)
KBO( :, 4,59, 9) = (/&
&1.7214E-04_JPRB,2.0391E-04_JPRB,1.6047E-04_JPRB,1.0123E-04_JPRB,5.4263E-05_JPRB/)
KBO( :, 5,59, 9) = (/&
&3.1897E-04_JPRB,3.7825E-04_JPRB,2.9606E-04_JPRB,1.8480E-04_JPRB,8.4393E-05_JPRB/)
KBO( :, 1,13,10) = (/&
&2.7341E-01_JPRB,2.7526E-01_JPRB,2.5183E-01_JPRB,1.9261E-01_JPRB,1.4210E+00_JPRB/)
KBO( :, 2,13,10) = (/&
&3.8641E-01_JPRB,3.8931E-01_JPRB,3.5500E-01_JPRB,2.7363E-01_JPRB,1.5250E+00_JPRB/)
KBO( :, 3,13,10) = (/&
&5.2101E-01_JPRB,5.2751E-01_JPRB,4.7841E-01_JPRB,3.7012E-01_JPRB,1.6242E+00_JPRB/)
KBO( :, 4,13,10) = (/&
&6.7807E-01_JPRB,6.8631E-01_JPRB,6.2447E-01_JPRB,4.8162E-01_JPRB,1.7236E+00_JPRB/)
KBO( :, 5,13,10) = (/&
&8.5732E-01_JPRB,8.6502E-01_JPRB,7.8632E-01_JPRB,6.0788E-01_JPRB,1.8353E+00_JPRB/)
KBO( :, 1,14,10) = (/&
&2.6100E-01_JPRB,2.7217E-01_JPRB,2.4857E-01_JPRB,1.9099E-01_JPRB,1.3096E+00_JPRB/)
KBO( :, 2,14,10) = (/&
&3.6662E-01_JPRB,3.8321E-01_JPRB,3.4838E-01_JPRB,2.6817E-01_JPRB,1.4048E+00_JPRB/)
KBO( :, 3,14,10) = (/&
&4.9302E-01_JPRB,5.1421E-01_JPRB,4.6962E-01_JPRB,3.6021E-01_JPRB,1.4986E+00_JPRB/)
KBO( :, 4,14,10) = (/&
&6.4068E-01_JPRB,6.6503E-01_JPRB,6.0806E-01_JPRB,4.6655E-01_JPRB,1.6008E+00_JPRB/)
KBO( :, 5,14,10) = (/&
&8.0594E-01_JPRB,8.3870E-01_JPRB,7.6286E-01_JPRB,5.8739E-01_JPRB,1.6996E+00_JPRB/)
KBO( :, 1,15,10) = (/&
&2.4538E-01_JPRB,2.6450E-01_JPRB,2.4065E-01_JPRB,1.8544E-01_JPRB,1.0991E+00_JPRB/)
KBO( :, 2,15,10) = (/&
&3.4290E-01_JPRB,3.6880E-01_JPRB,3.3714E-01_JPRB,2.5768E-01_JPRB,1.1807E+00_JPRB/)
KBO( :, 3,15,10) = (/&
&4.6008E-01_JPRB,4.9212E-01_JPRB,4.5111E-01_JPRB,3.4351E-01_JPRB,1.2655E+00_JPRB/)
KBO( :, 4,15,10) = (/&
&5.9510E-01_JPRB,6.3591E-01_JPRB,5.8042E-01_JPRB,4.4347E-01_JPRB,1.3538E+00_JPRB/)
KBO( :, 5,15,10) = (/&
&7.4431E-01_JPRB,7.9818E-01_JPRB,7.2810E-01_JPRB,5.5870E-01_JPRB,1.4415E+00_JPRB/)
KBO( :, 1,16,10) = (/&
&2.2814E-01_JPRB,2.5112E-01_JPRB,2.2894E-01_JPRB,1.7604E-01_JPRB,8.6918E-01_JPRB/)
KBO( :, 2,16,10) = (/&
&3.1740E-01_JPRB,3.4815E-01_JPRB,3.1813E-01_JPRB,2.4321E-01_JPRB,9.3794E-01_JPRB/)
KBO( :, 3,16,10) = (/&
&4.2406E-01_JPRB,4.6410E-01_JPRB,4.2260E-01_JPRB,3.2211E-01_JPRB,1.0122E+00_JPRB/)
KBO( :, 4,16,10) = (/&
&5.4520E-01_JPRB,5.9870E-01_JPRB,5.4328E-01_JPRB,4.1424E-01_JPRB,1.0849E+00_JPRB/)
KBO( :, 5,16,10) = (/&
&6.8053E-01_JPRB,7.4608E-01_JPRB,6.8074E-01_JPRB,5.2205E-01_JPRB,1.1616E+00_JPRB/)
KBO( :, 1,17,10) = (/&
&2.0942E-01_JPRB,2.3428E-01_JPRB,2.1300E-01_JPRB,1.6357E-01_JPRB,6.8856E-01_JPRB/)
KBO( :, 2,17,10) = (/&
&2.9028E-01_JPRB,3.2402E-01_JPRB,2.9334E-01_JPRB,2.2459E-01_JPRB,7.5316E-01_JPRB/)
KBO( :, 3,17,10) = (/&
&3.8521E-01_JPRB,4.3154E-01_JPRB,3.8848E-01_JPRB,2.9660E-01_JPRB,8.1712E-01_JPRB/)
KBO( :, 4,17,10) = (/&
&4.9386E-01_JPRB,5.5280E-01_JPRB,4.9908E-01_JPRB,3.8197E-01_JPRB,8.8331E-01_JPRB/)
KBO( :, 5,17,10) = (/&
&6.1488E-01_JPRB,6.8821E-01_JPRB,6.2452E-01_JPRB,4.7879E-01_JPRB,9.5857E-01_JPRB/)
KBO( :, 1,18,10) = (/&
&1.9063E-01_JPRB,2.1561E-01_JPRB,1.9503E-01_JPRB,1.4897E-01_JPRB,5.8262E-01_JPRB/)
KBO( :, 2,18,10) = (/&
&2.6234E-01_JPRB,2.9815E-01_JPRB,2.6727E-01_JPRB,2.0340E-01_JPRB,6.4437E-01_JPRB/)
KBO( :, 3,18,10) = (/&
&3.4666E-01_JPRB,3.9448E-01_JPRB,3.5278E-01_JPRB,2.6945E-01_JPRB,7.0773E-01_JPRB/)
KBO( :, 4,18,10) = (/&
&4.4310E-01_JPRB,5.0370E-01_JPRB,4.5197E-01_JPRB,3.4624E-01_JPRB,7.7610E-01_JPRB/)
KBO( :, 5,18,10) = (/&
&5.4979E-01_JPRB,6.2640E-01_JPRB,5.6607E-01_JPRB,4.3269E-01_JPRB,8.4498E-01_JPRB/)
KBO( :, 1,19,10) = (/&
&1.7161E-01_JPRB,1.9659E-01_JPRB,1.7592E-01_JPRB,1.3400E-01_JPRB,5.2315E-01_JPRB/)
KBO( :, 2,19,10) = (/&
&2.3489E-01_JPRB,2.7003E-01_JPRB,2.4068E-01_JPRB,1.8320E-01_JPRB,5.8488E-01_JPRB/)
KBO( :, 3,19,10) = (/&
&3.0942E-01_JPRB,3.5576E-01_JPRB,3.1712E-01_JPRB,2.4210E-01_JPRB,6.4789E-01_JPRB/)
KBO( :, 4,19,10) = (/&
&3.9389E-01_JPRB,4.5374E-01_JPRB,4.0629E-01_JPRB,3.0999E-01_JPRB,7.1351E-01_JPRB/)
KBO( :, 5,19,10) = (/&
&4.8891E-01_JPRB,5.6402E-01_JPRB,5.0679E-01_JPRB,3.8613E-01_JPRB,7.7670E-01_JPRB/)
KBO( :, 1,20,10) = (/&
&1.5436E-01_JPRB,1.7849E-01_JPRB,1.5835E-01_JPRB,1.2054E-01_JPRB,4.8122E-01_JPRB/)
KBO( :, 2,20,10) = (/&
&2.1037E-01_JPRB,2.4329E-01_JPRB,2.1594E-01_JPRB,1.6475E-01_JPRB,5.4083E-01_JPRB/)
KBO( :, 3,20,10) = (/&
&2.7588E-01_JPRB,3.1923E-01_JPRB,2.8475E-01_JPRB,2.1683E-01_JPRB,6.0229E-01_JPRB/)
KBO( :, 4,20,10) = (/&
&3.5179E-01_JPRB,4.0673E-01_JPRB,3.6356E-01_JPRB,2.7647E-01_JPRB,6.6389E-01_JPRB/)
KBO( :, 5,20,10) = (/&
&4.3944E-01_JPRB,5.0591E-01_JPRB,4.5161E-01_JPRB,3.4309E-01_JPRB,7.2588E-01_JPRB/)
KBO( :, 1,21,10) = (/&
&1.3931E-01_JPRB,1.6061E-01_JPRB,1.4210E-01_JPRB,1.0800E-01_JPRB,4.4082E-01_JPRB/)
KBO( :, 2,21,10) = (/&
&1.8903E-01_JPRB,2.1792E-01_JPRB,1.9361E-01_JPRB,1.4691E-01_JPRB,4.9685E-01_JPRB/)
KBO( :, 3,21,10) = (/&
&2.4836E-01_JPRB,2.8494E-01_JPRB,2.5423E-01_JPRB,1.9232E-01_JPRB,5.5604E-01_JPRB/)
KBO( :, 4,21,10) = (/&
&3.1855E-01_JPRB,3.6313E-01_JPRB,3.2325E-01_JPRB,2.4463E-01_JPRB,6.1543E-01_JPRB/)
KBO( :, 5,21,10) = (/&
&4.0034E-01_JPRB,4.5346E-01_JPRB,4.0071E-01_JPRB,3.0346E-01_JPRB,6.7562E-01_JPRB/)
KBO( :, 1,22,10) = (/&
&1.2853E-01_JPRB,1.4730E-01_JPRB,1.3012E-01_JPRB,9.8419E-02_JPRB,3.9506E-01_JPRB/)
KBO( :, 2,22,10) = (/&
&1.7432E-01_JPRB,1.9857E-01_JPRB,1.7621E-01_JPRB,1.3274E-01_JPRB,4.4910E-01_JPRB/)
KBO( :, 3,22,10) = (/&
&2.3012E-01_JPRB,2.5984E-01_JPRB,2.2960E-01_JPRB,1.7295E-01_JPRB,5.0505E-01_JPRB/)
KBO( :, 4,22,10) = (/&
&2.9716E-01_JPRB,3.3163E-01_JPRB,2.9126E-01_JPRB,2.1891E-01_JPRB,5.6304E-01_JPRB/)
KBO( :, 5,22,10) = (/&
&3.7733E-01_JPRB,4.1497E-01_JPRB,3.6137E-01_JPRB,2.7093E-01_JPRB,6.2241E-01_JPRB/)
KBO( :, 1,23,10) = (/&
&1.1881E-01_JPRB,1.3545E-01_JPRB,1.1944E-01_JPRB,8.9244E-02_JPRB,3.5223E-01_JPRB/)
KBO( :, 2,23,10) = (/&
&1.6173E-01_JPRB,1.8250E-01_JPRB,1.6019E-01_JPRB,1.1960E-01_JPRB,4.0380E-01_JPRB/)
KBO( :, 3,23,10) = (/&
&2.1531E-01_JPRB,2.3918E-01_JPRB,2.0828E-01_JPRB,1.5508E-01_JPRB,4.5685E-01_JPRB/)
KBO( :, 4,23,10) = (/&
&2.8111E-01_JPRB,3.0634E-01_JPRB,2.6433E-01_JPRB,1.9616E-01_JPRB,5.1050E-01_JPRB/)
KBO( :, 5,23,10) = (/&
&3.5862E-01_JPRB,3.8538E-01_JPRB,3.2913E-01_JPRB,2.4336E-01_JPRB,5.6512E-01_JPRB/)
KBO( :, 1,24,10) = (/&
&1.1051E-01_JPRB,1.2496E-01_JPRB,1.0957E-01_JPRB,8.1032E-02_JPRB,3.1062E-01_JPRB/)
KBO( :, 2,24,10) = (/&
&1.5172E-01_JPRB,1.6880E-01_JPRB,1.4660E-01_JPRB,1.0802E-01_JPRB,3.5601E-01_JPRB/)
KBO( :, 3,24,10) = (/&
&2.0376E-01_JPRB,2.2212E-01_JPRB,1.9093E-01_JPRB,1.3969E-01_JPRB,4.0151E-01_JPRB/)
KBO( :, 4,24,10) = (/&
&2.6595E-01_JPRB,2.8670E-01_JPRB,2.4290E-01_JPRB,1.7693E-01_JPRB,4.4655E-01_JPRB/)
KBO( :, 5,24,10) = (/&
&3.3711E-01_JPRB,3.6154E-01_JPRB,3.0421E-01_JPRB,2.2016E-01_JPRB,4.9307E-01_JPRB/)
KBO( :, 1,25,10) = (/&
&1.0420E-01_JPRB,1.1612E-01_JPRB,1.0071E-01_JPRB,7.3994E-02_JPRB,2.6769E-01_JPRB/)
KBO( :, 2,25,10) = (/&
&1.4379E-01_JPRB,1.5740E-01_JPRB,1.3501E-01_JPRB,9.8353E-02_JPRB,3.0486E-01_JPRB/)
KBO( :, 3,25,10) = (/&
&1.9217E-01_JPRB,2.0868E-01_JPRB,1.7650E-01_JPRB,1.2735E-01_JPRB,3.4236E-01_JPRB/)
KBO( :, 4,25,10) = (/&
&2.4870E-01_JPRB,2.6919E-01_JPRB,2.2634E-01_JPRB,1.6171E-01_JPRB,3.8148E-01_JPRB/)
KBO( :, 5,25,10) = (/&
&3.1377E-01_JPRB,3.3803E-01_JPRB,2.8442E-01_JPRB,2.0146E-01_JPRB,4.2272E-01_JPRB/)
KBO( :, 1,26,10) = (/&
&9.9675E-02_JPRB,1.0913E-01_JPRB,9.3389E-02_JPRB,6.8204E-02_JPRB,2.2702E-01_JPRB/)
KBO( :, 2,26,10) = (/&
&1.3608E-01_JPRB,1.4866E-01_JPRB,1.2587E-01_JPRB,9.0548E-02_JPRB,2.5831E-01_JPRB/)
KBO( :, 3,26,10) = (/&
&1.7987E-01_JPRB,1.9629E-01_JPRB,1.6531E-01_JPRB,1.1761E-01_JPRB,2.9077E-01_JPRB/)
KBO( :, 4,26,10) = (/&
&2.3141E-01_JPRB,2.5133E-01_JPRB,2.1184E-01_JPRB,1.5002E-01_JPRB,3.2521E-01_JPRB/)
KBO( :, 5,26,10) = (/&
&2.9168E-01_JPRB,3.1498E-01_JPRB,2.6568E-01_JPRB,1.8754E-01_JPRB,3.6164E-01_JPRB/)
KBO( :, 1,27,10) = (/&
&9.4961E-02_JPRB,1.0334E-01_JPRB,8.7374E-02_JPRB,6.3126E-02_JPRB,1.8683E-01_JPRB/)
KBO( :, 2,27,10) = (/&
&1.2783E-01_JPRB,1.3969E-01_JPRB,1.1790E-01_JPRB,8.4112E-02_JPRB,2.1332E-01_JPRB/)
KBO( :, 3,27,10) = (/&
&1.6762E-01_JPRB,1.8278E-01_JPRB,1.5442E-01_JPRB,1.0984E-01_JPRB,2.4142E-01_JPRB/)
KBO( :, 4,27,10) = (/&
&2.1518E-01_JPRB,2.3329E-01_JPRB,1.9719E-01_JPRB,1.3996E-01_JPRB,2.7159E-01_JPRB/)
KBO( :, 5,27,10) = (/&
&2.7088E-01_JPRB,2.9228E-01_JPRB,2.4666E-01_JPRB,1.7442E-01_JPRB,3.0352E-01_JPRB/)
KBO( :, 1,28,10) = (/&
&8.9894E-02_JPRB,9.7468E-02_JPRB,8.2177E-02_JPRB,5.8889E-02_JPRB,1.5060E-01_JPRB/)
KBO( :, 2,28,10) = (/&
&1.1988E-01_JPRB,1.3035E-01_JPRB,1.1000E-01_JPRB,7.8738E-02_JPRB,1.7287E-01_JPRB/)
KBO( :, 3,28,10) = (/&
&1.5649E-01_JPRB,1.6957E-01_JPRB,1.4329E-01_JPRB,1.0256E-01_JPRB,1.9707E-01_JPRB/)
KBO( :, 4,28,10) = (/&
&2.0046E-01_JPRB,2.1640E-01_JPRB,1.8266E-01_JPRB,1.3021E-01_JPRB,2.2305E-01_JPRB/)
KBO( :, 5,28,10) = (/&
&2.5209E-01_JPRB,2.7147E-01_JPRB,2.2856E-01_JPRB,1.6182E-01_JPRB,2.5048E-01_JPRB/)
KBO( :, 1,29,10) = (/&
&8.4975E-02_JPRB,9.1564E-02_JPRB,7.7119E-02_JPRB,5.5320E-02_JPRB,1.2031E-01_JPRB/)
KBO( :, 2,29,10) = (/&
&1.1279E-01_JPRB,1.2154E-01_JPRB,1.0248E-01_JPRB,7.3699E-02_JPRB,1.3921E-01_JPRB/)
KBO( :, 3,29,10) = (/&
&1.4673E-01_JPRB,1.5792E-01_JPRB,1.3309E-01_JPRB,9.5449E-02_JPRB,1.5984E-01_JPRB/)
KBO( :, 4,29,10) = (/&
&1.8741E-01_JPRB,2.0158E-01_JPRB,1.6951E-01_JPRB,1.2082E-01_JPRB,1.8203E-01_JPRB/)
KBO( :, 5,29,10) = (/&
&2.3506E-01_JPRB,2.5337E-01_JPRB,2.1224E-01_JPRB,1.5053E-01_JPRB,2.0549E-01_JPRB/)
KBO( :, 1,30,10) = (/&
&8.0540E-02_JPRB,8.5979E-02_JPRB,7.2248E-02_JPRB,5.1838E-02_JPRB,9.5257E-02_JPRB/)
KBO( :, 2,30,10) = (/&
&1.0659E-01_JPRB,1.1363E-01_JPRB,9.5542E-02_JPRB,6.8630E-02_JPRB,1.1116E-01_JPRB/)
KBO( :, 3,30,10) = (/&
&1.3811E-01_JPRB,1.4769E-01_JPRB,1.2398E-01_JPRB,8.8651E-02_JPRB,1.2851E-01_JPRB/)
KBO( :, 4,30,10) = (/&
&1.7576E-01_JPRB,1.8885E-01_JPRB,1.5795E-01_JPRB,1.1230E-01_JPRB,1.4704E-01_JPRB/)
KBO( :, 5,30,10) = (/&
&2.1968E-01_JPRB,2.3750E-01_JPRB,1.9778E-01_JPRB,1.4034E-01_JPRB,1.6746E-01_JPRB/)
KBO( :, 1,31,10) = (/&
&7.6568E-02_JPRB,8.1013E-02_JPRB,6.7877E-02_JPRB,4.8531E-02_JPRB,7.4566E-02_JPRB/)
KBO( :, 2,31,10) = (/&
&1.0109E-01_JPRB,1.0699E-01_JPRB,8.9628E-02_JPRB,6.3973E-02_JPRB,8.7642E-02_JPRB/)
KBO( :, 3,31,10) = (/&
&1.3062E-01_JPRB,1.3896E-01_JPRB,1.1618E-01_JPRB,8.2665E-02_JPRB,1.0209E-01_JPRB/)
KBO( :, 4,31,10) = (/&
&1.6550E-01_JPRB,1.7774E-01_JPRB,1.4814E-01_JPRB,1.0503E-01_JPRB,1.1802E-01_JPRB/)
KBO( :, 5,31,10) = (/&
&2.0675E-01_JPRB,2.2327E-01_JPRB,1.8555E-01_JPRB,1.3151E-01_JPRB,1.3544E-01_JPRB/)
KBO( :, 1,32,10) = (/&
&7.2888E-02_JPRB,7.6838E-02_JPRB,6.4126E-02_JPRB,4.5495E-02_JPRB,5.8817E-02_JPRB/)
KBO( :, 2,32,10) = (/&
&9.6267E-02_JPRB,1.0140E-01_JPRB,8.4579E-02_JPRB,5.9945E-02_JPRB,6.9773E-02_JPRB/)
KBO( :, 3,32,10) = (/&
&1.2398E-01_JPRB,1.3170E-01_JPRB,1.0960E-01_JPRB,7.7555E-02_JPRB,8.1997E-02_JPRB/)
KBO( :, 4,32,10) = (/&
&1.5682E-01_JPRB,1.6810E-01_JPRB,1.3960E-01_JPRB,9.8812E-02_JPRB,9.5528E-02_JPRB/)
KBO( :, 5,32,10) = (/&
&1.9594E-01_JPRB,2.1107E-01_JPRB,1.7505E-01_JPRB,1.2416E-01_JPRB,1.1090E-01_JPRB/)
KBO( :, 1,33,10) = (/&
&6.9635E-02_JPRB,7.3317E-02_JPRB,6.1010E-02_JPRB,4.2865E-02_JPRB,4.6660E-02_JPRB/)
KBO( :, 2,33,10) = (/&
&9.1701E-02_JPRB,9.6759E-02_JPRB,8.0326E-02_JPRB,5.6501E-02_JPRB,5.5833E-02_JPRB/)
KBO( :, 3,33,10) = (/&
&1.1801E-01_JPRB,1.2540E-01_JPRB,1.0406E-01_JPRB,7.3316E-02_JPRB,6.6138E-02_JPRB/)
KBO( :, 4,33,10) = (/&
&1.4953E-01_JPRB,1.5985E-01_JPRB,1.3238E-01_JPRB,9.3601E-02_JPRB,7.7808E-02_JPRB/)
KBO( :, 5,33,10) = (/&
&1.8727E-01_JPRB,2.0108E-01_JPRB,1.6621E-01_JPRB,1.1789E-01_JPRB,9.1029E-02_JPRB/)
KBO( :, 1,34,10) = (/&
&6.6051E-02_JPRB,6.9606E-02_JPRB,5.7793E-02_JPRB,4.0300E-02_JPRB,3.8390E-02_JPRB/)
KBO( :, 2,34,10) = (/&
&8.6850E-02_JPRB,9.2010E-02_JPRB,7.6104E-02_JPRB,5.3129E-02_JPRB,4.6300E-02_JPRB/)
KBO( :, 3,34,10) = (/&
&1.1190E-01_JPRB,1.1902E-01_JPRB,9.8376E-02_JPRB,6.9059E-02_JPRB,5.5243E-02_JPRB/)
KBO( :, 4,34,10) = (/&
&1.4227E-01_JPRB,1.5193E-01_JPRB,1.2534E-01_JPRB,8.8424E-02_JPRB,6.5503E-02_JPRB/)
KBO( :, 5,34,10) = (/&
&1.7893E-01_JPRB,1.9164E-01_JPRB,1.5780E-01_JPRB,1.1159E-01_JPRB,7.7108E-02_JPRB/)
KBO( :, 1,35,10) = (/&
&6.1061E-02_JPRB,6.4589E-02_JPRB,5.3472E-02_JPRB,3.7076E-02_JPRB,3.0936E-02_JPRB/)
KBO( :, 2,35,10) = (/&
&8.0413E-02_JPRB,8.5518E-02_JPRB,7.0631E-02_JPRB,4.9033E-02_JPRB,3.7630E-02_JPRB/)
KBO( :, 3,35,10) = (/&
&1.0418E-01_JPRB,1.1098E-01_JPRB,9.1376E-02_JPRB,6.3892E-02_JPRB,4.5348E-02_JPRB/)
KBO( :, 4,35,10) = (/&
&1.3326E-01_JPRB,1.4218E-01_JPRB,1.1684E-01_JPRB,8.2004E-02_JPRB,5.4177E-02_JPRB/)
KBO( :, 5,35,10) = (/&
&1.6818E-01_JPRB,1.8014E-01_JPRB,1.4791E-01_JPRB,1.0383E-01_JPRB,6.4352E-02_JPRB/)
KBO( :, 1,36,10) = (/&
&5.4859E-02_JPRB,5.8269E-02_JPRB,4.8182E-02_JPRB,3.3253E-02_JPRB,2.4204E-02_JPRB/)
KBO( :, 2,36,10) = (/&
&7.2626E-02_JPRB,7.7491E-02_JPRB,6.3949E-02_JPRB,4.4186E-02_JPRB,2.9747E-02_JPRB/)
KBO( :, 3,36,10) = (/&
&9.4867E-02_JPRB,1.0121E-01_JPRB,8.3126E-02_JPRB,5.7761E-02_JPRB,3.6183E-02_JPRB/)
KBO( :, 4,36,10) = (/&
&1.2215E-01_JPRB,1.3045E-01_JPRB,1.0693E-01_JPRB,7.4445E-02_JPRB,4.3693E-02_JPRB/)
KBO( :, 5,36,10) = (/&
&1.5514E-01_JPRB,1.6646E-01_JPRB,1.3613E-01_JPRB,9.4760E-02_JPRB,5.2444E-02_JPRB/)
KBO( :, 1,37,10) = (/&
&4.7230E-02_JPRB,5.0376E-02_JPRB,4.1606E-02_JPRB,2.8650E-02_JPRB,1.9576E-02_JPRB/)
KBO( :, 2,37,10) = (/&
&6.3162E-02_JPRB,6.7559E-02_JPRB,5.5737E-02_JPRB,3.8366E-02_JPRB,2.4307E-02_JPRB/)
KBO( :, 3,37,10) = (/&
&8.3382E-02_JPRB,8.9100E-02_JPRB,7.3096E-02_JPRB,5.0404E-02_JPRB,2.9845E-02_JPRB/)
KBO( :, 4,37,10) = (/&
&1.0831E-01_JPRB,1.1578E-01_JPRB,9.4747E-02_JPRB,6.5399E-02_JPRB,3.6334E-02_JPRB/)
KBO( :, 5,37,10) = (/&
&1.3872E-01_JPRB,1.4912E-01_JPRB,1.2153E-01_JPRB,8.3890E-02_JPRB,4.3970E-02_JPRB/)
KBO( :, 1,38,10) = (/&
&4.0594E-02_JPRB,4.3482E-02_JPRB,3.5882E-02_JPRB,2.4652E-02_JPRB,1.5796E-02_JPRB/)
KBO( :, 2,38,10) = (/&
&5.4893E-02_JPRB,5.8859E-02_JPRB,4.8535E-02_JPRB,3.3342E-02_JPRB,1.9838E-02_JPRB/)
KBO( :, 3,38,10) = (/&
&7.3270E-02_JPRB,7.8442E-02_JPRB,6.4299E-02_JPRB,4.4057E-02_JPRB,2.4587E-02_JPRB/)
KBO( :, 4,38,10) = (/&
&9.6131E-02_JPRB,1.0297E-01_JPRB,8.4062E-02_JPRB,5.7542E-02_JPRB,3.0194E-02_JPRB/)
KBO( :, 5,38,10) = (/&
&1.2425E-01_JPRB,1.3371E-01_JPRB,1.0871E-01_JPRB,7.4376E-02_JPRB,3.6826E-02_JPRB/)
KBO( :, 1,39,10) = (/&
&3.4960E-02_JPRB,3.7584E-02_JPRB,3.1001E-02_JPRB,2.1253E-02_JPRB,1.2659E-02_JPRB/)
KBO( :, 2,39,10) = (/&
&4.7796E-02_JPRB,5.1412E-02_JPRB,4.2333E-02_JPRB,2.9006E-02_JPRB,1.6073E-02_JPRB/)
KBO( :, 3,39,10) = (/&
&6.4510E-02_JPRB,6.9244E-02_JPRB,5.6690E-02_JPRB,3.8671E-02_JPRB,2.0130E-02_JPRB/)
KBO( :, 4,39,10) = (/&
&8.5561E-02_JPRB,9.1904E-02_JPRB,7.4800E-02_JPRB,5.0873E-02_JPRB,2.4941E-02_JPRB/)
KBO( :, 5,39,10) = (/&
&1.1163E-01_JPRB,1.2022E-01_JPRB,9.7628E-02_JPRB,6.6235E-02_JPRB,3.0668E-02_JPRB/)
KBO( :, 1,40,10) = (/&
&2.9268E-02_JPRB,3.1482E-02_JPRB,2.5935E-02_JPRB,1.7721E-02_JPRB,1.0217E-02_JPRB/)
KBO( :, 2,40,10) = (/&
&4.0459E-02_JPRB,4.3586E-02_JPRB,3.5852E-02_JPRB,2.4486E-02_JPRB,1.3110E-02_JPRB/)
KBO( :, 3,40,10) = (/&
&5.5229E-02_JPRB,5.9449E-02_JPRB,4.8588E-02_JPRB,3.3038E-02_JPRB,1.6586E-02_JPRB/)
KBO( :, 4,40,10) = (/&
&7.4117E-02_JPRB,7.9872E-02_JPRB,6.4885E-02_JPRB,4.3907E-02_JPRB,2.0725E-02_JPRB/)
KBO( :, 5,40,10) = (/&
&9.7865E-02_JPRB,1.0550E-01_JPRB,8.5568E-02_JPRB,5.7643E-02_JPRB,2.5662E-02_JPRB/)
KBO( :, 1,41,10) = (/&
&2.4397E-02_JPRB,2.6231E-02_JPRB,2.1586E-02_JPRB,1.4682E-02_JPRB,8.2353E-03_JPRB/)
KBO( :, 2,41,10) = (/&
&3.4139E-02_JPRB,3.6786E-02_JPRB,3.0230E-02_JPRB,2.0568E-02_JPRB,1.0674E-02_JPRB/)
KBO( :, 3,41,10) = (/&
&4.7106E-02_JPRB,5.0858E-02_JPRB,4.1459E-02_JPRB,2.8115E-02_JPRB,1.3635E-02_JPRB/)
KBO( :, 4,41,10) = (/&
&6.4000E-02_JPRB,6.9180E-02_JPRB,5.6062E-02_JPRB,3.7799E-02_JPRB,1.7204E-02_JPRB/)
KBO( :, 5,41,10) = (/&
&8.5517E-02_JPRB,9.2400E-02_JPRB,7.4782E-02_JPRB,5.0099E-02_JPRB,2.1450E-02_JPRB/)
KBO( :, 1,42,10) = (/&
&2.0268E-02_JPRB,2.1845E-02_JPRB,1.7956E-02_JPRB,1.2140E-02_JPRB,6.5991E-03_JPRB/)
KBO( :, 2,42,10) = (/&
&2.8789E-02_JPRB,3.1021E-02_JPRB,2.5467E-02_JPRB,1.7246E-02_JPRB,8.6477E-03_JPRB/)
KBO( :, 3,42,10) = (/&
&4.0194E-02_JPRB,4.3474E-02_JPRB,3.5363E-02_JPRB,2.3902E-02_JPRB,1.1154E-02_JPRB/)
KBO( :, 4,42,10) = (/&
&5.5258E-02_JPRB,5.9919E-02_JPRB,4.8429E-02_JPRB,3.2536E-02_JPRB,1.4210E-02_JPRB/)
KBO( :, 5,42,10) = (/&
&7.4696E-02_JPRB,8.0962E-02_JPRB,6.5393E-02_JPRB,4.3618E-02_JPRB,1.7849E-02_JPRB/)
KBO( :, 1,43,10) = (/&
&1.6426E-02_JPRB,1.7804E-02_JPRB,1.4613E-02_JPRB,9.8050E-03_JPRB,5.2617E-03_JPRB/)
KBO( :, 2,43,10) = (/&
&2.3747E-02_JPRB,2.5630E-02_JPRB,2.1011E-02_JPRB,1.4160E-02_JPRB,6.9847E-03_JPRB/)
KBO( :, 3,43,10) = (/&
&3.3653E-02_JPRB,3.6412E-02_JPRB,2.9592E-02_JPRB,1.9925E-02_JPRB,9.1040E-03_JPRB/)
KBO( :, 4,43,10) = (/&
&4.6868E-02_JPRB,5.0938E-02_JPRB,4.1108E-02_JPRB,2.7526E-02_JPRB,1.1710E-02_JPRB/)
KBO( :, 5,43,10) = (/&
&6.4129E-02_JPRB,6.9760E-02_JPRB,5.6238E-02_JPRB,3.7383E-02_JPRB,1.4823E-02_JPRB/)
KBO( :, 1,44,10) = (/&
&1.3100E-02_JPRB,1.4316E-02_JPRB,1.1742E-02_JPRB,7.8185E-03_JPRB,4.1731E-03_JPRB/)
KBO( :, 2,44,10) = (/&
&1.9306E-02_JPRB,2.0946E-02_JPRB,1.7130E-02_JPRB,1.1488E-02_JPRB,5.6253E-03_JPRB/)
KBO( :, 3,44,10) = (/&
&2.7839E-02_JPRB,3.0159E-02_JPRB,2.4497E-02_JPRB,1.6420E-02_JPRB,7.4177E-03_JPRB/)
KBO( :, 4,44,10) = (/&
&3.9351E-02_JPRB,4.2845E-02_JPRB,3.4542E-02_JPRB,2.3036E-02_JPRB,9.6323E-03_JPRB/)
KBO( :, 5,44,10) = (/&
&5.4545E-02_JPRB,5.9565E-02_JPRB,4.7916E-02_JPRB,3.1766E-02_JPRB,1.2297E-02_JPRB/)
KBO( :, 1,45,10) = (/&
&1.0365E-02_JPRB,1.1432E-02_JPRB,9.3767E-03_JPRB,6.2117E-03_JPRB,3.2839E-03_JPRB/)
KBO( :, 2,45,10) = (/&
&1.5589E-02_JPRB,1.7063E-02_JPRB,1.3930E-02_JPRB,9.2859E-03_JPRB,4.5005E-03_JPRB/)
KBO( :, 3,45,10) = (/&
&2.2910E-02_JPRB,2.4924E-02_JPRB,2.0227E-02_JPRB,1.3494E-02_JPRB,6.0165E-03_JPRB/)
KBO( :, 4,45,10) = (/&
&3.2938E-02_JPRB,3.5933E-02_JPRB,2.8944E-02_JPRB,1.9215E-02_JPRB,7.8901E-03_JPRB/)
KBO( :, 5,45,10) = (/&
&4.6288E-02_JPRB,5.0739E-02_JPRB,4.0755E-02_JPRB,2.6930E-02_JPRB,1.0163E-02_JPRB/)
KBO( :, 1,46,10) = (/&
&8.0611E-03_JPRB,8.9687E-03_JPRB,7.3616E-03_JPRB,4.8649E-03_JPRB,2.5630E-03_JPRB/)
KBO( :, 2,46,10) = (/&
&1.2384E-02_JPRB,1.3700E-02_JPRB,1.1187E-02_JPRB,7.4141E-03_JPRB,3.5736E-03_JPRB/)
KBO( :, 3,46,10) = (/&
&1.8589E-02_JPRB,2.0376E-02_JPRB,1.6514E-02_JPRB,1.0949E-02_JPRB,4.8546E-03_JPRB/)
KBO( :, 4,46,10) = (/&
&2.7228E-02_JPRB,2.9798E-02_JPRB,2.3986E-02_JPRB,1.5867E-02_JPRB,6.4395E-03_JPRB/)
KBO( :, 5,46,10) = (/&
&3.8907E-02_JPRB,4.2772E-02_JPRB,3.4328E-02_JPRB,2.2598E-02_JPRB,8.3793E-03_JPRB/)
KBO( :, 1,47,10) = (/&
&6.0942E-03_JPRB,6.8373E-03_JPRB,5.6151E-03_JPRB,3.7108E-03_JPRB,1.9874E-03_JPRB/)
KBO( :, 2,47,10) = (/&
&9.5830E-03_JPRB,1.0720E-02_JPRB,8.7687E-03_JPRB,5.7830E-03_JPRB,2.8149E-03_JPRB/)
KBO( :, 3,47,10) = (/&
&1.4719E-02_JPRB,1.6286E-02_JPRB,1.3206E-02_JPRB,8.7082E-03_JPRB,3.8989E-03_JPRB/)
KBO( :, 4,47,10) = (/&
&2.2034E-02_JPRB,2.4248E-02_JPRB,1.9496E-02_JPRB,1.2839E-02_JPRB,5.2464E-03_JPRB/)
KBO( :, 5,47,10) = (/&
&3.2068E-02_JPRB,3.5385E-02_JPRB,2.8366E-02_JPRB,1.8611E-02_JPRB,6.9087E-03_JPRB/)
KBO( :, 1,48,10) = (/&
&4.5510E-03_JPRB,5.1515E-03_JPRB,4.2286E-03_JPRB,2.7938E-03_JPRB,1.5324E-03_JPRB/)
KBO( :, 2,48,10) = (/&
&7.3293E-03_JPRB,8.3022E-03_JPRB,6.7958E-03_JPRB,4.4708E-03_JPRB,2.2018E-03_JPRB/)
KBO( :, 3,48,10) = (/&
&1.1532E-02_JPRB,1.2909E-02_JPRB,1.0485E-02_JPRB,6.8896E-03_JPRB,3.1032E-03_JPRB/)
KBO( :, 4,48,10) = (/&
&1.7669E-02_JPRB,1.9619E-02_JPRB,1.5768E-02_JPRB,1.0334E-02_JPRB,4.2526E-03_JPRB/)
KBO( :, 5,48,10) = (/&
&2.6263E-02_JPRB,2.9134E-02_JPRB,2.3325E-02_JPRB,1.5244E-02_JPRB,5.6768E-03_JPRB/)
KBO( :, 1,49,10) = (/&
&3.3560E-03_JPRB,3.8327E-03_JPRB,3.1391E-03_JPRB,2.0743E-03_JPRB,1.1802E-03_JPRB/)
KBO( :, 2,49,10) = (/&
&5.5342E-03_JPRB,6.3542E-03_JPRB,5.1981E-03_JPRB,3.4211E-03_JPRB,1.7096E-03_JPRB/)
KBO( :, 3,49,10) = (/&
&8.9294E-03_JPRB,1.0143E-02_JPRB,8.2468E-03_JPRB,5.4196E-03_JPRB,2.4470E-03_JPRB/)
KBO( :, 4,49,10) = (/&
&1.4024E-02_JPRB,1.5765E-02_JPRB,1.2684E-02_JPRB,8.2734E-03_JPRB,3.4129E-03_JPRB/)
KBO( :, 5,49,10) = (/&
&2.1352E-02_JPRB,2.3866E-02_JPRB,1.9075E-02_JPRB,1.2411E-02_JPRB,4.6279E-03_JPRB/)
KBO( :, 1,50,10) = (/&
&2.4929E-03_JPRB,2.8632E-03_JPRB,2.3379E-03_JPRB,1.5440E-03_JPRB,9.3225E-04_JPRB/)
KBO( :, 2,50,10) = (/&
&4.2029E-03_JPRB,4.8752E-03_JPRB,3.9805E-03_JPRB,2.6198E-03_JPRB,1.3576E-03_JPRB/)
KBO( :, 3,50,10) = (/&
&6.9325E-03_JPRB,7.9925E-03_JPRB,6.4974E-03_JPRB,4.2674E-03_JPRB,1.9613E-03_JPRB/)
KBO( :, 4,50,10) = (/&
&1.1158E-02_JPRB,1.2709E-02_JPRB,1.0229E-02_JPRB,6.6644E-03_JPRB,2.7832E-03_JPRB/)
KBO( :, 5,50,10) = (/&
&1.7403E-02_JPRB,1.9642E-02_JPRB,1.5691E-02_JPRB,1.0155E-02_JPRB,3.8333E-03_JPRB/)
KBO( :, 1,51,10) = (/&
&1.8532E-03_JPRB,2.1364E-03_JPRB,1.7376E-03_JPRB,1.1454E-03_JPRB,7.4878E-04_JPRB/)
KBO( :, 2,51,10) = (/&
&3.1888E-03_JPRB,3.7291E-03_JPRB,3.0357E-03_JPRB,1.9945E-03_JPRB,1.0922E-03_JPRB/)
KBO( :, 3,51,10) = (/&
&5.3638E-03_JPRB,6.2780E-03_JPRB,5.0968E-03_JPRB,3.3419E-03_JPRB,1.5858E-03_JPRB/)
KBO( :, 4,51,10) = (/&
&8.8501E-03_JPRB,1.0219E-02_JPRB,8.2277E-03_JPRB,5.3639E-03_JPRB,2.2832E-03_JPRB/)
KBO( :, 5,51,10) = (/&
&1.4149E-02_JPRB,1.6146E-02_JPRB,1.2912E-02_JPRB,8.3171E-03_JPRB,3.2000E-03_JPRB/)
KBO( :, 1,52,10) = (/&
&1.3628E-03_JPRB,1.5783E-03_JPRB,1.2808E-03_JPRB,8.4055E-04_JPRB,6.0012E-04_JPRB/)
KBO( :, 2,52,10) = (/&
&2.4017E-03_JPRB,2.8236E-03_JPRB,2.2905E-03_JPRB,1.5011E-03_JPRB,8.8126E-04_JPRB/)
KBO( :, 3,52,10) = (/&
&4.1169E-03_JPRB,4.8815E-03_JPRB,3.9607E-03_JPRB,2.5906E-03_JPRB,1.2847E-03_JPRB/)
KBO( :, 4,52,10) = (/&
&6.9536E-03_JPRB,8.1559E-03_JPRB,6.5664E-03_JPRB,4.2815E-03_JPRB,1.8638E-03_JPRB/)
KBO( :, 5,52,10) = (/&
&1.1409E-02_JPRB,1.3194E-02_JPRB,1.0553E-02_JPRB,6.7875E-03_JPRB,2.6534E-03_JPRB/)
KBO( :, 1,53,10) = (/&
&9.8606E-04_JPRB,1.1540E-03_JPRB,9.3384E-04_JPRB,6.1040E-04_JPRB,4.7709E-04_JPRB/)
KBO( :, 2,53,10) = (/&
&1.7920E-03_JPRB,2.1145E-03_JPRB,1.7063E-03_JPRB,1.1169E-03_JPRB,7.1312E-04_JPRB/)
KBO( :, 3,53,10) = (/&
&3.1294E-03_JPRB,3.7546E-03_JPRB,3.0421E-03_JPRB,1.9861E-03_JPRB,1.0419E-03_JPRB/)
KBO( :, 4,53,10) = (/&
&5.4059E-03_JPRB,6.4522E-03_JPRB,5.1921E-03_JPRB,3.3816E-03_JPRB,1.5130E-03_JPRB/)
KBO( :, 5,53,10) = (/&
&9.1118E-03_JPRB,1.0696E-02_JPRB,8.5534E-03_JPRB,5.5066E-03_JPRB,2.1843E-03_JPRB/)
KBO( :, 1,54,10) = (/&
&7.2513E-04_JPRB,8.5732E-04_JPRB,6.9183E-04_JPRB,4.5039E-04_JPRB,3.8769E-04_JPRB/)
KBO( :, 2,54,10) = (/&
&1.3639E-03_JPRB,1.6067E-03_JPRB,1.2902E-03_JPRB,8.3972E-04_JPRB,5.9341E-04_JPRB/)
KBO( :, 3,54,10) = (/&
&2.4214E-03_JPRB,2.9176E-03_JPRB,2.3545E-03_JPRB,1.5328E-03_JPRB,8.7214E-04_JPRB/)
KBO( :, 4,54,10) = (/&
&4.2490E-03_JPRB,5.1414E-03_JPRB,4.1362E-03_JPRB,2.6851E-03_JPRB,1.2710E-03_JPRB/)
KBO( :, 5,54,10) = (/&
&7.3277E-03_JPRB,8.7352E-03_JPRB,6.9866E-03_JPRB,4.4974E-03_JPRB,1.8463E-03_JPRB/)
KBO( :, 1,55,10) = (/&
&5.3536E-04_JPRB,6.3819E-04_JPRB,5.1429E-04_JPRB,3.3384E-04_JPRB,3.1787E-04_JPRB/)
KBO( :, 2,55,10) = (/&
&1.0434E-03_JPRB,1.2286E-03_JPRB,9.8197E-04_JPRB,6.3464E-04_JPRB,5.0051E-04_JPRB/)
KBO( :, 3,55,10) = (/&
&1.8896E-03_JPRB,2.2759E-03_JPRB,1.8255E-03_JPRB,1.1820E-03_JPRB,7.4689E-04_JPRB/)
KBO( :, 4,55,10) = (/&
&3.3543E-03_JPRB,4.1000E-03_JPRB,3.2922E-03_JPRB,2.1289E-03_JPRB,1.0910E-03_JPRB/)
KBO( :, 5,55,10) = (/&
&5.8957E-03_JPRB,7.1360E-03_JPRB,5.7072E-03_JPRB,3.6721E-03_JPRB,1.5883E-03_JPRB/)
KBO( :, 1,56,10) = (/&
&3.9041E-04_JPRB,4.6983E-04_JPRB,3.7827E-04_JPRB,2.4495E-04_JPRB,2.5822E-04_JPRB/)
KBO( :, 2,56,10) = (/&
&7.9041E-04_JPRB,9.3554E-04_JPRB,7.4444E-04_JPRB,4.7743E-04_JPRB,4.2098E-04_JPRB/)
KBO( :, 3,56,10) = (/&
&1.4711E-03_JPRB,1.7706E-03_JPRB,1.4085E-03_JPRB,9.0462E-04_JPRB,6.4135E-04_JPRB/)
KBO( :, 4,56,10) = (/&
&2.6410E-03_JPRB,3.2487E-03_JPRB,2.5994E-03_JPRB,1.6753E-03_JPRB,9.4189E-04_JPRB/)
KBO( :, 5,56,10) = (/&
&4.7180E-03_JPRB,5.7942E-03_JPRB,4.6339E-03_JPRB,2.9753E-03_JPRB,1.3744E-03_JPRB/)
KBO( :, 1,57,10) = (/&
&2.8112E-04_JPRB,3.4134E-04_JPRB,2.7460E-04_JPRB,1.7739E-04_JPRB,2.0810E-04_JPRB/)
KBO( :, 2,57,10) = (/&
&5.9233E-04_JPRB,7.0612E-04_JPRB,5.6036E-04_JPRB,3.5724E-04_JPRB,3.5218E-04_JPRB/)
KBO( :, 3,57,10) = (/&
&1.1404E-03_JPRB,1.3698E-03_JPRB,1.0818E-03_JPRB,6.8867E-04_JPRB,5.5095E-04_JPRB/)
KBO( :, 4,57,10) = (/&
&2.0756E-03_JPRB,2.5598E-03_JPRB,2.0389E-03_JPRB,1.3071E-03_JPRB,8.1947E-04_JPRB/)
KBO( :, 5,57,10) = (/&
&3.7565E-03_JPRB,4.6715E-03_JPRB,3.7372E-03_JPRB,2.3897E-03_JPRB,1.1970E-03_JPRB/)
KBO( :, 1,58,10) = (/&
&2.0287E-04_JPRB,2.4841E-04_JPRB,1.9950E-04_JPRB,1.2870E-04_JPRB,1.6873E-04_JPRB/)
KBO( :, 2,58,10) = (/&
&4.4472E-04_JPRB,5.3470E-04_JPRB,4.2292E-04_JPRB,2.6899E-04_JPRB,2.9556E-04_JPRB/)
KBO( :, 3,58,10) = (/&
&8.8909E-04_JPRB,1.0668E-03_JPRB,8.3669E-04_JPRB,5.2917E-04_JPRB,4.7698E-04_JPRB/)
KBO( :, 4,58,10) = (/&
&1.6472E-03_JPRB,2.0319E-03_JPRB,1.6079E-03_JPRB,1.0235E-03_JPRB,7.2222E-04_JPRB/)
KBO( :, 5,58,10) = (/&
&3.0142E-03_JPRB,3.7808E-03_JPRB,3.0200E-03_JPRB,1.9230E-03_JPRB,1.0578E-03_JPRB/)
KBO( :, 1,59,10) = (/&
&1.7264E-04_JPRB,2.1252E-04_JPRB,1.6979E-04_JPRB,1.0877E-04_JPRB,1.5535E-04_JPRB/)
KBO( :, 2,59,10) = (/&
&3.8844E-04_JPRB,4.6892E-04_JPRB,3.6892E-04_JPRB,2.3285E-04_JPRB,2.7770E-04_JPRB/)
KBO( :, 3,59,10) = (/&
&7.9313E-04_JPRB,9.5358E-04_JPRB,7.4242E-04_JPRB,4.6490E-04_JPRB,4.5611E-04_JPRB/)
KBO( :, 4,59,10) = (/&
&1.4888E-03_JPRB,1.8362E-03_JPRB,1.4437E-03_JPRB,9.0907E-04_JPRB,6.9878E-04_JPRB/)
KBO( :, 5,59,10) = (/&
&2.7412E-03_JPRB,3.4444E-03_JPRB,2.7403E-03_JPRB,1.7293E-03_JPRB,1.0280E-03_JPRB/)
KBO( :, 1,13,11) = (/&
&4.6582E-01_JPRB,4.3126E-01_JPRB,3.9148E-01_JPRB,2.9782E-01_JPRB,2.0038E+00_JPRB/)
KBO( :, 2,13,11) = (/&
&6.6015E-01_JPRB,6.1362E-01_JPRB,5.5564E-01_JPRB,4.1997E-01_JPRB,2.1506E+00_JPRB/)
KBO( :, 3,13,11) = (/&
&8.9186E-01_JPRB,8.3255E-01_JPRB,7.5032E-01_JPRB,5.6975E-01_JPRB,2.2970E+00_JPRB/)
KBO( :, 4,13,11) = (/&
&1.1586E+00_JPRB,1.0869E+00_JPRB,9.7359E-01_JPRB,7.4196E-01_JPRB,2.4271E+00_JPRB/)
KBO( :, 5,13,11) = (/&
&1.4563E+00_JPRB,1.3761E+00_JPRB,1.2287E+00_JPRB,9.3624E-01_JPRB,2.5537E+00_JPRB/)
KBO( :, 1,14,11) = (/&
&4.6622E-01_JPRB,4.4694E-01_JPRB,4.0621E-01_JPRB,3.0517E-01_JPRB,1.9239E+00_JPRB/)
KBO( :, 2,14,11) = (/&
&6.5626E-01_JPRB,6.3097E-01_JPRB,5.7029E-01_JPRB,4.3017E-01_JPRB,2.0659E+00_JPRB/)
KBO( :, 3,14,11) = (/&
&8.8153E-01_JPRB,8.5029E-01_JPRB,7.6391E-01_JPRB,5.8015E-01_JPRB,2.1968E+00_JPRB/)
KBO( :, 4,14,11) = (/&
&1.1396E+00_JPRB,1.1043E+00_JPRB,9.8836E-01_JPRB,7.5006E-01_JPRB,2.3180E+00_JPRB/)
KBO( :, 5,14,11) = (/&
&1.4290E+00_JPRB,1.3870E+00_JPRB,1.2407E+00_JPRB,9.4051E-01_JPRB,2.4548E+00_JPRB/)
KBO( :, 1,15,11) = (/&
&4.5814E-01_JPRB,4.5398E-01_JPRB,4.1054E-01_JPRB,3.0839E-01_JPRB,1.6835E+00_JPRB/)
KBO( :, 2,15,11) = (/&
&6.4005E-01_JPRB,6.3563E-01_JPRB,5.7202E-01_JPRB,4.3265E-01_JPRB,1.8044E+00_JPRB/)
KBO( :, 3,15,11) = (/&
&8.5481E-01_JPRB,8.5188E-01_JPRB,7.6325E-01_JPRB,5.7776E-01_JPRB,1.9216E+00_JPRB/)
KBO( :, 4,15,11) = (/&
&1.1011E+00_JPRB,1.0984E+00_JPRB,9.8470E-01_JPRB,7.4242E-01_JPRB,2.0480E+00_JPRB/)
KBO( :, 5,15,11) = (/&
&1.3789E+00_JPRB,1.3707E+00_JPRB,1.2263E+00_JPRB,9.2692E-01_JPRB,2.1662E+00_JPRB/)
KBO( :, 1,16,11) = (/&
&4.3936E-01_JPRB,4.5055E-01_JPRB,4.0610E-01_JPRB,3.0607E-01_JPRB,1.3891E+00_JPRB/)
KBO( :, 2,16,11) = (/&
&6.0980E-01_JPRB,6.2580E-01_JPRB,5.6205E-01_JPRB,4.2411E-01_JPRB,1.4937E+00_JPRB/)
KBO( :, 3,16,11) = (/&
&8.1051E-01_JPRB,8.3041E-01_JPRB,7.4762E-01_JPRB,5.6219E-01_JPRB,1.6024E+00_JPRB/)
KBO( :, 4,16,11) = (/&
&1.0423E+00_JPRB,1.0629E+00_JPRB,9.5636E-01_JPRB,7.1926E-01_JPRB,1.7074E+00_JPRB/)
KBO( :, 5,16,11) = (/&
&1.3012E+00_JPRB,1.3270E+00_JPRB,1.1867E+00_JPRB,8.9662E-01_JPRB,1.8065E+00_JPRB/)
KBO( :, 1,17,11) = (/&
&4.1226E-01_JPRB,4.3606E-01_JPRB,3.9203E-01_JPRB,2.9614E-01_JPRB,1.1476E+00_JPRB/)
KBO( :, 2,17,11) = (/&
&5.6889E-01_JPRB,6.0078E-01_JPRB,5.4100E-01_JPRB,4.0607E-01_JPRB,1.2378E+00_JPRB/)
KBO( :, 3,17,11) = (/&
&7.5475E-01_JPRB,7.9223E-01_JPRB,7.1421E-01_JPRB,5.3429E-01_JPRB,1.3294E+00_JPRB/)
KBO( :, 4,17,11) = (/&
&9.6747E-01_JPRB,1.0124E+00_JPRB,9.0807E-01_JPRB,6.8194E-01_JPRB,1.4124E+00_JPRB/)
KBO( :, 5,17,11) = (/&
&1.1994E+00_JPRB,1.2593E+00_JPRB,1.1261E+00_JPRB,8.5185E-01_JPRB,1.4955E+00_JPRB/)
KBO( :, 1,18,11) = (/&
&3.8064E-01_JPRB,4.1279E-01_JPRB,3.7089E-01_JPRB,2.7981E-01_JPRB,9.7150E-01_JPRB/)
KBO( :, 2,18,11) = (/&
&5.2358E-01_JPRB,5.6462E-01_JPRB,5.0829E-01_JPRB,3.8105E-01_JPRB,1.0549E+00_JPRB/)
KBO( :, 3,18,11) = (/&
&6.9263E-01_JPRB,7.4312E-01_JPRB,6.6621E-01_JPRB,4.9871E-01_JPRB,1.1339E+00_JPRB/)
KBO( :, 4,18,11) = (/&
&8.8229E-01_JPRB,9.4872E-01_JPRB,8.4607E-01_JPRB,6.3576E-01_JPRB,1.2109E+00_JPRB/)
KBO( :, 5,18,11) = (/&
&1.0918E+00_JPRB,1.1715E+00_JPRB,1.0485E+00_JPRB,7.9321E-01_JPRB,1.2966E+00_JPRB/)
KBO( :, 1,19,11) = (/&
&3.4707E-01_JPRB,3.8254E-01_JPRB,3.4362E-01_JPRB,2.5858E-01_JPRB,8.6524E-01_JPRB/)
KBO( :, 2,19,11) = (/&
&4.7624E-01_JPRB,5.2177E-01_JPRB,4.6660E-01_JPRB,3.5041E-01_JPRB,9.4567E-01_JPRB/)
KBO( :, 3,19,11) = (/&
&6.2671E-01_JPRB,6.8651E-01_JPRB,6.0965E-01_JPRB,4.5831E-01_JPRB,1.0244E+00_JPRB/)
KBO( :, 4,19,11) = (/&
&7.9653E-01_JPRB,8.7098E-01_JPRB,7.7442E-01_JPRB,5.8401E-01_JPRB,1.1073E+00_JPRB/)
KBO( :, 5,19,11) = (/&
&9.8427E-01_JPRB,1.0726E+00_JPRB,9.5997E-01_JPRB,7.2540E-01_JPRB,1.1966E+00_JPRB/)
KBO( :, 1,20,11) = (/&
&3.1567E-01_JPRB,3.5181E-01_JPRB,3.1444E-01_JPRB,2.3622E-01_JPRB,8.0158E-01_JPRB/)
KBO( :, 2,20,11) = (/&
&4.3131E-01_JPRB,4.7923E-01_JPRB,4.2436E-01_JPRB,3.1880E-01_JPRB,8.8081E-01_JPRB/)
KBO( :, 3,20,11) = (/&
&5.6512E-01_JPRB,6.2700E-01_JPRB,5.5312E-01_JPRB,4.1741E-01_JPRB,9.6113E-01_JPRB/)
KBO( :, 4,20,11) = (/&
&7.1661E-01_JPRB,7.9159E-01_JPRB,7.0178E-01_JPRB,5.3032E-01_JPRB,1.0489E+00_JPRB/)
KBO( :, 5,20,11) = (/&
&8.8236E-01_JPRB,9.7468E-01_JPRB,8.6952E-01_JPRB,6.5743E-01_JPRB,1.1372E+00_JPRB/)
KBO( :, 1,21,11) = (/&
&2.8592E-01_JPRB,3.2074E-01_JPRB,2.8394E-01_JPRB,2.1333E-01_JPRB,7.4290E-01_JPRB/)
KBO( :, 2,21,11) = (/&
&3.8826E-01_JPRB,4.3502E-01_JPRB,3.8223E-01_JPRB,2.8797E-01_JPRB,8.2178E-01_JPRB/)
KBO( :, 3,21,11) = (/&
&5.0741E-01_JPRB,5.6572E-01_JPRB,4.9792E-01_JPRB,3.7590E-01_JPRB,9.0519E-01_JPRB/)
KBO( :, 4,21,11) = (/&
&6.4058E-01_JPRB,7.1340E-01_JPRB,6.3080E-01_JPRB,4.7663E-01_JPRB,9.9225E-01_JPRB/)
KBO( :, 5,21,11) = (/&
&7.8811E-01_JPRB,8.7944E-01_JPRB,7.7953E-01_JPRB,5.8917E-01_JPRB,1.0812E+00_JPRB/)
KBO( :, 1,22,11) = (/&
&2.6349E-01_JPRB,2.9660E-01_JPRB,2.5964E-01_JPRB,1.9557E-01_JPRB,6.7570E-01_JPRB/)
KBO( :, 2,22,11) = (/&
&3.5527E-01_JPRB,3.9835E-01_JPRB,3.4850E-01_JPRB,2.6305E-01_JPRB,7.5224E-01_JPRB/)
KBO( :, 3,22,11) = (/&
&4.6050E-01_JPRB,5.1538E-01_JPRB,4.5315E-01_JPRB,3.4161E-01_JPRB,8.3620E-01_JPRB/)
KBO( :, 4,22,11) = (/&
&5.8034E-01_JPRB,6.4971E-01_JPRB,5.7124E-01_JPRB,4.3148E-01_JPRB,9.2191E-01_JPRB/)
KBO( :, 5,22,11) = (/&
&7.1598E-01_JPRB,7.9992E-01_JPRB,7.0387E-01_JPRB,5.3098E-01_JPRB,1.0108E+00_JPRB/)
KBO( :, 1,23,11) = (/&
&2.4294E-01_JPRB,2.7306E-01_JPRB,2.3732E-01_JPRB,1.7872E-01_JPRB,6.0705E-01_JPRB/)
KBO( :, 2,23,11) = (/&
&3.2497E-01_JPRB,3.6372E-01_JPRB,3.1788E-01_JPRB,2.3869E-01_JPRB,6.8421E-01_JPRB/)
KBO( :, 3,23,11) = (/&
&4.2067E-01_JPRB,4.6941E-01_JPRB,4.1072E-01_JPRB,3.0874E-01_JPRB,7.6600E-01_JPRB/)
KBO( :, 4,23,11) = (/&
&5.3164E-01_JPRB,5.9097E-01_JPRB,5.1614E-01_JPRB,3.8792E-01_JPRB,8.5300E-01_JPRB/)
KBO( :, 5,23,11) = (/&
&6.5861E-01_JPRB,7.2844E-01_JPRB,6.3392E-01_JPRB,4.7757E-01_JPRB,9.4241E-01_JPRB/)
KBO( :, 1,24,11) = (/&
&2.2482E-01_JPRB,2.5108E-01_JPRB,2.1802E-01_JPRB,1.6286E-01_JPRB,5.3854E-01_JPRB/)
KBO( :, 2,24,11) = (/&
&2.9997E-01_JPRB,3.3291E-01_JPRB,2.8985E-01_JPRB,2.1640E-01_JPRB,6.1678E-01_JPRB/)
KBO( :, 3,24,11) = (/&
&3.8949E-01_JPRB,4.2945E-01_JPRB,3.7259E-01_JPRB,2.7841E-01_JPRB,6.9947E-01_JPRB/)
KBO( :, 4,24,11) = (/&
&4.9475E-01_JPRB,5.4040E-01_JPRB,4.6781E-01_JPRB,3.4874E-01_JPRB,7.8678E-01_JPRB/)
KBO( :, 5,24,11) = (/&
&6.1688E-01_JPRB,6.6845E-01_JPRB,5.7526E-01_JPRB,4.2946E-01_JPRB,8.7638E-01_JPRB/)
KBO( :, 1,25,11) = (/&
&2.0867E-01_JPRB,2.3175E-01_JPRB,2.0085E-01_JPRB,1.4849E-01_JPRB,4.8336E-01_JPRB/)
KBO( :, 2,25,11) = (/&
&2.7944E-01_JPRB,3.0729E-01_JPRB,2.6487E-01_JPRB,1.9609E-01_JPRB,5.5823E-01_JPRB/)
KBO( :, 3,25,11) = (/&
&3.6506E-01_JPRB,3.9632E-01_JPRB,3.4020E-01_JPRB,2.5115E-01_JPRB,6.3661E-01_JPRB/)
KBO( :, 4,25,11) = (/&
&4.6727E-01_JPRB,5.0070E-01_JPRB,4.2731E-01_JPRB,3.1512E-01_JPRB,7.1582E-01_JPRB/)
KBO( :, 5,25,11) = (/&
&5.8636E-01_JPRB,6.2209E-01_JPRB,5.2796E-01_JPRB,3.8925E-01_JPRB,7.9834E-01_JPRB/)
KBO( :, 1,26,11) = (/&
&1.9587E-01_JPRB,2.1594E-01_JPRB,1.8576E-01_JPRB,1.3602E-01_JPRB,4.3426E-01_JPRB/)
KBO( :, 2,26,11) = (/&
&2.6382E-01_JPRB,2.8676E-01_JPRB,2.4459E-01_JPRB,1.7873E-01_JPRB,5.0085E-01_JPRB/)
KBO( :, 3,26,11) = (/&
&3.4692E-01_JPRB,3.7120E-01_JPRB,3.1465E-01_JPRB,2.2874E-01_JPRB,5.6934E-01_JPRB/)
KBO( :, 4,26,11) = (/&
&4.4520E-01_JPRB,4.7181E-01_JPRB,3.9637E-01_JPRB,2.8766E-01_JPRB,6.3969E-01_JPRB/)
KBO( :, 5,26,11) = (/&
&5.5605E-01_JPRB,5.8855E-01_JPRB,4.9195E-01_JPRB,3.5675E-01_JPRB,7.1476E-01_JPRB/)
KBO( :, 1,27,11) = (/&
&1.8539E-01_JPRB,2.0232E-01_JPRB,1.7242E-01_JPRB,1.2491E-01_JPRB,3.7468E-01_JPRB/)
KBO( :, 2,27,11) = (/&
&2.5096E-01_JPRB,2.6936E-01_JPRB,2.2766E-01_JPRB,1.6372E-01_JPRB,4.3134E-01_JPRB/)
KBO( :, 3,27,11) = (/&
&3.2985E-01_JPRB,3.5118E-01_JPRB,2.9380E-01_JPRB,2.1018E-01_JPRB,4.9024E-01_JPRB/)
KBO( :, 4,27,11) = (/&
&4.2050E-01_JPRB,4.4779E-01_JPRB,3.7245E-01_JPRB,2.6552E-01_JPRB,5.5373E-01_JPRB/)
KBO( :, 5,27,11) = (/&
&5.2353E-01_JPRB,5.5799E-01_JPRB,4.6451E-01_JPRB,3.2979E-01_JPRB,6.2244E-01_JPRB/)
KBO( :, 1,28,11) = (/&
&1.7670E-01_JPRB,1.9079E-01_JPRB,1.6081E-01_JPRB,1.1550E-01_JPRB,3.1173E-01_JPRB/)
KBO( :, 2,28,11) = (/&
&2.3816E-01_JPRB,2.5545E-01_JPRB,2.1349E-01_JPRB,1.5165E-01_JPRB,3.6015E-01_JPRB/)
KBO( :, 3,28,11) = (/&
&3.1046E-01_JPRB,3.3329E-01_JPRB,2.7692E-01_JPRB,1.9535E-01_JPRB,4.1203E-01_JPRB/)
KBO( :, 4,28,11) = (/&
&3.9421E-01_JPRB,4.2355E-01_JPRB,3.5226E-01_JPRB,2.4753E-01_JPRB,4.6881E-01_JPRB/)
KBO( :, 5,28,11) = (/&
&4.9113E-01_JPRB,5.2757E-01_JPRB,4.3988E-01_JPRB,3.0817E-01_JPRB,5.2989E-01_JPRB/)
KBO( :, 1,29,11) = (/&
&1.6843E-01_JPRB,1.8154E-01_JPRB,1.5154E-01_JPRB,1.0767E-01_JPRB,2.5441E-01_JPRB/)
KBO( :, 2,29,11) = (/&
&2.2466E-01_JPRB,2.4270E-01_JPRB,2.0190E-01_JPRB,1.4201E-01_JPRB,2.9556E-01_JPRB/)
KBO( :, 3,29,11) = (/&
&2.9126E-01_JPRB,3.1537E-01_JPRB,2.6232E-01_JPRB,1.8387E-01_JPRB,3.4113E-01_JPRB/)
KBO( :, 4,29,11) = (/&
&3.6983E-01_JPRB,4.0011E-01_JPRB,3.3340E-01_JPRB,2.3338E-01_JPRB,3.9100E-01_JPRB/)
KBO( :, 5,29,11) = (/&
&4.6101E-01_JPRB,4.9867E-01_JPRB,4.1663E-01_JPRB,2.9053E-01_JPRB,4.4464E-01_JPRB/)
KBO( :, 1,30,11) = (/&
&1.5959E-01_JPRB,1.7262E-01_JPRB,1.4374E-01_JPRB,1.0130E-01_JPRB,2.0471E-01_JPRB/)
KBO( :, 2,30,11) = (/&
&2.1115E-01_JPRB,2.2963E-01_JPRB,1.9116E-01_JPRB,1.3421E-01_JPRB,2.4020E-01_JPRB/)
KBO( :, 3,30,11) = (/&
&2.7360E-01_JPRB,2.9740E-01_JPRB,2.4795E-01_JPRB,1.7403E-01_JPRB,2.7968E-01_JPRB/)
KBO( :, 4,30,11) = (/&
&3.4764E-01_JPRB,3.7756E-01_JPRB,3.1549E-01_JPRB,2.2070E-01_JPRB,3.2281E-01_JPRB/)
KBO( :, 5,30,11) = (/&
&4.3440E-01_JPRB,4.7219E-01_JPRB,3.9465E-01_JPRB,2.7465E-01_JPRB,3.6896E-01_JPRB/)
KBO( :, 1,31,11) = (/&
&1.5091E-01_JPRB,1.6391E-01_JPRB,1.3645E-01_JPRB,9.6278E-02_JPRB,1.6289E-01_JPRB/)
KBO( :, 2,31,11) = (/&
&1.9931E-01_JPRB,2.1721E-01_JPRB,1.8079E-01_JPRB,1.2771E-01_JPRB,1.9309E-01_JPRB/)
KBO( :, 3,31,11) = (/&
&2.5821E-01_JPRB,2.8109E-01_JPRB,2.3449E-01_JPRB,1.6502E-01_JPRB,2.2676E-01_JPRB/)
KBO( :, 4,31,11) = (/&
&3.2875E-01_JPRB,3.5829E-01_JPRB,2.9898E-01_JPRB,2.0919E-01_JPRB,2.6370E-01_JPRB/)
KBO( :, 5,31,11) = (/&
&4.1157E-01_JPRB,4.5002E-01_JPRB,3.7499E-01_JPRB,2.6064E-01_JPRB,3.0365E-01_JPRB/)
KBO( :, 1,32,11) = (/&
&1.4350E-01_JPRB,1.5577E-01_JPRB,1.2948E-01_JPRB,9.1911E-02_JPRB,1.3126E-01_JPRB/)
KBO( :, 2,32,11) = (/&
&1.8927E-01_JPRB,2.0591E-01_JPRB,1.7137E-01_JPRB,1.2148E-01_JPRB,1.5712E-01_JPRB/)
KBO( :, 3,32,11) = (/&
&2.4542E-01_JPRB,2.6745E-01_JPRB,2.2265E-01_JPRB,1.5686E-01_JPRB,1.8606E-01_JPRB/)
KBO( :, 4,32,11) = (/&
&3.1299E-01_JPRB,3.4211E-01_JPRB,2.8464E-01_JPRB,1.9879E-01_JPRB,2.1776E-01_JPRB/)
KBO( :, 5,32,11) = (/&
&3.9189E-01_JPRB,4.3154E-01_JPRB,3.5784E-01_JPRB,2.4869E-01_JPRB,2.5261E-01_JPRB/)
KBO( :, 1,33,11) = (/&
&1.3727E-01_JPRB,1.4838E-01_JPRB,1.2325E-01_JPRB,8.7723E-02_JPRB,1.0656E-01_JPRB/)
KBO( :, 2,33,11) = (/&
&1.8110E-01_JPRB,1.9647E-01_JPRB,1.6322E-01_JPRB,1.1562E-01_JPRB,1.2867E-01_JPRB/)
KBO( :, 3,33,11) = (/&
&2.3493E-01_JPRB,2.5633E-01_JPRB,2.1260E-01_JPRB,1.4945E-01_JPRB,1.5344E-01_JPRB/)
KBO( :, 4,33,11) = (/&
&2.9930E-01_JPRB,3.2911E-01_JPRB,2.7241E-01_JPRB,1.8991E-01_JPRB,1.8112E-01_JPRB/)
KBO( :, 5,33,11) = (/&
&3.7491E-01_JPRB,4.1658E-01_JPRB,3.4340E-01_JPRB,2.3867E-01_JPRB,2.1188E-01_JPRB/)
KBO( :, 1,34,11) = (/&
&1.3092E-01_JPRB,1.4094E-01_JPRB,1.1667E-01_JPRB,8.2911E-02_JPRB,8.9471E-02_JPRB/)
KBO( :, 2,34,11) = (/&
&1.7283E-01_JPRB,1.8720E-01_JPRB,1.5498E-01_JPRB,1.0945E-01_JPRB,1.0879E-01_JPRB/)
KBO( :, 3,34,11) = (/&
&2.2423E-01_JPRB,2.4508E-01_JPRB,2.0247E-01_JPRB,1.4175E-01_JPRB,1.3067E-01_JPRB/)
KBO( :, 4,34,11) = (/&
&2.8568E-01_JPRB,3.1613E-01_JPRB,2.6022E-01_JPRB,1.8119E-01_JPRB,1.5551E-01_JPRB/)
KBO( :, 5,34,11) = (/&
&3.5836E-01_JPRB,4.0157E-01_JPRB,3.2942E-01_JPRB,2.2886E-01_JPRB,1.8335E-01_JPRB/)
KBO( :, 1,35,11) = (/&
&1.2228E-01_JPRB,1.3118E-01_JPRB,1.0815E-01_JPRB,7.6480E-02_JPRB,7.3770E-02_JPRB/)
KBO( :, 2,35,11) = (/&
&1.6172E-01_JPRB,1.7516E-01_JPRB,1.4419E-01_JPRB,1.0138E-01_JPRB,9.0532E-02_JPRB/)
KBO( :, 3,35,11) = (/&
&2.1005E-01_JPRB,2.3024E-01_JPRB,1.8936E-01_JPRB,1.3212E-01_JPRB,1.0977E-01_JPRB/)
KBO( :, 4,35,11) = (/&
&2.6823E-01_JPRB,2.9837E-01_JPRB,2.4450E-01_JPRB,1.7010E-01_JPRB,1.3152E-01_JPRB/)
KBO( :, 5,35,11) = (/&
&3.3803E-01_JPRB,3.8069E-01_JPRB,3.1151E-01_JPRB,2.1623E-01_JPRB,1.5639E-01_JPRB/)
KBO( :, 1,36,11) = (/&
&1.1127E-01_JPRB,1.1902E-01_JPRB,9.7790E-02_JPRB,6.8652E-02_JPRB,5.9294E-02_JPRB/)
KBO( :, 2,36,11) = (/&
&1.4779E-01_JPRB,1.5991E-01_JPRB,1.3100E-01_JPRB,9.1678E-02_JPRB,7.3428E-02_JPRB/)
KBO( :, 3,36,11) = (/&
&1.9248E-01_JPRB,2.1152E-01_JPRB,1.7310E-01_JPRB,1.2044E-01_JPRB,8.9931E-02_JPRB/)
KBO( :, 4,36,11) = (/&
&2.4698E-01_JPRB,2.7546E-01_JPRB,2.2513E-01_JPRB,1.5635E-01_JPRB,1.0865E-01_JPRB/)
KBO( :, 5,36,11) = (/&
&3.1312E-01_JPRB,3.5357E-01_JPRB,2.8900E-01_JPRB,2.0028E-01_JPRB,1.3007E-01_JPRB/)
KBO( :, 1,37,11) = (/&
&9.7171E-02_JPRB,1.0370E-01_JPRB,8.4930E-02_JPRB,5.9132E-02_JPRB,4.8800E-02_JPRB/)
KBO( :, 2,37,11) = (/&
&1.3022E-01_JPRB,1.4042E-01_JPRB,1.1467E-01_JPRB,7.9788E-02_JPRB,6.1101E-02_JPRB/)
KBO( :, 3,37,11) = (/&
&1.7053E-01_JPRB,1.8732E-01_JPRB,1.5267E-01_JPRB,1.0592E-01_JPRB,7.5549E-02_JPRB/)
KBO( :, 4,37,11) = (/&
&2.2021E-01_JPRB,2.4584E-01_JPRB,2.0025E-01_JPRB,1.3887E-01_JPRB,9.2123E-02_JPRB/)
KBO( :, 5,37,11) = (/&
&2.8142E-01_JPRB,3.1806E-01_JPRB,2.5954E-01_JPRB,1.7970E-01_JPRB,1.1114E-01_JPRB/)
KBO( :, 1,38,11) = (/&
&8.4750E-02_JPRB,9.0447E-02_JPRB,7.3862E-02_JPRB,5.1024E-02_JPRB,4.0120E-02_JPRB/)
KBO( :, 2,38,11) = (/&
&1.1472E-01_JPRB,1.2347E-01_JPRB,1.0053E-01_JPRB,6.9437E-02_JPRB,5.0776E-02_JPRB/)
KBO( :, 3,38,11) = (/&
&1.5136E-01_JPRB,1.6607E-01_JPRB,1.3499E-01_JPRB,9.3219E-02_JPRB,6.3385E-02_JPRB/)
KBO( :, 4,38,11) = (/&
&1.9680E-01_JPRB,2.1978E-01_JPRB,1.7847E-01_JPRB,1.2347E-01_JPRB,7.8006E-02_JPRB/)
KBO( :, 5,38,11) = (/&
&2.5341E-01_JPRB,2.8675E-01_JPRB,2.3338E-01_JPRB,1.6145E-01_JPRB,9.4840E-02_JPRB/)
KBO( :, 1,39,11) = (/&
&7.4011E-02_JPRB,7.9191E-02_JPRB,6.4478E-02_JPRB,4.4207E-02_JPRB,3.2805E-02_JPRB/)
KBO( :, 2,39,11) = (/&
&1.0122E-01_JPRB,1.0907E-01_JPRB,8.8541E-02_JPRB,6.0759E-02_JPRB,4.1971E-02_JPRB/)
KBO( :, 3,39,11) = (/&
&1.3478E-01_JPRB,1.4779E-01_JPRB,1.1992E-01_JPRB,8.2325E-02_JPRB,5.2901E-02_JPRB/)
KBO( :, 4,39,11) = (/&
&1.7660E-01_JPRB,1.9727E-01_JPRB,1.5986E-01_JPRB,1.1017E-01_JPRB,6.5730E-02_JPRB/)
KBO( :, 5,39,11) = (/&
&2.2909E-01_JPRB,2.5986E-01_JPRB,2.1074E-01_JPRB,1.4557E-01_JPRB,8.0505E-02_JPRB/)
KBO( :, 1,40,11) = (/&
&6.2473E-02_JPRB,6.7073E-02_JPRB,5.4566E-02_JPRB,3.7187E-02_JPRB,2.6885E-02_JPRB/)
KBO( :, 2,40,11) = (/&
&8.6606E-02_JPRB,9.3644E-02_JPRB,7.5801E-02_JPRB,5.1661E-02_JPRB,3.4836E-02_JPRB/)
KBO( :, 3,40,11) = (/&
&1.1680E-01_JPRB,1.2799E-01_JPRB,1.0372E-01_JPRB,7.0693E-02_JPRB,4.4368E-02_JPRB/)
KBO( :, 4,40,11) = (/&
&1.5470E-01_JPRB,1.7247E-01_JPRB,1.3960E-01_JPRB,9.5679E-02_JPRB,5.5687E-02_JPRB/)
KBO( :, 5,40,11) = (/&
&2.0237E-01_JPRB,2.2977E-01_JPRB,1.8573E-01_JPRB,1.2793E-01_JPRB,6.8850E-02_JPRB/)
KBO( :, 1,41,11) = (/&
&5.2446E-02_JPRB,5.6507E-02_JPRB,4.5959E-02_JPRB,3.1195E-02_JPRB,2.1948E-02_JPRB/)
KBO( :, 2,41,11) = (/&
&7.3701E-02_JPRB,8.0111E-02_JPRB,6.4714E-02_JPRB,4.3819E-02_JPRB,2.8834E-02_JPRB/)
KBO( :, 3,41,11) = (/&
&1.0076E-01_JPRB,1.1070E-01_JPRB,8.9512E-02_JPRB,6.0576E-02_JPRB,3.7158E-02_JPRB/)
KBO( :, 4,41,11) = (/&
&1.3508E-01_JPRB,1.5057E-01_JPRB,1.2175E-01_JPRB,8.2892E-02_JPRB,4.7100E-02_JPRB/)
KBO( :, 5,41,11) = (/&
&1.7854E-01_JPRB,2.0269E-01_JPRB,1.6356E-01_JPRB,1.1214E-01_JPRB,5.8823E-02_JPRB/)
KBO( :, 1,42,11) = (/&
&4.3993E-02_JPRB,4.7543E-02_JPRB,3.8628E-02_JPRB,2.6175E-02_JPRB,1.7822E-02_JPRB/)
KBO( :, 2,42,11) = (/&
&6.2618E-02_JPRB,6.8461E-02_JPRB,5.5301E-02_JPRB,3.7217E-02_JPRB,2.3728E-02_JPRB/)
KBO( :, 3,42,11) = (/&
&8.6814E-02_JPRB,9.5948E-02_JPRB,7.7328E-02_JPRB,5.2009E-02_JPRB,3.0953E-02_JPRB/)
KBO( :, 4,42,11) = (/&
&1.1793E-01_JPRB,1.3165E-01_JPRB,1.0635E-01_JPRB,7.1967E-02_JPRB,3.9679E-02_JPRB/)
KBO( :, 5,42,11) = (/&
&1.5767E-01_JPRB,1.7909E-01_JPRB,1.4430E-01_JPRB,9.8414E-02_JPRB,5.0031E-02_JPRB/)
KBO( :, 1,43,11) = (/&
&3.6051E-02_JPRB,3.9068E-02_JPRB,3.1700E-02_JPRB,2.1500E-02_JPRB,1.4336E-02_JPRB/)
KBO( :, 2,43,11) = (/&
&5.2131E-02_JPRB,5.7262E-02_JPRB,4.6240E-02_JPRB,3.1003E-02_JPRB,1.9367E-02_JPRB/)
KBO( :, 3,43,11) = (/&
&7.3341E-02_JPRB,8.1590E-02_JPRB,6.5706E-02_JPRB,4.3880E-02_JPRB,2.5604E-02_JPRB/)
KBO( :, 4,43,11) = (/&
&1.0113E-01_JPRB,1.1336E-01_JPRB,9.1355E-02_JPRB,6.1391E-02_JPRB,3.3210E-02_JPRB/)
KBO( :, 5,43,11) = (/&
&1.3704E-01_JPRB,1.5566E-01_JPRB,1.2530E-01_JPRB,8.4984E-02_JPRB,4.2357E-02_JPRB/)
KBO( :, 1,44,11) = (/&
&2.9153E-02_JPRB,3.1689E-02_JPRB,2.5651E-02_JPRB,1.7398E-02_JPRB,1.1452E-02_JPRB/)
KBO( :, 2,44,11) = (/&
&4.2894E-02_JPRB,4.7271E-02_JPRB,3.8161E-02_JPRB,2.5559E-02_JPRB,1.5702E-02_JPRB/)
KBO( :, 3,44,11) = (/&
&6.1316E-02_JPRB,6.8606E-02_JPRB,5.5241E-02_JPRB,3.6706E-02_JPRB,2.1051E-02_JPRB/)
KBO( :, 4,44,11) = (/&
&8.5809E-02_JPRB,9.6811E-02_JPRB,7.7867E-02_JPRB,5.1972E-02_JPRB,2.7643E-02_JPRB/)
KBO( :, 5,44,11) = (/&
&1.1804E-01_JPRB,1.3427E-01_JPRB,1.0805E-01_JPRB,7.2832E-02_JPRB,3.5698E-02_JPRB/)
KBO( :, 1,45,11) = (/&
&2.3474E-02_JPRB,2.5620E-02_JPRB,2.0683E-02_JPRB,1.3992E-02_JPRB,9.0872E-03_JPRB/)
KBO( :, 2,45,11) = (/&
&3.5168E-02_JPRB,3.8884E-02_JPRB,3.1357E-02_JPRB,2.0998E-02_JPRB,1.2650E-02_JPRB/)
KBO( :, 3,45,11) = (/&
&5.1125E-02_JPRB,5.7479E-02_JPRB,4.6268E-02_JPRB,3.0685E-02_JPRB,1.7188E-02_JPRB/)
KBO( :, 4,45,11) = (/&
&7.2642E-02_JPRB,8.2540E-02_JPRB,6.6385E-02_JPRB,4.3982E-02_JPRB,2.2878E-02_JPRB/)
KBO( :, 5,45,11) = (/&
&1.0141E-01_JPRB,1.1593E-01_JPRB,9.3129E-02_JPRB,6.2384E-02_JPRB,2.9912E-02_JPRB/)
KBO( :, 1,46,11) = (/&
&1.8622E-02_JPRB,2.0419E-02_JPRB,1.6446E-02_JPRB,1.1089E-02_JPRB,7.1508E-03_JPRB/)
KBO( :, 2,46,11) = (/&
&2.8465E-02_JPRB,3.1591E-02_JPRB,2.5425E-02_JPRB,1.7003E-02_JPRB,1.0100E-02_JPRB/)
KBO( :, 3,46,11) = (/&
&4.2115E-02_JPRB,4.7558E-02_JPRB,3.8296E-02_JPRB,2.5381E-02_JPRB,1.3928E-02_JPRB/)
KBO( :, 4,46,11) = (/&
&6.0884E-02_JPRB,6.9606E-02_JPRB,5.6000E-02_JPRB,3.6888E-02_JPRB,1.8798E-02_JPRB/)
KBO( :, 5,46,11) = (/&
&8.6271E-02_JPRB,9.9295E-02_JPRB,7.9645E-02_JPRB,5.2994E-02_JPRB,2.4873E-02_JPRB/)
KBO( :, 1,47,11) = (/&
&1.4376E-02_JPRB,1.5849E-02_JPRB,1.2756E-02_JPRB,8.5637E-03_JPRB,5.5846E-03_JPRB/)
KBO( :, 2,47,11) = (/&
&2.2523E-02_JPRB,2.5091E-02_JPRB,2.0133E-02_JPRB,1.3433E-02_JPRB,8.0135E-03_JPRB/)
KBO( :, 3,47,11) = (/&
&3.3987E-02_JPRB,3.8521E-02_JPRB,3.0971E-02_JPRB,2.0498E-02_JPRB,1.1217E-02_JPRB/)
KBO( :, 4,47,11) = (/&
&4.9995E-02_JPRB,5.7475E-02_JPRB,4.6271E-02_JPRB,3.0427E-02_JPRB,1.5354E-02_JPRB/)
KBO( :, 5,47,11) = (/&
&7.2095E-02_JPRB,8.3553E-02_JPRB,6.7099E-02_JPRB,4.4249E-02_JPRB,2.0567E-02_JPRB/)
KBO( :, 1,48,11) = (/&
&1.0948E-02_JPRB,1.2187E-02_JPRB,9.8197E-03_JPRB,6.5686E-03_JPRB,4.3309E-03_JPRB/)
KBO( :, 2,48,11) = (/&
&1.7678E-02_JPRB,1.9773E-02_JPRB,1.5847E-02_JPRB,1.0523E-02_JPRB,6.3196E-03_JPRB/)
KBO( :, 3,48,11) = (/&
&2.7272E-02_JPRB,3.1035E-02_JPRB,2.4886E-02_JPRB,1.6427E-02_JPRB,8.9753E-03_JPRB/)
KBO( :, 4,48,11) = (/&
&4.0847E-02_JPRB,4.7231E-02_JPRB,3.7989E-02_JPRB,2.4968E-02_JPRB,1.2435E-02_JPRB/)
KBO( :, 5,48,11) = (/&
&5.9943E-02_JPRB,6.9928E-02_JPRB,5.6261E-02_JPRB,3.6863E-02_JPRB,1.6884E-02_JPRB/)
KBO( :, 1,49,11) = (/&
&8.2227E-03_JPRB,9.2751E-03_JPRB,7.4918E-03_JPRB,4.9857E-03_JPRB,3.3179E-03_JPRB/)
KBO( :, 2,49,11) = (/&
&1.3710E-02_JPRB,1.5461E-02_JPRB,1.2382E-02_JPRB,8.1837E-03_JPRB,4.9416E-03_JPRB/)
KBO( :, 3,49,11) = (/&
&2.1752E-02_JPRB,2.4824E-02_JPRB,1.9870E-02_JPRB,1.3064E-02_JPRB,7.1199E-03_JPRB/)
KBO( :, 4,49,11) = (/&
&3.3202E-02_JPRB,3.8592E-02_JPRB,3.0992E-02_JPRB,2.0326E-02_JPRB,9.9895E-03_JPRB/)
KBO( :, 5,49,11) = (/&
&4.9564E-02_JPRB,5.8206E-02_JPRB,4.6898E-02_JPRB,3.0661E-02_JPRB,1.3734E-02_JPRB/)
KBO( :, 1,50,11) = (/&
&6.1915E-03_JPRB,7.0808E-03_JPRB,5.7341E-03_JPRB,3.7933E-03_JPRB,2.6014E-03_JPRB/)
KBO( :, 2,50,11) = (/&
&1.0634E-02_JPRB,1.2140E-02_JPRB,9.7185E-03_JPRB,6.3965E-03_JPRB,3.9374E-03_JPRB/)
KBO( :, 3,50,11) = (/&
&1.7391E-02_JPRB,1.9945E-02_JPRB,1.5955E-02_JPRB,1.0445E-02_JPRB,5.7678E-03_JPRB/)
KBO( :, 4,50,11) = (/&
&2.7125E-02_JPRB,3.1701E-02_JPRB,2.5413E-02_JPRB,1.6599E-02_JPRB,8.1975E-03_JPRB/)
KBO( :, 5,50,11) = (/&
&4.1193E-02_JPRB,4.8726E-02_JPRB,3.9234E-02_JPRB,2.5636E-02_JPRB,1.1392E-02_JPRB/)
KBO( :, 1,51,11) = (/&
&4.6415E-03_JPRB,5.3779E-03_JPRB,4.3645E-03_JPRB,2.8762E-03_JPRB,2.0670E-03_JPRB/)
KBO( :, 2,51,11) = (/&
&8.1982E-03_JPRB,9.4964E-03_JPRB,7.6128E-03_JPRB,4.9899E-03_JPRB,3.1638E-03_JPRB/)
KBO( :, 3,51,11) = (/&
&1.3839E-02_JPRB,1.6014E-02_JPRB,1.2808E-02_JPRB,8.3362E-03_JPRB,4.7173E-03_JPRB/)
KBO( :, 4,51,11) = (/&
&2.2155E-02_JPRB,2.6015E-02_JPRB,2.0833E-02_JPRB,1.3537E-02_JPRB,6.8071E-03_JPRB/)
KBO( :, 5,51,11) = (/&
&3.4266E-02_JPRB,4.0819E-02_JPRB,3.2809E-02_JPRB,2.1399E-02_JPRB,9.5494E-03_JPRB/)
KBO( :, 1,52,11) = (/&
&3.4450E-03_JPRB,4.0419E-03_JPRB,3.2822E-03_JPRB,2.1593E-03_JPRB,1.6475E-03_JPRB/)
KBO( :, 2,52,11) = (/&
&6.2508E-03_JPRB,7.3537E-03_JPRB,5.9181E-03_JPRB,3.8603E-03_JPRB,2.5371E-03_JPRB/)
KBO( :, 3,52,11) = (/&
&1.0900E-02_JPRB,1.2773E-02_JPRB,1.0216E-02_JPRB,6.6126E-03_JPRB,3.8348E-03_JPRB/)
KBO( :, 4,52,11) = (/&
&1.7975E-02_JPRB,2.1233E-02_JPRB,1.7001E-02_JPRB,1.0994E-02_JPRB,5.6303E-03_JPRB/)
KBO( :, 5,52,11) = (/&
&2.8375E-02_JPRB,3.4038E-02_JPRB,2.7332E-02_JPRB,1.7744E-02_JPRB,7.9843E-03_JPRB/)
KBO( :, 1,53,11) = (/&
&2.5331E-03_JPRB,3.0017E-03_JPRB,2.4368E-03_JPRB,1.5998E-03_JPRB,1.3193E-03_JPRB/)
KBO( :, 2,53,11) = (/&
&4.7088E-03_JPRB,5.6274E-03_JPRB,4.5483E-03_JPRB,2.9549E-03_JPRB,2.0294E-03_JPRB/)
KBO( :, 3,53,11) = (/&
&8.4774E-03_JPRB,1.0097E-02_JPRB,8.0775E-03_JPRB,5.2092E-03_JPRB,3.0959E-03_JPRB/)
KBO( :, 4,53,11) = (/&
&1.4441E-02_JPRB,1.7209E-02_JPRB,1.3780E-02_JPRB,8.8745E-03_JPRB,4.6172E-03_JPRB/)
KBO( :, 5,53,11) = (/&
&2.3385E-02_JPRB,2.8212E-02_JPRB,2.2650E-02_JPRB,1.4615E-02_JPRB,6.6511E-03_JPRB/)
KBO( :, 1,54,11) = (/&
&1.8954E-03_JPRB,2.2607E-03_JPRB,1.8278E-03_JPRB,1.1946E-03_JPRB,1.0985E-03_JPRB/)
KBO( :, 2,54,11) = (/&
&3.5862E-03_JPRB,4.3471E-03_JPRB,3.5189E-03_JPRB,2.2822E-03_JPRB,1.6895E-03_JPRB/)
KBO( :, 3,54,11) = (/&
&6.6312E-03_JPRB,8.0424E-03_JPRB,6.4523E-03_JPRB,4.1406E-03_JPRB,2.5940E-03_JPRB/)
KBO( :, 4,54,11) = (/&
&1.1671E-02_JPRB,1.4089E-02_JPRB,1.1281E-02_JPRB,7.2279E-03_JPRB,3.9122E-03_JPRB/)
KBO( :, 5,54,11) = (/&
&1.9432E-02_JPRB,2.3598E-02_JPRB,1.8940E-02_JPRB,1.2154E-02_JPRB,5.7337E-03_JPRB/)
KBO( :, 1,55,11) = (/&
&1.4290E-03_JPRB,1.7125E-03_JPRB,1.3776E-03_JPRB,8.9347E-04_JPRB,9.3784E-04_JPRB/)
KBO( :, 2,55,11) = (/&
&2.7457E-03_JPRB,3.3623E-03_JPRB,2.7182E-03_JPRB,1.7597E-03_JPRB,1.4453E-03_JPRB/)
KBO( :, 3,55,11) = (/&
&5.1874E-03_JPRB,6.3979E-03_JPRB,5.1511E-03_JPRB,3.2930E-03_JPRB,2.2221E-03_JPRB/)
KBO( :, 4,55,11) = (/&
&9.4226E-03_JPRB,1.1550E-02_JPRB,9.2557E-03_JPRB,5.8990E-03_JPRB,3.3851E-03_JPRB/)
KBO( :, 5,55,11) = (/&
&1.6150E-02_JPRB,1.9777E-02_JPRB,1.5877E-02_JPRB,1.0138E-02_JPRB,5.0396E-03_JPRB/)
KBO( :, 1,56,11) = (/&
&1.0680E-03_JPRB,1.2890E-03_JPRB,1.0316E-03_JPRB,6.6446E-04_JPRB,8.0430E-04_JPRB/)
KBO( :, 2,56,11) = (/&
&2.0978E-03_JPRB,2.5858E-03_JPRB,2.0823E-03_JPRB,1.3442E-03_JPRB,1.2456E-03_JPRB/)
KBO( :, 3,56,11) = (/&
&4.0301E-03_JPRB,5.0435E-03_JPRB,4.0770E-03_JPRB,2.5996E-03_JPRB,1.9142E-03_JPRB/)
KBO( :, 4,56,11) = (/&
&7.5402E-03_JPRB,9.4035E-03_JPRB,7.5479E-03_JPRB,4.7898E-03_JPRB,2.9393E-03_JPRB/)
KBO( :, 5,56,11) = (/&
&1.3330E-02_JPRB,1.6498E-02_JPRB,1.3248E-02_JPRB,8.4281E-03_JPRB,4.4305E-03_JPRB/)
KBO( :, 1,57,11) = (/&
&7.8801E-04_JPRB,9.6289E-04_JPRB,7.6691E-04_JPRB,4.9097E-04_JPRB,6.8859E-04_JPRB/)
KBO( :, 2,57,11) = (/&
&1.5966E-03_JPRB,1.9777E-03_JPRB,1.5840E-03_JPRB,1.0164E-03_JPRB,1.0803E-03_JPRB/)
KBO( :, 3,57,11) = (/&
&3.1118E-03_JPRB,3.9473E-03_JPRB,3.1938E-03_JPRB,2.0343E-03_JPRB,1.6622E-03_JPRB/)
KBO( :, 4,57,11) = (/&
&5.9752E-03_JPRB,7.5907E-03_JPRB,6.1119E-03_JPRB,3.8625E-03_JPRB,2.5583E-03_JPRB/)
KBO( :, 5,57,11) = (/&
&1.0909E-02_JPRB,1.3694E-02_JPRB,1.0990E-02_JPRB,6.9630E-03_JPRB,3.8987E-03_JPRB/)
KBO( :, 1,58,11) = (/&
&5.8173E-04_JPRB,7.2041E-04_JPRB,5.7279E-04_JPRB,3.6474E-04_JPRB,5.9355E-04_JPRB/)
KBO( :, 2,58,11) = (/&
&1.2258E-03_JPRB,1.5249E-03_JPRB,1.2145E-03_JPRB,7.7245E-04_JPRB,9.5456E-04_JPRB/)
KBO( :, 3,58,11) = (/&
&2.4241E-03_JPRB,3.1044E-03_JPRB,2.5087E-03_JPRB,1.5934E-03_JPRB,1.4697E-03_JPRB/)
KBO( :, 4,58,11) = (/&
&4.7512E-03_JPRB,6.1351E-03_JPRB,4.9587E-03_JPRB,3.1245E-03_JPRB,2.2636E-03_JPRB/)
KBO( :, 5,58,11) = (/&
&8.9451E-03_JPRB,1.1404E-02_JPRB,9.1570E-03_JPRB,5.7752E-03_JPRB,3.4844E-03_JPRB/)
KBO( :, 1,59,11) = (/&
&5.0522E-04_JPRB,6.3041E-04_JPRB,4.9923E-04_JPRB,3.1529E-04_JPRB,5.7581E-04_JPRB/)
KBO( :, 2,59,11) = (/&
&1.0885E-03_JPRB,1.3595E-03_JPRB,1.0775E-03_JPRB,6.7742E-04_JPRB,9.3929E-04_JPRB/)
KBO( :, 3,59,11) = (/&
&2.1758E-03_JPRB,2.7928E-03_JPRB,2.2487E-03_JPRB,1.4181E-03_JPRB,1.4518E-03_JPRB/)
KBO( :, 4,59,11) = (/&
&4.2933E-03_JPRB,5.5813E-03_JPRB,4.5166E-03_JPRB,2.8320E-03_JPRB,2.2456E-03_JPRB/)
KBO( :, 5,59,11) = (/&
&8.1802E-03_JPRB,1.0526E-02_JPRB,8.4597E-03_JPRB,5.3170E-03_JPRB,3.4840E-03_JPRB/)
KBO( :, 1,13,12) = (/&
&7.9228E-01_JPRB,6.7739E-01_JPRB,5.9851E-01_JPRB,4.7753E-01_JPRB,2.7637E+00_JPRB/)
KBO( :, 2,13,12) = (/&
&1.1298E+00_JPRB,9.7146E-01_JPRB,8.5148E-01_JPRB,6.6642E-01_JPRB,2.9701E+00_JPRB/)
KBO( :, 3,13,12) = (/&
&1.5315E+00_JPRB,1.3283E+00_JPRB,1.1586E+00_JPRB,8.9312E-01_JPRB,3.2188E+00_JPRB/)
KBO( :, 4,13,12) = (/&
&1.9944E+00_JPRB,1.7422E+00_JPRB,1.5174E+00_JPRB,1.1641E+00_JPRB,3.5302E+00_JPRB/)
KBO( :, 5,13,12) = (/&
&2.5089E+00_JPRB,2.2052E+00_JPRB,1.9170E+00_JPRB,1.4741E+00_JPRB,3.8622E+00_JPRB/)
KBO( :, 1,14,12) = (/&
&8.3949E-01_JPRB,7.3093E-01_JPRB,6.4746E-01_JPRB,4.9215E-01_JPRB,2.7289E+00_JPRB/)
KBO( :, 2,14,12) = (/&
&1.1838E+00_JPRB,1.0392E+00_JPRB,9.1530E-01_JPRB,6.8593E-01_JPRB,2.9374E+00_JPRB/)
KBO( :, 3,14,12) = (/&
&1.5936E+00_JPRB,1.4080E+00_JPRB,1.2362E+00_JPRB,9.1792E-01_JPRB,3.1661E+00_JPRB/)
KBO( :, 4,14,12) = (/&
&2.0618E+00_JPRB,1.8318E+00_JPRB,1.6006E+00_JPRB,1.1951E+00_JPRB,3.4133E+00_JPRB/)
KBO( :, 5,14,12) = (/&
&2.5782E+00_JPRB,2.3016E+00_JPRB,2.0067E+00_JPRB,1.5032E+00_JPRB,3.6330E+00_JPRB/)
KBO( :, 1,15,12) = (/&
&8.6850E-01_JPRB,7.7816E-01_JPRB,6.8988E-01_JPRB,5.1142E-01_JPRB,2.4839E+00_JPRB/)
KBO( :, 2,15,12) = (/&
&1.2152E+00_JPRB,1.0938E+00_JPRB,9.6727E-01_JPRB,7.1145E-01_JPRB,2.6794E+00_JPRB/)
KBO( :, 3,15,12) = (/&
&1.6231E+00_JPRB,1.4682E+00_JPRB,1.2912E+00_JPRB,9.5405E-01_JPRB,2.8636E+00_JPRB/)
KBO( :, 4,15,12) = (/&
&2.0833E+00_JPRB,1.8933E+00_JPRB,1.6562E+00_JPRB,1.2315E+00_JPRB,3.0203E+00_JPRB/)
KBO( :, 5,15,12) = (/&
&2.5907E+00_JPRB,2.3660E+00_JPRB,2.0692E+00_JPRB,1.5407E+00_JPRB,3.1955E+00_JPRB/)
KBO( :, 1,16,12) = (/&
&8.7903E-01_JPRB,8.1154E-01_JPRB,7.2017E-01_JPRB,5.2966E-01_JPRB,2.1487E+00_JPRB/)
KBO( :, 2,16,12) = (/&
&1.2196E+00_JPRB,1.1290E+00_JPRB,9.9867E-01_JPRB,7.3589E-01_JPRB,2.2979E+00_JPRB/)
KBO( :, 3,16,12) = (/&
&1.6158E+00_JPRB,1.5020E+00_JPRB,1.3215E+00_JPRB,9.8028E-01_JPRB,2.4332E+00_JPRB/)
KBO( :, 4,16,12) = (/&
&2.0608E+00_JPRB,1.9258E+00_JPRB,1.6884E+00_JPRB,1.2547E+00_JPRB,2.5777E+00_JPRB/)
KBO( :, 5,16,12) = (/&
&2.5444E+00_JPRB,2.3922E+00_JPRB,2.0979E+00_JPRB,1.5613E+00_JPRB,2.7073E+00_JPRB/)
KBO( :, 1,17,12) = (/&
&8.6797E-01_JPRB,8.2657E-01_JPRB,7.3338E-01_JPRB,5.3823E-01_JPRB,1.8450E+00_JPRB/)
KBO( :, 2,17,12) = (/&
&1.1929E+00_JPRB,1.1407E+00_JPRB,1.0074E+00_JPRB,7.4525E-01_JPRB,1.9691E+00_JPRB/)
KBO( :, 3,17,12) = (/&
&1.5694E+00_JPRB,1.5051E+00_JPRB,1.3270E+00_JPRB,9.8535E-01_JPRB,2.0903E+00_JPRB/)
KBO( :, 4,17,12) = (/&
&1.9886E+00_JPRB,1.9165E+00_JPRB,1.6896E+00_JPRB,1.2533E+00_JPRB,2.2071E+00_JPRB/)
KBO( :, 5,17,12) = (/&
&2.4525E+00_JPRB,2.3619E+00_JPRB,2.0849E+00_JPRB,1.5524E+00_JPRB,2.3229E+00_JPRB/)
KBO( :, 1,18,12) = (/&
&8.3385E-01_JPRB,8.2168E-01_JPRB,7.2749E-01_JPRB,5.3649E-01_JPRB,1.6234E+00_JPRB/)
KBO( :, 2,18,12) = (/&
&1.1389E+00_JPRB,1.1231E+00_JPRB,9.9306E-01_JPRB,7.3634E-01_JPRB,1.7307E+00_JPRB/)
KBO( :, 3,18,12) = (/&
&1.4887E+00_JPRB,1.4739E+00_JPRB,1.3034E+00_JPRB,9.6635E-01_JPRB,1.8435E+00_JPRB/)
KBO( :, 4,18,12) = (/&
&1.8815E+00_JPRB,1.8634E+00_JPRB,1.6522E+00_JPRB,1.2254E+00_JPRB,1.9484E+00_JPRB/)
KBO( :, 5,18,12) = (/&
&2.3106E+00_JPRB,2.2920E+00_JPRB,2.0285E+00_JPRB,1.5162E+00_JPRB,2.0551E+00_JPRB/)
KBO( :, 1,19,12) = (/&
&7.8530E-01_JPRB,7.9679E-01_JPRB,7.0528E-01_JPRB,5.2265E-01_JPRB,1.4533E+00_JPRB/)
KBO( :, 2,19,12) = (/&
&1.0644E+00_JPRB,1.0830E+00_JPRB,9.5920E-01_JPRB,7.1045E-01_JPRB,1.5651E+00_JPRB/)
KBO( :, 3,19,12) = (/&
&1.3856E+00_JPRB,1.4087E+00_JPRB,1.2542E+00_JPRB,9.2677E-01_JPRB,1.6748E+00_JPRB/)
KBO( :, 4,19,12) = (/&
&1.7452E+00_JPRB,1.7745E+00_JPRB,1.5782E+00_JPRB,1.1737E+00_JPRB,1.7839E+00_JPRB/)
KBO( :, 5,19,12) = (/&
&2.1398E+00_JPRB,2.1794E+00_JPRB,1.9373E+00_JPRB,1.4553E+00_JPRB,1.9023E+00_JPRB/)
KBO( :, 1,20,12) = (/&
&7.2778E-01_JPRB,7.6194E-01_JPRB,6.7390E-01_JPRB,5.0077E-01_JPRB,1.3617E+00_JPRB/)
KBO( :, 2,20,12) = (/&
&9.8068E-01_JPRB,1.0262E+00_JPRB,9.1245E-01_JPRB,6.7491E-01_JPRB,1.4807E+00_JPRB/)
KBO( :, 3,20,12) = (/&
&1.2722E+00_JPRB,1.3293E+00_JPRB,1.1831E+00_JPRB,8.7574E-01_JPRB,1.5966E+00_JPRB/)
KBO( :, 4,20,12) = (/&
&1.5991E+00_JPRB,1.6714E+00_JPRB,1.4853E+00_JPRB,1.1090E+00_JPRB,1.7163E+00_JPRB/)
KBO( :, 5,20,12) = (/&
&1.9535E+00_JPRB,2.0500E+00_JPRB,1.8231E+00_JPRB,1.3754E+00_JPRB,1.8494E+00_JPRB/)
KBO( :, 1,21,12) = (/&
&6.6504E-01_JPRB,7.1378E-01_JPRB,6.3305E-01_JPRB,4.7002E-01_JPRB,1.2946E+00_JPRB/)
KBO( :, 2,21,12) = (/&
&8.9278E-01_JPRB,9.5693E-01_JPRB,8.4967E-01_JPRB,6.2960E-01_JPRB,1.4170E+00_JPRB/)
KBO( :, 3,21,12) = (/&
&1.1553E+00_JPRB,1.2382E+00_JPRB,1.0968E+00_JPRB,8.1599E-01_JPRB,1.5400E+00_JPRB/)
KBO( :, 4,21,12) = (/&
&1.4482E+00_JPRB,1.5551E+00_JPRB,1.3761E+00_JPRB,1.0330E+00_JPRB,1.6737E+00_JPRB/)
KBO( :, 5,21,12) = (/&
&1.7635E+00_JPRB,1.8984E+00_JPRB,1.6920E+00_JPRB,1.2782E+00_JPRB,1.8148E+00_JPRB/)
KBO( :, 1,22,12) = (/&
&6.1409E-01_JPRB,6.7210E-01_JPRB,5.9517E-01_JPRB,4.4205E-01_JPRB,1.2140E+00_JPRB/)
KBO( :, 2,22,12) = (/&
&8.2009E-01_JPRB,8.9690E-01_JPRB,7.9134E-01_JPRB,5.8900E-01_JPRB,1.3388E+00_JPRB/)
KBO( :, 3,22,12) = (/&
&1.0573E+00_JPRB,1.1562E+00_JPRB,1.0170E+00_JPRB,7.6239E-01_JPRB,1.4674E+00_JPRB/)
KBO( :, 4,22,12) = (/&
&1.3173E+00_JPRB,1.4441E+00_JPRB,1.2773E+00_JPRB,9.6111E-01_JPRB,1.6103E+00_JPRB/)
KBO( :, 5,22,12) = (/&
&1.6008E+00_JPRB,1.7593E+00_JPRB,1.5714E+00_JPRB,1.1859E+00_JPRB,1.7554E+00_JPRB/)
KBO( :, 1,23,12) = (/&
&5.6489E-01_JPRB,6.2643E-01_JPRB,5.5181E-01_JPRB,4.1055E-01_JPRB,1.1296E+00_JPRB/)
KBO( :, 2,23,12) = (/&
&7.5136E-01_JPRB,8.3205E-01_JPRB,7.2882E-01_JPRB,5.4587E-01_JPRB,1.2556E+00_JPRB/)
KBO( :, 3,23,12) = (/&
&9.6147E-01_JPRB,1.0673E+00_JPRB,9.3622E-01_JPRB,7.0474E-01_JPRB,1.3939E+00_JPRB/)
KBO( :, 4,23,12) = (/&
&1.1945E+00_JPRB,1.3292E+00_JPRB,1.1758E+00_JPRB,8.8540E-01_JPRB,1.5380E+00_JPRB/)
KBO( :, 5,23,12) = (/&
&1.4498E+00_JPRB,1.6203E+00_JPRB,1.4443E+00_JPRB,1.0897E+00_JPRB,1.6879E+00_JPRB/)
KBO( :, 1,24,12) = (/&
&5.2019E-01_JPRB,5.8108E-01_JPRB,5.0714E-01_JPRB,3.7894E-01_JPRB,1.0335E+00_JPRB/)
KBO( :, 2,24,12) = (/&
&6.8678E-01_JPRB,7.6753E-01_JPRB,6.6836E-01_JPRB,5.0261E-01_JPRB,1.1623E+00_JPRB/)
KBO( :, 3,24,12) = (/&
&8.7490E-01_JPRB,9.8000E-01_JPRB,8.5888E-01_JPRB,6.4559E-01_JPRB,1.3047E+00_JPRB/)
KBO( :, 4,24,12) = (/&
&1.0855E+00_JPRB,1.2194E+00_JPRB,1.0757E+00_JPRB,8.1029E-01_JPRB,1.4513E+00_JPRB/)
KBO( :, 5,24,12) = (/&
&1.3195E+00_JPRB,1.4875E+00_JPRB,1.3176E+00_JPRB,9.9617E-01_JPRB,1.6042E+00_JPRB/)
KBO( :, 1,25,12) = (/&
&4.8125E-01_JPRB,5.3776E-01_JPRB,4.6543E-01_JPRB,3.4920E-01_JPRB,9.4296E-01_JPRB/)
KBO( :, 2,25,12) = (/&
&6.3062E-01_JPRB,7.0671E-01_JPRB,6.1374E-01_JPRB,4.6025E-01_JPRB,1.0786E+00_JPRB/)
KBO( :, 3,25,12) = (/&
&8.0138E-01_JPRB,8.9961E-01_JPRB,7.8690E-01_JPRB,5.8999E-01_JPRB,1.2219E+00_JPRB/)
KBO( :, 4,25,12) = (/&
&9.9501E-01_JPRB,1.1200E+00_JPRB,9.8131E-01_JPRB,7.3979E-01_JPRB,1.3746E+00_JPRB/)
KBO( :, 5,25,12) = (/&
&1.2133E+00_JPRB,1.3690E+00_JPRB,1.2002E+00_JPRB,9.0848E-01_JPRB,1.5310E+00_JPRB/)
KBO( :, 1,26,12) = (/&
&4.4718E-01_JPRB,5.0045E-01_JPRB,4.3026E-01_JPRB,3.2190E-01_JPRB,8.7401E-01_JPRB/)
KBO( :, 2,26,12) = (/&
&5.8377E-01_JPRB,6.5329E-01_JPRB,5.6669E-01_JPRB,4.2222E-01_JPRB,1.0132E+00_JPRB/)
KBO( :, 3,26,12) = (/&
&7.4225E-01_JPRB,8.3122E-01_JPRB,7.2142E-01_JPRB,5.4093E-01_JPRB,1.1599E+00_JPRB/)
KBO( :, 4,26,12) = (/&
&9.2576E-01_JPRB,1.0363E+00_JPRB,8.9875E-01_JPRB,6.7651E-01_JPRB,1.3150E+00_JPRB/)
KBO( :, 5,26,12) = (/&
&1.1359E+00_JPRB,1.2689E+00_JPRB,1.1003E+00_JPRB,8.3128E-01_JPRB,1.4725E+00_JPRB/)
KBO( :, 1,27,12) = (/&
&4.1742E-01_JPRB,4.6589E-01_JPRB,4.0014E-01_JPRB,2.9607E-01_JPRB,8.0311E-01_JPRB/)
KBO( :, 2,27,12) = (/&
&5.4534E-01_JPRB,6.0694E-01_JPRB,5.2254E-01_JPRB,3.8814E-01_JPRB,9.3748E-01_JPRB/)
KBO( :, 3,27,12) = (/&
&6.9705E-01_JPRB,7.7317E-01_JPRB,6.6432E-01_JPRB,4.9566E-01_JPRB,1.0808E+00_JPRB/)
KBO( :, 4,27,12) = (/&
&8.7421E-01_JPRB,9.6588E-01_JPRB,8.2816E-01_JPRB,6.1915E-01_JPRB,1.2270E+00_JPRB/)
KBO( :, 5,27,12) = (/&
&1.0783E+00_JPRB,1.1900E+00_JPRB,1.0151E+00_JPRB,7.6356E-01_JPRB,1.3781E+00_JPRB/)
KBO( :, 1,28,12) = (/&
&3.9237E-01_JPRB,4.3515E-01_JPRB,3.7248E-01_JPRB,2.7305E-01_JPRB,7.2280E-01_JPRB/)
KBO( :, 2,28,12) = (/&
&5.1563E-01_JPRB,5.6757E-01_JPRB,4.8403E-01_JPRB,3.5700E-01_JPRB,8.4677E-01_JPRB/)
KBO( :, 3,28,12) = (/&
&6.6308E-01_JPRB,7.2519E-01_JPRB,6.1590E-01_JPRB,4.5472E-01_JPRB,9.7710E-01_JPRB/)
KBO( :, 4,28,12) = (/&
&8.3646E-01_JPRB,9.1152E-01_JPRB,7.6997E-01_JPRB,5.6988E-01_JPRB,1.1096E+00_JPRB/)
KBO( :, 5,28,12) = (/&
&1.0359E+00_JPRB,1.1276E+00_JPRB,9.4962E-01_JPRB,7.0526E-01_JPRB,1.2485E+00_JPRB/)
KBO( :, 1,29,12) = (/&
&3.7279E-01_JPRB,4.1014E-01_JPRB,3.4774E-01_JPRB,2.5341E-01_JPRB,6.3269E-01_JPRB/)
KBO( :, 2,29,12) = (/&
&4.9283E-01_JPRB,5.3769E-01_JPRB,4.5233E-01_JPRB,3.3021E-01_JPRB,7.4294E-01_JPRB/)
KBO( :, 3,29,12) = (/&
&6.3731E-01_JPRB,6.8994E-01_JPRB,5.7780E-01_JPRB,4.2070E-01_JPRB,8.5678E-01_JPRB/)
KBO( :, 4,29,12) = (/&
&8.0637E-01_JPRB,8.7025E-01_JPRB,7.2644E-01_JPRB,5.2908E-01_JPRB,9.7595E-01_JPRB/)
KBO( :, 5,29,12) = (/&
&9.9943E-01_JPRB,1.0813E+00_JPRB,9.0128E-01_JPRB,6.5866E-01_JPRB,1.1019E+00_JPRB/)
KBO( :, 1,30,12) = (/&
&3.5722E-01_JPRB,3.9080E-01_JPRB,3.2710E-01_JPRB,2.3601E-01_JPRB,5.4037E-01_JPRB/)
KBO( :, 2,30,12) = (/&
&4.7448E-01_JPRB,5.1429E-01_JPRB,4.2783E-01_JPRB,3.0716E-01_JPRB,6.3503E-01_JPRB/)
KBO( :, 3,30,12) = (/&
&6.1439E-01_JPRB,6.6308E-01_JPRB,5.4920E-01_JPRB,3.9345E-01_JPRB,7.3381E-01_JPRB/)
KBO( :, 4,30,12) = (/&
&7.7644E-01_JPRB,8.4062E-01_JPRB,6.9350E-01_JPRB,4.9782E-01_JPRB,8.4010E-01_JPRB/)
KBO( :, 5,30,12) = (/&
&9.6226E-01_JPRB,1.0478E+00_JPRB,8.6468E-01_JPRB,6.2256E-01_JPRB,9.5398E-01_JPRB/)
KBO( :, 1,31,12) = (/&
&3.4498E-01_JPRB,3.7545E-01_JPRB,3.1150E-01_JPRB,2.2122E-01_JPRB,4.4905E-01_JPRB/)
KBO( :, 2,31,12) = (/&
&4.5820E-01_JPRB,4.9653E-01_JPRB,4.0983E-01_JPRB,2.8888E-01_JPRB,5.2917E-01_JPRB/)
KBO( :, 3,31,12) = (/&
&5.9170E-01_JPRB,6.4378E-01_JPRB,5.2810E-01_JPRB,3.7284E-01_JPRB,6.1590E-01_JPRB/)
KBO( :, 4,31,12) = (/&
&7.4787E-01_JPRB,8.1835E-01_JPRB,6.7064E-01_JPRB,4.7448E-01_JPRB,7.0953E-01_JPRB/)
KBO( :, 5,31,12) = (/&
&9.2776E-01_JPRB,1.0238E+00_JPRB,8.4020E-01_JPRB,5.9540E-01_JPRB,8.0850E-01_JPRB/)
KBO( :, 1,32,12) = (/&
&3.3387E-01_JPRB,3.6397E-01_JPRB,2.9979E-01_JPRB,2.0962E-01_JPRB,3.7307E-01_JPRB/)
KBO( :, 2,32,12) = (/&
&4.4163E-01_JPRB,4.8363E-01_JPRB,3.9607E-01_JPRB,2.7594E-01_JPRB,4.4216E-01_JPRB/)
KBO( :, 3,32,12) = (/&
&5.7015E-01_JPRB,6.2876E-01_JPRB,5.1363E-01_JPRB,3.5765E-01_JPRB,5.1788E-01_JPRB/)
KBO( :, 4,32,12) = (/&
&7.2141E-01_JPRB,8.0151E-01_JPRB,6.5517E-01_JPRB,4.5717E-01_JPRB,6.0016E-01_JPRB/)
KBO( :, 5,32,12) = (/&
&8.9922E-01_JPRB,1.0062E+00_JPRB,8.2407E-01_JPRB,5.7459E-01_JPRB,6.8536E-01_JPRB/)
KBO( :, 1,33,12) = (/&
&3.2293E-01_JPRB,3.5547E-01_JPRB,2.9093E-01_JPRB,2.0149E-01_JPRB,3.0917E-01_JPRB/)
KBO( :, 2,33,12) = (/&
&4.2627E-01_JPRB,4.7355E-01_JPRB,3.8619E-01_JPRB,2.6640E-01_JPRB,3.6920E-01_JPRB/)
KBO( :, 3,33,12) = (/&
&5.5058E-01_JPRB,6.1665E-01_JPRB,5.0346E-01_JPRB,3.4679E-01_JPRB,4.3505E-01_JPRB/)
KBO( :, 4,33,12) = (/&
&6.9980E-01_JPRB,7.8852E-01_JPRB,6.4475E-01_JPRB,4.4442E-01_JPRB,5.0488E-01_JPRB/)
KBO( :, 5,33,12) = (/&
&8.7592E-01_JPRB,9.9390E-01_JPRB,8.1496E-01_JPRB,5.6029E-01_JPRB,5.7746E-01_JPRB/)
KBO( :, 1,34,12) = (/&
&3.0940E-01_JPRB,3.4528E-01_JPRB,2.8156E-01_JPRB,1.9363E-01_JPRB,2.6611E-01_JPRB/)
KBO( :, 2,34,12) = (/&
&4.0894E-01_JPRB,4.6074E-01_JPRB,3.7565E-01_JPRB,2.5763E-01_JPRB,3.1938E-01_JPRB/)
KBO( :, 3,34,12) = (/&
&5.3041E-01_JPRB,6.0251E-01_JPRB,4.9185E-01_JPRB,3.3679E-01_JPRB,3.7762E-01_JPRB/)
KBO( :, 4,34,12) = (/&
&6.7786E-01_JPRB,7.7350E-01_JPRB,6.3399E-01_JPRB,4.3276E-01_JPRB,4.3880E-01_JPRB/)
KBO( :, 5,34,12) = (/&
&8.5216E-01_JPRB,9.8050E-01_JPRB,8.0443E-01_JPRB,5.4758E-01_JPRB,5.0384E-01_JPRB/)
KBO( :, 1,35,12) = (/&
&2.8939E-01_JPRB,3.2702E-01_JPRB,2.6622E-01_JPRB,1.8249E-01_JPRB,2.2426E-01_JPRB/)
KBO( :, 2,35,12) = (/&
&3.8432E-01_JPRB,4.3860E-01_JPRB,3.5768E-01_JPRB,2.4461E-01_JPRB,2.7044E-01_JPRB/)
KBO( :, 3,35,12) = (/&
&5.0227E-01_JPRB,5.7687E-01_JPRB,4.7133E-01_JPRB,3.2156E-01_JPRB,3.2047E-01_JPRB/)
KBO( :, 4,35,12) = (/&
&6.4522E-01_JPRB,7.4630E-01_JPRB,6.1202E-01_JPRB,4.1516E-01_JPRB,3.7356E-01_JPRB/)
KBO( :, 5,35,12) = (/&
&8.1623E-01_JPRB,9.5325E-01_JPRB,7.8163E-01_JPRB,5.2821E-01_JPRB,4.3272E-01_JPRB/)
KBO( :, 1,36,12) = (/&
&2.6330E-01_JPRB,3.0070E-01_JPRB,2.4442E-01_JPRB,1.6757E-01_JPRB,1.8310E-01_JPRB/)
KBO( :, 2,36,12) = (/&
&3.5255E-01_JPRB,4.0667E-01_JPRB,3.3144E-01_JPRB,2.2644E-01_JPRB,2.2200E-01_JPRB/)
KBO( :, 3,36,12) = (/&
&4.6468E-01_JPRB,5.3948E-01_JPRB,4.4110E-01_JPRB,3.0012E-01_JPRB,2.6412E-01_JPRB/)
KBO( :, 4,36,12) = (/&
&6.0155E-01_JPRB,7.0486E-01_JPRB,5.7783E-01_JPRB,3.9058E-01_JPRB,3.1002E-01_JPRB/)
KBO( :, 5,36,12) = (/&
&7.6703E-01_JPRB,9.0873E-01_JPRB,7.4457E-01_JPRB,5.0060E-01_JPRB,3.6395E-01_JPRB/)
KBO( :, 1,37,12) = (/&
&2.3001E-01_JPRB,2.6442E-01_JPRB,2.1459E-01_JPRB,1.4727E-01_JPRB,1.5536E-01_JPRB/)
KBO( :, 2,37,12) = (/&
&3.1096E-01_JPRB,3.6197E-01_JPRB,2.9461E-01_JPRB,2.0129E-01_JPRB,1.9004E-01_JPRB/)
KBO( :, 3,37,12) = (/&
&4.1431E-01_JPRB,4.8589E-01_JPRB,3.9700E-01_JPRB,2.7000E-01_JPRB,2.2800E-01_JPRB/)
KBO( :, 4,37,12) = (/&
&5.4226E-01_JPRB,6.4266E-01_JPRB,5.2665E-01_JPRB,3.5524E-01_JPRB,2.6910E-01_JPRB/)
KBO( :, 5,37,12) = (/&
&6.9841E-01_JPRB,8.3797E-01_JPRB,6.8663E-01_JPRB,4.5963E-01_JPRB,3.1774E-01_JPRB/)
KBO( :, 1,38,12) = (/&
&2.0134E-01_JPRB,2.3227E-01_JPRB,1.8814E-01_JPRB,1.2935E-01_JPRB,1.3137E-01_JPRB/)
KBO( :, 2,38,12) = (/&
&2.7468E-01_JPRB,3.2208E-01_JPRB,2.6174E-01_JPRB,1.7891E-01_JPRB,1.6217E-01_JPRB/)
KBO( :, 3,38,12) = (/&
&3.6956E-01_JPRB,4.3776E-01_JPRB,3.5733E-01_JPRB,2.4289E-01_JPRB,1.9623E-01_JPRB/)
KBO( :, 4,38,12) = (/&
&4.8896E-01_JPRB,5.8640E-01_JPRB,4.8002E-01_JPRB,3.2349E-01_JPRB,2.3300E-01_JPRB/)
KBO( :, 5,38,12) = (/&
&6.3666E-01_JPRB,7.7346E-01_JPRB,6.3380E-01_JPRB,4.2286E-01_JPRB,2.7663E-01_JPRB/)
KBO( :, 1,39,12) = (/&
&1.7697E-01_JPRB,2.0467E-01_JPRB,1.6540E-01_JPRB,1.1386E-01_JPRB,1.1007E-01_JPRB/)
KBO( :, 2,39,12) = (/&
&2.4368E-01_JPRB,2.8735E-01_JPRB,2.3319E-01_JPRB,1.5947E-01_JPRB,1.3719E-01_JPRB/)
KBO( :, 3,39,12) = (/&
&3.3092E-01_JPRB,3.9580E-01_JPRB,3.2268E-01_JPRB,2.1918E-01_JPRB,1.6720E-01_JPRB/)
KBO( :, 4,39,12) = (/&
&4.4249E-01_JPRB,5.3699E-01_JPRB,4.3914E-01_JPRB,2.9552E-01_JPRB,1.9987E-01_JPRB/)
KBO( :, 5,39,12) = (/&
&5.8226E-01_JPRB,7.1600E-01_JPRB,5.8709E-01_JPRB,3.9058E-01_JPRB,2.3879E-01_JPRB/)
KBO( :, 1,40,12) = (/&
&1.5084E-01_JPRB,1.7449E-01_JPRB,1.4045E-01_JPRB,9.6794E-02_JPRB,9.3392E-02_JPRB/)
KBO( :, 2,40,12) = (/&
&2.1010E-01_JPRB,2.4822E-01_JPRB,2.0097E-01_JPRB,1.3766E-01_JPRB,1.1767E-01_JPRB/)
KBO( :, 3,40,12) = (/&
&2.8835E-01_JPRB,3.4716E-01_JPRB,2.8248E-01_JPRB,1.9197E-01_JPRB,1.4495E-01_JPRB/)
KBO( :, 4,40,12) = (/&
&3.8988E-01_JPRB,4.7789E-01_JPRB,3.9037E-01_JPRB,2.6261E-01_JPRB,1.7468E-01_JPRB/)
KBO( :, 5,40,12) = (/&
&5.1945E-01_JPRB,6.4586E-01_JPRB,5.2903E-01_JPRB,3.5162E-01_JPRB,2.0975E-01_JPRB/)
KBO( :, 1,41,12) = (/&
&1.2817E-01_JPRB,1.4829E-01_JPRB,1.1887E-01_JPRB,8.1840E-02_JPRB,7.9057E-02_JPRB/)
KBO( :, 2,41,12) = (/&
&1.8060E-01_JPRB,2.1362E-01_JPRB,1.7247E-01_JPRB,1.1830E-01_JPRB,1.0081E-01_JPRB/)
KBO( :, 3,41,12) = (/&
&2.5080E-01_JPRB,3.0334E-01_JPRB,2.4634E-01_JPRB,1.6753E-01_JPRB,1.2548E-01_JPRB/)
KBO( :, 4,41,12) = (/&
&3.4280E-01_JPRB,4.2376E-01_JPRB,3.4586E-01_JPRB,2.3251E-01_JPRB,1.5256E-01_JPRB/)
KBO( :, 5,41,12) = (/&
&4.6230E-01_JPRB,5.8070E-01_JPRB,4.7518E-01_JPRB,3.1572E-01_JPRB,1.8431E-01_JPRB/)
KBO( :, 1,42,12) = (/&
&1.0893E-01_JPRB,1.2613E-01_JPRB,1.0083E-01_JPRB,6.9157E-02_JPRB,6.6394E-02_JPRB/)
KBO( :, 2,42,12) = (/&
&1.5547E-01_JPRB,1.8415E-01_JPRB,1.4803E-01_JPRB,1.0161E-01_JPRB,8.5777E-02_JPRB/)
KBO( :, 3,42,12) = (/&
&2.1846E-01_JPRB,2.6502E-01_JPRB,2.1486E-01_JPRB,1.4627E-01_JPRB,1.0794E-01_JPRB/)
KBO( :, 4,42,12) = (/&
&3.0198E-01_JPRB,3.7587E-01_JPRB,3.0638E-01_JPRB,2.0583E-01_JPRB,1.3247E-01_JPRB/)
KBO( :, 5,42,12) = (/&
&4.1199E-01_JPRB,5.2225E-01_JPRB,4.2709E-01_JPRB,2.8351E-01_JPRB,1.6111E-01_JPRB/)
KBO( :, 1,43,12) = (/&
&9.0638E-02_JPRB,1.0503E-01_JPRB,8.3795E-02_JPRB,5.7071E-02_JPRB,5.5354E-02_JPRB/)
KBO( :, 2,43,12) = (/&
&1.3131E-01_JPRB,1.5548E-01_JPRB,1.2458E-01_JPRB,8.5364E-02_JPRB,7.2576E-02_JPRB/)
KBO( :, 3,43,12) = (/&
&1.8681E-01_JPRB,2.2707E-01_JPRB,1.8347E-01_JPRB,1.2501E-01_JPRB,9.2538E-02_JPRB/)
KBO( :, 4,43,12) = (/&
&2.6160E-01_JPRB,3.2672E-01_JPRB,2.6595E-01_JPRB,1.7876E-01_JPRB,1.1500E-01_JPRB/)
KBO( :, 5,43,12) = (/&
&3.6120E-01_JPRB,4.6097E-01_JPRB,3.7669E-01_JPRB,2.4999E-01_JPRB,1.4075E-01_JPRB/)
KBO( :, 1,44,12) = (/&
&7.4518E-02_JPRB,8.6409E-02_JPRB,6.8952E-02_JPRB,4.6577E-02_JPRB,4.5787E-02_JPRB/)
KBO( :, 2,44,12) = (/&
&1.0975E-01_JPRB,1.2994E-01_JPRB,1.0385E-01_JPRB,7.0835E-02_JPRB,6.0976E-02_JPRB/)
KBO( :, 3,44,12) = (/&
&1.5828E-01_JPRB,1.9250E-01_JPRB,1.5506E-01_JPRB,1.0558E-01_JPRB,7.8936E-02_JPRB/)
KBO( :, 4,44,12) = (/&
&2.2471E-01_JPRB,2.8098E-01_JPRB,2.2821E-01_JPRB,1.5365E-01_JPRB,9.9460E-02_JPRB/)
KBO( :, 5,44,12) = (/&
&3.1406E-01_JPRB,4.0269E-01_JPRB,3.2871E-01_JPRB,2.1813E-01_JPRB,1.2276E-01_JPRB/)
KBO( :, 1,45,12) = (/&
&6.0927E-02_JPRB,7.0888E-02_JPRB,5.6604E-02_JPRB,3.8007E-02_JPRB,3.7451E-02_JPRB/)
KBO( :, 2,45,12) = (/&
&9.1562E-02_JPRB,1.0848E-01_JPRB,8.6563E-02_JPRB,5.8638E-02_JPRB,5.0739E-02_JPRB/)
KBO( :, 3,45,12) = (/&
&1.3401E-01_JPRB,1.6305E-01_JPRB,1.3093E-01_JPRB,8.8909E-02_JPRB,6.6645E-02_JPRB/)
KBO( :, 4,45,12) = (/&
&1.9278E-01_JPRB,2.4132E-01_JPRB,1.9538E-01_JPRB,1.3171E-01_JPRB,8.5195E-02_JPRB/)
KBO( :, 5,45,12) = (/&
&2.7301E-01_JPRB,3.5087E-01_JPRB,2.8599E-01_JPRB,1.8994E-01_JPRB,1.0627E-01_JPRB/)
KBO( :, 1,46,12) = (/&
&4.9049E-02_JPRB,5.7390E-02_JPRB,4.5841E-02_JPRB,3.0652E-02_JPRB,3.0244E-02_JPRB/)
KBO( :, 2,46,12) = (/&
&7.5395E-02_JPRB,8.9544E-02_JPRB,7.1479E-02_JPRB,4.8016E-02_JPRB,4.1812E-02_JPRB/)
KBO( :, 3,46,12) = (/&
&1.1243E-01_JPRB,1.3673E-01_JPRB,1.0940E-01_JPRB,7.3992E-02_JPRB,5.5802E-02_JPRB/)
KBO( :, 4,46,12) = (/&
&1.6385E-01_JPRB,2.0515E-01_JPRB,1.6554E-01_JPRB,1.1163E-01_JPRB,7.2384E-02_JPRB/)
KBO( :, 5,46,12) = (/&
&2.3535E-01_JPRB,3.0228E-01_JPRB,2.4596E-01_JPRB,1.6359E-01_JPRB,9.1350E-02_JPRB/)
KBO( :, 1,47,12) = (/&
&3.8455E-02_JPRB,4.5311E-02_JPRB,3.6191E-02_JPRB,2.4099E-02_JPRB,2.4180E-02_JPRB/)
KBO( :, 2,47,12) = (/&
&6.0543E-02_JPRB,7.2219E-02_JPRB,5.7752E-02_JPRB,3.8501E-02_JPRB,3.4153E-02_JPRB/)
KBO( :, 3,47,12) = (/&
&9.2469E-02_JPRB,1.1229E-01_JPRB,8.9649E-02_JPRB,6.0326E-02_JPRB,4.6448E-02_JPRB/)
KBO( :, 4,47,12) = (/&
&1.3689E-01_JPRB,1.7102E-01_JPRB,1.3750E-01_JPRB,9.2547E-02_JPRB,6.1214E-02_JPRB/)
KBO( :, 5,47,12) = (/&
&1.9927E-01_JPRB,2.5535E-01_JPRB,2.0704E-01_JPRB,1.3818E-01_JPRB,7.8425E-02_JPRB/)
KBO( :, 1,48,12) = (/&
&2.9907E-02_JPRB,3.5538E-02_JPRB,2.8349E-02_JPRB,1.8781E-02_JPRB,1.9054E-02_JPRB/)
KBO( :, 2,48,12) = (/&
&4.8228E-02_JPRB,5.7904E-02_JPRB,4.6345E-02_JPRB,3.0764E-02_JPRB,2.7466E-02_JPRB/)
KBO( :, 3,48,12) = (/&
&7.5470E-02_JPRB,9.1806E-02_JPRB,7.3317E-02_JPRB,4.8995E-02_JPRB,3.8151E-02_JPRB/)
KBO( :, 4,48,12) = (/&
&1.1406E-01_JPRB,1.4204E-01_JPRB,1.1383E-01_JPRB,7.6343E-02_JPRB,5.1172E-02_JPRB/)
KBO( :, 5,48,12) = (/&
&1.6822E-01_JPRB,2.1497E-01_JPRB,1.7372E-01_JPRB,1.1607E-01_JPRB,6.6629E-02_JPRB/)
KBO( :, 1,49,12) = (/&
&2.3084E-02_JPRB,2.7602E-02_JPRB,2.2043E-02_JPRB,1.4515E-02_JPRB,1.4700E-02_JPRB/)
KBO( :, 2,49,12) = (/&
&3.8134E-02_JPRB,4.6138E-02_JPRB,3.6932E-02_JPRB,2.4422E-02_JPRB,2.1696E-02_JPRB/)
KBO( :, 3,49,12) = (/&
&6.1053E-02_JPRB,7.4691E-02_JPRB,5.9743E-02_JPRB,3.9618E-02_JPRB,3.0784E-02_JPRB/)
KBO( :, 4,49,12) = (/&
&9.4624E-02_JPRB,1.1747E-01_JPRB,9.3906E-02_JPRB,6.2717E-02_JPRB,4.2057E-02_JPRB/)
KBO( :, 5,49,12) = (/&
&1.4162E-01_JPRB,1.8031E-01_JPRB,1.4520E-01_JPRB,9.6951E-02_JPRB,5.5665E-02_JPRB/)
KBO( :, 1,50,12) = (/&
&1.7880E-02_JPRB,2.1522E-02_JPRB,1.7193E-02_JPRB,1.1281E-02_JPRB,1.1563E-02_JPRB/)
KBO( :, 2,50,12) = (/&
&3.0304E-02_JPRB,3.6988E-02_JPRB,2.9594E-02_JPRB,1.9489E-02_JPRB,1.7511E-02_JPRB/)
KBO( :, 3,50,12) = (/&
&4.9620E-02_JPRB,6.1130E-02_JPRB,4.8990E-02_JPRB,3.2313E-02_JPRB,2.5345E-02_JPRB/)
KBO( :, 4,50,12) = (/&
&7.8794E-02_JPRB,9.7813E-02_JPRB,7.8198E-02_JPRB,5.1943E-02_JPRB,3.5298E-02_JPRB/)
KBO( :, 5,50,12) = (/&
&1.2010E-01_JPRB,1.5227E-01_JPRB,1.2229E-01_JPRB,8.1438E-02_JPRB,4.7462E-02_JPRB/)
KBO( :, 1,51,12) = (/&
&1.3778E-02_JPRB,1.6753E-02_JPRB,1.3366E-02_JPRB,8.7587E-03_JPRB,9.1691E-03_JPRB/)
KBO( :, 2,51,12) = (/&
&2.4068E-02_JPRB,2.9598E-02_JPRB,2.3720E-02_JPRB,1.5531E-02_JPRB,1.4241E-02_JPRB/)
KBO( :, 3,51,12) = (/&
&4.0319E-02_JPRB,5.0023E-02_JPRB,4.0146E-02_JPRB,2.6379E-02_JPRB,2.1041E-02_JPRB/)
KBO( :, 4,51,12) = (/&
&6.5444E-02_JPRB,8.1559E-02_JPRB,6.5274E-02_JPRB,4.3107E-02_JPRB,2.9808E-02_JPRB/)
KBO( :, 5,51,12) = (/&
&1.0193E-01_JPRB,1.2878E-01_JPRB,1.0316E-01_JPRB,6.8485E-02_JPRB,4.0764E-02_JPRB/)
KBO( :, 1,52,12) = (/&
&1.0503E-02_JPRB,1.2908E-02_JPRB,1.0296E-02_JPRB,6.7391E-03_JPRB,7.1632E-03_JPRB/)
KBO( :, 2,52,12) = (/&
&1.8963E-02_JPRB,2.3514E-02_JPRB,1.8863E-02_JPRB,1.2292E-02_JPRB,1.1416E-02_JPRB/)
KBO( :, 3,52,12) = (/&
&3.2574E-02_JPRB,4.0763E-02_JPRB,3.2692E-02_JPRB,2.1413E-02_JPRB,1.7232E-02_JPRB/)
KBO( :, 4,52,12) = (/&
&5.4015E-02_JPRB,6.7725E-02_JPRB,5.4297E-02_JPRB,3.5648E-02_JPRB,2.4880E-02_JPRB/)
KBO( :, 5,52,12) = (/&
&8.6142E-02_JPRB,1.0850E-01_JPRB,8.6783E-02_JPRB,5.7412E-02_JPRB,3.4604E-02_JPRB/)
KBO( :, 1,53,12) = (/&
&7.9034E-03_JPRB,9.8239E-03_JPRB,7.8369E-03_JPRB,5.1248E-03_JPRB,5.4843E-03_JPRB/)
KBO( :, 2,53,12) = (/&
&1.4792E-02_JPRB,1.8526E-02_JPRB,1.4847E-02_JPRB,9.6585E-03_JPRB,8.9798E-03_JPRB/)
KBO( :, 3,53,12) = (/&
&2.6145E-02_JPRB,3.2976E-02_JPRB,2.6454E-02_JPRB,1.7260E-02_JPRB,1.3880E-02_JPRB/)
KBO( :, 4,53,12) = (/&
&4.4324E-02_JPRB,5.5900E-02_JPRB,4.4894E-02_JPRB,2.9345E-02_JPRB,2.0450E-02_JPRB/)
KBO( :, 5,53,12) = (/&
&7.2259E-02_JPRB,9.1031E-02_JPRB,7.2836E-02_JPRB,4.7964E-02_JPRB,2.8899E-02_JPRB/)
KBO( :, 1,54,12) = (/&
&6.0030E-03_JPRB,7.5343E-03_JPRB,6.0206E-03_JPRB,3.9269E-03_JPRB,4.4374E-03_JPRB/)
KBO( :, 2,54,12) = (/&
&1.1626E-02_JPRB,1.4746E-02_JPRB,1.1801E-02_JPRB,7.6733E-03_JPRB,7.4644E-03_JPRB/)
KBO( :, 3,54,12) = (/&
&2.1204E-02_JPRB,2.6932E-02_JPRB,2.1639E-02_JPRB,1.4058E-02_JPRB,1.1820E-02_JPRB/)
KBO( :, 4,54,12) = (/&
&3.6734E-02_JPRB,4.6630E-02_JPRB,3.7473E-02_JPRB,2.4399E-02_JPRB,1.7746E-02_JPRB/)
KBO( :, 5,54,12) = (/&
&6.1048E-02_JPRB,7.7176E-02_JPRB,6.1839E-02_JPRB,4.0517E-02_JPRB,2.5474E-02_JPRB/)
KBO( :, 1,55,12) = (/&
&4.5630E-03_JPRB,5.7681E-03_JPRB,4.6205E-03_JPRB,3.0002E-03_JPRB,3.7045E-03_JPRB/)
KBO( :, 2,55,12) = (/&
&9.1273E-03_JPRB,1.1728E-02_JPRB,9.3956E-03_JPRB,6.0945E-03_JPRB,6.4077E-03_JPRB/)
KBO( :, 3,55,12) = (/&
&1.7191E-02_JPRB,2.2039E-02_JPRB,1.7711E-02_JPRB,1.1469E-02_JPRB,1.0390E-02_JPRB/)
KBO( :, 4,55,12) = (/&
&3.0517E-02_JPRB,3.9009E-02_JPRB,3.1321E-02_JPRB,2.0350E-02_JPRB,1.5909E-02_JPRB/)
KBO( :, 5,55,12) = (/&
&5.1680E-02_JPRB,6.5618E-02_JPRB,5.2649E-02_JPRB,3.4345E-02_JPRB,2.3231E-02_JPRB/)
KBO( :, 1,56,12) = (/&
&3.4429E-03_JPRB,4.3693E-03_JPRB,3.5102E-03_JPRB,2.2664E-03_JPRB,3.0972E-03_JPRB/)
KBO( :, 2,56,12) = (/&
&7.1067E-03_JPRB,9.2412E-03_JPRB,7.4106E-03_JPRB,4.8010E-03_JPRB,5.4938E-03_JPRB/)
KBO( :, 3,56,12) = (/&
&1.3838E-02_JPRB,1.7926E-02_JPRB,1.4393E-02_JPRB,9.3102E-03_JPRB,9.1167E-03_JPRB/)
KBO( :, 4,56,12) = (/&
&2.5226E-02_JPRB,3.2470E-02_JPRB,2.6067E-02_JPRB,1.6890E-02_JPRB,1.4253E-02_JPRB/)
KBO( :, 5,56,12) = (/&
&4.3555E-02_JPRB,5.5559E-02_JPRB,4.4639E-02_JPRB,2.9008E-02_JPRB,2.1194E-02_JPRB/)
KBO( :, 1,57,12) = (/&
&2.5835E-03_JPRB,3.2792E-03_JPRB,2.6340E-03_JPRB,1.6928E-03_JPRB,2.5979E-03_JPRB/)
KBO( :, 2,57,12) = (/&
&5.4818E-03_JPRB,7.2018E-03_JPRB,5.7860E-03_JPRB,3.7399E-03_JPRB,4.6938E-03_JPRB/)
KBO( :, 3,57,12) = (/&
&1.1045E-02_JPRB,1.4477E-02_JPRB,1.1615E-02_JPRB,7.5071E-03_JPRB,7.9880E-03_JPRB/)
KBO( :, 4,57,12) = (/&
&2.0734E-02_JPRB,2.6855E-02_JPRB,2.1584E-02_JPRB,1.3939E-02_JPRB,1.2771E-02_JPRB/)
KBO( :, 5,57,12) = (/&
&3.6531E-02_JPRB,4.6834E-02_JPRB,3.7641E-02_JPRB,2.4391E-02_JPRB,1.9328E-02_JPRB/)
KBO( :, 1,58,12) = (/&
&1.9554E-03_JPRB,2.4805E-03_JPRB,1.9815E-03_JPRB,1.2675E-03_JPRB,2.2311E-03_JPRB/)
KBO( :, 2,58,12) = (/&
&4.2406E-03_JPRB,5.6194E-03_JPRB,4.5251E-03_JPRB,2.9142E-03_JPRB,4.0751E-03_JPRB/)
KBO( :, 3,58,12) = (/&
&8.8253E-03_JPRB,1.1715E-02_JPRB,9.4049E-03_JPRB,6.0687E-03_JPRB,7.1082E-03_JPRB/)
KBO( :, 4,58,12) = (/&
&1.7081E-02_JPRB,2.2294E-02_JPRB,1.7921E-02_JPRB,1.1542E-02_JPRB,1.1601E-02_JPRB/)
KBO( :, 5,58,12) = (/&
&3.0768E-02_JPRB,3.9661E-02_JPRB,3.1853E-02_JPRB,2.0599E-02_JPRB,1.7860E-02_JPRB/)
KBO( :, 1,59,12) = (/&
&1.7311E-03_JPRB,2.1950E-03_JPRB,1.7464E-03_JPRB,1.1095E-03_JPRB,2.2810E-03_JPRB/)
KBO( :, 2,59,12) = (/&
&3.7867E-03_JPRB,5.0375E-03_JPRB,4.0622E-03_JPRB,2.6050E-03_JPRB,4.2229E-03_JPRB/)
KBO( :, 3,59,12) = (/&
&7.9927E-03_JPRB,1.0691E-02_JPRB,8.5872E-03_JPRB,5.5330E-03_JPRB,7.4637E-03_JPRB/)
KBO( :, 4,59,12) = (/&
&1.5706E-02_JPRB,2.0603E-02_JPRB,1.6559E-02_JPRB,1.0653E-02_JPRB,1.2338E-02_JPRB/)
KBO( :, 5,59,12) = (/&
&2.8614E-02_JPRB,3.6995E-02_JPRB,2.9703E-02_JPRB,1.9191E-02_JPRB,1.9178E-02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3_B3
