!OCL SCALAR
SUBROUTINE RRTM_KGB3_B1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different H2O to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = H2O/(H2O+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of H2O.  For instance, JS=1 refers to no H2O, 
!     JS = 2 corresponds to eta = 0.25, etc.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 1) = (/&
&7.1418E-07_JPRB,7.7683E-05_JPRB,1.6530E-04_JPRB,3.3221E-04_JPRB,3.4375E-04_JPRB/)
KBO( :, 2,13, 1) = (/&
&7.2895E-07_JPRB,7.7891E-05_JPRB,1.5813E-04_JPRB,2.9611E-04_JPRB,3.5156E-04_JPRB/)
KBO( :, 3,13, 1) = (/&
&8.1104E-07_JPRB,8.0313E-05_JPRB,1.5573E-04_JPRB,2.7205E-04_JPRB,3.6744E-04_JPRB/)
KBO( :, 4,13, 1) = (/&
&9.8030E-07_JPRB,8.4645E-05_JPRB,1.5829E-04_JPRB,2.5788E-04_JPRB,3.9124E-04_JPRB/)
KBO( :, 5,13, 1) = (/&
&1.2532E-06_JPRB,9.1367E-05_JPRB,1.6556E-04_JPRB,2.5243E-04_JPRB,4.2278E-04_JPRB/)
KBO( :, 1,14, 1) = (/&
&5.8662E-07_JPRB,6.3217E-05_JPRB,1.3394E-04_JPRB,2.6815E-04_JPRB,2.8024E-04_JPRB/)
KBO( :, 2,14, 1) = (/&
&6.0322E-07_JPRB,6.3644E-05_JPRB,1.2871E-04_JPRB,2.3989E-04_JPRB,2.8697E-04_JPRB/)
KBO( :, 3,14, 1) = (/&
&6.7707E-07_JPRB,6.5857E-05_JPRB,1.2726E-04_JPRB,2.2113E-04_JPRB,3.0014E-04_JPRB/)
KBO( :, 4,14, 1) = (/&
&8.2251E-07_JPRB,6.9663E-05_JPRB,1.2984E-04_JPRB,2.1038E-04_JPRB,3.1976E-04_JPRB/)
KBO( :, 5,14, 1) = (/&
&1.0537E-06_JPRB,7.5477E-05_JPRB,1.3625E-04_JPRB,2.0669E-04_JPRB,3.4553E-04_JPRB/)
KBO( :, 1,15, 1) = (/&
&4.8159E-07_JPRB,5.1327E-05_JPRB,1.0828E-04_JPRB,2.1580E-04_JPRB,2.2716E-04_JPRB/)
KBO( :, 2,15, 1) = (/&
&4.9953E-07_JPRB,5.1898E-05_JPRB,1.0456E-04_JPRB,1.9384E-04_JPRB,2.3282E-04_JPRB/)
KBO( :, 3,15, 1) = (/&
&5.6592E-07_JPRB,5.3937E-05_JPRB,1.0383E-04_JPRB,1.7938E-04_JPRB,2.4342E-04_JPRB/)
KBO( :, 4,15, 1) = (/&
&6.9060E-07_JPRB,5.7276E-05_JPRB,1.0637E-04_JPRB,1.7136E-04_JPRB,2.5925E-04_JPRB/)
KBO( :, 5,15, 1) = (/&
&8.8764E-07_JPRB,6.2300E-05_JPRB,1.1206E-04_JPRB,1.6901E-04_JPRB,2.7978E-04_JPRB/)
KBO( :, 1,16, 1) = (/&
&3.9534E-07_JPRB,4.1658E-05_JPRB,8.7509E-05_JPRB,1.7349E-04_JPRB,1.8327E-04_JPRB/)
KBO( :, 2,16, 1) = (/&
&4.1395E-07_JPRB,4.2305E-05_JPRB,8.4934E-05_JPRB,1.5653E-04_JPRB,1.8794E-04_JPRB/)
KBO( :, 3,16, 1) = (/&
&4.7298E-07_JPRB,4.4176E-05_JPRB,8.4714E-05_JPRB,1.4546E-04_JPRB,1.9627E-04_JPRB/)
KBO( :, 4,16, 1) = (/&
&5.8017E-07_JPRB,4.7094E-05_JPRB,8.7162E-05_JPRB,1.3953E-04_JPRB,2.0862E-04_JPRB/)
KBO( :, 5,16, 1) = (/&
&7.4847E-07_JPRB,5.1410E-05_JPRB,9.2164E-05_JPRB,1.3822E-04_JPRB,2.2492E-04_JPRB/)
KBO( :, 1,17, 1) = (/&
&3.2461E-07_JPRB,3.3900E-05_JPRB,7.0928E-05_JPRB,1.3982E-04_JPRB,1.4790E-04_JPRB/)
KBO( :, 2,17, 1) = (/&
&3.4310E-07_JPRB,3.4570E-05_JPRB,6.9142E-05_JPRB,1.2666E-04_JPRB,1.5175E-04_JPRB/)
KBO( :, 3,17, 1) = (/&
&3.9502E-07_JPRB,3.6243E-05_JPRB,6.9258E-05_JPRB,1.1817E-04_JPRB,1.5840E-04_JPRB/)
KBO( :, 4,17, 1) = (/&
&4.8706E-07_JPRB,3.8770E-05_JPRB,7.1558E-05_JPRB,1.1380E-04_JPRB,1.6811E-04_JPRB/)
KBO( :, 5,17, 1) = (/&
&6.3052E-07_JPRB,4.2462E-05_JPRB,7.5924E-05_JPRB,1.1322E-04_JPRB,1.8097E-04_JPRB/)
KBO( :, 1,18, 1) = (/&
&2.6665E-07_JPRB,2.7690E-05_JPRB,5.7714E-05_JPRB,1.1306E-04_JPRB,1.1974E-04_JPRB/)
KBO( :, 2,18, 1) = (/&
&2.8433E-07_JPRB,2.8352E-05_JPRB,5.6467E-05_JPRB,1.0278E-04_JPRB,1.2295E-04_JPRB/)
KBO( :, 3,18, 1) = (/&
&3.2991E-07_JPRB,2.9820E-05_JPRB,5.6782E-05_JPRB,9.6223E-05_JPRB,1.2833E-04_JPRB/)
KBO( :, 4,18, 1) = (/&
&4.0885E-07_JPRB,3.1990E-05_JPRB,5.8916E-05_JPRB,9.3033E-05_JPRB,1.3601E-04_JPRB/)
KBO( :, 5,18, 1) = (/&
&5.3113E-07_JPRB,3.5147E-05_JPRB,6.2667E-05_JPRB,9.2955E-05_JPRB,1.4604E-04_JPRB/)
KBO( :, 1,19, 1) = (/&
&2.1915E-07_JPRB,2.2650E-05_JPRB,4.7032E-05_JPRB,9.1545E-05_JPRB,9.7174E-05_JPRB/)
KBO( :, 2,19, 1) = (/&
&2.3563E-07_JPRB,2.3282E-05_JPRB,4.6172E-05_JPRB,8.3486E-05_JPRB,9.9869E-05_JPRB/)
KBO( :, 3,19, 1) = (/&
&2.7548E-07_JPRB,2.4553E-05_JPRB,4.6603E-05_JPRB,7.8441E-05_JPRB,1.0422E-04_JPRB/)
KBO( :, 4,19, 1) = (/&
&3.4310E-07_JPRB,2.6414E-05_JPRB,4.8547E-05_JPRB,7.6134E-05_JPRB,1.1036E-04_JPRB/)
KBO( :, 5,19, 1) = (/&
&4.4724E-07_JPRB,2.9096E-05_JPRB,5.1737E-05_JPRB,7.6381E-05_JPRB,1.1839E-04_JPRB/)
KBO( :, 1,20, 1) = (/&
&1.8030E-07_JPRB,1.8558E-05_JPRB,3.8356E-05_JPRB,7.4071E-05_JPRB,7.9169E-05_JPRB/)
KBO( :, 2,20, 1) = (/&
&1.9579E-07_JPRB,1.9155E-05_JPRB,3.7791E-05_JPRB,6.7788E-05_JPRB,8.1446E-05_JPRB/)
KBO( :, 3,20, 1) = (/&
&2.3085E-07_JPRB,2.0254E-05_JPRB,3.8309E-05_JPRB,6.3956E-05_JPRB,8.5047E-05_JPRB/)
KBO( :, 4,20, 1) = (/&
&2.8924E-07_JPRB,2.1859E-05_JPRB,4.0062E-05_JPRB,6.2346E-05_JPRB,9.0082E-05_JPRB/)
KBO( :, 5,20, 1) = (/&
&3.7846E-07_JPRB,2.4137E-05_JPRB,4.2788E-05_JPRB,6.2820E-05_JPRB,9.6650E-05_JPRB/)
KBO( :, 1,21, 1) = (/&
&1.4847E-07_JPRB,1.5215E-05_JPRB,3.1290E-05_JPRB,5.9949E-05_JPRB,6.4552E-05_JPRB/)
KBO( :, 2,21, 1) = (/&
&1.6287E-07_JPRB,1.5766E-05_JPRB,3.0943E-05_JPRB,5.5054E-05_JPRB,6.6478E-05_JPRB/)
KBO( :, 3,21, 1) = (/&
&1.9366E-07_JPRB,1.6713E-05_JPRB,3.1503E-05_JPRB,5.2161E-05_JPRB,6.9475E-05_JPRB/)
KBO( :, 4,21, 1) = (/&
&2.4408E-07_JPRB,1.8092E-05_JPRB,3.3059E-05_JPRB,5.1064E-05_JPRB,7.3632E-05_JPRB/)
KBO( :, 5,21, 1) = (/&
&3.2048E-07_JPRB,2.0022E-05_JPRB,3.5383E-05_JPRB,5.1675E-05_JPRB,7.9025E-05_JPRB/)
KBO( :, 1,22, 1) = (/&
&1.2289E-07_JPRB,1.2484E-05_JPRB,2.5472E-05_JPRB,4.8192E-05_JPRB,5.2603E-05_JPRB/)
KBO( :, 2,22, 1) = (/&
&1.3697E-07_JPRB,1.3009E-05_JPRB,2.5334E-05_JPRB,4.4504E-05_JPRB,5.4267E-05_JPRB/)
KBO( :, 3,22, 1) = (/&
&1.6488E-07_JPRB,1.3843E-05_JPRB,2.5950E-05_JPRB,4.2432E-05_JPRB,5.6803E-05_JPRB/)
KBO( :, 4,22, 1) = (/&
&2.0968E-07_JPRB,1.5052E-05_JPRB,2.7363E-05_JPRB,4.1803E-05_JPRB,6.0274E-05_JPRB/)
KBO( :, 5,22, 1) = (/&
&2.7669E-07_JPRB,1.6715E-05_JPRB,2.9384E-05_JPRB,4.2575E-05_JPRB,6.4715E-05_JPRB/)
KBO( :, 1,23, 1) = (/&
&1.0206E-07_JPRB,1.0252E-05_JPRB,2.0747E-05_JPRB,3.8734E-05_JPRB,4.2840E-05_JPRB/)
KBO( :, 2,23, 1) = (/&
&1.1559E-07_JPRB,1.0742E-05_JPRB,2.0755E-05_JPRB,3.5990E-05_JPRB,4.4274E-05_JPRB/)
KBO( :, 3,23, 1) = (/&
&1.4082E-07_JPRB,1.1473E-05_JPRB,2.1391E-05_JPRB,3.4535E-05_JPRB,4.6409E-05_JPRB/)
KBO( :, 4,23, 1) = (/&
&1.8064E-07_JPRB,1.2528E-05_JPRB,2.2650E-05_JPRB,3.4245E-05_JPRB,4.9289E-05_JPRB/)
KBO( :, 5,23, 1) = (/&
&2.3944E-07_JPRB,1.3961E-05_JPRB,2.4408E-05_JPRB,3.5094E-05_JPRB,5.2908E-05_JPRB/)
KBO( :, 1,24, 1) = (/&
&8.5103E-08_JPRB,8.4147E-06_JPRB,1.6891E-05_JPRB,3.1099E-05_JPRB,3.4780E-05_JPRB/)
KBO( :, 2,24, 1) = (/&
&9.8006E-08_JPRB,8.8655E-06_JPRB,1.6999E-05_JPRB,2.9091E-05_JPRB,3.5996E-05_JPRB/)
KBO( :, 3,24, 1) = (/&
&1.2073E-07_JPRB,9.5086E-06_JPRB,1.7631E-05_JPRB,2.8105E-05_JPRB,3.7773E-05_JPRB/)
KBO( :, 4,24, 1) = (/&
&1.5616E-07_JPRB,1.0427E-05_JPRB,1.8742E-05_JPRB,2.8056E-05_JPRB,4.0114E-05_JPRB/)
KBO( :, 5,24, 1) = (/&
&2.0784E-07_JPRB,1.1663E-05_JPRB,2.0274E-05_JPRB,2.8927E-05_JPRB,4.3028E-05_JPRB/)
KBO( :, 1,25, 1) = (/&
&7.1310E-08_JPRB,6.9185E-06_JPRB,1.3767E-05_JPRB,2.4976E-05_JPRB,2.8241E-05_JPRB/)
KBO( :, 2,25, 1) = (/&
&8.3499E-08_JPRB,7.3246E-06_JPRB,1.3943E-05_JPRB,2.3533E-05_JPRB,2.9273E-05_JPRB/)
KBO( :, 3,25, 1) = (/&
&1.0401E-07_JPRB,7.8935E-06_JPRB,1.4555E-05_JPRB,2.2896E-05_JPRB,3.0735E-05_JPRB/)
KBO( :, 4,25, 1) = (/&
&1.3555E-07_JPRB,8.6941E-06_JPRB,1.5529E-05_JPRB,2.3015E-05_JPRB,3.2639E-05_JPRB/)
KBO( :, 5,25, 1) = (/&
&1.8108E-07_JPRB,9.7609E-06_JPRB,1.6867E-05_JPRB,2.3873E-05_JPRB,3.4993E-05_JPRB/)
KBO( :, 1,26, 1) = (/&
&6.0142E-08_JPRB,5.7047E-06_JPRB,1.1243E-05_JPRB,2.0069E-05_JPRB,2.2978E-05_JPRB/)
KBO( :, 2,26, 1) = (/&
&7.1603E-08_JPRB,6.0681E-06_JPRB,1.1465E-05_JPRB,1.9057E-05_JPRB,2.3854E-05_JPRB/)
KBO( :, 3,26, 1) = (/&
&9.0251E-08_JPRB,6.5738E-06_JPRB,1.2045E-05_JPRB,1.8681E-05_JPRB,2.5076E-05_JPRB/)
KBO( :, 4,26, 1) = (/&
&1.1847E-07_JPRB,7.2745E-06_JPRB,1.2903E-05_JPRB,1.8921E-05_JPRB,2.6626E-05_JPRB/)
KBO( :, 5,26, 1) = (/&
&1.5875E-07_JPRB,8.1996E-06_JPRB,1.4077E-05_JPRB,1.9751E-05_JPRB,2.8555E-05_JPRB/)
KBO( :, 1,27, 1) = (/&
&5.0983E-08_JPRB,4.7088E-06_JPRB,9.1912E-06_JPRB,1.6147E-05_JPRB,1.8668E-05_JPRB/)
KBO( :, 2,27, 1) = (/&
&6.1630E-08_JPRB,5.0315E-06_JPRB,9.4402E-06_JPRB,1.5452E-05_JPRB,1.9405E-05_JPRB/)
KBO( :, 3,27, 1) = (/&
&7.8563E-08_JPRB,5.4806E-06_JPRB,9.9742E-06_JPRB,1.5262E-05_JPRB,2.0403E-05_JPRB/)
KBO( :, 4,27, 1) = (/&
&1.0377E-07_JPRB,6.0931E-06_JPRB,1.0731E-05_JPRB,1.5575E-05_JPRB,2.1672E-05_JPRB/)
KBO( :, 5,27, 1) = (/&
&1.3934E-07_JPRB,6.8942E-06_JPRB,1.1760E-05_JPRB,1.6361E-05_JPRB,2.3196E-05_JPRB/)
KBO( :, 1,28, 1) = (/&
&4.3423E-08_JPRB,3.8906E-06_JPRB,7.5226E-06_JPRB,1.3009E-05_JPRB,1.5127E-05_JPRB/)
KBO( :, 2,28, 1) = (/&
&5.3228E-08_JPRB,4.1755E-06_JPRB,7.7818E-06_JPRB,1.2546E-05_JPRB,1.5736E-05_JPRB/)
KBO( :, 3,28, 1) = (/&
&6.8564E-08_JPRB,4.5731E-06_JPRB,8.2639E-06_JPRB,1.2487E-05_JPRB,1.6536E-05_JPRB/)
KBO( :, 4,28, 1) = (/&
&9.1039E-08_JPRB,5.1074E-06_JPRB,8.9326E-06_JPRB,1.2837E-05_JPRB,1.7505E-05_JPRB/)
KBO( :, 5,28, 1) = (/&
&1.2239E-07_JPRB,5.8016E-06_JPRB,9.8318E-06_JPRB,1.3565E-05_JPRB,1.8670E-05_JPRB/)
KBO( :, 1,29, 1) = (/&
&3.7204E-08_JPRB,3.2238E-06_JPRB,6.1736E-06_JPRB,1.0502E-05_JPRB,1.2279E-05_JPRB/)
KBO( :, 2,29, 1) = (/&
&4.6206E-08_JPRB,3.4759E-06_JPRB,6.4330E-06_JPRB,1.0209E-05_JPRB,1.2764E-05_JPRB/)
KBO( :, 3,29, 1) = (/&
&6.0076E-08_JPRB,3.8273E-06_JPRB,6.8635E-06_JPRB,1.0241E-05_JPRB,1.3368E-05_JPRB/)
KBO( :, 4,29, 1) = (/&
&8.0144E-08_JPRB,4.2936E-06_JPRB,7.4538E-06_JPRB,1.0606E-05_JPRB,1.4121E-05_JPRB/)
KBO( :, 5,29, 1) = (/&
&1.0777E-07_JPRB,4.8966E-06_JPRB,8.2412E-06_JPRB,1.1275E-05_JPRB,1.5046E-05_JPRB/)
KBO( :, 1,30, 1) = (/&
&3.1996E-08_JPRB,2.6737E-06_JPRB,5.0754E-06_JPRB,8.4948E-06_JPRB,9.8822E-06_JPRB/)
KBO( :, 2,30, 1) = (/&
&4.0245E-08_JPRB,2.8984E-06_JPRB,5.3264E-06_JPRB,8.3223E-06_JPRB,1.0256E-05_JPRB/)
KBO( :, 3,30, 1) = (/&
&5.2747E-08_JPRB,3.2079E-06_JPRB,5.7080E-06_JPRB,8.4160E-06_JPRB,1.0727E-05_JPRB/)
KBO( :, 4,30, 1) = (/&
&7.0609E-08_JPRB,3.6138E-06_JPRB,6.2283E-06_JPRB,8.7777E-06_JPRB,1.1320E-05_JPRB/)
KBO( :, 5,30, 1) = (/&
&9.4984E-08_JPRB,4.1398E-06_JPRB,6.9193E-06_JPRB,9.3872E-06_JPRB,1.2062E-05_JPRB/)
KBO( :, 1,31, 1) = (/&
&2.7641E-08_JPRB,2.2221E-06_JPRB,4.1820E-06_JPRB,6.8854E-06_JPRB,7.8857E-06_JPRB/)
KBO( :, 2,31, 1) = (/&
&3.5201E-08_JPRB,2.4225E-06_JPRB,4.4182E-06_JPRB,6.7986E-06_JPRB,8.1875E-06_JPRB/)
KBO( :, 3,31, 1) = (/&
&4.6451E-08_JPRB,2.6943E-06_JPRB,4.7566E-06_JPRB,6.9330E-06_JPRB,8.5704E-06_JPRB/)
KBO( :, 4,31, 1) = (/&
&6.2336E-08_JPRB,3.0481E-06_JPRB,5.2150E-06_JPRB,7.2810E-06_JPRB,9.0473E-06_JPRB/)
KBO( :, 5,31, 1) = (/&
&8.3774E-08_JPRB,3.5048E-06_JPRB,5.8188E-06_JPRB,7.8290E-06_JPRB,9.6365E-06_JPRB/)
KBO( :, 1,32, 1) = (/&
&2.3981E-08_JPRB,1.8500E-06_JPRB,3.4538E-06_JPRB,5.5925E-06_JPRB,6.2708E-06_JPRB/)
KBO( :, 2,32, 1) = (/&
&3.0888E-08_JPRB,2.0288E-06_JPRB,3.6701E-06_JPRB,5.5668E-06_JPRB,6.5148E-06_JPRB/)
KBO( :, 3,32, 1) = (/&
&4.1004E-08_JPRB,2.2672E-06_JPRB,3.9709E-06_JPRB,5.7241E-06_JPRB,6.8232E-06_JPRB/)
KBO( :, 4,32, 1) = (/&
&5.5092E-08_JPRB,2.5754E-06_JPRB,4.3743E-06_JPRB,6.0514E-06_JPRB,7.2153E-06_JPRB/)
KBO( :, 5,32, 1) = (/&
&7.3928E-08_JPRB,2.9722E-06_JPRB,4.9013E-06_JPRB,6.5406E-06_JPRB,7.6884E-06_JPRB/)
KBO( :, 1,33, 1) = (/&
&2.0891E-08_JPRB,1.5432E-06_JPRB,2.8587E-06_JPRB,4.5518E-06_JPRB,4.9648E-06_JPRB/)
KBO( :, 2,33, 1) = (/&
&2.7170E-08_JPRB,1.7018E-06_JPRB,3.0535E-06_JPRB,4.5689E-06_JPRB,5.1628E-06_JPRB/)
KBO( :, 3,33, 1) = (/&
&3.6242E-08_JPRB,1.9105E-06_JPRB,3.3202E-06_JPRB,4.7346E-06_JPRB,5.4226E-06_JPRB/)
KBO( :, 4,33, 1) = (/&
&4.8741E-08_JPRB,2.1800E-06_JPRB,3.6760E-06_JPRB,5.0388E-06_JPRB,5.7379E-06_JPRB/)
KBO( :, 5,33, 1) = (/&
&6.5227E-08_JPRB,2.5234E-06_JPRB,4.1341E-06_JPRB,5.4730E-06_JPRB,6.1189E-06_JPRB/)
KBO( :, 1,34, 1) = (/&
&1.8095E-08_JPRB,1.2866E-06_JPRB,2.3675E-06_JPRB,3.7154E-06_JPRB,3.9669E-06_JPRB/)
KBO( :, 2,34, 1) = (/&
&2.3709E-08_JPRB,1.4253E-06_JPRB,2.5394E-06_JPRB,3.7569E-06_JPRB,4.1359E-06_JPRB/)
KBO( :, 3,34, 1) = (/&
&3.1721E-08_JPRB,1.6060E-06_JPRB,2.7729E-06_JPRB,3.9185E-06_JPRB,4.3498E-06_JPRB/)
KBO( :, 4,34, 1) = (/&
&4.2654E-08_JPRB,1.8394E-06_JPRB,3.0822E-06_JPRB,4.1918E-06_JPRB,4.6083E-06_JPRB/)
KBO( :, 5,34, 1) = (/&
&5.6945E-08_JPRB,2.1348E-06_JPRB,3.4773E-06_JPRB,4.5733E-06_JPRB,4.9229E-06_JPRB/)
KBO( :, 1,35, 1) = (/&
&1.5318E-08_JPRB,1.0637E-06_JPRB,1.9503E-06_JPRB,3.0369E-06_JPRB,3.1425E-06_JPRB/)
KBO( :, 2,35, 1) = (/&
&2.0142E-08_JPRB,1.1814E-06_JPRB,2.0969E-06_JPRB,3.0840E-06_JPRB,3.2804E-06_JPRB/)
KBO( :, 3,35, 1) = (/&
&2.6985E-08_JPRB,1.3339E-06_JPRB,2.2954E-06_JPRB,3.2281E-06_JPRB,3.4506E-06_JPRB/)
KBO( :, 4,35, 1) = (/&
&3.6271E-08_JPRB,1.5312E-06_JPRB,2.5572E-06_JPRB,3.4632E-06_JPRB,3.6600E-06_JPRB/)
KBO( :, 5,35, 1) = (/&
&4.8348E-08_JPRB,1.7796E-06_JPRB,2.8900E-06_JPRB,3.7877E-06_JPRB,3.9119E-06_JPRB/)
KBO( :, 1,36, 1) = (/&
&1.2609E-08_JPRB,8.7019E-07_JPRB,1.5952E-06_JPRB,2.4829E-06_JPRB,2.4549E-06_JPRB/)
KBO( :, 2,36, 1) = (/&
&1.6587E-08_JPRB,9.6711E-07_JPRB,1.7160E-06_JPRB,2.5229E-06_JPRB,2.5656E-06_JPRB/)
KBO( :, 3,36, 1) = (/&
&2.2224E-08_JPRB,1.0924E-06_JPRB,1.8795E-06_JPRB,2.6424E-06_JPRB,2.6986E-06_JPRB/)
KBO( :, 4,36, 1) = (/&
&2.9869E-08_JPRB,1.2544E-06_JPRB,2.0948E-06_JPRB,2.8361E-06_JPRB,2.8620E-06_JPRB/)
KBO( :, 5,36, 1) = (/&
&3.9802E-08_JPRB,1.4584E-06_JPRB,2.3682E-06_JPRB,3.1034E-06_JPRB,3.0593E-06_JPRB/)
KBO( :, 1,37, 1) = (/&
&9.9825E-09_JPRB,7.0298E-07_JPRB,1.2942E-06_JPRB,2.0328E-06_JPRB,1.9580E-06_JPRB/)
KBO( :, 2,37, 1) = (/&
&1.3082E-08_JPRB,7.7949E-07_JPRB,1.3892E-06_JPRB,2.0567E-06_JPRB,2.0455E-06_JPRB/)
KBO( :, 3,37, 1) = (/&
&1.7504E-08_JPRB,8.7873E-07_JPRB,1.5181E-06_JPRB,2.1464E-06_JPRB,2.1505E-06_JPRB/)
KBO( :, 4,37, 1) = (/&
&2.3530E-08_JPRB,1.0069E-06_JPRB,1.6884E-06_JPRB,2.2974E-06_JPRB,2.2783E-06_JPRB/)
KBO( :, 5,37, 1) = (/&
&3.1408E-08_JPRB,1.1691E-06_JPRB,1.9058E-06_JPRB,2.5076E-06_JPRB,2.4325E-06_JPRB/)
KBO( :, 1,38, 1) = (/&
&7.8914E-09_JPRB,5.6770E-07_JPRB,1.0500E-06_JPRB,1.6653E-06_JPRB,1.5591E-06_JPRB/)
KBO( :, 2,38, 1) = (/&
&1.0298E-08_JPRB,6.2785E-07_JPRB,1.1243E-06_JPRB,1.6773E-06_JPRB,1.6284E-06_JPRB/)
KBO( :, 3,38, 1) = (/&
&1.3752E-08_JPRB,7.0630E-07_JPRB,1.2256E-06_JPRB,1.7435E-06_JPRB,1.7113E-06_JPRB/)
KBO( :, 4,38, 1) = (/&
&1.8491E-08_JPRB,8.0748E-07_JPRB,1.3600E-06_JPRB,1.8604E-06_JPRB,1.8119E-06_JPRB/)
KBO( :, 5,38, 1) = (/&
&2.4713E-08_JPRB,9.3623E-07_JPRB,1.5323E-06_JPRB,2.0252E-06_JPRB,1.9325E-06_JPRB/)
KBO( :, 1,39, 1) = (/&
&6.2449E-09_JPRB,4.5862E-07_JPRB,8.5227E-07_JPRB,1.3650E-06_JPRB,1.2362E-06_JPRB/)
KBO( :, 2,39, 1) = (/&
&8.1107E-09_JPRB,5.0588E-07_JPRB,9.1024E-07_JPRB,1.3687E-06_JPRB,1.2913E-06_JPRB/)
KBO( :, 3,39, 1) = (/&
&1.0807E-08_JPRB,5.6790E-07_JPRB,9.8979E-07_JPRB,1.4171E-06_JPRB,1.3567E-06_JPRB/)
KBO( :, 4,39, 1) = (/&
&1.4528E-08_JPRB,6.4780E-07_JPRB,1.0958E-06_JPRB,1.5072E-06_JPRB,1.4361E-06_JPRB/)
KBO( :, 5,39, 1) = (/&
&1.9446E-08_JPRB,7.4988E-07_JPRB,1.2323E-06_JPRB,1.6363E-06_JPRB,1.5306E-06_JPRB/)
KBO( :, 1,40, 1) = (/&
&4.8302E-09_JPRB,3.6764E-07_JPRB,6.8890E-07_JPRB,1.1218E-06_JPRB,9.8696E-07_JPRB/)
KBO( :, 2,40, 1) = (/&
&6.2157E-09_JPRB,4.0354E-07_JPRB,7.3207E-07_JPRB,1.1164E-06_JPRB,1.0304E-06_JPRB/)
KBO( :, 3,40, 1) = (/&
&8.2441E-09_JPRB,4.5131E-07_JPRB,7.9261E-07_JPRB,1.1474E-06_JPRB,1.0817E-06_JPRB/)
KBO( :, 4,40, 1) = (/&
&1.1074E-08_JPRB,5.1282E-07_JPRB,8.7386E-07_JPRB,1.2132E-06_JPRB,1.1434E-06_JPRB/)
KBO( :, 5,40, 1) = (/&
&1.4851E-08_JPRB,5.9180E-07_JPRB,9.7921E-07_JPRB,1.3110E-06_JPRB,1.2171E-06_JPRB/)
KBO( :, 1,41, 1) = (/&
&3.7368E-09_JPRB,2.9476E-07_JPRB,5.5755E-07_JPRB,9.2376E-07_JPRB,7.8720E-07_JPRB/)
KBO( :, 2,41, 1) = (/&
&4.7545E-09_JPRB,3.2182E-07_JPRB,5.8886E-07_JPRB,9.1238E-07_JPRB,8.2191E-07_JPRB/)
KBO( :, 3,41, 1) = (/&
&6.2690E-09_JPRB,3.5842E-07_JPRB,6.3462E-07_JPRB,9.3003E-07_JPRB,8.6237E-07_JPRB/)
KBO( :, 4,41, 1) = (/&
&8.4086E-09_JPRB,4.0567E-07_JPRB,6.9663E-07_JPRB,9.7688E-07_JPRB,9.1026E-07_JPRB/)
KBO( :, 5,41, 1) = (/&
&1.1291E-08_JPRB,4.6640E-07_JPRB,7.7748E-07_JPRB,1.0503E-06_JPRB,9.6752E-07_JPRB/)
KBO( :, 1,42, 1) = (/&
&2.9007E-09_JPRB,2.3650E-07_JPRB,4.5213E-07_JPRB,7.6209E-07_JPRB,6.2575E-07_JPRB/)
KBO( :, 2,42, 1) = (/&
&3.6445E-09_JPRB,2.5698E-07_JPRB,4.7408E-07_JPRB,7.4714E-07_JPRB,6.5397E-07_JPRB/)
KBO( :, 3,42, 1) = (/&
&4.7714E-09_JPRB,2.8488E-07_JPRB,5.0867E-07_JPRB,7.5527E-07_JPRB,6.8601E-07_JPRB/)
KBO( :, 4,42, 1) = (/&
&6.3838E-09_JPRB,3.2120E-07_JPRB,5.5584E-07_JPRB,7.8778E-07_JPRB,7.2350E-07_JPRB/)
KBO( :, 5,42, 1) = (/&
&8.5773E-09_JPRB,3.6777E-07_JPRB,6.1782E-07_JPRB,8.4249E-07_JPRB,7.6794E-07_JPRB/)
KBO( :, 1,43, 1) = (/&
&2.2351E-09_JPRB,1.8911E-07_JPRB,3.6687E-07_JPRB,6.3162E-07_JPRB,4.9805E-07_JPRB/)
KBO( :, 2,43, 1) = (/&
&2.7634E-09_JPRB,2.0451E-07_JPRB,3.8115E-07_JPRB,6.1360E-07_JPRB,5.2107E-07_JPRB/)
KBO( :, 3,43, 1) = (/&
&3.5807E-09_JPRB,2.2534E-07_JPRB,4.0658E-07_JPRB,6.1409E-07_JPRB,5.4635E-07_JPRB/)
KBO( :, 4,43, 1) = (/&
&4.7672E-09_JPRB,2.5284E-07_JPRB,4.4177E-07_JPRB,6.3473E-07_JPRB,5.7553E-07_JPRB/)
KBO( :, 5,43, 1) = (/&
&6.4052E-09_JPRB,2.8805E-07_JPRB,4.8846E-07_JPRB,6.7397E-07_JPRB,6.0977E-07_JPRB/)
KBO( :, 1,44, 1) = (/&
&1.7248E-09_JPRB,1.5121E-07_JPRB,2.9826E-07_JPRB,5.2580E-07_JPRB,3.9624E-07_JPRB/)
KBO( :, 2,44, 1) = (/&
&2.0939E-09_JPRB,1.6277E-07_JPRB,3.0698E-07_JPRB,5.0563E-07_JPRB,4.1515E-07_JPRB/)
KBO( :, 3,44, 1) = (/&
&2.6759E-09_JPRB,1.7808E-07_JPRB,3.2502E-07_JPRB,5.0085E-07_JPRB,4.3507E-07_JPRB/)
KBO( :, 4,44, 1) = (/&
&3.5375E-09_JPRB,1.9875E-07_JPRB,3.5098E-07_JPRB,5.1227E-07_JPRB,4.5779E-07_JPRB/)
KBO( :, 5,44, 1) = (/&
&4.7457E-09_JPRB,2.2523E-07_JPRB,3.8582E-07_JPRB,5.3933E-07_JPRB,4.8421E-07_JPRB/)
KBO( :, 1,45, 1) = (/&
&1.3426E-09_JPRB,1.2131E-07_JPRB,2.4315E-07_JPRB,4.3919E-07_JPRB,3.1429E-07_JPRB/)
KBO( :, 2,45, 1) = (/&
&1.5963E-09_JPRB,1.2978E-07_JPRB,2.4811E-07_JPRB,4.1799E-07_JPRB,3.2982E-07_JPRB/)
KBO( :, 3,45, 1) = (/&
&2.0068E-09_JPRB,1.4107E-07_JPRB,2.6027E-07_JPRB,4.0999E-07_JPRB,3.4585E-07_JPRB/)
KBO( :, 4,45, 1) = (/&
&2.6291E-09_JPRB,1.5649E-07_JPRB,2.7939E-07_JPRB,4.1473E-07_JPRB,3.6360E-07_JPRB/)
KBO( :, 5,45, 1) = (/&
&3.5165E-09_JPRB,1.7643E-07_JPRB,3.0531E-07_JPRB,4.3268E-07_JPRB,3.8407E-07_JPRB/)
KBO( :, 1,46, 1) = (/&
&1.0525E-09_JPRB,9.7607E-08_JPRB,1.9871E-07_JPRB,3.6864E-07_JPRB,2.4954E-07_JPRB/)
KBO( :, 2,46, 1) = (/&
&1.2190E-09_JPRB,1.0342E-07_JPRB,2.0108E-07_JPRB,3.4713E-07_JPRB,2.6150E-07_JPRB/)
KBO( :, 3,46, 1) = (/&
&1.5044E-09_JPRB,1.1181E-07_JPRB,2.0871E-07_JPRB,3.3691E-07_JPRB,2.7474E-07_JPRB/)
KBO( :, 4,46, 1) = (/&
&1.9474E-09_JPRB,1.2315E-07_JPRB,2.2254E-07_JPRB,3.3690E-07_JPRB,2.8869E-07_JPRB/)
KBO( :, 5,46, 1) = (/&
&2.5900E-09_JPRB,1.3809E-07_JPRB,2.4160E-07_JPRB,3.4784E-07_JPRB,3.0446E-07_JPRB/)
KBO( :, 1,47, 1) = (/&
&8.3184E-10_JPRB,7.8730E-08_JPRB,1.6288E-07_JPRB,3.1142E-07_JPRB,1.9926E-07_JPRB/)
KBO( :, 2,47, 1) = (/&
&9.3189E-10_JPRB,8.2400E-08_JPRB,1.6338E-07_JPRB,2.9014E-07_JPRB,2.0781E-07_JPRB/)
KBO( :, 3,47, 1) = (/&
&1.1246E-09_JPRB,8.8566E-08_JPRB,1.6773E-07_JPRB,2.7820E-07_JPRB,2.1850E-07_JPRB/)
KBO( :, 4,47, 1) = (/&
&1.4310E-09_JPRB,9.6726E-08_JPRB,1.7718E-07_JPRB,2.7482E-07_JPRB,2.2960E-07_JPRB/)
KBO( :, 5,47, 1) = (/&
&1.8866E-09_JPRB,1.0777E-07_JPRB,1.9096E-07_JPRB,2.8016E-07_JPRB,2.4174E-07_JPRB/)
KBO( :, 1,48, 1) = (/&
&6.6667E-10_JPRB,6.3743E-08_JPRB,1.3383E-07_JPRB,2.6444E-07_JPRB,1.5919E-07_JPRB/)
KBO( :, 2,48, 1) = (/&
&7.2152E-10_JPRB,6.5980E-08_JPRB,1.3326E-07_JPRB,2.4370E-07_JPRB,1.6500E-07_JPRB/)
KBO( :, 3,48, 1) = (/&
&8.4803E-10_JPRB,7.0305E-08_JPRB,1.3546E-07_JPRB,2.3079E-07_JPRB,1.7325E-07_JPRB/)
KBO( :, 4,48, 1) = (/&
&1.0576E-09_JPRB,7.6239E-08_JPRB,1.4145E-07_JPRB,2.2533E-07_JPRB,1.8229E-07_JPRB/)
KBO( :, 5,48, 1) = (/&
&1.3781E-09_JPRB,8.4292E-08_JPRB,1.5136E-07_JPRB,2.2672E-07_JPRB,1.9179E-07_JPRB/)
KBO( :, 1,49, 1) = (/&
&5.4144E-10_JPRB,5.1801E-08_JPRB,1.1013E-07_JPRB,2.2618E-07_JPRB,1.2711E-07_JPRB/)
KBO( :, 2,49, 1) = (/&
&5.6629E-10_JPRB,5.3107E-08_JPRB,1.0907E-07_JPRB,2.0553E-07_JPRB,1.3089E-07_JPRB/)
KBO( :, 3,49, 1) = (/&
&6.4486E-10_JPRB,5.5918E-08_JPRB,1.0986E-07_JPRB,1.9244E-07_JPRB,1.3676E-07_JPRB/)
KBO( :, 4,49, 1) = (/&
&7.8735E-10_JPRB,6.0291E-08_JPRB,1.1339E-07_JPRB,1.8565E-07_JPRB,1.4422E-07_JPRB/)
KBO( :, 5,49, 1) = (/&
&1.0106E-09_JPRB,6.6110E-08_JPRB,1.2034E-07_JPRB,1.8446E-07_JPRB,1.5185E-07_JPRB/)
KBO( :, 1,50, 1) = (/&
&4.4437E-10_JPRB,4.2232E-08_JPRB,9.0862E-08_JPRB,1.9444E-07_JPRB,1.0220E-07_JPRB/)
KBO( :, 2,50, 1) = (/&
&4.5142E-10_JPRB,4.2954E-08_JPRB,8.9495E-08_JPRB,1.7367E-07_JPRB,1.0478E-07_JPRB/)
KBO( :, 3,50, 1) = (/&
&4.9792E-10_JPRB,4.4724E-08_JPRB,8.9470E-08_JPRB,1.6100E-07_JPRB,1.0886E-07_JPRB/)
KBO( :, 4,50, 1) = (/&
&5.9436E-10_JPRB,4.7919E-08_JPRB,9.1442E-08_JPRB,1.5352E-07_JPRB,1.1464E-07_JPRB/)
KBO( :, 5,50, 1) = (/&
&7.4940E-10_JPRB,5.2145E-08_JPRB,9.6092E-08_JPRB,1.5086E-07_JPRB,1.2088E-07_JPRB/)
KBO( :, 1,51, 1) = (/&
&3.6713E-10_JPRB,3.4474E-08_JPRB,7.5308E-08_JPRB,1.6803E-07_JPRB,8.2415E-08_JPRB/)
KBO( :, 2,51, 1) = (/&
&3.6430E-10_JPRB,3.4862E-08_JPRB,7.3571E-08_JPRB,1.4732E-07_JPRB,8.4283E-08_JPRB/)
KBO( :, 3,51, 1) = (/&
&3.8938E-10_JPRB,3.5958E-08_JPRB,7.3095E-08_JPRB,1.3515E-07_JPRB,8.7129E-08_JPRB/)
KBO( :, 4,51, 1) = (/&
&4.5287E-10_JPRB,3.8169E-08_JPRB,7.4068E-08_JPRB,1.2746E-07_JPRB,9.1359E-08_JPRB/)
KBO( :, 5,51, 1) = (/&
&5.6042E-10_JPRB,4.1297E-08_JPRB,7.7005E-08_JPRB,1.2390E-07_JPRB,9.6467E-08_JPRB/)
KBO( :, 1,52, 1) = (/&
&3.0507E-10_JPRB,2.8135E-08_JPRB,6.2903E-08_JPRB,1.4596E-07_JPRB,6.6326E-08_JPRB/)
KBO( :, 2,52, 1) = (/&
&2.9709E-10_JPRB,2.8385E-08_JPRB,6.0554E-08_JPRB,1.2580E-07_JPRB,6.7717E-08_JPRB/)
KBO( :, 3,52, 1) = (/&
&3.0805E-10_JPRB,2.9029E-08_JPRB,5.9886E-08_JPRB,1.1380E-07_JPRB,6.9709E-08_JPRB/)
KBO( :, 4,52, 1) = (/&
&3.4776E-10_JPRB,3.0470E-08_JPRB,6.0190E-08_JPRB,1.0625E-07_JPRB,7.2725E-08_JPRB/)
KBO( :, 5,52, 1) = (/&
&4.2195E-10_JPRB,3.2800E-08_JPRB,6.1944E-08_JPRB,1.0216E-07_JPRB,7.6745E-08_JPRB/)
KBO( :, 1,53, 1) = (/&
&2.5471E-10_JPRB,2.2998E-08_JPRB,5.2959E-08_JPRB,1.2738E-07_JPRB,5.3131E-08_JPRB/)
KBO( :, 2,53, 1) = (/&
&2.4432E-10_JPRB,2.3152E-08_JPRB,5.0007E-08_JPRB,1.0819E-07_JPRB,5.4179E-08_JPRB/)
KBO( :, 3,53, 1) = (/&
&2.4654E-10_JPRB,2.3508E-08_JPRB,4.9165E-08_JPRB,9.6195E-08_JPRB,5.5658E-08_JPRB/)
KBO( :, 4,53, 1) = (/&
&2.6977E-10_JPRB,2.4417E-08_JPRB,4.9071E-08_JPRB,8.8939E-08_JPRB,5.7790E-08_JPRB/)
KBO( :, 5,53, 1) = (/&
&3.1992E-10_JPRB,2.6104E-08_JPRB,5.0031E-08_JPRB,8.4550E-08_JPRB,6.0803E-08_JPRB/)
KBO( :, 1,54, 1) = (/&
&2.1314E-10_JPRB,1.8852E-08_JPRB,4.4748E-08_JPRB,1.1115E-07_JPRB,4.3302E-08_JPRB/)
KBO( :, 2,54, 1) = (/&
&2.0193E-10_JPRB,1.8904E-08_JPRB,4.1449E-08_JPRB,9.3135E-08_JPRB,4.4067E-08_JPRB/)
KBO( :, 3,54, 1) = (/&
&1.9965E-10_JPRB,1.9105E-08_JPRB,4.0409E-08_JPRB,8.1420E-08_JPRB,4.5177E-08_JPRB/)
KBO( :, 4,54, 1) = (/&
&2.1224E-10_JPRB,1.9678E-08_JPRB,4.0114E-08_JPRB,7.4541E-08_JPRB,4.6704E-08_JPRB/)
KBO( :, 5,54, 1) = (/&
&2.4557E-10_JPRB,2.0847E-08_JPRB,4.0586E-08_JPRB,7.0154E-08_JPRB,4.8932E-08_JPRB/)
KBO( :, 1,55, 1) = (/&
&1.7867E-10_JPRB,1.5555E-08_JPRB,3.7972E-08_JPRB,9.7108E-08_JPRB,3.5728E-08_JPRB/)
KBO( :, 2,55, 1) = (/&
&1.6760E-10_JPRB,1.5433E-08_JPRB,3.4555E-08_JPRB,8.0306E-08_JPRB,3.6271E-08_JPRB/)
KBO( :, 3,55, 1) = (/&
&1.6306E-10_JPRB,1.5570E-08_JPRB,3.3237E-08_JPRB,6.9179E-08_JPRB,3.7075E-08_JPRB/)
KBO( :, 4,55, 1) = (/&
&1.6881E-10_JPRB,1.5918E-08_JPRB,3.2865E-08_JPRB,6.2543E-08_JPRB,3.8181E-08_JPRB/)
KBO( :, 5,55, 1) = (/&
&1.9022E-10_JPRB,1.6697E-08_JPRB,3.3018E-08_JPRB,5.8357E-08_JPRB,3.9829E-08_JPRB/)
KBO( :, 1,56, 1) = (/&
&1.5014E-10_JPRB,1.2915E-08_JPRB,3.2380E-08_JPRB,8.5055E-08_JPRB,2.9526E-08_JPRB/)
KBO( :, 2,56, 1) = (/&
&1.3958E-10_JPRB,1.2616E-08_JPRB,2.8978E-08_JPRB,6.9473E-08_JPRB,2.9904E-08_JPRB/)
KBO( :, 3,56, 1) = (/&
&1.3402E-10_JPRB,1.2704E-08_JPRB,2.7411E-08_JPRB,5.9088E-08_JPRB,3.0485E-08_JPRB/)
KBO( :, 4,56, 1) = (/&
&1.3548E-10_JPRB,1.2908E-08_JPRB,2.6966E-08_JPRB,5.2631E-08_JPRB,3.1281E-08_JPRB/)
KBO( :, 5,56, 1) = (/&
&1.4854E-10_JPRB,1.3416E-08_JPRB,2.6928E-08_JPRB,4.8694E-08_JPRB,3.2487E-08_JPRB/)
KBO( :, 1,57, 1) = (/&
&1.2648E-10_JPRB,1.0778E-08_JPRB,2.7708E-08_JPRB,7.4942E-08_JPRB,2.4443E-08_JPRB/)
KBO( :, 2,57, 1) = (/&
&1.1666E-10_JPRB,1.0334E-08_JPRB,2.4430E-08_JPRB,6.0404E-08_JPRB,2.4707E-08_JPRB/)
KBO( :, 3,57, 1) = (/&
&1.1067E-10_JPRB,1.0374E-08_JPRB,2.2691E-08_JPRB,5.0714E-08_JPRB,2.5111E-08_JPRB/)
KBO( :, 4,57, 1) = (/&
&1.0967E-10_JPRB,1.0490E-08_JPRB,2.2155E-08_JPRB,4.4446E-08_JPRB,2.5686E-08_JPRB/)
KBO( :, 5,57, 1) = (/&
&1.1697E-10_JPRB,1.0815E-08_JPRB,2.2007E-08_JPRB,4.0752E-08_JPRB,2.6560E-08_JPRB/)
KBO( :, 1,58, 1) = (/&
&1.0659E-10_JPRB,9.0293E-09_JPRB,2.3759E-08_JPRB,6.6089E-08_JPRB,2.0347E-08_JPRB/)
KBO( :, 2,58, 1) = (/&
&9.7636E-11_JPRB,8.5135E-09_JPRB,2.0668E-08_JPRB,5.2543E-08_JPRB,2.0525E-08_JPRB/)
KBO( :, 3,58, 1) = (/&
&9.1732E-11_JPRB,8.4689E-09_JPRB,1.8876E-08_JPRB,4.3570E-08_JPRB,2.0785E-08_JPRB/)
KBO( :, 4,58, 1) = (/&
&8.9487E-11_JPRB,8.5483E-09_JPRB,1.8213E-08_JPRB,3.7645E-08_JPRB,2.1195E-08_JPRB/)
KBO( :, 5,58, 1) = (/&
&9.3059E-11_JPRB,8.7505E-09_JPRB,1.8022E-08_JPRB,3.4131E-08_JPRB,2.1827E-08_JPRB/)
KBO( :, 1,59, 1) = (/&
&8.8331E-11_JPRB,7.4630E-09_JPRB,1.9793E-08_JPRB,5.5593E-08_JPRB,1.7482E-08_JPRB/)
KBO( :, 2,59, 1) = (/&
&8.0694E-11_JPRB,6.9932E-09_JPRB,1.7133E-08_JPRB,4.3957E-08_JPRB,1.7486E-08_JPRB/)
KBO( :, 3,59, 1) = (/&
&7.5549E-11_JPRB,6.9233E-09_JPRB,1.5553E-08_JPRB,3.6288E-08_JPRB,1.7620E-08_JPRB/)
KBO( :, 4,59, 1) = (/&
&7.3293E-11_JPRB,6.9863E-09_JPRB,1.4925E-08_JPRB,3.1206E-08_JPRB,1.7870E-08_JPRB/)
KBO( :, 5,59, 1) = (/&
&7.5492E-11_JPRB,7.1328E-09_JPRB,1.4750E-08_JPRB,2.8159E-08_JPRB,1.8369E-08_JPRB/)
KBO( :, 1,13, 2) = (/&
&1.7831E-06_JPRB,1.1485E-04_JPRB,2.2492E-04_JPRB,4.1688E-04_JPRB,6.0547E-04_JPRB/)
KBO( :, 2,13, 2) = (/&
&2.2523E-06_JPRB,1.2306E-04_JPRB,2.2855E-04_JPRB,3.8873E-04_JPRB,6.9580E-04_JPRB/)
KBO( :, 3,13, 2) = (/&
&3.1401E-06_JPRB,1.3738E-04_JPRB,2.4315E-04_JPRB,3.7873E-04_JPRB,8.1218E-04_JPRB/)
KBO( :, 4,13, 2) = (/&
&4.6444E-06_JPRB,1.5956E-04_JPRB,2.6822E-04_JPRB,3.8629E-04_JPRB,9.5399E-04_JPRB/)
KBO( :, 5,13, 2) = (/&
&7.0313E-06_JPRB,1.8987E-04_JPRB,3.0507E-04_JPRB,4.1261E-04_JPRB,1.1192E-03_JPRB/)
KBO( :, 1,14, 2) = (/&
&1.5078E-06_JPRB,9.3955E-05_JPRB,1.8376E-04_JPRB,3.3845E-04_JPRB,5.0372E-04_JPRB/)
KBO( :, 2,14, 2) = (/&
&1.9334E-06_JPRB,1.0121E-04_JPRB,1.8743E-04_JPRB,3.1713E-04_JPRB,5.7910E-04_JPRB/)
KBO( :, 3,14, 2) = (/&
&2.7160E-06_JPRB,1.1368E-04_JPRB,2.0048E-04_JPRB,3.1032E-04_JPRB,6.7658E-04_JPRB/)
KBO( :, 4,14, 2) = (/&
&4.0314E-06_JPRB,1.3266E-04_JPRB,2.2233E-04_JPRB,3.1845E-04_JPRB,7.9423E-04_JPRB/)
KBO( :, 5,14, 2) = (/&
&6.1144E-06_JPRB,1.5848E-04_JPRB,2.5408E-04_JPRB,3.4197E-04_JPRB,9.2922E-04_JPRB/)
KBO( :, 1,15, 2) = (/&
&1.2774E-06_JPRB,7.6659E-05_JPRB,1.4966E-04_JPRB,2.7428E-04_JPRB,4.0806E-04_JPRB/)
KBO( :, 2,15, 2) = (/&
&1.6539E-06_JPRB,8.3075E-05_JPRB,1.5341E-04_JPRB,2.5818E-04_JPRB,4.6824E-04_JPRB/)
KBO( :, 3,15, 2) = (/&
&2.3327E-06_JPRB,9.3823E-05_JPRB,1.6504E-04_JPRB,2.5400E-04_JPRB,5.4554E-04_JPRB/)
KBO( :, 4,15, 2) = (/&
&3.4694E-06_JPRB,1.1007E-04_JPRB,1.8398E-04_JPRB,2.6231E-04_JPRB,6.3780E-04_JPRB/)
KBO( :, 5,15, 2) = (/&
&5.2705E-06_JPRB,1.3207E-04_JPRB,2.1119E-04_JPRB,2.8323E-04_JPRB,7.4509E-04_JPRB/)
KBO( :, 1,16, 2) = (/&
&1.0807E-06_JPRB,6.2530E-05_JPRB,1.2180E-04_JPRB,2.2215E-04_JPRB,3.2808E-04_JPRB/)
KBO( :, 2,16, 2) = (/&
&1.4084E-06_JPRB,6.8196E-05_JPRB,1.2558E-04_JPRB,2.1014E-04_JPRB,3.7445E-04_JPRB/)
KBO( :, 3,16, 2) = (/&
&1.9921E-06_JPRB,7.7409E-05_JPRB,1.3589E-04_JPRB,2.0792E-04_JPRB,4.3322E-04_JPRB/)
KBO( :, 4,16, 2) = (/&
&2.9709E-06_JPRB,9.1317E-05_JPRB,1.5223E-04_JPRB,2.1610E-04_JPRB,5.0329E-04_JPRB/)
KBO( :, 5,16, 2) = (/&
&4.5175E-06_JPRB,1.1013E-04_JPRB,1.7552E-04_JPRB,2.3456E-04_JPRB,5.8394E-04_JPRB/)
KBO( :, 1,17, 2) = (/&
&9.1180E-07_JPRB,5.1179E-05_JPRB,9.9386E-05_JPRB,1.8025E-04_JPRB,2.6437E-04_JPRB/)
KBO( :, 2,17, 2) = (/&
&1.1946E-06_JPRB,5.6143E-05_JPRB,1.0310E-04_JPRB,1.7134E-04_JPRB,2.9996E-04_JPRB/)
KBO( :, 3,17, 2) = (/&
&1.6972E-06_JPRB,6.4077E-05_JPRB,1.1216E-04_JPRB,1.7049E-04_JPRB,3.4494E-04_JPRB/)
KBO( :, 4,17, 2) = (/&
&2.5402E-06_JPRB,7.6034E-05_JPRB,1.2620E-04_JPRB,1.7834E-04_JPRB,3.9850E-04_JPRB/)
KBO( :, 5,17, 2) = (/&
&3.8602E-06_JPRB,9.2137E-05_JPRB,1.4620E-04_JPRB,1.9446E-04_JPRB,4.6053E-04_JPRB/)
KBO( :, 1,18, 2) = (/&
&7.6847E-07_JPRB,4.2128E-05_JPRB,8.1427E-05_JPRB,1.4663E-04_JPRB,2.1428E-04_JPRB/)
KBO( :, 2,18, 2) = (/&
&1.0140E-06_JPRB,4.6467E-05_JPRB,8.5018E-05_JPRB,1.4005E-04_JPRB,2.4221E-04_JPRB/)
KBO( :, 3,18, 2) = (/&
&1.4492E-06_JPRB,5.3358E-05_JPRB,9.2939E-05_JPRB,1.4019E-04_JPRB,2.7739E-04_JPRB/)
KBO( :, 4,18, 2) = (/&
&2.1756E-06_JPRB,6.3671E-05_JPRB,1.0504E-04_JPRB,1.4753E-04_JPRB,3.1937E-04_JPRB/)
KBO( :, 5,18, 2) = (/&
&3.2973E-06_JPRB,7.7469E-05_JPRB,1.2233E-04_JPRB,1.6159E-04_JPRB,3.6805E-04_JPRB/)
KBO( :, 1,19, 2) = (/&
&6.4665E-07_JPRB,3.4756E-05_JPRB,6.6830E-05_JPRB,1.1940E-04_JPRB,1.7455E-04_JPRB/)
KBO( :, 2,19, 2) = (/&
&8.6026E-07_JPRB,3.8528E-05_JPRB,7.0212E-05_JPRB,1.1460E-04_JPRB,1.9694E-04_JPRB/)
KBO( :, 3,19, 2) = (/&
&1.2368E-06_JPRB,4.4528E-05_JPRB,7.7120E-05_JPRB,1.1540E-04_JPRB,2.2498E-04_JPRB/)
KBO( :, 4,19, 2) = (/&
&1.8580E-06_JPRB,5.3404E-05_JPRB,8.7557E-05_JPRB,1.2215E-04_JPRB,2.5850E-04_JPRB/)
KBO( :, 5,19, 2) = (/&
&2.8103E-06_JPRB,6.5162E-05_JPRB,1.0249E-04_JPRB,1.3438E-04_JPRB,2.9679E-04_JPRB/)
KBO( :, 1,20, 2) = (/&
&5.4656E-07_JPRB,2.8770E-05_JPRB,5.4975E-05_JPRB,9.7196E-05_JPRB,1.4326E-04_JPRB/)
KBO( :, 2,20, 2) = (/&
&7.3436E-07_JPRB,3.2085E-05_JPRB,5.8157E-05_JPRB,9.3865E-05_JPRB,1.6155E-04_JPRB/)
KBO( :, 3,20, 2) = (/&
&1.0622E-06_JPRB,3.7358E-05_JPRB,6.4221E-05_JPRB,9.5159E-05_JPRB,1.8436E-04_JPRB/)
KBO( :, 4,20, 2) = (/&
&1.5965E-06_JPRB,4.4974E-05_JPRB,7.3287E-05_JPRB,1.0139E-04_JPRB,2.1149E-04_JPRB/)
KBO( :, 5,20, 2) = (/&
&2.4119E-06_JPRB,5.5033E-05_JPRB,8.6244E-05_JPRB,1.1207E-04_JPRB,2.4172E-04_JPRB/)
KBO( :, 1,21, 2) = (/&
&4.6233E-07_JPRB,2.3834E-05_JPRB,4.5264E-05_JPRB,7.9149E-05_JPRB,1.1774E-04_JPRB/)
KBO( :, 2,21, 2) = (/&
&6.2707E-07_JPRB,2.6751E-05_JPRB,4.8202E-05_JPRB,7.6928E-05_JPRB,1.3273E-04_JPRB/)
KBO( :, 3,21, 2) = (/&
&9.1123E-07_JPRB,3.1358E-05_JPRB,5.3515E-05_JPRB,7.8550E-05_JPRB,1.5133E-04_JPRB/)
KBO( :, 4,21, 2) = (/&
&1.3711E-06_JPRB,3.7856E-05_JPRB,6.1405E-05_JPRB,8.4206E-05_JPRB,1.7321E-04_JPRB/)
KBO( :, 5,21, 2) = (/&
&2.0698E-06_JPRB,4.6466E-05_JPRB,7.2555E-05_JPRB,9.3524E-05_JPRB,1.9698E-04_JPRB/)
KBO( :, 1,22, 2) = (/&
&3.9809E-07_JPRB,1.9861E-05_JPRB,3.7362E-05_JPRB,6.4255E-05_JPRB,9.7130E-05_JPRB/)
KBO( :, 2,22, 2) = (/&
&5.4666E-07_JPRB,2.2487E-05_JPRB,4.0159E-05_JPRB,6.3058E-05_JPRB,1.0946E-04_JPRB/)
KBO( :, 3,22, 2) = (/&
&8.0057E-07_JPRB,2.6577E-05_JPRB,4.4935E-05_JPRB,6.5070E-05_JPRB,1.2456E-04_JPRB/)
KBO( :, 4,22, 2) = (/&
&1.2071E-06_JPRB,3.2211E-05_JPRB,5.1924E-05_JPRB,7.0344E-05_JPRB,1.4182E-04_JPRB/)
KBO( :, 5,22, 2) = (/&
&1.8195E-06_JPRB,3.9674E-05_JPRB,6.1645E-05_JPRB,7.8623E-05_JPRB,1.6040E-04_JPRB/)
KBO( :, 1,23, 2) = (/&
&3.4367E-07_JPRB,1.6568E-05_JPRB,3.0880E-05_JPRB,5.2238E-05_JPRB,8.0021E-05_JPRB/)
KBO( :, 2,23, 2) = (/&
&4.7758E-07_JPRB,1.8928E-05_JPRB,3.3504E-05_JPRB,5.1762E-05_JPRB,9.0054E-05_JPRB/)
KBO( :, 3,23, 2) = (/&
&7.0447E-07_JPRB,2.2529E-05_JPRB,3.7774E-05_JPRB,5.3990E-05_JPRB,1.0211E-04_JPRB/)
KBO( :, 4,23, 2) = (/&
&1.0638E-06_JPRB,2.7414E-05_JPRB,4.3928E-05_JPRB,5.8845E-05_JPRB,1.1542E-04_JPRB/)
KBO( :, 5,23, 2) = (/&
&1.6007E-06_JPRB,3.3849E-05_JPRB,5.2353E-05_JPRB,6.6134E-05_JPRB,1.3002E-04_JPRB/)
KBO( :, 1,24, 2) = (/&
&2.9731E-07_JPRB,1.3817E-05_JPRB,2.5531E-05_JPRB,4.2477E-05_JPRB,6.5483E-05_JPRB/)
KBO( :, 2,24, 2) = (/&
&4.1800E-07_JPRB,1.5925E-05_JPRB,2.7963E-05_JPRB,4.2525E-05_JPRB,7.3450E-05_JPRB/)
KBO( :, 3,24, 2) = (/&
&6.2039E-07_JPRB,1.9083E-05_JPRB,3.1748E-05_JPRB,4.4841E-05_JPRB,8.2603E-05_JPRB/)
KBO( :, 4,24, 2) = (/&
&9.3799E-07_JPRB,2.3303E-05_JPRB,3.7155E-05_JPRB,4.9236E-05_JPRB,9.2771E-05_JPRB/)
KBO( :, 5,24, 2) = (/&
&1.4084E-06_JPRB,2.8824E-05_JPRB,4.4404E-05_JPRB,5.5621E-05_JPRB,1.0401E-04_JPRB/)
KBO( :, 1,25, 2) = (/&
&2.5846E-07_JPRB,1.1557E-05_JPRB,2.1168E-05_JPRB,3.4591E-05_JPRB,5.3402E-05_JPRB/)
KBO( :, 2,25, 2) = (/&
&3.6779E-07_JPRB,1.3446E-05_JPRB,2.3397E-05_JPRB,3.5019E-05_JPRB,5.9504E-05_JPRB/)
KBO( :, 3,25, 2) = (/&
&5.4914E-07_JPRB,1.6203E-05_JPRB,2.6747E-05_JPRB,3.7316E-05_JPRB,6.6453E-05_JPRB/)
KBO( :, 4,25, 2) = (/&
&8.3081E-07_JPRB,1.9848E-05_JPRB,3.1489E-05_JPRB,4.1271E-05_JPRB,7.4204E-05_JPRB/)
KBO( :, 5,25, 2) = (/&
&1.2434E-06_JPRB,2.4586E-05_JPRB,3.7706E-05_JPRB,4.6843E-05_JPRB,8.2964E-05_JPRB/)
KBO( :, 1,26, 2) = (/&
&2.2688E-07_JPRB,9.7182E-06_JPRB,1.7626E-05_JPRB,2.8238E-05_JPRB,4.3458E-05_JPRB/)
KBO( :, 2,26, 2) = (/&
&3.2698E-07_JPRB,1.1421E-05_JPRB,1.9660E-05_JPRB,2.8946E-05_JPRB,4.8104E-05_JPRB/)
KBO( :, 3,26, 2) = (/&
&4.9095E-07_JPRB,1.3827E-05_JPRB,2.2642E-05_JPRB,3.1162E-05_JPRB,5.3458E-05_JPRB/)
KBO( :, 4,26, 2) = (/&
&7.4254E-07_JPRB,1.6991E-05_JPRB,2.6804E-05_JPRB,3.4710E-05_JPRB,5.9616E-05_JPRB/)
KBO( :, 5,26, 2) = (/&
&1.1064E-06_JPRB,2.1073E-05_JPRB,3.2131E-05_JPRB,3.9581E-05_JPRB,6.6564E-05_JPRB/)
KBO( :, 1,27, 2) = (/&
&1.9993E-07_JPRB,8.1890E-06_JPRB,1.4706E-05_JPRB,2.3104E-05_JPRB,3.4885E-05_JPRB/)
KBO( :, 2,27, 2) = (/&
&2.9147E-07_JPRB,9.7120E-06_JPRB,1.6544E-05_JPRB,2.3984E-05_JPRB,3.8444E-05_JPRB/)
KBO( :, 3,27, 2) = (/&
&4.3955E-07_JPRB,1.1803E-05_JPRB,1.9192E-05_JPRB,2.6063E-05_JPRB,4.2658E-05_JPRB/)
KBO( :, 4,27, 2) = (/&
&6.6365E-07_JPRB,1.4549E-05_JPRB,2.2817E-05_JPRB,2.9214E-05_JPRB,4.7548E-05_JPRB/)
KBO( :, 5,27, 2) = (/&
&9.8399E-07_JPRB,1.8060E-05_JPRB,2.7381E-05_JPRB,3.3454E-05_JPRB,5.3034E-05_JPRB/)
KBO( :, 1,28, 2) = (/&
&1.7666E-07_JPRB,6.9106E-06_JPRB,1.2291E-05_JPRB,1.8950E-05_JPRB,2.7614E-05_JPRB/)
KBO( :, 2,28, 2) = (/&
&2.6027E-07_JPRB,8.2613E-06_JPRB,1.3939E-05_JPRB,1.9912E-05_JPRB,3.0347E-05_JPRB/)
KBO( :, 3,28, 2) = (/&
&3.9360E-07_JPRB,1.0076E-05_JPRB,1.6277E-05_JPRB,2.1822E-05_JPRB,3.3665E-05_JPRB/)
KBO( :, 4,28, 2) = (/&
&5.9255E-07_JPRB,1.2455E-05_JPRB,1.9419E-05_JPRB,2.4599E-05_JPRB,3.7521E-05_JPRB/)
KBO( :, 5,28, 2) = (/&
&8.7397E-07_JPRB,1.5474E-05_JPRB,2.3332E-05_JPRB,2.8281E-05_JPRB,4.1809E-05_JPRB/)
KBO( :, 1,29, 2) = (/&
&1.5731E-07_JPRB,5.8606E-06_JPRB,1.0316E-05_JPRB,1.5600E-05_JPRB,2.1902E-05_JPRB/)
KBO( :, 2,29, 2) = (/&
&2.3400E-07_JPRB,7.0543E-06_JPRB,1.1790E-05_JPRB,1.6590E-05_JPRB,2.4089E-05_JPRB/)
KBO( :, 3,29, 2) = (/&
&3.5418E-07_JPRB,8.6343E-06_JPRB,1.3853E-05_JPRB,1.8324E-05_JPRB,2.6737E-05_JPRB/)
KBO( :, 4,29, 2) = (/&
&5.3119E-07_JPRB,1.0700E-05_JPRB,1.6576E-05_JPRB,2.0766E-05_JPRB,2.9758E-05_JPRB/)
KBO( :, 5,29, 2) = (/&
&7.7916E-07_JPRB,1.3299E-05_JPRB,1.9939E-05_JPRB,2.3971E-05_JPRB,3.3117E-05_JPRB/)
KBO( :, 1,30, 2) = (/&
&1.4063E-07_JPRB,4.9824E-06_JPRB,8.6764E-06_JPRB,1.2880E-05_JPRB,1.7310E-05_JPRB/)
KBO( :, 2,30, 2) = (/&
&2.1067E-07_JPRB,6.0303E-06_JPRB,9.9875E-06_JPRB,1.3848E-05_JPRB,1.9047E-05_JPRB/)
KBO( :, 3,30, 2) = (/&
&3.1873E-07_JPRB,7.4093E-06_JPRB,1.1804E-05_JPRB,1.5408E-05_JPRB,2.1112E-05_JPRB/)
KBO( :, 4,30, 2) = (/&
&4.7602E-07_JPRB,9.1990E-06_JPRB,1.4156E-05_JPRB,1.7550E-05_JPRB,2.3467E-05_JPRB/)
KBO( :, 5,30, 2) = (/&
&6.9431E-07_JPRB,1.1442E-05_JPRB,1.7053E-05_JPRB,2.0340E-05_JPRB,2.6091E-05_JPRB/)
KBO( :, 1,31, 2) = (/&
&1.2644E-07_JPRB,4.2516E-06_JPRB,7.3195E-06_JPRB,1.0673E-05_JPRB,1.3682E-05_JPRB/)
KBO( :, 2,31, 2) = (/&
&1.9031E-07_JPRB,5.1693E-06_JPRB,8.4857E-06_JPRB,1.1593E-05_JPRB,1.5034E-05_JPRB/)
KBO( :, 3,31, 2) = (/&
&2.8751E-07_JPRB,6.3745E-06_JPRB,1.0084E-05_JPRB,1.2985E-05_JPRB,1.6635E-05_JPRB/)
KBO( :, 4,31, 2) = (/&
&4.2724E-07_JPRB,7.9260E-06_JPRB,1.2109E-05_JPRB,1.4860E-05_JPRB,1.8446E-05_JPRB/)
KBO( :, 5,31, 2) = (/&
&6.1916E-07_JPRB,9.8570E-06_JPRB,1.4602E-05_JPRB,1.7280E-05_JPRB,2.0481E-05_JPRB/)
KBO( :, 1,32, 2) = (/&
&1.1409E-07_JPRB,3.6379E-06_JPRB,6.1915E-06_JPRB,8.8747E-06_JPRB,1.0783E-05_JPRB/)
KBO( :, 2,32, 2) = (/&
&1.7228E-07_JPRB,4.4412E-06_JPRB,7.2287E-06_JPRB,9.7273E-06_JPRB,1.1842E-05_JPRB/)
KBO( :, 3,32, 2) = (/&
&2.5962E-07_JPRB,5.4949E-06_JPRB,8.6268E-06_JPRB,1.0963E-05_JPRB,1.3078E-05_JPRB/)
KBO( :, 4,32, 2) = (/&
&3.8365E-07_JPRB,6.8377E-06_JPRB,1.0371E-05_JPRB,1.2605E-05_JPRB,1.4477E-05_JPRB/)
KBO( :, 5,32, 2) = (/&
&5.5233E-07_JPRB,8.5032E-06_JPRB,1.2515E-05_JPRB,1.4698E-05_JPRB,1.6068E-05_JPRB/)
KBO( :, 1,33, 2) = (/&
&1.0319E-07_JPRB,3.1180E-06_JPRB,5.2481E-06_JPRB,7.4004E-06_JPRB,8.4500E-06_JPRB/)
KBO( :, 2,33, 2) = (/&
&1.5612E-07_JPRB,3.8215E-06_JPRB,6.1686E-06_JPRB,8.1771E-06_JPRB,9.2833E-06_JPRB/)
KBO( :, 3,33, 2) = (/&
&2.3441E-07_JPRB,4.7418E-06_JPRB,7.3861E-06_JPRB,9.2700E-06_JPRB,1.0235E-05_JPRB/)
KBO( :, 4,33, 2) = (/&
&3.4446E-07_JPRB,5.9060E-06_JPRB,8.8925E-06_JPRB,1.0710E-05_JPRB,1.1335E-05_JPRB/)
KBO( :, 5,33, 2) = (/&
&4.9241E-07_JPRB,7.3371E-06_JPRB,1.0731E-05_JPRB,1.2507E-05_JPRB,1.2576E-05_JPRB/)
KBO( :, 1,34, 2) = (/&
&9.2307E-08_JPRB,2.6619E-06_JPRB,4.4385E-06_JPRB,6.1710E-06_JPRB,6.7086E-06_JPRB/)
KBO( :, 2,34, 2) = (/&
&1.3970E-07_JPRB,3.2731E-06_JPRB,5.2448E-06_JPRB,6.8652E-06_JPRB,7.3666E-06_JPRB/)
KBO( :, 3,34, 2) = (/&
&2.0895E-07_JPRB,4.0690E-06_JPRB,6.2930E-06_JPRB,7.8186E-06_JPRB,8.1274E-06_JPRB/)
KBO( :, 4,34, 2) = (/&
&3.0532E-07_JPRB,5.0681E-06_JPRB,7.5836E-06_JPRB,9.0634E-06_JPRB,9.0071E-06_JPRB/)
KBO( :, 5,34, 2) = (/&
&4.3392E-07_JPRB,6.2912E-06_JPRB,9.1516E-06_JPRB,1.0598E-05_JPRB,1.0001E-05_JPRB/)
KBO( :, 1,35, 2) = (/&
&7.9334E-08_JPRB,2.2294E-06_JPRB,3.6998E-06_JPRB,5.1049E-06_JPRB,5.2466E-06_JPRB/)
KBO( :, 2,35, 2) = (/&
&1.2002E-07_JPRB,2.7467E-06_JPRB,4.3846E-06_JPRB,5.6993E-06_JPRB,5.7554E-06_JPRB/)
KBO( :, 3,35, 2) = (/&
&1.7912E-07_JPRB,3.4176E-06_JPRB,5.2654E-06_JPRB,6.5073E-06_JPRB,6.3538E-06_JPRB/)
KBO( :, 4,35, 2) = (/&
&2.6096E-07_JPRB,4.2572E-06_JPRB,6.3499E-06_JPRB,7.5566E-06_JPRB,7.0484E-06_JPRB/)
KBO( :, 5,35, 2) = (/&
&3.6971E-07_JPRB,5.2820E-06_JPRB,7.6616E-06_JPRB,8.8415E-06_JPRB,7.8403E-06_JPRB/)
KBO( :, 1,36, 2) = (/&
&6.5133E-08_JPRB,1.8258E-06_JPRB,3.0305E-06_JPRB,4.1781E-06_JPRB,4.0391E-06_JPRB/)
KBO( :, 2,36, 2) = (/&
&9.8521E-08_JPRB,2.2504E-06_JPRB,3.5927E-06_JPRB,4.6670E-06_JPRB,4.4257E-06_JPRB/)
KBO( :, 3,36, 2) = (/&
&1.4704E-07_JPRB,2.8014E-06_JPRB,4.3159E-06_JPRB,5.3307E-06_JPRB,4.8851E-06_JPRB/)
KBO( :, 4,36, 2) = (/&
&2.1423E-07_JPRB,3.4905E-06_JPRB,5.2056E-06_JPRB,6.1919E-06_JPRB,5.4221E-06_JPRB/)
KBO( :, 5,36, 2) = (/&
&3.0347E-07_JPRB,4.3311E-06_JPRB,6.2810E-06_JPRB,7.2464E-06_JPRB,6.0400E-06_JPRB/)
KBO( :, 1,37, 2) = (/&
&5.0409E-08_JPRB,1.4546E-06_JPRB,2.4297E-06_JPRB,3.3777E-06_JPRB,3.1888E-06_JPRB/)
KBO( :, 2,37, 2) = (/&
&7.6278E-08_JPRB,1.7897E-06_JPRB,2.8722E-06_JPRB,3.7595E-06_JPRB,3.4883E-06_JPRB/)
KBO( :, 3,37, 2) = (/&
&1.1416E-07_JPRB,2.2265E-06_JPRB,3.4480E-06_JPRB,4.2834E-06_JPRB,3.8454E-06_JPRB/)
KBO( :, 4,37, 2) = (/&
&1.6695E-07_JPRB,2.7752E-06_JPRB,4.1566E-06_JPRB,4.9670E-06_JPRB,4.2653E-06_JPRB/)
KBO( :, 5,37, 2) = (/&
&2.3741E-07_JPRB,3.4464E-06_JPRB,5.0175E-06_JPRB,5.8098E-06_JPRB,4.7509E-06_JPRB/)
KBO( :, 1,38, 2) = (/&
&3.8890E-08_JPRB,1.1572E-06_JPRB,1.9462E-06_JPRB,2.7303E-06_JPRB,2.5173E-06_JPRB/)
KBO( :, 2,38, 2) = (/&
&5.8839E-08_JPRB,1.4211E-06_JPRB,2.2935E-06_JPRB,3.0265E-06_JPRB,2.7490E-06_JPRB/)
KBO( :, 3,38, 2) = (/&
&8.8306E-08_JPRB,1.7664E-06_JPRB,2.7503E-06_JPRB,3.4388E-06_JPRB,3.0259E-06_JPRB/)
KBO( :, 4,38, 2) = (/&
&1.2963E-07_JPRB,2.2023E-06_JPRB,3.3138E-06_JPRB,3.9798E-06_JPRB,3.3533E-06_JPRB/)
KBO( :, 5,38, 2) = (/&
&1.8509E-07_JPRB,2.7372E-06_JPRB,4.0007E-06_JPRB,4.6520E-06_JPRB,3.7342E-06_JPRB/)
KBO( :, 1,39, 2) = (/&
&3.0015E-08_JPRB,9.2084E-07_JPRB,1.5596E-06_JPRB,2.2083E-06_JPRB,1.9828E-06_JPRB/)
KBO( :, 2,39, 2) = (/&
&4.5385E-08_JPRB,1.1288E-06_JPRB,1.8319E-06_JPRB,2.4376E-06_JPRB,2.1608E-06_JPRB/)
KBO( :, 3,39, 2) = (/&
&6.8278E-08_JPRB,1.4014E-06_JPRB,2.1937E-06_JPRB,2.7616E-06_JPRB,2.3751E-06_JPRB/)
KBO( :, 4,39, 2) = (/&
&1.0061E-07_JPRB,1.7477E-06_JPRB,2.6422E-06_JPRB,3.1891E-06_JPRB,2.6290E-06_JPRB/)
KBO( :, 5,39, 2) = (/&
&1.4423E-07_JPRB,2.1734E-06_JPRB,3.1901E-06_JPRB,3.7248E-06_JPRB,2.9256E-06_JPRB/)
KBO( :, 1,40, 2) = (/&
&2.2256E-08_JPRB,7.1912E-07_JPRB,1.2329E-06_JPRB,1.7745E-06_JPRB,1.5697E-06_JPRB/)
KBO( :, 2,40, 2) = (/&
&3.3569E-08_JPRB,8.7851E-07_JPRB,1.4396E-06_JPRB,1.9436E-06_JPRB,1.7055E-06_JPRB/)
KBO( :, 3,40, 2) = (/&
&5.0664E-08_JPRB,1.0879E-06_JPRB,1.7182E-06_JPRB,2.1900E-06_JPRB,1.8705E-06_JPRB/)
KBO( :, 4,40, 2) = (/&
&7.5118E-08_JPRB,1.3564E-06_JPRB,2.0680E-06_JPRB,2.5192E-06_JPRB,2.0668E-06_JPRB/)
KBO( :, 5,40, 2) = (/&
&1.0843E-07_JPRB,1.6886E-06_JPRB,2.4960E-06_JPRB,2.9369E-06_JPRB,2.2973E-06_JPRB/)
KBO( :, 1,41, 2) = (/&
&1.6447E-08_JPRB,5.6080E-07_JPRB,9.7444E-07_JPRB,1.4286E-06_JPRB,1.2435E-06_JPRB/)
KBO( :, 2,41, 2) = (/&
&2.4695E-08_JPRB,6.8242E-07_JPRB,1.1302E-06_JPRB,1.5500E-06_JPRB,1.3469E-06_JPRB/)
KBO( :, 3,41, 2) = (/&
&3.7349E-08_JPRB,8.4229E-07_JPRB,1.3428E-06_JPRB,1.7360E-06_JPRB,1.4732E-06_JPRB/)
KBO( :, 4,41, 2) = (/&
&5.5705E-08_JPRB,1.0497E-06_JPRB,1.6148E-06_JPRB,1.9875E-06_JPRB,1.6246E-06_JPRB/)
KBO( :, 5,41, 2) = (/&
&8.0988E-08_JPRB,1.3075E-06_JPRB,1.9479E-06_JPRB,2.3109E-06_JPRB,1.8030E-06_JPRB/)
KBO( :, 1,42, 2) = (/&
&1.2186E-08_JPRB,4.3819E-07_JPRB,7.7124E-07_JPRB,1.1538E-06_JPRB,9.8460E-07_JPRB/)
KBO( :, 2,42, 2) = (/&
&1.8167E-08_JPRB,5.3040E-07_JPRB,8.8867E-07_JPRB,1.2386E-06_JPRB,1.0631E-06_JPRB/)
KBO( :, 3,42, 2) = (/&
&2.7496E-08_JPRB,6.5240E-07_JPRB,1.0501E-06_JPRB,1.3776E-06_JPRB,1.1592E-06_JPRB/)
KBO( :, 4,42, 2) = (/&
&4.1226E-08_JPRB,8.1205E-07_JPRB,1.2611E-06_JPRB,1.5695E-06_JPRB,1.2755E-06_JPRB/)
KBO( :, 5,42, 2) = (/&
&6.0358E-08_JPRB,1.0122E-06_JPRB,1.5198E-06_JPRB,1.8189E-06_JPRB,1.4129E-06_JPRB/)
KBO( :, 1,43, 2) = (/&
&8.8825E-09_JPRB,3.4025E-07_JPRB,6.0770E-07_JPRB,9.3331E-07_JPRB,7.8085E-07_JPRB/)
KBO( :, 2,43, 2) = (/&
&1.3077E-08_JPRB,4.0821E-07_JPRB,6.9425E-07_JPRB,9.8759E-07_JPRB,8.3977E-07_JPRB/)
KBO( :, 3,43, 2) = (/&
&1.9763E-08_JPRB,4.9996E-07_JPRB,8.1437E-07_JPRB,1.0881E-06_JPRB,9.1252E-07_JPRB/)
KBO( :, 4,43, 2) = (/&
&2.9785E-08_JPRB,6.2062E-07_JPRB,9.7495E-07_JPRB,1.2316E-06_JPRB,1.0010E-06_JPRB/)
KBO( :, 5,43, 2) = (/&
&4.3968E-08_JPRB,7.7371E-07_JPRB,1.1737E-06_JPRB,1.4206E-06_JPRB,1.1059E-06_JPRB/)
KBO( :, 1,44, 2) = (/&
&6.4652E-09_JPRB,2.6432E-07_JPRB,4.7930E-07_JPRB,7.5854E-07_JPRB,6.2018E-07_JPRB/)
KBO( :, 2,44, 2) = (/&
&9.3431E-09_JPRB,3.1321E-07_JPRB,5.4189E-07_JPRB,7.8917E-07_JPRB,6.6342E-07_JPRB/)
KBO( :, 3,44, 2) = (/&
&1.4054E-08_JPRB,3.8170E-07_JPRB,6.3021E-07_JPRB,8.5948E-07_JPRB,7.1866E-07_JPRB/)
KBO( :, 4,44, 2) = (/&
&2.1257E-08_JPRB,4.7192E-07_JPRB,7.5053E-07_JPRB,9.6532E-07_JPRB,7.8542E-07_JPRB/)
KBO( :, 5,44, 2) = (/&
&3.1636E-08_JPRB,5.8814E-07_JPRB,9.0255E-07_JPRB,1.1069E-06_JPRB,8.6508E-07_JPRB/)
KBO( :, 1,45, 2) = (/&
&4.7493E-09_JPRB,2.0618E-07_JPRB,3.7955E-07_JPRB,6.2010E-07_JPRB,4.9320E-07_JPRB/)
KBO( :, 2,45, 2) = (/&
&6.7046E-09_JPRB,2.4103E-07_JPRB,4.2421E-07_JPRB,6.3409E-07_JPRB,5.2372E-07_JPRB/)
KBO( :, 3,45, 2) = (/&
&9.9979E-09_JPRB,2.9183E-07_JPRB,4.8903E-07_JPRB,6.8121E-07_JPRB,5.6534E-07_JPRB/)
KBO( :, 4,45, 2) = (/&
&1.5142E-08_JPRB,3.5915E-07_JPRB,5.7833E-07_JPRB,7.5825E-07_JPRB,6.1575E-07_JPRB/)
KBO( :, 5,45, 2) = (/&
&2.2692E-08_JPRB,4.4695E-07_JPRB,6.9435E-07_JPRB,8.6394E-07_JPRB,6.7584E-07_JPRB/)
KBO( :, 1,46, 2) = (/&
&3.5026E-09_JPRB,1.6095E-07_JPRB,3.0164E-07_JPRB,5.0988E-07_JPRB,3.9266E-07_JPRB/)
KBO( :, 2,46, 2) = (/&
&4.8056E-09_JPRB,1.8571E-07_JPRB,3.3238E-07_JPRB,5.1211E-07_JPRB,4.1411E-07_JPRB/)
KBO( :, 3,46, 2) = (/&
&7.0611E-09_JPRB,2.2256E-07_JPRB,3.7936E-07_JPRB,5.4108E-07_JPRB,4.4422E-07_JPRB/)
KBO( :, 4,46, 2) = (/&
&1.0674E-08_JPRB,2.7254E-07_JPRB,4.4484E-07_JPRB,5.9573E-07_JPRB,4.8213E-07_JPRB/)
KBO( :, 5,46, 2) = (/&
&1.6091E-08_JPRB,3.3807E-07_JPRB,5.3220E-07_JPRB,6.7368E-07_JPRB,5.2739E-07_JPRB/)
KBO( :, 1,47, 2) = (/&
&2.5860E-09_JPRB,1.2558E-07_JPRB,2.4079E-07_JPRB,4.2237E-07_JPRB,3.1326E-07_JPRB/)
KBO( :, 2,47, 2) = (/&
&3.4290E-09_JPRB,1.4300E-07_JPRB,2.6056E-07_JPRB,4.1623E-07_JPRB,3.2857E-07_JPRB/)
KBO( :, 3,47, 2) = (/&
&4.9220E-09_JPRB,1.6878E-07_JPRB,2.9365E-07_JPRB,4.3092E-07_JPRB,3.4960E-07_JPRB/)
KBO( :, 4,47, 2) = (/&
&7.3908E-09_JPRB,2.0541E-07_JPRB,3.4074E-07_JPRB,4.6771E-07_JPRB,3.7790E-07_JPRB/)
KBO( :, 5,47, 2) = (/&
&1.1182E-08_JPRB,2.5354E-07_JPRB,4.0498E-07_JPRB,5.2394E-07_JPRB,4.1187E-07_JPRB/)
KBO( :, 1,48, 2) = (/&
&1.9362E-09_JPRB,9.8548E-08_JPRB,1.9411E-07_JPRB,3.5272E-07_JPRB,2.4937E-07_JPRB/)
KBO( :, 2,48, 2) = (/&
&2.4798E-09_JPRB,1.1072E-07_JPRB,2.0550E-07_JPRB,3.4105E-07_JPRB,2.6090E-07_JPRB/)
KBO( :, 3,48, 2) = (/&
&3.4555E-09_JPRB,1.2865E-07_JPRB,2.2828E-07_JPRB,3.4594E-07_JPRB,2.7560E-07_JPRB/)
KBO( :, 4,48, 2) = (/&
&5.1234E-09_JPRB,1.5515E-07_JPRB,2.6207E-07_JPRB,3.6909E-07_JPRB,2.9595E-07_JPRB/)
KBO( :, 5,48, 2) = (/&
&7.7538E-09_JPRB,1.9045E-07_JPRB,3.0872E-07_JPRB,4.0878E-07_JPRB,3.2128E-07_JPRB/)
KBO( :, 1,49, 2) = (/&
&1.4693E-09_JPRB,7.7790E-08_JPRB,1.5796E-07_JPRB,2.9638E-07_JPRB,1.9770E-07_JPRB/)
KBO( :, 2,49, 2) = (/&
&1.8189E-09_JPRB,8.6134E-08_JPRB,1.6334E-07_JPRB,2.8139E-07_JPRB,2.0674E-07_JPRB/)
KBO( :, 3,49, 2) = (/&
&2.4514E-09_JPRB,9.8737E-08_JPRB,1.7842E-07_JPRB,2.8001E-07_JPRB,2.1740E-07_JPRB/)
KBO( :, 4,49, 2) = (/&
&3.5625E-09_JPRB,1.1749E-07_JPRB,2.0240E-07_JPRB,2.9292E-07_JPRB,2.3150E-07_JPRB/)
KBO( :, 5,49, 2) = (/&
&5.3682E-09_JPRB,1.4339E-07_JPRB,2.3606E-07_JPRB,3.2024E-07_JPRB,2.5000E-07_JPRB/)
KBO( :, 1,50, 2) = (/&
&1.1339E-09_JPRB,6.1945E-08_JPRB,1.2933E-07_JPRB,2.5041E-07_JPRB,1.5748E-07_JPRB/)
KBO( :, 2,50, 2) = (/&
&1.3605E-09_JPRB,6.7603E-08_JPRB,1.3118E-07_JPRB,2.3383E-07_JPRB,1.6480E-07_JPRB/)
KBO( :, 3,50, 2) = (/&
&1.7751E-09_JPRB,7.6527E-08_JPRB,1.4063E-07_JPRB,2.2853E-07_JPRB,1.7288E-07_JPRB/)
KBO( :, 4,50, 2) = (/&
&2.5157E-09_JPRB,8.9697E-08_JPRB,1.5753E-07_JPRB,2.3451E-07_JPRB,1.8295E-07_JPRB/)
KBO( :, 5,50, 2) = (/&
&3.7579E-09_JPRB,1.0875E-07_JPRB,1.8190E-07_JPRB,2.5266E-07_JPRB,1.9633E-07_JPRB/)
KBO( :, 1,51, 2) = (/&
&8.8714E-10_JPRB,4.9745E-08_JPRB,1.0659E-07_JPRB,2.1260E-07_JPRB,1.2561E-07_JPRB/)
KBO( :, 2,51, 2) = (/&
&1.0323E-09_JPRB,5.3369E-08_JPRB,1.0630E-07_JPRB,1.9542E-07_JPRB,1.3171E-07_JPRB/)
KBO( :, 3,51, 2) = (/&
&1.3054E-09_JPRB,5.9668E-08_JPRB,1.1161E-07_JPRB,1.8777E-07_JPRB,1.3801E-07_JPRB/)
KBO( :, 4,51, 2) = (/&
&1.7978E-09_JPRB,6.8999E-08_JPRB,1.2328E-07_JPRB,1.8919E-07_JPRB,1.4548E-07_JPRB/)
KBO( :, 5,51, 2) = (/&
&2.6478E-09_JPRB,8.2837E-08_JPRB,1.4093E-07_JPRB,2.0051E-07_JPRB,1.5510E-07_JPRB/)
KBO( :, 1,52, 2) = (/&
&7.0184E-10_JPRB,4.0190E-08_JPRB,8.8218E-08_JPRB,1.8136E-07_JPRB,9.9731E-08_JPRB/)
KBO( :, 2,52, 2) = (/&
&7.9197E-10_JPRB,4.2349E-08_JPRB,8.6755E-08_JPRB,1.6417E-07_JPRB,1.0496E-07_JPRB/)
KBO( :, 3,52, 2) = (/&
&9.7132E-10_JPRB,4.6717E-08_JPRB,8.9179E-08_JPRB,1.5515E-07_JPRB,1.1000E-07_JPRB/)
KBO( :, 4,52, 2) = (/&
&1.2972E-09_JPRB,5.3380E-08_JPRB,9.6954E-08_JPRB,1.5366E-07_JPRB,1.1563E-07_JPRB/)
KBO( :, 5,52, 2) = (/&
&1.8721E-09_JPRB,6.3248E-08_JPRB,1.0959E-07_JPRB,1.5990E-07_JPRB,1.2254E-07_JPRB/)
KBO( :, 1,53, 2) = (/&
&5.6092E-10_JPRB,3.2648E-08_JPRB,7.3117E-08_JPRB,1.5519E-07_JPRB,7.8979E-08_JPRB/)
KBO( :, 2,53, 2) = (/&
&6.1423E-10_JPRB,3.3821E-08_JPRB,7.1138E-08_JPRB,1.3880E-07_JPRB,8.3275E-08_JPRB/)
KBO( :, 3,53, 2) = (/&
&7.3095E-10_JPRB,3.6763E-08_JPRB,7.1824E-08_JPRB,1.2909E-07_JPRB,8.7408E-08_JPRB/)
KBO( :, 4,53, 2) = (/&
&9.4591E-10_JPRB,4.1492E-08_JPRB,7.6609E-08_JPRB,1.2565E-07_JPRB,9.1725E-08_JPRB/)
KBO( :, 5,53, 2) = (/&
&1.3305E-09_JPRB,4.8452E-08_JPRB,8.5519E-08_JPRB,1.2833E-07_JPRB,9.6780E-08_JPRB/)
KBO( :, 1,54, 2) = (/&
&4.5340E-10_JPRB,2.6715E-08_JPRB,6.0844E-08_JPRB,1.3273E-07_JPRB,6.3768E-08_JPRB/)
KBO( :, 2,54, 2) = (/&
&4.8357E-10_JPRB,2.7241E-08_JPRB,5.8664E-08_JPRB,1.1758E-07_JPRB,6.7028E-08_JPRB/)
KBO( :, 3,54, 2) = (/&
&5.5955E-10_JPRB,2.9137E-08_JPRB,5.8341E-08_JPRB,1.0779E-07_JPRB,7.0461E-08_JPRB/)
KBO( :, 4,54, 2) = (/&
&7.0364E-10_JPRB,3.2508E-08_JPRB,6.1041E-08_JPRB,1.0330E-07_JPRB,7.3905E-08_JPRB/)
KBO( :, 5,54, 2) = (/&
&9.6348E-10_JPRB,3.7510E-08_JPRB,6.7236E-08_JPRB,1.0378E-07_JPRB,7.7793E-08_JPRB/)
KBO( :, 1,55, 2) = (/&
&3.7018E-10_JPRB,2.1877E-08_JPRB,5.0748E-08_JPRB,1.1383E-07_JPRB,5.2143E-08_JPRB/)
KBO( :, 2,55, 2) = (/&
&3.8461E-10_JPRB,2.2059E-08_JPRB,4.8491E-08_JPRB,9.9810E-08_JPRB,5.4531E-08_JPRB/)
KBO( :, 3,55, 2) = (/&
&4.3319E-10_JPRB,2.3219E-08_JPRB,4.7656E-08_JPRB,9.0291E-08_JPRB,5.7357E-08_JPRB/)
KBO( :, 4,55, 2) = (/&
&5.3033E-10_JPRB,2.5603E-08_JPRB,4.8945E-08_JPRB,8.5282E-08_JPRB,6.0114E-08_JPRB/)
KBO( :, 5,55, 2) = (/&
&7.0668E-10_JPRB,2.9236E-08_JPRB,5.3162E-08_JPRB,8.4413E-08_JPRB,6.3151E-08_JPRB/)
KBO( :, 1,56, 2) = (/&
&3.0445E-10_JPRB,1.7931E-08_JPRB,4.2378E-08_JPRB,9.8533E-08_JPRB,4.2768E-08_JPRB/)
KBO( :, 2,56, 2) = (/&
&3.0831E-10_JPRB,1.7934E-08_JPRB,4.0116E-08_JPRB,8.4908E-08_JPRB,4.4445E-08_JPRB/)
KBO( :, 3,56, 2) = (/&
&3.3824E-10_JPRB,1.8600E-08_JPRB,3.9063E-08_JPRB,7.5998E-08_JPRB,4.6738E-08_JPRB/)
KBO( :, 4,56, 2) = (/&
&4.0330E-10_JPRB,2.0246E-08_JPRB,3.9492E-08_JPRB,7.0783E-08_JPRB,4.8957E-08_JPRB/)
KBO( :, 5,56, 2) = (/&
&5.2280E-10_JPRB,2.2872E-08_JPRB,4.2190E-08_JPRB,6.9008E-08_JPRB,5.1331E-08_JPRB/)
KBO( :, 1,57, 2) = (/&
&2.5188E-10_JPRB,1.4754E-08_JPRB,3.5438E-08_JPRB,8.5756E-08_JPRB,3.5193E-08_JPRB/)
KBO( :, 2,57, 2) = (/&
&2.4912E-10_JPRB,1.4670E-08_JPRB,3.3337E-08_JPRB,7.2430E-08_JPRB,3.6276E-08_JPRB/)
KBO( :, 3,57, 2) = (/&
&2.6653E-10_JPRB,1.4983E-08_JPRB,3.2184E-08_JPRB,6.4241E-08_JPRB,3.8128E-08_JPRB/)
KBO( :, 4,57, 2) = (/&
&3.0939E-10_JPRB,1.6062E-08_JPRB,3.2064E-08_JPRB,5.9025E-08_JPRB,3.9920E-08_JPRB/)
KBO( :, 5,57, 2) = (/&
&3.9021E-10_JPRB,1.7948E-08_JPRB,3.3635E-08_JPRB,5.6680E-08_JPRB,4.1787E-08_JPRB/)
KBO( :, 1,58, 2) = (/&
&2.0925E-10_JPRB,1.2170E-08_JPRB,2.9715E-08_JPRB,7.4671E-08_JPRB,2.9109E-08_JPRB/)
KBO( :, 2,58, 2) = (/&
&2.0318E-10_JPRB,1.2015E-08_JPRB,2.7763E-08_JPRB,6.1869E-08_JPRB,2.9789E-08_JPRB/)
KBO( :, 3,58, 2) = (/&
&2.1207E-10_JPRB,1.2135E-08_JPRB,2.6581E-08_JPRB,5.4388E-08_JPRB,3.1254E-08_JPRB/)
KBO( :, 4,58, 2) = (/&
&2.3998E-10_JPRB,1.2810E-08_JPRB,2.6176E-08_JPRB,4.9330E-08_JPRB,3.2703E-08_JPRB/)
KBO( :, 5,58, 2) = (/&
&2.9508E-10_JPRB,1.4156E-08_JPRB,2.6975E-08_JPRB,4.6724E-08_JPRB,3.4169E-08_JPRB/)
KBO( :, 1,59, 2) = (/&
&1.7253E-10_JPRB,9.9906E-09_JPRB,2.4546E-08_JPRB,6.2526E-08_JPRB,2.4559E-08_JPRB/)
KBO( :, 2,59, 2) = (/&
&1.6644E-10_JPRB,9.8313E-09_JPRB,2.2868E-08_JPRB,5.1484E-08_JPRB,2.5300E-08_JPRB/)
KBO( :, 3,59, 2) = (/&
&1.7202E-10_JPRB,9.8966E-09_JPRB,2.1823E-08_JPRB,4.5067E-08_JPRB,2.6453E-08_JPRB/)
KBO( :, 4,59, 2) = (/&
&1.9270E-10_JPRB,1.0388E-08_JPRB,2.1414E-08_JPRB,4.0702E-08_JPRB,2.7518E-08_JPRB/)
KBO( :, 5,59, 2) = (/&
&2.3454E-10_JPRB,1.1431E-08_JPRB,2.1928E-08_JPRB,3.8364E-08_JPRB,2.8657E-08_JPRB/)
KBO( :, 1,13, 3) = (/&
&9.3592E-06_JPRB,1.8635E-04_JPRB,3.2360E-04_JPRB,5.1013E-04_JPRB,1.3719E-03_JPRB/)
KBO( :, 2,13, 3) = (/&
&1.3997E-05_JPRB,2.2150E-04_JPRB,3.6186E-04_JPRB,5.0766E-04_JPRB,1.6952E-03_JPRB/)
KBO( :, 3,13, 3) = (/&
&2.1472E-05_JPRB,2.7029E-04_JPRB,4.2086E-04_JPRB,5.4160E-04_JPRB,2.0559E-03_JPRB/)
KBO( :, 4,13, 3) = (/&
&3.2949E-05_JPRB,3.3595E-04_JPRB,5.0190E-04_JPRB,6.0909E-04_JPRB,2.4422E-03_JPRB/)
KBO( :, 5,13, 3) = (/&
&5.0055E-05_JPRB,4.2283E-04_JPRB,6.0794E-04_JPRB,7.0057E-04_JPRB,2.8431E-03_JPRB/)
KBO( :, 1,14, 3) = (/&
&7.7811E-06_JPRB,1.5443E-04_JPRB,2.6731E-04_JPRB,4.1737E-04_JPRB,1.1937E-03_JPRB/)
KBO( :, 2,14, 3) = (/&
&1.1790E-05_JPRB,1.8454E-04_JPRB,3.0104E-04_JPRB,4.1861E-04_JPRB,1.4661E-03_JPRB/)
KBO( :, 3,14, 3) = (/&
&1.8281E-05_JPRB,2.2651E-04_JPRB,3.5177E-04_JPRB,4.5049E-04_JPRB,1.7659E-03_JPRB/)
KBO( :, 4,14, 3) = (/&
&2.8361E-05_JPRB,2.8319E-04_JPRB,4.2136E-04_JPRB,5.0814E-04_JPRB,2.0759E-03_JPRB/)
KBO( :, 5,14, 3) = (/&
&4.3496E-05_JPRB,3.5806E-04_JPRB,5.1240E-04_JPRB,5.8626E-04_JPRB,2.3955E-03_JPRB/)
KBO( :, 1,15, 3) = (/&
&6.4085E-06_JPRB,1.2732E-04_JPRB,2.2021E-04_JPRB,3.4093E-04_JPRB,1.0104E-03_JPRB/)
KBO( :, 2,15, 3) = (/&
&9.8620E-06_JPRB,1.5303E-04_JPRB,2.4982E-04_JPRB,3.4487E-04_JPRB,1.2327E-03_JPRB/)
KBO( :, 3,15, 3) = (/&
&1.5483E-05_JPRB,1.8913E-04_JPRB,2.9331E-04_JPRB,3.7385E-04_JPRB,1.4660E-03_JPRB/)
KBO( :, 4,15, 3) = (/&
&2.4329E-05_JPRB,2.3772E-04_JPRB,3.5313E-04_JPRB,4.2330E-04_JPRB,1.7021E-03_JPRB/)
KBO( :, 5,15, 3) = (/&
&3.7620E-05_JPRB,3.0181E-04_JPRB,4.3081E-04_JPRB,4.9037E-04_JPRB,1.9309E-03_JPRB/)
KBO( :, 1,16, 3) = (/&
&5.2944E-06_JPRB,1.0489E-04_JPRB,1.8139E-04_JPRB,2.7836E-04_JPRB,8.1553E-04_JPRB/)
KBO( :, 2,16, 3) = (/&
&8.2639E-06_JPRB,1.2685E-04_JPRB,2.0708E-04_JPRB,2.8409E-04_JPRB,9.8078E-04_JPRB/)
KBO( :, 3,16, 3) = (/&
&1.3171E-05_JPRB,1.5775E-04_JPRB,2.4443E-04_JPRB,3.0988E-04_JPRB,1.1503E-03_JPRB/)
KBO( :, 4,16, 3) = (/&
&2.0912E-05_JPRB,1.9929E-04_JPRB,2.9554E-04_JPRB,3.5252E-04_JPRB,1.3131E-03_JPRB/)
KBO( :, 5,16, 3) = (/&
&3.2496E-05_JPRB,2.5409E-04_JPRB,3.6179E-04_JPRB,4.0963E-04_JPRB,1.4760E-03_JPRB/)
KBO( :, 1,17, 3) = (/&
&4.4493E-06_JPRB,8.6770E-05_JPRB,1.4991E-04_JPRB,2.2771E-04_JPRB,6.5245E-04_JPRB/)
KBO( :, 2,17, 3) = (/&
&7.0395E-06_JPRB,1.0559E-04_JPRB,1.7203E-04_JPRB,2.3430E-04_JPRB,7.7262E-04_JPRB/)
KBO( :, 3,17, 3) = (/&
&1.1335E-05_JPRB,1.3208E-04_JPRB,2.0407E-04_JPRB,2.5722E-04_JPRB,8.9028E-04_JPRB/)
KBO( :, 4,17, 3) = (/&
&1.8069E-05_JPRB,1.6765E-04_JPRB,2.4779E-04_JPRB,2.9368E-04_JPRB,1.0063E-03_JPRB/)
KBO( :, 5,17, 3) = (/&
&2.8090E-05_JPRB,2.1455E-04_JPRB,3.0412E-04_JPRB,3.4249E-04_JPRB,1.1248E-03_JPRB/)
KBO( :, 1,18, 3) = (/&
&3.8316E-06_JPRB,7.2347E-05_JPRB,1.2458E-04_JPRB,1.8673E-04_JPRB,5.2122E-04_JPRB/)
KBO( :, 2,18, 3) = (/&
&6.1184E-06_JPRB,8.8580E-05_JPRB,1.4361E-04_JPRB,1.9377E-04_JPRB,6.0767E-04_JPRB/)
KBO( :, 3,18, 3) = (/&
&9.8947E-06_JPRB,1.1135E-04_JPRB,1.7120E-04_JPRB,2.1410E-04_JPRB,6.9194E-04_JPRB/)
KBO( :, 4,18, 3) = (/&
&1.5756E-05_JPRB,1.4190E-04_JPRB,2.0855E-04_JPRB,2.4531E-04_JPRB,7.7868E-04_JPRB/)
KBO( :, 5,18, 3) = (/&
&2.4472E-05_JPRB,1.8227E-04_JPRB,2.5667E-04_JPRB,2.8708E-04_JPRB,8.6975E-04_JPRB/)
KBO( :, 1,19, 3) = (/&
&3.3167E-06_JPRB,6.0472E-05_JPRB,1.0361E-04_JPRB,1.5344E-04_JPRB,4.1912E-04_JPRB/)
KBO( :, 2,19, 3) = (/&
&5.3275E-06_JPRB,7.4485E-05_JPRB,1.2002E-04_JPRB,1.6049E-04_JPRB,4.8167E-04_JPRB/)
KBO( :, 3,19, 3) = (/&
&8.6182E-06_JPRB,9.4048E-05_JPRB,1.4375E-04_JPRB,1.7839E-04_JPRB,5.4498E-04_JPRB/)
KBO( :, 4,19, 3) = (/&
&1.3697E-05_JPRB,1.2034E-04_JPRB,1.7570E-04_JPRB,2.0508E-04_JPRB,6.1244E-04_JPRB/)
KBO( :, 5,19, 3) = (/&
&2.1261E-05_JPRB,1.5516E-04_JPRB,2.1680E-04_JPRB,2.4089E-04_JPRB,6.8509E-04_JPRB/)
KBO( :, 1,20, 3) = (/&
&2.9049E-06_JPRB,5.0863E-05_JPRB,8.6497E-05_JPRB,1.2631E-04_JPRB,3.3898E-04_JPRB/)
KBO( :, 2,20, 3) = (/&
&4.6782E-06_JPRB,6.3037E-05_JPRB,1.0077E-04_JPRB,1.3328E-04_JPRB,3.8658E-04_JPRB/)
KBO( :, 3,20, 3) = (/&
&7.5551E-06_JPRB,7.9949E-05_JPRB,1.2127E-04_JPRB,1.4912E-04_JPRB,4.3608E-04_JPRB/)
KBO( :, 4,20, 3) = (/&
&1.1985E-05_JPRB,1.0272E-04_JPRB,1.4880E-04_JPRB,1.7209E-04_JPRB,4.8968E-04_JPRB/)
KBO( :, 5,20, 3) = (/&
&1.8564E-05_JPRB,1.3289E-04_JPRB,1.8395E-04_JPRB,2.0290E-04_JPRB,5.4862E-04_JPRB/)
KBO( :, 1,21, 3) = (/&
&2.5348E-06_JPRB,4.2827E-05_JPRB,7.2239E-05_JPRB,1.0405E-04_JPRB,2.7347E-04_JPRB/)
KBO( :, 2,21, 3) = (/&
&4.0896E-06_JPRB,5.3392E-05_JPRB,8.4682E-05_JPRB,1.1078E-04_JPRB,3.1033E-04_JPRB/)
KBO( :, 3,21, 3) = (/&
&6.5911E-06_JPRB,6.8002E-05_JPRB,1.0240E-04_JPRB,1.2468E-04_JPRB,3.4945E-04_JPRB/)
KBO( :, 4,21, 3) = (/&
&1.0443E-05_JPRB,8.7777E-05_JPRB,1.2604E-04_JPRB,1.4448E-04_JPRB,3.9270E-04_JPRB/)
KBO( :, 5,21, 3) = (/&
&1.6126E-05_JPRB,1.1384E-04_JPRB,1.5619E-04_JPRB,1.7100E-04_JPRB,4.4032E-04_JPRB/)
KBO( :, 1,22, 3) = (/&
&2.2535E-06_JPRB,3.6484E-05_JPRB,6.0844E-05_JPRB,8.5915E-05_JPRB,2.1861E-04_JPRB/)
KBO( :, 2,22, 3) = (/&
&3.6421E-06_JPRB,4.5838E-05_JPRB,7.1930E-05_JPRB,9.2688E-05_JPRB,2.4695E-04_JPRB/)
KBO( :, 3,22, 3) = (/&
&5.8649E-06_JPRB,5.8716E-05_JPRB,8.7516E-05_JPRB,1.0512E-04_JPRB,2.7805E-04_JPRB/)
KBO( :, 4,22, 3) = (/&
&9.2724E-06_JPRB,7.6158E-05_JPRB,1.0809E-04_JPRB,1.2256E-04_JPRB,3.1283E-04_JPRB/)
KBO( :, 5,22, 3) = (/&
&1.4237E-05_JPRB,9.8834E-05_JPRB,1.3432E-04_JPRB,1.4571E-04_JPRB,3.5095E-04_JPRB/)
KBO( :, 1,23, 3) = (/&
&1.9940E-06_JPRB,3.1133E-05_JPRB,5.1328E-05_JPRB,7.1090E-05_JPRB,1.7327E-04_JPRB/)
KBO( :, 2,23, 3) = (/&
&3.2312E-06_JPRB,3.9399E-05_JPRB,6.1179E-05_JPRB,7.7708E-05_JPRB,1.9531E-04_JPRB/)
KBO( :, 3,23, 3) = (/&
&5.2011E-06_JPRB,5.0768E-05_JPRB,7.4847E-05_JPRB,8.8760E-05_JPRB,2.2017E-04_JPRB/)
KBO( :, 4,23, 3) = (/&
&8.1919E-06_JPRB,6.6023E-05_JPRB,9.2815E-05_JPRB,1.0413E-04_JPRB,2.4809E-04_JPRB/)
KBO( :, 5,23, 3) = (/&
&1.2498E-05_JPRB,8.5676E-05_JPRB,1.1550E-04_JPRB,1.2430E-04_JPRB,2.7861E-04_JPRB/)
KBO( :, 1,24, 3) = (/&
&1.7459E-06_JPRB,2.6558E-05_JPRB,4.3302E-05_JPRB,5.8931E-05_JPRB,1.3456E-04_JPRB/)
KBO( :, 2,24, 3) = (/&
&2.8378E-06_JPRB,3.3840E-05_JPRB,5.2034E-05_JPRB,6.5221E-05_JPRB,1.5184E-04_JPRB/)
KBO( :, 3,24, 3) = (/&
&4.5668E-06_JPRB,4.3812E-05_JPRB,6.4027E-05_JPRB,7.5015E-05_JPRB,1.7156E-04_JPRB/)
KBO( :, 4,24, 3) = (/&
&7.1655E-06_JPRB,5.7056E-05_JPRB,7.9597E-05_JPRB,8.8545E-05_JPRB,1.9368E-04_JPRB/)
KBO( :, 5,24, 3) = (/&
&1.0891E-05_JPRB,7.4041E-05_JPRB,9.9156E-05_JPRB,1.0602E-04_JPRB,2.1759E-04_JPRB/)
KBO( :, 1,25, 3) = (/&
&1.5351E-06_JPRB,2.2739E-05_JPRB,3.6661E-05_JPRB,4.9033E-05_JPRB,1.0464E-04_JPRB/)
KBO( :, 2,25, 3) = (/&
&2.5013E-06_JPRB,2.9156E-05_JPRB,4.4403E-05_JPRB,5.4906E-05_JPRB,1.1839E-04_JPRB/)
KBO( :, 3,25, 3) = (/&
&4.0193E-06_JPRB,3.7867E-05_JPRB,5.4900E-05_JPRB,6.3596E-05_JPRB,1.3405E-04_JPRB/)
KBO( :, 4,25, 3) = (/&
&6.2816E-06_JPRB,4.9369E-05_JPRB,6.8362E-05_JPRB,7.5478E-05_JPRB,1.5142E-04_JPRB/)
KBO( :, 5,25, 3) = (/&
&9.5147E-06_JPRB,6.4006E-05_JPRB,8.5212E-05_JPRB,9.0532E-05_JPRB,1.6998E-04_JPRB/)
KBO( :, 1,26, 3) = (/&
&1.3683E-06_JPRB,1.9609E-05_JPRB,3.1239E-05_JPRB,4.1025E-05_JPRB,8.2529E-05_JPRB/)
KBO( :, 2,26, 3) = (/&
&2.2313E-06_JPRB,2.5269E-05_JPRB,3.8126E-05_JPRB,4.6436E-05_JPRB,9.3600E-05_JPRB/)
KBO( :, 3,26, 3) = (/&
&3.5754E-06_JPRB,3.2913E-05_JPRB,4.7295E-05_JPRB,5.4190E-05_JPRB,1.0611E-04_JPRB/)
KBO( :, 4,26, 3) = (/&
&5.5664E-06_JPRB,4.2915E-05_JPRB,5.8952E-05_JPRB,6.4581E-05_JPRB,1.1966E-04_JPRB/)
KBO( :, 5,26, 3) = (/&
&8.3928E-06_JPRB,5.5540E-05_JPRB,7.3478E-05_JPRB,7.7578E-05_JPRB,1.3407E-04_JPRB/)
KBO( :, 1,27, 3) = (/&
&1.2171E-06_JPRB,1.6923E-05_JPRB,2.6666E-05_JPRB,3.4428E-05_JPRB,6.4836E-05_JPRB/)
KBO( :, 2,27, 3) = (/&
&1.9862E-06_JPRB,2.1896E-05_JPRB,3.2752E-05_JPRB,3.9332E-05_JPRB,7.3650E-05_JPRB/)
KBO( :, 3,27, 3) = (/&
&3.1750E-06_JPRB,2.8593E-05_JPRB,4.0727E-05_JPRB,4.6210E-05_JPRB,8.3366E-05_JPRB/)
KBO( :, 4,27, 3) = (/&
&4.9257E-06_JPRB,3.7245E-05_JPRB,5.0788E-05_JPRB,5.5242E-05_JPRB,9.3744E-05_JPRB/)
KBO( :, 5,27, 3) = (/&
&7.3934E-06_JPRB,4.8090E-05_JPRB,6.3249E-05_JPRB,6.6414E-05_JPRB,1.0490E-04_JPRB/)
KBO( :, 1,28, 3) = (/&
&1.0792E-06_JPRB,1.4600E-05_JPRB,2.2784E-05_JPRB,2.8952E-05_JPRB,5.0485E-05_JPRB/)
KBO( :, 2,28, 3) = (/&
&1.7629E-06_JPRB,1.8972E-05_JPRB,2.8123E-05_JPRB,3.3346E-05_JPRB,5.7277E-05_JPRB/)
KBO( :, 3,28, 3) = (/&
&2.8131E-06_JPRB,2.4805E-05_JPRB,3.5042E-05_JPRB,3.9409E-05_JPRB,6.4622E-05_JPRB/)
KBO( :, 4,28, 3) = (/&
&4.3512E-06_JPRB,3.2251E-05_JPRB,4.3694E-05_JPRB,4.7211E-05_JPRB,7.2602E-05_JPRB/)
KBO( :, 5,28, 3) = (/&
&6.4989E-06_JPRB,4.1559E-05_JPRB,5.4337E-05_JPRB,5.6763E-05_JPRB,8.1333E-05_JPRB/)
KBO( :, 1,29, 3) = (/&
&9.6857E-07_JPRB,1.2666E-05_JPRB,1.9556E-05_JPRB,2.4447E-05_JPRB,3.9529E-05_JPRB/)
KBO( :, 2,29, 3) = (/&
&1.5818E-06_JPRB,1.6515E-05_JPRB,2.4236E-05_JPRB,2.8362E-05_JPRB,4.4697E-05_JPRB/)
KBO( :, 3,29, 3) = (/&
&2.5168E-06_JPRB,2.1586E-05_JPRB,3.0227E-05_JPRB,3.3688E-05_JPRB,5.0413E-05_JPRB/)
KBO( :, 4,29, 3) = (/&
&3.8723E-06_JPRB,2.8010E-05_JPRB,3.7666E-05_JPRB,4.0411E-05_JPRB,5.6688E-05_JPRB/)
KBO( :, 5,29, 3) = (/&
&5.7462E-06_JPRB,3.6016E-05_JPRB,4.6768E-05_JPRB,4.8565E-05_JPRB,6.3553E-05_JPRB/)
KBO( :, 1,30, 3) = (/&
&8.7056E-07_JPRB,1.1001E-05_JPRB,1.6806E-05_JPRB,2.0679E-05_JPRB,3.0642E-05_JPRB/)
KBO( :, 2,30, 3) = (/&
&1.4204E-06_JPRB,1.4373E-05_JPRB,2.0891E-05_JPRB,2.4158E-05_JPRB,3.4644E-05_JPRB/)
KBO( :, 3,30, 3) = (/&
&2.2511E-06_JPRB,1.8769E-05_JPRB,2.6058E-05_JPRB,2.8796E-05_JPRB,3.9114E-05_JPRB/)
KBO( :, 4,30, 3) = (/&
&3.4456E-06_JPRB,2.4312E-05_JPRB,3.2449E-05_JPRB,3.4570E-05_JPRB,4.4025E-05_JPRB/)
KBO( :, 5,30, 3) = (/&
&5.0796E-06_JPRB,3.1203E-05_JPRB,4.0247E-05_JPRB,4.1528E-05_JPRB,4.9430E-05_JPRB/)
KBO( :, 1,31, 3) = (/&
&7.8800E-07_JPRB,9.5841E-06_JPRB,1.4480E-05_JPRB,1.7537E-05_JPRB,2.3703E-05_JPRB/)
KBO( :, 2,31, 3) = (/&
&1.2827E-06_JPRB,1.2532E-05_JPRB,1.8035E-05_JPRB,2.0619E-05_JPRB,2.6829E-05_JPRB/)
KBO( :, 3,31, 3) = (/&
&2.0224E-06_JPRB,1.6343E-05_JPRB,2.2488E-05_JPRB,2.4639E-05_JPRB,3.0300E-05_JPRB/)
KBO( :, 4,31, 3) = (/&
&3.0735E-06_JPRB,2.1137E-05_JPRB,2.7988E-05_JPRB,2.9590E-05_JPRB,3.4174E-05_JPRB/)
KBO( :, 5,31, 3) = (/&
&4.5010E-06_JPRB,2.7051E-05_JPRB,3.4649E-05_JPRB,3.5519E-05_JPRB,3.8449E-05_JPRB/)
KBO( :, 1,32, 3) = (/&
&7.1645E-07_JPRB,8.3621E-06_JPRB,1.2499E-05_JPRB,1.4908E-05_JPRB,1.8443E-05_JPRB/)
KBO( :, 2,32, 3) = (/&
&1.1619E-06_JPRB,1.0942E-05_JPRB,1.5584E-05_JPRB,1.7626E-05_JPRB,2.0886E-05_JPRB/)
KBO( :, 3,32, 3) = (/&
&1.8202E-06_JPRB,1.4246E-05_JPRB,1.9422E-05_JPRB,2.1099E-05_JPRB,2.3648E-05_JPRB/)
KBO( :, 4,32, 3) = (/&
&2.7468E-06_JPRB,1.8389E-05_JPRB,2.4154E-05_JPRB,2.5344E-05_JPRB,2.6722E-05_JPRB/)
KBO( :, 5,32, 3) = (/&
&3.9939E-06_JPRB,2.3459E-05_JPRB,2.9845E-05_JPRB,3.0391E-05_JPRB,3.0128E-05_JPRB/)
KBO( :, 1,33, 3) = (/&
&6.5279E-07_JPRB,7.3021E-06_JPRB,1.0797E-05_JPRB,1.2695E-05_JPRB,1.4402E-05_JPRB/)
KBO( :, 2,33, 3) = (/&
&1.0533E-06_JPRB,9.5550E-06_JPRB,1.3466E-05_JPRB,1.5078E-05_JPRB,1.6322E-05_JPRB/)
KBO( :, 3,33, 3) = (/&
&1.6386E-06_JPRB,1.2420E-05_JPRB,1.6777E-05_JPRB,1.8071E-05_JPRB,1.8509E-05_JPRB/)
KBO( :, 4,33, 3) = (/&
&2.4555E-06_JPRB,1.6002E-05_JPRB,2.0850E-05_JPRB,2.1713E-05_JPRB,2.0967E-05_JPRB/)
KBO( :, 5,33, 3) = (/&
&3.5438E-06_JPRB,2.0331E-05_JPRB,2.5695E-05_JPRB,2.6001E-05_JPRB,2.3644E-05_JPRB/)
KBO( :, 1,34, 3) = (/&
&5.8863E-07_JPRB,6.3339E-06_JPRB,9.2734E-06_JPRB,1.0778E-05_JPRB,1.1469E-05_JPRB/)
KBO( :, 2,34, 3) = (/&
&9.4445E-07_JPRB,8.2845E-06_JPRB,1.1567E-05_JPRB,1.2839E-05_JPRB,1.3017E-05_JPRB/)
KBO( :, 3,34, 3) = (/&
&1.4596E-06_JPRB,1.0750E-05_JPRB,1.4406E-05_JPRB,1.5399E-05_JPRB,1.4774E-05_JPRB/)
KBO( :, 4,34, 3) = (/&
&2.1724E-06_JPRB,1.3818E-05_JPRB,1.7879E-05_JPRB,1.8493E-05_JPRB,1.6729E-05_JPRB/)
KBO( :, 5,34, 3) = (/&
&3.1148E-06_JPRB,1.7498E-05_JPRB,2.1987E-05_JPRB,2.2131E-05_JPRB,1.8824E-05_JPRB/)
KBO( :, 1,35, 3) = (/&
&5.0537E-07_JPRB,5.3493E-06_JPRB,7.7919E-06_JPRB,9.0039E-06_JPRB,8.9781E-06_JPRB/)
KBO( :, 2,35, 3) = (/&
&8.0918E-07_JPRB,6.9937E-06_JPRB,9.7192E-06_JPRB,1.0739E-05_JPRB,1.0213E-05_JPRB/)
KBO( :, 3,35, 3) = (/&
&1.2470E-06_JPRB,9.0680E-06_JPRB,1.2102E-05_JPRB,1.2886E-05_JPRB,1.1596E-05_JPRB/)
KBO( :, 4,35, 3) = (/&
&1.8501E-06_JPRB,1.1641E-05_JPRB,1.5006E-05_JPRB,1.5470E-05_JPRB,1.3118E-05_JPRB/)
KBO( :, 5,35, 3) = (/&
&2.6449E-06_JPRB,1.4713E-05_JPRB,1.8433E-05_JPRB,1.8505E-05_JPRB,1.4740E-05_JPRB/)
KBO( :, 1,36, 3) = (/&
&4.1057E-07_JPRB,4.3814E-06_JPRB,6.3851E-06_JPRB,7.3787E-06_JPRB,6.8704E-06_JPRB/)
KBO( :, 2,36, 3) = (/&
&6.5882E-07_JPRB,5.7295E-06_JPRB,7.9649E-06_JPRB,8.8014E-06_JPRB,7.8310E-06_JPRB/)
KBO( :, 3,36, 3) = (/&
&1.0168E-06_JPRB,7.4305E-06_JPRB,9.9179E-06_JPRB,1.0562E-05_JPRB,8.9079E-06_JPRB/)
KBO( :, 4,36, 3) = (/&
&1.5108E-06_JPRB,9.5390E-06_JPRB,1.2298E-05_JPRB,1.2679E-05_JPRB,1.0083E-05_JPRB/)
KBO( :, 5,36, 3) = (/&
&2.1616E-06_JPRB,1.2056E-05_JPRB,1.5104E-05_JPRB,1.5169E-05_JPRB,1.1345E-05_JPRB/)
KBO( :, 1,37, 3) = (/&
&3.1315E-07_JPRB,3.4610E-06_JPRB,5.0780E-06_JPRB,5.9099E-06_JPRB,5.3692E-06_JPRB/)
KBO( :, 2,37, 3) = (/&
&5.0553E-07_JPRB,4.5300E-06_JPRB,6.3356E-06_JPRB,7.0381E-06_JPRB,6.1160E-06_JPRB/)
KBO( :, 3,37, 3) = (/&
&7.8502E-07_JPRB,5.8822E-06_JPRB,7.8910E-06_JPRB,8.4420E-06_JPRB,6.9587E-06_JPRB/)
KBO( :, 4,37, 3) = (/&
&1.1731E-06_JPRB,7.5654E-06_JPRB,9.7936E-06_JPRB,1.0137E-05_JPRB,7.8860E-06_JPRB/)
KBO( :, 5,37, 3) = (/&
&1.6874E-06_JPRB,9.5810E-06_JPRB,1.2045E-05_JPRB,1.2132E-05_JPRB,8.8810E-06_JPRB/)
KBO( :, 1,38, 3) = (/&
&2.3771E-07_JPRB,2.7274E-06_JPRB,4.0311E-06_JPRB,4.7281E-06_JPRB,4.1877E-06_JPRB/)
KBO( :, 2,38, 3) = (/&
&3.8612E-07_JPRB,3.5727E-06_JPRB,5.0296E-06_JPRB,5.6200E-06_JPRB,4.7630E-06_JPRB/)
KBO( :, 3,38, 3) = (/&
&6.0348E-07_JPRB,4.6457E-06_JPRB,6.2661E-06_JPRB,6.7370E-06_JPRB,5.4196E-06_JPRB/)
KBO( :, 4,38, 3) = (/&
&9.0735E-07_JPRB,5.9856E-06_JPRB,7.7840E-06_JPRB,8.0913E-06_JPRB,6.1484E-06_JPRB/)
KBO( :, 5,38, 3) = (/&
&1.3127E-06_JPRB,7.5975E-06_JPRB,9.5859E-06_JPRB,9.6880E-06_JPRB,6.9288E-06_JPRB/)
KBO( :, 1,39, 3) = (/&
&1.8023E-07_JPRB,2.1491E-06_JPRB,3.2000E-06_JPRB,3.7837E-06_JPRB,3.2502E-06_JPRB/)
KBO( :, 2,39, 3) = (/&
&2.9456E-07_JPRB,2.8164E-06_JPRB,3.9921E-06_JPRB,4.4877E-06_JPRB,3.6914E-06_JPRB/)
KBO( :, 3,39, 3) = (/&
&4.6344E-07_JPRB,3.6676E-06_JPRB,4.9751E-06_JPRB,5.3760E-06_JPRB,4.1983E-06_JPRB/)
KBO( :, 4,39, 3) = (/&
&7.0119E-07_JPRB,4.7335E-06_JPRB,6.1852E-06_JPRB,6.4579E-06_JPRB,4.7648E-06_JPRB/)
KBO( :, 5,39, 3) = (/&
&1.0202E-06_JPRB,6.0220E-06_JPRB,7.6267E-06_JPRB,7.7355E-06_JPRB,5.3712E-06_JPRB/)
KBO( :, 1,40, 3) = (/&
&1.2988E-07_JPRB,1.6490E-06_JPRB,2.4862E-06_JPRB,2.9837E-06_JPRB,2.5331E-06_JPRB/)
KBO( :, 2,40, 3) = (/&
&2.1421E-07_JPRB,2.1615E-06_JPRB,3.1003E-06_JPRB,3.5229E-06_JPRB,2.8723E-06_JPRB/)
KBO( :, 3,40, 3) = (/&
&3.4046E-07_JPRB,2.8213E-06_JPRB,3.8655E-06_JPRB,4.2144E-06_JPRB,3.2646E-06_JPRB/)
KBO( :, 4,40, 3) = (/&
&5.2031E-07_JPRB,3.6506E-06_JPRB,4.8112E-06_JPRB,5.0626E-06_JPRB,3.7075E-06_JPRB/)
KBO( :, 5,40, 3) = (/&
&7.6450E-07_JPRB,4.6621E-06_JPRB,5.9448E-06_JPRB,6.0685E-06_JPRB,4.1839E-06_JPRB/)
KBO( :, 1,41, 3) = (/&
&9.2788E-08_JPRB,1.2611E-06_JPRB,1.9271E-06_JPRB,2.3514E-06_JPRB,1.9748E-06_JPRB/)
KBO( :, 2,41, 3) = (/&
&1.5438E-07_JPRB,1.6527E-06_JPRB,2.4004E-06_JPRB,2.7614E-06_JPRB,2.2337E-06_JPRB/)
KBO( :, 3,41, 3) = (/&
&2.4802E-07_JPRB,2.1617E-06_JPRB,2.9945E-06_JPRB,3.2967E-06_JPRB,2.5364E-06_JPRB/)
KBO( :, 4,41, 3) = (/&
&3.8306E-07_JPRB,2.8040E-06_JPRB,3.7298E-06_JPRB,3.9584E-06_JPRB,2.8813E-06_JPRB/)
KBO( :, 5,41, 3) = (/&
&5.6866E-07_JPRB,3.5943E-06_JPRB,4.6183E-06_JPRB,4.7484E-06_JPRB,3.2555E-06_JPRB/)
KBO( :, 1,42, 3) = (/&
&6.6123E-08_JPRB,9.6442E-07_JPRB,1.4943E-06_JPRB,1.8557E-06_JPRB,1.5379E-06_JPRB/)
KBO( :, 2,42, 3) = (/&
&1.1090E-07_JPRB,1.2629E-06_JPRB,1.8581E-06_JPRB,2.1664E-06_JPRB,1.7336E-06_JPRB/)
KBO( :, 3,42, 3) = (/&
&1.8006E-07_JPRB,1.6546E-06_JPRB,2.3186E-06_JPRB,2.5790E-06_JPRB,1.9660E-06_JPRB/)
KBO( :, 4,42, 3) = (/&
&2.8112E-07_JPRB,2.1513E-06_JPRB,2.8897E-06_JPRB,3.0943E-06_JPRB,2.2331E-06_JPRB/)
KBO( :, 5,42, 3) = (/&
&4.2176E-07_JPRB,2.7676E-06_JPRB,3.5854E-06_JPRB,3.7139E-06_JPRB,2.5247E-06_JPRB/)
KBO( :, 1,43, 3) = (/&
&4.5723E-08_JPRB,7.2721E-07_JPRB,1.1468E-06_JPRB,1.4561E-06_JPRB,1.1970E-06_JPRB/)
KBO( :, 2,43, 3) = (/&
&7.7279E-08_JPRB,9.5086E-07_JPRB,1.4214E-06_JPRB,1.6869E-06_JPRB,1.3436E-06_JPRB/)
KBO( :, 3,43, 3) = (/&
&1.2698E-07_JPRB,1.2469E-06_JPRB,1.7734E-06_JPRB,1.9988E-06_JPRB,1.5201E-06_JPRB/)
KBO( :, 4,43, 3) = (/&
&2.0087E-07_JPRB,1.6261E-06_JPRB,2.2117E-06_JPRB,2.3948E-06_JPRB,1.7257E-06_JPRB/)
KBO( :, 5,43, 3) = (/&
&3.0517E-07_JPRB,2.0997E-06_JPRB,2.7492E-06_JPRB,2.8756E-06_JPRB,1.9526E-06_JPRB/)
KBO( :, 1,44, 3) = (/&
&3.1195E-08_JPRB,5.4529E-07_JPRB,8.7740E-07_JPRB,1.1428E-06_JPRB,9.3212E-07_JPRB/)
KBO( :, 2,44, 3) = (/&
&5.3002E-08_JPRB,7.1132E-07_JPRB,1.0821E-06_JPRB,1.3117E-06_JPRB,1.0411E-06_JPRB/)
KBO( :, 3,44, 3) = (/&
&8.8116E-08_JPRB,9.3281E-07_JPRB,1.3488E-06_JPRB,1.5439E-06_JPRB,1.1733E-06_JPRB/)
KBO( :, 4,44, 3) = (/&
&1.4135E-07_JPRB,1.2201E-06_JPRB,1.6833E-06_JPRB,1.8457E-06_JPRB,1.3305E-06_JPRB/)
KBO( :, 5,44, 3) = (/&
&2.1772E-07_JPRB,1.5809E-06_JPRB,2.0956E-06_JPRB,2.2159E-06_JPRB,1.5063E-06_JPRB/)
KBO( :, 1,45, 3) = (/&
&2.1310E-08_JPRB,4.0944E-07_JPRB,6.7327E-07_JPRB,9.0153E-07_JPRB,7.2497E-07_JPRB/)
KBO( :, 2,45, 3) = (/&
&3.6231E-08_JPRB,5.3235E-07_JPRB,8.2462E-07_JPRB,1.0227E-06_JPRB,8.0606E-07_JPRB/)
KBO( :, 3,45, 3) = (/&
&6.0860E-08_JPRB,6.9752E-07_JPRB,1.0257E-06_JPRB,1.1946E-06_JPRB,9.0421E-07_JPRB/)
KBO( :, 4,45, 3) = (/&
&9.8966E-08_JPRB,9.1442E-07_JPRB,1.2808E-06_JPRB,1.4232E-06_JPRB,1.0228E-06_JPRB/)
KBO( :, 5,45, 3) = (/&
&1.5458E-07_JPRB,1.1885E-06_JPRB,1.5957E-06_JPRB,1.7071E-06_JPRB,1.1581E-06_JPRB/)
KBO( :, 1,46, 3) = (/&
&1.4455E-08_JPRB,3.0647E-07_JPRB,5.1657E-07_JPRB,7.1517E-07_JPRB,5.6309E-07_JPRB/)
KBO( :, 2,46, 3) = (/&
&2.4438E-08_JPRB,3.9644E-07_JPRB,6.2668E-07_JPRB,7.9740E-07_JPRB,6.2357E-07_JPRB/)
KBO( :, 3,46, 3) = (/&
&4.1400E-08_JPRB,5.1850E-07_JPRB,7.7667E-07_JPRB,9.2312E-07_JPRB,6.9619E-07_JPRB/)
KBO( :, 4,46, 3) = (/&
&6.8241E-08_JPRB,6.8045E-07_JPRB,9.6951E-07_JPRB,1.0939E-06_JPRB,7.8455E-07_JPRB/)
KBO( :, 5,46, 3) = (/&
&1.0821E-07_JPRB,8.8739E-07_JPRB,1.2089E-06_JPRB,1.3101E-06_JPRB,8.8794E-07_JPRB/)
KBO( :, 1,47, 3) = (/&
&9.6929E-09_JPRB,2.2797E-07_JPRB,3.9542E-07_JPRB,5.7182E-07_JPRB,4.3847E-07_JPRB/)
KBO( :, 2,47, 3) = (/&
&1.6123E-08_JPRB,2.9242E-07_JPRB,4.7359E-07_JPRB,6.2141E-07_JPRB,4.8271E-07_JPRB/)
KBO( :, 3,47, 3) = (/&
&2.7447E-08_JPRB,3.8129E-07_JPRB,5.8328E-07_JPRB,7.1120E-07_JPRB,5.3692E-07_JPRB/)
KBO( :, 4,47, 3) = (/&
&4.5855E-08_JPRB,5.0030E-07_JPRB,7.2710E-07_JPRB,8.3592E-07_JPRB,6.0206E-07_JPRB/)
KBO( :, 5,47, 3) = (/&
&7.3923E-08_JPRB,6.5467E-07_JPRB,9.0733E-07_JPRB,9.9829E-07_JPRB,6.8031E-07_JPRB/)
KBO( :, 1,48, 3) = (/&
&6.6058E-09_JPRB,1.7063E-07_JPRB,3.0447E-07_JPRB,4.6224E-07_JPRB,3.4217E-07_JPRB/)
KBO( :, 2,48, 3) = (/&
&1.0670E-08_JPRB,2.1618E-07_JPRB,3.5958E-07_JPRB,4.8824E-07_JPRB,3.7325E-07_JPRB/)
KBO( :, 3,48, 3) = (/&
&1.8128E-08_JPRB,2.8060E-07_JPRB,4.3881E-07_JPRB,5.5007E-07_JPRB,4.1348E-07_JPRB/)
KBO( :, 4,48, 3) = (/&
&3.0624E-08_JPRB,3.6766E-07_JPRB,5.4535E-07_JPRB,6.4036E-07_JPRB,4.6137E-07_JPRB/)
KBO( :, 5,48, 3) = (/&
&5.0151E-08_JPRB,4.8217E-07_JPRB,6.8071E-07_JPRB,7.6123E-07_JPRB,5.1955E-07_JPRB/)
KBO( :, 1,49, 3) = (/&
&4.6014E-09_JPRB,1.2872E-07_JPRB,2.3633E-07_JPRB,3.7814E-07_JPRB,2.6748E-07_JPRB/)
KBO( :, 2,49, 3) = (/&
&7.1127E-09_JPRB,1.6040E-07_JPRB,2.7445E-07_JPRB,3.8804E-07_JPRB,2.8841E-07_JPRB/)
KBO( :, 3,49, 3) = (/&
&1.1951E-08_JPRB,2.0675E-07_JPRB,3.3098E-07_JPRB,4.2738E-07_JPRB,3.1734E-07_JPRB/)
KBO( :, 4,49, 3) = (/&
&2.0341E-08_JPRB,2.7019E-07_JPRB,4.0929E-07_JPRB,4.9230E-07_JPRB,3.5284E-07_JPRB/)
KBO( :, 5,49, 3) = (/&
&3.3789E-08_JPRB,3.5457E-07_JPRB,5.1051E-07_JPRB,5.8104E-07_JPRB,3.9543E-07_JPRB/)
KBO( :, 1,50, 3) = (/&
&3.3123E-09_JPRB,9.8389E-08_JPRB,1.8583E-07_JPRB,3.1200E-07_JPRB,2.1151E-07_JPRB/)
KBO( :, 2,50, 3) = (/&
&4.8635E-09_JPRB,1.2034E-07_JPRB,2.1156E-07_JPRB,3.1223E-07_JPRB,2.2606E-07_JPRB/)
KBO( :, 3,50, 3) = (/&
&8.0017E-09_JPRB,1.5366E-07_JPRB,2.5190E-07_JPRB,3.3521E-07_JPRB,2.4676E-07_JPRB/)
KBO( :, 4,50, 3) = (/&
&1.3638E-08_JPRB,2.0012E-07_JPRB,3.0928E-07_JPRB,3.8141E-07_JPRB,2.7336E-07_JPRB/)
KBO( :, 5,50, 3) = (/&
&2.2922E-08_JPRB,2.6241E-07_JPRB,3.8502E-07_JPRB,4.4648E-07_JPRB,3.0528E-07_JPRB/)
KBO( :, 1,51, 3) = (/&
&2.4418E-09_JPRB,7.5933E-08_JPRB,1.4742E-07_JPRB,2.5968E-07_JPRB,1.6891E-07_JPRB/)
KBO( :, 2,51, 3) = (/&
&3.3989E-09_JPRB,9.1095E-08_JPRB,1.6428E-07_JPRB,2.5385E-07_JPRB,1.7889E-07_JPRB/)
KBO( :, 3,51, 3) = (/&
&5.4139E-09_JPRB,1.1482E-07_JPRB,1.9299E-07_JPRB,2.6542E-07_JPRB,1.9344E-07_JPRB/)
KBO( :, 4,51, 3) = (/&
&9.1803E-09_JPRB,1.4881E-07_JPRB,2.3477E-07_JPRB,2.9709E-07_JPRB,2.1318E-07_JPRB/)
KBO( :, 5,51, 3) = (/&
&1.5567E-08_JPRB,1.9481E-07_JPRB,2.9131E-07_JPRB,3.4464E-07_JPRB,2.3734E-07_JPRB/)
KBO( :, 1,52, 3) = (/&
&1.8356E-09_JPRB,5.9138E-08_JPRB,1.1788E-07_JPRB,2.1792E-07_JPRB,1.3551E-07_JPRB/)
KBO( :, 2,52, 3) = (/&
&2.4226E-09_JPRB,6.9427E-08_JPRB,1.2853E-07_JPRB,2.0827E-07_JPRB,1.4167E-07_JPRB/)
KBO( :, 3,52, 3) = (/&
&3.6921E-09_JPRB,8.6117E-08_JPRB,1.4855E-07_JPRB,2.1230E-07_JPRB,1.5195E-07_JPRB/)
KBO( :, 4,52, 3) = (/&
&6.1793E-09_JPRB,1.1080E-07_JPRB,1.7865E-07_JPRB,2.3238E-07_JPRB,1.6623E-07_JPRB/)
KBO( :, 5,52, 3) = (/&
&1.0533E-08_JPRB,1.4468E-07_JPRB,2.2055E-07_JPRB,2.6689E-07_JPRB,1.8440E-07_JPRB/)
KBO( :, 1,53, 3) = (/&
&1.4057E-09_JPRB,4.6460E-08_JPRB,9.5335E-08_JPRB,1.8476E-07_JPRB,1.0859E-07_JPRB/)
KBO( :, 2,53, 3) = (/&
&1.7607E-09_JPRB,5.3285E-08_JPRB,1.0139E-07_JPRB,1.7215E-07_JPRB,1.1242E-07_JPRB/)
KBO( :, 3,53, 3) = (/&
&2.5488E-09_JPRB,6.4871E-08_JPRB,1.1488E-07_JPRB,1.7132E-07_JPRB,1.1951E-07_JPRB/)
KBO( :, 4,53, 3) = (/&
&4.1657E-09_JPRB,8.2629E-08_JPRB,1.3641E-07_JPRB,1.8283E-07_JPRB,1.2965E-07_JPRB/)
KBO( :, 5,53, 3) = (/&
&7.0997E-09_JPRB,1.0750E-07_JPRB,1.6715E-07_JPRB,2.0732E-07_JPRB,1.4296E-07_JPRB/)
KBO( :, 1,54, 3) = (/&
&1.0999E-09_JPRB,3.6846E-08_JPRB,7.7697E-08_JPRB,1.5754E-07_JPRB,8.8206E-08_JPRB/)
KBO( :, 2,54, 3) = (/&
&1.3156E-09_JPRB,4.1399E-08_JPRB,8.0749E-08_JPRB,1.4331E-07_JPRB,9.0854E-08_JPRB/)
KBO( :, 3,54, 3) = (/&
&1.8124E-09_JPRB,4.9493E-08_JPRB,8.9710E-08_JPRB,1.3962E-07_JPRB,9.5712E-08_JPRB/)
KBO( :, 4,54, 3) = (/&
&2.8677E-09_JPRB,6.2264E-08_JPRB,1.0518E-07_JPRB,1.4542E-07_JPRB,1.0312E-07_JPRB/)
KBO( :, 5,54, 3) = (/&
&4.8571E-09_JPRB,8.0602E-08_JPRB,1.2774E-07_JPRB,1.6229E-07_JPRB,1.1315E-07_JPRB/)
KBO( :, 1,55, 3) = (/&
&8.7254E-10_JPRB,2.9511E-08_JPRB,6.3773E-08_JPRB,1.3472E-07_JPRB,7.2224E-08_JPRB/)
KBO( :, 2,55, 3) = (/&
&1.0019E-09_JPRB,3.2470E-08_JPRB,6.4795E-08_JPRB,1.1996E-07_JPRB,7.4131E-08_JPRB/)
KBO( :, 3,55, 3) = (/&
&1.3171E-09_JPRB,3.8081E-08_JPRB,7.0642E-08_JPRB,1.1458E-07_JPRB,7.7438E-08_JPRB/)
KBO( :, 4,55, 3) = (/&
&2.0021E-09_JPRB,4.7221E-08_JPRB,8.1614E-08_JPRB,1.1674E-07_JPRB,8.2998E-08_JPRB/)
KBO( :, 5,55, 3) = (/&
&3.3482E-09_JPRB,6.0727E-08_JPRB,9.8113E-08_JPRB,1.2774E-07_JPRB,9.0672E-08_JPRB/)
KBO( :, 1,56, 3) = (/&
&6.9950E-10_JPRB,2.3838E-08_JPRB,5.2680E-08_JPRB,1.1562E-07_JPRB,5.9234E-08_JPRB/)
KBO( :, 2,56, 3) = (/&
&7.7413E-10_JPRB,2.5644E-08_JPRB,5.2472E-08_JPRB,1.0117E-07_JPRB,6.0572E-08_JPRB/)
KBO( :, 3,56, 3) = (/&
&9.7208E-10_JPRB,2.9465E-08_JPRB,5.5972E-08_JPRB,9.4548E-08_JPRB,6.2834E-08_JPRB/)
KBO( :, 4,56, 3) = (/&
&1.4121E-09_JPRB,3.5940E-08_JPRB,6.3562E-08_JPRB,9.4353E-08_JPRB,6.6970E-08_JPRB/)
KBO( :, 5,56, 3) = (/&
&2.3128E-09_JPRB,4.5822E-08_JPRB,7.5568E-08_JPRB,1.0098E-07_JPRB,7.2808E-08_JPRB/)
KBO( :, 1,57, 3) = (/&
&5.6581E-10_JPRB,1.9346E-08_JPRB,4.3790E-08_JPRB,9.9565E-08_JPRB,4.8602E-08_JPRB/)
KBO( :, 2,57, 3) = (/&
&6.0638E-10_JPRB,2.0352E-08_JPRB,4.2737E-08_JPRB,8.6020E-08_JPRB,4.9598E-08_JPRB/)
KBO( :, 3,57, 3) = (/&
&7.2835E-10_JPRB,2.2928E-08_JPRB,4.4588E-08_JPRB,7.8554E-08_JPRB,5.1156E-08_JPRB/)
KBO( :, 4,57, 3) = (/&
&1.0089E-09_JPRB,2.7487E-08_JPRB,4.9704E-08_JPRB,7.6812E-08_JPRB,5.4188E-08_JPRB/)
KBO( :, 5,57, 3) = (/&
&1.6034E-09_JPRB,3.4641E-08_JPRB,5.8392E-08_JPRB,8.0331E-08_JPRB,5.8574E-08_JPRB/)
KBO( :, 1,58, 3) = (/&
&4.6103E-10_JPRB,1.5793E-08_JPRB,3.6627E-08_JPRB,8.5726E-08_JPRB,3.9978E-08_JPRB/)
KBO( :, 2,58, 3) = (/&
&4.8130E-10_JPRB,1.6286E-08_JPRB,3.5015E-08_JPRB,7.3307E-08_JPRB,4.0789E-08_JPRB/)
KBO( :, 3,58, 3) = (/&
&5.5585E-10_JPRB,1.8004E-08_JPRB,3.5764E-08_JPRB,6.5610E-08_JPRB,4.1884E-08_JPRB/)
KBO( :, 4,58, 3) = (/&
&7.3630E-10_JPRB,2.1198E-08_JPRB,3.9171E-08_JPRB,6.2959E-08_JPRB,4.4100E-08_JPRB/)
KBO( :, 5,58, 3) = (/&
&1.1276E-09_JPRB,2.6366E-08_JPRB,4.5403E-08_JPRB,6.4458E-08_JPRB,4.7431E-08_JPRB/)
KBO( :, 1,59, 3) = (/&
&3.7755E-10_JPRB,1.2932E-08_JPRB,3.0232E-08_JPRB,7.1480E-08_JPRB,3.3647E-08_JPRB/)
KBO( :, 2,59, 3) = (/&
&3.9028E-10_JPRB,1.3252E-08_JPRB,2.8716E-08_JPRB,6.0919E-08_JPRB,3.4209E-08_JPRB/)
KBO( :, 3,59, 3) = (/&
&4.4415E-10_JPRB,1.4531E-08_JPRB,2.9099E-08_JPRB,5.4129E-08_JPRB,3.5197E-08_JPRB/)
KBO( :, 4,59, 3) = (/&
&5.7804E-10_JPRB,1.6979E-08_JPRB,3.1645E-08_JPRB,5.1588E-08_JPRB,3.7203E-08_JPRB/)
KBO( :, 5,59, 3) = (/&
&8.7073E-10_JPRB,2.0997E-08_JPRB,3.6469E-08_JPRB,5.2428E-08_JPRB,4.0115E-08_JPRB/)
KBO( :, 1,13, 4) = (/&
&8.9291E-05_JPRB,3.8524E-04_JPRB,5.0838E-04_JPRB,6.5865E-04_JPRB,3.8422E-03_JPRB/)
KBO( :, 2,13, 4) = (/&
&1.2150E-04_JPRB,5.0395E-04_JPRB,6.2502E-04_JPRB,7.1591E-04_JPRB,4.4934E-03_JPRB/)
KBO( :, 3,13, 4) = (/&
&1.6722E-04_JPRB,6.6391E-04_JPRB,7.8605E-04_JPRB,8.2001E-04_JPRB,5.0967E-03_JPRB/)
KBO( :, 4,13, 4) = (/&
&2.3167E-04_JPRB,8.6690E-04_JPRB,9.9738E-04_JPRB,9.6960E-04_JPRB,5.6862E-03_JPRB/)
KBO( :, 5,13, 4) = (/&
&3.2066E-04_JPRB,1.1149E-03_JPRB,1.2572E-03_JPRB,1.1723E-03_JPRB,6.2886E-03_JPRB/)
KBO( :, 1,14, 4) = (/&
&7.3069E-05_JPRB,3.2443E-04_JPRB,4.2572E-04_JPRB,5.4565E-04_JPRB,3.2324E-03_JPRB/)
KBO( :, 2,14, 4) = (/&
&1.0078E-04_JPRB,4.2788E-04_JPRB,5.2773E-04_JPRB,5.9812E-04_JPRB,3.7083E-03_JPRB/)
KBO( :, 3,14, 4) = (/&
&1.4066E-04_JPRB,5.6564E-04_JPRB,6.6846E-04_JPRB,6.8982E-04_JPRB,4.1601E-03_JPRB/)
KBO( :, 4,14, 4) = (/&
&1.9708E-04_JPRB,7.3974E-04_JPRB,8.5021E-04_JPRB,8.2165E-04_JPRB,4.6256E-03_JPRB/)
KBO( :, 5,14, 4) = (/&
&2.7523E-04_JPRB,9.5281E-04_JPRB,1.0713E-03_JPRB,9.9745E-04_JPRB,5.1177E-03_JPRB/)
KBO( :, 1,15, 4) = (/&
&5.8268E-05_JPRB,2.7203E-04_JPRB,3.5604E-04_JPRB,4.5206E-04_JPRB,2.5355E-03_JPRB/)
KBO( :, 2,15, 4) = (/&
&8.1805E-05_JPRB,3.6098E-04_JPRB,4.4467E-04_JPRB,4.9956E-04_JPRB,2.8581E-03_JPRB/)
KBO( :, 3,15, 4) = (/&
&1.1620E-04_JPRB,4.7910E-04_JPRB,5.6641E-04_JPRB,5.8044E-04_JPRB,3.1903E-03_JPRB/)
KBO( :, 4,15, 4) = (/&
&1.6501E-04_JPRB,6.2810E-04_JPRB,7.2148E-04_JPRB,6.9577E-04_JPRB,3.5501E-03_JPRB/)
KBO( :, 5,15, 4) = (/&
&2.3301E-04_JPRB,8.1144E-04_JPRB,9.1027E-04_JPRB,8.4726E-04_JPRB,3.9463E-03_JPRB/)
KBO( :, 1,16, 4) = (/&
&4.6115E-05_JPRB,2.2742E-04_JPRB,2.9760E-04_JPRB,3.7441E-04_JPRB,1.8635E-03_JPRB/)
KBO( :, 2,16, 4) = (/&
&6.6044E-05_JPRB,3.0388E-04_JPRB,3.7432E-04_JPRB,4.1709E-04_JPRB,2.0896E-03_JPRB/)
KBO( :, 3,16, 4) = (/&
&9.5513E-05_JPRB,4.0494E-04_JPRB,4.7881E-04_JPRB,4.8833E-04_JPRB,2.3373E-03_JPRB/)
KBO( :, 4,16, 4) = (/&
&1.3768E-04_JPRB,5.3229E-04_JPRB,6.1073E-04_JPRB,5.8836E-04_JPRB,2.6201E-03_JPRB/)
KBO( :, 5,16, 4) = (/&
&1.9676E-04_JPRB,6.8916E-04_JPRB,7.7223E-04_JPRB,7.1811E-04_JPRB,2.9128E-03_JPRB/)
KBO( :, 1,17, 4) = (/&
&3.7236E-05_JPRB,1.9117E-04_JPRB,2.4928E-04_JPRB,3.1036E-04_JPRB,1.3781E-03_JPRB/)
KBO( :, 2,17, 4) = (/&
&5.4291E-05_JPRB,2.5693E-04_JPRB,3.1565E-04_JPRB,3.4867E-04_JPRB,1.5505E-03_JPRB/)
KBO( :, 3,17, 4) = (/&
&7.9749E-05_JPRB,3.4332E-04_JPRB,4.0498E-04_JPRB,4.1127E-04_JPRB,1.7502E-03_JPRB/)
KBO( :, 4,17, 4) = (/&
&1.1653E-04_JPRB,4.5210E-04_JPRB,5.1744E-04_JPRB,4.9715E-04_JPRB,1.9654E-03_JPRB/)
KBO( :, 5,17, 4) = (/&
&1.6848E-04_JPRB,5.8567E-04_JPRB,6.5487E-04_JPRB,6.0828E-04_JPRB,2.1867E-03_JPRB/)
KBO( :, 1,18, 4) = (/&
&3.1214E-05_JPRB,1.6265E-04_JPRB,2.1001E-04_JPRB,2.5789E-04_JPRB,1.0508E-03_JPRB/)
KBO( :, 2,18, 4) = (/&
&4.6115E-05_JPRB,2.1928E-04_JPRB,2.6764E-04_JPRB,2.9235E-04_JPRB,1.1925E-03_JPRB/)
KBO( :, 3,18, 4) = (/&
&6.8526E-05_JPRB,2.9311E-04_JPRB,3.4395E-04_JPRB,3.4662E-04_JPRB,1.3522E-03_JPRB/)
KBO( :, 4,18, 4) = (/&
&1.0108E-04_JPRB,3.8595E-04_JPRB,4.3972E-04_JPRB,4.2050E-04_JPRB,1.5200E-03_JPRB/)
KBO( :, 5,18, 4) = (/&
&1.4724E-04_JPRB,4.9979E-04_JPRB,5.5620E-04_JPRB,5.1508E-04_JPRB,1.6884E-03_JPRB/)
KBO( :, 1,19, 4) = (/&
&2.6494E-05_JPRB,1.3877E-04_JPRB,1.7752E-04_JPRB,2.1456E-04_JPRB,8.3267E-04_JPRB/)
KBO( :, 2,19, 4) = (/&
&3.9645E-05_JPRB,1.8735E-04_JPRB,2.2717E-04_JPRB,2.4531E-04_JPRB,9.5168E-04_JPRB/)
KBO( :, 3,19, 4) = (/&
&5.9441E-05_JPRB,2.5031E-04_JPRB,2.9223E-04_JPRB,2.9203E-04_JPRB,1.0814E-03_JPRB/)
KBO( :, 4,19, 4) = (/&
&8.8341E-05_JPRB,3.2954E-04_JPRB,3.7346E-04_JPRB,3.5516E-04_JPRB,1.2143E-03_JPRB/)
KBO( :, 5,19, 4) = (/&
&1.2952E-04_JPRB,4.2674E-04_JPRB,4.7232E-04_JPRB,4.3565E-04_JPRB,1.3453E-03_JPRB/)
KBO( :, 1,20, 4) = (/&
&2.2953E-05_JPRB,1.1923E-04_JPRB,1.5106E-04_JPRB,1.7906E-04_JPRB,6.7531E-04_JPRB/)
KBO( :, 2,20, 4) = (/&
&3.4684E-05_JPRB,1.6096E-04_JPRB,1.9387E-04_JPRB,2.0645E-04_JPRB,7.7360E-04_JPRB/)
KBO( :, 3,20, 4) = (/&
&5.2387E-05_JPRB,2.1493E-04_JPRB,2.4939E-04_JPRB,2.4674E-04_JPRB,8.7927E-04_JPRB/)
KBO( :, 4,20, 4) = (/&
&7.8339E-05_JPRB,2.8287E-04_JPRB,3.1867E-04_JPRB,3.0094E-04_JPRB,9.8457E-04_JPRB/)
KBO( :, 5,20, 4) = (/&
&1.1532E-04_JPRB,3.6655E-04_JPRB,4.0332E-04_JPRB,3.6955E-04_JPRB,1.0890E-03_JPRB/)
KBO( :, 1,21, 4) = (/&
&1.9939E-05_JPRB,1.0230E-04_JPRB,1.2858E-04_JPRB,1.4968E-04_JPRB,5.4869E-04_JPRB/)
KBO( :, 2,21, 4) = (/&
&3.0427E-05_JPRB,1.3816E-04_JPRB,1.6531E-04_JPRB,1.7375E-04_JPRB,6.2932E-04_JPRB/)
KBO( :, 3,21, 4) = (/&
&4.6301E-05_JPRB,1.8453E-04_JPRB,2.1269E-04_JPRB,2.0848E-04_JPRB,7.1424E-04_JPRB/)
KBO( :, 4,21, 4) = (/&
&6.9612E-05_JPRB,2.4288E-04_JPRB,2.7189E-04_JPRB,2.5497E-04_JPRB,7.9799E-04_JPRB/)
KBO( :, 5,21, 4) = (/&
&1.0255E-04_JPRB,3.1496E-04_JPRB,3.4452E-04_JPRB,3.1356E-04_JPRB,8.8178E-04_JPRB/)
KBO( :, 1,22, 4) = (/&
&1.7650E-05_JPRB,8.9099E-05_JPRB,1.1086E-04_JPRB,1.2617E-04_JPRB,4.4136E-04_JPRB/)
KBO( :, 2,22, 4) = (/&
&2.7256E-05_JPRB,1.2040E-04_JPRB,1.4288E-04_JPRB,1.4770E-04_JPRB,5.0625E-04_JPRB/)
KBO( :, 3,22, 4) = (/&
&4.1784E-05_JPRB,1.6082E-04_JPRB,1.8391E-04_JPRB,1.7825E-04_JPRB,5.7259E-04_JPRB/)
KBO( :, 4,22, 4) = (/&
&6.2963E-05_JPRB,2.1168E-04_JPRB,2.3528E-04_JPRB,2.1869E-04_JPRB,6.3831E-04_JPRB/)
KBO( :, 5,22, 4) = (/&
&9.2479E-05_JPRB,2.7473E-04_JPRB,2.9834E-04_JPRB,2.6936E-04_JPRB,7.0511E-04_JPRB/)
KBO( :, 1,23, 4) = (/&
&1.5661E-05_JPRB,7.7570E-05_JPRB,9.5606E-05_JPRB,1.0649E-04_JPRB,3.5282E-04_JPRB/)
KBO( :, 2,23, 4) = (/&
&2.4419E-05_JPRB,1.0492E-04_JPRB,1.2350E-04_JPRB,1.2569E-04_JPRB,4.0389E-04_JPRB/)
KBO( :, 3,23, 4) = (/&
&3.7617E-05_JPRB,1.4021E-04_JPRB,1.5914E-04_JPRB,1.5253E-04_JPRB,4.5535E-04_JPRB/)
KBO( :, 4,23, 4) = (/&
&5.6623E-05_JPRB,1.8459E-04_JPRB,2.0378E-04_JPRB,1.8772E-04_JPRB,5.0734E-04_JPRB/)
KBO( :, 5,23, 4) = (/&
&8.2850E-05_JPRB,2.3955E-04_JPRB,2.5868E-04_JPRB,2.3168E-04_JPRB,5.6073E-04_JPRB/)
KBO( :, 1,24, 4) = (/&
&1.3761E-05_JPRB,6.7313E-05_JPRB,8.2387E-05_JPRB,8.9985E-05_JPRB,2.7657E-04_JPRB/)
KBO( :, 2,24, 4) = (/&
&2.1660E-05_JPRB,9.1214E-05_JPRB,1.0663E-04_JPRB,1.0703E-04_JPRB,3.1564E-04_JPRB/)
KBO( :, 3,24, 4) = (/&
&3.3471E-05_JPRB,1.2198E-04_JPRB,1.3767E-04_JPRB,1.3062E-04_JPRB,3.5536E-04_JPRB/)
KBO( :, 4,24, 4) = (/&
&5.0313E-05_JPRB,1.6066E-04_JPRB,1.7646E-04_JPRB,1.6127E-04_JPRB,3.9633E-04_JPRB/)
KBO( :, 5,24, 4) = (/&
&7.3360E-05_JPRB,2.0829E-04_JPRB,2.2414E-04_JPRB,1.9939E-04_JPRB,4.3964E-04_JPRB/)
KBO( :, 1,25, 4) = (/&
&1.2163E-05_JPRB,5.8632E-05_JPRB,7.1210E-05_JPRB,7.6289E-05_JPRB,2.1557E-04_JPRB/)
KBO( :, 2,25, 4) = (/&
&1.9262E-05_JPRB,7.9563E-05_JPRB,9.2384E-05_JPRB,9.1431E-05_JPRB,2.4548E-04_JPRB/)
KBO( :, 3,25, 4) = (/&
&2.9768E-05_JPRB,1.0645E-04_JPRB,1.1942E-04_JPRB,1.1222E-04_JPRB,2.7636E-04_JPRB/)
KBO( :, 4,25, 4) = (/&
&4.4635E-05_JPRB,1.4006E-04_JPRB,1.5316E-04_JPRB,1.3892E-04_JPRB,3.0913E-04_JPRB/)
KBO( :, 5,25, 4) = (/&
&6.4723E-05_JPRB,1.8122E-04_JPRB,1.9446E-04_JPRB,1.7203E-04_JPRB,3.4459E-04_JPRB/)
KBO( :, 1,26, 4) = (/&
&1.0905E-05_JPRB,5.1509E-05_JPRB,6.1982E-05_JPRB,6.5048E-05_JPRB,1.6912E-04_JPRB/)
KBO( :, 2,26, 4) = (/&
&1.7301E-05_JPRB,6.9938E-05_JPRB,8.0564E-05_JPRB,7.8594E-05_JPRB,1.9235E-04_JPRB/)
KBO( :, 3,26, 4) = (/&
&2.6674E-05_JPRB,9.3478E-05_JPRB,1.0420E-04_JPRB,9.6933E-05_JPRB,2.1692E-04_JPRB/)
KBO( :, 4,26, 4) = (/&
&3.9810E-05_JPRB,1.2260E-04_JPRB,1.3358E-04_JPRB,1.2031E-04_JPRB,2.4372E-04_JPRB/)
KBO( :, 5,26, 4) = (/&
&5.7269E-05_JPRB,1.5819E-04_JPRB,1.6929E-04_JPRB,1.4904E-04_JPRB,2.7283E-04_JPRB/)
KBO( :, 1,27, 4) = (/&
&9.7443E-06_JPRB,4.5256E-05_JPRB,5.3977E-05_JPRB,5.5564E-05_JPRB,1.3079E-04_JPRB/)
KBO( :, 2,27, 4) = (/&
&1.5468E-05_JPRB,6.1434E-05_JPRB,7.0240E-05_JPRB,6.7661E-05_JPRB,1.4885E-04_JPRB/)
KBO( :, 3,27, 4) = (/&
&2.3785E-05_JPRB,8.1876E-05_JPRB,9.0868E-05_JPRB,8.3801E-05_JPRB,1.6857E-04_JPRB/)
KBO( :, 4,27, 4) = (/&
&3.5289E-05_JPRB,1.0705E-04_JPRB,1.1628E-04_JPRB,1.0418E-04_JPRB,1.9038E-04_JPRB/)
KBO( :, 5,27, 4) = (/&
&5.0352E-05_JPRB,1.3763E-04_JPRB,1.4705E-04_JPRB,1.2891E-04_JPRB,2.1399E-04_JPRB/)
KBO( :, 1,28, 4) = (/&
&8.6662E-06_JPRB,3.9710E-05_JPRB,4.6973E-05_JPRB,4.7545E-05_JPRB,9.9573E-05_JPRB/)
KBO( :, 2,28, 4) = (/&
&1.3762E-05_JPRB,5.3808E-05_JPRB,6.1191E-05_JPRB,5.8312E-05_JPRB,1.1378E-04_JPRB/)
KBO( :, 3,28, 4) = (/&
&2.1087E-05_JPRB,7.1458E-05_JPRB,7.9071E-05_JPRB,7.2428E-05_JPRB,1.2969E-04_JPRB/)
KBO( :, 4,28, 4) = (/&
&3.1073E-05_JPRB,9.3127E-05_JPRB,1.0097E-04_JPRB,9.0079E-05_JPRB,1.4713E-04_JPRB/)
KBO( :, 5,28, 4) = (/&
&4.4032E-05_JPRB,1.1919E-04_JPRB,1.2726E-04_JPRB,1.1128E-04_JPRB,1.6603E-04_JPRB/)
KBO( :, 1,29, 4) = (/&
&7.7998E-06_JPRB,3.4996E-05_JPRB,4.1036E-05_JPRB,4.0865E-05_JPRB,7.6462E-05_JPRB/)
KBO( :, 2,29, 4) = (/&
&1.2351E-05_JPRB,4.7253E-05_JPRB,5.3436E-05_JPRB,5.0409E-05_JPRB,8.7836E-05_JPRB/)
KBO( :, 3,29, 4) = (/&
&1.8799E-05_JPRB,6.2498E-05_JPRB,6.8909E-05_JPRB,6.2727E-05_JPRB,1.0047E-04_JPRB/)
KBO( :, 4,29, 4) = (/&
&2.7485E-05_JPRB,8.1095E-05_JPRB,8.7731E-05_JPRB,7.7973E-05_JPRB,1.1434E-04_JPRB/)
KBO( :, 5,29, 4) = (/&
&3.8681E-05_JPRB,1.0324E-04_JPRB,1.1009E-04_JPRB,9.6092E-05_JPRB,1.2937E-04_JPRB/)
KBO( :, 1,30, 4) = (/&
&7.0184E-06_JPRB,3.0793E-05_JPRB,3.5835E-05_JPRB,3.5181E-05_JPRB,5.8539E-05_JPRB/)
KBO( :, 2,30, 4) = (/&
&1.1059E-05_JPRB,4.1419E-05_JPRB,4.6605E-05_JPRB,4.3585E-05_JPRB,6.7504E-05_JPRB/)
KBO( :, 3,30, 4) = (/&
&1.6707E-05_JPRB,5.4550E-05_JPRB,5.9937E-05_JPRB,5.4295E-05_JPRB,7.7471E-05_JPRB/)
KBO( :, 4,30, 4) = (/&
&2.4261E-05_JPRB,7.0416E-05_JPRB,7.6043E-05_JPRB,6.7394E-05_JPRB,8.8468E-05_JPRB/)
KBO( :, 5,30, 4) = (/&
&3.3920E-05_JPRB,8.9259E-05_JPRB,9.5020E-05_JPRB,8.2834E-05_JPRB,1.0026E-04_JPRB/)
KBO( :, 1,31, 4) = (/&
&6.3446E-06_JPRB,2.7130E-05_JPRB,3.1326E-05_JPRB,3.0364E-05_JPRB,4.4778E-05_JPRB/)
KBO( :, 2,31, 4) = (/&
&9.9240E-06_JPRB,3.6330E-05_JPRB,4.0667E-05_JPRB,3.7732E-05_JPRB,5.1776E-05_JPRB/)
KBO( :, 3,31, 4) = (/&
&1.4883E-05_JPRB,4.7593E-05_JPRB,5.2134E-05_JPRB,4.7015E-05_JPRB,5.9603E-05_JPRB/)
KBO( :, 4,31, 4) = (/&
&2.1454E-05_JPRB,6.1120E-05_JPRB,6.5847E-05_JPRB,5.8207E-05_JPRB,6.8104E-05_JPRB/)
KBO( :, 5,31, 4) = (/&
&2.9770E-05_JPRB,7.7114E-05_JPRB,8.1935E-05_JPRB,7.1309E-05_JPRB,7.7163E-05_JPRB/)
KBO( :, 1,32, 4) = (/&
&5.7447E-06_JPRB,2.3909E-05_JPRB,2.7402E-05_JPRB,2.6256E-05_JPRB,3.4475E-05_JPRB/)
KBO( :, 2,32, 4) = (/&
&8.9146E-06_JPRB,3.1849E-05_JPRB,3.5487E-05_JPRB,3.2695E-05_JPRB,3.9934E-05_JPRB/)
KBO( :, 3,32, 4) = (/&
&1.3271E-05_JPRB,4.1481E-05_JPRB,4.5305E-05_JPRB,4.0703E-05_JPRB,4.6002E-05_JPRB/)
KBO( :, 4,32, 4) = (/&
&1.8982E-05_JPRB,5.3015E-05_JPRB,5.6969E-05_JPRB,5.0230E-05_JPRB,5.2546E-05_JPRB/)
KBO( :, 5,32, 4) = (/&
&2.6129E-05_JPRB,6.6634E-05_JPRB,7.0625E-05_JPRB,6.1359E-05_JPRB,5.9507E-05_JPRB/)
KBO( :, 1,33, 4) = (/&
&5.1981E-06_JPRB,2.1048E-05_JPRB,2.3959E-05_JPRB,2.2727E-05_JPRB,2.6591E-05_JPRB/)
KBO( :, 2,33, 4) = (/&
&8.0045E-06_JPRB,2.7863E-05_JPRB,3.0928E-05_JPRB,2.8329E-05_JPRB,3.0795E-05_JPRB/)
KBO( :, 3,33, 4) = (/&
&1.1826E-05_JPRB,3.6107E-05_JPRB,3.9311E-05_JPRB,3.5200E-05_JPRB,3.5437E-05_JPRB/)
KBO( :, 4,33, 4) = (/&
&1.6780E-05_JPRB,4.5955E-05_JPRB,4.9249E-05_JPRB,4.3321E-05_JPRB,4.0422E-05_JPRB/)
KBO( :, 5,33, 4) = (/&
&2.2903E-05_JPRB,5.7519E-05_JPRB,6.0835E-05_JPRB,5.2765E-05_JPRB,4.5739E-05_JPRB/)
KBO( :, 1,34, 4) = (/&
&4.6580E-06_JPRB,1.8365E-05_JPRB,2.0792E-05_JPRB,1.9562E-05_JPRB,2.0973E-05_JPRB/)
KBO( :, 2,34, 4) = (/&
&7.1195E-06_JPRB,2.4178E-05_JPRB,2.6741E-05_JPRB,2.4385E-05_JPRB,2.4253E-05_JPRB/)
KBO( :, 3,34, 4) = (/&
&1.0442E-05_JPRB,3.1196E-05_JPRB,3.3863E-05_JPRB,3.0227E-05_JPRB,2.7827E-05_JPRB/)
KBO( :, 4,34, 4) = (/&
&1.4703E-05_JPRB,3.9556E-05_JPRB,4.2281E-05_JPRB,3.7105E-05_JPRB,3.1694E-05_JPRB/)
KBO( :, 5,34, 4) = (/&
&1.9922E-05_JPRB,4.9351E-05_JPRB,5.2082E-05_JPRB,4.5102E-05_JPRB,3.5824E-05_JPRB/)
KBO( :, 1,35, 4) = (/&
&3.9871E-06_JPRB,1.5551E-05_JPRB,1.7571E-05_JPRB,1.6475E-05_JPRB,1.6236E-05_JPRB/)
KBO( :, 2,35, 4) = (/&
&6.0757E-06_JPRB,2.0414E-05_JPRB,2.2542E-05_JPRB,2.0527E-05_JPRB,1.8741E-05_JPRB/)
KBO( :, 3,35, 4) = (/&
&8.8794E-06_JPRB,2.6281E-05_JPRB,2.8490E-05_JPRB,2.5405E-05_JPRB,2.1473E-05_JPRB/)
KBO( :, 4,35, 4) = (/&
&1.2455E-05_JPRB,3.3253E-05_JPRB,3.5511E-05_JPRB,3.1147E-05_JPRB,2.4458E-05_JPRB/)
KBO( :, 5,35, 4) = (/&
&1.6817E-05_JPRB,4.1417E-05_JPRB,4.3680E-05_JPRB,3.7812E-05_JPRB,2.7668E-05_JPRB/)
KBO( :, 1,36, 4) = (/&
&3.2421E-06_JPRB,1.2741E-05_JPRB,1.4415E-05_JPRB,1.3532E-05_JPRB,1.2305E-05_JPRB/)
KBO( :, 2,36, 4) = (/&
&4.9489E-06_JPRB,1.6721E-05_JPRB,1.8482E-05_JPRB,1.6856E-05_JPRB,1.4197E-05_JPRB/)
KBO( :, 3,36, 4) = (/&
&7.2420E-06_JPRB,2.1525E-05_JPRB,2.3354E-05_JPRB,2.0857E-05_JPRB,1.6279E-05_JPRB/)
KBO( :, 4,36, 4) = (/&
&1.0165E-05_JPRB,2.7235E-05_JPRB,2.9106E-05_JPRB,2.5564E-05_JPRB,1.8568E-05_JPRB/)
KBO( :, 5,36, 4) = (/&
&1.3731E-05_JPRB,3.3924E-05_JPRB,3.5798E-05_JPRB,3.1035E-05_JPRB,2.1028E-05_JPRB/)
KBO( :, 1,37, 4) = (/&
&2.4960E-06_JPRB,1.0060E-05_JPRB,1.1424E-05_JPRB,1.0782E-05_JPRB,9.5086E-06_JPRB/)
KBO( :, 2,37, 4) = (/&
&3.8363E-06_JPRB,1.3236E-05_JPRB,1.4673E-05_JPRB,1.3431E-05_JPRB,1.0977E-05_JPRB/)
KBO( :, 3,37, 4) = (/&
&5.6488E-06_JPRB,1.7076E-05_JPRB,1.8572E-05_JPRB,1.6635E-05_JPRB,1.2594E-05_JPRB/)
KBO( :, 4,37, 4) = (/&
&7.9747E-06_JPRB,2.1652E-05_JPRB,2.3188E-05_JPRB,2.0415E-05_JPRB,1.4374E-05_JPRB/)
KBO( :, 5,37, 4) = (/&
&1.0825E-05_JPRB,2.7021E-05_JPRB,2.8566E-05_JPRB,2.4811E-05_JPRB,1.6291E-05_JPRB/)
KBO( :, 1,38, 4) = (/&
&1.9124E-06_JPRB,7.9183E-06_JPRB,9.0316E-06_JPRB,8.5743E-06_JPRB,7.3236E-06_JPRB/)
KBO( :, 2,38, 4) = (/&
&2.9610E-06_JPRB,1.0450E-05_JPRB,1.1621E-05_JPRB,1.0680E-05_JPRB,8.4614E-06_JPRB/)
KBO( :, 3,38, 4) = (/&
&4.3884E-06_JPRB,1.3515E-05_JPRB,1.4735E-05_JPRB,1.3241E-05_JPRB,9.7136E-06_JPRB/)
KBO( :, 4,38, 4) = (/&
&6.2344E-06_JPRB,1.7177E-05_JPRB,1.8435E-05_JPRB,1.6272E-05_JPRB,1.1094E-05_JPRB/)
KBO( :, 5,38, 4) = (/&
&8.5074E-06_JPRB,2.1480E-05_JPRB,2.2749E-05_JPRB,1.9801E-05_JPRB,1.2587E-05_JPRB/)
KBO( :, 1,39, 4) = (/&
&1.4627E-06_JPRB,6.2280E-06_JPRB,7.1358E-06_JPRB,6.8164E-06_JPRB,5.6091E-06_JPRB/)
KBO( :, 2,39, 4) = (/&
&2.2819E-06_JPRB,8.2437E-06_JPRB,9.1991E-06_JPRB,8.4900E-06_JPRB,6.4837E-06_JPRB/)
KBO( :, 3,39, 4) = (/&
&3.4040E-06_JPRB,1.0689E-05_JPRB,1.1687E-05_JPRB,1.0535E-05_JPRB,7.4507E-06_JPRB/)
KBO( :, 4,39, 4) = (/&
&4.8667E-06_JPRB,1.3619E-05_JPRB,1.4649E-05_JPRB,1.2965E-05_JPRB,8.5144E-06_JPRB/)
KBO( :, 5,39, 4) = (/&
&6.6789E-06_JPRB,1.7065E-05_JPRB,1.8109E-05_JPRB,1.5796E-05_JPRB,9.6724E-06_JPRB/)
KBO( :, 1,40, 4) = (/&
&1.0675E-06_JPRB,4.7580E-06_JPRB,5.4948E-06_JPRB,5.3059E-06_JPRB,4.3235E-06_JPRB/)
KBO( :, 2,40, 4) = (/&
&1.6854E-06_JPRB,6.3316E-06_JPRB,7.1065E-06_JPRB,6.6059E-06_JPRB,5.0037E-06_JPRB/)
KBO( :, 3,40, 4) = (/&
&2.5416E-06_JPRB,8.2475E-06_JPRB,9.0584E-06_JPRB,8.2078E-06_JPRB,5.7598E-06_JPRB/)
KBO( :, 4,40, 4) = (/&
&3.6732E-06_JPRB,1.0552E-05_JPRB,1.1392E-05_JPRB,1.0125E-05_JPRB,6.5921E-06_JPRB/)
KBO( :, 5,40, 4) = (/&
&5.0895E-06_JPRB,1.3270E-05_JPRB,1.4125E-05_JPRB,1.2362E-05_JPRB,7.4983E-06_JPRB/)
KBO( :, 1,41, 4) = (/&
&7.7161E-07_JPRB,3.6153E-06_JPRB,4.2135E-06_JPRB,4.1208E-06_JPRB,3.3291E-06_JPRB/)
KBO( :, 2,41, 4) = (/&
&1.2341E-06_JPRB,4.8398E-06_JPRB,5.4667E-06_JPRB,5.1245E-06_JPRB,3.8572E-06_JPRB/)
KBO( :, 3,41, 4) = (/&
&1.8830E-06_JPRB,6.3358E-06_JPRB,6.9937E-06_JPRB,6.3742E-06_JPRB,4.4475E-06_JPRB/)
KBO( :, 4,41, 4) = (/&
&2.7524E-06_JPRB,8.1422E-06_JPRB,8.8253E-06_JPRB,7.8806E-06_JPRB,5.1001E-06_JPRB/)
KBO( :, 5,41, 4) = (/&
&3.8533E-06_JPRB,1.0280E-05_JPRB,1.0980E-05_JPRB,9.6445E-06_JPRB,5.8088E-06_JPRB/)
KBO( :, 1,42, 4) = (/&
&5.5525E-07_JPRB,2.7416E-06_JPRB,3.2273E-06_JPRB,3.2019E-06_JPRB,2.5561E-06_JPRB/)
KBO( :, 2,42, 4) = (/&
&8.9993E-07_JPRB,3.6924E-06_JPRB,4.1998E-06_JPRB,3.9740E-06_JPRB,2.9638E-06_JPRB/)
KBO( :, 3,42, 4) = (/&
&1.3900E-06_JPRB,4.8597E-06_JPRB,5.3933E-06_JPRB,4.9465E-06_JPRB,3.4230E-06_JPRB/)
KBO( :, 4,42, 4) = (/&
&2.0552E-06_JPRB,6.2735E-06_JPRB,6.8295E-06_JPRB,6.1284E-06_JPRB,3.9326E-06_JPRB/)
KBO( :, 5,42, 4) = (/&
&2.9084E-06_JPRB,7.9541E-06_JPRB,8.5264E-06_JPRB,7.5190E-06_JPRB,4.4871E-06_JPRB/)
KBO( :, 1,43, 4) = (/&
&3.8700E-07_JPRB,2.0403E-06_JPRB,2.4343E-06_JPRB,2.4629E-06_JPRB,1.9559E-06_JPRB/)
KBO( :, 2,43, 4) = (/&
&6.3768E-07_JPRB,2.7683E-06_JPRB,3.1780E-06_JPRB,3.0455E-06_JPRB,2.2677E-06_JPRB/)
KBO( :, 3,43, 4) = (/&
&9.9992E-07_JPRB,3.6688E-06_JPRB,4.0996E-06_JPRB,3.7915E-06_JPRB,2.6241E-06_JPRB/)
KBO( :, 4,43, 4) = (/&
&1.4987E-06_JPRB,4.7637E-06_JPRB,5.2140E-06_JPRB,4.7076E-06_JPRB,3.0207E-06_JPRB/)
KBO( :, 5,43, 4) = (/&
&2.1501E-06_JPRB,6.0714E-06_JPRB,6.5361E-06_JPRB,5.7934E-06_JPRB,3.4541E-06_JPRB/)
KBO( :, 1,44, 4) = (/&
&2.6473E-07_JPRB,1.5026E-06_JPRB,1.8221E-06_JPRB,1.8897E-06_JPRB,1.4930E-06_JPRB/)
KBO( :, 2,44, 4) = (/&
&4.4431E-07_JPRB,2.0561E-06_JPRB,2.3866E-06_JPRB,2.3229E-06_JPRB,1.7300E-06_JPRB/)
KBO( :, 3,44, 4) = (/&
&7.0836E-07_JPRB,2.7457E-06_JPRB,3.0927E-06_JPRB,2.8894E-06_JPRB,2.0046E-06_JPRB/)
KBO( :, 4,44, 4) = (/&
&1.0778E-06_JPRB,3.5888E-06_JPRB,3.9529E-06_JPRB,3.5941E-06_JPRB,2.3122E-06_JPRB/)
KBO( :, 5,44, 4) = (/&
&1.5696E-06_JPRB,4.6015E-06_JPRB,4.9786E-06_JPRB,4.4373E-06_JPRB,2.6499E-06_JPRB/)
KBO( :, 1,45, 4) = (/&
&1.7988E-07_JPRB,1.1038E-06_JPRB,1.3625E-06_JPRB,1.4540E-06_JPRB,1.1371E-06_JPRB/)
KBO( :, 2,45, 4) = (/&
&3.0761E-07_JPRB,1.5225E-06_JPRB,1.7898E-06_JPRB,1.7738E-06_JPRB,1.3160E-06_JPRB/)
KBO( :, 3,45, 4) = (/&
&4.9893E-07_JPRB,2.0494E-06_JPRB,2.3287E-06_JPRB,2.2017E-06_JPRB,1.5258E-06_JPRB/)
KBO( :, 4,45, 4) = (/&
&7.7117E-07_JPRB,2.6974E-06_JPRB,2.9913E-06_JPRB,2.7416E-06_JPRB,1.7632E-06_JPRB/)
KBO( :, 5,45, 4) = (/&
&1.1399E-06_JPRB,3.4797E-06_JPRB,3.7851E-06_JPRB,3.3943E-06_JPRB,2.0252E-06_JPRB/)
KBO( :, 1,46, 4) = (/&
&1.1995E-07_JPRB,8.0292E-07_JPRB,1.0121E-06_JPRB,1.1184E-06_JPRB,8.6488E-07_JPRB/)
KBO( :, 2,46, 4) = (/&
&2.0923E-07_JPRB,1.1166E-06_JPRB,1.3331E-06_JPRB,1.3511E-06_JPRB,9.9849E-07_JPRB/)
KBO( :, 3,46, 4) = (/&
&3.4582E-07_JPRB,1.5161E-06_JPRB,1.7409E-06_JPRB,1.6700E-06_JPRB,1.1579E-06_JPRB/)
KBO( :, 4,46, 4) = (/&
&5.4384E-07_JPRB,2.0114E-06_JPRB,2.2481E-06_JPRB,2.0803E-06_JPRB,1.3401E-06_JPRB/)
KBO( :, 5,46, 4) = (/&
&8.1669E-07_JPRB,2.6123E-06_JPRB,2.8596E-06_JPRB,2.5822E-06_JPRB,1.5424E-06_JPRB/)
KBO( :, 1,47, 4) = (/&
&7.7552E-08_JPRB,5.7430E-07_JPRB,7.4352E-07_JPRB,8.5913E-07_JPRB,6.5834E-07_JPRB/)
KBO( :, 2,47, 4) = (/&
&1.3815E-07_JPRB,8.0547E-07_JPRB,9.8055E-07_JPRB,1.0241E-06_JPRB,7.5785E-07_JPRB/)
KBO( :, 3,47, 4) = (/&
&2.3338E-07_JPRB,1.1046E-06_JPRB,1.2855E-06_JPRB,1.2567E-06_JPRB,8.7753E-07_JPRB/)
KBO( :, 4,47, 4) = (/&
&3.7439E-07_JPRB,1.4793E-06_JPRB,1.6690E-06_JPRB,1.5636E-06_JPRB,1.0168E-06_JPRB/)
KBO( :, 5,47, 4) = (/&
&5.7238E-07_JPRB,1.9364E-06_JPRB,2.1357E-06_JPRB,1.9451E-06_JPRB,1.1726E-06_JPRB/)
KBO( :, 1,48, 4) = (/&
&4.9759E-08_JPRB,4.0982E-07_JPRB,5.4734E-07_JPRB,6.6597E-07_JPRB,5.0055E-07_JPRB/)
KBO( :, 2,48, 4) = (/&
&9.0399E-08_JPRB,5.7899E-07_JPRB,7.2041E-07_JPRB,7.7952E-07_JPRB,5.7407E-07_JPRB/)
KBO( :, 3,48, 4) = (/&
&1.5613E-07_JPRB,8.0155E-07_JPRB,9.4754E-07_JPRB,9.4742E-07_JPRB,6.6288E-07_JPRB/)
KBO( :, 4,48, 4) = (/&
&2.5563E-07_JPRB,1.0837E-06_JPRB,1.2359E-06_JPRB,1.1750E-06_JPRB,7.6860E-07_JPRB/)
KBO( :, 5,48, 4) = (/&
&3.9824E-07_JPRB,1.4310E-06_JPRB,1.5913E-06_JPRB,1.4634E-06_JPRB,8.8756E-07_JPRB/)
KBO( :, 1,49, 4) = (/&
&3.1747E-08_JPRB,2.9202E-07_JPRB,4.0458E-07_JPRB,5.2185E-07_JPRB,3.8074E-07_JPRB/)
KBO( :, 2,49, 4) = (/&
&5.8620E-08_JPRB,4.1476E-07_JPRB,5.2889E-07_JPRB,5.9643E-07_JPRB,4.3322E-07_JPRB/)
KBO( :, 3,49, 4) = (/&
&1.0349E-07_JPRB,5.7925E-07_JPRB,6.9731E-07_JPRB,7.1647E-07_JPRB,4.9889E-07_JPRB/)
KBO( :, 4,49, 4) = (/&
&1.7311E-07_JPRB,7.9083E-07_JPRB,9.1312E-07_JPRB,8.8335E-07_JPRB,5.7760E-07_JPRB/)
KBO( :, 5,49, 4) = (/&
&2.7502E-07_JPRB,1.0539E-06_JPRB,1.1826E-06_JPRB,1.1000E-06_JPRB,6.6799E-07_JPRB/)
KBO( :, 1,50, 4) = (/&
&2.0584E-08_JPRB,2.1008E-07_JPRB,3.0301E-07_JPRB,4.1495E-07_JPRB,2.9497E-07_JPRB/)
KBO( :, 2,50, 4) = (/&
&3.8348E-08_JPRB,2.9905E-07_JPRB,3.9149E-07_JPRB,4.6171E-07_JPRB,3.3200E-07_JPRB/)
KBO( :, 3,50, 4) = (/&
&6.9001E-08_JPRB,4.2073E-07_JPRB,5.1626E-07_JPRB,5.4677E-07_JPRB,3.8063E-07_JPRB/)
KBO( :, 4,50, 4) = (/&
&1.1783E-07_JPRB,5.7965E-07_JPRB,6.7829E-07_JPRB,6.6887E-07_JPRB,4.3991E-07_JPRB/)
KBO( :, 5,50, 4) = (/&
&1.9076E-07_JPRB,7.7947E-07_JPRB,8.8269E-07_JPRB,8.3154E-07_JPRB,5.0913E-07_JPRB/)
KBO( :, 1,51, 4) = (/&
&1.3493E-08_JPRB,1.5211E-07_JPRB,2.2929E-07_JPRB,3.3385E-07_JPRB,2.3077E-07_JPRB/)
KBO( :, 2,51, 4) = (/&
&2.5122E-08_JPRB,2.1611E-07_JPRB,2.9145E-07_JPRB,3.6106E-07_JPRB,2.5676E-07_JPRB/)
KBO( :, 3,51, 4) = (/&
&4.5978E-08_JPRB,3.0596E-07_JPRB,3.8316E-07_JPRB,4.1984E-07_JPRB,2.9257E-07_JPRB/)
KBO( :, 4,51, 4) = (/&
&8.0110E-08_JPRB,4.2511E-07_JPRB,5.0483E-07_JPRB,5.0877E-07_JPRB,3.3737E-07_JPRB/)
KBO( :, 5,51, 4) = (/&
&1.3215E-07_JPRB,5.7668E-07_JPRB,6.5965E-07_JPRB,6.3029E-07_JPRB,3.9043E-07_JPRB/)
KBO( :, 1,52, 4) = (/&
&8.9230E-09_JPRB,1.1071E-07_JPRB,1.7523E-07_JPRB,2.7190E-07_JPRB,1.8118E-07_JPRB/)
KBO( :, 2,52, 4) = (/&
&1.6411E-08_JPRB,1.5606E-07_JPRB,2.1785E-07_JPRB,2.8505E-07_JPRB,1.9923E-07_JPRB/)
KBO( :, 3,52, 4) = (/&
&3.0439E-08_JPRB,2.2195E-07_JPRB,2.8438E-07_JPRB,3.2394E-07_JPRB,2.2485E-07_JPRB/)
KBO( :, 4,52, 4) = (/&
&5.4073E-08_JPRB,3.1080E-07_JPRB,3.7535E-07_JPRB,3.8813E-07_JPRB,2.5827E-07_JPRB/)
KBO( :, 5,52, 4) = (/&
&9.0961E-08_JPRB,4.2534E-07_JPRB,4.9215E-07_JPRB,4.7800E-07_JPRB,2.9864E-07_JPRB/)
KBO( :, 1,53, 4) = (/&
&5.9876E-09_JPRB,8.1201E-08_JPRB,1.3536E-07_JPRB,2.2434E-07_JPRB,1.4306E-07_JPRB/)
KBO( :, 2,53, 4) = (/&
&1.0717E-08_JPRB,1.1272E-07_JPRB,1.6383E-07_JPRB,2.2748E-07_JPRB,1.5495E-07_JPRB/)
KBO( :, 3,53, 4) = (/&
&2.0015E-08_JPRB,1.6060E-07_JPRB,2.1125E-07_JPRB,2.5162E-07_JPRB,1.7284E-07_JPRB/)
KBO( :, 4,53, 4) = (/&
&3.6209E-08_JPRB,2.2643E-07_JPRB,2.7869E-07_JPRB,2.9706E-07_JPRB,1.9723E-07_JPRB/)
KBO( :, 5,53, 4) = (/&
&6.2161E-08_JPRB,3.1263E-07_JPRB,3.6655E-07_JPRB,3.6292E-07_JPRB,2.2770E-07_JPRB/)
KBO( :, 1,54, 4) = (/&
&4.1655E-09_JPRB,6.0699E-08_JPRB,1.0631E-07_JPRB,1.8695E-07_JPRB,1.1504E-07_JPRB/)
KBO( :, 2,54, 4) = (/&
&7.1662E-09_JPRB,8.2506E-08_JPRB,1.2498E-07_JPRB,1.8360E-07_JPRB,1.2311E-07_JPRB/)
KBO( :, 3,54, 4) = (/&
&1.3353E-08_JPRB,1.1732E-07_JPRB,1.5863E-07_JPRB,1.9781E-07_JPRB,1.3609E-07_JPRB/)
KBO( :, 4,54, 4) = (/&
&2.4527E-08_JPRB,1.6632E-07_JPRB,2.0860E-07_JPRB,2.2954E-07_JPRB,1.5431E-07_JPRB/)
KBO( :, 5,54, 4) = (/&
&4.2883E-08_JPRB,2.3139E-07_JPRB,2.7507E-07_JPRB,2.7789E-07_JPRB,1.7766E-07_JPRB/)
KBO( :, 1,55, 4) = (/&
&2.9815E-09_JPRB,4.5994E-08_JPRB,8.4525E-08_JPRB,1.5735E-07_JPRB,9.3462E-08_JPRB/)
KBO( :, 2,55, 4) = (/&
&4.8723E-09_JPRB,6.0940E-08_JPRB,9.6391E-08_JPRB,1.4974E-07_JPRB,9.9006E-08_JPRB/)
KBO( :, 3,55, 4) = (/&
&8.9683E-09_JPRB,8.6061E-08_JPRB,1.1996E-07_JPRB,1.5698E-07_JPRB,1.0869E-07_JPRB/)
KBO( :, 4,55, 4) = (/&
&1.6661E-08_JPRB,1.2249E-07_JPRB,1.5677E-07_JPRB,1.7852E-07_JPRB,1.2250E-07_JPRB/)
KBO( :, 5,55, 4) = (/&
&2.9629E-08_JPRB,1.7161E-07_JPRB,2.0705E-07_JPRB,2.1394E-07_JPRB,1.4060E-07_JPRB/)
KBO( :, 1,56, 4) = (/&
&2.1861E-09_JPRB,3.5243E-08_JPRB,6.7842E-08_JPRB,1.3338E-07_JPRB,7.6071E-08_JPRB/)
KBO( :, 2,56, 4) = (/&
&3.3518E-09_JPRB,4.5292E-08_JPRB,7.4962E-08_JPRB,1.2335E-07_JPRB,7.9965E-08_JPRB/)
KBO( :, 3,56, 4) = (/&
&6.0272E-09_JPRB,6.3165E-08_JPRB,9.1168E-08_JPRB,1.2562E-07_JPRB,8.7021E-08_JPRB/)
KBO( :, 4,56, 4) = (/&
&1.1269E-08_JPRB,9.0068E-08_JPRB,1.1792E-07_JPRB,1.3956E-07_JPRB,9.7479E-08_JPRB/)
KBO( :, 5,56, 4) = (/&
&2.0362E-08_JPRB,1.2698E-07_JPRB,1.5571E-07_JPRB,1.6515E-07_JPRB,1.1148E-07_JPRB/)
KBO( :, 1,57, 4) = (/&
&1.6409E-09_JPRB,2.7386E-08_JPRB,5.4848E-08_JPRB,1.1388E-07_JPRB,6.2033E-08_JPRB/)
KBO( :, 2,57, 4) = (/&
&2.3428E-09_JPRB,3.3930E-08_JPRB,5.8875E-08_JPRB,1.0251E-07_JPRB,6.4870E-08_JPRB/)
KBO( :, 3,57, 4) = (/&
&4.0625E-09_JPRB,4.6423E-08_JPRB,6.9674E-08_JPRB,1.0133E-07_JPRB,6.9866E-08_JPRB/)
KBO( :, 4,57, 4) = (/&
&7.5880E-09_JPRB,6.6138E-08_JPRB,8.8862E-08_JPRB,1.0977E-07_JPRB,7.7746E-08_JPRB/)
KBO( :, 5,57, 4) = (/&
&1.3915E-08_JPRB,9.3738E-08_JPRB,1.1702E-07_JPRB,1.2786E-07_JPRB,8.8586E-08_JPRB/)
KBO( :, 1,58, 4) = (/&
&1.2635E-09_JPRB,2.1604E-08_JPRB,4.4731E-08_JPRB,9.7552E-08_JPRB,5.0828E-08_JPRB/)
KBO( :, 2,58, 4) = (/&
&1.6814E-09_JPRB,2.5762E-08_JPRB,4.6786E-08_JPRB,8.5976E-08_JPRB,5.2911E-08_JPRB/)
KBO( :, 3,58, 4) = (/&
&2.7835E-09_JPRB,3.4427E-08_JPRB,5.3815E-08_JPRB,8.2469E-08_JPRB,5.6515E-08_JPRB/)
KBO( :, 4,58, 4) = (/&
&5.1497E-09_JPRB,4.8806E-08_JPRB,6.7425E-08_JPRB,8.7085E-08_JPRB,6.2504E-08_JPRB/)
KBO( :, 5,58, 4) = (/&
&9.5533E-09_JPRB,6.9446E-08_JPRB,8.8336E-08_JPRB,9.9625E-08_JPRB,7.0988E-08_JPRB/)
KBO( :, 1,59, 4) = (/&
&1.0158E-09_JPRB,1.7490E-08_JPRB,3.6651E-08_JPRB,8.1330E-08_JPRB,4.2750E-08_JPRB/)
KBO( :, 2,59, 4) = (/&
&1.3161E-09_JPRB,2.0543E-08_JPRB,3.7942E-08_JPRB,7.1098E-08_JPRB,4.4506E-08_JPRB/)
KBO( :, 3,59, 4) = (/&
&2.1325E-09_JPRB,2.7191E-08_JPRB,4.3180E-08_JPRB,6.7506E-08_JPRB,4.7664E-08_JPRB/)
KBO( :, 4,59, 4) = (/&
&3.9206E-09_JPRB,3.8435E-08_JPRB,5.3711E-08_JPRB,7.0587E-08_JPRB,5.2961E-08_JPRB/)
KBO( :, 5,59, 4) = (/&
&7.2991E-09_JPRB,5.4760E-08_JPRB,7.0199E-08_JPRB,8.0158E-08_JPRB,6.0356E-08_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3_B1
