!OCL SCALAR
SUBROUTINE RRTM_KGB2_01

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 2:  250-500 cm-1 (low - H2O; high - H2O)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO2 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO
USE YOERRTA2 , ONLY : REFPARAM

!     ------------------------------------------------------------------


IMPLICIT NONE
FRACREFBO( :) = (/&
!     From P = 0.432 mb.
    &0.17444289_JPRB,0.16467269_JPRB,0.15021490_JPRB,0.12460902_JPRB,&
    &0.10400643_JPRB,0.09481928_JPRB,0.07590704_JPRB,0.05752856_JPRB,&
    &0.03931715_JPRB,0.00428572_JPRB,0.00349352_JPRB,0.00278938_JPRB,&
    &0.00203448_JPRB,0.00130037_JPRB,0.00051560_JPRB,0.00006255_JPRB/)

FORREFO( :) = (/&
     &-2.34550E-03_JPRB,-8.42698E-03_JPRB,-2.01816E-02_JPRB,-5.66701E-02_JPRB,&
     &-8.93189E-02_JPRB,-6.37487E-02_JPRB,-4.56455E-02_JPRB,-4.41417E-02_JPRB,&
     &-4.48605E-02_JPRB,-4.74696E-02_JPRB,-5.16648E-02_JPRB,-5.63099E-02_JPRB,&
     &-4.74781E-02_JPRB,-3.84704E-02_JPRB,-2.49905E-02_JPRB, 2.02114E-03_JPRB/)

!     The following are parameters related to the reference water vapor
!     mixing ratios by REFPARAM(I) = REFH2O(I) / (.002+REFH2O(I)).
!     These parameters are used for the Planck function interpolation.
REFPARAM( :) = (/&
 &0.903661_JPRB   , 0.859386_JPRB   , 0.746542_JPRB   , 0.580496_JPRB   , 0.412889_JPRB   ,&
 &0.275283_JPRB   , 0.162745_JPRB   , 7.63929E-02_JPRB, 1.82553E-02_JPRB, 3.72432E-03_JPRB, &
 &2.14946E-03_JPRB, 1.66320E-03_JPRB, 1.59940E-03_JPRB/)

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
&1.4400E-02_JPRB,1.5554E-02_JPRB,1.6739E-02_JPRB,1.7961E-02_JPRB,1.9379E-02_JPRB/)
KAO( :, 2, 1) = (/&
&1.1452E-02_JPRB,1.2288E-02_JPRB,1.3232E-02_JPRB,1.4190E-02_JPRB,1.5277E-02_JPRB/)
KAO( :, 3, 1) = (/&
&8.9989E-03_JPRB,9.5960E-03_JPRB,1.0327E-02_JPRB,1.1068E-02_JPRB,1.1889E-02_JPRB/)
KAO( :, 4, 1) = (/&
&7.1078E-03_JPRB,7.5424E-03_JPRB,8.0710E-03_JPRB,8.6639E-03_JPRB,9.2920E-03_JPRB/)
KAO( :, 5, 1) = (/&
&5.6632E-03_JPRB,5.9616E-03_JPRB,6.3421E-03_JPRB,6.8076E-03_JPRB,7.2949E-03_JPRB/)
KAO( :, 6, 1) = (/&
&4.5348E-03_JPRB,4.7267E-03_JPRB,5.0015E-03_JPRB,5.3391E-03_JPRB,5.7317E-03_JPRB/)
KAO( :, 7, 1) = (/&
&3.6484E-03_JPRB,3.7737E-03_JPRB,3.9583E-03_JPRB,4.2050E-03_JPRB,4.5069E-03_JPRB/)
KAO( :, 8, 1) = (/&
&2.9485E-03_JPRB,3.0305E-03_JPRB,3.1509E-03_JPRB,3.3270E-03_JPRB,3.5470E-03_JPRB/)
KAO( :, 9, 1) = (/&
&2.4028E-03_JPRB,2.4476E-03_JPRB,2.5272E-03_JPRB,2.6456E-03_JPRB,2.8089E-03_JPRB/)
KAO( :,10, 1) = (/&
&1.9899E-03_JPRB,2.0047E-03_JPRB,2.0583E-03_JPRB,2.1403E-03_JPRB,2.2643E-03_JPRB/)
KAO( :,11, 1) = (/&
&1.6478E-03_JPRB,1.6593E-03_JPRB,1.7036E-03_JPRB,1.7737E-03_JPRB,1.8823E-03_JPRB/)
KAO( :,12, 1) = (/&
&1.3599E-03_JPRB,1.3694E-03_JPRB,1.4067E-03_JPRB,1.4672E-03_JPRB,1.5617E-03_JPRB/)
KAO( :,13, 1) = (/&
&1.1157E-03_JPRB,1.1241E-03_JPRB,1.1555E-03_JPRB,1.2073E-03_JPRB,1.2864E-03_JPRB/)
KAO( :, 1, 2) = (/&
&3.8905E-02_JPRB,4.2429E-02_JPRB,4.6513E-02_JPRB,5.0588E-02_JPRB,5.5021E-02_JPRB/)
KAO( :, 2, 2) = (/&
&3.0803E-02_JPRB,3.3461E-02_JPRB,3.6546E-02_JPRB,3.9922E-02_JPRB,4.3440E-02_JPRB/)
KAO( :, 3, 2) = (/&
&2.4144E-02_JPRB,2.6019E-02_JPRB,2.8287E-02_JPRB,3.0953E-02_JPRB,3.3739E-02_JPRB/)
KAO( :, 4, 2) = (/&
&1.9082E-02_JPRB,2.0371E-02_JPRB,2.2034E-02_JPRB,2.4014E-02_JPRB,2.6250E-02_JPRB/)
KAO( :, 5, 2) = (/&
&1.5203E-02_JPRB,1.6092E-02_JPRB,1.7271E-02_JPRB,1.8721E-02_JPRB,2.0471E-02_JPRB/)
KAO( :, 6, 2) = (/&
&1.2164E-02_JPRB,1.2769E-02_JPRB,1.3578E-02_JPRB,1.4643E-02_JPRB,1.5928E-02_JPRB/)
KAO( :, 7, 2) = (/&
&9.7815E-03_JPRB,1.0186E-02_JPRB,1.0740E-02_JPRB,1.1487E-02_JPRB,1.2435E-02_JPRB/)
KAO( :, 8, 2) = (/&
&7.9245E-03_JPRB,8.1687E-03_JPRB,8.5497E-03_JPRB,9.0644E-03_JPRB,9.7618E-03_JPRB/)
KAO( :, 9, 2) = (/&
&6.4727E-03_JPRB,6.5836E-03_JPRB,6.8391E-03_JPRB,7.1947E-03_JPRB,7.6826E-03_JPRB/)
KAO( :,10, 2) = (/&
&5.3240E-03_JPRB,5.3575E-03_JPRB,5.5193E-03_JPRB,5.7706E-03_JPRB,6.1166E-03_JPRB/)
KAO( :,11, 2) = (/&
&4.3783E-03_JPRB,4.4065E-03_JPRB,4.5391E-03_JPRB,4.7453E-03_JPRB,5.0313E-03_JPRB/)
KAO( :,12, 2) = (/&
&3.5968E-03_JPRB,3.6203E-03_JPRB,3.7298E-03_JPRB,3.8998E-03_JPRB,4.1378E-03_JPRB/)
KAO( :,13, 2) = (/&
&2.9507E-03_JPRB,2.9704E-03_JPRB,3.0611E-03_JPRB,3.2015E-03_JPRB,3.4012E-03_JPRB/)
KAO( :, 1, 3) = (/&
&1.0636E-01_JPRB,1.1680E-01_JPRB,1.2824E-01_JPRB,1.4017E-01_JPRB,1.5266E-01_JPRB/)
KAO( :, 2, 3) = (/&
&8.4443E-02_JPRB,9.2480E-02_JPRB,1.0148E-01_JPRB,1.1092E-01_JPRB,1.2100E-01_JPRB/)
KAO( :, 3, 3) = (/&
&6.5959E-02_JPRB,7.1869E-02_JPRB,7.8770E-02_JPRB,8.6250E-02_JPRB,9.4058E-02_JPRB/)
KAO( :, 4, 3) = (/&
&5.1681E-02_JPRB,5.6029E-02_JPRB,6.1207E-02_JPRB,6.7088E-02_JPRB,7.3195E-02_JPRB/)
KAO( :, 5, 3) = (/&
&4.0734E-02_JPRB,4.3938E-02_JPRB,4.7777E-02_JPRB,5.2288E-02_JPRB,5.7243E-02_JPRB/)
KAO( :, 6, 3) = (/&
&3.2248E-02_JPRB,3.4534E-02_JPRB,3.7344E-02_JPRB,4.0738E-02_JPRB,4.4673E-02_JPRB/)
KAO( :, 7, 3) = (/&
&2.5731E-02_JPRB,2.7244E-02_JPRB,2.9333E-02_JPRB,3.1849E-02_JPRB,3.4861E-02_JPRB/)
KAO( :, 8, 3) = (/&
&2.0693E-02_JPRB,2.1657E-02_JPRB,2.3154E-02_JPRB,2.5012E-02_JPRB,2.7268E-02_JPRB/)
KAO( :, 9, 3) = (/&
&1.6730E-02_JPRB,1.7346E-02_JPRB,1.8327E-02_JPRB,1.9716E-02_JPRB,2.1381E-02_JPRB/)
KAO( :,10, 3) = (/&
&1.3588E-02_JPRB,1.4015E-02_JPRB,1.4658E-02_JPRB,1.5680E-02_JPRB,1.6936E-02_JPRB/)
KAO( :,11, 3) = (/&
&1.1180E-02_JPRB,1.1528E-02_JPRB,1.2063E-02_JPRB,1.2917E-02_JPRB,1.3959E-02_JPRB/)
KAO( :,12, 3) = (/&
&9.1920E-03_JPRB,9.4766E-03_JPRB,9.9244E-03_JPRB,1.0636E-02_JPRB,1.1502E-02_JPRB/)
KAO( :,13, 3) = (/&
&7.5517E-03_JPRB,7.7861E-03_JPRB,8.1602E-03_JPRB,8.7504E-03_JPRB,9.4682E-03_JPRB/)
KAO( :, 1, 4) = (/&
&2.6559E-01_JPRB,2.7778E-01_JPRB,2.8983E-01_JPRB,3.0112E-01_JPRB,3.1151E-01_JPRB/)
KAO( :, 2, 4) = (/&
&2.1415E-01_JPRB,2.2376E-01_JPRB,2.3372E-01_JPRB,2.4291E-01_JPRB,2.5148E-01_JPRB/)
KAO( :, 3, 4) = (/&
&1.7113E-01_JPRB,1.7864E-01_JPRB,1.8679E-01_JPRB,1.9418E-01_JPRB,2.0158E-01_JPRB/)
KAO( :, 4, 4) = (/&
&1.3689E-01_JPRB,1.4305E-01_JPRB,1.4933E-01_JPRB,1.5577E-01_JPRB,1.6212E-01_JPRB/)
KAO( :, 5, 4) = (/&
&1.0951E-01_JPRB,1.1484E-01_JPRB,1.1993E-01_JPRB,1.2527E-01_JPRB,1.3048E-01_JPRB/)
KAO( :, 6, 4) = (/&
&8.7678E-02_JPRB,9.2013E-02_JPRB,9.6292E-02_JPRB,1.0052E-01_JPRB,1.0492E-01_JPRB/)
KAO( :, 7, 4) = (/&
&7.0271E-02_JPRB,7.3646E-02_JPRB,7.7252E-02_JPRB,8.0679E-02_JPRB,8.4295E-02_JPRB/)
KAO( :, 8, 4) = (/&
&5.6292E-02_JPRB,5.9027E-02_JPRB,6.1915E-02_JPRB,6.4784E-02_JPRB,6.7662E-02_JPRB/)
KAO( :, 9, 4) = (/&
&4.5045E-02_JPRB,4.7308E-02_JPRB,4.9593E-02_JPRB,5.1992E-02_JPRB,5.4350E-02_JPRB/)
KAO( :,10, 4) = (/&
&3.6083E-02_JPRB,3.8037E-02_JPRB,3.9928E-02_JPRB,4.1868E-02_JPRB,4.3827E-02_JPRB/)
KAO( :,11, 4) = (/&
&2.9684E-02_JPRB,3.1305E-02_JPRB,3.2869E-02_JPRB,3.4458E-02_JPRB,3.6069E-02_JPRB/)
KAO( :,12, 4) = (/&
&2.4428E-02_JPRB,2.5760E-02_JPRB,2.7039E-02_JPRB,2.8345E-02_JPRB,2.9671E-02_JPRB/)
KAO( :,13, 4) = (/&
&2.0094E-02_JPRB,2.1179E-02_JPRB,2.2224E-02_JPRB,2.3304E-02_JPRB,2.4394E-02_JPRB/)
KAO( :, 1, 5) = (/&
&4.7290E-01_JPRB,4.8928E-01_JPRB,5.0887E-01_JPRB,5.3328E-01_JPRB,5.6216E-01_JPRB/)
KAO( :, 2, 5) = (/&
&3.8475E-01_JPRB,3.9762E-01_JPRB,4.1280E-01_JPRB,4.3219E-01_JPRB,4.5473E-01_JPRB/)
KAO( :, 3, 5) = (/&
&3.0979E-01_JPRB,3.1996E-01_JPRB,3.3105E-01_JPRB,3.4530E-01_JPRB,3.6216E-01_JPRB/)
KAO( :, 4, 5) = (/&
&2.5002E-01_JPRB,2.5800E-01_JPRB,2.6674E-01_JPRB,2.7709E-01_JPRB,2.8946E-01_JPRB/)
KAO( :, 5, 5) = (/&
&2.0218E-01_JPRB,2.0847E-01_JPRB,2.1546E-01_JPRB,2.2311E-01_JPRB,2.3239E-01_JPRB/)
KAO( :, 6, 5) = (/&
&1.6286E-01_JPRB,1.6840E-01_JPRB,1.7397E-01_JPRB,1.7996E-01_JPRB,1.8683E-01_JPRB/)
KAO( :, 7, 5) = (/&
&1.3055E-01_JPRB,1.3602E-01_JPRB,1.4050E-01_JPRB,1.4524E-01_JPRB,1.5047E-01_JPRB/)
KAO( :, 8, 5) = (/&
&1.0442E-01_JPRB,1.0954E-01_JPRB,1.1353E-01_JPRB,1.1737E-01_JPRB,1.2143E-01_JPRB/)
KAO( :, 9, 5) = (/&
&8.3388E-02_JPRB,8.7841E-02_JPRB,9.1682E-02_JPRB,9.4816E-02_JPRB,9.8050E-02_JPRB/)
KAO( :,10, 5) = (/&
&6.7010E-02_JPRB,7.0598E-02_JPRB,7.4015E-02_JPRB,7.6769E-02_JPRB,7.9372E-02_JPRB/)
KAO( :,11, 5) = (/&
&5.5118E-02_JPRB,5.8051E-02_JPRB,6.0869E-02_JPRB,6.3114E-02_JPRB,6.5294E-02_JPRB/)
KAO( :,12, 5) = (/&
&4.5300E-02_JPRB,4.7721E-02_JPRB,5.0049E-02_JPRB,5.1890E-02_JPRB,5.3682E-02_JPRB/)
KAO( :,13, 5) = (/&
&3.7225E-02_JPRB,3.9236E-02_JPRB,4.1133E-02_JPRB,4.2631E-02_JPRB,4.4126E-02_JPRB/)
KAO( :, 1, 6) = (/&
&8.4224E-01_JPRB,9.2264E-01_JPRB,1.0073E+00_JPRB,1.0930E+00_JPRB,1.1793E+00_JPRB/)
KAO( :, 2, 6) = (/&
&6.7595E-01_JPRB,7.4232E-01_JPRB,8.1248E-01_JPRB,8.8302E-01_JPRB,9.5616E-01_JPRB/)
KAO( :, 3, 6) = (/&
&5.2904E-01_JPRB,5.8048E-01_JPRB,6.3751E-01_JPRB,6.9642E-01_JPRB,7.5721E-01_JPRB/)
KAO( :, 4, 6) = (/&
&4.1315E-01_JPRB,4.5407E-01_JPRB,4.9971E-01_JPRB,5.4886E-01_JPRB,5.9964E-01_JPRB/)
KAO( :, 5, 6) = (/&
&3.2467E-01_JPRB,3.5531E-01_JPRB,3.9159E-01_JPRB,4.3161E-01_JPRB,4.7423E-01_JPRB/)
KAO( :, 6, 6) = (/&
&2.5574E-01_JPRB,2.7784E-01_JPRB,3.0579E-01_JPRB,3.3817E-01_JPRB,3.7278E-01_JPRB/)
KAO( :, 7, 6) = (/&
&2.0313E-01_JPRB,2.1792E-01_JPRB,2.3876E-01_JPRB,2.6386E-01_JPRB,2.9205E-01_JPRB/)
KAO( :, 8, 6) = (/&
&1.6285E-01_JPRB,1.7201E-01_JPRB,1.8675E-01_JPRB,2.0598E-01_JPRB,2.2843E-01_JPRB/)
KAO( :, 9, 6) = (/&
&1.3178E-01_JPRB,1.3687E-01_JPRB,1.4670E-01_JPRB,1.6087E-01_JPRB,1.7827E-01_JPRB/)
KAO( :,10, 6) = (/&
&1.0760E-01_JPRB,1.1022E-01_JPRB,1.1661E-01_JPRB,1.2690E-01_JPRB,1.4033E-01_JPRB/)
KAO( :,11, 6) = (/&
&8.8471E-02_JPRB,9.0742E-02_JPRB,9.6088E-02_JPRB,1.0477E-01_JPRB,1.1601E-01_JPRB/)
KAO( :,12, 6) = (/&
&7.2724E-02_JPRB,7.4645E-02_JPRB,7.9165E-02_JPRB,8.6464E-02_JPRB,9.5844E-02_JPRB/)
KAO( :,13, 6) = (/&
&5.9719E-02_JPRB,6.1350E-02_JPRB,6.5177E-02_JPRB,7.1301E-02_JPRB,7.9088E-02_JPRB/)
KAO( :, 1, 7) = (/&
&1.8416E+00_JPRB,2.0377E+00_JPRB,2.2351E+00_JPRB,2.4351E+00_JPRB,2.6357E+00_JPRB/)
KAO( :, 2, 7) = (/&
&1.5057E+00_JPRB,1.6691E+00_JPRB,1.8342E+00_JPRB,2.0031E+00_JPRB,2.1705E+00_JPRB/)
KAO( :, 3, 7) = (/&
&1.1980E+00_JPRB,1.3329E+00_JPRB,1.4704E+00_JPRB,1.6099E+00_JPRB,1.7488E+00_JPRB/)
KAO( :, 4, 7) = (/&
&9.4408E-01_JPRB,1.0566E+00_JPRB,1.1708E+00_JPRB,1.2874E+00_JPRB,1.4014E+00_JPRB/)
KAO( :, 5, 7) = (/&
&7.4052E-01_JPRB,8.3332E-01_JPRB,9.3007E-01_JPRB,1.0263E+00_JPRB,1.1221E+00_JPRB/)
KAO( :, 6, 7) = (/&
&5.7502E-01_JPRB,6.5145E-01_JPRB,7.3102E-01_JPRB,8.1228E-01_JPRB,8.9283E-01_JPRB/)
KAO( :, 7, 7) = (/&
&4.4413E-01_JPRB,5.0565E-01_JPRB,5.7113E-01_JPRB,6.3832E-01_JPRB,7.0636E-01_JPRB/)
KAO( :, 8, 7) = (/&
&3.4215E-01_JPRB,3.9125E-01_JPRB,4.4414E-01_JPRB,4.9963E-01_JPRB,5.5600E-01_JPRB/)
KAO( :, 9, 7) = (/&
&2.6278E-01_JPRB,3.0155E-01_JPRB,3.4409E-01_JPRB,3.8940E-01_JPRB,4.3634E-01_JPRB/)
KAO( :,10, 7) = (/&
&2.0399E-01_JPRB,2.3450E-01_JPRB,2.6863E-01_JPRB,3.0559E-01_JPRB,3.4410E-01_JPRB/)
KAO( :,11, 7) = (/&
&1.6899E-01_JPRB,1.9452E-01_JPRB,2.2306E-01_JPRB,2.5367E-01_JPRB,2.8600E-01_JPRB/)
KAO( :,12, 7) = (/&
&1.4000E-01_JPRB,1.6132E-01_JPRB,1.8504E-01_JPRB,2.1049E-01_JPRB,2.3736E-01_JPRB/)
KAO( :,13, 7) = (/&
&1.1587E-01_JPRB,1.3364E-01_JPRB,1.5332E-01_JPRB,1.7448E-01_JPRB,1.9695E-01_JPRB/)
KAO( :, 1, 8) = (/&
&4.7751E+00_JPRB,5.2791E+00_JPRB,5.7933E+00_JPRB,6.3083E+00_JPRB,6.8326E+00_JPRB/)
KAO( :, 2, 8) = (/&
&4.0048E+00_JPRB,4.4443E+00_JPRB,4.8940E+00_JPRB,5.3580E+00_JPRB,5.8267E+00_JPRB/)
KAO( :, 3, 8) = (/&
&3.2400E+00_JPRB,3.6253E+00_JPRB,4.0207E+00_JPRB,4.4230E+00_JPRB,4.8210E+00_JPRB/)
KAO( :, 4, 8) = (/&
&2.5883E+00_JPRB,2.9210E+00_JPRB,3.2656E+00_JPRB,3.6154E+00_JPRB,3.9641E+00_JPRB/)
KAO( :, 5, 8) = (/&
&2.0550E+00_JPRB,2.3390E+00_JPRB,2.6351E+00_JPRB,2.9336E+00_JPRB,3.2370E+00_JPRB/)
KAO( :, 6, 8) = (/&
&1.6130E+00_JPRB,1.8538E+00_JPRB,2.1027E+00_JPRB,2.3582E+00_JPRB,2.6184E+00_JPRB/)
KAO( :, 7, 8) = (/&
&1.2548E+00_JPRB,1.4567E+00_JPRB,1.6664E+00_JPRB,1.8820E+00_JPRB,2.1036E+00_JPRB/)
KAO( :, 8, 8) = (/&
&9.6687E-01_JPRB,1.1348E+00_JPRB,1.3110E+00_JPRB,1.4930E+00_JPRB,1.6805E+00_JPRB/)
KAO( :, 9, 8) = (/&
&7.3847E-01_JPRB,8.7593E-01_JPRB,1.0221E+00_JPRB,1.1741E+00_JPRB,1.3319E+00_JPRB/)
KAO( :,10, 8) = (/&
&5.6776E-01_JPRB,6.8017E-01_JPRB,8.0059E-01_JPRB,9.2750E-01_JPRB,1.0593E+00_JPRB/)
KAO( :,11, 8) = (/&
&4.7511E-01_JPRB,5.6972E-01_JPRB,6.7118E-01_JPRB,7.7840E-01_JPRB,8.8949E-01_JPRB/)
KAO( :,12, 8) = (/&
&3.9658E-01_JPRB,4.7593E-01_JPRB,5.6128E-01_JPRB,6.5124E-01_JPRB,7.4417E-01_JPRB/)
KAO( :,13, 8) = (/&
&3.3005E-01_JPRB,3.9650E-01_JPRB,4.6807E-01_JPRB,5.4357E-01_JPRB,6.2155E-01_JPRB/)
KAO( :, 1, 9) = (/&
&1.7831E+01_JPRB,1.9823E+01_JPRB,2.1884E+01_JPRB,2.3937E+01_JPRB,2.5904E+01_JPRB/)
KAO( :, 2, 9) = (/&
&1.5983E+01_JPRB,1.7908E+01_JPRB,1.9844E+01_JPRB,2.1750E+01_JPRB,2.3639E+01_JPRB/)
KAO( :, 3, 9) = (/&
&1.3838E+01_JPRB,1.5652E+01_JPRB,1.7428E+01_JPRB,1.9195E+01_JPRB,2.0946E+01_JPRB/)
KAO( :, 4, 9) = (/&
&1.1707E+01_JPRB,1.3372E+01_JPRB,1.5018E+01_JPRB,1.6675E+01_JPRB,1.8330E+01_JPRB/)
KAO( :, 5, 9) = (/&
&9.7619E+00_JPRB,1.1244E+01_JPRB,1.2752E+01_JPRB,1.4279E+01_JPRB,1.5837E+01_JPRB/)
KAO( :, 6, 9) = (/&
&7.9817E+00_JPRB,9.2988E+00_JPRB,1.0650E+01_JPRB,1.2029E+01_JPRB,1.3449E+01_JPRB/)
KAO( :, 7, 9) = (/&
&6.4478E+00_JPRB,7.5864E+00_JPRB,8.7717E+00_JPRB,1.0008E+01_JPRB,1.1289E+01_JPRB/)
KAO( :, 8, 9) = (/&
&5.1550E+00_JPRB,6.1381E+00_JPRB,7.1667E+00_JPRB,8.2567E+00_JPRB,9.3759E+00_JPRB/)
KAO( :, 9, 9) = (/&
&4.0462E+00_JPRB,4.8924E+00_JPRB,5.7944E+00_JPRB,6.7466E+00_JPRB,7.7100E+00_JPRB/)
KAO( :,10, 9) = (/&
&3.1920E+00_JPRB,3.9133E+00_JPRB,4.6912E+00_JPRB,5.5091E+00_JPRB,6.3432E+00_JPRB/)
KAO( :,11, 9) = (/&
&2.7717E+00_JPRB,3.4039E+00_JPRB,4.0800E+00_JPRB,4.7818E+00_JPRB,5.5081E+00_JPRB/)
KAO( :,12, 9) = (/&
&2.3978E+00_JPRB,2.9436E+00_JPRB,3.5235E+00_JPRB,4.1293E+00_JPRB,4.7600E+00_JPRB/)
KAO( :,13, 9) = (/&
&2.0575E+00_JPRB,2.5263E+00_JPRB,3.0244E+00_JPRB,3.5477E+00_JPRB,4.0896E+00_JPRB/)
KAO( :, 1,10) = (/&
&4.9748E+01_JPRB,5.5112E+01_JPRB,5.9938E+01_JPRB,6.5023E+01_JPRB,7.0458E+01_JPRB/)
KAO( :, 2,10) = (/&
&4.6588E+01_JPRB,5.1661E+01_JPRB,5.6901E+01_JPRB,6.2463E+01_JPRB,6.8487E+01_JPRB/)
KAO( :, 3,10) = (/&
&4.1628E+01_JPRB,4.6699E+01_JPRB,5.2314E+01_JPRB,5.8353E+01_JPRB,6.4458E+01_JPRB/)
KAO( :, 4,10) = (/&
&3.7456E+01_JPRB,4.2469E+01_JPRB,4.7867E+01_JPRB,5.3384E+01_JPRB,5.9111E+01_JPRB/)
KAO( :, 5,10) = (/&
&3.3436E+01_JPRB,3.8793E+01_JPRB,4.3992E+01_JPRB,4.9077E+01_JPRB,5.4046E+01_JPRB/)
KAO( :, 6,10) = (/&
&2.8948E+01_JPRB,3.4066E+01_JPRB,3.9093E+01_JPRB,4.3943E+01_JPRB,4.8577E+01_JPRB/)
KAO( :, 7,10) = (/&
&2.4411E+01_JPRB,2.9169E+01_JPRB,3.3772E+01_JPRB,3.8328E+01_JPRB,4.2674E+01_JPRB/)
KAO( :, 8,10) = (/&
&2.0213E+01_JPRB,2.4379E+01_JPRB,2.8547E+01_JPRB,3.2632E+01_JPRB,3.6717E+01_JPRB/)
KAO( :, 9,10) = (/&
&1.6770E+01_JPRB,2.0275E+01_JPRB,2.3726E+01_JPRB,2.7289E+01_JPRB,3.1149E+01_JPRB/)
KAO( :,10,10) = (/&
&1.3740E+01_JPRB,1.6814E+01_JPRB,1.9874E+01_JPRB,2.3039E+01_JPRB,2.6529E+01_JPRB/)
KAO( :,11,10) = (/&
&1.2161E+01_JPRB,1.4820E+01_JPRB,1.7667E+01_JPRB,2.0767E+01_JPRB,2.3948E+01_JPRB/)
KAO( :,12,10) = (/&
&1.0666E+01_JPRB,1.3093E+01_JPRB,1.5727E+01_JPRB,1.8473E+01_JPRB,2.1195E+01_JPRB/)
KAO( :,13,10) = (/&
&9.3915E+00_JPRB,1.1557E+01_JPRB,1.3847E+01_JPRB,1.6172E+01_JPRB,1.8558E+01_JPRB/)
KAO( :, 1,11) = (/&
&7.2842E+01_JPRB,8.2127E+01_JPRB,9.1751E+01_JPRB,1.0081E+02_JPRB,1.0868E+02_JPRB/)
KAO( :, 2,11) = (/&
&7.0912E+01_JPRB,8.0211E+01_JPRB,8.9133E+01_JPRB,9.7767E+01_JPRB,1.0537E+02_JPRB/)
KAO( :, 3,11) = (/&
&6.7169E+01_JPRB,7.5895E+01_JPRB,8.3957E+01_JPRB,9.1467E+01_JPRB,9.8740E+01_JPRB/)
KAO( :, 4,11) = (/&
&6.1046E+01_JPRB,6.9086E+01_JPRB,7.7071E+01_JPRB,8.4625E+01_JPRB,9.2325E+01_JPRB/)
KAO( :, 5,11) = (/&
&5.4291E+01_JPRB,6.1624E+01_JPRB,6.9146E+01_JPRB,7.6916E+01_JPRB,8.5050E+01_JPRB/)
KAO( :, 6,11) = (/&
&4.7940E+01_JPRB,5.4754E+01_JPRB,6.1943E+01_JPRB,6.9739E+01_JPRB,7.7765E+01_JPRB/)
KAO( :, 7,11) = (/&
&4.1424E+01_JPRB,4.8323E+01_JPRB,5.5884E+01_JPRB,6.3434E+01_JPRB,7.1064E+01_JPRB/)
KAO( :, 8,11) = (/&
&3.4808E+01_JPRB,4.1718E+01_JPRB,4.9240E+01_JPRB,5.6728E+01_JPRB,6.4032E+01_JPRB/)
KAO( :, 9,11) = (/&
&2.8724E+01_JPRB,3.5333E+01_JPRB,4.2395E+01_JPRB,4.9372E+01_JPRB,5.6186E+01_JPRB/)
KAO( :,10,11) = (/&
&2.4060E+01_JPRB,2.9886E+01_JPRB,3.6171E+01_JPRB,4.2511E+01_JPRB,4.8855E+01_JPRB/)
KAO( :,11,11) = (/&
&2.2466E+01_JPRB,2.7842E+01_JPRB,3.3276E+01_JPRB,3.8707E+01_JPRB,4.4411E+01_JPRB/)
KAO( :,12,11) = (/&
&2.0635E+01_JPRB,2.5402E+01_JPRB,3.0130E+01_JPRB,3.5065E+01_JPRB,4.0456E+01_JPRB/)
KAO( :,13,11) = (/&
&1.8375E+01_JPRB,2.2528E+01_JPRB,2.6944E+01_JPRB,3.1721E+01_JPRB,3.6642E+01_JPRB/)
KAO( :, 1,12) = (/&
&1.2814E+02_JPRB,1.3938E+02_JPRB,1.4994E+02_JPRB,1.6150E+02_JPRB,1.7273E+02_JPRB/)
KAO( :, 2,12) = (/&
&1.2028E+02_JPRB,1.3171E+02_JPRB,1.4381E+02_JPRB,1.5628E+02_JPRB,1.6936E+02_JPRB/)
KAO( :, 3,12) = (/&
&1.0908E+02_JPRB,1.2221E+02_JPRB,1.3662E+02_JPRB,1.5108E+02_JPRB,1.6591E+02_JPRB/)
KAO( :, 4,12) = (/&
&9.9689E+01_JPRB,1.1393E+02_JPRB,1.2899E+02_JPRB,1.4446E+02_JPRB,1.5932E+02_JPRB/)
KAO( :, 5,12) = (/&
&9.1574E+01_JPRB,1.0647E+02_JPRB,1.2179E+02_JPRB,1.3681E+02_JPRB,1.5090E+02_JPRB/)
KAO( :, 6,12) = (/&
&8.3159E+01_JPRB,9.8372E+01_JPRB,1.1370E+02_JPRB,1.2787E+02_JPRB,1.4184E+02_JPRB/)
KAO( :, 7,12) = (/&
&7.5130E+01_JPRB,8.9279E+01_JPRB,1.0335E+02_JPRB,1.1696E+02_JPRB,1.3088E+02_JPRB/)
KAO( :, 8,12) = (/&
&6.6942E+01_JPRB,7.9719E+01_JPRB,9.2547E+01_JPRB,1.0530E+02_JPRB,1.1887E+02_JPRB/)
KAO( :, 9,12) = (/&
&5.7722E+01_JPRB,6.9837E+01_JPRB,8.2082E+01_JPRB,9.4593E+01_JPRB,1.0770E+02_JPRB/)
KAO( :,10,12) = (/&
&4.9040E+01_JPRB,6.0620E+01_JPRB,7.2577E+01_JPRB,8.5187E+01_JPRB,9.7844E+01_JPRB/)
KAO( :,11,12) = (/&
&4.5433E+01_JPRB,5.6352E+01_JPRB,6.8223E+01_JPRB,8.0499E+01_JPRB,9.2512E+01_JPRB/)
KAO( :,12,12) = (/&
&4.1971E+01_JPRB,5.2467E+01_JPRB,6.3533E+01_JPRB,7.4543E+01_JPRB,8.5084E+01_JPRB/)
KAO( :,13,12) = (/&
&3.9013E+01_JPRB,4.8568E+01_JPRB,5.8272E+01_JPRB,6.7741E+01_JPRB,7.7194E+01_JPRB/)
KAO( :, 1,13) = (/&
&2.2210E+02_JPRB,2.4767E+02_JPRB,2.7177E+02_JPRB,2.9506E+02_JPRB,3.1428E+02_JPRB/)
KAO( :, 2,13) = (/&
&2.2387E+02_JPRB,2.5269E+02_JPRB,2.7872E+02_JPRB,2.9937E+02_JPRB,3.1679E+02_JPRB/)
KAO( :, 3,13) = (/&
&2.1746E+02_JPRB,2.4620E+02_JPRB,2.7168E+02_JPRB,2.9352E+02_JPRB,3.1488E+02_JPRB/)
KAO( :, 4,13) = (/&
&2.0527E+02_JPRB,2.3513E+02_JPRB,2.5998E+02_JPRB,2.8303E+02_JPRB,3.0506E+02_JPRB/)
KAO( :, 5,13) = (/&
&1.8964E+02_JPRB,2.1890E+02_JPRB,2.4311E+02_JPRB,2.6810E+02_JPRB,2.9248E+02_JPRB/)
KAO( :, 6,13) = (/&
&1.7090E+02_JPRB,1.9758E+02_JPRB,2.2284E+02_JPRB,2.4839E+02_JPRB,2.7463E+02_JPRB/)
KAO( :, 7,13) = (/&
&1.5109E+02_JPRB,1.7710E+02_JPRB,2.0295E+02_JPRB,2.2932E+02_JPRB,2.5634E+02_JPRB/)
KAO( :, 8,13) = (/&
&1.3270E+02_JPRB,1.5826E+02_JPRB,1.8450E+02_JPRB,2.1121E+02_JPRB,2.3873E+02_JPRB/)
KAO( :, 9,13) = (/&
&1.1570E+02_JPRB,1.4021E+02_JPRB,1.6653E+02_JPRB,1.9389E+02_JPRB,2.2105E+02_JPRB/)
KAO( :,10,13) = (/&
&1.0259E+02_JPRB,1.2584E+02_JPRB,1.5091E+02_JPRB,1.7718E+02_JPRB,2.0281E+02_JPRB/)
KAO( :,11,13) = (/&
&1.0076E+02_JPRB,1.2370E+02_JPRB,1.4756E+02_JPRB,1.7147E+02_JPRB,1.9575E+02_JPRB/)
KAO( :,12,13) = (/&
&9.7325E+01_JPRB,1.1939E+02_JPRB,1.4174E+02_JPRB,1.6449E+02_JPRB,1.8836E+02_JPRB/)
KAO( :,13,13) = (/&
&9.2070E+01_JPRB,1.1299E+02_JPRB,1.3489E+02_JPRB,1.5734E+02_JPRB,1.8036E+02_JPRB/)
KAO( :, 1,14) = (/&
&4.2241E+02_JPRB,4.5820E+02_JPRB,4.8815E+02_JPRB,5.1730E+02_JPRB,5.4765E+02_JPRB/)
KAO( :, 2,14) = (/&
&4.2461E+02_JPRB,4.6681E+02_JPRB,4.9982E+02_JPRB,5.3726E+02_JPRB,5.6640E+02_JPRB/)
KAO( :, 3,14) = (/&
&4.1742E+02_JPRB,4.5924E+02_JPRB,4.9930E+02_JPRB,5.3630E+02_JPRB,5.8090E+02_JPRB/)
KAO( :, 4,14) = (/&
&3.9739E+02_JPRB,4.4336E+02_JPRB,4.8832E+02_JPRB,5.2886E+02_JPRB,5.8035E+02_JPRB/)
KAO( :, 5,14) = (/&
&3.7398E+02_JPRB,4.2048E+02_JPRB,4.7438E+02_JPRB,5.2486E+02_JPRB,5.7134E+02_JPRB/)
KAO( :, 6,14) = (/&
&3.4725E+02_JPRB,3.9940E+02_JPRB,4.5648E+02_JPRB,5.1230E+02_JPRB,5.6617E+02_JPRB/)
KAO( :, 7,14) = (/&
&3.2072E+02_JPRB,3.7728E+02_JPRB,4.3646E+02_JPRB,4.9362E+02_JPRB,5.5200E+02_JPRB/)
KAO( :, 8,14) = (/&
&2.9404E+02_JPRB,3.5487E+02_JPRB,4.1802E+02_JPRB,4.7825E+02_JPRB,5.4076E+02_JPRB/)
KAO( :, 9,14) = (/&
&2.7034E+02_JPRB,3.3232E+02_JPRB,3.9722E+02_JPRB,4.5997E+02_JPRB,5.2290E+02_JPRB/)
KAO( :,10,14) = (/&
&2.5045E+02_JPRB,3.1309E+02_JPRB,3.7582E+02_JPRB,4.4096E+02_JPRB,5.0588E+02_JPRB/)
KAO( :,11,14) = (/&
&2.5624E+02_JPRB,3.1911E+02_JPRB,3.8269E+02_JPRB,4.5034E+02_JPRB,5.1713E+02_JPRB/)
KAO( :,12,14) = (/&
&2.6046E+02_JPRB,3.2208E+02_JPRB,3.8851E+02_JPRB,4.5644E+02_JPRB,5.2468E+02_JPRB/)
KAO( :,13,14) = (/&
&2.6376E+02_JPRB,3.2552E+02_JPRB,3.9097E+02_JPRB,4.5804E+02_JPRB,5.2614E+02_JPRB/)
KAO( :, 1,15) = (/&
&8.5706E+02_JPRB,9.2142E+02_JPRB,9.6878E+02_JPRB,1.0281E+03_JPRB,1.0795E+03_JPRB/)
KAO( :, 2,15) = (/&
&9.5189E+02_JPRB,1.0335E+03_JPRB,1.0913E+03_JPRB,1.1632E+03_JPRB,1.2011E+03_JPRB/)
KAO( :, 3,15) = (/&
&1.0232E+03_JPRB,1.0861E+03_JPRB,1.1646E+03_JPRB,1.2285E+03_JPRB,1.3057E+03_JPRB/)
KAO( :, 4,15) = (/&
&1.0392E+03_JPRB,1.1356E+03_JPRB,1.2544E+03_JPRB,1.3115E+03_JPRB,1.4338E+03_JPRB/)
KAO( :, 5,15) = (/&
&1.0616E+03_JPRB,1.1713E+03_JPRB,1.3147E+03_JPRB,1.4146E+03_JPRB,1.4989E+03_JPRB/)
KAO( :, 6,15) = (/&
&1.0788E+03_JPRB,1.1886E+03_JPRB,1.3302E+03_JPRB,1.4680E+03_JPRB,1.5638E+03_JPRB/)
KAO( :, 7,15) = (/&
&1.0593E+03_JPRB,1.1909E+03_JPRB,1.3423E+03_JPRB,1.4840E+03_JPRB,1.6000E+03_JPRB/)
KAO( :, 8,15) = (/&
&9.9873E+02_JPRB,1.1655E+03_JPRB,1.3439E+03_JPRB,1.4887E+03_JPRB,1.6318E+03_JPRB/)
KAO( :, 9,15) = (/&
&9.4071E+02_JPRB,1.1173E+03_JPRB,1.3103E+03_JPRB,1.4801E+03_JPRB,1.6507E+03_JPRB/)
KAO( :,10,15) = (/&
&8.8647E+02_JPRB,1.0727E+03_JPRB,1.2703E+03_JPRB,1.4721E+03_JPRB,1.6711E+03_JPRB/)
KAO( :,11,15) = (/&
&9.2131E+02_JPRB,1.1303E+03_JPRB,1.3379E+03_JPRB,1.5675E+03_JPRB,1.7706E+03_JPRB/)
KAO( :,12,15) = (/&
&9.6245E+02_JPRB,1.1976E+03_JPRB,1.4205E+03_JPRB,1.6577E+03_JPRB,1.8724E+03_JPRB/)
KAO( :,13,15) = (/&
&1.0149E+03_JPRB,1.2514E+03_JPRB,1.4928E+03_JPRB,1.7376E+03_JPRB,1.9688E+03_JPRB/)
KAO( :, 1,16) = (/&
&1.1893E+03_JPRB,1.2688E+03_JPRB,1.3351E+03_JPRB,1.3959E+03_JPRB,1.4433E+03_JPRB/)
KAO( :, 2,16) = (/&
&1.4043E+03_JPRB,1.5015E+03_JPRB,1.5933E+03_JPRB,1.6702E+03_JPRB,1.7343E+03_JPRB/)
KAO( :, 3,16) = (/&
&1.6203E+03_JPRB,1.7272E+03_JPRB,1.8338E+03_JPRB,1.9414E+03_JPRB,2.0288E+03_JPRB/)
KAO( :, 4,16) = (/&
&1.7997E+03_JPRB,1.9426E+03_JPRB,2.1186E+03_JPRB,2.2171E+03_JPRB,2.3429E+03_JPRB/)
KAO( :, 5,16) = (/&
&1.9840E+03_JPRB,2.1906E+03_JPRB,2.3875E+03_JPRB,2.5360E+03_JPRB,2.6578E+03_JPRB/)
KAO( :, 6,16) = (/&
&2.1706E+03_JPRB,2.4031E+03_JPRB,2.6185E+03_JPRB,2.8410E+03_JPRB,2.9858E+03_JPRB/)
KAO( :, 7,16) = (/&
&2.3367E+03_JPRB,2.6044E+03_JPRB,2.8764E+03_JPRB,3.1365E+03_JPRB,3.3254E+03_JPRB/)
KAO( :, 8,16) = (/&
&2.4353E+03_JPRB,2.7922E+03_JPRB,3.1601E+03_JPRB,3.4455E+03_JPRB,3.6918E+03_JPRB/)
KAO( :, 9,16) = (/&
&2.5375E+03_JPRB,2.9571E+03_JPRB,3.4043E+03_JPRB,3.7567E+03_JPRB,4.0876E+03_JPRB/)
KAO( :,10,16) = (/&
&2.6751E+03_JPRB,3.1240E+03_JPRB,3.6015E+03_JPRB,4.0631E+03_JPRB,4.4658E+03_JPRB/)
KAO( :,11,16) = (/&
&3.0220E+03_JPRB,3.5297E+03_JPRB,4.0306E+03_JPRB,4.6185E+03_JPRB,5.0516E+03_JPRB/)
KAO( :,12,16) = (/&
&3.3138E+03_JPRB,4.0094E+03_JPRB,4.5368E+03_JPRB,5.2030E+03_JPRB,5.7257E+03_JPRB/)
KAO( :,13,16) = (/&
&3.6770E+03_JPRB,4.3534E+03_JPRB,5.0748E+03_JPRB,5.8067E+03_JPRB,6.4888E+03_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&7.54232E-01_JPRB, 6.87231E-01_JPRB, 6.26181E-01_JPRB, 5.70555E-01_JPRB, 5.19870E-01_JPRB,&
&4.73688E-01_JPRB, 4.31608E-01_JPRB, 3.93266E-01_JPRB, 3.58331E-01_JPRB, 3.26499E-01_JPRB/)
SELFREFO( :, 2) = (/&
&1.01377E+00_JPRB, 9.30266E-01_JPRB, 8.53637E-01_JPRB, 7.83320E-01_JPRB, 7.18796E-01_JPRB,&
&6.59587E-01_JPRB, 6.05254E-01_JPRB, 5.55398E-01_JPRB, 5.09648E-01_JPRB, 4.67667E-01_JPRB/)
SELFREFO( :, 3) = (/&
&1.31954E+00_JPRB, 1.22523E+00_JPRB, 1.13766E+00_JPRB, 1.05635E+00_JPRB, 9.80853E-01_JPRB,&
&9.10749E-01_JPRB, 8.45656E-01_JPRB, 7.85215E-01_JPRB, 7.29095E-01_JPRB, 6.76985E-01_JPRB/)
SELFREFO( :, 4) = (/&
&2.18726E+00_JPRB, 2.05960E+00_JPRB, 1.93940E+00_JPRB, 1.82621E+00_JPRB, 1.71962E+00_JPRB,&
&1.61926E+00_JPRB, 1.52476E+00_JPRB, 1.43577E+00_JPRB, 1.35197E+00_JPRB, 1.27306E+00_JPRB/)
SELFREFO( :, 5) = (/&
&3.17440E+00_JPRB, 2.92794E+00_JPRB, 2.70061E+00_JPRB, 2.49094E+00_JPRB, 2.29754E+00_JPRB,&
&2.11916E+00_JPRB, 1.95463E+00_JPRB, 1.80287E+00_JPRB, 1.66290E+00_JPRB, 1.53379E+00_JPRB/)
SELFREFO( :, 6) = (/&
&2.69705E+00_JPRB, 2.48684E+00_JPRB, 2.29302E+00_JPRB, 2.11431E+00_JPRB, 1.94952E+00_JPRB,&
&1.79758E+00_JPRB, 1.65748E+00_JPRB, 1.52830E+00_JPRB, 1.40919E+00_JPRB, 1.29936E+00_JPRB/)
SELFREFO( :, 7) = (/&
&2.91893E+00_JPRB, 2.68371E+00_JPRB, 2.46745E+00_JPRB, 2.26862E+00_JPRB, 2.08581E+00_JPRB,&
&1.91773E+00_JPRB, 1.76319E+00_JPRB, 1.62111E+00_JPRB, 1.49048E+00_JPRB, 1.37037E+00_JPRB/)
SELFREFO( :, 8) = (/&
&2.91847E+00_JPRB, 2.69138E+00_JPRB, 2.48195E+00_JPRB, 2.28883E+00_JPRB, 2.11073E+00_JPRB,&
&1.94648E+00_JPRB, 1.79502E+00_JPRB, 1.65535E+00_JPRB, 1.52654E+00_JPRB, 1.40776E+00_JPRB/)
SELFREFO( :, 9) = (/&
&2.73994E+00_JPRB, 2.54834E+00_JPRB, 2.37014E+00_JPRB, 2.20440E+00_JPRB, 2.05026E+00_JPRB,&
&1.90689E+00_JPRB, 1.77354E+00_JPRB, 1.64952E+00_JPRB, 1.53418E+00_JPRB, 1.42690E+00_JPRB/)
SELFREFO( :,10) = (/&
&2.81902E+00_JPRB, 2.66010E+00_JPRB, 2.51014E+00_JPRB, 2.36863E+00_JPRB, 2.23510E+00_JPRB,&
&2.10909E+00_JPRB, 1.99020E+00_JPRB, 1.87800E+00_JPRB, 1.77213E+00_JPRB, 1.67222E+00_JPRB/)
SELFREFO( :,11) = (/&
&3.19430E+00_JPRB, 2.97671E+00_JPRB, 2.77395E+00_JPRB, 2.58500E+00_JPRB, 2.40891E+00_JPRB,&
&2.24483E+00_JPRB, 2.09192E+00_JPRB, 1.94942E+00_JPRB, 1.81663E+00_JPRB, 1.69289E+00_JPRB/)
SELFREFO( :,12) = (/&
&3.24778E+00_JPRB, 3.04535E+00_JPRB, 2.85553E+00_JPRB, 2.67755E+00_JPRB, 2.51066E+00_JPRB,&
&2.35417E+00_JPRB, 2.20744E+00_JPRB, 2.06985E+00_JPRB, 1.94084E+00_JPRB, 1.81987E+00_JPRB/)
SELFREFO( :,13) = (/&
&3.67142E+00_JPRB, 3.39875E+00_JPRB, 3.14634E+00_JPRB, 2.91267E+00_JPRB, 2.69636E+00_JPRB,&
&2.49611E+00_JPRB, 2.31073E+00_JPRB, 2.13913E+00_JPRB, 1.98026E+00_JPRB, 1.83319E+00_JPRB/)
SELFREFO( :,14) = (/&
&3.73679E+00_JPRB, 3.49113E+00_JPRB, 3.26162E+00_JPRB, 3.04719E+00_JPRB, 2.84686E+00_JPRB,&
&2.65970E+00_JPRB, 2.48485E+00_JPRB, 2.32149E+00_JPRB, 2.16887E+00_JPRB, 2.02628E+00_JPRB/)
SELFREFO( :,15) = (/&
&4.25684E+00_JPRB, 3.95885E+00_JPRB, 3.68171E+00_JPRB, 3.42397E+00_JPRB, 3.18428E+00_JPRB,&
&2.96137E+00_JPRB, 2.75406E+00_JPRB, 2.56126E+00_JPRB, 2.38196E+00_JPRB, 2.21521E+00_JPRB/)
SELFREFO( :,16) = (/&
&4.97048E+00_JPRB, 4.59255E+00_JPRB, 4.24336E+00_JPRB, 3.92072E+00_JPRB, 3.62261E+00_JPRB,&
&3.34717E+00_JPRB, 3.09267E+00_JPRB, 2.85752E+00_JPRB, 2.64025E+00_JPRB, 2.43950E+00_JPRB/)

!     The ith set of reference fractions are from the ith reference
!     pressure level.
FRACREFAO( :, 1) = (/&
    &0.18068060_JPRB,0.16803175_JPRB,0.15140158_JPRB,0.12221480_JPRB,&
    &0.10240850_JPRB,0.09330297_JPRB,0.07518960_JPRB,0.05611294_JPRB,&
    &0.03781487_JPRB,0.00387192_JPRB,0.00321285_JPRB,0.00244440_JPRB,&
    &0.00179546_JPRB,0.00107704_JPRB,0.00038798_JPRB,0.00005060_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.17927621_JPRB,0.16731168_JPRB,0.15129538_JPRB,0.12328085_JPRB,&
    &0.10243484_JPRB,0.09354796_JPRB,0.07538418_JPRB,0.05633071_JPRB,&
    &0.03810832_JPRB,0.00398347_JPRB,0.00320262_JPRB,0.00250029_JPRB,&
    &0.00178666_JPRB,0.00111127_JPRB,0.00039438_JPRB,0.00005169_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.17762886_JPRB,0.16638555_JPRB,0.15115446_JPRB,0.12470623_JPRB,&
    &0.10253213_JPRB,0.09383459_JPRB,0.07560240_JPRB,0.05646568_JPRB,&
    &0.03844077_JPRB,0.00409142_JPRB,0.00322521_JPRB,0.00254918_JPRB,&
    &0.00179296_JPRB,0.00113652_JPRB,0.00040169_JPRB,0.00005259_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.17566043_JPRB,0.16539773_JPRB,0.15092199_JPRB,0.12571971_JPRB,&
    &0.10340609_JPRB,0.09426189_JPRB,0.07559051_JPRB,0.05678188_JPRB,&
    &0.03881499_JPRB,0.00414102_JPRB,0.00328551_JPRB,0.00258795_JPRB,&
    &0.00181648_JPRB,0.00115145_JPRB,0.00040969_JPRB,0.00005357_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.17335825_JPRB,0.16442548_JPRB,0.15070701_JPRB,0.12667464_JPRB,&
    &0.10452303_JPRB,0.09450833_JPRB,0.07599410_JPRB,0.05706393_JPRB,&
    &0.03910370_JPRB,0.00417880_JPRB,0.00335256_JPRB,0.00261708_JPRB,&
    &0.00185491_JPRB,0.00116627_JPRB,0.00041759_JPRB,0.00005464_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.17082544_JPRB,0.16321516_JPRB,0.15044247_JPRB,0.12797612_JPRB,&
    &0.10574646_JPRB,0.09470057_JPRB,0.07647423_JPRB,0.05738756_JPRB,&
    &0.03935621_JPRB,0.00423789_JPRB,0.00342651_JPRB,0.00264549_JPRB,&
    &0.00190188_JPRB,0.00118281_JPRB,0.00042592_JPRB,0.00005583_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.16809277_JPRB,0.16193336_JPRB,0.15013184_JPRB,0.12937409_JPRB,&
    &0.10720784_JPRB,0.09485368_JPRB,0.07692636_JPRB,0.05771774_JPRB,&
    &0.03966988_JPRB,0.00427754_JPRB,0.00349696_JPRB,0.00268946_JPRB,&
    &0.00193536_JPRB,0.00120222_JPRB,0.00043462_JPRB,0.00005712_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.16517997_JPRB,0.16059248_JPRB,0.14984852_JPRB,0.13079269_JPRB,&
    &0.10865030_JPRB,0.09492947_JPRB,0.07759736_JPRB,0.05812201_JPRB,&
    &0.03997169_JPRB,0.00432356_JPRB,0.00355308_JPRB,0.00274031_JPRB,&
    &0.00197243_JPRB,0.00122401_JPRB,0.00044359_JPRB,0.00005849_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.16209179_JPRB,0.15912023_JPRB,0.14938223_JPRB,0.13198245_JPRB,&
    &0.11077233_JPRB,0.09487948_JPRB,0.07831636_JPRB,0.05863440_JPRB,&
    &0.04028239_JPRB,0.00436804_JPRB,0.00360407_JPRB,0.00279885_JPRB,&
    &0.00200364_JPRB,0.00124861_JPRB,0.00045521_JPRB,0.00005996_JPRB/)
FRACREFAO( :,10) = (/&
    &0.15962425_JPRB,0.15789343_JPRB,0.14898103_JPRB,0.13275230_JPRB,&
    &0.11253940_JPRB,0.09503502_JPRB,0.07884382_JPRB,0.05908009_JPRB,&
    &0.04053524_JPRB,0.00439971_JPRB,0.00364269_JPRB,0.00284965_JPRB,&
    &0.00202758_JPRB,0.00127076_JPRB,0.00046408_JPRB,0.00006114_JPRB/)
FRACREFAO( :,11) = (/&
    &0.15926200_JPRB,0.15770932_JPRB,0.14891729_JPRB,0.13283882_JPRB,&
    &0.11276010_JPRB,0.09507311_JPRB,0.07892222_JPRB,0.05919230_JPRB,&
    &0.04054824_JPRB,0.00440833_JPRB,0.00365575_JPRB,0.00286459_JPRB,&
    &0.00203786_JPRB,0.00128405_JPRB,0.00046504_JPRB,0.00006146_JPRB/)
FRACREFAO( :,12) = (/&
    &0.15926351_JPRB,0.15770483_JPRB,0.14891177_JPRB,0.13279966_JPRB,&
    &0.11268171_JPRB,0.09515216_JPRB,0.07890341_JPRB,0.05924807_JPRB,&
    &0.04052851_JPRB,0.00440870_JPRB,0.00365425_JPRB,0.00286878_JPRB,&
    &0.00205747_JPRB,0.00128916_JPRB,0.00046589_JPRB,0.00006221_JPRB/)
FRACREFAO( :,13) = (/&
    &0.15937765_JPRB,0.15775780_JPRB,0.14892603_JPRB,0.13273248_JPRB,&
    &0.11252731_JPRB,0.09521657_JPRB,0.07885858_JPRB,0.05927679_JPRB,&
    &0.04050184_JPRB,0.00440285_JPRB,0.00365748_JPRB,0.00286791_JPRB,&
    &0.00207507_JPRB,0.00129193_JPRB,0.00046679_JPRB,0.00006308_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB2_01
