!OCL SCALAR
SUBROUTINE RRTM_KGB16_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 16:  2600-3000 cm-1 (low - H2O,CH4; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO16, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA16, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.9384E-05_JPRB,2.9898E-05_JPRB,3.4062E-05_JPRB,3.6004E-05_JPRB,3.6430E-05_JPRB,3.5549E-05_JPRB,&
&3.3320E-05_JPRB,2.9615E-05_JPRB,2.3873E-05_JPRB/)
KAO( :, 2, 1, 1) = (/&
&1.9436E-05_JPRB,2.9740E-05_JPRB,3.3708E-05_JPRB,3.5476E-05_JPRB,3.5843E-05_JPRB,3.5033E-05_JPRB,&
&3.2962E-05_JPRB,2.9462E-05_JPRB,2.4055E-05_JPRB/)
KAO( :, 3, 1, 1) = (/&
&1.9464E-05_JPRB,2.9570E-05_JPRB,3.3324E-05_JPRB,3.4974E-05_JPRB,3.5304E-05_JPRB,3.4544E-05_JPRB,&
&3.2637E-05_JPRB,2.9289E-05_JPRB,2.4237E-05_JPRB/)
KAO( :, 4, 1, 1) = (/&
&1.9302E-05_JPRB,2.9247E-05_JPRB,3.2832E-05_JPRB,3.4416E-05_JPRB,3.4737E-05_JPRB,3.4031E-05_JPRB,&
&3.2272E-05_JPRB,2.9080E-05_JPRB,2.4364E-05_JPRB/)
KAO( :, 5, 1, 1) = (/&
&1.9123E-05_JPRB,2.8885E-05_JPRB,3.2360E-05_JPRB,3.3877E-05_JPRB,3.4211E-05_JPRB,3.3554E-05_JPRB,&
&3.1880E-05_JPRB,2.8883E-05_JPRB,2.4458E-05_JPRB/)
KAO( :, 1, 2, 1) = (/&
&1.6583E-05_JPRB,2.6012E-05_JPRB,2.9608E-05_JPRB,3.1154E-05_JPRB,3.1427E-05_JPRB,3.0616E-05_JPRB,&
&2.8665E-05_JPRB,2.5368E-05_JPRB,2.0615E-05_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.6630E-05_JPRB,2.5863E-05_JPRB,2.9249E-05_JPRB,3.0678E-05_JPRB,3.0941E-05_JPRB,3.0197E-05_JPRB,&
&2.8392E-05_JPRB,2.5270E-05_JPRB,2.0786E-05_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.6647E-05_JPRB,2.5697E-05_JPRB,2.8891E-05_JPRB,3.0222E-05_JPRB,3.0484E-05_JPRB,2.9802E-05_JPRB,&
&2.8138E-05_JPRB,2.5165E-05_JPRB,2.0933E-05_JPRB/)
KAO( :, 4, 2, 1) = (/&
&1.6540E-05_JPRB,2.5405E-05_JPRB,2.8466E-05_JPRB,2.9745E-05_JPRB,3.0011E-05_JPRB,2.9400E-05_JPRB,&
&2.7847E-05_JPRB,2.5027E-05_JPRB,2.1051E-05_JPRB/)
KAO( :, 5, 2, 1) = (/&
&1.6324E-05_JPRB,2.5032E-05_JPRB,2.7991E-05_JPRB,2.9251E-05_JPRB,2.9530E-05_JPRB,2.8984E-05_JPRB,&
&2.7519E-05_JPRB,2.4864E-05_JPRB,2.1134E-05_JPRB/)
KAO( :, 1, 3, 1) = (/&
&1.4086E-05_JPRB,2.2526E-05_JPRB,2.5577E-05_JPRB,2.6862E-05_JPRB,2.7021E-05_JPRB,2.6302E-05_JPRB,&
&2.4576E-05_JPRB,2.1643E-05_JPRB,1.8751E-05_JPRB/)
KAO( :, 2, 3, 1) = (/&
&1.4131E-05_JPRB,2.2392E-05_JPRB,2.5264E-05_JPRB,2.6452E-05_JPRB,2.6617E-05_JPRB,2.5964E-05_JPRB,&
&2.4370E-05_JPRB,2.1595E-05_JPRB,1.8898E-05_JPRB/)
KAO( :, 3, 3, 1) = (/&
&1.4113E-05_JPRB,2.2191E-05_JPRB,2.4900E-05_JPRB,2.6018E-05_JPRB,2.6215E-05_JPRB,2.5621E-05_JPRB,&
&2.4158E-05_JPRB,2.1540E-05_JPRB,1.9048E-05_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.4058E-05_JPRB,2.1961E-05_JPRB,2.4548E-05_JPRB,2.5623E-05_JPRB,2.5838E-05_JPRB,2.5312E-05_JPRB,&
&2.3952E-05_JPRB,2.1469E-05_JPRB,1.9182E-05_JPRB/)
KAO( :, 5, 3, 1) = (/&
&1.3863E-05_JPRB,2.1619E-05_JPRB,2.4113E-05_JPRB,2.5184E-05_JPRB,2.5419E-05_JPRB,2.4957E-05_JPRB,&
&2.3697E-05_JPRB,2.1357E-05_JPRB,1.9265E-05_JPRB/)
KAO( :, 1, 4, 1) = (/&
&1.1900E-05_JPRB,1.9396E-05_JPRB,2.1993E-05_JPRB,2.3049E-05_JPRB,2.3163E-05_JPRB,2.2508E-05_JPRB,&
&2.0982E-05_JPRB,1.8407E-05_JPRB,1.7094E-05_JPRB/)
KAO( :, 2, 4, 1) = (/&
&1.1936E-05_JPRB,1.9289E-05_JPRB,2.1740E-05_JPRB,2.2712E-05_JPRB,2.2827E-05_JPRB,2.2234E-05_JPRB,&
&2.0833E-05_JPRB,1.8390E-05_JPRB,1.7367E-05_JPRB/)
KAO( :, 3, 4, 1) = (/&
&1.1914E-05_JPRB,1.9113E-05_JPRB,2.1420E-05_JPRB,2.2348E-05_JPRB,2.2488E-05_JPRB,2.1958E-05_JPRB,&
&2.0668E-05_JPRB,1.8368E-05_JPRB,1.7624E-05_JPRB/)
KAO( :, 4, 4, 1) = (/&
&1.1850E-05_JPRB,1.8882E-05_JPRB,2.1069E-05_JPRB,2.1971E-05_JPRB,2.2145E-05_JPRB,2.1684E-05_JPRB,&
&2.0493E-05_JPRB,1.8332E-05_JPRB,1.7862E-05_JPRB/)
KAO( :, 5, 4, 1) = (/&
&1.1744E-05_JPRB,1.8626E-05_JPRB,2.0733E-05_JPRB,2.1634E-05_JPRB,2.1819E-05_JPRB,2.1414E-05_JPRB,&
&2.0321E-05_JPRB,1.8279E-05_JPRB,1.8065E-05_JPRB/)
KAO( :, 1, 5, 1) = (/&
&1.0007E-05_JPRB,1.6633E-05_JPRB,1.8846E-05_JPRB,1.9714E-05_JPRB,1.9792E-05_JPRB,1.9192E-05_JPRB,&
&1.7849E-05_JPRB,1.5620E-05_JPRB,1.4831E-05_JPRB/)
KAO( :, 2, 5, 1) = (/&
&1.0036E-05_JPRB,1.6537E-05_JPRB,1.8619E-05_JPRB,1.9430E-05_JPRB,1.9510E-05_JPRB,1.8974E-05_JPRB,&
&1.7727E-05_JPRB,1.5597E-05_JPRB,1.5243E-05_JPRB/)
KAO( :, 3, 5, 1) = (/&
&1.0020E-05_JPRB,1.6382E-05_JPRB,1.8357E-05_JPRB,1.9125E-05_JPRB,1.9225E-05_JPRB,1.8747E-05_JPRB,&
&1.7610E-05_JPRB,1.5596E-05_JPRB,1.5694E-05_JPRB/)
KAO( :, 4, 5, 1) = (/&
&9.9655E-06_JPRB,1.6185E-05_JPRB,1.8047E-05_JPRB,1.8806E-05_JPRB,1.8930E-05_JPRB,1.8511E-05_JPRB,&
&1.7475E-05_JPRB,1.5592E-05_JPRB,1.6134E-05_JPRB/)
KAO( :, 5, 5, 1) = (/&
&9.8924E-06_JPRB,1.5961E-05_JPRB,1.7750E-05_JPRB,1.8511E-05_JPRB,1.8653E-05_JPRB,1.8287E-05_JPRB,&
&1.7340E-05_JPRB,1.5571E-05_JPRB,1.6528E-05_JPRB/)
KAO( :, 1, 6, 1) = (/&
&8.3773E-06_JPRB,1.4205E-05_JPRB,1.6091E-05_JPRB,1.6810E-05_JPRB,1.6854E-05_JPRB,1.6312E-05_JPRB,&
&1.5134E-05_JPRB,1.3227E-05_JPRB,1.2806E-05_JPRB/)
KAO( :, 2, 6, 1) = (/&
&8.4040E-06_JPRB,1.4116E-05_JPRB,1.5890E-05_JPRB,1.6565E-05_JPRB,1.6618E-05_JPRB,1.6134E-05_JPRB,&
&1.5030E-05_JPRB,1.3175E-05_JPRB,1.3188E-05_JPRB/)
KAO( :, 3, 6, 1) = (/&
&8.3967E-06_JPRB,1.3982E-05_JPRB,1.5670E-05_JPRB,1.6315E-05_JPRB,1.6378E-05_JPRB,1.5948E-05_JPRB,&
&1.4938E-05_JPRB,1.3181E-05_JPRB,1.3640E-05_JPRB/)
KAO( :, 4, 6, 1) = (/&
&8.3520E-06_JPRB,1.3808E-05_JPRB,1.5410E-05_JPRB,1.6041E-05_JPRB,1.6129E-05_JPRB,1.5748E-05_JPRB,&
&1.4840E-05_JPRB,1.3187E-05_JPRB,1.4105E-05_JPRB/)
KAO( :, 5, 6, 1) = (/&
&8.2808E-06_JPRB,1.3600E-05_JPRB,1.5125E-05_JPRB,1.5766E-05_JPRB,1.5873E-05_JPRB,1.5546E-05_JPRB,&
&1.4725E-05_JPRB,1.3184E-05_JPRB,1.4585E-05_JPRB/)
KAO( :, 1, 7, 1) = (/&
&6.9702E-06_JPRB,1.2049E-05_JPRB,1.3655E-05_JPRB,1.4254E-05_JPRB,1.4272E-05_JPRB,1.3786E-05_JPRB,&
&1.2775E-05_JPRB,1.1193E-05_JPRB,1.1151E-05_JPRB/)
KAO( :, 2, 7, 1) = (/&
&6.9954E-06_JPRB,1.1967E-05_JPRB,1.3478E-05_JPRB,1.4043E-05_JPRB,1.4073E-05_JPRB,1.3643E-05_JPRB,&
&1.2677E-05_JPRB,1.1085E-05_JPRB,1.1514E-05_JPRB/)
KAO( :, 3, 7, 1) = (/&
&6.9926E-06_JPRB,1.1851E-05_JPRB,1.3284E-05_JPRB,1.3826E-05_JPRB,1.3871E-05_JPRB,1.3488E-05_JPRB,&
&1.2600E-05_JPRB,1.1081E-05_JPRB,1.1911E-05_JPRB/)
KAO( :, 4, 7, 1) = (/&
&6.9597E-06_JPRB,1.1700E-05_JPRB,1.3068E-05_JPRB,1.3600E-05_JPRB,1.3659E-05_JPRB,1.3321E-05_JPRB,&
&1.2522E-05_JPRB,1.1091E-05_JPRB,1.2356E-05_JPRB/)
KAO( :, 5, 7, 1) = (/&
&6.9051E-06_JPRB,1.1522E-05_JPRB,1.2825E-05_JPRB,1.3359E-05_JPRB,1.3444E-05_JPRB,1.3151E-05_JPRB,&
&1.2435E-05_JPRB,1.1100E-05_JPRB,1.2847E-05_JPRB/)
KAO( :, 1, 8, 1) = (/&
&5.8087E-06_JPRB,1.0208E-05_JPRB,1.1579E-05_JPRB,1.2087E-05_JPRB,1.2081E-05_JPRB,1.1640E-05_JPRB,&
&1.0763E-05_JPRB,9.5182E-06_JPRB,9.7914E-06_JPRB/)
KAO( :, 2, 8, 1) = (/&
&5.8314E-06_JPRB,1.0134E-05_JPRB,1.1429E-05_JPRB,1.1911E-05_JPRB,1.1918E-05_JPRB,1.1522E-05_JPRB,&
&1.0685E-05_JPRB,9.3144E-06_JPRB,1.0107E-05_JPRB/)
KAO( :, 3, 8, 1) = (/&
&5.8306E-06_JPRB,1.0039E-05_JPRB,1.1263E-05_JPRB,1.1721E-05_JPRB,1.1741E-05_JPRB,1.1392E-05_JPRB,&
&1.0611E-05_JPRB,9.2970E-06_JPRB,1.0491E-05_JPRB/)
KAO( :, 4, 8, 1) = (/&
&5.8084E-06_JPRB,9.9094E-06_JPRB,1.1082E-05_JPRB,1.1528E-05_JPRB,1.1564E-05_JPRB,1.1253E-05_JPRB,&
&1.0543E-05_JPRB,9.3028E-06_JPRB,1.0943E-05_JPRB/)
KAO( :, 5, 8, 1) = (/&
&5.7671E-06_JPRB,9.7597E-06_JPRB,1.0878E-05_JPRB,1.1322E-05_JPRB,1.1380E-05_JPRB,1.1112E-05_JPRB,&
&1.0475E-05_JPRB,9.3153E-06_JPRB,1.1451E-05_JPRB/)
KAO( :, 1, 9, 1) = (/&
&4.8301E-06_JPRB,8.6067E-06_JPRB,9.7714E-06_JPRB,1.0210E-05_JPRB,1.0192E-05_JPRB,9.7977E-06_JPRB,&
&9.0505E-06_JPRB,8.2004E-06_JPRB,9.1168E-06_JPRB/)
KAO( :, 2, 9, 1) = (/&
&4.8495E-06_JPRB,8.5468E-06_JPRB,9.6571E-06_JPRB,1.0063E-05_JPRB,1.0051E-05_JPRB,9.6903E-06_JPRB,&
&8.9660E-06_JPRB,7.8251E-06_JPRB,9.4876E-06_JPRB/)
KAO( :, 3, 9, 1) = (/&
&4.8497E-06_JPRB,8.4643E-06_JPRB,9.5144E-06_JPRB,9.9014E-06_JPRB,9.9028E-06_JPRB,9.5821E-06_JPRB,&
&8.9043E-06_JPRB,7.7718E-06_JPRB,9.9373E-06_JPRB/)
KAO( :, 4, 9, 1) = (/&
&4.8347E-06_JPRB,8.3597E-06_JPRB,9.3601E-06_JPRB,9.7348E-06_JPRB,9.7523E-06_JPRB,9.4691E-06_JPRB,&
&8.8479E-06_JPRB,7.7751E-06_JPRB,1.0480E-05_JPRB/)
KAO( :, 5, 9, 1) = (/&
&4.8060E-06_JPRB,8.2344E-06_JPRB,9.1913E-06_JPRB,9.5624E-06_JPRB,9.5965E-06_JPRB,9.3522E-06_JPRB,&
&8.7881E-06_JPRB,7.7833E-06_JPRB,1.1108E-05_JPRB/)
KAO( :, 1,10, 1) = (/&
&4.0064E-06_JPRB,7.2194E-06_JPRB,8.1998E-06_JPRB,8.5791E-06_JPRB,8.5570E-06_JPRB,8.2127E-06_JPRB,&
&7.5956E-06_JPRB,7.1868E-06_JPRB,1.0453E-05_JPRB/)
KAO( :, 2,10, 1) = (/&
&4.0197E-06_JPRB,7.1679E-06_JPRB,8.1105E-06_JPRB,8.4531E-06_JPRB,8.4331E-06_JPRB,8.1149E-06_JPRB,&
&7.4918E-06_JPRB,6.5776E-06_JPRB,1.0520E-05_JPRB/)
KAO( :, 3,10, 1) = (/&
&4.0198E-06_JPRB,7.0974E-06_JPRB,7.9934E-06_JPRB,8.3195E-06_JPRB,8.3088E-06_JPRB,8.0216E-06_JPRB,&
&7.4367E-06_JPRB,6.4788E-06_JPRB,1.0711E-05_JPRB/)
KAO( :, 4,10, 1) = (/&
&4.0097E-06_JPRB,7.0130E-06_JPRB,7.8610E-06_JPRB,8.1737E-06_JPRB,8.1778E-06_JPRB,7.9289E-06_JPRB,&
&7.3886E-06_JPRB,6.4723E-06_JPRB,1.1047E-05_JPRB/)
KAO( :, 5,10, 1) = (/&
&3.9884E-06_JPRB,6.9092E-06_JPRB,7.7198E-06_JPRB,8.0283E-06_JPRB,8.0487E-06_JPRB,7.8282E-06_JPRB,&
&7.3394E-06_JPRB,6.4785E-06_JPRB,1.1524E-05_JPRB/)
KAO( :, 1,11, 1) = (/&
&3.3235E-06_JPRB,6.0184E-06_JPRB,6.8284E-06_JPRB,7.1399E-06_JPRB,7.1176E-06_JPRB,6.8268E-06_JPRB,&
&6.3069E-06_JPRB,5.9015E-06_JPRB,1.0775E-05_JPRB/)
KAO( :, 2,11, 1) = (/&
&3.3290E-06_JPRB,5.9691E-06_JPRB,6.7492E-06_JPRB,7.0301E-06_JPRB,7.0090E-06_JPRB,6.7423E-06_JPRB,&
&6.2217E-06_JPRB,5.4471E-06_JPRB,1.0671E-05_JPRB/)
KAO( :, 3,11, 1) = (/&
&3.3251E-06_JPRB,5.9052E-06_JPRB,6.6470E-06_JPRB,6.9153E-06_JPRB,6.9027E-06_JPRB,6.6631E-06_JPRB,&
&6.1768E-06_JPRB,5.3794E-06_JPRB,1.0714E-05_JPRB/)
KAO( :, 4,11, 1) = (/&
&3.3144E-06_JPRB,5.8297E-06_JPRB,6.5309E-06_JPRB,6.7910E-06_JPRB,6.7926E-06_JPRB,6.5831E-06_JPRB,&
&6.1358E-06_JPRB,5.3736E-06_JPRB,1.0902E-05_JPRB/)
KAO( :, 5,11, 1) = (/&
&3.2953E-06_JPRB,5.7419E-06_JPRB,6.4131E-06_JPRB,6.6688E-06_JPRB,6.6812E-06_JPRB,6.4951E-06_JPRB,&
&6.0888E-06_JPRB,5.3759E-06_JPRB,1.1211E-05_JPRB/)
KAO( :, 1,12, 1) = (/&
&2.7539E-06_JPRB,5.0055E-06_JPRB,5.6748E-06_JPRB,5.9323E-06_JPRB,5.9106E-06_JPRB,5.6659E-06_JPRB,&
&5.2301E-06_JPRB,4.8410E-06_JPRB,1.0041E-05_JPRB/)
KAO( :, 2,12, 1) = (/&
&2.7540E-06_JPRB,4.9609E-06_JPRB,5.6055E-06_JPRB,5.8388E-06_JPRB,5.8173E-06_JPRB,5.5933E-06_JPRB,&
&5.1585E-06_JPRB,4.5035E-06_JPRB,9.8783E-06_JPRB/)
KAO( :, 3,12, 1) = (/&
&2.7488E-06_JPRB,4.9048E-06_JPRB,5.5190E-06_JPRB,5.7407E-06_JPRB,5.7275E-06_JPRB,5.5257E-06_JPRB,&
&5.1201E-06_JPRB,4.4556E-06_JPRB,9.8584E-06_JPRB/)
KAO( :, 4,12, 1) = (/&
&2.7385E-06_JPRB,4.8395E-06_JPRB,5.4207E-06_JPRB,5.6356E-06_JPRB,5.6337E-06_JPRB,5.4559E-06_JPRB,&
&5.0826E-06_JPRB,4.4482E-06_JPRB,9.9631E-06_JPRB/)
KAO( :, 5,12, 1) = (/&
&2.7214E-06_JPRB,4.7654E-06_JPRB,5.3225E-06_JPRB,5.5318E-06_JPRB,5.5373E-06_JPRB,5.3782E-06_JPRB,&
&5.0386E-06_JPRB,4.4476E-06_JPRB,1.0178E-05_JPRB/)
KAO( :, 1,13, 1) = (/&
&2.2801E-06_JPRB,4.1555E-06_JPRB,4.7093E-06_JPRB,4.9224E-06_JPRB,4.9034E-06_JPRB,4.6982E-06_JPRB,&
&4.3297E-06_JPRB,3.9733E-06_JPRB,8.4129E-06_JPRB/)
KAO( :, 2,13, 1) = (/&
&2.2770E-06_JPRB,4.1173E-06_JPRB,4.6509E-06_JPRB,4.8443E-06_JPRB,4.8245E-06_JPRB,4.6351E-06_JPRB,&
&4.2708E-06_JPRB,3.7196E-06_JPRB,8.2708E-06_JPRB/)
KAO( :, 3,13, 1) = (/&
&2.2712E-06_JPRB,4.0679E-06_JPRB,4.5774E-06_JPRB,4.7613E-06_JPRB,4.7480E-06_JPRB,4.5771E-06_JPRB,&
&4.2377E-06_JPRB,3.6828E-06_JPRB,8.2482E-06_JPRB/)
KAO( :, 4,13, 1) = (/&
&2.2616E-06_JPRB,4.0128E-06_JPRB,4.4962E-06_JPRB,4.6740E-06_JPRB,4.6674E-06_JPRB,4.5144E-06_JPRB,&
&4.2021E-06_JPRB,3.6746E-06_JPRB,8.3289E-06_JPRB/)
KAO( :, 5,13, 1) = (/&
&2.2466E-06_JPRB,3.9523E-06_JPRB,4.4147E-06_JPRB,4.5851E-06_JPRB,4.5844E-06_JPRB,4.4468E-06_JPRB,&
&4.1612E-06_JPRB,3.6696E-06_JPRB,8.4982E-06_JPRB/)
KAO( :, 1, 1, 2) = (/&
&4.5009E-05_JPRB,5.8537E-05_JPRB,6.2677E-05_JPRB,6.4420E-05_JPRB,6.4899E-05_JPRB,6.4046E-05_JPRB,&
&6.1758E-05_JPRB,5.7308E-05_JPRB,4.4974E-05_JPRB/)
KAO( :, 2, 1, 2) = (/&
&4.4639E-05_JPRB,5.7851E-05_JPRB,6.2018E-05_JPRB,6.3985E-05_JPRB,6.4709E-05_JPRB,6.3972E-05_JPRB,&
&6.1776E-05_JPRB,5.7584E-05_JPRB,4.6032E-05_JPRB/)
KAO( :, 3, 1, 2) = (/&
&4.4183E-05_JPRB,5.7134E-05_JPRB,6.1429E-05_JPRB,6.3594E-05_JPRB,6.4467E-05_JPRB,6.3906E-05_JPRB,&
&6.1866E-05_JPRB,5.7909E-05_JPRB,4.7065E-05_JPRB/)
KAO( :, 4, 1, 2) = (/&
&4.3603E-05_JPRB,5.6311E-05_JPRB,6.0747E-05_JPRB,6.3098E-05_JPRB,6.4110E-05_JPRB,6.3723E-05_JPRB,&
&6.1859E-05_JPRB,5.8107E-05_JPRB,4.8038E-05_JPRB/)
KAO( :, 5, 1, 2) = (/&
&4.3016E-05_JPRB,5.5575E-05_JPRB,6.0089E-05_JPRB,6.2604E-05_JPRB,6.3758E-05_JPRB,6.3526E-05_JPRB,&
&6.1825E-05_JPRB,5.8256E-05_JPRB,4.8937E-05_JPRB/)
KAO( :, 1, 2, 2) = (/&
&3.8991E-05_JPRB,5.1237E-05_JPRB,5.5073E-05_JPRB,5.6912E-05_JPRB,5.7291E-05_JPRB,5.6357E-05_JPRB,&
&5.4136E-05_JPRB,4.9871E-05_JPRB,3.8345E-05_JPRB/)
KAO( :, 2, 2, 2) = (/&
&3.8628E-05_JPRB,5.0611E-05_JPRB,5.4618E-05_JPRB,5.6670E-05_JPRB,5.7177E-05_JPRB,5.6367E-05_JPRB,&
&5.4237E-05_JPRB,5.0203E-05_JPRB,3.9241E-05_JPRB/)
KAO( :, 3, 2, 2) = (/&
&3.8218E-05_JPRB,5.0047E-05_JPRB,5.4219E-05_JPRB,5.6458E-05_JPRB,5.7088E-05_JPRB,5.6414E-05_JPRB,&
&5.4375E-05_JPRB,5.0554E-05_JPRB,4.0182E-05_JPRB/)
KAO( :, 4, 2, 2) = (/&
&3.7696E-05_JPRB,4.9413E-05_JPRB,5.3740E-05_JPRB,5.6131E-05_JPRB,5.6939E-05_JPRB,5.6393E-05_JPRB,&
&5.4506E-05_JPRB,5.0827E-05_JPRB,4.1063E-05_JPRB/)
KAO( :, 5, 2, 2) = (/&
&3.7087E-05_JPRB,4.8772E-05_JPRB,5.3212E-05_JPRB,5.5737E-05_JPRB,5.6714E-05_JPRB,5.6323E-05_JPRB,&
&5.4580E-05_JPRB,5.1064E-05_JPRB,4.1833E-05_JPRB/)
KAO( :, 1, 3, 2) = (/&
&3.3664E-05_JPRB,4.4718E-05_JPRB,4.8316E-05_JPRB,5.0054E-05_JPRB,5.0316E-05_JPRB,4.9337E-05_JPRB,&
&4.7131E-05_JPRB,4.3067E-05_JPRB,3.3821E-05_JPRB/)
KAO( :, 2, 3, 2) = (/&
&3.3332E-05_JPRB,4.4193E-05_JPRB,4.7982E-05_JPRB,4.9921E-05_JPRB,5.0286E-05_JPRB,4.9400E-05_JPRB,&
&4.7278E-05_JPRB,4.3395E-05_JPRB,3.4508E-05_JPRB/)
KAO( :, 3, 3, 2) = (/&
&3.2912E-05_JPRB,4.3709E-05_JPRB,4.7689E-05_JPRB,4.9796E-05_JPRB,5.0261E-05_JPRB,4.9490E-05_JPRB,&
&4.7455E-05_JPRB,4.3769E-05_JPRB,3.5275E-05_JPRB/)
KAO( :, 4, 3, 2) = (/&
&3.2477E-05_JPRB,4.3262E-05_JPRB,4.7404E-05_JPRB,4.9658E-05_JPRB,5.0286E-05_JPRB,4.9612E-05_JPRB,&
&4.7676E-05_JPRB,4.4119E-05_JPRB,3.6032E-05_JPRB/)
KAO( :, 5, 3, 2) = (/&
&3.1897E-05_JPRB,4.2732E-05_JPRB,4.7020E-05_JPRB,4.9397E-05_JPRB,5.0209E-05_JPRB,4.9662E-05_JPRB,&
&4.7863E-05_JPRB,4.4408E-05_JPRB,3.6739E-05_JPRB/)
KAO( :, 1, 4, 2) = (/&
&2.9034E-05_JPRB,3.9020E-05_JPRB,4.2255E-05_JPRB,4.3779E-05_JPRB,4.3941E-05_JPRB,4.2940E-05_JPRB,&
&4.0749E-05_JPRB,3.6991E-05_JPRB,3.2231E-05_JPRB/)
KAO( :, 2, 4, 2) = (/&
&2.8733E-05_JPRB,3.8566E-05_JPRB,4.1993E-05_JPRB,4.3688E-05_JPRB,4.3978E-05_JPRB,4.3065E-05_JPRB,&
&4.0955E-05_JPRB,3.7298E-05_JPRB,3.2530E-05_JPRB/)
KAO( :, 3, 4, 2) = (/&
&2.8365E-05_JPRB,3.8166E-05_JPRB,4.1800E-05_JPRB,4.3640E-05_JPRB,4.4034E-05_JPRB,4.3186E-05_JPRB,&
&4.1171E-05_JPRB,3.7663E-05_JPRB,3.3003E-05_JPRB/)
KAO( :, 4, 4, 2) = (/&
&2.7906E-05_JPRB,3.7772E-05_JPRB,4.1598E-05_JPRB,4.3582E-05_JPRB,4.4101E-05_JPRB,4.3335E-05_JPRB,&
&4.1429E-05_JPRB,3.8018E-05_JPRB,3.3543E-05_JPRB/)
KAO( :, 5, 4, 2) = (/&
&2.7464E-05_JPRB,3.7412E-05_JPRB,4.1395E-05_JPRB,4.3505E-05_JPRB,4.4180E-05_JPRB,4.3547E-05_JPRB,&
&4.1708E-05_JPRB,3.8366E-05_JPRB,3.4090E-05_JPRB/)
KAO( :, 1, 5, 2) = (/&
&2.5046E-05_JPRB,3.4030E-05_JPRB,3.6841E-05_JPRB,3.8123E-05_JPRB,3.8161E-05_JPRB,3.7165E-05_JPRB,&
&3.5069E-05_JPRB,3.1597E-05_JPRB,3.1884E-05_JPRB/)
KAO( :, 2, 5, 2) = (/&
&2.4766E-05_JPRB,3.3630E-05_JPRB,3.6644E-05_JPRB,3.8042E-05_JPRB,3.8206E-05_JPRB,3.7320E-05_JPRB,&
&3.5335E-05_JPRB,3.1911E-05_JPRB,3.2055E-05_JPRB/)
KAO( :, 3, 5, 2) = (/&
&2.4433E-05_JPRB,3.3294E-05_JPRB,3.6479E-05_JPRB,3.8027E-05_JPRB,3.8311E-05_JPRB,3.7468E-05_JPRB,&
&3.5564E-05_JPRB,3.2236E-05_JPRB,3.2305E-05_JPRB/)
KAO( :, 4, 5, 2) = (/&
&2.4018E-05_JPRB,3.2959E-05_JPRB,3.6349E-05_JPRB,3.8027E-05_JPRB,3.8418E-05_JPRB,3.7650E-05_JPRB,&
&3.5828E-05_JPRB,3.2583E-05_JPRB,3.2642E-05_JPRB/)
KAO( :, 5, 5, 2) = (/&
&2.3591E-05_JPRB,3.2668E-05_JPRB,3.6232E-05_JPRB,3.8051E-05_JPRB,3.8551E-05_JPRB,3.7905E-05_JPRB,&
&3.6128E-05_JPRB,3.2939E-05_JPRB,3.3008E-05_JPRB/)
KAO( :, 1, 6, 2) = (/&
&2.1579E-05_JPRB,2.9591E-05_JPRB,3.1991E-05_JPRB,3.3013E-05_JPRB,3.2936E-05_JPRB,3.1944E-05_JPRB,&
&3.0025E-05_JPRB,2.6876E-05_JPRB,2.9999E-05_JPRB/)
KAO( :, 2, 6, 2) = (/&
&2.1317E-05_JPRB,2.9255E-05_JPRB,3.1830E-05_JPRB,3.2965E-05_JPRB,3.2983E-05_JPRB,3.2102E-05_JPRB,&
&3.0272E-05_JPRB,2.7170E-05_JPRB,3.0568E-05_JPRB/)
KAO( :, 3, 6, 2) = (/&
&2.1011E-05_JPRB,2.8952E-05_JPRB,3.1684E-05_JPRB,3.2945E-05_JPRB,3.3093E-05_JPRB,3.2263E-05_JPRB,&
&3.0533E-05_JPRB,2.7474E-05_JPRB,3.1151E-05_JPRB/)
KAO( :, 4, 6, 2) = (/&
&2.0627E-05_JPRB,2.8670E-05_JPRB,3.1569E-05_JPRB,3.2960E-05_JPRB,3.3217E-05_JPRB,3.2461E-05_JPRB,&
&3.0780E-05_JPRB,2.7789E-05_JPRB,3.1790E-05_JPRB/)
KAO( :, 5, 6, 2) = (/&
&2.0182E-05_JPRB,2.8368E-05_JPRB,3.1449E-05_JPRB,3.2969E-05_JPRB,3.3342E-05_JPRB,3.2673E-05_JPRB,&
&3.1052E-05_JPRB,2.8119E-05_JPRB,3.2386E-05_JPRB/)
KAO( :, 1, 7, 2) = (/&
&1.8452E-05_JPRB,2.5532E-05_JPRB,2.7551E-05_JPRB,2.8351E-05_JPRB,2.8204E-05_JPRB,2.7262E-05_JPRB,&
&2.5546E-05_JPRB,2.2740E-05_JPRB,2.8091E-05_JPRB/)
KAO( :, 2, 7, 2) = (/&
&1.8215E-05_JPRB,2.5256E-05_JPRB,2.7416E-05_JPRB,2.8318E-05_JPRB,2.8249E-05_JPRB,2.7395E-05_JPRB,&
&2.5765E-05_JPRB,2.3002E-05_JPRB,2.8720E-05_JPRB/)
KAO( :, 3, 7, 2) = (/&
&1.7931E-05_JPRB,2.4972E-05_JPRB,2.7294E-05_JPRB,2.8314E-05_JPRB,2.8348E-05_JPRB,2.7572E-05_JPRB,&
&2.6008E-05_JPRB,2.3291E-05_JPRB,2.9431E-05_JPRB/)
KAO( :, 4, 7, 2) = (/&
&1.7583E-05_JPRB,2.4714E-05_JPRB,2.7183E-05_JPRB,2.8322E-05_JPRB,2.8484E-05_JPRB,2.7765E-05_JPRB,&
&2.6265E-05_JPRB,2.3586E-05_JPRB,3.0235E-05_JPRB/)
KAO( :, 5, 7, 2) = (/&
&1.7179E-05_JPRB,2.4453E-05_JPRB,2.7076E-05_JPRB,2.8339E-05_JPRB,2.8609E-05_JPRB,2.7972E-05_JPRB,&
&2.6510E-05_JPRB,2.3882E-05_JPRB,3.1083E-05_JPRB/)
KAO( :, 1, 8, 2) = (/&
&1.5794E-05_JPRB,2.2020E-05_JPRB,2.3670E-05_JPRB,2.4259E-05_JPRB,2.4056E-05_JPRB,2.3178E-05_JPRB,&
&2.1635E-05_JPRB,1.9134E-05_JPRB,2.7582E-05_JPRB/)
KAO( :, 2, 8, 2) = (/&
&1.5579E-05_JPRB,2.1775E-05_JPRB,2.3546E-05_JPRB,2.4231E-05_JPRB,2.4092E-05_JPRB,2.3297E-05_JPRB,&
&2.1816E-05_JPRB,1.9397E-05_JPRB,2.8313E-05_JPRB/)
KAO( :, 3, 8, 2) = (/&
&1.5328E-05_JPRB,2.1517E-05_JPRB,2.3429E-05_JPRB,2.4220E-05_JPRB,2.4175E-05_JPRB,2.3443E-05_JPRB,&
&2.2039E-05_JPRB,1.9642E-05_JPRB,2.9205E-05_JPRB/)
KAO( :, 4, 8, 2) = (/&
&1.5023E-05_JPRB,2.1268E-05_JPRB,2.3319E-05_JPRB,2.4225E-05_JPRB,2.4291E-05_JPRB,2.3637E-05_JPRB,&
&2.2285E-05_JPRB,1.9922E-05_JPRB,3.0174E-05_JPRB/)
KAO( :, 5, 8, 2) = (/&
&1.4668E-05_JPRB,2.1020E-05_JPRB,2.3208E-05_JPRB,2.4227E-05_JPRB,2.4407E-05_JPRB,2.3824E-05_JPRB,&
&2.2528E-05_JPRB,2.0191E-05_JPRB,3.1226E-05_JPRB/)
KAO( :, 1, 9, 2) = (/&
&1.3453E-05_JPRB,1.8874E-05_JPRB,2.0200E-05_JPRB,2.0614E-05_JPRB,2.0394E-05_JPRB,1.9585E-05_JPRB,&
&1.8218E-05_JPRB,1.5952E-05_JPRB,3.1081E-05_JPRB/)
KAO( :, 2, 9, 2) = (/&
&1.3262E-05_JPRB,1.8651E-05_JPRB,2.0085E-05_JPRB,2.0598E-05_JPRB,2.0424E-05_JPRB,1.9696E-05_JPRB,&
&1.8380E-05_JPRB,1.6281E-05_JPRB,3.2467E-05_JPRB/)
KAO( :, 3, 9, 2) = (/&
&1.3038E-05_JPRB,1.8418E-05_JPRB,1.9972E-05_JPRB,2.0581E-05_JPRB,2.0487E-05_JPRB,1.9824E-05_JPRB,&
&1.8572E-05_JPRB,1.6491E-05_JPRB,3.3986E-05_JPRB/)
KAO( :, 4, 9, 2) = (/&
&1.2776E-05_JPRB,1.8181E-05_JPRB,1.9859E-05_JPRB,2.0572E-05_JPRB,2.0585E-05_JPRB,1.9985E-05_JPRB,&
&1.8794E-05_JPRB,1.6733E-05_JPRB,3.5607E-05_JPRB/)
KAO( :, 5, 9, 2) = (/&
&1.2471E-05_JPRB,1.7952E-05_JPRB,1.9753E-05_JPRB,2.0569E-05_JPRB,2.0679E-05_JPRB,2.0158E-05_JPRB,&
&1.9021E-05_JPRB,1.6980E-05_JPRB,3.7340E-05_JPRB/)
KAO( :, 1,10, 2) = (/&
&1.1374E-05_JPRB,1.6047E-05_JPRB,1.7111E-05_JPRB,1.7393E-05_JPRB,1.7165E-05_JPRB,1.6451E-05_JPRB,&
&1.5255E-05_JPRB,1.3140E-05_JPRB,3.4787E-05_JPRB/)
KAO( :, 2,10, 2) = (/&
&1.1208E-05_JPRB,1.5847E-05_JPRB,1.6997E-05_JPRB,1.7386E-05_JPRB,1.7209E-05_JPRB,1.6555E-05_JPRB,&
&1.5407E-05_JPRB,1.3598E-05_JPRB,3.7476E-05_JPRB/)
KAO( :, 3,10, 2) = (/&
&1.1010E-05_JPRB,1.5634E-05_JPRB,1.6890E-05_JPRB,1.7366E-05_JPRB,1.7258E-05_JPRB,1.6670E-05_JPRB,&
&1.5570E-05_JPRB,1.3793E-05_JPRB,4.0426E-05_JPRB/)
KAO( :, 4,10, 2) = (/&
&1.0782E-05_JPRB,1.5423E-05_JPRB,1.6783E-05_JPRB,1.7341E-05_JPRB,1.7331E-05_JPRB,1.6806E-05_JPRB,&
&1.5764E-05_JPRB,1.4000E-05_JPRB,4.3679E-05_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.0524E-05_JPRB,1.5209E-05_JPRB,1.6680E-05_JPRB,1.7333E-05_JPRB,1.7403E-05_JPRB,1.6952E-05_JPRB,&
&1.5975E-05_JPRB,1.4224E-05_JPRB,4.7059E-05_JPRB/)
KAO( :, 1,11, 2) = (/&
&9.5209E-06_JPRB,1.3499E-05_JPRB,1.4375E-05_JPRB,1.4600E-05_JPRB,1.4393E-05_JPRB,1.3793E-05_JPRB,&
&1.2781E-05_JPRB,1.1038E-05_JPRB,3.2865E-05_JPRB/)
KAO( :, 2,11, 2) = (/&
&9.3637E-06_JPRB,1.3313E-05_JPRB,1.4267E-05_JPRB,1.4592E-05_JPRB,1.4440E-05_JPRB,1.3889E-05_JPRB,&
&1.2920E-05_JPRB,1.1404E-05_JPRB,3.5445E-05_JPRB/)
KAO( :, 3,11, 2) = (/&
&9.1833E-06_JPRB,1.3123E-05_JPRB,1.4166E-05_JPRB,1.4568E-05_JPRB,1.4482E-05_JPRB,1.3996E-05_JPRB,&
&1.3070E-05_JPRB,1.1568E-05_JPRB,3.8218E-05_JPRB/)
KAO( :, 4,11, 2) = (/&
&8.9761E-06_JPRB,1.2932E-05_JPRB,1.4072E-05_JPRB,1.4544E-05_JPRB,1.4541E-05_JPRB,1.4107E-05_JPRB,&
&1.3243E-05_JPRB,1.1758E-05_JPRB,4.1117E-05_JPRB/)
KAO( :, 5,11, 2) = (/&
&8.7519E-06_JPRB,1.2738E-05_JPRB,1.3974E-05_JPRB,1.4523E-05_JPRB,1.4594E-05_JPRB,1.4232E-05_JPRB,&
&1.3426E-05_JPRB,1.1955E-05_JPRB,4.4210E-05_JPRB/)
KAO( :, 1,12, 2) = (/&
&7.9463E-06_JPRB,1.1314E-05_JPRB,1.2032E-05_JPRB,1.2211E-05_JPRB,1.2025E-05_JPRB,1.1526E-05_JPRB,&
&1.0676E-05_JPRB,9.2413E-06_JPRB,2.9106E-05_JPRB/)
KAO( :, 2,12, 2) = (/&
&7.8042E-06_JPRB,1.1141E-05_JPRB,1.1931E-05_JPRB,1.2198E-05_JPRB,1.2069E-05_JPRB,1.1610E-05_JPRB,&
&1.0799E-05_JPRB,9.5264E-06_JPRB,3.1349E-05_JPRB/)
KAO( :, 3,12, 2) = (/&
&7.6428E-06_JPRB,1.0975E-05_JPRB,1.1841E-05_JPRB,1.2172E-05_JPRB,1.2102E-05_JPRB,1.1694E-05_JPRB,&
&1.0928E-05_JPRB,9.6721E-06_JPRB,3.3866E-05_JPRB/)
KAO( :, 4,12, 2) = (/&
&7.4623E-06_JPRB,1.0806E-05_JPRB,1.1756E-05_JPRB,1.2145E-05_JPRB,1.2145E-05_JPRB,1.1788E-05_JPRB,&
&1.1076E-05_JPRB,9.8394E-06_JPRB,3.6457E-05_JPRB/)
KAO( :, 5,12, 2) = (/&
&7.2711E-06_JPRB,1.0633E-05_JPRB,1.1656E-05_JPRB,1.2115E-05_JPRB,1.2181E-05_JPRB,1.1891E-05_JPRB,&
&1.1228E-05_JPRB,1.0010E-05_JPRB,3.9156E-05_JPRB/)
KAO( :, 1,13, 2) = (/&
&6.6184E-06_JPRB,9.4565E-06_JPRB,1.0043E-05_JPRB,1.0182E-05_JPRB,1.0021E-05_JPRB,9.6035E-06_JPRB,&
&8.8893E-06_JPRB,7.7053E-06_JPRB,2.4435E-05_JPRB/)
KAO( :, 2,13, 2) = (/&
&6.4936E-06_JPRB,9.3020E-06_JPRB,9.9506E-06_JPRB,1.0164E-05_JPRB,1.0053E-05_JPRB,9.6688E-06_JPRB,&
&8.9931E-06_JPRB,7.9311E-06_JPRB,2.6318E-05_JPRB/)
KAO( :, 3,13, 2) = (/&
&6.3517E-06_JPRB,9.1558E-06_JPRB,9.8692E-06_JPRB,1.0135E-05_JPRB,1.0076E-05_JPRB,9.7347E-06_JPRB,&
&9.1027E-06_JPRB,8.0612E-06_JPRB,2.8419E-05_JPRB/)
KAO( :, 4,13, 2) = (/&
&6.1987E-06_JPRB,9.0085E-06_JPRB,9.7873E-06_JPRB,1.0106E-05_JPRB,1.0104E-05_JPRB,9.8108E-06_JPRB,&
&9.2254E-06_JPRB,8.2025E-06_JPRB,3.0596E-05_JPRB/)
KAO( :, 5,13, 2) = (/&
&6.0390E-06_JPRB,8.8585E-06_JPRB,9.6966E-06_JPRB,1.0071E-05_JPRB,1.0127E-05_JPRB,9.8907E-06_JPRB,&
&9.3441E-06_JPRB,8.3431E-06_JPRB,3.2866E-05_JPRB/)
KAO( :, 1, 1, 3) = (/&
&7.0753E-05_JPRB,8.7371E-05_JPRB,9.5172E-05_JPRB,9.9390E-05_JPRB,1.0056E-04_JPRB,9.9494E-05_JPRB,&
&9.5837E-05_JPRB,8.9326E-05_JPRB,7.4323E-05_JPRB/)
KAO( :, 2, 1, 3) = (/&
&6.9795E-05_JPRB,8.7509E-05_JPRB,9.5691E-05_JPRB,9.9950E-05_JPRB,1.0125E-04_JPRB,1.0041E-04_JPRB,&
&9.7011E-05_JPRB,9.0609E-05_JPRB,7.5641E-05_JPRB/)
KAO( :, 3, 1, 3) = (/&
&6.9131E-05_JPRB,8.7916E-05_JPRB,9.6468E-05_JPRB,1.0076E-04_JPRB,1.0214E-04_JPRB,1.0141E-04_JPRB,&
&9.8247E-05_JPRB,9.2085E-05_JPRB,7.7357E-05_JPRB/)
KAO( :, 4, 1, 3) = (/&
&6.8482E-05_JPRB,8.8338E-05_JPRB,9.7157E-05_JPRB,1.0153E-04_JPRB,1.0307E-04_JPRB,1.0249E-04_JPRB,&
&9.9530E-05_JPRB,9.3696E-05_JPRB,7.9379E-05_JPRB/)
KAO( :, 5, 1, 3) = (/&
&6.7880E-05_JPRB,8.8892E-05_JPRB,9.7857E-05_JPRB,1.0242E-04_JPRB,1.0411E-04_JPRB,1.0366E-04_JPRB,&
&1.0077E-04_JPRB,9.5333E-05_JPRB,8.1423E-05_JPRB/)
KAO( :, 1, 2, 3) = (/&
&6.2276E-05_JPRB,7.8469E-05_JPRB,8.5472E-05_JPRB,8.8868E-05_JPRB,8.9888E-05_JPRB,8.8903E-05_JPRB,&
&8.5409E-05_JPRB,7.9146E-05_JPRB,6.4309E-05_JPRB/)
KAO( :, 2, 2, 3) = (/&
&6.1522E-05_JPRB,7.8775E-05_JPRB,8.6027E-05_JPRB,8.9487E-05_JPRB,9.0686E-05_JPRB,8.9927E-05_JPRB,&
&8.6540E-05_JPRB,8.0293E-05_JPRB,6.5447E-05_JPRB/)
KAO( :, 3, 2, 3) = (/&
&6.1045E-05_JPRB,7.9281E-05_JPRB,8.6793E-05_JPRB,9.0368E-05_JPRB,9.1669E-05_JPRB,9.0966E-05_JPRB,&
&8.7713E-05_JPRB,8.1579E-05_JPRB,6.6858E-05_JPRB/)
KAO( :, 4, 2, 3) = (/&
&6.0651E-05_JPRB,7.9924E-05_JPRB,8.7586E-05_JPRB,9.1281E-05_JPRB,9.2660E-05_JPRB,9.2033E-05_JPRB,&
&8.8973E-05_JPRB,8.3100E-05_JPRB,6.8552E-05_JPRB/)
KAO( :, 5, 2, 3) = (/&
&6.0196E-05_JPRB,8.0517E-05_JPRB,8.8362E-05_JPRB,9.2181E-05_JPRB,9.3655E-05_JPRB,9.3124E-05_JPRB,&
&9.0231E-05_JPRB,8.4620E-05_JPRB,7.0321E-05_JPRB/)
KAO( :, 1, 3, 3) = (/&
&5.4594E-05_JPRB,7.0140E-05_JPRB,7.6291E-05_JPRB,7.9103E-05_JPRB,7.9908E-05_JPRB,7.8825E-05_JPRB,&
&7.5557E-05_JPRB,6.9638E-05_JPRB,5.6129E-05_JPRB/)
KAO( :, 2, 3, 3) = (/&
&5.3987E-05_JPRB,7.0481E-05_JPRB,7.6809E-05_JPRB,7.9722E-05_JPRB,8.0799E-05_JPRB,7.9847E-05_JPRB,&
&7.6636E-05_JPRB,7.0746E-05_JPRB,5.7083E-05_JPRB/)
KAO( :, 3, 3, 3) = (/&
&5.3598E-05_JPRB,7.0935E-05_JPRB,7.7478E-05_JPRB,8.0559E-05_JPRB,8.1742E-05_JPRB,8.0926E-05_JPRB,&
&7.7718E-05_JPRB,7.1792E-05_JPRB,5.8231E-05_JPRB/)
KAO( :, 4, 3, 3) = (/&
&5.3419E-05_JPRB,7.1650E-05_JPRB,7.8342E-05_JPRB,8.1570E-05_JPRB,8.2791E-05_JPRB,8.1991E-05_JPRB,&
&7.8849E-05_JPRB,7.3062E-05_JPRB,5.9633E-05_JPRB/)
KAO( :, 5, 3, 3) = (/&
&5.3129E-05_JPRB,7.2273E-05_JPRB,7.9178E-05_JPRB,8.2486E-05_JPRB,8.3759E-05_JPRB,8.3022E-05_JPRB,&
&8.0014E-05_JPRB,7.4467E-05_JPRB,6.1152E-05_JPRB/)
KAO( :, 1, 4, 3) = (/&
&4.7696E-05_JPRB,6.2286E-05_JPRB,6.7749E-05_JPRB,7.0181E-05_JPRB,7.0624E-05_JPRB,6.9456E-05_JPRB,&
&6.6381E-05_JPRB,6.0701E-05_JPRB,5.1576E-05_JPRB/)
KAO( :, 2, 4, 3) = (/&
&4.7208E-05_JPRB,6.2637E-05_JPRB,6.8240E-05_JPRB,7.0849E-05_JPRB,7.1530E-05_JPRB,7.0423E-05_JPRB,&
&6.7425E-05_JPRB,6.1760E-05_JPRB,5.2349E-05_JPRB/)
KAO( :, 3, 4, 3) = (/&
&4.6920E-05_JPRB,6.3058E-05_JPRB,6.8836E-05_JPRB,7.1607E-05_JPRB,7.2463E-05_JPRB,7.1509E-05_JPRB,&
&6.8509E-05_JPRB,6.2750E-05_JPRB,5.3224E-05_JPRB/)
KAO( :, 4, 4, 3) = (/&
&4.6776E-05_JPRB,6.3606E-05_JPRB,6.9601E-05_JPRB,7.2517E-05_JPRB,7.3446E-05_JPRB,7.2570E-05_JPRB,&
&6.9521E-05_JPRB,6.3786E-05_JPRB,5.4286E-05_JPRB/)
KAO( :, 5, 4, 3) = (/&
&4.6682E-05_JPRB,6.4343E-05_JPRB,7.0568E-05_JPRB,7.3573E-05_JPRB,7.4545E-05_JPRB,7.3619E-05_JPRB,&
&7.0604E-05_JPRB,6.5003E-05_JPRB,5.5521E-05_JPRB/)
KAO( :, 1, 5, 3) = (/&
&4.1581E-05_JPRB,5.4899E-05_JPRB,5.9799E-05_JPRB,6.1832E-05_JPRB,6.2136E-05_JPRB,6.0898E-05_JPRB,&
&5.7964E-05_JPRB,5.2516E-05_JPRB,5.0115E-05_JPRB/)
KAO( :, 2, 5, 3) = (/&
&4.1165E-05_JPRB,5.5257E-05_JPRB,6.0251E-05_JPRB,6.2555E-05_JPRB,6.3007E-05_JPRB,6.1795E-05_JPRB,&
&5.8864E-05_JPRB,5.3500E-05_JPRB,5.0524E-05_JPRB/)
KAO( :, 3, 5, 3) = (/&
&4.0905E-05_JPRB,5.5656E-05_JPRB,6.0839E-05_JPRB,6.3322E-05_JPRB,6.3891E-05_JPRB,6.2840E-05_JPRB,&
&5.9887E-05_JPRB,5.4446E-05_JPRB,5.1001E-05_JPRB/)
KAO( :, 4, 5, 3) = (/&
&4.0790E-05_JPRB,5.6129E-05_JPRB,6.1526E-05_JPRB,6.4146E-05_JPRB,6.4873E-05_JPRB,6.3880E-05_JPRB,&
&6.0934E-05_JPRB,5.5421E-05_JPRB,5.1576E-05_JPRB/)
KAO( :, 5, 5, 3) = (/&
&4.0741E-05_JPRB,5.6811E-05_JPRB,6.2419E-05_JPRB,6.5146E-05_JPRB,6.5947E-05_JPRB,6.4915E-05_JPRB,&
&6.1966E-05_JPRB,5.6459E-05_JPRB,5.2345E-05_JPRB/)
KAO( :, 1, 6, 3) = (/&
&3.6128E-05_JPRB,4.8074E-05_JPRB,5.2303E-05_JPRB,5.4088E-05_JPRB,5.4305E-05_JPRB,5.3072E-05_JPRB,&
&5.0232E-05_JPRB,4.5105E-05_JPRB,5.1680E-05_JPRB/)
KAO( :, 2, 6, 3) = (/&
&3.5776E-05_JPRB,4.8378E-05_JPRB,5.2790E-05_JPRB,5.4763E-05_JPRB,5.5146E-05_JPRB,5.3920E-05_JPRB,&
&5.1041E-05_JPRB,4.6023E-05_JPRB,5.1519E-05_JPRB/)
KAO( :, 3, 6, 3) = (/&
&3.5527E-05_JPRB,4.8788E-05_JPRB,5.3350E-05_JPRB,5.5505E-05_JPRB,5.5990E-05_JPRB,5.4859E-05_JPRB,&
&5.1952E-05_JPRB,4.6910E-05_JPRB,5.1451E-05_JPRB/)
KAO( :, 4, 6, 3) = (/&
&3.5393E-05_JPRB,4.9227E-05_JPRB,5.4029E-05_JPRB,5.6316E-05_JPRB,5.6902E-05_JPRB,5.5852E-05_JPRB,&
&5.2950E-05_JPRB,4.7839E-05_JPRB,5.1463E-05_JPRB/)
KAO( :, 5, 6, 3) = (/&
&3.5279E-05_JPRB,4.9738E-05_JPRB,5.4773E-05_JPRB,5.7200E-05_JPRB,5.7864E-05_JPRB,5.6831E-05_JPRB,&
&5.3962E-05_JPRB,4.8775E-05_JPRB,5.1664E-05_JPRB/)
KAO( :, 1, 7, 3) = (/&
&3.1175E-05_JPRB,4.1797E-05_JPRB,4.5353E-05_JPRB,4.6878E-05_JPRB,4.7045E-05_JPRB,4.5914E-05_JPRB,&
&4.3260E-05_JPRB,3.8528E-05_JPRB,5.5034E-05_JPRB/)
KAO( :, 2, 7, 3) = (/&
&3.0861E-05_JPRB,4.2063E-05_JPRB,4.5864E-05_JPRB,4.7535E-05_JPRB,4.7827E-05_JPRB,4.6677E-05_JPRB,&
&4.3974E-05_JPRB,3.9350E-05_JPRB,5.5182E-05_JPRB/)
KAO( :, 3, 7, 3) = (/&
&3.0632E-05_JPRB,4.2441E-05_JPRB,4.6427E-05_JPRB,4.8241E-05_JPRB,4.8620E-05_JPRB,4.7526E-05_JPRB,&
&4.4793E-05_JPRB,4.0140E-05_JPRB,5.5398E-05_JPRB/)
KAO( :, 4, 7, 3) = (/&
&3.0475E-05_JPRB,4.2876E-05_JPRB,4.7039E-05_JPRB,4.9018E-05_JPRB,4.9446E-05_JPRB,4.8432E-05_JPRB,&
&4.5701E-05_JPRB,4.0986E-05_JPRB,5.5585E-05_JPRB/)
KAO( :, 5, 7, 3) = (/&
&3.0340E-05_JPRB,4.3333E-05_JPRB,4.7753E-05_JPRB,4.9874E-05_JPRB,5.0366E-05_JPRB,4.9368E-05_JPRB,&
&4.6641E-05_JPRB,4.1870E-05_JPRB,5.5728E-05_JPRB/)
KAO( :, 1, 8, 3) = (/&
&2.6882E-05_JPRB,3.6181E-05_JPRB,3.9159E-05_JPRB,4.0385E-05_JPRB,4.0472E-05_JPRB,3.9467E-05_JPRB,&
&3.7068E-05_JPRB,3.2787E-05_JPRB,6.0191E-05_JPRB/)
KAO( :, 2, 8, 3) = (/&
&2.6577E-05_JPRB,3.6420E-05_JPRB,3.9630E-05_JPRB,4.1005E-05_JPRB,4.1190E-05_JPRB,4.0154E-05_JPRB,&
&3.7711E-05_JPRB,3.3501E-05_JPRB,6.0976E-05_JPRB/)
KAO( :, 3, 8, 3) = (/&
&2.6344E-05_JPRB,3.6733E-05_JPRB,4.0183E-05_JPRB,4.1714E-05_JPRB,4.1930E-05_JPRB,4.0908E-05_JPRB,&
&3.8425E-05_JPRB,3.4195E-05_JPRB,6.1747E-05_JPRB/)
KAO( :, 4, 8, 3) = (/&
&2.6154E-05_JPRB,3.7129E-05_JPRB,4.0772E-05_JPRB,4.2424E-05_JPRB,4.2698E-05_JPRB,4.1708E-05_JPRB,&
&3.9208E-05_JPRB,3.4923E-05_JPRB,6.2436E-05_JPRB/)
KAO( :, 5, 8, 3) = (/&
&2.5969E-05_JPRB,3.7541E-05_JPRB,4.1396E-05_JPRB,4.3205E-05_JPRB,4.3544E-05_JPRB,4.2561E-05_JPRB,&
&4.0066E-05_JPRB,3.5716E-05_JPRB,6.2996E-05_JPRB/)
KAO( :, 1, 9, 3) = (/&
&2.3030E-05_JPRB,3.1081E-05_JPRB,3.3574E-05_JPRB,3.4578E-05_JPRB,3.4594E-05_JPRB,3.3680E-05_JPRB,&
&3.1564E-05_JPRB,2.7753E-05_JPRB,8.2972E-05_JPRB/)
KAO( :, 2, 9, 3) = (/&
&2.2745E-05_JPRB,3.1301E-05_JPRB,3.4001E-05_JPRB,3.5099E-05_JPRB,3.5210E-05_JPRB,3.4293E-05_JPRB,&
&3.2147E-05_JPRB,2.8418E-05_JPRB,8.5573E-05_JPRB/)
KAO( :, 3, 9, 3) = (/&
&2.2504E-05_JPRB,3.1575E-05_JPRB,3.4507E-05_JPRB,3.5759E-05_JPRB,3.5892E-05_JPRB,3.4957E-05_JPRB,&
&3.2777E-05_JPRB,2.9021E-05_JPRB,8.7692E-05_JPRB/)
KAO( :, 4, 9, 3) = (/&
&2.2288E-05_JPRB,3.1903E-05_JPRB,3.5055E-05_JPRB,3.6460E-05_JPRB,3.6616E-05_JPRB,3.5667E-05_JPRB,&
&3.3440E-05_JPRB,2.9641E-05_JPRB,8.9596E-05_JPRB/)
KAO( :, 5, 9, 3) = (/&
&2.2076E-05_JPRB,3.2254E-05_JPRB,3.5612E-05_JPRB,3.7158E-05_JPRB,3.7379E-05_JPRB,3.6426E-05_JPRB,&
&3.4185E-05_JPRB,3.0329E-05_JPRB,9.1172E-05_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.9573E-05_JPRB,2.6501E-05_JPRB,2.8604E-05_JPRB,2.9434E-05_JPRB,2.9415E-05_JPRB,2.8586E-05_JPRB,&
&2.6756E-05_JPRB,2.3398E-05_JPRB,1.1831E-04_JPRB/)
KAO( :, 2,10, 3) = (/&
&1.9311E-05_JPRB,2.6696E-05_JPRB,2.8987E-05_JPRB,2.9871E-05_JPRB,2.9930E-05_JPRB,2.9131E-05_JPRB,&
&2.7291E-05_JPRB,2.4061E-05_JPRB,1.2413E-04_JPRB/)
KAO( :, 3,10, 3) = (/&
&1.9064E-05_JPRB,2.6931E-05_JPRB,2.9433E-05_JPRB,3.0442E-05_JPRB,3.0524E-05_JPRB,2.9723E-05_JPRB,&
&2.7830E-05_JPRB,2.4575E-05_JPRB,1.2968E-04_JPRB/)
KAO( :, 4,10, 3) = (/&
&1.8838E-05_JPRB,2.7200E-05_JPRB,2.9911E-05_JPRB,3.1092E-05_JPRB,3.1189E-05_JPRB,3.0347E-05_JPRB,&
&2.8402E-05_JPRB,2.5111E-05_JPRB,1.3500E-04_JPRB/)
KAO( :, 5,10, 3) = (/&
&1.8619E-05_JPRB,2.7473E-05_JPRB,3.0391E-05_JPRB,3.1737E-05_JPRB,3.1883E-05_JPRB,3.1020E-05_JPRB,&
&2.9042E-05_JPRB,2.5702E-05_JPRB,1.4050E-04_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.6456E-05_JPRB,2.2515E-05_JPRB,2.4353E-05_JPRB,2.5062E-05_JPRB,2.5054E-05_JPRB,2.4348E-05_JPRB,&
&2.2780E-05_JPRB,1.9929E-05_JPRB,1.2447E-04_JPRB/)
KAO( :, 2,11, 3) = (/&
&1.6210E-05_JPRB,2.2705E-05_JPRB,2.4709E-05_JPRB,2.5473E-05_JPRB,2.5515E-05_JPRB,2.4826E-05_JPRB,&
&2.3259E-05_JPRB,2.0482E-05_JPRB,1.3150E-04_JPRB/)
KAO( :, 3,11, 3) = (/&
&1.5971E-05_JPRB,2.2902E-05_JPRB,2.5095E-05_JPRB,2.5990E-05_JPRB,2.6068E-05_JPRB,2.5361E-05_JPRB,&
&2.3741E-05_JPRB,2.0933E-05_JPRB,1.3833E-04_JPRB/)
KAO( :, 4,11, 3) = (/&
&1.5752E-05_JPRB,2.3106E-05_JPRB,2.5493E-05_JPRB,2.6568E-05_JPRB,2.6674E-05_JPRB,2.5935E-05_JPRB,&
&2.4259E-05_JPRB,2.1401E-05_JPRB,1.4470E-04_JPRB/)
KAO( :, 5,11, 3) = (/&
&1.5528E-05_JPRB,2.3318E-05_JPRB,2.5901E-05_JPRB,2.7141E-05_JPRB,2.7302E-05_JPRB,2.6558E-05_JPRB,&
&2.4843E-05_JPRB,2.1914E-05_JPRB,1.5074E-04_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.3780E-05_JPRB,1.9033E-05_JPRB,2.0619E-05_JPRB,2.1228E-05_JPRB,2.1226E-05_JPRB,2.0621E-05_JPRB,&
&1.9294E-05_JPRB,1.6882E-05_JPRB,1.1649E-04_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.3548E-05_JPRB,1.9199E-05_JPRB,2.0913E-05_JPRB,2.1600E-05_JPRB,2.1645E-05_JPRB,2.1053E-05_JPRB,&
&1.9719E-05_JPRB,1.7352E-05_JPRB,1.2368E-04_JPRB/)
KAO( :, 3,12, 3) = (/&
&1.3324E-05_JPRB,1.9341E-05_JPRB,2.1240E-05_JPRB,2.2050E-05_JPRB,2.2132E-05_JPRB,2.1536E-05_JPRB,&
&2.0156E-05_JPRB,1.7750E-05_JPRB,1.3017E-04_JPRB/)
KAO( :, 4,12, 3) = (/&
&1.3111E-05_JPRB,1.9487E-05_JPRB,2.1558E-05_JPRB,2.2533E-05_JPRB,2.2665E-05_JPRB,2.2056E-05_JPRB,&
&2.0628E-05_JPRB,1.8158E-05_JPRB,1.3659E-04_JPRB/)
KAO( :, 5,12, 3) = (/&
&1.2895E-05_JPRB,1.9642E-05_JPRB,2.1889E-05_JPRB,2.3011E-05_JPRB,2.3210E-05_JPRB,2.2606E-05_JPRB,&
&2.1150E-05_JPRB,1.8610E-05_JPRB,1.4251E-04_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.1500E-05_JPRB,1.6003E-05_JPRB,1.7357E-05_JPRB,1.7889E-05_JPRB,1.7884E-05_JPRB,1.7367E-05_JPRB,&
&1.6254E-05_JPRB,1.4227E-05_JPRB,9.8757E-05_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.1286E-05_JPRB,1.6126E-05_JPRB,1.7594E-05_JPRB,1.8210E-05_JPRB,1.8252E-05_JPRB,1.7751E-05_JPRB,&
&1.6632E-05_JPRB,1.4641E-05_JPRB,1.0488E-04_JPRB/)
KAO( :, 3,13, 3) = (/&
&1.1079E-05_JPRB,1.6225E-05_JPRB,1.7843E-05_JPRB,1.8579E-05_JPRB,1.8672E-05_JPRB,1.8176E-05_JPRB,&
&1.7024E-05_JPRB,1.4980E-05_JPRB,1.1036E-04_JPRB/)
KAO( :, 4,13, 3) = (/&
&1.0876E-05_JPRB,1.6327E-05_JPRB,1.8099E-05_JPRB,1.8965E-05_JPRB,1.9122E-05_JPRB,1.8629E-05_JPRB,&
&1.7445E-05_JPRB,1.5339E-05_JPRB,1.1580E-04_JPRB/)
KAO( :, 5,13, 3) = (/&
&1.0678E-05_JPRB,1.6434E-05_JPRB,1.8360E-05_JPRB,1.9355E-05_JPRB,1.9573E-05_JPRB,1.9100E-05_JPRB,&
&1.7895E-05_JPRB,1.5734E-05_JPRB,1.2071E-04_JPRB/)
KAO( :, 1, 1, 4) = (/&
&1.0452E-04_JPRB,1.3483E-04_JPRB,1.4507E-04_JPRB,1.5035E-04_JPRB,1.5233E-04_JPRB,1.5098E-04_JPRB,&
&1.4623E-04_JPRB,1.3688E-04_JPRB,1.1596E-04_JPRB/)
KAO( :, 2, 1, 4) = (/&
&1.0431E-04_JPRB,1.3598E-04_JPRB,1.4693E-04_JPRB,1.5285E-04_JPRB,1.5505E-04_JPRB,1.5376E-04_JPRB,&
&1.4899E-04_JPRB,1.4010E-04_JPRB,1.1898E-04_JPRB/)
KAO( :, 3, 1, 4) = (/&
&1.0452E-04_JPRB,1.3748E-04_JPRB,1.4911E-04_JPRB,1.5568E-04_JPRB,1.5820E-04_JPRB,1.5701E-04_JPRB,&
&1.5204E-04_JPRB,1.4309E-04_JPRB,1.2195E-04_JPRB/)
KAO( :, 4, 1, 4) = (/&
&1.0446E-04_JPRB,1.3898E-04_JPRB,1.5142E-04_JPRB,1.5876E-04_JPRB,1.6160E-04_JPRB,1.6033E-04_JPRB,&
&1.5519E-04_JPRB,1.4614E-04_JPRB,1.2504E-04_JPRB/)
KAO( :, 5, 1, 4) = (/&
&1.0490E-04_JPRB,1.4072E-04_JPRB,1.5426E-04_JPRB,1.6221E-04_JPRB,1.6521E-04_JPRB,1.6398E-04_JPRB,&
&1.5900E-04_JPRB,1.4986E-04_JPRB,1.2878E-04_JPRB/)
KAO( :, 1, 2, 4) = (/&
&9.4204E-05_JPRB,1.2226E-04_JPRB,1.3172E-04_JPRB,1.3677E-04_JPRB,1.3845E-04_JPRB,1.3676E-04_JPRB,&
&1.3184E-04_JPRB,1.2295E-04_JPRB,1.0190E-04_JPRB/)
KAO( :, 2, 2, 4) = (/&
&9.4074E-05_JPRB,1.2351E-04_JPRB,1.3361E-04_JPRB,1.3908E-04_JPRB,1.4094E-04_JPRB,1.3921E-04_JPRB,&
&1.3441E-04_JPRB,1.2595E-04_JPRB,1.0466E-04_JPRB/)
KAO( :, 3, 2, 4) = (/&
&9.4344E-05_JPRB,1.2509E-04_JPRB,1.3579E-04_JPRB,1.4166E-04_JPRB,1.4376E-04_JPRB,1.4219E-04_JPRB,&
&1.3731E-04_JPRB,1.2889E-04_JPRB,1.0736E-04_JPRB/)
KAO( :, 4, 2, 4) = (/&
&9.4551E-05_JPRB,1.2662E-04_JPRB,1.3810E-04_JPRB,1.4452E-04_JPRB,1.4685E-04_JPRB,1.4532E-04_JPRB,&
&1.4026E-04_JPRB,1.3156E-04_JPRB,1.1005E-04_JPRB/)
KAO( :, 5, 2, 4) = (/&
&9.4911E-05_JPRB,1.2828E-04_JPRB,1.4068E-04_JPRB,1.4753E-04_JPRB,1.5017E-04_JPRB,1.4865E-04_JPRB,&
&1.4353E-04_JPRB,1.3462E-04_JPRB,1.1332E-04_JPRB/)
KAO( :, 1, 3, 4) = (/&
&8.4477E-05_JPRB,1.0977E-04_JPRB,1.1875E-04_JPRB,1.2346E-04_JPRB,1.2481E-04_JPRB,1.2312E-04_JPRB,&
&1.1833E-04_JPRB,1.0957E-04_JPRB,8.9535E-05_JPRB/)
KAO( :, 2, 3, 4) = (/&
&8.4379E-05_JPRB,1.1105E-04_JPRB,1.2059E-04_JPRB,1.2560E-04_JPRB,1.2700E-04_JPRB,1.2527E-04_JPRB,&
&1.2063E-04_JPRB,1.1208E-04_JPRB,9.1925E-05_JPRB/)
KAO( :, 3, 3, 4) = (/&
&8.4459E-05_JPRB,1.1263E-04_JPRB,1.2255E-04_JPRB,1.2789E-04_JPRB,1.2949E-04_JPRB,1.2788E-04_JPRB,&
&1.2327E-04_JPRB,1.1489E-04_JPRB,9.4307E-05_JPRB/)
KAO( :, 4, 3, 4) = (/&
&8.4957E-05_JPRB,1.1436E-04_JPRB,1.2477E-04_JPRB,1.3051E-04_JPRB,1.3225E-04_JPRB,1.3075E-04_JPRB,&
&1.2605E-04_JPRB,1.1763E-04_JPRB,9.6664E-05_JPRB/)
KAO( :, 5, 3, 4) = (/&
&8.5267E-05_JPRB,1.1603E-04_JPRB,1.2711E-04_JPRB,1.3323E-04_JPRB,1.3522E-04_JPRB,1.3376E-04_JPRB,&
&1.2892E-04_JPRB,1.2027E-04_JPRB,9.9423E-05_JPRB/)
KAO( :, 1, 4, 4) = (/&
&7.5106E-05_JPRB,9.8023E-05_JPRB,1.0634E-04_JPRB,1.1074E-04_JPRB,1.1207E-04_JPRB,1.1047E-04_JPRB,&
&1.0566E-04_JPRB,9.7179E-05_JPRB,8.0970E-05_JPRB/)
KAO( :, 2, 4, 4) = (/&
&7.5068E-05_JPRB,9.9316E-05_JPRB,1.0818E-04_JPRB,1.1273E-04_JPRB,1.1400E-04_JPRB,1.1240E-04_JPRB,&
&1.0763E-04_JPRB,9.9160E-05_JPRB,8.2847E-05_JPRB/)
KAO( :, 3, 4, 4) = (/&
&7.5176E-05_JPRB,1.0088E-04_JPRB,1.1012E-04_JPRB,1.1492E-04_JPRB,1.1630E-04_JPRB,1.1469E-04_JPRB,&
&1.0990E-04_JPRB,1.0156E-04_JPRB,8.4919E-05_JPRB/)
KAO( :, 4, 4, 4) = (/&
&7.5441E-05_JPRB,1.0260E-04_JPRB,1.1218E-04_JPRB,1.1722E-04_JPRB,1.1877E-04_JPRB,1.1722E-04_JPRB,&
&1.1247E-04_JPRB,1.0418E-04_JPRB,8.7047E-05_JPRB/)
KAO( :, 5, 4, 4) = (/&
&7.6234E-05_JPRB,1.0451E-04_JPRB,1.1445E-04_JPRB,1.1978E-04_JPRB,1.2144E-04_JPRB,1.1995E-04_JPRB,&
&1.1523E-04_JPRB,1.0678E-04_JPRB,8.9379E-05_JPRB/)
KAO( :, 1, 5, 4) = (/&
&6.6160E-05_JPRB,8.7240E-05_JPRB,9.4827E-05_JPRB,9.8971E-05_JPRB,1.0023E-04_JPRB,9.8598E-05_JPRB,&
&9.3977E-05_JPRB,8.6015E-05_JPRB,7.7683E-05_JPRB/)
KAO( :, 2, 5, 4) = (/&
&6.6183E-05_JPRB,8.8517E-05_JPRB,9.6624E-05_JPRB,1.0080E-04_JPRB,1.0196E-04_JPRB,1.0036E-04_JPRB,&
&9.5737E-05_JPRB,8.7609E-05_JPRB,7.8892E-05_JPRB/)
KAO( :, 3, 5, 4) = (/&
&6.6375E-05_JPRB,9.0052E-05_JPRB,9.8476E-05_JPRB,1.0284E-04_JPRB,1.0408E-04_JPRB,1.0241E-04_JPRB,&
&9.7689E-05_JPRB,8.9585E-05_JPRB,8.0494E-05_JPRB/)
KAO( :, 4, 5, 4) = (/&
&6.6706E-05_JPRB,9.1731E-05_JPRB,1.0049E-04_JPRB,1.0501E-04_JPRB,1.0639E-04_JPRB,1.0469E-04_JPRB,&
&9.9852E-05_JPRB,9.1849E-05_JPRB,8.2317E-05_JPRB/)
KAO( :, 5, 5, 4) = (/&
&6.7530E-05_JPRB,9.3541E-05_JPRB,1.0261E-04_JPRB,1.0728E-04_JPRB,1.0881E-04_JPRB,1.0721E-04_JPRB,&
&1.0236E-04_JPRB,9.4247E-05_JPRB,8.4311E-05_JPRB/)
KAO( :, 1, 6, 4) = (/&
&5.7820E-05_JPRB,7.7124E-05_JPRB,8.4195E-05_JPRB,8.7927E-05_JPRB,8.8972E-05_JPRB,8.7430E-05_JPRB,&
&8.3132E-05_JPRB,7.5650E-05_JPRB,7.8327E-05_JPRB/)
KAO( :, 2, 6, 4) = (/&
&5.7858E-05_JPRB,7.8413E-05_JPRB,8.5775E-05_JPRB,8.9605E-05_JPRB,9.0590E-05_JPRB,8.9122E-05_JPRB,&
&8.4773E-05_JPRB,7.7051E-05_JPRB,7.8482E-05_JPRB/)
KAO( :, 3, 6, 4) = (/&
&5.8124E-05_JPRB,7.9824E-05_JPRB,8.7576E-05_JPRB,9.1549E-05_JPRB,9.2483E-05_JPRB,9.0882E-05_JPRB,&
&8.6480E-05_JPRB,7.8637E-05_JPRB,7.9105E-05_JPRB/)
KAO( :, 4, 6, 4) = (/&
&5.8563E-05_JPRB,8.1362E-05_JPRB,8.9405E-05_JPRB,9.3593E-05_JPRB,9.4634E-05_JPRB,9.2868E-05_JPRB,&
&8.8337E-05_JPRB,8.0467E-05_JPRB,8.0117E-05_JPRB/)
KAO( :, 5, 6, 4) = (/&
&5.9163E-05_JPRB,8.2947E-05_JPRB,9.1328E-05_JPRB,9.5614E-05_JPRB,9.6868E-05_JPRB,9.5118E-05_JPRB,&
&9.0461E-05_JPRB,8.2517E-05_JPRB,8.1395E-05_JPRB/)
KAO( :, 1, 7, 4) = (/&
&5.0089E-05_JPRB,6.7496E-05_JPRB,7.4227E-05_JPRB,7.7520E-05_JPRB,7.8410E-05_JPRB,7.6863E-05_JPRB,&
&7.2879E-05_JPRB,6.5963E-05_JPRB,8.6270E-05_JPRB/)
KAO( :, 2, 7, 4) = (/&
&5.0200E-05_JPRB,6.8721E-05_JPRB,7.5605E-05_JPRB,7.9011E-05_JPRB,7.9876E-05_JPRB,7.8434E-05_JPRB,&
&7.4469E-05_JPRB,6.7323E-05_JPRB,8.5543E-05_JPRB/)
KAO( :, 3, 7, 4) = (/&
&5.0465E-05_JPRB,7.0073E-05_JPRB,7.7198E-05_JPRB,8.0725E-05_JPRB,8.1573E-05_JPRB,8.0081E-05_JPRB,&
&7.6049E-05_JPRB,6.8699E-05_JPRB,8.4940E-05_JPRB/)
KAO( :, 4, 7, 4) = (/&
&5.0935E-05_JPRB,7.1437E-05_JPRB,7.8942E-05_JPRB,8.2653E-05_JPRB,8.3546E-05_JPRB,8.1849E-05_JPRB,&
&7.7644E-05_JPRB,7.0190E-05_JPRB,8.4597E-05_JPRB/)
KAO( :, 5, 7, 4) = (/&
&5.1558E-05_JPRB,7.2909E-05_JPRB,8.0657E-05_JPRB,8.4558E-05_JPRB,8.5533E-05_JPRB,8.3860E-05_JPRB,&
&7.9445E-05_JPRB,7.1873E-05_JPRB,8.4633E-05_JPRB/)
KAO( :, 1, 8, 4) = (/&
&4.3241E-05_JPRB,5.8715E-05_JPRB,6.4907E-05_JPRB,6.7818E-05_JPRB,6.8520E-05_JPRB,6.7059E-05_JPRB,&
&6.3436E-05_JPRB,5.7025E-05_JPRB,1.0556E-04_JPRB/)
KAO( :, 2, 8, 4) = (/&
&4.3396E-05_JPRB,5.9829E-05_JPRB,6.6154E-05_JPRB,6.9172E-05_JPRB,6.9903E-05_JPRB,6.8506E-05_JPRB,&
&6.4888E-05_JPRB,5.8346E-05_JPRB,1.0621E-04_JPRB/)
KAO( :, 3, 8, 4) = (/&
&4.3671E-05_JPRB,6.1116E-05_JPRB,6.7537E-05_JPRB,7.0639E-05_JPRB,7.1418E-05_JPRB,7.0005E-05_JPRB,&
&6.6322E-05_JPRB,5.9628E-05_JPRB,1.0623E-04_JPRB/)
KAO( :, 4, 8, 4) = (/&
&4.4098E-05_JPRB,6.2393E-05_JPRB,6.9085E-05_JPRB,7.2351E-05_JPRB,7.3148E-05_JPRB,7.1679E-05_JPRB,&
&6.7759E-05_JPRB,6.0926E-05_JPRB,1.0598E-04_JPRB/)
KAO( :, 5, 8, 4) = (/&
&4.4692E-05_JPRB,6.3732E-05_JPRB,7.0698E-05_JPRB,7.4137E-05_JPRB,7.4984E-05_JPRB,7.3462E-05_JPRB,&
&6.9302E-05_JPRB,6.2346E-05_JPRB,1.0567E-04_JPRB/)
KAO( :, 1, 9, 4) = (/&
&3.7132E-05_JPRB,5.0817E-05_JPRB,5.6256E-05_JPRB,5.8754E-05_JPRB,5.9255E-05_JPRB,5.8002E-05_JPRB,&
&5.4741E-05_JPRB,4.8907E-05_JPRB,1.5932E-04_JPRB/)
KAO( :, 2, 9, 4) = (/&
&3.7275E-05_JPRB,5.1787E-05_JPRB,5.7392E-05_JPRB,6.0022E-05_JPRB,6.0595E-05_JPRB,5.9356E-05_JPRB,&
&5.6080E-05_JPRB,5.0176E-05_JPRB,1.6074E-04_JPRB/)
KAO( :, 3, 9, 4) = (/&
&3.7562E-05_JPRB,5.2932E-05_JPRB,5.8629E-05_JPRB,6.1314E-05_JPRB,6.1975E-05_JPRB,6.0718E-05_JPRB,&
&5.7380E-05_JPRB,5.1383E-05_JPRB,1.6208E-04_JPRB/)
KAO( :, 4, 9, 4) = (/&
&3.7959E-05_JPRB,5.4161E-05_JPRB,5.9989E-05_JPRB,6.2778E-05_JPRB,6.3464E-05_JPRB,6.2208E-05_JPRB,&
&5.8730E-05_JPRB,5.2572E-05_JPRB,1.6367E-04_JPRB/)
KAO( :, 5, 9, 4) = (/&
&3.8474E-05_JPRB,5.5413E-05_JPRB,6.1478E-05_JPRB,6.4374E-05_JPRB,6.5107E-05_JPRB,6.3821E-05_JPRB,&
&6.0122E-05_JPRB,5.3780E-05_JPRB,1.6576E-04_JPRB/)
KAO( :, 1,10, 4) = (/&
&3.1661E-05_JPRB,4.3721E-05_JPRB,4.8375E-05_JPRB,5.0533E-05_JPRB,5.0884E-05_JPRB,4.9757E-05_JPRB,&
&4.6933E-05_JPRB,4.1760E-05_JPRB,3.3288E-04_JPRB/)
KAO( :, 2,10, 4) = (/&
&3.1799E-05_JPRB,4.4567E-05_JPRB,4.9444E-05_JPRB,5.1711E-05_JPRB,5.2132E-05_JPRB,5.1037E-05_JPRB,&
&4.8202E-05_JPRB,4.2932E-05_JPRB,3.3259E-04_JPRB/)
KAO( :, 3,10, 4) = (/&
&3.2076E-05_JPRB,4.5598E-05_JPRB,5.0572E-05_JPRB,5.2901E-05_JPRB,5.3401E-05_JPRB,5.2274E-05_JPRB,&
&4.9410E-05_JPRB,4.4046E-05_JPRB,3.3116E-04_JPRB/)
KAO( :, 4,10, 4) = (/&
&3.2432E-05_JPRB,4.6745E-05_JPRB,5.1822E-05_JPRB,5.4161E-05_JPRB,5.4721E-05_JPRB,5.3605E-05_JPRB,&
&5.0657E-05_JPRB,4.5130E-05_JPRB,3.2908E-04_JPRB/)
KAO( :, 5,10, 4) = (/&
&3.2849E-05_JPRB,4.7929E-05_JPRB,5.3191E-05_JPRB,5.5555E-05_JPRB,5.6151E-05_JPRB,5.5034E-05_JPRB,&
&5.1913E-05_JPRB,4.6196E-05_JPRB,3.2646E-04_JPRB/)
KAO( :, 1,11, 4) = (/&
&2.6856E-05_JPRB,3.7683E-05_JPRB,4.1693E-05_JPRB,4.3606E-05_JPRB,4.3883E-05_JPRB,4.2891E-05_JPRB,&
&4.0459E-05_JPRB,3.5912E-05_JPRB,4.0077E-04_JPRB/)
KAO( :, 2,11, 4) = (/&
&2.7039E-05_JPRB,3.8497E-05_JPRB,4.2726E-05_JPRB,4.4727E-05_JPRB,4.5037E-05_JPRB,4.4055E-05_JPRB,&
&4.1621E-05_JPRB,3.6978E-05_JPRB,3.9949E-04_JPRB/)
KAO( :, 3,11, 4) = (/&
&2.7307E-05_JPRB,3.9484E-05_JPRB,4.3818E-05_JPRB,4.5808E-05_JPRB,4.6194E-05_JPRB,4.5211E-05_JPRB,&
&4.2730E-05_JPRB,3.7986E-05_JPRB,3.9696E-04_JPRB/)
KAO( :, 4,11, 4) = (/&
&2.7612E-05_JPRB,4.0551E-05_JPRB,4.5021E-05_JPRB,4.6980E-05_JPRB,4.7421E-05_JPRB,4.6420E-05_JPRB,&
&4.3860E-05_JPRB,3.8943E-05_JPRB,3.9400E-04_JPRB/)
KAO( :, 5,11, 4) = (/&
&2.7944E-05_JPRB,4.1639E-05_JPRB,4.6278E-05_JPRB,4.8247E-05_JPRB,4.8726E-05_JPRB,4.7717E-05_JPRB,&
&4.5010E-05_JPRB,3.9912E-05_JPRB,3.9021E-04_JPRB/)
KAO( :, 1,12, 4) = (/&
&2.2674E-05_JPRB,3.2256E-05_JPRB,3.5706E-05_JPRB,3.7375E-05_JPRB,3.7620E-05_JPRB,3.6748E-05_JPRB,&
&3.4672E-05_JPRB,3.0753E-05_JPRB,3.9801E-04_JPRB/)
KAO( :, 2,12, 4) = (/&
&2.2856E-05_JPRB,3.3035E-05_JPRB,3.6681E-05_JPRB,3.8389E-05_JPRB,3.8658E-05_JPRB,3.7799E-05_JPRB,&
&3.5709E-05_JPRB,3.1711E-05_JPRB,3.9549E-04_JPRB/)
KAO( :, 3,12, 4) = (/&
&2.3070E-05_JPRB,3.3949E-05_JPRB,3.7724E-05_JPRB,3.9400E-05_JPRB,3.9718E-05_JPRB,3.8860E-05_JPRB,&
&3.6712E-05_JPRB,3.2588E-05_JPRB,3.9241E-04_JPRB/)
KAO( :, 4,12, 4) = (/&
&2.3301E-05_JPRB,3.4905E-05_JPRB,3.8836E-05_JPRB,4.0484E-05_JPRB,4.0838E-05_JPRB,3.9966E-05_JPRB,&
&3.7706E-05_JPRB,3.3447E-05_JPRB,3.8870E-04_JPRB/)
KAO( :, 5,12, 4) = (/&
&2.3543E-05_JPRB,3.5840E-05_JPRB,3.9948E-05_JPRB,4.1657E-05_JPRB,4.2028E-05_JPRB,4.1130E-05_JPRB,&
&3.8770E-05_JPRB,3.4320E-05_JPRB,3.8474E-04_JPRB/)
KAO( :, 1,13, 4) = (/&
&1.9048E-05_JPRB,2.7433E-05_JPRB,3.0355E-05_JPRB,3.1781E-05_JPRB,3.2020E-05_JPRB,3.1297E-05_JPRB,&
&2.9545E-05_JPRB,2.6213E-05_JPRB,3.3572E-04_JPRB/)
KAO( :, 2,13, 4) = (/&
&1.9186E-05_JPRB,2.8151E-05_JPRB,3.1249E-05_JPRB,3.2687E-05_JPRB,3.2953E-05_JPRB,3.2236E-05_JPRB,&
&3.0464E-05_JPRB,2.7042E-05_JPRB,3.3299E-04_JPRB/)
KAO( :, 3,13, 4) = (/&
&1.9336E-05_JPRB,2.8946E-05_JPRB,3.2213E-05_JPRB,3.3632E-05_JPRB,3.3925E-05_JPRB,3.3202E-05_JPRB,&
&3.1346E-05_JPRB,2.7832E-05_JPRB,3.2995E-04_JPRB/)
KAO( :, 4,13, 4) = (/&
&1.9500E-05_JPRB,2.9752E-05_JPRB,3.3189E-05_JPRB,3.4641E-05_JPRB,3.4936E-05_JPRB,3.4186E-05_JPRB,&
&3.2242E-05_JPRB,2.8586E-05_JPRB,3.2636E-04_JPRB/)
KAO( :, 5,13, 4) = (/&
&1.9647E-05_JPRB,3.0517E-05_JPRB,3.4157E-05_JPRB,3.5690E-05_JPRB,3.6009E-05_JPRB,3.5240E-05_JPRB,&
&3.3224E-05_JPRB,2.9383E-05_JPRB,3.2302E-04_JPRB/)
KAO( :, 1, 1, 5) = (/&
&1.5710E-04_JPRB,2.0320E-04_JPRB,2.2809E-04_JPRB,2.4127E-04_JPRB,2.4664E-04_JPRB,2.4637E-04_JPRB,&
&2.3954E-04_JPRB,2.2558E-04_JPRB,1.9226E-04_JPRB/)
KAO( :, 2, 1, 5) = (/&
&1.5763E-04_JPRB,2.0602E-04_JPRB,2.3252E-04_JPRB,2.4654E-04_JPRB,2.5266E-04_JPRB,2.5275E-04_JPRB,&
&2.4636E-04_JPRB,2.3254E-04_JPRB,1.9836E-04_JPRB/)
KAO( :, 3, 1, 5) = (/&
&1.5885E-04_JPRB,2.0936E-04_JPRB,2.3726E-04_JPRB,2.5211E-04_JPRB,2.5917E-04_JPRB,2.5987E-04_JPRB,&
&2.5423E-04_JPRB,2.4110E-04_JPRB,2.0597E-04_JPRB/)
KAO( :, 4, 1, 5) = (/&
&1.6010E-04_JPRB,2.1292E-04_JPRB,2.4195E-04_JPRB,2.5773E-04_JPRB,2.6599E-04_JPRB,2.6801E-04_JPRB,&
&2.6343E-04_JPRB,2.5079E-04_JPRB,2.1448E-04_JPRB/)
KAO( :, 5, 1, 5) = (/&
&1.6183E-04_JPRB,2.1689E-04_JPRB,2.4710E-04_JPRB,2.6390E-04_JPRB,2.7349E-04_JPRB,2.7678E-04_JPRB,&
&2.7286E-04_JPRB,2.6055E-04_JPRB,2.2334E-04_JPRB/)
KAO( :, 1, 2, 5) = (/&
&1.4264E-04_JPRB,1.8747E-04_JPRB,2.0916E-04_JPRB,2.2048E-04_JPRB,2.2542E-04_JPRB,2.2467E-04_JPRB,&
&2.1833E-04_JPRB,2.0428E-04_JPRB,1.7002E-04_JPRB/)
KAO( :, 2, 2, 5) = (/&
&1.4357E-04_JPRB,1.9029E-04_JPRB,2.1342E-04_JPRB,2.2542E-04_JPRB,2.3082E-04_JPRB,2.3044E-04_JPRB,&
&2.2413E-04_JPRB,2.1022E-04_JPRB,1.7510E-04_JPRB/)
KAO( :, 3, 2, 5) = (/&
&1.4512E-04_JPRB,1.9354E-04_JPRB,2.1804E-04_JPRB,2.3071E-04_JPRB,2.3662E-04_JPRB,2.3677E-04_JPRB,&
&2.3090E-04_JPRB,2.1760E-04_JPRB,1.8164E-04_JPRB/)
KAO( :, 4, 2, 5) = (/&
&1.4675E-04_JPRB,1.9716E-04_JPRB,2.2262E-04_JPRB,2.3622E-04_JPRB,2.4303E-04_JPRB,2.4400E-04_JPRB,&
&2.3876E-04_JPRB,2.2602E-04_JPRB,1.8905E-04_JPRB/)
KAO( :, 5, 2, 5) = (/&
&1.4825E-04_JPRB,2.0084E-04_JPRB,2.2744E-04_JPRB,2.4214E-04_JPRB,2.4980E-04_JPRB,2.5170E-04_JPRB,&
&2.4697E-04_JPRB,2.3468E-04_JPRB,1.9668E-04_JPRB/)
KAO( :, 1, 3, 5) = (/&
&1.2913E-04_JPRB,1.7105E-04_JPRB,1.8962E-04_JPRB,1.9927E-04_JPRB,2.0344E-04_JPRB,2.0263E-04_JPRB,&
&1.9648E-04_JPRB,1.8374E-04_JPRB,1.5154E-04_JPRB/)
KAO( :, 2, 3, 5) = (/&
&1.3034E-04_JPRB,1.7385E-04_JPRB,1.9352E-04_JPRB,2.0379E-04_JPRB,2.0816E-04_JPRB,2.0767E-04_JPRB,&
&2.0141E-04_JPRB,1.8880E-04_JPRB,1.5543E-04_JPRB/)
KAO( :, 3, 3, 5) = (/&
&1.3189E-04_JPRB,1.7683E-04_JPRB,1.9785E-04_JPRB,2.0858E-04_JPRB,2.1306E-04_JPRB,2.1289E-04_JPRB,&
&2.0705E-04_JPRB,1.9450E-04_JPRB,1.6042E-04_JPRB/)
KAO( :, 4, 3, 5) = (/&
&1.3375E-04_JPRB,1.8038E-04_JPRB,2.0233E-04_JPRB,2.1375E-04_JPRB,2.1890E-04_JPRB,2.1897E-04_JPRB,&
&2.1362E-04_JPRB,2.0111E-04_JPRB,1.6638E-04_JPRB/)
KAO( :, 5, 3, 5) = (/&
&1.3531E-04_JPRB,1.8393E-04_JPRB,2.0677E-04_JPRB,2.1903E-04_JPRB,2.2516E-04_JPRB,2.2557E-04_JPRB,&
&2.2073E-04_JPRB,2.0849E-04_JPRB,1.7278E-04_JPRB/)
KAO( :, 1, 4, 5) = (/&
&1.1675E-04_JPRB,1.5471E-04_JPRB,1.7086E-04_JPRB,1.7907E-04_JPRB,1.8234E-04_JPRB,1.8104E-04_JPRB,&
&1.7606E-04_JPRB,1.6488E-04_JPRB,1.3686E-04_JPRB/)
KAO( :, 2, 4, 5) = (/&
&1.1811E-04_JPRB,1.5738E-04_JPRB,1.7430E-04_JPRB,1.8299E-04_JPRB,1.8662E-04_JPRB,1.8551E-04_JPRB,&
&1.8028E-04_JPRB,1.6914E-04_JPRB,1.4021E-04_JPRB/)
KAO( :, 3, 4, 5) = (/&
&1.1971E-04_JPRB,1.6033E-04_JPRB,1.7826E-04_JPRB,1.8706E-04_JPRB,1.9073E-04_JPRB,1.9003E-04_JPRB,&
&1.8491E-04_JPRB,1.7381E-04_JPRB,1.4440E-04_JPRB/)
KAO( :, 4, 4, 5) = (/&
&1.2145E-04_JPRB,1.6360E-04_JPRB,1.8232E-04_JPRB,1.9160E-04_JPRB,1.9546E-04_JPRB,1.9520E-04_JPRB,&
&1.9032E-04_JPRB,1.7913E-04_JPRB,1.4919E-04_JPRB/)
KAO( :, 5, 4, 5) = (/&
&1.2345E-04_JPRB,1.6734E-04_JPRB,1.8679E-04_JPRB,1.9667E-04_JPRB,2.0102E-04_JPRB,2.0119E-04_JPRB,&
&1.9631E-04_JPRB,1.8511E-04_JPRB,1.5453E-04_JPRB/)
KAO( :, 1, 5, 5) = (/&
&1.0534E-04_JPRB,1.3892E-04_JPRB,1.5318E-04_JPRB,1.6013E-04_JPRB,1.6249E-04_JPRB,1.6140E-04_JPRB,&
&1.5677E-04_JPRB,1.4673E-04_JPRB,1.2734E-04_JPRB/)
KAO( :, 2, 5, 5) = (/&
&1.0682E-04_JPRB,1.4149E-04_JPRB,1.5615E-04_JPRB,1.6351E-04_JPRB,1.6643E-04_JPRB,1.6536E-04_JPRB,&
&1.6060E-04_JPRB,1.5077E-04_JPRB,1.3032E-04_JPRB/)
KAO( :, 3, 5, 5) = (/&
&1.0832E-04_JPRB,1.4437E-04_JPRB,1.5968E-04_JPRB,1.6719E-04_JPRB,1.7007E-04_JPRB,1.6925E-04_JPRB,&
&1.6475E-04_JPRB,1.5487E-04_JPRB,1.3383E-04_JPRB/)
KAO( :, 4, 5, 5) = (/&
&1.0998E-04_JPRB,1.4759E-04_JPRB,1.6348E-04_JPRB,1.7115E-04_JPRB,1.7411E-04_JPRB,1.7355E-04_JPRB,&
&1.6947E-04_JPRB,1.5945E-04_JPRB,1.3787E-04_JPRB/)
KAO( :, 5, 5, 5) = (/&
&1.1196E-04_JPRB,1.5129E-04_JPRB,1.6770E-04_JPRB,1.7586E-04_JPRB,1.7902E-04_JPRB,1.7859E-04_JPRB,&
&1.7456E-04_JPRB,1.6452E-04_JPRB,1.4233E-04_JPRB/)
KAO( :, 1, 6, 5) = (/&
&9.4514E-05_JPRB,1.2412E-04_JPRB,1.3657E-04_JPRB,1.4247E-04_JPRB,1.4441E-04_JPRB,1.4315E-04_JPRB,&
&1.3838E-04_JPRB,1.2929E-04_JPRB,1.2327E-04_JPRB/)
KAO( :, 2, 6, 5) = (/&
&9.5941E-05_JPRB,1.2645E-04_JPRB,1.3931E-04_JPRB,1.4558E-04_JPRB,1.4789E-04_JPRB,1.4670E-04_JPRB,&
&1.4200E-04_JPRB,1.3303E-04_JPRB,1.2601E-04_JPRB/)
KAO( :, 3, 6, 5) = (/&
&9.7365E-05_JPRB,1.2920E-04_JPRB,1.4235E-04_JPRB,1.4876E-04_JPRB,1.5129E-04_JPRB,1.5035E-04_JPRB,&
&1.4574E-04_JPRB,1.3687E-04_JPRB,1.2924E-04_JPRB/)
KAO( :, 4, 6, 5) = (/&
&9.8894E-05_JPRB,1.3238E-04_JPRB,1.4586E-04_JPRB,1.5224E-04_JPRB,1.5484E-04_JPRB,1.5423E-04_JPRB,&
&1.4989E-04_JPRB,1.4089E-04_JPRB,1.3292E-04_JPRB/)
KAO( :, 5, 6, 5) = (/&
&1.0059E-04_JPRB,1.3577E-04_JPRB,1.4967E-04_JPRB,1.5644E-04_JPRB,1.5902E-04_JPRB,1.5844E-04_JPRB,&
&1.5428E-04_JPRB,1.4522E-04_JPRB,1.3684E-04_JPRB/)
KAO( :, 1, 7, 5) = (/&
&8.3817E-05_JPRB,1.1024E-04_JPRB,1.2069E-04_JPRB,1.2606E-04_JPRB,1.2762E-04_JPRB,1.2601E-04_JPRB,&
&1.2142E-04_JPRB,1.1275E-04_JPRB,1.2580E-04_JPRB/)
KAO( :, 2, 7, 5) = (/&
&8.5049E-05_JPRB,1.1240E-04_JPRB,1.2345E-04_JPRB,1.2908E-04_JPRB,1.3088E-04_JPRB,1.2946E-04_JPRB,&
&1.2489E-04_JPRB,1.1643E-04_JPRB,1.2769E-04_JPRB/)
KAO( :, 3, 7, 5) = (/&
&8.6443E-05_JPRB,1.1489E-04_JPRB,1.2631E-04_JPRB,1.3210E-04_JPRB,1.3408E-04_JPRB,1.3284E-04_JPRB,&
&1.2822E-04_JPRB,1.1996E-04_JPRB,1.3009E-04_JPRB/)
KAO( :, 4, 7, 5) = (/&
&8.7868E-05_JPRB,1.1787E-04_JPRB,1.2952E-04_JPRB,1.3521E-04_JPRB,1.3734E-04_JPRB,1.3637E-04_JPRB,&
&1.3189E-04_JPRB,1.2366E-04_JPRB,1.3307E-04_JPRB/)
KAO( :, 5, 7, 5) = (/&
&8.9520E-05_JPRB,1.2113E-04_JPRB,1.3311E-04_JPRB,1.3890E-04_JPRB,1.4111E-04_JPRB,1.4019E-04_JPRB,&
&1.3574E-04_JPRB,1.2746E-04_JPRB,1.3629E-04_JPRB/)
KAO( :, 1, 8, 5) = (/&
&7.3739E-05_JPRB,9.7315E-05_JPRB,1.0630E-04_JPRB,1.1091E-04_JPRB,1.1210E-04_JPRB,1.1034E-04_JPRB,&
&1.0576E-04_JPRB,9.7435E-05_JPRB,1.5219E-04_JPRB/)
KAO( :, 2, 8, 5) = (/&
&7.4739E-05_JPRB,9.9339E-05_JPRB,1.0888E-04_JPRB,1.1385E-04_JPRB,1.1515E-04_JPRB,1.1361E-04_JPRB,&
&1.0914E-04_JPRB,1.0091E-04_JPRB,1.5078E-04_JPRB/)
KAO( :, 3, 8, 5) = (/&
&7.5979E-05_JPRB,1.0158E-04_JPRB,1.1168E-04_JPRB,1.1676E-04_JPRB,1.1825E-04_JPRB,1.1684E-04_JPRB,&
&1.1240E-04_JPRB,1.0417E-04_JPRB,1.5044E-04_JPRB/)
KAO( :, 4, 8, 5) = (/&
&7.7389E-05_JPRB,1.0425E-04_JPRB,1.1460E-04_JPRB,1.1977E-04_JPRB,1.2131E-04_JPRB,1.2000E-04_JPRB,&
&1.1564E-04_JPRB,1.0754E-04_JPRB,1.5083E-04_JPRB/)
KAO( :, 5, 8, 5) = (/&
&7.8988E-05_JPRB,1.0719E-04_JPRB,1.1787E-04_JPRB,1.2308E-04_JPRB,1.2465E-04_JPRB,1.2345E-04_JPRB,&
&1.1918E-04_JPRB,1.1099E-04_JPRB,1.5186E-04_JPRB/)
KAO( :, 1, 9, 5) = (/&
&6.4327E-05_JPRB,8.5194E-05_JPRB,9.3124E-05_JPRB,9.6906E-05_JPRB,9.7902E-05_JPRB,9.6087E-05_JPRB,&
&9.1486E-05_JPRB,8.3530E-05_JPRB,3.0559E-04_JPRB/)
KAO( :, 2, 9, 5) = (/&
&6.5169E-05_JPRB,8.7114E-05_JPRB,9.5498E-05_JPRB,9.9699E-05_JPRB,1.0078E-04_JPRB,9.9075E-05_JPRB,&
&9.4585E-05_JPRB,8.6649E-05_JPRB,3.0376E-04_JPRB/)
KAO( :, 3, 9, 5) = (/&
&6.6228E-05_JPRB,8.9174E-05_JPRB,9.8080E-05_JPRB,1.0257E-04_JPRB,1.0373E-04_JPRB,1.0212E-04_JPRB,&
&9.7761E-05_JPRB,8.9715E-05_JPRB,3.0205E-04_JPRB/)
KAO( :, 4, 9, 5) = (/&
&6.7560E-05_JPRB,9.1493E-05_JPRB,1.0085E-04_JPRB,1.0546E-04_JPRB,1.0670E-04_JPRB,1.0511E-04_JPRB,&
&1.0078E-04_JPRB,9.2773E-05_JPRB,2.9925E-04_JPRB/)
KAO( :, 5, 9, 5) = (/&
&6.9090E-05_JPRB,9.4108E-05_JPRB,1.0377E-04_JPRB,1.0852E-04_JPRB,1.0981E-04_JPRB,1.0822E-04_JPRB,&
&1.0396E-04_JPRB,9.5948E-05_JPRB,2.9560E-04_JPRB/)
KAO( :, 1,10, 5) = (/&
&5.5732E-05_JPRB,7.4195E-05_JPRB,8.1092E-05_JPRB,8.4263E-05_JPRB,8.5004E-05_JPRB,8.3260E-05_JPRB,&
&7.8896E-05_JPRB,7.1326E-05_JPRB,7.3141E-04_JPRB/)
KAO( :, 2,10, 5) = (/&
&5.6464E-05_JPRB,7.5996E-05_JPRB,8.3306E-05_JPRB,8.6877E-05_JPRB,8.7776E-05_JPRB,8.6058E-05_JPRB,&
&8.1636E-05_JPRB,7.4082E-05_JPRB,7.1679E-04_JPRB/)
KAO( :, 3,10, 5) = (/&
&5.7403E-05_JPRB,7.7891E-05_JPRB,8.5666E-05_JPRB,8.9585E-05_JPRB,9.0592E-05_JPRB,8.8875E-05_JPRB,&
&8.4523E-05_JPRB,7.6897E-05_JPRB,7.0421E-04_JPRB/)
KAO( :, 4,10, 5) = (/&
&5.8620E-05_JPRB,7.9933E-05_JPRB,8.8213E-05_JPRB,9.2386E-05_JPRB,9.3433E-05_JPRB,9.1667E-05_JPRB,&
&8.7388E-05_JPRB,7.9742E-05_JPRB,6.9385E-04_JPRB/)
KAO( :, 5,10, 5) = (/&
&6.0067E-05_JPRB,8.2256E-05_JPRB,9.0893E-05_JPRB,9.5273E-05_JPRB,9.6366E-05_JPRB,9.4596E-05_JPRB,&
&9.0298E-05_JPRB,8.2632E-05_JPRB,6.8465E-04_JPRB/)
KAO( :, 1,11, 5) = (/&
&4.8186E-05_JPRB,6.4983E-05_JPRB,7.1108E-05_JPRB,7.3858E-05_JPRB,7.4401E-05_JPRB,7.2817E-05_JPRB,&
&6.8716E-05_JPRB,6.1721E-05_JPRB,9.3137E-04_JPRB/)
KAO( :, 2,11, 5) = (/&
&4.8927E-05_JPRB,6.6681E-05_JPRB,7.3165E-05_JPRB,7.6242E-05_JPRB,7.7034E-05_JPRB,7.5453E-05_JPRB,&
&7.1255E-05_JPRB,6.4142E-05_JPRB,9.0283E-04_JPRB/)
KAO( :, 3,11, 5) = (/&
&4.9906E-05_JPRB,6.8442E-05_JPRB,7.5379E-05_JPRB,7.8833E-05_JPRB,7.9706E-05_JPRB,7.8052E-05_JPRB,&
&7.3833E-05_JPRB,6.6698E-05_JPRB,8.7896E-04_JPRB/)
KAO( :, 4,11, 5) = (/&
&5.1140E-05_JPRB,7.0403E-05_JPRB,7.7738E-05_JPRB,8.1490E-05_JPRB,8.2392E-05_JPRB,8.0715E-05_JPRB,&
&7.6507E-05_JPRB,6.9333E-05_JPRB,8.5877E-04_JPRB/)
KAO( :, 5,11, 5) = (/&
&5.2547E-05_JPRB,7.2595E-05_JPRB,8.0310E-05_JPRB,8.4272E-05_JPRB,8.5190E-05_JPRB,8.3479E-05_JPRB,&
&7.9204E-05_JPRB,7.1956E-05_JPRB,8.4129E-04_JPRB/)
KAO( :, 1,12, 5) = (/&
&4.1357E-05_JPRB,5.6591E-05_JPRB,6.2004E-05_JPRB,6.4335E-05_JPRB,6.4718E-05_JPRB,6.3255E-05_JPRB,&
&5.9536E-05_JPRB,5.3170E-05_JPRB,9.4628E-04_JPRB/)
KAO( :, 2,12, 5) = (/&
&4.2117E-05_JPRB,5.8142E-05_JPRB,6.3912E-05_JPRB,6.6563E-05_JPRB,6.7175E-05_JPRB,6.5721E-05_JPRB,&
&6.1864E-05_JPRB,5.5283E-05_JPRB,9.1448E-04_JPRB/)
KAO( :, 3,12, 5) = (/&
&4.3123E-05_JPRB,5.9831E-05_JPRB,6.5955E-05_JPRB,6.8956E-05_JPRB,6.9677E-05_JPRB,6.8113E-05_JPRB,&
&6.4202E-05_JPRB,5.7597E-05_JPRB,8.8738E-04_JPRB/)
KAO( :, 4,12, 5) = (/&
&4.4308E-05_JPRB,6.1719E-05_JPRB,6.8165E-05_JPRB,7.1448E-05_JPRB,7.2209E-05_JPRB,7.0617E-05_JPRB,&
&6.6651E-05_JPRB,5.9974E-05_JPRB,8.6370E-04_JPRB/)
KAO( :, 5,12, 5) = (/&
&4.5586E-05_JPRB,6.3825E-05_JPRB,7.0651E-05_JPRB,7.4074E-05_JPRB,7.4824E-05_JPRB,7.3199E-05_JPRB,&
&6.9129E-05_JPRB,6.2368E-05_JPRB,8.4394E-04_JPRB/)
KAO( :, 1,13, 5) = (/&
&3.5199E-05_JPRB,4.8904E-05_JPRB,5.3685E-05_JPRB,5.5708E-05_JPRB,5.5958E-05_JPRB,5.4602E-05_JPRB,&
&5.1289E-05_JPRB,4.5544E-05_JPRB,7.9844E-04_JPRB/)
KAO( :, 2,13, 5) = (/&
&3.5968E-05_JPRB,5.0359E-05_JPRB,5.5441E-05_JPRB,5.7776E-05_JPRB,5.8210E-05_JPRB,5.6833E-05_JPRB,&
&5.3406E-05_JPRB,4.7437E-05_JPRB,7.7225E-04_JPRB/)
KAO( :, 3,13, 5) = (/&
&3.6919E-05_JPRB,5.1978E-05_JPRB,5.7339E-05_JPRB,5.9942E-05_JPRB,6.0487E-05_JPRB,5.9061E-05_JPRB,&
&5.5548E-05_JPRB,4.9491E-05_JPRB,7.4964E-04_JPRB/)
KAO( :, 4,13, 5) = (/&
&3.7983E-05_JPRB,5.3790E-05_JPRB,5.9444E-05_JPRB,6.2256E-05_JPRB,6.2844E-05_JPRB,6.1377E-05_JPRB,&
&5.7755E-05_JPRB,5.1611E-05_JPRB,7.3016E-04_JPRB/)
KAO( :, 5,13, 5) = (/&
&3.9071E-05_JPRB,5.5803E-05_JPRB,6.1798E-05_JPRB,6.4723E-05_JPRB,6.5302E-05_JPRB,6.3732E-05_JPRB,&
&5.9993E-05_JPRB,5.3748E-05_JPRB,7.1404E-04_JPRB/)
KAO( :, 1, 1, 6) = (/&
&2.5660E-04_JPRB,3.1807E-04_JPRB,3.6094E-04_JPRB,3.8920E-04_JPRB,4.0736E-04_JPRB,4.1545E-04_JPRB,&
&4.1386E-04_JPRB,4.0633E-04_JPRB,3.6193E-04_JPRB/)
KAO( :, 2, 1, 6) = (/&
&2.5865E-04_JPRB,3.2319E-04_JPRB,3.6764E-04_JPRB,3.9762E-04_JPRB,4.1800E-04_JPRB,4.2858E-04_JPRB,&
&4.2847E-04_JPRB,4.2235E-04_JPRB,3.7675E-04_JPRB/)
KAO( :, 3, 1, 6) = (/&
&2.6137E-04_JPRB,3.2915E-04_JPRB,3.7535E-04_JPRB,4.0750E-04_JPRB,4.2970E-04_JPRB,4.4147E-04_JPRB,&
&4.4293E-04_JPRB,4.3843E-04_JPRB,3.9233E-04_JPRB/)
KAO( :, 4, 1, 6) = (/&
&2.6360E-04_JPRB,3.3488E-04_JPRB,3.8404E-04_JPRB,4.1788E-04_JPRB,4.4114E-04_JPRB,4.5427E-04_JPRB,&
&4.5738E-04_JPRB,4.5544E-04_JPRB,4.1003E-04_JPRB/)
KAO( :, 5, 1, 6) = (/&
&2.6660E-04_JPRB,3.4173E-04_JPRB,3.9350E-04_JPRB,4.2919E-04_JPRB,4.5400E-04_JPRB,4.6894E-04_JPRB,&
&4.7415E-04_JPRB,4.7523E-04_JPRB,4.3058E-04_JPRB/)
KAO( :, 1, 2, 6) = (/&
&2.3631E-04_JPRB,2.9631E-04_JPRB,3.3525E-04_JPRB,3.5919E-04_JPRB,3.7267E-04_JPRB,3.7835E-04_JPRB,&
&3.7529E-04_JPRB,3.6555E-04_JPRB,3.2111E-04_JPRB/)
KAO( :, 2, 2, 6) = (/&
&2.3829E-04_JPRB,3.0128E-04_JPRB,3.4159E-04_JPRB,3.6758E-04_JPRB,3.8290E-04_JPRB,3.9019E-04_JPRB,&
&3.8891E-04_JPRB,3.7964E-04_JPRB,3.3378E-04_JPRB/)
KAO( :, 3, 2, 6) = (/&
&2.4092E-04_JPRB,3.0698E-04_JPRB,3.4893E-04_JPRB,3.7703E-04_JPRB,3.9429E-04_JPRB,4.0240E-04_JPRB,&
&4.0189E-04_JPRB,3.9363E-04_JPRB,3.4730E-04_JPRB/)
KAO( :, 4, 2, 6) = (/&
&2.4353E-04_JPRB,3.1280E-04_JPRB,3.5757E-04_JPRB,3.8697E-04_JPRB,4.0550E-04_JPRB,4.1447E-04_JPRB,&
&4.1496E-04_JPRB,4.0890E-04_JPRB,3.6318E-04_JPRB/)
KAO( :, 5, 2, 6) = (/&
&2.4646E-04_JPRB,3.1930E-04_JPRB,3.6666E-04_JPRB,3.9774E-04_JPRB,4.1741E-04_JPRB,4.2801E-04_JPRB,&
&4.2988E-04_JPRB,4.2637E-04_JPRB,3.8102E-04_JPRB/)
KAO( :, 1, 3, 6) = (/&
&2.1702E-04_JPRB,2.7392E-04_JPRB,3.0713E-04_JPRB,3.2661E-04_JPRB,3.3701E-04_JPRB,3.4012E-04_JPRB,&
&3.3574E-04_JPRB,3.2367E-04_JPRB,2.7953E-04_JPRB/)
KAO( :, 2, 3, 6) = (/&
&2.1882E-04_JPRB,2.7874E-04_JPRB,3.1368E-04_JPRB,3.3483E-04_JPRB,3.4655E-04_JPRB,3.5089E-04_JPRB,&
&3.4836E-04_JPRB,3.3662E-04_JPRB,2.9075E-04_JPRB/)
KAO( :, 3, 3, 6) = (/&
&2.2093E-04_JPRB,2.8379E-04_JPRB,3.2031E-04_JPRB,3.4355E-04_JPRB,3.5690E-04_JPRB,3.6196E-04_JPRB,&
&3.6029E-04_JPRB,3.4924E-04_JPRB,3.0255E-04_JPRB/)
KAO( :, 4, 3, 6) = (/&
&2.2391E-04_JPRB,2.8964E-04_JPRB,3.2857E-04_JPRB,3.5322E-04_JPRB,3.6741E-04_JPRB,3.7364E-04_JPRB,&
&3.7227E-04_JPRB,3.6287E-04_JPRB,3.1610E-04_JPRB/)
KAO( :, 5, 3, 6) = (/&
&2.2678E-04_JPRB,2.9569E-04_JPRB,3.3712E-04_JPRB,3.6314E-04_JPRB,3.7839E-04_JPRB,3.8589E-04_JPRB,&
&3.8538E-04_JPRB,3.7808E-04_JPRB,3.3103E-04_JPRB/)
KAO( :, 1, 4, 6) = (/&
&1.9893E-04_JPRB,2.5184E-04_JPRB,2.7904E-04_JPRB,2.9424E-04_JPRB,3.0215E-04_JPRB,3.0353E-04_JPRB,&
&2.9750E-04_JPRB,2.8367E-04_JPRB,2.4378E-04_JPRB/)
KAO( :, 2, 4, 6) = (/&
&2.0039E-04_JPRB,2.5636E-04_JPRB,2.8551E-04_JPRB,3.0218E-04_JPRB,3.1138E-04_JPRB,3.1364E-04_JPRB,&
&3.0933E-04_JPRB,2.9596E-04_JPRB,2.5360E-04_JPRB/)
KAO( :, 3, 4, 6) = (/&
&2.0244E-04_JPRB,2.6111E-04_JPRB,2.9172E-04_JPRB,3.1073E-04_JPRB,3.2138E-04_JPRB,3.2408E-04_JPRB,&
&3.2030E-04_JPRB,3.0766E-04_JPRB,2.6380E-04_JPRB/)
KAO( :, 4, 4, 6) = (/&
&2.0501E-04_JPRB,2.6640E-04_JPRB,2.9889E-04_JPRB,3.1956E-04_JPRB,3.3116E-04_JPRB,3.3435E-04_JPRB,&
&3.3120E-04_JPRB,3.1983E-04_JPRB,2.7551E-04_JPRB/)
KAO( :, 5, 4, 6) = (/&
&2.0836E-04_JPRB,2.7264E-04_JPRB,3.0721E-04_JPRB,3.2917E-04_JPRB,3.4139E-04_JPRB,3.4585E-04_JPRB,&
&3.4342E-04_JPRB,3.3321E-04_JPRB,2.8833E-04_JPRB/)
KAO( :, 1, 5, 6) = (/&
&1.8177E-04_JPRB,2.3005E-04_JPRB,2.5216E-04_JPRB,2.6400E-04_JPRB,2.6980E-04_JPRB,2.6977E-04_JPRB,&
&2.6270E-04_JPRB,2.4807E-04_JPRB,2.1566E-04_JPRB/)
KAO( :, 2, 5, 6) = (/&
&1.8288E-04_JPRB,2.3456E-04_JPRB,2.5850E-04_JPRB,2.7178E-04_JPRB,2.7838E-04_JPRB,2.7918E-04_JPRB,&
&2.7326E-04_JPRB,2.5893E-04_JPRB,2.2464E-04_JPRB/)
KAO( :, 3, 5, 6) = (/&
&1.8495E-04_JPRB,2.3899E-04_JPRB,2.6446E-04_JPRB,2.7972E-04_JPRB,2.8778E-04_JPRB,2.8887E-04_JPRB,&
&2.8352E-04_JPRB,2.6965E-04_JPRB,2.3371E-04_JPRB/)
KAO( :, 4, 5, 6) = (/&
&1.8757E-04_JPRB,2.4389E-04_JPRB,2.7104E-04_JPRB,2.8807E-04_JPRB,2.9709E-04_JPRB,2.9855E-04_JPRB,&
&2.9335E-04_JPRB,2.8065E-04_JPRB,2.4386E-04_JPRB/)
KAO( :, 5, 5, 6) = (/&
&1.9089E-04_JPRB,2.4987E-04_JPRB,2.7871E-04_JPRB,2.9704E-04_JPRB,3.0660E-04_JPRB,3.0888E-04_JPRB,&
&3.0414E-04_JPRB,2.9240E-04_JPRB,2.5489E-04_JPRB/)
KAO( :, 1, 6, 6) = (/&
&1.6548E-04_JPRB,2.0845E-04_JPRB,2.2667E-04_JPRB,2.3621E-04_JPRB,2.3998E-04_JPRB,2.3852E-04_JPRB,&
&2.3181E-04_JPRB,2.1713E-04_JPRB,1.9774E-04_JPRB/)
KAO( :, 2, 6, 6) = (/&
&1.6647E-04_JPRB,2.1295E-04_JPRB,2.3285E-04_JPRB,2.4356E-04_JPRB,2.4798E-04_JPRB,2.4711E-04_JPRB,&
&2.4086E-04_JPRB,2.2656E-04_JPRB,2.0619E-04_JPRB/)
KAO( :, 3, 6, 6) = (/&
&1.6832E-04_JPRB,2.1735E-04_JPRB,2.3897E-04_JPRB,2.5101E-04_JPRB,2.5638E-04_JPRB,2.5608E-04_JPRB,&
&2.5005E-04_JPRB,2.3612E-04_JPRB,2.1472E-04_JPRB/)
KAO( :, 4, 6, 6) = (/&
&1.7090E-04_JPRB,2.2192E-04_JPRB,2.4527E-04_JPRB,2.5863E-04_JPRB,2.6479E-04_JPRB,2.6498E-04_JPRB,&
&2.5909E-04_JPRB,2.4595E-04_JPRB,2.2382E-04_JPRB/)
KAO( :, 5, 6, 6) = (/&
&1.7392E-04_JPRB,2.2728E-04_JPRB,2.5204E-04_JPRB,2.6653E-04_JPRB,2.7329E-04_JPRB,2.7417E-04_JPRB,&
&2.6871E-04_JPRB,2.5622E-04_JPRB,2.3379E-04_JPRB/)
KAO( :, 1, 7, 6) = (/&
&1.4974E-04_JPRB,1.8746E-04_JPRB,2.0303E-04_JPRB,2.1075E-04_JPRB,2.1306E-04_JPRB,2.1110E-04_JPRB,&
&2.0431E-04_JPRB,1.8998E-04_JPRB,1.9358E-04_JPRB/)
KAO( :, 2, 7, 6) = (/&
&1.5089E-04_JPRB,1.9183E-04_JPRB,2.0895E-04_JPRB,2.1750E-04_JPRB,2.2044E-04_JPRB,2.1873E-04_JPRB,&
&2.1228E-04_JPRB,1.9808E-04_JPRB,2.0012E-04_JPRB/)
KAO( :, 3, 7, 6) = (/&
&1.5257E-04_JPRB,1.9611E-04_JPRB,2.1478E-04_JPRB,2.2448E-04_JPRB,2.2805E-04_JPRB,2.2660E-04_JPRB,&
&2.2066E-04_JPRB,2.0672E-04_JPRB,2.0775E-04_JPRB/)
KAO( :, 4, 7, 6) = (/&
&1.5493E-04_JPRB,2.0056E-04_JPRB,2.2076E-04_JPRB,2.3152E-04_JPRB,2.3569E-04_JPRB,2.3461E-04_JPRB,&
&2.2897E-04_JPRB,2.1559E-04_JPRB,2.1605E-04_JPRB/)
KAO( :, 5, 7, 6) = (/&
&1.5774E-04_JPRB,2.0562E-04_JPRB,2.2715E-04_JPRB,2.3878E-04_JPRB,2.4330E-04_JPRB,2.4290E-04_JPRB,&
&2.3768E-04_JPRB,2.2474E-04_JPRB,2.2537E-04_JPRB/)
KAO( :, 1, 8, 6) = (/&
&1.3469E-04_JPRB,1.6768E-04_JPRB,1.8125E-04_JPRB,1.8765E-04_JPRB,1.8912E-04_JPRB,1.8647E-04_JPRB,&
&1.7925E-04_JPRB,1.6551E-04_JPRB,2.2549E-04_JPRB/)
KAO( :, 2, 8, 6) = (/&
&1.3601E-04_JPRB,1.7179E-04_JPRB,1.8676E-04_JPRB,1.9388E-04_JPRB,1.9601E-04_JPRB,1.9365E-04_JPRB,&
&1.8651E-04_JPRB,1.7268E-04_JPRB,2.2728E-04_JPRB/)
KAO( :, 3, 8, 6) = (/&
&1.3770E-04_JPRB,1.7606E-04_JPRB,1.9214E-04_JPRB,2.0024E-04_JPRB,2.0294E-04_JPRB,2.0077E-04_JPRB,&
&1.9394E-04_JPRB,1.8025E-04_JPRB,2.3037E-04_JPRB/)
KAO( :, 4, 8, 6) = (/&
&1.3980E-04_JPRB,1.8052E-04_JPRB,1.9782E-04_JPRB,2.0667E-04_JPRB,2.0985E-04_JPRB,2.0804E-04_JPRB,&
&2.0170E-04_JPRB,1.8820E-04_JPRB,2.3502E-04_JPRB/)
KAO( :, 5, 8, 6) = (/&
&1.4234E-04_JPRB,1.8549E-04_JPRB,2.0378E-04_JPRB,2.1326E-04_JPRB,2.1685E-04_JPRB,2.1554E-04_JPRB,&
&2.0965E-04_JPRB,1.9644E-04_JPRB,2.4136E-04_JPRB/)
KAO( :, 1, 9, 6) = (/&
&1.1992E-04_JPRB,1.4933E-04_JPRB,1.6105E-04_JPRB,1.6671E-04_JPRB,1.6730E-04_JPRB,1.6393E-04_JPRB,&
&1.5666E-04_JPRB,1.4342E-04_JPRB,4.8653E-04_JPRB/)
KAO( :, 2, 9, 6) = (/&
&1.2149E-04_JPRB,1.5326E-04_JPRB,1.6624E-04_JPRB,1.7247E-04_JPRB,1.7376E-04_JPRB,1.7057E-04_JPRB,&
&1.6339E-04_JPRB,1.5015E-04_JPRB,4.7263E-04_JPRB/)
KAO( :, 3, 9, 6) = (/&
&1.2314E-04_JPRB,1.5738E-04_JPRB,1.7131E-04_JPRB,1.7818E-04_JPRB,1.8004E-04_JPRB,1.7724E-04_JPRB,&
&1.6998E-04_JPRB,1.5688E-04_JPRB,4.6122E-04_JPRB/)
KAO( :, 4, 9, 6) = (/&
&1.2514E-04_JPRB,1.6177E-04_JPRB,1.7650E-04_JPRB,1.8400E-04_JPRB,1.8641E-04_JPRB,1.8403E-04_JPRB,&
&1.7684E-04_JPRB,1.6385E-04_JPRB,4.5149E-04_JPRB/)
KAO( :, 5, 9, 6) = (/&
&1.2748E-04_JPRB,1.6660E-04_JPRB,1.8214E-04_JPRB,1.9005E-04_JPRB,1.9284E-04_JPRB,1.9097E-04_JPRB,&
&1.8405E-04_JPRB,1.7111E-04_JPRB,4.4363E-04_JPRB/)
KAO( :, 1,10, 6) = (/&
&1.0584E-04_JPRB,1.3236E-04_JPRB,1.4288E-04_JPRB,1.4761E-04_JPRB,1.4780E-04_JPRB,1.4423E-04_JPRB,&
&1.3667E-04_JPRB,1.2400E-04_JPRB,1.5407E-03_JPRB/)
KAO( :, 2,10, 6) = (/&
&1.0748E-04_JPRB,1.3619E-04_JPRB,1.4771E-04_JPRB,1.5305E-04_JPRB,1.5361E-04_JPRB,1.5017E-04_JPRB,&
&1.4291E-04_JPRB,1.3024E-04_JPRB,1.4707E-03_JPRB/)
KAO( :, 3,10, 6) = (/&
&1.0916E-04_JPRB,1.4012E-04_JPRB,1.5258E-04_JPRB,1.5840E-04_JPRB,1.5929E-04_JPRB,1.5625E-04_JPRB,&
&1.4913E-04_JPRB,1.3639E-04_JPRB,1.4078E-03_JPRB/)
KAO( :, 4,10, 6) = (/&
&1.1108E-04_JPRB,1.4432E-04_JPRB,1.5744E-04_JPRB,1.6378E-04_JPRB,1.6514E-04_JPRB,1.6251E-04_JPRB,&
&1.5541E-04_JPRB,1.4254E-04_JPRB,1.3501E-03_JPRB/)
KAO( :, 5,10, 6) = (/&
&1.1328E-04_JPRB,1.4893E-04_JPRB,1.6265E-04_JPRB,1.6934E-04_JPRB,1.7119E-04_JPRB,1.6880E-04_JPRB,&
&1.6190E-04_JPRB,1.4900E-04_JPRB,1.2982E-03_JPRB/)
KAO( :, 1,11, 6) = (/&
&9.3489E-05_JPRB,1.1825E-04_JPRB,1.2805E-04_JPRB,1.3224E-04_JPRB,1.3232E-04_JPRB,1.2873E-04_JPRB,&
&1.2131E-04_JPRB,1.0918E-04_JPRB,2.0757E-03_JPRB/)
KAO( :, 2,11, 6) = (/&
&9.5099E-05_JPRB,1.2195E-04_JPRB,1.3268E-04_JPRB,1.3732E-04_JPRB,1.3748E-04_JPRB,1.3414E-04_JPRB,&
&1.2695E-04_JPRB,1.1489E-04_JPRB,1.9797E-03_JPRB/)
KAO( :, 3,11, 6) = (/&
&9.6804E-05_JPRB,1.2575E-04_JPRB,1.3731E-04_JPRB,1.4230E-04_JPRB,1.4278E-04_JPRB,1.3973E-04_JPRB,&
&1.3283E-04_JPRB,1.2047E-04_JPRB,1.8901E-03_JPRB/)
KAO( :, 4,11, 6) = (/&
&9.8710E-05_JPRB,1.2986E-04_JPRB,1.4205E-04_JPRB,1.4740E-04_JPRB,1.4826E-04_JPRB,1.4548E-04_JPRB,&
&1.3868E-04_JPRB,1.2603E-04_JPRB,1.8079E-03_JPRB/)
KAO( :, 5,11, 6) = (/&
&1.0095E-04_JPRB,1.3435E-04_JPRB,1.4704E-04_JPRB,1.5275E-04_JPRB,1.5397E-04_JPRB,1.5141E-04_JPRB,&
&1.4471E-04_JPRB,1.3186E-04_JPRB,1.7340E-03_JPRB/)
KAO( :, 1,12, 6) = (/&
&8.2093E-05_JPRB,1.0522E-04_JPRB,1.1410E-04_JPRB,1.1782E-04_JPRB,1.1761E-04_JPRB,1.1416E-04_JPRB,&
&1.0724E-04_JPRB,9.5735E-05_JPRB,2.1586E-03_JPRB/)
KAO( :, 2,12, 6) = (/&
&8.3669E-05_JPRB,1.0871E-04_JPRB,1.1846E-04_JPRB,1.2251E-04_JPRB,1.2240E-04_JPRB,1.1908E-04_JPRB,&
&1.1234E-04_JPRB,1.0091E-04_JPRB,2.0547E-03_JPRB/)
KAO( :, 3,12, 6) = (/&
&8.5301E-05_JPRB,1.1235E-04_JPRB,1.2282E-04_JPRB,1.2721E-04_JPRB,1.2738E-04_JPRB,1.2431E-04_JPRB,&
&1.1770E-04_JPRB,1.0601E-04_JPRB,1.9599E-03_JPRB/)
KAO( :, 4,12, 6) = (/&
&8.7242E-05_JPRB,1.1626E-04_JPRB,1.2740E-04_JPRB,1.3207E-04_JPRB,1.3252E-04_JPRB,1.2966E-04_JPRB,&
&1.2318E-04_JPRB,1.1105E-04_JPRB,1.8736E-03_JPRB/)
KAO( :, 5,12, 6) = (/&
&8.9569E-05_JPRB,1.2041E-04_JPRB,1.3214E-04_JPRB,1.3715E-04_JPRB,1.3802E-04_JPRB,1.3533E-04_JPRB,&
&1.2876E-04_JPRB,1.1627E-04_JPRB,1.7949E-03_JPRB/)
KAO( :, 1,13, 6) = (/&
&7.1569E-05_JPRB,9.3060E-05_JPRB,1.0102E-04_JPRB,1.0423E-04_JPRB,1.0388E-04_JPRB,1.0052E-04_JPRB,&
&9.4174E-05_JPRB,8.3531E-05_JPRB,1.8351E-03_JPRB/)
KAO( :, 2,13, 6) = (/&
&7.3011E-05_JPRB,9.6373E-05_JPRB,1.0503E-04_JPRB,1.0856E-04_JPRB,1.0834E-04_JPRB,1.0508E-04_JPRB,&
&9.8836E-05_JPRB,8.8176E-05_JPRB,1.7459E-03_JPRB/)
KAO( :, 3,13, 6) = (/&
&7.4663E-05_JPRB,9.9794E-05_JPRB,1.0913E-04_JPRB,1.1298E-04_JPRB,1.1299E-04_JPRB,1.0991E-04_JPRB,&
&1.0372E-04_JPRB,9.2787E-05_JPRB,1.6660E-03_JPRB/)
KAO( :, 4,13, 6) = (/&
&7.6630E-05_JPRB,1.0344E-04_JPRB,1.1345E-04_JPRB,1.1756E-04_JPRB,1.1782E-04_JPRB,1.1495E-04_JPRB,&
&1.0877E-04_JPRB,9.7412E-05_JPRB,1.5932E-03_JPRB/)
KAO( :, 5,13, 6) = (/&
&7.9007E-05_JPRB,1.0733E-04_JPRB,1.1787E-04_JPRB,1.2235E-04_JPRB,1.2303E-04_JPRB,1.2033E-04_JPRB,&
&1.1390E-04_JPRB,1.0206E-04_JPRB,1.5265E-03_JPRB/)
KAO( :, 1, 1, 7) = (/&
&4.6305E-04_JPRB,5.4556E-04_JPRB,6.0200E-04_JPRB,6.4863E-04_JPRB,6.8107E-04_JPRB,7.0420E-04_JPRB,&
&7.2199E-04_JPRB,7.3085E-04_JPRB,6.7646E-04_JPRB/)
KAO( :, 2, 1, 7) = (/&
&4.6301E-04_JPRB,5.5700E-04_JPRB,6.1674E-04_JPRB,6.6918E-04_JPRB,7.0683E-04_JPRB,7.3382E-04_JPRB,&
&7.5720E-04_JPRB,7.6870E-04_JPRB,7.1353E-04_JPRB/)
KAO( :, 3, 1, 7) = (/&
&4.6454E-04_JPRB,5.7050E-04_JPRB,6.3324E-04_JPRB,6.9016E-04_JPRB,7.3249E-04_JPRB,7.6632E-04_JPRB,&
&7.9567E-04_JPRB,8.0915E-04_JPRB,7.5224E-04_JPRB/)
KAO( :, 4, 1, 7) = (/&
&4.6651E-04_JPRB,5.8405E-04_JPRB,6.4895E-04_JPRB,7.1069E-04_JPRB,7.5837E-04_JPRB,7.9949E-04_JPRB,&
&8.3506E-04_JPRB,8.5087E-04_JPRB,7.9164E-04_JPRB/)
KAO( :, 5, 1, 7) = (/&
&4.7034E-04_JPRB,5.9930E-04_JPRB,6.6683E-04_JPRB,7.3355E-04_JPRB,7.8609E-04_JPRB,8.3312E-04_JPRB,&
&8.7517E-04_JPRB,8.9333E-04_JPRB,8.3199E-04_JPRB/)
KAO( :, 1, 2, 7) = (/&
&4.3178E-04_JPRB,5.0967E-04_JPRB,5.7208E-04_JPRB,6.1793E-04_JPRB,6.4678E-04_JPRB,6.6138E-04_JPRB,&
&6.6815E-04_JPRB,6.6568E-04_JPRB,5.9744E-04_JPRB/)
KAO( :, 2, 2, 7) = (/&
&4.3227E-04_JPRB,5.2067E-04_JPRB,5.8785E-04_JPRB,6.3795E-04_JPRB,6.7133E-04_JPRB,6.9007E-04_JPRB,&
&7.0100E-04_JPRB,7.0211E-04_JPRB,6.3355E-04_JPRB/)
KAO( :, 3, 2, 7) = (/&
&4.3414E-04_JPRB,5.3362E-04_JPRB,6.0473E-04_JPRB,6.5841E-04_JPRB,6.9567E-04_JPRB,7.2097E-04_JPRB,&
&7.3754E-04_JPRB,7.4189E-04_JPRB,6.7066E-04_JPRB/)
KAO( :, 4, 2, 7) = (/&
&4.3688E-04_JPRB,5.4677E-04_JPRB,6.2106E-04_JPRB,6.7900E-04_JPRB,7.2053E-04_JPRB,7.5255E-04_JPRB,&
&7.7596E-04_JPRB,7.8317E-04_JPRB,7.0771E-04_JPRB/)
KAO( :, 5, 2, 7) = (/&
&4.4026E-04_JPRB,5.6009E-04_JPRB,6.3723E-04_JPRB,6.9996E-04_JPRB,7.4621E-04_JPRB,7.8382E-04_JPRB,&
&8.1411E-04_JPRB,8.2479E-04_JPRB,7.4663E-04_JPRB/)
KAO( :, 1, 3, 7) = (/&
&4.0042E-04_JPRB,4.7588E-04_JPRB,5.3737E-04_JPRB,5.7848E-04_JPRB,6.0266E-04_JPRB,6.1092E-04_JPRB,&
&6.0756E-04_JPRB,5.9389E-04_JPRB,5.1726E-04_JPRB/)
KAO( :, 2, 3, 7) = (/&
&4.0139E-04_JPRB,4.8636E-04_JPRB,5.5256E-04_JPRB,5.9842E-04_JPRB,6.2668E-04_JPRB,6.3795E-04_JPRB,&
&6.3723E-04_JPRB,6.2673E-04_JPRB,5.4890E-04_JPRB/)
KAO( :, 3, 3, 7) = (/&
&4.0264E-04_JPRB,4.9818E-04_JPRB,5.6878E-04_JPRB,6.1775E-04_JPRB,6.4985E-04_JPRB,6.6625E-04_JPRB,&
&6.6960E-04_JPRB,6.6297E-04_JPRB,5.8203E-04_JPRB/)
KAO( :, 4, 3, 7) = (/&
&4.0594E-04_JPRB,5.1098E-04_JPRB,5.8559E-04_JPRB,6.3812E-04_JPRB,6.7417E-04_JPRB,6.9560E-04_JPRB,&
&7.0436E-04_JPRB,7.0139E-04_JPRB,6.1550E-04_JPRB/)
KAO( :, 5, 3, 7) = (/&
&4.0942E-04_JPRB,5.2279E-04_JPRB,6.0106E-04_JPRB,6.5810E-04_JPRB,6.9804E-04_JPRB,7.2431E-04_JPRB,&
&7.3907E-04_JPRB,7.3980E-04_JPRB,6.5087E-04_JPRB/)
KAO( :, 1, 4, 7) = (/&
&3.6954E-04_JPRB,4.4390E-04_JPRB,4.9967E-04_JPRB,5.3490E-04_JPRB,5.5341E-04_JPRB,5.5728E-04_JPRB,&
&5.4744E-04_JPRB,5.2585E-04_JPRB,4.5076E-04_JPRB/)
KAO( :, 2, 4, 7) = (/&
&3.7099E-04_JPRB,4.5452E-04_JPRB,5.1452E-04_JPRB,5.5410E-04_JPRB,5.7617E-04_JPRB,5.8227E-04_JPRB,&
&5.7394E-04_JPRB,5.5446E-04_JPRB,4.7750E-04_JPRB/)
KAO( :, 3, 4, 7) = (/&
&3.7261E-04_JPRB,4.6594E-04_JPRB,5.3039E-04_JPRB,5.7264E-04_JPRB,5.9783E-04_JPRB,6.0838E-04_JPRB,&
&6.0270E-04_JPRB,5.8596E-04_JPRB,5.0606E-04_JPRB/)
KAO( :, 4, 4, 7) = (/&
&3.7542E-04_JPRB,4.7733E-04_JPRB,5.4631E-04_JPRB,5.9142E-04_JPRB,6.2021E-04_JPRB,6.3532E-04_JPRB,&
&6.3302E-04_JPRB,6.1929E-04_JPRB,5.3494E-04_JPRB/)
KAO( :, 5, 4, 7) = (/&
&3.7994E-04_JPRB,4.8922E-04_JPRB,5.6238E-04_JPRB,6.1134E-04_JPRB,6.4405E-04_JPRB,6.6206E-04_JPRB,&
&6.6409E-04_JPRB,6.5333E-04_JPRB,5.6564E-04_JPRB/)
KAO( :, 1, 5, 7) = (/&
&3.4061E-04_JPRB,4.1228E-04_JPRB,4.6040E-04_JPRB,4.8986E-04_JPRB,5.0320E-04_JPRB,5.0314E-04_JPRB,&
&4.9155E-04_JPRB,4.6563E-04_JPRB,3.9708E-04_JPRB/)
KAO( :, 2, 5, 7) = (/&
&3.4265E-04_JPRB,4.2238E-04_JPRB,4.7497E-04_JPRB,5.0787E-04_JPRB,5.2436E-04_JPRB,5.2638E-04_JPRB,&
&5.1586E-04_JPRB,4.9074E-04_JPRB,4.1980E-04_JPRB/)
KAO( :, 3, 5, 7) = (/&
&3.4457E-04_JPRB,4.3316E-04_JPRB,4.9022E-04_JPRB,5.2547E-04_JPRB,5.4476E-04_JPRB,5.5018E-04_JPRB,&
&5.4131E-04_JPRB,5.1767E-04_JPRB,4.4445E-04_JPRB/)
KAO( :, 4, 5, 7) = (/&
&3.4732E-04_JPRB,4.4421E-04_JPRB,5.0540E-04_JPRB,5.4314E-04_JPRB,5.6518E-04_JPRB,5.7439E-04_JPRB,&
&5.6831E-04_JPRB,5.4593E-04_JPRB,4.6962E-04_JPRB/)
KAO( :, 5, 5, 7) = (/&
&3.5182E-04_JPRB,4.5580E-04_JPRB,5.2093E-04_JPRB,5.6187E-04_JPRB,5.8688E-04_JPRB,5.9917E-04_JPRB,&
&5.9551E-04_JPRB,5.7498E-04_JPRB,4.9655E-04_JPRB/)
KAO( :, 1, 6, 7) = (/&
&3.1397E-04_JPRB,3.8099E-04_JPRB,4.2085E-04_JPRB,4.4392E-04_JPRB,4.5344E-04_JPRB,4.5128E-04_JPRB,&
&4.3795E-04_JPRB,4.1046E-04_JPRB,3.5811E-04_JPRB/)
KAO( :, 2, 6, 7) = (/&
&3.1655E-04_JPRB,3.9053E-04_JPRB,4.3489E-04_JPRB,4.6069E-04_JPRB,4.7295E-04_JPRB,4.7284E-04_JPRB,&
&4.6063E-04_JPRB,4.3290E-04_JPRB,3.7673E-04_JPRB/)
KAO( :, 3, 6, 7) = (/&
&3.1898E-04_JPRB,4.0060E-04_JPRB,4.4896E-04_JPRB,4.7714E-04_JPRB,4.9199E-04_JPRB,4.9458E-04_JPRB,&
&4.8353E-04_JPRB,4.5629E-04_JPRB,3.9672E-04_JPRB/)
KAO( :, 4, 6, 7) = (/&
&3.2158E-04_JPRB,4.1129E-04_JPRB,4.6291E-04_JPRB,4.9376E-04_JPRB,5.1129E-04_JPRB,5.1624E-04_JPRB,&
&5.0719E-04_JPRB,4.8049E-04_JPRB,4.1801E-04_JPRB/)
KAO( :, 5, 6, 7) = (/&
&3.2502E-04_JPRB,4.2183E-04_JPRB,4.7677E-04_JPRB,5.1073E-04_JPRB,5.3095E-04_JPRB,5.3777E-04_JPRB,&
&5.3107E-04_JPRB,5.0560E-04_JPRB,4.4095E-04_JPRB/)
KAO( :, 1, 7, 7) = (/&
&2.8858E-04_JPRB,3.5072E-04_JPRB,3.8244E-04_JPRB,3.9969E-04_JPRB,4.0628E-04_JPRB,4.0266E-04_JPRB,&
&3.8820E-04_JPRB,3.6095E-04_JPRB,3.4917E-04_JPRB/)
KAO( :, 2, 7, 7) = (/&
&2.9154E-04_JPRB,3.5995E-04_JPRB,3.9513E-04_JPRB,4.1562E-04_JPRB,4.2428E-04_JPRB,4.2225E-04_JPRB,&
&4.0848E-04_JPRB,3.8100E-04_JPRB,3.6556E-04_JPRB/)
KAO( :, 3, 7, 7) = (/&
&2.9427E-04_JPRB,3.6955E-04_JPRB,4.0818E-04_JPRB,4.3070E-04_JPRB,4.4206E-04_JPRB,4.4209E-04_JPRB,&
&4.2902E-04_JPRB,4.0153E-04_JPRB,3.8273E-04_JPRB/)
KAO( :, 4, 7, 7) = (/&
&2.9693E-04_JPRB,3.7937E-04_JPRB,4.2130E-04_JPRB,4.4602E-04_JPRB,4.5975E-04_JPRB,4.6189E-04_JPRB,&
&4.5029E-04_JPRB,4.2249E-04_JPRB,4.0122E-04_JPRB/)
KAO( :, 5, 7, 7) = (/&
&3.0032E-04_JPRB,3.8893E-04_JPRB,4.3431E-04_JPRB,4.6164E-04_JPRB,4.7805E-04_JPRB,4.8151E-04_JPRB,&
&4.7139E-04_JPRB,4.4430E-04_JPRB,4.2113E-04_JPRB/)
KAO( :, 1, 8, 7) = (/&
&2.6433E-04_JPRB,3.2164E-04_JPRB,3.4678E-04_JPRB,3.5895E-04_JPRB,3.6313E-04_JPRB,3.5828E-04_JPRB,&
&3.4379E-04_JPRB,3.1784E-04_JPRB,3.8325E-04_JPRB/)
KAO( :, 2, 8, 7) = (/&
&2.6764E-04_JPRB,3.3079E-04_JPRB,3.5818E-04_JPRB,3.7326E-04_JPRB,3.7969E-04_JPRB,3.7570E-04_JPRB,&
&3.6173E-04_JPRB,3.3531E-04_JPRB,3.9627E-04_JPRB/)
KAO( :, 3, 8, 7) = (/&
&2.7049E-04_JPRB,3.3967E-04_JPRB,3.6984E-04_JPRB,3.8764E-04_JPRB,3.9567E-04_JPRB,3.9347E-04_JPRB,&
&3.7992E-04_JPRB,3.5345E-04_JPRB,4.1157E-04_JPRB/)
KAO( :, 4, 8, 7) = (/&
&2.7332E-04_JPRB,3.4840E-04_JPRB,3.8188E-04_JPRB,4.0186E-04_JPRB,4.1166E-04_JPRB,4.1115E-04_JPRB,&
&3.9867E-04_JPRB,3.7201E-04_JPRB,4.2882E-04_JPRB/)
KAO( :, 5, 8, 7) = (/&
&2.7670E-04_JPRB,3.5697E-04_JPRB,3.9392E-04_JPRB,4.1633E-04_JPRB,4.2814E-04_JPRB,4.2877E-04_JPRB,&
&4.1760E-04_JPRB,3.9091E-04_JPRB,4.4711E-04_JPRB/)
KAO( :, 1, 9, 7) = (/&
&2.4137E-04_JPRB,2.9350E-04_JPRB,3.1375E-04_JPRB,3.2233E-04_JPRB,3.2400E-04_JPRB,3.1859E-04_JPRB,&
&3.0441E-04_JPRB,2.7946E-04_JPRB,7.4112E-04_JPRB/)
KAO( :, 2, 9, 7) = (/&
&2.4480E-04_JPRB,3.0210E-04_JPRB,3.2420E-04_JPRB,3.3517E-04_JPRB,3.3871E-04_JPRB,3.3414E-04_JPRB,&
&3.2021E-04_JPRB,2.9498E-04_JPRB,7.2877E-04_JPRB/)
KAO( :, 3, 9, 7) = (/&
&2.4785E-04_JPRB,3.1022E-04_JPRB,3.3497E-04_JPRB,3.4812E-04_JPRB,3.5338E-04_JPRB,3.4970E-04_JPRB,&
&3.3648E-04_JPRB,3.1095E-04_JPRB,7.2183E-04_JPRB/)
KAO( :, 4, 9, 7) = (/&
&2.5068E-04_JPRB,3.1830E-04_JPRB,3.4602E-04_JPRB,3.6150E-04_JPRB,3.6764E-04_JPRB,3.6525E-04_JPRB,&
&3.5301E-04_JPRB,3.2741E-04_JPRB,7.2069E-04_JPRB/)
KAO( :, 5, 9, 7) = (/&
&2.5395E-04_JPRB,3.2629E-04_JPRB,3.5706E-04_JPRB,3.7496E-04_JPRB,3.8230E-04_JPRB,3.8101E-04_JPRB,&
&3.6964E-04_JPRB,3.4426E-04_JPRB,7.2393E-04_JPRB/)
KAO( :, 1,10, 7) = (/&
&2.1916E-04_JPRB,2.6728E-04_JPRB,2.8357E-04_JPRB,2.9003E-04_JPRB,2.9019E-04_JPRB,2.8394E-04_JPRB,&
&2.6987E-04_JPRB,2.4557E-04_JPRB,2.2951E-03_JPRB/)
KAO( :, 2,10, 7) = (/&
&2.2269E-04_JPRB,2.7508E-04_JPRB,2.9328E-04_JPRB,3.0170E-04_JPRB,3.0330E-04_JPRB,2.9810E-04_JPRB,&
&2.8439E-04_JPRB,2.5963E-04_JPRB,2.1937E-03_JPRB/)
KAO( :, 3,10, 7) = (/&
&2.2592E-04_JPRB,2.8247E-04_JPRB,3.0321E-04_JPRB,3.1354E-04_JPRB,3.1659E-04_JPRB,3.1208E-04_JPRB,&
&2.9880E-04_JPRB,2.7415E-04_JPRB,2.1089E-03_JPRB/)
KAO( :, 4,10, 7) = (/&
&2.2891E-04_JPRB,2.8992E-04_JPRB,3.1332E-04_JPRB,3.2558E-04_JPRB,3.2968E-04_JPRB,3.2576E-04_JPRB,&
&3.1353E-04_JPRB,2.8898E-04_JPRB,2.0353E-03_JPRB/)
KAO( :, 5,10, 7) = (/&
&2.3224E-04_JPRB,2.9740E-04_JPRB,3.2354E-04_JPRB,3.3796E-04_JPRB,3.4280E-04_JPRB,3.3971E-04_JPRB,&
&3.2827E-04_JPRB,3.0414E-04_JPRB,1.9694E-03_JPRB/)
KAO( :, 1,11, 7) = (/&
&1.9917E-04_JPRB,2.4536E-04_JPRB,2.5993E-04_JPRB,2.6557E-04_JPRB,2.6515E-04_JPRB,2.5837E-04_JPRB,&
&2.4462E-04_JPRB,2.2066E-04_JPRB,3.1341E-03_JPRB/)
KAO( :, 2,11, 7) = (/&
&2.0264E-04_JPRB,2.5224E-04_JPRB,2.6895E-04_JPRB,2.7632E-04_JPRB,2.7737E-04_JPRB,2.7142E-04_JPRB,&
&2.5767E-04_JPRB,2.3346E-04_JPRB,2.9845E-03_JPRB/)
KAO( :, 3,11, 7) = (/&
&2.0597E-04_JPRB,2.5913E-04_JPRB,2.7799E-04_JPRB,2.8723E-04_JPRB,2.8930E-04_JPRB,2.8411E-04_JPRB,&
&2.7068E-04_JPRB,2.4666E-04_JPRB,2.8531E-03_JPRB/)
KAO( :, 4,11, 7) = (/&
&2.0923E-04_JPRB,2.6606E-04_JPRB,2.8717E-04_JPRB,2.9817E-04_JPRB,3.0130E-04_JPRB,2.9662E-04_JPRB,&
&2.8382E-04_JPRB,2.6011E-04_JPRB,2.7344E-03_JPRB/)
KAO( :, 5,11, 7) = (/&
&2.1283E-04_JPRB,2.7325E-04_JPRB,2.9677E-04_JPRB,3.0938E-04_JPRB,3.1326E-04_JPRB,3.0919E-04_JPRB,&
&2.9712E-04_JPRB,2.7384E-04_JPRB,2.6277E-03_JPRB/)
KAO( :, 1,12, 7) = (/&
&1.7936E-04_JPRB,2.2328E-04_JPRB,2.3724E-04_JPRB,2.4243E-04_JPRB,2.4172E-04_JPRB,2.3478E-04_JPRB,&
&2.2093E-04_JPRB,1.9737E-04_JPRB,3.2835E-03_JPRB/)
KAO( :, 2,12, 7) = (/&
&1.8285E-04_JPRB,2.2978E-04_JPRB,2.4543E-04_JPRB,2.5241E-04_JPRB,2.5294E-04_JPRB,2.4651E-04_JPRB,&
&2.3266E-04_JPRB,2.0912E-04_JPRB,3.1216E-03_JPRB/)
KAO( :, 3,12, 7) = (/&
&1.8634E-04_JPRB,2.3640E-04_JPRB,2.5382E-04_JPRB,2.6232E-04_JPRB,2.6378E-04_JPRB,2.5795E-04_JPRB,&
&2.4444E-04_JPRB,2.2095E-04_JPRB,2.9752E-03_JPRB/)
KAO( :, 4,12, 7) = (/&
&1.8978E-04_JPRB,2.4319E-04_JPRB,2.6232E-04_JPRB,2.7232E-04_JPRB,2.7477E-04_JPRB,2.6960E-04_JPRB,&
&2.5603E-04_JPRB,2.3306E-04_JPRB,2.8433E-03_JPRB/)
KAO( :, 5,12, 7) = (/&
&1.9368E-04_JPRB,2.5043E-04_JPRB,2.7137E-04_JPRB,2.8261E-04_JPRB,2.8588E-04_JPRB,2.8109E-04_JPRB,&
&2.6784E-04_JPRB,2.4548E-04_JPRB,2.7264E-03_JPRB/)
KAO( :, 1,13, 7) = (/&
&1.6014E-04_JPRB,2.0144E-04_JPRB,2.1482E-04_JPRB,2.1993E-04_JPRB,2.1918E-04_JPRB,2.1245E-04_JPRB,&
&1.9850E-04_JPRB,1.7572E-04_JPRB,2.8014E-03_JPRB/)
KAO( :, 2,13, 7) = (/&
&1.6372E-04_JPRB,2.0772E-04_JPRB,2.2263E-04_JPRB,2.2918E-04_JPRB,2.2929E-04_JPRB,2.2295E-04_JPRB,&
&2.0909E-04_JPRB,1.8627E-04_JPRB,2.6597E-03_JPRB/)
KAO( :, 3,13, 7) = (/&
&1.6711E-04_JPRB,2.1423E-04_JPRB,2.3053E-04_JPRB,2.3833E-04_JPRB,2.3922E-04_JPRB,2.3334E-04_JPRB,&
&2.1968E-04_JPRB,1.9695E-04_JPRB,2.5327E-03_JPRB/)
KAO( :, 4,13, 7) = (/&
&1.7075E-04_JPRB,2.2099E-04_JPRB,2.3863E-04_JPRB,2.4766E-04_JPRB,2.4941E-04_JPRB,2.4382E-04_JPRB,&
&2.3022E-04_JPRB,2.0776E-04_JPRB,2.4204E-03_JPRB/)
KAO( :, 5,13, 7) = (/&
&1.7481E-04_JPRB,2.2827E-04_JPRB,2.4735E-04_JPRB,2.5731E-04_JPRB,2.5972E-04_JPRB,2.5434E-04_JPRB,&
&2.4101E-04_JPRB,2.1916E-04_JPRB,2.3207E-03_JPRB/)
KAO( :, 1, 1, 8) = (/&
&9.5608E-04_JPRB,1.1137E-03_JPRB,1.1928E-03_JPRB,1.2676E-03_JPRB,1.3453E-03_JPRB,1.4201E-03_JPRB,&
&1.4858E-03_JPRB,1.4985E-03_JPRB,1.3296E-03_JPRB/)
KAO( :, 2, 1, 8) = (/&
&9.5994E-04_JPRB,1.1580E-03_JPRB,1.2586E-03_JPRB,1.3444E-03_JPRB,1.4304E-03_JPRB,1.5065E-03_JPRB,&
&1.5698E-03_JPRB,1.5822E-03_JPRB,1.4127E-03_JPRB/)
KAO( :, 3, 1, 8) = (/&
&9.6434E-04_JPRB,1.2039E-03_JPRB,1.3295E-03_JPRB,1.4283E-03_JPRB,1.5240E-03_JPRB,1.6021E-03_JPRB,&
&1.6610E-03_JPRB,1.6690E-03_JPRB,1.4964E-03_JPRB/)
KAO( :, 4, 1, 8) = (/&
&9.6594E-04_JPRB,1.2459E-03_JPRB,1.3992E-03_JPRB,1.5151E-03_JPRB,1.6213E-03_JPRB,1.7037E-03_JPRB,&
&1.7586E-03_JPRB,1.7581E-03_JPRB,1.5822E-03_JPRB/)
KAO( :, 5, 1, 8) = (/&
&9.7112E-04_JPRB,1.2922E-03_JPRB,1.4733E-03_JPRB,1.6088E-03_JPRB,1.7251E-03_JPRB,1.8137E-03_JPRB,&
&1.8637E-03_JPRB,1.8544E-03_JPRB,1.6729E-03_JPRB/)
KAO( :, 1, 2, 8) = (/&
&9.2093E-04_JPRB,1.0546E-03_JPRB,1.1184E-03_JPRB,1.1877E-03_JPRB,1.2677E-03_JPRB,1.3451E-03_JPRB,&
&1.4085E-03_JPRB,1.4282E-03_JPRB,1.2587E-03_JPRB/)
KAO( :, 2, 2, 8) = (/&
&9.2391E-04_JPRB,1.0934E-03_JPRB,1.1705E-03_JPRB,1.2485E-03_JPRB,1.3345E-03_JPRB,1.4205E-03_JPRB,&
&1.4904E-03_JPRB,1.5108E-03_JPRB,1.3375E-03_JPRB/)
KAO( :, 3, 2, 8) = (/&
&9.2775E-04_JPRB,1.1328E-03_JPRB,1.2272E-03_JPRB,1.3169E-03_JPRB,1.4101E-03_JPRB,1.5006E-03_JPRB,&
&1.5743E-03_JPRB,1.5928E-03_JPRB,1.4152E-03_JPRB/)
KAO( :, 4, 2, 8) = (/&
&9.3033E-04_JPRB,1.1705E-03_JPRB,1.2842E-03_JPRB,1.3889E-03_JPRB,1.4909E-03_JPRB,1.5847E-03_JPRB,&
&1.6559E-03_JPRB,1.6749E-03_JPRB,1.4953E-03_JPRB/)
KAO( :, 5, 2, 8) = (/&
&9.3350E-04_JPRB,1.2078E-03_JPRB,1.3426E-03_JPRB,1.4642E-03_JPRB,1.5755E-03_JPRB,1.6738E-03_JPRB,&
&1.7416E-03_JPRB,1.7599E-03_JPRB,1.5794E-03_JPRB/)
KAO( :, 1, 3, 8) = (/&
&8.8225E-04_JPRB,9.9524E-04_JPRB,1.0564E-03_JPRB,1.1307E-03_JPRB,1.2003E-03_JPRB,1.2591E-03_JPRB,&
&1.3108E-03_JPRB,1.3309E-03_JPRB,1.1549E-03_JPRB/)
KAO( :, 2, 3, 8) = (/&
&8.8537E-04_JPRB,1.0284E-03_JPRB,1.0990E-03_JPRB,1.1784E-03_JPRB,1.2595E-03_JPRB,1.3310E-03_JPRB,&
&1.3892E-03_JPRB,1.4138E-03_JPRB,1.2306E-03_JPRB/)
KAO( :, 3, 3, 8) = (/&
&8.8781E-04_JPRB,1.0600E-03_JPRB,1.1442E-03_JPRB,1.2314E-03_JPRB,1.3222E-03_JPRB,1.4061E-03_JPRB,&
&1.4693E-03_JPRB,1.4932E-03_JPRB,1.3048E-03_JPRB/)
KAO( :, 4, 3, 8) = (/&
&8.9189E-04_JPRB,1.0939E-03_JPRB,1.1921E-03_JPRB,1.2907E-03_JPRB,1.3886E-03_JPRB,1.4820E-03_JPRB,&
&1.5492E-03_JPRB,1.5703E-03_JPRB,1.3811E-03_JPRB/)
KAO( :, 5, 3, 8) = (/&
&8.9438E-04_JPRB,1.1258E-03_JPRB,1.2397E-03_JPRB,1.3504E-03_JPRB,1.4556E-03_JPRB,1.5581E-03_JPRB,&
&1.6301E-03_JPRB,1.6498E-03_JPRB,1.4607E-03_JPRB/)
KAO( :, 1, 4, 8) = (/&
&8.3849E-04_JPRB,9.3566E-04_JPRB,1.0099E-03_JPRB,1.0816E-03_JPRB,1.1344E-03_JPRB,1.1752E-03_JPRB,&
&1.2048E-03_JPRB,1.2139E-03_JPRB,1.0399E-03_JPRB/)
KAO( :, 2, 4, 8) = (/&
&8.4244E-04_JPRB,9.6570E-04_JPRB,1.0454E-03_JPRB,1.1259E-03_JPRB,1.1888E-03_JPRB,1.2423E-03_JPRB,&
&1.2800E-03_JPRB,1.2943E-03_JPRB,1.1122E-03_JPRB/)
KAO( :, 3, 4, 8) = (/&
&8.4472E-04_JPRB,9.9456E-04_JPRB,1.0829E-03_JPRB,1.1722E-03_JPRB,1.2472E-03_JPRB,1.3102E-03_JPRB,&
&1.3565E-03_JPRB,1.3722E-03_JPRB,1.1831E-03_JPRB/)
KAO( :, 4, 4, 8) = (/&
&8.4703E-04_JPRB,1.0229E-03_JPRB,1.1215E-03_JPRB,1.2221E-03_JPRB,1.3077E-03_JPRB,1.3778E-03_JPRB,&
&1.4318E-03_JPRB,1.4488E-03_JPRB,1.2549E-03_JPRB/)
KAO( :, 5, 4, 8) = (/&
&8.5239E-04_JPRB,1.0541E-03_JPRB,1.1634E-03_JPRB,1.2735E-03_JPRB,1.3695E-03_JPRB,1.4485E-03_JPRB,&
&1.5090E-03_JPRB,1.5277E-03_JPRB,1.3292E-03_JPRB/)
KAO( :, 1, 5, 8) = (/&
&7.9083E-04_JPRB,8.8170E-04_JPRB,9.6674E-04_JPRB,1.0299E-03_JPRB,1.0698E-03_JPRB,1.0915E-03_JPRB,&
&1.0968E-03_JPRB,1.0912E-03_JPRB,9.3090E-04_JPRB/)
KAO( :, 2, 5, 8) = (/&
&7.9562E-04_JPRB,9.0868E-04_JPRB,9.9995E-04_JPRB,1.0720E-03_JPRB,1.1213E-03_JPRB,1.1526E-03_JPRB,&
&1.1662E-03_JPRB,1.1662E-03_JPRB,9.9625E-04_JPRB/)
KAO( :, 3, 5, 8) = (/&
&7.9829E-04_JPRB,9.3547E-04_JPRB,1.0342E-03_JPRB,1.1161E-03_JPRB,1.1759E-03_JPRB,1.2152E-03_JPRB,&
&1.2368E-03_JPRB,1.2405E-03_JPRB,1.0609E-03_JPRB/)
KAO( :, 4, 5, 8) = (/&
&8.0091E-04_JPRB,9.6089E-04_JPRB,1.0686E-03_JPRB,1.1624E-03_JPRB,1.2313E-03_JPRB,1.2778E-03_JPRB,&
&1.3076E-03_JPRB,1.3141E-03_JPRB,1.1274E-03_JPRB/)
KAO( :, 5, 5, 8) = (/&
&8.0636E-04_JPRB,9.8796E-04_JPRB,1.1047E-03_JPRB,1.2088E-03_JPRB,1.2883E-03_JPRB,1.3425E-03_JPRB,&
&1.3805E-03_JPRB,1.3900E-03_JPRB,1.1960E-03_JPRB/)
KAO( :, 1, 6, 8) = (/&
&7.4042E-04_JPRB,8.3357E-04_JPRB,9.1717E-04_JPRB,9.7114E-04_JPRB,1.0002E-03_JPRB,1.0057E-03_JPRB,&
&9.9270E-04_JPRB,9.6792E-04_JPRB,8.3659E-04_JPRB/)
KAO( :, 2, 6, 8) = (/&
&7.4565E-04_JPRB,8.5743E-04_JPRB,9.4912E-04_JPRB,1.0119E-03_JPRB,1.0480E-03_JPRB,1.0602E-03_JPRB,&
&1.0545E-03_JPRB,1.0369E-03_JPRB,8.9582E-04_JPRB/)
KAO( :, 3, 6, 8) = (/&
&7.4922E-04_JPRB,8.8128E-04_JPRB,9.8142E-04_JPRB,1.0542E-03_JPRB,1.0980E-03_JPRB,1.1167E-03_JPRB,&
&1.1185E-03_JPRB,1.1056E-03_JPRB,9.5443E-04_JPRB/)
KAO( :, 4, 6, 8) = (/&
&7.5232E-04_JPRB,9.0308E-04_JPRB,1.0141E-03_JPRB,1.0981E-03_JPRB,1.1486E-03_JPRB,1.1744E-03_JPRB,&
&1.1833E-03_JPRB,1.1741E-03_JPRB,1.0132E-03_JPRB/)
KAO( :, 5, 6, 8) = (/&
&7.5627E-04_JPRB,9.2523E-04_JPRB,1.0466E-03_JPRB,1.1406E-03_JPRB,1.2001E-03_JPRB,1.2335E-03_JPRB,&
&1.2490E-03_JPRB,1.2439E-03_JPRB,1.0736E-03_JPRB/)
KAO( :, 1, 7, 8) = (/&
&6.8964E-04_JPRB,7.8723E-04_JPRB,8.6407E-04_JPRB,9.0570E-04_JPRB,9.2461E-04_JPRB,9.2134E-04_JPRB,&
&8.9655E-04_JPRB,8.5470E-04_JPRB,7.7227E-04_JPRB/)
KAO( :, 2, 7, 8) = (/&
&6.9565E-04_JPRB,8.0904E-04_JPRB,8.9444E-04_JPRB,9.4366E-04_JPRB,9.6915E-04_JPRB,9.7063E-04_JPRB,&
&9.5066E-04_JPRB,9.1508E-04_JPRB,8.2464E-04_JPRB/)
KAO( :, 3, 7, 8) = (/&
&7.0042E-04_JPRB,8.3032E-04_JPRB,9.2461E-04_JPRB,9.8296E-04_JPRB,1.0152E-03_JPRB,1.0214E-03_JPRB,&
&1.0076E-03_JPRB,9.7640E-04_JPRB,8.7766E-04_JPRB/)
KAO( :, 4, 7, 8) = (/&
&7.0426E-04_JPRB,8.4981E-04_JPRB,9.5485E-04_JPRB,1.0240E-03_JPRB,1.0623E-03_JPRB,1.0734E-03_JPRB,&
&1.0651E-03_JPRB,1.0378E-03_JPRB,9.3187E-04_JPRB/)
KAO( :, 5, 7, 8) = (/&
&7.0821E-04_JPRB,8.6946E-04_JPRB,9.8537E-04_JPRB,1.0646E-03_JPRB,1.1098E-03_JPRB,1.1263E-03_JPRB,&
&1.1245E-03_JPRB,1.1007E-03_JPRB,9.8663E-04_JPRB/)
KAO( :, 1, 8, 8) = (/&
&6.4047E-04_JPRB,7.3858E-04_JPRB,8.0453E-04_JPRB,8.3694E-04_JPRB,8.4619E-04_JPRB,8.3765E-04_JPRB,&
&8.0766E-04_JPRB,7.5466E-04_JPRB,8.2781E-04_JPRB/)
KAO( :, 2, 8, 8) = (/&
&6.4742E-04_JPRB,7.5904E-04_JPRB,8.3405E-04_JPRB,8.7266E-04_JPRB,8.8676E-04_JPRB,8.8236E-04_JPRB,&
&8.5570E-04_JPRB,8.0688E-04_JPRB,8.7433E-04_JPRB/)
KAO( :, 3, 8, 8) = (/&
&6.5283E-04_JPRB,7.7980E-04_JPRB,8.6316E-04_JPRB,9.0850E-04_JPRB,9.2898E-04_JPRB,9.2841E-04_JPRB,&
&9.0551E-04_JPRB,8.6048E-04_JPRB,9.2376E-04_JPRB/)
KAO( :, 4, 8, 8) = (/&
&6.5707E-04_JPRB,7.9894E-04_JPRB,8.9224E-04_JPRB,9.4602E-04_JPRB,9.7258E-04_JPRB,9.7562E-04_JPRB,&
&9.5565E-04_JPRB,9.1442E-04_JPRB,9.7371E-04_JPRB/)
KAO( :, 5, 8, 8) = (/&
&6.6119E-04_JPRB,8.1764E-04_JPRB,9.2118E-04_JPRB,9.8357E-04_JPRB,1.0164E-03_JPRB,1.0233E-03_JPRB,&
&1.0075E-03_JPRB,9.7011E-04_JPRB,1.0250E-03_JPRB/)
KAO( :, 1, 9, 8) = (/&
&5.9304E-04_JPRB,6.8835E-04_JPRB,7.4179E-04_JPRB,7.6634E-04_JPRB,7.7050E-04_JPRB,7.5604E-04_JPRB,&
&7.2393E-04_JPRB,6.6767E-04_JPRB,1.3527E-03_JPRB/)
KAO( :, 2, 9, 8) = (/&
&6.0061E-04_JPRB,7.0826E-04_JPRB,7.7005E-04_JPRB,7.9970E-04_JPRB,8.0682E-04_JPRB,7.9622E-04_JPRB,&
&7.6713E-04_JPRB,7.1229E-04_JPRB,1.3810E-03_JPRB/)
KAO( :, 3, 9, 8) = (/&
&6.0690E-04_JPRB,7.2826E-04_JPRB,7.9782E-04_JPRB,8.3277E-04_JPRB,8.4414E-04_JPRB,8.3763E-04_JPRB,&
&8.1182E-04_JPRB,7.5863E-04_JPRB,1.4228E-03_JPRB/)
KAO( :, 4, 9, 8) = (/&
&6.1167E-04_JPRB,7.4710E-04_JPRB,8.2533E-04_JPRB,8.6687E-04_JPRB,8.8342E-04_JPRB,8.8028E-04_JPRB,&
&8.5678E-04_JPRB,8.0590E-04_JPRB,1.4759E-03_JPRB/)
KAO( :, 5, 9, 8) = (/&
&6.1627E-04_JPRB,7.6539E-04_JPRB,8.5255E-04_JPRB,9.0125E-04_JPRB,9.2320E-04_JPRB,9.2321E-04_JPRB,&
&9.0266E-04_JPRB,8.5442E-04_JPRB,1.5365E-03_JPRB/)
KAO( :, 1,10, 8) = (/&
&5.4825E-04_JPRB,6.3891E-04_JPRB,6.8254E-04_JPRB,7.0037E-04_JPRB,6.9928E-04_JPRB,6.8268E-04_JPRB,&
&6.4957E-04_JPRB,5.9476E-04_JPRB,3.8180E-03_JPRB/)
KAO( :, 2,10, 8) = (/&
&5.5676E-04_JPRB,6.5829E-04_JPRB,7.0890E-04_JPRB,7.3100E-04_JPRB,7.3257E-04_JPRB,7.1817E-04_JPRB,&
&6.8748E-04_JPRB,6.3344E-04_JPRB,3.7319E-03_JPRB/)
KAO( :, 3,10, 8) = (/&
&5.6387E-04_JPRB,6.7778E-04_JPRB,7.3493E-04_JPRB,7.6099E-04_JPRB,7.6595E-04_JPRB,7.5519E-04_JPRB,&
&7.2717E-04_JPRB,6.7342E-04_JPRB,3.6841E-03_JPRB/)
KAO( :, 4,10, 8) = (/&
&5.6965E-04_JPRB,6.9628E-04_JPRB,7.6095E-04_JPRB,7.9168E-04_JPRB,8.0061E-04_JPRB,7.9369E-04_JPRB,&
&7.6769E-04_JPRB,7.1402E-04_JPRB,3.6718E-03_JPRB/)
KAO( :, 5,10, 8) = (/&
&5.7483E-04_JPRB,7.1426E-04_JPRB,7.8640E-04_JPRB,8.2247E-04_JPRB,8.3634E-04_JPRB,8.3289E-04_JPRB,&
&8.0894E-04_JPRB,7.5561E-04_JPRB,3.6884E-03_JPRB/)
KAO( :, 1,11, 8) = (/&
&5.0971E-04_JPRB,5.9908E-04_JPRB,6.3716E-04_JPRB,6.5075E-04_JPRB,6.4646E-04_JPRB,6.2883E-04_JPRB,&
&5.9611E-04_JPRB,5.4516E-04_JPRB,5.2044E-03_JPRB/)
KAO( :, 2,11, 8) = (/&
&5.1851E-04_JPRB,6.1830E-04_JPRB,6.6103E-04_JPRB,6.7814E-04_JPRB,6.7644E-04_JPRB,6.6100E-04_JPRB,&
&6.3054E-04_JPRB,5.7922E-04_JPRB,5.0472E-03_JPRB/)
KAO( :, 3,11, 8) = (/&
&5.2576E-04_JPRB,6.3685E-04_JPRB,6.8508E-04_JPRB,7.0561E-04_JPRB,7.0702E-04_JPRB,6.9454E-04_JPRB,&
&6.6622E-04_JPRB,6.1448E-04_JPRB,4.9485E-03_JPRB/)
KAO( :, 4,11, 8) = (/&
&5.3230E-04_JPRB,6.5426E-04_JPRB,7.0906E-04_JPRB,7.3336E-04_JPRB,7.3854E-04_JPRB,7.2917E-04_JPRB,&
&7.0247E-04_JPRB,6.5031E-04_JPRB,4.8945E-03_JPRB/)
KAO( :, 5,11, 8) = (/&
&5.3825E-04_JPRB,6.7152E-04_JPRB,7.3265E-04_JPRB,7.6088E-04_JPRB,7.7057E-04_JPRB,7.6479E-04_JPRB,&
&7.3945E-04_JPRB,6.8664E-04_JPRB,4.8718E-03_JPRB/)
KAO( :, 1,12, 8) = (/&
&4.7268E-04_JPRB,5.5911E-04_JPRB,5.9221E-04_JPRB,6.0202E-04_JPRB,5.9599E-04_JPRB,5.7673E-04_JPRB,&
&5.4567E-04_JPRB,4.9766E-04_JPRB,5.4784E-03_JPRB/)
KAO( :, 2,12, 8) = (/&
&4.8142E-04_JPRB,5.7788E-04_JPRB,6.1435E-04_JPRB,6.2655E-04_JPRB,6.2325E-04_JPRB,6.0670E-04_JPRB,&
&5.7673E-04_JPRB,5.2800E-04_JPRB,5.3059E-03_JPRB/)
KAO( :, 3,12, 8) = (/&
&4.8905E-04_JPRB,5.9521E-04_JPRB,6.3638E-04_JPRB,6.5188E-04_JPRB,6.5138E-04_JPRB,6.3718E-04_JPRB,&
&6.0852E-04_JPRB,5.5928E-04_JPRB,5.1929E-03_JPRB/)
KAO( :, 4,12, 8) = (/&
&4.9586E-04_JPRB,6.1204E-04_JPRB,6.5810E-04_JPRB,6.7725E-04_JPRB,6.7983E-04_JPRB,6.6800E-04_JPRB,&
&6.4102E-04_JPRB,5.9098E-04_JPRB,5.1181E-03_JPRB/)
KAO( :, 5,12, 8) = (/&
&5.0219E-04_JPRB,6.2893E-04_JPRB,6.7933E-04_JPRB,7.0239E-04_JPRB,7.0829E-04_JPRB,6.9992E-04_JPRB,&
&6.7457E-04_JPRB,6.2315E-04_JPRB,5.0659E-03_JPRB/)
KAO( :, 1,13, 8) = (/&
&4.3613E-04_JPRB,5.1896E-04_JPRB,5.4757E-04_JPRB,5.5450E-04_JPRB,5.4716E-04_JPRB,5.2848E-04_JPRB,&
&4.9828E-04_JPRB,4.5179E-04_JPRB,4.7039E-03_JPRB/)
KAO( :, 2,13, 8) = (/&
&4.4480E-04_JPRB,5.3652E-04_JPRB,5.6828E-04_JPRB,5.7733E-04_JPRB,5.7232E-04_JPRB,5.5571E-04_JPRB,&
&5.2643E-04_JPRB,4.7940E-04_JPRB,4.5588E-03_JPRB/)
KAO( :, 3,13, 8) = (/&
&4.5255E-04_JPRB,5.5296E-04_JPRB,5.8851E-04_JPRB,6.0068E-04_JPRB,5.9826E-04_JPRB,5.8320E-04_JPRB,&
&5.5480E-04_JPRB,5.0729E-04_JPRB,4.4582E-03_JPRB/)
KAO( :, 4,13, 8) = (/&
&4.5948E-04_JPRB,5.6913E-04_JPRB,6.0860E-04_JPRB,6.2380E-04_JPRB,6.2384E-04_JPRB,6.1098E-04_JPRB,&
&5.8363E-04_JPRB,5.3555E-04_JPRB,4.3840E-03_JPRB/)
KAO( :, 5,13, 8) = (/&
&4.6648E-04_JPRB,5.8526E-04_JPRB,6.2843E-04_JPRB,6.4682E-04_JPRB,6.4977E-04_JPRB,6.3953E-04_JPRB,&
&6.1349E-04_JPRB,5.6436E-04_JPRB,4.3301E-03_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB16_A2
