!OCL SCALAR
SUBROUTINE RRTM_KGB14

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 14:  2250-2380 cm-1 (low - CO2; high - CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO14, ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO

!     ------------------------------------------------------------------


IMPLICIT NONE
FRACREFAO( :) = (/&
!     From P = 1053.6 mb.
    &0.18446200_JPRB,0.16795200_JPRB,0.14949700_JPRB,0.12036000_JPRB,&
    &0.10440100_JPRB,0.09024280_JPRB,0.07435880_JPRB,0.05629380_JPRB,&
    &0.03825420_JPRB,0.00417276_JPRB,0.00345278_JPRB,0.00272949_JPRB,&
    &0.00200378_JPRB,0.00127404_JPRB,0.00050721_JPRB,0.00004141_JPRB/)

FRACREFBO( :) = (/&
!     From P = 0.64 mb.
    &0.19128500_JPRB,0.16495700_JPRB,0.14146100_JPRB,0.11904500_JPRB,&
    &0.10350200_JPRB,0.09151190_JPRB,0.07604270_JPRB,0.05806020_JPRB,&
    &0.03979950_JPRB,0.00423959_JPRB,0.00357439_JPRB,0.00287559_JPRB,&
    &0.00198860_JPRB,0.00116529_JPRB,0.00043616_JPRB,0.00005987_JPRB/)

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
&3.5949E-01_JPRB,3.8238E-01_JPRB,4.1007E-01_JPRB,4.4339E-01_JPRB,4.8230E-01_JPRB/)
KAO( :, 2, 1) = (/&
&3.0485E-01_JPRB,3.2295E-01_JPRB,3.4552E-01_JPRB,3.7333E-01_JPRB,4.0603E-01_JPRB/)
KAO( :, 3, 1) = (/&
&2.5422E-01_JPRB,2.6754E-01_JPRB,2.8483E-01_JPRB,3.0668E-01_JPRB,3.3252E-01_JPRB/)
KAO( :, 4, 1) = (/&
&2.1093E-01_JPRB,2.2073E-01_JPRB,2.3378E-01_JPRB,2.5076E-01_JPRB,2.7135E-01_JPRB/)
KAO( :, 5, 1) = (/&
&1.7483E-01_JPRB,1.8205E-01_JPRB,1.9194E-01_JPRB,2.0512E-01_JPRB,2.2145E-01_JPRB/)
KAO( :, 6, 1) = (/&
&1.4472E-01_JPRB,1.4992E-01_JPRB,1.5732E-01_JPRB,1.6735E-01_JPRB,1.8017E-01_JPRB/)
KAO( :, 7, 1) = (/&
&1.1982E-01_JPRB,1.2359E-01_JPRB,1.2898E-01_JPRB,1.3657E-01_JPRB,1.4653E-01_JPRB/)
KAO( :, 8, 1) = (/&
&9.9228E-02_JPRB,1.0198E-01_JPRB,1.0592E-01_JPRB,1.1158E-01_JPRB,1.1926E-01_JPRB/)
KAO( :, 9, 1) = (/&
&8.2262E-02_JPRB,8.4210E-02_JPRB,8.7109E-02_JPRB,9.1293E-02_JPRB,9.7123E-02_JPRB/)
KAO( :,10, 1) = (/&
&6.8209E-02_JPRB,6.9606E-02_JPRB,7.1781E-02_JPRB,7.4983E-02_JPRB,7.9504E-02_JPRB/)
KAO( :,11, 1) = (/&
&5.6845E-02_JPRB,5.8087E-02_JPRB,6.0031E-02_JPRB,6.2957E-02_JPRB,6.7037E-02_JPRB/)
KAO( :,12, 1) = (/&
&4.7244E-02_JPRB,4.8375E-02_JPRB,5.0140E-02_JPRB,5.2785E-02_JPRB,5.6455E-02_JPRB/)
KAO( :,13, 1) = (/&
&3.9170E-02_JPRB,4.0208E-02_JPRB,4.1811E-02_JPRB,4.4178E-02_JPRB,4.7427E-02_JPRB/)
KAO( :, 1, 2) = (/&
&1.2872E+00_JPRB,1.3933E+00_JPRB,1.5229E+00_JPRB,1.6818E+00_JPRB,1.8746E+00_JPRB/)
KAO( :, 2, 2) = (/&
&1.1067E+00_JPRB,1.2035E+00_JPRB,1.3215E+00_JPRB,1.4648E+00_JPRB,1.6373E+00_JPRB/)
KAO( :, 3, 2) = (/&
&9.2875E-01_JPRB,1.0145E+00_JPRB,1.1171E+00_JPRB,1.2402E+00_JPRB,1.3874E+00_JPRB/)
KAO( :, 4, 2) = (/&
&7.7024E-01_JPRB,8.4470E-01_JPRB,9.3397E-01_JPRB,1.0398E+00_JPRB,1.1644E+00_JPRB/)
KAO( :, 5, 2) = (/&
&6.3547E-01_JPRB,6.9999E-01_JPRB,7.7719E-01_JPRB,8.6762E-01_JPRB,9.7354E-01_JPRB/)
KAO( :, 6, 2) = (/&
&5.2029E-01_JPRB,5.7514E-01_JPRB,6.4113E-01_JPRB,7.1778E-01_JPRB,8.0690E-01_JPRB/)
KAO( :, 7, 2) = (/&
&4.2402E-01_JPRB,4.7059E-01_JPRB,5.2574E-01_JPRB,5.9013E-01_JPRB,6.6415E-01_JPRB/)
KAO( :, 8, 2) = (/&
&3.4478E-01_JPRB,3.8240E-01_JPRB,4.2694E-01_JPRB,4.7936E-01_JPRB,5.3995E-01_JPRB/)
KAO( :, 9, 2) = (/&
&2.7872E-01_JPRB,3.0857E-01_JPRB,3.4389E-01_JPRB,3.8559E-01_JPRB,4.3444E-01_JPRB/)
KAO( :,10, 2) = (/&
&2.2596E-01_JPRB,2.5018E-01_JPRB,2.7837E-01_JPRB,3.1178E-01_JPRB,3.5123E-01_JPRB/)
KAO( :,11, 2) = (/&
&1.9149E-01_JPRB,2.1236E-01_JPRB,2.3673E-01_JPRB,2.6562E-01_JPRB,2.9993E-01_JPRB/)
KAO( :,12, 2) = (/&
&1.6195E-01_JPRB,1.7991E-01_JPRB,2.0098E-01_JPRB,2.2594E-01_JPRB,2.5567E-01_JPRB/)
KAO( :,13, 2) = (/&
&1.3643E-01_JPRB,1.5192E-01_JPRB,1.7016E-01_JPRB,1.9179E-01_JPRB,2.1776E-01_JPRB/)
KAO( :, 1, 3) = (/&
&5.3360E+00_JPRB,5.9602E+00_JPRB,6.6311E+00_JPRB,7.3500E+00_JPRB,8.1211E+00_JPRB/)
KAO( :, 2, 3) = (/&
&4.6843E+00_JPRB,5.2481E+00_JPRB,5.8517E+00_JPRB,6.5055E+00_JPRB,7.2045E+00_JPRB/)
KAO( :, 3, 3) = (/&
&3.9306E+00_JPRB,4.4236E+00_JPRB,4.9546E+00_JPRB,5.5277E+00_JPRB,6.1375E+00_JPRB/)
KAO( :, 4, 3) = (/&
&3.2173E+00_JPRB,3.6357E+00_JPRB,4.0925E+00_JPRB,4.5878E+00_JPRB,5.1170E+00_JPRB/)
KAO( :, 5, 3) = (/&
&2.5942E+00_JPRB,2.9460E+00_JPRB,3.3334E+00_JPRB,3.7556E+00_JPRB,4.2107E+00_JPRB/)
KAO( :, 6, 3) = (/&
&2.0555E+00_JPRB,2.3477E+00_JPRB,2.6712E+00_JPRB,3.0269E+00_JPRB,3.4138E+00_JPRB/)
KAO( :, 7, 3) = (/&
&1.6118E+00_JPRB,1.8526E+00_JPRB,2.1224E+00_JPRB,2.4196E+00_JPRB,2.7460E+00_JPRB/)
KAO( :, 8, 3) = (/&
&1.2564E+00_JPRB,1.4546E+00_JPRB,1.6794E+00_JPRB,1.9292E+00_JPRB,2.2031E+00_JPRB/)
KAO( :, 9, 3) = (/&
&9.7439E-01_JPRB,1.1371E+00_JPRB,1.3228E+00_JPRB,1.5317E+00_JPRB,1.7615E+00_JPRB/)
KAO( :,10, 3) = (/&
&7.6284E-01_JPRB,8.9693E-01_JPRB,1.0511E+00_JPRB,1.2260E+00_JPRB,1.4196E+00_JPRB/)
KAO( :,11, 3) = (/&
&6.4505E-01_JPRB,7.6321E-01_JPRB,8.9939E-01_JPRB,1.0531E+00_JPRB,1.2207E+00_JPRB/)
KAO( :,12, 3) = (/&
&5.4741E-01_JPRB,6.5142E-01_JPRB,7.6976E-01_JPRB,9.0081E-01_JPRB,1.0418E+00_JPRB/)
KAO( :,13, 3) = (/&
&4.6530E-01_JPRB,5.5436E-01_JPRB,6.5441E-01_JPRB,7.6383E-01_JPRB,8.8219E-01_JPRB/)
KAO( :, 1, 4) = (/&
&1.6152E+01_JPRB,1.7527E+01_JPRB,1.8781E+01_JPRB,1.9894E+01_JPRB,2.0832E+01_JPRB/)
KAO( :, 2, 4) = (/&
&1.4046E+01_JPRB,1.5178E+01_JPRB,1.6195E+01_JPRB,1.7086E+01_JPRB,1.7867E+01_JPRB/)
KAO( :, 3, 4) = (/&
&1.2099E+01_JPRB,1.3048E+01_JPRB,1.3899E+01_JPRB,1.4662E+01_JPRB,1.5345E+01_JPRB/)
KAO( :, 4, 4) = (/&
&1.0250E+01_JPRB,1.1071E+01_JPRB,1.1812E+01_JPRB,1.2480E+01_JPRB,1.3082E+01_JPRB/)
KAO( :, 5, 4) = (/&
&8.5710E+00_JPRB,9.2814E+00_JPRB,9.9329E+00_JPRB,1.0519E+01_JPRB,1.1047E+01_JPRB/)
KAO( :, 6, 4) = (/&
&7.0718E+00_JPRB,7.6889E+00_JPRB,8.2584E+00_JPRB,8.7766E+00_JPRB,9.2483E+00_JPRB/)
KAO( :, 7, 4) = (/&
&5.7749E+00_JPRB,6.3070E+00_JPRB,6.8047E+00_JPRB,7.2640E+00_JPRB,7.6824E+00_JPRB/)
KAO( :, 8, 4) = (/&
&4.6724E+00_JPRB,5.1283E+00_JPRB,5.5581E+00_JPRB,5.9613E+00_JPRB,6.3358E+00_JPRB/)
KAO( :, 9, 4) = (/&
&3.7440E+00_JPRB,4.1328E+00_JPRB,4.5018E+00_JPRB,4.8548E+00_JPRB,5.1877E+00_JPRB/)
KAO( :,10, 4) = (/&
&2.9973E+00_JPRB,3.3277E+00_JPRB,3.6442E+00_JPRB,3.9507E+00_JPRB,4.2451E+00_JPRB/)
KAO( :,11, 4) = (/&
&2.5128E+00_JPRB,2.7893E+00_JPRB,3.0562E+00_JPRB,3.3207E+00_JPRB,3.5778E+00_JPRB/)
KAO( :,12, 4) = (/&
&2.1002E+00_JPRB,2.3318E+00_JPRB,2.5620E+00_JPRB,2.7945E+00_JPRB,3.0199E+00_JPRB/)
KAO( :,13, 4) = (/&
&1.7517E+00_JPRB,1.9494E+00_JPRB,2.1523E+00_JPRB,2.3581E+00_JPRB,2.5501E+00_JPRB/)
KAO( :, 1, 5) = (/&
&3.4751E+01_JPRB,3.5230E+01_JPRB,3.5638E+01_JPRB,3.5981E+01_JPRB,3.6301E+01_JPRB/)
KAO( :, 2, 5) = (/&
&2.9729E+01_JPRB,3.0178E+01_JPRB,3.0562E+01_JPRB,3.0895E+01_JPRB,3.1160E+01_JPRB/)
KAO( :, 3, 5) = (/&
&2.5226E+01_JPRB,2.5646E+01_JPRB,2.6010E+01_JPRB,2.6290E+01_JPRB,2.6514E+01_JPRB/)
KAO( :, 4, 5) = (/&
&2.1570E+01_JPRB,2.1943E+01_JPRB,2.2252E+01_JPRB,2.2465E+01_JPRB,2.2652E+01_JPRB/)
KAO( :, 5, 5) = (/&
&1.8526E+01_JPRB,1.8854E+01_JPRB,1.9098E+01_JPRB,1.9261E+01_JPRB,1.9423E+01_JPRB/)
KAO( :, 6, 5) = (/&
&1.5776E+01_JPRB,1.6061E+01_JPRB,1.6258E+01_JPRB,1.6386E+01_JPRB,1.6522E+01_JPRB/)
KAO( :, 7, 5) = (/&
&1.3340E+01_JPRB,1.3594E+01_JPRB,1.3756E+01_JPRB,1.3864E+01_JPRB,1.3982E+01_JPRB/)
KAO( :, 8, 5) = (/&
&1.1233E+01_JPRB,1.1458E+01_JPRB,1.1599E+01_JPRB,1.1693E+01_JPRB,1.1791E+01_JPRB/)
KAO( :, 9, 5) = (/&
&9.4215E+00_JPRB,9.6164E+00_JPRB,9.7423E+00_JPRB,9.8254E+00_JPRB,9.9049E+00_JPRB/)
KAO( :,10, 5) = (/&
&7.8744E+00_JPRB,8.0390E+00_JPRB,8.1492E+00_JPRB,8.2195E+00_JPRB,8.2844E+00_JPRB/)
KAO( :,11, 5) = (/&
&6.6269E+00_JPRB,6.7416E+00_JPRB,6.8204E+00_JPRB,6.8736E+00_JPRB,6.9401E+00_JPRB/)
KAO( :,12, 5) = (/&
&5.5397E+00_JPRB,5.6256E+00_JPRB,5.6856E+00_JPRB,5.7347E+00_JPRB,5.8086E+00_JPRB/)
KAO( :,13, 5) = (/&
&4.6101E+00_JPRB,4.6786E+00_JPRB,4.7276E+00_JPRB,4.7772E+00_JPRB,4.8596E+00_JPRB/)
KAO( :, 1, 6) = (/&
&5.5130E+01_JPRB,5.5331E+01_JPRB,5.5751E+01_JPRB,5.6249E+01_JPRB,5.6765E+01_JPRB/)
KAO( :, 2, 6) = (/&
&4.8314E+01_JPRB,4.8735E+01_JPRB,4.9176E+01_JPRB,4.9631E+01_JPRB,5.0143E+01_JPRB/)
KAO( :, 3, 6) = (/&
&4.2059E+01_JPRB,4.2411E+01_JPRB,4.2762E+01_JPRB,4.3188E+01_JPRB,4.3691E+01_JPRB/)
KAO( :, 4, 6) = (/&
&3.6248E+01_JPRB,3.6478E+01_JPRB,3.6774E+01_JPRB,3.7187E+01_JPRB,3.7662E+01_JPRB/)
KAO( :, 5, 6) = (/&
&3.1107E+01_JPRB,3.1277E+01_JPRB,3.1534E+01_JPRB,3.1919E+01_JPRB,3.2341E+01_JPRB/)
KAO( :, 6, 6) = (/&
&2.6880E+01_JPRB,2.7008E+01_JPRB,2.7229E+01_JPRB,2.7549E+01_JPRB,2.7880E+01_JPRB/)
KAO( :, 7, 6) = (/&
&2.3158E+01_JPRB,2.3247E+01_JPRB,2.3429E+01_JPRB,2.3676E+01_JPRB,2.3946E+01_JPRB/)
KAO( :, 8, 6) = (/&
&1.9829E+01_JPRB,1.9879E+01_JPRB,2.0010E+01_JPRB,2.0196E+01_JPRB,2.0418E+01_JPRB/)
KAO( :, 9, 6) = (/&
&1.6898E+01_JPRB,1.6922E+01_JPRB,1.7013E+01_JPRB,1.7148E+01_JPRB,1.7325E+01_JPRB/)
KAO( :,10, 6) = (/&
&1.4366E+01_JPRB,1.4373E+01_JPRB,1.4439E+01_JPRB,1.4534E+01_JPRB,1.4675E+01_JPRB/)
KAO( :,11, 6) = (/&
&1.2164E+01_JPRB,1.2183E+01_JPRB,1.2231E+01_JPRB,1.2319E+01_JPRB,1.2450E+01_JPRB/)
KAO( :,12, 6) = (/&
&1.0258E+01_JPRB,1.0264E+01_JPRB,1.0303E+01_JPRB,1.0384E+01_JPRB,1.0512E+01_JPRB/)
KAO( :,13, 6) = (/&
&8.6118E+00_JPRB,8.6082E+00_JPRB,8.6451E+00_JPRB,8.7236E+00_JPRB,8.8552E+00_JPRB/)
KAO( :, 1, 7) = (/&
&9.6613E+01_JPRB,9.5560E+01_JPRB,9.4868E+01_JPRB,9.4707E+01_JPRB,9.5047E+01_JPRB/)
KAO( :, 2, 7) = (/&
&8.5378E+01_JPRB,8.4844E+01_JPRB,8.4980E+01_JPRB,8.5705E+01_JPRB,8.6820E+01_JPRB/)
KAO( :, 3, 7) = (/&
&7.4914E+01_JPRB,7.5068E+01_JPRB,7.5864E+01_JPRB,7.7176E+01_JPRB,7.8814E+01_JPRB/)
KAO( :, 4, 7) = (/&
&6.5406E+01_JPRB,6.6072E+01_JPRB,6.7363E+01_JPRB,6.9077E+01_JPRB,7.0805E+01_JPRB/)
KAO( :, 5, 7) = (/&
&5.6834E+01_JPRB,5.7880E+01_JPRB,5.9486E+01_JPRB,6.1110E+01_JPRB,6.2642E+01_JPRB/)
KAO( :, 6, 7) = (/&
&4.9134E+01_JPRB,5.0398E+01_JPRB,5.1914E+01_JPRB,5.3305E+01_JPRB,5.4686E+01_JPRB/)
KAO( :, 7, 7) = (/&
&4.2637E+01_JPRB,4.3892E+01_JPRB,4.5117E+01_JPRB,4.6325E+01_JPRB,4.7499E+01_JPRB/)
KAO( :, 8, 7) = (/&
&3.7229E+01_JPRB,3.8287E+01_JPRB,3.9278E+01_JPRB,4.0285E+01_JPRB,4.1280E+01_JPRB/)
KAO( :, 9, 7) = (/&
&3.2369E+01_JPRB,3.3232E+01_JPRB,3.4050E+01_JPRB,3.4909E+01_JPRB,3.5773E+01_JPRB/)
KAO( :,10, 7) = (/&
&2.7964E+01_JPRB,2.8642E+01_JPRB,2.9313E+01_JPRB,3.0048E+01_JPRB,3.0775E+01_JPRB/)
KAO( :,11, 7) = (/&
&2.4270E+01_JPRB,2.4795E+01_JPRB,2.5375E+01_JPRB,2.5988E+01_JPRB,2.6571E+01_JPRB/)
KAO( :,12, 7) = (/&
&2.0936E+01_JPRB,2.1384E+01_JPRB,2.1881E+01_JPRB,2.2373E+01_JPRB,2.2843E+01_JPRB/)
KAO( :,13, 7) = (/&
&1.7997E+01_JPRB,1.8384E+01_JPRB,1.8786E+01_JPRB,1.9175E+01_JPRB,1.9563E+01_JPRB/)
KAO( :, 1, 8) = (/&
&2.1875E+02_JPRB,2.1582E+02_JPRB,2.1296E+02_JPRB,2.1003E+02_JPRB,2.0715E+02_JPRB/)
KAO( :, 2, 8) = (/&
&2.0320E+02_JPRB,2.0039E+02_JPRB,1.9765E+02_JPRB,1.9490E+02_JPRB,1.9237E+02_JPRB/)
KAO( :, 3, 8) = (/&
&1.8600E+02_JPRB,1.8334E+02_JPRB,1.8077E+02_JPRB,1.7842E+02_JPRB,1.7627E+02_JPRB/)
KAO( :, 4, 8) = (/&
&1.6777E+02_JPRB,1.6536E+02_JPRB,1.6312E+02_JPRB,1.6113E+02_JPRB,1.5989E+02_JPRB/)
KAO( :, 5, 8) = (/&
&1.4943E+02_JPRB,1.4725E+02_JPRB,1.4535E+02_JPRB,1.4437E+02_JPRB,1.4430E+02_JPRB/)
KAO( :, 6, 8) = (/&
&1.3133E+02_JPRB,1.2945E+02_JPRB,1.2835E+02_JPRB,1.2837E+02_JPRB,1.2929E+02_JPRB/)
KAO( :, 7, 8) = (/&
&1.1418E+02_JPRB,1.1273E+02_JPRB,1.1250E+02_JPRB,1.1334E+02_JPRB,1.1514E+02_JPRB/)
KAO( :, 8, 8) = (/&
&9.8405E+01_JPRB,9.7565E+01_JPRB,9.8029E+01_JPRB,9.9545E+01_JPRB,1.0201E+02_JPRB/)
KAO( :, 9, 8) = (/&
&8.4682E+01_JPRB,8.4331E+01_JPRB,8.5271E+01_JPRB,8.7263E+01_JPRB,9.0114E+01_JPRB/)
KAO( :,10, 8) = (/&
&7.3042E+01_JPRB,7.3160E+01_JPRB,7.4507E+01_JPRB,7.6830E+01_JPRB,7.9492E+01_JPRB/)
KAO( :,11, 8) = (/&
&6.3320E+01_JPRB,6.4346E+01_JPRB,6.6364E+01_JPRB,6.8605E+01_JPRB,7.0750E+01_JPRB/)
KAO( :,12, 8) = (/&
&5.5520E+01_JPRB,5.7127E+01_JPRB,5.9034E+01_JPRB,6.0843E+01_JPRB,6.2628E+01_JPRB/)
KAO( :,13, 8) = (/&
&4.8720E+01_JPRB,5.0320E+01_JPRB,5.1854E+01_JPRB,5.3381E+01_JPRB,5.4848E+01_JPRB/)
KAO( :, 1, 9) = (/&
&5.5976E+02_JPRB,5.5606E+02_JPRB,5.5170E+02_JPRB,5.4679E+02_JPRB,5.4142E+02_JPRB/)
KAO( :, 2, 9) = (/&
&5.7991E+02_JPRB,5.7550E+02_JPRB,5.7048E+02_JPRB,5.6499E+02_JPRB,5.5881E+02_JPRB/)
KAO( :, 3, 9) = (/&
&5.9128E+02_JPRB,5.8623E+02_JPRB,5.8077E+02_JPRB,5.7450E+02_JPRB,5.6801E+02_JPRB/)
KAO( :, 4, 9) = (/&
&5.9173E+02_JPRB,5.8627E+02_JPRB,5.8008E+02_JPRB,5.7365E+02_JPRB,5.6657E+02_JPRB/)
KAO( :, 5, 9) = (/&
&5.8078E+02_JPRB,5.7460E+02_JPRB,5.6816E+02_JPRB,5.6109E+02_JPRB,5.5382E+02_JPRB/)
KAO( :, 6, 9) = (/&
&5.6004E+02_JPRB,5.5342E+02_JPRB,5.4648E+02_JPRB,5.3935E+02_JPRB,5.3177E+02_JPRB/)
KAO( :, 7, 9) = (/&
&5.3020E+02_JPRB,5.2344E+02_JPRB,5.1623E+02_JPRB,5.0891E+02_JPRB,5.0146E+02_JPRB/)
KAO( :, 8, 9) = (/&
&4.9306E+02_JPRB,4.8589E+02_JPRB,4.7879E+02_JPRB,4.7156E+02_JPRB,4.6424E+02_JPRB/)
KAO( :, 9, 9) = (/&
&4.5109E+02_JPRB,4.4398E+02_JPRB,4.3682E+02_JPRB,4.2990E+02_JPRB,4.2317E+02_JPRB/)
KAO( :,10, 9) = (/&
&4.0554E+02_JPRB,3.9861E+02_JPRB,3.9191E+02_JPRB,3.8539E+02_JPRB,3.7999E+02_JPRB/)
KAO( :,11, 9) = (/&
&3.5678E+02_JPRB,3.5028E+02_JPRB,3.4422E+02_JPRB,3.3949E+02_JPRB,3.3677E+02_JPRB/)
KAO( :,12, 9) = (/&
&3.0997E+02_JPRB,3.0426E+02_JPRB,2.9997E+02_JPRB,2.9770E+02_JPRB,2.9720E+02_JPRB/)
KAO( :,13, 9) = (/&
&2.6709E+02_JPRB,2.6293E+02_JPRB,2.6082E+02_JPRB,2.6061E+02_JPRB,2.6217E+02_JPRB/)
KAO( :, 1,10) = (/&
&9.5728E+02_JPRB,9.5690E+02_JPRB,9.5401E+02_JPRB,9.5007E+02_JPRB,9.4420E+02_JPRB/)
KAO( :, 2,10) = (/&
&1.0745E+03_JPRB,1.0719E+03_JPRB,1.0680E+03_JPRB,1.0623E+03_JPRB,1.0552E+03_JPRB/)
KAO( :, 3,10) = (/&
&1.1871E+03_JPRB,1.1845E+03_JPRB,1.1802E+03_JPRB,1.1737E+03_JPRB,1.1657E+03_JPRB/)
KAO( :, 4,10) = (/&
&1.2933E+03_JPRB,1.2895E+03_JPRB,1.2845E+03_JPRB,1.2769E+03_JPRB,1.2684E+03_JPRB/)
KAO( :, 5,10) = (/&
&1.3871E+03_JPRB,1.3843E+03_JPRB,1.3770E+03_JPRB,1.3701E+03_JPRB,1.3589E+03_JPRB/)
KAO( :, 6,10) = (/&
&1.4584E+03_JPRB,1.4525E+03_JPRB,1.4462E+03_JPRB,1.4355E+03_JPRB,1.4255E+03_JPRB/)
KAO( :, 7,10) = (/&
&1.5042E+03_JPRB,1.4961E+03_JPRB,1.4859E+03_JPRB,1.4751E+03_JPRB,1.4602E+03_JPRB/)
KAO( :, 8,10) = (/&
&1.5189E+03_JPRB,1.5105E+03_JPRB,1.4981E+03_JPRB,1.4842E+03_JPRB,1.4701E+03_JPRB/)
KAO( :, 9,10) = (/&
&1.5016E+03_JPRB,1.4885E+03_JPRB,1.4763E+03_JPRB,1.4608E+03_JPRB,1.4435E+03_JPRB/)
KAO( :,10,10) = (/&
&1.4531E+03_JPRB,1.4390E+03_JPRB,1.4217E+03_JPRB,1.4053E+03_JPRB,1.3883E+03_JPRB/)
KAO( :,11,10) = (/&
&1.3673E+03_JPRB,1.3498E+03_JPRB,1.3324E+03_JPRB,1.3154E+03_JPRB,1.2964E+03_JPRB/)
KAO( :,12,10) = (/&
&1.2564E+03_JPRB,1.2384E+03_JPRB,1.2210E+03_JPRB,1.2031E+03_JPRB,1.1837E+03_JPRB/)
KAO( :,13,10) = (/&
&1.1371E+03_JPRB,1.1192E+03_JPRB,1.1015E+03_JPRB,1.0830E+03_JPRB,1.0644E+03_JPRB/)
KAO( :, 1,11) = (/&
&1.0794E+03_JPRB,1.0788E+03_JPRB,1.0790E+03_JPRB,1.0769E+03_JPRB,1.0715E+03_JPRB/)
KAO( :, 2,11) = (/&
&1.2369E+03_JPRB,1.2394E+03_JPRB,1.2387E+03_JPRB,1.2348E+03_JPRB,1.2284E+03_JPRB/)
KAO( :, 3,11) = (/&
&1.4037E+03_JPRB,1.4057E+03_JPRB,1.4048E+03_JPRB,1.4010E+03_JPRB,1.3938E+03_JPRB/)
KAO( :, 4,11) = (/&
&1.5772E+03_JPRB,1.5782E+03_JPRB,1.5766E+03_JPRB,1.5700E+03_JPRB,1.5626E+03_JPRB/)
KAO( :, 5,11) = (/&
&1.7441E+03_JPRB,1.7459E+03_JPRB,1.7422E+03_JPRB,1.7359E+03_JPRB,1.7270E+03_JPRB/)
KAO( :, 6,11) = (/&
&1.9017E+03_JPRB,1.9021E+03_JPRB,1.8960E+03_JPRB,1.8905E+03_JPRB,1.8786E+03_JPRB/)
KAO( :, 7,11) = (/&
&2.0395E+03_JPRB,2.0360E+03_JPRB,2.0330E+03_JPRB,2.0229E+03_JPRB,2.0133E+03_JPRB/)
KAO( :, 8,11) = (/&
&2.1454E+03_JPRB,2.1404E+03_JPRB,2.1335E+03_JPRB,2.1240E+03_JPRB,2.1091E+03_JPRB/)
KAO( :, 9,11) = (/&
&2.2123E+03_JPRB,2.2075E+03_JPRB,2.1945E+03_JPRB,2.1814E+03_JPRB,2.1649E+03_JPRB/)
KAO( :,10,11) = (/&
&2.2367E+03_JPRB,2.2244E+03_JPRB,2.2129E+03_JPRB,2.1949E+03_JPRB,2.1755E+03_JPRB/)
KAO( :,11,11) = (/&
&2.2036E+03_JPRB,2.1899E+03_JPRB,2.1713E+03_JPRB,2.1494E+03_JPRB,2.1278E+03_JPRB/)
KAO( :,12,11) = (/&
&2.1239E+03_JPRB,2.1041E+03_JPRB,2.0806E+03_JPRB,2.0570E+03_JPRB,2.0321E+03_JPRB/)
KAO( :,13,11) = (/&
&1.9981E+03_JPRB,1.9741E+03_JPRB,1.9501E+03_JPRB,1.9259E+03_JPRB,1.8992E+03_JPRB/)
KAO( :, 1,12) = (/&
&1.1941E+03_JPRB,1.1961E+03_JPRB,1.1962E+03_JPRB,1.1934E+03_JPRB,1.1915E+03_JPRB/)
KAO( :, 2,12) = (/&
&1.3953E+03_JPRB,1.3978E+03_JPRB,1.3989E+03_JPRB,1.3989E+03_JPRB,1.3975E+03_JPRB/)
KAO( :, 3,12) = (/&
&1.6228E+03_JPRB,1.6258E+03_JPRB,1.6260E+03_JPRB,1.6268E+03_JPRB,1.6242E+03_JPRB/)
KAO( :, 4,12) = (/&
&1.8694E+03_JPRB,1.8740E+03_JPRB,1.8767E+03_JPRB,1.8774E+03_JPRB,1.8733E+03_JPRB/)
KAO( :, 5,12) = (/&
&2.1317E+03_JPRB,2.1362E+03_JPRB,2.1424E+03_JPRB,2.1420E+03_JPRB,2.1392E+03_JPRB/)
KAO( :, 6,12) = (/&
&2.4044E+03_JPRB,2.4133E+03_JPRB,2.4176E+03_JPRB,2.4160E+03_JPRB,2.4115E+03_JPRB/)
KAO( :, 7,12) = (/&
&2.6762E+03_JPRB,2.6888E+03_JPRB,2.6899E+03_JPRB,2.6906E+03_JPRB,2.6811E+03_JPRB/)
KAO( :, 8,12) = (/&
&2.9393E+03_JPRB,2.9492E+03_JPRB,2.9517E+03_JPRB,2.9490E+03_JPRB,2.9400E+03_JPRB/)
KAO( :, 9,12) = (/&
&3.1791E+03_JPRB,3.1838E+03_JPRB,3.1886E+03_JPRB,3.1814E+03_JPRB,3.1717E+03_JPRB/)
KAO( :,10,12) = (/&
&3.3778E+03_JPRB,3.3826E+03_JPRB,3.3785E+03_JPRB,3.3711E+03_JPRB,3.3555E+03_JPRB/)
KAO( :,11,12) = (/&
&3.5199E+03_JPRB,3.5143E+03_JPRB,3.5061E+03_JPRB,3.4899E+03_JPRB,3.4698E+03_JPRB/)
KAO( :,12,12) = (/&
&3.5918E+03_JPRB,3.5807E+03_JPRB,3.5632E+03_JPRB,3.5417E+03_JPRB,3.5132E+03_JPRB/)
KAO( :,13,12) = (/&
&3.5817E+03_JPRB,3.5602E+03_JPRB,3.5362E+03_JPRB,3.5063E+03_JPRB,3.4751E+03_JPRB/)
KAO( :, 1,13) = (/&
&1.2927E+03_JPRB,1.2959E+03_JPRB,1.2982E+03_JPRB,1.2977E+03_JPRB,1.2950E+03_JPRB/)
KAO( :, 2,13) = (/&
&1.5393E+03_JPRB,1.5429E+03_JPRB,1.5452E+03_JPRB,1.5442E+03_JPRB,1.5416E+03_JPRB/)
KAO( :, 3,13) = (/&
&1.8235E+03_JPRB,1.8299E+03_JPRB,1.8332E+03_JPRB,1.8330E+03_JPRB,1.8307E+03_JPRB/)
KAO( :, 4,13) = (/&
&2.1460E+03_JPRB,2.1562E+03_JPRB,2.1625E+03_JPRB,2.1633E+03_JPRB,2.1623E+03_JPRB/)
KAO( :, 5,13) = (/&
&2.5138E+03_JPRB,2.5270E+03_JPRB,2.5346E+03_JPRB,2.5383E+03_JPRB,2.5372E+03_JPRB/)
KAO( :, 6,13) = (/&
&2.9233E+03_JPRB,2.9381E+03_JPRB,2.9500E+03_JPRB,2.9556E+03_JPRB,2.9572E+03_JPRB/)
KAO( :, 7,13) = (/&
&3.3704E+03_JPRB,3.3895E+03_JPRB,3.4050E+03_JPRB,3.4111E+03_JPRB,3.4146E+03_JPRB/)
KAO( :, 8,13) = (/&
&3.8494E+03_JPRB,3.8729E+03_JPRB,3.8913E+03_JPRB,3.9008E+03_JPRB,3.9062E+03_JPRB/)
KAO( :, 9,13) = (/&
&4.3484E+03_JPRB,4.3768E+03_JPRB,4.3938E+03_JPRB,4.4075E+03_JPRB,4.4120E+03_JPRB/)
KAO( :,10,13) = (/&
&4.8563E+03_JPRB,4.8884E+03_JPRB,4.9080E+03_JPRB,4.9204E+03_JPRB,4.9230E+03_JPRB/)
KAO( :,11,13) = (/&
&5.3698E+03_JPRB,5.3968E+03_JPRB,5.4124E+03_JPRB,5.4206E+03_JPRB,5.4132E+03_JPRB/)
KAO( :,12,13) = (/&
&5.8401E+03_JPRB,5.8572E+03_JPRB,5.8683E+03_JPRB,5.8634E+03_JPRB,5.8549E+03_JPRB/)
KAO( :,13,13) = (/&
&6.2394E+03_JPRB,6.2548E+03_JPRB,6.2534E+03_JPRB,6.2438E+03_JPRB,6.2213E+03_JPRB/)
KAO( :, 1,14) = (/&
&1.3753E+03_JPRB,1.3791E+03_JPRB,1.3806E+03_JPRB,1.3820E+03_JPRB,1.3825E+03_JPRB/)
KAO( :, 2,14) = (/&
&1.6535E+03_JPRB,1.6590E+03_JPRB,1.6607E+03_JPRB,1.6628E+03_JPRB,1.6629E+03_JPRB/)
KAO( :, 3,14) = (/&
&1.9826E+03_JPRB,1.9922E+03_JPRB,1.9976E+03_JPRB,2.0007E+03_JPRB,2.0006E+03_JPRB/)
KAO( :, 4,14) = (/&
&2.3745E+03_JPRB,2.3859E+03_JPRB,2.3951E+03_JPRB,2.4030E+03_JPRB,2.4041E+03_JPRB/)
KAO( :, 5,14) = (/&
&2.8392E+03_JPRB,2.8553E+03_JPRB,2.8669E+03_JPRB,2.8760E+03_JPRB,2.8790E+03_JPRB/)
KAO( :, 6,14) = (/&
&3.3773E+03_JPRB,3.4016E+03_JPRB,3.4204E+03_JPRB,3.4341E+03_JPRB,3.4397E+03_JPRB/)
KAO( :, 7,14) = (/&
&4.0025E+03_JPRB,4.0325E+03_JPRB,4.0568E+03_JPRB,4.0775E+03_JPRB,4.0887E+03_JPRB/)
KAO( :, 8,14) = (/&
&4.7223E+03_JPRB,4.7649E+03_JPRB,4.7948E+03_JPRB,4.8179E+03_JPRB,4.8302E+03_JPRB/)
KAO( :, 9,14) = (/&
&5.5328E+03_JPRB,5.5878E+03_JPRB,5.6319E+03_JPRB,5.6661E+03_JPRB,5.6818E+03_JPRB/)
KAO( :,10,14) = (/&
&6.4532E+03_JPRB,6.5137E+03_JPRB,6.5680E+03_JPRB,6.6072E+03_JPRB,6.6322E+03_JPRB/)
KAO( :,11,14) = (/&
&7.5145E+03_JPRB,7.5791E+03_JPRB,7.6282E+03_JPRB,7.6633E+03_JPRB,7.6872E+03_JPRB/)
KAO( :,12,14) = (/&
&8.6607E+03_JPRB,8.7343E+03_JPRB,8.7852E+03_JPRB,8.8163E+03_JPRB,8.8288E+03_JPRB/)
KAO( :,13,14) = (/&
&9.8833E+03_JPRB,9.9529E+03_JPRB,1.0003E+04_JPRB,1.0028E+04_JPRB,1.0035E+04_JPRB/)
KAO( :, 1,15) = (/&
&1.4542E+03_JPRB,1.4589E+03_JPRB,1.4604E+03_JPRB,1.4579E+03_JPRB,1.4548E+03_JPRB/)
KAO( :, 2,15) = (/&
&1.7565E+03_JPRB,1.7644E+03_JPRB,1.7674E+03_JPRB,1.7671E+03_JPRB,1.7644E+03_JPRB/)
KAO( :, 3,15) = (/&
&2.1193E+03_JPRB,2.1295E+03_JPRB,2.1356E+03_JPRB,2.1395E+03_JPRB,2.1395E+03_JPRB/)
KAO( :, 4,15) = (/&
&2.5571E+03_JPRB,2.5704E+03_JPRB,2.5775E+03_JPRB,2.5844E+03_JPRB,2.5879E+03_JPRB/)
KAO( :, 5,15) = (/&
&3.0796E+03_JPRB,3.0997E+03_JPRB,3.1125E+03_JPRB,3.1195E+03_JPRB,3.1261E+03_JPRB/)
KAO( :, 6,15) = (/&
&3.7030E+03_JPRB,3.7342E+03_JPRB,3.7541E+03_JPRB,3.7653E+03_JPRB,3.7758E+03_JPRB/)
KAO( :, 7,15) = (/&
&4.4506E+03_JPRB,4.4902E+03_JPRB,4.5215E+03_JPRB,4.5394E+03_JPRB,4.5554E+03_JPRB/)
KAO( :, 8,15) = (/&
&5.3453E+03_JPRB,5.3952E+03_JPRB,5.4338E+03_JPRB,5.4624E+03_JPRB,5.4876E+03_JPRB/)
KAO( :, 9,15) = (/&
&6.4078E+03_JPRB,6.4736E+03_JPRB,6.5253E+03_JPRB,6.5575E+03_JPRB,6.5911E+03_JPRB/)
KAO( :,10,15) = (/&
&7.6598E+03_JPRB,7.7526E+03_JPRB,7.8219E+03_JPRB,7.8681E+03_JPRB,7.9031E+03_JPRB/)
KAO( :,11,15) = (/&
&9.1855E+03_JPRB,9.2916E+03_JPRB,9.3732E+03_JPRB,9.4318E+03_JPRB,9.4669E+03_JPRB/)
KAO( :,12,15) = (/&
&1.0994E+04_JPRB,1.1100E+04_JPRB,1.1186E+04_JPRB,1.1251E+04_JPRB,1.1289E+04_JPRB/)
KAO( :,13,15) = (/&
&1.3104E+04_JPRB,1.3212E+04_JPRB,1.3290E+04_JPRB,1.3346E+04_JPRB,1.3376E+04_JPRB/)
KAO( :, 1,16) = (/&
&1.4780E+03_JPRB,1.4827E+03_JPRB,1.4826E+03_JPRB,1.4874E+03_JPRB,1.4915E+03_JPRB/)
KAO( :, 2,16) = (/&
&1.7951E+03_JPRB,1.8015E+03_JPRB,1.8036E+03_JPRB,1.8055E+03_JPRB,1.8112E+03_JPRB/)
KAO( :, 3,16) = (/&
&2.1816E+03_JPRB,2.1886E+03_JPRB,2.1943E+03_JPRB,2.1956E+03_JPRB,2.1996E+03_JPRB/)
KAO( :, 4,16) = (/&
&2.6509E+03_JPRB,2.6606E+03_JPRB,2.6687E+03_JPRB,2.6722E+03_JPRB,2.6753E+03_JPRB/)
KAO( :, 5,16) = (/&
&3.2176E+03_JPRB,3.2329E+03_JPRB,3.2455E+03_JPRB,3.2518E+03_JPRB,3.2561E+03_JPRB/)
KAO( :, 6,16) = (/&
&3.8984E+03_JPRB,3.9245E+03_JPRB,3.9448E+03_JPRB,3.9570E+03_JPRB,3.9591E+03_JPRB/)
KAO( :, 7,16) = (/&
&4.7171E+03_JPRB,4.7549E+03_JPRB,4.7886E+03_JPRB,4.8095E+03_JPRB,4.8182E+03_JPRB/)
KAO( :, 8,16) = (/&
&5.7104E+03_JPRB,5.7554E+03_JPRB,5.8029E+03_JPRB,5.8388E+03_JPRB,5.8553E+03_JPRB/)
KAO( :, 9,16) = (/&
&6.9103E+03_JPRB,6.9722E+03_JPRB,7.0177E+03_JPRB,7.0728E+03_JPRB,7.1035E+03_JPRB/)
KAO( :,10,16) = (/&
&8.3550E+03_JPRB,8.4416E+03_JPRB,8.4942E+03_JPRB,8.5534E+03_JPRB,8.5999E+03_JPRB/)
KAO( :,11,16) = (/&
&1.0144E+04_JPRB,1.0238E+04_JPRB,1.0302E+04_JPRB,1.0361E+04_JPRB,1.0397E+04_JPRB/)
KAO( :,12,16) = (/&
&1.2283E+04_JPRB,1.2387E+04_JPRB,1.2470E+04_JPRB,1.2524E+04_JPRB,1.2537E+04_JPRB/)
KAO( :,13,16) = (/&
&1.4822E+04_JPRB,1.4946E+04_JPRB,1.5038E+04_JPRB,1.5076E+04_JPRB,1.5064E+04_JPRB/)

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
&3.9171E-02_JPRB,4.0209E-02_JPRB,4.1806E-02_JPRB,4.4182E-02_JPRB,4.7428E-02_JPRB/)
KBO( :,14, 1) = (/&
&3.2490E-02_JPRB,3.3463E-02_JPRB,3.4945E-02_JPRB,3.7104E-02_JPRB,4.0032E-02_JPRB/)
KBO( :,15, 1) = (/&
&2.6917E-02_JPRB,2.7822E-02_JPRB,2.9187E-02_JPRB,3.1142E-02_JPRB,3.3701E-02_JPRB/)
KBO( :,16, 1) = (/&
&2.2291E-02_JPRB,2.3129E-02_JPRB,2.4369E-02_JPRB,2.6101E-02_JPRB,2.8325E-02_JPRB/)
KBO( :,17, 1) = (/&
&1.8463E-02_JPRB,1.9231E-02_JPRB,2.0335E-02_JPRB,2.1845E-02_JPRB,2.3775E-02_JPRB/)
KBO( :,18, 1) = (/&
&1.5304E-02_JPRB,1.5992E-02_JPRB,1.6967E-02_JPRB,1.8267E-02_JPRB,1.9954E-02_JPRB/)
KBO( :,19, 1) = (/&
&1.2689E-02_JPRB,1.3293E-02_JPRB,1.4142E-02_JPRB,1.5272E-02_JPRB,1.6744E-02_JPRB/)
KBO( :,20, 1) = (/&
&1.0525E-02_JPRB,1.1058E-02_JPRB,1.1796E-02_JPRB,1.2786E-02_JPRB,1.4077E-02_JPRB/)
KBO( :,21, 1) = (/&
&8.7289E-03_JPRB,9.1958E-03_JPRB,9.8417E-03_JPRB,1.0709E-02_JPRB,1.1847E-02_JPRB/)
KBO( :,22, 1) = (/&
&7.2588E-03_JPRB,7.6747E-03_JPRB,8.2530E-03_JPRB,9.0292E-03_JPRB,1.0054E-02_JPRB/)
KBO( :,23, 1) = (/&
&6.0387E-03_JPRB,6.4108E-03_JPRB,6.9298E-03_JPRB,7.6312E-03_JPRB,8.5511E-03_JPRB/)
KBO( :,24, 1) = (/&
&5.0265E-03_JPRB,5.3630E-03_JPRB,5.8339E-03_JPRB,6.4676E-03_JPRB,7.2886E-03_JPRB/)
KBO( :,25, 1) = (/&
&4.1912E-03_JPRB,4.4982E-03_JPRB,4.9297E-03_JPRB,5.4991E-03_JPRB,6.2336E-03_JPRB/)
KBO( :,26, 1) = (/&
&3.5050E-03_JPRB,3.7893E-03_JPRB,4.1842E-03_JPRB,4.6973E-03_JPRB,5.3580E-03_JPRB/)
KBO( :,27, 1) = (/&
&2.9383E-03_JPRB,3.2032E-03_JPRB,3.5605E-03_JPRB,4.0246E-03_JPRB,4.6201E-03_JPRB/)
KBO( :,28, 1) = (/&
&2.4712E-03_JPRB,2.7165E-03_JPRB,3.0381E-03_JPRB,3.4592E-03_JPRB,3.9959E-03_JPRB/)
KBO( :,29, 1) = (/&
&2.0871E-03_JPRB,2.3113E-03_JPRB,2.6040E-03_JPRB,2.9852E-03_JPRB,3.4732E-03_JPRB/)
KBO( :,30, 1) = (/&
&1.7686E-03_JPRB,1.9719E-03_JPRB,2.2397E-03_JPRB,2.5854E-03_JPRB,3.0292E-03_JPRB/)
KBO( :,31, 1) = (/&
&1.5043E-03_JPRB,1.6903E-03_JPRB,1.9338E-03_JPRB,2.2497E-03_JPRB,2.6538E-03_JPRB/)
KBO( :,32, 1) = (/&
&1.2840E-03_JPRB,1.4547E-03_JPRB,1.6770E-03_JPRB,1.9662E-03_JPRB,2.3339E-03_JPRB/)
KBO( :,33, 1) = (/&
&1.1003E-03_JPRB,1.2566E-03_JPRB,1.4609E-03_JPRB,1.7254E-03_JPRB,2.0596E-03_JPRB/)
KBO( :,34, 1) = (/&
&9.4252E-04_JPRB,1.0841E-03_JPRB,1.2703E-03_JPRB,1.5103E-03_JPRB,1.8108E-03_JPRB/)
KBO( :,35, 1) = (/&
&7.9883E-04_JPRB,9.2438E-04_JPRB,1.0899E-03_JPRB,1.3019E-03_JPRB,1.5661E-03_JPRB/)
KBO( :,36, 1) = (/&
&6.6758E-04_JPRB,7.7591E-04_JPRB,9.1882E-04_JPRB,1.1013E-03_JPRB,1.3278E-03_JPRB/)
KBO( :,37, 1) = (/&
&5.4656E-04_JPRB,6.3617E-04_JPRB,7.5472E-04_JPRB,9.0662E-04_JPRB,1.0949E-03_JPRB/)
KBO( :,38, 1) = (/&
&4.4691E-04_JPRB,5.2075E-04_JPRB,6.1878E-04_JPRB,7.4481E-04_JPRB,9.0091E-04_JPRB/)
KBO( :,39, 1) = (/&
&3.6542E-04_JPRB,4.2618E-04_JPRB,5.0722E-04_JPRB,6.1164E-04_JPRB,7.4104E-04_JPRB/)
KBO( :,40, 1) = (/&
&2.9441E-04_JPRB,3.4292E-04_JPRB,4.0801E-04_JPRB,4.9232E-04_JPRB,5.9726E-04_JPRB/)
KBO( :,41, 1) = (/&
&2.3677E-04_JPRB,2.7525E-04_JPRB,3.2723E-04_JPRB,3.9501E-04_JPRB,4.7963E-04_JPRB/)
KBO( :,42, 1) = (/&
&1.9036E-04_JPRB,2.2088E-04_JPRB,2.6226E-04_JPRB,3.1664E-04_JPRB,3.8484E-04_JPRB/)
KBO( :,43, 1) = (/&
&1.5188E-04_JPRB,1.7566E-04_JPRB,2.0797E-04_JPRB,2.5103E-04_JPRB,3.0521E-04_JPRB/)
KBO( :,44, 1) = (/&
&1.2085E-04_JPRB,1.3918E-04_JPRB,1.6418E-04_JPRB,1.9786E-04_JPRB,2.4065E-04_JPRB/)
KBO( :,45, 1) = (/&
&9.6221E-05_JPRB,1.1032E-04_JPRB,1.2961E-04_JPRB,1.5587E-04_JPRB,1.8956E-04_JPRB/)
KBO( :,46, 1) = (/&
&7.6451E-05_JPRB,8.7222E-05_JPRB,1.0196E-04_JPRB,1.2223E-04_JPRB,1.4859E-04_JPRB/)
KBO( :,47, 1) = (/&
&6.0518E-05_JPRB,6.8617E-05_JPRB,7.9736E-05_JPRB,9.5061E-05_JPRB,1.1539E-04_JPRB/)
KBO( :,48, 1) = (/&
&4.7995E-05_JPRB,5.4058E-05_JPRB,6.2416E-05_JPRB,7.3982E-05_JPRB,8.9568E-05_JPRB/)
KBO( :,49, 1) = (/&
&3.8135E-05_JPRB,4.2643E-05_JPRB,4.8908E-05_JPRB,5.7603E-05_JPRB,6.9496E-05_JPRB/)
KBO( :,50, 1) = (/&
&3.0417E-05_JPRB,3.3789E-05_JPRB,3.8523E-05_JPRB,4.5097E-05_JPRB,5.4183E-05_JPRB/)
KBO( :,51, 1) = (/&
&2.4294E-05_JPRB,2.6856E-05_JPRB,3.0433E-05_JPRB,3.5411E-05_JPRB,4.2342E-05_JPRB/)
KBO( :,52, 1) = (/&
&1.9384E-05_JPRB,2.1372E-05_JPRB,2.4069E-05_JPRB,2.7837E-05_JPRB,3.3107E-05_JPRB/)
KBO( :,53, 1) = (/&
&1.5445E-05_JPRB,1.7027E-05_JPRB,1.9053E-05_JPRB,2.1903E-05_JPRB,2.5892E-05_JPRB/)
KBO( :,54, 1) = (/&
&1.2327E-05_JPRB,1.3603E-05_JPRB,1.5162E-05_JPRB,1.7332E-05_JPRB,2.0379E-05_JPRB/)
KBO( :,55, 1) = (/&
&9.8408E-06_JPRB,1.0879E-05_JPRB,1.2096E-05_JPRB,1.3752E-05_JPRB,1.6089E-05_JPRB/)
KBO( :,56, 1) = (/&
&7.8284E-06_JPRB,8.6964E-06_JPRB,9.6567E-06_JPRB,1.0920E-05_JPRB,1.2709E-05_JPRB/)
KBO( :,57, 1) = (/&
&6.2093E-06_JPRB,6.9436E-06_JPRB,7.7088E-06_JPRB,8.6775E-06_JPRB,1.0049E-05_JPRB/)
KBO( :,58, 1) = (/&
&4.9212E-06_JPRB,5.5457E-06_JPRB,6.1634E-06_JPRB,6.9165E-06_JPRB,7.9717E-06_JPRB/)
KBO( :,59, 1) = (/&
&3.9876E-06_JPRB,4.5117E-06_JPRB,5.0251E-06_JPRB,5.6457E-06_JPRB,6.5064E-06_JPRB/)
KBO( :,13, 2) = (/&
&1.3642E-01_JPRB,1.5192E-01_JPRB,1.7017E-01_JPRB,1.9179E-01_JPRB,2.1776E-01_JPRB/)
KBO( :,14, 2) = (/&
&1.1549E-01_JPRB,1.2903E-01_JPRB,1.4505E-01_JPRB,1.6416E-01_JPRB,1.8735E-01_JPRB/)
KBO( :,15, 2) = (/&
&9.7601E-02_JPRB,1.0941E-01_JPRB,1.2344E-01_JPRB,1.4044E-01_JPRB,1.6109E-01_JPRB/)
KBO( :,16, 2) = (/&
&8.2400E-02_JPRB,9.2656E-02_JPRB,1.0500E-01_JPRB,1.2010E-01_JPRB,1.3841E-01_JPRB/)
KBO( :,17, 2) = (/&
&6.9444E-02_JPRB,7.8382E-02_JPRB,8.9340E-02_JPRB,1.0266E-01_JPRB,1.1885E-01_JPRB/)
KBO( :,18, 2) = (/&
&5.8427E-02_JPRB,6.6311E-02_JPRB,7.5999E-02_JPRB,8.7777E-02_JPRB,1.0199E-01_JPRB/)
KBO( :,19, 2) = (/&
&4.9105E-02_JPRB,5.6056E-02_JPRB,6.4599E-02_JPRB,7.4928E-02_JPRB,8.7316E-02_JPRB/)
KBO( :,20, 2) = (/&
&4.1362E-02_JPRB,4.7500E-02_JPRB,5.4972E-02_JPRB,6.3982E-02_JPRB,7.4793E-02_JPRB/)
KBO( :,21, 2) = (/&
&3.4892E-02_JPRB,4.0253E-02_JPRB,4.6723E-02_JPRB,5.4540E-02_JPRB,6.3927E-02_JPRB/)
KBO( :,22, 2) = (/&
&2.9712E-02_JPRB,3.4419E-02_JPRB,4.0080E-02_JPRB,4.6923E-02_JPRB,5.5143E-02_JPRB/)
KBO( :,23, 2) = (/&
&2.5337E-02_JPRB,2.9440E-02_JPRB,3.4407E-02_JPRB,4.0399E-02_JPRB,4.7598E-02_JPRB/)
KBO( :,24, 2) = (/&
&2.1646E-02_JPRB,2.5231E-02_JPRB,2.9587E-02_JPRB,3.4849E-02_JPRB,4.1184E-02_JPRB/)
KBO( :,25, 2) = (/&
&1.8533E-02_JPRB,2.1686E-02_JPRB,2.5506E-02_JPRB,3.0158E-02_JPRB,3.5787E-02_JPRB/)
KBO( :,26, 2) = (/&
&1.5940E-02_JPRB,1.8720E-02_JPRB,2.2097E-02_JPRB,2.6247E-02_JPRB,3.1293E-02_JPRB/)
KBO( :,27, 2) = (/&
&1.3738E-02_JPRB,1.6188E-02_JPRB,1.9206E-02_JPRB,2.2922E-02_JPRB,2.7465E-02_JPRB/)
KBO( :,28, 2) = (/&
&1.1858E-02_JPRB,1.4036E-02_JPRB,1.6746E-02_JPRB,2.0086E-02_JPRB,2.4173E-02_JPRB/)
KBO( :,29, 2) = (/&
&1.0271E-02_JPRB,1.2222E-02_JPRB,1.4667E-02_JPRB,1.7690E-02_JPRB,2.1356E-02_JPRB/)
KBO( :,30, 2) = (/&
&8.9226E-03_JPRB,1.0686E-02_JPRB,1.2896E-02_JPRB,1.5632E-02_JPRB,1.8914E-02_JPRB/)
KBO( :,31, 2) = (/&
&7.7843E-03_JPRB,9.3890E-03_JPRB,1.1399E-02_JPRB,1.3861E-02_JPRB,1.6797E-02_JPRB/)
KBO( :,32, 2) = (/&
&6.8247E-03_JPRB,8.2905E-03_JPRB,1.0116E-02_JPRB,1.2328E-02_JPRB,1.4951E-02_JPRB/)
KBO( :,33, 2) = (/&
&6.0149E-03_JPRB,7.3520E-03_JPRB,8.9996E-03_JPRB,1.0989E-02_JPRB,1.3332E-02_JPRB/)
KBO( :,34, 2) = (/&
&5.2871E-03_JPRB,6.4941E-03_JPRB,7.9727E-03_JPRB,9.7480E-03_JPRB,1.1841E-02_JPRB/)
KBO( :,35, 2) = (/&
&4.5697E-03_JPRB,5.6343E-03_JPRB,6.9361E-03_JPRB,8.4981E-03_JPRB,1.0344E-02_JPRB/)
KBO( :,36, 2) = (/&
&3.8668E-03_JPRB,4.7847E-03_JPRB,5.9090E-03_JPRB,7.2600E-03_JPRB,8.8580E-03_JPRB/)
KBO( :,37, 2) = (/&
&3.1704E-03_JPRB,3.9381E-03_JPRB,4.8844E-03_JPRB,6.0241E-03_JPRB,7.3747E-03_JPRB/)
KBO( :,38, 2) = (/&
&2.5936E-03_JPRB,3.2350E-03_JPRB,4.0298E-03_JPRB,4.9900E-03_JPRB,6.1292E-03_JPRB/)
KBO( :,39, 2) = (/&
&2.1215E-03_JPRB,2.6573E-03_JPRB,3.3247E-03_JPRB,4.1335E-03_JPRB,5.0950E-03_JPRB/)
KBO( :,40, 2) = (/&
&1.6950E-03_JPRB,2.1322E-03_JPRB,2.6802E-03_JPRB,3.3483E-03_JPRB,4.1474E-03_JPRB/)
KBO( :,41, 2) = (/&
&1.3487E-03_JPRB,1.7036E-03_JPRB,2.1515E-03_JPRB,2.7015E-03_JPRB,3.3638E-03_JPRB/)
KBO( :,42, 2) = (/&
&1.0717E-03_JPRB,1.3591E-03_JPRB,1.7246E-03_JPRB,2.1766E-03_JPRB,2.7248E-03_JPRB/)
KBO( :,43, 2) = (/&
&8.3901E-04_JPRB,1.0683E-03_JPRB,1.3622E-03_JPRB,1.7292E-03_JPRB,2.1771E-03_JPRB/)
KBO( :,44, 2) = (/&
&6.5192E-04_JPRB,8.3311E-04_JPRB,1.0673E-03_JPRB,1.3624E-03_JPRB,1.7262E-03_JPRB/)
KBO( :,45, 2) = (/&
&5.0592E-04_JPRB,6.4840E-04_JPRB,8.3427E-04_JPRB,1.0708E-03_JPRB,1.3653E-03_JPRB/)
KBO( :,46, 2) = (/&
&3.9015E-04_JPRB,5.0066E-04_JPRB,6.4700E-04_JPRB,8.3496E-04_JPRB,1.0720E-03_JPRB/)
KBO( :,47, 2) = (/&
&2.9734E-04_JPRB,3.8142E-04_JPRB,4.9495E-04_JPRB,6.4229E-04_JPRB,8.3000E-04_JPRB/)
KBO( :,48, 2) = (/&
&2.2635E-04_JPRB,2.9002E-04_JPRB,3.7759E-04_JPRB,4.9244E-04_JPRB,6.4043E-04_JPRB/)
KBO( :,49, 2) = (/&
&1.7220E-04_JPRB,2.2034E-04_JPRB,2.8722E-04_JPRB,3.7634E-04_JPRB,4.9229E-04_JPRB/)
KBO( :,50, 2) = (/&
&1.3177E-04_JPRB,1.6818E-04_JPRB,2.1937E-04_JPRB,2.8871E-04_JPRB,3.7961E-04_JPRB/)
KBO( :,51, 2) = (/&
&1.0109E-04_JPRB,1.2859E-04_JPRB,1.6766E-04_JPRB,2.2156E-04_JPRB,2.9268E-04_JPRB/)
KBO( :,52, 2) = (/&
&7.7612E-05_JPRB,9.8243E-05_JPRB,1.2795E-04_JPRB,1.6959E-04_JPRB,2.2502E-04_JPRB/)
KBO( :,53, 2) = (/&
&5.9611E-05_JPRB,7.4979E-05_JPRB,9.7483E-05_JPRB,1.2940E-04_JPRB,1.7242E-04_JPRB/)
KBO( :,54, 2) = (/&
&4.6116E-05_JPRB,5.7675E-05_JPRB,7.4813E-05_JPRB,9.9354E-05_JPRB,1.3295E-04_JPRB/)
KBO( :,55, 2) = (/&
&3.5802E-05_JPRB,4.4529E-05_JPRB,5.7546E-05_JPRB,7.6441E-05_JPRB,1.0268E-04_JPRB/)
KBO( :,56, 2) = (/&
&2.7830E-05_JPRB,3.4393E-05_JPRB,4.4221E-05_JPRB,5.8724E-05_JPRB,7.9138E-05_JPRB/)
KBO( :,57, 2) = (/&
&2.1657E-05_JPRB,2.6571E-05_JPRB,3.3962E-05_JPRB,4.5038E-05_JPRB,6.0834E-05_JPRB/)
KBO( :,58, 2) = (/&
&1.6922E-05_JPRB,2.0621E-05_JPRB,2.6207E-05_JPRB,3.4660E-05_JPRB,4.6890E-05_JPRB/)
KBO( :,59, 2) = (/&
&1.3669E-05_JPRB,1.6659E-05_JPRB,2.1203E-05_JPRB,2.8141E-05_JPRB,3.8169E-05_JPRB/)
KBO( :,13, 3) = (/&
&4.6528E-01_JPRB,5.5437E-01_JPRB,6.5439E-01_JPRB,7.6387E-01_JPRB,8.8225E-01_JPRB/)
KBO( :,14, 3) = (/&
&4.0092E-01_JPRB,4.7676E-01_JPRB,5.6104E-01_JPRB,6.5300E-01_JPRB,7.5323E-01_JPRB/)
KBO( :,15, 3) = (/&
&3.4496E-01_JPRB,4.0936E-01_JPRB,4.8004E-01_JPRB,5.5783E-01_JPRB,6.4259E-01_JPRB/)
KBO( :,16, 3) = (/&
&2.9656E-01_JPRB,3.5091E-01_JPRB,4.1039E-01_JPRB,4.7609E-01_JPRB,5.4769E-01_JPRB/)
KBO( :,17, 3) = (/&
&2.5400E-01_JPRB,2.9985E-01_JPRB,3.5009E-01_JPRB,4.0555E-01_JPRB,4.6622E-01_JPRB/)
KBO( :,18, 3) = (/&
&2.1658E-01_JPRB,2.5524E-01_JPRB,2.9779E-01_JPRB,3.4497E-01_JPRB,3.9663E-01_JPRB/)
KBO( :,19, 3) = (/&
&1.8401E-01_JPRB,2.1660E-01_JPRB,2.5265E-01_JPRB,2.9293E-01_JPRB,3.3703E-01_JPRB/)
KBO( :,20, 3) = (/&
&1.5650E-01_JPRB,1.8401E-01_JPRB,2.1476E-01_JPRB,2.4926E-01_JPRB,2.8701E-01_JPRB/)
KBO( :,21, 3) = (/&
&1.3298E-01_JPRB,1.5631E-01_JPRB,1.8271E-01_JPRB,2.1234E-01_JPRB,2.4465E-01_JPRB/)
KBO( :,22, 3) = (/&
&1.1417E-01_JPRB,1.3429E-01_JPRB,1.5724E-01_JPRB,1.8276E-01_JPRB,2.1037E-01_JPRB/)
KBO( :,23, 3) = (/&
&9.8014E-02_JPRB,1.1558E-01_JPRB,1.3557E-01_JPRB,1.5742E-01_JPRB,1.8091E-01_JPRB/)
KBO( :,24, 3) = (/&
&8.4303E-02_JPRB,9.9682E-02_JPRB,1.1696E-01_JPRB,1.3564E-01_JPRB,1.5560E-01_JPRB/)
KBO( :,25, 3) = (/&
&7.2747E-02_JPRB,8.6163E-02_JPRB,1.0094E-01_JPRB,1.1688E-01_JPRB,1.3386E-01_JPRB/)
KBO( :,26, 3) = (/&
&6.3075E-02_JPRB,7.4679E-02_JPRB,8.7296E-02_JPRB,1.0089E-01_JPRB,1.1530E-01_JPRB/)
KBO( :,27, 3) = (/&
&5.4748E-02_JPRB,6.4713E-02_JPRB,7.5472E-02_JPRB,8.7090E-02_JPRB,9.9299E-02_JPRB/)
KBO( :,28, 3) = (/&
&4.7545E-02_JPRB,5.6049E-02_JPRB,6.5267E-02_JPRB,7.5162E-02_JPRB,8.5597E-02_JPRB/)
KBO( :,29, 3) = (/&
&4.1339E-02_JPRB,4.8610E-02_JPRB,5.6528E-02_JPRB,6.4950E-02_JPRB,7.3930E-02_JPRB/)
KBO( :,30, 3) = (/&
&3.5954E-02_JPRB,4.2191E-02_JPRB,4.8989E-02_JPRB,5.6214E-02_JPRB,6.3907E-02_JPRB/)
KBO( :,31, 3) = (/&
&3.1296E-02_JPRB,3.6680E-02_JPRB,4.2495E-02_JPRB,4.8776E-02_JPRB,5.5328E-02_JPRB/)
KBO( :,32, 3) = (/&
&2.7277E-02_JPRB,3.1929E-02_JPRB,3.6963E-02_JPRB,4.2388E-02_JPRB,4.7945E-02_JPRB/)
KBO( :,33, 3) = (/&
&2.3800E-02_JPRB,2.7822E-02_JPRB,3.2216E-02_JPRB,3.6870E-02_JPRB,4.1544E-02_JPRB/)
KBO( :,34, 3) = (/&
&2.0672E-02_JPRB,2.4161E-02_JPRB,2.7975E-02_JPRB,3.1921E-02_JPRB,3.5834E-02_JPRB/)
KBO( :,35, 3) = (/&
&1.7697E-02_JPRB,2.0710E-02_JPRB,2.3987E-02_JPRB,2.7306E-02_JPRB,3.0580E-02_JPRB/)
KBO( :,36, 3) = (/&
&1.4902E-02_JPRB,1.7480E-02_JPRB,2.0264E-02_JPRB,2.3055E-02_JPRB,2.5809E-02_JPRB/)
KBO( :,37, 3) = (/&
&1.2253E-02_JPRB,1.4429E-02_JPRB,1.6775E-02_JPRB,1.9126E-02_JPRB,2.1452E-02_JPRB/)
KBO( :,38, 3) = (/&
&1.0063E-02_JPRB,1.1900E-02_JPRB,1.3875E-02_JPRB,1.5855E-02_JPRB,1.7824E-02_JPRB/)
KBO( :,39, 3) = (/&
&8.2683E-03_JPRB,9.8196E-03_JPRB,1.1482E-02_JPRB,1.3151E-02_JPRB,1.4822E-02_JPRB/)
KBO( :,40, 3) = (/&
&6.6706E-03_JPRB,7.9659E-03_JPRB,9.3641E-03_JPRB,1.0772E-02_JPRB,1.2185E-02_JPRB/)
KBO( :,41, 3) = (/&
&5.3639E-03_JPRB,6.4425E-03_JPRB,7.6176E-03_JPRB,8.8040E-03_JPRB,9.9984E-03_JPRB/)
KBO( :,42, 3) = (/&
&4.3069E-03_JPRB,5.2039E-03_JPRB,6.1906E-03_JPRB,7.1908E-03_JPRB,8.2008E-03_JPRB/)
KBO( :,43, 3) = (/&
&3.4140E-03_JPRB,4.1540E-03_JPRB,4.9779E-03_JPRB,5.8242E-03_JPRB,6.6751E-03_JPRB/)
KBO( :,44, 3) = (/&
&2.6853E-03_JPRB,3.2927E-03_JPRB,3.9767E-03_JPRB,4.6909E-03_JPRB,5.4086E-03_JPRB/)
KBO( :,45, 3) = (/&
&2.1067E-03_JPRB,2.6025E-03_JPRB,3.1683E-03_JPRB,3.7707E-03_JPRB,4.3756E-03_JPRB/)
KBO( :,46, 3) = (/&
&1.6407E-03_JPRB,2.0417E-03_JPRB,2.5060E-03_JPRB,3.0128E-03_JPRB,3.5248E-03_JPRB/)
KBO( :,47, 3) = (/&
&1.2608E-03_JPRB,1.5817E-03_JPRB,1.9591E-03_JPRB,2.3817E-03_JPRB,2.8141E-03_JPRB/)
KBO( :,48, 3) = (/&
&9.6508E-04_JPRB,1.2203E-03_JPRB,1.5253E-03_JPRB,1.8746E-03_JPRB,2.2397E-03_JPRB/)
KBO( :,49, 3) = (/&
&7.3585E-04_JPRB,9.3796E-04_JPRB,1.1824E-03_JPRB,1.4683E-03_JPRB,1.7760E-03_JPRB/)
KBO( :,50, 3) = (/&
&5.6241E-04_JPRB,7.2242E-04_JPRB,9.1862E-04_JPRB,1.1510E-03_JPRB,1.4096E-03_JPRB/)
KBO( :,51, 3) = (/&
&4.2964E-04_JPRB,5.5593E-04_JPRB,7.1290E-04_JPRB,9.0146E-04_JPRB,1.1171E-03_JPRB/)
KBO( :,52, 3) = (/&
&3.2726E-04_JPRB,4.2631E-04_JPRB,5.5102E-04_JPRB,7.0359E-04_JPRB,8.8175E-04_JPRB/)
KBO( :,53, 3) = (/&
&2.4838E-04_JPRB,3.2560E-04_JPRB,4.2431E-04_JPRB,5.4692E-04_JPRB,6.9286E-04_JPRB/)
KBO( :,54, 3) = (/&
&1.8942E-04_JPRB,2.4999E-04_JPRB,3.2832E-04_JPRB,4.2678E-04_JPRB,5.4592E-04_JPRB/)
KBO( :,55, 3) = (/&
&1.4456E-04_JPRB,1.9209E-04_JPRB,2.5406E-04_JPRB,3.3310E-04_JPRB,4.3005E-04_JPRB/)
KBO( :,56, 3) = (/&
&1.1005E-04_JPRB,1.4722E-04_JPRB,1.9603E-04_JPRB,2.5905E-04_JPRB,3.3773E-04_JPRB/)
KBO( :,57, 3) = (/&
&8.3591E-05_JPRB,1.1253E-04_JPRB,1.5073E-04_JPRB,2.0071E-04_JPRB,2.6434E-04_JPRB/)
KBO( :,58, 3) = (/&
&6.3746E-05_JPRB,8.6176E-05_JPRB,1.1609E-04_JPRB,1.5578E-04_JPRB,2.0708E-04_JPRB/)
KBO( :,59, 3) = (/&
&5.1259E-05_JPRB,6.9567E-05_JPRB,9.4236E-05_JPRB,1.2739E-04_JPRB,1.7028E-04_JPRB/)
KBO( :,13, 4) = (/&
&1.7515E+00_JPRB,1.9495E+00_JPRB,2.1521E+00_JPRB,2.3581E+00_JPRB,2.5501E+00_JPRB/)
KBO( :,14, 4) = (/&
&1.4765E+00_JPRB,1.6496E+00_JPRB,1.8290E+00_JPRB,2.0062E+00_JPRB,2.1622E+00_JPRB/)
KBO( :,15, 4) = (/&
&1.2492E+00_JPRB,1.4011E+00_JPRB,1.5567E+00_JPRB,1.6989E+00_JPRB,1.8218E+00_JPRB/)
KBO( :,16, 4) = (/&
&1.0604E+00_JPRB,1.1904E+00_JPRB,1.3179E+00_JPRB,1.4307E+00_JPRB,1.5294E+00_JPRB/)
KBO( :,17, 4) = (/&
&8.9936E-01_JPRB,1.0071E+00_JPRB,1.1099E+00_JPRB,1.2005E+00_JPRB,1.2809E+00_JPRB/)
KBO( :,18, 4) = (/&
&7.6142E-01_JPRB,8.4995E-01_JPRB,9.3267E-01_JPRB,1.0060E+00_JPRB,1.0720E+00_JPRB/)
KBO( :,19, 4) = (/&
&6.4349E-01_JPRB,7.1626E-01_JPRB,7.8316E-01_JPRB,8.4250E-01_JPRB,8.9631E-01_JPRB/)
KBO( :,20, 4) = (/&
&5.4427E-01_JPRB,6.0390E-01_JPRB,6.5771E-01_JPRB,7.0547E-01_JPRB,7.4978E-01_JPRB/)
KBO( :,21, 4) = (/&
&4.5925E-01_JPRB,5.0777E-01_JPRB,5.5117E-01_JPRB,5.9049E-01_JPRB,6.2731E-01_JPRB/)
KBO( :,22, 4) = (/&
&3.8923E-01_JPRB,4.2824E-01_JPRB,4.6341E-01_JPRB,4.9590E-01_JPRB,5.2688E-01_JPRB/)
KBO( :,23, 4) = (/&
&3.2937E-01_JPRB,3.6081E-01_JPRB,3.8954E-01_JPRB,4.1663E-01_JPRB,4.4301E-01_JPRB/)
KBO( :,24, 4) = (/&
&2.7854E-01_JPRB,3.0409E-01_JPRB,3.2784E-01_JPRB,3.5064E-01_JPRB,3.7278E-01_JPRB/)
KBO( :,25, 4) = (/&
&2.3559E-01_JPRB,2.5658E-01_JPRB,2.7647E-01_JPRB,2.9561E-01_JPRB,3.1381E-01_JPRB/)
KBO( :,26, 4) = (/&
&1.9962E-01_JPRB,2.1703E-01_JPRB,2.3374E-01_JPRB,2.4963E-01_JPRB,2.6441E-01_JPRB/)
KBO( :,27, 4) = (/&
&1.6921E-01_JPRB,1.8380E-01_JPRB,1.9768E-01_JPRB,2.1076E-01_JPRB,2.2287E-01_JPRB/)
KBO( :,28, 4) = (/&
&1.4345E-01_JPRB,1.5565E-01_JPRB,1.6716E-01_JPRB,1.7793E-01_JPRB,1.8788E-01_JPRB/)
KBO( :,29, 4) = (/&
&1.2177E-01_JPRB,1.3186E-01_JPRB,1.4136E-01_JPRB,1.5019E-01_JPRB,1.5853E-01_JPRB/)
KBO( :,30, 4) = (/&
&1.0336E-01_JPRB,1.1168E-01_JPRB,1.1949E-01_JPRB,1.2673E-01_JPRB,1.3395E-01_JPRB/)
KBO( :,31, 4) = (/&
&8.7734E-02_JPRB,9.4596E-02_JPRB,1.0101E-01_JPRB,1.0703E-01_JPRB,1.1341E-01_JPRB/)
KBO( :,32, 4) = (/&
&7.4481E-02_JPRB,8.0126E-02_JPRB,8.5362E-02_JPRB,9.0546E-02_JPRB,9.6274E-02_JPRB/)
KBO( :,33, 4) = (/&
&6.3213E-02_JPRB,6.7862E-02_JPRB,7.2206E-02_JPRB,7.6786E-02_JPRB,8.2026E-02_JPRB/)
KBO( :,34, 4) = (/&
&5.3531E-02_JPRB,5.7349E-02_JPRB,6.1073E-02_JPRB,6.5202E-02_JPRB,6.9973E-02_JPRB/)
KBO( :,35, 4) = (/&
&4.5020E-02_JPRB,4.8200E-02_JPRB,5.1452E-02_JPRB,5.5159E-02_JPRB,5.9429E-02_JPRB/)
KBO( :,36, 4) = (/&
&3.7576E-02_JPRB,4.0274E-02_JPRB,4.3123E-02_JPRB,4.6399E-02_JPRB,5.0146E-02_JPRB/)
KBO( :,37, 4) = (/&
&3.1036E-02_JPRB,3.3333E-02_JPRB,3.5789E-02_JPRB,3.8617E-02_JPRB,4.1842E-02_JPRB/)
KBO( :,38, 4) = (/&
&2.5615E-02_JPRB,2.7577E-02_JPRB,2.9689E-02_JPRB,3.2124E-02_JPRB,3.4898E-02_JPRB/)
KBO( :,39, 4) = (/&
&2.1142E-02_JPRB,2.2815E-02_JPRB,2.4636E-02_JPRB,2.6727E-02_JPRB,2.9117E-02_JPRB/)
KBO( :,40, 4) = (/&
&1.7305E-02_JPRB,1.8730E-02_JPRB,2.0274E-02_JPRB,2.2044E-02_JPRB,2.4076E-02_JPRB/)
KBO( :,41, 4) = (/&
&1.4141E-02_JPRB,1.5353E-02_JPRB,1.6658E-02_JPRB,1.8154E-02_JPRB,1.9875E-02_JPRB/)
KBO( :,42, 4) = (/&
&1.1548E-02_JPRB,1.2579E-02_JPRB,1.3681E-02_JPRB,1.4943E-02_JPRB,1.6400E-02_JPRB/)
KBO( :,43, 4) = (/&
&9.3739E-03_JPRB,1.0251E-02_JPRB,1.1178E-02_JPRB,1.2234E-02_JPRB,1.3456E-02_JPRB/)
KBO( :,44, 4) = (/&
&7.5827E-03_JPRB,8.3302E-03_JPRB,9.1085E-03_JPRB,9.9874E-03_JPRB,1.1008E-02_JPRB/)
KBO( :,45, 4) = (/&
&6.1263E-03_JPRB,6.7635E-03_JPRB,7.4181E-03_JPRB,8.1480E-03_JPRB,8.9981E-03_JPRB/)
KBO( :,46, 4) = (/&
&4.9321E-03_JPRB,5.4733E-03_JPRB,6.0244E-03_JPRB,6.6282E-03_JPRB,7.3328E-03_JPRB/)
KBO( :,47, 4) = (/&
&3.9434E-03_JPRB,4.4020E-03_JPRB,4.8671E-03_JPRB,5.3648E-03_JPRB,5.9417E-03_JPRB/)
KBO( :,48, 4) = (/&
&3.1433E-03_JPRB,3.5325E-03_JPRB,3.9255E-03_JPRB,4.3369E-03_JPRB,4.8087E-03_JPRB/)
KBO( :,49, 4) = (/&
&2.4978E-03_JPRB,2.8291E-03_JPRB,3.1605E-03_JPRB,3.5019E-03_JPRB,3.8874E-03_JPRB/)
KBO( :,50, 4) = (/&
&1.9842E-03_JPRB,2.2663E-03_JPRB,2.5454E-03_JPRB,2.8316E-03_JPRB,3.1474E-03_JPRB/)
KBO( :,51, 4) = (/&
&1.5720E-03_JPRB,1.8131E-03_JPRB,2.0480E-03_JPRB,2.2890E-03_JPRB,2.5485E-03_JPRB/)
KBO( :,52, 4) = (/&
&1.2397E-03_JPRB,1.4466E-03_JPRB,1.6443E-03_JPRB,1.8471E-03_JPRB,2.0617E-03_JPRB/)
KBO( :,53, 4) = (/&
&9.7269E-04_JPRB,1.1506E-03_JPRB,1.3170E-03_JPRB,1.4882E-03_JPRB,1.6660E-03_JPRB/)
KBO( :,54, 4) = (/&
&7.6427E-04_JPRB,9.1578E-04_JPRB,1.0573E-03_JPRB,1.2008E-03_JPRB,1.3494E-03_JPRB/)
KBO( :,55, 4) = (/&
&5.9962E-04_JPRB,7.2798E-04_JPRB,8.4833E-04_JPRB,9.6858E-04_JPRB,1.0933E-03_JPRB/)
KBO( :,56, 4) = (/&
&4.6816E-04_JPRB,5.7642E-04_JPRB,6.7912E-04_JPRB,7.7992E-04_JPRB,8.8480E-04_JPRB/)
KBO( :,57, 4) = (/&
&3.6414E-04_JPRB,4.5440E-04_JPRB,5.4227E-04_JPRB,6.2686E-04_JPRB,7.1489E-04_JPRB/)
KBO( :,58, 4) = (/&
&2.8365E-04_JPRB,3.5805E-04_JPRB,4.3286E-04_JPRB,5.0398E-04_JPRB,5.7785E-04_JPRB/)
KBO( :,59, 4) = (/&
&2.3044E-04_JPRB,2.9262E-04_JPRB,3.5550E-04_JPRB,4.1574E-04_JPRB,4.7795E-04_JPRB/)
KBO( :,13, 5) = (/&
&4.6093E+00_JPRB,4.6787E+00_JPRB,4.7279E+00_JPRB,4.7779E+00_JPRB,4.8597E+00_JPRB/)
KBO( :,14, 5) = (/&
&3.8282E+00_JPRB,3.8821E+00_JPRB,3.9279E+00_JPRB,3.9847E+00_JPRB,4.0757E+00_JPRB/)
KBO( :,15, 5) = (/&
&3.1725E+00_JPRB,3.2179E+00_JPRB,3.2654E+00_JPRB,3.3336E+00_JPRB,3.4242E+00_JPRB/)
KBO( :,16, 5) = (/&
&2.6254E+00_JPRB,2.6717E+00_JPRB,2.7257E+00_JPRB,2.7935E+00_JPRB,2.8681E+00_JPRB/)
KBO( :,17, 5) = (/&
&2.1766E+00_JPRB,2.2257E+00_JPRB,2.2759E+00_JPRB,2.3323E+00_JPRB,2.3943E+00_JPRB/)
KBO( :,18, 5) = (/&
&1.8104E+00_JPRB,1.8529E+00_JPRB,1.8948E+00_JPRB,1.9412E+00_JPRB,1.9943E+00_JPRB/)
KBO( :,19, 5) = (/&
&1.5048E+00_JPRB,1.5390E+00_JPRB,1.5736E+00_JPRB,1.6140E+00_JPRB,1.6604E+00_JPRB/)
KBO( :,20, 5) = (/&
&1.2496E+00_JPRB,1.2771E+00_JPRB,1.3070E+00_JPRB,1.3421E+00_JPRB,1.3834E+00_JPRB/)
KBO( :,21, 5) = (/&
&1.0376E+00_JPRB,1.0603E+00_JPRB,1.0863E+00_JPRB,1.1161E+00_JPRB,1.1527E+00_JPRB/)
KBO( :,22, 5) = (/&
&8.6290E-01_JPRB,8.8239E-01_JPRB,9.0428E-01_JPRB,9.3058E-01_JPRB,9.6346E-01_JPRB/)
KBO( :,23, 5) = (/&
&7.1714E-01_JPRB,7.3382E-01_JPRB,7.5282E-01_JPRB,7.7698E-01_JPRB,8.0640E-01_JPRB/)
KBO( :,24, 5) = (/&
&5.9554E-01_JPRB,6.0982E-01_JPRB,6.2698E-01_JPRB,6.4926E-01_JPRB,6.7588E-01_JPRB/)
KBO( :,25, 5) = (/&
&4.9438E-01_JPRB,5.0695E-01_JPRB,5.2299E-01_JPRB,5.4349E-01_JPRB,5.6801E-01_JPRB/)
KBO( :,26, 5) = (/&
&4.1054E-01_JPRB,4.2226E-01_JPRB,4.3732E-01_JPRB,4.5640E-01_JPRB,4.7888E-01_JPRB/)
KBO( :,27, 5) = (/&
&3.4145E-01_JPRB,3.5257E-01_JPRB,3.6692E-01_JPRB,3.8422E-01_JPRB,4.0431E-01_JPRB/)
KBO( :,28, 5) = (/&
&2.8483E-01_JPRB,2.9535E-01_JPRB,3.0859E-01_JPRB,3.2404E-01_JPRB,3.4192E-01_JPRB/)
KBO( :,29, 5) = (/&
&2.3827E-01_JPRB,2.4827E-01_JPRB,2.6013E-01_JPRB,2.7398E-01_JPRB,2.9004E-01_JPRB/)
KBO( :,30, 5) = (/&
&1.9983E-01_JPRB,2.0911E-01_JPRB,2.1978E-01_JPRB,2.3227E-01_JPRB,2.4681E-01_JPRB/)
KBO( :,31, 5) = (/&
&1.6804E-01_JPRB,1.7642E-01_JPRB,1.8613E-01_JPRB,1.9752E-01_JPRB,2.1089E-01_JPRB/)
KBO( :,32, 5) = (/&
&1.4159E-01_JPRB,1.4918E-01_JPRB,1.5803E-01_JPRB,1.6847E-01_JPRB,1.8108E-01_JPRB/)
KBO( :,33, 5) = (/&
&1.1954E-01_JPRB,1.2642E-01_JPRB,1.3455E-01_JPRB,1.4426E-01_JPRB,1.5610E-01_JPRB/)
KBO( :,34, 5) = (/&
&1.0095E-01_JPRB,1.0717E-01_JPRB,1.1462E-01_JPRB,1.2375E-01_JPRB,1.3481E-01_JPRB/)
KBO( :,35, 5) = (/&
&8.4924E-02_JPRB,9.0501E-02_JPRB,9.7279E-02_JPRB,1.0569E-01_JPRB,1.1588E-01_JPRB/)
KBO( :,36, 5) = (/&
&7.1064E-02_JPRB,7.5984E-02_JPRB,8.2057E-02_JPRB,8.9603E-02_JPRB,9.8847E-02_JPRB/)
KBO( :,37, 5) = (/&
&5.8932E-02_JPRB,6.3161E-02_JPRB,6.8439E-02_JPRB,7.5043E-02_JPRB,8.3182E-02_JPRB/)
KBO( :,38, 5) = (/&
&4.8865E-02_JPRB,5.2499E-02_JPRB,5.7079E-02_JPRB,6.2859E-02_JPRB,7.0017E-02_JPRB/)
KBO( :,39, 5) = (/&
&4.0531E-02_JPRB,4.3655E-02_JPRB,4.7640E-02_JPRB,5.2727E-02_JPRB,5.9016E-02_JPRB/)
KBO( :,40, 5) = (/&
&3.3380E-02_JPRB,3.6019E-02_JPRB,3.9402E-02_JPRB,4.3769E-02_JPRB,4.9191E-02_JPRB/)
KBO( :,41, 5) = (/&
&2.7463E-02_JPRB,2.9675E-02_JPRB,3.2537E-02_JPRB,3.6268E-02_JPRB,4.0932E-02_JPRB/)
KBO( :,42, 5) = (/&
&2.2583E-02_JPRB,2.4432E-02_JPRB,2.6850E-02_JPRB,3.0032E-02_JPRB,3.4041E-02_JPRB/)
KBO( :,43, 5) = (/&
&1.8485E-02_JPRB,2.0010E-02_JPRB,2.2013E-02_JPRB,2.4687E-02_JPRB,2.8084E-02_JPRB/)
KBO( :,44, 5) = (/&
&1.5098E-02_JPRB,1.6344E-02_JPRB,1.7988E-02_JPRB,2.0205E-02_JPRB,2.3066E-02_JPRB/)
KBO( :,45, 5) = (/&
&1.2325E-02_JPRB,1.3345E-02_JPRB,1.4686E-02_JPRB,1.6519E-02_JPRB,1.8916E-02_JPRB/)
KBO( :,46, 5) = (/&
&1.0042E-02_JPRB,1.0870E-02_JPRB,1.1952E-02_JPRB,1.3450E-02_JPRB,1.5443E-02_JPRB/)
KBO( :,47, 5) = (/&
&8.1480E-03_JPRB,8.8179E-03_JPRB,9.6778E-03_JPRB,1.0879E-02_JPRB,1.2508E-02_JPRB/)
KBO( :,48, 5) = (/&
&6.6080E-03_JPRB,7.1502E-03_JPRB,7.8346E-03_JPRB,8.7926E-03_JPRB,1.0114E-02_JPRB/)
KBO( :,49, 5) = (/&
&5.3563E-03_JPRB,5.7957E-03_JPRB,6.3414E-03_JPRB,7.1019E-03_JPRB,8.1661E-03_JPRB/)
KBO( :,50, 5) = (/&
&4.3491E-03_JPRB,4.7045E-03_JPRB,5.1464E-03_JPRB,5.7505E-03_JPRB,6.6095E-03_JPRB/)
KBO( :,51, 5) = (/&
&3.5331E-03_JPRB,3.8208E-03_JPRB,4.1803E-03_JPRB,4.6605E-03_JPRB,5.3531E-03_JPRB/)
KBO( :,52, 5) = (/&
&2.8692E-03_JPRB,3.1024E-03_JPRB,3.3948E-03_JPRB,3.7764E-03_JPRB,4.3307E-03_JPRB/)
KBO( :,53, 5) = (/&
&2.3284E-03_JPRB,2.5177E-03_JPRB,2.7545E-03_JPRB,3.0575E-03_JPRB,3.4986E-03_JPRB/)
KBO( :,54, 5) = (/&
&1.8918E-03_JPRB,2.0476E-03_JPRB,2.2400E-03_JPRB,2.4835E-03_JPRB,2.8364E-03_JPRB/)
KBO( :,55, 5) = (/&
&1.5376E-03_JPRB,1.6662E-03_JPRB,1.8225E-03_JPRB,2.0195E-03_JPRB,2.3020E-03_JPRB/)
KBO( :,56, 5) = (/&
&1.2490E-03_JPRB,1.3549E-03_JPRB,1.4817E-03_JPRB,1.6414E-03_JPRB,1.8660E-03_JPRB/)
KBO( :,57, 5) = (/&
&1.0129E-03_JPRB,1.1011E-03_JPRB,1.2038E-03_JPRB,1.3331E-03_JPRB,1.5112E-03_JPRB/)
KBO( :,58, 5) = (/&
&8.2101E-04_JPRB,8.9501E-04_JPRB,9.7881E-04_JPRB,1.0839E-03_JPRB,1.2260E-03_JPRB/)
KBO( :,59, 5) = (/&
&6.7572E-04_JPRB,7.3861E-04_JPRB,8.0949E-04_JPRB,8.9902E-04_JPRB,1.0203E-03_JPRB/)
KBO( :,13, 6) = (/&
&8.6113E+00_JPRB,8.6083E+00_JPRB,8.6450E+00_JPRB,8.7235E+00_JPRB,8.8556E+00_JPRB/)
KBO( :,14, 6) = (/&
&7.2014E+00_JPRB,7.2025E+00_JPRB,7.2397E+00_JPRB,7.3254E+00_JPRB,7.4723E+00_JPRB/)
KBO( :,15, 6) = (/&
&6.0044E+00_JPRB,6.0112E+00_JPRB,6.0572E+00_JPRB,6.1588E+00_JPRB,6.3194E+00_JPRB/)
KBO( :,16, 6) = (/&
&4.9871E+00_JPRB,5.0011E+00_JPRB,5.0609E+00_JPRB,5.1819E+00_JPRB,5.3526E+00_JPRB/)
KBO( :,17, 6) = (/&
&4.1295E+00_JPRB,4.1562E+00_JPRB,4.2380E+00_JPRB,4.3711E+00_JPRB,4.5320E+00_JPRB/)
KBO( :,18, 6) = (/&
&3.4160E+00_JPRB,3.4619E+00_JPRB,3.5592E+00_JPRB,3.6837E+00_JPRB,3.8207E+00_JPRB/)
KBO( :,19, 6) = (/&
&2.8320E+00_JPRB,2.8936E+00_JPRB,2.9843E+00_JPRB,3.0907E+00_JPRB,3.2080E+00_JPRB/)
KBO( :,20, 6) = (/&
&2.3566E+00_JPRB,2.4173E+00_JPRB,2.4971E+00_JPRB,2.5878E+00_JPRB,2.6909E+00_JPRB/)
KBO( :,21, 6) = (/&
&1.9610E+00_JPRB,2.0160E+00_JPRB,2.0844E+00_JPRB,2.1648E+00_JPRB,2.2552E+00_JPRB/)
KBO( :,22, 6) = (/&
&1.6333E+00_JPRB,1.6835E+00_JPRB,1.7446E+00_JPRB,1.8165E+00_JPRB,1.8978E+00_JPRB/)
KBO( :,23, 6) = (/&
&1.3622E+00_JPRB,1.4076E+00_JPRB,1.4625E+00_JPRB,1.5261E+00_JPRB,1.5991E+00_JPRB/)
KBO( :,24, 6) = (/&
&1.1385E+00_JPRB,1.1796E+00_JPRB,1.2278E+00_JPRB,1.2843E+00_JPRB,1.3507E+00_JPRB/)
KBO( :,25, 6) = (/&
&9.5319E-01_JPRB,9.8944E-01_JPRB,1.0319E+00_JPRB,1.0833E+00_JPRB,1.1441E+00_JPRB/)
KBO( :,26, 6) = (/&
&7.9849E-01_JPRB,8.3054E-01_JPRB,8.6957E-01_JPRB,9.1733E-01_JPRB,9.7330E-01_JPRB/)
KBO( :,27, 6) = (/&
&6.6899E-01_JPRB,6.9794E-01_JPRB,7.3432E-01_JPRB,7.7906E-01_JPRB,8.3118E-01_JPRB/)
KBO( :,28, 6) = (/&
&5.6075E-01_JPRB,5.8798E-01_JPRB,6.2243E-01_JPRB,6.6420E-01_JPRB,7.1248E-01_JPRB/)
KBO( :,29, 6) = (/&
&4.7122E-01_JPRB,4.9735E-01_JPRB,5.3000E-01_JPRB,5.6898E-01_JPRB,6.1331E-01_JPRB/)
KBO( :,30, 6) = (/&
&3.9766E-01_JPRB,4.2278E-01_JPRB,4.5340E-01_JPRB,4.8935E-01_JPRB,5.2965E-01_JPRB/)
KBO( :,31, 6) = (/&
&3.3747E-01_JPRB,3.6139E-01_JPRB,3.8970E-01_JPRB,4.2246E-01_JPRB,4.5888E-01_JPRB/)
KBO( :,32, 6) = (/&
&2.8804E-01_JPRB,3.1035E-01_JPRB,3.3634E-01_JPRB,3.6608E-01_JPRB,3.9890E-01_JPRB/)
KBO( :,33, 6) = (/&
&2.4714E-01_JPRB,2.6763E-01_JPRB,2.9142E-01_JPRB,3.1834E-01_JPRB,3.4859E-01_JPRB/)
KBO( :,34, 6) = (/&
&2.1224E-01_JPRB,2.3103E-01_JPRB,2.5268E-01_JPRB,2.7715E-01_JPRB,3.0529E-01_JPRB/)
KBO( :,35, 6) = (/&
&1.8132E-01_JPRB,1.9841E-01_JPRB,2.1788E-01_JPRB,2.4021E-01_JPRB,2.6615E-01_JPRB/)
KBO( :,36, 6) = (/&
&1.5372E-01_JPRB,1.6906E-01_JPRB,1.8646E-01_JPRB,2.0663E-01_JPRB,2.3032E-01_JPRB/)
KBO( :,37, 6) = (/&
&1.2864E-01_JPRB,1.4207E-01_JPRB,1.5741E-01_JPRB,1.7532E-01_JPRB,1.9647E-01_JPRB/)
KBO( :,38, 6) = (/&
&1.0758E-01_JPRB,1.1934E-01_JPRB,1.3284E-01_JPRB,1.4872E-01_JPRB,1.6769E-01_JPRB/)
KBO( :,39, 6) = (/&
&9.0014E-02_JPRB,1.0028E-01_JPRB,1.1215E-01_JPRB,1.2626E-01_JPRB,1.4329E-01_JPRB/)
KBO( :,40, 6) = (/&
&7.4527E-02_JPRB,8.3327E-02_JPRB,9.3593E-02_JPRB,1.0586E-01_JPRB,1.2084E-01_JPRB/)
KBO( :,41, 6) = (/&
&6.1610E-02_JPRB,6.9119E-02_JPRB,7.7943E-02_JPRB,8.8568E-02_JPRB,1.0169E-01_JPRB/)
KBO( :,42, 6) = (/&
&5.0916E-02_JPRB,5.7313E-02_JPRB,6.4881E-02_JPRB,7.4072E-02_JPRB,8.5537E-02_JPRB/)
KBO( :,43, 6) = (/&
&4.1772E-02_JPRB,4.7174E-02_JPRB,5.3598E-02_JPRB,6.1449E-02_JPRB,7.1316E-02_JPRB/)
KBO( :,44, 6) = (/&
&3.4127E-02_JPRB,3.8669E-02_JPRB,4.4102E-02_JPRB,5.0754E-02_JPRB,5.9162E-02_JPRB/)
KBO( :,45, 6) = (/&
&2.7847E-02_JPRB,3.1650E-02_JPRB,3.6246E-02_JPRB,4.1879E-02_JPRB,4.9025E-02_JPRB/)
KBO( :,46, 6) = (/&
&2.2640E-02_JPRB,2.5789E-02_JPRB,2.9652E-02_JPRB,3.4397E-02_JPRB,4.0430E-02_JPRB/)
KBO( :,47, 6) = (/&
&1.8270E-02_JPRB,2.0851E-02_JPRB,2.4060E-02_JPRB,2.8007E-02_JPRB,3.3038E-02_JPRB/)
KBO( :,48, 6) = (/&
&1.4718E-02_JPRB,1.6825E-02_JPRB,1.9472E-02_JPRB,2.2745E-02_JPRB,2.6928E-02_JPRB/)
KBO( :,49, 6) = (/&
&1.1830E-02_JPRB,1.3552E-02_JPRB,1.5716E-02_JPRB,1.8420E-02_JPRB,2.1884E-02_JPRB/)
KBO( :,50, 6) = (/&
&9.5237E-03_JPRB,1.0928E-02_JPRB,1.2702E-02_JPRB,1.4943E-02_JPRB,1.7817E-02_JPRB/)
KBO( :,51, 6) = (/&
&7.6692E-03_JPRB,8.8098E-03_JPRB,1.0261E-02_JPRB,1.2117E-02_JPRB,1.4501E-02_JPRB/)
KBO( :,52, 6) = (/&
&6.1727E-03_JPRB,7.0883E-03_JPRB,8.2706E-03_JPRB,9.8014E-03_JPRB,1.1773E-02_JPRB/)
KBO( :,53, 6) = (/&
&4.9680E-03_JPRB,5.6916E-03_JPRB,6.6514E-03_JPRB,7.9092E-03_JPRB,9.5340E-03_JPRB/)
KBO( :,54, 6) = (/&
&4.0130E-03_JPRB,4.5840E-03_JPRB,5.3714E-03_JPRB,6.4027E-03_JPRB,7.7491E-03_JPRB/)
KBO( :,55, 6) = (/&
&3.2475E-03_JPRB,3.6955E-03_JPRB,4.3373E-03_JPRB,5.1858E-03_JPRB,6.3030E-03_JPRB/)
KBO( :,56, 6) = (/&
&2.6304E-03_JPRB,2.9771E-03_JPRB,3.4979E-03_JPRB,4.1928E-03_JPRB,5.1174E-03_JPRB/)
KBO( :,57, 6) = (/&
&2.1330E-03_JPRB,2.3975E-03_JPRB,2.8161E-03_JPRB,3.3836E-03_JPRB,4.1464E-03_JPRB/)
KBO( :,58, 6) = (/&
&1.7350E-03_JPRB,1.9351E-03_JPRB,2.2702E-03_JPRB,2.7338E-03_JPRB,3.3646E-03_JPRB/)
KBO( :,59, 6) = (/&
&1.4314E-03_JPRB,1.6016E-03_JPRB,1.8884E-03_JPRB,2.2911E-03_JPRB,2.8369E-03_JPRB/)
KBO( :,13, 7) = (/&
&1.7998E+01_JPRB,1.8384E+01_JPRB,1.8787E+01_JPRB,1.9175E+01_JPRB,1.9563E+01_JPRB/)
KBO( :,14, 7) = (/&
&1.5399E+01_JPRB,1.5722E+01_JPRB,1.6043E+01_JPRB,1.6364E+01_JPRB,1.6692E+01_JPRB/)
KBO( :,15, 7) = (/&
&1.3091E+01_JPRB,1.3337E+01_JPRB,1.3597E+01_JPRB,1.3865E+01_JPRB,1.4179E+01_JPRB/)
KBO( :,16, 7) = (/&
&1.1057E+01_JPRB,1.1261E+01_JPRB,1.1479E+01_JPRB,1.1723E+01_JPRB,1.2049E+01_JPRB/)
KBO( :,17, 7) = (/&
&9.3100E+00_JPRB,9.4784E+00_JPRB,9.6707E+00_JPRB,9.9204E+00_JPRB,1.0268E+01_JPRB/)
KBO( :,18, 7) = (/&
&7.8212E+00_JPRB,7.9725E+00_JPRB,8.1612E+00_JPRB,8.4289E+00_JPRB,8.7794E+00_JPRB/)
KBO( :,19, 7) = (/&
&6.5480E+00_JPRB,6.6917E+00_JPRB,6.8980E+00_JPRB,7.1803E+00_JPRB,7.5042E+00_JPRB/)
KBO( :,20, 7) = (/&
&5.4693E+00_JPRB,5.6250E+00_JPRB,5.8473E+00_JPRB,6.1172E+00_JPRB,6.4007E+00_JPRB/)
KBO( :,21, 7) = (/&
&4.5737E+00_JPRB,4.7442E+00_JPRB,4.9649E+00_JPRB,5.1990E+00_JPRB,5.4386E+00_JPRB/)
KBO( :,22, 7) = (/&
&3.8455E+00_JPRB,4.0231E+00_JPRB,4.2157E+00_JPRB,4.4147E+00_JPRB,4.6179E+00_JPRB/)
KBO( :,23, 7) = (/&
&3.2447E+00_JPRB,3.4045E+00_JPRB,3.5713E+00_JPRB,3.7411E+00_JPRB,3.9201E+00_JPRB/)
KBO( :,24, 7) = (/&
&2.7398E+00_JPRB,2.8775E+00_JPRB,3.0223E+00_JPRB,3.1715E+00_JPRB,3.3312E+00_JPRB/)
KBO( :,25, 7) = (/&
&2.3131E+00_JPRB,2.4334E+00_JPRB,2.5607E+00_JPRB,2.6934E+00_JPRB,2.8395E+00_JPRB/)
KBO( :,26, 7) = (/&
&1.9571E+00_JPRB,2.0628E+00_JPRB,2.1758E+00_JPRB,2.2949E+00_JPRB,2.4331E+00_JPRB/)
KBO( :,27, 7) = (/&
&1.6594E+00_JPRB,1.7534E+00_JPRB,1.8527E+00_JPRB,1.9641E+00_JPRB,2.0963E+00_JPRB/)
KBO( :,28, 7) = (/&
&1.4114E+00_JPRB,1.4941E+00_JPRB,1.5830E+00_JPRB,1.6881E+00_JPRB,1.8157E+00_JPRB/)
KBO( :,29, 7) = (/&
&1.2034E+00_JPRB,1.2757E+00_JPRB,1.3579E+00_JPRB,1.4591E+00_JPRB,1.5811E+00_JPRB/)
KBO( :,30, 7) = (/&
&1.0272E+00_JPRB,1.0924E+00_JPRB,1.1710E+00_JPRB,1.2689E+00_JPRB,1.3849E+00_JPRB/)
KBO( :,31, 7) = (/&
&8.7820E-01_JPRB,9.4005E-01_JPRB,1.0171E+00_JPRB,1.1110E+00_JPRB,1.2204E+00_JPRB/)
KBO( :,32, 7) = (/&
&7.5354E-01_JPRB,8.1419E-01_JPRB,8.8955E-01_JPRB,9.7931E-01_JPRB,1.0823E+00_JPRB/)
KBO( :,33, 7) = (/&
&6.5024E-01_JPRB,7.1018E-01_JPRB,7.8337E-01_JPRB,8.6897E-01_JPRB,9.6647E-01_JPRB/)
KBO( :,34, 7) = (/&
&5.6343E-01_JPRB,6.2181E-01_JPRB,6.9198E-01_JPRB,7.7311E-01_JPRB,8.6525E-01_JPRB/)
KBO( :,35, 7) = (/&
&4.8705E-01_JPRB,5.4236E-01_JPRB,6.0822E-01_JPRB,6.8426E-01_JPRB,7.7067E-01_JPRB/)
KBO( :,36, 7) = (/&
&4.1841E-01_JPRB,4.6955E-01_JPRB,5.3016E-01_JPRB,6.0039E-01_JPRB,6.8061E-01_JPRB/)
KBO( :,37, 7) = (/&
&3.5459E-01_JPRB,4.0042E-01_JPRB,4.5487E-01_JPRB,5.1825E-01_JPRB,5.9150E-01_JPRB/)
KBO( :,38, 7) = (/&
&3.0070E-01_JPRB,3.4160E-01_JPRB,3.9046E-01_JPRB,4.4765E-01_JPRB,5.1436E-01_JPRB/)
KBO( :,39, 7) = (/&
&2.5532E-01_JPRB,2.9176E-01_JPRB,3.3565E-01_JPRB,3.8725E-01_JPRB,4.4814E-01_JPRB/)
KBO( :,40, 7) = (/&
&2.1409E-01_JPRB,2.4592E-01_JPRB,2.8460E-01_JPRB,3.3041E-01_JPRB,3.8495E-01_JPRB/)
KBO( :,41, 7) = (/&
&1.7907E-01_JPRB,2.0691E-01_JPRB,2.4085E-01_JPRB,2.8135E-01_JPRB,3.3001E-01_JPRB/)
KBO( :,42, 7) = (/&
&1.4955E-01_JPRB,1.7397E-01_JPRB,2.0378E-01_JPRB,2.3951E-01_JPRB,2.8290E-01_JPRB/)
KBO( :,43, 7) = (/&
&1.2365E-01_JPRB,1.4471E-01_JPRB,1.7077E-01_JPRB,2.0210E-01_JPRB,2.4022E-01_JPRB/)
KBO( :,44, 7) = (/&
&1.0162E-01_JPRB,1.1963E-01_JPRB,1.4218E-01_JPRB,1.6960E-01_JPRB,2.0293E-01_JPRB/)
KBO( :,45, 7) = (/&
&8.3355E-02_JPRB,9.8637E-02_JPRB,1.1807E-01_JPRB,1.4201E-01_JPRB,1.7123E-01_JPRB/)
KBO( :,46, 7) = (/&
&6.8005E-02_JPRB,8.0800E-02_JPRB,9.7358E-02_JPRB,1.1807E-01_JPRB,1.4373E-01_JPRB/)
KBO( :,47, 7) = (/&
&5.5003E-02_JPRB,6.5496E-02_JPRB,7.9363E-02_JPRB,9.6996E-02_JPRB,1.1911E-01_JPRB/)
KBO( :,48, 7) = (/&
&4.4405E-02_JPRB,5.2953E-02_JPRB,6.4487E-02_JPRB,7.9375E-02_JPRB,9.8343E-02_JPRB/)
KBO( :,49, 7) = (/&
&3.5783E-02_JPRB,4.2715E-02_JPRB,5.2233E-02_JPRB,6.4713E-02_JPRB,8.0863E-02_JPRB/)
KBO( :,50, 7) = (/&
&2.8912E-02_JPRB,3.4525E-02_JPRB,4.2407E-02_JPRB,5.2882E-02_JPRB,6.6632E-02_JPRB/)
KBO( :,51, 7) = (/&
&2.3366E-02_JPRB,2.7895E-02_JPRB,3.4405E-02_JPRB,4.3195E-02_JPRB,5.4868E-02_JPRB/)
KBO( :,52, 7) = (/&
&1.8859E-02_JPRB,2.2482E-02_JPRB,2.7819E-02_JPRB,3.5177E-02_JPRB,4.5036E-02_JPRB/)
KBO( :,53, 7) = (/&
&1.5196E-02_JPRB,1.8070E-02_JPRB,2.2410E-02_JPRB,2.8538E-02_JPRB,3.6840E-02_JPRB/)
KBO( :,54, 7) = (/&
&1.2283E-02_JPRB,1.4588E-02_JPRB,1.8123E-02_JPRB,2.3240E-02_JPRB,3.0277E-02_JPRB/)
KBO( :,55, 7) = (/&
&9.9346E-03_JPRB,1.1792E-02_JPRB,1.4660E-02_JPRB,1.8922E-02_JPRB,2.4879E-02_JPRB/)
KBO( :,56, 7) = (/&
&8.0224E-03_JPRB,9.5173E-03_JPRB,1.1833E-02_JPRB,1.5354E-02_JPRB,2.0376E-02_JPRB/)
KBO( :,57, 7) = (/&
&6.4674E-03_JPRB,7.6719E-03_JPRB,9.5269E-03_JPRB,1.2415E-02_JPRB,1.6626E-02_JPRB/)
KBO( :,58, 7) = (/&
&5.2243E-03_JPRB,6.1935E-03_JPRB,7.6844E-03_JPRB,1.0054E-02_JPRB,1.3583E-02_JPRB/)
KBO( :,59, 7) = (/&
&4.3349E-03_JPRB,5.1717E-03_JPRB,6.4734E-03_JPRB,8.5759E-03_JPRB,1.1721E-02_JPRB/)
KBO( :,13, 8) = (/&
&4.8718E+01_JPRB,5.0320E+01_JPRB,5.1858E+01_JPRB,5.3380E+01_JPRB,5.4850E+01_JPRB/)
KBO( :,14, 8) = (/&
&4.2766E+01_JPRB,4.4021E+01_JPRB,4.5285E+01_JPRB,4.6520E+01_JPRB,4.7719E+01_JPRB/)
KBO( :,15, 8) = (/&
&3.7265E+01_JPRB,3.8285E+01_JPRB,3.9305E+01_JPRB,4.0312E+01_JPRB,4.1280E+01_JPRB/)
KBO( :,16, 8) = (/&
&3.2320E+01_JPRB,3.3145E+01_JPRB,3.3978E+01_JPRB,3.4801E+01_JPRB,3.5603E+01_JPRB/)
KBO( :,17, 8) = (/&
&2.7905E+01_JPRB,2.8588E+01_JPRB,2.9274E+01_JPRB,2.9948E+01_JPRB,3.0618E+01_JPRB/)
KBO( :,18, 8) = (/&
&2.3907E+01_JPRB,2.4472E+01_JPRB,2.5035E+01_JPRB,2.5608E+01_JPRB,2.6240E+01_JPRB/)
KBO( :,19, 8) = (/&
&2.0357E+01_JPRB,2.0811E+01_JPRB,2.1283E+01_JPRB,2.1801E+01_JPRB,2.2463E+01_JPRB/)
KBO( :,20, 8) = (/&
&1.7248E+01_JPRB,1.7625E+01_JPRB,1.8041E+01_JPRB,1.8568E+01_JPRB,1.9286E+01_JPRB/)
KBO( :,21, 8) = (/&
&1.4568E+01_JPRB,1.4891E+01_JPRB,1.5295E+01_JPRB,1.5868E+01_JPRB,1.6645E+01_JPRB/)
KBO( :,22, 8) = (/&
&1.2302E+01_JPRB,1.2610E+01_JPRB,1.3060E+01_JPRB,1.3693E+01_JPRB,1.4488E+01_JPRB/)
KBO( :,23, 8) = (/&
&1.0398E+01_JPRB,1.0740E+01_JPRB,1.1241E+01_JPRB,1.1898E+01_JPRB,1.2647E+01_JPRB/)
KBO( :,24, 8) = (/&
&8.8094E+00_JPRB,9.1977E+00_JPRB,9.7363E+00_JPRB,1.0379E+01_JPRB,1.1057E+01_JPRB/)
KBO( :,25, 8) = (/&
&7.5025E+00_JPRB,7.9291E+00_JPRB,8.4687E+00_JPRB,9.0617E+00_JPRB,9.6792E+00_JPRB/)
KBO( :,26, 8) = (/&
&6.4368E+00_JPRB,6.8798E+00_JPRB,7.3859E+00_JPRB,7.9241E+00_JPRB,8.4787E+00_JPRB/)
KBO( :,27, 8) = (/&
&5.5620E+00_JPRB,5.9868E+00_JPRB,6.4448E+00_JPRB,6.9294E+00_JPRB,7.4281E+00_JPRB/)
KBO( :,28, 8) = (/&
&4.8240E+00_JPRB,5.2122E+00_JPRB,5.6283E+00_JPRB,6.0659E+00_JPRB,6.5242E+00_JPRB/)
KBO( :,29, 8) = (/&
&4.1944E+00_JPRB,4.5487E+00_JPRB,4.9272E+00_JPRB,5.3264E+00_JPRB,5.7585E+00_JPRB/)
KBO( :,30, 8) = (/&
&3.6568E+00_JPRB,3.9803E+00_JPRB,4.3255E+00_JPRB,4.6987E+00_JPRB,5.1122E+00_JPRB/)
KBO( :,31, 8) = (/&
&3.2011E+00_JPRB,3.4961E+00_JPRB,3.8161E+00_JPRB,4.1707E+00_JPRB,4.5746E+00_JPRB/)
KBO( :,32, 8) = (/&
&2.8138E+00_JPRB,3.0858E+00_JPRB,3.3881E+00_JPRB,3.7312E+00_JPRB,4.1306E+00_JPRB/)
KBO( :,33, 8) = (/&
&2.4854E+00_JPRB,2.7408E+00_JPRB,3.0308E+00_JPRB,3.3678E+00_JPRB,3.7681E+00_JPRB/)
KBO( :,34, 8) = (/&
&2.2003E+00_JPRB,2.4428E+00_JPRB,2.7239E+00_JPRB,3.0581E+00_JPRB,3.4595E+00_JPRB/)
KBO( :,35, 8) = (/&
&1.9399E+00_JPRB,2.1700E+00_JPRB,2.4416E+00_JPRB,2.7703E+00_JPRB,3.1684E+00_JPRB/)
KBO( :,36, 8) = (/&
&1.6987E+00_JPRB,1.9152E+00_JPRB,2.1743E+00_JPRB,2.4922E+00_JPRB,2.8785E+00_JPRB/)
KBO( :,37, 8) = (/&
&1.4664E+00_JPRB,1.6646E+00_JPRB,1.9059E+00_JPRB,2.2053E+00_JPRB,2.5708E+00_JPRB/)
KBO( :,38, 8) = (/&
&1.2664E+00_JPRB,1.4483E+00_JPRB,1.6728E+00_JPRB,1.9542E+00_JPRB,2.2994E+00_JPRB/)
KBO( :,39, 8) = (/&
&1.0955E+00_JPRB,1.2626E+00_JPRB,1.4719E+00_JPRB,1.7366E+00_JPRB,2.0631E+00_JPRB/)
KBO( :,40, 8) = (/&
&9.3556E-01_JPRB,1.0859E+00_JPRB,1.2762E+00_JPRB,1.5192E+00_JPRB,1.8216E+00_JPRB/)
KBO( :,41, 8) = (/&
&7.9800E-01_JPRB,9.3250E-01_JPRB,1.1046E+00_JPRB,1.3263E+00_JPRB,1.6051E+00_JPRB/)
KBO( :,42, 8) = (/&
&6.8026E-01_JPRB,8.0111E-01_JPRB,9.5621E-01_JPRB,1.1581E+00_JPRB,1.4148E+00_JPRB/)
KBO( :,43, 8) = (/&
&5.7416E-01_JPRB,6.8147E-01_JPRB,8.1937E-01_JPRB,1.0003E+00_JPRB,1.2325E+00_JPRB/)
KBO( :,44, 8) = (/&
&4.8192E-01_JPRB,5.7630E-01_JPRB,6.9849E-01_JPRB,8.5859E-01_JPRB,1.0670E+00_JPRB/)
KBO( :,45, 8) = (/&
&4.0390E-01_JPRB,4.8662E-01_JPRB,5.9437E-01_JPRB,7.3642E-01_JPRB,9.2241E-01_JPRB/)
KBO( :,46, 8) = (/&
&3.3692E-01_JPRB,4.0832E-01_JPRB,5.0245E-01_JPRB,6.2763E-01_JPRB,7.9306E-01_JPRB/)
KBO( :,47, 8) = (/&
&2.7795E-01_JPRB,3.3890E-01_JPRB,4.1977E-01_JPRB,5.2809E-01_JPRB,6.7337E-01_JPRB/)
KBO( :,48, 8) = (/&
&2.2885E-01_JPRB,2.8056E-01_JPRB,3.4963E-01_JPRB,4.4288E-01_JPRB,5.6978E-01_JPRB/)
KBO( :,49, 8) = (/&
&1.8806E-01_JPRB,2.3188E-01_JPRB,2.9038E-01_JPRB,3.7027E-01_JPRB,4.8015E-01_JPRB/)
KBO( :,50, 8) = (/&
&1.5486E-01_JPRB,1.9227E-01_JPRB,2.4202E-01_JPRB,3.1061E-01_JPRB,4.0591E-01_JPRB/)
KBO( :,51, 8) = (/&
&1.2721E-01_JPRB,1.5949E-01_JPRB,2.0189E-01_JPRB,2.6069E-01_JPRB,3.4317E-01_JPRB/)
KBO( :,52, 8) = (/&
&1.0403E-01_JPRB,1.3183E-01_JPRB,1.6821E-01_JPRB,2.1833E-01_JPRB,2.8940E-01_JPRB/)
KBO( :,53, 8) = (/&
&8.4647E-02_JPRB,1.0841E-01_JPRB,1.3976E-01_JPRB,1.8251E-01_JPRB,2.4335E-01_JPRB/)
KBO( :,54, 8) = (/&
&6.9094E-02_JPRB,8.9415E-02_JPRB,1.1671E-01_JPRB,1.5366E-01_JPRB,2.0608E-01_JPRB/)
KBO( :,55, 8) = (/&
&5.6395E-02_JPRB,7.3686E-02_JPRB,9.7324E-02_JPRB,1.2958E-01_JPRB,1.7505E-01_JPRB/)
KBO( :,56, 8) = (/&
&4.5872E-02_JPRB,6.0506E-02_JPRB,8.0843E-02_JPRB,1.0885E-01_JPRB,1.4852E-01_JPRB/)
KBO( :,57, 8) = (/&
&3.7163E-02_JPRB,4.9485E-02_JPRB,6.6836E-02_JPRB,9.1072E-02_JPRB,1.2569E-01_JPRB/)
KBO( :,58, 8) = (/&
&3.0142E-02_JPRB,4.0510E-02_JPRB,5.5284E-02_JPRB,7.6236E-02_JPRB,1.0654E-01_JPRB/)
KBO( :,59, 8) = (/&
&2.5655E-02_JPRB,3.4976E-02_JPRB,4.8360E-02_JPRB,6.7750E-02_JPRB,9.5910E-02_JPRB/)
KBO( :,13, 9) = (/&
&2.6710E+02_JPRB,2.6292E+02_JPRB,2.6081E+02_JPRB,2.6060E+02_JPRB,2.6216E+02_JPRB/)
KBO( :,14, 9) = (/&
&2.2905E+02_JPRB,2.2705E+02_JPRB,2.2701E+02_JPRB,2.2883E+02_JPRB,2.3237E+02_JPRB/)
KBO( :,15, 9) = (/&
&1.9681E+02_JPRB,1.9674E+02_JPRB,1.9855E+02_JPRB,2.0218E+02_JPRB,2.0745E+02_JPRB/)
KBO( :,16, 9) = (/&
&1.6990E+02_JPRB,1.7146E+02_JPRB,1.7490E+02_JPRB,1.8008E+02_JPRB,1.8673E+02_JPRB/)
KBO( :,17, 9) = (/&
&1.4763E+02_JPRB,1.5059E+02_JPRB,1.5539E+02_JPRB,1.6156E+02_JPRB,1.6765E+02_JPRB/)
KBO( :,18, 9) = (/&
&1.2952E+02_JPRB,1.3368E+02_JPRB,1.3907E+02_JPRB,1.4438E+02_JPRB,1.4950E+02_JPRB/)
KBO( :,19, 9) = (/&
&1.1453E+02_JPRB,1.1924E+02_JPRB,1.2392E+02_JPRB,1.2844E+02_JPRB,1.3271E+02_JPRB/)
KBO( :,20, 9) = (/&
&1.0152E+02_JPRB,1.0566E+02_JPRB,1.0970E+02_JPRB,1.1358E+02_JPRB,1.1731E+02_JPRB/)
KBO( :,21, 9) = (/&
&8.9460E+01_JPRB,9.3028E+01_JPRB,9.6510E+01_JPRB,9.9904E+01_JPRB,1.0318E+02_JPRB/)
KBO( :,22, 9) = (/&
&7.8631E+01_JPRB,8.1700E+01_JPRB,8.4725E+01_JPRB,8.7702E+01_JPRB,9.0717E+01_JPRB/)
KBO( :,23, 9) = (/&
&6.8898E+01_JPRB,7.1547E+01_JPRB,7.4194E+01_JPRB,7.6892E+01_JPRB,7.9806E+01_JPRB/)
KBO( :,24, 9) = (/&
&6.0312E+01_JPRB,6.2630E+01_JPRB,6.4994E+01_JPRB,6.7556E+01_JPRB,7.0443E+01_JPRB/)
KBO( :,25, 9) = (/&
&5.2851E+01_JPRB,5.4897E+01_JPRB,5.7127E+01_JPRB,5.9634E+01_JPRB,6.2506E+01_JPRB/)
KBO( :,26, 9) = (/&
&4.6436E+01_JPRB,4.8336E+01_JPRB,5.0486E+01_JPRB,5.2975E+01_JPRB,5.5885E+01_JPRB/)
KBO( :,27, 9) = (/&
&4.0910E+01_JPRB,4.2771E+01_JPRB,4.4909E+01_JPRB,4.7425E+01_JPRB,5.0391E+01_JPRB/)
KBO( :,28, 9) = (/&
&3.6155E+01_JPRB,3.8062E+01_JPRB,4.0266E+01_JPRB,4.2832E+01_JPRB,4.5858E+01_JPRB/)
KBO( :,29, 9) = (/&
&3.2126E+01_JPRB,3.4094E+01_JPRB,3.6392E+01_JPRB,3.9062E+01_JPRB,4.2162E+01_JPRB/)
KBO( :,30, 9) = (/&
&2.8724E+01_JPRB,3.0764E+01_JPRB,3.3154E+01_JPRB,3.5941E+01_JPRB,3.9179E+01_JPRB/)
KBO( :,31, 9) = (/&
&2.5882E+01_JPRB,2.7995E+01_JPRB,3.0486E+01_JPRB,3.3401E+01_JPRB,3.6792E+01_JPRB/)
KBO( :,32, 9) = (/&
&2.3528E+01_JPRB,2.5718E+01_JPRB,2.8311E+01_JPRB,3.1365E+01_JPRB,3.4906E+01_JPRB/)
KBO( :,33, 9) = (/&
&2.1587E+01_JPRB,2.3866E+01_JPRB,2.6575E+01_JPRB,2.9769E+01_JPRB,3.3431E+01_JPRB/)
KBO( :,34, 9) = (/&
&1.9935E+01_JPRB,2.2294E+01_JPRB,2.5115E+01_JPRB,2.8414E+01_JPRB,3.2169E+01_JPRB/)
KBO( :,35, 9) = (/&
&1.8379E+01_JPRB,2.0784E+01_JPRB,2.3667E+01_JPRB,2.7018E+01_JPRB,3.0818E+01_JPRB/)
KBO( :,36, 9) = (/&
&1.6837E+01_JPRB,1.9243E+01_JPRB,2.2128E+01_JPRB,2.5484E+01_JPRB,2.9290E+01_JPRB/)
KBO( :,37, 9) = (/&
&1.5193E+01_JPRB,1.7529E+01_JPRB,2.0337E+01_JPRB,2.3631E+01_JPRB,2.7386E+01_JPRB/)
KBO( :,38, 9) = (/&
&1.3737E+01_JPRB,1.6000E+01_JPRB,1.8725E+01_JPRB,2.1951E+01_JPRB,2.5656E+01_JPRB/)
KBO( :,39, 9) = (/&
&1.2460E+01_JPRB,1.4648E+01_JPRB,1.7295E+01_JPRB,2.0455E+01_JPRB,2.4116E+01_JPRB/)
KBO( :,40, 9) = (/&
&1.1143E+01_JPRB,1.3211E+01_JPRB,1.5737E+01_JPRB,1.8782E+01_JPRB,2.2346E+01_JPRB/)
KBO( :,41, 9) = (/&
&9.9585E+00_JPRB,1.1899E+01_JPRB,1.4300E+01_JPRB,1.7222E+01_JPRB,2.0680E+01_JPRB/)
KBO( :,42, 9) = (/&
&8.9074E+00_JPRB,1.0724E+01_JPRB,1.3003E+01_JPRB,1.5806E+01_JPRB,1.9155E+01_JPRB/)
KBO( :,43, 9) = (/&
&7.8838E+00_JPRB,9.5638E+00_JPRB,1.1699E+01_JPRB,1.4356E+01_JPRB,1.7558E+01_JPRB/)
KBO( :,44, 9) = (/&
&6.9325E+00_JPRB,8.4860E+00_JPRB,1.0467E+01_JPRB,1.2961E+01_JPRB,1.6001E+01_JPRB/)
KBO( :,45, 9) = (/&
&6.0822E+00_JPRB,7.5231E+00_JPRB,9.3599E+00_JPRB,1.1689E+01_JPRB,1.4566E+01_JPRB/)
KBO( :,46, 9) = (/&
&5.2984E+00_JPRB,6.6221E+00_JPRB,8.3226E+00_JPRB,1.0480E+01_JPRB,1.3187E+01_JPRB/)
KBO( :,47, 9) = (/&
&4.5534E+00_JPRB,5.7527E+00_JPRB,7.3122E+00_JPRB,9.2888E+00_JPRB,1.1789E+01_JPRB/)
KBO( :,48, 9) = (/&
&3.8949E+00_JPRB,4.9778E+00_JPRB,6.4003E+00_JPRB,8.2164E+00_JPRB,1.0513E+01_JPRB/)
KBO( :,49, 9) = (/&
&3.3152E+00_JPRB,4.2900E+00_JPRB,5.5808E+00_JPRB,7.2516E+00_JPRB,9.3536E+00_JPRB/)
KBO( :,50, 9) = (/&
&2.8251E+00_JPRB,3.7029E+00_JPRB,4.8790E+00_JPRB,6.4176E+00_JPRB,8.3604E+00_JPRB/)
KBO( :,51, 9) = (/&
&2.4036E+00_JPRB,3.1914E+00_JPRB,4.2626E+00_JPRB,5.6760E+00_JPRB,7.4806E+00_JPRB/)
KBO( :,52, 9) = (/&
&2.0358E+00_JPRB,2.7394E+00_JPRB,3.7092E+00_JPRB,5.0052E+00_JPRB,6.6771E+00_JPRB/)
KBO( :,53, 9) = (/&
&1.7150E+00_JPRB,2.3392E+00_JPRB,3.2126E+00_JPRB,4.3953E+00_JPRB,5.9352E+00_JPRB/)
KBO( :,54, 9) = (/&
&1.4515E+00_JPRB,2.0067E+00_JPRB,2.8012E+00_JPRB,3.8817E+00_JPRB,5.3047E+00_JPRB/)
KBO( :,55, 9) = (/&
&1.2285E+00_JPRB,1.7230E+00_JPRB,2.4420E+00_JPRB,3.4310E+00_JPRB,4.7490E+00_JPRB/)
KBO( :,56, 9) = (/&
&1.0358E+00_JPRB,1.4720E+00_JPRB,2.1203E+00_JPRB,3.0228E+00_JPRB,4.2384E+00_JPRB/)
KBO( :,57, 9) = (/&
&8.6995E-01_JPRB,1.2523E+00_JPRB,1.8327E+00_JPRB,2.6527E+00_JPRB,3.7712E+00_JPRB/)
KBO( :,58, 9) = (/&
&7.3361E-01_JPRB,1.0673E+00_JPRB,1.5876E+00_JPRB,2.3341E+00_JPRB,3.3624E+00_JPRB/)
KBO( :,59, 9) = (/&
&6.5934E-01_JPRB,9.7595E-01_JPRB,1.4746E+00_JPRB,2.2013E+00_JPRB,3.1927E+00_JPRB/)
KBO( :,13,10) = (/&
&1.1370E+03_JPRB,1.1193E+03_JPRB,1.1015E+03_JPRB,1.0831E+03_JPRB,1.0644E+03_JPRB/)
KBO( :,14,10) = (/&
&1.0077E+03_JPRB,9.9068E+02_JPRB,9.7382E+02_JPRB,9.5646E+02_JPRB,9.3960E+02_JPRB/)
KBO( :,15,10) = (/&
&8.7737E+02_JPRB,8.6162E+02_JPRB,8.4607E+02_JPRB,8.3075E+02_JPRB,8.1589E+02_JPRB/)
KBO( :,16,10) = (/&
&7.5426E+02_JPRB,7.4028E+02_JPRB,7.2665E+02_JPRB,7.1344E+02_JPRB,7.0172E+02_JPRB/)
KBO( :,17,10) = (/&
&6.4244E+02_JPRB,6.3047E+02_JPRB,6.1893E+02_JPRB,6.1102E+02_JPRB,6.1824E+02_JPRB/)
KBO( :,18,10) = (/&
&5.4326E+02_JPRB,5.3346E+02_JPRB,5.2903E+02_JPRB,5.4116E+02_JPRB,5.6772E+02_JPRB/)
KBO( :,19,10) = (/&
&4.6041E+02_JPRB,4.5657E+02_JPRB,4.6965E+02_JPRB,4.9609E+02_JPRB,5.2443E+02_JPRB/)
KBO( :,20,10) = (/&
&3.9849E+02_JPRB,4.0983E+02_JPRB,4.3310E+02_JPRB,4.5724E+02_JPRB,4.8136E+02_JPRB/)
KBO( :,21,10) = (/&
&3.5855E+02_JPRB,3.7953E+02_JPRB,4.0064E+02_JPRB,4.2132E+02_JPRB,4.4170E+02_JPRB/)
KBO( :,22,10) = (/&
&3.2988E+02_JPRB,3.4998E+02_JPRB,3.6966E+02_JPRB,3.8861E+02_JPRB,4.0637E+02_JPRB/)
KBO( :,23,10) = (/&
&3.0132E+02_JPRB,3.2005E+02_JPRB,3.3835E+02_JPRB,3.5588E+02_JPRB,3.7212E+02_JPRB/)
KBO( :,24,10) = (/&
&2.7350E+02_JPRB,2.9090E+02_JPRB,3.0784E+02_JPRB,3.2378E+02_JPRB,3.3905E+02_JPRB/)
KBO( :,25,10) = (/&
&2.4700E+02_JPRB,2.6316E+02_JPRB,2.7865E+02_JPRB,2.9355E+02_JPRB,3.0831E+02_JPRB/)
KBO( :,26,10) = (/&
&2.2261E+02_JPRB,2.3737E+02_JPRB,2.5178E+02_JPRB,2.6623E+02_JPRB,2.8060E+02_JPRB/)
KBO( :,27,10) = (/&
&2.0072E+02_JPRB,2.1392E+02_JPRB,2.2763E+02_JPRB,2.4159E+02_JPRB,2.5577E+02_JPRB/)
KBO( :,28,10) = (/&
&1.8170E+02_JPRB,1.9355E+02_JPRB,2.0624E+02_JPRB,2.1988E+02_JPRB,2.3391E+02_JPRB/)
KBO( :,29,10) = (/&
&1.6551E+02_JPRB,1.7639E+02_JPRB,1.8818E+02_JPRB,2.0102E+02_JPRB,2.1504E+02_JPRB/)
KBO( :,30,10) = (/&
&1.5197E+02_JPRB,1.6180E+02_JPRB,1.7277E+02_JPRB,1.8505E+02_JPRB,1.9878E+02_JPRB/)
KBO( :,31,10) = (/&
&1.4040E+02_JPRB,1.4951E+02_JPRB,1.5989E+02_JPRB,1.7189E+02_JPRB,1.8557E+02_JPRB/)
KBO( :,32,10) = (/&
&1.3052E+02_JPRB,1.3922E+02_JPRB,1.4931E+02_JPRB,1.6122E+02_JPRB,1.7537E+02_JPRB/)
KBO( :,33,10) = (/&
&1.2219E+02_JPRB,1.3073E+02_JPRB,1.4066E+02_JPRB,1.5295E+02_JPRB,1.6793E+02_JPRB/)
KBO( :,34,10) = (/&
&1.1485E+02_JPRB,1.2346E+02_JPRB,1.3352E+02_JPRB,1.4643E+02_JPRB,1.6252E+02_JPRB/)
KBO( :,35,10) = (/&
&1.0786E+02_JPRB,1.1670E+02_JPRB,1.2704E+02_JPRB,1.4054E+02_JPRB,1.5777E+02_JPRB/)
KBO( :,36,10) = (/&
&1.0096E+02_JPRB,1.1026E+02_JPRB,1.2083E+02_JPRB,1.3466E+02_JPRB,1.5266E+02_JPRB/)
KBO( :,37,10) = (/&
&9.3649E+01_JPRB,1.0335E+02_JPRB,1.1406E+02_JPRB,1.2775E+02_JPRB,1.4574E+02_JPRB/)
KBO( :,38,10) = (/&
&8.6966E+01_JPRB,9.7115E+01_JPRB,1.0831E+02_JPRB,1.2180E+02_JPRB,1.3969E+02_JPRB/)
KBO( :,39,10) = (/&
&8.1095E+01_JPRB,9.1619E+01_JPRB,1.0337E+02_JPRB,1.1677E+02_JPRB,1.3445E+02_JPRB/)
KBO( :,40,10) = (/&
&7.4825E+01_JPRB,8.5620E+01_JPRB,9.7708E+01_JPRB,1.1093E+02_JPRB,1.2782E+02_JPRB/)
KBO( :,41,10) = (/&
&6.8987E+01_JPRB,7.9975E+01_JPRB,9.2327E+01_JPRB,1.0557E+02_JPRB,1.2158E+02_JPRB/)
KBO( :,42,10) = (/&
&6.3582E+01_JPRB,7.4799E+01_JPRB,8.7292E+01_JPRB,1.0067E+02_JPRB,1.1590E+02_JPRB/)
KBO( :,43,10) = (/&
&5.8100E+01_JPRB,6.9336E+01_JPRB,8.1830E+01_JPRB,9.5341E+01_JPRB,1.0982E+02_JPRB/)
KBO( :,44,10) = (/&
&5.2932E+01_JPRB,6.3876E+01_JPRB,7.6294E+01_JPRB,8.9737E+01_JPRB,1.0391E+02_JPRB/)
KBO( :,45,10) = (/&
&4.8226E+01_JPRB,5.8773E+01_JPRB,7.1006E+01_JPRB,8.4358E+01_JPRB,9.8366E+01_JPRB/)
KBO( :,46,10) = (/&
&4.3799E+01_JPRB,5.3806E+01_JPRB,6.5676E+01_JPRB,7.8828E+01_JPRB,9.2780E+01_JPRB/)
KBO( :,47,10) = (/&
&3.9350E+01_JPRB,4.8773E+01_JPRB,6.0056E+01_JPRB,7.2887E+01_JPRB,8.6626E+01_JPRB/)
KBO( :,48,10) = (/&
&3.5360E+01_JPRB,4.4132E+01_JPRB,5.4788E+01_JPRB,6.7135E+01_JPRB,8.0643E+01_JPRB/)
KBO( :,49,10) = (/&
&3.1759E+01_JPRB,3.9919E+01_JPRB,4.9896E+01_JPRB,6.1616E+01_JPRB,7.4794E+01_JPRB/)
KBO( :,50,10) = (/&
&2.8696E+01_JPRB,3.6220E+01_JPRB,4.5579E+01_JPRB,5.6700E+01_JPRB,6.9436E+01_JPRB/)
KBO( :,51,10) = (/&
&2.5923E+01_JPRB,3.2951E+01_JPRB,4.1668E+01_JPRB,5.2205E+01_JPRB,6.4403E+01_JPRB/)
KBO( :,52,10) = (/&
&2.3246E+01_JPRB,2.9949E+01_JPRB,3.8044E+01_JPRB,4.7965E+01_JPRB,5.9561E+01_JPRB/)
KBO( :,53,10) = (/&
&2.0677E+01_JPRB,2.7212E+01_JPRB,3.4689E+01_JPRB,4.3992E+01_JPRB,5.4982E+01_JPRB/)
KBO( :,54,10) = (/&
&1.8394E+01_JPRB,2.4800E+01_JPRB,3.1896E+01_JPRB,4.0551E+01_JPRB,5.0999E+01_JPRB/)
KBO( :,55,10) = (/&
&1.6290E+01_JPRB,2.2530E+01_JPRB,2.9365E+01_JPRB,3.7468E+01_JPRB,4.7358E+01_JPRB/)
KBO( :,56,10) = (/&
&1.4293E+01_JPRB,2.0343E+01_JPRB,2.7025E+01_JPRB,3.4587E+01_JPRB,4.3934E+01_JPRB/)
KBO( :,57,10) = (/&
&1.2429E+01_JPRB,1.8222E+01_JPRB,2.4765E+01_JPRB,3.1908E+01_JPRB,4.0683E+01_JPRB/)
KBO( :,58,10) = (/&
&1.0794E+01_JPRB,1.6277E+01_JPRB,2.2653E+01_JPRB,2.9533E+01_JPRB,3.7782E+01_JPRB/)
KBO( :,59,10) = (/&
&1.0104E+01_JPRB,1.5485E+01_JPRB,2.1801E+01_JPRB,2.8646E+01_JPRB,3.6640E+01_JPRB/)
KBO( :,13,11) = (/&
&1.9982E+03_JPRB,1.9741E+03_JPRB,1.9501E+03_JPRB,1.9258E+03_JPRB,1.8991E+03_JPRB/)
KBO( :,14,11) = (/&
&1.8366E+03_JPRB,1.8117E+03_JPRB,1.7872E+03_JPRB,1.7620E+03_JPRB,1.7357E+03_JPRB/)
KBO( :,15,11) = (/&
&1.6593E+03_JPRB,1.6345E+03_JPRB,1.6105E+03_JPRB,1.5852E+03_JPRB,1.5607E+03_JPRB/)
KBO( :,16,11) = (/&
&1.4714E+03_JPRB,1.4482E+03_JPRB,1.4256E+03_JPRB,1.4029E+03_JPRB,1.3814E+03_JPRB/)
KBO( :,17,11) = (/&
&1.2821E+03_JPRB,1.2610E+03_JPRB,1.2407E+03_JPRB,1.2217E+03_JPRB,1.2035E+03_JPRB/)
KBO( :,18,11) = (/&
&1.1031E+03_JPRB,1.0851E+03_JPRB,1.0681E+03_JPRB,1.0526E+03_JPRB,1.0392E+03_JPRB/)
KBO( :,19,11) = (/&
&9.4073E+02_JPRB,9.2594E+02_JPRB,9.1239E+02_JPRB,9.0492E+02_JPRB,9.1389E+02_JPRB/)
KBO( :,20,11) = (/&
&7.9752E+02_JPRB,7.8605E+02_JPRB,7.8200E+02_JPRB,7.9771E+02_JPRB,8.3070E+02_JPRB/)
KBO( :,21,11) = (/&
&6.7621E+02_JPRB,6.7302E+02_JPRB,6.9037E+02_JPRB,7.2680E+02_JPRB,7.7342E+02_JPRB/)
KBO( :,22,11) = (/&
&5.8317E+02_JPRB,5.9901E+02_JPRB,6.3384E+02_JPRB,6.7592E+02_JPRB,7.2003E+02_JPRB/)
KBO( :,23,11) = (/&
&5.2345E+02_JPRB,5.5460E+02_JPRB,5.9107E+02_JPRB,6.2902E+02_JPRB,6.6965E+02_JPRB/)
KBO( :,24,11) = (/&
&4.8603E+02_JPRB,5.1872E+02_JPRB,5.5143E+02_JPRB,5.8645E+02_JPRB,6.2372E+02_JPRB/)
KBO( :,25,11) = (/&
&4.5248E+02_JPRB,4.8397E+02_JPRB,5.1550E+02_JPRB,5.4767E+02_JPRB,5.8239E+02_JPRB/)
KBO( :,26,11) = (/&
&4.2042E+02_JPRB,4.5092E+02_JPRB,4.8247E+02_JPRB,5.1356E+02_JPRB,5.4667E+02_JPRB/)
KBO( :,27,11) = (/&
&3.8993E+02_JPRB,4.2017E+02_JPRB,4.5102E+02_JPRB,4.8294E+02_JPRB,5.1599E+02_JPRB/)
KBO( :,28,11) = (/&
&3.6206E+02_JPRB,3.9191E+02_JPRB,4.2290E+02_JPRB,4.5578E+02_JPRB,4.8932E+02_JPRB/)
KBO( :,29,11) = (/&
&3.3701E+02_JPRB,3.6670E+02_JPRB,3.9835E+02_JPRB,4.3253E+02_JPRB,4.6763E+02_JPRB/)
KBO( :,30,11) = (/&
&3.1435E+02_JPRB,3.4509E+02_JPRB,3.7799E+02_JPRB,4.1371E+02_JPRB,4.5072E+02_JPRB/)
KBO( :,31,11) = (/&
&2.9536E+02_JPRB,3.2738E+02_JPRB,3.6185E+02_JPRB,3.9930E+02_JPRB,4.3870E+02_JPRB/)
KBO( :,32,11) = (/&
&2.8017E+02_JPRB,3.1347E+02_JPRB,3.5000E+02_JPRB,3.8948E+02_JPRB,4.3126E+02_JPRB/)
KBO( :,33,11) = (/&
&2.6842E+02_JPRB,3.0340E+02_JPRB,3.4238E+02_JPRB,3.8415E+02_JPRB,4.2838E+02_JPRB/)
KBO( :,34,11) = (/&
&2.5904E+02_JPRB,2.9599E+02_JPRB,3.3729E+02_JPRB,3.8143E+02_JPRB,4.2772E+02_JPRB/)
KBO( :,35,11) = (/&
&2.4977E+02_JPRB,2.8824E+02_JPRB,3.3150E+02_JPRB,3.7746E+02_JPRB,4.2524E+02_JPRB/)
KBO( :,36,11) = (/&
&2.3959E+02_JPRB,2.7880E+02_JPRB,3.2342E+02_JPRB,3.7070E+02_JPRB,4.1949E+02_JPRB/)
KBO( :,37,11) = (/&
&2.2622E+02_JPRB,2.6520E+02_JPRB,3.1011E+02_JPRB,3.5817E+02_JPRB,4.0759E+02_JPRB/)
KBO( :,38,11) = (/&
&2.1446E+02_JPRB,2.5305E+02_JPRB,2.9777E+02_JPRB,3.4633E+02_JPRB,3.9620E+02_JPRB/)
KBO( :,39,11) = (/&
&2.0431E+02_JPRB,2.4241E+02_JPRB,2.8661E+02_JPRB,3.3540E+02_JPRB,3.8561E+02_JPRB/)
KBO( :,40,11) = (/&
&1.9199E+02_JPRB,2.2883E+02_JPRB,2.7179E+02_JPRB,3.2005E+02_JPRB,3.7046E+02_JPRB/)
KBO( :,41,11) = (/&
&1.8042E+02_JPRB,2.1588E+02_JPRB,2.5742E+02_JPRB,3.0459E+02_JPRB,3.5513E+02_JPRB/)
KBO( :,42,11) = (/&
&1.6997E+02_JPRB,2.0388E+02_JPRB,2.4396E+02_JPRB,2.8977E+02_JPRB,3.4012E+02_JPRB/)
KBO( :,43,11) = (/&
&1.5886E+02_JPRB,1.9075E+02_JPRB,2.2902E+02_JPRB,2.7322E+02_JPRB,3.2256E+02_JPRB/)
KBO( :,44,11) = (/&
&1.4807E+02_JPRB,1.7777E+02_JPRB,2.1401E+02_JPRB,2.5624E+02_JPRB,3.0398E+02_JPRB/)
KBO( :,45,11) = (/&
&1.3833E+02_JPRB,1.6586E+02_JPRB,1.9992E+02_JPRB,2.4015E+02_JPRB,2.8607E+02_JPRB/)
KBO( :,46,11) = (/&
&1.2866E+02_JPRB,1.5433E+02_JPRB,1.8602E+02_JPRB,2.2411E+02_JPRB,2.6807E+02_JPRB/)
KBO( :,47,11) = (/&
&1.1806E+02_JPRB,1.4268E+02_JPRB,1.7176E+02_JPRB,2.0732E+02_JPRB,2.4896E+02_JPRB/)
KBO( :,48,11) = (/&
&1.0762E+02_JPRB,1.3206E+02_JPRB,1.5870E+02_JPRB,1.9169E+02_JPRB,2.3091E+02_JPRB/)
KBO( :,49,11) = (/&
&9.7413E+01_JPRB,1.2171E+02_JPRB,1.4684E+02_JPRB,1.7718E+02_JPRB,2.1396E+02_JPRB/)
KBO( :,50,11) = (/&
&8.8070E+01_JPRB,1.1204E+02_JPRB,1.3673E+02_JPRB,1.6460E+02_JPRB,1.9898E+02_JPRB/)
KBO( :,51,11) = (/&
&7.9391E+01_JPRB,1.0276E+02_JPRB,1.2732E+02_JPRB,1.5339E+02_JPRB,1.8537E+02_JPRB/)
KBO( :,52,11) = (/&
&7.1290E+01_JPRB,9.3724E+01_JPRB,1.1803E+02_JPRB,1.4312E+02_JPRB,1.7272E+02_JPRB/)
KBO( :,53,11) = (/&
&6.3690E+01_JPRB,8.4888E+01_JPRB,1.0877E+02_JPRB,1.3364E+02_JPRB,1.6093E+02_JPRB/)
KBO( :,54,11) = (/&
&5.7252E+01_JPRB,7.7190E+01_JPRB,1.0050E+02_JPRB,1.2512E+02_JPRB,1.5096E+02_JPRB/)
KBO( :,55,11) = (/&
&5.1553E+01_JPRB,7.0213E+01_JPRB,9.2633E+01_JPRB,1.1699E+02_JPRB,1.4211E+02_JPRB/)
KBO( :,56,11) = (/&
&4.6347E+01_JPRB,6.3641E+01_JPRB,8.4965E+01_JPRB,1.0895E+02_JPRB,1.3389E+02_JPRB/)
KBO( :,57,11) = (/&
&4.1558E+01_JPRB,5.7539E+01_JPRB,7.7656E+01_JPRB,1.0100E+02_JPRB,1.2577E+02_JPRB/)
KBO( :,58,11) = (/&
&3.7465E+01_JPRB,5.2155E+01_JPRB,7.1065E+01_JPRB,9.3602E+01_JPRB,1.1811E+02_JPRB/)
KBO( :,59,11) = (/&
&3.5865E+01_JPRB,5.0074E+01_JPRB,6.8488E+01_JPRB,9.0703E+01_JPRB,1.1503E+02_JPRB/)
KBO( :,13,12) = (/&
&3.5818E+03_JPRB,3.5602E+03_JPRB,3.5361E+03_JPRB,3.5062E+03_JPRB,3.4753E+03_JPRB/)
KBO( :,14,12) = (/&
&3.4873E+03_JPRB,3.4617E+03_JPRB,3.4320E+03_JPRB,3.3978E+03_JPRB,3.3640E+03_JPRB/)
KBO( :,15,12) = (/&
&3.3174E+03_JPRB,3.2873E+03_JPRB,3.2522E+03_JPRB,3.2184E+03_JPRB,3.1823E+03_JPRB/)
KBO( :,16,12) = (/&
&3.0916E+03_JPRB,3.0581E+03_JPRB,3.0238E+03_JPRB,2.9909E+03_JPRB,2.9539E+03_JPRB/)
KBO( :,17,12) = (/&
&2.8257E+03_JPRB,2.7923E+03_JPRB,2.7615E+03_JPRB,2.7297E+03_JPRB,2.6960E+03_JPRB/)
KBO( :,18,12) = (/&
&2.5404E+03_JPRB,2.5105E+03_JPRB,2.4823E+03_JPRB,2.4526E+03_JPRB,2.4250E+03_JPRB/)
KBO( :,19,12) = (/&
&2.2483E+03_JPRB,2.2241E+03_JPRB,2.1993E+03_JPRB,2.1755E+03_JPRB,2.1543E+03_JPRB/)
KBO( :,20,12) = (/&
&1.9604E+03_JPRB,1.9400E+03_JPRB,1.9209E+03_JPRB,1.9048E+03_JPRB,1.8895E+03_JPRB/)
KBO( :,21,12) = (/&
&1.6892E+03_JPRB,1.6737E+03_JPRB,1.6614E+03_JPRB,1.6516E+03_JPRB,1.6529E+03_JPRB/)
KBO( :,22,12) = (/&
&1.4436E+03_JPRB,1.4342E+03_JPRB,1.4286E+03_JPRB,1.4399E+03_JPRB,1.4734E+03_JPRB/)
KBO( :,23,12) = (/&
&1.2278E+03_JPRB,1.2256E+03_JPRB,1.2434E+03_JPRB,1.2846E+03_JPRB,1.3446E+03_JPRB/)
KBO( :,24,12) = (/&
&1.0469E+03_JPRB,1.0648E+03_JPRB,1.1103E+03_JPRB,1.1758E+03_JPRB,1.2604E+03_JPRB/)
KBO( :,25,12) = (/&
&9.1261E+02_JPRB,9.5264E+02_JPRB,1.0193E+03_JPRB,1.1064E+03_JPRB,1.2100E+03_JPRB/)
KBO( :,26,12) = (/&
&8.2117E+02_JPRB,8.8093E+02_JPRB,9.6383E+02_JPRB,1.0654E+03_JPRB,1.1751E+03_JPRB/)
KBO( :,27,12) = (/&
&7.6353E+02_JPRB,8.3890E+02_JPRB,9.3016E+02_JPRB,1.0327E+03_JPRB,1.1460E+03_JPRB/)
KBO( :,28,12) = (/&
&7.3032E+02_JPRB,8.1065E+02_JPRB,9.0335E+02_JPRB,1.0079E+03_JPRB,1.1263E+03_JPRB/)
KBO( :,29,12) = (/&
&7.0685E+02_JPRB,7.8909E+02_JPRB,8.8424E+02_JPRB,9.9311E+02_JPRB,1.1170E+03_JPRB/)
KBO( :,30,12) = (/&
&6.8897E+02_JPRB,7.7363E+02_JPRB,8.7322E+02_JPRB,9.8778E+02_JPRB,1.1175E+03_JPRB/)
KBO( :,31,12) = (/&
&6.7689E+02_JPRB,7.6589E+02_JPRB,8.7126E+02_JPRB,9.9171E+02_JPRB,1.1269E+03_JPRB/)
KBO( :,32,12) = (/&
&6.7137E+02_JPRB,7.6614E+02_JPRB,8.7757E+02_JPRB,1.0041E+03_JPRB,1.1438E+03_JPRB/)
KBO( :,33,12) = (/&
&6.7295E+02_JPRB,7.7394E+02_JPRB,8.9109E+02_JPRB,1.0224E+03_JPRB,1.1662E+03_JPRB/)
KBO( :,34,12) = (/&
&6.7760E+02_JPRB,7.8360E+02_JPRB,9.0569E+02_JPRB,1.0406E+03_JPRB,1.1879E+03_JPRB/)
KBO( :,35,12) = (/&
&6.7716E+02_JPRB,7.8671E+02_JPRB,9.1119E+02_JPRB,1.0486E+03_JPRB,1.1979E+03_JPRB/)
KBO( :,36,12) = (/&
&6.6904E+02_JPRB,7.7952E+02_JPRB,9.0494E+02_JPRB,1.0434E+03_JPRB,1.1930E+03_JPRB/)
KBO( :,37,12) = (/&
&6.4763E+02_JPRB,7.5648E+02_JPRB,8.8059E+02_JPRB,1.0176E+03_JPRB,1.1662E+03_JPRB/)
KBO( :,38,12) = (/&
&6.2716E+02_JPRB,7.3431E+02_JPRB,8.5661E+02_JPRB,9.9212E+02_JPRB,1.1395E+03_JPRB/)
KBO( :,39,12) = (/&
&6.0818E+02_JPRB,7.1366E+02_JPRB,8.3407E+02_JPRB,9.6793E+02_JPRB,1.1141E+03_JPRB/)
KBO( :,40,12) = (/&
&5.8003E+02_JPRB,6.8275E+02_JPRB,7.9982E+02_JPRB,9.3064E+02_JPRB,1.0742E+03_JPRB/)
KBO( :,41,12) = (/&
&5.5133E+02_JPRB,6.5206E+02_JPRB,7.6547E+02_JPRB,8.9303E+02_JPRB,1.0336E+03_JPRB/)
KBO( :,42,12) = (/&
&5.2305E+02_JPRB,6.2298E+02_JPRB,7.3258E+02_JPRB,8.5660E+02_JPRB,9.9409E+02_JPRB/)
KBO( :,43,12) = (/&
&4.8966E+02_JPRB,5.8921E+02_JPRB,6.9465E+02_JPRB,8.1454E+02_JPRB,9.4783E+02_JPRB/)
KBO( :,44,12) = (/&
&4.5450E+02_JPRB,5.5350E+02_JPRB,6.5588E+02_JPRB,7.7082E+02_JPRB,8.9980E+02_JPRB/)
KBO( :,45,12) = (/&
&4.2021E+02_JPRB,5.1820E+02_JPRB,6.1912E+02_JPRB,7.2914E+02_JPRB,8.5336E+02_JPRB/)
KBO( :,46,12) = (/&
&3.8545E+02_JPRB,4.8121E+02_JPRB,5.8143E+02_JPRB,6.8674E+02_JPRB,8.0608E+02_JPRB/)
KBO( :,47,12) = (/&
&3.4881E+02_JPRB,4.4053E+02_JPRB,5.3980E+02_JPRB,6.4195E+02_JPRB,7.5551E+02_JPRB/)
KBO( :,48,12) = (/&
&3.1491E+02_JPRB,4.0104E+02_JPRB,4.9870E+02_JPRB,5.9963E+02_JPRB,7.0738E+02_JPRB/)
KBO( :,49,12) = (/&
&2.8368E+02_JPRB,3.6400E+02_JPRB,4.5807E+02_JPRB,5.5813E+02_JPRB,6.6173E+02_JPRB/)
KBO( :,50,12) = (/&
&2.5677E+02_JPRB,3.3132E+02_JPRB,4.2070E+02_JPRB,5.1964E+02_JPRB,6.2120E+02_JPRB/)
KBO( :,51,12) = (/&
&2.3306E+02_JPRB,3.0179E+02_JPRB,3.8584E+02_JPRB,4.8266E+02_JPRB,5.8343E+02_JPRB/)
KBO( :,52,12) = (/&
&2.1156E+02_JPRB,2.7447E+02_JPRB,3.5296E+02_JPRB,4.4605E+02_JPRB,5.4606E+02_JPRB/)
KBO( :,53,12) = (/&
&1.9230E+02_JPRB,2.4924E+02_JPRB,3.2214E+02_JPRB,4.1028E+02_JPRB,5.0889E+02_JPRB/)
KBO( :,54,12) = (/&
&1.7631E+02_JPRB,2.2814E+02_JPRB,2.9584E+02_JPRB,3.7892E+02_JPRB,4.7521E+02_JPRB/)
KBO( :,55,12) = (/&
&1.6135E+02_JPRB,2.0966E+02_JPRB,2.7215E+02_JPRB,3.5038E+02_JPRB,4.4318E+02_JPRB/)
KBO( :,56,12) = (/&
&1.4671E+02_JPRB,1.9290E+02_JPRB,2.5021E+02_JPRB,3.2348E+02_JPRB,4.1193E+02_JPRB/)
KBO( :,57,12) = (/&
&1.3244E+02_JPRB,1.7761E+02_JPRB,2.2999E+02_JPRB,2.9808E+02_JPRB,3.8198E+02_JPRB/)
KBO( :,58,12) = (/&
&1.1934E+02_JPRB,1.6351E+02_JPRB,2.1236E+02_JPRB,2.7551E+02_JPRB,3.5480E+02_JPRB/)
KBO( :,59,12) = (/&
&1.1416E+02_JPRB,1.5788E+02_JPRB,2.0569E+02_JPRB,2.6705E+02_JPRB,3.4428E+02_JPRB/)
KBO( :,13,13) = (/&
&6.2395E+03_JPRB,6.2548E+03_JPRB,6.2528E+03_JPRB,6.2437E+03_JPRB,6.2212E+03_JPRB/)
KBO( :,14,13) = (/&
&6.5506E+03_JPRB,6.5502E+03_JPRB,6.5372E+03_JPRB,6.5181E+03_JPRB,6.4862E+03_JPRB/)
KBO( :,15,13) = (/&
&6.7305E+03_JPRB,6.7173E+03_JPRB,6.7025E+03_JPRB,6.6735E+03_JPRB,6.6396E+03_JPRB/)
KBO( :,16,13) = (/&
&6.7735E+03_JPRB,6.7593E+03_JPRB,6.7329E+03_JPRB,6.7018E+03_JPRB,6.6632E+03_JPRB/)
KBO( :,17,13) = (/&
&6.6866E+03_JPRB,6.6652E+03_JPRB,6.6418E+03_JPRB,6.6109E+03_JPRB,6.5815E+03_JPRB/)
KBO( :,18,13) = (/&
&6.4678E+03_JPRB,6.4550E+03_JPRB,6.4343E+03_JPRB,6.4161E+03_JPRB,6.3909E+03_JPRB/)
KBO( :,19,13) = (/&
&6.1502E+03_JPRB,6.1407E+03_JPRB,6.1364E+03_JPRB,6.1306E+03_JPRB,6.1254E+03_JPRB/)
KBO( :,20,13) = (/&
&5.7689E+03_JPRB,5.7735E+03_JPRB,5.7841E+03_JPRB,5.7948E+03_JPRB,5.8088E+03_JPRB/)
KBO( :,21,13) = (/&
&5.3403E+03_JPRB,5.3684E+03_JPRB,5.3985E+03_JPRB,5.4338E+03_JPRB,5.4704E+03_JPRB/)
KBO( :,22,13) = (/&
&4.8996E+03_JPRB,4.9455E+03_JPRB,5.0039E+03_JPRB,5.0665E+03_JPRB,5.1301E+03_JPRB/)
KBO( :,23,13) = (/&
&4.4632E+03_JPRB,4.5382E+03_JPRB,4.6203E+03_JPRB,4.7095E+03_JPRB,4.8061E+03_JPRB/)
KBO( :,24,13) = (/&
&4.0592E+03_JPRB,4.1561E+03_JPRB,4.2652E+03_JPRB,4.3841E+03_JPRB,4.5045E+03_JPRB/)
KBO( :,25,13) = (/&
&3.6916E+03_JPRB,3.8157E+03_JPRB,3.9506E+03_JPRB,4.0939E+03_JPRB,4.2439E+03_JPRB/)
KBO( :,26,13) = (/&
&3.3695E+03_JPRB,3.5229E+03_JPRB,3.6811E+03_JPRB,3.8560E+03_JPRB,4.0438E+03_JPRB/)
KBO( :,27,13) = (/&
&3.0970E+03_JPRB,3.2745E+03_JPRB,3.4707E+03_JPRB,3.6834E+03_JPRB,3.9050E+03_JPRB/)
KBO( :,28,13) = (/&
&2.8706E+03_JPRB,3.0888E+03_JPRB,3.3231E+03_JPRB,3.5664E+03_JPRB,3.8148E+03_JPRB/)
KBO( :,29,13) = (/&
&2.7113E+03_JPRB,2.9644E+03_JPRB,3.2288E+03_JPRB,3.4982E+03_JPRB,3.7656E+03_JPRB/)
KBO( :,30,13) = (/&
&2.6074E+03_JPRB,2.8885E+03_JPRB,3.1778E+03_JPRB,3.4648E+03_JPRB,3.7470E+03_JPRB/)
KBO( :,31,13) = (/&
&2.5496E+03_JPRB,2.8533E+03_JPRB,3.1606E+03_JPRB,3.4611E+03_JPRB,3.7527E+03_JPRB/)
KBO( :,32,13) = (/&
&2.5294E+03_JPRB,2.8506E+03_JPRB,3.1699E+03_JPRB,3.4785E+03_JPRB,3.7755E+03_JPRB/)
KBO( :,33,13) = (/&
&2.5376E+03_JPRB,2.8705E+03_JPRB,3.1985E+03_JPRB,3.5117E+03_JPRB,3.8116E+03_JPRB/)
KBO( :,34,13) = (/&
&2.5544E+03_JPRB,2.8966E+03_JPRB,3.2284E+03_JPRB,3.5457E+03_JPRB,3.8464E+03_JPRB/)
KBO( :,35,13) = (/&
&2.5535E+03_JPRB,2.9023E+03_JPRB,3.2375E+03_JPRB,3.5577E+03_JPRB,3.8601E+03_JPRB/)
KBO( :,36,13) = (/&
&2.5246E+03_JPRB,2.8777E+03_JPRB,3.2177E+03_JPRB,3.5406E+03_JPRB,3.8472E+03_JPRB/)
KBO( :,37,13) = (/&
&2.4476E+03_JPRB,2.8057E+03_JPRB,3.1519E+03_JPRB,3.4804E+03_JPRB,3.7923E+03_JPRB/)
KBO( :,38,13) = (/&
&2.3725E+03_JPRB,2.7347E+03_JPRB,3.0855E+03_JPRB,3.4198E+03_JPRB,3.7363E+03_JPRB/)
KBO( :,39,13) = (/&
&2.3022E+03_JPRB,2.6668E+03_JPRB,3.0226E+03_JPRB,3.3616E+03_JPRB,3.6822E+03_JPRB/)
KBO( :,40,13) = (/&
&2.1978E+03_JPRB,2.5643E+03_JPRB,2.9251E+03_JPRB,3.2708E+03_JPRB,3.5971E+03_JPRB/)
KBO( :,41,13) = (/&
&2.0936E+03_JPRB,2.4587E+03_JPRB,2.8232E+03_JPRB,3.1755E+03_JPRB,3.5072E+03_JPRB/)
KBO( :,42,13) = (/&
&1.9924E+03_JPRB,2.3537E+03_JPRB,2.7212E+03_JPRB,3.0790E+03_JPRB,3.4170E+03_JPRB/)
KBO( :,43,13) = (/&
&1.8759E+03_JPRB,2.2299E+03_JPRB,2.5995E+03_JPRB,2.9624E+03_JPRB,3.3082E+03_JPRB/)
KBO( :,44,13) = (/&
&1.7551E+03_JPRB,2.1002E+03_JPRB,2.4686E+03_JPRB,2.8357E+03_JPRB,3.1891E+03_JPRB/)
KBO( :,45,13) = (/&
&1.6392E+03_JPRB,1.9745E+03_JPRB,2.3377E+03_JPRB,2.7076E+03_JPRB,3.0676E+03_JPRB/)
KBO( :,46,13) = (/&
&1.5222E+03_JPRB,1.8455E+03_JPRB,2.1996E+03_JPRB,2.5709E+03_JPRB,2.9366E+03_JPRB/)
KBO( :,47,13) = (/&
&1.3973E+03_JPRB,1.7071E+03_JPRB,2.0502E+03_JPRB,2.4181E+03_JPRB,2.7876E+03_JPRB/)
KBO( :,48,13) = (/&
&1.2797E+03_JPRB,1.5744E+03_JPRB,1.9051E+03_JPRB,2.2652E+03_JPRB,2.6369E+03_JPRB/)
KBO( :,49,13) = (/&
&1.1690E+03_JPRB,1.4484E+03_JPRB,1.7654E+03_JPRB,2.1147E+03_JPRB,2.4860E+03_JPRB/)
KBO( :,50,13) = (/&
&1.0720E+03_JPRB,1.3359E+03_JPRB,1.6397E+03_JPRB,1.9779E+03_JPRB,2.3429E+03_JPRB/)
KBO( :,51,13) = (/&
&9.8386E+02_JPRB,1.2327E+03_JPRB,1.5222E+03_JPRB,1.8488E+03_JPRB,2.2054E+03_JPRB/)
KBO( :,52,13) = (/&
&9.0207E+02_JPRB,1.1351E+03_JPRB,1.4100E+03_JPRB,1.7243E+03_JPRB,2.0711E+03_JPRB/)
KBO( :,53,13) = (/&
&8.2675E+02_JPRB,1.0437E+03_JPRB,1.3030E+03_JPRB,1.6043E+03_JPRB,1.9396E+03_JPRB/)
KBO( :,54,13) = (/&
&7.6352E+02_JPRB,9.6482E+02_JPRB,1.2111E+03_JPRB,1.4982E+03_JPRB,1.8229E+03_JPRB/)
KBO( :,55,13) = (/&
&7.0952E+02_JPRB,8.9409E+02_JPRB,1.1266E+03_JPRB,1.4008E+03_JPRB,1.7142E+03_JPRB/)
KBO( :,56,13) = (/&
&6.6233E+02_JPRB,8.2850E+02_JPRB,1.0468E+03_JPRB,1.3073E+03_JPRB,1.6094E+03_JPRB/)
KBO( :,57,13) = (/&
&6.2132E+02_JPRB,7.6796E+02_JPRB,9.7144E+02_JPRB,1.2186E+03_JPRB,1.5081E+03_JPRB/)
KBO( :,58,13) = (/&
&5.8653E+02_JPRB,7.1647E+02_JPRB,9.0432E+02_JPRB,1.1383E+03_JPRB,1.4157E+03_JPRB/)
KBO( :,59,13) = (/&
&5.7212E+02_JPRB,6.9724E+02_JPRB,8.7847E+02_JPRB,1.1078E+03_JPRB,1.3794E+03_JPRB/)
KBO( :,13,14) = (/&
&9.8835E+03_JPRB,9.9539E+03_JPRB,1.0003E+04_JPRB,1.0028E+04_JPRB,1.0036E+04_JPRB/)
KBO( :,14,14) = (/&
&1.1157E+04_JPRB,1.1221E+04_JPRB,1.1261E+04_JPRB,1.1278E+04_JPRB,1.1272E+04_JPRB/)
KBO( :,15,14) = (/&
&1.2451E+04_JPRB,1.2500E+04_JPRB,1.2523E+04_JPRB,1.2525E+04_JPRB,1.2496E+04_JPRB/)
KBO( :,16,14) = (/&
&1.3702E+04_JPRB,1.3735E+04_JPRB,1.3749E+04_JPRB,1.3724E+04_JPRB,1.3688E+04_JPRB/)
KBO( :,17,14) = (/&
&1.4864E+04_JPRB,1.4899E+04_JPRB,1.4888E+04_JPRB,1.4860E+04_JPRB,1.4794E+04_JPRB/)
KBO( :,18,14) = (/&
&1.5913E+04_JPRB,1.5926E+04_JPRB,1.5919E+04_JPRB,1.5876E+04_JPRB,1.5804E+04_JPRB/)
KBO( :,19,14) = (/&
&1.6806E+04_JPRB,1.6819E+04_JPRB,1.6811E+04_JPRB,1.6767E+04_JPRB,1.6686E+04_JPRB/)
KBO( :,20,14) = (/&
&1.7528E+04_JPRB,1.7560E+04_JPRB,1.7554E+04_JPRB,1.7516E+04_JPRB,1.7446E+04_JPRB/)
KBO( :,21,14) = (/&
&1.8101E+04_JPRB,1.8142E+04_JPRB,1.8157E+04_JPRB,1.8133E+04_JPRB,1.8069E+04_JPRB/)
KBO( :,22,14) = (/&
&1.8522E+04_JPRB,1.8600E+04_JPRB,1.8643E+04_JPRB,1.8633E+04_JPRB,1.8576E+04_JPRB/)
KBO( :,23,14) = (/&
&1.8830E+04_JPRB,1.8951E+04_JPRB,1.9026E+04_JPRB,1.9036E+04_JPRB,1.8990E+04_JPRB/)
KBO( :,24,14) = (/&
&1.9044E+04_JPRB,1.9220E+04_JPRB,1.9318E+04_JPRB,1.9356E+04_JPRB,1.9336E+04_JPRB/)
KBO( :,25,14) = (/&
&1.9206E+04_JPRB,1.9423E+04_JPRB,1.9557E+04_JPRB,1.9620E+04_JPRB,1.9613E+04_JPRB/)
KBO( :,26,14) = (/&
&1.9345E+04_JPRB,1.9590E+04_JPRB,1.9754E+04_JPRB,1.9836E+04_JPRB,1.9837E+04_JPRB/)
KBO( :,27,14) = (/&
&1.9462E+04_JPRB,1.9735E+04_JPRB,1.9916E+04_JPRB,2.0012E+04_JPRB,2.0020E+04_JPRB/)
KBO( :,28,14) = (/&
&1.9573E+04_JPRB,1.9864E+04_JPRB,2.0059E+04_JPRB,2.0163E+04_JPRB,2.0168E+04_JPRB/)
KBO( :,29,14) = (/&
&1.9682E+04_JPRB,1.9985E+04_JPRB,2.0186E+04_JPRB,2.0286E+04_JPRB,2.0288E+04_JPRB/)
KBO( :,30,14) = (/&
&1.9789E+04_JPRB,2.0101E+04_JPRB,2.0295E+04_JPRB,2.0389E+04_JPRB,2.0383E+04_JPRB/)
KBO( :,31,14) = (/&
&1.9904E+04_JPRB,2.0212E+04_JPRB,2.0395E+04_JPRB,2.0474E+04_JPRB,2.0459E+04_JPRB/)
KBO( :,32,14) = (/&
&2.0019E+04_JPRB,2.0312E+04_JPRB,2.0477E+04_JPRB,2.0546E+04_JPRB,2.0515E+04_JPRB/)
KBO( :,33,14) = (/&
&2.0130E+04_JPRB,2.0401E+04_JPRB,2.0548E+04_JPRB,2.0603E+04_JPRB,2.0557E+04_JPRB/)
KBO( :,34,14) = (/&
&2.0224E+04_JPRB,2.0479E+04_JPRB,2.0609E+04_JPRB,2.0649E+04_JPRB,2.0588E+04_JPRB/)
KBO( :,35,14) = (/&
&2.0280E+04_JPRB,2.0527E+04_JPRB,2.0652E+04_JPRB,2.0686E+04_JPRB,2.0619E+04_JPRB/)
KBO( :,36,14) = (/&
&2.0300E+04_JPRB,2.0553E+04_JPRB,2.0683E+04_JPRB,2.0717E+04_JPRB,2.0652E+04_JPRB/)
KBO( :,37,14) = (/&
&2.0267E+04_JPRB,2.0544E+04_JPRB,2.0692E+04_JPRB,2.0745E+04_JPRB,2.0696E+04_JPRB/)
KBO( :,38,14) = (/&
&2.0221E+04_JPRB,2.0526E+04_JPRB,2.0695E+04_JPRB,2.0765E+04_JPRB,2.0733E+04_JPRB/)
KBO( :,39,14) = (/&
&2.0172E+04_JPRB,2.0502E+04_JPRB,2.0692E+04_JPRB,2.0780E+04_JPRB,2.0762E+04_JPRB/)
KBO( :,40,14) = (/&
&2.0072E+04_JPRB,2.0440E+04_JPRB,2.0669E+04_JPRB,2.0782E+04_JPRB,2.0789E+04_JPRB/)
KBO( :,41,14) = (/&
&1.9953E+04_JPRB,2.0365E+04_JPRB,2.0629E+04_JPRB,2.0773E+04_JPRB,2.0810E+04_JPRB/)
KBO( :,42,14) = (/&
&1.9824E+04_JPRB,2.0275E+04_JPRB,2.0580E+04_JPRB,2.0757E+04_JPRB,2.0819E+04_JPRB/)
KBO( :,43,14) = (/&
&1.9649E+04_JPRB,2.0152E+04_JPRB,2.0505E+04_JPRB,2.0716E+04_JPRB,2.0819E+04_JPRB/)
KBO( :,44,14) = (/&
&1.9430E+04_JPRB,2.0000E+04_JPRB,2.0405E+04_JPRB,2.0665E+04_JPRB,2.0802E+04_JPRB/)
KBO( :,45,14) = (/&
&1.9196E+04_JPRB,1.9828E+04_JPRB,2.0288E+04_JPRB,2.0595E+04_JPRB,2.0775E+04_JPRB/)
KBO( :,46,14) = (/&
&1.8908E+04_JPRB,1.9621E+04_JPRB,2.0141E+04_JPRB,2.0502E+04_JPRB,2.0723E+04_JPRB/)
KBO( :,47,14) = (/&
&1.8564E+04_JPRB,1.9359E+04_JPRB,1.9951E+04_JPRB,2.0375E+04_JPRB,2.0651E+04_JPRB/)
KBO( :,48,14) = (/&
&1.8186E+04_JPRB,1.9064E+04_JPRB,1.9734E+04_JPRB,2.0222E+04_JPRB,2.0560E+04_JPRB/)
KBO( :,49,14) = (/&
&1.7775E+04_JPRB,1.8727E+04_JPRB,1.9486E+04_JPRB,2.0046E+04_JPRB,2.0443E+04_JPRB/)
KBO( :,50,14) = (/&
&1.7362E+04_JPRB,1.8391E+04_JPRB,1.9223E+04_JPRB,1.9856E+04_JPRB,2.0310E+04_JPRB/)
KBO( :,51,14) = (/&
&1.6921E+04_JPRB,1.8033E+04_JPRB,1.8942E+04_JPRB,1.9648E+04_JPRB,2.0164E+04_JPRB/)
KBO( :,52,14) = (/&
&1.6453E+04_JPRB,1.7649E+04_JPRB,1.8637E+04_JPRB,1.9415E+04_JPRB,1.9994E+04_JPRB/)
KBO( :,53,14) = (/&
&1.5948E+04_JPRB,1.7240E+04_JPRB,1.8303E+04_JPRB,1.9152E+04_JPRB,1.9803E+04_JPRB/)
KBO( :,54,14) = (/&
&1.5455E+04_JPRB,1.6834E+04_JPRB,1.7961E+04_JPRB,1.8891E+04_JPRB,1.9606E+04_JPRB/)
KBO( :,55,14) = (/&
&1.4957E+04_JPRB,1.6418E+04_JPRB,1.7624E+04_JPRB,1.8615E+04_JPRB,1.9397E+04_JPRB/)
KBO( :,56,14) = (/&
&1.4440E+04_JPRB,1.5974E+04_JPRB,1.7263E+04_JPRB,1.8321E+04_JPRB,1.9169E+04_JPRB/)
KBO( :,57,14) = (/&
&1.3900E+04_JPRB,1.5506E+04_JPRB,1.6878E+04_JPRB,1.8004E+04_JPRB,1.8917E+04_JPRB/)
KBO( :,58,14) = (/&
&1.3361E+04_JPRB,1.5039E+04_JPRB,1.6487E+04_JPRB,1.7689E+04_JPRB,1.8664E+04_JPRB/)
KBO( :,59,14) = (/&
&1.3141E+04_JPRB,1.4845E+04_JPRB,1.6324E+04_JPRB,1.7549E+04_JPRB,1.8556E+04_JPRB/)
KBO( :,13,15) = (/&
&1.3105E+04_JPRB,1.3211E+04_JPRB,1.3290E+04_JPRB,1.3347E+04_JPRB,1.3377E+04_JPRB/)
KBO( :,14,15) = (/&
&1.5542E+04_JPRB,1.5648E+04_JPRB,1.5712E+04_JPRB,1.5742E+04_JPRB,1.5741E+04_JPRB/)
KBO( :,15,15) = (/&
&1.8293E+04_JPRB,1.8393E+04_JPRB,1.8434E+04_JPRB,1.8432E+04_JPRB,1.8387E+04_JPRB/)
KBO( :,16,15) = (/&
&2.1367E+04_JPRB,2.1424E+04_JPRB,2.1423E+04_JPRB,2.1375E+04_JPRB,2.1256E+04_JPRB/)
KBO( :,17,15) = (/&
&2.4738E+04_JPRB,2.4717E+04_JPRB,2.4651E+04_JPRB,2.4501E+04_JPRB,2.4302E+04_JPRB/)
KBO( :,18,15) = (/&
&2.8333E+04_JPRB,2.8229E+04_JPRB,2.8040E+04_JPRB,2.7775E+04_JPRB,2.7461E+04_JPRB/)
KBO( :,19,15) = (/&
&3.2088E+04_JPRB,3.1857E+04_JPRB,3.1527E+04_JPRB,3.1118E+04_JPRB,3.0643E+04_JPRB/)
KBO( :,20,15) = (/&
&3.5897E+04_JPRB,3.5492E+04_JPRB,3.5012E+04_JPRB,3.4430E+04_JPRB,3.3771E+04_JPRB/)
KBO( :,21,15) = (/&
&3.9650E+04_JPRB,3.9061E+04_JPRB,3.8385E+04_JPRB,3.7607E+04_JPRB,3.6774E+04_JPRB/)
KBO( :,22,15) = (/&
&4.3231E+04_JPRB,4.2424E+04_JPRB,4.1504E+04_JPRB,4.0530E+04_JPRB,3.9497E+04_JPRB/)
KBO( :,23,15) = (/&
&4.6557E+04_JPRB,4.5500E+04_JPRB,4.4350E+04_JPRB,4.3167E+04_JPRB,4.1929E+04_JPRB/)
KBO( :,24,15) = (/&
&4.9552E+04_JPRB,4.8236E+04_JPRB,4.6880E+04_JPRB,4.5475E+04_JPRB,4.4033E+04_JPRB/)
KBO( :,25,15) = (/&
&5.2158E+04_JPRB,5.0602E+04_JPRB,4.9033E+04_JPRB,4.7428E+04_JPRB,4.5797E+04_JPRB/)
KBO( :,26,15) = (/&
&5.4326E+04_JPRB,5.2566E+04_JPRB,5.0793E+04_JPRB,4.9004E+04_JPRB,4.7209E+04_JPRB/)
KBO( :,27,15) = (/&
&5.6113E+04_JPRB,5.4155E+04_JPRB,5.2200E+04_JPRB,5.0246E+04_JPRB,4.8319E+04_JPRB/)
KBO( :,28,15) = (/&
&5.7518E+04_JPRB,5.5394E+04_JPRB,5.3278E+04_JPRB,5.1199E+04_JPRB,4.9157E+04_JPRB/)
KBO( :,29,15) = (/&
&5.8580E+04_JPRB,5.6300E+04_JPRB,5.4057E+04_JPRB,5.1871E+04_JPRB,4.9732E+04_JPRB/)
KBO( :,30,15) = (/&
&5.9321E+04_JPRB,5.6927E+04_JPRB,5.4587E+04_JPRB,5.2312E+04_JPRB,5.0097E+04_JPRB/)
KBO( :,31,15) = (/&
&5.9791E+04_JPRB,5.7302E+04_JPRB,5.4893E+04_JPRB,5.2547E+04_JPRB,5.0272E+04_JPRB/)
KBO( :,32,15) = (/&
&6.0024E+04_JPRB,5.7470E+04_JPRB,5.5008E+04_JPRB,5.2603E+04_JPRB,5.0291E+04_JPRB/)
KBO( :,33,15) = (/&
&6.0073E+04_JPRB,5.7468E+04_JPRB,5.4966E+04_JPRB,5.2524E+04_JPRB,5.0181E+04_JPRB/)
KBO( :,34,15) = (/&
&6.0061E+04_JPRB,5.7423E+04_JPRB,5.4889E+04_JPRB,5.2419E+04_JPRB,5.0055E+04_JPRB/)
KBO( :,35,15) = (/&
&6.0191E+04_JPRB,5.7520E+04_JPRB,5.4955E+04_JPRB,5.2459E+04_JPRB,5.0075E+04_JPRB/)
KBO( :,36,15) = (/&
&6.0539E+04_JPRB,5.7824E+04_JPRB,5.5225E+04_JPRB,5.2698E+04_JPRB,5.0287E+04_JPRB/)
KBO( :,37,15) = (/&
&6.1234E+04_JPRB,5.8473E+04_JPRB,5.5831E+04_JPRB,5.3268E+04_JPRB,5.0811E+04_JPRB/)
KBO( :,38,15) = (/&
&6.1911E+04_JPRB,5.9110E+04_JPRB,5.6429E+04_JPRB,5.3825E+04_JPRB,5.1333E+04_JPRB/)
KBO( :,39,15) = (/&
&6.2546E+04_JPRB,5.9701E+04_JPRB,5.6980E+04_JPRB,5.4347E+04_JPRB,5.1826E+04_JPRB/)
KBO( :,40,15) = (/&
&6.3440E+04_JPRB,6.0560E+04_JPRB,5.7786E+04_JPRB,5.5116E+04_JPRB,5.2552E+04_JPRB/)
KBO( :,41,15) = (/&
&6.4362E+04_JPRB,6.1427E+04_JPRB,5.8612E+04_JPRB,5.5905E+04_JPRB,5.3303E+04_JPRB/)
KBO( :,42,15) = (/&
&6.5271E+04_JPRB,6.2297E+04_JPRB,5.9433E+04_JPRB,5.6685E+04_JPRB,5.4054E+04_JPRB/)
KBO( :,43,15) = (/&
&6.6345E+04_JPRB,6.3316E+04_JPRB,6.0412E+04_JPRB,5.7629E+04_JPRB,5.4943E+04_JPRB/)
KBO( :,44,15) = (/&
&6.7502E+04_JPRB,6.4418E+04_JPRB,6.1461E+04_JPRB,5.8625E+04_JPRB,5.5900E+04_JPRB/)
KBO( :,45,15) = (/&
&6.8664E+04_JPRB,6.5524E+04_JPRB,6.2518E+04_JPRB,5.9632E+04_JPRB,5.6859E+04_JPRB/)
KBO( :,46,15) = (/&
&6.9916E+04_JPRB,6.6699E+04_JPRB,6.3637E+04_JPRB,6.0705E+04_JPRB,5.7897E+04_JPRB/)
KBO( :,47,15) = (/&
&7.1307E+04_JPRB,6.8027E+04_JPRB,6.4908E+04_JPRB,6.1920E+04_JPRB,5.9052E+04_JPRB/)
KBO( :,48,15) = (/&
&7.2692E+04_JPRB,6.9380E+04_JPRB,6.6186E+04_JPRB,6.3144E+04_JPRB,6.0224E+04_JPRB/)
KBO( :,49,15) = (/&
&7.4089E+04_JPRB,7.0754E+04_JPRB,6.7488E+04_JPRB,6.4384E+04_JPRB,6.1415E+04_JPRB/)
KBO( :,50,15) = (/&
&7.5388E+04_JPRB,7.2035E+04_JPRB,6.8731E+04_JPRB,6.5568E+04_JPRB,6.2543E+04_JPRB/)
KBO( :,51,15) = (/&
&7.6677E+04_JPRB,7.3293E+04_JPRB,6.9952E+04_JPRB,6.6726E+04_JPRB,6.3655E+04_JPRB/)
KBO( :,52,15) = (/&
&7.7977E+04_JPRB,7.4539E+04_JPRB,7.1186E+04_JPRB,6.7906E+04_JPRB,6.4783E+04_JPRB/)
KBO( :,53,15) = (/&
&7.9289E+04_JPRB,7.5794E+04_JPRB,7.2422E+04_JPRB,6.9107E+04_JPRB,6.5922E+04_JPRB/)
KBO( :,54,15) = (/&
&8.0507E+04_JPRB,7.6976E+04_JPRB,7.3575E+04_JPRB,7.0226E+04_JPRB,6.6980E+04_JPRB/)
KBO( :,55,15) = (/&
&8.1668E+04_JPRB,7.8115E+04_JPRB,7.4665E+04_JPRB,7.1303E+04_JPRB,6.8017E+04_JPRB/)
KBO( :,56,15) = (/&
&8.2825E+04_JPRB,7.9256E+04_JPRB,7.5760E+04_JPRB,7.2375E+04_JPRB,6.9059E+04_JPRB/)
KBO( :,57,15) = (/&
&8.3969E+04_JPRB,8.0408E+04_JPRB,7.6872E+04_JPRB,7.3475E+04_JPRB,7.0130E+04_JPRB/)
KBO( :,58,15) = (/&
&8.5046E+04_JPRB,8.1501E+04_JPRB,7.7943E+04_JPRB,7.4498E+04_JPRB,7.1139E+04_JPRB/)
KBO( :,59,15) = (/&
&8.5481E+04_JPRB,8.1948E+04_JPRB,7.8376E+04_JPRB,7.4922E+04_JPRB,7.1551E+04_JPRB/)
KBO( :,13,16) = (/&
&1.4822E+04_JPRB,1.4947E+04_JPRB,1.5039E+04_JPRB,1.5078E+04_JPRB,1.5067E+04_JPRB/)
KBO( :,14,16) = (/&
&1.7844E+04_JPRB,1.7976E+04_JPRB,1.8048E+04_JPRB,1.8049E+04_JPRB,1.8009E+04_JPRB/)
KBO( :,15,16) = (/&
&2.1400E+04_JPRB,2.1492E+04_JPRB,2.1520E+04_JPRB,2.1466E+04_JPRB,2.1373E+04_JPRB/)
KBO( :,16,16) = (/&
&2.5508E+04_JPRB,2.5515E+04_JPRB,2.5445E+04_JPRB,2.5314E+04_JPRB,2.5126E+04_JPRB/)
KBO( :,17,16) = (/&
&3.0159E+04_JPRB,3.0040E+04_JPRB,2.9821E+04_JPRB,2.9561E+04_JPRB,2.9224E+04_JPRB/)
KBO( :,18,16) = (/&
&3.5323E+04_JPRB,3.5002E+04_JPRB,3.4578E+04_JPRB,3.4138E+04_JPRB,3.3586E+04_JPRB/)
KBO( :,19,16) = (/&
&4.0906E+04_JPRB,4.0304E+04_JPRB,3.9627E+04_JPRB,3.8916E+04_JPRB,3.8103E+04_JPRB/)
KBO( :,20,16) = (/&
&4.6757E+04_JPRB,4.5796E+04_JPRB,4.4798E+04_JPRB,4.3759E+04_JPRB,4.2633E+04_JPRB/)
KBO( :,21,16) = (/&
&5.2696E+04_JPRB,5.1326E+04_JPRB,4.9934E+04_JPRB,4.8491E+04_JPRB,4.7018E+04_JPRB/)
KBO( :,22,16) = (/&
&5.8463E+04_JPRB,5.6597E+04_JPRB,5.4757E+04_JPRB,5.2889E+04_JPRB,5.1042E+04_JPRB/)
KBO( :,23,16) = (/&
&6.3885E+04_JPRB,6.1516E+04_JPRB,5.9197E+04_JPRB,5.6911E+04_JPRB,5.4673E+04_JPRB/)
KBO( :,24,16) = (/&
&6.8792E+04_JPRB,6.5930E+04_JPRB,6.3138E+04_JPRB,6.0429E+04_JPRB,5.7833E+04_JPRB/)
KBO( :,25,16) = (/&
&7.3081E+04_JPRB,6.9742E+04_JPRB,6.6502E+04_JPRB,6.3413E+04_JPRB,6.0489E+04_JPRB/)
KBO( :,26,16) = (/&
&7.6659E+04_JPRB,7.2881E+04_JPRB,6.9229E+04_JPRB,6.5813E+04_JPRB,6.2609E+04_JPRB/)
KBO( :,27,16) = (/&
&7.9551E+04_JPRB,7.5372E+04_JPRB,7.1411E+04_JPRB,6.7691E+04_JPRB,6.4257E+04_JPRB/)
KBO( :,28,16) = (/&
&8.1786E+04_JPRB,7.7281E+04_JPRB,7.3039E+04_JPRB,6.9087E+04_JPRB,6.5469E+04_JPRB/)
KBO( :,29,16) = (/&
&8.3384E+04_JPRB,7.8614E+04_JPRB,7.4165E+04_JPRB,7.0047E+04_JPRB,6.6277E+04_JPRB/)
KBO( :,30,16) = (/&
&8.4452E+04_JPRB,7.9468E+04_JPRB,7.4871E+04_JPRB,7.0641E+04_JPRB,6.6750E+04_JPRB/)
KBO( :,31,16) = (/&
&8.5039E+04_JPRB,7.9905E+04_JPRB,7.5199E+04_JPRB,7.0901E+04_JPRB,6.6924E+04_JPRB/)
KBO( :,32,16) = (/&
&8.5212E+04_JPRB,7.9990E+04_JPRB,7.5213E+04_JPRB,7.0881E+04_JPRB,6.6857E+04_JPRB/)
KBO( :,33,16) = (/&
&8.5050E+04_JPRB,7.9794E+04_JPRB,7.5003E+04_JPRB,7.0644E+04_JPRB,6.6588E+04_JPRB/)
KBO( :,34,16) = (/&
&8.4825E+04_JPRB,7.9556E+04_JPRB,7.4769E+04_JPRB,7.0382E+04_JPRB,6.6308E+04_JPRB/)
KBO( :,35,16) = (/&
&8.4932E+04_JPRB,7.9627E+04_JPRB,7.4818E+04_JPRB,7.0396E+04_JPRB,6.6295E+04_JPRB/)
KBO( :,36,16) = (/&
&8.5505E+04_JPRB,8.0119E+04_JPRB,7.5241E+04_JPRB,7.0767E+04_JPRB,6.6616E+04_JPRB/)
KBO( :,37,16) = (/&
&8.6832E+04_JPRB,8.1301E+04_JPRB,7.6293E+04_JPRB,7.1722E+04_JPRB,6.7493E+04_JPRB/)
KBO( :,38,16) = (/&
&8.8141E+04_JPRB,8.2471E+04_JPRB,7.7320E+04_JPRB,7.2657E+04_JPRB,6.8355E+04_JPRB/)
KBO( :,39,16) = (/&
&8.9385E+04_JPRB,8.3583E+04_JPRB,7.8311E+04_JPRB,7.3555E+04_JPRB,6.9176E+04_JPRB/)
KBO( :,40,16) = (/&
&9.1225E+04_JPRB,8.5227E+04_JPRB,7.9808E+04_JPRB,7.4896E+04_JPRB,7.0406E+04_JPRB/)
KBO( :,41,16) = (/&
&9.3145E+04_JPRB,8.6959E+04_JPRB,8.1376E+04_JPRB,7.6283E+04_JPRB,7.1693E+04_JPRB/)
KBO( :,42,16) = (/&
&9.5061E+04_JPRB,8.8707E+04_JPRB,8.2949E+04_JPRB,7.7691E+04_JPRB,7.2983E+04_JPRB/)
KBO( :,43,16) = (/&
&9.7401E+04_JPRB,9.0828E+04_JPRB,8.4849E+04_JPRB,7.9428E+04_JPRB,7.4539E+04_JPRB/)
KBO( :,44,16) = (/&
&9.9953E+04_JPRB,9.3134E+04_JPRB,8.6932E+04_JPRB,8.1331E+04_JPRB,7.6228E+04_JPRB/)
KBO( :,45,16) = (/&
&1.0257E+05_JPRB,9.5499E+04_JPRB,8.9091E+04_JPRB,8.3270E+04_JPRB,7.7968E+04_JPRB/)
KBO( :,46,16) = (/&
&1.0547E+05_JPRB,9.8084E+04_JPRB,9.1440E+04_JPRB,8.5379E+04_JPRB,7.9900E+04_JPRB/)
KBO( :,47,16) = (/&
&1.0883E+05_JPRB,1.0107E+05_JPRB,9.4133E+04_JPRB,8.7821E+04_JPRB,8.2113E+04_JPRB/)
KBO( :,48,16) = (/&
&1.1238E+05_JPRB,1.0415E+05_JPRB,9.6911E+04_JPRB,9.0357E+04_JPRB,8.4400E+04_JPRB/)
KBO( :,49,16) = (/&
&1.1611E+05_JPRB,1.0741E+05_JPRB,9.9813E+04_JPRB,9.2980E+04_JPRB,8.6767E+04_JPRB/)
KBO( :,50,16) = (/&
&1.1983E+05_JPRB,1.1062E+05_JPRB,1.0263E+05_JPRB,9.5525E+04_JPRB,8.9084E+04_JPRB/)
KBO( :,51,16) = (/&
&1.2356E+05_JPRB,1.1388E+05_JPRB,1.0545E+05_JPRB,9.8084E+04_JPRB,9.1415E+04_JPRB/)
KBO( :,52,16) = (/&
&1.2745E+05_JPRB,1.1733E+05_JPRB,1.0841E+05_JPRB,1.0073E+05_JPRB,9.3803E+04_JPRB/)
KBO( :,53,16) = (/&
&1.3156E+05_JPRB,1.2095E+05_JPRB,1.1156E+05_JPRB,1.0347E+05_JPRB,9.6284E+04_JPRB/)
KBO( :,54,16) = (/&
&1.3554E+05_JPRB,1.2438E+05_JPRB,1.1460E+05_JPRB,1.0608E+05_JPRB,9.8639E+04_JPRB/)
KBO( :,55,16) = (/&
&1.3951E+05_JPRB,1.2782E+05_JPRB,1.1764E+05_JPRB,1.0869E+05_JPRB,1.0096E+05_JPRB/)
KBO( :,56,16) = (/&
&1.4367E+05_JPRB,1.3142E+05_JPRB,1.2080E+05_JPRB,1.1144E+05_JPRB,1.0335E+05_JPRB/)
KBO( :,57,16) = (/&
&1.4808E+05_JPRB,1.3519E+05_JPRB,1.2406E+05_JPRB,1.1429E+05_JPRB,1.0582E+05_JPRB/)
KBO( :,58,16) = (/&
&1.5260E+05_JPRB,1.3891E+05_JPRB,1.2727E+05_JPRB,1.1713E+05_JPRB,1.0827E+05_JPRB/)
KBO( :,59,16) = (/&
&1.5447E+05_JPRB,1.4046E+05_JPRB,1.2861E+05_JPRB,1.1836E+05_JPRB,1.0930E+05_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&4.67280E-03_JPRB, 3.95219E-03_JPRB, 3.34270E-03_JPRB, 2.82721E-03_JPRB, 2.39121E-03_JPRB,&
&2.02245E-03_JPRB, 1.71056E-03_JPRB, 1.44677E-03_JPRB, 1.22365E-03_JPRB, 1.03495E-03_JPRB/)
SELFREFO( :, 2) = (/&
&4.42573E-03_JPRB, 3.73328E-03_JPRB, 3.14917E-03_JPRB, 2.65644E-03_JPRB, 2.24081E-03_JPRB,&
&1.89021E-03_JPRB, 1.59447E-03_JPRB, 1.34500E-03_JPRB, 1.13456E-03_JPRB, 9.57044E-04_JPRB/)
SELFREFO( :, 3) = (/&
&3.96061E-03_JPRB, 3.33783E-03_JPRB, 2.81297E-03_JPRB, 2.37065E-03_JPRB, 1.99788E-03_JPRB,&
&1.68372E-03_JPRB, 1.41897E-03_JPRB, 1.19584E-03_JPRB, 1.00780E-03_JPRB, 8.49333E-04_JPRB/)
SELFREFO( :, 4) = (/&
&3.71838E-03_JPRB, 3.10031E-03_JPRB, 2.58497E-03_JPRB, 2.15529E-03_JPRB, 1.79704E-03_JPRB,&
&1.49833E-03_JPRB, 1.24928E-03_JPRB, 1.04162E-03_JPRB, 8.68480E-04_JPRB, 7.24120E-04_JPRB/)
SELFREFO( :, 5) = (/&
&3.55795E-03_JPRB, 2.95385E-03_JPRB, 2.45232E-03_JPRB, 2.03594E-03_JPRB, 1.69026E-03_JPRB,&
&1.40327E-03_JPRB, 1.16501E-03_JPRB, 9.67201E-04_JPRB, 8.02981E-04_JPRB, 6.66643E-04_JPRB/)
SELFREFO( :, 6) = (/&
&3.47573E-03_JPRB, 2.88608E-03_JPRB, 2.39646E-03_JPRB, 1.98991E-03_JPRB, 1.65232E-03_JPRB,&
&1.37201E-03_JPRB, 1.13925E-03_JPRB, 9.45979E-04_JPRB, 7.85496E-04_JPRB, 6.52238E-04_JPRB/)
SELFREFO( :, 7) = (/&
&3.44473E-03_JPRB, 2.86220E-03_JPRB, 2.37818E-03_JPRB, 1.97601E-03_JPRB, 1.64185E-03_JPRB,&
&1.36420E-03_JPRB, 1.13350E-03_JPRB, 9.41819E-04_JPRB, 7.82550E-04_JPRB, 6.50214E-04_JPRB/)
SELFREFO( :, 8) = (/&
&3.40166E-03_JPRB, 2.82961E-03_JPRB, 2.35376E-03_JPRB, 1.95793E-03_JPRB, 1.62867E-03_JPRB,&
&1.35478E-03_JPRB, 1.12694E-03_JPRB, 9.37427E-04_JPRB, 7.79781E-04_JPRB, 6.48646E-04_JPRB/)
SELFREFO( :, 9) = (/&
&3.39363E-03_JPRB, 2.82276E-03_JPRB, 2.34792E-03_JPRB, 1.95296E-03_JPRB, 1.62443E-03_JPRB,&
&1.35117E-03_JPRB, 1.12388E-03_JPRB, 9.34822E-04_JPRB, 7.77568E-04_JPRB, 6.46766E-04_JPRB/)
SELFREFO( :,10) = (/&
&3.37151E-03_JPRB, 2.80633E-03_JPRB, 2.33590E-03_JPRB, 1.94432E-03_JPRB, 1.61839E-03_JPRB,&
&1.34709E-03_JPRB, 1.12128E-03_JPRB, 9.33313E-04_JPRB, 7.76859E-04_JPRB, 6.46632E-04_JPRB/)
SELFREFO( :,11) = (/&
&3.37954E-03_JPRB, 2.81192E-03_JPRB, 2.33963E-03_JPRB, 1.94666E-03_JPRB, 1.61970E-03_JPRB,&
&1.34765E-03_JPRB, 1.12130E-03_JPRB, 9.32968E-04_JPRB, 7.76266E-04_JPRB, 6.45885E-04_JPRB/)
SELFREFO( :,12) = (/&
&3.39637E-03_JPRB, 2.82275E-03_JPRB, 2.34600E-03_JPRB, 1.94978E-03_JPRB, 1.62048E-03_JPRB,&
&1.34679E-03_JPRB, 1.11933E-03_JPRB, 9.30281E-04_JPRB, 7.73163E-04_JPRB, 6.42581E-04_JPRB/)
SELFREFO( :,13) = (/&
&3.35979E-03_JPRB, 2.79857E-03_JPRB, 2.33109E-03_JPRB, 1.94170E-03_JPRB, 1.61736E-03_JPRB,&
&1.34719E-03_JPRB, 1.12216E-03_JPRB, 9.34712E-04_JPRB, 7.78576E-04_JPRB, 6.48522E-04_JPRB/)
SELFREFO( :,14) = (/&
&3.40473E-03_JPRB, 2.82009E-03_JPRB, 2.33585E-03_JPRB, 1.93475E-03_JPRB, 1.60253E-03_JPRB,&
&1.32736E-03_JPRB, 1.09943E-03_JPRB, 9.10645E-04_JPRB, 7.54276E-04_JPRB, 6.24757E-04_JPRB/)
SELFREFO( :,15) = (/&
&3.27200E-03_JPRB, 2.70869E-03_JPRB, 2.24237E-03_JPRB, 1.85633E-03_JPRB, 1.53675E-03_JPRB,&
&1.27218E-03_JPRB, 1.05317E-03_JPRB, 8.71854E-04_JPRB, 7.21757E-04_JPRB, 5.97501E-04_JPRB/)
SELFREFO( :,16) = (/&
&3.22979E-03_JPRB, 2.67796E-03_JPRB, 2.22041E-03_JPRB, 1.84104E-03_JPRB, 1.52648E-03_JPRB,&
&1.26567E-03_JPRB, 1.04942E-03_JPRB, 8.70124E-04_JPRB, 7.21457E-04_JPRB, 5.98191E-04_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB14
