!OCL SCALAR
SUBROUTINE RRTM_KGB13_00

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 13:  2080-2250 cm-1 (low - H2O,N2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO13, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA13, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
STRRAT = 16658.87_JPRB

!     ------------------------------------------------------------------

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&9.83745E-03_JPRB, 8.45687E-03_JPRB, 7.27004E-03_JPRB, 6.24977E-03_JPRB, 5.37269E-03_JPRB,&
&4.61869E-03_JPRB, 3.97051E-03_JPRB, 3.41329E-03_JPRB, 2.93427E-03_JPRB, 2.52248E-03_JPRB/)
SELFREFO( :, 2) = (/&
&9.79014E-03_JPRB, 8.48557E-03_JPRB, 7.35483E-03_JPRB, 6.37477E-03_JPRB, 5.52531E-03_JPRB,&
&4.78905E-03_JPRB, 4.15089E-03_JPRB, 3.59777E-03_JPRB, 3.11835E-03_JPRB, 2.70282E-03_JPRB/)
SELFREFO( :, 3) = (/&
&9.36931E-03_JPRB, 8.10880E-03_JPRB, 7.01787E-03_JPRB, 6.07371E-03_JPRB, 5.25658E-03_JPRB,&
&4.54938E-03_JPRB, 3.93732E-03_JPRB, 3.40761E-03_JPRB, 2.94916E-03_JPRB, 2.55239E-03_JPRB/)
SELFREFO( :, 4) = (/&
&8.44896E-03_JPRB, 7.26401E-03_JPRB, 6.24525E-03_JPRB, 5.36937E-03_JPRB, 4.61632E-03_JPRB,&
&3.96889E-03_JPRB, 3.41226E-03_JPRB, 2.93370E-03_JPRB, 2.52226E-03_JPRB, 2.16851E-03_JPRB/)
SELFREFO( :, 5) = (/&
&6.69018E-03_JPRB, 5.93911E-03_JPRB, 5.27237E-03_JPRB, 4.68047E-03_JPRB, 4.15502E-03_JPRB,&
&3.68856E-03_JPRB, 3.27447E-03_JPRB, 2.90686E-03_JPRB, 2.58053E-03_JPRB, 2.29083E-03_JPRB/)
SELFREFO( :, 6) = (/&
&6.26590E-03_JPRB, 5.54076E-03_JPRB, 4.89954E-03_JPRB, 4.33252E-03_JPRB, 3.83113E-03_JPRB,&
&3.38776E-03_JPRB, 2.99570E-03_JPRB, 2.64901E-03_JPRB, 2.34244E-03_JPRB, 2.07136E-03_JPRB/)
SELFREFO( :, 7) = (/&
&6.01943E-03_JPRB, 5.31006E-03_JPRB, 4.68429E-03_JPRB, 4.13226E-03_JPRB, 3.64529E-03_JPRB,&
&3.21570E-03_JPRB, 2.83674E-03_JPRB, 2.50244E-03_JPRB, 2.20754E-03_JPRB, 1.94739E-03_JPRB/)
SELFREFO( :, 8) = (/&
&5.80205E-03_JPRB, 5.07696E-03_JPRB, 4.44248E-03_JPRB, 3.88730E-03_JPRB, 3.40149E-03_JPRB,&
&2.97640E-03_JPRB, 2.60444E-03_JPRB, 2.27895E-03_JPRB, 1.99415E-03_JPRB, 1.74494E-03_JPRB/)
SELFREFO( :, 9) = (/&
&4.90962E-03_JPRB, 4.54613E-03_JPRB, 4.20956E-03_JPRB, 3.89790E-03_JPRB, 3.60931E-03_JPRB,&
&3.34210E-03_JPRB, 3.09466E-03_JPRB, 2.86555E-03_JPRB, 2.65339E-03_JPRB, 2.45695E-03_JPRB/)
SELFREFO( :,10) = (/&
&4.51541E-03_JPRB, 4.34841E-03_JPRB, 4.18758E-03_JPRB, 4.03271E-03_JPRB, 3.88356E-03_JPRB,&
&3.73992E-03_JPRB, 3.60160E-03_JPRB, 3.46840E-03_JPRB, 3.34012E-03_JPRB, 3.21658E-03_JPRB/)
SELFREFO( :,11) = (/&
&4.41859E-03_JPRB, 4.25299E-03_JPRB, 4.09360E-03_JPRB, 3.94018E-03_JPRB, 3.79252E-03_JPRB,&
&3.65038E-03_JPRB, 3.51357E-03_JPRB, 3.38189E-03_JPRB, 3.25515E-03_JPRB, 3.13316E-03_JPRB/)
SELFREFO( :,12) = (/&
&4.41867E-03_JPRB, 4.22140E-03_JPRB, 4.03294E-03_JPRB, 3.85289E-03_JPRB, 3.68088E-03_JPRB,&
&3.51655E-03_JPRB, 3.35956E-03_JPRB, 3.20957E-03_JPRB, 3.06628E-03_JPRB, 2.92939E-03_JPRB/)
SELFREFO( :,13) = (/&
&4.42776E-03_JPRB, 4.34604E-03_JPRB, 4.26583E-03_JPRB, 4.18710E-03_JPRB, 4.10983E-03_JPRB,&
&4.03398E-03_JPRB, 3.95953E-03_JPRB, 3.88645E-03_JPRB, 3.81472E-03_JPRB, 3.74432E-03_JPRB/)
SELFREFO( :,14) = (/&
&4.46410E-03_JPRB, 4.46210E-03_JPRB, 4.46011E-03_JPRB, 4.45812E-03_JPRB, 4.45613E-03_JPRB,&
&4.45414E-03_JPRB, 4.45216E-03_JPRB, 4.45017E-03_JPRB, 4.44818E-03_JPRB, 4.44620E-03_JPRB/)
SELFREFO( :,15) = (/&
&3.21270E-03_JPRB, 3.42098E-03_JPRB, 3.64276E-03_JPRB, 3.87892E-03_JPRB, 4.13040E-03_JPRB,&
&4.39817E-03_JPRB, 4.68330E-03_JPRB, 4.98692E-03_JPRB, 5.31023E-03_JPRB, 5.65449E-03_JPRB/)
SELFREFO( :,16) = (/&
&3.11411E-03_JPRB, 3.35874E-03_JPRB, 3.62259E-03_JPRB, 3.90717E-03_JPRB, 4.21410E-03_JPRB,&
&4.54514E-03_JPRB, 4.90219E-03_JPRB, 5.28729E-03_JPRB, 5.70264E-03_JPRB, 6.15061E-03_JPRB/)

FRACREFAO( : , 1) = (/&
!   From P = 706.3 mb.
    &0.17683899_JPRB,0.17319500_JPRB,0.15712699_JPRB,0.13604601_JPRB,&
    &0.10776200_JPRB,0.08750010_JPRB,0.06808820_JPRB,0.04905150_JPRB,&
    &0.03280360_JPRB,0.00350836_JPRB,0.00281864_JPRB,0.00219862_JPRB,&
    &0.00160943_JPRB,0.00101885_JPRB,0.00038147_JPRB,0.00005348_JPRB/)
FRACREFAO( : , 2) = (/&
    &0.17535400_JPRB,0.16999300_JPRB,0.15610200_JPRB,0.13589200_JPRB,&
    &0.10842100_JPRB,0.08988550_JPRB,0.06943920_JPRB,0.04974900_JPRB,&
    &0.03323400_JPRB,0.00352752_JPRB,0.00289402_JPRB,0.00231003_JPRB,&
    &0.00174659_JPRB,0.00101884_JPRB,0.00038147_JPRB,0.00005348_JPRB/)
FRACREFAO( : , 3) = (/&
    &0.17409500_JPRB,0.16846400_JPRB,0.15641899_JPRB,0.13503000_JPRB,&
    &0.10838600_JPRB,0.08985800_JPRB,0.07092720_JPRB,0.05075710_JPRB,&
    &0.03364180_JPRB,0.00354241_JPRB,0.00303507_JPRB,0.00243391_JPRB,&
    &0.00177502_JPRB,0.00114638_JPRB,0.00043585_JPRB,0.00005348_JPRB/)
FRACREFAO( : , 4) = (/&
    &0.17248300_JPRB,0.16778600_JPRB,0.15543500_JPRB,0.13496999_JPRB,&
    &0.10826300_JPRB,0.09028740_JPRB,0.07156720_JPRB,0.05187120_JPRB,&
    &0.03424890_JPRB,0.00363933_JPRB,0.00324715_JPRB,0.00255030_JPRB,&
    &0.00187380_JPRB,0.00116978_JPRB,0.00051229_JPRB,0.00009768_JPRB/)
FRACREFAO( : , 5) = (/&
    &0.17061099_JPRB,0.16715799_JPRB,0.15405200_JPRB,0.13471501_JPRB,&
    &0.10896400_JPRB,0.09069460_JPRB,0.07229760_JPRB,0.05218280_JPRB,&
    &0.03555340_JPRB,0.00379576_JPRB,0.00330240_JPRB,0.00274693_JPRB,&
    &0.00201587_JPRB,0.00119598_JPRB,0.00061885_JPRB,0.00009768_JPRB/)
FRACREFAO( : , 6) = (/&
    &0.16789700_JPRB,0.16629100_JPRB,0.15270300_JPRB,0.13360199_JPRB,&
    &0.11047200_JPRB,0.09151080_JPRB,0.07325000_JPRB,0.05261450_JPRB,&
    &0.03657990_JPRB,0.00450092_JPRB,0.00349537_JPRB,0.00283321_JPRB,&
    &0.00208396_JPRB,0.00140354_JPRB,0.00066587_JPRB,0.00009768_JPRB/)
FRACREFAO( : , 7) = (/&
    &0.16412200_JPRB,0.16387400_JPRB,0.15211500_JPRB,0.13062200_JPRB,&
    &0.11325100_JPRB,0.09348130_JPRB,0.07381380_JPRB,0.05434740_JPRB,&
    &0.03803160_JPRB,0.00481346_JPRB,0.00393592_JPRB,0.00296633_JPRB,&
    &0.00222532_JPRB,0.00163762_JPRB,0.00066648_JPRB,0.00009768_JPRB/)
FRACREFAO( : , 8) = (/&
    &0.15513401_JPRB,0.15768200_JPRB,0.14850400_JPRB,0.13330200_JPRB,&
    &0.11446500_JPRB,0.09868230_JPRB,0.07642050_JPRB,0.05624170_JPRB,&
    &0.04197810_JPRB,0.00502288_JPRB,0.00429452_JPRB,0.00315347_JPRB,&
    &0.00263559_JPRB,0.00171772_JPRB,0.00066860_JPRB,0.00009768_JPRB/)
FRACREFAO( : , 9) = (/&
    &0.15732600_JPRB,0.15223300_JPRB,0.14271900_JPRB,0.13563600_JPRB,&
    &0.11859600_JPRB,0.10274200_JPRB,0.07934560_JPRB,0.05763410_JPRB,&
    &0.03921740_JPRB,0.00437741_JPRB,0.00337921_JPRB,0.00280212_JPRB,&
    &0.00200156_JPRB,0.00124812_JPRB,0.00064664_JPRB,0.00009768_JPRB/)

!     ------------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB13_00
