!OCL SCALAR
SUBROUTINE RRTM_KGB12_00

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 12:  1800-2080 cm-1 (low - H2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO12, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA12, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
STRRAT = 0.009736757_JPRB

!     ------------------------------------------------------------------

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&2.34973E-02_JPRB, 2.07877E-02_JPRB, 1.83905E-02_JPRB, 1.62698E-02_JPRB, 1.43936E-02_JPRB,&
&1.27338E-02_JPRB, 1.12654E-02_JPRB, 9.96632E-03_JPRB, 8.81704E-03_JPRB, 7.80030E-03_JPRB/)
SELFREFO( :, 2) = (/&
&3.10090E-02_JPRB, 2.82626E-02_JPRB, 2.57594E-02_JPRB, 2.34779E-02_JPRB, 2.13985E-02_JPRB,&
&1.95033E-02_JPRB, 1.77759E-02_JPRB, 1.62015E-02_JPRB, 1.47665E-02_JPRB, 1.34587E-02_JPRB/)
SELFREFO( :, 3) = (/&
&5.36676E-02_JPRB, 4.95621E-02_JPRB, 4.57706E-02_JPRB, 4.22692E-02_JPRB, 3.90356E-02_JPRB,&
&3.60494E-02_JPRB, 3.32917E-02_JPRB, 3.07449E-02_JPRB, 2.83929E-02_JPRB, 2.62209E-02_JPRB/)
SELFREFO( :, 4) = (/&
&9.05844E-02_JPRB, 8.33349E-02_JPRB, 7.66656E-02_JPRB, 7.05300E-02_JPRB, 6.48855E-02_JPRB,&
&5.96927E-02_JPRB, 5.49155E-02_JPRB, 5.05206E-02_JPRB, 4.64774E-02_JPRB, 4.27578E-02_JPRB/)
SELFREFO( :, 5) = (/&
&1.10531E-01_JPRB, 1.03430E-01_JPRB, 9.67851E-02_JPRB, 9.05670E-02_JPRB, 8.47484E-02_JPRB,&
&7.93037E-02_JPRB, 7.42087E-02_JPRB, 6.94411E-02_JPRB, 6.49797E-02_JPRB, 6.08050E-02_JPRB/)
SELFREFO( :, 6) = (/&
&1.24308E-01_JPRB, 1.16014E-01_JPRB, 1.08274E-01_JPRB, 1.01050E-01_JPRB, 9.43078E-02_JPRB,&
&8.80155E-02_JPRB, 8.21431E-02_JPRB, 7.66624E-02_JPRB, 7.15475E-02_JPRB, 6.67738E-02_JPRB/)
SELFREFO( :, 7) = (/&
&1.34594E-01_JPRB, 1.25054E-01_JPRB, 1.16190E-01_JPRB, 1.07954E-01_JPRB, 1.00302E-01_JPRB,&
&9.31920E-02_JPRB, 8.65863E-02_JPRB, 8.04488E-02_JPRB, 7.47464E-02_JPRB, 6.94481E-02_JPRB/)
SELFREFO( :, 8) = (/&
&1.26966E-01_JPRB, 1.18270E-01_JPRB, 1.10169E-01_JPRB, 1.02624E-01_JPRB, 9.55948E-02_JPRB,&
&8.90474E-02_JPRB, 8.29484E-02_JPRB, 7.72672E-02_JPRB, 7.19750E-02_JPRB, 6.70453E-02_JPRB/)
SELFREFO( :, 9) = (/&
&1.29806E-01_JPRB, 1.21296E-01_JPRB, 1.13344E-01_JPRB, 1.05913E-01_JPRB, 9.89690E-02_JPRB,&
&9.24805E-02_JPRB, 8.64175E-02_JPRB, 8.07519E-02_JPRB, 7.54578E-02_JPRB, 7.05108E-02_JPRB/)
SELFREFO( :,10) = (/&
&1.37781E-01_JPRB, 1.26830E-01_JPRB, 1.16751E-01_JPRB, 1.07472E-01_JPRB, 9.89303E-02_JPRB,&
&9.10678E-02_JPRB, 8.38301E-02_JPRB, 7.71677E-02_JPRB, 7.10347E-02_JPRB, 6.53892E-02_JPRB/)
SELFREFO( :,11) = (/&
&1.30675E-01_JPRB, 1.24254E-01_JPRB, 1.18149E-01_JPRB, 1.12344E-01_JPRB, 1.06824E-01_JPRB,&
&1.01575E-01_JPRB, 9.65839E-02_JPRB, 9.18383E-02_JPRB, 8.73258E-02_JPRB, 8.30351E-02_JPRB/)
SELFREFO( :,12) = (/&
&1.55998E-01_JPRB, 1.45155E-01_JPRB, 1.35067E-01_JPRB, 1.25679E-01_JPRB, 1.16944E-01_JPRB,&
&1.08816E-01_JPRB, 1.01253E-01_JPRB, 9.42160E-02_JPRB, 8.76677E-02_JPRB, 8.15746E-02_JPRB/)
SELFREFO( :,13) = (/&
&1.56508E-01_JPRB, 1.46390E-01_JPRB, 1.36925E-01_JPRB, 1.28072E-01_JPRB, 1.19792E-01_JPRB,&
&1.12047E-01_JPRB, 1.04803E-01_JPRB, 9.80266E-02_JPRB, 9.16888E-02_JPRB, 8.57608E-02_JPRB/)
SELFREFO( :,14) = (/&
&1.55206E-01_JPRB, 1.43469E-01_JPRB, 1.32620E-01_JPRB, 1.22591E-01_JPRB, 1.13321E-01_JPRB,&
&1.04752E-01_JPRB, 9.68305E-02_JPRB, 8.95082E-02_JPRB, 8.27396E-02_JPRB, 7.64829E-02_JPRB/)
SELFREFO( :,15) = (/&
&1.46694E-01_JPRB, 1.35458E-01_JPRB, 1.25082E-01_JPRB, 1.15501E-01_JPRB, 1.06654E-01_JPRB,&
&9.84840E-02_JPRB, 9.09403E-02_JPRB, 8.39744E-02_JPRB, 7.75420E-02_JPRB, 7.16024E-02_JPRB/)
SELFREFO( :,16) = (/&
&1.65126E-01_JPRB, 1.53281E-01_JPRB, 1.42287E-01_JPRB, 1.32081E-01_JPRB, 1.22607E-01_JPRB,&
&1.13812E-01_JPRB, 1.05649E-01_JPRB, 9.80707E-02_JPRB, 9.10362E-02_JPRB, 8.45063E-02_JPRB/)

FRACREFAO( : ,1) = (/&
!     From P = 706.3 mb.
    &0.21245100_JPRB,0.15164700_JPRB,0.14486700_JPRB,0.13075501_JPRB,&
    &0.11629600_JPRB,0.09266050_JPRB,0.06579930_JPRB,0.04524000_JPRB,&
    &0.03072870_JPRB,0.00284297_JPRB,0.00234660_JPRB,0.00185208_JPRB,&
    &0.00133978_JPRB,0.00082214_JPRB,0.00031016_JPRB,0.00004363_JPRB/)
FRACREFAO( : ,2) = (/&
    &0.14703900_JPRB,0.16937999_JPRB,0.15605700_JPRB,0.14159000_JPRB,&
    &0.12088500_JPRB,0.10058500_JPRB,0.06809110_JPRB,0.05131470_JPRB,&
    &0.03487040_JPRB,0.00327281_JPRB,0.00250183_JPRB,0.00190024_JPRB,&
    &0.00133978_JPRB,0.00082214_JPRB,0.00031016_JPRB,0.00004363_JPRB/)
FRACREFAO( : ,3) = (/&
    &0.13689300_JPRB,0.16610400_JPRB,0.15723500_JPRB,0.14299500_JPRB,&
    &0.12399400_JPRB,0.09907820_JPRB,0.07169690_JPRB,0.05367370_JPRB,&
    &0.03671630_JPRB,0.00378148_JPRB,0.00290510_JPRB,0.00221076_JPRB,&
    &0.00142810_JPRB,0.00093527_JPRB,0.00031016_JPRB,0.00004363_JPRB/)
FRACREFAO( : ,4) = (/&
    &0.13054299_JPRB,0.16273800_JPRB,0.15874299_JPRB,0.14279599_JPRB,&
    &0.12674300_JPRB,0.09664900_JPRB,0.07462200_JPRB,0.05620080_JPRB,&
    &0.03789090_JPRB,0.00411690_JPRB,0.00322920_JPRB,0.00245036_JPRB,&
    &0.00178303_JPRB,0.00098595_JPRB,0.00040802_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,5) = (/&
    &0.12828299_JPRB,0.15824600_JPRB,0.15688400_JPRB,0.14449100_JPRB,&
    &0.12787800_JPRB,0.09517830_JPRB,0.07679350_JPRB,0.05890820_JPRB,&
    &0.03883570_JPRB,0.00442304_JPRB,0.00346796_JPRB,0.00255333_JPRB,&
    &0.00212519_JPRB,0.00116168_JPRB,0.00067065_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,6) = (/&
    &0.12649800_JPRB,0.15195100_JPRB,0.15646499_JPRB,0.14569700_JPRB,&
    &0.12669300_JPRB,0.09653520_JPRB,0.07887920_JPRB,0.06106920_JPRB,&
    &0.04043910_JPRB,0.00430390_JPRB,0.00364453_JPRB,0.00314360_JPRB,&
    &0.00203206_JPRB,0.00187787_JPRB,0.00067075_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,7) = (/&
    &0.12500300_JPRB,0.14460599_JPRB,0.15672199_JPRB,0.14724600_JPRB,&
    &0.11978900_JPRB,0.10190200_JPRB,0.08196710_JPRB,0.06315770_JPRB,&
    &0.04240100_JPRB,0.00433645_JPRB,0.00404097_JPRB,0.00329466_JPRB,&
    &0.00288491_JPRB,0.00187803_JPRB,0.00067093_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,8) = (/&
    &0.12317200_JPRB,0.14118700_JPRB,0.15242000_JPRB,0.13794300_JPRB,&
    &0.12119200_JPRB,0.10655400_JPRB,0.08808350_JPRB,0.06521370_JPRB,&
    &0.04505680_JPRB,0.00485949_JPRB,0.00477105_JPRB,0.00401468_JPRB,&
    &0.00288491_JPRB,0.00187786_JPRB,0.00067110_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,9) = (/&
    &0.10193600_JPRB,0.11693000_JPRB,0.13236099_JPRB,0.14053200_JPRB,&
    &0.13749801_JPRB,0.12193100_JPRB,0.10221000_JPRB,0.07448910_JPRB,&
    &0.05205320_JPRB,0.00572312_JPRB,0.00476882_JPRB,0.00403380_JPRB,&
    &0.00288871_JPRB,0.00187396_JPRB,0.00067218_JPRB,0.00010150_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB12_00
