      subroutine PHY_SISVAT_UBC(FlagRT,FlagAT,FlagCM,FlagCP)

!------------------------------------------------------------------------------+
!                                                         Sat 29-Jun-2013  MAR |
!     SubRoutine PHY_SISVAT_UBC provides Upper Boundary Conditions to          |
!                    SISVAT    (Soil                                           |
!                               Ice                                            |
!                               Snow                                           |
!                               Vegetation                                     |
!                               Atmosphere                                     |
!                               Transfer   Scheme)                             |
!                                                                              |
!                               USING DATA                                     |
!                                                                              |
!     Here DATA mimic the behaviour of non-active part of PHYsical package     |
!                                      (radiative transfert,                   |
!                                      (convective precipitation,              |
!                                      (stratiform precipitation,              |
!           and are generated by a Driver designed to test MARthusalem version |
!                                                       of SISVAT              |
!          Air Temperature, specific humidity and wind are provided as INPUT   |
!                                                      of PHYsical package     |
!                                                                              |
!     version 3.p.4.1 created by H. Gallee,               Fri  3-May-2013      |
!           Last Modification by H. Gallee,               Sat 29-Jun-2013      |
!                                                                              |
!------------------------------------------------------------------------------+


! Global  Variables
! =================

      use Mod_Real
      use Mod_PHY____grd
      use Mod_SISVAT_ctr
      use Mod_SISVAT_grd
      use Mod_SISVAT_kkl
      use Mod_SISVAT_gpt
      use Mod_PHY_RT_kkl
      use Mod_PHY_CM_kkl
      use Mod_PHY_AT_kkl


      logical                                    ::  FlagAT             !  Flag         (Turbulent Transfer)
      logical                                    ::  FlagCM             !  Flag         (Cloud Microphysics)
      logical                                    ::  FlagCP             !  Flag         (Convection Param. )
      logical                                    ::  FlagRT             !  Flag         (Radiative Transfer)


!     real(kind=real8),ALLOCATABLE ,dimension(:,:,:)  ::  LAI____xyn    ! Leaf Area Index              (Mosaic)  [m2/m2]
!     real(kind=real8),ALLOCATABLE ,dimension(:,:,:)  ::  GLF____xyn    ! Green Leaf Fraction          (Mosaic)      [-]


!     allocate  ( LAI____xyn(ixp1:mxpp,jyp1:mypp,mwp) )                 !  Leaf Area Index             (Mosaic)  [m2/m2]
!     allocate  ( GLF____xyn(ixp1:mxpp,jyp1:mypp,mwp) )                 !  Green Leaf Fraction         (Mosaic)      [-]






! Local   Variables
! =================

      integer  ::  i     ,j     ,n     ,ikp
      integer  ::  k




! UPPER BOUNDARY CONDITIONS (second term must be verified and modified if needed)
! =========================

        DO ikp = 1,kcolp

          i   = ii__AP(ikp)
          j   = jj__AP(ikp)

        IF (.NOT. FlagAT)                                           THEN
          DO k=1,mzp
          Kzh_AT(ikp,k)       =     1.35e-5           ! Turbulent Diffusion Coefficient for Scalars             [m2/s]
                                                      ! Air Viscosity
          ENDDO
        END IF

        IF (.NOT. FlagCM)                                           THEN
          SnowCM(ikp)         =     0.0               ! Snow  Accumulation (time t   )                        [m w.e.]
          SnobCM(ikp)         =     0.0               ! Snow  Accumulation (time t-dt, after  snow erosion)   [m w.e.]
          Sno0CM(ikp)         =     0.0               ! Snow  Accumulation (time t-dt, before snow erosion)   [m w.e.]
          RainCM(ikp)         =     0.0               ! Rain  Accumulation (time t   )                        [m w.e.]
          Rai0CM(ikp)         =     0.0               ! Rain  Accumulation (time t-dt)                        [m w.e.]
        END IF

        IF (.NOT. FlagRT)                                           THEN
          SWDsRT(ikp)         =     0.0               ! Surface ShrtWave Heat Flux (+)  (Downward)              [W/m2]
          LWDsRT(ikp)         =     0.0               ! Surface LongWave Heat Flux (+)  (Downward)              [W/m2]
          ClouRT(ikp)         =     0.0               ! Total Cloudiness above lowest Atmospheric Level            [-]
        END IF

          sst_SB(ikp)         =   271.2               ! Ocean     FORCING (SST)                                    [K]
          sif_SB(ikp)         =     0.0               ! Ocean     FORCING (Sea-Ice Fraction)                       [-]

        DO n=1,mwp
!         s_T_AO_xyn(i,j,n)   =   271.2               ! Ocean    COUPLING (SST)                                    [K]
!         s_T_AO    (ikp,n)   =  s_T_AO_xyn(i,j,n)    !
!         Alb_AO_xyn(i,j,n)   =     0.0               ! Ocean    COUPLING (Surface Albedo)                         [-]
!         Alb_AO    (ikp,n)   =  Alb_AO_xyn(i,j,n)    ! Ocean    COUPLING (Surface Albedo)                         [-]
!         LAI____xyn(i,j,n)   =     3.0               ! Leaf Area Index             (Mosaic)                   [m2/m2]
!         LAI0SV    (ikp,n)   =  LAI_SV_xyn(i,j,n)    !
          LAI0SV    (ikp,n)   =     3.0
!         GLF____xyn(i,j,n)   =     1.0               ! Green Leaf Fraction         (Mosaic)                       [-]
!         glf0SV    (ikp,n)   =  GLF_SV_xyn(i,j,n)    ! Green Leaf Frac.
          glf0SV    (ikp,n)   =     1.0               ! Green Leaf Frac.


!         s_T_AO_xyn(i,j,n)   =   271.2               ! Ocean    COUPLING (SST)
!         s_T_AO    (ikp,n)   =  s_T_AO_xyn(i,j,n)    !
        ENDDO


        ENDDO

      end subroutine PHY_SISVAT_UBC
