     module Mod_SISVAT_flx

!--------------------------------------------------------------------------+
!    module Mod_SISVAT_flx                            Wed 26-Jun-2013  MAR |
!    module Mod_SISVAT_flx  contains specific variables (and constants)    |
!           used by Soil/Ice Snow Vegetation Atmosphere Transfer Scheme    |
!                                                                          |
!     version 3.p.4.1 created by H. Gallee,           Fri  1-Feb-2013      |
!                    modified by H. Gallee,           Wed 26-Jun-2013      |
!                                                                          |
!--------------------------------------------------------------------------+



! General Variables
! =================

      use Mod_Real
      use Mod_SISVAT_dim


      IMPLICIT NONE


! SISVAT_flx    specific variables (and constants)
! ================================================

! OUTPUT for Stand Alone NetCDF File
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      real(kind=real8), SAVE, ALLOCATABLE, dimension(:,:)  ::  SOsoKL        ! Absorbed Solar Radiation
      real(kind=real8), SAVE, ALLOCATABLE, dimension(:,:)  ::  IRsoKL        ! Absorbed IR    Radiation
      real(kind=real8), SAVE, ALLOCATABLE, dimension(:,:)  ::  HSsoKL        ! Absorbed Sensible Heat Flux
      real(kind=real8), SAVE, ALLOCATABLE, dimension(:,:)  ::  HLsoKL        ! Absorbed Latent   Heat Flux
      real(kind=real8), SAVE, ALLOCATABLE, dimension(:,:)  ::  HLs_KL        ! Evaporation
      real(kind=real8), SAVE, ALLOCATABLE, dimension(:,:)  ::  HLv_KL        ! Transpiration



     end module Mod_SISVAT_flx
