!
! $Header$
!
MODULE microphys_mod

CONTAINS
!*******************************************************************

FUNCTION icefrac_lsc(temp, tmin, tmax, nexpo)
  IMPLICIT NONE
  !
  ! Compute the ice fraction 1-xliq (see e.g.
  ! Doutriaux-Boucher & Quaas 2004, section 2.2.)
  !
  ! (JBM 3/14)
  REAL :: icefrac_lsc ! ice fraction 
  REAL :: temp ! temperature
  REAL :: tmin ! if T < Tmin, the cloud is only made of water ice
  REAL :: tmax ! if T > Tmax, the cloud is only made of liquid water
  REAL :: nexpo ! controls the sharpness of the transition

  icefrac_lsc = 1.0 - (temp-tmin) / (tmax-tmin)
  icefrac_lsc = MIN(MAX(icefrac_lsc,0.0),1.0)
  icefrac_lsc = icefrac_lsc**nexpo

  RETURN
END FUNCTION icefrac_lsc

!*******************************************************************
!
END MODULE microphys_mod
