# This is a script in Bash.

# This script installs the source files of LMDZ 1D. Run this script
# from "libf".

set -xe

# cp --no-clobber phylmd/* phy1d:
cd phylmd
set +x
for my_file in *
  do
  if [[ ! -a ../phy1d/$my_file ]]
      then
#     cp $my_file ../phy1d
      cp -R $my_file ../phy1d 
  fi
done
set -x

cd ../phy1d

sed -i -e "/SUBROUTINE *convers_timesteps/,/END SUBROUTINE convers_timesteps/{
 /USE *phys_cal_mod/d
 /use *ioipsl/a\\
    USE phys_cal_mod
 s/ioget_mon_len(annee_ref,day_ref)/mth_len/
};/SUBROUTINE *phys_output_open/,/end *subroutine *phys_output_open/{
 /USE *ioipsl/a\\
  USE phys_cal_mod, only : hour
 /ymds2ju.*annee_ref.*zjulian/c\\
!!!      CALL ymds2ju(annee_ref, 1, idayref, 0.0, zjulian)       !jyg \\
! correction pour l heure initiale                               !jyg \\
!                                                                !jyg \\
      CALL ymds2ju(annee_ref, 1, idayref, hour, zjulian)         !jyg
}" phys_output_mod.F90

 ln -s ../dyn3d/mod_const_mpi.F90 .
 ln -sf ../dyn3d_common/infotrac.F90 .
 ln -s ../dyn3d/conf_gcm.F .
 ln -s ../dyn3d_common/pres2lev* .
 ln -s ../dyn3d_common/control_mod.F90 .
 ln -sf ../dyn3d_common/q_sat.F .
 ln -s ../dyn3d_common/disvert.F90 .
