!
! $Id: ini_undefSTD.F 1921 2013-12-20 09:04:40Z fairhead $
!

      SUBROUTINE ini_undefSTD(itap,itapm1)
      USE dimphy
      USE phys_state_var_mod ! Variables sauvegardees de la physique
      USE phys_cal_mod, only : mth_len
      IMPLICIT none
      include "clesphys.h"
c
c====================================================================
c
c I. Musat : 09.2004
c
c Initialisation - a des frequences differentes : 
c
c 1) des variables moyennees sur la journee "day" ou sur le mois "mth"
c    calculees a partir des valeurs "instantannees" de la physique
c
c 2) des variables moyennes mensuelles "NMC" calculees a partir des val.
c    toutes les 6 heures
c
c nout=1 !var. journaliere "day" moyenne sur tous les pas de temps
c              ! de la physique
c nout=2 !var. mensuelle "mth" moyennee sur tous les pas de temps
c              ! de la physique
c nout=3 !var. mensuelle "NMC" moyennee toutes les 6heures
c
c NB: mettre "inst(X)" dans le write_hist*NMC.h !
c====================================================================
c
cym #include "dimensions.h"
cym      integer jjmp1
cym      parameter (jjmp1=jjm+1-1/jjm)
cym #include "dimphy.h"
c variables Input/Output
c     INTEGER nlevSTD, klevSTD, itap
      INTEGER itap, itapm1
c     PARAMETER(klevSTD=17)
c     REAL dtime
c
c variables locales
c     INTEGER i, k, nout, n
      INTEGER i, k, n
c     PARAMETER(nout=3) !nout=1 day/nout=2 mth/nout=3 NMC
c     REAL freq_outNMC(nout)
      REAL un_jour
      PARAMETER(un_jour=86400.)
c
c variables Output
c     REAL tnondef(klon,klevSTD,nout)
c     REAL tsumSTD(klon,klevSTD,nout)
c
      DO n=1, nout
c
c initialisation variables en debut du mois, de la journee ou des 6h
c
       IF(n.EQ.1.AND.itap-itapm1.EQ.1.OR.
     &n.GT.1.AND.MOD(itap,NINT(freq_outNMC(n)/dtime)).EQ.1) THEN
c       print*,'ini_undefSTD n itap',n,itap
        DO k=1, nlevSTD
         DO i=1, klon
          tnondef(i,k,n)=0.
          tsumSTD(i,k,n)=0.
          usumSTD(i,k,n)=0.
          vsumSTD(i,k,n)=0.
          wsumSTD(i,k,n)=0.
          phisumSTD(i,k,n)=0.
          qsumSTD(i,k,n)=0.
          rhsumSTD(i,k,n)=0.
          uvsumSTD(i,k,n)=0.
          vqsumSTD(i,k,n)=0.
          vTsumSTD(i,k,n)=0.
          wqsumSTD(i,k,n)=0.
          vphisumSTD(i,k,n)=0.
          wTsumSTD(i,k,n)=0.
          u2sumSTD(i,k,n)=0.
          v2sumSTD(i,k,n)=0.
          T2sumSTD(i,k,n)=0.
          O3sumSTD(i,k,n)=0.
          O3daysumSTD(i,k,n)=0.
         ENDDO !i
        ENDDO !k
       ENDIF !
      ENDDO !n
      RETURN
      END  
