MODULE vlz_mod

  REAL,POINTER,SAVE :: wq(:,:)
  REAL,POINTER,SAVE :: dzq(:,:)
  REAL,POINTER,SAVE :: dzqw(:,:)
  REAL,POINTER,SAVE :: adzqw(:,:)
  
CONTAINS

  SUBROUTINE vlz_allocate
  USE bands
  USE allocate_field_mod
  USE parallel_lmdz
  USE infotrac
  USE dimensions_mod
  IMPLICIT NONE
  TYPE(distrib),POINTER :: d
    
    d=>distrib_vanleer
    CALL allocate_u(wq,llm+1,d)
    CALL allocate_u(dzq,llm,d)
    CALL allocate_u(dzqw,llm,d)
    CALL allocate_u(adzqw,llm,d)

  END SUBROUTINE vlz_allocate
  
  SUBROUTINE vlz_switch_vanleer(dist)
  USE allocate_field_mod
  USE bands
  USE parallel_lmdz
  IMPLICIT NONE
    TYPE(distrib),INTENT(IN) :: dist
  
    CALL switch_u(wq,distrib_vanleer,dist)
    CALL switch_u(dzq,distrib_vanleer,dist)
    CALL switch_u(dzqw,distrib_vanleer,dist)
    CALL switch_u(adzqw,distrib_vanleer,dist)

  END SUBROUTINE vlz_switch_vanleer  
  
END MODULE vlz_mod  
