MODULE phys_output_ctrlout_mod

  USE phys_output_var_mod
  USE indice_sol_mod
  USE aero_mod, only : naero_spc,name_aero



  IMPLICIT NONE
      INTEGER, PRIVATE :: i

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! Definition pour chaque variable du niveau d ecriture dans chaque fichier,
!! de son nom, de sa description, de son unité et du type d'écriture.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!/ histmth, histday, histhf, histins /),'!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  CHARACTER(len=20), dimension(nfiles) :: TEF = type_ecri_files

!!! Comosantes de la coordonnee sigma-hybride
!!! Ap et Bp
  TYPE(ctrl_out), SAVE :: o_Ahyb = ctrl_out((/ 1, 1, 1, 1, 1, 1, 11, 11, 11 /), &
	'Ap', '', '', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_Bhyb = ctrl_out((/ 1, 1, 1, 1, 1, 1, 11, 11, 11 /), &
	'Bp', '', '', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_Alt = ctrl_out((/ 1, 1, 1, 1, 1, 1, 11, 11, 11 /), &
	'Alt', '', '', (/ ('', i=1, 9) /))

!!! 1D
  TYPE(ctrl_out), SAVE :: o_phis = ctrl_out((/ 1, 1, 10, 5, 1, 1, 11, 11, 11 /), &
	'phis', 'Surface geop.height', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_aire = ctrl_out((/ 1, 1, 10,  10, 1, 1, 11, 11, 11 /), &
	'aire', 'Grid area', '-', (/ 'once', 'once', 'once', 'once', 'once', 'once', &
                                     'once', 'once', 'once' /))
  TYPE(ctrl_out), SAVE :: o_contfracATM = ctrl_out((/ 10, 1,  1, 10, 10, 10, 11, 11, 11 /), &
	'contfracATM', '% sfce ter+lic', '-', &
       (/ 'once', 'once', 'once', 'once', 'once', 'once', 'once', 'once', 'once' /)) 
  TYPE(ctrl_out), SAVE :: o_contfracOR = ctrl_out((/ 10, 1,  1, 10, 10, 10, 11, 11, 11 /), &
	'contfracOR', '% sfce terre OR', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_aireTER = ctrl_out((/ 10, 10, 1, 10, 10, 10, 11, 11, 11 /), &
	'aireTER', 'Grid area CONT', '-', (/ ('', i=1, 9) /))

!!! 2D
  TYPE(ctrl_out), SAVE :: o_flat = ctrl_out((/ 5, 1, 10, 10, 5, 10, 11, 11, 11 /), &
	'flat', 'Latent heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_slp = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'slp', 'Sea Level Pressure', 'Pa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tsol = ctrl_out((/ 1, 1, 1, 5, 10, 10, 11, 11, 11 /), &
	'tsol', 'Surface Temperature', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_t2m = ctrl_out((/ 1, 1, 1, 5, 10, 10, 11, 11, 11 /), &
	't2m', 'Temperature 2m', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_t2m_min = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	't2m_min', 'Temp 2m min', 'K', &
      (/ "t_min(X)", "t_min(X)", "t_min(X)", "t_min(X)", "t_min(X)", "t_min(X)", "t_min(X)", "t_min(X)", "t_min(X)" /))
  TYPE(ctrl_out), SAVE :: o_t2m_max = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	't2m_max', 'Temp 2m max', 'K', &
      (/ "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", &
         "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)" /))

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_t2m_srf = (/ &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	't2m_ter', "Temp 2m "//clnsurf(1), "K", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	't2m_lic', "Temp 2m "//clnsurf(2), "K", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	't2m_oce', "Temp 2m "//clnsurf(3), "K", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	't2m_sic', "Temp 2m "//clnsurf(4), "K", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE :: o_wind10m = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'wind10m', '10-m wind speed', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wind10max = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'wind10max', '10m wind speed max', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sicf = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'sicf', 'Sea-ice fraction', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_q2m = ctrl_out((/ 1, 1, 1, 5, 10, 10, 11, 11, 11 /), &
	'q2m', 'Specific humidity 2m', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ustar = ctrl_out((/ 1, 1, 1, 5, 10, 10, 11, 11, 11 /), &
	'ustar', 'Friction velocity', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_u10m = ctrl_out((/ 1, 1, 1, 5, 10, 10, 11, 11, 11 /), &
	'u10m', 'Vent zonal 10m', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_v10m = ctrl_out((/ 1, 1, 1, 5, 10, 10, 11, 11, 11 /), &
	'v10m', 'Vent meridien 10m', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_psol = ctrl_out((/ 1, 1, 1, 5, 10, 10, 11, 11, 11 /), &
	'psol', 'Surface Pressure', 'Pa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_qsurf = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'qsurf', 'Surface Air humidity', 'kg/kg', (/ ('', i=1, 9) /))

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_ustar_srf     = (/ &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'ustar_ter', &
      "Friction velocity "//clnsurf(1),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'ustar_lic', &
      "Friction velocity "//clnsurf(2),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'ustar_oce', &
      "Friction velocity "//clnsurf(3),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'ustar_sic', &
      "Friction velocity "//clnsurf(4),"m/s", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(5) :: o_wstar         = (/ &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'wstar_ter', &
      "Friction velocity "//clnsurf(1),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'wstar_lic', &
      "Friction velocity "//clnsurf(2),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'wstar_oce', &
      "Friction velocity "//clnsurf(3),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'wstar_sic', &
      "Friction velocity "//clnsurf(4),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 5, 5, 10, 10, 10, 10, 11, 11, 11 /),'wstar', &
      "w* convective velocity "//clnsurf(4),"m/s", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_u10m_srf     = (/ &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'u10m_ter', &
      "Vent Zonal 10m "//clnsurf(1),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'u10m_lic', &
      "Vent Zonal 10m "//clnsurf(2),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'u10m_oce', &
      "Vent Zonal 10m "//clnsurf(3),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'u10m_sic', &
      "Vent Zonal 10m "//clnsurf(4),"m/s", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_v10m_srf     = (/ &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'v10m_ter', &
      "Vent meredien 10m "//clnsurf(1),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'v10m_lic', &
      "Vent meredien 10m "//clnsurf(2),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'v10m_oce', &
      "Vent meredien 10m "//clnsurf(3),"m/s", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 6, 10, 10, 10, 10, 11, 11, 11 /),'v10m_sic', &
      "Vent meredien 10m "//clnsurf(4),"m/s", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE :: o_qsol = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'qsol', 'Soil watter content', 'mm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ndayrain = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ndayrain', 'Number of dayrain(liq+sol)', '-', &
      (/ "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)" /))
  TYPE(ctrl_out), SAVE :: o_precip = ctrl_out((/ 1, 1, 1, 10, 5, 10, 11, 11, 11 /), &
	'precip', 'Precip Totale liq+sol', 'kg/(s*m2)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_plul = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'plul', 'Large-scale Precip.', 'kg/(s*m2)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_pluc = ctrl_out((/ 1, 1, 1, 10, 5, 10, 11, 11, 11 /), &
	'pluc', 'Convective Precip.', 'kg/(s*m2)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_snow = ctrl_out((/ 1, 1, 10, 10, 5, 10, 11, 11, 11 /), &
	'snow', 'Snow fall', 'kg/(s*m2)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_evap = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'evap', 'Evaporat', 'kg/(s*m2)', (/ ('', i=1, 9) /))

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_evap_srf     = (/ &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'evap_ter', &
      "evaporation at surface "//clnsurf(1),"kg/(s*m2)", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'evap_lic', &
      "evaporation at surface "//clnsurf(2),"kg/(s*m2)", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'evap_oce', &
      "evaporation at surface "//clnsurf(3),"kg/(s*m2)", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'evap_sic', &
      "evaporation at surface "//clnsurf(4),"kg/(s*m2)", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE :: o_msnow = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'msnow', 'Surface snow amount', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_fsnow = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'fsnow', 'Surface snow area fraction', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tops = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'tops', 'Solar rad. at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tops0 = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'tops0', 'CS Solar rad. at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_topl = ctrl_out((/ 1, 1, 10, 5, 10, 10, 11, 11, 11 /), &
	'topl', 'IR rad. at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_topl0 = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'topl0', 'IR rad. at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWupTOA = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWupTOA', 'SWup at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWupTOAclr = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWupTOAclr', 'SWup clear sky at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWdnTOA = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWdnTOA', 'SWdn at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWdnTOAclr = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWdnTOAclr', 'SWdn clear sky at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_nettop = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /), &
	'nettop', 'Net dn radiatif flux at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWup200 = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWup200', 'SWup at 200mb', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWup200clr = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWup200clr', 'SWup clear sky at 200mb', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWdn200 = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWdn200', 'SWdn at 200mb', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWdn200clr = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'SWdn200clr', 'SWdn clear sky at 200mb', 'W/m2', (/ ('', i=1, 9) /))

  ! arajouter
  !  type(ctrl_out),save :: o_LWupTOA     = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /),'LWupTOA', &
  !	(/ ('', i=1, 9) /))
  !  type(ctrl_out),save :: o_LWupTOAclr  = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /),'LWupTOAclr', &
  !	(/ ('', i=1, 9) /))
  !  type(ctrl_out),save :: o_LWdnTOA     = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /),'LWdnTOA', &
  !	(/ ('', i=1, 9) /))
  !  type(ctrl_out),save :: o_LWdnTOAclr  = ctrl_out((/ 1, 4, 10, 10, 10, 10, 11, 11, 11 /),'LWdnTOAclr', &
  !	(/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWup200 = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'LWup200', 'LWup at 200mb', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWup200clr = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'LWup200clr', 'LWup clear sky at 200mb', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWdn200 = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'LWdn200', 'LWdn at 200mb', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWdn200clr = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'LWdn200clr', 'LWdn clear sky at 200mb', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sols = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'sols', 'Solar rad. at surf.', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sols0 = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'sols0', 'Solar rad. at surf.', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_soll = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'soll', 'IR rad. at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_soll0 = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'soll0', 'IR rad. at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_radsol = ctrl_out((/ 1, 7, 10, 10, 10, 10, 11, 11, 11 /), &
	'radsol', 'Rayonnement au sol', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWupSFC = ctrl_out((/ 1, 4, 10, 10, 5, 10, 11, 11, 11 /), &
	'SWupSFC', 'SWup at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWupSFCclr = ctrl_out((/ 1, 4, 10, 10, 5, 10, 11, 11, 11 /), &
	'SWupSFCclr', 'SWup clear sky at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWdnSFC = ctrl_out((/ 1, 1, 10, 10, 5, 10, 11, 11, 11 /), &
	'SWdnSFC', 'SWdn at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWdnSFCclr = ctrl_out((/ 1, 4, 10, 10, 5, 10, 11, 11, 11 /), &
	'SWdnSFCclr', 'SWdn clear sky at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWupSFC = ctrl_out((/ 1, 4, 10, 10, 5, 10, 11, 11, 11 /), &
	'LWupSFC', 'Upwd. IR rad. at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWupSFCclr = ctrl_out((/ 1, 4, 10, 10, 5, 10, 11, 11, 11 /), &
	'LWupSFCclr', 'CS Upwd. IR rad. at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWdnSFC = ctrl_out((/ 1, 4, 10, 10, 5, 10, 11, 11, 11 /), &
	'LWdnSFC', 'Down. IR rad. at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWdnSFCclr = ctrl_out((/ 1, 4, 10, 10, 5, 10, 11, 11, 11 /), &
	'LWdnSFCclr', 'Down. CS IR rad. at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_bils = ctrl_out((/ 1, 2, 10, 5, 10, 10, 11, 11, 11 /), &
	'bils', 'Surf. total heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_bils_tke = ctrl_out((/ 1, 2, 10, 5, 10, 10, 11, 11, 11 /), &
	'bils_tke', 'Surf. total heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_bils_diss = ctrl_out((/ 1, 2, 10, 5, 10, 10, 11, 11, 11 /), &
	'bils_diss', 'Surf. total heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_bils_ec = ctrl_out((/ 1, 2, 10, 5, 10, 10, 11, 11, 11 /), &
	'bils_ec', 'Surf. total heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_bils_kinetic = ctrl_out((/ 1, 2, 10, 5, 10, 10, 11, 11, 11 /), &
	'bils_kinetic', 'Surf. total heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_bils_enthalp = ctrl_out((/ 1, 2, 10, 5, 10, 10, 11, 11, 11 /), &
	'bils_enthalp', 'Surf. total heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_bils_latent = ctrl_out((/ 1, 2, 10, 5, 10, 10, 11, 11, 11 /), &
	'bils_latent', 'Surf. total heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sens = ctrl_out((/ 1, 1, 10, 10, 5, 10, 11, 11, 11 /), &
	'sens', 'Sensible heat flux', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_fder = ctrl_out((/ 1, 2, 10, 10, 10, 10, 11, 11, 11 /), &
	'fder', 'Heat flux derivation', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ffonte = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ffonte', 'Thermal flux for snow melting', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_fqcalving = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'fqcalving', 'Ice Calving', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_fqfonte = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'fqfonte', 'Land ice melt', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_taux = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'taux', 'Zonal wind stress', 'Pa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tauy = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tauy', 'Meridional wind stress', 'Pa', (/ ('', i=1, 9) /))

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_taux_srf = (/           &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'taux_ter',             &
      "Zonal wind stress"//clnsurf(1), "Pa", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'taux_lic',             &
      "Zonal wind stress"//clnsurf(2), "Pa", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'taux_oce',             &
      "Zonal wind stress"//clnsurf(3), "Pa", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'taux_sic',             &
      "Zonal wind stress"//clnsurf(4), "Pa", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_tauy_srf     = (/             &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tauy_ter',                   &
      "Meridional wind stress "//clnsurf(1),"Pa", (/ ('', i=1, 9) /)),  &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tauy_lic',                   &
      "Meridional wind stress "//clnsurf(2),"Pa", (/ ('', i=1, 9) /)),  &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tauy_oce',                   &
      "Meridional wind stress "//clnsurf(3),"Pa", (/ ('', i=1, 9) /)),  &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tauy_sic',                   &
      "Meridional wind stress "//clnsurf(4),"Pa", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_pourc_srf    = (/ &
      ctrl_out((/ 1, 7, 10, 10, 10, 10, 11, 11, 11 /),'pourc_ter',      &
      "% "//clnsurf(1),"%", (/ ('', i=1, 9) /)),            &
      ctrl_out((/ 1, 7, 10, 10, 10, 10, 11, 11, 11 /),'pourc_lic',      &
      "% "//clnsurf(2),"%", (/ ('', i=1, 9) /)),            &
      ctrl_out((/ 1, 7, 10, 10, 10, 10, 11, 11, 11 /),'pourc_oce',      &
      "% "//clnsurf(3),"%", (/ ('', i=1, 9) /)),            &
      ctrl_out((/ 1, 7, 10, 10, 10, 10, 11, 11, 11 /),'pourc_sic',      &
      "% "//clnsurf(4),"%", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_fract_srf    = (/ &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'fract_ter',      &
      "Fraction "//clnsurf(1),"1", (/ ('', i=1, 9) /)),     &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'fract_lic',      &
      "Fraction "//clnsurf(2),"1", (/ ('', i=1, 9) /)),     &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'fract_oce',      &
      "Fraction "//clnsurf(3),"1", (/ ('', i=1, 9) /)),     &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'fract_sic',      &
      "Fraction "//clnsurf(4),"1", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_tsol_srf     = (/ &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tsol_ter',       &
      "Temperature "//clnsurf(1),"K", (/ ('', i=1, 9) /)),  &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tsol_lic',       &
      "Temperature "//clnsurf(2),"K", (/ ('', i=1, 9) /)),  &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tsol_oce',       &
      "Temperature "//clnsurf(3),"K", (/ ('', i=1, 9) /)),  &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'tsol_sic',       &
      "Temperature "//clnsurf(4),"K", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_evappot_srf  = (/ &
      ctrl_out((/ 1, 6, 10, 10, 10, 10, 11, 11, 11 /),'evappot_ter',    &
      "Temperature"//clnsurf(1),"K", (/ ('', i=1, 9) /)),   &
      ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /),'evappot_lic',    &
      "Temperature"//clnsurf(2),"K", (/ ('', i=1, 9) /)),   &
      ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /),'evappot_oce',    &
      "Temperature"//clnsurf(3),"K", (/ ('', i=1, 9) /)),   &
      ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /),'evappot_sic',    &
      "Temperature"//clnsurf(4),"K", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_sens_srf     = (/          &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'sens_ter',                 &
      "Sensible heat flux "//clnsurf(1),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'sens_lic',                 &
      "Sensible heat flux "//clnsurf(2),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'sens_oce',                 &
      "Sensible heat flux "//clnsurf(3),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'sens_sic',                 &
      "Sensible heat flux "//clnsurf(4),"W/m2", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_lat_srf      = (/        &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'lat_ter',                &
      "Latent heat flux "//clnsurf(1),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'lat_lic',                &
      "Latent heat flux "//clnsurf(2),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'lat_oce',                &
      "Latent heat flux "//clnsurf(3),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 6, 10, 7, 10, 10, 11, 11, 11 /),'lat_sic',                &
      "Latent heat flux "//clnsurf(4),"W/m2", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_flw_srf      = (/ &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'flw_ter',       &
      "LW "//clnsurf(1),"W/m2", (/ ('', i=1, 9) /)),        &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'flw_lic',       &
      "LW "//clnsurf(2),"W/m2", (/ ('', i=1, 9) /)),        &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'flw_oce',       &
      "LW "//clnsurf(3),"W/m2", (/ ('', i=1, 9) /)),        &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'flw_sic',       &
      "LW "//clnsurf(4),"W/m2", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_fsw_srf      = (/ &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'fsw_ter',       &
      "SW "//clnsurf(1),"W/m2", (/ ('', i=1, 9) /)),        &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'fsw_lic',       &
      "SW "//clnsurf(2),"W/m2", (/ ('', i=1, 9) /)),        &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'fsw_oce',       &
      "SW "//clnsurf(3),"W/m2", (/ ('', i=1, 9) /)),        &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'fsw_sic',       &
      "SW "//clnsurf(4),"W/m2", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_wbils_srf    = (/ &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbils_ter',     &
      "Bilan sol "//clnsurf(1),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbils_lic',     &
      "Bilan sol "//clnsurf(2),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbils_oce',     &
      "Bilan sol "//clnsurf(3),"W/m2", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbils_sic',     &
      "Bilan sol "//clnsurf(4),"W/m2", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_wbilo_srf    = (/      &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbilo_ter',          &
      "Bilan eau "//clnsurf(1),"kg/(m2*s)", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbilo_lic',          &
      "Bilan eau "//clnsurf(2),"kg/(m2*s)", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbilo_oce',          &
      "Bilan eau "//clnsurf(3),"kg/(m2*s)", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'wbilo_sic',          &
      "Bilan eau "//clnsurf(4),"kg/(m2*s)", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE :: o_cdrm = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'cdrm', 'Momentum drag coef.', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cdrh = ctrl_out((/ 1, 10, 10, 7, 10, 10, 11, 11, 11 /), &
	'cdrh', 'Heat drag coef.', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldl = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldl', 'Low-level cloudiness', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldm = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldm', 'Mid-level cloudiness', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldh = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldh', 'High-level cloudiness', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldt = ctrl_out((/ 1, 1, 2, 10, 5, 10, 11, 11, 11 /), &
	'cldt', 'Total cloudiness', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldq = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldq', 'Cloud liquid water path', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lwp = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'lwp', 'Cloud water path', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_iwp = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'iwp', 'Cloud ice water path', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ue = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ue', 'Zonal energy transport', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ve = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	've', 'Merid energy transport', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_uq = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'uq', 'Zonal humidity transport', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_vq = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'vq', 'Merid humidity transport', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cape = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'cape', 'Conv avlbl pot ener', 'J/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_pbase = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'pbase', 'Cld base pressure', 'Pa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ptop = ctrl_out((/ 1, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'ptop', 'Cld top pressure', 'Pa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_fbase = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'fbase', 'Cld base mass flux', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_plcl = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'plcl', 'Lifting Condensation Level', 'hPa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_plfc = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'plfc', 'Level of Free Convection', 'hPa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wbeff = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'wbeff', 'Conv. updraft velocity at LFC (<100)', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_prw = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'prw', 'Precipitable water', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_s_pblh = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	's_pblh', 'Boundary Layer Height', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_s_pblt = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	's_pblt', 't at Boundary Layer Height', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_s_lcl = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	's_lcl', 'Condensation level', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_s_therm = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	's_therm', 'Exces du thermique', 'K', (/ ('', i=1, 9) /))
  !IM : Les champs suivants (s_capCL, s_oliqCL, s_cteiCL, s_trmb1, s_trmb2, s_trmb3) ne sont pas definis dans HBTM.F
  ! type(ctrl_out),save :: o_s_capCL      = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'s_capCL', &
!	(/ ('', i=1, 9) /))
  ! type(ctrl_out),save :: o_s_oliqCL     = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'s_oliqCL', &
!	(/ ('', i=1, 9) /))
  ! type(ctrl_out),save :: o_s_cteiCL     = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'s_cteiCL', &
!	(/ ('', i=1, 9) /))
  ! type(ctrl_out),save :: o_s_trmb1      = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'s_trmb1', &
!	(/ ('', i=1, 9) /))
  ! type(ctrl_out),save :: o_s_trmb2      = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'s_trmb2', &
!	(/ ('', i=1, 9) /))
  ! type(ctrl_out),save :: o_s_trmb3      = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /),'s_trmb3', &
	!(/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_slab_bils = ctrl_out((/ 1, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'slab_bils_oce', 'Bilan au sol sur ocean slab', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ale_bl = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'ale_bl', 'ALE BL', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alp_bl = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp_bl', 'ALP BL', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ale_wk = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'ale_wk', 'ALE WK', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alp_wk = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp_wk', 'ALP WK', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ale = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'ale', 'ALE', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alp = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp', 'ALP', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cin = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'cin', 'Convective INhibition', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wape = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'wape', '', '', (/ ('', i=1, 9) /))

!!! nrlmd le 10/04/2012

!-------Spectre de thermiques de type 2 au LCL
  TYPE(ctrl_out), SAVE :: o_n2 = ctrl_out((/ 1, 1, 1, 6, 10, 10, 11, 11, 11 /), &
	'n2', 'Nombre de panaches de type 2', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_s2 = ctrl_out((/ 1, 1, 1, 6, 10, 10, 11, 11, 11 /), &
	's2', 'Surface moyenne des panaches de type 2', 'm2', (/ ('', i=1, 9) /))
                                                                             
!-------Déclenchement stochastique                                           
  TYPE(ctrl_out), SAVE :: o_proba_notrig = ctrl_out((/ 1, 1, 1, 6, 10, 10, 11, 11, 11 /), &
	'proba_notrig', &
                         'Probabilité de non-déclenchement', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_random_notrig = ctrl_out((/ 1, 1, 1, 6, 10, 10, 11, 11, 11 /), &
	'random_notrig', &
                         'Tirage aléatoire de non-déclenchement', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ale_bl_stat = ctrl_out((/ 1, 1, 1, 6, 10, 10, 11, 11, 11 /), &
	'ale_bl_stat', &
       'ALE_BL_STAT', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ale_bl_trig = ctrl_out((/ 1, 1, 1, 6, 10, 10, 11, 11, 11 /), &
	'ale_bl_trig', &
       'ALE_BL_STAT + Condition P>Pseuil', 'm2/s2', (/ ('', i=1, 9) /))

!-------Fermeture statistique
  TYPE(ctrl_out), SAVE :: o_alp_bl_det = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp_bl_det', 'ALP_BL_DET', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alp_bl_fluct_m = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp_bl_fluct_m', 'ALP_BL_FLUCT_M', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alp_bl_fluct_tke = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp_bl_fluct_tke', 'ALP_BL_FLUCT_TKE', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alp_bl_conv = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp_bl_conv', 'ALP_BL_CONV', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alp_bl_stat = ctrl_out((/ 1, 1, 1, 10, 10, 10, 11, 11, 11 /), &
	'alp_bl_stat', 'ALP_BL_STAT', 'W/m2', (/ ('', i=1, 9) /))

!!! fin nrlmd le 10/04/2012

  ! Champs interpolles sur des niveaux de pression ??? a faire correctement

  TYPE(ctrl_out), SAVE, DIMENSION(7) :: o_uSTDlevs     = (/                    &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'u850', "Zonal wind 1hPa", "m/s",     &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'u700', "Zonal wind 2hPa", "m/s",     &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'u500', "Zonal wind 3hPa", "m/s",     &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'u200', "Zonal wind 4hPa", "m/s",     &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'u100', "Zonal wind 5hPa", "m/s",     &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'u50', "Zonal wind 6hPa", "m/s",     &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'u10', "Zonal wind 7hPa", "m/s",     &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(7) :: o_vSTDlevs     = (/                     &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'v850', "Meridional wind 1hPa", "m/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)),  &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'v700', "Meridional wind 2hPa", "m/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)),  &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'v500', "Meridional wind 3hPa", "m/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)),  &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'v200', "Meridional wind 4hPa", "m/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)),  &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'v100', "Meridional wind 5hPa", "m/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)),  &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'v50', "Meridional wind 6hPa", "m/s",  &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)),  &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'v10', "Meridional wind 7hPa", "m/s",  &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(7) :: o_wSTDlevs     = (/                    &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'w850', "Vertical wind 1hPa", "Pa/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'w700', "Vertical wind 2hPa", "Pa/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'w500', "Vertical wind 3hPa", "Pa/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'w200', "Vertical wind 4hPa", "Pa/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'w100', "Vertical wind 5hPa", "Pa/s", &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'w50', "Vertical wind 6hPa", "Pa/s",  &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'w10', "Vertical wind 7hPa", "Pa/s",  &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(7) :: o_tSTDlevs     = (/                    &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'t850', "Temperature 1hPa", "K",      &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'t700', "Temperature 2hPa", "K",      &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'t500', "Temperature 3hPa", "K",      &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'t200', "Temperature 4hPa", "K",      &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'t100', "Temperature 5hPa", "K",      &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'t50',  "Temperature 6hPa", "K",      &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'t10',  "Temperature 7hPa", "K",      &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(7) :: o_qSTDlevs     = (/                             &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'q850', "Specific humidity 1hPa", &
      "kg/kg", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'q700', "Specific humidity 2hPa", &
      "kg/kg", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'q500', "Specific humidity 3hPa", &
      "kg/kg", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'q200', "Specific humidity 4hPa", &
      "kg/kg", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'q100', "Specific humidity 5hPa", &
      "kg/kg", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'q50', "Specific humidity 6hPa",  &
      "kg/kg", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'q10', "Specific humidity 7hPa", &
      "kg/kg", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(7) :: o_zSTDlevs   = (/                           &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'z850', "Geopotential height 1hPa",        &
      "m", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'z700', "Geopotential height 2hPa",        &
      "m", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'z500', "Geopotential height 3hPa",        &
      "m", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'z200', "Geopotential height 4hPa",        &
      "m", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'z100', "Geopotential height 5hPa",        &
      "m", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'z50', "Geopotential height 6hPa",         &
      "m", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)), &
      ctrl_out((/ 1, 7, 7, 10, 10, 10, 11, 11, 11 /),'z10', "Geopotential height 7hPa",         &
      "m", (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /)) /)

  TYPE(ctrl_out), SAVE :: o_t_oce_sic = ctrl_out((/ 1, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	't_oce_sic', 'Temp mixte oce-sic', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_weakinv = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'weakinv', 'Weak inversion', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dthmin = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'dthmin', 'dTheta mini', 'K/m', (/ ('', i=1, 9) /))

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_u10_srf      = (/ &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'u10_ter', "", "", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'u10_lic', "", "", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'u10_oce', "", "", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'u10_sic', "", "", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_v10_srf      = (/ &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'v10_ter', "", "", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'v10_lic', "", "", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'v10_oce', "", "", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'v10_sic', "", "", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE :: o_cldtau = ctrl_out((/ 10, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldtau', 'Cloud optical thickness', '1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldemi = ctrl_out((/ 10, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldemi', 'Cloud optical emissivity', '1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rh2m = ctrl_out((/ 5, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'rh2m', 'Relative humidity at 2m', '%', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rh2m_min = ctrl_out((/ 10, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'rh2m_min', 'Min Relative humidity at 2m', '%',                        &
      (/ 't_min(X)', 't_min(X)', 't_min(X)', 't_min(X)', 't_min(X)', 't_min(X)', 't_min(X)', 't_min(X)', 't_min(X)' /))
  TYPE(ctrl_out), SAVE :: o_rh2m_max = ctrl_out((/ 10, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'rh2m_max', 'Max Relative humidity at 2m', '%',                        &
      (/ 't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)', &
         't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)' /))
  TYPE(ctrl_out), SAVE :: o_qsat2m = ctrl_out((/ 10, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'qsat2m', 'Saturant humidity at 2m', '%', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tpot = ctrl_out((/ 10, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'tpot', 'Surface air potential temperature', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tpote = ctrl_out((/ 10, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'tpote', &
      'Surface air equivalent potential temperature', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tke = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tke ', 'TKE', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tke_max = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tke_max', 'TKE max', 'm2/s2',                                        &
      (/ 't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)', &
         't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)' /))

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_tke_srf      = (/             &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_ter',       &
      "Max Turb. Kinetic Energy "//clnsurf(1),"-", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_lic',       &
      "Max Turb. Kinetic Energy "//clnsurf(2),"-", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_oce',       &
      "Max Turb. Kinetic Energy "//clnsurf(3),"-", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_sic',       &
      "Max Turb. Kinetic Energy "//clnsurf(4),"-", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_tke_max_srf  = (/                          &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_max_ter',                &
      "Max Turb. Kinetic Energy "//clnsurf(1),"-",                                   &
      (/ "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", &
         "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)" /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_max_lic',                &
      "Max Turb. Kinetic Energy "//clnsurf(2),"-",                                   &
      (/ "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", &
         "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)" /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_max_oce',                &
      "Max Turb. Kinetic Energy "//clnsurf(3),"-",                                   &
      (/ "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", &
         "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)" /)), &
      ctrl_out((/ 10, 4, 10, 10, 10, 10, 11, 11, 11 /),'tke_max_sic',                &
      "Max Turb. Kinetic Energy "//clnsurf(4),"-",                                   &
      (/ "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", &
         "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)" /)) /)

  TYPE(ctrl_out), SAVE :: o_kz = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'kz', 'Kz melange', 'm2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_kz_max = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'kz_max', 'Kz melange max', 'm2/s',                                  &
      (/ 't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)', 't_max(X)', &
         't_max(X)', "t_max(X)", "t_max(X)", "t_max(X)" /))
  TYPE(ctrl_out), SAVE :: o_SWnetOR = ctrl_out((/ 10, 10, 2, 10, 10, 10, 11, 11, 11 /), &
	'SWnetOR', 'Sfce net SW radiation OR', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_SWdownOR = ctrl_out((/ 10, 10, 2, 10, 10, 10, 11, 11, 11 /), &
	'SWdownOR', 'Sfce incident SW radiation OR', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_LWdownOR = ctrl_out((/ 10, 10, 2, 10, 10, 10, 11, 11, 11 /), &
	'LWdownOR', 'Sfce incident LW radiation OR', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_snowl = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'snowl', 'Solid Large-scale Precip.', 'kg/(m2*s)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cape_max = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'cape_max', 'CAPE max.', 'J/kg',                                       &
      (/ "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)", &
         "t_max(X)", "t_max(X)", "t_max(X)", "t_max(X)" /))
  TYPE(ctrl_out), SAVE :: o_solldown = ctrl_out((/ 10, 1, 10, 10, 10, 10, 11, 11, 11 /), &
	'solldown', 'Down. IR rad. at surface', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtsvdfo = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtsvdfo', 'Boundary-layer dTs(o)', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtsvdft = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtsvdft', 'Boundary-layer dTs(t)', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtsvdfg = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtsvdfg', 'Boundary-layer dTs(g)', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtsvdfi = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtsvdfi', 'Boundary-layer dTs(g)', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rugs = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rugs', 'rugosity', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_topswad = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'topswad', 'ADE at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_topswad0 = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'topswad0', 'ADE clear-sky at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_topswai = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'topswai', 'AIE at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_solswad = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'solswad', 'ADE at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_solswad0 = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'solswad0', 'ADE clear-sky at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_solswai = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'solswai', 'AIE at SFR', 'W/m2', (/ ('', i=1, 9) /))

!  type(ctrl_out),save,dimension(10) :: o_tausumaero  = (/ ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_ASBCM', &
!	(/ ('', i=1, 9) /)), &
  type(ctrl_out),save,dimension(11) :: o_tausumaero  =                           & 
    (/ ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_ASBCM',                        &
      "Aerosol Optical depth at 550 nm "//name_aero(1),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_ASPOMM',                       &
      "Aerosol Optical depth at 550 nm "//name_aero(2),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_ASSO4M',                       &
      "Aerosol Optical depth at 550 nm "//name_aero(3),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_CSSO4M',                       &
      "Aerosol Optical depth at 550 nm "//name_aero(4),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_SSSSM',                        &
      "Aerosol Optical depth at 550 nm "//name_aero(5),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_ASSSM',                        &
      "Aerosol Optical depth at 550 nm "//name_aero(6),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_CSSSM',                        &
      "Aerosol Optical depth at 550 nm "//name_aero(7),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_CIDUSTM',                      &
      "Aerosol Optical depth at 550 nm "//name_aero(8),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_AIBCM',                        &
      "Aerosol Optical depth at 550 nm "//name_aero(9),"1", (/ ('', i=1, 9) /)), &
       ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /),'OD550_AIPOMM',                       &
      "Aerosol Optical depth at 550 nm "//name_aero(10),"1", (/ ('', i=1, 9) /)),&
       ctrl_out((/ 2, 2, 10, 10, 10, 10, 11, 11, 11 /),'OD550_STRAT',                        &
      "Aerosol Optical depth at 550 nm "//name_aero(11),"1", (/ ('', i=1, 9) /)) /)
  TYPE(ctrl_out), SAVE :: o_od550aer = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'od550aer', 'Total aerosol optical depth at 550nm', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_od865aer = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'od865aer', 'Total aerosol optical depth at 870nm', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_absvisaer = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'absvisaer', 'Absorption aerosol visible optical depth', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_od550lt1aer = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'od550lt1aer', 'Fine mode optical depth', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sconcso4 = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'sconcso4', 'Surface Concentration of Sulfate ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sconcoa = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'sconcoa', 'Surface Concentration of Organic Aerosol ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sconcbc = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'sconcbc', 'Surface Concentration of Black Carbon ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sconcss = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'sconcss', 'Surface Concentration of Sea Salt ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_sconcdust = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'sconcdust', 'Surface Concentration of Dust ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_concso4 = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'concso4', 'Concentration of Sulfate ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_concoa = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'concoa', 'Concentration of Organic Aerosol ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_concbc = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'concbc', 'Concentration of Black Carbon ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_concss = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'concss', 'Concentration of Sea Salt ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_concdust = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'concdust', 'Concentration of Dust ', 'kg/m3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_loadso4 = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'loadso4', 'Column Load of Sulfate ', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_loadoa = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'loadoa', 'Column Load of Organic Aerosol ', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_loadbc = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'loadbc', 'Column Load of Black Carbon ', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_loadss = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'loadss', 'Column Load of Sea Salt ', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_loaddust = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'loaddust', 'Column Load of Dust ', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swtoaas_nat = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swtoaas_nat', 'Natural aerosol radiative forcing all-sky at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swsrfas_nat = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swsrfas_nat', 'Natural aerosol radiative forcing all-sky at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swtoacs_nat = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swtoacs_nat', 'Natural aerosol radiative forcing clear-sky at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swsrfcs_nat = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swsrfcs_nat', 'Natural aerosol radiative forcing clear-sky at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swtoaas_ant = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swtoaas_ant', 'Anthropogenic aerosol radiative forcing all-sky at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swsrfas_ant = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swsrfas_ant', 'Anthropogenic aerosol radiative forcing all-sky at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swtoacs_ant = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swtoacs_ant', 'Anthropogenic aerosol radiative forcing clear-sky at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swsrfcs_ant = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swsrfcs_ant', 'Anthropogenic aerosol radiative forcing clear-sky at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swtoacf_nat = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swtoacf_nat', 'Natural aerosol impact on cloud radiative forcing at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swsrfcf_nat = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swsrfcf_nat', 'Natural aerosol impact on cloud radiative forcing  at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swtoacf_ant = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swtoacf_ant', 'Anthropogenic aerosol impact on cloud radiative forcing at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swsrfcf_ant = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swsrfcf_ant', 'Anthropogenic aerosol impact on cloud radiative forcing at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swtoacf_zero = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swtoacf_zero', 'Cloud radiative forcing (allsky-clearsky fluxes) at TOA', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_swsrfcf_zero = ctrl_out((/ 4, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'swsrfcf_zero', 'Cloud radiative forcing (allsky-clearsky fluxes) at SRF', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldncl = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldncl', 'CDNC at top of liquid water cloud', 'm-3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_reffclwtop = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'reffclwtop', 'Droplet effective radius at top of liquid water cloud', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_cldnvi = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'cldnvi', 'Column Integrated Cloud Droplet Number', 'm-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lcc = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'lcc', 'Cloud liquid fraction at top of cloud', '1', (/ ('', i=1, 9) /))


!!!!!!!!!!!!!!!!!!!!!! 3D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
  TYPE(ctrl_out), SAVE :: o_ec550aer = ctrl_out((/ 2, 6, 10, 10, 10, 10, 11, 11, 11 /), &
	'ec550aer', 'Extinction at 550nm', 'm^-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lwcon = ctrl_out((/ 2, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'lwcon', 'Cloud liquid water content', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_iwcon = ctrl_out((/ 2, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'iwcon', 'Cloud ice water content', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_temp = ctrl_out((/ 2, 3, 4, 10, 10, 10, 11, 11, 11 /), &
	'temp', 'Air temperature', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_theta = ctrl_out((/ 2, 3, 4, 10, 10, 10, 11, 11, 11 /), &
	'theta', 'Potential air temperature', 'K', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ovap = ctrl_out((/ 2, 3, 4, 10, 10, 10, 11, 11, 11 /), &
	'ovap', 'Specific humidity', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ovapinit = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ovapinit', 'Specific humidity (begin of timestep)', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_oliq = ctrl_out((/ 2, 3, 4, 10, 10, 10, 11, 11, 11 /), &
	'oliq', 'Condensed water', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wvapp = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'wvapp', '', '', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_geop = ctrl_out((/ 2, 3, 10, 10, 10, 10, 11, 11, 11 /), &
	'geop', 'Geopotential height', 'm2/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_vitu = ctrl_out((/ 2, 3, 4, 6, 10, 10, 11, 11, 11 /), &
	'vitu', 'Zonal wind', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_vitv = ctrl_out((/ 2, 3, 4, 6, 10, 10, 11, 11, 11 /), &
	'vitv', 'Meridional wind', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_vitw = ctrl_out((/ 2, 3, 10, 6, 10, 10, 11, 11, 11 /), &
	'vitw', 'Vertical wind', 'Pa/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_pres = ctrl_out((/ 2, 3, 10, 10, 10, 10, 11, 11, 11 /), &
	'pres', 'Air pressure', 'Pa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_paprs = ctrl_out((/ 2, 3, 10, 10, 10, 10, 11, 11, 11 /), &
	'paprs', 'Air pressure Inter-Couches', 'Pa', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_mass = ctrl_out((/ 2, 3, 10, 10, 10, 10, 11, 11, 11 /), &
	'mass', 'Masse Couches', 'kg/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_zfull = ctrl_out((/ 2, 3, 10, 10, 10, 10, 11, 11, 11 /), &
	'zfull', 'Altitude of full pressure levels', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_zhalf = ctrl_out((/ 2, 3, 10, 10, 10, 10, 11, 11, 11 /), &
	'zhalf', 'Altitude of half pressure levels', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rneb = ctrl_out((/ 2, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'rneb', 'Cloud fraction', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rnebcon = ctrl_out((/ 2, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'rnebcon', 'Convective Cloud Fraction', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rnebls = ctrl_out((/ 2, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'rnebls', 'LS Cloud fraction', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rhum = ctrl_out((/ 2, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'rhum', 'Relative humidity', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ozone = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ozone', 'Ozone mole fraction', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ozone_light = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ozone_daylight', 'Daylight ozone mole fraction', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_upwd = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'upwd', 'saturated updraft', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtphy = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtphy', 'Physics dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqphy = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqphy', 'Physics dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_pr_con_l = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'pr_con_l', 'Convective precipitation lic', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_pr_con_i = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'pr_con_i', 'Convective precipitation ice', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_pr_lsc_l = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'pr_lsc_l', 'Large scale precipitation lic', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_pr_lsc_i = ctrl_out((/ 2, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'pr_lsc_i', 'Large scale precipitation ice', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_re = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	're', 'Cloud droplet effective radius', 'um', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_fl = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'fl', 'Denominator of Cloud droplet effective radius', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_scdnc = ctrl_out((/ 2,  6, 10, 10, 10, 10, 11, 11, 11 /), &
	'scdnc', 'Cloud droplet number concentration', 'm-3', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_reffclws = ctrl_out((/ 2,  6, 10, 10, 10, 10, 11, 11, 11 /), &
	'reffclws', 'Stratiform Cloud Droplet Effective Radius (aerosol diags.)', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_reffclwc = ctrl_out((/ 2,  6, 10, 10, 10, 10, 11, 11, 11 /), &
	'reffclwc', 'Convective Cloud Droplet Effective Radius (aerosol diags.)', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lcc3d = ctrl_out((/ 2,  6, 10, 10, 10, 10, 11, 11, 11 /), &
	'lcc3d', 'Cloud liquid fraction', '1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lcc3dcon = ctrl_out((/ 2,  6, 10, 10, 10, 10, 11, 11, 11 /), &
	'lcc3dcon', 'Convective cloud liquid fraction', '1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lcc3dstra = ctrl_out((/ 2,  6, 10, 10, 10, 10, 11, 11, 11 /), &
	'lcc3dstra', 'Stratiform cloud liquid fraction', '1', (/ ('', i=1, 9) /))
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_albe_srf     = (/ &
      ctrl_out((/ 3, 7, 10, 7, 10, 10, 11, 11, 11 /),'albe_ter', "Albedo VIS surf. "//clnsurf(1),"-", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 7, 10, 7, 10, 10, 11, 11, 11 /),'albe_lic', "Albedo VIS surf. "//clnsurf(2),"-", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 7, 10, 7, 10, 10, 11, 11, 11 /),'albe_oce', "Albedo VIS surf. "//clnsurf(3),"-", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 7, 10, 7, 10, 10, 11, 11, 11 /),'albe_sic', "Albedo VIS surf. "//clnsurf(4),"-", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_ages_srf     = (/ &
      ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /),'ages_ter', "Snow age", "day", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 10, 10, 10, 10, 10, 11, 11, 11 /),'ages_lic', "Snow age", "day", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /),'ages_oce',"Snow age", "day", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 10, 10, 10, 10, 10, 11, 11, 11 /),'ages_sic',"Snow age", "day", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE, DIMENSION(4) :: o_rugs_srf     = (/ &
      ctrl_out((/ 3, 6, 10, 10, 10, 10, 11, 11, 11 /),'rugs_ter', "Surface roughness "//clnsurf(1),"m", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 6, 10, 10, 10, 10, 11, 11, 11 /),'rugs_lic', "Surface roughness "//clnsurf(2),"m", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 6, 10, 10, 10, 10, 11, 11, 11 /),'rugs_oce', "Surface roughness "//clnsurf(3),"m", (/ ('', i=1, 9) /)), &
      ctrl_out((/ 3, 6, 10, 10, 10, 10, 11, 11, 11 /),'rugs_sic', "Surface roughness "//clnsurf(4),"m", (/ ('', i=1, 9) /)) /)

  TYPE(ctrl_out), SAVE :: o_alb1 = ctrl_out((/ 3, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'alb1', 'Surface VIS albedo', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_alb2 = ctrl_out((/ 3, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'alb2', 'Surface Near IR albedo', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_clwcon = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'clwcon', 'Convective Cloud Liquid water content', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_Ma = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'Ma', 'undilute adiab updraft', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dnwd = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dnwd', 'saturated downdraft', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dnwd0 = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dnwd0', 'unsat. downdraft', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_mc = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'mc', 'Convective mass flux', 'kg/m2/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ftime_con = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ftime_con', 'Fraction of time convection Occurs', ' ',                 &
      (/ 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)', 'inst(X)' /))
  TYPE(ctrl_out), SAVE :: o_dtdyn = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtdyn', 'Dynamics dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqdyn = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqdyn', 'Dynamics dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dudyn = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dudyn', 'Dynamics dU', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dvdyn = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dvdyn', 'Dynamics dV', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtcon = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtcon', 'Convection dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ducon = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ducon', 'Convection du', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dvcon = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dvcon', 'Convection dv', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqcon = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqcon', 'Convection dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtwak = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtwak', 'Wake dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqwak = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqwak', 'Wake dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wake_h = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'wake_h', 'wake_h', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wake_s = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'wake_s', 'wake_s', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wake_deltat = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'wake_deltat', 'wake_deltat', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wake_deltaq = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'wake_deltaq', 'wake_deltaq', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wake_omg = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'wake_omg', 'wake_omg', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wdtrainA = ctrl_out((/ 4, 1, 10,  4,  1, 10, 11, 11, 110 /), &
	'wdtrainA', 'precipitation from AA', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_wdtrainM = ctrl_out((/ 4, 1, 10,  4,  1, 10, 11, 11, 110 /), &
	'wdtrainM', 'precipitation from mixture', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_Vprecip = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'Vprecip', 'precipitation vertical profile', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ftd = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'ftd', 'tend temp due aux descentes precip', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_fqd = ctrl_out((/ 4, 5, 10, 10, 10, 10, 11, 11, 11 /), &
	'fqd', 'tend vap eau due aux descentes precip', '-', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtlsc = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtlsc', 'Condensation dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtlschr = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtlschr', 'Large-scale condensational heating rate', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqlsc = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqlsc', 'Condensation dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_beta_prec = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'beta_prec', 'LS Conversion rate to prec', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtvdf = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtvdf', 'Boundary-layer dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtdis = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtdis', 'TKE dissipation dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqvdf = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqvdf', 'Boundary-layer dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dteva = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dteva', 'Reevaporation dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqeva = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqeva', 'Reevaporation dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))

!!!!!!!!!!!!!!!! Specifique thermiques
  TYPE(ctrl_out), SAVE :: o_dqlscth = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqlscth', 'dQ therm.', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqlscst = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqlscst', 'dQ strat.', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtlscth = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtlscth', 'dQ therm.', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtlscst = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtlscst', 'dQ strat.', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_plulth = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'plulth', 'Rainfall therm.', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_plulst = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'plulst', 'Rainfall strat.', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lmaxth = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'lmaxth', "Upper level thermals", "", (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ptconvth = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ptconvth', 'POINTS CONVECTIFS therm.', ' ', (/ ('', i=1, 9) /))
!!!!!!!!!!!!!!!!!!!!!!!!
  TYPE(ctrl_out), SAVE :: o_ptconv = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ptconv', 'POINTS CONVECTIFS', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ratqs = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ratqs', 'RATQS', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtthe = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtthe', 'Thermal dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_f_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'f_th', 'Thermal plume mass flux', 'kg/(m2*s)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_e_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'e_th', 'Thermal plume entrainment', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_w_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'w_th', 'Thermal plume vertical velocity', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_lambda_th = ctrl_out((/ 10, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'lambda_th', 'Thermal plume vertical velocity', 'm/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ftime_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ftime_th', 'Fraction of time Shallow convection occurs', ' ', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_q_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'q_th', 'Thermal plume total humidity', 'kg/kg', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_a_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'a_th', "Thermal plume fraction", "", (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_d_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'd_th', 'Thermal plume detrainment', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_f0_th = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'f0_th', 'Thermal closure mass flux', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_zmax_th = ctrl_out((/ 4,  4,  4,  5, 10, 10, 11, 11, 11 /), &
	'zmax_th', 'Thermal plume height', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqthe = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqthe', 'Thermal dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtajs = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtajs', 'Dry adjust. dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dqajs = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dqajs', 'Dry adjust. dQ', '(kg/kg)/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtswr = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtswr', 'SW radiation dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtsw0 = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtsw0', 'CS SW radiation dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtlwr = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtlwr', 'LW radiation dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtlw0 = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtlw0', 'CS LW radiation dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtec = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtec', 'Cinetic dissip dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_duvdf = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'duvdf', 'Boundary-layer dU', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dvvdf = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dvvdf', 'Boundary-layer dV', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_duoro = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'duoro', 'Orography dU', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dvoro = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dvoro', 'Orography dV', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dulif = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dulif', 'Orography dU', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dvlif = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dvlif', 'Orography dV', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_duhin = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'duhin', 'Hines GWD dU', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dvhin = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dvhin', 'Hines GWD dV', 'm/s2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtoro = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtoro', 'Orography dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dtlif = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dtlif', 'Orography dT', 'K/s', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dthin = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dthin', 'Hines GWD dT', 'K/s', (/ ('', i=1, 9) /))

  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_trac(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_trac_cum(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_vdf(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_the(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_con(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_lessi_impa(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_lessi_nucl(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_insc(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_bcscav(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_evapls(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_ls(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_trsp(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_sscav(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_sat(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_uscav(:)
  TYPE(ctrl_out), SAVE, ALLOCATABLE :: o_dtr_dry(:)

  TYPE(ctrl_out), SAVE :: o_rsu = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsu', 'SW upward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsd = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsd', 'SW downward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rlu = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rlu', 'LW upward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rld = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rld', 'LW downward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsucs = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsucs', 'SW CS upward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsdcs = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsdcs', 'SW CS downward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rlucs = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rlucs', 'LW CS upward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rldcs = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rldcs', 'LW CS downward radiation', 'W m-2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tnt = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tnt', 'Tendency of air temperature', 'K s-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tntc = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tntc', 'Tendency of air temperature due to Moist Convection', 'K s-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tntr = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tntr', 'Air temperature tendency due to Radiative heating', 'K s-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tntscpbl = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /),                  &
	'tntscpbl', 'Air temperature tendency due to St cloud and precipitation and BL mixing', &
      'K s-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tnhus = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tnhus', 'Tendency of specific humidity', 's-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tnhusc = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tnhusc', 'Tendency of specific humidity due to convection', 's-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_tnhusscpbl = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'tnhusscpbl', 'Tendency of Specific humidity due to ST cl, precip and BL mixing', 's-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_evu = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'evu', 'Eddy viscosity coefficient for Momentum Variables', 'm2 s-1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_h2o = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'h2o', 'Mass Fraction of Water', '1', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_mcd = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'mcd', 'Downdraft COnvective Mass Flux', 'kg/(m2*s)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_dmc = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'dmc', 'Deep COnvective Mass Flux', 'kg/(m2*s)', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ref_liq = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ref_liq', 'Effective radius of convective cloud liquid water particle', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_ref_ice = ctrl_out((/ 4, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'ref_ice', 'Effective radius of startiform cloud ice particle', 'm', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsut4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsut4co2', 'TOA Out SW in 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rlut4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rlut4co2', 'TOA Out LW in 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsutcs4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsutcs4co2', 'TOA Out CS SW in 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rlutcs4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rlutcs4co2', 'TOA Out CS LW in 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsu4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsu4co2', 'Upwelling SW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rlu4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rlu4co2', 'Upwelling LW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsucs4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsucs4co2', 'Upwelling CS SW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rlucs4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rlucs4co2', 'Upwelling CS LW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsd4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsd4co2', 'Downwelling SW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rld4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rld4co2', 'Downwelling LW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rsdcs4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rsdcs4co2', 'Downwelling CS SW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))
  TYPE(ctrl_out), SAVE :: o_rldcs4co2 = ctrl_out((/ 5, 10, 10, 10, 10, 10, 11, 11, 11 /), &
	'rldcs4co2', 'Downwelling CS LW 4xCO2 atmosphere', 'W/m2', (/ ('', i=1, 9) /))

!!!!!!!!!!!!! Sorties niveaux standards de pression NMC 
  TYPE(ctrl_out), SAVE :: o_tnondef = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'tnondef', 'Undefined value of T', 'K', (/ "inst(X)", "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_ta = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'ta', 'Air temperature', 'K', (/ "inst(X)", "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_zg  = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'zg', 'Geopotential height', 'm', (/ "inst(X)", "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_hus = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'hus', 'Specific humidity', '1', (/ "inst(X)", "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                    
  TYPE(ctrl_out), SAVE :: o_hur = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'hur', 'Relative humidity', '%', (/ "inst(X)", "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_ua = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'ua', 'Eastward wind', 'm s-1', (/ "inst(X)", "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_va = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'va', 'Northward wind', 'm s-1', (/ ('', i=1, 9)/))
  TYPE(ctrl_out), SAVE :: o_wap = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'wap', 'Lagrangian tendency of air pressure', 'Pa s-1', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_psbg = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'psbg', 'Lagrangian tendency of air pressure', 'Pa s-1', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_tro3 = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'tro3', 'Ozone mole fraction', '1e-9', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_tro3_daylight = ctrl_out((/ 11, 11, 11, 11, 11, 11, 5, 5, 5 /), &
       'tro3_daylight', 'Daylight ozone mole fraction', '1e-9', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_uxv = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'uv', 'uv', 'm2/s2', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))
  TYPE(ctrl_out), SAVE :: o_vxq = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'vq', 'vq', 'm/s * (kg/kg)', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                                    
  TYPE(ctrl_out), SAVE :: o_vxT = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'vT', 'vT', 'mK/s', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                      
  TYPE(ctrl_out), SAVE :: o_wxq = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'wq', 'wq', '(Pa/s)*(kg/kg)', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                
  TYPE(ctrl_out), SAVE :: o_vxphi = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'vphi', 'vphi', 'm2/s', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                 
  TYPE(ctrl_out), SAVE :: o_wxT = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'wT', 'wT', '"K*Pa/s', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                     
  TYPE(ctrl_out), SAVE :: o_uxu = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'u2', 'u2', 'm2/s2', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                                                                         
  TYPE(ctrl_out), SAVE :: o_vxv = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'v2', 'v2', 'm2/s2', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                               
   TYPE(ctrl_out), SAVE :: o_TxT = ctrl_out((/ 11, 11, 11, 11, 11, 11, 6, 6, 6 /), &
       'T2', 'T2', 'K2', (/ "inst(X)", "inst(X)", "inst(X)", &
       "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)", "inst(X)"  /))                                                                                  

END MODULE phys_output_ctrlout_mod
