!
! phys_local_var_mod.F90 1327 2010-03-17 15:33:56Z idelkadi $

      MODULE phys_output_var_mod

      use dimphy
! Variables outputs pour les ecritures des sorties
!======================================================================
!
!
!======================================================================
! Declaration des variables

      REAL, SAVE, ALLOCATABLE :: snow_o(:), zfra_o(:)
!$OMP THREADPRIVATE(snow_o, zfra_o)
      INTEGER, SAVE, ALLOCATABLE ::  itau_con(:)       ! Nombre de pas ou rflag <= 1
!$OMP THREADPRIVATE(itau_con)
      REAL, ALLOCATABLE :: bils_ec(:) ! Contribution of energy conservation
      REAL, ALLOCATABLE :: bils_tke(:) ! Contribution of energy conservation
      REAL, ALLOCATABLE :: bils_diss(:) ! Contribution of energy conservation
      REAL, ALLOCATABLE :: bils_kinetic(:) ! bilan de chaleur au sol, kinetic
      REAL, ALLOCATABLE :: bils_enthalp(:) ! bilan de chaleur au sol
      REAL, ALLOCATABLE :: bils_latent(:) ! bilan de chaleur au sol
!$OMP THREADPRIVATE(bils_ec,bils_tke,bils_diss,bils_kinetic,bils_enthalp,bils_latent)

! ug Plein de variables venues de phys_output_mod
      INTEGER, PARAMETER                           :: nfiles = 6
      LOGICAL, DIMENSION(nfiles), SAVE             :: clef_files
      LOGICAL, DIMENSION(nfiles), SAVE             :: clef_stations
      INTEGER, DIMENSION(nfiles), SAVE             :: lev_files
      INTEGER, DIMENSION(nfiles), SAVE             :: nid_files
      INTEGER, DIMENSION(nfiles), SAVE  :: nnid_files
!$OMP THREADPRIVATE(clef_files, clef_stations, lev_files,nid_files,nnid_files)
      INTEGER, DIMENSION(nfiles), SAVE :: nnhorim

      INTEGER, DIMENSION(nfiles), SAVE :: nhorim, nvertm
      INTEGER, DIMENSION(nfiles), SAVE :: nvertap, nvertbp, nvertAlt
      REAL, DIMENSION(nfiles), SAVE                :: zoutm
      CHARACTER(LEN=20), DIMENSION(nfiles), SAVE   :: type_ecri
!$OMP THREADPRIVATE(nnhorim, nhorim, nvertm, zoutm,type_ecri)
      CHARACTER(LEN=20), DIMENSION(nfiles), SAVE  :: type_ecri_files, phys_out_filetypes
!$OMP THREADPRIVATE(type_ecri_files, phys_out_filetypes)
    CHARACTER(LEN=20), DIMENSION(nfiles), SAVE  :: phys_out_filenames
!$OMP THREADPRIVATE(phys_out_filenames)

 ! swaero_diag : flag indicates if it is necessary to do calculation for some aerosol diagnostics
      LOGICAL, SAVE                                :: swaero_diag=.FALSE.
!$OMP THREADPRIVATE(swaero_diag)

      INTEGER, SAVE:: levmin(nfiles) = 1
      INTEGER, SAVE:: levmax(nfiles)
!$OMP THREADPRIVATE(levmin, levmax)

      REAL, SAVE                :: zdtime_moy
!$OMP THREADPRIVATE(zdtime_moy)

      LOGICAL, SAVE :: vars_defined = .FALSE. ! ug PAS THREADPRIVATE ET C'EST NORMAL

  TYPE ctrl_out
     INTEGER,DIMENSION(nfiles)            :: flag
     CHARACTER(len=20)                    :: name
     CHARACTER(len=150)                   :: description
     CHARACTER(len=20)                    :: unit
     CHARACTER(len=20),DIMENSION(nfiles)  :: type_ecrit
  END TYPE ctrl_out
CONTAINS

!======================================================================
SUBROUTINE phys_output_var_init
use dimphy

IMPLICIT NONE

      allocate(snow_o(klon), zfra_o(klon))
      allocate(itau_con(klon))
      allocate (bils_ec(klon),bils_tke(klon),bils_diss(klon),bils_kinetic(klon),bils_enthalp(klon),bils_latent(klon))

END SUBROUTINE phys_output_var_init

!======================================================================
SUBROUTINE phys_output_var_end
use dimphy
IMPLICIT NONE

      deallocate(snow_o,zfra_o,itau_con)
      deallocate (bils_ec,bils_tke,bils_diss,bils_kinetic,bils_enthalp,bils_latent)

END SUBROUTINE phys_output_var_end

END MODULE phys_output_var_mod
