#!/bin/ksh
#
#   Script d'installation de LMDZ_1D, pour la version trunk
# du 07 Octobre 2011 (=1575) et au-dela.
#   ATTENTION : la prise en compte de l'heure de dmarrage n'existe que dans les versions
# postrieures au 3 Novembre 2011 (=1577).
#   Le script est conu pour fonctionner aussi avec des versions antrieures mais ce n'est 
# pas test : Use at your own risk!
#
#Directory o est place le modele install par install.sh


version=`sed -n "s/version *=//p" install.sh`
echo $version
modele=`pwd`/LMDZ${version}
#Les directories de simulation seront placs sous $modele/1dcases .
#Le code physique sera place sous $modele/modipsl/modeles/LMDZ5/libf/.
#
cd $modele
#
LMDGCM=`pwd`



##########################################################################################
# Recuperation des sources du modele 1D et des cas.

cd $LMDGCM/modipsl/modeles/LMDZ5/libf/
LMDlibf=`pwd`
cd $LMDGCM
# On va chercher les fichiers
interne=no
###interne=yes
if [ $interne = no ]
then
 wget http://www.lmd.jussieu.fr/~lmdz/DistribG95/lmdz1d_source_20121016.tar.gz
 tar xvfz lmdz1d_source_20121016.tar.gz
 rm -f lmdz1d_source_20121016.tar.gz
 source=${LMDGCM}/lmdz1d_source_20121016
else
 cp -a /home/jygz/LMDZ/SLMDZ/LMDZ5_source_20120112/lmdz1d_source_20120112 .
 source=${LMDGCM}/lmdz1d_source_20120112
fi
#

##########################################################################################
# Creation des repertoires des cas.
##########################################################################################

if [ -f 1dcases ]
then
  echo '1dcases existe deja'
  echo 'on continue'
else
  echo 'creation du directory 1dcases'
  mkdir 1dcases
fi
cd 1dcases


for cas in ayotte eq_rd_cv case_e hapex92_init twpice toga rico arm_cu ; do
   if [ -f $cas ]
   then
      echo $cas existe deja
      echo 'on continue, mais il  faudra verifier qu il ne manque rien dans '$cas
   else
      echo 'creation du directory de simulation '$cas
      cp -a ${source}/$cas .
   fi
   dir $cas
done


##########################################################################################
# On teste si la version svn est plus recentes que la 1640 pour la gestion du 1D
cd $LMDGCM/modipsl/modeles
new1d=`svn info LMDZ5 | grep Revision | awk ' { fl = 0 ; if ( $2 > 1640 )  fl=1 ; print fl } '`


if [ $new1d = 1 ] ; then

cd $LMDlibf
wget http://lmdz.lmd.jussieu.fr/utilisateurs/outils/utilisation-de-lmdz/install_1d_src-sh
chmod +x install_1d_src-sh
./install_1d_src-sh


else
##########################################################################################
# Ancienne gestion des sources 1D avec corrections.
# Voir commemnt faire cohabiter une partie de cette facon de faire avec la nouvelle

cd ${LMDlibf}
if [ -d phy1d ]
then
 echo 'phy1d existe deja'
 echo 'on continue'
 cd phy1d
 echo 'on cree le lien vers ../dyn3d/mod_const_para.F90 si necessaire'
 if [ ! -f mod_const_para.F90 ]
 then
  ln -s ../dyn3d/mod_const_para.F90  mod_const_para.F90
  ln -s ../dyn3d/infotrac.F90        infotrac.F90
  ln -s ../dyn3d/conf_gcm.F          conf_gcm.F
  ln -s ../dyn3d/pres2lev.F90        pres2lev.F90
  ln -s ../dyn3d/control_mod.F90     control_mod.F90
  ln -s ../dyn3d/q_sat.F             q_sat.F
 fi
else
 \rm -rf phy1d
 echo 'creation du directory phy1d'
 mkdir phy1d
 echo copie de phylmd dans phy1d
 cp -a phylmd/* phy1d
 cp -a ${source}/phy1d_source/* phy1d
 cp -af ${source}/phy1d_source_upd/* phy1d
 cd phy1d
 ln -s ../dyn3d/mod_const_para.F90  mod_const_para.F90
 ln -s ../dyn3d/infotrac.F90        infotrac.F90
 ln -s ../dyn3d/conf_gcm.F          conf_gcm.F
 ln -s ../dyn3d/pres2lev.F90        pres2lev.F90
 ln -s ../dyn3d/control_mod.F90     control_mod.F90
 ln -s ../dyn3d/q_sat.F             q_sat.F
#
 grep -i "subroutine *writelim" *.F *.F90 >/dev/null
 if [ "$?" = "0" ]
 then
  echo Use writelim free version of 1DUTILS.h
  mv 1DUTILS.h_no_writelim 1DUTILS.h
 else
  echo Use 1DUTILS.h version including subroutine writelim
  mv 1DUTILS.h_with_writelim 1DUTILS.h
  rm -f ttt
  sed -e "s/^ *call *writelim *( *1 *,/      call writelim (/" lmdz1d.F >ttt
  rm -f lmdz1d.F
  mv ttt lmdz1d.F
 fi
 rm -f 1DUTILS.h*writelim
#
############################################################################
#                                                                          #
#               CORRECTIONS spcifiques au 1D                              #
#                                                                          #
############################################################################
#
 echo Update physiq.F and suppress lambda_th
 rm -f physiq.F
 sed -e "/add_phys_tend.*_vdf/s/add_phys_tend/add_pbl_tend/;" ../phylmd/physiq.F >physiq.F.ori
#
 echo Update phys_output_mod.F90 and suppress lambda_th
 rm -f phys_output_mod.F90
sed -e "/SUBROUTINE *convers_timesteps/,/END SUBROUTINE convers_timesteps/{
 /USE *phys_cal_mod/d
 /use *ioipsl/a\\
    USE phys_cal_mod
 s/ioget_mon_len(annee_ref,day_ref)/mth_len/
};/SUBROUTINE *phys_output_open/,/end *subroutine *phys_output_open/{
 /USE *ioipsl/a\\
  USE phys_cal_mod, only : hour
 /ymds2ju.*annee_ref.*zjulian/c\\
!!!      CALL ymds2ju(annee_ref, 1, idayref, 0.0, zjulian)       !jyg \\
! correction pour l heure initiale                               !jyg \\
!                                                                !jyg \\
      CALL ymds2ju(annee_ref, 1, idayref, hour, zjulian)         !jyg
}" ../phylmd/phys_output_mod.F90 >phys_output_mod.F90.ori
#
 echo Update pbl_surface_mod.F90
 rm -f pbl_surface_mod.F90
 sed -e "/^ *INCLUDE *\"temps.h\"/{
 a\\
!****************************************************************************************\\
! Declarations specifiques pour le 1D. A reprendre \\
    INCLUDE \"flux_arp.h\"
 }; /^.*REAL *::.*fsens *, *flat/d; /^.*LOGICAL *::.*ok_flux_surf/d; /^.*COMMON.*flux_arp.*/d " ../phylmd/pbl_surface_mod.F90 >pbl_surface_mod.F90.ori
fi
#
############################################################################
#                                                                          #
#               CORRECTIONS DE BUGS (corrections necessaires au            #
#                                    fonctionnement du 1D pour le cas      #
#                                    o une version trop vieille de LMDZ   #
#                                    est utilise)                         #
#                                                                          #
############################################################################
#
 echo Update coef_diff_turb_mod.F90
 rm -f coef_diff_turb_mod.F90
sed -e "/zfr *= *(zq+ratqs\*zq-zqs) *\/ *(2.0\*ratqs\*zq)/{
c\\
!!jyg : pour eviter une division par 0                                   \\
!!!!          zfr = (zq+ratqs*zq-zqs) / (2.0*ratqs*zq)                   \\
          zfr = (zq+ratqs*zq-zqs) / (2.0*ratqs*MAX(zq,zqs/(1.+ratqs)))
}" ../phylmd/coef_diff_turb_mod.F90 >coef_diff_turb_mod.F90
#
 echo Update physiq.F and suppress lambda_th
 rm -f physiq.F
 sed -e "/REAL/s/lambda_th(klon,klev),//;/lambda_th.*=/d" physiq.F.ori >physiq.F
#
 echo Update phys_output_mod.F90 and suppress lambda_th
 rm -f phys_output_mod.F90
sed -e "/save.*o_lambda_th/d;/CALL histdef3d(iff,clef_stations(iff),/{
N;/o_lambda_th/d
}" phys_output_mod.F90.ori >phys_output_mod.F90
#
 echo Update phys_output_write.h and suppress lambda_th
 rm -f phys_output_write.h
sed -e "/IF *( *o_lambda_th/,/ENDIF/d" ../phylmd/phys_output_write.h >phys_output_write.h
#
 mv pbl_surface_mod.F90.ori pbl_surface_mod.F90
#
############################################################################
#                                                                          #
#               CORRECTIONS pour version en developpement :                #
#                  fabrication ventuelle de phy1dref et phy1d            #
#                                                                          #
#        Partie  effacer si on ne veut pas de ces corrections             #
#        (par ex. si le 3D les contients dej, ou s'il est trop ancien)    #
#                                                                          #
############################################################################
#
 
#
if [ -d ${source}/phy1d_source_new ]
then
#  D'abord on recopie la physique que l'on vient de construire dans phy1dref
#
  echo Creation de phy1dref
  cd ..
  cp -a phy1d phy1dref
  echo Ajout des nouveaux codes-source
  cp -af ${source}/phy1d_source_new/* phy1d
  cd phy1d
#
  echo Update physiq.F dans phy1d
  rm -f physiq.F
  sed -e "/if *(iflag_thermals\.gt\.1) *then/{
N;/call *calltherm/s/(iflag_thermals\.gt\.1)/(iflag_thermals>=1)/
};/if *(iflag_thermals>1) *then/{
N;N;/d_t_lscth.*d_t_lscst/s/(iflag_thermals>1)/(iflag_thermals>=1)/
}" ../phy1dref/physiq.F >physiq.F
#
  echo Update phys_output_mod.F90 dans phy1d
  rm -f phys_output_mod.F90
  sed -e "/type(ctrl_out).*o_ovapinit/{
a\\
  type(ctrl_out),save :: o_oliq         = ctrl_out((/ 2, 3, 4, 10, 10, 10 /),'oliq')
};/CALL *histdef3d.*o_ovap%flag/{
a\\
          CALL histdef3d(iff,clef_stations(iff),o_oliq%flag,o_oliq%name, \"Condensed water\", \"kg/kg\" )
};/if *(iflag_thermals\.gt\.1) *THEN/,/endif *!iflag_thermals\.gt\.1/{
/if *(iflag_thermals\.gt\.1)/{
N;N;h;/dqlscth.*dqlscst/{
s/(iflag_thermals\.gt\.1)/(iflag_thermals>=1)/
}
};/endif *!iflag_thermals\.gt\.1/{
x;/dqlscth.*dqlscst/{
x;s/iflag_thermals\.gt\.1/iflag_thermals>=1/
}
}
}" ../phy1dref/phys_output_mod.F90 >phys_output_mod.F90
#
  echo Update phys_output_write.h dans phy1d
  rm -f phys_output_write.h
  sed -e "/IF.*o_ovap%flag/,/ENDIF/{
/ENDIF/{
a\\
                                                               \\
       IF (o_oliq%flag(iff)<=lev_files(iff)) THEN              \\
      CALL histwrite_phy(nid_files(iff),clef_stations(iff),    \\
     $                   o_oliq%name,itau_w,ql_seri)            \\
       ENDIF
}
};/IF *(o_mc\%flag(iff)/,/ENDIF/s/(iflag_thermals\.gt\.1)/(iflag_thermals>=1)/;/if *(iflag_thermals>1) *then/,/endif *! *iflag_thermals>1/{
/if *(iflag_thermals>1)/{
N;N;N;h;/o_dtlscth\%flag(iff)/s/(iflag_thermals>1)/(iflag_thermals>=1)/
};/endif *! *iflag_thermals>1/{
x;/o_dtlscth\%flag(iff)/{
x;s/iflag_thermals>1/iflag_thermals>=1/
}
}
};/IF *(iflag_thermals\.gt\.1) *THEN/{
N;N;/o_ftime_th%flag(iff)/s/(iflag_thermals\.gt\.1)/(iflag_thermals>=1)/
}" ../phy1dref/phys_output_write.h >phys_output_write.h 
#
fi
#
fi
############################################################################
#                                                                          #
#              FIN DES CORRECTIONS                                         #
#                                                                          #
############################################################################
#
##   Nettoyage
\rm -r ${source}
#
cd ${LMDlibf}/..
\rm -f makefile
for i in 1ere 2eme 3eme ; do
   echo 1ere compilation : makegcm -d 39 -p 1d lmdz1d
   ./makegcm -d 39 -p 1d lmdz1d
done
if [ -f lmdz1d.e ]
then
 echo Compilation russie
 ln -s `pwd`/lmdz1d.e ${LMDGCM}/1dcases/ayotte
 ln -s `pwd`/lmdz1d.e ${LMDGCM}/1dcases/case_e
 ln -s `pwd`/lmdz1d.e ${LMDGCM}/1dcases/eq_rd_cv
 ln -s `pwd`/lmdz1d.e ${LMDGCM}/1dcases/hapex92_init
 ln -s `pwd`/lmdz1d.e ${LMDGCM}/1dcases/rico
 ln -s `pwd`/lmdz1d.e ${LMDGCM}/1dcases/toga
 ln -s `pwd`/lmdz1d.e ${LMDGCM}/1dcases/twpice
else
 echo La compilation a chou
 stop
fi
#
echo ========================
echo '   Simulation test 1D'
echo ========================
##echo Execution d un cas d equilibre radiatif-convectif
##cd ${LMDGCM}/1dcases/eq_rd_cv
##./xqt.x NPv3.1
##echo Si la derniere ligne avant \"SIMULATION FINISHED\" est \"Everything is cool!\", alors la simulation a reussi.
echo Execution de case_e
cd ${LMDGCM}/1dcases/case_e
./xqt.x NPv3.1
echo Si la derniere ligne avant \"SIMULATION FINISHED\" est \"Everything is cool!\", alors la simulation a reussi.
##echo Execution du cas Hapex92_init
##cd ${LMDGCM}/1dcases/hapex92_init
##./xqt.x NPv3.1
##echo Si la derniere ligne avant \"SIMULATION FINISHED\" est \"Everything is cool!\", alors la simulation a reussi.
echo 'Execution d une partie de Toga (1mois)'
cd ${LMDGCM}/1dcases/toga
./xqt.x NPv3.1
echo Si la derniere ligne avant \"SIMULATION FINISHED\" est \"Everything is cool!\", alors la simulation a reussi.
echo Execution de arm_cu


armcu=0
if [ $armcu=1 ] ; then
cd ${LMDGCM}/1dcases/arm_cu
./compile.x ; ./compile.x ; ./compile.x
ln -s lmdz1d_L40.e lmdz1d.e
./xqt.x NPv3.1
echo Si la derniere ligne avant \"SIMULATION FINISHED\" est \"Everything is cool!\", alors la simulation a reussi.
fi



