!---------------------------------------------------------------------
! Interpolation forcing in time and onto model levels
!---------------------------------------------------------------------
      if (forcing_GCSSold) then

       call get_uvd(it,timestep,fich_gcssold_ctl,fich_gcssold_dat,
     :               ht_gcssold,hq_gcssold,hw_gcssold,
     :               hu_gcssold,hv_gcssold,
     :               hthturb_gcssold,hqturb_gcssold,Ts_gcssold,
     :               imp_fcg_gcssold,ts_fcg_gcssold,
     :               Tp_fcg_gcssold,Turb_fcg_gcssold)
       if (prt_level.ge.1) then
         print *,' get_uvd -> hqturb_gcssold ',it,hqturb_gcssold
       endif
! large-scale forcing :
!!!      tsurf = ts_gcssold
      do l = 1, llm
!       u(l) = hu_gcssold(l) !  on prescrit le vent
!       v(l) = hv_gcssold(l)    !  on prescrit le vent
!       omega(l) = hw_gcssold(l)
!       rho(l)  = play(l)/(rd*temp(l)*(1.+(rv/rd-1.)*q(l,1)))
!       omega2(l)=-rho(l)*omega(l)
       omega(l) = hw_gcssold(l)
       omega2(l)= omega(l)/rg*airefi ! flxmass_w calcule comme ds physiq

       alpha = rd*temp(l)*(1.+(rv/rd-1.)*q(l,1))/play(l)
       d_th_adv(l) = ht_gcssold(l)
       d_q_adv(l,1) = hq_gcssold(l)
       dt_cooling(l) = 0.0
      enddo

      endif ! forcing_GCSSold
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!---------------------------------------------------------------------
! Interpolation Toga forcing 
!---------------------------------------------------------------------
      if (forcing_toga) then

       if (prt_level.ge.1) then
        print*,
     : '#### ITAP,day,day1,(day-day1)*86400,(day-day1)*86400/dt_toga=',
     :    day,day1,(day-day1)*86400.,(day-day1)*86400/dt_toga
       endif

! time interpolation:
        CALL interp_toga_time(daytime,day1,annee_ref
     i             ,year_ini_toga,day_ju_ini_toga,nt_toga,dt_toga
     i             ,nlev_toga,ts_toga,plev_toga,t_toga,q_toga,u_toga
     i             ,v_toga,w_toga,ht_toga,vt_toga,hq_toga,vq_toga
     o             ,ts_prof,plev_prof,t_prof,q_prof,u_prof,v_prof,w_prof
     o             ,ht_prof,vt_prof,hq_prof,vq_prof)

        if (type_ts_forcing.eq.1) ts_cur = ts_prof ! SST used in read_tsurf1d

! vertical interpolation:
      CALL interp_toga_vertical(play,nlev_toga,plev_prof
     :         ,t_prof,q_prof,u_prof,v_prof,w_prof
     :         ,ht_prof,vt_prof,hq_prof,vq_prof
     :         ,t_mod,q_mod,u_mod,v_mod,w_mod
     :         ,ht_mod,vt_mod,hq_mod,vq_mod,mxcalc)

! large-scale forcing :
      tsurf = ts_prof
      do l = 1, llm
       u(l) = u_mod(l) ! sb: on prescrit le vent
       v(l) = v_mod(l) ! sb: on prescrit le vent
!       omega(l) = w_prof(l)
!       rho(l)  = play(l)/(rd*temp(l)*(1.+(rv/rd-1.)*q(l,1)))
!       omega2(l)=-rho(l)*omega(l)
       omega(l) = w_mod(l)
       omega2(l)= omega(l)/rg*airefi ! flxmass_w calcule comme ds physiq

       alpha = rd*temp(l)*(1.+(rv/rd-1.)*q(l,1))/play(l)
       d_th_adv(l) = alpha*omega(l)/rcpd-(ht_mod(l)+vt_mod(l))
       d_q_adv(l,1) = -(hq_mod(l)+vq_mod(l))
       dt_cooling(l) = 0.0
      enddo

      endif ! forcing_toga
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!---------------------------------------------------------------------
! Interpolation forcing TWPice
!---------------------------------------------------------------------
      if (forcing_twpice) then

        print*,
     : '#### ITAP,day,day1,(day-day1)*86400,(day-day1)*86400/dt_twpi=',
     :    daytime,day1,(daytime-day1)*86400.,
     :    (daytime-day1)*86400/dt_twpi

! time interpolation:
        CALL interp_toga_time(daytime,day1,annee_ref
     i       ,year_ini_twpi,day_ju_ini_twpi,nt_twpi,dt_twpi,nlev_twpi
     i       ,ts_twpi,plev_twpi,t_twpi,q_twpi,u_twpi,v_twpi,w_twpi
     i       ,ht_twpi,vt_twpi,hq_twpi,vq_twpi
     o       ,ts_proftwp,plev_proftwp,t_proftwp,q_proftwp,u_proftwp
     o       ,v_proftwp,w_proftwp
     o       ,ht_proftwp,vt_proftwp,hq_proftwp,vq_proftwp)

! vertical interpolation:
      CALL interp_toga_vertical(play,nlev_twpi,plev_proftwp
     :         ,t_proftwp,q_proftwp,u_proftwp,v_proftwp,w_proftwp
     :         ,ht_proftwp,vt_proftwp,hq_proftwp,vq_proftwp
     :         ,t_mod,q_mod,u_mod,v_mod,w_mod
     :         ,ht_mod,vt_mod,hq_mod,vq_mod,mxcalc)


!calcul de l'advection verticale a partir du omega
cCalcul des gradients verticaux
cinitialisation
      d_t_z(:)=0.
      d_q_z(:)=0.
      d_t_dyn_z(:)=0.
      d_q_dyn_z(:)=0.
      DO l=2,llm-1
       d_t_z(l)=(temp(l+1)-temp(l-1))
     &          /(play(l+1)-play(l-1))
       d_q_z(l)=(q(l+1,1)-q(l-1,1))
     &          /(play(l+1)-play(l-1))
      ENDDO
      d_t_z(1)=d_t_z(2)
      d_q_z(1)=d_q_z(2)
      d_t_z(llm)=d_t_z(llm-1)
      d_q_z(llm)=d_q_z(llm-1)

cCalcul de l advection verticale
      d_t_dyn_z(:)=w_mod(:)*d_t_z(:)
      d_q_dyn_z(:)=w_mod(:)*d_q_z(:)

!wind nudging above 500m with a 2h time scale
        do l=1,llm
        if (nudge_wind) then
!           if (phi(l).gt.5000.) then
        if (phi(l).gt.0.) then
        u(l)=u(l)
     .      +timestep*(u_mod(l)-u(l))/(2.*3600.)
        v(l)=v(l) 
     .      +timestep*(v_mod(l)-v(l))/(2.*3600.)
           endif    
        else
        u(l) = u_mod(l) 
        v(l) = v_mod(l)
        endif
        enddo

!CR:nudging of q and theta with a 6h time scale above 15km
        if (nudge_thermo) then
        do l=1,llm
           zz(l)=phi(l)/9.8
           if ((zz(l).le.16000.).and.(zz(l).gt.15000.)) then
             zfact=(zz(l)-15000.)/1000.
        q(l,1)=q(l,1)
     .      +timestep*(q_mod(l)-q(l,1))/(6.*3600.)*zfact
        temp(l)=temp(l) 
     .      +timestep*(t_mod(l)-temp(l))/(6.*3600.)*zfact
           else if (zz(l).gt.16000.) then 
        q(l,1)=q(l,1)
     .      +timestep*(q_mod(l)-q(l,1))/(6.*3600.)
        temp(l)=temp(l) 
     .      +timestep*(t_mod(l)-temp(l))/(6.*3600.)
           endif
        enddo    
        endif

      do l = 1, llm
       omega(l) = w_mod(l)
       omega2(l)= omega(l)/rg*airefi ! flxmass_w calcule comme ds physiq
       alpha = rd*temp(l)*(1.+(rv/rd-1.)*q(l,1))/play(l)
!calcul de l'advection totale
        if (cptadvw) then
        d_th_adv(l) = alpha*omega(l)/rcpd+ht_mod(l)-d_t_dyn_z(l)
!        print*,'temp vert adv',l,ht_mod(l),vt_mod(l),-d_t_dyn_z(l)
        d_q_adv(l,1) = hq_mod(l)-d_q_dyn_z(l)
!        print*,'q vert adv',l,hq_mod(l),vq_mod(l),-d_q_dyn_z(l)
        else
        d_th_adv(l) = alpha*omega(l)/rcpd+(ht_mod(l)+vt_mod(l))
        d_q_adv(l,1) = (hq_mod(l)+vq_mod(l))
        endif
       dt_cooling(l) = 0.0
      enddo

      endif ! forcing_twpice
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!---------------------------------------------------------------------
! Interpolation forcing Rico
!---------------------------------------------------------------------
      if (forcing_rico) then
!       call lstendH(llm,omega,dt_dyn,dq_dyn,du_dyn, dv_dyn,
!     :  q,temp,u,v,play)
       call lstendH(llm,nqtot,omega,dt_dyn,dq_dyn,
     :  q,temp,u,v,play)

        do l=1,llm
       d_th_adv(l) =  (dth_rico(l) +  dt_dyn(l))
       d_q_adv(l,1) = (dqh_rico(l) +  dq_dyn(l,1))
       d_q_adv(l,2) = 0.
        enddo
      endif  ! forcing_rico
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!---------------------------------------------------------------------
! Interpolation forcing Arm_cu
!---------------------------------------------------------------------
      if (forcing_armcu) then

        print*,
     : '#### ITAP,day,day1,(day-day1)*86400,(day-day1)*86400/dt_armcu=',
     :    day,day1,(day-day1)*86400.,(day-day1)*86400/dt_armcu

! time interpolation:
! ATTENTION, cet appel ne convient pas pour TOGA !!
! revoir 1DUTILS.h et les arguments
      CALL interp_armcu_time(daytime,day1,annee_ref
     i            ,year_ini_armcu,day_ju_ini_armcu,nt_armcu,dt_armcu
     i            ,nlev_armcu,sens_armcu,flat_armcu,adv_theta_armcu
     i            ,rad_theta_armcu,adv_qt_armcu,sens_prof,flat_prof
     i            ,adv_theta_prof,rad_theta_prof,adv_qt_prof)

! vertical interpolation:
! No vertical interpolation if nlev imposed to 19 or 40

! For this case, fluxes are imposed
       fsens=-1*sens_prof
       flat=-1*flat_prof

! Advective forcings are given in K or g/kg ... BY HOUR
      do l = 1, llm
       ug(l)= u_mod(l)
       vg(l)= v_mod(l)
       IF((phi(l)/RG).LT.1000) THEN
         d_th_adv(l) = (adv_theta_prof + rad_theta_prof)/3600.
         d_q_adv(l,1) = adv_qt_prof/1000./3600.
         d_q_adv(l,2) = 0.0
!        print *,'INF1000: phi dth dq1 dq2',
!    :  phi(l)/RG,d_th_adv(l),d_q_adv(l,1),d_q_adv(l,2)
       ELSEIF ((phi(l)/RG).GE.1000.AND.(phi(l)/RG).lt.3000) THEN
         fact=((phi(l)/RG)-1000.)/2000.
         fact=1-fact
         d_th_adv(l) = (adv_theta_prof + rad_theta_prof)*fact/3600.
         d_q_adv(l,1) = adv_qt_prof*fact/1000./3600.
         d_q_adv(l,2) = 0.0
!        print *,'SUP1000: phi fact dth dq1 dq2',
!    :  phi(l)/RG,fact,d_th_adv(l),d_q_adv(l,1),d_q_adv(l,2)
       ELSE
         d_th_adv(l) = 0.0
         d_q_adv(l,1) = 0.0
         d_q_adv(l,2) = 0.0
!        print *,'SUP3000: phi dth dq1 dq2',
!    :  phi(l)/RG,d_th_adv(l),d_q_adv(l,1),d_q_adv(l,2)
       ENDIF
      dt_cooling(l) = 0.0  
!     print *,'Interp armcu: phi dth dq1 dq2',
!    :  l,phi(l),d_th_adv(l),d_q_adv(l,1),d_q_adv(l,2)
      enddo
      endif ! forcing_armcu
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

