!
! $Header$
!
      SUBROUTINE moy_undefSTD(nlevSTD,itap,
     $           dtime,ecrit_day,ecrit_mth,ecrit_hf2mth,
     $           tnondef,tsumSTD)
      USE netcdf
      USE dimphy
      IMPLICIT none
c
c====================================================================
c
c I. Musat : 09.2004
c
c Moyenne - a des frequences differentes - des valeurs bien definies
c         (.NE.1.E+20) des variables interpolees a un niveau de
c         pression.
c 1) les variables de type "day" (nout=1) ou "mth" (nout=2) sont sommees
c    tous les pas de temps de la physique
c
c 2) les variables de type "NMC" (nout=3) sont calculees a partir
c    des valeurs instantannees toutes les 6 heures
c
c
c NB: mettre "inst(X)" dans le write_histXXX.h !
c====================================================================
cym#include "dimensions.h"
cym      integer jjmp1
cym      parameter (jjmp1=jjm+1-1/jjm)
cym#include "dimphy.h"
c
c
c variables Input
      INTEGER nlevSTD, klevSTD, itap
      PARAMETER(klevSTD=17)
      REAL dtime, ecrit_day, ecrit_mth, ecrit_hf2mth
c
c variables locales
      INTEGER i, k, nout
      PARAMETER(nout=3) !nout=1 day/nout=2 mth/nout=3 NMC
c
c variables Output
      REAL tnondef(klon,klevSTD,nout)
      REAL tsumSTD(klon,klevSTD,nout)
c
      REAL missing_val
c
      missing_val=nf90_fill_real
c
c calcul 1 fois par jour
c
      IF(MOD(itap,NINT(ecrit_day/dtime)).EQ.0) THEN
       DO k=1, nlevSTD
        DO i=1, klon
         IF (NINT(tnondef(i,k,1)).NE.NINT(ecrit_day/dtime)) THEN
          tsumSTD(i,k,1)=tsumSTD(i,k,1)/
     $    (ecrit_day/dtime-tnondef(i,k,1))
         ELSE
          tsumSTD(i,k,1)=missing_val
         ENDIF !tnondef
        ENDDO !i
       ENDDO !k
      ENDIF !MOD(itap,ecrit_day).EQ.0
c
c calcul 1 fois par mois
c
      IF(MOD(itap,NINT(ecrit_mth/dtime)).EQ.0) THEN
       DO k=1, nlevSTD
        DO i=1, klon
         IF(tnondef(i,k,2).NE.ecrit_mth/dtime) THEN
          tsumSTD(i,k,2)=tsumSTD(i,k,2)/
     $    (ecrit_mth/dtime-tnondef(i,k,2))
         ELSE
          tsumSTD(i,k,2)=missing_val
         ENDIF !tnondef
c
         IF(tnondef(i,k,3).NE.NINT(ecrit_hf2mth)) THEN
          tsumSTD(i,k,3)=tsumSTD(i,k,3)/
     $    (ecrit_hf2mth-tnondef(i,k,3))
         ELSE
          tsumSTD(i,k,3)=missing_val
         ENDIF !tnondef
c
        ENDDO !i
       ENDDO !k
      ENDIF !MOD
c
      RETURN
      END  
