SUBROUTINE read_map2D(filename, varname, timestep, inverse, varout)
! Open file and read one variable for one timestep.
! Return variable for the given timestep. 
  USE dimphy
  USE netcdf
  USE mod_grid_phy_lmdz
  USE mod_phys_lmdz_para


  IMPLICIT NONE

! Input arguments
  CHARACTER(len=20), INTENT(IN) :: filename     ! name of file to read
  CHARACTER(len=20), INTENT(IN) :: varname      ! name of variable in file
  INTEGER, INTENT(IN)           :: timestep     ! actual timestep
  LOGICAL, INTENT(IN)           :: inverse      ! TRUE if latitude needs to be inversed
! Output argument
  REAL, DIMENSION(klon), INTENT(OUT) :: varout  ! The variable read from file for the given timestep

! Local variables
  INTEGER :: j
  INTEGER :: nid, nvarid, ierr
  INTEGER, DIMENSION(3) :: start, count
  CHARACTER(len=20)     :: modname='read_map2D'

  REAL, DIMENSION(nbp_lon,nbp_lat) :: var_glo2D     ! 2D global 
  REAL, DIMENSION(nbp_lon,nbp_lat) :: var_glo2D_tmp ! 2D global
  REAL, DIMENSION(klon_glo)        :: var_glo1D     ! 1D global


! Read variable from file. Done by master process MPI and master thread OpenMP
  IF (is_mpi_root .AND. is_omp_root) THEN
     ierr = NF90_OPEN (filename, NF90_NOWRITE, nid)
     IF (ierr /= NF90_NOERR) CALL abort_gcm(modname,'Problem in opening file '//filename,1)

     ierr = NF90_INQ_VARID(nid, varname, nvarid)
     IF (ierr /= NF90_NOERR) CALL abort_gcm(modname, 'The variable '//varname//' is absent in file',1)
     
     start=(/1,1,timestep/)
     count=(/nbp_lon,nbp_lat,1/)
     ierr = NF90_GET_VAR(nid, nvarid, var_glo2D,start,count)
     IF (ierr /= NF90_NOERR) CALL abort_gcm(modname, 'Problem in reading varaiable '//varname,1)

     ! Inverse latitude order
     IF (inverse) THEN
        var_glo2D_tmp(:,:) = var_glo2D(:,:)
        DO j=1, nbp_lat
           var_glo2D(:,j) = var_glo2D_tmp(:,nbp_lat-j+1)
        END DO
     END IF

     ! Transform the global field from 2D to 1D
     CALL grid2Dto1D_glo(var_glo2D,var_glo1D)

  ENDIF

! Scatter gloabl 1D variable to all processes
  CALL scatter(var_glo1D, varout)

END SUBROUTINE read_map2D
