

SUBROUTINE AEROPT_5WV(&
   pdel, m_allaer, delt, &
   RHcl, ai, flag_aerosol, &
   pplay, t_seri, &
   tausum, tau)

  USE DIMPHY
  USE aerosol_mod

  !
  !    Yves Balkanski le 12 avril 2006
  !    Celine Deandreis
  !    Anne Cozic  Avril 2009
  !    a partir d'une sous-routine de Johannes Quaas pour les sulfates
  !
  !
  ! Refractive indices for seasalt come from Shettle and Fenn (1979)
  !
  ! Refractive indices from water come from Hale and Querry (1973)
  !
  ! Refractive indices from Ammonium Sulfate Toon and Pollack (1976)
  !
  ! Refractive indices for Dust, internal mixture of minerals coated with 1.5% hematite 
  ! by Volume (Balkanski et al., 2006)
  !
  ! Refractive indices for POM: Kinne (pers. Communication 
  !
  ! Refractive index for BC from Shettle and Fenn (1979)
  !
  ! Shettle, E. P., & Fenn, R. W. (1979), Models for the aerosols of the lower atmosphere and 
  ! the effects of humidity variations on their optical properties, U.S. Air Force Geophysics 
  ! Laboratory Rept. AFGL-TR-79-0214, Hanscomb Air Force Base, MA.
  !
  ! Hale, G. M. and M. R. Querry, Optical constants of water in the 200-nm to 200-m 
  ! wavelength region, Appl. Opt., 12, 555-563, 1973.
  !
  ! Toon, O. B. and J. B. Pollack, The optical constants of several atmospheric aerosol species:
  ! Ammonium sulfate, aluminum oxide, and sodium chloride, J. Geohys. Res., 81, 5733-5748,
  ! 1976.
  !
  ! Balkanski, Y., M. Schulz, T. Claquin And O. Boucher, Reevaluation of mineral aerosol 
  ! radiative forcings suggests a better agreement with satellite and AERONET data, Atmospheric 
  ! Chemistry and Physics Discussions., 6, pp 8383-8419, 2006.
  !
  IMPLICIT NONE
  INCLUDE "YOMCST.h"
  !
  ! Input arguments:
  !
  REAL, DIMENSION(klon,klev), INTENT(in)   :: pdel
  REAL, INTENT(in)                         :: delt
  REAL, DIMENSION(klon,klev,naero_spc), INTENT(in) :: m_allaer
  REAL, DIMENSION(klon,klev), INTENT(in)   :: RHcl     ! humidite relative ciel clair
  INTEGER,INTENT(in)                       :: flag_aerosol
  REAL, DIMENSION(klon,klev), INTENT(in)   :: pplay
  REAL, DIMENSION(klon,klev), INTENT(in)   :: t_seri
  !
  ! Output arguments:
  !
  REAL, DIMENSION(klon), INTENT(out)          :: ai      ! POLDER aerosol index 
  REAL, DIMENSION(klon,nwave,naero_spc), INTENT(out)      :: tausum
  REAL, DIMENSION(klon,klev,nwave,naero_spc), INTENT(out) :: tau


  !
  ! Local
  !
  INTEGER, PARAMETER :: las = nwave
  LOGICAL :: soluble
  
  INTEGER :: i, k, m
  INTEGER :: spsol, spinsol, la
  INTEGER :: RH_num
  INTEGER, PARAMETER :: la443 = 1
  INTEGER, PARAMETER :: la550 = 2
  INTEGER, PARAMETER :: la670 = 3
  INTEGER, PARAMETER :: la765 = 4
  INTEGER, PARAMETER :: la865 = 5
  INTEGER, PARAMETER :: nbre_RH=12
  INTEGER, PARAMETER :: nbsol_compaer=5   ! 1- Seasalt AS: 2- Sesalt CS; 3- BC soluble; 4- POM soluble; 5- SO4.
  INTEGER, PARAMETER :: nbinsol_compaer=3 ! 1- Dust; 2- BC insoluble; 3- POM insoluble
  REAL :: zrho
  REAL :: RH_tab(nbre_RH)
  REAL :: DELTA, rh 
  REAL :: tau_ae5wv_int(KLON,KLEV,las) ! Intermediate computation of epaisseur optique aerosol
  REAL :: piz_ae5wv_int(KLON,KLEV,las) ! Intermediate single scattering albedo aerosol
  REAL :: cg_ae5wv_int(KLON,KLEV,las)  ! Intermediate asymmetry parameter aerosol
  REAL, PARAMETER :: RH_MAX=95.
  DATA RH_tab/0.,10.,20.,30.,40.,50.,60.,70.,80.,85.,90.,95./
  REAL :: taue670(KLON)       ! epaisseur optique aerosol absorption 550 nm
  REAL :: taue865(KLON)       ! epaisseur optique aerosol extinction 865 nm
  REAL :: fac
  REAL :: zdp1(klon,klev) 
  REAL, PARAMETER ::  gravit = 9.80616    ! m2/s
  INTEGER, ALLOCATABLE, DIMENSION(:)  :: aerosol_name
  INTEGER :: nb_aer
  
  REAL :: tau3d(KLON,KLEV), piz3d(KLON,KLEV), cg3d(KLON,KLEV)
  REAL :: abs3d(KLON,KLEV)     ! epaisseur optique d'absorption

  
  REAL :: alpha_aers_5wv(nbre_RH,las,nbsol_compaer)   ! ext. coeff. Soluble comp. units *** m2/g 
                                                      ! 1- Seasalt AS: 2- Sesalt CS; 3- BC; 4- POM; 5- SO4.
  REAL :: alpha_aeri_5wv(las,nbinsol_compaer)         ! ext. coeff. Insoluble comp. 1- Dust: 2- BC; 3- POM
  REAL :: cg_aers_5wv(nbre_RH,las,nbsol_compaer)      ! Asym. param. soluble comp. 
                                                      ! 1- Seasalt AS: 2- Sesalt CS; 3- BC; 4- POM; 5- SO4.
  REAL :: cg_aeri_5wv(las,nbinsol_compaer)            ! Asym. param. insoluble comp. 1- Dust: 2- BC; 3- POM
  REAL :: piz_aers_5wv(nbre_RH,las,nbsol_compaer)   
                                                      ! 1- Seasalt AS: 2- Sesalt CS; 3- BC; 4- POM; 5- SO4.
  REAL :: piz_aeri_5wv(las,nbinsol_compaer)           ! Insoluble comp. 1- Dust: 2- BC; 3- POM

  REAL, DIMENSION(klon,klev,naero_spc) :: mass_temp
  
  !
  ! Proprietes optiques
  !
  REAL :: radry = 287.054                     ! dry air mass constant

  !
  ! 
  !
  ! From here on we look at the optical parameters at 5 wavelengths: 
  ! 443nm, 550, 670, 765 and 865 nm
  !                                   le 12 AVRIL 2006
  ! 
  DATA alpha_aers_5wv/ &
     ! seasalt soluble CS
     0.50,0.90,1.05,1.21,1.40,2.41, &
     2.66,3.11,3.88,4.52,5.69,8.84, &
     0.51,0.92,1.07,1.23,1.42,2.45, &
     2.70,3.16,3.94,4.58,5.76,8.94, & 
     0.52,0.93,1.08,1.24,1.43,2.47, &
     2.73,3.20,3.99,4.64,5.84,9.04, &
     0.52,0.93,1.09,1.25,1.44,2.50, &
     2.76,3.23,4.03,4.68,5.89,9.14, &
     0.52,0.94,1.09,1.26,1.45,2.51, &
     2.78,3.25,4.06,4.72,5.94,9.22, &
     ! seasalt soluble AS
     4.28, 7.17, 8.44, 9.85,11.60,22.44,  &
     25.34,30.54,39.38,46.52,59.33,91.77, &
     3.40, 5.67, 6.69, 7.85, 9.32,19.03,  &
     21.78,26.88,35.87,43.40,57.33,93.43, &
     2.48, 4.22, 5.02, 5.94, 7.11,15.29,  &
     17.70,22.31,30.73,38.06,52.15,90.59, &
     1.90, 3.29, 3.94, 4.69, 5.65, 12.58, &
     14.68,18.77,26.41,33.25,46.77,85.50, &
     1.47, 2.59, 3.12, 3.74, 4.54, 10.42, &
     12.24,15.82,22.66,28.91,41.54,79.33, &
     ! bc soluble
     7.930,7.930,7.930,7.930,7.930,7.930,     &
     7.930,7.930,10.893,12.618,14.550,16.613, &
     7.658,7.658,7.658,7.658,7.658,7.658,     &
     7.658,7.658,10.351,11.879,13.642,15.510, &
     7.195,7.195,7.195,7.195,7.195,7.195,     &
     7.195,7.195,9.551,10.847,12.381,13.994,  &
     6.736,6.736,6.736,6.736,6.736,6.736,     &
     6.736,6.736,8.818,9.938,11.283,12.687,   &
     6.277,6.277,6.277,6.277,6.277,6.277,     &
     6.277,6.277,8.123,9.094,10.275,11.501,   &
     ! pom soluble
     6.676,6.676,6.676,6.676,6.710,6.934,   &
     7.141,7.569,8.034,8.529,9.456,10.511,  &
     5.109,5.109,5.109,5.109,5.189,5.535,   &
     5.960,6.852,8.008,9.712,12.897,19.676, &
     3.718,3.718,3.718,3.718,3.779,4.042,   &
     4.364,5.052,5.956,7.314,9.896,15.688,  &
     2.849,2.849,2.849,2.849,2.897,3.107,   &
     3.365,3.916,4.649,5.760,7.900,12.863,  &
     2.229,2.229,2.229,2.229,2.268,2.437,   &
     2.645,3.095,3.692,4.608,6.391,10.633,  &
     ! Sulfate
     5.751,6.215,6.690,7.024,7.599,8.195,      &
     9.156,10.355,12.660,14.823,18.908,24.508, &
     4.320,4.675,5.052,5.375,5.787,6.274,      &
     7.066,8.083,10.088,12.003,15.697,21.133,  &
     3.079,3.351,3.639,3.886,4.205,4.584,      &
     5.206,6.019,7.648,9.234,12.391,17.220,    &
     2.336,2.552,2.781,2.979,3.236,3.540,      &
     4.046,4.711,6.056,7.388,10.093,14.313,    &
     1.777,1.949,2.134,2.292,2.503,2.751,      &
     3.166,3.712,4.828,5.949,8.264,11.922/

  DATA alpha_aeri_5wv/ &
     ! dust insoluble
     0.759, 0.770, 0.775, 0.775, 0.772, &
     !!jb bc insoluble
     11.536,10.033, 8.422, 7.234, 6.270, &
     ! pom insoluble
     5.042, 3.101, 1.890, 1.294, 0.934/

  DATA cg_aers_5wv/ & 
     ! seasalt soluble (CS)
     0.730,0.753,0.760,0.766,0.772,0.793, &
     0.797,0.802,0.809,0.813,0.820,0.830, &
     0.719,0.744,0.751,0.757,0.764,0.786, &
     0.791,0.796,0.803,0.808,0.815,0.826, &
     0.721,0.744,0.750,0.756,0.762,0.784, &
     0.787,0.793,0.800,0.804,0.811,0.822, &
     0.717,0.741,0.747,0.753,0.759,0.780, &
     0.784,0.789,0.795,0.800,0.806,0.817, &
     0.715,0.739,0.745,0.751,0.757,0.777, & 
     0.781,0.786,0.793,0.797,0.803,0.814, &
     ! seasalt soluble (AS)
     0.698,0.722,0.729,0.736,0.743,0.765, &
     0.768,0.773,0.777,0.779,0.781,0.779, &
     0.682,0.710,0.719,0.727,0.735,0.764, &
     0.769,0.776,0.783,0.787,0.791,0.792, &
     0.658,0.691,0.701,0.710,0.720,0.756, &
     0.763,0.771,0.782,0.788,0.795,0.801, &
     0.632,0.668,0.679,0.690,0.701,0.743, &
     0.750,0.762,0.775,0.783,0.792,0.804, &
     0.605,0.644,0.656,0.669,0.681,0.729, &
     0.737,0.750,0.765,0.775,0.787,0.803, &
     ! bc soluble
     .651, .651, .651, .651, .651, .651, &
     .651, .651, .738, .764, .785, .800, &
     .597, .597, .597, .597, .597, .597, &
     .597, .597, .695, .725, .751, .770, &
     .543, .543, .543, .543, .543, .543, &
     .543, .543, .650, .684, .714, .736, & 
     .504, .504, .504, .504, .504, .504, &
     .504, .504, .614, .651, .683, .708, & 
     .469, .469, .469, .469, .469, .469, &
     .469, .469, .582, .620, .655, .681, &
     ! pom soluble
     .679, .679, .679, .679, .683, .691, &
     .703, .720, .736, .751, .766, .784, &
     .656, .656, .656, .656, .659, .669, &
     .681, .699, .717, .735, .750, .779, & 
     .623, .623, .623, .623, .627, .637, &
     .649, .668, .688, .709, .734, .762, &
     .592, .592, .592, .592, .595, .605, &
     .618, .639, .660, .682, .711, .743, &
     .561, .561, .561, .561, .565, .575, &
     .588, .609, .632, .656, .688, .724, &
     ! sulfate
     .671, .684, .697, .704, .714, .723, &
     .734, .746, .762, .771, .781, .789, &
     .653, .666, .678, .687, .697, .707, &
     .719, .732, .751, .762, .775, .789, &
     .622, .635, .648, .657, .667, .678, &
     .691, .705, .728, .741, .758, .777, &
     .591, .604, .617, .627, .638, .650, &
     .664, .679, .704, .719, .739, .761, &
     .560, .574, .587, .597, .609, .621, & 
     .637, .653, .680, .697, .719, .745/
  !

  DATA cg_aeri_5wv/&
     ! dust insoluble
     0.714, 0.697, 0.688, 0.683, 0.679, &
     ! bc insoluble
     0.511, 0.445, 0.384, 0.342, 0.307, &
     !c pom insoluble
     0.596, 0.536, 0.466, 0.409, 0.359/
  !
  DATA piz_aers_5wv/&
     ! seasalt soluble (CS)
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     ! seasalt soluble (AS)
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     ! bc soluble
     .445, .445, .445, .445, .445, .445, &
     .445, .445, .470, .487, .508, .531, &
     .442, .442, .442, .442, .442, .442, &
     .442, .442, .462, .481, .506, .533, &
     .427, .427, .427, .427, .427, .427, &
     .427, .427, .449, .470, .497, .526, &
     .413, .413, .413, .413, .413, .413, &
     .413, .413, .437, .458, .486, .516, &
     .399, .399, .399, .399, .399, .399, &
     .399, .399, .423, .445, .473, .506, &
     ! pom soluble
     .975, .975, .975, .975, .975, .977, &
     .979, .982, .984, .987, .990, .994, &
     .972, .972, .972, .972, .973, .974, &
     .977, .980, .983, .986, .989, .993, &
     .963, .963, .963, .963, .964, .966, &
     .969, .974, .977, .982, .986, .991, &
     .955, .955, .955, .955, .955, .958, &
     .962, .967, .972, .977, .983, .989, &
     .944, .944, .944, .944, .944, .948, &
     .952, .959, .962, .972, .979, .987, &
     ! sulfate
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000, &
     1.000,1.000,1.000,1.000,1.000,1.000/
  !
  DATA piz_aeri_5wv/&
     ! dust insoluble
     0.944, 0.970, 0.977, 0.982, 0.987, &
     ! bc insoluble
     0.415, 0.387, 0.355, 0.328, 0.301, &
     ! pom insoluble
     0.972, 0.963, 0.943, 0.923, 0.897/

  ! Initialisations
  ai(:) = 0.
  tau_ae5wv_int(:,:,:) = 0.
  piz_ae5wv_int(:,:,:) = 0.
  cg_ae5wv_int(:,:,:)  = 0.
  tausum(:,:,:) = 0.
  tau(:,:,:,:)  = 0.


  DO k=1, klev
    DO i=1, klon
      IF (t_seri(i,k).EQ.0) stop 'stop aeropt_5wv T '
      IF (pplay(i,k).EQ.0) stop  'stop aeropt_5wv p '

      zrho=pplay(i,k)/t_seri(i,k)/RD                  ! kg/m3
      mass_temp(i,k,:) = m_allaer(i,k,:) / zrho / 1.e+9

    ENDDO
  ENDDO


  IF (flag_aerosol .EQ. 1) THEN 
     nb_aer = 1
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASSO4M
  ELSEIF (flag_aerosol .EQ. 2) THEN
     nb_aer = 2
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASBCM
     aerosol_name(2) = id_AIBCM
  ELSEIF (flag_aerosol .EQ. 3) THEN 
     nb_aer = 2
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASPOMM
     aerosol_name(2) = id_AIPOMM
  ELSEIF (flag_aerosol .EQ. 4) THEN 
     nb_aer = 3
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_CSSSM
     aerosol_name(2) = id_SSSSM
     aerosol_name(3) = id_ASSSM
  ELSEIF (flag_aerosol .EQ. 5) THEN 
     nb_aer = 1
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_CIDUSTM
  ELSEIF (flag_aerosol .EQ. 6) THEN 
     nb_aer = 9
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASSO4M      
     aerosol_name(2) = id_ASBCM
     aerosol_name(3) = id_AIBCM
     aerosol_name(4) = id_ASPOMM
     aerosol_name(5) = id_AIPOMM
     aerosol_name(6) = id_CSSSM
     aerosol_name(7) = id_SSSSM
     aerosol_name(8) = id_ASSSM
     aerosol_name(9) = id_CIDUSTM
  ENDIF

  ! 
  ! loop over modes, use of precalculated nmd and corresponding sigma
  !    loop over wavelengths
  !    for each mass species in mode
  !      interpolate from Sext to retrieve Sext_at_gridpoint_per_species
  !      compute optical_thickness_at_gridpoint_per_species
  

  !
  ! Calculations that need to be done since we are not in the subroutines INCA
  !      
  ! air mass auxiliary  variable --> zdp1 [kg/(m^2 *s)]
  zdp1=pdel(:,:)/(gravit*delt) 
  
  DO m=1,nb_aer   ! tau is only computed for each mass
    
    fac=1.0
    IF (aerosol_name(m).EQ.id_SSSSM) THEN   ! for now
        soluble=.TRUE.
        spsol=1
    ELSEIF (aerosol_name(m).EQ.id_CSSSM) THEN 
        soluble=.TRUE.
        spsol=1
    ELSEIF (aerosol_name(m).EQ.id_ASSSM) THEN
        soluble=.TRUE.
        spsol=2
    ELSEIF (aerosol_name(m).EQ.id_ASBCM) THEN
        soluble=.TRUE.
        spsol=3
    ELSEIF (aerosol_name(m).EQ.id_ASPOMM) THEN 
        soluble=.TRUE.
        spsol=4 
    ELSEIF ((aerosol_name(m).EQ.id_ASSO4M) .OR.  (aerosol_name(m).EQ.id_CSSO4M)) THEN
        soluble=.TRUE.
        spsol=5
        fac=1.375    ! (NH4)2-SO4/SO4 132/96 mass conversion factor for OD
    ELSEIF     (aerosol_name(m).EQ.id_CIDUSTM) THEN 
        soluble=.FALSE.
        spinsol=1
    ELSEIF  (aerosol_name(m).EQ.id_AIBCM) THEN 
        soluble=.FALSE.
        spinsol=2
    ELSEIF (aerosol_name(m).EQ.id_AIPOMM) THEN 
        soluble=.FALSE.
        spinsol=3
    ELSE 
        CYCLE
    ENDIF
    
    DO la=1,las
      tau3d(:,:)=0.
      piz3d(:,:)=0.
      cg3d(:,:)=0.
      abs3d(:,:)=0.
      
      DO k=1, KLEV
        DO i=1, KLON
          
          rh=MIN(RHcl(i,k)*100.,RH_MAX)
          RH_num = INT( rh/10. + 1.)
          
          IF (rh.GT.85.) RH_num=10
          IF (rh.GT.90.) RH_num=11
          DELTA=(rh-RH_tab(RH_num))/(RH_tab(RH_num+1)-RH_tab(RH_num))
          
          IF (soluble) THEN
              tau_ae5wv_int(i,k,la) = &
                 alpha_aers_5wv(RH_num,la,spsol)+DELTA* &
                 (alpha_aers_5wv(RH_num+1,la,spsol) - & 
                 alpha_aers_5wv(RH_num,la,spsol))
              
              piz_ae5wv_int(i,k,la) = &
                 piz_aers_5wv(RH_num,la,spsol)+DELTA* &
                 (piz_aers_5wv(RH_num+1,la,spsol) - & 
                 piz_aers_5wv(RH_num,la,spsol))
              
              cg_ae5wv_int(i,k,la) = &
                 cg_aers_5wv(RH_num,la,spsol)+DELTA* & 
                 (cg_aers_5wv(RH_num+1,la,spsol) - & 
                 cg_aers_5wv(RH_num,la,spsol))
              
              tau3d(i,k) = &
                 mass_temp(i,k,spsol)*1000.*zdp1(i,k)*tau_ae5wv_int(i,k,la)*delt*fac

          ELSE
              tau_ae5wv_int(i,k,la) = alpha_aeri_5wv(la,spinsol)
              piz_ae5wv_int(i,k,la) = piz_aeri_5wv(la,spinsol)
              cg_ae5wv_int(i,k,la)  = cg_aeri_5wv(la,spinsol)

              tau3d(i,k) = &
                 mass_temp(i,k,5+spinsol)*1000.*zdp1(i,k)*tau_ae5wv_int(i,k,la)*delt*fac
          ENDIF
          
          
        ENDDO     ! Boucle sur les points gographiques (grille horizontale)
      ENDDO     ! Boucle sur les niveaux verticaux

      IF (soluble) THEN

          tau(:,:,la,spsol)=tau3d(:,:)
      
          DO k=1, KLEV
            DO i=1,KLON
              tausum(i,la,spsol)=tausum(i,la,spsol)+tau3d(i,k)
            ENDDO
          ENDDO
      ELSE
          tau(:,:,la,spsol)=tau3d(:,:)
      
          DO k=1, KLEV
            DO i=1,KLON
              tausum(i,la,5+spinsol)=tausum(i,la,5+spinsol)+tau3d(i,k)
            ENDDO
          ENDDO
      ENDIF



    ENDDO   ! boucle sur les longueurs d'onde
  ENDDO     ! Boucle  sur les masses de traceurs
!
!
!  taue670(:) = SUM(tausum(:,la670,:),dim=2) 
!  taue865(:) = SUM(tausum(:,la865,:),dim=2) 
!
!  DO i=1, klon
!    ai(i)=-LOG(MAX(taue670(i),0.0001)/ &
!       MAX(taue865(i),0.0001))/LOG(670./865.)
!  ENDDO

  DEALLOCATE(aerosol_name) 
  
END SUBROUTINE AEROPT_5WV
