SUBROUTINE AEROPT_2BANDS( &
     pdel, m_allaer, delt, RHcl, &
     tau_allaer, piz_allaer, &
     cg_allaer, fractnat_allaer, &
     flag_aerosol, pplay, t_seri)

  USE dimphy
  USE aerosol_mod

  !    Yves Balkanski le 12 avril 2006
  !    Celine Deandreis
  !    Anne Cozic Avril 2009
  !    a partir d'une sous-routine de Johannes Quaas pour les sulfates
  !
  IMPLICIT NONE

  INCLUDE "YOMCST.h"
  INCLUDE "iniprint.h"

  !
  ! Input arguments:
  !
  REAL,                           INTENT(in)  :: pdel(KLON,KLEV)
  REAL,                           INTENT(in)  :: delt
  REAL, DIMENSION(klon,klev,naero_spc),   INTENT(in)  :: m_allaer
  REAL,                           INTENT(in)  :: RHcl(KLON,KLEV)     ! humidite relative ciel clair
  REAL, DIMENSION(klon,naero_tot),INTENT(in)  :: fractnat_allaer
  INTEGER,                        INTENT(in)  :: flag_aerosol
  REAL,                           INTENT(in)  :: pplay(klon,klev)
  REAL,                           INTENT(in)  :: t_seri(klon,klev)

  !
  ! Output arguments:
  !
  REAL, DIMENSION(klon,klev,naero_grp,nbands), INTENT(out) :: tau_allaer ! epaisseur optique aerosol
  REAL, DIMENSION(klon,klev,naero_grp,nbands), INTENT(out) :: piz_allaer ! single scattering albedo aerosol
  REAL, DIMENSION(klon,klev,naero_grp,nbands), INTENT(out) :: cg_allaer  ! asymmetry parameter aerosol

  !
  ! Local
  !
  REAL, DIMENSION(klon,klev,naero_tot,nbands) ::  tau_ae
  REAL, DIMENSION(klon,klev,naero_tot,nbands) ::  piz_ae
  REAL, DIMENSION(klon,klev,naero_tot,nbands) ::  cg_ae
  LOGICAL ::  soluble
  INTEGER :: i, k, inu, m, mrfspecies
  INTEGER :: spsol, spinsol
  INTEGER :: RH_num, nbre_RH, nbsol_compaer, nbinsol_compaer

  PARAMETER (nbre_RH=12)
  PARAMETER (nbsol_compaer=5)        ! 1- Seasalt AS; 2- Sesalt CS; 3- BC soluble; 4- POM soluble; 5- SO4.
  PARAMETER (nbinsol_compaer=3)      ! 1- Dust; 2- BC insoluble; 3- POM insoluble
  REAL:: RH_tab(nbre_RH)
  REAL:: RH_MAX, DELTA, rh 
  REAL:: tau_ae2b_int(KLON,KLEV,nbands)   ! Intermediate computation of epaisseur optique aerosol
  REAL:: piz_ae2b_int(KLON,KLEV,nbands)   ! Intermediate computation of Single scattering albedo
  REAL:: cg_ae2b_int(KLON,KLEV,nbands)    ! Intermediate computation of Assymetry parameter
  PARAMETER (RH_MAX=95.)
  DATA RH_tab/0.,10.,20.,30.,40.,50.,60.,70.,80.,85.,90.,95./
  REAL :: zrho
  REAL :: fac
  REAL :: zdp1(klon,klev) 
  REAL, PARAMETER ::  gravit = 9.80616    ! m2/s
  INTEGER, ALLOCATABLE, DIMENSION(:)   :: aerosol_name
  INTEGER :: nb_aer
  REAL, DIMENSION(klon,klev,naero_spc) :: mass_temp

  !
  ! Proprietes optiques
  !
  REAL:: alpha_aers_2bands(nbre_RH,nbands,nbsol_compaer)   !--unit m2/g SO4
  REAL:: alpha_aeri_2bands(nbands,nbinsol_compaer)
  REAL:: cg_aers_2bands(nbre_RH,nbands,nbsol_compaer)      !--unit 
  REAL:: cg_aeri_2bands(nbands,nbinsol_compaer)
  REAL:: piz_aers_2bands(nbre_RH,nbands,nbsol_compaer)     !-- unit
  REAL:: piz_aeri_2bands(nbands,nbinsol_compaer)           !-- unit


  spsol = 0
  spinsol = 0 


  DATA alpha_aers_2bands/  & 
       ! seasalt soluble Coarse Soluble (CS)
       0.5090,0.6554,0.7129,0.7767,0.8529,1.2728, & 
       1.3820,1.5792,1.9173,2.2002,2.7173,4.1487, & 
       0.5167,0.6613,0.7221,0.7868,0.8622,1.3027, & 
       1.4227,1.6317,1.9887,2.2883,2.8356,4.3453, & 
       ! seasalt soluble Accumulation Soluble (AS)
       4.125, 4.674, 5.005, 5.434, 5.985, 10.006, & 
       11.175,13.376,17.264,20.540,26.604, 42.349,& 
       4.187, 3.939, 3.919, 3.937, 3.995,  5.078, & 
       5.511, 6.434, 8.317,10.152,14.024, 26.537, &
       ! bc soluble
       7.675,7.675,7.675,7.675,7.675,7.675,    &
       7.675,7.675,10.433,11.984,13.767,15.567,& 
       4.720,4.720,4.720,4.720,4.720,4.720,    & 
       4.720,4.720,6.081,6.793,7.567,9.344,    & 
       ! pom soluble
       5.503,5.503,5.503,5.503,5.588,5.957,    & 
       6.404,7.340,8.545,10.319,13.595,20.398, & 
       1.402,1.402,1.402,1.402,1.431,1.562,    & 
       1.715,2.032,2.425,2.991,4.193,7.133,    & 
       ! sulfate    
       4.681,5.062,5.460,5.798,6.224,6.733,    & 
       7.556,8.613,10.687,12.265,16.32,21.692, & 
       1.107,1.239,1.381,1.490,1.635,1.8030,   &
       2.071,2.407,3.126,3.940,5.539,7.921/ 


  DATA alpha_aeri_2bands/  & 
       ! dust insoluble
       0.7661,0.7123,&
       ! bc insoluble
       10.360,4.437, &
       ! pom insoluble
       3.741,0.606/


  DATA cg_aers_2bands/ &
       ! seasalt Coarse soluble (CS)
       0.727, 0.747, 0.755, 0.761, 0.770, 0.788, &
       0.792, 0.799, 0.805, 0.809, 0.815, 0.826, &
       0.717, 0.738, 0.745, 0.752, 0.761, 0.779, &
       0.781, 0.786, 0.793, 0.797, 0.803, 0.813, &
       ! Sesalt Accumulation Soluble (AS)
       0.727, 0.741, 0.748, 0.754, 0.761, 0.782, & 
       0.787, 0.792, 0.797, 0.799, 0.801, 0.799, &
       0.606, 0.645, 0.658, 0.669, 0.681, 0.726, &
       0.734, 0.746, 0.761, 0.770, 0.782, 0.798, &
       ! bc soluble
       .612, .612, .612, .612, .612, .612, &
       .612, .612, .702, .734, .760, .796, &
       .433, .433, .433, .433, .433, .433, &
       .433, .433, .534, .575, .613, .669, &
       ! pom soluble
       .663, .663, .663, .663, .666, .674, &
       .685, .702, .718, .737, .757, .777, &
       .544, .544, .544, .544, .547, .554, &
       .565, .583, .604, .631, .661, .698, &
       ! sulfate    
       .658, .669, .680, .688, .698, .707, &
       .719, .733, .752, .760, .773, .786, &
       .544, .555, .565, .573, .583, .593, &
       .610, .628, .655, .666, .692, .719/


  DATA cg_aeri_2bands/ &
       ! dust insoluble
       .701, .670, &
       ! bc insoluble
       .471, .297, &
       ! pom insoluble
       .568, .365/

  DATA piz_aers_2bands/&
       ! seasalt Coarse soluble (CS)
       1.000,1.000,1.000,1.000,1.000,1.000, &
       1.000,1.000,1.000,1.000,1.000,1.000, &
       0.992,0.989,0.987,0.986,0.986,0.980, &
       0.980,0.978,0.976,0.976,0.974,0.971, &
       ! seasalt Accumulation Soluble (AS)
       1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
       1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
       0.970, 0.975, 0.976, 0.977, 0.978, 0.982, &
       0.982, 0.983, 0.984, 0.984, 0.985, 0.985, & 
       ! bc soluble
       .445, .445, .445, .445, .445, .445, &
       .445, .445, .461, .480, .505, .528, &
       .362, .362, .362, .362, .362, .362, &
       .362, .362, .381, .405, .437, .483, &
       ! pom soluble
       .972, .972, .972, .972, .972, .974, &
       .976, .979, .982, .986, .989, .992, &
       .924, .924, .924, .924, .925, .927, &
       .932, .938, .945, .952, .961, .970, &
       ! sulfate
       1.000,1.000,1.000,1.000,1.000,1.000, &
       1.000,1.000,1.000,1.000,1.000,1.000, &
       .992, .988, .988, .987, .986, .985,  &
       .985, .985, .984, .984, .984, .984 /


  DATA piz_aeri_2bands/ &
       ! dust insoluble
       .963, .987, &
       ! bc insoluble
       .395, .264, &
       ! pom insoluble
       .966, .859/


  DO k=1, klev
     DO i=1, klon
        IF (t_seri(i,k).EQ.0.) THEN
           WRITE(lunout,*) 't_seri(i,k)=0 for i=',i,'k=',k
           CALL abort_gcm('aeropt_2bands','t_seri=0',1)
        END IF
        IF (pplay(i,k).EQ.0.) THEN
           WRITE(lunout,*) 'pplay(i,k)=0 for i=',i,'k=',k
           CALL abort_gcm('aeropt_2bands','pplay=0',1)
        END IF

        zrho=pplay(i,k)/t_seri(i,k)/RD                  ! kg/m3
        mass_temp(i,k,:) = m_allaer(i,k,:) / zrho / 1.e+9

     ENDDO
  ENDDO

  IF (flag_aerosol .EQ. 1) THEN 
     nb_aer = 1
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASSO4M
  ELSEIF (flag_aerosol .EQ. 2) THEN
     nb_aer = 2
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASBCM
     aerosol_name(2) = id_AIBCM
  ELSEIF (flag_aerosol .EQ. 3) THEN 
     nb_aer = 2
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASPOMM
     aerosol_name(2) = id_AIPOMM
  ELSEIF (flag_aerosol .EQ. 4) THEN 
     nb_aer = 3
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_CSSSM
     aerosol_name(2) = id_SSSSM
     aerosol_name(3) = id_ASSSM
  ELSEIF (flag_aerosol .EQ. 5) THEN 
     nb_aer = 1
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_CIDUSTM
  ELSEIF (flag_aerosol .EQ. 6) THEN 
     nb_aer = 9
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASSO4M      
     aerosol_name(2) = id_ASBCM
     aerosol_name(3) = id_AIBCM
     aerosol_name(4) = id_ASPOMM
     aerosol_name(5) = id_AIPOMM
     aerosol_name(6) = id_CSSSM
     aerosol_name(7) = id_SSSSM
     aerosol_name(8) = id_ASSSM
     aerosol_name(9) = id_CIDUSTM
  ENDIF


  !
  ! loop over modes, use of precalculated nmd and corresponding sigma
  !    loop over wavelengths
  !    for each mass species in mode
  !      interpolate from Sext to retrieve Sext_at_gridpoint_per_species
  !      compute optical_thickness_at_gridpoint_per_species

  tau_ae(:,:,:,:)=0.
  piz_ae(:,:,:,:)=0.
  cg_ae(:,:,:,:)=0.
  tau_allaer(:,:,:,:)=0.
  piz_allaer(:,:,:,:)=0.
  cg_allaer(:,:,:,:)=0.

  !
  ! Calculations that need to be done since we are not in the subroutines INCA
  !      
  ! air mass auxiliary  variable --> zdp1 [kg/(m^2 *s)]
  zdp1(:,:)=pdel(:,:)/(gravit*delt) 


  DO m=1,nb_aer   ! tau is only computed for each mass

     fac=1.0
     IF (aerosol_name(m).EQ.id_SSSSM) THEN   ! for now
        soluble=.TRUE.
        spsol=1
     ELSEIF (aerosol_name(m).EQ.id_CSSSM) THEN 
        soluble=.TRUE.
        spsol=1
     ELSEIF (aerosol_name(m).EQ.id_ASSSM) THEN
        soluble=.TRUE.
        spsol=2
     ELSEIF (aerosol_name(m).EQ.id_ASBCM) THEN
        soluble=.TRUE.
        spsol=3
     ELSEIF (aerosol_name(m).EQ.id_ASPOMM) THEN 
        soluble=.TRUE.
        spsol=4 
     ELSEIF ((aerosol_name(m).EQ.id_ASSO4M) .OR.  (aerosol_name(m).EQ.id_CSSO4M)) THEN
        soluble=.TRUE.
        spsol=5
        fac=1.375    ! (NH4)2-SO4/SO4 132/96 mass conversion factor for OD
     ELSEIF (aerosol_name(m).EQ.id_CIDUSTM) THEN 
        soluble=.FALSE.
        spinsol=1
     ELSEIF  (aerosol_name(m).EQ.id_AIBCM) THEN 
        soluble=.FALSE.
        spinsol=2
     ELSEIF (aerosol_name(m).EQ.id_AIPOMM) THEN 
        soluble=.FALSE.
        spinsol=3
     ELSE 
        CYCLE
     ENDIF


     tau_ae2b_int(:,:,:)=0.
     piz_ae2b_int(:,:,:)=0.
     cg_ae2b_int(:,:,:)=0.

     DO k=1, KLEV
        DO i=1, KLON

           rh=MIN(RHcl(i,k)*100.,RH_MAX)
           RH_num = INT( rh/10. + 1.)

           IF (rh.GT.85.) RH_num=10
           IF (rh.GT.90.) RH_num=11
           DELTA=(rh-RH_tab(RH_num))/(RH_tab(RH_num+1)-RH_tab(RH_num))

           DO inu=1,nbands
              IF (soluble) THEN
                 tau_ae2b_int(i,k,inu)= &
                      alpha_aers_2bands(RH_num,inu,spsol)+ & 
                      DELTA* (alpha_aers_2bands(RH_num+1,inu,spsol) - & 
                      alpha_aers_2bands(RH_num,inu,spsol))

                 piz_ae2b_int(i,k,inu)= &
                      piz_aers_2bands(RH_num,inu,spsol) + & 
                      DELTA* (piz_aers_2bands(RH_num+1,inu,spsol) - & 
                      piz_aers_2bands(RH_num,inu,spsol))

                 cg_ae2b_int(i,k,inu)= &
                      cg_aers_2bands(RH_num,inu,spsol) + & 
                      DELTA* (cg_aers_2bands(RH_num+1,inu,spsol) - & 
                      cg_aers_2bands(RH_num,inu,spsol))

                 tau_ae(i,k,aerosol_name(m),inu) = &
                    mass_temp(i,k,spsol)*1000.*zdp1(i,k)*delt*tau_ae2b_int(i,k,inu)*fac

              ELSE
                 tau_ae2b_int(i,k,inu) = alpha_aeri_2bands(inu,spinsol)
                 piz_ae2b_int(i,k,inu) = piz_aeri_2bands(inu,spinsol)
                 cg_ae2b_int(i,k,inu) = cg_aeri_2bands(inu,spinsol) 

                 tau_ae(i,k,aerosol_name(m),inu) = &
                    mass_temp(i,k,5+ spinsol)*1000.*zdp1(i,k)*delt*tau_ae2b_int(i,k,inu)*fac
              ENDIF

              piz_ae(i,k,aerosol_name(m),inu) = piz_ae2b_int(i,k,inu)

              cg_ae(i,k,aerosol_name(m),inu)= cg_ae2b_int(i,k,inu)


           ENDDO    ! boucle sur les bandes spectrale
        ENDDO     ! Boucle sur les points gographiques (grille horizontale)
     ENDDO     ! Boucle sur les niveaux verticaux
  ENDDO     ! Boucle  sur les masses de traceurs


  DO inu=1, nbands
     DO mrfspecies=1,naero_grp
        DO k=1, KLEV
           DO i=1, KLON
              IF (mrfspecies .EQ. 2) THEN             ! = total aerosol AER	 
	 	 tau_allaer(i,k,mrfspecies,inu)=tau_ae(i,k,id_ASSO4M,inu)+tau_ae(i,k,id_CSSO4M,inu)+ &
                      tau_ae(i,k,id_ASBCM,inu)+tau_ae(i,k,id_AIBCM,inu)+ &						     
                      tau_ae(i,k,id_ASPOMM,inu)+tau_ae(i,k,id_AIPOMM,inu)+ &	
                      tau_ae(i,k,id_ASSSM,inu)+tau_ae(i,k,id_CSSSM,inu)+tau_ae(i,k,id_SSSSM,inu)+ &
                      tau_ae(i,k,id_CIDUSTM,inu)
	         tau_allaer(i,k,mrfspecies,inu)=MAX(tau_allaer(i,k,mrfspecies,inu),1e-20)
                 
	 	 piz_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASSO4M,inu)*piz_ae(i,k,id_ASSO4M,inu)+ &
                      tau_ae(i,k,id_CSSO4M,inu)*piz_ae(i,k,id_CSSO4M,inu)+ &
                      tau_ae(i,k,id_ASBCM,inu)*piz_ae(i,k,id_ASBCM,inu)+ &
                      tau_ae(i,k,id_AIBCM,inu)*piz_ae(i,k,id_AIBCM,inu)+ &
                      tau_ae(i,k,id_ASPOMM,inu)*piz_ae(i,k,id_ASPOMM,inu)+ &
                      tau_ae(i,k,id_AIPOMM,inu)*piz_ae(i,k,id_AIPOMM,inu)+ &	
                      tau_ae(i,k,id_ASSSM,inu)*piz_ae(i,k,id_ASSSM,inu)+ &
                      tau_ae(i,k,id_CSSSM,inu)*piz_ae(i,k,id_CSSSM,inu)+ &
                      tau_ae(i,k,id_SSSSM,inu)*piz_ae(i,k,id_SSSSM,inu)+ &
                      tau_ae(i,k,id_CIDUSTM,inu)*piz_ae(i,k,id_CIDUSTM,inu))/tau_allaer(i,k,mrfspecies,inu)
	         piz_allaer(i,k,mrfspecies,inu)=MAX(piz_allaer(i,k,mrfspecies,inu),1e-20)

	 	 cg_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASSO4M,inu)*piz_ae(i,k,id_ASSO4M,inu)*cg_ae(i,k,id_ASSO4M,inu)+ &
                      tau_ae(i,k,id_CSSO4M,inu)*piz_ae(i,k,id_CSSO4M,inu)*cg_ae(i,k,id_CSSO4M,inu)+ &
                      tau_ae(i,k,id_ASBCM,inu)*piz_ae(i,k,id_ASBCM,inu)*cg_ae(i,k,id_ASBCM,inu)+ &
                      tau_ae(i,k,id_AIBCM,inu)*piz_ae(i,k,id_AIBCM,inu)*cg_ae(i,k,id_AIBCM,inu)+ &
                      tau_ae(i,k,id_ASPOMM,inu)*piz_ae(i,k,id_ASPOMM,inu)*cg_ae(i,k,id_ASPOMM,inu)+ &
                      tau_ae(i,k,id_AIPOMM,inu)*piz_ae(i,k,id_AIPOMM,inu)*cg_ae(i,k,id_AIPOMM,inu)+ &	
                      tau_ae(i,k,id_ASSSM,inu)*piz_ae(i,k,id_ASSSM,inu)*cg_ae(i,k,id_ASSSM,inu)+ &
                      tau_ae(i,k,id_CSSSM,inu)*piz_ae(i,k,id_CSSSM,inu)*cg_ae(i,k,id_CSSSM,inu)+ &
                      tau_ae(i,k,id_SSSSM,inu)*piz_ae(i,k,id_SSSSM,inu)*cg_ae(i,k,id_SSSSM,inu)+ &
                      tau_ae(i,k,id_CIDUSTM,inu)*piz_ae(i,k,id_CIDUSTM,inu)*cg_ae(i,k,id_CIDUSTM,inu))/ &
                      (tau_allaer(i,k,mrfspecies,inu)*piz_allaer(i,k,mrfspecies,inu))


              ELSEIF (mrfspecies .EQ. 3) THEN             ! = natural aerosol NAT
	 	 tau_allaer(i,k,mrfspecies,inu)=tau_ae(i,k,id_ASSO4M,inu)*fractnat_allaer(i,id_ASSO4M)+ &
                      tau_ae(i,k,id_CSSO4M,inu)*fractnat_allaer(i,id_CSSO4M)+ &
                      tau_ae(i,k,id_ASBCM,inu)*fractnat_allaer(i,id_ASBCM)+ &
                      tau_ae(i,k,id_AIBCM,inu)*fractnat_allaer(i,id_AIBCM)+ &
                      tau_ae(i,k,id_ASPOMM,inu)*fractnat_allaer(i,id_ASPOMM)+ &
                      tau_ae(i,k,id_AIPOMM,inu)*fractnat_allaer(i,id_AIPOMM)+ &	
                      tau_ae(i,k,id_ASSSM,inu)*fractnat_allaer(i,id_ASSSM)+ &
                      tau_ae(i,k,id_CSSSM,inu)*fractnat_allaer(i,id_CSSSM)+ &
                      tau_ae(i,k,id_SSSSM,inu)*fractnat_allaer(i,id_SSSSM)+ &
                      tau_ae(i,k,id_CIDUSTM,inu)*fractnat_allaer(i,id_CIDUSTM)
	         tau_allaer(i,k,mrfspecies,inu)=MAX(tau_allaer(i,k,mrfspecies,inu),1e-20)

	 	 piz_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASSO4M,inu)*fractnat_allaer(i,id_ASSO4M)*piz_ae(i,k,id_ASSO4M,inu)+ &
                      tau_ae(i,k,id_CSSO4M,inu)*fractnat_allaer(i,id_CSSO4M)*piz_ae(i,k,id_CSSO4M,inu)+ &
                      tau_ae(i,k,id_ASBCM,inu)*fractnat_allaer(i,id_ASBCM)*piz_ae(i,k,id_ASBCM,inu)+ &
                      tau_ae(i,k,id_AIBCM,inu)*fractnat_allaer(i,id_AIBCM)*piz_ae(i,k,id_AIBCM,inu)+ &
                      tau_ae(i,k,id_ASPOMM,inu)*fractnat_allaer(i,id_ASPOMM)*piz_ae(i,k,id_ASPOMM,inu)+ &
                      tau_ae(i,k,id_AIPOMM,inu)*fractnat_allaer(i,id_AIPOMM)*piz_ae(i,k,id_AIPOMM,inu)+ &	
                      tau_ae(i,k,id_ASSSM,inu)*fractnat_allaer(i,id_ASSSM)*piz_ae(i,k,id_ASSSM,inu)+ &
                      tau_ae(i,k,id_CSSSM,inu)*fractnat_allaer(i,id_CSSSM)*piz_ae(i,k,id_CSSSM,inu)+ &
                      tau_ae(i,k,id_SSSSM,inu)*fractnat_allaer(i,id_SSSSM)*piz_ae(i,k,id_SSSSM,inu)+ &
                      tau_ae(i,k,id_CIDUSTM,inu)*fractnat_allaer(i,id_CIDUSTM)*piz_ae(i,k,id_CIDUSTM,inu)) &
                      /tau_allaer(i,k,mrfspecies,inu)
	         piz_allaer(i,k,mrfspecies,inu)=MAX(piz_allaer(i,k,mrfspecies,inu),1e-20)

	 	 cg_allaer(i,k,mrfspecies,inu)=(&
                      tau_ae(i,k,id_ASSO4M,inu)*fractnat_allaer(i,id_ASSO4M)*piz_ae(i,k,id_ASSO4M,inu)*cg_ae(i,k,id_ASSO4M,inu)+ &
                      tau_ae(i,k,id_CSSO4M,inu)*fractnat_allaer(i,id_CSSO4M)*piz_ae(i,k,id_CSSO4M,inu)*cg_ae(i,k,id_CSSO4M,inu)+ &
                      tau_ae(i,k,id_ASBCM,inu)*fractnat_allaer(i,id_ASBCM)*piz_ae(i,k,id_ASBCM,inu)*cg_ae(i,k,id_ASBCM,inu)+ &
                      tau_ae(i,k,id_AIBCM,inu)*fractnat_allaer(i,id_AIBCM)*piz_ae(i,k,id_AIBCM,inu)*cg_ae(i,k,id_AIBCM,inu)+ &
                      tau_ae(i,k,id_ASPOMM,inu)*fractnat_allaer(i,id_ASPOMM)*piz_ae(i,k,id_ASPOMM,inu)*cg_ae(i,k,id_ASPOMM,inu)+ &
                      tau_ae(i,k,id_AIPOMM,inu)*fractnat_allaer(i,id_AIPOMM)*piz_ae(i,k,id_AIPOMM,inu)*cg_ae(i,k,id_AIPOMM,inu)+ &
                      tau_ae(i,k,id_ASSSM,inu)*fractnat_allaer(i,id_ASSSM)*piz_ae(i,k,id_ASSSM,inu)*cg_ae(i,k,id_ASSSM,inu)+ &
                      tau_ae(i,k,id_CSSSM,inu)*fractnat_allaer(i,id_CSSSM)*piz_ae(i,k,id_CSSSM,inu)*cg_ae(i,k,id_CSSSM,inu)+ &
                      tau_ae(i,k,id_SSSSM,inu)*fractnat_allaer(i,id_SSSSM)*piz_ae(i,k,id_SSSSM,inu)*cg_ae(i,k,id_SSSSM,inu)+ &
                      tau_ae(i,k,id_CIDUSTM,inu)*fractnat_allaer(i,id_CIDUSTM)*piz_ae(i,k,id_CIDUSTM,inu)*&
                      cg_ae(i,k,id_CIDUSTM,inu))/ &
                      (tau_allaer(i,k,mrfspecies,inu)*piz_allaer(i,k,mrfspecies,inu))


              ELSEIF (mrfspecies .EQ. 4) THEN             ! = BC
	 	 tau_allaer(i,k,mrfspecies,inu)=tau_ae(i,k,id_ASBCM,inu)+tau_ae(i,k,id_AIBCM,inu)
	         tau_allaer(i,k,mrfspecies,inu)=MAX(tau_allaer(i,k,mrfspecies,inu),1e-20)
		 piz_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASBCM,inu)*piz_ae(i,k,id_ASBCM,inu) &
                      +tau_ae(i,k,id_AIBCM,inu)*piz_ae(i,k,id_AIBCM,inu))/ &
                      tau_allaer(i,k,mrfspecies,inu)
	         piz_allaer(i,k,mrfspecies,inu)=MAX(piz_allaer(i,k,mrfspecies,inu),1e-20)
		 cg_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASBCM,inu)*piz_ae(i,k,id_ASBCM,inu) *cg_ae(i,k,id_ASBCM,inu)&
                      +tau_ae(i,k,id_AIBCM,inu)*piz_ae(i,k,id_AIBCM,inu)*cg_ae(i,k,id_AIBCM,inu))/ &
                      (tau_allaer(i,k,mrfspecies,inu)*piz_allaer(i,k,mrfspecies,inu))
              ELSEIF (mrfspecies .EQ. 5) THEN             ! = SO4
	 	 tau_allaer(i,k,mrfspecies,inu)=tau_ae(i,k,id_ASSO4M,inu)+tau_ae(i,k,id_CSSO4M,inu)
	         tau_allaer(i,k,mrfspecies,inu)=MAX(tau_allaer(i,k,mrfspecies,inu),1e-20)
		 piz_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_CSSO4M,inu)*piz_ae(i,k,id_CSSO4M,inu) &
                      +tau_ae(i,k,id_ASSO4M,inu)*piz_ae(i,k,id_ASSO4M,inu))/ &
                      tau_allaer(i,k,mrfspecies,inu)
	         piz_allaer(i,k,mrfspecies,inu)=MAX(piz_allaer(i,k,mrfspecies,inu),1e-20)
		 cg_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_CSSO4M,inu)*piz_ae(i,k,id_CSSO4M,inu) *cg_ae(i,k,id_CSSO4M,inu)&
                      +tau_ae(i,k,id_ASSO4M,inu)*piz_ae(i,k,id_ASSO4M,inu)*cg_ae(i,k,id_ASSO4M,inu))/ &
                      (tau_allaer(i,k,mrfspecies,inu)*piz_allaer(i,k,mrfspecies,inu))

              ELSEIF (mrfspecies .EQ. 6) THEN             ! = POM
	 	 tau_allaer(i,k,mrfspecies,inu)=tau_ae(i,k,id_ASPOMM,inu)+tau_ae(i,k,id_AIPOMM,inu)
	         tau_allaer(i,k,mrfspecies,inu)=MAX(tau_allaer(i,k,mrfspecies,inu),1e-20)
		 piz_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASPOMM,inu)*piz_ae(i,k,id_ASPOMM,inu) &
                      +tau_ae(i,k,id_AIPOMM,inu)*piz_ae(i,k,id_AIPOMM,inu))/ &
                      tau_allaer(i,k,mrfspecies,inu)
	         piz_allaer(i,k,mrfspecies,inu)=MAX(piz_allaer(i,k,mrfspecies,inu),1e-20)
		 cg_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASPOMM,inu)*piz_ae(i,k,id_ASPOMM,inu) *cg_ae(i,k,id_ASPOMM,inu)&
                      +tau_ae(i,k,id_AIPOMM,inu)*piz_ae(i,k,id_AIPOMM,inu)*cg_ae(i,k,id_AIPOMM,inu))/ &
                      (tau_allaer(i,k,mrfspecies,inu)*piz_allaer(i,k,mrfspecies,inu))
              ELSEIF (mrfspecies .EQ. 7) THEN             ! = DUST
	 	 tau_allaer(i,k,mrfspecies,inu)=tau_ae(i,k,id_CIDUSTM,inu)
	         tau_allaer(i,k,mrfspecies,inu)=MAX(tau_allaer(i,k,mrfspecies,inu),1e-20)
		 piz_allaer(i,k,mrfspecies,inu)=piz_ae(i,k,id_CIDUSTM,inu)
		 cg_allaer(i,k,mrfspecies,inu)=cg_ae(i,k,id_CIDUSTM,inu)

              ELSEIF (mrfspecies .EQ. 8) THEN             ! = SS
	 	 tau_allaer(i,k,mrfspecies,inu)=tau_ae(i,k,id_ASSSM,inu)+tau_ae(i,k,id_CSSSM,inu)+tau_ae(i,k,id_SSSSM,inu)
	         tau_allaer(i,k,mrfspecies,inu)=MAX(tau_allaer(i,k,mrfspecies,inu),1e-20)
		 piz_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASSSM,inu)*piz_ae(i,k,id_ASSSM,inu) &
                      +tau_ae(i,k,id_CSSSM,inu)*piz_ae(i,k,id_CSSSM,inu) &
                      +tau_ae(i,k,id_SSSSM,inu)*piz_ae(i,k,id_SSSSM,inu))/ &
                      tau_allaer(i,k,mrfspecies,inu)
	         piz_allaer(i,k,mrfspecies,inu)=MAX(piz_allaer(i,k,mrfspecies,inu),1e-20)
		 cg_allaer(i,k,mrfspecies,inu)=(tau_ae(i,k,id_ASSSM,inu)*piz_ae(i,k,id_ASSSM,inu) *cg_ae(i,k,id_ASSSM,inu)&
                      +tau_ae(i,k,id_CSSSM,inu)*piz_ae(i,k,id_CSSSM,inu)*cg_ae(i,k,id_CSSSM,inu) &
                      +tau_ae(i,k,id_SSSSM,inu)*piz_ae(i,k,id_SSSSM,inu)*cg_ae(i,k,id_SSSSM,inu))/ &
                      (tau_allaer(i,k,mrfspecies,inu)*piz_allaer(i,k,mrfspecies,inu))

              ELSEIF (mrfspecies .EQ. 9) THEN             ! = NO3
	 	 tau_allaer(i,k,mrfspecies,inu)=0.   ! preliminary
		 piz_allaer(i,k,mrfspecies,inu)=0.
		 cg_allaer(i,k,mrfspecies,inu)=0.
              ENDIF
           ENDDO
        ENDDO
     ENDDO
  ENDDO

  DEALLOCATE(aerosol_name) 

END SUBROUTINE AEROPT_2BANDS
