!
! $Id: phys_local_var_mod.F90 1179 2009-06-11 14:18:47Z jghattas $
!
      MODULE phys_local_var_mod
! Variables locales pour effectuer les appels en serie
!======================================================================
!
!
!======================================================================
! Declaration des variables

      REAL, SAVE, ALLOCATABLE :: t_seri(:,:), q_seri(:,:)
      !$OMP THREADPRIVATE(t_seri, q_seri)
      REAL, SAVE, ALLOCATABLE :: ql_seri(:,:),qs_seri(:,:)
      !$OMP THREADPRIVATE(ql_seri,qs_seri)
      REAL, SAVE, ALLOCATABLE :: u_seri(:,:), v_seri(:,:)
      !$OMP THREADPRIVATE(u_seri, v_seri)

      REAL, SAVE, ALLOCATABLE :: tr_seri(:,:,:)
      !$OMP THREADPRIVATE(tr_seri)
      REAL, SAVE, ALLOCATABLE :: d_t_dyn(:,:), d_q_dyn(:,:)
      !$OMP THREADPRIVATE(d_t_dyn, d_q_dyn)
      REAL, SAVE, ALLOCATABLE :: d_u_dyn(:,:), d_v_dyn(:,:)
      !$OMP THREADPRIVATE(d_u_dyn, d_v_dyn)
      REAL, SAVE, ALLOCATABLE :: d_t_con(:,:),d_q_con(:,:)
      !$OMP THREADPRIVATE(d_t_con,d_q_con)
      REAL, SAVE, ALLOCATABLE :: d_u_con(:,:),d_v_con(:,:)
      !$OMP THREADPRIVATE(d_u_con,d_v_con)
      REAL, SAVE, ALLOCATABLE :: d_t_wake(:,:),d_q_wake(:,:)
      !$OMP THREADPRIVATE( d_t_wake,d_q_wake)
      REAL, SAVE, ALLOCATABLE :: d_t_lsc(:,:),d_q_lsc(:,:),d_ql_lsc(:,:)
      !$OMP THREADPRIVATE(d_t_lsc,d_q_lsc,d_ql_lsc)
      REAL, SAVE, ALLOCATABLE :: d_t_ajsb(:,:), d_q_ajsb(:,:)
      !$OMP THREADPRIVATE(d_t_ajsb, d_q_ajsb)
      REAL, SAVE, ALLOCATABLE :: d_t_ajs(:,:), d_q_ajs(:,:)
      !$OMP THREADPRIVATE(d_t_ajs, d_q_ajs)
      REAL, SAVE, ALLOCATABLE :: d_u_ajs(:,:), d_v_ajs(:,:)
      !$OMP THREADPRIVATE(d_u_ajs, d_v_ajs)
      REAL, SAVE, ALLOCATABLE :: d_t_eva(:,:),d_q_eva(:,:)
      !$OMP THREADPRIVATE(d_t_eva,d_q_eva)
!tendances dues a oro et lif
      REAL, SAVE, ALLOCATABLE :: d_t_oli(:,:)
      !$OMP THREADPRIVATE(d_t_oli)
      REAL, SAVE, ALLOCATABLE :: d_u_oli(:,:), d_v_oli(:,:)
      !$OMP THREADPRIVATE(d_u_oli, d_v_oli)
      REAL, SAVE, ALLOCATABLE :: d_t_vdf(:,:), d_q_vdf(:,:)
      !$OMP THREADPRIVATE( d_t_vdf, d_q_vdf)
      REAL, SAVE, ALLOCATABLE :: d_u_vdf(:,:), d_v_vdf(:,:)
      !$OMP THREADPRIVATE(d_u_vdf, d_v_vdf)
      REAL, SAVE, ALLOCATABLE :: d_t_oro(:,:)
      !$OMP THREADPRIVATE(d_t_oro)
      REAL, SAVE, ALLOCATABLE :: d_u_oro(:,:), d_v_oro(:,:)
      !$OMP THREADPRIVATE(d_u_oro, d_v_oro)
      REAL, SAVE, ALLOCATABLE :: d_t_lif(:,:)
      !$OMP THREADPRIVATE(d_t_lif)
      REAL, SAVE, ALLOCATABLE :: d_u_lif(:,:), d_v_lif(:,:)
      !$OMP THREADPRIVATE(d_u_lif, d_v_lif)
! Tendances Ondes de G non oro (runs strato).
      REAL, SAVE, ALLOCATABLE :: d_u_hin(:,:)
      !$OMP THREADPRIVATE(d_u_hin)
      REAL, SAVE, ALLOCATABLE :: d_v_hin(:,:)
      !$OMP THREADPRIVATE(d_v_hin)
      REAL, SAVE, ALLOCATABLE :: d_t_hin(:,:)
      !$OMP THREADPRIVATE(d_t_hin)

! tendance du a la conersion Ec -> E thermique
      REAL, SAVE, ALLOCATABLE :: d_t_ec(:,:)
      !$OMP THREADPRIVATE(d_t_ec)
      REAL, SAVE, ALLOCATABLE :: d_ts(:,:), d_tr(:,:,:)
      !$OMP THREADPRIVATE(d_ts, d_tr)

! diagnostique pour le rayonnement
      REAL, SAVE, ALLOCATABLE :: topswad_aero(:),  solswad_aero(:)  ! diag
      !$OMP THREADPRIVATE(topswad_aero,solswad_aero)
      REAL, SAVE, ALLOCATABLE :: topswai_aero(:),  solswai_aero(:)  ! diag
      !$OMP THREADPRIVATE(topswai_aero,solswai_aero)
      REAL, SAVE, ALLOCATABLE :: topswad0_aero(:), solswad0_aero(:) ! pas utilise, eventuellment pour diag
      !$OMP THREADPRIVATE(topswad0_aero,solswad0_aero)
      REAL, SAVE, ALLOCATABLE :: topsw_aero(:,:),  solsw_aero(:,:)  ! pas utilise, eventuellment pour diag
      !$OMP THREADPRIVATE(topsw_aero,solsw_aero)
      REAL, SAVE, ALLOCATABLE :: topsw0_aero(:,:), solsw0_aero(:,:) ! pas utilise, eventuellment pour diag
      !$OMP THREADPRIVATE(topsw0_aero,solsw0_aero)
CONTAINS

!======================================================================
SUBROUTINE phys_local_var_init
use dimphy
use infotrac, ONLY : nbtr
IMPLICIT NONE
#include "indicesol.h"
      allocate(t_seri(klon,klev),q_seri(klon,klev),ql_seri(klon,klev),qs_seri(klon,klev))
      allocate(u_seri(klon,klev),v_seri(klon,klev))

      allocate(tr_seri(klon,klev,nbtr))
      allocate(d_t_dyn(klon,klev),d_q_dyn(klon,klev))
      allocate(d_u_dyn(klon,klev),d_v_dyn(klon,klev))
      allocate(d_t_con(klon,klev),d_q_con(klon,klev))
      allocate(d_u_con(klon,klev),d_v_con(klon,klev))
      allocate(d_t_wake(klon,klev),d_q_wake(klon,klev))
      allocate(d_t_lsc(klon,klev),d_q_lsc(klon,klev))
      allocate(d_ql_lsc(klon,klev))
      allocate(d_t_ajsb(klon,klev),d_q_ajsb(klon,klev))
      allocate(d_t_ajs(klon,klev),d_q_ajs(klon,klev))
      allocate(d_u_ajs(klon,klev),d_v_ajs(klon,klev))
      allocate(d_t_eva(klon,klev),d_q_eva(klon,klev))
      allocate(d_t_vdf(klon,klev),d_q_vdf(klon,klev))
      allocate(d_u_vdf(klon,klev),d_v_vdf(klon,klev))
      allocate(d_t_oli(klon,klev),d_t_oro(klon,klev))
      allocate(d_u_oli(klon,klev),d_v_oli(klon,klev))
      allocate(d_u_oro(klon,klev),d_v_oro(klon,klev))
      allocate(d_t_lif(klon,klev),d_t_ec(klon,klev))
      allocate(d_u_lif(klon,klev),d_v_lif(klon,klev))
      allocate(d_ts(klon,klev), d_tr(klon,klev,nbtr))
      allocate(topswad_aero(klon), solswad_aero(klon))
      allocate(topswai_aero(klon), solswai_aero(klon))
      allocate(topswad0_aero(klon), solswad0_aero(klon))
      allocate(topsw_aero(klon,9), solsw_aero(klon,9))
      allocate(topsw0_aero(klon,9), solsw0_aero(klon,9))
      allocate(d_u_hin(klon,klev),d_v_hin(klon,klev),d_t_hin(klon,klev))

END SUBROUTINE phys_local_var_init

!======================================================================
SUBROUTINE phys_local_var_end
use dimphy
IMPLICIT NONE
#include "indicesol.h"
      deallocate(t_seri,q_seri,ql_seri,qs_seri)
      deallocate(u_seri,v_seri)

      deallocate(tr_seri)
      deallocate(d_t_dyn,d_q_dyn)
      deallocate(d_u_dyn,d_v_dyn)
      deallocate(d_t_con,d_q_con)
      deallocate(d_u_con,d_v_con)
      deallocate(d_t_wake,d_q_wake)
      deallocate(d_t_lsc,d_q_lsc)
      deallocate(d_ql_lsc)
      deallocate(d_t_ajsb,d_q_ajsb)
      deallocate(d_t_ajs,d_q_ajs)
      deallocate(d_u_ajs,d_v_ajs)
      deallocate(d_t_eva,d_q_eva)
      deallocate(d_t_vdf,d_q_vdf)
      deallocate(d_u_vdf,d_v_vdf)
      deallocate(d_t_oli,d_t_oro)
      deallocate(d_u_oli,d_v_oli)
      deallocate(d_u_oro,d_v_oro)
      deallocate(d_t_lif,d_t_ec)
      deallocate(d_u_lif,d_v_lif)
      deallocate(d_ts, d_tr)
      deallocate(topswad_aero,solswad_aero)
      deallocate(topswai_aero,solswai_aero)
      deallocate(topswad0_aero,solswad0_aero)
      deallocate(topsw_aero,solsw_aero)
      deallocate(topsw0_aero,solsw0_aero)
      deallocate(d_u_hin,d_v_hin,d_t_hin)

END SUBROUTINE phys_local_var_end

END MODULE phys_local_var_mod
