! $Id: pres2lev.F 1179 2009-06-11 14:18:47Z jghattas $
!
c******************************************************
      SUBROUTINE   pres2lev(varo,varn,lmo,lmn,po,pn,
     %                      ni,nj,ok_invertp)
c
c interpolation lineaire pour passer
c a une nouvelle discretisation verticale pour
c les variables de GCM
c Francois Forget (01/1995)
c MOdif remy roca 12/97 pour passer de pres2sig
c Modif F.Codron 07/08 po en 3D
c**********************************************************

      IMPLICIT NONE

c   Declarations:
c ==============
c
c  ARGUMENTS
c  """""""""
       LOGICAL, INTENT(IN) :: ok_invertp
       INTEGER, INTENT(IN) :: lmo ! dimensions ancienne couches
       INTEGER, INTENT(IN) :: lmn ! dimensions nouvelle couches
       INTEGER lmomx ! dimensions ancienne couches
       INTEGER lmnmx ! dimensions nouvelle couches

       parameter(lmomx=10000,lmnmx=10000)

        real, INTENT(IN) :: po(ni,nj,lmo) ! niveau de pression ancienne grille
        real, INTENT(IN) :: pn(ni,nj,lmn) ! niveau de pression nouvelle grille

       INTEGER, INTENT(IN) :: ni,nj ! nombre de point horizontale

       REAL, INTENT(IN)  :: varo(ni,nj,lmo) ! var dans l'ancienne grille
       REAL, INTENT(OUT) :: varn(ni,nj,lmn) ! var dans la nouvelle grille

       real zvaro(lmomx),zpo(lmomx)

c Autres variables
c """"""""""""""""
       INTEGER n, ln ,lo, i, j, Nhoriz
       REAL coef

c run
c ====
        do i=1,ni
        do j=1,nj
! Inversion de l'ordre des niveaux verticaux
          IF (ok_invertp) THEN
           do lo=1,lmo
              zpo(lo)=po(i,j,lmo+1-lo)
              zvaro(lo)=varo(i,j,lmo+1-lo)
           enddo
          ELSE
           do lo=1,lmo
              zpo(lo)=po(i,j,lo)
              zvaro(lo)=varo(i,j,lo)
           enddo
          ENDIF 

           do ln=1,lmn
              if (pn(i,j,ln).ge.zpo(1))then
                 varn(i,j,ln) =  zvaro(1)
              else if (pn(i,j,ln).le.zpo(lmo)) then
                 varn(i,j,ln) =  zvaro(lmo)
              else
                 do lo=1,lmo-1 
                    if ( (pn(i,j,ln).le.zpo(lo)).and.
     &                 (pn(i,j,ln).gt.zpo(lo+1)) )then
                       coef=(pn(i,j,ln)-zpo(lo))
     &                 /(zpo(lo+1)-zpo(lo))
                       varn(i,j,ln)=zvaro(lo)
     &                 +coef*(zvaro(lo+1)-zvaro(lo))
c       print*,'pn(',ln,')=',pn(i,j,ln),varn(i,j,ln)
                    end if
                 enddo           
              endif
           enddo

        enddo
        enddo
      return
      end    
