SUBROUTINE SW_AEROAR4(PSCT, PRMU0, PFRAC, &
     PPMB, PDP, &
     PPSOL, PALBD, PALBP,&
     PTAVE, PWV, PQS, POZON, PAER,&
     PCLDSW, PTAU, POMEGA, PCG,&
     PHEAT, PHEAT0,&
     PALBPLA,PTOPSW,PSOLSW,PTOPSW0,PSOLSW0,&
     ZFSUP,ZFSDN,ZFSUP0,ZFSDN0,&
     tauaero, pizaero, cgaero,&
     PTAUA, POMEGAA,&
     PTOPSWADAERO,PSOLSWADAERO,&
     PTOPSWAD0AERO,PSOLSWAD0AERO,&
     PTOPSWAIAERO,PSOLSWAIAERO,&
     PTOPSWAERO,PTOPSW0AERO,&
     PSOLSWAERO,PSOLSW0AERO,&
     ok_ade, ok_aie )

  USE dimphy
  IMPLICIT NONE

#include "YOMCST.h"
  !
  !     ------------------------------------------------------------------
  !
  !     PURPOSE.
  !     --------
  !
  !          THIS ROUTINE COMPUTES THE SHORTWAVE RADIATION FLUXES IN TWO
  !     SPECTRAL INTERVALS FOLLOWING FOUQUART AND BONNEL (1980).
  !
  !     METHOD.
  !     -------
  !
  !          1. COMPUTES ABSORBER AMOUNTS                 (SWU)
  !          2. COMPUTES FLUXES IN 1ST SPECTRAL INTERVAL  (SW1S)
  !          3. COMPUTES FLUXES IN 2ND SPECTRAL INTERVAL  (SW2S)
  !
  !     REFERENCE.
  !     ----------
  !
  !        SEE RADIATION'S PART OF THE ECMWF RESEARCH DEPARTMENT
  !        DOCUMENTATION, AND FOUQUART AND BONNEL (1980)
  !
  !     AUTHOR.
  !     -------
  !        JEAN-JACQUES MORCRETTE  *ECMWF*
  !
  !     MODIFICATIONS.
  !     --------------
  !        ORIGINAL : 89-07-14
  !        95-01-01   J.-J. MORCRETTE  Direct/Diffuse Albedo
  !        03-11-27   J. QUAAS Introduce aerosol forcings (based on BOUCHER)
  !        09-04      A. COZIC - C.DEANDREIS Indroduce NAT/BC/POM/DUST/SS aerosol forcing
  !     ------------------------------------------------------------------
  !
  !* ARGUMENTS:
  !
  REAL*8 PSCT  ! constante solaire (valeur conseillee: 1370)

  REAL*8 PPSOL(KDLON)        ! SURFACE PRESSURE (PA)
  REAL*8 PDP(KDLON,KFLEV)    ! LAYER THICKNESS (PA)
  REAL*8 PPMB(KDLON,KFLEV+1) ! HALF-LEVEL PRESSURE (MB)

  REAL*8 PRMU0(KDLON)  ! COSINE OF ZENITHAL ANGLE
  REAL*8 PFRAC(KDLON)  ! fraction de la journee

  REAL*8 PTAVE(KDLON,KFLEV)  ! LAYER TEMPERATURE (K)
  REAL*8 PWV(KDLON,KFLEV)    ! SPECIFI! HUMIDITY (KG/KG)
  REAL*8 PQS(KDLON,KFLEV)    ! SATURATED WATER VAPOUR (KG/KG)
  REAL*8 POZON(KDLON,KFLEV)  ! OZONE CONCENTRATION (KG/KG)
  REAL*8 PAER(KDLON,KFLEV,5) ! AEROSOLS' OPTICAL THICKNESS

  REAL*8 PALBD(KDLON,2)  ! albedo du sol (lumiere diffuse)
  REAL*8 PALBP(KDLON,2)  ! albedo du sol (lumiere parallele)

  REAL*8 PCLDSW(KDLON,KFLEV)    ! CLOUD FRACTION
  REAL*8 PTAU(KDLON,2,KFLEV)    ! CLOUD OPTICAL THICKNESS
  REAL*8 PCG(KDLON,2,KFLEV)     ! ASYMETRY FACTOR
  REAL*8 POMEGA(KDLON,2,KFLEV)  ! SINGLE SCATTERING ALBEDO

  REAL*8 PHEAT(KDLON,KFLEV) ! SHORTWAVE HEATING (K/DAY)
  REAL*8 PHEAT0(KDLON,KFLEV)! SHORTWAVE HEATING (K/DAY) clear-sky
  REAL*8 PALBPLA(KDLON)     ! PLANETARY ALBEDO
  REAL*8 PTOPSW(KDLON)      ! SHORTWAVE FLUX AT T.O.A.
  REAL*8 PSOLSW(KDLON)      ! SHORTWAVE FLUX AT SURFACE
  REAL*8 PTOPSW0(KDLON)     ! SHORTWAVE FLUX AT T.O.A. (CLEAR-SKY)
  REAL*8 PSOLSW0(KDLON)     ! SHORTWAVE FLUX AT SURFACE (CLEAR-SKY)
  !
  !* LOCAL VARIABLES:
  !
  REAL*8 ZOZ(KDLON,KFLEV)
  REAL*8 ZAKI(KDLON,2)     
  REAL*8 ZCLD(KDLON,KFLEV)
  REAL*8 ZCLEAR(KDLON) 
  REAL*8 ZDSIG(KDLON,KFLEV)
  REAL*8 ZFACT(KDLON)
  REAL*8 ZFD(KDLON,KFLEV+1)
  REAL*8 ZFDOWN(KDLON,KFLEV+1)
  REAL*8 ZFU(KDLON,KFLEV+1)
  REAL*8 ZFUP(KDLON,KFLEV+1)
  REAL*8 ZRMU(KDLON)
  REAL*8 ZSEC(KDLON)
  REAL*8 ZUD(KDLON,5,KFLEV+1)
  REAL*8 ZCLDSW0(KDLON,KFLEV)

  REAL*8 ZFSUP(KDLON,KFLEV+1)
  REAL*8 ZFSDN(KDLON,KFLEV+1)
  REAL*8 ZFSUP0(KDLON,KFLEV+1)
  REAL*8 ZFSDN0(KDLON,KFLEV+1)

  INTEGER inu, jl, jk, i, k, kpl1

  INTEGER swpas  ! Every swpas steps, sw is calculated
  PARAMETER(swpas=1)

  INTEGER itapsw
  LOGICAL appel1er
  DATA itapsw /0/
  DATA appel1er /.TRUE./
  SAVE itapsw,appel1er
  !$OMP THREADPRIVATE(appel1er)
  !$OMP THREADPRIVATE(itapsw)
  !jq-Introduced for aerosol forcings
  REAL*8 flag_aer
  LOGICAL ok_ade, ok_aie    ! use aerosol forcings or not?
  REAL*8 tauaero(kdlon,kflev,9,2)  ! aerosol optical properties
  REAL*8 pizaero(kdlon,kflev,9,2)  ! (see aeropt.F)
  REAL*8 cgaero(kdlon,kflev,9,2)   ! -"-
  REAL*8 PTAUA(KDLON,2,KFLEV)    ! CLOUD OPTICAL THICKNESS (pre-industrial value)
  REAL*8 POMEGAA(KDLON,2,KFLEV)  ! SINGLE SCATTERING ALBEDO
  REAL*8 PTOPSWADAERO(KDLON)     ! SHORTWAVE FLUX AT T.O.A.(+AEROSOL DIR)
  REAL*8 PSOLSWADAERO(KDLON)     ! SHORTWAVE FLUX AT SURFACE(+AEROSOL DIR)
  REAL*8 PTOPSWAD0AERO(KDLON)     ! SHORTWAVE FLUX AT T.O.A.(+AEROSOL DIR)
  REAL*8 PSOLSWAD0AERO(KDLON)     ! SHORTWAVE FLUX AT SURFACE(+AEROSOL DIR)
  REAL*8 PTOPSWAIAERO(KDLON)     ! SHORTWAVE FLUX AT T.O.A.(+AEROSOL IND)
  REAL*8 PSOLSWAIAERO(KDLON)     ! SHORTWAVE FLUX AT SURFACE(+AEROSOL IND)
  REAL*8 PTOPSWAERO(KDLON,9)
  REAL*8 PTOPSW0AERO(KDLON,9)
  REAL*8 PSOLSWAERO(KDLON,9)
  REAL*8 PSOLSW0AERO(KDLON,9)

  !jq - Fluxes including aerosol effects
  REAL*8,ALLOCATABLE,SAVE :: ZFSUPAD_AERO(:,:)
  !$OMP THREADPRIVATE(ZFSUPAD_AERO)
  REAL*8,ALLOCATABLE,SAVE :: ZFSDNAD_AERO(:,:)
  !$OMP THREADPRIVATE(ZFSDNAD_AERO)
  !jq - Fluxes including aerosol effects
  REAL*8,ALLOCATABLE,SAVE :: ZFSUPAD0_AERO(:,:)
  !$OMP THREADPRIVATE(ZFSUPAD0_AERO)
  REAL*8,ALLOCATABLE,SAVE :: ZFSDNAD0_AERO(:,:)
  !$OMP THREADPRIVATE(ZFSDNAD0_AERO)
  REAL*8,ALLOCATABLE,SAVE :: ZFSUPAI_AERO(:,:)
  !$OMP THREADPRIVATE(ZFSUPAI_AERO)
  REAL*8,ALLOCATABLE,SAVE :: ZFSDNAI_AERO(:,:)
  !$OMP THREADPRIVATE(ZFSDNAI_AERO)
  REAL*8,ALLOCATABLE,SAVE ::  ZFSUP_AERO(:,:,:)
  !$OMP THREADPRIVATE(ZFSUP_AERO)
  REAL*8,ALLOCATABLE,SAVE ::  ZFSDN_AERO(:,:,:)
  !$OMP THREADPRIVATE(ZFSDN_AERO)
  REAL*8,ALLOCATABLE,SAVE ::  ZFSUP0_AERO(:,:,:)
  !$OMP THREADPRIVATE(ZFSUP0_AERO)
  REAL*8,ALLOCATABLE,SAVE ::  ZFSDN0_AERO(:,:,:)
  !$OMP THREADPRIVATE(ZFSDN0_AERO)

  LOGICAL initialized
  !rv
  SAVE flag_aer
  !$OMP THREADPRIVATE(flag_aer)
  DATA initialized/.FALSE./
  SAVE initialized
  !$OMP THREADPRIVATE(initialized)


  IF(.NOT.initialized) THEN
     flag_aer=0.
     initialized=.TRUE.
     ALLOCATE(ZFSUPAD_AERO(KDLON,KFLEV+1))
     ALLOCATE(ZFSDNAD_AERO(KDLON,KFLEV+1))
     ALLOCATE(ZFSUPAD0_AERO(KDLON,KFLEV+1))
     ALLOCATE(ZFSDNAD0_AERO(KDLON,KFLEV+1))
     ALLOCATE(ZFSUPAI_AERO(KDLON,KFLEV+1))
     ALLOCATE(ZFSDNAI_AERO(KDLON,KFLEV+1))
     ALLOCATE(ZFSUP_AERO (KDLON,KFLEV+1,9))
     ALLOCATE(ZFSDN_AERO (KDLON,KFLEV+1,9))
     ALLOCATE(ZFSUP0_AERO(KDLON,KFLEV+1,9))
     ALLOCATE(ZFSDN0_AERO(KDLON,KFLEV+1,9))
     ZFSUPAD_AERO(:,:)=0.
     ZFSDNAD_AERO(:,:)=0.
     ZFSUPAD0_AERO(:,:)=0.
     ZFSDNAD0_AERO(:,:)=0.
     ZFSUPAI_AERO(:,:)=0.
     ZFSDNAI_AERO(:,:)=0.
     ZFSUP_AERO (:,:,:)=0.
     ZFSDN_AERO (:,:,:)=0.
     ZFSUP0_AERO(:,:,:)=0.
     ZFSDN0_AERO(:,:,:)=0.
  ENDIF
  !rv


  IF (appel1er) THEN
     PRINT*, 'SW calling frequency : ', swpas
     PRINT*, "   In general, it should be 1"
     appel1er = .FALSE.
  ENDIF
  !     ------------------------------------------------------------------
  IF (MOD(itapsw,swpas).EQ.0) THEN

     DO JK = 1 , KFLEV
        DO JL = 1, KDLON
           ZCLDSW0(JL,JK) = 0.0
           ZOZ(JL,JK) = POZON(JL,JK)*46.6968/RG &
                *PDP(JL,JK)*(101325.0/PPSOL(JL))
        ENDDO
     ENDDO


     ! clear-sky:
     flag_aer=0.0
     CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
          PRMU0,PFRAC,PTAVE,PWV,&
          ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
     INU = 1
     CALL SW1S_LMDAR4(INU,PAER, flag_aer, &
          tauaero(:,:,1,:), pizaero(:,:,1,:), cgaero(:,:,1,:),&
          PALBD, PALBP, PCG, ZCLD, ZCLEAR, ZCLDSW0,&
          ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
          ZFD, ZFU)
     INU = 2
     CALL SW2S_LMDAR4(INU, PAER, flag_aer, &
          tauaero(:,:,1,:), pizaero(:,:,1,:), cgaero(:,:,1,:),&
          ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, ZCLDSW0,&
          ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
          PWV, PQS,&
          ZFDOWN, ZFUP)
     DO JK = 1 , KFLEV+1
        DO JL = 1, KDLON
           ZFSUP0(JL,JK) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
           ZFSDN0(JL,JK) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ZFSUP0_AERO(JL,JK,1) = ZFSUP0(JL,JK) 
           ZFSDN0_AERO(JL,JK,1) = ZFSDN0(JL,JK)
        ENDDO
     ENDDO


     ! cloudy-sky:
     flag_aer=0.0
     CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
          PRMU0,PFRAC,PTAVE,PWV,&
          ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
     INU = 1
     CALL SW1S_LMDAR4(INU, PAER, flag_aer, &
          tauaero(:,:,1,:), pizaero(:,:,1,:), cgaero(:,:,1,:),&
          PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
          ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
          ZFD, ZFU)
     INU = 2
     CALL SW2S_LMDAR4(INU, PAER, flag_aer, &
          tauaero(:,:,1,:), pizaero(:,:,1,:), cgaero(:,:,1,:),&
          ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
          ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
          PWV, PQS,&
          ZFDOWN, ZFUP)

     DO JK = 1 , KFLEV+1
        DO JL = 1, KDLON
           ZFSUP(JL,JK) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
           ZFSDN(JL,JK) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ZFSUP_AERO(JL,JK,1) = ZFSUP(JL,JK) 
           ZFSDN_AERO(JL,JK,1) = ZFSDN(JL,JK)
        ENDDO
     ENDDO

     ZFSUP0_AERO(:,:,2) = ZFSUP0_AERO(:,:,1)
     ZFSDN0_AERO(:,:,2) = ZFSDN0_AERO(:,:,1)
     ZFSUP_AERO(:,:,2) = ZFSUP_AERO(:,:,1)
     ZFSDN_AERO(:,:,2) = ZFSDN_AERO(:,:,1)


     IF (ok_ade) THEN

        ! clear sky (Anne Cozic 03/07/2007)
        ! CAS AER (2)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,2,:), pizaero(:,:,2,:), cgaero(:,:,2,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,2,:), pizaero(:,:,2,:), cgaero(:,:,2,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUPAD0_AERO(JL,JK) = ZFSUP0(JL,JK) 
              ZFSDNAD0_AERO(JL,JK) = ZFSDN0(JL,JK) 
              ZFSUP0(JL,JK) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN0(JL,JK) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
              ZFSUP0_AERO(JL,JK,2) = ZFSUP0(JL,JK) 
              ZFSDN0_AERO(JL,JK,2) = ZFSDN0(JL,JK)
           ENDDO
        ENDDO

        ! cloudy-sky + aerosol dir OB
        ! ACo AER 
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,2,:), pizaero(:,:,2,:), cgaero(:,:,2,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,2,:), pizaero(:,:,2,:), cgaero(:,:,2,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUPAD_AERO(JL,JK) = ZFSUP(JL,JK) 
              ZFSDNAD_AERO(JL,JK) = ZFSDN(JL,JK) 
              ZFSUP(JL,JK) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN(JL,JK) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
              ZFSUP_AERO(JL,JK,2) = ZFSUP(JL,JK) 
              ZFSDN_AERO(JL,JK,2) = ZFSDN(JL,JK)
           ENDDO
        ENDDO

        !CAS NAT
        ! clear sky
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,3,:), pizaero(:,:,3,:), cgaero(:,:,3,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,3,:), pizaero(:,:,3,:), cgaero(:,:,3,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP0_AERO(JL,JK,3) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN0_AERO(JL,JK,3) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! cloudy-sky 
        ! ACo NAT
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,3,:), pizaero(:,:,3,:), cgaero(:,:,3,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,3,:), pizaero(:,:,3,:), cgaero(:,:,3,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP_AERO(JL,JK,3) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN_AERO(JL,JK,3) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! clear sky (Yves 01/12/2007)
        ! CAS BC (4)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,4,:), pizaero(:,:,4,:), cgaero(:,:,4,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,4,:), pizaero(:,:,4,:), cgaero(:,:,4,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP0_AERO(JL,JK,4) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN0_AERO(JL,JK,4) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! cloudy-sky + aerosol dir OB
        ! CAS BC (4)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,4,:), pizaero(:,:,4,:), cgaero(:,:,4,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,4,:), pizaero(:,:,4,:), cgaero(:,:,4,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP_AERO(JL,JK,4) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN_AERO(JL,JK,4) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! clear sky (Yves 13/12/2007)
        ! CAS SO4 (5)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,5,:), pizaero(:,:,5,:), cgaero(:,:,5,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,5,:), pizaero(:,:,5,:), cgaero(:,:,5,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP0_AERO(JL,JK,5) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN0_AERO(JL,JK,5) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! cloudy-sky + aerosol dir OB
        ! CAS SO4 (5)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,5,:), pizaero(:,:,5,:), cgaero(:,:,5,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,5,:), pizaero(:,:,5,:), cgaero(:,:,5,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP_AERO(JL,JK,5) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN_AERO(JL,JK,5) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! clear sky (Yves 13/12/2007)
        ! CAS POM (6)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,6,:), pizaero(:,:,6,:), cgaero(:,:,6,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,6,:), pizaero(:,:,6,:), cgaero(:,:,6,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP0_AERO(JL,JK,6) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN0_AERO(JL,JK,6) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! cloudy-sky + aerosol dir OB
        ! CAS POM (6)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,6,:), pizaero(:,:,6,:), cgaero(:,:,6,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,6,:), pizaero(:,:,6,:), cgaero(:,:,6,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP_AERO(JL,JK,6) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN_AERO(JL,JK,6) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! clear sky (Yves 13/12/2007)
        ! CAS DUST (7)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,7,:), pizaero(:,:,7,:), cgaero(:,:,7,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,7,:), pizaero(:,:,7,:), cgaero(:,:,7,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP0_AERO(JL,JK,7) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN0_AERO(JL,JK,7) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! cloudy-sky + aerosol dir OB
        ! CAS DUST (7)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,7,:), pizaero(:,:,7,:), cgaero(:,:,7,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,7,:), pizaero(:,:,7,:), cgaero(:,:,7,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP_AERO(JL,JK,7) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN_AERO(JL,JK,7) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! clear sky (Yves 13/12/2007)
        ! CAS Seasalt SS (8)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,ZCLDSW0,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,8,:), pizaero(:,:,8,:), cgaero(:,:,8,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,8,:), pizaero(:,:,8,:), cgaero(:,:,8,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP0_AERO(JL,JK,8) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN0_AERO(JL,JK,8) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

        ! cloudy-sky + aerosol dir OB
        ! CAS Seasalt SS (8)
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,8,:), pizaero(:,:,8,:), cgaero(:,:,8,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,8,:), pizaero(:,:,8,:), cgaero(:,:,8,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGA, ZOZ, ZRMU, ZSEC, PTAU, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)

        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUP_AERO(JL,JK,8) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN_AERO(JL,JK,8) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
           ENDDO
        ENDDO

     ENDIF ! ok_ade


     IF (ok_aie) THEN
        !jq   cloudy-sky + aerosol direct + aerosol indirect
        flag_aer=1.0
        CALL SWU_LMDAR4(PSCT,PCLDSW,PPMB,PPSOL,&
             PRMU0,PFRAC,PTAVE,PWV,&
             ZAKI,ZCLD,ZCLEAR,ZDSIG,ZFACT,ZRMU,ZSEC,ZUD)
        INU = 1
        CALL SW1S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,2,:), pizaero(:,:,2,:), cgaero(:,:,2,:),&
             PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGAA, ZOZ, ZRMU, ZSEC, PTAUA, ZUD,&
             ZFD, ZFU)
        INU = 2
        CALL SW2S_LMDAR4(INU, PAER, flag_aer,&
             tauaero(:,:,2,:), pizaero(:,:,2,:), cgaero(:,:,2,:),&
             ZAKI, PALBD, PALBP, PCG, ZCLD, ZCLEAR, PCLDSW,&
             ZDSIG, POMEGAA, ZOZ, ZRMU, ZSEC, PTAUA, ZUD,&
             PWV, PQS,&
             ZFDOWN, ZFUP)
        DO JK = 1 , KFLEV+1
           DO JL = 1, KDLON
              ZFSUPAI_AERO(JL,JK) = ZFSUP(JL,JK) 
              ZFSDNAI_AERO(JL,JK) = ZFSDN(JL,JK)          
              ZFSUP(JL,JK) = (ZFUP(JL,JK)   + ZFU(JL,JK)) * ZFACT(JL)
              ZFSDN(JL,JK) = (ZFDOWN(JL,JK) + ZFD(JL,JK)) * ZFACT(JL)
              ZFSUP_AERO(JL,JK,2) = ZFSUP(JL,JK) 
              ZFSDN_AERO(JL,JK,2) = ZFSDN(JL,JK)
           ENDDO
        ENDDO
     ENDIF ! ok_aie      

     itapsw = 0
  ENDIF
  itapsw = itapsw + 1

  DO k = 1, KFLEV
     kpl1 = k+1
     DO i = 1, KDLON

        PHEAT(i,k) = -(ZFSUP_AERO(i,kpl1,2)-ZFSUP_AERO(i,k,2)) &
             -(ZFSDN_AERO(i,k,2)-ZFSDN_AERO(i,kpl1,2))
        PHEAT(i,k) = PHEAT(i,k) * RDAY*RG/RCPD / PDP(i,k)
        PHEAT0(i,k) = -(ZFSUP0_AERO(i,kpl1,2)-ZFSUP0_AERO(i,k,2)) &
             -(ZFSDN0_AERO(i,k,2)-ZFSDN0_AERO(i,kpl1,2))
        PHEAT0(i,k) = PHEAT0(i,k) * RDAY*RG/RCPD / PDP(i,k)

     ENDDO
  ENDDO
  DO i = 1, KDLON
     PALBPLA(i) = ZFSUP(i,KFLEV+1)/(ZFSDN(i,KFLEV+1)+1.0e-20)
     ! clear sky
     PSOLSW0(i) = ZFSDN0(i,1) - ZFSUP0(i,1)
     PTOPSW0(i) = ZFSDN0(i,KFLEV+1) - ZFSUP0(i,KFLEV+1)

     PSOLSW(i) = ZFSDN(i,1) - ZFSUP(i,1)
     PTOPSW(i) = ZFSDN(i,KFLEV+1) - ZFSUP(i,KFLEV+1)

     PSOLSW0AERO(i,:) = ZFSDN0_AERO(i,1,:) - ZFSUP0_AERO(i,1,:)
     PTOPSW0AERO(i,:) = &
          ZFSDN0_AERO(i,KFLEV+1,:) - ZFSUP0_AERO(i,KFLEV+1,:)

     PSOLSWAERO(i,:) = ZFSDN_AERO(i,1,:) - ZFSUP_AERO(i,1,:)
     PTOPSWAERO(i,:) = &
          ZFSDN_AERO(i,KFLEV+1,:) - ZFSUP_AERO(i,KFLEV+1,:)

     PSOLSWADAERO(i) = ZFSDNAD_AERO(i,1) - ZFSUPAD_AERO(i,1)
     PTOPSWADAERO(i) = &
          ZFSDNAD_AERO(i,KFLEV+1) - ZFSUPAD_AERO(i,KFLEV+1)

     PSOLSWAD0AERO(i) = ZFSDNAD0_AERO(i,1) - ZFSUPAD0_AERO(i,1)
     PTOPSWAD0AERO(i) = &
          ZFSDNAD0_AERO(i,KFLEV+1) - ZFSUPAD0_AERO(i,KFLEV+1)

     PSOLSWAIAERO(i) = ZFSDNAI_AERO(i,1) - ZFSUPAI_AERO(i,1)
     PTOPSWAIAERO(i) = &
          ZFSDNAI_AERO(i,KFLEV+1) - ZFSUPAI_AERO(i,KFLEV+1)

  ENDDO
END SUBROUTINE SW_AEROAR4

