!
! $Header: /home/cvsroot/LMDZ4/libf/phylmd/geo2atm.F90,v 1.1 2008-12-05 17:56:40 lsce Exp $
!
SUBROUTINE geo2atm(im, jm, px, py, pz, plon, plat, pu, pv, pr)
  USE dimphy
  USE mod_phys_lmdz_para
    
  IMPLICIT NONE
  include 'dimensions.h'

! Change wind corrdinates from cartesian geocentric to local spherical
! NB! Fonctionne probablement uniquement en MPI seul (sans OpenMP)
!
  INTEGER, INTENT (IN)                 :: im, jm
  REAL, DIMENSION (im,jm), INTENT(IN)  :: px, py, pz
  REAL, DIMENSION (im,jm), INTENT(IN)  :: plon, plat
  REAL, DIMENSION (im,jm), INTENT(OUT) :: pu, pv, pr

  REAL, PARAMETER :: rpi = 3.141592653E0
  REAL, PARAMETER :: rad = rpi / 180.0E0
  
  REAL, DIMENSION (im,jm) :: zsinlon, zcoslon
  REAL, DIMENSION (im,jm) :: zsinlat, zcoslat

  zsinlon = SIN (rad * plon)
  zcoslon = COS (rad * plon)
  zsinlat = SIN (rad * plat)
  zcoslat = COS (rad * plat)

  pu = - px * zsinlon         + py * zcoslon
  pv = - px * zsinlat*zcoslon - py * zsinlat*zsinlon + pz * zcoslat  
  pr =   px * zcoslat*zcoslon + py * zcoslat*zsinlon + pz * zsinlat

! Value at North Pole
  IF (is_north_pole) THEN
     pu(:,1) = - py(1,1)
     pv(:,1) = - px(1,1) 
     pr(:,1) = 0.
  ENDIF

! Value at South Pole     
  IF (is_south_pole) THEN
     pu(:,jm) = py(1,jm)
     pv(:,jm) = px(1,jm)
     pr(:,jm) = 0.
  ENDIF
 
END SUBROUTINE geo2atm
