      itau_w = itau_phy + itap

      DO iff=1,nfiles

       IF (clef_files(iff)) THEN
             ndex2d = 0
             ndex3d = 0

!!! Champs 1D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
       IF (flag_phis(iff)<=lev_files(iff)) THEN 
         CALL histwrite_phy(nid_files(iff),
     $                      "phis",itau_w,pphis)
       ENDIF

       IF (flag_aire(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"aire",itau_w,airephy)
       ENDIF

       IF (flag_pourc_sol(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = pctsrf(1 : klon, is_ter)* 100.
      CALL histwrite_phy(nid_files(iff),
     $                   "pourc_"//clnsurf(is_ter),itau_w,
     $                   zx_tmp_fi2d)
       ENDIF

       IF (flag_fract_sol(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = pctsrf(1 : klon, is_ter)
      CALL histwrite_phy(nid_files(iff),
     $               "fract_"//clnsurf(is_ter),itau_w,
     $               zx_tmp_fi2d)
       ENDIF

       IF (flag_contfracATM(iff)<=lev_files(iff)) THEN
      DO i=1, klon
       zx_tmp_fi2d(i)=pctsrf(i,is_ter)+pctsrf(i,is_lic)
      ENDDO
      CALL histwrite_phy(nid_files(iff),
     $                   "contfracATM",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_contfracOR(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"contfracOR",itau_w,
     $                   pctsrf(:,is_ter))
       ENDIF

       IF (flag_aireTER(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),
     $                  "aireTER",itau_w,paire_ter)
       ENDIF

!!! Champs 2D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

       IF (flag_flat(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"flat",itau_w,zxfluxlat)
       ENDIF

       IF (flag_slp(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"slp",itau_w,slp)
       ENDIF

       IF (flag_tsol(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"tsol",itau_w,zxtsol)
       ENDIF

       IF (flag_t2m(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"t2m",itau_w,zt2m)
       ENDIF

       IF (flag_t2m_min(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"t2m_min",itau_w,zt2m)
       ENDIF

       IF (flag_t2m_max(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"t2m_max",itau_w,zt2m)
       ENDIF

       IF (flag_wind10m(iff)<=lev_files(iff)) THEN
      DO i=1, klon
       zx_tmp_fi2d(i)=SQRT(zu10m(i)*zu10m(i)+zv10m(i)*zv10m(i))
      ENDDO
      CALL histwrite_phy(nid_files(iff),"wind10m",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_wind10max(iff)<=lev_files(iff)) THEN
      DO i=1, klon
       zx_tmp_fi2d(i)=SQRT(zu10m(i)*zu10m(i)+zv10m(i)*zv10m(i))
      ENDDO
      CALL histwrite_phy(nid_files(iff),"wind10max", 
     $                   itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_sicf(iff)<=lev_files(iff)) THEN
      DO i = 1, klon
         zx_tmp_fi2d(i) = pctsrf(i,is_sic)
      ENDDO
      CALL histwrite_phy(nid_files(iff),"sicf",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_q2m(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"q2m",itau_w,zq2m)
       ENDIF

       IF (flag_u10m(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"u10m",itau_w,zu10m)
       ENDIF

       IF (flag_v10m(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"v10m",itau_w,zv10m)
       ENDIF

       IF (flag_psol(iff)<=lev_files(iff)) THEN
      DO i = 1, klon
         zx_tmp_fi2d(i) = paprs(i,1)
      ENDDO
      CALL histwrite_phy(nid_files(iff),"psol",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_qsurf(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"qsurf",itau_w,zxqsurf)
       ENDIF

       if (.not. ok_veget) then
         IF (flag_qsol(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),"qsol",itau_w,qsol)
         ENDIF
       endif

      IF (flag_precip(iff)<=lev_files(iff)) THEN
       DO i = 1, klon
         zx_tmp_fi2d(i) = rain_fall(i) + snow_fall(i)
       ENDDO
      CALL histwrite_phy(nid_files(iff),"precip",itau_w,zx_tmp_fi2d)
      ENDIF

       IF (flag_ndayrain(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"ndayrain",itau_w,nday_rain)
       ENDIF

      IF (flag_plul(iff)<=lev_files(iff)) THEN
       DO i = 1, klon
         zx_tmp_fi2d(i) = rain_lsc(i) + snow_lsc(i)
       ENDDO
      CALL histwrite_phy(nid_files(iff),"plul",itau_w,zx_tmp_fi2d)
      ENDIF

      IF (flag_pluc(iff)<=lev_files(iff)) THEN
      DO i = 1, klon
         zx_tmp_fi2d(i) = rain_con(i) + snow_con(i)
      ENDDO
      CALL histwrite_phy(nid_files(iff),"pluc",itau_w,zx_tmp_fi2d)
      ENDIF

       IF (flag_snow(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"snow",itau_w,snow_fall)
       ENDIF

       IF (flag_evap(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"evap",itau_w,evap)
       ENDIF

       IF (flag_tops(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"tops",itau_w,topsw)
       ENDIF

       IF (flag_tops0(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"tops0",itau_w,topsw0)
       ENDIF

       IF (flag_topl(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"topl",itau_w,toplw)
       ENDIF

       IF (flag_topl0(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"topl0",itau_w,toplw0)
       ENDIF

       IF (flag_SWupTOA(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swup ( 1 : klon, klevp1 )
      CALL histwrite_phy(nid_files(iff), "SWupTOA",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_SWupTOAclr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swup0 ( 1 : klon, klevp1 )
      CALL histwrite_phy(nid_files(iff), 
     $                  "SWupTOAclr",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_SWdnTOA(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swdn ( 1 : klon, klevp1 )
      CALL histwrite_phy(nid_files(iff), "SWdnTOA",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_SWdnTOAclr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swdn0 ( 1 : klon, klevp1 )
      CALL histwrite_phy(nid_files(iff), 
     $                  "SWdnTOAclr",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_SWup200(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"SWup200",itau_w,SWup200)
       ENDIF

       IF (flag_SWup200clr(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"SWup200clr",itau_w,SWup200clr)
       ENDIF

       IF (flag_SWdn200(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"SWdn200",itau_w,SWdn200)
       ENDIF

       IF (flag_SWdn200clr(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"SWdn200clr",itau_w,SWdn200clr)
       ENDIF

       IF (flag_LWup200(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"LWup200",itau_w,LWup200)
       ENDIF

       IF (flag_LWup200clr(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"LWup200clr",itau_w,LWup200clr)
       ENDIF

       IF (flag_LWdn200(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"LWdn200",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_LWdn200clr(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"LWdn200clr",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_sols(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"sols",itau_w,solsw)
       ENDIF

       IF (flag_sols0(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"sols0",itau_w,solsw0)
       ENDIF

       IF (flag_soll(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"soll",itau_w,sollw)
       ENDIF

       IF (flag_radsol(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"radsol",itau_w,radsol)
       ENDIF

       IF (flag_soll0(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"soll0",itau_w,sollw0)
       ENDIF

       IF (flag_SWupSFC(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swup ( 1 : klon, 1 )
      CALL histwrite_phy(nid_files(iff), "SWupSFC",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_SWupSFCclr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swup0 ( 1 : klon, 1 )
      CALL histwrite_phy(nid_files(iff), 
     $                   "SWupSFCclr",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_SWdnSFC(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swdn ( 1 : klon, 1 )
      CALL histwrite_phy(nid_files(iff), 
     $                   "SWdnSFC",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_SWdnSFCclr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = swdn0 ( 1 : klon, 1 )
      CALL histwrite_phy(nid_files(iff), 
     $                  "SWdnSFCclr",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_LWupSFC(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1:klon)=sollwdown(1:klon)-sollw(1:klon)
      CALL histwrite_phy(nid_files(iff),
     $                    "LWupSFC",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_LWdnSFC(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),
     $                   "LWdnSFC",itau_w,sollwdown)
       ENDIF

       sollwdownclr(1:klon) = -1.*lwdn0(1:klon,1)
       IF (flag_LWupSFCclr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1:klon)=sollwdownclr(1:klon)-sollw0(1:klon)
      CALL histwrite_phy(nid_files(iff),
     $                   "LWupSFCclr",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_LWdnSFCclr(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),
     $                   "LWdnSFCclr",itau_w,sollwdownclr)
       ENDIF

       IF (flag_bils(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"bils",itau_w,bils)
       ENDIF

       IF (flag_sens(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1:klon)=-1*sens(1:klon)
      CALL histwrite_phy(nid_files(iff),"sens",itau_w,zx_tmp_fi2d)
       ENDIF

       IF (flag_fder(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"fder",itau_w,fder)
       ENDIF

       IF (flag_ffonte(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"ffonte",itau_w,zxffonte)
       ENDIF

       IF (flag_fqcalving(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),
     $                    "fqcalving",itau_w,zxfqcalving)
       ENDIF

       IF (flag_fqfonte(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),
     $                    "fqfonte",itau_w,zxfqfonte)
       ENDIF

         DO nsrf = 1, nbsrf
           IF(nsrf.GE.2) THEN
            IF (flag_pourc_sol(iff)<=lev_files(iff)) THEN
            zx_tmp_fi2d(1 : klon) = pctsrf( 1 : klon, nsrf)*100.
            CALL histwrite_phy(nid_files(iff),
     $                     "pourc_"//clnsurf(nsrf),itau_w,
     $                     zx_tmp_fi2d)
            ENDIF

          IF (flag_fract_sol(iff)<=lev_files(iff)) THEN
          zx_tmp_fi2d(1 : klon) = pctsrf( 1 : klon, nsrf)
          CALL histwrite_phy(nid_files(iff),
     $                    "fract_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
          ENDIF
         ENDIF !nsrf.GT.2

        IF (flag_taux_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = fluxu( 1 : klon, 1, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                     "taux_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

        IF (flag_tauy_sol(iff)<=lev_files(iff)) THEN           
        zx_tmp_fi2d(1 : klon) = fluxv( 1 : klon, 1, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                    "tauy_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

        IF (flag_tsol_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = ftsol( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                   "tsol_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

      IF (flag_u10m_sol(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = u10m(1 : klon, nsrf)
      CALL histwrite_phy(nid_files(iff),"u10m_"//clnsurf(nsrf),
     $                 itau_w,zx_tmp_fi2d)
      ENDIF

      IF (flag_v10m_sol(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = v10m(1 : klon, nsrf)
      CALL histwrite_phy(nid_files(iff),"v10m_"//clnsurf(nsrf),
     $              itau_w,zx_tmp_fi2d)
      ENDIF
 
      IF (flag_t2m_sol(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = t2m(1 : klon, nsrf)
      CALL histwrite_phy(nid_files(iff),"t2m_"//clnsurf(nsrf),
     $           itau_w,zx_tmp_fi2d)
      ENDIF

       IF (flag_sens_sol(iff)<=lev_files(iff)) THEN
       zx_tmp_fi2d(1 : klon) = fluxt( 1 : klon, 1, nsrf)
       CALL histwrite_phy(nid_files(iff),
     $                     "sens_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
       ENDIF

        IF (flag_lat_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = fluxlat( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                 "lat_"//clnsurf(nsrf),itau_w,
     $                                   zx_tmp_fi2d)
          ENDIF

        IF (flag_flw_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = fsollw( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                     "flw_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

        IF (flag_fsw_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = fsolsw( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                     "fsw_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

        IF (flag_wbils_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = wfbils( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                     "wbils_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

        IF (flag_wbilo_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = wfbilo( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),
     $                    "wbilo_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

       if (iflag_pbl>1 .and. lev_histday.gt.10 ) then
        IF (flag_tke_sol(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),
     $                    "tke_"//clnsurf(nsrf),itau_w,
     $      pbl_tke(:,1:klev,nsrf))
       ENDIF

        IF (flag_tke_max_sol(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),
     $                    "tke_max_"//clnsurf(nsrf),itau_w,
     $      pbl_tke(:,1:klev,nsrf))
        ENDIF
       endif
      ENDDO

        IF (flag_cdrm(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cdrm",itau_w,cdragm)
        ENDIF

        IF (flag_cdrh(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cdrh",itau_w,cdragh)
        ENDIF

        IF (flag_cldl(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cldl",itau_w,cldl)
        ENDIF

        IF (flag_cldm(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cldm",itau_w,cldm)
        ENDIF

        IF (flag_cldh(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cldh",itau_w,cldh)
        ENDIF

        IF (flag_cldt(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cldt", 
     &                   itau_w,cldt*100)
        ENDIF

        IF (flag_cldq(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cldq",itau_w,cldq)
        ENDIF

        IF (flag_lwp(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1:klon) = flwp(1:klon)
      CALL histwrite_phy(nid_files(iff),"lwp",itau_w,zx_tmp_fi2d)
        ENDIF

        IF (flag_iwp(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1:klon) = fiwp(1:klon)
      CALL histwrite_phy(nid_files(iff),"iwp",itau_w,zx_tmp_fi2d)
        ENDIF

        IF (flag_ue(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"ue",itau_w,ue)
        ENDIF

        IF (flag_ve(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"ve",itau_w,ve)
        ENDIF

        IF (flag_uq(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"uq",itau_w,uq)
        ENDIF

        IF (flag_vq(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"vq",itau_w,vq)
        ENDIF

      IF(iflag_con.GE.3) THEN ! sb
        IF (flag_cape(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cape",itau_w,cape)
        ENDIF

        IF (flag_pbase(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"pbase",itau_w,pbase)
        ENDIF

        IF (flag_ptop(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"ptop",itau_w,ema_pct)
        ENDIF

        IF (flag_fbase(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"fbase",itau_w,ema_cbmf)
        ENDIF

        IF (flag_prw(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"prw",itau_w,prw)
        ENDIF
      ENDIF !iflag_con .GE. 3

        IF (flag_s_pblh(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_pblh",itau_w,s_pblh)
        ENDIF

        IF (flag_s_pblt(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_pblt",itau_w,s_pblt)
        ENDIF

        IF (flag_s_lcl(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_lcl",itau_w,s_lcl)
        ENDIF

        IF (flag_s_capCL(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_capCL",itau_w,s_capCL)
        ENDIF

        IF (flag_s_oliqCL(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_oliqCL",itau_w,s_oliqCL)
        ENDIF

        IF (flag_s_cteiCL(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_cteiCL",itau_w,s_cteiCL)
        ENDIF

        IF (flag_s_therm(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_therm",itau_w,s_therm)
        ENDIF

        IF (flag_s_trmb1(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_trmb1",itau_w,s_trmb1)
        ENDIF

        IF (flag_s_trmb2(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_trmb2",itau_w,s_trmb2)
        ENDIF

        IF (flag_s_trmb3(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"s_trmb3",itau_w,s_trmb3)
        ENDIF

! Champs interpolles sur des niveaux de pression
! if=1 on ecrit u v w phi sur 850 700 500 200 au niv 1
! if=2 on ecrit w et ph 500 seulement au niv 1
!        et u v sur 850 700 500 200
! if=3 on ecrit ph a 500 seulement au niv 1
!      on ecrit u v t q a 850 700 500 200 au niv 3

        DO k=1, nlevSTD
         IF(k.GE.2.AND.k.LE.12) bb2=clevSTD(k)
         IF(k.GE.13.AND.k.LE.17) bb3=clevSTD(k)
         IF(bb2.EQ."850".OR.bb2.EQ."700".OR.
     $      bb2.EQ."500".OR.bb2.EQ."200") THEN

! a refaire correctement !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
       IF (flag_ulevsSTD(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"u"//bb2,
     & itau_w,uwriteSTD(:,k,iff))
       ENDIF

       IF (flag_vlevsSTD(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"v"//bb2,  
     & itau_w,vwriteSTD(:,k,iff))
       ENDIF

       IF (flag_wlevsSTD(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"w"//bb2,
     & itau_w,wwriteSTD(:,k,iff))
       ENDIF

       IF (flag_philevsSTD(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),
     $                  "phi"//bb2,
     &               itau_w,phiwriteSTD(:,k,iff))
       ENDIF

       IF (flag_qlevsSTD(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"q"//bb2,
     & itau_w, qwriteSTD(:,k,iff))
       ENDIF

       IF (flag_tlevsSTD(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"t"//bb2,
     & itau_w, twriteSTD(:,k,iff))
       ENDIF

       ENDIF !(bb2.EQ."850".OR.bb2.EQ."700".OR.
       ENDDO

      IF (flag_t_oce_sic(iff)<=lev_files(iff)) THEN
      DO i=1, klon
       IF (pctsrf(i,is_oce).GT.epsfra.OR.
     $     pctsrf(i,is_sic).GT.epsfra) THEN
        zx_tmp_fi2d(i) = (ftsol(i, is_oce) * pctsrf(i,is_oce)+
     $                   ftsol(i, is_sic) * pctsrf(i,is_sic))/
     $                   (pctsrf(i,is_oce)+pctsrf(i,is_sic))
       ELSE
        zx_tmp_fi2d(i) = 273.15
       ENDIF
      ENDDO
      CALL histwrite_phy(nid_files(iff),"t_oce_sic",itau_w,zx_tmp_fi2d)
      ENDIF

      IF (type_ocean=='force ') THEN

      IF (iflag_con.GE.3) THEN
      IF (iflag_coupl.EQ.1) THEN
       IF (flag_ale_bl(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"ale_bl",itau_w,ale_bl)
       ENDIF
       IF (flag_alp_bl(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"alp_bl",itau_w,alp_bl)
       ENDIF
      ENDIF !iflag_coupl.EQ.1

      IF (iflag_wake.EQ.1) THEN
       IF (flag_ale_wk(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"ale_wk",itau_w,ale_wake)
       ENDIF
       IF (flag_alp_wk(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"alp_wk",itau_w,alp_wake)
       ENDIF

       IF (flag_ale(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"ale",itau_w,ale)
       ENDIF
       IF (flag_alp(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"alp",itau_w,alp)
       ENDIF
       IF (flag_cin(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"cin",itau_w,cin)
       ENDIF
       IF (flag_wape(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"WAPE",itau_w,wake_pe)
       ENDIF
       IF (flag_wake_h(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"wake_h",itau_w,wake_h)
       ENDIF

       IF (flag_wake_s(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"wake_s",itau_w,wake_s)
       ENDIF

        IF (flag_wake_deltat(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"wake_deltat",
     $                     itau_w,wake_deltat)
        ENDIF

        IF (flag_wake_deltaq(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"wake_deltaq",
     $                    itau_w,wake_deltaq)
        ENDIF

        IF (flag_wake_omg(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"wake_omg",itau_w,wake_omg)
        ENDIF
      ENDIF

        IF (flag_Vprecip(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"Vprecip",itau_w,Vprecip)
        ENDIF

        IF (flag_ftd(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"ftd",itau_w,ftd)
        ENDIF

        IF (flag_fqd(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"fqd",itau_w,fqd)
        ENDIF

      ENDIF !(iflag_con.GE.3) 
 
      ELSE IF (type_ocean=='slab  ') THEN

      IF ( flag_slab_bils(iff)<=lev_files(iff)) 
     $     CALL histwrite_phy(
     $     nid_files(iff),"slab_wbils_oce",itau_w,slab_wfbils)

      ENDIF !type_ocean == force/slab

      IF (flag_weakinv(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"weakinv",itau_w,weak_inversion)
      ENDIF

      IF (flag_dthmin(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dthmin",itau_w,dthmin)
      ENDIF

       IF (flag_cldtau(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"cldtau",itau_w,cldtau)
       ENDIF

       IF (flag_cldemi(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"cldemi",itau_w,cldemi)
       ENDIF

!      IF (flag_pr_con_l(iff)<=lev_files(iff)) THEN
!      CALL histwrite_phy(nid_files(iff),"pmflxr",itau_w,pmflxr)
!      ENDIF

!      IF (flag_pr_con_i(iff)<=lev_files(iff)) THEN
!      CALL histwrite_phy(nid_files(iff),"pmflxs",itau_w,pmflxs)
!      ENDIF

!      IF (flag_pr_lsc_l(iff)<=lev_files(iff)) THEN
!      CALL histwrite_phy(nid_files(iff),"prfl",itau_w,prfl)
!      ENDIF

!      IF (flag_pr_lsc_i(iff)<=lev_files(iff)) THEN
!      CALL histwrite_phy(nid_files(iff),"psfl",itau_w,psfl)
!      ENDIF

      IF (flag_rh2m(iff)<=lev_files(iff)) THEN
      DO i=1, klon
       zx_tmp_fi2d(i)=MIN(100.,rh2m(i)*100.)
      ENDDO
      CALL histwrite_phy(nid_files(iff),"rh2m",itau_w,zx_tmp_fi2d)
      ENDIF

      IF (flag_qsat2m(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"qsat2m",itau_w,qsat2m)
      ENDIF

      IF (flag_tpot(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"tpot",itau_w,tpot)
      ENDIF

       IF (flag_tpote(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"tpote",itau_w,tpote)
       ENDIF

      IF (flag_SWnetOR(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1 : klon) = fsolsw( 1 : klon, is_ter)
      CALL histwrite_phy(nid_files(iff),"SWnetOR",itau_w, zx_tmp_fi2d)
      ENDIF

      IF (flag_SWdownOR(iff)<=lev_files(iff)) THEN
      zx_tmp_fi2d(1:klon) = solsw(1:klon)/(1.-albsol1(1:klon))
      CALL histwrite_phy(nid_files(iff),"SWdownOR",itau_w, zx_tmp_fi2d)
      ENDIF

      IF (flag_LWdownOR(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"LWdownOR",itau_w,sollwdown)
      ENDIF

      IF (flag_snowl(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"snowl",itau_w,snow_lsc)
      ENDIF

      IF (iflag_con.GE.3) THEN
      IF (flag_cape_max(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"cape_max",itau_w,cape)
      ENDIF
      ENDIF !(iflag_con.GE.3)

      IF (flag_solldown(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"solldown",itau_w,sollwdown)
      ENDIF

      IF (flag_dtsvdfo(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dtsvdfo",itau_w,d_ts(:,is_oce))
      ENDIF

      IF (flag_dtsvdft(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dtsvdft",itau_w,d_ts(:,is_ter))
      ENDIF

       IF (flag_dtsvdfg(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),
     $                     "dtsvdfg",itau_w, d_ts(:,is_lic))
       ENDIF

       IF (flag_dtsvdfi(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dtsvdfi",itau_w,d_ts(:,is_sic))
       ENDIF

       IF (flag_rugs(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"rugs",itau_w,zxrugs)
       ENDIF

! Champs 3D:
       IF (flag_lwcon(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"lwcon",itau_w,flwc)
       ENDIF

       IF (flag_iwcon(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"iwcon",itau_w,fiwc)
       ENDIF

       IF (flag_temp(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"temp",itau_w,t_seri)
       ENDIF

       IF (flag_theta(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"theta",itau_w,theta)
       ENDIF

       IF (flag_ovap(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"ovap",itau_w,qx(:,:,ivap))
       ENDIF

       IF (flag_geop(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"geop",itau_w,zphi)
       ENDIF

       IF (flag_vitu(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"vitu",itau_w,u_seri)
       ENDIF

       IF (flag_vitv(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"vitv",itau_w,v_seri)
       ENDIF

       IF (flag_vitw(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"vitw",itau_w,omega)
       ENDIF

        IF (flag_pres(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"pres",itau_w,pplay)
        ENDIF

       IF (flag_rneb(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"rneb",itau_w,cldfra)
       ENDIF

       IF (flag_rnebcon(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"rnebcon",itau_w,rnebcon)
       ENDIF

       IF (flag_rhum(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"rhum",itau_w,zx_rh)
       ENDIF

      IF (flag_ozone(iff)<=lev_files(iff)) THEN
      DO k=1, klev
       DO i=1, klon
         zx_tmp_fi3d(i,k)=wo(i,k)*RG/46.6968
     $                    /(paprs(i,k)-paprs(i,k+1))
     $                    *(paprs(i,1)/101325.0)
       ENDDO !i
      ENDDO !k
      CALL histwrite_phy(nid_files(iff),"ozone",itau_w,zx_tmp_fi3d)
      ENDIF

      IF(iflag_con.GE.3) THEN
       IF (flag_upwd(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"upwd",itau_w,upwd)
       ENDIF
      ENDIF !(iflag_con.GE.3)

       IF (flag_dtphy(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dtphy",itau_w,d_t)
       ENDIF

       IF (flag_dqphy(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dqphy",itau_w, d_qx(:,:,ivap))
       ENDIF

        DO nsrf=1, nbsrf
        IF (flag_albe_sol(iff)<=lev_files(iff)) THEN 
        zx_tmp_fi2d(1 : klon) = falb1( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),"albe_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

        IF (flag_rugs_sol(iff)<=lev_files(iff)) THEN  
        zx_tmp_fi2d(1 : klon) = frugs( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),"rugs_"//clnsurf(nsrf),itau_w,
     $      zx_tmp_fi2d)
        ENDIF

        IF (flag_ages_sol(iff)<=lev_files(iff)) THEN
        zx_tmp_fi2d(1 : klon) = agesno( 1 : klon, nsrf)
        CALL histwrite_phy(nid_files(iff),"ages_"//clnsurf(nsrf),itau_w
     $    ,zx_tmp_fi2d)
        ENDIF
        ENDDO !nsrf=1, nbsrf

       IF (flag_albs(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"albs",itau_w,albsol1)
       ENDIF

       IF (flag_albslw(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"albslw",itau_w,albsol2)
       ENDIF

!FH Sorties pour la couche limite
      if (iflag_pbl>1) then
      zx_tmp_fi3d=0.
      do nsrf=1,nbsrf
         do k=1,klev
          zx_tmp_fi3d(:,k)=zx_tmp_fi3d(:,k)
     $    +pctsrf(:,nsrf)*pbl_tke(:,k,nsrf)
         enddo
      enddo
       IF (flag_tke(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"tke",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_tke_max(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"tke_max",itau_w,zx_tmp_fi3d)
       ENDIF
      endif

       IF (flag_kz(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"kz",itau_w,ycoefh)
       ENDIF

       IF (flag_kz_max(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"kz_max",itau_w,ycoefh)
       ENDIF

       IF (flag_clwcon(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"clwcon",itau_w,clwcon0)
       ENDIF

      IF(iflag_con.GE.3) THEN
       IF (flag_Ma(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"Ma",itau_w,Ma)
       ENDIF

       IF (flag_dnwd(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dnwd",itau_w,dnwd)
       ENDIF

       IF (flag_dnwd0(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dnwd0",itau_w,dnwd0)
       ENDIF
      ENDIF !(iflag_con.GE.3)

       IF (flag_dtdyn(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dtdyn",itau_w,d_t_dyn)
       ENDIF

       IF (flag_dqdyn(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dqdyn",itau_w,d_q_dyn)
       ENDIF

       IF (flag_dudyn(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"dudyn",itau_w,d_u_dyn)
       ENDIF                                                    

       IF (flag_dvdyn(iff)<=lev_files(iff)) THEN                 
      CALL histwrite_phy(nid_files(iff),"dvdyn",itau_w,d_v_dyn)  
       ENDIF                                                     

       IF (flag_dtcon(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_t_con(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dtcon",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_ducon(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_u_con(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"ducon",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dqcon(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_q_con(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dqcon",itau_w,zx_tmp_fi3d)
       ENDIF

      IF(iflag_con.GE.3) THEN
       IF (iflag_wake == 1) THEN
         IF (flag_dtwak(iff)<=lev_files(iff)) THEN
           zx_tmp_fi3d(1:klon,1:klev)=d_t_wake(1:klon,1:klev)           &
     &                                        /pdtphys
           CALL histwrite_phy(nid_files(iff),"dtwak",itau_w,zx_tmp_fi3d)
         ENDIF

        IF (flag_dqwak(iff)<=lev_files(iff)) THEN
        zx_tmp_fi3d(1:klon,1:klev)=d_q_wake(1:klon,1:klev)/pdtphys
        CALL histwrite_phy(nid_files(iff),"dqwak",itau_w,zx_tmp_fi3d)
        ENDIF
       ENDIF
      ENDIF !(iflag_con.GE.3) 

       IF (flag_dtlsc(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_t_lsc(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dtlsc",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtlschr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon, 1:klev)=(d_t_lsc(1:klon,1:klev)+
     $                           d_t_eva(1:klon,1:klev))/pdtphys
      CALL histwrite_phy(nid_files(iff),"dtlschr",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dqlsc(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_q_lsc(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dqlsc",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtvdf(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_t_vdf(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dtvdf",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dqvdf(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_q_vdf(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dqvdf",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dteva(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_t_eva(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dteva",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dqeva(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_q_eva(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dqeva",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_ptconv(iff)<=lev_files(iff)) THEN
      zpt_conv = 0.
      where (ptconv) zpt_conv = 1.
      CALL histwrite_phy(nid_files(iff),"ptconv",itau_w,zpt_conv)
       ENDIF

       IF (flag_ratqs(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"ratqs",itau_w,ratqs)
       ENDIF

       IF (flag_dtthe(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_t_ajs(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dtthe",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (iflag_thermals.gt.1) THEN
        IF (flag_f_th(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),"f_th",itau_w,fm_therm)
        ENDIF

        IF (flag_e_th(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),"e_th",itau_w,entr_therm)
        ENDIF

        IF (flag_w_th(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),"w_th",itau_w,zw2)
        ENDIF

        IF (flag_q_th(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),"q_th",itau_w,zqasc)
        ENDIF

        IF (flag_lambda_th(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),"lambda_th",itau_w,lambda_th)
        ENDIF

        IF (flag_a_th(iff)<=lev_files(iff)) THEN
        CALL histwrite_phy(nid_files(iff),"a_th",itau_w,fraca)
        ENDIF

       IF (flag_d_th(iff)<=lev_files(iff)) THEN
       CALL histwrite_phy(nid_files(iff),"d_th",itau_w,detr_therm)
       ENDIF

       ENDIF !iflag_thermals

       IF (flag_f0_th(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"f0_th",itau_w,f0)
       ENDIF

       IF (flag_f0_th(iff)<=lev_files(iff)) THEN
      CALL histwrite_phy(nid_files(iff),"zmax_th",itau_w,zmax0)
       ENDIF

       IF (flag_dqthe(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_q_ajs(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dqthe",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtajs(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_t_ajsb(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dtajs",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dqajs(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_q_ajsb(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dqajs",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtswr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=heat(1:klon,1:klev)/RDAY
      CALL histwrite_phy(nid_files(iff),"dtswr",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtsw0(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=heat0(1:klon,1:klev)/RDAY
      CALL histwrite_phy(nid_files(iff),"dtsw0",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtlwr(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=-1.*cool(1:klon,1:klev)/RDAY
      CALL histwrite_phy(nid_files(iff),"dtlwr",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtlw0(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=-1.*cool0(1:klon,1:klev)/RDAY
      CALL histwrite_phy(nid_files(iff),"dtlw0",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dtec(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_t_ec(1:klon,1:klev)
      CALL histwrite_phy(nid_files(iff),"dtec",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_duvdf(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_u_vdf(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"duvdf",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (flag_dvvdf(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_v_vdf(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dvvdf",itau_w,zx_tmp_fi3d)
       ENDIF

       IF (ok_orodr) THEN
      IF (flag_duoro(iff)<=lev_files(iff)) THEN 
      zx_tmp_fi3d(1:klon,1:klev)=d_u_oro(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"duoro",itau_w,zx_tmp_fi3d)
       ENDIF

      IF (flag_dvoro(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_v_oro(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dvoro",itau_w,zx_tmp_fi3d)
      ENDIF
       ENDIF

        IF (ok_orolf) THEN
       IF (flag_dulif(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_u_lif(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dulif",itau_w,zx_tmp_fi3d)
       ENDIF

        IF (flag_dvlif(iff)<=lev_files(iff)) THEN
      zx_tmp_fi3d(1:klon,1:klev)=d_v_lif(1:klon,1:klev)/pdtphys
      CALL histwrite_phy(nid_files(iff),"dvlif",itau_w,zx_tmp_fi3d)
       ENDIF
        ENDIF

       IF (flag_trac(iff)<=lev_files(iff)) THEN
         if (nqmax.GE.3) THEN
           DO iq=3,nqmax
         CALL histwrite_phy(nid_files(iff),tnom(iq),itau_w,qx(:,:,iq))
           ENDDO
          endif

       ENDIF
      if (ok_sync) then
c$OMP MASTER
        call histsync(nid_files(iff))
c$OMP END MASTER
      endif

       ENDIF ! clef_files

      ENDDO ! iff=1,nfiles
