MODULE mod_const_mpi

  INTEGER,SAVE :: COMM_LMDZ
  INTEGER,SAVE :: MPI_REAL_LMDZ
 

CONTAINS 

  SUBROUTINE Init_const_mpi
    USE IOIPSL

    IMPLICIT NONE
    INCLUDE 'mpif.h'
    INTEGER             :: ierr
    INTEGER             :: comp_id
    INTEGER             :: thread_required
    INTEGER             :: thread_provided
    CHARACTER(len = 6)  :: ocean

!$OMP MASTER
    ocean = 'force '
    CALL getin('OCEAN', ocean)
!$OMP END MASTER
!$OMP BARRIER

    IF (ocean=='couple') THEN
#ifdef CPP_COUPLE
!$OMP MASTER
       CALL prism_init_comp_proto (comp_id, 'lmdz.x', ierr)
       CALL prism_get_localcomm_proto(COMM_LMDZ,ierr)
!$OMP END MASTER
#endif
    ELSE
!$OMP MASTER
       thread_required=MPI_THREAD_SERIALIZED
       CALL MPI_INIT_THREAD(thread_required,thread_provided,ierr)
       IF (thread_provided < thread_required) THEN
         CALL abort_gcm('The multithreaded level of MPI librairy do not provide the requiered level', &
                        'mod_const_mpi::Init_const_mpi',1)
       ENDIF
       COMM_LMDZ=MPI_COMM_WORLD
!$OMP END MASTER
    END IF

    MPI_REAL_LMDZ=MPI_REAL8
  END SUBROUTINE Init_const_mpi

END MODULE mod_const_mpi
