      SUBROUTINE INI_WAKE(wape,fip,it_wape_prescr,
     :     wape_prescr, fip_prescr, alp_bl_prescr, ale_bl_prescr)
***************************************************************
*                                                             *
*        INI_WAKE : variables d'initialisation de la poche    *
*                   froide, necessaires au declenchement      *
*                   de la convection.                         *
*                                                             *
*                                                             *
***************************************************************
c Arguments
c =========
c Input
c -----
c   wape           : valeur de l'energie potentielle de la poche (WAPE)
c                    dans l'etat initial
c   fip            : valeur de la puissance incidente sur le front (FIP)
c                    dans l'etat initial
c Output
c ------
c   it_wape_prescr : nombre de pas de temps pendant lesquels la WAPE
c            doit etre imposee.
c   wape_prescr    : valeur prescrite de la WAPE.
c   fip_prescr     : valeur prescrite de la FIP.
c
c Variables internes
c ==================
c   it = nbre de pas de temps lu
c   w  = WAPE lue
c   f  = FIP lue
c
cdeclarations
      real ale_bl_prescr
      real alp_bl_prescr
      real it
cCR: on rajoute ale et alp de la PBL precrits
c     open (99,file='wake.data',form='formatted')
c     read (99,*) it
c     read (99,*) w
c     read (99,*) f
c     read (99,*) u
c     read (99,*) p
c     close (99)

! FH A mettre si besoin dans physiq.def
! FH : voir avec JYG
      it=0.
      w=4.
      f=0.1
      u=0.1
      p=4.
c
      print *,' it,w ',it,w
      it_wape_prescr = it
      if (w .lt. 0) then
         wape_prescr = wape
         fip_prescr = fip
      else
         wape_prescr = w
         fip_prescr = f
      endif
c
      print *,' u,p ',u,p
      alp_bl_prescr=u
      ale_bl_prescr=p
      print *,'Initialisation de la poche : WAPE, FIP imposees ='
     $               ,wape_prescr, fip_prescr
      print *, '                   pendant ',it_wape_prescr,' steps'
c
      print *,'Initialisation de la BL: ALP, ALE imposees ='
     $               ,alp_bl_prescr, ale_bl_prescr
      return
      end
