!
! $Header$
!
c
      SUBROUTINE phyredem (fichnom)

      USE dimphy
      USE mod_grid_phy_lmdz
      USE mod_phys_lmdz_para
      USE ocean_slab_mod,   ONLY : ocean_slab_final
      USE fonte_neige_mod,  ONLY : fonte_neige_final
      USE pbl_surface_mod,  ONLY : pbl_surface_final
      USE surface_data,     ONLY : ocean, ok_veget
      USE phys_state_var_mod

      IMPLICIT none
c======================================================================
c Auteur(s) Z.X. Li (LMD/CNRS) date: 19930818
c Objet: Ecriture de l'etat de redemarrage pour la physique
c======================================================================
#include "netcdf.inc"
#include "indicesol.h"
#include "dimsoil.h"
#include "clesphys.h"
#include "control.h"
#include "temps.h"
#include "thermcell.h"
#include "compbl.h"
c======================================================================
      CHARACTER*(*) fichnom

c les variables globales ecrites dans le fichier restart
      REAL rlat_glo(klon_glo), rlon_glo(klon_glo)
      REAL pctsrf_glo(klon_glo, nbsrf)
      REAL tsol_glo(klon_glo,nbsrf)
      REAL alb1_glo(klon_glo,nbsrf)
      REAL alb2_glo(klon_glo,nbsrf)
      REAL rain_fall_glo(klon_glo)
      REAL snow_fall_glo(klon_glo)
      real solsw_glo(klon_glo)
      real sollw_glo(klon_glo)
      REAL radsol_glo(klon_glo)
      REAL zmea_glo(klon_glo)
      REAL zstd_glo(klon_glo)
      REAL zsig_glo(klon_glo)
      REAL zgam_glo(klon_glo)
      REAL zthe_glo(klon_glo)
      REAL zpic_glo(klon_glo)
      REAL zval_glo(klon_glo)
      REAL rugsrel_glo(klon_glo)
      REAL t_ancien_glo(klon_glo,klev), q_ancien_glo(klon_glo,klev)
      REAL clwcon_glo(klon_glo,klev)
      REAL rnebcon_glo(klon_glo,klev) 
      REAL ratqs_glo(klon_glo,klev)
      REAL pbl_tke_glo(klon_glo,klev,nbsrf)
      REAL zmax0_glo(klon_glo), f0_glo(klon)
      REAL ema_work1_glo(klon_glo, klev), ema_work2_glo(klon_glo, klev)

cIM "slab" ocean
      REAL tsoil_p(klon,nsoilmx,nbsrf)
      REAL tslab_p(klon), seaice_p(klon)
      REAL qsurf_p(klon,nbsrf)
      REAL qsol_p(klon)
      REAL snow_p(klon,nbsrf)
      REAL evap_p(klon,nbsrf)
      real fder_p(klon)
      REAL frugs_p(klon,nbsrf)
      REAL agesno_p(klon,nbsrf)
      REAL run_off_lic_0_p(klon)
      
      REAL tsoil(klon_glo,nsoilmx,nbsrf)
      REAL tslab(klon_glo), seaice(klon_glo)
      REAL qsurf(klon_glo,nbsrf)
      REAL qsol(klon_glo)
      REAL snow(klon_glo,nbsrf)
      REAL evap(klon_glo,nbsrf)
      real fder(klon_glo)
      REAL frugs(klon_glo,nbsrf)
      REAL agesno(klon_glo,nbsrf)
      REAL run_off_lic_0(klon_glo)
      REAL masq(klon_glo)
c
      INTEGER nid, nvarid, idim1, idim2, idim3
      INTEGER ierr
      INTEGER length
      PARAMETER (length=100)
      REAL tab_cntrl(length)
c
      INTEGER isoil, nsrf
      CHARACTER (len=7) :: str7
      CHARACTER (len=2) :: str2

c======================================================================
c 
c Get variables which will be written to restart file from module 
c pbl_surface_mod
      CALL pbl_surface_final(qsol_p, fder_p, snow_p, qsurf_p, 
     $     evap_p, frugs_p, agesno_p, tsoil_p)

c Get a variable calculated in module fonte_neige_mod
      CALL fonte_neige_final(run_off_lic_0_p)

c If slab ocean then get 2 varaibles from module ocean_slab_mod
      IF ( ocean == 'slab' ) THEN
         CALL ocean_slab_final(tslab_p, seaice_p)
      ELSE 
         tslab_p(:)  = 0.0
         seaice_p(:) = 0.0
      ENDIF      

c======================================================================

      call Gather( rlat,rlat_glo)
      call Gather( rlon,rlon_glo)
      call Gather( pctsrf,pctsrf_glo)
      call Gather( ftsol,tsol_glo)
      call Gather( falb1,alb1_glo)
      call Gather( falb2,alb2_glo)
      call Gather( rain_fall,rain_fall_glo)
      call Gather( snow_fall,snow_fall_glo)
      call Gather( sollw,sollw_glo)
      call Gather( solsw,solsw_glo)
      call Gather( radsol,radsol_glo)
      call Gather( zmea,zmea_glo)
      call Gather( zstd,zstd_glo)
      call Gather( zsig,zsig_glo)
      call Gather( zgam,zgam_glo)
      call Gather( zthe,zthe_glo)
      call Gather( zpic,zpic_glo)
      call Gather( zval,zval_glo)
      call Gather( rugoro,rugsrel_glo)
      call Gather( t_ancien,t_ancien_glo)
      call Gather( q_ancien,q_ancien_glo)
      call Gather( clwcon,clwcon_glo)
      call Gather( rnebcon,rnebcon_glo)
      call Gather( ratqs,ratqs_glo)
      call Gather( pbl_tke,pbl_tke_glo)
      call Gather( zmax0,zmax0_glo)
      call Gather( f0,f0_glo)
      call Gather( ema_work1, ema_work1_glo)
      call Gather( ema_work2, ema_work2_glo)

      call Gather( tsoil_p,tsoil)
      call Gather( tslab_p,tslab)
      call Gather( seaice_p,seaice)
      call Gather( qsurf_p,qsurf)
      call Gather( qsol_p,qsol)
      call Gather( snow_p,snow)
      call Gather( evap_p,evap)
      call Gather( fder_p,fder)
      call Gather( frugs_p,frugs)
      call Gather( agesno_p,agesno)
      call Gather( run_off_lic_0_p,run_off_lic_0)
      call Gather( zmasq,masq)
      
c$OMP MASTER
      IF (is_mpi_root) THEN
      
      ierr = NF_CREATE(fichnom, NF_CLOBBER, nid)
      IF (ierr.NE.NF_NOERR) THEN
        write(6,*)' Pb d''ouverture du fichier '//fichnom
        write(6,*)' ierr = ', ierr
        CALL ABORT
      ENDIF
c
      ierr = NF_PUT_ATT_TEXT (nid, NF_GLOBAL, "title", 28,
     .                       "Fichier redemmarage physique")
c
      ierr = NF_DEF_DIM (nid, "index", length, idim1)
      ierr = NF_DEF_DIM (nid, "points_physiques", klon_glo, idim2)
      ierr = NF_DEF_DIM (nid, "horizon_vertical", klon_glo*klev, idim3)
c
      ierr = NF_ENDDEF(nid)
c
      DO ierr = 1, length
         tab_cntrl(ierr) = 0.0
      ENDDO
      tab_cntrl(1) = dtime
      tab_cntrl(2) = radpas
      tab_cntrl(3) = co2_ppm
      tab_cntrl(4) = solaire
      tab_cntrl(5) = iflag_con
      tab_cntrl(6) = nbapp_rad

      IF( cycle_diurne ) tab_cntrl( 7 ) = 1.
      IF(   soil_model ) tab_cntrl( 8 ) = 1.
      IF(     new_oliq ) tab_cntrl( 9 ) = 1.
      IF(     ok_orodr ) tab_cntrl(10 ) = 1.
      IF(     ok_orolf ) tab_cntrl(11 ) = 1.

      tab_cntrl(13) = day_end
      tab_cntrl(14) = annee_ref
      tab_cntrl(15) = itau_phy
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "controle", NF_DOUBLE, 1, idim1,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "controle", NF_FLOAT, 1, idim1,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Parametres de controle")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tab_cntrl)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,tab_cntrl)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "longitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "longitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Longitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlon_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlon_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "latitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "latitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 31,
     .                        "Latitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlat_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlat_glo)
#endif
c
C PB ajout du masque terre/mer
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "masque", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "masque", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 16,
     .                        "masque terre mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,masq)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,masq)
#endif      
c BP ajout des fraction de chaque sous-surface
C
C 1. fraction de terre 
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FTER", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FTER", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 21,
     .                        "fraction de continent")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf_glo(1 : klon_glo,     &
     &   is_ter))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf_glo(1 : klon_glo,       &
     &    is_ter))
#endif
C 
C 2. Fraction de glace de terre
C 
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FLIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FLIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 24,
     .                        "fraction glace de terre")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf_glo(1 : klon_glo,
     &                          is_lic))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf_glo(1 : klon_glo, 
     &                        is_lic))
#endif
C
C 3. fraction ocean
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FOCE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FOCE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 14,
     .                        "fraction ocean")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf_glo(1 : klon_glo,
     &                          is_oce))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf_glo(1 : klon_glo,
     &                        is_oce))
#endif
C
C 4. Fraction glace de mer
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FSIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FSIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 18,
     .                        "fraction glace mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf_glo(1 : klon_glo, 
     &                          is_sic))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf_glo(1 : klon_glo,
     &                         is_sic))
#endif
C
C
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "TS"//str2, NF_DOUBLE, 1, idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "TS"//str2, NF_FLOAT, 1, idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Temperature de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsol_glo(1,nsrf))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsol_glo(1,nsrf))
#endif
      ENDDO
c
      DO nsrf = 1, nbsrf
      DO isoil=1, nsoilmx
        IF (isoil.LE.99 .AND. nsrf.LE.99) THEN
        WRITE(str7,'(i2.2,"srf",i2.2)') isoil,nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "Tsoil"//str7,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "Tsoil"//str7,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 29,
     .                        "Temperature du sol No."//str7)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de couches"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsoil(1,isoil,nsrf))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsoil(1,isoil,nsrf))
#endif
      ENDDO
      ENDDO
c
cIM "slab" ocean
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "TSLAB", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "TSLAB", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 33,
     .                        "Ecart de la SST (pour slab-ocean)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tslab)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,tslab)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "SEAICE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "SEAICE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 33,
     .                        "Glace de mer kg/m2 (pour slab-ocean)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,seaice)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,seaice)
#endif
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"QS"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"QS"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 25,
     .                        "Humidite de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,qsurf(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,qsurf(1,nsrf))
#endif
      END DO
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid,"QSOL",NF_DOUBLE,1,idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid,"QSOL",NF_FLOAT,1,idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 20,
     .    "Eau dans le sol (mm)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,qsol)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,qsol)
#endif
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"ALBE"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"ALBE"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "albedo de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,alb1_glo(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,alb1_glo(1,nsrf))
#endif
      ENDDO

        DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"ALBLW"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"ALBLW"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "albedo LW de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,alb2_glo(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,alb2_glo(1,nsrf))
#endif
      ENDDO
c
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"EVAP"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"EVAP"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Evaporation de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,evap(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,evap(1,nsrf))
#endif
      ENDDO

c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"SNOW"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"SNOW"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Neige de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,snow(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,snow(1,nsrf))
#endif
      ENDDO

c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RADS", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RADS", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Rayonnement net a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,radsol_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,radsol_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "solsw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "solsw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Rayonnement solaire a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,solsw_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,solsw_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "sollw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "sollw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 27,
     .                        "Rayonnement IF a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,sollw_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,sollw_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "fder", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "fder", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 14,
     .                        "Derive de flux")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,fder)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,fder)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "rain_f", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "rain_f", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 21,
     .                        "precipitation liquide")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rain_fall_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rain_fall_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "snow_f", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "snow_f", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 20,
     .                        "precipitation solide")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,snow_fall_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,snow_fall_glo)
#endif
c
       endif
c$OMP END MASTER
cc ----> necessaire pour eviter bug openMP sur SX6
c$OMP MASTER
      if (is_mpi_root) then
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"RUG"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"RUG"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "rugosite de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,frugs(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,frugs(1,nsrf))
#endif
      ENDDO
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
            WRITE(str2,'(i2.2)') nsrf
            ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
            ierr = NF_DEF_VAR (nid,"AGESNO"//str2,NF_DOUBLE,1,idim2
     $          ,nvarid)
#else
            ierr = NF_DEF_VAR (nid,"AGESNO"//str2,NF_FLOAT,1,idim2
     $          ,nvarid)
#endif
            ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 15,
     .                        "Age de la neige surface No."//str2)
            ierr = NF_ENDDEF(nid)
        ELSE
            PRINT*, "Trop de sous-mailles"
            CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,agesno(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,agesno(1,nsrf))
#endif
      ENDDO
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZMEA", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZMEA", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zmea_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zmea_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZSTD", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZSTD", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zstd_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zstd_glo)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZSIG", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZSIG", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zsig_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zsig_glo)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZGAM", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZGAM", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zgam_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zgam_glo)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZTHE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZTHE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zthe_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zthe_glo)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZPIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZPIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zpic_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zpic_glo)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZVAL", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZVAL", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zval_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zval_glo)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RUGSREL", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RUGSREL", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rugsrel_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rugsrel_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_DOUBLE, 1, idim3,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_FLOAT, 1, idim3,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,t_ancien_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,t_ancien_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "QANCIEN", NF_DOUBLE, 1, idim3,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "QANCIEN", NF_FLOAT, 1, idim3,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,q_ancien_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,q_ancien_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RUGMER", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RUGMER", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Longueur de rugosite sur mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,frugs(1,is_oce))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,frugs(1,is_oce))
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "CLWCON", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "CLWCON", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Eau liquide convective")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,clwcon_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,clwcon_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RNEBCON", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RNEBCON", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Nebulosite convective")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rnebcon_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rnebcon_glo)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RATQS", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RATQS", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Ratqs")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,ratqs_glo)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,ratqs_glo)
#endif
c
c run_off_lic_0
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr=NF_DEF_VAR(nid,"RUNOFFLIC0",NF_DOUBLE,1,idim2,nvarid)
#else
      ierr=NF_DEF_VAR(nid,"RUNOFFLIC0",NF_FLOAT, 1,idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Runofflic0")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,run_off_lic_0)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,run_off_lic_0)
#endif
c
c
!!!!!!!!!!!!!!!!!!!! DEB TKE PBL !!!!!!!!!!!!!!!!!!!!!!!!!
c
      IF (iflag_pbl>1) then
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
            WRITE(str2,'(i2.2)') nsrf
            ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
            ierr = NF_DEF_VAR (nid,"TKE"//str2,NF_DOUBLE,1,idim3
     $          ,nvarid)
#else
            ierr = NF_DEF_VAR (nid,"TKE"//str2,NF_FLOAT,1,idim3
     $          ,nvarid)
#endif
            ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 15,
     .                        "Energ. Cineti. Turb."//str2)
            ierr = NF_ENDDEF(nid)
        ELSE
            PRINT*, "Trop de sous-mailles"
            CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pbl_tke_glo(:,:,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pbl_tke_glo(:,:,nsrf))
#endif
      ENDDO
      ENDIF

!!!!!!!!!!!!!!!!!!!! FIN TKE PBL !!!!!!!!!!!!!!!!!!!!!!!!!
c
      ierr = NF_CLOSE(nid)
c
      endif   ! is_mpi_root
c$OMP END MASTER
      RETURN
      END
