! Abderrahmane 12 2007
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!! Ecreture des Sorties du modele dans les fichiers Netcdf :
! histmth.nc : moyennes mensuelles
! histday.nc : moyennes journalieres
! histhf.nc  : moyennes toutes les 3 heures
! histins.nc : valeurs instantanees
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

MODULE phys_output_mod

  IMPLICIT NONE

   integer, parameter                :: nfiles = 4
   logical, dimension(nfiles), save  :: clef_files
   integer, dimension(nfiles), save  :: lev_files
   integer, dimension(nfiles), save  :: nid_files
!   integer, save                     :: nid_hf3d 

!!!!!!!!!! stockage dans une region limitee pour chaque fichier !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                 entre [lonmin_reg,lonmax_reg] et [latmin_reg,latmax_reg]

  logical, dimension(nfiles), save  :: ok_reglim         = (/ .false., .true., .true., .false. /) 
  real, dimension(nfiles), save     :: lonmin_reg        = (/ 0., 0., 0., 0. /)
  real, dimension(nfiles), save     :: lonmax_reg        = (/ 90., 90., 90., 90. /)
  real, dimension(nfiles), save     :: latmin_reg        = (/ 0., 0., 0., 0. /)
  real, dimension(nfiles), save     :: latmax_reg        = (/ 90., 90., 90., 90. /)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! Definition pour chaque variable du niveau d ecriture dans chaque fichier
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!/ histmth, histday, histhf, histins /)!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!!! 1D
  integer, dimension(nfiles) , save :: flag_phis         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_aire         = (/ 1, 1, 10,  1 /)
  integer, dimension(nfiles) , save :: flag_contfracATM  = (/ 10, 1,  1, 10 /)
  integer, dimension(nfiles) , save :: flag_contfracOR   = (/ 10, 1,  1, 10 /)
  integer, dimension(nfiles) , save :: flag_aireTER      = (/ 10, 10, 1, 10 /)
  
!!! 2D
  integer, dimension(nfiles) , save :: flag_flat         = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_slp          = (/ 1, 1, 1, 10 /)
  integer, dimension(nfiles) , save :: flag_tsol         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_t2m          = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_t2m_min      = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_t2m_max      = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_t2m_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_wind10m      = (/ 1, 1, 1, 10 /)
  integer, dimension(nfiles) , save :: flag_wind10max    = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_sicf         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_q2m          = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_u10m         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_v10m         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_psol         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_qsurf        = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_u10m_sol     = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_v10m_sol     = (/ 10, 4, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_qsol         = (/ 1, 10, 10, 1 /)

  integer, dimension(nfiles),save   :: flag_ndayrain     = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles),save  :: flag_precip(nfiles)= (/ 1, 1, 1, 1 /)
  integer,  dimension(nfiles), save :: flag_plul(nfiles) = (/ 1, 1, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_pluc         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_snow         = (/ 1, 1, 10, 1 /) 
  integer, dimension(nfiles) , save :: flag_evap         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_tops         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tops0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_topl         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_topl0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupTOA      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupTOAclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdnTOA      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdnTOAclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWup200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWup200clr   = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdn200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdn200clr   = (/ 10, 1, 10, 10 /)

! arajouter
!  integer, dimension(nfiles) , save :: flag_LWupTOA     = (/ 1, 4, 10, 10 /)
!  integer, dimension(nfiles) , save :: flag_LWupTOAclr  = (/ 1, 4, 10, 10 /)
!  integer, dimension(nfiles) , save :: flag_LWdnTOA     = (/ 1, 4, 10, 10 /)
!  integer, dimension(nfiles) , save :: flag_LWdnTOAclr  = (/ 1, 4, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_LWup200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWup200clr   = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdn200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdn200clr   = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_sols         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_sols0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_soll         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_soll0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_radsol       = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupSFC      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdnSFC      = (/ 1, 1, 10, 10 /) 
  integer, dimension(nfiles) , save :: flag_SWdnSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWupSFC      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWupSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdnSFC      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdnSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_bils         = (/ 1, 2, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_sens         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_fder         = (/ 1, 2, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_ffonte       = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fqcalving    = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fqfonte      = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_taux_sol     = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_tauy_sol     = (/ 1, 4, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_pourc_sol    = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_fract_sol    = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_tsol_sol     = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_sens_sol     = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_lat_sol      = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_flw_sol      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fsw_sol      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_wbils_sol    = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_wbilo_sol    = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_cdrm         = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_cdrh         = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_cldl         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldm         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldh         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldt         = (/ 1, 1, 2, 10 /)
  integer, dimension(nfiles) , save :: flag_cldq         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_lwp          = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_iwp          = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ue           = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ve           = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_uq           = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_vq           = (/ 1, 10, 10, 10 /)
 
  integer, dimension(nfiles) , save :: flag_cape         = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pbase        = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ptop         = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fbase        = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_prw          = (/ 1, 1, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_s_pblh       = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_pblt       = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_lclt       = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_capCL      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_oliqCLL    = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_cteiCL     = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_therm      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_trmb1      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_trmb2      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_trmb3      = (/ 1, 10, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_slab_bils    = (/ 1, 1, 10, 10 /)

! Champs interpolles sur des niveaux de pression ??? a faire correctement
! if=1 on ecrit u v w phi sur 850 700 500 200 au niv 1
! if=2 on ecrit w et ph 500 seulement au niv 1
!        et u v sur 850 700 500 200
! if=3 on ecrit ph a 500 seulement au niv 1
!      on ecrit u v t q a 850 700 500 200 au niv 3
!      on ecrit ph  a 500   au niv 3

  integer, dimension(nfiles) , save :: flag_ulevsSTD     = (/ 1, 1, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_vlevsSTD     = (/ 1, 1, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_wlevsSTD     = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tlevsSTD     = (/ 10, 10, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_qlevsSTD     = (/ 10, 10, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_philevsSTD   = (/ 1, 1, 1, 10 /)

  integer, dimension(nfiles) , save :: flag_fluxo        = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fluxg        = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_t_oce_sic    = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_lmt_bils     = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tslab        = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_seaice       = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_siceh        = (/ 1, 1, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_weakinv      = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dthmin       = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_u10_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_v10_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_meantaucld   = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldtau       = (/ 10, 5, 10, 10 /)                     
  integer, dimension(nfiles) , save :: flag_cldemi       = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rh2m         = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_qsat2m       = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tpot         = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tpote        = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke          = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke_max      = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke_max_sol  = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_kz           = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_kz_max       = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWnetOR      = (/ 10, 10, 2, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdownOR     = (/ 10, 10, 2, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdownOR     = (/ 10, 10, 2, 10 /)

  integer, dimension(nfiles) , save :: flag_snowl         = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cape_max      = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_solldown      = (/ 10, 1, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_dtsvdfo       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dtsvdft       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dtsvdfg       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dtsvdfi       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_rugs          = (/ 10, 10, 10, 1 /)

!!!!!!!!!!!!!!!!!!!!!! 3D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
  integer, dimension(nfiles) , save :: flag_lwcon        = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_iwcon        = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_temp         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_ovap         = (/ 2, 3, 4, 10 /)
  integer, dimension(nfiles) , save :: flag_wvapp        = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_geop         = (/ 2, 3, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_vitu         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_vitv         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_vitw         = (/ 2, 3, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pres         = (/ 2, 3, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_rneb         = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rnebcon      = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rhum         = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ozone        = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_upwd         = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtphy        = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqphy        = (/ 2, 10, 10, 10 /)
! arevoir probleme noms (geop, ovap  a ?????)

  integer, dimension(nfiles) , save :: flag_albe_sol     = (/ 3, 4, 10, 1 /) 
  integer, dimension(nfiles) , save :: flag_ages_sol     = (/ 3, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rugs_sol     = (/ 3, 4, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_albs         = (/ 3, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_albslw       = (/ 3, 10, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_clwcon       = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_Ma           = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dnwd         = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dnwd0        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtdyn        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqdyn        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtcon        = (/ 4, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ducon        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqcon        = (/ 4, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlsc        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlschr      = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqlsc        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtvdf        = (/ 4, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dqvdf        = (/ 4, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dteva        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqeva        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ptconv       = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ratqs        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtthe        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqthe        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtajs        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqajs        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtswr        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtsw0        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlwr        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlw0        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtec         = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_duvdf        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dvvdf        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_duoro        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dvoro        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dulif        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dvlif        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_trac         = (/ 4, 10, 10, 10 /)

    CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!! Ouverture des fichier et definition des variable de sortie !!!!!!!!
!! histbeg, histvert et histdef
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 

       SUBROUTINE phys_output_open ( jj_nb, jjmp1, nqmax, &
     &                nlevSTD, clevSTD, nbteta, ctetaSTD, &
     &              dtime, presnivs, ok_veget, ocean, iflag_pbl, &
     &                ok_mensuel,ok_journe,ok_hf,ok_instan, &
     &                 rlon, rlat, nid_fil) 


   
       USE iophy 
       USE dimphy
       USE ioipsl

       IMPLICIT NONE
       include "dimensions.h"
       include "temps.h"
       include "indicesol.h"
       include "advtrac.h"
       include "clesphys.h"

        integer      :: jj_nb, jjmp1, nqmax
        integer      :: nbteta, nlevSTD, radpas
        logical      :: ok_mensuel, ok_journe, ok_hf, ok_instan
        real         :: dtime, zstophy, zout
        integer      :: nhori, nvert
        integer      :: idayref
        real         :: zjulian
        real, dimension(klev) :: presnivs
        character(len=4), dimension(nlevSTD) :: clevSTD
        integer      :: nsrf, k, iq, iiq, iff, i, j
        logical      :: ok_veget
        integer           :: iflag_pbl
        CHARACTER(len=3)  :: bb2
        CHARACTER(len=2)  :: bb3
        character(len=6)  :: ocean
        CHARACTER(len=3)  :: ctetaSTD(nbteta)
        integer, dimension(nfiles) :: nid_fil
        real, dimension(nfiles)    ::  ecrit_files
        CHARACTER(len=20), dimension(nfiles) :: name_files
        CHARACTER(len=20), dimension(nfiles) :: type_ecri
        INTEGER, dimension(iim*jjmp1) ::  ndex2d
        INTEGER, dimension(iim*jjmp1*klev) :: ndex3d
        REAL, dimension(klon) :: rlon, rlat
        integer               :: imin_ins, imax_ins
        integer               :: jmin_ins, jmax_ins
        REAL, dimension(iim,jjmp1) :: zx_lon, zx_lat

        name_files(1) = 'histmth'
        name_files(2) = 'histday'
        name_files(3) = 'histhf'
        name_files(4) = 'histins'

        type_ecri(1) = 'ave(X)'
        type_ecri(2) = 'ave(X)'
        type_ecri(3) = 'ave(X)'
        type_ecri(4) = 'inst(X)'

        clef_files(1) = ok_mensuel
        clef_files(2) = ok_journe
        clef_files(3) = ok_hf
        clef_files(4) = ok_instan

        lev_files(1) = lev_histmth
        lev_files(2) = lev_histday
        lev_files(3) = lev_histhf
        lev_files(4) = 1

        ecrit_files(1) = ecrit_mth
        ecrit_files(2) = ecrit_day
        ecrit_files(3) = ecrit_hf
        ecrit_files(4) = ecrit_ins
 
!!!!!!!!!!!!!!!!!!!!!!! Boucle sur les fichiers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Appel de histbeg et histvert pour creer le fichier et les niveaux verticaux !!
! Appel des histbeg pour definir les variables (nom, moy ou inst, freq de sortie ..
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

      DO iff=1,nfiles
  
       IF (clef_files(iff)) THEN
      
         zstophy = dtime         ! Frequence ou l on moyenne
         zout = ecrit_files(iff) ! Frequence ou l on ecrit

          idayref = day_ref

          CALL ymds2ju(annee_ref, 1, idayref, 0.0, zjulian)

!         print*,'Dans hist_def, name_files(iff) ',name_files(iff)

!!!!!!!!!!!!!!!!! Traitement dans le cas ou l'on veut stocker sur un domaine limite !!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         if (ok_reglim(iff)) then

! a reecrire plus simplement en appelant io_lat et io_lon de iophy

           CALL gr_fi_ecrit(1,klon,iim,jjmp1,rlon,zx_lon)
           CALL gr_fi_ecrit(1,klon,iim,jjmp1,rlat,zx_lat)

           DO i = 1, iim
              zx_lon(i,1) = rlon(i+1)
              zx_lon(i,jjmp1) = rlon(i+1)
           ENDDO

                
           imin_ins=1
           imax_ins=iim
           jmin_ins=1
           jmax_ins=jjmp1

           do i=1,iim-1
            if (zx_lon(i,1).lt.lonmin_reg(iff)) imin_ins=i
            if (zx_lon(i,1).le.lonmax_reg(iff)) imax_ins=i+1
           enddo

           do j=1,jjmp1-1
            if (zx_lat(1,j).ge.latmin_reg(iff)) jmax_ins=j
            if (zx_lat(1,j).gt.latmax_reg(iff)) jmin_ins=j
           enddo


         print*,'On stoke le fichier hist sur, ', &
     &   imin_ins,imax_ins,jmin_ins,jmax_ins 
         print*,'On stoke le fichier instantanne sur, ', &
     &   zx_lon(imin_ins,1),zx_lon(imax_ins,1), &
     &   zx_lat(1,jmin_ins),zx_lat(1,jmax_ins)

     
         CALL histbeg(name_files(iff),iim,zx_lon(:,1), &
     &                jjmp1,zx_lat(1,:), &
     &            imin_ins,imax_ins-imin_ins+1, &
     &           jmin_ins,jmax_ins-jmin_ins+1, &
     &           itau_phy, zjulian, dtime, &
     &          nhori, nid_fil(iff))

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
       else

          CALL histbeg_phy(name_files(iff),itau_phy, & 
     &                     zjulian, dtime, &
     &                     nhori, nid_fil(iff))
       endif
 
          nid_files(iff)=nid_fil(iff)
!         print*,'Dans hist_def, nid_files(iff) ',nid_files(iff)

         CALL histvert(nid_files(iff),"presnivs", &
     &                 "Vertical levels","mb", &
     &                 klev, presnivs/100., nvert)

!!!!!!!!!!!!! Traitement des champs 3D pour histhf !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!! A Revoir plus tard !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!          IF (iff.eq.3.and.lev_files(iff).ge.4) THEN
!          CALL histbeg_phy("histhf3d",itau_phy, &
!     &                     zjulian, dtime, &
!     &                     nhori, nid_hf3d)

!         CALL histvert(nid_hf3d,"presnivs", &
!     &                 "Vertical levels","mb", &
!     &                 klev, presnivs/100., nvert)
!          ENDIF


!!! Champs 1D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
       IF (flag_phis(iff)<=lev_files(iff)) THEN
        CALL  histdef(nid_files(iff),"phis", &
     &                 "Surface geop. height", "m2/s2", &
     &	              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                 "once",  zstophy,zout)
       ENDIF

       IF (flag_aire(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "aire", "Grid area", "-", &
     &               iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              "once",  zstophy,zout)
       ENDIF


       IF (flag_contfracATM(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), &
     &               "contfracATM","% sfce ter+lic ", &
     &               "-", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "once", zstophy,zout)
      ENDIF

       IF (flag_contfracOR(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), &
     &                "contfracOR","% sfce terre OR", &
     &                 "-", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "once", zstophy,zout)
      ENDIF

       IF (flag_aireTER(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), &
     &                "aireTER","Grid area CONT","-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "once", zstophy,zout)
      ENDIF

!!! Champs 2D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

       IF (flag_flat(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "flat", "Latent heat flux", &
     &                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_slp(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "slp", &
     &               "Sea Level Pressure", "Pa", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_tsol(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "tsol", &
     &                "Surface Temperature", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
       ENDIF

       IF (flag_t2m(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "t2m", &
     &                "Temperature 2m", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_t2m_min(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "t2m_min", &
     &                "Temp 2m min", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "t_min(X)", zstophy,zout)
      ENDIF

       IF (flag_t2m_max(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "t2m_max", &
     &                "Temp 2m max", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "t_max(X)", zstophy,zout)
      ENDIF

       IF (flag_wind10m(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff), "wind10m", &
     &                "10-m wind speed","m/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_wind10max(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "wind10max", &
     &                "10-m wind speed max.", "m/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "t_max(X)", zstophy,zout)
       ENDIF

       IF (flag_sicf(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "sicf", &
     &                "Sea-ice fraction", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_q2m(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "q2m", &
     &                "Specific humidity 2m", &
     &                "kg/kg", iim,jj_nb,nhori, & 
     &                1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
       ENDIF

       IF (flag_u10m(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "u10m", &
     &                "Vent zonal 10m", "m/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_v10m(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "v10m", &
     &                "Vent meridien 10m", &
     &                "m/s", iim,jj_nb,nhori, &
     &                1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_psol(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"psol", &
     &                "Surface Pressure","Pa", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_qsurf(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"qsurf", &
     &                "Surface Air humidity", &
     &             "kg/kg",iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

      if (.not. ok_veget) then
       IF (flag_qsol(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "qsol", &
     &                "Soil watter content", &
     &                "mm", iim,jj_nb,nhori, &
     &                 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF
      endif

       IF (flag_ndayrain(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ndayrain", &
     &            "Number of day with rain (liq+sol)", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "inst(X)", zout,zout)
      ENDIF

       IF (flag_precip(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"precip", &
     &         "Precip Totale liq+sol","kg/(s*m2)", &
     &             iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &               type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_plul(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "plul", &
     &             "Large-scale Precip.","kg/(s*m2)", &
     &               iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                  type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_pluc(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "pluc", &
     &              "Convective Precip.", "kg/(s*m2)", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_snow(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff),"snow", &
     &               "Snow fall","kg/(s*m2)", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_evap(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"evap", &
     &                "Evaporat", "kg/(s*m2)", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_tops(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff),"tops", &
     &                "Solar rad. at TOA","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_tops0(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff),"tops0", &
     &               "CS Solar rad. at TOA", &
     &          "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_topl(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "topl", &
     &               "IR rad. at TOA", &
     &          "W/m2",iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_topl0(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"topl0", &
     &                "IR rad. at TOA","W/m2", &
     &                 iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWupTOA(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"SWupTOA", &
     &                "SWup at TOA","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWupTOAclr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWupTOAclr", &
     &                "SWup clear sky at TOA","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWdnTOA(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"SWdnTOA", &
     &                "SWdn at TOA","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWdnTOAclr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWdnTOAclr", &
     &                "SWdn clear sky at TOA","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWup200(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"SWup200", &
     &                "SWup at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWup200clr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWup200clr", &
     &              "SWup clear sky at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWdn200(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"SWdn200", &
     &                "SWdn at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWdn200clr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWdn200clr", &
     &                "SWdn clear sky at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWup200(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"LWup200", &
     &                "LWup at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWup200clr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "LWup200clr", &
     &                "LWup clear sky at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWdn200(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"LWdn200", &
     &                "LWdn at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWdn200clr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "LWdn200clr", &
     &                "LWdn clear sky at 200mb","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_sols(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "sols", &
     &               "Solar rad. at surf.", &
     &           "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_sols0(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "sols0", &
     &                "Solar rad. at surf.", &
     &            "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_soll(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"soll", &
     &               "IR rad. at surface","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_radsol(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"radsol", &
     &               "Rayonnement au sol", &
     &          "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_soll0(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "soll0", &
     &                "IR rad. at surface", &
     &             "W/m2",iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWupSFC(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWupSFC", &
     &               "SWup at surface", &
     &                "W/m2",iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWupSFCclr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWupSFCclr", &
     &                "SWup clear sky at surface","W/m2", &
     &               iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWdnSFC(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"SWdnSFC", &
     &               "SWdn at surface","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWdnSFCclr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWdnSFCclr", &
     &                "SWdn clear sky at surface","W/m2", &
     &               iim,jj_nb,nhori, 1,1,1,-99, &
     &                32, type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWupSFC(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"LWupSFC", &
     &               "Upwd. IR rad. at surface", "W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWdnSFC(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"LWdnSFC", &
     &                "Down. IR rad. at surface", &
     &            "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWupSFCclr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"LWupSFCclr", &
     &                "CS Upwd. IR rad. at surface", &
     &            "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWdnSFCclr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"LWdnSFCclr", &
     &                "Down. CS IR rad. at surface", &
     &                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_bils(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), &
     &                "bils","Surf. total heat flux","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_sens(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"sens", &
     &                "Sensible heat flux","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_fder(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"fder", &
     &                "Heat flux derivation","W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_ffonte(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff),"ffonte", &
     &                "Thermal flux for snow melting", &
     &                "W/m2",iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_fqcalving(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "fqcalving", &
     &                 "Ice Calving", &
     &            "kg/m2/s",iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_fqfonte(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "fqfonte", &
     &                "Land ice melt", &
     &           "kg/m2/s",iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

         DO nsrf = 1, nbsrf
            IF (flag_pourc_sol(iff)<=lev_files(iff)) THEN
         call histdef(nid_files(iff), "pourc_"//clnsurf(nsrf), &
     &                "% "//clnsurf(nsrf), "%", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
            ENDIF

            IF (flag_fract_sol(iff)<=lev_files(iff)) THEN
         call histdef(nid_files(iff), "fract_"//clnsurf(nsrf), &
     &         "Fraction "//clnsurf(nsrf), "1", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
            ENDIF

           IF (flag_taux_sol(iff)<=lev_files(iff)) THEN
             call histdef(nid_files(iff), "taux_"//clnsurf(nsrf), &
     &         "Zonal wind stress"//clnsurf(nsrf), "Pa", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
           ENDIF

           IF (flag_tauy_sol(iff)<=lev_files(iff)) THEN           
             call histdef(nid_files(iff), "tauy_"//clnsurf(nsrf), &
     &         "Meridional wind stress "//clnsurf(nsrf), "Pa", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
           ENDIF

          IF (flag_tsol_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "tsol_"//clnsurf(nsrf), &
     &         "Temperature "//clnsurf(nsrf), "K", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
          ENDIF

          IF (flag_u10m_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "u10m_"//clnsurf(nsrf), &
     &         "Vent Zonal 10m "//clnsurf(nsrf), "m/s", &
     &          iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &          type_ecri(iff), zstophy,zout)
          ENDIF

          IF (flag_v10m_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "v10m_"//clnsurf(nsrf), &
     &         "Vent meredien 10m "//clnsurf(nsrf), "m/s", &
     &          iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &          type_ecri(iff), zstophy,zout)
          ENDIF
 
          IF (flag_t2m_sol(iff)<=lev_files(iff)) THEN
            call histdef(nid_files(iff), "t2m_"//clnsurf(nsrf), &
     &            "Temp 2m "//clnsurf(nsrf), "K", &
     &            iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &            type_ecri(iff), zstophy,zout)
          ENDIF

          IF (flag_sens_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "sens_"//clnsurf(nsrf), &
     &         "Sensible heat flux "//clnsurf(nsrf), "W/m2", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
          ENDIF

          IF (flag_lat_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "lat_"//clnsurf(nsrf), &
     &         "Latent heat flux "//clnsurf(nsrf), "W/m2", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
          ENDIF

          IF (flag_flw_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "flw_"//clnsurf(nsrf), &
     &         "LW "//clnsurf(nsrf), "W/m2", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
         ENDIF

          IF (flag_fsw_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "fsw_"//clnsurf(nsrf), &
     &         "SW "//clnsurf(nsrf), "W/m2", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
         ENDIF

          IF (flag_wbils_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "wbils_"//clnsurf(nsrf), &
     &         "Bilan sol "//clnsurf(nsrf), "W/m2", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
         ENDIF

          IF (flag_wbilo_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "wbilo_"//clnsurf(nsrf), &
     &         "Bilan eau "//clnsurf(nsrf), "kg/(m2*s)", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
         ENDIF

         if (iflag_pbl>1 .and. lev_files(iff).gt.10 ) then
          IF (flag_tke_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "tke_"//clnsurf(nsrf), &
     &         "Max Turb. Kinetic Energy "//clnsurf(nsrf), "-", &
     &         iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &         type_ecri(iff), zstophy,zout)
          ENDIF

          IF (flag_tke_max_sol(iff)<=lev_files(iff)) THEN
           call histdef(nid_files(iff), "tke_max_"//clnsurf(nsrf), &
     &         "Max Turb. Kinetic Energy "//clnsurf(nsrf), "-", &
     &         iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &         "t_max(X)", zstophy,zout)
          ENDIF
         endif

        END DO

        IF (flag_cdrm(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cdrm", &
     &                "Momentum drag coef.", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_cdrh(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cdrh", &
     &                "Heat drag coef.", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_cldl(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cldl", &
     &                "Low-level cloudiness", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_cldm(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cldm", &
     &                "Mid-level cloudiness", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_cldh(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cldh", &
     &                "High-level cloudiness", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_cldt(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cldt", &
     &                "Total cloudiness", "%", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_cldq(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"cldq", &
     &                "Cloud liquid water path","kg/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_lwp(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"lwp", &
     &                "Cloud water path","kg/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_iwp(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"iwp", &
     &                "Cloud ice water path","kg/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_ue(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ue", &
     &                "Zonal energy transport", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_ve(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ve", &
     &                "Merid energy transport", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_uq(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "uq", &
     &                "Zonal humidity transport", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_vq(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "vq", &
     &                "Merid humidity transport", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

      IF(iflag_con.GE.3) THEN ! sb
        IF (flag_cape(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cape", &
     &                "Conv avlbl pot ener", "J/kg", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_pbase(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "pbase", &
     &                "Cld base pressure", "mb", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_ptop(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ptop", &
     &                "Cld top pressure", "mb", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_fbase(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "fbase", &
     &                "Cld base mass flux", "kg/m2/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_prw(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "prw", &
     &                "Precipitable water", "kg/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

      ENDIF !iflag_con .GE. 3

        IF (flag_s_pblh(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_pblh", &
     &                "Boundary Layer Height", "m", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_pblt(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_pblt", &
     &               "t at Boundary Layer Height","K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_lclt(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_lcl", &
     &                "Condensation level", "m", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_capCL(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_capCL", &
     &               "Conv avlbl pot enerfor ABL", "J/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_oliqCLL(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_oliqCL", &
     &                "Liq Water in BL", "kg/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_cteiCL(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_cteiCL", &
     &               "Instability criteria(ABL)", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_therm(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "s_therm", &
     &                "Exces du thermique", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_trmb1(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_trmb1", &
     &                "deep_cape(HBTM2)", "J/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_trmb2(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_trmb2", &
     &                "inhibition (HBTM2)", "J/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_s_trmb3(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "s_trmb3", &
     &                "Point Omega (HBTM2)", "m", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
        ENDIF

! Champs interpolles sur des niveaux de pression
! iif=1 on ecrit u v w phi sur 850 700 500 200 au niv 1
! iif=2 on ecrit w et ph 500 seulement au niv 1
!        et u v sur 850 700 500 200
! iif=3 on ecrit ph a 500 seulement au niv 1
!      on ecrit u v t q a 850 700 500 200 au niv 3

       DO k=1, nlevSTD
         IF(k.GE.2.AND.k.LE.12) bb2=clevSTD(k)
         IF(k.GE.13.AND.k.LE.17) bb3=clevSTD(k)
         IF(bb2.EQ."850".OR.bb2.EQ."700".OR. &
     &      bb2.EQ."500".OR.bb2.EQ."200") THEN

        IF (flag_ulevsSTD(iff)<=lev_files(iff)) THEN
          CALL histdef(nid_files(iff), "u"//bb2, &
     &                 "Zonal wind "//bb2//"mb","m/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "inst(X)", zout,zout)
        ENDIF

        IF (flag_vlevsSTD(iff)<=lev_files(iff)) THEN
          CALL histdef(nid_files(iff), "v"//bb2, &
     &                 "Meridional wind "//bb2//"mb","m/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "inst(X)", zout,zout)
        ENDIF

        IF (flag_wlevsSTD(iff)<=lev_files(iff)) THEN
          CALL histdef(nid_files(iff), "w"//bb2, &
     &                 "Vertical wind "//bb2//"mb","m/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "inst(X)", zout,zout)
        ENDIF

        IF (flag_philevsSTD(iff)<=lev_files(iff)) THEN
          CALL histdef(nid_files(iff), "phi"//bb2, &
     &                 "Geopotential "//bb2//"mb","m", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "inst(X)", zout,zout)
        ENDIF

        IF (flag_qlevsSTD(iff)<=lev_files(iff)) THEN
          CALL histdef(nid_files(iff), "q"//bb2, &
     &               "Specific humidity "//bb2//"mb","kg/kg", &
     &               iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &               "inst(X)", zout,zout)
        ENDIF

        IF (flag_tlevsSTD(iff)<=lev_files(iff)) THEN
          CALL histdef(nid_files(iff), "t"//bb2, &
     &                 "Temperature "//bb2//"mb","K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "inst(X)", zout,zout)
        ENDIF

       ENDIF !(bb2.EQ."850".OR.bb2.EQ."700".OR.
       ENDDO

!IM diagnostiques flux ocean-atm ou ocean-glace de mer
!IM pour utilisation dans un modele de "slab" ocean

      IF (flag_fluxo(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff), "fluxo", &
     &              "Flux turbulents ocean-atmosphere", "W/m2", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
      ENDIF

      IF (flag_fluxg(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff), "fluxg", &
     &              "Flux turbulents ocean-glace de mer","W/m2", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
      ENDIF

      IF (flag_t_oce_sic(iff)<=lev_files(iff)) THEN
       CALL histdef(nid_files(iff), "t_oce_sic", &
     &              "Temp. mixte oce-sic","K", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
      ENDIF

       IF (OCEAN.EQ.'force ') THEN
        IF (flag_lmt_bils(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "lmt_bils", &
     &       "Bilan au sol atmosphere forcee", "W/m2", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
        ENDIF

       ELSE IF (OCEAN.EQ.'slab  ') THEN

        IF (flag_slab_bils(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "slab_bils", &
     &       "Bilan au sol Slab", "W/m2", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_tslab(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "tslab", "Slab SST ", "K", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_seaice(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"seaice","Slab seaice","kg/m2", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
        ENDIF

        IF (flag_siceh(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"siceh", &
     &               "Slab seaice height","m", &
     &              iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &              type_ecri(iff), zstophy,zout)
        ENDIF
       ENDIF

      IF (flag_weakinv(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "weakinv", &
     &            "Weak inversion", "-", &
     &            iim,jjmp1,nhori, 1,1,1, -99, 32, &
     &            type_ecri(iff), zstophy,zout)
      ENDIF

      IF (flag_dthmin(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dthmin", &
     &            "dTheta mini", "K/m", &
     &            iim,jjmp1,nhori, 1,1,1, -99, 32, &
     &            type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_meantaucld(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"meantaucld", &
     &                 "ISCCP mean cloud optical thickness","1", &
     &                 iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                 type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_cldtau(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"cldtau", &
     &                 "Cloud optical thickness","1", &
     &                 iim,jj_nb,nhori, klev,1,klev, nvert, 32, &
     &                 type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_cldemi(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"cldemi", &
     &			"Cloud optical emissivity","1", &
     &                 iim,jj_nb,nhori, klev,1,klev, nvert, 32, &
     &                 type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_rh2m(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "rh2m", &
     &			"Relative humidity at 2m", "%", &
     &                 iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                 type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_qsat2m(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "qsat2m", &
     &			"Saturant humidity at 2m", "%", &
     &                 iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                 type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_tpot(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "tpot", &
     &                "Surface air potential temperature", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_tpote(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "tpote", &
     &        "Surface air equivalent potential temperature", "K", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWnetOR(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWnetOR", &
     &                "Sfce net SW radiation OR", "W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_SWdownOR(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "SWdownOR", &
     &                "Sfce incident SW radiation OR", "W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_LWdownOR(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "LWdownOR", &
     &                "Sfce incident LW radiation OR", "W/m2", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_snowl(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "snowl", &
     &              "Solid Large-scale Precip.","kg/(m2*s)", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_cape_max(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "cape_max", "CAPE max.", &
     &                "J/kg", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                't_max(X)', zstophy,zout)
      ENDIF

       IF (flag_solldown(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "solldown", &
     &			"Down. IR rad. at surface", &
     &                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtsvdfo(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "dtsvdfo", &
     &			"Boundary-layer dTs(o)", &
     &               "K/s", iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &               type_ecri(iff), zout,zout)
      ENDIF

       IF (flag_dtsvdft(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "dtsvdft", &
     &			"Boundary-layer dTs(t)", "K/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zout,zout)
      ENDIF

       IF (flag_dtsvdfg(iff)<=lev_files(iff)) THEN
      CALL histdef(nid_files(iff), "dtsvdfg", &
     &			"Boundary-layer dTs(g)", "K/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zout,zout)
      ENDIF

       IF (flag_dtsvdfi(iff)<=lev_files(iff)) THEN
      CALL histdef(nid_files(iff), "dtsvdfi", &
     &			"Boundary-layer dTs(g)", "K/s", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zout,zout)
      ENDIF

       IF (flag_rugs(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "rugs", "rugosity", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                "inst(X)", zout,zout)
      ENDIF

! Champs 3D:

       IF (flag_lwcon(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"lwcon", &
     &                 "Cloud liquid water content","kg/kg", &
     &                iim,jj_nb,nhori, klev,1,klev, nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_iwcon(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"iwcon", &
     &                "Cloud ice water content","kg/kg", &
     &                iim,jj_nb,nhori, klev,1,klev, nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_temp(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"temp","Air temperature","K", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_ovap(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ovap", &
     &			"Specific humidity","kg/kg", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF


       IF (flag_geop(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "geop", &
     &			"Geopotential height", "m2/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_vitu(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "vitu", "Zonal wind", "m/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_vitv(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"vitv","Meridional wind","m/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_vitw(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"vitw","Vertical wind","m/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_pres(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "pres", "Air pressure", "Pa", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_rneb(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "rneb", "Cloud fraction", "-", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_rnebcon(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "rnebcon", &
     &		      "Convective Cloud Fraction", "-", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_rhum(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "rhum", "Relative humidity", "-", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_ozone(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ozone", &
     &			"Ozone concentration", "ppmv", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_upwd(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "upwd", &
     &			"saturated updraft", "kg/m2/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtphy(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtphy", "Physics dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqphy(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dqphy", &
     &			"Physics dQ", "(kg/kg)/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

        DO nsrf=1, nbsrf
          IF (flag_albe_sol(iff)<=lev_files(iff)) THEN 
           call histdef(nid_files(iff), "albe_"//clnsurf(nsrf), &
     &          "Albedo surf. "//clnsurf(nsrf), "-", &
     &          iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &          type_ecri(iff), zstophy,zout)
        ENDIF

          IF (flag_rugs_sol(iff)<=lev_files(iff)) THEN  
           call histdef(nid_files(iff), "rugs_"//clnsurf(nsrf), &
     &          "Latent heat flux "//clnsurf(nsrf), "W/m2", &
     &         iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &         type_ecri(iff), zstophy,zout)
       ENDIF

        IF (flag_ages_sol(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), &
     &		"ages_"//clnsurf(nsrf), "Snow age","day", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
       ENDIF

         ENDDO !nsrf=1, nbsrf

       IF (flag_albs(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"albs","Surface albedo","-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_albslw(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"albslw", &
     & 			"Surface albedo LW", "-", &
     &                iim,jj_nb,nhori, 1,1,1, -99, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

!FH Sorties pour la couche limite
      if (iflag_pbl>1) then
       IF (flag_tke(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "tke","TKE","m2/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_tke_max(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "tke_max","TKE max","m2/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                "t_max(X)", zstophy,zout)
      ENDIF
      endif

       IF (flag_kz(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "kz","Kz melange","m2/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_kz_max(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "kz_max", &
     &			"Kz melange max","m2/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                "t_max(X)", zstophy,zout)
      ENDIF

       IF (flag_clwcon(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "clwcon", &
     &                "Convective Cloud Liquid water content", &
     &                 "kg/kg", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_Ma(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"Ma", &
     &			"undilute adiab updraft","kg/m2/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dnwd(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dnwd", &
     &			"saturated downdraft","kg/m2/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dnwd0(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dnwd0", &
     &			"unsat. downdraft", "kg/m2/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtdyn(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"dtdyn","Dynamics dT","K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqdyn(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dqdyn", &
     &			"Dynamics dQ", "(kg/kg)/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtcon(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"dtcon","Convection dT","K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_ducon(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff),"ducon","Convection du","m/s2", &
     &               iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &               type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqcon(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dqcon", &
     &			"Convection dQ", "(kg/kg)/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtlsc(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtlsc", &
     &			"Condensation dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtlschr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtlschr", &
     &                "Large-scale condensational heating rate", &
     &                "K/s",iim,jj_nb, nhori, klev,1,klev,nvert, &
     &                 32,type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqlsc(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dqlsc", &
     &	              "Condensation dQ", "(kg/kg)/s", &
     &               iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtvdf(iff)<=lev_files(iff)) THEN
        CALL histdef(nid_files(iff), "dtvdf", &
     &                "Boundary-layer dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqvdf(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dqvdf", &
     &                "Boundary-layer dQ","(kg/kg)/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dteva(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dteva", &
     &			"Reevaporation dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqeva(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dqeva", &
     &			"Reevaporation dQ","(kg/kg)/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_ptconv(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ptconv", &
     &			"POINTS CONVECTIFS"," ", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_ratqs(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "ratqs", "RATQS"," ", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtthe(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtthe", &
     &			"Dry adjust. dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqthe(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"dqthe", &
     &                "Dry adjust. dQ","(kg/kg)/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtajs(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtajs", &
     &			"Dry adjust. dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dqajs(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"dqajs", &
     &			"Dry adjust. dQ","(kg/kg)/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtswr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtswr", &
     & 			"SW radiation dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtsw0(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtsw0", &
     &			"CS SW radiation dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtlwr(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtlwr", &
     &			"LW radiation dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtlw0(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff),"dtlw0", &
     &			"CS LW radiation dT","K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dtec(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dtec", &
     &			"Cinetic dissip dT", "K/s", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_duvdf(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "duvdf", &
     &			"Boundary-layer dU", "m/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dvvdf(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dvvdf", &
     & 		"Boundary-layer dV", "m/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

         IF (ok_orodr) THEN
       IF (flag_duoro(iff)<=lev_files(iff)) THEN 
         CALL histdef(nid_files(iff), "duoro", &
     &			"Orography dU", "m/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

       IF (flag_dvoro(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dvoro", &
     &			"Orography dV", "m/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
      ENDIF

         ENDIF

      IF (ok_orolf) THEN
       IF (flag_dulif(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dulif", &
     &                "Orography dU", "m/s2", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
       ENDIF

       IF (flag_dvlif(iff)<=lev_files(iff)) THEN
         CALL histdef(nid_files(iff), "dvlif", &
     &			"Orography dV", "m/s2", &
     &               iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
       ENDIF
      ENDIF

          IF (flag_trac(iff)<=lev_files(iff)) THEN
           if (nqmax>=3) THEN
             DO iq=3,nqmax
              iiq=niadv(iq)
         CALL histdef(nid_files(iff),tnom(iq),ttext(iiq), "-", &
     &                iim,jj_nb,nhori, klev,1,klev,nvert, 32, &
     &                type_ecri(iff), zstophy,zout)
             ENDDO
           endif
         ENDIF

        CALL histend(nid_files(iff))

         ndex2d = 0
         ndex3d = 0

         ENDIF ! clef_files

         ENDDO ! 
      end subroutine phys_output_open

END MODULE phys_output_mod

