!
! $Header$
!
c
      SUBROUTINE phyredem (fichnom,dtime,radpas,ocean,
     .           rlat_p,rlon_p, pctsrf_p,tsol_p,
     .           alb1_p, alb2_p,
     .           rain_fall_p, snow_fall_p,solsw_p, sollw_p,
     .           radsol_p,zmea_p,zstd_p,zsig_p,
     .           zgam_p,zthe_p,zpic_p,zval_p,rugsrel_p,
     .           t_ancien_p, q_ancien_p, rnebcon_p, ratqs_p, clwcon_p,
     .           pbl_tke_p)

      USE dimphy
      USE mod_grid_phy_lmdz
      USE mod_phys_lmdz_para
      USE ocean_slab_mod,   ONLY : ocean_slab_final
      USE fonte_neige_mod,  ONLY : fonte_neige_final
      USE pbl_surface_mod,  ONLY : pbl_surface_final

      IMPLICIT none
c======================================================================
c Auteur(s) Z.X. Li (LMD/CNRS) date: 19930818
c Objet: Ecriture de l'etat de redemarrage pour la physique
c======================================================================
#include "netcdf.inc"
#include "indicesol.h"
#include "dimsoil.h"
#include "clesphys.h"
#include "control.h"
#include "temps.h"
#include "thermcell.h"
#include "compbl.h"
c======================================================================
      CHARACTER*(*) fichnom
      REAL dtime
      INTEGER radpas
      REAL rlat_p(klon), rlon_p(klon)
      REAL tsol_p(klon,nbsrf)
      REAL pbl_tke_p(klon,klev,nbsrf)
      REAL tsoil_p(klon,nsoilmx,nbsrf)
      CHARACTER*6 ocean
cIM "slab" ocean
      REAL tslab_p(klon), seaice_p(klon)
      REAL qsurf_p(klon,nbsrf)
      REAL qsol_p(klon)
      REAL snow_p(klon,nbsrf)
      REAL alb1_p(klon,nbsrf)   ! albedo in visible SW interval  
      REAL alb2_p(klon,nbsrf)   ! albedo in near IR interval
      REAL evap_p(klon,nbsrf)
      REAL rain_fall_p(klon)
      REAL snow_fall_p(klon)
      real solsw_p(klon)
      real sollw_p(klon)
      real fder_p(klon)
      REAL radsol_p(klon)
      REAL frugs_p(klon,nbsrf)
      REAL agesno_p(klon,nbsrf)
      REAL zmea_p(klon)
      REAL zstd_p(klon)
      REAL zsig_p(klon)
      REAL zgam_p(klon)
      REAL zthe_p(klon)
      REAL zpic_p(klon)
      REAL zval_p(klon)
      REAL rugsrel_p(klon)
      REAL pctsrf_p(klon, nbsrf)
      REAL t_ancien_p(klon,klev), q_ancien_p(klon,klev)
      real clwcon_p(klon,klev),rnebcon_p(klon,klev),ratqs_p(klon,klev)
      REAL run_off_lic_0_p(klon)
      
      REAL rlat(klon_glo), rlon(klon_glo)
      REAL tsol(klon_glo,nbsrf)
      REAL pbl_tke(klon_glo,klev,nbsrf)
      REAL tsoil(klon_glo,nsoilmx,nbsrf)
      REAL tslab(klon_glo), seaice(klon_glo)
      REAL qsurf(klon_glo,nbsrf)
      REAL qsol(klon_glo)
      REAL snow(klon_glo,nbsrf)
      REAL alb1(klon_glo,nbsrf)
      REAL alb2(klon_glo,nbsrf)
      REAL evap(klon_glo,nbsrf)
      REAL rain_fall(klon_glo)
      REAL snow_fall(klon_glo)
      real solsw(klon_glo)
      real sollw(klon_glo)
      real fder(klon_glo)
      REAL radsol(klon_glo)
      REAL frugs(klon_glo,nbsrf)
      REAL agesno(klon_glo,nbsrf)
      REAL zmea(klon_glo)
      REAL zstd(klon_glo)
      REAL zsig(klon_glo)
      REAL zgam(klon_glo)
      REAL zthe(klon_glo)
      REAL zpic(klon_glo)
      REAL zval(klon_glo)
      REAL rugsrel(klon_glo)
      REAL pctsrf(klon_glo, nbsrf)
      REAL t_ancien(klon_glo,klev), q_ancien(klon_glo,klev)
      REAL clwcon(klon_glo,klev)
      REAL rnebcon(klon_glo,klev) 
      REAL ratqs(klon_glo,klev)
      REAL run_off_lic_0(klon_glo)
      REAL masq(klon_glo)
c
      INTEGER nid, nvarid, idim1, idim2, idim3
      INTEGER ierr
      INTEGER length
      PARAMETER (length=100)
      REAL tab_cntrl(length)
c
      INTEGER isoil, nsrf
      CHARACTER*7 str7
      CHARACTER*2 str2

c======================================================================
c 
c Get variables which will be written to restart file from module 
c pbl_surface_mod
      CALL pbl_surface_final(qsol_p, fder_p, snow_p, qsurf_p, 
     $     evap_p, frugs_p, agesno_p, tsoil_p)

c Get a variable calculated in module fonte_neige_mod
      CALL fonte_neige_final(run_off_lic_0_p)

c If slab ocean then get 2 varaibles from module ocean_slab_mod
      IF ( ocean == 'slab' ) THEN
         CALL ocean_slab_final(tslab_p, seaice_p)
      ELSE 
         tslab_p(:)  = 0.0
         seaice_p(:) = 0.0
      ENDIF      

c======================================================================

      call Gather( rlat_p,rlat)
      call Gather( rlon_p,rlon)
      call Gather( tsol_p,tsol)
      call Gather( pbl_tke_p,pbl_tke)
      call Gather( tsoil_p,tsoil)
      call Gather( tslab_p,tslab)
      call Gather( seaice_p,seaice)
      call Gather( qsurf_p,qsurf)
      call Gather( qsol_p,qsol)
      call Gather( snow_p,snow)
      call Gather( alb1_p,alb1)
      call Gather( alb2_p,alb2)
      call Gather( evap_p,evap)
      call Gather( radsol_p,radsol)
      call Gather( rain_fall_p,rain_fall)
      call Gather( snow_fall_p,snow_fall)
      call Gather( sollw_p,sollw)
      call Gather( solsw_p,solsw)
      call Gather( fder_p,fder)
      call Gather( frugs_p,frugs)
      call Gather( agesno_p,agesno)
      call Gather( zmea_p,zmea)
      call Gather( zstd_p,zstd)
      call Gather( zsig_p,zsig)
      call Gather( zgam_p,zgam)
      call Gather( zthe_p,zthe)
      call Gather( zpic_p,zpic)
      call Gather( zval_p,zval)
      call Gather( rugsrel_p,rugsrel)
      call Gather( pctsrf_p,pctsrf)
      call Gather( run_off_lic_0_p,run_off_lic_0)
      call Gather( t_ancien_p,t_ancien)
      call Gather( q_ancien_p,q_ancien)
      call Gather( rnebcon_p,rnebcon)
      call Gather( clwcon_p,clwcon)
      call Gather( ratqs_p,ratqs)
      call Gather( zmasq,masq)
      
c$OMP MASTER
      IF (is_mpi_root) THEN
      
      ierr = NF_CREATE(fichnom, NF_CLOBBER, nid)
      IF (ierr.NE.NF_NOERR) THEN
        write(6,*)' Pb d''ouverture du fichier '//fichnom
        write(6,*)' ierr = ', ierr
        CALL ABORT
      ENDIF
c
      ierr = NF_PUT_ATT_TEXT (nid, NF_GLOBAL, "title", 28,
     .                       "Fichier redemmarage physique")
c
      ierr = NF_DEF_DIM (nid, "index", length, idim1)
      ierr = NF_DEF_DIM (nid, "points_physiques", klon_glo, idim2)
      ierr = NF_DEF_DIM (nid, "horizon_vertical", klon_glo*klev, idim3)
c
      ierr = NF_ENDDEF(nid)
c
      DO ierr = 1, length
         tab_cntrl(ierr) = 0.0
      ENDDO
      tab_cntrl(1) = dtime
      tab_cntrl(2) = radpas
      tab_cntrl(3) = co2_ppm
      tab_cntrl(4) = solaire
      tab_cntrl(5) = iflag_con
      tab_cntrl(6) = nbapp_rad

      IF( cycle_diurne ) tab_cntrl( 7 ) = 1.
      IF(   soil_model ) tab_cntrl( 8 ) = 1.
      IF(     new_oliq ) tab_cntrl( 9 ) = 1.
      IF(     ok_orodr ) tab_cntrl(10 ) = 1.
      IF(     ok_orolf ) tab_cntrl(11 ) = 1.

      tab_cntrl(13) = day_end
      tab_cntrl(14) = annee_ref
      tab_cntrl(15) = itau_phy
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "controle", NF_DOUBLE, 1, idim1,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "controle", NF_FLOAT, 1, idim1,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Parametres de controle")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tab_cntrl)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,tab_cntrl)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "longitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "longitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Longitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlon)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlon)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "latitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "latitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 31,
     .                        "Latitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlat)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlat)
#endif
c
C PB ajout du masque terre/mer
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "masque", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "masque", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 16,
     .                        "masque terre mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,masq)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,masq)
#endif      
c BP ajout des fraction de chaque sous-surface
C
C 1. fraction de terre 
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FTER", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FTER", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 21,
     .                        "fraction de continent")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon_glo, is_ter))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon_glo, is_ter))
#endif
C 
C 2. Fraction de glace de terre
C 
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FLIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FLIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 24,
     .                        "fraction glace de terre")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon_glo,is_lic))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon_glo, is_lic))
#endif
C
C 3. fraction ocean
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FOCE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FOCE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 14,
     .                        "fraction ocean")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon_glo, is_oce))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon_glo, is_oce))
#endif
C
C 4. Fraction glace de mer
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FSIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FSIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 18,
     .                        "fraction glace mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon_glo, is_sic))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon_glo, is_sic))
#endif
C
C
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "TS"//str2, NF_DOUBLE, 1, idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "TS"//str2, NF_FLOAT, 1, idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Temperature de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsol(1,nsrf))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsol(1,nsrf))
#endif
      ENDDO
c
      DO nsrf = 1, nbsrf
      DO isoil=1, nsoilmx
        IF (isoil.LE.99 .AND. nsrf.LE.99) THEN
        WRITE(str7,'(i2.2,"srf",i2.2)') isoil,nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "Tsoil"//str7,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "Tsoil"//str7,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 29,
     .                        "Temperature du sol No."//str7)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de couches"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsoil(1,isoil,nsrf))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsoil(1,isoil,nsrf))
#endif
      ENDDO
      ENDDO
c
cIM "slab" ocean
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "TSLAB", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "TSLAB", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 33,
     .                        "Ecart de la SST (pour slab-ocean)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tslab)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,tslab)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "SEAICE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "SEAICE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 33,
     .                        "Glace de mer kg/m2 (pour slab-ocean)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,seaice)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,seaice)
#endif
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"QS"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"QS"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 25,
     .                        "Humidite de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,qsurf(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,qsurf(1,nsrf))
#endif
      END DO
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid,"QSOL",NF_DOUBLE,1,idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid,"QSOL",NF_FLOAT,1,idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 20,
     .    "Eau dans le sol (mm)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,qsol)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,qsol)
#endif
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"ALBE"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"ALBE"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "albedo de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,alb1(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,alb1(1,nsrf))
#endif
      ENDDO

        DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"ALBLW"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"ALBLW"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "albedo LW de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,alb2(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,alb2(1,nsrf))
#endif
      ENDDO
c
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"EVAP"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"EVAP"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Evaporation de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,evap(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,evap(1,nsrf))
#endif
      ENDDO

c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"SNOW"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"SNOW"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Neige de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,snow(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,snow(1,nsrf))
#endif
      ENDDO

c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RADS", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RADS", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Rayonnement net a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,radsol)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,radsol)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "solsw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "solsw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Rayonnement solaire a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,solsw)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,solsw)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "sollw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "sollw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 27,
     .                        "Rayonnement IF a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,sollw)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,sollw)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "fder", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "fder", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 14,
     .                        "Derive de flux")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,fder)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,fder)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "rain_f", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "rain_f", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 21,
     .                        "precipitation liquide")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rain_fall)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rain_fall)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "snow_f", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "snow_f", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 20,
     .                        "precipitation solide")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,snow_fall)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,snow_fall)
#endif
c
       endif
c$OMP END MASTER
cc ----> necessaire pour eviter bug openMP sur SX6
c$OMP MASTER
      if (is_mpi_root) then
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"RUG"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"RUG"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "rugosite de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,frugs(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,frugs(1,nsrf))
#endif
      ENDDO
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
            WRITE(str2,'(i2.2)') nsrf
            ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
            ierr = NF_DEF_VAR (nid,"AGESNO"//str2,NF_DOUBLE,1,idim2
     $          ,nvarid)
#else
            ierr = NF_DEF_VAR (nid,"AGESNO"//str2,NF_FLOAT,1,idim2
     $          ,nvarid)
#endif
            ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 15,
     .                        "Age de la neige surface No."//str2)
            ierr = NF_ENDDEF(nid)
        ELSE
            PRINT*, "Trop de sous-mailles"
            CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,agesno(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,agesno(1,nsrf))
#endif
      ENDDO
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZMEA", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZMEA", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zmea)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zmea)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZSTD", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZSTD", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zstd)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zstd)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZSIG", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZSIG", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zsig)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zsig)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZGAM", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZGAM", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zgam)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zgam)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZTHE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZTHE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zthe)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zthe)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZPIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZPIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zpic)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zpic)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZVAL", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZVAL", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zval)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zval)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RUGSREL", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RUGSREL", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rugsrel)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rugsrel)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_DOUBLE, 1, idim3,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_FLOAT, 1, idim3,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,t_ancien)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,t_ancien)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "QANCIEN", NF_DOUBLE, 1, idim3,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "QANCIEN", NF_FLOAT, 1, idim3,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,q_ancien)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,q_ancien)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RUGMER", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RUGMER", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Longueur de rugosite sur mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,frugs(1,is_oce))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,frugs(1,is_oce))
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "CLWCON", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "CLWCON", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Eau liquide convective")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,clwcon)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,clwcon)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RNEBCON", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RNEBCON", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Nebulosite convective")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rnebcon)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rnebcon)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RATQS", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RATQS", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Ratqs")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,ratqs)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,ratqs)
#endif
c
c run_off_lic_0
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr=NF_DEF_VAR(nid,"RUNOFFLIC0",NF_DOUBLE,1,idim2,nvarid)
#else
      ierr=NF_DEF_VAR(nid,"RUNOFFLIC0",NF_FLOAT, 1,idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Runofflic0")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,run_off_lic_0)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,run_off_lic_0)
#endif
c
c
!!!!!!!!!!!!!!!!!!!! DEB TKE PBL !!!!!!!!!!!!!!!!!!!!!!!!!
c
      IF (iflag_pbl>1) then
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
            WRITE(str2,'(i2.2)') nsrf
            ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
            ierr = NF_DEF_VAR (nid,"TKE"//str2,NF_DOUBLE,1,idim3
     $          ,nvarid)
#else
            ierr = NF_DEF_VAR (nid,"TKE"//str2,NF_FLOAT,1,idim3
     $          ,nvarid)
#endif
            ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 15,
     .                        "Energ. Cineti. Turb."//str2)
            ierr = NF_ENDDEF(nid)
        ELSE
            PRINT*, "Trop de sous-mailles"
            CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pbl_tke(:,:,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pbl_tke(:,:,nsrf))
#endif
      ENDDO
      ENDIF

!!!!!!!!!!!!!!!!!!!! FIN TKE PBL !!!!!!!!!!!!!!!!!!!!!!!!!
c
      ierr = NF_CLOSE(nid)
c
      endif   ! is_mpi_root
c$OMP END MASTER
      RETURN
      END
